/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 3.0.9
 *
 * This file is not intended to be easily readable and contains a number of
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG
 * interface file instead.
 * ----------------------------------------------------------------------------- */
#include <stdio.h>
#include <string.h>
#include <stddef.h>
#include <math.h> /* required for special case floating point output */

// Do not edit below this line
// end-of-default-includes


#define GL_GLEXT_PROTOTYPES
#include <stdint.h>
#include <GL/gl.h>
#include <GL/glext.h>

typedef enum{ NONE = -1, GFORTH = 0, SWIFTFORTH, VFX } SwigTargetSystem;
SwigTargetSystem swigTargetSystem = NONE;

unsigned char swigPrintStackComments = 1;

/* comments */
void swigNewline()
{
	printf( "\n" );
}

void swigComment( char *comment )
{
	printf( "\\ %s", comment );
}

/* generic print */
void swigPrint( char* gforth, char *swiftForth, char *vfx )
{
	if( swigTargetSystem == GFORTH )
		printf( "%s", gforth );
	else if( swigTargetSystem == SWIFTFORTH )
		printf( "%s", swiftForth );
	else if( swigTargetSystem == VFX )
		printf( "%s", vfx );
	printf( "\n" );
}
void swigPrintSystem( SwigTargetSystem targetSystem, char *text )
{
	if( targetSystem == swigTargetSystem )
	    printf( "%s\n", text );
}

/* constants */
void swigIntConstant( long constant, char *name )
{
	printf( "#%ld\tconstant %s\n", constant, name );
}

void swigUnsignedIntConstant( unsigned long constant, char *name )
{
	printf( "#%lu\tconstant %s\n", constant, name );
}

void swigLongConstant( long long constant, char *name )
{
	printf( "#%lld.\t2constant %s\n", constant, name );
}

void swigUnsignedLongConstant( unsigned long long constant, char *name )
{
	printf( "#%llu.\t2constant %s\n", constant, name );
}

void swigFloatConstant( double constant, char *name )
{
	char buffer[128];
	sprintf( buffer, "%f", constant );

	/* if the constant contains no exponent, add one */
	char *s;
	for( s = buffer; *s != 0; s++ )
		if( *s == 'e' || *s == 'E' )
			break;

	/* exponent found */
	if( *s != 0 )
		printf( "%s\tfconstant %s\n", buffer, name );
	/* no exponent */
	else {
		/* special class? */
		int class = fpclassify( constant );
		if( class == FP_INFINITE )
			printf( "%sInf\tfconstant %s\n", constant < 0.0f ? "-" : "+", name );
		else if( class == FP_NAN )
			printf( "NaN\tfconstant %s\n", name );
		else
			/* treat as generic float */
			printf( "%se0\tfconstant %s\n", buffer, name );
        }
}

void swigStringConstant( char* constant, char *name )
{
	char c;
	printf( ": %s s\\\" ", name );
	while(( c = *constant++ ))
	{
		switch(c)
		{
			case '\b': printf( "\\b" ); break;
			case '\n': printf( "\\n" ); break;
			case '\f': printf( "\\f" ); break;
			case '\r': printf( "\\r" ); break;
			case '\t': printf( "\\t" ); break;
			case '"' : printf( "\\q" ); break;
			default:
				if(c < 0x20)
					printf("\\x%02x", c);
				else
					printf("%c", c); break;
		}
	}
	printf(	"\" ;\n" );
}

/* structs */
void swigStructField( char *name, size_t offset, size_t size )
{
	printf( "\tdrop %zu %zu +field %s\n", offset, size, name );
}

/* functions */
void swigFunction( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	if( swigTargetSystem == GFORTH )
		printf( "%s", gforth );
	else if( swigTargetSystem == SWIFTFORTH )
		printf( "%s", swiftForth );
	else if( swigTargetSystem == VFX )
		printf( "%s", vfx );

	if( swigPrintStackComments )
		printf( "%s", stackComment );

	printf( "\n" );
}

/* function pointers */
void swigFunctionPointer( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	swigFunction( gforth, swiftForth, vfx, stackComment );
}

/* callbacks */
void swigCallback( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	swigFunction( gforth, swiftForth, vfx, stackComment );
}

void swigUsage( char **argv )
{
	fprintf( stderr, "Usage: %s [-gforth|-swiftforth|-vfx]\n", argv[0] );
}

int main( int argc, char **argv )
{
	int i;

	/* check arguments */
	for( i = 1; i < argc; i++ )
		if( strcmp( argv[i], "-gforth" ) == 0 )
			swigTargetSystem = GFORTH;
		else if( strcmp( argv[i], "-swiftforth" ) == 0 )
			swigTargetSystem = SWIFTFORTH;
		else if( strcmp( argv[i], "-vfx" ) == 0 )
			swigTargetSystem = VFX;

	if( swigTargetSystem == NONE )
	{
		fprintf( stderr, "Error: no target system specified\n" );
		swigUsage( argv );
		return 1;
	}

	/* primer */
	printf( "\\ This file has been generated using SWIG and fsi,\n"
		"\\ and is already platform dependent, search for the corresponding\n"
		"\\ fsi-file to compile it where no one has compiled it before ;)\n"
		"\\ Forth systems have their own own dynamic loader and don't need addional C-Code.\n"
		"\\ That's why this file will just print normal forth-code once compiled\n"
		"\\ and can be used directly with include or require.\n"
		"\\ As all comments are stripped during the compilation, please\n"
		"\\ insert the copyright notice of the original file here.\n"
	);



	swigNewline();

	swigComment("----===< prefix >===-----\n");

	swigPrint( "c-library gl\ns\" GL\" add-lib\n\\c #define GL_GLEXT_PROTOTYPES\n\\c #include <stdint.h>\n\\c #include <GL/gl.h>\n\\c #include <GL/glext.h>", "( none )", "( none )" );

	swigNewline();

	swigComment("----===< int constants >===-----\n");
	#ifdef GL_VERSION_1_1
		swigIntConstant( GL_VERSION_1_1, "GL_VERSION_1_1" );
	#endif
	#ifdef GL_VERSION_1_2
		swigIntConstant( GL_VERSION_1_2, "GL_VERSION_1_2" );
	#endif
	#ifdef GL_VERSION_1_3
		swigIntConstant( GL_VERSION_1_3, "GL_VERSION_1_3" );
	#endif
	#ifdef GL_ARB_imaging
		swigIntConstant( GL_ARB_imaging, "GL_ARB_imaging" );
	#endif
	#ifdef GL_FALSE
		swigIntConstant( GL_FALSE, "GL_FALSE" );
	#endif
	#ifdef GL_TRUE
		swigIntConstant( GL_TRUE, "GL_TRUE" );
	#endif
	#ifdef GL_BYTE
		swigIntConstant( GL_BYTE, "GL_BYTE" );
	#endif
	#ifdef GL_UNSIGNED_BYTE
		swigIntConstant( GL_UNSIGNED_BYTE, "GL_UNSIGNED_BYTE" );
	#endif
	#ifdef GL_SHORT
		swigIntConstant( GL_SHORT, "GL_SHORT" );
	#endif
	#ifdef GL_UNSIGNED_SHORT
		swigIntConstant( GL_UNSIGNED_SHORT, "GL_UNSIGNED_SHORT" );
	#endif
	#ifdef GL_INT
		swigIntConstant( GL_INT, "GL_INT" );
	#endif
	#ifdef GL_UNSIGNED_INT
		swigIntConstant( GL_UNSIGNED_INT, "GL_UNSIGNED_INT" );
	#endif
	#ifdef GL_FLOAT
		swigIntConstant( GL_FLOAT, "GL_FLOAT" );
	#endif
	#ifdef GL_2_BYTES
		swigIntConstant( GL_2_BYTES, "GL_2_BYTES" );
	#endif
	#ifdef GL_3_BYTES
		swigIntConstant( GL_3_BYTES, "GL_3_BYTES" );
	#endif
	#ifdef GL_4_BYTES
		swigIntConstant( GL_4_BYTES, "GL_4_BYTES" );
	#endif
	#ifdef GL_DOUBLE
		swigIntConstant( GL_DOUBLE, "GL_DOUBLE" );
	#endif
	#ifdef GL_POINTS
		swigIntConstant( GL_POINTS, "GL_POINTS" );
	#endif
	#ifdef GL_LINES
		swigIntConstant( GL_LINES, "GL_LINES" );
	#endif
	#ifdef GL_LINE_LOOP
		swigIntConstant( GL_LINE_LOOP, "GL_LINE_LOOP" );
	#endif
	#ifdef GL_LINE_STRIP
		swigIntConstant( GL_LINE_STRIP, "GL_LINE_STRIP" );
	#endif
	#ifdef GL_TRIANGLES
		swigIntConstant( GL_TRIANGLES, "GL_TRIANGLES" );
	#endif
	#ifdef GL_TRIANGLE_STRIP
		swigIntConstant( GL_TRIANGLE_STRIP, "GL_TRIANGLE_STRIP" );
	#endif
	#ifdef GL_TRIANGLE_FAN
		swigIntConstant( GL_TRIANGLE_FAN, "GL_TRIANGLE_FAN" );
	#endif
	#ifdef GL_QUADS
		swigIntConstant( GL_QUADS, "GL_QUADS" );
	#endif
	#ifdef GL_QUAD_STRIP
		swigIntConstant( GL_QUAD_STRIP, "GL_QUAD_STRIP" );
	#endif
	#ifdef GL_POLYGON
		swigIntConstant( GL_POLYGON, "GL_POLYGON" );
	#endif
	#ifdef GL_VERTEX_ARRAY
		swigIntConstant( GL_VERTEX_ARRAY, "GL_VERTEX_ARRAY" );
	#endif
	#ifdef GL_NORMAL_ARRAY
		swigIntConstant( GL_NORMAL_ARRAY, "GL_NORMAL_ARRAY" );
	#endif
	#ifdef GL_COLOR_ARRAY
		swigIntConstant( GL_COLOR_ARRAY, "GL_COLOR_ARRAY" );
	#endif
	#ifdef GL_INDEX_ARRAY
		swigIntConstant( GL_INDEX_ARRAY, "GL_INDEX_ARRAY" );
	#endif
	#ifdef GL_TEXTURE_COORD_ARRAY
		swigIntConstant( GL_TEXTURE_COORD_ARRAY, "GL_TEXTURE_COORD_ARRAY" );
	#endif
	#ifdef GL_EDGE_FLAG_ARRAY
		swigIntConstant( GL_EDGE_FLAG_ARRAY, "GL_EDGE_FLAG_ARRAY" );
	#endif
	#ifdef GL_VERTEX_ARRAY_SIZE
		swigIntConstant( GL_VERTEX_ARRAY_SIZE, "GL_VERTEX_ARRAY_SIZE" );
	#endif
	#ifdef GL_VERTEX_ARRAY_TYPE
		swigIntConstant( GL_VERTEX_ARRAY_TYPE, "GL_VERTEX_ARRAY_TYPE" );
	#endif
	#ifdef GL_VERTEX_ARRAY_STRIDE
		swigIntConstant( GL_VERTEX_ARRAY_STRIDE, "GL_VERTEX_ARRAY_STRIDE" );
	#endif
	#ifdef GL_NORMAL_ARRAY_TYPE
		swigIntConstant( GL_NORMAL_ARRAY_TYPE, "GL_NORMAL_ARRAY_TYPE" );
	#endif
	#ifdef GL_NORMAL_ARRAY_STRIDE
		swigIntConstant( GL_NORMAL_ARRAY_STRIDE, "GL_NORMAL_ARRAY_STRIDE" );
	#endif
	#ifdef GL_COLOR_ARRAY_SIZE
		swigIntConstant( GL_COLOR_ARRAY_SIZE, "GL_COLOR_ARRAY_SIZE" );
	#endif
	#ifdef GL_COLOR_ARRAY_TYPE
		swigIntConstant( GL_COLOR_ARRAY_TYPE, "GL_COLOR_ARRAY_TYPE" );
	#endif
	#ifdef GL_COLOR_ARRAY_STRIDE
		swigIntConstant( GL_COLOR_ARRAY_STRIDE, "GL_COLOR_ARRAY_STRIDE" );
	#endif
	#ifdef GL_INDEX_ARRAY_TYPE
		swigIntConstant( GL_INDEX_ARRAY_TYPE, "GL_INDEX_ARRAY_TYPE" );
	#endif
	#ifdef GL_INDEX_ARRAY_STRIDE
		swigIntConstant( GL_INDEX_ARRAY_STRIDE, "GL_INDEX_ARRAY_STRIDE" );
	#endif
	#ifdef GL_TEXTURE_COORD_ARRAY_SIZE
		swigIntConstant( GL_TEXTURE_COORD_ARRAY_SIZE, "GL_TEXTURE_COORD_ARRAY_SIZE" );
	#endif
	#ifdef GL_TEXTURE_COORD_ARRAY_TYPE
		swigIntConstant( GL_TEXTURE_COORD_ARRAY_TYPE, "GL_TEXTURE_COORD_ARRAY_TYPE" );
	#endif
	#ifdef GL_TEXTURE_COORD_ARRAY_STRIDE
		swigIntConstant( GL_TEXTURE_COORD_ARRAY_STRIDE, "GL_TEXTURE_COORD_ARRAY_STRIDE" );
	#endif
	#ifdef GL_EDGE_FLAG_ARRAY_STRIDE
		swigIntConstant( GL_EDGE_FLAG_ARRAY_STRIDE, "GL_EDGE_FLAG_ARRAY_STRIDE" );
	#endif
	#ifdef GL_VERTEX_ARRAY_POINTER
		swigIntConstant( GL_VERTEX_ARRAY_POINTER, "GL_VERTEX_ARRAY_POINTER" );
	#endif
	#ifdef GL_NORMAL_ARRAY_POINTER
		swigIntConstant( GL_NORMAL_ARRAY_POINTER, "GL_NORMAL_ARRAY_POINTER" );
	#endif
	#ifdef GL_COLOR_ARRAY_POINTER
		swigIntConstant( GL_COLOR_ARRAY_POINTER, "GL_COLOR_ARRAY_POINTER" );
	#endif
	#ifdef GL_INDEX_ARRAY_POINTER
		swigIntConstant( GL_INDEX_ARRAY_POINTER, "GL_INDEX_ARRAY_POINTER" );
	#endif
	#ifdef GL_TEXTURE_COORD_ARRAY_POINTER
		swigIntConstant( GL_TEXTURE_COORD_ARRAY_POINTER, "GL_TEXTURE_COORD_ARRAY_POINTER" );
	#endif
	#ifdef GL_EDGE_FLAG_ARRAY_POINTER
		swigIntConstant( GL_EDGE_FLAG_ARRAY_POINTER, "GL_EDGE_FLAG_ARRAY_POINTER" );
	#endif
	#ifdef GL_V2F
		swigIntConstant( GL_V2F, "GL_V2F" );
	#endif
	#ifdef GL_V3F
		swigIntConstant( GL_V3F, "GL_V3F" );
	#endif
	#ifdef GL_C4UB_V2F
		swigIntConstant( GL_C4UB_V2F, "GL_C4UB_V2F" );
	#endif
	#ifdef GL_C4UB_V3F
		swigIntConstant( GL_C4UB_V3F, "GL_C4UB_V3F" );
	#endif
	#ifdef GL_C3F_V3F
		swigIntConstant( GL_C3F_V3F, "GL_C3F_V3F" );
	#endif
	#ifdef GL_N3F_V3F
		swigIntConstant( GL_N3F_V3F, "GL_N3F_V3F" );
	#endif
	#ifdef GL_C4F_N3F_V3F
		swigIntConstant( GL_C4F_N3F_V3F, "GL_C4F_N3F_V3F" );
	#endif
	#ifdef GL_T2F_V3F
		swigIntConstant( GL_T2F_V3F, "GL_T2F_V3F" );
	#endif
	#ifdef GL_T4F_V4F
		swigIntConstant( GL_T4F_V4F, "GL_T4F_V4F" );
	#endif
	#ifdef GL_T2F_C4UB_V3F
		swigIntConstant( GL_T2F_C4UB_V3F, "GL_T2F_C4UB_V3F" );
	#endif
	#ifdef GL_T2F_C3F_V3F
		swigIntConstant( GL_T2F_C3F_V3F, "GL_T2F_C3F_V3F" );
	#endif
	#ifdef GL_T2F_N3F_V3F
		swigIntConstant( GL_T2F_N3F_V3F, "GL_T2F_N3F_V3F" );
	#endif
	#ifdef GL_T2F_C4F_N3F_V3F
		swigIntConstant( GL_T2F_C4F_N3F_V3F, "GL_T2F_C4F_N3F_V3F" );
	#endif
	#ifdef GL_T4F_C4F_N3F_V4F
		swigIntConstant( GL_T4F_C4F_N3F_V4F, "GL_T4F_C4F_N3F_V4F" );
	#endif
	#ifdef GL_MATRIX_MODE
		swigIntConstant( GL_MATRIX_MODE, "GL_MATRIX_MODE" );
	#endif
	#ifdef GL_MODELVIEW
		swigIntConstant( GL_MODELVIEW, "GL_MODELVIEW" );
	#endif
	#ifdef GL_PROJECTION
		swigIntConstant( GL_PROJECTION, "GL_PROJECTION" );
	#endif
	#ifdef GL_TEXTURE
		swigIntConstant( GL_TEXTURE, "GL_TEXTURE" );
	#endif
	#ifdef GL_POINT_SMOOTH
		swigIntConstant( GL_POINT_SMOOTH, "GL_POINT_SMOOTH" );
	#endif
	#ifdef GL_POINT_SIZE
		swigIntConstant( GL_POINT_SIZE, "GL_POINT_SIZE" );
	#endif
	#ifdef GL_POINT_SIZE_GRANULARITY
		swigIntConstant( GL_POINT_SIZE_GRANULARITY, "GL_POINT_SIZE_GRANULARITY" );
	#endif
	#ifdef GL_POINT_SIZE_RANGE
		swigIntConstant( GL_POINT_SIZE_RANGE, "GL_POINT_SIZE_RANGE" );
	#endif
	#ifdef GL_LINE_SMOOTH
		swigIntConstant( GL_LINE_SMOOTH, "GL_LINE_SMOOTH" );
	#endif
	#ifdef GL_LINE_STIPPLE
		swigIntConstant( GL_LINE_STIPPLE, "GL_LINE_STIPPLE" );
	#endif
	#ifdef GL_LINE_STIPPLE_PATTERN
		swigIntConstant( GL_LINE_STIPPLE_PATTERN, "GL_LINE_STIPPLE_PATTERN" );
	#endif
	#ifdef GL_LINE_STIPPLE_REPEAT
		swigIntConstant( GL_LINE_STIPPLE_REPEAT, "GL_LINE_STIPPLE_REPEAT" );
	#endif
	#ifdef GL_LINE_WIDTH
		swigIntConstant( GL_LINE_WIDTH, "GL_LINE_WIDTH" );
	#endif
	#ifdef GL_LINE_WIDTH_GRANULARITY
		swigIntConstant( GL_LINE_WIDTH_GRANULARITY, "GL_LINE_WIDTH_GRANULARITY" );
	#endif
	#ifdef GL_LINE_WIDTH_RANGE
		swigIntConstant( GL_LINE_WIDTH_RANGE, "GL_LINE_WIDTH_RANGE" );
	#endif
	#ifdef GL_POINT
		swigIntConstant( GL_POINT, "GL_POINT" );
	#endif
	#ifdef GL_LINE
		swigIntConstant( GL_LINE, "GL_LINE" );
	#endif
	#ifdef GL_FILL
		swigIntConstant( GL_FILL, "GL_FILL" );
	#endif
	#ifdef GL_CW
		swigIntConstant( GL_CW, "GL_CW" );
	#endif
	#ifdef GL_CCW
		swigIntConstant( GL_CCW, "GL_CCW" );
	#endif
	#ifdef GL_FRONT
		swigIntConstant( GL_FRONT, "GL_FRONT" );
	#endif
	#ifdef GL_BACK
		swigIntConstant( GL_BACK, "GL_BACK" );
	#endif
	#ifdef GL_POLYGON_MODE
		swigIntConstant( GL_POLYGON_MODE, "GL_POLYGON_MODE" );
	#endif
	#ifdef GL_POLYGON_SMOOTH
		swigIntConstant( GL_POLYGON_SMOOTH, "GL_POLYGON_SMOOTH" );
	#endif
	#ifdef GL_POLYGON_STIPPLE
		swigIntConstant( GL_POLYGON_STIPPLE, "GL_POLYGON_STIPPLE" );
	#endif
	#ifdef GL_EDGE_FLAG
		swigIntConstant( GL_EDGE_FLAG, "GL_EDGE_FLAG" );
	#endif
	#ifdef GL_CULL_FACE
		swigIntConstant( GL_CULL_FACE, "GL_CULL_FACE" );
	#endif
	#ifdef GL_CULL_FACE_MODE
		swigIntConstant( GL_CULL_FACE_MODE, "GL_CULL_FACE_MODE" );
	#endif
	#ifdef GL_FRONT_FACE
		swigIntConstant( GL_FRONT_FACE, "GL_FRONT_FACE" );
	#endif
	#ifdef GL_POLYGON_OFFSET_FACTOR
		swigIntConstant( GL_POLYGON_OFFSET_FACTOR, "GL_POLYGON_OFFSET_FACTOR" );
	#endif
	#ifdef GL_POLYGON_OFFSET_UNITS
		swigIntConstant( GL_POLYGON_OFFSET_UNITS, "GL_POLYGON_OFFSET_UNITS" );
	#endif
	#ifdef GL_POLYGON_OFFSET_POINT
		swigIntConstant( GL_POLYGON_OFFSET_POINT, "GL_POLYGON_OFFSET_POINT" );
	#endif
	#ifdef GL_POLYGON_OFFSET_LINE
		swigIntConstant( GL_POLYGON_OFFSET_LINE, "GL_POLYGON_OFFSET_LINE" );
	#endif
	#ifdef GL_POLYGON_OFFSET_FILL
		swigIntConstant( GL_POLYGON_OFFSET_FILL, "GL_POLYGON_OFFSET_FILL" );
	#endif
	#ifdef GL_COMPILE
		swigIntConstant( GL_COMPILE, "GL_COMPILE" );
	#endif
	#ifdef GL_COMPILE_AND_EXECUTE
		swigIntConstant( GL_COMPILE_AND_EXECUTE, "GL_COMPILE_AND_EXECUTE" );
	#endif
	#ifdef GL_LIST_BASE
		swigIntConstant( GL_LIST_BASE, "GL_LIST_BASE" );
	#endif
	#ifdef GL_LIST_INDEX
		swigIntConstant( GL_LIST_INDEX, "GL_LIST_INDEX" );
	#endif
	#ifdef GL_LIST_MODE
		swigIntConstant( GL_LIST_MODE, "GL_LIST_MODE" );
	#endif
	#ifdef GL_NEVER
		swigIntConstant( GL_NEVER, "GL_NEVER" );
	#endif
	#ifdef GL_LESS
		swigIntConstant( GL_LESS, "GL_LESS" );
	#endif
	#ifdef GL_EQUAL
		swigIntConstant( GL_EQUAL, "GL_EQUAL" );
	#endif
	#ifdef GL_LEQUAL
		swigIntConstant( GL_LEQUAL, "GL_LEQUAL" );
	#endif
	#ifdef GL_GREATER
		swigIntConstant( GL_GREATER, "GL_GREATER" );
	#endif
	#ifdef GL_NOTEQUAL
		swigIntConstant( GL_NOTEQUAL, "GL_NOTEQUAL" );
	#endif
	#ifdef GL_GEQUAL
		swigIntConstant( GL_GEQUAL, "GL_GEQUAL" );
	#endif
	#ifdef GL_ALWAYS
		swigIntConstant( GL_ALWAYS, "GL_ALWAYS" );
	#endif
	#ifdef GL_DEPTH_TEST
		swigIntConstant( GL_DEPTH_TEST, "GL_DEPTH_TEST" );
	#endif
	#ifdef GL_DEPTH_BITS
		swigIntConstant( GL_DEPTH_BITS, "GL_DEPTH_BITS" );
	#endif
	#ifdef GL_DEPTH_CLEAR_VALUE
		swigIntConstant( GL_DEPTH_CLEAR_VALUE, "GL_DEPTH_CLEAR_VALUE" );
	#endif
	#ifdef GL_DEPTH_FUNC
		swigIntConstant( GL_DEPTH_FUNC, "GL_DEPTH_FUNC" );
	#endif
	#ifdef GL_DEPTH_RANGE
		swigIntConstant( GL_DEPTH_RANGE, "GL_DEPTH_RANGE" );
	#endif
	#ifdef GL_DEPTH_WRITEMASK
		swigIntConstant( GL_DEPTH_WRITEMASK, "GL_DEPTH_WRITEMASK" );
	#endif
	#ifdef GL_DEPTH_COMPONENT
		swigIntConstant( GL_DEPTH_COMPONENT, "GL_DEPTH_COMPONENT" );
	#endif
	#ifdef GL_LIGHTING
		swigIntConstant( GL_LIGHTING, "GL_LIGHTING" );
	#endif
	#ifdef GL_LIGHT0
		swigIntConstant( GL_LIGHT0, "GL_LIGHT0" );
	#endif
	#ifdef GL_LIGHT1
		swigIntConstant( GL_LIGHT1, "GL_LIGHT1" );
	#endif
	#ifdef GL_LIGHT2
		swigIntConstant( GL_LIGHT2, "GL_LIGHT2" );
	#endif
	#ifdef GL_LIGHT3
		swigIntConstant( GL_LIGHT3, "GL_LIGHT3" );
	#endif
	#ifdef GL_LIGHT4
		swigIntConstant( GL_LIGHT4, "GL_LIGHT4" );
	#endif
	#ifdef GL_LIGHT5
		swigIntConstant( GL_LIGHT5, "GL_LIGHT5" );
	#endif
	#ifdef GL_LIGHT6
		swigIntConstant( GL_LIGHT6, "GL_LIGHT6" );
	#endif
	#ifdef GL_LIGHT7
		swigIntConstant( GL_LIGHT7, "GL_LIGHT7" );
	#endif
	#ifdef GL_SPOT_EXPONENT
		swigIntConstant( GL_SPOT_EXPONENT, "GL_SPOT_EXPONENT" );
	#endif
	#ifdef GL_SPOT_CUTOFF
		swigIntConstant( GL_SPOT_CUTOFF, "GL_SPOT_CUTOFF" );
	#endif
	#ifdef GL_CONSTANT_ATTENUATION
		swigIntConstant( GL_CONSTANT_ATTENUATION, "GL_CONSTANT_ATTENUATION" );
	#endif
	#ifdef GL_LINEAR_ATTENUATION
		swigIntConstant( GL_LINEAR_ATTENUATION, "GL_LINEAR_ATTENUATION" );
	#endif
	#ifdef GL_QUADRATIC_ATTENUATION
		swigIntConstant( GL_QUADRATIC_ATTENUATION, "GL_QUADRATIC_ATTENUATION" );
	#endif
	#ifdef GL_AMBIENT
		swigIntConstant( GL_AMBIENT, "GL_AMBIENT" );
	#endif
	#ifdef GL_DIFFUSE
		swigIntConstant( GL_DIFFUSE, "GL_DIFFUSE" );
	#endif
	#ifdef GL_SPECULAR
		swigIntConstant( GL_SPECULAR, "GL_SPECULAR" );
	#endif
	#ifdef GL_SHININESS
		swigIntConstant( GL_SHININESS, "GL_SHININESS" );
	#endif
	#ifdef GL_EMISSION
		swigIntConstant( GL_EMISSION, "GL_EMISSION" );
	#endif
	#ifdef GL_POSITION
		swigIntConstant( GL_POSITION, "GL_POSITION" );
	#endif
	#ifdef GL_SPOT_DIRECTION
		swigIntConstant( GL_SPOT_DIRECTION, "GL_SPOT_DIRECTION" );
	#endif
	#ifdef GL_AMBIENT_AND_DIFFUSE
		swigIntConstant( GL_AMBIENT_AND_DIFFUSE, "GL_AMBIENT_AND_DIFFUSE" );
	#endif
	#ifdef GL_COLOR_INDEXES
		swigIntConstant( GL_COLOR_INDEXES, "GL_COLOR_INDEXES" );
	#endif
	#ifdef GL_LIGHT_MODEL_TWO_SIDE
		swigIntConstant( GL_LIGHT_MODEL_TWO_SIDE, "GL_LIGHT_MODEL_TWO_SIDE" );
	#endif
	#ifdef GL_LIGHT_MODEL_LOCAL_VIEWER
		swigIntConstant( GL_LIGHT_MODEL_LOCAL_VIEWER, "GL_LIGHT_MODEL_LOCAL_VIEWER" );
	#endif
	#ifdef GL_LIGHT_MODEL_AMBIENT
		swigIntConstant( GL_LIGHT_MODEL_AMBIENT, "GL_LIGHT_MODEL_AMBIENT" );
	#endif
	#ifdef GL_FRONT_AND_BACK
		swigIntConstant( GL_FRONT_AND_BACK, "GL_FRONT_AND_BACK" );
	#endif
	#ifdef GL_SHADE_MODEL
		swigIntConstant( GL_SHADE_MODEL, "GL_SHADE_MODEL" );
	#endif
	#ifdef GL_FLAT
		swigIntConstant( GL_FLAT, "GL_FLAT" );
	#endif
	#ifdef GL_SMOOTH
		swigIntConstant( GL_SMOOTH, "GL_SMOOTH" );
	#endif
	#ifdef GL_COLOR_MATERIAL
		swigIntConstant( GL_COLOR_MATERIAL, "GL_COLOR_MATERIAL" );
	#endif
	#ifdef GL_COLOR_MATERIAL_FACE
		swigIntConstant( GL_COLOR_MATERIAL_FACE, "GL_COLOR_MATERIAL_FACE" );
	#endif
	#ifdef GL_COLOR_MATERIAL_PARAMETER
		swigIntConstant( GL_COLOR_MATERIAL_PARAMETER, "GL_COLOR_MATERIAL_PARAMETER" );
	#endif
	#ifdef GL_NORMALIZE
		swigIntConstant( GL_NORMALIZE, "GL_NORMALIZE" );
	#endif
	#ifdef GL_CLIP_PLANE0
		swigIntConstant( GL_CLIP_PLANE0, "GL_CLIP_PLANE0" );
	#endif
	#ifdef GL_CLIP_PLANE1
		swigIntConstant( GL_CLIP_PLANE1, "GL_CLIP_PLANE1" );
	#endif
	#ifdef GL_CLIP_PLANE2
		swigIntConstant( GL_CLIP_PLANE2, "GL_CLIP_PLANE2" );
	#endif
	#ifdef GL_CLIP_PLANE3
		swigIntConstant( GL_CLIP_PLANE3, "GL_CLIP_PLANE3" );
	#endif
	#ifdef GL_CLIP_PLANE4
		swigIntConstant( GL_CLIP_PLANE4, "GL_CLIP_PLANE4" );
	#endif
	#ifdef GL_CLIP_PLANE5
		swigIntConstant( GL_CLIP_PLANE5, "GL_CLIP_PLANE5" );
	#endif
	#ifdef GL_ACCUM_RED_BITS
		swigIntConstant( GL_ACCUM_RED_BITS, "GL_ACCUM_RED_BITS" );
	#endif
	#ifdef GL_ACCUM_GREEN_BITS
		swigIntConstant( GL_ACCUM_GREEN_BITS, "GL_ACCUM_GREEN_BITS" );
	#endif
	#ifdef GL_ACCUM_BLUE_BITS
		swigIntConstant( GL_ACCUM_BLUE_BITS, "GL_ACCUM_BLUE_BITS" );
	#endif
	#ifdef GL_ACCUM_ALPHA_BITS
		swigIntConstant( GL_ACCUM_ALPHA_BITS, "GL_ACCUM_ALPHA_BITS" );
	#endif
	#ifdef GL_ACCUM_CLEAR_VALUE
		swigIntConstant( GL_ACCUM_CLEAR_VALUE, "GL_ACCUM_CLEAR_VALUE" );
	#endif
	#ifdef GL_ACCUM
		swigIntConstant( GL_ACCUM, "GL_ACCUM" );
	#endif
	#ifdef GL_ADD
		swigIntConstant( GL_ADD, "GL_ADD" );
	#endif
	#ifdef GL_LOAD
		swigIntConstant( GL_LOAD, "GL_LOAD" );
	#endif
	#ifdef GL_MULT
		swigIntConstant( GL_MULT, "GL_MULT" );
	#endif
	#ifdef GL_RETURN
		swigIntConstant( GL_RETURN, "GL_RETURN" );
	#endif
	#ifdef GL_ALPHA_TEST
		swigIntConstant( GL_ALPHA_TEST, "GL_ALPHA_TEST" );
	#endif
	#ifdef GL_ALPHA_TEST_REF
		swigIntConstant( GL_ALPHA_TEST_REF, "GL_ALPHA_TEST_REF" );
	#endif
	#ifdef GL_ALPHA_TEST_FUNC
		swigIntConstant( GL_ALPHA_TEST_FUNC, "GL_ALPHA_TEST_FUNC" );
	#endif
	#ifdef GL_BLEND
		swigIntConstant( GL_BLEND, "GL_BLEND" );
	#endif
	#ifdef GL_BLEND_SRC
		swigIntConstant( GL_BLEND_SRC, "GL_BLEND_SRC" );
	#endif
	#ifdef GL_BLEND_DST
		swigIntConstant( GL_BLEND_DST, "GL_BLEND_DST" );
	#endif
	#ifdef GL_ZERO
		swigIntConstant( GL_ZERO, "GL_ZERO" );
	#endif
	#ifdef GL_ONE
		swigIntConstant( GL_ONE, "GL_ONE" );
	#endif
	#ifdef GL_SRC_COLOR
		swigIntConstant( GL_SRC_COLOR, "GL_SRC_COLOR" );
	#endif
	#ifdef GL_ONE_MINUS_SRC_COLOR
		swigIntConstant( GL_ONE_MINUS_SRC_COLOR, "GL_ONE_MINUS_SRC_COLOR" );
	#endif
	#ifdef GL_SRC_ALPHA
		swigIntConstant( GL_SRC_ALPHA, "GL_SRC_ALPHA" );
	#endif
	#ifdef GL_ONE_MINUS_SRC_ALPHA
		swigIntConstant( GL_ONE_MINUS_SRC_ALPHA, "GL_ONE_MINUS_SRC_ALPHA" );
	#endif
	#ifdef GL_DST_ALPHA
		swigIntConstant( GL_DST_ALPHA, "GL_DST_ALPHA" );
	#endif
	#ifdef GL_ONE_MINUS_DST_ALPHA
		swigIntConstant( GL_ONE_MINUS_DST_ALPHA, "GL_ONE_MINUS_DST_ALPHA" );
	#endif
	#ifdef GL_DST_COLOR
		swigIntConstant( GL_DST_COLOR, "GL_DST_COLOR" );
	#endif
	#ifdef GL_ONE_MINUS_DST_COLOR
		swigIntConstant( GL_ONE_MINUS_DST_COLOR, "GL_ONE_MINUS_DST_COLOR" );
	#endif
	#ifdef GL_SRC_ALPHA_SATURATE
		swigIntConstant( GL_SRC_ALPHA_SATURATE, "GL_SRC_ALPHA_SATURATE" );
	#endif
	#ifdef GL_FEEDBACK
		swigIntConstant( GL_FEEDBACK, "GL_FEEDBACK" );
	#endif
	#ifdef GL_RENDER
		swigIntConstant( GL_RENDER, "GL_RENDER" );
	#endif
	#ifdef GL_SELECT
		swigIntConstant( GL_SELECT, "GL_SELECT" );
	#endif
	#ifdef GL_2D
		swigIntConstant( GL_2D, "GL_2D" );
	#endif
	#ifdef GL_3D
		swigIntConstant( GL_3D, "GL_3D" );
	#endif
	#ifdef GL_3D_COLOR
		swigIntConstant( GL_3D_COLOR, "GL_3D_COLOR" );
	#endif
	#ifdef GL_3D_COLOR_TEXTURE
		swigIntConstant( GL_3D_COLOR_TEXTURE, "GL_3D_COLOR_TEXTURE" );
	#endif
	#ifdef GL_4D_COLOR_TEXTURE
		swigIntConstant( GL_4D_COLOR_TEXTURE, "GL_4D_COLOR_TEXTURE" );
	#endif
	#ifdef GL_POINT_TOKEN
		swigIntConstant( GL_POINT_TOKEN, "GL_POINT_TOKEN" );
	#endif
	#ifdef GL_LINE_TOKEN
		swigIntConstant( GL_LINE_TOKEN, "GL_LINE_TOKEN" );
	#endif
	#ifdef GL_LINE_RESET_TOKEN
		swigIntConstant( GL_LINE_RESET_TOKEN, "GL_LINE_RESET_TOKEN" );
	#endif
	#ifdef GL_POLYGON_TOKEN
		swigIntConstant( GL_POLYGON_TOKEN, "GL_POLYGON_TOKEN" );
	#endif
	#ifdef GL_BITMAP_TOKEN
		swigIntConstant( GL_BITMAP_TOKEN, "GL_BITMAP_TOKEN" );
	#endif
	#ifdef GL_DRAW_PIXEL_TOKEN
		swigIntConstant( GL_DRAW_PIXEL_TOKEN, "GL_DRAW_PIXEL_TOKEN" );
	#endif
	#ifdef GL_COPY_PIXEL_TOKEN
		swigIntConstant( GL_COPY_PIXEL_TOKEN, "GL_COPY_PIXEL_TOKEN" );
	#endif
	#ifdef GL_PASS_THROUGH_TOKEN
		swigIntConstant( GL_PASS_THROUGH_TOKEN, "GL_PASS_THROUGH_TOKEN" );
	#endif
	#ifdef GL_FEEDBACK_BUFFER_POINTER
		swigIntConstant( GL_FEEDBACK_BUFFER_POINTER, "GL_FEEDBACK_BUFFER_POINTER" );
	#endif
	#ifdef GL_FEEDBACK_BUFFER_SIZE
		swigIntConstant( GL_FEEDBACK_BUFFER_SIZE, "GL_FEEDBACK_BUFFER_SIZE" );
	#endif
	#ifdef GL_FEEDBACK_BUFFER_TYPE
		swigIntConstant( GL_FEEDBACK_BUFFER_TYPE, "GL_FEEDBACK_BUFFER_TYPE" );
	#endif
	#ifdef GL_SELECTION_BUFFER_POINTER
		swigIntConstant( GL_SELECTION_BUFFER_POINTER, "GL_SELECTION_BUFFER_POINTER" );
	#endif
	#ifdef GL_SELECTION_BUFFER_SIZE
		swigIntConstant( GL_SELECTION_BUFFER_SIZE, "GL_SELECTION_BUFFER_SIZE" );
	#endif
	#ifdef GL_FOG
		swigIntConstant( GL_FOG, "GL_FOG" );
	#endif
	#ifdef GL_FOG_MODE
		swigIntConstant( GL_FOG_MODE, "GL_FOG_MODE" );
	#endif
	#ifdef GL_FOG_DENSITY
		swigIntConstant( GL_FOG_DENSITY, "GL_FOG_DENSITY" );
	#endif
	#ifdef GL_FOG_COLOR
		swigIntConstant( GL_FOG_COLOR, "GL_FOG_COLOR" );
	#endif
	#ifdef GL_FOG_INDEX
		swigIntConstant( GL_FOG_INDEX, "GL_FOG_INDEX" );
	#endif
	#ifdef GL_FOG_START
		swigIntConstant( GL_FOG_START, "GL_FOG_START" );
	#endif
	#ifdef GL_FOG_END
		swigIntConstant( GL_FOG_END, "GL_FOG_END" );
	#endif
	#ifdef GL_LINEAR
		swigIntConstant( GL_LINEAR, "GL_LINEAR" );
	#endif
	#ifdef GL_EXP
		swigIntConstant( GL_EXP, "GL_EXP" );
	#endif
	#ifdef GL_EXP2
		swigIntConstant( GL_EXP2, "GL_EXP2" );
	#endif
	#ifdef GL_LOGIC_OP
		swigIntConstant( GL_LOGIC_OP, "GL_LOGIC_OP" );
	#endif
	#ifdef GL_INDEX_LOGIC_OP
		swigIntConstant( GL_INDEX_LOGIC_OP, "GL_INDEX_LOGIC_OP" );
	#endif
	#ifdef GL_COLOR_LOGIC_OP
		swigIntConstant( GL_COLOR_LOGIC_OP, "GL_COLOR_LOGIC_OP" );
	#endif
	#ifdef GL_LOGIC_OP_MODE
		swigIntConstant( GL_LOGIC_OP_MODE, "GL_LOGIC_OP_MODE" );
	#endif
	#ifdef GL_CLEAR
		swigIntConstant( GL_CLEAR, "GL_CLEAR" );
	#endif
	#ifdef GL_SET
		swigIntConstant( GL_SET, "GL_SET" );
	#endif
	#ifdef GL_COPY
		swigIntConstant( GL_COPY, "GL_COPY" );
	#endif
	#ifdef GL_COPY_INVERTED
		swigIntConstant( GL_COPY_INVERTED, "GL_COPY_INVERTED" );
	#endif
	#ifdef GL_NOOP
		swigIntConstant( GL_NOOP, "GL_NOOP" );
	#endif
	#ifdef GL_INVERT
		swigIntConstant( GL_INVERT, "GL_INVERT" );
	#endif
	#ifdef GL_AND
		swigIntConstant( GL_AND, "GL_AND" );
	#endif
	#ifdef GL_NAND
		swigIntConstant( GL_NAND, "GL_NAND" );
	#endif
	#ifdef GL_OR
		swigIntConstant( GL_OR, "GL_OR" );
	#endif
	#ifdef GL_NOR
		swigIntConstant( GL_NOR, "GL_NOR" );
	#endif
	#ifdef GL_XOR
		swigIntConstant( GL_XOR, "GL_XOR" );
	#endif
	#ifdef GL_EQUIV
		swigIntConstant( GL_EQUIV, "GL_EQUIV" );
	#endif
	#ifdef GL_AND_REVERSE
		swigIntConstant( GL_AND_REVERSE, "GL_AND_REVERSE" );
	#endif
	#ifdef GL_AND_INVERTED
		swigIntConstant( GL_AND_INVERTED, "GL_AND_INVERTED" );
	#endif
	#ifdef GL_OR_REVERSE
		swigIntConstant( GL_OR_REVERSE, "GL_OR_REVERSE" );
	#endif
	#ifdef GL_OR_INVERTED
		swigIntConstant( GL_OR_INVERTED, "GL_OR_INVERTED" );
	#endif
	#ifdef GL_STENCIL_BITS
		swigIntConstant( GL_STENCIL_BITS, "GL_STENCIL_BITS" );
	#endif
	#ifdef GL_STENCIL_TEST
		swigIntConstant( GL_STENCIL_TEST, "GL_STENCIL_TEST" );
	#endif
	#ifdef GL_STENCIL_CLEAR_VALUE
		swigIntConstant( GL_STENCIL_CLEAR_VALUE, "GL_STENCIL_CLEAR_VALUE" );
	#endif
	#ifdef GL_STENCIL_FUNC
		swigIntConstant( GL_STENCIL_FUNC, "GL_STENCIL_FUNC" );
	#endif
	#ifdef GL_STENCIL_VALUE_MASK
		swigIntConstant( GL_STENCIL_VALUE_MASK, "GL_STENCIL_VALUE_MASK" );
	#endif
	#ifdef GL_STENCIL_FAIL
		swigIntConstant( GL_STENCIL_FAIL, "GL_STENCIL_FAIL" );
	#endif
	#ifdef GL_STENCIL_PASS_DEPTH_FAIL
		swigIntConstant( GL_STENCIL_PASS_DEPTH_FAIL, "GL_STENCIL_PASS_DEPTH_FAIL" );
	#endif
	#ifdef GL_STENCIL_PASS_DEPTH_PASS
		swigIntConstant( GL_STENCIL_PASS_DEPTH_PASS, "GL_STENCIL_PASS_DEPTH_PASS" );
	#endif
	#ifdef GL_STENCIL_REF
		swigIntConstant( GL_STENCIL_REF, "GL_STENCIL_REF" );
	#endif
	#ifdef GL_STENCIL_WRITEMASK
		swigIntConstant( GL_STENCIL_WRITEMASK, "GL_STENCIL_WRITEMASK" );
	#endif
	#ifdef GL_STENCIL_INDEX
		swigIntConstant( GL_STENCIL_INDEX, "GL_STENCIL_INDEX" );
	#endif
	#ifdef GL_KEEP
		swigIntConstant( GL_KEEP, "GL_KEEP" );
	#endif
	#ifdef GL_REPLACE
		swigIntConstant( GL_REPLACE, "GL_REPLACE" );
	#endif
	#ifdef GL_INCR
		swigIntConstant( GL_INCR, "GL_INCR" );
	#endif
	#ifdef GL_DECR
		swigIntConstant( GL_DECR, "GL_DECR" );
	#endif
	#ifdef GL_NONE
		swigIntConstant( GL_NONE, "GL_NONE" );
	#endif
	#ifdef GL_LEFT
		swigIntConstant( GL_LEFT, "GL_LEFT" );
	#endif
	#ifdef GL_RIGHT
		swigIntConstant( GL_RIGHT, "GL_RIGHT" );
	#endif
	#ifdef GL_FRONT_LEFT
		swigIntConstant( GL_FRONT_LEFT, "GL_FRONT_LEFT" );
	#endif
	#ifdef GL_FRONT_RIGHT
		swigIntConstant( GL_FRONT_RIGHT, "GL_FRONT_RIGHT" );
	#endif
	#ifdef GL_BACK_LEFT
		swigIntConstant( GL_BACK_LEFT, "GL_BACK_LEFT" );
	#endif
	#ifdef GL_BACK_RIGHT
		swigIntConstant( GL_BACK_RIGHT, "GL_BACK_RIGHT" );
	#endif
	#ifdef GL_AUX0
		swigIntConstant( GL_AUX0, "GL_AUX0" );
	#endif
	#ifdef GL_AUX1
		swigIntConstant( GL_AUX1, "GL_AUX1" );
	#endif
	#ifdef GL_AUX2
		swigIntConstant( GL_AUX2, "GL_AUX2" );
	#endif
	#ifdef GL_AUX3
		swigIntConstant( GL_AUX3, "GL_AUX3" );
	#endif
	#ifdef GL_COLOR_INDEX
		swigIntConstant( GL_COLOR_INDEX, "GL_COLOR_INDEX" );
	#endif
	#ifdef GL_RED
		swigIntConstant( GL_RED, "GL_RED" );
	#endif
	#ifdef GL_GREEN
		swigIntConstant( GL_GREEN, "GL_GREEN" );
	#endif
	#ifdef GL_BLUE
		swigIntConstant( GL_BLUE, "GL_BLUE" );
	#endif
	#ifdef GL_ALPHA
		swigIntConstant( GL_ALPHA, "GL_ALPHA" );
	#endif
	#ifdef GL_LUMINANCE
		swigIntConstant( GL_LUMINANCE, "GL_LUMINANCE" );
	#endif
	#ifdef GL_LUMINANCE_ALPHA
		swigIntConstant( GL_LUMINANCE_ALPHA, "GL_LUMINANCE_ALPHA" );
	#endif
	#ifdef GL_ALPHA_BITS
		swigIntConstant( GL_ALPHA_BITS, "GL_ALPHA_BITS" );
	#endif
	#ifdef GL_RED_BITS
		swigIntConstant( GL_RED_BITS, "GL_RED_BITS" );
	#endif
	#ifdef GL_GREEN_BITS
		swigIntConstant( GL_GREEN_BITS, "GL_GREEN_BITS" );
	#endif
	#ifdef GL_BLUE_BITS
		swigIntConstant( GL_BLUE_BITS, "GL_BLUE_BITS" );
	#endif
	#ifdef GL_INDEX_BITS
		swigIntConstant( GL_INDEX_BITS, "GL_INDEX_BITS" );
	#endif
	#ifdef GL_SUBPIXEL_BITS
		swigIntConstant( GL_SUBPIXEL_BITS, "GL_SUBPIXEL_BITS" );
	#endif
	#ifdef GL_AUX_BUFFERS
		swigIntConstant( GL_AUX_BUFFERS, "GL_AUX_BUFFERS" );
	#endif
	#ifdef GL_READ_BUFFER
		swigIntConstant( GL_READ_BUFFER, "GL_READ_BUFFER" );
	#endif
	#ifdef GL_DRAW_BUFFER
		swigIntConstant( GL_DRAW_BUFFER, "GL_DRAW_BUFFER" );
	#endif
	#ifdef GL_DOUBLEBUFFER
		swigIntConstant( GL_DOUBLEBUFFER, "GL_DOUBLEBUFFER" );
	#endif
	#ifdef GL_STEREO
		swigIntConstant( GL_STEREO, "GL_STEREO" );
	#endif
	#ifdef GL_BITMAP
		swigIntConstant( GL_BITMAP, "GL_BITMAP" );
	#endif
	#ifdef GL_COLOR
		swigIntConstant( GL_COLOR, "GL_COLOR" );
	#endif
	#ifdef GL_DEPTH
		swigIntConstant( GL_DEPTH, "GL_DEPTH" );
	#endif
	#ifdef GL_STENCIL
		swigIntConstant( GL_STENCIL, "GL_STENCIL" );
	#endif
	#ifdef GL_DITHER
		swigIntConstant( GL_DITHER, "GL_DITHER" );
	#endif
	#ifdef GL_RGB
		swigIntConstant( GL_RGB, "GL_RGB" );
	#endif
	#ifdef GL_RGBA
		swigIntConstant( GL_RGBA, "GL_RGBA" );
	#endif
	#ifdef GL_MAX_LIST_NESTING
		swigIntConstant( GL_MAX_LIST_NESTING, "GL_MAX_LIST_NESTING" );
	#endif
	#ifdef GL_MAX_EVAL_ORDER
		swigIntConstant( GL_MAX_EVAL_ORDER, "GL_MAX_EVAL_ORDER" );
	#endif
	#ifdef GL_MAX_LIGHTS
		swigIntConstant( GL_MAX_LIGHTS, "GL_MAX_LIGHTS" );
	#endif
	#ifdef GL_MAX_CLIP_PLANES
		swigIntConstant( GL_MAX_CLIP_PLANES, "GL_MAX_CLIP_PLANES" );
	#endif
	#ifdef GL_MAX_TEXTURE_SIZE
		swigIntConstant( GL_MAX_TEXTURE_SIZE, "GL_MAX_TEXTURE_SIZE" );
	#endif
	#ifdef GL_MAX_PIXEL_MAP_TABLE
		swigIntConstant( GL_MAX_PIXEL_MAP_TABLE, "GL_MAX_PIXEL_MAP_TABLE" );
	#endif
	#ifdef GL_MAX_ATTRIB_STACK_DEPTH
		swigIntConstant( GL_MAX_ATTRIB_STACK_DEPTH, "GL_MAX_ATTRIB_STACK_DEPTH" );
	#endif
	#ifdef GL_MAX_MODELVIEW_STACK_DEPTH
		swigIntConstant( GL_MAX_MODELVIEW_STACK_DEPTH, "GL_MAX_MODELVIEW_STACK_DEPTH" );
	#endif
	#ifdef GL_MAX_NAME_STACK_DEPTH
		swigIntConstant( GL_MAX_NAME_STACK_DEPTH, "GL_MAX_NAME_STACK_DEPTH" );
	#endif
	#ifdef GL_MAX_PROJECTION_STACK_DEPTH
		swigIntConstant( GL_MAX_PROJECTION_STACK_DEPTH, "GL_MAX_PROJECTION_STACK_DEPTH" );
	#endif
	#ifdef GL_MAX_TEXTURE_STACK_DEPTH
		swigIntConstant( GL_MAX_TEXTURE_STACK_DEPTH, "GL_MAX_TEXTURE_STACK_DEPTH" );
	#endif
	#ifdef GL_MAX_VIEWPORT_DIMS
		swigIntConstant( GL_MAX_VIEWPORT_DIMS, "GL_MAX_VIEWPORT_DIMS" );
	#endif
	#ifdef GL_MAX_CLIENT_ATTRIB_STACK_DEPTH
		swigIntConstant( GL_MAX_CLIENT_ATTRIB_STACK_DEPTH, "GL_MAX_CLIENT_ATTRIB_STACK_DEPTH" );
	#endif
	#ifdef GL_ATTRIB_STACK_DEPTH
		swigIntConstant( GL_ATTRIB_STACK_DEPTH, "GL_ATTRIB_STACK_DEPTH" );
	#endif
	#ifdef GL_CLIENT_ATTRIB_STACK_DEPTH
		swigIntConstant( GL_CLIENT_ATTRIB_STACK_DEPTH, "GL_CLIENT_ATTRIB_STACK_DEPTH" );
	#endif
	#ifdef GL_COLOR_CLEAR_VALUE
		swigIntConstant( GL_COLOR_CLEAR_VALUE, "GL_COLOR_CLEAR_VALUE" );
	#endif
	#ifdef GL_COLOR_WRITEMASK
		swigIntConstant( GL_COLOR_WRITEMASK, "GL_COLOR_WRITEMASK" );
	#endif
	#ifdef GL_CURRENT_INDEX
		swigIntConstant( GL_CURRENT_INDEX, "GL_CURRENT_INDEX" );
	#endif
	#ifdef GL_CURRENT_COLOR
		swigIntConstant( GL_CURRENT_COLOR, "GL_CURRENT_COLOR" );
	#endif
	#ifdef GL_CURRENT_NORMAL
		swigIntConstant( GL_CURRENT_NORMAL, "GL_CURRENT_NORMAL" );
	#endif
	#ifdef GL_CURRENT_RASTER_COLOR
		swigIntConstant( GL_CURRENT_RASTER_COLOR, "GL_CURRENT_RASTER_COLOR" );
	#endif
	#ifdef GL_CURRENT_RASTER_DISTANCE
		swigIntConstant( GL_CURRENT_RASTER_DISTANCE, "GL_CURRENT_RASTER_DISTANCE" );
	#endif
	#ifdef GL_CURRENT_RASTER_INDEX
		swigIntConstant( GL_CURRENT_RASTER_INDEX, "GL_CURRENT_RASTER_INDEX" );
	#endif
	#ifdef GL_CURRENT_RASTER_POSITION
		swigIntConstant( GL_CURRENT_RASTER_POSITION, "GL_CURRENT_RASTER_POSITION" );
	#endif
	#ifdef GL_CURRENT_RASTER_TEXTURE_COORDS
		swigIntConstant( GL_CURRENT_RASTER_TEXTURE_COORDS, "GL_CURRENT_RASTER_TEXTURE_COORDS" );
	#endif
	#ifdef GL_CURRENT_RASTER_POSITION_VALID
		swigIntConstant( GL_CURRENT_RASTER_POSITION_VALID, "GL_CURRENT_RASTER_POSITION_VALID" );
	#endif
	#ifdef GL_CURRENT_TEXTURE_COORDS
		swigIntConstant( GL_CURRENT_TEXTURE_COORDS, "GL_CURRENT_TEXTURE_COORDS" );
	#endif
	#ifdef GL_INDEX_CLEAR_VALUE
		swigIntConstant( GL_INDEX_CLEAR_VALUE, "GL_INDEX_CLEAR_VALUE" );
	#endif
	#ifdef GL_INDEX_MODE
		swigIntConstant( GL_INDEX_MODE, "GL_INDEX_MODE" );
	#endif
	#ifdef GL_INDEX_WRITEMASK
		swigIntConstant( GL_INDEX_WRITEMASK, "GL_INDEX_WRITEMASK" );
	#endif
	#ifdef GL_MODELVIEW_MATRIX
		swigIntConstant( GL_MODELVIEW_MATRIX, "GL_MODELVIEW_MATRIX" );
	#endif
	#ifdef GL_MODELVIEW_STACK_DEPTH
		swigIntConstant( GL_MODELVIEW_STACK_DEPTH, "GL_MODELVIEW_STACK_DEPTH" );
	#endif
	#ifdef GL_NAME_STACK_DEPTH
		swigIntConstant( GL_NAME_STACK_DEPTH, "GL_NAME_STACK_DEPTH" );
	#endif
	#ifdef GL_PROJECTION_MATRIX
		swigIntConstant( GL_PROJECTION_MATRIX, "GL_PROJECTION_MATRIX" );
	#endif
	#ifdef GL_PROJECTION_STACK_DEPTH
		swigIntConstant( GL_PROJECTION_STACK_DEPTH, "GL_PROJECTION_STACK_DEPTH" );
	#endif
	#ifdef GL_RENDER_MODE
		swigIntConstant( GL_RENDER_MODE, "GL_RENDER_MODE" );
	#endif
	#ifdef GL_RGBA_MODE
		swigIntConstant( GL_RGBA_MODE, "GL_RGBA_MODE" );
	#endif
	#ifdef GL_TEXTURE_MATRIX
		swigIntConstant( GL_TEXTURE_MATRIX, "GL_TEXTURE_MATRIX" );
	#endif
	#ifdef GL_TEXTURE_STACK_DEPTH
		swigIntConstant( GL_TEXTURE_STACK_DEPTH, "GL_TEXTURE_STACK_DEPTH" );
	#endif
	#ifdef GL_VIEWPORT
		swigIntConstant( GL_VIEWPORT, "GL_VIEWPORT" );
	#endif
	#ifdef GL_AUTO_NORMAL
		swigIntConstant( GL_AUTO_NORMAL, "GL_AUTO_NORMAL" );
	#endif
	#ifdef GL_MAP1_COLOR_4
		swigIntConstant( GL_MAP1_COLOR_4, "GL_MAP1_COLOR_4" );
	#endif
	#ifdef GL_MAP1_INDEX
		swigIntConstant( GL_MAP1_INDEX, "GL_MAP1_INDEX" );
	#endif
	#ifdef GL_MAP1_NORMAL
		swigIntConstant( GL_MAP1_NORMAL, "GL_MAP1_NORMAL" );
	#endif
	#ifdef GL_MAP1_TEXTURE_COORD_1
		swigIntConstant( GL_MAP1_TEXTURE_COORD_1, "GL_MAP1_TEXTURE_COORD_1" );
	#endif
	#ifdef GL_MAP1_TEXTURE_COORD_2
		swigIntConstant( GL_MAP1_TEXTURE_COORD_2, "GL_MAP1_TEXTURE_COORD_2" );
	#endif
	#ifdef GL_MAP1_TEXTURE_COORD_3
		swigIntConstant( GL_MAP1_TEXTURE_COORD_3, "GL_MAP1_TEXTURE_COORD_3" );
	#endif
	#ifdef GL_MAP1_TEXTURE_COORD_4
		swigIntConstant( GL_MAP1_TEXTURE_COORD_4, "GL_MAP1_TEXTURE_COORD_4" );
	#endif
	#ifdef GL_MAP1_VERTEX_3
		swigIntConstant( GL_MAP1_VERTEX_3, "GL_MAP1_VERTEX_3" );
	#endif
	#ifdef GL_MAP1_VERTEX_4
		swigIntConstant( GL_MAP1_VERTEX_4, "GL_MAP1_VERTEX_4" );
	#endif
	#ifdef GL_MAP2_COLOR_4
		swigIntConstant( GL_MAP2_COLOR_4, "GL_MAP2_COLOR_4" );
	#endif
	#ifdef GL_MAP2_INDEX
		swigIntConstant( GL_MAP2_INDEX, "GL_MAP2_INDEX" );
	#endif
	#ifdef GL_MAP2_NORMAL
		swigIntConstant( GL_MAP2_NORMAL, "GL_MAP2_NORMAL" );
	#endif
	#ifdef GL_MAP2_TEXTURE_COORD_1
		swigIntConstant( GL_MAP2_TEXTURE_COORD_1, "GL_MAP2_TEXTURE_COORD_1" );
	#endif
	#ifdef GL_MAP2_TEXTURE_COORD_2
		swigIntConstant( GL_MAP2_TEXTURE_COORD_2, "GL_MAP2_TEXTURE_COORD_2" );
	#endif
	#ifdef GL_MAP2_TEXTURE_COORD_3
		swigIntConstant( GL_MAP2_TEXTURE_COORD_3, "GL_MAP2_TEXTURE_COORD_3" );
	#endif
	#ifdef GL_MAP2_TEXTURE_COORD_4
		swigIntConstant( GL_MAP2_TEXTURE_COORD_4, "GL_MAP2_TEXTURE_COORD_4" );
	#endif
	#ifdef GL_MAP2_VERTEX_3
		swigIntConstant( GL_MAP2_VERTEX_3, "GL_MAP2_VERTEX_3" );
	#endif
	#ifdef GL_MAP2_VERTEX_4
		swigIntConstant( GL_MAP2_VERTEX_4, "GL_MAP2_VERTEX_4" );
	#endif
	#ifdef GL_MAP1_GRID_DOMAIN
		swigIntConstant( GL_MAP1_GRID_DOMAIN, "GL_MAP1_GRID_DOMAIN" );
	#endif
	#ifdef GL_MAP1_GRID_SEGMENTS
		swigIntConstant( GL_MAP1_GRID_SEGMENTS, "GL_MAP1_GRID_SEGMENTS" );
	#endif
	#ifdef GL_MAP2_GRID_DOMAIN
		swigIntConstant( GL_MAP2_GRID_DOMAIN, "GL_MAP2_GRID_DOMAIN" );
	#endif
	#ifdef GL_MAP2_GRID_SEGMENTS
		swigIntConstant( GL_MAP2_GRID_SEGMENTS, "GL_MAP2_GRID_SEGMENTS" );
	#endif
	#ifdef GL_COEFF
		swigIntConstant( GL_COEFF, "GL_COEFF" );
	#endif
	#ifdef GL_ORDER
		swigIntConstant( GL_ORDER, "GL_ORDER" );
	#endif
	#ifdef GL_DOMAIN
		swigIntConstant( GL_DOMAIN, "GL_DOMAIN" );
	#endif
	#ifdef GL_PERSPECTIVE_CORRECTION_HINT
		swigIntConstant( GL_PERSPECTIVE_CORRECTION_HINT, "GL_PERSPECTIVE_CORRECTION_HINT" );
	#endif
	#ifdef GL_POINT_SMOOTH_HINT
		swigIntConstant( GL_POINT_SMOOTH_HINT, "GL_POINT_SMOOTH_HINT" );
	#endif
	#ifdef GL_LINE_SMOOTH_HINT
		swigIntConstant( GL_LINE_SMOOTH_HINT, "GL_LINE_SMOOTH_HINT" );
	#endif
	#ifdef GL_POLYGON_SMOOTH_HINT
		swigIntConstant( GL_POLYGON_SMOOTH_HINT, "GL_POLYGON_SMOOTH_HINT" );
	#endif
	#ifdef GL_FOG_HINT
		swigIntConstant( GL_FOG_HINT, "GL_FOG_HINT" );
	#endif
	#ifdef GL_DONT_CARE
		swigIntConstant( GL_DONT_CARE, "GL_DONT_CARE" );
	#endif
	#ifdef GL_FASTEST
		swigIntConstant( GL_FASTEST, "GL_FASTEST" );
	#endif
	#ifdef GL_NICEST
		swigIntConstant( GL_NICEST, "GL_NICEST" );
	#endif
	#ifdef GL_SCISSOR_BOX
		swigIntConstant( GL_SCISSOR_BOX, "GL_SCISSOR_BOX" );
	#endif
	#ifdef GL_SCISSOR_TEST
		swigIntConstant( GL_SCISSOR_TEST, "GL_SCISSOR_TEST" );
	#endif
	#ifdef GL_MAP_COLOR
		swigIntConstant( GL_MAP_COLOR, "GL_MAP_COLOR" );
	#endif
	#ifdef GL_MAP_STENCIL
		swigIntConstant( GL_MAP_STENCIL, "GL_MAP_STENCIL" );
	#endif
	#ifdef GL_INDEX_SHIFT
		swigIntConstant( GL_INDEX_SHIFT, "GL_INDEX_SHIFT" );
	#endif
	#ifdef GL_INDEX_OFFSET
		swigIntConstant( GL_INDEX_OFFSET, "GL_INDEX_OFFSET" );
	#endif
	#ifdef GL_RED_SCALE
		swigIntConstant( GL_RED_SCALE, "GL_RED_SCALE" );
	#endif
	#ifdef GL_RED_BIAS
		swigIntConstant( GL_RED_BIAS, "GL_RED_BIAS" );
	#endif
	#ifdef GL_GREEN_SCALE
		swigIntConstant( GL_GREEN_SCALE, "GL_GREEN_SCALE" );
	#endif
	#ifdef GL_GREEN_BIAS
		swigIntConstant( GL_GREEN_BIAS, "GL_GREEN_BIAS" );
	#endif
	#ifdef GL_BLUE_SCALE
		swigIntConstant( GL_BLUE_SCALE, "GL_BLUE_SCALE" );
	#endif
	#ifdef GL_BLUE_BIAS
		swigIntConstant( GL_BLUE_BIAS, "GL_BLUE_BIAS" );
	#endif
	#ifdef GL_ALPHA_SCALE
		swigIntConstant( GL_ALPHA_SCALE, "GL_ALPHA_SCALE" );
	#endif
	#ifdef GL_ALPHA_BIAS
		swigIntConstant( GL_ALPHA_BIAS, "GL_ALPHA_BIAS" );
	#endif
	#ifdef GL_DEPTH_SCALE
		swigIntConstant( GL_DEPTH_SCALE, "GL_DEPTH_SCALE" );
	#endif
	#ifdef GL_DEPTH_BIAS
		swigIntConstant( GL_DEPTH_BIAS, "GL_DEPTH_BIAS" );
	#endif
	#ifdef GL_PIXEL_MAP_S_TO_S_SIZE
		swigIntConstant( GL_PIXEL_MAP_S_TO_S_SIZE, "GL_PIXEL_MAP_S_TO_S_SIZE" );
	#endif
	#ifdef GL_PIXEL_MAP_I_TO_I_SIZE
		swigIntConstant( GL_PIXEL_MAP_I_TO_I_SIZE, "GL_PIXEL_MAP_I_TO_I_SIZE" );
	#endif
	#ifdef GL_PIXEL_MAP_I_TO_R_SIZE
		swigIntConstant( GL_PIXEL_MAP_I_TO_R_SIZE, "GL_PIXEL_MAP_I_TO_R_SIZE" );
	#endif
	#ifdef GL_PIXEL_MAP_I_TO_G_SIZE
		swigIntConstant( GL_PIXEL_MAP_I_TO_G_SIZE, "GL_PIXEL_MAP_I_TO_G_SIZE" );
	#endif
	#ifdef GL_PIXEL_MAP_I_TO_B_SIZE
		swigIntConstant( GL_PIXEL_MAP_I_TO_B_SIZE, "GL_PIXEL_MAP_I_TO_B_SIZE" );
	#endif
	#ifdef GL_PIXEL_MAP_I_TO_A_SIZE
		swigIntConstant( GL_PIXEL_MAP_I_TO_A_SIZE, "GL_PIXEL_MAP_I_TO_A_SIZE" );
	#endif
	#ifdef GL_PIXEL_MAP_R_TO_R_SIZE
		swigIntConstant( GL_PIXEL_MAP_R_TO_R_SIZE, "GL_PIXEL_MAP_R_TO_R_SIZE" );
	#endif
	#ifdef GL_PIXEL_MAP_G_TO_G_SIZE
		swigIntConstant( GL_PIXEL_MAP_G_TO_G_SIZE, "GL_PIXEL_MAP_G_TO_G_SIZE" );
	#endif
	#ifdef GL_PIXEL_MAP_B_TO_B_SIZE
		swigIntConstant( GL_PIXEL_MAP_B_TO_B_SIZE, "GL_PIXEL_MAP_B_TO_B_SIZE" );
	#endif
	#ifdef GL_PIXEL_MAP_A_TO_A_SIZE
		swigIntConstant( GL_PIXEL_MAP_A_TO_A_SIZE, "GL_PIXEL_MAP_A_TO_A_SIZE" );
	#endif
	#ifdef GL_PIXEL_MAP_S_TO_S
		swigIntConstant( GL_PIXEL_MAP_S_TO_S, "GL_PIXEL_MAP_S_TO_S" );
	#endif
	#ifdef GL_PIXEL_MAP_I_TO_I
		swigIntConstant( GL_PIXEL_MAP_I_TO_I, "GL_PIXEL_MAP_I_TO_I" );
	#endif
	#ifdef GL_PIXEL_MAP_I_TO_R
		swigIntConstant( GL_PIXEL_MAP_I_TO_R, "GL_PIXEL_MAP_I_TO_R" );
	#endif
	#ifdef GL_PIXEL_MAP_I_TO_G
		swigIntConstant( GL_PIXEL_MAP_I_TO_G, "GL_PIXEL_MAP_I_TO_G" );
	#endif
	#ifdef GL_PIXEL_MAP_I_TO_B
		swigIntConstant( GL_PIXEL_MAP_I_TO_B, "GL_PIXEL_MAP_I_TO_B" );
	#endif
	#ifdef GL_PIXEL_MAP_I_TO_A
		swigIntConstant( GL_PIXEL_MAP_I_TO_A, "GL_PIXEL_MAP_I_TO_A" );
	#endif
	#ifdef GL_PIXEL_MAP_R_TO_R
		swigIntConstant( GL_PIXEL_MAP_R_TO_R, "GL_PIXEL_MAP_R_TO_R" );
	#endif
	#ifdef GL_PIXEL_MAP_G_TO_G
		swigIntConstant( GL_PIXEL_MAP_G_TO_G, "GL_PIXEL_MAP_G_TO_G" );
	#endif
	#ifdef GL_PIXEL_MAP_B_TO_B
		swigIntConstant( GL_PIXEL_MAP_B_TO_B, "GL_PIXEL_MAP_B_TO_B" );
	#endif
	#ifdef GL_PIXEL_MAP_A_TO_A
		swigIntConstant( GL_PIXEL_MAP_A_TO_A, "GL_PIXEL_MAP_A_TO_A" );
	#endif
	#ifdef GL_PACK_ALIGNMENT
		swigIntConstant( GL_PACK_ALIGNMENT, "GL_PACK_ALIGNMENT" );
	#endif
	#ifdef GL_PACK_LSB_FIRST
		swigIntConstant( GL_PACK_LSB_FIRST, "GL_PACK_LSB_FIRST" );
	#endif
	#ifdef GL_PACK_ROW_LENGTH
		swigIntConstant( GL_PACK_ROW_LENGTH, "GL_PACK_ROW_LENGTH" );
	#endif
	#ifdef GL_PACK_SKIP_PIXELS
		swigIntConstant( GL_PACK_SKIP_PIXELS, "GL_PACK_SKIP_PIXELS" );
	#endif
	#ifdef GL_PACK_SKIP_ROWS
		swigIntConstant( GL_PACK_SKIP_ROWS, "GL_PACK_SKIP_ROWS" );
	#endif
	#ifdef GL_PACK_SWAP_BYTES
		swigIntConstant( GL_PACK_SWAP_BYTES, "GL_PACK_SWAP_BYTES" );
	#endif
	#ifdef GL_UNPACK_ALIGNMENT
		swigIntConstant( GL_UNPACK_ALIGNMENT, "GL_UNPACK_ALIGNMENT" );
	#endif
	#ifdef GL_UNPACK_LSB_FIRST
		swigIntConstant( GL_UNPACK_LSB_FIRST, "GL_UNPACK_LSB_FIRST" );
	#endif
	#ifdef GL_UNPACK_ROW_LENGTH
		swigIntConstant( GL_UNPACK_ROW_LENGTH, "GL_UNPACK_ROW_LENGTH" );
	#endif
	#ifdef GL_UNPACK_SKIP_PIXELS
		swigIntConstant( GL_UNPACK_SKIP_PIXELS, "GL_UNPACK_SKIP_PIXELS" );
	#endif
	#ifdef GL_UNPACK_SKIP_ROWS
		swigIntConstant( GL_UNPACK_SKIP_ROWS, "GL_UNPACK_SKIP_ROWS" );
	#endif
	#ifdef GL_UNPACK_SWAP_BYTES
		swigIntConstant( GL_UNPACK_SWAP_BYTES, "GL_UNPACK_SWAP_BYTES" );
	#endif
	#ifdef GL_ZOOM_X
		swigIntConstant( GL_ZOOM_X, "GL_ZOOM_X" );
	#endif
	#ifdef GL_ZOOM_Y
		swigIntConstant( GL_ZOOM_Y, "GL_ZOOM_Y" );
	#endif
	#ifdef GL_TEXTURE_ENV
		swigIntConstant( GL_TEXTURE_ENV, "GL_TEXTURE_ENV" );
	#endif
	#ifdef GL_TEXTURE_ENV_MODE
		swigIntConstant( GL_TEXTURE_ENV_MODE, "GL_TEXTURE_ENV_MODE" );
	#endif
	#ifdef GL_TEXTURE_1D
		swigIntConstant( GL_TEXTURE_1D, "GL_TEXTURE_1D" );
	#endif
	#ifdef GL_TEXTURE_2D
		swigIntConstant( GL_TEXTURE_2D, "GL_TEXTURE_2D" );
	#endif
	#ifdef GL_TEXTURE_WRAP_S
		swigIntConstant( GL_TEXTURE_WRAP_S, "GL_TEXTURE_WRAP_S" );
	#endif
	#ifdef GL_TEXTURE_WRAP_T
		swigIntConstant( GL_TEXTURE_WRAP_T, "GL_TEXTURE_WRAP_T" );
	#endif
	#ifdef GL_TEXTURE_MAG_FILTER
		swigIntConstant( GL_TEXTURE_MAG_FILTER, "GL_TEXTURE_MAG_FILTER" );
	#endif
	#ifdef GL_TEXTURE_MIN_FILTER
		swigIntConstant( GL_TEXTURE_MIN_FILTER, "GL_TEXTURE_MIN_FILTER" );
	#endif
	#ifdef GL_TEXTURE_ENV_COLOR
		swigIntConstant( GL_TEXTURE_ENV_COLOR, "GL_TEXTURE_ENV_COLOR" );
	#endif
	#ifdef GL_TEXTURE_GEN_S
		swigIntConstant( GL_TEXTURE_GEN_S, "GL_TEXTURE_GEN_S" );
	#endif
	#ifdef GL_TEXTURE_GEN_T
		swigIntConstant( GL_TEXTURE_GEN_T, "GL_TEXTURE_GEN_T" );
	#endif
	#ifdef GL_TEXTURE_GEN_R
		swigIntConstant( GL_TEXTURE_GEN_R, "GL_TEXTURE_GEN_R" );
	#endif
	#ifdef GL_TEXTURE_GEN_Q
		swigIntConstant( GL_TEXTURE_GEN_Q, "GL_TEXTURE_GEN_Q" );
	#endif
	#ifdef GL_TEXTURE_GEN_MODE
		swigIntConstant( GL_TEXTURE_GEN_MODE, "GL_TEXTURE_GEN_MODE" );
	#endif
	#ifdef GL_TEXTURE_BORDER_COLOR
		swigIntConstant( GL_TEXTURE_BORDER_COLOR, "GL_TEXTURE_BORDER_COLOR" );
	#endif
	#ifdef GL_TEXTURE_WIDTH
		swigIntConstant( GL_TEXTURE_WIDTH, "GL_TEXTURE_WIDTH" );
	#endif
	#ifdef GL_TEXTURE_HEIGHT
		swigIntConstant( GL_TEXTURE_HEIGHT, "GL_TEXTURE_HEIGHT" );
	#endif
	#ifdef GL_TEXTURE_BORDER
		swigIntConstant( GL_TEXTURE_BORDER, "GL_TEXTURE_BORDER" );
	#endif
	#ifdef GL_TEXTURE_COMPONENTS
		swigIntConstant( GL_TEXTURE_COMPONENTS, "GL_TEXTURE_COMPONENTS" );
	#endif
	#ifdef GL_TEXTURE_RED_SIZE
		swigIntConstant( GL_TEXTURE_RED_SIZE, "GL_TEXTURE_RED_SIZE" );
	#endif
	#ifdef GL_TEXTURE_GREEN_SIZE
		swigIntConstant( GL_TEXTURE_GREEN_SIZE, "GL_TEXTURE_GREEN_SIZE" );
	#endif
	#ifdef GL_TEXTURE_BLUE_SIZE
		swigIntConstant( GL_TEXTURE_BLUE_SIZE, "GL_TEXTURE_BLUE_SIZE" );
	#endif
	#ifdef GL_TEXTURE_ALPHA_SIZE
		swigIntConstant( GL_TEXTURE_ALPHA_SIZE, "GL_TEXTURE_ALPHA_SIZE" );
	#endif
	#ifdef GL_TEXTURE_LUMINANCE_SIZE
		swigIntConstant( GL_TEXTURE_LUMINANCE_SIZE, "GL_TEXTURE_LUMINANCE_SIZE" );
	#endif
	#ifdef GL_TEXTURE_INTENSITY_SIZE
		swigIntConstant( GL_TEXTURE_INTENSITY_SIZE, "GL_TEXTURE_INTENSITY_SIZE" );
	#endif
	#ifdef GL_NEAREST_MIPMAP_NEAREST
		swigIntConstant( GL_NEAREST_MIPMAP_NEAREST, "GL_NEAREST_MIPMAP_NEAREST" );
	#endif
	#ifdef GL_NEAREST_MIPMAP_LINEAR
		swigIntConstant( GL_NEAREST_MIPMAP_LINEAR, "GL_NEAREST_MIPMAP_LINEAR" );
	#endif
	#ifdef GL_LINEAR_MIPMAP_NEAREST
		swigIntConstant( GL_LINEAR_MIPMAP_NEAREST, "GL_LINEAR_MIPMAP_NEAREST" );
	#endif
	#ifdef GL_LINEAR_MIPMAP_LINEAR
		swigIntConstant( GL_LINEAR_MIPMAP_LINEAR, "GL_LINEAR_MIPMAP_LINEAR" );
	#endif
	#ifdef GL_OBJECT_LINEAR
		swigIntConstant( GL_OBJECT_LINEAR, "GL_OBJECT_LINEAR" );
	#endif
	#ifdef GL_OBJECT_PLANE
		swigIntConstant( GL_OBJECT_PLANE, "GL_OBJECT_PLANE" );
	#endif
	#ifdef GL_EYE_LINEAR
		swigIntConstant( GL_EYE_LINEAR, "GL_EYE_LINEAR" );
	#endif
	#ifdef GL_EYE_PLANE
		swigIntConstant( GL_EYE_PLANE, "GL_EYE_PLANE" );
	#endif
	#ifdef GL_SPHERE_MAP
		swigIntConstant( GL_SPHERE_MAP, "GL_SPHERE_MAP" );
	#endif
	#ifdef GL_DECAL
		swigIntConstant( GL_DECAL, "GL_DECAL" );
	#endif
	#ifdef GL_MODULATE
		swigIntConstant( GL_MODULATE, "GL_MODULATE" );
	#endif
	#ifdef GL_NEAREST
		swigIntConstant( GL_NEAREST, "GL_NEAREST" );
	#endif
	#ifdef GL_REPEAT
		swigIntConstant( GL_REPEAT, "GL_REPEAT" );
	#endif
	#ifdef GL_CLAMP
		swigIntConstant( GL_CLAMP, "GL_CLAMP" );
	#endif
	#ifdef GL_S
		swigIntConstant( GL_S, "GL_S" );
	#endif
	#ifdef GL_T
		swigIntConstant( GL_T, "GL_T" );
	#endif
	#ifdef GL_R
		swigIntConstant( GL_R, "GL_R" );
	#endif
	#ifdef GL_Q
		swigIntConstant( GL_Q, "GL_Q" );
	#endif
	#ifdef GL_VENDOR
		swigIntConstant( GL_VENDOR, "GL_VENDOR" );
	#endif
	#ifdef GL_RENDERER
		swigIntConstant( GL_RENDERER, "GL_RENDERER" );
	#endif
	#ifdef GL_VERSION
		swigIntConstant( GL_VERSION, "GL_VERSION" );
	#endif
	#ifdef GL_EXTENSIONS
		swigIntConstant( GL_EXTENSIONS, "GL_EXTENSIONS" );
	#endif
	#ifdef GL_NO_ERROR
		swigIntConstant( GL_NO_ERROR, "GL_NO_ERROR" );
	#endif
	#ifdef GL_INVALID_ENUM
		swigIntConstant( GL_INVALID_ENUM, "GL_INVALID_ENUM" );
	#endif
	#ifdef GL_INVALID_VALUE
		swigIntConstant( GL_INVALID_VALUE, "GL_INVALID_VALUE" );
	#endif
	#ifdef GL_INVALID_OPERATION
		swigIntConstant( GL_INVALID_OPERATION, "GL_INVALID_OPERATION" );
	#endif
	#ifdef GL_STACK_OVERFLOW
		swigIntConstant( GL_STACK_OVERFLOW, "GL_STACK_OVERFLOW" );
	#endif
	#ifdef GL_STACK_UNDERFLOW
		swigIntConstant( GL_STACK_UNDERFLOW, "GL_STACK_UNDERFLOW" );
	#endif
	#ifdef GL_OUT_OF_MEMORY
		swigIntConstant( GL_OUT_OF_MEMORY, "GL_OUT_OF_MEMORY" );
	#endif
	#ifdef GL_CURRENT_BIT
		swigIntConstant( GL_CURRENT_BIT, "GL_CURRENT_BIT" );
	#endif
	#ifdef GL_POINT_BIT
		swigIntConstant( GL_POINT_BIT, "GL_POINT_BIT" );
	#endif
	#ifdef GL_LINE_BIT
		swigIntConstant( GL_LINE_BIT, "GL_LINE_BIT" );
	#endif
	#ifdef GL_POLYGON_BIT
		swigIntConstant( GL_POLYGON_BIT, "GL_POLYGON_BIT" );
	#endif
	#ifdef GL_POLYGON_STIPPLE_BIT
		swigIntConstant( GL_POLYGON_STIPPLE_BIT, "GL_POLYGON_STIPPLE_BIT" );
	#endif
	#ifdef GL_PIXEL_MODE_BIT
		swigIntConstant( GL_PIXEL_MODE_BIT, "GL_PIXEL_MODE_BIT" );
	#endif
	#ifdef GL_LIGHTING_BIT
		swigIntConstant( GL_LIGHTING_BIT, "GL_LIGHTING_BIT" );
	#endif
	#ifdef GL_FOG_BIT
		swigIntConstant( GL_FOG_BIT, "GL_FOG_BIT" );
	#endif
	#ifdef GL_DEPTH_BUFFER_BIT
		swigIntConstant( GL_DEPTH_BUFFER_BIT, "GL_DEPTH_BUFFER_BIT" );
	#endif
	#ifdef GL_ACCUM_BUFFER_BIT
		swigIntConstant( GL_ACCUM_BUFFER_BIT, "GL_ACCUM_BUFFER_BIT" );
	#endif
	#ifdef GL_STENCIL_BUFFER_BIT
		swigIntConstant( GL_STENCIL_BUFFER_BIT, "GL_STENCIL_BUFFER_BIT" );
	#endif
	#ifdef GL_VIEWPORT_BIT
		swigIntConstant( GL_VIEWPORT_BIT, "GL_VIEWPORT_BIT" );
	#endif
	#ifdef GL_TRANSFORM_BIT
		swigIntConstant( GL_TRANSFORM_BIT, "GL_TRANSFORM_BIT" );
	#endif
	#ifdef GL_ENABLE_BIT
		swigIntConstant( GL_ENABLE_BIT, "GL_ENABLE_BIT" );
	#endif
	#ifdef GL_COLOR_BUFFER_BIT
		swigIntConstant( GL_COLOR_BUFFER_BIT, "GL_COLOR_BUFFER_BIT" );
	#endif
	#ifdef GL_HINT_BIT
		swigIntConstant( GL_HINT_BIT, "GL_HINT_BIT" );
	#endif
	#ifdef GL_EVAL_BIT
		swigIntConstant( GL_EVAL_BIT, "GL_EVAL_BIT" );
	#endif
	#ifdef GL_LIST_BIT
		swigIntConstant( GL_LIST_BIT, "GL_LIST_BIT" );
	#endif
	#ifdef GL_TEXTURE_BIT
		swigIntConstant( GL_TEXTURE_BIT, "GL_TEXTURE_BIT" );
	#endif
	#ifdef GL_SCISSOR_BIT
		swigIntConstant( GL_SCISSOR_BIT, "GL_SCISSOR_BIT" );
	#endif
	#ifdef GL_ALL_ATTRIB_BITS
		swigIntConstant( GL_ALL_ATTRIB_BITS, "GL_ALL_ATTRIB_BITS" );
	#endif
	#ifdef GL_PROXY_TEXTURE_1D
		swigIntConstant( GL_PROXY_TEXTURE_1D, "GL_PROXY_TEXTURE_1D" );
	#endif
	#ifdef GL_PROXY_TEXTURE_2D
		swigIntConstant( GL_PROXY_TEXTURE_2D, "GL_PROXY_TEXTURE_2D" );
	#endif
	#ifdef GL_TEXTURE_PRIORITY
		swigIntConstant( GL_TEXTURE_PRIORITY, "GL_TEXTURE_PRIORITY" );
	#endif
	#ifdef GL_TEXTURE_RESIDENT
		swigIntConstant( GL_TEXTURE_RESIDENT, "GL_TEXTURE_RESIDENT" );
	#endif
	#ifdef GL_TEXTURE_BINDING_1D
		swigIntConstant( GL_TEXTURE_BINDING_1D, "GL_TEXTURE_BINDING_1D" );
	#endif
	#ifdef GL_TEXTURE_BINDING_2D
		swigIntConstant( GL_TEXTURE_BINDING_2D, "GL_TEXTURE_BINDING_2D" );
	#endif
	#ifdef GL_TEXTURE_INTERNAL_FORMAT
		swigIntConstant( GL_TEXTURE_INTERNAL_FORMAT, "GL_TEXTURE_INTERNAL_FORMAT" );
	#endif
	#ifdef GL_ALPHA4
		swigIntConstant( GL_ALPHA4, "GL_ALPHA4" );
	#endif
	#ifdef GL_ALPHA8
		swigIntConstant( GL_ALPHA8, "GL_ALPHA8" );
	#endif
	#ifdef GL_ALPHA12
		swigIntConstant( GL_ALPHA12, "GL_ALPHA12" );
	#endif
	#ifdef GL_ALPHA16
		swigIntConstant( GL_ALPHA16, "GL_ALPHA16" );
	#endif
	#ifdef GL_LUMINANCE4
		swigIntConstant( GL_LUMINANCE4, "GL_LUMINANCE4" );
	#endif
	#ifdef GL_LUMINANCE8
		swigIntConstant( GL_LUMINANCE8, "GL_LUMINANCE8" );
	#endif
	#ifdef GL_LUMINANCE12
		swigIntConstant( GL_LUMINANCE12, "GL_LUMINANCE12" );
	#endif
	#ifdef GL_LUMINANCE16
		swigIntConstant( GL_LUMINANCE16, "GL_LUMINANCE16" );
	#endif
	#ifdef GL_LUMINANCE4_ALPHA4
		swigIntConstant( GL_LUMINANCE4_ALPHA4, "GL_LUMINANCE4_ALPHA4" );
	#endif
	#ifdef GL_LUMINANCE6_ALPHA2
		swigIntConstant( GL_LUMINANCE6_ALPHA2, "GL_LUMINANCE6_ALPHA2" );
	#endif
	#ifdef GL_LUMINANCE8_ALPHA8
		swigIntConstant( GL_LUMINANCE8_ALPHA8, "GL_LUMINANCE8_ALPHA8" );
	#endif
	#ifdef GL_LUMINANCE12_ALPHA4
		swigIntConstant( GL_LUMINANCE12_ALPHA4, "GL_LUMINANCE12_ALPHA4" );
	#endif
	#ifdef GL_LUMINANCE12_ALPHA12
		swigIntConstant( GL_LUMINANCE12_ALPHA12, "GL_LUMINANCE12_ALPHA12" );
	#endif
	#ifdef GL_LUMINANCE16_ALPHA16
		swigIntConstant( GL_LUMINANCE16_ALPHA16, "GL_LUMINANCE16_ALPHA16" );
	#endif
	#ifdef GL_INTENSITY
		swigIntConstant( GL_INTENSITY, "GL_INTENSITY" );
	#endif
	#ifdef GL_INTENSITY4
		swigIntConstant( GL_INTENSITY4, "GL_INTENSITY4" );
	#endif
	#ifdef GL_INTENSITY8
		swigIntConstant( GL_INTENSITY8, "GL_INTENSITY8" );
	#endif
	#ifdef GL_INTENSITY12
		swigIntConstant( GL_INTENSITY12, "GL_INTENSITY12" );
	#endif
	#ifdef GL_INTENSITY16
		swigIntConstant( GL_INTENSITY16, "GL_INTENSITY16" );
	#endif
	#ifdef GL_R3_G3_B2
		swigIntConstant( GL_R3_G3_B2, "GL_R3_G3_B2" );
	#endif
	#ifdef GL_RGB4
		swigIntConstant( GL_RGB4, "GL_RGB4" );
	#endif
	#ifdef GL_RGB5
		swigIntConstant( GL_RGB5, "GL_RGB5" );
	#endif
	#ifdef GL_RGB8
		swigIntConstant( GL_RGB8, "GL_RGB8" );
	#endif
	#ifdef GL_RGB10
		swigIntConstant( GL_RGB10, "GL_RGB10" );
	#endif
	#ifdef GL_RGB12
		swigIntConstant( GL_RGB12, "GL_RGB12" );
	#endif
	#ifdef GL_RGB16
		swigIntConstant( GL_RGB16, "GL_RGB16" );
	#endif
	#ifdef GL_RGBA2
		swigIntConstant( GL_RGBA2, "GL_RGBA2" );
	#endif
	#ifdef GL_RGBA4
		swigIntConstant( GL_RGBA4, "GL_RGBA4" );
	#endif
	#ifdef GL_RGB5_A1
		swigIntConstant( GL_RGB5_A1, "GL_RGB5_A1" );
	#endif
	#ifdef GL_RGBA8
		swigIntConstant( GL_RGBA8, "GL_RGBA8" );
	#endif
	#ifdef GL_RGB10_A2
		swigIntConstant( GL_RGB10_A2, "GL_RGB10_A2" );
	#endif
	#ifdef GL_RGBA12
		swigIntConstant( GL_RGBA12, "GL_RGBA12" );
	#endif
	#ifdef GL_RGBA16
		swigIntConstant( GL_RGBA16, "GL_RGBA16" );
	#endif
	#ifdef GL_CLIENT_PIXEL_STORE_BIT
		swigIntConstant( GL_CLIENT_PIXEL_STORE_BIT, "GL_CLIENT_PIXEL_STORE_BIT" );
	#endif
	#ifdef GL_CLIENT_VERTEX_ARRAY_BIT
		swigIntConstant( GL_CLIENT_VERTEX_ARRAY_BIT, "GL_CLIENT_VERTEX_ARRAY_BIT" );
	#endif
	#ifdef GL_ALL_CLIENT_ATTRIB_BITS
		swigIntConstant( GL_ALL_CLIENT_ATTRIB_BITS, "GL_ALL_CLIENT_ATTRIB_BITS" );
	#endif
	#ifdef GL_CLIENT_ALL_ATTRIB_BITS
		swigIntConstant( GL_CLIENT_ALL_ATTRIB_BITS, "GL_CLIENT_ALL_ATTRIB_BITS" );
	#endif
	#ifdef GL_RESCALE_NORMAL
		swigIntConstant( GL_RESCALE_NORMAL, "GL_RESCALE_NORMAL" );
	#endif
	#ifdef GL_CLAMP_TO_EDGE
		swigIntConstant( GL_CLAMP_TO_EDGE, "GL_CLAMP_TO_EDGE" );
	#endif
	#ifdef GL_MAX_ELEMENTS_VERTICES
		swigIntConstant( GL_MAX_ELEMENTS_VERTICES, "GL_MAX_ELEMENTS_VERTICES" );
	#endif
	#ifdef GL_MAX_ELEMENTS_INDICES
		swigIntConstant( GL_MAX_ELEMENTS_INDICES, "GL_MAX_ELEMENTS_INDICES" );
	#endif
	#ifdef GL_BGR
		swigIntConstant( GL_BGR, "GL_BGR" );
	#endif
	#ifdef GL_BGRA
		swigIntConstant( GL_BGRA, "GL_BGRA" );
	#endif
	#ifdef GL_UNSIGNED_BYTE_3_3_2
		swigIntConstant( GL_UNSIGNED_BYTE_3_3_2, "GL_UNSIGNED_BYTE_3_3_2" );
	#endif
	#ifdef GL_UNSIGNED_BYTE_2_3_3_REV
		swigIntConstant( GL_UNSIGNED_BYTE_2_3_3_REV, "GL_UNSIGNED_BYTE_2_3_3_REV" );
	#endif
	#ifdef GL_UNSIGNED_SHORT_5_6_5
		swigIntConstant( GL_UNSIGNED_SHORT_5_6_5, "GL_UNSIGNED_SHORT_5_6_5" );
	#endif
	#ifdef GL_UNSIGNED_SHORT_5_6_5_REV
		swigIntConstant( GL_UNSIGNED_SHORT_5_6_5_REV, "GL_UNSIGNED_SHORT_5_6_5_REV" );
	#endif
	#ifdef GL_UNSIGNED_SHORT_4_4_4_4
		swigIntConstant( GL_UNSIGNED_SHORT_4_4_4_4, "GL_UNSIGNED_SHORT_4_4_4_4" );
	#endif
	#ifdef GL_UNSIGNED_SHORT_4_4_4_4_REV
		swigIntConstant( GL_UNSIGNED_SHORT_4_4_4_4_REV, "GL_UNSIGNED_SHORT_4_4_4_4_REV" );
	#endif
	#ifdef GL_UNSIGNED_SHORT_5_5_5_1
		swigIntConstant( GL_UNSIGNED_SHORT_5_5_5_1, "GL_UNSIGNED_SHORT_5_5_5_1" );
	#endif
	#ifdef GL_UNSIGNED_SHORT_1_5_5_5_REV
		swigIntConstant( GL_UNSIGNED_SHORT_1_5_5_5_REV, "GL_UNSIGNED_SHORT_1_5_5_5_REV" );
	#endif
	#ifdef GL_UNSIGNED_INT_8_8_8_8
		swigIntConstant( GL_UNSIGNED_INT_8_8_8_8, "GL_UNSIGNED_INT_8_8_8_8" );
	#endif
	#ifdef GL_UNSIGNED_INT_8_8_8_8_REV
		swigIntConstant( GL_UNSIGNED_INT_8_8_8_8_REV, "GL_UNSIGNED_INT_8_8_8_8_REV" );
	#endif
	#ifdef GL_UNSIGNED_INT_10_10_10_2
		swigIntConstant( GL_UNSIGNED_INT_10_10_10_2, "GL_UNSIGNED_INT_10_10_10_2" );
	#endif
	#ifdef GL_UNSIGNED_INT_2_10_10_10_REV
		swigIntConstant( GL_UNSIGNED_INT_2_10_10_10_REV, "GL_UNSIGNED_INT_2_10_10_10_REV" );
	#endif
	#ifdef GL_LIGHT_MODEL_COLOR_CONTROL
		swigIntConstant( GL_LIGHT_MODEL_COLOR_CONTROL, "GL_LIGHT_MODEL_COLOR_CONTROL" );
	#endif
	#ifdef GL_SINGLE_COLOR
		swigIntConstant( GL_SINGLE_COLOR, "GL_SINGLE_COLOR" );
	#endif
	#ifdef GL_SEPARATE_SPECULAR_COLOR
		swigIntConstant( GL_SEPARATE_SPECULAR_COLOR, "GL_SEPARATE_SPECULAR_COLOR" );
	#endif
	#ifdef GL_TEXTURE_MIN_LOD
		swigIntConstant( GL_TEXTURE_MIN_LOD, "GL_TEXTURE_MIN_LOD" );
	#endif
	#ifdef GL_TEXTURE_MAX_LOD
		swigIntConstant( GL_TEXTURE_MAX_LOD, "GL_TEXTURE_MAX_LOD" );
	#endif
	#ifdef GL_TEXTURE_BASE_LEVEL
		swigIntConstant( GL_TEXTURE_BASE_LEVEL, "GL_TEXTURE_BASE_LEVEL" );
	#endif
	#ifdef GL_TEXTURE_MAX_LEVEL
		swigIntConstant( GL_TEXTURE_MAX_LEVEL, "GL_TEXTURE_MAX_LEVEL" );
	#endif
	#ifdef GL_SMOOTH_POINT_SIZE_RANGE
		swigIntConstant( GL_SMOOTH_POINT_SIZE_RANGE, "GL_SMOOTH_POINT_SIZE_RANGE" );
	#endif
	#ifdef GL_SMOOTH_POINT_SIZE_GRANULARITY
		swigIntConstant( GL_SMOOTH_POINT_SIZE_GRANULARITY, "GL_SMOOTH_POINT_SIZE_GRANULARITY" );
	#endif
	#ifdef GL_SMOOTH_LINE_WIDTH_RANGE
		swigIntConstant( GL_SMOOTH_LINE_WIDTH_RANGE, "GL_SMOOTH_LINE_WIDTH_RANGE" );
	#endif
	#ifdef GL_SMOOTH_LINE_WIDTH_GRANULARITY
		swigIntConstant( GL_SMOOTH_LINE_WIDTH_GRANULARITY, "GL_SMOOTH_LINE_WIDTH_GRANULARITY" );
	#endif
	#ifdef GL_ALIASED_POINT_SIZE_RANGE
		swigIntConstant( GL_ALIASED_POINT_SIZE_RANGE, "GL_ALIASED_POINT_SIZE_RANGE" );
	#endif
	#ifdef GL_ALIASED_LINE_WIDTH_RANGE
		swigIntConstant( GL_ALIASED_LINE_WIDTH_RANGE, "GL_ALIASED_LINE_WIDTH_RANGE" );
	#endif
	#ifdef GL_PACK_SKIP_IMAGES
		swigIntConstant( GL_PACK_SKIP_IMAGES, "GL_PACK_SKIP_IMAGES" );
	#endif
	#ifdef GL_PACK_IMAGE_HEIGHT
		swigIntConstant( GL_PACK_IMAGE_HEIGHT, "GL_PACK_IMAGE_HEIGHT" );
	#endif
	#ifdef GL_UNPACK_SKIP_IMAGES
		swigIntConstant( GL_UNPACK_SKIP_IMAGES, "GL_UNPACK_SKIP_IMAGES" );
	#endif
	#ifdef GL_UNPACK_IMAGE_HEIGHT
		swigIntConstant( GL_UNPACK_IMAGE_HEIGHT, "GL_UNPACK_IMAGE_HEIGHT" );
	#endif
	#ifdef GL_TEXTURE_3D
		swigIntConstant( GL_TEXTURE_3D, "GL_TEXTURE_3D" );
	#endif
	#ifdef GL_PROXY_TEXTURE_3D
		swigIntConstant( GL_PROXY_TEXTURE_3D, "GL_PROXY_TEXTURE_3D" );
	#endif
	#ifdef GL_TEXTURE_DEPTH
		swigIntConstant( GL_TEXTURE_DEPTH, "GL_TEXTURE_DEPTH" );
	#endif
	#ifdef GL_TEXTURE_WRAP_R
		swigIntConstant( GL_TEXTURE_WRAP_R, "GL_TEXTURE_WRAP_R" );
	#endif
	#ifdef GL_MAX_3D_TEXTURE_SIZE
		swigIntConstant( GL_MAX_3D_TEXTURE_SIZE, "GL_MAX_3D_TEXTURE_SIZE" );
	#endif
	#ifdef GL_TEXTURE_BINDING_3D
		swigIntConstant( GL_TEXTURE_BINDING_3D, "GL_TEXTURE_BINDING_3D" );
	#endif
	#ifdef GL_CONSTANT_COLOR
		swigIntConstant( GL_CONSTANT_COLOR, "GL_CONSTANT_COLOR" );
	#endif
	#ifdef GL_ONE_MINUS_CONSTANT_COLOR
		swigIntConstant( GL_ONE_MINUS_CONSTANT_COLOR, "GL_ONE_MINUS_CONSTANT_COLOR" );
	#endif
	#ifdef GL_CONSTANT_ALPHA
		swigIntConstant( GL_CONSTANT_ALPHA, "GL_CONSTANT_ALPHA" );
	#endif
	#ifdef GL_ONE_MINUS_CONSTANT_ALPHA
		swigIntConstant( GL_ONE_MINUS_CONSTANT_ALPHA, "GL_ONE_MINUS_CONSTANT_ALPHA" );
	#endif
	#ifdef GL_COLOR_TABLE
		swigIntConstant( GL_COLOR_TABLE, "GL_COLOR_TABLE" );
	#endif
	#ifdef GL_POST_CONVOLUTION_COLOR_TABLE
		swigIntConstant( GL_POST_CONVOLUTION_COLOR_TABLE, "GL_POST_CONVOLUTION_COLOR_TABLE" );
	#endif
	#ifdef GL_POST_COLOR_MATRIX_COLOR_TABLE
		swigIntConstant( GL_POST_COLOR_MATRIX_COLOR_TABLE, "GL_POST_COLOR_MATRIX_COLOR_TABLE" );
	#endif
	#ifdef GL_PROXY_COLOR_TABLE
		swigIntConstant( GL_PROXY_COLOR_TABLE, "GL_PROXY_COLOR_TABLE" );
	#endif
	#ifdef GL_PROXY_POST_CONVOLUTION_COLOR_TABLE
		swigIntConstant( GL_PROXY_POST_CONVOLUTION_COLOR_TABLE, "GL_PROXY_POST_CONVOLUTION_COLOR_TABLE" );
	#endif
	#ifdef GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE
		swigIntConstant( GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE, "GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE" );
	#endif
	#ifdef GL_COLOR_TABLE_SCALE
		swigIntConstant( GL_COLOR_TABLE_SCALE, "GL_COLOR_TABLE_SCALE" );
	#endif
	#ifdef GL_COLOR_TABLE_BIAS
		swigIntConstant( GL_COLOR_TABLE_BIAS, "GL_COLOR_TABLE_BIAS" );
	#endif
	#ifdef GL_COLOR_TABLE_FORMAT
		swigIntConstant( GL_COLOR_TABLE_FORMAT, "GL_COLOR_TABLE_FORMAT" );
	#endif
	#ifdef GL_COLOR_TABLE_WIDTH
		swigIntConstant( GL_COLOR_TABLE_WIDTH, "GL_COLOR_TABLE_WIDTH" );
	#endif
	#ifdef GL_COLOR_TABLE_RED_SIZE
		swigIntConstant( GL_COLOR_TABLE_RED_SIZE, "GL_COLOR_TABLE_RED_SIZE" );
	#endif
	#ifdef GL_COLOR_TABLE_GREEN_SIZE
		swigIntConstant( GL_COLOR_TABLE_GREEN_SIZE, "GL_COLOR_TABLE_GREEN_SIZE" );
	#endif
	#ifdef GL_COLOR_TABLE_BLUE_SIZE
		swigIntConstant( GL_COLOR_TABLE_BLUE_SIZE, "GL_COLOR_TABLE_BLUE_SIZE" );
	#endif
	#ifdef GL_COLOR_TABLE_ALPHA_SIZE
		swigIntConstant( GL_COLOR_TABLE_ALPHA_SIZE, "GL_COLOR_TABLE_ALPHA_SIZE" );
	#endif
	#ifdef GL_COLOR_TABLE_LUMINANCE_SIZE
		swigIntConstant( GL_COLOR_TABLE_LUMINANCE_SIZE, "GL_COLOR_TABLE_LUMINANCE_SIZE" );
	#endif
	#ifdef GL_COLOR_TABLE_INTENSITY_SIZE
		swigIntConstant( GL_COLOR_TABLE_INTENSITY_SIZE, "GL_COLOR_TABLE_INTENSITY_SIZE" );
	#endif
	#ifdef GL_CONVOLUTION_1D
		swigIntConstant( GL_CONVOLUTION_1D, "GL_CONVOLUTION_1D" );
	#endif
	#ifdef GL_CONVOLUTION_2D
		swigIntConstant( GL_CONVOLUTION_2D, "GL_CONVOLUTION_2D" );
	#endif
	#ifdef GL_SEPARABLE_2D
		swigIntConstant( GL_SEPARABLE_2D, "GL_SEPARABLE_2D" );
	#endif
	#ifdef GL_CONVOLUTION_BORDER_MODE
		swigIntConstant( GL_CONVOLUTION_BORDER_MODE, "GL_CONVOLUTION_BORDER_MODE" );
	#endif
	#ifdef GL_CONVOLUTION_FILTER_SCALE
		swigIntConstant( GL_CONVOLUTION_FILTER_SCALE, "GL_CONVOLUTION_FILTER_SCALE" );
	#endif
	#ifdef GL_CONVOLUTION_FILTER_BIAS
		swigIntConstant( GL_CONVOLUTION_FILTER_BIAS, "GL_CONVOLUTION_FILTER_BIAS" );
	#endif
	#ifdef GL_REDUCE
		swigIntConstant( GL_REDUCE, "GL_REDUCE" );
	#endif
	#ifdef GL_CONVOLUTION_FORMAT
		swigIntConstant( GL_CONVOLUTION_FORMAT, "GL_CONVOLUTION_FORMAT" );
	#endif
	#ifdef GL_CONVOLUTION_WIDTH
		swigIntConstant( GL_CONVOLUTION_WIDTH, "GL_CONVOLUTION_WIDTH" );
	#endif
	#ifdef GL_CONVOLUTION_HEIGHT
		swigIntConstant( GL_CONVOLUTION_HEIGHT, "GL_CONVOLUTION_HEIGHT" );
	#endif
	#ifdef GL_MAX_CONVOLUTION_WIDTH
		swigIntConstant( GL_MAX_CONVOLUTION_WIDTH, "GL_MAX_CONVOLUTION_WIDTH" );
	#endif
	#ifdef GL_MAX_CONVOLUTION_HEIGHT
		swigIntConstant( GL_MAX_CONVOLUTION_HEIGHT, "GL_MAX_CONVOLUTION_HEIGHT" );
	#endif
	#ifdef GL_POST_CONVOLUTION_RED_SCALE
		swigIntConstant( GL_POST_CONVOLUTION_RED_SCALE, "GL_POST_CONVOLUTION_RED_SCALE" );
	#endif
	#ifdef GL_POST_CONVOLUTION_GREEN_SCALE
		swigIntConstant( GL_POST_CONVOLUTION_GREEN_SCALE, "GL_POST_CONVOLUTION_GREEN_SCALE" );
	#endif
	#ifdef GL_POST_CONVOLUTION_BLUE_SCALE
		swigIntConstant( GL_POST_CONVOLUTION_BLUE_SCALE, "GL_POST_CONVOLUTION_BLUE_SCALE" );
	#endif
	#ifdef GL_POST_CONVOLUTION_ALPHA_SCALE
		swigIntConstant( GL_POST_CONVOLUTION_ALPHA_SCALE, "GL_POST_CONVOLUTION_ALPHA_SCALE" );
	#endif
	#ifdef GL_POST_CONVOLUTION_RED_BIAS
		swigIntConstant( GL_POST_CONVOLUTION_RED_BIAS, "GL_POST_CONVOLUTION_RED_BIAS" );
	#endif
	#ifdef GL_POST_CONVOLUTION_GREEN_BIAS
		swigIntConstant( GL_POST_CONVOLUTION_GREEN_BIAS, "GL_POST_CONVOLUTION_GREEN_BIAS" );
	#endif
	#ifdef GL_POST_CONVOLUTION_BLUE_BIAS
		swigIntConstant( GL_POST_CONVOLUTION_BLUE_BIAS, "GL_POST_CONVOLUTION_BLUE_BIAS" );
	#endif
	#ifdef GL_POST_CONVOLUTION_ALPHA_BIAS
		swigIntConstant( GL_POST_CONVOLUTION_ALPHA_BIAS, "GL_POST_CONVOLUTION_ALPHA_BIAS" );
	#endif
	#ifdef GL_CONSTANT_BORDER
		swigIntConstant( GL_CONSTANT_BORDER, "GL_CONSTANT_BORDER" );
	#endif
	#ifdef GL_REPLICATE_BORDER
		swigIntConstant( GL_REPLICATE_BORDER, "GL_REPLICATE_BORDER" );
	#endif
	#ifdef GL_CONVOLUTION_BORDER_COLOR
		swigIntConstant( GL_CONVOLUTION_BORDER_COLOR, "GL_CONVOLUTION_BORDER_COLOR" );
	#endif
	#ifdef GL_COLOR_MATRIX
		swigIntConstant( GL_COLOR_MATRIX, "GL_COLOR_MATRIX" );
	#endif
	#ifdef GL_COLOR_MATRIX_STACK_DEPTH
		swigIntConstant( GL_COLOR_MATRIX_STACK_DEPTH, "GL_COLOR_MATRIX_STACK_DEPTH" );
	#endif
	#ifdef GL_MAX_COLOR_MATRIX_STACK_DEPTH
		swigIntConstant( GL_MAX_COLOR_MATRIX_STACK_DEPTH, "GL_MAX_COLOR_MATRIX_STACK_DEPTH" );
	#endif
	#ifdef GL_POST_COLOR_MATRIX_RED_SCALE
		swigIntConstant( GL_POST_COLOR_MATRIX_RED_SCALE, "GL_POST_COLOR_MATRIX_RED_SCALE" );
	#endif
	#ifdef GL_POST_COLOR_MATRIX_GREEN_SCALE
		swigIntConstant( GL_POST_COLOR_MATRIX_GREEN_SCALE, "GL_POST_COLOR_MATRIX_GREEN_SCALE" );
	#endif
	#ifdef GL_POST_COLOR_MATRIX_BLUE_SCALE
		swigIntConstant( GL_POST_COLOR_MATRIX_BLUE_SCALE, "GL_POST_COLOR_MATRIX_BLUE_SCALE" );
	#endif
	#ifdef GL_POST_COLOR_MATRIX_ALPHA_SCALE
		swigIntConstant( GL_POST_COLOR_MATRIX_ALPHA_SCALE, "GL_POST_COLOR_MATRIX_ALPHA_SCALE" );
	#endif
	#ifdef GL_POST_COLOR_MATRIX_RED_BIAS
		swigIntConstant( GL_POST_COLOR_MATRIX_RED_BIAS, "GL_POST_COLOR_MATRIX_RED_BIAS" );
	#endif
	#ifdef GL_POST_COLOR_MATRIX_GREEN_BIAS
		swigIntConstant( GL_POST_COLOR_MATRIX_GREEN_BIAS, "GL_POST_COLOR_MATRIX_GREEN_BIAS" );
	#endif
	#ifdef GL_POST_COLOR_MATRIX_BLUE_BIAS
		swigIntConstant( GL_POST_COLOR_MATRIX_BLUE_BIAS, "GL_POST_COLOR_MATRIX_BLUE_BIAS" );
	#endif
	#ifdef GL_POST_COLOR_MATRIX_ALPHA_BIAS
		swigIntConstant( GL_POST_COLOR_MATRIX_ALPHA_BIAS, "GL_POST_COLOR_MATRIX_ALPHA_BIAS" );
	#endif
	#ifdef GL_HISTOGRAM
		swigIntConstant( GL_HISTOGRAM, "GL_HISTOGRAM" );
	#endif
	#ifdef GL_PROXY_HISTOGRAM
		swigIntConstant( GL_PROXY_HISTOGRAM, "GL_PROXY_HISTOGRAM" );
	#endif
	#ifdef GL_HISTOGRAM_WIDTH
		swigIntConstant( GL_HISTOGRAM_WIDTH, "GL_HISTOGRAM_WIDTH" );
	#endif
	#ifdef GL_HISTOGRAM_FORMAT
		swigIntConstant( GL_HISTOGRAM_FORMAT, "GL_HISTOGRAM_FORMAT" );
	#endif
	#ifdef GL_HISTOGRAM_RED_SIZE
		swigIntConstant( GL_HISTOGRAM_RED_SIZE, "GL_HISTOGRAM_RED_SIZE" );
	#endif
	#ifdef GL_HISTOGRAM_GREEN_SIZE
		swigIntConstant( GL_HISTOGRAM_GREEN_SIZE, "GL_HISTOGRAM_GREEN_SIZE" );
	#endif
	#ifdef GL_HISTOGRAM_BLUE_SIZE
		swigIntConstant( GL_HISTOGRAM_BLUE_SIZE, "GL_HISTOGRAM_BLUE_SIZE" );
	#endif
	#ifdef GL_HISTOGRAM_ALPHA_SIZE
		swigIntConstant( GL_HISTOGRAM_ALPHA_SIZE, "GL_HISTOGRAM_ALPHA_SIZE" );
	#endif
	#ifdef GL_HISTOGRAM_LUMINANCE_SIZE
		swigIntConstant( GL_HISTOGRAM_LUMINANCE_SIZE, "GL_HISTOGRAM_LUMINANCE_SIZE" );
	#endif
	#ifdef GL_HISTOGRAM_SINK
		swigIntConstant( GL_HISTOGRAM_SINK, "GL_HISTOGRAM_SINK" );
	#endif
	#ifdef GL_MINMAX
		swigIntConstant( GL_MINMAX, "GL_MINMAX" );
	#endif
	#ifdef GL_MINMAX_FORMAT
		swigIntConstant( GL_MINMAX_FORMAT, "GL_MINMAX_FORMAT" );
	#endif
	#ifdef GL_MINMAX_SINK
		swigIntConstant( GL_MINMAX_SINK, "GL_MINMAX_SINK" );
	#endif
	#ifdef GL_TABLE_TOO_LARGE
		swigIntConstant( GL_TABLE_TOO_LARGE, "GL_TABLE_TOO_LARGE" );
	#endif
	#ifdef GL_BLEND_EQUATION
		swigIntConstant( GL_BLEND_EQUATION, "GL_BLEND_EQUATION" );
	#endif
	#ifdef GL_MIN
		swigIntConstant( GL_MIN, "GL_MIN" );
	#endif
	#ifdef GL_MAX
		swigIntConstant( GL_MAX, "GL_MAX" );
	#endif
	#ifdef GL_FUNC_ADD
		swigIntConstant( GL_FUNC_ADD, "GL_FUNC_ADD" );
	#endif
	#ifdef GL_FUNC_SUBTRACT
		swigIntConstant( GL_FUNC_SUBTRACT, "GL_FUNC_SUBTRACT" );
	#endif
	#ifdef GL_FUNC_REVERSE_SUBTRACT
		swigIntConstant( GL_FUNC_REVERSE_SUBTRACT, "GL_FUNC_REVERSE_SUBTRACT" );
	#endif
	#ifdef GL_BLEND_COLOR
		swigIntConstant( GL_BLEND_COLOR, "GL_BLEND_COLOR" );
	#endif
	#ifdef GL_TEXTURE0
		swigIntConstant( GL_TEXTURE0, "GL_TEXTURE0" );
	#endif
	#ifdef GL_TEXTURE1
		swigIntConstant( GL_TEXTURE1, "GL_TEXTURE1" );
	#endif
	#ifdef GL_TEXTURE2
		swigIntConstant( GL_TEXTURE2, "GL_TEXTURE2" );
	#endif
	#ifdef GL_TEXTURE3
		swigIntConstant( GL_TEXTURE3, "GL_TEXTURE3" );
	#endif
	#ifdef GL_TEXTURE4
		swigIntConstant( GL_TEXTURE4, "GL_TEXTURE4" );
	#endif
	#ifdef GL_TEXTURE5
		swigIntConstant( GL_TEXTURE5, "GL_TEXTURE5" );
	#endif
	#ifdef GL_TEXTURE6
		swigIntConstant( GL_TEXTURE6, "GL_TEXTURE6" );
	#endif
	#ifdef GL_TEXTURE7
		swigIntConstant( GL_TEXTURE7, "GL_TEXTURE7" );
	#endif
	#ifdef GL_TEXTURE8
		swigIntConstant( GL_TEXTURE8, "GL_TEXTURE8" );
	#endif
	#ifdef GL_TEXTURE9
		swigIntConstant( GL_TEXTURE9, "GL_TEXTURE9" );
	#endif
	#ifdef GL_TEXTURE10
		swigIntConstant( GL_TEXTURE10, "GL_TEXTURE10" );
	#endif
	#ifdef GL_TEXTURE11
		swigIntConstant( GL_TEXTURE11, "GL_TEXTURE11" );
	#endif
	#ifdef GL_TEXTURE12
		swigIntConstant( GL_TEXTURE12, "GL_TEXTURE12" );
	#endif
	#ifdef GL_TEXTURE13
		swigIntConstant( GL_TEXTURE13, "GL_TEXTURE13" );
	#endif
	#ifdef GL_TEXTURE14
		swigIntConstant( GL_TEXTURE14, "GL_TEXTURE14" );
	#endif
	#ifdef GL_TEXTURE15
		swigIntConstant( GL_TEXTURE15, "GL_TEXTURE15" );
	#endif
	#ifdef GL_TEXTURE16
		swigIntConstant( GL_TEXTURE16, "GL_TEXTURE16" );
	#endif
	#ifdef GL_TEXTURE17
		swigIntConstant( GL_TEXTURE17, "GL_TEXTURE17" );
	#endif
	#ifdef GL_TEXTURE18
		swigIntConstant( GL_TEXTURE18, "GL_TEXTURE18" );
	#endif
	#ifdef GL_TEXTURE19
		swigIntConstant( GL_TEXTURE19, "GL_TEXTURE19" );
	#endif
	#ifdef GL_TEXTURE20
		swigIntConstant( GL_TEXTURE20, "GL_TEXTURE20" );
	#endif
	#ifdef GL_TEXTURE21
		swigIntConstant( GL_TEXTURE21, "GL_TEXTURE21" );
	#endif
	#ifdef GL_TEXTURE22
		swigIntConstant( GL_TEXTURE22, "GL_TEXTURE22" );
	#endif
	#ifdef GL_TEXTURE23
		swigIntConstant( GL_TEXTURE23, "GL_TEXTURE23" );
	#endif
	#ifdef GL_TEXTURE24
		swigIntConstant( GL_TEXTURE24, "GL_TEXTURE24" );
	#endif
	#ifdef GL_TEXTURE25
		swigIntConstant( GL_TEXTURE25, "GL_TEXTURE25" );
	#endif
	#ifdef GL_TEXTURE26
		swigIntConstant( GL_TEXTURE26, "GL_TEXTURE26" );
	#endif
	#ifdef GL_TEXTURE27
		swigIntConstant( GL_TEXTURE27, "GL_TEXTURE27" );
	#endif
	#ifdef GL_TEXTURE28
		swigIntConstant( GL_TEXTURE28, "GL_TEXTURE28" );
	#endif
	#ifdef GL_TEXTURE29
		swigIntConstant( GL_TEXTURE29, "GL_TEXTURE29" );
	#endif
	#ifdef GL_TEXTURE30
		swigIntConstant( GL_TEXTURE30, "GL_TEXTURE30" );
	#endif
	#ifdef GL_TEXTURE31
		swigIntConstant( GL_TEXTURE31, "GL_TEXTURE31" );
	#endif
	#ifdef GL_ACTIVE_TEXTURE
		swigIntConstant( GL_ACTIVE_TEXTURE, "GL_ACTIVE_TEXTURE" );
	#endif
	#ifdef GL_CLIENT_ACTIVE_TEXTURE
		swigIntConstant( GL_CLIENT_ACTIVE_TEXTURE, "GL_CLIENT_ACTIVE_TEXTURE" );
	#endif
	#ifdef GL_MAX_TEXTURE_UNITS
		swigIntConstant( GL_MAX_TEXTURE_UNITS, "GL_MAX_TEXTURE_UNITS" );
	#endif
	#ifdef GL_NORMAL_MAP
		swigIntConstant( GL_NORMAL_MAP, "GL_NORMAL_MAP" );
	#endif
	#ifdef GL_REFLECTION_MAP
		swigIntConstant( GL_REFLECTION_MAP, "GL_REFLECTION_MAP" );
	#endif
	#ifdef GL_TEXTURE_CUBE_MAP
		swigIntConstant( GL_TEXTURE_CUBE_MAP, "GL_TEXTURE_CUBE_MAP" );
	#endif
	#ifdef GL_TEXTURE_BINDING_CUBE_MAP
		swigIntConstant( GL_TEXTURE_BINDING_CUBE_MAP, "GL_TEXTURE_BINDING_CUBE_MAP" );
	#endif
	#ifdef GL_TEXTURE_CUBE_MAP_POSITIVE_X
		swigIntConstant( GL_TEXTURE_CUBE_MAP_POSITIVE_X, "GL_TEXTURE_CUBE_MAP_POSITIVE_X" );
	#endif
	#ifdef GL_TEXTURE_CUBE_MAP_NEGATIVE_X
		swigIntConstant( GL_TEXTURE_CUBE_MAP_NEGATIVE_X, "GL_TEXTURE_CUBE_MAP_NEGATIVE_X" );
	#endif
	#ifdef GL_TEXTURE_CUBE_MAP_POSITIVE_Y
		swigIntConstant( GL_TEXTURE_CUBE_MAP_POSITIVE_Y, "GL_TEXTURE_CUBE_MAP_POSITIVE_Y" );
	#endif
	#ifdef GL_TEXTURE_CUBE_MAP_NEGATIVE_Y
		swigIntConstant( GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, "GL_TEXTURE_CUBE_MAP_NEGATIVE_Y" );
	#endif
	#ifdef GL_TEXTURE_CUBE_MAP_POSITIVE_Z
		swigIntConstant( GL_TEXTURE_CUBE_MAP_POSITIVE_Z, "GL_TEXTURE_CUBE_MAP_POSITIVE_Z" );
	#endif
	#ifdef GL_TEXTURE_CUBE_MAP_NEGATIVE_Z
		swigIntConstant( GL_TEXTURE_CUBE_MAP_NEGATIVE_Z, "GL_TEXTURE_CUBE_MAP_NEGATIVE_Z" );
	#endif
	#ifdef GL_PROXY_TEXTURE_CUBE_MAP
		swigIntConstant( GL_PROXY_TEXTURE_CUBE_MAP, "GL_PROXY_TEXTURE_CUBE_MAP" );
	#endif
	#ifdef GL_MAX_CUBE_MAP_TEXTURE_SIZE
		swigIntConstant( GL_MAX_CUBE_MAP_TEXTURE_SIZE, "GL_MAX_CUBE_MAP_TEXTURE_SIZE" );
	#endif
	#ifdef GL_COMPRESSED_ALPHA
		swigIntConstant( GL_COMPRESSED_ALPHA, "GL_COMPRESSED_ALPHA" );
	#endif
	#ifdef GL_COMPRESSED_LUMINANCE
		swigIntConstant( GL_COMPRESSED_LUMINANCE, "GL_COMPRESSED_LUMINANCE" );
	#endif
	#ifdef GL_COMPRESSED_LUMINANCE_ALPHA
		swigIntConstant( GL_COMPRESSED_LUMINANCE_ALPHA, "GL_COMPRESSED_LUMINANCE_ALPHA" );
	#endif
	#ifdef GL_COMPRESSED_INTENSITY
		swigIntConstant( GL_COMPRESSED_INTENSITY, "GL_COMPRESSED_INTENSITY" );
	#endif
	#ifdef GL_COMPRESSED_RGB
		swigIntConstant( GL_COMPRESSED_RGB, "GL_COMPRESSED_RGB" );
	#endif
	#ifdef GL_COMPRESSED_RGBA
		swigIntConstant( GL_COMPRESSED_RGBA, "GL_COMPRESSED_RGBA" );
	#endif
	#ifdef GL_TEXTURE_COMPRESSION_HINT
		swigIntConstant( GL_TEXTURE_COMPRESSION_HINT, "GL_TEXTURE_COMPRESSION_HINT" );
	#endif
	#ifdef GL_TEXTURE_COMPRESSED_IMAGE_SIZE
		swigIntConstant( GL_TEXTURE_COMPRESSED_IMAGE_SIZE, "GL_TEXTURE_COMPRESSED_IMAGE_SIZE" );
	#endif
	#ifdef GL_TEXTURE_COMPRESSED
		swigIntConstant( GL_TEXTURE_COMPRESSED, "GL_TEXTURE_COMPRESSED" );
	#endif
	#ifdef GL_NUM_COMPRESSED_TEXTURE_FORMATS
		swigIntConstant( GL_NUM_COMPRESSED_TEXTURE_FORMATS, "GL_NUM_COMPRESSED_TEXTURE_FORMATS" );
	#endif
	#ifdef GL_COMPRESSED_TEXTURE_FORMATS
		swigIntConstant( GL_COMPRESSED_TEXTURE_FORMATS, "GL_COMPRESSED_TEXTURE_FORMATS" );
	#endif
	#ifdef GL_MULTISAMPLE
		swigIntConstant( GL_MULTISAMPLE, "GL_MULTISAMPLE" );
	#endif
	#ifdef GL_SAMPLE_ALPHA_TO_COVERAGE
		swigIntConstant( GL_SAMPLE_ALPHA_TO_COVERAGE, "GL_SAMPLE_ALPHA_TO_COVERAGE" );
	#endif
	#ifdef GL_SAMPLE_ALPHA_TO_ONE
		swigIntConstant( GL_SAMPLE_ALPHA_TO_ONE, "GL_SAMPLE_ALPHA_TO_ONE" );
	#endif
	#ifdef GL_SAMPLE_COVERAGE
		swigIntConstant( GL_SAMPLE_COVERAGE, "GL_SAMPLE_COVERAGE" );
	#endif
	#ifdef GL_SAMPLE_BUFFERS
		swigIntConstant( GL_SAMPLE_BUFFERS, "GL_SAMPLE_BUFFERS" );
	#endif
	#ifdef GL_SAMPLES
		swigIntConstant( GL_SAMPLES, "GL_SAMPLES" );
	#endif
	#ifdef GL_SAMPLE_COVERAGE_VALUE
		swigIntConstant( GL_SAMPLE_COVERAGE_VALUE, "GL_SAMPLE_COVERAGE_VALUE" );
	#endif
	#ifdef GL_SAMPLE_COVERAGE_INVERT
		swigIntConstant( GL_SAMPLE_COVERAGE_INVERT, "GL_SAMPLE_COVERAGE_INVERT" );
	#endif
	#ifdef GL_MULTISAMPLE_BIT
		swigIntConstant( GL_MULTISAMPLE_BIT, "GL_MULTISAMPLE_BIT" );
	#endif
	#ifdef GL_TRANSPOSE_MODELVIEW_MATRIX
		swigIntConstant( GL_TRANSPOSE_MODELVIEW_MATRIX, "GL_TRANSPOSE_MODELVIEW_MATRIX" );
	#endif
	#ifdef GL_TRANSPOSE_PROJECTION_MATRIX
		swigIntConstant( GL_TRANSPOSE_PROJECTION_MATRIX, "GL_TRANSPOSE_PROJECTION_MATRIX" );
	#endif
	#ifdef GL_TRANSPOSE_TEXTURE_MATRIX
		swigIntConstant( GL_TRANSPOSE_TEXTURE_MATRIX, "GL_TRANSPOSE_TEXTURE_MATRIX" );
	#endif
	#ifdef GL_TRANSPOSE_COLOR_MATRIX
		swigIntConstant( GL_TRANSPOSE_COLOR_MATRIX, "GL_TRANSPOSE_COLOR_MATRIX" );
	#endif
	#ifdef GL_COMBINE
		swigIntConstant( GL_COMBINE, "GL_COMBINE" );
	#endif
	#ifdef GL_COMBINE_RGB
		swigIntConstant( GL_COMBINE_RGB, "GL_COMBINE_RGB" );
	#endif
	#ifdef GL_COMBINE_ALPHA
		swigIntConstant( GL_COMBINE_ALPHA, "GL_COMBINE_ALPHA" );
	#endif
	#ifdef GL_SOURCE0_RGB
		swigIntConstant( GL_SOURCE0_RGB, "GL_SOURCE0_RGB" );
	#endif
	#ifdef GL_SOURCE1_RGB
		swigIntConstant( GL_SOURCE1_RGB, "GL_SOURCE1_RGB" );
	#endif
	#ifdef GL_SOURCE2_RGB
		swigIntConstant( GL_SOURCE2_RGB, "GL_SOURCE2_RGB" );
	#endif
	#ifdef GL_SOURCE0_ALPHA
		swigIntConstant( GL_SOURCE0_ALPHA, "GL_SOURCE0_ALPHA" );
	#endif
	#ifdef GL_SOURCE1_ALPHA
		swigIntConstant( GL_SOURCE1_ALPHA, "GL_SOURCE1_ALPHA" );
	#endif
	#ifdef GL_SOURCE2_ALPHA
		swigIntConstant( GL_SOURCE2_ALPHA, "GL_SOURCE2_ALPHA" );
	#endif
	#ifdef GL_OPERAND0_RGB
		swigIntConstant( GL_OPERAND0_RGB, "GL_OPERAND0_RGB" );
	#endif
	#ifdef GL_OPERAND1_RGB
		swigIntConstant( GL_OPERAND1_RGB, "GL_OPERAND1_RGB" );
	#endif
	#ifdef GL_OPERAND2_RGB
		swigIntConstant( GL_OPERAND2_RGB, "GL_OPERAND2_RGB" );
	#endif
	#ifdef GL_OPERAND0_ALPHA
		swigIntConstant( GL_OPERAND0_ALPHA, "GL_OPERAND0_ALPHA" );
	#endif
	#ifdef GL_OPERAND1_ALPHA
		swigIntConstant( GL_OPERAND1_ALPHA, "GL_OPERAND1_ALPHA" );
	#endif
	#ifdef GL_OPERAND2_ALPHA
		swigIntConstant( GL_OPERAND2_ALPHA, "GL_OPERAND2_ALPHA" );
	#endif
	#ifdef GL_RGB_SCALE
		swigIntConstant( GL_RGB_SCALE, "GL_RGB_SCALE" );
	#endif
	#ifdef GL_ADD_SIGNED
		swigIntConstant( GL_ADD_SIGNED, "GL_ADD_SIGNED" );
	#endif
	#ifdef GL_INTERPOLATE
		swigIntConstant( GL_INTERPOLATE, "GL_INTERPOLATE" );
	#endif
	#ifdef GL_SUBTRACT
		swigIntConstant( GL_SUBTRACT, "GL_SUBTRACT" );
	#endif
	#ifdef GL_CONSTANT
		swigIntConstant( GL_CONSTANT, "GL_CONSTANT" );
	#endif
	#ifdef GL_PRIMARY_COLOR
		swigIntConstant( GL_PRIMARY_COLOR, "GL_PRIMARY_COLOR" );
	#endif
	#ifdef GL_PREVIOUS
		swigIntConstant( GL_PREVIOUS, "GL_PREVIOUS" );
	#endif
	#ifdef GL_DOT3_RGB
		swigIntConstant( GL_DOT3_RGB, "GL_DOT3_RGB" );
	#endif
	#ifdef GL_DOT3_RGBA
		swigIntConstant( GL_DOT3_RGBA, "GL_DOT3_RGBA" );
	#endif
	#ifdef GL_CLAMP_TO_BORDER
		swigIntConstant( GL_CLAMP_TO_BORDER, "GL_CLAMP_TO_BORDER" );
	#endif
	#ifdef GL_ARB_multitexture
		swigIntConstant( GL_ARB_multitexture, "GL_ARB_multitexture" );
	#endif
	#ifdef GL_TEXTURE0_ARB
		swigIntConstant( GL_TEXTURE0_ARB, "GL_TEXTURE0_ARB" );
	#endif
	#ifdef GL_TEXTURE1_ARB
		swigIntConstant( GL_TEXTURE1_ARB, "GL_TEXTURE1_ARB" );
	#endif
	#ifdef GL_TEXTURE2_ARB
		swigIntConstant( GL_TEXTURE2_ARB, "GL_TEXTURE2_ARB" );
	#endif
	#ifdef GL_TEXTURE3_ARB
		swigIntConstant( GL_TEXTURE3_ARB, "GL_TEXTURE3_ARB" );
	#endif
	#ifdef GL_TEXTURE4_ARB
		swigIntConstant( GL_TEXTURE4_ARB, "GL_TEXTURE4_ARB" );
	#endif
	#ifdef GL_TEXTURE5_ARB
		swigIntConstant( GL_TEXTURE5_ARB, "GL_TEXTURE5_ARB" );
	#endif
	#ifdef GL_TEXTURE6_ARB
		swigIntConstant( GL_TEXTURE6_ARB, "GL_TEXTURE6_ARB" );
	#endif
	#ifdef GL_TEXTURE7_ARB
		swigIntConstant( GL_TEXTURE7_ARB, "GL_TEXTURE7_ARB" );
	#endif
	#ifdef GL_TEXTURE8_ARB
		swigIntConstant( GL_TEXTURE8_ARB, "GL_TEXTURE8_ARB" );
	#endif
	#ifdef GL_TEXTURE9_ARB
		swigIntConstant( GL_TEXTURE9_ARB, "GL_TEXTURE9_ARB" );
	#endif
	#ifdef GL_TEXTURE10_ARB
		swigIntConstant( GL_TEXTURE10_ARB, "GL_TEXTURE10_ARB" );
	#endif
	#ifdef GL_TEXTURE11_ARB
		swigIntConstant( GL_TEXTURE11_ARB, "GL_TEXTURE11_ARB" );
	#endif
	#ifdef GL_TEXTURE12_ARB
		swigIntConstant( GL_TEXTURE12_ARB, "GL_TEXTURE12_ARB" );
	#endif
	#ifdef GL_TEXTURE13_ARB
		swigIntConstant( GL_TEXTURE13_ARB, "GL_TEXTURE13_ARB" );
	#endif
	#ifdef GL_TEXTURE14_ARB
		swigIntConstant( GL_TEXTURE14_ARB, "GL_TEXTURE14_ARB" );
	#endif
	#ifdef GL_TEXTURE15_ARB
		swigIntConstant( GL_TEXTURE15_ARB, "GL_TEXTURE15_ARB" );
	#endif
	#ifdef GL_TEXTURE16_ARB
		swigIntConstant( GL_TEXTURE16_ARB, "GL_TEXTURE16_ARB" );
	#endif
	#ifdef GL_TEXTURE17_ARB
		swigIntConstant( GL_TEXTURE17_ARB, "GL_TEXTURE17_ARB" );
	#endif
	#ifdef GL_TEXTURE18_ARB
		swigIntConstant( GL_TEXTURE18_ARB, "GL_TEXTURE18_ARB" );
	#endif
	#ifdef GL_TEXTURE19_ARB
		swigIntConstant( GL_TEXTURE19_ARB, "GL_TEXTURE19_ARB" );
	#endif
	#ifdef GL_TEXTURE20_ARB
		swigIntConstant( GL_TEXTURE20_ARB, "GL_TEXTURE20_ARB" );
	#endif
	#ifdef GL_TEXTURE21_ARB
		swigIntConstant( GL_TEXTURE21_ARB, "GL_TEXTURE21_ARB" );
	#endif
	#ifdef GL_TEXTURE22_ARB
		swigIntConstant( GL_TEXTURE22_ARB, "GL_TEXTURE22_ARB" );
	#endif
	#ifdef GL_TEXTURE23_ARB
		swigIntConstant( GL_TEXTURE23_ARB, "GL_TEXTURE23_ARB" );
	#endif
	#ifdef GL_TEXTURE24_ARB
		swigIntConstant( GL_TEXTURE24_ARB, "GL_TEXTURE24_ARB" );
	#endif
	#ifdef GL_TEXTURE25_ARB
		swigIntConstant( GL_TEXTURE25_ARB, "GL_TEXTURE25_ARB" );
	#endif
	#ifdef GL_TEXTURE26_ARB
		swigIntConstant( GL_TEXTURE26_ARB, "GL_TEXTURE26_ARB" );
	#endif
	#ifdef GL_TEXTURE27_ARB
		swigIntConstant( GL_TEXTURE27_ARB, "GL_TEXTURE27_ARB" );
	#endif
	#ifdef GL_TEXTURE28_ARB
		swigIntConstant( GL_TEXTURE28_ARB, "GL_TEXTURE28_ARB" );
	#endif
	#ifdef GL_TEXTURE29_ARB
		swigIntConstant( GL_TEXTURE29_ARB, "GL_TEXTURE29_ARB" );
	#endif
	#ifdef GL_TEXTURE30_ARB
		swigIntConstant( GL_TEXTURE30_ARB, "GL_TEXTURE30_ARB" );
	#endif
	#ifdef GL_TEXTURE31_ARB
		swigIntConstant( GL_TEXTURE31_ARB, "GL_TEXTURE31_ARB" );
	#endif
	#ifdef GL_ACTIVE_TEXTURE_ARB
		swigIntConstant( GL_ACTIVE_TEXTURE_ARB, "GL_ACTIVE_TEXTURE_ARB" );
	#endif
	#ifdef GL_CLIENT_ACTIVE_TEXTURE_ARB
		swigIntConstant( GL_CLIENT_ACTIVE_TEXTURE_ARB, "GL_CLIENT_ACTIVE_TEXTURE_ARB" );
	#endif
	#ifdef GL_MAX_TEXTURE_UNITS_ARB
		swigIntConstant( GL_MAX_TEXTURE_UNITS_ARB, "GL_MAX_TEXTURE_UNITS_ARB" );
	#endif
	#ifdef GL_MESA_packed_depth_stencil
		swigIntConstant( GL_MESA_packed_depth_stencil, "GL_MESA_packed_depth_stencil" );
	#endif
	#ifdef GL_DEPTH_STENCIL_MESA
		swigIntConstant( GL_DEPTH_STENCIL_MESA, "GL_DEPTH_STENCIL_MESA" );
	#endif
	#ifdef GL_UNSIGNED_INT_24_8_MESA
		swigIntConstant( GL_UNSIGNED_INT_24_8_MESA, "GL_UNSIGNED_INT_24_8_MESA" );
	#endif
	#ifdef GL_UNSIGNED_INT_8_24_REV_MESA
		swigIntConstant( GL_UNSIGNED_INT_8_24_REV_MESA, "GL_UNSIGNED_INT_8_24_REV_MESA" );
	#endif
	#ifdef GL_UNSIGNED_SHORT_15_1_MESA
		swigIntConstant( GL_UNSIGNED_SHORT_15_1_MESA, "GL_UNSIGNED_SHORT_15_1_MESA" );
	#endif
	#ifdef GL_UNSIGNED_SHORT_1_15_REV_MESA
		swigIntConstant( GL_UNSIGNED_SHORT_1_15_REV_MESA, "GL_UNSIGNED_SHORT_1_15_REV_MESA" );
	#endif
	#ifdef GL_ATI_blend_equation_separate
		swigIntConstant( GL_ATI_blend_equation_separate, "GL_ATI_blend_equation_separate" );
	#endif
	#ifdef GL_ALPHA_BLEND_EQUATION_ATI
		swigIntConstant( GL_ALPHA_BLEND_EQUATION_ATI, "GL_ALPHA_BLEND_EQUATION_ATI" );
	#endif
	#ifdef GL_OES_EGL_image
		swigIntConstant( GL_OES_EGL_image, "GL_OES_EGL_image" );
	#endif
	#ifdef __gl_glext_h_
		swigIntConstant( __gl_glext_h_, "__gl_glext_h_" );
	#endif
	#ifdef GL_GLEXT_VERSION
		swigIntConstant( GL_GLEXT_VERSION, "GL_GLEXT_VERSION" );
	#endif
	#ifdef GL_VERSION_1_4
		swigIntConstant( GL_VERSION_1_4, "GL_VERSION_1_4" );
	#endif
	#ifdef GL_BLEND_DST_RGB
		swigIntConstant( GL_BLEND_DST_RGB, "GL_BLEND_DST_RGB" );
	#endif
	#ifdef GL_BLEND_SRC_RGB
		swigIntConstant( GL_BLEND_SRC_RGB, "GL_BLEND_SRC_RGB" );
	#endif
	#ifdef GL_BLEND_DST_ALPHA
		swigIntConstant( GL_BLEND_DST_ALPHA, "GL_BLEND_DST_ALPHA" );
	#endif
	#ifdef GL_BLEND_SRC_ALPHA
		swigIntConstant( GL_BLEND_SRC_ALPHA, "GL_BLEND_SRC_ALPHA" );
	#endif
	#ifdef GL_POINT_FADE_THRESHOLD_SIZE
		swigIntConstant( GL_POINT_FADE_THRESHOLD_SIZE, "GL_POINT_FADE_THRESHOLD_SIZE" );
	#endif
	#ifdef GL_DEPTH_COMPONENT16
		swigIntConstant( GL_DEPTH_COMPONENT16, "GL_DEPTH_COMPONENT16" );
	#endif
	#ifdef GL_DEPTH_COMPONENT24
		swigIntConstant( GL_DEPTH_COMPONENT24, "GL_DEPTH_COMPONENT24" );
	#endif
	#ifdef GL_DEPTH_COMPONENT32
		swigIntConstant( GL_DEPTH_COMPONENT32, "GL_DEPTH_COMPONENT32" );
	#endif
	#ifdef GL_MIRRORED_REPEAT
		swigIntConstant( GL_MIRRORED_REPEAT, "GL_MIRRORED_REPEAT" );
	#endif
	#ifdef GL_MAX_TEXTURE_LOD_BIAS
		swigIntConstant( GL_MAX_TEXTURE_LOD_BIAS, "GL_MAX_TEXTURE_LOD_BIAS" );
	#endif
	#ifdef GL_TEXTURE_LOD_BIAS
		swigIntConstant( GL_TEXTURE_LOD_BIAS, "GL_TEXTURE_LOD_BIAS" );
	#endif
	#ifdef GL_INCR_WRAP
		swigIntConstant( GL_INCR_WRAP, "GL_INCR_WRAP" );
	#endif
	#ifdef GL_DECR_WRAP
		swigIntConstant( GL_DECR_WRAP, "GL_DECR_WRAP" );
	#endif
	#ifdef GL_TEXTURE_DEPTH_SIZE
		swigIntConstant( GL_TEXTURE_DEPTH_SIZE, "GL_TEXTURE_DEPTH_SIZE" );
	#endif
	#ifdef GL_TEXTURE_COMPARE_MODE
		swigIntConstant( GL_TEXTURE_COMPARE_MODE, "GL_TEXTURE_COMPARE_MODE" );
	#endif
	#ifdef GL_TEXTURE_COMPARE_FUNC
		swigIntConstant( GL_TEXTURE_COMPARE_FUNC, "GL_TEXTURE_COMPARE_FUNC" );
	#endif
	#ifdef GL_POINT_SIZE_MIN
		swigIntConstant( GL_POINT_SIZE_MIN, "GL_POINT_SIZE_MIN" );
	#endif
	#ifdef GL_POINT_SIZE_MAX
		swigIntConstant( GL_POINT_SIZE_MAX, "GL_POINT_SIZE_MAX" );
	#endif
	#ifdef GL_POINT_DISTANCE_ATTENUATION
		swigIntConstant( GL_POINT_DISTANCE_ATTENUATION, "GL_POINT_DISTANCE_ATTENUATION" );
	#endif
	#ifdef GL_GENERATE_MIPMAP
		swigIntConstant( GL_GENERATE_MIPMAP, "GL_GENERATE_MIPMAP" );
	#endif
	#ifdef GL_GENERATE_MIPMAP_HINT
		swigIntConstant( GL_GENERATE_MIPMAP_HINT, "GL_GENERATE_MIPMAP_HINT" );
	#endif
	#ifdef GL_FOG_COORDINATE_SOURCE
		swigIntConstant( GL_FOG_COORDINATE_SOURCE, "GL_FOG_COORDINATE_SOURCE" );
	#endif
	#ifdef GL_FOG_COORDINATE
		swigIntConstant( GL_FOG_COORDINATE, "GL_FOG_COORDINATE" );
	#endif
	#ifdef GL_FRAGMENT_DEPTH
		swigIntConstant( GL_FRAGMENT_DEPTH, "GL_FRAGMENT_DEPTH" );
	#endif
	#ifdef GL_CURRENT_FOG_COORDINATE
		swigIntConstant( GL_CURRENT_FOG_COORDINATE, "GL_CURRENT_FOG_COORDINATE" );
	#endif
	#ifdef GL_FOG_COORDINATE_ARRAY_TYPE
		swigIntConstant( GL_FOG_COORDINATE_ARRAY_TYPE, "GL_FOG_COORDINATE_ARRAY_TYPE" );
	#endif
	#ifdef GL_FOG_COORDINATE_ARRAY_STRIDE
		swigIntConstant( GL_FOG_COORDINATE_ARRAY_STRIDE, "GL_FOG_COORDINATE_ARRAY_STRIDE" );
	#endif
	#ifdef GL_FOG_COORDINATE_ARRAY_POINTER
		swigIntConstant( GL_FOG_COORDINATE_ARRAY_POINTER, "GL_FOG_COORDINATE_ARRAY_POINTER" );
	#endif
	#ifdef GL_FOG_COORDINATE_ARRAY
		swigIntConstant( GL_FOG_COORDINATE_ARRAY, "GL_FOG_COORDINATE_ARRAY" );
	#endif
	#ifdef GL_COLOR_SUM
		swigIntConstant( GL_COLOR_SUM, "GL_COLOR_SUM" );
	#endif
	#ifdef GL_CURRENT_SECONDARY_COLOR
		swigIntConstant( GL_CURRENT_SECONDARY_COLOR, "GL_CURRENT_SECONDARY_COLOR" );
	#endif
	#ifdef GL_SECONDARY_COLOR_ARRAY_SIZE
		swigIntConstant( GL_SECONDARY_COLOR_ARRAY_SIZE, "GL_SECONDARY_COLOR_ARRAY_SIZE" );
	#endif
	#ifdef GL_SECONDARY_COLOR_ARRAY_TYPE
		swigIntConstant( GL_SECONDARY_COLOR_ARRAY_TYPE, "GL_SECONDARY_COLOR_ARRAY_TYPE" );
	#endif
	#ifdef GL_SECONDARY_COLOR_ARRAY_STRIDE
		swigIntConstant( GL_SECONDARY_COLOR_ARRAY_STRIDE, "GL_SECONDARY_COLOR_ARRAY_STRIDE" );
	#endif
	#ifdef GL_SECONDARY_COLOR_ARRAY_POINTER
		swigIntConstant( GL_SECONDARY_COLOR_ARRAY_POINTER, "GL_SECONDARY_COLOR_ARRAY_POINTER" );
	#endif
	#ifdef GL_SECONDARY_COLOR_ARRAY
		swigIntConstant( GL_SECONDARY_COLOR_ARRAY, "GL_SECONDARY_COLOR_ARRAY" );
	#endif
	#ifdef GL_TEXTURE_FILTER_CONTROL
		swigIntConstant( GL_TEXTURE_FILTER_CONTROL, "GL_TEXTURE_FILTER_CONTROL" );
	#endif
	#ifdef GL_DEPTH_TEXTURE_MODE
		swigIntConstant( GL_DEPTH_TEXTURE_MODE, "GL_DEPTH_TEXTURE_MODE" );
	#endif
	#ifdef GL_COMPARE_R_TO_TEXTURE
		swigIntConstant( GL_COMPARE_R_TO_TEXTURE, "GL_COMPARE_R_TO_TEXTURE" );
	#endif
	#ifdef GL_VERSION_1_5
		swigIntConstant( GL_VERSION_1_5, "GL_VERSION_1_5" );
	#endif
	#ifdef GL_BUFFER_SIZE
		swigIntConstant( GL_BUFFER_SIZE, "GL_BUFFER_SIZE" );
	#endif
	#ifdef GL_BUFFER_USAGE
		swigIntConstant( GL_BUFFER_USAGE, "GL_BUFFER_USAGE" );
	#endif
	#ifdef GL_QUERY_COUNTER_BITS
		swigIntConstant( GL_QUERY_COUNTER_BITS, "GL_QUERY_COUNTER_BITS" );
	#endif
	#ifdef GL_CURRENT_QUERY
		swigIntConstant( GL_CURRENT_QUERY, "GL_CURRENT_QUERY" );
	#endif
	#ifdef GL_QUERY_RESULT
		swigIntConstant( GL_QUERY_RESULT, "GL_QUERY_RESULT" );
	#endif
	#ifdef GL_QUERY_RESULT_AVAILABLE
		swigIntConstant( GL_QUERY_RESULT_AVAILABLE, "GL_QUERY_RESULT_AVAILABLE" );
	#endif
	#ifdef GL_ARRAY_BUFFER
		swigIntConstant( GL_ARRAY_BUFFER, "GL_ARRAY_BUFFER" );
	#endif
	#ifdef GL_ELEMENT_ARRAY_BUFFER
		swigIntConstant( GL_ELEMENT_ARRAY_BUFFER, "GL_ELEMENT_ARRAY_BUFFER" );
	#endif
	#ifdef GL_ARRAY_BUFFER_BINDING
		swigIntConstant( GL_ARRAY_BUFFER_BINDING, "GL_ARRAY_BUFFER_BINDING" );
	#endif
	#ifdef GL_ELEMENT_ARRAY_BUFFER_BINDING
		swigIntConstant( GL_ELEMENT_ARRAY_BUFFER_BINDING, "GL_ELEMENT_ARRAY_BUFFER_BINDING" );
	#endif
	#ifdef GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING
		swigIntConstant( GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING, "GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING" );
	#endif
	#ifdef GL_READ_ONLY
		swigIntConstant( GL_READ_ONLY, "GL_READ_ONLY" );
	#endif
	#ifdef GL_WRITE_ONLY
		swigIntConstant( GL_WRITE_ONLY, "GL_WRITE_ONLY" );
	#endif
	#ifdef GL_READ_WRITE
		swigIntConstant( GL_READ_WRITE, "GL_READ_WRITE" );
	#endif
	#ifdef GL_BUFFER_ACCESS
		swigIntConstant( GL_BUFFER_ACCESS, "GL_BUFFER_ACCESS" );
	#endif
	#ifdef GL_BUFFER_MAPPED
		swigIntConstant( GL_BUFFER_MAPPED, "GL_BUFFER_MAPPED" );
	#endif
	#ifdef GL_BUFFER_MAP_POINTER
		swigIntConstant( GL_BUFFER_MAP_POINTER, "GL_BUFFER_MAP_POINTER" );
	#endif
	#ifdef GL_STREAM_DRAW
		swigIntConstant( GL_STREAM_DRAW, "GL_STREAM_DRAW" );
	#endif
	#ifdef GL_STREAM_READ
		swigIntConstant( GL_STREAM_READ, "GL_STREAM_READ" );
	#endif
	#ifdef GL_STREAM_COPY
		swigIntConstant( GL_STREAM_COPY, "GL_STREAM_COPY" );
	#endif
	#ifdef GL_STATIC_DRAW
		swigIntConstant( GL_STATIC_DRAW, "GL_STATIC_DRAW" );
	#endif
	#ifdef GL_STATIC_READ
		swigIntConstant( GL_STATIC_READ, "GL_STATIC_READ" );
	#endif
	#ifdef GL_STATIC_COPY
		swigIntConstant( GL_STATIC_COPY, "GL_STATIC_COPY" );
	#endif
	#ifdef GL_DYNAMIC_DRAW
		swigIntConstant( GL_DYNAMIC_DRAW, "GL_DYNAMIC_DRAW" );
	#endif
	#ifdef GL_DYNAMIC_READ
		swigIntConstant( GL_DYNAMIC_READ, "GL_DYNAMIC_READ" );
	#endif
	#ifdef GL_DYNAMIC_COPY
		swigIntConstant( GL_DYNAMIC_COPY, "GL_DYNAMIC_COPY" );
	#endif
	#ifdef GL_SAMPLES_PASSED
		swigIntConstant( GL_SAMPLES_PASSED, "GL_SAMPLES_PASSED" );
	#endif
	#ifdef GL_SRC1_ALPHA
		swigIntConstant( GL_SRC1_ALPHA, "GL_SRC1_ALPHA" );
	#endif
	#ifdef GL_VERTEX_ARRAY_BUFFER_BINDING
		swigIntConstant( GL_VERTEX_ARRAY_BUFFER_BINDING, "GL_VERTEX_ARRAY_BUFFER_BINDING" );
	#endif
	#ifdef GL_NORMAL_ARRAY_BUFFER_BINDING
		swigIntConstant( GL_NORMAL_ARRAY_BUFFER_BINDING, "GL_NORMAL_ARRAY_BUFFER_BINDING" );
	#endif
	#ifdef GL_COLOR_ARRAY_BUFFER_BINDING
		swigIntConstant( GL_COLOR_ARRAY_BUFFER_BINDING, "GL_COLOR_ARRAY_BUFFER_BINDING" );
	#endif
	#ifdef GL_INDEX_ARRAY_BUFFER_BINDING
		swigIntConstant( GL_INDEX_ARRAY_BUFFER_BINDING, "GL_INDEX_ARRAY_BUFFER_BINDING" );
	#endif
	#ifdef GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING
		swigIntConstant( GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING, "GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING" );
	#endif
	#ifdef GL_EDGE_FLAG_ARRAY_BUFFER_BINDING
		swigIntConstant( GL_EDGE_FLAG_ARRAY_BUFFER_BINDING, "GL_EDGE_FLAG_ARRAY_BUFFER_BINDING" );
	#endif
	#ifdef GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING
		swigIntConstant( GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING, "GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING" );
	#endif
	#ifdef GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING
		swigIntConstant( GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING, "GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING" );
	#endif
	#ifdef GL_WEIGHT_ARRAY_BUFFER_BINDING
		swigIntConstant( GL_WEIGHT_ARRAY_BUFFER_BINDING, "GL_WEIGHT_ARRAY_BUFFER_BINDING" );
	#endif
	#ifdef GL_FOG_COORD_SRC
		swigIntConstant( GL_FOG_COORD_SRC, "GL_FOG_COORD_SRC" );
	#endif
	#ifdef GL_FOG_COORD
		swigIntConstant( GL_FOG_COORD, "GL_FOG_COORD" );
	#endif
	#ifdef GL_CURRENT_FOG_COORD
		swigIntConstant( GL_CURRENT_FOG_COORD, "GL_CURRENT_FOG_COORD" );
	#endif
	#ifdef GL_FOG_COORD_ARRAY_TYPE
		swigIntConstant( GL_FOG_COORD_ARRAY_TYPE, "GL_FOG_COORD_ARRAY_TYPE" );
	#endif
	#ifdef GL_FOG_COORD_ARRAY_STRIDE
		swigIntConstant( GL_FOG_COORD_ARRAY_STRIDE, "GL_FOG_COORD_ARRAY_STRIDE" );
	#endif
	#ifdef GL_FOG_COORD_ARRAY_POINTER
		swigIntConstant( GL_FOG_COORD_ARRAY_POINTER, "GL_FOG_COORD_ARRAY_POINTER" );
	#endif
	#ifdef GL_FOG_COORD_ARRAY
		swigIntConstant( GL_FOG_COORD_ARRAY, "GL_FOG_COORD_ARRAY" );
	#endif
	#ifdef GL_FOG_COORD_ARRAY_BUFFER_BINDING
		swigIntConstant( GL_FOG_COORD_ARRAY_BUFFER_BINDING, "GL_FOG_COORD_ARRAY_BUFFER_BINDING" );
	#endif
	#ifdef GL_SRC0_RGB
		swigIntConstant( GL_SRC0_RGB, "GL_SRC0_RGB" );
	#endif
	#ifdef GL_SRC1_RGB
		swigIntConstant( GL_SRC1_RGB, "GL_SRC1_RGB" );
	#endif
	#ifdef GL_SRC2_RGB
		swigIntConstant( GL_SRC2_RGB, "GL_SRC2_RGB" );
	#endif
	#ifdef GL_SRC0_ALPHA
		swigIntConstant( GL_SRC0_ALPHA, "GL_SRC0_ALPHA" );
	#endif
	#ifdef GL_SRC2_ALPHA
		swigIntConstant( GL_SRC2_ALPHA, "GL_SRC2_ALPHA" );
	#endif
	#ifdef GL_VERSION_2_0
		swigIntConstant( GL_VERSION_2_0, "GL_VERSION_2_0" );
	#endif
	#ifdef GL_BLEND_EQUATION_RGB
		swigIntConstant( GL_BLEND_EQUATION_RGB, "GL_BLEND_EQUATION_RGB" );
	#endif
	#ifdef GL_VERTEX_ATTRIB_ARRAY_ENABLED
		swigIntConstant( GL_VERTEX_ATTRIB_ARRAY_ENABLED, "GL_VERTEX_ATTRIB_ARRAY_ENABLED" );
	#endif
	#ifdef GL_VERTEX_ATTRIB_ARRAY_SIZE
		swigIntConstant( GL_VERTEX_ATTRIB_ARRAY_SIZE, "GL_VERTEX_ATTRIB_ARRAY_SIZE" );
	#endif
	#ifdef GL_VERTEX_ATTRIB_ARRAY_STRIDE
		swigIntConstant( GL_VERTEX_ATTRIB_ARRAY_STRIDE, "GL_VERTEX_ATTRIB_ARRAY_STRIDE" );
	#endif
	#ifdef GL_VERTEX_ATTRIB_ARRAY_TYPE
		swigIntConstant( GL_VERTEX_ATTRIB_ARRAY_TYPE, "GL_VERTEX_ATTRIB_ARRAY_TYPE" );
	#endif
	#ifdef GL_CURRENT_VERTEX_ATTRIB
		swigIntConstant( GL_CURRENT_VERTEX_ATTRIB, "GL_CURRENT_VERTEX_ATTRIB" );
	#endif
	#ifdef GL_VERTEX_PROGRAM_POINT_SIZE
		swigIntConstant( GL_VERTEX_PROGRAM_POINT_SIZE, "GL_VERTEX_PROGRAM_POINT_SIZE" );
	#endif
	#ifdef GL_VERTEX_ATTRIB_ARRAY_POINTER
		swigIntConstant( GL_VERTEX_ATTRIB_ARRAY_POINTER, "GL_VERTEX_ATTRIB_ARRAY_POINTER" );
	#endif
	#ifdef GL_STENCIL_BACK_FUNC
		swigIntConstant( GL_STENCIL_BACK_FUNC, "GL_STENCIL_BACK_FUNC" );
	#endif
	#ifdef GL_STENCIL_BACK_FAIL
		swigIntConstant( GL_STENCIL_BACK_FAIL, "GL_STENCIL_BACK_FAIL" );
	#endif
	#ifdef GL_STENCIL_BACK_PASS_DEPTH_FAIL
		swigIntConstant( GL_STENCIL_BACK_PASS_DEPTH_FAIL, "GL_STENCIL_BACK_PASS_DEPTH_FAIL" );
	#endif
	#ifdef GL_STENCIL_BACK_PASS_DEPTH_PASS
		swigIntConstant( GL_STENCIL_BACK_PASS_DEPTH_PASS, "GL_STENCIL_BACK_PASS_DEPTH_PASS" );
	#endif
	#ifdef GL_MAX_DRAW_BUFFERS
		swigIntConstant( GL_MAX_DRAW_BUFFERS, "GL_MAX_DRAW_BUFFERS" );
	#endif
	#ifdef GL_DRAW_BUFFER0
		swigIntConstant( GL_DRAW_BUFFER0, "GL_DRAW_BUFFER0" );
	#endif
	#ifdef GL_DRAW_BUFFER1
		swigIntConstant( GL_DRAW_BUFFER1, "GL_DRAW_BUFFER1" );
	#endif
	#ifdef GL_DRAW_BUFFER2
		swigIntConstant( GL_DRAW_BUFFER2, "GL_DRAW_BUFFER2" );
	#endif
	#ifdef GL_DRAW_BUFFER3
		swigIntConstant( GL_DRAW_BUFFER3, "GL_DRAW_BUFFER3" );
	#endif
	#ifdef GL_DRAW_BUFFER4
		swigIntConstant( GL_DRAW_BUFFER4, "GL_DRAW_BUFFER4" );
	#endif
	#ifdef GL_DRAW_BUFFER5
		swigIntConstant( GL_DRAW_BUFFER5, "GL_DRAW_BUFFER5" );
	#endif
	#ifdef GL_DRAW_BUFFER6
		swigIntConstant( GL_DRAW_BUFFER6, "GL_DRAW_BUFFER6" );
	#endif
	#ifdef GL_DRAW_BUFFER7
		swigIntConstant( GL_DRAW_BUFFER7, "GL_DRAW_BUFFER7" );
	#endif
	#ifdef GL_DRAW_BUFFER8
		swigIntConstant( GL_DRAW_BUFFER8, "GL_DRAW_BUFFER8" );
	#endif
	#ifdef GL_DRAW_BUFFER9
		swigIntConstant( GL_DRAW_BUFFER9, "GL_DRAW_BUFFER9" );
	#endif
	#ifdef GL_DRAW_BUFFER10
		swigIntConstant( GL_DRAW_BUFFER10, "GL_DRAW_BUFFER10" );
	#endif
	#ifdef GL_DRAW_BUFFER11
		swigIntConstant( GL_DRAW_BUFFER11, "GL_DRAW_BUFFER11" );
	#endif
	#ifdef GL_DRAW_BUFFER12
		swigIntConstant( GL_DRAW_BUFFER12, "GL_DRAW_BUFFER12" );
	#endif
	#ifdef GL_DRAW_BUFFER13
		swigIntConstant( GL_DRAW_BUFFER13, "GL_DRAW_BUFFER13" );
	#endif
	#ifdef GL_DRAW_BUFFER14
		swigIntConstant( GL_DRAW_BUFFER14, "GL_DRAW_BUFFER14" );
	#endif
	#ifdef GL_DRAW_BUFFER15
		swigIntConstant( GL_DRAW_BUFFER15, "GL_DRAW_BUFFER15" );
	#endif
	#ifdef GL_BLEND_EQUATION_ALPHA
		swigIntConstant( GL_BLEND_EQUATION_ALPHA, "GL_BLEND_EQUATION_ALPHA" );
	#endif
	#ifdef GL_MAX_VERTEX_ATTRIBS
		swigIntConstant( GL_MAX_VERTEX_ATTRIBS, "GL_MAX_VERTEX_ATTRIBS" );
	#endif
	#ifdef GL_VERTEX_ATTRIB_ARRAY_NORMALIZED
		swigIntConstant( GL_VERTEX_ATTRIB_ARRAY_NORMALIZED, "GL_VERTEX_ATTRIB_ARRAY_NORMALIZED" );
	#endif
	#ifdef GL_MAX_TEXTURE_IMAGE_UNITS
		swigIntConstant( GL_MAX_TEXTURE_IMAGE_UNITS, "GL_MAX_TEXTURE_IMAGE_UNITS" );
	#endif
	#ifdef GL_FRAGMENT_SHADER
		swigIntConstant( GL_FRAGMENT_SHADER, "GL_FRAGMENT_SHADER" );
	#endif
	#ifdef GL_VERTEX_SHADER
		swigIntConstant( GL_VERTEX_SHADER, "GL_VERTEX_SHADER" );
	#endif
	#ifdef GL_MAX_FRAGMENT_UNIFORM_COMPONENTS
		swigIntConstant( GL_MAX_FRAGMENT_UNIFORM_COMPONENTS, "GL_MAX_FRAGMENT_UNIFORM_COMPONENTS" );
	#endif
	#ifdef GL_MAX_VERTEX_UNIFORM_COMPONENTS
		swigIntConstant( GL_MAX_VERTEX_UNIFORM_COMPONENTS, "GL_MAX_VERTEX_UNIFORM_COMPONENTS" );
	#endif
	#ifdef GL_MAX_VARYING_FLOATS
		swigIntConstant( GL_MAX_VARYING_FLOATS, "GL_MAX_VARYING_FLOATS" );
	#endif
	#ifdef GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS
		swigIntConstant( GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS, "GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS" );
	#endif
	#ifdef GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS
		swigIntConstant( GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS, "GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS" );
	#endif
	#ifdef GL_SHADER_TYPE
		swigIntConstant( GL_SHADER_TYPE, "GL_SHADER_TYPE" );
	#endif
	#ifdef GL_FLOAT_VEC2
		swigIntConstant( GL_FLOAT_VEC2, "GL_FLOAT_VEC2" );
	#endif
	#ifdef GL_FLOAT_VEC3
		swigIntConstant( GL_FLOAT_VEC3, "GL_FLOAT_VEC3" );
	#endif
	#ifdef GL_FLOAT_VEC4
		swigIntConstant( GL_FLOAT_VEC4, "GL_FLOAT_VEC4" );
	#endif
	#ifdef GL_INT_VEC2
		swigIntConstant( GL_INT_VEC2, "GL_INT_VEC2" );
	#endif
	#ifdef GL_INT_VEC3
		swigIntConstant( GL_INT_VEC3, "GL_INT_VEC3" );
	#endif
	#ifdef GL_INT_VEC4
		swigIntConstant( GL_INT_VEC4, "GL_INT_VEC4" );
	#endif
	#ifdef GL_BOOL
		swigIntConstant( GL_BOOL, "GL_BOOL" );
	#endif
	#ifdef GL_BOOL_VEC2
		swigIntConstant( GL_BOOL_VEC2, "GL_BOOL_VEC2" );
	#endif
	#ifdef GL_BOOL_VEC3
		swigIntConstant( GL_BOOL_VEC3, "GL_BOOL_VEC3" );
	#endif
	#ifdef GL_BOOL_VEC4
		swigIntConstant( GL_BOOL_VEC4, "GL_BOOL_VEC4" );
	#endif
	#ifdef GL_FLOAT_MAT2
		swigIntConstant( GL_FLOAT_MAT2, "GL_FLOAT_MAT2" );
	#endif
	#ifdef GL_FLOAT_MAT3
		swigIntConstant( GL_FLOAT_MAT3, "GL_FLOAT_MAT3" );
	#endif
	#ifdef GL_FLOAT_MAT4
		swigIntConstant( GL_FLOAT_MAT4, "GL_FLOAT_MAT4" );
	#endif
	#ifdef GL_SAMPLER_1D
		swigIntConstant( GL_SAMPLER_1D, "GL_SAMPLER_1D" );
	#endif
	#ifdef GL_SAMPLER_2D
		swigIntConstant( GL_SAMPLER_2D, "GL_SAMPLER_2D" );
	#endif
	#ifdef GL_SAMPLER_3D
		swigIntConstant( GL_SAMPLER_3D, "GL_SAMPLER_3D" );
	#endif
	#ifdef GL_SAMPLER_CUBE
		swigIntConstant( GL_SAMPLER_CUBE, "GL_SAMPLER_CUBE" );
	#endif
	#ifdef GL_SAMPLER_1D_SHADOW
		swigIntConstant( GL_SAMPLER_1D_SHADOW, "GL_SAMPLER_1D_SHADOW" );
	#endif
	#ifdef GL_SAMPLER_2D_SHADOW
		swigIntConstant( GL_SAMPLER_2D_SHADOW, "GL_SAMPLER_2D_SHADOW" );
	#endif
	#ifdef GL_DELETE_STATUS
		swigIntConstant( GL_DELETE_STATUS, "GL_DELETE_STATUS" );
	#endif
	#ifdef GL_COMPILE_STATUS
		swigIntConstant( GL_COMPILE_STATUS, "GL_COMPILE_STATUS" );
	#endif
	#ifdef GL_LINK_STATUS
		swigIntConstant( GL_LINK_STATUS, "GL_LINK_STATUS" );
	#endif
	#ifdef GL_VALIDATE_STATUS
		swigIntConstant( GL_VALIDATE_STATUS, "GL_VALIDATE_STATUS" );
	#endif
	#ifdef GL_INFO_LOG_LENGTH
		swigIntConstant( GL_INFO_LOG_LENGTH, "GL_INFO_LOG_LENGTH" );
	#endif
	#ifdef GL_ATTACHED_SHADERS
		swigIntConstant( GL_ATTACHED_SHADERS, "GL_ATTACHED_SHADERS" );
	#endif
	#ifdef GL_ACTIVE_UNIFORMS
		swigIntConstant( GL_ACTIVE_UNIFORMS, "GL_ACTIVE_UNIFORMS" );
	#endif
	#ifdef GL_ACTIVE_UNIFORM_MAX_LENGTH
		swigIntConstant( GL_ACTIVE_UNIFORM_MAX_LENGTH, "GL_ACTIVE_UNIFORM_MAX_LENGTH" );
	#endif
	#ifdef GL_SHADER_SOURCE_LENGTH
		swigIntConstant( GL_SHADER_SOURCE_LENGTH, "GL_SHADER_SOURCE_LENGTH" );
	#endif
	#ifdef GL_ACTIVE_ATTRIBUTES
		swigIntConstant( GL_ACTIVE_ATTRIBUTES, "GL_ACTIVE_ATTRIBUTES" );
	#endif
	#ifdef GL_ACTIVE_ATTRIBUTE_MAX_LENGTH
		swigIntConstant( GL_ACTIVE_ATTRIBUTE_MAX_LENGTH, "GL_ACTIVE_ATTRIBUTE_MAX_LENGTH" );
	#endif
	#ifdef GL_FRAGMENT_SHADER_DERIVATIVE_HINT
		swigIntConstant( GL_FRAGMENT_SHADER_DERIVATIVE_HINT, "GL_FRAGMENT_SHADER_DERIVATIVE_HINT" );
	#endif
	#ifdef GL_SHADING_LANGUAGE_VERSION
		swigIntConstant( GL_SHADING_LANGUAGE_VERSION, "GL_SHADING_LANGUAGE_VERSION" );
	#endif
	#ifdef GL_CURRENT_PROGRAM
		swigIntConstant( GL_CURRENT_PROGRAM, "GL_CURRENT_PROGRAM" );
	#endif
	#ifdef GL_POINT_SPRITE_COORD_ORIGIN
		swigIntConstant( GL_POINT_SPRITE_COORD_ORIGIN, "GL_POINT_SPRITE_COORD_ORIGIN" );
	#endif
	#ifdef GL_LOWER_LEFT
		swigIntConstant( GL_LOWER_LEFT, "GL_LOWER_LEFT" );
	#endif
	#ifdef GL_UPPER_LEFT
		swigIntConstant( GL_UPPER_LEFT, "GL_UPPER_LEFT" );
	#endif
	#ifdef GL_STENCIL_BACK_REF
		swigIntConstant( GL_STENCIL_BACK_REF, "GL_STENCIL_BACK_REF" );
	#endif
	#ifdef GL_STENCIL_BACK_VALUE_MASK
		swigIntConstant( GL_STENCIL_BACK_VALUE_MASK, "GL_STENCIL_BACK_VALUE_MASK" );
	#endif
	#ifdef GL_STENCIL_BACK_WRITEMASK
		swigIntConstant( GL_STENCIL_BACK_WRITEMASK, "GL_STENCIL_BACK_WRITEMASK" );
	#endif
	#ifdef GL_VERTEX_PROGRAM_TWO_SIDE
		swigIntConstant( GL_VERTEX_PROGRAM_TWO_SIDE, "GL_VERTEX_PROGRAM_TWO_SIDE" );
	#endif
	#ifdef GL_POINT_SPRITE
		swigIntConstant( GL_POINT_SPRITE, "GL_POINT_SPRITE" );
	#endif
	#ifdef GL_COORD_REPLACE
		swigIntConstant( GL_COORD_REPLACE, "GL_COORD_REPLACE" );
	#endif
	#ifdef GL_MAX_TEXTURE_COORDS
		swigIntConstant( GL_MAX_TEXTURE_COORDS, "GL_MAX_TEXTURE_COORDS" );
	#endif
	#ifdef GL_VERSION_2_1
		swigIntConstant( GL_VERSION_2_1, "GL_VERSION_2_1" );
	#endif
	#ifdef GL_PIXEL_PACK_BUFFER
		swigIntConstant( GL_PIXEL_PACK_BUFFER, "GL_PIXEL_PACK_BUFFER" );
	#endif
	#ifdef GL_PIXEL_UNPACK_BUFFER
		swigIntConstant( GL_PIXEL_UNPACK_BUFFER, "GL_PIXEL_UNPACK_BUFFER" );
	#endif
	#ifdef GL_PIXEL_PACK_BUFFER_BINDING
		swigIntConstant( GL_PIXEL_PACK_BUFFER_BINDING, "GL_PIXEL_PACK_BUFFER_BINDING" );
	#endif
	#ifdef GL_PIXEL_UNPACK_BUFFER_BINDING
		swigIntConstant( GL_PIXEL_UNPACK_BUFFER_BINDING, "GL_PIXEL_UNPACK_BUFFER_BINDING" );
	#endif
	#ifdef GL_FLOAT_MAT2x3
		swigIntConstant( GL_FLOAT_MAT2x3, "GL_FLOAT_MAT2x3" );
	#endif
	#ifdef GL_FLOAT_MAT2x4
		swigIntConstant( GL_FLOAT_MAT2x4, "GL_FLOAT_MAT2x4" );
	#endif
	#ifdef GL_FLOAT_MAT3x2
		swigIntConstant( GL_FLOAT_MAT3x2, "GL_FLOAT_MAT3x2" );
	#endif
	#ifdef GL_FLOAT_MAT3x4
		swigIntConstant( GL_FLOAT_MAT3x4, "GL_FLOAT_MAT3x4" );
	#endif
	#ifdef GL_FLOAT_MAT4x2
		swigIntConstant( GL_FLOAT_MAT4x2, "GL_FLOAT_MAT4x2" );
	#endif
	#ifdef GL_FLOAT_MAT4x3
		swigIntConstant( GL_FLOAT_MAT4x3, "GL_FLOAT_MAT4x3" );
	#endif
	#ifdef GL_SRGB
		swigIntConstant( GL_SRGB, "GL_SRGB" );
	#endif
	#ifdef GL_SRGB8
		swigIntConstant( GL_SRGB8, "GL_SRGB8" );
	#endif
	#ifdef GL_SRGB_ALPHA
		swigIntConstant( GL_SRGB_ALPHA, "GL_SRGB_ALPHA" );
	#endif
	#ifdef GL_SRGB8_ALPHA8
		swigIntConstant( GL_SRGB8_ALPHA8, "GL_SRGB8_ALPHA8" );
	#endif
	#ifdef GL_COMPRESSED_SRGB
		swigIntConstant( GL_COMPRESSED_SRGB, "GL_COMPRESSED_SRGB" );
	#endif
	#ifdef GL_COMPRESSED_SRGB_ALPHA
		swigIntConstant( GL_COMPRESSED_SRGB_ALPHA, "GL_COMPRESSED_SRGB_ALPHA" );
	#endif
	#ifdef GL_CURRENT_RASTER_SECONDARY_COLOR
		swigIntConstant( GL_CURRENT_RASTER_SECONDARY_COLOR, "GL_CURRENT_RASTER_SECONDARY_COLOR" );
	#endif
	#ifdef GL_SLUMINANCE_ALPHA
		swigIntConstant( GL_SLUMINANCE_ALPHA, "GL_SLUMINANCE_ALPHA" );
	#endif
	#ifdef GL_SLUMINANCE8_ALPHA8
		swigIntConstant( GL_SLUMINANCE8_ALPHA8, "GL_SLUMINANCE8_ALPHA8" );
	#endif
	#ifdef GL_SLUMINANCE
		swigIntConstant( GL_SLUMINANCE, "GL_SLUMINANCE" );
	#endif
	#ifdef GL_SLUMINANCE8
		swigIntConstant( GL_SLUMINANCE8, "GL_SLUMINANCE8" );
	#endif
	#ifdef GL_COMPRESSED_SLUMINANCE
		swigIntConstant( GL_COMPRESSED_SLUMINANCE, "GL_COMPRESSED_SLUMINANCE" );
	#endif
	#ifdef GL_COMPRESSED_SLUMINANCE_ALPHA
		swigIntConstant( GL_COMPRESSED_SLUMINANCE_ALPHA, "GL_COMPRESSED_SLUMINANCE_ALPHA" );
	#endif
	#ifdef GL_VERSION_3_0
		swigIntConstant( GL_VERSION_3_0, "GL_VERSION_3_0" );
	#endif
	#ifdef GL_COMPARE_REF_TO_TEXTURE
		swigIntConstant( GL_COMPARE_REF_TO_TEXTURE, "GL_COMPARE_REF_TO_TEXTURE" );
	#endif
	#ifdef GL_CLIP_DISTANCE0
		swigIntConstant( GL_CLIP_DISTANCE0, "GL_CLIP_DISTANCE0" );
	#endif
	#ifdef GL_CLIP_DISTANCE1
		swigIntConstant( GL_CLIP_DISTANCE1, "GL_CLIP_DISTANCE1" );
	#endif
	#ifdef GL_CLIP_DISTANCE2
		swigIntConstant( GL_CLIP_DISTANCE2, "GL_CLIP_DISTANCE2" );
	#endif
	#ifdef GL_CLIP_DISTANCE3
		swigIntConstant( GL_CLIP_DISTANCE3, "GL_CLIP_DISTANCE3" );
	#endif
	#ifdef GL_CLIP_DISTANCE4
		swigIntConstant( GL_CLIP_DISTANCE4, "GL_CLIP_DISTANCE4" );
	#endif
	#ifdef GL_CLIP_DISTANCE5
		swigIntConstant( GL_CLIP_DISTANCE5, "GL_CLIP_DISTANCE5" );
	#endif
	#ifdef GL_CLIP_DISTANCE6
		swigIntConstant( GL_CLIP_DISTANCE6, "GL_CLIP_DISTANCE6" );
	#endif
	#ifdef GL_CLIP_DISTANCE7
		swigIntConstant( GL_CLIP_DISTANCE7, "GL_CLIP_DISTANCE7" );
	#endif
	#ifdef GL_MAX_CLIP_DISTANCES
		swigIntConstant( GL_MAX_CLIP_DISTANCES, "GL_MAX_CLIP_DISTANCES" );
	#endif
	#ifdef GL_MAJOR_VERSION
		swigIntConstant( GL_MAJOR_VERSION, "GL_MAJOR_VERSION" );
	#endif
	#ifdef GL_MINOR_VERSION
		swigIntConstant( GL_MINOR_VERSION, "GL_MINOR_VERSION" );
	#endif
	#ifdef GL_NUM_EXTENSIONS
		swigIntConstant( GL_NUM_EXTENSIONS, "GL_NUM_EXTENSIONS" );
	#endif
	#ifdef GL_CONTEXT_FLAGS
		swigIntConstant( GL_CONTEXT_FLAGS, "GL_CONTEXT_FLAGS" );
	#endif
	#ifdef GL_COMPRESSED_RED
		swigIntConstant( GL_COMPRESSED_RED, "GL_COMPRESSED_RED" );
	#endif
	#ifdef GL_COMPRESSED_RG
		swigIntConstant( GL_COMPRESSED_RG, "GL_COMPRESSED_RG" );
	#endif
	#ifdef GL_CONTEXT_FLAG_FORWARD_COMPATIBLE_BIT
		swigIntConstant( GL_CONTEXT_FLAG_FORWARD_COMPATIBLE_BIT, "GL_CONTEXT_FLAG_FORWARD_COMPATIBLE_BIT" );
	#endif
	#ifdef GL_RGBA32F
		swigIntConstant( GL_RGBA32F, "GL_RGBA32F" );
	#endif
	#ifdef GL_RGB32F
		swigIntConstant( GL_RGB32F, "GL_RGB32F" );
	#endif
	#ifdef GL_RGBA16F
		swigIntConstant( GL_RGBA16F, "GL_RGBA16F" );
	#endif
	#ifdef GL_RGB16F
		swigIntConstant( GL_RGB16F, "GL_RGB16F" );
	#endif
	#ifdef GL_VERTEX_ATTRIB_ARRAY_INTEGER
		swigIntConstant( GL_VERTEX_ATTRIB_ARRAY_INTEGER, "GL_VERTEX_ATTRIB_ARRAY_INTEGER" );
	#endif
	#ifdef GL_MAX_ARRAY_TEXTURE_LAYERS
		swigIntConstant( GL_MAX_ARRAY_TEXTURE_LAYERS, "GL_MAX_ARRAY_TEXTURE_LAYERS" );
	#endif
	#ifdef GL_MIN_PROGRAM_TEXEL_OFFSET
		swigIntConstant( GL_MIN_PROGRAM_TEXEL_OFFSET, "GL_MIN_PROGRAM_TEXEL_OFFSET" );
	#endif
	#ifdef GL_MAX_PROGRAM_TEXEL_OFFSET
		swigIntConstant( GL_MAX_PROGRAM_TEXEL_OFFSET, "GL_MAX_PROGRAM_TEXEL_OFFSET" );
	#endif
	#ifdef GL_CLAMP_READ_COLOR
		swigIntConstant( GL_CLAMP_READ_COLOR, "GL_CLAMP_READ_COLOR" );
	#endif
	#ifdef GL_FIXED_ONLY
		swigIntConstant( GL_FIXED_ONLY, "GL_FIXED_ONLY" );
	#endif
	#ifdef GL_MAX_VARYING_COMPONENTS
		swigIntConstant( GL_MAX_VARYING_COMPONENTS, "GL_MAX_VARYING_COMPONENTS" );
	#endif
	#ifdef GL_TEXTURE_1D_ARRAY
		swigIntConstant( GL_TEXTURE_1D_ARRAY, "GL_TEXTURE_1D_ARRAY" );
	#endif
	#ifdef GL_PROXY_TEXTURE_1D_ARRAY
		swigIntConstant( GL_PROXY_TEXTURE_1D_ARRAY, "GL_PROXY_TEXTURE_1D_ARRAY" );
	#endif
	#ifdef GL_TEXTURE_2D_ARRAY
		swigIntConstant( GL_TEXTURE_2D_ARRAY, "GL_TEXTURE_2D_ARRAY" );
	#endif
	#ifdef GL_PROXY_TEXTURE_2D_ARRAY
		swigIntConstant( GL_PROXY_TEXTURE_2D_ARRAY, "GL_PROXY_TEXTURE_2D_ARRAY" );
	#endif
	#ifdef GL_TEXTURE_BINDING_1D_ARRAY
		swigIntConstant( GL_TEXTURE_BINDING_1D_ARRAY, "GL_TEXTURE_BINDING_1D_ARRAY" );
	#endif
	#ifdef GL_TEXTURE_BINDING_2D_ARRAY
		swigIntConstant( GL_TEXTURE_BINDING_2D_ARRAY, "GL_TEXTURE_BINDING_2D_ARRAY" );
	#endif
	#ifdef GL_R11F_G11F_B10F
		swigIntConstant( GL_R11F_G11F_B10F, "GL_R11F_G11F_B10F" );
	#endif
	#ifdef GL_UNSIGNED_INT_10F_11F_11F_REV
		swigIntConstant( GL_UNSIGNED_INT_10F_11F_11F_REV, "GL_UNSIGNED_INT_10F_11F_11F_REV" );
	#endif
	#ifdef GL_RGB9_E5
		swigIntConstant( GL_RGB9_E5, "GL_RGB9_E5" );
	#endif
	#ifdef GL_UNSIGNED_INT_5_9_9_9_REV
		swigIntConstant( GL_UNSIGNED_INT_5_9_9_9_REV, "GL_UNSIGNED_INT_5_9_9_9_REV" );
	#endif
	#ifdef GL_TEXTURE_SHARED_SIZE
		swigIntConstant( GL_TEXTURE_SHARED_SIZE, "GL_TEXTURE_SHARED_SIZE" );
	#endif
	#ifdef GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH
		swigIntConstant( GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH, "GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH" );
	#endif
	#ifdef GL_TRANSFORM_FEEDBACK_BUFFER_MODE
		swigIntConstant( GL_TRANSFORM_FEEDBACK_BUFFER_MODE, "GL_TRANSFORM_FEEDBACK_BUFFER_MODE" );
	#endif
	#ifdef GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS
		swigIntConstant( GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS, "GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS" );
	#endif
	#ifdef GL_TRANSFORM_FEEDBACK_VARYINGS
		swigIntConstant( GL_TRANSFORM_FEEDBACK_VARYINGS, "GL_TRANSFORM_FEEDBACK_VARYINGS" );
	#endif
	#ifdef GL_TRANSFORM_FEEDBACK_BUFFER_START
		swigIntConstant( GL_TRANSFORM_FEEDBACK_BUFFER_START, "GL_TRANSFORM_FEEDBACK_BUFFER_START" );
	#endif
	#ifdef GL_TRANSFORM_FEEDBACK_BUFFER_SIZE
		swigIntConstant( GL_TRANSFORM_FEEDBACK_BUFFER_SIZE, "GL_TRANSFORM_FEEDBACK_BUFFER_SIZE" );
	#endif
	#ifdef GL_PRIMITIVES_GENERATED
		swigIntConstant( GL_PRIMITIVES_GENERATED, "GL_PRIMITIVES_GENERATED" );
	#endif
	#ifdef GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN
		swigIntConstant( GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN, "GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN" );
	#endif
	#ifdef GL_RASTERIZER_DISCARD
		swigIntConstant( GL_RASTERIZER_DISCARD, "GL_RASTERIZER_DISCARD" );
	#endif
	#ifdef GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS
		swigIntConstant( GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS, "GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS" );
	#endif
	#ifdef GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS
		swigIntConstant( GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS, "GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS" );
	#endif
	#ifdef GL_INTERLEAVED_ATTRIBS
		swigIntConstant( GL_INTERLEAVED_ATTRIBS, "GL_INTERLEAVED_ATTRIBS" );
	#endif
	#ifdef GL_SEPARATE_ATTRIBS
		swigIntConstant( GL_SEPARATE_ATTRIBS, "GL_SEPARATE_ATTRIBS" );
	#endif
	#ifdef GL_TRANSFORM_FEEDBACK_BUFFER
		swigIntConstant( GL_TRANSFORM_FEEDBACK_BUFFER, "GL_TRANSFORM_FEEDBACK_BUFFER" );
	#endif
	#ifdef GL_TRANSFORM_FEEDBACK_BUFFER_BINDING
		swigIntConstant( GL_TRANSFORM_FEEDBACK_BUFFER_BINDING, "GL_TRANSFORM_FEEDBACK_BUFFER_BINDING" );
	#endif
	#ifdef GL_RGBA32UI
		swigIntConstant( GL_RGBA32UI, "GL_RGBA32UI" );
	#endif
	#ifdef GL_RGB32UI
		swigIntConstant( GL_RGB32UI, "GL_RGB32UI" );
	#endif
	#ifdef GL_RGBA16UI
		swigIntConstant( GL_RGBA16UI, "GL_RGBA16UI" );
	#endif
	#ifdef GL_RGB16UI
		swigIntConstant( GL_RGB16UI, "GL_RGB16UI" );
	#endif
	#ifdef GL_RGBA8UI
		swigIntConstant( GL_RGBA8UI, "GL_RGBA8UI" );
	#endif
	#ifdef GL_RGB8UI
		swigIntConstant( GL_RGB8UI, "GL_RGB8UI" );
	#endif
	#ifdef GL_RGBA32I
		swigIntConstant( GL_RGBA32I, "GL_RGBA32I" );
	#endif
	#ifdef GL_RGB32I
		swigIntConstant( GL_RGB32I, "GL_RGB32I" );
	#endif
	#ifdef GL_RGBA16I
		swigIntConstant( GL_RGBA16I, "GL_RGBA16I" );
	#endif
	#ifdef GL_RGB16I
		swigIntConstant( GL_RGB16I, "GL_RGB16I" );
	#endif
	#ifdef GL_RGBA8I
		swigIntConstant( GL_RGBA8I, "GL_RGBA8I" );
	#endif
	#ifdef GL_RGB8I
		swigIntConstant( GL_RGB8I, "GL_RGB8I" );
	#endif
	#ifdef GL_RED_INTEGER
		swigIntConstant( GL_RED_INTEGER, "GL_RED_INTEGER" );
	#endif
	#ifdef GL_GREEN_INTEGER
		swigIntConstant( GL_GREEN_INTEGER, "GL_GREEN_INTEGER" );
	#endif
	#ifdef GL_BLUE_INTEGER
		swigIntConstant( GL_BLUE_INTEGER, "GL_BLUE_INTEGER" );
	#endif
	#ifdef GL_RGB_INTEGER
		swigIntConstant( GL_RGB_INTEGER, "GL_RGB_INTEGER" );
	#endif
	#ifdef GL_RGBA_INTEGER
		swigIntConstant( GL_RGBA_INTEGER, "GL_RGBA_INTEGER" );
	#endif
	#ifdef GL_BGR_INTEGER
		swigIntConstant( GL_BGR_INTEGER, "GL_BGR_INTEGER" );
	#endif
	#ifdef GL_BGRA_INTEGER
		swigIntConstant( GL_BGRA_INTEGER, "GL_BGRA_INTEGER" );
	#endif
	#ifdef GL_SAMPLER_1D_ARRAY
		swigIntConstant( GL_SAMPLER_1D_ARRAY, "GL_SAMPLER_1D_ARRAY" );
	#endif
	#ifdef GL_SAMPLER_2D_ARRAY
		swigIntConstant( GL_SAMPLER_2D_ARRAY, "GL_SAMPLER_2D_ARRAY" );
	#endif
	#ifdef GL_SAMPLER_1D_ARRAY_SHADOW
		swigIntConstant( GL_SAMPLER_1D_ARRAY_SHADOW, "GL_SAMPLER_1D_ARRAY_SHADOW" );
	#endif
	#ifdef GL_SAMPLER_2D_ARRAY_SHADOW
		swigIntConstant( GL_SAMPLER_2D_ARRAY_SHADOW, "GL_SAMPLER_2D_ARRAY_SHADOW" );
	#endif
	#ifdef GL_SAMPLER_CUBE_SHADOW
		swigIntConstant( GL_SAMPLER_CUBE_SHADOW, "GL_SAMPLER_CUBE_SHADOW" );
	#endif
	#ifdef GL_UNSIGNED_INT_VEC2
		swigIntConstant( GL_UNSIGNED_INT_VEC2, "GL_UNSIGNED_INT_VEC2" );
	#endif
	#ifdef GL_UNSIGNED_INT_VEC3
		swigIntConstant( GL_UNSIGNED_INT_VEC3, "GL_UNSIGNED_INT_VEC3" );
	#endif
	#ifdef GL_UNSIGNED_INT_VEC4
		swigIntConstant( GL_UNSIGNED_INT_VEC4, "GL_UNSIGNED_INT_VEC4" );
	#endif
	#ifdef GL_INT_SAMPLER_1D
		swigIntConstant( GL_INT_SAMPLER_1D, "GL_INT_SAMPLER_1D" );
	#endif
	#ifdef GL_INT_SAMPLER_2D
		swigIntConstant( GL_INT_SAMPLER_2D, "GL_INT_SAMPLER_2D" );
	#endif
	#ifdef GL_INT_SAMPLER_3D
		swigIntConstant( GL_INT_SAMPLER_3D, "GL_INT_SAMPLER_3D" );
	#endif
	#ifdef GL_INT_SAMPLER_CUBE
		swigIntConstant( GL_INT_SAMPLER_CUBE, "GL_INT_SAMPLER_CUBE" );
	#endif
	#ifdef GL_INT_SAMPLER_1D_ARRAY
		swigIntConstant( GL_INT_SAMPLER_1D_ARRAY, "GL_INT_SAMPLER_1D_ARRAY" );
	#endif
	#ifdef GL_INT_SAMPLER_2D_ARRAY
		swigIntConstant( GL_INT_SAMPLER_2D_ARRAY, "GL_INT_SAMPLER_2D_ARRAY" );
	#endif
	#ifdef GL_UNSIGNED_INT_SAMPLER_1D
		swigIntConstant( GL_UNSIGNED_INT_SAMPLER_1D, "GL_UNSIGNED_INT_SAMPLER_1D" );
	#endif
	#ifdef GL_UNSIGNED_INT_SAMPLER_2D
		swigIntConstant( GL_UNSIGNED_INT_SAMPLER_2D, "GL_UNSIGNED_INT_SAMPLER_2D" );
	#endif
	#ifdef GL_UNSIGNED_INT_SAMPLER_3D
		swigIntConstant( GL_UNSIGNED_INT_SAMPLER_3D, "GL_UNSIGNED_INT_SAMPLER_3D" );
	#endif
	#ifdef GL_UNSIGNED_INT_SAMPLER_CUBE
		swigIntConstant( GL_UNSIGNED_INT_SAMPLER_CUBE, "GL_UNSIGNED_INT_SAMPLER_CUBE" );
	#endif
	#ifdef GL_UNSIGNED_INT_SAMPLER_1D_ARRAY
		swigIntConstant( GL_UNSIGNED_INT_SAMPLER_1D_ARRAY, "GL_UNSIGNED_INT_SAMPLER_1D_ARRAY" );
	#endif
	#ifdef GL_UNSIGNED_INT_SAMPLER_2D_ARRAY
		swigIntConstant( GL_UNSIGNED_INT_SAMPLER_2D_ARRAY, "GL_UNSIGNED_INT_SAMPLER_2D_ARRAY" );
	#endif
	#ifdef GL_QUERY_WAIT
		swigIntConstant( GL_QUERY_WAIT, "GL_QUERY_WAIT" );
	#endif
	#ifdef GL_QUERY_NO_WAIT
		swigIntConstant( GL_QUERY_NO_WAIT, "GL_QUERY_NO_WAIT" );
	#endif
	#ifdef GL_QUERY_BY_REGION_WAIT
		swigIntConstant( GL_QUERY_BY_REGION_WAIT, "GL_QUERY_BY_REGION_WAIT" );
	#endif
	#ifdef GL_QUERY_BY_REGION_NO_WAIT
		swigIntConstant( GL_QUERY_BY_REGION_NO_WAIT, "GL_QUERY_BY_REGION_NO_WAIT" );
	#endif
	#ifdef GL_BUFFER_ACCESS_FLAGS
		swigIntConstant( GL_BUFFER_ACCESS_FLAGS, "GL_BUFFER_ACCESS_FLAGS" );
	#endif
	#ifdef GL_BUFFER_MAP_LENGTH
		swigIntConstant( GL_BUFFER_MAP_LENGTH, "GL_BUFFER_MAP_LENGTH" );
	#endif
	#ifdef GL_BUFFER_MAP_OFFSET
		swigIntConstant( GL_BUFFER_MAP_OFFSET, "GL_BUFFER_MAP_OFFSET" );
	#endif
	#ifdef GL_DEPTH_COMPONENT32F
		swigIntConstant( GL_DEPTH_COMPONENT32F, "GL_DEPTH_COMPONENT32F" );
	#endif
	#ifdef GL_DEPTH32F_STENCIL8
		swigIntConstant( GL_DEPTH32F_STENCIL8, "GL_DEPTH32F_STENCIL8" );
	#endif
	#ifdef GL_FLOAT_32_UNSIGNED_INT_24_8_REV
		swigIntConstant( GL_FLOAT_32_UNSIGNED_INT_24_8_REV, "GL_FLOAT_32_UNSIGNED_INT_24_8_REV" );
	#endif
	#ifdef GL_INVALID_FRAMEBUFFER_OPERATION
		swigIntConstant( GL_INVALID_FRAMEBUFFER_OPERATION, "GL_INVALID_FRAMEBUFFER_OPERATION" );
	#endif
	#ifdef GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING
		swigIntConstant( GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING, "GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING" );
	#endif
	#ifdef GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE
		swigIntConstant( GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE, "GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE" );
	#endif
	#ifdef GL_FRAMEBUFFER_ATTACHMENT_RED_SIZE
		swigIntConstant( GL_FRAMEBUFFER_ATTACHMENT_RED_SIZE, "GL_FRAMEBUFFER_ATTACHMENT_RED_SIZE" );
	#endif
	#ifdef GL_FRAMEBUFFER_ATTACHMENT_GREEN_SIZE
		swigIntConstant( GL_FRAMEBUFFER_ATTACHMENT_GREEN_SIZE, "GL_FRAMEBUFFER_ATTACHMENT_GREEN_SIZE" );
	#endif
	#ifdef GL_FRAMEBUFFER_ATTACHMENT_BLUE_SIZE
		swigIntConstant( GL_FRAMEBUFFER_ATTACHMENT_BLUE_SIZE, "GL_FRAMEBUFFER_ATTACHMENT_BLUE_SIZE" );
	#endif
	#ifdef GL_FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE
		swigIntConstant( GL_FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE, "GL_FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE" );
	#endif
	#ifdef GL_FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE
		swigIntConstant( GL_FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE, "GL_FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE" );
	#endif
	#ifdef GL_FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE
		swigIntConstant( GL_FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE, "GL_FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE" );
	#endif
	#ifdef GL_FRAMEBUFFER_DEFAULT
		swigIntConstant( GL_FRAMEBUFFER_DEFAULT, "GL_FRAMEBUFFER_DEFAULT" );
	#endif
	#ifdef GL_FRAMEBUFFER_UNDEFINED
		swigIntConstant( GL_FRAMEBUFFER_UNDEFINED, "GL_FRAMEBUFFER_UNDEFINED" );
	#endif
	#ifdef GL_DEPTH_STENCIL_ATTACHMENT
		swigIntConstant( GL_DEPTH_STENCIL_ATTACHMENT, "GL_DEPTH_STENCIL_ATTACHMENT" );
	#endif
	#ifdef GL_MAX_RENDERBUFFER_SIZE
		swigIntConstant( GL_MAX_RENDERBUFFER_SIZE, "GL_MAX_RENDERBUFFER_SIZE" );
	#endif
	#ifdef GL_DEPTH_STENCIL
		swigIntConstant( GL_DEPTH_STENCIL, "GL_DEPTH_STENCIL" );
	#endif
	#ifdef GL_UNSIGNED_INT_24_8
		swigIntConstant( GL_UNSIGNED_INT_24_8, "GL_UNSIGNED_INT_24_8" );
	#endif
	#ifdef GL_DEPTH24_STENCIL8
		swigIntConstant( GL_DEPTH24_STENCIL8, "GL_DEPTH24_STENCIL8" );
	#endif
	#ifdef GL_TEXTURE_STENCIL_SIZE
		swigIntConstant( GL_TEXTURE_STENCIL_SIZE, "GL_TEXTURE_STENCIL_SIZE" );
	#endif
	#ifdef GL_TEXTURE_RED_TYPE
		swigIntConstant( GL_TEXTURE_RED_TYPE, "GL_TEXTURE_RED_TYPE" );
	#endif
	#ifdef GL_TEXTURE_GREEN_TYPE
		swigIntConstant( GL_TEXTURE_GREEN_TYPE, "GL_TEXTURE_GREEN_TYPE" );
	#endif
	#ifdef GL_TEXTURE_BLUE_TYPE
		swigIntConstant( GL_TEXTURE_BLUE_TYPE, "GL_TEXTURE_BLUE_TYPE" );
	#endif
	#ifdef GL_TEXTURE_ALPHA_TYPE
		swigIntConstant( GL_TEXTURE_ALPHA_TYPE, "GL_TEXTURE_ALPHA_TYPE" );
	#endif
	#ifdef GL_TEXTURE_DEPTH_TYPE
		swigIntConstant( GL_TEXTURE_DEPTH_TYPE, "GL_TEXTURE_DEPTH_TYPE" );
	#endif
	#ifdef GL_UNSIGNED_NORMALIZED
		swigIntConstant( GL_UNSIGNED_NORMALIZED, "GL_UNSIGNED_NORMALIZED" );
	#endif
	#ifdef GL_FRAMEBUFFER_BINDING
		swigIntConstant( GL_FRAMEBUFFER_BINDING, "GL_FRAMEBUFFER_BINDING" );
	#endif
	#ifdef GL_DRAW_FRAMEBUFFER_BINDING
		swigIntConstant( GL_DRAW_FRAMEBUFFER_BINDING, "GL_DRAW_FRAMEBUFFER_BINDING" );
	#endif
	#ifdef GL_RENDERBUFFER_BINDING
		swigIntConstant( GL_RENDERBUFFER_BINDING, "GL_RENDERBUFFER_BINDING" );
	#endif
	#ifdef GL_READ_FRAMEBUFFER
		swigIntConstant( GL_READ_FRAMEBUFFER, "GL_READ_FRAMEBUFFER" );
	#endif
	#ifdef GL_DRAW_FRAMEBUFFER
		swigIntConstant( GL_DRAW_FRAMEBUFFER, "GL_DRAW_FRAMEBUFFER" );
	#endif
	#ifdef GL_READ_FRAMEBUFFER_BINDING
		swigIntConstant( GL_READ_FRAMEBUFFER_BINDING, "GL_READ_FRAMEBUFFER_BINDING" );
	#endif
	#ifdef GL_RENDERBUFFER_SAMPLES
		swigIntConstant( GL_RENDERBUFFER_SAMPLES, "GL_RENDERBUFFER_SAMPLES" );
	#endif
	#ifdef GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE
		swigIntConstant( GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE, "GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE" );
	#endif
	#ifdef GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME
		swigIntConstant( GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME, "GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME" );
	#endif
	#ifdef GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL
		swigIntConstant( GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL, "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL" );
	#endif
	#ifdef GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE
		swigIntConstant( GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE, "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE" );
	#endif
	#ifdef GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER
		swigIntConstant( GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER, "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER" );
	#endif
	#ifdef GL_FRAMEBUFFER_COMPLETE
		swigIntConstant( GL_FRAMEBUFFER_COMPLETE, "GL_FRAMEBUFFER_COMPLETE" );
	#endif
	#ifdef GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT
		swigIntConstant( GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT, "GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT" );
	#endif
	#ifdef GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT
		swigIntConstant( GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT, "GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT" );
	#endif
	#ifdef GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER
		swigIntConstant( GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER, "GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER" );
	#endif
	#ifdef GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER
		swigIntConstant( GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER, "GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER" );
	#endif
	#ifdef GL_FRAMEBUFFER_UNSUPPORTED
		swigIntConstant( GL_FRAMEBUFFER_UNSUPPORTED, "GL_FRAMEBUFFER_UNSUPPORTED" );
	#endif
	#ifdef GL_MAX_COLOR_ATTACHMENTS
		swigIntConstant( GL_MAX_COLOR_ATTACHMENTS, "GL_MAX_COLOR_ATTACHMENTS" );
	#endif
	#ifdef GL_COLOR_ATTACHMENT0
		swigIntConstant( GL_COLOR_ATTACHMENT0, "GL_COLOR_ATTACHMENT0" );
	#endif
	#ifdef GL_COLOR_ATTACHMENT1
		swigIntConstant( GL_COLOR_ATTACHMENT1, "GL_COLOR_ATTACHMENT1" );
	#endif
	#ifdef GL_COLOR_ATTACHMENT2
		swigIntConstant( GL_COLOR_ATTACHMENT2, "GL_COLOR_ATTACHMENT2" );
	#endif
	#ifdef GL_COLOR_ATTACHMENT3
		swigIntConstant( GL_COLOR_ATTACHMENT3, "GL_COLOR_ATTACHMENT3" );
	#endif
	#ifdef GL_COLOR_ATTACHMENT4
		swigIntConstant( GL_COLOR_ATTACHMENT4, "GL_COLOR_ATTACHMENT4" );
	#endif
	#ifdef GL_COLOR_ATTACHMENT5
		swigIntConstant( GL_COLOR_ATTACHMENT5, "GL_COLOR_ATTACHMENT5" );
	#endif
	#ifdef GL_COLOR_ATTACHMENT6
		swigIntConstant( GL_COLOR_ATTACHMENT6, "GL_COLOR_ATTACHMENT6" );
	#endif
	#ifdef GL_COLOR_ATTACHMENT7
		swigIntConstant( GL_COLOR_ATTACHMENT7, "GL_COLOR_ATTACHMENT7" );
	#endif
	#ifdef GL_COLOR_ATTACHMENT8
		swigIntConstant( GL_COLOR_ATTACHMENT8, "GL_COLOR_ATTACHMENT8" );
	#endif
	#ifdef GL_COLOR_ATTACHMENT9
		swigIntConstant( GL_COLOR_ATTACHMENT9, "GL_COLOR_ATTACHMENT9" );
	#endif
	#ifdef GL_COLOR_ATTACHMENT10
		swigIntConstant( GL_COLOR_ATTACHMENT10, "GL_COLOR_ATTACHMENT10" );
	#endif
	#ifdef GL_COLOR_ATTACHMENT11
		swigIntConstant( GL_COLOR_ATTACHMENT11, "GL_COLOR_ATTACHMENT11" );
	#endif
	#ifdef GL_COLOR_ATTACHMENT12
		swigIntConstant( GL_COLOR_ATTACHMENT12, "GL_COLOR_ATTACHMENT12" );
	#endif
	#ifdef GL_COLOR_ATTACHMENT13
		swigIntConstant( GL_COLOR_ATTACHMENT13, "GL_COLOR_ATTACHMENT13" );
	#endif
	#ifdef GL_COLOR_ATTACHMENT14
		swigIntConstant( GL_COLOR_ATTACHMENT14, "GL_COLOR_ATTACHMENT14" );
	#endif
	#ifdef GL_COLOR_ATTACHMENT15
		swigIntConstant( GL_COLOR_ATTACHMENT15, "GL_COLOR_ATTACHMENT15" );
	#endif
	#ifdef GL_COLOR_ATTACHMENT16
		swigIntConstant( GL_COLOR_ATTACHMENT16, "GL_COLOR_ATTACHMENT16" );
	#endif
	#ifdef GL_COLOR_ATTACHMENT17
		swigIntConstant( GL_COLOR_ATTACHMENT17, "GL_COLOR_ATTACHMENT17" );
	#endif
	#ifdef GL_COLOR_ATTACHMENT18
		swigIntConstant( GL_COLOR_ATTACHMENT18, "GL_COLOR_ATTACHMENT18" );
	#endif
	#ifdef GL_COLOR_ATTACHMENT19
		swigIntConstant( GL_COLOR_ATTACHMENT19, "GL_COLOR_ATTACHMENT19" );
	#endif
	#ifdef GL_COLOR_ATTACHMENT20
		swigIntConstant( GL_COLOR_ATTACHMENT20, "GL_COLOR_ATTACHMENT20" );
	#endif
	#ifdef GL_COLOR_ATTACHMENT21
		swigIntConstant( GL_COLOR_ATTACHMENT21, "GL_COLOR_ATTACHMENT21" );
	#endif
	#ifdef GL_COLOR_ATTACHMENT22
		swigIntConstant( GL_COLOR_ATTACHMENT22, "GL_COLOR_ATTACHMENT22" );
	#endif
	#ifdef GL_COLOR_ATTACHMENT23
		swigIntConstant( GL_COLOR_ATTACHMENT23, "GL_COLOR_ATTACHMENT23" );
	#endif
	#ifdef GL_COLOR_ATTACHMENT24
		swigIntConstant( GL_COLOR_ATTACHMENT24, "GL_COLOR_ATTACHMENT24" );
	#endif
	#ifdef GL_COLOR_ATTACHMENT25
		swigIntConstant( GL_COLOR_ATTACHMENT25, "GL_COLOR_ATTACHMENT25" );
	#endif
	#ifdef GL_COLOR_ATTACHMENT26
		swigIntConstant( GL_COLOR_ATTACHMENT26, "GL_COLOR_ATTACHMENT26" );
	#endif
	#ifdef GL_COLOR_ATTACHMENT27
		swigIntConstant( GL_COLOR_ATTACHMENT27, "GL_COLOR_ATTACHMENT27" );
	#endif
	#ifdef GL_COLOR_ATTACHMENT28
		swigIntConstant( GL_COLOR_ATTACHMENT28, "GL_COLOR_ATTACHMENT28" );
	#endif
	#ifdef GL_COLOR_ATTACHMENT29
		swigIntConstant( GL_COLOR_ATTACHMENT29, "GL_COLOR_ATTACHMENT29" );
	#endif
	#ifdef GL_COLOR_ATTACHMENT30
		swigIntConstant( GL_COLOR_ATTACHMENT30, "GL_COLOR_ATTACHMENT30" );
	#endif
	#ifdef GL_COLOR_ATTACHMENT31
		swigIntConstant( GL_COLOR_ATTACHMENT31, "GL_COLOR_ATTACHMENT31" );
	#endif
	#ifdef GL_DEPTH_ATTACHMENT
		swigIntConstant( GL_DEPTH_ATTACHMENT, "GL_DEPTH_ATTACHMENT" );
	#endif
	#ifdef GL_STENCIL_ATTACHMENT
		swigIntConstant( GL_STENCIL_ATTACHMENT, "GL_STENCIL_ATTACHMENT" );
	#endif
	#ifdef GL_FRAMEBUFFER
		swigIntConstant( GL_FRAMEBUFFER, "GL_FRAMEBUFFER" );
	#endif
	#ifdef GL_RENDERBUFFER
		swigIntConstant( GL_RENDERBUFFER, "GL_RENDERBUFFER" );
	#endif
	#ifdef GL_RENDERBUFFER_WIDTH
		swigIntConstant( GL_RENDERBUFFER_WIDTH, "GL_RENDERBUFFER_WIDTH" );
	#endif
	#ifdef GL_RENDERBUFFER_HEIGHT
		swigIntConstant( GL_RENDERBUFFER_HEIGHT, "GL_RENDERBUFFER_HEIGHT" );
	#endif
	#ifdef GL_RENDERBUFFER_INTERNAL_FORMAT
		swigIntConstant( GL_RENDERBUFFER_INTERNAL_FORMAT, "GL_RENDERBUFFER_INTERNAL_FORMAT" );
	#endif
	#ifdef GL_STENCIL_INDEX1
		swigIntConstant( GL_STENCIL_INDEX1, "GL_STENCIL_INDEX1" );
	#endif
	#ifdef GL_STENCIL_INDEX4
		swigIntConstant( GL_STENCIL_INDEX4, "GL_STENCIL_INDEX4" );
	#endif
	#ifdef GL_STENCIL_INDEX8
		swigIntConstant( GL_STENCIL_INDEX8, "GL_STENCIL_INDEX8" );
	#endif
	#ifdef GL_STENCIL_INDEX16
		swigIntConstant( GL_STENCIL_INDEX16, "GL_STENCIL_INDEX16" );
	#endif
	#ifdef GL_RENDERBUFFER_RED_SIZE
		swigIntConstant( GL_RENDERBUFFER_RED_SIZE, "GL_RENDERBUFFER_RED_SIZE" );
	#endif
	#ifdef GL_RENDERBUFFER_GREEN_SIZE
		swigIntConstant( GL_RENDERBUFFER_GREEN_SIZE, "GL_RENDERBUFFER_GREEN_SIZE" );
	#endif
	#ifdef GL_RENDERBUFFER_BLUE_SIZE
		swigIntConstant( GL_RENDERBUFFER_BLUE_SIZE, "GL_RENDERBUFFER_BLUE_SIZE" );
	#endif
	#ifdef GL_RENDERBUFFER_ALPHA_SIZE
		swigIntConstant( GL_RENDERBUFFER_ALPHA_SIZE, "GL_RENDERBUFFER_ALPHA_SIZE" );
	#endif
	#ifdef GL_RENDERBUFFER_DEPTH_SIZE
		swigIntConstant( GL_RENDERBUFFER_DEPTH_SIZE, "GL_RENDERBUFFER_DEPTH_SIZE" );
	#endif
	#ifdef GL_RENDERBUFFER_STENCIL_SIZE
		swigIntConstant( GL_RENDERBUFFER_STENCIL_SIZE, "GL_RENDERBUFFER_STENCIL_SIZE" );
	#endif
	#ifdef GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE
		swigIntConstant( GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE, "GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE" );
	#endif
	#ifdef GL_MAX_SAMPLES
		swigIntConstant( GL_MAX_SAMPLES, "GL_MAX_SAMPLES" );
	#endif
	#ifdef GL_INDEX
		swigIntConstant( GL_INDEX, "GL_INDEX" );
	#endif
	#ifdef GL_TEXTURE_LUMINANCE_TYPE
		swigIntConstant( GL_TEXTURE_LUMINANCE_TYPE, "GL_TEXTURE_LUMINANCE_TYPE" );
	#endif
	#ifdef GL_TEXTURE_INTENSITY_TYPE
		swigIntConstant( GL_TEXTURE_INTENSITY_TYPE, "GL_TEXTURE_INTENSITY_TYPE" );
	#endif
	#ifdef GL_FRAMEBUFFER_SRGB
		swigIntConstant( GL_FRAMEBUFFER_SRGB, "GL_FRAMEBUFFER_SRGB" );
	#endif
	#ifdef GL_HALF_FLOAT
		swigIntConstant( GL_HALF_FLOAT, "GL_HALF_FLOAT" );
	#endif
	#ifdef GL_MAP_READ_BIT
		swigIntConstant( GL_MAP_READ_BIT, "GL_MAP_READ_BIT" );
	#endif
	#ifdef GL_MAP_WRITE_BIT
		swigIntConstant( GL_MAP_WRITE_BIT, "GL_MAP_WRITE_BIT" );
	#endif
	#ifdef GL_MAP_INVALIDATE_RANGE_BIT
		swigIntConstant( GL_MAP_INVALIDATE_RANGE_BIT, "GL_MAP_INVALIDATE_RANGE_BIT" );
	#endif
	#ifdef GL_MAP_INVALIDATE_BUFFER_BIT
		swigIntConstant( GL_MAP_INVALIDATE_BUFFER_BIT, "GL_MAP_INVALIDATE_BUFFER_BIT" );
	#endif
	#ifdef GL_MAP_FLUSH_EXPLICIT_BIT
		swigIntConstant( GL_MAP_FLUSH_EXPLICIT_BIT, "GL_MAP_FLUSH_EXPLICIT_BIT" );
	#endif
	#ifdef GL_MAP_UNSYNCHRONIZED_BIT
		swigIntConstant( GL_MAP_UNSYNCHRONIZED_BIT, "GL_MAP_UNSYNCHRONIZED_BIT" );
	#endif
	#ifdef GL_COMPRESSED_RED_RGTC1
		swigIntConstant( GL_COMPRESSED_RED_RGTC1, "GL_COMPRESSED_RED_RGTC1" );
	#endif
	#ifdef GL_COMPRESSED_SIGNED_RED_RGTC1
		swigIntConstant( GL_COMPRESSED_SIGNED_RED_RGTC1, "GL_COMPRESSED_SIGNED_RED_RGTC1" );
	#endif
	#ifdef GL_COMPRESSED_RG_RGTC2
		swigIntConstant( GL_COMPRESSED_RG_RGTC2, "GL_COMPRESSED_RG_RGTC2" );
	#endif
	#ifdef GL_COMPRESSED_SIGNED_RG_RGTC2
		swigIntConstant( GL_COMPRESSED_SIGNED_RG_RGTC2, "GL_COMPRESSED_SIGNED_RG_RGTC2" );
	#endif
	#ifdef GL_RG
		swigIntConstant( GL_RG, "GL_RG" );
	#endif
	#ifdef GL_RG_INTEGER
		swigIntConstant( GL_RG_INTEGER, "GL_RG_INTEGER" );
	#endif
	#ifdef GL_R8
		swigIntConstant( GL_R8, "GL_R8" );
	#endif
	#ifdef GL_R16
		swigIntConstant( GL_R16, "GL_R16" );
	#endif
	#ifdef GL_RG8
		swigIntConstant( GL_RG8, "GL_RG8" );
	#endif
	#ifdef GL_RG16
		swigIntConstant( GL_RG16, "GL_RG16" );
	#endif
	#ifdef GL_R16F
		swigIntConstant( GL_R16F, "GL_R16F" );
	#endif
	#ifdef GL_R32F
		swigIntConstant( GL_R32F, "GL_R32F" );
	#endif
	#ifdef GL_RG16F
		swigIntConstant( GL_RG16F, "GL_RG16F" );
	#endif
	#ifdef GL_RG32F
		swigIntConstant( GL_RG32F, "GL_RG32F" );
	#endif
	#ifdef GL_R8I
		swigIntConstant( GL_R8I, "GL_R8I" );
	#endif
	#ifdef GL_R8UI
		swigIntConstant( GL_R8UI, "GL_R8UI" );
	#endif
	#ifdef GL_R16I
		swigIntConstant( GL_R16I, "GL_R16I" );
	#endif
	#ifdef GL_R16UI
		swigIntConstant( GL_R16UI, "GL_R16UI" );
	#endif
	#ifdef GL_R32I
		swigIntConstant( GL_R32I, "GL_R32I" );
	#endif
	#ifdef GL_R32UI
		swigIntConstant( GL_R32UI, "GL_R32UI" );
	#endif
	#ifdef GL_RG8I
		swigIntConstant( GL_RG8I, "GL_RG8I" );
	#endif
	#ifdef GL_RG8UI
		swigIntConstant( GL_RG8UI, "GL_RG8UI" );
	#endif
	#ifdef GL_RG16I
		swigIntConstant( GL_RG16I, "GL_RG16I" );
	#endif
	#ifdef GL_RG16UI
		swigIntConstant( GL_RG16UI, "GL_RG16UI" );
	#endif
	#ifdef GL_RG32I
		swigIntConstant( GL_RG32I, "GL_RG32I" );
	#endif
	#ifdef GL_RG32UI
		swigIntConstant( GL_RG32UI, "GL_RG32UI" );
	#endif
	#ifdef GL_VERTEX_ARRAY_BINDING
		swigIntConstant( GL_VERTEX_ARRAY_BINDING, "GL_VERTEX_ARRAY_BINDING" );
	#endif
	#ifdef GL_CLAMP_VERTEX_COLOR
		swigIntConstant( GL_CLAMP_VERTEX_COLOR, "GL_CLAMP_VERTEX_COLOR" );
	#endif
	#ifdef GL_CLAMP_FRAGMENT_COLOR
		swigIntConstant( GL_CLAMP_FRAGMENT_COLOR, "GL_CLAMP_FRAGMENT_COLOR" );
	#endif
	#ifdef GL_ALPHA_INTEGER
		swigIntConstant( GL_ALPHA_INTEGER, "GL_ALPHA_INTEGER" );
	#endif
	#ifdef GL_VERSION_3_1
		swigIntConstant( GL_VERSION_3_1, "GL_VERSION_3_1" );
	#endif
	#ifdef GL_SAMPLER_2D_RECT
		swigIntConstant( GL_SAMPLER_2D_RECT, "GL_SAMPLER_2D_RECT" );
	#endif
	#ifdef GL_SAMPLER_2D_RECT_SHADOW
		swigIntConstant( GL_SAMPLER_2D_RECT_SHADOW, "GL_SAMPLER_2D_RECT_SHADOW" );
	#endif
	#ifdef GL_SAMPLER_BUFFER
		swigIntConstant( GL_SAMPLER_BUFFER, "GL_SAMPLER_BUFFER" );
	#endif
	#ifdef GL_INT_SAMPLER_2D_RECT
		swigIntConstant( GL_INT_SAMPLER_2D_RECT, "GL_INT_SAMPLER_2D_RECT" );
	#endif
	#ifdef GL_INT_SAMPLER_BUFFER
		swigIntConstant( GL_INT_SAMPLER_BUFFER, "GL_INT_SAMPLER_BUFFER" );
	#endif
	#ifdef GL_UNSIGNED_INT_SAMPLER_2D_RECT
		swigIntConstant( GL_UNSIGNED_INT_SAMPLER_2D_RECT, "GL_UNSIGNED_INT_SAMPLER_2D_RECT" );
	#endif
	#ifdef GL_UNSIGNED_INT_SAMPLER_BUFFER
		swigIntConstant( GL_UNSIGNED_INT_SAMPLER_BUFFER, "GL_UNSIGNED_INT_SAMPLER_BUFFER" );
	#endif
	#ifdef GL_TEXTURE_BUFFER
		swigIntConstant( GL_TEXTURE_BUFFER, "GL_TEXTURE_BUFFER" );
	#endif
	#ifdef GL_MAX_TEXTURE_BUFFER_SIZE
		swigIntConstant( GL_MAX_TEXTURE_BUFFER_SIZE, "GL_MAX_TEXTURE_BUFFER_SIZE" );
	#endif
	#ifdef GL_TEXTURE_BINDING_BUFFER
		swigIntConstant( GL_TEXTURE_BINDING_BUFFER, "GL_TEXTURE_BINDING_BUFFER" );
	#endif
	#ifdef GL_TEXTURE_BUFFER_DATA_STORE_BINDING
		swigIntConstant( GL_TEXTURE_BUFFER_DATA_STORE_BINDING, "GL_TEXTURE_BUFFER_DATA_STORE_BINDING" );
	#endif
	#ifdef GL_TEXTURE_RECTANGLE
		swigIntConstant( GL_TEXTURE_RECTANGLE, "GL_TEXTURE_RECTANGLE" );
	#endif
	#ifdef GL_TEXTURE_BINDING_RECTANGLE
		swigIntConstant( GL_TEXTURE_BINDING_RECTANGLE, "GL_TEXTURE_BINDING_RECTANGLE" );
	#endif
	#ifdef GL_PROXY_TEXTURE_RECTANGLE
		swigIntConstant( GL_PROXY_TEXTURE_RECTANGLE, "GL_PROXY_TEXTURE_RECTANGLE" );
	#endif
	#ifdef GL_MAX_RECTANGLE_TEXTURE_SIZE
		swigIntConstant( GL_MAX_RECTANGLE_TEXTURE_SIZE, "GL_MAX_RECTANGLE_TEXTURE_SIZE" );
	#endif
	#ifdef GL_R8_SNORM
		swigIntConstant( GL_R8_SNORM, "GL_R8_SNORM" );
	#endif
	#ifdef GL_RG8_SNORM
		swigIntConstant( GL_RG8_SNORM, "GL_RG8_SNORM" );
	#endif
	#ifdef GL_RGB8_SNORM
		swigIntConstant( GL_RGB8_SNORM, "GL_RGB8_SNORM" );
	#endif
	#ifdef GL_RGBA8_SNORM
		swigIntConstant( GL_RGBA8_SNORM, "GL_RGBA8_SNORM" );
	#endif
	#ifdef GL_R16_SNORM
		swigIntConstant( GL_R16_SNORM, "GL_R16_SNORM" );
	#endif
	#ifdef GL_RG16_SNORM
		swigIntConstant( GL_RG16_SNORM, "GL_RG16_SNORM" );
	#endif
	#ifdef GL_RGB16_SNORM
		swigIntConstant( GL_RGB16_SNORM, "GL_RGB16_SNORM" );
	#endif
	#ifdef GL_RGBA16_SNORM
		swigIntConstant( GL_RGBA16_SNORM, "GL_RGBA16_SNORM" );
	#endif
	#ifdef GL_SIGNED_NORMALIZED
		swigIntConstant( GL_SIGNED_NORMALIZED, "GL_SIGNED_NORMALIZED" );
	#endif
	#ifdef GL_PRIMITIVE_RESTART
		swigIntConstant( GL_PRIMITIVE_RESTART, "GL_PRIMITIVE_RESTART" );
	#endif
	#ifdef GL_PRIMITIVE_RESTART_INDEX
		swigIntConstant( GL_PRIMITIVE_RESTART_INDEX, "GL_PRIMITIVE_RESTART_INDEX" );
	#endif
	#ifdef GL_COPY_READ_BUFFER
		swigIntConstant( GL_COPY_READ_BUFFER, "GL_COPY_READ_BUFFER" );
	#endif
	#ifdef GL_COPY_WRITE_BUFFER
		swigIntConstant( GL_COPY_WRITE_BUFFER, "GL_COPY_WRITE_BUFFER" );
	#endif
	#ifdef GL_UNIFORM_BUFFER
		swigIntConstant( GL_UNIFORM_BUFFER, "GL_UNIFORM_BUFFER" );
	#endif
	#ifdef GL_UNIFORM_BUFFER_BINDING
		swigIntConstant( GL_UNIFORM_BUFFER_BINDING, "GL_UNIFORM_BUFFER_BINDING" );
	#endif
	#ifdef GL_UNIFORM_BUFFER_START
		swigIntConstant( GL_UNIFORM_BUFFER_START, "GL_UNIFORM_BUFFER_START" );
	#endif
	#ifdef GL_UNIFORM_BUFFER_SIZE
		swigIntConstant( GL_UNIFORM_BUFFER_SIZE, "GL_UNIFORM_BUFFER_SIZE" );
	#endif
	#ifdef GL_MAX_VERTEX_UNIFORM_BLOCKS
		swigIntConstant( GL_MAX_VERTEX_UNIFORM_BLOCKS, "GL_MAX_VERTEX_UNIFORM_BLOCKS" );
	#endif
	#ifdef GL_MAX_GEOMETRY_UNIFORM_BLOCKS
		swigIntConstant( GL_MAX_GEOMETRY_UNIFORM_BLOCKS, "GL_MAX_GEOMETRY_UNIFORM_BLOCKS" );
	#endif
	#ifdef GL_MAX_FRAGMENT_UNIFORM_BLOCKS
		swigIntConstant( GL_MAX_FRAGMENT_UNIFORM_BLOCKS, "GL_MAX_FRAGMENT_UNIFORM_BLOCKS" );
	#endif
	#ifdef GL_MAX_COMBINED_UNIFORM_BLOCKS
		swigIntConstant( GL_MAX_COMBINED_UNIFORM_BLOCKS, "GL_MAX_COMBINED_UNIFORM_BLOCKS" );
	#endif
	#ifdef GL_MAX_UNIFORM_BUFFER_BINDINGS
		swigIntConstant( GL_MAX_UNIFORM_BUFFER_BINDINGS, "GL_MAX_UNIFORM_BUFFER_BINDINGS" );
	#endif
	#ifdef GL_MAX_UNIFORM_BLOCK_SIZE
		swigIntConstant( GL_MAX_UNIFORM_BLOCK_SIZE, "GL_MAX_UNIFORM_BLOCK_SIZE" );
	#endif
	#ifdef GL_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS
		swigIntConstant( GL_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS, "GL_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS" );
	#endif
	#ifdef GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS
		swigIntConstant( GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS, "GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS" );
	#endif
	#ifdef GL_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS
		swigIntConstant( GL_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS, "GL_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS" );
	#endif
	#ifdef GL_UNIFORM_BUFFER_OFFSET_ALIGNMENT
		swigIntConstant( GL_UNIFORM_BUFFER_OFFSET_ALIGNMENT, "GL_UNIFORM_BUFFER_OFFSET_ALIGNMENT" );
	#endif
	#ifdef GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH
		swigIntConstant( GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH, "GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH" );
	#endif
	#ifdef GL_ACTIVE_UNIFORM_BLOCKS
		swigIntConstant( GL_ACTIVE_UNIFORM_BLOCKS, "GL_ACTIVE_UNIFORM_BLOCKS" );
	#endif
	#ifdef GL_UNIFORM_TYPE
		swigIntConstant( GL_UNIFORM_TYPE, "GL_UNIFORM_TYPE" );
	#endif
	#ifdef GL_UNIFORM_SIZE
		swigIntConstant( GL_UNIFORM_SIZE, "GL_UNIFORM_SIZE" );
	#endif
	#ifdef GL_UNIFORM_NAME_LENGTH
		swigIntConstant( GL_UNIFORM_NAME_LENGTH, "GL_UNIFORM_NAME_LENGTH" );
	#endif
	#ifdef GL_UNIFORM_BLOCK_INDEX
		swigIntConstant( GL_UNIFORM_BLOCK_INDEX, "GL_UNIFORM_BLOCK_INDEX" );
	#endif
	#ifdef GL_UNIFORM_OFFSET
		swigIntConstant( GL_UNIFORM_OFFSET, "GL_UNIFORM_OFFSET" );
	#endif
	#ifdef GL_UNIFORM_ARRAY_STRIDE
		swigIntConstant( GL_UNIFORM_ARRAY_STRIDE, "GL_UNIFORM_ARRAY_STRIDE" );
	#endif
	#ifdef GL_UNIFORM_MATRIX_STRIDE
		swigIntConstant( GL_UNIFORM_MATRIX_STRIDE, "GL_UNIFORM_MATRIX_STRIDE" );
	#endif
	#ifdef GL_UNIFORM_IS_ROW_MAJOR
		swigIntConstant( GL_UNIFORM_IS_ROW_MAJOR, "GL_UNIFORM_IS_ROW_MAJOR" );
	#endif
	#ifdef GL_UNIFORM_BLOCK_BINDING
		swigIntConstant( GL_UNIFORM_BLOCK_BINDING, "GL_UNIFORM_BLOCK_BINDING" );
	#endif
	#ifdef GL_UNIFORM_BLOCK_DATA_SIZE
		swigIntConstant( GL_UNIFORM_BLOCK_DATA_SIZE, "GL_UNIFORM_BLOCK_DATA_SIZE" );
	#endif
	#ifdef GL_UNIFORM_BLOCK_NAME_LENGTH
		swigIntConstant( GL_UNIFORM_BLOCK_NAME_LENGTH, "GL_UNIFORM_BLOCK_NAME_LENGTH" );
	#endif
	#ifdef GL_UNIFORM_BLOCK_ACTIVE_UNIFORMS
		swigIntConstant( GL_UNIFORM_BLOCK_ACTIVE_UNIFORMS, "GL_UNIFORM_BLOCK_ACTIVE_UNIFORMS" );
	#endif
	#ifdef GL_UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES
		swigIntConstant( GL_UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES, "GL_UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES" );
	#endif
	#ifdef GL_UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER
		swigIntConstant( GL_UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER, "GL_UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER" );
	#endif
	#ifdef GL_UNIFORM_BLOCK_REFERENCED_BY_GEOMETRY_SHADER
		swigIntConstant( GL_UNIFORM_BLOCK_REFERENCED_BY_GEOMETRY_SHADER, "GL_UNIFORM_BLOCK_REFERENCED_BY_GEOMETRY_SHADER" );
	#endif
	#ifdef GL_UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER
		swigIntConstant( GL_UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER, "GL_UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER" );
	#endif
	#ifdef GL_INVALID_INDEX
		swigUnsignedIntConstant( GL_INVALID_INDEX, "GL_INVALID_INDEX" );
	#endif
	#ifdef GL_VERSION_3_2
		swigIntConstant( GL_VERSION_3_2, "GL_VERSION_3_2" );
	#endif
	#ifdef GL_CONTEXT_CORE_PROFILE_BIT
		swigIntConstant( GL_CONTEXT_CORE_PROFILE_BIT, "GL_CONTEXT_CORE_PROFILE_BIT" );
	#endif
	#ifdef GL_CONTEXT_COMPATIBILITY_PROFILE_BIT
		swigIntConstant( GL_CONTEXT_COMPATIBILITY_PROFILE_BIT, "GL_CONTEXT_COMPATIBILITY_PROFILE_BIT" );
	#endif
	#ifdef GL_LINES_ADJACENCY
		swigIntConstant( GL_LINES_ADJACENCY, "GL_LINES_ADJACENCY" );
	#endif
	#ifdef GL_LINE_STRIP_ADJACENCY
		swigIntConstant( GL_LINE_STRIP_ADJACENCY, "GL_LINE_STRIP_ADJACENCY" );
	#endif
	#ifdef GL_TRIANGLES_ADJACENCY
		swigIntConstant( GL_TRIANGLES_ADJACENCY, "GL_TRIANGLES_ADJACENCY" );
	#endif
	#ifdef GL_TRIANGLE_STRIP_ADJACENCY
		swigIntConstant( GL_TRIANGLE_STRIP_ADJACENCY, "GL_TRIANGLE_STRIP_ADJACENCY" );
	#endif
	#ifdef GL_PROGRAM_POINT_SIZE
		swigIntConstant( GL_PROGRAM_POINT_SIZE, "GL_PROGRAM_POINT_SIZE" );
	#endif
	#ifdef GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS
		swigIntConstant( GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS, "GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS" );
	#endif
	#ifdef GL_FRAMEBUFFER_ATTACHMENT_LAYERED
		swigIntConstant( GL_FRAMEBUFFER_ATTACHMENT_LAYERED, "GL_FRAMEBUFFER_ATTACHMENT_LAYERED" );
	#endif
	#ifdef GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS
		swigIntConstant( GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS, "GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS" );
	#endif
	#ifdef GL_GEOMETRY_SHADER
		swigIntConstant( GL_GEOMETRY_SHADER, "GL_GEOMETRY_SHADER" );
	#endif
	#ifdef GL_GEOMETRY_VERTICES_OUT
		swigIntConstant( GL_GEOMETRY_VERTICES_OUT, "GL_GEOMETRY_VERTICES_OUT" );
	#endif
	#ifdef GL_GEOMETRY_INPUT_TYPE
		swigIntConstant( GL_GEOMETRY_INPUT_TYPE, "GL_GEOMETRY_INPUT_TYPE" );
	#endif
	#ifdef GL_GEOMETRY_OUTPUT_TYPE
		swigIntConstant( GL_GEOMETRY_OUTPUT_TYPE, "GL_GEOMETRY_OUTPUT_TYPE" );
	#endif
	#ifdef GL_MAX_GEOMETRY_UNIFORM_COMPONENTS
		swigIntConstant( GL_MAX_GEOMETRY_UNIFORM_COMPONENTS, "GL_MAX_GEOMETRY_UNIFORM_COMPONENTS" );
	#endif
	#ifdef GL_MAX_GEOMETRY_OUTPUT_VERTICES
		swigIntConstant( GL_MAX_GEOMETRY_OUTPUT_VERTICES, "GL_MAX_GEOMETRY_OUTPUT_VERTICES" );
	#endif
	#ifdef GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS
		swigIntConstant( GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS, "GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS" );
	#endif
	#ifdef GL_MAX_VERTEX_OUTPUT_COMPONENTS
		swigIntConstant( GL_MAX_VERTEX_OUTPUT_COMPONENTS, "GL_MAX_VERTEX_OUTPUT_COMPONENTS" );
	#endif
	#ifdef GL_MAX_GEOMETRY_INPUT_COMPONENTS
		swigIntConstant( GL_MAX_GEOMETRY_INPUT_COMPONENTS, "GL_MAX_GEOMETRY_INPUT_COMPONENTS" );
	#endif
	#ifdef GL_MAX_GEOMETRY_OUTPUT_COMPONENTS
		swigIntConstant( GL_MAX_GEOMETRY_OUTPUT_COMPONENTS, "GL_MAX_GEOMETRY_OUTPUT_COMPONENTS" );
	#endif
	#ifdef GL_MAX_FRAGMENT_INPUT_COMPONENTS
		swigIntConstant( GL_MAX_FRAGMENT_INPUT_COMPONENTS, "GL_MAX_FRAGMENT_INPUT_COMPONENTS" );
	#endif
	#ifdef GL_CONTEXT_PROFILE_MASK
		swigIntConstant( GL_CONTEXT_PROFILE_MASK, "GL_CONTEXT_PROFILE_MASK" );
	#endif
	#ifdef GL_DEPTH_CLAMP
		swigIntConstant( GL_DEPTH_CLAMP, "GL_DEPTH_CLAMP" );
	#endif
	#ifdef GL_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION
		swigIntConstant( GL_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION, "GL_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION" );
	#endif
	#ifdef GL_FIRST_VERTEX_CONVENTION
		swigIntConstant( GL_FIRST_VERTEX_CONVENTION, "GL_FIRST_VERTEX_CONVENTION" );
	#endif
	#ifdef GL_LAST_VERTEX_CONVENTION
		swigIntConstant( GL_LAST_VERTEX_CONVENTION, "GL_LAST_VERTEX_CONVENTION" );
	#endif
	#ifdef GL_PROVOKING_VERTEX
		swigIntConstant( GL_PROVOKING_VERTEX, "GL_PROVOKING_VERTEX" );
	#endif
	#ifdef GL_TEXTURE_CUBE_MAP_SEAMLESS
		swigIntConstant( GL_TEXTURE_CUBE_MAP_SEAMLESS, "GL_TEXTURE_CUBE_MAP_SEAMLESS" );
	#endif
	#ifdef GL_MAX_SERVER_WAIT_TIMEOUT
		swigIntConstant( GL_MAX_SERVER_WAIT_TIMEOUT, "GL_MAX_SERVER_WAIT_TIMEOUT" );
	#endif
	#ifdef GL_OBJECT_TYPE
		swigIntConstant( GL_OBJECT_TYPE, "GL_OBJECT_TYPE" );
	#endif
	#ifdef GL_SYNC_CONDITION
		swigIntConstant( GL_SYNC_CONDITION, "GL_SYNC_CONDITION" );
	#endif
	#ifdef GL_SYNC_STATUS
		swigIntConstant( GL_SYNC_STATUS, "GL_SYNC_STATUS" );
	#endif
	#ifdef GL_SYNC_FLAGS
		swigIntConstant( GL_SYNC_FLAGS, "GL_SYNC_FLAGS" );
	#endif
	#ifdef GL_SYNC_FENCE
		swigIntConstant( GL_SYNC_FENCE, "GL_SYNC_FENCE" );
	#endif
	#ifdef GL_SYNC_GPU_COMMANDS_COMPLETE
		swigIntConstant( GL_SYNC_GPU_COMMANDS_COMPLETE, "GL_SYNC_GPU_COMMANDS_COMPLETE" );
	#endif
	#ifdef GL_UNSIGNALED
		swigIntConstant( GL_UNSIGNALED, "GL_UNSIGNALED" );
	#endif
	#ifdef GL_SIGNALED
		swigIntConstant( GL_SIGNALED, "GL_SIGNALED" );
	#endif
	#ifdef GL_ALREADY_SIGNALED
		swigIntConstant( GL_ALREADY_SIGNALED, "GL_ALREADY_SIGNALED" );
	#endif
	#ifdef GL_TIMEOUT_EXPIRED
		swigIntConstant( GL_TIMEOUT_EXPIRED, "GL_TIMEOUT_EXPIRED" );
	#endif
	#ifdef GL_CONDITION_SATISFIED
		swigIntConstant( GL_CONDITION_SATISFIED, "GL_CONDITION_SATISFIED" );
	#endif
	#ifdef GL_WAIT_FAILED
		swigIntConstant( GL_WAIT_FAILED, "GL_WAIT_FAILED" );
	#endif
	#ifdef GL_SYNC_FLUSH_COMMANDS_BIT
		swigIntConstant( GL_SYNC_FLUSH_COMMANDS_BIT, "GL_SYNC_FLUSH_COMMANDS_BIT" );
	#endif
	#ifdef GL_SAMPLE_POSITION
		swigIntConstant( GL_SAMPLE_POSITION, "GL_SAMPLE_POSITION" );
	#endif
	#ifdef GL_SAMPLE_MASK
		swigIntConstant( GL_SAMPLE_MASK, "GL_SAMPLE_MASK" );
	#endif
	#ifdef GL_SAMPLE_MASK_VALUE
		swigIntConstant( GL_SAMPLE_MASK_VALUE, "GL_SAMPLE_MASK_VALUE" );
	#endif
	#ifdef GL_MAX_SAMPLE_MASK_WORDS
		swigIntConstant( GL_MAX_SAMPLE_MASK_WORDS, "GL_MAX_SAMPLE_MASK_WORDS" );
	#endif
	#ifdef GL_TEXTURE_2D_MULTISAMPLE
		swigIntConstant( GL_TEXTURE_2D_MULTISAMPLE, "GL_TEXTURE_2D_MULTISAMPLE" );
	#endif
	#ifdef GL_PROXY_TEXTURE_2D_MULTISAMPLE
		swigIntConstant( GL_PROXY_TEXTURE_2D_MULTISAMPLE, "GL_PROXY_TEXTURE_2D_MULTISAMPLE" );
	#endif
	#ifdef GL_TEXTURE_2D_MULTISAMPLE_ARRAY
		swigIntConstant( GL_TEXTURE_2D_MULTISAMPLE_ARRAY, "GL_TEXTURE_2D_MULTISAMPLE_ARRAY" );
	#endif
	#ifdef GL_PROXY_TEXTURE_2D_MULTISAMPLE_ARRAY
		swigIntConstant( GL_PROXY_TEXTURE_2D_MULTISAMPLE_ARRAY, "GL_PROXY_TEXTURE_2D_MULTISAMPLE_ARRAY" );
	#endif
	#ifdef GL_TEXTURE_BINDING_2D_MULTISAMPLE
		swigIntConstant( GL_TEXTURE_BINDING_2D_MULTISAMPLE, "GL_TEXTURE_BINDING_2D_MULTISAMPLE" );
	#endif
	#ifdef GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY
		swigIntConstant( GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY, "GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY" );
	#endif
	#ifdef GL_TEXTURE_SAMPLES
		swigIntConstant( GL_TEXTURE_SAMPLES, "GL_TEXTURE_SAMPLES" );
	#endif
	#ifdef GL_TEXTURE_FIXED_SAMPLE_LOCATIONS
		swigIntConstant( GL_TEXTURE_FIXED_SAMPLE_LOCATIONS, "GL_TEXTURE_FIXED_SAMPLE_LOCATIONS" );
	#endif
	#ifdef GL_SAMPLER_2D_MULTISAMPLE
		swigIntConstant( GL_SAMPLER_2D_MULTISAMPLE, "GL_SAMPLER_2D_MULTISAMPLE" );
	#endif
	#ifdef GL_INT_SAMPLER_2D_MULTISAMPLE
		swigIntConstant( GL_INT_SAMPLER_2D_MULTISAMPLE, "GL_INT_SAMPLER_2D_MULTISAMPLE" );
	#endif
	#ifdef GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE
		swigIntConstant( GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE, "GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE" );
	#endif
	#ifdef GL_SAMPLER_2D_MULTISAMPLE_ARRAY
		swigIntConstant( GL_SAMPLER_2D_MULTISAMPLE_ARRAY, "GL_SAMPLER_2D_MULTISAMPLE_ARRAY" );
	#endif
	#ifdef GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY
		swigIntConstant( GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY, "GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY" );
	#endif
	#ifdef GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY
		swigIntConstant( GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY, "GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY" );
	#endif
	#ifdef GL_MAX_COLOR_TEXTURE_SAMPLES
		swigIntConstant( GL_MAX_COLOR_TEXTURE_SAMPLES, "GL_MAX_COLOR_TEXTURE_SAMPLES" );
	#endif
	#ifdef GL_MAX_DEPTH_TEXTURE_SAMPLES
		swigIntConstant( GL_MAX_DEPTH_TEXTURE_SAMPLES, "GL_MAX_DEPTH_TEXTURE_SAMPLES" );
	#endif
	#ifdef GL_MAX_INTEGER_SAMPLES
		swigIntConstant( GL_MAX_INTEGER_SAMPLES, "GL_MAX_INTEGER_SAMPLES" );
	#endif
	#ifdef GL_VERSION_3_3
		swigIntConstant( GL_VERSION_3_3, "GL_VERSION_3_3" );
	#endif
	#ifdef GL_VERTEX_ATTRIB_ARRAY_DIVISOR
		swigIntConstant( GL_VERTEX_ATTRIB_ARRAY_DIVISOR, "GL_VERTEX_ATTRIB_ARRAY_DIVISOR" );
	#endif
	#ifdef GL_SRC1_COLOR
		swigIntConstant( GL_SRC1_COLOR, "GL_SRC1_COLOR" );
	#endif
	#ifdef GL_ONE_MINUS_SRC1_COLOR
		swigIntConstant( GL_ONE_MINUS_SRC1_COLOR, "GL_ONE_MINUS_SRC1_COLOR" );
	#endif
	#ifdef GL_ONE_MINUS_SRC1_ALPHA
		swigIntConstant( GL_ONE_MINUS_SRC1_ALPHA, "GL_ONE_MINUS_SRC1_ALPHA" );
	#endif
	#ifdef GL_MAX_DUAL_SOURCE_DRAW_BUFFERS
		swigIntConstant( GL_MAX_DUAL_SOURCE_DRAW_BUFFERS, "GL_MAX_DUAL_SOURCE_DRAW_BUFFERS" );
	#endif
	#ifdef GL_ANY_SAMPLES_PASSED
		swigIntConstant( GL_ANY_SAMPLES_PASSED, "GL_ANY_SAMPLES_PASSED" );
	#endif
	#ifdef GL_SAMPLER_BINDING
		swigIntConstant( GL_SAMPLER_BINDING, "GL_SAMPLER_BINDING" );
	#endif
	#ifdef GL_RGB10_A2UI
		swigIntConstant( GL_RGB10_A2UI, "GL_RGB10_A2UI" );
	#endif
	#ifdef GL_TEXTURE_SWIZZLE_R
		swigIntConstant( GL_TEXTURE_SWIZZLE_R, "GL_TEXTURE_SWIZZLE_R" );
	#endif
	#ifdef GL_TEXTURE_SWIZZLE_G
		swigIntConstant( GL_TEXTURE_SWIZZLE_G, "GL_TEXTURE_SWIZZLE_G" );
	#endif
	#ifdef GL_TEXTURE_SWIZZLE_B
		swigIntConstant( GL_TEXTURE_SWIZZLE_B, "GL_TEXTURE_SWIZZLE_B" );
	#endif
	#ifdef GL_TEXTURE_SWIZZLE_A
		swigIntConstant( GL_TEXTURE_SWIZZLE_A, "GL_TEXTURE_SWIZZLE_A" );
	#endif
	#ifdef GL_TEXTURE_SWIZZLE_RGBA
		swigIntConstant( GL_TEXTURE_SWIZZLE_RGBA, "GL_TEXTURE_SWIZZLE_RGBA" );
	#endif
	#ifdef GL_TIME_ELAPSED
		swigIntConstant( GL_TIME_ELAPSED, "GL_TIME_ELAPSED" );
	#endif
	#ifdef GL_TIMESTAMP
		swigIntConstant( GL_TIMESTAMP, "GL_TIMESTAMP" );
	#endif
	#ifdef GL_INT_2_10_10_10_REV
		swigIntConstant( GL_INT_2_10_10_10_REV, "GL_INT_2_10_10_10_REV" );
	#endif
	#ifdef GL_VERSION_4_0
		swigIntConstant( GL_VERSION_4_0, "GL_VERSION_4_0" );
	#endif
	#ifdef GL_SAMPLE_SHADING
		swigIntConstant( GL_SAMPLE_SHADING, "GL_SAMPLE_SHADING" );
	#endif
	#ifdef GL_MIN_SAMPLE_SHADING_VALUE
		swigIntConstant( GL_MIN_SAMPLE_SHADING_VALUE, "GL_MIN_SAMPLE_SHADING_VALUE" );
	#endif
	#ifdef GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET
		swigIntConstant( GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET, "GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET" );
	#endif
	#ifdef GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET
		swigIntConstant( GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET, "GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET" );
	#endif
	#ifdef GL_TEXTURE_CUBE_MAP_ARRAY
		swigIntConstant( GL_TEXTURE_CUBE_MAP_ARRAY, "GL_TEXTURE_CUBE_MAP_ARRAY" );
	#endif
	#ifdef GL_TEXTURE_BINDING_CUBE_MAP_ARRAY
		swigIntConstant( GL_TEXTURE_BINDING_CUBE_MAP_ARRAY, "GL_TEXTURE_BINDING_CUBE_MAP_ARRAY" );
	#endif
	#ifdef GL_PROXY_TEXTURE_CUBE_MAP_ARRAY
		swigIntConstant( GL_PROXY_TEXTURE_CUBE_MAP_ARRAY, "GL_PROXY_TEXTURE_CUBE_MAP_ARRAY" );
	#endif
	#ifdef GL_SAMPLER_CUBE_MAP_ARRAY
		swigIntConstant( GL_SAMPLER_CUBE_MAP_ARRAY, "GL_SAMPLER_CUBE_MAP_ARRAY" );
	#endif
	#ifdef GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW
		swigIntConstant( GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW, "GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW" );
	#endif
	#ifdef GL_INT_SAMPLER_CUBE_MAP_ARRAY
		swigIntConstant( GL_INT_SAMPLER_CUBE_MAP_ARRAY, "GL_INT_SAMPLER_CUBE_MAP_ARRAY" );
	#endif
	#ifdef GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY
		swigIntConstant( GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY, "GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY" );
	#endif
	#ifdef GL_DRAW_INDIRECT_BUFFER
		swigIntConstant( GL_DRAW_INDIRECT_BUFFER, "GL_DRAW_INDIRECT_BUFFER" );
	#endif
	#ifdef GL_DRAW_INDIRECT_BUFFER_BINDING
		swigIntConstant( GL_DRAW_INDIRECT_BUFFER_BINDING, "GL_DRAW_INDIRECT_BUFFER_BINDING" );
	#endif
	#ifdef GL_GEOMETRY_SHADER_INVOCATIONS
		swigIntConstant( GL_GEOMETRY_SHADER_INVOCATIONS, "GL_GEOMETRY_SHADER_INVOCATIONS" );
	#endif
	#ifdef GL_MAX_GEOMETRY_SHADER_INVOCATIONS
		swigIntConstant( GL_MAX_GEOMETRY_SHADER_INVOCATIONS, "GL_MAX_GEOMETRY_SHADER_INVOCATIONS" );
	#endif
	#ifdef GL_MIN_FRAGMENT_INTERPOLATION_OFFSET
		swigIntConstant( GL_MIN_FRAGMENT_INTERPOLATION_OFFSET, "GL_MIN_FRAGMENT_INTERPOLATION_OFFSET" );
	#endif
	#ifdef GL_MAX_FRAGMENT_INTERPOLATION_OFFSET
		swigIntConstant( GL_MAX_FRAGMENT_INTERPOLATION_OFFSET, "GL_MAX_FRAGMENT_INTERPOLATION_OFFSET" );
	#endif
	#ifdef GL_FRAGMENT_INTERPOLATION_OFFSET_BITS
		swigIntConstant( GL_FRAGMENT_INTERPOLATION_OFFSET_BITS, "GL_FRAGMENT_INTERPOLATION_OFFSET_BITS" );
	#endif
	#ifdef GL_MAX_VERTEX_STREAMS
		swigIntConstant( GL_MAX_VERTEX_STREAMS, "GL_MAX_VERTEX_STREAMS" );
	#endif
	#ifdef GL_DOUBLE_VEC2
		swigIntConstant( GL_DOUBLE_VEC2, "GL_DOUBLE_VEC2" );
	#endif
	#ifdef GL_DOUBLE_VEC3
		swigIntConstant( GL_DOUBLE_VEC3, "GL_DOUBLE_VEC3" );
	#endif
	#ifdef GL_DOUBLE_VEC4
		swigIntConstant( GL_DOUBLE_VEC4, "GL_DOUBLE_VEC4" );
	#endif
	#ifdef GL_DOUBLE_MAT2
		swigIntConstant( GL_DOUBLE_MAT2, "GL_DOUBLE_MAT2" );
	#endif
	#ifdef GL_DOUBLE_MAT3
		swigIntConstant( GL_DOUBLE_MAT3, "GL_DOUBLE_MAT3" );
	#endif
	#ifdef GL_DOUBLE_MAT4
		swigIntConstant( GL_DOUBLE_MAT4, "GL_DOUBLE_MAT4" );
	#endif
	#ifdef GL_DOUBLE_MAT2x3
		swigIntConstant( GL_DOUBLE_MAT2x3, "GL_DOUBLE_MAT2x3" );
	#endif
	#ifdef GL_DOUBLE_MAT2x4
		swigIntConstant( GL_DOUBLE_MAT2x4, "GL_DOUBLE_MAT2x4" );
	#endif
	#ifdef GL_DOUBLE_MAT3x2
		swigIntConstant( GL_DOUBLE_MAT3x2, "GL_DOUBLE_MAT3x2" );
	#endif
	#ifdef GL_DOUBLE_MAT3x4
		swigIntConstant( GL_DOUBLE_MAT3x4, "GL_DOUBLE_MAT3x4" );
	#endif
	#ifdef GL_DOUBLE_MAT4x2
		swigIntConstant( GL_DOUBLE_MAT4x2, "GL_DOUBLE_MAT4x2" );
	#endif
	#ifdef GL_DOUBLE_MAT4x3
		swigIntConstant( GL_DOUBLE_MAT4x3, "GL_DOUBLE_MAT4x3" );
	#endif
	#ifdef GL_ACTIVE_SUBROUTINES
		swigIntConstant( GL_ACTIVE_SUBROUTINES, "GL_ACTIVE_SUBROUTINES" );
	#endif
	#ifdef GL_ACTIVE_SUBROUTINE_UNIFORMS
		swigIntConstant( GL_ACTIVE_SUBROUTINE_UNIFORMS, "GL_ACTIVE_SUBROUTINE_UNIFORMS" );
	#endif
	#ifdef GL_ACTIVE_SUBROUTINE_UNIFORM_LOCATIONS
		swigIntConstant( GL_ACTIVE_SUBROUTINE_UNIFORM_LOCATIONS, "GL_ACTIVE_SUBROUTINE_UNIFORM_LOCATIONS" );
	#endif
	#ifdef GL_ACTIVE_SUBROUTINE_MAX_LENGTH
		swigIntConstant( GL_ACTIVE_SUBROUTINE_MAX_LENGTH, "GL_ACTIVE_SUBROUTINE_MAX_LENGTH" );
	#endif
	#ifdef GL_ACTIVE_SUBROUTINE_UNIFORM_MAX_LENGTH
		swigIntConstant( GL_ACTIVE_SUBROUTINE_UNIFORM_MAX_LENGTH, "GL_ACTIVE_SUBROUTINE_UNIFORM_MAX_LENGTH" );
	#endif
	#ifdef GL_MAX_SUBROUTINES
		swigIntConstant( GL_MAX_SUBROUTINES, "GL_MAX_SUBROUTINES" );
	#endif
	#ifdef GL_MAX_SUBROUTINE_UNIFORM_LOCATIONS
		swigIntConstant( GL_MAX_SUBROUTINE_UNIFORM_LOCATIONS, "GL_MAX_SUBROUTINE_UNIFORM_LOCATIONS" );
	#endif
	#ifdef GL_NUM_COMPATIBLE_SUBROUTINES
		swigIntConstant( GL_NUM_COMPATIBLE_SUBROUTINES, "GL_NUM_COMPATIBLE_SUBROUTINES" );
	#endif
	#ifdef GL_COMPATIBLE_SUBROUTINES
		swigIntConstant( GL_COMPATIBLE_SUBROUTINES, "GL_COMPATIBLE_SUBROUTINES" );
	#endif
	#ifdef GL_PATCHES
		swigIntConstant( GL_PATCHES, "GL_PATCHES" );
	#endif
	#ifdef GL_PATCH_VERTICES
		swigIntConstant( GL_PATCH_VERTICES, "GL_PATCH_VERTICES" );
	#endif
	#ifdef GL_PATCH_DEFAULT_INNER_LEVEL
		swigIntConstant( GL_PATCH_DEFAULT_INNER_LEVEL, "GL_PATCH_DEFAULT_INNER_LEVEL" );
	#endif
	#ifdef GL_PATCH_DEFAULT_OUTER_LEVEL
		swigIntConstant( GL_PATCH_DEFAULT_OUTER_LEVEL, "GL_PATCH_DEFAULT_OUTER_LEVEL" );
	#endif
	#ifdef GL_TESS_CONTROL_OUTPUT_VERTICES
		swigIntConstant( GL_TESS_CONTROL_OUTPUT_VERTICES, "GL_TESS_CONTROL_OUTPUT_VERTICES" );
	#endif
	#ifdef GL_TESS_GEN_MODE
		swigIntConstant( GL_TESS_GEN_MODE, "GL_TESS_GEN_MODE" );
	#endif
	#ifdef GL_TESS_GEN_SPACING
		swigIntConstant( GL_TESS_GEN_SPACING, "GL_TESS_GEN_SPACING" );
	#endif
	#ifdef GL_TESS_GEN_VERTEX_ORDER
		swigIntConstant( GL_TESS_GEN_VERTEX_ORDER, "GL_TESS_GEN_VERTEX_ORDER" );
	#endif
	#ifdef GL_TESS_GEN_POINT_MODE
		swigIntConstant( GL_TESS_GEN_POINT_MODE, "GL_TESS_GEN_POINT_MODE" );
	#endif
	#ifdef GL_ISOLINES
		swigIntConstant( GL_ISOLINES, "GL_ISOLINES" );
	#endif
	#ifdef GL_FRACTIONAL_ODD
		swigIntConstant( GL_FRACTIONAL_ODD, "GL_FRACTIONAL_ODD" );
	#endif
	#ifdef GL_FRACTIONAL_EVEN
		swigIntConstant( GL_FRACTIONAL_EVEN, "GL_FRACTIONAL_EVEN" );
	#endif
	#ifdef GL_MAX_PATCH_VERTICES
		swigIntConstant( GL_MAX_PATCH_VERTICES, "GL_MAX_PATCH_VERTICES" );
	#endif
	#ifdef GL_MAX_TESS_GEN_LEVEL
		swigIntConstant( GL_MAX_TESS_GEN_LEVEL, "GL_MAX_TESS_GEN_LEVEL" );
	#endif
	#ifdef GL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS
		swigIntConstant( GL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS, "GL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS" );
	#endif
	#ifdef GL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS
		swigIntConstant( GL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS, "GL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS" );
	#endif
	#ifdef GL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS
		swigIntConstant( GL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS, "GL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS" );
	#endif
	#ifdef GL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS
		swigIntConstant( GL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS, "GL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS" );
	#endif
	#ifdef GL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS
		swigIntConstant( GL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS, "GL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS" );
	#endif
	#ifdef GL_MAX_TESS_PATCH_COMPONENTS
		swigIntConstant( GL_MAX_TESS_PATCH_COMPONENTS, "GL_MAX_TESS_PATCH_COMPONENTS" );
	#endif
	#ifdef GL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS
		swigIntConstant( GL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS, "GL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS" );
	#endif
	#ifdef GL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS
		swigIntConstant( GL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS, "GL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS" );
	#endif
	#ifdef GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS
		swigIntConstant( GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS, "GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS" );
	#endif
	#ifdef GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS
		swigIntConstant( GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS, "GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS" );
	#endif
	#ifdef GL_MAX_TESS_CONTROL_INPUT_COMPONENTS
		swigIntConstant( GL_MAX_TESS_CONTROL_INPUT_COMPONENTS, "GL_MAX_TESS_CONTROL_INPUT_COMPONENTS" );
	#endif
	#ifdef GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS
		swigIntConstant( GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS, "GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS" );
	#endif
	#ifdef GL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS
		swigIntConstant( GL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS, "GL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS" );
	#endif
	#ifdef GL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS
		swigIntConstant( GL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS, "GL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS" );
	#endif
	#ifdef GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_CONTROL_SHADER
		swigIntConstant( GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_CONTROL_SHADER, "GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_CONTROL_SHADER" );
	#endif
	#ifdef GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_EVALUATION_SHADER
		swigIntConstant( GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_EVALUATION_SHADER, "GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_EVALUATION_SHADER" );
	#endif
	#ifdef GL_TESS_EVALUATION_SHADER
		swigIntConstant( GL_TESS_EVALUATION_SHADER, "GL_TESS_EVALUATION_SHADER" );
	#endif
	#ifdef GL_TESS_CONTROL_SHADER
		swigIntConstant( GL_TESS_CONTROL_SHADER, "GL_TESS_CONTROL_SHADER" );
	#endif
	#ifdef GL_TRANSFORM_FEEDBACK
		swigIntConstant( GL_TRANSFORM_FEEDBACK, "GL_TRANSFORM_FEEDBACK" );
	#endif
	#ifdef GL_TRANSFORM_FEEDBACK_BUFFER_PAUSED
		swigIntConstant( GL_TRANSFORM_FEEDBACK_BUFFER_PAUSED, "GL_TRANSFORM_FEEDBACK_BUFFER_PAUSED" );
	#endif
	#ifdef GL_TRANSFORM_FEEDBACK_BUFFER_ACTIVE
		swigIntConstant( GL_TRANSFORM_FEEDBACK_BUFFER_ACTIVE, "GL_TRANSFORM_FEEDBACK_BUFFER_ACTIVE" );
	#endif
	#ifdef GL_TRANSFORM_FEEDBACK_BINDING
		swigIntConstant( GL_TRANSFORM_FEEDBACK_BINDING, "GL_TRANSFORM_FEEDBACK_BINDING" );
	#endif
	#ifdef GL_MAX_TRANSFORM_FEEDBACK_BUFFERS
		swigIntConstant( GL_MAX_TRANSFORM_FEEDBACK_BUFFERS, "GL_MAX_TRANSFORM_FEEDBACK_BUFFERS" );
	#endif
	#ifdef GL_VERSION_4_1
		swigIntConstant( GL_VERSION_4_1, "GL_VERSION_4_1" );
	#endif
	#ifdef GL_FIXED
		swigIntConstant( GL_FIXED, "GL_FIXED" );
	#endif
	#ifdef GL_IMPLEMENTATION_COLOR_READ_TYPE
		swigIntConstant( GL_IMPLEMENTATION_COLOR_READ_TYPE, "GL_IMPLEMENTATION_COLOR_READ_TYPE" );
	#endif
	#ifdef GL_IMPLEMENTATION_COLOR_READ_FORMAT
		swigIntConstant( GL_IMPLEMENTATION_COLOR_READ_FORMAT, "GL_IMPLEMENTATION_COLOR_READ_FORMAT" );
	#endif
	#ifdef GL_LOW_FLOAT
		swigIntConstant( GL_LOW_FLOAT, "GL_LOW_FLOAT" );
	#endif
	#ifdef GL_MEDIUM_FLOAT
		swigIntConstant( GL_MEDIUM_FLOAT, "GL_MEDIUM_FLOAT" );
	#endif
	#ifdef GL_HIGH_FLOAT
		swigIntConstant( GL_HIGH_FLOAT, "GL_HIGH_FLOAT" );
	#endif
	#ifdef GL_LOW_INT
		swigIntConstant( GL_LOW_INT, "GL_LOW_INT" );
	#endif
	#ifdef GL_MEDIUM_INT
		swigIntConstant( GL_MEDIUM_INT, "GL_MEDIUM_INT" );
	#endif
	#ifdef GL_HIGH_INT
		swigIntConstant( GL_HIGH_INT, "GL_HIGH_INT" );
	#endif
	#ifdef GL_SHADER_COMPILER
		swigIntConstant( GL_SHADER_COMPILER, "GL_SHADER_COMPILER" );
	#endif
	#ifdef GL_SHADER_BINARY_FORMATS
		swigIntConstant( GL_SHADER_BINARY_FORMATS, "GL_SHADER_BINARY_FORMATS" );
	#endif
	#ifdef GL_NUM_SHADER_BINARY_FORMATS
		swigIntConstant( GL_NUM_SHADER_BINARY_FORMATS, "GL_NUM_SHADER_BINARY_FORMATS" );
	#endif
	#ifdef GL_MAX_VERTEX_UNIFORM_VECTORS
		swigIntConstant( GL_MAX_VERTEX_UNIFORM_VECTORS, "GL_MAX_VERTEX_UNIFORM_VECTORS" );
	#endif
	#ifdef GL_MAX_VARYING_VECTORS
		swigIntConstant( GL_MAX_VARYING_VECTORS, "GL_MAX_VARYING_VECTORS" );
	#endif
	#ifdef GL_MAX_FRAGMENT_UNIFORM_VECTORS
		swigIntConstant( GL_MAX_FRAGMENT_UNIFORM_VECTORS, "GL_MAX_FRAGMENT_UNIFORM_VECTORS" );
	#endif
	#ifdef GL_RGB565
		swigIntConstant( GL_RGB565, "GL_RGB565" );
	#endif
	#ifdef GL_PROGRAM_BINARY_RETRIEVABLE_HINT
		swigIntConstant( GL_PROGRAM_BINARY_RETRIEVABLE_HINT, "GL_PROGRAM_BINARY_RETRIEVABLE_HINT" );
	#endif
	#ifdef GL_PROGRAM_BINARY_LENGTH
		swigIntConstant( GL_PROGRAM_BINARY_LENGTH, "GL_PROGRAM_BINARY_LENGTH" );
	#endif
	#ifdef GL_NUM_PROGRAM_BINARY_FORMATS
		swigIntConstant( GL_NUM_PROGRAM_BINARY_FORMATS, "GL_NUM_PROGRAM_BINARY_FORMATS" );
	#endif
	#ifdef GL_PROGRAM_BINARY_FORMATS
		swigIntConstant( GL_PROGRAM_BINARY_FORMATS, "GL_PROGRAM_BINARY_FORMATS" );
	#endif
	#ifdef GL_VERTEX_SHADER_BIT
		swigIntConstant( GL_VERTEX_SHADER_BIT, "GL_VERTEX_SHADER_BIT" );
	#endif
	#ifdef GL_FRAGMENT_SHADER_BIT
		swigIntConstant( GL_FRAGMENT_SHADER_BIT, "GL_FRAGMENT_SHADER_BIT" );
	#endif
	#ifdef GL_GEOMETRY_SHADER_BIT
		swigIntConstant( GL_GEOMETRY_SHADER_BIT, "GL_GEOMETRY_SHADER_BIT" );
	#endif
	#ifdef GL_TESS_CONTROL_SHADER_BIT
		swigIntConstant( GL_TESS_CONTROL_SHADER_BIT, "GL_TESS_CONTROL_SHADER_BIT" );
	#endif
	#ifdef GL_TESS_EVALUATION_SHADER_BIT
		swigIntConstant( GL_TESS_EVALUATION_SHADER_BIT, "GL_TESS_EVALUATION_SHADER_BIT" );
	#endif
	#ifdef GL_ALL_SHADER_BITS
		swigIntConstant( GL_ALL_SHADER_BITS, "GL_ALL_SHADER_BITS" );
	#endif
	#ifdef GL_PROGRAM_SEPARABLE
		swigIntConstant( GL_PROGRAM_SEPARABLE, "GL_PROGRAM_SEPARABLE" );
	#endif
	#ifdef GL_ACTIVE_PROGRAM
		swigIntConstant( GL_ACTIVE_PROGRAM, "GL_ACTIVE_PROGRAM" );
	#endif
	#ifdef GL_PROGRAM_PIPELINE_BINDING
		swigIntConstant( GL_PROGRAM_PIPELINE_BINDING, "GL_PROGRAM_PIPELINE_BINDING" );
	#endif
	#ifdef GL_MAX_VIEWPORTS
		swigIntConstant( GL_MAX_VIEWPORTS, "GL_MAX_VIEWPORTS" );
	#endif
	#ifdef GL_VIEWPORT_SUBPIXEL_BITS
		swigIntConstant( GL_VIEWPORT_SUBPIXEL_BITS, "GL_VIEWPORT_SUBPIXEL_BITS" );
	#endif
	#ifdef GL_VIEWPORT_BOUNDS_RANGE
		swigIntConstant( GL_VIEWPORT_BOUNDS_RANGE, "GL_VIEWPORT_BOUNDS_RANGE" );
	#endif
	#ifdef GL_LAYER_PROVOKING_VERTEX
		swigIntConstant( GL_LAYER_PROVOKING_VERTEX, "GL_LAYER_PROVOKING_VERTEX" );
	#endif
	#ifdef GL_VIEWPORT_INDEX_PROVOKING_VERTEX
		swigIntConstant( GL_VIEWPORT_INDEX_PROVOKING_VERTEX, "GL_VIEWPORT_INDEX_PROVOKING_VERTEX" );
	#endif
	#ifdef GL_UNDEFINED_VERTEX
		swigIntConstant( GL_UNDEFINED_VERTEX, "GL_UNDEFINED_VERTEX" );
	#endif
	#ifdef GL_VERSION_4_2
		swigIntConstant( GL_VERSION_4_2, "GL_VERSION_4_2" );
	#endif
	#ifdef GL_COPY_READ_BUFFER_BINDING
		swigIntConstant( GL_COPY_READ_BUFFER_BINDING, "GL_COPY_READ_BUFFER_BINDING" );
	#endif
	#ifdef GL_COPY_WRITE_BUFFER_BINDING
		swigIntConstant( GL_COPY_WRITE_BUFFER_BINDING, "GL_COPY_WRITE_BUFFER_BINDING" );
	#endif
	#ifdef GL_TRANSFORM_FEEDBACK_ACTIVE
		swigIntConstant( GL_TRANSFORM_FEEDBACK_ACTIVE, "GL_TRANSFORM_FEEDBACK_ACTIVE" );
	#endif
	#ifdef GL_TRANSFORM_FEEDBACK_PAUSED
		swigIntConstant( GL_TRANSFORM_FEEDBACK_PAUSED, "GL_TRANSFORM_FEEDBACK_PAUSED" );
	#endif
	#ifdef GL_UNPACK_COMPRESSED_BLOCK_WIDTH
		swigIntConstant( GL_UNPACK_COMPRESSED_BLOCK_WIDTH, "GL_UNPACK_COMPRESSED_BLOCK_WIDTH" );
	#endif
	#ifdef GL_UNPACK_COMPRESSED_BLOCK_HEIGHT
		swigIntConstant( GL_UNPACK_COMPRESSED_BLOCK_HEIGHT, "GL_UNPACK_COMPRESSED_BLOCK_HEIGHT" );
	#endif
	#ifdef GL_UNPACK_COMPRESSED_BLOCK_DEPTH
		swigIntConstant( GL_UNPACK_COMPRESSED_BLOCK_DEPTH, "GL_UNPACK_COMPRESSED_BLOCK_DEPTH" );
	#endif
	#ifdef GL_UNPACK_COMPRESSED_BLOCK_SIZE
		swigIntConstant( GL_UNPACK_COMPRESSED_BLOCK_SIZE, "GL_UNPACK_COMPRESSED_BLOCK_SIZE" );
	#endif
	#ifdef GL_PACK_COMPRESSED_BLOCK_WIDTH
		swigIntConstant( GL_PACK_COMPRESSED_BLOCK_WIDTH, "GL_PACK_COMPRESSED_BLOCK_WIDTH" );
	#endif
	#ifdef GL_PACK_COMPRESSED_BLOCK_HEIGHT
		swigIntConstant( GL_PACK_COMPRESSED_BLOCK_HEIGHT, "GL_PACK_COMPRESSED_BLOCK_HEIGHT" );
	#endif
	#ifdef GL_PACK_COMPRESSED_BLOCK_DEPTH
		swigIntConstant( GL_PACK_COMPRESSED_BLOCK_DEPTH, "GL_PACK_COMPRESSED_BLOCK_DEPTH" );
	#endif
	#ifdef GL_PACK_COMPRESSED_BLOCK_SIZE
		swigIntConstant( GL_PACK_COMPRESSED_BLOCK_SIZE, "GL_PACK_COMPRESSED_BLOCK_SIZE" );
	#endif
	#ifdef GL_NUM_SAMPLE_COUNTS
		swigIntConstant( GL_NUM_SAMPLE_COUNTS, "GL_NUM_SAMPLE_COUNTS" );
	#endif
	#ifdef GL_MIN_MAP_BUFFER_ALIGNMENT
		swigIntConstant( GL_MIN_MAP_BUFFER_ALIGNMENT, "GL_MIN_MAP_BUFFER_ALIGNMENT" );
	#endif
	#ifdef GL_ATOMIC_COUNTER_BUFFER
		swigIntConstant( GL_ATOMIC_COUNTER_BUFFER, "GL_ATOMIC_COUNTER_BUFFER" );
	#endif
	#ifdef GL_ATOMIC_COUNTER_BUFFER_BINDING
		swigIntConstant( GL_ATOMIC_COUNTER_BUFFER_BINDING, "GL_ATOMIC_COUNTER_BUFFER_BINDING" );
	#endif
	#ifdef GL_ATOMIC_COUNTER_BUFFER_START
		swigIntConstant( GL_ATOMIC_COUNTER_BUFFER_START, "GL_ATOMIC_COUNTER_BUFFER_START" );
	#endif
	#ifdef GL_ATOMIC_COUNTER_BUFFER_SIZE
		swigIntConstant( GL_ATOMIC_COUNTER_BUFFER_SIZE, "GL_ATOMIC_COUNTER_BUFFER_SIZE" );
	#endif
	#ifdef GL_ATOMIC_COUNTER_BUFFER_DATA_SIZE
		swigIntConstant( GL_ATOMIC_COUNTER_BUFFER_DATA_SIZE, "GL_ATOMIC_COUNTER_BUFFER_DATA_SIZE" );
	#endif
	#ifdef GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTERS
		swigIntConstant( GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTERS, "GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTERS" );
	#endif
	#ifdef GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTER_INDICES
		swigIntConstant( GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTER_INDICES, "GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTER_INDICES" );
	#endif
	#ifdef GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_VERTEX_SHADER
		swigIntConstant( GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_VERTEX_SHADER, "GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_VERTEX_SHADER" );
	#endif
	#ifdef GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_CONTROL_SHADER
		swigIntConstant( GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_CONTROL_SHADER, "GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_CONTROL_SHADER" );
	#endif
	#ifdef GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_EVALUATION_SHADER
		swigIntConstant( GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_EVALUATION_SHADER, "GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_EVALUATION_SHADER" );
	#endif
	#ifdef GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_GEOMETRY_SHADER
		swigIntConstant( GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_GEOMETRY_SHADER, "GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_GEOMETRY_SHADER" );
	#endif
	#ifdef GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_FRAGMENT_SHADER
		swigIntConstant( GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_FRAGMENT_SHADER, "GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_FRAGMENT_SHADER" );
	#endif
	#ifdef GL_MAX_VERTEX_ATOMIC_COUNTER_BUFFERS
		swigIntConstant( GL_MAX_VERTEX_ATOMIC_COUNTER_BUFFERS, "GL_MAX_VERTEX_ATOMIC_COUNTER_BUFFERS" );
	#endif
	#ifdef GL_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS
		swigIntConstant( GL_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS, "GL_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS" );
	#endif
	#ifdef GL_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS
		swigIntConstant( GL_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS, "GL_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS" );
	#endif
	#ifdef GL_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS
		swigIntConstant( GL_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS, "GL_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS" );
	#endif
	#ifdef GL_MAX_FRAGMENT_ATOMIC_COUNTER_BUFFERS
		swigIntConstant( GL_MAX_FRAGMENT_ATOMIC_COUNTER_BUFFERS, "GL_MAX_FRAGMENT_ATOMIC_COUNTER_BUFFERS" );
	#endif
	#ifdef GL_MAX_COMBINED_ATOMIC_COUNTER_BUFFERS
		swigIntConstant( GL_MAX_COMBINED_ATOMIC_COUNTER_BUFFERS, "GL_MAX_COMBINED_ATOMIC_COUNTER_BUFFERS" );
	#endif
	#ifdef GL_MAX_VERTEX_ATOMIC_COUNTERS
		swigIntConstant( GL_MAX_VERTEX_ATOMIC_COUNTERS, "GL_MAX_VERTEX_ATOMIC_COUNTERS" );
	#endif
	#ifdef GL_MAX_TESS_CONTROL_ATOMIC_COUNTERS
		swigIntConstant( GL_MAX_TESS_CONTROL_ATOMIC_COUNTERS, "GL_MAX_TESS_CONTROL_ATOMIC_COUNTERS" );
	#endif
	#ifdef GL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS
		swigIntConstant( GL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS, "GL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS" );
	#endif
	#ifdef GL_MAX_GEOMETRY_ATOMIC_COUNTERS
		swigIntConstant( GL_MAX_GEOMETRY_ATOMIC_COUNTERS, "GL_MAX_GEOMETRY_ATOMIC_COUNTERS" );
	#endif
	#ifdef GL_MAX_FRAGMENT_ATOMIC_COUNTERS
		swigIntConstant( GL_MAX_FRAGMENT_ATOMIC_COUNTERS, "GL_MAX_FRAGMENT_ATOMIC_COUNTERS" );
	#endif
	#ifdef GL_MAX_COMBINED_ATOMIC_COUNTERS
		swigIntConstant( GL_MAX_COMBINED_ATOMIC_COUNTERS, "GL_MAX_COMBINED_ATOMIC_COUNTERS" );
	#endif
	#ifdef GL_MAX_ATOMIC_COUNTER_BUFFER_SIZE
		swigIntConstant( GL_MAX_ATOMIC_COUNTER_BUFFER_SIZE, "GL_MAX_ATOMIC_COUNTER_BUFFER_SIZE" );
	#endif
	#ifdef GL_MAX_ATOMIC_COUNTER_BUFFER_BINDINGS
		swigIntConstant( GL_MAX_ATOMIC_COUNTER_BUFFER_BINDINGS, "GL_MAX_ATOMIC_COUNTER_BUFFER_BINDINGS" );
	#endif
	#ifdef GL_ACTIVE_ATOMIC_COUNTER_BUFFERS
		swigIntConstant( GL_ACTIVE_ATOMIC_COUNTER_BUFFERS, "GL_ACTIVE_ATOMIC_COUNTER_BUFFERS" );
	#endif
	#ifdef GL_UNIFORM_ATOMIC_COUNTER_BUFFER_INDEX
		swigIntConstant( GL_UNIFORM_ATOMIC_COUNTER_BUFFER_INDEX, "GL_UNIFORM_ATOMIC_COUNTER_BUFFER_INDEX" );
	#endif
	#ifdef GL_UNSIGNED_INT_ATOMIC_COUNTER
		swigIntConstant( GL_UNSIGNED_INT_ATOMIC_COUNTER, "GL_UNSIGNED_INT_ATOMIC_COUNTER" );
	#endif
	#ifdef GL_VERTEX_ATTRIB_ARRAY_BARRIER_BIT
		swigIntConstant( GL_VERTEX_ATTRIB_ARRAY_BARRIER_BIT, "GL_VERTEX_ATTRIB_ARRAY_BARRIER_BIT" );
	#endif
	#ifdef GL_ELEMENT_ARRAY_BARRIER_BIT
		swigIntConstant( GL_ELEMENT_ARRAY_BARRIER_BIT, "GL_ELEMENT_ARRAY_BARRIER_BIT" );
	#endif
	#ifdef GL_UNIFORM_BARRIER_BIT
		swigIntConstant( GL_UNIFORM_BARRIER_BIT, "GL_UNIFORM_BARRIER_BIT" );
	#endif
	#ifdef GL_TEXTURE_FETCH_BARRIER_BIT
		swigIntConstant( GL_TEXTURE_FETCH_BARRIER_BIT, "GL_TEXTURE_FETCH_BARRIER_BIT" );
	#endif
	#ifdef GL_SHADER_IMAGE_ACCESS_BARRIER_BIT
		swigIntConstant( GL_SHADER_IMAGE_ACCESS_BARRIER_BIT, "GL_SHADER_IMAGE_ACCESS_BARRIER_BIT" );
	#endif
	#ifdef GL_COMMAND_BARRIER_BIT
		swigIntConstant( GL_COMMAND_BARRIER_BIT, "GL_COMMAND_BARRIER_BIT" );
	#endif
	#ifdef GL_PIXEL_BUFFER_BARRIER_BIT
		swigIntConstant( GL_PIXEL_BUFFER_BARRIER_BIT, "GL_PIXEL_BUFFER_BARRIER_BIT" );
	#endif
	#ifdef GL_TEXTURE_UPDATE_BARRIER_BIT
		swigIntConstant( GL_TEXTURE_UPDATE_BARRIER_BIT, "GL_TEXTURE_UPDATE_BARRIER_BIT" );
	#endif
	#ifdef GL_BUFFER_UPDATE_BARRIER_BIT
		swigIntConstant( GL_BUFFER_UPDATE_BARRIER_BIT, "GL_BUFFER_UPDATE_BARRIER_BIT" );
	#endif
	#ifdef GL_FRAMEBUFFER_BARRIER_BIT
		swigIntConstant( GL_FRAMEBUFFER_BARRIER_BIT, "GL_FRAMEBUFFER_BARRIER_BIT" );
	#endif
	#ifdef GL_TRANSFORM_FEEDBACK_BARRIER_BIT
		swigIntConstant( GL_TRANSFORM_FEEDBACK_BARRIER_BIT, "GL_TRANSFORM_FEEDBACK_BARRIER_BIT" );
	#endif
	#ifdef GL_ATOMIC_COUNTER_BARRIER_BIT
		swigIntConstant( GL_ATOMIC_COUNTER_BARRIER_BIT, "GL_ATOMIC_COUNTER_BARRIER_BIT" );
	#endif
	#ifdef GL_ALL_BARRIER_BITS
		swigIntConstant( GL_ALL_BARRIER_BITS, "GL_ALL_BARRIER_BITS" );
	#endif
	#ifdef GL_MAX_IMAGE_UNITS
		swigIntConstant( GL_MAX_IMAGE_UNITS, "GL_MAX_IMAGE_UNITS" );
	#endif
	#ifdef GL_MAX_COMBINED_IMAGE_UNITS_AND_FRAGMENT_OUTPUTS
		swigIntConstant( GL_MAX_COMBINED_IMAGE_UNITS_AND_FRAGMENT_OUTPUTS, "GL_MAX_COMBINED_IMAGE_UNITS_AND_FRAGMENT_OUTPUTS" );
	#endif
	#ifdef GL_IMAGE_BINDING_NAME
		swigIntConstant( GL_IMAGE_BINDING_NAME, "GL_IMAGE_BINDING_NAME" );
	#endif
	#ifdef GL_IMAGE_BINDING_LEVEL
		swigIntConstant( GL_IMAGE_BINDING_LEVEL, "GL_IMAGE_BINDING_LEVEL" );
	#endif
	#ifdef GL_IMAGE_BINDING_LAYERED
		swigIntConstant( GL_IMAGE_BINDING_LAYERED, "GL_IMAGE_BINDING_LAYERED" );
	#endif
	#ifdef GL_IMAGE_BINDING_LAYER
		swigIntConstant( GL_IMAGE_BINDING_LAYER, "GL_IMAGE_BINDING_LAYER" );
	#endif
	#ifdef GL_IMAGE_BINDING_ACCESS
		swigIntConstant( GL_IMAGE_BINDING_ACCESS, "GL_IMAGE_BINDING_ACCESS" );
	#endif
	#ifdef GL_IMAGE_1D
		swigIntConstant( GL_IMAGE_1D, "GL_IMAGE_1D" );
	#endif
	#ifdef GL_IMAGE_2D
		swigIntConstant( GL_IMAGE_2D, "GL_IMAGE_2D" );
	#endif
	#ifdef GL_IMAGE_3D
		swigIntConstant( GL_IMAGE_3D, "GL_IMAGE_3D" );
	#endif
	#ifdef GL_IMAGE_2D_RECT
		swigIntConstant( GL_IMAGE_2D_RECT, "GL_IMAGE_2D_RECT" );
	#endif
	#ifdef GL_IMAGE_CUBE
		swigIntConstant( GL_IMAGE_CUBE, "GL_IMAGE_CUBE" );
	#endif
	#ifdef GL_IMAGE_BUFFER
		swigIntConstant( GL_IMAGE_BUFFER, "GL_IMAGE_BUFFER" );
	#endif
	#ifdef GL_IMAGE_1D_ARRAY
		swigIntConstant( GL_IMAGE_1D_ARRAY, "GL_IMAGE_1D_ARRAY" );
	#endif
	#ifdef GL_IMAGE_2D_ARRAY
		swigIntConstant( GL_IMAGE_2D_ARRAY, "GL_IMAGE_2D_ARRAY" );
	#endif
	#ifdef GL_IMAGE_CUBE_MAP_ARRAY
		swigIntConstant( GL_IMAGE_CUBE_MAP_ARRAY, "GL_IMAGE_CUBE_MAP_ARRAY" );
	#endif
	#ifdef GL_IMAGE_2D_MULTISAMPLE
		swigIntConstant( GL_IMAGE_2D_MULTISAMPLE, "GL_IMAGE_2D_MULTISAMPLE" );
	#endif
	#ifdef GL_IMAGE_2D_MULTISAMPLE_ARRAY
		swigIntConstant( GL_IMAGE_2D_MULTISAMPLE_ARRAY, "GL_IMAGE_2D_MULTISAMPLE_ARRAY" );
	#endif
	#ifdef GL_INT_IMAGE_1D
		swigIntConstant( GL_INT_IMAGE_1D, "GL_INT_IMAGE_1D" );
	#endif
	#ifdef GL_INT_IMAGE_2D
		swigIntConstant( GL_INT_IMAGE_2D, "GL_INT_IMAGE_2D" );
	#endif
	#ifdef GL_INT_IMAGE_3D
		swigIntConstant( GL_INT_IMAGE_3D, "GL_INT_IMAGE_3D" );
	#endif
	#ifdef GL_INT_IMAGE_2D_RECT
		swigIntConstant( GL_INT_IMAGE_2D_RECT, "GL_INT_IMAGE_2D_RECT" );
	#endif
	#ifdef GL_INT_IMAGE_CUBE
		swigIntConstant( GL_INT_IMAGE_CUBE, "GL_INT_IMAGE_CUBE" );
	#endif
	#ifdef GL_INT_IMAGE_BUFFER
		swigIntConstant( GL_INT_IMAGE_BUFFER, "GL_INT_IMAGE_BUFFER" );
	#endif
	#ifdef GL_INT_IMAGE_1D_ARRAY
		swigIntConstant( GL_INT_IMAGE_1D_ARRAY, "GL_INT_IMAGE_1D_ARRAY" );
	#endif
	#ifdef GL_INT_IMAGE_2D_ARRAY
		swigIntConstant( GL_INT_IMAGE_2D_ARRAY, "GL_INT_IMAGE_2D_ARRAY" );
	#endif
	#ifdef GL_INT_IMAGE_CUBE_MAP_ARRAY
		swigIntConstant( GL_INT_IMAGE_CUBE_MAP_ARRAY, "GL_INT_IMAGE_CUBE_MAP_ARRAY" );
	#endif
	#ifdef GL_INT_IMAGE_2D_MULTISAMPLE
		swigIntConstant( GL_INT_IMAGE_2D_MULTISAMPLE, "GL_INT_IMAGE_2D_MULTISAMPLE" );
	#endif
	#ifdef GL_INT_IMAGE_2D_MULTISAMPLE_ARRAY
		swigIntConstant( GL_INT_IMAGE_2D_MULTISAMPLE_ARRAY, "GL_INT_IMAGE_2D_MULTISAMPLE_ARRAY" );
	#endif
	#ifdef GL_UNSIGNED_INT_IMAGE_1D
		swigIntConstant( GL_UNSIGNED_INT_IMAGE_1D, "GL_UNSIGNED_INT_IMAGE_1D" );
	#endif
	#ifdef GL_UNSIGNED_INT_IMAGE_2D
		swigIntConstant( GL_UNSIGNED_INT_IMAGE_2D, "GL_UNSIGNED_INT_IMAGE_2D" );
	#endif
	#ifdef GL_UNSIGNED_INT_IMAGE_3D
		swigIntConstant( GL_UNSIGNED_INT_IMAGE_3D, "GL_UNSIGNED_INT_IMAGE_3D" );
	#endif
	#ifdef GL_UNSIGNED_INT_IMAGE_2D_RECT
		swigIntConstant( GL_UNSIGNED_INT_IMAGE_2D_RECT, "GL_UNSIGNED_INT_IMAGE_2D_RECT" );
	#endif
	#ifdef GL_UNSIGNED_INT_IMAGE_CUBE
		swigIntConstant( GL_UNSIGNED_INT_IMAGE_CUBE, "GL_UNSIGNED_INT_IMAGE_CUBE" );
	#endif
	#ifdef GL_UNSIGNED_INT_IMAGE_BUFFER
		swigIntConstant( GL_UNSIGNED_INT_IMAGE_BUFFER, "GL_UNSIGNED_INT_IMAGE_BUFFER" );
	#endif
	#ifdef GL_UNSIGNED_INT_IMAGE_1D_ARRAY
		swigIntConstant( GL_UNSIGNED_INT_IMAGE_1D_ARRAY, "GL_UNSIGNED_INT_IMAGE_1D_ARRAY" );
	#endif
	#ifdef GL_UNSIGNED_INT_IMAGE_2D_ARRAY
		swigIntConstant( GL_UNSIGNED_INT_IMAGE_2D_ARRAY, "GL_UNSIGNED_INT_IMAGE_2D_ARRAY" );
	#endif
	#ifdef GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY
		swigIntConstant( GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY, "GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY" );
	#endif
	#ifdef GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE
		swigIntConstant( GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE, "GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE" );
	#endif
	#ifdef GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_ARRAY
		swigIntConstant( GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_ARRAY, "GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_ARRAY" );
	#endif
	#ifdef GL_MAX_IMAGE_SAMPLES
		swigIntConstant( GL_MAX_IMAGE_SAMPLES, "GL_MAX_IMAGE_SAMPLES" );
	#endif
	#ifdef GL_IMAGE_BINDING_FORMAT
		swigIntConstant( GL_IMAGE_BINDING_FORMAT, "GL_IMAGE_BINDING_FORMAT" );
	#endif
	#ifdef GL_IMAGE_FORMAT_COMPATIBILITY_TYPE
		swigIntConstant( GL_IMAGE_FORMAT_COMPATIBILITY_TYPE, "GL_IMAGE_FORMAT_COMPATIBILITY_TYPE" );
	#endif
	#ifdef GL_IMAGE_FORMAT_COMPATIBILITY_BY_SIZE
		swigIntConstant( GL_IMAGE_FORMAT_COMPATIBILITY_BY_SIZE, "GL_IMAGE_FORMAT_COMPATIBILITY_BY_SIZE" );
	#endif
	#ifdef GL_IMAGE_FORMAT_COMPATIBILITY_BY_CLASS
		swigIntConstant( GL_IMAGE_FORMAT_COMPATIBILITY_BY_CLASS, "GL_IMAGE_FORMAT_COMPATIBILITY_BY_CLASS" );
	#endif
	#ifdef GL_MAX_VERTEX_IMAGE_UNIFORMS
		swigIntConstant( GL_MAX_VERTEX_IMAGE_UNIFORMS, "GL_MAX_VERTEX_IMAGE_UNIFORMS" );
	#endif
	#ifdef GL_MAX_TESS_CONTROL_IMAGE_UNIFORMS
		swigIntConstant( GL_MAX_TESS_CONTROL_IMAGE_UNIFORMS, "GL_MAX_TESS_CONTROL_IMAGE_UNIFORMS" );
	#endif
	#ifdef GL_MAX_TESS_EVALUATION_IMAGE_UNIFORMS
		swigIntConstant( GL_MAX_TESS_EVALUATION_IMAGE_UNIFORMS, "GL_MAX_TESS_EVALUATION_IMAGE_UNIFORMS" );
	#endif
	#ifdef GL_MAX_GEOMETRY_IMAGE_UNIFORMS
		swigIntConstant( GL_MAX_GEOMETRY_IMAGE_UNIFORMS, "GL_MAX_GEOMETRY_IMAGE_UNIFORMS" );
	#endif
	#ifdef GL_MAX_FRAGMENT_IMAGE_UNIFORMS
		swigIntConstant( GL_MAX_FRAGMENT_IMAGE_UNIFORMS, "GL_MAX_FRAGMENT_IMAGE_UNIFORMS" );
	#endif
	#ifdef GL_MAX_COMBINED_IMAGE_UNIFORMS
		swigIntConstant( GL_MAX_COMBINED_IMAGE_UNIFORMS, "GL_MAX_COMBINED_IMAGE_UNIFORMS" );
	#endif
	#ifdef GL_COMPRESSED_RGBA_BPTC_UNORM
		swigIntConstant( GL_COMPRESSED_RGBA_BPTC_UNORM, "GL_COMPRESSED_RGBA_BPTC_UNORM" );
	#endif
	#ifdef GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM
		swigIntConstant( GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM, "GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM" );
	#endif
	#ifdef GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT
		swigIntConstant( GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT, "GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT" );
	#endif
	#ifdef GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT
		swigIntConstant( GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT, "GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT" );
	#endif
	#ifdef GL_TEXTURE_IMMUTABLE_FORMAT
		swigIntConstant( GL_TEXTURE_IMMUTABLE_FORMAT, "GL_TEXTURE_IMMUTABLE_FORMAT" );
	#endif
	#ifdef GL_VERSION_4_3
		swigIntConstant( GL_VERSION_4_3, "GL_VERSION_4_3" );
	#endif
	#ifdef GL_NUM_SHADING_LANGUAGE_VERSIONS
		swigIntConstant( GL_NUM_SHADING_LANGUAGE_VERSIONS, "GL_NUM_SHADING_LANGUAGE_VERSIONS" );
	#endif
	#ifdef GL_VERTEX_ATTRIB_ARRAY_LONG
		swigIntConstant( GL_VERTEX_ATTRIB_ARRAY_LONG, "GL_VERTEX_ATTRIB_ARRAY_LONG" );
	#endif
	#ifdef GL_COMPRESSED_RGB8_ETC2
		swigIntConstant( GL_COMPRESSED_RGB8_ETC2, "GL_COMPRESSED_RGB8_ETC2" );
	#endif
	#ifdef GL_COMPRESSED_SRGB8_ETC2
		swigIntConstant( GL_COMPRESSED_SRGB8_ETC2, "GL_COMPRESSED_SRGB8_ETC2" );
	#endif
	#ifdef GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2
		swigIntConstant( GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2, "GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2" );
	#endif
	#ifdef GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2
		swigIntConstant( GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2, "GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2" );
	#endif
	#ifdef GL_COMPRESSED_RGBA8_ETC2_EAC
		swigIntConstant( GL_COMPRESSED_RGBA8_ETC2_EAC, "GL_COMPRESSED_RGBA8_ETC2_EAC" );
	#endif
	#ifdef GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC
		swigIntConstant( GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC, "GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC" );
	#endif
	#ifdef GL_COMPRESSED_R11_EAC
		swigIntConstant( GL_COMPRESSED_R11_EAC, "GL_COMPRESSED_R11_EAC" );
	#endif
	#ifdef GL_COMPRESSED_SIGNED_R11_EAC
		swigIntConstant( GL_COMPRESSED_SIGNED_R11_EAC, "GL_COMPRESSED_SIGNED_R11_EAC" );
	#endif
	#ifdef GL_COMPRESSED_RG11_EAC
		swigIntConstant( GL_COMPRESSED_RG11_EAC, "GL_COMPRESSED_RG11_EAC" );
	#endif
	#ifdef GL_COMPRESSED_SIGNED_RG11_EAC
		swigIntConstant( GL_COMPRESSED_SIGNED_RG11_EAC, "GL_COMPRESSED_SIGNED_RG11_EAC" );
	#endif
	#ifdef GL_PRIMITIVE_RESTART_FIXED_INDEX
		swigIntConstant( GL_PRIMITIVE_RESTART_FIXED_INDEX, "GL_PRIMITIVE_RESTART_FIXED_INDEX" );
	#endif
	#ifdef GL_ANY_SAMPLES_PASSED_CONSERVATIVE
		swigIntConstant( GL_ANY_SAMPLES_PASSED_CONSERVATIVE, "GL_ANY_SAMPLES_PASSED_CONSERVATIVE" );
	#endif
	#ifdef GL_MAX_ELEMENT_INDEX
		swigIntConstant( GL_MAX_ELEMENT_INDEX, "GL_MAX_ELEMENT_INDEX" );
	#endif
	#ifdef GL_COMPUTE_SHADER
		swigIntConstant( GL_COMPUTE_SHADER, "GL_COMPUTE_SHADER" );
	#endif
	#ifdef GL_MAX_COMPUTE_UNIFORM_BLOCKS
		swigIntConstant( GL_MAX_COMPUTE_UNIFORM_BLOCKS, "GL_MAX_COMPUTE_UNIFORM_BLOCKS" );
	#endif
	#ifdef GL_MAX_COMPUTE_TEXTURE_IMAGE_UNITS
		swigIntConstant( GL_MAX_COMPUTE_TEXTURE_IMAGE_UNITS, "GL_MAX_COMPUTE_TEXTURE_IMAGE_UNITS" );
	#endif
	#ifdef GL_MAX_COMPUTE_IMAGE_UNIFORMS
		swigIntConstant( GL_MAX_COMPUTE_IMAGE_UNIFORMS, "GL_MAX_COMPUTE_IMAGE_UNIFORMS" );
	#endif
	#ifdef GL_MAX_COMPUTE_SHARED_MEMORY_SIZE
		swigIntConstant( GL_MAX_COMPUTE_SHARED_MEMORY_SIZE, "GL_MAX_COMPUTE_SHARED_MEMORY_SIZE" );
	#endif
	#ifdef GL_MAX_COMPUTE_UNIFORM_COMPONENTS
		swigIntConstant( GL_MAX_COMPUTE_UNIFORM_COMPONENTS, "GL_MAX_COMPUTE_UNIFORM_COMPONENTS" );
	#endif
	#ifdef GL_MAX_COMPUTE_ATOMIC_COUNTER_BUFFERS
		swigIntConstant( GL_MAX_COMPUTE_ATOMIC_COUNTER_BUFFERS, "GL_MAX_COMPUTE_ATOMIC_COUNTER_BUFFERS" );
	#endif
	#ifdef GL_MAX_COMPUTE_ATOMIC_COUNTERS
		swigIntConstant( GL_MAX_COMPUTE_ATOMIC_COUNTERS, "GL_MAX_COMPUTE_ATOMIC_COUNTERS" );
	#endif
	#ifdef GL_MAX_COMBINED_COMPUTE_UNIFORM_COMPONENTS
		swigIntConstant( GL_MAX_COMBINED_COMPUTE_UNIFORM_COMPONENTS, "GL_MAX_COMBINED_COMPUTE_UNIFORM_COMPONENTS" );
	#endif
	#ifdef GL_MAX_COMPUTE_WORK_GROUP_INVOCATIONS
		swigIntConstant( GL_MAX_COMPUTE_WORK_GROUP_INVOCATIONS, "GL_MAX_COMPUTE_WORK_GROUP_INVOCATIONS" );
	#endif
	#ifdef GL_MAX_COMPUTE_WORK_GROUP_COUNT
		swigIntConstant( GL_MAX_COMPUTE_WORK_GROUP_COUNT, "GL_MAX_COMPUTE_WORK_GROUP_COUNT" );
	#endif
	#ifdef GL_MAX_COMPUTE_WORK_GROUP_SIZE
		swigIntConstant( GL_MAX_COMPUTE_WORK_GROUP_SIZE, "GL_MAX_COMPUTE_WORK_GROUP_SIZE" );
	#endif
	#ifdef GL_COMPUTE_WORK_GROUP_SIZE
		swigIntConstant( GL_COMPUTE_WORK_GROUP_SIZE, "GL_COMPUTE_WORK_GROUP_SIZE" );
	#endif
	#ifdef GL_UNIFORM_BLOCK_REFERENCED_BY_COMPUTE_SHADER
		swigIntConstant( GL_UNIFORM_BLOCK_REFERENCED_BY_COMPUTE_SHADER, "GL_UNIFORM_BLOCK_REFERENCED_BY_COMPUTE_SHADER" );
	#endif
	#ifdef GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_COMPUTE_SHADER
		swigIntConstant( GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_COMPUTE_SHADER, "GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_COMPUTE_SHADER" );
	#endif
	#ifdef GL_DISPATCH_INDIRECT_BUFFER
		swigIntConstant( GL_DISPATCH_INDIRECT_BUFFER, "GL_DISPATCH_INDIRECT_BUFFER" );
	#endif
	#ifdef GL_DISPATCH_INDIRECT_BUFFER_BINDING
		swigIntConstant( GL_DISPATCH_INDIRECT_BUFFER_BINDING, "GL_DISPATCH_INDIRECT_BUFFER_BINDING" );
	#endif
	#ifdef GL_COMPUTE_SHADER_BIT
		swigIntConstant( GL_COMPUTE_SHADER_BIT, "GL_COMPUTE_SHADER_BIT" );
	#endif
	#ifdef GL_DEBUG_OUTPUT_SYNCHRONOUS
		swigIntConstant( GL_DEBUG_OUTPUT_SYNCHRONOUS, "GL_DEBUG_OUTPUT_SYNCHRONOUS" );
	#endif
	#ifdef GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH
		swigIntConstant( GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH, "GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH" );
	#endif
	#ifdef GL_DEBUG_CALLBACK_FUNCTION
		swigIntConstant( GL_DEBUG_CALLBACK_FUNCTION, "GL_DEBUG_CALLBACK_FUNCTION" );
	#endif
	#ifdef GL_DEBUG_CALLBACK_USER_PARAM
		swigIntConstant( GL_DEBUG_CALLBACK_USER_PARAM, "GL_DEBUG_CALLBACK_USER_PARAM" );
	#endif
	#ifdef GL_DEBUG_SOURCE_API
		swigIntConstant( GL_DEBUG_SOURCE_API, "GL_DEBUG_SOURCE_API" );
	#endif
	#ifdef GL_DEBUG_SOURCE_WINDOW_SYSTEM
		swigIntConstant( GL_DEBUG_SOURCE_WINDOW_SYSTEM, "GL_DEBUG_SOURCE_WINDOW_SYSTEM" );
	#endif
	#ifdef GL_DEBUG_SOURCE_SHADER_COMPILER
		swigIntConstant( GL_DEBUG_SOURCE_SHADER_COMPILER, "GL_DEBUG_SOURCE_SHADER_COMPILER" );
	#endif
	#ifdef GL_DEBUG_SOURCE_THIRD_PARTY
		swigIntConstant( GL_DEBUG_SOURCE_THIRD_PARTY, "GL_DEBUG_SOURCE_THIRD_PARTY" );
	#endif
	#ifdef GL_DEBUG_SOURCE_APPLICATION
		swigIntConstant( GL_DEBUG_SOURCE_APPLICATION, "GL_DEBUG_SOURCE_APPLICATION" );
	#endif
	#ifdef GL_DEBUG_SOURCE_OTHER
		swigIntConstant( GL_DEBUG_SOURCE_OTHER, "GL_DEBUG_SOURCE_OTHER" );
	#endif
	#ifdef GL_DEBUG_TYPE_ERROR
		swigIntConstant( GL_DEBUG_TYPE_ERROR, "GL_DEBUG_TYPE_ERROR" );
	#endif
	#ifdef GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR
		swigIntConstant( GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR, "GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR" );
	#endif
	#ifdef GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR
		swigIntConstant( GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR, "GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR" );
	#endif
	#ifdef GL_DEBUG_TYPE_PORTABILITY
		swigIntConstant( GL_DEBUG_TYPE_PORTABILITY, "GL_DEBUG_TYPE_PORTABILITY" );
	#endif
	#ifdef GL_DEBUG_TYPE_PERFORMANCE
		swigIntConstant( GL_DEBUG_TYPE_PERFORMANCE, "GL_DEBUG_TYPE_PERFORMANCE" );
	#endif
	#ifdef GL_DEBUG_TYPE_OTHER
		swigIntConstant( GL_DEBUG_TYPE_OTHER, "GL_DEBUG_TYPE_OTHER" );
	#endif
	#ifdef GL_MAX_DEBUG_MESSAGE_LENGTH
		swigIntConstant( GL_MAX_DEBUG_MESSAGE_LENGTH, "GL_MAX_DEBUG_MESSAGE_LENGTH" );
	#endif
	#ifdef GL_MAX_DEBUG_LOGGED_MESSAGES
		swigIntConstant( GL_MAX_DEBUG_LOGGED_MESSAGES, "GL_MAX_DEBUG_LOGGED_MESSAGES" );
	#endif
	#ifdef GL_DEBUG_LOGGED_MESSAGES
		swigIntConstant( GL_DEBUG_LOGGED_MESSAGES, "GL_DEBUG_LOGGED_MESSAGES" );
	#endif
	#ifdef GL_DEBUG_SEVERITY_HIGH
		swigIntConstant( GL_DEBUG_SEVERITY_HIGH, "GL_DEBUG_SEVERITY_HIGH" );
	#endif
	#ifdef GL_DEBUG_SEVERITY_MEDIUM
		swigIntConstant( GL_DEBUG_SEVERITY_MEDIUM, "GL_DEBUG_SEVERITY_MEDIUM" );
	#endif
	#ifdef GL_DEBUG_SEVERITY_LOW
		swigIntConstant( GL_DEBUG_SEVERITY_LOW, "GL_DEBUG_SEVERITY_LOW" );
	#endif
	#ifdef GL_DEBUG_TYPE_MARKER
		swigIntConstant( GL_DEBUG_TYPE_MARKER, "GL_DEBUG_TYPE_MARKER" );
	#endif
	#ifdef GL_DEBUG_TYPE_PUSH_GROUP
		swigIntConstant( GL_DEBUG_TYPE_PUSH_GROUP, "GL_DEBUG_TYPE_PUSH_GROUP" );
	#endif
	#ifdef GL_DEBUG_TYPE_POP_GROUP
		swigIntConstant( GL_DEBUG_TYPE_POP_GROUP, "GL_DEBUG_TYPE_POP_GROUP" );
	#endif
	#ifdef GL_DEBUG_SEVERITY_NOTIFICATION
		swigIntConstant( GL_DEBUG_SEVERITY_NOTIFICATION, "GL_DEBUG_SEVERITY_NOTIFICATION" );
	#endif
	#ifdef GL_MAX_DEBUG_GROUP_STACK_DEPTH
		swigIntConstant( GL_MAX_DEBUG_GROUP_STACK_DEPTH, "GL_MAX_DEBUG_GROUP_STACK_DEPTH" );
	#endif
	#ifdef GL_DEBUG_GROUP_STACK_DEPTH
		swigIntConstant( GL_DEBUG_GROUP_STACK_DEPTH, "GL_DEBUG_GROUP_STACK_DEPTH" );
	#endif
	#ifdef GL_BUFFER
		swigIntConstant( GL_BUFFER, "GL_BUFFER" );
	#endif
	#ifdef GL_SHADER
		swigIntConstant( GL_SHADER, "GL_SHADER" );
	#endif
	#ifdef GL_PROGRAM
		swigIntConstant( GL_PROGRAM, "GL_PROGRAM" );
	#endif
	#ifdef GL_QUERY
		swigIntConstant( GL_QUERY, "GL_QUERY" );
	#endif
	#ifdef GL_PROGRAM_PIPELINE
		swigIntConstant( GL_PROGRAM_PIPELINE, "GL_PROGRAM_PIPELINE" );
	#endif
	#ifdef GL_SAMPLER
		swigIntConstant( GL_SAMPLER, "GL_SAMPLER" );
	#endif
	#ifdef GL_MAX_LABEL_LENGTH
		swigIntConstant( GL_MAX_LABEL_LENGTH, "GL_MAX_LABEL_LENGTH" );
	#endif
	#ifdef GL_DEBUG_OUTPUT
		swigIntConstant( GL_DEBUG_OUTPUT, "GL_DEBUG_OUTPUT" );
	#endif
	#ifdef GL_CONTEXT_FLAG_DEBUG_BIT
		swigIntConstant( GL_CONTEXT_FLAG_DEBUG_BIT, "GL_CONTEXT_FLAG_DEBUG_BIT" );
	#endif
	#ifdef GL_MAX_UNIFORM_LOCATIONS
		swigIntConstant( GL_MAX_UNIFORM_LOCATIONS, "GL_MAX_UNIFORM_LOCATIONS" );
	#endif
	#ifdef GL_FRAMEBUFFER_DEFAULT_WIDTH
		swigIntConstant( GL_FRAMEBUFFER_DEFAULT_WIDTH, "GL_FRAMEBUFFER_DEFAULT_WIDTH" );
	#endif
	#ifdef GL_FRAMEBUFFER_DEFAULT_HEIGHT
		swigIntConstant( GL_FRAMEBUFFER_DEFAULT_HEIGHT, "GL_FRAMEBUFFER_DEFAULT_HEIGHT" );
	#endif
	#ifdef GL_FRAMEBUFFER_DEFAULT_LAYERS
		swigIntConstant( GL_FRAMEBUFFER_DEFAULT_LAYERS, "GL_FRAMEBUFFER_DEFAULT_LAYERS" );
	#endif
	#ifdef GL_FRAMEBUFFER_DEFAULT_SAMPLES
		swigIntConstant( GL_FRAMEBUFFER_DEFAULT_SAMPLES, "GL_FRAMEBUFFER_DEFAULT_SAMPLES" );
	#endif
	#ifdef GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS
		swigIntConstant( GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS, "GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS" );
	#endif
	#ifdef GL_MAX_FRAMEBUFFER_WIDTH
		swigIntConstant( GL_MAX_FRAMEBUFFER_WIDTH, "GL_MAX_FRAMEBUFFER_WIDTH" );
	#endif
	#ifdef GL_MAX_FRAMEBUFFER_HEIGHT
		swigIntConstant( GL_MAX_FRAMEBUFFER_HEIGHT, "GL_MAX_FRAMEBUFFER_HEIGHT" );
	#endif
	#ifdef GL_MAX_FRAMEBUFFER_LAYERS
		swigIntConstant( GL_MAX_FRAMEBUFFER_LAYERS, "GL_MAX_FRAMEBUFFER_LAYERS" );
	#endif
	#ifdef GL_MAX_FRAMEBUFFER_SAMPLES
		swigIntConstant( GL_MAX_FRAMEBUFFER_SAMPLES, "GL_MAX_FRAMEBUFFER_SAMPLES" );
	#endif
	#ifdef GL_INTERNALFORMAT_SUPPORTED
		swigIntConstant( GL_INTERNALFORMAT_SUPPORTED, "GL_INTERNALFORMAT_SUPPORTED" );
	#endif
	#ifdef GL_INTERNALFORMAT_PREFERRED
		swigIntConstant( GL_INTERNALFORMAT_PREFERRED, "GL_INTERNALFORMAT_PREFERRED" );
	#endif
	#ifdef GL_INTERNALFORMAT_RED_SIZE
		swigIntConstant( GL_INTERNALFORMAT_RED_SIZE, "GL_INTERNALFORMAT_RED_SIZE" );
	#endif
	#ifdef GL_INTERNALFORMAT_GREEN_SIZE
		swigIntConstant( GL_INTERNALFORMAT_GREEN_SIZE, "GL_INTERNALFORMAT_GREEN_SIZE" );
	#endif
	#ifdef GL_INTERNALFORMAT_BLUE_SIZE
		swigIntConstant( GL_INTERNALFORMAT_BLUE_SIZE, "GL_INTERNALFORMAT_BLUE_SIZE" );
	#endif
	#ifdef GL_INTERNALFORMAT_ALPHA_SIZE
		swigIntConstant( GL_INTERNALFORMAT_ALPHA_SIZE, "GL_INTERNALFORMAT_ALPHA_SIZE" );
	#endif
	#ifdef GL_INTERNALFORMAT_DEPTH_SIZE
		swigIntConstant( GL_INTERNALFORMAT_DEPTH_SIZE, "GL_INTERNALFORMAT_DEPTH_SIZE" );
	#endif
	#ifdef GL_INTERNALFORMAT_STENCIL_SIZE
		swigIntConstant( GL_INTERNALFORMAT_STENCIL_SIZE, "GL_INTERNALFORMAT_STENCIL_SIZE" );
	#endif
	#ifdef GL_INTERNALFORMAT_SHARED_SIZE
		swigIntConstant( GL_INTERNALFORMAT_SHARED_SIZE, "GL_INTERNALFORMAT_SHARED_SIZE" );
	#endif
	#ifdef GL_INTERNALFORMAT_RED_TYPE
		swigIntConstant( GL_INTERNALFORMAT_RED_TYPE, "GL_INTERNALFORMAT_RED_TYPE" );
	#endif
	#ifdef GL_INTERNALFORMAT_GREEN_TYPE
		swigIntConstant( GL_INTERNALFORMAT_GREEN_TYPE, "GL_INTERNALFORMAT_GREEN_TYPE" );
	#endif
	#ifdef GL_INTERNALFORMAT_BLUE_TYPE
		swigIntConstant( GL_INTERNALFORMAT_BLUE_TYPE, "GL_INTERNALFORMAT_BLUE_TYPE" );
	#endif
	#ifdef GL_INTERNALFORMAT_ALPHA_TYPE
		swigIntConstant( GL_INTERNALFORMAT_ALPHA_TYPE, "GL_INTERNALFORMAT_ALPHA_TYPE" );
	#endif
	#ifdef GL_INTERNALFORMAT_DEPTH_TYPE
		swigIntConstant( GL_INTERNALFORMAT_DEPTH_TYPE, "GL_INTERNALFORMAT_DEPTH_TYPE" );
	#endif
	#ifdef GL_INTERNALFORMAT_STENCIL_TYPE
		swigIntConstant( GL_INTERNALFORMAT_STENCIL_TYPE, "GL_INTERNALFORMAT_STENCIL_TYPE" );
	#endif
	#ifdef GL_MAX_WIDTH
		swigIntConstant( GL_MAX_WIDTH, "GL_MAX_WIDTH" );
	#endif
	#ifdef GL_MAX_HEIGHT
		swigIntConstant( GL_MAX_HEIGHT, "GL_MAX_HEIGHT" );
	#endif
	#ifdef GL_MAX_DEPTH
		swigIntConstant( GL_MAX_DEPTH, "GL_MAX_DEPTH" );
	#endif
	#ifdef GL_MAX_LAYERS
		swigIntConstant( GL_MAX_LAYERS, "GL_MAX_LAYERS" );
	#endif
	#ifdef GL_MAX_COMBINED_DIMENSIONS
		swigIntConstant( GL_MAX_COMBINED_DIMENSIONS, "GL_MAX_COMBINED_DIMENSIONS" );
	#endif
	#ifdef GL_COLOR_COMPONENTS
		swigIntConstant( GL_COLOR_COMPONENTS, "GL_COLOR_COMPONENTS" );
	#endif
	#ifdef GL_DEPTH_COMPONENTS
		swigIntConstant( GL_DEPTH_COMPONENTS, "GL_DEPTH_COMPONENTS" );
	#endif
	#ifdef GL_STENCIL_COMPONENTS
		swigIntConstant( GL_STENCIL_COMPONENTS, "GL_STENCIL_COMPONENTS" );
	#endif
	#ifdef GL_COLOR_RENDERABLE
		swigIntConstant( GL_COLOR_RENDERABLE, "GL_COLOR_RENDERABLE" );
	#endif
	#ifdef GL_DEPTH_RENDERABLE
		swigIntConstant( GL_DEPTH_RENDERABLE, "GL_DEPTH_RENDERABLE" );
	#endif
	#ifdef GL_STENCIL_RENDERABLE
		swigIntConstant( GL_STENCIL_RENDERABLE, "GL_STENCIL_RENDERABLE" );
	#endif
	#ifdef GL_FRAMEBUFFER_RENDERABLE
		swigIntConstant( GL_FRAMEBUFFER_RENDERABLE, "GL_FRAMEBUFFER_RENDERABLE" );
	#endif
	#ifdef GL_FRAMEBUFFER_RENDERABLE_LAYERED
		swigIntConstant( GL_FRAMEBUFFER_RENDERABLE_LAYERED, "GL_FRAMEBUFFER_RENDERABLE_LAYERED" );
	#endif
	#ifdef GL_FRAMEBUFFER_BLEND
		swigIntConstant( GL_FRAMEBUFFER_BLEND, "GL_FRAMEBUFFER_BLEND" );
	#endif
	#ifdef GL_READ_PIXELS
		swigIntConstant( GL_READ_PIXELS, "GL_READ_PIXELS" );
	#endif
	#ifdef GL_READ_PIXELS_FORMAT
		swigIntConstant( GL_READ_PIXELS_FORMAT, "GL_READ_PIXELS_FORMAT" );
	#endif
	#ifdef GL_READ_PIXELS_TYPE
		swigIntConstant( GL_READ_PIXELS_TYPE, "GL_READ_PIXELS_TYPE" );
	#endif
	#ifdef GL_TEXTURE_IMAGE_FORMAT
		swigIntConstant( GL_TEXTURE_IMAGE_FORMAT, "GL_TEXTURE_IMAGE_FORMAT" );
	#endif
	#ifdef GL_TEXTURE_IMAGE_TYPE
		swigIntConstant( GL_TEXTURE_IMAGE_TYPE, "GL_TEXTURE_IMAGE_TYPE" );
	#endif
	#ifdef GL_GET_TEXTURE_IMAGE_FORMAT
		swigIntConstant( GL_GET_TEXTURE_IMAGE_FORMAT, "GL_GET_TEXTURE_IMAGE_FORMAT" );
	#endif
	#ifdef GL_GET_TEXTURE_IMAGE_TYPE
		swigIntConstant( GL_GET_TEXTURE_IMAGE_TYPE, "GL_GET_TEXTURE_IMAGE_TYPE" );
	#endif
	#ifdef GL_MIPMAP
		swigIntConstant( GL_MIPMAP, "GL_MIPMAP" );
	#endif
	#ifdef GL_MANUAL_GENERATE_MIPMAP
		swigIntConstant( GL_MANUAL_GENERATE_MIPMAP, "GL_MANUAL_GENERATE_MIPMAP" );
	#endif
	#ifdef GL_AUTO_GENERATE_MIPMAP
		swigIntConstant( GL_AUTO_GENERATE_MIPMAP, "GL_AUTO_GENERATE_MIPMAP" );
	#endif
	#ifdef GL_COLOR_ENCODING
		swigIntConstant( GL_COLOR_ENCODING, "GL_COLOR_ENCODING" );
	#endif
	#ifdef GL_SRGB_READ
		swigIntConstant( GL_SRGB_READ, "GL_SRGB_READ" );
	#endif
	#ifdef GL_SRGB_WRITE
		swigIntConstant( GL_SRGB_WRITE, "GL_SRGB_WRITE" );
	#endif
	#ifdef GL_FILTER
		swigIntConstant( GL_FILTER, "GL_FILTER" );
	#endif
	#ifdef GL_VERTEX_TEXTURE
		swigIntConstant( GL_VERTEX_TEXTURE, "GL_VERTEX_TEXTURE" );
	#endif
	#ifdef GL_TESS_CONTROL_TEXTURE
		swigIntConstant( GL_TESS_CONTROL_TEXTURE, "GL_TESS_CONTROL_TEXTURE" );
	#endif
	#ifdef GL_TESS_EVALUATION_TEXTURE
		swigIntConstant( GL_TESS_EVALUATION_TEXTURE, "GL_TESS_EVALUATION_TEXTURE" );
	#endif
	#ifdef GL_GEOMETRY_TEXTURE
		swigIntConstant( GL_GEOMETRY_TEXTURE, "GL_GEOMETRY_TEXTURE" );
	#endif
	#ifdef GL_FRAGMENT_TEXTURE
		swigIntConstant( GL_FRAGMENT_TEXTURE, "GL_FRAGMENT_TEXTURE" );
	#endif
	#ifdef GL_COMPUTE_TEXTURE
		swigIntConstant( GL_COMPUTE_TEXTURE, "GL_COMPUTE_TEXTURE" );
	#endif
	#ifdef GL_TEXTURE_SHADOW
		swigIntConstant( GL_TEXTURE_SHADOW, "GL_TEXTURE_SHADOW" );
	#endif
	#ifdef GL_TEXTURE_GATHER
		swigIntConstant( GL_TEXTURE_GATHER, "GL_TEXTURE_GATHER" );
	#endif
	#ifdef GL_TEXTURE_GATHER_SHADOW
		swigIntConstant( GL_TEXTURE_GATHER_SHADOW, "GL_TEXTURE_GATHER_SHADOW" );
	#endif
	#ifdef GL_SHADER_IMAGE_LOAD
		swigIntConstant( GL_SHADER_IMAGE_LOAD, "GL_SHADER_IMAGE_LOAD" );
	#endif
	#ifdef GL_SHADER_IMAGE_STORE
		swigIntConstant( GL_SHADER_IMAGE_STORE, "GL_SHADER_IMAGE_STORE" );
	#endif
	#ifdef GL_SHADER_IMAGE_ATOMIC
		swigIntConstant( GL_SHADER_IMAGE_ATOMIC, "GL_SHADER_IMAGE_ATOMIC" );
	#endif
	#ifdef GL_IMAGE_TEXEL_SIZE
		swigIntConstant( GL_IMAGE_TEXEL_SIZE, "GL_IMAGE_TEXEL_SIZE" );
	#endif
	#ifdef GL_IMAGE_COMPATIBILITY_CLASS
		swigIntConstant( GL_IMAGE_COMPATIBILITY_CLASS, "GL_IMAGE_COMPATIBILITY_CLASS" );
	#endif
	#ifdef GL_IMAGE_PIXEL_FORMAT
		swigIntConstant( GL_IMAGE_PIXEL_FORMAT, "GL_IMAGE_PIXEL_FORMAT" );
	#endif
	#ifdef GL_IMAGE_PIXEL_TYPE
		swigIntConstant( GL_IMAGE_PIXEL_TYPE, "GL_IMAGE_PIXEL_TYPE" );
	#endif
	#ifdef GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_TEST
		swigIntConstant( GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_TEST, "GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_TEST" );
	#endif
	#ifdef GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_TEST
		swigIntConstant( GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_TEST, "GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_TEST" );
	#endif
	#ifdef GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_WRITE
		swigIntConstant( GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_WRITE, "GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_WRITE" );
	#endif
	#ifdef GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_WRITE
		swigIntConstant( GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_WRITE, "GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_WRITE" );
	#endif
	#ifdef GL_TEXTURE_COMPRESSED_BLOCK_WIDTH
		swigIntConstant( GL_TEXTURE_COMPRESSED_BLOCK_WIDTH, "GL_TEXTURE_COMPRESSED_BLOCK_WIDTH" );
	#endif
	#ifdef GL_TEXTURE_COMPRESSED_BLOCK_HEIGHT
		swigIntConstant( GL_TEXTURE_COMPRESSED_BLOCK_HEIGHT, "GL_TEXTURE_COMPRESSED_BLOCK_HEIGHT" );
	#endif
	#ifdef GL_TEXTURE_COMPRESSED_BLOCK_SIZE
		swigIntConstant( GL_TEXTURE_COMPRESSED_BLOCK_SIZE, "GL_TEXTURE_COMPRESSED_BLOCK_SIZE" );
	#endif
	#ifdef GL_CLEAR_BUFFER
		swigIntConstant( GL_CLEAR_BUFFER, "GL_CLEAR_BUFFER" );
	#endif
	#ifdef GL_TEXTURE_VIEW
		swigIntConstant( GL_TEXTURE_VIEW, "GL_TEXTURE_VIEW" );
	#endif
	#ifdef GL_VIEW_COMPATIBILITY_CLASS
		swigIntConstant( GL_VIEW_COMPATIBILITY_CLASS, "GL_VIEW_COMPATIBILITY_CLASS" );
	#endif
	#ifdef GL_FULL_SUPPORT
		swigIntConstant( GL_FULL_SUPPORT, "GL_FULL_SUPPORT" );
	#endif
	#ifdef GL_CAVEAT_SUPPORT
		swigIntConstant( GL_CAVEAT_SUPPORT, "GL_CAVEAT_SUPPORT" );
	#endif
	#ifdef GL_IMAGE_CLASS_4_X_32
		swigIntConstant( GL_IMAGE_CLASS_4_X_32, "GL_IMAGE_CLASS_4_X_32" );
	#endif
	#ifdef GL_IMAGE_CLASS_2_X_32
		swigIntConstant( GL_IMAGE_CLASS_2_X_32, "GL_IMAGE_CLASS_2_X_32" );
	#endif
	#ifdef GL_IMAGE_CLASS_1_X_32
		swigIntConstant( GL_IMAGE_CLASS_1_X_32, "GL_IMAGE_CLASS_1_X_32" );
	#endif
	#ifdef GL_IMAGE_CLASS_4_X_16
		swigIntConstant( GL_IMAGE_CLASS_4_X_16, "GL_IMAGE_CLASS_4_X_16" );
	#endif
	#ifdef GL_IMAGE_CLASS_2_X_16
		swigIntConstant( GL_IMAGE_CLASS_2_X_16, "GL_IMAGE_CLASS_2_X_16" );
	#endif
	#ifdef GL_IMAGE_CLASS_1_X_16
		swigIntConstant( GL_IMAGE_CLASS_1_X_16, "GL_IMAGE_CLASS_1_X_16" );
	#endif
	#ifdef GL_IMAGE_CLASS_4_X_8
		swigIntConstant( GL_IMAGE_CLASS_4_X_8, "GL_IMAGE_CLASS_4_X_8" );
	#endif
	#ifdef GL_IMAGE_CLASS_2_X_8
		swigIntConstant( GL_IMAGE_CLASS_2_X_8, "GL_IMAGE_CLASS_2_X_8" );
	#endif
	#ifdef GL_IMAGE_CLASS_1_X_8
		swigIntConstant( GL_IMAGE_CLASS_1_X_8, "GL_IMAGE_CLASS_1_X_8" );
	#endif
	#ifdef GL_IMAGE_CLASS_11_11_10
		swigIntConstant( GL_IMAGE_CLASS_11_11_10, "GL_IMAGE_CLASS_11_11_10" );
	#endif
	#ifdef GL_IMAGE_CLASS_10_10_10_2
		swigIntConstant( GL_IMAGE_CLASS_10_10_10_2, "GL_IMAGE_CLASS_10_10_10_2" );
	#endif
	#ifdef GL_VIEW_CLASS_128_BITS
		swigIntConstant( GL_VIEW_CLASS_128_BITS, "GL_VIEW_CLASS_128_BITS" );
	#endif
	#ifdef GL_VIEW_CLASS_96_BITS
		swigIntConstant( GL_VIEW_CLASS_96_BITS, "GL_VIEW_CLASS_96_BITS" );
	#endif
	#ifdef GL_VIEW_CLASS_64_BITS
		swigIntConstant( GL_VIEW_CLASS_64_BITS, "GL_VIEW_CLASS_64_BITS" );
	#endif
	#ifdef GL_VIEW_CLASS_48_BITS
		swigIntConstant( GL_VIEW_CLASS_48_BITS, "GL_VIEW_CLASS_48_BITS" );
	#endif
	#ifdef GL_VIEW_CLASS_32_BITS
		swigIntConstant( GL_VIEW_CLASS_32_BITS, "GL_VIEW_CLASS_32_BITS" );
	#endif
	#ifdef GL_VIEW_CLASS_24_BITS
		swigIntConstant( GL_VIEW_CLASS_24_BITS, "GL_VIEW_CLASS_24_BITS" );
	#endif
	#ifdef GL_VIEW_CLASS_16_BITS
		swigIntConstant( GL_VIEW_CLASS_16_BITS, "GL_VIEW_CLASS_16_BITS" );
	#endif
	#ifdef GL_VIEW_CLASS_8_BITS
		swigIntConstant( GL_VIEW_CLASS_8_BITS, "GL_VIEW_CLASS_8_BITS" );
	#endif
	#ifdef GL_VIEW_CLASS_S3TC_DXT1_RGB
		swigIntConstant( GL_VIEW_CLASS_S3TC_DXT1_RGB, "GL_VIEW_CLASS_S3TC_DXT1_RGB" );
	#endif
	#ifdef GL_VIEW_CLASS_S3TC_DXT1_RGBA
		swigIntConstant( GL_VIEW_CLASS_S3TC_DXT1_RGBA, "GL_VIEW_CLASS_S3TC_DXT1_RGBA" );
	#endif
	#ifdef GL_VIEW_CLASS_S3TC_DXT3_RGBA
		swigIntConstant( GL_VIEW_CLASS_S3TC_DXT3_RGBA, "GL_VIEW_CLASS_S3TC_DXT3_RGBA" );
	#endif
	#ifdef GL_VIEW_CLASS_S3TC_DXT5_RGBA
		swigIntConstant( GL_VIEW_CLASS_S3TC_DXT5_RGBA, "GL_VIEW_CLASS_S3TC_DXT5_RGBA" );
	#endif
	#ifdef GL_VIEW_CLASS_RGTC1_RED
		swigIntConstant( GL_VIEW_CLASS_RGTC1_RED, "GL_VIEW_CLASS_RGTC1_RED" );
	#endif
	#ifdef GL_VIEW_CLASS_RGTC2_RG
		swigIntConstant( GL_VIEW_CLASS_RGTC2_RG, "GL_VIEW_CLASS_RGTC2_RG" );
	#endif
	#ifdef GL_VIEW_CLASS_BPTC_UNORM
		swigIntConstant( GL_VIEW_CLASS_BPTC_UNORM, "GL_VIEW_CLASS_BPTC_UNORM" );
	#endif
	#ifdef GL_VIEW_CLASS_BPTC_FLOAT
		swigIntConstant( GL_VIEW_CLASS_BPTC_FLOAT, "GL_VIEW_CLASS_BPTC_FLOAT" );
	#endif
	#ifdef GL_UNIFORM
		swigIntConstant( GL_UNIFORM, "GL_UNIFORM" );
	#endif
	#ifdef GL_UNIFORM_BLOCK
		swigIntConstant( GL_UNIFORM_BLOCK, "GL_UNIFORM_BLOCK" );
	#endif
	#ifdef GL_PROGRAM_INPUT
		swigIntConstant( GL_PROGRAM_INPUT, "GL_PROGRAM_INPUT" );
	#endif
	#ifdef GL_PROGRAM_OUTPUT
		swigIntConstant( GL_PROGRAM_OUTPUT, "GL_PROGRAM_OUTPUT" );
	#endif
	#ifdef GL_BUFFER_VARIABLE
		swigIntConstant( GL_BUFFER_VARIABLE, "GL_BUFFER_VARIABLE" );
	#endif
	#ifdef GL_SHADER_STORAGE_BLOCK
		swigIntConstant( GL_SHADER_STORAGE_BLOCK, "GL_SHADER_STORAGE_BLOCK" );
	#endif
	#ifdef GL_VERTEX_SUBROUTINE
		swigIntConstant( GL_VERTEX_SUBROUTINE, "GL_VERTEX_SUBROUTINE" );
	#endif
	#ifdef GL_TESS_CONTROL_SUBROUTINE
		swigIntConstant( GL_TESS_CONTROL_SUBROUTINE, "GL_TESS_CONTROL_SUBROUTINE" );
	#endif
	#ifdef GL_TESS_EVALUATION_SUBROUTINE
		swigIntConstant( GL_TESS_EVALUATION_SUBROUTINE, "GL_TESS_EVALUATION_SUBROUTINE" );
	#endif
	#ifdef GL_GEOMETRY_SUBROUTINE
		swigIntConstant( GL_GEOMETRY_SUBROUTINE, "GL_GEOMETRY_SUBROUTINE" );
	#endif
	#ifdef GL_FRAGMENT_SUBROUTINE
		swigIntConstant( GL_FRAGMENT_SUBROUTINE, "GL_FRAGMENT_SUBROUTINE" );
	#endif
	#ifdef GL_COMPUTE_SUBROUTINE
		swigIntConstant( GL_COMPUTE_SUBROUTINE, "GL_COMPUTE_SUBROUTINE" );
	#endif
	#ifdef GL_VERTEX_SUBROUTINE_UNIFORM
		swigIntConstant( GL_VERTEX_SUBROUTINE_UNIFORM, "GL_VERTEX_SUBROUTINE_UNIFORM" );
	#endif
	#ifdef GL_TESS_CONTROL_SUBROUTINE_UNIFORM
		swigIntConstant( GL_TESS_CONTROL_SUBROUTINE_UNIFORM, "GL_TESS_CONTROL_SUBROUTINE_UNIFORM" );
	#endif
	#ifdef GL_TESS_EVALUATION_SUBROUTINE_UNIFORM
		swigIntConstant( GL_TESS_EVALUATION_SUBROUTINE_UNIFORM, "GL_TESS_EVALUATION_SUBROUTINE_UNIFORM" );
	#endif
	#ifdef GL_GEOMETRY_SUBROUTINE_UNIFORM
		swigIntConstant( GL_GEOMETRY_SUBROUTINE_UNIFORM, "GL_GEOMETRY_SUBROUTINE_UNIFORM" );
	#endif
	#ifdef GL_FRAGMENT_SUBROUTINE_UNIFORM
		swigIntConstant( GL_FRAGMENT_SUBROUTINE_UNIFORM, "GL_FRAGMENT_SUBROUTINE_UNIFORM" );
	#endif
	#ifdef GL_COMPUTE_SUBROUTINE_UNIFORM
		swigIntConstant( GL_COMPUTE_SUBROUTINE_UNIFORM, "GL_COMPUTE_SUBROUTINE_UNIFORM" );
	#endif
	#ifdef GL_TRANSFORM_FEEDBACK_VARYING
		swigIntConstant( GL_TRANSFORM_FEEDBACK_VARYING, "GL_TRANSFORM_FEEDBACK_VARYING" );
	#endif
	#ifdef GL_ACTIVE_RESOURCES
		swigIntConstant( GL_ACTIVE_RESOURCES, "GL_ACTIVE_RESOURCES" );
	#endif
	#ifdef GL_MAX_NAME_LENGTH
		swigIntConstant( GL_MAX_NAME_LENGTH, "GL_MAX_NAME_LENGTH" );
	#endif
	#ifdef GL_MAX_NUM_ACTIVE_VARIABLES
		swigIntConstant( GL_MAX_NUM_ACTIVE_VARIABLES, "GL_MAX_NUM_ACTIVE_VARIABLES" );
	#endif
	#ifdef GL_MAX_NUM_COMPATIBLE_SUBROUTINES
		swigIntConstant( GL_MAX_NUM_COMPATIBLE_SUBROUTINES, "GL_MAX_NUM_COMPATIBLE_SUBROUTINES" );
	#endif
	#ifdef GL_NAME_LENGTH
		swigIntConstant( GL_NAME_LENGTH, "GL_NAME_LENGTH" );
	#endif
	#ifdef GL_TYPE
		swigIntConstant( GL_TYPE, "GL_TYPE" );
	#endif
	#ifdef GL_ARRAY_SIZE
		swigIntConstant( GL_ARRAY_SIZE, "GL_ARRAY_SIZE" );
	#endif
	#ifdef GL_OFFSET
		swigIntConstant( GL_OFFSET, "GL_OFFSET" );
	#endif
	#ifdef GL_BLOCK_INDEX
		swigIntConstant( GL_BLOCK_INDEX, "GL_BLOCK_INDEX" );
	#endif
	#ifdef GL_ARRAY_STRIDE
		swigIntConstant( GL_ARRAY_STRIDE, "GL_ARRAY_STRIDE" );
	#endif
	#ifdef GL_MATRIX_STRIDE
		swigIntConstant( GL_MATRIX_STRIDE, "GL_MATRIX_STRIDE" );
	#endif
	#ifdef GL_IS_ROW_MAJOR
		swigIntConstant( GL_IS_ROW_MAJOR, "GL_IS_ROW_MAJOR" );
	#endif
	#ifdef GL_ATOMIC_COUNTER_BUFFER_INDEX
		swigIntConstant( GL_ATOMIC_COUNTER_BUFFER_INDEX, "GL_ATOMIC_COUNTER_BUFFER_INDEX" );
	#endif
	#ifdef GL_BUFFER_BINDING
		swigIntConstant( GL_BUFFER_BINDING, "GL_BUFFER_BINDING" );
	#endif
	#ifdef GL_BUFFER_DATA_SIZE
		swigIntConstant( GL_BUFFER_DATA_SIZE, "GL_BUFFER_DATA_SIZE" );
	#endif
	#ifdef GL_NUM_ACTIVE_VARIABLES
		swigIntConstant( GL_NUM_ACTIVE_VARIABLES, "GL_NUM_ACTIVE_VARIABLES" );
	#endif
	#ifdef GL_ACTIVE_VARIABLES
		swigIntConstant( GL_ACTIVE_VARIABLES, "GL_ACTIVE_VARIABLES" );
	#endif
	#ifdef GL_REFERENCED_BY_VERTEX_SHADER
		swigIntConstant( GL_REFERENCED_BY_VERTEX_SHADER, "GL_REFERENCED_BY_VERTEX_SHADER" );
	#endif
	#ifdef GL_REFERENCED_BY_TESS_CONTROL_SHADER
		swigIntConstant( GL_REFERENCED_BY_TESS_CONTROL_SHADER, "GL_REFERENCED_BY_TESS_CONTROL_SHADER" );
	#endif
	#ifdef GL_REFERENCED_BY_TESS_EVALUATION_SHADER
		swigIntConstant( GL_REFERENCED_BY_TESS_EVALUATION_SHADER, "GL_REFERENCED_BY_TESS_EVALUATION_SHADER" );
	#endif
	#ifdef GL_REFERENCED_BY_GEOMETRY_SHADER
		swigIntConstant( GL_REFERENCED_BY_GEOMETRY_SHADER, "GL_REFERENCED_BY_GEOMETRY_SHADER" );
	#endif
	#ifdef GL_REFERENCED_BY_FRAGMENT_SHADER
		swigIntConstant( GL_REFERENCED_BY_FRAGMENT_SHADER, "GL_REFERENCED_BY_FRAGMENT_SHADER" );
	#endif
	#ifdef GL_REFERENCED_BY_COMPUTE_SHADER
		swigIntConstant( GL_REFERENCED_BY_COMPUTE_SHADER, "GL_REFERENCED_BY_COMPUTE_SHADER" );
	#endif
	#ifdef GL_TOP_LEVEL_ARRAY_SIZE
		swigIntConstant( GL_TOP_LEVEL_ARRAY_SIZE, "GL_TOP_LEVEL_ARRAY_SIZE" );
	#endif
	#ifdef GL_TOP_LEVEL_ARRAY_STRIDE
		swigIntConstant( GL_TOP_LEVEL_ARRAY_STRIDE, "GL_TOP_LEVEL_ARRAY_STRIDE" );
	#endif
	#ifdef GL_LOCATION
		swigIntConstant( GL_LOCATION, "GL_LOCATION" );
	#endif
	#ifdef GL_LOCATION_INDEX
		swigIntConstant( GL_LOCATION_INDEX, "GL_LOCATION_INDEX" );
	#endif
	#ifdef GL_IS_PER_PATCH
		swigIntConstant( GL_IS_PER_PATCH, "GL_IS_PER_PATCH" );
	#endif
	#ifdef GL_SHADER_STORAGE_BUFFER
		swigIntConstant( GL_SHADER_STORAGE_BUFFER, "GL_SHADER_STORAGE_BUFFER" );
	#endif
	#ifdef GL_SHADER_STORAGE_BUFFER_BINDING
		swigIntConstant( GL_SHADER_STORAGE_BUFFER_BINDING, "GL_SHADER_STORAGE_BUFFER_BINDING" );
	#endif
	#ifdef GL_SHADER_STORAGE_BUFFER_START
		swigIntConstant( GL_SHADER_STORAGE_BUFFER_START, "GL_SHADER_STORAGE_BUFFER_START" );
	#endif
	#ifdef GL_SHADER_STORAGE_BUFFER_SIZE
		swigIntConstant( GL_SHADER_STORAGE_BUFFER_SIZE, "GL_SHADER_STORAGE_BUFFER_SIZE" );
	#endif
	#ifdef GL_MAX_VERTEX_SHADER_STORAGE_BLOCKS
		swigIntConstant( GL_MAX_VERTEX_SHADER_STORAGE_BLOCKS, "GL_MAX_VERTEX_SHADER_STORAGE_BLOCKS" );
	#endif
	#ifdef GL_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS
		swigIntConstant( GL_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS, "GL_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS" );
	#endif
	#ifdef GL_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS
		swigIntConstant( GL_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS, "GL_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS" );
	#endif
	#ifdef GL_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS
		swigIntConstant( GL_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS, "GL_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS" );
	#endif
	#ifdef GL_MAX_FRAGMENT_SHADER_STORAGE_BLOCKS
		swigIntConstant( GL_MAX_FRAGMENT_SHADER_STORAGE_BLOCKS, "GL_MAX_FRAGMENT_SHADER_STORAGE_BLOCKS" );
	#endif
	#ifdef GL_MAX_COMPUTE_SHADER_STORAGE_BLOCKS
		swigIntConstant( GL_MAX_COMPUTE_SHADER_STORAGE_BLOCKS, "GL_MAX_COMPUTE_SHADER_STORAGE_BLOCKS" );
	#endif
	#ifdef GL_MAX_COMBINED_SHADER_STORAGE_BLOCKS
		swigIntConstant( GL_MAX_COMBINED_SHADER_STORAGE_BLOCKS, "GL_MAX_COMBINED_SHADER_STORAGE_BLOCKS" );
	#endif
	#ifdef GL_MAX_SHADER_STORAGE_BUFFER_BINDINGS
		swigIntConstant( GL_MAX_SHADER_STORAGE_BUFFER_BINDINGS, "GL_MAX_SHADER_STORAGE_BUFFER_BINDINGS" );
	#endif
	#ifdef GL_MAX_SHADER_STORAGE_BLOCK_SIZE
		swigIntConstant( GL_MAX_SHADER_STORAGE_BLOCK_SIZE, "GL_MAX_SHADER_STORAGE_BLOCK_SIZE" );
	#endif
	#ifdef GL_SHADER_STORAGE_BUFFER_OFFSET_ALIGNMENT
		swigIntConstant( GL_SHADER_STORAGE_BUFFER_OFFSET_ALIGNMENT, "GL_SHADER_STORAGE_BUFFER_OFFSET_ALIGNMENT" );
	#endif
	#ifdef GL_SHADER_STORAGE_BARRIER_BIT
		swigIntConstant( GL_SHADER_STORAGE_BARRIER_BIT, "GL_SHADER_STORAGE_BARRIER_BIT" );
	#endif
	#ifdef GL_MAX_COMBINED_SHADER_OUTPUT_RESOURCES
		swigIntConstant( GL_MAX_COMBINED_SHADER_OUTPUT_RESOURCES, "GL_MAX_COMBINED_SHADER_OUTPUT_RESOURCES" );
	#endif
	#ifdef GL_DEPTH_STENCIL_TEXTURE_MODE
		swigIntConstant( GL_DEPTH_STENCIL_TEXTURE_MODE, "GL_DEPTH_STENCIL_TEXTURE_MODE" );
	#endif
	#ifdef GL_TEXTURE_BUFFER_OFFSET
		swigIntConstant( GL_TEXTURE_BUFFER_OFFSET, "GL_TEXTURE_BUFFER_OFFSET" );
	#endif
	#ifdef GL_TEXTURE_BUFFER_SIZE
		swigIntConstant( GL_TEXTURE_BUFFER_SIZE, "GL_TEXTURE_BUFFER_SIZE" );
	#endif
	#ifdef GL_TEXTURE_BUFFER_OFFSET_ALIGNMENT
		swigIntConstant( GL_TEXTURE_BUFFER_OFFSET_ALIGNMENT, "GL_TEXTURE_BUFFER_OFFSET_ALIGNMENT" );
	#endif
	#ifdef GL_TEXTURE_VIEW_MIN_LEVEL
		swigIntConstant( GL_TEXTURE_VIEW_MIN_LEVEL, "GL_TEXTURE_VIEW_MIN_LEVEL" );
	#endif
	#ifdef GL_TEXTURE_VIEW_NUM_LEVELS
		swigIntConstant( GL_TEXTURE_VIEW_NUM_LEVELS, "GL_TEXTURE_VIEW_NUM_LEVELS" );
	#endif
	#ifdef GL_TEXTURE_VIEW_MIN_LAYER
		swigIntConstant( GL_TEXTURE_VIEW_MIN_LAYER, "GL_TEXTURE_VIEW_MIN_LAYER" );
	#endif
	#ifdef GL_TEXTURE_VIEW_NUM_LAYERS
		swigIntConstant( GL_TEXTURE_VIEW_NUM_LAYERS, "GL_TEXTURE_VIEW_NUM_LAYERS" );
	#endif
	#ifdef GL_TEXTURE_IMMUTABLE_LEVELS
		swigIntConstant( GL_TEXTURE_IMMUTABLE_LEVELS, "GL_TEXTURE_IMMUTABLE_LEVELS" );
	#endif
	#ifdef GL_VERTEX_ATTRIB_BINDING
		swigIntConstant( GL_VERTEX_ATTRIB_BINDING, "GL_VERTEX_ATTRIB_BINDING" );
	#endif
	#ifdef GL_VERTEX_ATTRIB_RELATIVE_OFFSET
		swigIntConstant( GL_VERTEX_ATTRIB_RELATIVE_OFFSET, "GL_VERTEX_ATTRIB_RELATIVE_OFFSET" );
	#endif
	#ifdef GL_VERTEX_BINDING_DIVISOR
		swigIntConstant( GL_VERTEX_BINDING_DIVISOR, "GL_VERTEX_BINDING_DIVISOR" );
	#endif
	#ifdef GL_VERTEX_BINDING_OFFSET
		swigIntConstant( GL_VERTEX_BINDING_OFFSET, "GL_VERTEX_BINDING_OFFSET" );
	#endif
	#ifdef GL_VERTEX_BINDING_STRIDE
		swigIntConstant( GL_VERTEX_BINDING_STRIDE, "GL_VERTEX_BINDING_STRIDE" );
	#endif
	#ifdef GL_MAX_VERTEX_ATTRIB_RELATIVE_OFFSET
		swigIntConstant( GL_MAX_VERTEX_ATTRIB_RELATIVE_OFFSET, "GL_MAX_VERTEX_ATTRIB_RELATIVE_OFFSET" );
	#endif
	#ifdef GL_MAX_VERTEX_ATTRIB_BINDINGS
		swigIntConstant( GL_MAX_VERTEX_ATTRIB_BINDINGS, "GL_MAX_VERTEX_ATTRIB_BINDINGS" );
	#endif
	#ifdef GL_VERTEX_BINDING_BUFFER
		swigIntConstant( GL_VERTEX_BINDING_BUFFER, "GL_VERTEX_BINDING_BUFFER" );
	#endif
	#ifdef GL_DISPLAY_LIST
		swigIntConstant( GL_DISPLAY_LIST, "GL_DISPLAY_LIST" );
	#endif
	#ifdef GL_VERSION_4_4
		swigIntConstant( GL_VERSION_4_4, "GL_VERSION_4_4" );
	#endif
	#ifdef GL_MAX_VERTEX_ATTRIB_STRIDE
		swigIntConstant( GL_MAX_VERTEX_ATTRIB_STRIDE, "GL_MAX_VERTEX_ATTRIB_STRIDE" );
	#endif
	#ifdef GL_PRIMITIVE_RESTART_FOR_PATCHES_SUPPORTED
		swigIntConstant( GL_PRIMITIVE_RESTART_FOR_PATCHES_SUPPORTED, "GL_PRIMITIVE_RESTART_FOR_PATCHES_SUPPORTED" );
	#endif
	#ifdef GL_TEXTURE_BUFFER_BINDING
		swigIntConstant( GL_TEXTURE_BUFFER_BINDING, "GL_TEXTURE_BUFFER_BINDING" );
	#endif
	#ifdef GL_MAP_PERSISTENT_BIT
		swigIntConstant( GL_MAP_PERSISTENT_BIT, "GL_MAP_PERSISTENT_BIT" );
	#endif
	#ifdef GL_MAP_COHERENT_BIT
		swigIntConstant( GL_MAP_COHERENT_BIT, "GL_MAP_COHERENT_BIT" );
	#endif
	#ifdef GL_DYNAMIC_STORAGE_BIT
		swigIntConstant( GL_DYNAMIC_STORAGE_BIT, "GL_DYNAMIC_STORAGE_BIT" );
	#endif
	#ifdef GL_CLIENT_STORAGE_BIT
		swigIntConstant( GL_CLIENT_STORAGE_BIT, "GL_CLIENT_STORAGE_BIT" );
	#endif
	#ifdef GL_CLIENT_MAPPED_BUFFER_BARRIER_BIT
		swigIntConstant( GL_CLIENT_MAPPED_BUFFER_BARRIER_BIT, "GL_CLIENT_MAPPED_BUFFER_BARRIER_BIT" );
	#endif
	#ifdef GL_BUFFER_IMMUTABLE_STORAGE
		swigIntConstant( GL_BUFFER_IMMUTABLE_STORAGE, "GL_BUFFER_IMMUTABLE_STORAGE" );
	#endif
	#ifdef GL_BUFFER_STORAGE_FLAGS
		swigIntConstant( GL_BUFFER_STORAGE_FLAGS, "GL_BUFFER_STORAGE_FLAGS" );
	#endif
	#ifdef GL_CLEAR_TEXTURE
		swigIntConstant( GL_CLEAR_TEXTURE, "GL_CLEAR_TEXTURE" );
	#endif
	#ifdef GL_LOCATION_COMPONENT
		swigIntConstant( GL_LOCATION_COMPONENT, "GL_LOCATION_COMPONENT" );
	#endif
	#ifdef GL_TRANSFORM_FEEDBACK_BUFFER_INDEX
		swigIntConstant( GL_TRANSFORM_FEEDBACK_BUFFER_INDEX, "GL_TRANSFORM_FEEDBACK_BUFFER_INDEX" );
	#endif
	#ifdef GL_TRANSFORM_FEEDBACK_BUFFER_STRIDE
		swigIntConstant( GL_TRANSFORM_FEEDBACK_BUFFER_STRIDE, "GL_TRANSFORM_FEEDBACK_BUFFER_STRIDE" );
	#endif
	#ifdef GL_QUERY_BUFFER
		swigIntConstant( GL_QUERY_BUFFER, "GL_QUERY_BUFFER" );
	#endif
	#ifdef GL_QUERY_BUFFER_BARRIER_BIT
		swigIntConstant( GL_QUERY_BUFFER_BARRIER_BIT, "GL_QUERY_BUFFER_BARRIER_BIT" );
	#endif
	#ifdef GL_QUERY_BUFFER_BINDING
		swigIntConstant( GL_QUERY_BUFFER_BINDING, "GL_QUERY_BUFFER_BINDING" );
	#endif
	#ifdef GL_QUERY_RESULT_NO_WAIT
		swigIntConstant( GL_QUERY_RESULT_NO_WAIT, "GL_QUERY_RESULT_NO_WAIT" );
	#endif
	#ifdef GL_MIRROR_CLAMP_TO_EDGE
		swigIntConstant( GL_MIRROR_CLAMP_TO_EDGE, "GL_MIRROR_CLAMP_TO_EDGE" );
	#endif
	#ifdef GL_VERSION_4_5
		swigIntConstant( GL_VERSION_4_5, "GL_VERSION_4_5" );
	#endif
	#ifdef GL_CONTEXT_LOST
		swigIntConstant( GL_CONTEXT_LOST, "GL_CONTEXT_LOST" );
	#endif
	#ifdef GL_NEGATIVE_ONE_TO_ONE
		swigIntConstant( GL_NEGATIVE_ONE_TO_ONE, "GL_NEGATIVE_ONE_TO_ONE" );
	#endif
	#ifdef GL_ZERO_TO_ONE
		swigIntConstant( GL_ZERO_TO_ONE, "GL_ZERO_TO_ONE" );
	#endif
	#ifdef GL_CLIP_ORIGIN
		swigIntConstant( GL_CLIP_ORIGIN, "GL_CLIP_ORIGIN" );
	#endif
	#ifdef GL_CLIP_DEPTH_MODE
		swigIntConstant( GL_CLIP_DEPTH_MODE, "GL_CLIP_DEPTH_MODE" );
	#endif
	#ifdef GL_QUERY_WAIT_INVERTED
		swigIntConstant( GL_QUERY_WAIT_INVERTED, "GL_QUERY_WAIT_INVERTED" );
	#endif
	#ifdef GL_QUERY_NO_WAIT_INVERTED
		swigIntConstant( GL_QUERY_NO_WAIT_INVERTED, "GL_QUERY_NO_WAIT_INVERTED" );
	#endif
	#ifdef GL_QUERY_BY_REGION_WAIT_INVERTED
		swigIntConstant( GL_QUERY_BY_REGION_WAIT_INVERTED, "GL_QUERY_BY_REGION_WAIT_INVERTED" );
	#endif
	#ifdef GL_QUERY_BY_REGION_NO_WAIT_INVERTED
		swigIntConstant( GL_QUERY_BY_REGION_NO_WAIT_INVERTED, "GL_QUERY_BY_REGION_NO_WAIT_INVERTED" );
	#endif
	#ifdef GL_MAX_CULL_DISTANCES
		swigIntConstant( GL_MAX_CULL_DISTANCES, "GL_MAX_CULL_DISTANCES" );
	#endif
	#ifdef GL_MAX_COMBINED_CLIP_AND_CULL_DISTANCES
		swigIntConstant( GL_MAX_COMBINED_CLIP_AND_CULL_DISTANCES, "GL_MAX_COMBINED_CLIP_AND_CULL_DISTANCES" );
	#endif
	#ifdef GL_TEXTURE_TARGET
		swigIntConstant( GL_TEXTURE_TARGET, "GL_TEXTURE_TARGET" );
	#endif
	#ifdef GL_QUERY_TARGET
		swigIntConstant( GL_QUERY_TARGET, "GL_QUERY_TARGET" );
	#endif
	#ifdef GL_GUILTY_CONTEXT_RESET
		swigIntConstant( GL_GUILTY_CONTEXT_RESET, "GL_GUILTY_CONTEXT_RESET" );
	#endif
	#ifdef GL_INNOCENT_CONTEXT_RESET
		swigIntConstant( GL_INNOCENT_CONTEXT_RESET, "GL_INNOCENT_CONTEXT_RESET" );
	#endif
	#ifdef GL_UNKNOWN_CONTEXT_RESET
		swigIntConstant( GL_UNKNOWN_CONTEXT_RESET, "GL_UNKNOWN_CONTEXT_RESET" );
	#endif
	#ifdef GL_RESET_NOTIFICATION_STRATEGY
		swigIntConstant( GL_RESET_NOTIFICATION_STRATEGY, "GL_RESET_NOTIFICATION_STRATEGY" );
	#endif
	#ifdef GL_LOSE_CONTEXT_ON_RESET
		swigIntConstant( GL_LOSE_CONTEXT_ON_RESET, "GL_LOSE_CONTEXT_ON_RESET" );
	#endif
	#ifdef GL_NO_RESET_NOTIFICATION
		swigIntConstant( GL_NO_RESET_NOTIFICATION, "GL_NO_RESET_NOTIFICATION" );
	#endif
	#ifdef GL_CONTEXT_FLAG_ROBUST_ACCESS_BIT
		swigIntConstant( GL_CONTEXT_FLAG_ROBUST_ACCESS_BIT, "GL_CONTEXT_FLAG_ROBUST_ACCESS_BIT" );
	#endif
	#ifdef GL_CONTEXT_RELEASE_BEHAVIOR
		swigIntConstant( GL_CONTEXT_RELEASE_BEHAVIOR, "GL_CONTEXT_RELEASE_BEHAVIOR" );
	#endif
	#ifdef GL_CONTEXT_RELEASE_BEHAVIOR_FLUSH
		swigIntConstant( GL_CONTEXT_RELEASE_BEHAVIOR_FLUSH, "GL_CONTEXT_RELEASE_BEHAVIOR_FLUSH" );
	#endif
	#ifdef GL_VERSION_4_6
		swigIntConstant( GL_VERSION_4_6, "GL_VERSION_4_6" );
	#endif
	#ifdef GL_SHADER_BINARY_FORMAT_SPIR_V
		swigIntConstant( GL_SHADER_BINARY_FORMAT_SPIR_V, "GL_SHADER_BINARY_FORMAT_SPIR_V" );
	#endif
	#ifdef GL_SPIR_V_BINARY
		swigIntConstant( GL_SPIR_V_BINARY, "GL_SPIR_V_BINARY" );
	#endif
	#ifdef GL_PARAMETER_BUFFER
		swigIntConstant( GL_PARAMETER_BUFFER, "GL_PARAMETER_BUFFER" );
	#endif
	#ifdef GL_PARAMETER_BUFFER_BINDING
		swigIntConstant( GL_PARAMETER_BUFFER_BINDING, "GL_PARAMETER_BUFFER_BINDING" );
	#endif
	#ifdef GL_CONTEXT_FLAG_NO_ERROR_BIT
		swigIntConstant( GL_CONTEXT_FLAG_NO_ERROR_BIT, "GL_CONTEXT_FLAG_NO_ERROR_BIT" );
	#endif
	#ifdef GL_VERTICES_SUBMITTED
		swigIntConstant( GL_VERTICES_SUBMITTED, "GL_VERTICES_SUBMITTED" );
	#endif
	#ifdef GL_PRIMITIVES_SUBMITTED
		swigIntConstant( GL_PRIMITIVES_SUBMITTED, "GL_PRIMITIVES_SUBMITTED" );
	#endif
	#ifdef GL_VERTEX_SHADER_INVOCATIONS
		swigIntConstant( GL_VERTEX_SHADER_INVOCATIONS, "GL_VERTEX_SHADER_INVOCATIONS" );
	#endif
	#ifdef GL_TESS_CONTROL_SHADER_PATCHES
		swigIntConstant( GL_TESS_CONTROL_SHADER_PATCHES, "GL_TESS_CONTROL_SHADER_PATCHES" );
	#endif
	#ifdef GL_TESS_EVALUATION_SHADER_INVOCATIONS
		swigIntConstant( GL_TESS_EVALUATION_SHADER_INVOCATIONS, "GL_TESS_EVALUATION_SHADER_INVOCATIONS" );
	#endif
	#ifdef GL_GEOMETRY_SHADER_PRIMITIVES_EMITTED
		swigIntConstant( GL_GEOMETRY_SHADER_PRIMITIVES_EMITTED, "GL_GEOMETRY_SHADER_PRIMITIVES_EMITTED" );
	#endif
	#ifdef GL_FRAGMENT_SHADER_INVOCATIONS
		swigIntConstant( GL_FRAGMENT_SHADER_INVOCATIONS, "GL_FRAGMENT_SHADER_INVOCATIONS" );
	#endif
	#ifdef GL_COMPUTE_SHADER_INVOCATIONS
		swigIntConstant( GL_COMPUTE_SHADER_INVOCATIONS, "GL_COMPUTE_SHADER_INVOCATIONS" );
	#endif
	#ifdef GL_CLIPPING_INPUT_PRIMITIVES
		swigIntConstant( GL_CLIPPING_INPUT_PRIMITIVES, "GL_CLIPPING_INPUT_PRIMITIVES" );
	#endif
	#ifdef GL_CLIPPING_OUTPUT_PRIMITIVES
		swigIntConstant( GL_CLIPPING_OUTPUT_PRIMITIVES, "GL_CLIPPING_OUTPUT_PRIMITIVES" );
	#endif
	#ifdef GL_POLYGON_OFFSET_CLAMP
		swigIntConstant( GL_POLYGON_OFFSET_CLAMP, "GL_POLYGON_OFFSET_CLAMP" );
	#endif
	#ifdef GL_SPIR_V_EXTENSIONS
		swigIntConstant( GL_SPIR_V_EXTENSIONS, "GL_SPIR_V_EXTENSIONS" );
	#endif
	#ifdef GL_NUM_SPIR_V_EXTENSIONS
		swigIntConstant( GL_NUM_SPIR_V_EXTENSIONS, "GL_NUM_SPIR_V_EXTENSIONS" );
	#endif
	#ifdef GL_TEXTURE_MAX_ANISOTROPY
		swigIntConstant( GL_TEXTURE_MAX_ANISOTROPY, "GL_TEXTURE_MAX_ANISOTROPY" );
	#endif
	#ifdef GL_MAX_TEXTURE_MAX_ANISOTROPY
		swigIntConstant( GL_MAX_TEXTURE_MAX_ANISOTROPY, "GL_MAX_TEXTURE_MAX_ANISOTROPY" );
	#endif
	#ifdef GL_TRANSFORM_FEEDBACK_OVERFLOW
		swigIntConstant( GL_TRANSFORM_FEEDBACK_OVERFLOW, "GL_TRANSFORM_FEEDBACK_OVERFLOW" );
	#endif
	#ifdef GL_TRANSFORM_FEEDBACK_STREAM_OVERFLOW
		swigIntConstant( GL_TRANSFORM_FEEDBACK_STREAM_OVERFLOW, "GL_TRANSFORM_FEEDBACK_STREAM_OVERFLOW" );
	#endif
	#ifdef GL_ARB_ES2_compatibility
		swigIntConstant( GL_ARB_ES2_compatibility, "GL_ARB_ES2_compatibility" );
	#endif
	#ifdef GL_ARB_ES3_1_compatibility
		swigIntConstant( GL_ARB_ES3_1_compatibility, "GL_ARB_ES3_1_compatibility" );
	#endif
	#ifdef GL_ARB_ES3_2_compatibility
		swigIntConstant( GL_ARB_ES3_2_compatibility, "GL_ARB_ES3_2_compatibility" );
	#endif
	#ifdef GL_PRIMITIVE_BOUNDING_BOX_ARB
		swigIntConstant( GL_PRIMITIVE_BOUNDING_BOX_ARB, "GL_PRIMITIVE_BOUNDING_BOX_ARB" );
	#endif
	#ifdef GL_MULTISAMPLE_LINE_WIDTH_RANGE_ARB
		swigIntConstant( GL_MULTISAMPLE_LINE_WIDTH_RANGE_ARB, "GL_MULTISAMPLE_LINE_WIDTH_RANGE_ARB" );
	#endif
	#ifdef GL_MULTISAMPLE_LINE_WIDTH_GRANULARITY_ARB
		swigIntConstant( GL_MULTISAMPLE_LINE_WIDTH_GRANULARITY_ARB, "GL_MULTISAMPLE_LINE_WIDTH_GRANULARITY_ARB" );
	#endif
	#ifdef GL_ARB_ES3_compatibility
		swigIntConstant( GL_ARB_ES3_compatibility, "GL_ARB_ES3_compatibility" );
	#endif
	#ifdef GL_ARB_arrays_of_arrays
		swigIntConstant( GL_ARB_arrays_of_arrays, "GL_ARB_arrays_of_arrays" );
	#endif
	#ifdef GL_ARB_base_instance
		swigIntConstant( GL_ARB_base_instance, "GL_ARB_base_instance" );
	#endif
	#ifdef GL_ARB_bindless_texture
		swigIntConstant( GL_ARB_bindless_texture, "GL_ARB_bindless_texture" );
	#endif
	#ifdef GL_UNSIGNED_INT64_ARB
		swigIntConstant( GL_UNSIGNED_INT64_ARB, "GL_UNSIGNED_INT64_ARB" );
	#endif
	#ifdef GL_ARB_blend_func_extended
		swigIntConstant( GL_ARB_blend_func_extended, "GL_ARB_blend_func_extended" );
	#endif
	#ifdef GL_ARB_buffer_storage
		swigIntConstant( GL_ARB_buffer_storage, "GL_ARB_buffer_storage" );
	#endif
	#ifdef GL_ARB_cl_event
		swigIntConstant( GL_ARB_cl_event, "GL_ARB_cl_event" );
	#endif
	#ifdef GL_SYNC_CL_EVENT_ARB
		swigIntConstant( GL_SYNC_CL_EVENT_ARB, "GL_SYNC_CL_EVENT_ARB" );
	#endif
	#ifdef GL_SYNC_CL_EVENT_COMPLETE_ARB
		swigIntConstant( GL_SYNC_CL_EVENT_COMPLETE_ARB, "GL_SYNC_CL_EVENT_COMPLETE_ARB" );
	#endif
	#ifdef GL_ARB_clear_buffer_object
		swigIntConstant( GL_ARB_clear_buffer_object, "GL_ARB_clear_buffer_object" );
	#endif
	#ifdef GL_ARB_clear_texture
		swigIntConstant( GL_ARB_clear_texture, "GL_ARB_clear_texture" );
	#endif
	#ifdef GL_ARB_clip_control
		swigIntConstant( GL_ARB_clip_control, "GL_ARB_clip_control" );
	#endif
	#ifdef GL_ARB_color_buffer_float
		swigIntConstant( GL_ARB_color_buffer_float, "GL_ARB_color_buffer_float" );
	#endif
	#ifdef GL_RGBA_FLOAT_MODE_ARB
		swigIntConstant( GL_RGBA_FLOAT_MODE_ARB, "GL_RGBA_FLOAT_MODE_ARB" );
	#endif
	#ifdef GL_CLAMP_VERTEX_COLOR_ARB
		swigIntConstant( GL_CLAMP_VERTEX_COLOR_ARB, "GL_CLAMP_VERTEX_COLOR_ARB" );
	#endif
	#ifdef GL_CLAMP_FRAGMENT_COLOR_ARB
		swigIntConstant( GL_CLAMP_FRAGMENT_COLOR_ARB, "GL_CLAMP_FRAGMENT_COLOR_ARB" );
	#endif
	#ifdef GL_CLAMP_READ_COLOR_ARB
		swigIntConstant( GL_CLAMP_READ_COLOR_ARB, "GL_CLAMP_READ_COLOR_ARB" );
	#endif
	#ifdef GL_FIXED_ONLY_ARB
		swigIntConstant( GL_FIXED_ONLY_ARB, "GL_FIXED_ONLY_ARB" );
	#endif
	#ifdef GL_ARB_compatibility
		swigIntConstant( GL_ARB_compatibility, "GL_ARB_compatibility" );
	#endif
	#ifdef GL_ARB_compressed_texture_pixel_storage
		swigIntConstant( GL_ARB_compressed_texture_pixel_storage, "GL_ARB_compressed_texture_pixel_storage" );
	#endif
	#ifdef GL_ARB_compute_shader
		swigIntConstant( GL_ARB_compute_shader, "GL_ARB_compute_shader" );
	#endif
	#ifdef GL_ARB_compute_variable_group_size
		swigIntConstant( GL_ARB_compute_variable_group_size, "GL_ARB_compute_variable_group_size" );
	#endif
	#ifdef GL_MAX_COMPUTE_VARIABLE_GROUP_INVOCATIONS_ARB
		swigIntConstant( GL_MAX_COMPUTE_VARIABLE_GROUP_INVOCATIONS_ARB, "GL_MAX_COMPUTE_VARIABLE_GROUP_INVOCATIONS_ARB" );
	#endif
	#ifdef GL_MAX_COMPUTE_FIXED_GROUP_INVOCATIONS_ARB
		swigIntConstant( GL_MAX_COMPUTE_FIXED_GROUP_INVOCATIONS_ARB, "GL_MAX_COMPUTE_FIXED_GROUP_INVOCATIONS_ARB" );
	#endif
	#ifdef GL_MAX_COMPUTE_VARIABLE_GROUP_SIZE_ARB
		swigIntConstant( GL_MAX_COMPUTE_VARIABLE_GROUP_SIZE_ARB, "GL_MAX_COMPUTE_VARIABLE_GROUP_SIZE_ARB" );
	#endif
	#ifdef GL_MAX_COMPUTE_FIXED_GROUP_SIZE_ARB
		swigIntConstant( GL_MAX_COMPUTE_FIXED_GROUP_SIZE_ARB, "GL_MAX_COMPUTE_FIXED_GROUP_SIZE_ARB" );
	#endif
	#ifdef GL_ARB_conditional_render_inverted
		swigIntConstant( GL_ARB_conditional_render_inverted, "GL_ARB_conditional_render_inverted" );
	#endif
	#ifdef GL_ARB_conservative_depth
		swigIntConstant( GL_ARB_conservative_depth, "GL_ARB_conservative_depth" );
	#endif
	#ifdef GL_ARB_copy_buffer
		swigIntConstant( GL_ARB_copy_buffer, "GL_ARB_copy_buffer" );
	#endif
	#ifdef GL_ARB_copy_image
		swigIntConstant( GL_ARB_copy_image, "GL_ARB_copy_image" );
	#endif
	#ifdef GL_ARB_cull_distance
		swigIntConstant( GL_ARB_cull_distance, "GL_ARB_cull_distance" );
	#endif
	#ifdef GL_ARB_debug_output
		swigIntConstant( GL_ARB_debug_output, "GL_ARB_debug_output" );
	#endif
	#ifdef GL_DEBUG_OUTPUT_SYNCHRONOUS_ARB
		swigIntConstant( GL_DEBUG_OUTPUT_SYNCHRONOUS_ARB, "GL_DEBUG_OUTPUT_SYNCHRONOUS_ARB" );
	#endif
	#ifdef GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH_ARB
		swigIntConstant( GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH_ARB, "GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH_ARB" );
	#endif
	#ifdef GL_DEBUG_CALLBACK_FUNCTION_ARB
		swigIntConstant( GL_DEBUG_CALLBACK_FUNCTION_ARB, "GL_DEBUG_CALLBACK_FUNCTION_ARB" );
	#endif
	#ifdef GL_DEBUG_CALLBACK_USER_PARAM_ARB
		swigIntConstant( GL_DEBUG_CALLBACK_USER_PARAM_ARB, "GL_DEBUG_CALLBACK_USER_PARAM_ARB" );
	#endif
	#ifdef GL_DEBUG_SOURCE_API_ARB
		swigIntConstant( GL_DEBUG_SOURCE_API_ARB, "GL_DEBUG_SOURCE_API_ARB" );
	#endif
	#ifdef GL_DEBUG_SOURCE_WINDOW_SYSTEM_ARB
		swigIntConstant( GL_DEBUG_SOURCE_WINDOW_SYSTEM_ARB, "GL_DEBUG_SOURCE_WINDOW_SYSTEM_ARB" );
	#endif
	#ifdef GL_DEBUG_SOURCE_SHADER_COMPILER_ARB
		swigIntConstant( GL_DEBUG_SOURCE_SHADER_COMPILER_ARB, "GL_DEBUG_SOURCE_SHADER_COMPILER_ARB" );
	#endif
	#ifdef GL_DEBUG_SOURCE_THIRD_PARTY_ARB
		swigIntConstant( GL_DEBUG_SOURCE_THIRD_PARTY_ARB, "GL_DEBUG_SOURCE_THIRD_PARTY_ARB" );
	#endif
	#ifdef GL_DEBUG_SOURCE_APPLICATION_ARB
		swigIntConstant( GL_DEBUG_SOURCE_APPLICATION_ARB, "GL_DEBUG_SOURCE_APPLICATION_ARB" );
	#endif
	#ifdef GL_DEBUG_SOURCE_OTHER_ARB
		swigIntConstant( GL_DEBUG_SOURCE_OTHER_ARB, "GL_DEBUG_SOURCE_OTHER_ARB" );
	#endif
	#ifdef GL_DEBUG_TYPE_ERROR_ARB
		swigIntConstant( GL_DEBUG_TYPE_ERROR_ARB, "GL_DEBUG_TYPE_ERROR_ARB" );
	#endif
	#ifdef GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR_ARB
		swigIntConstant( GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR_ARB, "GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR_ARB" );
	#endif
	#ifdef GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR_ARB
		swigIntConstant( GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR_ARB, "GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR_ARB" );
	#endif
	#ifdef GL_DEBUG_TYPE_PORTABILITY_ARB
		swigIntConstant( GL_DEBUG_TYPE_PORTABILITY_ARB, "GL_DEBUG_TYPE_PORTABILITY_ARB" );
	#endif
	#ifdef GL_DEBUG_TYPE_PERFORMANCE_ARB
		swigIntConstant( GL_DEBUG_TYPE_PERFORMANCE_ARB, "GL_DEBUG_TYPE_PERFORMANCE_ARB" );
	#endif
	#ifdef GL_DEBUG_TYPE_OTHER_ARB
		swigIntConstant( GL_DEBUG_TYPE_OTHER_ARB, "GL_DEBUG_TYPE_OTHER_ARB" );
	#endif
	#ifdef GL_MAX_DEBUG_MESSAGE_LENGTH_ARB
		swigIntConstant( GL_MAX_DEBUG_MESSAGE_LENGTH_ARB, "GL_MAX_DEBUG_MESSAGE_LENGTH_ARB" );
	#endif
	#ifdef GL_MAX_DEBUG_LOGGED_MESSAGES_ARB
		swigIntConstant( GL_MAX_DEBUG_LOGGED_MESSAGES_ARB, "GL_MAX_DEBUG_LOGGED_MESSAGES_ARB" );
	#endif
	#ifdef GL_DEBUG_LOGGED_MESSAGES_ARB
		swigIntConstant( GL_DEBUG_LOGGED_MESSAGES_ARB, "GL_DEBUG_LOGGED_MESSAGES_ARB" );
	#endif
	#ifdef GL_DEBUG_SEVERITY_HIGH_ARB
		swigIntConstant( GL_DEBUG_SEVERITY_HIGH_ARB, "GL_DEBUG_SEVERITY_HIGH_ARB" );
	#endif
	#ifdef GL_DEBUG_SEVERITY_MEDIUM_ARB
		swigIntConstant( GL_DEBUG_SEVERITY_MEDIUM_ARB, "GL_DEBUG_SEVERITY_MEDIUM_ARB" );
	#endif
	#ifdef GL_DEBUG_SEVERITY_LOW_ARB
		swigIntConstant( GL_DEBUG_SEVERITY_LOW_ARB, "GL_DEBUG_SEVERITY_LOW_ARB" );
	#endif
	#ifdef GL_ARB_depth_buffer_float
		swigIntConstant( GL_ARB_depth_buffer_float, "GL_ARB_depth_buffer_float" );
	#endif
	#ifdef GL_ARB_depth_clamp
		swigIntConstant( GL_ARB_depth_clamp, "GL_ARB_depth_clamp" );
	#endif
	#ifdef GL_ARB_depth_texture
		swigIntConstant( GL_ARB_depth_texture, "GL_ARB_depth_texture" );
	#endif
	#ifdef GL_DEPTH_COMPONENT16_ARB
		swigIntConstant( GL_DEPTH_COMPONENT16_ARB, "GL_DEPTH_COMPONENT16_ARB" );
	#endif
	#ifdef GL_DEPTH_COMPONENT24_ARB
		swigIntConstant( GL_DEPTH_COMPONENT24_ARB, "GL_DEPTH_COMPONENT24_ARB" );
	#endif
	#ifdef GL_DEPTH_COMPONENT32_ARB
		swigIntConstant( GL_DEPTH_COMPONENT32_ARB, "GL_DEPTH_COMPONENT32_ARB" );
	#endif
	#ifdef GL_TEXTURE_DEPTH_SIZE_ARB
		swigIntConstant( GL_TEXTURE_DEPTH_SIZE_ARB, "GL_TEXTURE_DEPTH_SIZE_ARB" );
	#endif
	#ifdef GL_DEPTH_TEXTURE_MODE_ARB
		swigIntConstant( GL_DEPTH_TEXTURE_MODE_ARB, "GL_DEPTH_TEXTURE_MODE_ARB" );
	#endif
	#ifdef GL_ARB_derivative_control
		swigIntConstant( GL_ARB_derivative_control, "GL_ARB_derivative_control" );
	#endif
	#ifdef GL_ARB_direct_state_access
		swigIntConstant( GL_ARB_direct_state_access, "GL_ARB_direct_state_access" );
	#endif
	#ifdef GL_ARB_draw_buffers
		swigIntConstant( GL_ARB_draw_buffers, "GL_ARB_draw_buffers" );
	#endif
	#ifdef GL_MAX_DRAW_BUFFERS_ARB
		swigIntConstant( GL_MAX_DRAW_BUFFERS_ARB, "GL_MAX_DRAW_BUFFERS_ARB" );
	#endif
	#ifdef GL_DRAW_BUFFER0_ARB
		swigIntConstant( GL_DRAW_BUFFER0_ARB, "GL_DRAW_BUFFER0_ARB" );
	#endif
	#ifdef GL_DRAW_BUFFER1_ARB
		swigIntConstant( GL_DRAW_BUFFER1_ARB, "GL_DRAW_BUFFER1_ARB" );
	#endif
	#ifdef GL_DRAW_BUFFER2_ARB
		swigIntConstant( GL_DRAW_BUFFER2_ARB, "GL_DRAW_BUFFER2_ARB" );
	#endif
	#ifdef GL_DRAW_BUFFER3_ARB
		swigIntConstant( GL_DRAW_BUFFER3_ARB, "GL_DRAW_BUFFER3_ARB" );
	#endif
	#ifdef GL_DRAW_BUFFER4_ARB
		swigIntConstant( GL_DRAW_BUFFER4_ARB, "GL_DRAW_BUFFER4_ARB" );
	#endif
	#ifdef GL_DRAW_BUFFER5_ARB
		swigIntConstant( GL_DRAW_BUFFER5_ARB, "GL_DRAW_BUFFER5_ARB" );
	#endif
	#ifdef GL_DRAW_BUFFER6_ARB
		swigIntConstant( GL_DRAW_BUFFER6_ARB, "GL_DRAW_BUFFER6_ARB" );
	#endif
	#ifdef GL_DRAW_BUFFER7_ARB
		swigIntConstant( GL_DRAW_BUFFER7_ARB, "GL_DRAW_BUFFER7_ARB" );
	#endif
	#ifdef GL_DRAW_BUFFER8_ARB
		swigIntConstant( GL_DRAW_BUFFER8_ARB, "GL_DRAW_BUFFER8_ARB" );
	#endif
	#ifdef GL_DRAW_BUFFER9_ARB
		swigIntConstant( GL_DRAW_BUFFER9_ARB, "GL_DRAW_BUFFER9_ARB" );
	#endif
	#ifdef GL_DRAW_BUFFER10_ARB
		swigIntConstant( GL_DRAW_BUFFER10_ARB, "GL_DRAW_BUFFER10_ARB" );
	#endif
	#ifdef GL_DRAW_BUFFER11_ARB
		swigIntConstant( GL_DRAW_BUFFER11_ARB, "GL_DRAW_BUFFER11_ARB" );
	#endif
	#ifdef GL_DRAW_BUFFER12_ARB
		swigIntConstant( GL_DRAW_BUFFER12_ARB, "GL_DRAW_BUFFER12_ARB" );
	#endif
	#ifdef GL_DRAW_BUFFER13_ARB
		swigIntConstant( GL_DRAW_BUFFER13_ARB, "GL_DRAW_BUFFER13_ARB" );
	#endif
	#ifdef GL_DRAW_BUFFER14_ARB
		swigIntConstant( GL_DRAW_BUFFER14_ARB, "GL_DRAW_BUFFER14_ARB" );
	#endif
	#ifdef GL_DRAW_BUFFER15_ARB
		swigIntConstant( GL_DRAW_BUFFER15_ARB, "GL_DRAW_BUFFER15_ARB" );
	#endif
	#ifdef GL_ARB_draw_buffers_blend
		swigIntConstant( GL_ARB_draw_buffers_blend, "GL_ARB_draw_buffers_blend" );
	#endif
	#ifdef GL_ARB_draw_elements_base_vertex
		swigIntConstant( GL_ARB_draw_elements_base_vertex, "GL_ARB_draw_elements_base_vertex" );
	#endif
	#ifdef GL_ARB_draw_indirect
		swigIntConstant( GL_ARB_draw_indirect, "GL_ARB_draw_indirect" );
	#endif
	#ifdef GL_ARB_draw_instanced
		swigIntConstant( GL_ARB_draw_instanced, "GL_ARB_draw_instanced" );
	#endif
	#ifdef GL_ARB_enhanced_layouts
		swigIntConstant( GL_ARB_enhanced_layouts, "GL_ARB_enhanced_layouts" );
	#endif
	#ifdef GL_ARB_explicit_attrib_location
		swigIntConstant( GL_ARB_explicit_attrib_location, "GL_ARB_explicit_attrib_location" );
	#endif
	#ifdef GL_ARB_explicit_uniform_location
		swigIntConstant( GL_ARB_explicit_uniform_location, "GL_ARB_explicit_uniform_location" );
	#endif
	#ifdef GL_ARB_fragment_coord_conventions
		swigIntConstant( GL_ARB_fragment_coord_conventions, "GL_ARB_fragment_coord_conventions" );
	#endif
	#ifdef GL_ARB_fragment_layer_viewport
		swigIntConstant( GL_ARB_fragment_layer_viewport, "GL_ARB_fragment_layer_viewport" );
	#endif
	#ifdef GL_ARB_fragment_program
		swigIntConstant( GL_ARB_fragment_program, "GL_ARB_fragment_program" );
	#endif
	#ifdef GL_FRAGMENT_PROGRAM_ARB
		swigIntConstant( GL_FRAGMENT_PROGRAM_ARB, "GL_FRAGMENT_PROGRAM_ARB" );
	#endif
	#ifdef GL_PROGRAM_FORMAT_ASCII_ARB
		swigIntConstant( GL_PROGRAM_FORMAT_ASCII_ARB, "GL_PROGRAM_FORMAT_ASCII_ARB" );
	#endif
	#ifdef GL_PROGRAM_LENGTH_ARB
		swigIntConstant( GL_PROGRAM_LENGTH_ARB, "GL_PROGRAM_LENGTH_ARB" );
	#endif
	#ifdef GL_PROGRAM_FORMAT_ARB
		swigIntConstant( GL_PROGRAM_FORMAT_ARB, "GL_PROGRAM_FORMAT_ARB" );
	#endif
	#ifdef GL_PROGRAM_BINDING_ARB
		swigIntConstant( GL_PROGRAM_BINDING_ARB, "GL_PROGRAM_BINDING_ARB" );
	#endif
	#ifdef GL_PROGRAM_INSTRUCTIONS_ARB
		swigIntConstant( GL_PROGRAM_INSTRUCTIONS_ARB, "GL_PROGRAM_INSTRUCTIONS_ARB" );
	#endif
	#ifdef GL_MAX_PROGRAM_INSTRUCTIONS_ARB
		swigIntConstant( GL_MAX_PROGRAM_INSTRUCTIONS_ARB, "GL_MAX_PROGRAM_INSTRUCTIONS_ARB" );
	#endif
	#ifdef GL_PROGRAM_NATIVE_INSTRUCTIONS_ARB
		swigIntConstant( GL_PROGRAM_NATIVE_INSTRUCTIONS_ARB, "GL_PROGRAM_NATIVE_INSTRUCTIONS_ARB" );
	#endif
	#ifdef GL_MAX_PROGRAM_NATIVE_INSTRUCTIONS_ARB
		swigIntConstant( GL_MAX_PROGRAM_NATIVE_INSTRUCTIONS_ARB, "GL_MAX_PROGRAM_NATIVE_INSTRUCTIONS_ARB" );
	#endif
	#ifdef GL_PROGRAM_TEMPORARIES_ARB
		swigIntConstant( GL_PROGRAM_TEMPORARIES_ARB, "GL_PROGRAM_TEMPORARIES_ARB" );
	#endif
	#ifdef GL_MAX_PROGRAM_TEMPORARIES_ARB
		swigIntConstant( GL_MAX_PROGRAM_TEMPORARIES_ARB, "GL_MAX_PROGRAM_TEMPORARIES_ARB" );
	#endif
	#ifdef GL_PROGRAM_NATIVE_TEMPORARIES_ARB
		swigIntConstant( GL_PROGRAM_NATIVE_TEMPORARIES_ARB, "GL_PROGRAM_NATIVE_TEMPORARIES_ARB" );
	#endif
	#ifdef GL_MAX_PROGRAM_NATIVE_TEMPORARIES_ARB
		swigIntConstant( GL_MAX_PROGRAM_NATIVE_TEMPORARIES_ARB, "GL_MAX_PROGRAM_NATIVE_TEMPORARIES_ARB" );
	#endif
	#ifdef GL_PROGRAM_PARAMETERS_ARB
		swigIntConstant( GL_PROGRAM_PARAMETERS_ARB, "GL_PROGRAM_PARAMETERS_ARB" );
	#endif
	#ifdef GL_MAX_PROGRAM_PARAMETERS_ARB
		swigIntConstant( GL_MAX_PROGRAM_PARAMETERS_ARB, "GL_MAX_PROGRAM_PARAMETERS_ARB" );
	#endif
	#ifdef GL_PROGRAM_NATIVE_PARAMETERS_ARB
		swigIntConstant( GL_PROGRAM_NATIVE_PARAMETERS_ARB, "GL_PROGRAM_NATIVE_PARAMETERS_ARB" );
	#endif
	#ifdef GL_MAX_PROGRAM_NATIVE_PARAMETERS_ARB
		swigIntConstant( GL_MAX_PROGRAM_NATIVE_PARAMETERS_ARB, "GL_MAX_PROGRAM_NATIVE_PARAMETERS_ARB" );
	#endif
	#ifdef GL_PROGRAM_ATTRIBS_ARB
		swigIntConstant( GL_PROGRAM_ATTRIBS_ARB, "GL_PROGRAM_ATTRIBS_ARB" );
	#endif
	#ifdef GL_MAX_PROGRAM_ATTRIBS_ARB
		swigIntConstant( GL_MAX_PROGRAM_ATTRIBS_ARB, "GL_MAX_PROGRAM_ATTRIBS_ARB" );
	#endif
	#ifdef GL_PROGRAM_NATIVE_ATTRIBS_ARB
		swigIntConstant( GL_PROGRAM_NATIVE_ATTRIBS_ARB, "GL_PROGRAM_NATIVE_ATTRIBS_ARB" );
	#endif
	#ifdef GL_MAX_PROGRAM_NATIVE_ATTRIBS_ARB
		swigIntConstant( GL_MAX_PROGRAM_NATIVE_ATTRIBS_ARB, "GL_MAX_PROGRAM_NATIVE_ATTRIBS_ARB" );
	#endif
	#ifdef GL_MAX_PROGRAM_LOCAL_PARAMETERS_ARB
		swigIntConstant( GL_MAX_PROGRAM_LOCAL_PARAMETERS_ARB, "GL_MAX_PROGRAM_LOCAL_PARAMETERS_ARB" );
	#endif
	#ifdef GL_MAX_PROGRAM_ENV_PARAMETERS_ARB
		swigIntConstant( GL_MAX_PROGRAM_ENV_PARAMETERS_ARB, "GL_MAX_PROGRAM_ENV_PARAMETERS_ARB" );
	#endif
	#ifdef GL_PROGRAM_UNDER_NATIVE_LIMITS_ARB
		swigIntConstant( GL_PROGRAM_UNDER_NATIVE_LIMITS_ARB, "GL_PROGRAM_UNDER_NATIVE_LIMITS_ARB" );
	#endif
	#ifdef GL_PROGRAM_ALU_INSTRUCTIONS_ARB
		swigIntConstant( GL_PROGRAM_ALU_INSTRUCTIONS_ARB, "GL_PROGRAM_ALU_INSTRUCTIONS_ARB" );
	#endif
	#ifdef GL_PROGRAM_TEX_INSTRUCTIONS_ARB
		swigIntConstant( GL_PROGRAM_TEX_INSTRUCTIONS_ARB, "GL_PROGRAM_TEX_INSTRUCTIONS_ARB" );
	#endif
	#ifdef GL_PROGRAM_TEX_INDIRECTIONS_ARB
		swigIntConstant( GL_PROGRAM_TEX_INDIRECTIONS_ARB, "GL_PROGRAM_TEX_INDIRECTIONS_ARB" );
	#endif
	#ifdef GL_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB
		swigIntConstant( GL_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB, "GL_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB" );
	#endif
	#ifdef GL_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB
		swigIntConstant( GL_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB, "GL_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB" );
	#endif
	#ifdef GL_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB
		swigIntConstant( GL_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB, "GL_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB" );
	#endif
	#ifdef GL_MAX_PROGRAM_ALU_INSTRUCTIONS_ARB
		swigIntConstant( GL_MAX_PROGRAM_ALU_INSTRUCTIONS_ARB, "GL_MAX_PROGRAM_ALU_INSTRUCTIONS_ARB" );
	#endif
	#ifdef GL_MAX_PROGRAM_TEX_INSTRUCTIONS_ARB
		swigIntConstant( GL_MAX_PROGRAM_TEX_INSTRUCTIONS_ARB, "GL_MAX_PROGRAM_TEX_INSTRUCTIONS_ARB" );
	#endif
	#ifdef GL_MAX_PROGRAM_TEX_INDIRECTIONS_ARB
		swigIntConstant( GL_MAX_PROGRAM_TEX_INDIRECTIONS_ARB, "GL_MAX_PROGRAM_TEX_INDIRECTIONS_ARB" );
	#endif
	#ifdef GL_MAX_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB
		swigIntConstant( GL_MAX_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB, "GL_MAX_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB" );
	#endif
	#ifdef GL_MAX_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB
		swigIntConstant( GL_MAX_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB, "GL_MAX_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB" );
	#endif
	#ifdef GL_MAX_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB
		swigIntConstant( GL_MAX_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB, "GL_MAX_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB" );
	#endif
	#ifdef GL_PROGRAM_STRING_ARB
		swigIntConstant( GL_PROGRAM_STRING_ARB, "GL_PROGRAM_STRING_ARB" );
	#endif
	#ifdef GL_PROGRAM_ERROR_POSITION_ARB
		swigIntConstant( GL_PROGRAM_ERROR_POSITION_ARB, "GL_PROGRAM_ERROR_POSITION_ARB" );
	#endif
	#ifdef GL_CURRENT_MATRIX_ARB
		swigIntConstant( GL_CURRENT_MATRIX_ARB, "GL_CURRENT_MATRIX_ARB" );
	#endif
	#ifdef GL_TRANSPOSE_CURRENT_MATRIX_ARB
		swigIntConstant( GL_TRANSPOSE_CURRENT_MATRIX_ARB, "GL_TRANSPOSE_CURRENT_MATRIX_ARB" );
	#endif
	#ifdef GL_CURRENT_MATRIX_STACK_DEPTH_ARB
		swigIntConstant( GL_CURRENT_MATRIX_STACK_DEPTH_ARB, "GL_CURRENT_MATRIX_STACK_DEPTH_ARB" );
	#endif
	#ifdef GL_MAX_PROGRAM_MATRICES_ARB
		swigIntConstant( GL_MAX_PROGRAM_MATRICES_ARB, "GL_MAX_PROGRAM_MATRICES_ARB" );
	#endif
	#ifdef GL_MAX_PROGRAM_MATRIX_STACK_DEPTH_ARB
		swigIntConstant( GL_MAX_PROGRAM_MATRIX_STACK_DEPTH_ARB, "GL_MAX_PROGRAM_MATRIX_STACK_DEPTH_ARB" );
	#endif
	#ifdef GL_MAX_TEXTURE_COORDS_ARB
		swigIntConstant( GL_MAX_TEXTURE_COORDS_ARB, "GL_MAX_TEXTURE_COORDS_ARB" );
	#endif
	#ifdef GL_MAX_TEXTURE_IMAGE_UNITS_ARB
		swigIntConstant( GL_MAX_TEXTURE_IMAGE_UNITS_ARB, "GL_MAX_TEXTURE_IMAGE_UNITS_ARB" );
	#endif
	#ifdef GL_PROGRAM_ERROR_STRING_ARB
		swigIntConstant( GL_PROGRAM_ERROR_STRING_ARB, "GL_PROGRAM_ERROR_STRING_ARB" );
	#endif
	#ifdef GL_MATRIX0_ARB
		swigIntConstant( GL_MATRIX0_ARB, "GL_MATRIX0_ARB" );
	#endif
	#ifdef GL_MATRIX1_ARB
		swigIntConstant( GL_MATRIX1_ARB, "GL_MATRIX1_ARB" );
	#endif
	#ifdef GL_MATRIX2_ARB
		swigIntConstant( GL_MATRIX2_ARB, "GL_MATRIX2_ARB" );
	#endif
	#ifdef GL_MATRIX3_ARB
		swigIntConstant( GL_MATRIX3_ARB, "GL_MATRIX3_ARB" );
	#endif
	#ifdef GL_MATRIX4_ARB
		swigIntConstant( GL_MATRIX4_ARB, "GL_MATRIX4_ARB" );
	#endif
	#ifdef GL_MATRIX5_ARB
		swigIntConstant( GL_MATRIX5_ARB, "GL_MATRIX5_ARB" );
	#endif
	#ifdef GL_MATRIX6_ARB
		swigIntConstant( GL_MATRIX6_ARB, "GL_MATRIX6_ARB" );
	#endif
	#ifdef GL_MATRIX7_ARB
		swigIntConstant( GL_MATRIX7_ARB, "GL_MATRIX7_ARB" );
	#endif
	#ifdef GL_MATRIX8_ARB
		swigIntConstant( GL_MATRIX8_ARB, "GL_MATRIX8_ARB" );
	#endif
	#ifdef GL_MATRIX9_ARB
		swigIntConstant( GL_MATRIX9_ARB, "GL_MATRIX9_ARB" );
	#endif
	#ifdef GL_MATRIX10_ARB
		swigIntConstant( GL_MATRIX10_ARB, "GL_MATRIX10_ARB" );
	#endif
	#ifdef GL_MATRIX11_ARB
		swigIntConstant( GL_MATRIX11_ARB, "GL_MATRIX11_ARB" );
	#endif
	#ifdef GL_MATRIX12_ARB
		swigIntConstant( GL_MATRIX12_ARB, "GL_MATRIX12_ARB" );
	#endif
	#ifdef GL_MATRIX13_ARB
		swigIntConstant( GL_MATRIX13_ARB, "GL_MATRIX13_ARB" );
	#endif
	#ifdef GL_MATRIX14_ARB
		swigIntConstant( GL_MATRIX14_ARB, "GL_MATRIX14_ARB" );
	#endif
	#ifdef GL_MATRIX15_ARB
		swigIntConstant( GL_MATRIX15_ARB, "GL_MATRIX15_ARB" );
	#endif
	#ifdef GL_MATRIX16_ARB
		swigIntConstant( GL_MATRIX16_ARB, "GL_MATRIX16_ARB" );
	#endif
	#ifdef GL_MATRIX17_ARB
		swigIntConstant( GL_MATRIX17_ARB, "GL_MATRIX17_ARB" );
	#endif
	#ifdef GL_MATRIX18_ARB
		swigIntConstant( GL_MATRIX18_ARB, "GL_MATRIX18_ARB" );
	#endif
	#ifdef GL_MATRIX19_ARB
		swigIntConstant( GL_MATRIX19_ARB, "GL_MATRIX19_ARB" );
	#endif
	#ifdef GL_MATRIX20_ARB
		swigIntConstant( GL_MATRIX20_ARB, "GL_MATRIX20_ARB" );
	#endif
	#ifdef GL_MATRIX21_ARB
		swigIntConstant( GL_MATRIX21_ARB, "GL_MATRIX21_ARB" );
	#endif
	#ifdef GL_MATRIX22_ARB
		swigIntConstant( GL_MATRIX22_ARB, "GL_MATRIX22_ARB" );
	#endif
	#ifdef GL_MATRIX23_ARB
		swigIntConstant( GL_MATRIX23_ARB, "GL_MATRIX23_ARB" );
	#endif
	#ifdef GL_MATRIX24_ARB
		swigIntConstant( GL_MATRIX24_ARB, "GL_MATRIX24_ARB" );
	#endif
	#ifdef GL_MATRIX25_ARB
		swigIntConstant( GL_MATRIX25_ARB, "GL_MATRIX25_ARB" );
	#endif
	#ifdef GL_MATRIX26_ARB
		swigIntConstant( GL_MATRIX26_ARB, "GL_MATRIX26_ARB" );
	#endif
	#ifdef GL_MATRIX27_ARB
		swigIntConstant( GL_MATRIX27_ARB, "GL_MATRIX27_ARB" );
	#endif
	#ifdef GL_MATRIX28_ARB
		swigIntConstant( GL_MATRIX28_ARB, "GL_MATRIX28_ARB" );
	#endif
	#ifdef GL_MATRIX29_ARB
		swigIntConstant( GL_MATRIX29_ARB, "GL_MATRIX29_ARB" );
	#endif
	#ifdef GL_MATRIX30_ARB
		swigIntConstant( GL_MATRIX30_ARB, "GL_MATRIX30_ARB" );
	#endif
	#ifdef GL_MATRIX31_ARB
		swigIntConstant( GL_MATRIX31_ARB, "GL_MATRIX31_ARB" );
	#endif
	#ifdef GL_ARB_fragment_program_shadow
		swigIntConstant( GL_ARB_fragment_program_shadow, "GL_ARB_fragment_program_shadow" );
	#endif
	#ifdef GL_ARB_fragment_shader
		swigIntConstant( GL_ARB_fragment_shader, "GL_ARB_fragment_shader" );
	#endif
	#ifdef GL_FRAGMENT_SHADER_ARB
		swigIntConstant( GL_FRAGMENT_SHADER_ARB, "GL_FRAGMENT_SHADER_ARB" );
	#endif
	#ifdef GL_MAX_FRAGMENT_UNIFORM_COMPONENTS_ARB
		swigIntConstant( GL_MAX_FRAGMENT_UNIFORM_COMPONENTS_ARB, "GL_MAX_FRAGMENT_UNIFORM_COMPONENTS_ARB" );
	#endif
	#ifdef GL_FRAGMENT_SHADER_DERIVATIVE_HINT_ARB
		swigIntConstant( GL_FRAGMENT_SHADER_DERIVATIVE_HINT_ARB, "GL_FRAGMENT_SHADER_DERIVATIVE_HINT_ARB" );
	#endif
	#ifdef GL_ARB_fragment_shader_interlock
		swigIntConstant( GL_ARB_fragment_shader_interlock, "GL_ARB_fragment_shader_interlock" );
	#endif
	#ifdef GL_ARB_framebuffer_no_attachments
		swigIntConstant( GL_ARB_framebuffer_no_attachments, "GL_ARB_framebuffer_no_attachments" );
	#endif
	#ifdef GL_ARB_framebuffer_object
		swigIntConstant( GL_ARB_framebuffer_object, "GL_ARB_framebuffer_object" );
	#endif
	#ifdef GL_ARB_framebuffer_sRGB
		swigIntConstant( GL_ARB_framebuffer_sRGB, "GL_ARB_framebuffer_sRGB" );
	#endif
	#ifdef GL_ARB_geometry_shader4
		swigIntConstant( GL_ARB_geometry_shader4, "GL_ARB_geometry_shader4" );
	#endif
	#ifdef GL_LINES_ADJACENCY_ARB
		swigIntConstant( GL_LINES_ADJACENCY_ARB, "GL_LINES_ADJACENCY_ARB" );
	#endif
	#ifdef GL_LINE_STRIP_ADJACENCY_ARB
		swigIntConstant( GL_LINE_STRIP_ADJACENCY_ARB, "GL_LINE_STRIP_ADJACENCY_ARB" );
	#endif
	#ifdef GL_TRIANGLES_ADJACENCY_ARB
		swigIntConstant( GL_TRIANGLES_ADJACENCY_ARB, "GL_TRIANGLES_ADJACENCY_ARB" );
	#endif
	#ifdef GL_TRIANGLE_STRIP_ADJACENCY_ARB
		swigIntConstant( GL_TRIANGLE_STRIP_ADJACENCY_ARB, "GL_TRIANGLE_STRIP_ADJACENCY_ARB" );
	#endif
	#ifdef GL_PROGRAM_POINT_SIZE_ARB
		swigIntConstant( GL_PROGRAM_POINT_SIZE_ARB, "GL_PROGRAM_POINT_SIZE_ARB" );
	#endif
	#ifdef GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS_ARB
		swigIntConstant( GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS_ARB, "GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS_ARB" );
	#endif
	#ifdef GL_FRAMEBUFFER_ATTACHMENT_LAYERED_ARB
		swigIntConstant( GL_FRAMEBUFFER_ATTACHMENT_LAYERED_ARB, "GL_FRAMEBUFFER_ATTACHMENT_LAYERED_ARB" );
	#endif
	#ifdef GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS_ARB
		swigIntConstant( GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS_ARB, "GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS_ARB" );
	#endif
	#ifdef GL_FRAMEBUFFER_INCOMPLETE_LAYER_COUNT_ARB
		swigIntConstant( GL_FRAMEBUFFER_INCOMPLETE_LAYER_COUNT_ARB, "GL_FRAMEBUFFER_INCOMPLETE_LAYER_COUNT_ARB" );
	#endif
	#ifdef GL_GEOMETRY_SHADER_ARB
		swigIntConstant( GL_GEOMETRY_SHADER_ARB, "GL_GEOMETRY_SHADER_ARB" );
	#endif
	#ifdef GL_GEOMETRY_VERTICES_OUT_ARB
		swigIntConstant( GL_GEOMETRY_VERTICES_OUT_ARB, "GL_GEOMETRY_VERTICES_OUT_ARB" );
	#endif
	#ifdef GL_GEOMETRY_INPUT_TYPE_ARB
		swigIntConstant( GL_GEOMETRY_INPUT_TYPE_ARB, "GL_GEOMETRY_INPUT_TYPE_ARB" );
	#endif
	#ifdef GL_GEOMETRY_OUTPUT_TYPE_ARB
		swigIntConstant( GL_GEOMETRY_OUTPUT_TYPE_ARB, "GL_GEOMETRY_OUTPUT_TYPE_ARB" );
	#endif
	#ifdef GL_MAX_GEOMETRY_VARYING_COMPONENTS_ARB
		swigIntConstant( GL_MAX_GEOMETRY_VARYING_COMPONENTS_ARB, "GL_MAX_GEOMETRY_VARYING_COMPONENTS_ARB" );
	#endif
	#ifdef GL_MAX_VERTEX_VARYING_COMPONENTS_ARB
		swigIntConstant( GL_MAX_VERTEX_VARYING_COMPONENTS_ARB, "GL_MAX_VERTEX_VARYING_COMPONENTS_ARB" );
	#endif
	#ifdef GL_MAX_GEOMETRY_UNIFORM_COMPONENTS_ARB
		swigIntConstant( GL_MAX_GEOMETRY_UNIFORM_COMPONENTS_ARB, "GL_MAX_GEOMETRY_UNIFORM_COMPONENTS_ARB" );
	#endif
	#ifdef GL_MAX_GEOMETRY_OUTPUT_VERTICES_ARB
		swigIntConstant( GL_MAX_GEOMETRY_OUTPUT_VERTICES_ARB, "GL_MAX_GEOMETRY_OUTPUT_VERTICES_ARB" );
	#endif
	#ifdef GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS_ARB
		swigIntConstant( GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS_ARB, "GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS_ARB" );
	#endif
	#ifdef GL_ARB_get_program_binary
		swigIntConstant( GL_ARB_get_program_binary, "GL_ARB_get_program_binary" );
	#endif
	#ifdef GL_ARB_get_texture_sub_image
		swigIntConstant( GL_ARB_get_texture_sub_image, "GL_ARB_get_texture_sub_image" );
	#endif
	#ifdef GL_ARB_gl_spirv
		swigIntConstant( GL_ARB_gl_spirv, "GL_ARB_gl_spirv" );
	#endif
	#ifdef GL_SHADER_BINARY_FORMAT_SPIR_V_ARB
		swigIntConstant( GL_SHADER_BINARY_FORMAT_SPIR_V_ARB, "GL_SHADER_BINARY_FORMAT_SPIR_V_ARB" );
	#endif
	#ifdef GL_SPIR_V_BINARY_ARB
		swigIntConstant( GL_SPIR_V_BINARY_ARB, "GL_SPIR_V_BINARY_ARB" );
	#endif
	#ifdef GL_ARB_gpu_shader5
		swigIntConstant( GL_ARB_gpu_shader5, "GL_ARB_gpu_shader5" );
	#endif
	#ifdef GL_ARB_gpu_shader_fp64
		swigIntConstant( GL_ARB_gpu_shader_fp64, "GL_ARB_gpu_shader_fp64" );
	#endif
	#ifdef GL_ARB_gpu_shader_int64
		swigIntConstant( GL_ARB_gpu_shader_int64, "GL_ARB_gpu_shader_int64" );
	#endif
	#ifdef GL_INT64_ARB
		swigIntConstant( GL_INT64_ARB, "GL_INT64_ARB" );
	#endif
	#ifdef GL_INT64_VEC2_ARB
		swigIntConstant( GL_INT64_VEC2_ARB, "GL_INT64_VEC2_ARB" );
	#endif
	#ifdef GL_INT64_VEC3_ARB
		swigIntConstant( GL_INT64_VEC3_ARB, "GL_INT64_VEC3_ARB" );
	#endif
	#ifdef GL_INT64_VEC4_ARB
		swigIntConstant( GL_INT64_VEC4_ARB, "GL_INT64_VEC4_ARB" );
	#endif
	#ifdef GL_UNSIGNED_INT64_VEC2_ARB
		swigIntConstant( GL_UNSIGNED_INT64_VEC2_ARB, "GL_UNSIGNED_INT64_VEC2_ARB" );
	#endif
	#ifdef GL_UNSIGNED_INT64_VEC3_ARB
		swigIntConstant( GL_UNSIGNED_INT64_VEC3_ARB, "GL_UNSIGNED_INT64_VEC3_ARB" );
	#endif
	#ifdef GL_UNSIGNED_INT64_VEC4_ARB
		swigIntConstant( GL_UNSIGNED_INT64_VEC4_ARB, "GL_UNSIGNED_INT64_VEC4_ARB" );
	#endif
	#ifdef GL_ARB_half_float_pixel
		swigIntConstant( GL_ARB_half_float_pixel, "GL_ARB_half_float_pixel" );
	#endif
	#ifdef GL_HALF_FLOAT_ARB
		swigIntConstant( GL_HALF_FLOAT_ARB, "GL_HALF_FLOAT_ARB" );
	#endif
	#ifdef GL_ARB_half_float_vertex
		swigIntConstant( GL_ARB_half_float_vertex, "GL_ARB_half_float_vertex" );
	#endif
	#ifdef GL_ARB_indirect_parameters
		swigIntConstant( GL_ARB_indirect_parameters, "GL_ARB_indirect_parameters" );
	#endif
	#ifdef GL_PARAMETER_BUFFER_ARB
		swigIntConstant( GL_PARAMETER_BUFFER_ARB, "GL_PARAMETER_BUFFER_ARB" );
	#endif
	#ifdef GL_PARAMETER_BUFFER_BINDING_ARB
		swigIntConstant( GL_PARAMETER_BUFFER_BINDING_ARB, "GL_PARAMETER_BUFFER_BINDING_ARB" );
	#endif
	#ifdef GL_ARB_instanced_arrays
		swigIntConstant( GL_ARB_instanced_arrays, "GL_ARB_instanced_arrays" );
	#endif
	#ifdef GL_VERTEX_ATTRIB_ARRAY_DIVISOR_ARB
		swigIntConstant( GL_VERTEX_ATTRIB_ARRAY_DIVISOR_ARB, "GL_VERTEX_ATTRIB_ARRAY_DIVISOR_ARB" );
	#endif
	#ifdef GL_ARB_internalformat_query
		swigIntConstant( GL_ARB_internalformat_query, "GL_ARB_internalformat_query" );
	#endif
	#ifdef GL_ARB_internalformat_query2
		swigIntConstant( GL_ARB_internalformat_query2, "GL_ARB_internalformat_query2" );
	#endif
	#ifdef GL_SRGB_DECODE_ARB
		swigIntConstant( GL_SRGB_DECODE_ARB, "GL_SRGB_DECODE_ARB" );
	#endif
	#ifdef GL_VIEW_CLASS_EAC_R11
		swigIntConstant( GL_VIEW_CLASS_EAC_R11, "GL_VIEW_CLASS_EAC_R11" );
	#endif
	#ifdef GL_VIEW_CLASS_EAC_RG11
		swigIntConstant( GL_VIEW_CLASS_EAC_RG11, "GL_VIEW_CLASS_EAC_RG11" );
	#endif
	#ifdef GL_VIEW_CLASS_ETC2_RGB
		swigIntConstant( GL_VIEW_CLASS_ETC2_RGB, "GL_VIEW_CLASS_ETC2_RGB" );
	#endif
	#ifdef GL_VIEW_CLASS_ETC2_RGBA
		swigIntConstant( GL_VIEW_CLASS_ETC2_RGBA, "GL_VIEW_CLASS_ETC2_RGBA" );
	#endif
	#ifdef GL_VIEW_CLASS_ETC2_EAC_RGBA
		swigIntConstant( GL_VIEW_CLASS_ETC2_EAC_RGBA, "GL_VIEW_CLASS_ETC2_EAC_RGBA" );
	#endif
	#ifdef GL_VIEW_CLASS_ASTC_4x4_RGBA
		swigIntConstant( GL_VIEW_CLASS_ASTC_4x4_RGBA, "GL_VIEW_CLASS_ASTC_4x4_RGBA" );
	#endif
	#ifdef GL_VIEW_CLASS_ASTC_5x4_RGBA
		swigIntConstant( GL_VIEW_CLASS_ASTC_5x4_RGBA, "GL_VIEW_CLASS_ASTC_5x4_RGBA" );
	#endif
	#ifdef GL_VIEW_CLASS_ASTC_5x5_RGBA
		swigIntConstant( GL_VIEW_CLASS_ASTC_5x5_RGBA, "GL_VIEW_CLASS_ASTC_5x5_RGBA" );
	#endif
	#ifdef GL_VIEW_CLASS_ASTC_6x5_RGBA
		swigIntConstant( GL_VIEW_CLASS_ASTC_6x5_RGBA, "GL_VIEW_CLASS_ASTC_6x5_RGBA" );
	#endif
	#ifdef GL_VIEW_CLASS_ASTC_6x6_RGBA
		swigIntConstant( GL_VIEW_CLASS_ASTC_6x6_RGBA, "GL_VIEW_CLASS_ASTC_6x6_RGBA" );
	#endif
	#ifdef GL_VIEW_CLASS_ASTC_8x5_RGBA
		swigIntConstant( GL_VIEW_CLASS_ASTC_8x5_RGBA, "GL_VIEW_CLASS_ASTC_8x5_RGBA" );
	#endif
	#ifdef GL_VIEW_CLASS_ASTC_8x6_RGBA
		swigIntConstant( GL_VIEW_CLASS_ASTC_8x6_RGBA, "GL_VIEW_CLASS_ASTC_8x6_RGBA" );
	#endif
	#ifdef GL_VIEW_CLASS_ASTC_8x8_RGBA
		swigIntConstant( GL_VIEW_CLASS_ASTC_8x8_RGBA, "GL_VIEW_CLASS_ASTC_8x8_RGBA" );
	#endif
	#ifdef GL_VIEW_CLASS_ASTC_10x5_RGBA
		swigIntConstant( GL_VIEW_CLASS_ASTC_10x5_RGBA, "GL_VIEW_CLASS_ASTC_10x5_RGBA" );
	#endif
	#ifdef GL_VIEW_CLASS_ASTC_10x6_RGBA
		swigIntConstant( GL_VIEW_CLASS_ASTC_10x6_RGBA, "GL_VIEW_CLASS_ASTC_10x6_RGBA" );
	#endif
	#ifdef GL_VIEW_CLASS_ASTC_10x8_RGBA
		swigIntConstant( GL_VIEW_CLASS_ASTC_10x8_RGBA, "GL_VIEW_CLASS_ASTC_10x8_RGBA" );
	#endif
	#ifdef GL_VIEW_CLASS_ASTC_10x10_RGBA
		swigIntConstant( GL_VIEW_CLASS_ASTC_10x10_RGBA, "GL_VIEW_CLASS_ASTC_10x10_RGBA" );
	#endif
	#ifdef GL_VIEW_CLASS_ASTC_12x10_RGBA
		swigIntConstant( GL_VIEW_CLASS_ASTC_12x10_RGBA, "GL_VIEW_CLASS_ASTC_12x10_RGBA" );
	#endif
	#ifdef GL_VIEW_CLASS_ASTC_12x12_RGBA
		swigIntConstant( GL_VIEW_CLASS_ASTC_12x12_RGBA, "GL_VIEW_CLASS_ASTC_12x12_RGBA" );
	#endif
	#ifdef GL_ARB_invalidate_subdata
		swigIntConstant( GL_ARB_invalidate_subdata, "GL_ARB_invalidate_subdata" );
	#endif
	#ifdef GL_ARB_map_buffer_alignment
		swigIntConstant( GL_ARB_map_buffer_alignment, "GL_ARB_map_buffer_alignment" );
	#endif
	#ifdef GL_ARB_map_buffer_range
		swigIntConstant( GL_ARB_map_buffer_range, "GL_ARB_map_buffer_range" );
	#endif
	#ifdef GL_ARB_matrix_palette
		swigIntConstant( GL_ARB_matrix_palette, "GL_ARB_matrix_palette" );
	#endif
	#ifdef GL_MATRIX_PALETTE_ARB
		swigIntConstant( GL_MATRIX_PALETTE_ARB, "GL_MATRIX_PALETTE_ARB" );
	#endif
	#ifdef GL_MAX_MATRIX_PALETTE_STACK_DEPTH_ARB
		swigIntConstant( GL_MAX_MATRIX_PALETTE_STACK_DEPTH_ARB, "GL_MAX_MATRIX_PALETTE_STACK_DEPTH_ARB" );
	#endif
	#ifdef GL_MAX_PALETTE_MATRICES_ARB
		swigIntConstant( GL_MAX_PALETTE_MATRICES_ARB, "GL_MAX_PALETTE_MATRICES_ARB" );
	#endif
	#ifdef GL_CURRENT_PALETTE_MATRIX_ARB
		swigIntConstant( GL_CURRENT_PALETTE_MATRIX_ARB, "GL_CURRENT_PALETTE_MATRIX_ARB" );
	#endif
	#ifdef GL_MATRIX_INDEX_ARRAY_ARB
		swigIntConstant( GL_MATRIX_INDEX_ARRAY_ARB, "GL_MATRIX_INDEX_ARRAY_ARB" );
	#endif
	#ifdef GL_CURRENT_MATRIX_INDEX_ARB
		swigIntConstant( GL_CURRENT_MATRIX_INDEX_ARB, "GL_CURRENT_MATRIX_INDEX_ARB" );
	#endif
	#ifdef GL_MATRIX_INDEX_ARRAY_SIZE_ARB
		swigIntConstant( GL_MATRIX_INDEX_ARRAY_SIZE_ARB, "GL_MATRIX_INDEX_ARRAY_SIZE_ARB" );
	#endif
	#ifdef GL_MATRIX_INDEX_ARRAY_TYPE_ARB
		swigIntConstant( GL_MATRIX_INDEX_ARRAY_TYPE_ARB, "GL_MATRIX_INDEX_ARRAY_TYPE_ARB" );
	#endif
	#ifdef GL_MATRIX_INDEX_ARRAY_STRIDE_ARB
		swigIntConstant( GL_MATRIX_INDEX_ARRAY_STRIDE_ARB, "GL_MATRIX_INDEX_ARRAY_STRIDE_ARB" );
	#endif
	#ifdef GL_MATRIX_INDEX_ARRAY_POINTER_ARB
		swigIntConstant( GL_MATRIX_INDEX_ARRAY_POINTER_ARB, "GL_MATRIX_INDEX_ARRAY_POINTER_ARB" );
	#endif
	#ifdef GL_ARB_multi_bind
		swigIntConstant( GL_ARB_multi_bind, "GL_ARB_multi_bind" );
	#endif
	#ifdef GL_ARB_multi_draw_indirect
		swigIntConstant( GL_ARB_multi_draw_indirect, "GL_ARB_multi_draw_indirect" );
	#endif
	#ifdef GL_ARB_multisample
		swigIntConstant( GL_ARB_multisample, "GL_ARB_multisample" );
	#endif
	#ifdef GL_MULTISAMPLE_ARB
		swigIntConstant( GL_MULTISAMPLE_ARB, "GL_MULTISAMPLE_ARB" );
	#endif
	#ifdef GL_SAMPLE_ALPHA_TO_COVERAGE_ARB
		swigIntConstant( GL_SAMPLE_ALPHA_TO_COVERAGE_ARB, "GL_SAMPLE_ALPHA_TO_COVERAGE_ARB" );
	#endif
	#ifdef GL_SAMPLE_ALPHA_TO_ONE_ARB
		swigIntConstant( GL_SAMPLE_ALPHA_TO_ONE_ARB, "GL_SAMPLE_ALPHA_TO_ONE_ARB" );
	#endif
	#ifdef GL_SAMPLE_COVERAGE_ARB
		swigIntConstant( GL_SAMPLE_COVERAGE_ARB, "GL_SAMPLE_COVERAGE_ARB" );
	#endif
	#ifdef GL_SAMPLE_BUFFERS_ARB
		swigIntConstant( GL_SAMPLE_BUFFERS_ARB, "GL_SAMPLE_BUFFERS_ARB" );
	#endif
	#ifdef GL_SAMPLES_ARB
		swigIntConstant( GL_SAMPLES_ARB, "GL_SAMPLES_ARB" );
	#endif
	#ifdef GL_SAMPLE_COVERAGE_VALUE_ARB
		swigIntConstant( GL_SAMPLE_COVERAGE_VALUE_ARB, "GL_SAMPLE_COVERAGE_VALUE_ARB" );
	#endif
	#ifdef GL_SAMPLE_COVERAGE_INVERT_ARB
		swigIntConstant( GL_SAMPLE_COVERAGE_INVERT_ARB, "GL_SAMPLE_COVERAGE_INVERT_ARB" );
	#endif
	#ifdef GL_MULTISAMPLE_BIT_ARB
		swigIntConstant( GL_MULTISAMPLE_BIT_ARB, "GL_MULTISAMPLE_BIT_ARB" );
	#endif
	#ifdef GL_ARB_occlusion_query
		swigIntConstant( GL_ARB_occlusion_query, "GL_ARB_occlusion_query" );
	#endif
	#ifdef GL_QUERY_COUNTER_BITS_ARB
		swigIntConstant( GL_QUERY_COUNTER_BITS_ARB, "GL_QUERY_COUNTER_BITS_ARB" );
	#endif
	#ifdef GL_CURRENT_QUERY_ARB
		swigIntConstant( GL_CURRENT_QUERY_ARB, "GL_CURRENT_QUERY_ARB" );
	#endif
	#ifdef GL_QUERY_RESULT_ARB
		swigIntConstant( GL_QUERY_RESULT_ARB, "GL_QUERY_RESULT_ARB" );
	#endif
	#ifdef GL_QUERY_RESULT_AVAILABLE_ARB
		swigIntConstant( GL_QUERY_RESULT_AVAILABLE_ARB, "GL_QUERY_RESULT_AVAILABLE_ARB" );
	#endif
	#ifdef GL_SAMPLES_PASSED_ARB
		swigIntConstant( GL_SAMPLES_PASSED_ARB, "GL_SAMPLES_PASSED_ARB" );
	#endif
	#ifdef GL_ARB_occlusion_query2
		swigIntConstant( GL_ARB_occlusion_query2, "GL_ARB_occlusion_query2" );
	#endif
	#ifdef GL_ARB_parallel_shader_compile
		swigIntConstant( GL_ARB_parallel_shader_compile, "GL_ARB_parallel_shader_compile" );
	#endif
	#ifdef GL_MAX_SHADER_COMPILER_THREADS_ARB
		swigIntConstant( GL_MAX_SHADER_COMPILER_THREADS_ARB, "GL_MAX_SHADER_COMPILER_THREADS_ARB" );
	#endif
	#ifdef GL_COMPLETION_STATUS_ARB
		swigIntConstant( GL_COMPLETION_STATUS_ARB, "GL_COMPLETION_STATUS_ARB" );
	#endif
	#ifdef GL_ARB_pipeline_statistics_query
		swigIntConstant( GL_ARB_pipeline_statistics_query, "GL_ARB_pipeline_statistics_query" );
	#endif
	#ifdef GL_VERTICES_SUBMITTED_ARB
		swigIntConstant( GL_VERTICES_SUBMITTED_ARB, "GL_VERTICES_SUBMITTED_ARB" );
	#endif
	#ifdef GL_PRIMITIVES_SUBMITTED_ARB
		swigIntConstant( GL_PRIMITIVES_SUBMITTED_ARB, "GL_PRIMITIVES_SUBMITTED_ARB" );
	#endif
	#ifdef GL_VERTEX_SHADER_INVOCATIONS_ARB
		swigIntConstant( GL_VERTEX_SHADER_INVOCATIONS_ARB, "GL_VERTEX_SHADER_INVOCATIONS_ARB" );
	#endif
	#ifdef GL_TESS_CONTROL_SHADER_PATCHES_ARB
		swigIntConstant( GL_TESS_CONTROL_SHADER_PATCHES_ARB, "GL_TESS_CONTROL_SHADER_PATCHES_ARB" );
	#endif
	#ifdef GL_TESS_EVALUATION_SHADER_INVOCATIONS_ARB
		swigIntConstant( GL_TESS_EVALUATION_SHADER_INVOCATIONS_ARB, "GL_TESS_EVALUATION_SHADER_INVOCATIONS_ARB" );
	#endif
	#ifdef GL_GEOMETRY_SHADER_PRIMITIVES_EMITTED_ARB
		swigIntConstant( GL_GEOMETRY_SHADER_PRIMITIVES_EMITTED_ARB, "GL_GEOMETRY_SHADER_PRIMITIVES_EMITTED_ARB" );
	#endif
	#ifdef GL_FRAGMENT_SHADER_INVOCATIONS_ARB
		swigIntConstant( GL_FRAGMENT_SHADER_INVOCATIONS_ARB, "GL_FRAGMENT_SHADER_INVOCATIONS_ARB" );
	#endif
	#ifdef GL_COMPUTE_SHADER_INVOCATIONS_ARB
		swigIntConstant( GL_COMPUTE_SHADER_INVOCATIONS_ARB, "GL_COMPUTE_SHADER_INVOCATIONS_ARB" );
	#endif
	#ifdef GL_CLIPPING_INPUT_PRIMITIVES_ARB
		swigIntConstant( GL_CLIPPING_INPUT_PRIMITIVES_ARB, "GL_CLIPPING_INPUT_PRIMITIVES_ARB" );
	#endif
	#ifdef GL_CLIPPING_OUTPUT_PRIMITIVES_ARB
		swigIntConstant( GL_CLIPPING_OUTPUT_PRIMITIVES_ARB, "GL_CLIPPING_OUTPUT_PRIMITIVES_ARB" );
	#endif
	#ifdef GL_ARB_pixel_buffer_object
		swigIntConstant( GL_ARB_pixel_buffer_object, "GL_ARB_pixel_buffer_object" );
	#endif
	#ifdef GL_PIXEL_PACK_BUFFER_ARB
		swigIntConstant( GL_PIXEL_PACK_BUFFER_ARB, "GL_PIXEL_PACK_BUFFER_ARB" );
	#endif
	#ifdef GL_PIXEL_UNPACK_BUFFER_ARB
		swigIntConstant( GL_PIXEL_UNPACK_BUFFER_ARB, "GL_PIXEL_UNPACK_BUFFER_ARB" );
	#endif
	#ifdef GL_PIXEL_PACK_BUFFER_BINDING_ARB
		swigIntConstant( GL_PIXEL_PACK_BUFFER_BINDING_ARB, "GL_PIXEL_PACK_BUFFER_BINDING_ARB" );
	#endif
	#ifdef GL_PIXEL_UNPACK_BUFFER_BINDING_ARB
		swigIntConstant( GL_PIXEL_UNPACK_BUFFER_BINDING_ARB, "GL_PIXEL_UNPACK_BUFFER_BINDING_ARB" );
	#endif
	#ifdef GL_ARB_point_parameters
		swigIntConstant( GL_ARB_point_parameters, "GL_ARB_point_parameters" );
	#endif
	#ifdef GL_POINT_SIZE_MIN_ARB
		swigIntConstant( GL_POINT_SIZE_MIN_ARB, "GL_POINT_SIZE_MIN_ARB" );
	#endif
	#ifdef GL_POINT_SIZE_MAX_ARB
		swigIntConstant( GL_POINT_SIZE_MAX_ARB, "GL_POINT_SIZE_MAX_ARB" );
	#endif
	#ifdef GL_POINT_FADE_THRESHOLD_SIZE_ARB
		swigIntConstant( GL_POINT_FADE_THRESHOLD_SIZE_ARB, "GL_POINT_FADE_THRESHOLD_SIZE_ARB" );
	#endif
	#ifdef GL_POINT_DISTANCE_ATTENUATION_ARB
		swigIntConstant( GL_POINT_DISTANCE_ATTENUATION_ARB, "GL_POINT_DISTANCE_ATTENUATION_ARB" );
	#endif
	#ifdef GL_ARB_point_sprite
		swigIntConstant( GL_ARB_point_sprite, "GL_ARB_point_sprite" );
	#endif
	#ifdef GL_POINT_SPRITE_ARB
		swigIntConstant( GL_POINT_SPRITE_ARB, "GL_POINT_SPRITE_ARB" );
	#endif
	#ifdef GL_COORD_REPLACE_ARB
		swigIntConstant( GL_COORD_REPLACE_ARB, "GL_COORD_REPLACE_ARB" );
	#endif
	#ifdef GL_ARB_polygon_offset_clamp
		swigIntConstant( GL_ARB_polygon_offset_clamp, "GL_ARB_polygon_offset_clamp" );
	#endif
	#ifdef GL_ARB_post_depth_coverage
		swigIntConstant( GL_ARB_post_depth_coverage, "GL_ARB_post_depth_coverage" );
	#endif
	#ifdef GL_ARB_program_interface_query
		swigIntConstant( GL_ARB_program_interface_query, "GL_ARB_program_interface_query" );
	#endif
	#ifdef GL_ARB_provoking_vertex
		swigIntConstant( GL_ARB_provoking_vertex, "GL_ARB_provoking_vertex" );
	#endif
	#ifdef GL_ARB_query_buffer_object
		swigIntConstant( GL_ARB_query_buffer_object, "GL_ARB_query_buffer_object" );
	#endif
	#ifdef GL_ARB_robust_buffer_access_behavior
		swigIntConstant( GL_ARB_robust_buffer_access_behavior, "GL_ARB_robust_buffer_access_behavior" );
	#endif
	#ifdef GL_ARB_robustness
		swigIntConstant( GL_ARB_robustness, "GL_ARB_robustness" );
	#endif
	#ifdef GL_CONTEXT_FLAG_ROBUST_ACCESS_BIT_ARB
		swigIntConstant( GL_CONTEXT_FLAG_ROBUST_ACCESS_BIT_ARB, "GL_CONTEXT_FLAG_ROBUST_ACCESS_BIT_ARB" );
	#endif
	#ifdef GL_LOSE_CONTEXT_ON_RESET_ARB
		swigIntConstant( GL_LOSE_CONTEXT_ON_RESET_ARB, "GL_LOSE_CONTEXT_ON_RESET_ARB" );
	#endif
	#ifdef GL_GUILTY_CONTEXT_RESET_ARB
		swigIntConstant( GL_GUILTY_CONTEXT_RESET_ARB, "GL_GUILTY_CONTEXT_RESET_ARB" );
	#endif
	#ifdef GL_INNOCENT_CONTEXT_RESET_ARB
		swigIntConstant( GL_INNOCENT_CONTEXT_RESET_ARB, "GL_INNOCENT_CONTEXT_RESET_ARB" );
	#endif
	#ifdef GL_UNKNOWN_CONTEXT_RESET_ARB
		swigIntConstant( GL_UNKNOWN_CONTEXT_RESET_ARB, "GL_UNKNOWN_CONTEXT_RESET_ARB" );
	#endif
	#ifdef GL_RESET_NOTIFICATION_STRATEGY_ARB
		swigIntConstant( GL_RESET_NOTIFICATION_STRATEGY_ARB, "GL_RESET_NOTIFICATION_STRATEGY_ARB" );
	#endif
	#ifdef GL_NO_RESET_NOTIFICATION_ARB
		swigIntConstant( GL_NO_RESET_NOTIFICATION_ARB, "GL_NO_RESET_NOTIFICATION_ARB" );
	#endif
	#ifdef GL_ARB_robustness_isolation
		swigIntConstant( GL_ARB_robustness_isolation, "GL_ARB_robustness_isolation" );
	#endif
	#ifdef GL_ARB_sample_locations
		swigIntConstant( GL_ARB_sample_locations, "GL_ARB_sample_locations" );
	#endif
	#ifdef GL_SAMPLE_LOCATION_SUBPIXEL_BITS_ARB
		swigIntConstant( GL_SAMPLE_LOCATION_SUBPIXEL_BITS_ARB, "GL_SAMPLE_LOCATION_SUBPIXEL_BITS_ARB" );
	#endif
	#ifdef GL_SAMPLE_LOCATION_PIXEL_GRID_WIDTH_ARB
		swigIntConstant( GL_SAMPLE_LOCATION_PIXEL_GRID_WIDTH_ARB, "GL_SAMPLE_LOCATION_PIXEL_GRID_WIDTH_ARB" );
	#endif
	#ifdef GL_SAMPLE_LOCATION_PIXEL_GRID_HEIGHT_ARB
		swigIntConstant( GL_SAMPLE_LOCATION_PIXEL_GRID_HEIGHT_ARB, "GL_SAMPLE_LOCATION_PIXEL_GRID_HEIGHT_ARB" );
	#endif
	#ifdef GL_PROGRAMMABLE_SAMPLE_LOCATION_TABLE_SIZE_ARB
		swigIntConstant( GL_PROGRAMMABLE_SAMPLE_LOCATION_TABLE_SIZE_ARB, "GL_PROGRAMMABLE_SAMPLE_LOCATION_TABLE_SIZE_ARB" );
	#endif
	#ifdef GL_SAMPLE_LOCATION_ARB
		swigIntConstant( GL_SAMPLE_LOCATION_ARB, "GL_SAMPLE_LOCATION_ARB" );
	#endif
	#ifdef GL_PROGRAMMABLE_SAMPLE_LOCATION_ARB
		swigIntConstant( GL_PROGRAMMABLE_SAMPLE_LOCATION_ARB, "GL_PROGRAMMABLE_SAMPLE_LOCATION_ARB" );
	#endif
	#ifdef GL_FRAMEBUFFER_PROGRAMMABLE_SAMPLE_LOCATIONS_ARB
		swigIntConstant( GL_FRAMEBUFFER_PROGRAMMABLE_SAMPLE_LOCATIONS_ARB, "GL_FRAMEBUFFER_PROGRAMMABLE_SAMPLE_LOCATIONS_ARB" );
	#endif
	#ifdef GL_FRAMEBUFFER_SAMPLE_LOCATION_PIXEL_GRID_ARB
		swigIntConstant( GL_FRAMEBUFFER_SAMPLE_LOCATION_PIXEL_GRID_ARB, "GL_FRAMEBUFFER_SAMPLE_LOCATION_PIXEL_GRID_ARB" );
	#endif
	#ifdef GL_ARB_sample_shading
		swigIntConstant( GL_ARB_sample_shading, "GL_ARB_sample_shading" );
	#endif
	#ifdef GL_SAMPLE_SHADING_ARB
		swigIntConstant( GL_SAMPLE_SHADING_ARB, "GL_SAMPLE_SHADING_ARB" );
	#endif
	#ifdef GL_MIN_SAMPLE_SHADING_VALUE_ARB
		swigIntConstant( GL_MIN_SAMPLE_SHADING_VALUE_ARB, "GL_MIN_SAMPLE_SHADING_VALUE_ARB" );
	#endif
	#ifdef GL_ARB_sampler_objects
		swigIntConstant( GL_ARB_sampler_objects, "GL_ARB_sampler_objects" );
	#endif
	#ifdef GL_ARB_seamless_cube_map
		swigIntConstant( GL_ARB_seamless_cube_map, "GL_ARB_seamless_cube_map" );
	#endif
	#ifdef GL_ARB_seamless_cubemap_per_texture
		swigIntConstant( GL_ARB_seamless_cubemap_per_texture, "GL_ARB_seamless_cubemap_per_texture" );
	#endif
	#ifdef GL_ARB_separate_shader_objects
		swigIntConstant( GL_ARB_separate_shader_objects, "GL_ARB_separate_shader_objects" );
	#endif
	#ifdef GL_ARB_shader_atomic_counter_ops
		swigIntConstant( GL_ARB_shader_atomic_counter_ops, "GL_ARB_shader_atomic_counter_ops" );
	#endif
	#ifdef GL_ARB_shader_atomic_counters
		swigIntConstant( GL_ARB_shader_atomic_counters, "GL_ARB_shader_atomic_counters" );
	#endif
	#ifdef GL_ARB_shader_ballot
		swigIntConstant( GL_ARB_shader_ballot, "GL_ARB_shader_ballot" );
	#endif
	#ifdef GL_ARB_shader_bit_encoding
		swigIntConstant( GL_ARB_shader_bit_encoding, "GL_ARB_shader_bit_encoding" );
	#endif
	#ifdef GL_ARB_shader_clock
		swigIntConstant( GL_ARB_shader_clock, "GL_ARB_shader_clock" );
	#endif
	#ifdef GL_ARB_shader_draw_parameters
		swigIntConstant( GL_ARB_shader_draw_parameters, "GL_ARB_shader_draw_parameters" );
	#endif
	#ifdef GL_ARB_shader_group_vote
		swigIntConstant( GL_ARB_shader_group_vote, "GL_ARB_shader_group_vote" );
	#endif
	#ifdef GL_ARB_shader_image_load_store
		swigIntConstant( GL_ARB_shader_image_load_store, "GL_ARB_shader_image_load_store" );
	#endif
	#ifdef GL_ARB_shader_image_size
		swigIntConstant( GL_ARB_shader_image_size, "GL_ARB_shader_image_size" );
	#endif
	#ifdef GL_ARB_shader_objects
		swigIntConstant( GL_ARB_shader_objects, "GL_ARB_shader_objects" );
	#endif
	#ifdef GL_PROGRAM_OBJECT_ARB
		swigIntConstant( GL_PROGRAM_OBJECT_ARB, "GL_PROGRAM_OBJECT_ARB" );
	#endif
	#ifdef GL_SHADER_OBJECT_ARB
		swigIntConstant( GL_SHADER_OBJECT_ARB, "GL_SHADER_OBJECT_ARB" );
	#endif
	#ifdef GL_OBJECT_TYPE_ARB
		swigIntConstant( GL_OBJECT_TYPE_ARB, "GL_OBJECT_TYPE_ARB" );
	#endif
	#ifdef GL_OBJECT_SUBTYPE_ARB
		swigIntConstant( GL_OBJECT_SUBTYPE_ARB, "GL_OBJECT_SUBTYPE_ARB" );
	#endif
	#ifdef GL_FLOAT_VEC2_ARB
		swigIntConstant( GL_FLOAT_VEC2_ARB, "GL_FLOAT_VEC2_ARB" );
	#endif
	#ifdef GL_FLOAT_VEC3_ARB
		swigIntConstant( GL_FLOAT_VEC3_ARB, "GL_FLOAT_VEC3_ARB" );
	#endif
	#ifdef GL_FLOAT_VEC4_ARB
		swigIntConstant( GL_FLOAT_VEC4_ARB, "GL_FLOAT_VEC4_ARB" );
	#endif
	#ifdef GL_INT_VEC2_ARB
		swigIntConstant( GL_INT_VEC2_ARB, "GL_INT_VEC2_ARB" );
	#endif
	#ifdef GL_INT_VEC3_ARB
		swigIntConstant( GL_INT_VEC3_ARB, "GL_INT_VEC3_ARB" );
	#endif
	#ifdef GL_INT_VEC4_ARB
		swigIntConstant( GL_INT_VEC4_ARB, "GL_INT_VEC4_ARB" );
	#endif
	#ifdef GL_BOOL_ARB
		swigIntConstant( GL_BOOL_ARB, "GL_BOOL_ARB" );
	#endif
	#ifdef GL_BOOL_VEC2_ARB
		swigIntConstant( GL_BOOL_VEC2_ARB, "GL_BOOL_VEC2_ARB" );
	#endif
	#ifdef GL_BOOL_VEC3_ARB
		swigIntConstant( GL_BOOL_VEC3_ARB, "GL_BOOL_VEC3_ARB" );
	#endif
	#ifdef GL_BOOL_VEC4_ARB
		swigIntConstant( GL_BOOL_VEC4_ARB, "GL_BOOL_VEC4_ARB" );
	#endif
	#ifdef GL_FLOAT_MAT2_ARB
		swigIntConstant( GL_FLOAT_MAT2_ARB, "GL_FLOAT_MAT2_ARB" );
	#endif
	#ifdef GL_FLOAT_MAT3_ARB
		swigIntConstant( GL_FLOAT_MAT3_ARB, "GL_FLOAT_MAT3_ARB" );
	#endif
	#ifdef GL_FLOAT_MAT4_ARB
		swigIntConstant( GL_FLOAT_MAT4_ARB, "GL_FLOAT_MAT4_ARB" );
	#endif
	#ifdef GL_SAMPLER_1D_ARB
		swigIntConstant( GL_SAMPLER_1D_ARB, "GL_SAMPLER_1D_ARB" );
	#endif
	#ifdef GL_SAMPLER_2D_ARB
		swigIntConstant( GL_SAMPLER_2D_ARB, "GL_SAMPLER_2D_ARB" );
	#endif
	#ifdef GL_SAMPLER_3D_ARB
		swigIntConstant( GL_SAMPLER_3D_ARB, "GL_SAMPLER_3D_ARB" );
	#endif
	#ifdef GL_SAMPLER_CUBE_ARB
		swigIntConstant( GL_SAMPLER_CUBE_ARB, "GL_SAMPLER_CUBE_ARB" );
	#endif
	#ifdef GL_SAMPLER_1D_SHADOW_ARB
		swigIntConstant( GL_SAMPLER_1D_SHADOW_ARB, "GL_SAMPLER_1D_SHADOW_ARB" );
	#endif
	#ifdef GL_SAMPLER_2D_SHADOW_ARB
		swigIntConstant( GL_SAMPLER_2D_SHADOW_ARB, "GL_SAMPLER_2D_SHADOW_ARB" );
	#endif
	#ifdef GL_SAMPLER_2D_RECT_ARB
		swigIntConstant( GL_SAMPLER_2D_RECT_ARB, "GL_SAMPLER_2D_RECT_ARB" );
	#endif
	#ifdef GL_SAMPLER_2D_RECT_SHADOW_ARB
		swigIntConstant( GL_SAMPLER_2D_RECT_SHADOW_ARB, "GL_SAMPLER_2D_RECT_SHADOW_ARB" );
	#endif
	#ifdef GL_OBJECT_DELETE_STATUS_ARB
		swigIntConstant( GL_OBJECT_DELETE_STATUS_ARB, "GL_OBJECT_DELETE_STATUS_ARB" );
	#endif
	#ifdef GL_OBJECT_COMPILE_STATUS_ARB
		swigIntConstant( GL_OBJECT_COMPILE_STATUS_ARB, "GL_OBJECT_COMPILE_STATUS_ARB" );
	#endif
	#ifdef GL_OBJECT_LINK_STATUS_ARB
		swigIntConstant( GL_OBJECT_LINK_STATUS_ARB, "GL_OBJECT_LINK_STATUS_ARB" );
	#endif
	#ifdef GL_OBJECT_VALIDATE_STATUS_ARB
		swigIntConstant( GL_OBJECT_VALIDATE_STATUS_ARB, "GL_OBJECT_VALIDATE_STATUS_ARB" );
	#endif
	#ifdef GL_OBJECT_INFO_LOG_LENGTH_ARB
		swigIntConstant( GL_OBJECT_INFO_LOG_LENGTH_ARB, "GL_OBJECT_INFO_LOG_LENGTH_ARB" );
	#endif
	#ifdef GL_OBJECT_ATTACHED_OBJECTS_ARB
		swigIntConstant( GL_OBJECT_ATTACHED_OBJECTS_ARB, "GL_OBJECT_ATTACHED_OBJECTS_ARB" );
	#endif
	#ifdef GL_OBJECT_ACTIVE_UNIFORMS_ARB
		swigIntConstant( GL_OBJECT_ACTIVE_UNIFORMS_ARB, "GL_OBJECT_ACTIVE_UNIFORMS_ARB" );
	#endif
	#ifdef GL_OBJECT_ACTIVE_UNIFORM_MAX_LENGTH_ARB
		swigIntConstant( GL_OBJECT_ACTIVE_UNIFORM_MAX_LENGTH_ARB, "GL_OBJECT_ACTIVE_UNIFORM_MAX_LENGTH_ARB" );
	#endif
	#ifdef GL_OBJECT_SHADER_SOURCE_LENGTH_ARB
		swigIntConstant( GL_OBJECT_SHADER_SOURCE_LENGTH_ARB, "GL_OBJECT_SHADER_SOURCE_LENGTH_ARB" );
	#endif
	#ifdef GL_ARB_shader_precision
		swigIntConstant( GL_ARB_shader_precision, "GL_ARB_shader_precision" );
	#endif
	#ifdef GL_ARB_shader_stencil_export
		swigIntConstant( GL_ARB_shader_stencil_export, "GL_ARB_shader_stencil_export" );
	#endif
	#ifdef GL_ARB_shader_storage_buffer_object
		swigIntConstant( GL_ARB_shader_storage_buffer_object, "GL_ARB_shader_storage_buffer_object" );
	#endif
	#ifdef GL_ARB_shader_subroutine
		swigIntConstant( GL_ARB_shader_subroutine, "GL_ARB_shader_subroutine" );
	#endif
	#ifdef GL_ARB_shader_texture_image_samples
		swigIntConstant( GL_ARB_shader_texture_image_samples, "GL_ARB_shader_texture_image_samples" );
	#endif
	#ifdef GL_ARB_shader_texture_lod
		swigIntConstant( GL_ARB_shader_texture_lod, "GL_ARB_shader_texture_lod" );
	#endif
	#ifdef GL_ARB_shader_viewport_layer_array
		swigIntConstant( GL_ARB_shader_viewport_layer_array, "GL_ARB_shader_viewport_layer_array" );
	#endif
	#ifdef GL_ARB_shading_language_100
		swigIntConstant( GL_ARB_shading_language_100, "GL_ARB_shading_language_100" );
	#endif
	#ifdef GL_SHADING_LANGUAGE_VERSION_ARB
		swigIntConstant( GL_SHADING_LANGUAGE_VERSION_ARB, "GL_SHADING_LANGUAGE_VERSION_ARB" );
	#endif
	#ifdef GL_ARB_shading_language_420pack
		swigIntConstant( GL_ARB_shading_language_420pack, "GL_ARB_shading_language_420pack" );
	#endif
	#ifdef GL_ARB_shading_language_include
		swigIntConstant( GL_ARB_shading_language_include, "GL_ARB_shading_language_include" );
	#endif
	#ifdef GL_SHADER_INCLUDE_ARB
		swigIntConstant( GL_SHADER_INCLUDE_ARB, "GL_SHADER_INCLUDE_ARB" );
	#endif
	#ifdef GL_NAMED_STRING_LENGTH_ARB
		swigIntConstant( GL_NAMED_STRING_LENGTH_ARB, "GL_NAMED_STRING_LENGTH_ARB" );
	#endif
	#ifdef GL_NAMED_STRING_TYPE_ARB
		swigIntConstant( GL_NAMED_STRING_TYPE_ARB, "GL_NAMED_STRING_TYPE_ARB" );
	#endif
	#ifdef GL_ARB_shading_language_packing
		swigIntConstant( GL_ARB_shading_language_packing, "GL_ARB_shading_language_packing" );
	#endif
	#ifdef GL_ARB_shadow
		swigIntConstant( GL_ARB_shadow, "GL_ARB_shadow" );
	#endif
	#ifdef GL_TEXTURE_COMPARE_MODE_ARB
		swigIntConstant( GL_TEXTURE_COMPARE_MODE_ARB, "GL_TEXTURE_COMPARE_MODE_ARB" );
	#endif
	#ifdef GL_TEXTURE_COMPARE_FUNC_ARB
		swigIntConstant( GL_TEXTURE_COMPARE_FUNC_ARB, "GL_TEXTURE_COMPARE_FUNC_ARB" );
	#endif
	#ifdef GL_COMPARE_R_TO_TEXTURE_ARB
		swigIntConstant( GL_COMPARE_R_TO_TEXTURE_ARB, "GL_COMPARE_R_TO_TEXTURE_ARB" );
	#endif
	#ifdef GL_ARB_shadow_ambient
		swigIntConstant( GL_ARB_shadow_ambient, "GL_ARB_shadow_ambient" );
	#endif
	#ifdef GL_TEXTURE_COMPARE_FAIL_VALUE_ARB
		swigIntConstant( GL_TEXTURE_COMPARE_FAIL_VALUE_ARB, "GL_TEXTURE_COMPARE_FAIL_VALUE_ARB" );
	#endif
	#ifdef GL_ARB_sparse_buffer
		swigIntConstant( GL_ARB_sparse_buffer, "GL_ARB_sparse_buffer" );
	#endif
	#ifdef GL_SPARSE_STORAGE_BIT_ARB
		swigIntConstant( GL_SPARSE_STORAGE_BIT_ARB, "GL_SPARSE_STORAGE_BIT_ARB" );
	#endif
	#ifdef GL_SPARSE_BUFFER_PAGE_SIZE_ARB
		swigIntConstant( GL_SPARSE_BUFFER_PAGE_SIZE_ARB, "GL_SPARSE_BUFFER_PAGE_SIZE_ARB" );
	#endif
	#ifdef GL_ARB_sparse_texture
		swigIntConstant( GL_ARB_sparse_texture, "GL_ARB_sparse_texture" );
	#endif
	#ifdef GL_TEXTURE_SPARSE_ARB
		swigIntConstant( GL_TEXTURE_SPARSE_ARB, "GL_TEXTURE_SPARSE_ARB" );
	#endif
	#ifdef GL_VIRTUAL_PAGE_SIZE_INDEX_ARB
		swigIntConstant( GL_VIRTUAL_PAGE_SIZE_INDEX_ARB, "GL_VIRTUAL_PAGE_SIZE_INDEX_ARB" );
	#endif
	#ifdef GL_NUM_SPARSE_LEVELS_ARB
		swigIntConstant( GL_NUM_SPARSE_LEVELS_ARB, "GL_NUM_SPARSE_LEVELS_ARB" );
	#endif
	#ifdef GL_NUM_VIRTUAL_PAGE_SIZES_ARB
		swigIntConstant( GL_NUM_VIRTUAL_PAGE_SIZES_ARB, "GL_NUM_VIRTUAL_PAGE_SIZES_ARB" );
	#endif
	#ifdef GL_VIRTUAL_PAGE_SIZE_X_ARB
		swigIntConstant( GL_VIRTUAL_PAGE_SIZE_X_ARB, "GL_VIRTUAL_PAGE_SIZE_X_ARB" );
	#endif
	#ifdef GL_VIRTUAL_PAGE_SIZE_Y_ARB
		swigIntConstant( GL_VIRTUAL_PAGE_SIZE_Y_ARB, "GL_VIRTUAL_PAGE_SIZE_Y_ARB" );
	#endif
	#ifdef GL_VIRTUAL_PAGE_SIZE_Z_ARB
		swigIntConstant( GL_VIRTUAL_PAGE_SIZE_Z_ARB, "GL_VIRTUAL_PAGE_SIZE_Z_ARB" );
	#endif
	#ifdef GL_MAX_SPARSE_TEXTURE_SIZE_ARB
		swigIntConstant( GL_MAX_SPARSE_TEXTURE_SIZE_ARB, "GL_MAX_SPARSE_TEXTURE_SIZE_ARB" );
	#endif
	#ifdef GL_MAX_SPARSE_3D_TEXTURE_SIZE_ARB
		swigIntConstant( GL_MAX_SPARSE_3D_TEXTURE_SIZE_ARB, "GL_MAX_SPARSE_3D_TEXTURE_SIZE_ARB" );
	#endif
	#ifdef GL_MAX_SPARSE_ARRAY_TEXTURE_LAYERS_ARB
		swigIntConstant( GL_MAX_SPARSE_ARRAY_TEXTURE_LAYERS_ARB, "GL_MAX_SPARSE_ARRAY_TEXTURE_LAYERS_ARB" );
	#endif
	#ifdef GL_SPARSE_TEXTURE_FULL_ARRAY_CUBE_MIPMAPS_ARB
		swigIntConstant( GL_SPARSE_TEXTURE_FULL_ARRAY_CUBE_MIPMAPS_ARB, "GL_SPARSE_TEXTURE_FULL_ARRAY_CUBE_MIPMAPS_ARB" );
	#endif
	#ifdef GL_ARB_sparse_texture2
		swigIntConstant( GL_ARB_sparse_texture2, "GL_ARB_sparse_texture2" );
	#endif
	#ifdef GL_ARB_sparse_texture_clamp
		swigIntConstant( GL_ARB_sparse_texture_clamp, "GL_ARB_sparse_texture_clamp" );
	#endif
	#ifdef GL_ARB_spirv_extensions
		swigIntConstant( GL_ARB_spirv_extensions, "GL_ARB_spirv_extensions" );
	#endif
	#ifdef GL_ARB_stencil_texturing
		swigIntConstant( GL_ARB_stencil_texturing, "GL_ARB_stencil_texturing" );
	#endif
	#ifdef GL_ARB_sync
		swigIntConstant( GL_ARB_sync, "GL_ARB_sync" );
	#endif
	#ifdef GL_ARB_tessellation_shader
		swigIntConstant( GL_ARB_tessellation_shader, "GL_ARB_tessellation_shader" );
	#endif
	#ifdef GL_ARB_texture_barrier
		swigIntConstant( GL_ARB_texture_barrier, "GL_ARB_texture_barrier" );
	#endif
	#ifdef GL_ARB_texture_border_clamp
		swigIntConstant( GL_ARB_texture_border_clamp, "GL_ARB_texture_border_clamp" );
	#endif
	#ifdef GL_CLAMP_TO_BORDER_ARB
		swigIntConstant( GL_CLAMP_TO_BORDER_ARB, "GL_CLAMP_TO_BORDER_ARB" );
	#endif
	#ifdef GL_ARB_texture_buffer_object
		swigIntConstant( GL_ARB_texture_buffer_object, "GL_ARB_texture_buffer_object" );
	#endif
	#ifdef GL_TEXTURE_BUFFER_ARB
		swigIntConstant( GL_TEXTURE_BUFFER_ARB, "GL_TEXTURE_BUFFER_ARB" );
	#endif
	#ifdef GL_MAX_TEXTURE_BUFFER_SIZE_ARB
		swigIntConstant( GL_MAX_TEXTURE_BUFFER_SIZE_ARB, "GL_MAX_TEXTURE_BUFFER_SIZE_ARB" );
	#endif
	#ifdef GL_TEXTURE_BINDING_BUFFER_ARB
		swigIntConstant( GL_TEXTURE_BINDING_BUFFER_ARB, "GL_TEXTURE_BINDING_BUFFER_ARB" );
	#endif
	#ifdef GL_TEXTURE_BUFFER_DATA_STORE_BINDING_ARB
		swigIntConstant( GL_TEXTURE_BUFFER_DATA_STORE_BINDING_ARB, "GL_TEXTURE_BUFFER_DATA_STORE_BINDING_ARB" );
	#endif
	#ifdef GL_TEXTURE_BUFFER_FORMAT_ARB
		swigIntConstant( GL_TEXTURE_BUFFER_FORMAT_ARB, "GL_TEXTURE_BUFFER_FORMAT_ARB" );
	#endif
	#ifdef GL_ARB_texture_buffer_object_rgb32
		swigIntConstant( GL_ARB_texture_buffer_object_rgb32, "GL_ARB_texture_buffer_object_rgb32" );
	#endif
	#ifdef GL_ARB_texture_buffer_range
		swigIntConstant( GL_ARB_texture_buffer_range, "GL_ARB_texture_buffer_range" );
	#endif
	#ifdef GL_ARB_texture_compression
		swigIntConstant( GL_ARB_texture_compression, "GL_ARB_texture_compression" );
	#endif
	#ifdef GL_COMPRESSED_ALPHA_ARB
		swigIntConstant( GL_COMPRESSED_ALPHA_ARB, "GL_COMPRESSED_ALPHA_ARB" );
	#endif
	#ifdef GL_COMPRESSED_LUMINANCE_ARB
		swigIntConstant( GL_COMPRESSED_LUMINANCE_ARB, "GL_COMPRESSED_LUMINANCE_ARB" );
	#endif
	#ifdef GL_COMPRESSED_LUMINANCE_ALPHA_ARB
		swigIntConstant( GL_COMPRESSED_LUMINANCE_ALPHA_ARB, "GL_COMPRESSED_LUMINANCE_ALPHA_ARB" );
	#endif
	#ifdef GL_COMPRESSED_INTENSITY_ARB
		swigIntConstant( GL_COMPRESSED_INTENSITY_ARB, "GL_COMPRESSED_INTENSITY_ARB" );
	#endif
	#ifdef GL_COMPRESSED_RGB_ARB
		swigIntConstant( GL_COMPRESSED_RGB_ARB, "GL_COMPRESSED_RGB_ARB" );
	#endif
	#ifdef GL_COMPRESSED_RGBA_ARB
		swigIntConstant( GL_COMPRESSED_RGBA_ARB, "GL_COMPRESSED_RGBA_ARB" );
	#endif
	#ifdef GL_TEXTURE_COMPRESSION_HINT_ARB
		swigIntConstant( GL_TEXTURE_COMPRESSION_HINT_ARB, "GL_TEXTURE_COMPRESSION_HINT_ARB" );
	#endif
	#ifdef GL_TEXTURE_COMPRESSED_IMAGE_SIZE_ARB
		swigIntConstant( GL_TEXTURE_COMPRESSED_IMAGE_SIZE_ARB, "GL_TEXTURE_COMPRESSED_IMAGE_SIZE_ARB" );
	#endif
	#ifdef GL_TEXTURE_COMPRESSED_ARB
		swigIntConstant( GL_TEXTURE_COMPRESSED_ARB, "GL_TEXTURE_COMPRESSED_ARB" );
	#endif
	#ifdef GL_NUM_COMPRESSED_TEXTURE_FORMATS_ARB
		swigIntConstant( GL_NUM_COMPRESSED_TEXTURE_FORMATS_ARB, "GL_NUM_COMPRESSED_TEXTURE_FORMATS_ARB" );
	#endif
	#ifdef GL_COMPRESSED_TEXTURE_FORMATS_ARB
		swigIntConstant( GL_COMPRESSED_TEXTURE_FORMATS_ARB, "GL_COMPRESSED_TEXTURE_FORMATS_ARB" );
	#endif
	#ifdef GL_ARB_texture_compression_bptc
		swigIntConstant( GL_ARB_texture_compression_bptc, "GL_ARB_texture_compression_bptc" );
	#endif
	#ifdef GL_COMPRESSED_RGBA_BPTC_UNORM_ARB
		swigIntConstant( GL_COMPRESSED_RGBA_BPTC_UNORM_ARB, "GL_COMPRESSED_RGBA_BPTC_UNORM_ARB" );
	#endif
	#ifdef GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM_ARB
		swigIntConstant( GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM_ARB, "GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM_ARB" );
	#endif
	#ifdef GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT_ARB
		swigIntConstant( GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT_ARB, "GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT_ARB" );
	#endif
	#ifdef GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT_ARB
		swigIntConstant( GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT_ARB, "GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT_ARB" );
	#endif
	#ifdef GL_ARB_texture_compression_rgtc
		swigIntConstant( GL_ARB_texture_compression_rgtc, "GL_ARB_texture_compression_rgtc" );
	#endif
	#ifdef GL_ARB_texture_cube_map
		swigIntConstant( GL_ARB_texture_cube_map, "GL_ARB_texture_cube_map" );
	#endif
	#ifdef GL_NORMAL_MAP_ARB
		swigIntConstant( GL_NORMAL_MAP_ARB, "GL_NORMAL_MAP_ARB" );
	#endif
	#ifdef GL_REFLECTION_MAP_ARB
		swigIntConstant( GL_REFLECTION_MAP_ARB, "GL_REFLECTION_MAP_ARB" );
	#endif
	#ifdef GL_TEXTURE_CUBE_MAP_ARB
		swigIntConstant( GL_TEXTURE_CUBE_MAP_ARB, "GL_TEXTURE_CUBE_MAP_ARB" );
	#endif
	#ifdef GL_TEXTURE_BINDING_CUBE_MAP_ARB
		swigIntConstant( GL_TEXTURE_BINDING_CUBE_MAP_ARB, "GL_TEXTURE_BINDING_CUBE_MAP_ARB" );
	#endif
	#ifdef GL_TEXTURE_CUBE_MAP_POSITIVE_X_ARB
		swigIntConstant( GL_TEXTURE_CUBE_MAP_POSITIVE_X_ARB, "GL_TEXTURE_CUBE_MAP_POSITIVE_X_ARB" );
	#endif
	#ifdef GL_TEXTURE_CUBE_MAP_NEGATIVE_X_ARB
		swigIntConstant( GL_TEXTURE_CUBE_MAP_NEGATIVE_X_ARB, "GL_TEXTURE_CUBE_MAP_NEGATIVE_X_ARB" );
	#endif
	#ifdef GL_TEXTURE_CUBE_MAP_POSITIVE_Y_ARB
		swigIntConstant( GL_TEXTURE_CUBE_MAP_POSITIVE_Y_ARB, "GL_TEXTURE_CUBE_MAP_POSITIVE_Y_ARB" );
	#endif
	#ifdef GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_ARB
		swigIntConstant( GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_ARB, "GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_ARB" );
	#endif
	#ifdef GL_TEXTURE_CUBE_MAP_POSITIVE_Z_ARB
		swigIntConstant( GL_TEXTURE_CUBE_MAP_POSITIVE_Z_ARB, "GL_TEXTURE_CUBE_MAP_POSITIVE_Z_ARB" );
	#endif
	#ifdef GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_ARB
		swigIntConstant( GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_ARB, "GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_ARB" );
	#endif
	#ifdef GL_PROXY_TEXTURE_CUBE_MAP_ARB
		swigIntConstant( GL_PROXY_TEXTURE_CUBE_MAP_ARB, "GL_PROXY_TEXTURE_CUBE_MAP_ARB" );
	#endif
	#ifdef GL_MAX_CUBE_MAP_TEXTURE_SIZE_ARB
		swigIntConstant( GL_MAX_CUBE_MAP_TEXTURE_SIZE_ARB, "GL_MAX_CUBE_MAP_TEXTURE_SIZE_ARB" );
	#endif
	#ifdef GL_ARB_texture_cube_map_array
		swigIntConstant( GL_ARB_texture_cube_map_array, "GL_ARB_texture_cube_map_array" );
	#endif
	#ifdef GL_TEXTURE_CUBE_MAP_ARRAY_ARB
		swigIntConstant( GL_TEXTURE_CUBE_MAP_ARRAY_ARB, "GL_TEXTURE_CUBE_MAP_ARRAY_ARB" );
	#endif
	#ifdef GL_TEXTURE_BINDING_CUBE_MAP_ARRAY_ARB
		swigIntConstant( GL_TEXTURE_BINDING_CUBE_MAP_ARRAY_ARB, "GL_TEXTURE_BINDING_CUBE_MAP_ARRAY_ARB" );
	#endif
	#ifdef GL_PROXY_TEXTURE_CUBE_MAP_ARRAY_ARB
		swigIntConstant( GL_PROXY_TEXTURE_CUBE_MAP_ARRAY_ARB, "GL_PROXY_TEXTURE_CUBE_MAP_ARRAY_ARB" );
	#endif
	#ifdef GL_SAMPLER_CUBE_MAP_ARRAY_ARB
		swigIntConstant( GL_SAMPLER_CUBE_MAP_ARRAY_ARB, "GL_SAMPLER_CUBE_MAP_ARRAY_ARB" );
	#endif
	#ifdef GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW_ARB
		swigIntConstant( GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW_ARB, "GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW_ARB" );
	#endif
	#ifdef GL_INT_SAMPLER_CUBE_MAP_ARRAY_ARB
		swigIntConstant( GL_INT_SAMPLER_CUBE_MAP_ARRAY_ARB, "GL_INT_SAMPLER_CUBE_MAP_ARRAY_ARB" );
	#endif
	#ifdef GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY_ARB
		swigIntConstant( GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY_ARB, "GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY_ARB" );
	#endif
	#ifdef GL_ARB_texture_env_add
		swigIntConstant( GL_ARB_texture_env_add, "GL_ARB_texture_env_add" );
	#endif
	#ifdef GL_ARB_texture_env_combine
		swigIntConstant( GL_ARB_texture_env_combine, "GL_ARB_texture_env_combine" );
	#endif
	#ifdef GL_COMBINE_ARB
		swigIntConstant( GL_COMBINE_ARB, "GL_COMBINE_ARB" );
	#endif
	#ifdef GL_COMBINE_RGB_ARB
		swigIntConstant( GL_COMBINE_RGB_ARB, "GL_COMBINE_RGB_ARB" );
	#endif
	#ifdef GL_COMBINE_ALPHA_ARB
		swigIntConstant( GL_COMBINE_ALPHA_ARB, "GL_COMBINE_ALPHA_ARB" );
	#endif
	#ifdef GL_SOURCE0_RGB_ARB
		swigIntConstant( GL_SOURCE0_RGB_ARB, "GL_SOURCE0_RGB_ARB" );
	#endif
	#ifdef GL_SOURCE1_RGB_ARB
		swigIntConstant( GL_SOURCE1_RGB_ARB, "GL_SOURCE1_RGB_ARB" );
	#endif
	#ifdef GL_SOURCE2_RGB_ARB
		swigIntConstant( GL_SOURCE2_RGB_ARB, "GL_SOURCE2_RGB_ARB" );
	#endif
	#ifdef GL_SOURCE0_ALPHA_ARB
		swigIntConstant( GL_SOURCE0_ALPHA_ARB, "GL_SOURCE0_ALPHA_ARB" );
	#endif
	#ifdef GL_SOURCE1_ALPHA_ARB
		swigIntConstant( GL_SOURCE1_ALPHA_ARB, "GL_SOURCE1_ALPHA_ARB" );
	#endif
	#ifdef GL_SOURCE2_ALPHA_ARB
		swigIntConstant( GL_SOURCE2_ALPHA_ARB, "GL_SOURCE2_ALPHA_ARB" );
	#endif
	#ifdef GL_OPERAND0_RGB_ARB
		swigIntConstant( GL_OPERAND0_RGB_ARB, "GL_OPERAND0_RGB_ARB" );
	#endif
	#ifdef GL_OPERAND1_RGB_ARB
		swigIntConstant( GL_OPERAND1_RGB_ARB, "GL_OPERAND1_RGB_ARB" );
	#endif
	#ifdef GL_OPERAND2_RGB_ARB
		swigIntConstant( GL_OPERAND2_RGB_ARB, "GL_OPERAND2_RGB_ARB" );
	#endif
	#ifdef GL_OPERAND0_ALPHA_ARB
		swigIntConstant( GL_OPERAND0_ALPHA_ARB, "GL_OPERAND0_ALPHA_ARB" );
	#endif
	#ifdef GL_OPERAND1_ALPHA_ARB
		swigIntConstant( GL_OPERAND1_ALPHA_ARB, "GL_OPERAND1_ALPHA_ARB" );
	#endif
	#ifdef GL_OPERAND2_ALPHA_ARB
		swigIntConstant( GL_OPERAND2_ALPHA_ARB, "GL_OPERAND2_ALPHA_ARB" );
	#endif
	#ifdef GL_RGB_SCALE_ARB
		swigIntConstant( GL_RGB_SCALE_ARB, "GL_RGB_SCALE_ARB" );
	#endif
	#ifdef GL_ADD_SIGNED_ARB
		swigIntConstant( GL_ADD_SIGNED_ARB, "GL_ADD_SIGNED_ARB" );
	#endif
	#ifdef GL_INTERPOLATE_ARB
		swigIntConstant( GL_INTERPOLATE_ARB, "GL_INTERPOLATE_ARB" );
	#endif
	#ifdef GL_SUBTRACT_ARB
		swigIntConstant( GL_SUBTRACT_ARB, "GL_SUBTRACT_ARB" );
	#endif
	#ifdef GL_CONSTANT_ARB
		swigIntConstant( GL_CONSTANT_ARB, "GL_CONSTANT_ARB" );
	#endif
	#ifdef GL_PRIMARY_COLOR_ARB
		swigIntConstant( GL_PRIMARY_COLOR_ARB, "GL_PRIMARY_COLOR_ARB" );
	#endif
	#ifdef GL_PREVIOUS_ARB
		swigIntConstant( GL_PREVIOUS_ARB, "GL_PREVIOUS_ARB" );
	#endif
	#ifdef GL_ARB_texture_env_crossbar
		swigIntConstant( GL_ARB_texture_env_crossbar, "GL_ARB_texture_env_crossbar" );
	#endif
	#ifdef GL_ARB_texture_env_dot3
		swigIntConstant( GL_ARB_texture_env_dot3, "GL_ARB_texture_env_dot3" );
	#endif
	#ifdef GL_DOT3_RGB_ARB
		swigIntConstant( GL_DOT3_RGB_ARB, "GL_DOT3_RGB_ARB" );
	#endif
	#ifdef GL_DOT3_RGBA_ARB
		swigIntConstant( GL_DOT3_RGBA_ARB, "GL_DOT3_RGBA_ARB" );
	#endif
	#ifdef GL_ARB_texture_filter_anisotropic
		swigIntConstant( GL_ARB_texture_filter_anisotropic, "GL_ARB_texture_filter_anisotropic" );
	#endif
	#ifdef GL_ARB_texture_filter_minmax
		swigIntConstant( GL_ARB_texture_filter_minmax, "GL_ARB_texture_filter_minmax" );
	#endif
	#ifdef GL_TEXTURE_REDUCTION_MODE_ARB
		swigIntConstant( GL_TEXTURE_REDUCTION_MODE_ARB, "GL_TEXTURE_REDUCTION_MODE_ARB" );
	#endif
	#ifdef GL_WEIGHTED_AVERAGE_ARB
		swigIntConstant( GL_WEIGHTED_AVERAGE_ARB, "GL_WEIGHTED_AVERAGE_ARB" );
	#endif
	#ifdef GL_ARB_texture_float
		swigIntConstant( GL_ARB_texture_float, "GL_ARB_texture_float" );
	#endif
	#ifdef GL_TEXTURE_RED_TYPE_ARB
		swigIntConstant( GL_TEXTURE_RED_TYPE_ARB, "GL_TEXTURE_RED_TYPE_ARB" );
	#endif
	#ifdef GL_TEXTURE_GREEN_TYPE_ARB
		swigIntConstant( GL_TEXTURE_GREEN_TYPE_ARB, "GL_TEXTURE_GREEN_TYPE_ARB" );
	#endif
	#ifdef GL_TEXTURE_BLUE_TYPE_ARB
		swigIntConstant( GL_TEXTURE_BLUE_TYPE_ARB, "GL_TEXTURE_BLUE_TYPE_ARB" );
	#endif
	#ifdef GL_TEXTURE_ALPHA_TYPE_ARB
		swigIntConstant( GL_TEXTURE_ALPHA_TYPE_ARB, "GL_TEXTURE_ALPHA_TYPE_ARB" );
	#endif
	#ifdef GL_TEXTURE_LUMINANCE_TYPE_ARB
		swigIntConstant( GL_TEXTURE_LUMINANCE_TYPE_ARB, "GL_TEXTURE_LUMINANCE_TYPE_ARB" );
	#endif
	#ifdef GL_TEXTURE_INTENSITY_TYPE_ARB
		swigIntConstant( GL_TEXTURE_INTENSITY_TYPE_ARB, "GL_TEXTURE_INTENSITY_TYPE_ARB" );
	#endif
	#ifdef GL_TEXTURE_DEPTH_TYPE_ARB
		swigIntConstant( GL_TEXTURE_DEPTH_TYPE_ARB, "GL_TEXTURE_DEPTH_TYPE_ARB" );
	#endif
	#ifdef GL_UNSIGNED_NORMALIZED_ARB
		swigIntConstant( GL_UNSIGNED_NORMALIZED_ARB, "GL_UNSIGNED_NORMALIZED_ARB" );
	#endif
	#ifdef GL_RGBA32F_ARB
		swigIntConstant( GL_RGBA32F_ARB, "GL_RGBA32F_ARB" );
	#endif
	#ifdef GL_RGB32F_ARB
		swigIntConstant( GL_RGB32F_ARB, "GL_RGB32F_ARB" );
	#endif
	#ifdef GL_ALPHA32F_ARB
		swigIntConstant( GL_ALPHA32F_ARB, "GL_ALPHA32F_ARB" );
	#endif
	#ifdef GL_INTENSITY32F_ARB
		swigIntConstant( GL_INTENSITY32F_ARB, "GL_INTENSITY32F_ARB" );
	#endif
	#ifdef GL_LUMINANCE32F_ARB
		swigIntConstant( GL_LUMINANCE32F_ARB, "GL_LUMINANCE32F_ARB" );
	#endif
	#ifdef GL_LUMINANCE_ALPHA32F_ARB
		swigIntConstant( GL_LUMINANCE_ALPHA32F_ARB, "GL_LUMINANCE_ALPHA32F_ARB" );
	#endif
	#ifdef GL_RGBA16F_ARB
		swigIntConstant( GL_RGBA16F_ARB, "GL_RGBA16F_ARB" );
	#endif
	#ifdef GL_RGB16F_ARB
		swigIntConstant( GL_RGB16F_ARB, "GL_RGB16F_ARB" );
	#endif
	#ifdef GL_ALPHA16F_ARB
		swigIntConstant( GL_ALPHA16F_ARB, "GL_ALPHA16F_ARB" );
	#endif
	#ifdef GL_INTENSITY16F_ARB
		swigIntConstant( GL_INTENSITY16F_ARB, "GL_INTENSITY16F_ARB" );
	#endif
	#ifdef GL_LUMINANCE16F_ARB
		swigIntConstant( GL_LUMINANCE16F_ARB, "GL_LUMINANCE16F_ARB" );
	#endif
	#ifdef GL_LUMINANCE_ALPHA16F_ARB
		swigIntConstant( GL_LUMINANCE_ALPHA16F_ARB, "GL_LUMINANCE_ALPHA16F_ARB" );
	#endif
	#ifdef GL_ARB_texture_gather
		swigIntConstant( GL_ARB_texture_gather, "GL_ARB_texture_gather" );
	#endif
	#ifdef GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET_ARB
		swigIntConstant( GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET_ARB, "GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET_ARB" );
	#endif
	#ifdef GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET_ARB
		swigIntConstant( GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET_ARB, "GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET_ARB" );
	#endif
	#ifdef GL_MAX_PROGRAM_TEXTURE_GATHER_COMPONENTS_ARB
		swigIntConstant( GL_MAX_PROGRAM_TEXTURE_GATHER_COMPONENTS_ARB, "GL_MAX_PROGRAM_TEXTURE_GATHER_COMPONENTS_ARB" );
	#endif
	#ifdef GL_ARB_texture_mirror_clamp_to_edge
		swigIntConstant( GL_ARB_texture_mirror_clamp_to_edge, "GL_ARB_texture_mirror_clamp_to_edge" );
	#endif
	#ifdef GL_ARB_texture_mirrored_repeat
		swigIntConstant( GL_ARB_texture_mirrored_repeat, "GL_ARB_texture_mirrored_repeat" );
	#endif
	#ifdef GL_MIRRORED_REPEAT_ARB
		swigIntConstant( GL_MIRRORED_REPEAT_ARB, "GL_MIRRORED_REPEAT_ARB" );
	#endif
	#ifdef GL_ARB_texture_multisample
		swigIntConstant( GL_ARB_texture_multisample, "GL_ARB_texture_multisample" );
	#endif
	#ifdef GL_ARB_texture_non_power_of_two
		swigIntConstant( GL_ARB_texture_non_power_of_two, "GL_ARB_texture_non_power_of_two" );
	#endif
	#ifdef GL_ARB_texture_query_levels
		swigIntConstant( GL_ARB_texture_query_levels, "GL_ARB_texture_query_levels" );
	#endif
	#ifdef GL_ARB_texture_query_lod
		swigIntConstant( GL_ARB_texture_query_lod, "GL_ARB_texture_query_lod" );
	#endif
	#ifdef GL_ARB_texture_rectangle
		swigIntConstant( GL_ARB_texture_rectangle, "GL_ARB_texture_rectangle" );
	#endif
	#ifdef GL_TEXTURE_RECTANGLE_ARB
		swigIntConstant( GL_TEXTURE_RECTANGLE_ARB, "GL_TEXTURE_RECTANGLE_ARB" );
	#endif
	#ifdef GL_TEXTURE_BINDING_RECTANGLE_ARB
		swigIntConstant( GL_TEXTURE_BINDING_RECTANGLE_ARB, "GL_TEXTURE_BINDING_RECTANGLE_ARB" );
	#endif
	#ifdef GL_PROXY_TEXTURE_RECTANGLE_ARB
		swigIntConstant( GL_PROXY_TEXTURE_RECTANGLE_ARB, "GL_PROXY_TEXTURE_RECTANGLE_ARB" );
	#endif
	#ifdef GL_MAX_RECTANGLE_TEXTURE_SIZE_ARB
		swigIntConstant( GL_MAX_RECTANGLE_TEXTURE_SIZE_ARB, "GL_MAX_RECTANGLE_TEXTURE_SIZE_ARB" );
	#endif
	#ifdef GL_ARB_texture_rg
		swigIntConstant( GL_ARB_texture_rg, "GL_ARB_texture_rg" );
	#endif
	#ifdef GL_ARB_texture_rgb10_a2ui
		swigIntConstant( GL_ARB_texture_rgb10_a2ui, "GL_ARB_texture_rgb10_a2ui" );
	#endif
	#ifdef GL_ARB_texture_stencil8
		swigIntConstant( GL_ARB_texture_stencil8, "GL_ARB_texture_stencil8" );
	#endif
	#ifdef GL_ARB_texture_storage
		swigIntConstant( GL_ARB_texture_storage, "GL_ARB_texture_storage" );
	#endif
	#ifdef GL_ARB_texture_storage_multisample
		swigIntConstant( GL_ARB_texture_storage_multisample, "GL_ARB_texture_storage_multisample" );
	#endif
	#ifdef GL_ARB_texture_swizzle
		swigIntConstant( GL_ARB_texture_swizzle, "GL_ARB_texture_swizzle" );
	#endif
	#ifdef GL_ARB_texture_view
		swigIntConstant( GL_ARB_texture_view, "GL_ARB_texture_view" );
	#endif
	#ifdef GL_ARB_timer_query
		swigIntConstant( GL_ARB_timer_query, "GL_ARB_timer_query" );
	#endif
	#ifdef GL_ARB_transform_feedback2
		swigIntConstant( GL_ARB_transform_feedback2, "GL_ARB_transform_feedback2" );
	#endif
	#ifdef GL_ARB_transform_feedback3
		swigIntConstant( GL_ARB_transform_feedback3, "GL_ARB_transform_feedback3" );
	#endif
	#ifdef GL_ARB_transform_feedback_instanced
		swigIntConstant( GL_ARB_transform_feedback_instanced, "GL_ARB_transform_feedback_instanced" );
	#endif
	#ifdef GL_ARB_transform_feedback_overflow_query
		swigIntConstant( GL_ARB_transform_feedback_overflow_query, "GL_ARB_transform_feedback_overflow_query" );
	#endif
	#ifdef GL_TRANSFORM_FEEDBACK_OVERFLOW_ARB
		swigIntConstant( GL_TRANSFORM_FEEDBACK_OVERFLOW_ARB, "GL_TRANSFORM_FEEDBACK_OVERFLOW_ARB" );
	#endif
	#ifdef GL_TRANSFORM_FEEDBACK_STREAM_OVERFLOW_ARB
		swigIntConstant( GL_TRANSFORM_FEEDBACK_STREAM_OVERFLOW_ARB, "GL_TRANSFORM_FEEDBACK_STREAM_OVERFLOW_ARB" );
	#endif
	#ifdef GL_ARB_transpose_matrix
		swigIntConstant( GL_ARB_transpose_matrix, "GL_ARB_transpose_matrix" );
	#endif
	#ifdef GL_TRANSPOSE_MODELVIEW_MATRIX_ARB
		swigIntConstant( GL_TRANSPOSE_MODELVIEW_MATRIX_ARB, "GL_TRANSPOSE_MODELVIEW_MATRIX_ARB" );
	#endif
	#ifdef GL_TRANSPOSE_PROJECTION_MATRIX_ARB
		swigIntConstant( GL_TRANSPOSE_PROJECTION_MATRIX_ARB, "GL_TRANSPOSE_PROJECTION_MATRIX_ARB" );
	#endif
	#ifdef GL_TRANSPOSE_TEXTURE_MATRIX_ARB
		swigIntConstant( GL_TRANSPOSE_TEXTURE_MATRIX_ARB, "GL_TRANSPOSE_TEXTURE_MATRIX_ARB" );
	#endif
	#ifdef GL_TRANSPOSE_COLOR_MATRIX_ARB
		swigIntConstant( GL_TRANSPOSE_COLOR_MATRIX_ARB, "GL_TRANSPOSE_COLOR_MATRIX_ARB" );
	#endif
	#ifdef GL_ARB_uniform_buffer_object
		swigIntConstant( GL_ARB_uniform_buffer_object, "GL_ARB_uniform_buffer_object" );
	#endif
	#ifdef GL_ARB_vertex_array_bgra
		swigIntConstant( GL_ARB_vertex_array_bgra, "GL_ARB_vertex_array_bgra" );
	#endif
	#ifdef GL_ARB_vertex_array_object
		swigIntConstant( GL_ARB_vertex_array_object, "GL_ARB_vertex_array_object" );
	#endif
	#ifdef GL_ARB_vertex_attrib_64bit
		swigIntConstant( GL_ARB_vertex_attrib_64bit, "GL_ARB_vertex_attrib_64bit" );
	#endif
	#ifdef GL_ARB_vertex_attrib_binding
		swigIntConstant( GL_ARB_vertex_attrib_binding, "GL_ARB_vertex_attrib_binding" );
	#endif
	#ifdef GL_ARB_vertex_blend
		swigIntConstant( GL_ARB_vertex_blend, "GL_ARB_vertex_blend" );
	#endif
	#ifdef GL_MAX_VERTEX_UNITS_ARB
		swigIntConstant( GL_MAX_VERTEX_UNITS_ARB, "GL_MAX_VERTEX_UNITS_ARB" );
	#endif
	#ifdef GL_ACTIVE_VERTEX_UNITS_ARB
		swigIntConstant( GL_ACTIVE_VERTEX_UNITS_ARB, "GL_ACTIVE_VERTEX_UNITS_ARB" );
	#endif
	#ifdef GL_WEIGHT_SUM_UNITY_ARB
		swigIntConstant( GL_WEIGHT_SUM_UNITY_ARB, "GL_WEIGHT_SUM_UNITY_ARB" );
	#endif
	#ifdef GL_VERTEX_BLEND_ARB
		swigIntConstant( GL_VERTEX_BLEND_ARB, "GL_VERTEX_BLEND_ARB" );
	#endif
	#ifdef GL_CURRENT_WEIGHT_ARB
		swigIntConstant( GL_CURRENT_WEIGHT_ARB, "GL_CURRENT_WEIGHT_ARB" );
	#endif
	#ifdef GL_WEIGHT_ARRAY_TYPE_ARB
		swigIntConstant( GL_WEIGHT_ARRAY_TYPE_ARB, "GL_WEIGHT_ARRAY_TYPE_ARB" );
	#endif
	#ifdef GL_WEIGHT_ARRAY_STRIDE_ARB
		swigIntConstant( GL_WEIGHT_ARRAY_STRIDE_ARB, "GL_WEIGHT_ARRAY_STRIDE_ARB" );
	#endif
	#ifdef GL_WEIGHT_ARRAY_SIZE_ARB
		swigIntConstant( GL_WEIGHT_ARRAY_SIZE_ARB, "GL_WEIGHT_ARRAY_SIZE_ARB" );
	#endif
	#ifdef GL_WEIGHT_ARRAY_POINTER_ARB
		swigIntConstant( GL_WEIGHT_ARRAY_POINTER_ARB, "GL_WEIGHT_ARRAY_POINTER_ARB" );
	#endif
	#ifdef GL_WEIGHT_ARRAY_ARB
		swigIntConstant( GL_WEIGHT_ARRAY_ARB, "GL_WEIGHT_ARRAY_ARB" );
	#endif
	#ifdef GL_MODELVIEW0_ARB
		swigIntConstant( GL_MODELVIEW0_ARB, "GL_MODELVIEW0_ARB" );
	#endif
	#ifdef GL_MODELVIEW1_ARB
		swigIntConstant( GL_MODELVIEW1_ARB, "GL_MODELVIEW1_ARB" );
	#endif
	#ifdef GL_MODELVIEW2_ARB
		swigIntConstant( GL_MODELVIEW2_ARB, "GL_MODELVIEW2_ARB" );
	#endif
	#ifdef GL_MODELVIEW3_ARB
		swigIntConstant( GL_MODELVIEW3_ARB, "GL_MODELVIEW3_ARB" );
	#endif
	#ifdef GL_MODELVIEW4_ARB
		swigIntConstant( GL_MODELVIEW4_ARB, "GL_MODELVIEW4_ARB" );
	#endif
	#ifdef GL_MODELVIEW5_ARB
		swigIntConstant( GL_MODELVIEW5_ARB, "GL_MODELVIEW5_ARB" );
	#endif
	#ifdef GL_MODELVIEW6_ARB
		swigIntConstant( GL_MODELVIEW6_ARB, "GL_MODELVIEW6_ARB" );
	#endif
	#ifdef GL_MODELVIEW7_ARB
		swigIntConstant( GL_MODELVIEW7_ARB, "GL_MODELVIEW7_ARB" );
	#endif
	#ifdef GL_MODELVIEW8_ARB
		swigIntConstant( GL_MODELVIEW8_ARB, "GL_MODELVIEW8_ARB" );
	#endif
	#ifdef GL_MODELVIEW9_ARB
		swigIntConstant( GL_MODELVIEW9_ARB, "GL_MODELVIEW9_ARB" );
	#endif
	#ifdef GL_MODELVIEW10_ARB
		swigIntConstant( GL_MODELVIEW10_ARB, "GL_MODELVIEW10_ARB" );
	#endif
	#ifdef GL_MODELVIEW11_ARB
		swigIntConstant( GL_MODELVIEW11_ARB, "GL_MODELVIEW11_ARB" );
	#endif
	#ifdef GL_MODELVIEW12_ARB
		swigIntConstant( GL_MODELVIEW12_ARB, "GL_MODELVIEW12_ARB" );
	#endif
	#ifdef GL_MODELVIEW13_ARB
		swigIntConstant( GL_MODELVIEW13_ARB, "GL_MODELVIEW13_ARB" );
	#endif
	#ifdef GL_MODELVIEW14_ARB
		swigIntConstant( GL_MODELVIEW14_ARB, "GL_MODELVIEW14_ARB" );
	#endif
	#ifdef GL_MODELVIEW15_ARB
		swigIntConstant( GL_MODELVIEW15_ARB, "GL_MODELVIEW15_ARB" );
	#endif
	#ifdef GL_MODELVIEW16_ARB
		swigIntConstant( GL_MODELVIEW16_ARB, "GL_MODELVIEW16_ARB" );
	#endif
	#ifdef GL_MODELVIEW17_ARB
		swigIntConstant( GL_MODELVIEW17_ARB, "GL_MODELVIEW17_ARB" );
	#endif
	#ifdef GL_MODELVIEW18_ARB
		swigIntConstant( GL_MODELVIEW18_ARB, "GL_MODELVIEW18_ARB" );
	#endif
	#ifdef GL_MODELVIEW19_ARB
		swigIntConstant( GL_MODELVIEW19_ARB, "GL_MODELVIEW19_ARB" );
	#endif
	#ifdef GL_MODELVIEW20_ARB
		swigIntConstant( GL_MODELVIEW20_ARB, "GL_MODELVIEW20_ARB" );
	#endif
	#ifdef GL_MODELVIEW21_ARB
		swigIntConstant( GL_MODELVIEW21_ARB, "GL_MODELVIEW21_ARB" );
	#endif
	#ifdef GL_MODELVIEW22_ARB
		swigIntConstant( GL_MODELVIEW22_ARB, "GL_MODELVIEW22_ARB" );
	#endif
	#ifdef GL_MODELVIEW23_ARB
		swigIntConstant( GL_MODELVIEW23_ARB, "GL_MODELVIEW23_ARB" );
	#endif
	#ifdef GL_MODELVIEW24_ARB
		swigIntConstant( GL_MODELVIEW24_ARB, "GL_MODELVIEW24_ARB" );
	#endif
	#ifdef GL_MODELVIEW25_ARB
		swigIntConstant( GL_MODELVIEW25_ARB, "GL_MODELVIEW25_ARB" );
	#endif
	#ifdef GL_MODELVIEW26_ARB
		swigIntConstant( GL_MODELVIEW26_ARB, "GL_MODELVIEW26_ARB" );
	#endif
	#ifdef GL_MODELVIEW27_ARB
		swigIntConstant( GL_MODELVIEW27_ARB, "GL_MODELVIEW27_ARB" );
	#endif
	#ifdef GL_MODELVIEW28_ARB
		swigIntConstant( GL_MODELVIEW28_ARB, "GL_MODELVIEW28_ARB" );
	#endif
	#ifdef GL_MODELVIEW29_ARB
		swigIntConstant( GL_MODELVIEW29_ARB, "GL_MODELVIEW29_ARB" );
	#endif
	#ifdef GL_MODELVIEW30_ARB
		swigIntConstant( GL_MODELVIEW30_ARB, "GL_MODELVIEW30_ARB" );
	#endif
	#ifdef GL_MODELVIEW31_ARB
		swigIntConstant( GL_MODELVIEW31_ARB, "GL_MODELVIEW31_ARB" );
	#endif
	#ifdef GL_ARB_vertex_buffer_object
		swigIntConstant( GL_ARB_vertex_buffer_object, "GL_ARB_vertex_buffer_object" );
	#endif
	#ifdef GL_BUFFER_SIZE_ARB
		swigIntConstant( GL_BUFFER_SIZE_ARB, "GL_BUFFER_SIZE_ARB" );
	#endif
	#ifdef GL_BUFFER_USAGE_ARB
		swigIntConstant( GL_BUFFER_USAGE_ARB, "GL_BUFFER_USAGE_ARB" );
	#endif
	#ifdef GL_ARRAY_BUFFER_ARB
		swigIntConstant( GL_ARRAY_BUFFER_ARB, "GL_ARRAY_BUFFER_ARB" );
	#endif
	#ifdef GL_ELEMENT_ARRAY_BUFFER_ARB
		swigIntConstant( GL_ELEMENT_ARRAY_BUFFER_ARB, "GL_ELEMENT_ARRAY_BUFFER_ARB" );
	#endif
	#ifdef GL_ARRAY_BUFFER_BINDING_ARB
		swigIntConstant( GL_ARRAY_BUFFER_BINDING_ARB, "GL_ARRAY_BUFFER_BINDING_ARB" );
	#endif
	#ifdef GL_ELEMENT_ARRAY_BUFFER_BINDING_ARB
		swigIntConstant( GL_ELEMENT_ARRAY_BUFFER_BINDING_ARB, "GL_ELEMENT_ARRAY_BUFFER_BINDING_ARB" );
	#endif
	#ifdef GL_VERTEX_ARRAY_BUFFER_BINDING_ARB
		swigIntConstant( GL_VERTEX_ARRAY_BUFFER_BINDING_ARB, "GL_VERTEX_ARRAY_BUFFER_BINDING_ARB" );
	#endif
	#ifdef GL_NORMAL_ARRAY_BUFFER_BINDING_ARB
		swigIntConstant( GL_NORMAL_ARRAY_BUFFER_BINDING_ARB, "GL_NORMAL_ARRAY_BUFFER_BINDING_ARB" );
	#endif
	#ifdef GL_COLOR_ARRAY_BUFFER_BINDING_ARB
		swigIntConstant( GL_COLOR_ARRAY_BUFFER_BINDING_ARB, "GL_COLOR_ARRAY_BUFFER_BINDING_ARB" );
	#endif
	#ifdef GL_INDEX_ARRAY_BUFFER_BINDING_ARB
		swigIntConstant( GL_INDEX_ARRAY_BUFFER_BINDING_ARB, "GL_INDEX_ARRAY_BUFFER_BINDING_ARB" );
	#endif
	#ifdef GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING_ARB
		swigIntConstant( GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING_ARB, "GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING_ARB" );
	#endif
	#ifdef GL_EDGE_FLAG_ARRAY_BUFFER_BINDING_ARB
		swigIntConstant( GL_EDGE_FLAG_ARRAY_BUFFER_BINDING_ARB, "GL_EDGE_FLAG_ARRAY_BUFFER_BINDING_ARB" );
	#endif
	#ifdef GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING_ARB
		swigIntConstant( GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING_ARB, "GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING_ARB" );
	#endif
	#ifdef GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING_ARB
		swigIntConstant( GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING_ARB, "GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING_ARB" );
	#endif
	#ifdef GL_WEIGHT_ARRAY_BUFFER_BINDING_ARB
		swigIntConstant( GL_WEIGHT_ARRAY_BUFFER_BINDING_ARB, "GL_WEIGHT_ARRAY_BUFFER_BINDING_ARB" );
	#endif
	#ifdef GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING_ARB
		swigIntConstant( GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING_ARB, "GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING_ARB" );
	#endif
	#ifdef GL_READ_ONLY_ARB
		swigIntConstant( GL_READ_ONLY_ARB, "GL_READ_ONLY_ARB" );
	#endif
	#ifdef GL_WRITE_ONLY_ARB
		swigIntConstant( GL_WRITE_ONLY_ARB, "GL_WRITE_ONLY_ARB" );
	#endif
	#ifdef GL_READ_WRITE_ARB
		swigIntConstant( GL_READ_WRITE_ARB, "GL_READ_WRITE_ARB" );
	#endif
	#ifdef GL_BUFFER_ACCESS_ARB
		swigIntConstant( GL_BUFFER_ACCESS_ARB, "GL_BUFFER_ACCESS_ARB" );
	#endif
	#ifdef GL_BUFFER_MAPPED_ARB
		swigIntConstant( GL_BUFFER_MAPPED_ARB, "GL_BUFFER_MAPPED_ARB" );
	#endif
	#ifdef GL_BUFFER_MAP_POINTER_ARB
		swigIntConstant( GL_BUFFER_MAP_POINTER_ARB, "GL_BUFFER_MAP_POINTER_ARB" );
	#endif
	#ifdef GL_STREAM_DRAW_ARB
		swigIntConstant( GL_STREAM_DRAW_ARB, "GL_STREAM_DRAW_ARB" );
	#endif
	#ifdef GL_STREAM_READ_ARB
		swigIntConstant( GL_STREAM_READ_ARB, "GL_STREAM_READ_ARB" );
	#endif
	#ifdef GL_STREAM_COPY_ARB
		swigIntConstant( GL_STREAM_COPY_ARB, "GL_STREAM_COPY_ARB" );
	#endif
	#ifdef GL_STATIC_DRAW_ARB
		swigIntConstant( GL_STATIC_DRAW_ARB, "GL_STATIC_DRAW_ARB" );
	#endif
	#ifdef GL_STATIC_READ_ARB
		swigIntConstant( GL_STATIC_READ_ARB, "GL_STATIC_READ_ARB" );
	#endif
	#ifdef GL_STATIC_COPY_ARB
		swigIntConstant( GL_STATIC_COPY_ARB, "GL_STATIC_COPY_ARB" );
	#endif
	#ifdef GL_DYNAMIC_DRAW_ARB
		swigIntConstant( GL_DYNAMIC_DRAW_ARB, "GL_DYNAMIC_DRAW_ARB" );
	#endif
	#ifdef GL_DYNAMIC_READ_ARB
		swigIntConstant( GL_DYNAMIC_READ_ARB, "GL_DYNAMIC_READ_ARB" );
	#endif
	#ifdef GL_DYNAMIC_COPY_ARB
		swigIntConstant( GL_DYNAMIC_COPY_ARB, "GL_DYNAMIC_COPY_ARB" );
	#endif
	#ifdef GL_ARB_vertex_program
		swigIntConstant( GL_ARB_vertex_program, "GL_ARB_vertex_program" );
	#endif
	#ifdef GL_COLOR_SUM_ARB
		swigIntConstant( GL_COLOR_SUM_ARB, "GL_COLOR_SUM_ARB" );
	#endif
	#ifdef GL_VERTEX_PROGRAM_ARB
		swigIntConstant( GL_VERTEX_PROGRAM_ARB, "GL_VERTEX_PROGRAM_ARB" );
	#endif
	#ifdef GL_VERTEX_ATTRIB_ARRAY_ENABLED_ARB
		swigIntConstant( GL_VERTEX_ATTRIB_ARRAY_ENABLED_ARB, "GL_VERTEX_ATTRIB_ARRAY_ENABLED_ARB" );
	#endif
	#ifdef GL_VERTEX_ATTRIB_ARRAY_SIZE_ARB
		swigIntConstant( GL_VERTEX_ATTRIB_ARRAY_SIZE_ARB, "GL_VERTEX_ATTRIB_ARRAY_SIZE_ARB" );
	#endif
	#ifdef GL_VERTEX_ATTRIB_ARRAY_STRIDE_ARB
		swigIntConstant( GL_VERTEX_ATTRIB_ARRAY_STRIDE_ARB, "GL_VERTEX_ATTRIB_ARRAY_STRIDE_ARB" );
	#endif
	#ifdef GL_VERTEX_ATTRIB_ARRAY_TYPE_ARB
		swigIntConstant( GL_VERTEX_ATTRIB_ARRAY_TYPE_ARB, "GL_VERTEX_ATTRIB_ARRAY_TYPE_ARB" );
	#endif
	#ifdef GL_CURRENT_VERTEX_ATTRIB_ARB
		swigIntConstant( GL_CURRENT_VERTEX_ATTRIB_ARB, "GL_CURRENT_VERTEX_ATTRIB_ARB" );
	#endif
	#ifdef GL_VERTEX_PROGRAM_POINT_SIZE_ARB
		swigIntConstant( GL_VERTEX_PROGRAM_POINT_SIZE_ARB, "GL_VERTEX_PROGRAM_POINT_SIZE_ARB" );
	#endif
	#ifdef GL_VERTEX_PROGRAM_TWO_SIDE_ARB
		swigIntConstant( GL_VERTEX_PROGRAM_TWO_SIDE_ARB, "GL_VERTEX_PROGRAM_TWO_SIDE_ARB" );
	#endif
	#ifdef GL_VERTEX_ATTRIB_ARRAY_POINTER_ARB
		swigIntConstant( GL_VERTEX_ATTRIB_ARRAY_POINTER_ARB, "GL_VERTEX_ATTRIB_ARRAY_POINTER_ARB" );
	#endif
	#ifdef GL_MAX_VERTEX_ATTRIBS_ARB
		swigIntConstant( GL_MAX_VERTEX_ATTRIBS_ARB, "GL_MAX_VERTEX_ATTRIBS_ARB" );
	#endif
	#ifdef GL_VERTEX_ATTRIB_ARRAY_NORMALIZED_ARB
		swigIntConstant( GL_VERTEX_ATTRIB_ARRAY_NORMALIZED_ARB, "GL_VERTEX_ATTRIB_ARRAY_NORMALIZED_ARB" );
	#endif
	#ifdef GL_PROGRAM_ADDRESS_REGISTERS_ARB
		swigIntConstant( GL_PROGRAM_ADDRESS_REGISTERS_ARB, "GL_PROGRAM_ADDRESS_REGISTERS_ARB" );
	#endif
	#ifdef GL_MAX_PROGRAM_ADDRESS_REGISTERS_ARB
		swigIntConstant( GL_MAX_PROGRAM_ADDRESS_REGISTERS_ARB, "GL_MAX_PROGRAM_ADDRESS_REGISTERS_ARB" );
	#endif
	#ifdef GL_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB
		swigIntConstant( GL_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB, "GL_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB" );
	#endif
	#ifdef GL_MAX_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB
		swigIntConstant( GL_MAX_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB, "GL_MAX_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB" );
	#endif
	#ifdef GL_ARB_vertex_shader
		swigIntConstant( GL_ARB_vertex_shader, "GL_ARB_vertex_shader" );
	#endif
	#ifdef GL_VERTEX_SHADER_ARB
		swigIntConstant( GL_VERTEX_SHADER_ARB, "GL_VERTEX_SHADER_ARB" );
	#endif
	#ifdef GL_MAX_VERTEX_UNIFORM_COMPONENTS_ARB
		swigIntConstant( GL_MAX_VERTEX_UNIFORM_COMPONENTS_ARB, "GL_MAX_VERTEX_UNIFORM_COMPONENTS_ARB" );
	#endif
	#ifdef GL_MAX_VARYING_FLOATS_ARB
		swigIntConstant( GL_MAX_VARYING_FLOATS_ARB, "GL_MAX_VARYING_FLOATS_ARB" );
	#endif
	#ifdef GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS_ARB
		swigIntConstant( GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS_ARB, "GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS_ARB" );
	#endif
	#ifdef GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS_ARB
		swigIntConstant( GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS_ARB, "GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS_ARB" );
	#endif
	#ifdef GL_OBJECT_ACTIVE_ATTRIBUTES_ARB
		swigIntConstant( GL_OBJECT_ACTIVE_ATTRIBUTES_ARB, "GL_OBJECT_ACTIVE_ATTRIBUTES_ARB" );
	#endif
	#ifdef GL_OBJECT_ACTIVE_ATTRIBUTE_MAX_LENGTH_ARB
		swigIntConstant( GL_OBJECT_ACTIVE_ATTRIBUTE_MAX_LENGTH_ARB, "GL_OBJECT_ACTIVE_ATTRIBUTE_MAX_LENGTH_ARB" );
	#endif
	#ifdef GL_ARB_vertex_type_10f_11f_11f_rev
		swigIntConstant( GL_ARB_vertex_type_10f_11f_11f_rev, "GL_ARB_vertex_type_10f_11f_11f_rev" );
	#endif
	#ifdef GL_ARB_vertex_type_2_10_10_10_rev
		swigIntConstant( GL_ARB_vertex_type_2_10_10_10_rev, "GL_ARB_vertex_type_2_10_10_10_rev" );
	#endif
	#ifdef GL_ARB_viewport_array
		swigIntConstant( GL_ARB_viewport_array, "GL_ARB_viewport_array" );
	#endif
	#ifdef GL_ARB_window_pos
		swigIntConstant( GL_ARB_window_pos, "GL_ARB_window_pos" );
	#endif
	#ifdef GL_KHR_blend_equation_advanced
		swigIntConstant( GL_KHR_blend_equation_advanced, "GL_KHR_blend_equation_advanced" );
	#endif
	#ifdef GL_MULTIPLY_KHR
		swigIntConstant( GL_MULTIPLY_KHR, "GL_MULTIPLY_KHR" );
	#endif
	#ifdef GL_SCREEN_KHR
		swigIntConstant( GL_SCREEN_KHR, "GL_SCREEN_KHR" );
	#endif
	#ifdef GL_OVERLAY_KHR
		swigIntConstant( GL_OVERLAY_KHR, "GL_OVERLAY_KHR" );
	#endif
	#ifdef GL_DARKEN_KHR
		swigIntConstant( GL_DARKEN_KHR, "GL_DARKEN_KHR" );
	#endif
	#ifdef GL_LIGHTEN_KHR
		swigIntConstant( GL_LIGHTEN_KHR, "GL_LIGHTEN_KHR" );
	#endif
	#ifdef GL_COLORDODGE_KHR
		swigIntConstant( GL_COLORDODGE_KHR, "GL_COLORDODGE_KHR" );
	#endif
	#ifdef GL_COLORBURN_KHR
		swigIntConstant( GL_COLORBURN_KHR, "GL_COLORBURN_KHR" );
	#endif
	#ifdef GL_HARDLIGHT_KHR
		swigIntConstant( GL_HARDLIGHT_KHR, "GL_HARDLIGHT_KHR" );
	#endif
	#ifdef GL_SOFTLIGHT_KHR
		swigIntConstant( GL_SOFTLIGHT_KHR, "GL_SOFTLIGHT_KHR" );
	#endif
	#ifdef GL_DIFFERENCE_KHR
		swigIntConstant( GL_DIFFERENCE_KHR, "GL_DIFFERENCE_KHR" );
	#endif
	#ifdef GL_EXCLUSION_KHR
		swigIntConstant( GL_EXCLUSION_KHR, "GL_EXCLUSION_KHR" );
	#endif
	#ifdef GL_HSL_HUE_KHR
		swigIntConstant( GL_HSL_HUE_KHR, "GL_HSL_HUE_KHR" );
	#endif
	#ifdef GL_HSL_SATURATION_KHR
		swigIntConstant( GL_HSL_SATURATION_KHR, "GL_HSL_SATURATION_KHR" );
	#endif
	#ifdef GL_HSL_COLOR_KHR
		swigIntConstant( GL_HSL_COLOR_KHR, "GL_HSL_COLOR_KHR" );
	#endif
	#ifdef GL_HSL_LUMINOSITY_KHR
		swigIntConstant( GL_HSL_LUMINOSITY_KHR, "GL_HSL_LUMINOSITY_KHR" );
	#endif
	#ifdef GL_KHR_blend_equation_advanced_coherent
		swigIntConstant( GL_KHR_blend_equation_advanced_coherent, "GL_KHR_blend_equation_advanced_coherent" );
	#endif
	#ifdef GL_BLEND_ADVANCED_COHERENT_KHR
		swigIntConstant( GL_BLEND_ADVANCED_COHERENT_KHR, "GL_BLEND_ADVANCED_COHERENT_KHR" );
	#endif
	#ifdef GL_KHR_context_flush_control
		swigIntConstant( GL_KHR_context_flush_control, "GL_KHR_context_flush_control" );
	#endif
	#ifdef GL_KHR_debug
		swigIntConstant( GL_KHR_debug, "GL_KHR_debug" );
	#endif
	#ifdef GL_KHR_no_error
		swigIntConstant( GL_KHR_no_error, "GL_KHR_no_error" );
	#endif
	#ifdef GL_CONTEXT_FLAG_NO_ERROR_BIT_KHR
		swigIntConstant( GL_CONTEXT_FLAG_NO_ERROR_BIT_KHR, "GL_CONTEXT_FLAG_NO_ERROR_BIT_KHR" );
	#endif
	#ifdef GL_KHR_parallel_shader_compile
		swigIntConstant( GL_KHR_parallel_shader_compile, "GL_KHR_parallel_shader_compile" );
	#endif
	#ifdef GL_MAX_SHADER_COMPILER_THREADS_KHR
		swigIntConstant( GL_MAX_SHADER_COMPILER_THREADS_KHR, "GL_MAX_SHADER_COMPILER_THREADS_KHR" );
	#endif
	#ifdef GL_COMPLETION_STATUS_KHR
		swigIntConstant( GL_COMPLETION_STATUS_KHR, "GL_COMPLETION_STATUS_KHR" );
	#endif
	#ifdef GL_KHR_robust_buffer_access_behavior
		swigIntConstant( GL_KHR_robust_buffer_access_behavior, "GL_KHR_robust_buffer_access_behavior" );
	#endif
	#ifdef GL_KHR_robustness
		swigIntConstant( GL_KHR_robustness, "GL_KHR_robustness" );
	#endif
	#ifdef GL_CONTEXT_ROBUST_ACCESS
		swigIntConstant( GL_CONTEXT_ROBUST_ACCESS, "GL_CONTEXT_ROBUST_ACCESS" );
	#endif
	#ifdef GL_KHR_shader_subgroup
		swigIntConstant( GL_KHR_shader_subgroup, "GL_KHR_shader_subgroup" );
	#endif
	#ifdef GL_SUBGROUP_SIZE_KHR
		swigIntConstant( GL_SUBGROUP_SIZE_KHR, "GL_SUBGROUP_SIZE_KHR" );
	#endif
	#ifdef GL_SUBGROUP_SUPPORTED_STAGES_KHR
		swigIntConstant( GL_SUBGROUP_SUPPORTED_STAGES_KHR, "GL_SUBGROUP_SUPPORTED_STAGES_KHR" );
	#endif
	#ifdef GL_SUBGROUP_SUPPORTED_FEATURES_KHR
		swigIntConstant( GL_SUBGROUP_SUPPORTED_FEATURES_KHR, "GL_SUBGROUP_SUPPORTED_FEATURES_KHR" );
	#endif
	#ifdef GL_SUBGROUP_QUAD_ALL_STAGES_KHR
		swigIntConstant( GL_SUBGROUP_QUAD_ALL_STAGES_KHR, "GL_SUBGROUP_QUAD_ALL_STAGES_KHR" );
	#endif
	#ifdef GL_SUBGROUP_FEATURE_BASIC_BIT_KHR
		swigIntConstant( GL_SUBGROUP_FEATURE_BASIC_BIT_KHR, "GL_SUBGROUP_FEATURE_BASIC_BIT_KHR" );
	#endif
	#ifdef GL_SUBGROUP_FEATURE_VOTE_BIT_KHR
		swigIntConstant( GL_SUBGROUP_FEATURE_VOTE_BIT_KHR, "GL_SUBGROUP_FEATURE_VOTE_BIT_KHR" );
	#endif
	#ifdef GL_SUBGROUP_FEATURE_ARITHMETIC_BIT_KHR
		swigIntConstant( GL_SUBGROUP_FEATURE_ARITHMETIC_BIT_KHR, "GL_SUBGROUP_FEATURE_ARITHMETIC_BIT_KHR" );
	#endif
	#ifdef GL_SUBGROUP_FEATURE_BALLOT_BIT_KHR
		swigIntConstant( GL_SUBGROUP_FEATURE_BALLOT_BIT_KHR, "GL_SUBGROUP_FEATURE_BALLOT_BIT_KHR" );
	#endif
	#ifdef GL_SUBGROUP_FEATURE_SHUFFLE_BIT_KHR
		swigIntConstant( GL_SUBGROUP_FEATURE_SHUFFLE_BIT_KHR, "GL_SUBGROUP_FEATURE_SHUFFLE_BIT_KHR" );
	#endif
	#ifdef GL_SUBGROUP_FEATURE_SHUFFLE_RELATIVE_BIT_KHR
		swigIntConstant( GL_SUBGROUP_FEATURE_SHUFFLE_RELATIVE_BIT_KHR, "GL_SUBGROUP_FEATURE_SHUFFLE_RELATIVE_BIT_KHR" );
	#endif
	#ifdef GL_SUBGROUP_FEATURE_CLUSTERED_BIT_KHR
		swigIntConstant( GL_SUBGROUP_FEATURE_CLUSTERED_BIT_KHR, "GL_SUBGROUP_FEATURE_CLUSTERED_BIT_KHR" );
	#endif
	#ifdef GL_SUBGROUP_FEATURE_QUAD_BIT_KHR
		swigIntConstant( GL_SUBGROUP_FEATURE_QUAD_BIT_KHR, "GL_SUBGROUP_FEATURE_QUAD_BIT_KHR" );
	#endif
	#ifdef GL_KHR_texture_compression_astc_hdr
		swigIntConstant( GL_KHR_texture_compression_astc_hdr, "GL_KHR_texture_compression_astc_hdr" );
	#endif
	#ifdef GL_COMPRESSED_RGBA_ASTC_4x4_KHR
		swigIntConstant( GL_COMPRESSED_RGBA_ASTC_4x4_KHR, "GL_COMPRESSED_RGBA_ASTC_4x4_KHR" );
	#endif
	#ifdef GL_COMPRESSED_RGBA_ASTC_5x4_KHR
		swigIntConstant( GL_COMPRESSED_RGBA_ASTC_5x4_KHR, "GL_COMPRESSED_RGBA_ASTC_5x4_KHR" );
	#endif
	#ifdef GL_COMPRESSED_RGBA_ASTC_5x5_KHR
		swigIntConstant( GL_COMPRESSED_RGBA_ASTC_5x5_KHR, "GL_COMPRESSED_RGBA_ASTC_5x5_KHR" );
	#endif
	#ifdef GL_COMPRESSED_RGBA_ASTC_6x5_KHR
		swigIntConstant( GL_COMPRESSED_RGBA_ASTC_6x5_KHR, "GL_COMPRESSED_RGBA_ASTC_6x5_KHR" );
	#endif
	#ifdef GL_COMPRESSED_RGBA_ASTC_6x6_KHR
		swigIntConstant( GL_COMPRESSED_RGBA_ASTC_6x6_KHR, "GL_COMPRESSED_RGBA_ASTC_6x6_KHR" );
	#endif
	#ifdef GL_COMPRESSED_RGBA_ASTC_8x5_KHR
		swigIntConstant( GL_COMPRESSED_RGBA_ASTC_8x5_KHR, "GL_COMPRESSED_RGBA_ASTC_8x5_KHR" );
	#endif
	#ifdef GL_COMPRESSED_RGBA_ASTC_8x6_KHR
		swigIntConstant( GL_COMPRESSED_RGBA_ASTC_8x6_KHR, "GL_COMPRESSED_RGBA_ASTC_8x6_KHR" );
	#endif
	#ifdef GL_COMPRESSED_RGBA_ASTC_8x8_KHR
		swigIntConstant( GL_COMPRESSED_RGBA_ASTC_8x8_KHR, "GL_COMPRESSED_RGBA_ASTC_8x8_KHR" );
	#endif
	#ifdef GL_COMPRESSED_RGBA_ASTC_10x5_KHR
		swigIntConstant( GL_COMPRESSED_RGBA_ASTC_10x5_KHR, "GL_COMPRESSED_RGBA_ASTC_10x5_KHR" );
	#endif
	#ifdef GL_COMPRESSED_RGBA_ASTC_10x6_KHR
		swigIntConstant( GL_COMPRESSED_RGBA_ASTC_10x6_KHR, "GL_COMPRESSED_RGBA_ASTC_10x6_KHR" );
	#endif
	#ifdef GL_COMPRESSED_RGBA_ASTC_10x8_KHR
		swigIntConstant( GL_COMPRESSED_RGBA_ASTC_10x8_KHR, "GL_COMPRESSED_RGBA_ASTC_10x8_KHR" );
	#endif
	#ifdef GL_COMPRESSED_RGBA_ASTC_10x10_KHR
		swigIntConstant( GL_COMPRESSED_RGBA_ASTC_10x10_KHR, "GL_COMPRESSED_RGBA_ASTC_10x10_KHR" );
	#endif
	#ifdef GL_COMPRESSED_RGBA_ASTC_12x10_KHR
		swigIntConstant( GL_COMPRESSED_RGBA_ASTC_12x10_KHR, "GL_COMPRESSED_RGBA_ASTC_12x10_KHR" );
	#endif
	#ifdef GL_COMPRESSED_RGBA_ASTC_12x12_KHR
		swigIntConstant( GL_COMPRESSED_RGBA_ASTC_12x12_KHR, "GL_COMPRESSED_RGBA_ASTC_12x12_KHR" );
	#endif
	#ifdef GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR
		swigIntConstant( GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR" );
	#endif
	#ifdef GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR
		swigIntConstant( GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR" );
	#endif
	#ifdef GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR
		swigIntConstant( GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR" );
	#endif
	#ifdef GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR
		swigIntConstant( GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR" );
	#endif
	#ifdef GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR
		swigIntConstant( GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR" );
	#endif
	#ifdef GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR
		swigIntConstant( GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR" );
	#endif
	#ifdef GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR
		swigIntConstant( GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR" );
	#endif
	#ifdef GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR
		swigIntConstant( GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR" );
	#endif
	#ifdef GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR
		swigIntConstant( GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR" );
	#endif
	#ifdef GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR
		swigIntConstant( GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR" );
	#endif
	#ifdef GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR
		swigIntConstant( GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR" );
	#endif
	#ifdef GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR
		swigIntConstant( GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR" );
	#endif
	#ifdef GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR
		swigIntConstant( GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR" );
	#endif
	#ifdef GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR
		swigIntConstant( GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR" );
	#endif
	#ifdef GL_KHR_texture_compression_astc_ldr
		swigIntConstant( GL_KHR_texture_compression_astc_ldr, "GL_KHR_texture_compression_astc_ldr" );
	#endif
	#ifdef GL_KHR_texture_compression_astc_sliced_3d
		swigIntConstant( GL_KHR_texture_compression_astc_sliced_3d, "GL_KHR_texture_compression_astc_sliced_3d" );
	#endif
	#ifdef GL_OES_byte_coordinates
		swigIntConstant( GL_OES_byte_coordinates, "GL_OES_byte_coordinates" );
	#endif
	#ifdef GL_OES_compressed_paletted_texture
		swigIntConstant( GL_OES_compressed_paletted_texture, "GL_OES_compressed_paletted_texture" );
	#endif
	#ifdef GL_PALETTE4_RGB8_OES
		swigIntConstant( GL_PALETTE4_RGB8_OES, "GL_PALETTE4_RGB8_OES" );
	#endif
	#ifdef GL_PALETTE4_RGBA8_OES
		swigIntConstant( GL_PALETTE4_RGBA8_OES, "GL_PALETTE4_RGBA8_OES" );
	#endif
	#ifdef GL_PALETTE4_R5_G6_B5_OES
		swigIntConstant( GL_PALETTE4_R5_G6_B5_OES, "GL_PALETTE4_R5_G6_B5_OES" );
	#endif
	#ifdef GL_PALETTE4_RGBA4_OES
		swigIntConstant( GL_PALETTE4_RGBA4_OES, "GL_PALETTE4_RGBA4_OES" );
	#endif
	#ifdef GL_PALETTE4_RGB5_A1_OES
		swigIntConstant( GL_PALETTE4_RGB5_A1_OES, "GL_PALETTE4_RGB5_A1_OES" );
	#endif
	#ifdef GL_PALETTE8_RGB8_OES
		swigIntConstant( GL_PALETTE8_RGB8_OES, "GL_PALETTE8_RGB8_OES" );
	#endif
	#ifdef GL_PALETTE8_RGBA8_OES
		swigIntConstant( GL_PALETTE8_RGBA8_OES, "GL_PALETTE8_RGBA8_OES" );
	#endif
	#ifdef GL_PALETTE8_R5_G6_B5_OES
		swigIntConstant( GL_PALETTE8_R5_G6_B5_OES, "GL_PALETTE8_R5_G6_B5_OES" );
	#endif
	#ifdef GL_PALETTE8_RGBA4_OES
		swigIntConstant( GL_PALETTE8_RGBA4_OES, "GL_PALETTE8_RGBA4_OES" );
	#endif
	#ifdef GL_PALETTE8_RGB5_A1_OES
		swigIntConstant( GL_PALETTE8_RGB5_A1_OES, "GL_PALETTE8_RGB5_A1_OES" );
	#endif
	#ifdef GL_OES_fixed_point
		swigIntConstant( GL_OES_fixed_point, "GL_OES_fixed_point" );
	#endif
	#ifdef GL_FIXED_OES
		swigIntConstant( GL_FIXED_OES, "GL_FIXED_OES" );
	#endif
	#ifdef GL_OES_query_matrix
		swigIntConstant( GL_OES_query_matrix, "GL_OES_query_matrix" );
	#endif
	#ifdef GL_OES_read_format
		swigIntConstant( GL_OES_read_format, "GL_OES_read_format" );
	#endif
	#ifdef GL_IMPLEMENTATION_COLOR_READ_TYPE_OES
		swigIntConstant( GL_IMPLEMENTATION_COLOR_READ_TYPE_OES, "GL_IMPLEMENTATION_COLOR_READ_TYPE_OES" );
	#endif
	#ifdef GL_IMPLEMENTATION_COLOR_READ_FORMAT_OES
		swigIntConstant( GL_IMPLEMENTATION_COLOR_READ_FORMAT_OES, "GL_IMPLEMENTATION_COLOR_READ_FORMAT_OES" );
	#endif
	#ifdef GL_OES_single_precision
		swigIntConstant( GL_OES_single_precision, "GL_OES_single_precision" );
	#endif
	#ifdef GL_3DFX_multisample
		swigIntConstant( GL_3DFX_multisample, "GL_3DFX_multisample" );
	#endif
	#ifdef GL_MULTISAMPLE_3DFX
		swigIntConstant( GL_MULTISAMPLE_3DFX, "GL_MULTISAMPLE_3DFX" );
	#endif
	#ifdef GL_SAMPLE_BUFFERS_3DFX
		swigIntConstant( GL_SAMPLE_BUFFERS_3DFX, "GL_SAMPLE_BUFFERS_3DFX" );
	#endif
	#ifdef GL_SAMPLES_3DFX
		swigIntConstant( GL_SAMPLES_3DFX, "GL_SAMPLES_3DFX" );
	#endif
	#ifdef GL_MULTISAMPLE_BIT_3DFX
		swigIntConstant( GL_MULTISAMPLE_BIT_3DFX, "GL_MULTISAMPLE_BIT_3DFX" );
	#endif
	#ifdef GL_3DFX_tbuffer
		swigIntConstant( GL_3DFX_tbuffer, "GL_3DFX_tbuffer" );
	#endif
	#ifdef GL_3DFX_texture_compression_FXT1
		swigIntConstant( GL_3DFX_texture_compression_FXT1, "GL_3DFX_texture_compression_FXT1" );
	#endif
	#ifdef GL_COMPRESSED_RGB_FXT1_3DFX
		swigIntConstant( GL_COMPRESSED_RGB_FXT1_3DFX, "GL_COMPRESSED_RGB_FXT1_3DFX" );
	#endif
	#ifdef GL_COMPRESSED_RGBA_FXT1_3DFX
		swigIntConstant( GL_COMPRESSED_RGBA_FXT1_3DFX, "GL_COMPRESSED_RGBA_FXT1_3DFX" );
	#endif
	#ifdef GL_AMD_blend_minmax_factor
		swigIntConstant( GL_AMD_blend_minmax_factor, "GL_AMD_blend_minmax_factor" );
	#endif
	#ifdef GL_FACTOR_MIN_AMD
		swigIntConstant( GL_FACTOR_MIN_AMD, "GL_FACTOR_MIN_AMD" );
	#endif
	#ifdef GL_FACTOR_MAX_AMD
		swigIntConstant( GL_FACTOR_MAX_AMD, "GL_FACTOR_MAX_AMD" );
	#endif
	#ifdef GL_AMD_conservative_depth
		swigIntConstant( GL_AMD_conservative_depth, "GL_AMD_conservative_depth" );
	#endif
	#ifdef GL_AMD_debug_output
		swigIntConstant( GL_AMD_debug_output, "GL_AMD_debug_output" );
	#endif
	#ifdef GL_MAX_DEBUG_MESSAGE_LENGTH_AMD
		swigIntConstant( GL_MAX_DEBUG_MESSAGE_LENGTH_AMD, "GL_MAX_DEBUG_MESSAGE_LENGTH_AMD" );
	#endif
	#ifdef GL_MAX_DEBUG_LOGGED_MESSAGES_AMD
		swigIntConstant( GL_MAX_DEBUG_LOGGED_MESSAGES_AMD, "GL_MAX_DEBUG_LOGGED_MESSAGES_AMD" );
	#endif
	#ifdef GL_DEBUG_LOGGED_MESSAGES_AMD
		swigIntConstant( GL_DEBUG_LOGGED_MESSAGES_AMD, "GL_DEBUG_LOGGED_MESSAGES_AMD" );
	#endif
	#ifdef GL_DEBUG_SEVERITY_HIGH_AMD
		swigIntConstant( GL_DEBUG_SEVERITY_HIGH_AMD, "GL_DEBUG_SEVERITY_HIGH_AMD" );
	#endif
	#ifdef GL_DEBUG_SEVERITY_MEDIUM_AMD
		swigIntConstant( GL_DEBUG_SEVERITY_MEDIUM_AMD, "GL_DEBUG_SEVERITY_MEDIUM_AMD" );
	#endif
	#ifdef GL_DEBUG_SEVERITY_LOW_AMD
		swigIntConstant( GL_DEBUG_SEVERITY_LOW_AMD, "GL_DEBUG_SEVERITY_LOW_AMD" );
	#endif
	#ifdef GL_DEBUG_CATEGORY_API_ERROR_AMD
		swigIntConstant( GL_DEBUG_CATEGORY_API_ERROR_AMD, "GL_DEBUG_CATEGORY_API_ERROR_AMD" );
	#endif
	#ifdef GL_DEBUG_CATEGORY_WINDOW_SYSTEM_AMD
		swigIntConstant( GL_DEBUG_CATEGORY_WINDOW_SYSTEM_AMD, "GL_DEBUG_CATEGORY_WINDOW_SYSTEM_AMD" );
	#endif
	#ifdef GL_DEBUG_CATEGORY_DEPRECATION_AMD
		swigIntConstant( GL_DEBUG_CATEGORY_DEPRECATION_AMD, "GL_DEBUG_CATEGORY_DEPRECATION_AMD" );
	#endif
	#ifdef GL_DEBUG_CATEGORY_UNDEFINED_BEHAVIOR_AMD
		swigIntConstant( GL_DEBUG_CATEGORY_UNDEFINED_BEHAVIOR_AMD, "GL_DEBUG_CATEGORY_UNDEFINED_BEHAVIOR_AMD" );
	#endif
	#ifdef GL_DEBUG_CATEGORY_PERFORMANCE_AMD
		swigIntConstant( GL_DEBUG_CATEGORY_PERFORMANCE_AMD, "GL_DEBUG_CATEGORY_PERFORMANCE_AMD" );
	#endif
	#ifdef GL_DEBUG_CATEGORY_SHADER_COMPILER_AMD
		swigIntConstant( GL_DEBUG_CATEGORY_SHADER_COMPILER_AMD, "GL_DEBUG_CATEGORY_SHADER_COMPILER_AMD" );
	#endif
	#ifdef GL_DEBUG_CATEGORY_APPLICATION_AMD
		swigIntConstant( GL_DEBUG_CATEGORY_APPLICATION_AMD, "GL_DEBUG_CATEGORY_APPLICATION_AMD" );
	#endif
	#ifdef GL_DEBUG_CATEGORY_OTHER_AMD
		swigIntConstant( GL_DEBUG_CATEGORY_OTHER_AMD, "GL_DEBUG_CATEGORY_OTHER_AMD" );
	#endif
	#ifdef GL_AMD_depth_clamp_separate
		swigIntConstant( GL_AMD_depth_clamp_separate, "GL_AMD_depth_clamp_separate" );
	#endif
	#ifdef GL_DEPTH_CLAMP_NEAR_AMD
		swigIntConstant( GL_DEPTH_CLAMP_NEAR_AMD, "GL_DEPTH_CLAMP_NEAR_AMD" );
	#endif
	#ifdef GL_DEPTH_CLAMP_FAR_AMD
		swigIntConstant( GL_DEPTH_CLAMP_FAR_AMD, "GL_DEPTH_CLAMP_FAR_AMD" );
	#endif
	#ifdef GL_AMD_draw_buffers_blend
		swigIntConstant( GL_AMD_draw_buffers_blend, "GL_AMD_draw_buffers_blend" );
	#endif
	#ifdef GL_AMD_framebuffer_multisample_advanced
		swigIntConstant( GL_AMD_framebuffer_multisample_advanced, "GL_AMD_framebuffer_multisample_advanced" );
	#endif
	#ifdef GL_RENDERBUFFER_STORAGE_SAMPLES_AMD
		swigIntConstant( GL_RENDERBUFFER_STORAGE_SAMPLES_AMD, "GL_RENDERBUFFER_STORAGE_SAMPLES_AMD" );
	#endif
	#ifdef GL_MAX_COLOR_FRAMEBUFFER_SAMPLES_AMD
		swigIntConstant( GL_MAX_COLOR_FRAMEBUFFER_SAMPLES_AMD, "GL_MAX_COLOR_FRAMEBUFFER_SAMPLES_AMD" );
	#endif
	#ifdef GL_MAX_COLOR_FRAMEBUFFER_STORAGE_SAMPLES_AMD
		swigIntConstant( GL_MAX_COLOR_FRAMEBUFFER_STORAGE_SAMPLES_AMD, "GL_MAX_COLOR_FRAMEBUFFER_STORAGE_SAMPLES_AMD" );
	#endif
	#ifdef GL_MAX_DEPTH_STENCIL_FRAMEBUFFER_SAMPLES_AMD
		swigIntConstant( GL_MAX_DEPTH_STENCIL_FRAMEBUFFER_SAMPLES_AMD, "GL_MAX_DEPTH_STENCIL_FRAMEBUFFER_SAMPLES_AMD" );
	#endif
	#ifdef GL_NUM_SUPPORTED_MULTISAMPLE_MODES_AMD
		swigIntConstant( GL_NUM_SUPPORTED_MULTISAMPLE_MODES_AMD, "GL_NUM_SUPPORTED_MULTISAMPLE_MODES_AMD" );
	#endif
	#ifdef GL_SUPPORTED_MULTISAMPLE_MODES_AMD
		swigIntConstant( GL_SUPPORTED_MULTISAMPLE_MODES_AMD, "GL_SUPPORTED_MULTISAMPLE_MODES_AMD" );
	#endif
	#ifdef GL_AMD_framebuffer_sample_positions
		swigIntConstant( GL_AMD_framebuffer_sample_positions, "GL_AMD_framebuffer_sample_positions" );
	#endif
	#ifdef GL_SUBSAMPLE_DISTANCE_AMD
		swigIntConstant( GL_SUBSAMPLE_DISTANCE_AMD, "GL_SUBSAMPLE_DISTANCE_AMD" );
	#endif
	#ifdef GL_PIXELS_PER_SAMPLE_PATTERN_X_AMD
		swigIntConstant( GL_PIXELS_PER_SAMPLE_PATTERN_X_AMD, "GL_PIXELS_PER_SAMPLE_PATTERN_X_AMD" );
	#endif
	#ifdef GL_PIXELS_PER_SAMPLE_PATTERN_Y_AMD
		swigIntConstant( GL_PIXELS_PER_SAMPLE_PATTERN_Y_AMD, "GL_PIXELS_PER_SAMPLE_PATTERN_Y_AMD" );
	#endif
	#ifdef GL_ALL_PIXELS_AMD
		swigIntConstant( GL_ALL_PIXELS_AMD, "GL_ALL_PIXELS_AMD" );
	#endif
	#ifdef GL_AMD_gcn_shader
		swigIntConstant( GL_AMD_gcn_shader, "GL_AMD_gcn_shader" );
	#endif
	#ifdef GL_AMD_gpu_shader_half_float
		swigIntConstant( GL_AMD_gpu_shader_half_float, "GL_AMD_gpu_shader_half_float" );
	#endif
	#ifdef GL_FLOAT16_NV
		swigIntConstant( GL_FLOAT16_NV, "GL_FLOAT16_NV" );
	#endif
	#ifdef GL_FLOAT16_VEC2_NV
		swigIntConstant( GL_FLOAT16_VEC2_NV, "GL_FLOAT16_VEC2_NV" );
	#endif
	#ifdef GL_FLOAT16_VEC3_NV
		swigIntConstant( GL_FLOAT16_VEC3_NV, "GL_FLOAT16_VEC3_NV" );
	#endif
	#ifdef GL_FLOAT16_VEC4_NV
		swigIntConstant( GL_FLOAT16_VEC4_NV, "GL_FLOAT16_VEC4_NV" );
	#endif
	#ifdef GL_FLOAT16_MAT2_AMD
		swigIntConstant( GL_FLOAT16_MAT2_AMD, "GL_FLOAT16_MAT2_AMD" );
	#endif
	#ifdef GL_FLOAT16_MAT3_AMD
		swigIntConstant( GL_FLOAT16_MAT3_AMD, "GL_FLOAT16_MAT3_AMD" );
	#endif
	#ifdef GL_FLOAT16_MAT4_AMD
		swigIntConstant( GL_FLOAT16_MAT4_AMD, "GL_FLOAT16_MAT4_AMD" );
	#endif
	#ifdef GL_FLOAT16_MAT2x3_AMD
		swigIntConstant( GL_FLOAT16_MAT2x3_AMD, "GL_FLOAT16_MAT2x3_AMD" );
	#endif
	#ifdef GL_FLOAT16_MAT2x4_AMD
		swigIntConstant( GL_FLOAT16_MAT2x4_AMD, "GL_FLOAT16_MAT2x4_AMD" );
	#endif
	#ifdef GL_FLOAT16_MAT3x2_AMD
		swigIntConstant( GL_FLOAT16_MAT3x2_AMD, "GL_FLOAT16_MAT3x2_AMD" );
	#endif
	#ifdef GL_FLOAT16_MAT3x4_AMD
		swigIntConstant( GL_FLOAT16_MAT3x4_AMD, "GL_FLOAT16_MAT3x4_AMD" );
	#endif
	#ifdef GL_FLOAT16_MAT4x2_AMD
		swigIntConstant( GL_FLOAT16_MAT4x2_AMD, "GL_FLOAT16_MAT4x2_AMD" );
	#endif
	#ifdef GL_FLOAT16_MAT4x3_AMD
		swigIntConstant( GL_FLOAT16_MAT4x3_AMD, "GL_FLOAT16_MAT4x3_AMD" );
	#endif
	#ifdef GL_AMD_gpu_shader_int16
		swigIntConstant( GL_AMD_gpu_shader_int16, "GL_AMD_gpu_shader_int16" );
	#endif
	#ifdef GL_AMD_gpu_shader_int64
		swigIntConstant( GL_AMD_gpu_shader_int64, "GL_AMD_gpu_shader_int64" );
	#endif
	#ifdef GL_INT64_NV
		swigIntConstant( GL_INT64_NV, "GL_INT64_NV" );
	#endif
	#ifdef GL_UNSIGNED_INT64_NV
		swigIntConstant( GL_UNSIGNED_INT64_NV, "GL_UNSIGNED_INT64_NV" );
	#endif
	#ifdef GL_INT8_NV
		swigIntConstant( GL_INT8_NV, "GL_INT8_NV" );
	#endif
	#ifdef GL_INT8_VEC2_NV
		swigIntConstant( GL_INT8_VEC2_NV, "GL_INT8_VEC2_NV" );
	#endif
	#ifdef GL_INT8_VEC3_NV
		swigIntConstant( GL_INT8_VEC3_NV, "GL_INT8_VEC3_NV" );
	#endif
	#ifdef GL_INT8_VEC4_NV
		swigIntConstant( GL_INT8_VEC4_NV, "GL_INT8_VEC4_NV" );
	#endif
	#ifdef GL_INT16_NV
		swigIntConstant( GL_INT16_NV, "GL_INT16_NV" );
	#endif
	#ifdef GL_INT16_VEC2_NV
		swigIntConstant( GL_INT16_VEC2_NV, "GL_INT16_VEC2_NV" );
	#endif
	#ifdef GL_INT16_VEC3_NV
		swigIntConstant( GL_INT16_VEC3_NV, "GL_INT16_VEC3_NV" );
	#endif
	#ifdef GL_INT16_VEC4_NV
		swigIntConstant( GL_INT16_VEC4_NV, "GL_INT16_VEC4_NV" );
	#endif
	#ifdef GL_INT64_VEC2_NV
		swigIntConstant( GL_INT64_VEC2_NV, "GL_INT64_VEC2_NV" );
	#endif
	#ifdef GL_INT64_VEC3_NV
		swigIntConstant( GL_INT64_VEC3_NV, "GL_INT64_VEC3_NV" );
	#endif
	#ifdef GL_INT64_VEC4_NV
		swigIntConstant( GL_INT64_VEC4_NV, "GL_INT64_VEC4_NV" );
	#endif
	#ifdef GL_UNSIGNED_INT8_NV
		swigIntConstant( GL_UNSIGNED_INT8_NV, "GL_UNSIGNED_INT8_NV" );
	#endif
	#ifdef GL_UNSIGNED_INT8_VEC2_NV
		swigIntConstant( GL_UNSIGNED_INT8_VEC2_NV, "GL_UNSIGNED_INT8_VEC2_NV" );
	#endif
	#ifdef GL_UNSIGNED_INT8_VEC3_NV
		swigIntConstant( GL_UNSIGNED_INT8_VEC3_NV, "GL_UNSIGNED_INT8_VEC3_NV" );
	#endif
	#ifdef GL_UNSIGNED_INT8_VEC4_NV
		swigIntConstant( GL_UNSIGNED_INT8_VEC4_NV, "GL_UNSIGNED_INT8_VEC4_NV" );
	#endif
	#ifdef GL_UNSIGNED_INT16_NV
		swigIntConstant( GL_UNSIGNED_INT16_NV, "GL_UNSIGNED_INT16_NV" );
	#endif
	#ifdef GL_UNSIGNED_INT16_VEC2_NV
		swigIntConstant( GL_UNSIGNED_INT16_VEC2_NV, "GL_UNSIGNED_INT16_VEC2_NV" );
	#endif
	#ifdef GL_UNSIGNED_INT16_VEC3_NV
		swigIntConstant( GL_UNSIGNED_INT16_VEC3_NV, "GL_UNSIGNED_INT16_VEC3_NV" );
	#endif
	#ifdef GL_UNSIGNED_INT16_VEC4_NV
		swigIntConstant( GL_UNSIGNED_INT16_VEC4_NV, "GL_UNSIGNED_INT16_VEC4_NV" );
	#endif
	#ifdef GL_UNSIGNED_INT64_VEC2_NV
		swigIntConstant( GL_UNSIGNED_INT64_VEC2_NV, "GL_UNSIGNED_INT64_VEC2_NV" );
	#endif
	#ifdef GL_UNSIGNED_INT64_VEC3_NV
		swigIntConstant( GL_UNSIGNED_INT64_VEC3_NV, "GL_UNSIGNED_INT64_VEC3_NV" );
	#endif
	#ifdef GL_UNSIGNED_INT64_VEC4_NV
		swigIntConstant( GL_UNSIGNED_INT64_VEC4_NV, "GL_UNSIGNED_INT64_VEC4_NV" );
	#endif
	#ifdef GL_AMD_interleaved_elements
		swigIntConstant( GL_AMD_interleaved_elements, "GL_AMD_interleaved_elements" );
	#endif
	#ifdef GL_VERTEX_ELEMENT_SWIZZLE_AMD
		swigIntConstant( GL_VERTEX_ELEMENT_SWIZZLE_AMD, "GL_VERTEX_ELEMENT_SWIZZLE_AMD" );
	#endif
	#ifdef GL_VERTEX_ID_SWIZZLE_AMD
		swigIntConstant( GL_VERTEX_ID_SWIZZLE_AMD, "GL_VERTEX_ID_SWIZZLE_AMD" );
	#endif
	#ifdef GL_AMD_multi_draw_indirect
		swigIntConstant( GL_AMD_multi_draw_indirect, "GL_AMD_multi_draw_indirect" );
	#endif
	#ifdef GL_AMD_name_gen_delete
		swigIntConstant( GL_AMD_name_gen_delete, "GL_AMD_name_gen_delete" );
	#endif
	#ifdef GL_DATA_BUFFER_AMD
		swigIntConstant( GL_DATA_BUFFER_AMD, "GL_DATA_BUFFER_AMD" );
	#endif
	#ifdef GL_PERFORMANCE_MONITOR_AMD
		swigIntConstant( GL_PERFORMANCE_MONITOR_AMD, "GL_PERFORMANCE_MONITOR_AMD" );
	#endif
	#ifdef GL_QUERY_OBJECT_AMD
		swigIntConstant( GL_QUERY_OBJECT_AMD, "GL_QUERY_OBJECT_AMD" );
	#endif
	#ifdef GL_VERTEX_ARRAY_OBJECT_AMD
		swigIntConstant( GL_VERTEX_ARRAY_OBJECT_AMD, "GL_VERTEX_ARRAY_OBJECT_AMD" );
	#endif
	#ifdef GL_SAMPLER_OBJECT_AMD
		swigIntConstant( GL_SAMPLER_OBJECT_AMD, "GL_SAMPLER_OBJECT_AMD" );
	#endif
	#ifdef GL_AMD_occlusion_query_event
		swigIntConstant( GL_AMD_occlusion_query_event, "GL_AMD_occlusion_query_event" );
	#endif
	#ifdef GL_OCCLUSION_QUERY_EVENT_MASK_AMD
		swigIntConstant( GL_OCCLUSION_QUERY_EVENT_MASK_AMD, "GL_OCCLUSION_QUERY_EVENT_MASK_AMD" );
	#endif
	#ifdef GL_QUERY_DEPTH_PASS_EVENT_BIT_AMD
		swigIntConstant( GL_QUERY_DEPTH_PASS_EVENT_BIT_AMD, "GL_QUERY_DEPTH_PASS_EVENT_BIT_AMD" );
	#endif
	#ifdef GL_QUERY_DEPTH_FAIL_EVENT_BIT_AMD
		swigIntConstant( GL_QUERY_DEPTH_FAIL_EVENT_BIT_AMD, "GL_QUERY_DEPTH_FAIL_EVENT_BIT_AMD" );
	#endif
	#ifdef GL_QUERY_STENCIL_FAIL_EVENT_BIT_AMD
		swigIntConstant( GL_QUERY_STENCIL_FAIL_EVENT_BIT_AMD, "GL_QUERY_STENCIL_FAIL_EVENT_BIT_AMD" );
	#endif
	#ifdef GL_QUERY_DEPTH_BOUNDS_FAIL_EVENT_BIT_AMD
		swigIntConstant( GL_QUERY_DEPTH_BOUNDS_FAIL_EVENT_BIT_AMD, "GL_QUERY_DEPTH_BOUNDS_FAIL_EVENT_BIT_AMD" );
	#endif
	#ifdef GL_QUERY_ALL_EVENT_BITS_AMD
		swigIntConstant( GL_QUERY_ALL_EVENT_BITS_AMD, "GL_QUERY_ALL_EVENT_BITS_AMD" );
	#endif
	#ifdef GL_AMD_performance_monitor
		swigIntConstant( GL_AMD_performance_monitor, "GL_AMD_performance_monitor" );
	#endif
	#ifdef GL_COUNTER_TYPE_AMD
		swigIntConstant( GL_COUNTER_TYPE_AMD, "GL_COUNTER_TYPE_AMD" );
	#endif
	#ifdef GL_COUNTER_RANGE_AMD
		swigIntConstant( GL_COUNTER_RANGE_AMD, "GL_COUNTER_RANGE_AMD" );
	#endif
	#ifdef GL_UNSIGNED_INT64_AMD
		swigIntConstant( GL_UNSIGNED_INT64_AMD, "GL_UNSIGNED_INT64_AMD" );
	#endif
	#ifdef GL_PERCENTAGE_AMD
		swigIntConstant( GL_PERCENTAGE_AMD, "GL_PERCENTAGE_AMD" );
	#endif
	#ifdef GL_PERFMON_RESULT_AVAILABLE_AMD
		swigIntConstant( GL_PERFMON_RESULT_AVAILABLE_AMD, "GL_PERFMON_RESULT_AVAILABLE_AMD" );
	#endif
	#ifdef GL_PERFMON_RESULT_SIZE_AMD
		swigIntConstant( GL_PERFMON_RESULT_SIZE_AMD, "GL_PERFMON_RESULT_SIZE_AMD" );
	#endif
	#ifdef GL_PERFMON_RESULT_AMD
		swigIntConstant( GL_PERFMON_RESULT_AMD, "GL_PERFMON_RESULT_AMD" );
	#endif
	#ifdef GL_AMD_pinned_memory
		swigIntConstant( GL_AMD_pinned_memory, "GL_AMD_pinned_memory" );
	#endif
	#ifdef GL_EXTERNAL_VIRTUAL_MEMORY_BUFFER_AMD
		swigIntConstant( GL_EXTERNAL_VIRTUAL_MEMORY_BUFFER_AMD, "GL_EXTERNAL_VIRTUAL_MEMORY_BUFFER_AMD" );
	#endif
	#ifdef GL_AMD_query_buffer_object
		swigIntConstant( GL_AMD_query_buffer_object, "GL_AMD_query_buffer_object" );
	#endif
	#ifdef GL_QUERY_BUFFER_AMD
		swigIntConstant( GL_QUERY_BUFFER_AMD, "GL_QUERY_BUFFER_AMD" );
	#endif
	#ifdef GL_QUERY_BUFFER_BINDING_AMD
		swigIntConstant( GL_QUERY_BUFFER_BINDING_AMD, "GL_QUERY_BUFFER_BINDING_AMD" );
	#endif
	#ifdef GL_QUERY_RESULT_NO_WAIT_AMD
		swigIntConstant( GL_QUERY_RESULT_NO_WAIT_AMD, "GL_QUERY_RESULT_NO_WAIT_AMD" );
	#endif
	#ifdef GL_AMD_sample_positions
		swigIntConstant( GL_AMD_sample_positions, "GL_AMD_sample_positions" );
	#endif
	#ifdef GL_AMD_seamless_cubemap_per_texture
		swigIntConstant( GL_AMD_seamless_cubemap_per_texture, "GL_AMD_seamless_cubemap_per_texture" );
	#endif
	#ifdef GL_AMD_shader_atomic_counter_ops
		swigIntConstant( GL_AMD_shader_atomic_counter_ops, "GL_AMD_shader_atomic_counter_ops" );
	#endif
	#ifdef GL_AMD_shader_ballot
		swigIntConstant( GL_AMD_shader_ballot, "GL_AMD_shader_ballot" );
	#endif
	#ifdef GL_AMD_shader_explicit_vertex_parameter
		swigIntConstant( GL_AMD_shader_explicit_vertex_parameter, "GL_AMD_shader_explicit_vertex_parameter" );
	#endif
	#ifdef GL_AMD_shader_gpu_shader_half_float_fetch
		swigIntConstant( GL_AMD_shader_gpu_shader_half_float_fetch, "GL_AMD_shader_gpu_shader_half_float_fetch" );
	#endif
	#ifdef GL_AMD_shader_image_load_store_lod
		swigIntConstant( GL_AMD_shader_image_load_store_lod, "GL_AMD_shader_image_load_store_lod" );
	#endif
	#ifdef GL_AMD_shader_stencil_export
		swigIntConstant( GL_AMD_shader_stencil_export, "GL_AMD_shader_stencil_export" );
	#endif
	#ifdef GL_AMD_shader_trinary_minmax
		swigIntConstant( GL_AMD_shader_trinary_minmax, "GL_AMD_shader_trinary_minmax" );
	#endif
	#ifdef GL_AMD_sparse_texture
		swigIntConstant( GL_AMD_sparse_texture, "GL_AMD_sparse_texture" );
	#endif
	#ifdef GL_VIRTUAL_PAGE_SIZE_X_AMD
		swigIntConstant( GL_VIRTUAL_PAGE_SIZE_X_AMD, "GL_VIRTUAL_PAGE_SIZE_X_AMD" );
	#endif
	#ifdef GL_VIRTUAL_PAGE_SIZE_Y_AMD
		swigIntConstant( GL_VIRTUAL_PAGE_SIZE_Y_AMD, "GL_VIRTUAL_PAGE_SIZE_Y_AMD" );
	#endif
	#ifdef GL_VIRTUAL_PAGE_SIZE_Z_AMD
		swigIntConstant( GL_VIRTUAL_PAGE_SIZE_Z_AMD, "GL_VIRTUAL_PAGE_SIZE_Z_AMD" );
	#endif
	#ifdef GL_MAX_SPARSE_TEXTURE_SIZE_AMD
		swigIntConstant( GL_MAX_SPARSE_TEXTURE_SIZE_AMD, "GL_MAX_SPARSE_TEXTURE_SIZE_AMD" );
	#endif
	#ifdef GL_MAX_SPARSE_3D_TEXTURE_SIZE_AMD
		swigIntConstant( GL_MAX_SPARSE_3D_TEXTURE_SIZE_AMD, "GL_MAX_SPARSE_3D_TEXTURE_SIZE_AMD" );
	#endif
	#ifdef GL_MAX_SPARSE_ARRAY_TEXTURE_LAYERS
		swigIntConstant( GL_MAX_SPARSE_ARRAY_TEXTURE_LAYERS, "GL_MAX_SPARSE_ARRAY_TEXTURE_LAYERS" );
	#endif
	#ifdef GL_MIN_SPARSE_LEVEL_AMD
		swigIntConstant( GL_MIN_SPARSE_LEVEL_AMD, "GL_MIN_SPARSE_LEVEL_AMD" );
	#endif
	#ifdef GL_MIN_LOD_WARNING_AMD
		swigIntConstant( GL_MIN_LOD_WARNING_AMD, "GL_MIN_LOD_WARNING_AMD" );
	#endif
	#ifdef GL_TEXTURE_STORAGE_SPARSE_BIT_AMD
		swigIntConstant( GL_TEXTURE_STORAGE_SPARSE_BIT_AMD, "GL_TEXTURE_STORAGE_SPARSE_BIT_AMD" );
	#endif
	#ifdef GL_AMD_stencil_operation_extended
		swigIntConstant( GL_AMD_stencil_operation_extended, "GL_AMD_stencil_operation_extended" );
	#endif
	#ifdef GL_SET_AMD
		swigIntConstant( GL_SET_AMD, "GL_SET_AMD" );
	#endif
	#ifdef GL_REPLACE_VALUE_AMD
		swigIntConstant( GL_REPLACE_VALUE_AMD, "GL_REPLACE_VALUE_AMD" );
	#endif
	#ifdef GL_STENCIL_OP_VALUE_AMD
		swigIntConstant( GL_STENCIL_OP_VALUE_AMD, "GL_STENCIL_OP_VALUE_AMD" );
	#endif
	#ifdef GL_STENCIL_BACK_OP_VALUE_AMD
		swigIntConstant( GL_STENCIL_BACK_OP_VALUE_AMD, "GL_STENCIL_BACK_OP_VALUE_AMD" );
	#endif
	#ifdef GL_AMD_texture_gather_bias_lod
		swigIntConstant( GL_AMD_texture_gather_bias_lod, "GL_AMD_texture_gather_bias_lod" );
	#endif
	#ifdef GL_AMD_texture_texture4
		swigIntConstant( GL_AMD_texture_texture4, "GL_AMD_texture_texture4" );
	#endif
	#ifdef GL_AMD_transform_feedback3_lines_triangles
		swigIntConstant( GL_AMD_transform_feedback3_lines_triangles, "GL_AMD_transform_feedback3_lines_triangles" );
	#endif
	#ifdef GL_AMD_transform_feedback4
		swigIntConstant( GL_AMD_transform_feedback4, "GL_AMD_transform_feedback4" );
	#endif
	#ifdef GL_STREAM_RASTERIZATION_AMD
		swigIntConstant( GL_STREAM_RASTERIZATION_AMD, "GL_STREAM_RASTERIZATION_AMD" );
	#endif
	#ifdef GL_AMD_vertex_shader_layer
		swigIntConstant( GL_AMD_vertex_shader_layer, "GL_AMD_vertex_shader_layer" );
	#endif
	#ifdef GL_AMD_vertex_shader_tessellator
		swigIntConstant( GL_AMD_vertex_shader_tessellator, "GL_AMD_vertex_shader_tessellator" );
	#endif
	#ifdef GL_SAMPLER_BUFFER_AMD
		swigIntConstant( GL_SAMPLER_BUFFER_AMD, "GL_SAMPLER_BUFFER_AMD" );
	#endif
	#ifdef GL_INT_SAMPLER_BUFFER_AMD
		swigIntConstant( GL_INT_SAMPLER_BUFFER_AMD, "GL_INT_SAMPLER_BUFFER_AMD" );
	#endif
	#ifdef GL_UNSIGNED_INT_SAMPLER_BUFFER_AMD
		swigIntConstant( GL_UNSIGNED_INT_SAMPLER_BUFFER_AMD, "GL_UNSIGNED_INT_SAMPLER_BUFFER_AMD" );
	#endif
	#ifdef GL_TESSELLATION_MODE_AMD
		swigIntConstant( GL_TESSELLATION_MODE_AMD, "GL_TESSELLATION_MODE_AMD" );
	#endif
	#ifdef GL_TESSELLATION_FACTOR_AMD
		swigIntConstant( GL_TESSELLATION_FACTOR_AMD, "GL_TESSELLATION_FACTOR_AMD" );
	#endif
	#ifdef GL_DISCRETE_AMD
		swigIntConstant( GL_DISCRETE_AMD, "GL_DISCRETE_AMD" );
	#endif
	#ifdef GL_CONTINUOUS_AMD
		swigIntConstant( GL_CONTINUOUS_AMD, "GL_CONTINUOUS_AMD" );
	#endif
	#ifdef GL_AMD_vertex_shader_viewport_index
		swigIntConstant( GL_AMD_vertex_shader_viewport_index, "GL_AMD_vertex_shader_viewport_index" );
	#endif
	#ifdef GL_APPLE_aux_depth_stencil
		swigIntConstant( GL_APPLE_aux_depth_stencil, "GL_APPLE_aux_depth_stencil" );
	#endif
	#ifdef GL_AUX_DEPTH_STENCIL_APPLE
		swigIntConstant( GL_AUX_DEPTH_STENCIL_APPLE, "GL_AUX_DEPTH_STENCIL_APPLE" );
	#endif
	#ifdef GL_APPLE_client_storage
		swigIntConstant( GL_APPLE_client_storage, "GL_APPLE_client_storage" );
	#endif
	#ifdef GL_UNPACK_CLIENT_STORAGE_APPLE
		swigIntConstant( GL_UNPACK_CLIENT_STORAGE_APPLE, "GL_UNPACK_CLIENT_STORAGE_APPLE" );
	#endif
	#ifdef GL_APPLE_element_array
		swigIntConstant( GL_APPLE_element_array, "GL_APPLE_element_array" );
	#endif
	#ifdef GL_ELEMENT_ARRAY_APPLE
		swigIntConstant( GL_ELEMENT_ARRAY_APPLE, "GL_ELEMENT_ARRAY_APPLE" );
	#endif
	#ifdef GL_ELEMENT_ARRAY_TYPE_APPLE
		swigIntConstant( GL_ELEMENT_ARRAY_TYPE_APPLE, "GL_ELEMENT_ARRAY_TYPE_APPLE" );
	#endif
	#ifdef GL_ELEMENT_ARRAY_POINTER_APPLE
		swigIntConstant( GL_ELEMENT_ARRAY_POINTER_APPLE, "GL_ELEMENT_ARRAY_POINTER_APPLE" );
	#endif
	#ifdef GL_APPLE_fence
		swigIntConstant( GL_APPLE_fence, "GL_APPLE_fence" );
	#endif
	#ifdef GL_DRAW_PIXELS_APPLE
		swigIntConstant( GL_DRAW_PIXELS_APPLE, "GL_DRAW_PIXELS_APPLE" );
	#endif
	#ifdef GL_FENCE_APPLE
		swigIntConstant( GL_FENCE_APPLE, "GL_FENCE_APPLE" );
	#endif
	#ifdef GL_APPLE_float_pixels
		swigIntConstant( GL_APPLE_float_pixels, "GL_APPLE_float_pixels" );
	#endif
	#ifdef GL_HALF_APPLE
		swigIntConstant( GL_HALF_APPLE, "GL_HALF_APPLE" );
	#endif
	#ifdef GL_RGBA_FLOAT32_APPLE
		swigIntConstant( GL_RGBA_FLOAT32_APPLE, "GL_RGBA_FLOAT32_APPLE" );
	#endif
	#ifdef GL_RGB_FLOAT32_APPLE
		swigIntConstant( GL_RGB_FLOAT32_APPLE, "GL_RGB_FLOAT32_APPLE" );
	#endif
	#ifdef GL_ALPHA_FLOAT32_APPLE
		swigIntConstant( GL_ALPHA_FLOAT32_APPLE, "GL_ALPHA_FLOAT32_APPLE" );
	#endif
	#ifdef GL_INTENSITY_FLOAT32_APPLE
		swigIntConstant( GL_INTENSITY_FLOAT32_APPLE, "GL_INTENSITY_FLOAT32_APPLE" );
	#endif
	#ifdef GL_LUMINANCE_FLOAT32_APPLE
		swigIntConstant( GL_LUMINANCE_FLOAT32_APPLE, "GL_LUMINANCE_FLOAT32_APPLE" );
	#endif
	#ifdef GL_LUMINANCE_ALPHA_FLOAT32_APPLE
		swigIntConstant( GL_LUMINANCE_ALPHA_FLOAT32_APPLE, "GL_LUMINANCE_ALPHA_FLOAT32_APPLE" );
	#endif
	#ifdef GL_RGBA_FLOAT16_APPLE
		swigIntConstant( GL_RGBA_FLOAT16_APPLE, "GL_RGBA_FLOAT16_APPLE" );
	#endif
	#ifdef GL_RGB_FLOAT16_APPLE
		swigIntConstant( GL_RGB_FLOAT16_APPLE, "GL_RGB_FLOAT16_APPLE" );
	#endif
	#ifdef GL_ALPHA_FLOAT16_APPLE
		swigIntConstant( GL_ALPHA_FLOAT16_APPLE, "GL_ALPHA_FLOAT16_APPLE" );
	#endif
	#ifdef GL_INTENSITY_FLOAT16_APPLE
		swigIntConstant( GL_INTENSITY_FLOAT16_APPLE, "GL_INTENSITY_FLOAT16_APPLE" );
	#endif
	#ifdef GL_LUMINANCE_FLOAT16_APPLE
		swigIntConstant( GL_LUMINANCE_FLOAT16_APPLE, "GL_LUMINANCE_FLOAT16_APPLE" );
	#endif
	#ifdef GL_LUMINANCE_ALPHA_FLOAT16_APPLE
		swigIntConstant( GL_LUMINANCE_ALPHA_FLOAT16_APPLE, "GL_LUMINANCE_ALPHA_FLOAT16_APPLE" );
	#endif
	#ifdef GL_COLOR_FLOAT_APPLE
		swigIntConstant( GL_COLOR_FLOAT_APPLE, "GL_COLOR_FLOAT_APPLE" );
	#endif
	#ifdef GL_APPLE_flush_buffer_range
		swigIntConstant( GL_APPLE_flush_buffer_range, "GL_APPLE_flush_buffer_range" );
	#endif
	#ifdef GL_BUFFER_SERIALIZED_MODIFY_APPLE
		swigIntConstant( GL_BUFFER_SERIALIZED_MODIFY_APPLE, "GL_BUFFER_SERIALIZED_MODIFY_APPLE" );
	#endif
	#ifdef GL_BUFFER_FLUSHING_UNMAP_APPLE
		swigIntConstant( GL_BUFFER_FLUSHING_UNMAP_APPLE, "GL_BUFFER_FLUSHING_UNMAP_APPLE" );
	#endif
	#ifdef GL_APPLE_object_purgeable
		swigIntConstant( GL_APPLE_object_purgeable, "GL_APPLE_object_purgeable" );
	#endif
	#ifdef GL_BUFFER_OBJECT_APPLE
		swigIntConstant( GL_BUFFER_OBJECT_APPLE, "GL_BUFFER_OBJECT_APPLE" );
	#endif
	#ifdef GL_RELEASED_APPLE
		swigIntConstant( GL_RELEASED_APPLE, "GL_RELEASED_APPLE" );
	#endif
	#ifdef GL_VOLATILE_APPLE
		swigIntConstant( GL_VOLATILE_APPLE, "GL_VOLATILE_APPLE" );
	#endif
	#ifdef GL_RETAINED_APPLE
		swigIntConstant( GL_RETAINED_APPLE, "GL_RETAINED_APPLE" );
	#endif
	#ifdef GL_UNDEFINED_APPLE
		swigIntConstant( GL_UNDEFINED_APPLE, "GL_UNDEFINED_APPLE" );
	#endif
	#ifdef GL_PURGEABLE_APPLE
		swigIntConstant( GL_PURGEABLE_APPLE, "GL_PURGEABLE_APPLE" );
	#endif
	#ifdef GL_APPLE_rgb_422
		swigIntConstant( GL_APPLE_rgb_422, "GL_APPLE_rgb_422" );
	#endif
	#ifdef GL_RGB_422_APPLE
		swigIntConstant( GL_RGB_422_APPLE, "GL_RGB_422_APPLE" );
	#endif
	#ifdef GL_UNSIGNED_SHORT_8_8_APPLE
		swigIntConstant( GL_UNSIGNED_SHORT_8_8_APPLE, "GL_UNSIGNED_SHORT_8_8_APPLE" );
	#endif
	#ifdef GL_UNSIGNED_SHORT_8_8_REV_APPLE
		swigIntConstant( GL_UNSIGNED_SHORT_8_8_REV_APPLE, "GL_UNSIGNED_SHORT_8_8_REV_APPLE" );
	#endif
	#ifdef GL_RGB_RAW_422_APPLE
		swigIntConstant( GL_RGB_RAW_422_APPLE, "GL_RGB_RAW_422_APPLE" );
	#endif
	#ifdef GL_APPLE_row_bytes
		swigIntConstant( GL_APPLE_row_bytes, "GL_APPLE_row_bytes" );
	#endif
	#ifdef GL_PACK_ROW_BYTES_APPLE
		swigIntConstant( GL_PACK_ROW_BYTES_APPLE, "GL_PACK_ROW_BYTES_APPLE" );
	#endif
	#ifdef GL_UNPACK_ROW_BYTES_APPLE
		swigIntConstant( GL_UNPACK_ROW_BYTES_APPLE, "GL_UNPACK_ROW_BYTES_APPLE" );
	#endif
	#ifdef GL_APPLE_specular_vector
		swigIntConstant( GL_APPLE_specular_vector, "GL_APPLE_specular_vector" );
	#endif
	#ifdef GL_LIGHT_MODEL_SPECULAR_VECTOR_APPLE
		swigIntConstant( GL_LIGHT_MODEL_SPECULAR_VECTOR_APPLE, "GL_LIGHT_MODEL_SPECULAR_VECTOR_APPLE" );
	#endif
	#ifdef GL_APPLE_texture_range
		swigIntConstant( GL_APPLE_texture_range, "GL_APPLE_texture_range" );
	#endif
	#ifdef GL_TEXTURE_RANGE_LENGTH_APPLE
		swigIntConstant( GL_TEXTURE_RANGE_LENGTH_APPLE, "GL_TEXTURE_RANGE_LENGTH_APPLE" );
	#endif
	#ifdef GL_TEXTURE_RANGE_POINTER_APPLE
		swigIntConstant( GL_TEXTURE_RANGE_POINTER_APPLE, "GL_TEXTURE_RANGE_POINTER_APPLE" );
	#endif
	#ifdef GL_TEXTURE_STORAGE_HINT_APPLE
		swigIntConstant( GL_TEXTURE_STORAGE_HINT_APPLE, "GL_TEXTURE_STORAGE_HINT_APPLE" );
	#endif
	#ifdef GL_STORAGE_PRIVATE_APPLE
		swigIntConstant( GL_STORAGE_PRIVATE_APPLE, "GL_STORAGE_PRIVATE_APPLE" );
	#endif
	#ifdef GL_STORAGE_CACHED_APPLE
		swigIntConstant( GL_STORAGE_CACHED_APPLE, "GL_STORAGE_CACHED_APPLE" );
	#endif
	#ifdef GL_STORAGE_SHARED_APPLE
		swigIntConstant( GL_STORAGE_SHARED_APPLE, "GL_STORAGE_SHARED_APPLE" );
	#endif
	#ifdef GL_APPLE_transform_hint
		swigIntConstant( GL_APPLE_transform_hint, "GL_APPLE_transform_hint" );
	#endif
	#ifdef GL_TRANSFORM_HINT_APPLE
		swigIntConstant( GL_TRANSFORM_HINT_APPLE, "GL_TRANSFORM_HINT_APPLE" );
	#endif
	#ifdef GL_APPLE_vertex_array_object
		swigIntConstant( GL_APPLE_vertex_array_object, "GL_APPLE_vertex_array_object" );
	#endif
	#ifdef GL_VERTEX_ARRAY_BINDING_APPLE
		swigIntConstant( GL_VERTEX_ARRAY_BINDING_APPLE, "GL_VERTEX_ARRAY_BINDING_APPLE" );
	#endif
	#ifdef GL_APPLE_vertex_array_range
		swigIntConstant( GL_APPLE_vertex_array_range, "GL_APPLE_vertex_array_range" );
	#endif
	#ifdef GL_VERTEX_ARRAY_RANGE_APPLE
		swigIntConstant( GL_VERTEX_ARRAY_RANGE_APPLE, "GL_VERTEX_ARRAY_RANGE_APPLE" );
	#endif
	#ifdef GL_VERTEX_ARRAY_RANGE_LENGTH_APPLE
		swigIntConstant( GL_VERTEX_ARRAY_RANGE_LENGTH_APPLE, "GL_VERTEX_ARRAY_RANGE_LENGTH_APPLE" );
	#endif
	#ifdef GL_VERTEX_ARRAY_STORAGE_HINT_APPLE
		swigIntConstant( GL_VERTEX_ARRAY_STORAGE_HINT_APPLE, "GL_VERTEX_ARRAY_STORAGE_HINT_APPLE" );
	#endif
	#ifdef GL_VERTEX_ARRAY_RANGE_POINTER_APPLE
		swigIntConstant( GL_VERTEX_ARRAY_RANGE_POINTER_APPLE, "GL_VERTEX_ARRAY_RANGE_POINTER_APPLE" );
	#endif
	#ifdef GL_STORAGE_CLIENT_APPLE
		swigIntConstant( GL_STORAGE_CLIENT_APPLE, "GL_STORAGE_CLIENT_APPLE" );
	#endif
	#ifdef GL_APPLE_vertex_program_evaluators
		swigIntConstant( GL_APPLE_vertex_program_evaluators, "GL_APPLE_vertex_program_evaluators" );
	#endif
	#ifdef GL_VERTEX_ATTRIB_MAP1_APPLE
		swigIntConstant( GL_VERTEX_ATTRIB_MAP1_APPLE, "GL_VERTEX_ATTRIB_MAP1_APPLE" );
	#endif
	#ifdef GL_VERTEX_ATTRIB_MAP2_APPLE
		swigIntConstant( GL_VERTEX_ATTRIB_MAP2_APPLE, "GL_VERTEX_ATTRIB_MAP2_APPLE" );
	#endif
	#ifdef GL_VERTEX_ATTRIB_MAP1_SIZE_APPLE
		swigIntConstant( GL_VERTEX_ATTRIB_MAP1_SIZE_APPLE, "GL_VERTEX_ATTRIB_MAP1_SIZE_APPLE" );
	#endif
	#ifdef GL_VERTEX_ATTRIB_MAP1_COEFF_APPLE
		swigIntConstant( GL_VERTEX_ATTRIB_MAP1_COEFF_APPLE, "GL_VERTEX_ATTRIB_MAP1_COEFF_APPLE" );
	#endif
	#ifdef GL_VERTEX_ATTRIB_MAP1_ORDER_APPLE
		swigIntConstant( GL_VERTEX_ATTRIB_MAP1_ORDER_APPLE, "GL_VERTEX_ATTRIB_MAP1_ORDER_APPLE" );
	#endif
	#ifdef GL_VERTEX_ATTRIB_MAP1_DOMAIN_APPLE
		swigIntConstant( GL_VERTEX_ATTRIB_MAP1_DOMAIN_APPLE, "GL_VERTEX_ATTRIB_MAP1_DOMAIN_APPLE" );
	#endif
	#ifdef GL_VERTEX_ATTRIB_MAP2_SIZE_APPLE
		swigIntConstant( GL_VERTEX_ATTRIB_MAP2_SIZE_APPLE, "GL_VERTEX_ATTRIB_MAP2_SIZE_APPLE" );
	#endif
	#ifdef GL_VERTEX_ATTRIB_MAP2_COEFF_APPLE
		swigIntConstant( GL_VERTEX_ATTRIB_MAP2_COEFF_APPLE, "GL_VERTEX_ATTRIB_MAP2_COEFF_APPLE" );
	#endif
	#ifdef GL_VERTEX_ATTRIB_MAP2_ORDER_APPLE
		swigIntConstant( GL_VERTEX_ATTRIB_MAP2_ORDER_APPLE, "GL_VERTEX_ATTRIB_MAP2_ORDER_APPLE" );
	#endif
	#ifdef GL_VERTEX_ATTRIB_MAP2_DOMAIN_APPLE
		swigIntConstant( GL_VERTEX_ATTRIB_MAP2_DOMAIN_APPLE, "GL_VERTEX_ATTRIB_MAP2_DOMAIN_APPLE" );
	#endif
	#ifdef GL_APPLE_ycbcr_422
		swigIntConstant( GL_APPLE_ycbcr_422, "GL_APPLE_ycbcr_422" );
	#endif
	#ifdef GL_YCBCR_422_APPLE
		swigIntConstant( GL_YCBCR_422_APPLE, "GL_YCBCR_422_APPLE" );
	#endif
	#ifdef GL_ATI_draw_buffers
		swigIntConstant( GL_ATI_draw_buffers, "GL_ATI_draw_buffers" );
	#endif
	#ifdef GL_MAX_DRAW_BUFFERS_ATI
		swigIntConstant( GL_MAX_DRAW_BUFFERS_ATI, "GL_MAX_DRAW_BUFFERS_ATI" );
	#endif
	#ifdef GL_DRAW_BUFFER0_ATI
		swigIntConstant( GL_DRAW_BUFFER0_ATI, "GL_DRAW_BUFFER0_ATI" );
	#endif
	#ifdef GL_DRAW_BUFFER1_ATI
		swigIntConstant( GL_DRAW_BUFFER1_ATI, "GL_DRAW_BUFFER1_ATI" );
	#endif
	#ifdef GL_DRAW_BUFFER2_ATI
		swigIntConstant( GL_DRAW_BUFFER2_ATI, "GL_DRAW_BUFFER2_ATI" );
	#endif
	#ifdef GL_DRAW_BUFFER3_ATI
		swigIntConstant( GL_DRAW_BUFFER3_ATI, "GL_DRAW_BUFFER3_ATI" );
	#endif
	#ifdef GL_DRAW_BUFFER4_ATI
		swigIntConstant( GL_DRAW_BUFFER4_ATI, "GL_DRAW_BUFFER4_ATI" );
	#endif
	#ifdef GL_DRAW_BUFFER5_ATI
		swigIntConstant( GL_DRAW_BUFFER5_ATI, "GL_DRAW_BUFFER5_ATI" );
	#endif
	#ifdef GL_DRAW_BUFFER6_ATI
		swigIntConstant( GL_DRAW_BUFFER6_ATI, "GL_DRAW_BUFFER6_ATI" );
	#endif
	#ifdef GL_DRAW_BUFFER7_ATI
		swigIntConstant( GL_DRAW_BUFFER7_ATI, "GL_DRAW_BUFFER7_ATI" );
	#endif
	#ifdef GL_DRAW_BUFFER8_ATI
		swigIntConstant( GL_DRAW_BUFFER8_ATI, "GL_DRAW_BUFFER8_ATI" );
	#endif
	#ifdef GL_DRAW_BUFFER9_ATI
		swigIntConstant( GL_DRAW_BUFFER9_ATI, "GL_DRAW_BUFFER9_ATI" );
	#endif
	#ifdef GL_DRAW_BUFFER10_ATI
		swigIntConstant( GL_DRAW_BUFFER10_ATI, "GL_DRAW_BUFFER10_ATI" );
	#endif
	#ifdef GL_DRAW_BUFFER11_ATI
		swigIntConstant( GL_DRAW_BUFFER11_ATI, "GL_DRAW_BUFFER11_ATI" );
	#endif
	#ifdef GL_DRAW_BUFFER12_ATI
		swigIntConstant( GL_DRAW_BUFFER12_ATI, "GL_DRAW_BUFFER12_ATI" );
	#endif
	#ifdef GL_DRAW_BUFFER13_ATI
		swigIntConstant( GL_DRAW_BUFFER13_ATI, "GL_DRAW_BUFFER13_ATI" );
	#endif
	#ifdef GL_DRAW_BUFFER14_ATI
		swigIntConstant( GL_DRAW_BUFFER14_ATI, "GL_DRAW_BUFFER14_ATI" );
	#endif
	#ifdef GL_DRAW_BUFFER15_ATI
		swigIntConstant( GL_DRAW_BUFFER15_ATI, "GL_DRAW_BUFFER15_ATI" );
	#endif
	#ifdef GL_ATI_element_array
		swigIntConstant( GL_ATI_element_array, "GL_ATI_element_array" );
	#endif
	#ifdef GL_ELEMENT_ARRAY_ATI
		swigIntConstant( GL_ELEMENT_ARRAY_ATI, "GL_ELEMENT_ARRAY_ATI" );
	#endif
	#ifdef GL_ELEMENT_ARRAY_TYPE_ATI
		swigIntConstant( GL_ELEMENT_ARRAY_TYPE_ATI, "GL_ELEMENT_ARRAY_TYPE_ATI" );
	#endif
	#ifdef GL_ELEMENT_ARRAY_POINTER_ATI
		swigIntConstant( GL_ELEMENT_ARRAY_POINTER_ATI, "GL_ELEMENT_ARRAY_POINTER_ATI" );
	#endif
	#ifdef GL_ATI_envmap_bumpmap
		swigIntConstant( GL_ATI_envmap_bumpmap, "GL_ATI_envmap_bumpmap" );
	#endif
	#ifdef GL_BUMP_ROT_MATRIX_ATI
		swigIntConstant( GL_BUMP_ROT_MATRIX_ATI, "GL_BUMP_ROT_MATRIX_ATI" );
	#endif
	#ifdef GL_BUMP_ROT_MATRIX_SIZE_ATI
		swigIntConstant( GL_BUMP_ROT_MATRIX_SIZE_ATI, "GL_BUMP_ROT_MATRIX_SIZE_ATI" );
	#endif
	#ifdef GL_BUMP_NUM_TEX_UNITS_ATI
		swigIntConstant( GL_BUMP_NUM_TEX_UNITS_ATI, "GL_BUMP_NUM_TEX_UNITS_ATI" );
	#endif
	#ifdef GL_BUMP_TEX_UNITS_ATI
		swigIntConstant( GL_BUMP_TEX_UNITS_ATI, "GL_BUMP_TEX_UNITS_ATI" );
	#endif
	#ifdef GL_DUDV_ATI
		swigIntConstant( GL_DUDV_ATI, "GL_DUDV_ATI" );
	#endif
	#ifdef GL_DU8DV8_ATI
		swigIntConstant( GL_DU8DV8_ATI, "GL_DU8DV8_ATI" );
	#endif
	#ifdef GL_BUMP_ENVMAP_ATI
		swigIntConstant( GL_BUMP_ENVMAP_ATI, "GL_BUMP_ENVMAP_ATI" );
	#endif
	#ifdef GL_BUMP_TARGET_ATI
		swigIntConstant( GL_BUMP_TARGET_ATI, "GL_BUMP_TARGET_ATI" );
	#endif
	#ifdef GL_ATI_fragment_shader
		swigIntConstant( GL_ATI_fragment_shader, "GL_ATI_fragment_shader" );
	#endif
	#ifdef GL_FRAGMENT_SHADER_ATI
		swigIntConstant( GL_FRAGMENT_SHADER_ATI, "GL_FRAGMENT_SHADER_ATI" );
	#endif
	#ifdef GL_REG_0_ATI
		swigIntConstant( GL_REG_0_ATI, "GL_REG_0_ATI" );
	#endif
	#ifdef GL_REG_1_ATI
		swigIntConstant( GL_REG_1_ATI, "GL_REG_1_ATI" );
	#endif
	#ifdef GL_REG_2_ATI
		swigIntConstant( GL_REG_2_ATI, "GL_REG_2_ATI" );
	#endif
	#ifdef GL_REG_3_ATI
		swigIntConstant( GL_REG_3_ATI, "GL_REG_3_ATI" );
	#endif
	#ifdef GL_REG_4_ATI
		swigIntConstant( GL_REG_4_ATI, "GL_REG_4_ATI" );
	#endif
	#ifdef GL_REG_5_ATI
		swigIntConstant( GL_REG_5_ATI, "GL_REG_5_ATI" );
	#endif
	#ifdef GL_REG_6_ATI
		swigIntConstant( GL_REG_6_ATI, "GL_REG_6_ATI" );
	#endif
	#ifdef GL_REG_7_ATI
		swigIntConstant( GL_REG_7_ATI, "GL_REG_7_ATI" );
	#endif
	#ifdef GL_REG_8_ATI
		swigIntConstant( GL_REG_8_ATI, "GL_REG_8_ATI" );
	#endif
	#ifdef GL_REG_9_ATI
		swigIntConstant( GL_REG_9_ATI, "GL_REG_9_ATI" );
	#endif
	#ifdef GL_REG_10_ATI
		swigIntConstant( GL_REG_10_ATI, "GL_REG_10_ATI" );
	#endif
	#ifdef GL_REG_11_ATI
		swigIntConstant( GL_REG_11_ATI, "GL_REG_11_ATI" );
	#endif
	#ifdef GL_REG_12_ATI
		swigIntConstant( GL_REG_12_ATI, "GL_REG_12_ATI" );
	#endif
	#ifdef GL_REG_13_ATI
		swigIntConstant( GL_REG_13_ATI, "GL_REG_13_ATI" );
	#endif
	#ifdef GL_REG_14_ATI
		swigIntConstant( GL_REG_14_ATI, "GL_REG_14_ATI" );
	#endif
	#ifdef GL_REG_15_ATI
		swigIntConstant( GL_REG_15_ATI, "GL_REG_15_ATI" );
	#endif
	#ifdef GL_REG_16_ATI
		swigIntConstant( GL_REG_16_ATI, "GL_REG_16_ATI" );
	#endif
	#ifdef GL_REG_17_ATI
		swigIntConstant( GL_REG_17_ATI, "GL_REG_17_ATI" );
	#endif
	#ifdef GL_REG_18_ATI
		swigIntConstant( GL_REG_18_ATI, "GL_REG_18_ATI" );
	#endif
	#ifdef GL_REG_19_ATI
		swigIntConstant( GL_REG_19_ATI, "GL_REG_19_ATI" );
	#endif
	#ifdef GL_REG_20_ATI
		swigIntConstant( GL_REG_20_ATI, "GL_REG_20_ATI" );
	#endif
	#ifdef GL_REG_21_ATI
		swigIntConstant( GL_REG_21_ATI, "GL_REG_21_ATI" );
	#endif
	#ifdef GL_REG_22_ATI
		swigIntConstant( GL_REG_22_ATI, "GL_REG_22_ATI" );
	#endif
	#ifdef GL_REG_23_ATI
		swigIntConstant( GL_REG_23_ATI, "GL_REG_23_ATI" );
	#endif
	#ifdef GL_REG_24_ATI
		swigIntConstant( GL_REG_24_ATI, "GL_REG_24_ATI" );
	#endif
	#ifdef GL_REG_25_ATI
		swigIntConstant( GL_REG_25_ATI, "GL_REG_25_ATI" );
	#endif
	#ifdef GL_REG_26_ATI
		swigIntConstant( GL_REG_26_ATI, "GL_REG_26_ATI" );
	#endif
	#ifdef GL_REG_27_ATI
		swigIntConstant( GL_REG_27_ATI, "GL_REG_27_ATI" );
	#endif
	#ifdef GL_REG_28_ATI
		swigIntConstant( GL_REG_28_ATI, "GL_REG_28_ATI" );
	#endif
	#ifdef GL_REG_29_ATI
		swigIntConstant( GL_REG_29_ATI, "GL_REG_29_ATI" );
	#endif
	#ifdef GL_REG_30_ATI
		swigIntConstant( GL_REG_30_ATI, "GL_REG_30_ATI" );
	#endif
	#ifdef GL_REG_31_ATI
		swigIntConstant( GL_REG_31_ATI, "GL_REG_31_ATI" );
	#endif
	#ifdef GL_CON_0_ATI
		swigIntConstant( GL_CON_0_ATI, "GL_CON_0_ATI" );
	#endif
	#ifdef GL_CON_1_ATI
		swigIntConstant( GL_CON_1_ATI, "GL_CON_1_ATI" );
	#endif
	#ifdef GL_CON_2_ATI
		swigIntConstant( GL_CON_2_ATI, "GL_CON_2_ATI" );
	#endif
	#ifdef GL_CON_3_ATI
		swigIntConstant( GL_CON_3_ATI, "GL_CON_3_ATI" );
	#endif
	#ifdef GL_CON_4_ATI
		swigIntConstant( GL_CON_4_ATI, "GL_CON_4_ATI" );
	#endif
	#ifdef GL_CON_5_ATI
		swigIntConstant( GL_CON_5_ATI, "GL_CON_5_ATI" );
	#endif
	#ifdef GL_CON_6_ATI
		swigIntConstant( GL_CON_6_ATI, "GL_CON_6_ATI" );
	#endif
	#ifdef GL_CON_7_ATI
		swigIntConstant( GL_CON_7_ATI, "GL_CON_7_ATI" );
	#endif
	#ifdef GL_CON_8_ATI
		swigIntConstant( GL_CON_8_ATI, "GL_CON_8_ATI" );
	#endif
	#ifdef GL_CON_9_ATI
		swigIntConstant( GL_CON_9_ATI, "GL_CON_9_ATI" );
	#endif
	#ifdef GL_CON_10_ATI
		swigIntConstant( GL_CON_10_ATI, "GL_CON_10_ATI" );
	#endif
	#ifdef GL_CON_11_ATI
		swigIntConstant( GL_CON_11_ATI, "GL_CON_11_ATI" );
	#endif
	#ifdef GL_CON_12_ATI
		swigIntConstant( GL_CON_12_ATI, "GL_CON_12_ATI" );
	#endif
	#ifdef GL_CON_13_ATI
		swigIntConstant( GL_CON_13_ATI, "GL_CON_13_ATI" );
	#endif
	#ifdef GL_CON_14_ATI
		swigIntConstant( GL_CON_14_ATI, "GL_CON_14_ATI" );
	#endif
	#ifdef GL_CON_15_ATI
		swigIntConstant( GL_CON_15_ATI, "GL_CON_15_ATI" );
	#endif
	#ifdef GL_CON_16_ATI
		swigIntConstant( GL_CON_16_ATI, "GL_CON_16_ATI" );
	#endif
	#ifdef GL_CON_17_ATI
		swigIntConstant( GL_CON_17_ATI, "GL_CON_17_ATI" );
	#endif
	#ifdef GL_CON_18_ATI
		swigIntConstant( GL_CON_18_ATI, "GL_CON_18_ATI" );
	#endif
	#ifdef GL_CON_19_ATI
		swigIntConstant( GL_CON_19_ATI, "GL_CON_19_ATI" );
	#endif
	#ifdef GL_CON_20_ATI
		swigIntConstant( GL_CON_20_ATI, "GL_CON_20_ATI" );
	#endif
	#ifdef GL_CON_21_ATI
		swigIntConstant( GL_CON_21_ATI, "GL_CON_21_ATI" );
	#endif
	#ifdef GL_CON_22_ATI
		swigIntConstant( GL_CON_22_ATI, "GL_CON_22_ATI" );
	#endif
	#ifdef GL_CON_23_ATI
		swigIntConstant( GL_CON_23_ATI, "GL_CON_23_ATI" );
	#endif
	#ifdef GL_CON_24_ATI
		swigIntConstant( GL_CON_24_ATI, "GL_CON_24_ATI" );
	#endif
	#ifdef GL_CON_25_ATI
		swigIntConstant( GL_CON_25_ATI, "GL_CON_25_ATI" );
	#endif
	#ifdef GL_CON_26_ATI
		swigIntConstant( GL_CON_26_ATI, "GL_CON_26_ATI" );
	#endif
	#ifdef GL_CON_27_ATI
		swigIntConstant( GL_CON_27_ATI, "GL_CON_27_ATI" );
	#endif
	#ifdef GL_CON_28_ATI
		swigIntConstant( GL_CON_28_ATI, "GL_CON_28_ATI" );
	#endif
	#ifdef GL_CON_29_ATI
		swigIntConstant( GL_CON_29_ATI, "GL_CON_29_ATI" );
	#endif
	#ifdef GL_CON_30_ATI
		swigIntConstant( GL_CON_30_ATI, "GL_CON_30_ATI" );
	#endif
	#ifdef GL_CON_31_ATI
		swigIntConstant( GL_CON_31_ATI, "GL_CON_31_ATI" );
	#endif
	#ifdef GL_MOV_ATI
		swigIntConstant( GL_MOV_ATI, "GL_MOV_ATI" );
	#endif
	#ifdef GL_ADD_ATI
		swigIntConstant( GL_ADD_ATI, "GL_ADD_ATI" );
	#endif
	#ifdef GL_MUL_ATI
		swigIntConstant( GL_MUL_ATI, "GL_MUL_ATI" );
	#endif
	#ifdef GL_SUB_ATI
		swigIntConstant( GL_SUB_ATI, "GL_SUB_ATI" );
	#endif
	#ifdef GL_DOT3_ATI
		swigIntConstant( GL_DOT3_ATI, "GL_DOT3_ATI" );
	#endif
	#ifdef GL_DOT4_ATI
		swigIntConstant( GL_DOT4_ATI, "GL_DOT4_ATI" );
	#endif
	#ifdef GL_MAD_ATI
		swigIntConstant( GL_MAD_ATI, "GL_MAD_ATI" );
	#endif
	#ifdef GL_LERP_ATI
		swigIntConstant( GL_LERP_ATI, "GL_LERP_ATI" );
	#endif
	#ifdef GL_CND_ATI
		swigIntConstant( GL_CND_ATI, "GL_CND_ATI" );
	#endif
	#ifdef GL_CND0_ATI
		swigIntConstant( GL_CND0_ATI, "GL_CND0_ATI" );
	#endif
	#ifdef GL_DOT2_ADD_ATI
		swigIntConstant( GL_DOT2_ADD_ATI, "GL_DOT2_ADD_ATI" );
	#endif
	#ifdef GL_SECONDARY_INTERPOLATOR_ATI
		swigIntConstant( GL_SECONDARY_INTERPOLATOR_ATI, "GL_SECONDARY_INTERPOLATOR_ATI" );
	#endif
	#ifdef GL_NUM_FRAGMENT_REGISTERS_ATI
		swigIntConstant( GL_NUM_FRAGMENT_REGISTERS_ATI, "GL_NUM_FRAGMENT_REGISTERS_ATI" );
	#endif
	#ifdef GL_NUM_FRAGMENT_CONSTANTS_ATI
		swigIntConstant( GL_NUM_FRAGMENT_CONSTANTS_ATI, "GL_NUM_FRAGMENT_CONSTANTS_ATI" );
	#endif
	#ifdef GL_NUM_PASSES_ATI
		swigIntConstant( GL_NUM_PASSES_ATI, "GL_NUM_PASSES_ATI" );
	#endif
	#ifdef GL_NUM_INSTRUCTIONS_PER_PASS_ATI
		swigIntConstant( GL_NUM_INSTRUCTIONS_PER_PASS_ATI, "GL_NUM_INSTRUCTIONS_PER_PASS_ATI" );
	#endif
	#ifdef GL_NUM_INSTRUCTIONS_TOTAL_ATI
		swigIntConstant( GL_NUM_INSTRUCTIONS_TOTAL_ATI, "GL_NUM_INSTRUCTIONS_TOTAL_ATI" );
	#endif
	#ifdef GL_NUM_INPUT_INTERPOLATOR_COMPONENTS_ATI
		swigIntConstant( GL_NUM_INPUT_INTERPOLATOR_COMPONENTS_ATI, "GL_NUM_INPUT_INTERPOLATOR_COMPONENTS_ATI" );
	#endif
	#ifdef GL_NUM_LOOPBACK_COMPONENTS_ATI
		swigIntConstant( GL_NUM_LOOPBACK_COMPONENTS_ATI, "GL_NUM_LOOPBACK_COMPONENTS_ATI" );
	#endif
	#ifdef GL_COLOR_ALPHA_PAIRING_ATI
		swigIntConstant( GL_COLOR_ALPHA_PAIRING_ATI, "GL_COLOR_ALPHA_PAIRING_ATI" );
	#endif
	#ifdef GL_SWIZZLE_STR_ATI
		swigIntConstant( GL_SWIZZLE_STR_ATI, "GL_SWIZZLE_STR_ATI" );
	#endif
	#ifdef GL_SWIZZLE_STQ_ATI
		swigIntConstant( GL_SWIZZLE_STQ_ATI, "GL_SWIZZLE_STQ_ATI" );
	#endif
	#ifdef GL_SWIZZLE_STR_DR_ATI
		swigIntConstant( GL_SWIZZLE_STR_DR_ATI, "GL_SWIZZLE_STR_DR_ATI" );
	#endif
	#ifdef GL_SWIZZLE_STQ_DQ_ATI
		swigIntConstant( GL_SWIZZLE_STQ_DQ_ATI, "GL_SWIZZLE_STQ_DQ_ATI" );
	#endif
	#ifdef GL_SWIZZLE_STRQ_ATI
		swigIntConstant( GL_SWIZZLE_STRQ_ATI, "GL_SWIZZLE_STRQ_ATI" );
	#endif
	#ifdef GL_SWIZZLE_STRQ_DQ_ATI
		swigIntConstant( GL_SWIZZLE_STRQ_DQ_ATI, "GL_SWIZZLE_STRQ_DQ_ATI" );
	#endif
	#ifdef GL_RED_BIT_ATI
		swigIntConstant( GL_RED_BIT_ATI, "GL_RED_BIT_ATI" );
	#endif
	#ifdef GL_GREEN_BIT_ATI
		swigIntConstant( GL_GREEN_BIT_ATI, "GL_GREEN_BIT_ATI" );
	#endif
	#ifdef GL_BLUE_BIT_ATI
		swigIntConstant( GL_BLUE_BIT_ATI, "GL_BLUE_BIT_ATI" );
	#endif
	#ifdef GL_2X_BIT_ATI
		swigIntConstant( GL_2X_BIT_ATI, "GL_2X_BIT_ATI" );
	#endif
	#ifdef GL_4X_BIT_ATI
		swigIntConstant( GL_4X_BIT_ATI, "GL_4X_BIT_ATI" );
	#endif
	#ifdef GL_8X_BIT_ATI
		swigIntConstant( GL_8X_BIT_ATI, "GL_8X_BIT_ATI" );
	#endif
	#ifdef GL_HALF_BIT_ATI
		swigIntConstant( GL_HALF_BIT_ATI, "GL_HALF_BIT_ATI" );
	#endif
	#ifdef GL_QUARTER_BIT_ATI
		swigIntConstant( GL_QUARTER_BIT_ATI, "GL_QUARTER_BIT_ATI" );
	#endif
	#ifdef GL_EIGHTH_BIT_ATI
		swigIntConstant( GL_EIGHTH_BIT_ATI, "GL_EIGHTH_BIT_ATI" );
	#endif
	#ifdef GL_SATURATE_BIT_ATI
		swigIntConstant( GL_SATURATE_BIT_ATI, "GL_SATURATE_BIT_ATI" );
	#endif
	#ifdef GL_COMP_BIT_ATI
		swigIntConstant( GL_COMP_BIT_ATI, "GL_COMP_BIT_ATI" );
	#endif
	#ifdef GL_NEGATE_BIT_ATI
		swigIntConstant( GL_NEGATE_BIT_ATI, "GL_NEGATE_BIT_ATI" );
	#endif
	#ifdef GL_BIAS_BIT_ATI
		swigIntConstant( GL_BIAS_BIT_ATI, "GL_BIAS_BIT_ATI" );
	#endif
	#ifdef GL_ATI_map_object_buffer
		swigIntConstant( GL_ATI_map_object_buffer, "GL_ATI_map_object_buffer" );
	#endif
	#ifdef GL_ATI_meminfo
		swigIntConstant( GL_ATI_meminfo, "GL_ATI_meminfo" );
	#endif
	#ifdef GL_VBO_FREE_MEMORY_ATI
		swigIntConstant( GL_VBO_FREE_MEMORY_ATI, "GL_VBO_FREE_MEMORY_ATI" );
	#endif
	#ifdef GL_TEXTURE_FREE_MEMORY_ATI
		swigIntConstant( GL_TEXTURE_FREE_MEMORY_ATI, "GL_TEXTURE_FREE_MEMORY_ATI" );
	#endif
	#ifdef GL_RENDERBUFFER_FREE_MEMORY_ATI
		swigIntConstant( GL_RENDERBUFFER_FREE_MEMORY_ATI, "GL_RENDERBUFFER_FREE_MEMORY_ATI" );
	#endif
	#ifdef GL_ATI_pixel_format_float
		swigIntConstant( GL_ATI_pixel_format_float, "GL_ATI_pixel_format_float" );
	#endif
	#ifdef GL_RGBA_FLOAT_MODE_ATI
		swigIntConstant( GL_RGBA_FLOAT_MODE_ATI, "GL_RGBA_FLOAT_MODE_ATI" );
	#endif
	#ifdef GL_COLOR_CLEAR_UNCLAMPED_VALUE_ATI
		swigIntConstant( GL_COLOR_CLEAR_UNCLAMPED_VALUE_ATI, "GL_COLOR_CLEAR_UNCLAMPED_VALUE_ATI" );
	#endif
	#ifdef GL_ATI_pn_triangles
		swigIntConstant( GL_ATI_pn_triangles, "GL_ATI_pn_triangles" );
	#endif
	#ifdef GL_PN_TRIANGLES_ATI
		swigIntConstant( GL_PN_TRIANGLES_ATI, "GL_PN_TRIANGLES_ATI" );
	#endif
	#ifdef GL_MAX_PN_TRIANGLES_TESSELATION_LEVEL_ATI
		swigIntConstant( GL_MAX_PN_TRIANGLES_TESSELATION_LEVEL_ATI, "GL_MAX_PN_TRIANGLES_TESSELATION_LEVEL_ATI" );
	#endif
	#ifdef GL_PN_TRIANGLES_POINT_MODE_ATI
		swigIntConstant( GL_PN_TRIANGLES_POINT_MODE_ATI, "GL_PN_TRIANGLES_POINT_MODE_ATI" );
	#endif
	#ifdef GL_PN_TRIANGLES_NORMAL_MODE_ATI
		swigIntConstant( GL_PN_TRIANGLES_NORMAL_MODE_ATI, "GL_PN_TRIANGLES_NORMAL_MODE_ATI" );
	#endif
	#ifdef GL_PN_TRIANGLES_TESSELATION_LEVEL_ATI
		swigIntConstant( GL_PN_TRIANGLES_TESSELATION_LEVEL_ATI, "GL_PN_TRIANGLES_TESSELATION_LEVEL_ATI" );
	#endif
	#ifdef GL_PN_TRIANGLES_POINT_MODE_LINEAR_ATI
		swigIntConstant( GL_PN_TRIANGLES_POINT_MODE_LINEAR_ATI, "GL_PN_TRIANGLES_POINT_MODE_LINEAR_ATI" );
	#endif
	#ifdef GL_PN_TRIANGLES_POINT_MODE_CUBIC_ATI
		swigIntConstant( GL_PN_TRIANGLES_POINT_MODE_CUBIC_ATI, "GL_PN_TRIANGLES_POINT_MODE_CUBIC_ATI" );
	#endif
	#ifdef GL_PN_TRIANGLES_NORMAL_MODE_LINEAR_ATI
		swigIntConstant( GL_PN_TRIANGLES_NORMAL_MODE_LINEAR_ATI, "GL_PN_TRIANGLES_NORMAL_MODE_LINEAR_ATI" );
	#endif
	#ifdef GL_PN_TRIANGLES_NORMAL_MODE_QUADRATIC_ATI
		swigIntConstant( GL_PN_TRIANGLES_NORMAL_MODE_QUADRATIC_ATI, "GL_PN_TRIANGLES_NORMAL_MODE_QUADRATIC_ATI" );
	#endif
	#ifdef GL_ATI_separate_stencil
		swigIntConstant( GL_ATI_separate_stencil, "GL_ATI_separate_stencil" );
	#endif
	#ifdef GL_STENCIL_BACK_FUNC_ATI
		swigIntConstant( GL_STENCIL_BACK_FUNC_ATI, "GL_STENCIL_BACK_FUNC_ATI" );
	#endif
	#ifdef GL_STENCIL_BACK_FAIL_ATI
		swigIntConstant( GL_STENCIL_BACK_FAIL_ATI, "GL_STENCIL_BACK_FAIL_ATI" );
	#endif
	#ifdef GL_STENCIL_BACK_PASS_DEPTH_FAIL_ATI
		swigIntConstant( GL_STENCIL_BACK_PASS_DEPTH_FAIL_ATI, "GL_STENCIL_BACK_PASS_DEPTH_FAIL_ATI" );
	#endif
	#ifdef GL_STENCIL_BACK_PASS_DEPTH_PASS_ATI
		swigIntConstant( GL_STENCIL_BACK_PASS_DEPTH_PASS_ATI, "GL_STENCIL_BACK_PASS_DEPTH_PASS_ATI" );
	#endif
	#ifdef GL_ATI_text_fragment_shader
		swigIntConstant( GL_ATI_text_fragment_shader, "GL_ATI_text_fragment_shader" );
	#endif
	#ifdef GL_TEXT_FRAGMENT_SHADER_ATI
		swigIntConstant( GL_TEXT_FRAGMENT_SHADER_ATI, "GL_TEXT_FRAGMENT_SHADER_ATI" );
	#endif
	#ifdef GL_ATI_texture_env_combine3
		swigIntConstant( GL_ATI_texture_env_combine3, "GL_ATI_texture_env_combine3" );
	#endif
	#ifdef GL_MODULATE_ADD_ATI
		swigIntConstant( GL_MODULATE_ADD_ATI, "GL_MODULATE_ADD_ATI" );
	#endif
	#ifdef GL_MODULATE_SIGNED_ADD_ATI
		swigIntConstant( GL_MODULATE_SIGNED_ADD_ATI, "GL_MODULATE_SIGNED_ADD_ATI" );
	#endif
	#ifdef GL_MODULATE_SUBTRACT_ATI
		swigIntConstant( GL_MODULATE_SUBTRACT_ATI, "GL_MODULATE_SUBTRACT_ATI" );
	#endif
	#ifdef GL_ATI_texture_float
		swigIntConstant( GL_ATI_texture_float, "GL_ATI_texture_float" );
	#endif
	#ifdef GL_RGBA_FLOAT32_ATI
		swigIntConstant( GL_RGBA_FLOAT32_ATI, "GL_RGBA_FLOAT32_ATI" );
	#endif
	#ifdef GL_RGB_FLOAT32_ATI
		swigIntConstant( GL_RGB_FLOAT32_ATI, "GL_RGB_FLOAT32_ATI" );
	#endif
	#ifdef GL_ALPHA_FLOAT32_ATI
		swigIntConstant( GL_ALPHA_FLOAT32_ATI, "GL_ALPHA_FLOAT32_ATI" );
	#endif
	#ifdef GL_INTENSITY_FLOAT32_ATI
		swigIntConstant( GL_INTENSITY_FLOAT32_ATI, "GL_INTENSITY_FLOAT32_ATI" );
	#endif
	#ifdef GL_LUMINANCE_FLOAT32_ATI
		swigIntConstant( GL_LUMINANCE_FLOAT32_ATI, "GL_LUMINANCE_FLOAT32_ATI" );
	#endif
	#ifdef GL_LUMINANCE_ALPHA_FLOAT32_ATI
		swigIntConstant( GL_LUMINANCE_ALPHA_FLOAT32_ATI, "GL_LUMINANCE_ALPHA_FLOAT32_ATI" );
	#endif
	#ifdef GL_RGBA_FLOAT16_ATI
		swigIntConstant( GL_RGBA_FLOAT16_ATI, "GL_RGBA_FLOAT16_ATI" );
	#endif
	#ifdef GL_RGB_FLOAT16_ATI
		swigIntConstant( GL_RGB_FLOAT16_ATI, "GL_RGB_FLOAT16_ATI" );
	#endif
	#ifdef GL_ALPHA_FLOAT16_ATI
		swigIntConstant( GL_ALPHA_FLOAT16_ATI, "GL_ALPHA_FLOAT16_ATI" );
	#endif
	#ifdef GL_INTENSITY_FLOAT16_ATI
		swigIntConstant( GL_INTENSITY_FLOAT16_ATI, "GL_INTENSITY_FLOAT16_ATI" );
	#endif
	#ifdef GL_LUMINANCE_FLOAT16_ATI
		swigIntConstant( GL_LUMINANCE_FLOAT16_ATI, "GL_LUMINANCE_FLOAT16_ATI" );
	#endif
	#ifdef GL_LUMINANCE_ALPHA_FLOAT16_ATI
		swigIntConstant( GL_LUMINANCE_ALPHA_FLOAT16_ATI, "GL_LUMINANCE_ALPHA_FLOAT16_ATI" );
	#endif
	#ifdef GL_ATI_texture_mirror_once
		swigIntConstant( GL_ATI_texture_mirror_once, "GL_ATI_texture_mirror_once" );
	#endif
	#ifdef GL_MIRROR_CLAMP_ATI
		swigIntConstant( GL_MIRROR_CLAMP_ATI, "GL_MIRROR_CLAMP_ATI" );
	#endif
	#ifdef GL_MIRROR_CLAMP_TO_EDGE_ATI
		swigIntConstant( GL_MIRROR_CLAMP_TO_EDGE_ATI, "GL_MIRROR_CLAMP_TO_EDGE_ATI" );
	#endif
	#ifdef GL_ATI_vertex_array_object
		swigIntConstant( GL_ATI_vertex_array_object, "GL_ATI_vertex_array_object" );
	#endif
	#ifdef GL_STATIC_ATI
		swigIntConstant( GL_STATIC_ATI, "GL_STATIC_ATI" );
	#endif
	#ifdef GL_DYNAMIC_ATI
		swigIntConstant( GL_DYNAMIC_ATI, "GL_DYNAMIC_ATI" );
	#endif
	#ifdef GL_PRESERVE_ATI
		swigIntConstant( GL_PRESERVE_ATI, "GL_PRESERVE_ATI" );
	#endif
	#ifdef GL_DISCARD_ATI
		swigIntConstant( GL_DISCARD_ATI, "GL_DISCARD_ATI" );
	#endif
	#ifdef GL_OBJECT_BUFFER_SIZE_ATI
		swigIntConstant( GL_OBJECT_BUFFER_SIZE_ATI, "GL_OBJECT_BUFFER_SIZE_ATI" );
	#endif
	#ifdef GL_OBJECT_BUFFER_USAGE_ATI
		swigIntConstant( GL_OBJECT_BUFFER_USAGE_ATI, "GL_OBJECT_BUFFER_USAGE_ATI" );
	#endif
	#ifdef GL_ARRAY_OBJECT_BUFFER_ATI
		swigIntConstant( GL_ARRAY_OBJECT_BUFFER_ATI, "GL_ARRAY_OBJECT_BUFFER_ATI" );
	#endif
	#ifdef GL_ARRAY_OBJECT_OFFSET_ATI
		swigIntConstant( GL_ARRAY_OBJECT_OFFSET_ATI, "GL_ARRAY_OBJECT_OFFSET_ATI" );
	#endif
	#ifdef GL_ATI_vertex_attrib_array_object
		swigIntConstant( GL_ATI_vertex_attrib_array_object, "GL_ATI_vertex_attrib_array_object" );
	#endif
	#ifdef GL_ATI_vertex_streams
		swigIntConstant( GL_ATI_vertex_streams, "GL_ATI_vertex_streams" );
	#endif
	#ifdef GL_MAX_VERTEX_STREAMS_ATI
		swigIntConstant( GL_MAX_VERTEX_STREAMS_ATI, "GL_MAX_VERTEX_STREAMS_ATI" );
	#endif
	#ifdef GL_VERTEX_STREAM0_ATI
		swigIntConstant( GL_VERTEX_STREAM0_ATI, "GL_VERTEX_STREAM0_ATI" );
	#endif
	#ifdef GL_VERTEX_STREAM1_ATI
		swigIntConstant( GL_VERTEX_STREAM1_ATI, "GL_VERTEX_STREAM1_ATI" );
	#endif
	#ifdef GL_VERTEX_STREAM2_ATI
		swigIntConstant( GL_VERTEX_STREAM2_ATI, "GL_VERTEX_STREAM2_ATI" );
	#endif
	#ifdef GL_VERTEX_STREAM3_ATI
		swigIntConstant( GL_VERTEX_STREAM3_ATI, "GL_VERTEX_STREAM3_ATI" );
	#endif
	#ifdef GL_VERTEX_STREAM4_ATI
		swigIntConstant( GL_VERTEX_STREAM4_ATI, "GL_VERTEX_STREAM4_ATI" );
	#endif
	#ifdef GL_VERTEX_STREAM5_ATI
		swigIntConstant( GL_VERTEX_STREAM5_ATI, "GL_VERTEX_STREAM5_ATI" );
	#endif
	#ifdef GL_VERTEX_STREAM6_ATI
		swigIntConstant( GL_VERTEX_STREAM6_ATI, "GL_VERTEX_STREAM6_ATI" );
	#endif
	#ifdef GL_VERTEX_STREAM7_ATI
		swigIntConstant( GL_VERTEX_STREAM7_ATI, "GL_VERTEX_STREAM7_ATI" );
	#endif
	#ifdef GL_VERTEX_SOURCE_ATI
		swigIntConstant( GL_VERTEX_SOURCE_ATI, "GL_VERTEX_SOURCE_ATI" );
	#endif
	#ifdef GL_EXT_422_pixels
		swigIntConstant( GL_EXT_422_pixels, "GL_EXT_422_pixels" );
	#endif
	#ifdef GL_422_EXT
		swigIntConstant( GL_422_EXT, "GL_422_EXT" );
	#endif
	#ifdef GL_422_REV_EXT
		swigIntConstant( GL_422_REV_EXT, "GL_422_REV_EXT" );
	#endif
	#ifdef GL_422_AVERAGE_EXT
		swigIntConstant( GL_422_AVERAGE_EXT, "GL_422_AVERAGE_EXT" );
	#endif
	#ifdef GL_422_REV_AVERAGE_EXT
		swigIntConstant( GL_422_REV_AVERAGE_EXT, "GL_422_REV_AVERAGE_EXT" );
	#endif
	#ifdef GL_EXT_EGL_image_storage
		swigIntConstant( GL_EXT_EGL_image_storage, "GL_EXT_EGL_image_storage" );
	#endif
	#ifdef GL_EXT_EGL_sync
		swigIntConstant( GL_EXT_EGL_sync, "GL_EXT_EGL_sync" );
	#endif
	#ifdef GL_EXT_abgr
		swigIntConstant( GL_EXT_abgr, "GL_EXT_abgr" );
	#endif
	#ifdef GL_ABGR_EXT
		swigIntConstant( GL_ABGR_EXT, "GL_ABGR_EXT" );
	#endif
	#ifdef GL_EXT_bgra
		swigIntConstant( GL_EXT_bgra, "GL_EXT_bgra" );
	#endif
	#ifdef GL_BGR_EXT
		swigIntConstant( GL_BGR_EXT, "GL_BGR_EXT" );
	#endif
	#ifdef GL_BGRA_EXT
		swigIntConstant( GL_BGRA_EXT, "GL_BGRA_EXT" );
	#endif
	#ifdef GL_EXT_bindable_uniform
		swigIntConstant( GL_EXT_bindable_uniform, "GL_EXT_bindable_uniform" );
	#endif
	#ifdef GL_MAX_VERTEX_BINDABLE_UNIFORMS_EXT
		swigIntConstant( GL_MAX_VERTEX_BINDABLE_UNIFORMS_EXT, "GL_MAX_VERTEX_BINDABLE_UNIFORMS_EXT" );
	#endif
	#ifdef GL_MAX_FRAGMENT_BINDABLE_UNIFORMS_EXT
		swigIntConstant( GL_MAX_FRAGMENT_BINDABLE_UNIFORMS_EXT, "GL_MAX_FRAGMENT_BINDABLE_UNIFORMS_EXT" );
	#endif
	#ifdef GL_MAX_GEOMETRY_BINDABLE_UNIFORMS_EXT
		swigIntConstant( GL_MAX_GEOMETRY_BINDABLE_UNIFORMS_EXT, "GL_MAX_GEOMETRY_BINDABLE_UNIFORMS_EXT" );
	#endif
	#ifdef GL_MAX_BINDABLE_UNIFORM_SIZE_EXT
		swigIntConstant( GL_MAX_BINDABLE_UNIFORM_SIZE_EXT, "GL_MAX_BINDABLE_UNIFORM_SIZE_EXT" );
	#endif
	#ifdef GL_UNIFORM_BUFFER_EXT
		swigIntConstant( GL_UNIFORM_BUFFER_EXT, "GL_UNIFORM_BUFFER_EXT" );
	#endif
	#ifdef GL_UNIFORM_BUFFER_BINDING_EXT
		swigIntConstant( GL_UNIFORM_BUFFER_BINDING_EXT, "GL_UNIFORM_BUFFER_BINDING_EXT" );
	#endif
	#ifdef GL_EXT_blend_color
		swigIntConstant( GL_EXT_blend_color, "GL_EXT_blend_color" );
	#endif
	#ifdef GL_CONSTANT_COLOR_EXT
		swigIntConstant( GL_CONSTANT_COLOR_EXT, "GL_CONSTANT_COLOR_EXT" );
	#endif
	#ifdef GL_ONE_MINUS_CONSTANT_COLOR_EXT
		swigIntConstant( GL_ONE_MINUS_CONSTANT_COLOR_EXT, "GL_ONE_MINUS_CONSTANT_COLOR_EXT" );
	#endif
	#ifdef GL_CONSTANT_ALPHA_EXT
		swigIntConstant( GL_CONSTANT_ALPHA_EXT, "GL_CONSTANT_ALPHA_EXT" );
	#endif
	#ifdef GL_ONE_MINUS_CONSTANT_ALPHA_EXT
		swigIntConstant( GL_ONE_MINUS_CONSTANT_ALPHA_EXT, "GL_ONE_MINUS_CONSTANT_ALPHA_EXT" );
	#endif
	#ifdef GL_BLEND_COLOR_EXT
		swigIntConstant( GL_BLEND_COLOR_EXT, "GL_BLEND_COLOR_EXT" );
	#endif
	#ifdef GL_EXT_blend_equation_separate
		swigIntConstant( GL_EXT_blend_equation_separate, "GL_EXT_blend_equation_separate" );
	#endif
	#ifdef GL_BLEND_EQUATION_RGB_EXT
		swigIntConstant( GL_BLEND_EQUATION_RGB_EXT, "GL_BLEND_EQUATION_RGB_EXT" );
	#endif
	#ifdef GL_BLEND_EQUATION_ALPHA_EXT
		swigIntConstant( GL_BLEND_EQUATION_ALPHA_EXT, "GL_BLEND_EQUATION_ALPHA_EXT" );
	#endif
	#ifdef GL_EXT_blend_func_separate
		swigIntConstant( GL_EXT_blend_func_separate, "GL_EXT_blend_func_separate" );
	#endif
	#ifdef GL_BLEND_DST_RGB_EXT
		swigIntConstant( GL_BLEND_DST_RGB_EXT, "GL_BLEND_DST_RGB_EXT" );
	#endif
	#ifdef GL_BLEND_SRC_RGB_EXT
		swigIntConstant( GL_BLEND_SRC_RGB_EXT, "GL_BLEND_SRC_RGB_EXT" );
	#endif
	#ifdef GL_BLEND_DST_ALPHA_EXT
		swigIntConstant( GL_BLEND_DST_ALPHA_EXT, "GL_BLEND_DST_ALPHA_EXT" );
	#endif
	#ifdef GL_BLEND_SRC_ALPHA_EXT
		swigIntConstant( GL_BLEND_SRC_ALPHA_EXT, "GL_BLEND_SRC_ALPHA_EXT" );
	#endif
	#ifdef GL_EXT_blend_logic_op
		swigIntConstant( GL_EXT_blend_logic_op, "GL_EXT_blend_logic_op" );
	#endif
	#ifdef GL_EXT_blend_minmax
		swigIntConstant( GL_EXT_blend_minmax, "GL_EXT_blend_minmax" );
	#endif
	#ifdef GL_MIN_EXT
		swigIntConstant( GL_MIN_EXT, "GL_MIN_EXT" );
	#endif
	#ifdef GL_MAX_EXT
		swigIntConstant( GL_MAX_EXT, "GL_MAX_EXT" );
	#endif
	#ifdef GL_FUNC_ADD_EXT
		swigIntConstant( GL_FUNC_ADD_EXT, "GL_FUNC_ADD_EXT" );
	#endif
	#ifdef GL_BLEND_EQUATION_EXT
		swigIntConstant( GL_BLEND_EQUATION_EXT, "GL_BLEND_EQUATION_EXT" );
	#endif
	#ifdef GL_EXT_blend_subtract
		swigIntConstant( GL_EXT_blend_subtract, "GL_EXT_blend_subtract" );
	#endif
	#ifdef GL_FUNC_SUBTRACT_EXT
		swigIntConstant( GL_FUNC_SUBTRACT_EXT, "GL_FUNC_SUBTRACT_EXT" );
	#endif
	#ifdef GL_FUNC_REVERSE_SUBTRACT_EXT
		swigIntConstant( GL_FUNC_REVERSE_SUBTRACT_EXT, "GL_FUNC_REVERSE_SUBTRACT_EXT" );
	#endif
	#ifdef GL_EXT_clip_volume_hint
		swigIntConstant( GL_EXT_clip_volume_hint, "GL_EXT_clip_volume_hint" );
	#endif
	#ifdef GL_CLIP_VOLUME_CLIPPING_HINT_EXT
		swigIntConstant( GL_CLIP_VOLUME_CLIPPING_HINT_EXT, "GL_CLIP_VOLUME_CLIPPING_HINT_EXT" );
	#endif
	#ifdef GL_EXT_cmyka
		swigIntConstant( GL_EXT_cmyka, "GL_EXT_cmyka" );
	#endif
	#ifdef GL_CMYK_EXT
		swigIntConstant( GL_CMYK_EXT, "GL_CMYK_EXT" );
	#endif
	#ifdef GL_CMYKA_EXT
		swigIntConstant( GL_CMYKA_EXT, "GL_CMYKA_EXT" );
	#endif
	#ifdef GL_PACK_CMYK_HINT_EXT
		swigIntConstant( GL_PACK_CMYK_HINT_EXT, "GL_PACK_CMYK_HINT_EXT" );
	#endif
	#ifdef GL_UNPACK_CMYK_HINT_EXT
		swigIntConstant( GL_UNPACK_CMYK_HINT_EXT, "GL_UNPACK_CMYK_HINT_EXT" );
	#endif
	#ifdef GL_EXT_color_subtable
		swigIntConstant( GL_EXT_color_subtable, "GL_EXT_color_subtable" );
	#endif
	#ifdef GL_EXT_compiled_vertex_array
		swigIntConstant( GL_EXT_compiled_vertex_array, "GL_EXT_compiled_vertex_array" );
	#endif
	#ifdef GL_ARRAY_ELEMENT_LOCK_FIRST_EXT
		swigIntConstant( GL_ARRAY_ELEMENT_LOCK_FIRST_EXT, "GL_ARRAY_ELEMENT_LOCK_FIRST_EXT" );
	#endif
	#ifdef GL_ARRAY_ELEMENT_LOCK_COUNT_EXT
		swigIntConstant( GL_ARRAY_ELEMENT_LOCK_COUNT_EXT, "GL_ARRAY_ELEMENT_LOCK_COUNT_EXT" );
	#endif
	#ifdef GL_EXT_convolution
		swigIntConstant( GL_EXT_convolution, "GL_EXT_convolution" );
	#endif
	#ifdef GL_CONVOLUTION_1D_EXT
		swigIntConstant( GL_CONVOLUTION_1D_EXT, "GL_CONVOLUTION_1D_EXT" );
	#endif
	#ifdef GL_CONVOLUTION_2D_EXT
		swigIntConstant( GL_CONVOLUTION_2D_EXT, "GL_CONVOLUTION_2D_EXT" );
	#endif
	#ifdef GL_SEPARABLE_2D_EXT
		swigIntConstant( GL_SEPARABLE_2D_EXT, "GL_SEPARABLE_2D_EXT" );
	#endif
	#ifdef GL_CONVOLUTION_BORDER_MODE_EXT
		swigIntConstant( GL_CONVOLUTION_BORDER_MODE_EXT, "GL_CONVOLUTION_BORDER_MODE_EXT" );
	#endif
	#ifdef GL_CONVOLUTION_FILTER_SCALE_EXT
		swigIntConstant( GL_CONVOLUTION_FILTER_SCALE_EXT, "GL_CONVOLUTION_FILTER_SCALE_EXT" );
	#endif
	#ifdef GL_CONVOLUTION_FILTER_BIAS_EXT
		swigIntConstant( GL_CONVOLUTION_FILTER_BIAS_EXT, "GL_CONVOLUTION_FILTER_BIAS_EXT" );
	#endif
	#ifdef GL_REDUCE_EXT
		swigIntConstant( GL_REDUCE_EXT, "GL_REDUCE_EXT" );
	#endif
	#ifdef GL_CONVOLUTION_FORMAT_EXT
		swigIntConstant( GL_CONVOLUTION_FORMAT_EXT, "GL_CONVOLUTION_FORMAT_EXT" );
	#endif
	#ifdef GL_CONVOLUTION_WIDTH_EXT
		swigIntConstant( GL_CONVOLUTION_WIDTH_EXT, "GL_CONVOLUTION_WIDTH_EXT" );
	#endif
	#ifdef GL_CONVOLUTION_HEIGHT_EXT
		swigIntConstant( GL_CONVOLUTION_HEIGHT_EXT, "GL_CONVOLUTION_HEIGHT_EXT" );
	#endif
	#ifdef GL_MAX_CONVOLUTION_WIDTH_EXT
		swigIntConstant( GL_MAX_CONVOLUTION_WIDTH_EXT, "GL_MAX_CONVOLUTION_WIDTH_EXT" );
	#endif
	#ifdef GL_MAX_CONVOLUTION_HEIGHT_EXT
		swigIntConstant( GL_MAX_CONVOLUTION_HEIGHT_EXT, "GL_MAX_CONVOLUTION_HEIGHT_EXT" );
	#endif
	#ifdef GL_POST_CONVOLUTION_RED_SCALE_EXT
		swigIntConstant( GL_POST_CONVOLUTION_RED_SCALE_EXT, "GL_POST_CONVOLUTION_RED_SCALE_EXT" );
	#endif
	#ifdef GL_POST_CONVOLUTION_GREEN_SCALE_EXT
		swigIntConstant( GL_POST_CONVOLUTION_GREEN_SCALE_EXT, "GL_POST_CONVOLUTION_GREEN_SCALE_EXT" );
	#endif
	#ifdef GL_POST_CONVOLUTION_BLUE_SCALE_EXT
		swigIntConstant( GL_POST_CONVOLUTION_BLUE_SCALE_EXT, "GL_POST_CONVOLUTION_BLUE_SCALE_EXT" );
	#endif
	#ifdef GL_POST_CONVOLUTION_ALPHA_SCALE_EXT
		swigIntConstant( GL_POST_CONVOLUTION_ALPHA_SCALE_EXT, "GL_POST_CONVOLUTION_ALPHA_SCALE_EXT" );
	#endif
	#ifdef GL_POST_CONVOLUTION_RED_BIAS_EXT
		swigIntConstant( GL_POST_CONVOLUTION_RED_BIAS_EXT, "GL_POST_CONVOLUTION_RED_BIAS_EXT" );
	#endif
	#ifdef GL_POST_CONVOLUTION_GREEN_BIAS_EXT
		swigIntConstant( GL_POST_CONVOLUTION_GREEN_BIAS_EXT, "GL_POST_CONVOLUTION_GREEN_BIAS_EXT" );
	#endif
	#ifdef GL_POST_CONVOLUTION_BLUE_BIAS_EXT
		swigIntConstant( GL_POST_CONVOLUTION_BLUE_BIAS_EXT, "GL_POST_CONVOLUTION_BLUE_BIAS_EXT" );
	#endif
	#ifdef GL_POST_CONVOLUTION_ALPHA_BIAS_EXT
		swigIntConstant( GL_POST_CONVOLUTION_ALPHA_BIAS_EXT, "GL_POST_CONVOLUTION_ALPHA_BIAS_EXT" );
	#endif
	#ifdef GL_EXT_coordinate_frame
		swigIntConstant( GL_EXT_coordinate_frame, "GL_EXT_coordinate_frame" );
	#endif
	#ifdef GL_TANGENT_ARRAY_EXT
		swigIntConstant( GL_TANGENT_ARRAY_EXT, "GL_TANGENT_ARRAY_EXT" );
	#endif
	#ifdef GL_BINORMAL_ARRAY_EXT
		swigIntConstant( GL_BINORMAL_ARRAY_EXT, "GL_BINORMAL_ARRAY_EXT" );
	#endif
	#ifdef GL_CURRENT_TANGENT_EXT
		swigIntConstant( GL_CURRENT_TANGENT_EXT, "GL_CURRENT_TANGENT_EXT" );
	#endif
	#ifdef GL_CURRENT_BINORMAL_EXT
		swigIntConstant( GL_CURRENT_BINORMAL_EXT, "GL_CURRENT_BINORMAL_EXT" );
	#endif
	#ifdef GL_TANGENT_ARRAY_TYPE_EXT
		swigIntConstant( GL_TANGENT_ARRAY_TYPE_EXT, "GL_TANGENT_ARRAY_TYPE_EXT" );
	#endif
	#ifdef GL_TANGENT_ARRAY_STRIDE_EXT
		swigIntConstant( GL_TANGENT_ARRAY_STRIDE_EXT, "GL_TANGENT_ARRAY_STRIDE_EXT" );
	#endif
	#ifdef GL_BINORMAL_ARRAY_TYPE_EXT
		swigIntConstant( GL_BINORMAL_ARRAY_TYPE_EXT, "GL_BINORMAL_ARRAY_TYPE_EXT" );
	#endif
	#ifdef GL_BINORMAL_ARRAY_STRIDE_EXT
		swigIntConstant( GL_BINORMAL_ARRAY_STRIDE_EXT, "GL_BINORMAL_ARRAY_STRIDE_EXT" );
	#endif
	#ifdef GL_TANGENT_ARRAY_POINTER_EXT
		swigIntConstant( GL_TANGENT_ARRAY_POINTER_EXT, "GL_TANGENT_ARRAY_POINTER_EXT" );
	#endif
	#ifdef GL_BINORMAL_ARRAY_POINTER_EXT
		swigIntConstant( GL_BINORMAL_ARRAY_POINTER_EXT, "GL_BINORMAL_ARRAY_POINTER_EXT" );
	#endif
	#ifdef GL_MAP1_TANGENT_EXT
		swigIntConstant( GL_MAP1_TANGENT_EXT, "GL_MAP1_TANGENT_EXT" );
	#endif
	#ifdef GL_MAP2_TANGENT_EXT
		swigIntConstant( GL_MAP2_TANGENT_EXT, "GL_MAP2_TANGENT_EXT" );
	#endif
	#ifdef GL_MAP1_BINORMAL_EXT
		swigIntConstant( GL_MAP1_BINORMAL_EXT, "GL_MAP1_BINORMAL_EXT" );
	#endif
	#ifdef GL_MAP2_BINORMAL_EXT
		swigIntConstant( GL_MAP2_BINORMAL_EXT, "GL_MAP2_BINORMAL_EXT" );
	#endif
	#ifdef GL_EXT_copy_texture
		swigIntConstant( GL_EXT_copy_texture, "GL_EXT_copy_texture" );
	#endif
	#ifdef GL_EXT_cull_vertex
		swigIntConstant( GL_EXT_cull_vertex, "GL_EXT_cull_vertex" );
	#endif
	#ifdef GL_CULL_VERTEX_EXT
		swigIntConstant( GL_CULL_VERTEX_EXT, "GL_CULL_VERTEX_EXT" );
	#endif
	#ifdef GL_CULL_VERTEX_EYE_POSITION_EXT
		swigIntConstant( GL_CULL_VERTEX_EYE_POSITION_EXT, "GL_CULL_VERTEX_EYE_POSITION_EXT" );
	#endif
	#ifdef GL_CULL_VERTEX_OBJECT_POSITION_EXT
		swigIntConstant( GL_CULL_VERTEX_OBJECT_POSITION_EXT, "GL_CULL_VERTEX_OBJECT_POSITION_EXT" );
	#endif
	#ifdef GL_EXT_debug_label
		swigIntConstant( GL_EXT_debug_label, "GL_EXT_debug_label" );
	#endif
	#ifdef GL_PROGRAM_PIPELINE_OBJECT_EXT
		swigIntConstant( GL_PROGRAM_PIPELINE_OBJECT_EXT, "GL_PROGRAM_PIPELINE_OBJECT_EXT" );
	#endif
	#ifdef GL_PROGRAM_OBJECT_EXT
		swigIntConstant( GL_PROGRAM_OBJECT_EXT, "GL_PROGRAM_OBJECT_EXT" );
	#endif
	#ifdef GL_SHADER_OBJECT_EXT
		swigIntConstant( GL_SHADER_OBJECT_EXT, "GL_SHADER_OBJECT_EXT" );
	#endif
	#ifdef GL_BUFFER_OBJECT_EXT
		swigIntConstant( GL_BUFFER_OBJECT_EXT, "GL_BUFFER_OBJECT_EXT" );
	#endif
	#ifdef GL_QUERY_OBJECT_EXT
		swigIntConstant( GL_QUERY_OBJECT_EXT, "GL_QUERY_OBJECT_EXT" );
	#endif
	#ifdef GL_VERTEX_ARRAY_OBJECT_EXT
		swigIntConstant( GL_VERTEX_ARRAY_OBJECT_EXT, "GL_VERTEX_ARRAY_OBJECT_EXT" );
	#endif
	#ifdef GL_EXT_debug_marker
		swigIntConstant( GL_EXT_debug_marker, "GL_EXT_debug_marker" );
	#endif
	#ifdef GL_EXT_depth_bounds_test
		swigIntConstant( GL_EXT_depth_bounds_test, "GL_EXT_depth_bounds_test" );
	#endif
	#ifdef GL_DEPTH_BOUNDS_TEST_EXT
		swigIntConstant( GL_DEPTH_BOUNDS_TEST_EXT, "GL_DEPTH_BOUNDS_TEST_EXT" );
	#endif
	#ifdef GL_DEPTH_BOUNDS_EXT
		swigIntConstant( GL_DEPTH_BOUNDS_EXT, "GL_DEPTH_BOUNDS_EXT" );
	#endif
	#ifdef GL_EXT_direct_state_access
		swigIntConstant( GL_EXT_direct_state_access, "GL_EXT_direct_state_access" );
	#endif
	#ifdef GL_PROGRAM_MATRIX_EXT
		swigIntConstant( GL_PROGRAM_MATRIX_EXT, "GL_PROGRAM_MATRIX_EXT" );
	#endif
	#ifdef GL_TRANSPOSE_PROGRAM_MATRIX_EXT
		swigIntConstant( GL_TRANSPOSE_PROGRAM_MATRIX_EXT, "GL_TRANSPOSE_PROGRAM_MATRIX_EXT" );
	#endif
	#ifdef GL_PROGRAM_MATRIX_STACK_DEPTH_EXT
		swigIntConstant( GL_PROGRAM_MATRIX_STACK_DEPTH_EXT, "GL_PROGRAM_MATRIX_STACK_DEPTH_EXT" );
	#endif
	#ifdef GL_EXT_draw_buffers2
		swigIntConstant( GL_EXT_draw_buffers2, "GL_EXT_draw_buffers2" );
	#endif
	#ifdef GL_EXT_draw_instanced
		swigIntConstant( GL_EXT_draw_instanced, "GL_EXT_draw_instanced" );
	#endif
	#ifdef GL_EXT_draw_range_elements
		swigIntConstant( GL_EXT_draw_range_elements, "GL_EXT_draw_range_elements" );
	#endif
	#ifdef GL_MAX_ELEMENTS_VERTICES_EXT
		swigIntConstant( GL_MAX_ELEMENTS_VERTICES_EXT, "GL_MAX_ELEMENTS_VERTICES_EXT" );
	#endif
	#ifdef GL_MAX_ELEMENTS_INDICES_EXT
		swigIntConstant( GL_MAX_ELEMENTS_INDICES_EXT, "GL_MAX_ELEMENTS_INDICES_EXT" );
	#endif
	#ifdef GL_EXT_external_buffer
		swigIntConstant( GL_EXT_external_buffer, "GL_EXT_external_buffer" );
	#endif
	#ifdef GL_EXT_fog_coord
		swigIntConstant( GL_EXT_fog_coord, "GL_EXT_fog_coord" );
	#endif
	#ifdef GL_FOG_COORDINATE_SOURCE_EXT
		swigIntConstant( GL_FOG_COORDINATE_SOURCE_EXT, "GL_FOG_COORDINATE_SOURCE_EXT" );
	#endif
	#ifdef GL_FOG_COORDINATE_EXT
		swigIntConstant( GL_FOG_COORDINATE_EXT, "GL_FOG_COORDINATE_EXT" );
	#endif
	#ifdef GL_FRAGMENT_DEPTH_EXT
		swigIntConstant( GL_FRAGMENT_DEPTH_EXT, "GL_FRAGMENT_DEPTH_EXT" );
	#endif
	#ifdef GL_CURRENT_FOG_COORDINATE_EXT
		swigIntConstant( GL_CURRENT_FOG_COORDINATE_EXT, "GL_CURRENT_FOG_COORDINATE_EXT" );
	#endif
	#ifdef GL_FOG_COORDINATE_ARRAY_TYPE_EXT
		swigIntConstant( GL_FOG_COORDINATE_ARRAY_TYPE_EXT, "GL_FOG_COORDINATE_ARRAY_TYPE_EXT" );
	#endif
	#ifdef GL_FOG_COORDINATE_ARRAY_STRIDE_EXT
		swigIntConstant( GL_FOG_COORDINATE_ARRAY_STRIDE_EXT, "GL_FOG_COORDINATE_ARRAY_STRIDE_EXT" );
	#endif
	#ifdef GL_FOG_COORDINATE_ARRAY_POINTER_EXT
		swigIntConstant( GL_FOG_COORDINATE_ARRAY_POINTER_EXT, "GL_FOG_COORDINATE_ARRAY_POINTER_EXT" );
	#endif
	#ifdef GL_FOG_COORDINATE_ARRAY_EXT
		swigIntConstant( GL_FOG_COORDINATE_ARRAY_EXT, "GL_FOG_COORDINATE_ARRAY_EXT" );
	#endif
	#ifdef GL_EXT_framebuffer_blit
		swigIntConstant( GL_EXT_framebuffer_blit, "GL_EXT_framebuffer_blit" );
	#endif
	#ifdef GL_READ_FRAMEBUFFER_EXT
		swigIntConstant( GL_READ_FRAMEBUFFER_EXT, "GL_READ_FRAMEBUFFER_EXT" );
	#endif
	#ifdef GL_DRAW_FRAMEBUFFER_EXT
		swigIntConstant( GL_DRAW_FRAMEBUFFER_EXT, "GL_DRAW_FRAMEBUFFER_EXT" );
	#endif
	#ifdef GL_DRAW_FRAMEBUFFER_BINDING_EXT
		swigIntConstant( GL_DRAW_FRAMEBUFFER_BINDING_EXT, "GL_DRAW_FRAMEBUFFER_BINDING_EXT" );
	#endif
	#ifdef GL_READ_FRAMEBUFFER_BINDING_EXT
		swigIntConstant( GL_READ_FRAMEBUFFER_BINDING_EXT, "GL_READ_FRAMEBUFFER_BINDING_EXT" );
	#endif
	#ifdef GL_EXT_framebuffer_blit_layers
		swigIntConstant( GL_EXT_framebuffer_blit_layers, "GL_EXT_framebuffer_blit_layers" );
	#endif
	#ifdef GL_EXT_framebuffer_multisample
		swigIntConstant( GL_EXT_framebuffer_multisample, "GL_EXT_framebuffer_multisample" );
	#endif
	#ifdef GL_RENDERBUFFER_SAMPLES_EXT
		swigIntConstant( GL_RENDERBUFFER_SAMPLES_EXT, "GL_RENDERBUFFER_SAMPLES_EXT" );
	#endif
	#ifdef GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_EXT
		swigIntConstant( GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_EXT, "GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_EXT" );
	#endif
	#ifdef GL_MAX_SAMPLES_EXT
		swigIntConstant( GL_MAX_SAMPLES_EXT, "GL_MAX_SAMPLES_EXT" );
	#endif
	#ifdef GL_EXT_framebuffer_multisample_blit_scaled
		swigIntConstant( GL_EXT_framebuffer_multisample_blit_scaled, "GL_EXT_framebuffer_multisample_blit_scaled" );
	#endif
	#ifdef GL_SCALED_RESOLVE_FASTEST_EXT
		swigIntConstant( GL_SCALED_RESOLVE_FASTEST_EXT, "GL_SCALED_RESOLVE_FASTEST_EXT" );
	#endif
	#ifdef GL_SCALED_RESOLVE_NICEST_EXT
		swigIntConstant( GL_SCALED_RESOLVE_NICEST_EXT, "GL_SCALED_RESOLVE_NICEST_EXT" );
	#endif
	#ifdef GL_EXT_framebuffer_object
		swigIntConstant( GL_EXT_framebuffer_object, "GL_EXT_framebuffer_object" );
	#endif
	#ifdef GL_INVALID_FRAMEBUFFER_OPERATION_EXT
		swigIntConstant( GL_INVALID_FRAMEBUFFER_OPERATION_EXT, "GL_INVALID_FRAMEBUFFER_OPERATION_EXT" );
	#endif
	#ifdef GL_MAX_RENDERBUFFER_SIZE_EXT
		swigIntConstant( GL_MAX_RENDERBUFFER_SIZE_EXT, "GL_MAX_RENDERBUFFER_SIZE_EXT" );
	#endif
	#ifdef GL_FRAMEBUFFER_BINDING_EXT
		swigIntConstant( GL_FRAMEBUFFER_BINDING_EXT, "GL_FRAMEBUFFER_BINDING_EXT" );
	#endif
	#ifdef GL_RENDERBUFFER_BINDING_EXT
		swigIntConstant( GL_RENDERBUFFER_BINDING_EXT, "GL_RENDERBUFFER_BINDING_EXT" );
	#endif
	#ifdef GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE_EXT
		swigIntConstant( GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE_EXT, "GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE_EXT" );
	#endif
	#ifdef GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME_EXT
		swigIntConstant( GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME_EXT, "GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME_EXT" );
	#endif
	#ifdef GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL_EXT
		swigIntConstant( GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL_EXT, "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL_EXT" );
	#endif
	#ifdef GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE_EXT
		swigIntConstant( GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE_EXT, "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE_EXT" );
	#endif
	#ifdef GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_3D_ZOFFSET_EXT
		swigIntConstant( GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_3D_ZOFFSET_EXT, "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_3D_ZOFFSET_EXT" );
	#endif
	#ifdef GL_FRAMEBUFFER_COMPLETE_EXT
		swigIntConstant( GL_FRAMEBUFFER_COMPLETE_EXT, "GL_FRAMEBUFFER_COMPLETE_EXT" );
	#endif
	#ifdef GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_EXT
		swigIntConstant( GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_EXT, "GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_EXT" );
	#endif
	#ifdef GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT
		swigIntConstant( GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT, "GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT" );
	#endif
	#ifdef GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT
		swigIntConstant( GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT, "GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT" );
	#endif
	#ifdef GL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT
		swigIntConstant( GL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT, "GL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT" );
	#endif
	#ifdef GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT
		swigIntConstant( GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT, "GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT" );
	#endif
	#ifdef GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT
		swigIntConstant( GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT, "GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT" );
	#endif
	#ifdef GL_FRAMEBUFFER_UNSUPPORTED_EXT
		swigIntConstant( GL_FRAMEBUFFER_UNSUPPORTED_EXT, "GL_FRAMEBUFFER_UNSUPPORTED_EXT" );
	#endif
	#ifdef GL_MAX_COLOR_ATTACHMENTS_EXT
		swigIntConstant( GL_MAX_COLOR_ATTACHMENTS_EXT, "GL_MAX_COLOR_ATTACHMENTS_EXT" );
	#endif
	#ifdef GL_COLOR_ATTACHMENT0_EXT
		swigIntConstant( GL_COLOR_ATTACHMENT0_EXT, "GL_COLOR_ATTACHMENT0_EXT" );
	#endif
	#ifdef GL_COLOR_ATTACHMENT1_EXT
		swigIntConstant( GL_COLOR_ATTACHMENT1_EXT, "GL_COLOR_ATTACHMENT1_EXT" );
	#endif
	#ifdef GL_COLOR_ATTACHMENT2_EXT
		swigIntConstant( GL_COLOR_ATTACHMENT2_EXT, "GL_COLOR_ATTACHMENT2_EXT" );
	#endif
	#ifdef GL_COLOR_ATTACHMENT3_EXT
		swigIntConstant( GL_COLOR_ATTACHMENT3_EXT, "GL_COLOR_ATTACHMENT3_EXT" );
	#endif
	#ifdef GL_COLOR_ATTACHMENT4_EXT
		swigIntConstant( GL_COLOR_ATTACHMENT4_EXT, "GL_COLOR_ATTACHMENT4_EXT" );
	#endif
	#ifdef GL_COLOR_ATTACHMENT5_EXT
		swigIntConstant( GL_COLOR_ATTACHMENT5_EXT, "GL_COLOR_ATTACHMENT5_EXT" );
	#endif
	#ifdef GL_COLOR_ATTACHMENT6_EXT
		swigIntConstant( GL_COLOR_ATTACHMENT6_EXT, "GL_COLOR_ATTACHMENT6_EXT" );
	#endif
	#ifdef GL_COLOR_ATTACHMENT7_EXT
		swigIntConstant( GL_COLOR_ATTACHMENT7_EXT, "GL_COLOR_ATTACHMENT7_EXT" );
	#endif
	#ifdef GL_COLOR_ATTACHMENT8_EXT
		swigIntConstant( GL_COLOR_ATTACHMENT8_EXT, "GL_COLOR_ATTACHMENT8_EXT" );
	#endif
	#ifdef GL_COLOR_ATTACHMENT9_EXT
		swigIntConstant( GL_COLOR_ATTACHMENT9_EXT, "GL_COLOR_ATTACHMENT9_EXT" );
	#endif
	#ifdef GL_COLOR_ATTACHMENT10_EXT
		swigIntConstant( GL_COLOR_ATTACHMENT10_EXT, "GL_COLOR_ATTACHMENT10_EXT" );
	#endif
	#ifdef GL_COLOR_ATTACHMENT11_EXT
		swigIntConstant( GL_COLOR_ATTACHMENT11_EXT, "GL_COLOR_ATTACHMENT11_EXT" );
	#endif
	#ifdef GL_COLOR_ATTACHMENT12_EXT
		swigIntConstant( GL_COLOR_ATTACHMENT12_EXT, "GL_COLOR_ATTACHMENT12_EXT" );
	#endif
	#ifdef GL_COLOR_ATTACHMENT13_EXT
		swigIntConstant( GL_COLOR_ATTACHMENT13_EXT, "GL_COLOR_ATTACHMENT13_EXT" );
	#endif
	#ifdef GL_COLOR_ATTACHMENT14_EXT
		swigIntConstant( GL_COLOR_ATTACHMENT14_EXT, "GL_COLOR_ATTACHMENT14_EXT" );
	#endif
	#ifdef GL_COLOR_ATTACHMENT15_EXT
		swigIntConstant( GL_COLOR_ATTACHMENT15_EXT, "GL_COLOR_ATTACHMENT15_EXT" );
	#endif
	#ifdef GL_DEPTH_ATTACHMENT_EXT
		swigIntConstant( GL_DEPTH_ATTACHMENT_EXT, "GL_DEPTH_ATTACHMENT_EXT" );
	#endif
	#ifdef GL_STENCIL_ATTACHMENT_EXT
		swigIntConstant( GL_STENCIL_ATTACHMENT_EXT, "GL_STENCIL_ATTACHMENT_EXT" );
	#endif
	#ifdef GL_FRAMEBUFFER_EXT
		swigIntConstant( GL_FRAMEBUFFER_EXT, "GL_FRAMEBUFFER_EXT" );
	#endif
	#ifdef GL_RENDERBUFFER_EXT
		swigIntConstant( GL_RENDERBUFFER_EXT, "GL_RENDERBUFFER_EXT" );
	#endif
	#ifdef GL_RENDERBUFFER_WIDTH_EXT
		swigIntConstant( GL_RENDERBUFFER_WIDTH_EXT, "GL_RENDERBUFFER_WIDTH_EXT" );
	#endif
	#ifdef GL_RENDERBUFFER_HEIGHT_EXT
		swigIntConstant( GL_RENDERBUFFER_HEIGHT_EXT, "GL_RENDERBUFFER_HEIGHT_EXT" );
	#endif
	#ifdef GL_RENDERBUFFER_INTERNAL_FORMAT_EXT
		swigIntConstant( GL_RENDERBUFFER_INTERNAL_FORMAT_EXT, "GL_RENDERBUFFER_INTERNAL_FORMAT_EXT" );
	#endif
	#ifdef GL_STENCIL_INDEX1_EXT
		swigIntConstant( GL_STENCIL_INDEX1_EXT, "GL_STENCIL_INDEX1_EXT" );
	#endif
	#ifdef GL_STENCIL_INDEX4_EXT
		swigIntConstant( GL_STENCIL_INDEX4_EXT, "GL_STENCIL_INDEX4_EXT" );
	#endif
	#ifdef GL_STENCIL_INDEX8_EXT
		swigIntConstant( GL_STENCIL_INDEX8_EXT, "GL_STENCIL_INDEX8_EXT" );
	#endif
	#ifdef GL_STENCIL_INDEX16_EXT
		swigIntConstant( GL_STENCIL_INDEX16_EXT, "GL_STENCIL_INDEX16_EXT" );
	#endif
	#ifdef GL_RENDERBUFFER_RED_SIZE_EXT
		swigIntConstant( GL_RENDERBUFFER_RED_SIZE_EXT, "GL_RENDERBUFFER_RED_SIZE_EXT" );
	#endif
	#ifdef GL_RENDERBUFFER_GREEN_SIZE_EXT
		swigIntConstant( GL_RENDERBUFFER_GREEN_SIZE_EXT, "GL_RENDERBUFFER_GREEN_SIZE_EXT" );
	#endif
	#ifdef GL_RENDERBUFFER_BLUE_SIZE_EXT
		swigIntConstant( GL_RENDERBUFFER_BLUE_SIZE_EXT, "GL_RENDERBUFFER_BLUE_SIZE_EXT" );
	#endif
	#ifdef GL_RENDERBUFFER_ALPHA_SIZE_EXT
		swigIntConstant( GL_RENDERBUFFER_ALPHA_SIZE_EXT, "GL_RENDERBUFFER_ALPHA_SIZE_EXT" );
	#endif
	#ifdef GL_RENDERBUFFER_DEPTH_SIZE_EXT
		swigIntConstant( GL_RENDERBUFFER_DEPTH_SIZE_EXT, "GL_RENDERBUFFER_DEPTH_SIZE_EXT" );
	#endif
	#ifdef GL_RENDERBUFFER_STENCIL_SIZE_EXT
		swigIntConstant( GL_RENDERBUFFER_STENCIL_SIZE_EXT, "GL_RENDERBUFFER_STENCIL_SIZE_EXT" );
	#endif
	#ifdef GL_EXT_framebuffer_sRGB
		swigIntConstant( GL_EXT_framebuffer_sRGB, "GL_EXT_framebuffer_sRGB" );
	#endif
	#ifdef GL_FRAMEBUFFER_SRGB_EXT
		swigIntConstant( GL_FRAMEBUFFER_SRGB_EXT, "GL_FRAMEBUFFER_SRGB_EXT" );
	#endif
	#ifdef GL_FRAMEBUFFER_SRGB_CAPABLE_EXT
		swigIntConstant( GL_FRAMEBUFFER_SRGB_CAPABLE_EXT, "GL_FRAMEBUFFER_SRGB_CAPABLE_EXT" );
	#endif
	#ifdef GL_EXT_geometry_shader4
		swigIntConstant( GL_EXT_geometry_shader4, "GL_EXT_geometry_shader4" );
	#endif
	#ifdef GL_GEOMETRY_SHADER_EXT
		swigIntConstant( GL_GEOMETRY_SHADER_EXT, "GL_GEOMETRY_SHADER_EXT" );
	#endif
	#ifdef GL_GEOMETRY_VERTICES_OUT_EXT
		swigIntConstant( GL_GEOMETRY_VERTICES_OUT_EXT, "GL_GEOMETRY_VERTICES_OUT_EXT" );
	#endif
	#ifdef GL_GEOMETRY_INPUT_TYPE_EXT
		swigIntConstant( GL_GEOMETRY_INPUT_TYPE_EXT, "GL_GEOMETRY_INPUT_TYPE_EXT" );
	#endif
	#ifdef GL_GEOMETRY_OUTPUT_TYPE_EXT
		swigIntConstant( GL_GEOMETRY_OUTPUT_TYPE_EXT, "GL_GEOMETRY_OUTPUT_TYPE_EXT" );
	#endif
	#ifdef GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS_EXT
		swigIntConstant( GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS_EXT, "GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS_EXT" );
	#endif
	#ifdef GL_MAX_GEOMETRY_VARYING_COMPONENTS_EXT
		swigIntConstant( GL_MAX_GEOMETRY_VARYING_COMPONENTS_EXT, "GL_MAX_GEOMETRY_VARYING_COMPONENTS_EXT" );
	#endif
	#ifdef GL_MAX_VERTEX_VARYING_COMPONENTS_EXT
		swigIntConstant( GL_MAX_VERTEX_VARYING_COMPONENTS_EXT, "GL_MAX_VERTEX_VARYING_COMPONENTS_EXT" );
	#endif
	#ifdef GL_MAX_VARYING_COMPONENTS_EXT
		swigIntConstant( GL_MAX_VARYING_COMPONENTS_EXT, "GL_MAX_VARYING_COMPONENTS_EXT" );
	#endif
	#ifdef GL_MAX_GEOMETRY_UNIFORM_COMPONENTS_EXT
		swigIntConstant( GL_MAX_GEOMETRY_UNIFORM_COMPONENTS_EXT, "GL_MAX_GEOMETRY_UNIFORM_COMPONENTS_EXT" );
	#endif
	#ifdef GL_MAX_GEOMETRY_OUTPUT_VERTICES_EXT
		swigIntConstant( GL_MAX_GEOMETRY_OUTPUT_VERTICES_EXT, "GL_MAX_GEOMETRY_OUTPUT_VERTICES_EXT" );
	#endif
	#ifdef GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS_EXT
		swigIntConstant( GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS_EXT, "GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS_EXT" );
	#endif
	#ifdef GL_LINES_ADJACENCY_EXT
		swigIntConstant( GL_LINES_ADJACENCY_EXT, "GL_LINES_ADJACENCY_EXT" );
	#endif
	#ifdef GL_LINE_STRIP_ADJACENCY_EXT
		swigIntConstant( GL_LINE_STRIP_ADJACENCY_EXT, "GL_LINE_STRIP_ADJACENCY_EXT" );
	#endif
	#ifdef GL_TRIANGLES_ADJACENCY_EXT
		swigIntConstant( GL_TRIANGLES_ADJACENCY_EXT, "GL_TRIANGLES_ADJACENCY_EXT" );
	#endif
	#ifdef GL_TRIANGLE_STRIP_ADJACENCY_EXT
		swigIntConstant( GL_TRIANGLE_STRIP_ADJACENCY_EXT, "GL_TRIANGLE_STRIP_ADJACENCY_EXT" );
	#endif
	#ifdef GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS_EXT
		swigIntConstant( GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS_EXT, "GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS_EXT" );
	#endif
	#ifdef GL_FRAMEBUFFER_INCOMPLETE_LAYER_COUNT_EXT
		swigIntConstant( GL_FRAMEBUFFER_INCOMPLETE_LAYER_COUNT_EXT, "GL_FRAMEBUFFER_INCOMPLETE_LAYER_COUNT_EXT" );
	#endif
	#ifdef GL_FRAMEBUFFER_ATTACHMENT_LAYERED_EXT
		swigIntConstant( GL_FRAMEBUFFER_ATTACHMENT_LAYERED_EXT, "GL_FRAMEBUFFER_ATTACHMENT_LAYERED_EXT" );
	#endif
	#ifdef GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER_EXT
		swigIntConstant( GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER_EXT, "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER_EXT" );
	#endif
	#ifdef GL_PROGRAM_POINT_SIZE_EXT
		swigIntConstant( GL_PROGRAM_POINT_SIZE_EXT, "GL_PROGRAM_POINT_SIZE_EXT" );
	#endif
	#ifdef GL_EXT_gpu_program_parameters
		swigIntConstant( GL_EXT_gpu_program_parameters, "GL_EXT_gpu_program_parameters" );
	#endif
	#ifdef GL_EXT_gpu_shader4
		swigIntConstant( GL_EXT_gpu_shader4, "GL_EXT_gpu_shader4" );
	#endif
	#ifdef GL_SAMPLER_1D_ARRAY_EXT
		swigIntConstant( GL_SAMPLER_1D_ARRAY_EXT, "GL_SAMPLER_1D_ARRAY_EXT" );
	#endif
	#ifdef GL_SAMPLER_2D_ARRAY_EXT
		swigIntConstant( GL_SAMPLER_2D_ARRAY_EXT, "GL_SAMPLER_2D_ARRAY_EXT" );
	#endif
	#ifdef GL_SAMPLER_BUFFER_EXT
		swigIntConstant( GL_SAMPLER_BUFFER_EXT, "GL_SAMPLER_BUFFER_EXT" );
	#endif
	#ifdef GL_SAMPLER_1D_ARRAY_SHADOW_EXT
		swigIntConstant( GL_SAMPLER_1D_ARRAY_SHADOW_EXT, "GL_SAMPLER_1D_ARRAY_SHADOW_EXT" );
	#endif
	#ifdef GL_SAMPLER_2D_ARRAY_SHADOW_EXT
		swigIntConstant( GL_SAMPLER_2D_ARRAY_SHADOW_EXT, "GL_SAMPLER_2D_ARRAY_SHADOW_EXT" );
	#endif
	#ifdef GL_SAMPLER_CUBE_SHADOW_EXT
		swigIntConstant( GL_SAMPLER_CUBE_SHADOW_EXT, "GL_SAMPLER_CUBE_SHADOW_EXT" );
	#endif
	#ifdef GL_UNSIGNED_INT_VEC2_EXT
		swigIntConstant( GL_UNSIGNED_INT_VEC2_EXT, "GL_UNSIGNED_INT_VEC2_EXT" );
	#endif
	#ifdef GL_UNSIGNED_INT_VEC3_EXT
		swigIntConstant( GL_UNSIGNED_INT_VEC3_EXT, "GL_UNSIGNED_INT_VEC3_EXT" );
	#endif
	#ifdef GL_UNSIGNED_INT_VEC4_EXT
		swigIntConstant( GL_UNSIGNED_INT_VEC4_EXT, "GL_UNSIGNED_INT_VEC4_EXT" );
	#endif
	#ifdef GL_INT_SAMPLER_1D_EXT
		swigIntConstant( GL_INT_SAMPLER_1D_EXT, "GL_INT_SAMPLER_1D_EXT" );
	#endif
	#ifdef GL_INT_SAMPLER_2D_EXT
		swigIntConstant( GL_INT_SAMPLER_2D_EXT, "GL_INT_SAMPLER_2D_EXT" );
	#endif
	#ifdef GL_INT_SAMPLER_3D_EXT
		swigIntConstant( GL_INT_SAMPLER_3D_EXT, "GL_INT_SAMPLER_3D_EXT" );
	#endif
	#ifdef GL_INT_SAMPLER_CUBE_EXT
		swigIntConstant( GL_INT_SAMPLER_CUBE_EXT, "GL_INT_SAMPLER_CUBE_EXT" );
	#endif
	#ifdef GL_INT_SAMPLER_2D_RECT_EXT
		swigIntConstant( GL_INT_SAMPLER_2D_RECT_EXT, "GL_INT_SAMPLER_2D_RECT_EXT" );
	#endif
	#ifdef GL_INT_SAMPLER_1D_ARRAY_EXT
		swigIntConstant( GL_INT_SAMPLER_1D_ARRAY_EXT, "GL_INT_SAMPLER_1D_ARRAY_EXT" );
	#endif
	#ifdef GL_INT_SAMPLER_2D_ARRAY_EXT
		swigIntConstant( GL_INT_SAMPLER_2D_ARRAY_EXT, "GL_INT_SAMPLER_2D_ARRAY_EXT" );
	#endif
	#ifdef GL_INT_SAMPLER_BUFFER_EXT
		swigIntConstant( GL_INT_SAMPLER_BUFFER_EXT, "GL_INT_SAMPLER_BUFFER_EXT" );
	#endif
	#ifdef GL_UNSIGNED_INT_SAMPLER_1D_EXT
		swigIntConstant( GL_UNSIGNED_INT_SAMPLER_1D_EXT, "GL_UNSIGNED_INT_SAMPLER_1D_EXT" );
	#endif
	#ifdef GL_UNSIGNED_INT_SAMPLER_2D_EXT
		swigIntConstant( GL_UNSIGNED_INT_SAMPLER_2D_EXT, "GL_UNSIGNED_INT_SAMPLER_2D_EXT" );
	#endif
	#ifdef GL_UNSIGNED_INT_SAMPLER_3D_EXT
		swigIntConstant( GL_UNSIGNED_INT_SAMPLER_3D_EXT, "GL_UNSIGNED_INT_SAMPLER_3D_EXT" );
	#endif
	#ifdef GL_UNSIGNED_INT_SAMPLER_CUBE_EXT
		swigIntConstant( GL_UNSIGNED_INT_SAMPLER_CUBE_EXT, "GL_UNSIGNED_INT_SAMPLER_CUBE_EXT" );
	#endif
	#ifdef GL_UNSIGNED_INT_SAMPLER_2D_RECT_EXT
		swigIntConstant( GL_UNSIGNED_INT_SAMPLER_2D_RECT_EXT, "GL_UNSIGNED_INT_SAMPLER_2D_RECT_EXT" );
	#endif
	#ifdef GL_UNSIGNED_INT_SAMPLER_1D_ARRAY_EXT
		swigIntConstant( GL_UNSIGNED_INT_SAMPLER_1D_ARRAY_EXT, "GL_UNSIGNED_INT_SAMPLER_1D_ARRAY_EXT" );
	#endif
	#ifdef GL_UNSIGNED_INT_SAMPLER_2D_ARRAY_EXT
		swigIntConstant( GL_UNSIGNED_INT_SAMPLER_2D_ARRAY_EXT, "GL_UNSIGNED_INT_SAMPLER_2D_ARRAY_EXT" );
	#endif
	#ifdef GL_UNSIGNED_INT_SAMPLER_BUFFER_EXT
		swigIntConstant( GL_UNSIGNED_INT_SAMPLER_BUFFER_EXT, "GL_UNSIGNED_INT_SAMPLER_BUFFER_EXT" );
	#endif
	#ifdef GL_MIN_PROGRAM_TEXEL_OFFSET_EXT
		swigIntConstant( GL_MIN_PROGRAM_TEXEL_OFFSET_EXT, "GL_MIN_PROGRAM_TEXEL_OFFSET_EXT" );
	#endif
	#ifdef GL_MAX_PROGRAM_TEXEL_OFFSET_EXT
		swigIntConstant( GL_MAX_PROGRAM_TEXEL_OFFSET_EXT, "GL_MAX_PROGRAM_TEXEL_OFFSET_EXT" );
	#endif
	#ifdef GL_VERTEX_ATTRIB_ARRAY_INTEGER_EXT
		swigIntConstant( GL_VERTEX_ATTRIB_ARRAY_INTEGER_EXT, "GL_VERTEX_ATTRIB_ARRAY_INTEGER_EXT" );
	#endif
	#ifdef GL_EXT_histogram
		swigIntConstant( GL_EXT_histogram, "GL_EXT_histogram" );
	#endif
	#ifdef GL_HISTOGRAM_EXT
		swigIntConstant( GL_HISTOGRAM_EXT, "GL_HISTOGRAM_EXT" );
	#endif
	#ifdef GL_PROXY_HISTOGRAM_EXT
		swigIntConstant( GL_PROXY_HISTOGRAM_EXT, "GL_PROXY_HISTOGRAM_EXT" );
	#endif
	#ifdef GL_HISTOGRAM_WIDTH_EXT
		swigIntConstant( GL_HISTOGRAM_WIDTH_EXT, "GL_HISTOGRAM_WIDTH_EXT" );
	#endif
	#ifdef GL_HISTOGRAM_FORMAT_EXT
		swigIntConstant( GL_HISTOGRAM_FORMAT_EXT, "GL_HISTOGRAM_FORMAT_EXT" );
	#endif
	#ifdef GL_HISTOGRAM_RED_SIZE_EXT
		swigIntConstant( GL_HISTOGRAM_RED_SIZE_EXT, "GL_HISTOGRAM_RED_SIZE_EXT" );
	#endif
	#ifdef GL_HISTOGRAM_GREEN_SIZE_EXT
		swigIntConstant( GL_HISTOGRAM_GREEN_SIZE_EXT, "GL_HISTOGRAM_GREEN_SIZE_EXT" );
	#endif
	#ifdef GL_HISTOGRAM_BLUE_SIZE_EXT
		swigIntConstant( GL_HISTOGRAM_BLUE_SIZE_EXT, "GL_HISTOGRAM_BLUE_SIZE_EXT" );
	#endif
	#ifdef GL_HISTOGRAM_ALPHA_SIZE_EXT
		swigIntConstant( GL_HISTOGRAM_ALPHA_SIZE_EXT, "GL_HISTOGRAM_ALPHA_SIZE_EXT" );
	#endif
	#ifdef GL_HISTOGRAM_LUMINANCE_SIZE_EXT
		swigIntConstant( GL_HISTOGRAM_LUMINANCE_SIZE_EXT, "GL_HISTOGRAM_LUMINANCE_SIZE_EXT" );
	#endif
	#ifdef GL_HISTOGRAM_SINK_EXT
		swigIntConstant( GL_HISTOGRAM_SINK_EXT, "GL_HISTOGRAM_SINK_EXT" );
	#endif
	#ifdef GL_MINMAX_EXT
		swigIntConstant( GL_MINMAX_EXT, "GL_MINMAX_EXT" );
	#endif
	#ifdef GL_MINMAX_FORMAT_EXT
		swigIntConstant( GL_MINMAX_FORMAT_EXT, "GL_MINMAX_FORMAT_EXT" );
	#endif
	#ifdef GL_MINMAX_SINK_EXT
		swigIntConstant( GL_MINMAX_SINK_EXT, "GL_MINMAX_SINK_EXT" );
	#endif
	#ifdef GL_TABLE_TOO_LARGE_EXT
		swigIntConstant( GL_TABLE_TOO_LARGE_EXT, "GL_TABLE_TOO_LARGE_EXT" );
	#endif
	#ifdef GL_EXT_index_array_formats
		swigIntConstant( GL_EXT_index_array_formats, "GL_EXT_index_array_formats" );
	#endif
	#ifdef GL_IUI_V2F_EXT
		swigIntConstant( GL_IUI_V2F_EXT, "GL_IUI_V2F_EXT" );
	#endif
	#ifdef GL_IUI_V3F_EXT
		swigIntConstant( GL_IUI_V3F_EXT, "GL_IUI_V3F_EXT" );
	#endif
	#ifdef GL_IUI_N3F_V2F_EXT
		swigIntConstant( GL_IUI_N3F_V2F_EXT, "GL_IUI_N3F_V2F_EXT" );
	#endif
	#ifdef GL_IUI_N3F_V3F_EXT
		swigIntConstant( GL_IUI_N3F_V3F_EXT, "GL_IUI_N3F_V3F_EXT" );
	#endif
	#ifdef GL_T2F_IUI_V2F_EXT
		swigIntConstant( GL_T2F_IUI_V2F_EXT, "GL_T2F_IUI_V2F_EXT" );
	#endif
	#ifdef GL_T2F_IUI_V3F_EXT
		swigIntConstant( GL_T2F_IUI_V3F_EXT, "GL_T2F_IUI_V3F_EXT" );
	#endif
	#ifdef GL_T2F_IUI_N3F_V2F_EXT
		swigIntConstant( GL_T2F_IUI_N3F_V2F_EXT, "GL_T2F_IUI_N3F_V2F_EXT" );
	#endif
	#ifdef GL_T2F_IUI_N3F_V3F_EXT
		swigIntConstant( GL_T2F_IUI_N3F_V3F_EXT, "GL_T2F_IUI_N3F_V3F_EXT" );
	#endif
	#ifdef GL_EXT_index_func
		swigIntConstant( GL_EXT_index_func, "GL_EXT_index_func" );
	#endif
	#ifdef GL_INDEX_TEST_EXT
		swigIntConstant( GL_INDEX_TEST_EXT, "GL_INDEX_TEST_EXT" );
	#endif
	#ifdef GL_INDEX_TEST_FUNC_EXT
		swigIntConstant( GL_INDEX_TEST_FUNC_EXT, "GL_INDEX_TEST_FUNC_EXT" );
	#endif
	#ifdef GL_INDEX_TEST_REF_EXT
		swigIntConstant( GL_INDEX_TEST_REF_EXT, "GL_INDEX_TEST_REF_EXT" );
	#endif
	#ifdef GL_EXT_index_material
		swigIntConstant( GL_EXT_index_material, "GL_EXT_index_material" );
	#endif
	#ifdef GL_INDEX_MATERIAL_EXT
		swigIntConstant( GL_INDEX_MATERIAL_EXT, "GL_INDEX_MATERIAL_EXT" );
	#endif
	#ifdef GL_INDEX_MATERIAL_PARAMETER_EXT
		swigIntConstant( GL_INDEX_MATERIAL_PARAMETER_EXT, "GL_INDEX_MATERIAL_PARAMETER_EXT" );
	#endif
	#ifdef GL_INDEX_MATERIAL_FACE_EXT
		swigIntConstant( GL_INDEX_MATERIAL_FACE_EXT, "GL_INDEX_MATERIAL_FACE_EXT" );
	#endif
	#ifdef GL_EXT_index_texture
		swigIntConstant( GL_EXT_index_texture, "GL_EXT_index_texture" );
	#endif
	#ifdef GL_EXT_light_texture
		swigIntConstant( GL_EXT_light_texture, "GL_EXT_light_texture" );
	#endif
	#ifdef GL_FRAGMENT_MATERIAL_EXT
		swigIntConstant( GL_FRAGMENT_MATERIAL_EXT, "GL_FRAGMENT_MATERIAL_EXT" );
	#endif
	#ifdef GL_FRAGMENT_NORMAL_EXT
		swigIntConstant( GL_FRAGMENT_NORMAL_EXT, "GL_FRAGMENT_NORMAL_EXT" );
	#endif
	#ifdef GL_FRAGMENT_COLOR_EXT
		swigIntConstant( GL_FRAGMENT_COLOR_EXT, "GL_FRAGMENT_COLOR_EXT" );
	#endif
	#ifdef GL_ATTENUATION_EXT
		swigIntConstant( GL_ATTENUATION_EXT, "GL_ATTENUATION_EXT" );
	#endif
	#ifdef GL_SHADOW_ATTENUATION_EXT
		swigIntConstant( GL_SHADOW_ATTENUATION_EXT, "GL_SHADOW_ATTENUATION_EXT" );
	#endif
	#ifdef GL_TEXTURE_APPLICATION_MODE_EXT
		swigIntConstant( GL_TEXTURE_APPLICATION_MODE_EXT, "GL_TEXTURE_APPLICATION_MODE_EXT" );
	#endif
	#ifdef GL_TEXTURE_LIGHT_EXT
		swigIntConstant( GL_TEXTURE_LIGHT_EXT, "GL_TEXTURE_LIGHT_EXT" );
	#endif
	#ifdef GL_TEXTURE_MATERIAL_FACE_EXT
		swigIntConstant( GL_TEXTURE_MATERIAL_FACE_EXT, "GL_TEXTURE_MATERIAL_FACE_EXT" );
	#endif
	#ifdef GL_TEXTURE_MATERIAL_PARAMETER_EXT
		swigIntConstant( GL_TEXTURE_MATERIAL_PARAMETER_EXT, "GL_TEXTURE_MATERIAL_PARAMETER_EXT" );
	#endif
	#ifdef GL_EXT_memory_object
		swigIntConstant( GL_EXT_memory_object, "GL_EXT_memory_object" );
	#endif
	#ifdef GL_TEXTURE_TILING_EXT
		swigIntConstant( GL_TEXTURE_TILING_EXT, "GL_TEXTURE_TILING_EXT" );
	#endif
	#ifdef GL_DEDICATED_MEMORY_OBJECT_EXT
		swigIntConstant( GL_DEDICATED_MEMORY_OBJECT_EXT, "GL_DEDICATED_MEMORY_OBJECT_EXT" );
	#endif
	#ifdef GL_PROTECTED_MEMORY_OBJECT_EXT
		swigIntConstant( GL_PROTECTED_MEMORY_OBJECT_EXT, "GL_PROTECTED_MEMORY_OBJECT_EXT" );
	#endif
	#ifdef GL_NUM_TILING_TYPES_EXT
		swigIntConstant( GL_NUM_TILING_TYPES_EXT, "GL_NUM_TILING_TYPES_EXT" );
	#endif
	#ifdef GL_TILING_TYPES_EXT
		swigIntConstant( GL_TILING_TYPES_EXT, "GL_TILING_TYPES_EXT" );
	#endif
	#ifdef GL_OPTIMAL_TILING_EXT
		swigIntConstant( GL_OPTIMAL_TILING_EXT, "GL_OPTIMAL_TILING_EXT" );
	#endif
	#ifdef GL_LINEAR_TILING_EXT
		swigIntConstant( GL_LINEAR_TILING_EXT, "GL_LINEAR_TILING_EXT" );
	#endif
	#ifdef GL_NUM_DEVICE_UUIDS_EXT
		swigIntConstant( GL_NUM_DEVICE_UUIDS_EXT, "GL_NUM_DEVICE_UUIDS_EXT" );
	#endif
	#ifdef GL_DEVICE_UUID_EXT
		swigIntConstant( GL_DEVICE_UUID_EXT, "GL_DEVICE_UUID_EXT" );
	#endif
	#ifdef GL_DRIVER_UUID_EXT
		swigIntConstant( GL_DRIVER_UUID_EXT, "GL_DRIVER_UUID_EXT" );
	#endif
	#ifdef GL_UUID_SIZE_EXT
		swigIntConstant( GL_UUID_SIZE_EXT, "GL_UUID_SIZE_EXT" );
	#endif
	#ifdef GL_EXT_memory_object_fd
		swigIntConstant( GL_EXT_memory_object_fd, "GL_EXT_memory_object_fd" );
	#endif
	#ifdef GL_HANDLE_TYPE_OPAQUE_FD_EXT
		swigIntConstant( GL_HANDLE_TYPE_OPAQUE_FD_EXT, "GL_HANDLE_TYPE_OPAQUE_FD_EXT" );
	#endif
	#ifdef GL_EXT_memory_object_win32
		swigIntConstant( GL_EXT_memory_object_win32, "GL_EXT_memory_object_win32" );
	#endif
	#ifdef GL_HANDLE_TYPE_OPAQUE_WIN32_EXT
		swigIntConstant( GL_HANDLE_TYPE_OPAQUE_WIN32_EXT, "GL_HANDLE_TYPE_OPAQUE_WIN32_EXT" );
	#endif
	#ifdef GL_HANDLE_TYPE_OPAQUE_WIN32_KMT_EXT
		swigIntConstant( GL_HANDLE_TYPE_OPAQUE_WIN32_KMT_EXT, "GL_HANDLE_TYPE_OPAQUE_WIN32_KMT_EXT" );
	#endif
	#ifdef GL_DEVICE_LUID_EXT
		swigIntConstant( GL_DEVICE_LUID_EXT, "GL_DEVICE_LUID_EXT" );
	#endif
	#ifdef GL_DEVICE_NODE_MASK_EXT
		swigIntConstant( GL_DEVICE_NODE_MASK_EXT, "GL_DEVICE_NODE_MASK_EXT" );
	#endif
	#ifdef GL_LUID_SIZE_EXT
		swigIntConstant( GL_LUID_SIZE_EXT, "GL_LUID_SIZE_EXT" );
	#endif
	#ifdef GL_HANDLE_TYPE_D3D12_TILEPOOL_EXT
		swigIntConstant( GL_HANDLE_TYPE_D3D12_TILEPOOL_EXT, "GL_HANDLE_TYPE_D3D12_TILEPOOL_EXT" );
	#endif
	#ifdef GL_HANDLE_TYPE_D3D12_RESOURCE_EXT
		swigIntConstant( GL_HANDLE_TYPE_D3D12_RESOURCE_EXT, "GL_HANDLE_TYPE_D3D12_RESOURCE_EXT" );
	#endif
	#ifdef GL_HANDLE_TYPE_D3D11_IMAGE_EXT
		swigIntConstant( GL_HANDLE_TYPE_D3D11_IMAGE_EXT, "GL_HANDLE_TYPE_D3D11_IMAGE_EXT" );
	#endif
	#ifdef GL_HANDLE_TYPE_D3D11_IMAGE_KMT_EXT
		swigIntConstant( GL_HANDLE_TYPE_D3D11_IMAGE_KMT_EXT, "GL_HANDLE_TYPE_D3D11_IMAGE_KMT_EXT" );
	#endif
	#ifdef GL_EXT_mesh_shader
		swigIntConstant( GL_EXT_mesh_shader, "GL_EXT_mesh_shader" );
	#endif
	#ifdef GL_MESH_SHADER_EXT
		swigIntConstant( GL_MESH_SHADER_EXT, "GL_MESH_SHADER_EXT" );
	#endif
	#ifdef GL_TASK_SHADER_EXT
		swigIntConstant( GL_TASK_SHADER_EXT, "GL_TASK_SHADER_EXT" );
	#endif
	#ifdef GL_MAX_MESH_UNIFORM_BLOCKS_EXT
		swigIntConstant( GL_MAX_MESH_UNIFORM_BLOCKS_EXT, "GL_MAX_MESH_UNIFORM_BLOCKS_EXT" );
	#endif
	#ifdef GL_MAX_MESH_TEXTURE_IMAGE_UNITS_EXT
		swigIntConstant( GL_MAX_MESH_TEXTURE_IMAGE_UNITS_EXT, "GL_MAX_MESH_TEXTURE_IMAGE_UNITS_EXT" );
	#endif
	#ifdef GL_MAX_MESH_IMAGE_UNIFORMS_EXT
		swigIntConstant( GL_MAX_MESH_IMAGE_UNIFORMS_EXT, "GL_MAX_MESH_IMAGE_UNIFORMS_EXT" );
	#endif
	#ifdef GL_MAX_MESH_UNIFORM_COMPONENTS_EXT
		swigIntConstant( GL_MAX_MESH_UNIFORM_COMPONENTS_EXT, "GL_MAX_MESH_UNIFORM_COMPONENTS_EXT" );
	#endif
	#ifdef GL_MAX_MESH_ATOMIC_COUNTER_BUFFERS_EXT
		swigIntConstant( GL_MAX_MESH_ATOMIC_COUNTER_BUFFERS_EXT, "GL_MAX_MESH_ATOMIC_COUNTER_BUFFERS_EXT" );
	#endif
	#ifdef GL_MAX_MESH_ATOMIC_COUNTERS_EXT
		swigIntConstant( GL_MAX_MESH_ATOMIC_COUNTERS_EXT, "GL_MAX_MESH_ATOMIC_COUNTERS_EXT" );
	#endif
	#ifdef GL_MAX_MESH_SHADER_STORAGE_BLOCKS_EXT
		swigIntConstant( GL_MAX_MESH_SHADER_STORAGE_BLOCKS_EXT, "GL_MAX_MESH_SHADER_STORAGE_BLOCKS_EXT" );
	#endif
	#ifdef GL_MAX_COMBINED_MESH_UNIFORM_COMPONENTS_EXT
		swigIntConstant( GL_MAX_COMBINED_MESH_UNIFORM_COMPONENTS_EXT, "GL_MAX_COMBINED_MESH_UNIFORM_COMPONENTS_EXT" );
	#endif
	#ifdef GL_MAX_TASK_UNIFORM_BLOCKS_EXT
		swigIntConstant( GL_MAX_TASK_UNIFORM_BLOCKS_EXT, "GL_MAX_TASK_UNIFORM_BLOCKS_EXT" );
	#endif
	#ifdef GL_MAX_TASK_TEXTURE_IMAGE_UNITS_EXT
		swigIntConstant( GL_MAX_TASK_TEXTURE_IMAGE_UNITS_EXT, "GL_MAX_TASK_TEXTURE_IMAGE_UNITS_EXT" );
	#endif
	#ifdef GL_MAX_TASK_IMAGE_UNIFORMS_EXT
		swigIntConstant( GL_MAX_TASK_IMAGE_UNIFORMS_EXT, "GL_MAX_TASK_IMAGE_UNIFORMS_EXT" );
	#endif
	#ifdef GL_MAX_TASK_UNIFORM_COMPONENTS_EXT
		swigIntConstant( GL_MAX_TASK_UNIFORM_COMPONENTS_EXT, "GL_MAX_TASK_UNIFORM_COMPONENTS_EXT" );
	#endif
	#ifdef GL_MAX_TASK_ATOMIC_COUNTER_BUFFERS_EXT
		swigIntConstant( GL_MAX_TASK_ATOMIC_COUNTER_BUFFERS_EXT, "GL_MAX_TASK_ATOMIC_COUNTER_BUFFERS_EXT" );
	#endif
	#ifdef GL_MAX_TASK_ATOMIC_COUNTERS_EXT
		swigIntConstant( GL_MAX_TASK_ATOMIC_COUNTERS_EXT, "GL_MAX_TASK_ATOMIC_COUNTERS_EXT" );
	#endif
	#ifdef GL_MAX_TASK_SHADER_STORAGE_BLOCKS_EXT
		swigIntConstant( GL_MAX_TASK_SHADER_STORAGE_BLOCKS_EXT, "GL_MAX_TASK_SHADER_STORAGE_BLOCKS_EXT" );
	#endif
	#ifdef GL_MAX_COMBINED_TASK_UNIFORM_COMPONENTS_EXT
		swigIntConstant( GL_MAX_COMBINED_TASK_UNIFORM_COMPONENTS_EXT, "GL_MAX_COMBINED_TASK_UNIFORM_COMPONENTS_EXT" );
	#endif
	#ifdef GL_MAX_TASK_WORK_GROUP_TOTAL_COUNT_EXT
		swigIntConstant( GL_MAX_TASK_WORK_GROUP_TOTAL_COUNT_EXT, "GL_MAX_TASK_WORK_GROUP_TOTAL_COUNT_EXT" );
	#endif
	#ifdef GL_MAX_MESH_WORK_GROUP_TOTAL_COUNT_EXT
		swigIntConstant( GL_MAX_MESH_WORK_GROUP_TOTAL_COUNT_EXT, "GL_MAX_MESH_WORK_GROUP_TOTAL_COUNT_EXT" );
	#endif
	#ifdef GL_MAX_MESH_WORK_GROUP_INVOCATIONS_EXT
		swigIntConstant( GL_MAX_MESH_WORK_GROUP_INVOCATIONS_EXT, "GL_MAX_MESH_WORK_GROUP_INVOCATIONS_EXT" );
	#endif
	#ifdef GL_MAX_TASK_WORK_GROUP_INVOCATIONS_EXT
		swigIntConstant( GL_MAX_TASK_WORK_GROUP_INVOCATIONS_EXT, "GL_MAX_TASK_WORK_GROUP_INVOCATIONS_EXT" );
	#endif
	#ifdef GL_MAX_TASK_PAYLOAD_SIZE_EXT
		swigIntConstant( GL_MAX_TASK_PAYLOAD_SIZE_EXT, "GL_MAX_TASK_PAYLOAD_SIZE_EXT" );
	#endif
	#ifdef GL_MAX_TASK_SHARED_MEMORY_SIZE_EXT
		swigIntConstant( GL_MAX_TASK_SHARED_MEMORY_SIZE_EXT, "GL_MAX_TASK_SHARED_MEMORY_SIZE_EXT" );
	#endif
	#ifdef GL_MAX_MESH_SHARED_MEMORY_SIZE_EXT
		swigIntConstant( GL_MAX_MESH_SHARED_MEMORY_SIZE_EXT, "GL_MAX_MESH_SHARED_MEMORY_SIZE_EXT" );
	#endif
	#ifdef GL_MAX_TASK_PAYLOAD_AND_SHARED_MEMORY_SIZE_EXT
		swigIntConstant( GL_MAX_TASK_PAYLOAD_AND_SHARED_MEMORY_SIZE_EXT, "GL_MAX_TASK_PAYLOAD_AND_SHARED_MEMORY_SIZE_EXT" );
	#endif
	#ifdef GL_MAX_MESH_PAYLOAD_AND_SHARED_MEMORY_SIZE_EXT
		swigIntConstant( GL_MAX_MESH_PAYLOAD_AND_SHARED_MEMORY_SIZE_EXT, "GL_MAX_MESH_PAYLOAD_AND_SHARED_MEMORY_SIZE_EXT" );
	#endif
	#ifdef GL_MAX_MESH_OUTPUT_MEMORY_SIZE_EXT
		swigIntConstant( GL_MAX_MESH_OUTPUT_MEMORY_SIZE_EXT, "GL_MAX_MESH_OUTPUT_MEMORY_SIZE_EXT" );
	#endif
	#ifdef GL_MAX_MESH_PAYLOAD_AND_OUTPUT_MEMORY_SIZE_EXT
		swigIntConstant( GL_MAX_MESH_PAYLOAD_AND_OUTPUT_MEMORY_SIZE_EXT, "GL_MAX_MESH_PAYLOAD_AND_OUTPUT_MEMORY_SIZE_EXT" );
	#endif
	#ifdef GL_MAX_MESH_OUTPUT_VERTICES_EXT
		swigIntConstant( GL_MAX_MESH_OUTPUT_VERTICES_EXT, "GL_MAX_MESH_OUTPUT_VERTICES_EXT" );
	#endif
	#ifdef GL_MAX_MESH_OUTPUT_PRIMITIVES_EXT
		swigIntConstant( GL_MAX_MESH_OUTPUT_PRIMITIVES_EXT, "GL_MAX_MESH_OUTPUT_PRIMITIVES_EXT" );
	#endif
	#ifdef GL_MAX_MESH_OUTPUT_COMPONENTS_EXT
		swigIntConstant( GL_MAX_MESH_OUTPUT_COMPONENTS_EXT, "GL_MAX_MESH_OUTPUT_COMPONENTS_EXT" );
	#endif
	#ifdef GL_MAX_MESH_OUTPUT_LAYERS_EXT
		swigIntConstant( GL_MAX_MESH_OUTPUT_LAYERS_EXT, "GL_MAX_MESH_OUTPUT_LAYERS_EXT" );
	#endif
	#ifdef GL_MAX_MESH_MULTIVIEW_VIEW_COUNT_EXT
		swigIntConstant( GL_MAX_MESH_MULTIVIEW_VIEW_COUNT_EXT, "GL_MAX_MESH_MULTIVIEW_VIEW_COUNT_EXT" );
	#endif
	#ifdef GL_MESH_OUTPUT_PER_VERTEX_GRANULARITY_EXT
		swigIntConstant( GL_MESH_OUTPUT_PER_VERTEX_GRANULARITY_EXT, "GL_MESH_OUTPUT_PER_VERTEX_GRANULARITY_EXT" );
	#endif
	#ifdef GL_MESH_OUTPUT_PER_PRIMITIVE_GRANULARITY_EXT
		swigIntConstant( GL_MESH_OUTPUT_PER_PRIMITIVE_GRANULARITY_EXT, "GL_MESH_OUTPUT_PER_PRIMITIVE_GRANULARITY_EXT" );
	#endif
	#ifdef GL_MAX_PREFERRED_TASK_WORK_GROUP_INVOCATIONS_EXT
		swigIntConstant( GL_MAX_PREFERRED_TASK_WORK_GROUP_INVOCATIONS_EXT, "GL_MAX_PREFERRED_TASK_WORK_GROUP_INVOCATIONS_EXT" );
	#endif
	#ifdef GL_MAX_PREFERRED_MESH_WORK_GROUP_INVOCATIONS_EXT
		swigIntConstant( GL_MAX_PREFERRED_MESH_WORK_GROUP_INVOCATIONS_EXT, "GL_MAX_PREFERRED_MESH_WORK_GROUP_INVOCATIONS_EXT" );
	#endif
	#ifdef GL_MESH_PREFERS_LOCAL_INVOCATION_VERTEX_OUTPUT_EXT
		swigIntConstant( GL_MESH_PREFERS_LOCAL_INVOCATION_VERTEX_OUTPUT_EXT, "GL_MESH_PREFERS_LOCAL_INVOCATION_VERTEX_OUTPUT_EXT" );
	#endif
	#ifdef GL_MESH_PREFERS_LOCAL_INVOCATION_PRIMITIVE_OUTPUT_EXT
		swigIntConstant( GL_MESH_PREFERS_LOCAL_INVOCATION_PRIMITIVE_OUTPUT_EXT, "GL_MESH_PREFERS_LOCAL_INVOCATION_PRIMITIVE_OUTPUT_EXT" );
	#endif
	#ifdef GL_MESH_PREFERS_COMPACT_VERTEX_OUTPUT_EXT
		swigIntConstant( GL_MESH_PREFERS_COMPACT_VERTEX_OUTPUT_EXT, "GL_MESH_PREFERS_COMPACT_VERTEX_OUTPUT_EXT" );
	#endif
	#ifdef GL_MESH_PREFERS_COMPACT_PRIMITIVE_OUTPUT_EXT
		swigIntConstant( GL_MESH_PREFERS_COMPACT_PRIMITIVE_OUTPUT_EXT, "GL_MESH_PREFERS_COMPACT_PRIMITIVE_OUTPUT_EXT" );
	#endif
	#ifdef GL_MAX_TASK_WORK_GROUP_COUNT_EXT
		swigIntConstant( GL_MAX_TASK_WORK_GROUP_COUNT_EXT, "GL_MAX_TASK_WORK_GROUP_COUNT_EXT" );
	#endif
	#ifdef GL_MAX_MESH_WORK_GROUP_COUNT_EXT
		swigIntConstant( GL_MAX_MESH_WORK_GROUP_COUNT_EXT, "GL_MAX_MESH_WORK_GROUP_COUNT_EXT" );
	#endif
	#ifdef GL_MAX_MESH_WORK_GROUP_SIZE_EXT
		swigIntConstant( GL_MAX_MESH_WORK_GROUP_SIZE_EXT, "GL_MAX_MESH_WORK_GROUP_SIZE_EXT" );
	#endif
	#ifdef GL_MAX_TASK_WORK_GROUP_SIZE_EXT
		swigIntConstant( GL_MAX_TASK_WORK_GROUP_SIZE_EXT, "GL_MAX_TASK_WORK_GROUP_SIZE_EXT" );
	#endif
	#ifdef GL_MESH_WORK_GROUP_SIZE_EXT
		swigIntConstant( GL_MESH_WORK_GROUP_SIZE_EXT, "GL_MESH_WORK_GROUP_SIZE_EXT" );
	#endif
	#ifdef GL_TASK_WORK_GROUP_SIZE_EXT
		swigIntConstant( GL_TASK_WORK_GROUP_SIZE_EXT, "GL_TASK_WORK_GROUP_SIZE_EXT" );
	#endif
	#ifdef GL_MESH_VERTICES_OUT_EXT
		swigIntConstant( GL_MESH_VERTICES_OUT_EXT, "GL_MESH_VERTICES_OUT_EXT" );
	#endif
	#ifdef GL_MESH_PRIMITIVES_OUT_EXT
		swigIntConstant( GL_MESH_PRIMITIVES_OUT_EXT, "GL_MESH_PRIMITIVES_OUT_EXT" );
	#endif
	#ifdef GL_MESH_OUTPUT_TYPE_EXT
		swigIntConstant( GL_MESH_OUTPUT_TYPE_EXT, "GL_MESH_OUTPUT_TYPE_EXT" );
	#endif
	#ifdef GL_UNIFORM_BLOCK_REFERENCED_BY_MESH_SHADER_EXT
		swigIntConstant( GL_UNIFORM_BLOCK_REFERENCED_BY_MESH_SHADER_EXT, "GL_UNIFORM_BLOCK_REFERENCED_BY_MESH_SHADER_EXT" );
	#endif
	#ifdef GL_UNIFORM_BLOCK_REFERENCED_BY_TASK_SHADER_EXT
		swigIntConstant( GL_UNIFORM_BLOCK_REFERENCED_BY_TASK_SHADER_EXT, "GL_UNIFORM_BLOCK_REFERENCED_BY_TASK_SHADER_EXT" );
	#endif
	#ifdef GL_REFERENCED_BY_MESH_SHADER_EXT
		swigIntConstant( GL_REFERENCED_BY_MESH_SHADER_EXT, "GL_REFERENCED_BY_MESH_SHADER_EXT" );
	#endif
	#ifdef GL_REFERENCED_BY_TASK_SHADER_EXT
		swigIntConstant( GL_REFERENCED_BY_TASK_SHADER_EXT, "GL_REFERENCED_BY_TASK_SHADER_EXT" );
	#endif
	#ifdef GL_TASK_SHADER_INVOCATIONS_EXT
		swigIntConstant( GL_TASK_SHADER_INVOCATIONS_EXT, "GL_TASK_SHADER_INVOCATIONS_EXT" );
	#endif
	#ifdef GL_MESH_SHADER_INVOCATIONS_EXT
		swigIntConstant( GL_MESH_SHADER_INVOCATIONS_EXT, "GL_MESH_SHADER_INVOCATIONS_EXT" );
	#endif
	#ifdef GL_MESH_PRIMITIVES_GENERATED_EXT
		swigIntConstant( GL_MESH_PRIMITIVES_GENERATED_EXT, "GL_MESH_PRIMITIVES_GENERATED_EXT" );
	#endif
	#ifdef GL_MESH_SHADER_BIT_EXT
		swigIntConstant( GL_MESH_SHADER_BIT_EXT, "GL_MESH_SHADER_BIT_EXT" );
	#endif
	#ifdef GL_TASK_SHADER_BIT_EXT
		swigIntConstant( GL_TASK_SHADER_BIT_EXT, "GL_TASK_SHADER_BIT_EXT" );
	#endif
	#ifdef GL_MESH_SUBROUTINE_EXT
		swigIntConstant( GL_MESH_SUBROUTINE_EXT, "GL_MESH_SUBROUTINE_EXT" );
	#endif
	#ifdef GL_TASK_SUBROUTINE_EXT
		swigIntConstant( GL_TASK_SUBROUTINE_EXT, "GL_TASK_SUBROUTINE_EXT" );
	#endif
	#ifdef GL_MESH_SUBROUTINE_UNIFORM_EXT
		swigIntConstant( GL_MESH_SUBROUTINE_UNIFORM_EXT, "GL_MESH_SUBROUTINE_UNIFORM_EXT" );
	#endif
	#ifdef GL_TASK_SUBROUTINE_UNIFORM_EXT
		swigIntConstant( GL_TASK_SUBROUTINE_UNIFORM_EXT, "GL_TASK_SUBROUTINE_UNIFORM_EXT" );
	#endif
	#ifdef GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_MESH_SHADER_EXT
		swigIntConstant( GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_MESH_SHADER_EXT, "GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_MESH_SHADER_EXT" );
	#endif
	#ifdef GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TASK_SHADER_EXT
		swigIntConstant( GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TASK_SHADER_EXT, "GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TASK_SHADER_EXT" );
	#endif
	#ifdef GL_EXT_misc_attribute
		swigIntConstant( GL_EXT_misc_attribute, "GL_EXT_misc_attribute" );
	#endif
	#ifdef GL_EXT_multi_draw_arrays
		swigIntConstant( GL_EXT_multi_draw_arrays, "GL_EXT_multi_draw_arrays" );
	#endif
	#ifdef GL_EXT_multisample
		swigIntConstant( GL_EXT_multisample, "GL_EXT_multisample" );
	#endif
	#ifdef GL_MULTISAMPLE_EXT
		swigIntConstant( GL_MULTISAMPLE_EXT, "GL_MULTISAMPLE_EXT" );
	#endif
	#ifdef GL_SAMPLE_ALPHA_TO_MASK_EXT
		swigIntConstant( GL_SAMPLE_ALPHA_TO_MASK_EXT, "GL_SAMPLE_ALPHA_TO_MASK_EXT" );
	#endif
	#ifdef GL_SAMPLE_ALPHA_TO_ONE_EXT
		swigIntConstant( GL_SAMPLE_ALPHA_TO_ONE_EXT, "GL_SAMPLE_ALPHA_TO_ONE_EXT" );
	#endif
	#ifdef GL_SAMPLE_MASK_EXT
		swigIntConstant( GL_SAMPLE_MASK_EXT, "GL_SAMPLE_MASK_EXT" );
	#endif
	#ifdef GL_1PASS_EXT
		swigIntConstant( GL_1PASS_EXT, "GL_1PASS_EXT" );
	#endif
	#ifdef GL_2PASS_0_EXT
		swigIntConstant( GL_2PASS_0_EXT, "GL_2PASS_0_EXT" );
	#endif
	#ifdef GL_2PASS_1_EXT
		swigIntConstant( GL_2PASS_1_EXT, "GL_2PASS_1_EXT" );
	#endif
	#ifdef GL_4PASS_0_EXT
		swigIntConstant( GL_4PASS_0_EXT, "GL_4PASS_0_EXT" );
	#endif
	#ifdef GL_4PASS_1_EXT
		swigIntConstant( GL_4PASS_1_EXT, "GL_4PASS_1_EXT" );
	#endif
	#ifdef GL_4PASS_2_EXT
		swigIntConstant( GL_4PASS_2_EXT, "GL_4PASS_2_EXT" );
	#endif
	#ifdef GL_4PASS_3_EXT
		swigIntConstant( GL_4PASS_3_EXT, "GL_4PASS_3_EXT" );
	#endif
	#ifdef GL_SAMPLE_BUFFERS_EXT
		swigIntConstant( GL_SAMPLE_BUFFERS_EXT, "GL_SAMPLE_BUFFERS_EXT" );
	#endif
	#ifdef GL_SAMPLES_EXT
		swigIntConstant( GL_SAMPLES_EXT, "GL_SAMPLES_EXT" );
	#endif
	#ifdef GL_SAMPLE_MASK_VALUE_EXT
		swigIntConstant( GL_SAMPLE_MASK_VALUE_EXT, "GL_SAMPLE_MASK_VALUE_EXT" );
	#endif
	#ifdef GL_SAMPLE_MASK_INVERT_EXT
		swigIntConstant( GL_SAMPLE_MASK_INVERT_EXT, "GL_SAMPLE_MASK_INVERT_EXT" );
	#endif
	#ifdef GL_SAMPLE_PATTERN_EXT
		swigIntConstant( GL_SAMPLE_PATTERN_EXT, "GL_SAMPLE_PATTERN_EXT" );
	#endif
	#ifdef GL_MULTISAMPLE_BIT_EXT
		swigIntConstant( GL_MULTISAMPLE_BIT_EXT, "GL_MULTISAMPLE_BIT_EXT" );
	#endif
	#ifdef GL_EXT_multiview_tessellation_geometry_shader
		swigIntConstant( GL_EXT_multiview_tessellation_geometry_shader, "GL_EXT_multiview_tessellation_geometry_shader" );
	#endif
	#ifdef GL_EXT_multiview_texture_multisample
		swigIntConstant( GL_EXT_multiview_texture_multisample, "GL_EXT_multiview_texture_multisample" );
	#endif
	#ifdef GL_EXT_multiview_timer_query
		swigIntConstant( GL_EXT_multiview_timer_query, "GL_EXT_multiview_timer_query" );
	#endif
	#ifdef GL_EXT_packed_depth_stencil
		swigIntConstant( GL_EXT_packed_depth_stencil, "GL_EXT_packed_depth_stencil" );
	#endif
	#ifdef GL_DEPTH_STENCIL_EXT
		swigIntConstant( GL_DEPTH_STENCIL_EXT, "GL_DEPTH_STENCIL_EXT" );
	#endif
	#ifdef GL_UNSIGNED_INT_24_8_EXT
		swigIntConstant( GL_UNSIGNED_INT_24_8_EXT, "GL_UNSIGNED_INT_24_8_EXT" );
	#endif
	#ifdef GL_DEPTH24_STENCIL8_EXT
		swigIntConstant( GL_DEPTH24_STENCIL8_EXT, "GL_DEPTH24_STENCIL8_EXT" );
	#endif
	#ifdef GL_TEXTURE_STENCIL_SIZE_EXT
		swigIntConstant( GL_TEXTURE_STENCIL_SIZE_EXT, "GL_TEXTURE_STENCIL_SIZE_EXT" );
	#endif
	#ifdef GL_EXT_packed_float
		swigIntConstant( GL_EXT_packed_float, "GL_EXT_packed_float" );
	#endif
	#ifdef GL_R11F_G11F_B10F_EXT
		swigIntConstant( GL_R11F_G11F_B10F_EXT, "GL_R11F_G11F_B10F_EXT" );
	#endif
	#ifdef GL_UNSIGNED_INT_10F_11F_11F_REV_EXT
		swigIntConstant( GL_UNSIGNED_INT_10F_11F_11F_REV_EXT, "GL_UNSIGNED_INT_10F_11F_11F_REV_EXT" );
	#endif
	#ifdef GL_RGBA_SIGNED_COMPONENTS_EXT
		swigIntConstant( GL_RGBA_SIGNED_COMPONENTS_EXT, "GL_RGBA_SIGNED_COMPONENTS_EXT" );
	#endif
	#ifdef GL_EXT_packed_pixels
		swigIntConstant( GL_EXT_packed_pixels, "GL_EXT_packed_pixels" );
	#endif
	#ifdef GL_UNSIGNED_BYTE_3_3_2_EXT
		swigIntConstant( GL_UNSIGNED_BYTE_3_3_2_EXT, "GL_UNSIGNED_BYTE_3_3_2_EXT" );
	#endif
	#ifdef GL_UNSIGNED_SHORT_4_4_4_4_EXT
		swigIntConstant( GL_UNSIGNED_SHORT_4_4_4_4_EXT, "GL_UNSIGNED_SHORT_4_4_4_4_EXT" );
	#endif
	#ifdef GL_UNSIGNED_SHORT_5_5_5_1_EXT
		swigIntConstant( GL_UNSIGNED_SHORT_5_5_5_1_EXT, "GL_UNSIGNED_SHORT_5_5_5_1_EXT" );
	#endif
	#ifdef GL_UNSIGNED_INT_8_8_8_8_EXT
		swigIntConstant( GL_UNSIGNED_INT_8_8_8_8_EXT, "GL_UNSIGNED_INT_8_8_8_8_EXT" );
	#endif
	#ifdef GL_UNSIGNED_INT_10_10_10_2_EXT
		swigIntConstant( GL_UNSIGNED_INT_10_10_10_2_EXT, "GL_UNSIGNED_INT_10_10_10_2_EXT" );
	#endif
	#ifdef GL_EXT_paletted_texture
		swigIntConstant( GL_EXT_paletted_texture, "GL_EXT_paletted_texture" );
	#endif
	#ifdef GL_COLOR_INDEX1_EXT
		swigIntConstant( GL_COLOR_INDEX1_EXT, "GL_COLOR_INDEX1_EXT" );
	#endif
	#ifdef GL_COLOR_INDEX2_EXT
		swigIntConstant( GL_COLOR_INDEX2_EXT, "GL_COLOR_INDEX2_EXT" );
	#endif
	#ifdef GL_COLOR_INDEX4_EXT
		swigIntConstant( GL_COLOR_INDEX4_EXT, "GL_COLOR_INDEX4_EXT" );
	#endif
	#ifdef GL_COLOR_INDEX8_EXT
		swigIntConstant( GL_COLOR_INDEX8_EXT, "GL_COLOR_INDEX8_EXT" );
	#endif
	#ifdef GL_COLOR_INDEX12_EXT
		swigIntConstant( GL_COLOR_INDEX12_EXT, "GL_COLOR_INDEX12_EXT" );
	#endif
	#ifdef GL_COLOR_INDEX16_EXT
		swigIntConstant( GL_COLOR_INDEX16_EXT, "GL_COLOR_INDEX16_EXT" );
	#endif
	#ifdef GL_TEXTURE_INDEX_SIZE_EXT
		swigIntConstant( GL_TEXTURE_INDEX_SIZE_EXT, "GL_TEXTURE_INDEX_SIZE_EXT" );
	#endif
	#ifdef GL_EXT_pixel_buffer_object
		swigIntConstant( GL_EXT_pixel_buffer_object, "GL_EXT_pixel_buffer_object" );
	#endif
	#ifdef GL_PIXEL_PACK_BUFFER_EXT
		swigIntConstant( GL_PIXEL_PACK_BUFFER_EXT, "GL_PIXEL_PACK_BUFFER_EXT" );
	#endif
	#ifdef GL_PIXEL_UNPACK_BUFFER_EXT
		swigIntConstant( GL_PIXEL_UNPACK_BUFFER_EXT, "GL_PIXEL_UNPACK_BUFFER_EXT" );
	#endif
	#ifdef GL_PIXEL_PACK_BUFFER_BINDING_EXT
		swigIntConstant( GL_PIXEL_PACK_BUFFER_BINDING_EXT, "GL_PIXEL_PACK_BUFFER_BINDING_EXT" );
	#endif
	#ifdef GL_PIXEL_UNPACK_BUFFER_BINDING_EXT
		swigIntConstant( GL_PIXEL_UNPACK_BUFFER_BINDING_EXT, "GL_PIXEL_UNPACK_BUFFER_BINDING_EXT" );
	#endif
	#ifdef GL_EXT_pixel_transform
		swigIntConstant( GL_EXT_pixel_transform, "GL_EXT_pixel_transform" );
	#endif
	#ifdef GL_PIXEL_TRANSFORM_2D_EXT
		swigIntConstant( GL_PIXEL_TRANSFORM_2D_EXT, "GL_PIXEL_TRANSFORM_2D_EXT" );
	#endif
	#ifdef GL_PIXEL_MAG_FILTER_EXT
		swigIntConstant( GL_PIXEL_MAG_FILTER_EXT, "GL_PIXEL_MAG_FILTER_EXT" );
	#endif
	#ifdef GL_PIXEL_MIN_FILTER_EXT
		swigIntConstant( GL_PIXEL_MIN_FILTER_EXT, "GL_PIXEL_MIN_FILTER_EXT" );
	#endif
	#ifdef GL_PIXEL_CUBIC_WEIGHT_EXT
		swigIntConstant( GL_PIXEL_CUBIC_WEIGHT_EXT, "GL_PIXEL_CUBIC_WEIGHT_EXT" );
	#endif
	#ifdef GL_CUBIC_EXT
		swigIntConstant( GL_CUBIC_EXT, "GL_CUBIC_EXT" );
	#endif
	#ifdef GL_AVERAGE_EXT
		swigIntConstant( GL_AVERAGE_EXT, "GL_AVERAGE_EXT" );
	#endif
	#ifdef GL_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT
		swigIntConstant( GL_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT, "GL_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT" );
	#endif
	#ifdef GL_MAX_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT
		swigIntConstant( GL_MAX_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT, "GL_MAX_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT" );
	#endif
	#ifdef GL_PIXEL_TRANSFORM_2D_MATRIX_EXT
		swigIntConstant( GL_PIXEL_TRANSFORM_2D_MATRIX_EXT, "GL_PIXEL_TRANSFORM_2D_MATRIX_EXT" );
	#endif
	#ifdef GL_EXT_pixel_transform_color_table
		swigIntConstant( GL_EXT_pixel_transform_color_table, "GL_EXT_pixel_transform_color_table" );
	#endif
	#ifdef GL_EXT_point_parameters
		swigIntConstant( GL_EXT_point_parameters, "GL_EXT_point_parameters" );
	#endif
	#ifdef GL_POINT_SIZE_MIN_EXT
		swigIntConstant( GL_POINT_SIZE_MIN_EXT, "GL_POINT_SIZE_MIN_EXT" );
	#endif
	#ifdef GL_POINT_SIZE_MAX_EXT
		swigIntConstant( GL_POINT_SIZE_MAX_EXT, "GL_POINT_SIZE_MAX_EXT" );
	#endif
	#ifdef GL_POINT_FADE_THRESHOLD_SIZE_EXT
		swigIntConstant( GL_POINT_FADE_THRESHOLD_SIZE_EXT, "GL_POINT_FADE_THRESHOLD_SIZE_EXT" );
	#endif
	#ifdef GL_DISTANCE_ATTENUATION_EXT
		swigIntConstant( GL_DISTANCE_ATTENUATION_EXT, "GL_DISTANCE_ATTENUATION_EXT" );
	#endif
	#ifdef GL_EXT_polygon_offset
		swigIntConstant( GL_EXT_polygon_offset, "GL_EXT_polygon_offset" );
	#endif
	#ifdef GL_POLYGON_OFFSET_EXT
		swigIntConstant( GL_POLYGON_OFFSET_EXT, "GL_POLYGON_OFFSET_EXT" );
	#endif
	#ifdef GL_POLYGON_OFFSET_FACTOR_EXT
		swigIntConstant( GL_POLYGON_OFFSET_FACTOR_EXT, "GL_POLYGON_OFFSET_FACTOR_EXT" );
	#endif
	#ifdef GL_POLYGON_OFFSET_BIAS_EXT
		swigIntConstant( GL_POLYGON_OFFSET_BIAS_EXT, "GL_POLYGON_OFFSET_BIAS_EXT" );
	#endif
	#ifdef GL_EXT_polygon_offset_clamp
		swigIntConstant( GL_EXT_polygon_offset_clamp, "GL_EXT_polygon_offset_clamp" );
	#endif
	#ifdef GL_POLYGON_OFFSET_CLAMP_EXT
		swigIntConstant( GL_POLYGON_OFFSET_CLAMP_EXT, "GL_POLYGON_OFFSET_CLAMP_EXT" );
	#endif
	#ifdef GL_EXT_post_depth_coverage
		swigIntConstant( GL_EXT_post_depth_coverage, "GL_EXT_post_depth_coverage" );
	#endif
	#ifdef GL_EXT_provoking_vertex
		swigIntConstant( GL_EXT_provoking_vertex, "GL_EXT_provoking_vertex" );
	#endif
	#ifdef GL_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION_EXT
		swigIntConstant( GL_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION_EXT, "GL_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION_EXT" );
	#endif
	#ifdef GL_FIRST_VERTEX_CONVENTION_EXT
		swigIntConstant( GL_FIRST_VERTEX_CONVENTION_EXT, "GL_FIRST_VERTEX_CONVENTION_EXT" );
	#endif
	#ifdef GL_LAST_VERTEX_CONVENTION_EXT
		swigIntConstant( GL_LAST_VERTEX_CONVENTION_EXT, "GL_LAST_VERTEX_CONVENTION_EXT" );
	#endif
	#ifdef GL_PROVOKING_VERTEX_EXT
		swigIntConstant( GL_PROVOKING_VERTEX_EXT, "GL_PROVOKING_VERTEX_EXT" );
	#endif
	#ifdef GL_EXT_raster_multisample
		swigIntConstant( GL_EXT_raster_multisample, "GL_EXT_raster_multisample" );
	#endif
	#ifdef GL_RASTER_MULTISAMPLE_EXT
		swigIntConstant( GL_RASTER_MULTISAMPLE_EXT, "GL_RASTER_MULTISAMPLE_EXT" );
	#endif
	#ifdef GL_RASTER_SAMPLES_EXT
		swigIntConstant( GL_RASTER_SAMPLES_EXT, "GL_RASTER_SAMPLES_EXT" );
	#endif
	#ifdef GL_MAX_RASTER_SAMPLES_EXT
		swigIntConstant( GL_MAX_RASTER_SAMPLES_EXT, "GL_MAX_RASTER_SAMPLES_EXT" );
	#endif
	#ifdef GL_RASTER_FIXED_SAMPLE_LOCATIONS_EXT
		swigIntConstant( GL_RASTER_FIXED_SAMPLE_LOCATIONS_EXT, "GL_RASTER_FIXED_SAMPLE_LOCATIONS_EXT" );
	#endif
	#ifdef GL_MULTISAMPLE_RASTERIZATION_ALLOWED_EXT
		swigIntConstant( GL_MULTISAMPLE_RASTERIZATION_ALLOWED_EXT, "GL_MULTISAMPLE_RASTERIZATION_ALLOWED_EXT" );
	#endif
	#ifdef GL_EFFECTIVE_RASTER_SAMPLES_EXT
		swigIntConstant( GL_EFFECTIVE_RASTER_SAMPLES_EXT, "GL_EFFECTIVE_RASTER_SAMPLES_EXT" );
	#endif
	#ifdef GL_EXT_rescale_normal
		swigIntConstant( GL_EXT_rescale_normal, "GL_EXT_rescale_normal" );
	#endif
	#ifdef GL_RESCALE_NORMAL_EXT
		swigIntConstant( GL_RESCALE_NORMAL_EXT, "GL_RESCALE_NORMAL_EXT" );
	#endif
	#ifdef GL_EXT_secondary_color
		swigIntConstant( GL_EXT_secondary_color, "GL_EXT_secondary_color" );
	#endif
	#ifdef GL_COLOR_SUM_EXT
		swigIntConstant( GL_COLOR_SUM_EXT, "GL_COLOR_SUM_EXT" );
	#endif
	#ifdef GL_CURRENT_SECONDARY_COLOR_EXT
		swigIntConstant( GL_CURRENT_SECONDARY_COLOR_EXT, "GL_CURRENT_SECONDARY_COLOR_EXT" );
	#endif
	#ifdef GL_SECONDARY_COLOR_ARRAY_SIZE_EXT
		swigIntConstant( GL_SECONDARY_COLOR_ARRAY_SIZE_EXT, "GL_SECONDARY_COLOR_ARRAY_SIZE_EXT" );
	#endif
	#ifdef GL_SECONDARY_COLOR_ARRAY_TYPE_EXT
		swigIntConstant( GL_SECONDARY_COLOR_ARRAY_TYPE_EXT, "GL_SECONDARY_COLOR_ARRAY_TYPE_EXT" );
	#endif
	#ifdef GL_SECONDARY_COLOR_ARRAY_STRIDE_EXT
		swigIntConstant( GL_SECONDARY_COLOR_ARRAY_STRIDE_EXT, "GL_SECONDARY_COLOR_ARRAY_STRIDE_EXT" );
	#endif
	#ifdef GL_SECONDARY_COLOR_ARRAY_POINTER_EXT
		swigIntConstant( GL_SECONDARY_COLOR_ARRAY_POINTER_EXT, "GL_SECONDARY_COLOR_ARRAY_POINTER_EXT" );
	#endif
	#ifdef GL_SECONDARY_COLOR_ARRAY_EXT
		swigIntConstant( GL_SECONDARY_COLOR_ARRAY_EXT, "GL_SECONDARY_COLOR_ARRAY_EXT" );
	#endif
	#ifdef GL_EXT_semaphore
		swigIntConstant( GL_EXT_semaphore, "GL_EXT_semaphore" );
	#endif
	#ifdef GL_LAYOUT_GENERAL_EXT
		swigIntConstant( GL_LAYOUT_GENERAL_EXT, "GL_LAYOUT_GENERAL_EXT" );
	#endif
	#ifdef GL_LAYOUT_COLOR_ATTACHMENT_EXT
		swigIntConstant( GL_LAYOUT_COLOR_ATTACHMENT_EXT, "GL_LAYOUT_COLOR_ATTACHMENT_EXT" );
	#endif
	#ifdef GL_LAYOUT_DEPTH_STENCIL_ATTACHMENT_EXT
		swigIntConstant( GL_LAYOUT_DEPTH_STENCIL_ATTACHMENT_EXT, "GL_LAYOUT_DEPTH_STENCIL_ATTACHMENT_EXT" );
	#endif
	#ifdef GL_LAYOUT_DEPTH_STENCIL_READ_ONLY_EXT
		swigIntConstant( GL_LAYOUT_DEPTH_STENCIL_READ_ONLY_EXT, "GL_LAYOUT_DEPTH_STENCIL_READ_ONLY_EXT" );
	#endif
	#ifdef GL_LAYOUT_SHADER_READ_ONLY_EXT
		swigIntConstant( GL_LAYOUT_SHADER_READ_ONLY_EXT, "GL_LAYOUT_SHADER_READ_ONLY_EXT" );
	#endif
	#ifdef GL_LAYOUT_TRANSFER_SRC_EXT
		swigIntConstant( GL_LAYOUT_TRANSFER_SRC_EXT, "GL_LAYOUT_TRANSFER_SRC_EXT" );
	#endif
	#ifdef GL_LAYOUT_TRANSFER_DST_EXT
		swigIntConstant( GL_LAYOUT_TRANSFER_DST_EXT, "GL_LAYOUT_TRANSFER_DST_EXT" );
	#endif
	#ifdef GL_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_EXT
		swigIntConstant( GL_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_EXT, "GL_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_EXT" );
	#endif
	#ifdef GL_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_EXT
		swigIntConstant( GL_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_EXT, "GL_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_EXT" );
	#endif
	#ifdef GL_EXT_semaphore_fd
		swigIntConstant( GL_EXT_semaphore_fd, "GL_EXT_semaphore_fd" );
	#endif
	#ifdef GL_EXT_semaphore_win32
		swigIntConstant( GL_EXT_semaphore_win32, "GL_EXT_semaphore_win32" );
	#endif
	#ifdef GL_HANDLE_TYPE_D3D12_FENCE_EXT
		swigIntConstant( GL_HANDLE_TYPE_D3D12_FENCE_EXT, "GL_HANDLE_TYPE_D3D12_FENCE_EXT" );
	#endif
	#ifdef GL_D3D12_FENCE_VALUE_EXT
		swigIntConstant( GL_D3D12_FENCE_VALUE_EXT, "GL_D3D12_FENCE_VALUE_EXT" );
	#endif
	#ifdef GL_EXT_separate_shader_objects
		swigIntConstant( GL_EXT_separate_shader_objects, "GL_EXT_separate_shader_objects" );
	#endif
	#ifdef GL_ACTIVE_PROGRAM_EXT
		swigIntConstant( GL_ACTIVE_PROGRAM_EXT, "GL_ACTIVE_PROGRAM_EXT" );
	#endif
	#ifdef GL_EXT_separate_specular_color
		swigIntConstant( GL_EXT_separate_specular_color, "GL_EXT_separate_specular_color" );
	#endif
	#ifdef GL_LIGHT_MODEL_COLOR_CONTROL_EXT
		swigIntConstant( GL_LIGHT_MODEL_COLOR_CONTROL_EXT, "GL_LIGHT_MODEL_COLOR_CONTROL_EXT" );
	#endif
	#ifdef GL_SINGLE_COLOR_EXT
		swigIntConstant( GL_SINGLE_COLOR_EXT, "GL_SINGLE_COLOR_EXT" );
	#endif
	#ifdef GL_SEPARATE_SPECULAR_COLOR_EXT
		swigIntConstant( GL_SEPARATE_SPECULAR_COLOR_EXT, "GL_SEPARATE_SPECULAR_COLOR_EXT" );
	#endif
	#ifdef GL_EXT_shader_framebuffer_fetch
		swigIntConstant( GL_EXT_shader_framebuffer_fetch, "GL_EXT_shader_framebuffer_fetch" );
	#endif
	#ifdef GL_FRAGMENT_SHADER_DISCARDS_SAMPLES_EXT
		swigIntConstant( GL_FRAGMENT_SHADER_DISCARDS_SAMPLES_EXT, "GL_FRAGMENT_SHADER_DISCARDS_SAMPLES_EXT" );
	#endif
	#ifdef GL_EXT_shader_framebuffer_fetch_non_coherent
		swigIntConstant( GL_EXT_shader_framebuffer_fetch_non_coherent, "GL_EXT_shader_framebuffer_fetch_non_coherent" );
	#endif
	#ifdef GL_EXT_shader_image_load_formatted
		swigIntConstant( GL_EXT_shader_image_load_formatted, "GL_EXT_shader_image_load_formatted" );
	#endif
	#ifdef GL_EXT_shader_image_load_store
		swigIntConstant( GL_EXT_shader_image_load_store, "GL_EXT_shader_image_load_store" );
	#endif
	#ifdef GL_MAX_IMAGE_UNITS_EXT
		swigIntConstant( GL_MAX_IMAGE_UNITS_EXT, "GL_MAX_IMAGE_UNITS_EXT" );
	#endif
	#ifdef GL_MAX_COMBINED_IMAGE_UNITS_AND_FRAGMENT_OUTPUTS_EXT
		swigIntConstant( GL_MAX_COMBINED_IMAGE_UNITS_AND_FRAGMENT_OUTPUTS_EXT, "GL_MAX_COMBINED_IMAGE_UNITS_AND_FRAGMENT_OUTPUTS_EXT" );
	#endif
	#ifdef GL_IMAGE_BINDING_NAME_EXT
		swigIntConstant( GL_IMAGE_BINDING_NAME_EXT, "GL_IMAGE_BINDING_NAME_EXT" );
	#endif
	#ifdef GL_IMAGE_BINDING_LEVEL_EXT
		swigIntConstant( GL_IMAGE_BINDING_LEVEL_EXT, "GL_IMAGE_BINDING_LEVEL_EXT" );
	#endif
	#ifdef GL_IMAGE_BINDING_LAYERED_EXT
		swigIntConstant( GL_IMAGE_BINDING_LAYERED_EXT, "GL_IMAGE_BINDING_LAYERED_EXT" );
	#endif
	#ifdef GL_IMAGE_BINDING_LAYER_EXT
		swigIntConstant( GL_IMAGE_BINDING_LAYER_EXT, "GL_IMAGE_BINDING_LAYER_EXT" );
	#endif
	#ifdef GL_IMAGE_BINDING_ACCESS_EXT
		swigIntConstant( GL_IMAGE_BINDING_ACCESS_EXT, "GL_IMAGE_BINDING_ACCESS_EXT" );
	#endif
	#ifdef GL_IMAGE_1D_EXT
		swigIntConstant( GL_IMAGE_1D_EXT, "GL_IMAGE_1D_EXT" );
	#endif
	#ifdef GL_IMAGE_2D_EXT
		swigIntConstant( GL_IMAGE_2D_EXT, "GL_IMAGE_2D_EXT" );
	#endif
	#ifdef GL_IMAGE_3D_EXT
		swigIntConstant( GL_IMAGE_3D_EXT, "GL_IMAGE_3D_EXT" );
	#endif
	#ifdef GL_IMAGE_2D_RECT_EXT
		swigIntConstant( GL_IMAGE_2D_RECT_EXT, "GL_IMAGE_2D_RECT_EXT" );
	#endif
	#ifdef GL_IMAGE_CUBE_EXT
		swigIntConstant( GL_IMAGE_CUBE_EXT, "GL_IMAGE_CUBE_EXT" );
	#endif
	#ifdef GL_IMAGE_BUFFER_EXT
		swigIntConstant( GL_IMAGE_BUFFER_EXT, "GL_IMAGE_BUFFER_EXT" );
	#endif
	#ifdef GL_IMAGE_1D_ARRAY_EXT
		swigIntConstant( GL_IMAGE_1D_ARRAY_EXT, "GL_IMAGE_1D_ARRAY_EXT" );
	#endif
	#ifdef GL_IMAGE_2D_ARRAY_EXT
		swigIntConstant( GL_IMAGE_2D_ARRAY_EXT, "GL_IMAGE_2D_ARRAY_EXT" );
	#endif
	#ifdef GL_IMAGE_CUBE_MAP_ARRAY_EXT
		swigIntConstant( GL_IMAGE_CUBE_MAP_ARRAY_EXT, "GL_IMAGE_CUBE_MAP_ARRAY_EXT" );
	#endif
	#ifdef GL_IMAGE_2D_MULTISAMPLE_EXT
		swigIntConstant( GL_IMAGE_2D_MULTISAMPLE_EXT, "GL_IMAGE_2D_MULTISAMPLE_EXT" );
	#endif
	#ifdef GL_IMAGE_2D_MULTISAMPLE_ARRAY_EXT
		swigIntConstant( GL_IMAGE_2D_MULTISAMPLE_ARRAY_EXT, "GL_IMAGE_2D_MULTISAMPLE_ARRAY_EXT" );
	#endif
	#ifdef GL_INT_IMAGE_1D_EXT
		swigIntConstant( GL_INT_IMAGE_1D_EXT, "GL_INT_IMAGE_1D_EXT" );
	#endif
	#ifdef GL_INT_IMAGE_2D_EXT
		swigIntConstant( GL_INT_IMAGE_2D_EXT, "GL_INT_IMAGE_2D_EXT" );
	#endif
	#ifdef GL_INT_IMAGE_3D_EXT
		swigIntConstant( GL_INT_IMAGE_3D_EXT, "GL_INT_IMAGE_3D_EXT" );
	#endif
	#ifdef GL_INT_IMAGE_2D_RECT_EXT
		swigIntConstant( GL_INT_IMAGE_2D_RECT_EXT, "GL_INT_IMAGE_2D_RECT_EXT" );
	#endif
	#ifdef GL_INT_IMAGE_CUBE_EXT
		swigIntConstant( GL_INT_IMAGE_CUBE_EXT, "GL_INT_IMAGE_CUBE_EXT" );
	#endif
	#ifdef GL_INT_IMAGE_BUFFER_EXT
		swigIntConstant( GL_INT_IMAGE_BUFFER_EXT, "GL_INT_IMAGE_BUFFER_EXT" );
	#endif
	#ifdef GL_INT_IMAGE_1D_ARRAY_EXT
		swigIntConstant( GL_INT_IMAGE_1D_ARRAY_EXT, "GL_INT_IMAGE_1D_ARRAY_EXT" );
	#endif
	#ifdef GL_INT_IMAGE_2D_ARRAY_EXT
		swigIntConstant( GL_INT_IMAGE_2D_ARRAY_EXT, "GL_INT_IMAGE_2D_ARRAY_EXT" );
	#endif
	#ifdef GL_INT_IMAGE_CUBE_MAP_ARRAY_EXT
		swigIntConstant( GL_INT_IMAGE_CUBE_MAP_ARRAY_EXT, "GL_INT_IMAGE_CUBE_MAP_ARRAY_EXT" );
	#endif
	#ifdef GL_INT_IMAGE_2D_MULTISAMPLE_EXT
		swigIntConstant( GL_INT_IMAGE_2D_MULTISAMPLE_EXT, "GL_INT_IMAGE_2D_MULTISAMPLE_EXT" );
	#endif
	#ifdef GL_INT_IMAGE_2D_MULTISAMPLE_ARRAY_EXT
		swigIntConstant( GL_INT_IMAGE_2D_MULTISAMPLE_ARRAY_EXT, "GL_INT_IMAGE_2D_MULTISAMPLE_ARRAY_EXT" );
	#endif
	#ifdef GL_UNSIGNED_INT_IMAGE_1D_EXT
		swigIntConstant( GL_UNSIGNED_INT_IMAGE_1D_EXT, "GL_UNSIGNED_INT_IMAGE_1D_EXT" );
	#endif
	#ifdef GL_UNSIGNED_INT_IMAGE_2D_EXT
		swigIntConstant( GL_UNSIGNED_INT_IMAGE_2D_EXT, "GL_UNSIGNED_INT_IMAGE_2D_EXT" );
	#endif
	#ifdef GL_UNSIGNED_INT_IMAGE_3D_EXT
		swigIntConstant( GL_UNSIGNED_INT_IMAGE_3D_EXT, "GL_UNSIGNED_INT_IMAGE_3D_EXT" );
	#endif
	#ifdef GL_UNSIGNED_INT_IMAGE_2D_RECT_EXT
		swigIntConstant( GL_UNSIGNED_INT_IMAGE_2D_RECT_EXT, "GL_UNSIGNED_INT_IMAGE_2D_RECT_EXT" );
	#endif
	#ifdef GL_UNSIGNED_INT_IMAGE_CUBE_EXT
		swigIntConstant( GL_UNSIGNED_INT_IMAGE_CUBE_EXT, "GL_UNSIGNED_INT_IMAGE_CUBE_EXT" );
	#endif
	#ifdef GL_UNSIGNED_INT_IMAGE_BUFFER_EXT
		swigIntConstant( GL_UNSIGNED_INT_IMAGE_BUFFER_EXT, "GL_UNSIGNED_INT_IMAGE_BUFFER_EXT" );
	#endif
	#ifdef GL_UNSIGNED_INT_IMAGE_1D_ARRAY_EXT
		swigIntConstant( GL_UNSIGNED_INT_IMAGE_1D_ARRAY_EXT, "GL_UNSIGNED_INT_IMAGE_1D_ARRAY_EXT" );
	#endif
	#ifdef GL_UNSIGNED_INT_IMAGE_2D_ARRAY_EXT
		swigIntConstant( GL_UNSIGNED_INT_IMAGE_2D_ARRAY_EXT, "GL_UNSIGNED_INT_IMAGE_2D_ARRAY_EXT" );
	#endif
	#ifdef GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY_EXT
		swigIntConstant( GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY_EXT, "GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY_EXT" );
	#endif
	#ifdef GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_EXT
		swigIntConstant( GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_EXT, "GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_EXT" );
	#endif
	#ifdef GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_ARRAY_EXT
		swigIntConstant( GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_ARRAY_EXT, "GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_ARRAY_EXT" );
	#endif
	#ifdef GL_MAX_IMAGE_SAMPLES_EXT
		swigIntConstant( GL_MAX_IMAGE_SAMPLES_EXT, "GL_MAX_IMAGE_SAMPLES_EXT" );
	#endif
	#ifdef GL_IMAGE_BINDING_FORMAT_EXT
		swigIntConstant( GL_IMAGE_BINDING_FORMAT_EXT, "GL_IMAGE_BINDING_FORMAT_EXT" );
	#endif
	#ifdef GL_VERTEX_ATTRIB_ARRAY_BARRIER_BIT_EXT
		swigIntConstant( GL_VERTEX_ATTRIB_ARRAY_BARRIER_BIT_EXT, "GL_VERTEX_ATTRIB_ARRAY_BARRIER_BIT_EXT" );
	#endif
	#ifdef GL_ELEMENT_ARRAY_BARRIER_BIT_EXT
		swigIntConstant( GL_ELEMENT_ARRAY_BARRIER_BIT_EXT, "GL_ELEMENT_ARRAY_BARRIER_BIT_EXT" );
	#endif
	#ifdef GL_UNIFORM_BARRIER_BIT_EXT
		swigIntConstant( GL_UNIFORM_BARRIER_BIT_EXT, "GL_UNIFORM_BARRIER_BIT_EXT" );
	#endif
	#ifdef GL_TEXTURE_FETCH_BARRIER_BIT_EXT
		swigIntConstant( GL_TEXTURE_FETCH_BARRIER_BIT_EXT, "GL_TEXTURE_FETCH_BARRIER_BIT_EXT" );
	#endif
	#ifdef GL_SHADER_IMAGE_ACCESS_BARRIER_BIT_EXT
		swigIntConstant( GL_SHADER_IMAGE_ACCESS_BARRIER_BIT_EXT, "GL_SHADER_IMAGE_ACCESS_BARRIER_BIT_EXT" );
	#endif
	#ifdef GL_COMMAND_BARRIER_BIT_EXT
		swigIntConstant( GL_COMMAND_BARRIER_BIT_EXT, "GL_COMMAND_BARRIER_BIT_EXT" );
	#endif
	#ifdef GL_PIXEL_BUFFER_BARRIER_BIT_EXT
		swigIntConstant( GL_PIXEL_BUFFER_BARRIER_BIT_EXT, "GL_PIXEL_BUFFER_BARRIER_BIT_EXT" );
	#endif
	#ifdef GL_TEXTURE_UPDATE_BARRIER_BIT_EXT
		swigIntConstant( GL_TEXTURE_UPDATE_BARRIER_BIT_EXT, "GL_TEXTURE_UPDATE_BARRIER_BIT_EXT" );
	#endif
	#ifdef GL_BUFFER_UPDATE_BARRIER_BIT_EXT
		swigIntConstant( GL_BUFFER_UPDATE_BARRIER_BIT_EXT, "GL_BUFFER_UPDATE_BARRIER_BIT_EXT" );
	#endif
	#ifdef GL_FRAMEBUFFER_BARRIER_BIT_EXT
		swigIntConstant( GL_FRAMEBUFFER_BARRIER_BIT_EXT, "GL_FRAMEBUFFER_BARRIER_BIT_EXT" );
	#endif
	#ifdef GL_TRANSFORM_FEEDBACK_BARRIER_BIT_EXT
		swigIntConstant( GL_TRANSFORM_FEEDBACK_BARRIER_BIT_EXT, "GL_TRANSFORM_FEEDBACK_BARRIER_BIT_EXT" );
	#endif
	#ifdef GL_ATOMIC_COUNTER_BARRIER_BIT_EXT
		swigIntConstant( GL_ATOMIC_COUNTER_BARRIER_BIT_EXT, "GL_ATOMIC_COUNTER_BARRIER_BIT_EXT" );
	#endif
	#ifdef GL_ALL_BARRIER_BITS_EXT
		swigIntConstant( GL_ALL_BARRIER_BITS_EXT, "GL_ALL_BARRIER_BITS_EXT" );
	#endif
	#ifdef GL_EXT_shader_integer_mix
		swigIntConstant( GL_EXT_shader_integer_mix, "GL_EXT_shader_integer_mix" );
	#endif
	#ifdef GL_EXT_shader_samples_identical
		swigIntConstant( GL_EXT_shader_samples_identical, "GL_EXT_shader_samples_identical" );
	#endif
	#ifdef GL_EXT_shadow_funcs
		swigIntConstant( GL_EXT_shadow_funcs, "GL_EXT_shadow_funcs" );
	#endif
	#ifdef GL_EXT_shared_texture_palette
		swigIntConstant( GL_EXT_shared_texture_palette, "GL_EXT_shared_texture_palette" );
	#endif
	#ifdef GL_SHARED_TEXTURE_PALETTE_EXT
		swigIntConstant( GL_SHARED_TEXTURE_PALETTE_EXT, "GL_SHARED_TEXTURE_PALETTE_EXT" );
	#endif
	#ifdef GL_EXT_sparse_texture2
		swigIntConstant( GL_EXT_sparse_texture2, "GL_EXT_sparse_texture2" );
	#endif
	#ifdef GL_EXT_stencil_clear_tag
		swigIntConstant( GL_EXT_stencil_clear_tag, "GL_EXT_stencil_clear_tag" );
	#endif
	#ifdef GL_STENCIL_TAG_BITS_EXT
		swigIntConstant( GL_STENCIL_TAG_BITS_EXT, "GL_STENCIL_TAG_BITS_EXT" );
	#endif
	#ifdef GL_STENCIL_CLEAR_TAG_VALUE_EXT
		swigIntConstant( GL_STENCIL_CLEAR_TAG_VALUE_EXT, "GL_STENCIL_CLEAR_TAG_VALUE_EXT" );
	#endif
	#ifdef GL_EXT_stencil_two_side
		swigIntConstant( GL_EXT_stencil_two_side, "GL_EXT_stencil_two_side" );
	#endif
	#ifdef GL_STENCIL_TEST_TWO_SIDE_EXT
		swigIntConstant( GL_STENCIL_TEST_TWO_SIDE_EXT, "GL_STENCIL_TEST_TWO_SIDE_EXT" );
	#endif
	#ifdef GL_ACTIVE_STENCIL_FACE_EXT
		swigIntConstant( GL_ACTIVE_STENCIL_FACE_EXT, "GL_ACTIVE_STENCIL_FACE_EXT" );
	#endif
	#ifdef GL_EXT_stencil_wrap
		swigIntConstant( GL_EXT_stencil_wrap, "GL_EXT_stencil_wrap" );
	#endif
	#ifdef GL_INCR_WRAP_EXT
		swigIntConstant( GL_INCR_WRAP_EXT, "GL_INCR_WRAP_EXT" );
	#endif
	#ifdef GL_DECR_WRAP_EXT
		swigIntConstant( GL_DECR_WRAP_EXT, "GL_DECR_WRAP_EXT" );
	#endif
	#ifdef GL_EXT_subtexture
		swigIntConstant( GL_EXT_subtexture, "GL_EXT_subtexture" );
	#endif
	#ifdef GL_EXT_texture
		swigIntConstant( GL_EXT_texture, "GL_EXT_texture" );
	#endif
	#ifdef GL_ALPHA4_EXT
		swigIntConstant( GL_ALPHA4_EXT, "GL_ALPHA4_EXT" );
	#endif
	#ifdef GL_ALPHA8_EXT
		swigIntConstant( GL_ALPHA8_EXT, "GL_ALPHA8_EXT" );
	#endif
	#ifdef GL_ALPHA12_EXT
		swigIntConstant( GL_ALPHA12_EXT, "GL_ALPHA12_EXT" );
	#endif
	#ifdef GL_ALPHA16_EXT
		swigIntConstant( GL_ALPHA16_EXT, "GL_ALPHA16_EXT" );
	#endif
	#ifdef GL_LUMINANCE4_EXT
		swigIntConstant( GL_LUMINANCE4_EXT, "GL_LUMINANCE4_EXT" );
	#endif
	#ifdef GL_LUMINANCE8_EXT
		swigIntConstant( GL_LUMINANCE8_EXT, "GL_LUMINANCE8_EXT" );
	#endif
	#ifdef GL_LUMINANCE12_EXT
		swigIntConstant( GL_LUMINANCE12_EXT, "GL_LUMINANCE12_EXT" );
	#endif
	#ifdef GL_LUMINANCE16_EXT
		swigIntConstant( GL_LUMINANCE16_EXT, "GL_LUMINANCE16_EXT" );
	#endif
	#ifdef GL_LUMINANCE4_ALPHA4_EXT
		swigIntConstant( GL_LUMINANCE4_ALPHA4_EXT, "GL_LUMINANCE4_ALPHA4_EXT" );
	#endif
	#ifdef GL_LUMINANCE6_ALPHA2_EXT
		swigIntConstant( GL_LUMINANCE6_ALPHA2_EXT, "GL_LUMINANCE6_ALPHA2_EXT" );
	#endif
	#ifdef GL_LUMINANCE8_ALPHA8_EXT
		swigIntConstant( GL_LUMINANCE8_ALPHA8_EXT, "GL_LUMINANCE8_ALPHA8_EXT" );
	#endif
	#ifdef GL_LUMINANCE12_ALPHA4_EXT
		swigIntConstant( GL_LUMINANCE12_ALPHA4_EXT, "GL_LUMINANCE12_ALPHA4_EXT" );
	#endif
	#ifdef GL_LUMINANCE12_ALPHA12_EXT
		swigIntConstant( GL_LUMINANCE12_ALPHA12_EXT, "GL_LUMINANCE12_ALPHA12_EXT" );
	#endif
	#ifdef GL_LUMINANCE16_ALPHA16_EXT
		swigIntConstant( GL_LUMINANCE16_ALPHA16_EXT, "GL_LUMINANCE16_ALPHA16_EXT" );
	#endif
	#ifdef GL_INTENSITY_EXT
		swigIntConstant( GL_INTENSITY_EXT, "GL_INTENSITY_EXT" );
	#endif
	#ifdef GL_INTENSITY4_EXT
		swigIntConstant( GL_INTENSITY4_EXT, "GL_INTENSITY4_EXT" );
	#endif
	#ifdef GL_INTENSITY8_EXT
		swigIntConstant( GL_INTENSITY8_EXT, "GL_INTENSITY8_EXT" );
	#endif
	#ifdef GL_INTENSITY12_EXT
		swigIntConstant( GL_INTENSITY12_EXT, "GL_INTENSITY12_EXT" );
	#endif
	#ifdef GL_INTENSITY16_EXT
		swigIntConstant( GL_INTENSITY16_EXT, "GL_INTENSITY16_EXT" );
	#endif
	#ifdef GL_RGB2_EXT
		swigIntConstant( GL_RGB2_EXT, "GL_RGB2_EXT" );
	#endif
	#ifdef GL_RGB4_EXT
		swigIntConstant( GL_RGB4_EXT, "GL_RGB4_EXT" );
	#endif
	#ifdef GL_RGB5_EXT
		swigIntConstant( GL_RGB5_EXT, "GL_RGB5_EXT" );
	#endif
	#ifdef GL_RGB8_EXT
		swigIntConstant( GL_RGB8_EXT, "GL_RGB8_EXT" );
	#endif
	#ifdef GL_RGB10_EXT
		swigIntConstant( GL_RGB10_EXT, "GL_RGB10_EXT" );
	#endif
	#ifdef GL_RGB12_EXT
		swigIntConstant( GL_RGB12_EXT, "GL_RGB12_EXT" );
	#endif
	#ifdef GL_RGB16_EXT
		swigIntConstant( GL_RGB16_EXT, "GL_RGB16_EXT" );
	#endif
	#ifdef GL_RGBA2_EXT
		swigIntConstant( GL_RGBA2_EXT, "GL_RGBA2_EXT" );
	#endif
	#ifdef GL_RGBA4_EXT
		swigIntConstant( GL_RGBA4_EXT, "GL_RGBA4_EXT" );
	#endif
	#ifdef GL_RGB5_A1_EXT
		swigIntConstant( GL_RGB5_A1_EXT, "GL_RGB5_A1_EXT" );
	#endif
	#ifdef GL_RGBA8_EXT
		swigIntConstant( GL_RGBA8_EXT, "GL_RGBA8_EXT" );
	#endif
	#ifdef GL_RGB10_A2_EXT
		swigIntConstant( GL_RGB10_A2_EXT, "GL_RGB10_A2_EXT" );
	#endif
	#ifdef GL_RGBA12_EXT
		swigIntConstant( GL_RGBA12_EXT, "GL_RGBA12_EXT" );
	#endif
	#ifdef GL_RGBA16_EXT
		swigIntConstant( GL_RGBA16_EXT, "GL_RGBA16_EXT" );
	#endif
	#ifdef GL_TEXTURE_RED_SIZE_EXT
		swigIntConstant( GL_TEXTURE_RED_SIZE_EXT, "GL_TEXTURE_RED_SIZE_EXT" );
	#endif
	#ifdef GL_TEXTURE_GREEN_SIZE_EXT
		swigIntConstant( GL_TEXTURE_GREEN_SIZE_EXT, "GL_TEXTURE_GREEN_SIZE_EXT" );
	#endif
	#ifdef GL_TEXTURE_BLUE_SIZE_EXT
		swigIntConstant( GL_TEXTURE_BLUE_SIZE_EXT, "GL_TEXTURE_BLUE_SIZE_EXT" );
	#endif
	#ifdef GL_TEXTURE_ALPHA_SIZE_EXT
		swigIntConstant( GL_TEXTURE_ALPHA_SIZE_EXT, "GL_TEXTURE_ALPHA_SIZE_EXT" );
	#endif
	#ifdef GL_TEXTURE_LUMINANCE_SIZE_EXT
		swigIntConstant( GL_TEXTURE_LUMINANCE_SIZE_EXT, "GL_TEXTURE_LUMINANCE_SIZE_EXT" );
	#endif
	#ifdef GL_TEXTURE_INTENSITY_SIZE_EXT
		swigIntConstant( GL_TEXTURE_INTENSITY_SIZE_EXT, "GL_TEXTURE_INTENSITY_SIZE_EXT" );
	#endif
	#ifdef GL_REPLACE_EXT
		swigIntConstant( GL_REPLACE_EXT, "GL_REPLACE_EXT" );
	#endif
	#ifdef GL_PROXY_TEXTURE_1D_EXT
		swigIntConstant( GL_PROXY_TEXTURE_1D_EXT, "GL_PROXY_TEXTURE_1D_EXT" );
	#endif
	#ifdef GL_PROXY_TEXTURE_2D_EXT
		swigIntConstant( GL_PROXY_TEXTURE_2D_EXT, "GL_PROXY_TEXTURE_2D_EXT" );
	#endif
	#ifdef GL_TEXTURE_TOO_LARGE_EXT
		swigIntConstant( GL_TEXTURE_TOO_LARGE_EXT, "GL_TEXTURE_TOO_LARGE_EXT" );
	#endif
	#ifdef GL_EXT_texture3D
		swigIntConstant( GL_EXT_texture3D, "GL_EXT_texture3D" );
	#endif
	#ifdef GL_PACK_SKIP_IMAGES_EXT
		swigIntConstant( GL_PACK_SKIP_IMAGES_EXT, "GL_PACK_SKIP_IMAGES_EXT" );
	#endif
	#ifdef GL_PACK_IMAGE_HEIGHT_EXT
		swigIntConstant( GL_PACK_IMAGE_HEIGHT_EXT, "GL_PACK_IMAGE_HEIGHT_EXT" );
	#endif
	#ifdef GL_UNPACK_SKIP_IMAGES_EXT
		swigIntConstant( GL_UNPACK_SKIP_IMAGES_EXT, "GL_UNPACK_SKIP_IMAGES_EXT" );
	#endif
	#ifdef GL_UNPACK_IMAGE_HEIGHT_EXT
		swigIntConstant( GL_UNPACK_IMAGE_HEIGHT_EXT, "GL_UNPACK_IMAGE_HEIGHT_EXT" );
	#endif
	#ifdef GL_TEXTURE_3D_EXT
		swigIntConstant( GL_TEXTURE_3D_EXT, "GL_TEXTURE_3D_EXT" );
	#endif
	#ifdef GL_PROXY_TEXTURE_3D_EXT
		swigIntConstant( GL_PROXY_TEXTURE_3D_EXT, "GL_PROXY_TEXTURE_3D_EXT" );
	#endif
	#ifdef GL_TEXTURE_DEPTH_EXT
		swigIntConstant( GL_TEXTURE_DEPTH_EXT, "GL_TEXTURE_DEPTH_EXT" );
	#endif
	#ifdef GL_TEXTURE_WRAP_R_EXT
		swigIntConstant( GL_TEXTURE_WRAP_R_EXT, "GL_TEXTURE_WRAP_R_EXT" );
	#endif
	#ifdef GL_MAX_3D_TEXTURE_SIZE_EXT
		swigIntConstant( GL_MAX_3D_TEXTURE_SIZE_EXT, "GL_MAX_3D_TEXTURE_SIZE_EXT" );
	#endif
	#ifdef GL_EXT_texture_array
		swigIntConstant( GL_EXT_texture_array, "GL_EXT_texture_array" );
	#endif
	#ifdef GL_TEXTURE_1D_ARRAY_EXT
		swigIntConstant( GL_TEXTURE_1D_ARRAY_EXT, "GL_TEXTURE_1D_ARRAY_EXT" );
	#endif
	#ifdef GL_PROXY_TEXTURE_1D_ARRAY_EXT
		swigIntConstant( GL_PROXY_TEXTURE_1D_ARRAY_EXT, "GL_PROXY_TEXTURE_1D_ARRAY_EXT" );
	#endif
	#ifdef GL_TEXTURE_2D_ARRAY_EXT
		swigIntConstant( GL_TEXTURE_2D_ARRAY_EXT, "GL_TEXTURE_2D_ARRAY_EXT" );
	#endif
	#ifdef GL_PROXY_TEXTURE_2D_ARRAY_EXT
		swigIntConstant( GL_PROXY_TEXTURE_2D_ARRAY_EXT, "GL_PROXY_TEXTURE_2D_ARRAY_EXT" );
	#endif
	#ifdef GL_TEXTURE_BINDING_1D_ARRAY_EXT
		swigIntConstant( GL_TEXTURE_BINDING_1D_ARRAY_EXT, "GL_TEXTURE_BINDING_1D_ARRAY_EXT" );
	#endif
	#ifdef GL_TEXTURE_BINDING_2D_ARRAY_EXT
		swigIntConstant( GL_TEXTURE_BINDING_2D_ARRAY_EXT, "GL_TEXTURE_BINDING_2D_ARRAY_EXT" );
	#endif
	#ifdef GL_MAX_ARRAY_TEXTURE_LAYERS_EXT
		swigIntConstant( GL_MAX_ARRAY_TEXTURE_LAYERS_EXT, "GL_MAX_ARRAY_TEXTURE_LAYERS_EXT" );
	#endif
	#ifdef GL_COMPARE_REF_DEPTH_TO_TEXTURE_EXT
		swigIntConstant( GL_COMPARE_REF_DEPTH_TO_TEXTURE_EXT, "GL_COMPARE_REF_DEPTH_TO_TEXTURE_EXT" );
	#endif
	#ifdef GL_EXT_texture_buffer_object
		swigIntConstant( GL_EXT_texture_buffer_object, "GL_EXT_texture_buffer_object" );
	#endif
	#ifdef GL_TEXTURE_BUFFER_EXT
		swigIntConstant( GL_TEXTURE_BUFFER_EXT, "GL_TEXTURE_BUFFER_EXT" );
	#endif
	#ifdef GL_MAX_TEXTURE_BUFFER_SIZE_EXT
		swigIntConstant( GL_MAX_TEXTURE_BUFFER_SIZE_EXT, "GL_MAX_TEXTURE_BUFFER_SIZE_EXT" );
	#endif
	#ifdef GL_TEXTURE_BINDING_BUFFER_EXT
		swigIntConstant( GL_TEXTURE_BINDING_BUFFER_EXT, "GL_TEXTURE_BINDING_BUFFER_EXT" );
	#endif
	#ifdef GL_TEXTURE_BUFFER_DATA_STORE_BINDING_EXT
		swigIntConstant( GL_TEXTURE_BUFFER_DATA_STORE_BINDING_EXT, "GL_TEXTURE_BUFFER_DATA_STORE_BINDING_EXT" );
	#endif
	#ifdef GL_TEXTURE_BUFFER_FORMAT_EXT
		swigIntConstant( GL_TEXTURE_BUFFER_FORMAT_EXT, "GL_TEXTURE_BUFFER_FORMAT_EXT" );
	#endif
	#ifdef GL_EXT_texture_compression_latc
		swigIntConstant( GL_EXT_texture_compression_latc, "GL_EXT_texture_compression_latc" );
	#endif
	#ifdef GL_COMPRESSED_LUMINANCE_LATC1_EXT
		swigIntConstant( GL_COMPRESSED_LUMINANCE_LATC1_EXT, "GL_COMPRESSED_LUMINANCE_LATC1_EXT" );
	#endif
	#ifdef GL_COMPRESSED_SIGNED_LUMINANCE_LATC1_EXT
		swigIntConstant( GL_COMPRESSED_SIGNED_LUMINANCE_LATC1_EXT, "GL_COMPRESSED_SIGNED_LUMINANCE_LATC1_EXT" );
	#endif
	#ifdef GL_COMPRESSED_LUMINANCE_ALPHA_LATC2_EXT
		swigIntConstant( GL_COMPRESSED_LUMINANCE_ALPHA_LATC2_EXT, "GL_COMPRESSED_LUMINANCE_ALPHA_LATC2_EXT" );
	#endif
	#ifdef GL_COMPRESSED_SIGNED_LUMINANCE_ALPHA_LATC2_EXT
		swigIntConstant( GL_COMPRESSED_SIGNED_LUMINANCE_ALPHA_LATC2_EXT, "GL_COMPRESSED_SIGNED_LUMINANCE_ALPHA_LATC2_EXT" );
	#endif
	#ifdef GL_EXT_texture_compression_rgtc
		swigIntConstant( GL_EXT_texture_compression_rgtc, "GL_EXT_texture_compression_rgtc" );
	#endif
	#ifdef GL_COMPRESSED_RED_RGTC1_EXT
		swigIntConstant( GL_COMPRESSED_RED_RGTC1_EXT, "GL_COMPRESSED_RED_RGTC1_EXT" );
	#endif
	#ifdef GL_COMPRESSED_SIGNED_RED_RGTC1_EXT
		swigIntConstant( GL_COMPRESSED_SIGNED_RED_RGTC1_EXT, "GL_COMPRESSED_SIGNED_RED_RGTC1_EXT" );
	#endif
	#ifdef GL_COMPRESSED_RED_GREEN_RGTC2_EXT
		swigIntConstant( GL_COMPRESSED_RED_GREEN_RGTC2_EXT, "GL_COMPRESSED_RED_GREEN_RGTC2_EXT" );
	#endif
	#ifdef GL_COMPRESSED_SIGNED_RED_GREEN_RGTC2_EXT
		swigIntConstant( GL_COMPRESSED_SIGNED_RED_GREEN_RGTC2_EXT, "GL_COMPRESSED_SIGNED_RED_GREEN_RGTC2_EXT" );
	#endif
	#ifdef GL_EXT_texture_compression_s3tc
		swigIntConstant( GL_EXT_texture_compression_s3tc, "GL_EXT_texture_compression_s3tc" );
	#endif
	#ifdef GL_COMPRESSED_RGB_S3TC_DXT1_EXT
		swigIntConstant( GL_COMPRESSED_RGB_S3TC_DXT1_EXT, "GL_COMPRESSED_RGB_S3TC_DXT1_EXT" );
	#endif
	#ifdef GL_COMPRESSED_RGBA_S3TC_DXT1_EXT
		swigIntConstant( GL_COMPRESSED_RGBA_S3TC_DXT1_EXT, "GL_COMPRESSED_RGBA_S3TC_DXT1_EXT" );
	#endif
	#ifdef GL_COMPRESSED_RGBA_S3TC_DXT3_EXT
		swigIntConstant( GL_COMPRESSED_RGBA_S3TC_DXT3_EXT, "GL_COMPRESSED_RGBA_S3TC_DXT3_EXT" );
	#endif
	#ifdef GL_COMPRESSED_RGBA_S3TC_DXT5_EXT
		swigIntConstant( GL_COMPRESSED_RGBA_S3TC_DXT5_EXT, "GL_COMPRESSED_RGBA_S3TC_DXT5_EXT" );
	#endif
	#ifdef GL_EXT_texture_cube_map
		swigIntConstant( GL_EXT_texture_cube_map, "GL_EXT_texture_cube_map" );
	#endif
	#ifdef GL_NORMAL_MAP_EXT
		swigIntConstant( GL_NORMAL_MAP_EXT, "GL_NORMAL_MAP_EXT" );
	#endif
	#ifdef GL_REFLECTION_MAP_EXT
		swigIntConstant( GL_REFLECTION_MAP_EXT, "GL_REFLECTION_MAP_EXT" );
	#endif
	#ifdef GL_TEXTURE_CUBE_MAP_EXT
		swigIntConstant( GL_TEXTURE_CUBE_MAP_EXT, "GL_TEXTURE_CUBE_MAP_EXT" );
	#endif
	#ifdef GL_TEXTURE_BINDING_CUBE_MAP_EXT
		swigIntConstant( GL_TEXTURE_BINDING_CUBE_MAP_EXT, "GL_TEXTURE_BINDING_CUBE_MAP_EXT" );
	#endif
	#ifdef GL_TEXTURE_CUBE_MAP_POSITIVE_X_EXT
		swigIntConstant( GL_TEXTURE_CUBE_MAP_POSITIVE_X_EXT, "GL_TEXTURE_CUBE_MAP_POSITIVE_X_EXT" );
	#endif
	#ifdef GL_TEXTURE_CUBE_MAP_NEGATIVE_X_EXT
		swigIntConstant( GL_TEXTURE_CUBE_MAP_NEGATIVE_X_EXT, "GL_TEXTURE_CUBE_MAP_NEGATIVE_X_EXT" );
	#endif
	#ifdef GL_TEXTURE_CUBE_MAP_POSITIVE_Y_EXT
		swigIntConstant( GL_TEXTURE_CUBE_MAP_POSITIVE_Y_EXT, "GL_TEXTURE_CUBE_MAP_POSITIVE_Y_EXT" );
	#endif
	#ifdef GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_EXT
		swigIntConstant( GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_EXT, "GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_EXT" );
	#endif
	#ifdef GL_TEXTURE_CUBE_MAP_POSITIVE_Z_EXT
		swigIntConstant( GL_TEXTURE_CUBE_MAP_POSITIVE_Z_EXT, "GL_TEXTURE_CUBE_MAP_POSITIVE_Z_EXT" );
	#endif
	#ifdef GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_EXT
		swigIntConstant( GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_EXT, "GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_EXT" );
	#endif
	#ifdef GL_PROXY_TEXTURE_CUBE_MAP_EXT
		swigIntConstant( GL_PROXY_TEXTURE_CUBE_MAP_EXT, "GL_PROXY_TEXTURE_CUBE_MAP_EXT" );
	#endif
	#ifdef GL_MAX_CUBE_MAP_TEXTURE_SIZE_EXT
		swigIntConstant( GL_MAX_CUBE_MAP_TEXTURE_SIZE_EXT, "GL_MAX_CUBE_MAP_TEXTURE_SIZE_EXT" );
	#endif
	#ifdef GL_EXT_texture_env_add
		swigIntConstant( GL_EXT_texture_env_add, "GL_EXT_texture_env_add" );
	#endif
	#ifdef GL_EXT_texture_env_combine
		swigIntConstant( GL_EXT_texture_env_combine, "GL_EXT_texture_env_combine" );
	#endif
	#ifdef GL_COMBINE_EXT
		swigIntConstant( GL_COMBINE_EXT, "GL_COMBINE_EXT" );
	#endif
	#ifdef GL_COMBINE_RGB_EXT
		swigIntConstant( GL_COMBINE_RGB_EXT, "GL_COMBINE_RGB_EXT" );
	#endif
	#ifdef GL_COMBINE_ALPHA_EXT
		swigIntConstant( GL_COMBINE_ALPHA_EXT, "GL_COMBINE_ALPHA_EXT" );
	#endif
	#ifdef GL_RGB_SCALE_EXT
		swigIntConstant( GL_RGB_SCALE_EXT, "GL_RGB_SCALE_EXT" );
	#endif
	#ifdef GL_ADD_SIGNED_EXT
		swigIntConstant( GL_ADD_SIGNED_EXT, "GL_ADD_SIGNED_EXT" );
	#endif
	#ifdef GL_INTERPOLATE_EXT
		swigIntConstant( GL_INTERPOLATE_EXT, "GL_INTERPOLATE_EXT" );
	#endif
	#ifdef GL_CONSTANT_EXT
		swigIntConstant( GL_CONSTANT_EXT, "GL_CONSTANT_EXT" );
	#endif
	#ifdef GL_PRIMARY_COLOR_EXT
		swigIntConstant( GL_PRIMARY_COLOR_EXT, "GL_PRIMARY_COLOR_EXT" );
	#endif
	#ifdef GL_PREVIOUS_EXT
		swigIntConstant( GL_PREVIOUS_EXT, "GL_PREVIOUS_EXT" );
	#endif
	#ifdef GL_SOURCE0_RGB_EXT
		swigIntConstant( GL_SOURCE0_RGB_EXT, "GL_SOURCE0_RGB_EXT" );
	#endif
	#ifdef GL_SOURCE1_RGB_EXT
		swigIntConstant( GL_SOURCE1_RGB_EXT, "GL_SOURCE1_RGB_EXT" );
	#endif
	#ifdef GL_SOURCE2_RGB_EXT
		swigIntConstant( GL_SOURCE2_RGB_EXT, "GL_SOURCE2_RGB_EXT" );
	#endif
	#ifdef GL_SOURCE0_ALPHA_EXT
		swigIntConstant( GL_SOURCE0_ALPHA_EXT, "GL_SOURCE0_ALPHA_EXT" );
	#endif
	#ifdef GL_SOURCE1_ALPHA_EXT
		swigIntConstant( GL_SOURCE1_ALPHA_EXT, "GL_SOURCE1_ALPHA_EXT" );
	#endif
	#ifdef GL_SOURCE2_ALPHA_EXT
		swigIntConstant( GL_SOURCE2_ALPHA_EXT, "GL_SOURCE2_ALPHA_EXT" );
	#endif
	#ifdef GL_OPERAND0_RGB_EXT
		swigIntConstant( GL_OPERAND0_RGB_EXT, "GL_OPERAND0_RGB_EXT" );
	#endif
	#ifdef GL_OPERAND1_RGB_EXT
		swigIntConstant( GL_OPERAND1_RGB_EXT, "GL_OPERAND1_RGB_EXT" );
	#endif
	#ifdef GL_OPERAND2_RGB_EXT
		swigIntConstant( GL_OPERAND2_RGB_EXT, "GL_OPERAND2_RGB_EXT" );
	#endif
	#ifdef GL_OPERAND0_ALPHA_EXT
		swigIntConstant( GL_OPERAND0_ALPHA_EXT, "GL_OPERAND0_ALPHA_EXT" );
	#endif
	#ifdef GL_OPERAND1_ALPHA_EXT
		swigIntConstant( GL_OPERAND1_ALPHA_EXT, "GL_OPERAND1_ALPHA_EXT" );
	#endif
	#ifdef GL_OPERAND2_ALPHA_EXT
		swigIntConstant( GL_OPERAND2_ALPHA_EXT, "GL_OPERAND2_ALPHA_EXT" );
	#endif
	#ifdef GL_EXT_texture_env_dot3
		swigIntConstant( GL_EXT_texture_env_dot3, "GL_EXT_texture_env_dot3" );
	#endif
	#ifdef GL_DOT3_RGB_EXT
		swigIntConstant( GL_DOT3_RGB_EXT, "GL_DOT3_RGB_EXT" );
	#endif
	#ifdef GL_DOT3_RGBA_EXT
		swigIntConstant( GL_DOT3_RGBA_EXT, "GL_DOT3_RGBA_EXT" );
	#endif
	#ifdef GL_EXT_texture_filter_anisotropic
		swigIntConstant( GL_EXT_texture_filter_anisotropic, "GL_EXT_texture_filter_anisotropic" );
	#endif
	#ifdef GL_TEXTURE_MAX_ANISOTROPY_EXT
		swigIntConstant( GL_TEXTURE_MAX_ANISOTROPY_EXT, "GL_TEXTURE_MAX_ANISOTROPY_EXT" );
	#endif
	#ifdef GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT
		swigIntConstant( GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT, "GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT" );
	#endif
	#ifdef GL_EXT_texture_filter_minmax
		swigIntConstant( GL_EXT_texture_filter_minmax, "GL_EXT_texture_filter_minmax" );
	#endif
	#ifdef GL_TEXTURE_REDUCTION_MODE_EXT
		swigIntConstant( GL_TEXTURE_REDUCTION_MODE_EXT, "GL_TEXTURE_REDUCTION_MODE_EXT" );
	#endif
	#ifdef GL_WEIGHTED_AVERAGE_EXT
		swigIntConstant( GL_WEIGHTED_AVERAGE_EXT, "GL_WEIGHTED_AVERAGE_EXT" );
	#endif
	#ifdef GL_EXT_texture_integer
		swigIntConstant( GL_EXT_texture_integer, "GL_EXT_texture_integer" );
	#endif
	#ifdef GL_RGBA32UI_EXT
		swigIntConstant( GL_RGBA32UI_EXT, "GL_RGBA32UI_EXT" );
	#endif
	#ifdef GL_RGB32UI_EXT
		swigIntConstant( GL_RGB32UI_EXT, "GL_RGB32UI_EXT" );
	#endif
	#ifdef GL_ALPHA32UI_EXT
		swigIntConstant( GL_ALPHA32UI_EXT, "GL_ALPHA32UI_EXT" );
	#endif
	#ifdef GL_INTENSITY32UI_EXT
		swigIntConstant( GL_INTENSITY32UI_EXT, "GL_INTENSITY32UI_EXT" );
	#endif
	#ifdef GL_LUMINANCE32UI_EXT
		swigIntConstant( GL_LUMINANCE32UI_EXT, "GL_LUMINANCE32UI_EXT" );
	#endif
	#ifdef GL_LUMINANCE_ALPHA32UI_EXT
		swigIntConstant( GL_LUMINANCE_ALPHA32UI_EXT, "GL_LUMINANCE_ALPHA32UI_EXT" );
	#endif
	#ifdef GL_RGBA16UI_EXT
		swigIntConstant( GL_RGBA16UI_EXT, "GL_RGBA16UI_EXT" );
	#endif
	#ifdef GL_RGB16UI_EXT
		swigIntConstant( GL_RGB16UI_EXT, "GL_RGB16UI_EXT" );
	#endif
	#ifdef GL_ALPHA16UI_EXT
		swigIntConstant( GL_ALPHA16UI_EXT, "GL_ALPHA16UI_EXT" );
	#endif
	#ifdef GL_INTENSITY16UI_EXT
		swigIntConstant( GL_INTENSITY16UI_EXT, "GL_INTENSITY16UI_EXT" );
	#endif
	#ifdef GL_LUMINANCE16UI_EXT
		swigIntConstant( GL_LUMINANCE16UI_EXT, "GL_LUMINANCE16UI_EXT" );
	#endif
	#ifdef GL_LUMINANCE_ALPHA16UI_EXT
		swigIntConstant( GL_LUMINANCE_ALPHA16UI_EXT, "GL_LUMINANCE_ALPHA16UI_EXT" );
	#endif
	#ifdef GL_RGBA8UI_EXT
		swigIntConstant( GL_RGBA8UI_EXT, "GL_RGBA8UI_EXT" );
	#endif
	#ifdef GL_RGB8UI_EXT
		swigIntConstant( GL_RGB8UI_EXT, "GL_RGB8UI_EXT" );
	#endif
	#ifdef GL_ALPHA8UI_EXT
		swigIntConstant( GL_ALPHA8UI_EXT, "GL_ALPHA8UI_EXT" );
	#endif
	#ifdef GL_INTENSITY8UI_EXT
		swigIntConstant( GL_INTENSITY8UI_EXT, "GL_INTENSITY8UI_EXT" );
	#endif
	#ifdef GL_LUMINANCE8UI_EXT
		swigIntConstant( GL_LUMINANCE8UI_EXT, "GL_LUMINANCE8UI_EXT" );
	#endif
	#ifdef GL_LUMINANCE_ALPHA8UI_EXT
		swigIntConstant( GL_LUMINANCE_ALPHA8UI_EXT, "GL_LUMINANCE_ALPHA8UI_EXT" );
	#endif
	#ifdef GL_RGBA32I_EXT
		swigIntConstant( GL_RGBA32I_EXT, "GL_RGBA32I_EXT" );
	#endif
	#ifdef GL_RGB32I_EXT
		swigIntConstant( GL_RGB32I_EXT, "GL_RGB32I_EXT" );
	#endif
	#ifdef GL_ALPHA32I_EXT
		swigIntConstant( GL_ALPHA32I_EXT, "GL_ALPHA32I_EXT" );
	#endif
	#ifdef GL_INTENSITY32I_EXT
		swigIntConstant( GL_INTENSITY32I_EXT, "GL_INTENSITY32I_EXT" );
	#endif
	#ifdef GL_LUMINANCE32I_EXT
		swigIntConstant( GL_LUMINANCE32I_EXT, "GL_LUMINANCE32I_EXT" );
	#endif
	#ifdef GL_LUMINANCE_ALPHA32I_EXT
		swigIntConstant( GL_LUMINANCE_ALPHA32I_EXT, "GL_LUMINANCE_ALPHA32I_EXT" );
	#endif
	#ifdef GL_RGBA16I_EXT
		swigIntConstant( GL_RGBA16I_EXT, "GL_RGBA16I_EXT" );
	#endif
	#ifdef GL_RGB16I_EXT
		swigIntConstant( GL_RGB16I_EXT, "GL_RGB16I_EXT" );
	#endif
	#ifdef GL_ALPHA16I_EXT
		swigIntConstant( GL_ALPHA16I_EXT, "GL_ALPHA16I_EXT" );
	#endif
	#ifdef GL_INTENSITY16I_EXT
		swigIntConstant( GL_INTENSITY16I_EXT, "GL_INTENSITY16I_EXT" );
	#endif
	#ifdef GL_LUMINANCE16I_EXT
		swigIntConstant( GL_LUMINANCE16I_EXT, "GL_LUMINANCE16I_EXT" );
	#endif
	#ifdef GL_LUMINANCE_ALPHA16I_EXT
		swigIntConstant( GL_LUMINANCE_ALPHA16I_EXT, "GL_LUMINANCE_ALPHA16I_EXT" );
	#endif
	#ifdef GL_RGBA8I_EXT
		swigIntConstant( GL_RGBA8I_EXT, "GL_RGBA8I_EXT" );
	#endif
	#ifdef GL_RGB8I_EXT
		swigIntConstant( GL_RGB8I_EXT, "GL_RGB8I_EXT" );
	#endif
	#ifdef GL_ALPHA8I_EXT
		swigIntConstant( GL_ALPHA8I_EXT, "GL_ALPHA8I_EXT" );
	#endif
	#ifdef GL_INTENSITY8I_EXT
		swigIntConstant( GL_INTENSITY8I_EXT, "GL_INTENSITY8I_EXT" );
	#endif
	#ifdef GL_LUMINANCE8I_EXT
		swigIntConstant( GL_LUMINANCE8I_EXT, "GL_LUMINANCE8I_EXT" );
	#endif
	#ifdef GL_LUMINANCE_ALPHA8I_EXT
		swigIntConstant( GL_LUMINANCE_ALPHA8I_EXT, "GL_LUMINANCE_ALPHA8I_EXT" );
	#endif
	#ifdef GL_RED_INTEGER_EXT
		swigIntConstant( GL_RED_INTEGER_EXT, "GL_RED_INTEGER_EXT" );
	#endif
	#ifdef GL_GREEN_INTEGER_EXT
		swigIntConstant( GL_GREEN_INTEGER_EXT, "GL_GREEN_INTEGER_EXT" );
	#endif
	#ifdef GL_BLUE_INTEGER_EXT
		swigIntConstant( GL_BLUE_INTEGER_EXT, "GL_BLUE_INTEGER_EXT" );
	#endif
	#ifdef GL_ALPHA_INTEGER_EXT
		swigIntConstant( GL_ALPHA_INTEGER_EXT, "GL_ALPHA_INTEGER_EXT" );
	#endif
	#ifdef GL_RGB_INTEGER_EXT
		swigIntConstant( GL_RGB_INTEGER_EXT, "GL_RGB_INTEGER_EXT" );
	#endif
	#ifdef GL_RGBA_INTEGER_EXT
		swigIntConstant( GL_RGBA_INTEGER_EXT, "GL_RGBA_INTEGER_EXT" );
	#endif
	#ifdef GL_BGR_INTEGER_EXT
		swigIntConstant( GL_BGR_INTEGER_EXT, "GL_BGR_INTEGER_EXT" );
	#endif
	#ifdef GL_BGRA_INTEGER_EXT
		swigIntConstant( GL_BGRA_INTEGER_EXT, "GL_BGRA_INTEGER_EXT" );
	#endif
	#ifdef GL_LUMINANCE_INTEGER_EXT
		swigIntConstant( GL_LUMINANCE_INTEGER_EXT, "GL_LUMINANCE_INTEGER_EXT" );
	#endif
	#ifdef GL_LUMINANCE_ALPHA_INTEGER_EXT
		swigIntConstant( GL_LUMINANCE_ALPHA_INTEGER_EXT, "GL_LUMINANCE_ALPHA_INTEGER_EXT" );
	#endif
	#ifdef GL_RGBA_INTEGER_MODE_EXT
		swigIntConstant( GL_RGBA_INTEGER_MODE_EXT, "GL_RGBA_INTEGER_MODE_EXT" );
	#endif
	#ifdef GL_EXT_texture_lod_bias
		swigIntConstant( GL_EXT_texture_lod_bias, "GL_EXT_texture_lod_bias" );
	#endif
	#ifdef GL_MAX_TEXTURE_LOD_BIAS_EXT
		swigIntConstant( GL_MAX_TEXTURE_LOD_BIAS_EXT, "GL_MAX_TEXTURE_LOD_BIAS_EXT" );
	#endif
	#ifdef GL_TEXTURE_FILTER_CONTROL_EXT
		swigIntConstant( GL_TEXTURE_FILTER_CONTROL_EXT, "GL_TEXTURE_FILTER_CONTROL_EXT" );
	#endif
	#ifdef GL_TEXTURE_LOD_BIAS_EXT
		swigIntConstant( GL_TEXTURE_LOD_BIAS_EXT, "GL_TEXTURE_LOD_BIAS_EXT" );
	#endif
	#ifdef GL_EXT_texture_mirror_clamp
		swigIntConstant( GL_EXT_texture_mirror_clamp, "GL_EXT_texture_mirror_clamp" );
	#endif
	#ifdef GL_MIRROR_CLAMP_EXT
		swigIntConstant( GL_MIRROR_CLAMP_EXT, "GL_MIRROR_CLAMP_EXT" );
	#endif
	#ifdef GL_MIRROR_CLAMP_TO_EDGE_EXT
		swigIntConstant( GL_MIRROR_CLAMP_TO_EDGE_EXT, "GL_MIRROR_CLAMP_TO_EDGE_EXT" );
	#endif
	#ifdef GL_MIRROR_CLAMP_TO_BORDER_EXT
		swigIntConstant( GL_MIRROR_CLAMP_TO_BORDER_EXT, "GL_MIRROR_CLAMP_TO_BORDER_EXT" );
	#endif
	#ifdef GL_EXT_texture_object
		swigIntConstant( GL_EXT_texture_object, "GL_EXT_texture_object" );
	#endif
	#ifdef GL_TEXTURE_PRIORITY_EXT
		swigIntConstant( GL_TEXTURE_PRIORITY_EXT, "GL_TEXTURE_PRIORITY_EXT" );
	#endif
	#ifdef GL_TEXTURE_RESIDENT_EXT
		swigIntConstant( GL_TEXTURE_RESIDENT_EXT, "GL_TEXTURE_RESIDENT_EXT" );
	#endif
	#ifdef GL_TEXTURE_1D_BINDING_EXT
		swigIntConstant( GL_TEXTURE_1D_BINDING_EXT, "GL_TEXTURE_1D_BINDING_EXT" );
	#endif
	#ifdef GL_TEXTURE_2D_BINDING_EXT
		swigIntConstant( GL_TEXTURE_2D_BINDING_EXT, "GL_TEXTURE_2D_BINDING_EXT" );
	#endif
	#ifdef GL_TEXTURE_3D_BINDING_EXT
		swigIntConstant( GL_TEXTURE_3D_BINDING_EXT, "GL_TEXTURE_3D_BINDING_EXT" );
	#endif
	#ifdef GL_EXT_texture_perturb_normal
		swigIntConstant( GL_EXT_texture_perturb_normal, "GL_EXT_texture_perturb_normal" );
	#endif
	#ifdef GL_PERTURB_EXT
		swigIntConstant( GL_PERTURB_EXT, "GL_PERTURB_EXT" );
	#endif
	#ifdef GL_TEXTURE_NORMAL_EXT
		swigIntConstant( GL_TEXTURE_NORMAL_EXT, "GL_TEXTURE_NORMAL_EXT" );
	#endif
	#ifdef GL_EXT_texture_sRGB
		swigIntConstant( GL_EXT_texture_sRGB, "GL_EXT_texture_sRGB" );
	#endif
	#ifdef GL_SRGB_EXT
		swigIntConstant( GL_SRGB_EXT, "GL_SRGB_EXT" );
	#endif
	#ifdef GL_SRGB8_EXT
		swigIntConstant( GL_SRGB8_EXT, "GL_SRGB8_EXT" );
	#endif
	#ifdef GL_SRGB_ALPHA_EXT
		swigIntConstant( GL_SRGB_ALPHA_EXT, "GL_SRGB_ALPHA_EXT" );
	#endif
	#ifdef GL_SRGB8_ALPHA8_EXT
		swigIntConstant( GL_SRGB8_ALPHA8_EXT, "GL_SRGB8_ALPHA8_EXT" );
	#endif
	#ifdef GL_SLUMINANCE_ALPHA_EXT
		swigIntConstant( GL_SLUMINANCE_ALPHA_EXT, "GL_SLUMINANCE_ALPHA_EXT" );
	#endif
	#ifdef GL_SLUMINANCE8_ALPHA8_EXT
		swigIntConstant( GL_SLUMINANCE8_ALPHA8_EXT, "GL_SLUMINANCE8_ALPHA8_EXT" );
	#endif
	#ifdef GL_SLUMINANCE_EXT
		swigIntConstant( GL_SLUMINANCE_EXT, "GL_SLUMINANCE_EXT" );
	#endif
	#ifdef GL_SLUMINANCE8_EXT
		swigIntConstant( GL_SLUMINANCE8_EXT, "GL_SLUMINANCE8_EXT" );
	#endif
	#ifdef GL_COMPRESSED_SRGB_EXT
		swigIntConstant( GL_COMPRESSED_SRGB_EXT, "GL_COMPRESSED_SRGB_EXT" );
	#endif
	#ifdef GL_COMPRESSED_SRGB_ALPHA_EXT
		swigIntConstant( GL_COMPRESSED_SRGB_ALPHA_EXT, "GL_COMPRESSED_SRGB_ALPHA_EXT" );
	#endif
	#ifdef GL_COMPRESSED_SLUMINANCE_EXT
		swigIntConstant( GL_COMPRESSED_SLUMINANCE_EXT, "GL_COMPRESSED_SLUMINANCE_EXT" );
	#endif
	#ifdef GL_COMPRESSED_SLUMINANCE_ALPHA_EXT
		swigIntConstant( GL_COMPRESSED_SLUMINANCE_ALPHA_EXT, "GL_COMPRESSED_SLUMINANCE_ALPHA_EXT" );
	#endif
	#ifdef GL_COMPRESSED_SRGB_S3TC_DXT1_EXT
		swigIntConstant( GL_COMPRESSED_SRGB_S3TC_DXT1_EXT, "GL_COMPRESSED_SRGB_S3TC_DXT1_EXT" );
	#endif
	#ifdef GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT
		swigIntConstant( GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT, "GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT" );
	#endif
	#ifdef GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT
		swigIntConstant( GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT, "GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT" );
	#endif
	#ifdef GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT
		swigIntConstant( GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT, "GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT" );
	#endif
	#ifdef GL_EXT_texture_sRGB_R8
		swigIntConstant( GL_EXT_texture_sRGB_R8, "GL_EXT_texture_sRGB_R8" );
	#endif
	#ifdef GL_SR8_EXT
		swigIntConstant( GL_SR8_EXT, "GL_SR8_EXT" );
	#endif
	#ifdef GL_EXT_texture_sRGB_RG8
		swigIntConstant( GL_EXT_texture_sRGB_RG8, "GL_EXT_texture_sRGB_RG8" );
	#endif
	#ifdef GL_SRG8_EXT
		swigIntConstant( GL_SRG8_EXT, "GL_SRG8_EXT" );
	#endif
	#ifdef GL_EXT_texture_sRGB_decode
		swigIntConstant( GL_EXT_texture_sRGB_decode, "GL_EXT_texture_sRGB_decode" );
	#endif
	#ifdef GL_TEXTURE_SRGB_DECODE_EXT
		swigIntConstant( GL_TEXTURE_SRGB_DECODE_EXT, "GL_TEXTURE_SRGB_DECODE_EXT" );
	#endif
	#ifdef GL_DECODE_EXT
		swigIntConstant( GL_DECODE_EXT, "GL_DECODE_EXT" );
	#endif
	#ifdef GL_SKIP_DECODE_EXT
		swigIntConstant( GL_SKIP_DECODE_EXT, "GL_SKIP_DECODE_EXT" );
	#endif
	#ifdef GL_EXT_texture_shadow_lod
		swigIntConstant( GL_EXT_texture_shadow_lod, "GL_EXT_texture_shadow_lod" );
	#endif
	#ifdef GL_EXT_texture_shared_exponent
		swigIntConstant( GL_EXT_texture_shared_exponent, "GL_EXT_texture_shared_exponent" );
	#endif
	#ifdef GL_RGB9_E5_EXT
		swigIntConstant( GL_RGB9_E5_EXT, "GL_RGB9_E5_EXT" );
	#endif
	#ifdef GL_UNSIGNED_INT_5_9_9_9_REV_EXT
		swigIntConstant( GL_UNSIGNED_INT_5_9_9_9_REV_EXT, "GL_UNSIGNED_INT_5_9_9_9_REV_EXT" );
	#endif
	#ifdef GL_TEXTURE_SHARED_SIZE_EXT
		swigIntConstant( GL_TEXTURE_SHARED_SIZE_EXT, "GL_TEXTURE_SHARED_SIZE_EXT" );
	#endif
	#ifdef GL_EXT_texture_snorm
		swigIntConstant( GL_EXT_texture_snorm, "GL_EXT_texture_snorm" );
	#endif
	#ifdef GL_ALPHA_SNORM
		swigIntConstant( GL_ALPHA_SNORM, "GL_ALPHA_SNORM" );
	#endif
	#ifdef GL_LUMINANCE_SNORM
		swigIntConstant( GL_LUMINANCE_SNORM, "GL_LUMINANCE_SNORM" );
	#endif
	#ifdef GL_LUMINANCE_ALPHA_SNORM
		swigIntConstant( GL_LUMINANCE_ALPHA_SNORM, "GL_LUMINANCE_ALPHA_SNORM" );
	#endif
	#ifdef GL_INTENSITY_SNORM
		swigIntConstant( GL_INTENSITY_SNORM, "GL_INTENSITY_SNORM" );
	#endif
	#ifdef GL_ALPHA8_SNORM
		swigIntConstant( GL_ALPHA8_SNORM, "GL_ALPHA8_SNORM" );
	#endif
	#ifdef GL_LUMINANCE8_SNORM
		swigIntConstant( GL_LUMINANCE8_SNORM, "GL_LUMINANCE8_SNORM" );
	#endif
	#ifdef GL_LUMINANCE8_ALPHA8_SNORM
		swigIntConstant( GL_LUMINANCE8_ALPHA8_SNORM, "GL_LUMINANCE8_ALPHA8_SNORM" );
	#endif
	#ifdef GL_INTENSITY8_SNORM
		swigIntConstant( GL_INTENSITY8_SNORM, "GL_INTENSITY8_SNORM" );
	#endif
	#ifdef GL_ALPHA16_SNORM
		swigIntConstant( GL_ALPHA16_SNORM, "GL_ALPHA16_SNORM" );
	#endif
	#ifdef GL_LUMINANCE16_SNORM
		swigIntConstant( GL_LUMINANCE16_SNORM, "GL_LUMINANCE16_SNORM" );
	#endif
	#ifdef GL_LUMINANCE16_ALPHA16_SNORM
		swigIntConstant( GL_LUMINANCE16_ALPHA16_SNORM, "GL_LUMINANCE16_ALPHA16_SNORM" );
	#endif
	#ifdef GL_INTENSITY16_SNORM
		swigIntConstant( GL_INTENSITY16_SNORM, "GL_INTENSITY16_SNORM" );
	#endif
	#ifdef GL_RED_SNORM
		swigIntConstant( GL_RED_SNORM, "GL_RED_SNORM" );
	#endif
	#ifdef GL_RG_SNORM
		swigIntConstant( GL_RG_SNORM, "GL_RG_SNORM" );
	#endif
	#ifdef GL_RGB_SNORM
		swigIntConstant( GL_RGB_SNORM, "GL_RGB_SNORM" );
	#endif
	#ifdef GL_RGBA_SNORM
		swigIntConstant( GL_RGBA_SNORM, "GL_RGBA_SNORM" );
	#endif
	#ifdef GL_EXT_texture_storage
		swigIntConstant( GL_EXT_texture_storage, "GL_EXT_texture_storage" );
	#endif
	#ifdef GL_TEXTURE_IMMUTABLE_FORMAT_EXT
		swigIntConstant( GL_TEXTURE_IMMUTABLE_FORMAT_EXT, "GL_TEXTURE_IMMUTABLE_FORMAT_EXT" );
	#endif
	#ifdef GL_RGBA32F_EXT
		swigIntConstant( GL_RGBA32F_EXT, "GL_RGBA32F_EXT" );
	#endif
	#ifdef GL_RGB32F_EXT
		swigIntConstant( GL_RGB32F_EXT, "GL_RGB32F_EXT" );
	#endif
	#ifdef GL_ALPHA32F_EXT
		swigIntConstant( GL_ALPHA32F_EXT, "GL_ALPHA32F_EXT" );
	#endif
	#ifdef GL_LUMINANCE32F_EXT
		swigIntConstant( GL_LUMINANCE32F_EXT, "GL_LUMINANCE32F_EXT" );
	#endif
	#ifdef GL_LUMINANCE_ALPHA32F_EXT
		swigIntConstant( GL_LUMINANCE_ALPHA32F_EXT, "GL_LUMINANCE_ALPHA32F_EXT" );
	#endif
	#ifdef GL_RGBA16F_EXT
		swigIntConstant( GL_RGBA16F_EXT, "GL_RGBA16F_EXT" );
	#endif
	#ifdef GL_RGB16F_EXT
		swigIntConstant( GL_RGB16F_EXT, "GL_RGB16F_EXT" );
	#endif
	#ifdef GL_ALPHA16F_EXT
		swigIntConstant( GL_ALPHA16F_EXT, "GL_ALPHA16F_EXT" );
	#endif
	#ifdef GL_LUMINANCE16F_EXT
		swigIntConstant( GL_LUMINANCE16F_EXT, "GL_LUMINANCE16F_EXT" );
	#endif
	#ifdef GL_LUMINANCE_ALPHA16F_EXT
		swigIntConstant( GL_LUMINANCE_ALPHA16F_EXT, "GL_LUMINANCE_ALPHA16F_EXT" );
	#endif
	#ifdef GL_BGRA8_EXT
		swigIntConstant( GL_BGRA8_EXT, "GL_BGRA8_EXT" );
	#endif
	#ifdef GL_R8_EXT
		swigIntConstant( GL_R8_EXT, "GL_R8_EXT" );
	#endif
	#ifdef GL_RG8_EXT
		swigIntConstant( GL_RG8_EXT, "GL_RG8_EXT" );
	#endif
	#ifdef GL_R32F_EXT
		swigIntConstant( GL_R32F_EXT, "GL_R32F_EXT" );
	#endif
	#ifdef GL_RG32F_EXT
		swigIntConstant( GL_RG32F_EXT, "GL_RG32F_EXT" );
	#endif
	#ifdef GL_R16F_EXT
		swigIntConstant( GL_R16F_EXT, "GL_R16F_EXT" );
	#endif
	#ifdef GL_RG16F_EXT
		swigIntConstant( GL_RG16F_EXT, "GL_RG16F_EXT" );
	#endif
	#ifdef GL_EXT_texture_swizzle
		swigIntConstant( GL_EXT_texture_swizzle, "GL_EXT_texture_swizzle" );
	#endif
	#ifdef GL_TEXTURE_SWIZZLE_R_EXT
		swigIntConstant( GL_TEXTURE_SWIZZLE_R_EXT, "GL_TEXTURE_SWIZZLE_R_EXT" );
	#endif
	#ifdef GL_TEXTURE_SWIZZLE_G_EXT
		swigIntConstant( GL_TEXTURE_SWIZZLE_G_EXT, "GL_TEXTURE_SWIZZLE_G_EXT" );
	#endif
	#ifdef GL_TEXTURE_SWIZZLE_B_EXT
		swigIntConstant( GL_TEXTURE_SWIZZLE_B_EXT, "GL_TEXTURE_SWIZZLE_B_EXT" );
	#endif
	#ifdef GL_TEXTURE_SWIZZLE_A_EXT
		swigIntConstant( GL_TEXTURE_SWIZZLE_A_EXT, "GL_TEXTURE_SWIZZLE_A_EXT" );
	#endif
	#ifdef GL_TEXTURE_SWIZZLE_RGBA_EXT
		swigIntConstant( GL_TEXTURE_SWIZZLE_RGBA_EXT, "GL_TEXTURE_SWIZZLE_RGBA_EXT" );
	#endif
	#ifdef GL_EXT_timer_query
		swigIntConstant( GL_EXT_timer_query, "GL_EXT_timer_query" );
	#endif
	#ifdef GL_TIME_ELAPSED_EXT
		swigIntConstant( GL_TIME_ELAPSED_EXT, "GL_TIME_ELAPSED_EXT" );
	#endif
	#ifdef GL_EXT_transform_feedback
		swigIntConstant( GL_EXT_transform_feedback, "GL_EXT_transform_feedback" );
	#endif
	#ifdef GL_TRANSFORM_FEEDBACK_BUFFER_EXT
		swigIntConstant( GL_TRANSFORM_FEEDBACK_BUFFER_EXT, "GL_TRANSFORM_FEEDBACK_BUFFER_EXT" );
	#endif
	#ifdef GL_TRANSFORM_FEEDBACK_BUFFER_START_EXT
		swigIntConstant( GL_TRANSFORM_FEEDBACK_BUFFER_START_EXT, "GL_TRANSFORM_FEEDBACK_BUFFER_START_EXT" );
	#endif
	#ifdef GL_TRANSFORM_FEEDBACK_BUFFER_SIZE_EXT
		swigIntConstant( GL_TRANSFORM_FEEDBACK_BUFFER_SIZE_EXT, "GL_TRANSFORM_FEEDBACK_BUFFER_SIZE_EXT" );
	#endif
	#ifdef GL_TRANSFORM_FEEDBACK_BUFFER_BINDING_EXT
		swigIntConstant( GL_TRANSFORM_FEEDBACK_BUFFER_BINDING_EXT, "GL_TRANSFORM_FEEDBACK_BUFFER_BINDING_EXT" );
	#endif
	#ifdef GL_INTERLEAVED_ATTRIBS_EXT
		swigIntConstant( GL_INTERLEAVED_ATTRIBS_EXT, "GL_INTERLEAVED_ATTRIBS_EXT" );
	#endif
	#ifdef GL_SEPARATE_ATTRIBS_EXT
		swigIntConstant( GL_SEPARATE_ATTRIBS_EXT, "GL_SEPARATE_ATTRIBS_EXT" );
	#endif
	#ifdef GL_PRIMITIVES_GENERATED_EXT
		swigIntConstant( GL_PRIMITIVES_GENERATED_EXT, "GL_PRIMITIVES_GENERATED_EXT" );
	#endif
	#ifdef GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN_EXT
		swigIntConstant( GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN_EXT, "GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN_EXT" );
	#endif
	#ifdef GL_RASTERIZER_DISCARD_EXT
		swigIntConstant( GL_RASTERIZER_DISCARD_EXT, "GL_RASTERIZER_DISCARD_EXT" );
	#endif
	#ifdef GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS_EXT
		swigIntConstant( GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS_EXT, "GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS_EXT" );
	#endif
	#ifdef GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS_EXT
		swigIntConstant( GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS_EXT, "GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS_EXT" );
	#endif
	#ifdef GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS_EXT
		swigIntConstant( GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS_EXT, "GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS_EXT" );
	#endif
	#ifdef GL_TRANSFORM_FEEDBACK_VARYINGS_EXT
		swigIntConstant( GL_TRANSFORM_FEEDBACK_VARYINGS_EXT, "GL_TRANSFORM_FEEDBACK_VARYINGS_EXT" );
	#endif
	#ifdef GL_TRANSFORM_FEEDBACK_BUFFER_MODE_EXT
		swigIntConstant( GL_TRANSFORM_FEEDBACK_BUFFER_MODE_EXT, "GL_TRANSFORM_FEEDBACK_BUFFER_MODE_EXT" );
	#endif
	#ifdef GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH_EXT
		swigIntConstant( GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH_EXT, "GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH_EXT" );
	#endif
	#ifdef GL_EXT_vertex_array
		swigIntConstant( GL_EXT_vertex_array, "GL_EXT_vertex_array" );
	#endif
	#ifdef GL_VERTEX_ARRAY_EXT
		swigIntConstant( GL_VERTEX_ARRAY_EXT, "GL_VERTEX_ARRAY_EXT" );
	#endif
	#ifdef GL_NORMAL_ARRAY_EXT
		swigIntConstant( GL_NORMAL_ARRAY_EXT, "GL_NORMAL_ARRAY_EXT" );
	#endif
	#ifdef GL_COLOR_ARRAY_EXT
		swigIntConstant( GL_COLOR_ARRAY_EXT, "GL_COLOR_ARRAY_EXT" );
	#endif
	#ifdef GL_INDEX_ARRAY_EXT
		swigIntConstant( GL_INDEX_ARRAY_EXT, "GL_INDEX_ARRAY_EXT" );
	#endif
	#ifdef GL_TEXTURE_COORD_ARRAY_EXT
		swigIntConstant( GL_TEXTURE_COORD_ARRAY_EXT, "GL_TEXTURE_COORD_ARRAY_EXT" );
	#endif
	#ifdef GL_EDGE_FLAG_ARRAY_EXT
		swigIntConstant( GL_EDGE_FLAG_ARRAY_EXT, "GL_EDGE_FLAG_ARRAY_EXT" );
	#endif
	#ifdef GL_VERTEX_ARRAY_SIZE_EXT
		swigIntConstant( GL_VERTEX_ARRAY_SIZE_EXT, "GL_VERTEX_ARRAY_SIZE_EXT" );
	#endif
	#ifdef GL_VERTEX_ARRAY_TYPE_EXT
		swigIntConstant( GL_VERTEX_ARRAY_TYPE_EXT, "GL_VERTEX_ARRAY_TYPE_EXT" );
	#endif
	#ifdef GL_VERTEX_ARRAY_STRIDE_EXT
		swigIntConstant( GL_VERTEX_ARRAY_STRIDE_EXT, "GL_VERTEX_ARRAY_STRIDE_EXT" );
	#endif
	#ifdef GL_VERTEX_ARRAY_COUNT_EXT
		swigIntConstant( GL_VERTEX_ARRAY_COUNT_EXT, "GL_VERTEX_ARRAY_COUNT_EXT" );
	#endif
	#ifdef GL_NORMAL_ARRAY_TYPE_EXT
		swigIntConstant( GL_NORMAL_ARRAY_TYPE_EXT, "GL_NORMAL_ARRAY_TYPE_EXT" );
	#endif
	#ifdef GL_NORMAL_ARRAY_STRIDE_EXT
		swigIntConstant( GL_NORMAL_ARRAY_STRIDE_EXT, "GL_NORMAL_ARRAY_STRIDE_EXT" );
	#endif
	#ifdef GL_NORMAL_ARRAY_COUNT_EXT
		swigIntConstant( GL_NORMAL_ARRAY_COUNT_EXT, "GL_NORMAL_ARRAY_COUNT_EXT" );
	#endif
	#ifdef GL_COLOR_ARRAY_SIZE_EXT
		swigIntConstant( GL_COLOR_ARRAY_SIZE_EXT, "GL_COLOR_ARRAY_SIZE_EXT" );
	#endif
	#ifdef GL_COLOR_ARRAY_TYPE_EXT
		swigIntConstant( GL_COLOR_ARRAY_TYPE_EXT, "GL_COLOR_ARRAY_TYPE_EXT" );
	#endif
	#ifdef GL_COLOR_ARRAY_STRIDE_EXT
		swigIntConstant( GL_COLOR_ARRAY_STRIDE_EXT, "GL_COLOR_ARRAY_STRIDE_EXT" );
	#endif
	#ifdef GL_COLOR_ARRAY_COUNT_EXT
		swigIntConstant( GL_COLOR_ARRAY_COUNT_EXT, "GL_COLOR_ARRAY_COUNT_EXT" );
	#endif
	#ifdef GL_INDEX_ARRAY_TYPE_EXT
		swigIntConstant( GL_INDEX_ARRAY_TYPE_EXT, "GL_INDEX_ARRAY_TYPE_EXT" );
	#endif
	#ifdef GL_INDEX_ARRAY_STRIDE_EXT
		swigIntConstant( GL_INDEX_ARRAY_STRIDE_EXT, "GL_INDEX_ARRAY_STRIDE_EXT" );
	#endif
	#ifdef GL_INDEX_ARRAY_COUNT_EXT
		swigIntConstant( GL_INDEX_ARRAY_COUNT_EXT, "GL_INDEX_ARRAY_COUNT_EXT" );
	#endif
	#ifdef GL_TEXTURE_COORD_ARRAY_SIZE_EXT
		swigIntConstant( GL_TEXTURE_COORD_ARRAY_SIZE_EXT, "GL_TEXTURE_COORD_ARRAY_SIZE_EXT" );
	#endif
	#ifdef GL_TEXTURE_COORD_ARRAY_TYPE_EXT
		swigIntConstant( GL_TEXTURE_COORD_ARRAY_TYPE_EXT, "GL_TEXTURE_COORD_ARRAY_TYPE_EXT" );
	#endif
	#ifdef GL_TEXTURE_COORD_ARRAY_STRIDE_EXT
		swigIntConstant( GL_TEXTURE_COORD_ARRAY_STRIDE_EXT, "GL_TEXTURE_COORD_ARRAY_STRIDE_EXT" );
	#endif
	#ifdef GL_TEXTURE_COORD_ARRAY_COUNT_EXT
		swigIntConstant( GL_TEXTURE_COORD_ARRAY_COUNT_EXT, "GL_TEXTURE_COORD_ARRAY_COUNT_EXT" );
	#endif
	#ifdef GL_EDGE_FLAG_ARRAY_STRIDE_EXT
		swigIntConstant( GL_EDGE_FLAG_ARRAY_STRIDE_EXT, "GL_EDGE_FLAG_ARRAY_STRIDE_EXT" );
	#endif
	#ifdef GL_EDGE_FLAG_ARRAY_COUNT_EXT
		swigIntConstant( GL_EDGE_FLAG_ARRAY_COUNT_EXT, "GL_EDGE_FLAG_ARRAY_COUNT_EXT" );
	#endif
	#ifdef GL_VERTEX_ARRAY_POINTER_EXT
		swigIntConstant( GL_VERTEX_ARRAY_POINTER_EXT, "GL_VERTEX_ARRAY_POINTER_EXT" );
	#endif
	#ifdef GL_NORMAL_ARRAY_POINTER_EXT
		swigIntConstant( GL_NORMAL_ARRAY_POINTER_EXT, "GL_NORMAL_ARRAY_POINTER_EXT" );
	#endif
	#ifdef GL_COLOR_ARRAY_POINTER_EXT
		swigIntConstant( GL_COLOR_ARRAY_POINTER_EXT, "GL_COLOR_ARRAY_POINTER_EXT" );
	#endif
	#ifdef GL_INDEX_ARRAY_POINTER_EXT
		swigIntConstant( GL_INDEX_ARRAY_POINTER_EXT, "GL_INDEX_ARRAY_POINTER_EXT" );
	#endif
	#ifdef GL_TEXTURE_COORD_ARRAY_POINTER_EXT
		swigIntConstant( GL_TEXTURE_COORD_ARRAY_POINTER_EXT, "GL_TEXTURE_COORD_ARRAY_POINTER_EXT" );
	#endif
	#ifdef GL_EDGE_FLAG_ARRAY_POINTER_EXT
		swigIntConstant( GL_EDGE_FLAG_ARRAY_POINTER_EXT, "GL_EDGE_FLAG_ARRAY_POINTER_EXT" );
	#endif
	#ifdef GL_EXT_vertex_array_bgra
		swigIntConstant( GL_EXT_vertex_array_bgra, "GL_EXT_vertex_array_bgra" );
	#endif
	#ifdef GL_EXT_vertex_attrib_64bit
		swigIntConstant( GL_EXT_vertex_attrib_64bit, "GL_EXT_vertex_attrib_64bit" );
	#endif
	#ifdef GL_DOUBLE_VEC2_EXT
		swigIntConstant( GL_DOUBLE_VEC2_EXT, "GL_DOUBLE_VEC2_EXT" );
	#endif
	#ifdef GL_DOUBLE_VEC3_EXT
		swigIntConstant( GL_DOUBLE_VEC3_EXT, "GL_DOUBLE_VEC3_EXT" );
	#endif
	#ifdef GL_DOUBLE_VEC4_EXT
		swigIntConstant( GL_DOUBLE_VEC4_EXT, "GL_DOUBLE_VEC4_EXT" );
	#endif
	#ifdef GL_DOUBLE_MAT2_EXT
		swigIntConstant( GL_DOUBLE_MAT2_EXT, "GL_DOUBLE_MAT2_EXT" );
	#endif
	#ifdef GL_DOUBLE_MAT3_EXT
		swigIntConstant( GL_DOUBLE_MAT3_EXT, "GL_DOUBLE_MAT3_EXT" );
	#endif
	#ifdef GL_DOUBLE_MAT4_EXT
		swigIntConstant( GL_DOUBLE_MAT4_EXT, "GL_DOUBLE_MAT4_EXT" );
	#endif
	#ifdef GL_DOUBLE_MAT2x3_EXT
		swigIntConstant( GL_DOUBLE_MAT2x3_EXT, "GL_DOUBLE_MAT2x3_EXT" );
	#endif
	#ifdef GL_DOUBLE_MAT2x4_EXT
		swigIntConstant( GL_DOUBLE_MAT2x4_EXT, "GL_DOUBLE_MAT2x4_EXT" );
	#endif
	#ifdef GL_DOUBLE_MAT3x2_EXT
		swigIntConstant( GL_DOUBLE_MAT3x2_EXT, "GL_DOUBLE_MAT3x2_EXT" );
	#endif
	#ifdef GL_DOUBLE_MAT3x4_EXT
		swigIntConstant( GL_DOUBLE_MAT3x4_EXT, "GL_DOUBLE_MAT3x4_EXT" );
	#endif
	#ifdef GL_DOUBLE_MAT4x2_EXT
		swigIntConstant( GL_DOUBLE_MAT4x2_EXT, "GL_DOUBLE_MAT4x2_EXT" );
	#endif
	#ifdef GL_DOUBLE_MAT4x3_EXT
		swigIntConstant( GL_DOUBLE_MAT4x3_EXT, "GL_DOUBLE_MAT4x3_EXT" );
	#endif
	#ifdef GL_EXT_vertex_shader
		swigIntConstant( GL_EXT_vertex_shader, "GL_EXT_vertex_shader" );
	#endif
	#ifdef GL_VERTEX_SHADER_EXT
		swigIntConstant( GL_VERTEX_SHADER_EXT, "GL_VERTEX_SHADER_EXT" );
	#endif
	#ifdef GL_VERTEX_SHADER_BINDING_EXT
		swigIntConstant( GL_VERTEX_SHADER_BINDING_EXT, "GL_VERTEX_SHADER_BINDING_EXT" );
	#endif
	#ifdef GL_OP_INDEX_EXT
		swigIntConstant( GL_OP_INDEX_EXT, "GL_OP_INDEX_EXT" );
	#endif
	#ifdef GL_OP_NEGATE_EXT
		swigIntConstant( GL_OP_NEGATE_EXT, "GL_OP_NEGATE_EXT" );
	#endif
	#ifdef GL_OP_DOT3_EXT
		swigIntConstant( GL_OP_DOT3_EXT, "GL_OP_DOT3_EXT" );
	#endif
	#ifdef GL_OP_DOT4_EXT
		swigIntConstant( GL_OP_DOT4_EXT, "GL_OP_DOT4_EXT" );
	#endif
	#ifdef GL_OP_MUL_EXT
		swigIntConstant( GL_OP_MUL_EXT, "GL_OP_MUL_EXT" );
	#endif
	#ifdef GL_OP_ADD_EXT
		swigIntConstant( GL_OP_ADD_EXT, "GL_OP_ADD_EXT" );
	#endif
	#ifdef GL_OP_MADD_EXT
		swigIntConstant( GL_OP_MADD_EXT, "GL_OP_MADD_EXT" );
	#endif
	#ifdef GL_OP_FRAC_EXT
		swigIntConstant( GL_OP_FRAC_EXT, "GL_OP_FRAC_EXT" );
	#endif
	#ifdef GL_OP_MAX_EXT
		swigIntConstant( GL_OP_MAX_EXT, "GL_OP_MAX_EXT" );
	#endif
	#ifdef GL_OP_MIN_EXT
		swigIntConstant( GL_OP_MIN_EXT, "GL_OP_MIN_EXT" );
	#endif
	#ifdef GL_OP_SET_GE_EXT
		swigIntConstant( GL_OP_SET_GE_EXT, "GL_OP_SET_GE_EXT" );
	#endif
	#ifdef GL_OP_SET_LT_EXT
		swigIntConstant( GL_OP_SET_LT_EXT, "GL_OP_SET_LT_EXT" );
	#endif
	#ifdef GL_OP_CLAMP_EXT
		swigIntConstant( GL_OP_CLAMP_EXT, "GL_OP_CLAMP_EXT" );
	#endif
	#ifdef GL_OP_FLOOR_EXT
		swigIntConstant( GL_OP_FLOOR_EXT, "GL_OP_FLOOR_EXT" );
	#endif
	#ifdef GL_OP_ROUND_EXT
		swigIntConstant( GL_OP_ROUND_EXT, "GL_OP_ROUND_EXT" );
	#endif
	#ifdef GL_OP_EXP_BASE_2_EXT
		swigIntConstant( GL_OP_EXP_BASE_2_EXT, "GL_OP_EXP_BASE_2_EXT" );
	#endif
	#ifdef GL_OP_LOG_BASE_2_EXT
		swigIntConstant( GL_OP_LOG_BASE_2_EXT, "GL_OP_LOG_BASE_2_EXT" );
	#endif
	#ifdef GL_OP_POWER_EXT
		swigIntConstant( GL_OP_POWER_EXT, "GL_OP_POWER_EXT" );
	#endif
	#ifdef GL_OP_RECIP_EXT
		swigIntConstant( GL_OP_RECIP_EXT, "GL_OP_RECIP_EXT" );
	#endif
	#ifdef GL_OP_RECIP_SQRT_EXT
		swigIntConstant( GL_OP_RECIP_SQRT_EXT, "GL_OP_RECIP_SQRT_EXT" );
	#endif
	#ifdef GL_OP_SUB_EXT
		swigIntConstant( GL_OP_SUB_EXT, "GL_OP_SUB_EXT" );
	#endif
	#ifdef GL_OP_CROSS_PRODUCT_EXT
		swigIntConstant( GL_OP_CROSS_PRODUCT_EXT, "GL_OP_CROSS_PRODUCT_EXT" );
	#endif
	#ifdef GL_OP_MULTIPLY_MATRIX_EXT
		swigIntConstant( GL_OP_MULTIPLY_MATRIX_EXT, "GL_OP_MULTIPLY_MATRIX_EXT" );
	#endif
	#ifdef GL_OP_MOV_EXT
		swigIntConstant( GL_OP_MOV_EXT, "GL_OP_MOV_EXT" );
	#endif
	#ifdef GL_OUTPUT_VERTEX_EXT
		swigIntConstant( GL_OUTPUT_VERTEX_EXT, "GL_OUTPUT_VERTEX_EXT" );
	#endif
	#ifdef GL_OUTPUT_COLOR0_EXT
		swigIntConstant( GL_OUTPUT_COLOR0_EXT, "GL_OUTPUT_COLOR0_EXT" );
	#endif
	#ifdef GL_OUTPUT_COLOR1_EXT
		swigIntConstant( GL_OUTPUT_COLOR1_EXT, "GL_OUTPUT_COLOR1_EXT" );
	#endif
	#ifdef GL_OUTPUT_TEXTURE_COORD0_EXT
		swigIntConstant( GL_OUTPUT_TEXTURE_COORD0_EXT, "GL_OUTPUT_TEXTURE_COORD0_EXT" );
	#endif
	#ifdef GL_OUTPUT_TEXTURE_COORD1_EXT
		swigIntConstant( GL_OUTPUT_TEXTURE_COORD1_EXT, "GL_OUTPUT_TEXTURE_COORD1_EXT" );
	#endif
	#ifdef GL_OUTPUT_TEXTURE_COORD2_EXT
		swigIntConstant( GL_OUTPUT_TEXTURE_COORD2_EXT, "GL_OUTPUT_TEXTURE_COORD2_EXT" );
	#endif
	#ifdef GL_OUTPUT_TEXTURE_COORD3_EXT
		swigIntConstant( GL_OUTPUT_TEXTURE_COORD3_EXT, "GL_OUTPUT_TEXTURE_COORD3_EXT" );
	#endif
	#ifdef GL_OUTPUT_TEXTURE_COORD4_EXT
		swigIntConstant( GL_OUTPUT_TEXTURE_COORD4_EXT, "GL_OUTPUT_TEXTURE_COORD4_EXT" );
	#endif
	#ifdef GL_OUTPUT_TEXTURE_COORD5_EXT
		swigIntConstant( GL_OUTPUT_TEXTURE_COORD5_EXT, "GL_OUTPUT_TEXTURE_COORD5_EXT" );
	#endif
	#ifdef GL_OUTPUT_TEXTURE_COORD6_EXT
		swigIntConstant( GL_OUTPUT_TEXTURE_COORD6_EXT, "GL_OUTPUT_TEXTURE_COORD6_EXT" );
	#endif
	#ifdef GL_OUTPUT_TEXTURE_COORD7_EXT
		swigIntConstant( GL_OUTPUT_TEXTURE_COORD7_EXT, "GL_OUTPUT_TEXTURE_COORD7_EXT" );
	#endif
	#ifdef GL_OUTPUT_TEXTURE_COORD8_EXT
		swigIntConstant( GL_OUTPUT_TEXTURE_COORD8_EXT, "GL_OUTPUT_TEXTURE_COORD8_EXT" );
	#endif
	#ifdef GL_OUTPUT_TEXTURE_COORD9_EXT
		swigIntConstant( GL_OUTPUT_TEXTURE_COORD9_EXT, "GL_OUTPUT_TEXTURE_COORD9_EXT" );
	#endif
	#ifdef GL_OUTPUT_TEXTURE_COORD10_EXT
		swigIntConstant( GL_OUTPUT_TEXTURE_COORD10_EXT, "GL_OUTPUT_TEXTURE_COORD10_EXT" );
	#endif
	#ifdef GL_OUTPUT_TEXTURE_COORD11_EXT
		swigIntConstant( GL_OUTPUT_TEXTURE_COORD11_EXT, "GL_OUTPUT_TEXTURE_COORD11_EXT" );
	#endif
	#ifdef GL_OUTPUT_TEXTURE_COORD12_EXT
		swigIntConstant( GL_OUTPUT_TEXTURE_COORD12_EXT, "GL_OUTPUT_TEXTURE_COORD12_EXT" );
	#endif
	#ifdef GL_OUTPUT_TEXTURE_COORD13_EXT
		swigIntConstant( GL_OUTPUT_TEXTURE_COORD13_EXT, "GL_OUTPUT_TEXTURE_COORD13_EXT" );
	#endif
	#ifdef GL_OUTPUT_TEXTURE_COORD14_EXT
		swigIntConstant( GL_OUTPUT_TEXTURE_COORD14_EXT, "GL_OUTPUT_TEXTURE_COORD14_EXT" );
	#endif
	#ifdef GL_OUTPUT_TEXTURE_COORD15_EXT
		swigIntConstant( GL_OUTPUT_TEXTURE_COORD15_EXT, "GL_OUTPUT_TEXTURE_COORD15_EXT" );
	#endif
	#ifdef GL_OUTPUT_TEXTURE_COORD16_EXT
		swigIntConstant( GL_OUTPUT_TEXTURE_COORD16_EXT, "GL_OUTPUT_TEXTURE_COORD16_EXT" );
	#endif
	#ifdef GL_OUTPUT_TEXTURE_COORD17_EXT
		swigIntConstant( GL_OUTPUT_TEXTURE_COORD17_EXT, "GL_OUTPUT_TEXTURE_COORD17_EXT" );
	#endif
	#ifdef GL_OUTPUT_TEXTURE_COORD18_EXT
		swigIntConstant( GL_OUTPUT_TEXTURE_COORD18_EXT, "GL_OUTPUT_TEXTURE_COORD18_EXT" );
	#endif
	#ifdef GL_OUTPUT_TEXTURE_COORD19_EXT
		swigIntConstant( GL_OUTPUT_TEXTURE_COORD19_EXT, "GL_OUTPUT_TEXTURE_COORD19_EXT" );
	#endif
	#ifdef GL_OUTPUT_TEXTURE_COORD20_EXT
		swigIntConstant( GL_OUTPUT_TEXTURE_COORD20_EXT, "GL_OUTPUT_TEXTURE_COORD20_EXT" );
	#endif
	#ifdef GL_OUTPUT_TEXTURE_COORD21_EXT
		swigIntConstant( GL_OUTPUT_TEXTURE_COORD21_EXT, "GL_OUTPUT_TEXTURE_COORD21_EXT" );
	#endif
	#ifdef GL_OUTPUT_TEXTURE_COORD22_EXT
		swigIntConstant( GL_OUTPUT_TEXTURE_COORD22_EXT, "GL_OUTPUT_TEXTURE_COORD22_EXT" );
	#endif
	#ifdef GL_OUTPUT_TEXTURE_COORD23_EXT
		swigIntConstant( GL_OUTPUT_TEXTURE_COORD23_EXT, "GL_OUTPUT_TEXTURE_COORD23_EXT" );
	#endif
	#ifdef GL_OUTPUT_TEXTURE_COORD24_EXT
		swigIntConstant( GL_OUTPUT_TEXTURE_COORD24_EXT, "GL_OUTPUT_TEXTURE_COORD24_EXT" );
	#endif
	#ifdef GL_OUTPUT_TEXTURE_COORD25_EXT
		swigIntConstant( GL_OUTPUT_TEXTURE_COORD25_EXT, "GL_OUTPUT_TEXTURE_COORD25_EXT" );
	#endif
	#ifdef GL_OUTPUT_TEXTURE_COORD26_EXT
		swigIntConstant( GL_OUTPUT_TEXTURE_COORD26_EXT, "GL_OUTPUT_TEXTURE_COORD26_EXT" );
	#endif
	#ifdef GL_OUTPUT_TEXTURE_COORD27_EXT
		swigIntConstant( GL_OUTPUT_TEXTURE_COORD27_EXT, "GL_OUTPUT_TEXTURE_COORD27_EXT" );
	#endif
	#ifdef GL_OUTPUT_TEXTURE_COORD28_EXT
		swigIntConstant( GL_OUTPUT_TEXTURE_COORD28_EXT, "GL_OUTPUT_TEXTURE_COORD28_EXT" );
	#endif
	#ifdef GL_OUTPUT_TEXTURE_COORD29_EXT
		swigIntConstant( GL_OUTPUT_TEXTURE_COORD29_EXT, "GL_OUTPUT_TEXTURE_COORD29_EXT" );
	#endif
	#ifdef GL_OUTPUT_TEXTURE_COORD30_EXT
		swigIntConstant( GL_OUTPUT_TEXTURE_COORD30_EXT, "GL_OUTPUT_TEXTURE_COORD30_EXT" );
	#endif
	#ifdef GL_OUTPUT_TEXTURE_COORD31_EXT
		swigIntConstant( GL_OUTPUT_TEXTURE_COORD31_EXT, "GL_OUTPUT_TEXTURE_COORD31_EXT" );
	#endif
	#ifdef GL_OUTPUT_FOG_EXT
		swigIntConstant( GL_OUTPUT_FOG_EXT, "GL_OUTPUT_FOG_EXT" );
	#endif
	#ifdef GL_SCALAR_EXT
		swigIntConstant( GL_SCALAR_EXT, "GL_SCALAR_EXT" );
	#endif
	#ifdef GL_VECTOR_EXT
		swigIntConstant( GL_VECTOR_EXT, "GL_VECTOR_EXT" );
	#endif
	#ifdef GL_MATRIX_EXT
		swigIntConstant( GL_MATRIX_EXT, "GL_MATRIX_EXT" );
	#endif
	#ifdef GL_VARIANT_EXT
		swigIntConstant( GL_VARIANT_EXT, "GL_VARIANT_EXT" );
	#endif
	#ifdef GL_INVARIANT_EXT
		swigIntConstant( GL_INVARIANT_EXT, "GL_INVARIANT_EXT" );
	#endif
	#ifdef GL_LOCAL_CONSTANT_EXT
		swigIntConstant( GL_LOCAL_CONSTANT_EXT, "GL_LOCAL_CONSTANT_EXT" );
	#endif
	#ifdef GL_LOCAL_EXT
		swigIntConstant( GL_LOCAL_EXT, "GL_LOCAL_EXT" );
	#endif
	#ifdef GL_MAX_VERTEX_SHADER_INSTRUCTIONS_EXT
		swigIntConstant( GL_MAX_VERTEX_SHADER_INSTRUCTIONS_EXT, "GL_MAX_VERTEX_SHADER_INSTRUCTIONS_EXT" );
	#endif
	#ifdef GL_MAX_VERTEX_SHADER_VARIANTS_EXT
		swigIntConstant( GL_MAX_VERTEX_SHADER_VARIANTS_EXT, "GL_MAX_VERTEX_SHADER_VARIANTS_EXT" );
	#endif
	#ifdef GL_MAX_VERTEX_SHADER_INVARIANTS_EXT
		swigIntConstant( GL_MAX_VERTEX_SHADER_INVARIANTS_EXT, "GL_MAX_VERTEX_SHADER_INVARIANTS_EXT" );
	#endif
	#ifdef GL_MAX_VERTEX_SHADER_LOCAL_CONSTANTS_EXT
		swigIntConstant( GL_MAX_VERTEX_SHADER_LOCAL_CONSTANTS_EXT, "GL_MAX_VERTEX_SHADER_LOCAL_CONSTANTS_EXT" );
	#endif
	#ifdef GL_MAX_VERTEX_SHADER_LOCALS_EXT
		swigIntConstant( GL_MAX_VERTEX_SHADER_LOCALS_EXT, "GL_MAX_VERTEX_SHADER_LOCALS_EXT" );
	#endif
	#ifdef GL_MAX_OPTIMIZED_VERTEX_SHADER_INSTRUCTIONS_EXT
		swigIntConstant( GL_MAX_OPTIMIZED_VERTEX_SHADER_INSTRUCTIONS_EXT, "GL_MAX_OPTIMIZED_VERTEX_SHADER_INSTRUCTIONS_EXT" );
	#endif
	#ifdef GL_MAX_OPTIMIZED_VERTEX_SHADER_VARIANTS_EXT
		swigIntConstant( GL_MAX_OPTIMIZED_VERTEX_SHADER_VARIANTS_EXT, "GL_MAX_OPTIMIZED_VERTEX_SHADER_VARIANTS_EXT" );
	#endif
	#ifdef GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCAL_CONSTANTS_EXT
		swigIntConstant( GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCAL_CONSTANTS_EXT, "GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCAL_CONSTANTS_EXT" );
	#endif
	#ifdef GL_MAX_OPTIMIZED_VERTEX_SHADER_INVARIANTS_EXT
		swigIntConstant( GL_MAX_OPTIMIZED_VERTEX_SHADER_INVARIANTS_EXT, "GL_MAX_OPTIMIZED_VERTEX_SHADER_INVARIANTS_EXT" );
	#endif
	#ifdef GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCALS_EXT
		swigIntConstant( GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCALS_EXT, "GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCALS_EXT" );
	#endif
	#ifdef GL_VERTEX_SHADER_INSTRUCTIONS_EXT
		swigIntConstant( GL_VERTEX_SHADER_INSTRUCTIONS_EXT, "GL_VERTEX_SHADER_INSTRUCTIONS_EXT" );
	#endif
	#ifdef GL_VERTEX_SHADER_VARIANTS_EXT
		swigIntConstant( GL_VERTEX_SHADER_VARIANTS_EXT, "GL_VERTEX_SHADER_VARIANTS_EXT" );
	#endif
	#ifdef GL_VERTEX_SHADER_INVARIANTS_EXT
		swigIntConstant( GL_VERTEX_SHADER_INVARIANTS_EXT, "GL_VERTEX_SHADER_INVARIANTS_EXT" );
	#endif
	#ifdef GL_VERTEX_SHADER_LOCAL_CONSTANTS_EXT
		swigIntConstant( GL_VERTEX_SHADER_LOCAL_CONSTANTS_EXT, "GL_VERTEX_SHADER_LOCAL_CONSTANTS_EXT" );
	#endif
	#ifdef GL_VERTEX_SHADER_LOCALS_EXT
		swigIntConstant( GL_VERTEX_SHADER_LOCALS_EXT, "GL_VERTEX_SHADER_LOCALS_EXT" );
	#endif
	#ifdef GL_VERTEX_SHADER_OPTIMIZED_EXT
		swigIntConstant( GL_VERTEX_SHADER_OPTIMIZED_EXT, "GL_VERTEX_SHADER_OPTIMIZED_EXT" );
	#endif
	#ifdef GL_X_EXT
		swigIntConstant( GL_X_EXT, "GL_X_EXT" );
	#endif
	#ifdef GL_Y_EXT
		swigIntConstant( GL_Y_EXT, "GL_Y_EXT" );
	#endif
	#ifdef GL_Z_EXT
		swigIntConstant( GL_Z_EXT, "GL_Z_EXT" );
	#endif
	#ifdef GL_W_EXT
		swigIntConstant( GL_W_EXT, "GL_W_EXT" );
	#endif
	#ifdef GL_NEGATIVE_X_EXT
		swigIntConstant( GL_NEGATIVE_X_EXT, "GL_NEGATIVE_X_EXT" );
	#endif
	#ifdef GL_NEGATIVE_Y_EXT
		swigIntConstant( GL_NEGATIVE_Y_EXT, "GL_NEGATIVE_Y_EXT" );
	#endif
	#ifdef GL_NEGATIVE_Z_EXT
		swigIntConstant( GL_NEGATIVE_Z_EXT, "GL_NEGATIVE_Z_EXT" );
	#endif
	#ifdef GL_NEGATIVE_W_EXT
		swigIntConstant( GL_NEGATIVE_W_EXT, "GL_NEGATIVE_W_EXT" );
	#endif
	#ifdef GL_ZERO_EXT
		swigIntConstant( GL_ZERO_EXT, "GL_ZERO_EXT" );
	#endif
	#ifdef GL_ONE_EXT
		swigIntConstant( GL_ONE_EXT, "GL_ONE_EXT" );
	#endif
	#ifdef GL_NEGATIVE_ONE_EXT
		swigIntConstant( GL_NEGATIVE_ONE_EXT, "GL_NEGATIVE_ONE_EXT" );
	#endif
	#ifdef GL_NORMALIZED_RANGE_EXT
		swigIntConstant( GL_NORMALIZED_RANGE_EXT, "GL_NORMALIZED_RANGE_EXT" );
	#endif
	#ifdef GL_FULL_RANGE_EXT
		swigIntConstant( GL_FULL_RANGE_EXT, "GL_FULL_RANGE_EXT" );
	#endif
	#ifdef GL_CURRENT_VERTEX_EXT
		swigIntConstant( GL_CURRENT_VERTEX_EXT, "GL_CURRENT_VERTEX_EXT" );
	#endif
	#ifdef GL_MVP_MATRIX_EXT
		swigIntConstant( GL_MVP_MATRIX_EXT, "GL_MVP_MATRIX_EXT" );
	#endif
	#ifdef GL_VARIANT_VALUE_EXT
		swigIntConstant( GL_VARIANT_VALUE_EXT, "GL_VARIANT_VALUE_EXT" );
	#endif
	#ifdef GL_VARIANT_DATATYPE_EXT
		swigIntConstant( GL_VARIANT_DATATYPE_EXT, "GL_VARIANT_DATATYPE_EXT" );
	#endif
	#ifdef GL_VARIANT_ARRAY_STRIDE_EXT
		swigIntConstant( GL_VARIANT_ARRAY_STRIDE_EXT, "GL_VARIANT_ARRAY_STRIDE_EXT" );
	#endif
	#ifdef GL_VARIANT_ARRAY_TYPE_EXT
		swigIntConstant( GL_VARIANT_ARRAY_TYPE_EXT, "GL_VARIANT_ARRAY_TYPE_EXT" );
	#endif
	#ifdef GL_VARIANT_ARRAY_EXT
		swigIntConstant( GL_VARIANT_ARRAY_EXT, "GL_VARIANT_ARRAY_EXT" );
	#endif
	#ifdef GL_VARIANT_ARRAY_POINTER_EXT
		swigIntConstant( GL_VARIANT_ARRAY_POINTER_EXT, "GL_VARIANT_ARRAY_POINTER_EXT" );
	#endif
	#ifdef GL_INVARIANT_VALUE_EXT
		swigIntConstant( GL_INVARIANT_VALUE_EXT, "GL_INVARIANT_VALUE_EXT" );
	#endif
	#ifdef GL_INVARIANT_DATATYPE_EXT
		swigIntConstant( GL_INVARIANT_DATATYPE_EXT, "GL_INVARIANT_DATATYPE_EXT" );
	#endif
	#ifdef GL_LOCAL_CONSTANT_VALUE_EXT
		swigIntConstant( GL_LOCAL_CONSTANT_VALUE_EXT, "GL_LOCAL_CONSTANT_VALUE_EXT" );
	#endif
	#ifdef GL_LOCAL_CONSTANT_DATATYPE_EXT
		swigIntConstant( GL_LOCAL_CONSTANT_DATATYPE_EXT, "GL_LOCAL_CONSTANT_DATATYPE_EXT" );
	#endif
	#ifdef GL_EXT_vertex_weighting
		swigIntConstant( GL_EXT_vertex_weighting, "GL_EXT_vertex_weighting" );
	#endif
	#ifdef GL_MODELVIEW0_STACK_DEPTH_EXT
		swigIntConstant( GL_MODELVIEW0_STACK_DEPTH_EXT, "GL_MODELVIEW0_STACK_DEPTH_EXT" );
	#endif
	#ifdef GL_MODELVIEW1_STACK_DEPTH_EXT
		swigIntConstant( GL_MODELVIEW1_STACK_DEPTH_EXT, "GL_MODELVIEW1_STACK_DEPTH_EXT" );
	#endif
	#ifdef GL_MODELVIEW0_MATRIX_EXT
		swigIntConstant( GL_MODELVIEW0_MATRIX_EXT, "GL_MODELVIEW0_MATRIX_EXT" );
	#endif
	#ifdef GL_MODELVIEW1_MATRIX_EXT
		swigIntConstant( GL_MODELVIEW1_MATRIX_EXT, "GL_MODELVIEW1_MATRIX_EXT" );
	#endif
	#ifdef GL_VERTEX_WEIGHTING_EXT
		swigIntConstant( GL_VERTEX_WEIGHTING_EXT, "GL_VERTEX_WEIGHTING_EXT" );
	#endif
	#ifdef GL_MODELVIEW0_EXT
		swigIntConstant( GL_MODELVIEW0_EXT, "GL_MODELVIEW0_EXT" );
	#endif
	#ifdef GL_MODELVIEW1_EXT
		swigIntConstant( GL_MODELVIEW1_EXT, "GL_MODELVIEW1_EXT" );
	#endif
	#ifdef GL_CURRENT_VERTEX_WEIGHT_EXT
		swigIntConstant( GL_CURRENT_VERTEX_WEIGHT_EXT, "GL_CURRENT_VERTEX_WEIGHT_EXT" );
	#endif
	#ifdef GL_VERTEX_WEIGHT_ARRAY_EXT
		swigIntConstant( GL_VERTEX_WEIGHT_ARRAY_EXT, "GL_VERTEX_WEIGHT_ARRAY_EXT" );
	#endif
	#ifdef GL_VERTEX_WEIGHT_ARRAY_SIZE_EXT
		swigIntConstant( GL_VERTEX_WEIGHT_ARRAY_SIZE_EXT, "GL_VERTEX_WEIGHT_ARRAY_SIZE_EXT" );
	#endif
	#ifdef GL_VERTEX_WEIGHT_ARRAY_TYPE_EXT
		swigIntConstant( GL_VERTEX_WEIGHT_ARRAY_TYPE_EXT, "GL_VERTEX_WEIGHT_ARRAY_TYPE_EXT" );
	#endif
	#ifdef GL_VERTEX_WEIGHT_ARRAY_STRIDE_EXT
		swigIntConstant( GL_VERTEX_WEIGHT_ARRAY_STRIDE_EXT, "GL_VERTEX_WEIGHT_ARRAY_STRIDE_EXT" );
	#endif
	#ifdef GL_VERTEX_WEIGHT_ARRAY_POINTER_EXT
		swigIntConstant( GL_VERTEX_WEIGHT_ARRAY_POINTER_EXT, "GL_VERTEX_WEIGHT_ARRAY_POINTER_EXT" );
	#endif
	#ifdef GL_EXT_win32_keyed_mutex
		swigIntConstant( GL_EXT_win32_keyed_mutex, "GL_EXT_win32_keyed_mutex" );
	#endif
	#ifdef GL_EXT_window_rectangles
		swigIntConstant( GL_EXT_window_rectangles, "GL_EXT_window_rectangles" );
	#endif
	#ifdef GL_INCLUSIVE_EXT
		swigIntConstant( GL_INCLUSIVE_EXT, "GL_INCLUSIVE_EXT" );
	#endif
	#ifdef GL_EXCLUSIVE_EXT
		swigIntConstant( GL_EXCLUSIVE_EXT, "GL_EXCLUSIVE_EXT" );
	#endif
	#ifdef GL_WINDOW_RECTANGLE_EXT
		swigIntConstant( GL_WINDOW_RECTANGLE_EXT, "GL_WINDOW_RECTANGLE_EXT" );
	#endif
	#ifdef GL_WINDOW_RECTANGLE_MODE_EXT
		swigIntConstant( GL_WINDOW_RECTANGLE_MODE_EXT, "GL_WINDOW_RECTANGLE_MODE_EXT" );
	#endif
	#ifdef GL_MAX_WINDOW_RECTANGLES_EXT
		swigIntConstant( GL_MAX_WINDOW_RECTANGLES_EXT, "GL_MAX_WINDOW_RECTANGLES_EXT" );
	#endif
	#ifdef GL_NUM_WINDOW_RECTANGLES_EXT
		swigIntConstant( GL_NUM_WINDOW_RECTANGLES_EXT, "GL_NUM_WINDOW_RECTANGLES_EXT" );
	#endif
	#ifdef GL_EXT_x11_sync_object
		swigIntConstant( GL_EXT_x11_sync_object, "GL_EXT_x11_sync_object" );
	#endif
	#ifdef GL_SYNC_X11_FENCE_EXT
		swigIntConstant( GL_SYNC_X11_FENCE_EXT, "GL_SYNC_X11_FENCE_EXT" );
	#endif
	#ifdef GL_GREMEDY_frame_terminator
		swigIntConstant( GL_GREMEDY_frame_terminator, "GL_GREMEDY_frame_terminator" );
	#endif
	#ifdef GL_GREMEDY_string_marker
		swigIntConstant( GL_GREMEDY_string_marker, "GL_GREMEDY_string_marker" );
	#endif
	#ifdef GL_HP_convolution_border_modes
		swigIntConstant( GL_HP_convolution_border_modes, "GL_HP_convolution_border_modes" );
	#endif
	#ifdef GL_IGNORE_BORDER_HP
		swigIntConstant( GL_IGNORE_BORDER_HP, "GL_IGNORE_BORDER_HP" );
	#endif
	#ifdef GL_CONSTANT_BORDER_HP
		swigIntConstant( GL_CONSTANT_BORDER_HP, "GL_CONSTANT_BORDER_HP" );
	#endif
	#ifdef GL_REPLICATE_BORDER_HP
		swigIntConstant( GL_REPLICATE_BORDER_HP, "GL_REPLICATE_BORDER_HP" );
	#endif
	#ifdef GL_CONVOLUTION_BORDER_COLOR_HP
		swigIntConstant( GL_CONVOLUTION_BORDER_COLOR_HP, "GL_CONVOLUTION_BORDER_COLOR_HP" );
	#endif
	#ifdef GL_HP_image_transform
		swigIntConstant( GL_HP_image_transform, "GL_HP_image_transform" );
	#endif
	#ifdef GL_IMAGE_SCALE_X_HP
		swigIntConstant( GL_IMAGE_SCALE_X_HP, "GL_IMAGE_SCALE_X_HP" );
	#endif
	#ifdef GL_IMAGE_SCALE_Y_HP
		swigIntConstant( GL_IMAGE_SCALE_Y_HP, "GL_IMAGE_SCALE_Y_HP" );
	#endif
	#ifdef GL_IMAGE_TRANSLATE_X_HP
		swigIntConstant( GL_IMAGE_TRANSLATE_X_HP, "GL_IMAGE_TRANSLATE_X_HP" );
	#endif
	#ifdef GL_IMAGE_TRANSLATE_Y_HP
		swigIntConstant( GL_IMAGE_TRANSLATE_Y_HP, "GL_IMAGE_TRANSLATE_Y_HP" );
	#endif
	#ifdef GL_IMAGE_ROTATE_ANGLE_HP
		swigIntConstant( GL_IMAGE_ROTATE_ANGLE_HP, "GL_IMAGE_ROTATE_ANGLE_HP" );
	#endif
	#ifdef GL_IMAGE_ROTATE_ORIGIN_X_HP
		swigIntConstant( GL_IMAGE_ROTATE_ORIGIN_X_HP, "GL_IMAGE_ROTATE_ORIGIN_X_HP" );
	#endif
	#ifdef GL_IMAGE_ROTATE_ORIGIN_Y_HP
		swigIntConstant( GL_IMAGE_ROTATE_ORIGIN_Y_HP, "GL_IMAGE_ROTATE_ORIGIN_Y_HP" );
	#endif
	#ifdef GL_IMAGE_MAG_FILTER_HP
		swigIntConstant( GL_IMAGE_MAG_FILTER_HP, "GL_IMAGE_MAG_FILTER_HP" );
	#endif
	#ifdef GL_IMAGE_MIN_FILTER_HP
		swigIntConstant( GL_IMAGE_MIN_FILTER_HP, "GL_IMAGE_MIN_FILTER_HP" );
	#endif
	#ifdef GL_IMAGE_CUBIC_WEIGHT_HP
		swigIntConstant( GL_IMAGE_CUBIC_WEIGHT_HP, "GL_IMAGE_CUBIC_WEIGHT_HP" );
	#endif
	#ifdef GL_CUBIC_HP
		swigIntConstant( GL_CUBIC_HP, "GL_CUBIC_HP" );
	#endif
	#ifdef GL_AVERAGE_HP
		swigIntConstant( GL_AVERAGE_HP, "GL_AVERAGE_HP" );
	#endif
	#ifdef GL_IMAGE_TRANSFORM_2D_HP
		swigIntConstant( GL_IMAGE_TRANSFORM_2D_HP, "GL_IMAGE_TRANSFORM_2D_HP" );
	#endif
	#ifdef GL_POST_IMAGE_TRANSFORM_COLOR_TABLE_HP
		swigIntConstant( GL_POST_IMAGE_TRANSFORM_COLOR_TABLE_HP, "GL_POST_IMAGE_TRANSFORM_COLOR_TABLE_HP" );
	#endif
	#ifdef GL_PROXY_POST_IMAGE_TRANSFORM_COLOR_TABLE_HP
		swigIntConstant( GL_PROXY_POST_IMAGE_TRANSFORM_COLOR_TABLE_HP, "GL_PROXY_POST_IMAGE_TRANSFORM_COLOR_TABLE_HP" );
	#endif
	#ifdef GL_HP_occlusion_test
		swigIntConstant( GL_HP_occlusion_test, "GL_HP_occlusion_test" );
	#endif
	#ifdef GL_OCCLUSION_TEST_HP
		swigIntConstant( GL_OCCLUSION_TEST_HP, "GL_OCCLUSION_TEST_HP" );
	#endif
	#ifdef GL_OCCLUSION_TEST_RESULT_HP
		swigIntConstant( GL_OCCLUSION_TEST_RESULT_HP, "GL_OCCLUSION_TEST_RESULT_HP" );
	#endif
	#ifdef GL_HP_texture_lighting
		swigIntConstant( GL_HP_texture_lighting, "GL_HP_texture_lighting" );
	#endif
	#ifdef GL_TEXTURE_LIGHTING_MODE_HP
		swigIntConstant( GL_TEXTURE_LIGHTING_MODE_HP, "GL_TEXTURE_LIGHTING_MODE_HP" );
	#endif
	#ifdef GL_TEXTURE_POST_SPECULAR_HP
		swigIntConstant( GL_TEXTURE_POST_SPECULAR_HP, "GL_TEXTURE_POST_SPECULAR_HP" );
	#endif
	#ifdef GL_TEXTURE_PRE_SPECULAR_HP
		swigIntConstant( GL_TEXTURE_PRE_SPECULAR_HP, "GL_TEXTURE_PRE_SPECULAR_HP" );
	#endif
	#ifdef GL_IBM_cull_vertex
		swigIntConstant( GL_IBM_cull_vertex, "GL_IBM_cull_vertex" );
	#endif
	#ifdef GL_CULL_VERTEX_IBM
		swigIntConstant( GL_CULL_VERTEX_IBM, "GL_CULL_VERTEX_IBM" );
	#endif
	#ifdef GL_IBM_multimode_draw_arrays
		swigIntConstant( GL_IBM_multimode_draw_arrays, "GL_IBM_multimode_draw_arrays" );
	#endif
	#ifdef GL_IBM_rasterpos_clip
		swigIntConstant( GL_IBM_rasterpos_clip, "GL_IBM_rasterpos_clip" );
	#endif
	#ifdef GL_RASTER_POSITION_UNCLIPPED_IBM
		swigIntConstant( GL_RASTER_POSITION_UNCLIPPED_IBM, "GL_RASTER_POSITION_UNCLIPPED_IBM" );
	#endif
	#ifdef GL_IBM_static_data
		swigIntConstant( GL_IBM_static_data, "GL_IBM_static_data" );
	#endif
	#ifdef GL_ALL_STATIC_DATA_IBM
		swigIntConstant( GL_ALL_STATIC_DATA_IBM, "GL_ALL_STATIC_DATA_IBM" );
	#endif
	#ifdef GL_STATIC_VERTEX_ARRAY_IBM
		swigIntConstant( GL_STATIC_VERTEX_ARRAY_IBM, "GL_STATIC_VERTEX_ARRAY_IBM" );
	#endif
	#ifdef GL_IBM_texture_mirrored_repeat
		swigIntConstant( GL_IBM_texture_mirrored_repeat, "GL_IBM_texture_mirrored_repeat" );
	#endif
	#ifdef GL_MIRRORED_REPEAT_IBM
		swigIntConstant( GL_MIRRORED_REPEAT_IBM, "GL_MIRRORED_REPEAT_IBM" );
	#endif
	#ifdef GL_IBM_vertex_array_lists
		swigIntConstant( GL_IBM_vertex_array_lists, "GL_IBM_vertex_array_lists" );
	#endif
	#ifdef GL_VERTEX_ARRAY_LIST_IBM
		swigIntConstant( GL_VERTEX_ARRAY_LIST_IBM, "GL_VERTEX_ARRAY_LIST_IBM" );
	#endif
	#ifdef GL_NORMAL_ARRAY_LIST_IBM
		swigIntConstant( GL_NORMAL_ARRAY_LIST_IBM, "GL_NORMAL_ARRAY_LIST_IBM" );
	#endif
	#ifdef GL_COLOR_ARRAY_LIST_IBM
		swigIntConstant( GL_COLOR_ARRAY_LIST_IBM, "GL_COLOR_ARRAY_LIST_IBM" );
	#endif
	#ifdef GL_INDEX_ARRAY_LIST_IBM
		swigIntConstant( GL_INDEX_ARRAY_LIST_IBM, "GL_INDEX_ARRAY_LIST_IBM" );
	#endif
	#ifdef GL_TEXTURE_COORD_ARRAY_LIST_IBM
		swigIntConstant( GL_TEXTURE_COORD_ARRAY_LIST_IBM, "GL_TEXTURE_COORD_ARRAY_LIST_IBM" );
	#endif
	#ifdef GL_EDGE_FLAG_ARRAY_LIST_IBM
		swigIntConstant( GL_EDGE_FLAG_ARRAY_LIST_IBM, "GL_EDGE_FLAG_ARRAY_LIST_IBM" );
	#endif
	#ifdef GL_FOG_COORDINATE_ARRAY_LIST_IBM
		swigIntConstant( GL_FOG_COORDINATE_ARRAY_LIST_IBM, "GL_FOG_COORDINATE_ARRAY_LIST_IBM" );
	#endif
	#ifdef GL_SECONDARY_COLOR_ARRAY_LIST_IBM
		swigIntConstant( GL_SECONDARY_COLOR_ARRAY_LIST_IBM, "GL_SECONDARY_COLOR_ARRAY_LIST_IBM" );
	#endif
	#ifdef GL_VERTEX_ARRAY_LIST_STRIDE_IBM
		swigIntConstant( GL_VERTEX_ARRAY_LIST_STRIDE_IBM, "GL_VERTEX_ARRAY_LIST_STRIDE_IBM" );
	#endif
	#ifdef GL_NORMAL_ARRAY_LIST_STRIDE_IBM
		swigIntConstant( GL_NORMAL_ARRAY_LIST_STRIDE_IBM, "GL_NORMAL_ARRAY_LIST_STRIDE_IBM" );
	#endif
	#ifdef GL_COLOR_ARRAY_LIST_STRIDE_IBM
		swigIntConstant( GL_COLOR_ARRAY_LIST_STRIDE_IBM, "GL_COLOR_ARRAY_LIST_STRIDE_IBM" );
	#endif
	#ifdef GL_INDEX_ARRAY_LIST_STRIDE_IBM
		swigIntConstant( GL_INDEX_ARRAY_LIST_STRIDE_IBM, "GL_INDEX_ARRAY_LIST_STRIDE_IBM" );
	#endif
	#ifdef GL_TEXTURE_COORD_ARRAY_LIST_STRIDE_IBM
		swigIntConstant( GL_TEXTURE_COORD_ARRAY_LIST_STRIDE_IBM, "GL_TEXTURE_COORD_ARRAY_LIST_STRIDE_IBM" );
	#endif
	#ifdef GL_EDGE_FLAG_ARRAY_LIST_STRIDE_IBM
		swigIntConstant( GL_EDGE_FLAG_ARRAY_LIST_STRIDE_IBM, "GL_EDGE_FLAG_ARRAY_LIST_STRIDE_IBM" );
	#endif
	#ifdef GL_FOG_COORDINATE_ARRAY_LIST_STRIDE_IBM
		swigIntConstant( GL_FOG_COORDINATE_ARRAY_LIST_STRIDE_IBM, "GL_FOG_COORDINATE_ARRAY_LIST_STRIDE_IBM" );
	#endif
	#ifdef GL_SECONDARY_COLOR_ARRAY_LIST_STRIDE_IBM
		swigIntConstant( GL_SECONDARY_COLOR_ARRAY_LIST_STRIDE_IBM, "GL_SECONDARY_COLOR_ARRAY_LIST_STRIDE_IBM" );
	#endif
	#ifdef GL_INGR_blend_func_separate
		swigIntConstant( GL_INGR_blend_func_separate, "GL_INGR_blend_func_separate" );
	#endif
	#ifdef GL_INGR_color_clamp
		swigIntConstant( GL_INGR_color_clamp, "GL_INGR_color_clamp" );
	#endif
	#ifdef GL_RED_MIN_CLAMP_INGR
		swigIntConstant( GL_RED_MIN_CLAMP_INGR, "GL_RED_MIN_CLAMP_INGR" );
	#endif
	#ifdef GL_GREEN_MIN_CLAMP_INGR
		swigIntConstant( GL_GREEN_MIN_CLAMP_INGR, "GL_GREEN_MIN_CLAMP_INGR" );
	#endif
	#ifdef GL_BLUE_MIN_CLAMP_INGR
		swigIntConstant( GL_BLUE_MIN_CLAMP_INGR, "GL_BLUE_MIN_CLAMP_INGR" );
	#endif
	#ifdef GL_ALPHA_MIN_CLAMP_INGR
		swigIntConstant( GL_ALPHA_MIN_CLAMP_INGR, "GL_ALPHA_MIN_CLAMP_INGR" );
	#endif
	#ifdef GL_RED_MAX_CLAMP_INGR
		swigIntConstant( GL_RED_MAX_CLAMP_INGR, "GL_RED_MAX_CLAMP_INGR" );
	#endif
	#ifdef GL_GREEN_MAX_CLAMP_INGR
		swigIntConstant( GL_GREEN_MAX_CLAMP_INGR, "GL_GREEN_MAX_CLAMP_INGR" );
	#endif
	#ifdef GL_BLUE_MAX_CLAMP_INGR
		swigIntConstant( GL_BLUE_MAX_CLAMP_INGR, "GL_BLUE_MAX_CLAMP_INGR" );
	#endif
	#ifdef GL_ALPHA_MAX_CLAMP_INGR
		swigIntConstant( GL_ALPHA_MAX_CLAMP_INGR, "GL_ALPHA_MAX_CLAMP_INGR" );
	#endif
	#ifdef GL_INGR_interlace_read
		swigIntConstant( GL_INGR_interlace_read, "GL_INGR_interlace_read" );
	#endif
	#ifdef GL_INTERLACE_READ_INGR
		swigIntConstant( GL_INTERLACE_READ_INGR, "GL_INTERLACE_READ_INGR" );
	#endif
	#ifdef GL_INTEL_blackhole_render
		swigIntConstant( GL_INTEL_blackhole_render, "GL_INTEL_blackhole_render" );
	#endif
	#ifdef GL_BLACKHOLE_RENDER_INTEL
		swigIntConstant( GL_BLACKHOLE_RENDER_INTEL, "GL_BLACKHOLE_RENDER_INTEL" );
	#endif
	#ifdef GL_INTEL_conservative_rasterization
		swigIntConstant( GL_INTEL_conservative_rasterization, "GL_INTEL_conservative_rasterization" );
	#endif
	#ifdef GL_CONSERVATIVE_RASTERIZATION_INTEL
		swigIntConstant( GL_CONSERVATIVE_RASTERIZATION_INTEL, "GL_CONSERVATIVE_RASTERIZATION_INTEL" );
	#endif
	#ifdef GL_INTEL_fragment_shader_ordering
		swigIntConstant( GL_INTEL_fragment_shader_ordering, "GL_INTEL_fragment_shader_ordering" );
	#endif
	#ifdef GL_INTEL_framebuffer_CMAA
		swigIntConstant( GL_INTEL_framebuffer_CMAA, "GL_INTEL_framebuffer_CMAA" );
	#endif
	#ifdef GL_INTEL_map_texture
		swigIntConstant( GL_INTEL_map_texture, "GL_INTEL_map_texture" );
	#endif
	#ifdef GL_TEXTURE_MEMORY_LAYOUT_INTEL
		swigIntConstant( GL_TEXTURE_MEMORY_LAYOUT_INTEL, "GL_TEXTURE_MEMORY_LAYOUT_INTEL" );
	#endif
	#ifdef GL_LAYOUT_DEFAULT_INTEL
		swigIntConstant( GL_LAYOUT_DEFAULT_INTEL, "GL_LAYOUT_DEFAULT_INTEL" );
	#endif
	#ifdef GL_LAYOUT_LINEAR_INTEL
		swigIntConstant( GL_LAYOUT_LINEAR_INTEL, "GL_LAYOUT_LINEAR_INTEL" );
	#endif
	#ifdef GL_LAYOUT_LINEAR_CPU_CACHED_INTEL
		swigIntConstant( GL_LAYOUT_LINEAR_CPU_CACHED_INTEL, "GL_LAYOUT_LINEAR_CPU_CACHED_INTEL" );
	#endif
	#ifdef GL_INTEL_parallel_arrays
		swigIntConstant( GL_INTEL_parallel_arrays, "GL_INTEL_parallel_arrays" );
	#endif
	#ifdef GL_PARALLEL_ARRAYS_INTEL
		swigIntConstant( GL_PARALLEL_ARRAYS_INTEL, "GL_PARALLEL_ARRAYS_INTEL" );
	#endif
	#ifdef GL_VERTEX_ARRAY_PARALLEL_POINTERS_INTEL
		swigIntConstant( GL_VERTEX_ARRAY_PARALLEL_POINTERS_INTEL, "GL_VERTEX_ARRAY_PARALLEL_POINTERS_INTEL" );
	#endif
	#ifdef GL_NORMAL_ARRAY_PARALLEL_POINTERS_INTEL
		swigIntConstant( GL_NORMAL_ARRAY_PARALLEL_POINTERS_INTEL, "GL_NORMAL_ARRAY_PARALLEL_POINTERS_INTEL" );
	#endif
	#ifdef GL_COLOR_ARRAY_PARALLEL_POINTERS_INTEL
		swigIntConstant( GL_COLOR_ARRAY_PARALLEL_POINTERS_INTEL, "GL_COLOR_ARRAY_PARALLEL_POINTERS_INTEL" );
	#endif
	#ifdef GL_TEXTURE_COORD_ARRAY_PARALLEL_POINTERS_INTEL
		swigIntConstant( GL_TEXTURE_COORD_ARRAY_PARALLEL_POINTERS_INTEL, "GL_TEXTURE_COORD_ARRAY_PARALLEL_POINTERS_INTEL" );
	#endif
	#ifdef GL_INTEL_performance_query
		swigIntConstant( GL_INTEL_performance_query, "GL_INTEL_performance_query" );
	#endif
	#ifdef GL_PERFQUERY_SINGLE_CONTEXT_INTEL
		swigIntConstant( GL_PERFQUERY_SINGLE_CONTEXT_INTEL, "GL_PERFQUERY_SINGLE_CONTEXT_INTEL" );
	#endif
	#ifdef GL_PERFQUERY_GLOBAL_CONTEXT_INTEL
		swigIntConstant( GL_PERFQUERY_GLOBAL_CONTEXT_INTEL, "GL_PERFQUERY_GLOBAL_CONTEXT_INTEL" );
	#endif
	#ifdef GL_PERFQUERY_WAIT_INTEL
		swigIntConstant( GL_PERFQUERY_WAIT_INTEL, "GL_PERFQUERY_WAIT_INTEL" );
	#endif
	#ifdef GL_PERFQUERY_FLUSH_INTEL
		swigIntConstant( GL_PERFQUERY_FLUSH_INTEL, "GL_PERFQUERY_FLUSH_INTEL" );
	#endif
	#ifdef GL_PERFQUERY_DONOT_FLUSH_INTEL
		swigIntConstant( GL_PERFQUERY_DONOT_FLUSH_INTEL, "GL_PERFQUERY_DONOT_FLUSH_INTEL" );
	#endif
	#ifdef GL_PERFQUERY_COUNTER_EVENT_INTEL
		swigIntConstant( GL_PERFQUERY_COUNTER_EVENT_INTEL, "GL_PERFQUERY_COUNTER_EVENT_INTEL" );
	#endif
	#ifdef GL_PERFQUERY_COUNTER_DURATION_NORM_INTEL
		swigIntConstant( GL_PERFQUERY_COUNTER_DURATION_NORM_INTEL, "GL_PERFQUERY_COUNTER_DURATION_NORM_INTEL" );
	#endif
	#ifdef GL_PERFQUERY_COUNTER_DURATION_RAW_INTEL
		swigIntConstant( GL_PERFQUERY_COUNTER_DURATION_RAW_INTEL, "GL_PERFQUERY_COUNTER_DURATION_RAW_INTEL" );
	#endif
	#ifdef GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL
		swigIntConstant( GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL, "GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL" );
	#endif
	#ifdef GL_PERFQUERY_COUNTER_RAW_INTEL
		swigIntConstant( GL_PERFQUERY_COUNTER_RAW_INTEL, "GL_PERFQUERY_COUNTER_RAW_INTEL" );
	#endif
	#ifdef GL_PERFQUERY_COUNTER_TIMESTAMP_INTEL
		swigIntConstant( GL_PERFQUERY_COUNTER_TIMESTAMP_INTEL, "GL_PERFQUERY_COUNTER_TIMESTAMP_INTEL" );
	#endif
	#ifdef GL_PERFQUERY_COUNTER_DATA_UINT32_INTEL
		swigIntConstant( GL_PERFQUERY_COUNTER_DATA_UINT32_INTEL, "GL_PERFQUERY_COUNTER_DATA_UINT32_INTEL" );
	#endif
	#ifdef GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL
		swigIntConstant( GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL, "GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL" );
	#endif
	#ifdef GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL
		swigIntConstant( GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL, "GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL" );
	#endif
	#ifdef GL_PERFQUERY_COUNTER_DATA_DOUBLE_INTEL
		swigIntConstant( GL_PERFQUERY_COUNTER_DATA_DOUBLE_INTEL, "GL_PERFQUERY_COUNTER_DATA_DOUBLE_INTEL" );
	#endif
	#ifdef GL_PERFQUERY_COUNTER_DATA_BOOL32_INTEL
		swigIntConstant( GL_PERFQUERY_COUNTER_DATA_BOOL32_INTEL, "GL_PERFQUERY_COUNTER_DATA_BOOL32_INTEL" );
	#endif
	#ifdef GL_PERFQUERY_QUERY_NAME_LENGTH_MAX_INTEL
		swigIntConstant( GL_PERFQUERY_QUERY_NAME_LENGTH_MAX_INTEL, "GL_PERFQUERY_QUERY_NAME_LENGTH_MAX_INTEL" );
	#endif
	#ifdef GL_PERFQUERY_COUNTER_NAME_LENGTH_MAX_INTEL
		swigIntConstant( GL_PERFQUERY_COUNTER_NAME_LENGTH_MAX_INTEL, "GL_PERFQUERY_COUNTER_NAME_LENGTH_MAX_INTEL" );
	#endif
	#ifdef GL_PERFQUERY_COUNTER_DESC_LENGTH_MAX_INTEL
		swigIntConstant( GL_PERFQUERY_COUNTER_DESC_LENGTH_MAX_INTEL, "GL_PERFQUERY_COUNTER_DESC_LENGTH_MAX_INTEL" );
	#endif
	#ifdef GL_PERFQUERY_GPA_EXTENDED_COUNTERS_INTEL
		swigIntConstant( GL_PERFQUERY_GPA_EXTENDED_COUNTERS_INTEL, "GL_PERFQUERY_GPA_EXTENDED_COUNTERS_INTEL" );
	#endif
	#ifdef GL_MESAX_texture_stack
		swigIntConstant( GL_MESAX_texture_stack, "GL_MESAX_texture_stack" );
	#endif
	#ifdef GL_TEXTURE_1D_STACK_MESAX
		swigIntConstant( GL_TEXTURE_1D_STACK_MESAX, "GL_TEXTURE_1D_STACK_MESAX" );
	#endif
	#ifdef GL_TEXTURE_2D_STACK_MESAX
		swigIntConstant( GL_TEXTURE_2D_STACK_MESAX, "GL_TEXTURE_2D_STACK_MESAX" );
	#endif
	#ifdef GL_PROXY_TEXTURE_1D_STACK_MESAX
		swigIntConstant( GL_PROXY_TEXTURE_1D_STACK_MESAX, "GL_PROXY_TEXTURE_1D_STACK_MESAX" );
	#endif
	#ifdef GL_PROXY_TEXTURE_2D_STACK_MESAX
		swigIntConstant( GL_PROXY_TEXTURE_2D_STACK_MESAX, "GL_PROXY_TEXTURE_2D_STACK_MESAX" );
	#endif
	#ifdef GL_TEXTURE_1D_STACK_BINDING_MESAX
		swigIntConstant( GL_TEXTURE_1D_STACK_BINDING_MESAX, "GL_TEXTURE_1D_STACK_BINDING_MESAX" );
	#endif
	#ifdef GL_TEXTURE_2D_STACK_BINDING_MESAX
		swigIntConstant( GL_TEXTURE_2D_STACK_BINDING_MESAX, "GL_TEXTURE_2D_STACK_BINDING_MESAX" );
	#endif
	#ifdef GL_MESA_framebuffer_flip_x
		swigIntConstant( GL_MESA_framebuffer_flip_x, "GL_MESA_framebuffer_flip_x" );
	#endif
	#ifdef GL_FRAMEBUFFER_FLIP_X_MESA
		swigIntConstant( GL_FRAMEBUFFER_FLIP_X_MESA, "GL_FRAMEBUFFER_FLIP_X_MESA" );
	#endif
	#ifdef GL_MESA_framebuffer_flip_y
		swigIntConstant( GL_MESA_framebuffer_flip_y, "GL_MESA_framebuffer_flip_y" );
	#endif
	#ifdef GL_FRAMEBUFFER_FLIP_Y_MESA
		swigIntConstant( GL_FRAMEBUFFER_FLIP_Y_MESA, "GL_FRAMEBUFFER_FLIP_Y_MESA" );
	#endif
	#ifdef GL_MESA_framebuffer_swap_xy
		swigIntConstant( GL_MESA_framebuffer_swap_xy, "GL_MESA_framebuffer_swap_xy" );
	#endif
	#ifdef GL_FRAMEBUFFER_SWAP_XY_MESA
		swigIntConstant( GL_FRAMEBUFFER_SWAP_XY_MESA, "GL_FRAMEBUFFER_SWAP_XY_MESA" );
	#endif
	#ifdef GL_MESA_pack_invert
		swigIntConstant( GL_MESA_pack_invert, "GL_MESA_pack_invert" );
	#endif
	#ifdef GL_PACK_INVERT_MESA
		swigIntConstant( GL_PACK_INVERT_MESA, "GL_PACK_INVERT_MESA" );
	#endif
	#ifdef GL_MESA_program_binary_formats
		swigIntConstant( GL_MESA_program_binary_formats, "GL_MESA_program_binary_formats" );
	#endif
	#ifdef GL_PROGRAM_BINARY_FORMAT_MESA
		swigIntConstant( GL_PROGRAM_BINARY_FORMAT_MESA, "GL_PROGRAM_BINARY_FORMAT_MESA" );
	#endif
	#ifdef GL_MESA_resize_buffers
		swigIntConstant( GL_MESA_resize_buffers, "GL_MESA_resize_buffers" );
	#endif
	#ifdef GL_MESA_shader_integer_functions
		swigIntConstant( GL_MESA_shader_integer_functions, "GL_MESA_shader_integer_functions" );
	#endif
	#ifdef GL_MESA_texture_const_bandwidth
		swigIntConstant( GL_MESA_texture_const_bandwidth, "GL_MESA_texture_const_bandwidth" );
	#endif
	#ifdef GL_CONST_BW_TILING_MESA
		swigIntConstant( GL_CONST_BW_TILING_MESA, "GL_CONST_BW_TILING_MESA" );
	#endif
	#ifdef GL_MESA_tile_raster_order
		swigIntConstant( GL_MESA_tile_raster_order, "GL_MESA_tile_raster_order" );
	#endif
	#ifdef GL_TILE_RASTER_ORDER_FIXED_MESA
		swigIntConstant( GL_TILE_RASTER_ORDER_FIXED_MESA, "GL_TILE_RASTER_ORDER_FIXED_MESA" );
	#endif
	#ifdef GL_TILE_RASTER_ORDER_INCREASING_X_MESA
		swigIntConstant( GL_TILE_RASTER_ORDER_INCREASING_X_MESA, "GL_TILE_RASTER_ORDER_INCREASING_X_MESA" );
	#endif
	#ifdef GL_TILE_RASTER_ORDER_INCREASING_Y_MESA
		swigIntConstant( GL_TILE_RASTER_ORDER_INCREASING_Y_MESA, "GL_TILE_RASTER_ORDER_INCREASING_Y_MESA" );
	#endif
	#ifdef GL_MESA_window_pos
		swigIntConstant( GL_MESA_window_pos, "GL_MESA_window_pos" );
	#endif
	#ifdef GL_MESA_ycbcr_texture
		swigIntConstant( GL_MESA_ycbcr_texture, "GL_MESA_ycbcr_texture" );
	#endif
	#ifdef GL_UNSIGNED_SHORT_8_8_MESA
		swigIntConstant( GL_UNSIGNED_SHORT_8_8_MESA, "GL_UNSIGNED_SHORT_8_8_MESA" );
	#endif
	#ifdef GL_UNSIGNED_SHORT_8_8_REV_MESA
		swigIntConstant( GL_UNSIGNED_SHORT_8_8_REV_MESA, "GL_UNSIGNED_SHORT_8_8_REV_MESA" );
	#endif
	#ifdef GL_YCBCR_MESA
		swigIntConstant( GL_YCBCR_MESA, "GL_YCBCR_MESA" );
	#endif
	#ifdef GL_NVX_blend_equation_advanced_multi_draw_buffers
		swigIntConstant( GL_NVX_blend_equation_advanced_multi_draw_buffers, "GL_NVX_blend_equation_advanced_multi_draw_buffers" );
	#endif
	#ifdef GL_NVX_conditional_render
		swigIntConstant( GL_NVX_conditional_render, "GL_NVX_conditional_render" );
	#endif
	#ifdef GL_NVX_gpu_memory_info
		swigIntConstant( GL_NVX_gpu_memory_info, "GL_NVX_gpu_memory_info" );
	#endif
	#ifdef GL_GPU_MEMORY_INFO_DEDICATED_VIDMEM_NVX
		swigIntConstant( GL_GPU_MEMORY_INFO_DEDICATED_VIDMEM_NVX, "GL_GPU_MEMORY_INFO_DEDICATED_VIDMEM_NVX" );
	#endif
	#ifdef GL_GPU_MEMORY_INFO_TOTAL_AVAILABLE_MEMORY_NVX
		swigIntConstant( GL_GPU_MEMORY_INFO_TOTAL_AVAILABLE_MEMORY_NVX, "GL_GPU_MEMORY_INFO_TOTAL_AVAILABLE_MEMORY_NVX" );
	#endif
	#ifdef GL_GPU_MEMORY_INFO_CURRENT_AVAILABLE_VIDMEM_NVX
		swigIntConstant( GL_GPU_MEMORY_INFO_CURRENT_AVAILABLE_VIDMEM_NVX, "GL_GPU_MEMORY_INFO_CURRENT_AVAILABLE_VIDMEM_NVX" );
	#endif
	#ifdef GL_GPU_MEMORY_INFO_EVICTION_COUNT_NVX
		swigIntConstant( GL_GPU_MEMORY_INFO_EVICTION_COUNT_NVX, "GL_GPU_MEMORY_INFO_EVICTION_COUNT_NVX" );
	#endif
	#ifdef GL_GPU_MEMORY_INFO_EVICTED_MEMORY_NVX
		swigIntConstant( GL_GPU_MEMORY_INFO_EVICTED_MEMORY_NVX, "GL_GPU_MEMORY_INFO_EVICTED_MEMORY_NVX" );
	#endif
	#ifdef GL_NVX_gpu_multicast2
		swigIntConstant( GL_NVX_gpu_multicast2, "GL_NVX_gpu_multicast2" );
	#endif
	#ifdef GL_UPLOAD_GPU_MASK_NVX
		swigIntConstant( GL_UPLOAD_GPU_MASK_NVX, "GL_UPLOAD_GPU_MASK_NVX" );
	#endif
	#ifdef GL_NVX_linked_gpu_multicast
		swigIntConstant( GL_NVX_linked_gpu_multicast, "GL_NVX_linked_gpu_multicast" );
	#endif
	#ifdef GL_LGPU_SEPARATE_STORAGE_BIT_NVX
		swigIntConstant( GL_LGPU_SEPARATE_STORAGE_BIT_NVX, "GL_LGPU_SEPARATE_STORAGE_BIT_NVX" );
	#endif
	#ifdef GL_MAX_LGPU_GPUS_NVX
		swigIntConstant( GL_MAX_LGPU_GPUS_NVX, "GL_MAX_LGPU_GPUS_NVX" );
	#endif
	#ifdef GL_NVX_progress_fence
		swigIntConstant( GL_NVX_progress_fence, "GL_NVX_progress_fence" );
	#endif
	#ifdef GL_NV_alpha_to_coverage_dither_control
		swigIntConstant( GL_NV_alpha_to_coverage_dither_control, "GL_NV_alpha_to_coverage_dither_control" );
	#endif
	#ifdef GL_ALPHA_TO_COVERAGE_DITHER_DEFAULT_NV
		swigIntConstant( GL_ALPHA_TO_COVERAGE_DITHER_DEFAULT_NV, "GL_ALPHA_TO_COVERAGE_DITHER_DEFAULT_NV" );
	#endif
	#ifdef GL_ALPHA_TO_COVERAGE_DITHER_ENABLE_NV
		swigIntConstant( GL_ALPHA_TO_COVERAGE_DITHER_ENABLE_NV, "GL_ALPHA_TO_COVERAGE_DITHER_ENABLE_NV" );
	#endif
	#ifdef GL_ALPHA_TO_COVERAGE_DITHER_DISABLE_NV
		swigIntConstant( GL_ALPHA_TO_COVERAGE_DITHER_DISABLE_NV, "GL_ALPHA_TO_COVERAGE_DITHER_DISABLE_NV" );
	#endif
	#ifdef GL_ALPHA_TO_COVERAGE_DITHER_MODE_NV
		swigIntConstant( GL_ALPHA_TO_COVERAGE_DITHER_MODE_NV, "GL_ALPHA_TO_COVERAGE_DITHER_MODE_NV" );
	#endif
	#ifdef GL_NV_bindless_multi_draw_indirect
		swigIntConstant( GL_NV_bindless_multi_draw_indirect, "GL_NV_bindless_multi_draw_indirect" );
	#endif
	#ifdef GL_NV_bindless_multi_draw_indirect_count
		swigIntConstant( GL_NV_bindless_multi_draw_indirect_count, "GL_NV_bindless_multi_draw_indirect_count" );
	#endif
	#ifdef GL_NV_bindless_texture
		swigIntConstant( GL_NV_bindless_texture, "GL_NV_bindless_texture" );
	#endif
	#ifdef GL_NV_blend_equation_advanced
		swigIntConstant( GL_NV_blend_equation_advanced, "GL_NV_blend_equation_advanced" );
	#endif
	#ifdef GL_BLEND_OVERLAP_NV
		swigIntConstant( GL_BLEND_OVERLAP_NV, "GL_BLEND_OVERLAP_NV" );
	#endif
	#ifdef GL_BLEND_PREMULTIPLIED_SRC_NV
		swigIntConstant( GL_BLEND_PREMULTIPLIED_SRC_NV, "GL_BLEND_PREMULTIPLIED_SRC_NV" );
	#endif
	#ifdef GL_BLUE_NV
		swigIntConstant( GL_BLUE_NV, "GL_BLUE_NV" );
	#endif
	#ifdef GL_COLORBURN_NV
		swigIntConstant( GL_COLORBURN_NV, "GL_COLORBURN_NV" );
	#endif
	#ifdef GL_COLORDODGE_NV
		swigIntConstant( GL_COLORDODGE_NV, "GL_COLORDODGE_NV" );
	#endif
	#ifdef GL_CONJOINT_NV
		swigIntConstant( GL_CONJOINT_NV, "GL_CONJOINT_NV" );
	#endif
	#ifdef GL_CONTRAST_NV
		swigIntConstant( GL_CONTRAST_NV, "GL_CONTRAST_NV" );
	#endif
	#ifdef GL_DARKEN_NV
		swigIntConstant( GL_DARKEN_NV, "GL_DARKEN_NV" );
	#endif
	#ifdef GL_DIFFERENCE_NV
		swigIntConstant( GL_DIFFERENCE_NV, "GL_DIFFERENCE_NV" );
	#endif
	#ifdef GL_DISJOINT_NV
		swigIntConstant( GL_DISJOINT_NV, "GL_DISJOINT_NV" );
	#endif
	#ifdef GL_DST_ATOP_NV
		swigIntConstant( GL_DST_ATOP_NV, "GL_DST_ATOP_NV" );
	#endif
	#ifdef GL_DST_IN_NV
		swigIntConstant( GL_DST_IN_NV, "GL_DST_IN_NV" );
	#endif
	#ifdef GL_DST_NV
		swigIntConstant( GL_DST_NV, "GL_DST_NV" );
	#endif
	#ifdef GL_DST_OUT_NV
		swigIntConstant( GL_DST_OUT_NV, "GL_DST_OUT_NV" );
	#endif
	#ifdef GL_DST_OVER_NV
		swigIntConstant( GL_DST_OVER_NV, "GL_DST_OVER_NV" );
	#endif
	#ifdef GL_EXCLUSION_NV
		swigIntConstant( GL_EXCLUSION_NV, "GL_EXCLUSION_NV" );
	#endif
	#ifdef GL_GREEN_NV
		swigIntConstant( GL_GREEN_NV, "GL_GREEN_NV" );
	#endif
	#ifdef GL_HARDLIGHT_NV
		swigIntConstant( GL_HARDLIGHT_NV, "GL_HARDLIGHT_NV" );
	#endif
	#ifdef GL_HARDMIX_NV
		swigIntConstant( GL_HARDMIX_NV, "GL_HARDMIX_NV" );
	#endif
	#ifdef GL_HSL_COLOR_NV
		swigIntConstant( GL_HSL_COLOR_NV, "GL_HSL_COLOR_NV" );
	#endif
	#ifdef GL_HSL_HUE_NV
		swigIntConstant( GL_HSL_HUE_NV, "GL_HSL_HUE_NV" );
	#endif
	#ifdef GL_HSL_LUMINOSITY_NV
		swigIntConstant( GL_HSL_LUMINOSITY_NV, "GL_HSL_LUMINOSITY_NV" );
	#endif
	#ifdef GL_HSL_SATURATION_NV
		swigIntConstant( GL_HSL_SATURATION_NV, "GL_HSL_SATURATION_NV" );
	#endif
	#ifdef GL_INVERT_OVG_NV
		swigIntConstant( GL_INVERT_OVG_NV, "GL_INVERT_OVG_NV" );
	#endif
	#ifdef GL_INVERT_RGB_NV
		swigIntConstant( GL_INVERT_RGB_NV, "GL_INVERT_RGB_NV" );
	#endif
	#ifdef GL_LIGHTEN_NV
		swigIntConstant( GL_LIGHTEN_NV, "GL_LIGHTEN_NV" );
	#endif
	#ifdef GL_LINEARBURN_NV
		swigIntConstant( GL_LINEARBURN_NV, "GL_LINEARBURN_NV" );
	#endif
	#ifdef GL_LINEARDODGE_NV
		swigIntConstant( GL_LINEARDODGE_NV, "GL_LINEARDODGE_NV" );
	#endif
	#ifdef GL_LINEARLIGHT_NV
		swigIntConstant( GL_LINEARLIGHT_NV, "GL_LINEARLIGHT_NV" );
	#endif
	#ifdef GL_MINUS_CLAMPED_NV
		swigIntConstant( GL_MINUS_CLAMPED_NV, "GL_MINUS_CLAMPED_NV" );
	#endif
	#ifdef GL_MINUS_NV
		swigIntConstant( GL_MINUS_NV, "GL_MINUS_NV" );
	#endif
	#ifdef GL_MULTIPLY_NV
		swigIntConstant( GL_MULTIPLY_NV, "GL_MULTIPLY_NV" );
	#endif
	#ifdef GL_OVERLAY_NV
		swigIntConstant( GL_OVERLAY_NV, "GL_OVERLAY_NV" );
	#endif
	#ifdef GL_PINLIGHT_NV
		swigIntConstant( GL_PINLIGHT_NV, "GL_PINLIGHT_NV" );
	#endif
	#ifdef GL_PLUS_CLAMPED_ALPHA_NV
		swigIntConstant( GL_PLUS_CLAMPED_ALPHA_NV, "GL_PLUS_CLAMPED_ALPHA_NV" );
	#endif
	#ifdef GL_PLUS_CLAMPED_NV
		swigIntConstant( GL_PLUS_CLAMPED_NV, "GL_PLUS_CLAMPED_NV" );
	#endif
	#ifdef GL_PLUS_DARKER_NV
		swigIntConstant( GL_PLUS_DARKER_NV, "GL_PLUS_DARKER_NV" );
	#endif
	#ifdef GL_PLUS_NV
		swigIntConstant( GL_PLUS_NV, "GL_PLUS_NV" );
	#endif
	#ifdef GL_RED_NV
		swigIntConstant( GL_RED_NV, "GL_RED_NV" );
	#endif
	#ifdef GL_SCREEN_NV
		swigIntConstant( GL_SCREEN_NV, "GL_SCREEN_NV" );
	#endif
	#ifdef GL_SOFTLIGHT_NV
		swigIntConstant( GL_SOFTLIGHT_NV, "GL_SOFTLIGHT_NV" );
	#endif
	#ifdef GL_SRC_ATOP_NV
		swigIntConstant( GL_SRC_ATOP_NV, "GL_SRC_ATOP_NV" );
	#endif
	#ifdef GL_SRC_IN_NV
		swigIntConstant( GL_SRC_IN_NV, "GL_SRC_IN_NV" );
	#endif
	#ifdef GL_SRC_NV
		swigIntConstant( GL_SRC_NV, "GL_SRC_NV" );
	#endif
	#ifdef GL_SRC_OUT_NV
		swigIntConstant( GL_SRC_OUT_NV, "GL_SRC_OUT_NV" );
	#endif
	#ifdef GL_SRC_OVER_NV
		swigIntConstant( GL_SRC_OVER_NV, "GL_SRC_OVER_NV" );
	#endif
	#ifdef GL_UNCORRELATED_NV
		swigIntConstant( GL_UNCORRELATED_NV, "GL_UNCORRELATED_NV" );
	#endif
	#ifdef GL_VIVIDLIGHT_NV
		swigIntConstant( GL_VIVIDLIGHT_NV, "GL_VIVIDLIGHT_NV" );
	#endif
	#ifdef GL_XOR_NV
		swigIntConstant( GL_XOR_NV, "GL_XOR_NV" );
	#endif
	#ifdef GL_NV_blend_equation_advanced_coherent
		swigIntConstant( GL_NV_blend_equation_advanced_coherent, "GL_NV_blend_equation_advanced_coherent" );
	#endif
	#ifdef GL_BLEND_ADVANCED_COHERENT_NV
		swigIntConstant( GL_BLEND_ADVANCED_COHERENT_NV, "GL_BLEND_ADVANCED_COHERENT_NV" );
	#endif
	#ifdef GL_NV_blend_minmax_factor
		swigIntConstant( GL_NV_blend_minmax_factor, "GL_NV_blend_minmax_factor" );
	#endif
	#ifdef GL_NV_blend_square
		swigIntConstant( GL_NV_blend_square, "GL_NV_blend_square" );
	#endif
	#ifdef GL_NV_clip_space_w_scaling
		swigIntConstant( GL_NV_clip_space_w_scaling, "GL_NV_clip_space_w_scaling" );
	#endif
	#ifdef GL_VIEWPORT_POSITION_W_SCALE_NV
		swigIntConstant( GL_VIEWPORT_POSITION_W_SCALE_NV, "GL_VIEWPORT_POSITION_W_SCALE_NV" );
	#endif
	#ifdef GL_VIEWPORT_POSITION_W_SCALE_X_COEFF_NV
		swigIntConstant( GL_VIEWPORT_POSITION_W_SCALE_X_COEFF_NV, "GL_VIEWPORT_POSITION_W_SCALE_X_COEFF_NV" );
	#endif
	#ifdef GL_VIEWPORT_POSITION_W_SCALE_Y_COEFF_NV
		swigIntConstant( GL_VIEWPORT_POSITION_W_SCALE_Y_COEFF_NV, "GL_VIEWPORT_POSITION_W_SCALE_Y_COEFF_NV" );
	#endif
	#ifdef GL_NV_command_list
		swigIntConstant( GL_NV_command_list, "GL_NV_command_list" );
	#endif
	#ifdef GL_TERMINATE_SEQUENCE_COMMAND_NV
		swigIntConstant( GL_TERMINATE_SEQUENCE_COMMAND_NV, "GL_TERMINATE_SEQUENCE_COMMAND_NV" );
	#endif
	#ifdef GL_NOP_COMMAND_NV
		swigIntConstant( GL_NOP_COMMAND_NV, "GL_NOP_COMMAND_NV" );
	#endif
	#ifdef GL_DRAW_ELEMENTS_COMMAND_NV
		swigIntConstant( GL_DRAW_ELEMENTS_COMMAND_NV, "GL_DRAW_ELEMENTS_COMMAND_NV" );
	#endif
	#ifdef GL_DRAW_ARRAYS_COMMAND_NV
		swigIntConstant( GL_DRAW_ARRAYS_COMMAND_NV, "GL_DRAW_ARRAYS_COMMAND_NV" );
	#endif
	#ifdef GL_DRAW_ELEMENTS_STRIP_COMMAND_NV
		swigIntConstant( GL_DRAW_ELEMENTS_STRIP_COMMAND_NV, "GL_DRAW_ELEMENTS_STRIP_COMMAND_NV" );
	#endif
	#ifdef GL_DRAW_ARRAYS_STRIP_COMMAND_NV
		swigIntConstant( GL_DRAW_ARRAYS_STRIP_COMMAND_NV, "GL_DRAW_ARRAYS_STRIP_COMMAND_NV" );
	#endif
	#ifdef GL_DRAW_ELEMENTS_INSTANCED_COMMAND_NV
		swigIntConstant( GL_DRAW_ELEMENTS_INSTANCED_COMMAND_NV, "GL_DRAW_ELEMENTS_INSTANCED_COMMAND_NV" );
	#endif
	#ifdef GL_DRAW_ARRAYS_INSTANCED_COMMAND_NV
		swigIntConstant( GL_DRAW_ARRAYS_INSTANCED_COMMAND_NV, "GL_DRAW_ARRAYS_INSTANCED_COMMAND_NV" );
	#endif
	#ifdef GL_ELEMENT_ADDRESS_COMMAND_NV
		swigIntConstant( GL_ELEMENT_ADDRESS_COMMAND_NV, "GL_ELEMENT_ADDRESS_COMMAND_NV" );
	#endif
	#ifdef GL_ATTRIBUTE_ADDRESS_COMMAND_NV
		swigIntConstant( GL_ATTRIBUTE_ADDRESS_COMMAND_NV, "GL_ATTRIBUTE_ADDRESS_COMMAND_NV" );
	#endif
	#ifdef GL_UNIFORM_ADDRESS_COMMAND_NV
		swigIntConstant( GL_UNIFORM_ADDRESS_COMMAND_NV, "GL_UNIFORM_ADDRESS_COMMAND_NV" );
	#endif
	#ifdef GL_BLEND_COLOR_COMMAND_NV
		swigIntConstant( GL_BLEND_COLOR_COMMAND_NV, "GL_BLEND_COLOR_COMMAND_NV" );
	#endif
	#ifdef GL_STENCIL_REF_COMMAND_NV
		swigIntConstant( GL_STENCIL_REF_COMMAND_NV, "GL_STENCIL_REF_COMMAND_NV" );
	#endif
	#ifdef GL_LINE_WIDTH_COMMAND_NV
		swigIntConstant( GL_LINE_WIDTH_COMMAND_NV, "GL_LINE_WIDTH_COMMAND_NV" );
	#endif
	#ifdef GL_POLYGON_OFFSET_COMMAND_NV
		swigIntConstant( GL_POLYGON_OFFSET_COMMAND_NV, "GL_POLYGON_OFFSET_COMMAND_NV" );
	#endif
	#ifdef GL_ALPHA_REF_COMMAND_NV
		swigIntConstant( GL_ALPHA_REF_COMMAND_NV, "GL_ALPHA_REF_COMMAND_NV" );
	#endif
	#ifdef GL_VIEWPORT_COMMAND_NV
		swigIntConstant( GL_VIEWPORT_COMMAND_NV, "GL_VIEWPORT_COMMAND_NV" );
	#endif
	#ifdef GL_SCISSOR_COMMAND_NV
		swigIntConstant( GL_SCISSOR_COMMAND_NV, "GL_SCISSOR_COMMAND_NV" );
	#endif
	#ifdef GL_FRONT_FACE_COMMAND_NV
		swigIntConstant( GL_FRONT_FACE_COMMAND_NV, "GL_FRONT_FACE_COMMAND_NV" );
	#endif
	#ifdef GL_NV_compute_program5
		swigIntConstant( GL_NV_compute_program5, "GL_NV_compute_program5" );
	#endif
	#ifdef GL_COMPUTE_PROGRAM_NV
		swigIntConstant( GL_COMPUTE_PROGRAM_NV, "GL_COMPUTE_PROGRAM_NV" );
	#endif
	#ifdef GL_COMPUTE_PROGRAM_PARAMETER_BUFFER_NV
		swigIntConstant( GL_COMPUTE_PROGRAM_PARAMETER_BUFFER_NV, "GL_COMPUTE_PROGRAM_PARAMETER_BUFFER_NV" );
	#endif
	#ifdef GL_NV_compute_shader_derivatives
		swigIntConstant( GL_NV_compute_shader_derivatives, "GL_NV_compute_shader_derivatives" );
	#endif
	#ifdef GL_NV_conditional_render
		swigIntConstant( GL_NV_conditional_render, "GL_NV_conditional_render" );
	#endif
	#ifdef GL_QUERY_WAIT_NV
		swigIntConstant( GL_QUERY_WAIT_NV, "GL_QUERY_WAIT_NV" );
	#endif
	#ifdef GL_QUERY_NO_WAIT_NV
		swigIntConstant( GL_QUERY_NO_WAIT_NV, "GL_QUERY_NO_WAIT_NV" );
	#endif
	#ifdef GL_QUERY_BY_REGION_WAIT_NV
		swigIntConstant( GL_QUERY_BY_REGION_WAIT_NV, "GL_QUERY_BY_REGION_WAIT_NV" );
	#endif
	#ifdef GL_QUERY_BY_REGION_NO_WAIT_NV
		swigIntConstant( GL_QUERY_BY_REGION_NO_WAIT_NV, "GL_QUERY_BY_REGION_NO_WAIT_NV" );
	#endif
	#ifdef GL_NV_conservative_raster
		swigIntConstant( GL_NV_conservative_raster, "GL_NV_conservative_raster" );
	#endif
	#ifdef GL_CONSERVATIVE_RASTERIZATION_NV
		swigIntConstant( GL_CONSERVATIVE_RASTERIZATION_NV, "GL_CONSERVATIVE_RASTERIZATION_NV" );
	#endif
	#ifdef GL_SUBPIXEL_PRECISION_BIAS_X_BITS_NV
		swigIntConstant( GL_SUBPIXEL_PRECISION_BIAS_X_BITS_NV, "GL_SUBPIXEL_PRECISION_BIAS_X_BITS_NV" );
	#endif
	#ifdef GL_SUBPIXEL_PRECISION_BIAS_Y_BITS_NV
		swigIntConstant( GL_SUBPIXEL_PRECISION_BIAS_Y_BITS_NV, "GL_SUBPIXEL_PRECISION_BIAS_Y_BITS_NV" );
	#endif
	#ifdef GL_MAX_SUBPIXEL_PRECISION_BIAS_BITS_NV
		swigIntConstant( GL_MAX_SUBPIXEL_PRECISION_BIAS_BITS_NV, "GL_MAX_SUBPIXEL_PRECISION_BIAS_BITS_NV" );
	#endif
	#ifdef GL_NV_conservative_raster_dilate
		swigIntConstant( GL_NV_conservative_raster_dilate, "GL_NV_conservative_raster_dilate" );
	#endif
	#ifdef GL_CONSERVATIVE_RASTER_DILATE_NV
		swigIntConstant( GL_CONSERVATIVE_RASTER_DILATE_NV, "GL_CONSERVATIVE_RASTER_DILATE_NV" );
	#endif
	#ifdef GL_CONSERVATIVE_RASTER_DILATE_RANGE_NV
		swigIntConstant( GL_CONSERVATIVE_RASTER_DILATE_RANGE_NV, "GL_CONSERVATIVE_RASTER_DILATE_RANGE_NV" );
	#endif
	#ifdef GL_CONSERVATIVE_RASTER_DILATE_GRANULARITY_NV
		swigIntConstant( GL_CONSERVATIVE_RASTER_DILATE_GRANULARITY_NV, "GL_CONSERVATIVE_RASTER_DILATE_GRANULARITY_NV" );
	#endif
	#ifdef GL_NV_conservative_raster_pre_snap
		swigIntConstant( GL_NV_conservative_raster_pre_snap, "GL_NV_conservative_raster_pre_snap" );
	#endif
	#ifdef GL_CONSERVATIVE_RASTER_MODE_PRE_SNAP_NV
		swigIntConstant( GL_CONSERVATIVE_RASTER_MODE_PRE_SNAP_NV, "GL_CONSERVATIVE_RASTER_MODE_PRE_SNAP_NV" );
	#endif
	#ifdef GL_NV_conservative_raster_pre_snap_triangles
		swigIntConstant( GL_NV_conservative_raster_pre_snap_triangles, "GL_NV_conservative_raster_pre_snap_triangles" );
	#endif
	#ifdef GL_CONSERVATIVE_RASTER_MODE_NV
		swigIntConstant( GL_CONSERVATIVE_RASTER_MODE_NV, "GL_CONSERVATIVE_RASTER_MODE_NV" );
	#endif
	#ifdef GL_CONSERVATIVE_RASTER_MODE_POST_SNAP_NV
		swigIntConstant( GL_CONSERVATIVE_RASTER_MODE_POST_SNAP_NV, "GL_CONSERVATIVE_RASTER_MODE_POST_SNAP_NV" );
	#endif
	#ifdef GL_CONSERVATIVE_RASTER_MODE_PRE_SNAP_TRIANGLES_NV
		swigIntConstant( GL_CONSERVATIVE_RASTER_MODE_PRE_SNAP_TRIANGLES_NV, "GL_CONSERVATIVE_RASTER_MODE_PRE_SNAP_TRIANGLES_NV" );
	#endif
	#ifdef GL_NV_conservative_raster_underestimation
		swigIntConstant( GL_NV_conservative_raster_underestimation, "GL_NV_conservative_raster_underestimation" );
	#endif
	#ifdef GL_NV_copy_depth_to_color
		swigIntConstant( GL_NV_copy_depth_to_color, "GL_NV_copy_depth_to_color" );
	#endif
	#ifdef GL_DEPTH_STENCIL_TO_RGBA_NV
		swigIntConstant( GL_DEPTH_STENCIL_TO_RGBA_NV, "GL_DEPTH_STENCIL_TO_RGBA_NV" );
	#endif
	#ifdef GL_DEPTH_STENCIL_TO_BGRA_NV
		swigIntConstant( GL_DEPTH_STENCIL_TO_BGRA_NV, "GL_DEPTH_STENCIL_TO_BGRA_NV" );
	#endif
	#ifdef GL_NV_copy_image
		swigIntConstant( GL_NV_copy_image, "GL_NV_copy_image" );
	#endif
	#ifdef GL_NV_deep_texture3D
		swigIntConstant( GL_NV_deep_texture3D, "GL_NV_deep_texture3D" );
	#endif
	#ifdef GL_MAX_DEEP_3D_TEXTURE_WIDTH_HEIGHT_NV
		swigIntConstant( GL_MAX_DEEP_3D_TEXTURE_WIDTH_HEIGHT_NV, "GL_MAX_DEEP_3D_TEXTURE_WIDTH_HEIGHT_NV" );
	#endif
	#ifdef GL_MAX_DEEP_3D_TEXTURE_DEPTH_NV
		swigIntConstant( GL_MAX_DEEP_3D_TEXTURE_DEPTH_NV, "GL_MAX_DEEP_3D_TEXTURE_DEPTH_NV" );
	#endif
	#ifdef GL_NV_depth_buffer_float
		swigIntConstant( GL_NV_depth_buffer_float, "GL_NV_depth_buffer_float" );
	#endif
	#ifdef GL_DEPTH_COMPONENT32F_NV
		swigIntConstant( GL_DEPTH_COMPONENT32F_NV, "GL_DEPTH_COMPONENT32F_NV" );
	#endif
	#ifdef GL_DEPTH32F_STENCIL8_NV
		swigIntConstant( GL_DEPTH32F_STENCIL8_NV, "GL_DEPTH32F_STENCIL8_NV" );
	#endif
	#ifdef GL_FLOAT_32_UNSIGNED_INT_24_8_REV_NV
		swigIntConstant( GL_FLOAT_32_UNSIGNED_INT_24_8_REV_NV, "GL_FLOAT_32_UNSIGNED_INT_24_8_REV_NV" );
	#endif
	#ifdef GL_DEPTH_BUFFER_FLOAT_MODE_NV
		swigIntConstant( GL_DEPTH_BUFFER_FLOAT_MODE_NV, "GL_DEPTH_BUFFER_FLOAT_MODE_NV" );
	#endif
	#ifdef GL_NV_depth_clamp
		swigIntConstant( GL_NV_depth_clamp, "GL_NV_depth_clamp" );
	#endif
	#ifdef GL_DEPTH_CLAMP_NV
		swigIntConstant( GL_DEPTH_CLAMP_NV, "GL_DEPTH_CLAMP_NV" );
	#endif
	#ifdef GL_NV_draw_texture
		swigIntConstant( GL_NV_draw_texture, "GL_NV_draw_texture" );
	#endif
	#ifdef GL_NV_draw_vulkan_image
		swigIntConstant( GL_NV_draw_vulkan_image, "GL_NV_draw_vulkan_image" );
	#endif
	#ifdef GL_NV_evaluators
		swigIntConstant( GL_NV_evaluators, "GL_NV_evaluators" );
	#endif
	#ifdef GL_EVAL_2D_NV
		swigIntConstant( GL_EVAL_2D_NV, "GL_EVAL_2D_NV" );
	#endif
	#ifdef GL_EVAL_TRIANGULAR_2D_NV
		swigIntConstant( GL_EVAL_TRIANGULAR_2D_NV, "GL_EVAL_TRIANGULAR_2D_NV" );
	#endif
	#ifdef GL_MAP_TESSELLATION_NV
		swigIntConstant( GL_MAP_TESSELLATION_NV, "GL_MAP_TESSELLATION_NV" );
	#endif
	#ifdef GL_MAP_ATTRIB_U_ORDER_NV
		swigIntConstant( GL_MAP_ATTRIB_U_ORDER_NV, "GL_MAP_ATTRIB_U_ORDER_NV" );
	#endif
	#ifdef GL_MAP_ATTRIB_V_ORDER_NV
		swigIntConstant( GL_MAP_ATTRIB_V_ORDER_NV, "GL_MAP_ATTRIB_V_ORDER_NV" );
	#endif
	#ifdef GL_EVAL_FRACTIONAL_TESSELLATION_NV
		swigIntConstant( GL_EVAL_FRACTIONAL_TESSELLATION_NV, "GL_EVAL_FRACTIONAL_TESSELLATION_NV" );
	#endif
	#ifdef GL_EVAL_VERTEX_ATTRIB0_NV
		swigIntConstant( GL_EVAL_VERTEX_ATTRIB0_NV, "GL_EVAL_VERTEX_ATTRIB0_NV" );
	#endif
	#ifdef GL_EVAL_VERTEX_ATTRIB1_NV
		swigIntConstant( GL_EVAL_VERTEX_ATTRIB1_NV, "GL_EVAL_VERTEX_ATTRIB1_NV" );
	#endif
	#ifdef GL_EVAL_VERTEX_ATTRIB2_NV
		swigIntConstant( GL_EVAL_VERTEX_ATTRIB2_NV, "GL_EVAL_VERTEX_ATTRIB2_NV" );
	#endif
	#ifdef GL_EVAL_VERTEX_ATTRIB3_NV
		swigIntConstant( GL_EVAL_VERTEX_ATTRIB3_NV, "GL_EVAL_VERTEX_ATTRIB3_NV" );
	#endif
	#ifdef GL_EVAL_VERTEX_ATTRIB4_NV
		swigIntConstant( GL_EVAL_VERTEX_ATTRIB4_NV, "GL_EVAL_VERTEX_ATTRIB4_NV" );
	#endif
	#ifdef GL_EVAL_VERTEX_ATTRIB5_NV
		swigIntConstant( GL_EVAL_VERTEX_ATTRIB5_NV, "GL_EVAL_VERTEX_ATTRIB5_NV" );
	#endif
	#ifdef GL_EVAL_VERTEX_ATTRIB6_NV
		swigIntConstant( GL_EVAL_VERTEX_ATTRIB6_NV, "GL_EVAL_VERTEX_ATTRIB6_NV" );
	#endif
	#ifdef GL_EVAL_VERTEX_ATTRIB7_NV
		swigIntConstant( GL_EVAL_VERTEX_ATTRIB7_NV, "GL_EVAL_VERTEX_ATTRIB7_NV" );
	#endif
	#ifdef GL_EVAL_VERTEX_ATTRIB8_NV
		swigIntConstant( GL_EVAL_VERTEX_ATTRIB8_NV, "GL_EVAL_VERTEX_ATTRIB8_NV" );
	#endif
	#ifdef GL_EVAL_VERTEX_ATTRIB9_NV
		swigIntConstant( GL_EVAL_VERTEX_ATTRIB9_NV, "GL_EVAL_VERTEX_ATTRIB9_NV" );
	#endif
	#ifdef GL_EVAL_VERTEX_ATTRIB10_NV
		swigIntConstant( GL_EVAL_VERTEX_ATTRIB10_NV, "GL_EVAL_VERTEX_ATTRIB10_NV" );
	#endif
	#ifdef GL_EVAL_VERTEX_ATTRIB11_NV
		swigIntConstant( GL_EVAL_VERTEX_ATTRIB11_NV, "GL_EVAL_VERTEX_ATTRIB11_NV" );
	#endif
	#ifdef GL_EVAL_VERTEX_ATTRIB12_NV
		swigIntConstant( GL_EVAL_VERTEX_ATTRIB12_NV, "GL_EVAL_VERTEX_ATTRIB12_NV" );
	#endif
	#ifdef GL_EVAL_VERTEX_ATTRIB13_NV
		swigIntConstant( GL_EVAL_VERTEX_ATTRIB13_NV, "GL_EVAL_VERTEX_ATTRIB13_NV" );
	#endif
	#ifdef GL_EVAL_VERTEX_ATTRIB14_NV
		swigIntConstant( GL_EVAL_VERTEX_ATTRIB14_NV, "GL_EVAL_VERTEX_ATTRIB14_NV" );
	#endif
	#ifdef GL_EVAL_VERTEX_ATTRIB15_NV
		swigIntConstant( GL_EVAL_VERTEX_ATTRIB15_NV, "GL_EVAL_VERTEX_ATTRIB15_NV" );
	#endif
	#ifdef GL_MAX_MAP_TESSELLATION_NV
		swigIntConstant( GL_MAX_MAP_TESSELLATION_NV, "GL_MAX_MAP_TESSELLATION_NV" );
	#endif
	#ifdef GL_MAX_RATIONAL_EVAL_ORDER_NV
		swigIntConstant( GL_MAX_RATIONAL_EVAL_ORDER_NV, "GL_MAX_RATIONAL_EVAL_ORDER_NV" );
	#endif
	#ifdef GL_NV_explicit_multisample
		swigIntConstant( GL_NV_explicit_multisample, "GL_NV_explicit_multisample" );
	#endif
	#ifdef GL_SAMPLE_POSITION_NV
		swigIntConstant( GL_SAMPLE_POSITION_NV, "GL_SAMPLE_POSITION_NV" );
	#endif
	#ifdef GL_SAMPLE_MASK_NV
		swigIntConstant( GL_SAMPLE_MASK_NV, "GL_SAMPLE_MASK_NV" );
	#endif
	#ifdef GL_SAMPLE_MASK_VALUE_NV
		swigIntConstant( GL_SAMPLE_MASK_VALUE_NV, "GL_SAMPLE_MASK_VALUE_NV" );
	#endif
	#ifdef GL_TEXTURE_BINDING_RENDERBUFFER_NV
		swigIntConstant( GL_TEXTURE_BINDING_RENDERBUFFER_NV, "GL_TEXTURE_BINDING_RENDERBUFFER_NV" );
	#endif
	#ifdef GL_TEXTURE_RENDERBUFFER_DATA_STORE_BINDING_NV
		swigIntConstant( GL_TEXTURE_RENDERBUFFER_DATA_STORE_BINDING_NV, "GL_TEXTURE_RENDERBUFFER_DATA_STORE_BINDING_NV" );
	#endif
	#ifdef GL_TEXTURE_RENDERBUFFER_NV
		swigIntConstant( GL_TEXTURE_RENDERBUFFER_NV, "GL_TEXTURE_RENDERBUFFER_NV" );
	#endif
	#ifdef GL_SAMPLER_RENDERBUFFER_NV
		swigIntConstant( GL_SAMPLER_RENDERBUFFER_NV, "GL_SAMPLER_RENDERBUFFER_NV" );
	#endif
	#ifdef GL_INT_SAMPLER_RENDERBUFFER_NV
		swigIntConstant( GL_INT_SAMPLER_RENDERBUFFER_NV, "GL_INT_SAMPLER_RENDERBUFFER_NV" );
	#endif
	#ifdef GL_UNSIGNED_INT_SAMPLER_RENDERBUFFER_NV
		swigIntConstant( GL_UNSIGNED_INT_SAMPLER_RENDERBUFFER_NV, "GL_UNSIGNED_INT_SAMPLER_RENDERBUFFER_NV" );
	#endif
	#ifdef GL_MAX_SAMPLE_MASK_WORDS_NV
		swigIntConstant( GL_MAX_SAMPLE_MASK_WORDS_NV, "GL_MAX_SAMPLE_MASK_WORDS_NV" );
	#endif
	#ifdef GL_NV_fence
		swigIntConstant( GL_NV_fence, "GL_NV_fence" );
	#endif
	#ifdef GL_ALL_COMPLETED_NV
		swigIntConstant( GL_ALL_COMPLETED_NV, "GL_ALL_COMPLETED_NV" );
	#endif
	#ifdef GL_FENCE_STATUS_NV
		swigIntConstant( GL_FENCE_STATUS_NV, "GL_FENCE_STATUS_NV" );
	#endif
	#ifdef GL_FENCE_CONDITION_NV
		swigIntConstant( GL_FENCE_CONDITION_NV, "GL_FENCE_CONDITION_NV" );
	#endif
	#ifdef GL_NV_fill_rectangle
		swigIntConstant( GL_NV_fill_rectangle, "GL_NV_fill_rectangle" );
	#endif
	#ifdef GL_FILL_RECTANGLE_NV
		swigIntConstant( GL_FILL_RECTANGLE_NV, "GL_FILL_RECTANGLE_NV" );
	#endif
	#ifdef GL_NV_float_buffer
		swigIntConstant( GL_NV_float_buffer, "GL_NV_float_buffer" );
	#endif
	#ifdef GL_FLOAT_R_NV
		swigIntConstant( GL_FLOAT_R_NV, "GL_FLOAT_R_NV" );
	#endif
	#ifdef GL_FLOAT_RG_NV
		swigIntConstant( GL_FLOAT_RG_NV, "GL_FLOAT_RG_NV" );
	#endif
	#ifdef GL_FLOAT_RGB_NV
		swigIntConstant( GL_FLOAT_RGB_NV, "GL_FLOAT_RGB_NV" );
	#endif
	#ifdef GL_FLOAT_RGBA_NV
		swigIntConstant( GL_FLOAT_RGBA_NV, "GL_FLOAT_RGBA_NV" );
	#endif
	#ifdef GL_FLOAT_R16_NV
		swigIntConstant( GL_FLOAT_R16_NV, "GL_FLOAT_R16_NV" );
	#endif
	#ifdef GL_FLOAT_R32_NV
		swigIntConstant( GL_FLOAT_R32_NV, "GL_FLOAT_R32_NV" );
	#endif
	#ifdef GL_FLOAT_RG16_NV
		swigIntConstant( GL_FLOAT_RG16_NV, "GL_FLOAT_RG16_NV" );
	#endif
	#ifdef GL_FLOAT_RG32_NV
		swigIntConstant( GL_FLOAT_RG32_NV, "GL_FLOAT_RG32_NV" );
	#endif
	#ifdef GL_FLOAT_RGB16_NV
		swigIntConstant( GL_FLOAT_RGB16_NV, "GL_FLOAT_RGB16_NV" );
	#endif
	#ifdef GL_FLOAT_RGB32_NV
		swigIntConstant( GL_FLOAT_RGB32_NV, "GL_FLOAT_RGB32_NV" );
	#endif
	#ifdef GL_FLOAT_RGBA16_NV
		swigIntConstant( GL_FLOAT_RGBA16_NV, "GL_FLOAT_RGBA16_NV" );
	#endif
	#ifdef GL_FLOAT_RGBA32_NV
		swigIntConstant( GL_FLOAT_RGBA32_NV, "GL_FLOAT_RGBA32_NV" );
	#endif
	#ifdef GL_TEXTURE_FLOAT_COMPONENTS_NV
		swigIntConstant( GL_TEXTURE_FLOAT_COMPONENTS_NV, "GL_TEXTURE_FLOAT_COMPONENTS_NV" );
	#endif
	#ifdef GL_FLOAT_CLEAR_COLOR_VALUE_NV
		swigIntConstant( GL_FLOAT_CLEAR_COLOR_VALUE_NV, "GL_FLOAT_CLEAR_COLOR_VALUE_NV" );
	#endif
	#ifdef GL_FLOAT_RGBA_MODE_NV
		swigIntConstant( GL_FLOAT_RGBA_MODE_NV, "GL_FLOAT_RGBA_MODE_NV" );
	#endif
	#ifdef GL_NV_fog_distance
		swigIntConstant( GL_NV_fog_distance, "GL_NV_fog_distance" );
	#endif
	#ifdef GL_FOG_DISTANCE_MODE_NV
		swigIntConstant( GL_FOG_DISTANCE_MODE_NV, "GL_FOG_DISTANCE_MODE_NV" );
	#endif
	#ifdef GL_EYE_RADIAL_NV
		swigIntConstant( GL_EYE_RADIAL_NV, "GL_EYE_RADIAL_NV" );
	#endif
	#ifdef GL_EYE_PLANE_ABSOLUTE_NV
		swigIntConstant( GL_EYE_PLANE_ABSOLUTE_NV, "GL_EYE_PLANE_ABSOLUTE_NV" );
	#endif
	#ifdef GL_NV_fragment_coverage_to_color
		swigIntConstant( GL_NV_fragment_coverage_to_color, "GL_NV_fragment_coverage_to_color" );
	#endif
	#ifdef GL_FRAGMENT_COVERAGE_TO_COLOR_NV
		swigIntConstant( GL_FRAGMENT_COVERAGE_TO_COLOR_NV, "GL_FRAGMENT_COVERAGE_TO_COLOR_NV" );
	#endif
	#ifdef GL_FRAGMENT_COVERAGE_COLOR_NV
		swigIntConstant( GL_FRAGMENT_COVERAGE_COLOR_NV, "GL_FRAGMENT_COVERAGE_COLOR_NV" );
	#endif
	#ifdef GL_NV_fragment_program
		swigIntConstant( GL_NV_fragment_program, "GL_NV_fragment_program" );
	#endif
	#ifdef GL_MAX_FRAGMENT_PROGRAM_LOCAL_PARAMETERS_NV
		swigIntConstant( GL_MAX_FRAGMENT_PROGRAM_LOCAL_PARAMETERS_NV, "GL_MAX_FRAGMENT_PROGRAM_LOCAL_PARAMETERS_NV" );
	#endif
	#ifdef GL_FRAGMENT_PROGRAM_NV
		swigIntConstant( GL_FRAGMENT_PROGRAM_NV, "GL_FRAGMENT_PROGRAM_NV" );
	#endif
	#ifdef GL_MAX_TEXTURE_COORDS_NV
		swigIntConstant( GL_MAX_TEXTURE_COORDS_NV, "GL_MAX_TEXTURE_COORDS_NV" );
	#endif
	#ifdef GL_MAX_TEXTURE_IMAGE_UNITS_NV
		swigIntConstant( GL_MAX_TEXTURE_IMAGE_UNITS_NV, "GL_MAX_TEXTURE_IMAGE_UNITS_NV" );
	#endif
	#ifdef GL_FRAGMENT_PROGRAM_BINDING_NV
		swigIntConstant( GL_FRAGMENT_PROGRAM_BINDING_NV, "GL_FRAGMENT_PROGRAM_BINDING_NV" );
	#endif
	#ifdef GL_PROGRAM_ERROR_STRING_NV
		swigIntConstant( GL_PROGRAM_ERROR_STRING_NV, "GL_PROGRAM_ERROR_STRING_NV" );
	#endif
	#ifdef GL_NV_fragment_program2
		swigIntConstant( GL_NV_fragment_program2, "GL_NV_fragment_program2" );
	#endif
	#ifdef GL_MAX_PROGRAM_EXEC_INSTRUCTIONS_NV
		swigIntConstant( GL_MAX_PROGRAM_EXEC_INSTRUCTIONS_NV, "GL_MAX_PROGRAM_EXEC_INSTRUCTIONS_NV" );
	#endif
	#ifdef GL_MAX_PROGRAM_CALL_DEPTH_NV
		swigIntConstant( GL_MAX_PROGRAM_CALL_DEPTH_NV, "GL_MAX_PROGRAM_CALL_DEPTH_NV" );
	#endif
	#ifdef GL_MAX_PROGRAM_IF_DEPTH_NV
		swigIntConstant( GL_MAX_PROGRAM_IF_DEPTH_NV, "GL_MAX_PROGRAM_IF_DEPTH_NV" );
	#endif
	#ifdef GL_MAX_PROGRAM_LOOP_DEPTH_NV
		swigIntConstant( GL_MAX_PROGRAM_LOOP_DEPTH_NV, "GL_MAX_PROGRAM_LOOP_DEPTH_NV" );
	#endif
	#ifdef GL_MAX_PROGRAM_LOOP_COUNT_NV
		swigIntConstant( GL_MAX_PROGRAM_LOOP_COUNT_NV, "GL_MAX_PROGRAM_LOOP_COUNT_NV" );
	#endif
	#ifdef GL_NV_fragment_program4
		swigIntConstant( GL_NV_fragment_program4, "GL_NV_fragment_program4" );
	#endif
	#ifdef GL_NV_fragment_program_option
		swigIntConstant( GL_NV_fragment_program_option, "GL_NV_fragment_program_option" );
	#endif
	#ifdef GL_NV_fragment_shader_barycentric
		swigIntConstant( GL_NV_fragment_shader_barycentric, "GL_NV_fragment_shader_barycentric" );
	#endif
	#ifdef GL_NV_fragment_shader_interlock
		swigIntConstant( GL_NV_fragment_shader_interlock, "GL_NV_fragment_shader_interlock" );
	#endif
	#ifdef GL_NV_framebuffer_mixed_samples
		swigIntConstant( GL_NV_framebuffer_mixed_samples, "GL_NV_framebuffer_mixed_samples" );
	#endif
	#ifdef GL_COVERAGE_MODULATION_TABLE_NV
		swigIntConstant( GL_COVERAGE_MODULATION_TABLE_NV, "GL_COVERAGE_MODULATION_TABLE_NV" );
	#endif
	#ifdef GL_COLOR_SAMPLES_NV
		swigIntConstant( GL_COLOR_SAMPLES_NV, "GL_COLOR_SAMPLES_NV" );
	#endif
	#ifdef GL_DEPTH_SAMPLES_NV
		swigIntConstant( GL_DEPTH_SAMPLES_NV, "GL_DEPTH_SAMPLES_NV" );
	#endif
	#ifdef GL_STENCIL_SAMPLES_NV
		swigIntConstant( GL_STENCIL_SAMPLES_NV, "GL_STENCIL_SAMPLES_NV" );
	#endif
	#ifdef GL_MIXED_DEPTH_SAMPLES_SUPPORTED_NV
		swigIntConstant( GL_MIXED_DEPTH_SAMPLES_SUPPORTED_NV, "GL_MIXED_DEPTH_SAMPLES_SUPPORTED_NV" );
	#endif
	#ifdef GL_MIXED_STENCIL_SAMPLES_SUPPORTED_NV
		swigIntConstant( GL_MIXED_STENCIL_SAMPLES_SUPPORTED_NV, "GL_MIXED_STENCIL_SAMPLES_SUPPORTED_NV" );
	#endif
	#ifdef GL_COVERAGE_MODULATION_NV
		swigIntConstant( GL_COVERAGE_MODULATION_NV, "GL_COVERAGE_MODULATION_NV" );
	#endif
	#ifdef GL_COVERAGE_MODULATION_TABLE_SIZE_NV
		swigIntConstant( GL_COVERAGE_MODULATION_TABLE_SIZE_NV, "GL_COVERAGE_MODULATION_TABLE_SIZE_NV" );
	#endif
	#ifdef GL_NV_framebuffer_multisample_coverage
		swigIntConstant( GL_NV_framebuffer_multisample_coverage, "GL_NV_framebuffer_multisample_coverage" );
	#endif
	#ifdef GL_RENDERBUFFER_COVERAGE_SAMPLES_NV
		swigIntConstant( GL_RENDERBUFFER_COVERAGE_SAMPLES_NV, "GL_RENDERBUFFER_COVERAGE_SAMPLES_NV" );
	#endif
	#ifdef GL_RENDERBUFFER_COLOR_SAMPLES_NV
		swigIntConstant( GL_RENDERBUFFER_COLOR_SAMPLES_NV, "GL_RENDERBUFFER_COLOR_SAMPLES_NV" );
	#endif
	#ifdef GL_MAX_MULTISAMPLE_COVERAGE_MODES_NV
		swigIntConstant( GL_MAX_MULTISAMPLE_COVERAGE_MODES_NV, "GL_MAX_MULTISAMPLE_COVERAGE_MODES_NV" );
	#endif
	#ifdef GL_MULTISAMPLE_COVERAGE_MODES_NV
		swigIntConstant( GL_MULTISAMPLE_COVERAGE_MODES_NV, "GL_MULTISAMPLE_COVERAGE_MODES_NV" );
	#endif
	#ifdef GL_NV_geometry_program4
		swigIntConstant( GL_NV_geometry_program4, "GL_NV_geometry_program4" );
	#endif
	#ifdef GL_GEOMETRY_PROGRAM_NV
		swigIntConstant( GL_GEOMETRY_PROGRAM_NV, "GL_GEOMETRY_PROGRAM_NV" );
	#endif
	#ifdef GL_MAX_PROGRAM_OUTPUT_VERTICES_NV
		swigIntConstant( GL_MAX_PROGRAM_OUTPUT_VERTICES_NV, "GL_MAX_PROGRAM_OUTPUT_VERTICES_NV" );
	#endif
	#ifdef GL_MAX_PROGRAM_TOTAL_OUTPUT_COMPONENTS_NV
		swigIntConstant( GL_MAX_PROGRAM_TOTAL_OUTPUT_COMPONENTS_NV, "GL_MAX_PROGRAM_TOTAL_OUTPUT_COMPONENTS_NV" );
	#endif
	#ifdef GL_NV_geometry_shader4
		swigIntConstant( GL_NV_geometry_shader4, "GL_NV_geometry_shader4" );
	#endif
	#ifdef GL_NV_geometry_shader_passthrough
		swigIntConstant( GL_NV_geometry_shader_passthrough, "GL_NV_geometry_shader_passthrough" );
	#endif
	#ifdef GL_NV_gpu_multicast
		swigIntConstant( GL_NV_gpu_multicast, "GL_NV_gpu_multicast" );
	#endif
	#ifdef GL_PER_GPU_STORAGE_BIT_NV
		swigIntConstant( GL_PER_GPU_STORAGE_BIT_NV, "GL_PER_GPU_STORAGE_BIT_NV" );
	#endif
	#ifdef GL_MULTICAST_GPUS_NV
		swigIntConstant( GL_MULTICAST_GPUS_NV, "GL_MULTICAST_GPUS_NV" );
	#endif
	#ifdef GL_RENDER_GPU_MASK_NV
		swigIntConstant( GL_RENDER_GPU_MASK_NV, "GL_RENDER_GPU_MASK_NV" );
	#endif
	#ifdef GL_PER_GPU_STORAGE_NV
		swigIntConstant( GL_PER_GPU_STORAGE_NV, "GL_PER_GPU_STORAGE_NV" );
	#endif
	#ifdef GL_MULTICAST_PROGRAMMABLE_SAMPLE_LOCATION_NV
		swigIntConstant( GL_MULTICAST_PROGRAMMABLE_SAMPLE_LOCATION_NV, "GL_MULTICAST_PROGRAMMABLE_SAMPLE_LOCATION_NV" );
	#endif
	#ifdef GL_NV_gpu_program4
		swigIntConstant( GL_NV_gpu_program4, "GL_NV_gpu_program4" );
	#endif
	#ifdef GL_MIN_PROGRAM_TEXEL_OFFSET_NV
		swigIntConstant( GL_MIN_PROGRAM_TEXEL_OFFSET_NV, "GL_MIN_PROGRAM_TEXEL_OFFSET_NV" );
	#endif
	#ifdef GL_MAX_PROGRAM_TEXEL_OFFSET_NV
		swigIntConstant( GL_MAX_PROGRAM_TEXEL_OFFSET_NV, "GL_MAX_PROGRAM_TEXEL_OFFSET_NV" );
	#endif
	#ifdef GL_PROGRAM_ATTRIB_COMPONENTS_NV
		swigIntConstant( GL_PROGRAM_ATTRIB_COMPONENTS_NV, "GL_PROGRAM_ATTRIB_COMPONENTS_NV" );
	#endif
	#ifdef GL_PROGRAM_RESULT_COMPONENTS_NV
		swigIntConstant( GL_PROGRAM_RESULT_COMPONENTS_NV, "GL_PROGRAM_RESULT_COMPONENTS_NV" );
	#endif
	#ifdef GL_MAX_PROGRAM_ATTRIB_COMPONENTS_NV
		swigIntConstant( GL_MAX_PROGRAM_ATTRIB_COMPONENTS_NV, "GL_MAX_PROGRAM_ATTRIB_COMPONENTS_NV" );
	#endif
	#ifdef GL_MAX_PROGRAM_RESULT_COMPONENTS_NV
		swigIntConstant( GL_MAX_PROGRAM_RESULT_COMPONENTS_NV, "GL_MAX_PROGRAM_RESULT_COMPONENTS_NV" );
	#endif
	#ifdef GL_MAX_PROGRAM_GENERIC_ATTRIBS_NV
		swigIntConstant( GL_MAX_PROGRAM_GENERIC_ATTRIBS_NV, "GL_MAX_PROGRAM_GENERIC_ATTRIBS_NV" );
	#endif
	#ifdef GL_MAX_PROGRAM_GENERIC_RESULTS_NV
		swigIntConstant( GL_MAX_PROGRAM_GENERIC_RESULTS_NV, "GL_MAX_PROGRAM_GENERIC_RESULTS_NV" );
	#endif
	#ifdef GL_NV_gpu_program5
		swigIntConstant( GL_NV_gpu_program5, "GL_NV_gpu_program5" );
	#endif
	#ifdef GL_MAX_GEOMETRY_PROGRAM_INVOCATIONS_NV
		swigIntConstant( GL_MAX_GEOMETRY_PROGRAM_INVOCATIONS_NV, "GL_MAX_GEOMETRY_PROGRAM_INVOCATIONS_NV" );
	#endif
	#ifdef GL_MIN_FRAGMENT_INTERPOLATION_OFFSET_NV
		swigIntConstant( GL_MIN_FRAGMENT_INTERPOLATION_OFFSET_NV, "GL_MIN_FRAGMENT_INTERPOLATION_OFFSET_NV" );
	#endif
	#ifdef GL_MAX_FRAGMENT_INTERPOLATION_OFFSET_NV
		swigIntConstant( GL_MAX_FRAGMENT_INTERPOLATION_OFFSET_NV, "GL_MAX_FRAGMENT_INTERPOLATION_OFFSET_NV" );
	#endif
	#ifdef GL_FRAGMENT_PROGRAM_INTERPOLATION_OFFSET_BITS_NV
		swigIntConstant( GL_FRAGMENT_PROGRAM_INTERPOLATION_OFFSET_BITS_NV, "GL_FRAGMENT_PROGRAM_INTERPOLATION_OFFSET_BITS_NV" );
	#endif
	#ifdef GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET_NV
		swigIntConstant( GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET_NV, "GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET_NV" );
	#endif
	#ifdef GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET_NV
		swigIntConstant( GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET_NV, "GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET_NV" );
	#endif
	#ifdef GL_MAX_PROGRAM_SUBROUTINE_PARAMETERS_NV
		swigIntConstant( GL_MAX_PROGRAM_SUBROUTINE_PARAMETERS_NV, "GL_MAX_PROGRAM_SUBROUTINE_PARAMETERS_NV" );
	#endif
	#ifdef GL_MAX_PROGRAM_SUBROUTINE_NUM_NV
		swigIntConstant( GL_MAX_PROGRAM_SUBROUTINE_NUM_NV, "GL_MAX_PROGRAM_SUBROUTINE_NUM_NV" );
	#endif
	#ifdef GL_NV_gpu_program5_mem_extended
		swigIntConstant( GL_NV_gpu_program5_mem_extended, "GL_NV_gpu_program5_mem_extended" );
	#endif
	#ifdef GL_NV_gpu_shader5
		swigIntConstant( GL_NV_gpu_shader5, "GL_NV_gpu_shader5" );
	#endif
	#ifdef GL_NV_half_float
		swigIntConstant( GL_NV_half_float, "GL_NV_half_float" );
	#endif
	#ifdef GL_HALF_FLOAT_NV
		swigIntConstant( GL_HALF_FLOAT_NV, "GL_HALF_FLOAT_NV" );
	#endif
	#ifdef GL_NV_internalformat_sample_query
		swigIntConstant( GL_NV_internalformat_sample_query, "GL_NV_internalformat_sample_query" );
	#endif
	#ifdef GL_MULTISAMPLES_NV
		swigIntConstant( GL_MULTISAMPLES_NV, "GL_MULTISAMPLES_NV" );
	#endif
	#ifdef GL_SUPERSAMPLE_SCALE_X_NV
		swigIntConstant( GL_SUPERSAMPLE_SCALE_X_NV, "GL_SUPERSAMPLE_SCALE_X_NV" );
	#endif
	#ifdef GL_SUPERSAMPLE_SCALE_Y_NV
		swigIntConstant( GL_SUPERSAMPLE_SCALE_Y_NV, "GL_SUPERSAMPLE_SCALE_Y_NV" );
	#endif
	#ifdef GL_CONFORMANT_NV
		swigIntConstant( GL_CONFORMANT_NV, "GL_CONFORMANT_NV" );
	#endif
	#ifdef GL_NV_light_max_exponent
		swigIntConstant( GL_NV_light_max_exponent, "GL_NV_light_max_exponent" );
	#endif
	#ifdef GL_MAX_SHININESS_NV
		swigIntConstant( GL_MAX_SHININESS_NV, "GL_MAX_SHININESS_NV" );
	#endif
	#ifdef GL_MAX_SPOT_EXPONENT_NV
		swigIntConstant( GL_MAX_SPOT_EXPONENT_NV, "GL_MAX_SPOT_EXPONENT_NV" );
	#endif
	#ifdef GL_NV_memory_attachment
		swigIntConstant( GL_NV_memory_attachment, "GL_NV_memory_attachment" );
	#endif
	#ifdef GL_ATTACHED_MEMORY_OBJECT_NV
		swigIntConstant( GL_ATTACHED_MEMORY_OBJECT_NV, "GL_ATTACHED_MEMORY_OBJECT_NV" );
	#endif
	#ifdef GL_ATTACHED_MEMORY_OFFSET_NV
		swigIntConstant( GL_ATTACHED_MEMORY_OFFSET_NV, "GL_ATTACHED_MEMORY_OFFSET_NV" );
	#endif
	#ifdef GL_MEMORY_ATTACHABLE_ALIGNMENT_NV
		swigIntConstant( GL_MEMORY_ATTACHABLE_ALIGNMENT_NV, "GL_MEMORY_ATTACHABLE_ALIGNMENT_NV" );
	#endif
	#ifdef GL_MEMORY_ATTACHABLE_SIZE_NV
		swigIntConstant( GL_MEMORY_ATTACHABLE_SIZE_NV, "GL_MEMORY_ATTACHABLE_SIZE_NV" );
	#endif
	#ifdef GL_MEMORY_ATTACHABLE_NV
		swigIntConstant( GL_MEMORY_ATTACHABLE_NV, "GL_MEMORY_ATTACHABLE_NV" );
	#endif
	#ifdef GL_DETACHED_MEMORY_INCARNATION_NV
		swigIntConstant( GL_DETACHED_MEMORY_INCARNATION_NV, "GL_DETACHED_MEMORY_INCARNATION_NV" );
	#endif
	#ifdef GL_DETACHED_TEXTURES_NV
		swigIntConstant( GL_DETACHED_TEXTURES_NV, "GL_DETACHED_TEXTURES_NV" );
	#endif
	#ifdef GL_DETACHED_BUFFERS_NV
		swigIntConstant( GL_DETACHED_BUFFERS_NV, "GL_DETACHED_BUFFERS_NV" );
	#endif
	#ifdef GL_MAX_DETACHED_TEXTURES_NV
		swigIntConstant( GL_MAX_DETACHED_TEXTURES_NV, "GL_MAX_DETACHED_TEXTURES_NV" );
	#endif
	#ifdef GL_MAX_DETACHED_BUFFERS_NV
		swigIntConstant( GL_MAX_DETACHED_BUFFERS_NV, "GL_MAX_DETACHED_BUFFERS_NV" );
	#endif
	#ifdef GL_NV_memory_object_sparse
		swigIntConstant( GL_NV_memory_object_sparse, "GL_NV_memory_object_sparse" );
	#endif
	#ifdef GL_NV_mesh_shader
		swigIntConstant( GL_NV_mesh_shader, "GL_NV_mesh_shader" );
	#endif
	#ifdef GL_MESH_SHADER_NV
		swigIntConstant( GL_MESH_SHADER_NV, "GL_MESH_SHADER_NV" );
	#endif
	#ifdef GL_TASK_SHADER_NV
		swigIntConstant( GL_TASK_SHADER_NV, "GL_TASK_SHADER_NV" );
	#endif
	#ifdef GL_MAX_MESH_UNIFORM_BLOCKS_NV
		swigIntConstant( GL_MAX_MESH_UNIFORM_BLOCKS_NV, "GL_MAX_MESH_UNIFORM_BLOCKS_NV" );
	#endif
	#ifdef GL_MAX_MESH_TEXTURE_IMAGE_UNITS_NV
		swigIntConstant( GL_MAX_MESH_TEXTURE_IMAGE_UNITS_NV, "GL_MAX_MESH_TEXTURE_IMAGE_UNITS_NV" );
	#endif
	#ifdef GL_MAX_MESH_IMAGE_UNIFORMS_NV
		swigIntConstant( GL_MAX_MESH_IMAGE_UNIFORMS_NV, "GL_MAX_MESH_IMAGE_UNIFORMS_NV" );
	#endif
	#ifdef GL_MAX_MESH_UNIFORM_COMPONENTS_NV
		swigIntConstant( GL_MAX_MESH_UNIFORM_COMPONENTS_NV, "GL_MAX_MESH_UNIFORM_COMPONENTS_NV" );
	#endif
	#ifdef GL_MAX_MESH_ATOMIC_COUNTER_BUFFERS_NV
		swigIntConstant( GL_MAX_MESH_ATOMIC_COUNTER_BUFFERS_NV, "GL_MAX_MESH_ATOMIC_COUNTER_BUFFERS_NV" );
	#endif
	#ifdef GL_MAX_MESH_ATOMIC_COUNTERS_NV
		swigIntConstant( GL_MAX_MESH_ATOMIC_COUNTERS_NV, "GL_MAX_MESH_ATOMIC_COUNTERS_NV" );
	#endif
	#ifdef GL_MAX_MESH_SHADER_STORAGE_BLOCKS_NV
		swigIntConstant( GL_MAX_MESH_SHADER_STORAGE_BLOCKS_NV, "GL_MAX_MESH_SHADER_STORAGE_BLOCKS_NV" );
	#endif
	#ifdef GL_MAX_COMBINED_MESH_UNIFORM_COMPONENTS_NV
		swigIntConstant( GL_MAX_COMBINED_MESH_UNIFORM_COMPONENTS_NV, "GL_MAX_COMBINED_MESH_UNIFORM_COMPONENTS_NV" );
	#endif
	#ifdef GL_MAX_TASK_UNIFORM_BLOCKS_NV
		swigIntConstant( GL_MAX_TASK_UNIFORM_BLOCKS_NV, "GL_MAX_TASK_UNIFORM_BLOCKS_NV" );
	#endif
	#ifdef GL_MAX_TASK_TEXTURE_IMAGE_UNITS_NV
		swigIntConstant( GL_MAX_TASK_TEXTURE_IMAGE_UNITS_NV, "GL_MAX_TASK_TEXTURE_IMAGE_UNITS_NV" );
	#endif
	#ifdef GL_MAX_TASK_IMAGE_UNIFORMS_NV
		swigIntConstant( GL_MAX_TASK_IMAGE_UNIFORMS_NV, "GL_MAX_TASK_IMAGE_UNIFORMS_NV" );
	#endif
	#ifdef GL_MAX_TASK_UNIFORM_COMPONENTS_NV
		swigIntConstant( GL_MAX_TASK_UNIFORM_COMPONENTS_NV, "GL_MAX_TASK_UNIFORM_COMPONENTS_NV" );
	#endif
	#ifdef GL_MAX_TASK_ATOMIC_COUNTER_BUFFERS_NV
		swigIntConstant( GL_MAX_TASK_ATOMIC_COUNTER_BUFFERS_NV, "GL_MAX_TASK_ATOMIC_COUNTER_BUFFERS_NV" );
	#endif
	#ifdef GL_MAX_TASK_ATOMIC_COUNTERS_NV
		swigIntConstant( GL_MAX_TASK_ATOMIC_COUNTERS_NV, "GL_MAX_TASK_ATOMIC_COUNTERS_NV" );
	#endif
	#ifdef GL_MAX_TASK_SHADER_STORAGE_BLOCKS_NV
		swigIntConstant( GL_MAX_TASK_SHADER_STORAGE_BLOCKS_NV, "GL_MAX_TASK_SHADER_STORAGE_BLOCKS_NV" );
	#endif
	#ifdef GL_MAX_COMBINED_TASK_UNIFORM_COMPONENTS_NV
		swigIntConstant( GL_MAX_COMBINED_TASK_UNIFORM_COMPONENTS_NV, "GL_MAX_COMBINED_TASK_UNIFORM_COMPONENTS_NV" );
	#endif
	#ifdef GL_MAX_MESH_WORK_GROUP_INVOCATIONS_NV
		swigIntConstant( GL_MAX_MESH_WORK_GROUP_INVOCATIONS_NV, "GL_MAX_MESH_WORK_GROUP_INVOCATIONS_NV" );
	#endif
	#ifdef GL_MAX_TASK_WORK_GROUP_INVOCATIONS_NV
		swigIntConstant( GL_MAX_TASK_WORK_GROUP_INVOCATIONS_NV, "GL_MAX_TASK_WORK_GROUP_INVOCATIONS_NV" );
	#endif
	#ifdef GL_MAX_MESH_TOTAL_MEMORY_SIZE_NV
		swigIntConstant( GL_MAX_MESH_TOTAL_MEMORY_SIZE_NV, "GL_MAX_MESH_TOTAL_MEMORY_SIZE_NV" );
	#endif
	#ifdef GL_MAX_TASK_TOTAL_MEMORY_SIZE_NV
		swigIntConstant( GL_MAX_TASK_TOTAL_MEMORY_SIZE_NV, "GL_MAX_TASK_TOTAL_MEMORY_SIZE_NV" );
	#endif
	#ifdef GL_MAX_MESH_OUTPUT_VERTICES_NV
		swigIntConstant( GL_MAX_MESH_OUTPUT_VERTICES_NV, "GL_MAX_MESH_OUTPUT_VERTICES_NV" );
	#endif
	#ifdef GL_MAX_MESH_OUTPUT_PRIMITIVES_NV
		swigIntConstant( GL_MAX_MESH_OUTPUT_PRIMITIVES_NV, "GL_MAX_MESH_OUTPUT_PRIMITIVES_NV" );
	#endif
	#ifdef GL_MAX_TASK_OUTPUT_COUNT_NV
		swigIntConstant( GL_MAX_TASK_OUTPUT_COUNT_NV, "GL_MAX_TASK_OUTPUT_COUNT_NV" );
	#endif
	#ifdef GL_MAX_DRAW_MESH_TASKS_COUNT_NV
		swigIntConstant( GL_MAX_DRAW_MESH_TASKS_COUNT_NV, "GL_MAX_DRAW_MESH_TASKS_COUNT_NV" );
	#endif
	#ifdef GL_MAX_MESH_VIEWS_NV
		swigIntConstant( GL_MAX_MESH_VIEWS_NV, "GL_MAX_MESH_VIEWS_NV" );
	#endif
	#ifdef GL_MESH_OUTPUT_PER_VERTEX_GRANULARITY_NV
		swigIntConstant( GL_MESH_OUTPUT_PER_VERTEX_GRANULARITY_NV, "GL_MESH_OUTPUT_PER_VERTEX_GRANULARITY_NV" );
	#endif
	#ifdef GL_MESH_OUTPUT_PER_PRIMITIVE_GRANULARITY_NV
		swigIntConstant( GL_MESH_OUTPUT_PER_PRIMITIVE_GRANULARITY_NV, "GL_MESH_OUTPUT_PER_PRIMITIVE_GRANULARITY_NV" );
	#endif
	#ifdef GL_MAX_MESH_WORK_GROUP_SIZE_NV
		swigIntConstant( GL_MAX_MESH_WORK_GROUP_SIZE_NV, "GL_MAX_MESH_WORK_GROUP_SIZE_NV" );
	#endif
	#ifdef GL_MAX_TASK_WORK_GROUP_SIZE_NV
		swigIntConstant( GL_MAX_TASK_WORK_GROUP_SIZE_NV, "GL_MAX_TASK_WORK_GROUP_SIZE_NV" );
	#endif
	#ifdef GL_MESH_WORK_GROUP_SIZE_NV
		swigIntConstant( GL_MESH_WORK_GROUP_SIZE_NV, "GL_MESH_WORK_GROUP_SIZE_NV" );
	#endif
	#ifdef GL_TASK_WORK_GROUP_SIZE_NV
		swigIntConstant( GL_TASK_WORK_GROUP_SIZE_NV, "GL_TASK_WORK_GROUP_SIZE_NV" );
	#endif
	#ifdef GL_MESH_VERTICES_OUT_NV
		swigIntConstant( GL_MESH_VERTICES_OUT_NV, "GL_MESH_VERTICES_OUT_NV" );
	#endif
	#ifdef GL_MESH_PRIMITIVES_OUT_NV
		swigIntConstant( GL_MESH_PRIMITIVES_OUT_NV, "GL_MESH_PRIMITIVES_OUT_NV" );
	#endif
	#ifdef GL_MESH_OUTPUT_TYPE_NV
		swigIntConstant( GL_MESH_OUTPUT_TYPE_NV, "GL_MESH_OUTPUT_TYPE_NV" );
	#endif
	#ifdef GL_UNIFORM_BLOCK_REFERENCED_BY_MESH_SHADER_NV
		swigIntConstant( GL_UNIFORM_BLOCK_REFERENCED_BY_MESH_SHADER_NV, "GL_UNIFORM_BLOCK_REFERENCED_BY_MESH_SHADER_NV" );
	#endif
	#ifdef GL_UNIFORM_BLOCK_REFERENCED_BY_TASK_SHADER_NV
		swigIntConstant( GL_UNIFORM_BLOCK_REFERENCED_BY_TASK_SHADER_NV, "GL_UNIFORM_BLOCK_REFERENCED_BY_TASK_SHADER_NV" );
	#endif
	#ifdef GL_REFERENCED_BY_MESH_SHADER_NV
		swigIntConstant( GL_REFERENCED_BY_MESH_SHADER_NV, "GL_REFERENCED_BY_MESH_SHADER_NV" );
	#endif
	#ifdef GL_REFERENCED_BY_TASK_SHADER_NV
		swigIntConstant( GL_REFERENCED_BY_TASK_SHADER_NV, "GL_REFERENCED_BY_TASK_SHADER_NV" );
	#endif
	#ifdef GL_MESH_SHADER_BIT_NV
		swigIntConstant( GL_MESH_SHADER_BIT_NV, "GL_MESH_SHADER_BIT_NV" );
	#endif
	#ifdef GL_TASK_SHADER_BIT_NV
		swigIntConstant( GL_TASK_SHADER_BIT_NV, "GL_TASK_SHADER_BIT_NV" );
	#endif
	#ifdef GL_MESH_SUBROUTINE_NV
		swigIntConstant( GL_MESH_SUBROUTINE_NV, "GL_MESH_SUBROUTINE_NV" );
	#endif
	#ifdef GL_TASK_SUBROUTINE_NV
		swigIntConstant( GL_TASK_SUBROUTINE_NV, "GL_TASK_SUBROUTINE_NV" );
	#endif
	#ifdef GL_MESH_SUBROUTINE_UNIFORM_NV
		swigIntConstant( GL_MESH_SUBROUTINE_UNIFORM_NV, "GL_MESH_SUBROUTINE_UNIFORM_NV" );
	#endif
	#ifdef GL_TASK_SUBROUTINE_UNIFORM_NV
		swigIntConstant( GL_TASK_SUBROUTINE_UNIFORM_NV, "GL_TASK_SUBROUTINE_UNIFORM_NV" );
	#endif
	#ifdef GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_MESH_SHADER_NV
		swigIntConstant( GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_MESH_SHADER_NV, "GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_MESH_SHADER_NV" );
	#endif
	#ifdef GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TASK_SHADER_NV
		swigIntConstant( GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TASK_SHADER_NV, "GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TASK_SHADER_NV" );
	#endif
	#ifdef GL_NV_multisample_coverage
		swigIntConstant( GL_NV_multisample_coverage, "GL_NV_multisample_coverage" );
	#endif
	#ifdef GL_NV_multisample_filter_hint
		swigIntConstant( GL_NV_multisample_filter_hint, "GL_NV_multisample_filter_hint" );
	#endif
	#ifdef GL_MULTISAMPLE_FILTER_HINT_NV
		swigIntConstant( GL_MULTISAMPLE_FILTER_HINT_NV, "GL_MULTISAMPLE_FILTER_HINT_NV" );
	#endif
	#ifdef GL_NV_occlusion_query
		swigIntConstant( GL_NV_occlusion_query, "GL_NV_occlusion_query" );
	#endif
	#ifdef GL_PIXEL_COUNTER_BITS_NV
		swigIntConstant( GL_PIXEL_COUNTER_BITS_NV, "GL_PIXEL_COUNTER_BITS_NV" );
	#endif
	#ifdef GL_CURRENT_OCCLUSION_QUERY_ID_NV
		swigIntConstant( GL_CURRENT_OCCLUSION_QUERY_ID_NV, "GL_CURRENT_OCCLUSION_QUERY_ID_NV" );
	#endif
	#ifdef GL_PIXEL_COUNT_NV
		swigIntConstant( GL_PIXEL_COUNT_NV, "GL_PIXEL_COUNT_NV" );
	#endif
	#ifdef GL_PIXEL_COUNT_AVAILABLE_NV
		swigIntConstant( GL_PIXEL_COUNT_AVAILABLE_NV, "GL_PIXEL_COUNT_AVAILABLE_NV" );
	#endif
	#ifdef GL_NV_packed_depth_stencil
		swigIntConstant( GL_NV_packed_depth_stencil, "GL_NV_packed_depth_stencil" );
	#endif
	#ifdef GL_DEPTH_STENCIL_NV
		swigIntConstant( GL_DEPTH_STENCIL_NV, "GL_DEPTH_STENCIL_NV" );
	#endif
	#ifdef GL_UNSIGNED_INT_24_8_NV
		swigIntConstant( GL_UNSIGNED_INT_24_8_NV, "GL_UNSIGNED_INT_24_8_NV" );
	#endif
	#ifdef GL_NV_parameter_buffer_object
		swigIntConstant( GL_NV_parameter_buffer_object, "GL_NV_parameter_buffer_object" );
	#endif
	#ifdef GL_MAX_PROGRAM_PARAMETER_BUFFER_BINDINGS_NV
		swigIntConstant( GL_MAX_PROGRAM_PARAMETER_BUFFER_BINDINGS_NV, "GL_MAX_PROGRAM_PARAMETER_BUFFER_BINDINGS_NV" );
	#endif
	#ifdef GL_MAX_PROGRAM_PARAMETER_BUFFER_SIZE_NV
		swigIntConstant( GL_MAX_PROGRAM_PARAMETER_BUFFER_SIZE_NV, "GL_MAX_PROGRAM_PARAMETER_BUFFER_SIZE_NV" );
	#endif
	#ifdef GL_VERTEX_PROGRAM_PARAMETER_BUFFER_NV
		swigIntConstant( GL_VERTEX_PROGRAM_PARAMETER_BUFFER_NV, "GL_VERTEX_PROGRAM_PARAMETER_BUFFER_NV" );
	#endif
	#ifdef GL_GEOMETRY_PROGRAM_PARAMETER_BUFFER_NV
		swigIntConstant( GL_GEOMETRY_PROGRAM_PARAMETER_BUFFER_NV, "GL_GEOMETRY_PROGRAM_PARAMETER_BUFFER_NV" );
	#endif
	#ifdef GL_FRAGMENT_PROGRAM_PARAMETER_BUFFER_NV
		swigIntConstant( GL_FRAGMENT_PROGRAM_PARAMETER_BUFFER_NV, "GL_FRAGMENT_PROGRAM_PARAMETER_BUFFER_NV" );
	#endif
	#ifdef GL_NV_parameter_buffer_object2
		swigIntConstant( GL_NV_parameter_buffer_object2, "GL_NV_parameter_buffer_object2" );
	#endif
	#ifdef GL_NV_path_rendering
		swigIntConstant( GL_NV_path_rendering, "GL_NV_path_rendering" );
	#endif
	#ifdef GL_PATH_FORMAT_SVG_NV
		swigIntConstant( GL_PATH_FORMAT_SVG_NV, "GL_PATH_FORMAT_SVG_NV" );
	#endif
	#ifdef GL_PATH_FORMAT_PS_NV
		swigIntConstant( GL_PATH_FORMAT_PS_NV, "GL_PATH_FORMAT_PS_NV" );
	#endif
	#ifdef GL_STANDARD_FONT_NAME_NV
		swigIntConstant( GL_STANDARD_FONT_NAME_NV, "GL_STANDARD_FONT_NAME_NV" );
	#endif
	#ifdef GL_SYSTEM_FONT_NAME_NV
		swigIntConstant( GL_SYSTEM_FONT_NAME_NV, "GL_SYSTEM_FONT_NAME_NV" );
	#endif
	#ifdef GL_FILE_NAME_NV
		swigIntConstant( GL_FILE_NAME_NV, "GL_FILE_NAME_NV" );
	#endif
	#ifdef GL_PATH_STROKE_WIDTH_NV
		swigIntConstant( GL_PATH_STROKE_WIDTH_NV, "GL_PATH_STROKE_WIDTH_NV" );
	#endif
	#ifdef GL_PATH_END_CAPS_NV
		swigIntConstant( GL_PATH_END_CAPS_NV, "GL_PATH_END_CAPS_NV" );
	#endif
	#ifdef GL_PATH_INITIAL_END_CAP_NV
		swigIntConstant( GL_PATH_INITIAL_END_CAP_NV, "GL_PATH_INITIAL_END_CAP_NV" );
	#endif
	#ifdef GL_PATH_TERMINAL_END_CAP_NV
		swigIntConstant( GL_PATH_TERMINAL_END_CAP_NV, "GL_PATH_TERMINAL_END_CAP_NV" );
	#endif
	#ifdef GL_PATH_JOIN_STYLE_NV
		swigIntConstant( GL_PATH_JOIN_STYLE_NV, "GL_PATH_JOIN_STYLE_NV" );
	#endif
	#ifdef GL_PATH_MITER_LIMIT_NV
		swigIntConstant( GL_PATH_MITER_LIMIT_NV, "GL_PATH_MITER_LIMIT_NV" );
	#endif
	#ifdef GL_PATH_DASH_CAPS_NV
		swigIntConstant( GL_PATH_DASH_CAPS_NV, "GL_PATH_DASH_CAPS_NV" );
	#endif
	#ifdef GL_PATH_INITIAL_DASH_CAP_NV
		swigIntConstant( GL_PATH_INITIAL_DASH_CAP_NV, "GL_PATH_INITIAL_DASH_CAP_NV" );
	#endif
	#ifdef GL_PATH_TERMINAL_DASH_CAP_NV
		swigIntConstant( GL_PATH_TERMINAL_DASH_CAP_NV, "GL_PATH_TERMINAL_DASH_CAP_NV" );
	#endif
	#ifdef GL_PATH_DASH_OFFSET_NV
		swigIntConstant( GL_PATH_DASH_OFFSET_NV, "GL_PATH_DASH_OFFSET_NV" );
	#endif
	#ifdef GL_PATH_CLIENT_LENGTH_NV
		swigIntConstant( GL_PATH_CLIENT_LENGTH_NV, "GL_PATH_CLIENT_LENGTH_NV" );
	#endif
	#ifdef GL_PATH_FILL_MODE_NV
		swigIntConstant( GL_PATH_FILL_MODE_NV, "GL_PATH_FILL_MODE_NV" );
	#endif
	#ifdef GL_PATH_FILL_MASK_NV
		swigIntConstant( GL_PATH_FILL_MASK_NV, "GL_PATH_FILL_MASK_NV" );
	#endif
	#ifdef GL_PATH_FILL_COVER_MODE_NV
		swigIntConstant( GL_PATH_FILL_COVER_MODE_NV, "GL_PATH_FILL_COVER_MODE_NV" );
	#endif
	#ifdef GL_PATH_STROKE_COVER_MODE_NV
		swigIntConstant( GL_PATH_STROKE_COVER_MODE_NV, "GL_PATH_STROKE_COVER_MODE_NV" );
	#endif
	#ifdef GL_PATH_STROKE_MASK_NV
		swigIntConstant( GL_PATH_STROKE_MASK_NV, "GL_PATH_STROKE_MASK_NV" );
	#endif
	#ifdef GL_COUNT_UP_NV
		swigIntConstant( GL_COUNT_UP_NV, "GL_COUNT_UP_NV" );
	#endif
	#ifdef GL_COUNT_DOWN_NV
		swigIntConstant( GL_COUNT_DOWN_NV, "GL_COUNT_DOWN_NV" );
	#endif
	#ifdef GL_PATH_OBJECT_BOUNDING_BOX_NV
		swigIntConstant( GL_PATH_OBJECT_BOUNDING_BOX_NV, "GL_PATH_OBJECT_BOUNDING_BOX_NV" );
	#endif
	#ifdef GL_CONVEX_HULL_NV
		swigIntConstant( GL_CONVEX_HULL_NV, "GL_CONVEX_HULL_NV" );
	#endif
	#ifdef GL_BOUNDING_BOX_NV
		swigIntConstant( GL_BOUNDING_BOX_NV, "GL_BOUNDING_BOX_NV" );
	#endif
	#ifdef GL_TRANSLATE_X_NV
		swigIntConstant( GL_TRANSLATE_X_NV, "GL_TRANSLATE_X_NV" );
	#endif
	#ifdef GL_TRANSLATE_Y_NV
		swigIntConstant( GL_TRANSLATE_Y_NV, "GL_TRANSLATE_Y_NV" );
	#endif
	#ifdef GL_TRANSLATE_2D_NV
		swigIntConstant( GL_TRANSLATE_2D_NV, "GL_TRANSLATE_2D_NV" );
	#endif
	#ifdef GL_TRANSLATE_3D_NV
		swigIntConstant( GL_TRANSLATE_3D_NV, "GL_TRANSLATE_3D_NV" );
	#endif
	#ifdef GL_AFFINE_2D_NV
		swigIntConstant( GL_AFFINE_2D_NV, "GL_AFFINE_2D_NV" );
	#endif
	#ifdef GL_AFFINE_3D_NV
		swigIntConstant( GL_AFFINE_3D_NV, "GL_AFFINE_3D_NV" );
	#endif
	#ifdef GL_TRANSPOSE_AFFINE_2D_NV
		swigIntConstant( GL_TRANSPOSE_AFFINE_2D_NV, "GL_TRANSPOSE_AFFINE_2D_NV" );
	#endif
	#ifdef GL_TRANSPOSE_AFFINE_3D_NV
		swigIntConstant( GL_TRANSPOSE_AFFINE_3D_NV, "GL_TRANSPOSE_AFFINE_3D_NV" );
	#endif
	#ifdef GL_UTF8_NV
		swigIntConstant( GL_UTF8_NV, "GL_UTF8_NV" );
	#endif
	#ifdef GL_UTF16_NV
		swigIntConstant( GL_UTF16_NV, "GL_UTF16_NV" );
	#endif
	#ifdef GL_BOUNDING_BOX_OF_BOUNDING_BOXES_NV
		swigIntConstant( GL_BOUNDING_BOX_OF_BOUNDING_BOXES_NV, "GL_BOUNDING_BOX_OF_BOUNDING_BOXES_NV" );
	#endif
	#ifdef GL_PATH_COMMAND_COUNT_NV
		swigIntConstant( GL_PATH_COMMAND_COUNT_NV, "GL_PATH_COMMAND_COUNT_NV" );
	#endif
	#ifdef GL_PATH_COORD_COUNT_NV
		swigIntConstant( GL_PATH_COORD_COUNT_NV, "GL_PATH_COORD_COUNT_NV" );
	#endif
	#ifdef GL_PATH_DASH_ARRAY_COUNT_NV
		swigIntConstant( GL_PATH_DASH_ARRAY_COUNT_NV, "GL_PATH_DASH_ARRAY_COUNT_NV" );
	#endif
	#ifdef GL_PATH_COMPUTED_LENGTH_NV
		swigIntConstant( GL_PATH_COMPUTED_LENGTH_NV, "GL_PATH_COMPUTED_LENGTH_NV" );
	#endif
	#ifdef GL_PATH_FILL_BOUNDING_BOX_NV
		swigIntConstant( GL_PATH_FILL_BOUNDING_BOX_NV, "GL_PATH_FILL_BOUNDING_BOX_NV" );
	#endif
	#ifdef GL_PATH_STROKE_BOUNDING_BOX_NV
		swigIntConstant( GL_PATH_STROKE_BOUNDING_BOX_NV, "GL_PATH_STROKE_BOUNDING_BOX_NV" );
	#endif
	#ifdef GL_SQUARE_NV
		swigIntConstant( GL_SQUARE_NV, "GL_SQUARE_NV" );
	#endif
	#ifdef GL_ROUND_NV
		swigIntConstant( GL_ROUND_NV, "GL_ROUND_NV" );
	#endif
	#ifdef GL_TRIANGULAR_NV
		swigIntConstant( GL_TRIANGULAR_NV, "GL_TRIANGULAR_NV" );
	#endif
	#ifdef GL_BEVEL_NV
		swigIntConstant( GL_BEVEL_NV, "GL_BEVEL_NV" );
	#endif
	#ifdef GL_MITER_REVERT_NV
		swigIntConstant( GL_MITER_REVERT_NV, "GL_MITER_REVERT_NV" );
	#endif
	#ifdef GL_MITER_TRUNCATE_NV
		swigIntConstant( GL_MITER_TRUNCATE_NV, "GL_MITER_TRUNCATE_NV" );
	#endif
	#ifdef GL_SKIP_MISSING_GLYPH_NV
		swigIntConstant( GL_SKIP_MISSING_GLYPH_NV, "GL_SKIP_MISSING_GLYPH_NV" );
	#endif
	#ifdef GL_USE_MISSING_GLYPH_NV
		swigIntConstant( GL_USE_MISSING_GLYPH_NV, "GL_USE_MISSING_GLYPH_NV" );
	#endif
	#ifdef GL_PATH_ERROR_POSITION_NV
		swigIntConstant( GL_PATH_ERROR_POSITION_NV, "GL_PATH_ERROR_POSITION_NV" );
	#endif
	#ifdef GL_ACCUM_ADJACENT_PAIRS_NV
		swigIntConstant( GL_ACCUM_ADJACENT_PAIRS_NV, "GL_ACCUM_ADJACENT_PAIRS_NV" );
	#endif
	#ifdef GL_ADJACENT_PAIRS_NV
		swigIntConstant( GL_ADJACENT_PAIRS_NV, "GL_ADJACENT_PAIRS_NV" );
	#endif
	#ifdef GL_FIRST_TO_REST_NV
		swigIntConstant( GL_FIRST_TO_REST_NV, "GL_FIRST_TO_REST_NV" );
	#endif
	#ifdef GL_PATH_GEN_MODE_NV
		swigIntConstant( GL_PATH_GEN_MODE_NV, "GL_PATH_GEN_MODE_NV" );
	#endif
	#ifdef GL_PATH_GEN_COEFF_NV
		swigIntConstant( GL_PATH_GEN_COEFF_NV, "GL_PATH_GEN_COEFF_NV" );
	#endif
	#ifdef GL_PATH_GEN_COMPONENTS_NV
		swigIntConstant( GL_PATH_GEN_COMPONENTS_NV, "GL_PATH_GEN_COMPONENTS_NV" );
	#endif
	#ifdef GL_PATH_STENCIL_FUNC_NV
		swigIntConstant( GL_PATH_STENCIL_FUNC_NV, "GL_PATH_STENCIL_FUNC_NV" );
	#endif
	#ifdef GL_PATH_STENCIL_REF_NV
		swigIntConstant( GL_PATH_STENCIL_REF_NV, "GL_PATH_STENCIL_REF_NV" );
	#endif
	#ifdef GL_PATH_STENCIL_VALUE_MASK_NV
		swigIntConstant( GL_PATH_STENCIL_VALUE_MASK_NV, "GL_PATH_STENCIL_VALUE_MASK_NV" );
	#endif
	#ifdef GL_PATH_STENCIL_DEPTH_OFFSET_FACTOR_NV
		swigIntConstant( GL_PATH_STENCIL_DEPTH_OFFSET_FACTOR_NV, "GL_PATH_STENCIL_DEPTH_OFFSET_FACTOR_NV" );
	#endif
	#ifdef GL_PATH_STENCIL_DEPTH_OFFSET_UNITS_NV
		swigIntConstant( GL_PATH_STENCIL_DEPTH_OFFSET_UNITS_NV, "GL_PATH_STENCIL_DEPTH_OFFSET_UNITS_NV" );
	#endif
	#ifdef GL_PATH_COVER_DEPTH_FUNC_NV
		swigIntConstant( GL_PATH_COVER_DEPTH_FUNC_NV, "GL_PATH_COVER_DEPTH_FUNC_NV" );
	#endif
	#ifdef GL_PATH_DASH_OFFSET_RESET_NV
		swigIntConstant( GL_PATH_DASH_OFFSET_RESET_NV, "GL_PATH_DASH_OFFSET_RESET_NV" );
	#endif
	#ifdef GL_MOVE_TO_RESETS_NV
		swigIntConstant( GL_MOVE_TO_RESETS_NV, "GL_MOVE_TO_RESETS_NV" );
	#endif
	#ifdef GL_MOVE_TO_CONTINUES_NV
		swigIntConstant( GL_MOVE_TO_CONTINUES_NV, "GL_MOVE_TO_CONTINUES_NV" );
	#endif
	#ifdef GL_CLOSE_PATH_NV
		swigIntConstant( GL_CLOSE_PATH_NV, "GL_CLOSE_PATH_NV" );
	#endif
	#ifdef GL_MOVE_TO_NV
		swigIntConstant( GL_MOVE_TO_NV, "GL_MOVE_TO_NV" );
	#endif
	#ifdef GL_RELATIVE_MOVE_TO_NV
		swigIntConstant( GL_RELATIVE_MOVE_TO_NV, "GL_RELATIVE_MOVE_TO_NV" );
	#endif
	#ifdef GL_LINE_TO_NV
		swigIntConstant( GL_LINE_TO_NV, "GL_LINE_TO_NV" );
	#endif
	#ifdef GL_RELATIVE_LINE_TO_NV
		swigIntConstant( GL_RELATIVE_LINE_TO_NV, "GL_RELATIVE_LINE_TO_NV" );
	#endif
	#ifdef GL_HORIZONTAL_LINE_TO_NV
		swigIntConstant( GL_HORIZONTAL_LINE_TO_NV, "GL_HORIZONTAL_LINE_TO_NV" );
	#endif
	#ifdef GL_RELATIVE_HORIZONTAL_LINE_TO_NV
		swigIntConstant( GL_RELATIVE_HORIZONTAL_LINE_TO_NV, "GL_RELATIVE_HORIZONTAL_LINE_TO_NV" );
	#endif
	#ifdef GL_VERTICAL_LINE_TO_NV
		swigIntConstant( GL_VERTICAL_LINE_TO_NV, "GL_VERTICAL_LINE_TO_NV" );
	#endif
	#ifdef GL_RELATIVE_VERTICAL_LINE_TO_NV
		swigIntConstant( GL_RELATIVE_VERTICAL_LINE_TO_NV, "GL_RELATIVE_VERTICAL_LINE_TO_NV" );
	#endif
	#ifdef GL_QUADRATIC_CURVE_TO_NV
		swigIntConstant( GL_QUADRATIC_CURVE_TO_NV, "GL_QUADRATIC_CURVE_TO_NV" );
	#endif
	#ifdef GL_RELATIVE_QUADRATIC_CURVE_TO_NV
		swigIntConstant( GL_RELATIVE_QUADRATIC_CURVE_TO_NV, "GL_RELATIVE_QUADRATIC_CURVE_TO_NV" );
	#endif
	#ifdef GL_CUBIC_CURVE_TO_NV
		swigIntConstant( GL_CUBIC_CURVE_TO_NV, "GL_CUBIC_CURVE_TO_NV" );
	#endif
	#ifdef GL_RELATIVE_CUBIC_CURVE_TO_NV
		swigIntConstant( GL_RELATIVE_CUBIC_CURVE_TO_NV, "GL_RELATIVE_CUBIC_CURVE_TO_NV" );
	#endif
	#ifdef GL_SMOOTH_QUADRATIC_CURVE_TO_NV
		swigIntConstant( GL_SMOOTH_QUADRATIC_CURVE_TO_NV, "GL_SMOOTH_QUADRATIC_CURVE_TO_NV" );
	#endif
	#ifdef GL_RELATIVE_SMOOTH_QUADRATIC_CURVE_TO_NV
		swigIntConstant( GL_RELATIVE_SMOOTH_QUADRATIC_CURVE_TO_NV, "GL_RELATIVE_SMOOTH_QUADRATIC_CURVE_TO_NV" );
	#endif
	#ifdef GL_SMOOTH_CUBIC_CURVE_TO_NV
		swigIntConstant( GL_SMOOTH_CUBIC_CURVE_TO_NV, "GL_SMOOTH_CUBIC_CURVE_TO_NV" );
	#endif
	#ifdef GL_RELATIVE_SMOOTH_CUBIC_CURVE_TO_NV
		swigIntConstant( GL_RELATIVE_SMOOTH_CUBIC_CURVE_TO_NV, "GL_RELATIVE_SMOOTH_CUBIC_CURVE_TO_NV" );
	#endif
	#ifdef GL_SMALL_CCW_ARC_TO_NV
		swigIntConstant( GL_SMALL_CCW_ARC_TO_NV, "GL_SMALL_CCW_ARC_TO_NV" );
	#endif
	#ifdef GL_RELATIVE_SMALL_CCW_ARC_TO_NV
		swigIntConstant( GL_RELATIVE_SMALL_CCW_ARC_TO_NV, "GL_RELATIVE_SMALL_CCW_ARC_TO_NV" );
	#endif
	#ifdef GL_SMALL_CW_ARC_TO_NV
		swigIntConstant( GL_SMALL_CW_ARC_TO_NV, "GL_SMALL_CW_ARC_TO_NV" );
	#endif
	#ifdef GL_RELATIVE_SMALL_CW_ARC_TO_NV
		swigIntConstant( GL_RELATIVE_SMALL_CW_ARC_TO_NV, "GL_RELATIVE_SMALL_CW_ARC_TO_NV" );
	#endif
	#ifdef GL_LARGE_CCW_ARC_TO_NV
		swigIntConstant( GL_LARGE_CCW_ARC_TO_NV, "GL_LARGE_CCW_ARC_TO_NV" );
	#endif
	#ifdef GL_RELATIVE_LARGE_CCW_ARC_TO_NV
		swigIntConstant( GL_RELATIVE_LARGE_CCW_ARC_TO_NV, "GL_RELATIVE_LARGE_CCW_ARC_TO_NV" );
	#endif
	#ifdef GL_LARGE_CW_ARC_TO_NV
		swigIntConstant( GL_LARGE_CW_ARC_TO_NV, "GL_LARGE_CW_ARC_TO_NV" );
	#endif
	#ifdef GL_RELATIVE_LARGE_CW_ARC_TO_NV
		swigIntConstant( GL_RELATIVE_LARGE_CW_ARC_TO_NV, "GL_RELATIVE_LARGE_CW_ARC_TO_NV" );
	#endif
	#ifdef GL_RESTART_PATH_NV
		swigIntConstant( GL_RESTART_PATH_NV, "GL_RESTART_PATH_NV" );
	#endif
	#ifdef GL_DUP_FIRST_CUBIC_CURVE_TO_NV
		swigIntConstant( GL_DUP_FIRST_CUBIC_CURVE_TO_NV, "GL_DUP_FIRST_CUBIC_CURVE_TO_NV" );
	#endif
	#ifdef GL_DUP_LAST_CUBIC_CURVE_TO_NV
		swigIntConstant( GL_DUP_LAST_CUBIC_CURVE_TO_NV, "GL_DUP_LAST_CUBIC_CURVE_TO_NV" );
	#endif
	#ifdef GL_RECT_NV
		swigIntConstant( GL_RECT_NV, "GL_RECT_NV" );
	#endif
	#ifdef GL_CIRCULAR_CCW_ARC_TO_NV
		swigIntConstant( GL_CIRCULAR_CCW_ARC_TO_NV, "GL_CIRCULAR_CCW_ARC_TO_NV" );
	#endif
	#ifdef GL_CIRCULAR_CW_ARC_TO_NV
		swigIntConstant( GL_CIRCULAR_CW_ARC_TO_NV, "GL_CIRCULAR_CW_ARC_TO_NV" );
	#endif
	#ifdef GL_CIRCULAR_TANGENT_ARC_TO_NV
		swigIntConstant( GL_CIRCULAR_TANGENT_ARC_TO_NV, "GL_CIRCULAR_TANGENT_ARC_TO_NV" );
	#endif
	#ifdef GL_ARC_TO_NV
		swigIntConstant( GL_ARC_TO_NV, "GL_ARC_TO_NV" );
	#endif
	#ifdef GL_RELATIVE_ARC_TO_NV
		swigIntConstant( GL_RELATIVE_ARC_TO_NV, "GL_RELATIVE_ARC_TO_NV" );
	#endif
	#ifdef GL_BOLD_BIT_NV
		swigIntConstant( GL_BOLD_BIT_NV, "GL_BOLD_BIT_NV" );
	#endif
	#ifdef GL_ITALIC_BIT_NV
		swigIntConstant( GL_ITALIC_BIT_NV, "GL_ITALIC_BIT_NV" );
	#endif
	#ifdef GL_GLYPH_WIDTH_BIT_NV
		swigIntConstant( GL_GLYPH_WIDTH_BIT_NV, "GL_GLYPH_WIDTH_BIT_NV" );
	#endif
	#ifdef GL_GLYPH_HEIGHT_BIT_NV
		swigIntConstant( GL_GLYPH_HEIGHT_BIT_NV, "GL_GLYPH_HEIGHT_BIT_NV" );
	#endif
	#ifdef GL_GLYPH_HORIZONTAL_BEARING_X_BIT_NV
		swigIntConstant( GL_GLYPH_HORIZONTAL_BEARING_X_BIT_NV, "GL_GLYPH_HORIZONTAL_BEARING_X_BIT_NV" );
	#endif
	#ifdef GL_GLYPH_HORIZONTAL_BEARING_Y_BIT_NV
		swigIntConstant( GL_GLYPH_HORIZONTAL_BEARING_Y_BIT_NV, "GL_GLYPH_HORIZONTAL_BEARING_Y_BIT_NV" );
	#endif
	#ifdef GL_GLYPH_HORIZONTAL_BEARING_ADVANCE_BIT_NV
		swigIntConstant( GL_GLYPH_HORIZONTAL_BEARING_ADVANCE_BIT_NV, "GL_GLYPH_HORIZONTAL_BEARING_ADVANCE_BIT_NV" );
	#endif
	#ifdef GL_GLYPH_VERTICAL_BEARING_X_BIT_NV
		swigIntConstant( GL_GLYPH_VERTICAL_BEARING_X_BIT_NV, "GL_GLYPH_VERTICAL_BEARING_X_BIT_NV" );
	#endif
	#ifdef GL_GLYPH_VERTICAL_BEARING_Y_BIT_NV
		swigIntConstant( GL_GLYPH_VERTICAL_BEARING_Y_BIT_NV, "GL_GLYPH_VERTICAL_BEARING_Y_BIT_NV" );
	#endif
	#ifdef GL_GLYPH_VERTICAL_BEARING_ADVANCE_BIT_NV
		swigIntConstant( GL_GLYPH_VERTICAL_BEARING_ADVANCE_BIT_NV, "GL_GLYPH_VERTICAL_BEARING_ADVANCE_BIT_NV" );
	#endif
	#ifdef GL_GLYPH_HAS_KERNING_BIT_NV
		swigIntConstant( GL_GLYPH_HAS_KERNING_BIT_NV, "GL_GLYPH_HAS_KERNING_BIT_NV" );
	#endif
	#ifdef GL_FONT_X_MIN_BOUNDS_BIT_NV
		swigIntConstant( GL_FONT_X_MIN_BOUNDS_BIT_NV, "GL_FONT_X_MIN_BOUNDS_BIT_NV" );
	#endif
	#ifdef GL_FONT_Y_MIN_BOUNDS_BIT_NV
		swigIntConstant( GL_FONT_Y_MIN_BOUNDS_BIT_NV, "GL_FONT_Y_MIN_BOUNDS_BIT_NV" );
	#endif
	#ifdef GL_FONT_X_MAX_BOUNDS_BIT_NV
		swigIntConstant( GL_FONT_X_MAX_BOUNDS_BIT_NV, "GL_FONT_X_MAX_BOUNDS_BIT_NV" );
	#endif
	#ifdef GL_FONT_Y_MAX_BOUNDS_BIT_NV
		swigIntConstant( GL_FONT_Y_MAX_BOUNDS_BIT_NV, "GL_FONT_Y_MAX_BOUNDS_BIT_NV" );
	#endif
	#ifdef GL_FONT_UNITS_PER_EM_BIT_NV
		swigIntConstant( GL_FONT_UNITS_PER_EM_BIT_NV, "GL_FONT_UNITS_PER_EM_BIT_NV" );
	#endif
	#ifdef GL_FONT_ASCENDER_BIT_NV
		swigIntConstant( GL_FONT_ASCENDER_BIT_NV, "GL_FONT_ASCENDER_BIT_NV" );
	#endif
	#ifdef GL_FONT_DESCENDER_BIT_NV
		swigIntConstant( GL_FONT_DESCENDER_BIT_NV, "GL_FONT_DESCENDER_BIT_NV" );
	#endif
	#ifdef GL_FONT_HEIGHT_BIT_NV
		swigIntConstant( GL_FONT_HEIGHT_BIT_NV, "GL_FONT_HEIGHT_BIT_NV" );
	#endif
	#ifdef GL_FONT_MAX_ADVANCE_WIDTH_BIT_NV
		swigIntConstant( GL_FONT_MAX_ADVANCE_WIDTH_BIT_NV, "GL_FONT_MAX_ADVANCE_WIDTH_BIT_NV" );
	#endif
	#ifdef GL_FONT_MAX_ADVANCE_HEIGHT_BIT_NV
		swigIntConstant( GL_FONT_MAX_ADVANCE_HEIGHT_BIT_NV, "GL_FONT_MAX_ADVANCE_HEIGHT_BIT_NV" );
	#endif
	#ifdef GL_FONT_UNDERLINE_POSITION_BIT_NV
		swigIntConstant( GL_FONT_UNDERLINE_POSITION_BIT_NV, "GL_FONT_UNDERLINE_POSITION_BIT_NV" );
	#endif
	#ifdef GL_FONT_UNDERLINE_THICKNESS_BIT_NV
		swigIntConstant( GL_FONT_UNDERLINE_THICKNESS_BIT_NV, "GL_FONT_UNDERLINE_THICKNESS_BIT_NV" );
	#endif
	#ifdef GL_FONT_HAS_KERNING_BIT_NV
		swigIntConstant( GL_FONT_HAS_KERNING_BIT_NV, "GL_FONT_HAS_KERNING_BIT_NV" );
	#endif
	#ifdef GL_ROUNDED_RECT_NV
		swigIntConstant( GL_ROUNDED_RECT_NV, "GL_ROUNDED_RECT_NV" );
	#endif
	#ifdef GL_RELATIVE_ROUNDED_RECT_NV
		swigIntConstant( GL_RELATIVE_ROUNDED_RECT_NV, "GL_RELATIVE_ROUNDED_RECT_NV" );
	#endif
	#ifdef GL_ROUNDED_RECT2_NV
		swigIntConstant( GL_ROUNDED_RECT2_NV, "GL_ROUNDED_RECT2_NV" );
	#endif
	#ifdef GL_RELATIVE_ROUNDED_RECT2_NV
		swigIntConstant( GL_RELATIVE_ROUNDED_RECT2_NV, "GL_RELATIVE_ROUNDED_RECT2_NV" );
	#endif
	#ifdef GL_ROUNDED_RECT4_NV
		swigIntConstant( GL_ROUNDED_RECT4_NV, "GL_ROUNDED_RECT4_NV" );
	#endif
	#ifdef GL_RELATIVE_ROUNDED_RECT4_NV
		swigIntConstant( GL_RELATIVE_ROUNDED_RECT4_NV, "GL_RELATIVE_ROUNDED_RECT4_NV" );
	#endif
	#ifdef GL_ROUNDED_RECT8_NV
		swigIntConstant( GL_ROUNDED_RECT8_NV, "GL_ROUNDED_RECT8_NV" );
	#endif
	#ifdef GL_RELATIVE_ROUNDED_RECT8_NV
		swigIntConstant( GL_RELATIVE_ROUNDED_RECT8_NV, "GL_RELATIVE_ROUNDED_RECT8_NV" );
	#endif
	#ifdef GL_RELATIVE_RECT_NV
		swigIntConstant( GL_RELATIVE_RECT_NV, "GL_RELATIVE_RECT_NV" );
	#endif
	#ifdef GL_FONT_GLYPHS_AVAILABLE_NV
		swigIntConstant( GL_FONT_GLYPHS_AVAILABLE_NV, "GL_FONT_GLYPHS_AVAILABLE_NV" );
	#endif
	#ifdef GL_FONT_TARGET_UNAVAILABLE_NV
		swigIntConstant( GL_FONT_TARGET_UNAVAILABLE_NV, "GL_FONT_TARGET_UNAVAILABLE_NV" );
	#endif
	#ifdef GL_FONT_UNAVAILABLE_NV
		swigIntConstant( GL_FONT_UNAVAILABLE_NV, "GL_FONT_UNAVAILABLE_NV" );
	#endif
	#ifdef GL_FONT_UNINTELLIGIBLE_NV
		swigIntConstant( GL_FONT_UNINTELLIGIBLE_NV, "GL_FONT_UNINTELLIGIBLE_NV" );
	#endif
	#ifdef GL_CONIC_CURVE_TO_NV
		swigIntConstant( GL_CONIC_CURVE_TO_NV, "GL_CONIC_CURVE_TO_NV" );
	#endif
	#ifdef GL_RELATIVE_CONIC_CURVE_TO_NV
		swigIntConstant( GL_RELATIVE_CONIC_CURVE_TO_NV, "GL_RELATIVE_CONIC_CURVE_TO_NV" );
	#endif
	#ifdef GL_FONT_NUM_GLYPH_INDICES_BIT_NV
		swigIntConstant( GL_FONT_NUM_GLYPH_INDICES_BIT_NV, "GL_FONT_NUM_GLYPH_INDICES_BIT_NV" );
	#endif
	#ifdef GL_STANDARD_FONT_FORMAT_NV
		swigIntConstant( GL_STANDARD_FONT_FORMAT_NV, "GL_STANDARD_FONT_FORMAT_NV" );
	#endif
	#ifdef GL_2_BYTES_NV
		swigIntConstant( GL_2_BYTES_NV, "GL_2_BYTES_NV" );
	#endif
	#ifdef GL_3_BYTES_NV
		swigIntConstant( GL_3_BYTES_NV, "GL_3_BYTES_NV" );
	#endif
	#ifdef GL_4_BYTES_NV
		swigIntConstant( GL_4_BYTES_NV, "GL_4_BYTES_NV" );
	#endif
	#ifdef GL_EYE_LINEAR_NV
		swigIntConstant( GL_EYE_LINEAR_NV, "GL_EYE_LINEAR_NV" );
	#endif
	#ifdef GL_OBJECT_LINEAR_NV
		swigIntConstant( GL_OBJECT_LINEAR_NV, "GL_OBJECT_LINEAR_NV" );
	#endif
	#ifdef GL_CONSTANT_NV
		swigIntConstant( GL_CONSTANT_NV, "GL_CONSTANT_NV" );
	#endif
	#ifdef GL_PATH_FOG_GEN_MODE_NV
		swigIntConstant( GL_PATH_FOG_GEN_MODE_NV, "GL_PATH_FOG_GEN_MODE_NV" );
	#endif
	#ifdef GL_PRIMARY_COLOR_NV
		swigIntConstant( GL_PRIMARY_COLOR_NV, "GL_PRIMARY_COLOR_NV" );
	#endif
	#ifdef GL_SECONDARY_COLOR_NV
		swigIntConstant( GL_SECONDARY_COLOR_NV, "GL_SECONDARY_COLOR_NV" );
	#endif
	#ifdef GL_PATH_GEN_COLOR_FORMAT_NV
		swigIntConstant( GL_PATH_GEN_COLOR_FORMAT_NV, "GL_PATH_GEN_COLOR_FORMAT_NV" );
	#endif
	#ifdef GL_PATH_PROJECTION_NV
		swigIntConstant( GL_PATH_PROJECTION_NV, "GL_PATH_PROJECTION_NV" );
	#endif
	#ifdef GL_PATH_MODELVIEW_NV
		swigIntConstant( GL_PATH_MODELVIEW_NV, "GL_PATH_MODELVIEW_NV" );
	#endif
	#ifdef GL_PATH_MODELVIEW_STACK_DEPTH_NV
		swigIntConstant( GL_PATH_MODELVIEW_STACK_DEPTH_NV, "GL_PATH_MODELVIEW_STACK_DEPTH_NV" );
	#endif
	#ifdef GL_PATH_MODELVIEW_MATRIX_NV
		swigIntConstant( GL_PATH_MODELVIEW_MATRIX_NV, "GL_PATH_MODELVIEW_MATRIX_NV" );
	#endif
	#ifdef GL_PATH_MAX_MODELVIEW_STACK_DEPTH_NV
		swigIntConstant( GL_PATH_MAX_MODELVIEW_STACK_DEPTH_NV, "GL_PATH_MAX_MODELVIEW_STACK_DEPTH_NV" );
	#endif
	#ifdef GL_PATH_TRANSPOSE_MODELVIEW_MATRIX_NV
		swigIntConstant( GL_PATH_TRANSPOSE_MODELVIEW_MATRIX_NV, "GL_PATH_TRANSPOSE_MODELVIEW_MATRIX_NV" );
	#endif
	#ifdef GL_PATH_PROJECTION_STACK_DEPTH_NV
		swigIntConstant( GL_PATH_PROJECTION_STACK_DEPTH_NV, "GL_PATH_PROJECTION_STACK_DEPTH_NV" );
	#endif
	#ifdef GL_PATH_PROJECTION_MATRIX_NV
		swigIntConstant( GL_PATH_PROJECTION_MATRIX_NV, "GL_PATH_PROJECTION_MATRIX_NV" );
	#endif
	#ifdef GL_PATH_MAX_PROJECTION_STACK_DEPTH_NV
		swigIntConstant( GL_PATH_MAX_PROJECTION_STACK_DEPTH_NV, "GL_PATH_MAX_PROJECTION_STACK_DEPTH_NV" );
	#endif
	#ifdef GL_PATH_TRANSPOSE_PROJECTION_MATRIX_NV
		swigIntConstant( GL_PATH_TRANSPOSE_PROJECTION_MATRIX_NV, "GL_PATH_TRANSPOSE_PROJECTION_MATRIX_NV" );
	#endif
	#ifdef GL_FRAGMENT_INPUT_NV
		swigIntConstant( GL_FRAGMENT_INPUT_NV, "GL_FRAGMENT_INPUT_NV" );
	#endif
	#ifdef GL_NV_path_rendering_shared_edge
		swigIntConstant( GL_NV_path_rendering_shared_edge, "GL_NV_path_rendering_shared_edge" );
	#endif
	#ifdef GL_SHARED_EDGE_NV
		swigIntConstant( GL_SHARED_EDGE_NV, "GL_SHARED_EDGE_NV" );
	#endif
	#ifdef GL_NV_pixel_data_range
		swigIntConstant( GL_NV_pixel_data_range, "GL_NV_pixel_data_range" );
	#endif
	#ifdef GL_WRITE_PIXEL_DATA_RANGE_NV
		swigIntConstant( GL_WRITE_PIXEL_DATA_RANGE_NV, "GL_WRITE_PIXEL_DATA_RANGE_NV" );
	#endif
	#ifdef GL_READ_PIXEL_DATA_RANGE_NV
		swigIntConstant( GL_READ_PIXEL_DATA_RANGE_NV, "GL_READ_PIXEL_DATA_RANGE_NV" );
	#endif
	#ifdef GL_WRITE_PIXEL_DATA_RANGE_LENGTH_NV
		swigIntConstant( GL_WRITE_PIXEL_DATA_RANGE_LENGTH_NV, "GL_WRITE_PIXEL_DATA_RANGE_LENGTH_NV" );
	#endif
	#ifdef GL_READ_PIXEL_DATA_RANGE_LENGTH_NV
		swigIntConstant( GL_READ_PIXEL_DATA_RANGE_LENGTH_NV, "GL_READ_PIXEL_DATA_RANGE_LENGTH_NV" );
	#endif
	#ifdef GL_WRITE_PIXEL_DATA_RANGE_POINTER_NV
		swigIntConstant( GL_WRITE_PIXEL_DATA_RANGE_POINTER_NV, "GL_WRITE_PIXEL_DATA_RANGE_POINTER_NV" );
	#endif
	#ifdef GL_READ_PIXEL_DATA_RANGE_POINTER_NV
		swigIntConstant( GL_READ_PIXEL_DATA_RANGE_POINTER_NV, "GL_READ_PIXEL_DATA_RANGE_POINTER_NV" );
	#endif
	#ifdef GL_NV_point_sprite
		swigIntConstant( GL_NV_point_sprite, "GL_NV_point_sprite" );
	#endif
	#ifdef GL_POINT_SPRITE_NV
		swigIntConstant( GL_POINT_SPRITE_NV, "GL_POINT_SPRITE_NV" );
	#endif
	#ifdef GL_COORD_REPLACE_NV
		swigIntConstant( GL_COORD_REPLACE_NV, "GL_COORD_REPLACE_NV" );
	#endif
	#ifdef GL_POINT_SPRITE_R_MODE_NV
		swigIntConstant( GL_POINT_SPRITE_R_MODE_NV, "GL_POINT_SPRITE_R_MODE_NV" );
	#endif
	#ifdef GL_NV_present_video
		swigIntConstant( GL_NV_present_video, "GL_NV_present_video" );
	#endif
	#ifdef GL_FRAME_NV
		swigIntConstant( GL_FRAME_NV, "GL_FRAME_NV" );
	#endif
	#ifdef GL_FIELDS_NV
		swigIntConstant( GL_FIELDS_NV, "GL_FIELDS_NV" );
	#endif
	#ifdef GL_CURRENT_TIME_NV
		swigIntConstant( GL_CURRENT_TIME_NV, "GL_CURRENT_TIME_NV" );
	#endif
	#ifdef GL_NUM_FILL_STREAMS_NV
		swigIntConstant( GL_NUM_FILL_STREAMS_NV, "GL_NUM_FILL_STREAMS_NV" );
	#endif
	#ifdef GL_PRESENT_TIME_NV
		swigIntConstant( GL_PRESENT_TIME_NV, "GL_PRESENT_TIME_NV" );
	#endif
	#ifdef GL_PRESENT_DURATION_NV
		swigIntConstant( GL_PRESENT_DURATION_NV, "GL_PRESENT_DURATION_NV" );
	#endif
	#ifdef GL_NV_primitive_restart
		swigIntConstant( GL_NV_primitive_restart, "GL_NV_primitive_restart" );
	#endif
	#ifdef GL_PRIMITIVE_RESTART_NV
		swigIntConstant( GL_PRIMITIVE_RESTART_NV, "GL_PRIMITIVE_RESTART_NV" );
	#endif
	#ifdef GL_PRIMITIVE_RESTART_INDEX_NV
		swigIntConstant( GL_PRIMITIVE_RESTART_INDEX_NV, "GL_PRIMITIVE_RESTART_INDEX_NV" );
	#endif
	#ifdef GL_NV_primitive_shading_rate
		swigIntConstant( GL_NV_primitive_shading_rate, "GL_NV_primitive_shading_rate" );
	#endif
	#ifdef GL_SHADING_RATE_IMAGE_PER_PRIMITIVE_NV
		swigIntConstant( GL_SHADING_RATE_IMAGE_PER_PRIMITIVE_NV, "GL_SHADING_RATE_IMAGE_PER_PRIMITIVE_NV" );
	#endif
	#ifdef GL_SHADING_RATE_IMAGE_PALETTE_COUNT_NV
		swigIntConstant( GL_SHADING_RATE_IMAGE_PALETTE_COUNT_NV, "GL_SHADING_RATE_IMAGE_PALETTE_COUNT_NV" );
	#endif
	#ifdef GL_NV_query_resource
		swigIntConstant( GL_NV_query_resource, "GL_NV_query_resource" );
	#endif
	#ifdef GL_QUERY_RESOURCE_TYPE_VIDMEM_ALLOC_NV
		swigIntConstant( GL_QUERY_RESOURCE_TYPE_VIDMEM_ALLOC_NV, "GL_QUERY_RESOURCE_TYPE_VIDMEM_ALLOC_NV" );
	#endif
	#ifdef GL_QUERY_RESOURCE_MEMTYPE_VIDMEM_NV
		swigIntConstant( GL_QUERY_RESOURCE_MEMTYPE_VIDMEM_NV, "GL_QUERY_RESOURCE_MEMTYPE_VIDMEM_NV" );
	#endif
	#ifdef GL_QUERY_RESOURCE_SYS_RESERVED_NV
		swigIntConstant( GL_QUERY_RESOURCE_SYS_RESERVED_NV, "GL_QUERY_RESOURCE_SYS_RESERVED_NV" );
	#endif
	#ifdef GL_QUERY_RESOURCE_TEXTURE_NV
		swigIntConstant( GL_QUERY_RESOURCE_TEXTURE_NV, "GL_QUERY_RESOURCE_TEXTURE_NV" );
	#endif
	#ifdef GL_QUERY_RESOURCE_RENDERBUFFER_NV
		swigIntConstant( GL_QUERY_RESOURCE_RENDERBUFFER_NV, "GL_QUERY_RESOURCE_RENDERBUFFER_NV" );
	#endif
	#ifdef GL_QUERY_RESOURCE_BUFFEROBJECT_NV
		swigIntConstant( GL_QUERY_RESOURCE_BUFFEROBJECT_NV, "GL_QUERY_RESOURCE_BUFFEROBJECT_NV" );
	#endif
	#ifdef GL_NV_query_resource_tag
		swigIntConstant( GL_NV_query_resource_tag, "GL_NV_query_resource_tag" );
	#endif
	#ifdef GL_NV_register_combiners
		swigIntConstant( GL_NV_register_combiners, "GL_NV_register_combiners" );
	#endif
	#ifdef GL_REGISTER_COMBINERS_NV
		swigIntConstant( GL_REGISTER_COMBINERS_NV, "GL_REGISTER_COMBINERS_NV" );
	#endif
	#ifdef GL_VARIABLE_A_NV
		swigIntConstant( GL_VARIABLE_A_NV, "GL_VARIABLE_A_NV" );
	#endif
	#ifdef GL_VARIABLE_B_NV
		swigIntConstant( GL_VARIABLE_B_NV, "GL_VARIABLE_B_NV" );
	#endif
	#ifdef GL_VARIABLE_C_NV
		swigIntConstant( GL_VARIABLE_C_NV, "GL_VARIABLE_C_NV" );
	#endif
	#ifdef GL_VARIABLE_D_NV
		swigIntConstant( GL_VARIABLE_D_NV, "GL_VARIABLE_D_NV" );
	#endif
	#ifdef GL_VARIABLE_E_NV
		swigIntConstant( GL_VARIABLE_E_NV, "GL_VARIABLE_E_NV" );
	#endif
	#ifdef GL_VARIABLE_F_NV
		swigIntConstant( GL_VARIABLE_F_NV, "GL_VARIABLE_F_NV" );
	#endif
	#ifdef GL_VARIABLE_G_NV
		swigIntConstant( GL_VARIABLE_G_NV, "GL_VARIABLE_G_NV" );
	#endif
	#ifdef GL_CONSTANT_COLOR0_NV
		swigIntConstant( GL_CONSTANT_COLOR0_NV, "GL_CONSTANT_COLOR0_NV" );
	#endif
	#ifdef GL_CONSTANT_COLOR1_NV
		swigIntConstant( GL_CONSTANT_COLOR1_NV, "GL_CONSTANT_COLOR1_NV" );
	#endif
	#ifdef GL_SPARE0_NV
		swigIntConstant( GL_SPARE0_NV, "GL_SPARE0_NV" );
	#endif
	#ifdef GL_SPARE1_NV
		swigIntConstant( GL_SPARE1_NV, "GL_SPARE1_NV" );
	#endif
	#ifdef GL_DISCARD_NV
		swigIntConstant( GL_DISCARD_NV, "GL_DISCARD_NV" );
	#endif
	#ifdef GL_E_TIMES_F_NV
		swigIntConstant( GL_E_TIMES_F_NV, "GL_E_TIMES_F_NV" );
	#endif
	#ifdef GL_SPARE0_PLUS_SECONDARY_COLOR_NV
		swigIntConstant( GL_SPARE0_PLUS_SECONDARY_COLOR_NV, "GL_SPARE0_PLUS_SECONDARY_COLOR_NV" );
	#endif
	#ifdef GL_UNSIGNED_IDENTITY_NV
		swigIntConstant( GL_UNSIGNED_IDENTITY_NV, "GL_UNSIGNED_IDENTITY_NV" );
	#endif
	#ifdef GL_UNSIGNED_INVERT_NV
		swigIntConstant( GL_UNSIGNED_INVERT_NV, "GL_UNSIGNED_INVERT_NV" );
	#endif
	#ifdef GL_EXPAND_NORMAL_NV
		swigIntConstant( GL_EXPAND_NORMAL_NV, "GL_EXPAND_NORMAL_NV" );
	#endif
	#ifdef GL_EXPAND_NEGATE_NV
		swigIntConstant( GL_EXPAND_NEGATE_NV, "GL_EXPAND_NEGATE_NV" );
	#endif
	#ifdef GL_HALF_BIAS_NORMAL_NV
		swigIntConstant( GL_HALF_BIAS_NORMAL_NV, "GL_HALF_BIAS_NORMAL_NV" );
	#endif
	#ifdef GL_HALF_BIAS_NEGATE_NV
		swigIntConstant( GL_HALF_BIAS_NEGATE_NV, "GL_HALF_BIAS_NEGATE_NV" );
	#endif
	#ifdef GL_SIGNED_IDENTITY_NV
		swigIntConstant( GL_SIGNED_IDENTITY_NV, "GL_SIGNED_IDENTITY_NV" );
	#endif
	#ifdef GL_SIGNED_NEGATE_NV
		swigIntConstant( GL_SIGNED_NEGATE_NV, "GL_SIGNED_NEGATE_NV" );
	#endif
	#ifdef GL_SCALE_BY_TWO_NV
		swigIntConstant( GL_SCALE_BY_TWO_NV, "GL_SCALE_BY_TWO_NV" );
	#endif
	#ifdef GL_SCALE_BY_FOUR_NV
		swigIntConstant( GL_SCALE_BY_FOUR_NV, "GL_SCALE_BY_FOUR_NV" );
	#endif
	#ifdef GL_SCALE_BY_ONE_HALF_NV
		swigIntConstant( GL_SCALE_BY_ONE_HALF_NV, "GL_SCALE_BY_ONE_HALF_NV" );
	#endif
	#ifdef GL_BIAS_BY_NEGATIVE_ONE_HALF_NV
		swigIntConstant( GL_BIAS_BY_NEGATIVE_ONE_HALF_NV, "GL_BIAS_BY_NEGATIVE_ONE_HALF_NV" );
	#endif
	#ifdef GL_COMBINER_INPUT_NV
		swigIntConstant( GL_COMBINER_INPUT_NV, "GL_COMBINER_INPUT_NV" );
	#endif
	#ifdef GL_COMBINER_MAPPING_NV
		swigIntConstant( GL_COMBINER_MAPPING_NV, "GL_COMBINER_MAPPING_NV" );
	#endif
	#ifdef GL_COMBINER_COMPONENT_USAGE_NV
		swigIntConstant( GL_COMBINER_COMPONENT_USAGE_NV, "GL_COMBINER_COMPONENT_USAGE_NV" );
	#endif
	#ifdef GL_COMBINER_AB_DOT_PRODUCT_NV
		swigIntConstant( GL_COMBINER_AB_DOT_PRODUCT_NV, "GL_COMBINER_AB_DOT_PRODUCT_NV" );
	#endif
	#ifdef GL_COMBINER_CD_DOT_PRODUCT_NV
		swigIntConstant( GL_COMBINER_CD_DOT_PRODUCT_NV, "GL_COMBINER_CD_DOT_PRODUCT_NV" );
	#endif
	#ifdef GL_COMBINER_MUX_SUM_NV
		swigIntConstant( GL_COMBINER_MUX_SUM_NV, "GL_COMBINER_MUX_SUM_NV" );
	#endif
	#ifdef GL_COMBINER_SCALE_NV
		swigIntConstant( GL_COMBINER_SCALE_NV, "GL_COMBINER_SCALE_NV" );
	#endif
	#ifdef GL_COMBINER_BIAS_NV
		swigIntConstant( GL_COMBINER_BIAS_NV, "GL_COMBINER_BIAS_NV" );
	#endif
	#ifdef GL_COMBINER_AB_OUTPUT_NV
		swigIntConstant( GL_COMBINER_AB_OUTPUT_NV, "GL_COMBINER_AB_OUTPUT_NV" );
	#endif
	#ifdef GL_COMBINER_CD_OUTPUT_NV
		swigIntConstant( GL_COMBINER_CD_OUTPUT_NV, "GL_COMBINER_CD_OUTPUT_NV" );
	#endif
	#ifdef GL_COMBINER_SUM_OUTPUT_NV
		swigIntConstant( GL_COMBINER_SUM_OUTPUT_NV, "GL_COMBINER_SUM_OUTPUT_NV" );
	#endif
	#ifdef GL_MAX_GENERAL_COMBINERS_NV
		swigIntConstant( GL_MAX_GENERAL_COMBINERS_NV, "GL_MAX_GENERAL_COMBINERS_NV" );
	#endif
	#ifdef GL_NUM_GENERAL_COMBINERS_NV
		swigIntConstant( GL_NUM_GENERAL_COMBINERS_NV, "GL_NUM_GENERAL_COMBINERS_NV" );
	#endif
	#ifdef GL_COLOR_SUM_CLAMP_NV
		swigIntConstant( GL_COLOR_SUM_CLAMP_NV, "GL_COLOR_SUM_CLAMP_NV" );
	#endif
	#ifdef GL_COMBINER0_NV
		swigIntConstant( GL_COMBINER0_NV, "GL_COMBINER0_NV" );
	#endif
	#ifdef GL_COMBINER1_NV
		swigIntConstant( GL_COMBINER1_NV, "GL_COMBINER1_NV" );
	#endif
	#ifdef GL_COMBINER2_NV
		swigIntConstant( GL_COMBINER2_NV, "GL_COMBINER2_NV" );
	#endif
	#ifdef GL_COMBINER3_NV
		swigIntConstant( GL_COMBINER3_NV, "GL_COMBINER3_NV" );
	#endif
	#ifdef GL_COMBINER4_NV
		swigIntConstant( GL_COMBINER4_NV, "GL_COMBINER4_NV" );
	#endif
	#ifdef GL_COMBINER5_NV
		swigIntConstant( GL_COMBINER5_NV, "GL_COMBINER5_NV" );
	#endif
	#ifdef GL_COMBINER6_NV
		swigIntConstant( GL_COMBINER6_NV, "GL_COMBINER6_NV" );
	#endif
	#ifdef GL_COMBINER7_NV
		swigIntConstant( GL_COMBINER7_NV, "GL_COMBINER7_NV" );
	#endif
	#ifdef GL_NV_register_combiners2
		swigIntConstant( GL_NV_register_combiners2, "GL_NV_register_combiners2" );
	#endif
	#ifdef GL_PER_STAGE_CONSTANTS_NV
		swigIntConstant( GL_PER_STAGE_CONSTANTS_NV, "GL_PER_STAGE_CONSTANTS_NV" );
	#endif
	#ifdef GL_NV_representative_fragment_test
		swigIntConstant( GL_NV_representative_fragment_test, "GL_NV_representative_fragment_test" );
	#endif
	#ifdef GL_REPRESENTATIVE_FRAGMENT_TEST_NV
		swigIntConstant( GL_REPRESENTATIVE_FRAGMENT_TEST_NV, "GL_REPRESENTATIVE_FRAGMENT_TEST_NV" );
	#endif
	#ifdef GL_NV_robustness_video_memory_purge
		swigIntConstant( GL_NV_robustness_video_memory_purge, "GL_NV_robustness_video_memory_purge" );
	#endif
	#ifdef GL_PURGED_CONTEXT_RESET_NV
		swigIntConstant( GL_PURGED_CONTEXT_RESET_NV, "GL_PURGED_CONTEXT_RESET_NV" );
	#endif
	#ifdef GL_NV_sample_locations
		swigIntConstant( GL_NV_sample_locations, "GL_NV_sample_locations" );
	#endif
	#ifdef GL_SAMPLE_LOCATION_SUBPIXEL_BITS_NV
		swigIntConstant( GL_SAMPLE_LOCATION_SUBPIXEL_BITS_NV, "GL_SAMPLE_LOCATION_SUBPIXEL_BITS_NV" );
	#endif
	#ifdef GL_SAMPLE_LOCATION_PIXEL_GRID_WIDTH_NV
		swigIntConstant( GL_SAMPLE_LOCATION_PIXEL_GRID_WIDTH_NV, "GL_SAMPLE_LOCATION_PIXEL_GRID_WIDTH_NV" );
	#endif
	#ifdef GL_SAMPLE_LOCATION_PIXEL_GRID_HEIGHT_NV
		swigIntConstant( GL_SAMPLE_LOCATION_PIXEL_GRID_HEIGHT_NV, "GL_SAMPLE_LOCATION_PIXEL_GRID_HEIGHT_NV" );
	#endif
	#ifdef GL_PROGRAMMABLE_SAMPLE_LOCATION_TABLE_SIZE_NV
		swigIntConstant( GL_PROGRAMMABLE_SAMPLE_LOCATION_TABLE_SIZE_NV, "GL_PROGRAMMABLE_SAMPLE_LOCATION_TABLE_SIZE_NV" );
	#endif
	#ifdef GL_SAMPLE_LOCATION_NV
		swigIntConstant( GL_SAMPLE_LOCATION_NV, "GL_SAMPLE_LOCATION_NV" );
	#endif
	#ifdef GL_PROGRAMMABLE_SAMPLE_LOCATION_NV
		swigIntConstant( GL_PROGRAMMABLE_SAMPLE_LOCATION_NV, "GL_PROGRAMMABLE_SAMPLE_LOCATION_NV" );
	#endif
	#ifdef GL_FRAMEBUFFER_PROGRAMMABLE_SAMPLE_LOCATIONS_NV
		swigIntConstant( GL_FRAMEBUFFER_PROGRAMMABLE_SAMPLE_LOCATIONS_NV, "GL_FRAMEBUFFER_PROGRAMMABLE_SAMPLE_LOCATIONS_NV" );
	#endif
	#ifdef GL_FRAMEBUFFER_SAMPLE_LOCATION_PIXEL_GRID_NV
		swigIntConstant( GL_FRAMEBUFFER_SAMPLE_LOCATION_PIXEL_GRID_NV, "GL_FRAMEBUFFER_SAMPLE_LOCATION_PIXEL_GRID_NV" );
	#endif
	#ifdef GL_NV_sample_mask_override_coverage
		swigIntConstant( GL_NV_sample_mask_override_coverage, "GL_NV_sample_mask_override_coverage" );
	#endif
	#ifdef GL_NV_scissor_exclusive
		swigIntConstant( GL_NV_scissor_exclusive, "GL_NV_scissor_exclusive" );
	#endif
	#ifdef GL_SCISSOR_TEST_EXCLUSIVE_NV
		swigIntConstant( GL_SCISSOR_TEST_EXCLUSIVE_NV, "GL_SCISSOR_TEST_EXCLUSIVE_NV" );
	#endif
	#ifdef GL_SCISSOR_BOX_EXCLUSIVE_NV
		swigIntConstant( GL_SCISSOR_BOX_EXCLUSIVE_NV, "GL_SCISSOR_BOX_EXCLUSIVE_NV" );
	#endif
	#ifdef GL_NV_shader_atomic_counters
		swigIntConstant( GL_NV_shader_atomic_counters, "GL_NV_shader_atomic_counters" );
	#endif
	#ifdef GL_NV_shader_atomic_float
		swigIntConstant( GL_NV_shader_atomic_float, "GL_NV_shader_atomic_float" );
	#endif
	#ifdef GL_NV_shader_atomic_float64
		swigIntConstant( GL_NV_shader_atomic_float64, "GL_NV_shader_atomic_float64" );
	#endif
	#ifdef GL_NV_shader_atomic_fp16_vector
		swigIntConstant( GL_NV_shader_atomic_fp16_vector, "GL_NV_shader_atomic_fp16_vector" );
	#endif
	#ifdef GL_NV_shader_atomic_int64
		swigIntConstant( GL_NV_shader_atomic_int64, "GL_NV_shader_atomic_int64" );
	#endif
	#ifdef GL_NV_shader_buffer_load
		swigIntConstant( GL_NV_shader_buffer_load, "GL_NV_shader_buffer_load" );
	#endif
	#ifdef GL_BUFFER_GPU_ADDRESS_NV
		swigIntConstant( GL_BUFFER_GPU_ADDRESS_NV, "GL_BUFFER_GPU_ADDRESS_NV" );
	#endif
	#ifdef GL_GPU_ADDRESS_NV
		swigIntConstant( GL_GPU_ADDRESS_NV, "GL_GPU_ADDRESS_NV" );
	#endif
	#ifdef GL_MAX_SHADER_BUFFER_ADDRESS_NV
		swigIntConstant( GL_MAX_SHADER_BUFFER_ADDRESS_NV, "GL_MAX_SHADER_BUFFER_ADDRESS_NV" );
	#endif
	#ifdef GL_NV_shader_buffer_store
		swigIntConstant( GL_NV_shader_buffer_store, "GL_NV_shader_buffer_store" );
	#endif
	#ifdef GL_SHADER_GLOBAL_ACCESS_BARRIER_BIT_NV
		swigIntConstant( GL_SHADER_GLOBAL_ACCESS_BARRIER_BIT_NV, "GL_SHADER_GLOBAL_ACCESS_BARRIER_BIT_NV" );
	#endif
	#ifdef GL_NV_shader_storage_buffer_object
		swigIntConstant( GL_NV_shader_storage_buffer_object, "GL_NV_shader_storage_buffer_object" );
	#endif
	#ifdef GL_NV_shader_subgroup_partitioned
		swigIntConstant( GL_NV_shader_subgroup_partitioned, "GL_NV_shader_subgroup_partitioned" );
	#endif
	#ifdef GL_SUBGROUP_FEATURE_PARTITIONED_BIT_NV
		swigIntConstant( GL_SUBGROUP_FEATURE_PARTITIONED_BIT_NV, "GL_SUBGROUP_FEATURE_PARTITIONED_BIT_NV" );
	#endif
	#ifdef GL_NV_shader_texture_footprint
		swigIntConstant( GL_NV_shader_texture_footprint, "GL_NV_shader_texture_footprint" );
	#endif
	#ifdef GL_NV_shader_thread_group
		swigIntConstant( GL_NV_shader_thread_group, "GL_NV_shader_thread_group" );
	#endif
	#ifdef GL_WARP_SIZE_NV
		swigIntConstant( GL_WARP_SIZE_NV, "GL_WARP_SIZE_NV" );
	#endif
	#ifdef GL_WARPS_PER_SM_NV
		swigIntConstant( GL_WARPS_PER_SM_NV, "GL_WARPS_PER_SM_NV" );
	#endif
	#ifdef GL_SM_COUNT_NV
		swigIntConstant( GL_SM_COUNT_NV, "GL_SM_COUNT_NV" );
	#endif
	#ifdef GL_NV_shader_thread_shuffle
		swigIntConstant( GL_NV_shader_thread_shuffle, "GL_NV_shader_thread_shuffle" );
	#endif
	#ifdef GL_NV_shading_rate_image
		swigIntConstant( GL_NV_shading_rate_image, "GL_NV_shading_rate_image" );
	#endif
	#ifdef GL_SHADING_RATE_IMAGE_NV
		swigIntConstant( GL_SHADING_RATE_IMAGE_NV, "GL_SHADING_RATE_IMAGE_NV" );
	#endif
	#ifdef GL_SHADING_RATE_NO_INVOCATIONS_NV
		swigIntConstant( GL_SHADING_RATE_NO_INVOCATIONS_NV, "GL_SHADING_RATE_NO_INVOCATIONS_NV" );
	#endif
	#ifdef GL_SHADING_RATE_1_INVOCATION_PER_PIXEL_NV
		swigIntConstant( GL_SHADING_RATE_1_INVOCATION_PER_PIXEL_NV, "GL_SHADING_RATE_1_INVOCATION_PER_PIXEL_NV" );
	#endif
	#ifdef GL_SHADING_RATE_1_INVOCATION_PER_1X2_PIXELS_NV
		swigIntConstant( GL_SHADING_RATE_1_INVOCATION_PER_1X2_PIXELS_NV, "GL_SHADING_RATE_1_INVOCATION_PER_1X2_PIXELS_NV" );
	#endif
	#ifdef GL_SHADING_RATE_1_INVOCATION_PER_2X1_PIXELS_NV
		swigIntConstant( GL_SHADING_RATE_1_INVOCATION_PER_2X1_PIXELS_NV, "GL_SHADING_RATE_1_INVOCATION_PER_2X1_PIXELS_NV" );
	#endif
	#ifdef GL_SHADING_RATE_1_INVOCATION_PER_2X2_PIXELS_NV
		swigIntConstant( GL_SHADING_RATE_1_INVOCATION_PER_2X2_PIXELS_NV, "GL_SHADING_RATE_1_INVOCATION_PER_2X2_PIXELS_NV" );
	#endif
	#ifdef GL_SHADING_RATE_1_INVOCATION_PER_2X4_PIXELS_NV
		swigIntConstant( GL_SHADING_RATE_1_INVOCATION_PER_2X4_PIXELS_NV, "GL_SHADING_RATE_1_INVOCATION_PER_2X4_PIXELS_NV" );
	#endif
	#ifdef GL_SHADING_RATE_1_INVOCATION_PER_4X2_PIXELS_NV
		swigIntConstant( GL_SHADING_RATE_1_INVOCATION_PER_4X2_PIXELS_NV, "GL_SHADING_RATE_1_INVOCATION_PER_4X2_PIXELS_NV" );
	#endif
	#ifdef GL_SHADING_RATE_1_INVOCATION_PER_4X4_PIXELS_NV
		swigIntConstant( GL_SHADING_RATE_1_INVOCATION_PER_4X4_PIXELS_NV, "GL_SHADING_RATE_1_INVOCATION_PER_4X4_PIXELS_NV" );
	#endif
	#ifdef GL_SHADING_RATE_2_INVOCATIONS_PER_PIXEL_NV
		swigIntConstant( GL_SHADING_RATE_2_INVOCATIONS_PER_PIXEL_NV, "GL_SHADING_RATE_2_INVOCATIONS_PER_PIXEL_NV" );
	#endif
	#ifdef GL_SHADING_RATE_4_INVOCATIONS_PER_PIXEL_NV
		swigIntConstant( GL_SHADING_RATE_4_INVOCATIONS_PER_PIXEL_NV, "GL_SHADING_RATE_4_INVOCATIONS_PER_PIXEL_NV" );
	#endif
	#ifdef GL_SHADING_RATE_8_INVOCATIONS_PER_PIXEL_NV
		swigIntConstant( GL_SHADING_RATE_8_INVOCATIONS_PER_PIXEL_NV, "GL_SHADING_RATE_8_INVOCATIONS_PER_PIXEL_NV" );
	#endif
	#ifdef GL_SHADING_RATE_16_INVOCATIONS_PER_PIXEL_NV
		swigIntConstant( GL_SHADING_RATE_16_INVOCATIONS_PER_PIXEL_NV, "GL_SHADING_RATE_16_INVOCATIONS_PER_PIXEL_NV" );
	#endif
	#ifdef GL_SHADING_RATE_IMAGE_BINDING_NV
		swigIntConstant( GL_SHADING_RATE_IMAGE_BINDING_NV, "GL_SHADING_RATE_IMAGE_BINDING_NV" );
	#endif
	#ifdef GL_SHADING_RATE_IMAGE_TEXEL_WIDTH_NV
		swigIntConstant( GL_SHADING_RATE_IMAGE_TEXEL_WIDTH_NV, "GL_SHADING_RATE_IMAGE_TEXEL_WIDTH_NV" );
	#endif
	#ifdef GL_SHADING_RATE_IMAGE_TEXEL_HEIGHT_NV
		swigIntConstant( GL_SHADING_RATE_IMAGE_TEXEL_HEIGHT_NV, "GL_SHADING_RATE_IMAGE_TEXEL_HEIGHT_NV" );
	#endif
	#ifdef GL_SHADING_RATE_IMAGE_PALETTE_SIZE_NV
		swigIntConstant( GL_SHADING_RATE_IMAGE_PALETTE_SIZE_NV, "GL_SHADING_RATE_IMAGE_PALETTE_SIZE_NV" );
	#endif
	#ifdef GL_MAX_COARSE_FRAGMENT_SAMPLES_NV
		swigIntConstant( GL_MAX_COARSE_FRAGMENT_SAMPLES_NV, "GL_MAX_COARSE_FRAGMENT_SAMPLES_NV" );
	#endif
	#ifdef GL_SHADING_RATE_SAMPLE_ORDER_DEFAULT_NV
		swigIntConstant( GL_SHADING_RATE_SAMPLE_ORDER_DEFAULT_NV, "GL_SHADING_RATE_SAMPLE_ORDER_DEFAULT_NV" );
	#endif
	#ifdef GL_SHADING_RATE_SAMPLE_ORDER_PIXEL_MAJOR_NV
		swigIntConstant( GL_SHADING_RATE_SAMPLE_ORDER_PIXEL_MAJOR_NV, "GL_SHADING_RATE_SAMPLE_ORDER_PIXEL_MAJOR_NV" );
	#endif
	#ifdef GL_SHADING_RATE_SAMPLE_ORDER_SAMPLE_MAJOR_NV
		swigIntConstant( GL_SHADING_RATE_SAMPLE_ORDER_SAMPLE_MAJOR_NV, "GL_SHADING_RATE_SAMPLE_ORDER_SAMPLE_MAJOR_NV" );
	#endif
	#ifdef GL_NV_stereo_view_rendering
		swigIntConstant( GL_NV_stereo_view_rendering, "GL_NV_stereo_view_rendering" );
	#endif
	#ifdef GL_NV_tessellation_program5
		swigIntConstant( GL_NV_tessellation_program5, "GL_NV_tessellation_program5" );
	#endif
	#ifdef GL_MAX_PROGRAM_PATCH_ATTRIBS_NV
		swigIntConstant( GL_MAX_PROGRAM_PATCH_ATTRIBS_NV, "GL_MAX_PROGRAM_PATCH_ATTRIBS_NV" );
	#endif
	#ifdef GL_TESS_CONTROL_PROGRAM_NV
		swigIntConstant( GL_TESS_CONTROL_PROGRAM_NV, "GL_TESS_CONTROL_PROGRAM_NV" );
	#endif
	#ifdef GL_TESS_EVALUATION_PROGRAM_NV
		swigIntConstant( GL_TESS_EVALUATION_PROGRAM_NV, "GL_TESS_EVALUATION_PROGRAM_NV" );
	#endif
	#ifdef GL_TESS_CONTROL_PROGRAM_PARAMETER_BUFFER_NV
		swigIntConstant( GL_TESS_CONTROL_PROGRAM_PARAMETER_BUFFER_NV, "GL_TESS_CONTROL_PROGRAM_PARAMETER_BUFFER_NV" );
	#endif
	#ifdef GL_TESS_EVALUATION_PROGRAM_PARAMETER_BUFFER_NV
		swigIntConstant( GL_TESS_EVALUATION_PROGRAM_PARAMETER_BUFFER_NV, "GL_TESS_EVALUATION_PROGRAM_PARAMETER_BUFFER_NV" );
	#endif
	#ifdef GL_NV_texgen_emboss
		swigIntConstant( GL_NV_texgen_emboss, "GL_NV_texgen_emboss" );
	#endif
	#ifdef GL_EMBOSS_LIGHT_NV
		swigIntConstant( GL_EMBOSS_LIGHT_NV, "GL_EMBOSS_LIGHT_NV" );
	#endif
	#ifdef GL_EMBOSS_CONSTANT_NV
		swigIntConstant( GL_EMBOSS_CONSTANT_NV, "GL_EMBOSS_CONSTANT_NV" );
	#endif
	#ifdef GL_EMBOSS_MAP_NV
		swigIntConstant( GL_EMBOSS_MAP_NV, "GL_EMBOSS_MAP_NV" );
	#endif
	#ifdef GL_NV_texgen_reflection
		swigIntConstant( GL_NV_texgen_reflection, "GL_NV_texgen_reflection" );
	#endif
	#ifdef GL_NORMAL_MAP_NV
		swigIntConstant( GL_NORMAL_MAP_NV, "GL_NORMAL_MAP_NV" );
	#endif
	#ifdef GL_REFLECTION_MAP_NV
		swigIntConstant( GL_REFLECTION_MAP_NV, "GL_REFLECTION_MAP_NV" );
	#endif
	#ifdef GL_NV_texture_barrier
		swigIntConstant( GL_NV_texture_barrier, "GL_NV_texture_barrier" );
	#endif
	#ifdef GL_NV_texture_compression_vtc
		swigIntConstant( GL_NV_texture_compression_vtc, "GL_NV_texture_compression_vtc" );
	#endif
	#ifdef GL_NV_texture_env_combine4
		swigIntConstant( GL_NV_texture_env_combine4, "GL_NV_texture_env_combine4" );
	#endif
	#ifdef GL_COMBINE4_NV
		swigIntConstant( GL_COMBINE4_NV, "GL_COMBINE4_NV" );
	#endif
	#ifdef GL_SOURCE3_RGB_NV
		swigIntConstant( GL_SOURCE3_RGB_NV, "GL_SOURCE3_RGB_NV" );
	#endif
	#ifdef GL_SOURCE3_ALPHA_NV
		swigIntConstant( GL_SOURCE3_ALPHA_NV, "GL_SOURCE3_ALPHA_NV" );
	#endif
	#ifdef GL_OPERAND3_RGB_NV
		swigIntConstant( GL_OPERAND3_RGB_NV, "GL_OPERAND3_RGB_NV" );
	#endif
	#ifdef GL_OPERAND3_ALPHA_NV
		swigIntConstant( GL_OPERAND3_ALPHA_NV, "GL_OPERAND3_ALPHA_NV" );
	#endif
	#ifdef GL_NV_texture_expand_normal
		swigIntConstant( GL_NV_texture_expand_normal, "GL_NV_texture_expand_normal" );
	#endif
	#ifdef GL_TEXTURE_UNSIGNED_REMAP_MODE_NV
		swigIntConstant( GL_TEXTURE_UNSIGNED_REMAP_MODE_NV, "GL_TEXTURE_UNSIGNED_REMAP_MODE_NV" );
	#endif
	#ifdef GL_NV_texture_multisample
		swigIntConstant( GL_NV_texture_multisample, "GL_NV_texture_multisample" );
	#endif
	#ifdef GL_TEXTURE_COVERAGE_SAMPLES_NV
		swigIntConstant( GL_TEXTURE_COVERAGE_SAMPLES_NV, "GL_TEXTURE_COVERAGE_SAMPLES_NV" );
	#endif
	#ifdef GL_TEXTURE_COLOR_SAMPLES_NV
		swigIntConstant( GL_TEXTURE_COLOR_SAMPLES_NV, "GL_TEXTURE_COLOR_SAMPLES_NV" );
	#endif
	#ifdef GL_NV_texture_rectangle
		swigIntConstant( GL_NV_texture_rectangle, "GL_NV_texture_rectangle" );
	#endif
	#ifdef GL_TEXTURE_RECTANGLE_NV
		swigIntConstant( GL_TEXTURE_RECTANGLE_NV, "GL_TEXTURE_RECTANGLE_NV" );
	#endif
	#ifdef GL_TEXTURE_BINDING_RECTANGLE_NV
		swigIntConstant( GL_TEXTURE_BINDING_RECTANGLE_NV, "GL_TEXTURE_BINDING_RECTANGLE_NV" );
	#endif
	#ifdef GL_PROXY_TEXTURE_RECTANGLE_NV
		swigIntConstant( GL_PROXY_TEXTURE_RECTANGLE_NV, "GL_PROXY_TEXTURE_RECTANGLE_NV" );
	#endif
	#ifdef GL_MAX_RECTANGLE_TEXTURE_SIZE_NV
		swigIntConstant( GL_MAX_RECTANGLE_TEXTURE_SIZE_NV, "GL_MAX_RECTANGLE_TEXTURE_SIZE_NV" );
	#endif
	#ifdef GL_NV_texture_rectangle_compressed
		swigIntConstant( GL_NV_texture_rectangle_compressed, "GL_NV_texture_rectangle_compressed" );
	#endif
	#ifdef GL_NV_texture_shader
		swigIntConstant( GL_NV_texture_shader, "GL_NV_texture_shader" );
	#endif
	#ifdef GL_OFFSET_TEXTURE_RECTANGLE_NV
		swigIntConstant( GL_OFFSET_TEXTURE_RECTANGLE_NV, "GL_OFFSET_TEXTURE_RECTANGLE_NV" );
	#endif
	#ifdef GL_OFFSET_TEXTURE_RECTANGLE_SCALE_NV
		swigIntConstant( GL_OFFSET_TEXTURE_RECTANGLE_SCALE_NV, "GL_OFFSET_TEXTURE_RECTANGLE_SCALE_NV" );
	#endif
	#ifdef GL_DOT_PRODUCT_TEXTURE_RECTANGLE_NV
		swigIntConstant( GL_DOT_PRODUCT_TEXTURE_RECTANGLE_NV, "GL_DOT_PRODUCT_TEXTURE_RECTANGLE_NV" );
	#endif
	#ifdef GL_RGBA_UNSIGNED_DOT_PRODUCT_MAPPING_NV
		swigIntConstant( GL_RGBA_UNSIGNED_DOT_PRODUCT_MAPPING_NV, "GL_RGBA_UNSIGNED_DOT_PRODUCT_MAPPING_NV" );
	#endif
	#ifdef GL_UNSIGNED_INT_S8_S8_8_8_NV
		swigIntConstant( GL_UNSIGNED_INT_S8_S8_8_8_NV, "GL_UNSIGNED_INT_S8_S8_8_8_NV" );
	#endif
	#ifdef GL_UNSIGNED_INT_8_8_S8_S8_REV_NV
		swigIntConstant( GL_UNSIGNED_INT_8_8_S8_S8_REV_NV, "GL_UNSIGNED_INT_8_8_S8_S8_REV_NV" );
	#endif
	#ifdef GL_DSDT_MAG_INTENSITY_NV
		swigIntConstant( GL_DSDT_MAG_INTENSITY_NV, "GL_DSDT_MAG_INTENSITY_NV" );
	#endif
	#ifdef GL_SHADER_CONSISTENT_NV
		swigIntConstant( GL_SHADER_CONSISTENT_NV, "GL_SHADER_CONSISTENT_NV" );
	#endif
	#ifdef GL_TEXTURE_SHADER_NV
		swigIntConstant( GL_TEXTURE_SHADER_NV, "GL_TEXTURE_SHADER_NV" );
	#endif
	#ifdef GL_SHADER_OPERATION_NV
		swigIntConstant( GL_SHADER_OPERATION_NV, "GL_SHADER_OPERATION_NV" );
	#endif
	#ifdef GL_CULL_MODES_NV
		swigIntConstant( GL_CULL_MODES_NV, "GL_CULL_MODES_NV" );
	#endif
	#ifdef GL_OFFSET_TEXTURE_MATRIX_NV
		swigIntConstant( GL_OFFSET_TEXTURE_MATRIX_NV, "GL_OFFSET_TEXTURE_MATRIX_NV" );
	#endif
	#ifdef GL_OFFSET_TEXTURE_SCALE_NV
		swigIntConstant( GL_OFFSET_TEXTURE_SCALE_NV, "GL_OFFSET_TEXTURE_SCALE_NV" );
	#endif
	#ifdef GL_OFFSET_TEXTURE_BIAS_NV
		swigIntConstant( GL_OFFSET_TEXTURE_BIAS_NV, "GL_OFFSET_TEXTURE_BIAS_NV" );
	#endif
	#ifdef GL_OFFSET_TEXTURE_2D_MATRIX_NV
		swigIntConstant( GL_OFFSET_TEXTURE_2D_MATRIX_NV, "GL_OFFSET_TEXTURE_2D_MATRIX_NV" );
	#endif
	#ifdef GL_OFFSET_TEXTURE_2D_SCALE_NV
		swigIntConstant( GL_OFFSET_TEXTURE_2D_SCALE_NV, "GL_OFFSET_TEXTURE_2D_SCALE_NV" );
	#endif
	#ifdef GL_OFFSET_TEXTURE_2D_BIAS_NV
		swigIntConstant( GL_OFFSET_TEXTURE_2D_BIAS_NV, "GL_OFFSET_TEXTURE_2D_BIAS_NV" );
	#endif
	#ifdef GL_PREVIOUS_TEXTURE_INPUT_NV
		swigIntConstant( GL_PREVIOUS_TEXTURE_INPUT_NV, "GL_PREVIOUS_TEXTURE_INPUT_NV" );
	#endif
	#ifdef GL_CONST_EYE_NV
		swigIntConstant( GL_CONST_EYE_NV, "GL_CONST_EYE_NV" );
	#endif
	#ifdef GL_PASS_THROUGH_NV
		swigIntConstant( GL_PASS_THROUGH_NV, "GL_PASS_THROUGH_NV" );
	#endif
	#ifdef GL_CULL_FRAGMENT_NV
		swigIntConstant( GL_CULL_FRAGMENT_NV, "GL_CULL_FRAGMENT_NV" );
	#endif
	#ifdef GL_OFFSET_TEXTURE_2D_NV
		swigIntConstant( GL_OFFSET_TEXTURE_2D_NV, "GL_OFFSET_TEXTURE_2D_NV" );
	#endif
	#ifdef GL_DEPENDENT_AR_TEXTURE_2D_NV
		swigIntConstant( GL_DEPENDENT_AR_TEXTURE_2D_NV, "GL_DEPENDENT_AR_TEXTURE_2D_NV" );
	#endif
	#ifdef GL_DEPENDENT_GB_TEXTURE_2D_NV
		swigIntConstant( GL_DEPENDENT_GB_TEXTURE_2D_NV, "GL_DEPENDENT_GB_TEXTURE_2D_NV" );
	#endif
	#ifdef GL_DOT_PRODUCT_NV
		swigIntConstant( GL_DOT_PRODUCT_NV, "GL_DOT_PRODUCT_NV" );
	#endif
	#ifdef GL_DOT_PRODUCT_DEPTH_REPLACE_NV
		swigIntConstant( GL_DOT_PRODUCT_DEPTH_REPLACE_NV, "GL_DOT_PRODUCT_DEPTH_REPLACE_NV" );
	#endif
	#ifdef GL_DOT_PRODUCT_TEXTURE_2D_NV
		swigIntConstant( GL_DOT_PRODUCT_TEXTURE_2D_NV, "GL_DOT_PRODUCT_TEXTURE_2D_NV" );
	#endif
	#ifdef GL_DOT_PRODUCT_TEXTURE_CUBE_MAP_NV
		swigIntConstant( GL_DOT_PRODUCT_TEXTURE_CUBE_MAP_NV, "GL_DOT_PRODUCT_TEXTURE_CUBE_MAP_NV" );
	#endif
	#ifdef GL_DOT_PRODUCT_DIFFUSE_CUBE_MAP_NV
		swigIntConstant( GL_DOT_PRODUCT_DIFFUSE_CUBE_MAP_NV, "GL_DOT_PRODUCT_DIFFUSE_CUBE_MAP_NV" );
	#endif
	#ifdef GL_DOT_PRODUCT_REFLECT_CUBE_MAP_NV
		swigIntConstant( GL_DOT_PRODUCT_REFLECT_CUBE_MAP_NV, "GL_DOT_PRODUCT_REFLECT_CUBE_MAP_NV" );
	#endif
	#ifdef GL_DOT_PRODUCT_CONST_EYE_REFLECT_CUBE_MAP_NV
		swigIntConstant( GL_DOT_PRODUCT_CONST_EYE_REFLECT_CUBE_MAP_NV, "GL_DOT_PRODUCT_CONST_EYE_REFLECT_CUBE_MAP_NV" );
	#endif
	#ifdef GL_HILO_NV
		swigIntConstant( GL_HILO_NV, "GL_HILO_NV" );
	#endif
	#ifdef GL_DSDT_NV
		swigIntConstant( GL_DSDT_NV, "GL_DSDT_NV" );
	#endif
	#ifdef GL_DSDT_MAG_NV
		swigIntConstant( GL_DSDT_MAG_NV, "GL_DSDT_MAG_NV" );
	#endif
	#ifdef GL_DSDT_MAG_VIB_NV
		swigIntConstant( GL_DSDT_MAG_VIB_NV, "GL_DSDT_MAG_VIB_NV" );
	#endif
	#ifdef GL_HILO16_NV
		swigIntConstant( GL_HILO16_NV, "GL_HILO16_NV" );
	#endif
	#ifdef GL_SIGNED_HILO_NV
		swigIntConstant( GL_SIGNED_HILO_NV, "GL_SIGNED_HILO_NV" );
	#endif
	#ifdef GL_SIGNED_HILO16_NV
		swigIntConstant( GL_SIGNED_HILO16_NV, "GL_SIGNED_HILO16_NV" );
	#endif
	#ifdef GL_SIGNED_RGBA_NV
		swigIntConstant( GL_SIGNED_RGBA_NV, "GL_SIGNED_RGBA_NV" );
	#endif
	#ifdef GL_SIGNED_RGBA8_NV
		swigIntConstant( GL_SIGNED_RGBA8_NV, "GL_SIGNED_RGBA8_NV" );
	#endif
	#ifdef GL_SIGNED_RGB_NV
		swigIntConstant( GL_SIGNED_RGB_NV, "GL_SIGNED_RGB_NV" );
	#endif
	#ifdef GL_SIGNED_RGB8_NV
		swigIntConstant( GL_SIGNED_RGB8_NV, "GL_SIGNED_RGB8_NV" );
	#endif
	#ifdef GL_SIGNED_LUMINANCE_NV
		swigIntConstant( GL_SIGNED_LUMINANCE_NV, "GL_SIGNED_LUMINANCE_NV" );
	#endif
	#ifdef GL_SIGNED_LUMINANCE8_NV
		swigIntConstant( GL_SIGNED_LUMINANCE8_NV, "GL_SIGNED_LUMINANCE8_NV" );
	#endif
	#ifdef GL_SIGNED_LUMINANCE_ALPHA_NV
		swigIntConstant( GL_SIGNED_LUMINANCE_ALPHA_NV, "GL_SIGNED_LUMINANCE_ALPHA_NV" );
	#endif
	#ifdef GL_SIGNED_LUMINANCE8_ALPHA8_NV
		swigIntConstant( GL_SIGNED_LUMINANCE8_ALPHA8_NV, "GL_SIGNED_LUMINANCE8_ALPHA8_NV" );
	#endif
	#ifdef GL_SIGNED_ALPHA_NV
		swigIntConstant( GL_SIGNED_ALPHA_NV, "GL_SIGNED_ALPHA_NV" );
	#endif
	#ifdef GL_SIGNED_ALPHA8_NV
		swigIntConstant( GL_SIGNED_ALPHA8_NV, "GL_SIGNED_ALPHA8_NV" );
	#endif
	#ifdef GL_SIGNED_INTENSITY_NV
		swigIntConstant( GL_SIGNED_INTENSITY_NV, "GL_SIGNED_INTENSITY_NV" );
	#endif
	#ifdef GL_SIGNED_INTENSITY8_NV
		swigIntConstant( GL_SIGNED_INTENSITY8_NV, "GL_SIGNED_INTENSITY8_NV" );
	#endif
	#ifdef GL_DSDT8_NV
		swigIntConstant( GL_DSDT8_NV, "GL_DSDT8_NV" );
	#endif
	#ifdef GL_DSDT8_MAG8_NV
		swigIntConstant( GL_DSDT8_MAG8_NV, "GL_DSDT8_MAG8_NV" );
	#endif
	#ifdef GL_DSDT8_MAG8_INTENSITY8_NV
		swigIntConstant( GL_DSDT8_MAG8_INTENSITY8_NV, "GL_DSDT8_MAG8_INTENSITY8_NV" );
	#endif
	#ifdef GL_SIGNED_RGB_UNSIGNED_ALPHA_NV
		swigIntConstant( GL_SIGNED_RGB_UNSIGNED_ALPHA_NV, "GL_SIGNED_RGB_UNSIGNED_ALPHA_NV" );
	#endif
	#ifdef GL_SIGNED_RGB8_UNSIGNED_ALPHA8_NV
		swigIntConstant( GL_SIGNED_RGB8_UNSIGNED_ALPHA8_NV, "GL_SIGNED_RGB8_UNSIGNED_ALPHA8_NV" );
	#endif
	#ifdef GL_HI_SCALE_NV
		swigIntConstant( GL_HI_SCALE_NV, "GL_HI_SCALE_NV" );
	#endif
	#ifdef GL_LO_SCALE_NV
		swigIntConstant( GL_LO_SCALE_NV, "GL_LO_SCALE_NV" );
	#endif
	#ifdef GL_DS_SCALE_NV
		swigIntConstant( GL_DS_SCALE_NV, "GL_DS_SCALE_NV" );
	#endif
	#ifdef GL_DT_SCALE_NV
		swigIntConstant( GL_DT_SCALE_NV, "GL_DT_SCALE_NV" );
	#endif
	#ifdef GL_MAGNITUDE_SCALE_NV
		swigIntConstant( GL_MAGNITUDE_SCALE_NV, "GL_MAGNITUDE_SCALE_NV" );
	#endif
	#ifdef GL_VIBRANCE_SCALE_NV
		swigIntConstant( GL_VIBRANCE_SCALE_NV, "GL_VIBRANCE_SCALE_NV" );
	#endif
	#ifdef GL_HI_BIAS_NV
		swigIntConstant( GL_HI_BIAS_NV, "GL_HI_BIAS_NV" );
	#endif
	#ifdef GL_LO_BIAS_NV
		swigIntConstant( GL_LO_BIAS_NV, "GL_LO_BIAS_NV" );
	#endif
	#ifdef GL_DS_BIAS_NV
		swigIntConstant( GL_DS_BIAS_NV, "GL_DS_BIAS_NV" );
	#endif
	#ifdef GL_DT_BIAS_NV
		swigIntConstant( GL_DT_BIAS_NV, "GL_DT_BIAS_NV" );
	#endif
	#ifdef GL_MAGNITUDE_BIAS_NV
		swigIntConstant( GL_MAGNITUDE_BIAS_NV, "GL_MAGNITUDE_BIAS_NV" );
	#endif
	#ifdef GL_VIBRANCE_BIAS_NV
		swigIntConstant( GL_VIBRANCE_BIAS_NV, "GL_VIBRANCE_BIAS_NV" );
	#endif
	#ifdef GL_TEXTURE_BORDER_VALUES_NV
		swigIntConstant( GL_TEXTURE_BORDER_VALUES_NV, "GL_TEXTURE_BORDER_VALUES_NV" );
	#endif
	#ifdef GL_TEXTURE_HI_SIZE_NV
		swigIntConstant( GL_TEXTURE_HI_SIZE_NV, "GL_TEXTURE_HI_SIZE_NV" );
	#endif
	#ifdef GL_TEXTURE_LO_SIZE_NV
		swigIntConstant( GL_TEXTURE_LO_SIZE_NV, "GL_TEXTURE_LO_SIZE_NV" );
	#endif
	#ifdef GL_TEXTURE_DS_SIZE_NV
		swigIntConstant( GL_TEXTURE_DS_SIZE_NV, "GL_TEXTURE_DS_SIZE_NV" );
	#endif
	#ifdef GL_TEXTURE_DT_SIZE_NV
		swigIntConstant( GL_TEXTURE_DT_SIZE_NV, "GL_TEXTURE_DT_SIZE_NV" );
	#endif
	#ifdef GL_TEXTURE_MAG_SIZE_NV
		swigIntConstant( GL_TEXTURE_MAG_SIZE_NV, "GL_TEXTURE_MAG_SIZE_NV" );
	#endif
	#ifdef GL_NV_texture_shader2
		swigIntConstant( GL_NV_texture_shader2, "GL_NV_texture_shader2" );
	#endif
	#ifdef GL_DOT_PRODUCT_TEXTURE_3D_NV
		swigIntConstant( GL_DOT_PRODUCT_TEXTURE_3D_NV, "GL_DOT_PRODUCT_TEXTURE_3D_NV" );
	#endif
	#ifdef GL_NV_texture_shader3
		swigIntConstant( GL_NV_texture_shader3, "GL_NV_texture_shader3" );
	#endif
	#ifdef GL_OFFSET_PROJECTIVE_TEXTURE_2D_NV
		swigIntConstant( GL_OFFSET_PROJECTIVE_TEXTURE_2D_NV, "GL_OFFSET_PROJECTIVE_TEXTURE_2D_NV" );
	#endif
	#ifdef GL_OFFSET_PROJECTIVE_TEXTURE_2D_SCALE_NV
		swigIntConstant( GL_OFFSET_PROJECTIVE_TEXTURE_2D_SCALE_NV, "GL_OFFSET_PROJECTIVE_TEXTURE_2D_SCALE_NV" );
	#endif
	#ifdef GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_NV
		swigIntConstant( GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_NV, "GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_NV" );
	#endif
	#ifdef GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_SCALE_NV
		swigIntConstant( GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_SCALE_NV, "GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_SCALE_NV" );
	#endif
	#ifdef GL_OFFSET_HILO_TEXTURE_2D_NV
		swigIntConstant( GL_OFFSET_HILO_TEXTURE_2D_NV, "GL_OFFSET_HILO_TEXTURE_2D_NV" );
	#endif
	#ifdef GL_OFFSET_HILO_TEXTURE_RECTANGLE_NV
		swigIntConstant( GL_OFFSET_HILO_TEXTURE_RECTANGLE_NV, "GL_OFFSET_HILO_TEXTURE_RECTANGLE_NV" );
	#endif
	#ifdef GL_OFFSET_HILO_PROJECTIVE_TEXTURE_2D_NV
		swigIntConstant( GL_OFFSET_HILO_PROJECTIVE_TEXTURE_2D_NV, "GL_OFFSET_HILO_PROJECTIVE_TEXTURE_2D_NV" );
	#endif
	#ifdef GL_OFFSET_HILO_PROJECTIVE_TEXTURE_RECTANGLE_NV
		swigIntConstant( GL_OFFSET_HILO_PROJECTIVE_TEXTURE_RECTANGLE_NV, "GL_OFFSET_HILO_PROJECTIVE_TEXTURE_RECTANGLE_NV" );
	#endif
	#ifdef GL_DEPENDENT_HILO_TEXTURE_2D_NV
		swigIntConstant( GL_DEPENDENT_HILO_TEXTURE_2D_NV, "GL_DEPENDENT_HILO_TEXTURE_2D_NV" );
	#endif
	#ifdef GL_DEPENDENT_RGB_TEXTURE_3D_NV
		swigIntConstant( GL_DEPENDENT_RGB_TEXTURE_3D_NV, "GL_DEPENDENT_RGB_TEXTURE_3D_NV" );
	#endif
	#ifdef GL_DEPENDENT_RGB_TEXTURE_CUBE_MAP_NV
		swigIntConstant( GL_DEPENDENT_RGB_TEXTURE_CUBE_MAP_NV, "GL_DEPENDENT_RGB_TEXTURE_CUBE_MAP_NV" );
	#endif
	#ifdef GL_DOT_PRODUCT_PASS_THROUGH_NV
		swigIntConstant( GL_DOT_PRODUCT_PASS_THROUGH_NV, "GL_DOT_PRODUCT_PASS_THROUGH_NV" );
	#endif
	#ifdef GL_DOT_PRODUCT_TEXTURE_1D_NV
		swigIntConstant( GL_DOT_PRODUCT_TEXTURE_1D_NV, "GL_DOT_PRODUCT_TEXTURE_1D_NV" );
	#endif
	#ifdef GL_DOT_PRODUCT_AFFINE_DEPTH_REPLACE_NV
		swigIntConstant( GL_DOT_PRODUCT_AFFINE_DEPTH_REPLACE_NV, "GL_DOT_PRODUCT_AFFINE_DEPTH_REPLACE_NV" );
	#endif
	#ifdef GL_HILO8_NV
		swigIntConstant( GL_HILO8_NV, "GL_HILO8_NV" );
	#endif
	#ifdef GL_SIGNED_HILO8_NV
		swigIntConstant( GL_SIGNED_HILO8_NV, "GL_SIGNED_HILO8_NV" );
	#endif
	#ifdef GL_FORCE_BLUE_TO_ONE_NV
		swigIntConstant( GL_FORCE_BLUE_TO_ONE_NV, "GL_FORCE_BLUE_TO_ONE_NV" );
	#endif
	#ifdef GL_NV_timeline_semaphore
		swigIntConstant( GL_NV_timeline_semaphore, "GL_NV_timeline_semaphore" );
	#endif
	#ifdef GL_TIMELINE_SEMAPHORE_VALUE_NV
		swigIntConstant( GL_TIMELINE_SEMAPHORE_VALUE_NV, "GL_TIMELINE_SEMAPHORE_VALUE_NV" );
	#endif
	#ifdef GL_SEMAPHORE_TYPE_NV
		swigIntConstant( GL_SEMAPHORE_TYPE_NV, "GL_SEMAPHORE_TYPE_NV" );
	#endif
	#ifdef GL_SEMAPHORE_TYPE_BINARY_NV
		swigIntConstant( GL_SEMAPHORE_TYPE_BINARY_NV, "GL_SEMAPHORE_TYPE_BINARY_NV" );
	#endif
	#ifdef GL_SEMAPHORE_TYPE_TIMELINE_NV
		swigIntConstant( GL_SEMAPHORE_TYPE_TIMELINE_NV, "GL_SEMAPHORE_TYPE_TIMELINE_NV" );
	#endif
	#ifdef GL_MAX_TIMELINE_SEMAPHORE_VALUE_DIFFERENCE_NV
		swigIntConstant( GL_MAX_TIMELINE_SEMAPHORE_VALUE_DIFFERENCE_NV, "GL_MAX_TIMELINE_SEMAPHORE_VALUE_DIFFERENCE_NV" );
	#endif
	#ifdef GL_NV_transform_feedback
		swigIntConstant( GL_NV_transform_feedback, "GL_NV_transform_feedback" );
	#endif
	#ifdef GL_BACK_PRIMARY_COLOR_NV
		swigIntConstant( GL_BACK_PRIMARY_COLOR_NV, "GL_BACK_PRIMARY_COLOR_NV" );
	#endif
	#ifdef GL_BACK_SECONDARY_COLOR_NV
		swigIntConstant( GL_BACK_SECONDARY_COLOR_NV, "GL_BACK_SECONDARY_COLOR_NV" );
	#endif
	#ifdef GL_TEXTURE_COORD_NV
		swigIntConstant( GL_TEXTURE_COORD_NV, "GL_TEXTURE_COORD_NV" );
	#endif
	#ifdef GL_CLIP_DISTANCE_NV
		swigIntConstant( GL_CLIP_DISTANCE_NV, "GL_CLIP_DISTANCE_NV" );
	#endif
	#ifdef GL_VERTEX_ID_NV
		swigIntConstant( GL_VERTEX_ID_NV, "GL_VERTEX_ID_NV" );
	#endif
	#ifdef GL_PRIMITIVE_ID_NV
		swigIntConstant( GL_PRIMITIVE_ID_NV, "GL_PRIMITIVE_ID_NV" );
	#endif
	#ifdef GL_GENERIC_ATTRIB_NV
		swigIntConstant( GL_GENERIC_ATTRIB_NV, "GL_GENERIC_ATTRIB_NV" );
	#endif
	#ifdef GL_TRANSFORM_FEEDBACK_ATTRIBS_NV
		swigIntConstant( GL_TRANSFORM_FEEDBACK_ATTRIBS_NV, "GL_TRANSFORM_FEEDBACK_ATTRIBS_NV" );
	#endif
	#ifdef GL_TRANSFORM_FEEDBACK_BUFFER_MODE_NV
		swigIntConstant( GL_TRANSFORM_FEEDBACK_BUFFER_MODE_NV, "GL_TRANSFORM_FEEDBACK_BUFFER_MODE_NV" );
	#endif
	#ifdef GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS_NV
		swigIntConstant( GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS_NV, "GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS_NV" );
	#endif
	#ifdef GL_ACTIVE_VARYINGS_NV
		swigIntConstant( GL_ACTIVE_VARYINGS_NV, "GL_ACTIVE_VARYINGS_NV" );
	#endif
	#ifdef GL_ACTIVE_VARYING_MAX_LENGTH_NV
		swigIntConstant( GL_ACTIVE_VARYING_MAX_LENGTH_NV, "GL_ACTIVE_VARYING_MAX_LENGTH_NV" );
	#endif
	#ifdef GL_TRANSFORM_FEEDBACK_VARYINGS_NV
		swigIntConstant( GL_TRANSFORM_FEEDBACK_VARYINGS_NV, "GL_TRANSFORM_FEEDBACK_VARYINGS_NV" );
	#endif
	#ifdef GL_TRANSFORM_FEEDBACK_BUFFER_START_NV
		swigIntConstant( GL_TRANSFORM_FEEDBACK_BUFFER_START_NV, "GL_TRANSFORM_FEEDBACK_BUFFER_START_NV" );
	#endif
	#ifdef GL_TRANSFORM_FEEDBACK_BUFFER_SIZE_NV
		swigIntConstant( GL_TRANSFORM_FEEDBACK_BUFFER_SIZE_NV, "GL_TRANSFORM_FEEDBACK_BUFFER_SIZE_NV" );
	#endif
	#ifdef GL_TRANSFORM_FEEDBACK_RECORD_NV
		swigIntConstant( GL_TRANSFORM_FEEDBACK_RECORD_NV, "GL_TRANSFORM_FEEDBACK_RECORD_NV" );
	#endif
	#ifdef GL_PRIMITIVES_GENERATED_NV
		swigIntConstant( GL_PRIMITIVES_GENERATED_NV, "GL_PRIMITIVES_GENERATED_NV" );
	#endif
	#ifdef GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN_NV
		swigIntConstant( GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN_NV, "GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN_NV" );
	#endif
	#ifdef GL_RASTERIZER_DISCARD_NV
		swigIntConstant( GL_RASTERIZER_DISCARD_NV, "GL_RASTERIZER_DISCARD_NV" );
	#endif
	#ifdef GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS_NV
		swigIntConstant( GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS_NV, "GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS_NV" );
	#endif
	#ifdef GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS_NV
		swigIntConstant( GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS_NV, "GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS_NV" );
	#endif
	#ifdef GL_INTERLEAVED_ATTRIBS_NV
		swigIntConstant( GL_INTERLEAVED_ATTRIBS_NV, "GL_INTERLEAVED_ATTRIBS_NV" );
	#endif
	#ifdef GL_SEPARATE_ATTRIBS_NV
		swigIntConstant( GL_SEPARATE_ATTRIBS_NV, "GL_SEPARATE_ATTRIBS_NV" );
	#endif
	#ifdef GL_TRANSFORM_FEEDBACK_BUFFER_NV
		swigIntConstant( GL_TRANSFORM_FEEDBACK_BUFFER_NV, "GL_TRANSFORM_FEEDBACK_BUFFER_NV" );
	#endif
	#ifdef GL_TRANSFORM_FEEDBACK_BUFFER_BINDING_NV
		swigIntConstant( GL_TRANSFORM_FEEDBACK_BUFFER_BINDING_NV, "GL_TRANSFORM_FEEDBACK_BUFFER_BINDING_NV" );
	#endif
	#ifdef GL_LAYER_NV
		swigIntConstant( GL_LAYER_NV, "GL_LAYER_NV" );
	#endif
	#ifdef GL_NEXT_BUFFER_NV
		swigIntConstant( GL_NEXT_BUFFER_NV, "GL_NEXT_BUFFER_NV" );
	#endif
	#ifdef GL_SKIP_COMPONENTS4_NV
		swigIntConstant( GL_SKIP_COMPONENTS4_NV, "GL_SKIP_COMPONENTS4_NV" );
	#endif
	#ifdef GL_SKIP_COMPONENTS3_NV
		swigIntConstant( GL_SKIP_COMPONENTS3_NV, "GL_SKIP_COMPONENTS3_NV" );
	#endif
	#ifdef GL_SKIP_COMPONENTS2_NV
		swigIntConstant( GL_SKIP_COMPONENTS2_NV, "GL_SKIP_COMPONENTS2_NV" );
	#endif
	#ifdef GL_SKIP_COMPONENTS1_NV
		swigIntConstant( GL_SKIP_COMPONENTS1_NV, "GL_SKIP_COMPONENTS1_NV" );
	#endif
	#ifdef GL_NV_transform_feedback2
		swigIntConstant( GL_NV_transform_feedback2, "GL_NV_transform_feedback2" );
	#endif
	#ifdef GL_TRANSFORM_FEEDBACK_NV
		swigIntConstant( GL_TRANSFORM_FEEDBACK_NV, "GL_TRANSFORM_FEEDBACK_NV" );
	#endif
	#ifdef GL_TRANSFORM_FEEDBACK_BUFFER_PAUSED_NV
		swigIntConstant( GL_TRANSFORM_FEEDBACK_BUFFER_PAUSED_NV, "GL_TRANSFORM_FEEDBACK_BUFFER_PAUSED_NV" );
	#endif
	#ifdef GL_TRANSFORM_FEEDBACK_BUFFER_ACTIVE_NV
		swigIntConstant( GL_TRANSFORM_FEEDBACK_BUFFER_ACTIVE_NV, "GL_TRANSFORM_FEEDBACK_BUFFER_ACTIVE_NV" );
	#endif
	#ifdef GL_TRANSFORM_FEEDBACK_BINDING_NV
		swigIntConstant( GL_TRANSFORM_FEEDBACK_BINDING_NV, "GL_TRANSFORM_FEEDBACK_BINDING_NV" );
	#endif
	#ifdef GL_NV_uniform_buffer_std430_layout
		swigIntConstant( GL_NV_uniform_buffer_std430_layout, "GL_NV_uniform_buffer_std430_layout" );
	#endif
	#ifdef GL_NV_uniform_buffer_unified_memory
		swigIntConstant( GL_NV_uniform_buffer_unified_memory, "GL_NV_uniform_buffer_unified_memory" );
	#endif
	#ifdef GL_UNIFORM_BUFFER_UNIFIED_NV
		swigIntConstant( GL_UNIFORM_BUFFER_UNIFIED_NV, "GL_UNIFORM_BUFFER_UNIFIED_NV" );
	#endif
	#ifdef GL_UNIFORM_BUFFER_ADDRESS_NV
		swigIntConstant( GL_UNIFORM_BUFFER_ADDRESS_NV, "GL_UNIFORM_BUFFER_ADDRESS_NV" );
	#endif
	#ifdef GL_UNIFORM_BUFFER_LENGTH_NV
		swigIntConstant( GL_UNIFORM_BUFFER_LENGTH_NV, "GL_UNIFORM_BUFFER_LENGTH_NV" );
	#endif
	#ifdef GL_NV_vdpau_interop
		swigIntConstant( GL_NV_vdpau_interop, "GL_NV_vdpau_interop" );
	#endif
	#ifdef GL_SURFACE_STATE_NV
		swigIntConstant( GL_SURFACE_STATE_NV, "GL_SURFACE_STATE_NV" );
	#endif
	#ifdef GL_SURFACE_REGISTERED_NV
		swigIntConstant( GL_SURFACE_REGISTERED_NV, "GL_SURFACE_REGISTERED_NV" );
	#endif
	#ifdef GL_SURFACE_MAPPED_NV
		swigIntConstant( GL_SURFACE_MAPPED_NV, "GL_SURFACE_MAPPED_NV" );
	#endif
	#ifdef GL_WRITE_DISCARD_NV
		swigIntConstant( GL_WRITE_DISCARD_NV, "GL_WRITE_DISCARD_NV" );
	#endif
	#ifdef GL_NV_vdpau_interop2
		swigIntConstant( GL_NV_vdpau_interop2, "GL_NV_vdpau_interop2" );
	#endif
	#ifdef GL_NV_vertex_array_range
		swigIntConstant( GL_NV_vertex_array_range, "GL_NV_vertex_array_range" );
	#endif
	#ifdef GL_VERTEX_ARRAY_RANGE_NV
		swigIntConstant( GL_VERTEX_ARRAY_RANGE_NV, "GL_VERTEX_ARRAY_RANGE_NV" );
	#endif
	#ifdef GL_VERTEX_ARRAY_RANGE_LENGTH_NV
		swigIntConstant( GL_VERTEX_ARRAY_RANGE_LENGTH_NV, "GL_VERTEX_ARRAY_RANGE_LENGTH_NV" );
	#endif
	#ifdef GL_VERTEX_ARRAY_RANGE_VALID_NV
		swigIntConstant( GL_VERTEX_ARRAY_RANGE_VALID_NV, "GL_VERTEX_ARRAY_RANGE_VALID_NV" );
	#endif
	#ifdef GL_MAX_VERTEX_ARRAY_RANGE_ELEMENT_NV
		swigIntConstant( GL_MAX_VERTEX_ARRAY_RANGE_ELEMENT_NV, "GL_MAX_VERTEX_ARRAY_RANGE_ELEMENT_NV" );
	#endif
	#ifdef GL_VERTEX_ARRAY_RANGE_POINTER_NV
		swigIntConstant( GL_VERTEX_ARRAY_RANGE_POINTER_NV, "GL_VERTEX_ARRAY_RANGE_POINTER_NV" );
	#endif
	#ifdef GL_NV_vertex_array_range2
		swigIntConstant( GL_NV_vertex_array_range2, "GL_NV_vertex_array_range2" );
	#endif
	#ifdef GL_VERTEX_ARRAY_RANGE_WITHOUT_FLUSH_NV
		swigIntConstant( GL_VERTEX_ARRAY_RANGE_WITHOUT_FLUSH_NV, "GL_VERTEX_ARRAY_RANGE_WITHOUT_FLUSH_NV" );
	#endif
	#ifdef GL_NV_vertex_attrib_integer_64bit
		swigIntConstant( GL_NV_vertex_attrib_integer_64bit, "GL_NV_vertex_attrib_integer_64bit" );
	#endif
	#ifdef GL_NV_vertex_buffer_unified_memory
		swigIntConstant( GL_NV_vertex_buffer_unified_memory, "GL_NV_vertex_buffer_unified_memory" );
	#endif
	#ifdef GL_VERTEX_ATTRIB_ARRAY_UNIFIED_NV
		swigIntConstant( GL_VERTEX_ATTRIB_ARRAY_UNIFIED_NV, "GL_VERTEX_ATTRIB_ARRAY_UNIFIED_NV" );
	#endif
	#ifdef GL_ELEMENT_ARRAY_UNIFIED_NV
		swigIntConstant( GL_ELEMENT_ARRAY_UNIFIED_NV, "GL_ELEMENT_ARRAY_UNIFIED_NV" );
	#endif
	#ifdef GL_VERTEX_ATTRIB_ARRAY_ADDRESS_NV
		swigIntConstant( GL_VERTEX_ATTRIB_ARRAY_ADDRESS_NV, "GL_VERTEX_ATTRIB_ARRAY_ADDRESS_NV" );
	#endif
	#ifdef GL_VERTEX_ARRAY_ADDRESS_NV
		swigIntConstant( GL_VERTEX_ARRAY_ADDRESS_NV, "GL_VERTEX_ARRAY_ADDRESS_NV" );
	#endif
	#ifdef GL_NORMAL_ARRAY_ADDRESS_NV
		swigIntConstant( GL_NORMAL_ARRAY_ADDRESS_NV, "GL_NORMAL_ARRAY_ADDRESS_NV" );
	#endif
	#ifdef GL_COLOR_ARRAY_ADDRESS_NV
		swigIntConstant( GL_COLOR_ARRAY_ADDRESS_NV, "GL_COLOR_ARRAY_ADDRESS_NV" );
	#endif
	#ifdef GL_INDEX_ARRAY_ADDRESS_NV
		swigIntConstant( GL_INDEX_ARRAY_ADDRESS_NV, "GL_INDEX_ARRAY_ADDRESS_NV" );
	#endif
	#ifdef GL_TEXTURE_COORD_ARRAY_ADDRESS_NV
		swigIntConstant( GL_TEXTURE_COORD_ARRAY_ADDRESS_NV, "GL_TEXTURE_COORD_ARRAY_ADDRESS_NV" );
	#endif
	#ifdef GL_EDGE_FLAG_ARRAY_ADDRESS_NV
		swigIntConstant( GL_EDGE_FLAG_ARRAY_ADDRESS_NV, "GL_EDGE_FLAG_ARRAY_ADDRESS_NV" );
	#endif
	#ifdef GL_SECONDARY_COLOR_ARRAY_ADDRESS_NV
		swigIntConstant( GL_SECONDARY_COLOR_ARRAY_ADDRESS_NV, "GL_SECONDARY_COLOR_ARRAY_ADDRESS_NV" );
	#endif
	#ifdef GL_FOG_COORD_ARRAY_ADDRESS_NV
		swigIntConstant( GL_FOG_COORD_ARRAY_ADDRESS_NV, "GL_FOG_COORD_ARRAY_ADDRESS_NV" );
	#endif
	#ifdef GL_ELEMENT_ARRAY_ADDRESS_NV
		swigIntConstant( GL_ELEMENT_ARRAY_ADDRESS_NV, "GL_ELEMENT_ARRAY_ADDRESS_NV" );
	#endif
	#ifdef GL_VERTEX_ATTRIB_ARRAY_LENGTH_NV
		swigIntConstant( GL_VERTEX_ATTRIB_ARRAY_LENGTH_NV, "GL_VERTEX_ATTRIB_ARRAY_LENGTH_NV" );
	#endif
	#ifdef GL_VERTEX_ARRAY_LENGTH_NV
		swigIntConstant( GL_VERTEX_ARRAY_LENGTH_NV, "GL_VERTEX_ARRAY_LENGTH_NV" );
	#endif
	#ifdef GL_NORMAL_ARRAY_LENGTH_NV
		swigIntConstant( GL_NORMAL_ARRAY_LENGTH_NV, "GL_NORMAL_ARRAY_LENGTH_NV" );
	#endif
	#ifdef GL_COLOR_ARRAY_LENGTH_NV
		swigIntConstant( GL_COLOR_ARRAY_LENGTH_NV, "GL_COLOR_ARRAY_LENGTH_NV" );
	#endif
	#ifdef GL_INDEX_ARRAY_LENGTH_NV
		swigIntConstant( GL_INDEX_ARRAY_LENGTH_NV, "GL_INDEX_ARRAY_LENGTH_NV" );
	#endif
	#ifdef GL_TEXTURE_COORD_ARRAY_LENGTH_NV
		swigIntConstant( GL_TEXTURE_COORD_ARRAY_LENGTH_NV, "GL_TEXTURE_COORD_ARRAY_LENGTH_NV" );
	#endif
	#ifdef GL_EDGE_FLAG_ARRAY_LENGTH_NV
		swigIntConstant( GL_EDGE_FLAG_ARRAY_LENGTH_NV, "GL_EDGE_FLAG_ARRAY_LENGTH_NV" );
	#endif
	#ifdef GL_SECONDARY_COLOR_ARRAY_LENGTH_NV
		swigIntConstant( GL_SECONDARY_COLOR_ARRAY_LENGTH_NV, "GL_SECONDARY_COLOR_ARRAY_LENGTH_NV" );
	#endif
	#ifdef GL_FOG_COORD_ARRAY_LENGTH_NV
		swigIntConstant( GL_FOG_COORD_ARRAY_LENGTH_NV, "GL_FOG_COORD_ARRAY_LENGTH_NV" );
	#endif
	#ifdef GL_ELEMENT_ARRAY_LENGTH_NV
		swigIntConstant( GL_ELEMENT_ARRAY_LENGTH_NV, "GL_ELEMENT_ARRAY_LENGTH_NV" );
	#endif
	#ifdef GL_DRAW_INDIRECT_UNIFIED_NV
		swigIntConstant( GL_DRAW_INDIRECT_UNIFIED_NV, "GL_DRAW_INDIRECT_UNIFIED_NV" );
	#endif
	#ifdef GL_DRAW_INDIRECT_ADDRESS_NV
		swigIntConstant( GL_DRAW_INDIRECT_ADDRESS_NV, "GL_DRAW_INDIRECT_ADDRESS_NV" );
	#endif
	#ifdef GL_DRAW_INDIRECT_LENGTH_NV
		swigIntConstant( GL_DRAW_INDIRECT_LENGTH_NV, "GL_DRAW_INDIRECT_LENGTH_NV" );
	#endif
	#ifdef GL_NV_vertex_program
		swigIntConstant( GL_NV_vertex_program, "GL_NV_vertex_program" );
	#endif
	#ifdef GL_VERTEX_PROGRAM_NV
		swigIntConstant( GL_VERTEX_PROGRAM_NV, "GL_VERTEX_PROGRAM_NV" );
	#endif
	#ifdef GL_VERTEX_STATE_PROGRAM_NV
		swigIntConstant( GL_VERTEX_STATE_PROGRAM_NV, "GL_VERTEX_STATE_PROGRAM_NV" );
	#endif
	#ifdef GL_ATTRIB_ARRAY_SIZE_NV
		swigIntConstant( GL_ATTRIB_ARRAY_SIZE_NV, "GL_ATTRIB_ARRAY_SIZE_NV" );
	#endif
	#ifdef GL_ATTRIB_ARRAY_STRIDE_NV
		swigIntConstant( GL_ATTRIB_ARRAY_STRIDE_NV, "GL_ATTRIB_ARRAY_STRIDE_NV" );
	#endif
	#ifdef GL_ATTRIB_ARRAY_TYPE_NV
		swigIntConstant( GL_ATTRIB_ARRAY_TYPE_NV, "GL_ATTRIB_ARRAY_TYPE_NV" );
	#endif
	#ifdef GL_CURRENT_ATTRIB_NV
		swigIntConstant( GL_CURRENT_ATTRIB_NV, "GL_CURRENT_ATTRIB_NV" );
	#endif
	#ifdef GL_PROGRAM_LENGTH_NV
		swigIntConstant( GL_PROGRAM_LENGTH_NV, "GL_PROGRAM_LENGTH_NV" );
	#endif
	#ifdef GL_PROGRAM_STRING_NV
		swigIntConstant( GL_PROGRAM_STRING_NV, "GL_PROGRAM_STRING_NV" );
	#endif
	#ifdef GL_MODELVIEW_PROJECTION_NV
		swigIntConstant( GL_MODELVIEW_PROJECTION_NV, "GL_MODELVIEW_PROJECTION_NV" );
	#endif
	#ifdef GL_IDENTITY_NV
		swigIntConstant( GL_IDENTITY_NV, "GL_IDENTITY_NV" );
	#endif
	#ifdef GL_INVERSE_NV
		swigIntConstant( GL_INVERSE_NV, "GL_INVERSE_NV" );
	#endif
	#ifdef GL_TRANSPOSE_NV
		swigIntConstant( GL_TRANSPOSE_NV, "GL_TRANSPOSE_NV" );
	#endif
	#ifdef GL_INVERSE_TRANSPOSE_NV
		swigIntConstant( GL_INVERSE_TRANSPOSE_NV, "GL_INVERSE_TRANSPOSE_NV" );
	#endif
	#ifdef GL_MAX_TRACK_MATRIX_STACK_DEPTH_NV
		swigIntConstant( GL_MAX_TRACK_MATRIX_STACK_DEPTH_NV, "GL_MAX_TRACK_MATRIX_STACK_DEPTH_NV" );
	#endif
	#ifdef GL_MAX_TRACK_MATRICES_NV
		swigIntConstant( GL_MAX_TRACK_MATRICES_NV, "GL_MAX_TRACK_MATRICES_NV" );
	#endif
	#ifdef GL_MATRIX0_NV
		swigIntConstant( GL_MATRIX0_NV, "GL_MATRIX0_NV" );
	#endif
	#ifdef GL_MATRIX1_NV
		swigIntConstant( GL_MATRIX1_NV, "GL_MATRIX1_NV" );
	#endif
	#ifdef GL_MATRIX2_NV
		swigIntConstant( GL_MATRIX2_NV, "GL_MATRIX2_NV" );
	#endif
	#ifdef GL_MATRIX3_NV
		swigIntConstant( GL_MATRIX3_NV, "GL_MATRIX3_NV" );
	#endif
	#ifdef GL_MATRIX4_NV
		swigIntConstant( GL_MATRIX4_NV, "GL_MATRIX4_NV" );
	#endif
	#ifdef GL_MATRIX5_NV
		swigIntConstant( GL_MATRIX5_NV, "GL_MATRIX5_NV" );
	#endif
	#ifdef GL_MATRIX6_NV
		swigIntConstant( GL_MATRIX6_NV, "GL_MATRIX6_NV" );
	#endif
	#ifdef GL_MATRIX7_NV
		swigIntConstant( GL_MATRIX7_NV, "GL_MATRIX7_NV" );
	#endif
	#ifdef GL_CURRENT_MATRIX_STACK_DEPTH_NV
		swigIntConstant( GL_CURRENT_MATRIX_STACK_DEPTH_NV, "GL_CURRENT_MATRIX_STACK_DEPTH_NV" );
	#endif
	#ifdef GL_CURRENT_MATRIX_NV
		swigIntConstant( GL_CURRENT_MATRIX_NV, "GL_CURRENT_MATRIX_NV" );
	#endif
	#ifdef GL_VERTEX_PROGRAM_POINT_SIZE_NV
		swigIntConstant( GL_VERTEX_PROGRAM_POINT_SIZE_NV, "GL_VERTEX_PROGRAM_POINT_SIZE_NV" );
	#endif
	#ifdef GL_VERTEX_PROGRAM_TWO_SIDE_NV
		swigIntConstant( GL_VERTEX_PROGRAM_TWO_SIDE_NV, "GL_VERTEX_PROGRAM_TWO_SIDE_NV" );
	#endif
	#ifdef GL_PROGRAM_PARAMETER_NV
		swigIntConstant( GL_PROGRAM_PARAMETER_NV, "GL_PROGRAM_PARAMETER_NV" );
	#endif
	#ifdef GL_ATTRIB_ARRAY_POINTER_NV
		swigIntConstant( GL_ATTRIB_ARRAY_POINTER_NV, "GL_ATTRIB_ARRAY_POINTER_NV" );
	#endif
	#ifdef GL_PROGRAM_TARGET_NV
		swigIntConstant( GL_PROGRAM_TARGET_NV, "GL_PROGRAM_TARGET_NV" );
	#endif
	#ifdef GL_PROGRAM_RESIDENT_NV
		swigIntConstant( GL_PROGRAM_RESIDENT_NV, "GL_PROGRAM_RESIDENT_NV" );
	#endif
	#ifdef GL_TRACK_MATRIX_NV
		swigIntConstant( GL_TRACK_MATRIX_NV, "GL_TRACK_MATRIX_NV" );
	#endif
	#ifdef GL_TRACK_MATRIX_TRANSFORM_NV
		swigIntConstant( GL_TRACK_MATRIX_TRANSFORM_NV, "GL_TRACK_MATRIX_TRANSFORM_NV" );
	#endif
	#ifdef GL_VERTEX_PROGRAM_BINDING_NV
		swigIntConstant( GL_VERTEX_PROGRAM_BINDING_NV, "GL_VERTEX_PROGRAM_BINDING_NV" );
	#endif
	#ifdef GL_PROGRAM_ERROR_POSITION_NV
		swigIntConstant( GL_PROGRAM_ERROR_POSITION_NV, "GL_PROGRAM_ERROR_POSITION_NV" );
	#endif
	#ifdef GL_VERTEX_ATTRIB_ARRAY0_NV
		swigIntConstant( GL_VERTEX_ATTRIB_ARRAY0_NV, "GL_VERTEX_ATTRIB_ARRAY0_NV" );
	#endif
	#ifdef GL_VERTEX_ATTRIB_ARRAY1_NV
		swigIntConstant( GL_VERTEX_ATTRIB_ARRAY1_NV, "GL_VERTEX_ATTRIB_ARRAY1_NV" );
	#endif
	#ifdef GL_VERTEX_ATTRIB_ARRAY2_NV
		swigIntConstant( GL_VERTEX_ATTRIB_ARRAY2_NV, "GL_VERTEX_ATTRIB_ARRAY2_NV" );
	#endif
	#ifdef GL_VERTEX_ATTRIB_ARRAY3_NV
		swigIntConstant( GL_VERTEX_ATTRIB_ARRAY3_NV, "GL_VERTEX_ATTRIB_ARRAY3_NV" );
	#endif
	#ifdef GL_VERTEX_ATTRIB_ARRAY4_NV
		swigIntConstant( GL_VERTEX_ATTRIB_ARRAY4_NV, "GL_VERTEX_ATTRIB_ARRAY4_NV" );
	#endif
	#ifdef GL_VERTEX_ATTRIB_ARRAY5_NV
		swigIntConstant( GL_VERTEX_ATTRIB_ARRAY5_NV, "GL_VERTEX_ATTRIB_ARRAY5_NV" );
	#endif
	#ifdef GL_VERTEX_ATTRIB_ARRAY6_NV
		swigIntConstant( GL_VERTEX_ATTRIB_ARRAY6_NV, "GL_VERTEX_ATTRIB_ARRAY6_NV" );
	#endif
	#ifdef GL_VERTEX_ATTRIB_ARRAY7_NV
		swigIntConstant( GL_VERTEX_ATTRIB_ARRAY7_NV, "GL_VERTEX_ATTRIB_ARRAY7_NV" );
	#endif
	#ifdef GL_VERTEX_ATTRIB_ARRAY8_NV
		swigIntConstant( GL_VERTEX_ATTRIB_ARRAY8_NV, "GL_VERTEX_ATTRIB_ARRAY8_NV" );
	#endif
	#ifdef GL_VERTEX_ATTRIB_ARRAY9_NV
		swigIntConstant( GL_VERTEX_ATTRIB_ARRAY9_NV, "GL_VERTEX_ATTRIB_ARRAY9_NV" );
	#endif
	#ifdef GL_VERTEX_ATTRIB_ARRAY10_NV
		swigIntConstant( GL_VERTEX_ATTRIB_ARRAY10_NV, "GL_VERTEX_ATTRIB_ARRAY10_NV" );
	#endif
	#ifdef GL_VERTEX_ATTRIB_ARRAY11_NV
		swigIntConstant( GL_VERTEX_ATTRIB_ARRAY11_NV, "GL_VERTEX_ATTRIB_ARRAY11_NV" );
	#endif
	#ifdef GL_VERTEX_ATTRIB_ARRAY12_NV
		swigIntConstant( GL_VERTEX_ATTRIB_ARRAY12_NV, "GL_VERTEX_ATTRIB_ARRAY12_NV" );
	#endif
	#ifdef GL_VERTEX_ATTRIB_ARRAY13_NV
		swigIntConstant( GL_VERTEX_ATTRIB_ARRAY13_NV, "GL_VERTEX_ATTRIB_ARRAY13_NV" );
	#endif
	#ifdef GL_VERTEX_ATTRIB_ARRAY14_NV
		swigIntConstant( GL_VERTEX_ATTRIB_ARRAY14_NV, "GL_VERTEX_ATTRIB_ARRAY14_NV" );
	#endif
	#ifdef GL_VERTEX_ATTRIB_ARRAY15_NV
		swigIntConstant( GL_VERTEX_ATTRIB_ARRAY15_NV, "GL_VERTEX_ATTRIB_ARRAY15_NV" );
	#endif
	#ifdef GL_MAP1_VERTEX_ATTRIB0_4_NV
		swigIntConstant( GL_MAP1_VERTEX_ATTRIB0_4_NV, "GL_MAP1_VERTEX_ATTRIB0_4_NV" );
	#endif
	#ifdef GL_MAP1_VERTEX_ATTRIB1_4_NV
		swigIntConstant( GL_MAP1_VERTEX_ATTRIB1_4_NV, "GL_MAP1_VERTEX_ATTRIB1_4_NV" );
	#endif
	#ifdef GL_MAP1_VERTEX_ATTRIB2_4_NV
		swigIntConstant( GL_MAP1_VERTEX_ATTRIB2_4_NV, "GL_MAP1_VERTEX_ATTRIB2_4_NV" );
	#endif
	#ifdef GL_MAP1_VERTEX_ATTRIB3_4_NV
		swigIntConstant( GL_MAP1_VERTEX_ATTRIB3_4_NV, "GL_MAP1_VERTEX_ATTRIB3_4_NV" );
	#endif
	#ifdef GL_MAP1_VERTEX_ATTRIB4_4_NV
		swigIntConstant( GL_MAP1_VERTEX_ATTRIB4_4_NV, "GL_MAP1_VERTEX_ATTRIB4_4_NV" );
	#endif
	#ifdef GL_MAP1_VERTEX_ATTRIB5_4_NV
		swigIntConstant( GL_MAP1_VERTEX_ATTRIB5_4_NV, "GL_MAP1_VERTEX_ATTRIB5_4_NV" );
	#endif
	#ifdef GL_MAP1_VERTEX_ATTRIB6_4_NV
		swigIntConstant( GL_MAP1_VERTEX_ATTRIB6_4_NV, "GL_MAP1_VERTEX_ATTRIB6_4_NV" );
	#endif
	#ifdef GL_MAP1_VERTEX_ATTRIB7_4_NV
		swigIntConstant( GL_MAP1_VERTEX_ATTRIB7_4_NV, "GL_MAP1_VERTEX_ATTRIB7_4_NV" );
	#endif
	#ifdef GL_MAP1_VERTEX_ATTRIB8_4_NV
		swigIntConstant( GL_MAP1_VERTEX_ATTRIB8_4_NV, "GL_MAP1_VERTEX_ATTRIB8_4_NV" );
	#endif
	#ifdef GL_MAP1_VERTEX_ATTRIB9_4_NV
		swigIntConstant( GL_MAP1_VERTEX_ATTRIB9_4_NV, "GL_MAP1_VERTEX_ATTRIB9_4_NV" );
	#endif
	#ifdef GL_MAP1_VERTEX_ATTRIB10_4_NV
		swigIntConstant( GL_MAP1_VERTEX_ATTRIB10_4_NV, "GL_MAP1_VERTEX_ATTRIB10_4_NV" );
	#endif
	#ifdef GL_MAP1_VERTEX_ATTRIB11_4_NV
		swigIntConstant( GL_MAP1_VERTEX_ATTRIB11_4_NV, "GL_MAP1_VERTEX_ATTRIB11_4_NV" );
	#endif
	#ifdef GL_MAP1_VERTEX_ATTRIB12_4_NV
		swigIntConstant( GL_MAP1_VERTEX_ATTRIB12_4_NV, "GL_MAP1_VERTEX_ATTRIB12_4_NV" );
	#endif
	#ifdef GL_MAP1_VERTEX_ATTRIB13_4_NV
		swigIntConstant( GL_MAP1_VERTEX_ATTRIB13_4_NV, "GL_MAP1_VERTEX_ATTRIB13_4_NV" );
	#endif
	#ifdef GL_MAP1_VERTEX_ATTRIB14_4_NV
		swigIntConstant( GL_MAP1_VERTEX_ATTRIB14_4_NV, "GL_MAP1_VERTEX_ATTRIB14_4_NV" );
	#endif
	#ifdef GL_MAP1_VERTEX_ATTRIB15_4_NV
		swigIntConstant( GL_MAP1_VERTEX_ATTRIB15_4_NV, "GL_MAP1_VERTEX_ATTRIB15_4_NV" );
	#endif
	#ifdef GL_MAP2_VERTEX_ATTRIB0_4_NV
		swigIntConstant( GL_MAP2_VERTEX_ATTRIB0_4_NV, "GL_MAP2_VERTEX_ATTRIB0_4_NV" );
	#endif
	#ifdef GL_MAP2_VERTEX_ATTRIB1_4_NV
		swigIntConstant( GL_MAP2_VERTEX_ATTRIB1_4_NV, "GL_MAP2_VERTEX_ATTRIB1_4_NV" );
	#endif
	#ifdef GL_MAP2_VERTEX_ATTRIB2_4_NV
		swigIntConstant( GL_MAP2_VERTEX_ATTRIB2_4_NV, "GL_MAP2_VERTEX_ATTRIB2_4_NV" );
	#endif
	#ifdef GL_MAP2_VERTEX_ATTRIB3_4_NV
		swigIntConstant( GL_MAP2_VERTEX_ATTRIB3_4_NV, "GL_MAP2_VERTEX_ATTRIB3_4_NV" );
	#endif
	#ifdef GL_MAP2_VERTEX_ATTRIB4_4_NV
		swigIntConstant( GL_MAP2_VERTEX_ATTRIB4_4_NV, "GL_MAP2_VERTEX_ATTRIB4_4_NV" );
	#endif
	#ifdef GL_MAP2_VERTEX_ATTRIB5_4_NV
		swigIntConstant( GL_MAP2_VERTEX_ATTRIB5_4_NV, "GL_MAP2_VERTEX_ATTRIB5_4_NV" );
	#endif
	#ifdef GL_MAP2_VERTEX_ATTRIB6_4_NV
		swigIntConstant( GL_MAP2_VERTEX_ATTRIB6_4_NV, "GL_MAP2_VERTEX_ATTRIB6_4_NV" );
	#endif
	#ifdef GL_MAP2_VERTEX_ATTRIB7_4_NV
		swigIntConstant( GL_MAP2_VERTEX_ATTRIB7_4_NV, "GL_MAP2_VERTEX_ATTRIB7_4_NV" );
	#endif
	#ifdef GL_MAP2_VERTEX_ATTRIB8_4_NV
		swigIntConstant( GL_MAP2_VERTEX_ATTRIB8_4_NV, "GL_MAP2_VERTEX_ATTRIB8_4_NV" );
	#endif
	#ifdef GL_MAP2_VERTEX_ATTRIB9_4_NV
		swigIntConstant( GL_MAP2_VERTEX_ATTRIB9_4_NV, "GL_MAP2_VERTEX_ATTRIB9_4_NV" );
	#endif
	#ifdef GL_MAP2_VERTEX_ATTRIB10_4_NV
		swigIntConstant( GL_MAP2_VERTEX_ATTRIB10_4_NV, "GL_MAP2_VERTEX_ATTRIB10_4_NV" );
	#endif
	#ifdef GL_MAP2_VERTEX_ATTRIB11_4_NV
		swigIntConstant( GL_MAP2_VERTEX_ATTRIB11_4_NV, "GL_MAP2_VERTEX_ATTRIB11_4_NV" );
	#endif
	#ifdef GL_MAP2_VERTEX_ATTRIB12_4_NV
		swigIntConstant( GL_MAP2_VERTEX_ATTRIB12_4_NV, "GL_MAP2_VERTEX_ATTRIB12_4_NV" );
	#endif
	#ifdef GL_MAP2_VERTEX_ATTRIB13_4_NV
		swigIntConstant( GL_MAP2_VERTEX_ATTRIB13_4_NV, "GL_MAP2_VERTEX_ATTRIB13_4_NV" );
	#endif
	#ifdef GL_MAP2_VERTEX_ATTRIB14_4_NV
		swigIntConstant( GL_MAP2_VERTEX_ATTRIB14_4_NV, "GL_MAP2_VERTEX_ATTRIB14_4_NV" );
	#endif
	#ifdef GL_MAP2_VERTEX_ATTRIB15_4_NV
		swigIntConstant( GL_MAP2_VERTEX_ATTRIB15_4_NV, "GL_MAP2_VERTEX_ATTRIB15_4_NV" );
	#endif
	#ifdef GL_NV_vertex_program1_1
		swigIntConstant( GL_NV_vertex_program1_1, "GL_NV_vertex_program1_1" );
	#endif
	#ifdef GL_NV_vertex_program2
		swigIntConstant( GL_NV_vertex_program2, "GL_NV_vertex_program2" );
	#endif
	#ifdef GL_NV_vertex_program2_option
		swigIntConstant( GL_NV_vertex_program2_option, "GL_NV_vertex_program2_option" );
	#endif
	#ifdef GL_NV_vertex_program3
		swigIntConstant( GL_NV_vertex_program3, "GL_NV_vertex_program3" );
	#endif
	#ifdef GL_NV_vertex_program4
		swigIntConstant( GL_NV_vertex_program4, "GL_NV_vertex_program4" );
	#endif
	#ifdef GL_VERTEX_ATTRIB_ARRAY_INTEGER_NV
		swigIntConstant( GL_VERTEX_ATTRIB_ARRAY_INTEGER_NV, "GL_VERTEX_ATTRIB_ARRAY_INTEGER_NV" );
	#endif
	#ifdef GL_NV_video_capture
		swigIntConstant( GL_NV_video_capture, "GL_NV_video_capture" );
	#endif
	#ifdef GL_VIDEO_BUFFER_NV
		swigIntConstant( GL_VIDEO_BUFFER_NV, "GL_VIDEO_BUFFER_NV" );
	#endif
	#ifdef GL_VIDEO_BUFFER_BINDING_NV
		swigIntConstant( GL_VIDEO_BUFFER_BINDING_NV, "GL_VIDEO_BUFFER_BINDING_NV" );
	#endif
	#ifdef GL_FIELD_UPPER_NV
		swigIntConstant( GL_FIELD_UPPER_NV, "GL_FIELD_UPPER_NV" );
	#endif
	#ifdef GL_FIELD_LOWER_NV
		swigIntConstant( GL_FIELD_LOWER_NV, "GL_FIELD_LOWER_NV" );
	#endif
	#ifdef GL_NUM_VIDEO_CAPTURE_STREAMS_NV
		swigIntConstant( GL_NUM_VIDEO_CAPTURE_STREAMS_NV, "GL_NUM_VIDEO_CAPTURE_STREAMS_NV" );
	#endif
	#ifdef GL_NEXT_VIDEO_CAPTURE_BUFFER_STATUS_NV
		swigIntConstant( GL_NEXT_VIDEO_CAPTURE_BUFFER_STATUS_NV, "GL_NEXT_VIDEO_CAPTURE_BUFFER_STATUS_NV" );
	#endif
	#ifdef GL_VIDEO_CAPTURE_TO_422_SUPPORTED_NV
		swigIntConstant( GL_VIDEO_CAPTURE_TO_422_SUPPORTED_NV, "GL_VIDEO_CAPTURE_TO_422_SUPPORTED_NV" );
	#endif
	#ifdef GL_LAST_VIDEO_CAPTURE_STATUS_NV
		swigIntConstant( GL_LAST_VIDEO_CAPTURE_STATUS_NV, "GL_LAST_VIDEO_CAPTURE_STATUS_NV" );
	#endif
	#ifdef GL_VIDEO_BUFFER_PITCH_NV
		swigIntConstant( GL_VIDEO_BUFFER_PITCH_NV, "GL_VIDEO_BUFFER_PITCH_NV" );
	#endif
	#ifdef GL_VIDEO_COLOR_CONVERSION_MATRIX_NV
		swigIntConstant( GL_VIDEO_COLOR_CONVERSION_MATRIX_NV, "GL_VIDEO_COLOR_CONVERSION_MATRIX_NV" );
	#endif
	#ifdef GL_VIDEO_COLOR_CONVERSION_MAX_NV
		swigIntConstant( GL_VIDEO_COLOR_CONVERSION_MAX_NV, "GL_VIDEO_COLOR_CONVERSION_MAX_NV" );
	#endif
	#ifdef GL_VIDEO_COLOR_CONVERSION_MIN_NV
		swigIntConstant( GL_VIDEO_COLOR_CONVERSION_MIN_NV, "GL_VIDEO_COLOR_CONVERSION_MIN_NV" );
	#endif
	#ifdef GL_VIDEO_COLOR_CONVERSION_OFFSET_NV
		swigIntConstant( GL_VIDEO_COLOR_CONVERSION_OFFSET_NV, "GL_VIDEO_COLOR_CONVERSION_OFFSET_NV" );
	#endif
	#ifdef GL_VIDEO_BUFFER_INTERNAL_FORMAT_NV
		swigIntConstant( GL_VIDEO_BUFFER_INTERNAL_FORMAT_NV, "GL_VIDEO_BUFFER_INTERNAL_FORMAT_NV" );
	#endif
	#ifdef GL_PARTIAL_SUCCESS_NV
		swigIntConstant( GL_PARTIAL_SUCCESS_NV, "GL_PARTIAL_SUCCESS_NV" );
	#endif
	#ifdef GL_SUCCESS_NV
		swigIntConstant( GL_SUCCESS_NV, "GL_SUCCESS_NV" );
	#endif
	#ifdef GL_FAILURE_NV
		swigIntConstant( GL_FAILURE_NV, "GL_FAILURE_NV" );
	#endif
	#ifdef GL_YCBYCR8_422_NV
		swigIntConstant( GL_YCBYCR8_422_NV, "GL_YCBYCR8_422_NV" );
	#endif
	#ifdef GL_YCBAYCR8A_4224_NV
		swigIntConstant( GL_YCBAYCR8A_4224_NV, "GL_YCBAYCR8A_4224_NV" );
	#endif
	#ifdef GL_Z6Y10Z6CB10Z6Y10Z6CR10_422_NV
		swigIntConstant( GL_Z6Y10Z6CB10Z6Y10Z6CR10_422_NV, "GL_Z6Y10Z6CB10Z6Y10Z6CR10_422_NV" );
	#endif
	#ifdef GL_Z6Y10Z6CB10Z6A10Z6Y10Z6CR10Z6A10_4224_NV
		swigIntConstant( GL_Z6Y10Z6CB10Z6A10Z6Y10Z6CR10Z6A10_4224_NV, "GL_Z6Y10Z6CB10Z6A10Z6Y10Z6CR10Z6A10_4224_NV" );
	#endif
	#ifdef GL_Z4Y12Z4CB12Z4Y12Z4CR12_422_NV
		swigIntConstant( GL_Z4Y12Z4CB12Z4Y12Z4CR12_422_NV, "GL_Z4Y12Z4CB12Z4Y12Z4CR12_422_NV" );
	#endif
	#ifdef GL_Z4Y12Z4CB12Z4A12Z4Y12Z4CR12Z4A12_4224_NV
		swigIntConstant( GL_Z4Y12Z4CB12Z4A12Z4Y12Z4CR12Z4A12_4224_NV, "GL_Z4Y12Z4CB12Z4A12Z4Y12Z4CR12Z4A12_4224_NV" );
	#endif
	#ifdef GL_Z4Y12Z4CB12Z4CR12_444_NV
		swigIntConstant( GL_Z4Y12Z4CB12Z4CR12_444_NV, "GL_Z4Y12Z4CB12Z4CR12_444_NV" );
	#endif
	#ifdef GL_VIDEO_CAPTURE_FRAME_WIDTH_NV
		swigIntConstant( GL_VIDEO_CAPTURE_FRAME_WIDTH_NV, "GL_VIDEO_CAPTURE_FRAME_WIDTH_NV" );
	#endif
	#ifdef GL_VIDEO_CAPTURE_FRAME_HEIGHT_NV
		swigIntConstant( GL_VIDEO_CAPTURE_FRAME_HEIGHT_NV, "GL_VIDEO_CAPTURE_FRAME_HEIGHT_NV" );
	#endif
	#ifdef GL_VIDEO_CAPTURE_FIELD_UPPER_HEIGHT_NV
		swigIntConstant( GL_VIDEO_CAPTURE_FIELD_UPPER_HEIGHT_NV, "GL_VIDEO_CAPTURE_FIELD_UPPER_HEIGHT_NV" );
	#endif
	#ifdef GL_VIDEO_CAPTURE_FIELD_LOWER_HEIGHT_NV
		swigIntConstant( GL_VIDEO_CAPTURE_FIELD_LOWER_HEIGHT_NV, "GL_VIDEO_CAPTURE_FIELD_LOWER_HEIGHT_NV" );
	#endif
	#ifdef GL_VIDEO_CAPTURE_SURFACE_ORIGIN_NV
		swigIntConstant( GL_VIDEO_CAPTURE_SURFACE_ORIGIN_NV, "GL_VIDEO_CAPTURE_SURFACE_ORIGIN_NV" );
	#endif
	#ifdef GL_NV_viewport_array2
		swigIntConstant( GL_NV_viewport_array2, "GL_NV_viewport_array2" );
	#endif
	#ifdef GL_NV_viewport_swizzle
		swigIntConstant( GL_NV_viewport_swizzle, "GL_NV_viewport_swizzle" );
	#endif
	#ifdef GL_VIEWPORT_SWIZZLE_POSITIVE_X_NV
		swigIntConstant( GL_VIEWPORT_SWIZZLE_POSITIVE_X_NV, "GL_VIEWPORT_SWIZZLE_POSITIVE_X_NV" );
	#endif
	#ifdef GL_VIEWPORT_SWIZZLE_NEGATIVE_X_NV
		swigIntConstant( GL_VIEWPORT_SWIZZLE_NEGATIVE_X_NV, "GL_VIEWPORT_SWIZZLE_NEGATIVE_X_NV" );
	#endif
	#ifdef GL_VIEWPORT_SWIZZLE_POSITIVE_Y_NV
		swigIntConstant( GL_VIEWPORT_SWIZZLE_POSITIVE_Y_NV, "GL_VIEWPORT_SWIZZLE_POSITIVE_Y_NV" );
	#endif
	#ifdef GL_VIEWPORT_SWIZZLE_NEGATIVE_Y_NV
		swigIntConstant( GL_VIEWPORT_SWIZZLE_NEGATIVE_Y_NV, "GL_VIEWPORT_SWIZZLE_NEGATIVE_Y_NV" );
	#endif
	#ifdef GL_VIEWPORT_SWIZZLE_POSITIVE_Z_NV
		swigIntConstant( GL_VIEWPORT_SWIZZLE_POSITIVE_Z_NV, "GL_VIEWPORT_SWIZZLE_POSITIVE_Z_NV" );
	#endif
	#ifdef GL_VIEWPORT_SWIZZLE_NEGATIVE_Z_NV
		swigIntConstant( GL_VIEWPORT_SWIZZLE_NEGATIVE_Z_NV, "GL_VIEWPORT_SWIZZLE_NEGATIVE_Z_NV" );
	#endif
	#ifdef GL_VIEWPORT_SWIZZLE_POSITIVE_W_NV
		swigIntConstant( GL_VIEWPORT_SWIZZLE_POSITIVE_W_NV, "GL_VIEWPORT_SWIZZLE_POSITIVE_W_NV" );
	#endif
	#ifdef GL_VIEWPORT_SWIZZLE_NEGATIVE_W_NV
		swigIntConstant( GL_VIEWPORT_SWIZZLE_NEGATIVE_W_NV, "GL_VIEWPORT_SWIZZLE_NEGATIVE_W_NV" );
	#endif
	#ifdef GL_VIEWPORT_SWIZZLE_X_NV
		swigIntConstant( GL_VIEWPORT_SWIZZLE_X_NV, "GL_VIEWPORT_SWIZZLE_X_NV" );
	#endif
	#ifdef GL_VIEWPORT_SWIZZLE_Y_NV
		swigIntConstant( GL_VIEWPORT_SWIZZLE_Y_NV, "GL_VIEWPORT_SWIZZLE_Y_NV" );
	#endif
	#ifdef GL_VIEWPORT_SWIZZLE_Z_NV
		swigIntConstant( GL_VIEWPORT_SWIZZLE_Z_NV, "GL_VIEWPORT_SWIZZLE_Z_NV" );
	#endif
	#ifdef GL_VIEWPORT_SWIZZLE_W_NV
		swigIntConstant( GL_VIEWPORT_SWIZZLE_W_NV, "GL_VIEWPORT_SWIZZLE_W_NV" );
	#endif
	#ifdef GL_OML_interlace
		swigIntConstant( GL_OML_interlace, "GL_OML_interlace" );
	#endif
	#ifdef GL_INTERLACE_OML
		swigIntConstant( GL_INTERLACE_OML, "GL_INTERLACE_OML" );
	#endif
	#ifdef GL_INTERLACE_READ_OML
		swigIntConstant( GL_INTERLACE_READ_OML, "GL_INTERLACE_READ_OML" );
	#endif
	#ifdef GL_OML_resample
		swigIntConstant( GL_OML_resample, "GL_OML_resample" );
	#endif
	#ifdef GL_PACK_RESAMPLE_OML
		swigIntConstant( GL_PACK_RESAMPLE_OML, "GL_PACK_RESAMPLE_OML" );
	#endif
	#ifdef GL_UNPACK_RESAMPLE_OML
		swigIntConstant( GL_UNPACK_RESAMPLE_OML, "GL_UNPACK_RESAMPLE_OML" );
	#endif
	#ifdef GL_RESAMPLE_REPLICATE_OML
		swigIntConstant( GL_RESAMPLE_REPLICATE_OML, "GL_RESAMPLE_REPLICATE_OML" );
	#endif
	#ifdef GL_RESAMPLE_ZERO_FILL_OML
		swigIntConstant( GL_RESAMPLE_ZERO_FILL_OML, "GL_RESAMPLE_ZERO_FILL_OML" );
	#endif
	#ifdef GL_RESAMPLE_AVERAGE_OML
		swigIntConstant( GL_RESAMPLE_AVERAGE_OML, "GL_RESAMPLE_AVERAGE_OML" );
	#endif
	#ifdef GL_RESAMPLE_DECIMATE_OML
		swigIntConstant( GL_RESAMPLE_DECIMATE_OML, "GL_RESAMPLE_DECIMATE_OML" );
	#endif
	#ifdef GL_OML_subsample
		swigIntConstant( GL_OML_subsample, "GL_OML_subsample" );
	#endif
	#ifdef GL_FORMAT_SUBSAMPLE_24_24_OML
		swigIntConstant( GL_FORMAT_SUBSAMPLE_24_24_OML, "GL_FORMAT_SUBSAMPLE_24_24_OML" );
	#endif
	#ifdef GL_FORMAT_SUBSAMPLE_244_244_OML
		swigIntConstant( GL_FORMAT_SUBSAMPLE_244_244_OML, "GL_FORMAT_SUBSAMPLE_244_244_OML" );
	#endif
	#ifdef GL_OVR_multiview
		swigIntConstant( GL_OVR_multiview, "GL_OVR_multiview" );
	#endif
	#ifdef GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_NUM_VIEWS_OVR
		swigIntConstant( GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_NUM_VIEWS_OVR, "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_NUM_VIEWS_OVR" );
	#endif
	#ifdef GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_BASE_VIEW_INDEX_OVR
		swigIntConstant( GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_BASE_VIEW_INDEX_OVR, "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_BASE_VIEW_INDEX_OVR" );
	#endif
	#ifdef GL_MAX_VIEWS_OVR
		swigIntConstant( GL_MAX_VIEWS_OVR, "GL_MAX_VIEWS_OVR" );
	#endif
	#ifdef GL_FRAMEBUFFER_INCOMPLETE_VIEW_TARGETS_OVR
		swigIntConstant( GL_FRAMEBUFFER_INCOMPLETE_VIEW_TARGETS_OVR, "GL_FRAMEBUFFER_INCOMPLETE_VIEW_TARGETS_OVR" );
	#endif
	#ifdef GL_OVR_multiview2
		swigIntConstant( GL_OVR_multiview2, "GL_OVR_multiview2" );
	#endif
	#ifdef GL_PGI_misc_hints
		swigIntConstant( GL_PGI_misc_hints, "GL_PGI_misc_hints" );
	#endif
	#ifdef GL_PREFER_DOUBLEBUFFER_HINT_PGI
		swigIntConstant( GL_PREFER_DOUBLEBUFFER_HINT_PGI, "GL_PREFER_DOUBLEBUFFER_HINT_PGI" );
	#endif
	#ifdef GL_CONSERVE_MEMORY_HINT_PGI
		swigIntConstant( GL_CONSERVE_MEMORY_HINT_PGI, "GL_CONSERVE_MEMORY_HINT_PGI" );
	#endif
	#ifdef GL_RECLAIM_MEMORY_HINT_PGI
		swigIntConstant( GL_RECLAIM_MEMORY_HINT_PGI, "GL_RECLAIM_MEMORY_HINT_PGI" );
	#endif
	#ifdef GL_NATIVE_GRAPHICS_HANDLE_PGI
		swigIntConstant( GL_NATIVE_GRAPHICS_HANDLE_PGI, "GL_NATIVE_GRAPHICS_HANDLE_PGI" );
	#endif
	#ifdef GL_NATIVE_GRAPHICS_BEGIN_HINT_PGI
		swigIntConstant( GL_NATIVE_GRAPHICS_BEGIN_HINT_PGI, "GL_NATIVE_GRAPHICS_BEGIN_HINT_PGI" );
	#endif
	#ifdef GL_NATIVE_GRAPHICS_END_HINT_PGI
		swigIntConstant( GL_NATIVE_GRAPHICS_END_HINT_PGI, "GL_NATIVE_GRAPHICS_END_HINT_PGI" );
	#endif
	#ifdef GL_ALWAYS_FAST_HINT_PGI
		swigIntConstant( GL_ALWAYS_FAST_HINT_PGI, "GL_ALWAYS_FAST_HINT_PGI" );
	#endif
	#ifdef GL_ALWAYS_SOFT_HINT_PGI
		swigIntConstant( GL_ALWAYS_SOFT_HINT_PGI, "GL_ALWAYS_SOFT_HINT_PGI" );
	#endif
	#ifdef GL_ALLOW_DRAW_OBJ_HINT_PGI
		swigIntConstant( GL_ALLOW_DRAW_OBJ_HINT_PGI, "GL_ALLOW_DRAW_OBJ_HINT_PGI" );
	#endif
	#ifdef GL_ALLOW_DRAW_WIN_HINT_PGI
		swigIntConstant( GL_ALLOW_DRAW_WIN_HINT_PGI, "GL_ALLOW_DRAW_WIN_HINT_PGI" );
	#endif
	#ifdef GL_ALLOW_DRAW_FRG_HINT_PGI
		swigIntConstant( GL_ALLOW_DRAW_FRG_HINT_PGI, "GL_ALLOW_DRAW_FRG_HINT_PGI" );
	#endif
	#ifdef GL_ALLOW_DRAW_MEM_HINT_PGI
		swigIntConstant( GL_ALLOW_DRAW_MEM_HINT_PGI, "GL_ALLOW_DRAW_MEM_HINT_PGI" );
	#endif
	#ifdef GL_STRICT_DEPTHFUNC_HINT_PGI
		swigIntConstant( GL_STRICT_DEPTHFUNC_HINT_PGI, "GL_STRICT_DEPTHFUNC_HINT_PGI" );
	#endif
	#ifdef GL_STRICT_LIGHTING_HINT_PGI
		swigIntConstant( GL_STRICT_LIGHTING_HINT_PGI, "GL_STRICT_LIGHTING_HINT_PGI" );
	#endif
	#ifdef GL_STRICT_SCISSOR_HINT_PGI
		swigIntConstant( GL_STRICT_SCISSOR_HINT_PGI, "GL_STRICT_SCISSOR_HINT_PGI" );
	#endif
	#ifdef GL_FULL_STIPPLE_HINT_PGI
		swigIntConstant( GL_FULL_STIPPLE_HINT_PGI, "GL_FULL_STIPPLE_HINT_PGI" );
	#endif
	#ifdef GL_CLIP_NEAR_HINT_PGI
		swigIntConstant( GL_CLIP_NEAR_HINT_PGI, "GL_CLIP_NEAR_HINT_PGI" );
	#endif
	#ifdef GL_CLIP_FAR_HINT_PGI
		swigIntConstant( GL_CLIP_FAR_HINT_PGI, "GL_CLIP_FAR_HINT_PGI" );
	#endif
	#ifdef GL_WIDE_LINE_HINT_PGI
		swigIntConstant( GL_WIDE_LINE_HINT_PGI, "GL_WIDE_LINE_HINT_PGI" );
	#endif
	#ifdef GL_BACK_NORMALS_HINT_PGI
		swigIntConstant( GL_BACK_NORMALS_HINT_PGI, "GL_BACK_NORMALS_HINT_PGI" );
	#endif
	#ifdef GL_PGI_vertex_hints
		swigIntConstant( GL_PGI_vertex_hints, "GL_PGI_vertex_hints" );
	#endif
	#ifdef GL_VERTEX_DATA_HINT_PGI
		swigIntConstant( GL_VERTEX_DATA_HINT_PGI, "GL_VERTEX_DATA_HINT_PGI" );
	#endif
	#ifdef GL_VERTEX_CONSISTENT_HINT_PGI
		swigIntConstant( GL_VERTEX_CONSISTENT_HINT_PGI, "GL_VERTEX_CONSISTENT_HINT_PGI" );
	#endif
	#ifdef GL_MATERIAL_SIDE_HINT_PGI
		swigIntConstant( GL_MATERIAL_SIDE_HINT_PGI, "GL_MATERIAL_SIDE_HINT_PGI" );
	#endif
	#ifdef GL_MAX_VERTEX_HINT_PGI
		swigIntConstant( GL_MAX_VERTEX_HINT_PGI, "GL_MAX_VERTEX_HINT_PGI" );
	#endif
	#ifdef GL_COLOR3_BIT_PGI
		swigIntConstant( GL_COLOR3_BIT_PGI, "GL_COLOR3_BIT_PGI" );
	#endif
	#ifdef GL_COLOR4_BIT_PGI
		swigIntConstant( GL_COLOR4_BIT_PGI, "GL_COLOR4_BIT_PGI" );
	#endif
	#ifdef GL_EDGEFLAG_BIT_PGI
		swigIntConstant( GL_EDGEFLAG_BIT_PGI, "GL_EDGEFLAG_BIT_PGI" );
	#endif
	#ifdef GL_INDEX_BIT_PGI
		swigIntConstant( GL_INDEX_BIT_PGI, "GL_INDEX_BIT_PGI" );
	#endif
	#ifdef GL_MAT_AMBIENT_BIT_PGI
		swigIntConstant( GL_MAT_AMBIENT_BIT_PGI, "GL_MAT_AMBIENT_BIT_PGI" );
	#endif
	#ifdef GL_MAT_AMBIENT_AND_DIFFUSE_BIT_PGI
		swigIntConstant( GL_MAT_AMBIENT_AND_DIFFUSE_BIT_PGI, "GL_MAT_AMBIENT_AND_DIFFUSE_BIT_PGI" );
	#endif
	#ifdef GL_MAT_DIFFUSE_BIT_PGI
		swigIntConstant( GL_MAT_DIFFUSE_BIT_PGI, "GL_MAT_DIFFUSE_BIT_PGI" );
	#endif
	#ifdef GL_MAT_EMISSION_BIT_PGI
		swigIntConstant( GL_MAT_EMISSION_BIT_PGI, "GL_MAT_EMISSION_BIT_PGI" );
	#endif
	#ifdef GL_MAT_COLOR_INDEXES_BIT_PGI
		swigIntConstant( GL_MAT_COLOR_INDEXES_BIT_PGI, "GL_MAT_COLOR_INDEXES_BIT_PGI" );
	#endif
	#ifdef GL_MAT_SHININESS_BIT_PGI
		swigIntConstant( GL_MAT_SHININESS_BIT_PGI, "GL_MAT_SHININESS_BIT_PGI" );
	#endif
	#ifdef GL_MAT_SPECULAR_BIT_PGI
		swigIntConstant( GL_MAT_SPECULAR_BIT_PGI, "GL_MAT_SPECULAR_BIT_PGI" );
	#endif
	#ifdef GL_NORMAL_BIT_PGI
		swigIntConstant( GL_NORMAL_BIT_PGI, "GL_NORMAL_BIT_PGI" );
	#endif
	#ifdef GL_TEXCOORD1_BIT_PGI
		swigIntConstant( GL_TEXCOORD1_BIT_PGI, "GL_TEXCOORD1_BIT_PGI" );
	#endif
	#ifdef GL_TEXCOORD2_BIT_PGI
		swigIntConstant( GL_TEXCOORD2_BIT_PGI, "GL_TEXCOORD2_BIT_PGI" );
	#endif
	#ifdef GL_TEXCOORD3_BIT_PGI
		swigIntConstant( GL_TEXCOORD3_BIT_PGI, "GL_TEXCOORD3_BIT_PGI" );
	#endif
	#ifdef GL_TEXCOORD4_BIT_PGI
		swigIntConstant( GL_TEXCOORD4_BIT_PGI, "GL_TEXCOORD4_BIT_PGI" );
	#endif
	#ifdef GL_VERTEX23_BIT_PGI
		swigIntConstant( GL_VERTEX23_BIT_PGI, "GL_VERTEX23_BIT_PGI" );
	#endif
	#ifdef GL_VERTEX4_BIT_PGI
		swigIntConstant( GL_VERTEX4_BIT_PGI, "GL_VERTEX4_BIT_PGI" );
	#endif
	#ifdef GL_REND_screen_coordinates
		swigIntConstant( GL_REND_screen_coordinates, "GL_REND_screen_coordinates" );
	#endif
	#ifdef GL_SCREEN_COORDINATES_REND
		swigIntConstant( GL_SCREEN_COORDINATES_REND, "GL_SCREEN_COORDINATES_REND" );
	#endif
	#ifdef GL_INVERTED_SCREEN_W_REND
		swigIntConstant( GL_INVERTED_SCREEN_W_REND, "GL_INVERTED_SCREEN_W_REND" );
	#endif
	#ifdef GL_S3_s3tc
		swigIntConstant( GL_S3_s3tc, "GL_S3_s3tc" );
	#endif
	#ifdef GL_RGB_S3TC
		swigIntConstant( GL_RGB_S3TC, "GL_RGB_S3TC" );
	#endif
	#ifdef GL_RGB4_S3TC
		swigIntConstant( GL_RGB4_S3TC, "GL_RGB4_S3TC" );
	#endif
	#ifdef GL_RGBA_S3TC
		swigIntConstant( GL_RGBA_S3TC, "GL_RGBA_S3TC" );
	#endif
	#ifdef GL_RGBA4_S3TC
		swigIntConstant( GL_RGBA4_S3TC, "GL_RGBA4_S3TC" );
	#endif
	#ifdef GL_RGBA_DXT5_S3TC
		swigIntConstant( GL_RGBA_DXT5_S3TC, "GL_RGBA_DXT5_S3TC" );
	#endif
	#ifdef GL_RGBA4_DXT5_S3TC
		swigIntConstant( GL_RGBA4_DXT5_S3TC, "GL_RGBA4_DXT5_S3TC" );
	#endif
	#ifdef GL_SGIS_detail_texture
		swigIntConstant( GL_SGIS_detail_texture, "GL_SGIS_detail_texture" );
	#endif
	#ifdef GL_DETAIL_TEXTURE_2D_SGIS
		swigIntConstant( GL_DETAIL_TEXTURE_2D_SGIS, "GL_DETAIL_TEXTURE_2D_SGIS" );
	#endif
	#ifdef GL_DETAIL_TEXTURE_2D_BINDING_SGIS
		swigIntConstant( GL_DETAIL_TEXTURE_2D_BINDING_SGIS, "GL_DETAIL_TEXTURE_2D_BINDING_SGIS" );
	#endif
	#ifdef GL_LINEAR_DETAIL_SGIS
		swigIntConstant( GL_LINEAR_DETAIL_SGIS, "GL_LINEAR_DETAIL_SGIS" );
	#endif
	#ifdef GL_LINEAR_DETAIL_ALPHA_SGIS
		swigIntConstant( GL_LINEAR_DETAIL_ALPHA_SGIS, "GL_LINEAR_DETAIL_ALPHA_SGIS" );
	#endif
	#ifdef GL_LINEAR_DETAIL_COLOR_SGIS
		swigIntConstant( GL_LINEAR_DETAIL_COLOR_SGIS, "GL_LINEAR_DETAIL_COLOR_SGIS" );
	#endif
	#ifdef GL_DETAIL_TEXTURE_LEVEL_SGIS
		swigIntConstant( GL_DETAIL_TEXTURE_LEVEL_SGIS, "GL_DETAIL_TEXTURE_LEVEL_SGIS" );
	#endif
	#ifdef GL_DETAIL_TEXTURE_MODE_SGIS
		swigIntConstant( GL_DETAIL_TEXTURE_MODE_SGIS, "GL_DETAIL_TEXTURE_MODE_SGIS" );
	#endif
	#ifdef GL_DETAIL_TEXTURE_FUNC_POINTS_SGIS
		swigIntConstant( GL_DETAIL_TEXTURE_FUNC_POINTS_SGIS, "GL_DETAIL_TEXTURE_FUNC_POINTS_SGIS" );
	#endif
	#ifdef GL_SGIS_fog_function
		swigIntConstant( GL_SGIS_fog_function, "GL_SGIS_fog_function" );
	#endif
	#ifdef GL_FOG_FUNC_SGIS
		swigIntConstant( GL_FOG_FUNC_SGIS, "GL_FOG_FUNC_SGIS" );
	#endif
	#ifdef GL_FOG_FUNC_POINTS_SGIS
		swigIntConstant( GL_FOG_FUNC_POINTS_SGIS, "GL_FOG_FUNC_POINTS_SGIS" );
	#endif
	#ifdef GL_MAX_FOG_FUNC_POINTS_SGIS
		swigIntConstant( GL_MAX_FOG_FUNC_POINTS_SGIS, "GL_MAX_FOG_FUNC_POINTS_SGIS" );
	#endif
	#ifdef GL_SGIS_generate_mipmap
		swigIntConstant( GL_SGIS_generate_mipmap, "GL_SGIS_generate_mipmap" );
	#endif
	#ifdef GL_GENERATE_MIPMAP_SGIS
		swigIntConstant( GL_GENERATE_MIPMAP_SGIS, "GL_GENERATE_MIPMAP_SGIS" );
	#endif
	#ifdef GL_GENERATE_MIPMAP_HINT_SGIS
		swigIntConstant( GL_GENERATE_MIPMAP_HINT_SGIS, "GL_GENERATE_MIPMAP_HINT_SGIS" );
	#endif
	#ifdef GL_SGIS_multisample
		swigIntConstant( GL_SGIS_multisample, "GL_SGIS_multisample" );
	#endif
	#ifdef GL_MULTISAMPLE_SGIS
		swigIntConstant( GL_MULTISAMPLE_SGIS, "GL_MULTISAMPLE_SGIS" );
	#endif
	#ifdef GL_SAMPLE_ALPHA_TO_MASK_SGIS
		swigIntConstant( GL_SAMPLE_ALPHA_TO_MASK_SGIS, "GL_SAMPLE_ALPHA_TO_MASK_SGIS" );
	#endif
	#ifdef GL_SAMPLE_ALPHA_TO_ONE_SGIS
		swigIntConstant( GL_SAMPLE_ALPHA_TO_ONE_SGIS, "GL_SAMPLE_ALPHA_TO_ONE_SGIS" );
	#endif
	#ifdef GL_SAMPLE_MASK_SGIS
		swigIntConstant( GL_SAMPLE_MASK_SGIS, "GL_SAMPLE_MASK_SGIS" );
	#endif
	#ifdef GL_1PASS_SGIS
		swigIntConstant( GL_1PASS_SGIS, "GL_1PASS_SGIS" );
	#endif
	#ifdef GL_2PASS_0_SGIS
		swigIntConstant( GL_2PASS_0_SGIS, "GL_2PASS_0_SGIS" );
	#endif
	#ifdef GL_2PASS_1_SGIS
		swigIntConstant( GL_2PASS_1_SGIS, "GL_2PASS_1_SGIS" );
	#endif
	#ifdef GL_4PASS_0_SGIS
		swigIntConstant( GL_4PASS_0_SGIS, "GL_4PASS_0_SGIS" );
	#endif
	#ifdef GL_4PASS_1_SGIS
		swigIntConstant( GL_4PASS_1_SGIS, "GL_4PASS_1_SGIS" );
	#endif
	#ifdef GL_4PASS_2_SGIS
		swigIntConstant( GL_4PASS_2_SGIS, "GL_4PASS_2_SGIS" );
	#endif
	#ifdef GL_4PASS_3_SGIS
		swigIntConstant( GL_4PASS_3_SGIS, "GL_4PASS_3_SGIS" );
	#endif
	#ifdef GL_SAMPLE_BUFFERS_SGIS
		swigIntConstant( GL_SAMPLE_BUFFERS_SGIS, "GL_SAMPLE_BUFFERS_SGIS" );
	#endif
	#ifdef GL_SAMPLES_SGIS
		swigIntConstant( GL_SAMPLES_SGIS, "GL_SAMPLES_SGIS" );
	#endif
	#ifdef GL_SAMPLE_MASK_VALUE_SGIS
		swigIntConstant( GL_SAMPLE_MASK_VALUE_SGIS, "GL_SAMPLE_MASK_VALUE_SGIS" );
	#endif
	#ifdef GL_SAMPLE_MASK_INVERT_SGIS
		swigIntConstant( GL_SAMPLE_MASK_INVERT_SGIS, "GL_SAMPLE_MASK_INVERT_SGIS" );
	#endif
	#ifdef GL_SAMPLE_PATTERN_SGIS
		swigIntConstant( GL_SAMPLE_PATTERN_SGIS, "GL_SAMPLE_PATTERN_SGIS" );
	#endif
	#ifdef GL_SGIS_pixel_texture
		swigIntConstant( GL_SGIS_pixel_texture, "GL_SGIS_pixel_texture" );
	#endif
	#ifdef GL_PIXEL_TEXTURE_SGIS
		swigIntConstant( GL_PIXEL_TEXTURE_SGIS, "GL_PIXEL_TEXTURE_SGIS" );
	#endif
	#ifdef GL_PIXEL_FRAGMENT_RGB_SOURCE_SGIS
		swigIntConstant( GL_PIXEL_FRAGMENT_RGB_SOURCE_SGIS, "GL_PIXEL_FRAGMENT_RGB_SOURCE_SGIS" );
	#endif
	#ifdef GL_PIXEL_FRAGMENT_ALPHA_SOURCE_SGIS
		swigIntConstant( GL_PIXEL_FRAGMENT_ALPHA_SOURCE_SGIS, "GL_PIXEL_FRAGMENT_ALPHA_SOURCE_SGIS" );
	#endif
	#ifdef GL_PIXEL_GROUP_COLOR_SGIS
		swigIntConstant( GL_PIXEL_GROUP_COLOR_SGIS, "GL_PIXEL_GROUP_COLOR_SGIS" );
	#endif
	#ifdef GL_SGIS_point_line_texgen
		swigIntConstant( GL_SGIS_point_line_texgen, "GL_SGIS_point_line_texgen" );
	#endif
	#ifdef GL_EYE_DISTANCE_TO_POINT_SGIS
		swigIntConstant( GL_EYE_DISTANCE_TO_POINT_SGIS, "GL_EYE_DISTANCE_TO_POINT_SGIS" );
	#endif
	#ifdef GL_OBJECT_DISTANCE_TO_POINT_SGIS
		swigIntConstant( GL_OBJECT_DISTANCE_TO_POINT_SGIS, "GL_OBJECT_DISTANCE_TO_POINT_SGIS" );
	#endif
	#ifdef GL_EYE_DISTANCE_TO_LINE_SGIS
		swigIntConstant( GL_EYE_DISTANCE_TO_LINE_SGIS, "GL_EYE_DISTANCE_TO_LINE_SGIS" );
	#endif
	#ifdef GL_OBJECT_DISTANCE_TO_LINE_SGIS
		swigIntConstant( GL_OBJECT_DISTANCE_TO_LINE_SGIS, "GL_OBJECT_DISTANCE_TO_LINE_SGIS" );
	#endif
	#ifdef GL_EYE_POINT_SGIS
		swigIntConstant( GL_EYE_POINT_SGIS, "GL_EYE_POINT_SGIS" );
	#endif
	#ifdef GL_OBJECT_POINT_SGIS
		swigIntConstant( GL_OBJECT_POINT_SGIS, "GL_OBJECT_POINT_SGIS" );
	#endif
	#ifdef GL_EYE_LINE_SGIS
		swigIntConstant( GL_EYE_LINE_SGIS, "GL_EYE_LINE_SGIS" );
	#endif
	#ifdef GL_OBJECT_LINE_SGIS
		swigIntConstant( GL_OBJECT_LINE_SGIS, "GL_OBJECT_LINE_SGIS" );
	#endif
	#ifdef GL_SGIS_point_parameters
		swigIntConstant( GL_SGIS_point_parameters, "GL_SGIS_point_parameters" );
	#endif
	#ifdef GL_POINT_SIZE_MIN_SGIS
		swigIntConstant( GL_POINT_SIZE_MIN_SGIS, "GL_POINT_SIZE_MIN_SGIS" );
	#endif
	#ifdef GL_POINT_SIZE_MAX_SGIS
		swigIntConstant( GL_POINT_SIZE_MAX_SGIS, "GL_POINT_SIZE_MAX_SGIS" );
	#endif
	#ifdef GL_POINT_FADE_THRESHOLD_SIZE_SGIS
		swigIntConstant( GL_POINT_FADE_THRESHOLD_SIZE_SGIS, "GL_POINT_FADE_THRESHOLD_SIZE_SGIS" );
	#endif
	#ifdef GL_DISTANCE_ATTENUATION_SGIS
		swigIntConstant( GL_DISTANCE_ATTENUATION_SGIS, "GL_DISTANCE_ATTENUATION_SGIS" );
	#endif
	#ifdef GL_SGIS_sharpen_texture
		swigIntConstant( GL_SGIS_sharpen_texture, "GL_SGIS_sharpen_texture" );
	#endif
	#ifdef GL_LINEAR_SHARPEN_SGIS
		swigIntConstant( GL_LINEAR_SHARPEN_SGIS, "GL_LINEAR_SHARPEN_SGIS" );
	#endif
	#ifdef GL_LINEAR_SHARPEN_ALPHA_SGIS
		swigIntConstant( GL_LINEAR_SHARPEN_ALPHA_SGIS, "GL_LINEAR_SHARPEN_ALPHA_SGIS" );
	#endif
	#ifdef GL_LINEAR_SHARPEN_COLOR_SGIS
		swigIntConstant( GL_LINEAR_SHARPEN_COLOR_SGIS, "GL_LINEAR_SHARPEN_COLOR_SGIS" );
	#endif
	#ifdef GL_SHARPEN_TEXTURE_FUNC_POINTS_SGIS
		swigIntConstant( GL_SHARPEN_TEXTURE_FUNC_POINTS_SGIS, "GL_SHARPEN_TEXTURE_FUNC_POINTS_SGIS" );
	#endif
	#ifdef GL_SGIS_texture4D
		swigIntConstant( GL_SGIS_texture4D, "GL_SGIS_texture4D" );
	#endif
	#ifdef GL_PACK_SKIP_VOLUMES_SGIS
		swigIntConstant( GL_PACK_SKIP_VOLUMES_SGIS, "GL_PACK_SKIP_VOLUMES_SGIS" );
	#endif
	#ifdef GL_PACK_IMAGE_DEPTH_SGIS
		swigIntConstant( GL_PACK_IMAGE_DEPTH_SGIS, "GL_PACK_IMAGE_DEPTH_SGIS" );
	#endif
	#ifdef GL_UNPACK_SKIP_VOLUMES_SGIS
		swigIntConstant( GL_UNPACK_SKIP_VOLUMES_SGIS, "GL_UNPACK_SKIP_VOLUMES_SGIS" );
	#endif
	#ifdef GL_UNPACK_IMAGE_DEPTH_SGIS
		swigIntConstant( GL_UNPACK_IMAGE_DEPTH_SGIS, "GL_UNPACK_IMAGE_DEPTH_SGIS" );
	#endif
	#ifdef GL_TEXTURE_4D_SGIS
		swigIntConstant( GL_TEXTURE_4D_SGIS, "GL_TEXTURE_4D_SGIS" );
	#endif
	#ifdef GL_PROXY_TEXTURE_4D_SGIS
		swigIntConstant( GL_PROXY_TEXTURE_4D_SGIS, "GL_PROXY_TEXTURE_4D_SGIS" );
	#endif
	#ifdef GL_TEXTURE_4DSIZE_SGIS
		swigIntConstant( GL_TEXTURE_4DSIZE_SGIS, "GL_TEXTURE_4DSIZE_SGIS" );
	#endif
	#ifdef GL_TEXTURE_WRAP_Q_SGIS
		swigIntConstant( GL_TEXTURE_WRAP_Q_SGIS, "GL_TEXTURE_WRAP_Q_SGIS" );
	#endif
	#ifdef GL_MAX_4D_TEXTURE_SIZE_SGIS
		swigIntConstant( GL_MAX_4D_TEXTURE_SIZE_SGIS, "GL_MAX_4D_TEXTURE_SIZE_SGIS" );
	#endif
	#ifdef GL_TEXTURE_4D_BINDING_SGIS
		swigIntConstant( GL_TEXTURE_4D_BINDING_SGIS, "GL_TEXTURE_4D_BINDING_SGIS" );
	#endif
	#ifdef GL_SGIS_texture_border_clamp
		swigIntConstant( GL_SGIS_texture_border_clamp, "GL_SGIS_texture_border_clamp" );
	#endif
	#ifdef GL_CLAMP_TO_BORDER_SGIS
		swigIntConstant( GL_CLAMP_TO_BORDER_SGIS, "GL_CLAMP_TO_BORDER_SGIS" );
	#endif
	#ifdef GL_SGIS_texture_color_mask
		swigIntConstant( GL_SGIS_texture_color_mask, "GL_SGIS_texture_color_mask" );
	#endif
	#ifdef GL_TEXTURE_COLOR_WRITEMASK_SGIS
		swigIntConstant( GL_TEXTURE_COLOR_WRITEMASK_SGIS, "GL_TEXTURE_COLOR_WRITEMASK_SGIS" );
	#endif
	#ifdef GL_SGIS_texture_edge_clamp
		swigIntConstant( GL_SGIS_texture_edge_clamp, "GL_SGIS_texture_edge_clamp" );
	#endif
	#ifdef GL_CLAMP_TO_EDGE_SGIS
		swigIntConstant( GL_CLAMP_TO_EDGE_SGIS, "GL_CLAMP_TO_EDGE_SGIS" );
	#endif
	#ifdef GL_SGIS_texture_filter4
		swigIntConstant( GL_SGIS_texture_filter4, "GL_SGIS_texture_filter4" );
	#endif
	#ifdef GL_FILTER4_SGIS
		swigIntConstant( GL_FILTER4_SGIS, "GL_FILTER4_SGIS" );
	#endif
	#ifdef GL_TEXTURE_FILTER4_SIZE_SGIS
		swigIntConstant( GL_TEXTURE_FILTER4_SIZE_SGIS, "GL_TEXTURE_FILTER4_SIZE_SGIS" );
	#endif
	#ifdef GL_SGIS_texture_lod
		swigIntConstant( GL_SGIS_texture_lod, "GL_SGIS_texture_lod" );
	#endif
	#ifdef GL_TEXTURE_MIN_LOD_SGIS
		swigIntConstant( GL_TEXTURE_MIN_LOD_SGIS, "GL_TEXTURE_MIN_LOD_SGIS" );
	#endif
	#ifdef GL_TEXTURE_MAX_LOD_SGIS
		swigIntConstant( GL_TEXTURE_MAX_LOD_SGIS, "GL_TEXTURE_MAX_LOD_SGIS" );
	#endif
	#ifdef GL_TEXTURE_BASE_LEVEL_SGIS
		swigIntConstant( GL_TEXTURE_BASE_LEVEL_SGIS, "GL_TEXTURE_BASE_LEVEL_SGIS" );
	#endif
	#ifdef GL_TEXTURE_MAX_LEVEL_SGIS
		swigIntConstant( GL_TEXTURE_MAX_LEVEL_SGIS, "GL_TEXTURE_MAX_LEVEL_SGIS" );
	#endif
	#ifdef GL_SGIS_texture_select
		swigIntConstant( GL_SGIS_texture_select, "GL_SGIS_texture_select" );
	#endif
	#ifdef GL_DUAL_ALPHA4_SGIS
		swigIntConstant( GL_DUAL_ALPHA4_SGIS, "GL_DUAL_ALPHA4_SGIS" );
	#endif
	#ifdef GL_DUAL_ALPHA8_SGIS
		swigIntConstant( GL_DUAL_ALPHA8_SGIS, "GL_DUAL_ALPHA8_SGIS" );
	#endif
	#ifdef GL_DUAL_ALPHA12_SGIS
		swigIntConstant( GL_DUAL_ALPHA12_SGIS, "GL_DUAL_ALPHA12_SGIS" );
	#endif
	#ifdef GL_DUAL_ALPHA16_SGIS
		swigIntConstant( GL_DUAL_ALPHA16_SGIS, "GL_DUAL_ALPHA16_SGIS" );
	#endif
	#ifdef GL_DUAL_LUMINANCE4_SGIS
		swigIntConstant( GL_DUAL_LUMINANCE4_SGIS, "GL_DUAL_LUMINANCE4_SGIS" );
	#endif
	#ifdef GL_DUAL_LUMINANCE8_SGIS
		swigIntConstant( GL_DUAL_LUMINANCE8_SGIS, "GL_DUAL_LUMINANCE8_SGIS" );
	#endif
	#ifdef GL_DUAL_LUMINANCE12_SGIS
		swigIntConstant( GL_DUAL_LUMINANCE12_SGIS, "GL_DUAL_LUMINANCE12_SGIS" );
	#endif
	#ifdef GL_DUAL_LUMINANCE16_SGIS
		swigIntConstant( GL_DUAL_LUMINANCE16_SGIS, "GL_DUAL_LUMINANCE16_SGIS" );
	#endif
	#ifdef GL_DUAL_INTENSITY4_SGIS
		swigIntConstant( GL_DUAL_INTENSITY4_SGIS, "GL_DUAL_INTENSITY4_SGIS" );
	#endif
	#ifdef GL_DUAL_INTENSITY8_SGIS
		swigIntConstant( GL_DUAL_INTENSITY8_SGIS, "GL_DUAL_INTENSITY8_SGIS" );
	#endif
	#ifdef GL_DUAL_INTENSITY12_SGIS
		swigIntConstant( GL_DUAL_INTENSITY12_SGIS, "GL_DUAL_INTENSITY12_SGIS" );
	#endif
	#ifdef GL_DUAL_INTENSITY16_SGIS
		swigIntConstant( GL_DUAL_INTENSITY16_SGIS, "GL_DUAL_INTENSITY16_SGIS" );
	#endif
	#ifdef GL_DUAL_LUMINANCE_ALPHA4_SGIS
		swigIntConstant( GL_DUAL_LUMINANCE_ALPHA4_SGIS, "GL_DUAL_LUMINANCE_ALPHA4_SGIS" );
	#endif
	#ifdef GL_DUAL_LUMINANCE_ALPHA8_SGIS
		swigIntConstant( GL_DUAL_LUMINANCE_ALPHA8_SGIS, "GL_DUAL_LUMINANCE_ALPHA8_SGIS" );
	#endif
	#ifdef GL_QUAD_ALPHA4_SGIS
		swigIntConstant( GL_QUAD_ALPHA4_SGIS, "GL_QUAD_ALPHA4_SGIS" );
	#endif
	#ifdef GL_QUAD_ALPHA8_SGIS
		swigIntConstant( GL_QUAD_ALPHA8_SGIS, "GL_QUAD_ALPHA8_SGIS" );
	#endif
	#ifdef GL_QUAD_LUMINANCE4_SGIS
		swigIntConstant( GL_QUAD_LUMINANCE4_SGIS, "GL_QUAD_LUMINANCE4_SGIS" );
	#endif
	#ifdef GL_QUAD_LUMINANCE8_SGIS
		swigIntConstant( GL_QUAD_LUMINANCE8_SGIS, "GL_QUAD_LUMINANCE8_SGIS" );
	#endif
	#ifdef GL_QUAD_INTENSITY4_SGIS
		swigIntConstant( GL_QUAD_INTENSITY4_SGIS, "GL_QUAD_INTENSITY4_SGIS" );
	#endif
	#ifdef GL_QUAD_INTENSITY8_SGIS
		swigIntConstant( GL_QUAD_INTENSITY8_SGIS, "GL_QUAD_INTENSITY8_SGIS" );
	#endif
	#ifdef GL_DUAL_TEXTURE_SELECT_SGIS
		swigIntConstant( GL_DUAL_TEXTURE_SELECT_SGIS, "GL_DUAL_TEXTURE_SELECT_SGIS" );
	#endif
	#ifdef GL_QUAD_TEXTURE_SELECT_SGIS
		swigIntConstant( GL_QUAD_TEXTURE_SELECT_SGIS, "GL_QUAD_TEXTURE_SELECT_SGIS" );
	#endif
	#ifdef GL_SGIX_async
		swigIntConstant( GL_SGIX_async, "GL_SGIX_async" );
	#endif
	#ifdef GL_ASYNC_MARKER_SGIX
		swigIntConstant( GL_ASYNC_MARKER_SGIX, "GL_ASYNC_MARKER_SGIX" );
	#endif
	#ifdef GL_SGIX_async_histogram
		swigIntConstant( GL_SGIX_async_histogram, "GL_SGIX_async_histogram" );
	#endif
	#ifdef GL_ASYNC_HISTOGRAM_SGIX
		swigIntConstant( GL_ASYNC_HISTOGRAM_SGIX, "GL_ASYNC_HISTOGRAM_SGIX" );
	#endif
	#ifdef GL_MAX_ASYNC_HISTOGRAM_SGIX
		swigIntConstant( GL_MAX_ASYNC_HISTOGRAM_SGIX, "GL_MAX_ASYNC_HISTOGRAM_SGIX" );
	#endif
	#ifdef GL_SGIX_async_pixel
		swigIntConstant( GL_SGIX_async_pixel, "GL_SGIX_async_pixel" );
	#endif
	#ifdef GL_ASYNC_TEX_IMAGE_SGIX
		swigIntConstant( GL_ASYNC_TEX_IMAGE_SGIX, "GL_ASYNC_TEX_IMAGE_SGIX" );
	#endif
	#ifdef GL_ASYNC_DRAW_PIXELS_SGIX
		swigIntConstant( GL_ASYNC_DRAW_PIXELS_SGIX, "GL_ASYNC_DRAW_PIXELS_SGIX" );
	#endif
	#ifdef GL_ASYNC_READ_PIXELS_SGIX
		swigIntConstant( GL_ASYNC_READ_PIXELS_SGIX, "GL_ASYNC_READ_PIXELS_SGIX" );
	#endif
	#ifdef GL_MAX_ASYNC_TEX_IMAGE_SGIX
		swigIntConstant( GL_MAX_ASYNC_TEX_IMAGE_SGIX, "GL_MAX_ASYNC_TEX_IMAGE_SGIX" );
	#endif
	#ifdef GL_MAX_ASYNC_DRAW_PIXELS_SGIX
		swigIntConstant( GL_MAX_ASYNC_DRAW_PIXELS_SGIX, "GL_MAX_ASYNC_DRAW_PIXELS_SGIX" );
	#endif
	#ifdef GL_MAX_ASYNC_READ_PIXELS_SGIX
		swigIntConstant( GL_MAX_ASYNC_READ_PIXELS_SGIX, "GL_MAX_ASYNC_READ_PIXELS_SGIX" );
	#endif
	#ifdef GL_SGIX_blend_alpha_minmax
		swigIntConstant( GL_SGIX_blend_alpha_minmax, "GL_SGIX_blend_alpha_minmax" );
	#endif
	#ifdef GL_ALPHA_MIN_SGIX
		swigIntConstant( GL_ALPHA_MIN_SGIX, "GL_ALPHA_MIN_SGIX" );
	#endif
	#ifdef GL_ALPHA_MAX_SGIX
		swigIntConstant( GL_ALPHA_MAX_SGIX, "GL_ALPHA_MAX_SGIX" );
	#endif
	#ifdef GL_SGIX_calligraphic_fragment
		swigIntConstant( GL_SGIX_calligraphic_fragment, "GL_SGIX_calligraphic_fragment" );
	#endif
	#ifdef GL_CALLIGRAPHIC_FRAGMENT_SGIX
		swigIntConstant( GL_CALLIGRAPHIC_FRAGMENT_SGIX, "GL_CALLIGRAPHIC_FRAGMENT_SGIX" );
	#endif
	#ifdef GL_SGIX_clipmap
		swigIntConstant( GL_SGIX_clipmap, "GL_SGIX_clipmap" );
	#endif
	#ifdef GL_LINEAR_CLIPMAP_LINEAR_SGIX
		swigIntConstant( GL_LINEAR_CLIPMAP_LINEAR_SGIX, "GL_LINEAR_CLIPMAP_LINEAR_SGIX" );
	#endif
	#ifdef GL_TEXTURE_CLIPMAP_CENTER_SGIX
		swigIntConstant( GL_TEXTURE_CLIPMAP_CENTER_SGIX, "GL_TEXTURE_CLIPMAP_CENTER_SGIX" );
	#endif
	#ifdef GL_TEXTURE_CLIPMAP_FRAME_SGIX
		swigIntConstant( GL_TEXTURE_CLIPMAP_FRAME_SGIX, "GL_TEXTURE_CLIPMAP_FRAME_SGIX" );
	#endif
	#ifdef GL_TEXTURE_CLIPMAP_OFFSET_SGIX
		swigIntConstant( GL_TEXTURE_CLIPMAP_OFFSET_SGIX, "GL_TEXTURE_CLIPMAP_OFFSET_SGIX" );
	#endif
	#ifdef GL_TEXTURE_CLIPMAP_VIRTUAL_DEPTH_SGIX
		swigIntConstant( GL_TEXTURE_CLIPMAP_VIRTUAL_DEPTH_SGIX, "GL_TEXTURE_CLIPMAP_VIRTUAL_DEPTH_SGIX" );
	#endif
	#ifdef GL_TEXTURE_CLIPMAP_LOD_OFFSET_SGIX
		swigIntConstant( GL_TEXTURE_CLIPMAP_LOD_OFFSET_SGIX, "GL_TEXTURE_CLIPMAP_LOD_OFFSET_SGIX" );
	#endif
	#ifdef GL_TEXTURE_CLIPMAP_DEPTH_SGIX
		swigIntConstant( GL_TEXTURE_CLIPMAP_DEPTH_SGIX, "GL_TEXTURE_CLIPMAP_DEPTH_SGIX" );
	#endif
	#ifdef GL_MAX_CLIPMAP_DEPTH_SGIX
		swigIntConstant( GL_MAX_CLIPMAP_DEPTH_SGIX, "GL_MAX_CLIPMAP_DEPTH_SGIX" );
	#endif
	#ifdef GL_MAX_CLIPMAP_VIRTUAL_DEPTH_SGIX
		swigIntConstant( GL_MAX_CLIPMAP_VIRTUAL_DEPTH_SGIX, "GL_MAX_CLIPMAP_VIRTUAL_DEPTH_SGIX" );
	#endif
	#ifdef GL_NEAREST_CLIPMAP_NEAREST_SGIX
		swigIntConstant( GL_NEAREST_CLIPMAP_NEAREST_SGIX, "GL_NEAREST_CLIPMAP_NEAREST_SGIX" );
	#endif
	#ifdef GL_NEAREST_CLIPMAP_LINEAR_SGIX
		swigIntConstant( GL_NEAREST_CLIPMAP_LINEAR_SGIX, "GL_NEAREST_CLIPMAP_LINEAR_SGIX" );
	#endif
	#ifdef GL_LINEAR_CLIPMAP_NEAREST_SGIX
		swigIntConstant( GL_LINEAR_CLIPMAP_NEAREST_SGIX, "GL_LINEAR_CLIPMAP_NEAREST_SGIX" );
	#endif
	#ifdef GL_SGIX_convolution_accuracy
		swigIntConstant( GL_SGIX_convolution_accuracy, "GL_SGIX_convolution_accuracy" );
	#endif
	#ifdef GL_CONVOLUTION_HINT_SGIX
		swigIntConstant( GL_CONVOLUTION_HINT_SGIX, "GL_CONVOLUTION_HINT_SGIX" );
	#endif
	#ifdef GL_SGIX_depth_pass_instrument
		swigIntConstant( GL_SGIX_depth_pass_instrument, "GL_SGIX_depth_pass_instrument" );
	#endif
	#ifdef GL_SGIX_depth_texture
		swigIntConstant( GL_SGIX_depth_texture, "GL_SGIX_depth_texture" );
	#endif
	#ifdef GL_DEPTH_COMPONENT16_SGIX
		swigIntConstant( GL_DEPTH_COMPONENT16_SGIX, "GL_DEPTH_COMPONENT16_SGIX" );
	#endif
	#ifdef GL_DEPTH_COMPONENT24_SGIX
		swigIntConstant( GL_DEPTH_COMPONENT24_SGIX, "GL_DEPTH_COMPONENT24_SGIX" );
	#endif
	#ifdef GL_DEPTH_COMPONENT32_SGIX
		swigIntConstant( GL_DEPTH_COMPONENT32_SGIX, "GL_DEPTH_COMPONENT32_SGIX" );
	#endif
	#ifdef GL_SGIX_flush_raster
		swigIntConstant( GL_SGIX_flush_raster, "GL_SGIX_flush_raster" );
	#endif
	#ifdef GL_SGIX_fog_offset
		swigIntConstant( GL_SGIX_fog_offset, "GL_SGIX_fog_offset" );
	#endif
	#ifdef GL_FOG_OFFSET_SGIX
		swigIntConstant( GL_FOG_OFFSET_SGIX, "GL_FOG_OFFSET_SGIX" );
	#endif
	#ifdef GL_FOG_OFFSET_VALUE_SGIX
		swigIntConstant( GL_FOG_OFFSET_VALUE_SGIX, "GL_FOG_OFFSET_VALUE_SGIX" );
	#endif
	#ifdef GL_SGIX_fragment_lighting
		swigIntConstant( GL_SGIX_fragment_lighting, "GL_SGIX_fragment_lighting" );
	#endif
	#ifdef GL_FRAGMENT_LIGHTING_SGIX
		swigIntConstant( GL_FRAGMENT_LIGHTING_SGIX, "GL_FRAGMENT_LIGHTING_SGIX" );
	#endif
	#ifdef GL_FRAGMENT_COLOR_MATERIAL_SGIX
		swigIntConstant( GL_FRAGMENT_COLOR_MATERIAL_SGIX, "GL_FRAGMENT_COLOR_MATERIAL_SGIX" );
	#endif
	#ifdef GL_FRAGMENT_COLOR_MATERIAL_FACE_SGIX
		swigIntConstant( GL_FRAGMENT_COLOR_MATERIAL_FACE_SGIX, "GL_FRAGMENT_COLOR_MATERIAL_FACE_SGIX" );
	#endif
	#ifdef GL_FRAGMENT_COLOR_MATERIAL_PARAMETER_SGIX
		swigIntConstant( GL_FRAGMENT_COLOR_MATERIAL_PARAMETER_SGIX, "GL_FRAGMENT_COLOR_MATERIAL_PARAMETER_SGIX" );
	#endif
	#ifdef GL_MAX_FRAGMENT_LIGHTS_SGIX
		swigIntConstant( GL_MAX_FRAGMENT_LIGHTS_SGIX, "GL_MAX_FRAGMENT_LIGHTS_SGIX" );
	#endif
	#ifdef GL_MAX_ACTIVE_LIGHTS_SGIX
		swigIntConstant( GL_MAX_ACTIVE_LIGHTS_SGIX, "GL_MAX_ACTIVE_LIGHTS_SGIX" );
	#endif
	#ifdef GL_CURRENT_RASTER_NORMAL_SGIX
		swigIntConstant( GL_CURRENT_RASTER_NORMAL_SGIX, "GL_CURRENT_RASTER_NORMAL_SGIX" );
	#endif
	#ifdef GL_LIGHT_ENV_MODE_SGIX
		swigIntConstant( GL_LIGHT_ENV_MODE_SGIX, "GL_LIGHT_ENV_MODE_SGIX" );
	#endif
	#ifdef GL_FRAGMENT_LIGHT_MODEL_LOCAL_VIEWER_SGIX
		swigIntConstant( GL_FRAGMENT_LIGHT_MODEL_LOCAL_VIEWER_SGIX, "GL_FRAGMENT_LIGHT_MODEL_LOCAL_VIEWER_SGIX" );
	#endif
	#ifdef GL_FRAGMENT_LIGHT_MODEL_TWO_SIDE_SGIX
		swigIntConstant( GL_FRAGMENT_LIGHT_MODEL_TWO_SIDE_SGIX, "GL_FRAGMENT_LIGHT_MODEL_TWO_SIDE_SGIX" );
	#endif
	#ifdef GL_FRAGMENT_LIGHT_MODEL_AMBIENT_SGIX
		swigIntConstant( GL_FRAGMENT_LIGHT_MODEL_AMBIENT_SGIX, "GL_FRAGMENT_LIGHT_MODEL_AMBIENT_SGIX" );
	#endif
	#ifdef GL_FRAGMENT_LIGHT_MODEL_NORMAL_INTERPOLATION_SGIX
		swigIntConstant( GL_FRAGMENT_LIGHT_MODEL_NORMAL_INTERPOLATION_SGIX, "GL_FRAGMENT_LIGHT_MODEL_NORMAL_INTERPOLATION_SGIX" );
	#endif
	#ifdef GL_FRAGMENT_LIGHT0_SGIX
		swigIntConstant( GL_FRAGMENT_LIGHT0_SGIX, "GL_FRAGMENT_LIGHT0_SGIX" );
	#endif
	#ifdef GL_FRAGMENT_LIGHT1_SGIX
		swigIntConstant( GL_FRAGMENT_LIGHT1_SGIX, "GL_FRAGMENT_LIGHT1_SGIX" );
	#endif
	#ifdef GL_FRAGMENT_LIGHT2_SGIX
		swigIntConstant( GL_FRAGMENT_LIGHT2_SGIX, "GL_FRAGMENT_LIGHT2_SGIX" );
	#endif
	#ifdef GL_FRAGMENT_LIGHT3_SGIX
		swigIntConstant( GL_FRAGMENT_LIGHT3_SGIX, "GL_FRAGMENT_LIGHT3_SGIX" );
	#endif
	#ifdef GL_FRAGMENT_LIGHT4_SGIX
		swigIntConstant( GL_FRAGMENT_LIGHT4_SGIX, "GL_FRAGMENT_LIGHT4_SGIX" );
	#endif
	#ifdef GL_FRAGMENT_LIGHT5_SGIX
		swigIntConstant( GL_FRAGMENT_LIGHT5_SGIX, "GL_FRAGMENT_LIGHT5_SGIX" );
	#endif
	#ifdef GL_FRAGMENT_LIGHT6_SGIX
		swigIntConstant( GL_FRAGMENT_LIGHT6_SGIX, "GL_FRAGMENT_LIGHT6_SGIX" );
	#endif
	#ifdef GL_FRAGMENT_LIGHT7_SGIX
		swigIntConstant( GL_FRAGMENT_LIGHT7_SGIX, "GL_FRAGMENT_LIGHT7_SGIX" );
	#endif
	#ifdef GL_SGIX_framezoom
		swigIntConstant( GL_SGIX_framezoom, "GL_SGIX_framezoom" );
	#endif
	#ifdef GL_FRAMEZOOM_SGIX
		swigIntConstant( GL_FRAMEZOOM_SGIX, "GL_FRAMEZOOM_SGIX" );
	#endif
	#ifdef GL_FRAMEZOOM_FACTOR_SGIX
		swigIntConstant( GL_FRAMEZOOM_FACTOR_SGIX, "GL_FRAMEZOOM_FACTOR_SGIX" );
	#endif
	#ifdef GL_MAX_FRAMEZOOM_FACTOR_SGIX
		swigIntConstant( GL_MAX_FRAMEZOOM_FACTOR_SGIX, "GL_MAX_FRAMEZOOM_FACTOR_SGIX" );
	#endif
	#ifdef GL_SGIX_igloo_interface
		swigIntConstant( GL_SGIX_igloo_interface, "GL_SGIX_igloo_interface" );
	#endif
	#ifdef GL_SGIX_instruments
		swigIntConstant( GL_SGIX_instruments, "GL_SGIX_instruments" );
	#endif
	#ifdef GL_INSTRUMENT_BUFFER_POINTER_SGIX
		swigIntConstant( GL_INSTRUMENT_BUFFER_POINTER_SGIX, "GL_INSTRUMENT_BUFFER_POINTER_SGIX" );
	#endif
	#ifdef GL_INSTRUMENT_MEASUREMENTS_SGIX
		swigIntConstant( GL_INSTRUMENT_MEASUREMENTS_SGIX, "GL_INSTRUMENT_MEASUREMENTS_SGIX" );
	#endif
	#ifdef GL_SGIX_interlace
		swigIntConstant( GL_SGIX_interlace, "GL_SGIX_interlace" );
	#endif
	#ifdef GL_INTERLACE_SGIX
		swigIntConstant( GL_INTERLACE_SGIX, "GL_INTERLACE_SGIX" );
	#endif
	#ifdef GL_SGIX_ir_instrument1
		swigIntConstant( GL_SGIX_ir_instrument1, "GL_SGIX_ir_instrument1" );
	#endif
	#ifdef GL_IR_INSTRUMENT1_SGIX
		swigIntConstant( GL_IR_INSTRUMENT1_SGIX, "GL_IR_INSTRUMENT1_SGIX" );
	#endif
	#ifdef GL_SGIX_list_priority
		swigIntConstant( GL_SGIX_list_priority, "GL_SGIX_list_priority" );
	#endif
	#ifdef GL_LIST_PRIORITY_SGIX
		swigIntConstant( GL_LIST_PRIORITY_SGIX, "GL_LIST_PRIORITY_SGIX" );
	#endif
	#ifdef GL_SGIX_pixel_texture
		swigIntConstant( GL_SGIX_pixel_texture, "GL_SGIX_pixel_texture" );
	#endif
	#ifdef GL_PIXEL_TEX_GEN_SGIX
		swigIntConstant( GL_PIXEL_TEX_GEN_SGIX, "GL_PIXEL_TEX_GEN_SGIX" );
	#endif
	#ifdef GL_PIXEL_TEX_GEN_MODE_SGIX
		swigIntConstant( GL_PIXEL_TEX_GEN_MODE_SGIX, "GL_PIXEL_TEX_GEN_MODE_SGIX" );
	#endif
	#ifdef GL_SGIX_pixel_tiles
		swigIntConstant( GL_SGIX_pixel_tiles, "GL_SGIX_pixel_tiles" );
	#endif
	#ifdef GL_PIXEL_TILE_BEST_ALIGNMENT_SGIX
		swigIntConstant( GL_PIXEL_TILE_BEST_ALIGNMENT_SGIX, "GL_PIXEL_TILE_BEST_ALIGNMENT_SGIX" );
	#endif
	#ifdef GL_PIXEL_TILE_CACHE_INCREMENT_SGIX
		swigIntConstant( GL_PIXEL_TILE_CACHE_INCREMENT_SGIX, "GL_PIXEL_TILE_CACHE_INCREMENT_SGIX" );
	#endif
	#ifdef GL_PIXEL_TILE_WIDTH_SGIX
		swigIntConstant( GL_PIXEL_TILE_WIDTH_SGIX, "GL_PIXEL_TILE_WIDTH_SGIX" );
	#endif
	#ifdef GL_PIXEL_TILE_HEIGHT_SGIX
		swigIntConstant( GL_PIXEL_TILE_HEIGHT_SGIX, "GL_PIXEL_TILE_HEIGHT_SGIX" );
	#endif
	#ifdef GL_PIXEL_TILE_GRID_WIDTH_SGIX
		swigIntConstant( GL_PIXEL_TILE_GRID_WIDTH_SGIX, "GL_PIXEL_TILE_GRID_WIDTH_SGIX" );
	#endif
	#ifdef GL_PIXEL_TILE_GRID_HEIGHT_SGIX
		swigIntConstant( GL_PIXEL_TILE_GRID_HEIGHT_SGIX, "GL_PIXEL_TILE_GRID_HEIGHT_SGIX" );
	#endif
	#ifdef GL_PIXEL_TILE_GRID_DEPTH_SGIX
		swigIntConstant( GL_PIXEL_TILE_GRID_DEPTH_SGIX, "GL_PIXEL_TILE_GRID_DEPTH_SGIX" );
	#endif
	#ifdef GL_PIXEL_TILE_CACHE_SIZE_SGIX
		swigIntConstant( GL_PIXEL_TILE_CACHE_SIZE_SGIX, "GL_PIXEL_TILE_CACHE_SIZE_SGIX" );
	#endif
	#ifdef GL_SGIX_polynomial_ffd
		swigIntConstant( GL_SGIX_polynomial_ffd, "GL_SGIX_polynomial_ffd" );
	#endif
	#ifdef GL_TEXTURE_DEFORMATION_BIT_SGIX
		swigIntConstant( GL_TEXTURE_DEFORMATION_BIT_SGIX, "GL_TEXTURE_DEFORMATION_BIT_SGIX" );
	#endif
	#ifdef GL_GEOMETRY_DEFORMATION_BIT_SGIX
		swigIntConstant( GL_GEOMETRY_DEFORMATION_BIT_SGIX, "GL_GEOMETRY_DEFORMATION_BIT_SGIX" );
	#endif
	#ifdef GL_GEOMETRY_DEFORMATION_SGIX
		swigIntConstant( GL_GEOMETRY_DEFORMATION_SGIX, "GL_GEOMETRY_DEFORMATION_SGIX" );
	#endif
	#ifdef GL_TEXTURE_DEFORMATION_SGIX
		swigIntConstant( GL_TEXTURE_DEFORMATION_SGIX, "GL_TEXTURE_DEFORMATION_SGIX" );
	#endif
	#ifdef GL_DEFORMATIONS_MASK_SGIX
		swigIntConstant( GL_DEFORMATIONS_MASK_SGIX, "GL_DEFORMATIONS_MASK_SGIX" );
	#endif
	#ifdef GL_MAX_DEFORMATION_ORDER_SGIX
		swigIntConstant( GL_MAX_DEFORMATION_ORDER_SGIX, "GL_MAX_DEFORMATION_ORDER_SGIX" );
	#endif
	#ifdef GL_SGIX_reference_plane
		swigIntConstant( GL_SGIX_reference_plane, "GL_SGIX_reference_plane" );
	#endif
	#ifdef GL_REFERENCE_PLANE_SGIX
		swigIntConstant( GL_REFERENCE_PLANE_SGIX, "GL_REFERENCE_PLANE_SGIX" );
	#endif
	#ifdef GL_REFERENCE_PLANE_EQUATION_SGIX
		swigIntConstant( GL_REFERENCE_PLANE_EQUATION_SGIX, "GL_REFERENCE_PLANE_EQUATION_SGIX" );
	#endif
	#ifdef GL_SGIX_resample
		swigIntConstant( GL_SGIX_resample, "GL_SGIX_resample" );
	#endif
	#ifdef GL_PACK_RESAMPLE_SGIX
		swigIntConstant( GL_PACK_RESAMPLE_SGIX, "GL_PACK_RESAMPLE_SGIX" );
	#endif
	#ifdef GL_UNPACK_RESAMPLE_SGIX
		swigIntConstant( GL_UNPACK_RESAMPLE_SGIX, "GL_UNPACK_RESAMPLE_SGIX" );
	#endif
	#ifdef GL_RESAMPLE_REPLICATE_SGIX
		swigIntConstant( GL_RESAMPLE_REPLICATE_SGIX, "GL_RESAMPLE_REPLICATE_SGIX" );
	#endif
	#ifdef GL_RESAMPLE_ZERO_FILL_SGIX
		swigIntConstant( GL_RESAMPLE_ZERO_FILL_SGIX, "GL_RESAMPLE_ZERO_FILL_SGIX" );
	#endif
	#ifdef GL_RESAMPLE_DECIMATE_SGIX
		swigIntConstant( GL_RESAMPLE_DECIMATE_SGIX, "GL_RESAMPLE_DECIMATE_SGIX" );
	#endif
	#ifdef GL_SGIX_scalebias_hint
		swigIntConstant( GL_SGIX_scalebias_hint, "GL_SGIX_scalebias_hint" );
	#endif
	#ifdef GL_SCALEBIAS_HINT_SGIX
		swigIntConstant( GL_SCALEBIAS_HINT_SGIX, "GL_SCALEBIAS_HINT_SGIX" );
	#endif
	#ifdef GL_SGIX_shadow
		swigIntConstant( GL_SGIX_shadow, "GL_SGIX_shadow" );
	#endif
	#ifdef GL_TEXTURE_COMPARE_SGIX
		swigIntConstant( GL_TEXTURE_COMPARE_SGIX, "GL_TEXTURE_COMPARE_SGIX" );
	#endif
	#ifdef GL_TEXTURE_COMPARE_OPERATOR_SGIX
		swigIntConstant( GL_TEXTURE_COMPARE_OPERATOR_SGIX, "GL_TEXTURE_COMPARE_OPERATOR_SGIX" );
	#endif
	#ifdef GL_TEXTURE_LEQUAL_R_SGIX
		swigIntConstant( GL_TEXTURE_LEQUAL_R_SGIX, "GL_TEXTURE_LEQUAL_R_SGIX" );
	#endif
	#ifdef GL_TEXTURE_GEQUAL_R_SGIX
		swigIntConstant( GL_TEXTURE_GEQUAL_R_SGIX, "GL_TEXTURE_GEQUAL_R_SGIX" );
	#endif
	#ifdef GL_SGIX_shadow_ambient
		swigIntConstant( GL_SGIX_shadow_ambient, "GL_SGIX_shadow_ambient" );
	#endif
	#ifdef GL_SHADOW_AMBIENT_SGIX
		swigIntConstant( GL_SHADOW_AMBIENT_SGIX, "GL_SHADOW_AMBIENT_SGIX" );
	#endif
	#ifdef GL_SGIX_sprite
		swigIntConstant( GL_SGIX_sprite, "GL_SGIX_sprite" );
	#endif
	#ifdef GL_SPRITE_SGIX
		swigIntConstant( GL_SPRITE_SGIX, "GL_SPRITE_SGIX" );
	#endif
	#ifdef GL_SPRITE_MODE_SGIX
		swigIntConstant( GL_SPRITE_MODE_SGIX, "GL_SPRITE_MODE_SGIX" );
	#endif
	#ifdef GL_SPRITE_AXIS_SGIX
		swigIntConstant( GL_SPRITE_AXIS_SGIX, "GL_SPRITE_AXIS_SGIX" );
	#endif
	#ifdef GL_SPRITE_TRANSLATION_SGIX
		swigIntConstant( GL_SPRITE_TRANSLATION_SGIX, "GL_SPRITE_TRANSLATION_SGIX" );
	#endif
	#ifdef GL_SPRITE_AXIAL_SGIX
		swigIntConstant( GL_SPRITE_AXIAL_SGIX, "GL_SPRITE_AXIAL_SGIX" );
	#endif
	#ifdef GL_SPRITE_OBJECT_ALIGNED_SGIX
		swigIntConstant( GL_SPRITE_OBJECT_ALIGNED_SGIX, "GL_SPRITE_OBJECT_ALIGNED_SGIX" );
	#endif
	#ifdef GL_SPRITE_EYE_ALIGNED_SGIX
		swigIntConstant( GL_SPRITE_EYE_ALIGNED_SGIX, "GL_SPRITE_EYE_ALIGNED_SGIX" );
	#endif
	#ifdef GL_SGIX_subsample
		swigIntConstant( GL_SGIX_subsample, "GL_SGIX_subsample" );
	#endif
	#ifdef GL_PACK_SUBSAMPLE_RATE_SGIX
		swigIntConstant( GL_PACK_SUBSAMPLE_RATE_SGIX, "GL_PACK_SUBSAMPLE_RATE_SGIX" );
	#endif
	#ifdef GL_UNPACK_SUBSAMPLE_RATE_SGIX
		swigIntConstant( GL_UNPACK_SUBSAMPLE_RATE_SGIX, "GL_UNPACK_SUBSAMPLE_RATE_SGIX" );
	#endif
	#ifdef GL_PIXEL_SUBSAMPLE_4444_SGIX
		swigIntConstant( GL_PIXEL_SUBSAMPLE_4444_SGIX, "GL_PIXEL_SUBSAMPLE_4444_SGIX" );
	#endif
	#ifdef GL_PIXEL_SUBSAMPLE_2424_SGIX
		swigIntConstant( GL_PIXEL_SUBSAMPLE_2424_SGIX, "GL_PIXEL_SUBSAMPLE_2424_SGIX" );
	#endif
	#ifdef GL_PIXEL_SUBSAMPLE_4242_SGIX
		swigIntConstant( GL_PIXEL_SUBSAMPLE_4242_SGIX, "GL_PIXEL_SUBSAMPLE_4242_SGIX" );
	#endif
	#ifdef GL_SGIX_tag_sample_buffer
		swigIntConstant( GL_SGIX_tag_sample_buffer, "GL_SGIX_tag_sample_buffer" );
	#endif
	#ifdef GL_SGIX_texture_add_env
		swigIntConstant( GL_SGIX_texture_add_env, "GL_SGIX_texture_add_env" );
	#endif
	#ifdef GL_TEXTURE_ENV_BIAS_SGIX
		swigIntConstant( GL_TEXTURE_ENV_BIAS_SGIX, "GL_TEXTURE_ENV_BIAS_SGIX" );
	#endif
	#ifdef GL_SGIX_texture_coordinate_clamp
		swigIntConstant( GL_SGIX_texture_coordinate_clamp, "GL_SGIX_texture_coordinate_clamp" );
	#endif
	#ifdef GL_TEXTURE_MAX_CLAMP_S_SGIX
		swigIntConstant( GL_TEXTURE_MAX_CLAMP_S_SGIX, "GL_TEXTURE_MAX_CLAMP_S_SGIX" );
	#endif
	#ifdef GL_TEXTURE_MAX_CLAMP_T_SGIX
		swigIntConstant( GL_TEXTURE_MAX_CLAMP_T_SGIX, "GL_TEXTURE_MAX_CLAMP_T_SGIX" );
	#endif
	#ifdef GL_TEXTURE_MAX_CLAMP_R_SGIX
		swigIntConstant( GL_TEXTURE_MAX_CLAMP_R_SGIX, "GL_TEXTURE_MAX_CLAMP_R_SGIX" );
	#endif
	#ifdef GL_SGIX_texture_lod_bias
		swigIntConstant( GL_SGIX_texture_lod_bias, "GL_SGIX_texture_lod_bias" );
	#endif
	#ifdef GL_TEXTURE_LOD_BIAS_S_SGIX
		swigIntConstant( GL_TEXTURE_LOD_BIAS_S_SGIX, "GL_TEXTURE_LOD_BIAS_S_SGIX" );
	#endif
	#ifdef GL_TEXTURE_LOD_BIAS_T_SGIX
		swigIntConstant( GL_TEXTURE_LOD_BIAS_T_SGIX, "GL_TEXTURE_LOD_BIAS_T_SGIX" );
	#endif
	#ifdef GL_TEXTURE_LOD_BIAS_R_SGIX
		swigIntConstant( GL_TEXTURE_LOD_BIAS_R_SGIX, "GL_TEXTURE_LOD_BIAS_R_SGIX" );
	#endif
	#ifdef GL_SGIX_texture_multi_buffer
		swigIntConstant( GL_SGIX_texture_multi_buffer, "GL_SGIX_texture_multi_buffer" );
	#endif
	#ifdef GL_TEXTURE_MULTI_BUFFER_HINT_SGIX
		swigIntConstant( GL_TEXTURE_MULTI_BUFFER_HINT_SGIX, "GL_TEXTURE_MULTI_BUFFER_HINT_SGIX" );
	#endif
	#ifdef GL_SGIX_texture_scale_bias
		swigIntConstant( GL_SGIX_texture_scale_bias, "GL_SGIX_texture_scale_bias" );
	#endif
	#ifdef GL_POST_TEXTURE_FILTER_BIAS_SGIX
		swigIntConstant( GL_POST_TEXTURE_FILTER_BIAS_SGIX, "GL_POST_TEXTURE_FILTER_BIAS_SGIX" );
	#endif
	#ifdef GL_POST_TEXTURE_FILTER_SCALE_SGIX
		swigIntConstant( GL_POST_TEXTURE_FILTER_SCALE_SGIX, "GL_POST_TEXTURE_FILTER_SCALE_SGIX" );
	#endif
	#ifdef GL_POST_TEXTURE_FILTER_BIAS_RANGE_SGIX
		swigIntConstant( GL_POST_TEXTURE_FILTER_BIAS_RANGE_SGIX, "GL_POST_TEXTURE_FILTER_BIAS_RANGE_SGIX" );
	#endif
	#ifdef GL_POST_TEXTURE_FILTER_SCALE_RANGE_SGIX
		swigIntConstant( GL_POST_TEXTURE_FILTER_SCALE_RANGE_SGIX, "GL_POST_TEXTURE_FILTER_SCALE_RANGE_SGIX" );
	#endif
	#ifdef GL_SGIX_vertex_preclip
		swigIntConstant( GL_SGIX_vertex_preclip, "GL_SGIX_vertex_preclip" );
	#endif
	#ifdef GL_VERTEX_PRECLIP_SGIX
		swigIntConstant( GL_VERTEX_PRECLIP_SGIX, "GL_VERTEX_PRECLIP_SGIX" );
	#endif
	#ifdef GL_VERTEX_PRECLIP_HINT_SGIX
		swigIntConstant( GL_VERTEX_PRECLIP_HINT_SGIX, "GL_VERTEX_PRECLIP_HINT_SGIX" );
	#endif
	#ifdef GL_SGIX_ycrcb
		swigIntConstant( GL_SGIX_ycrcb, "GL_SGIX_ycrcb" );
	#endif
	#ifdef GL_YCRCB_422_SGIX
		swigIntConstant( GL_YCRCB_422_SGIX, "GL_YCRCB_422_SGIX" );
	#endif
	#ifdef GL_YCRCB_444_SGIX
		swigIntConstant( GL_YCRCB_444_SGIX, "GL_YCRCB_444_SGIX" );
	#endif
	#ifdef GL_SGIX_ycrcb_subsample
		swigIntConstant( GL_SGIX_ycrcb_subsample, "GL_SGIX_ycrcb_subsample" );
	#endif
	#ifdef GL_SGIX_ycrcba
		swigIntConstant( GL_SGIX_ycrcba, "GL_SGIX_ycrcba" );
	#endif
	#ifdef GL_YCRCB_SGIX
		swigIntConstant( GL_YCRCB_SGIX, "GL_YCRCB_SGIX" );
	#endif
	#ifdef GL_YCRCBA_SGIX
		swigIntConstant( GL_YCRCBA_SGIX, "GL_YCRCBA_SGIX" );
	#endif
	#ifdef GL_SGI_color_matrix
		swigIntConstant( GL_SGI_color_matrix, "GL_SGI_color_matrix" );
	#endif
	#ifdef GL_COLOR_MATRIX_SGI
		swigIntConstant( GL_COLOR_MATRIX_SGI, "GL_COLOR_MATRIX_SGI" );
	#endif
	#ifdef GL_COLOR_MATRIX_STACK_DEPTH_SGI
		swigIntConstant( GL_COLOR_MATRIX_STACK_DEPTH_SGI, "GL_COLOR_MATRIX_STACK_DEPTH_SGI" );
	#endif
	#ifdef GL_MAX_COLOR_MATRIX_STACK_DEPTH_SGI
		swigIntConstant( GL_MAX_COLOR_MATRIX_STACK_DEPTH_SGI, "GL_MAX_COLOR_MATRIX_STACK_DEPTH_SGI" );
	#endif
	#ifdef GL_POST_COLOR_MATRIX_RED_SCALE_SGI
		swigIntConstant( GL_POST_COLOR_MATRIX_RED_SCALE_SGI, "GL_POST_COLOR_MATRIX_RED_SCALE_SGI" );
	#endif
	#ifdef GL_POST_COLOR_MATRIX_GREEN_SCALE_SGI
		swigIntConstant( GL_POST_COLOR_MATRIX_GREEN_SCALE_SGI, "GL_POST_COLOR_MATRIX_GREEN_SCALE_SGI" );
	#endif
	#ifdef GL_POST_COLOR_MATRIX_BLUE_SCALE_SGI
		swigIntConstant( GL_POST_COLOR_MATRIX_BLUE_SCALE_SGI, "GL_POST_COLOR_MATRIX_BLUE_SCALE_SGI" );
	#endif
	#ifdef GL_POST_COLOR_MATRIX_ALPHA_SCALE_SGI
		swigIntConstant( GL_POST_COLOR_MATRIX_ALPHA_SCALE_SGI, "GL_POST_COLOR_MATRIX_ALPHA_SCALE_SGI" );
	#endif
	#ifdef GL_POST_COLOR_MATRIX_RED_BIAS_SGI
		swigIntConstant( GL_POST_COLOR_MATRIX_RED_BIAS_SGI, "GL_POST_COLOR_MATRIX_RED_BIAS_SGI" );
	#endif
	#ifdef GL_POST_COLOR_MATRIX_GREEN_BIAS_SGI
		swigIntConstant( GL_POST_COLOR_MATRIX_GREEN_BIAS_SGI, "GL_POST_COLOR_MATRIX_GREEN_BIAS_SGI" );
	#endif
	#ifdef GL_POST_COLOR_MATRIX_BLUE_BIAS_SGI
		swigIntConstant( GL_POST_COLOR_MATRIX_BLUE_BIAS_SGI, "GL_POST_COLOR_MATRIX_BLUE_BIAS_SGI" );
	#endif
	#ifdef GL_POST_COLOR_MATRIX_ALPHA_BIAS_SGI
		swigIntConstant( GL_POST_COLOR_MATRIX_ALPHA_BIAS_SGI, "GL_POST_COLOR_MATRIX_ALPHA_BIAS_SGI" );
	#endif
	#ifdef GL_SGI_color_table
		swigIntConstant( GL_SGI_color_table, "GL_SGI_color_table" );
	#endif
	#ifdef GL_COLOR_TABLE_SGI
		swigIntConstant( GL_COLOR_TABLE_SGI, "GL_COLOR_TABLE_SGI" );
	#endif
	#ifdef GL_POST_CONVOLUTION_COLOR_TABLE_SGI
		swigIntConstant( GL_POST_CONVOLUTION_COLOR_TABLE_SGI, "GL_POST_CONVOLUTION_COLOR_TABLE_SGI" );
	#endif
	#ifdef GL_POST_COLOR_MATRIX_COLOR_TABLE_SGI
		swigIntConstant( GL_POST_COLOR_MATRIX_COLOR_TABLE_SGI, "GL_POST_COLOR_MATRIX_COLOR_TABLE_SGI" );
	#endif
	#ifdef GL_PROXY_COLOR_TABLE_SGI
		swigIntConstant( GL_PROXY_COLOR_TABLE_SGI, "GL_PROXY_COLOR_TABLE_SGI" );
	#endif
	#ifdef GL_PROXY_POST_CONVOLUTION_COLOR_TABLE_SGI
		swigIntConstant( GL_PROXY_POST_CONVOLUTION_COLOR_TABLE_SGI, "GL_PROXY_POST_CONVOLUTION_COLOR_TABLE_SGI" );
	#endif
	#ifdef GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE_SGI
		swigIntConstant( GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE_SGI, "GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE_SGI" );
	#endif
	#ifdef GL_COLOR_TABLE_SCALE_SGI
		swigIntConstant( GL_COLOR_TABLE_SCALE_SGI, "GL_COLOR_TABLE_SCALE_SGI" );
	#endif
	#ifdef GL_COLOR_TABLE_BIAS_SGI
		swigIntConstant( GL_COLOR_TABLE_BIAS_SGI, "GL_COLOR_TABLE_BIAS_SGI" );
	#endif
	#ifdef GL_COLOR_TABLE_FORMAT_SGI
		swigIntConstant( GL_COLOR_TABLE_FORMAT_SGI, "GL_COLOR_TABLE_FORMAT_SGI" );
	#endif
	#ifdef GL_COLOR_TABLE_WIDTH_SGI
		swigIntConstant( GL_COLOR_TABLE_WIDTH_SGI, "GL_COLOR_TABLE_WIDTH_SGI" );
	#endif
	#ifdef GL_COLOR_TABLE_RED_SIZE_SGI
		swigIntConstant( GL_COLOR_TABLE_RED_SIZE_SGI, "GL_COLOR_TABLE_RED_SIZE_SGI" );
	#endif
	#ifdef GL_COLOR_TABLE_GREEN_SIZE_SGI
		swigIntConstant( GL_COLOR_TABLE_GREEN_SIZE_SGI, "GL_COLOR_TABLE_GREEN_SIZE_SGI" );
	#endif
	#ifdef GL_COLOR_TABLE_BLUE_SIZE_SGI
		swigIntConstant( GL_COLOR_TABLE_BLUE_SIZE_SGI, "GL_COLOR_TABLE_BLUE_SIZE_SGI" );
	#endif
	#ifdef GL_COLOR_TABLE_ALPHA_SIZE_SGI
		swigIntConstant( GL_COLOR_TABLE_ALPHA_SIZE_SGI, "GL_COLOR_TABLE_ALPHA_SIZE_SGI" );
	#endif
	#ifdef GL_COLOR_TABLE_LUMINANCE_SIZE_SGI
		swigIntConstant( GL_COLOR_TABLE_LUMINANCE_SIZE_SGI, "GL_COLOR_TABLE_LUMINANCE_SIZE_SGI" );
	#endif
	#ifdef GL_COLOR_TABLE_INTENSITY_SIZE_SGI
		swigIntConstant( GL_COLOR_TABLE_INTENSITY_SIZE_SGI, "GL_COLOR_TABLE_INTENSITY_SIZE_SGI" );
	#endif
	#ifdef GL_SGI_texture_color_table
		swigIntConstant( GL_SGI_texture_color_table, "GL_SGI_texture_color_table" );
	#endif
	#ifdef GL_TEXTURE_COLOR_TABLE_SGI
		swigIntConstant( GL_TEXTURE_COLOR_TABLE_SGI, "GL_TEXTURE_COLOR_TABLE_SGI" );
	#endif
	#ifdef GL_PROXY_TEXTURE_COLOR_TABLE_SGI
		swigIntConstant( GL_PROXY_TEXTURE_COLOR_TABLE_SGI, "GL_PROXY_TEXTURE_COLOR_TABLE_SGI" );
	#endif
	#ifdef GL_SUNX_constant_data
		swigIntConstant( GL_SUNX_constant_data, "GL_SUNX_constant_data" );
	#endif
	#ifdef GL_UNPACK_CONSTANT_DATA_SUNX
		swigIntConstant( GL_UNPACK_CONSTANT_DATA_SUNX, "GL_UNPACK_CONSTANT_DATA_SUNX" );
	#endif
	#ifdef GL_TEXTURE_CONSTANT_DATA_SUNX
		swigIntConstant( GL_TEXTURE_CONSTANT_DATA_SUNX, "GL_TEXTURE_CONSTANT_DATA_SUNX" );
	#endif
	#ifdef GL_SUN_convolution_border_modes
		swigIntConstant( GL_SUN_convolution_border_modes, "GL_SUN_convolution_border_modes" );
	#endif
	#ifdef GL_WRAP_BORDER_SUN
		swigIntConstant( GL_WRAP_BORDER_SUN, "GL_WRAP_BORDER_SUN" );
	#endif
	#ifdef GL_SUN_global_alpha
		swigIntConstant( GL_SUN_global_alpha, "GL_SUN_global_alpha" );
	#endif
	#ifdef GL_GLOBAL_ALPHA_SUN
		swigIntConstant( GL_GLOBAL_ALPHA_SUN, "GL_GLOBAL_ALPHA_SUN" );
	#endif
	#ifdef GL_GLOBAL_ALPHA_FACTOR_SUN
		swigIntConstant( GL_GLOBAL_ALPHA_FACTOR_SUN, "GL_GLOBAL_ALPHA_FACTOR_SUN" );
	#endif
	#ifdef GL_SUN_mesh_array
		swigIntConstant( GL_SUN_mesh_array, "GL_SUN_mesh_array" );
	#endif
	#ifdef GL_QUAD_MESH_SUN
		swigIntConstant( GL_QUAD_MESH_SUN, "GL_QUAD_MESH_SUN" );
	#endif
	#ifdef GL_TRIANGLE_MESH_SUN
		swigIntConstant( GL_TRIANGLE_MESH_SUN, "GL_TRIANGLE_MESH_SUN" );
	#endif
	#ifdef GL_SUN_slice_accum
		swigIntConstant( GL_SUN_slice_accum, "GL_SUN_slice_accum" );
	#endif
	#ifdef GL_SLICE_ACCUM_SUN
		swigIntConstant( GL_SLICE_ACCUM_SUN, "GL_SLICE_ACCUM_SUN" );
	#endif
	#ifdef GL_SUN_triangle_list
		swigIntConstant( GL_SUN_triangle_list, "GL_SUN_triangle_list" );
	#endif
	#ifdef GL_RESTART_SUN
		swigIntConstant( GL_RESTART_SUN, "GL_RESTART_SUN" );
	#endif
	#ifdef GL_REPLACE_MIDDLE_SUN
		swigIntConstant( GL_REPLACE_MIDDLE_SUN, "GL_REPLACE_MIDDLE_SUN" );
	#endif
	#ifdef GL_REPLACE_OLDEST_SUN
		swigIntConstant( GL_REPLACE_OLDEST_SUN, "GL_REPLACE_OLDEST_SUN" );
	#endif
	#ifdef GL_TRIANGLE_LIST_SUN
		swigIntConstant( GL_TRIANGLE_LIST_SUN, "GL_TRIANGLE_LIST_SUN" );
	#endif
	#ifdef GL_REPLACEMENT_CODE_SUN
		swigIntConstant( GL_REPLACEMENT_CODE_SUN, "GL_REPLACEMENT_CODE_SUN" );
	#endif
	#ifdef GL_REPLACEMENT_CODE_ARRAY_SUN
		swigIntConstant( GL_REPLACEMENT_CODE_ARRAY_SUN, "GL_REPLACEMENT_CODE_ARRAY_SUN" );
	#endif
	#ifdef GL_REPLACEMENT_CODE_ARRAY_TYPE_SUN
		swigIntConstant( GL_REPLACEMENT_CODE_ARRAY_TYPE_SUN, "GL_REPLACEMENT_CODE_ARRAY_TYPE_SUN" );
	#endif
	#ifdef GL_REPLACEMENT_CODE_ARRAY_STRIDE_SUN
		swigIntConstant( GL_REPLACEMENT_CODE_ARRAY_STRIDE_SUN, "GL_REPLACEMENT_CODE_ARRAY_STRIDE_SUN" );
	#endif
	#ifdef GL_REPLACEMENT_CODE_ARRAY_POINTER_SUN
		swigIntConstant( GL_REPLACEMENT_CODE_ARRAY_POINTER_SUN, "GL_REPLACEMENT_CODE_ARRAY_POINTER_SUN" );
	#endif
	#ifdef GL_R1UI_V3F_SUN
		swigIntConstant( GL_R1UI_V3F_SUN, "GL_R1UI_V3F_SUN" );
	#endif
	#ifdef GL_R1UI_C4UB_V3F_SUN
		swigIntConstant( GL_R1UI_C4UB_V3F_SUN, "GL_R1UI_C4UB_V3F_SUN" );
	#endif
	#ifdef GL_R1UI_C3F_V3F_SUN
		swigIntConstant( GL_R1UI_C3F_V3F_SUN, "GL_R1UI_C3F_V3F_SUN" );
	#endif
	#ifdef GL_R1UI_N3F_V3F_SUN
		swigIntConstant( GL_R1UI_N3F_V3F_SUN, "GL_R1UI_N3F_V3F_SUN" );
	#endif
	#ifdef GL_R1UI_C4F_N3F_V3F_SUN
		swigIntConstant( GL_R1UI_C4F_N3F_V3F_SUN, "GL_R1UI_C4F_N3F_V3F_SUN" );
	#endif
	#ifdef GL_R1UI_T2F_V3F_SUN
		swigIntConstant( GL_R1UI_T2F_V3F_SUN, "GL_R1UI_T2F_V3F_SUN" );
	#endif
	#ifdef GL_R1UI_T2F_N3F_V3F_SUN
		swigIntConstant( GL_R1UI_T2F_N3F_V3F_SUN, "GL_R1UI_T2F_N3F_V3F_SUN" );
	#endif
	#ifdef GL_R1UI_T2F_C4F_N3F_V3F_SUN
		swigIntConstant( GL_R1UI_T2F_C4F_N3F_V3F_SUN, "GL_R1UI_T2F_C4F_N3F_V3F_SUN" );
	#endif
	#ifdef GL_SUN_vertex
		swigIntConstant( GL_SUN_vertex, "GL_SUN_vertex" );
	#endif
	#ifdef GL_WIN_phong_shading
		swigIntConstant( GL_WIN_phong_shading, "GL_WIN_phong_shading" );
	#endif
	#ifdef GL_PHONG_WIN
		swigIntConstant( GL_PHONG_WIN, "GL_PHONG_WIN" );
	#endif
	#ifdef GL_PHONG_HINT_WIN
		swigIntConstant( GL_PHONG_HINT_WIN, "GL_PHONG_HINT_WIN" );
	#endif
	#ifdef GL_WIN_specular_fog
		swigIntConstant( GL_WIN_specular_fog, "GL_WIN_specular_fog" );
	#endif
	#ifdef GL_FOG_SPECULAR_TEXTURE_WIN
		swigIntConstant( GL_FOG_SPECULAR_TEXTURE_WIN, "GL_FOG_SPECULAR_TEXTURE_WIN" );
	#endif

	swigNewline();

	swigComment("----===< long constants >===-----\n");
	#ifdef GL_TIMEOUT_IGNORED
		swigUnsignedLongConstant( GL_TIMEOUT_IGNORED, "GL_TIMEOUT_IGNORED" );
	#endif

	swigNewline();

	swigComment("------===< functions >===-------\n");
	swigFunction( "c-function glClearIndex glClearIndex r -- void", "FUNCTION: glClearIndex ( c -- void )", "EXTERN: \"C\" void glClearIndex( float c );", "	( c -- )" );
	swigFunction( "c-function glClearColor glClearColor r r r r -- void", "FUNCTION: glClearColor ( red green blue alpha -- void )", "EXTERN: \"C\" void glClearColor( float red, float green, float blue, float alpha );", "	( red green blue alpha -- )" );
	swigFunction( "c-function glClear glClear u -- void", "FUNCTION: glClear ( mask -- void )", "EXTERN: \"C\" void glClear( int mask );", "	( mask -- )" );
	swigFunction( "c-function glIndexMask glIndexMask u -- void", "FUNCTION: glIndexMask ( mask -- void )", "EXTERN: \"C\" void glIndexMask( int mask );", "	( mask -- )" );
	swigFunction( "c-function glColorMask glColorMask u u u u -- void", "FUNCTION: glColorMask ( red green blue alpha -- void )", "EXTERN: \"C\" void glColorMask( char red, char green, char blue, char alpha );", "	( red green blue alpha -- )" );
	swigFunction( "c-function glAlphaFunc glAlphaFunc u r -- void", "FUNCTION: glAlphaFunc ( func ref -- void )", "EXTERN: \"C\" void glAlphaFunc( int func, float ref );", "	( func ref -- )" );
	swigFunction( "c-function glBlendFunc glBlendFunc u u -- void", "FUNCTION: glBlendFunc ( sfactor dfactor -- void )", "EXTERN: \"C\" void glBlendFunc( int sfactor, int dfactor );", "	( sfactor dfactor -- )" );
	swigFunction( "c-function glLogicOp glLogicOp u -- void", "FUNCTION: glLogicOp ( opcode -- void )", "EXTERN: \"C\" void glLogicOp( int opcode );", "	( opcode -- )" );
	swigFunction( "c-function glCullFace glCullFace u -- void", "FUNCTION: glCullFace ( mode -- void )", "EXTERN: \"C\" void glCullFace( int mode );", "	( mode -- )" );
	swigFunction( "c-function glFrontFace glFrontFace u -- void", "FUNCTION: glFrontFace ( mode -- void )", "EXTERN: \"C\" void glFrontFace( int mode );", "	( mode -- )" );
	swigFunction( "c-function glPointSize glPointSize r -- void", "FUNCTION: glPointSize ( size -- void )", "EXTERN: \"C\" void glPointSize( float size );", "	( size -- )" );
	swigFunction( "c-function glLineWidth glLineWidth r -- void", "FUNCTION: glLineWidth ( width -- void )", "EXTERN: \"C\" void glLineWidth( float width );", "	( width -- )" );
	swigFunction( "c-function glLineStipple glLineStipple n u -- void", "FUNCTION: glLineStipple ( factor pattern -- void )", "EXTERN: \"C\" void glLineStipple( int factor, short pattern );", "	( factor pattern -- )" );
	swigFunction( "c-function glPolygonMode glPolygonMode u u -- void", "FUNCTION: glPolygonMode ( face mode -- void )", "EXTERN: \"C\" void glPolygonMode( int face, int mode );", "	( face mode -- )" );
	swigFunction( "c-function glPolygonOffset glPolygonOffset r r -- void", "FUNCTION: glPolygonOffset ( factor units -- void )", "EXTERN: \"C\" void glPolygonOffset( float factor, float units );", "	( factor units -- )" );
	swigFunction( "c-function glPolygonStipple glPolygonStipple a -- void", "FUNCTION: glPolygonStipple ( mask -- void )", "EXTERN: \"C\" void glPolygonStipple( void * mask );", "	( mask -- )" );
	swigFunction( "c-function glGetPolygonStipple glGetPolygonStipple a -- void", "FUNCTION: glGetPolygonStipple ( mask -- void )", "EXTERN: \"C\" void glGetPolygonStipple( void * mask );", "	( mask -- )" );
	swigFunction( "c-function glEdgeFlag glEdgeFlag u -- void", "FUNCTION: glEdgeFlag ( flag -- void )", "EXTERN: \"C\" void glEdgeFlag( char flag );", "	( flag -- )" );
	swigFunction( "c-function glEdgeFlagv glEdgeFlagv a -- void", "FUNCTION: glEdgeFlagv ( flag -- void )", "EXTERN: \"C\" void glEdgeFlagv( void * flag );", "	( flag -- )" );
	swigFunction( "c-function glScissor glScissor n n n n -- void", "FUNCTION: glScissor ( x y width height -- void )", "EXTERN: \"C\" void glScissor( int x, int y, int width, int height );", "	( x y width height -- )" );
	swigFunction( "c-function glClipPlane glClipPlane u a -- void", "FUNCTION: glClipPlane ( plane equation -- void )", "EXTERN: \"C\" void glClipPlane( int plane, void * equation );", "	( plane equation -- )" );
	swigFunction( "c-function glGetClipPlane glGetClipPlane u a -- void", "FUNCTION: glGetClipPlane ( plane equation -- void )", "EXTERN: \"C\" void glGetClipPlane( int plane, void * equation );", "	( plane equation -- )" );
	swigFunction( "c-function glDrawBuffer glDrawBuffer u -- void", "FUNCTION: glDrawBuffer ( mode -- void )", "EXTERN: \"C\" void glDrawBuffer( int mode );", "	( mode -- )" );
	swigFunction( "c-function glReadBuffer glReadBuffer u -- void", "FUNCTION: glReadBuffer ( mode -- void )", "EXTERN: \"C\" void glReadBuffer( int mode );", "	( mode -- )" );
	swigFunction( "c-function glEnable glEnable u -- void", "FUNCTION: glEnable ( cap -- void )", "EXTERN: \"C\" void glEnable( int cap );", "	( cap -- )" );
	swigFunction( "c-function glDisable glDisable u -- void", "FUNCTION: glDisable ( cap -- void )", "EXTERN: \"C\" void glDisable( int cap );", "	( cap -- )" );
	swigFunction( "c-function glIsEnabled glIsEnabled u -- u", "FUNCTION: glIsEnabled ( cap -- u )", "EXTERN: \"C\" char glIsEnabled( int cap );", "	( cap -- )" );
	swigFunction( "c-function glEnableClientState glEnableClientState u -- void", "FUNCTION: glEnableClientState ( cap -- void )", "EXTERN: \"C\" void glEnableClientState( int cap );", "	( cap -- )" );
	swigFunction( "c-function glDisableClientState glDisableClientState u -- void", "FUNCTION: glDisableClientState ( cap -- void )", "EXTERN: \"C\" void glDisableClientState( int cap );", "	( cap -- )" );
	swigFunction( "c-function glGetBooleanv glGetBooleanv u a -- void", "FUNCTION: glGetBooleanv ( pname params -- void )", "EXTERN: \"C\" void glGetBooleanv( int pname, void * params );", "	( pname params -- )" );
	swigFunction( "c-function glGetDoublev glGetDoublev u a -- void", "FUNCTION: glGetDoublev ( pname params -- void )", "EXTERN: \"C\" void glGetDoublev( int pname, void * params );", "	( pname params -- )" );
	swigFunction( "c-function glGetFloatv glGetFloatv u a -- void", "FUNCTION: glGetFloatv ( pname params -- void )", "EXTERN: \"C\" void glGetFloatv( int pname, void * params );", "	( pname params -- )" );
	swigFunction( "c-function glGetIntegerv glGetIntegerv u a -- void", "FUNCTION: glGetIntegerv ( pname params -- void )", "EXTERN: \"C\" void glGetIntegerv( int pname, void * params );", "	( pname params -- )" );
	swigFunction( "c-function glPushAttrib glPushAttrib u -- void", "FUNCTION: glPushAttrib ( mask -- void )", "EXTERN: \"C\" void glPushAttrib( int mask );", "	( mask -- )" );
	swigFunction( "c-function glPopAttrib glPopAttrib  -- void", "FUNCTION: glPopAttrib (  -- void )", "EXTERN: \"C\" void glPopAttrib(  );", "	( -- )" );
	swigFunction( "c-function glPushClientAttrib glPushClientAttrib u -- void", "FUNCTION: glPushClientAttrib ( mask -- void )", "EXTERN: \"C\" void glPushClientAttrib( int mask );", "	( mask -- )" );
	swigFunction( "c-function glPopClientAttrib glPopClientAttrib  -- void", "FUNCTION: glPopClientAttrib (  -- void )", "EXTERN: \"C\" void glPopClientAttrib(  );", "	( -- )" );
	swigFunction( "c-function glRenderMode glRenderMode u -- n", "FUNCTION: glRenderMode ( mode -- n )", "EXTERN: \"C\" int glRenderMode( int mode );", "	( mode -- )" );
	swigFunction( "c-function glGetError glGetError  -- u", "FUNCTION: glGetError (  -- u )", "EXTERN: \"C\" int glGetError(  );", "	( -- )" );
	swigFunction( "c-function glGetString glGetString u -- a", "FUNCTION: glGetString ( name -- a )", "EXTERN: \"C\" void * glGetString( int name );", "	( name -- )" );
	swigFunction( "c-function glFinish glFinish  -- void", "FUNCTION: glFinish (  -- void )", "EXTERN: \"C\" void glFinish(  );", "	( -- )" );
	swigFunction( "c-function glFlush glFlush  -- void", "FUNCTION: glFlush (  -- void )", "EXTERN: \"C\" void glFlush(  );", "	( -- )" );
	swigFunction( "c-function glHint glHint u u -- void", "FUNCTION: glHint ( target mode -- void )", "EXTERN: \"C\" void glHint( int target, int mode );", "	( target mode -- )" );
	swigFunction( "c-function glClearDepth glClearDepth r -- void", "FUNCTION: glClearDepth ( depth -- void )", "EXTERN: \"C\" void glClearDepth( double depth );", "	( depth -- )" );
	swigFunction( "c-function glDepthFunc glDepthFunc u -- void", "FUNCTION: glDepthFunc ( func -- void )", "EXTERN: \"C\" void glDepthFunc( int func );", "	( func -- )" );
	swigFunction( "c-function glDepthMask glDepthMask u -- void", "FUNCTION: glDepthMask ( flag -- void )", "EXTERN: \"C\" void glDepthMask( char flag );", "	( flag -- )" );
	swigFunction( "c-function glDepthRange glDepthRange r r -- void", "FUNCTION: glDepthRange ( near_val far_val -- void )", "EXTERN: \"C\" void glDepthRange( double near_val, double far_val );", "	( near_val far_val -- )" );
	swigFunction( "c-function glClearAccum glClearAccum r r r r -- void", "FUNCTION: glClearAccum ( red green blue alpha -- void )", "EXTERN: \"C\" void glClearAccum( float red, float green, float blue, float alpha );", "	( red green blue alpha -- )" );
	swigFunction( "c-function glAccum glAccum u r -- void", "FUNCTION: glAccum ( op value -- void )", "EXTERN: \"C\" void glAccum( int op, float value );", "	( op value -- )" );
	swigFunction( "c-function glMatrixMode glMatrixMode u -- void", "FUNCTION: glMatrixMode ( mode -- void )", "EXTERN: \"C\" void glMatrixMode( int mode );", "	( mode -- )" );
	swigFunction( "c-function glOrtho glOrtho r r r r r r -- void", "FUNCTION: glOrtho ( left right bottom top near_val far_val -- void )", "EXTERN: \"C\" void glOrtho( double left, double right, double bottom, double top, double near_val, double far_val );", "	( left right bottom top near_val far_val -- )" );
	swigFunction( "c-function glFrustum glFrustum r r r r r r -- void", "FUNCTION: glFrustum ( left right bottom top near_val far_val -- void )", "EXTERN: \"C\" void glFrustum( double left, double right, double bottom, double top, double near_val, double far_val );", "	( left right bottom top near_val far_val -- )" );
	swigFunction( "c-function glViewport glViewport n n n n -- void", "FUNCTION: glViewport ( x y width height -- void )", "EXTERN: \"C\" void glViewport( int x, int y, int width, int height );", "	( x y width height -- )" );
	swigFunction( "c-function glPushMatrix glPushMatrix  -- void", "FUNCTION: glPushMatrix (  -- void )", "EXTERN: \"C\" void glPushMatrix(  );", "	( -- )" );
	swigFunction( "c-function glPopMatrix glPopMatrix  -- void", "FUNCTION: glPopMatrix (  -- void )", "EXTERN: \"C\" void glPopMatrix(  );", "	( -- )" );
	swigFunction( "c-function glLoadIdentity glLoadIdentity  -- void", "FUNCTION: glLoadIdentity (  -- void )", "EXTERN: \"C\" void glLoadIdentity(  );", "	( -- )" );
	swigFunction( "c-function glLoadMatrixd glLoadMatrixd a -- void", "FUNCTION: glLoadMatrixd ( m -- void )", "EXTERN: \"C\" void glLoadMatrixd( void * m );", "	( m -- )" );
	swigFunction( "c-function glLoadMatrixf glLoadMatrixf a -- void", "FUNCTION: glLoadMatrixf ( m -- void )", "EXTERN: \"C\" void glLoadMatrixf( void * m );", "	( m -- )" );
	swigFunction( "c-function glMultMatrixd glMultMatrixd a -- void", "FUNCTION: glMultMatrixd ( m -- void )", "EXTERN: \"C\" void glMultMatrixd( void * m );", "	( m -- )" );
	swigFunction( "c-function glMultMatrixf glMultMatrixf a -- void", "FUNCTION: glMultMatrixf ( m -- void )", "EXTERN: \"C\" void glMultMatrixf( void * m );", "	( m -- )" );
	swigFunction( "c-function glRotated glRotated r r r r -- void", "FUNCTION: glRotated ( angle x y z -- void )", "EXTERN: \"C\" void glRotated( double angle, double x, double y, double z );", "	( angle x y z -- )" );
	swigFunction( "c-function glRotatef glRotatef r r r r -- void", "FUNCTION: glRotatef ( angle x y z -- void )", "EXTERN: \"C\" void glRotatef( float angle, float x, float y, float z );", "	( angle x y z -- )" );
	swigFunction( "c-function glScaled glScaled r r r -- void", "FUNCTION: glScaled ( x y z -- void )", "EXTERN: \"C\" void glScaled( double x, double y, double z );", "	( x y z -- )" );
	swigFunction( "c-function glScalef glScalef r r r -- void", "FUNCTION: glScalef ( x y z -- void )", "EXTERN: \"C\" void glScalef( float x, float y, float z );", "	( x y z -- )" );
	swigFunction( "c-function glTranslated glTranslated r r r -- void", "FUNCTION: glTranslated ( x y z -- void )", "EXTERN: \"C\" void glTranslated( double x, double y, double z );", "	( x y z -- )" );
	swigFunction( "c-function glTranslatef glTranslatef r r r -- void", "FUNCTION: glTranslatef ( x y z -- void )", "EXTERN: \"C\" void glTranslatef( float x, float y, float z );", "	( x y z -- )" );
	swigFunction( "c-function glIsList glIsList u -- u", "FUNCTION: glIsList ( list -- u )", "EXTERN: \"C\" char glIsList( int list );", "	( list -- )" );
	swigFunction( "c-function glDeleteLists glDeleteLists u n -- void", "FUNCTION: glDeleteLists ( list range -- void )", "EXTERN: \"C\" void glDeleteLists( int list, int range );", "	( list range -- )" );
	swigFunction( "c-function glGenLists glGenLists n -- u", "FUNCTION: glGenLists ( range -- u )", "EXTERN: \"C\" int glGenLists( int range );", "	( range -- )" );
	swigFunction( "c-function glNewList glNewList u u -- void", "FUNCTION: glNewList ( list mode -- void )", "EXTERN: \"C\" void glNewList( int list, int mode );", "	( list mode -- )" );
	swigFunction( "c-function glEndList glEndList  -- void", "FUNCTION: glEndList (  -- void )", "EXTERN: \"C\" void glEndList(  );", "	( -- )" );
	swigFunction( "c-function glCallList glCallList u -- void", "FUNCTION: glCallList ( list -- void )", "EXTERN: \"C\" void glCallList( int list );", "	( list -- )" );
	swigFunction( "c-function glCallLists glCallLists n u a -- void", "FUNCTION: glCallLists ( n type lists -- void )", "EXTERN: \"C\" void glCallLists( int n, int type, void * lists );", "	( n type lists -- )" );
	swigFunction( "c-function glListBase glListBase u -- void", "FUNCTION: glListBase ( base -- void )", "EXTERN: \"C\" void glListBase( int base );", "	( base -- )" );
	swigFunction( "c-function glBegin glBegin u -- void", "FUNCTION: glBegin ( mode -- void )", "EXTERN: \"C\" void glBegin( int mode );", "	( mode -- )" );
	swigFunction( "c-function glEnd glEnd  -- void", "FUNCTION: glEnd (  -- void )", "EXTERN: \"C\" void glEnd(  );", "	( -- )" );
	swigFunction( "c-function glVertex2d glVertex2d r r -- void", "FUNCTION: glVertex2d ( x y -- void )", "EXTERN: \"C\" void glVertex2d( double x, double y );", "	( x y -- )" );
	swigFunction( "c-function glVertex2f glVertex2f r r -- void", "FUNCTION: glVertex2f ( x y -- void )", "EXTERN: \"C\" void glVertex2f( float x, float y );", "	( x y -- )" );
	swigFunction( "c-function glVertex2i glVertex2i n n -- void", "FUNCTION: glVertex2i ( x y -- void )", "EXTERN: \"C\" void glVertex2i( int x, int y );", "	( x y -- )" );
	swigFunction( "c-function glVertex2s glVertex2s n n -- void", "FUNCTION: glVertex2s ( x y -- void )", "EXTERN: \"C\" void glVertex2s( short x, short y );", "	( x y -- )" );
	swigFunction( "c-function glVertex3d glVertex3d r r r -- void", "FUNCTION: glVertex3d ( x y z -- void )", "EXTERN: \"C\" void glVertex3d( double x, double y, double z );", "	( x y z -- )" );
	swigFunction( "c-function glVertex3f glVertex3f r r r -- void", "FUNCTION: glVertex3f ( x y z -- void )", "EXTERN: \"C\" void glVertex3f( float x, float y, float z );", "	( x y z -- )" );
	swigFunction( "c-function glVertex3i glVertex3i n n n -- void", "FUNCTION: glVertex3i ( x y z -- void )", "EXTERN: \"C\" void glVertex3i( int x, int y, int z );", "	( x y z -- )" );
	swigFunction( "c-function glVertex3s glVertex3s n n n -- void", "FUNCTION: glVertex3s ( x y z -- void )", "EXTERN: \"C\" void glVertex3s( short x, short y, short z );", "	( x y z -- )" );
	swigFunction( "c-function glVertex4d glVertex4d r r r r -- void", "FUNCTION: glVertex4d ( x y z w -- void )", "EXTERN: \"C\" void glVertex4d( double x, double y, double z, double w );", "	( x y z w -- )" );
	swigFunction( "c-function glVertex4f glVertex4f r r r r -- void", "FUNCTION: glVertex4f ( x y z w -- void )", "EXTERN: \"C\" void glVertex4f( float x, float y, float z, float w );", "	( x y z w -- )" );
	swigFunction( "c-function glVertex4i glVertex4i n n n n -- void", "FUNCTION: glVertex4i ( x y z w -- void )", "EXTERN: \"C\" void glVertex4i( int x, int y, int z, int w );", "	( x y z w -- )" );
	swigFunction( "c-function glVertex4s glVertex4s n n n n -- void", "FUNCTION: glVertex4s ( x y z w -- void )", "EXTERN: \"C\" void glVertex4s( short x, short y, short z, short w );", "	( x y z w -- )" );
	swigFunction( "c-function glVertex2dv glVertex2dv a -- void", "FUNCTION: glVertex2dv ( v -- void )", "EXTERN: \"C\" void glVertex2dv( void * v );", "	( v -- )" );
	swigFunction( "c-function glVertex2fv glVertex2fv a -- void", "FUNCTION: glVertex2fv ( v -- void )", "EXTERN: \"C\" void glVertex2fv( void * v );", "	( v -- )" );
	swigFunction( "c-function glVertex2iv glVertex2iv a -- void", "FUNCTION: glVertex2iv ( v -- void )", "EXTERN: \"C\" void glVertex2iv( void * v );", "	( v -- )" );
	swigFunction( "c-function glVertex2sv glVertex2sv a -- void", "FUNCTION: glVertex2sv ( v -- void )", "EXTERN: \"C\" void glVertex2sv( void * v );", "	( v -- )" );
	swigFunction( "c-function glVertex3dv glVertex3dv a -- void", "FUNCTION: glVertex3dv ( v -- void )", "EXTERN: \"C\" void glVertex3dv( void * v );", "	( v -- )" );
	swigFunction( "c-function glVertex3fv glVertex3fv a -- void", "FUNCTION: glVertex3fv ( v -- void )", "EXTERN: \"C\" void glVertex3fv( void * v );", "	( v -- )" );
	swigFunction( "c-function glVertex3iv glVertex3iv a -- void", "FUNCTION: glVertex3iv ( v -- void )", "EXTERN: \"C\" void glVertex3iv( void * v );", "	( v -- )" );
	swigFunction( "c-function glVertex3sv glVertex3sv a -- void", "FUNCTION: glVertex3sv ( v -- void )", "EXTERN: \"C\" void glVertex3sv( void * v );", "	( v -- )" );
	swigFunction( "c-function glVertex4dv glVertex4dv a -- void", "FUNCTION: glVertex4dv ( v -- void )", "EXTERN: \"C\" void glVertex4dv( void * v );", "	( v -- )" );
	swigFunction( "c-function glVertex4fv glVertex4fv a -- void", "FUNCTION: glVertex4fv ( v -- void )", "EXTERN: \"C\" void glVertex4fv( void * v );", "	( v -- )" );
	swigFunction( "c-function glVertex4iv glVertex4iv a -- void", "FUNCTION: glVertex4iv ( v -- void )", "EXTERN: \"C\" void glVertex4iv( void * v );", "	( v -- )" );
	swigFunction( "c-function glVertex4sv glVertex4sv a -- void", "FUNCTION: glVertex4sv ( v -- void )", "EXTERN: \"C\" void glVertex4sv( void * v );", "	( v -- )" );
	swigFunction( "c-function glNormal3b glNormal3b n n n -- void", "FUNCTION: glNormal3b ( nx ny nz -- void )", "EXTERN: \"C\" void glNormal3b( char nx, char ny, char nz );", "	( nx ny nz -- )" );
	swigFunction( "c-function glNormal3d glNormal3d r r r -- void", "FUNCTION: glNormal3d ( nx ny nz -- void )", "EXTERN: \"C\" void glNormal3d( double nx, double ny, double nz );", "	( nx ny nz -- )" );
	swigFunction( "c-function glNormal3f glNormal3f r r r -- void", "FUNCTION: glNormal3f ( nx ny nz -- void )", "EXTERN: \"C\" void glNormal3f( float nx, float ny, float nz );", "	( nx ny nz -- )" );
	swigFunction( "c-function glNormal3i glNormal3i n n n -- void", "FUNCTION: glNormal3i ( nx ny nz -- void )", "EXTERN: \"C\" void glNormal3i( int nx, int ny, int nz );", "	( nx ny nz -- )" );
	swigFunction( "c-function glNormal3s glNormal3s n n n -- void", "FUNCTION: glNormal3s ( nx ny nz -- void )", "EXTERN: \"C\" void glNormal3s( short nx, short ny, short nz );", "	( nx ny nz -- )" );
	swigFunction( "c-function glNormal3bv glNormal3bv a -- void", "FUNCTION: glNormal3bv ( v -- void )", "EXTERN: \"C\" void glNormal3bv( void * v );", "	( v -- )" );
	swigFunction( "c-function glNormal3dv glNormal3dv a -- void", "FUNCTION: glNormal3dv ( v -- void )", "EXTERN: \"C\" void glNormal3dv( void * v );", "	( v -- )" );
	swigFunction( "c-function glNormal3fv glNormal3fv a -- void", "FUNCTION: glNormal3fv ( v -- void )", "EXTERN: \"C\" void glNormal3fv( void * v );", "	( v -- )" );
	swigFunction( "c-function glNormal3iv glNormal3iv a -- void", "FUNCTION: glNormal3iv ( v -- void )", "EXTERN: \"C\" void glNormal3iv( void * v );", "	( v -- )" );
	swigFunction( "c-function glNormal3sv glNormal3sv a -- void", "FUNCTION: glNormal3sv ( v -- void )", "EXTERN: \"C\" void glNormal3sv( void * v );", "	( v -- )" );
	swigFunction( "c-function glIndexd glIndexd r -- void", "FUNCTION: glIndexd ( c -- void )", "EXTERN: \"C\" void glIndexd( double c );", "	( c -- )" );
	swigFunction( "c-function glIndexf glIndexf r -- void", "FUNCTION: glIndexf ( c -- void )", "EXTERN: \"C\" void glIndexf( float c );", "	( c -- )" );
	swigFunction( "c-function glIndexi glIndexi n -- void", "FUNCTION: glIndexi ( c -- void )", "EXTERN: \"C\" void glIndexi( int c );", "	( c -- )" );
	swigFunction( "c-function glIndexs glIndexs n -- void", "FUNCTION: glIndexs ( c -- void )", "EXTERN: \"C\" void glIndexs( short c );", "	( c -- )" );
	swigFunction( "c-function glIndexub glIndexub u -- void", "FUNCTION: glIndexub ( c -- void )", "EXTERN: \"C\" void glIndexub( char c );", "	( c -- )" );
	swigFunction( "c-function glIndexdv glIndexdv a -- void", "FUNCTION: glIndexdv ( c -- void )", "EXTERN: \"C\" void glIndexdv( void * c );", "	( c -- )" );
	swigFunction( "c-function glIndexfv glIndexfv a -- void", "FUNCTION: glIndexfv ( c -- void )", "EXTERN: \"C\" void glIndexfv( void * c );", "	( c -- )" );
	swigFunction( "c-function glIndexiv glIndexiv a -- void", "FUNCTION: glIndexiv ( c -- void )", "EXTERN: \"C\" void glIndexiv( void * c );", "	( c -- )" );
	swigFunction( "c-function glIndexsv glIndexsv a -- void", "FUNCTION: glIndexsv ( c -- void )", "EXTERN: \"C\" void glIndexsv( void * c );", "	( c -- )" );
	swigFunction( "c-function glIndexubv glIndexubv a -- void", "FUNCTION: glIndexubv ( c -- void )", "EXTERN: \"C\" void glIndexubv( void * c );", "	( c -- )" );
	swigFunction( "c-function glColor3b glColor3b n n n -- void", "FUNCTION: glColor3b ( red green blue -- void )", "EXTERN: \"C\" void glColor3b( char red, char green, char blue );", "	( red green blue -- )" );
	swigFunction( "c-function glColor3d glColor3d r r r -- void", "FUNCTION: glColor3d ( red green blue -- void )", "EXTERN: \"C\" void glColor3d( double red, double green, double blue );", "	( red green blue -- )" );
	swigFunction( "c-function glColor3f glColor3f r r r -- void", "FUNCTION: glColor3f ( red green blue -- void )", "EXTERN: \"C\" void glColor3f( float red, float green, float blue );", "	( red green blue -- )" );
	swigFunction( "c-function glColor3i glColor3i n n n -- void", "FUNCTION: glColor3i ( red green blue -- void )", "EXTERN: \"C\" void glColor3i( int red, int green, int blue );", "	( red green blue -- )" );
	swigFunction( "c-function glColor3s glColor3s n n n -- void", "FUNCTION: glColor3s ( red green blue -- void )", "EXTERN: \"C\" void glColor3s( short red, short green, short blue );", "	( red green blue -- )" );
	swigFunction( "c-function glColor3ub glColor3ub u u u -- void", "FUNCTION: glColor3ub ( red green blue -- void )", "EXTERN: \"C\" void glColor3ub( char red, char green, char blue );", "	( red green blue -- )" );
	swigFunction( "c-function glColor3ui glColor3ui u u u -- void", "FUNCTION: glColor3ui ( red green blue -- void )", "EXTERN: \"C\" void glColor3ui( int red, int green, int blue );", "	( red green blue -- )" );
	swigFunction( "c-function glColor3us glColor3us u u u -- void", "FUNCTION: glColor3us ( red green blue -- void )", "EXTERN: \"C\" void glColor3us( short red, short green, short blue );", "	( red green blue -- )" );
	swigFunction( "c-function glColor4b glColor4b n n n n -- void", "FUNCTION: glColor4b ( red green blue alpha -- void )", "EXTERN: \"C\" void glColor4b( char red, char green, char blue, char alpha );", "	( red green blue alpha -- )" );
	swigFunction( "c-function glColor4d glColor4d r r r r -- void", "FUNCTION: glColor4d ( red green blue alpha -- void )", "EXTERN: \"C\" void glColor4d( double red, double green, double blue, double alpha );", "	( red green blue alpha -- )" );
	swigFunction( "c-function glColor4f glColor4f r r r r -- void", "FUNCTION: glColor4f ( red green blue alpha -- void )", "EXTERN: \"C\" void glColor4f( float red, float green, float blue, float alpha );", "	( red green blue alpha -- )" );
	swigFunction( "c-function glColor4i glColor4i n n n n -- void", "FUNCTION: glColor4i ( red green blue alpha -- void )", "EXTERN: \"C\" void glColor4i( int red, int green, int blue, int alpha );", "	( red green blue alpha -- )" );
	swigFunction( "c-function glColor4s glColor4s n n n n -- void", "FUNCTION: glColor4s ( red green blue alpha -- void )", "EXTERN: \"C\" void glColor4s( short red, short green, short blue, short alpha );", "	( red green blue alpha -- )" );
	swigFunction( "c-function glColor4ub glColor4ub u u u u -- void", "FUNCTION: glColor4ub ( red green blue alpha -- void )", "EXTERN: \"C\" void glColor4ub( char red, char green, char blue, char alpha );", "	( red green blue alpha -- )" );
	swigFunction( "c-function glColor4ui glColor4ui u u u u -- void", "FUNCTION: glColor4ui ( red green blue alpha -- void )", "EXTERN: \"C\" void glColor4ui( int red, int green, int blue, int alpha );", "	( red green blue alpha -- )" );
	swigFunction( "c-function glColor4us glColor4us u u u u -- void", "FUNCTION: glColor4us ( red green blue alpha -- void )", "EXTERN: \"C\" void glColor4us( short red, short green, short blue, short alpha );", "	( red green blue alpha -- )" );
	swigFunction( "c-function glColor3bv glColor3bv a -- void", "FUNCTION: glColor3bv ( v -- void )", "EXTERN: \"C\" void glColor3bv( void * v );", "	( v -- )" );
	swigFunction( "c-function glColor3dv glColor3dv a -- void", "FUNCTION: glColor3dv ( v -- void )", "EXTERN: \"C\" void glColor3dv( void * v );", "	( v -- )" );
	swigFunction( "c-function glColor3fv glColor3fv a -- void", "FUNCTION: glColor3fv ( v -- void )", "EXTERN: \"C\" void glColor3fv( void * v );", "	( v -- )" );
	swigFunction( "c-function glColor3iv glColor3iv a -- void", "FUNCTION: glColor3iv ( v -- void )", "EXTERN: \"C\" void glColor3iv( void * v );", "	( v -- )" );
	swigFunction( "c-function glColor3sv glColor3sv a -- void", "FUNCTION: glColor3sv ( v -- void )", "EXTERN: \"C\" void glColor3sv( void * v );", "	( v -- )" );
	swigFunction( "c-function glColor3ubv glColor3ubv a -- void", "FUNCTION: glColor3ubv ( v -- void )", "EXTERN: \"C\" void glColor3ubv( void * v );", "	( v -- )" );
	swigFunction( "c-function glColor3uiv glColor3uiv a -- void", "FUNCTION: glColor3uiv ( v -- void )", "EXTERN: \"C\" void glColor3uiv( void * v );", "	( v -- )" );
	swigFunction( "c-function glColor3usv glColor3usv a -- void", "FUNCTION: glColor3usv ( v -- void )", "EXTERN: \"C\" void glColor3usv( void * v );", "	( v -- )" );
	swigFunction( "c-function glColor4bv glColor4bv a -- void", "FUNCTION: glColor4bv ( v -- void )", "EXTERN: \"C\" void glColor4bv( void * v );", "	( v -- )" );
	swigFunction( "c-function glColor4dv glColor4dv a -- void", "FUNCTION: glColor4dv ( v -- void )", "EXTERN: \"C\" void glColor4dv( void * v );", "	( v -- )" );
	swigFunction( "c-function glColor4fv glColor4fv a -- void", "FUNCTION: glColor4fv ( v -- void )", "EXTERN: \"C\" void glColor4fv( void * v );", "	( v -- )" );
	swigFunction( "c-function glColor4iv glColor4iv a -- void", "FUNCTION: glColor4iv ( v -- void )", "EXTERN: \"C\" void glColor4iv( void * v );", "	( v -- )" );
	swigFunction( "c-function glColor4sv glColor4sv a -- void", "FUNCTION: glColor4sv ( v -- void )", "EXTERN: \"C\" void glColor4sv( void * v );", "	( v -- )" );
	swigFunction( "c-function glColor4ubv glColor4ubv a -- void", "FUNCTION: glColor4ubv ( v -- void )", "EXTERN: \"C\" void glColor4ubv( void * v );", "	( v -- )" );
	swigFunction( "c-function glColor4uiv glColor4uiv a -- void", "FUNCTION: glColor4uiv ( v -- void )", "EXTERN: \"C\" void glColor4uiv( void * v );", "	( v -- )" );
	swigFunction( "c-function glColor4usv glColor4usv a -- void", "FUNCTION: glColor4usv ( v -- void )", "EXTERN: \"C\" void glColor4usv( void * v );", "	( v -- )" );
	swigFunction( "c-function glTexCoord1d glTexCoord1d r -- void", "FUNCTION: glTexCoord1d ( s -- void )", "EXTERN: \"C\" void glTexCoord1d( double s );", "	( s -- )" );
	swigFunction( "c-function glTexCoord1f glTexCoord1f r -- void", "FUNCTION: glTexCoord1f ( s -- void )", "EXTERN: \"C\" void glTexCoord1f( float s );", "	( s -- )" );
	swigFunction( "c-function glTexCoord1i glTexCoord1i n -- void", "FUNCTION: glTexCoord1i ( s -- void )", "EXTERN: \"C\" void glTexCoord1i( int s );", "	( s -- )" );
	swigFunction( "c-function glTexCoord1s glTexCoord1s n -- void", "FUNCTION: glTexCoord1s ( s -- void )", "EXTERN: \"C\" void glTexCoord1s( short s );", "	( s -- )" );
	swigFunction( "c-function glTexCoord2d glTexCoord2d r r -- void", "FUNCTION: glTexCoord2d ( s t -- void )", "EXTERN: \"C\" void glTexCoord2d( double s, double t );", "	( s t -- )" );
	swigFunction( "c-function glTexCoord2f glTexCoord2f r r -- void", "FUNCTION: glTexCoord2f ( s t -- void )", "EXTERN: \"C\" void glTexCoord2f( float s, float t );", "	( s t -- )" );
	swigFunction( "c-function glTexCoord2i glTexCoord2i n n -- void", "FUNCTION: glTexCoord2i ( s t -- void )", "EXTERN: \"C\" void glTexCoord2i( int s, int t );", "	( s t -- )" );
	swigFunction( "c-function glTexCoord2s glTexCoord2s n n -- void", "FUNCTION: glTexCoord2s ( s t -- void )", "EXTERN: \"C\" void glTexCoord2s( short s, short t );", "	( s t -- )" );
	swigFunction( "c-function glTexCoord3d glTexCoord3d r r r -- void", "FUNCTION: glTexCoord3d ( s t r -- void )", "EXTERN: \"C\" void glTexCoord3d( double s, double t, double r );", "	( s t r -- )" );
	swigFunction( "c-function glTexCoord3f glTexCoord3f r r r -- void", "FUNCTION: glTexCoord3f ( s t r -- void )", "EXTERN: \"C\" void glTexCoord3f( float s, float t, float r );", "	( s t r -- )" );
	swigFunction( "c-function glTexCoord3i glTexCoord3i n n n -- void", "FUNCTION: glTexCoord3i ( s t r -- void )", "EXTERN: \"C\" void glTexCoord3i( int s, int t, int r );", "	( s t r -- )" );
	swigFunction( "c-function glTexCoord3s glTexCoord3s n n n -- void", "FUNCTION: glTexCoord3s ( s t r -- void )", "EXTERN: \"C\" void glTexCoord3s( short s, short t, short r );", "	( s t r -- )" );
	swigFunction( "c-function glTexCoord4d glTexCoord4d r r r r -- void", "FUNCTION: glTexCoord4d ( s t r q -- void )", "EXTERN: \"C\" void glTexCoord4d( double s, double t, double r, double q );", "	( s t r q -- )" );
	swigFunction( "c-function glTexCoord4f glTexCoord4f r r r r -- void", "FUNCTION: glTexCoord4f ( s t r q -- void )", "EXTERN: \"C\" void glTexCoord4f( float s, float t, float r, float q );", "	( s t r q -- )" );
	swigFunction( "c-function glTexCoord4i glTexCoord4i n n n n -- void", "FUNCTION: glTexCoord4i ( s t r q -- void )", "EXTERN: \"C\" void glTexCoord4i( int s, int t, int r, int q );", "	( s t r q -- )" );
	swigFunction( "c-function glTexCoord4s glTexCoord4s n n n n -- void", "FUNCTION: glTexCoord4s ( s t r q -- void )", "EXTERN: \"C\" void glTexCoord4s( short s, short t, short r, short q );", "	( s t r q -- )" );
	swigFunction( "c-function glTexCoord1dv glTexCoord1dv a -- void", "FUNCTION: glTexCoord1dv ( v -- void )", "EXTERN: \"C\" void glTexCoord1dv( void * v );", "	( v -- )" );
	swigFunction( "c-function glTexCoord1fv glTexCoord1fv a -- void", "FUNCTION: glTexCoord1fv ( v -- void )", "EXTERN: \"C\" void glTexCoord1fv( void * v );", "	( v -- )" );
	swigFunction( "c-function glTexCoord1iv glTexCoord1iv a -- void", "FUNCTION: glTexCoord1iv ( v -- void )", "EXTERN: \"C\" void glTexCoord1iv( void * v );", "	( v -- )" );
	swigFunction( "c-function glTexCoord1sv glTexCoord1sv a -- void", "FUNCTION: glTexCoord1sv ( v -- void )", "EXTERN: \"C\" void glTexCoord1sv( void * v );", "	( v -- )" );
	swigFunction( "c-function glTexCoord2dv glTexCoord2dv a -- void", "FUNCTION: glTexCoord2dv ( v -- void )", "EXTERN: \"C\" void glTexCoord2dv( void * v );", "	( v -- )" );
	swigFunction( "c-function glTexCoord2fv glTexCoord2fv a -- void", "FUNCTION: glTexCoord2fv ( v -- void )", "EXTERN: \"C\" void glTexCoord2fv( void * v );", "	( v -- )" );
	swigFunction( "c-function glTexCoord2iv glTexCoord2iv a -- void", "FUNCTION: glTexCoord2iv ( v -- void )", "EXTERN: \"C\" void glTexCoord2iv( void * v );", "	( v -- )" );
	swigFunction( "c-function glTexCoord2sv glTexCoord2sv a -- void", "FUNCTION: glTexCoord2sv ( v -- void )", "EXTERN: \"C\" void glTexCoord2sv( void * v );", "	( v -- )" );
	swigFunction( "c-function glTexCoord3dv glTexCoord3dv a -- void", "FUNCTION: glTexCoord3dv ( v -- void )", "EXTERN: \"C\" void glTexCoord3dv( void * v );", "	( v -- )" );
	swigFunction( "c-function glTexCoord3fv glTexCoord3fv a -- void", "FUNCTION: glTexCoord3fv ( v -- void )", "EXTERN: \"C\" void glTexCoord3fv( void * v );", "	( v -- )" );
	swigFunction( "c-function glTexCoord3iv glTexCoord3iv a -- void", "FUNCTION: glTexCoord3iv ( v -- void )", "EXTERN: \"C\" void glTexCoord3iv( void * v );", "	( v -- )" );
	swigFunction( "c-function glTexCoord3sv glTexCoord3sv a -- void", "FUNCTION: glTexCoord3sv ( v -- void )", "EXTERN: \"C\" void glTexCoord3sv( void * v );", "	( v -- )" );
	swigFunction( "c-function glTexCoord4dv glTexCoord4dv a -- void", "FUNCTION: glTexCoord4dv ( v -- void )", "EXTERN: \"C\" void glTexCoord4dv( void * v );", "	( v -- )" );
	swigFunction( "c-function glTexCoord4fv glTexCoord4fv a -- void", "FUNCTION: glTexCoord4fv ( v -- void )", "EXTERN: \"C\" void glTexCoord4fv( void * v );", "	( v -- )" );
	swigFunction( "c-function glTexCoord4iv glTexCoord4iv a -- void", "FUNCTION: glTexCoord4iv ( v -- void )", "EXTERN: \"C\" void glTexCoord4iv( void * v );", "	( v -- )" );
	swigFunction( "c-function glTexCoord4sv glTexCoord4sv a -- void", "FUNCTION: glTexCoord4sv ( v -- void )", "EXTERN: \"C\" void glTexCoord4sv( void * v );", "	( v -- )" );
	swigFunction( "c-function glRasterPos2d glRasterPos2d r r -- void", "FUNCTION: glRasterPos2d ( x y -- void )", "EXTERN: \"C\" void glRasterPos2d( double x, double y );", "	( x y -- )" );
	swigFunction( "c-function glRasterPos2f glRasterPos2f r r -- void", "FUNCTION: glRasterPos2f ( x y -- void )", "EXTERN: \"C\" void glRasterPos2f( float x, float y );", "	( x y -- )" );
	swigFunction( "c-function glRasterPos2i glRasterPos2i n n -- void", "FUNCTION: glRasterPos2i ( x y -- void )", "EXTERN: \"C\" void glRasterPos2i( int x, int y );", "	( x y -- )" );
	swigFunction( "c-function glRasterPos2s glRasterPos2s n n -- void", "FUNCTION: glRasterPos2s ( x y -- void )", "EXTERN: \"C\" void glRasterPos2s( short x, short y );", "	( x y -- )" );
	swigFunction( "c-function glRasterPos3d glRasterPos3d r r r -- void", "FUNCTION: glRasterPos3d ( x y z -- void )", "EXTERN: \"C\" void glRasterPos3d( double x, double y, double z );", "	( x y z -- )" );
	swigFunction( "c-function glRasterPos3f glRasterPos3f r r r -- void", "FUNCTION: glRasterPos3f ( x y z -- void )", "EXTERN: \"C\" void glRasterPos3f( float x, float y, float z );", "	( x y z -- )" );
	swigFunction( "c-function glRasterPos3i glRasterPos3i n n n -- void", "FUNCTION: glRasterPos3i ( x y z -- void )", "EXTERN: \"C\" void glRasterPos3i( int x, int y, int z );", "	( x y z -- )" );
	swigFunction( "c-function glRasterPos3s glRasterPos3s n n n -- void", "FUNCTION: glRasterPos3s ( x y z -- void )", "EXTERN: \"C\" void glRasterPos3s( short x, short y, short z );", "	( x y z -- )" );
	swigFunction( "c-function glRasterPos4d glRasterPos4d r r r r -- void", "FUNCTION: glRasterPos4d ( x y z w -- void )", "EXTERN: \"C\" void glRasterPos4d( double x, double y, double z, double w );", "	( x y z w -- )" );
	swigFunction( "c-function glRasterPos4f glRasterPos4f r r r r -- void", "FUNCTION: glRasterPos4f ( x y z w -- void )", "EXTERN: \"C\" void glRasterPos4f( float x, float y, float z, float w );", "	( x y z w -- )" );
	swigFunction( "c-function glRasterPos4i glRasterPos4i n n n n -- void", "FUNCTION: glRasterPos4i ( x y z w -- void )", "EXTERN: \"C\" void glRasterPos4i( int x, int y, int z, int w );", "	( x y z w -- )" );
	swigFunction( "c-function glRasterPos4s glRasterPos4s n n n n -- void", "FUNCTION: glRasterPos4s ( x y z w -- void )", "EXTERN: \"C\" void glRasterPos4s( short x, short y, short z, short w );", "	( x y z w -- )" );
	swigFunction( "c-function glRasterPos2dv glRasterPos2dv a -- void", "FUNCTION: glRasterPos2dv ( v -- void )", "EXTERN: \"C\" void glRasterPos2dv( void * v );", "	( v -- )" );
	swigFunction( "c-function glRasterPos2fv glRasterPos2fv a -- void", "FUNCTION: glRasterPos2fv ( v -- void )", "EXTERN: \"C\" void glRasterPos2fv( void * v );", "	( v -- )" );
	swigFunction( "c-function glRasterPos2iv glRasterPos2iv a -- void", "FUNCTION: glRasterPos2iv ( v -- void )", "EXTERN: \"C\" void glRasterPos2iv( void * v );", "	( v -- )" );
	swigFunction( "c-function glRasterPos2sv glRasterPos2sv a -- void", "FUNCTION: glRasterPos2sv ( v -- void )", "EXTERN: \"C\" void glRasterPos2sv( void * v );", "	( v -- )" );
	swigFunction( "c-function glRasterPos3dv glRasterPos3dv a -- void", "FUNCTION: glRasterPos3dv ( v -- void )", "EXTERN: \"C\" void glRasterPos3dv( void * v );", "	( v -- )" );
	swigFunction( "c-function glRasterPos3fv glRasterPos3fv a -- void", "FUNCTION: glRasterPos3fv ( v -- void )", "EXTERN: \"C\" void glRasterPos3fv( void * v );", "	( v -- )" );
	swigFunction( "c-function glRasterPos3iv glRasterPos3iv a -- void", "FUNCTION: glRasterPos3iv ( v -- void )", "EXTERN: \"C\" void glRasterPos3iv( void * v );", "	( v -- )" );
	swigFunction( "c-function glRasterPos3sv glRasterPos3sv a -- void", "FUNCTION: glRasterPos3sv ( v -- void )", "EXTERN: \"C\" void glRasterPos3sv( void * v );", "	( v -- )" );
	swigFunction( "c-function glRasterPos4dv glRasterPos4dv a -- void", "FUNCTION: glRasterPos4dv ( v -- void )", "EXTERN: \"C\" void glRasterPos4dv( void * v );", "	( v -- )" );
	swigFunction( "c-function glRasterPos4fv glRasterPos4fv a -- void", "FUNCTION: glRasterPos4fv ( v -- void )", "EXTERN: \"C\" void glRasterPos4fv( void * v );", "	( v -- )" );
	swigFunction( "c-function glRasterPos4iv glRasterPos4iv a -- void", "FUNCTION: glRasterPos4iv ( v -- void )", "EXTERN: \"C\" void glRasterPos4iv( void * v );", "	( v -- )" );
	swigFunction( "c-function glRasterPos4sv glRasterPos4sv a -- void", "FUNCTION: glRasterPos4sv ( v -- void )", "EXTERN: \"C\" void glRasterPos4sv( void * v );", "	( v -- )" );
	swigFunction( "c-function glRectd glRectd r r r r -- void", "FUNCTION: glRectd ( x1 y1 x2 y2 -- void )", "EXTERN: \"C\" void glRectd( double x1, double y1, double x2, double y2 );", "	( x1 y1 x2 y2 -- )" );
	swigFunction( "c-function glRectf glRectf r r r r -- void", "FUNCTION: glRectf ( x1 y1 x2 y2 -- void )", "EXTERN: \"C\" void glRectf( float x1, float y1, float x2, float y2 );", "	( x1 y1 x2 y2 -- )" );
	swigFunction( "c-function glRecti glRecti n n n n -- void", "FUNCTION: glRecti ( x1 y1 x2 y2 -- void )", "EXTERN: \"C\" void glRecti( int x1, int y1, int x2, int y2 );", "	( x1 y1 x2 y2 -- )" );
	swigFunction( "c-function glRects glRects n n n n -- void", "FUNCTION: glRects ( x1 y1 x2 y2 -- void )", "EXTERN: \"C\" void glRects( short x1, short y1, short x2, short y2 );", "	( x1 y1 x2 y2 -- )" );
	swigFunction( "c-function glRectdv glRectdv a a -- void", "FUNCTION: glRectdv ( v1 v2 -- void )", "EXTERN: \"C\" void glRectdv( void * v1, void * v2 );", "	( v1 v2 -- )" );
	swigFunction( "c-function glRectfv glRectfv a a -- void", "FUNCTION: glRectfv ( v1 v2 -- void )", "EXTERN: \"C\" void glRectfv( void * v1, void * v2 );", "	( v1 v2 -- )" );
	swigFunction( "c-function glRectiv glRectiv a a -- void", "FUNCTION: glRectiv ( v1 v2 -- void )", "EXTERN: \"C\" void glRectiv( void * v1, void * v2 );", "	( v1 v2 -- )" );
	swigFunction( "c-function glRectsv glRectsv a a -- void", "FUNCTION: glRectsv ( v1 v2 -- void )", "EXTERN: \"C\" void glRectsv( void * v1, void * v2 );", "	( v1 v2 -- )" );
	swigFunction( "c-function glVertexPointer glVertexPointer n u n a -- void", "FUNCTION: glVertexPointer ( size type stride ptr -- void )", "EXTERN: \"C\" void glVertexPointer( int size, int type, int stride, void * ptr );", "	( size type stride ptr -- )" );
	swigFunction( "c-function glNormalPointer glNormalPointer u n a -- void", "FUNCTION: glNormalPointer ( type stride ptr -- void )", "EXTERN: \"C\" void glNormalPointer( int type, int stride, void * ptr );", "	( type stride ptr -- )" );
	swigFunction( "c-function glColorPointer glColorPointer n u n a -- void", "FUNCTION: glColorPointer ( size type stride ptr -- void )", "EXTERN: \"C\" void glColorPointer( int size, int type, int stride, void * ptr );", "	( size type stride ptr -- )" );
	swigFunction( "c-function glIndexPointer glIndexPointer u n a -- void", "FUNCTION: glIndexPointer ( type stride ptr -- void )", "EXTERN: \"C\" void glIndexPointer( int type, int stride, void * ptr );", "	( type stride ptr -- )" );
	swigFunction( "c-function glTexCoordPointer glTexCoordPointer n u n a -- void", "FUNCTION: glTexCoordPointer ( size type stride ptr -- void )", "EXTERN: \"C\" void glTexCoordPointer( int size, int type, int stride, void * ptr );", "	( size type stride ptr -- )" );
	swigFunction( "c-function glEdgeFlagPointer glEdgeFlagPointer n a -- void", "FUNCTION: glEdgeFlagPointer ( stride ptr -- void )", "EXTERN: \"C\" void glEdgeFlagPointer( int stride, void * ptr );", "	( stride ptr -- )" );
	swigFunction( "c-function glGetPointerv glGetPointerv u a -- void", "FUNCTION: glGetPointerv ( pname params -- void )", "EXTERN: \"C\" void glGetPointerv( int pname, void * params );", "	( pname params -- )" );
	swigFunction( "c-function glArrayElement glArrayElement n -- void", "FUNCTION: glArrayElement ( i -- void )", "EXTERN: \"C\" void glArrayElement( int i );", "	( i -- )" );
	swigFunction( "c-function glDrawArrays glDrawArrays u n n -- void", "FUNCTION: glDrawArrays ( mode first count -- void )", "EXTERN: \"C\" void glDrawArrays( int mode, int first, int count );", "	( mode first count -- )" );
	swigFunction( "c-function glDrawElements glDrawElements u n u a -- void", "FUNCTION: glDrawElements ( mode count type indices -- void )", "EXTERN: \"C\" void glDrawElements( int mode, int count, int type, void * indices );", "	( mode count type indices -- )" );
	swigFunction( "c-function glInterleavedArrays glInterleavedArrays u n a -- void", "FUNCTION: glInterleavedArrays ( format stride pointer -- void )", "EXTERN: \"C\" void glInterleavedArrays( int format, int stride, void * pointer );", "	( format stride pointer -- )" );
	swigFunction( "c-function glShadeModel glShadeModel u -- void", "FUNCTION: glShadeModel ( mode -- void )", "EXTERN: \"C\" void glShadeModel( int mode );", "	( mode -- )" );
	swigFunction( "c-function glLightf glLightf u u r -- void", "FUNCTION: glLightf ( light pname param -- void )", "EXTERN: \"C\" void glLightf( int light, int pname, float param );", "	( light pname param -- )" );
	swigFunction( "c-function glLighti glLighti u u n -- void", "FUNCTION: glLighti ( light pname param -- void )", "EXTERN: \"C\" void glLighti( int light, int pname, int param );", "	( light pname param -- )" );
	swigFunction( "c-function glLightfv glLightfv u u a -- void", "FUNCTION: glLightfv ( light pname params -- void )", "EXTERN: \"C\" void glLightfv( int light, int pname, void * params );", "	( light pname params -- )" );
	swigFunction( "c-function glLightiv glLightiv u u a -- void", "FUNCTION: glLightiv ( light pname params -- void )", "EXTERN: \"C\" void glLightiv( int light, int pname, void * params );", "	( light pname params -- )" );
	swigFunction( "c-function glGetLightfv glGetLightfv u u a -- void", "FUNCTION: glGetLightfv ( light pname params -- void )", "EXTERN: \"C\" void glGetLightfv( int light, int pname, void * params );", "	( light pname params -- )" );
	swigFunction( "c-function glGetLightiv glGetLightiv u u a -- void", "FUNCTION: glGetLightiv ( light pname params -- void )", "EXTERN: \"C\" void glGetLightiv( int light, int pname, void * params );", "	( light pname params -- )" );
	swigFunction( "c-function glLightModelf glLightModelf u r -- void", "FUNCTION: glLightModelf ( pname param -- void )", "EXTERN: \"C\" void glLightModelf( int pname, float param );", "	( pname param -- )" );
	swigFunction( "c-function glLightModeli glLightModeli u n -- void", "FUNCTION: glLightModeli ( pname param -- void )", "EXTERN: \"C\" void glLightModeli( int pname, int param );", "	( pname param -- )" );
	swigFunction( "c-function glLightModelfv glLightModelfv u a -- void", "FUNCTION: glLightModelfv ( pname params -- void )", "EXTERN: \"C\" void glLightModelfv( int pname, void * params );", "	( pname params -- )" );
	swigFunction( "c-function glLightModeliv glLightModeliv u a -- void", "FUNCTION: glLightModeliv ( pname params -- void )", "EXTERN: \"C\" void glLightModeliv( int pname, void * params );", "	( pname params -- )" );
	swigFunction( "c-function glMaterialf glMaterialf u u r -- void", "FUNCTION: glMaterialf ( face pname param -- void )", "EXTERN: \"C\" void glMaterialf( int face, int pname, float param );", "	( face pname param -- )" );
	swigFunction( "c-function glMateriali glMateriali u u n -- void", "FUNCTION: glMateriali ( face pname param -- void )", "EXTERN: \"C\" void glMateriali( int face, int pname, int param );", "	( face pname param -- )" );
	swigFunction( "c-function glMaterialfv glMaterialfv u u a -- void", "FUNCTION: glMaterialfv ( face pname params -- void )", "EXTERN: \"C\" void glMaterialfv( int face, int pname, void * params );", "	( face pname params -- )" );
	swigFunction( "c-function glMaterialiv glMaterialiv u u a -- void", "FUNCTION: glMaterialiv ( face pname params -- void )", "EXTERN: \"C\" void glMaterialiv( int face, int pname, void * params );", "	( face pname params -- )" );
	swigFunction( "c-function glGetMaterialfv glGetMaterialfv u u a -- void", "FUNCTION: glGetMaterialfv ( face pname params -- void )", "EXTERN: \"C\" void glGetMaterialfv( int face, int pname, void * params );", "	( face pname params -- )" );
	swigFunction( "c-function glGetMaterialiv glGetMaterialiv u u a -- void", "FUNCTION: glGetMaterialiv ( face pname params -- void )", "EXTERN: \"C\" void glGetMaterialiv( int face, int pname, void * params );", "	( face pname params -- )" );
	swigFunction( "c-function glColorMaterial glColorMaterial u u -- void", "FUNCTION: glColorMaterial ( face mode -- void )", "EXTERN: \"C\" void glColorMaterial( int face, int mode );", "	( face mode -- )" );
	swigFunction( "c-function glPixelZoom glPixelZoom r r -- void", "FUNCTION: glPixelZoom ( xfactor yfactor -- void )", "EXTERN: \"C\" void glPixelZoom( float xfactor, float yfactor );", "	( xfactor yfactor -- )" );
	swigFunction( "c-function glPixelStoref glPixelStoref u r -- void", "FUNCTION: glPixelStoref ( pname param -- void )", "EXTERN: \"C\" void glPixelStoref( int pname, float param );", "	( pname param -- )" );
	swigFunction( "c-function glPixelStorei glPixelStorei u n -- void", "FUNCTION: glPixelStorei ( pname param -- void )", "EXTERN: \"C\" void glPixelStorei( int pname, int param );", "	( pname param -- )" );
	swigFunction( "c-function glPixelTransferf glPixelTransferf u r -- void", "FUNCTION: glPixelTransferf ( pname param -- void )", "EXTERN: \"C\" void glPixelTransferf( int pname, float param );", "	( pname param -- )" );
	swigFunction( "c-function glPixelTransferi glPixelTransferi u n -- void", "FUNCTION: glPixelTransferi ( pname param -- void )", "EXTERN: \"C\" void glPixelTransferi( int pname, int param );", "	( pname param -- )" );
	swigFunction( "c-function glPixelMapfv glPixelMapfv u n a -- void", "FUNCTION: glPixelMapfv ( map mapsize values -- void )", "EXTERN: \"C\" void glPixelMapfv( int map, int mapsize, void * values );", "	( map mapsize values -- )" );
	swigFunction( "c-function glPixelMapuiv glPixelMapuiv u n a -- void", "FUNCTION: glPixelMapuiv ( map mapsize values -- void )", "EXTERN: \"C\" void glPixelMapuiv( int map, int mapsize, void * values );", "	( map mapsize values -- )" );
	swigFunction( "c-function glPixelMapusv glPixelMapusv u n a -- void", "FUNCTION: glPixelMapusv ( map mapsize values -- void )", "EXTERN: \"C\" void glPixelMapusv( int map, int mapsize, void * values );", "	( map mapsize values -- )" );
	swigFunction( "c-function glGetPixelMapfv glGetPixelMapfv u a -- void", "FUNCTION: glGetPixelMapfv ( map values -- void )", "EXTERN: \"C\" void glGetPixelMapfv( int map, void * values );", "	( map values -- )" );
	swigFunction( "c-function glGetPixelMapuiv glGetPixelMapuiv u a -- void", "FUNCTION: glGetPixelMapuiv ( map values -- void )", "EXTERN: \"C\" void glGetPixelMapuiv( int map, void * values );", "	( map values -- )" );
	swigFunction( "c-function glGetPixelMapusv glGetPixelMapusv u a -- void", "FUNCTION: glGetPixelMapusv ( map values -- void )", "EXTERN: \"C\" void glGetPixelMapusv( int map, void * values );", "	( map values -- )" );
	swigFunction( "c-function glBitmap glBitmap n n r r r r a -- void", "FUNCTION: glBitmap ( width height xorig yorig xmove ymove bitmap -- void )", "EXTERN: \"C\" void glBitmap( int width, int height, float xorig, float yorig, float xmove, float ymove, void * bitmap );", "	( width height xorig yorig xmove ymove bitmap -- )" );
	swigFunction( "c-function glReadPixels glReadPixels n n n n u u a -- void", "FUNCTION: glReadPixels ( x y width height format type pixels -- void )", "EXTERN: \"C\" void glReadPixels( int x, int y, int width, int height, int format, int type, void * pixels );", "	( x y width height format type pixels -- )" );
	swigFunction( "c-function glDrawPixels glDrawPixels n n u u a -- void", "FUNCTION: glDrawPixels ( width height format type pixels -- void )", "EXTERN: \"C\" void glDrawPixels( int width, int height, int format, int type, void * pixels );", "	( width height format type pixels -- )" );
	swigFunction( "c-function glCopyPixels glCopyPixels n n n n u -- void", "FUNCTION: glCopyPixels ( x y width height type -- void )", "EXTERN: \"C\" void glCopyPixels( int x, int y, int width, int height, int type );", "	( x y width height type -- )" );
	swigFunction( "c-function glStencilFunc glStencilFunc u n u -- void", "FUNCTION: glStencilFunc ( func ref mask -- void )", "EXTERN: \"C\" void glStencilFunc( int func, int ref, int mask );", "	( func ref mask -- )" );
	swigFunction( "c-function glStencilMask glStencilMask u -- void", "FUNCTION: glStencilMask ( mask -- void )", "EXTERN: \"C\" void glStencilMask( int mask );", "	( mask -- )" );
	swigFunction( "c-function glStencilOp glStencilOp u u u -- void", "FUNCTION: glStencilOp ( fail zfail zpass -- void )", "EXTERN: \"C\" void glStencilOp( int fail, int zfail, int zpass );", "	( fail zfail zpass -- )" );
	swigFunction( "c-function glClearStencil glClearStencil n -- void", "FUNCTION: glClearStencil ( s -- void )", "EXTERN: \"C\" void glClearStencil( int s );", "	( s -- )" );
	swigFunction( "c-function glTexGend glTexGend u u r -- void", "FUNCTION: glTexGend ( coord pname param -- void )", "EXTERN: \"C\" void glTexGend( int coord, int pname, double param );", "	( coord pname param -- )" );
	swigFunction( "c-function glTexGenf glTexGenf u u r -- void", "FUNCTION: glTexGenf ( coord pname param -- void )", "EXTERN: \"C\" void glTexGenf( int coord, int pname, float param );", "	( coord pname param -- )" );
	swigFunction( "c-function glTexGeni glTexGeni u u n -- void", "FUNCTION: glTexGeni ( coord pname param -- void )", "EXTERN: \"C\" void glTexGeni( int coord, int pname, int param );", "	( coord pname param -- )" );
	swigFunction( "c-function glTexGendv glTexGendv u u a -- void", "FUNCTION: glTexGendv ( coord pname params -- void )", "EXTERN: \"C\" void glTexGendv( int coord, int pname, void * params );", "	( coord pname params -- )" );
	swigFunction( "c-function glTexGenfv glTexGenfv u u a -- void", "FUNCTION: glTexGenfv ( coord pname params -- void )", "EXTERN: \"C\" void glTexGenfv( int coord, int pname, void * params );", "	( coord pname params -- )" );
	swigFunction( "c-function glTexGeniv glTexGeniv u u a -- void", "FUNCTION: glTexGeniv ( coord pname params -- void )", "EXTERN: \"C\" void glTexGeniv( int coord, int pname, void * params );", "	( coord pname params -- )" );
	swigFunction( "c-function glGetTexGendv glGetTexGendv u u a -- void", "FUNCTION: glGetTexGendv ( coord pname params -- void )", "EXTERN: \"C\" void glGetTexGendv( int coord, int pname, void * params );", "	( coord pname params -- )" );
	swigFunction( "c-function glGetTexGenfv glGetTexGenfv u u a -- void", "FUNCTION: glGetTexGenfv ( coord pname params -- void )", "EXTERN: \"C\" void glGetTexGenfv( int coord, int pname, void * params );", "	( coord pname params -- )" );
	swigFunction( "c-function glGetTexGeniv glGetTexGeniv u u a -- void", "FUNCTION: glGetTexGeniv ( coord pname params -- void )", "EXTERN: \"C\" void glGetTexGeniv( int coord, int pname, void * params );", "	( coord pname params -- )" );
	swigFunction( "c-function glTexEnvf glTexEnvf u u r -- void", "FUNCTION: glTexEnvf ( target pname param -- void )", "EXTERN: \"C\" void glTexEnvf( int target, int pname, float param );", "	( target pname param -- )" );
	swigFunction( "c-function glTexEnvi glTexEnvi u u n -- void", "FUNCTION: glTexEnvi ( target pname param -- void )", "EXTERN: \"C\" void glTexEnvi( int target, int pname, int param );", "	( target pname param -- )" );
	swigFunction( "c-function glTexEnvfv glTexEnvfv u u a -- void", "FUNCTION: glTexEnvfv ( target pname params -- void )", "EXTERN: \"C\" void glTexEnvfv( int target, int pname, void * params );", "	( target pname params -- )" );
	swigFunction( "c-function glTexEnviv glTexEnviv u u a -- void", "FUNCTION: glTexEnviv ( target pname params -- void )", "EXTERN: \"C\" void glTexEnviv( int target, int pname, void * params );", "	( target pname params -- )" );
	swigFunction( "c-function glGetTexEnvfv glGetTexEnvfv u u a -- void", "FUNCTION: glGetTexEnvfv ( target pname params -- void )", "EXTERN: \"C\" void glGetTexEnvfv( int target, int pname, void * params );", "	( target pname params -- )" );
	swigFunction( "c-function glGetTexEnviv glGetTexEnviv u u a -- void", "FUNCTION: glGetTexEnviv ( target pname params -- void )", "EXTERN: \"C\" void glGetTexEnviv( int target, int pname, void * params );", "	( target pname params -- )" );
	swigFunction( "c-function glTexParameterf glTexParameterf u u r -- void", "FUNCTION: glTexParameterf ( target pname param -- void )", "EXTERN: \"C\" void glTexParameterf( int target, int pname, float param );", "	( target pname param -- )" );
	swigFunction( "c-function glTexParameteri glTexParameteri u u n -- void", "FUNCTION: glTexParameteri ( target pname param -- void )", "EXTERN: \"C\" void glTexParameteri( int target, int pname, int param );", "	( target pname param -- )" );
	swigFunction( "c-function glTexParameterfv glTexParameterfv u u a -- void", "FUNCTION: glTexParameterfv ( target pname params -- void )", "EXTERN: \"C\" void glTexParameterfv( int target, int pname, void * params );", "	( target pname params -- )" );
	swigFunction( "c-function glTexParameteriv glTexParameteriv u u a -- void", "FUNCTION: glTexParameteriv ( target pname params -- void )", "EXTERN: \"C\" void glTexParameteriv( int target, int pname, void * params );", "	( target pname params -- )" );
	swigFunction( "c-function glGetTexParameterfv glGetTexParameterfv u u a -- void", "FUNCTION: glGetTexParameterfv ( target pname params -- void )", "EXTERN: \"C\" void glGetTexParameterfv( int target, int pname, void * params );", "	( target pname params -- )" );
	swigFunction( "c-function glGetTexParameteriv glGetTexParameteriv u u a -- void", "FUNCTION: glGetTexParameteriv ( target pname params -- void )", "EXTERN: \"C\" void glGetTexParameteriv( int target, int pname, void * params );", "	( target pname params -- )" );
	swigFunction( "c-function glGetTexLevelParameterfv glGetTexLevelParameterfv u n u a -- void", "FUNCTION: glGetTexLevelParameterfv ( target level pname params -- void )", "EXTERN: \"C\" void glGetTexLevelParameterfv( int target, int level, int pname, void * params );", "	( target level pname params -- )" );
	swigFunction( "c-function glGetTexLevelParameteriv glGetTexLevelParameteriv u n u a -- void", "FUNCTION: glGetTexLevelParameteriv ( target level pname params -- void )", "EXTERN: \"C\" void glGetTexLevelParameteriv( int target, int level, int pname, void * params );", "	( target level pname params -- )" );
	swigFunction( "c-function glTexImage1D glTexImage1D u n n n n u u a -- void", "FUNCTION: glTexImage1D ( target level internalFormat width border format type pixels -- void )", "EXTERN: \"C\" void glTexImage1D( int target, int level, int internalFormat, int width, int border, int format, int type, void * pixels );", "	( target level internalFormat width border format type pixels -- )" );
	swigFunction( "c-function glTexImage2D glTexImage2D u n n n n n u u a -- void", "FUNCTION: glTexImage2D ( target level internalFormat width height border format type pixels -- void )", "EXTERN: \"C\" void glTexImage2D( int target, int level, int internalFormat, int width, int height, int border, int format, int type, void * pixels );", "	( target level internalFormat width height border format type pixels -- )" );
	swigFunction( "c-function glGetTexImage glGetTexImage u n u u a -- void", "FUNCTION: glGetTexImage ( target level format type pixels -- void )", "EXTERN: \"C\" void glGetTexImage( int target, int level, int format, int type, void * pixels );", "	( target level format type pixels -- )" );
	swigFunction( "c-function glGenTextures glGenTextures n a -- void", "FUNCTION: glGenTextures ( n textures -- void )", "EXTERN: \"C\" void glGenTextures( int n, void * textures );", "	( n textures -- )" );
	swigFunction( "c-function glDeleteTextures glDeleteTextures n a -- void", "FUNCTION: glDeleteTextures ( n textures -- void )", "EXTERN: \"C\" void glDeleteTextures( int n, void * textures );", "	( n textures -- )" );
	swigFunction( "c-function glBindTexture glBindTexture u u -- void", "FUNCTION: glBindTexture ( target texture -- void )", "EXTERN: \"C\" void glBindTexture( int target, int texture );", "	( target texture -- )" );
	swigFunction( "c-function glPrioritizeTextures glPrioritizeTextures n a a -- void", "FUNCTION: glPrioritizeTextures ( n textures priorities -- void )", "EXTERN: \"C\" void glPrioritizeTextures( int n, void * textures, void * priorities );", "	( n textures priorities -- )" );
	swigFunction( "c-function glAreTexturesResident glAreTexturesResident n a a -- u", "FUNCTION: glAreTexturesResident ( n textures residences -- u )", "EXTERN: \"C\" char glAreTexturesResident( int n, void * textures, void * residences );", "	( n textures residences -- )" );
	swigFunction( "c-function glIsTexture glIsTexture u -- u", "FUNCTION: glIsTexture ( texture -- u )", "EXTERN: \"C\" char glIsTexture( int texture );", "	( texture -- )" );
	swigFunction( "c-function glTexSubImage1D glTexSubImage1D u n n n u u a -- void", "FUNCTION: glTexSubImage1D ( target level xoffset width format type pixels -- void )", "EXTERN: \"C\" void glTexSubImage1D( int target, int level, int xoffset, int width, int format, int type, void * pixels );", "	( target level xoffset width format type pixels -- )" );
	swigFunction( "c-function glTexSubImage2D glTexSubImage2D u n n n n n u u a -- void", "FUNCTION: glTexSubImage2D ( target level xoffset yoffset width height format type pixels -- void )", "EXTERN: \"C\" void glTexSubImage2D( int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, void * pixels );", "	( target level xoffset yoffset width height format type pixels -- )" );
	swigFunction( "c-function glCopyTexImage1D glCopyTexImage1D u n u n n n n -- void", "FUNCTION: glCopyTexImage1D ( target level internalformat x y width border -- void )", "EXTERN: \"C\" void glCopyTexImage1D( int target, int level, int internalformat, int x, int y, int width, int border );", "	( target level internalformat x y width border -- )" );
	swigFunction( "c-function glCopyTexImage2D glCopyTexImage2D u n u n n n n n -- void", "FUNCTION: glCopyTexImage2D ( target level internalformat x y width height border -- void )", "EXTERN: \"C\" void glCopyTexImage2D( int target, int level, int internalformat, int x, int y, int width, int height, int border );", "	( target level internalformat x y width height border -- )" );
	swigFunction( "c-function glCopyTexSubImage1D glCopyTexSubImage1D u n n n n n -- void", "FUNCTION: glCopyTexSubImage1D ( target level xoffset x y width -- void )", "EXTERN: \"C\" void glCopyTexSubImage1D( int target, int level, int xoffset, int x, int y, int width );", "	( target level xoffset x y width -- )" );
	swigFunction( "c-function glCopyTexSubImage2D glCopyTexSubImage2D u n n n n n n n -- void", "FUNCTION: glCopyTexSubImage2D ( target level xoffset yoffset x y width height -- void )", "EXTERN: \"C\" void glCopyTexSubImage2D( int target, int level, int xoffset, int yoffset, int x, int y, int width, int height );", "	( target level xoffset yoffset x y width height -- )" );
	swigFunction( "c-function glMap1d glMap1d u r r n n a -- void", "FUNCTION: glMap1d ( target u1 u2 stride order points -- void )", "EXTERN: \"C\" void glMap1d( int target, double u1, double u2, int stride, int order, void * points );", "	( target u1 u2 stride order points -- )" );
	swigFunction( "c-function glMap1f glMap1f u r r n n a -- void", "FUNCTION: glMap1f ( target u1 u2 stride order points -- void )", "EXTERN: \"C\" void glMap1f( int target, float u1, float u2, int stride, int order, void * points );", "	( target u1 u2 stride order points -- )" );
	swigFunction( "c-function glMap2d glMap2d u r r n n r r n n a -- void", "FUNCTION: glMap2d ( target u1 u2 ustride uorder v1 v2 vstride vorder points -- void )", "EXTERN: \"C\" void glMap2d( int target, double u1, double u2, int ustride, int uorder, double v1, double v2, int vstride, int vorder, void * points );", "	( target u1 u2 ustride uorder v1 v2 vstride vorder points -- )" );
	swigFunction( "c-function glMap2f glMap2f u r r n n r r n n a -- void", "FUNCTION: glMap2f ( target u1 u2 ustride uorder v1 v2 vstride vorder points -- void )", "EXTERN: \"C\" void glMap2f( int target, float u1, float u2, int ustride, int uorder, float v1, float v2, int vstride, int vorder, void * points );", "	( target u1 u2 ustride uorder v1 v2 vstride vorder points -- )" );
	swigFunction( "c-function glGetMapdv glGetMapdv u u a -- void", "FUNCTION: glGetMapdv ( target query v -- void )", "EXTERN: \"C\" void glGetMapdv( int target, int query, void * v );", "	( target query v -- )" );
	swigFunction( "c-function glGetMapfv glGetMapfv u u a -- void", "FUNCTION: glGetMapfv ( target query v -- void )", "EXTERN: \"C\" void glGetMapfv( int target, int query, void * v );", "	( target query v -- )" );
	swigFunction( "c-function glGetMapiv glGetMapiv u u a -- void", "FUNCTION: glGetMapiv ( target query v -- void )", "EXTERN: \"C\" void glGetMapiv( int target, int query, void * v );", "	( target query v -- )" );
	swigFunction( "c-function glEvalCoord1d glEvalCoord1d r -- void", "FUNCTION: glEvalCoord1d ( u -- void )", "EXTERN: \"C\" void glEvalCoord1d( double u );", "	( u -- )" );
	swigFunction( "c-function glEvalCoord1f glEvalCoord1f r -- void", "FUNCTION: glEvalCoord1f ( u -- void )", "EXTERN: \"C\" void glEvalCoord1f( float u );", "	( u -- )" );
	swigFunction( "c-function glEvalCoord1dv glEvalCoord1dv a -- void", "FUNCTION: glEvalCoord1dv ( u -- void )", "EXTERN: \"C\" void glEvalCoord1dv( void * u );", "	( u -- )" );
	swigFunction( "c-function glEvalCoord1fv glEvalCoord1fv a -- void", "FUNCTION: glEvalCoord1fv ( u -- void )", "EXTERN: \"C\" void glEvalCoord1fv( void * u );", "	( u -- )" );
	swigFunction( "c-function glEvalCoord2d glEvalCoord2d r r -- void", "FUNCTION: glEvalCoord2d ( u v -- void )", "EXTERN: \"C\" void glEvalCoord2d( double u, double v );", "	( u v -- )" );
	swigFunction( "c-function glEvalCoord2f glEvalCoord2f r r -- void", "FUNCTION: glEvalCoord2f ( u v -- void )", "EXTERN: \"C\" void glEvalCoord2f( float u, float v );", "	( u v -- )" );
	swigFunction( "c-function glEvalCoord2dv glEvalCoord2dv a -- void", "FUNCTION: glEvalCoord2dv ( u -- void )", "EXTERN: \"C\" void glEvalCoord2dv( void * u );", "	( u -- )" );
	swigFunction( "c-function glEvalCoord2fv glEvalCoord2fv a -- void", "FUNCTION: glEvalCoord2fv ( u -- void )", "EXTERN: \"C\" void glEvalCoord2fv( void * u );", "	( u -- )" );
	swigFunction( "c-function glMapGrid1d glMapGrid1d n r r -- void", "FUNCTION: glMapGrid1d ( un u1 u2 -- void )", "EXTERN: \"C\" void glMapGrid1d( int un, double u1, double u2 );", "	( un u1 u2 -- )" );
	swigFunction( "c-function glMapGrid1f glMapGrid1f n r r -- void", "FUNCTION: glMapGrid1f ( un u1 u2 -- void )", "EXTERN: \"C\" void glMapGrid1f( int un, float u1, float u2 );", "	( un u1 u2 -- )" );
	swigFunction( "c-function glMapGrid2d glMapGrid2d n r r n r r -- void", "FUNCTION: glMapGrid2d ( un u1 u2 vn v1 v2 -- void )", "EXTERN: \"C\" void glMapGrid2d( int un, double u1, double u2, int vn, double v1, double v2 );", "	( un u1 u2 vn v1 v2 -- )" );
	swigFunction( "c-function glMapGrid2f glMapGrid2f n r r n r r -- void", "FUNCTION: glMapGrid2f ( un u1 u2 vn v1 v2 -- void )", "EXTERN: \"C\" void glMapGrid2f( int un, float u1, float u2, int vn, float v1, float v2 );", "	( un u1 u2 vn v1 v2 -- )" );
	swigFunction( "c-function glEvalPoint1 glEvalPoint1 n -- void", "FUNCTION: glEvalPoint1 ( i -- void )", "EXTERN: \"C\" void glEvalPoint1( int i );", "	( i -- )" );
	swigFunction( "c-function glEvalPoint2 glEvalPoint2 n n -- void", "FUNCTION: glEvalPoint2 ( i j -- void )", "EXTERN: \"C\" void glEvalPoint2( int i, int j );", "	( i j -- )" );
	swigFunction( "c-function glEvalMesh1 glEvalMesh1 u n n -- void", "FUNCTION: glEvalMesh1 ( mode i1 i2 -- void )", "EXTERN: \"C\" void glEvalMesh1( int mode, int i1, int i2 );", "	( mode i1 i2 -- )" );
	swigFunction( "c-function glEvalMesh2 glEvalMesh2 u n n n n -- void", "FUNCTION: glEvalMesh2 ( mode i1 i2 j1 j2 -- void )", "EXTERN: \"C\" void glEvalMesh2( int mode, int i1, int i2, int j1, int j2 );", "	( mode i1 i2 j1 j2 -- )" );
	swigFunction( "c-function glFogf glFogf u r -- void", "FUNCTION: glFogf ( pname param -- void )", "EXTERN: \"C\" void glFogf( int pname, float param );", "	( pname param -- )" );
	swigFunction( "c-function glFogi glFogi u n -- void", "FUNCTION: glFogi ( pname param -- void )", "EXTERN: \"C\" void glFogi( int pname, int param );", "	( pname param -- )" );
	swigFunction( "c-function glFogfv glFogfv u a -- void", "FUNCTION: glFogfv ( pname params -- void )", "EXTERN: \"C\" void glFogfv( int pname, void * params );", "	( pname params -- )" );
	swigFunction( "c-function glFogiv glFogiv u a -- void", "FUNCTION: glFogiv ( pname params -- void )", "EXTERN: \"C\" void glFogiv( int pname, void * params );", "	( pname params -- )" );
	swigFunction( "c-function glFeedbackBuffer glFeedbackBuffer n u a -- void", "FUNCTION: glFeedbackBuffer ( size type buffer -- void )", "EXTERN: \"C\" void glFeedbackBuffer( int size, int type, void * buffer );", "	( size type buffer -- )" );
	swigFunction( "c-function glPassThrough glPassThrough r -- void", "FUNCTION: glPassThrough ( token -- void )", "EXTERN: \"C\" void glPassThrough( float token );", "	( token -- )" );
	swigFunction( "c-function glSelectBuffer glSelectBuffer n a -- void", "FUNCTION: glSelectBuffer ( size buffer -- void )", "EXTERN: \"C\" void glSelectBuffer( int size, void * buffer );", "	( size buffer -- )" );
	swigFunction( "c-function glInitNames glInitNames  -- void", "FUNCTION: glInitNames (  -- void )", "EXTERN: \"C\" void glInitNames(  );", "	( -- )" );
	swigFunction( "c-function glLoadName glLoadName u -- void", "FUNCTION: glLoadName ( name -- void )", "EXTERN: \"C\" void glLoadName( int name );", "	( name -- )" );
	swigFunction( "c-function glPushName glPushName u -- void", "FUNCTION: glPushName ( name -- void )", "EXTERN: \"C\" void glPushName( int name );", "	( name -- )" );
	swigFunction( "c-function glPopName glPopName  -- void", "FUNCTION: glPopName (  -- void )", "EXTERN: \"C\" void glPopName(  );", "	( -- )" );
	swigFunction( "c-function glDrawRangeElements glDrawRangeElements u u u n u a -- void", "FUNCTION: glDrawRangeElements ( mode start end count type indices -- void )", "EXTERN: \"C\" void glDrawRangeElements( int mode, int start, int end, int count, int type, void * indices );", "	( mode start end count type indices -- )" );
	swigFunction( "c-function glTexImage3D glTexImage3D u n n n n n n u u a -- void", "FUNCTION: glTexImage3D ( target level internalFormat width height depth border format type pixels -- void )", "EXTERN: \"C\" void glTexImage3D( int target, int level, int internalFormat, int width, int height, int depth, int border, int format, int type, void * pixels );", "	( target level internalFormat width height depth border format type pixels -- )" );
	swigFunction( "c-function glTexSubImage3D glTexSubImage3D u n n n n n n n u u a -- void", "FUNCTION: glTexSubImage3D ( target level xoffset yoffset zoffset width height depth format type pixels -- void )", "EXTERN: \"C\" void glTexSubImage3D( int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, void * pixels );", "	( target level xoffset yoffset zoffset width height depth format type pixels -- )" );
	swigFunction( "c-function glCopyTexSubImage3D glCopyTexSubImage3D u n n n n n n n n -- void", "FUNCTION: glCopyTexSubImage3D ( target level xoffset yoffset zoffset x y width height -- void )", "EXTERN: \"C\" void glCopyTexSubImage3D( int target, int level, int xoffset, int yoffset, int zoffset, int x, int y, int width, int height );", "	( target level xoffset yoffset zoffset x y width height -- )" );
	swigFunction( "c-function glColorTable glColorTable u u n u u a -- void", "FUNCTION: glColorTable ( target internalformat width format type table -- void )", "EXTERN: \"C\" void glColorTable( int target, int internalformat, int width, int format, int type, void * table );", "	( target internalformat width format type table -- )" );
	swigFunction( "c-function glColorSubTable glColorSubTable u n n u u a -- void", "FUNCTION: glColorSubTable ( target start count format type data -- void )", "EXTERN: \"C\" void glColorSubTable( int target, int start, int count, int format, int type, void * data );", "	( target start count format type data -- )" );
	swigFunction( "c-function glColorTableParameteriv glColorTableParameteriv u u a -- void", "FUNCTION: glColorTableParameteriv ( target pname params -- void )", "EXTERN: \"C\" void glColorTableParameteriv( int target, int pname, void * params );", "	( target pname params -- )" );
	swigFunction( "c-function glColorTableParameterfv glColorTableParameterfv u u a -- void", "FUNCTION: glColorTableParameterfv ( target pname params -- void )", "EXTERN: \"C\" void glColorTableParameterfv( int target, int pname, void * params );", "	( target pname params -- )" );
	swigFunction( "c-function glCopyColorSubTable glCopyColorSubTable u n n n n -- void", "FUNCTION: glCopyColorSubTable ( target start x y width -- void )", "EXTERN: \"C\" void glCopyColorSubTable( int target, int start, int x, int y, int width );", "	( target start x y width -- )" );
	swigFunction( "c-function glCopyColorTable glCopyColorTable u u n n n -- void", "FUNCTION: glCopyColorTable ( target internalformat x y width -- void )", "EXTERN: \"C\" void glCopyColorTable( int target, int internalformat, int x, int y, int width );", "	( target internalformat x y width -- )" );
	swigFunction( "c-function glGetColorTable glGetColorTable u u u a -- void", "FUNCTION: glGetColorTable ( target format type table -- void )", "EXTERN: \"C\" void glGetColorTable( int target, int format, int type, void * table );", "	( target format type table -- )" );
	swigFunction( "c-function glGetColorTableParameterfv glGetColorTableParameterfv u u a -- void", "FUNCTION: glGetColorTableParameterfv ( target pname params -- void )", "EXTERN: \"C\" void glGetColorTableParameterfv( int target, int pname, void * params );", "	( target pname params -- )" );
	swigFunction( "c-function glGetColorTableParameteriv glGetColorTableParameteriv u u a -- void", "FUNCTION: glGetColorTableParameteriv ( target pname params -- void )", "EXTERN: \"C\" void glGetColorTableParameteriv( int target, int pname, void * params );", "	( target pname params -- )" );
	swigFunction( "c-function glBlendEquation glBlendEquation u -- void", "FUNCTION: glBlendEquation ( mode -- void )", "EXTERN: \"C\" void glBlendEquation( int mode );", "	( mode -- )" );
	swigFunction( "c-function glBlendColor glBlendColor r r r r -- void", "FUNCTION: glBlendColor ( red green blue alpha -- void )", "EXTERN: \"C\" void glBlendColor( float red, float green, float blue, float alpha );", "	( red green blue alpha -- )" );
	swigFunction( "c-function glHistogram glHistogram u n u u -- void", "FUNCTION: glHistogram ( target width internalformat sink -- void )", "EXTERN: \"C\" void glHistogram( int target, int width, int internalformat, char sink );", "	( target width internalformat sink -- )" );
	swigFunction( "c-function glResetHistogram glResetHistogram u -- void", "FUNCTION: glResetHistogram ( target -- void )", "EXTERN: \"C\" void glResetHistogram( int target );", "	( target -- )" );
	swigFunction( "c-function glGetHistogram glGetHistogram u u u u a -- void", "FUNCTION: glGetHistogram ( target reset format type values -- void )", "EXTERN: \"C\" void glGetHistogram( int target, char reset, int format, int type, void * values );", "	( target reset format type values -- )" );
	swigFunction( "c-function glGetHistogramParameterfv glGetHistogramParameterfv u u a -- void", "FUNCTION: glGetHistogramParameterfv ( target pname params -- void )", "EXTERN: \"C\" void glGetHistogramParameterfv( int target, int pname, void * params );", "	( target pname params -- )" );
	swigFunction( "c-function glGetHistogramParameteriv glGetHistogramParameteriv u u a -- void", "FUNCTION: glGetHistogramParameteriv ( target pname params -- void )", "EXTERN: \"C\" void glGetHistogramParameteriv( int target, int pname, void * params );", "	( target pname params -- )" );
	swigFunction( "c-function glMinmax glMinmax u u u -- void", "FUNCTION: glMinmax ( target internalformat sink -- void )", "EXTERN: \"C\" void glMinmax( int target, int internalformat, char sink );", "	( target internalformat sink -- )" );
	swigFunction( "c-function glResetMinmax glResetMinmax u -- void", "FUNCTION: glResetMinmax ( target -- void )", "EXTERN: \"C\" void glResetMinmax( int target );", "	( target -- )" );
	swigFunction( "c-function glGetMinmax glGetMinmax u u u u a -- void", "FUNCTION: glGetMinmax ( target reset format types values -- void )", "EXTERN: \"C\" void glGetMinmax( int target, char reset, int format, int types, void * values );", "	( target reset format types values -- )" );
	swigFunction( "c-function glGetMinmaxParameterfv glGetMinmaxParameterfv u u a -- void", "FUNCTION: glGetMinmaxParameterfv ( target pname params -- void )", "EXTERN: \"C\" void glGetMinmaxParameterfv( int target, int pname, void * params );", "	( target pname params -- )" );
	swigFunction( "c-function glGetMinmaxParameteriv glGetMinmaxParameteriv u u a -- void", "FUNCTION: glGetMinmaxParameteriv ( target pname params -- void )", "EXTERN: \"C\" void glGetMinmaxParameteriv( int target, int pname, void * params );", "	( target pname params -- )" );
	swigFunction( "c-function glConvolutionFilter1D glConvolutionFilter1D u u n u u a -- void", "FUNCTION: glConvolutionFilter1D ( target internalformat width format type image -- void )", "EXTERN: \"C\" void glConvolutionFilter1D( int target, int internalformat, int width, int format, int type, void * image );", "	( target internalformat width format type image -- )" );
	swigFunction( "c-function glConvolutionFilter2D glConvolutionFilter2D u u n n u u a -- void", "FUNCTION: glConvolutionFilter2D ( target internalformat width height format type image -- void )", "EXTERN: \"C\" void glConvolutionFilter2D( int target, int internalformat, int width, int height, int format, int type, void * image );", "	( target internalformat width height format type image -- )" );
	swigFunction( "c-function glConvolutionParameterf glConvolutionParameterf u u r -- void", "FUNCTION: glConvolutionParameterf ( target pname params -- void )", "EXTERN: \"C\" void glConvolutionParameterf( int target, int pname, float params );", "	( target pname params -- )" );
	swigFunction( "c-function glConvolutionParameterfv glConvolutionParameterfv u u a -- void", "FUNCTION: glConvolutionParameterfv ( target pname params -- void )", "EXTERN: \"C\" void glConvolutionParameterfv( int target, int pname, void * params );", "	( target pname params -- )" );
	swigFunction( "c-function glConvolutionParameteri glConvolutionParameteri u u n -- void", "FUNCTION: glConvolutionParameteri ( target pname params -- void )", "EXTERN: \"C\" void glConvolutionParameteri( int target, int pname, int params );", "	( target pname params -- )" );
	swigFunction( "c-function glConvolutionParameteriv glConvolutionParameteriv u u a -- void", "FUNCTION: glConvolutionParameteriv ( target pname params -- void )", "EXTERN: \"C\" void glConvolutionParameteriv( int target, int pname, void * params );", "	( target pname params -- )" );
	swigFunction( "c-function glCopyConvolutionFilter1D glCopyConvolutionFilter1D u u n n n -- void", "FUNCTION: glCopyConvolutionFilter1D ( target internalformat x y width -- void )", "EXTERN: \"C\" void glCopyConvolutionFilter1D( int target, int internalformat, int x, int y, int width );", "	( target internalformat x y width -- )" );
	swigFunction( "c-function glCopyConvolutionFilter2D glCopyConvolutionFilter2D u u n n n n -- void", "FUNCTION: glCopyConvolutionFilter2D ( target internalformat x y width height -- void )", "EXTERN: \"C\" void glCopyConvolutionFilter2D( int target, int internalformat, int x, int y, int width, int height );", "	( target internalformat x y width height -- )" );
	swigFunction( "c-function glGetConvolutionFilter glGetConvolutionFilter u u u a -- void", "FUNCTION: glGetConvolutionFilter ( target format type image -- void )", "EXTERN: \"C\" void glGetConvolutionFilter( int target, int format, int type, void * image );", "	( target format type image -- )" );
	swigFunction( "c-function glGetConvolutionParameterfv glGetConvolutionParameterfv u u a -- void", "FUNCTION: glGetConvolutionParameterfv ( target pname params -- void )", "EXTERN: \"C\" void glGetConvolutionParameterfv( int target, int pname, void * params );", "	( target pname params -- )" );
	swigFunction( "c-function glGetConvolutionParameteriv glGetConvolutionParameteriv u u a -- void", "FUNCTION: glGetConvolutionParameteriv ( target pname params -- void )", "EXTERN: \"C\" void glGetConvolutionParameteriv( int target, int pname, void * params );", "	( target pname params -- )" );
	swigFunction( "c-function glSeparableFilter2D glSeparableFilter2D u u n n u u a a -- void", "FUNCTION: glSeparableFilter2D ( target internalformat width height format type row column -- void )", "EXTERN: \"C\" void glSeparableFilter2D( int target, int internalformat, int width, int height, int format, int type, void * row, void * column );", "	( target internalformat width height format type row column -- )" );
	swigFunction( "c-function glGetSeparableFilter glGetSeparableFilter u u u a a a -- void", "FUNCTION: glGetSeparableFilter ( target format type row column span -- void )", "EXTERN: \"C\" void glGetSeparableFilter( int target, int format, int type, void * row, void * column, void * span );", "	( target format type row column span -- )" );
	swigFunction( "c-function glActiveTexture glActiveTexture u -- void", "FUNCTION: glActiveTexture ( texture -- void )", "EXTERN: \"C\" void glActiveTexture( int texture );", "	( texture -- )" );
	swigFunction( "c-function glClientActiveTexture glClientActiveTexture u -- void", "FUNCTION: glClientActiveTexture ( texture -- void )", "EXTERN: \"C\" void glClientActiveTexture( int texture );", "	( texture -- )" );
	swigFunction( "c-function glCompressedTexImage1D glCompressedTexImage1D u n u n n n a -- void", "FUNCTION: glCompressedTexImage1D ( target level internalformat width border imageSize data -- void )", "EXTERN: \"C\" void glCompressedTexImage1D( int target, int level, int internalformat, int width, int border, int imageSize, void * data );", "	( target level internalformat width border imageSize data -- )" );
	swigFunction( "c-function glCompressedTexImage2D glCompressedTexImage2D u n u n n n n a -- void", "FUNCTION: glCompressedTexImage2D ( target level internalformat width height border imageSize data -- void )", "EXTERN: \"C\" void glCompressedTexImage2D( int target, int level, int internalformat, int width, int height, int border, int imageSize, void * data );", "	( target level internalformat width height border imageSize data -- )" );
	swigFunction( "c-function glCompressedTexImage3D glCompressedTexImage3D u n u n n n n n a -- void", "FUNCTION: glCompressedTexImage3D ( target level internalformat width height depth border imageSize data -- void )", "EXTERN: \"C\" void glCompressedTexImage3D( int target, int level, int internalformat, int width, int height, int depth, int border, int imageSize, void * data );", "	( target level internalformat width height depth border imageSize data -- )" );
	swigFunction( "c-function glCompressedTexSubImage1D glCompressedTexSubImage1D u n n n u n a -- void", "FUNCTION: glCompressedTexSubImage1D ( target level xoffset width format imageSize data -- void )", "EXTERN: \"C\" void glCompressedTexSubImage1D( int target, int level, int xoffset, int width, int format, int imageSize, void * data );", "	( target level xoffset width format imageSize data -- )" );
	swigFunction( "c-function glCompressedTexSubImage2D glCompressedTexSubImage2D u n n n n n u n a -- void", "FUNCTION: glCompressedTexSubImage2D ( target level xoffset yoffset width height format imageSize data -- void )", "EXTERN: \"C\" void glCompressedTexSubImage2D( int target, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, void * data );", "	( target level xoffset yoffset width height format imageSize data -- )" );
	swigFunction( "c-function glCompressedTexSubImage3D glCompressedTexSubImage3D u n n n n n n n u n a -- void", "FUNCTION: glCompressedTexSubImage3D ( target level xoffset yoffset zoffset width height depth format imageSize data -- void )", "EXTERN: \"C\" void glCompressedTexSubImage3D( int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int imageSize, void * data );", "	( target level xoffset yoffset zoffset width height depth format imageSize data -- )" );
	swigFunction( "c-function glGetCompressedTexImage glGetCompressedTexImage u n a -- void", "FUNCTION: glGetCompressedTexImage ( target lod img -- void )", "EXTERN: \"C\" void glGetCompressedTexImage( int target, int lod, void * img );", "	( target lod img -- )" );
	swigFunction( "c-function glMultiTexCoord1d glMultiTexCoord1d u r -- void", "FUNCTION: glMultiTexCoord1d ( target s -- void )", "EXTERN: \"C\" void glMultiTexCoord1d( int target, double s );", "	( target s -- )" );
	swigFunction( "c-function glMultiTexCoord1dv glMultiTexCoord1dv u a -- void", "FUNCTION: glMultiTexCoord1dv ( target v -- void )", "EXTERN: \"C\" void glMultiTexCoord1dv( int target, void * v );", "	( target v -- )" );
	swigFunction( "c-function glMultiTexCoord1f glMultiTexCoord1f u r -- void", "FUNCTION: glMultiTexCoord1f ( target s -- void )", "EXTERN: \"C\" void glMultiTexCoord1f( int target, float s );", "	( target s -- )" );
	swigFunction( "c-function glMultiTexCoord1fv glMultiTexCoord1fv u a -- void", "FUNCTION: glMultiTexCoord1fv ( target v -- void )", "EXTERN: \"C\" void glMultiTexCoord1fv( int target, void * v );", "	( target v -- )" );
	swigFunction( "c-function glMultiTexCoord1i glMultiTexCoord1i u n -- void", "FUNCTION: glMultiTexCoord1i ( target s -- void )", "EXTERN: \"C\" void glMultiTexCoord1i( int target, int s );", "	( target s -- )" );
	swigFunction( "c-function glMultiTexCoord1iv glMultiTexCoord1iv u a -- void", "FUNCTION: glMultiTexCoord1iv ( target v -- void )", "EXTERN: \"C\" void glMultiTexCoord1iv( int target, void * v );", "	( target v -- )" );
	swigFunction( "c-function glMultiTexCoord1s glMultiTexCoord1s u n -- void", "FUNCTION: glMultiTexCoord1s ( target s -- void )", "EXTERN: \"C\" void glMultiTexCoord1s( int target, short s );", "	( target s -- )" );
	swigFunction( "c-function glMultiTexCoord1sv glMultiTexCoord1sv u a -- void", "FUNCTION: glMultiTexCoord1sv ( target v -- void )", "EXTERN: \"C\" void glMultiTexCoord1sv( int target, void * v );", "	( target v -- )" );
	swigFunction( "c-function glMultiTexCoord2d glMultiTexCoord2d u r r -- void", "FUNCTION: glMultiTexCoord2d ( target s t -- void )", "EXTERN: \"C\" void glMultiTexCoord2d( int target, double s, double t );", "	( target s t -- )" );
	swigFunction( "c-function glMultiTexCoord2dv glMultiTexCoord2dv u a -- void", "FUNCTION: glMultiTexCoord2dv ( target v -- void )", "EXTERN: \"C\" void glMultiTexCoord2dv( int target, void * v );", "	( target v -- )" );
	swigFunction( "c-function glMultiTexCoord2f glMultiTexCoord2f u r r -- void", "FUNCTION: glMultiTexCoord2f ( target s t -- void )", "EXTERN: \"C\" void glMultiTexCoord2f( int target, float s, float t );", "	( target s t -- )" );
	swigFunction( "c-function glMultiTexCoord2fv glMultiTexCoord2fv u a -- void", "FUNCTION: glMultiTexCoord2fv ( target v -- void )", "EXTERN: \"C\" void glMultiTexCoord2fv( int target, void * v );", "	( target v -- )" );
	swigFunction( "c-function glMultiTexCoord2i glMultiTexCoord2i u n n -- void", "FUNCTION: glMultiTexCoord2i ( target s t -- void )", "EXTERN: \"C\" void glMultiTexCoord2i( int target, int s, int t );", "	( target s t -- )" );
	swigFunction( "c-function glMultiTexCoord2iv glMultiTexCoord2iv u a -- void", "FUNCTION: glMultiTexCoord2iv ( target v -- void )", "EXTERN: \"C\" void glMultiTexCoord2iv( int target, void * v );", "	( target v -- )" );
	swigFunction( "c-function glMultiTexCoord2s glMultiTexCoord2s u n n -- void", "FUNCTION: glMultiTexCoord2s ( target s t -- void )", "EXTERN: \"C\" void glMultiTexCoord2s( int target, short s, short t );", "	( target s t -- )" );
	swigFunction( "c-function glMultiTexCoord2sv glMultiTexCoord2sv u a -- void", "FUNCTION: glMultiTexCoord2sv ( target v -- void )", "EXTERN: \"C\" void glMultiTexCoord2sv( int target, void * v );", "	( target v -- )" );
	swigFunction( "c-function glMultiTexCoord3d glMultiTexCoord3d u r r r -- void", "FUNCTION: glMultiTexCoord3d ( target s t r -- void )", "EXTERN: \"C\" void glMultiTexCoord3d( int target, double s, double t, double r );", "	( target s t r -- )" );
	swigFunction( "c-function glMultiTexCoord3dv glMultiTexCoord3dv u a -- void", "FUNCTION: glMultiTexCoord3dv ( target v -- void )", "EXTERN: \"C\" void glMultiTexCoord3dv( int target, void * v );", "	( target v -- )" );
	swigFunction( "c-function glMultiTexCoord3f glMultiTexCoord3f u r r r -- void", "FUNCTION: glMultiTexCoord3f ( target s t r -- void )", "EXTERN: \"C\" void glMultiTexCoord3f( int target, float s, float t, float r );", "	( target s t r -- )" );
	swigFunction( "c-function glMultiTexCoord3fv glMultiTexCoord3fv u a -- void", "FUNCTION: glMultiTexCoord3fv ( target v -- void )", "EXTERN: \"C\" void glMultiTexCoord3fv( int target, void * v );", "	( target v -- )" );
	swigFunction( "c-function glMultiTexCoord3i glMultiTexCoord3i u n n n -- void", "FUNCTION: glMultiTexCoord3i ( target s t r -- void )", "EXTERN: \"C\" void glMultiTexCoord3i( int target, int s, int t, int r );", "	( target s t r -- )" );
	swigFunction( "c-function glMultiTexCoord3iv glMultiTexCoord3iv u a -- void", "FUNCTION: glMultiTexCoord3iv ( target v -- void )", "EXTERN: \"C\" void glMultiTexCoord3iv( int target, void * v );", "	( target v -- )" );
	swigFunction( "c-function glMultiTexCoord3s glMultiTexCoord3s u n n n -- void", "FUNCTION: glMultiTexCoord3s ( target s t r -- void )", "EXTERN: \"C\" void glMultiTexCoord3s( int target, short s, short t, short r );", "	( target s t r -- )" );
	swigFunction( "c-function glMultiTexCoord3sv glMultiTexCoord3sv u a -- void", "FUNCTION: glMultiTexCoord3sv ( target v -- void )", "EXTERN: \"C\" void glMultiTexCoord3sv( int target, void * v );", "	( target v -- )" );
	swigFunction( "c-function glMultiTexCoord4d glMultiTexCoord4d u r r r r -- void", "FUNCTION: glMultiTexCoord4d ( target s t r q -- void )", "EXTERN: \"C\" void glMultiTexCoord4d( int target, double s, double t, double r, double q );", "	( target s t r q -- )" );
	swigFunction( "c-function glMultiTexCoord4dv glMultiTexCoord4dv u a -- void", "FUNCTION: glMultiTexCoord4dv ( target v -- void )", "EXTERN: \"C\" void glMultiTexCoord4dv( int target, void * v );", "	( target v -- )" );
	swigFunction( "c-function glMultiTexCoord4f glMultiTexCoord4f u r r r r -- void", "FUNCTION: glMultiTexCoord4f ( target s t r q -- void )", "EXTERN: \"C\" void glMultiTexCoord4f( int target, float s, float t, float r, float q );", "	( target s t r q -- )" );
	swigFunction( "c-function glMultiTexCoord4fv glMultiTexCoord4fv u a -- void", "FUNCTION: glMultiTexCoord4fv ( target v -- void )", "EXTERN: \"C\" void glMultiTexCoord4fv( int target, void * v );", "	( target v -- )" );
	swigFunction( "c-function glMultiTexCoord4i glMultiTexCoord4i u n n n n -- void", "FUNCTION: glMultiTexCoord4i ( target s t r q -- void )", "EXTERN: \"C\" void glMultiTexCoord4i( int target, int s, int t, int r, int q );", "	( target s t r q -- )" );
	swigFunction( "c-function glMultiTexCoord4iv glMultiTexCoord4iv u a -- void", "FUNCTION: glMultiTexCoord4iv ( target v -- void )", "EXTERN: \"C\" void glMultiTexCoord4iv( int target, void * v );", "	( target v -- )" );
	swigFunction( "c-function glMultiTexCoord4s glMultiTexCoord4s u n n n n -- void", "FUNCTION: glMultiTexCoord4s ( target s t r q -- void )", "EXTERN: \"C\" void glMultiTexCoord4s( int target, short s, short t, short r, short q );", "	( target s t r q -- )" );
	swigFunction( "c-function glMultiTexCoord4sv glMultiTexCoord4sv u a -- void", "FUNCTION: glMultiTexCoord4sv ( target v -- void )", "EXTERN: \"C\" void glMultiTexCoord4sv( int target, void * v );", "	( target v -- )" );
	swigFunction( "c-function glLoadTransposeMatrixd glLoadTransposeMatrixd a -- void", "FUNCTION: glLoadTransposeMatrixd ( m -- void )", "EXTERN: \"C\" void glLoadTransposeMatrixd( void * m );", "	( m -- )" );
	swigFunction( "c-function glLoadTransposeMatrixf glLoadTransposeMatrixf a -- void", "FUNCTION: glLoadTransposeMatrixf ( m -- void )", "EXTERN: \"C\" void glLoadTransposeMatrixf( void * m );", "	( m -- )" );
	swigFunction( "c-function glMultTransposeMatrixd glMultTransposeMatrixd a -- void", "FUNCTION: glMultTransposeMatrixd ( m -- void )", "EXTERN: \"C\" void glMultTransposeMatrixd( void * m );", "	( m -- )" );
	swigFunction( "c-function glMultTransposeMatrixf glMultTransposeMatrixf a -- void", "FUNCTION: glMultTransposeMatrixf ( m -- void )", "EXTERN: \"C\" void glMultTransposeMatrixf( void * m );", "	( m -- )" );
	swigFunction( "c-function glSampleCoverage glSampleCoverage r u -- void", "FUNCTION: glSampleCoverage ( value invert -- void )", "EXTERN: \"C\" void glSampleCoverage( float value, char invert );", "	( value invert -- )" );
	swigFunction( "c-function glActiveTextureARB glActiveTextureARB u -- void", "FUNCTION: glActiveTextureARB ( texture -- void )", "EXTERN: \"C\" void glActiveTextureARB( int texture );", "	( texture -- )" );
	swigFunction( "c-function glClientActiveTextureARB glClientActiveTextureARB u -- void", "FUNCTION: glClientActiveTextureARB ( texture -- void )", "EXTERN: \"C\" void glClientActiveTextureARB( int texture );", "	( texture -- )" );
	swigFunction( "c-function glMultiTexCoord1dARB glMultiTexCoord1dARB u r -- void", "FUNCTION: glMultiTexCoord1dARB ( target s -- void )", "EXTERN: \"C\" void glMultiTexCoord1dARB( int target, double s );", "	( target s -- )" );
	swigFunction( "c-function glMultiTexCoord1dvARB glMultiTexCoord1dvARB u a -- void", "FUNCTION: glMultiTexCoord1dvARB ( target v -- void )", "EXTERN: \"C\" void glMultiTexCoord1dvARB( int target, void * v );", "	( target v -- )" );
	swigFunction( "c-function glMultiTexCoord1fARB glMultiTexCoord1fARB u r -- void", "FUNCTION: glMultiTexCoord1fARB ( target s -- void )", "EXTERN: \"C\" void glMultiTexCoord1fARB( int target, float s );", "	( target s -- )" );
	swigFunction( "c-function glMultiTexCoord1fvARB glMultiTexCoord1fvARB u a -- void", "FUNCTION: glMultiTexCoord1fvARB ( target v -- void )", "EXTERN: \"C\" void glMultiTexCoord1fvARB( int target, void * v );", "	( target v -- )" );
	swigFunction( "c-function glMultiTexCoord1iARB glMultiTexCoord1iARB u n -- void", "FUNCTION: glMultiTexCoord1iARB ( target s -- void )", "EXTERN: \"C\" void glMultiTexCoord1iARB( int target, int s );", "	( target s -- )" );
	swigFunction( "c-function glMultiTexCoord1ivARB glMultiTexCoord1ivARB u a -- void", "FUNCTION: glMultiTexCoord1ivARB ( target v -- void )", "EXTERN: \"C\" void glMultiTexCoord1ivARB( int target, void * v );", "	( target v -- )" );
	swigFunction( "c-function glMultiTexCoord1sARB glMultiTexCoord1sARB u n -- void", "FUNCTION: glMultiTexCoord1sARB ( target s -- void )", "EXTERN: \"C\" void glMultiTexCoord1sARB( int target, short s );", "	( target s -- )" );
	swigFunction( "c-function glMultiTexCoord1svARB glMultiTexCoord1svARB u a -- void", "FUNCTION: glMultiTexCoord1svARB ( target v -- void )", "EXTERN: \"C\" void glMultiTexCoord1svARB( int target, void * v );", "	( target v -- )" );
	swigFunction( "c-function glMultiTexCoord2dARB glMultiTexCoord2dARB u r r -- void", "FUNCTION: glMultiTexCoord2dARB ( target s t -- void )", "EXTERN: \"C\" void glMultiTexCoord2dARB( int target, double s, double t );", "	( target s t -- )" );
	swigFunction( "c-function glMultiTexCoord2dvARB glMultiTexCoord2dvARB u a -- void", "FUNCTION: glMultiTexCoord2dvARB ( target v -- void )", "EXTERN: \"C\" void glMultiTexCoord2dvARB( int target, void * v );", "	( target v -- )" );
	swigFunction( "c-function glMultiTexCoord2fARB glMultiTexCoord2fARB u r r -- void", "FUNCTION: glMultiTexCoord2fARB ( target s t -- void )", "EXTERN: \"C\" void glMultiTexCoord2fARB( int target, float s, float t );", "	( target s t -- )" );
	swigFunction( "c-function glMultiTexCoord2fvARB glMultiTexCoord2fvARB u a -- void", "FUNCTION: glMultiTexCoord2fvARB ( target v -- void )", "EXTERN: \"C\" void glMultiTexCoord2fvARB( int target, void * v );", "	( target v -- )" );
	swigFunction( "c-function glMultiTexCoord2iARB glMultiTexCoord2iARB u n n -- void", "FUNCTION: glMultiTexCoord2iARB ( target s t -- void )", "EXTERN: \"C\" void glMultiTexCoord2iARB( int target, int s, int t );", "	( target s t -- )" );
	swigFunction( "c-function glMultiTexCoord2ivARB glMultiTexCoord2ivARB u a -- void", "FUNCTION: glMultiTexCoord2ivARB ( target v -- void )", "EXTERN: \"C\" void glMultiTexCoord2ivARB( int target, void * v );", "	( target v -- )" );
	swigFunction( "c-function glMultiTexCoord2sARB glMultiTexCoord2sARB u n n -- void", "FUNCTION: glMultiTexCoord2sARB ( target s t -- void )", "EXTERN: \"C\" void glMultiTexCoord2sARB( int target, short s, short t );", "	( target s t -- )" );
	swigFunction( "c-function glMultiTexCoord2svARB glMultiTexCoord2svARB u a -- void", "FUNCTION: glMultiTexCoord2svARB ( target v -- void )", "EXTERN: \"C\" void glMultiTexCoord2svARB( int target, void * v );", "	( target v -- )" );
	swigFunction( "c-function glMultiTexCoord3dARB glMultiTexCoord3dARB u r r r -- void", "FUNCTION: glMultiTexCoord3dARB ( target s t r -- void )", "EXTERN: \"C\" void glMultiTexCoord3dARB( int target, double s, double t, double r );", "	( target s t r -- )" );
	swigFunction( "c-function glMultiTexCoord3dvARB glMultiTexCoord3dvARB u a -- void", "FUNCTION: glMultiTexCoord3dvARB ( target v -- void )", "EXTERN: \"C\" void glMultiTexCoord3dvARB( int target, void * v );", "	( target v -- )" );
	swigFunction( "c-function glMultiTexCoord3fARB glMultiTexCoord3fARB u r r r -- void", "FUNCTION: glMultiTexCoord3fARB ( target s t r -- void )", "EXTERN: \"C\" void glMultiTexCoord3fARB( int target, float s, float t, float r );", "	( target s t r -- )" );
	swigFunction( "c-function glMultiTexCoord3fvARB glMultiTexCoord3fvARB u a -- void", "FUNCTION: glMultiTexCoord3fvARB ( target v -- void )", "EXTERN: \"C\" void glMultiTexCoord3fvARB( int target, void * v );", "	( target v -- )" );
	swigFunction( "c-function glMultiTexCoord3iARB glMultiTexCoord3iARB u n n n -- void", "FUNCTION: glMultiTexCoord3iARB ( target s t r -- void )", "EXTERN: \"C\" void glMultiTexCoord3iARB( int target, int s, int t, int r );", "	( target s t r -- )" );
	swigFunction( "c-function glMultiTexCoord3ivARB glMultiTexCoord3ivARB u a -- void", "FUNCTION: glMultiTexCoord3ivARB ( target v -- void )", "EXTERN: \"C\" void glMultiTexCoord3ivARB( int target, void * v );", "	( target v -- )" );
	swigFunction( "c-function glMultiTexCoord3sARB glMultiTexCoord3sARB u n n n -- void", "FUNCTION: glMultiTexCoord3sARB ( target s t r -- void )", "EXTERN: \"C\" void glMultiTexCoord3sARB( int target, short s, short t, short r );", "	( target s t r -- )" );
	swigFunction( "c-function glMultiTexCoord3svARB glMultiTexCoord3svARB u a -- void", "FUNCTION: glMultiTexCoord3svARB ( target v -- void )", "EXTERN: \"C\" void glMultiTexCoord3svARB( int target, void * v );", "	( target v -- )" );
	swigFunction( "c-function glMultiTexCoord4dARB glMultiTexCoord4dARB u r r r r -- void", "FUNCTION: glMultiTexCoord4dARB ( target s t r q -- void )", "EXTERN: \"C\" void glMultiTexCoord4dARB( int target, double s, double t, double r, double q );", "	( target s t r q -- )" );
	swigFunction( "c-function glMultiTexCoord4dvARB glMultiTexCoord4dvARB u a -- void", "FUNCTION: glMultiTexCoord4dvARB ( target v -- void )", "EXTERN: \"C\" void glMultiTexCoord4dvARB( int target, void * v );", "	( target v -- )" );
	swigFunction( "c-function glMultiTexCoord4fARB glMultiTexCoord4fARB u r r r r -- void", "FUNCTION: glMultiTexCoord4fARB ( target s t r q -- void )", "EXTERN: \"C\" void glMultiTexCoord4fARB( int target, float s, float t, float r, float q );", "	( target s t r q -- )" );
	swigFunction( "c-function glMultiTexCoord4fvARB glMultiTexCoord4fvARB u a -- void", "FUNCTION: glMultiTexCoord4fvARB ( target v -- void )", "EXTERN: \"C\" void glMultiTexCoord4fvARB( int target, void * v );", "	( target v -- )" );
	swigFunction( "c-function glMultiTexCoord4iARB glMultiTexCoord4iARB u n n n n -- void", "FUNCTION: glMultiTexCoord4iARB ( target s t r q -- void )", "EXTERN: \"C\" void glMultiTexCoord4iARB( int target, int s, int t, int r, int q );", "	( target s t r q -- )" );
	swigFunction( "c-function glMultiTexCoord4ivARB glMultiTexCoord4ivARB u a -- void", "FUNCTION: glMultiTexCoord4ivARB ( target v -- void )", "EXTERN: \"C\" void glMultiTexCoord4ivARB( int target, void * v );", "	( target v -- )" );
	swigFunction( "c-function glMultiTexCoord4sARB glMultiTexCoord4sARB u n n n n -- void", "FUNCTION: glMultiTexCoord4sARB ( target s t r q -- void )", "EXTERN: \"C\" void glMultiTexCoord4sARB( int target, short s, short t, short r, short q );", "	( target s t r q -- )" );
	swigFunction( "c-function glMultiTexCoord4svARB glMultiTexCoord4svARB u a -- void", "FUNCTION: glMultiTexCoord4svARB ( target v -- void )", "EXTERN: \"C\" void glMultiTexCoord4svARB( int target, void * v );", "	( target v -- )" );
	swigFunction( "c-function glBlendEquationSeparateATI glBlendEquationSeparateATI u u -- void", "FUNCTION: glBlendEquationSeparateATI ( modeRGB modeA -- void )", "EXTERN: \"C\" void glBlendEquationSeparateATI( int modeRGB, int modeA );", "	( modeRGB modeA -- )" );
	swigFunction( "c-function glEGLImageTargetTexture2DOES glEGLImageTargetTexture2DOES u a -- void", "FUNCTION: glEGLImageTargetTexture2DOES ( target image -- void )", "EXTERN: \"C\" void glEGLImageTargetTexture2DOES( int target, void * image );", "	( target image -- )" );
	swigFunction( "c-function glEGLImageTargetRenderbufferStorageOES glEGLImageTargetRenderbufferStorageOES u a -- void", "FUNCTION: glEGLImageTargetRenderbufferStorageOES ( target image -- void )", "EXTERN: \"C\" void glEGLImageTargetRenderbufferStorageOES( int target, void * image );", "	( target image -- )" );
	swigFunction( "c-function glBlendFuncSeparate glBlendFuncSeparate u u u u -- void", "FUNCTION: glBlendFuncSeparate ( sfactorRGB dfactorRGB sfactorAlpha dfactorAlpha -- void )", "EXTERN: \"C\" void glBlendFuncSeparate( int sfactorRGB, int dfactorRGB, int sfactorAlpha, int dfactorAlpha );", "	( sfactorRGB dfactorRGB sfactorAlpha dfactorAlpha -- )" );
	swigFunction( "c-function glMultiDrawArrays glMultiDrawArrays u a a n -- void", "FUNCTION: glMultiDrawArrays ( mode first count drawcount -- void )", "EXTERN: \"C\" void glMultiDrawArrays( int mode, void * first, void * count, int drawcount );", "	( mode first count drawcount -- )" );
	swigFunction( "c-function glMultiDrawElements glMultiDrawElements u a u a n -- void", "FUNCTION: glMultiDrawElements ( mode count type indices drawcount -- void )", "EXTERN: \"C\" void glMultiDrawElements( int mode, void * count, int type, void * indices, int drawcount );", "	( mode count type indices drawcount -- )" );
	swigFunction( "c-function glPointParameterf glPointParameterf u r -- void", "FUNCTION: glPointParameterf ( pname param -- void )", "EXTERN: \"C\" void glPointParameterf( int pname, float param );", "	( pname param -- )" );
	swigFunction( "c-function glPointParameterfv glPointParameterfv u a -- void", "FUNCTION: glPointParameterfv ( pname params -- void )", "EXTERN: \"C\" void glPointParameterfv( int pname, void * params );", "	( pname params -- )" );
	swigFunction( "c-function glPointParameteri glPointParameteri u n -- void", "FUNCTION: glPointParameteri ( pname param -- void )", "EXTERN: \"C\" void glPointParameteri( int pname, int param );", "	( pname param -- )" );
	swigFunction( "c-function glPointParameteriv glPointParameteriv u a -- void", "FUNCTION: glPointParameteriv ( pname params -- void )", "EXTERN: \"C\" void glPointParameteriv( int pname, void * params );", "	( pname params -- )" );
	swigFunction( "c-function glFogCoordf glFogCoordf r -- void", "FUNCTION: glFogCoordf ( coord -- void )", "EXTERN: \"C\" void glFogCoordf( float coord );", "	( coord -- )" );
	swigFunction( "c-function glFogCoordfv glFogCoordfv a -- void", "FUNCTION: glFogCoordfv ( coord -- void )", "EXTERN: \"C\" void glFogCoordfv( void * coord );", "	( coord -- )" );
	swigFunction( "c-function glFogCoordd glFogCoordd r -- void", "FUNCTION: glFogCoordd ( coord -- void )", "EXTERN: \"C\" void glFogCoordd( double coord );", "	( coord -- )" );
	swigFunction( "c-function glFogCoorddv glFogCoorddv a -- void", "FUNCTION: glFogCoorddv ( coord -- void )", "EXTERN: \"C\" void glFogCoorddv( void * coord );", "	( coord -- )" );
	swigFunction( "c-function glFogCoordPointer glFogCoordPointer u n a -- void", "FUNCTION: glFogCoordPointer ( type stride pointer -- void )", "EXTERN: \"C\" void glFogCoordPointer( int type, int stride, void * pointer );", "	( type stride pointer -- )" );
	swigFunction( "c-function glSecondaryColor3b glSecondaryColor3b n n n -- void", "FUNCTION: glSecondaryColor3b ( red green blue -- void )", "EXTERN: \"C\" void glSecondaryColor3b( char red, char green, char blue );", "	( red green blue -- )" );
	swigFunction( "c-function glSecondaryColor3bv glSecondaryColor3bv a -- void", "FUNCTION: glSecondaryColor3bv ( v -- void )", "EXTERN: \"C\" void glSecondaryColor3bv( void * v );", "	( v -- )" );
	swigFunction( "c-function glSecondaryColor3d glSecondaryColor3d r r r -- void", "FUNCTION: glSecondaryColor3d ( red green blue -- void )", "EXTERN: \"C\" void glSecondaryColor3d( double red, double green, double blue );", "	( red green blue -- )" );
	swigFunction( "c-function glSecondaryColor3dv glSecondaryColor3dv a -- void", "FUNCTION: glSecondaryColor3dv ( v -- void )", "EXTERN: \"C\" void glSecondaryColor3dv( void * v );", "	( v -- )" );
	swigFunction( "c-function glSecondaryColor3f glSecondaryColor3f r r r -- void", "FUNCTION: glSecondaryColor3f ( red green blue -- void )", "EXTERN: \"C\" void glSecondaryColor3f( float red, float green, float blue );", "	( red green blue -- )" );
	swigFunction( "c-function glSecondaryColor3fv glSecondaryColor3fv a -- void", "FUNCTION: glSecondaryColor3fv ( v -- void )", "EXTERN: \"C\" void glSecondaryColor3fv( void * v );", "	( v -- )" );
	swigFunction( "c-function glSecondaryColor3i glSecondaryColor3i n n n -- void", "FUNCTION: glSecondaryColor3i ( red green blue -- void )", "EXTERN: \"C\" void glSecondaryColor3i( int red, int green, int blue );", "	( red green blue -- )" );
	swigFunction( "c-function glSecondaryColor3iv glSecondaryColor3iv a -- void", "FUNCTION: glSecondaryColor3iv ( v -- void )", "EXTERN: \"C\" void glSecondaryColor3iv( void * v );", "	( v -- )" );
	swigFunction( "c-function glSecondaryColor3s glSecondaryColor3s n n n -- void", "FUNCTION: glSecondaryColor3s ( red green blue -- void )", "EXTERN: \"C\" void glSecondaryColor3s( short red, short green, short blue );", "	( red green blue -- )" );
	swigFunction( "c-function glSecondaryColor3sv glSecondaryColor3sv a -- void", "FUNCTION: glSecondaryColor3sv ( v -- void )", "EXTERN: \"C\" void glSecondaryColor3sv( void * v );", "	( v -- )" );
	swigFunction( "c-function glSecondaryColor3ub glSecondaryColor3ub u u u -- void", "FUNCTION: glSecondaryColor3ub ( red green blue -- void )", "EXTERN: \"C\" void glSecondaryColor3ub( char red, char green, char blue );", "	( red green blue -- )" );
	swigFunction( "c-function glSecondaryColor3ubv glSecondaryColor3ubv a -- void", "FUNCTION: glSecondaryColor3ubv ( v -- void )", "EXTERN: \"C\" void glSecondaryColor3ubv( void * v );", "	( v -- )" );
	swigFunction( "c-function glSecondaryColor3ui glSecondaryColor3ui u u u -- void", "FUNCTION: glSecondaryColor3ui ( red green blue -- void )", "EXTERN: \"C\" void glSecondaryColor3ui( int red, int green, int blue );", "	( red green blue -- )" );
	swigFunction( "c-function glSecondaryColor3uiv glSecondaryColor3uiv a -- void", "FUNCTION: glSecondaryColor3uiv ( v -- void )", "EXTERN: \"C\" void glSecondaryColor3uiv( void * v );", "	( v -- )" );
	swigFunction( "c-function glSecondaryColor3us glSecondaryColor3us u u u -- void", "FUNCTION: glSecondaryColor3us ( red green blue -- void )", "EXTERN: \"C\" void glSecondaryColor3us( short red, short green, short blue );", "	( red green blue -- )" );
	swigFunction( "c-function glSecondaryColor3usv glSecondaryColor3usv a -- void", "FUNCTION: glSecondaryColor3usv ( v -- void )", "EXTERN: \"C\" void glSecondaryColor3usv( void * v );", "	( v -- )" );
	swigFunction( "c-function glSecondaryColorPointer glSecondaryColorPointer n u n a -- void", "FUNCTION: glSecondaryColorPointer ( size type stride pointer -- void )", "EXTERN: \"C\" void glSecondaryColorPointer( int size, int type, int stride, void * pointer );", "	( size type stride pointer -- )" );
	swigFunction( "c-function glWindowPos2d glWindowPos2d r r -- void", "FUNCTION: glWindowPos2d ( x y -- void )", "EXTERN: \"C\" void glWindowPos2d( double x, double y );", "	( x y -- )" );
	swigFunction( "c-function glWindowPos2dv glWindowPos2dv a -- void", "FUNCTION: glWindowPos2dv ( v -- void )", "EXTERN: \"C\" void glWindowPos2dv( void * v );", "	( v -- )" );
	swigFunction( "c-function glWindowPos2f glWindowPos2f r r -- void", "FUNCTION: glWindowPos2f ( x y -- void )", "EXTERN: \"C\" void glWindowPos2f( float x, float y );", "	( x y -- )" );
	swigFunction( "c-function glWindowPos2fv glWindowPos2fv a -- void", "FUNCTION: glWindowPos2fv ( v -- void )", "EXTERN: \"C\" void glWindowPos2fv( void * v );", "	( v -- )" );
	swigFunction( "c-function glWindowPos2i glWindowPos2i n n -- void", "FUNCTION: glWindowPos2i ( x y -- void )", "EXTERN: \"C\" void glWindowPos2i( int x, int y );", "	( x y -- )" );
	swigFunction( "c-function glWindowPos2iv glWindowPos2iv a -- void", "FUNCTION: glWindowPos2iv ( v -- void )", "EXTERN: \"C\" void glWindowPos2iv( void * v );", "	( v -- )" );
	swigFunction( "c-function glWindowPos2s glWindowPos2s n n -- void", "FUNCTION: glWindowPos2s ( x y -- void )", "EXTERN: \"C\" void glWindowPos2s( short x, short y );", "	( x y -- )" );
	swigFunction( "c-function glWindowPos2sv glWindowPos2sv a -- void", "FUNCTION: glWindowPos2sv ( v -- void )", "EXTERN: \"C\" void glWindowPos2sv( void * v );", "	( v -- )" );
	swigFunction( "c-function glWindowPos3d glWindowPos3d r r r -- void", "FUNCTION: glWindowPos3d ( x y z -- void )", "EXTERN: \"C\" void glWindowPos3d( double x, double y, double z );", "	( x y z -- )" );
	swigFunction( "c-function glWindowPos3dv glWindowPos3dv a -- void", "FUNCTION: glWindowPos3dv ( v -- void )", "EXTERN: \"C\" void glWindowPos3dv( void * v );", "	( v -- )" );
	swigFunction( "c-function glWindowPos3f glWindowPos3f r r r -- void", "FUNCTION: glWindowPos3f ( x y z -- void )", "EXTERN: \"C\" void glWindowPos3f( float x, float y, float z );", "	( x y z -- )" );
	swigFunction( "c-function glWindowPos3fv glWindowPos3fv a -- void", "FUNCTION: glWindowPos3fv ( v -- void )", "EXTERN: \"C\" void glWindowPos3fv( void * v );", "	( v -- )" );
	swigFunction( "c-function glWindowPos3i glWindowPos3i n n n -- void", "FUNCTION: glWindowPos3i ( x y z -- void )", "EXTERN: \"C\" void glWindowPos3i( int x, int y, int z );", "	( x y z -- )" );
	swigFunction( "c-function glWindowPos3iv glWindowPos3iv a -- void", "FUNCTION: glWindowPos3iv ( v -- void )", "EXTERN: \"C\" void glWindowPos3iv( void * v );", "	( v -- )" );
	swigFunction( "c-function glWindowPos3s glWindowPos3s n n n -- void", "FUNCTION: glWindowPos3s ( x y z -- void )", "EXTERN: \"C\" void glWindowPos3s( short x, short y, short z );", "	( x y z -- )" );
	swigFunction( "c-function glWindowPos3sv glWindowPos3sv a -- void", "FUNCTION: glWindowPos3sv ( v -- void )", "EXTERN: \"C\" void glWindowPos3sv( void * v );", "	( v -- )" );
	swigFunction( "c-function glGenQueries glGenQueries n a -- void", "FUNCTION: glGenQueries ( n ids -- void )", "EXTERN: \"C\" void glGenQueries( int n, void * ids );", "	( n ids -- )" );
	swigFunction( "c-function glDeleteQueries glDeleteQueries n a -- void", "FUNCTION: glDeleteQueries ( n ids -- void )", "EXTERN: \"C\" void glDeleteQueries( int n, void * ids );", "	( n ids -- )" );
	swigFunction( "c-function glIsQuery glIsQuery u -- u", "FUNCTION: glIsQuery ( id -- u )", "EXTERN: \"C\" char glIsQuery( int id );", "	( id -- )" );
	swigFunction( "c-function glBeginQuery glBeginQuery u u -- void", "FUNCTION: glBeginQuery ( target id -- void )", "EXTERN: \"C\" void glBeginQuery( int target, int id );", "	( target id -- )" );
	swigFunction( "c-function glEndQuery glEndQuery u -- void", "FUNCTION: glEndQuery ( target -- void )", "EXTERN: \"C\" void glEndQuery( int target );", "	( target -- )" );
	swigFunction( "c-function glGetQueryiv glGetQueryiv u u a -- void", "FUNCTION: glGetQueryiv ( target pname params -- void )", "EXTERN: \"C\" void glGetQueryiv( int target, int pname, void * params );", "	( target pname params -- )" );
	swigFunction( "c-function glGetQueryObjectiv glGetQueryObjectiv u u a -- void", "FUNCTION: glGetQueryObjectiv ( id pname params -- void )", "EXTERN: \"C\" void glGetQueryObjectiv( int id, int pname, void * params );", "	( id pname params -- )" );
	swigFunction( "c-function glGetQueryObjectuiv glGetQueryObjectuiv u u a -- void", "FUNCTION: glGetQueryObjectuiv ( id pname params -- void )", "EXTERN: \"C\" void glGetQueryObjectuiv( int id, int pname, void * params );", "	( id pname params -- )" );
	swigFunction( "c-function glBindBuffer glBindBuffer u u -- void", "FUNCTION: glBindBuffer ( target buffer -- void )", "EXTERN: \"C\" void glBindBuffer( int target, int buffer );", "	( target buffer -- )" );
	swigFunction( "c-function glDeleteBuffers glDeleteBuffers n a -- void", "FUNCTION: glDeleteBuffers ( n buffers -- void )", "EXTERN: \"C\" void glDeleteBuffers( int n, void * buffers );", "	( n buffers -- )" );
	swigFunction( "c-function glGenBuffers glGenBuffers n a -- void", "FUNCTION: glGenBuffers ( n buffers -- void )", "EXTERN: \"C\" void glGenBuffers( int n, void * buffers );", "	( n buffers -- )" );
	swigFunction( "c-function glIsBuffer glIsBuffer u -- u", "FUNCTION: glIsBuffer ( buffer -- u )", "EXTERN: \"C\" char glIsBuffer( int buffer );", "	( buffer -- )" );
	swigFunction( "c-function glBufferData glBufferData u n a u -- void", "FUNCTION: glBufferData ( target size data usage -- void )", "EXTERN: \"C\" void glBufferData( int target, long size, void * data, int usage );", "	( target size data usage -- )" );
	swigFunction( "c-function glBufferSubData glBufferSubData u n n a -- void", "FUNCTION: glBufferSubData ( target offset size data -- void )", "EXTERN: \"C\" void glBufferSubData( int target, long offset, long size, void * data );", "	( target offset size data -- )" );
	swigFunction( "c-function glGetBufferSubData glGetBufferSubData u n n a -- void", "FUNCTION: glGetBufferSubData ( target offset size data -- void )", "EXTERN: \"C\" void glGetBufferSubData( int target, long offset, long size, void * data );", "	( target offset size data -- )" );
	swigFunction( "c-function glMapBuffer glMapBuffer u u -- a", "FUNCTION: glMapBuffer ( target access -- a )", "EXTERN: \"C\" void * glMapBuffer( int target, int access );", "	( target access -- )" );
	swigFunction( "c-function glUnmapBuffer glUnmapBuffer u -- u", "FUNCTION: glUnmapBuffer ( target -- u )", "EXTERN: \"C\" char glUnmapBuffer( int target );", "	( target -- )" );
	swigFunction( "c-function glGetBufferParameteriv glGetBufferParameteriv u u a -- void", "FUNCTION: glGetBufferParameteriv ( target pname params -- void )", "EXTERN: \"C\" void glGetBufferParameteriv( int target, int pname, void * params );", "	( target pname params -- )" );
	swigFunction( "c-function glGetBufferPointerv glGetBufferPointerv u u a -- void", "FUNCTION: glGetBufferPointerv ( target pname params -- void )", "EXTERN: \"C\" void glGetBufferPointerv( int target, int pname, void * params );", "	( target pname params -- )" );
	swigFunction( "c-function glBlendEquationSeparate glBlendEquationSeparate u u -- void", "FUNCTION: glBlendEquationSeparate ( modeRGB modeAlpha -- void )", "EXTERN: \"C\" void glBlendEquationSeparate( int modeRGB, int modeAlpha );", "	( modeRGB modeAlpha -- )" );
	swigFunction( "c-function glDrawBuffers glDrawBuffers n a -- void", "FUNCTION: glDrawBuffers ( n bufs -- void )", "EXTERN: \"C\" void glDrawBuffers( int n, void * bufs );", "	( n bufs -- )" );
	swigFunction( "c-function glStencilOpSeparate glStencilOpSeparate u u u u -- void", "FUNCTION: glStencilOpSeparate ( face sfail dpfail dppass -- void )", "EXTERN: \"C\" void glStencilOpSeparate( int face, int sfail, int dpfail, int dppass );", "	( face sfail dpfail dppass -- )" );
	swigFunction( "c-function glStencilFuncSeparate glStencilFuncSeparate u u n u -- void", "FUNCTION: glStencilFuncSeparate ( face func ref mask -- void )", "EXTERN: \"C\" void glStencilFuncSeparate( int face, int func, int ref, int mask );", "	( face func ref mask -- )" );
	swigFunction( "c-function glStencilMaskSeparate glStencilMaskSeparate u u -- void", "FUNCTION: glStencilMaskSeparate ( face mask -- void )", "EXTERN: \"C\" void glStencilMaskSeparate( int face, int mask );", "	( face mask -- )" );
	swigFunction( "c-function glAttachShader glAttachShader u u -- void", "FUNCTION: glAttachShader ( program shader -- void )", "EXTERN: \"C\" void glAttachShader( int program, int shader );", "	( program shader -- )" );
	swigFunction( "c-function glBindAttribLocation glBindAttribLocation u u s -- void", "FUNCTION: glBindAttribLocation ( program index name -- void )", "EXTERN: \"C\" void glBindAttribLocation( int program, int index, char * name );", "	( program index name -- )" );
	swigFunction( "c-function glCompileShader glCompileShader u -- void", "FUNCTION: glCompileShader ( shader -- void )", "EXTERN: \"C\" void glCompileShader( int shader );", "	( shader -- )" );
	swigFunction( "c-function glCreateProgram glCreateProgram  -- u", "FUNCTION: glCreateProgram (  -- u )", "EXTERN: \"C\" int glCreateProgram(  );", "	( -- )" );
	swigFunction( "c-function glCreateShader glCreateShader u -- u", "FUNCTION: glCreateShader ( type -- u )", "EXTERN: \"C\" int glCreateShader( int type );", "	( type -- )" );
	swigFunction( "c-function glDeleteProgram glDeleteProgram u -- void", "FUNCTION: glDeleteProgram ( program -- void )", "EXTERN: \"C\" void glDeleteProgram( int program );", "	( program -- )" );
	swigFunction( "c-function glDeleteShader glDeleteShader u -- void", "FUNCTION: glDeleteShader ( shader -- void )", "EXTERN: \"C\" void glDeleteShader( int shader );", "	( shader -- )" );
	swigFunction( "c-function glDetachShader glDetachShader u u -- void", "FUNCTION: glDetachShader ( program shader -- void )", "EXTERN: \"C\" void glDetachShader( int program, int shader );", "	( program shader -- )" );
	swigFunction( "c-function glDisableVertexAttribArray glDisableVertexAttribArray u -- void", "FUNCTION: glDisableVertexAttribArray ( index -- void )", "EXTERN: \"C\" void glDisableVertexAttribArray( int index );", "	( index -- )" );
	swigFunction( "c-function glEnableVertexAttribArray glEnableVertexAttribArray u -- void", "FUNCTION: glEnableVertexAttribArray ( index -- void )", "EXTERN: \"C\" void glEnableVertexAttribArray( int index );", "	( index -- )" );
	swigFunction( "c-function glGetActiveAttrib glGetActiveAttrib u u n a a a a -- void", "FUNCTION: glGetActiveAttrib ( program index bufSize length size type name -- void )", "EXTERN: \"C\" void glGetActiveAttrib( int program, int index, int bufSize, void * length, void * size, void * type, void * name );", "	( program index bufSize length size type name -- )" );
	swigFunction( "c-function glGetActiveUniform glGetActiveUniform u u n a a a a -- void", "FUNCTION: glGetActiveUniform ( program index bufSize length size type name -- void )", "EXTERN: \"C\" void glGetActiveUniform( int program, int index, int bufSize, void * length, void * size, void * type, void * name );", "	( program index bufSize length size type name -- )" );
	swigFunction( "c-function glGetAttachedShaders glGetAttachedShaders u n a a -- void", "FUNCTION: glGetAttachedShaders ( program maxCount count shaders -- void )", "EXTERN: \"C\" void glGetAttachedShaders( int program, int maxCount, void * count, void * shaders );", "	( program maxCount count shaders -- )" );
	swigFunction( "c-function glGetAttribLocation glGetAttribLocation u s -- n", "FUNCTION: glGetAttribLocation ( program name -- n )", "EXTERN: \"C\" int glGetAttribLocation( int program, char * name );", "	( program name -- )" );
	swigFunction( "c-function glGetProgramiv glGetProgramiv u u a -- void", "FUNCTION: glGetProgramiv ( program pname params -- void )", "EXTERN: \"C\" void glGetProgramiv( int program, int pname, void * params );", "	( program pname params -- )" );
	swigFunction( "c-function glGetProgramInfoLog glGetProgramInfoLog u n a a -- void", "FUNCTION: glGetProgramInfoLog ( program bufSize length infoLog -- void )", "EXTERN: \"C\" void glGetProgramInfoLog( int program, int bufSize, void * length, void * infoLog );", "	( program bufSize length infoLog -- )" );
	swigFunction( "c-function glGetShaderiv glGetShaderiv u u a -- void", "FUNCTION: glGetShaderiv ( shader pname params -- void )", "EXTERN: \"C\" void glGetShaderiv( int shader, int pname, void * params );", "	( shader pname params -- )" );
	swigFunction( "c-function glGetShaderInfoLog glGetShaderInfoLog u n a a -- void", "FUNCTION: glGetShaderInfoLog ( shader bufSize length infoLog -- void )", "EXTERN: \"C\" void glGetShaderInfoLog( int shader, int bufSize, void * length, void * infoLog );", "	( shader bufSize length infoLog -- )" );
	swigFunction( "c-function glGetShaderSource glGetShaderSource u n a a -- void", "FUNCTION: glGetShaderSource ( shader bufSize length source -- void )", "EXTERN: \"C\" void glGetShaderSource( int shader, int bufSize, void * length, void * source );", "	( shader bufSize length source -- )" );
	swigFunction( "c-function glGetUniformLocation glGetUniformLocation u s -- n", "FUNCTION: glGetUniformLocation ( program name -- n )", "EXTERN: \"C\" int glGetUniformLocation( int program, char * name );", "	( program name -- )" );
	swigFunction( "c-function glGetUniformfv glGetUniformfv u n a -- void", "FUNCTION: glGetUniformfv ( program location params -- void )", "EXTERN: \"C\" void glGetUniformfv( int program, int location, void * params );", "	( program location params -- )" );
	swigFunction( "c-function glGetUniformiv glGetUniformiv u n a -- void", "FUNCTION: glGetUniformiv ( program location params -- void )", "EXTERN: \"C\" void glGetUniformiv( int program, int location, void * params );", "	( program location params -- )" );
	swigFunction( "c-function glGetVertexAttribdv glGetVertexAttribdv u u a -- void", "FUNCTION: glGetVertexAttribdv ( index pname params -- void )", "EXTERN: \"C\" void glGetVertexAttribdv( int index, int pname, void * params );", "	( index pname params -- )" );
	swigFunction( "c-function glGetVertexAttribfv glGetVertexAttribfv u u a -- void", "FUNCTION: glGetVertexAttribfv ( index pname params -- void )", "EXTERN: \"C\" void glGetVertexAttribfv( int index, int pname, void * params );", "	( index pname params -- )" );
	swigFunction( "c-function glGetVertexAttribiv glGetVertexAttribiv u u a -- void", "FUNCTION: glGetVertexAttribiv ( index pname params -- void )", "EXTERN: \"C\" void glGetVertexAttribiv( int index, int pname, void * params );", "	( index pname params -- )" );
	swigFunction( "c-function glGetVertexAttribPointerv glGetVertexAttribPointerv u u a -- void", "FUNCTION: glGetVertexAttribPointerv ( index pname pointer -- void )", "EXTERN: \"C\" void glGetVertexAttribPointerv( int index, int pname, void * pointer );", "	( index pname pointer -- )" );
	swigFunction( "c-function glIsProgram glIsProgram u -- u", "FUNCTION: glIsProgram ( program -- u )", "EXTERN: \"C\" char glIsProgram( int program );", "	( program -- )" );
	swigFunction( "c-function glIsShader glIsShader u -- u", "FUNCTION: glIsShader ( shader -- u )", "EXTERN: \"C\" char glIsShader( int shader );", "	( shader -- )" );
	swigFunction( "c-function glLinkProgram glLinkProgram u -- void", "FUNCTION: glLinkProgram ( program -- void )", "EXTERN: \"C\" void glLinkProgram( int program );", "	( program -- )" );
	swigFunction( "c-function glShaderSource glShaderSource u n a a -- void", "FUNCTION: glShaderSource ( shader count string length -- void )", "EXTERN: \"C\" void glShaderSource( int shader, int count, void * string, void * length );", "	( shader count string length -- )" );
	swigFunction( "c-function glUseProgram glUseProgram u -- void", "FUNCTION: glUseProgram ( program -- void )", "EXTERN: \"C\" void glUseProgram( int program );", "	( program -- )" );
	swigFunction( "c-function glUniform1f glUniform1f n r -- void", "FUNCTION: glUniform1f ( location v0 -- void )", "EXTERN: \"C\" void glUniform1f( int location, float v0 );", "	( location v0 -- )" );
	swigFunction( "c-function glUniform2f glUniform2f n r r -- void", "FUNCTION: glUniform2f ( location v0 v1 -- void )", "EXTERN: \"C\" void glUniform2f( int location, float v0, float v1 );", "	( location v0 v1 -- )" );
	swigFunction( "c-function glUniform3f glUniform3f n r r r -- void", "FUNCTION: glUniform3f ( location v0 v1 v2 -- void )", "EXTERN: \"C\" void glUniform3f( int location, float v0, float v1, float v2 );", "	( location v0 v1 v2 -- )" );
	swigFunction( "c-function glUniform4f glUniform4f n r r r r -- void", "FUNCTION: glUniform4f ( location v0 v1 v2 v3 -- void )", "EXTERN: \"C\" void glUniform4f( int location, float v0, float v1, float v2, float v3 );", "	( location v0 v1 v2 v3 -- )" );
	swigFunction( "c-function glUniform1i glUniform1i n n -- void", "FUNCTION: glUniform1i ( location v0 -- void )", "EXTERN: \"C\" void glUniform1i( int location, int v0 );", "	( location v0 -- )" );
	swigFunction( "c-function glUniform2i glUniform2i n n n -- void", "FUNCTION: glUniform2i ( location v0 v1 -- void )", "EXTERN: \"C\" void glUniform2i( int location, int v0, int v1 );", "	( location v0 v1 -- )" );
	swigFunction( "c-function glUniform3i glUniform3i n n n n -- void", "FUNCTION: glUniform3i ( location v0 v1 v2 -- void )", "EXTERN: \"C\" void glUniform3i( int location, int v0, int v1, int v2 );", "	( location v0 v1 v2 -- )" );
	swigFunction( "c-function glUniform4i glUniform4i n n n n n -- void", "FUNCTION: glUniform4i ( location v0 v1 v2 v3 -- void )", "EXTERN: \"C\" void glUniform4i( int location, int v0, int v1, int v2, int v3 );", "	( location v0 v1 v2 v3 -- )" );
	swigFunction( "c-function glUniform1fv glUniform1fv n n a -- void", "FUNCTION: glUniform1fv ( location count value -- void )", "EXTERN: \"C\" void glUniform1fv( int location, int count, void * value );", "	( location count value -- )" );
	swigFunction( "c-function glUniform2fv glUniform2fv n n a -- void", "FUNCTION: glUniform2fv ( location count value -- void )", "EXTERN: \"C\" void glUniform2fv( int location, int count, void * value );", "	( location count value -- )" );
	swigFunction( "c-function glUniform3fv glUniform3fv n n a -- void", "FUNCTION: glUniform3fv ( location count value -- void )", "EXTERN: \"C\" void glUniform3fv( int location, int count, void * value );", "	( location count value -- )" );
	swigFunction( "c-function glUniform4fv glUniform4fv n n a -- void", "FUNCTION: glUniform4fv ( location count value -- void )", "EXTERN: \"C\" void glUniform4fv( int location, int count, void * value );", "	( location count value -- )" );
	swigFunction( "c-function glUniform1iv glUniform1iv n n a -- void", "FUNCTION: glUniform1iv ( location count value -- void )", "EXTERN: \"C\" void glUniform1iv( int location, int count, void * value );", "	( location count value -- )" );
	swigFunction( "c-function glUniform2iv glUniform2iv n n a -- void", "FUNCTION: glUniform2iv ( location count value -- void )", "EXTERN: \"C\" void glUniform2iv( int location, int count, void * value );", "	( location count value -- )" );
	swigFunction( "c-function glUniform3iv glUniform3iv n n a -- void", "FUNCTION: glUniform3iv ( location count value -- void )", "EXTERN: \"C\" void glUniform3iv( int location, int count, void * value );", "	( location count value -- )" );
	swigFunction( "c-function glUniform4iv glUniform4iv n n a -- void", "FUNCTION: glUniform4iv ( location count value -- void )", "EXTERN: \"C\" void glUniform4iv( int location, int count, void * value );", "	( location count value -- )" );
	swigFunction( "c-function glUniformMatrix2fv glUniformMatrix2fv n n u a -- void", "FUNCTION: glUniformMatrix2fv ( location count transpose value -- void )", "EXTERN: \"C\" void glUniformMatrix2fv( int location, int count, char transpose, void * value );", "	( location count transpose value -- )" );
	swigFunction( "c-function glUniformMatrix3fv glUniformMatrix3fv n n u a -- void", "FUNCTION: glUniformMatrix3fv ( location count transpose value -- void )", "EXTERN: \"C\" void glUniformMatrix3fv( int location, int count, char transpose, void * value );", "	( location count transpose value -- )" );
	swigFunction( "c-function glUniformMatrix4fv glUniformMatrix4fv n n u a -- void", "FUNCTION: glUniformMatrix4fv ( location count transpose value -- void )", "EXTERN: \"C\" void glUniformMatrix4fv( int location, int count, char transpose, void * value );", "	( location count transpose value -- )" );
	swigFunction( "c-function glValidateProgram glValidateProgram u -- void", "FUNCTION: glValidateProgram ( program -- void )", "EXTERN: \"C\" void glValidateProgram( int program );", "	( program -- )" );
	swigFunction( "c-function glVertexAttrib1d glVertexAttrib1d u r -- void", "FUNCTION: glVertexAttrib1d ( index x -- void )", "EXTERN: \"C\" void glVertexAttrib1d( int index, double x );", "	( index x -- )" );
	swigFunction( "c-function glVertexAttrib1dv glVertexAttrib1dv u a -- void", "FUNCTION: glVertexAttrib1dv ( index v -- void )", "EXTERN: \"C\" void glVertexAttrib1dv( int index, void * v );", "	( index v -- )" );
	swigFunction( "c-function glVertexAttrib1f glVertexAttrib1f u r -- void", "FUNCTION: glVertexAttrib1f ( index x -- void )", "EXTERN: \"C\" void glVertexAttrib1f( int index, float x );", "	( index x -- )" );
	swigFunction( "c-function glVertexAttrib1fv glVertexAttrib1fv u a -- void", "FUNCTION: glVertexAttrib1fv ( index v -- void )", "EXTERN: \"C\" void glVertexAttrib1fv( int index, void * v );", "	( index v -- )" );
	swigFunction( "c-function glVertexAttrib1s glVertexAttrib1s u n -- void", "FUNCTION: glVertexAttrib1s ( index x -- void )", "EXTERN: \"C\" void glVertexAttrib1s( int index, short x );", "	( index x -- )" );
	swigFunction( "c-function glVertexAttrib1sv glVertexAttrib1sv u a -- void", "FUNCTION: glVertexAttrib1sv ( index v -- void )", "EXTERN: \"C\" void glVertexAttrib1sv( int index, void * v );", "	( index v -- )" );
	swigFunction( "c-function glVertexAttrib2d glVertexAttrib2d u r r -- void", "FUNCTION: glVertexAttrib2d ( index x y -- void )", "EXTERN: \"C\" void glVertexAttrib2d( int index, double x, double y );", "	( index x y -- )" );
	swigFunction( "c-function glVertexAttrib2dv glVertexAttrib2dv u a -- void", "FUNCTION: glVertexAttrib2dv ( index v -- void )", "EXTERN: \"C\" void glVertexAttrib2dv( int index, void * v );", "	( index v -- )" );
	swigFunction( "c-function glVertexAttrib2f glVertexAttrib2f u r r -- void", "FUNCTION: glVertexAttrib2f ( index x y -- void )", "EXTERN: \"C\" void glVertexAttrib2f( int index, float x, float y );", "	( index x y -- )" );
	swigFunction( "c-function glVertexAttrib2fv glVertexAttrib2fv u a -- void", "FUNCTION: glVertexAttrib2fv ( index v -- void )", "EXTERN: \"C\" void glVertexAttrib2fv( int index, void * v );", "	( index v -- )" );
	swigFunction( "c-function glVertexAttrib2s glVertexAttrib2s u n n -- void", "FUNCTION: glVertexAttrib2s ( index x y -- void )", "EXTERN: \"C\" void glVertexAttrib2s( int index, short x, short y );", "	( index x y -- )" );
	swigFunction( "c-function glVertexAttrib2sv glVertexAttrib2sv u a -- void", "FUNCTION: glVertexAttrib2sv ( index v -- void )", "EXTERN: \"C\" void glVertexAttrib2sv( int index, void * v );", "	( index v -- )" );
	swigFunction( "c-function glVertexAttrib3d glVertexAttrib3d u r r r -- void", "FUNCTION: glVertexAttrib3d ( index x y z -- void )", "EXTERN: \"C\" void glVertexAttrib3d( int index, double x, double y, double z );", "	( index x y z -- )" );
	swigFunction( "c-function glVertexAttrib3dv glVertexAttrib3dv u a -- void", "FUNCTION: glVertexAttrib3dv ( index v -- void )", "EXTERN: \"C\" void glVertexAttrib3dv( int index, void * v );", "	( index v -- )" );
	swigFunction( "c-function glVertexAttrib3f glVertexAttrib3f u r r r -- void", "FUNCTION: glVertexAttrib3f ( index x y z -- void )", "EXTERN: \"C\" void glVertexAttrib3f( int index, float x, float y, float z );", "	( index x y z -- )" );
	swigFunction( "c-function glVertexAttrib3fv glVertexAttrib3fv u a -- void", "FUNCTION: glVertexAttrib3fv ( index v -- void )", "EXTERN: \"C\" void glVertexAttrib3fv( int index, void * v );", "	( index v -- )" );
	swigFunction( "c-function glVertexAttrib3s glVertexAttrib3s u n n n -- void", "FUNCTION: glVertexAttrib3s ( index x y z -- void )", "EXTERN: \"C\" void glVertexAttrib3s( int index, short x, short y, short z );", "	( index x y z -- )" );
	swigFunction( "c-function glVertexAttrib3sv glVertexAttrib3sv u a -- void", "FUNCTION: glVertexAttrib3sv ( index v -- void )", "EXTERN: \"C\" void glVertexAttrib3sv( int index, void * v );", "	( index v -- )" );
	swigFunction( "c-function glVertexAttrib4Nbv glVertexAttrib4Nbv u a -- void", "FUNCTION: glVertexAttrib4Nbv ( index v -- void )", "EXTERN: \"C\" void glVertexAttrib4Nbv( int index, void * v );", "	( index v -- )" );
	swigFunction( "c-function glVertexAttrib4Niv glVertexAttrib4Niv u a -- void", "FUNCTION: glVertexAttrib4Niv ( index v -- void )", "EXTERN: \"C\" void glVertexAttrib4Niv( int index, void * v );", "	( index v -- )" );
	swigFunction( "c-function glVertexAttrib4Nsv glVertexAttrib4Nsv u a -- void", "FUNCTION: glVertexAttrib4Nsv ( index v -- void )", "EXTERN: \"C\" void glVertexAttrib4Nsv( int index, void * v );", "	( index v -- )" );
	swigFunction( "c-function glVertexAttrib4Nub glVertexAttrib4Nub u u u u u -- void", "FUNCTION: glVertexAttrib4Nub ( index x y z w -- void )", "EXTERN: \"C\" void glVertexAttrib4Nub( int index, char x, char y, char z, char w );", "	( index x y z w -- )" );
	swigFunction( "c-function glVertexAttrib4Nubv glVertexAttrib4Nubv u a -- void", "FUNCTION: glVertexAttrib4Nubv ( index v -- void )", "EXTERN: \"C\" void glVertexAttrib4Nubv( int index, void * v );", "	( index v -- )" );
	swigFunction( "c-function glVertexAttrib4Nuiv glVertexAttrib4Nuiv u a -- void", "FUNCTION: glVertexAttrib4Nuiv ( index v -- void )", "EXTERN: \"C\" void glVertexAttrib4Nuiv( int index, void * v );", "	( index v -- )" );
	swigFunction( "c-function glVertexAttrib4Nusv glVertexAttrib4Nusv u a -- void", "FUNCTION: glVertexAttrib4Nusv ( index v -- void )", "EXTERN: \"C\" void glVertexAttrib4Nusv( int index, void * v );", "	( index v -- )" );
	swigFunction( "c-function glVertexAttrib4bv glVertexAttrib4bv u a -- void", "FUNCTION: glVertexAttrib4bv ( index v -- void )", "EXTERN: \"C\" void glVertexAttrib4bv( int index, void * v );", "	( index v -- )" );
	swigFunction( "c-function glVertexAttrib4d glVertexAttrib4d u r r r r -- void", "FUNCTION: glVertexAttrib4d ( index x y z w -- void )", "EXTERN: \"C\" void glVertexAttrib4d( int index, double x, double y, double z, double w );", "	( index x y z w -- )" );
	swigFunction( "c-function glVertexAttrib4dv glVertexAttrib4dv u a -- void", "FUNCTION: glVertexAttrib4dv ( index v -- void )", "EXTERN: \"C\" void glVertexAttrib4dv( int index, void * v );", "	( index v -- )" );
	swigFunction( "c-function glVertexAttrib4f glVertexAttrib4f u r r r r -- void", "FUNCTION: glVertexAttrib4f ( index x y z w -- void )", "EXTERN: \"C\" void glVertexAttrib4f( int index, float x, float y, float z, float w );", "	( index x y z w -- )" );
	swigFunction( "c-function glVertexAttrib4fv glVertexAttrib4fv u a -- void", "FUNCTION: glVertexAttrib4fv ( index v -- void )", "EXTERN: \"C\" void glVertexAttrib4fv( int index, void * v );", "	( index v -- )" );
	swigFunction( "c-function glVertexAttrib4iv glVertexAttrib4iv u a -- void", "FUNCTION: glVertexAttrib4iv ( index v -- void )", "EXTERN: \"C\" void glVertexAttrib4iv( int index, void * v );", "	( index v -- )" );
	swigFunction( "c-function glVertexAttrib4s glVertexAttrib4s u n n n n -- void", "FUNCTION: glVertexAttrib4s ( index x y z w -- void )", "EXTERN: \"C\" void glVertexAttrib4s( int index, short x, short y, short z, short w );", "	( index x y z w -- )" );
	swigFunction( "c-function glVertexAttrib4sv glVertexAttrib4sv u a -- void", "FUNCTION: glVertexAttrib4sv ( index v -- void )", "EXTERN: \"C\" void glVertexAttrib4sv( int index, void * v );", "	( index v -- )" );
	swigFunction( "c-function glVertexAttrib4ubv glVertexAttrib4ubv u a -- void", "FUNCTION: glVertexAttrib4ubv ( index v -- void )", "EXTERN: \"C\" void glVertexAttrib4ubv( int index, void * v );", "	( index v -- )" );
	swigFunction( "c-function glVertexAttrib4uiv glVertexAttrib4uiv u a -- void", "FUNCTION: glVertexAttrib4uiv ( index v -- void )", "EXTERN: \"C\" void glVertexAttrib4uiv( int index, void * v );", "	( index v -- )" );
	swigFunction( "c-function glVertexAttrib4usv glVertexAttrib4usv u a -- void", "FUNCTION: glVertexAttrib4usv ( index v -- void )", "EXTERN: \"C\" void glVertexAttrib4usv( int index, void * v );", "	( index v -- )" );
	swigFunction( "c-function glVertexAttribPointer glVertexAttribPointer u n u u n a -- void", "FUNCTION: glVertexAttribPointer ( index size type normalized stride pointer -- void )", "EXTERN: \"C\" void glVertexAttribPointer( int index, int size, int type, char normalized, int stride, void * pointer );", "	( index size type normalized stride pointer -- )" );
	swigFunction( "c-function glUniformMatrix2x3fv glUniformMatrix2x3fv n n u a -- void", "FUNCTION: glUniformMatrix2x3fv ( location count transpose value -- void )", "EXTERN: \"C\" void glUniformMatrix2x3fv( int location, int count, char transpose, void * value );", "	( location count transpose value -- )" );
	swigFunction( "c-function glUniformMatrix3x2fv glUniformMatrix3x2fv n n u a -- void", "FUNCTION: glUniformMatrix3x2fv ( location count transpose value -- void )", "EXTERN: \"C\" void glUniformMatrix3x2fv( int location, int count, char transpose, void * value );", "	( location count transpose value -- )" );
	swigFunction( "c-function glUniformMatrix2x4fv glUniformMatrix2x4fv n n u a -- void", "FUNCTION: glUniformMatrix2x4fv ( location count transpose value -- void )", "EXTERN: \"C\" void glUniformMatrix2x4fv( int location, int count, char transpose, void * value );", "	( location count transpose value -- )" );
	swigFunction( "c-function glUniformMatrix4x2fv glUniformMatrix4x2fv n n u a -- void", "FUNCTION: glUniformMatrix4x2fv ( location count transpose value -- void )", "EXTERN: \"C\" void glUniformMatrix4x2fv( int location, int count, char transpose, void * value );", "	( location count transpose value -- )" );
	swigFunction( "c-function glUniformMatrix3x4fv glUniformMatrix3x4fv n n u a -- void", "FUNCTION: glUniformMatrix3x4fv ( location count transpose value -- void )", "EXTERN: \"C\" void glUniformMatrix3x4fv( int location, int count, char transpose, void * value );", "	( location count transpose value -- )" );
	swigFunction( "c-function glUniformMatrix4x3fv glUniformMatrix4x3fv n n u a -- void", "FUNCTION: glUniformMatrix4x3fv ( location count transpose value -- void )", "EXTERN: \"C\" void glUniformMatrix4x3fv( int location, int count, char transpose, void * value );", "	( location count transpose value -- )" );
	swigFunction( "c-function glColorMaski glColorMaski u u u u u -- void", "FUNCTION: glColorMaski ( index r g b a -- void )", "EXTERN: \"C\" void glColorMaski( int index, char r, char g, char b, char a );", "	( index r g b a -- )" );
	swigFunction( "c-function glGetBooleani_v glGetBooleani_v u u a -- void", "FUNCTION: glGetBooleani_v ( target index data -- void )", "EXTERN: \"C\" void glGetBooleani_v( int target, int index, void * data );", "	( target index data -- )" );
	swigFunction( "c-function glGetIntegeri_v glGetIntegeri_v u u a -- void", "FUNCTION: glGetIntegeri_v ( target index data -- void )", "EXTERN: \"C\" void glGetIntegeri_v( int target, int index, void * data );", "	( target index data -- )" );
	swigFunction( "c-function glEnablei glEnablei u u -- void", "FUNCTION: glEnablei ( target index -- void )", "EXTERN: \"C\" void glEnablei( int target, int index );", "	( target index -- )" );
	swigFunction( "c-function glDisablei glDisablei u u -- void", "FUNCTION: glDisablei ( target index -- void )", "EXTERN: \"C\" void glDisablei( int target, int index );", "	( target index -- )" );
	swigFunction( "c-function glIsEnabledi glIsEnabledi u u -- u", "FUNCTION: glIsEnabledi ( target index -- u )", "EXTERN: \"C\" char glIsEnabledi( int target, int index );", "	( target index -- )" );
	swigFunction( "c-function glBeginTransformFeedback glBeginTransformFeedback u -- void", "FUNCTION: glBeginTransformFeedback ( primitiveMode -- void )", "EXTERN: \"C\" void glBeginTransformFeedback( int primitiveMode );", "	( primitiveMode -- )" );
	swigFunction( "c-function glEndTransformFeedback glEndTransformFeedback  -- void", "FUNCTION: glEndTransformFeedback (  -- void )", "EXTERN: \"C\" void glEndTransformFeedback(  );", "	( -- )" );
	swigFunction( "c-function glBindBufferRange glBindBufferRange u u u n n -- void", "FUNCTION: glBindBufferRange ( target index buffer offset size -- void )", "EXTERN: \"C\" void glBindBufferRange( int target, int index, int buffer, long offset, long size );", "	( target index buffer offset size -- )" );
	swigFunction( "c-function glBindBufferBase glBindBufferBase u u u -- void", "FUNCTION: glBindBufferBase ( target index buffer -- void )", "EXTERN: \"C\" void glBindBufferBase( int target, int index, int buffer );", "	( target index buffer -- )" );
	swigFunction( "c-function glTransformFeedbackVaryings glTransformFeedbackVaryings u n a u -- void", "FUNCTION: glTransformFeedbackVaryings ( program count varyings bufferMode -- void )", "EXTERN: \"C\" void glTransformFeedbackVaryings( int program, int count, void * varyings, int bufferMode );", "	( program count varyings bufferMode -- )" );
	swigFunction( "c-function glGetTransformFeedbackVarying glGetTransformFeedbackVarying u u n a a a a -- void", "FUNCTION: glGetTransformFeedbackVarying ( program index bufSize length size type name -- void )", "EXTERN: \"C\" void glGetTransformFeedbackVarying( int program, int index, int bufSize, void * length, void * size, void * type, void * name );", "	( program index bufSize length size type name -- )" );
	swigFunction( "c-function glClampColor glClampColor u u -- void", "FUNCTION: glClampColor ( target clamp -- void )", "EXTERN: \"C\" void glClampColor( int target, int clamp );", "	( target clamp -- )" );
	swigFunction( "c-function glBeginConditionalRender glBeginConditionalRender u u -- void", "FUNCTION: glBeginConditionalRender ( id mode -- void )", "EXTERN: \"C\" void glBeginConditionalRender( int id, int mode );", "	( id mode -- )" );
	swigFunction( "c-function glEndConditionalRender glEndConditionalRender  -- void", "FUNCTION: glEndConditionalRender (  -- void )", "EXTERN: \"C\" void glEndConditionalRender(  );", "	( -- )" );
	swigFunction( "c-function glVertexAttribIPointer glVertexAttribIPointer u n u n a -- void", "FUNCTION: glVertexAttribIPointer ( index size type stride pointer -- void )", "EXTERN: \"C\" void glVertexAttribIPointer( int index, int size, int type, int stride, void * pointer );", "	( index size type stride pointer -- )" );
	swigFunction( "c-function glGetVertexAttribIiv glGetVertexAttribIiv u u a -- void", "FUNCTION: glGetVertexAttribIiv ( index pname params -- void )", "EXTERN: \"C\" void glGetVertexAttribIiv( int index, int pname, void * params );", "	( index pname params -- )" );
	swigFunction( "c-function glGetVertexAttribIuiv glGetVertexAttribIuiv u u a -- void", "FUNCTION: glGetVertexAttribIuiv ( index pname params -- void )", "EXTERN: \"C\" void glGetVertexAttribIuiv( int index, int pname, void * params );", "	( index pname params -- )" );
	swigFunction( "c-function glVertexAttribI1i glVertexAttribI1i u n -- void", "FUNCTION: glVertexAttribI1i ( index x -- void )", "EXTERN: \"C\" void glVertexAttribI1i( int index, int x );", "	( index x -- )" );
	swigFunction( "c-function glVertexAttribI2i glVertexAttribI2i u n n -- void", "FUNCTION: glVertexAttribI2i ( index x y -- void )", "EXTERN: \"C\" void glVertexAttribI2i( int index, int x, int y );", "	( index x y -- )" );
	swigFunction( "c-function glVertexAttribI3i glVertexAttribI3i u n n n -- void", "FUNCTION: glVertexAttribI3i ( index x y z -- void )", "EXTERN: \"C\" void glVertexAttribI3i( int index, int x, int y, int z );", "	( index x y z -- )" );
	swigFunction( "c-function glVertexAttribI4i glVertexAttribI4i u n n n n -- void", "FUNCTION: glVertexAttribI4i ( index x y z w -- void )", "EXTERN: \"C\" void glVertexAttribI4i( int index, int x, int y, int z, int w );", "	( index x y z w -- )" );
	swigFunction( "c-function glVertexAttribI1ui glVertexAttribI1ui u u -- void", "FUNCTION: glVertexAttribI1ui ( index x -- void )", "EXTERN: \"C\" void glVertexAttribI1ui( int index, int x );", "	( index x -- )" );
	swigFunction( "c-function glVertexAttribI2ui glVertexAttribI2ui u u u -- void", "FUNCTION: glVertexAttribI2ui ( index x y -- void )", "EXTERN: \"C\" void glVertexAttribI2ui( int index, int x, int y );", "	( index x y -- )" );
	swigFunction( "c-function glVertexAttribI3ui glVertexAttribI3ui u u u u -- void", "FUNCTION: glVertexAttribI3ui ( index x y z -- void )", "EXTERN: \"C\" void glVertexAttribI3ui( int index, int x, int y, int z );", "	( index x y z -- )" );
	swigFunction( "c-function glVertexAttribI4ui glVertexAttribI4ui u u u u u -- void", "FUNCTION: glVertexAttribI4ui ( index x y z w -- void )", "EXTERN: \"C\" void glVertexAttribI4ui( int index, int x, int y, int z, int w );", "	( index x y z w -- )" );
	swigFunction( "c-function glVertexAttribI1iv glVertexAttribI1iv u a -- void", "FUNCTION: glVertexAttribI1iv ( index v -- void )", "EXTERN: \"C\" void glVertexAttribI1iv( int index, void * v );", "	( index v -- )" );
	swigFunction( "c-function glVertexAttribI2iv glVertexAttribI2iv u a -- void", "FUNCTION: glVertexAttribI2iv ( index v -- void )", "EXTERN: \"C\" void glVertexAttribI2iv( int index, void * v );", "	( index v -- )" );
	swigFunction( "c-function glVertexAttribI3iv glVertexAttribI3iv u a -- void", "FUNCTION: glVertexAttribI3iv ( index v -- void )", "EXTERN: \"C\" void glVertexAttribI3iv( int index, void * v );", "	( index v -- )" );
	swigFunction( "c-function glVertexAttribI4iv glVertexAttribI4iv u a -- void", "FUNCTION: glVertexAttribI4iv ( index v -- void )", "EXTERN: \"C\" void glVertexAttribI4iv( int index, void * v );", "	( index v -- )" );
	swigFunction( "c-function glVertexAttribI1uiv glVertexAttribI1uiv u a -- void", "FUNCTION: glVertexAttribI1uiv ( index v -- void )", "EXTERN: \"C\" void glVertexAttribI1uiv( int index, void * v );", "	( index v -- )" );
	swigFunction( "c-function glVertexAttribI2uiv glVertexAttribI2uiv u a -- void", "FUNCTION: glVertexAttribI2uiv ( index v -- void )", "EXTERN: \"C\" void glVertexAttribI2uiv( int index, void * v );", "	( index v -- )" );
	swigFunction( "c-function glVertexAttribI3uiv glVertexAttribI3uiv u a -- void", "FUNCTION: glVertexAttribI3uiv ( index v -- void )", "EXTERN: \"C\" void glVertexAttribI3uiv( int index, void * v );", "	( index v -- )" );
	swigFunction( "c-function glVertexAttribI4uiv glVertexAttribI4uiv u a -- void", "FUNCTION: glVertexAttribI4uiv ( index v -- void )", "EXTERN: \"C\" void glVertexAttribI4uiv( int index, void * v );", "	( index v -- )" );
	swigFunction( "c-function glVertexAttribI4bv glVertexAttribI4bv u a -- void", "FUNCTION: glVertexAttribI4bv ( index v -- void )", "EXTERN: \"C\" void glVertexAttribI4bv( int index, void * v );", "	( index v -- )" );
	swigFunction( "c-function glVertexAttribI4sv glVertexAttribI4sv u a -- void", "FUNCTION: glVertexAttribI4sv ( index v -- void )", "EXTERN: \"C\" void glVertexAttribI4sv( int index, void * v );", "	( index v -- )" );
	swigFunction( "c-function glVertexAttribI4ubv glVertexAttribI4ubv u a -- void", "FUNCTION: glVertexAttribI4ubv ( index v -- void )", "EXTERN: \"C\" void glVertexAttribI4ubv( int index, void * v );", "	( index v -- )" );
	swigFunction( "c-function glVertexAttribI4usv glVertexAttribI4usv u a -- void", "FUNCTION: glVertexAttribI4usv ( index v -- void )", "EXTERN: \"C\" void glVertexAttribI4usv( int index, void * v );", "	( index v -- )" );
	swigFunction( "c-function glGetUniformuiv glGetUniformuiv u n a -- void", "FUNCTION: glGetUniformuiv ( program location params -- void )", "EXTERN: \"C\" void glGetUniformuiv( int program, int location, void * params );", "	( program location params -- )" );
	swigFunction( "c-function glBindFragDataLocation glBindFragDataLocation u u s -- void", "FUNCTION: glBindFragDataLocation ( program color name -- void )", "EXTERN: \"C\" void glBindFragDataLocation( int program, int color, char * name );", "	( program color name -- )" );
	swigFunction( "c-function glGetFragDataLocation glGetFragDataLocation u s -- n", "FUNCTION: glGetFragDataLocation ( program name -- n )", "EXTERN: \"C\" int glGetFragDataLocation( int program, char * name );", "	( program name -- )" );
	swigFunction( "c-function glUniform1ui glUniform1ui n u -- void", "FUNCTION: glUniform1ui ( location v0 -- void )", "EXTERN: \"C\" void glUniform1ui( int location, int v0 );", "	( location v0 -- )" );
	swigFunction( "c-function glUniform2ui glUniform2ui n u u -- void", "FUNCTION: glUniform2ui ( location v0 v1 -- void )", "EXTERN: \"C\" void glUniform2ui( int location, int v0, int v1 );", "	( location v0 v1 -- )" );
	swigFunction( "c-function glUniform3ui glUniform3ui n u u u -- void", "FUNCTION: glUniform3ui ( location v0 v1 v2 -- void )", "EXTERN: \"C\" void glUniform3ui( int location, int v0, int v1, int v2 );", "	( location v0 v1 v2 -- )" );
	swigFunction( "c-function glUniform4ui glUniform4ui n u u u u -- void", "FUNCTION: glUniform4ui ( location v0 v1 v2 v3 -- void )", "EXTERN: \"C\" void glUniform4ui( int location, int v0, int v1, int v2, int v3 );", "	( location v0 v1 v2 v3 -- )" );
	swigFunction( "c-function glUniform1uiv glUniform1uiv n n a -- void", "FUNCTION: glUniform1uiv ( location count value -- void )", "EXTERN: \"C\" void glUniform1uiv( int location, int count, void * value );", "	( location count value -- )" );
	swigFunction( "c-function glUniform2uiv glUniform2uiv n n a -- void", "FUNCTION: glUniform2uiv ( location count value -- void )", "EXTERN: \"C\" void glUniform2uiv( int location, int count, void * value );", "	( location count value -- )" );
	swigFunction( "c-function glUniform3uiv glUniform3uiv n n a -- void", "FUNCTION: glUniform3uiv ( location count value -- void )", "EXTERN: \"C\" void glUniform3uiv( int location, int count, void * value );", "	( location count value -- )" );
	swigFunction( "c-function glUniform4uiv glUniform4uiv n n a -- void", "FUNCTION: glUniform4uiv ( location count value -- void )", "EXTERN: \"C\" void glUniform4uiv( int location, int count, void * value );", "	( location count value -- )" );
	swigFunction( "c-function glTexParameterIiv glTexParameterIiv u u a -- void", "FUNCTION: glTexParameterIiv ( target pname params -- void )", "EXTERN: \"C\" void glTexParameterIiv( int target, int pname, void * params );", "	( target pname params -- )" );
	swigFunction( "c-function glTexParameterIuiv glTexParameterIuiv u u a -- void", "FUNCTION: glTexParameterIuiv ( target pname params -- void )", "EXTERN: \"C\" void glTexParameterIuiv( int target, int pname, void * params );", "	( target pname params -- )" );
	swigFunction( "c-function glGetTexParameterIiv glGetTexParameterIiv u u a -- void", "FUNCTION: glGetTexParameterIiv ( target pname params -- void )", "EXTERN: \"C\" void glGetTexParameterIiv( int target, int pname, void * params );", "	( target pname params -- )" );
	swigFunction( "c-function glGetTexParameterIuiv glGetTexParameterIuiv u u a -- void", "FUNCTION: glGetTexParameterIuiv ( target pname params -- void )", "EXTERN: \"C\" void glGetTexParameterIuiv( int target, int pname, void * params );", "	( target pname params -- )" );
	swigFunction( "c-function glClearBufferiv glClearBufferiv u n a -- void", "FUNCTION: glClearBufferiv ( buffer drawbuffer value -- void )", "EXTERN: \"C\" void glClearBufferiv( int buffer, int drawbuffer, void * value );", "	( buffer drawbuffer value -- )" );
	swigFunction( "c-function glClearBufferuiv glClearBufferuiv u n a -- void", "FUNCTION: glClearBufferuiv ( buffer drawbuffer value -- void )", "EXTERN: \"C\" void glClearBufferuiv( int buffer, int drawbuffer, void * value );", "	( buffer drawbuffer value -- )" );
	swigFunction( "c-function glClearBufferfv glClearBufferfv u n a -- void", "FUNCTION: glClearBufferfv ( buffer drawbuffer value -- void )", "EXTERN: \"C\" void glClearBufferfv( int buffer, int drawbuffer, void * value );", "	( buffer drawbuffer value -- )" );
	swigFunction( "c-function glClearBufferfi glClearBufferfi u n r n -- void", "FUNCTION: glClearBufferfi ( buffer drawbuffer depth stencil -- void )", "EXTERN: \"C\" void glClearBufferfi( int buffer, int drawbuffer, float depth, int stencil );", "	( buffer drawbuffer depth stencil -- )" );
	swigFunction( "c-function glGetStringi glGetStringi u u -- a", "FUNCTION: glGetStringi ( name index -- a )", "EXTERN: \"C\" void * glGetStringi( int name, int index );", "	( name index -- )" );
	swigFunction( "c-function glIsRenderbuffer glIsRenderbuffer u -- u", "FUNCTION: glIsRenderbuffer ( renderbuffer -- u )", "EXTERN: \"C\" char glIsRenderbuffer( int renderbuffer );", "	( renderbuffer -- )" );
	swigFunction( "c-function glBindRenderbuffer glBindRenderbuffer u u -- void", "FUNCTION: glBindRenderbuffer ( target renderbuffer -- void )", "EXTERN: \"C\" void glBindRenderbuffer( int target, int renderbuffer );", "	( target renderbuffer -- )" );
	swigFunction( "c-function glDeleteRenderbuffers glDeleteRenderbuffers n a -- void", "FUNCTION: glDeleteRenderbuffers ( n renderbuffers -- void )", "EXTERN: \"C\" void glDeleteRenderbuffers( int n, void * renderbuffers );", "	( n renderbuffers -- )" );
	swigFunction( "c-function glGenRenderbuffers glGenRenderbuffers n a -- void", "FUNCTION: glGenRenderbuffers ( n renderbuffers -- void )", "EXTERN: \"C\" void glGenRenderbuffers( int n, void * renderbuffers );", "	( n renderbuffers -- )" );
	swigFunction( "c-function glRenderbufferStorage glRenderbufferStorage u u n n -- void", "FUNCTION: glRenderbufferStorage ( target internalformat width height -- void )", "EXTERN: \"C\" void glRenderbufferStorage( int target, int internalformat, int width, int height );", "	( target internalformat width height -- )" );
	swigFunction( "c-function glGetRenderbufferParameteriv glGetRenderbufferParameteriv u u a -- void", "FUNCTION: glGetRenderbufferParameteriv ( target pname params -- void )", "EXTERN: \"C\" void glGetRenderbufferParameteriv( int target, int pname, void * params );", "	( target pname params -- )" );
	swigFunction( "c-function glIsFramebuffer glIsFramebuffer u -- u", "FUNCTION: glIsFramebuffer ( framebuffer -- u )", "EXTERN: \"C\" char glIsFramebuffer( int framebuffer );", "	( framebuffer -- )" );
	swigFunction( "c-function glBindFramebuffer glBindFramebuffer u u -- void", "FUNCTION: glBindFramebuffer ( target framebuffer -- void )", "EXTERN: \"C\" void glBindFramebuffer( int target, int framebuffer );", "	( target framebuffer -- )" );
	swigFunction( "c-function glDeleteFramebuffers glDeleteFramebuffers n a -- void", "FUNCTION: glDeleteFramebuffers ( n framebuffers -- void )", "EXTERN: \"C\" void glDeleteFramebuffers( int n, void * framebuffers );", "	( n framebuffers -- )" );
	swigFunction( "c-function glGenFramebuffers glGenFramebuffers n a -- void", "FUNCTION: glGenFramebuffers ( n framebuffers -- void )", "EXTERN: \"C\" void glGenFramebuffers( int n, void * framebuffers );", "	( n framebuffers -- )" );
	swigFunction( "c-function glCheckFramebufferStatus glCheckFramebufferStatus u -- u", "FUNCTION: glCheckFramebufferStatus ( target -- u )", "EXTERN: \"C\" int glCheckFramebufferStatus( int target );", "	( target -- )" );
	swigFunction( "c-function glFramebufferTexture1D glFramebufferTexture1D u u u u n -- void", "FUNCTION: glFramebufferTexture1D ( target attachment textarget texture level -- void )", "EXTERN: \"C\" void glFramebufferTexture1D( int target, int attachment, int textarget, int texture, int level );", "	( target attachment textarget texture level -- )" );
	swigFunction( "c-function glFramebufferTexture2D glFramebufferTexture2D u u u u n -- void", "FUNCTION: glFramebufferTexture2D ( target attachment textarget texture level -- void )", "EXTERN: \"C\" void glFramebufferTexture2D( int target, int attachment, int textarget, int texture, int level );", "	( target attachment textarget texture level -- )" );
	swigFunction( "c-function glFramebufferTexture3D glFramebufferTexture3D u u u u n n -- void", "FUNCTION: glFramebufferTexture3D ( target attachment textarget texture level zoffset -- void )", "EXTERN: \"C\" void glFramebufferTexture3D( int target, int attachment, int textarget, int texture, int level, int zoffset );", "	( target attachment textarget texture level zoffset -- )" );
	swigFunction( "c-function glFramebufferRenderbuffer glFramebufferRenderbuffer u u u u -- void", "FUNCTION: glFramebufferRenderbuffer ( target attachment renderbuffertarget renderbuffer -- void )", "EXTERN: \"C\" void glFramebufferRenderbuffer( int target, int attachment, int renderbuffertarget, int renderbuffer );", "	( target attachment renderbuffertarget renderbuffer -- )" );
	swigFunction( "c-function glGetFramebufferAttachmentParameteriv glGetFramebufferAttachmentParameteriv u u u a -- void", "FUNCTION: glGetFramebufferAttachmentParameteriv ( target attachment pname params -- void )", "EXTERN: \"C\" void glGetFramebufferAttachmentParameteriv( int target, int attachment, int pname, void * params );", "	( target attachment pname params -- )" );
	swigFunction( "c-function glGenerateMipmap glGenerateMipmap u -- void", "FUNCTION: glGenerateMipmap ( target -- void )", "EXTERN: \"C\" void glGenerateMipmap( int target );", "	( target -- )" );
	swigFunction( "c-function glBlitFramebuffer glBlitFramebuffer n n n n n n n n u u -- void", "FUNCTION: glBlitFramebuffer ( srcX0 srcY0 srcX1 srcY1 dstX0 dstY0 dstX1 dstY1 mask filter -- void )", "EXTERN: \"C\" void glBlitFramebuffer( int srcX0, int srcY0, int srcX1, int srcY1, int dstX0, int dstY0, int dstX1, int dstY1, int mask, int filter );", "	( srcX0 srcY0 srcX1 srcY1 dstX0 dstY0 dstX1 dstY1 mask filter -- )" );
	swigFunction( "c-function glRenderbufferStorageMultisample glRenderbufferStorageMultisample u n u n n -- void", "FUNCTION: glRenderbufferStorageMultisample ( target samples internalformat width height -- void )", "EXTERN: \"C\" void glRenderbufferStorageMultisample( int target, int samples, int internalformat, int width, int height );", "	( target samples internalformat width height -- )" );
	swigFunction( "c-function glFramebufferTextureLayer glFramebufferTextureLayer u u u n n -- void", "FUNCTION: glFramebufferTextureLayer ( target attachment texture level layer -- void )", "EXTERN: \"C\" void glFramebufferTextureLayer( int target, int attachment, int texture, int level, int layer );", "	( target attachment texture level layer -- )" );
	swigFunction( "c-function glMapBufferRange glMapBufferRange u n n u -- a", "FUNCTION: glMapBufferRange ( target offset length access -- a )", "EXTERN: \"C\" void * glMapBufferRange( int target, long offset, long length, int access );", "	( target offset length access -- )" );
	swigFunction( "c-function glFlushMappedBufferRange glFlushMappedBufferRange u n n -- void", "FUNCTION: glFlushMappedBufferRange ( target offset length -- void )", "EXTERN: \"C\" void glFlushMappedBufferRange( int target, long offset, long length );", "	( target offset length -- )" );
	swigFunction( "c-function glBindVertexArray glBindVertexArray u -- void", "FUNCTION: glBindVertexArray ( array -- void )", "EXTERN: \"C\" void glBindVertexArray( int array );", "	( array -- )" );
	swigFunction( "c-function glDeleteVertexArrays glDeleteVertexArrays n a -- void", "FUNCTION: glDeleteVertexArrays ( n arrays -- void )", "EXTERN: \"C\" void glDeleteVertexArrays( int n, void * arrays );", "	( n arrays -- )" );
	swigFunction( "c-function glGenVertexArrays glGenVertexArrays n a -- void", "FUNCTION: glGenVertexArrays ( n arrays -- void )", "EXTERN: \"C\" void glGenVertexArrays( int n, void * arrays );", "	( n arrays -- )" );
	swigFunction( "c-function glIsVertexArray glIsVertexArray u -- u", "FUNCTION: glIsVertexArray ( array -- u )", "EXTERN: \"C\" char glIsVertexArray( int array );", "	( array -- )" );
	swigFunction( "c-function glDrawArraysInstanced glDrawArraysInstanced u n n n -- void", "FUNCTION: glDrawArraysInstanced ( mode first count instancecount -- void )", "EXTERN: \"C\" void glDrawArraysInstanced( int mode, int first, int count, int instancecount );", "	( mode first count instancecount -- )" );
	swigFunction( "c-function glDrawElementsInstanced glDrawElementsInstanced u n u a n -- void", "FUNCTION: glDrawElementsInstanced ( mode count type indices instancecount -- void )", "EXTERN: \"C\" void glDrawElementsInstanced( int mode, int count, int type, void * indices, int instancecount );", "	( mode count type indices instancecount -- )" );
	swigFunction( "c-function glTexBuffer glTexBuffer u u u -- void", "FUNCTION: glTexBuffer ( target internalformat buffer -- void )", "EXTERN: \"C\" void glTexBuffer( int target, int internalformat, int buffer );", "	( target internalformat buffer -- )" );
	swigFunction( "c-function glPrimitiveRestartIndex glPrimitiveRestartIndex u -- void", "FUNCTION: glPrimitiveRestartIndex ( index -- void )", "EXTERN: \"C\" void glPrimitiveRestartIndex( int index );", "	( index -- )" );
	swigFunction( "c-function glCopyBufferSubData glCopyBufferSubData u u n n n -- void", "FUNCTION: glCopyBufferSubData ( readTarget writeTarget readOffset writeOffset size -- void )", "EXTERN: \"C\" void glCopyBufferSubData( int readTarget, int writeTarget, long readOffset, long writeOffset, long size );", "	( readTarget writeTarget readOffset writeOffset size -- )" );
	swigFunction( "c-function glGetUniformIndices glGetUniformIndices u n a a -- void", "FUNCTION: glGetUniformIndices ( program uniformCount uniformNames uniformIndices -- void )", "EXTERN: \"C\" void glGetUniformIndices( int program, int uniformCount, void * uniformNames, void * uniformIndices );", "	( program uniformCount uniformNames uniformIndices -- )" );
	swigFunction( "c-function glGetActiveUniformsiv glGetActiveUniformsiv u n a u a -- void", "FUNCTION: glGetActiveUniformsiv ( program uniformCount uniformIndices pname params -- void )", "EXTERN: \"C\" void glGetActiveUniformsiv( int program, int uniformCount, void * uniformIndices, int pname, void * params );", "	( program uniformCount uniformIndices pname params -- )" );
	swigFunction( "c-function glGetActiveUniformName glGetActiveUniformName u u n a a -- void", "FUNCTION: glGetActiveUniformName ( program uniformIndex bufSize length uniformName -- void )", "EXTERN: \"C\" void glGetActiveUniformName( int program, int uniformIndex, int bufSize, void * length, void * uniformName );", "	( program uniformIndex bufSize length uniformName -- )" );
	swigFunction( "c-function glGetUniformBlockIndex glGetUniformBlockIndex u s -- u", "FUNCTION: glGetUniformBlockIndex ( program uniformBlockName -- u )", "EXTERN: \"C\" int glGetUniformBlockIndex( int program, char * uniformBlockName );", "	( program uniformBlockName -- )" );
	swigFunction( "c-function glGetActiveUniformBlockiv glGetActiveUniformBlockiv u u u a -- void", "FUNCTION: glGetActiveUniformBlockiv ( program uniformBlockIndex pname params -- void )", "EXTERN: \"C\" void glGetActiveUniformBlockiv( int program, int uniformBlockIndex, int pname, void * params );", "	( program uniformBlockIndex pname params -- )" );
	swigFunction( "c-function glGetActiveUniformBlockName glGetActiveUniformBlockName u u n a a -- void", "FUNCTION: glGetActiveUniformBlockName ( program uniformBlockIndex bufSize length uniformBlockName -- void )", "EXTERN: \"C\" void glGetActiveUniformBlockName( int program, int uniformBlockIndex, int bufSize, void * length, void * uniformBlockName );", "	( program uniformBlockIndex bufSize length uniformBlockName -- )" );
	swigFunction( "c-function glUniformBlockBinding glUniformBlockBinding u u u -- void", "FUNCTION: glUniformBlockBinding ( program uniformBlockIndex uniformBlockBinding -- void )", "EXTERN: \"C\" void glUniformBlockBinding( int program, int uniformBlockIndex, int uniformBlockBinding );", "	( program uniformBlockIndex uniformBlockBinding -- )" );
	swigFunction( "c-function glDrawElementsBaseVertex glDrawElementsBaseVertex u n u a n -- void", "FUNCTION: glDrawElementsBaseVertex ( mode count type indices basevertex -- void )", "EXTERN: \"C\" void glDrawElementsBaseVertex( int mode, int count, int type, void * indices, int basevertex );", "	( mode count type indices basevertex -- )" );
	swigFunction( "c-function glDrawRangeElementsBaseVertex glDrawRangeElementsBaseVertex u u u n u a n -- void", "FUNCTION: glDrawRangeElementsBaseVertex ( mode start end count type indices basevertex -- void )", "EXTERN: \"C\" void glDrawRangeElementsBaseVertex( int mode, int start, int end, int count, int type, void * indices, int basevertex );", "	( mode start end count type indices basevertex -- )" );
	swigFunction( "c-function glDrawElementsInstancedBaseVertex glDrawElementsInstancedBaseVertex u n u a n n -- void", "FUNCTION: glDrawElementsInstancedBaseVertex ( mode count type indices instancecount basevertex -- void )", "EXTERN: \"C\" void glDrawElementsInstancedBaseVertex( int mode, int count, int type, void * indices, int instancecount, int basevertex );", "	( mode count type indices instancecount basevertex -- )" );
	swigFunction( "c-function glMultiDrawElementsBaseVertex glMultiDrawElementsBaseVertex u a u a n a -- void", "FUNCTION: glMultiDrawElementsBaseVertex ( mode count type indices drawcount basevertex -- void )", "EXTERN: \"C\" void glMultiDrawElementsBaseVertex( int mode, void * count, int type, void * indices, int drawcount, void * basevertex );", "	( mode count type indices drawcount basevertex -- )" );
	swigFunction( "c-function glProvokingVertex glProvokingVertex u -- void", "FUNCTION: glProvokingVertex ( mode -- void )", "EXTERN: \"C\" void glProvokingVertex( int mode );", "	( mode -- )" );
	swigFunction( "c-function glFenceSync glFenceSync u u -- a", "FUNCTION: glFenceSync ( condition flags -- a )", "EXTERN: \"C\" void * glFenceSync( int condition, int flags );", "	( condition flags -- )" );
	swigFunction( "c-function glIsSync glIsSync a -- u", "FUNCTION: glIsSync ( sync -- u )", "EXTERN: \"C\" char glIsSync( void * sync );", "	( sync -- )" );
	swigFunction( "c-function glDeleteSync glDeleteSync a -- void", "FUNCTION: glDeleteSync ( sync -- void )", "EXTERN: \"C\" void glDeleteSync( void * sync );", "	( sync -- )" );
	swigFunction( "c-function glClientWaitSync glClientWaitSync a u d -- u", "FUNCTION: glClientWaitSync ( sync flags timeout -- u )", "EXTERN: \"C\" int glClientWaitSync( void * sync, int flags, long long timeout );", "	( sync flags timeout -- )" );
	swigFunction( "c-function glWaitSync glWaitSync a u d -- void", "FUNCTION: glWaitSync ( sync flags timeout -- void )", "EXTERN: \"C\" void glWaitSync( void * sync, int flags, long long timeout );", "	( sync flags timeout -- )" );
	swigFunction( "c-function glGetInteger64v glGetInteger64v u a -- void", "FUNCTION: glGetInteger64v ( pname data -- void )", "EXTERN: \"C\" void glGetInteger64v( int pname, void * data );", "	( pname data -- )" );
	swigFunction( "c-function glGetSynciv glGetSynciv a u n a a -- void", "FUNCTION: glGetSynciv ( sync pname count length values -- void )", "EXTERN: \"C\" void glGetSynciv( void * sync, int pname, int count, void * length, void * values );", "	( sync pname count length values -- )" );
	swigFunction( "c-function glGetInteger64i_v glGetInteger64i_v u u a -- void", "FUNCTION: glGetInteger64i_v ( target index data -- void )", "EXTERN: \"C\" void glGetInteger64i_v( int target, int index, void * data );", "	( target index data -- )" );
	swigFunction( "c-function glGetBufferParameteri64v glGetBufferParameteri64v u u a -- void", "FUNCTION: glGetBufferParameteri64v ( target pname params -- void )", "EXTERN: \"C\" void glGetBufferParameteri64v( int target, int pname, void * params );", "	( target pname params -- )" );
	swigFunction( "c-function glFramebufferTexture glFramebufferTexture u u u n -- void", "FUNCTION: glFramebufferTexture ( target attachment texture level -- void )", "EXTERN: \"C\" void glFramebufferTexture( int target, int attachment, int texture, int level );", "	( target attachment texture level -- )" );
	swigFunction( "c-function glTexImage2DMultisample glTexImage2DMultisample u n u n n u -- void", "FUNCTION: glTexImage2DMultisample ( target samples internalformat width height fixedsamplelocations -- void )", "EXTERN: \"C\" void glTexImage2DMultisample( int target, int samples, int internalformat, int width, int height, char fixedsamplelocations );", "	( target samples internalformat width height fixedsamplelocations -- )" );
	swigFunction( "c-function glTexImage3DMultisample glTexImage3DMultisample u n u n n n u -- void", "FUNCTION: glTexImage3DMultisample ( target samples internalformat width height depth fixedsamplelocations -- void )", "EXTERN: \"C\" void glTexImage3DMultisample( int target, int samples, int internalformat, int width, int height, int depth, char fixedsamplelocations );", "	( target samples internalformat width height depth fixedsamplelocations -- )" );
	swigFunction( "c-function glGetMultisamplefv glGetMultisamplefv u u a -- void", "FUNCTION: glGetMultisamplefv ( pname index val -- void )", "EXTERN: \"C\" void glGetMultisamplefv( int pname, int index, void * val );", "	( pname index val -- )" );
	swigFunction( "c-function glSampleMaski glSampleMaski u u -- void", "FUNCTION: glSampleMaski ( maskNumber mask -- void )", "EXTERN: \"C\" void glSampleMaski( int maskNumber, int mask );", "	( maskNumber mask -- )" );
	swigFunction( "c-function glBindFragDataLocationIndexed glBindFragDataLocationIndexed u u u s -- void", "FUNCTION: glBindFragDataLocationIndexed ( program colorNumber index name -- void )", "EXTERN: \"C\" void glBindFragDataLocationIndexed( int program, int colorNumber, int index, char * name );", "	( program colorNumber index name -- )" );
	swigFunction( "c-function glGetFragDataIndex glGetFragDataIndex u s -- n", "FUNCTION: glGetFragDataIndex ( program name -- n )", "EXTERN: \"C\" int glGetFragDataIndex( int program, char * name );", "	( program name -- )" );
	swigFunction( "c-function glGenSamplers glGenSamplers n a -- void", "FUNCTION: glGenSamplers ( count samplers -- void )", "EXTERN: \"C\" void glGenSamplers( int count, void * samplers );", "	( count samplers -- )" );
	swigFunction( "c-function glDeleteSamplers glDeleteSamplers n a -- void", "FUNCTION: glDeleteSamplers ( count samplers -- void )", "EXTERN: \"C\" void glDeleteSamplers( int count, void * samplers );", "	( count samplers -- )" );
	swigFunction( "c-function glIsSampler glIsSampler u -- u", "FUNCTION: glIsSampler ( sampler -- u )", "EXTERN: \"C\" char glIsSampler( int sampler );", "	( sampler -- )" );
	swigFunction( "c-function glBindSampler glBindSampler u u -- void", "FUNCTION: glBindSampler ( unit sampler -- void )", "EXTERN: \"C\" void glBindSampler( int unit, int sampler );", "	( unit sampler -- )" );
	swigFunction( "c-function glSamplerParameteri glSamplerParameteri u u n -- void", "FUNCTION: glSamplerParameteri ( sampler pname param -- void )", "EXTERN: \"C\" void glSamplerParameteri( int sampler, int pname, int param );", "	( sampler pname param -- )" );
	swigFunction( "c-function glSamplerParameteriv glSamplerParameteriv u u a -- void", "FUNCTION: glSamplerParameteriv ( sampler pname param -- void )", "EXTERN: \"C\" void glSamplerParameteriv( int sampler, int pname, void * param );", "	( sampler pname param -- )" );
	swigFunction( "c-function glSamplerParameterf glSamplerParameterf u u r -- void", "FUNCTION: glSamplerParameterf ( sampler pname param -- void )", "EXTERN: \"C\" void glSamplerParameterf( int sampler, int pname, float param );", "	( sampler pname param -- )" );
	swigFunction( "c-function glSamplerParameterfv glSamplerParameterfv u u a -- void", "FUNCTION: glSamplerParameterfv ( sampler pname param -- void )", "EXTERN: \"C\" void glSamplerParameterfv( int sampler, int pname, void * param );", "	( sampler pname param -- )" );
	swigFunction( "c-function glSamplerParameterIiv glSamplerParameterIiv u u a -- void", "FUNCTION: glSamplerParameterIiv ( sampler pname param -- void )", "EXTERN: \"C\" void glSamplerParameterIiv( int sampler, int pname, void * param );", "	( sampler pname param -- )" );
	swigFunction( "c-function glSamplerParameterIuiv glSamplerParameterIuiv u u a -- void", "FUNCTION: glSamplerParameterIuiv ( sampler pname param -- void )", "EXTERN: \"C\" void glSamplerParameterIuiv( int sampler, int pname, void * param );", "	( sampler pname param -- )" );
	swigFunction( "c-function glGetSamplerParameteriv glGetSamplerParameteriv u u a -- void", "FUNCTION: glGetSamplerParameteriv ( sampler pname params -- void )", "EXTERN: \"C\" void glGetSamplerParameteriv( int sampler, int pname, void * params );", "	( sampler pname params -- )" );
	swigFunction( "c-function glGetSamplerParameterIiv glGetSamplerParameterIiv u u a -- void", "FUNCTION: glGetSamplerParameterIiv ( sampler pname params -- void )", "EXTERN: \"C\" void glGetSamplerParameterIiv( int sampler, int pname, void * params );", "	( sampler pname params -- )" );
	swigFunction( "c-function glGetSamplerParameterfv glGetSamplerParameterfv u u a -- void", "FUNCTION: glGetSamplerParameterfv ( sampler pname params -- void )", "EXTERN: \"C\" void glGetSamplerParameterfv( int sampler, int pname, void * params );", "	( sampler pname params -- )" );
	swigFunction( "c-function glGetSamplerParameterIuiv glGetSamplerParameterIuiv u u a -- void", "FUNCTION: glGetSamplerParameterIuiv ( sampler pname params -- void )", "EXTERN: \"C\" void glGetSamplerParameterIuiv( int sampler, int pname, void * params );", "	( sampler pname params -- )" );
	swigFunction( "c-function glQueryCounter glQueryCounter u u -- void", "FUNCTION: glQueryCounter ( id target -- void )", "EXTERN: \"C\" void glQueryCounter( int id, int target );", "	( id target -- )" );
	swigFunction( "c-function glGetQueryObjecti64v glGetQueryObjecti64v u u a -- void", "FUNCTION: glGetQueryObjecti64v ( id pname params -- void )", "EXTERN: \"C\" void glGetQueryObjecti64v( int id, int pname, void * params );", "	( id pname params -- )" );
	swigFunction( "c-function glGetQueryObjectui64v glGetQueryObjectui64v u u a -- void", "FUNCTION: glGetQueryObjectui64v ( id pname params -- void )", "EXTERN: \"C\" void glGetQueryObjectui64v( int id, int pname, void * params );", "	( id pname params -- )" );
	swigFunction( "c-function glVertexAttribDivisor glVertexAttribDivisor u u -- void", "FUNCTION: glVertexAttribDivisor ( index divisor -- void )", "EXTERN: \"C\" void glVertexAttribDivisor( int index, int divisor );", "	( index divisor -- )" );
	swigFunction( "c-function glVertexAttribP1ui glVertexAttribP1ui u u u u -- void", "FUNCTION: glVertexAttribP1ui ( index type normalized value -- void )", "EXTERN: \"C\" void glVertexAttribP1ui( int index, int type, char normalized, int value );", "	( index type normalized value -- )" );
	swigFunction( "c-function glVertexAttribP1uiv glVertexAttribP1uiv u u u a -- void", "FUNCTION: glVertexAttribP1uiv ( index type normalized value -- void )", "EXTERN: \"C\" void glVertexAttribP1uiv( int index, int type, char normalized, void * value );", "	( index type normalized value -- )" );
	swigFunction( "c-function glVertexAttribP2ui glVertexAttribP2ui u u u u -- void", "FUNCTION: glVertexAttribP2ui ( index type normalized value -- void )", "EXTERN: \"C\" void glVertexAttribP2ui( int index, int type, char normalized, int value );", "	( index type normalized value -- )" );
	swigFunction( "c-function glVertexAttribP2uiv glVertexAttribP2uiv u u u a -- void", "FUNCTION: glVertexAttribP2uiv ( index type normalized value -- void )", "EXTERN: \"C\" void glVertexAttribP2uiv( int index, int type, char normalized, void * value );", "	( index type normalized value -- )" );
	swigFunction( "c-function glVertexAttribP3ui glVertexAttribP3ui u u u u -- void", "FUNCTION: glVertexAttribP3ui ( index type normalized value -- void )", "EXTERN: \"C\" void glVertexAttribP3ui( int index, int type, char normalized, int value );", "	( index type normalized value -- )" );
	swigFunction( "c-function glVertexAttribP3uiv glVertexAttribP3uiv u u u a -- void", "FUNCTION: glVertexAttribP3uiv ( index type normalized value -- void )", "EXTERN: \"C\" void glVertexAttribP3uiv( int index, int type, char normalized, void * value );", "	( index type normalized value -- )" );
	swigFunction( "c-function glVertexAttribP4ui glVertexAttribP4ui u u u u -- void", "FUNCTION: glVertexAttribP4ui ( index type normalized value -- void )", "EXTERN: \"C\" void glVertexAttribP4ui( int index, int type, char normalized, int value );", "	( index type normalized value -- )" );
	swigFunction( "c-function glVertexAttribP4uiv glVertexAttribP4uiv u u u a -- void", "FUNCTION: glVertexAttribP4uiv ( index type normalized value -- void )", "EXTERN: \"C\" void glVertexAttribP4uiv( int index, int type, char normalized, void * value );", "	( index type normalized value -- )" );
	swigFunction( "c-function glVertexP2ui glVertexP2ui u u -- void", "FUNCTION: glVertexP2ui ( type value -- void )", "EXTERN: \"C\" void glVertexP2ui( int type, int value );", "	( type value -- )" );
	swigFunction( "c-function glVertexP2uiv glVertexP2uiv u a -- void", "FUNCTION: glVertexP2uiv ( type value -- void )", "EXTERN: \"C\" void glVertexP2uiv( int type, void * value );", "	( type value -- )" );
	swigFunction( "c-function glVertexP3ui glVertexP3ui u u -- void", "FUNCTION: glVertexP3ui ( type value -- void )", "EXTERN: \"C\" void glVertexP3ui( int type, int value );", "	( type value -- )" );
	swigFunction( "c-function glVertexP3uiv glVertexP3uiv u a -- void", "FUNCTION: glVertexP3uiv ( type value -- void )", "EXTERN: \"C\" void glVertexP3uiv( int type, void * value );", "	( type value -- )" );
	swigFunction( "c-function glVertexP4ui glVertexP4ui u u -- void", "FUNCTION: glVertexP4ui ( type value -- void )", "EXTERN: \"C\" void glVertexP4ui( int type, int value );", "	( type value -- )" );
	swigFunction( "c-function glVertexP4uiv glVertexP4uiv u a -- void", "FUNCTION: glVertexP4uiv ( type value -- void )", "EXTERN: \"C\" void glVertexP4uiv( int type, void * value );", "	( type value -- )" );
	swigFunction( "c-function glTexCoordP1ui glTexCoordP1ui u u -- void", "FUNCTION: glTexCoordP1ui ( type coords -- void )", "EXTERN: \"C\" void glTexCoordP1ui( int type, int coords );", "	( type coords -- )" );
	swigFunction( "c-function glTexCoordP1uiv glTexCoordP1uiv u a -- void", "FUNCTION: glTexCoordP1uiv ( type coords -- void )", "EXTERN: \"C\" void glTexCoordP1uiv( int type, void * coords );", "	( type coords -- )" );
	swigFunction( "c-function glTexCoordP2ui glTexCoordP2ui u u -- void", "FUNCTION: glTexCoordP2ui ( type coords -- void )", "EXTERN: \"C\" void glTexCoordP2ui( int type, int coords );", "	( type coords -- )" );
	swigFunction( "c-function glTexCoordP2uiv glTexCoordP2uiv u a -- void", "FUNCTION: glTexCoordP2uiv ( type coords -- void )", "EXTERN: \"C\" void glTexCoordP2uiv( int type, void * coords );", "	( type coords -- )" );
	swigFunction( "c-function glTexCoordP3ui glTexCoordP3ui u u -- void", "FUNCTION: glTexCoordP3ui ( type coords -- void )", "EXTERN: \"C\" void glTexCoordP3ui( int type, int coords );", "	( type coords -- )" );
	swigFunction( "c-function glTexCoordP3uiv glTexCoordP3uiv u a -- void", "FUNCTION: glTexCoordP3uiv ( type coords -- void )", "EXTERN: \"C\" void glTexCoordP3uiv( int type, void * coords );", "	( type coords -- )" );
	swigFunction( "c-function glTexCoordP4ui glTexCoordP4ui u u -- void", "FUNCTION: glTexCoordP4ui ( type coords -- void )", "EXTERN: \"C\" void glTexCoordP4ui( int type, int coords );", "	( type coords -- )" );
	swigFunction( "c-function glTexCoordP4uiv glTexCoordP4uiv u a -- void", "FUNCTION: glTexCoordP4uiv ( type coords -- void )", "EXTERN: \"C\" void glTexCoordP4uiv( int type, void * coords );", "	( type coords -- )" );
	swigFunction( "c-function glMultiTexCoordP1ui glMultiTexCoordP1ui u u u -- void", "FUNCTION: glMultiTexCoordP1ui ( texture type coords -- void )", "EXTERN: \"C\" void glMultiTexCoordP1ui( int texture, int type, int coords );", "	( texture type coords -- )" );
	swigFunction( "c-function glMultiTexCoordP1uiv glMultiTexCoordP1uiv u u a -- void", "FUNCTION: glMultiTexCoordP1uiv ( texture type coords -- void )", "EXTERN: \"C\" void glMultiTexCoordP1uiv( int texture, int type, void * coords );", "	( texture type coords -- )" );
	swigFunction( "c-function glMultiTexCoordP2ui glMultiTexCoordP2ui u u u -- void", "FUNCTION: glMultiTexCoordP2ui ( texture type coords -- void )", "EXTERN: \"C\" void glMultiTexCoordP2ui( int texture, int type, int coords );", "	( texture type coords -- )" );
	swigFunction( "c-function glMultiTexCoordP2uiv glMultiTexCoordP2uiv u u a -- void", "FUNCTION: glMultiTexCoordP2uiv ( texture type coords -- void )", "EXTERN: \"C\" void glMultiTexCoordP2uiv( int texture, int type, void * coords );", "	( texture type coords -- )" );
	swigFunction( "c-function glMultiTexCoordP3ui glMultiTexCoordP3ui u u u -- void", "FUNCTION: glMultiTexCoordP3ui ( texture type coords -- void )", "EXTERN: \"C\" void glMultiTexCoordP3ui( int texture, int type, int coords );", "	( texture type coords -- )" );
	swigFunction( "c-function glMultiTexCoordP3uiv glMultiTexCoordP3uiv u u a -- void", "FUNCTION: glMultiTexCoordP3uiv ( texture type coords -- void )", "EXTERN: \"C\" void glMultiTexCoordP3uiv( int texture, int type, void * coords );", "	( texture type coords -- )" );
	swigFunction( "c-function glMultiTexCoordP4ui glMultiTexCoordP4ui u u u -- void", "FUNCTION: glMultiTexCoordP4ui ( texture type coords -- void )", "EXTERN: \"C\" void glMultiTexCoordP4ui( int texture, int type, int coords );", "	( texture type coords -- )" );
	swigFunction( "c-function glMultiTexCoordP4uiv glMultiTexCoordP4uiv u u a -- void", "FUNCTION: glMultiTexCoordP4uiv ( texture type coords -- void )", "EXTERN: \"C\" void glMultiTexCoordP4uiv( int texture, int type, void * coords );", "	( texture type coords -- )" );
	swigFunction( "c-function glNormalP3ui glNormalP3ui u u -- void", "FUNCTION: glNormalP3ui ( type coords -- void )", "EXTERN: \"C\" void glNormalP3ui( int type, int coords );", "	( type coords -- )" );
	swigFunction( "c-function glNormalP3uiv glNormalP3uiv u a -- void", "FUNCTION: glNormalP3uiv ( type coords -- void )", "EXTERN: \"C\" void glNormalP3uiv( int type, void * coords );", "	( type coords -- )" );
	swigFunction( "c-function glColorP3ui glColorP3ui u u -- void", "FUNCTION: glColorP3ui ( type color -- void )", "EXTERN: \"C\" void glColorP3ui( int type, int color );", "	( type color -- )" );
	swigFunction( "c-function glColorP3uiv glColorP3uiv u a -- void", "FUNCTION: glColorP3uiv ( type color -- void )", "EXTERN: \"C\" void glColorP3uiv( int type, void * color );", "	( type color -- )" );
	swigFunction( "c-function glColorP4ui glColorP4ui u u -- void", "FUNCTION: glColorP4ui ( type color -- void )", "EXTERN: \"C\" void glColorP4ui( int type, int color );", "	( type color -- )" );
	swigFunction( "c-function glColorP4uiv glColorP4uiv u a -- void", "FUNCTION: glColorP4uiv ( type color -- void )", "EXTERN: \"C\" void glColorP4uiv( int type, void * color );", "	( type color -- )" );
	swigFunction( "c-function glSecondaryColorP3ui glSecondaryColorP3ui u u -- void", "FUNCTION: glSecondaryColorP3ui ( type color -- void )", "EXTERN: \"C\" void glSecondaryColorP3ui( int type, int color );", "	( type color -- )" );
	swigFunction( "c-function glSecondaryColorP3uiv glSecondaryColorP3uiv u a -- void", "FUNCTION: glSecondaryColorP3uiv ( type color -- void )", "EXTERN: \"C\" void glSecondaryColorP3uiv( int type, void * color );", "	( type color -- )" );
	swigFunction( "c-function glMinSampleShading glMinSampleShading r -- void", "FUNCTION: glMinSampleShading ( value -- void )", "EXTERN: \"C\" void glMinSampleShading( float value );", "	( value -- )" );
	swigFunction( "c-function glBlendEquationi glBlendEquationi u u -- void", "FUNCTION: glBlendEquationi ( buf mode -- void )", "EXTERN: \"C\" void glBlendEquationi( int buf, int mode );", "	( buf mode -- )" );
	swigFunction( "c-function glBlendEquationSeparatei glBlendEquationSeparatei u u u -- void", "FUNCTION: glBlendEquationSeparatei ( buf modeRGB modeAlpha -- void )", "EXTERN: \"C\" void glBlendEquationSeparatei( int buf, int modeRGB, int modeAlpha );", "	( buf modeRGB modeAlpha -- )" );
	swigFunction( "c-function glBlendFunci glBlendFunci u u u -- void", "FUNCTION: glBlendFunci ( buf src dst -- void )", "EXTERN: \"C\" void glBlendFunci( int buf, int src, int dst );", "	( buf src dst -- )" );
	swigFunction( "c-function glBlendFuncSeparatei glBlendFuncSeparatei u u u u u -- void", "FUNCTION: glBlendFuncSeparatei ( buf srcRGB dstRGB srcAlpha dstAlpha -- void )", "EXTERN: \"C\" void glBlendFuncSeparatei( int buf, int srcRGB, int dstRGB, int srcAlpha, int dstAlpha );", "	( buf srcRGB dstRGB srcAlpha dstAlpha -- )" );
	swigFunction( "c-function glDrawArraysIndirect glDrawArraysIndirect u a -- void", "FUNCTION: glDrawArraysIndirect ( mode indirect -- void )", "EXTERN: \"C\" void glDrawArraysIndirect( int mode, void * indirect );", "	( mode indirect -- )" );
	swigFunction( "c-function glDrawElementsIndirect glDrawElementsIndirect u u a -- void", "FUNCTION: glDrawElementsIndirect ( mode type indirect -- void )", "EXTERN: \"C\" void glDrawElementsIndirect( int mode, int type, void * indirect );", "	( mode type indirect -- )" );
	swigFunction( "c-function glUniform1d glUniform1d n r -- void", "FUNCTION: glUniform1d ( location x -- void )", "EXTERN: \"C\" void glUniform1d( int location, double x );", "	( location x -- )" );
	swigFunction( "c-function glUniform2d glUniform2d n r r -- void", "FUNCTION: glUniform2d ( location x y -- void )", "EXTERN: \"C\" void glUniform2d( int location, double x, double y );", "	( location x y -- )" );
	swigFunction( "c-function glUniform3d glUniform3d n r r r -- void", "FUNCTION: glUniform3d ( location x y z -- void )", "EXTERN: \"C\" void glUniform3d( int location, double x, double y, double z );", "	( location x y z -- )" );
	swigFunction( "c-function glUniform4d glUniform4d n r r r r -- void", "FUNCTION: glUniform4d ( location x y z w -- void )", "EXTERN: \"C\" void glUniform4d( int location, double x, double y, double z, double w );", "	( location x y z w -- )" );
	swigFunction( "c-function glUniform1dv glUniform1dv n n a -- void", "FUNCTION: glUniform1dv ( location count value -- void )", "EXTERN: \"C\" void glUniform1dv( int location, int count, void * value );", "	( location count value -- )" );
	swigFunction( "c-function glUniform2dv glUniform2dv n n a -- void", "FUNCTION: glUniform2dv ( location count value -- void )", "EXTERN: \"C\" void glUniform2dv( int location, int count, void * value );", "	( location count value -- )" );
	swigFunction( "c-function glUniform3dv glUniform3dv n n a -- void", "FUNCTION: glUniform3dv ( location count value -- void )", "EXTERN: \"C\" void glUniform3dv( int location, int count, void * value );", "	( location count value -- )" );
	swigFunction( "c-function glUniform4dv glUniform4dv n n a -- void", "FUNCTION: glUniform4dv ( location count value -- void )", "EXTERN: \"C\" void glUniform4dv( int location, int count, void * value );", "	( location count value -- )" );
	swigFunction( "c-function glUniformMatrix2dv glUniformMatrix2dv n n u a -- void", "FUNCTION: glUniformMatrix2dv ( location count transpose value -- void )", "EXTERN: \"C\" void glUniformMatrix2dv( int location, int count, char transpose, void * value );", "	( location count transpose value -- )" );
	swigFunction( "c-function glUniformMatrix3dv glUniformMatrix3dv n n u a -- void", "FUNCTION: glUniformMatrix3dv ( location count transpose value -- void )", "EXTERN: \"C\" void glUniformMatrix3dv( int location, int count, char transpose, void * value );", "	( location count transpose value -- )" );
	swigFunction( "c-function glUniformMatrix4dv glUniformMatrix4dv n n u a -- void", "FUNCTION: glUniformMatrix4dv ( location count transpose value -- void )", "EXTERN: \"C\" void glUniformMatrix4dv( int location, int count, char transpose, void * value );", "	( location count transpose value -- )" );
	swigFunction( "c-function glUniformMatrix2x3dv glUniformMatrix2x3dv n n u a -- void", "FUNCTION: glUniformMatrix2x3dv ( location count transpose value -- void )", "EXTERN: \"C\" void glUniformMatrix2x3dv( int location, int count, char transpose, void * value );", "	( location count transpose value -- )" );
	swigFunction( "c-function glUniformMatrix2x4dv glUniformMatrix2x4dv n n u a -- void", "FUNCTION: glUniformMatrix2x4dv ( location count transpose value -- void )", "EXTERN: \"C\" void glUniformMatrix2x4dv( int location, int count, char transpose, void * value );", "	( location count transpose value -- )" );
	swigFunction( "c-function glUniformMatrix3x2dv glUniformMatrix3x2dv n n u a -- void", "FUNCTION: glUniformMatrix3x2dv ( location count transpose value -- void )", "EXTERN: \"C\" void glUniformMatrix3x2dv( int location, int count, char transpose, void * value );", "	( location count transpose value -- )" );
	swigFunction( "c-function glUniformMatrix3x4dv glUniformMatrix3x4dv n n u a -- void", "FUNCTION: glUniformMatrix3x4dv ( location count transpose value -- void )", "EXTERN: \"C\" void glUniformMatrix3x4dv( int location, int count, char transpose, void * value );", "	( location count transpose value -- )" );
	swigFunction( "c-function glUniformMatrix4x2dv glUniformMatrix4x2dv n n u a -- void", "FUNCTION: glUniformMatrix4x2dv ( location count transpose value -- void )", "EXTERN: \"C\" void glUniformMatrix4x2dv( int location, int count, char transpose, void * value );", "	( location count transpose value -- )" );
	swigFunction( "c-function glUniformMatrix4x3dv glUniformMatrix4x3dv n n u a -- void", "FUNCTION: glUniformMatrix4x3dv ( location count transpose value -- void )", "EXTERN: \"C\" void glUniformMatrix4x3dv( int location, int count, char transpose, void * value );", "	( location count transpose value -- )" );
	swigFunction( "c-function glGetUniformdv glGetUniformdv u n a -- void", "FUNCTION: glGetUniformdv ( program location params -- void )", "EXTERN: \"C\" void glGetUniformdv( int program, int location, void * params );", "	( program location params -- )" );
	swigFunction( "c-function glGetSubroutineUniformLocation glGetSubroutineUniformLocation u u s -- n", "FUNCTION: glGetSubroutineUniformLocation ( program shadertype name -- n )", "EXTERN: \"C\" int glGetSubroutineUniformLocation( int program, int shadertype, char * name );", "	( program shadertype name -- )" );
	swigFunction( "c-function glGetSubroutineIndex glGetSubroutineIndex u u s -- u", "FUNCTION: glGetSubroutineIndex ( program shadertype name -- u )", "EXTERN: \"C\" int glGetSubroutineIndex( int program, int shadertype, char * name );", "	( program shadertype name -- )" );
	swigFunction( "c-function glGetActiveSubroutineUniformiv glGetActiveSubroutineUniformiv u u u u a -- void", "FUNCTION: glGetActiveSubroutineUniformiv ( program shadertype index pname values -- void )", "EXTERN: \"C\" void glGetActiveSubroutineUniformiv( int program, int shadertype, int index, int pname, void * values );", "	( program shadertype index pname values -- )" );
	swigFunction( "c-function glGetActiveSubroutineUniformName glGetActiveSubroutineUniformName u u u n a a -- void", "FUNCTION: glGetActiveSubroutineUniformName ( program shadertype index bufSize length name -- void )", "EXTERN: \"C\" void glGetActiveSubroutineUniformName( int program, int shadertype, int index, int bufSize, void * length, void * name );", "	( program shadertype index bufSize length name -- )" );
	swigFunction( "c-function glGetActiveSubroutineName glGetActiveSubroutineName u u u n a a -- void", "FUNCTION: glGetActiveSubroutineName ( program shadertype index bufSize length name -- void )", "EXTERN: \"C\" void glGetActiveSubroutineName( int program, int shadertype, int index, int bufSize, void * length, void * name );", "	( program shadertype index bufSize length name -- )" );
	swigFunction( "c-function glUniformSubroutinesuiv glUniformSubroutinesuiv u n a -- void", "FUNCTION: glUniformSubroutinesuiv ( shadertype count indices -- void )", "EXTERN: \"C\" void glUniformSubroutinesuiv( int shadertype, int count, void * indices );", "	( shadertype count indices -- )" );
	swigFunction( "c-function glGetUniformSubroutineuiv glGetUniformSubroutineuiv u n a -- void", "FUNCTION: glGetUniformSubroutineuiv ( shadertype location params -- void )", "EXTERN: \"C\" void glGetUniformSubroutineuiv( int shadertype, int location, void * params );", "	( shadertype location params -- )" );
	swigFunction( "c-function glGetProgramStageiv glGetProgramStageiv u u u a -- void", "FUNCTION: glGetProgramStageiv ( program shadertype pname values -- void )", "EXTERN: \"C\" void glGetProgramStageiv( int program, int shadertype, int pname, void * values );", "	( program shadertype pname values -- )" );
	swigFunction( "c-function glPatchParameteri glPatchParameteri u n -- void", "FUNCTION: glPatchParameteri ( pname value -- void )", "EXTERN: \"C\" void glPatchParameteri( int pname, int value );", "	( pname value -- )" );
	swigFunction( "c-function glPatchParameterfv glPatchParameterfv u a -- void", "FUNCTION: glPatchParameterfv ( pname values -- void )", "EXTERN: \"C\" void glPatchParameterfv( int pname, void * values );", "	( pname values -- )" );
	swigFunction( "c-function glBindTransformFeedback glBindTransformFeedback u u -- void", "FUNCTION: glBindTransformFeedback ( target id -- void )", "EXTERN: \"C\" void glBindTransformFeedback( int target, int id );", "	( target id -- )" );
	swigFunction( "c-function glDeleteTransformFeedbacks glDeleteTransformFeedbacks n a -- void", "FUNCTION: glDeleteTransformFeedbacks ( n ids -- void )", "EXTERN: \"C\" void glDeleteTransformFeedbacks( int n, void * ids );", "	( n ids -- )" );
	swigFunction( "c-function glGenTransformFeedbacks glGenTransformFeedbacks n a -- void", "FUNCTION: glGenTransformFeedbacks ( n ids -- void )", "EXTERN: \"C\" void glGenTransformFeedbacks( int n, void * ids );", "	( n ids -- )" );
	swigFunction( "c-function glIsTransformFeedback glIsTransformFeedback u -- u", "FUNCTION: glIsTransformFeedback ( id -- u )", "EXTERN: \"C\" char glIsTransformFeedback( int id );", "	( id -- )" );
	swigFunction( "c-function glPauseTransformFeedback glPauseTransformFeedback  -- void", "FUNCTION: glPauseTransformFeedback (  -- void )", "EXTERN: \"C\" void glPauseTransformFeedback(  );", "	( -- )" );
	swigFunction( "c-function glResumeTransformFeedback glResumeTransformFeedback  -- void", "FUNCTION: glResumeTransformFeedback (  -- void )", "EXTERN: \"C\" void glResumeTransformFeedback(  );", "	( -- )" );
	swigFunction( "c-function glDrawTransformFeedback glDrawTransformFeedback u u -- void", "FUNCTION: glDrawTransformFeedback ( mode id -- void )", "EXTERN: \"C\" void glDrawTransformFeedback( int mode, int id );", "	( mode id -- )" );
	swigFunction( "c-function glDrawTransformFeedbackStream glDrawTransformFeedbackStream u u u -- void", "FUNCTION: glDrawTransformFeedbackStream ( mode id stream -- void )", "EXTERN: \"C\" void glDrawTransformFeedbackStream( int mode, int id, int stream );", "	( mode id stream -- )" );
	swigFunction( "c-function glBeginQueryIndexed glBeginQueryIndexed u u u -- void", "FUNCTION: glBeginQueryIndexed ( target index id -- void )", "EXTERN: \"C\" void glBeginQueryIndexed( int target, int index, int id );", "	( target index id -- )" );
	swigFunction( "c-function glEndQueryIndexed glEndQueryIndexed u u -- void", "FUNCTION: glEndQueryIndexed ( target index -- void )", "EXTERN: \"C\" void glEndQueryIndexed( int target, int index );", "	( target index -- )" );
	swigFunction( "c-function glGetQueryIndexediv glGetQueryIndexediv u u u a -- void", "FUNCTION: glGetQueryIndexediv ( target index pname params -- void )", "EXTERN: \"C\" void glGetQueryIndexediv( int target, int index, int pname, void * params );", "	( target index pname params -- )" );
	swigFunction( "c-function glReleaseShaderCompiler glReleaseShaderCompiler  -- void", "FUNCTION: glReleaseShaderCompiler (  -- void )", "EXTERN: \"C\" void glReleaseShaderCompiler(  );", "	( -- )" );
	swigFunction( "c-function glShaderBinary glShaderBinary n a u a n -- void", "FUNCTION: glShaderBinary ( count shaders binaryFormat binary length -- void )", "EXTERN: \"C\" void glShaderBinary( int count, void * shaders, int binaryFormat, void * binary, int length );", "	( count shaders binaryFormat binary length -- )" );
	swigFunction( "c-function glGetShaderPrecisionFormat glGetShaderPrecisionFormat u u a a -- void", "FUNCTION: glGetShaderPrecisionFormat ( shadertype precisiontype range precision -- void )", "EXTERN: \"C\" void glGetShaderPrecisionFormat( int shadertype, int precisiontype, void * range, void * precision );", "	( shadertype precisiontype range precision -- )" );
	swigFunction( "c-function glDepthRangef glDepthRangef r r -- void", "FUNCTION: glDepthRangef ( n f -- void )", "EXTERN: \"C\" void glDepthRangef( float n, float f );", "	( n f -- )" );
	swigFunction( "c-function glClearDepthf glClearDepthf r -- void", "FUNCTION: glClearDepthf ( d -- void )", "EXTERN: \"C\" void glClearDepthf( float d );", "	( d -- )" );
	swigFunction( "c-function glGetProgramBinary glGetProgramBinary u n a a a -- void", "FUNCTION: glGetProgramBinary ( program bufSize length binaryFormat binary -- void )", "EXTERN: \"C\" void glGetProgramBinary( int program, int bufSize, void * length, void * binaryFormat, void * binary );", "	( program bufSize length binaryFormat binary -- )" );
	swigFunction( "c-function glProgramBinary glProgramBinary u u a n -- void", "FUNCTION: glProgramBinary ( program binaryFormat binary length -- void )", "EXTERN: \"C\" void glProgramBinary( int program, int binaryFormat, void * binary, int length );", "	( program binaryFormat binary length -- )" );
	swigFunction( "c-function glProgramParameteri glProgramParameteri u u n -- void", "FUNCTION: glProgramParameteri ( program pname value -- void )", "EXTERN: \"C\" void glProgramParameteri( int program, int pname, int value );", "	( program pname value -- )" );
	swigFunction( "c-function glUseProgramStages glUseProgramStages u u u -- void", "FUNCTION: glUseProgramStages ( pipeline stages program -- void )", "EXTERN: \"C\" void glUseProgramStages( int pipeline, int stages, int program );", "	( pipeline stages program -- )" );
	swigFunction( "c-function glActiveShaderProgram glActiveShaderProgram u u -- void", "FUNCTION: glActiveShaderProgram ( pipeline program -- void )", "EXTERN: \"C\" void glActiveShaderProgram( int pipeline, int program );", "	( pipeline program -- )" );
	swigFunction( "c-function glCreateShaderProgramv glCreateShaderProgramv u n a -- u", "FUNCTION: glCreateShaderProgramv ( type count strings -- u )", "EXTERN: \"C\" int glCreateShaderProgramv( int type, int count, void * strings );", "	( type count strings -- )" );
	swigFunction( "c-function glBindProgramPipeline glBindProgramPipeline u -- void", "FUNCTION: glBindProgramPipeline ( pipeline -- void )", "EXTERN: \"C\" void glBindProgramPipeline( int pipeline );", "	( pipeline -- )" );
	swigFunction( "c-function glDeleteProgramPipelines glDeleteProgramPipelines n a -- void", "FUNCTION: glDeleteProgramPipelines ( n pipelines -- void )", "EXTERN: \"C\" void glDeleteProgramPipelines( int n, void * pipelines );", "	( n pipelines -- )" );
	swigFunction( "c-function glGenProgramPipelines glGenProgramPipelines n a -- void", "FUNCTION: glGenProgramPipelines ( n pipelines -- void )", "EXTERN: \"C\" void glGenProgramPipelines( int n, void * pipelines );", "	( n pipelines -- )" );
	swigFunction( "c-function glIsProgramPipeline glIsProgramPipeline u -- u", "FUNCTION: glIsProgramPipeline ( pipeline -- u )", "EXTERN: \"C\" char glIsProgramPipeline( int pipeline );", "	( pipeline -- )" );
	swigFunction( "c-function glGetProgramPipelineiv glGetProgramPipelineiv u u a -- void", "FUNCTION: glGetProgramPipelineiv ( pipeline pname params -- void )", "EXTERN: \"C\" void glGetProgramPipelineiv( int pipeline, int pname, void * params );", "	( pipeline pname params -- )" );
	swigFunction( "c-function glProgramUniform1i glProgramUniform1i u n n -- void", "FUNCTION: glProgramUniform1i ( program location v0 -- void )", "EXTERN: \"C\" void glProgramUniform1i( int program, int location, int v0 );", "	( program location v0 -- )" );
	swigFunction( "c-function glProgramUniform1iv glProgramUniform1iv u n n a -- void", "FUNCTION: glProgramUniform1iv ( program location count value -- void )", "EXTERN: \"C\" void glProgramUniform1iv( int program, int location, int count, void * value );", "	( program location count value -- )" );
	swigFunction( "c-function glProgramUniform1f glProgramUniform1f u n r -- void", "FUNCTION: glProgramUniform1f ( program location v0 -- void )", "EXTERN: \"C\" void glProgramUniform1f( int program, int location, float v0 );", "	( program location v0 -- )" );
	swigFunction( "c-function glProgramUniform1fv glProgramUniform1fv u n n a -- void", "FUNCTION: glProgramUniform1fv ( program location count value -- void )", "EXTERN: \"C\" void glProgramUniform1fv( int program, int location, int count, void * value );", "	( program location count value -- )" );
	swigFunction( "c-function glProgramUniform1d glProgramUniform1d u n r -- void", "FUNCTION: glProgramUniform1d ( program location v0 -- void )", "EXTERN: \"C\" void glProgramUniform1d( int program, int location, double v0 );", "	( program location v0 -- )" );
	swigFunction( "c-function glProgramUniform1dv glProgramUniform1dv u n n a -- void", "FUNCTION: glProgramUniform1dv ( program location count value -- void )", "EXTERN: \"C\" void glProgramUniform1dv( int program, int location, int count, void * value );", "	( program location count value -- )" );
	swigFunction( "c-function glProgramUniform1ui glProgramUniform1ui u n u -- void", "FUNCTION: glProgramUniform1ui ( program location v0 -- void )", "EXTERN: \"C\" void glProgramUniform1ui( int program, int location, int v0 );", "	( program location v0 -- )" );
	swigFunction( "c-function glProgramUniform1uiv glProgramUniform1uiv u n n a -- void", "FUNCTION: glProgramUniform1uiv ( program location count value -- void )", "EXTERN: \"C\" void glProgramUniform1uiv( int program, int location, int count, void * value );", "	( program location count value -- )" );
	swigFunction( "c-function glProgramUniform2i glProgramUniform2i u n n n -- void", "FUNCTION: glProgramUniform2i ( program location v0 v1 -- void )", "EXTERN: \"C\" void glProgramUniform2i( int program, int location, int v0, int v1 );", "	( program location v0 v1 -- )" );
	swigFunction( "c-function glProgramUniform2iv glProgramUniform2iv u n n a -- void", "FUNCTION: glProgramUniform2iv ( program location count value -- void )", "EXTERN: \"C\" void glProgramUniform2iv( int program, int location, int count, void * value );", "	( program location count value -- )" );
	swigFunction( "c-function glProgramUniform2f glProgramUniform2f u n r r -- void", "FUNCTION: glProgramUniform2f ( program location v0 v1 -- void )", "EXTERN: \"C\" void glProgramUniform2f( int program, int location, float v0, float v1 );", "	( program location v0 v1 -- )" );
	swigFunction( "c-function glProgramUniform2fv glProgramUniform2fv u n n a -- void", "FUNCTION: glProgramUniform2fv ( program location count value -- void )", "EXTERN: \"C\" void glProgramUniform2fv( int program, int location, int count, void * value );", "	( program location count value -- )" );
	swigFunction( "c-function glProgramUniform2d glProgramUniform2d u n r r -- void", "FUNCTION: glProgramUniform2d ( program location v0 v1 -- void )", "EXTERN: \"C\" void glProgramUniform2d( int program, int location, double v0, double v1 );", "	( program location v0 v1 -- )" );
	swigFunction( "c-function glProgramUniform2dv glProgramUniform2dv u n n a -- void", "FUNCTION: glProgramUniform2dv ( program location count value -- void )", "EXTERN: \"C\" void glProgramUniform2dv( int program, int location, int count, void * value );", "	( program location count value -- )" );
	swigFunction( "c-function glProgramUniform2ui glProgramUniform2ui u n u u -- void", "FUNCTION: glProgramUniform2ui ( program location v0 v1 -- void )", "EXTERN: \"C\" void glProgramUniform2ui( int program, int location, int v0, int v1 );", "	( program location v0 v1 -- )" );
	swigFunction( "c-function glProgramUniform2uiv glProgramUniform2uiv u n n a -- void", "FUNCTION: glProgramUniform2uiv ( program location count value -- void )", "EXTERN: \"C\" void glProgramUniform2uiv( int program, int location, int count, void * value );", "	( program location count value -- )" );
	swigFunction( "c-function glProgramUniform3i glProgramUniform3i u n n n n -- void", "FUNCTION: glProgramUniform3i ( program location v0 v1 v2 -- void )", "EXTERN: \"C\" void glProgramUniform3i( int program, int location, int v0, int v1, int v2 );", "	( program location v0 v1 v2 -- )" );
	swigFunction( "c-function glProgramUniform3iv glProgramUniform3iv u n n a -- void", "FUNCTION: glProgramUniform3iv ( program location count value -- void )", "EXTERN: \"C\" void glProgramUniform3iv( int program, int location, int count, void * value );", "	( program location count value -- )" );
	swigFunction( "c-function glProgramUniform3f glProgramUniform3f u n r r r -- void", "FUNCTION: glProgramUniform3f ( program location v0 v1 v2 -- void )", "EXTERN: \"C\" void glProgramUniform3f( int program, int location, float v0, float v1, float v2 );", "	( program location v0 v1 v2 -- )" );
	swigFunction( "c-function glProgramUniform3fv glProgramUniform3fv u n n a -- void", "FUNCTION: glProgramUniform3fv ( program location count value -- void )", "EXTERN: \"C\" void glProgramUniform3fv( int program, int location, int count, void * value );", "	( program location count value -- )" );
	swigFunction( "c-function glProgramUniform3d glProgramUniform3d u n r r r -- void", "FUNCTION: glProgramUniform3d ( program location v0 v1 v2 -- void )", "EXTERN: \"C\" void glProgramUniform3d( int program, int location, double v0, double v1, double v2 );", "	( program location v0 v1 v2 -- )" );
	swigFunction( "c-function glProgramUniform3dv glProgramUniform3dv u n n a -- void", "FUNCTION: glProgramUniform3dv ( program location count value -- void )", "EXTERN: \"C\" void glProgramUniform3dv( int program, int location, int count, void * value );", "	( program location count value -- )" );
	swigFunction( "c-function glProgramUniform3ui glProgramUniform3ui u n u u u -- void", "FUNCTION: glProgramUniform3ui ( program location v0 v1 v2 -- void )", "EXTERN: \"C\" void glProgramUniform3ui( int program, int location, int v0, int v1, int v2 );", "	( program location v0 v1 v2 -- )" );
	swigFunction( "c-function glProgramUniform3uiv glProgramUniform3uiv u n n a -- void", "FUNCTION: glProgramUniform3uiv ( program location count value -- void )", "EXTERN: \"C\" void glProgramUniform3uiv( int program, int location, int count, void * value );", "	( program location count value -- )" );
	swigFunction( "c-function glProgramUniform4i glProgramUniform4i u n n n n n -- void", "FUNCTION: glProgramUniform4i ( program location v0 v1 v2 v3 -- void )", "EXTERN: \"C\" void glProgramUniform4i( int program, int location, int v0, int v1, int v2, int v3 );", "	( program location v0 v1 v2 v3 -- )" );
	swigFunction( "c-function glProgramUniform4iv glProgramUniform4iv u n n a -- void", "FUNCTION: glProgramUniform4iv ( program location count value -- void )", "EXTERN: \"C\" void glProgramUniform4iv( int program, int location, int count, void * value );", "	( program location count value -- )" );
	swigFunction( "c-function glProgramUniform4f glProgramUniform4f u n r r r r -- void", "FUNCTION: glProgramUniform4f ( program location v0 v1 v2 v3 -- void )", "EXTERN: \"C\" void glProgramUniform4f( int program, int location, float v0, float v1, float v2, float v3 );", "	( program location v0 v1 v2 v3 -- )" );
	swigFunction( "c-function glProgramUniform4fv glProgramUniform4fv u n n a -- void", "FUNCTION: glProgramUniform4fv ( program location count value -- void )", "EXTERN: \"C\" void glProgramUniform4fv( int program, int location, int count, void * value );", "	( program location count value -- )" );
	swigFunction( "c-function glProgramUniform4d glProgramUniform4d u n r r r r -- void", "FUNCTION: glProgramUniform4d ( program location v0 v1 v2 v3 -- void )", "EXTERN: \"C\" void glProgramUniform4d( int program, int location, double v0, double v1, double v2, double v3 );", "	( program location v0 v1 v2 v3 -- )" );
	swigFunction( "c-function glProgramUniform4dv glProgramUniform4dv u n n a -- void", "FUNCTION: glProgramUniform4dv ( program location count value -- void )", "EXTERN: \"C\" void glProgramUniform4dv( int program, int location, int count, void * value );", "	( program location count value -- )" );
	swigFunction( "c-function glProgramUniform4ui glProgramUniform4ui u n u u u u -- void", "FUNCTION: glProgramUniform4ui ( program location v0 v1 v2 v3 -- void )", "EXTERN: \"C\" void glProgramUniform4ui( int program, int location, int v0, int v1, int v2, int v3 );", "	( program location v0 v1 v2 v3 -- )" );
	swigFunction( "c-function glProgramUniform4uiv glProgramUniform4uiv u n n a -- void", "FUNCTION: glProgramUniform4uiv ( program location count value -- void )", "EXTERN: \"C\" void glProgramUniform4uiv( int program, int location, int count, void * value );", "	( program location count value -- )" );
	swigFunction( "c-function glProgramUniformMatrix2fv glProgramUniformMatrix2fv u n n u a -- void", "FUNCTION: glProgramUniformMatrix2fv ( program location count transpose value -- void )", "EXTERN: \"C\" void glProgramUniformMatrix2fv( int program, int location, int count, char transpose, void * value );", "	( program location count transpose value -- )" );
	swigFunction( "c-function glProgramUniformMatrix3fv glProgramUniformMatrix3fv u n n u a -- void", "FUNCTION: glProgramUniformMatrix3fv ( program location count transpose value -- void )", "EXTERN: \"C\" void glProgramUniformMatrix3fv( int program, int location, int count, char transpose, void * value );", "	( program location count transpose value -- )" );
	swigFunction( "c-function glProgramUniformMatrix4fv glProgramUniformMatrix4fv u n n u a -- void", "FUNCTION: glProgramUniformMatrix4fv ( program location count transpose value -- void )", "EXTERN: \"C\" void glProgramUniformMatrix4fv( int program, int location, int count, char transpose, void * value );", "	( program location count transpose value -- )" );
	swigFunction( "c-function glProgramUniformMatrix2dv glProgramUniformMatrix2dv u n n u a -- void", "FUNCTION: glProgramUniformMatrix2dv ( program location count transpose value -- void )", "EXTERN: \"C\" void glProgramUniformMatrix2dv( int program, int location, int count, char transpose, void * value );", "	( program location count transpose value -- )" );
	swigFunction( "c-function glProgramUniformMatrix3dv glProgramUniformMatrix3dv u n n u a -- void", "FUNCTION: glProgramUniformMatrix3dv ( program location count transpose value -- void )", "EXTERN: \"C\" void glProgramUniformMatrix3dv( int program, int location, int count, char transpose, void * value );", "	( program location count transpose value -- )" );
	swigFunction( "c-function glProgramUniformMatrix4dv glProgramUniformMatrix4dv u n n u a -- void", "FUNCTION: glProgramUniformMatrix4dv ( program location count transpose value -- void )", "EXTERN: \"C\" void glProgramUniformMatrix4dv( int program, int location, int count, char transpose, void * value );", "	( program location count transpose value -- )" );
	swigFunction( "c-function glProgramUniformMatrix2x3fv glProgramUniformMatrix2x3fv u n n u a -- void", "FUNCTION: glProgramUniformMatrix2x3fv ( program location count transpose value -- void )", "EXTERN: \"C\" void glProgramUniformMatrix2x3fv( int program, int location, int count, char transpose, void * value );", "	( program location count transpose value -- )" );
	swigFunction( "c-function glProgramUniformMatrix3x2fv glProgramUniformMatrix3x2fv u n n u a -- void", "FUNCTION: glProgramUniformMatrix3x2fv ( program location count transpose value -- void )", "EXTERN: \"C\" void glProgramUniformMatrix3x2fv( int program, int location, int count, char transpose, void * value );", "	( program location count transpose value -- )" );
	swigFunction( "c-function glProgramUniformMatrix2x4fv glProgramUniformMatrix2x4fv u n n u a -- void", "FUNCTION: glProgramUniformMatrix2x4fv ( program location count transpose value -- void )", "EXTERN: \"C\" void glProgramUniformMatrix2x4fv( int program, int location, int count, char transpose, void * value );", "	( program location count transpose value -- )" );
	swigFunction( "c-function glProgramUniformMatrix4x2fv glProgramUniformMatrix4x2fv u n n u a -- void", "FUNCTION: glProgramUniformMatrix4x2fv ( program location count transpose value -- void )", "EXTERN: \"C\" void glProgramUniformMatrix4x2fv( int program, int location, int count, char transpose, void * value );", "	( program location count transpose value -- )" );
	swigFunction( "c-function glProgramUniformMatrix3x4fv glProgramUniformMatrix3x4fv u n n u a -- void", "FUNCTION: glProgramUniformMatrix3x4fv ( program location count transpose value -- void )", "EXTERN: \"C\" void glProgramUniformMatrix3x4fv( int program, int location, int count, char transpose, void * value );", "	( program location count transpose value -- )" );
	swigFunction( "c-function glProgramUniformMatrix4x3fv glProgramUniformMatrix4x3fv u n n u a -- void", "FUNCTION: glProgramUniformMatrix4x3fv ( program location count transpose value -- void )", "EXTERN: \"C\" void glProgramUniformMatrix4x3fv( int program, int location, int count, char transpose, void * value );", "	( program location count transpose value -- )" );
	swigFunction( "c-function glProgramUniformMatrix2x3dv glProgramUniformMatrix2x3dv u n n u a -- void", "FUNCTION: glProgramUniformMatrix2x3dv ( program location count transpose value -- void )", "EXTERN: \"C\" void glProgramUniformMatrix2x3dv( int program, int location, int count, char transpose, void * value );", "	( program location count transpose value -- )" );
	swigFunction( "c-function glProgramUniformMatrix3x2dv glProgramUniformMatrix3x2dv u n n u a -- void", "FUNCTION: glProgramUniformMatrix3x2dv ( program location count transpose value -- void )", "EXTERN: \"C\" void glProgramUniformMatrix3x2dv( int program, int location, int count, char transpose, void * value );", "	( program location count transpose value -- )" );
	swigFunction( "c-function glProgramUniformMatrix2x4dv glProgramUniformMatrix2x4dv u n n u a -- void", "FUNCTION: glProgramUniformMatrix2x4dv ( program location count transpose value -- void )", "EXTERN: \"C\" void glProgramUniformMatrix2x4dv( int program, int location, int count, char transpose, void * value );", "	( program location count transpose value -- )" );
	swigFunction( "c-function glProgramUniformMatrix4x2dv glProgramUniformMatrix4x2dv u n n u a -- void", "FUNCTION: glProgramUniformMatrix4x2dv ( program location count transpose value -- void )", "EXTERN: \"C\" void glProgramUniformMatrix4x2dv( int program, int location, int count, char transpose, void * value );", "	( program location count transpose value -- )" );
	swigFunction( "c-function glProgramUniformMatrix3x4dv glProgramUniformMatrix3x4dv u n n u a -- void", "FUNCTION: glProgramUniformMatrix3x4dv ( program location count transpose value -- void )", "EXTERN: \"C\" void glProgramUniformMatrix3x4dv( int program, int location, int count, char transpose, void * value );", "	( program location count transpose value -- )" );
	swigFunction( "c-function glProgramUniformMatrix4x3dv glProgramUniformMatrix4x3dv u n n u a -- void", "FUNCTION: glProgramUniformMatrix4x3dv ( program location count transpose value -- void )", "EXTERN: \"C\" void glProgramUniformMatrix4x3dv( int program, int location, int count, char transpose, void * value );", "	( program location count transpose value -- )" );
	swigFunction( "c-function glValidateProgramPipeline glValidateProgramPipeline u -- void", "FUNCTION: glValidateProgramPipeline ( pipeline -- void )", "EXTERN: \"C\" void glValidateProgramPipeline( int pipeline );", "	( pipeline -- )" );
	swigFunction( "c-function glGetProgramPipelineInfoLog glGetProgramPipelineInfoLog u n a a -- void", "FUNCTION: glGetProgramPipelineInfoLog ( pipeline bufSize length infoLog -- void )", "EXTERN: \"C\" void glGetProgramPipelineInfoLog( int pipeline, int bufSize, void * length, void * infoLog );", "	( pipeline bufSize length infoLog -- )" );
	swigFunction( "c-function glVertexAttribL1d glVertexAttribL1d u r -- void", "FUNCTION: glVertexAttribL1d ( index x -- void )", "EXTERN: \"C\" void glVertexAttribL1d( int index, double x );", "	( index x -- )" );
	swigFunction( "c-function glVertexAttribL2d glVertexAttribL2d u r r -- void", "FUNCTION: glVertexAttribL2d ( index x y -- void )", "EXTERN: \"C\" void glVertexAttribL2d( int index, double x, double y );", "	( index x y -- )" );
	swigFunction( "c-function glVertexAttribL3d glVertexAttribL3d u r r r -- void", "FUNCTION: glVertexAttribL3d ( index x y z -- void )", "EXTERN: \"C\" void glVertexAttribL3d( int index, double x, double y, double z );", "	( index x y z -- )" );
	swigFunction( "c-function glVertexAttribL4d glVertexAttribL4d u r r r r -- void", "FUNCTION: glVertexAttribL4d ( index x y z w -- void )", "EXTERN: \"C\" void glVertexAttribL4d( int index, double x, double y, double z, double w );", "	( index x y z w -- )" );
	swigFunction( "c-function glVertexAttribL1dv glVertexAttribL1dv u a -- void", "FUNCTION: glVertexAttribL1dv ( index v -- void )", "EXTERN: \"C\" void glVertexAttribL1dv( int index, void * v );", "	( index v -- )" );
	swigFunction( "c-function glVertexAttribL2dv glVertexAttribL2dv u a -- void", "FUNCTION: glVertexAttribL2dv ( index v -- void )", "EXTERN: \"C\" void glVertexAttribL2dv( int index, void * v );", "	( index v -- )" );
	swigFunction( "c-function glVertexAttribL3dv glVertexAttribL3dv u a -- void", "FUNCTION: glVertexAttribL3dv ( index v -- void )", "EXTERN: \"C\" void glVertexAttribL3dv( int index, void * v );", "	( index v -- )" );
	swigFunction( "c-function glVertexAttribL4dv glVertexAttribL4dv u a -- void", "FUNCTION: glVertexAttribL4dv ( index v -- void )", "EXTERN: \"C\" void glVertexAttribL4dv( int index, void * v );", "	( index v -- )" );
	swigFunction( "c-function glVertexAttribLPointer glVertexAttribLPointer u n u n a -- void", "FUNCTION: glVertexAttribLPointer ( index size type stride pointer -- void )", "EXTERN: \"C\" void glVertexAttribLPointer( int index, int size, int type, int stride, void * pointer );", "	( index size type stride pointer -- )" );
	swigFunction( "c-function glGetVertexAttribLdv glGetVertexAttribLdv u u a -- void", "FUNCTION: glGetVertexAttribLdv ( index pname params -- void )", "EXTERN: \"C\" void glGetVertexAttribLdv( int index, int pname, void * params );", "	( index pname params -- )" );
	swigFunction( "c-function glViewportArrayv glViewportArrayv u n a -- void", "FUNCTION: glViewportArrayv ( first count v -- void )", "EXTERN: \"C\" void glViewportArrayv( int first, int count, void * v );", "	( first count v -- )" );
	swigFunction( "c-function glViewportIndexedf glViewportIndexedf u r r r r -- void", "FUNCTION: glViewportIndexedf ( index x y w h -- void )", "EXTERN: \"C\" void glViewportIndexedf( int index, float x, float y, float w, float h );", "	( index x y w h -- )" );
	swigFunction( "c-function glViewportIndexedfv glViewportIndexedfv u a -- void", "FUNCTION: glViewportIndexedfv ( index v -- void )", "EXTERN: \"C\" void glViewportIndexedfv( int index, void * v );", "	( index v -- )" );
	swigFunction( "c-function glScissorArrayv glScissorArrayv u n a -- void", "FUNCTION: glScissorArrayv ( first count v -- void )", "EXTERN: \"C\" void glScissorArrayv( int first, int count, void * v );", "	( first count v -- )" );
	swigFunction( "c-function glScissorIndexed glScissorIndexed u n n n n -- void", "FUNCTION: glScissorIndexed ( index left bottom width height -- void )", "EXTERN: \"C\" void glScissorIndexed( int index, int left, int bottom, int width, int height );", "	( index left bottom width height -- )" );
	swigFunction( "c-function glScissorIndexedv glScissorIndexedv u a -- void", "FUNCTION: glScissorIndexedv ( index v -- void )", "EXTERN: \"C\" void glScissorIndexedv( int index, void * v );", "	( index v -- )" );
	swigFunction( "c-function glDepthRangeArrayv glDepthRangeArrayv u n a -- void", "FUNCTION: glDepthRangeArrayv ( first count v -- void )", "EXTERN: \"C\" void glDepthRangeArrayv( int first, int count, void * v );", "	( first count v -- )" );
	swigFunction( "c-function glDepthRangeIndexed glDepthRangeIndexed u r r -- void", "FUNCTION: glDepthRangeIndexed ( index n f -- void )", "EXTERN: \"C\" void glDepthRangeIndexed( int index, double n, double f );", "	( index n f -- )" );
	swigFunction( "c-function glGetFloati_v glGetFloati_v u u a -- void", "FUNCTION: glGetFloati_v ( target index data -- void )", "EXTERN: \"C\" void glGetFloati_v( int target, int index, void * data );", "	( target index data -- )" );
	swigFunction( "c-function glGetDoublei_v glGetDoublei_v u u a -- void", "FUNCTION: glGetDoublei_v ( target index data -- void )", "EXTERN: \"C\" void glGetDoublei_v( int target, int index, void * data );", "	( target index data -- )" );
	swigFunction( "c-function glDrawArraysInstancedBaseInstance glDrawArraysInstancedBaseInstance u n n n u -- void", "FUNCTION: glDrawArraysInstancedBaseInstance ( mode first count instancecount baseinstance -- void )", "EXTERN: \"C\" void glDrawArraysInstancedBaseInstance( int mode, int first, int count, int instancecount, int baseinstance );", "	( mode first count instancecount baseinstance -- )" );
	swigFunction( "c-function glDrawElementsInstancedBaseInstance glDrawElementsInstancedBaseInstance u n u a n u -- void", "FUNCTION: glDrawElementsInstancedBaseInstance ( mode count type indices instancecount baseinstance -- void )", "EXTERN: \"C\" void glDrawElementsInstancedBaseInstance( int mode, int count, int type, void * indices, int instancecount, int baseinstance );", "	( mode count type indices instancecount baseinstance -- )" );
	swigFunction( "c-function glDrawElementsInstancedBaseVertexBaseInstance glDrawElementsInstancedBaseVertexBaseInstance u n u a n n u -- void", "FUNCTION: glDrawElementsInstancedBaseVertexBaseInstance ( mode count type indices instancecount basevertex baseinstance -- void )", "EXTERN: \"C\" void glDrawElementsInstancedBaseVertexBaseInstance( int mode, int count, int type, void * indices, int instancecount, int basevertex, int baseinstance );", "	( mode count type indices instancecount basevertex baseinstance -- )" );
	swigFunction( "c-function glGetInternalformativ glGetInternalformativ u u u n a -- void", "FUNCTION: glGetInternalformativ ( target internalformat pname count params -- void )", "EXTERN: \"C\" void glGetInternalformativ( int target, int internalformat, int pname, int count, void * params );", "	( target internalformat pname count params -- )" );
	swigFunction( "c-function glGetActiveAtomicCounterBufferiv glGetActiveAtomicCounterBufferiv u u u a -- void", "FUNCTION: glGetActiveAtomicCounterBufferiv ( program bufferIndex pname params -- void )", "EXTERN: \"C\" void glGetActiveAtomicCounterBufferiv( int program, int bufferIndex, int pname, void * params );", "	( program bufferIndex pname params -- )" );
	swigFunction( "c-function glBindImageTexture glBindImageTexture u u n u n u u -- void", "FUNCTION: glBindImageTexture ( unit texture level layered layer access format -- void )", "EXTERN: \"C\" void glBindImageTexture( int unit, int texture, int level, char layered, int layer, int access, int format );", "	( unit texture level layered layer access format -- )" );
	swigFunction( "c-function glMemoryBarrier glMemoryBarrier u -- void", "FUNCTION: glMemoryBarrier ( barriers -- void )", "EXTERN: \"C\" void glMemoryBarrier( int barriers );", "	( barriers -- )" );
	swigFunction( "c-function glTexStorage1D glTexStorage1D u n u n -- void", "FUNCTION: glTexStorage1D ( target levels internalformat width -- void )", "EXTERN: \"C\" void glTexStorage1D( int target, int levels, int internalformat, int width );", "	( target levels internalformat width -- )" );
	swigFunction( "c-function glTexStorage2D glTexStorage2D u n u n n -- void", "FUNCTION: glTexStorage2D ( target levels internalformat width height -- void )", "EXTERN: \"C\" void glTexStorage2D( int target, int levels, int internalformat, int width, int height );", "	( target levels internalformat width height -- )" );
	swigFunction( "c-function glTexStorage3D glTexStorage3D u n u n n n -- void", "FUNCTION: glTexStorage3D ( target levels internalformat width height depth -- void )", "EXTERN: \"C\" void glTexStorage3D( int target, int levels, int internalformat, int width, int height, int depth );", "	( target levels internalformat width height depth -- )" );
	swigFunction( "c-function glDrawTransformFeedbackInstanced glDrawTransformFeedbackInstanced u u n -- void", "FUNCTION: glDrawTransformFeedbackInstanced ( mode id instancecount -- void )", "EXTERN: \"C\" void glDrawTransformFeedbackInstanced( int mode, int id, int instancecount );", "	( mode id instancecount -- )" );
	swigFunction( "c-function glDrawTransformFeedbackStreamInstanced glDrawTransformFeedbackStreamInstanced u u u n -- void", "FUNCTION: glDrawTransformFeedbackStreamInstanced ( mode id stream instancecount -- void )", "EXTERN: \"C\" void glDrawTransformFeedbackStreamInstanced( int mode, int id, int stream, int instancecount );", "	( mode id stream instancecount -- )" );
	swigFunction( "c-function glClearBufferData glClearBufferData u u u u a -- void", "FUNCTION: glClearBufferData ( target internalformat format type data -- void )", "EXTERN: \"C\" void glClearBufferData( int target, int internalformat, int format, int type, void * data );", "	( target internalformat format type data -- )" );
	swigFunction( "c-function glClearBufferSubData glClearBufferSubData u u n n u u a -- void", "FUNCTION: glClearBufferSubData ( target internalformat offset size format type data -- void )", "EXTERN: \"C\" void glClearBufferSubData( int target, int internalformat, long offset, long size, int format, int type, void * data );", "	( target internalformat offset size format type data -- )" );
	swigFunction( "c-function glDispatchCompute glDispatchCompute u u u -- void", "FUNCTION: glDispatchCompute ( num_groups_x num_groups_y num_groups_z -- void )", "EXTERN: \"C\" void glDispatchCompute( int num_groups_x, int num_groups_y, int num_groups_z );", "	( num_groups_x num_groups_y num_groups_z -- )" );
	swigFunction( "c-function glDispatchComputeIndirect glDispatchComputeIndirect n -- void", "FUNCTION: glDispatchComputeIndirect ( indirect -- void )", "EXTERN: \"C\" void glDispatchComputeIndirect( long indirect );", "	( indirect -- )" );
	swigFunction( "c-function glCopyImageSubData glCopyImageSubData u u n n n n u u n n n n n n n -- void", "FUNCTION: glCopyImageSubData ( srcName srcTarget srcLevel srcX srcY srcZ dstName dstTarget dstLevel dstX dstY dstZ srcWidth srcHeight srcDepth -- void )", "EXTERN: \"C\" void glCopyImageSubData( int srcName, int srcTarget, int srcLevel, int srcX, int srcY, int srcZ, int dstName, int dstTarget, int dstLevel, int dstX, int dstY, int dstZ, int srcWidth, int srcHeight, int srcDepth );", "	( srcName srcTarget srcLevel srcX srcY srcZ dstName dstTarget dstLevel dstX dstY dstZ srcWidth srcHeight srcDepth -- )" );
	swigFunction( "c-function glFramebufferParameteri glFramebufferParameteri u u n -- void", "FUNCTION: glFramebufferParameteri ( target pname param -- void )", "EXTERN: \"C\" void glFramebufferParameteri( int target, int pname, int param );", "	( target pname param -- )" );
	swigFunction( "c-function glGetFramebufferParameteriv glGetFramebufferParameteriv u u a -- void", "FUNCTION: glGetFramebufferParameteriv ( target pname params -- void )", "EXTERN: \"C\" void glGetFramebufferParameteriv( int target, int pname, void * params );", "	( target pname params -- )" );
	swigFunction( "c-function glGetInternalformati64v glGetInternalformati64v u u u n a -- void", "FUNCTION: glGetInternalformati64v ( target internalformat pname count params -- void )", "EXTERN: \"C\" void glGetInternalformati64v( int target, int internalformat, int pname, int count, void * params );", "	( target internalformat pname count params -- )" );
	swigFunction( "c-function glInvalidateTexSubImage glInvalidateTexSubImage u n n n n n n n -- void", "FUNCTION: glInvalidateTexSubImage ( texture level xoffset yoffset zoffset width height depth -- void )", "EXTERN: \"C\" void glInvalidateTexSubImage( int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth );", "	( texture level xoffset yoffset zoffset width height depth -- )" );
	swigFunction( "c-function glInvalidateTexImage glInvalidateTexImage u n -- void", "FUNCTION: glInvalidateTexImage ( texture level -- void )", "EXTERN: \"C\" void glInvalidateTexImage( int texture, int level );", "	( texture level -- )" );
	swigFunction( "c-function glInvalidateBufferSubData glInvalidateBufferSubData u n n -- void", "FUNCTION: glInvalidateBufferSubData ( buffer offset length -- void )", "EXTERN: \"C\" void glInvalidateBufferSubData( int buffer, long offset, long length );", "	( buffer offset length -- )" );
	swigFunction( "c-function glInvalidateBufferData glInvalidateBufferData u -- void", "FUNCTION: glInvalidateBufferData ( buffer -- void )", "EXTERN: \"C\" void glInvalidateBufferData( int buffer );", "	( buffer -- )" );
	swigFunction( "c-function glInvalidateFramebuffer glInvalidateFramebuffer u n a -- void", "FUNCTION: glInvalidateFramebuffer ( target numAttachments attachments -- void )", "EXTERN: \"C\" void glInvalidateFramebuffer( int target, int numAttachments, void * attachments );", "	( target numAttachments attachments -- )" );
	swigFunction( "c-function glInvalidateSubFramebuffer glInvalidateSubFramebuffer u n a n n n n -- void", "FUNCTION: glInvalidateSubFramebuffer ( target numAttachments attachments x y width height -- void )", "EXTERN: \"C\" void glInvalidateSubFramebuffer( int target, int numAttachments, void * attachments, int x, int y, int width, int height );", "	( target numAttachments attachments x y width height -- )" );
	swigFunction( "c-function glMultiDrawArraysIndirect glMultiDrawArraysIndirect u a n n -- void", "FUNCTION: glMultiDrawArraysIndirect ( mode indirect drawcount stride -- void )", "EXTERN: \"C\" void glMultiDrawArraysIndirect( int mode, void * indirect, int drawcount, int stride );", "	( mode indirect drawcount stride -- )" );
	swigFunction( "c-function glMultiDrawElementsIndirect glMultiDrawElementsIndirect u u a n n -- void", "FUNCTION: glMultiDrawElementsIndirect ( mode type indirect drawcount stride -- void )", "EXTERN: \"C\" void glMultiDrawElementsIndirect( int mode, int type, void * indirect, int drawcount, int stride );", "	( mode type indirect drawcount stride -- )" );
	swigFunction( "c-function glGetProgramInterfaceiv glGetProgramInterfaceiv u u u a -- void", "FUNCTION: glGetProgramInterfaceiv ( program programInterface pname params -- void )", "EXTERN: \"C\" void glGetProgramInterfaceiv( int program, int programInterface, int pname, void * params );", "	( program programInterface pname params -- )" );
	swigFunction( "c-function glGetProgramResourceIndex glGetProgramResourceIndex u u s -- u", "FUNCTION: glGetProgramResourceIndex ( program programInterface name -- u )", "EXTERN: \"C\" int glGetProgramResourceIndex( int program, int programInterface, char * name );", "	( program programInterface name -- )" );
	swigFunction( "c-function glGetProgramResourceName glGetProgramResourceName u u u n a a -- void", "FUNCTION: glGetProgramResourceName ( program programInterface index bufSize length name -- void )", "EXTERN: \"C\" void glGetProgramResourceName( int program, int programInterface, int index, int bufSize, void * length, void * name );", "	( program programInterface index bufSize length name -- )" );
	swigFunction( "c-function glGetProgramResourceiv glGetProgramResourceiv u u u n a n a a -- void", "FUNCTION: glGetProgramResourceiv ( program programInterface index propCount props count length params -- void )", "EXTERN: \"C\" void glGetProgramResourceiv( int program, int programInterface, int index, int propCount, void * props, int count, void * length, void * params );", "	( program programInterface index propCount props count length params -- )" );
	swigFunction( "c-function glGetProgramResourceLocation glGetProgramResourceLocation u u s -- n", "FUNCTION: glGetProgramResourceLocation ( program programInterface name -- n )", "EXTERN: \"C\" int glGetProgramResourceLocation( int program, int programInterface, char * name );", "	( program programInterface name -- )" );
	swigFunction( "c-function glGetProgramResourceLocationIndex glGetProgramResourceLocationIndex u u s -- n", "FUNCTION: glGetProgramResourceLocationIndex ( program programInterface name -- n )", "EXTERN: \"C\" int glGetProgramResourceLocationIndex( int program, int programInterface, char * name );", "	( program programInterface name -- )" );
	swigFunction( "c-function glShaderStorageBlockBinding glShaderStorageBlockBinding u u u -- void", "FUNCTION: glShaderStorageBlockBinding ( program storageBlockIndex storageBlockBinding -- void )", "EXTERN: \"C\" void glShaderStorageBlockBinding( int program, int storageBlockIndex, int storageBlockBinding );", "	( program storageBlockIndex storageBlockBinding -- )" );
	swigFunction( "c-function glTexBufferRange glTexBufferRange u u u n n -- void", "FUNCTION: glTexBufferRange ( target internalformat buffer offset size -- void )", "EXTERN: \"C\" void glTexBufferRange( int target, int internalformat, int buffer, long offset, long size );", "	( target internalformat buffer offset size -- )" );
	swigFunction( "c-function glTexStorage2DMultisample glTexStorage2DMultisample u n u n n u -- void", "FUNCTION: glTexStorage2DMultisample ( target samples internalformat width height fixedsamplelocations -- void )", "EXTERN: \"C\" void glTexStorage2DMultisample( int target, int samples, int internalformat, int width, int height, char fixedsamplelocations );", "	( target samples internalformat width height fixedsamplelocations -- )" );
	swigFunction( "c-function glTexStorage3DMultisample glTexStorage3DMultisample u n u n n n u -- void", "FUNCTION: glTexStorage3DMultisample ( target samples internalformat width height depth fixedsamplelocations -- void )", "EXTERN: \"C\" void glTexStorage3DMultisample( int target, int samples, int internalformat, int width, int height, int depth, char fixedsamplelocations );", "	( target samples internalformat width height depth fixedsamplelocations -- )" );
	swigFunction( "c-function glTextureView glTextureView u u u u u u u u -- void", "FUNCTION: glTextureView ( texture target origtexture internalformat minlevel numlevels minlayer numlayers -- void )", "EXTERN: \"C\" void glTextureView( int texture, int target, int origtexture, int internalformat, int minlevel, int numlevels, int minlayer, int numlayers );", "	( texture target origtexture internalformat minlevel numlevels minlayer numlayers -- )" );
	swigFunction( "c-function glBindVertexBuffer glBindVertexBuffer u u n n -- void", "FUNCTION: glBindVertexBuffer ( bindingindex buffer offset stride -- void )", "EXTERN: \"C\" void glBindVertexBuffer( int bindingindex, int buffer, long offset, int stride );", "	( bindingindex buffer offset stride -- )" );
	swigFunction( "c-function glVertexAttribFormat glVertexAttribFormat u n u u u -- void", "FUNCTION: glVertexAttribFormat ( attribindex size type normalized relativeoffset -- void )", "EXTERN: \"C\" void glVertexAttribFormat( int attribindex, int size, int type, char normalized, int relativeoffset );", "	( attribindex size type normalized relativeoffset -- )" );
	swigFunction( "c-function glVertexAttribIFormat glVertexAttribIFormat u n u u -- void", "FUNCTION: glVertexAttribIFormat ( attribindex size type relativeoffset -- void )", "EXTERN: \"C\" void glVertexAttribIFormat( int attribindex, int size, int type, int relativeoffset );", "	( attribindex size type relativeoffset -- )" );
	swigFunction( "c-function glVertexAttribLFormat glVertexAttribLFormat u n u u -- void", "FUNCTION: glVertexAttribLFormat ( attribindex size type relativeoffset -- void )", "EXTERN: \"C\" void glVertexAttribLFormat( int attribindex, int size, int type, int relativeoffset );", "	( attribindex size type relativeoffset -- )" );
	swigFunction( "c-function glVertexAttribBinding glVertexAttribBinding u u -- void", "FUNCTION: glVertexAttribBinding ( attribindex bindingindex -- void )", "EXTERN: \"C\" void glVertexAttribBinding( int attribindex, int bindingindex );", "	( attribindex bindingindex -- )" );
	swigFunction( "c-function glVertexBindingDivisor glVertexBindingDivisor u u -- void", "FUNCTION: glVertexBindingDivisor ( bindingindex divisor -- void )", "EXTERN: \"C\" void glVertexBindingDivisor( int bindingindex, int divisor );", "	( bindingindex divisor -- )" );
	swigFunction( "c-function glDebugMessageControl glDebugMessageControl u u u n a u -- void", "FUNCTION: glDebugMessageControl ( source type severity count ids enabled -- void )", "EXTERN: \"C\" void glDebugMessageControl( int source, int type, int severity, int count, void * ids, char enabled );", "	( source type severity count ids enabled -- )" );
	swigFunction( "c-function glDebugMessageInsert glDebugMessageInsert u u u u n s -- void", "FUNCTION: glDebugMessageInsert ( source type id severity length buf -- void )", "EXTERN: \"C\" void glDebugMessageInsert( int source, int type, int id, int severity, int length, char * buf );", "	( source type id severity length buf -- )" );
	swigFunction( "c-function glDebugMessageCallback glDebugMessageCallback a a -- void", "FUNCTION: glDebugMessageCallback ( callback userParam -- void )", "EXTERN: \"C\" void glDebugMessageCallback( void * callback, void * userParam );", "	( callback userParam -- )" );
	swigFunction( "c-function glGetDebugMessageLog glGetDebugMessageLog u n a a a a a a -- u", "FUNCTION: glGetDebugMessageLog ( count bufSize sources types ids severities lengths messageLog -- u )", "EXTERN: \"C\" int glGetDebugMessageLog( int count, int bufSize, void * sources, void * types, void * ids, void * severities, void * lengths, void * messageLog );", "	( count bufSize sources types ids severities lengths messageLog -- )" );
	swigFunction( "c-function glPushDebugGroup glPushDebugGroup u u n s -- void", "FUNCTION: glPushDebugGroup ( source id length message -- void )", "EXTERN: \"C\" void glPushDebugGroup( int source, int id, int length, char * message );", "	( source id length message -- )" );
	swigFunction( "c-function glPopDebugGroup glPopDebugGroup  -- void", "FUNCTION: glPopDebugGroup (  -- void )", "EXTERN: \"C\" void glPopDebugGroup(  );", "	( -- )" );
	swigFunction( "c-function glObjectLabel glObjectLabel u u n s -- void", "FUNCTION: glObjectLabel ( identifier name length label -- void )", "EXTERN: \"C\" void glObjectLabel( int identifier, int name, int length, char * label );", "	( identifier name length label -- )" );
	swigFunction( "c-function glGetObjectLabel glGetObjectLabel u u n a a -- void", "FUNCTION: glGetObjectLabel ( identifier name bufSize length label -- void )", "EXTERN: \"C\" void glGetObjectLabel( int identifier, int name, int bufSize, void * length, void * label );", "	( identifier name bufSize length label -- )" );
	swigFunction( "c-function glObjectPtrLabel glObjectPtrLabel a n s -- void", "FUNCTION: glObjectPtrLabel ( ptr length label -- void )", "EXTERN: \"C\" void glObjectPtrLabel( void * ptr, int length, char * label );", "	( ptr length label -- )" );
	swigFunction( "c-function glGetObjectPtrLabel glGetObjectPtrLabel a n a a -- void", "FUNCTION: glGetObjectPtrLabel ( ptr bufSize length label -- void )", "EXTERN: \"C\" void glGetObjectPtrLabel( void * ptr, int bufSize, void * length, void * label );", "	( ptr bufSize length label -- )" );
	swigFunction( "c-function glBufferStorage glBufferStorage u n a u -- void", "FUNCTION: glBufferStorage ( target size data flags -- void )", "EXTERN: \"C\" void glBufferStorage( int target, long size, void * data, int flags );", "	( target size data flags -- )" );
	swigFunction( "c-function glClearTexImage glClearTexImage u n u u a -- void", "FUNCTION: glClearTexImage ( texture level format type data -- void )", "EXTERN: \"C\" void glClearTexImage( int texture, int level, int format, int type, void * data );", "	( texture level format type data -- )" );
	swigFunction( "c-function glClearTexSubImage glClearTexSubImage u n n n n n n n u u a -- void", "FUNCTION: glClearTexSubImage ( texture level xoffset yoffset zoffset width height depth format type data -- void )", "EXTERN: \"C\" void glClearTexSubImage( int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, void * data );", "	( texture level xoffset yoffset zoffset width height depth format type data -- )" );
	swigFunction( "c-function glBindBuffersBase glBindBuffersBase u u n a -- void", "FUNCTION: glBindBuffersBase ( target first count buffers -- void )", "EXTERN: \"C\" void glBindBuffersBase( int target, int first, int count, void * buffers );", "	( target first count buffers -- )" );
	swigFunction( "c-function glBindBuffersRange glBindBuffersRange u u n a a a -- void", "FUNCTION: glBindBuffersRange ( target first count buffers offsets sizes -- void )", "EXTERN: \"C\" void glBindBuffersRange( int target, int first, int count, void * buffers, void * offsets, void * sizes );", "	( target first count buffers offsets sizes -- )" );
	swigFunction( "c-function glBindTextures glBindTextures u n a -- void", "FUNCTION: glBindTextures ( first count textures -- void )", "EXTERN: \"C\" void glBindTextures( int first, int count, void * textures );", "	( first count textures -- )" );
	swigFunction( "c-function glBindSamplers glBindSamplers u n a -- void", "FUNCTION: glBindSamplers ( first count samplers -- void )", "EXTERN: \"C\" void glBindSamplers( int first, int count, void * samplers );", "	( first count samplers -- )" );
	swigFunction( "c-function glBindImageTextures glBindImageTextures u n a -- void", "FUNCTION: glBindImageTextures ( first count textures -- void )", "EXTERN: \"C\" void glBindImageTextures( int first, int count, void * textures );", "	( first count textures -- )" );
	swigFunction( "c-function glBindVertexBuffers glBindVertexBuffers u n a a a -- void", "FUNCTION: glBindVertexBuffers ( first count buffers offsets strides -- void )", "EXTERN: \"C\" void glBindVertexBuffers( int first, int count, void * buffers, void * offsets, void * strides );", "	( first count buffers offsets strides -- )" );
	swigFunction( "c-function glClipControl glClipControl u u -- void", "FUNCTION: glClipControl ( origin depth -- void )", "EXTERN: \"C\" void glClipControl( int origin, int depth );", "	( origin depth -- )" );
	swigFunction( "c-function glCreateTransformFeedbacks glCreateTransformFeedbacks n a -- void", "FUNCTION: glCreateTransformFeedbacks ( n ids -- void )", "EXTERN: \"C\" void glCreateTransformFeedbacks( int n, void * ids );", "	( n ids -- )" );
	swigFunction( "c-function glTransformFeedbackBufferBase glTransformFeedbackBufferBase u u u -- void", "FUNCTION: glTransformFeedbackBufferBase ( xfb index buffer -- void )", "EXTERN: \"C\" void glTransformFeedbackBufferBase( int xfb, int index, int buffer );", "	( xfb index buffer -- )" );
	swigFunction( "c-function glTransformFeedbackBufferRange glTransformFeedbackBufferRange u u u n n -- void", "FUNCTION: glTransformFeedbackBufferRange ( xfb index buffer offset size -- void )", "EXTERN: \"C\" void glTransformFeedbackBufferRange( int xfb, int index, int buffer, long offset, long size );", "	( xfb index buffer offset size -- )" );
	swigFunction( "c-function glGetTransformFeedbackiv glGetTransformFeedbackiv u u a -- void", "FUNCTION: glGetTransformFeedbackiv ( xfb pname param -- void )", "EXTERN: \"C\" void glGetTransformFeedbackiv( int xfb, int pname, void * param );", "	( xfb pname param -- )" );
	swigFunction( "c-function glGetTransformFeedbacki_v glGetTransformFeedbacki_v u u u a -- void", "FUNCTION: glGetTransformFeedbacki_v ( xfb pname index param -- void )", "EXTERN: \"C\" void glGetTransformFeedbacki_v( int xfb, int pname, int index, void * param );", "	( xfb pname index param -- )" );
	swigFunction( "c-function glGetTransformFeedbacki64_v glGetTransformFeedbacki64_v u u u a -- void", "FUNCTION: glGetTransformFeedbacki64_v ( xfb pname index param -- void )", "EXTERN: \"C\" void glGetTransformFeedbacki64_v( int xfb, int pname, int index, void * param );", "	( xfb pname index param -- )" );
	swigFunction( "c-function glCreateBuffers glCreateBuffers n a -- void", "FUNCTION: glCreateBuffers ( n buffers -- void )", "EXTERN: \"C\" void glCreateBuffers( int n, void * buffers );", "	( n buffers -- )" );
	swigFunction( "c-function glNamedBufferStorage glNamedBufferStorage u n a u -- void", "FUNCTION: glNamedBufferStorage ( buffer size data flags -- void )", "EXTERN: \"C\" void glNamedBufferStorage( int buffer, long size, void * data, int flags );", "	( buffer size data flags -- )" );
	swigFunction( "c-function glNamedBufferData glNamedBufferData u n a u -- void", "FUNCTION: glNamedBufferData ( buffer size data usage -- void )", "EXTERN: \"C\" void glNamedBufferData( int buffer, long size, void * data, int usage );", "	( buffer size data usage -- )" );
	swigFunction( "c-function glNamedBufferSubData glNamedBufferSubData u n n a -- void", "FUNCTION: glNamedBufferSubData ( buffer offset size data -- void )", "EXTERN: \"C\" void glNamedBufferSubData( int buffer, long offset, long size, void * data );", "	( buffer offset size data -- )" );
	swigFunction( "c-function glCopyNamedBufferSubData glCopyNamedBufferSubData u u n n n -- void", "FUNCTION: glCopyNamedBufferSubData ( readBuffer writeBuffer readOffset writeOffset size -- void )", "EXTERN: \"C\" void glCopyNamedBufferSubData( int readBuffer, int writeBuffer, long readOffset, long writeOffset, long size );", "	( readBuffer writeBuffer readOffset writeOffset size -- )" );
	swigFunction( "c-function glClearNamedBufferData glClearNamedBufferData u u u u a -- void", "FUNCTION: glClearNamedBufferData ( buffer internalformat format type data -- void )", "EXTERN: \"C\" void glClearNamedBufferData( int buffer, int internalformat, int format, int type, void * data );", "	( buffer internalformat format type data -- )" );
	swigFunction( "c-function glClearNamedBufferSubData glClearNamedBufferSubData u u n n u u a -- void", "FUNCTION: glClearNamedBufferSubData ( buffer internalformat offset size format type data -- void )", "EXTERN: \"C\" void glClearNamedBufferSubData( int buffer, int internalformat, long offset, long size, int format, int type, void * data );", "	( buffer internalformat offset size format type data -- )" );
	swigFunction( "c-function glMapNamedBuffer glMapNamedBuffer u u -- a", "FUNCTION: glMapNamedBuffer ( buffer access -- a )", "EXTERN: \"C\" void * glMapNamedBuffer( int buffer, int access );", "	( buffer access -- )" );
	swigFunction( "c-function glMapNamedBufferRange glMapNamedBufferRange u n n u -- a", "FUNCTION: glMapNamedBufferRange ( buffer offset length access -- a )", "EXTERN: \"C\" void * glMapNamedBufferRange( int buffer, long offset, long length, int access );", "	( buffer offset length access -- )" );
	swigFunction( "c-function glUnmapNamedBuffer glUnmapNamedBuffer u -- u", "FUNCTION: glUnmapNamedBuffer ( buffer -- u )", "EXTERN: \"C\" char glUnmapNamedBuffer( int buffer );", "	( buffer -- )" );
	swigFunction( "c-function glFlushMappedNamedBufferRange glFlushMappedNamedBufferRange u n n -- void", "FUNCTION: glFlushMappedNamedBufferRange ( buffer offset length -- void )", "EXTERN: \"C\" void glFlushMappedNamedBufferRange( int buffer, long offset, long length );", "	( buffer offset length -- )" );
	swigFunction( "c-function glGetNamedBufferParameteriv glGetNamedBufferParameteriv u u a -- void", "FUNCTION: glGetNamedBufferParameteriv ( buffer pname params -- void )", "EXTERN: \"C\" void glGetNamedBufferParameteriv( int buffer, int pname, void * params );", "	( buffer pname params -- )" );
	swigFunction( "c-function glGetNamedBufferParameteri64v glGetNamedBufferParameteri64v u u a -- void", "FUNCTION: glGetNamedBufferParameteri64v ( buffer pname params -- void )", "EXTERN: \"C\" void glGetNamedBufferParameteri64v( int buffer, int pname, void * params );", "	( buffer pname params -- )" );
	swigFunction( "c-function glGetNamedBufferPointerv glGetNamedBufferPointerv u u a -- void", "FUNCTION: glGetNamedBufferPointerv ( buffer pname params -- void )", "EXTERN: \"C\" void glGetNamedBufferPointerv( int buffer, int pname, void * params );", "	( buffer pname params -- )" );
	swigFunction( "c-function glGetNamedBufferSubData glGetNamedBufferSubData u n n a -- void", "FUNCTION: glGetNamedBufferSubData ( buffer offset size data -- void )", "EXTERN: \"C\" void glGetNamedBufferSubData( int buffer, long offset, long size, void * data );", "	( buffer offset size data -- )" );
	swigFunction( "c-function glCreateFramebuffers glCreateFramebuffers n a -- void", "FUNCTION: glCreateFramebuffers ( n framebuffers -- void )", "EXTERN: \"C\" void glCreateFramebuffers( int n, void * framebuffers );", "	( n framebuffers -- )" );
	swigFunction( "c-function glNamedFramebufferRenderbuffer glNamedFramebufferRenderbuffer u u u u -- void", "FUNCTION: glNamedFramebufferRenderbuffer ( framebuffer attachment renderbuffertarget renderbuffer -- void )", "EXTERN: \"C\" void glNamedFramebufferRenderbuffer( int framebuffer, int attachment, int renderbuffertarget, int renderbuffer );", "	( framebuffer attachment renderbuffertarget renderbuffer -- )" );
	swigFunction( "c-function glNamedFramebufferParameteri glNamedFramebufferParameteri u u n -- void", "FUNCTION: glNamedFramebufferParameteri ( framebuffer pname param -- void )", "EXTERN: \"C\" void glNamedFramebufferParameteri( int framebuffer, int pname, int param );", "	( framebuffer pname param -- )" );
	swigFunction( "c-function glNamedFramebufferTexture glNamedFramebufferTexture u u u n -- void", "FUNCTION: glNamedFramebufferTexture ( framebuffer attachment texture level -- void )", "EXTERN: \"C\" void glNamedFramebufferTexture( int framebuffer, int attachment, int texture, int level );", "	( framebuffer attachment texture level -- )" );
	swigFunction( "c-function glNamedFramebufferTextureLayer glNamedFramebufferTextureLayer u u u n n -- void", "FUNCTION: glNamedFramebufferTextureLayer ( framebuffer attachment texture level layer -- void )", "EXTERN: \"C\" void glNamedFramebufferTextureLayer( int framebuffer, int attachment, int texture, int level, int layer );", "	( framebuffer attachment texture level layer -- )" );
	swigFunction( "c-function glNamedFramebufferDrawBuffer glNamedFramebufferDrawBuffer u u -- void", "FUNCTION: glNamedFramebufferDrawBuffer ( framebuffer buf -- void )", "EXTERN: \"C\" void glNamedFramebufferDrawBuffer( int framebuffer, int buf );", "	( framebuffer buf -- )" );
	swigFunction( "c-function glNamedFramebufferDrawBuffers glNamedFramebufferDrawBuffers u n a -- void", "FUNCTION: glNamedFramebufferDrawBuffers ( framebuffer n bufs -- void )", "EXTERN: \"C\" void glNamedFramebufferDrawBuffers( int framebuffer, int n, void * bufs );", "	( framebuffer n bufs -- )" );
	swigFunction( "c-function glNamedFramebufferReadBuffer glNamedFramebufferReadBuffer u u -- void", "FUNCTION: glNamedFramebufferReadBuffer ( framebuffer src -- void )", "EXTERN: \"C\" void glNamedFramebufferReadBuffer( int framebuffer, int src );", "	( framebuffer src -- )" );
	swigFunction( "c-function glInvalidateNamedFramebufferData glInvalidateNamedFramebufferData u n a -- void", "FUNCTION: glInvalidateNamedFramebufferData ( framebuffer numAttachments attachments -- void )", "EXTERN: \"C\" void glInvalidateNamedFramebufferData( int framebuffer, int numAttachments, void * attachments );", "	( framebuffer numAttachments attachments -- )" );
	swigFunction( "c-function glInvalidateNamedFramebufferSubData glInvalidateNamedFramebufferSubData u n a n n n n -- void", "FUNCTION: glInvalidateNamedFramebufferSubData ( framebuffer numAttachments attachments x y width height -- void )", "EXTERN: \"C\" void glInvalidateNamedFramebufferSubData( int framebuffer, int numAttachments, void * attachments, int x, int y, int width, int height );", "	( framebuffer numAttachments attachments x y width height -- )" );
	swigFunction( "c-function glClearNamedFramebufferiv glClearNamedFramebufferiv u u n a -- void", "FUNCTION: glClearNamedFramebufferiv ( framebuffer buffer drawbuffer value -- void )", "EXTERN: \"C\" void glClearNamedFramebufferiv( int framebuffer, int buffer, int drawbuffer, void * value );", "	( framebuffer buffer drawbuffer value -- )" );
	swigFunction( "c-function glClearNamedFramebufferuiv glClearNamedFramebufferuiv u u n a -- void", "FUNCTION: glClearNamedFramebufferuiv ( framebuffer buffer drawbuffer value -- void )", "EXTERN: \"C\" void glClearNamedFramebufferuiv( int framebuffer, int buffer, int drawbuffer, void * value );", "	( framebuffer buffer drawbuffer value -- )" );
	swigFunction( "c-function glClearNamedFramebufferfv glClearNamedFramebufferfv u u n a -- void", "FUNCTION: glClearNamedFramebufferfv ( framebuffer buffer drawbuffer value -- void )", "EXTERN: \"C\" void glClearNamedFramebufferfv( int framebuffer, int buffer, int drawbuffer, void * value );", "	( framebuffer buffer drawbuffer value -- )" );
	swigFunction( "c-function glClearNamedFramebufferfi glClearNamedFramebufferfi u u n r n -- void", "FUNCTION: glClearNamedFramebufferfi ( framebuffer buffer drawbuffer depth stencil -- void )", "EXTERN: \"C\" void glClearNamedFramebufferfi( int framebuffer, int buffer, int drawbuffer, float depth, int stencil );", "	( framebuffer buffer drawbuffer depth stencil -- )" );
	swigFunction( "c-function glBlitNamedFramebuffer glBlitNamedFramebuffer u u n n n n n n n n u u -- void", "FUNCTION: glBlitNamedFramebuffer ( readFramebuffer drawFramebuffer srcX0 srcY0 srcX1 srcY1 dstX0 dstY0 dstX1 dstY1 mask filter -- void )", "EXTERN: \"C\" void glBlitNamedFramebuffer( int readFramebuffer, int drawFramebuffer, int srcX0, int srcY0, int srcX1, int srcY1, int dstX0, int dstY0, int dstX1, int dstY1, int mask, int filter );", "	( readFramebuffer drawFramebuffer srcX0 srcY0 srcX1 srcY1 dstX0 dstY0 dstX1 dstY1 mask filter -- )" );
	swigFunction( "c-function glCheckNamedFramebufferStatus glCheckNamedFramebufferStatus u u -- u", "FUNCTION: glCheckNamedFramebufferStatus ( framebuffer target -- u )", "EXTERN: \"C\" int glCheckNamedFramebufferStatus( int framebuffer, int target );", "	( framebuffer target -- )" );
	swigFunction( "c-function glGetNamedFramebufferParameteriv glGetNamedFramebufferParameteriv u u a -- void", "FUNCTION: glGetNamedFramebufferParameteriv ( framebuffer pname param -- void )", "EXTERN: \"C\" void glGetNamedFramebufferParameteriv( int framebuffer, int pname, void * param );", "	( framebuffer pname param -- )" );
	swigFunction( "c-function glGetNamedFramebufferAttachmentParameteriv glGetNamedFramebufferAttachmentParameteriv u u u a -- void", "FUNCTION: glGetNamedFramebufferAttachmentParameteriv ( framebuffer attachment pname params -- void )", "EXTERN: \"C\" void glGetNamedFramebufferAttachmentParameteriv( int framebuffer, int attachment, int pname, void * params );", "	( framebuffer attachment pname params -- )" );
	swigFunction( "c-function glCreateRenderbuffers glCreateRenderbuffers n a -- void", "FUNCTION: glCreateRenderbuffers ( n renderbuffers -- void )", "EXTERN: \"C\" void glCreateRenderbuffers( int n, void * renderbuffers );", "	( n renderbuffers -- )" );
	swigFunction( "c-function glNamedRenderbufferStorage glNamedRenderbufferStorage u u n n -- void", "FUNCTION: glNamedRenderbufferStorage ( renderbuffer internalformat width height -- void )", "EXTERN: \"C\" void glNamedRenderbufferStorage( int renderbuffer, int internalformat, int width, int height );", "	( renderbuffer internalformat width height -- )" );
	swigFunction( "c-function glNamedRenderbufferStorageMultisample glNamedRenderbufferStorageMultisample u n u n n -- void", "FUNCTION: glNamedRenderbufferStorageMultisample ( renderbuffer samples internalformat width height -- void )", "EXTERN: \"C\" void glNamedRenderbufferStorageMultisample( int renderbuffer, int samples, int internalformat, int width, int height );", "	( renderbuffer samples internalformat width height -- )" );
	swigFunction( "c-function glGetNamedRenderbufferParameteriv glGetNamedRenderbufferParameteriv u u a -- void", "FUNCTION: glGetNamedRenderbufferParameteriv ( renderbuffer pname params -- void )", "EXTERN: \"C\" void glGetNamedRenderbufferParameteriv( int renderbuffer, int pname, void * params );", "	( renderbuffer pname params -- )" );
	swigFunction( "c-function glCreateTextures glCreateTextures u n a -- void", "FUNCTION: glCreateTextures ( target n textures -- void )", "EXTERN: \"C\" void glCreateTextures( int target, int n, void * textures );", "	( target n textures -- )" );
	swigFunction( "c-function glTextureBuffer glTextureBuffer u u u -- void", "FUNCTION: glTextureBuffer ( texture internalformat buffer -- void )", "EXTERN: \"C\" void glTextureBuffer( int texture, int internalformat, int buffer );", "	( texture internalformat buffer -- )" );
	swigFunction( "c-function glTextureBufferRange glTextureBufferRange u u u n n -- void", "FUNCTION: glTextureBufferRange ( texture internalformat buffer offset size -- void )", "EXTERN: \"C\" void glTextureBufferRange( int texture, int internalformat, int buffer, long offset, long size );", "	( texture internalformat buffer offset size -- )" );
	swigFunction( "c-function glTextureStorage1D glTextureStorage1D u n u n -- void", "FUNCTION: glTextureStorage1D ( texture levels internalformat width -- void )", "EXTERN: \"C\" void glTextureStorage1D( int texture, int levels, int internalformat, int width );", "	( texture levels internalformat width -- )" );
	swigFunction( "c-function glTextureStorage2D glTextureStorage2D u n u n n -- void", "FUNCTION: glTextureStorage2D ( texture levels internalformat width height -- void )", "EXTERN: \"C\" void glTextureStorage2D( int texture, int levels, int internalformat, int width, int height );", "	( texture levels internalformat width height -- )" );
	swigFunction( "c-function glTextureStorage3D glTextureStorage3D u n u n n n -- void", "FUNCTION: glTextureStorage3D ( texture levels internalformat width height depth -- void )", "EXTERN: \"C\" void glTextureStorage3D( int texture, int levels, int internalformat, int width, int height, int depth );", "	( texture levels internalformat width height depth -- )" );
	swigFunction( "c-function glTextureStorage2DMultisample glTextureStorage2DMultisample u n u n n u -- void", "FUNCTION: glTextureStorage2DMultisample ( texture samples internalformat width height fixedsamplelocations -- void )", "EXTERN: \"C\" void glTextureStorage2DMultisample( int texture, int samples, int internalformat, int width, int height, char fixedsamplelocations );", "	( texture samples internalformat width height fixedsamplelocations -- )" );
	swigFunction( "c-function glTextureStorage3DMultisample glTextureStorage3DMultisample u n u n n n u -- void", "FUNCTION: glTextureStorage3DMultisample ( texture samples internalformat width height depth fixedsamplelocations -- void )", "EXTERN: \"C\" void glTextureStorage3DMultisample( int texture, int samples, int internalformat, int width, int height, int depth, char fixedsamplelocations );", "	( texture samples internalformat width height depth fixedsamplelocations -- )" );
	swigFunction( "c-function glTextureSubImage1D glTextureSubImage1D u n n n u u a -- void", "FUNCTION: glTextureSubImage1D ( texture level xoffset width format type pixels -- void )", "EXTERN: \"C\" void glTextureSubImage1D( int texture, int level, int xoffset, int width, int format, int type, void * pixels );", "	( texture level xoffset width format type pixels -- )" );
	swigFunction( "c-function glTextureSubImage2D glTextureSubImage2D u n n n n n u u a -- void", "FUNCTION: glTextureSubImage2D ( texture level xoffset yoffset width height format type pixels -- void )", "EXTERN: \"C\" void glTextureSubImage2D( int texture, int level, int xoffset, int yoffset, int width, int height, int format, int type, void * pixels );", "	( texture level xoffset yoffset width height format type pixels -- )" );
	swigFunction( "c-function glTextureSubImage3D glTextureSubImage3D u n n n n n n n u u a -- void", "FUNCTION: glTextureSubImage3D ( texture level xoffset yoffset zoffset width height depth format type pixels -- void )", "EXTERN: \"C\" void glTextureSubImage3D( int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, void * pixels );", "	( texture level xoffset yoffset zoffset width height depth format type pixels -- )" );
	swigFunction( "c-function glCompressedTextureSubImage1D glCompressedTextureSubImage1D u n n n u n a -- void", "FUNCTION: glCompressedTextureSubImage1D ( texture level xoffset width format imageSize data -- void )", "EXTERN: \"C\" void glCompressedTextureSubImage1D( int texture, int level, int xoffset, int width, int format, int imageSize, void * data );", "	( texture level xoffset width format imageSize data -- )" );
	swigFunction( "c-function glCompressedTextureSubImage2D glCompressedTextureSubImage2D u n n n n n u n a -- void", "FUNCTION: glCompressedTextureSubImage2D ( texture level xoffset yoffset width height format imageSize data -- void )", "EXTERN: \"C\" void glCompressedTextureSubImage2D( int texture, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, void * data );", "	( texture level xoffset yoffset width height format imageSize data -- )" );
	swigFunction( "c-function glCompressedTextureSubImage3D glCompressedTextureSubImage3D u n n n n n n n u n a -- void", "FUNCTION: glCompressedTextureSubImage3D ( texture level xoffset yoffset zoffset width height depth format imageSize data -- void )", "EXTERN: \"C\" void glCompressedTextureSubImage3D( int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int imageSize, void * data );", "	( texture level xoffset yoffset zoffset width height depth format imageSize data -- )" );
	swigFunction( "c-function glCopyTextureSubImage1D glCopyTextureSubImage1D u n n n n n -- void", "FUNCTION: glCopyTextureSubImage1D ( texture level xoffset x y width -- void )", "EXTERN: \"C\" void glCopyTextureSubImage1D( int texture, int level, int xoffset, int x, int y, int width );", "	( texture level xoffset x y width -- )" );
	swigFunction( "c-function glCopyTextureSubImage2D glCopyTextureSubImage2D u n n n n n n n -- void", "FUNCTION: glCopyTextureSubImage2D ( texture level xoffset yoffset x y width height -- void )", "EXTERN: \"C\" void glCopyTextureSubImage2D( int texture, int level, int xoffset, int yoffset, int x, int y, int width, int height );", "	( texture level xoffset yoffset x y width height -- )" );
	swigFunction( "c-function glCopyTextureSubImage3D glCopyTextureSubImage3D u n n n n n n n n -- void", "FUNCTION: glCopyTextureSubImage3D ( texture level xoffset yoffset zoffset x y width height -- void )", "EXTERN: \"C\" void glCopyTextureSubImage3D( int texture, int level, int xoffset, int yoffset, int zoffset, int x, int y, int width, int height );", "	( texture level xoffset yoffset zoffset x y width height -- )" );
	swigFunction( "c-function glTextureParameterf glTextureParameterf u u r -- void", "FUNCTION: glTextureParameterf ( texture pname param -- void )", "EXTERN: \"C\" void glTextureParameterf( int texture, int pname, float param );", "	( texture pname param -- )" );
	swigFunction( "c-function glTextureParameterfv glTextureParameterfv u u a -- void", "FUNCTION: glTextureParameterfv ( texture pname param -- void )", "EXTERN: \"C\" void glTextureParameterfv( int texture, int pname, void * param );", "	( texture pname param -- )" );
	swigFunction( "c-function glTextureParameteri glTextureParameteri u u n -- void", "FUNCTION: glTextureParameteri ( texture pname param -- void )", "EXTERN: \"C\" void glTextureParameteri( int texture, int pname, int param );", "	( texture pname param -- )" );
	swigFunction( "c-function glTextureParameterIiv glTextureParameterIiv u u a -- void", "FUNCTION: glTextureParameterIiv ( texture pname params -- void )", "EXTERN: \"C\" void glTextureParameterIiv( int texture, int pname, void * params );", "	( texture pname params -- )" );
	swigFunction( "c-function glTextureParameterIuiv glTextureParameterIuiv u u a -- void", "FUNCTION: glTextureParameterIuiv ( texture pname params -- void )", "EXTERN: \"C\" void glTextureParameterIuiv( int texture, int pname, void * params );", "	( texture pname params -- )" );
	swigFunction( "c-function glTextureParameteriv glTextureParameteriv u u a -- void", "FUNCTION: glTextureParameteriv ( texture pname param -- void )", "EXTERN: \"C\" void glTextureParameteriv( int texture, int pname, void * param );", "	( texture pname param -- )" );
	swigFunction( "c-function glGenerateTextureMipmap glGenerateTextureMipmap u -- void", "FUNCTION: glGenerateTextureMipmap ( texture -- void )", "EXTERN: \"C\" void glGenerateTextureMipmap( int texture );", "	( texture -- )" );
	swigFunction( "c-function glBindTextureUnit glBindTextureUnit u u -- void", "FUNCTION: glBindTextureUnit ( unit texture -- void )", "EXTERN: \"C\" void glBindTextureUnit( int unit, int texture );", "	( unit texture -- )" );
	swigFunction( "c-function glGetTextureImage glGetTextureImage u n u u n a -- void", "FUNCTION: glGetTextureImage ( texture level format type bufSize pixels -- void )", "EXTERN: \"C\" void glGetTextureImage( int texture, int level, int format, int type, int bufSize, void * pixels );", "	( texture level format type bufSize pixels -- )" );
	swigFunction( "c-function glGetCompressedTextureImage glGetCompressedTextureImage u n n a -- void", "FUNCTION: glGetCompressedTextureImage ( texture level bufSize pixels -- void )", "EXTERN: \"C\" void glGetCompressedTextureImage( int texture, int level, int bufSize, void * pixels );", "	( texture level bufSize pixels -- )" );
	swigFunction( "c-function glGetTextureLevelParameterfv glGetTextureLevelParameterfv u n u a -- void", "FUNCTION: glGetTextureLevelParameterfv ( texture level pname params -- void )", "EXTERN: \"C\" void glGetTextureLevelParameterfv( int texture, int level, int pname, void * params );", "	( texture level pname params -- )" );
	swigFunction( "c-function glGetTextureLevelParameteriv glGetTextureLevelParameteriv u n u a -- void", "FUNCTION: glGetTextureLevelParameteriv ( texture level pname params -- void )", "EXTERN: \"C\" void glGetTextureLevelParameteriv( int texture, int level, int pname, void * params );", "	( texture level pname params -- )" );
	swigFunction( "c-function glGetTextureParameterfv glGetTextureParameterfv u u a -- void", "FUNCTION: glGetTextureParameterfv ( texture pname params -- void )", "EXTERN: \"C\" void glGetTextureParameterfv( int texture, int pname, void * params );", "	( texture pname params -- )" );
	swigFunction( "c-function glGetTextureParameterIiv glGetTextureParameterIiv u u a -- void", "FUNCTION: glGetTextureParameterIiv ( texture pname params -- void )", "EXTERN: \"C\" void glGetTextureParameterIiv( int texture, int pname, void * params );", "	( texture pname params -- )" );
	swigFunction( "c-function glGetTextureParameterIuiv glGetTextureParameterIuiv u u a -- void", "FUNCTION: glGetTextureParameterIuiv ( texture pname params -- void )", "EXTERN: \"C\" void glGetTextureParameterIuiv( int texture, int pname, void * params );", "	( texture pname params -- )" );
	swigFunction( "c-function glGetTextureParameteriv glGetTextureParameteriv u u a -- void", "FUNCTION: glGetTextureParameteriv ( texture pname params -- void )", "EXTERN: \"C\" void glGetTextureParameteriv( int texture, int pname, void * params );", "	( texture pname params -- )" );
	swigFunction( "c-function glCreateVertexArrays glCreateVertexArrays n a -- void", "FUNCTION: glCreateVertexArrays ( n arrays -- void )", "EXTERN: \"C\" void glCreateVertexArrays( int n, void * arrays );", "	( n arrays -- )" );
	swigFunction( "c-function glDisableVertexArrayAttrib glDisableVertexArrayAttrib u u -- void", "FUNCTION: glDisableVertexArrayAttrib ( vaobj index -- void )", "EXTERN: \"C\" void glDisableVertexArrayAttrib( int vaobj, int index );", "	( vaobj index -- )" );
	swigFunction( "c-function glEnableVertexArrayAttrib glEnableVertexArrayAttrib u u -- void", "FUNCTION: glEnableVertexArrayAttrib ( vaobj index -- void )", "EXTERN: \"C\" void glEnableVertexArrayAttrib( int vaobj, int index );", "	( vaobj index -- )" );
	swigFunction( "c-function glVertexArrayElementBuffer glVertexArrayElementBuffer u u -- void", "FUNCTION: glVertexArrayElementBuffer ( vaobj buffer -- void )", "EXTERN: \"C\" void glVertexArrayElementBuffer( int vaobj, int buffer );", "	( vaobj buffer -- )" );
	swigFunction( "c-function glVertexArrayVertexBuffer glVertexArrayVertexBuffer u u u n n -- void", "FUNCTION: glVertexArrayVertexBuffer ( vaobj bindingindex buffer offset stride -- void )", "EXTERN: \"C\" void glVertexArrayVertexBuffer( int vaobj, int bindingindex, int buffer, long offset, int stride );", "	( vaobj bindingindex buffer offset stride -- )" );
	swigFunction( "c-function glVertexArrayVertexBuffers glVertexArrayVertexBuffers u u n a a a -- void", "FUNCTION: glVertexArrayVertexBuffers ( vaobj first count buffers offsets strides -- void )", "EXTERN: \"C\" void glVertexArrayVertexBuffers( int vaobj, int first, int count, void * buffers, void * offsets, void * strides );", "	( vaobj first count buffers offsets strides -- )" );
	swigFunction( "c-function glVertexArrayAttribBinding glVertexArrayAttribBinding u u u -- void", "FUNCTION: glVertexArrayAttribBinding ( vaobj attribindex bindingindex -- void )", "EXTERN: \"C\" void glVertexArrayAttribBinding( int vaobj, int attribindex, int bindingindex );", "	( vaobj attribindex bindingindex -- )" );
	swigFunction( "c-function glVertexArrayAttribFormat glVertexArrayAttribFormat u u n u u u -- void", "FUNCTION: glVertexArrayAttribFormat ( vaobj attribindex size type normalized relativeoffset -- void )", "EXTERN: \"C\" void glVertexArrayAttribFormat( int vaobj, int attribindex, int size, int type, char normalized, int relativeoffset );", "	( vaobj attribindex size type normalized relativeoffset -- )" );
	swigFunction( "c-function glVertexArrayAttribIFormat glVertexArrayAttribIFormat u u n u u -- void", "FUNCTION: glVertexArrayAttribIFormat ( vaobj attribindex size type relativeoffset -- void )", "EXTERN: \"C\" void glVertexArrayAttribIFormat( int vaobj, int attribindex, int size, int type, int relativeoffset );", "	( vaobj attribindex size type relativeoffset -- )" );
	swigFunction( "c-function glVertexArrayAttribLFormat glVertexArrayAttribLFormat u u n u u -- void", "FUNCTION: glVertexArrayAttribLFormat ( vaobj attribindex size type relativeoffset -- void )", "EXTERN: \"C\" void glVertexArrayAttribLFormat( int vaobj, int attribindex, int size, int type, int relativeoffset );", "	( vaobj attribindex size type relativeoffset -- )" );
	swigFunction( "c-function glVertexArrayBindingDivisor glVertexArrayBindingDivisor u u u -- void", "FUNCTION: glVertexArrayBindingDivisor ( vaobj bindingindex divisor -- void )", "EXTERN: \"C\" void glVertexArrayBindingDivisor( int vaobj, int bindingindex, int divisor );", "	( vaobj bindingindex divisor -- )" );
	swigFunction( "c-function glGetVertexArrayiv glGetVertexArrayiv u u a -- void", "FUNCTION: glGetVertexArrayiv ( vaobj pname param -- void )", "EXTERN: \"C\" void glGetVertexArrayiv( int vaobj, int pname, void * param );", "	( vaobj pname param -- )" );
	swigFunction( "c-function glGetVertexArrayIndexediv glGetVertexArrayIndexediv u u u a -- void", "FUNCTION: glGetVertexArrayIndexediv ( vaobj index pname param -- void )", "EXTERN: \"C\" void glGetVertexArrayIndexediv( int vaobj, int index, int pname, void * param );", "	( vaobj index pname param -- )" );
	swigFunction( "c-function glGetVertexArrayIndexed64iv glGetVertexArrayIndexed64iv u u u a -- void", "FUNCTION: glGetVertexArrayIndexed64iv ( vaobj index pname param -- void )", "EXTERN: \"C\" void glGetVertexArrayIndexed64iv( int vaobj, int index, int pname, void * param );", "	( vaobj index pname param -- )" );
	swigFunction( "c-function glCreateSamplers glCreateSamplers n a -- void", "FUNCTION: glCreateSamplers ( n samplers -- void )", "EXTERN: \"C\" void glCreateSamplers( int n, void * samplers );", "	( n samplers -- )" );
	swigFunction( "c-function glCreateProgramPipelines glCreateProgramPipelines n a -- void", "FUNCTION: glCreateProgramPipelines ( n pipelines -- void )", "EXTERN: \"C\" void glCreateProgramPipelines( int n, void * pipelines );", "	( n pipelines -- )" );
	swigFunction( "c-function glCreateQueries glCreateQueries u n a -- void", "FUNCTION: glCreateQueries ( target n ids -- void )", "EXTERN: \"C\" void glCreateQueries( int target, int n, void * ids );", "	( target n ids -- )" );
	swigFunction( "c-function glGetQueryBufferObjecti64v glGetQueryBufferObjecti64v u u u n -- void", "FUNCTION: glGetQueryBufferObjecti64v ( id buffer pname offset -- void )", "EXTERN: \"C\" void glGetQueryBufferObjecti64v( int id, int buffer, int pname, long offset );", "	( id buffer pname offset -- )" );
	swigFunction( "c-function glGetQueryBufferObjectiv glGetQueryBufferObjectiv u u u n -- void", "FUNCTION: glGetQueryBufferObjectiv ( id buffer pname offset -- void )", "EXTERN: \"C\" void glGetQueryBufferObjectiv( int id, int buffer, int pname, long offset );", "	( id buffer pname offset -- )" );
	swigFunction( "c-function glGetQueryBufferObjectui64v glGetQueryBufferObjectui64v u u u n -- void", "FUNCTION: glGetQueryBufferObjectui64v ( id buffer pname offset -- void )", "EXTERN: \"C\" void glGetQueryBufferObjectui64v( int id, int buffer, int pname, long offset );", "	( id buffer pname offset -- )" );
	swigFunction( "c-function glGetQueryBufferObjectuiv glGetQueryBufferObjectuiv u u u n -- void", "FUNCTION: glGetQueryBufferObjectuiv ( id buffer pname offset -- void )", "EXTERN: \"C\" void glGetQueryBufferObjectuiv( int id, int buffer, int pname, long offset );", "	( id buffer pname offset -- )" );
	swigFunction( "c-function glMemoryBarrierByRegion glMemoryBarrierByRegion u -- void", "FUNCTION: glMemoryBarrierByRegion ( barriers -- void )", "EXTERN: \"C\" void glMemoryBarrierByRegion( int barriers );", "	( barriers -- )" );
	swigFunction( "c-function glGetTextureSubImage glGetTextureSubImage u n n n n n n n u u n a -- void", "FUNCTION: glGetTextureSubImage ( texture level xoffset yoffset zoffset width height depth format type bufSize pixels -- void )", "EXTERN: \"C\" void glGetTextureSubImage( int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, int bufSize, void * pixels );", "	( texture level xoffset yoffset zoffset width height depth format type bufSize pixels -- )" );
	swigFunction( "c-function glGetCompressedTextureSubImage glGetCompressedTextureSubImage u n n n n n n n n a -- void", "FUNCTION: glGetCompressedTextureSubImage ( texture level xoffset yoffset zoffset width height depth bufSize pixels -- void )", "EXTERN: \"C\" void glGetCompressedTextureSubImage( int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int bufSize, void * pixels );", "	( texture level xoffset yoffset zoffset width height depth bufSize pixels -- )" );
	swigFunction( "c-function glGetGraphicsResetStatus glGetGraphicsResetStatus  -- u", "FUNCTION: glGetGraphicsResetStatus (  -- u )", "EXTERN: \"C\" int glGetGraphicsResetStatus(  );", "	( -- )" );
	swigFunction( "c-function glGetnCompressedTexImage glGetnCompressedTexImage u n n a -- void", "FUNCTION: glGetnCompressedTexImage ( target lod bufSize pixels -- void )", "EXTERN: \"C\" void glGetnCompressedTexImage( int target, int lod, int bufSize, void * pixels );", "	( target lod bufSize pixels -- )" );
	swigFunction( "c-function glGetnTexImage glGetnTexImage u n u u n a -- void", "FUNCTION: glGetnTexImage ( target level format type bufSize pixels -- void )", "EXTERN: \"C\" void glGetnTexImage( int target, int level, int format, int type, int bufSize, void * pixels );", "	( target level format type bufSize pixels -- )" );
	swigFunction( "c-function glGetnUniformdv glGetnUniformdv u n n a -- void", "FUNCTION: glGetnUniformdv ( program location bufSize params -- void )", "EXTERN: \"C\" void glGetnUniformdv( int program, int location, int bufSize, void * params );", "	( program location bufSize params -- )" );
	swigFunction( "c-function glGetnUniformfv glGetnUniformfv u n n a -- void", "FUNCTION: glGetnUniformfv ( program location bufSize params -- void )", "EXTERN: \"C\" void glGetnUniformfv( int program, int location, int bufSize, void * params );", "	( program location bufSize params -- )" );
	swigFunction( "c-function glGetnUniformiv glGetnUniformiv u n n a -- void", "FUNCTION: glGetnUniformiv ( program location bufSize params -- void )", "EXTERN: \"C\" void glGetnUniformiv( int program, int location, int bufSize, void * params );", "	( program location bufSize params -- )" );
	swigFunction( "c-function glGetnUniformuiv glGetnUniformuiv u n n a -- void", "FUNCTION: glGetnUniformuiv ( program location bufSize params -- void )", "EXTERN: \"C\" void glGetnUniformuiv( int program, int location, int bufSize, void * params );", "	( program location bufSize params -- )" );
	swigFunction( "c-function glReadnPixels glReadnPixels n n n n u u n a -- void", "FUNCTION: glReadnPixels ( x y width height format type bufSize data -- void )", "EXTERN: \"C\" void glReadnPixels( int x, int y, int width, int height, int format, int type, int bufSize, void * data );", "	( x y width height format type bufSize data -- )" );
	swigFunction( "c-function glGetnMapdv glGetnMapdv u u n a -- void", "FUNCTION: glGetnMapdv ( target query bufSize v -- void )", "EXTERN: \"C\" void glGetnMapdv( int target, int query, int bufSize, void * v );", "	( target query bufSize v -- )" );
	swigFunction( "c-function glGetnMapfv glGetnMapfv u u n a -- void", "FUNCTION: glGetnMapfv ( target query bufSize v -- void )", "EXTERN: \"C\" void glGetnMapfv( int target, int query, int bufSize, void * v );", "	( target query bufSize v -- )" );
	swigFunction( "c-function glGetnMapiv glGetnMapiv u u n a -- void", "FUNCTION: glGetnMapiv ( target query bufSize v -- void )", "EXTERN: \"C\" void glGetnMapiv( int target, int query, int bufSize, void * v );", "	( target query bufSize v -- )" );
	swigFunction( "c-function glGetnPixelMapfv glGetnPixelMapfv u n a -- void", "FUNCTION: glGetnPixelMapfv ( map bufSize values -- void )", "EXTERN: \"C\" void glGetnPixelMapfv( int map, int bufSize, void * values );", "	( map bufSize values -- )" );
	swigFunction( "c-function glGetnPixelMapuiv glGetnPixelMapuiv u n a -- void", "FUNCTION: glGetnPixelMapuiv ( map bufSize values -- void )", "EXTERN: \"C\" void glGetnPixelMapuiv( int map, int bufSize, void * values );", "	( map bufSize values -- )" );
	swigFunction( "c-function glGetnPixelMapusv glGetnPixelMapusv u n a -- void", "FUNCTION: glGetnPixelMapusv ( map bufSize values -- void )", "EXTERN: \"C\" void glGetnPixelMapusv( int map, int bufSize, void * values );", "	( map bufSize values -- )" );
	swigFunction( "c-function glGetnPolygonStipple glGetnPolygonStipple n a -- void", "FUNCTION: glGetnPolygonStipple ( bufSize pattern -- void )", "EXTERN: \"C\" void glGetnPolygonStipple( int bufSize, void * pattern );", "	( bufSize pattern -- )" );
	swigFunction( "c-function glGetnColorTable glGetnColorTable u u u n a -- void", "FUNCTION: glGetnColorTable ( target format type bufSize table -- void )", "EXTERN: \"C\" void glGetnColorTable( int target, int format, int type, int bufSize, void * table );", "	( target format type bufSize table -- )" );
	swigFunction( "c-function glGetnConvolutionFilter glGetnConvolutionFilter u u u n a -- void", "FUNCTION: glGetnConvolutionFilter ( target format type bufSize image -- void )", "EXTERN: \"C\" void glGetnConvolutionFilter( int target, int format, int type, int bufSize, void * image );", "	( target format type bufSize image -- )" );
	swigFunction( "c-function glGetnSeparableFilter glGetnSeparableFilter u u u n a n a a -- void", "FUNCTION: glGetnSeparableFilter ( target format type rowBufSize row columnBufSize column span -- void )", "EXTERN: \"C\" void glGetnSeparableFilter( int target, int format, int type, int rowBufSize, void * row, int columnBufSize, void * column, void * span );", "	( target format type rowBufSize row columnBufSize column span -- )" );
	swigFunction( "c-function glGetnHistogram glGetnHistogram u u u u n a -- void", "FUNCTION: glGetnHistogram ( target reset format type bufSize values -- void )", "EXTERN: \"C\" void glGetnHistogram( int target, char reset, int format, int type, int bufSize, void * values );", "	( target reset format type bufSize values -- )" );
	swigFunction( "c-function glGetnMinmax glGetnMinmax u u u u n a -- void", "FUNCTION: glGetnMinmax ( target reset format type bufSize values -- void )", "EXTERN: \"C\" void glGetnMinmax( int target, char reset, int format, int type, int bufSize, void * values );", "	( target reset format type bufSize values -- )" );
	swigFunction( "c-function glTextureBarrier glTextureBarrier  -- void", "FUNCTION: glTextureBarrier (  -- void )", "EXTERN: \"C\" void glTextureBarrier(  );", "	( -- )" );
	swigFunction( "c-function glSpecializeShader glSpecializeShader u s u a a -- void", "FUNCTION: glSpecializeShader ( shader pEntryPoint numSpecializationConstants pConstantIndex pConstantValue -- void )", "EXTERN: \"C\" void glSpecializeShader( int shader, char * pEntryPoint, int numSpecializationConstants, void * pConstantIndex, void * pConstantValue );", "	( shader pEntryPoint numSpecializationConstants pConstantIndex pConstantValue -- )" );
	swigFunction( "c-function glMultiDrawArraysIndirectCount glMultiDrawArraysIndirectCount u a n n n -- void", "FUNCTION: glMultiDrawArraysIndirectCount ( mode indirect drawcount maxdrawcount stride -- void )", "EXTERN: \"C\" void glMultiDrawArraysIndirectCount( int mode, void * indirect, long drawcount, int maxdrawcount, int stride );", "	( mode indirect drawcount maxdrawcount stride -- )" );
	swigFunction( "c-function glMultiDrawElementsIndirectCount glMultiDrawElementsIndirectCount u u a n n n -- void", "FUNCTION: glMultiDrawElementsIndirectCount ( mode type indirect drawcount maxdrawcount stride -- void )", "EXTERN: \"C\" void glMultiDrawElementsIndirectCount( int mode, int type, void * indirect, long drawcount, int maxdrawcount, int stride );", "	( mode type indirect drawcount maxdrawcount stride -- )" );
	swigFunction( "c-function glPolygonOffsetClamp glPolygonOffsetClamp r r r -- void", "FUNCTION: glPolygonOffsetClamp ( factor units clamp -- void )", "EXTERN: \"C\" void glPolygonOffsetClamp( float factor, float units, float clamp );", "	( factor units clamp -- )" );
	swigFunction( "c-function glPrimitiveBoundingBoxARB glPrimitiveBoundingBoxARB r r r r r r r r -- void", "FUNCTION: glPrimitiveBoundingBoxARB ( minX minY minZ minW maxX maxY maxZ maxW -- void )", "EXTERN: \"C\" void glPrimitiveBoundingBoxARB( float minX, float minY, float minZ, float minW, float maxX, float maxY, float maxZ, float maxW );", "	( minX minY minZ minW maxX maxY maxZ maxW -- )" );
	swigFunction( "c-function glGetTextureHandleARB glGetTextureHandleARB u -- d", "FUNCTION: glGetTextureHandleARB ( texture -- d )", "EXTERN: \"C\" long long glGetTextureHandleARB( int texture );", "	( texture -- )" );
	swigFunction( "c-function glGetTextureSamplerHandleARB glGetTextureSamplerHandleARB u u -- d", "FUNCTION: glGetTextureSamplerHandleARB ( texture sampler -- d )", "EXTERN: \"C\" long long glGetTextureSamplerHandleARB( int texture, int sampler );", "	( texture sampler -- )" );
	swigFunction( "c-function glMakeTextureHandleResidentARB glMakeTextureHandleResidentARB d -- void", "FUNCTION: glMakeTextureHandleResidentARB ( handle -- void )", "EXTERN: \"C\" void glMakeTextureHandleResidentARB( long long handle );", "	( handle -- )" );
	swigFunction( "c-function glMakeTextureHandleNonResidentARB glMakeTextureHandleNonResidentARB d -- void", "FUNCTION: glMakeTextureHandleNonResidentARB ( handle -- void )", "EXTERN: \"C\" void glMakeTextureHandleNonResidentARB( long long handle );", "	( handle -- )" );
	swigFunction( "c-function glGetImageHandleARB glGetImageHandleARB u n u n u -- d", "FUNCTION: glGetImageHandleARB ( texture level layered layer format -- d )", "EXTERN: \"C\" long long glGetImageHandleARB( int texture, int level, char layered, int layer, int format );", "	( texture level layered layer format -- )" );
	swigFunction( "c-function glMakeImageHandleResidentARB glMakeImageHandleResidentARB d u -- void", "FUNCTION: glMakeImageHandleResidentARB ( handle access -- void )", "EXTERN: \"C\" void glMakeImageHandleResidentARB( long long handle, int access );", "	( handle access -- )" );
	swigFunction( "c-function glMakeImageHandleNonResidentARB glMakeImageHandleNonResidentARB d -- void", "FUNCTION: glMakeImageHandleNonResidentARB ( handle -- void )", "EXTERN: \"C\" void glMakeImageHandleNonResidentARB( long long handle );", "	( handle -- )" );
	swigFunction( "c-function glUniformHandleui64ARB glUniformHandleui64ARB n d -- void", "FUNCTION: glUniformHandleui64ARB ( location value -- void )", "EXTERN: \"C\" void glUniformHandleui64ARB( int location, long long value );", "	( location value -- )" );
	swigFunction( "c-function glUniformHandleui64vARB glUniformHandleui64vARB n n a -- void", "FUNCTION: glUniformHandleui64vARB ( location count value -- void )", "EXTERN: \"C\" void glUniformHandleui64vARB( int location, int count, void * value );", "	( location count value -- )" );
	swigFunction( "c-function glProgramUniformHandleui64ARB glProgramUniformHandleui64ARB u n d -- void", "FUNCTION: glProgramUniformHandleui64ARB ( program location value -- void )", "EXTERN: \"C\" void glProgramUniformHandleui64ARB( int program, int location, long long value );", "	( program location value -- )" );
	swigFunction( "c-function glProgramUniformHandleui64vARB glProgramUniformHandleui64vARB u n n a -- void", "FUNCTION: glProgramUniformHandleui64vARB ( program location count values -- void )", "EXTERN: \"C\" void glProgramUniformHandleui64vARB( int program, int location, int count, void * values );", "	( program location count values -- )" );
	swigFunction( "c-function glIsTextureHandleResidentARB glIsTextureHandleResidentARB d -- u", "FUNCTION: glIsTextureHandleResidentARB ( handle -- u )", "EXTERN: \"C\" char glIsTextureHandleResidentARB( long long handle );", "	( handle -- )" );
	swigFunction( "c-function glIsImageHandleResidentARB glIsImageHandleResidentARB d -- u", "FUNCTION: glIsImageHandleResidentARB ( handle -- u )", "EXTERN: \"C\" char glIsImageHandleResidentARB( long long handle );", "	( handle -- )" );
	swigFunction( "c-function glVertexAttribL1ui64ARB glVertexAttribL1ui64ARB u d -- void", "FUNCTION: glVertexAttribL1ui64ARB ( index x -- void )", "EXTERN: \"C\" void glVertexAttribL1ui64ARB( int index, long long x );", "	( index x -- )" );
	swigFunction( "c-function glVertexAttribL1ui64vARB glVertexAttribL1ui64vARB u a -- void", "FUNCTION: glVertexAttribL1ui64vARB ( index v -- void )", "EXTERN: \"C\" void glVertexAttribL1ui64vARB( int index, void * v );", "	( index v -- )" );
	swigFunction( "c-function glGetVertexAttribLui64vARB glGetVertexAttribLui64vARB u u a -- void", "FUNCTION: glGetVertexAttribLui64vARB ( index pname params -- void )", "EXTERN: \"C\" void glGetVertexAttribLui64vARB( int index, int pname, void * params );", "	( index pname params -- )" );
	swigFunction( "c-function glCreateSyncFromCLeventARB glCreateSyncFromCLeventARB a a u -- a", "FUNCTION: glCreateSyncFromCLeventARB ( context event flags -- a )", "EXTERN: \"C\" void * glCreateSyncFromCLeventARB( void * context, void * event, int flags );", "	( context event flags -- )" );
	swigFunction( "c-function glClampColorARB glClampColorARB u u -- void", "FUNCTION: glClampColorARB ( target clamp -- void )", "EXTERN: \"C\" void glClampColorARB( int target, int clamp );", "	( target clamp -- )" );
	swigFunction( "c-function glDispatchComputeGroupSizeARB glDispatchComputeGroupSizeARB u u u u u u -- void", "FUNCTION: glDispatchComputeGroupSizeARB ( num_groups_x num_groups_y num_groups_z group_size_x group_size_y group_size_z -- void )", "EXTERN: \"C\" void glDispatchComputeGroupSizeARB( int num_groups_x, int num_groups_y, int num_groups_z, int group_size_x, int group_size_y, int group_size_z );", "	( num_groups_x num_groups_y num_groups_z group_size_x group_size_y group_size_z -- )" );
	swigFunction( "c-function glDebugMessageControlARB glDebugMessageControlARB u u u n a u -- void", "FUNCTION: glDebugMessageControlARB ( source type severity count ids enabled -- void )", "EXTERN: \"C\" void glDebugMessageControlARB( int source, int type, int severity, int count, void * ids, char enabled );", "	( source type severity count ids enabled -- )" );
	swigFunction( "c-function glDebugMessageInsertARB glDebugMessageInsertARB u u u u n s -- void", "FUNCTION: glDebugMessageInsertARB ( source type id severity length buf -- void )", "EXTERN: \"C\" void glDebugMessageInsertARB( int source, int type, int id, int severity, int length, char * buf );", "	( source type id severity length buf -- )" );
	swigFunction( "c-function glDebugMessageCallbackARB glDebugMessageCallbackARB a a -- void", "FUNCTION: glDebugMessageCallbackARB ( callback userParam -- void )", "EXTERN: \"C\" void glDebugMessageCallbackARB( void * callback, void * userParam );", "	( callback userParam -- )" );
	swigFunction( "c-function glGetDebugMessageLogARB glGetDebugMessageLogARB u n a a a a a a -- u", "FUNCTION: glGetDebugMessageLogARB ( count bufSize sources types ids severities lengths messageLog -- u )", "EXTERN: \"C\" int glGetDebugMessageLogARB( int count, int bufSize, void * sources, void * types, void * ids, void * severities, void * lengths, void * messageLog );", "	( count bufSize sources types ids severities lengths messageLog -- )" );
	swigFunction( "c-function glDrawBuffersARB glDrawBuffersARB n a -- void", "FUNCTION: glDrawBuffersARB ( n bufs -- void )", "EXTERN: \"C\" void glDrawBuffersARB( int n, void * bufs );", "	( n bufs -- )" );
	swigFunction( "c-function glBlendEquationiARB glBlendEquationiARB u u -- void", "FUNCTION: glBlendEquationiARB ( buf mode -- void )", "EXTERN: \"C\" void glBlendEquationiARB( int buf, int mode );", "	( buf mode -- )" );
	swigFunction( "c-function glBlendEquationSeparateiARB glBlendEquationSeparateiARB u u u -- void", "FUNCTION: glBlendEquationSeparateiARB ( buf modeRGB modeAlpha -- void )", "EXTERN: \"C\" void glBlendEquationSeparateiARB( int buf, int modeRGB, int modeAlpha );", "	( buf modeRGB modeAlpha -- )" );
	swigFunction( "c-function glBlendFunciARB glBlendFunciARB u u u -- void", "FUNCTION: glBlendFunciARB ( buf src dst -- void )", "EXTERN: \"C\" void glBlendFunciARB( int buf, int src, int dst );", "	( buf src dst -- )" );
	swigFunction( "c-function glBlendFuncSeparateiARB glBlendFuncSeparateiARB u u u u u -- void", "FUNCTION: glBlendFuncSeparateiARB ( buf srcRGB dstRGB srcAlpha dstAlpha -- void )", "EXTERN: \"C\" void glBlendFuncSeparateiARB( int buf, int srcRGB, int dstRGB, int srcAlpha, int dstAlpha );", "	( buf srcRGB dstRGB srcAlpha dstAlpha -- )" );
	swigFunction( "c-function glDrawArraysInstancedARB glDrawArraysInstancedARB u n n n -- void", "FUNCTION: glDrawArraysInstancedARB ( mode first count primcount -- void )", "EXTERN: \"C\" void glDrawArraysInstancedARB( int mode, int first, int count, int primcount );", "	( mode first count primcount -- )" );
	swigFunction( "c-function glDrawElementsInstancedARB glDrawElementsInstancedARB u n u a n -- void", "FUNCTION: glDrawElementsInstancedARB ( mode count type indices primcount -- void )", "EXTERN: \"C\" void glDrawElementsInstancedARB( int mode, int count, int type, void * indices, int primcount );", "	( mode count type indices primcount -- )" );
	swigFunction( "c-function glProgramStringARB glProgramStringARB u u n a -- void", "FUNCTION: glProgramStringARB ( target format len string -- void )", "EXTERN: \"C\" void glProgramStringARB( int target, int format, int len, void * string );", "	( target format len string -- )" );
	swigFunction( "c-function glBindProgramARB glBindProgramARB u u -- void", "FUNCTION: glBindProgramARB ( target program -- void )", "EXTERN: \"C\" void glBindProgramARB( int target, int program );", "	( target program -- )" );
	swigFunction( "c-function glDeleteProgramsARB glDeleteProgramsARB n a -- void", "FUNCTION: glDeleteProgramsARB ( n programs -- void )", "EXTERN: \"C\" void glDeleteProgramsARB( int n, void * programs );", "	( n programs -- )" );
	swigFunction( "c-function glGenProgramsARB glGenProgramsARB n a -- void", "FUNCTION: glGenProgramsARB ( n programs -- void )", "EXTERN: \"C\" void glGenProgramsARB( int n, void * programs );", "	( n programs -- )" );
	swigFunction( "c-function glProgramEnvParameter4dARB glProgramEnvParameter4dARB u u r r r r -- void", "FUNCTION: glProgramEnvParameter4dARB ( target index x y z w -- void )", "EXTERN: \"C\" void glProgramEnvParameter4dARB( int target, int index, double x, double y, double z, double w );", "	( target index x y z w -- )" );
	swigFunction( "c-function glProgramEnvParameter4dvARB glProgramEnvParameter4dvARB u u a -- void", "FUNCTION: glProgramEnvParameter4dvARB ( target index params -- void )", "EXTERN: \"C\" void glProgramEnvParameter4dvARB( int target, int index, void * params );", "	( target index params -- )" );
	swigFunction( "c-function glProgramEnvParameter4fARB glProgramEnvParameter4fARB u u r r r r -- void", "FUNCTION: glProgramEnvParameter4fARB ( target index x y z w -- void )", "EXTERN: \"C\" void glProgramEnvParameter4fARB( int target, int index, float x, float y, float z, float w );", "	( target index x y z w -- )" );
	swigFunction( "c-function glProgramEnvParameter4fvARB glProgramEnvParameter4fvARB u u a -- void", "FUNCTION: glProgramEnvParameter4fvARB ( target index params -- void )", "EXTERN: \"C\" void glProgramEnvParameter4fvARB( int target, int index, void * params );", "	( target index params -- )" );
	swigFunction( "c-function glProgramLocalParameter4dARB glProgramLocalParameter4dARB u u r r r r -- void", "FUNCTION: glProgramLocalParameter4dARB ( target index x y z w -- void )", "EXTERN: \"C\" void glProgramLocalParameter4dARB( int target, int index, double x, double y, double z, double w );", "	( target index x y z w -- )" );
	swigFunction( "c-function glProgramLocalParameter4dvARB glProgramLocalParameter4dvARB u u a -- void", "FUNCTION: glProgramLocalParameter4dvARB ( target index params -- void )", "EXTERN: \"C\" void glProgramLocalParameter4dvARB( int target, int index, void * params );", "	( target index params -- )" );
	swigFunction( "c-function glProgramLocalParameter4fARB glProgramLocalParameter4fARB u u r r r r -- void", "FUNCTION: glProgramLocalParameter4fARB ( target index x y z w -- void )", "EXTERN: \"C\" void glProgramLocalParameter4fARB( int target, int index, float x, float y, float z, float w );", "	( target index x y z w -- )" );
	swigFunction( "c-function glProgramLocalParameter4fvARB glProgramLocalParameter4fvARB u u a -- void", "FUNCTION: glProgramLocalParameter4fvARB ( target index params -- void )", "EXTERN: \"C\" void glProgramLocalParameter4fvARB( int target, int index, void * params );", "	( target index params -- )" );
	swigFunction( "c-function glGetProgramEnvParameterdvARB glGetProgramEnvParameterdvARB u u a -- void", "FUNCTION: glGetProgramEnvParameterdvARB ( target index params -- void )", "EXTERN: \"C\" void glGetProgramEnvParameterdvARB( int target, int index, void * params );", "	( target index params -- )" );
	swigFunction( "c-function glGetProgramEnvParameterfvARB glGetProgramEnvParameterfvARB u u a -- void", "FUNCTION: glGetProgramEnvParameterfvARB ( target index params -- void )", "EXTERN: \"C\" void glGetProgramEnvParameterfvARB( int target, int index, void * params );", "	( target index params -- )" );
	swigFunction( "c-function glGetProgramLocalParameterdvARB glGetProgramLocalParameterdvARB u u a -- void", "FUNCTION: glGetProgramLocalParameterdvARB ( target index params -- void )", "EXTERN: \"C\" void glGetProgramLocalParameterdvARB( int target, int index, void * params );", "	( target index params -- )" );
	swigFunction( "c-function glGetProgramLocalParameterfvARB glGetProgramLocalParameterfvARB u u a -- void", "FUNCTION: glGetProgramLocalParameterfvARB ( target index params -- void )", "EXTERN: \"C\" void glGetProgramLocalParameterfvARB( int target, int index, void * params );", "	( target index params -- )" );
	swigFunction( "c-function glGetProgramivARB glGetProgramivARB u u a -- void", "FUNCTION: glGetProgramivARB ( target pname params -- void )", "EXTERN: \"C\" void glGetProgramivARB( int target, int pname, void * params );", "	( target pname params -- )" );
	swigFunction( "c-function glGetProgramStringARB glGetProgramStringARB u u a -- void", "FUNCTION: glGetProgramStringARB ( target pname string -- void )", "EXTERN: \"C\" void glGetProgramStringARB( int target, int pname, void * string );", "	( target pname string -- )" );
	swigFunction( "c-function glIsProgramARB glIsProgramARB u -- u", "FUNCTION: glIsProgramARB ( program -- u )", "EXTERN: \"C\" char glIsProgramARB( int program );", "	( program -- )" );
	swigFunction( "c-function glProgramParameteriARB glProgramParameteriARB u u n -- void", "FUNCTION: glProgramParameteriARB ( program pname value -- void )", "EXTERN: \"C\" void glProgramParameteriARB( int program, int pname, int value );", "	( program pname value -- )" );
	swigFunction( "c-function glFramebufferTextureARB glFramebufferTextureARB u u u n -- void", "FUNCTION: glFramebufferTextureARB ( target attachment texture level -- void )", "EXTERN: \"C\" void glFramebufferTextureARB( int target, int attachment, int texture, int level );", "	( target attachment texture level -- )" );
	swigFunction( "c-function glFramebufferTextureLayerARB glFramebufferTextureLayerARB u u u n n -- void", "FUNCTION: glFramebufferTextureLayerARB ( target attachment texture level layer -- void )", "EXTERN: \"C\" void glFramebufferTextureLayerARB( int target, int attachment, int texture, int level, int layer );", "	( target attachment texture level layer -- )" );
	swigFunction( "c-function glFramebufferTextureFaceARB glFramebufferTextureFaceARB u u u n u -- void", "FUNCTION: glFramebufferTextureFaceARB ( target attachment texture level face -- void )", "EXTERN: \"C\" void glFramebufferTextureFaceARB( int target, int attachment, int texture, int level, int face );", "	( target attachment texture level face -- )" );
	swigFunction( "c-function glSpecializeShaderARB glSpecializeShaderARB u s u a a -- void", "FUNCTION: glSpecializeShaderARB ( shader pEntryPoint numSpecializationConstants pConstantIndex pConstantValue -- void )", "EXTERN: \"C\" void glSpecializeShaderARB( int shader, char * pEntryPoint, int numSpecializationConstants, void * pConstantIndex, void * pConstantValue );", "	( shader pEntryPoint numSpecializationConstants pConstantIndex pConstantValue -- )" );
	swigFunction( "c-function glUniform1i64ARB glUniform1i64ARB n d -- void", "FUNCTION: glUniform1i64ARB ( location x -- void )", "EXTERN: \"C\" void glUniform1i64ARB( int location, long long x );", "	( location x -- )" );
	swigFunction( "c-function glUniform2i64ARB glUniform2i64ARB n d d -- void", "FUNCTION: glUniform2i64ARB ( location x y -- void )", "EXTERN: \"C\" void glUniform2i64ARB( int location, long long x, long long y );", "	( location x y -- )" );
	swigFunction( "c-function glUniform3i64ARB glUniform3i64ARB n d d d -- void", "FUNCTION: glUniform3i64ARB ( location x y z -- void )", "EXTERN: \"C\" void glUniform3i64ARB( int location, long long x, long long y, long long z );", "	( location x y z -- )" );
	swigFunction( "c-function glUniform4i64ARB glUniform4i64ARB n d d d d -- void", "FUNCTION: glUniform4i64ARB ( location x y z w -- void )", "EXTERN: \"C\" void glUniform4i64ARB( int location, long long x, long long y, long long z, long long w );", "	( location x y z w -- )" );
	swigFunction( "c-function glUniform1i64vARB glUniform1i64vARB n n a -- void", "FUNCTION: glUniform1i64vARB ( location count value -- void )", "EXTERN: \"C\" void glUniform1i64vARB( int location, int count, void * value );", "	( location count value -- )" );
	swigFunction( "c-function glUniform2i64vARB glUniform2i64vARB n n a -- void", "FUNCTION: glUniform2i64vARB ( location count value -- void )", "EXTERN: \"C\" void glUniform2i64vARB( int location, int count, void * value );", "	( location count value -- )" );
	swigFunction( "c-function glUniform3i64vARB glUniform3i64vARB n n a -- void", "FUNCTION: glUniform3i64vARB ( location count value -- void )", "EXTERN: \"C\" void glUniform3i64vARB( int location, int count, void * value );", "	( location count value -- )" );
	swigFunction( "c-function glUniform4i64vARB glUniform4i64vARB n n a -- void", "FUNCTION: glUniform4i64vARB ( location count value -- void )", "EXTERN: \"C\" void glUniform4i64vARB( int location, int count, void * value );", "	( location count value -- )" );
	swigFunction( "c-function glUniform1ui64ARB glUniform1ui64ARB n d -- void", "FUNCTION: glUniform1ui64ARB ( location x -- void )", "EXTERN: \"C\" void glUniform1ui64ARB( int location, long long x );", "	( location x -- )" );
	swigFunction( "c-function glUniform2ui64ARB glUniform2ui64ARB n d d -- void", "FUNCTION: glUniform2ui64ARB ( location x y -- void )", "EXTERN: \"C\" void glUniform2ui64ARB( int location, long long x, long long y );", "	( location x y -- )" );
	swigFunction( "c-function glUniform3ui64ARB glUniform3ui64ARB n d d d -- void", "FUNCTION: glUniform3ui64ARB ( location x y z -- void )", "EXTERN: \"C\" void glUniform3ui64ARB( int location, long long x, long long y, long long z );", "	( location x y z -- )" );
	swigFunction( "c-function glUniform4ui64ARB glUniform4ui64ARB n d d d d -- void", "FUNCTION: glUniform4ui64ARB ( location x y z w -- void )", "EXTERN: \"C\" void glUniform4ui64ARB( int location, long long x, long long y, long long z, long long w );", "	( location x y z w -- )" );
	swigFunction( "c-function glUniform1ui64vARB glUniform1ui64vARB n n a -- void", "FUNCTION: glUniform1ui64vARB ( location count value -- void )", "EXTERN: \"C\" void glUniform1ui64vARB( int location, int count, void * value );", "	( location count value -- )" );
	swigFunction( "c-function glUniform2ui64vARB glUniform2ui64vARB n n a -- void", "FUNCTION: glUniform2ui64vARB ( location count value -- void )", "EXTERN: \"C\" void glUniform2ui64vARB( int location, int count, void * value );", "	( location count value -- )" );
	swigFunction( "c-function glUniform3ui64vARB glUniform3ui64vARB n n a -- void", "FUNCTION: glUniform3ui64vARB ( location count value -- void )", "EXTERN: \"C\" void glUniform3ui64vARB( int location, int count, void * value );", "	( location count value -- )" );
	swigFunction( "c-function glUniform4ui64vARB glUniform4ui64vARB n n a -- void", "FUNCTION: glUniform4ui64vARB ( location count value -- void )", "EXTERN: \"C\" void glUniform4ui64vARB( int location, int count, void * value );", "	( location count value -- )" );
	swigFunction( "c-function glGetUniformi64vARB glGetUniformi64vARB u n a -- void", "FUNCTION: glGetUniformi64vARB ( program location params -- void )", "EXTERN: \"C\" void glGetUniformi64vARB( int program, int location, void * params );", "	( program location params -- )" );
	swigFunction( "c-function glGetUniformui64vARB glGetUniformui64vARB u n a -- void", "FUNCTION: glGetUniformui64vARB ( program location params -- void )", "EXTERN: \"C\" void glGetUniformui64vARB( int program, int location, void * params );", "	( program location params -- )" );
	swigFunction( "c-function glGetnUniformi64vARB glGetnUniformi64vARB u n n a -- void", "FUNCTION: glGetnUniformi64vARB ( program location bufSize params -- void )", "EXTERN: \"C\" void glGetnUniformi64vARB( int program, int location, int bufSize, void * params );", "	( program location bufSize params -- )" );
	swigFunction( "c-function glGetnUniformui64vARB glGetnUniformui64vARB u n n a -- void", "FUNCTION: glGetnUniformui64vARB ( program location bufSize params -- void )", "EXTERN: \"C\" void glGetnUniformui64vARB( int program, int location, int bufSize, void * params );", "	( program location bufSize params -- )" );
	swigFunction( "c-function glProgramUniform1i64ARB glProgramUniform1i64ARB u n d -- void", "FUNCTION: glProgramUniform1i64ARB ( program location x -- void )", "EXTERN: \"C\" void glProgramUniform1i64ARB( int program, int location, long long x );", "	( program location x -- )" );
	swigFunction( "c-function glProgramUniform2i64ARB glProgramUniform2i64ARB u n d d -- void", "FUNCTION: glProgramUniform2i64ARB ( program location x y -- void )", "EXTERN: \"C\" void glProgramUniform2i64ARB( int program, int location, long long x, long long y );", "	( program location x y -- )" );
	swigFunction( "c-function glProgramUniform3i64ARB glProgramUniform3i64ARB u n d d d -- void", "FUNCTION: glProgramUniform3i64ARB ( program location x y z -- void )", "EXTERN: \"C\" void glProgramUniform3i64ARB( int program, int location, long long x, long long y, long long z );", "	( program location x y z -- )" );
	swigFunction( "c-function glProgramUniform4i64ARB glProgramUniform4i64ARB u n d d d d -- void", "FUNCTION: glProgramUniform4i64ARB ( program location x y z w -- void )", "EXTERN: \"C\" void glProgramUniform4i64ARB( int program, int location, long long x, long long y, long long z, long long w );", "	( program location x y z w -- )" );
	swigFunction( "c-function glProgramUniform1i64vARB glProgramUniform1i64vARB u n n a -- void", "FUNCTION: glProgramUniform1i64vARB ( program location count value -- void )", "EXTERN: \"C\" void glProgramUniform1i64vARB( int program, int location, int count, void * value );", "	( program location count value -- )" );
	swigFunction( "c-function glProgramUniform2i64vARB glProgramUniform2i64vARB u n n a -- void", "FUNCTION: glProgramUniform2i64vARB ( program location count value -- void )", "EXTERN: \"C\" void glProgramUniform2i64vARB( int program, int location, int count, void * value );", "	( program location count value -- )" );
	swigFunction( "c-function glProgramUniform3i64vARB glProgramUniform3i64vARB u n n a -- void", "FUNCTION: glProgramUniform3i64vARB ( program location count value -- void )", "EXTERN: \"C\" void glProgramUniform3i64vARB( int program, int location, int count, void * value );", "	( program location count value -- )" );
	swigFunction( "c-function glProgramUniform4i64vARB glProgramUniform4i64vARB u n n a -- void", "FUNCTION: glProgramUniform4i64vARB ( program location count value -- void )", "EXTERN: \"C\" void glProgramUniform4i64vARB( int program, int location, int count, void * value );", "	( program location count value -- )" );
	swigFunction( "c-function glProgramUniform1ui64ARB glProgramUniform1ui64ARB u n d -- void", "FUNCTION: glProgramUniform1ui64ARB ( program location x -- void )", "EXTERN: \"C\" void glProgramUniform1ui64ARB( int program, int location, long long x );", "	( program location x -- )" );
	swigFunction( "c-function glProgramUniform2ui64ARB glProgramUniform2ui64ARB u n d d -- void", "FUNCTION: glProgramUniform2ui64ARB ( program location x y -- void )", "EXTERN: \"C\" void glProgramUniform2ui64ARB( int program, int location, long long x, long long y );", "	( program location x y -- )" );
	swigFunction( "c-function glProgramUniform3ui64ARB glProgramUniform3ui64ARB u n d d d -- void", "FUNCTION: glProgramUniform3ui64ARB ( program location x y z -- void )", "EXTERN: \"C\" void glProgramUniform3ui64ARB( int program, int location, long long x, long long y, long long z );", "	( program location x y z -- )" );
	swigFunction( "c-function glProgramUniform4ui64ARB glProgramUniform4ui64ARB u n d d d d -- void", "FUNCTION: glProgramUniform4ui64ARB ( program location x y z w -- void )", "EXTERN: \"C\" void glProgramUniform4ui64ARB( int program, int location, long long x, long long y, long long z, long long w );", "	( program location x y z w -- )" );
	swigFunction( "c-function glProgramUniform1ui64vARB glProgramUniform1ui64vARB u n n a -- void", "FUNCTION: glProgramUniform1ui64vARB ( program location count value -- void )", "EXTERN: \"C\" void glProgramUniform1ui64vARB( int program, int location, int count, void * value );", "	( program location count value -- )" );
	swigFunction( "c-function glProgramUniform2ui64vARB glProgramUniform2ui64vARB u n n a -- void", "FUNCTION: glProgramUniform2ui64vARB ( program location count value -- void )", "EXTERN: \"C\" void glProgramUniform2ui64vARB( int program, int location, int count, void * value );", "	( program location count value -- )" );
	swigFunction( "c-function glProgramUniform3ui64vARB glProgramUniform3ui64vARB u n n a -- void", "FUNCTION: glProgramUniform3ui64vARB ( program location count value -- void )", "EXTERN: \"C\" void glProgramUniform3ui64vARB( int program, int location, int count, void * value );", "	( program location count value -- )" );
	swigFunction( "c-function glProgramUniform4ui64vARB glProgramUniform4ui64vARB u n n a -- void", "FUNCTION: glProgramUniform4ui64vARB ( program location count value -- void )", "EXTERN: \"C\" void glProgramUniform4ui64vARB( int program, int location, int count, void * value );", "	( program location count value -- )" );
	swigFunction( "c-function glMultiDrawArraysIndirectCountARB glMultiDrawArraysIndirectCountARB u a n n n -- void", "FUNCTION: glMultiDrawArraysIndirectCountARB ( mode indirect drawcount maxdrawcount stride -- void )", "EXTERN: \"C\" void glMultiDrawArraysIndirectCountARB( int mode, void * indirect, long drawcount, int maxdrawcount, int stride );", "	( mode indirect drawcount maxdrawcount stride -- )" );
	swigFunction( "c-function glMultiDrawElementsIndirectCountARB glMultiDrawElementsIndirectCountARB u u a n n n -- void", "FUNCTION: glMultiDrawElementsIndirectCountARB ( mode type indirect drawcount maxdrawcount stride -- void )", "EXTERN: \"C\" void glMultiDrawElementsIndirectCountARB( int mode, int type, void * indirect, long drawcount, int maxdrawcount, int stride );", "	( mode type indirect drawcount maxdrawcount stride -- )" );
	swigFunction( "c-function glVertexAttribDivisorARB glVertexAttribDivisorARB u u -- void", "FUNCTION: glVertexAttribDivisorARB ( index divisor -- void )", "EXTERN: \"C\" void glVertexAttribDivisorARB( int index, int divisor );", "	( index divisor -- )" );
	swigFunction( "c-function glCurrentPaletteMatrixARB glCurrentPaletteMatrixARB n -- void", "FUNCTION: glCurrentPaletteMatrixARB ( index -- void )", "EXTERN: \"C\" void glCurrentPaletteMatrixARB( int index );", "	( index -- )" );
	swigFunction( "c-function glMatrixIndexubvARB glMatrixIndexubvARB n a -- void", "FUNCTION: glMatrixIndexubvARB ( size indices -- void )", "EXTERN: \"C\" void glMatrixIndexubvARB( int size, void * indices );", "	( size indices -- )" );
	swigFunction( "c-function glMatrixIndexusvARB glMatrixIndexusvARB n a -- void", "FUNCTION: glMatrixIndexusvARB ( size indices -- void )", "EXTERN: \"C\" void glMatrixIndexusvARB( int size, void * indices );", "	( size indices -- )" );
	swigFunction( "c-function glMatrixIndexuivARB glMatrixIndexuivARB n a -- void", "FUNCTION: glMatrixIndexuivARB ( size indices -- void )", "EXTERN: \"C\" void glMatrixIndexuivARB( int size, void * indices );", "	( size indices -- )" );
	swigFunction( "c-function glMatrixIndexPointerARB glMatrixIndexPointerARB n u n a -- void", "FUNCTION: glMatrixIndexPointerARB ( size type stride pointer -- void )", "EXTERN: \"C\" void glMatrixIndexPointerARB( int size, int type, int stride, void * pointer );", "	( size type stride pointer -- )" );
	swigFunction( "c-function glSampleCoverageARB glSampleCoverageARB r u -- void", "FUNCTION: glSampleCoverageARB ( value invert -- void )", "EXTERN: \"C\" void glSampleCoverageARB( float value, char invert );", "	( value invert -- )" );
	swigFunction( "c-function glGenQueriesARB glGenQueriesARB n a -- void", "FUNCTION: glGenQueriesARB ( n ids -- void )", "EXTERN: \"C\" void glGenQueriesARB( int n, void * ids );", "	( n ids -- )" );
	swigFunction( "c-function glDeleteQueriesARB glDeleteQueriesARB n a -- void", "FUNCTION: glDeleteQueriesARB ( n ids -- void )", "EXTERN: \"C\" void glDeleteQueriesARB( int n, void * ids );", "	( n ids -- )" );
	swigFunction( "c-function glIsQueryARB glIsQueryARB u -- u", "FUNCTION: glIsQueryARB ( id -- u )", "EXTERN: \"C\" char glIsQueryARB( int id );", "	( id -- )" );
	swigFunction( "c-function glBeginQueryARB glBeginQueryARB u u -- void", "FUNCTION: glBeginQueryARB ( target id -- void )", "EXTERN: \"C\" void glBeginQueryARB( int target, int id );", "	( target id -- )" );
	swigFunction( "c-function glEndQueryARB glEndQueryARB u -- void", "FUNCTION: glEndQueryARB ( target -- void )", "EXTERN: \"C\" void glEndQueryARB( int target );", "	( target -- )" );
	swigFunction( "c-function glGetQueryivARB glGetQueryivARB u u a -- void", "FUNCTION: glGetQueryivARB ( target pname params -- void )", "EXTERN: \"C\" void glGetQueryivARB( int target, int pname, void * params );", "	( target pname params -- )" );
	swigFunction( "c-function glGetQueryObjectivARB glGetQueryObjectivARB u u a -- void", "FUNCTION: glGetQueryObjectivARB ( id pname params -- void )", "EXTERN: \"C\" void glGetQueryObjectivARB( int id, int pname, void * params );", "	( id pname params -- )" );
	swigFunction( "c-function glGetQueryObjectuivARB glGetQueryObjectuivARB u u a -- void", "FUNCTION: glGetQueryObjectuivARB ( id pname params -- void )", "EXTERN: \"C\" void glGetQueryObjectuivARB( int id, int pname, void * params );", "	( id pname params -- )" );
	swigFunction( "c-function glMaxShaderCompilerThreadsARB glMaxShaderCompilerThreadsARB u -- void", "FUNCTION: glMaxShaderCompilerThreadsARB ( count -- void )", "EXTERN: \"C\" void glMaxShaderCompilerThreadsARB( int count );", "	( count -- )" );
	swigFunction( "c-function glPointParameterfARB glPointParameterfARB u r -- void", "FUNCTION: glPointParameterfARB ( pname param -- void )", "EXTERN: \"C\" void glPointParameterfARB( int pname, float param );", "	( pname param -- )" );
	swigFunction( "c-function glPointParameterfvARB glPointParameterfvARB u a -- void", "FUNCTION: glPointParameterfvARB ( pname params -- void )", "EXTERN: \"C\" void glPointParameterfvARB( int pname, void * params );", "	( pname params -- )" );
	swigFunction( "c-function glGetGraphicsResetStatusARB glGetGraphicsResetStatusARB  -- u", "FUNCTION: glGetGraphicsResetStatusARB (  -- u )", "EXTERN: \"C\" int glGetGraphicsResetStatusARB(  );", "	( -- )" );
	swigFunction( "c-function glGetnTexImageARB glGetnTexImageARB u n u u n a -- void", "FUNCTION: glGetnTexImageARB ( target level format type bufSize img -- void )", "EXTERN: \"C\" void glGetnTexImageARB( int target, int level, int format, int type, int bufSize, void * img );", "	( target level format type bufSize img -- )" );
	swigFunction( "c-function glReadnPixelsARB glReadnPixelsARB n n n n u u n a -- void", "FUNCTION: glReadnPixelsARB ( x y width height format type bufSize data -- void )", "EXTERN: \"C\" void glReadnPixelsARB( int x, int y, int width, int height, int format, int type, int bufSize, void * data );", "	( x y width height format type bufSize data -- )" );
	swigFunction( "c-function glGetnCompressedTexImageARB glGetnCompressedTexImageARB u n n a -- void", "FUNCTION: glGetnCompressedTexImageARB ( target lod bufSize img -- void )", "EXTERN: \"C\" void glGetnCompressedTexImageARB( int target, int lod, int bufSize, void * img );", "	( target lod bufSize img -- )" );
	swigFunction( "c-function glGetnUniformfvARB glGetnUniformfvARB u n n a -- void", "FUNCTION: glGetnUniformfvARB ( program location bufSize params -- void )", "EXTERN: \"C\" void glGetnUniformfvARB( int program, int location, int bufSize, void * params );", "	( program location bufSize params -- )" );
	swigFunction( "c-function glGetnUniformivARB glGetnUniformivARB u n n a -- void", "FUNCTION: glGetnUniformivARB ( program location bufSize params -- void )", "EXTERN: \"C\" void glGetnUniformivARB( int program, int location, int bufSize, void * params );", "	( program location bufSize params -- )" );
	swigFunction( "c-function glGetnUniformuivARB glGetnUniformuivARB u n n a -- void", "FUNCTION: glGetnUniformuivARB ( program location bufSize params -- void )", "EXTERN: \"C\" void glGetnUniformuivARB( int program, int location, int bufSize, void * params );", "	( program location bufSize params -- )" );
	swigFunction( "c-function glGetnUniformdvARB glGetnUniformdvARB u n n a -- void", "FUNCTION: glGetnUniformdvARB ( program location bufSize params -- void )", "EXTERN: \"C\" void glGetnUniformdvARB( int program, int location, int bufSize, void * params );", "	( program location bufSize params -- )" );
	swigFunction( "c-function glGetnMapdvARB glGetnMapdvARB u u n a -- void", "FUNCTION: glGetnMapdvARB ( target query bufSize v -- void )", "EXTERN: \"C\" void glGetnMapdvARB( int target, int query, int bufSize, void * v );", "	( target query bufSize v -- )" );
	swigFunction( "c-function glGetnMapfvARB glGetnMapfvARB u u n a -- void", "FUNCTION: glGetnMapfvARB ( target query bufSize v -- void )", "EXTERN: \"C\" void glGetnMapfvARB( int target, int query, int bufSize, void * v );", "	( target query bufSize v -- )" );
	swigFunction( "c-function glGetnMapivARB glGetnMapivARB u u n a -- void", "FUNCTION: glGetnMapivARB ( target query bufSize v -- void )", "EXTERN: \"C\" void glGetnMapivARB( int target, int query, int bufSize, void * v );", "	( target query bufSize v -- )" );
	swigFunction( "c-function glGetnPixelMapfvARB glGetnPixelMapfvARB u n a -- void", "FUNCTION: glGetnPixelMapfvARB ( map bufSize values -- void )", "EXTERN: \"C\" void glGetnPixelMapfvARB( int map, int bufSize, void * values );", "	( map bufSize values -- )" );
	swigFunction( "c-function glGetnPixelMapuivARB glGetnPixelMapuivARB u n a -- void", "FUNCTION: glGetnPixelMapuivARB ( map bufSize values -- void )", "EXTERN: \"C\" void glGetnPixelMapuivARB( int map, int bufSize, void * values );", "	( map bufSize values -- )" );
	swigFunction( "c-function glGetnPixelMapusvARB glGetnPixelMapusvARB u n a -- void", "FUNCTION: glGetnPixelMapusvARB ( map bufSize values -- void )", "EXTERN: \"C\" void glGetnPixelMapusvARB( int map, int bufSize, void * values );", "	( map bufSize values -- )" );
	swigFunction( "c-function glGetnPolygonStippleARB glGetnPolygonStippleARB n a -- void", "FUNCTION: glGetnPolygonStippleARB ( bufSize pattern -- void )", "EXTERN: \"C\" void glGetnPolygonStippleARB( int bufSize, void * pattern );", "	( bufSize pattern -- )" );
	swigFunction( "c-function glGetnColorTableARB glGetnColorTableARB u u u n a -- void", "FUNCTION: glGetnColorTableARB ( target format type bufSize table -- void )", "EXTERN: \"C\" void glGetnColorTableARB( int target, int format, int type, int bufSize, void * table );", "	( target format type bufSize table -- )" );
	swigFunction( "c-function glGetnConvolutionFilterARB glGetnConvolutionFilterARB u u u n a -- void", "FUNCTION: glGetnConvolutionFilterARB ( target format type bufSize image -- void )", "EXTERN: \"C\" void glGetnConvolutionFilterARB( int target, int format, int type, int bufSize, void * image );", "	( target format type bufSize image -- )" );
	swigFunction( "c-function glGetnSeparableFilterARB glGetnSeparableFilterARB u u u n a n a a -- void", "FUNCTION: glGetnSeparableFilterARB ( target format type rowBufSize row columnBufSize column span -- void )", "EXTERN: \"C\" void glGetnSeparableFilterARB( int target, int format, int type, int rowBufSize, void * row, int columnBufSize, void * column, void * span );", "	( target format type rowBufSize row columnBufSize column span -- )" );
	swigFunction( "c-function glGetnHistogramARB glGetnHistogramARB u u u u n a -- void", "FUNCTION: glGetnHistogramARB ( target reset format type bufSize values -- void )", "EXTERN: \"C\" void glGetnHistogramARB( int target, char reset, int format, int type, int bufSize, void * values );", "	( target reset format type bufSize values -- )" );
	swigFunction( "c-function glGetnMinmaxARB glGetnMinmaxARB u u u u n a -- void", "FUNCTION: glGetnMinmaxARB ( target reset format type bufSize values -- void )", "EXTERN: \"C\" void glGetnMinmaxARB( int target, char reset, int format, int type, int bufSize, void * values );", "	( target reset format type bufSize values -- )" );
	swigFunction( "c-function glFramebufferSampleLocationsfvARB glFramebufferSampleLocationsfvARB u u n a -- void", "FUNCTION: glFramebufferSampleLocationsfvARB ( target start count v -- void )", "EXTERN: \"C\" void glFramebufferSampleLocationsfvARB( int target, int start, int count, void * v );", "	( target start count v -- )" );
	swigFunction( "c-function glNamedFramebufferSampleLocationsfvARB glNamedFramebufferSampleLocationsfvARB u u n a -- void", "FUNCTION: glNamedFramebufferSampleLocationsfvARB ( framebuffer start count v -- void )", "EXTERN: \"C\" void glNamedFramebufferSampleLocationsfvARB( int framebuffer, int start, int count, void * v );", "	( framebuffer start count v -- )" );
	swigFunction( "c-function glEvaluateDepthValuesARB glEvaluateDepthValuesARB  -- void", "FUNCTION: glEvaluateDepthValuesARB (  -- void )", "EXTERN: \"C\" void glEvaluateDepthValuesARB(  );", "	( -- )" );
	swigFunction( "c-function glMinSampleShadingARB glMinSampleShadingARB r -- void", "FUNCTION: glMinSampleShadingARB ( value -- void )", "EXTERN: \"C\" void glMinSampleShadingARB( float value );", "	( value -- )" );
	swigFunction( "c-function glDeleteObjectARB glDeleteObjectARB a -- void", "FUNCTION: glDeleteObjectARB ( obj -- void )", "EXTERN: \"C\" void glDeleteObjectARB( void * obj );", "	( obj -- )" );
	swigFunction( "c-function glGetHandleARB glGetHandleARB u -- a", "FUNCTION: glGetHandleARB ( pname -- a )", "EXTERN: \"C\" void * glGetHandleARB( int pname );", "	( pname -- )" );
	swigFunction( "c-function glDetachObjectARB glDetachObjectARB a a -- void", "FUNCTION: glDetachObjectARB ( containerObj attachedObj -- void )", "EXTERN: \"C\" void glDetachObjectARB( void * containerObj, void * attachedObj );", "	( containerObj attachedObj -- )" );
	swigFunction( "c-function glCreateShaderObjectARB glCreateShaderObjectARB u -- a", "FUNCTION: glCreateShaderObjectARB ( shaderType -- a )", "EXTERN: \"C\" void * glCreateShaderObjectARB( int shaderType );", "	( shaderType -- )" );
	swigFunction( "c-function glShaderSourceARB glShaderSourceARB a n a a -- void", "FUNCTION: glShaderSourceARB ( shaderObj count string length -- void )", "EXTERN: \"C\" void glShaderSourceARB( void * shaderObj, int count, void * string, void * length );", "	( shaderObj count string length -- )" );
	swigFunction( "c-function glCompileShaderARB glCompileShaderARB a -- void", "FUNCTION: glCompileShaderARB ( shaderObj -- void )", "EXTERN: \"C\" void glCompileShaderARB( void * shaderObj );", "	( shaderObj -- )" );
	swigFunction( "c-function glCreateProgramObjectARB glCreateProgramObjectARB  -- a", "FUNCTION: glCreateProgramObjectARB (  -- a )", "EXTERN: \"C\" void * glCreateProgramObjectARB(  );", "	( -- )" );
	swigFunction( "c-function glAttachObjectARB glAttachObjectARB a a -- void", "FUNCTION: glAttachObjectARB ( containerObj obj -- void )", "EXTERN: \"C\" void glAttachObjectARB( void * containerObj, void * obj );", "	( containerObj obj -- )" );
	swigFunction( "c-function glLinkProgramARB glLinkProgramARB a -- void", "FUNCTION: glLinkProgramARB ( programObj -- void )", "EXTERN: \"C\" void glLinkProgramARB( void * programObj );", "	( programObj -- )" );
	swigFunction( "c-function glUseProgramObjectARB glUseProgramObjectARB a -- void", "FUNCTION: glUseProgramObjectARB ( programObj -- void )", "EXTERN: \"C\" void glUseProgramObjectARB( void * programObj );", "	( programObj -- )" );
	swigFunction( "c-function glValidateProgramARB glValidateProgramARB a -- void", "FUNCTION: glValidateProgramARB ( programObj -- void )", "EXTERN: \"C\" void glValidateProgramARB( void * programObj );", "	( programObj -- )" );
	swigFunction( "c-function glUniform1fARB glUniform1fARB n r -- void", "FUNCTION: glUniform1fARB ( location v0 -- void )", "EXTERN: \"C\" void glUniform1fARB( int location, float v0 );", "	( location v0 -- )" );
	swigFunction( "c-function glUniform2fARB glUniform2fARB n r r -- void", "FUNCTION: glUniform2fARB ( location v0 v1 -- void )", "EXTERN: \"C\" void glUniform2fARB( int location, float v0, float v1 );", "	( location v0 v1 -- )" );
	swigFunction( "c-function glUniform3fARB glUniform3fARB n r r r -- void", "FUNCTION: glUniform3fARB ( location v0 v1 v2 -- void )", "EXTERN: \"C\" void glUniform3fARB( int location, float v0, float v1, float v2 );", "	( location v0 v1 v2 -- )" );
	swigFunction( "c-function glUniform4fARB glUniform4fARB n r r r r -- void", "FUNCTION: glUniform4fARB ( location v0 v1 v2 v3 -- void )", "EXTERN: \"C\" void glUniform4fARB( int location, float v0, float v1, float v2, float v3 );", "	( location v0 v1 v2 v3 -- )" );
	swigFunction( "c-function glUniform1iARB glUniform1iARB n n -- void", "FUNCTION: glUniform1iARB ( location v0 -- void )", "EXTERN: \"C\" void glUniform1iARB( int location, int v0 );", "	( location v0 -- )" );
	swigFunction( "c-function glUniform2iARB glUniform2iARB n n n -- void", "FUNCTION: glUniform2iARB ( location v0 v1 -- void )", "EXTERN: \"C\" void glUniform2iARB( int location, int v0, int v1 );", "	( location v0 v1 -- )" );
	swigFunction( "c-function glUniform3iARB glUniform3iARB n n n n -- void", "FUNCTION: glUniform3iARB ( location v0 v1 v2 -- void )", "EXTERN: \"C\" void glUniform3iARB( int location, int v0, int v1, int v2 );", "	( location v0 v1 v2 -- )" );
	swigFunction( "c-function glUniform4iARB glUniform4iARB n n n n n -- void", "FUNCTION: glUniform4iARB ( location v0 v1 v2 v3 -- void )", "EXTERN: \"C\" void glUniform4iARB( int location, int v0, int v1, int v2, int v3 );", "	( location v0 v1 v2 v3 -- )" );
	swigFunction( "c-function glUniform1fvARB glUniform1fvARB n n a -- void", "FUNCTION: glUniform1fvARB ( location count value -- void )", "EXTERN: \"C\" void glUniform1fvARB( int location, int count, void * value );", "	( location count value -- )" );
	swigFunction( "c-function glUniform2fvARB glUniform2fvARB n n a -- void", "FUNCTION: glUniform2fvARB ( location count value -- void )", "EXTERN: \"C\" void glUniform2fvARB( int location, int count, void * value );", "	( location count value -- )" );
	swigFunction( "c-function glUniform3fvARB glUniform3fvARB n n a -- void", "FUNCTION: glUniform3fvARB ( location count value -- void )", "EXTERN: \"C\" void glUniform3fvARB( int location, int count, void * value );", "	( location count value -- )" );
	swigFunction( "c-function glUniform4fvARB glUniform4fvARB n n a -- void", "FUNCTION: glUniform4fvARB ( location count value -- void )", "EXTERN: \"C\" void glUniform4fvARB( int location, int count, void * value );", "	( location count value -- )" );
	swigFunction( "c-function glUniform1ivARB glUniform1ivARB n n a -- void", "FUNCTION: glUniform1ivARB ( location count value -- void )", "EXTERN: \"C\" void glUniform1ivARB( int location, int count, void * value );", "	( location count value -- )" );
	swigFunction( "c-function glUniform2ivARB glUniform2ivARB n n a -- void", "FUNCTION: glUniform2ivARB ( location count value -- void )", "EXTERN: \"C\" void glUniform2ivARB( int location, int count, void * value );", "	( location count value -- )" );
	swigFunction( "c-function glUniform3ivARB glUniform3ivARB n n a -- void", "FUNCTION: glUniform3ivARB ( location count value -- void )", "EXTERN: \"C\" void glUniform3ivARB( int location, int count, void * value );", "	( location count value -- )" );
	swigFunction( "c-function glUniform4ivARB glUniform4ivARB n n a -- void", "FUNCTION: glUniform4ivARB ( location count value -- void )", "EXTERN: \"C\" void glUniform4ivARB( int location, int count, void * value );", "	( location count value -- )" );
	swigFunction( "c-function glUniformMatrix2fvARB glUniformMatrix2fvARB n n u a -- void", "FUNCTION: glUniformMatrix2fvARB ( location count transpose value -- void )", "EXTERN: \"C\" void glUniformMatrix2fvARB( int location, int count, char transpose, void * value );", "	( location count transpose value -- )" );
	swigFunction( "c-function glUniformMatrix3fvARB glUniformMatrix3fvARB n n u a -- void", "FUNCTION: glUniformMatrix3fvARB ( location count transpose value -- void )", "EXTERN: \"C\" void glUniformMatrix3fvARB( int location, int count, char transpose, void * value );", "	( location count transpose value -- )" );
	swigFunction( "c-function glUniformMatrix4fvARB glUniformMatrix4fvARB n n u a -- void", "FUNCTION: glUniformMatrix4fvARB ( location count transpose value -- void )", "EXTERN: \"C\" void glUniformMatrix4fvARB( int location, int count, char transpose, void * value );", "	( location count transpose value -- )" );
	swigFunction( "c-function glGetObjectParameterfvARB glGetObjectParameterfvARB a u a -- void", "FUNCTION: glGetObjectParameterfvARB ( obj pname params -- void )", "EXTERN: \"C\" void glGetObjectParameterfvARB( void * obj, int pname, void * params );", "	( obj pname params -- )" );
	swigFunction( "c-function glGetObjectParameterivARB glGetObjectParameterivARB a u a -- void", "FUNCTION: glGetObjectParameterivARB ( obj pname params -- void )", "EXTERN: \"C\" void glGetObjectParameterivARB( void * obj, int pname, void * params );", "	( obj pname params -- )" );
	swigFunction( "c-function glGetInfoLogARB glGetInfoLogARB a n a a -- void", "FUNCTION: glGetInfoLogARB ( obj maxLength length infoLog -- void )", "EXTERN: \"C\" void glGetInfoLogARB( void * obj, int maxLength, void * length, void * infoLog );", "	( obj maxLength length infoLog -- )" );
	swigFunction( "c-function glGetAttachedObjectsARB glGetAttachedObjectsARB a n a a -- void", "FUNCTION: glGetAttachedObjectsARB ( containerObj maxCount count obj -- void )", "EXTERN: \"C\" void glGetAttachedObjectsARB( void * containerObj, int maxCount, void * count, void * obj );", "	( containerObj maxCount count obj -- )" );
	swigFunction( "c-function glGetUniformLocationARB glGetUniformLocationARB a s -- n", "FUNCTION: glGetUniformLocationARB ( programObj name -- n )", "EXTERN: \"C\" int glGetUniformLocationARB( void * programObj, char * name );", "	( programObj name -- )" );
	swigFunction( "c-function glGetActiveUniformARB glGetActiveUniformARB a u n a a a a -- void", "FUNCTION: glGetActiveUniformARB ( programObj index maxLength length size type name -- void )", "EXTERN: \"C\" void glGetActiveUniformARB( void * programObj, int index, int maxLength, void * length, void * size, void * type, void * name );", "	( programObj index maxLength length size type name -- )" );
	swigFunction( "c-function glGetUniformfvARB glGetUniformfvARB a n a -- void", "FUNCTION: glGetUniformfvARB ( programObj location params -- void )", "EXTERN: \"C\" void glGetUniformfvARB( void * programObj, int location, void * params );", "	( programObj location params -- )" );
	swigFunction( "c-function glGetUniformivARB glGetUniformivARB a n a -- void", "FUNCTION: glGetUniformivARB ( programObj location params -- void )", "EXTERN: \"C\" void glGetUniformivARB( void * programObj, int location, void * params );", "	( programObj location params -- )" );
	swigFunction( "c-function glGetShaderSourceARB glGetShaderSourceARB a n a a -- void", "FUNCTION: glGetShaderSourceARB ( obj maxLength length source -- void )", "EXTERN: \"C\" void glGetShaderSourceARB( void * obj, int maxLength, void * length, void * source );", "	( obj maxLength length source -- )" );
	swigFunction( "c-function glNamedStringARB glNamedStringARB u n s n s -- void", "FUNCTION: glNamedStringARB ( type namelen name stringlen string -- void )", "EXTERN: \"C\" void glNamedStringARB( int type, int namelen, char * name, int stringlen, char * string );", "	( type namelen name stringlen string -- )" );
	swigFunction( "c-function glDeleteNamedStringARB glDeleteNamedStringARB n s -- void", "FUNCTION: glDeleteNamedStringARB ( namelen name -- void )", "EXTERN: \"C\" void glDeleteNamedStringARB( int namelen, char * name );", "	( namelen name -- )" );
	swigFunction( "c-function glCompileShaderIncludeARB glCompileShaderIncludeARB u n a a -- void", "FUNCTION: glCompileShaderIncludeARB ( shader count path length -- void )", "EXTERN: \"C\" void glCompileShaderIncludeARB( int shader, int count, void * path, void * length );", "	( shader count path length -- )" );
	swigFunction( "c-function glIsNamedStringARB glIsNamedStringARB n s -- u", "FUNCTION: glIsNamedStringARB ( namelen name -- u )", "EXTERN: \"C\" char glIsNamedStringARB( int namelen, char * name );", "	( namelen name -- )" );
	swigFunction( "c-function glGetNamedStringARB glGetNamedStringARB n s n a a -- void", "FUNCTION: glGetNamedStringARB ( namelen name bufSize stringlen string -- void )", "EXTERN: \"C\" void glGetNamedStringARB( int namelen, char * name, int bufSize, void * stringlen, void * string );", "	( namelen name bufSize stringlen string -- )" );
	swigFunction( "c-function glGetNamedStringivARB glGetNamedStringivARB n s u a -- void", "FUNCTION: glGetNamedStringivARB ( namelen name pname params -- void )", "EXTERN: \"C\" void glGetNamedStringivARB( int namelen, char * name, int pname, void * params );", "	( namelen name pname params -- )" );
	swigFunction( "c-function glBufferPageCommitmentARB glBufferPageCommitmentARB u n n u -- void", "FUNCTION: glBufferPageCommitmentARB ( target offset size commit -- void )", "EXTERN: \"C\" void glBufferPageCommitmentARB( int target, long offset, long size, char commit );", "	( target offset size commit -- )" );
	swigFunction( "c-function glNamedBufferPageCommitmentEXT glNamedBufferPageCommitmentEXT u n n u -- void", "FUNCTION: glNamedBufferPageCommitmentEXT ( buffer offset size commit -- void )", "EXTERN: \"C\" void glNamedBufferPageCommitmentEXT( int buffer, long offset, long size, char commit );", "	( buffer offset size commit -- )" );
	swigFunction( "c-function glNamedBufferPageCommitmentARB glNamedBufferPageCommitmentARB u n n u -- void", "FUNCTION: glNamedBufferPageCommitmentARB ( buffer offset size commit -- void )", "EXTERN: \"C\" void glNamedBufferPageCommitmentARB( int buffer, long offset, long size, char commit );", "	( buffer offset size commit -- )" );
	swigFunction( "c-function glTexPageCommitmentARB glTexPageCommitmentARB u n n n n n n n u -- void", "FUNCTION: glTexPageCommitmentARB ( target level xoffset yoffset zoffset width height depth commit -- void )", "EXTERN: \"C\" void glTexPageCommitmentARB( int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, char commit );", "	( target level xoffset yoffset zoffset width height depth commit -- )" );
	swigFunction( "c-function glTexBufferARB glTexBufferARB u u u -- void", "FUNCTION: glTexBufferARB ( target internalformat buffer -- void )", "EXTERN: \"C\" void glTexBufferARB( int target, int internalformat, int buffer );", "	( target internalformat buffer -- )" );
	swigFunction( "c-function glCompressedTexImage3DARB glCompressedTexImage3DARB u n u n n n n n a -- void", "FUNCTION: glCompressedTexImage3DARB ( target level internalformat width height depth border imageSize data -- void )", "EXTERN: \"C\" void glCompressedTexImage3DARB( int target, int level, int internalformat, int width, int height, int depth, int border, int imageSize, void * data );", "	( target level internalformat width height dept