/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 3.0.9
 *
 * This file is not intended to be easily readable and contains a number of
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG
 * interface file instead.
 * ----------------------------------------------------------------------------- */
#include <stdio.h>
#include <string.h>
#include <stddef.h>
#include <math.h> /* required for special case floating point output */

// Do not edit below this line
// end-of-default-includes


#include <xkbcommon/xkbcommon.h>
#include <xkbcommon/xkbcommon-keysyms.h>

typedef enum{ NONE = -1, GFORTH = 0, SWIFTFORTH, VFX } SwigTargetSystem;
SwigTargetSystem swigTargetSystem = NONE;

unsigned char swigPrintStackComments = 1;

/* comments */
void swigNewline()
{
	printf( "\n" );
}

void swigComment( char *comment )
{
	printf( "\\ %s", comment );
}

/* generic print */
void swigPrint( char* gforth, char *swiftForth, char *vfx )
{
	if( swigTargetSystem == GFORTH )
		printf( "%s", gforth );
	else if( swigTargetSystem == SWIFTFORTH )
		printf( "%s", swiftForth );
	else if( swigTargetSystem == VFX )
		printf( "%s", vfx );
	printf( "\n" );
}
void swigPrintSystem( SwigTargetSystem targetSystem, char *text )
{
	if( targetSystem == swigTargetSystem )
	    printf( "%s\n", text );
}

/* constants */
void swigIntConstant( long constant, char *name )
{
	printf( "#%ld\tconstant %s\n", constant, name );
}

void swigUnsignedIntConstant( unsigned long constant, char *name )
{
	printf( "#%lu\tconstant %s\n", constant, name );
}

void swigLongConstant( long long constant, char *name )
{
	printf( "#%lld.\t2constant %s\n", constant, name );
}

void swigUnsignedLongConstant( unsigned long long constant, char *name )
{
	printf( "#%llu.\t2constant %s\n", constant, name );
}

void swigFloatConstant( double constant, char *name )
{
	char buffer[128];
	sprintf( buffer, "%f", constant );

	/* if the constant contains no exponent, add one */
	char *s;
	for( s = buffer; *s != 0; s++ )
		if( *s == 'e' || *s == 'E' )
			break;

	/* exponent found */
	if( *s != 0 )
		printf( "%s\tfconstant %s\n", buffer, name );
	/* no exponent */
	else {
		/* special class? */
		int class = fpclassify( constant );
		if( class == FP_INFINITE )
			printf( "%sInf\tfconstant %s\n", constant < 0.0f ? "-" : "+", name );
		else if( class == FP_NAN )
			printf( "NaN\tfconstant %s\n", name );
		else
			/* treat as generic float */
			printf( "%se0\tfconstant %s\n", buffer, name );
        }
}

void swigStringConstant( char* constant, char *name )
{
	char c;
	printf( ": %s s\\\" ", name );
	while(( c = *constant++ ))
	{
		switch(c)
		{
			case '\b': printf( "\\b" ); break;
			case '\n': printf( "\\n" ); break;
			case '\f': printf( "\\f" ); break;
			case '\r': printf( "\\r" ); break;
			case '\t': printf( "\\t" ); break;
			case '"' : printf( "\\q" ); break;
			default:
				if(c < 0x20)
					printf("\\x%02x", c);
				else
					printf("%c", c); break;
		}
	}
	printf(	"\" ;\n" );
}

/* structs */
void swigStructField( char *name, size_t offset, size_t size )
{
	printf( "\tdrop %zu %zu +field %s\n", offset, size, name );
}

/* functions */
void swigFunction( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	if( swigTargetSystem == GFORTH )
		printf( "%s", gforth );
	else if( swigTargetSystem == SWIFTFORTH )
		printf( "%s", swiftForth );
	else if( swigTargetSystem == VFX )
		printf( "%s", vfx );

	if( swigPrintStackComments )
		printf( "%s", stackComment );

	printf( "\n" );
}

/* function pointers */
void swigFunctionPointer( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	swigFunction( gforth, swiftForth, vfx, stackComment );
}

/* callbacks */
void swigCallback( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	swigFunction( gforth, swiftForth, vfx, stackComment );
}

void swigUsage( char **argv )
{
	fprintf( stderr, "Usage: %s [-gforth|-swiftforth|-vfx]\n", argv[0] );
}

int main( int argc, char **argv )
{
	int i;

	/* check arguments */
	for( i = 1; i < argc; i++ )
		if( strcmp( argv[i], "-gforth" ) == 0 )
			swigTargetSystem = GFORTH;
		else if( strcmp( argv[i], "-swiftforth" ) == 0 )
			swigTargetSystem = SWIFTFORTH;
		else if( strcmp( argv[i], "-vfx" ) == 0 )
			swigTargetSystem = VFX;

	if( swigTargetSystem == NONE )
	{
		fprintf( stderr, "Error: no target system specified\n" );
		swigUsage( argv );
		return 1;
	}

	/* primer */
	printf( "\\ This file has been generated using SWIG and fsi,\n"
		"\\ and is already platform dependent, search for the corresponding\n"
		"\\ fsi-file to compile it where no one has compiled it before ;)\n"
		"\\ Forth systems have their own own dynamic loader and don't need addional C-Code.\n"
		"\\ That's why this file will just print normal forth-code once compiled\n"
		"\\ and can be used directly with include or require.\n"
		"\\ As all comments are stripped during the compilation, please\n"
		"\\ insert the copyright notice of the original file here.\n"
	);



	swigNewline();

	swigComment("----===< prefix >===-----\n");

	swigPrint( "c-library xkbcommon\ns\" xkbcommon\" add-lib\n\\c #include <xkbcommon/xkbcommon.h>\n\\c #include <xkbcommon/xkbcommon-keysyms.h>", "( none )", "( none )" );

	swigNewline();

	swigComment("----===< int constants >===-----\n");
	#ifdef XKB_KEYCODE_INVALID
		swigIntConstant( XKB_KEYCODE_INVALID, "XKB_KEYCODE_INVALID" );
	#endif
	#ifdef XKB_LAYOUT_INVALID
		swigIntConstant( XKB_LAYOUT_INVALID, "XKB_LAYOUT_INVALID" );
	#endif
	#ifdef XKB_LEVEL_INVALID
		swigIntConstant( XKB_LEVEL_INVALID, "XKB_LEVEL_INVALID" );
	#endif
	#ifdef XKB_MOD_INVALID
		swigIntConstant( XKB_MOD_INVALID, "XKB_MOD_INVALID" );
	#endif
	#ifdef XKB_LED_INVALID
		swigIntConstant( XKB_LED_INVALID, "XKB_LED_INVALID" );
	#endif
	#ifdef XKB_KEYCODE_MAX
		swigIntConstant( XKB_KEYCODE_MAX, "XKB_KEYCODE_MAX" );
	#endif
	#ifdef XKB_KEYSYM_MAX
		swigIntConstant( XKB_KEYSYM_MAX, "XKB_KEYSYM_MAX" );
	#endif
	#ifdef XKB_KEY_NoSymbol
		swigIntConstant( XKB_KEY_NoSymbol, "XKB_KEY_NoSymbol" );
	#endif
	#ifdef XKB_KEY_VoidSymbol
		swigIntConstant( XKB_KEY_VoidSymbol, "XKB_KEY_VoidSymbol" );
	#endif
	#ifdef XKB_KEY_BackSpace
		swigIntConstant( XKB_KEY_BackSpace, "XKB_KEY_BackSpace" );
	#endif
	#ifdef XKB_KEY_Tab
		swigIntConstant( XKB_KEY_Tab, "XKB_KEY_Tab" );
	#endif
	#ifdef XKB_KEY_Linefeed
		swigIntConstant( XKB_KEY_Linefeed, "XKB_KEY_Linefeed" );
	#endif
	#ifdef XKB_KEY_Clear
		swigIntConstant( XKB_KEY_Clear, "XKB_KEY_Clear" );
	#endif
	#ifdef XKB_KEY_Return
		swigIntConstant( XKB_KEY_Return, "XKB_KEY_Return" );
	#endif
	#ifdef XKB_KEY_Pause
		swigIntConstant( XKB_KEY_Pause, "XKB_KEY_Pause" );
	#endif
	#ifdef XKB_KEY_Scroll_Lock
		swigIntConstant( XKB_KEY_Scroll_Lock, "XKB_KEY_Scroll_Lock" );
	#endif
	#ifdef XKB_KEY_Sys_Req
		swigIntConstant( XKB_KEY_Sys_Req, "XKB_KEY_Sys_Req" );
	#endif
	#ifdef XKB_KEY_Escape
		swigIntConstant( XKB_KEY_Escape, "XKB_KEY_Escape" );
	#endif
	#ifdef XKB_KEY_Delete
		swigIntConstant( XKB_KEY_Delete, "XKB_KEY_Delete" );
	#endif
	#ifdef XKB_KEY_Multi_key
		swigIntConstant( XKB_KEY_Multi_key, "XKB_KEY_Multi_key" );
	#endif
	#ifdef XKB_KEY_Codeinput
		swigIntConstant( XKB_KEY_Codeinput, "XKB_KEY_Codeinput" );
	#endif
	#ifdef XKB_KEY_SingleCandidate
		swigIntConstant( XKB_KEY_SingleCandidate, "XKB_KEY_SingleCandidate" );
	#endif
	#ifdef XKB_KEY_MultipleCandidate
		swigIntConstant( XKB_KEY_MultipleCandidate, "XKB_KEY_MultipleCandidate" );
	#endif
	#ifdef XKB_KEY_PreviousCandidate
		swigIntConstant( XKB_KEY_PreviousCandidate, "XKB_KEY_PreviousCandidate" );
	#endif
	#ifdef XKB_KEY_Kanji
		swigIntConstant( XKB_KEY_Kanji, "XKB_KEY_Kanji" );
	#endif
	#ifdef XKB_KEY_Muhenkan
		swigIntConstant( XKB_KEY_Muhenkan, "XKB_KEY_Muhenkan" );
	#endif
	#ifdef XKB_KEY_Henkan_Mode
		swigIntConstant( XKB_KEY_Henkan_Mode, "XKB_KEY_Henkan_Mode" );
	#endif
	#ifdef XKB_KEY_Henkan
		swigIntConstant( XKB_KEY_Henkan, "XKB_KEY_Henkan" );
	#endif
	#ifdef XKB_KEY_Romaji
		swigIntConstant( XKB_KEY_Romaji, "XKB_KEY_Romaji" );
	#endif
	#ifdef XKB_KEY_Hiragana
		swigIntConstant( XKB_KEY_Hiragana, "XKB_KEY_Hiragana" );
	#endif
	#ifdef XKB_KEY_Katakana
		swigIntConstant( XKB_KEY_Katakana, "XKB_KEY_Katakana" );
	#endif
	#ifdef XKB_KEY_Hiragana_Katakana
		swigIntConstant( XKB_KEY_Hiragana_Katakana, "XKB_KEY_Hiragana_Katakana" );
	#endif
	#ifdef XKB_KEY_Zenkaku
		swigIntConstant( XKB_KEY_Zenkaku, "XKB_KEY_Zenkaku" );
	#endif
	#ifdef XKB_KEY_Hankaku
		swigIntConstant( XKB_KEY_Hankaku, "XKB_KEY_Hankaku" );
	#endif
	#ifdef XKB_KEY_Zenkaku_Hankaku
		swigIntConstant( XKB_KEY_Zenkaku_Hankaku, "XKB_KEY_Zenkaku_Hankaku" );
	#endif
	#ifdef XKB_KEY_Touroku
		swigIntConstant( XKB_KEY_Touroku, "XKB_KEY_Touroku" );
	#endif
	#ifdef XKB_KEY_Massyo
		swigIntConstant( XKB_KEY_Massyo, "XKB_KEY_Massyo" );
	#endif
	#ifdef XKB_KEY_Kana_Lock
		swigIntConstant( XKB_KEY_Kana_Lock, "XKB_KEY_Kana_Lock" );
	#endif
	#ifdef XKB_KEY_Kana_Shift
		swigIntConstant( XKB_KEY_Kana_Shift, "XKB_KEY_Kana_Shift" );
	#endif
	#ifdef XKB_KEY_Eisu_Shift
		swigIntConstant( XKB_KEY_Eisu_Shift, "XKB_KEY_Eisu_Shift" );
	#endif
	#ifdef XKB_KEY_Eisu_toggle
		swigIntConstant( XKB_KEY_Eisu_toggle, "XKB_KEY_Eisu_toggle" );
	#endif
	#ifdef XKB_KEY_Kanji_Bangou
		swigIntConstant( XKB_KEY_Kanji_Bangou, "XKB_KEY_Kanji_Bangou" );
	#endif
	#ifdef XKB_KEY_Zen_Koho
		swigIntConstant( XKB_KEY_Zen_Koho, "XKB_KEY_Zen_Koho" );
	#endif
	#ifdef XKB_KEY_Mae_Koho
		swigIntConstant( XKB_KEY_Mae_Koho, "XKB_KEY_Mae_Koho" );
	#endif
	#ifdef XKB_KEY_Home
		swigIntConstant( XKB_KEY_Home, "XKB_KEY_Home" );
	#endif
	#ifdef XKB_KEY_Left
		swigIntConstant( XKB_KEY_Left, "XKB_KEY_Left" );
	#endif
	#ifdef XKB_KEY_Up
		swigIntConstant( XKB_KEY_Up, "XKB_KEY_Up" );
	#endif
	#ifdef XKB_KEY_Right
		swigIntConstant( XKB_KEY_Right, "XKB_KEY_Right" );
	#endif
	#ifdef XKB_KEY_Down
		swigIntConstant( XKB_KEY_Down, "XKB_KEY_Down" );
	#endif
	#ifdef XKB_KEY_Prior
		swigIntConstant( XKB_KEY_Prior, "XKB_KEY_Prior" );
	#endif
	#ifdef XKB_KEY_Page_Up
		swigIntConstant( XKB_KEY_Page_Up, "XKB_KEY_Page_Up" );
	#endif
	#ifdef XKB_KEY_Next
		swigIntConstant( XKB_KEY_Next, "XKB_KEY_Next" );
	#endif
	#ifdef XKB_KEY_Page_Down
		swigIntConstant( XKB_KEY_Page_Down, "XKB_KEY_Page_Down" );
	#endif
	#ifdef XKB_KEY_End
		swigIntConstant( XKB_KEY_End, "XKB_KEY_End" );
	#endif
	#ifdef XKB_KEY_Begin
		swigIntConstant( XKB_KEY_Begin, "XKB_KEY_Begin" );
	#endif
	#ifdef XKB_KEY_Select
		swigIntConstant( XKB_KEY_Select, "XKB_KEY_Select" );
	#endif
	#ifdef XKB_KEY_Print
		swigIntConstant( XKB_KEY_Print, "XKB_KEY_Print" );
	#endif
	#ifdef XKB_KEY_Execute
		swigIntConstant( XKB_KEY_Execute, "XKB_KEY_Execute" );
	#endif
	#ifdef XKB_KEY_Insert
		swigIntConstant( XKB_KEY_Insert, "XKB_KEY_Insert" );
	#endif
	#ifdef XKB_KEY_Undo
		swigIntConstant( XKB_KEY_Undo, "XKB_KEY_Undo" );
	#endif
	#ifdef XKB_KEY_Redo
		swigIntConstant( XKB_KEY_Redo, "XKB_KEY_Redo" );
	#endif
	#ifdef XKB_KEY_Menu
		swigIntConstant( XKB_KEY_Menu, "XKB_KEY_Menu" );
	#endif
	#ifdef XKB_KEY_Find
		swigIntConstant( XKB_KEY_Find, "XKB_KEY_Find" );
	#endif
	#ifdef XKB_KEY_Cancel
		swigIntConstant( XKB_KEY_Cancel, "XKB_KEY_Cancel" );
	#endif
	#ifdef XKB_KEY_Help
		swigIntConstant( XKB_KEY_Help, "XKB_KEY_Help" );
	#endif
	#ifdef XKB_KEY_Break
		swigIntConstant( XKB_KEY_Break, "XKB_KEY_Break" );
	#endif
	#ifdef XKB_KEY_Mode_switch
		swigIntConstant( XKB_KEY_Mode_switch, "XKB_KEY_Mode_switch" );
	#endif
	#ifdef XKB_KEY_script_switch
		swigIntConstant( XKB_KEY_script_switch, "XKB_KEY_script_switch" );
	#endif
	#ifdef XKB_KEY_Num_Lock
		swigIntConstant( XKB_KEY_Num_Lock, "XKB_KEY_Num_Lock" );
	#endif
	#ifdef XKB_KEY_KP_Space
		swigIntConstant( XKB_KEY_KP_Space, "XKB_KEY_KP_Space" );
	#endif
	#ifdef XKB_KEY_KP_Tab
		swigIntConstant( XKB_KEY_KP_Tab, "XKB_KEY_KP_Tab" );
	#endif
	#ifdef XKB_KEY_KP_Enter
		swigIntConstant( XKB_KEY_KP_Enter, "XKB_KEY_KP_Enter" );
	#endif
	#ifdef XKB_KEY_KP_F1
		swigIntConstant( XKB_KEY_KP_F1, "XKB_KEY_KP_F1" );
	#endif
	#ifdef XKB_KEY_KP_F2
		swigIntConstant( XKB_KEY_KP_F2, "XKB_KEY_KP_F2" );
	#endif
	#ifdef XKB_KEY_KP_F3
		swigIntConstant( XKB_KEY_KP_F3, "XKB_KEY_KP_F3" );
	#endif
	#ifdef XKB_KEY_KP_F4
		swigIntConstant( XKB_KEY_KP_F4, "XKB_KEY_KP_F4" );
	#endif
	#ifdef XKB_KEY_KP_Home
		swigIntConstant( XKB_KEY_KP_Home, "XKB_KEY_KP_Home" );
	#endif
	#ifdef XKB_KEY_KP_Left
		swigIntConstant( XKB_KEY_KP_Left, "XKB_KEY_KP_Left" );
	#endif
	#ifdef XKB_KEY_KP_Up
		swigIntConstant( XKB_KEY_KP_Up, "XKB_KEY_KP_Up" );
	#endif
	#ifdef XKB_KEY_KP_Right
		swigIntConstant( XKB_KEY_KP_Right, "XKB_KEY_KP_Right" );
	#endif
	#ifdef XKB_KEY_KP_Down
		swigIntConstant( XKB_KEY_KP_Down, "XKB_KEY_KP_Down" );
	#endif
	#ifdef XKB_KEY_KP_Prior
		swigIntConstant( XKB_KEY_KP_Prior, "XKB_KEY_KP_Prior" );
	#endif
	#ifdef XKB_KEY_KP_Page_Up
		swigIntConstant( XKB_KEY_KP_Page_Up, "XKB_KEY_KP_Page_Up" );
	#endif
	#ifdef XKB_KEY_KP_Next
		swigIntConstant( XKB_KEY_KP_Next, "XKB_KEY_KP_Next" );
	#endif
	#ifdef XKB_KEY_KP_Page_Down
		swigIntConstant( XKB_KEY_KP_Page_Down, "XKB_KEY_KP_Page_Down" );
	#endif
	#ifdef XKB_KEY_KP_End
		swigIntConstant( XKB_KEY_KP_End, "XKB_KEY_KP_End" );
	#endif
	#ifdef XKB_KEY_KP_Begin
		swigIntConstant( XKB_KEY_KP_Begin, "XKB_KEY_KP_Begin" );
	#endif
	#ifdef XKB_KEY_KP_Insert
		swigIntConstant( XKB_KEY_KP_Insert, "XKB_KEY_KP_Insert" );
	#endif
	#ifdef XKB_KEY_KP_Delete
		swigIntConstant( XKB_KEY_KP_Delete, "XKB_KEY_KP_Delete" );
	#endif
	#ifdef XKB_KEY_KP_Equal
		swigIntConstant( XKB_KEY_KP_Equal, "XKB_KEY_KP_Equal" );
	#endif
	#ifdef XKB_KEY_KP_Multiply
		swigIntConstant( XKB_KEY_KP_Multiply, "XKB_KEY_KP_Multiply" );
	#endif
	#ifdef XKB_KEY_KP_Add
		swigIntConstant( XKB_KEY_KP_Add, "XKB_KEY_KP_Add" );
	#endif
	#ifdef XKB_KEY_KP_Separator
		swigIntConstant( XKB_KEY_KP_Separator, "XKB_KEY_KP_Separator" );
	#endif
	#ifdef XKB_KEY_KP_Subtract
		swigIntConstant( XKB_KEY_KP_Subtract, "XKB_KEY_KP_Subtract" );
	#endif
	#ifdef XKB_KEY_KP_Decimal
		swigIntConstant( XKB_KEY_KP_Decimal, "XKB_KEY_KP_Decimal" );
	#endif
	#ifdef XKB_KEY_KP_Divide
		swigIntConstant( XKB_KEY_KP_Divide, "XKB_KEY_KP_Divide" );
	#endif
	#ifdef XKB_KEY_KP_0
		swigIntConstant( XKB_KEY_KP_0, "XKB_KEY_KP_0" );
	#endif
	#ifdef XKB_KEY_KP_1
		swigIntConstant( XKB_KEY_KP_1, "XKB_KEY_KP_1" );
	#endif
	#ifdef XKB_KEY_KP_2
		swigIntConstant( XKB_KEY_KP_2, "XKB_KEY_KP_2" );
	#endif
	#ifdef XKB_KEY_KP_3
		swigIntConstant( XKB_KEY_KP_3, "XKB_KEY_KP_3" );
	#endif
	#ifdef XKB_KEY_KP_4
		swigIntConstant( XKB_KEY_KP_4, "XKB_KEY_KP_4" );
	#endif
	#ifdef XKB_KEY_KP_5
		swigIntConstant( XKB_KEY_KP_5, "XKB_KEY_KP_5" );
	#endif
	#ifdef XKB_KEY_KP_6
		swigIntConstant( XKB_KEY_KP_6, "XKB_KEY_KP_6" );
	#endif
	#ifdef XKB_KEY_KP_7
		swigIntConstant( XKB_KEY_KP_7, "XKB_KEY_KP_7" );
	#endif
	#ifdef XKB_KEY_KP_8
		swigIntConstant( XKB_KEY_KP_8, "XKB_KEY_KP_8" );
	#endif
	#ifdef XKB_KEY_KP_9
		swigIntConstant( XKB_KEY_KP_9, "XKB_KEY_KP_9" );
	#endif
	#ifdef XKB_KEY_F1
		swigIntConstant( XKB_KEY_F1, "XKB_KEY_F1" );
	#endif
	#ifdef XKB_KEY_F2
		swigIntConstant( XKB_KEY_F2, "XKB_KEY_F2" );
	#endif
	#ifdef XKB_KEY_F3
		swigIntConstant( XKB_KEY_F3, "XKB_KEY_F3" );
	#endif
	#ifdef XKB_KEY_F4
		swigIntConstant( XKB_KEY_F4, "XKB_KEY_F4" );
	#endif
	#ifdef XKB_KEY_F5
		swigIntConstant( XKB_KEY_F5, "XKB_KEY_F5" );
	#endif
	#ifdef XKB_KEY_F6
		swigIntConstant( XKB_KEY_F6, "XKB_KEY_F6" );
	#endif
	#ifdef XKB_KEY_F7
		swigIntConstant( XKB_KEY_F7, "XKB_KEY_F7" );
	#endif
	#ifdef XKB_KEY_F8
		swigIntConstant( XKB_KEY_F8, "XKB_KEY_F8" );
	#endif
	#ifdef XKB_KEY_F9
		swigIntConstant( XKB_KEY_F9, "XKB_KEY_F9" );
	#endif
	#ifdef XKB_KEY_F10
		swigIntConstant( XKB_KEY_F10, "XKB_KEY_F10" );
	#endif
	#ifdef XKB_KEY_F11
		swigIntConstant( XKB_KEY_F11, "XKB_KEY_F11" );
	#endif
	#ifdef XKB_KEY_L1
		swigIntConstant( XKB_KEY_L1, "XKB_KEY_L1" );
	#endif
	#ifdef XKB_KEY_F12
		swigIntConstant( XKB_KEY_F12, "XKB_KEY_F12" );
	#endif
	#ifdef XKB_KEY_L2
		swigIntConstant( XKB_KEY_L2, "XKB_KEY_L2" );
	#endif
	#ifdef XKB_KEY_F13
		swigIntConstant( XKB_KEY_F13, "XKB_KEY_F13" );
	#endif
	#ifdef XKB_KEY_L3
		swigIntConstant( XKB_KEY_L3, "XKB_KEY_L3" );
	#endif
	#ifdef XKB_KEY_F14
		swigIntConstant( XKB_KEY_F14, "XKB_KEY_F14" );
	#endif
	#ifdef XKB_KEY_L4
		swigIntConstant( XKB_KEY_L4, "XKB_KEY_L4" );
	#endif
	#ifdef XKB_KEY_F15
		swigIntConstant( XKB_KEY_F15, "XKB_KEY_F15" );
	#endif
	#ifdef XKB_KEY_L5
		swigIntConstant( XKB_KEY_L5, "XKB_KEY_L5" );
	#endif
	#ifdef XKB_KEY_F16
		swigIntConstant( XKB_KEY_F16, "XKB_KEY_F16" );
	#endif
	#ifdef XKB_KEY_L6
		swigIntConstant( XKB_KEY_L6, "XKB_KEY_L6" );
	#endif
	#ifdef XKB_KEY_F17
		swigIntConstant( XKB_KEY_F17, "XKB_KEY_F17" );
	#endif
	#ifdef XKB_KEY_L7
		swigIntConstant( XKB_KEY_L7, "XKB_KEY_L7" );
	#endif
	#ifdef XKB_KEY_F18
		swigIntConstant( XKB_KEY_F18, "XKB_KEY_F18" );
	#endif
	#ifdef XKB_KEY_L8
		swigIntConstant( XKB_KEY_L8, "XKB_KEY_L8" );
	#endif
	#ifdef XKB_KEY_F19
		swigIntConstant( XKB_KEY_F19, "XKB_KEY_F19" );
	#endif
	#ifdef XKB_KEY_L9
		swigIntConstant( XKB_KEY_L9, "XKB_KEY_L9" );
	#endif
	#ifdef XKB_KEY_F20
		swigIntConstant( XKB_KEY_F20, "XKB_KEY_F20" );
	#endif
	#ifdef XKB_KEY_L10
		swigIntConstant( XKB_KEY_L10, "XKB_KEY_L10" );
	#endif
	#ifdef XKB_KEY_F21
		swigIntConstant( XKB_KEY_F21, "XKB_KEY_F21" );
	#endif
	#ifdef XKB_KEY_R1
		swigIntConstant( XKB_KEY_R1, "XKB_KEY_R1" );
	#endif
	#ifdef XKB_KEY_F22
		swigIntConstant( XKB_KEY_F22, "XKB_KEY_F22" );
	#endif
	#ifdef XKB_KEY_R2
		swigIntConstant( XKB_KEY_R2, "XKB_KEY_R2" );
	#endif
	#ifdef XKB_KEY_F23
		swigIntConstant( XKB_KEY_F23, "XKB_KEY_F23" );
	#endif
	#ifdef XKB_KEY_R3
		swigIntConstant( XKB_KEY_R3, "XKB_KEY_R3" );
	#endif
	#ifdef XKB_KEY_F24
		swigIntConstant( XKB_KEY_F24, "XKB_KEY_F24" );
	#endif
	#ifdef XKB_KEY_R4
		swigIntConstant( XKB_KEY_R4, "XKB_KEY_R4" );
	#endif
	#ifdef XKB_KEY_F25
		swigIntConstant( XKB_KEY_F25, "XKB_KEY_F25" );
	#endif
	#ifdef XKB_KEY_R5
		swigIntConstant( XKB_KEY_R5, "XKB_KEY_R5" );
	#endif
	#ifdef XKB_KEY_F26
		swigIntConstant( XKB_KEY_F26, "XKB_KEY_F26" );
	#endif
	#ifdef XKB_KEY_R6
		swigIntConstant( XKB_KEY_R6, "XKB_KEY_R6" );
	#endif
	#ifdef XKB_KEY_F27
		swigIntConstant( XKB_KEY_F27, "XKB_KEY_F27" );
	#endif
	#ifdef XKB_KEY_R7
		swigIntConstant( XKB_KEY_R7, "XKB_KEY_R7" );
	#endif
	#ifdef XKB_KEY_F28
		swigIntConstant( XKB_KEY_F28, "XKB_KEY_F28" );
	#endif
	#ifdef XKB_KEY_R8
		swigIntConstant( XKB_KEY_R8, "XKB_KEY_R8" );
	#endif
	#ifdef XKB_KEY_F29
		swigIntConstant( XKB_KEY_F29, "XKB_KEY_F29" );
	#endif
	#ifdef XKB_KEY_R9
		swigIntConstant( XKB_KEY_R9, "XKB_KEY_R9" );
	#endif
	#ifdef XKB_KEY_F30
		swigIntConstant( XKB_KEY_F30, "XKB_KEY_F30" );
	#endif
	#ifdef XKB_KEY_R10
		swigIntConstant( XKB_KEY_R10, "XKB_KEY_R10" );
	#endif
	#ifdef XKB_KEY_F31
		swigIntConstant( XKB_KEY_F31, "XKB_KEY_F31" );
	#endif
	#ifdef XKB_KEY_R11
		swigIntConstant( XKB_KEY_R11, "XKB_KEY_R11" );
	#endif
	#ifdef XKB_KEY_F32
		swigIntConstant( XKB_KEY_F32, "XKB_KEY_F32" );
	#endif
	#ifdef XKB_KEY_R12
		swigIntConstant( XKB_KEY_R12, "XKB_KEY_R12" );
	#endif
	#ifdef XKB_KEY_F33
		swigIntConstant( XKB_KEY_F33, "XKB_KEY_F33" );
	#endif
	#ifdef XKB_KEY_R13
		swigIntConstant( XKB_KEY_R13, "XKB_KEY_R13" );
	#endif
	#ifdef XKB_KEY_F34
		swigIntConstant( XKB_KEY_F34, "XKB_KEY_F34" );
	#endif
	#ifdef XKB_KEY_R14
		swigIntConstant( XKB_KEY_R14, "XKB_KEY_R14" );
	#endif
	#ifdef XKB_KEY_F35
		swigIntConstant( XKB_KEY_F35, "XKB_KEY_F35" );
	#endif
	#ifdef XKB_KEY_R15
		swigIntConstant( XKB_KEY_R15, "XKB_KEY_R15" );
	#endif
	#ifdef XKB_KEY_Shift_L
		swigIntConstant( XKB_KEY_Shift_L, "XKB_KEY_Shift_L" );
	#endif
	#ifdef XKB_KEY_Shift_R
		swigIntConstant( XKB_KEY_Shift_R, "XKB_KEY_Shift_R" );
	#endif
	#ifdef XKB_KEY_Control_L
		swigIntConstant( XKB_KEY_Control_L, "XKB_KEY_Control_L" );
	#endif
	#ifdef XKB_KEY_Control_R
		swigIntConstant( XKB_KEY_Control_R, "XKB_KEY_Control_R" );
	#endif
	#ifdef XKB_KEY_Caps_Lock
		swigIntConstant( XKB_KEY_Caps_Lock, "XKB_KEY_Caps_Lock" );
	#endif
	#ifdef XKB_KEY_Shift_Lock
		swigIntConstant( XKB_KEY_Shift_Lock, "XKB_KEY_Shift_Lock" );
	#endif
	#ifdef XKB_KEY_Meta_L
		swigIntConstant( XKB_KEY_Meta_L, "XKB_KEY_Meta_L" );
	#endif
	#ifdef XKB_KEY_Meta_R
		swigIntConstant( XKB_KEY_Meta_R, "XKB_KEY_Meta_R" );
	#endif
	#ifdef XKB_KEY_Alt_L
		swigIntConstant( XKB_KEY_Alt_L, "XKB_KEY_Alt_L" );
	#endif
	#ifdef XKB_KEY_Alt_R
		swigIntConstant( XKB_KEY_Alt_R, "XKB_KEY_Alt_R" );
	#endif
	#ifdef XKB_KEY_Super_L
		swigIntConstant( XKB_KEY_Super_L, "XKB_KEY_Super_L" );
	#endif
	#ifdef XKB_KEY_Super_R
		swigIntConstant( XKB_KEY_Super_R, "XKB_KEY_Super_R" );
	#endif
	#ifdef XKB_KEY_Hyper_L
		swigIntConstant( XKB_KEY_Hyper_L, "XKB_KEY_Hyper_L" );
	#endif
	#ifdef XKB_KEY_Hyper_R
		swigIntConstant( XKB_KEY_Hyper_R, "XKB_KEY_Hyper_R" );
	#endif
	#ifdef XKB_KEY_ISO_Lock
		swigIntConstant( XKB_KEY_ISO_Lock, "XKB_KEY_ISO_Lock" );
	#endif
	#ifdef XKB_KEY_ISO_Level2_Latch
		swigIntConstant( XKB_KEY_ISO_Level2_Latch, "XKB_KEY_ISO_Level2_Latch" );
	#endif
	#ifdef XKB_KEY_ISO_Level3_Shift
		swigIntConstant( XKB_KEY_ISO_Level3_Shift, "XKB_KEY_ISO_Level3_Shift" );
	#endif
	#ifdef XKB_KEY_ISO_Level3_Latch
		swigIntConstant( XKB_KEY_ISO_Level3_Latch, "XKB_KEY_ISO_Level3_Latch" );
	#endif
	#ifdef XKB_KEY_ISO_Level3_Lock
		swigIntConstant( XKB_KEY_ISO_Level3_Lock, "XKB_KEY_ISO_Level3_Lock" );
	#endif
	#ifdef XKB_KEY_ISO_Level5_Shift
		swigIntConstant( XKB_KEY_ISO_Level5_Shift, "XKB_KEY_ISO_Level5_Shift" );
	#endif
	#ifdef XKB_KEY_ISO_Level5_Latch
		swigIntConstant( XKB_KEY_ISO_Level5_Latch, "XKB_KEY_ISO_Level5_Latch" );
	#endif
	#ifdef XKB_KEY_ISO_Level5_Lock
		swigIntConstant( XKB_KEY_ISO_Level5_Lock, "XKB_KEY_ISO_Level5_Lock" );
	#endif
	#ifdef XKB_KEY_ISO_Group_Shift
		swigIntConstant( XKB_KEY_ISO_Group_Shift, "XKB_KEY_ISO_Group_Shift" );
	#endif
	#ifdef XKB_KEY_ISO_Group_Latch
		swigIntConstant( XKB_KEY_ISO_Group_Latch, "XKB_KEY_ISO_Group_Latch" );
	#endif
	#ifdef XKB_KEY_ISO_Group_Lock
		swigIntConstant( XKB_KEY_ISO_Group_Lock, "XKB_KEY_ISO_Group_Lock" );
	#endif
	#ifdef XKB_KEY_ISO_Next_Group
		swigIntConstant( XKB_KEY_ISO_Next_Group, "XKB_KEY_ISO_Next_Group" );
	#endif
	#ifdef XKB_KEY_ISO_Next_Group_Lock
		swigIntConstant( XKB_KEY_ISO_Next_Group_Lock, "XKB_KEY_ISO_Next_Group_Lock" );
	#endif
	#ifdef XKB_KEY_ISO_Prev_Group
		swigIntConstant( XKB_KEY_ISO_Prev_Group, "XKB_KEY_ISO_Prev_Group" );
	#endif
	#ifdef XKB_KEY_ISO_Prev_Group_Lock
		swigIntConstant( XKB_KEY_ISO_Prev_Group_Lock, "XKB_KEY_ISO_Prev_Group_Lock" );
	#endif
	#ifdef XKB_KEY_ISO_First_Group
		swigIntConstant( XKB_KEY_ISO_First_Group, "XKB_KEY_ISO_First_Group" );
	#endif
	#ifdef XKB_KEY_ISO_First_Group_Lock
		swigIntConstant( XKB_KEY_ISO_First_Group_Lock, "XKB_KEY_ISO_First_Group_Lock" );
	#endif
	#ifdef XKB_KEY_ISO_Last_Group
		swigIntConstant( XKB_KEY_ISO_Last_Group, "XKB_KEY_ISO_Last_Group" );
	#endif
	#ifdef XKB_KEY_ISO_Last_Group_Lock
		swigIntConstant( XKB_KEY_ISO_Last_Group_Lock, "XKB_KEY_ISO_Last_Group_Lock" );
	#endif
	#ifdef XKB_KEY_ISO_Left_Tab
		swigIntConstant( XKB_KEY_ISO_Left_Tab, "XKB_KEY_ISO_Left_Tab" );
	#endif
	#ifdef XKB_KEY_ISO_Move_Line_Up
		swigIntConstant( XKB_KEY_ISO_Move_Line_Up, "XKB_KEY_ISO_Move_Line_Up" );
	#endif
	#ifdef XKB_KEY_ISO_Move_Line_Down
		swigIntConstant( XKB_KEY_ISO_Move_Line_Down, "XKB_KEY_ISO_Move_Line_Down" );
	#endif
	#ifdef XKB_KEY_ISO_Partial_Line_Up
		swigIntConstant( XKB_KEY_ISO_Partial_Line_Up, "XKB_KEY_ISO_Partial_Line_Up" );
	#endif
	#ifdef XKB_KEY_ISO_Partial_Line_Down
		swigIntConstant( XKB_KEY_ISO_Partial_Line_Down, "XKB_KEY_ISO_Partial_Line_Down" );
	#endif
	#ifdef XKB_KEY_ISO_Partial_Space_Left
		swigIntConstant( XKB_KEY_ISO_Partial_Space_Left, "XKB_KEY_ISO_Partial_Space_Left" );
	#endif
	#ifdef XKB_KEY_ISO_Partial_Space_Right
		swigIntConstant( XKB_KEY_ISO_Partial_Space_Right, "XKB_KEY_ISO_Partial_Space_Right" );
	#endif
	#ifdef XKB_KEY_ISO_Set_Margin_Left
		swigIntConstant( XKB_KEY_ISO_Set_Margin_Left, "XKB_KEY_ISO_Set_Margin_Left" );
	#endif
	#ifdef XKB_KEY_ISO_Set_Margin_Right
		swigIntConstant( XKB_KEY_ISO_Set_Margin_Right, "XKB_KEY_ISO_Set_Margin_Right" );
	#endif
	#ifdef XKB_KEY_ISO_Release_Margin_Left
		swigIntConstant( XKB_KEY_ISO_Release_Margin_Left, "XKB_KEY_ISO_Release_Margin_Left" );
	#endif
	#ifdef XKB_KEY_ISO_Release_Margin_Right
		swigIntConstant( XKB_KEY_ISO_Release_Margin_Right, "XKB_KEY_ISO_Release_Margin_Right" );
	#endif
	#ifdef XKB_KEY_ISO_Release_Both_Margins
		swigIntConstant( XKB_KEY_ISO_Release_Both_Margins, "XKB_KEY_ISO_Release_Both_Margins" );
	#endif
	#ifdef XKB_KEY_ISO_Fast_Cursor_Left
		swigIntConstant( XKB_KEY_ISO_Fast_Cursor_Left, "XKB_KEY_ISO_Fast_Cursor_Left" );
	#endif
	#ifdef XKB_KEY_ISO_Fast_Cursor_Right
		swigIntConstant( XKB_KEY_ISO_Fast_Cursor_Right, "XKB_KEY_ISO_Fast_Cursor_Right" );
	#endif
	#ifdef XKB_KEY_ISO_Fast_Cursor_Up
		swigIntConstant( XKB_KEY_ISO_Fast_Cursor_Up, "XKB_KEY_ISO_Fast_Cursor_Up" );
	#endif
	#ifdef XKB_KEY_ISO_Fast_Cursor_Down
		swigIntConstant( XKB_KEY_ISO_Fast_Cursor_Down, "XKB_KEY_ISO_Fast_Cursor_Down" );
	#endif
	#ifdef XKB_KEY_ISO_Continuous_Underline
		swigIntConstant( XKB_KEY_ISO_Continuous_Underline, "XKB_KEY_ISO_Continuous_Underline" );
	#endif
	#ifdef XKB_KEY_ISO_Discontinuous_Underline
		swigIntConstant( XKB_KEY_ISO_Discontinuous_Underline, "XKB_KEY_ISO_Discontinuous_Underline" );
	#endif
	#ifdef XKB_KEY_ISO_Emphasize
		swigIntConstant( XKB_KEY_ISO_Emphasize, "XKB_KEY_ISO_Emphasize" );
	#endif
	#ifdef XKB_KEY_ISO_Center_Object
		swigIntConstant( XKB_KEY_ISO_Center_Object, "XKB_KEY_ISO_Center_Object" );
	#endif
	#ifdef XKB_KEY_ISO_Enter
		swigIntConstant( XKB_KEY_ISO_Enter, "XKB_KEY_ISO_Enter" );
	#endif
	#ifdef XKB_KEY_dead_grave
		swigIntConstant( XKB_KEY_dead_grave, "XKB_KEY_dead_grave" );
	#endif
	#ifdef XKB_KEY_dead_acute
		swigIntConstant( XKB_KEY_dead_acute, "XKB_KEY_dead_acute" );
	#endif
	#ifdef XKB_KEY_dead_circumflex
		swigIntConstant( XKB_KEY_dead_circumflex, "XKB_KEY_dead_circumflex" );
	#endif
	#ifdef XKB_KEY_dead_tilde
		swigIntConstant( XKB_KEY_dead_tilde, "XKB_KEY_dead_tilde" );
	#endif
	#ifdef XKB_KEY_dead_perispomeni
		swigIntConstant( XKB_KEY_dead_perispomeni, "XKB_KEY_dead_perispomeni" );
	#endif
	#ifdef XKB_KEY_dead_macron
		swigIntConstant( XKB_KEY_dead_macron, "XKB_KEY_dead_macron" );
	#endif
	#ifdef XKB_KEY_dead_breve
		swigIntConstant( XKB_KEY_dead_breve, "XKB_KEY_dead_breve" );
	#endif
	#ifdef XKB_KEY_dead_abovedot
		swigIntConstant( XKB_KEY_dead_abovedot, "XKB_KEY_dead_abovedot" );
	#endif
	#ifdef XKB_KEY_dead_diaeresis
		swigIntConstant( XKB_KEY_dead_diaeresis, "XKB_KEY_dead_diaeresis" );
	#endif
	#ifdef XKB_KEY_dead_abovering
		swigIntConstant( XKB_KEY_dead_abovering, "XKB_KEY_dead_abovering" );
	#endif
	#ifdef XKB_KEY_dead_doubleacute
		swigIntConstant( XKB_KEY_dead_doubleacute, "XKB_KEY_dead_doubleacute" );
	#endif
	#ifdef XKB_KEY_dead_caron
		swigIntConstant( XKB_KEY_dead_caron, "XKB_KEY_dead_caron" );
	#endif
	#ifdef XKB_KEY_dead_cedilla
		swigIntConstant( XKB_KEY_dead_cedilla, "XKB_KEY_dead_cedilla" );
	#endif
	#ifdef XKB_KEY_dead_ogonek
		swigIntConstant( XKB_KEY_dead_ogonek, "XKB_KEY_dead_ogonek" );
	#endif
	#ifdef XKB_KEY_dead_iota
		swigIntConstant( XKB_KEY_dead_iota, "XKB_KEY_dead_iota" );
	#endif
	#ifdef XKB_KEY_dead_voiced_sound
		swigIntConstant( XKB_KEY_dead_voiced_sound, "XKB_KEY_dead_voiced_sound" );
	#endif
	#ifdef XKB_KEY_dead_semivoiced_sound
		swigIntConstant( XKB_KEY_dead_semivoiced_sound, "XKB_KEY_dead_semivoiced_sound" );
	#endif
	#ifdef XKB_KEY_dead_belowdot
		swigIntConstant( XKB_KEY_dead_belowdot, "XKB_KEY_dead_belowdot" );
	#endif
	#ifdef XKB_KEY_dead_hook
		swigIntConstant( XKB_KEY_dead_hook, "XKB_KEY_dead_hook" );
	#endif
	#ifdef XKB_KEY_dead_horn
		swigIntConstant( XKB_KEY_dead_horn, "XKB_KEY_dead_horn" );
	#endif
	#ifdef XKB_KEY_dead_stroke
		swigIntConstant( XKB_KEY_dead_stroke, "XKB_KEY_dead_stroke" );
	#endif
	#ifdef XKB_KEY_dead_abovecomma
		swigIntConstant( XKB_KEY_dead_abovecomma, "XKB_KEY_dead_abovecomma" );
	#endif
	#ifdef XKB_KEY_dead_psili
		swigIntConstant( XKB_KEY_dead_psili, "XKB_KEY_dead_psili" );
	#endif
	#ifdef XKB_KEY_dead_abovereversedcomma
		swigIntConstant( XKB_KEY_dead_abovereversedcomma, "XKB_KEY_dead_abovereversedcomma" );
	#endif
	#ifdef XKB_KEY_dead_dasia
		swigIntConstant( XKB_KEY_dead_dasia, "XKB_KEY_dead_dasia" );
	#endif
	#ifdef XKB_KEY_dead_doublegrave
		swigIntConstant( XKB_KEY_dead_doublegrave, "XKB_KEY_dead_doublegrave" );
	#endif
	#ifdef XKB_KEY_dead_belowring
		swigIntConstant( XKB_KEY_dead_belowring, "XKB_KEY_dead_belowring" );
	#endif
	#ifdef XKB_KEY_dead_belowmacron
		swigIntConstant( XKB_KEY_dead_belowmacron, "XKB_KEY_dead_belowmacron" );
	#endif
	#ifdef XKB_KEY_dead_belowcircumflex
		swigIntConstant( XKB_KEY_dead_belowcircumflex, "XKB_KEY_dead_belowcircumflex" );
	#endif
	#ifdef XKB_KEY_dead_belowtilde
		swigIntConstant( XKB_KEY_dead_belowtilde, "XKB_KEY_dead_belowtilde" );
	#endif
	#ifdef XKB_KEY_dead_belowbreve
		swigIntConstant( XKB_KEY_dead_belowbreve, "XKB_KEY_dead_belowbreve" );
	#endif
	#ifdef XKB_KEY_dead_belowdiaeresis
		swigIntConstant( XKB_KEY_dead_belowdiaeresis, "XKB_KEY_dead_belowdiaeresis" );
	#endif
	#ifdef XKB_KEY_dead_invertedbreve
		swigIntConstant( XKB_KEY_dead_invertedbreve, "XKB_KEY_dead_invertedbreve" );
	#endif
	#ifdef XKB_KEY_dead_belowcomma
		swigIntConstant( XKB_KEY_dead_belowcomma, "XKB_KEY_dead_belowcomma" );
	#endif
	#ifdef XKB_KEY_dead_currency
		swigIntConstant( XKB_KEY_dead_currency, "XKB_KEY_dead_currency" );
	#endif
	#ifdef XKB_KEY_dead_lowline
		swigIntConstant( XKB_KEY_dead_lowline, "XKB_KEY_dead_lowline" );
	#endif
	#ifdef XKB_KEY_dead_aboveverticalline
		swigIntConstant( XKB_KEY_dead_aboveverticalline, "XKB_KEY_dead_aboveverticalline" );
	#endif
	#ifdef XKB_KEY_dead_belowverticalline
		swigIntConstant( XKB_KEY_dead_belowverticalline, "XKB_KEY_dead_belowverticalline" );
	#endif
	#ifdef XKB_KEY_dead_longsolidusoverlay
		swigIntConstant( XKB_KEY_dead_longsolidusoverlay, "XKB_KEY_dead_longsolidusoverlay" );
	#endif
	#ifdef XKB_KEY_dead_a
		swigIntConstant( XKB_KEY_dead_a, "XKB_KEY_dead_a" );
	#endif
	#ifdef XKB_KEY_dead_A
		swigIntConstant( XKB_KEY_dead_A, "XKB_KEY_dead_A" );
	#endif
	#ifdef XKB_KEY_dead_e
		swigIntConstant( XKB_KEY_dead_e, "XKB_KEY_dead_e" );
	#endif
	#ifdef XKB_KEY_dead_E
		swigIntConstant( XKB_KEY_dead_E, "XKB_KEY_dead_E" );
	#endif
	#ifdef XKB_KEY_dead_i
		swigIntConstant( XKB_KEY_dead_i, "XKB_KEY_dead_i" );
	#endif
	#ifdef XKB_KEY_dead_I
		swigIntConstant( XKB_KEY_dead_I, "XKB_KEY_dead_I" );
	#endif
	#ifdef XKB_KEY_dead_o
		swigIntConstant( XKB_KEY_dead_o, "XKB_KEY_dead_o" );
	#endif
	#ifdef XKB_KEY_dead_O
		swigIntConstant( XKB_KEY_dead_O, "XKB_KEY_dead_O" );
	#endif
	#ifdef XKB_KEY_dead_u
		swigIntConstant( XKB_KEY_dead_u, "XKB_KEY_dead_u" );
	#endif
	#ifdef XKB_KEY_dead_U
		swigIntConstant( XKB_KEY_dead_U, "XKB_KEY_dead_U" );
	#endif
	#ifdef XKB_KEY_dead_small_schwa
		swigIntConstant( XKB_KEY_dead_small_schwa, "XKB_KEY_dead_small_schwa" );
	#endif
	#ifdef XKB_KEY_dead_schwa
		swigIntConstant( XKB_KEY_dead_schwa, "XKB_KEY_dead_schwa" );
	#endif
	#ifdef XKB_KEY_dead_capital_schwa
		swigIntConstant( XKB_KEY_dead_capital_schwa, "XKB_KEY_dead_capital_schwa" );
	#endif
	#ifdef XKB_KEY_dead_SCHWA
		swigIntConstant( XKB_KEY_dead_SCHWA, "XKB_KEY_dead_SCHWA" );
	#endif
	#ifdef XKB_KEY_dead_greek
		swigIntConstant( XKB_KEY_dead_greek, "XKB_KEY_dead_greek" );
	#endif
	#ifdef XKB_KEY_dead_hamza
		swigIntConstant( XKB_KEY_dead_hamza, "XKB_KEY_dead_hamza" );
	#endif
	#ifdef XKB_KEY_First_Virtual_Screen
		swigIntConstant( XKB_KEY_First_Virtual_Screen, "XKB_KEY_First_Virtual_Screen" );
	#endif
	#ifdef XKB_KEY_Prev_Virtual_Screen
		swigIntConstant( XKB_KEY_Prev_Virtual_Screen, "XKB_KEY_Prev_Virtual_Screen" );
	#endif
	#ifdef XKB_KEY_Next_Virtual_Screen
		swigIntConstant( XKB_KEY_Next_Virtual_Screen, "XKB_KEY_Next_Virtual_Screen" );
	#endif
	#ifdef XKB_KEY_Last_Virtual_Screen
		swigIntConstant( XKB_KEY_Last_Virtual_Screen, "XKB_KEY_Last_Virtual_Screen" );
	#endif
	#ifdef XKB_KEY_Terminate_Server
		swigIntConstant( XKB_KEY_Terminate_Server, "XKB_KEY_Terminate_Server" );
	#endif
	#ifdef XKB_KEY_AccessX_Enable
		swigIntConstant( XKB_KEY_AccessX_Enable, "XKB_KEY_AccessX_Enable" );
	#endif
	#ifdef XKB_KEY_AccessX_Feedback_Enable
		swigIntConstant( XKB_KEY_AccessX_Feedback_Enable, "XKB_KEY_AccessX_Feedback_Enable" );
	#endif
	#ifdef XKB_KEY_RepeatKeys_Enable
		swigIntConstant( XKB_KEY_RepeatKeys_Enable, "XKB_KEY_RepeatKeys_Enable" );
	#endif
	#ifdef XKB_KEY_SlowKeys_Enable
		swigIntConstant( XKB_KEY_SlowKeys_Enable, "XKB_KEY_SlowKeys_Enable" );
	#endif
	#ifdef XKB_KEY_BounceKeys_Enable
		swigIntConstant( XKB_KEY_BounceKeys_Enable, "XKB_KEY_BounceKeys_Enable" );
	#endif
	#ifdef XKB_KEY_StickyKeys_Enable
		swigIntConstant( XKB_KEY_StickyKeys_Enable, "XKB_KEY_StickyKeys_Enable" );
	#endif
	#ifdef XKB_KEY_MouseKeys_Enable
		swigIntConstant( XKB_KEY_MouseKeys_Enable, "XKB_KEY_MouseKeys_Enable" );
	#endif
	#ifdef XKB_KEY_MouseKeys_Accel_Enable
		swigIntConstant( XKB_KEY_MouseKeys_Accel_Enable, "XKB_KEY_MouseKeys_Accel_Enable" );
	#endif
	#ifdef XKB_KEY_Overlay1_Enable
		swigIntConstant( XKB_KEY_Overlay1_Enable, "XKB_KEY_Overlay1_Enable" );
	#endif
	#ifdef XKB_KEY_Overlay2_Enable
		swigIntConstant( XKB_KEY_Overlay2_Enable, "XKB_KEY_Overlay2_Enable" );
	#endif
	#ifdef XKB_KEY_AudibleBell_Enable
		swigIntConstant( XKB_KEY_AudibleBell_Enable, "XKB_KEY_AudibleBell_Enable" );
	#endif
	#ifdef XKB_KEY_Pointer_Left
		swigIntConstant( XKB_KEY_Pointer_Left, "XKB_KEY_Pointer_Left" );
	#endif
	#ifdef XKB_KEY_Pointer_Right
		swigIntConstant( XKB_KEY_Pointer_Right, "XKB_KEY_Pointer_Right" );
	#endif
	#ifdef XKB_KEY_Pointer_Up
		swigIntConstant( XKB_KEY_Pointer_Up, "XKB_KEY_Pointer_Up" );
	#endif
	#ifdef XKB_KEY_Pointer_Down
		swigIntConstant( XKB_KEY_Pointer_Down, "XKB_KEY_Pointer_Down" );
	#endif
	#ifdef XKB_KEY_Pointer_UpLeft
		swigIntConstant( XKB_KEY_Pointer_UpLeft, "XKB_KEY_Pointer_UpLeft" );
	#endif
	#ifdef XKB_KEY_Pointer_UpRight
		swigIntConstant( XKB_KEY_Pointer_UpRight, "XKB_KEY_Pointer_UpRight" );
	#endif
	#ifdef XKB_KEY_Pointer_DownLeft
		swigIntConstant( XKB_KEY_Pointer_DownLeft, "XKB_KEY_Pointer_DownLeft" );
	#endif
	#ifdef XKB_KEY_Pointer_DownRight
		swigIntConstant( XKB_KEY_Pointer_DownRight, "XKB_KEY_Pointer_DownRight" );
	#endif
	#ifdef XKB_KEY_Pointer_Button_Dflt
		swigIntConstant( XKB_KEY_Pointer_Button_Dflt, "XKB_KEY_Pointer_Button_Dflt" );
	#endif
	#ifdef XKB_KEY_Pointer_Button1
		swigIntConstant( XKB_KEY_Pointer_Button1, "XKB_KEY_Pointer_Button1" );
	#endif
	#ifdef XKB_KEY_Pointer_Button2
		swigIntConstant( XKB_KEY_Pointer_Button2, "XKB_KEY_Pointer_Button2" );
	#endif
	#ifdef XKB_KEY_Pointer_Button3
		swigIntConstant( XKB_KEY_Pointer_Button3, "XKB_KEY_Pointer_Button3" );
	#endif
	#ifdef XKB_KEY_Pointer_Button4
		swigIntConstant( XKB_KEY_Pointer_Button4, "XKB_KEY_Pointer_Button4" );
	#endif
	#ifdef XKB_KEY_Pointer_Button5
		swigIntConstant( XKB_KEY_Pointer_Button5, "XKB_KEY_Pointer_Button5" );
	#endif
	#ifdef XKB_KEY_Pointer_DblClick_Dflt
		swigIntConstant( XKB_KEY_Pointer_DblClick_Dflt, "XKB_KEY_Pointer_DblClick_Dflt" );
	#endif
	#ifdef XKB_KEY_Pointer_DblClick1
		swigIntConstant( XKB_KEY_Pointer_DblClick1, "XKB_KEY_Pointer_DblClick1" );
	#endif
	#ifdef XKB_KEY_Pointer_DblClick2
		swigIntConstant( XKB_KEY_Pointer_DblClick2, "XKB_KEY_Pointer_DblClick2" );
	#endif
	#ifdef XKB_KEY_Pointer_DblClick3
		swigIntConstant( XKB_KEY_Pointer_DblClick3, "XKB_KEY_Pointer_DblClick3" );
	#endif
	#ifdef XKB_KEY_Pointer_DblClick4
		swigIntConstant( XKB_KEY_Pointer_DblClick4, "XKB_KEY_Pointer_DblClick4" );
	#endif
	#ifdef XKB_KEY_Pointer_DblClick5
		swigIntConstant( XKB_KEY_Pointer_DblClick5, "XKB_KEY_Pointer_DblClick5" );
	#endif
	#ifdef XKB_KEY_Pointer_Drag_Dflt
		swigIntConstant( XKB_KEY_Pointer_Drag_Dflt, "XKB_KEY_Pointer_Drag_Dflt" );
	#endif
	#ifdef XKB_KEY_Pointer_Drag1
		swigIntConstant( XKB_KEY_Pointer_Drag1, "XKB_KEY_Pointer_Drag1" );
	#endif
	#ifdef XKB_KEY_Pointer_Drag2
		swigIntConstant( XKB_KEY_Pointer_Drag2, "XKB_KEY_Pointer_Drag2" );
	#endif
	#ifdef XKB_KEY_Pointer_Drag3
		swigIntConstant( XKB_KEY_Pointer_Drag3, "XKB_KEY_Pointer_Drag3" );
	#endif
	#ifdef XKB_KEY_Pointer_Drag4
		swigIntConstant( XKB_KEY_Pointer_Drag4, "XKB_KEY_Pointer_Drag4" );
	#endif
	#ifdef XKB_KEY_Pointer_Drag5
		swigIntConstant( XKB_KEY_Pointer_Drag5, "XKB_KEY_Pointer_Drag5" );
	#endif
	#ifdef XKB_KEY_Pointer_EnableKeys
		swigIntConstant( XKB_KEY_Pointer_EnableKeys, "XKB_KEY_Pointer_EnableKeys" );
	#endif
	#ifdef XKB_KEY_Pointer_Accelerate
		swigIntConstant( XKB_KEY_Pointer_Accelerate, "XKB_KEY_Pointer_Accelerate" );
	#endif
	#ifdef XKB_KEY_Pointer_DfltBtnNext
		swigIntConstant( XKB_KEY_Pointer_DfltBtnNext, "XKB_KEY_Pointer_DfltBtnNext" );
	#endif
	#ifdef XKB_KEY_Pointer_DfltBtnPrev
		swigIntConstant( XKB_KEY_Pointer_DfltBtnPrev, "XKB_KEY_Pointer_DfltBtnPrev" );
	#endif
	#ifdef XKB_KEY_ch
		swigIntConstant( XKB_KEY_ch, "XKB_KEY_ch" );
	#endif
	#ifdef XKB_KEY_Ch
		swigIntConstant( XKB_KEY_Ch, "XKB_KEY_Ch" );
	#endif
	#ifdef XKB_KEY_CH
		swigIntConstant( XKB_KEY_CH, "XKB_KEY_CH" );
	#endif
	#ifdef XKB_KEY_c_h
		swigIntConstant( XKB_KEY_c_h, "XKB_KEY_c_h" );
	#endif
	#ifdef XKB_KEY_C_h
		swigIntConstant( XKB_KEY_C_h, "XKB_KEY_C_h" );
	#endif
	#ifdef XKB_KEY_C_H
		swigIntConstant( XKB_KEY_C_H, "XKB_KEY_C_H" );
	#endif
	#ifdef XKB_KEY_3270_Duplicate
		swigIntConstant( XKB_KEY_3270_Duplicate, "XKB_KEY_3270_Duplicate" );
	#endif
	#ifdef XKB_KEY_3270_FieldMark
		swigIntConstant( XKB_KEY_3270_FieldMark, "XKB_KEY_3270_FieldMark" );
	#endif
	#ifdef XKB_KEY_3270_Right2
		swigIntConstant( XKB_KEY_3270_Right2, "XKB_KEY_3270_Right2" );
	#endif
	#ifdef XKB_KEY_3270_Left2
		swigIntConstant( XKB_KEY_3270_Left2, "XKB_KEY_3270_Left2" );
	#endif
	#ifdef XKB_KEY_3270_BackTab
		swigIntConstant( XKB_KEY_3270_BackTab, "XKB_KEY_3270_BackTab" );
	#endif
	#ifdef XKB_KEY_3270_EraseEOF
		swigIntConstant( XKB_KEY_3270_EraseEOF, "XKB_KEY_3270_EraseEOF" );
	#endif
	#ifdef XKB_KEY_3270_EraseInput
		swigIntConstant( XKB_KEY_3270_EraseInput, "XKB_KEY_3270_EraseInput" );
	#endif
	#ifdef XKB_KEY_3270_Reset
		swigIntConstant( XKB_KEY_3270_Reset, "XKB_KEY_3270_Reset" );
	#endif
	#ifdef XKB_KEY_3270_Quit
		swigIntConstant( XKB_KEY_3270_Quit, "XKB_KEY_3270_Quit" );
	#endif
	#ifdef XKB_KEY_3270_PA1
		swigIntConstant( XKB_KEY_3270_PA1, "XKB_KEY_3270_PA1" );
	#endif
	#ifdef XKB_KEY_3270_PA2
		swigIntConstant( XKB_KEY_3270_PA2, "XKB_KEY_3270_PA2" );
	#endif
	#ifdef XKB_KEY_3270_PA3
		swigIntConstant( XKB_KEY_3270_PA3, "XKB_KEY_3270_PA3" );
	#endif
	#ifdef XKB_KEY_3270_Test
		swigIntConstant( XKB_KEY_3270_Test, "XKB_KEY_3270_Test" );
	#endif
	#ifdef XKB_KEY_3270_Attn
		swigIntConstant( XKB_KEY_3270_Attn, "XKB_KEY_3270_Attn" );
	#endif
	#ifdef XKB_KEY_3270_CursorBlink
		swigIntConstant( XKB_KEY_3270_CursorBlink, "XKB_KEY_3270_CursorBlink" );
	#endif
	#ifdef XKB_KEY_3270_AltCursor
		swigIntConstant( XKB_KEY_3270_AltCursor, "XKB_KEY_3270_AltCursor" );
	#endif
	#ifdef XKB_KEY_3270_KeyClick
		swigIntConstant( XKB_KEY_3270_KeyClick, "XKB_KEY_3270_KeyClick" );
	#endif
	#ifdef XKB_KEY_3270_Jump
		swigIntConstant( XKB_KEY_3270_Jump, "XKB_KEY_3270_Jump" );
	#endif
	#ifdef XKB_KEY_3270_Ident
		swigIntConstant( XKB_KEY_3270_Ident, "XKB_KEY_3270_Ident" );
	#endif
	#ifdef XKB_KEY_3270_Rule
		swigIntConstant( XKB_KEY_3270_Rule, "XKB_KEY_3270_Rule" );
	#endif
	#ifdef XKB_KEY_3270_Copy
		swigIntConstant( XKB_KEY_3270_Copy, "XKB_KEY_3270_Copy" );
	#endif
	#ifdef XKB_KEY_3270_Play
		swigIntConstant( XKB_KEY_3270_Play, "XKB_KEY_3270_Play" );
	#endif
	#ifdef XKB_KEY_3270_Setup
		swigIntConstant( XKB_KEY_3270_Setup, "XKB_KEY_3270_Setup" );
	#endif
	#ifdef XKB_KEY_3270_Record
		swigIntConstant( XKB_KEY_3270_Record, "XKB_KEY_3270_Record" );
	#endif
	#ifdef XKB_KEY_3270_ChangeScreen
		swigIntConstant( XKB_KEY_3270_ChangeScreen, "XKB_KEY_3270_ChangeScreen" );
	#endif
	#ifdef XKB_KEY_3270_DeleteWord
		swigIntConstant( XKB_KEY_3270_DeleteWord, "XKB_KEY_3270_DeleteWord" );
	#endif
	#ifdef XKB_KEY_3270_ExSelect
		swigIntConstant( XKB_KEY_3270_ExSelect, "XKB_KEY_3270_ExSelect" );
	#endif
	#ifdef XKB_KEY_3270_CursorSelect
		swigIntConstant( XKB_KEY_3270_CursorSelect, "XKB_KEY_3270_CursorSelect" );
	#endif
	#ifdef XKB_KEY_3270_PrintScreen
		swigIntConstant( XKB_KEY_3270_PrintScreen, "XKB_KEY_3270_PrintScreen" );
	#endif
	#ifdef XKB_KEY_3270_Enter
		swigIntConstant( XKB_KEY_3270_Enter, "XKB_KEY_3270_Enter" );
	#endif
	#ifdef XKB_KEY_space
		swigIntConstant( XKB_KEY_space, "XKB_KEY_space" );
	#endif
	#ifdef XKB_KEY_exclam
		swigIntConstant( XKB_KEY_exclam, "XKB_KEY_exclam" );
	#endif
	#ifdef XKB_KEY_quotedbl
		swigIntConstant( XKB_KEY_quotedbl, "XKB_KEY_quotedbl" );
	#endif
	#ifdef XKB_KEY_numbersign
		swigIntConstant( XKB_KEY_numbersign, "XKB_KEY_numbersign" );
	#endif
	#ifdef XKB_KEY_dollar
		swigIntConstant( XKB_KEY_dollar, "XKB_KEY_dollar" );
	#endif
	#ifdef XKB_KEY_percent
		swigIntConstant( XKB_KEY_percent, "XKB_KEY_percent" );
	#endif
	#ifdef XKB_KEY_ampersand
		swigIntConstant( XKB_KEY_ampersand, "XKB_KEY_ampersand" );
	#endif
	#ifdef XKB_KEY_apostrophe
		swigIntConstant( XKB_KEY_apostrophe, "XKB_KEY_apostrophe" );
	#endif
	#ifdef XKB_KEY_quoteright
		swigIntConstant( XKB_KEY_quoteright, "XKB_KEY_quoteright" );
	#endif
	#ifdef XKB_KEY_parenleft
		swigIntConstant( XKB_KEY_parenleft, "XKB_KEY_parenleft" );
	#endif
	#ifdef XKB_KEY_parenright
		swigIntConstant( XKB_KEY_parenright, "XKB_KEY_parenright" );
	#endif
	#ifdef XKB_KEY_asterisk
		swigIntConstant( XKB_KEY_asterisk, "XKB_KEY_asterisk" );
	#endif
	#ifdef XKB_KEY_plus
		swigIntConstant( XKB_KEY_plus, "XKB_KEY_plus" );
	#endif
	#ifdef XKB_KEY_comma
		swigIntConstant( XKB_KEY_comma, "XKB_KEY_comma" );
	#endif
	#ifdef XKB_KEY_minus
		swigIntConstant( XKB_KEY_minus, "XKB_KEY_minus" );
	#endif
	#ifdef XKB_KEY_period
		swigIntConstant( XKB_KEY_period, "XKB_KEY_period" );
	#endif
	#ifdef XKB_KEY_slash
		swigIntConstant( XKB_KEY_slash, "XKB_KEY_slash" );
	#endif
	#ifdef XKB_KEY_0
		swigIntConstant( XKB_KEY_0, "XKB_KEY_0" );
	#endif
	#ifdef XKB_KEY_1
		swigIntConstant( XKB_KEY_1, "XKB_KEY_1" );
	#endif
	#ifdef XKB_KEY_2
		swigIntConstant( XKB_KEY_2, "XKB_KEY_2" );
	#endif
	#ifdef XKB_KEY_3
		swigIntConstant( XKB_KEY_3, "XKB_KEY_3" );
	#endif
	#ifdef XKB_KEY_4
		swigIntConstant( XKB_KEY_4, "XKB_KEY_4" );
	#endif
	#ifdef XKB_KEY_5
		swigIntConstant( XKB_KEY_5, "XKB_KEY_5" );
	#endif
	#ifdef XKB_KEY_6
		swigIntConstant( XKB_KEY_6, "XKB_KEY_6" );
	#endif
	#ifdef XKB_KEY_7
		swigIntConstant( XKB_KEY_7, "XKB_KEY_7" );
	#endif
	#ifdef XKB_KEY_8
		swigIntConstant( XKB_KEY_8, "XKB_KEY_8" );
	#endif
	#ifdef XKB_KEY_9
		swigIntConstant( XKB_KEY_9, "XKB_KEY_9" );
	#endif
	#ifdef XKB_KEY_colon
		swigIntConstant( XKB_KEY_colon, "XKB_KEY_colon" );
	#endif
	#ifdef XKB_KEY_semicolon
		swigIntConstant( XKB_KEY_semicolon, "XKB_KEY_semicolon" );
	#endif
	#ifdef XKB_KEY_less
		swigIntConstant( XKB_KEY_less, "XKB_KEY_less" );
	#endif
	#ifdef XKB_KEY_equal
		swigIntConstant( XKB_KEY_equal, "XKB_KEY_equal" );
	#endif
	#ifdef XKB_KEY_greater
		swigIntConstant( XKB_KEY_greater, "XKB_KEY_greater" );
	#endif
	#ifdef XKB_KEY_question
		swigIntConstant( XKB_KEY_question, "XKB_KEY_question" );
	#endif
	#ifdef XKB_KEY_at
		swigIntConstant( XKB_KEY_at, "XKB_KEY_at" );
	#endif
	#ifdef XKB_KEY_A
		swigIntConstant( XKB_KEY_A, "XKB_KEY_A" );
	#endif
	#ifdef XKB_KEY_B
		swigIntConstant( XKB_KEY_B, "XKB_KEY_B" );
	#endif
	#ifdef XKB_KEY_C
		swigIntConstant( XKB_KEY_C, "XKB_KEY_C" );
	#endif
	#ifdef XKB_KEY_D
		swigIntConstant( XKB_KEY_D, "XKB_KEY_D" );
	#endif
	#ifdef XKB_KEY_E
		swigIntConstant( XKB_KEY_E, "XKB_KEY_E" );
	#endif
	#ifdef XKB_KEY_F
		swigIntConstant( XKB_KEY_F, "XKB_KEY_F" );
	#endif
	#ifdef XKB_KEY_G
		swigIntConstant( XKB_KEY_G, "XKB_KEY_G" );
	#endif
	#ifdef XKB_KEY_H
		swigIntConstant( XKB_KEY_H, "XKB_KEY_H" );
	#endif
	#ifdef XKB_KEY_I
		swigIntConstant( XKB_KEY_I, "XKB_KEY_I" );
	#endif
	#ifdef XKB_KEY_J
		swigIntConstant( XKB_KEY_J, "XKB_KEY_J" );
	#endif
	#ifdef XKB_KEY_K
		swigIntConstant( XKB_KEY_K, "XKB_KEY_K" );
	#endif
	#ifdef XKB_KEY_L
		swigIntConstant( XKB_KEY_L, "XKB_KEY_L" );
	#endif
	#ifdef XKB_KEY_M
		swigIntConstant( XKB_KEY_M, "XKB_KEY_M" );
	#endif
	#ifdef XKB_KEY_N
		swigIntConstant( XKB_KEY_N, "XKB_KEY_N" );
	#endif
	#ifdef XKB_KEY_O
		swigIntConstant( XKB_KEY_O, "XKB_KEY_O" );
	#endif
	#ifdef XKB_KEY_P
		swigIntConstant( XKB_KEY_P, "XKB_KEY_P" );
	#endif
	#ifdef XKB_KEY_Q
		swigIntConstant( XKB_KEY_Q, "XKB_KEY_Q" );
	#endif
	#ifdef XKB_KEY_R
		swigIntConstant( XKB_KEY_R, "XKB_KEY_R" );
	#endif
	#ifdef XKB_KEY_S
		swigIntConstant( XKB_KEY_S, "XKB_KEY_S" );
	#endif
	#ifdef XKB_KEY_T
		swigIntConstant( XKB_KEY_T, "XKB_KEY_T" );
	#endif
	#ifdef XKB_KEY_U
		swigIntConstant( XKB_KEY_U, "XKB_KEY_U" );
	#endif
	#ifdef XKB_KEY_V
		swigIntConstant( XKB_KEY_V, "XKB_KEY_V" );
	#endif
	#ifdef XKB_KEY_W
		swigIntConstant( XKB_KEY_W, "XKB_KEY_W" );
	#endif
	#ifdef XKB_KEY_X
		swigIntConstant( XKB_KEY_X, "XKB_KEY_X" );
	#endif
	#ifdef XKB_KEY_Y
		swigIntConstant( XKB_KEY_Y, "XKB_KEY_Y" );
	#endif
	#ifdef XKB_KEY_Z
		swigIntConstant( XKB_KEY_Z, "XKB_KEY_Z" );
	#endif
	#ifdef XKB_KEY_bracketleft
		swigIntConstant( XKB_KEY_bracketleft, "XKB_KEY_bracketleft" );
	#endif
	#ifdef XKB_KEY_backslash
		swigIntConstant( XKB_KEY_backslash, "XKB_KEY_backslash" );
	#endif
	#ifdef XKB_KEY_bracketright
		swigIntConstant( XKB_KEY_bracketright, "XKB_KEY_bracketright" );
	#endif
	#ifdef XKB_KEY_asciicircum
		swigIntConstant( XKB_KEY_asciicircum, "XKB_KEY_asciicircum" );
	#endif
	#ifdef XKB_KEY_underscore
		swigIntConstant( XKB_KEY_underscore, "XKB_KEY_underscore" );
	#endif
	#ifdef XKB_KEY_grave
		swigIntConstant( XKB_KEY_grave, "XKB_KEY_grave" );
	#endif
	#ifdef XKB_KEY_quoteleft
		swigIntConstant( XKB_KEY_quoteleft, "XKB_KEY_quoteleft" );
	#endif
	#ifdef XKB_KEY_a
		swigIntConstant( XKB_KEY_a, "XKB_KEY_a" );
	#endif
	#ifdef XKB_KEY_b
		swigIntConstant( XKB_KEY_b, "XKB_KEY_b" );
	#endif
	#ifdef XKB_KEY_c
		swigIntConstant( XKB_KEY_c, "XKB_KEY_c" );
	#endif
	#ifdef XKB_KEY_d
		swigIntConstant( XKB_KEY_d, "XKB_KEY_d" );
	#endif
	#ifdef XKB_KEY_e
		swigIntConstant( XKB_KEY_e, "XKB_KEY_e" );
	#endif
	#ifdef XKB_KEY_f
		swigIntConstant( XKB_KEY_f, "XKB_KEY_f" );
	#endif
	#ifdef XKB_KEY_g
		swigIntConstant( XKB_KEY_g, "XKB_KEY_g" );
	#endif
	#ifdef XKB_KEY_h
		swigIntConstant( XKB_KEY_h, "XKB_KEY_h" );
	#endif
	#ifdef XKB_KEY_i
		swigIntConstant( XKB_KEY_i, "XKB_KEY_i" );
	#endif
	#ifdef XKB_KEY_j
		swigIntConstant( XKB_KEY_j, "XKB_KEY_j" );
	#endif
	#ifdef XKB_KEY_k
		swigIntConstant( XKB_KEY_k, "XKB_KEY_k" );
	#endif
	#ifdef XKB_KEY_l
		swigIntConstant( XKB_KEY_l, "XKB_KEY_l" );
	#endif
	#ifdef XKB_KEY_m
		swigIntConstant( XKB_KEY_m, "XKB_KEY_m" );
	#endif
	#ifdef XKB_KEY_n
		swigIntConstant( XKB_KEY_n, "XKB_KEY_n" );
	#endif
	#ifdef XKB_KEY_o
		swigIntConstant( XKB_KEY_o, "XKB_KEY_o" );
	#endif
	#ifdef XKB_KEY_p
		swigIntConstant( XKB_KEY_p, "XKB_KEY_p" );
	#endif
	#ifdef XKB_KEY_q
		swigIntConstant( XKB_KEY_q, "XKB_KEY_q" );
	#endif
	#ifdef XKB_KEY_r
		swigIntConstant( XKB_KEY_r, "XKB_KEY_r" );
	#endif
	#ifdef XKB_KEY_s
		swigIntConstant( XKB_KEY_s, "XKB_KEY_s" );
	#endif
	#ifdef XKB_KEY_t
		swigIntConstant( XKB_KEY_t, "XKB_KEY_t" );
	#endif
	#ifdef XKB_KEY_u
		swigIntConstant( XKB_KEY_u, "XKB_KEY_u" );
	#endif
	#ifdef XKB_KEY_v
		swigIntConstant( XKB_KEY_v, "XKB_KEY_v" );
	#endif
	#ifdef XKB_KEY_w
		swigIntConstant( XKB_KEY_w, "XKB_KEY_w" );
	#endif
	#ifdef XKB_KEY_x
		swigIntConstant( XKB_KEY_x, "XKB_KEY_x" );
	#endif
	#ifdef XKB_KEY_y
		swigIntConstant( XKB_KEY_y, "XKB_KEY_y" );
	#endif
	#ifdef XKB_KEY_z
		swigIntConstant( XKB_KEY_z, "XKB_KEY_z" );
	#endif
	#ifdef XKB_KEY_braceleft
		swigIntConstant( XKB_KEY_braceleft, "XKB_KEY_braceleft" );
	#endif
	#ifdef XKB_KEY_bar
		swigIntConstant( XKB_KEY_bar, "XKB_KEY_bar" );
	#endif
	#ifdef XKB_KEY_braceright
		swigIntConstant( XKB_KEY_braceright, "XKB_KEY_braceright" );
	#endif
	#ifdef XKB_KEY_asciitilde
		swigIntConstant( XKB_KEY_asciitilde, "XKB_KEY_asciitilde" );
	#endif
	#ifdef XKB_KEY_nobreakspace
		swigIntConstant( XKB_KEY_nobreakspace, "XKB_KEY_nobreakspace" );
	#endif
	#ifdef XKB_KEY_exclamdown
		swigIntConstant( XKB_KEY_exclamdown, "XKB_KEY_exclamdown" );
	#endif
	#ifdef XKB_KEY_cent
		swigIntConstant( XKB_KEY_cent, "XKB_KEY_cent" );
	#endif
	#ifdef XKB_KEY_sterling
		swigIntConstant( XKB_KEY_sterling, "XKB_KEY_sterling" );
	#endif
	#ifdef XKB_KEY_currency
		swigIntConstant( XKB_KEY_currency, "XKB_KEY_currency" );
	#endif
	#ifdef XKB_KEY_yen
		swigIntConstant( XKB_KEY_yen, "XKB_KEY_yen" );
	#endif
	#ifdef XKB_KEY_brokenbar
		swigIntConstant( XKB_KEY_brokenbar, "XKB_KEY_brokenbar" );
	#endif
	#ifdef XKB_KEY_section
		swigIntConstant( XKB_KEY_section, "XKB_KEY_section" );
	#endif
	#ifdef XKB_KEY_diaeresis
		swigIntConstant( XKB_KEY_diaeresis, "XKB_KEY_diaeresis" );
	#endif
	#ifdef XKB_KEY_copyright
		swigIntConstant( XKB_KEY_copyright, "XKB_KEY_copyright" );
	#endif
	#ifdef XKB_KEY_ordfeminine
		swigIntConstant( XKB_KEY_ordfeminine, "XKB_KEY_ordfeminine" );
	#endif
	#ifdef XKB_KEY_guillemotleft
		swigIntConstant( XKB_KEY_guillemotleft, "XKB_KEY_guillemotleft" );
	#endif
	#ifdef XKB_KEY_guillemetleft
		swigIntConstant( XKB_KEY_guillemetleft, "XKB_KEY_guillemetleft" );
	#endif
	#ifdef XKB_KEY_notsign
		swigIntConstant( XKB_KEY_notsign, "XKB_KEY_notsign" );
	#endif
	#ifdef XKB_KEY_hyphen
		swigIntConstant( XKB_KEY_hyphen, "XKB_KEY_hyphen" );
	#endif
	#ifdef XKB_KEY_registered
		swigIntConstant( XKB_KEY_registered, "XKB_KEY_registered" );
	#endif
	#ifdef XKB_KEY_macron
		swigIntConstant( XKB_KEY_macron, "XKB_KEY_macron" );
	#endif
	#ifdef XKB_KEY_degree
		swigIntConstant( XKB_KEY_degree, "XKB_KEY_degree" );
	#endif
	#ifdef XKB_KEY_plusminus
		swigIntConstant( XKB_KEY_plusminus, "XKB_KEY_plusminus" );
	#endif
	#ifdef XKB_KEY_twosuperior
		swigIntConstant( XKB_KEY_twosuperior, "XKB_KEY_twosuperior" );
	#endif
	#ifdef XKB_KEY_threesuperior
		swigIntConstant( XKB_KEY_threesuperior, "XKB_KEY_threesuperior" );
	#endif
	#ifdef XKB_KEY_acute
		swigIntConstant( XKB_KEY_acute, "XKB_KEY_acute" );
	#endif
	#ifdef XKB_KEY_mu
		swigIntConstant( XKB_KEY_mu, "XKB_KEY_mu" );
	#endif
	#ifdef XKB_KEY_paragraph
		swigIntConstant( XKB_KEY_paragraph, "XKB_KEY_paragraph" );
	#endif
	#ifdef XKB_KEY_periodcentered
		swigIntConstant( XKB_KEY_periodcentered, "XKB_KEY_periodcentered" );
	#endif
	#ifdef XKB_KEY_cedilla
		swigIntConstant( XKB_KEY_cedilla, "XKB_KEY_cedilla" );
	#endif
	#ifdef XKB_KEY_onesuperior
		swigIntConstant( XKB_KEY_onesuperior, "XKB_KEY_onesuperior" );
	#endif
	#ifdef XKB_KEY_masculine
		swigIntConstant( XKB_KEY_masculine, "XKB_KEY_masculine" );
	#endif
	#ifdef XKB_KEY_ordmasculine
		swigIntConstant( XKB_KEY_ordmasculine, "XKB_KEY_ordmasculine" );
	#endif
	#ifdef XKB_KEY_guillemotright
		swigIntConstant( XKB_KEY_guillemotright, "XKB_KEY_guillemotright" );
	#endif
	#ifdef XKB_KEY_guillemetright
		swigIntConstant( XKB_KEY_guillemetright, "XKB_KEY_guillemetright" );
	#endif
	#ifdef XKB_KEY_onequarter
		swigIntConstant( XKB_KEY_onequarter, "XKB_KEY_onequarter" );
	#endif
	#ifdef XKB_KEY_onehalf
		swigIntConstant( XKB_KEY_onehalf, "XKB_KEY_onehalf" );
	#endif
	#ifdef XKB_KEY_threequarters
		swigIntConstant( XKB_KEY_threequarters, "XKB_KEY_threequarters" );
	#endif
	#ifdef XKB_KEY_questiondown
		swigIntConstant( XKB_KEY_questiondown, "XKB_KEY_questiondown" );
	#endif
	#ifdef XKB_KEY_Agrave
		swigIntConstant( XKB_KEY_Agrave, "XKB_KEY_Agrave" );
	#endif
	#ifdef XKB_KEY_Aacute
		swigIntConstant( XKB_KEY_Aacute, "XKB_KEY_Aacute" );
	#endif
	#ifdef XKB_KEY_Acircumflex
		swigIntConstant( XKB_KEY_Acircumflex, "XKB_KEY_Acircumflex" );
	#endif
	#ifdef XKB_KEY_Atilde
		swigIntConstant( XKB_KEY_Atilde, "XKB_KEY_Atilde" );
	#endif
	#ifdef XKB_KEY_Adiaeresis
		swigIntConstant( XKB_KEY_Adiaeresis, "XKB_KEY_Adiaeresis" );
	#endif
	#ifdef XKB_KEY_Aring
		swigIntConstant( XKB_KEY_Aring, "XKB_KEY_Aring" );
	#endif
	#ifdef XKB_KEY_AE
		swigIntConstant( XKB_KEY_AE, "XKB_KEY_AE" );
	#endif
	#ifdef XKB_KEY_Ccedilla
		swigIntConstant( XKB_KEY_Ccedilla, "XKB_KEY_Ccedilla" );
	#endif
	#ifdef XKB_KEY_Egrave
		swigIntConstant( XKB_KEY_Egrave, "XKB_KEY_Egrave" );
	#endif
	#ifdef XKB_KEY_Eacute
		swigIntConstant( XKB_KEY_Eacute, "XKB_KEY_Eacute" );
	#endif
	#ifdef XKB_KEY_Ecircumflex
		swigIntConstant( XKB_KEY_Ecircumflex, "XKB_KEY_Ecircumflex" );
	#endif
	#ifdef XKB_KEY_Ediaeresis
		swigIntConstant( XKB_KEY_Ediaeresis, "XKB_KEY_Ediaeresis" );
	#endif
	#ifdef XKB_KEY_Igrave
		swigIntConstant( XKB_KEY_Igrave, "XKB_KEY_Igrave" );
	#endif
	#ifdef XKB_KEY_Iacute
		swigIntConstant( XKB_KEY_Iacute, "XKB_KEY_Iacute" );
	#endif
	#ifdef XKB_KEY_Icircumflex
		swigIntConstant( XKB_KEY_Icircumflex, "XKB_KEY_Icircumflex" );
	#endif
	#ifdef XKB_KEY_Idiaeresis
		swigIntConstant( XKB_KEY_Idiaeresis, "XKB_KEY_Idiaeresis" );
	#endif
	#ifdef XKB_KEY_ETH
		swigIntConstant( XKB_KEY_ETH, "XKB_KEY_ETH" );
	#endif
	#ifdef XKB_KEY_Eth
		swigIntConstant( XKB_KEY_Eth, "XKB_KEY_Eth" );
	#endif
	#ifdef XKB_KEY_Ntilde
		swigIntConstant( XKB_KEY_Ntilde, "XKB_KEY_Ntilde" );
	#endif
	#ifdef XKB_KEY_Ograve
		swigIntConstant( XKB_KEY_Ograve, "XKB_KEY_Ograve" );
	#endif
	#ifdef XKB_KEY_Oacute
		swigIntConstant( XKB_KEY_Oacute, "XKB_KEY_Oacute" );
	#endif
	#ifdef XKB_KEY_Ocircumflex
		swigIntConstant( XKB_KEY_Ocircumflex, "XKB_KEY_Ocircumflex" );
	#endif
	#ifdef XKB_KEY_Otilde
		swigIntConstant( XKB_KEY_Otilde, "XKB_KEY_Otilde" );
	#endif
	#ifdef XKB_KEY_Odiaeresis
		swigIntConstant( XKB_KEY_Odiaeresis, "XKB_KEY_Odiaeresis" );
	#endif
	#ifdef XKB_KEY_multiply
		swigIntConstant( XKB_KEY_multiply, "XKB_KEY_multiply" );
	#endif
	#ifdef XKB_KEY_Oslash
		swigIntConstant( XKB_KEY_Oslash, "XKB_KEY_Oslash" );
	#endif
	#ifdef XKB_KEY_Ooblique
		swigIntConstant( XKB_KEY_Ooblique, "XKB_KEY_Ooblique" );
	#endif
	#ifdef XKB_KEY_Ugrave
		swigIntConstant( XKB_KEY_Ugrave, "XKB_KEY_Ugrave" );
	#endif
	#ifdef XKB_KEY_Uacute
		swigIntConstant( XKB_KEY_Uacute, "XKB_KEY_Uacute" );
	#endif
	#ifdef XKB_KEY_Ucircumflex
		swigIntConstant( XKB_KEY_Ucircumflex, "XKB_KEY_Ucircumflex" );
	#endif
	#ifdef XKB_KEY_Udiaeresis
		swigIntConstant( XKB_KEY_Udiaeresis, "XKB_KEY_Udiaeresis" );
	#endif
	#ifdef XKB_KEY_Yacute
		swigIntConstant( XKB_KEY_Yacute, "XKB_KEY_Yacute" );
	#endif
	#ifdef XKB_KEY_THORN
		swigIntConstant( XKB_KEY_THORN, "XKB_KEY_THORN" );
	#endif
	#ifdef XKB_KEY_Thorn
		swigIntConstant( XKB_KEY_Thorn, "XKB_KEY_Thorn" );
	#endif
	#ifdef XKB_KEY_ssharp
		swigIntConstant( XKB_KEY_ssharp, "XKB_KEY_ssharp" );
	#endif
	#ifdef XKB_KEY_agrave
		swigIntConstant( XKB_KEY_agrave, "XKB_KEY_agrave" );
	#endif
	#ifdef XKB_KEY_aacute
		swigIntConstant( XKB_KEY_aacute, "XKB_KEY_aacute" );
	#endif
	#ifdef XKB_KEY_acircumflex
		swigIntConstant( XKB_KEY_acircumflex, "XKB_KEY_acircumflex" );
	#endif
	#ifdef XKB_KEY_atilde
		swigIntConstant( XKB_KEY_atilde, "XKB_KEY_atilde" );
	#endif
	#ifdef XKB_KEY_adiaeresis
		swigIntConstant( XKB_KEY_adiaeresis, "XKB_KEY_adiaeresis" );
	#endif
	#ifdef XKB_KEY_aring
		swigIntConstant( XKB_KEY_aring, "XKB_KEY_aring" );
	#endif
	#ifdef XKB_KEY_ae
		swigIntConstant( XKB_KEY_ae, "XKB_KEY_ae" );
	#endif
	#ifdef XKB_KEY_ccedilla
		swigIntConstant( XKB_KEY_ccedilla, "XKB_KEY_ccedilla" );
	#endif
	#ifdef XKB_KEY_egrave
		swigIntConstant( XKB_KEY_egrave, "XKB_KEY_egrave" );
	#endif
	#ifdef XKB_KEY_eacute
		swigIntConstant( XKB_KEY_eacute, "XKB_KEY_eacute" );
	#endif
	#ifdef XKB_KEY_ecircumflex
		swigIntConstant( XKB_KEY_ecircumflex, "XKB_KEY_ecircumflex" );
	#endif
	#ifdef XKB_KEY_ediaeresis
		swigIntConstant( XKB_KEY_ediaeresis, "XKB_KEY_ediaeresis" );
	#endif
	#ifdef XKB_KEY_igrave
		swigIntConstant( XKB_KEY_igrave, "XKB_KEY_igrave" );
	#endif
	#ifdef XKB_KEY_iacute
		swigIntConstant( XKB_KEY_iacute, "XKB_KEY_iacute" );
	#endif
	#ifdef XKB_KEY_icircumflex
		swigIntConstant( XKB_KEY_icircumflex, "XKB_KEY_icircumflex" );
	#endif
	#ifdef XKB_KEY_idiaeresis
		swigIntConstant( XKB_KEY_idiaeresis, "XKB_KEY_idiaeresis" );
	#endif
	#ifdef XKB_KEY_eth
		swigIntConstant( XKB_KEY_eth, "XKB_KEY_eth" );
	#endif
	#ifdef XKB_KEY_ntilde
		swigIntConstant( XKB_KEY_ntilde, "XKB_KEY_ntilde" );
	#endif
	#ifdef XKB_KEY_ograve
		swigIntConstant( XKB_KEY_ograve, "XKB_KEY_ograve" );
	#endif
	#ifdef XKB_KEY_oacute
		swigIntConstant( XKB_KEY_oacute, "XKB_KEY_oacute" );
	#endif
	#ifdef XKB_KEY_ocircumflex
		swigIntConstant( XKB_KEY_ocircumflex, "XKB_KEY_ocircumflex" );
	#endif
	#ifdef XKB_KEY_otilde
		swigIntConstant( XKB_KEY_otilde, "XKB_KEY_otilde" );
	#endif
	#ifdef XKB_KEY_odiaeresis
		swigIntConstant( XKB_KEY_odiaeresis, "XKB_KEY_odiaeresis" );
	#endif
	#ifdef XKB_KEY_division
		swigIntConstant( XKB_KEY_division, "XKB_KEY_division" );
	#endif
	#ifdef XKB_KEY_oslash
		swigIntConstant( XKB_KEY_oslash, "XKB_KEY_oslash" );
	#endif
	#ifdef XKB_KEY_ooblique
		swigIntConstant( XKB_KEY_ooblique, "XKB_KEY_ooblique" );
	#endif
	#ifdef XKB_KEY_ugrave
		swigIntConstant( XKB_KEY_ugrave, "XKB_KEY_ugrave" );
	#endif
	#ifdef XKB_KEY_uacute
		swigIntConstant( XKB_KEY_uacute, "XKB_KEY_uacute" );
	#endif
	#ifdef XKB_KEY_ucircumflex
		swigIntConstant( XKB_KEY_ucircumflex, "XKB_KEY_ucircumflex" );
	#endif
	#ifdef XKB_KEY_udiaeresis
		swigIntConstant( XKB_KEY_udiaeresis, "XKB_KEY_udiaeresis" );
	#endif
	#ifdef XKB_KEY_yacute
		swigIntConstant( XKB_KEY_yacute, "XKB_KEY_yacute" );
	#endif
	#ifdef XKB_KEY_thorn
		swigIntConstant( XKB_KEY_thorn, "XKB_KEY_thorn" );
	#endif
	#ifdef XKB_KEY_ydiaeresis
		swigIntConstant( XKB_KEY_ydiaeresis, "XKB_KEY_ydiaeresis" );
	#endif
	#ifdef XKB_KEY_Aogonek
		swigIntConstant( XKB_KEY_Aogonek, "XKB_KEY_Aogonek" );
	#endif
	#ifdef XKB_KEY_breve
		swigIntConstant( XKB_KEY_breve, "XKB_KEY_breve" );
	#endif
	#ifdef XKB_KEY_Lstroke
		swigIntConstant( XKB_KEY_Lstroke, "XKB_KEY_Lstroke" );
	#endif
	#ifdef XKB_KEY_Lcaron
		swigIntConstant( XKB_KEY_Lcaron, "XKB_KEY_Lcaron" );
	#endif
	#ifdef XKB_KEY_Sacute
		swigIntConstant( XKB_KEY_Sacute, "XKB_KEY_Sacute" );
	#endif
	#ifdef XKB_KEY_Scaron
		swigIntConstant( XKB_KEY_Scaron, "XKB_KEY_Scaron" );
	#endif
	#ifdef XKB_KEY_Scedilla
		swigIntConstant( XKB_KEY_Scedilla, "XKB_KEY_Scedilla" );
	#endif
	#ifdef XKB_KEY_Tcaron
		swigIntConstant( XKB_KEY_Tcaron, "XKB_KEY_Tcaron" );
	#endif
	#ifdef XKB_KEY_Zacute
		swigIntConstant( XKB_KEY_Zacute, "XKB_KEY_Zacute" );
	#endif
	#ifdef XKB_KEY_Zcaron
		swigIntConstant( XKB_KEY_Zcaron, "XKB_KEY_Zcaron" );
	#endif
	#ifdef XKB_KEY_Zabovedot
		swigIntConstant( XKB_KEY_Zabovedot, "XKB_KEY_Zabovedot" );
	#endif
	#ifdef XKB_KEY_aogonek
		swigIntConstant( XKB_KEY_aogonek, "XKB_KEY_aogonek" );
	#endif
	#ifdef XKB_KEY_ogonek
		swigIntConstant( XKB_KEY_ogonek, "XKB_KEY_ogonek" );
	#endif
	#ifdef XKB_KEY_lstroke
		swigIntConstant( XKB_KEY_lstroke, "XKB_KEY_lstroke" );
	#endif
	#ifdef XKB_KEY_lcaron
		swigIntConstant( XKB_KEY_lcaron, "XKB_KEY_lcaron" );
	#endif
	#ifdef XKB_KEY_sacute
		swigIntConstant( XKB_KEY_sacute, "XKB_KEY_sacute" );
	#endif
	#ifdef XKB_KEY_caron
		swigIntConstant( XKB_KEY_caron, "XKB_KEY_caron" );
	#endif
	#ifdef XKB_KEY_scaron
		swigIntConstant( XKB_KEY_scaron, "XKB_KEY_scaron" );
	#endif
	#ifdef XKB_KEY_scedilla
		swigIntConstant( XKB_KEY_scedilla, "XKB_KEY_scedilla" );
	#endif
	#ifdef XKB_KEY_tcaron
		swigIntConstant( XKB_KEY_tcaron, "XKB_KEY_tcaron" );
	#endif
	#ifdef XKB_KEY_zacute
		swigIntConstant( XKB_KEY_zacute, "XKB_KEY_zacute" );
	#endif
	#ifdef XKB_KEY_doubleacute
		swigIntConstant( XKB_KEY_doubleacute, "XKB_KEY_doubleacute" );
	#endif
	#ifdef XKB_KEY_zcaron
		swigIntConstant( XKB_KEY_zcaron, "XKB_KEY_zcaron" );
	#endif
	#ifdef XKB_KEY_zabovedot
		swigIntConstant( XKB_KEY_zabovedot, "XKB_KEY_zabovedot" );
	#endif
	#ifdef XKB_KEY_Racute
		swigIntConstant( XKB_KEY_Racute, "XKB_KEY_Racute" );
	#endif
	#ifdef XKB_KEY_Abreve
		swigIntConstant( XKB_KEY_Abreve, "XKB_KEY_Abreve" );
	#endif
	#ifdef XKB_KEY_Lacute
		swigIntConstant( XKB_KEY_Lacute, "XKB_KEY_Lacute" );
	#endif
	#ifdef XKB_KEY_Cacute
		swigIntConstant( XKB_KEY_Cacute, "XKB_KEY_Cacute" );
	#endif
	#ifdef XKB_KEY_Ccaron
		swigIntConstant( XKB_KEY_Ccaron, "XKB_KEY_Ccaron" );
	#endif
	#ifdef XKB_KEY_Eogonek
		swigIntConstant( XKB_KEY_Eogonek, "XKB_KEY_Eogonek" );
	#endif
	#ifdef XKB_KEY_Ecaron
		swigIntConstant( XKB_KEY_Ecaron, "XKB_KEY_Ecaron" );
	#endif
	#ifdef XKB_KEY_Dcaron
		swigIntConstant( XKB_KEY_Dcaron, "XKB_KEY_Dcaron" );
	#endif
	#ifdef XKB_KEY_Dstroke
		swigIntConstant( XKB_KEY_Dstroke, "XKB_KEY_Dstroke" );
	#endif
	#ifdef XKB_KEY_Nacute
		swigIntConstant( XKB_KEY_Nacute, "XKB_KEY_Nacute" );
	#endif
	#ifdef XKB_KEY_Ncaron
		swigIntConstant( XKB_KEY_Ncaron, "XKB_KEY_Ncaron" );
	#endif
	#ifdef XKB_KEY_Odoubleacute
		swigIntConstant( XKB_KEY_Odoubleacute, "XKB_KEY_Odoubleacute" );
	#endif
	#ifdef XKB_KEY_Rcaron
		swigIntConstant( XKB_KEY_Rcaron, "XKB_KEY_Rcaron" );
	#endif
	#ifdef XKB_KEY_Uring
		swigIntConstant( XKB_KEY_Uring, "XKB_KEY_Uring" );
	#endif
	#ifdef XKB_KEY_Udoubleacute
		swigIntConstant( XKB_KEY_Udoubleacute, "XKB_KEY_Udoubleacute" );
	#endif
	#ifdef XKB_KEY_Tcedilla
		swigIntConstant( XKB_KEY_Tcedilla, "XKB_KEY_Tcedilla" );
	#endif
	#ifdef XKB_KEY_racute
		swigIntConstant( XKB_KEY_racute, "XKB_KEY_racute" );
	#endif
	#ifdef XKB_KEY_abreve
		swigIntConstant( XKB_KEY_abreve, "XKB_KEY_abreve" );
	#endif
	#ifdef XKB_KEY_lacute
		swigIntConstant( XKB_KEY_lacute, "XKB_KEY_lacute" );
	#endif
	#ifdef XKB_KEY_cacute
		swigIntConstant( XKB_KEY_cacute, "XKB_KEY_cacute" );
	#endif
	#ifdef XKB_KEY_ccaron
		swigIntConstant( XKB_KEY_ccaron, "XKB_KEY_ccaron" );
	#endif
	#ifdef XKB_KEY_eogonek
		swigIntConstant( XKB_KEY_eogonek, "XKB_KEY_eogonek" );
	#endif
	#ifdef XKB_KEY_ecaron
		swigIntConstant( XKB_KEY_ecaron, "XKB_KEY_ecaron" );
	#endif
	#ifdef XKB_KEY_dcaron
		swigIntConstant( XKB_KEY_dcaron, "XKB_KEY_dcaron" );
	#endif
	#ifdef XKB_KEY_dstroke
		swigIntConstant( XKB_KEY_dstroke, "XKB_KEY_dstroke" );
	#endif
	#ifdef XKB_KEY_nacute
		swigIntConstant( XKB_KEY_nacute, "XKB_KEY_nacute" );
	#endif
	#ifdef XKB_KEY_ncaron
		swigIntConstant( XKB_KEY_ncaron, "XKB_KEY_ncaron" );
	#endif
	#ifdef XKB_KEY_odoubleacute
		swigIntConstant( XKB_KEY_odoubleacute, "XKB_KEY_odoubleacute" );
	#endif
	#ifdef XKB_KEY_rcaron
		swigIntConstant( XKB_KEY_rcaron, "XKB_KEY_rcaron" );
	#endif
	#ifdef XKB_KEY_uring
		swigIntConstant( XKB_KEY_uring, "XKB_KEY_uring" );
	#endif
	#ifdef XKB_KEY_udoubleacute
		swigIntConstant( XKB_KEY_udoubleacute, "XKB_KEY_udoubleacute" );
	#endif
	#ifdef XKB_KEY_tcedilla
		swigIntConstant( XKB_KEY_tcedilla, "XKB_KEY_tcedilla" );
	#endif
	#ifdef XKB_KEY_abovedot
		swigIntConstant( XKB_KEY_abovedot, "XKB_KEY_abovedot" );
	#endif
	#ifdef XKB_KEY_Hstroke
		swigIntConstant( XKB_KEY_Hstroke, "XKB_KEY_Hstroke" );
	#endif
	#ifdef XKB_KEY_Hcircumflex
		swigIntConstant( XKB_KEY_Hcircumflex, "XKB_KEY_Hcircumflex" );
	#endif
	#ifdef XKB_KEY_Iabovedot
		swigIntConstant( XKB_KEY_Iabovedot, "XKB_KEY_Iabovedot" );
	#endif
	#ifdef XKB_KEY_Gbreve
		swigIntConstant( XKB_KEY_Gbreve, "XKB_KEY_Gbreve" );
	#endif
	#ifdef XKB_KEY_Jcircumflex
		swigIntConstant( XKB_KEY_Jcircumflex, "XKB_KEY_Jcircumflex" );
	#endif
	#ifdef XKB_KEY_hstroke
		swigIntConstant( XKB_KEY_hstroke, "XKB_KEY_hstroke" );
	#endif
	#ifdef XKB_KEY_hcircumflex
		swigIntConstant( XKB_KEY_hcircumflex, "XKB_KEY_hcircumflex" );
	#endif
	#ifdef XKB_KEY_idotless
		swigIntConstant( XKB_KEY_idotless, "XKB_KEY_idotless" );
	#endif
	#ifdef XKB_KEY_gbreve
		swigIntConstant( XKB_KEY_gbreve, "XKB_KEY_gbreve" );
	#endif
	#ifdef XKB_KEY_jcircumflex
		swigIntConstant( XKB_KEY_jcircumflex, "XKB_KEY_jcircumflex" );
	#endif
	#ifdef XKB_KEY_Cabovedot
		swigIntConstant( XKB_KEY_Cabovedot, "XKB_KEY_Cabovedot" );
	#endif
	#ifdef XKB_KEY_Ccircumflex
		swigIntConstant( XKB_KEY_Ccircumflex, "XKB_KEY_Ccircumflex" );
	#endif
	#ifdef XKB_KEY_Gabovedot
		swigIntConstant( XKB_KEY_Gabovedot, "XKB_KEY_Gabovedot" );
	#endif
	#ifdef XKB_KEY_Gcircumflex
		swigIntConstant( XKB_KEY_Gcircumflex, "XKB_KEY_Gcircumflex" );
	#endif
	#ifdef XKB_KEY_Ubreve
		swigIntConstant( XKB_KEY_Ubreve, "XKB_KEY_Ubreve" );
	#endif
	#ifdef XKB_KEY_Scircumflex
		swigIntConstant( XKB_KEY_Scircumflex, "XKB_KEY_Scircumflex" );
	#endif
	#ifdef XKB_KEY_cabovedot
		swigIntConstant( XKB_KEY_cabovedot, "XKB_KEY_cabovedot" );
	#endif
	#ifdef XKB_KEY_ccircumflex
		swigIntConstant( XKB_KEY_ccircumflex, "XKB_KEY_ccircumflex" );
	#endif
	#ifdef XKB_KEY_gabovedot
		swigIntConstant( XKB_KEY_gabovedot, "XKB_KEY_gabovedot" );
	#endif
	#ifdef XKB_KEY_gcircumflex
		swigIntConstant( XKB_KEY_gcircumflex, "XKB_KEY_gcircumflex" );
	#endif
	#ifdef XKB_KEY_ubreve
		swigIntConstant( XKB_KEY_ubreve, "XKB_KEY_ubreve" );
	#endif
	#ifdef XKB_KEY_scircumflex
		swigIntConstant( XKB_KEY_scircumflex, "XKB_KEY_scircumflex" );
	#endif
	#ifdef XKB_KEY_kra
		swigIntConstant( XKB_KEY_kra, "XKB_KEY_kra" );
	#endif
	#ifdef XKB_KEY_kappa
		swigIntConstant( XKB_KEY_kappa, "XKB_KEY_kappa" );
	#endif
	#ifdef XKB_KEY_Rcedilla
		swigIntConstant( XKB_KEY_Rcedilla, "XKB_KEY_Rcedilla" );
	#endif
	#ifdef XKB_KEY_Itilde
		swigIntConstant( XKB_KEY_Itilde, "XKB_KEY_Itilde" );
	#endif
	#ifdef XKB_KEY_Lcedilla
		swigIntConstant( XKB_KEY_Lcedilla, "XKB_KEY_Lcedilla" );
	#endif
	#ifdef XKB_KEY_Emacron
		swigIntConstant( XKB_KEY_Emacron, "XKB_KEY_Emacron" );
	#endif
	#ifdef XKB_KEY_Gcedilla
		swigIntConstant( XKB_KEY_Gcedilla, "XKB_KEY_Gcedilla" );
	#endif
	#ifdef XKB_KEY_Tslash
		swigIntConstant( XKB_KEY_Tslash, "XKB_KEY_Tslash" );
	#endif
	#ifdef XKB_KEY_rcedilla
		swigIntConstant( XKB_KEY_rcedilla, "XKB_KEY_rcedilla" );
	#endif
	#ifdef XKB_KEY_itilde
		swigIntConstant( XKB_KEY_itilde, "XKB_KEY_itilde" );
	#endif
	#ifdef XKB_KEY_lcedilla
		swigIntConstant( XKB_KEY_lcedilla, "XKB_KEY_lcedilla" );
	#endif
	#ifdef XKB_KEY_emacron
		swigIntConstant( XKB_KEY_emacron, "XKB_KEY_emacron" );
	#endif
	#ifdef XKB_KEY_gcedilla
		swigIntConstant( XKB_KEY_gcedilla, "XKB_KEY_gcedilla" );
	#endif
	#ifdef XKB_KEY_tslash
		swigIntConstant( XKB_KEY_tslash, "XKB_KEY_tslash" );
	#endif
	#ifdef XKB_KEY_ENG
		swigIntConstant( XKB_KEY_ENG, "XKB_KEY_ENG" );
	#endif
	#ifdef XKB_KEY_eng
		swigIntConstant( XKB_KEY_eng, "XKB_KEY_eng" );
	#endif
	#ifdef XKB_KEY_Amacron
		swigIntConstant( XKB_KEY_Amacron, "XKB_KEY_Amacron" );
	#endif
	#ifdef XKB_KEY_Iogonek
		swigIntConstant( XKB_KEY_Iogonek, "XKB_KEY_Iogonek" );
	#endif
	#ifdef XKB_KEY_Eabovedot
		swigIntConstant( XKB_KEY_Eabovedot, "XKB_KEY_Eabovedot" );
	#endif
	#ifdef XKB_KEY_Imacron
		swigIntConstant( XKB_KEY_Imacron, "XKB_KEY_Imacron" );
	#endif
	#ifdef XKB_KEY_Ncedilla
		swigIntConstant( XKB_KEY_Ncedilla, "XKB_KEY_Ncedilla" );
	#endif
	#ifdef XKB_KEY_Omacron
		swigIntConstant( XKB_KEY_Omacron, "XKB_KEY_Omacron" );
	#endif
	#ifdef XKB_KEY_Kcedilla
		swigIntConstant( XKB_KEY_Kcedilla, "XKB_KEY_Kcedilla" );
	#endif
	#ifdef XKB_KEY_Uogonek
		swigIntConstant( XKB_KEY_Uogonek, "XKB_KEY_Uogonek" );
	#endif
	#ifdef XKB_KEY_Utilde
		swigIntConstant( XKB_KEY_Utilde, "XKB_KEY_Utilde" );
	#endif
	#ifdef XKB_KEY_Umacron
		swigIntConstant( XKB_KEY_Umacron, "XKB_KEY_Umacron" );
	#endif
	#ifdef XKB_KEY_amacron
		swigIntConstant( XKB_KEY_amacron, "XKB_KEY_amacron" );
	#endif
	#ifdef XKB_KEY_iogonek
		swigIntConstant( XKB_KEY_iogonek, "XKB_KEY_iogonek" );
	#endif
	#ifdef XKB_KEY_eabovedot
		swigIntConstant( XKB_KEY_eabovedot, "XKB_KEY_eabovedot" );
	#endif
	#ifdef XKB_KEY_imacron
		swigIntConstant( XKB_KEY_imacron, "XKB_KEY_imacron" );
	#endif
	#ifdef XKB_KEY_ncedilla
		swigIntConstant( XKB_KEY_ncedilla, "XKB_KEY_ncedilla" );
	#endif
	#ifdef XKB_KEY_omacron
		swigIntConstant( XKB_KEY_omacron, "XKB_KEY_omacron" );
	#endif
	#ifdef XKB_KEY_kcedilla
		swigIntConstant( XKB_KEY_kcedilla, "XKB_KEY_kcedilla" );
	#endif
	#ifdef XKB_KEY_uogonek
		swigIntConstant( XKB_KEY_uogonek, "XKB_KEY_uogonek" );
	#endif
	#ifdef XKB_KEY_utilde
		swigIntConstant( XKB_KEY_utilde, "XKB_KEY_utilde" );
	#endif
	#ifdef XKB_KEY_umacron
		swigIntConstant( XKB_KEY_umacron, "XKB_KEY_umacron" );
	#endif
	#ifdef XKB_KEY_Wcircumflex
		swigIntConstant( XKB_KEY_Wcircumflex, "XKB_KEY_Wcircumflex" );
	#endif
	#ifdef XKB_KEY_wcircumflex
		swigIntConstant( XKB_KEY_wcircumflex, "XKB_KEY_wcircumflex" );
	#endif
	#ifdef XKB_KEY_Ycircumflex
		swigIntConstant( XKB_KEY_Ycircumflex, "XKB_KEY_Ycircumflex" );
	#endif
	#ifdef XKB_KEY_ycircumflex
		swigIntConstant( XKB_KEY_ycircumflex, "XKB_KEY_ycircumflex" );
	#endif
	#ifdef XKB_KEY_Babovedot
		swigIntConstant( XKB_KEY_Babovedot, "XKB_KEY_Babovedot" );
	#endif
	#ifdef XKB_KEY_babovedot
		swigIntConstant( XKB_KEY_babovedot, "XKB_KEY_babovedot" );
	#endif
	#ifdef XKB_KEY_Dabovedot
		swigIntConstant( XKB_KEY_Dabovedot, "XKB_KEY_Dabovedot" );
	#endif
	#ifdef XKB_KEY_dabovedot
		swigIntConstant( XKB_KEY_dabovedot, "XKB_KEY_dabovedot" );
	#endif
	#ifdef XKB_KEY_Fabovedot
		swigIntConstant( XKB_KEY_Fabovedot, "XKB_KEY_Fabovedot" );
	#endif
	#ifdef XKB_KEY_fabovedot
		swigIntConstant( XKB_KEY_fabovedot, "XKB_KEY_fabovedot" );
	#endif
	#ifdef XKB_KEY_Mabovedot
		swigIntConstant( XKB_KEY_Mabovedot, "XKB_KEY_Mabovedot" );
	#endif
	#ifdef XKB_KEY_mabovedot
		swigIntConstant( XKB_KEY_mabovedot, "XKB_KEY_mabovedot" );
	#endif
	#ifdef XKB_KEY_Pabovedot
		swigIntConstant( XKB_KEY_Pabovedot, "XKB_KEY_Pabovedot" );
	#endif
	#ifdef XKB_KEY_pabovedot
		swigIntConstant( XKB_KEY_pabovedot, "XKB_KEY_pabovedot" );
	#endif
	#ifdef XKB_KEY_Sabovedot
		swigIntConstant( XKB_KEY_Sabovedot, "XKB_KEY_Sabovedot" );
	#endif
	#ifdef XKB_KEY_sabovedot
		swigIntConstant( XKB_KEY_sabovedot, "XKB_KEY_sabovedot" );
	#endif
	#ifdef XKB_KEY_Tabovedot
		swigIntConstant( XKB_KEY_Tabovedot, "XKB_KEY_Tabovedot" );
	#endif
	#ifdef XKB_KEY_tabovedot
		swigIntConstant( XKB_KEY_tabovedot, "XKB_KEY_tabovedot" );
	#endif
	#ifdef XKB_KEY_Wgrave
		swigIntConstant( XKB_KEY_Wgrave, "XKB_KEY_Wgrave" );
	#endif
	#ifdef XKB_KEY_wgrave
		swigIntConstant( XKB_KEY_wgrave, "XKB_KEY_wgrave" );
	#endif
	#ifdef XKB_KEY_Wacute
		swigIntConstant( XKB_KEY_Wacute, "XKB_KEY_Wacute" );
	#endif
	#ifdef XKB_KEY_wacute
		swigIntConstant( XKB_KEY_wacute, "XKB_KEY_wacute" );
	#endif
	#ifdef XKB_KEY_Wdiaeresis
		swigIntConstant( XKB_KEY_Wdiaeresis, "XKB_KEY_Wdiaeresis" );
	#endif
	#ifdef XKB_KEY_wdiaeresis
		swigIntConstant( XKB_KEY_wdiaeresis, "XKB_KEY_wdiaeresis" );
	#endif
	#ifdef XKB_KEY_Ygrave
		swigIntConstant( XKB_KEY_Ygrave, "XKB_KEY_Ygrave" );
	#endif
	#ifdef XKB_KEY_ygrave
		swigIntConstant( XKB_KEY_ygrave, "XKB_KEY_ygrave" );
	#endif
	#ifdef XKB_KEY_OE
		swigIntConstant( XKB_KEY_OE, "XKB_KEY_OE" );
	#endif
	#ifdef XKB_KEY_oe
		swigIntConstant( XKB_KEY_oe, "XKB_KEY_oe" );
	#endif
	#ifdef XKB_KEY_Ydiaeresis
		swigIntConstant( XKB_KEY_Ydiaeresis, "XKB_KEY_Ydiaeresis" );
	#endif
	#ifdef XKB_KEY_overline
		swigIntConstant( XKB_KEY_overline, "XKB_KEY_overline" );
	#endif
	#ifdef XKB_KEY_kana_fullstop
		swigIntConstant( XKB_KEY_kana_fullstop, "XKB_KEY_kana_fullstop" );
	#endif
	#ifdef XKB_KEY_kana_openingbracket
		swigIntConstant( XKB_KEY_kana_openingbracket, "XKB_KEY_kana_openingbracket" );
	#endif
	#ifdef XKB_KEY_kana_closingbracket
		swigIntConstant( XKB_KEY_kana_closingbracket, "XKB_KEY_kana_closingbracket" );
	#endif
	#ifdef XKB_KEY_kana_comma
		swigIntConstant( XKB_KEY_kana_comma, "XKB_KEY_kana_comma" );
	#endif
	#ifdef XKB_KEY_kana_conjunctive
		swigIntConstant( XKB_KEY_kana_conjunctive, "XKB_KEY_kana_conjunctive" );
	#endif
	#ifdef XKB_KEY_kana_middledot
		swigIntConstant( XKB_KEY_kana_middledot, "XKB_KEY_kana_middledot" );
	#endif
	#ifdef XKB_KEY_kana_WO
		swigIntConstant( XKB_KEY_kana_WO, "XKB_KEY_kana_WO" );
	#endif
	#ifdef XKB_KEY_kana_a
		swigIntConstant( XKB_KEY_kana_a, "XKB_KEY_kana_a" );
	#endif
	#ifdef XKB_KEY_kana_i
		swigIntConstant( XKB_KEY_kana_i, "XKB_KEY_kana_i" );
	#endif
	#ifdef XKB_KEY_kana_u
		swigIntConstant( XKB_KEY_kana_u, "XKB_KEY_kana_u" );
	#endif
	#ifdef XKB_KEY_kana_e
		swigIntConstant( XKB_KEY_kana_e, "XKB_KEY_kana_e" );
	#endif
	#ifdef XKB_KEY_kana_o
		swigIntConstant( XKB_KEY_kana_o, "XKB_KEY_kana_o" );
	#endif
	#ifdef XKB_KEY_kana_ya
		swigIntConstant( XKB_KEY_kana_ya, "XKB_KEY_kana_ya" );
	#endif
	#ifdef XKB_KEY_kana_yu
		swigIntConstant( XKB_KEY_kana_yu, "XKB_KEY_kana_yu" );
	#endif
	#ifdef XKB_KEY_kana_yo
		swigIntConstant( XKB_KEY_kana_yo, "XKB_KEY_kana_yo" );
	#endif
	#ifdef XKB_KEY_kana_tsu
		swigIntConstant( XKB_KEY_kana_tsu, "XKB_KEY_kana_tsu" );
	#endif
	#ifdef XKB_KEY_kana_tu
		swigIntConstant( XKB_KEY_kana_tu, "XKB_KEY_kana_tu" );
	#endif
	#ifdef XKB_KEY_prolongedsound
		swigIntConstant( XKB_KEY_prolongedsound, "XKB_KEY_prolongedsound" );
	#endif
	#ifdef XKB_KEY_kana_A
		swigIntConstant( XKB_KEY_kana_A, "XKB_KEY_kana_A" );
	#endif
	#ifdef XKB_KEY_kana_I
		swigIntConstant( XKB_KEY_kana_I, "XKB_KEY_kana_I" );
	#endif
	#ifdef XKB_KEY_kana_U
		swigIntConstant( XKB_KEY_kana_U, "XKB_KEY_kana_U" );
	#endif
	#ifdef XKB_KEY_kana_E
		swigIntConstant( XKB_KEY_kana_E, "XKB_KEY_kana_E" );
	#endif
	#ifdef XKB_KEY_kana_O
		swigIntConstant( XKB_KEY_kana_O, "XKB_KEY_kana_O" );
	#endif
	#ifdef XKB_KEY_kana_KA
		swigIntConstant( XKB_KEY_kana_KA, "XKB_KEY_kana_KA" );
	#endif
	#ifdef XKB_KEY_kana_KI
		swigIntConstant( XKB_KEY_kana_KI, "XKB_KEY_kana_KI" );
	#endif
	#ifdef XKB_KEY_kana_KU
		swigIntConstant( XKB_KEY_kana_KU, "XKB_KEY_kana_KU" );
	#endif
	#ifdef XKB_KEY_kana_KE
		swigIntConstant( XKB_KEY_kana_KE, "XKB_KEY_kana_KE" );
	#endif
	#ifdef XKB_KEY_kana_KO
		swigIntConstant( XKB_KEY_kana_KO, "XKB_KEY_kana_KO" );
	#endif
	#ifdef XKB_KEY_kana_SA
		swigIntConstant( XKB_KEY_kana_SA, "XKB_KEY_kana_SA" );
	#endif
	#ifdef XKB_KEY_kana_SHI
		swigIntConstant( XKB_KEY_kana_SHI, "XKB_KEY_kana_SHI" );
	#endif
	#ifdef XKB_KEY_kana_SU
		swigIntConstant( XKB_KEY_kana_SU, "XKB_KEY_kana_SU" );
	#endif
	#ifdef XKB_KEY_kana_SE
		swigIntConstant( XKB_KEY_kana_SE, "XKB_KEY_kana_SE" );
	#endif
	#ifdef XKB_KEY_kana_SO
		swigIntConstant( XKB_KEY_kana_SO, "XKB_KEY_kana_SO" );
	#endif
	#ifdef XKB_KEY_kana_TA
		swigIntConstant( XKB_KEY_kana_TA, "XKB_KEY_kana_TA" );
	#endif
	#ifdef XKB_KEY_kana_CHI
		swigIntConstant( XKB_KEY_kana_CHI, "XKB_KEY_kana_CHI" );
	#endif
	#ifdef XKB_KEY_kana_TI
		swigIntConstant( XKB_KEY_kana_TI, "XKB_KEY_kana_TI" );
	#endif
	#ifdef XKB_KEY_kana_TSU
		swigIntConstant( XKB_KEY_kana_TSU, "XKB_KEY_kana_TSU" );
	#endif
	#ifdef XKB_KEY_kana_TU
		swigIntConstant( XKB_KEY_kana_TU, "XKB_KEY_kana_TU" );
	#endif
	#ifdef XKB_KEY_kana_TE
		swigIntConstant( XKB_KEY_kana_TE, "XKB_KEY_kana_TE" );
	#endif
	#ifdef XKB_KEY_kana_TO
		swigIntConstant( XKB_KEY_kana_TO, "XKB_KEY_kana_TO" );
	#endif
	#ifdef XKB_KEY_kana_NA
		swigIntConstant( XKB_KEY_kana_NA, "XKB_KEY_kana_NA" );
	#endif
	#ifdef XKB_KEY_kana_NI
		swigIntConstant( XKB_KEY_kana_NI, "XKB_KEY_kana_NI" );
	#endif
	#ifdef XKB_KEY_kana_NU
		swigIntConstant( XKB_KEY_kana_NU, "XKB_KEY_kana_NU" );
	#endif
	#ifdef XKB_KEY_kana_NE
		swigIntConstant( XKB_KEY_kana_NE, "XKB_KEY_kana_NE" );
	#endif
	#ifdef XKB_KEY_kana_NO
		swigIntConstant( XKB_KEY_kana_NO, "XKB_KEY_kana_NO" );
	#endif
	#ifdef XKB_KEY_kana_HA
		swigIntConstant( XKB_KEY_kana_HA, "XKB_KEY_kana_HA" );
	#endif
	#ifdef XKB_KEY_kana_HI
		swigIntConstant( XKB_KEY_kana_HI, "XKB_KEY_kana_HI" );
	#endif
	#ifdef XKB_KEY_kana_FU
		swigIntConstant( XKB_KEY_kana_FU, "XKB_KEY_kana_FU" );
	#endif
	#ifdef XKB_KEY_kana_HU
		swigIntConstant( XKB_KEY_kana_HU, "XKB_KEY_kana_HU" );
	#endif
	#ifdef XKB_KEY_kana_HE
		swigIntConstant( XKB_KEY_kana_HE, "XKB_KEY_kana_HE" );
	#endif
	#ifdef XKB_KEY_kana_HO
		swigIntConstant( XKB_KEY_kana_HO, "XKB_KEY_kana_HO" );
	#endif
	#ifdef XKB_KEY_kana_MA
		swigIntConstant( XKB_KEY_kana_MA, "XKB_KEY_kana_MA" );
	#endif
	#ifdef XKB_KEY_kana_MI
		swigIntConstant( XKB_KEY_kana_MI, "XKB_KEY_kana_MI" );
	#endif
	#ifdef XKB_KEY_kana_MU
		swigIntConstant( XKB_KEY_kana_MU, "XKB_KEY_kana_MU" );
	#endif
	#ifdef XKB_KEY_kana_ME
		swigIntConstant( XKB_KEY_kana_ME, "XKB_KEY_kana_ME" );
	#endif
	#ifdef XKB_KEY_kana_MO
		swigIntConstant( XKB_KEY_kana_MO, "XKB_KEY_kana_MO" );
	#endif
	#ifdef XKB_KEY_kana_YA
		swigIntConstant( XKB_KEY_kana_YA, "XKB_KEY_kana_YA" );
	#endif
	#ifdef XKB_KEY_kana_YU
		swigIntConstant( XKB_KEY_kana_YU, "XKB_KEY_kana_YU" );
	#endif
	#ifdef XKB_KEY_kana_YO
		swigIntConstant( XKB_KEY_kana_YO, "XKB_KEY_kana_YO" );
	#endif
	#ifdef XKB_KEY_kana_RA
		swigIntConstant( XKB_KEY_kana_RA, "XKB_KEY_kana_RA" );
	#endif
	#ifdef XKB_KEY_kana_RI
		swigIntConstant( XKB_KEY_kana_RI, "XKB_KEY_kana_RI" );
	#endif
	#ifdef XKB_KEY_kana_RU
		swigIntConstant( XKB_KEY_kana_RU, "XKB_KEY_kana_RU" );
	#endif
	#ifdef XKB_KEY_kana_RE
		swigIntConstant( XKB_KEY_kana_RE, "XKB_KEY_kana_RE" );
	#endif
	#ifdef XKB_KEY_kana_RO
		swigIntConstant( XKB_KEY_kana_RO, "XKB_KEY_kana_RO" );
	#endif
	#ifdef XKB_KEY_kana_WA
		swigIntConstant( XKB_KEY_kana_WA, "XKB_KEY_kana_WA" );
	#endif
	#ifdef XKB_KEY_kana_N
		swigIntConstant( XKB_KEY_kana_N, "XKB_KEY_kana_N" );
	#endif
	#ifdef XKB_KEY_voicedsound
		swigIntConstant( XKB_KEY_voicedsound, "XKB_KEY_voicedsound" );
	#endif
	#ifdef XKB_KEY_semivoicedsound
		swigIntConstant( XKB_KEY_semivoicedsound, "XKB_KEY_semivoicedsound" );
	#endif
	#ifdef XKB_KEY_kana_switch
		swigIntConstant( XKB_KEY_kana_switch, "XKB_KEY_kana_switch" );
	#endif
	#ifdef XKB_KEY_Farsi_0
		swigIntConstant( XKB_KEY_Farsi_0, "XKB_KEY_Farsi_0" );
	#endif
	#ifdef XKB_KEY_Farsi_1
		swigIntConstant( XKB_KEY_Farsi_1, "XKB_KEY_Farsi_1" );
	#endif
	#ifdef XKB_KEY_Farsi_2
		swigIntConstant( XKB_KEY_Farsi_2, "XKB_KEY_Farsi_2" );
	#endif
	#ifdef XKB_KEY_Farsi_3
		swigIntConstant( XKB_KEY_Farsi_3, "XKB_KEY_Farsi_3" );
	#endif
	#ifdef XKB_KEY_Farsi_4
		swigIntConstant( XKB_KEY_Farsi_4, "XKB_KEY_Farsi_4" );
	#endif
	#ifdef XKB_KEY_Farsi_5
		swigIntConstant( XKB_KEY_Farsi_5, "XKB_KEY_Farsi_5" );
	#endif
	#ifdef XKB_KEY_Farsi_6
		swigIntConstant( XKB_KEY_Farsi_6, "XKB_KEY_Farsi_6" );
	#endif
	#ifdef XKB_KEY_Farsi_7
		swigIntConstant( XKB_KEY_Farsi_7, "XKB_KEY_Farsi_7" );
	#endif
	#ifdef XKB_KEY_Farsi_8
		swigIntConstant( XKB_KEY_Farsi_8, "XKB_KEY_Farsi_8" );
	#endif
	#ifdef XKB_KEY_Farsi_9
		swigIntConstant( XKB_KEY_Farsi_9, "XKB_KEY_Farsi_9" );
	#endif
	#ifdef XKB_KEY_Arabic_percent
		swigIntConstant( XKB_KEY_Arabic_percent, "XKB_KEY_Arabic_percent" );
	#endif
	#ifdef XKB_KEY_Arabic_superscript_alef
		swigIntConstant( XKB_KEY_Arabic_superscript_alef, "XKB_KEY_Arabic_superscript_alef" );
	#endif
	#ifdef XKB_KEY_Arabic_tteh
		swigIntConstant( XKB_KEY_Arabic_tteh, "XKB_KEY_Arabic_tteh" );
	#endif
	#ifdef XKB_KEY_Arabic_peh
		swigIntConstant( XKB_KEY_Arabic_peh, "XKB_KEY_Arabic_peh" );
	#endif
	#ifdef XKB_KEY_Arabic_tcheh
		swigIntConstant( XKB_KEY_Arabic_tcheh, "XKB_KEY_Arabic_tcheh" );
	#endif
	#ifdef XKB_KEY_Arabic_ddal
		swigIntConstant( XKB_KEY_Arabic_ddal, "XKB_KEY_Arabic_ddal" );
	#endif
	#ifdef XKB_KEY_Arabic_rreh
		swigIntConstant( XKB_KEY_Arabic_rreh, "XKB_KEY_Arabic_rreh" );
	#endif
	#ifdef XKB_KEY_Arabic_comma
		swigIntConstant( XKB_KEY_Arabic_comma, "XKB_KEY_Arabic_comma" );
	#endif
	#ifdef XKB_KEY_Arabic_fullstop
		swigIntConstant( XKB_KEY_Arabic_fullstop, "XKB_KEY_Arabic_fullstop" );
	#endif
	#ifdef XKB_KEY_Arabic_0
		swigIntConstant( XKB_KEY_Arabic_0, "XKB_KEY_Arabic_0" );
	#endif
	#ifdef XKB_KEY_Arabic_1
		swigIntConstant( XKB_KEY_Arabic_1, "XKB_KEY_Arabic_1" );
	#endif
	#ifdef XKB_KEY_Arabic_2
		swigIntConstant( XKB_KEY_Arabic_2, "XKB_KEY_Arabic_2" );
	#endif
	#ifdef XKB_KEY_Arabic_3
		swigIntConstant( XKB_KEY_Arabic_3, "XKB_KEY_Arabic_3" );
	#endif
	#ifdef XKB_KEY_Arabic_4
		swigIntConstant( XKB_KEY_Arabic_4, "XKB_KEY_Arabic_4" );
	#endif
	#ifdef XKB_KEY_Arabic_5
		swigIntConstant( XKB_KEY_Arabic_5, "XKB_KEY_Arabic_5" );
	#endif
	#ifdef XKB_KEY_Arabic_6
		swigIntConstant( XKB_KEY_Arabic_6, "XKB_KEY_Arabic_6" );
	#endif
	#ifdef XKB_KEY_Arabic_7
		swigIntConstant( XKB_KEY_Arabic_7, "XKB_KEY_Arabic_7" );
	#endif
	#ifdef XKB_KEY_Arabic_8
		swigIntConstant( XKB_KEY_Arabic_8, "XKB_KEY_Arabic_8" );
	#endif
	#ifdef XKB_KEY_Arabic_9
		swigIntConstant( XKB_KEY_Arabic_9, "XKB_KEY_Arabic_9" );
	#endif
	#ifdef XKB_KEY_Arabic_semicolon
		swigIntConstant( XKB_KEY_Arabic_semicolon, "XKB_KEY_Arabic_semicolon" );
	#endif
	#ifdef XKB_KEY_Arabic_question_mark
		swigIntConstant( XKB_KEY_Arabic_question_mark, "XKB_KEY_Arabic_question_mark" );
	#endif
	#ifdef XKB_KEY_Arabic_hamza
		swigIntConstant( XKB_KEY_Arabic_hamza, "XKB_KEY_Arabic_hamza" );
	#endif
	#ifdef XKB_KEY_Arabic_maddaonalef
		swigIntConstant( XKB_KEY_Arabic_maddaonalef, "XKB_KEY_Arabic_maddaonalef" );
	#endif
	#ifdef XKB_KEY_Arabic_hamzaonalef
		swigIntConstant( XKB_KEY_Arabic_hamzaonalef, "XKB_KEY_Arabic_hamzaonalef" );
	#endif
	#ifdef XKB_KEY_Arabic_hamzaonwaw
		swigIntConstant( XKB_KEY_Arabic_hamzaonwaw, "XKB_KEY_Arabic_hamzaonwaw" );
	#endif
	#ifdef XKB_KEY_Arabic_hamzaunderalef
		swigIntConstant( XKB_KEY_Arabic_hamzaunderalef, "XKB_KEY_Arabic_hamzaunderalef" );
	#endif
	#ifdef XKB_KEY_Arabic_hamzaonyeh
		swigIntConstant( XKB_KEY_Arabic_hamzaonyeh, "XKB_KEY_Arabic_hamzaonyeh" );
	#endif
	#ifdef XKB_KEY_Arabic_alef
		swigIntConstant( XKB_KEY_Arabic_alef, "XKB_KEY_Arabic_alef" );
	#endif
	#ifdef XKB_KEY_Arabic_beh
		swigIntConstant( XKB_KEY_Arabic_beh, "XKB_KEY_Arabic_beh" );
	#endif
	#ifdef XKB_KEY_Arabic_tehmarbuta
		swigIntConstant( XKB_KEY_Arabic_tehmarbuta, "XKB_KEY_Arabic_tehmarbuta" );
	#endif
	#ifdef XKB_KEY_Arabic_teh
		swigIntConstant( XKB_KEY_Arabic_teh, "XKB_KEY_Arabic_teh" );
	#endif
	#ifdef XKB_KEY_Arabic_theh
		swigIntConstant( XKB_KEY_Arabic_theh, "XKB_KEY_Arabic_theh" );
	#endif
	#ifdef XKB_KEY_Arabic_jeem
		swigIntConstant( XKB_KEY_Arabic_jeem, "XKB_KEY_Arabic_jeem" );
	#endif
	#ifdef XKB_KEY_Arabic_hah
		swigIntConstant( XKB_KEY_Arabic_hah, "XKB_KEY_Arabic_hah" );
	#endif
	#ifdef XKB_KEY_Arabic_khah
		swigIntConstant( XKB_KEY_Arabic_khah, "XKB_KEY_Arabic_khah" );
	#endif
	#ifdef XKB_KEY_Arabic_dal
		swigIntConstant( XKB_KEY_Arabic_dal, "XKB_KEY_Arabic_dal" );
	#endif
	#ifdef XKB_KEY_Arabic_thal
		swigIntConstant( XKB_KEY_Arabic_thal, "XKB_KEY_Arabic_thal" );
	#endif
	#ifdef XKB_KEY_Arabic_ra
		swigIntConstant( XKB_KEY_Arabic_ra, "XKB_KEY_Arabic_ra" );
	#endif
	#ifdef XKB_KEY_Arabic_zain
		swigIntConstant( XKB_KEY_Arabic_zain, "XKB_KEY_Arabic_zain" );
	#endif
	#ifdef XKB_KEY_Arabic_seen
		swigIntConstant( XKB_KEY_Arabic_seen, "XKB_KEY_Arabic_seen" );
	#endif
	#ifdef XKB_KEY_Arabic_sheen
		swigIntConstant( XKB_KEY_Arabic_sheen, "XKB_KEY_Arabic_sheen" );
	#endif
	#ifdef XKB_KEY_Arabic_sad
		swigIntConstant( XKB_KEY_Arabic_sad, "XKB_KEY_Arabic_sad" );
	#endif
	#ifdef XKB_KEY_Arabic_dad
		swigIntConstant( XKB_KEY_Arabic_dad, "XKB_KEY_Arabic_dad" );
	#endif
	#ifdef XKB_KEY_Arabic_tah
		swigIntConstant( XKB_KEY_Arabic_tah, "XKB_KEY_Arabic_tah" );
	#endif
	#ifdef XKB_KEY_Arabic_zah
		swigIntConstant( XKB_KEY_Arabic_zah, "XKB_KEY_Arabic_zah" );
	#endif
	#ifdef XKB_KEY_Arabic_ain
		swigIntConstant( XKB_KEY_Arabic_ain, "XKB_KEY_Arabic_ain" );
	#endif
	#ifdef XKB_KEY_Arabic_ghain
		swigIntConstant( XKB_KEY_Arabic_ghain, "XKB_KEY_Arabic_ghain" );
	#endif
	#ifdef XKB_KEY_Arabic_tatweel
		swigIntConstant( XKB_KEY_Arabic_tatweel, "XKB_KEY_Arabic_tatweel" );
	#endif
	#ifdef XKB_KEY_Arabic_feh
		swigIntConstant( XKB_KEY_Arabic_feh, "XKB_KEY_Arabic_feh" );
	#endif
	#ifdef XKB_KEY_Arabic_qaf
		swigIntConstant( XKB_KEY_Arabic_qaf, "XKB_KEY_Arabic_qaf" );
	#endif
	#ifdef XKB_KEY_Arabic_kaf
		swigIntConstant( XKB_KEY_Arabic_kaf, "XKB_KEY_Arabic_kaf" );
	#endif
	#ifdef XKB_KEY_Arabic_lam
		swigIntConstant( XKB_KEY_Arabic_lam, "XKB_KEY_Arabic_lam" );
	#endif
	#ifdef XKB_KEY_Arabic_meem
		swigIntConstant( XKB_KEY_Arabic_meem, "XKB_KEY_Arabic_meem" );
	#endif
	#ifdef XKB_KEY_Arabic_noon
		swigIntConstant( XKB_KEY_Arabic_noon, "XKB_KEY_Arabic_noon" );
	#endif
	#ifdef XKB_KEY_Arabic_ha
		swigIntConstant( XKB_KEY_Arabic_ha, "XKB_KEY_Arabic_ha" );
	#endif
	#ifdef XKB_KEY_Arabic_heh
		swigIntConstant( XKB_KEY_Arabic_heh, "XKB_KEY_Arabic_heh" );
	#endif
	#ifdef XKB_KEY_Arabic_waw
		swigIntConstant( XKB_KEY_Arabic_waw, "XKB_KEY_Arabic_waw" );
	#endif
	#ifdef XKB_KEY_Arabic_alefmaksura
		swigIntConstant( XKB_KEY_Arabic_alefmaksura, "XKB_KEY_Arabic_alefmaksura" );
	#endif
	#ifdef XKB_KEY_Arabic_yeh
		swigIntConstant( XKB_KEY_Arabic_yeh, "XKB_KEY_Arabic_yeh" );
	#endif
	#ifdef XKB_KEY_Arabic_fathatan
		swigIntConstant( XKB_KEY_Arabic_fathatan, "XKB_KEY_Arabic_fathatan" );
	#endif
	#ifdef XKB_KEY_Arabic_dammatan
		swigIntConstant( XKB_KEY_Arabic_dammatan, "XKB_KEY_Arabic_dammatan" );
	#endif
	#ifdef XKB_KEY_Arabic_kasratan
		swigIntConstant( XKB_KEY_Arabic_kasratan, "XKB_KEY_Arabic_kasratan" );
	#endif
	#ifdef XKB_KEY_Arabic_fatha
		swigIntConstant( XKB_KEY_Arabic_fatha, "XKB_KEY_Arabic_fatha" );
	#endif
	#ifdef XKB_KEY_Arabic_damma
		swigIntConstant( XKB_KEY_Arabic_damma, "XKB_KEY_Arabic_damma" );
	#endif
	#ifdef XKB_KEY_Arabic_kasra
		swigIntConstant( XKB_KEY_Arabic_kasra, "XKB_KEY_Arabic_kasra" );
	#endif
	#ifdef XKB_KEY_Arabic_shadda
		swigIntConstant( XKB_KEY_Arabic_shadda, "XKB_KEY_Arabic_shadda" );
	#endif
	#ifdef XKB_KEY_Arabic_sukun
		swigIntConstant( XKB_KEY_Arabic_sukun, "XKB_KEY_Arabic_sukun" );
	#endif
	#ifdef XKB_KEY_Arabic_madda_above
		swigIntConstant( XKB_KEY_Arabic_madda_above, "XKB_KEY_Arabic_madda_above" );
	#endif
	#ifdef XKB_KEY_Arabic_hamza_above
		swigIntConstant( XKB_KEY_Arabic_hamza_above, "XKB_KEY_Arabic_hamza_above" );
	#endif
	#ifdef XKB_KEY_Arabic_hamza_below
		swigIntConstant( XKB_KEY_Arabic_hamza_below, "XKB_KEY_Arabic_hamza_below" );
	#endif
	#ifdef XKB_KEY_Arabic_jeh
		swigIntConstant( XKB_KEY_Arabic_jeh, "XKB_KEY_Arabic_jeh" );
	#endif
	#ifdef XKB_KEY_Arabic_veh
		swigIntConstant( XKB_KEY_Arabic_veh, "XKB_KEY_Arabic_veh" );
	#endif
	#ifdef XKB_KEY_Arabic_keheh
		swigIntConstant( XKB_KEY_Arabic_keheh, "XKB_KEY_Arabic_keheh" );
	#endif
	#ifdef XKB_KEY_Arabic_gaf
		swigIntConstant( XKB_KEY_Arabic_gaf, "XKB_KEY_Arabic_gaf" );
	#endif
	#ifdef XKB_KEY_Arabic_noon_ghunna
		swigIntConstant( XKB_KEY_Arabic_noon_ghunna, "XKB_KEY_Arabic_noon_ghunna" );
	#endif
	#ifdef XKB_KEY_Arabic_heh_doachashmee
		swigIntConstant( XKB_KEY_Arabic_heh_doachashmee, "XKB_KEY_Arabic_heh_doachashmee" );
	#endif
	#ifdef XKB_KEY_Farsi_yeh
		swigIntConstant( XKB_KEY_Farsi_yeh, "XKB_KEY_Farsi_yeh" );
	#endif
	#ifdef XKB_KEY_Arabic_farsi_yeh
		swigIntConstant( XKB_KEY_Arabic_farsi_yeh, "XKB_KEY_Arabic_farsi_yeh" );
	#endif
	#ifdef XKB_KEY_Arabic_yeh_baree
		swigIntConstant( XKB_KEY_Arabic_yeh_baree, "XKB_KEY_Arabic_yeh_baree" );
	#endif
	#ifdef XKB_KEY_Arabic_heh_goal
		swigIntConstant( XKB_KEY_Arabic_heh_goal, "XKB_KEY_Arabic_heh_goal" );
	#endif
	#ifdef XKB_KEY_Arabic_switch
		swigIntConstant( XKB_KEY_Arabic_switch, "XKB_KEY_Arabic_switch" );
	#endif
	#ifdef XKB_KEY_Cyrillic_GHE_bar
		swigIntConstant( XKB_KEY_Cyrillic_GHE_bar, "XKB_KEY_Cyrillic_GHE_bar" );
	#endif
	#ifdef XKB_KEY_Cyrillic_ghe_bar
		swigIntConstant( XKB_KEY_Cyrillic_ghe_bar, "XKB_KEY_Cyrillic_ghe_bar" );
	#endif
	#ifdef XKB_KEY_Cyrillic_ZHE_descender
		swigIntConstant( XKB_KEY_Cyrillic_ZHE_descender, "XKB_KEY_Cyrillic_ZHE_descender" );
	#endif
	#ifdef XKB_KEY_Cyrillic_zhe_descender
		swigIntConstant( XKB_KEY_Cyrillic_zhe_descender, "XKB_KEY_Cyrillic_zhe_descender" );
	#endif
	#ifdef XKB_KEY_Cyrillic_KA_descender
		swigIntConstant( XKB_KEY_Cyrillic_KA_descender, "XKB_KEY_Cyrillic_KA_descender" );
	#endif
	#ifdef XKB_KEY_Cyrillic_ka_descender
		swigIntConstant( XKB_KEY_Cyrillic_ka_descender, "XKB_KEY_Cyrillic_ka_descender" );
	#endif
	#ifdef XKB_KEY_Cyrillic_KA_vertstroke
		swigIntConstant( XKB_KEY_Cyrillic_KA_vertstroke, "XKB_KEY_Cyrillic_KA_vertstroke" );
	#endif
	#ifdef XKB_KEY_Cyrillic_ka_vertstroke
		swigIntConstant( XKB_KEY_Cyrillic_ka_vertstroke, "XKB_KEY_Cyrillic_ka_vertstroke" );
	#endif
	#ifdef XKB_KEY_Cyrillic_EN_descender
		swigIntConstant( XKB_KEY_Cyrillic_EN_descender, "XKB_KEY_Cyrillic_EN_descender" );
	#endif
	#ifdef XKB_KEY_Cyrillic_en_descender
		swigIntConstant( XKB_KEY_Cyrillic_en_descender, "XKB_KEY_Cyrillic_en_descender" );
	#endif
	#ifdef XKB_KEY_Cyrillic_U_straight
		swigIntConstant( XKB_KEY_Cyrillic_U_straight, "XKB_KEY_Cyrillic_U_straight" );
	#endif
	#ifdef XKB_KEY_Cyrillic_u_straight
		swigIntConstant( XKB_KEY_Cyrillic_u_straight, "XKB_KEY_Cyrillic_u_straight" );
	#endif
	#ifdef XKB_KEY_Cyrillic_U_straight_bar
		swigIntConstant( XKB_KEY_Cyrillic_U_straight_bar, "XKB_KEY_Cyrillic_U_straight_bar" );
	#endif
	#ifdef XKB_KEY_Cyrillic_u_straight_bar
		swigIntConstant( XKB_KEY_Cyrillic_u_straight_bar, "XKB_KEY_Cyrillic_u_straight_bar" );
	#endif
	#ifdef XKB_KEY_Cyrillic_HA_descender
		swigIntConstant( XKB_KEY_Cyrillic_HA_descender, "XKB_KEY_Cyrillic_HA_descender" );
	#endif
	#ifdef XKB_KEY_Cyrillic_ha_descender
		swigIntConstant( XKB_KEY_Cyrillic_ha_descender, "XKB_KEY_Cyrillic_ha_descender" );
	#endif
	#ifdef XKB_KEY_Cyrillic_CHE_descender
		swigIntConstant( XKB_KEY_Cyrillic_CHE_descender, "XKB_KEY_Cyrillic_CHE_descender" );
	#endif
	#ifdef XKB_KEY_Cyrillic_che_descender
		swigIntConstant( XKB_KEY_Cyrillic_che_descender, "XKB_KEY_Cyrillic_che_descender" );
	#endif
	#ifdef XKB_KEY_Cyrillic_CHE_vertstroke
		swigIntConstant( XKB_KEY_Cyrillic_CHE_vertstroke, "XKB_KEY_Cyrillic_CHE_vertstroke" );
	#endif
	#ifdef XKB_KEY_Cyrillic_che_vertstroke
		swigIntConstant( XKB_KEY_Cyrillic_che_vertstroke, "XKB_KEY_Cyrillic_che_vertstroke" );
	#endif
	#ifdef XKB_KEY_Cyrillic_SHHA
		swigIntConstant( XKB_KEY_Cyrillic_SHHA, "XKB_KEY_Cyrillic_SHHA" );
	#endif
	#ifdef XKB_KEY_Cyrillic_shha
		swigIntConstant( XKB_KEY_Cyrillic_shha, "XKB_KEY_Cyrillic_shha" );
	#endif
	#ifdef XKB_KEY_Cyrillic_SCHWA
		swigIntConstant( XKB_KEY_Cyrillic_SCHWA, "XKB_KEY_Cyrillic_SCHWA" );
	#endif
	#ifdef XKB_KEY_Cyrillic_schwa
		swigIntConstant( XKB_KEY_Cyrillic_schwa, "XKB_KEY_Cyrillic_schwa" );
	#endif
	#ifdef XKB_KEY_Cyrillic_I_macron
		swigIntConstant( XKB_KEY_Cyrillic_I_macron, "XKB_KEY_Cyrillic_I_macron" );
	#endif
	#ifdef XKB_KEY_Cyrillic_i_macron
		swigIntConstant( XKB_KEY_Cyrillic_i_macron, "XKB_KEY_Cyrillic_i_macron" );
	#endif
	#ifdef XKB_KEY_Cyrillic_O_bar
		swigIntConstant( XKB_KEY_Cyrillic_O_bar, "XKB_KEY_Cyrillic_O_bar" );
	#endif
	#ifdef XKB_KEY_Cyrillic_o_bar
		swigIntConstant( XKB_KEY_Cyrillic_o_bar, "XKB_KEY_Cyrillic_o_bar" );
	#endif
	#ifdef XKB_KEY_Cyrillic_U_macron
		swigIntConstant( XKB_KEY_Cyrillic_U_macron, "XKB_KEY_Cyrillic_U_macron" );
	#endif
	#ifdef XKB_KEY_Cyrillic_u_macron
		swigIntConstant( XKB_KEY_Cyrillic_u_macron, "XKB_KEY_Cyrillic_u_macron" );
	#endif
	#ifdef XKB_KEY_Serbian_dje
		swigIntConstant( XKB_KEY_Serbian_dje, "XKB_KEY_Serbian_dje" );
	#endif
	#ifdef XKB_KEY_Macedonia_gje
		swigIntConstant( XKB_KEY_Macedonia_gje, "XKB_KEY_Macedonia_gje" );
	#endif
	#ifdef XKB_KEY_Cyrillic_io
		swigIntConstant( XKB_KEY_Cyrillic_io, "XKB_KEY_Cyrillic_io" );
	#endif
	#ifdef XKB_KEY_Ukrainian_ie
		swigIntConstant( XKB_KEY_Ukrainian_ie, "XKB_KEY_Ukrainian_ie" );
	#endif
	#ifdef XKB_KEY_Ukranian_je
		swigIntConstant( XKB_KEY_Ukranian_je, "XKB_KEY_Ukranian_je" );
	#endif
	#ifdef XKB_KEY_Macedonia_dse
		swigIntConstant( XKB_KEY_Macedonia_dse, "XKB_KEY_Macedonia_dse" );
	#endif
	#ifdef XKB_KEY_Ukrainian_i
		swigIntConstant( XKB_KEY_Ukrainian_i, "XKB_KEY_Ukrainian_i" );
	#endif
	#ifdef XKB_KEY_Ukranian_i
		swigIntConstant( XKB_KEY_Ukranian_i, "XKB_KEY_Ukranian_i" );
	#endif
	#ifdef XKB_KEY_Ukrainian_yi
		swigIntConstant( XKB_KEY_Ukrainian_yi, "XKB_KEY_Ukrainian_yi" );
	#endif
	#ifdef XKB_KEY_Ukranian_yi
		swigIntConstant( XKB_KEY_Ukranian_yi, "XKB_KEY_Ukranian_yi" );
	#endif
	#ifdef XKB_KEY_Cyrillic_je
		swigIntConstant( XKB_KEY_Cyrillic_je, "XKB_KEY_Cyrillic_je" );
	#endif
	#ifdef XKB_KEY_Serbian_je
		swigIntConstant( XKB_KEY_Serbian_je, "XKB_KEY_Serbian_je" );
	#endif
	#ifdef XKB_KEY_Cyrillic_lje
		swigIntConstant( XKB_KEY_Cyrillic_lje, "XKB_KEY_Cyrillic_lje" );
	#endif
	#ifdef XKB_KEY_Serbian_lje
		swigIntConstant( XKB_KEY_Serbian_lje, "XKB_KEY_Serbian_lje" );
	#endif
	#ifdef XKB_KEY_Cyrillic_nje
		swigIntConstant( XKB_KEY_Cyrillic_nje, "XKB_KEY_Cyrillic_nje" );
	#endif
	#ifdef XKB_KEY_Serbian_nje
		swigIntConstant( XKB_KEY_Serbian_nje, "XKB_KEY_Serbian_nje" );
	#endif
	#ifdef XKB_KEY_Serbian_tshe
		swigIntConstant( XKB_KEY_Serbian_tshe, "XKB_KEY_Serbian_tshe" );
	#endif
	#ifdef XKB_KEY_Macedonia_kje
		swigIntConstant( XKB_KEY_Macedonia_kje, "XKB_KEY_Macedonia_kje" );
	#endif
	#ifdef XKB_KEY_Ukrainian_ghe_with_upturn
		swigIntConstant( XKB_KEY_Ukrainian_ghe_with_upturn, "XKB_KEY_Ukrainian_ghe_with_upturn" );
	#endif
	#ifdef XKB_KEY_Byelorussian_shortu
		swigIntConstant( XKB_KEY_Byelorussian_shortu, "XKB_KEY_Byelorussian_shortu" );
	#endif
	#ifdef XKB_KEY_Cyrillic_dzhe
		swigIntConstant( XKB_KEY_Cyrillic_dzhe, "XKB_KEY_Cyrillic_dzhe" );
	#endif
	#ifdef XKB_KEY_Serbian_dze
		swigIntConstant( XKB_KEY_Serbian_dze, "XKB_KEY_Serbian_dze" );
	#endif
	#ifdef XKB_KEY_numerosign
		swigIntConstant( XKB_KEY_numerosign, "XKB_KEY_numerosign" );
	#endif
	#ifdef XKB_KEY_Serbian_DJE
		swigIntConstant( XKB_KEY_Serbian_DJE, "XKB_KEY_Serbian_DJE" );
	#endif
	#ifdef XKB_KEY_Macedonia_GJE
		swigIntConstant( XKB_KEY_Macedonia_GJE, "XKB_KEY_Macedonia_GJE" );
	#endif
	#ifdef XKB_KEY_Cyrillic_IO
		swigIntConstant( XKB_KEY_Cyrillic_IO, "XKB_KEY_Cyrillic_IO" );
	#endif
	#ifdef XKB_KEY_Ukrainian_IE
		swigIntConstant( XKB_KEY_Ukrainian_IE, "XKB_KEY_Ukrainian_IE" );
	#endif
	#ifdef XKB_KEY_Ukranian_JE
		swigIntConstant( XKB_KEY_Ukranian_JE, "XKB_KEY_Ukranian_JE" );
	#endif
	#ifdef XKB_KEY_Macedonia_DSE
		swigIntConstant( XKB_KEY_Macedonia_DSE, "XKB_KEY_Macedonia_DSE" );
	#endif
	#ifdef XKB_KEY_Ukrainian_I
		swigIntConstant( XKB_KEY_Ukrainian_I, "XKB_KEY_Ukrainian_I" );
	#endif
	#ifdef XKB_KEY_Ukranian_I
		swigIntConstant( XKB_KEY_Ukranian_I, "XKB_KEY_Ukranian_I" );
	#endif
	#ifdef XKB_KEY_Ukrainian_YI
		swigIntConstant( XKB_KEY_Ukrainian_YI, "XKB_KEY_Ukrainian_YI" );
	#endif
	#ifdef XKB_KEY_Ukranian_YI
		swigIntConstant( XKB_KEY_Ukranian_YI, "XKB_KEY_Ukranian_YI" );
	#endif
	#ifdef XKB_KEY_Cyrillic_JE
		swigIntConstant( XKB_KEY_Cyrillic_JE, "XKB_KEY_Cyrillic_JE" );
	#endif
	#ifdef XKB_KEY_Serbian_JE
		swigIntConstant( XKB_KEY_Serbian_JE, "XKB_KEY_Serbian_JE" );
	#endif
	#ifdef XKB_KEY_Cyrillic_LJE
		swigIntConstant( XKB_KEY_Cyrillic_LJE, "XKB_KEY_Cyrillic_LJE" );
	#endif
	#ifdef XKB_KEY_Serbian_LJE
		swigIntConstant( XKB_KEY_Serbian_LJE, "XKB_KEY_Serbian_LJE" );
	#endif
	#ifdef XKB_KEY_Cyrillic_NJE
		swigIntConstant( XKB_KEY_Cyrillic_NJE, "XKB_KEY_Cyrillic_NJE" );
	#endif
	#ifdef XKB_KEY_Serbian_NJE
		swigIntConstant( XKB_KEY_Serbian_NJE, "XKB_KEY_Serbian_NJE" );
	#endif
	#ifdef XKB_KEY_Serbian_TSHE
		swigIntConstant( XKB_KEY_Serbian_TSHE, "XKB_KEY_Serbian_TSHE" );
	#endif
	#ifdef XKB_KEY_Macedonia_KJE
		swigIntConstant( XKB_KEY_Macedonia_KJE, "XKB_KEY_Macedonia_KJE" );
	#endif
	#ifdef XKB_KEY_Ukrainian_GHE_WITH_UPTURN
		swigIntConstant( XKB_KEY_Ukrainian_GHE_WITH_UPTURN, "XKB_KEY_Ukrainian_GHE_WITH_UPTURN" );
	#endif
	#ifdef XKB_KEY_Byelorussian_SHORTU
		swigIntConstant( XKB_KEY_Byelorussian_SHORTU, "XKB_KEY_Byelorussian_SHORTU" );
	#endif
	#ifdef XKB_KEY_Cyrillic_DZHE
		swigIntConstant( XKB_KEY_Cyrillic_DZHE, "XKB_KEY_Cyrillic_DZHE" );
	#endif
	#ifdef XKB_KEY_Serbian_DZE
		swigIntConstant( XKB_KEY_Serbian_DZE, "XKB_KEY_Serbian_DZE" );
	#endif
	#ifdef XKB_KEY_Cyrillic_yu
		swigIntConstant( XKB_KEY_Cyrillic_yu, "XKB_KEY_Cyrillic_yu" );
	#endif
	#ifdef XKB_KEY_Cyrillic_a
		swigIntConstant( XKB_KEY_Cyrillic_a, "XKB_KEY_Cyrillic_a" );
	#endif
	#ifdef XKB_KEY_Cyrillic_be
		swigIntConstant( XKB_KEY_Cyrillic_be, "XKB_KEY_Cyrillic_be" );
	#endif
	#ifdef XKB_KEY_Cyrillic_tse
		swigIntConstant( XKB_KEY_Cyrillic_tse, "XKB_KEY_Cyrillic_tse" );
	#endif
	#ifdef XKB_KEY_Cyrillic_de
		swigIntConstant( XKB_KEY_Cyrillic_de, "XKB_KEY_Cyrillic_de" );
	#endif
	#ifdef XKB_KEY_Cyrillic_ie
		swigIntConstant( XKB_KEY_Cyrillic_ie, "XKB_KEY_Cyrillic_ie" );
	#endif
	#ifdef XKB_KEY_Cyrillic_ef
		swigIntConstant( XKB_KEY_Cyrillic_ef, "XKB_KEY_Cyrillic_ef" );
	#endif
	#ifdef XKB_KEY_Cyrillic_ghe
		swigIntConstant( XKB_KEY_Cyrillic_ghe, "XKB_KEY_Cyrillic_ghe" );
	#endif
	#ifdef XKB_KEY_Cyrillic_ha
		swigIntConstant( XKB_KEY_Cyrillic_ha, "XKB_KEY_Cyrillic_ha" );
	#endif
	#ifdef XKB_KEY_Cyrillic_i
		swigIntConstant( XKB_KEY_Cyrillic_i, "XKB_KEY_Cyrillic_i" );
	#endif
	#ifdef XKB_KEY_Cyrillic_shorti
		swigIntConstant( XKB_KEY_Cyrillic_shorti, "XKB_KEY_Cyrillic_shorti" );
	#endif
	#ifdef XKB_KEY_Cyrillic_ka
		swigIntConstant( XKB_KEY_Cyrillic_ka, "XKB_KEY_Cyrillic_ka" );
	#endif
	#ifdef XKB_KEY_Cyrillic_el
		swigIntConstant( XKB_KEY_Cyrillic_el, "XKB_KEY_Cyrillic_el" );
	#endif
	#ifdef XKB_KEY_Cyrillic_em
		swigIntConstant( XKB_KEY_Cyrillic_em, "XKB_KEY_Cyrillic_em" );
	#endif
	#ifdef XKB_KEY_Cyrillic_en
		swigIntConstant( XKB_KEY_Cyrillic_en, "XKB_KEY_Cyrillic_en" );
	#endif
	#ifdef XKB_KEY_Cyrillic_o
		swigIntConstant( XKB_KEY_Cyrillic_o, "XKB_KEY_Cyrillic_o" );
	#endif
	#ifdef XKB_KEY_Cyrillic_pe
		swigIntConstant( XKB_KEY_Cyrillic_pe, "XKB_KEY_Cyrillic_pe" );
	#endif
	#ifdef XKB_KEY_Cyrillic_ya
		swigIntConstant( XKB_KEY_Cyrillic_ya, "XKB_KEY_Cyrillic_ya" );
	#endif
	#ifdef XKB_KEY_Cyrillic_er
		swigIntConstant( XKB_KEY_Cyrillic_er, "XKB_KEY_Cyrillic_er" );
	#endif
	#ifdef XKB_KEY_Cyrillic_es
		swigIntConstant( XKB_KEY_Cyrillic_es, "XKB_KEY_Cyrillic_es" );
	#endif
	#ifdef XKB_KEY_Cyrillic_te
		swigIntConstant( XKB_KEY_Cyrillic_te, "XKB_KEY_Cyrillic_te" );
	#endif
	#ifdef XKB_KEY_Cyrillic_u
		swigIntConstant( XKB_KEY_Cyrillic_u, "XKB_KEY_Cyrillic_u" );
	#endif
	#ifdef XKB_KEY_Cyrillic_zhe
		swigIntConstant( XKB_KEY_Cyrillic_zhe, "XKB_KEY_Cyrillic_zhe" );
	#endif
	#ifdef XKB_KEY_Cyrillic_ve
		swigIntConstant( XKB_KEY_Cyrillic_ve, "XKB_KEY_Cyrillic_ve" );
	#endif
	#ifdef XKB_KEY_Cyrillic_softsign
		swigIntConstant( XKB_KEY_Cyrillic_softsign, "XKB_KEY_Cyrillic_softsign" );
	#endif
	#ifdef XKB_KEY_Cyrillic_yeru
		swigIntConstant( XKB_KEY_Cyrillic_yeru, "XKB_KEY_Cyrillic_yeru" );
	#endif
	#ifdef XKB_KEY_Cyrillic_ze
		swigIntConstant( XKB_KEY_Cyrillic_ze, "XKB_KEY_Cyrillic_ze" );
	#endif
	#ifdef XKB_KEY_Cyrillic_sha
		swigIntConstant( XKB_KEY_Cyrillic_sha, "XKB_KEY_Cyrillic_sha" );
	#endif
	#ifdef XKB_KEY_Cyrillic_e
		swigIntConstant( XKB_KEY_Cyrillic_e, "XKB_KEY_Cyrillic_e" );
	#endif
	#ifdef XKB_KEY_Cyrillic_shcha
		swigIntConstant( XKB_KEY_Cyrillic_shcha, "XKB_KEY_Cyrillic_shcha" );
	#endif
	#ifdef XKB_KEY_Cyrillic_che
		swigIntConstant( XKB_KEY_Cyrillic_che, "XKB_KEY_Cyrillic_che" );
	#endif
	#ifdef XKB_KEY_Cyrillic_hardsign
		swigIntConstant( XKB_KEY_Cyrillic_hardsign, "XKB_KEY_Cyrillic_hardsign" );
	#endif
	#ifdef XKB_KEY_Cyrillic_YU
		swigIntConstant( XKB_KEY_Cyrillic_YU, "XKB_KEY_Cyrillic_YU" );
	#endif
	#ifdef XKB_KEY_Cyrillic_A
		swigIntConstant( XKB_KEY_Cyrillic_A, "XKB_KEY_Cyrillic_A" );
	#endif
	#ifdef XKB_KEY_Cyrillic_BE
		swigIntConstant( XKB_KEY_Cyrillic_BE, "XKB_KEY_Cyrillic_BE" );
	#endif
	#ifdef XKB_KEY_Cyrillic_TSE
		swigIntConstant( XKB_KEY_Cyrillic_TSE, "XKB_KEY_Cyrillic_TSE" );
	#endif
	#ifdef XKB_KEY_Cyrillic_DE
		swigIntConstant( XKB_KEY_Cyrillic_DE, "XKB_KEY_Cyrillic_DE" );
	#endif
	#ifdef XKB_KEY_Cyrillic_IE
		swigIntConstant( XKB_KEY_Cyrillic_IE, "XKB_KEY_Cyrillic_IE" );
	#endif
	#ifdef XKB_KEY_Cyrillic_EF
		swigIntConstant( XKB_KEY_Cyrillic_EF, "XKB_KEY_Cyrillic_EF" );
	#endif
	#ifdef XKB_KEY_Cyrillic_GHE
		swigIntConstant( XKB_KEY_Cyrillic_GHE, "XKB_KEY_Cyrillic_GHE" );
	#endif
	#ifdef XKB_KEY_Cyrillic_HA
		swigIntConstant( XKB_KEY_Cyrillic_HA, "XKB_KEY_Cyrillic_HA" );
	#endif
	#ifdef XKB_KEY_Cyrillic_I
		swigIntConstant( XKB_KEY_Cyrillic_I, "XKB_KEY_Cyrillic_I" );
	#endif
	#ifdef XKB_KEY_Cyrillic_SHORTI
		swigIntConstant( XKB_KEY_Cyrillic_SHORTI, "XKB_KEY_Cyrillic_SHORTI" );
	#endif
	#ifdef XKB_KEY_Cyrillic_KA
		swigIntConstant( XKB_KEY_Cyrillic_KA, "XKB_KEY_Cyrillic_KA" );
	#endif
	#ifdef XKB_KEY_Cyrillic_EL
		swigIntConstant( XKB_KEY_Cyrillic_EL, "XKB_KEY_Cyrillic_EL" );
	#endif
	#ifdef XKB_KEY_Cyrillic_EM
		swigIntConstant( XKB_KEY_Cyrillic_EM, "XKB_KEY_Cyrillic_EM" );
	#endif
	#ifdef XKB_KEY_Cyrillic_EN
		swigIntConstant( XKB_KEY_Cyrillic_EN, "XKB_KEY_Cyrillic_EN" );
	#endif
	#ifdef XKB_KEY_Cyrillic_O
		swigIntConstant( XKB_KEY_Cyrillic_O, "XKB_KEY_Cyrillic_O" );
	#endif
	#ifdef XKB_KEY_Cyrillic_PE
		swigIntConstant( XKB_KEY_Cyrillic_PE, "XKB_KEY_Cyrillic_PE" );
	#endif
	#ifdef XKB_KEY_Cyrillic_YA
		swigIntConstant( XKB_KEY_Cyrillic_YA, "XKB_KEY_Cyrillic_YA" );
	#endif
	#ifdef XKB_KEY_Cyrillic_ER
		swigIntConstant( XKB_KEY_Cyrillic_ER, "XKB_KEY_Cyrillic_ER" );
	#endif
	#ifdef XKB_KEY_Cyrillic_ES
		swigIntConstant( XKB_KEY_Cyrillic_ES, "XKB_KEY_Cyrillic_ES" );
	#endif
	#ifdef XKB_KEY_Cyrillic_TE
		swigIntConstant( XKB_KEY_Cyrillic_TE, "XKB_KEY_Cyrillic_TE" );
	#endif
	#ifdef XKB_KEY_Cyrillic_U
		swigIntConstant( XKB_KEY_Cyrillic_U, "XKB_KEY_Cyrillic_U" );
	#endif
	#ifdef XKB_KEY_Cyrillic_ZHE
		swigIntConstant( XKB_KEY_Cyrillic_ZHE, "XKB_KEY_Cyrillic_ZHE" );
	#endif
	#ifdef XKB_KEY_Cyrillic_VE
		swigIntConstant( XKB_KEY_Cyrillic_VE, "XKB_KEY_Cyrillic_VE" );
	#endif
	#ifdef XKB_KEY_Cyrillic_SOFTSIGN
		swigIntConstant( XKB_KEY_Cyrillic_SOFTSIGN, "XKB_KEY_Cyrillic_SOFTSIGN" );
	#endif
	#ifdef XKB_KEY_Cyrillic_YERU
		swigIntConstant( XKB_KEY_Cyrillic_YERU, "XKB_KEY_Cyrillic_YERU" );
	#endif
	#ifdef XKB_KEY_Cyrillic_ZE
		swigIntConstant( XKB_KEY_Cyrillic_ZE, "XKB_KEY_Cyrillic_ZE" );
	#endif
	#ifdef XKB_KEY_Cyrillic_SHA
		swigIntConstant( XKB_KEY_Cyrillic_SHA, "XKB_KEY_Cyrillic_SHA" );
	#endif
	#ifdef XKB_KEY_Cyrillic_E
		swigIntConstant( XKB_KEY_Cyrillic_E, "XKB_KEY_Cyrillic_E" );
	#endif
	#ifdef XKB_KEY_Cyrillic_SHCHA
		swigIntConstant( XKB_KEY_Cyrillic_SHCHA, "XKB_KEY_Cyrillic_SHCHA" );
	#endif
	#ifdef XKB_KEY_Cyrillic_CHE
		swigIntConstant( XKB_KEY_Cyrillic_CHE, "XKB_KEY_Cyrillic_CHE" );
	#endif
	#ifdef XKB_KEY_Cyrillic_HARDSIGN
		swigIntConstant( XKB_KEY_Cyrillic_HARDSIGN, "XKB_KEY_Cyrillic_HARDSIGN" );
	#endif
	#ifdef XKB_KEY_Greek_ALPHAaccent
		swigIntConstant( XKB_KEY_Greek_ALPHAaccent, "XKB_KEY_Greek_ALPHAaccent" );
	#endif
	#ifdef XKB_KEY_Greek_EPSILONaccent
		swigIntConstant( XKB_KEY_Greek_EPSILONaccent, "XKB_KEY_Greek_EPSILONaccent" );
	#endif
	#ifdef XKB_KEY_Greek_ETAaccent
		swigIntConstant( XKB_KEY_Greek_ETAaccent, "XKB_KEY_Greek_ETAaccent" );
	#endif
	#ifdef XKB_KEY_Greek_IOTAaccent
		swigIntConstant( XKB_KEY_Greek_IOTAaccent, "XKB_KEY_Greek_IOTAaccent" );
	#endif
	#ifdef XKB_KEY_Greek_IOTAdieresis
		swigIntConstant( XKB_KEY_Greek_IOTAdieresis, "XKB_KEY_Greek_IOTAdieresis" );
	#endif
	#ifdef XKB_KEY_Greek_IOTAdiaeresis
		swigIntConstant( XKB_KEY_Greek_IOTAdiaeresis, "XKB_KEY_Greek_IOTAdiaeresis" );
	#endif
	#ifdef XKB_KEY_Greek_OMICRONaccent
		swigIntConstant( XKB_KEY_Greek_OMICRONaccent, "XKB_KEY_Greek_OMICRONaccent" );
	#endif
	#ifdef XKB_KEY_Greek_UPSILONaccent
		swigIntConstant( XKB_KEY_Greek_UPSILONaccent, "XKB_KEY_Greek_UPSILONaccent" );
	#endif
	#ifdef XKB_KEY_Greek_UPSILONdieresis
		swigIntConstant( XKB_KEY_Greek_UPSILONdieresis, "XKB_KEY_Greek_UPSILONdieresis" );
	#endif
	#ifdef XKB_KEY_Greek_OMEGAaccent
		swigIntConstant( XKB_KEY_Greek_OMEGAaccent, "XKB_KEY_Greek_OMEGAaccent" );
	#endif
	#ifdef XKB_KEY_Greek_accentdieresis
		swigIntConstant( XKB_KEY_Greek_accentdieresis, "XKB_KEY_Greek_accentdieresis" );
	#endif
	#ifdef XKB_KEY_Greek_horizbar
		swigIntConstant( XKB_KEY_Greek_horizbar, "XKB_KEY_Greek_horizbar" );
	#endif
	#ifdef XKB_KEY_Greek_alphaaccent
		swigIntConstant( XKB_KEY_Greek_alphaaccent, "XKB_KEY_Greek_alphaaccent" );
	#endif
	#ifdef XKB_KEY_Greek_epsilonaccent
		swigIntConstant( XKB_KEY_Greek_epsilonaccent, "XKB_KEY_Greek_epsilonaccent" );
	#endif
	#ifdef XKB_KEY_Greek_etaaccent
		swigIntConstant( XKB_KEY_Greek_etaaccent, "XKB_KEY_Greek_etaaccent" );
	#endif
	#ifdef XKB_KEY_Greek_iotaaccent
		swigIntConstant( XKB_KEY_Greek_iotaaccent, "XKB_KEY_Greek_iotaaccent" );
	#endif
	#ifdef XKB_KEY_Greek_iotadieresis
		swigIntConstant( XKB_KEY_Greek_iotadieresis, "XKB_KEY_Greek_iotadieresis" );
	#endif
	#ifdef XKB_KEY_Greek_iotaaccentdieresis
		swigIntConstant( XKB_KEY_Greek_iotaaccentdieresis, "XKB_KEY_Greek_iotaaccentdieresis" );
	#endif
	#ifdef XKB_KEY_Greek_omicronaccent
		swigIntConstant( XKB_KEY_Greek_omicronaccent, "XKB_KEY_Greek_omicronaccent" );
	#endif
	#ifdef XKB_KEY_Greek_upsilonaccent
		swigIntConstant( XKB_KEY_Greek_upsilonaccent, "XKB_KEY_Greek_upsilonaccent" );
	#endif
	#ifdef XKB_KEY_Greek_upsilondieresis
		swigIntConstant( XKB_KEY_Greek_upsilondieresis, "XKB_KEY_Greek_upsilondieresis" );
	#endif
	#ifdef XKB_KEY_Greek_upsilonaccentdieresis
		swigIntConstant( XKB_KEY_Greek_upsilonaccentdieresis, "XKB_KEY_Greek_upsilonaccentdieresis" );
	#endif
	#ifdef XKB_KEY_Greek_omegaaccent
		swigIntConstant( XKB_KEY_Greek_omegaaccent, "XKB_KEY_Greek_omegaaccent" );
	#endif
	#ifdef XKB_KEY_Greek_ALPHA
		swigIntConstant( XKB_KEY_Greek_ALPHA, "XKB_KEY_Greek_ALPHA" );
	#endif
	#ifdef XKB_KEY_Greek_BETA
		swigIntConstant( XKB_KEY_Greek_BETA, "XKB_KEY_Greek_BETA" );
	#endif
	#ifdef XKB_KEY_Greek_GAMMA
		swigIntConstant( XKB_KEY_Greek_GAMMA, "XKB_KEY_Greek_GAMMA" );
	#endif
	#ifdef XKB_KEY_Greek_DELTA
		swigIntConstant( XKB_KEY_Greek_DELTA, "XKB_KEY_Greek_DELTA" );
	#endif
	#ifdef XKB_KEY_Greek_EPSILON
		swigIntConstant( XKB_KEY_Greek_EPSILON, "XKB_KEY_Greek_EPSILON" );
	#endif
	#ifdef XKB_KEY_Greek_ZETA
		swigIntConstant( XKB_KEY_Greek_ZETA, "XKB_KEY_Greek_ZETA" );
	#endif
	#ifdef XKB_KEY_Greek_ETA
		swigIntConstant( XKB_KEY_Greek_ETA, "XKB_KEY_Greek_ETA" );
	#endif
	#ifdef XKB_KEY_Greek_THETA
		swigIntConstant( XKB_KEY_Greek_THETA, "XKB_KEY_Greek_THETA" );
	#endif
	#ifdef XKB_KEY_Greek_IOTA
		swigIntConstant( XKB_KEY_Greek_IOTA, "XKB_KEY_Greek_IOTA" );
	#endif
	#ifdef XKB_KEY_Greek_KAPPA
		swigIntConstant( XKB_KEY_Greek_KAPPA, "XKB_KEY_Greek_KAPPA" );
	#endif
	#ifdef XKB_KEY_Greek_LAMDA
		swigIntConstant( XKB_KEY_Greek_LAMDA, "XKB_KEY_Greek_LAMDA" );
	#endif
	#ifdef XKB_KEY_Greek_LAMBDA
		swigIntConstant( XKB_KEY_Greek_LAMBDA, "XKB_KEY_Greek_LAMBDA" );
	#endif
	#ifdef XKB_KEY_Greek_MU
		swigIntConstant( XKB_KEY_Greek_MU, "XKB_KEY_Greek_MU" );
	#endif
	#ifdef XKB_KEY_Greek_NU
		swigIntConstant( XKB_KEY_Greek_NU, "XKB_KEY_Greek_NU" );
	#endif
	#ifdef XKB_KEY_Greek_XI
		swigIntConstant( XKB_KEY_Greek_XI, "XKB_KEY_Greek_XI" );
	#endif
	#ifdef XKB_KEY_Greek_OMICRON
		swigIntConstant( XKB_KEY_Greek_OMICRON, "XKB_KEY_Greek_OMICRON" );
	#endif
	#ifdef XKB_KEY_Greek_PI
		swigIntConstant( XKB_KEY_Greek_PI, "XKB_KEY_Greek_PI" );
	#endif
	#ifdef XKB_KEY_Greek_RHO
		swigIntConstant( XKB_KEY_Greek_RHO, "XKB_KEY_Greek_RHO" );
	#endif
	#ifdef XKB_KEY_Greek_SIGMA
		swigIntConstant( XKB_KEY_Greek_SIGMA, "XKB_KEY_Greek_SIGMA" );
	#endif
	#ifdef XKB_KEY_Greek_TAU
		swigIntConstant( XKB_KEY_Greek_TAU, "XKB_KEY_Greek_TAU" );
	#endif
	#ifdef XKB_KEY_Greek_UPSILON
		swigIntConstant( XKB_KEY_Greek_UPSILON, "XKB_KEY_Greek_UPSILON" );
	#endif
	#ifdef XKB_KEY_Greek_PHI
		swigIntConstant( XKB_KEY_Greek_PHI, "XKB_KEY_Greek_PHI" );
	#endif
	#ifdef XKB_KEY_Greek_CHI
		swigIntConstant( XKB_KEY_Greek_CHI, "XKB_KEY_Greek_CHI" );
	#endif
	#ifdef XKB_KEY_Greek_PSI
		swigIntConstant( XKB_KEY_Greek_PSI, "XKB_KEY_Greek_PSI" );
	#endif
	#ifdef XKB_KEY_Greek_OMEGA
		swigIntConstant( XKB_KEY_Greek_OMEGA, "XKB_KEY_Greek_OMEGA" );
	#endif
	#ifdef XKB_KEY_Greek_alpha
		swigIntConstant( XKB_KEY_Greek_alpha, "XKB_KEY_Greek_alpha" );
	#endif
	#ifdef XKB_KEY_Greek_beta
		swigIntConstant( XKB_KEY_Greek_beta, "XKB_KEY_Greek_beta" );
	#endif
	#ifdef XKB_KEY_Greek_gamma
		swigIntConstant( XKB_KEY_Greek_gamma, "XKB_KEY_Greek_gamma" );
	#endif
	#ifdef XKB_KEY_Greek_delta
		swigIntConstant( XKB_KEY_Greek_delta, "XKB_KEY_Greek_delta" );
	#endif
	#ifdef XKB_KEY_Greek_epsilon
		swigIntConstant( XKB_KEY_Greek_epsilon, "XKB_KEY_Greek_epsilon" );
	#endif
	#ifdef XKB_KEY_Greek_zeta
		swigIntConstant( XKB_KEY_Greek_zeta, "XKB_KEY_Greek_zeta" );
	#endif
	#ifdef XKB_KEY_Greek_eta
		swigIntConstant( XKB_KEY_Greek_eta, "XKB_KEY_Greek_eta" );
	#endif
	#ifdef XKB_KEY_Greek_theta
		swigIntConstant( XKB_KEY_Greek_theta, "XKB_KEY_Greek_theta" );
	#endif
	#ifdef XKB_KEY_Greek_iota
		swigIntConstant( XKB_KEY_Greek_iota, "XKB_KEY_Greek_iota" );
	#endif
	#ifdef XKB_KEY_Greek_kappa
		swigIntConstant( XKB_KEY_Greek_kappa, "XKB_KEY_Greek_kappa" );
	#endif
	#ifdef XKB_KEY_Greek_lamda
		swigIntConstant( XKB_KEY_Greek_lamda, "XKB_KEY_Greek_lamda" );
	#endif
	#ifdef XKB_KEY_Greek_lambda
		swigIntConstant( XKB_KEY_Greek_lambda, "XKB_KEY_Greek_lambda" );
	#endif
	#ifdef XKB_KEY_Greek_mu
		swigIntConstant( XKB_KEY_Greek_mu, "XKB_KEY_Greek_mu" );
	#endif
	#ifdef XKB_KEY_Greek_nu
		swigIntConstant( XKB_KEY_Greek_nu, "XKB_KEY_Greek_nu" );
	#endif
	#ifdef XKB_KEY_Greek_xi
		swigIntConstant( XKB_KEY_Greek_xi, "XKB_KEY_Greek_xi" );
	#endif
	#ifdef XKB_KEY_Greek_omicron
		swigIntConstant( XKB_KEY_Greek_omicron, "XKB_KEY_Greek_omicron" );
	#endif
	#ifdef XKB_KEY_Greek_pi
		swigIntConstant( XKB_KEY_Greek_pi, "XKB_KEY_Greek_pi" );
	#endif
	#ifdef XKB_KEY_Greek_rho
		swigIntConstant( XKB_KEY_Greek_rho, "XKB_KEY_Greek_rho" );
	#endif
	#ifdef XKB_KEY_Greek_sigma
		swigIntConstant( XKB_KEY_Greek_sigma, "XKB_KEY_Greek_sigma" );
	#endif
	#ifdef XKB_KEY_Greek_finalsmallsigma
		swigIntConstant( XKB_KEY_Greek_finalsmallsigma, "XKB_KEY_Greek_finalsmallsigma" );
	#endif
	#ifdef XKB_KEY_Greek_tau
		swigIntConstant( XKB_KEY_Greek_tau, "XKB_KEY_Greek_tau" );
	#endif
	#ifdef XKB_KEY_Greek_upsilon
		swigIntConstant( XKB_KEY_Greek_upsilon, "XKB_KEY_Greek_upsilon" );
	#endif
	#ifdef XKB_KEY_Greek_phi
		swigIntConstant( XKB_KEY_Greek_phi, "XKB_KEY_Greek_phi" );
	#endif
	#ifdef XKB_KEY_Greek_chi
		swigIntConstant( XKB_KEY_Greek_chi, "XKB_KEY_Greek_chi" );
	#endif
	#ifdef XKB_KEY_Greek_psi
		swigIntConstant( XKB_KEY_Greek_psi, "XKB_KEY_Greek_psi" );
	#endif
	#ifdef XKB_KEY_Greek_omega
		swigIntConstant( XKB_KEY_Greek_omega, "XKB_KEY_Greek_omega" );
	#endif
	#ifdef XKB_KEY_Greek_switch
		swigIntConstant( XKB_KEY_Greek_switch, "XKB_KEY_Greek_switch" );
	#endif
	#ifdef XKB_KEY_leftradical
		swigIntConstant( XKB_KEY_leftradical, "XKB_KEY_leftradical" );
	#endif
	#ifdef XKB_KEY_topleftradical
		swigIntConstant( XKB_KEY_topleftradical, "XKB_KEY_topleftradical" );
	#endif
	#ifdef XKB_KEY_horizconnector
		swigIntConstant( XKB_KEY_horizconnector, "XKB_KEY_horizconnector" );
	#endif
	#ifdef XKB_KEY_topintegral
		swigIntConstant( XKB_KEY_topintegral, "XKB_KEY_topintegral" );
	#endif
	#ifdef XKB_KEY_botintegral
		swigIntConstant( XKB_KEY_botintegral, "XKB_KEY_botintegral" );
	#endif
	#ifdef XKB_KEY_vertconnector
		swigIntConstant( XKB_KEY_vertconnector, "XKB_KEY_vertconnector" );
	#endif
	#ifdef XKB_KEY_topleftsqbracket
		swigIntConstant( XKB_KEY_topleftsqbracket, "XKB_KEY_topleftsqbracket" );
	#endif
	#ifdef XKB_KEY_botleftsqbracket
		swigIntConstant( XKB_KEY_botleftsqbracket, "XKB_KEY_botleftsqbracket" );
	#endif
	#ifdef XKB_KEY_toprightsqbracket
		swigIntConstant( XKB_KEY_toprightsqbracket, "XKB_KEY_toprightsqbracket" );
	#endif
	#ifdef XKB_KEY_botrightsqbracket
		swigIntConstant( XKB_KEY_botrightsqbracket, "XKB_KEY_botrightsqbracket" );
	#endif
	#ifdef XKB_KEY_topleftparens
		swigIntConstant( XKB_KEY_topleftparens, "XKB_KEY_topleftparens" );
	#endif
	#ifdef XKB_KEY_botleftparens
		swigIntConstant( XKB_KEY_botleftparens, "XKB_KEY_botleftparens" );
	#endif
	#ifdef XKB_KEY_toprightparens
		swigIntConstant( XKB_KEY_toprightparens, "XKB_KEY_toprightparens" );
	#endif
	#ifdef XKB_KEY_botrightparens
		swigIntConstant( XKB_KEY_botrightparens, "XKB_KEY_botrightparens" );
	#endif
	#ifdef XKB_KEY_leftmiddlecurlybrace
		swigIntConstant( XKB_KEY_leftmiddlecurlybrace, "XKB_KEY_leftmiddlecurlybrace" );
	#endif
	#ifdef XKB_KEY_rightmiddlecurlybrace
		swigIntConstant( XKB_KEY_rightmiddlecurlybrace, "XKB_KEY_rightmiddlecurlybrace" );
	#endif
	#ifdef XKB_KEY_topleftsummation
		swigIntConstant( XKB_KEY_topleftsummation, "XKB_KEY_topleftsummation" );
	#endif
	#ifdef XKB_KEY_botleftsummation
		swigIntConstant( XKB_KEY_botleftsummation, "XKB_KEY_botleftsummation" );
	#endif
	#ifdef XKB_KEY_topvertsummationconnector
		swigIntConstant( XKB_KEY_topvertsummationconnector, "XKB_KEY_topvertsummationconnector" );
	#endif
	#ifdef XKB_KEY_botvertsummationconnector
		swigIntConstant( XKB_KEY_botvertsummationconnector, "XKB_KEY_botvertsummationconnector" );
	#endif
	#ifdef XKB_KEY_toprightsummation
		swigIntConstant( XKB_KEY_toprightsummation, "XKB_KEY_toprightsummation" );
	#endif
	#ifdef XKB_KEY_botrightsummation
		swigIntConstant( XKB_KEY_botrightsummation, "XKB_KEY_botrightsummation" );
	#endif
	#ifdef XKB_KEY_rightmiddlesummation
		swigIntConstant( XKB_KEY_rightmiddlesummation, "XKB_KEY_rightmiddlesummation" );
	#endif
	#ifdef XKB_KEY_lessthanequal
		swigIntConstant( XKB_KEY_lessthanequal, "XKB_KEY_lessthanequal" );
	#endif
	#ifdef XKB_KEY_notequal
		swigIntConstant( XKB_KEY_notequal, "XKB_KEY_notequal" );
	#endif
	#ifdef XKB_KEY_greaterthanequal
		swigIntConstant( XKB_KEY_greaterthanequal, "XKB_KEY_greaterthanequal" );
	#endif
	#ifdef XKB_KEY_integral
		swigIntConstant( XKB_KEY_integral, "XKB_KEY_integral" );
	#endif
	#ifdef XKB_KEY_therefore
		swigIntConstant( XKB_KEY_therefore, "XKB_KEY_therefore" );
	#endif
	#ifdef XKB_KEY_variation
		swigIntConstant( XKB_KEY_variation, "XKB_KEY_variation" );
	#endif
	#ifdef XKB_KEY_infinity
		swigIntConstant( XKB_KEY_infinity, "XKB_KEY_infinity" );
	#endif
	#ifdef XKB_KEY_nabla
		swigIntConstant( XKB_KEY_nabla, "XKB_KEY_nabla" );
	#endif
	#ifdef XKB_KEY_approximate
		swigIntConstant( XKB_KEY_approximate, "XKB_KEY_approximate" );
	#endif
	#ifdef XKB_KEY_similarequal
		swigIntConstant( XKB_KEY_similarequal, "XKB_KEY_similarequal" );
	#endif
	#ifdef XKB_KEY_ifonlyif
		swigIntConstant( XKB_KEY_ifonlyif, "XKB_KEY_ifonlyif" );
	#endif
	#ifdef XKB_KEY_implies
		swigIntConstant( XKB_KEY_implies, "XKB_KEY_implies" );
	#endif
	#ifdef XKB_KEY_identical
		swigIntConstant( XKB_KEY_identical, "XKB_KEY_identical" );
	#endif
	#ifdef XKB_KEY_radical
		swigIntConstant( XKB_KEY_radical, "XKB_KEY_radical" );
	#endif
	#ifdef XKB_KEY_includedin
		swigIntConstant( XKB_KEY_includedin, "XKB_KEY_includedin" );
	#endif
	#ifdef XKB_KEY_includes
		swigIntConstant( XKB_KEY_includes, "XKB_KEY_includes" );
	#endif
	#ifdef XKB_KEY_intersection
		swigIntConstant( XKB_KEY_intersection, "XKB_KEY_intersection" );
	#endif
	#ifdef XKB_KEY_union
		swigIntConstant( XKB_KEY_union, "XKB_KEY_union" );
	#endif
	#ifdef XKB_KEY_logicaland
		swigIntConstant( XKB_KEY_logicaland, "XKB_KEY_logicaland" );
	#endif
	#ifdef XKB_KEY_logicalor
		swigIntConstant( XKB_KEY_logicalor, "XKB_KEY_logicalor" );
	#endif
	#ifdef XKB_KEY_partialderivative
		swigIntConstant( XKB_KEY_partialderivative, "XKB_KEY_partialderivative" );
	#endif
	#ifdef XKB_KEY_function
		swigIntConstant( XKB_KEY_function, "XKB_KEY_function" );
	#endif
	#ifdef XKB_KEY_leftarrow
		swigIntConstant( XKB_KEY_leftarrow, "XKB_KEY_leftarrow" );
	#endif
	#ifdef XKB_KEY_uparrow
		swigIntConstant( XKB_KEY_uparrow, "XKB_KEY_uparrow" );
	#endif
	#ifdef XKB_KEY_rightarrow
		swigIntConstant( XKB_KEY_rightarrow, "XKB_KEY_rightarrow" );
	#endif
	#ifdef XKB_KEY_downarrow
		swigIntConstant( XKB_KEY_downarrow, "XKB_KEY_downarrow" );
	#endif
	#ifdef XKB_KEY_blank
		swigIntConstant( XKB_KEY_blank, "XKB_KEY_blank" );
	#endif
	#ifdef XKB_KEY_soliddiamond
		swigIntConstant( XKB_KEY_soliddiamond, "XKB_KEY_soliddiamond" );
	#endif
	#ifdef XKB_KEY_checkerboard
		swigIntConstant( XKB_KEY_checkerboard, "XKB_KEY_checkerboard" );
	#endif
	#ifdef XKB_KEY_ht
		swigIntConstant( XKB_KEY_ht, "XKB_KEY_ht" );
	#endif
	#ifdef XKB_KEY_ff
		swigIntConstant( XKB_KEY_ff, "XKB_KEY_ff" );
	#endif
	#ifdef XKB_KEY_cr
		swigIntConstant( XKB_KEY_cr, "XKB_KEY_cr" );
	#endif
	#ifdef XKB_KEY_lf
		swigIntConstant( XKB_KEY_lf, "XKB_KEY_lf" );
	#endif
	#ifdef XKB_KEY_nl
		swigIntConstant( XKB_KEY_nl, "XKB_KEY_nl" );
	#endif
	#ifdef XKB_KEY_vt
		swigIntConstant( XKB_KEY_vt, "XKB_KEY_vt" );
	#endif
	#ifdef XKB_KEY_lowrightcorner
		swigIntConstant( XKB_KEY_lowrightcorner, "XKB_KEY_lowrightcorner" );
	#endif
	#ifdef XKB_KEY_uprightcorner
		swigIntConstant( XKB_KEY_uprightcorner, "XKB_KEY_uprightcorner" );
	#endif
	#ifdef XKB_KEY_upleftcorner
		swigIntConstant( XKB_KEY_upleftcorner, "XKB_KEY_upleftcorner" );
	#endif
	#ifdef XKB_KEY_lowleftcorner
		swigIntConstant( XKB_KEY_lowleftcorner, "XKB_KEY_lowleftcorner" );
	#endif
	#ifdef XKB_KEY_crossinglines
		swigIntConstant( XKB_KEY_crossinglines, "XKB_KEY_crossinglines" );
	#endif
	#ifdef XKB_KEY_horizlinescan1
		swigIntConstant( XKB_KEY_horizlinescan1, "XKB_KEY_horizlinescan1" );
	#endif
	#ifdef XKB_KEY_horizlinescan3
		swigIntConstant( XKB_KEY_horizlinescan3, "XKB_KEY_horizlinescan3" );
	#endif
	#ifdef XKB_KEY_horizlinescan5
		swigIntConstant( XKB_KEY_horizlinescan5, "XKB_KEY_horizlinescan5" );
	#endif
	#ifdef XKB_KEY_horizlinescan7
		swigIntConstant( XKB_KEY_horizlinescan7, "XKB_KEY_horizlinescan7" );
	#endif
	#ifdef XKB_KEY_horizlinescan9
		swigIntConstant( XKB_KEY_horizlinescan9, "XKB_KEY_horizlinescan9" );
	#endif
	#ifdef XKB_KEY_leftt
		swigIntConstant( XKB_KEY_leftt, "XKB_KEY_leftt" );
	#endif
	#ifdef XKB_KEY_rightt
		swigIntConstant( XKB_KEY_rightt, "XKB_KEY_rightt" );
	#endif
	#ifdef XKB_KEY_bott
		swigIntConstant( XKB_KEY_bott, "XKB_KEY_bott" );
	#endif
	#ifdef XKB_KEY_topt
		swigIntConstant( XKB_KEY_topt, "XKB_KEY_topt" );
	#endif
	#ifdef XKB_KEY_vertbar
		swigIntConstant( XKB_KEY_vertbar, "XKB_KEY_vertbar" );
	#endif
	#ifdef XKB_KEY_emspace
		swigIntConstant( XKB_KEY_emspace, "XKB_KEY_emspace" );
	#endif
	#ifdef XKB_KEY_enspace
		swigIntConstant( XKB_KEY_enspace, "XKB_KEY_enspace" );
	#endif
	#ifdef XKB_KEY_em3space
		swigIntConstant( XKB_KEY_em3space, "XKB_KEY_em3space" );
	#endif
	#ifdef XKB_KEY_em4space
		swigIntConstant( XKB_KEY_em4space, "XKB_KEY_em4space" );
	#endif
	#ifdef XKB_KEY_digitspace
		swigIntConstant( XKB_KEY_digitspace, "XKB_KEY_digitspace" );
	#endif
	#ifdef XKB_KEY_punctspace
		swigIntConstant( XKB_KEY_punctspace, "XKB_KEY_punctspace" );
	#endif
	#ifdef XKB_KEY_thinspace
		swigIntConstant( XKB_KEY_thinspace, "XKB_KEY_thinspace" );
	#endif
	#ifdef XKB_KEY_hairspace
		swigIntConstant( XKB_KEY_hairspace, "XKB_KEY_hairspace" );
	#endif
	#ifdef XKB_KEY_emdash
		swigIntConstant( XKB_KEY_emdash, "XKB_KEY_emdash" );
	#endif
	#ifdef XKB_KEY_endash
		swigIntConstant( XKB_KEY_endash, "XKB_KEY_endash" );
	#endif
	#ifdef XKB_KEY_signifblank
		swigIntConstant( XKB_KEY_signifblank, "XKB_KEY_signifblank" );
	#endif
	#ifdef XKB_KEY_ellipsis
		swigIntConstant( XKB_KEY_ellipsis, "XKB_KEY_ellipsis" );
	#endif
	#ifdef XKB_KEY_doubbaselinedot
		swigIntConstant( XKB_KEY_doubbaselinedot, "XKB_KEY_doubbaselinedot" );
	#endif
	#ifdef XKB_KEY_onethird
		swigIntConstant( XKB_KEY_onethird, "XKB_KEY_onethird" );
	#endif
	#ifdef XKB_KEY_twothirds
		swigIntConstant( XKB_KEY_twothirds, "XKB_KEY_twothirds" );
	#endif
	#ifdef XKB_KEY_onefifth
		swigIntConstant( XKB_KEY_onefifth, "XKB_KEY_onefifth" );
	#endif
	#ifdef XKB_KEY_twofifths
		swigIntConstant( XKB_KEY_twofifths, "XKB_KEY_twofifths" );
	#endif
	#ifdef XKB_KEY_threefifths
		swigIntConstant( XKB_KEY_threefifths, "XKB_KEY_threefifths" );
	#endif
	#ifdef XKB_KEY_fourfifths
		swigIntConstant( XKB_KEY_fourfifths, "XKB_KEY_fourfifths" );
	#endif
	#ifdef XKB_KEY_onesixth
		swigIntConstant( XKB_KEY_onesixth, "XKB_KEY_onesixth" );
	#endif
	#ifdef XKB_KEY_fivesixths
		swigIntConstant( XKB_KEY_fivesixths, "XKB_KEY_fivesixths" );
	#endif
	#ifdef XKB_KEY_careof
		swigIntConstant( XKB_KEY_careof, "XKB_KEY_careof" );
	#endif
	#ifdef XKB_KEY_figdash
		swigIntConstant( XKB_KEY_figdash, "XKB_KEY_figdash" );
	#endif
	#ifdef XKB_KEY_leftanglebracket
		swigIntConstant( XKB_KEY_leftanglebracket, "XKB_KEY_leftanglebracket" );
	#endif
	#ifdef XKB_KEY_decimalpoint
		swigIntConstant( XKB_KEY_decimalpoint, "XKB_KEY_decimalpoint" );
	#endif
	#ifdef XKB_KEY_rightanglebracket
		swigIntConstant( XKB_KEY_rightanglebracket, "XKB_KEY_rightanglebracket" );
	#endif
	#ifdef XKB_KEY_marker
		swigIntConstant( XKB_KEY_marker, "XKB_KEY_marker" );
	#endif
	#ifdef XKB_KEY_oneeighth
		swigIntConstant( XKB_KEY_oneeighth, "XKB_KEY_oneeighth" );
	#endif
	#ifdef XKB_KEY_threeeighths
		swigIntConstant( XKB_KEY_threeeighths, "XKB_KEY_threeeighths" );
	#endif
	#ifdef XKB_KEY_fiveeighths
		swigIntConstant( XKB_KEY_fiveeighths, "XKB_KEY_fiveeighths" );
	#endif
	#ifdef XKB_KEY_seveneighths
		swigIntConstant( XKB_KEY_seveneighths, "XKB_KEY_seveneighths" );
	#endif
	#ifdef XKB_KEY_trademark
		swigIntConstant( XKB_KEY_trademark, "XKB_KEY_trademark" );
	#endif
	#ifdef XKB_KEY_signaturemark
		swigIntConstant( XKB_KEY_signaturemark, "XKB_KEY_signaturemark" );
	#endif
	#ifdef XKB_KEY_trademarkincircle
		swigIntConstant( XKB_KEY_trademarkincircle, "XKB_KEY_trademarkincircle" );
	#endif
	#ifdef XKB_KEY_leftopentriangle
		swigIntConstant( XKB_KEY_leftopentriangle, "XKB_KEY_leftopentriangle" );
	#endif
	#ifdef XKB_KEY_rightopentriangle
		swigIntConstant( XKB_KEY_rightopentriangle, "XKB_KEY_rightopentriangle" );
	#endif
	#ifdef XKB_KEY_emopencircle
		swigIntConstant( XKB_KEY_emopencircle, "XKB_KEY_emopencircle" );
	#endif
	#ifdef XKB_KEY_emopenrectangle
		swigIntConstant( XKB_KEY_emopenrectangle, "XKB_KEY_emopenrectangle" );
	#endif
	#ifdef XKB_KEY_leftsinglequotemark
		swigIntConstant( XKB_KEY_leftsinglequotemark, "XKB_KEY_leftsinglequotemark" );
	#endif
	#ifdef XKB_KEY_rightsinglequotemark
		swigIntConstant( XKB_KEY_rightsinglequotemark, "XKB_KEY_rightsinglequotemark" );
	#endif
	#ifdef XKB_KEY_leftdoublequotemark
		swigIntConstant( XKB_KEY_leftdoublequotemark, "XKB_KEY_leftdoublequotemark" );
	#endif
	#ifdef XKB_KEY_rightdoublequotemark
		swigIntConstant( XKB_KEY_rightdoublequotemark, "XKB_KEY_rightdoublequotemark" );
	#endif
	#ifdef XKB_KEY_prescription
		swigIntConstant( XKB_KEY_prescription, "XKB_KEY_prescription" );
	#endif
	#ifdef XKB_KEY_permille
		swigIntConstant( XKB_KEY_permille, "XKB_KEY_permille" );
	#endif
	#ifdef XKB_KEY_minutes
		swigIntConstant( XKB_KEY_minutes, "XKB_KEY_minutes" );
	#endif
	#ifdef XKB_KEY_seconds
		swigIntConstant( XKB_KEY_seconds, "XKB_KEY_seconds" );
	#endif
	#ifdef XKB_KEY_latincross
		swigIntConstant( XKB_KEY_latincross, "XKB_KEY_latincross" );
	#endif
	#ifdef XKB_KEY_hexagram
		swigIntConstant( XKB_KEY_hexagram, "XKB_KEY_hexagram" );
	#endif
	#ifdef XKB_KEY_filledrectbullet
		swigIntConstant( XKB_KEY_filledrectbullet, "XKB_KEY_filledrectbullet" );
	#endif
	#ifdef XKB_KEY_filledlefttribullet
		swigIntConstant( XKB_KEY_filledlefttribullet, "XKB_KEY_filledlefttribullet" );
	#endif
	#ifdef XKB_KEY_filledrighttribullet
		swigIntConstant( XKB_KEY_filledrighttribullet, "XKB_KEY_filledrighttribullet" );
	#endif
	#ifdef XKB_KEY_emfilledcircle
		swigIntConstant( XKB_KEY_emfilledcircle, "XKB_KEY_emfilledcircle" );
	#endif
	#ifdef XKB_KEY_emfilledrect
		swigIntConstant( XKB_KEY_emfilledrect, "XKB_KEY_emfilledrect" );
	#endif
	#ifdef XKB_KEY_enopencircbullet
		swigIntConstant( XKB_KEY_enopencircbullet, "XKB_KEY_enopencircbullet" );
	#endif
	#ifdef XKB_KEY_enopensquarebullet
		swigIntConstant( XKB_KEY_enopensquarebullet, "XKB_KEY_enopensquarebullet" );
	#endif
	#ifdef XKB_KEY_openrectbullet
		swigIntConstant( XKB_KEY_openrectbullet, "XKB_KEY_openrectbullet" );
	#endif
	#ifdef XKB_KEY_opentribulletup
		swigIntConstant( XKB_KEY_opentribulletup, "XKB_KEY_opentribulletup" );
	#endif
	#ifdef XKB_KEY_opentribulletdown
		swigIntConstant( XKB_KEY_opentribulletdown, "XKB_KEY_opentribulletdown" );
	#endif
	#ifdef XKB_KEY_openstar
		swigIntConstant( XKB_KEY_openstar, "XKB_KEY_openstar" );
	#endif
	#ifdef XKB_KEY_enfilledcircbullet
		swigIntConstant( XKB_KEY_enfilledcircbullet, "XKB_KEY_enfilledcircbullet" );
	#endif
	#ifdef XKB_KEY_enfilledsqbullet
		swigIntConstant( XKB_KEY_enfilledsqbullet, "XKB_KEY_enfilledsqbullet" );
	#endif
	#ifdef XKB_KEY_filledtribulletup
		swigIntConstant( XKB_KEY_filledtribulletup, "XKB_KEY_filledtribulletup" );
	#endif
	#ifdef XKB_KEY_filledtribulletdown
		swigIntConstant( XKB_KEY_filledtribulletdown, "XKB_KEY_filledtribulletdown" );
	#endif
	#ifdef XKB_KEY_leftpointer
		swigIntConstant( XKB_KEY_leftpointer, "XKB_KEY_leftpointer" );
	#endif
	#ifdef XKB_KEY_rightpointer
		swigIntConstant( XKB_KEY_rightpointer, "XKB_KEY_rightpointer" );
	#endif
	#ifdef XKB_KEY_club
		swigIntConstant( XKB_KEY_club, "XKB_KEY_club" );
	#endif
	#ifdef XKB_KEY_diamond
		swigIntConstant( XKB_KEY_diamond, "XKB_KEY_diamond" );
	#endif
	#ifdef XKB_KEY_heart
		swigIntConstant( XKB_KEY_heart, "XKB_KEY_heart" );
	#endif
	#ifdef XKB_KEY_maltesecross
		swigIntConstant( XKB_KEY_maltesecross, "XKB_KEY_maltesecross" );
	#endif
	#ifdef XKB_KEY_dagger
		swigIntConstant( XKB_KEY_dagger, "XKB_KEY_dagger" );
	#endif
	#ifdef XKB_KEY_doubledagger
		swigIntConstant( XKB_KEY_doubledagger, "XKB_KEY_doubledagger" );
	#endif
	#ifdef XKB_KEY_checkmark
		swigIntConstant( XKB_KEY_checkmark, "XKB_KEY_checkmark" );
	#endif
	#ifdef XKB_KEY_ballotcross
		swigIntConstant( XKB_KEY_ballotcross, "XKB_KEY_ballotcross" );
	#endif
	#ifdef XKB_KEY_musicalsharp
		swigIntConstant( XKB_KEY_musicalsharp, "XKB_KEY_musicalsharp" );
	#endif
	#ifdef XKB_KEY_musicalflat
		swigIntConstant( XKB_KEY_musicalflat, "XKB_KEY_musicalflat" );
	#endif
	#ifdef XKB_KEY_malesymbol
		swigIntConstant( XKB_KEY_malesymbol, "XKB_KEY_malesymbol" );
	#endif
	#ifdef XKB_KEY_femalesymbol
		swigIntConstant( XKB_KEY_femalesymbol, "XKB_KEY_femalesymbol" );
	#endif
	#ifdef XKB_KEY_telephone
		swigIntConstant( XKB_KEY_telephone, "XKB_KEY_telephone" );
	#endif
	#ifdef XKB_KEY_telephonerecorder
		swigIntConstant( XKB_KEY_telephonerecorder, "XKB_KEY_telephonerecorder" );
	#endif
	#ifdef XKB_KEY_phonographcopyright
		swigIntConstant( XKB_KEY_phonographcopyright, "XKB_KEY_phonographcopyright" );
	#endif
	#ifdef XKB_KEY_caret
		swigIntConstant( XKB_KEY_caret, "XKB_KEY_caret" );
	#endif
	#ifdef XKB_KEY_singlelowquotemark
		swigIntConstant( XKB_KEY_singlelowquotemark, "XKB_KEY_singlelowquotemark" );
	#endif
	#ifdef XKB_KEY_doublelowquotemark
		swigIntConstant( XKB_KEY_doublelowquotemark, "XKB_KEY_doublelowquotemark" );
	#endif
	#ifdef XKB_KEY_cursor
		swigIntConstant( XKB_KEY_cursor, "XKB_KEY_cursor" );
	#endif
	#ifdef XKB_KEY_leftcaret
		swigIntConstant( XKB_KEY_leftcaret, "XKB_KEY_leftcaret" );
	#endif
	#ifdef XKB_KEY_rightcaret
		swigIntConstant( XKB_KEY_rightcaret, "XKB_KEY_rightcaret" );
	#endif
	#ifdef XKB_KEY_downcaret
		swigIntConstant( XKB_KEY_downcaret, "XKB_KEY_downcaret" );
	#endif
	#ifdef XKB_KEY_upcaret
		swigIntConstant( XKB_KEY_upcaret, "XKB_KEY_upcaret" );
	#endif
	#ifdef XKB_KEY_overbar
		swigIntConstant( XKB_KEY_overbar, "XKB_KEY_overbar" );
	#endif
	#ifdef XKB_KEY_downtack
		swigIntConstant( XKB_KEY_downtack, "XKB_KEY_downtack" );
	#endif
	#ifdef XKB_KEY_upshoe
		swigIntConstant( XKB_KEY_upshoe, "XKB_KEY_upshoe" );
	#endif
	#ifdef XKB_KEY_downstile
		swigIntConstant( XKB_KEY_downstile, "XKB_KEY_downstile" );
	#endif
	#ifdef XKB_KEY_underbar
		swigIntConstant( XKB_KEY_underbar, "XKB_KEY_underbar" );
	#endif
	#ifdef XKB_KEY_jot
		swigIntConstant( XKB_KEY_jot, "XKB_KEY_jot" );
	#endif
	#ifdef XKB_KEY_quad
		swigIntConstant( XKB_KEY_quad, "XKB_KEY_quad" );
	#endif
	#ifdef XKB_KEY_uptack
		swigIntConstant( XKB_KEY_uptack, "XKB_KEY_uptack" );
	#endif
	#ifdef XKB_KEY_circle
		swigIntConstant( XKB_KEY_circle, "XKB_KEY_circle" );
	#endif
	#ifdef XKB_KEY_upstile
		swigIntConstant( XKB_KEY_upstile, "XKB_KEY_upstile" );
	#endif
	#ifdef XKB_KEY_downshoe
		swigIntConstant( XKB_KEY_downshoe, "XKB_KEY_downshoe" );
	#endif
	#ifdef XKB_KEY_rightshoe
		swigIntConstant( XKB_KEY_rightshoe, "XKB_KEY_rightshoe" );
	#endif
	#ifdef XKB_KEY_leftshoe
		swigIntConstant( XKB_KEY_leftshoe, "XKB_KEY_leftshoe" );
	#endif
	#ifdef XKB_KEY_lefttack
		swigIntConstant( XKB_KEY_lefttack, "XKB_KEY_lefttack" );
	#endif
	#ifdef XKB_KEY_righttack
		swigIntConstant( XKB_KEY_righttack, "XKB_KEY_righttack" );
	#endif
	#ifdef XKB_KEY_hebrew_doublelowline
		swigIntConstant( XKB_KEY_hebrew_doublelowline, "XKB_KEY_hebrew_doublelowline" );
	#endif
	#ifdef XKB_KEY_hebrew_aleph
		swigIntConstant( XKB_KEY_hebrew_aleph, "XKB_KEY_hebrew_aleph" );
	#endif
	#ifdef XKB_KEY_hebrew_bet
		swigIntConstant( XKB_KEY_hebrew_bet, "XKB_KEY_hebrew_bet" );
	#endif
	#ifdef XKB_KEY_hebrew_beth
		swigIntConstant( XKB_KEY_hebrew_beth, "XKB_KEY_hebrew_beth" );
	#endif
	#ifdef XKB_KEY_hebrew_gimel
		swigIntConstant( XKB_KEY_hebrew_gimel, "XKB_KEY_hebrew_gimel" );
	#endif
	#ifdef XKB_KEY_hebrew_gimmel
		swigIntConstant( XKB_KEY_hebrew_gimmel, "XKB_KEY_hebrew_gimmel" );
	#endif
	#ifdef XKB_KEY_hebrew_dalet
		swigIntConstant( XKB_KEY_hebrew_dalet, "XKB_KEY_hebrew_dalet" );
	#endif
	#ifdef XKB_KEY_hebrew_daleth
		swigIntConstant( XKB_KEY_hebrew_daleth, "XKB_KEY_hebrew_daleth" );
	#endif
	#ifdef XKB_KEY_hebrew_he
		swigIntConstant( XKB_KEY_hebrew_he, "XKB_KEY_hebrew_he" );
	#endif
	#ifdef XKB_KEY_hebrew_waw
		swigIntConstant( XKB_KEY_hebrew_waw, "XKB_KEY_hebrew_waw" );
	#endif
	#ifdef XKB_KEY_hebrew_zain
		swigIntConstant( XKB_KEY_hebrew_zain, "XKB_KEY_hebrew_zain" );
	#endif
	#ifdef XKB_KEY_hebrew_zayin
		swigIntConstant( XKB_KEY_hebrew_zayin, "XKB_KEY_hebrew_zayin" );
	#endif
	#ifdef XKB_KEY_hebrew_chet
		swigIntConstant( XKB_KEY_hebrew_chet, "XKB_KEY_hebrew_chet" );
	#endif
	#ifdef XKB_KEY_hebrew_het
		swigIntConstant( XKB_KEY_hebrew_het, "XKB_KEY_hebrew_het" );
	#endif
	#ifdef XKB_KEY_hebrew_tet
		swigIntConstant( XKB_KEY_hebrew_tet, "XKB_KEY_hebrew_tet" );
	#endif
	#ifdef XKB_KEY_hebrew_teth
		swigIntConstant( XKB_KEY_hebrew_teth, "XKB_KEY_hebrew_teth" );
	#endif
	#ifdef XKB_KEY_hebrew_yod
		swigIntConstant( XKB_KEY_hebrew_yod, "XKB_KEY_hebrew_yod" );
	#endif
	#ifdef XKB_KEY_hebrew_finalkaph
		swigIntConstant( XKB_KEY_hebrew_finalkaph, "XKB_KEY_hebrew_finalkaph" );
	#endif
	#ifdef XKB_KEY_hebrew_kaph
		swigIntConstant( XKB_KEY_hebrew_kaph, "XKB_KEY_hebrew_kaph" );
	#endif
	#ifdef XKB_KEY_hebrew_lamed
		swigIntConstant( XKB_KEY_hebrew_lamed, "XKB_KEY_hebrew_lamed" );
	#endif
	#ifdef XKB_KEY_hebrew_finalmem
		swigIntConstant( XKB_KEY_hebrew_finalmem, "XKB_KEY_hebrew_finalmem" );
	#endif
	#ifdef XKB_KEY_hebrew_mem
		swigIntConstant( XKB_KEY_hebrew_mem, "XKB_KEY_hebrew_mem" );
	#endif
	#ifdef XKB_KEY_hebrew_finalnun
		swigIntConstant( XKB_KEY_hebrew_finalnun, "XKB_KEY_hebrew_finalnun" );
	#endif
	#ifdef XKB_KEY_hebrew_nun
		swigIntConstant( XKB_KEY_hebrew_nun, "XKB_KEY_hebrew_nun" );
	#endif
	#ifdef XKB_KEY_hebrew_samech
		swigIntConstant( XKB_KEY_hebrew_samech, "XKB_KEY_hebrew_samech" );
	#endif
	#ifdef XKB_KEY_hebrew_samekh
		swigIntConstant( XKB_KEY_hebrew_samekh, "XKB_KEY_hebrew_samekh" );
	#endif
	#ifdef XKB_KEY_hebrew_ayin
		swigIntConstant( XKB_KEY_hebrew_ayin, "XKB_KEY_hebrew_ayin" );
	#endif
	#ifdef XKB_KEY_hebrew_finalpe
		swigIntConstant( XKB_KEY_hebrew_finalpe, "XKB_KEY_hebrew_finalpe" );
	#endif
	#ifdef XKB_KEY_hebrew_pe
		swigIntConstant( XKB_KEY_hebrew_pe, "XKB_KEY_hebrew_pe" );
	#endif
	#ifdef XKB_KEY_hebrew_finalzade
		swigIntConstant( XKB_KEY_hebrew_finalzade, "XKB_KEY_hebrew_finalzade" );
	#endif
	#ifdef XKB_KEY_hebrew_finalzadi
		swigIntConstant( XKB_KEY_hebrew_finalzadi, "XKB_KEY_hebrew_finalzadi" );
	#endif
	#ifdef XKB_KEY_hebrew_zade
		swigIntConstant( XKB_KEY_hebrew_zade, "XKB_KEY_hebrew_zade" );
	#endif
	#ifdef XKB_KEY_hebrew_zadi
		swigIntConstant( XKB_KEY_hebrew_zadi, "XKB_KEY_hebrew_zadi" );
	#endif
	#ifdef XKB_KEY_hebrew_qoph
		swigIntConstant( XKB_KEY_hebrew_qoph, "XKB_KEY_hebrew_qoph" );
	#endif
	#ifdef XKB_KEY_hebrew_kuf
		swigIntConstant( XKB_KEY_hebrew_kuf, "XKB_KEY_hebrew_kuf" );
	#endif
	#ifdef XKB_KEY_hebrew_resh
		swigIntConstant( XKB_KEY_hebrew_resh, "XKB_KEY_hebrew_resh" );
	#endif
	#ifdef XKB_KEY_hebrew_shin
		swigIntConstant( XKB_KEY_hebrew_shin, "XKB_KEY_hebrew_shin" );
	#endif
	#ifdef XKB_KEY_hebrew_taw
		swigIntConstant( XKB_KEY_hebrew_taw, "XKB_KEY_hebrew_taw" );
	#endif
	#ifdef XKB_KEY_hebrew_taf
		swigIntConstant( XKB_KEY_hebrew_taf, "XKB_KEY_hebrew_taf" );
	#endif
	#ifdef XKB_KEY_Hebrew_switch
		swigIntConstant( XKB_KEY_Hebrew_switch, "XKB_KEY_Hebrew_switch" );
	#endif
	#ifdef XKB_KEY_Thai_kokai
		swigIntConstant( XKB_KEY_Thai_kokai, "XKB_KEY_Thai_kokai" );
	#endif
	#ifdef XKB_KEY_Thai_khokhai
		swigIntConstant( XKB_KEY_Thai_khokhai, "XKB_KEY_Thai_khokhai" );
	#endif
	#ifdef XKB_KEY_Thai_khokhuat
		swigIntConstant( XKB_KEY_Thai_khokhuat, "XKB_KEY_Thai_khokhuat" );
	#endif
	#ifdef XKB_KEY_Thai_khokhwai
		swigIntConstant( XKB_KEY_Thai_khokhwai, "XKB_KEY_Thai_khokhwai" );
	#endif
	#ifdef XKB_KEY_Thai_khokhon
		swigIntConstant( XKB_KEY_Thai_khokhon, "XKB_KEY_Thai_khokhon" );
	#endif
	#ifdef XKB_KEY_Thai_khorakhang
		swigIntConstant( XKB_KEY_Thai_khorakhang, "XKB_KEY_Thai_khorakhang" );
	#endif
	#ifdef XKB_KEY_Thai_ngongu
		swigIntConstant( XKB_KEY_Thai_ngongu, "XKB_KEY_Thai_ngongu" );
	#endif
	#ifdef XKB_KEY_Thai_chochan
		swigIntConstant( XKB_KEY_Thai_chochan, "XKB_KEY_Thai_chochan" );
	#endif
	#ifdef XKB_KEY_Thai_choching
		swigIntConstant( XKB_KEY_Thai_choching, "XKB_KEY_Thai_choching" );
	#endif
	#ifdef XKB_KEY_Thai_chochang
		swigIntConstant( XKB_KEY_Thai_chochang, "XKB_KEY_Thai_chochang" );
	#endif
	#ifdef XKB_KEY_Thai_soso
		swigIntConstant( XKB_KEY_Thai_soso, "XKB_KEY_Thai_soso" );
	#endif
	#ifdef XKB_KEY_Thai_chochoe
		swigIntConstant( XKB_KEY_Thai_chochoe, "XKB_KEY_Thai_chochoe" );
	#endif
	#ifdef XKB_KEY_Thai_yoying
		swigIntConstant( XKB_KEY_Thai_yoying, "XKB_KEY_Thai_yoying" );
	#endif
	#ifdef XKB_KEY_Thai_dochada
		swigIntConstant( XKB_KEY_Thai_dochada, "XKB_KEY_Thai_dochada" );
	#endif
	#ifdef XKB_KEY_Thai_topatak
		swigIntConstant( XKB_KEY_Thai_topatak, "XKB_KEY_Thai_topatak" );
	#endif
	#ifdef XKB_KEY_Thai_thothan
		swigIntConstant( XKB_KEY_Thai_thothan, "XKB_KEY_Thai_thothan" );
	#endif
	#ifdef XKB_KEY_Thai_thonangmontho
		swigIntConstant( XKB_KEY_Thai_thonangmontho, "XKB_KEY_Thai_thonangmontho" );
	#endif
	#ifdef XKB_KEY_Thai_thophuthao
		swigIntConstant( XKB_KEY_Thai_thophuthao, "XKB_KEY_Thai_thophuthao" );
	#endif
	#ifdef XKB_KEY_Thai_nonen
		swigIntConstant( XKB_KEY_Thai_nonen, "XKB_KEY_Thai_nonen" );
	#endif
	#ifdef XKB_KEY_Thai_dodek
		swigIntConstant( XKB_KEY_Thai_dodek, "XKB_KEY_Thai_dodek" );
	#endif
	#ifdef XKB_KEY_Thai_totao
		swigIntConstant( XKB_KEY_Thai_totao, "XKB_KEY_Thai_totao" );
	#endif
	#ifdef XKB_KEY_Thai_thothung
		swigIntConstant( XKB_KEY_Thai_thothung, "XKB_KEY_Thai_thothung" );
	#endif
	#ifdef XKB_KEY_Thai_thothahan
		swigIntConstant( XKB_KEY_Thai_thothahan, "XKB_KEY_Thai_thothahan" );
	#endif
	#ifdef XKB_KEY_Thai_thothong
		swigIntConstant( XKB_KEY_Thai_thothong, "XKB_KEY_Thai_thothong" );
	#endif
	#ifdef XKB_KEY_Thai_nonu
		swigIntConstant( XKB_KEY_Thai_nonu, "XKB_KEY_Thai_nonu" );
	#endif
	#ifdef XKB_KEY_Thai_bobaimai
		swigIntConstant( XKB_KEY_Thai_bobaimai, "XKB_KEY_Thai_bobaimai" );
	#endif
	#ifdef XKB_KEY_Thai_popla
		swigIntConstant( XKB_KEY_Thai_popla, "XKB_KEY_Thai_popla" );
	#endif
	#ifdef XKB_KEY_Thai_phophung
		swigIntConstant( XKB_KEY_Thai_phophung, "XKB_KEY_Thai_phophung" );
	#endif
	#ifdef XKB_KEY_Thai_fofa
		swigIntConstant( XKB_KEY_Thai_fofa, "XKB_KEY_Thai_fofa" );
	#endif
	#ifdef XKB_KEY_Thai_phophan
		swigIntConstant( XKB_KEY_Thai_phophan, "XKB_KEY_Thai_phophan" );
	#endif
	#ifdef XKB_KEY_Thai_fofan
		swigIntConstant( XKB_KEY_Thai_fofan, "XKB_KEY_Thai_fofan" );
	#endif
	#ifdef XKB_KEY_Thai_phosamphao
		swigIntConstant( XKB_KEY_Thai_phosamphao, "XKB_KEY_Thai_phosamphao" );
	#endif
	#ifdef XKB_KEY_Thai_moma
		swigIntConstant( XKB_KEY_Thai_moma, "XKB_KEY_Thai_moma" );
	#endif
	#ifdef XKB_KEY_Thai_yoyak
		swigIntConstant( XKB_KEY_Thai_yoyak, "XKB_KEY_Thai_yoyak" );
	#endif
	#ifdef XKB_KEY_Thai_rorua
		swigIntConstant( XKB_KEY_Thai_rorua, "XKB_KEY_Thai_rorua" );
	#endif
	#ifdef XKB_KEY_Thai_ru
		swigIntConstant( XKB_KEY_Thai_ru, "XKB_KEY_Thai_ru" );
	#endif
	#ifdef XKB_KEY_Thai_loling
		swigIntConstant( XKB_KEY_Thai_loling, "XKB_KEY_Thai_loling" );
	#endif
	#ifdef XKB_KEY_Thai_lu
		swigIntConstant( XKB_KEY_Thai_lu, "XKB_KEY_Thai_lu" );
	#endif
	#ifdef XKB_KEY_Thai_wowaen
		swigIntConstant( XKB_KEY_Thai_wowaen, "XKB_KEY_Thai_wowaen" );
	#endif
	#ifdef XKB_KEY_Thai_sosala
		swigIntConstant( XKB_KEY_Thai_sosala, "XKB_KEY_Thai_sosala" );
	#endif
	#ifdef XKB_KEY_Thai_sorusi
		swigIntConstant( XKB_KEY_Thai_sorusi, "XKB_KEY_Thai_sorusi" );
	#endif
	#ifdef XKB_KEY_Thai_sosua
		swigIntConstant( XKB_KEY_Thai_sosua, "XKB_KEY_Thai_sosua" );
	#endif
	#ifdef XKB_KEY_Thai_hohip
		swigIntConstant( XKB_KEY_Thai_hohip, "XKB_KEY_Thai_hohip" );
	#endif
	#ifdef XKB_KEY_Thai_lochula
		swigIntConstant( XKB_KEY_Thai_lochula, "XKB_KEY_Thai_lochula" );
	#endif
	#ifdef XKB_KEY_Thai_oang
		swigIntConstant( XKB_KEY_Thai_oang, "XKB_KEY_Thai_oang" );
	#endif
	#ifdef XKB_KEY_Thai_honokhuk
		swigIntConstant( XKB_KEY_Thai_honokhuk, "XKB_KEY_Thai_honokhuk" );
	#endif
	#ifdef XKB_KEY_Thai_paiyannoi
		swigIntConstant( XKB_KEY_Thai_paiyannoi, "XKB_KEY_Thai_paiyannoi" );
	#endif
	#ifdef XKB_KEY_Thai_saraa
		swigIntConstant( XKB_KEY_Thai_saraa, "XKB_KEY_Thai_saraa" );
	#endif
	#ifdef XKB_KEY_Thai_maihanakat
		swigIntConstant( XKB_KEY_Thai_maihanakat, "XKB_KEY_Thai_maihanakat" );
	#endif
	#ifdef XKB_KEY_Thai_saraaa
		swigIntConstant( XKB_KEY_Thai_saraaa, "XKB_KEY_Thai_saraaa" );
	#endif
	#ifdef XKB_KEY_Thai_saraam
		swigIntConstant( XKB_KEY_Thai_saraam, "XKB_KEY_Thai_saraam" );
	#endif
	#ifdef XKB_KEY_Thai_sarai
		swigIntConstant( XKB_KEY_Thai_sarai, "XKB_KEY_Thai_sarai" );
	#endif
	#ifdef XKB_KEY_Thai_saraii
		swigIntConstant( XKB_KEY_Thai_saraii, "XKB_KEY_Thai_saraii" );
	#endif
	#ifdef XKB_KEY_Thai_saraue
		swigIntConstant( XKB_KEY_Thai_saraue, "XKB_KEY_Thai_saraue" );
	#endif
	#ifdef XKB_KEY_Thai_sarauee
		swigIntConstant( XKB_KEY_Thai_sarauee, "XKB_KEY_Thai_sarauee" );
	#endif
	#ifdef XKB_KEY_Thai_sarau
		swigIntConstant( XKB_KEY_Thai_sarau, "XKB_KEY_Thai_sarau" );
	#endif
	#ifdef XKB_KEY_Thai_sarauu
		swigIntConstant( XKB_KEY_Thai_sarauu, "XKB_KEY_Thai_sarauu" );
	#endif
	#ifdef XKB_KEY_Thai_phinthu
		swigIntConstant( XKB_KEY_Thai_phinthu, "XKB_KEY_Thai_phinthu" );
	#endif
	#ifdef XKB_KEY_Thai_maihanakat_maitho
		swigIntConstant( XKB_KEY_Thai_maihanakat_maitho, "XKB_KEY_Thai_maihanakat_maitho" );
	#endif
	#ifdef XKB_KEY_Thai_baht
		swigIntConstant( XKB_KEY_Thai_baht, "XKB_KEY_Thai_baht" );
	#endif
	#ifdef XKB_KEY_Thai_sarae
		swigIntConstant( XKB_KEY_Thai_sarae, "XKB_KEY_Thai_sarae" );
	#endif
	#ifdef XKB_KEY_Thai_saraae
		swigIntConstant( XKB_KEY_Thai_saraae, "XKB_KEY_Thai_saraae" );
	#endif
	#ifdef XKB_KEY_Thai_sarao
		swigIntConstant( XKB_KEY_Thai_sarao, "XKB_KEY_Thai_sarao" );
	#endif
	#ifdef XKB_KEY_Thai_saraaimaimuan
		swigIntConstant( XKB_KEY_Thai_saraaimaimuan, "XKB_KEY_Thai_saraaimaimuan" );
	#endif
	#ifdef XKB_KEY_Thai_saraaimaimalai
		swigIntConstant( XKB_KEY_Thai_saraaimaimalai, "XKB_KEY_Thai_saraaimaimalai" );
	#endif
	#ifdef XKB_KEY_Thai_lakkhangyao
		swigIntConstant( XKB_KEY_Thai_lakkhangyao, "XKB_KEY_Thai_lakkhangyao" );
	#endif
	#ifdef XKB_KEY_Thai_maiyamok
		swigIntConstant( XKB_KEY_Thai_maiyamok, "XKB_KEY_Thai_maiyamok" );
	#endif
	#ifdef XKB_KEY_Thai_maitaikhu
		swigIntConstant( XKB_KEY_Thai_maitaikhu, "XKB_KEY_Thai_maitaikhu" );
	#endif
	#ifdef XKB_KEY_Thai_maiek
		swigIntConstant( XKB_KEY_Thai_maiek, "XKB_KEY_Thai_maiek" );
	#endif
	#ifdef XKB_KEY_Thai_maitho
		swigIntConstant( XKB_KEY_Thai_maitho, "XKB_KEY_Thai_maitho" );
	#endif
	#ifdef XKB_KEY_Thai_maitri
		swigIntConstant( XKB_KEY_Thai_maitri, "XKB_KEY_Thai_maitri" );
	#endif
	#ifdef XKB_KEY_Thai_maichattawa
		swigIntConstant( XKB_KEY_Thai_maichattawa, "XKB_KEY_Thai_maichattawa" );
	#endif
	#ifdef XKB_KEY_Thai_thanthakhat
		swigIntConstant( XKB_KEY_Thai_thanthakhat, "XKB_KEY_Thai_thanthakhat" );
	#endif
	#ifdef XKB_KEY_Thai_nikhahit
		swigIntConstant( XKB_KEY_Thai_nikhahit, "XKB_KEY_Thai_nikhahit" );
	#endif
	#ifdef XKB_KEY_Thai_leksun
		swigIntConstant( XKB_KEY_Thai_leksun, "XKB_KEY_Thai_leksun" );
	#endif
	#ifdef XKB_KEY_Thai_leknung
		swigIntConstant( XKB_KEY_Thai_leknung, "XKB_KEY_Thai_leknung" );
	#endif
	#ifdef XKB_KEY_Thai_leksong
		swigIntConstant( XKB_KEY_Thai_leksong, "XKB_KEY_Thai_leksong" );
	#endif
	#ifdef XKB_KEY_Thai_leksam
		swigIntConstant( XKB_KEY_Thai_leksam, "XKB_KEY_Thai_leksam" );
	#endif
	#ifdef XKB_KEY_Thai_leksi
		swigIntConstant( XKB_KEY_Thai_leksi, "XKB_KEY_Thai_leksi" );
	#endif
	#ifdef XKB_KEY_Thai_lekha
		swigIntConstant( XKB_KEY_Thai_lekha, "XKB_KEY_Thai_lekha" );
	#endif
	#ifdef XKB_KEY_Thai_lekhok
		swigIntConstant( XKB_KEY_Thai_lekhok, "XKB_KEY_Thai_lekhok" );
	#endif
	#ifdef XKB_KEY_Thai_lekchet
		swigIntConstant( XKB_KEY_Thai_lekchet, "XKB_KEY_Thai_lekchet" );
	#endif
	#ifdef XKB_KEY_Thai_lekpaet
		swigIntConstant( XKB_KEY_Thai_lekpaet, "XKB_KEY_Thai_lekpaet" );
	#endif
	#ifdef XKB_KEY_Thai_lekkao
		swigIntConstant( XKB_KEY_Thai_lekkao, "XKB_KEY_Thai_lekkao" );
	#endif
	#ifdef XKB_KEY_Hangul
		swigIntConstant( XKB_KEY_Hangul, "XKB_KEY_Hangul" );
	#endif
	#ifdef XKB_KEY_Hangul_Start
		swigIntConstant( XKB_KEY_Hangul_Start, "XKB_KEY_Hangul_Start" );
	#endif
	#ifdef XKB_KEY_Hangul_End
		swigIntConstant( XKB_KEY_Hangul_End, "XKB_KEY_Hangul_End" );
	#endif
	#ifdef XKB_KEY_Hangul_Hanja
		swigIntConstant( XKB_KEY_Hangul_Hanja, "XKB_KEY_Hangul_Hanja" );
	#endif
	#ifdef XKB_KEY_Hangul_Jamo
		swigIntConstant( XKB_KEY_Hangul_Jamo, "XKB_KEY_Hangul_Jamo" );
	#endif
	#ifdef XKB_KEY_Hangul_Romaja
		swigIntConstant( XKB_KEY_Hangul_Romaja, "XKB_KEY_Hangul_Romaja" );
	#endif
	#ifdef XKB_KEY_Hangul_Codeinput
		swigIntConstant( XKB_KEY_Hangul_Codeinput, "XKB_KEY_Hangul_Codeinput" );
	#endif
	#ifdef XKB_KEY_Hangul_Jeonja
		swigIntConstant( XKB_KEY_Hangul_Jeonja, "XKB_KEY_Hangul_Jeonja" );
	#endif
	#ifdef XKB_KEY_Hangul_Banja
		swigIntConstant( XKB_KEY_Hangul_Banja, "XKB_KEY_Hangul_Banja" );
	#endif
	#ifdef XKB_KEY_Hangul_PreHanja
		swigIntConstant( XKB_KEY_Hangul_PreHanja, "XKB_KEY_Hangul_PreHanja" );
	#endif
	#ifdef XKB_KEY_Hangul_PostHanja
		swigIntConstant( XKB_KEY_Hangul_PostHanja, "XKB_KEY_Hangul_PostHanja" );
	#endif
	#ifdef XKB_KEY_Hangul_SingleCandidate
		swigIntConstant( XKB_KEY_Hangul_SingleCandidate, "XKB_KEY_Hangul_SingleCandidate" );
	#endif
	#ifdef XKB_KEY_Hangul_MultipleCandidate
		swigIntConstant( XKB_KEY_Hangul_MultipleCandidate, "XKB_KEY_Hangul_MultipleCandidate" );
	#endif
	#ifdef XKB_KEY_Hangul_PreviousCandidate
		swigIntConstant( XKB_KEY_Hangul_PreviousCandidate, "XKB_KEY_Hangul_PreviousCandidate" );
	#endif
	#ifdef XKB_KEY_Hangul_Special
		swigIntConstant( XKB_KEY_Hangul_Special, "XKB_KEY_Hangul_Special" );
	#endif
	#ifdef XKB_KEY_Hangul_switch
		swigIntConstant( XKB_KEY_Hangul_switch, "XKB_KEY_Hangul_switch" );
	#endif
	#ifdef XKB_KEY_Hangul_Kiyeog
		swigIntConstant( XKB_KEY_Hangul_Kiyeog, "XKB_KEY_Hangul_Kiyeog" );
	#endif
	#ifdef XKB_KEY_Hangul_SsangKiyeog
		swigIntConstant( XKB_KEY_Hangul_SsangKiyeog, "XKB_KEY_Hangul_SsangKiyeog" );
	#endif
	#ifdef XKB_KEY_Hangul_KiyeogSios
		swigIntConstant( XKB_KEY_Hangul_KiyeogSios, "XKB_KEY_Hangul_KiyeogSios" );
	#endif
	#ifdef XKB_KEY_Hangul_Nieun
		swigIntConstant( XKB_KEY_Hangul_Nieun, "XKB_KEY_Hangul_Nieun" );
	#endif
	#ifdef XKB_KEY_Hangul_NieunJieuj
		swigIntConstant( XKB_KEY_Hangul_NieunJieuj, "XKB_KEY_Hangul_NieunJieuj" );
	#endif
	#ifdef XKB_KEY_Hangul_NieunHieuh
		swigIntConstant( XKB_KEY_Hangul_NieunHieuh, "XKB_KEY_Hangul_NieunHieuh" );
	#endif
	#ifdef XKB_KEY_Hangul_Dikeud
		swigIntConstant( XKB_KEY_Hangul_Dikeud, "XKB_KEY_Hangul_Dikeud" );
	#endif
	#ifdef XKB_KEY_Hangul_SsangDikeud
		swigIntConstant( XKB_KEY_Hangul_SsangDikeud, "XKB_KEY_Hangul_SsangDikeud" );
	#endif
	#ifdef XKB_KEY_Hangul_Rieul
		swigIntConstant( XKB_KEY_Hangul_Rieul, "XKB_KEY_Hangul_Rieul" );
	#endif
	#ifdef XKB_KEY_Hangul_RieulKiyeog
		swigIntConstant( XKB_KEY_Hangul_RieulKiyeog, "XKB_KEY_Hangul_RieulKiyeog" );
	#endif
	#ifdef XKB_KEY_Hangul_RieulMieum
		swigIntConstant( XKB_KEY_Hangul_RieulMieum, "XKB_KEY_Hangul_RieulMieum" );
	#endif
	#ifdef XKB_KEY_Hangul_RieulPieub
		swigIntConstant( XKB_KEY_Hangul_RieulPieub, "XKB_KEY_Hangul_RieulPieub" );
	#endif
	#ifdef XKB_KEY_Hangul_RieulSios
		swigIntConstant( XKB_KEY_Hangul_RieulSios, "XKB_KEY_Hangul_RieulSios" );
	#endif
	#ifdef XKB_KEY_Hangul_RieulTieut
		swigIntConstant( XKB_KEY_Hangul_RieulTieut, "XKB_KEY_Hangul_RieulTieut" );
	#endif
	#ifdef XKB_KEY_Hangul_RieulPhieuf
		swigIntConstant( XKB_KEY_Hangul_RieulPhieuf, "XKB_KEY_Hangul_RieulPhieuf" );
	#endif
	#ifdef XKB_KEY_Hangul_RieulHieuh
		swigIntConstant( XKB_KEY_Hangul_RieulHieuh, "XKB_KEY_Hangul_RieulHieuh" );
	#endif
	#ifdef XKB_KEY_Hangul_Mieum
		swigIntConstant( XKB_KEY_Hangul_Mieum, "XKB_KEY_Hangul_Mieum" );
	#endif
	#ifdef XKB_KEY_Hangul_Pieub
		swigIntConstant( XKB_KEY_Hangul_Pieub, "XKB_KEY_Hangul_Pieub" );
	#endif
	#ifdef XKB_KEY_Hangul_SsangPieub
		swigIntConstant( XKB_KEY_Hangul_SsangPieub, "XKB_KEY_Hangul_SsangPieub" );
	#endif
	#ifdef XKB_KEY_Hangul_PieubSios
		swigIntConstant( XKB_KEY_Hangul_PieubSios, "XKB_KEY_Hangul_PieubSios" );
	#endif
	#ifdef XKB_KEY_Hangul_Sios
		swigIntConstant( XKB_KEY_Hangul_Sios, "XKB_KEY_Hangul_Sios" );
	#endif
	#ifdef XKB_KEY_Hangul_SsangSios
		swigIntConstant( XKB_KEY_Hangul_SsangSios, "XKB_KEY_Hangul_SsangSios" );
	#endif
	#ifdef XKB_KEY_Hangul_Ieung
		swigIntConstant( XKB_KEY_Hangul_Ieung, "XKB_KEY_Hangul_Ieung" );
	#endif
	#ifdef XKB_KEY_Hangul_Jieuj
		swigIntConstant( XKB_KEY_Hangul_Jieuj, "XKB_KEY_Hangul_Jieuj" );
	#endif
	#ifdef XKB_KEY_Hangul_SsangJieuj
		swigIntConstant( XKB_KEY_Hangul_SsangJieuj, "XKB_KEY_Hangul_SsangJieuj" );
	#endif
	#ifdef XKB_KEY_Hangul_Cieuc
		swigIntConstant( XKB_KEY_Hangul_Cieuc, "XKB_KEY_Hangul_Cieuc" );
	#endif
	#ifdef XKB_KEY_Hangul_Khieuq
		swigIntConstant( XKB_KEY_Hangul_Khieuq, "XKB_KEY_Hangul_Khieuq" );
	#endif
	#ifdef XKB_KEY_Hangul_Tieut
		swigIntConstant( XKB_KEY_Hangul_Tieut, "XKB_KEY_Hangul_Tieut" );
	#endif
	#ifdef XKB_KEY_Hangul_Phieuf
		swigIntConstant( XKB_KEY_Hangul_Phieuf, "XKB_KEY_Hangul_Phieuf" );
	#endif
	#ifdef XKB_KEY_Hangul_Hieuh
		swigIntConstant( XKB_KEY_Hangul_Hieuh, "XKB_KEY_Hangul_Hieuh" );
	#endif
	#ifdef XKB_KEY_Hangul_A
		swigIntConstant( XKB_KEY_Hangul_A, "XKB_KEY_Hangul_A" );
	#endif
	#ifdef XKB_KEY_Hangul_AE
		swigIntConstant( XKB_KEY_Hangul_AE, "XKB_KEY_Hangul_AE" );
	#endif
	#ifdef XKB_KEY_Hangul_YA
		swigIntConstant( XKB_KEY_Hangul_YA, "XKB_KEY_Hangul_YA" );
	#endif
	#ifdef XKB_KEY_Hangul_YAE
		swigIntConstant( XKB_KEY_Hangul_YAE, "XKB_KEY_Hangul_YAE" );
	#endif
	#ifdef XKB_KEY_Hangul_EO
		swigIntConstant( XKB_KEY_Hangul_EO, "XKB_KEY_Hangul_EO" );
	#endif
	#ifdef XKB_KEY_Hangul_E
		swigIntConstant( XKB_KEY_Hangul_E, "XKB_KEY_Hangul_E" );
	#endif
	#ifdef XKB_KEY_Hangul_YEO
		swigIntConstant( XKB_KEY_Hangul_YEO, "XKB_KEY_Hangul_YEO" );
	#endif
	#ifdef XKB_KEY_Hangul_YE
		swigIntConstant( XKB_KEY_Hangul_YE, "XKB_KEY_Hangul_YE" );
	#endif
	#ifdef XKB_KEY_Hangul_O
		swigIntConstant( XKB_KEY_Hangul_O, "XKB_KEY_Hangul_O" );
	#endif
	#ifdef XKB_KEY_Hangul_WA
		swigIntConstant( XKB_KEY_Hangul_WA, "XKB_KEY_Hangul_WA" );
	#endif
	#ifdef XKB_KEY_Hangul_WAE
		swigIntConstant( XKB_KEY_Hangul_WAE, "XKB_KEY_Hangul_WAE" );
	#endif
	#ifdef XKB_KEY_Hangul_OE
		swigIntConstant( XKB_KEY_Hangul_OE, "XKB_KEY_Hangul_OE" );
	#endif
	#ifdef XKB_KEY_Hangul_YO
		swigIntConstant( XKB_KEY_Hangul_YO, "XKB_KEY_Hangul_YO" );
	#endif
	#ifdef XKB_KEY_Hangul_U
		swigIntConstant( XKB_KEY_Hangul_U, "XKB_KEY_Hangul_U" );
	#endif
	#ifdef XKB_KEY_Hangul_WEO
		swigIntConstant( XKB_KEY_Hangul_WEO, "XKB_KEY_Hangul_WEO" );
	#endif
	#ifdef XKB_KEY_Hangul_WE
		swigIntConstant( XKB_KEY_Hangul_WE, "XKB_KEY_Hangul_WE" );
	#endif
	#ifdef XKB_KEY_Hangul_WI
		swigIntConstant( XKB_KEY_Hangul_WI, "XKB_KEY_Hangul_WI" );
	#endif
	#ifdef XKB_KEY_Hangul_YU
		swigIntConstant( XKB_KEY_Hangul_YU, "XKB_KEY_Hangul_YU" );
	#endif
	#ifdef XKB_KEY_Hangul_EU
		swigIntConstant( XKB_KEY_Hangul_EU, "XKB_KEY_Hangul_EU" );
	#endif
	#ifdef XKB_KEY_Hangul_YI
		swigIntConstant( XKB_KEY_Hangul_YI, "XKB_KEY_Hangul_YI" );
	#endif
	#ifdef XKB_KEY_Hangul_I
		swigIntConstant( XKB_KEY_Hangul_I, "XKB_KEY_Hangul_I" );
	#endif
	#ifdef XKB_KEY_Hangul_J_Kiyeog
		swigIntConstant( XKB_KEY_Hangul_J_Kiyeog, "XKB_KEY_Hangul_J_Kiyeog" );
	#endif
	#ifdef XKB_KEY_Hangul_J_SsangKiyeog
		swigIntConstant( XKB_KEY_Hangul_J_SsangKiyeog, "XKB_KEY_Hangul_J_SsangKiyeog" );
	#endif
	#ifdef XKB_KEY_Hangul_J_KiyeogSios
		swigIntConstant( XKB_KEY_Hangul_J_KiyeogSios, "XKB_KEY_Hangul_J_KiyeogSios" );
	#endif
	#ifdef XKB_KEY_Hangul_J_Nieun
		swigIntConstant( XKB_KEY_Hangul_J_Nieun, "XKB_KEY_Hangul_J_Nieun" );
	#endif
	#ifdef XKB_KEY_Hangul_J_NieunJieuj
		swigIntConstant( XKB_KEY_Hangul_J_NieunJieuj, "XKB_KEY_Hangul_J_NieunJieuj" );
	#endif
	#ifdef XKB_KEY_Hangul_J_NieunHieuh
		swigIntConstant( XKB_KEY_Hangul_J_NieunHieuh, "XKB_KEY_Hangul_J_NieunHieuh" );
	#endif
	#ifdef XKB_KEY_Hangul_J_Dikeud
		swigIntConstant( XKB_KEY_Hangul_J_Dikeud, "XKB_KEY_Hangul_J_Dikeud" );
	#endif
	#ifdef XKB_KEY_Hangul_J_Rieul
		swigIntConstant( XKB_KEY_Hangul_J_Rieul, "XKB_KEY_Hangul_J_Rieul" );
	#endif
	#ifdef XKB_KEY_Hangul_J_RieulKiyeog
		swigIntConstant( XKB_KEY_Hangul_J_RieulKiyeog, "XKB_KEY_Hangul_J_RieulKiyeog" );
	#endif
	#ifdef XKB_KEY_Hangul_J_RieulMieum
		swigIntConstant( XKB_KEY_Hangul_J_RieulMieum, "XKB_KEY_Hangul_J_RieulMieum" );
	#endif
	#ifdef XKB_KEY_Hangul_J_RieulPieub
		swigIntConstant( XKB_KEY_Hangul_J_RieulPieub, "XKB_KEY_Hangul_J_RieulPieub" );
	#endif
	#ifdef XKB_KEY_Hangul_J_RieulSios
		swigIntConstant( XKB_KEY_Hangul_J_RieulSios, "XKB_KEY_Hangul_J_RieulSios" );
	#endif
	#ifdef XKB_KEY_Hangul_J_RieulTieut
		swigIntConstant( XKB_KEY_Hangul_J_RieulTieut, "XKB_KEY_Hangul_J_RieulTieut" );
	#endif
	#ifdef XKB_KEY_Hangul_J_RieulPhieuf
		swigIntConstant( XKB_KEY_Hangul_J_RieulPhieuf, "XKB_KEY_Hangul_J_RieulPhieuf" );
	#endif
	#ifdef XKB_KEY_Hangul_J_RieulHieuh
		swigIntConstant( XKB_KEY_Hangul_J_RieulHieuh, "XKB_KEY_Hangul_J_RieulHieuh" );
	#endif
	#ifdef XKB_KEY_Hangul_J_Mieum
		swigIntConstant( XKB_KEY_Hangul_J_Mieum, "XKB_KEY_Hangul_J_Mieum" );
	#endif
	#ifdef XKB_KEY_Hangul_J_Pieub
		swigIntConstant( XKB_KEY_Hangul_J_Pieub, "XKB_KEY_Hangul_J_Pieub" );
	#endif
	#ifdef XKB_KEY_Hangul_J_PieubSios
		swigIntConstant( XKB_KEY_Hangul_J_PieubSios, "XKB_KEY_Hangul_J_PieubSios" );
	#endif
	#ifdef XKB_KEY_Hangul_J_Sios
		swigIntConstant( XKB_KEY_Hangul_J_Sios, "XKB_KEY_Hangul_J_Sios" );
	#endif
	#ifdef XKB_KEY_Hangul_J_SsangSios
		swigIntConstant( XKB_KEY_Hangul_J_SsangSios, "XKB_KEY_Hangul_J_SsangSios" );
	#endif
	#ifdef XKB_KEY_Hangul_J_Ieung
		swigIntConstant( XKB_KEY_Hangul_J_Ieung, "XKB_KEY_Hangul_J_Ieung" );
	#endif
	#ifdef XKB_KEY_Hangul_J_Jieuj
		swigIntConstant( XKB_KEY_Hangul_J_Jieuj, "XKB_KEY_Hangul_J_Jieuj" );
	#endif
	#ifdef XKB_KEY_Hangul_J_Cieuc
		swigIntConstant( XKB_KEY_Hangul_J_Cieuc, "XKB_KEY_Hangul_J_Cieuc" );
	#endif
	#ifdef XKB_KEY_Hangul_J_Khieuq
		swigIntConstant( XKB_KEY_Hangul_J_Khieuq, "XKB_KEY_Hangul_J_Khieuq" );
	#endif
	#ifdef XKB_KEY_Hangul_J_Tieut
		swigIntConstant( XKB_KEY_Hangul_J_Tieut, "XKB_KEY_Hangul_J_Tieut" );
	#endif
	#ifdef XKB_KEY_Hangul_J_Phieuf
		swigIntConstant( XKB_KEY_Hangul_J_Phieuf, "XKB_KEY_Hangul_J_Phieuf" );
	#endif
	#ifdef XKB_KEY_Hangul_J_Hieuh
		swigIntConstant( XKB_KEY_Hangul_J_Hieuh, "XKB_KEY_Hangul_J_Hieuh" );
	#endif
	#ifdef XKB_KEY_Hangul_RieulYeorinHieuh
		swigIntConstant( XKB_KEY_Hangul_RieulYeorinHieuh, "XKB_KEY_Hangul_RieulYeorinHieuh" );
	#endif
	#ifdef XKB_KEY_Hangul_SunkyeongeumMieum
		swigIntConstant( XKB_KEY_Hangul_SunkyeongeumMieum, "XKB_KEY_Hangul_SunkyeongeumMieum" );
	#endif
	#ifdef XKB_KEY_Hangul_SunkyeongeumPieub
		swigIntConstant( XKB_KEY_Hangul_SunkyeongeumPieub, "XKB_KEY_Hangul_SunkyeongeumPieub" );
	#endif
	#ifdef XKB_KEY_Hangul_PanSios
		swigIntConstant( XKB_KEY_Hangul_PanSios, "XKB_KEY_Hangul_PanSios" );
	#endif
	#ifdef XKB_KEY_Hangul_KkogjiDalrinIeung
		swigIntConstant( XKB_KEY_Hangul_KkogjiDalrinIeung, "XKB_KEY_Hangul_KkogjiDalrinIeung" );
	#endif
	#ifdef XKB_KEY_Hangul_SunkyeongeumPhieuf
		swigIntConstant( XKB_KEY_Hangul_SunkyeongeumPhieuf, "XKB_KEY_Hangul_SunkyeongeumPhieuf" );
	#endif
	#ifdef XKB_KEY_Hangul_YeorinHieuh
		swigIntConstant( XKB_KEY_Hangul_YeorinHieuh, "XKB_KEY_Hangul_YeorinHieuh" );
	#endif
	#ifdef XKB_KEY_Hangul_AraeA
		swigIntConstant( XKB_KEY_Hangul_AraeA, "XKB_KEY_Hangul_AraeA" );
	#endif
	#ifdef XKB_KEY_Hangul_AraeAE
		swigIntConstant( XKB_KEY_Hangul_AraeAE, "XKB_KEY_Hangul_AraeAE" );
	#endif
	#ifdef XKB_KEY_Hangul_J_PanSios
		swigIntConstant( XKB_KEY_Hangul_J_PanSios, "XKB_KEY_Hangul_J_PanSios" );
	#endif
	#ifdef XKB_KEY_Hangul_J_KkogjiDalrinIeung
		swigIntConstant( XKB_KEY_Hangul_J_KkogjiDalrinIeung, "XKB_KEY_Hangul_J_KkogjiDalrinIeung" );
	#endif
	#ifdef XKB_KEY_Hangul_J_YeorinHieuh
		swigIntConstant( XKB_KEY_Hangul_J_YeorinHieuh, "XKB_KEY_Hangul_J_YeorinHieuh" );
	#endif
	#ifdef XKB_KEY_Korean_Won
		swigIntConstant( XKB_KEY_Korean_Won, "XKB_KEY_Korean_Won" );
	#endif
	#ifdef XKB_KEY_Armenian_ligature_ew
		swigIntConstant( XKB_KEY_Armenian_ligature_ew, "XKB_KEY_Armenian_ligature_ew" );
	#endif
	#ifdef XKB_KEY_Armenian_full_stop
		swigIntConstant( XKB_KEY_Armenian_full_stop, "XKB_KEY_Armenian_full_stop" );
	#endif
	#ifdef XKB_KEY_Armenian_verjaket
		swigIntConstant( XKB_KEY_Armenian_verjaket, "XKB_KEY_Armenian_verjaket" );
	#endif
	#ifdef XKB_KEY_Armenian_separation_mark
		swigIntConstant( XKB_KEY_Armenian_separation_mark, "XKB_KEY_Armenian_separation_mark" );
	#endif
	#ifdef XKB_KEY_Armenian_but
		swigIntConstant( XKB_KEY_Armenian_but, "XKB_KEY_Armenian_but" );
	#endif
	#ifdef XKB_KEY_Armenian_hyphen
		swigIntConstant( XKB_KEY_Armenian_hyphen, "XKB_KEY_Armenian_hyphen" );
	#endif
	#ifdef XKB_KEY_Armenian_yentamna
		swigIntConstant( XKB_KEY_Armenian_yentamna, "XKB_KEY_Armenian_yentamna" );
	#endif
	#ifdef XKB_KEY_Armenian_exclam
		swigIntConstant( XKB_KEY_Armenian_exclam, "XKB_KEY_Armenian_exclam" );
	#endif
	#ifdef XKB_KEY_Armenian_amanak
		swigIntConstant( XKB_KEY_Armenian_amanak, "XKB_KEY_Armenian_amanak" );
	#endif
	#ifdef XKB_KEY_Armenian_accent
		swigIntConstant( XKB_KEY_Armenian_accent, "XKB_KEY_Armenian_accent" );
	#endif
	#ifdef XKB_KEY_Armenian_shesht
		swigIntConstant( XKB_KEY_Armenian_shesht, "XKB_KEY_Armenian_shesht" );
	#endif
	#ifdef XKB_KEY_Armenian_question
		swigIntConstant( XKB_KEY_Armenian_question, "XKB_KEY_Armenian_question" );
	#endif
	#ifdef XKB_KEY_Armenian_paruyk
		swigIntConstant( XKB_KEY_Armenian_paruyk, "XKB_KEY_Armenian_paruyk" );
	#endif
	#ifdef XKB_KEY_Armenian_AYB
		swigIntConstant( XKB_KEY_Armenian_AYB, "XKB_KEY_Armenian_AYB" );
	#endif
	#ifdef XKB_KEY_Armenian_ayb
		swigIntConstant( XKB_KEY_Armenian_ayb, "XKB_KEY_Armenian_ayb" );
	#endif
	#ifdef XKB_KEY_Armenian_BEN
		swigIntConstant( XKB_KEY_Armenian_BEN, "XKB_KEY_Armenian_BEN" );
	#endif
	#ifdef XKB_KEY_Armenian_ben
		swigIntConstant( XKB_KEY_Armenian_ben, "XKB_KEY_Armenian_ben" );
	#endif
	#ifdef XKB_KEY_Armenian_GIM
		swigIntConstant( XKB_KEY_Armenian_GIM, "XKB_KEY_Armenian_GIM" );
	#endif
	#ifdef XKB_KEY_Armenian_gim
		swigIntConstant( XKB_KEY_Armenian_gim, "XKB_KEY_Armenian_gim" );
	#endif
	#ifdef XKB_KEY_Armenian_DA
		swigIntConstant( XKB_KEY_Armenian_DA, "XKB_KEY_Armenian_DA" );
	#endif
	#ifdef XKB_KEY_Armenian_da
		swigIntConstant( XKB_KEY_Armenian_da, "XKB_KEY_Armenian_da" );
	#endif
	#ifdef XKB_KEY_Armenian_YECH
		swigIntConstant( XKB_KEY_Armenian_YECH, "XKB_KEY_Armenian_YECH" );
	#endif
	#ifdef XKB_KEY_Armenian_yech
		swigIntConstant( XKB_KEY_Armenian_yech, "XKB_KEY_Armenian_yech" );
	#endif
	#ifdef XKB_KEY_Armenian_ZA
		swigIntConstant( XKB_KEY_Armenian_ZA, "XKB_KEY_Armenian_ZA" );
	#endif
	#ifdef XKB_KEY_Armenian_za
		swigIntConstant( XKB_KEY_Armenian_za, "XKB_KEY_Armenian_za" );
	#endif
	#ifdef XKB_KEY_Armenian_E
		swigIntConstant( XKB_KEY_Armenian_E, "XKB_KEY_Armenian_E" );
	#endif
	#ifdef XKB_KEY_Armenian_e
		swigIntConstant( XKB_KEY_Armenian_e, "XKB_KEY_Armenian_e" );
	#endif
	#ifdef XKB_KEY_Armenian_AT
		swigIntConstant( XKB_KEY_Armenian_AT, "XKB_KEY_Armenian_AT" );
	#endif
	#ifdef XKB_KEY_Armenian_at
		swigIntConstant( XKB_KEY_Armenian_at, "XKB_KEY_Armenian_at" );
	#endif
	#ifdef XKB_KEY_Armenian_TO
		swigIntConstant( XKB_KEY_Armenian_TO, "XKB_KEY_Armenian_TO" );
	#endif
	#ifdef XKB_KEY_Armenian_to
		swigIntConstant( XKB_KEY_Armenian_to, "XKB_KEY_Armenian_to" );
	#endif
	#ifdef XKB_KEY_Armenian_ZHE
		swigIntConstant( XKB_KEY_Armenian_ZHE, "XKB_KEY_Armenian_ZHE" );
	#endif
	#ifdef XKB_KEY_Armenian_zhe
		swigIntConstant( XKB_KEY_Armenian_zhe, "XKB_KEY_Armenian_zhe" );
	#endif
	#ifdef XKB_KEY_Armenian_INI
		swigIntConstant( XKB_KEY_Armenian_INI, "XKB_KEY_Armenian_INI" );
	#endif
	#ifdef XKB_KEY_Armenian_ini
		swigIntConstant( XKB_KEY_Armenian_ini, "XKB_KEY_Armenian_ini" );
	#endif
	#ifdef XKB_KEY_Armenian_LYUN
		swigIntConstant( XKB_KEY_Armenian_LYUN, "XKB_KEY_Armenian_LYUN" );
	#endif
	#ifdef XKB_KEY_Armenian_lyun
		swigIntConstant( XKB_KEY_Armenian_lyun, "XKB_KEY_Armenian_lyun" );
	#endif
	#ifdef XKB_KEY_Armenian_KHE
		swigIntConstant( XKB_KEY_Armenian_KHE, "XKB_KEY_Armenian_KHE" );
	#endif
	#ifdef XKB_KEY_Armenian_khe
		swigIntConstant( XKB_KEY_Armenian_khe, "XKB_KEY_Armenian_khe" );
	#endif
	#ifdef XKB_KEY_Armenian_TSA
		swigIntConstant( XKB_KEY_Armenian_TSA, "XKB_KEY_Armenian_TSA" );
	#endif
	#ifdef XKB_KEY_Armenian_tsa
		swigIntConstant( XKB_KEY_Armenian_tsa, "XKB_KEY_Armenian_tsa" );
	#endif
	#ifdef XKB_KEY_Armenian_KEN
		swigIntConstant( XKB_KEY_Armenian_KEN, "XKB_KEY_Armenian_KEN" );
	#endif
	#ifdef XKB_KEY_Armenian_ken
		swigIntConstant( XKB_KEY_Armenian_ken, "XKB_KEY_Armenian_ken" );
	#endif
	#ifdef XKB_KEY_Armenian_HO
		swigIntConstant( XKB_KEY_Armenian_HO, "XKB_KEY_Armenian_HO" );
	#endif
	#ifdef XKB_KEY_Armenian_ho
		swigIntConstant( XKB_KEY_Armenian_ho, "XKB_KEY_Armenian_ho" );
	#endif
	#ifdef XKB_KEY_Armenian_DZA
		swigIntConstant( XKB_KEY_Armenian_DZA, "XKB_KEY_Armenian_DZA" );
	#endif
	#ifdef XKB_KEY_Armenian_dza
		swigIntConstant( XKB_KEY_Armenian_dza, "XKB_KEY_Armenian_dza" );
	#endif
	#ifdef XKB_KEY_Armenian_GHAT
		swigIntConstant( XKB_KEY_Armenian_GHAT, "XKB_KEY_Armenian_GHAT" );
	#endif
	#ifdef XKB_KEY_Armenian_ghat
		swigIntConstant( XKB_KEY_Armenian_ghat, "XKB_KEY_Armenian_ghat" );
	#endif
	#ifdef XKB_KEY_Armenian_TCHE
		swigIntConstant( XKB_KEY_Armenian_TCHE, "XKB_KEY_Armenian_TCHE" );
	#endif
	#ifdef XKB_KEY_Armenian_tche
		swigIntConstant( XKB_KEY_Armenian_tche, "XKB_KEY_Armenian_tche" );
	#endif
	#ifdef XKB_KEY_Armenian_MEN
		swigIntConstant( XKB_KEY_Armenian_MEN, "XKB_KEY_Armenian_MEN" );
	#endif
	#ifdef XKB_KEY_Armenian_men
		swigIntConstant( XKB_KEY_Armenian_men, "XKB_KEY_Armenian_men" );
	#endif
	#ifdef XKB_KEY_Armenian_HI
		swigIntConstant( XKB_KEY_Armenian_HI, "XKB_KEY_Armenian_HI" );
	#endif
	#ifdef XKB_KEY_Armenian_hi
		swigIntConstant( XKB_KEY_Armenian_hi, "XKB_KEY_Armenian_hi" );
	#endif
	#ifdef XKB_KEY_Armenian_NU
		swigIntConstant( XKB_KEY_Armenian_NU, "XKB_KEY_Armenian_NU" );
	#endif
	#ifdef XKB_KEY_Armenian_nu
		swigIntConstant( XKB_KEY_Armenian_nu, "XKB_KEY_Armenian_nu" );
	#endif
	#ifdef XKB_KEY_Armenian_SHA
		swigIntConstant( XKB_KEY_Armenian_SHA, "XKB_KEY_Armenian_SHA" );
	#endif
	#ifdef XKB_KEY_Armenian_sha
		swigIntConstant( XKB_KEY_Armenian_sha, "XKB_KEY_Armenian_sha" );
	#endif
	#ifdef XKB_KEY_Armenian_VO
		swigIntConstant( XKB_KEY_Armenian_VO, "XKB_KEY_Armenian_VO" );
	#endif
	#ifdef XKB_KEY_Armenian_vo
		swigIntConstant( XKB_KEY_Armenian_vo, "XKB_KEY_Armenian_vo" );
	#endif
	#ifdef XKB_KEY_Armenian_CHA
		swigIntConstant( XKB_KEY_Armenian_CHA, "XKB_KEY_Armenian_CHA" );
	#endif
	#ifdef XKB_KEY_Armenian_cha
		swigIntConstant( XKB_KEY_Armenian_cha, "XKB_KEY_Armenian_cha" );
	#endif
	#ifdef XKB_KEY_Armenian_PE
		swigIntConstant( XKB_KEY_Armenian_PE, "XKB_KEY_Armenian_PE" );
	#endif
	#ifdef XKB_KEY_Armenian_pe
		swigIntConstant( XKB_KEY_Armenian_pe, "XKB_KEY_Armenian_pe" );
	#endif
	#ifdef XKB_KEY_Armenian_JE
		swigIntConstant( XKB_KEY_Armenian_JE, "XKB_KEY_Armenian_JE" );
	#endif
	#ifdef XKB_KEY_Armenian_je
		swigIntConstant( XKB_KEY_Armenian_je, "XKB_KEY_Armenian_je" );
	#endif
	#ifdef XKB_KEY_Armenian_RA
		swigIntConstant( XKB_KEY_Armenian_RA, "XKB_KEY_Armenian_RA" );
	#endif
	#ifdef XKB_KEY_Armenian_ra
		swigIntConstant( XKB_KEY_Armenian_ra, "XKB_KEY_Armenian_ra" );
	#endif
	#ifdef XKB_KEY_Armenian_SE
		swigIntConstant( XKB_KEY_Armenian_SE, "XKB_KEY_Armenian_SE" );
	#endif
	#ifdef XKB_KEY_Armenian_se
		swigIntConstant( XKB_KEY_Armenian_se, "XKB_KEY_Armenian_se" );
	#endif
	#ifdef XKB_KEY_Armenian_VEV
		swigIntConstant( XKB_KEY_Armenian_VEV, "XKB_KEY_Armenian_VEV" );
	#endif
	#ifdef XKB_KEY_Armenian_vev
		swigIntConstant( XKB_KEY_Armenian_vev, "XKB_KEY_Armenian_vev" );
	#endif
	#ifdef XKB_KEY_Armenian_TYUN
		swigIntConstant( XKB_KEY_Armenian_TYUN, "XKB_KEY_Armenian_TYUN" );
	#endif
	#ifdef XKB_KEY_Armenian_tyun
		swigIntConstant( XKB_KEY_Armenian_tyun, "XKB_KEY_Armenian_tyun" );
	#endif
	#ifdef XKB_KEY_Armenian_RE
		swigIntConstant( XKB_KEY_Armenian_RE, "XKB_KEY_Armenian_RE" );
	#endif
	#ifdef XKB_KEY_Armenian_re
		swigIntConstant( XKB_KEY_Armenian_re, "XKB_KEY_Armenian_re" );
	#endif
	#ifdef XKB_KEY_Armenian_TSO
		swigIntConstant( XKB_KEY_Armenian_TSO, "XKB_KEY_Armenian_TSO" );
	#endif
	#ifdef XKB_KEY_Armenian_tso
		swigIntConstant( XKB_KEY_Armenian_tso, "XKB_KEY_Armenian_tso" );
	#endif
	#ifdef XKB_KEY_Armenian_VYUN
		swigIntConstant( XKB_KEY_Armenian_VYUN, "XKB_KEY_Armenian_VYUN" );
	#endif
	#ifdef XKB_KEY_Armenian_vyun
		swigIntConstant( XKB_KEY_Armenian_vyun, "XKB_KEY_Armenian_vyun" );
	#endif
	#ifdef XKB_KEY_Armenian_PYUR
		swigIntConstant( XKB_KEY_Armenian_PYUR, "XKB_KEY_Armenian_PYUR" );
	#endif
	#ifdef XKB_KEY_Armenian_pyur
		swigIntConstant( XKB_KEY_Armenian_pyur, "XKB_KEY_Armenian_pyur" );
	#endif
	#ifdef XKB_KEY_Armenian_KE
		swigIntConstant( XKB_KEY_Armenian_KE, "XKB_KEY_Armenian_KE" );
	#endif
	#ifdef XKB_KEY_Armenian_ke
		swigIntConstant( XKB_KEY_Armenian_ke, "XKB_KEY_Armenian_ke" );
	#endif
	#ifdef XKB_KEY_Armenian_O
		swigIntConstant( XKB_KEY_Armenian_O, "XKB_KEY_Armenian_O" );
	#endif
	#ifdef XKB_KEY_Armenian_o
		swigIntConstant( XKB_KEY_Armenian_o, "XKB_KEY_Armenian_o" );
	#endif
	#ifdef XKB_KEY_Armenian_FE
		swigIntConstant( XKB_KEY_Armenian_FE, "XKB_KEY_Armenian_FE" );
	#endif
	#ifdef XKB_KEY_Armenian_fe
		swigIntConstant( XKB_KEY_Armenian_fe, "XKB_KEY_Armenian_fe" );
	#endif
	#ifdef XKB_KEY_Armenian_apostrophe
		swigIntConstant( XKB_KEY_Armenian_apostrophe, "XKB_KEY_Armenian_apostrophe" );
	#endif
	#ifdef XKB_KEY_Georgian_an
		swigIntConstant( XKB_KEY_Georgian_an, "XKB_KEY_Georgian_an" );
	#endif
	#ifdef XKB_KEY_Georgian_ban
		swigIntConstant( XKB_KEY_Georgian_ban, "XKB_KEY_Georgian_ban" );
	#endif
	#ifdef XKB_KEY_Georgian_gan
		swigIntConstant( XKB_KEY_Georgian_gan, "XKB_KEY_Georgian_gan" );
	#endif
	#ifdef XKB_KEY_Georgian_don
		swigIntConstant( XKB_KEY_Georgian_don, "XKB_KEY_Georgian_don" );
	#endif
	#ifdef XKB_KEY_Georgian_en
		swigIntConstant( XKB_KEY_Georgian_en, "XKB_KEY_Georgian_en" );
	#endif
	#ifdef XKB_KEY_Georgian_vin
		swigIntConstant( XKB_KEY_Georgian_vin, "XKB_KEY_Georgian_vin" );
	#endif
	#ifdef XKB_KEY_Georgian_zen
		swigIntConstant( XKB_KEY_Georgian_zen, "XKB_KEY_Georgian_zen" );
	#endif
	#ifdef XKB_KEY_Georgian_tan
		swigIntConstant( XKB_KEY_Georgian_tan, "XKB_KEY_Georgian_tan" );
	#endif
	#ifdef XKB_KEY_Georgian_in
		swigIntConstant( XKB_KEY_Georgian_in, "XKB_KEY_Georgian_in" );
	#endif
	#ifdef XKB_KEY_Georgian_kan
		swigIntConstant( XKB_KEY_Georgian_kan, "XKB_KEY_Georgian_kan" );
	#endif
	#ifdef XKB_KEY_Georgian_las
		swigIntConstant( XKB_KEY_Georgian_las, "XKB_KEY_Georgian_las" );
	#endif
	#ifdef XKB_KEY_Georgian_man
		swigIntConstant( XKB_KEY_Georgian_man, "XKB_KEY_Georgian_man" );
	#endif
	#ifdef XKB_KEY_Georgian_nar
		swigIntConstant( XKB_KEY_Georgian_nar, "XKB_KEY_Georgian_nar" );
	#endif
	#ifdef XKB_KEY_Georgian_on
		swigIntConstant( XKB_KEY_Georgian_on, "XKB_KEY_Georgian_on" );
	#endif
	#ifdef XKB_KEY_Georgian_par
		swigIntConstant( XKB_KEY_Georgian_par, "XKB_KEY_Georgian_par" );
	#endif
	#ifdef XKB_KEY_Georgian_zhar
		swigIntConstant( XKB_KEY_Georgian_zhar, "XKB_KEY_Georgian_zhar" );
	#endif
	#ifdef XKB_KEY_Georgian_rae
		swigIntConstant( XKB_KEY_Georgian_rae, "XKB_KEY_Georgian_rae" );
	#endif
	#ifdef XKB_KEY_Georgian_san
		swigIntConstant( XKB_KEY_Georgian_san, "XKB_KEY_Georgian_san" );
	#endif
	#ifdef XKB_KEY_Georgian_tar
		swigIntConstant( XKB_KEY_Georgian_tar, "XKB_KEY_Georgian_tar" );
	#endif
	#ifdef XKB_KEY_Georgian_un
		swigIntConstant( XKB_KEY_Georgian_un, "XKB_KEY_Georgian_un" );
	#endif
	#ifdef XKB_KEY_Georgian_phar
		swigIntConstant( XKB_KEY_Georgian_phar, "XKB_KEY_Georgian_phar" );
	#endif
	#ifdef XKB_KEY_Georgian_khar
		swigIntConstant( XKB_KEY_Georgian_khar, "XKB_KEY_Georgian_khar" );
	#endif
	#ifdef XKB_KEY_Georgian_ghan
		swigIntConstant( XKB_KEY_Georgian_ghan, "XKB_KEY_Georgian_ghan" );
	#endif
	#ifdef XKB_KEY_Georgian_qar
		swigIntConstant( XKB_KEY_Georgian_qar, "XKB_KEY_Georgian_qar" );
	#endif
	#ifdef XKB_KEY_Georgian_shin
		swigIntConstant( XKB_KEY_Georgian_shin, "XKB_KEY_Georgian_shin" );
	#endif
	#ifdef XKB_KEY_Georgian_chin
		swigIntConstant( XKB_KEY_Georgian_chin, "XKB_KEY_Georgian_chin" );
	#endif
	#ifdef XKB_KEY_Georgian_can
		swigIntConstant( XKB_KEY_Georgian_can, "XKB_KEY_Georgian_can" );
	#endif
	#ifdef XKB_KEY_Georgian_jil
		swigIntConstant( XKB_KEY_Georgian_jil, "XKB_KEY_Georgian_jil" );
	#endif
	#ifdef XKB_KEY_Georgian_cil
		swigIntConstant( XKB_KEY_Georgian_cil, "XKB_KEY_Georgian_cil" );
	#endif
	#ifdef XKB_KEY_Georgian_char
		swigIntConstant( XKB_KEY_Georgian_char, "XKB_KEY_Georgian_char" );
	#endif
	#ifdef XKB_KEY_Georgian_xan
		swigIntConstant( XKB_KEY_Georgian_xan, "XKB_KEY_Georgian_xan" );
	#endif
	#ifdef XKB_KEY_Georgian_jhan
		swigIntConstant( XKB_KEY_Georgian_jhan, "XKB_KEY_Georgian_jhan" );
	#endif
	#ifdef XKB_KEY_Georgian_hae
		swigIntConstant( XKB_KEY_Georgian_hae, "XKB_KEY_Georgian_hae" );
	#endif
	#ifdef XKB_KEY_Georgian_he
		swigIntConstant( XKB_KEY_Georgian_he, "XKB_KEY_Georgian_he" );
	#endif
	#ifdef XKB_KEY_Georgian_hie
		swigIntConstant( XKB_KEY_Georgian_hie, "XKB_KEY_Georgian_hie" );
	#endif
	#ifdef XKB_KEY_Georgian_we
		swigIntConstant( XKB_KEY_Georgian_we, "XKB_KEY_Georgian_we" );
	#endif
	#ifdef XKB_KEY_Georgian_har
		swigIntConstant( XKB_KEY_Georgian_har, "XKB_KEY_Georgian_har" );
	#endif
	#ifdef XKB_KEY_Georgian_hoe
		swigIntConstant( XKB_KEY_Georgian_hoe, "XKB_KEY_Georgian_hoe" );
	#endif
	#ifdef XKB_KEY_Georgian_fi
		swigIntConstant( XKB_KEY_Georgian_fi, "XKB_KEY_Georgian_fi" );
	#endif
	#ifdef XKB_KEY_Xabovedot
		swigIntConstant( XKB_KEY_Xabovedot, "XKB_KEY_Xabovedot" );
	#endif
	#ifdef XKB_KEY_Ibreve
		swigIntConstant( XKB_KEY_Ibreve, "XKB_KEY_Ibreve" );
	#endif
	#ifdef XKB_KEY_Zstroke
		swigIntConstant( XKB_KEY_Zstroke, "XKB_KEY_Zstroke" );
	#endif
	#ifdef XKB_KEY_Gcaron
		swigIntConstant( XKB_KEY_Gcaron, "XKB_KEY_Gcaron" );
	#endif
	#ifdef XKB_KEY_Ocaron
		swigIntConstant( XKB_KEY_Ocaron, "XKB_KEY_Ocaron" );
	#endif
	#ifdef XKB_KEY_Obarred
		swigIntConstant( XKB_KEY_Obarred, "XKB_KEY_Obarred" );
	#endif
	#ifdef XKB_KEY_xabovedot
		swigIntConstant( XKB_KEY_xabovedot, "XKB_KEY_xabovedot" );
	#endif
	#ifdef XKB_KEY_ibreve
		swigIntConstant( XKB_KEY_ibreve, "XKB_KEY_ibreve" );
	#endif
	#ifdef XKB_KEY_zstroke
		swigIntConstant( XKB_KEY_zstroke, "XKB_KEY_zstroke" );
	#endif
	#ifdef XKB_KEY_gcaron
		swigIntConstant( XKB_KEY_gcaron, "XKB_KEY_gcaron" );
	#endif
	#ifdef XKB_KEY_ocaron
		swigIntConstant( XKB_KEY_ocaron, "XKB_KEY_ocaron" );
	#endif
	#ifdef XKB_KEY_obarred
		swigIntConstant( XKB_KEY_obarred, "XKB_KEY_obarred" );
	#endif
	#ifdef XKB_KEY_SCHWA
		swigIntConstant( XKB_KEY_SCHWA, "XKB_KEY_SCHWA" );
	#endif
	#ifdef XKB_KEY_schwa
		swigIntConstant( XKB_KEY_schwa, "XKB_KEY_schwa" );
	#endif
	#ifdef XKB_KEY_EZH
		swigIntConstant( XKB_KEY_EZH, "XKB_KEY_EZH" );
	#endif
	#ifdef XKB_KEY_ezh
		swigIntConstant( XKB_KEY_ezh, "XKB_KEY_ezh" );
	#endif
	#ifdef XKB_KEY_Lbelowdot
		swigIntConstant( XKB_KEY_Lbelowdot, "XKB_KEY_Lbelowdot" );
	#endif
	#ifdef XKB_KEY_lbelowdot
		swigIntConstant( XKB_KEY_lbelowdot, "XKB_KEY_lbelowdot" );
	#endif
	#ifdef XKB_KEY_Abelowdot
		swigIntConstant( XKB_KEY_Abelowdot, "XKB_KEY_Abelowdot" );
	#endif
	#ifdef XKB_KEY_abelowdot
		swigIntConstant( XKB_KEY_abelowdot, "XKB_KEY_abelowdot" );
	#endif
	#ifdef XKB_KEY_Ahook
		swigIntConstant( XKB_KEY_Ahook, "XKB_KEY_Ahook" );
	#endif
	#ifdef XKB_KEY_ahook
		swigIntConstant( XKB_KEY_ahook, "XKB_KEY_ahook" );
	#endif
	#ifdef XKB_KEY_Acircumflexacute
		swigIntConstant( XKB_KEY_Acircumflexacute, "XKB_KEY_Acircumflexacute" );
	#endif
	#ifdef XKB_KEY_acircumflexacute
		swigIntConstant( XKB_KEY_acircumflexacute, "XKB_KEY_acircumflexacute" );
	#endif
	#ifdef XKB_KEY_Acircumflexgrave
		swigIntConstant( XKB_KEY_Acircumflexgrave, "XKB_KEY_Acircumflexgrave" );
	#endif
	#ifdef XKB_KEY_acircumflexgrave
		swigIntConstant( XKB_KEY_acircumflexgrave, "XKB_KEY_acircumflexgrave" );
	#endif
	#ifdef XKB_KEY_Acircumflexhook
		swigIntConstant( XKB_KEY_Acircumflexhook, "XKB_KEY_Acircumflexhook" );
	#endif
	#ifdef XKB_KEY_acircumflexhook
		swigIntConstant( XKB_KEY_acircumflexhook, "XKB_KEY_acircumflexhook" );
	#endif
	#ifdef XKB_KEY_Acircumflextilde
		swigIntConstant( XKB_KEY_Acircumflextilde, "XKB_KEY_Acircumflextilde" );
	#endif
	#ifdef XKB_KEY_acircumflextilde
		swigIntConstant( XKB_KEY_acircumflextilde, "XKB_KEY_acircumflextilde" );
	#endif
	#ifdef XKB_KEY_Acircumflexbelowdot
		swigIntConstant( XKB_KEY_Acircumflexbelowdot, "XKB_KEY_Acircumflexbelowdot" );
	#endif
	#ifdef XKB_KEY_acircumflexbelowdot
		swigIntConstant( XKB_KEY_acircumflexbelowdot, "XKB_KEY_acircumflexbelowdot" );
	#endif
	#ifdef XKB_KEY_Abreveacute
		swigIntConstant( XKB_KEY_Abreveacute, "XKB_KEY_Abreveacute" );
	#endif
	#ifdef XKB_KEY_abreveacute
		swigIntConstant( XKB_KEY_abreveacute, "XKB_KEY_abreveacute" );
	#endif
	#ifdef XKB_KEY_Abrevegrave
		swigIntConstant( XKB_KEY_Abrevegrave, "XKB_KEY_Abrevegrave" );
	#endif
	#ifdef XKB_KEY_abrevegrave
		swigIntConstant( XKB_KEY_abrevegrave, "XKB_KEY_abrevegrave" );
	#endif
	#ifdef XKB_KEY_Abrevehook
		swigIntConstant( XKB_KEY_Abrevehook, "XKB_KEY_Abrevehook" );
	#endif
	#ifdef XKB_KEY_abrevehook
		swigIntConstant( XKB_KEY_abrevehook, "XKB_KEY_abrevehook" );
	#endif
	#ifdef XKB_KEY_Abrevetilde
		swigIntConstant( XKB_KEY_Abrevetilde, "XKB_KEY_Abrevetilde" );
	#endif
	#ifdef XKB_KEY_abrevetilde
		swigIntConstant( XKB_KEY_abrevetilde, "XKB_KEY_abrevetilde" );
	#endif
	#ifdef XKB_KEY_Abrevebelowdot
		swigIntConstant( XKB_KEY_Abrevebelowdot, "XKB_KEY_Abrevebelowdot" );
	#endif
	#ifdef XKB_KEY_abrevebelowdot
		swigIntConstant( XKB_KEY_abrevebelowdot, "XKB_KEY_abrevebelowdot" );
	#endif
	#ifdef XKB_KEY_Ebelowdot
		swigIntConstant( XKB_KEY_Ebelowdot, "XKB_KEY_Ebelowdot" );
	#endif
	#ifdef XKB_KEY_ebelowdot
		swigIntConstant( XKB_KEY_ebelowdot, "XKB_KEY_ebelowdot" );
	#endif
	#ifdef XKB_KEY_Ehook
		swigIntConstant( XKB_KEY_Ehook, "XKB_KEY_Ehook" );
	#endif
	#ifdef XKB_KEY_ehook
		swigIntConstant( XKB_KEY_ehook, "XKB_KEY_ehook" );
	#endif
	#ifdef XKB_KEY_Etilde
		swigIntConstant( XKB_KEY_Etilde, "XKB_KEY_Etilde" );
	#endif
	#ifdef XKB_KEY_etilde
		swigIntConstant( XKB_KEY_etilde, "XKB_KEY_etilde" );
	#endif
	#ifdef XKB_KEY_Ecircumflexacute
		swigIntConstant( XKB_KEY_Ecircumflexacute, "XKB_KEY_Ecircumflexacute" );
	#endif
	#ifdef XKB_KEY_ecircumflexacute
		swigIntConstant( XKB_KEY_ecircumflexacute, "XKB_KEY_ecircumflexacute" );
	#endif
	#ifdef XKB_KEY_Ecircumflexgrave
		swigIntConstant( XKB_KEY_Ecircumflexgrave, "XKB_KEY_Ecircumflexgrave" );
	#endif
	#ifdef XKB_KEY_ecircumflexgrave
		swigIntConstant( XKB_KEY_ecircumflexgrave, "XKB_KEY_ecircumflexgrave" );
	#endif
	#ifdef XKB_KEY_Ecircumflexhook
		swigIntConstant( XKB_KEY_Ecircumflexhook, "XKB_KEY_Ecircumflexhook" );
	#endif
	#ifdef XKB_KEY_ecircumflexhook
		swigIntConstant( XKB_KEY_ecircumflexhook, "XKB_KEY_ecircumflexhook" );
	#endif
	#ifdef XKB_KEY_Ecircumflextilde
		swigIntConstant( XKB_KEY_Ecircumflextilde, "XKB_KEY_Ecircumflextilde" );
	#endif
	#ifdef XKB_KEY_ecircumflextilde
		swigIntConstant( XKB_KEY_ecircumflextilde, "XKB_KEY_ecircumflextilde" );
	#endif
	#ifdef XKB_KEY_Ecircumflexbelowdot
		swigIntConstant( XKB_KEY_Ecircumflexbelowdot, "XKB_KEY_Ecircumflexbelowdot" );
	#endif
	#ifdef XKB_KEY_ecircumflexbelowdot
		swigIntConstant( XKB_KEY_ecircumflexbelowdot, "XKB_KEY_ecircumflexbelowdot" );
	#endif
	#ifdef XKB_KEY_Ihook
		swigIntConstant( XKB_KEY_Ihook, "XKB_KEY_Ihook" );
	#endif
	#ifdef XKB_KEY_ihook
		swigIntConstant( XKB_KEY_ihook, "XKB_KEY_ihook" );
	#endif
	#ifdef XKB_KEY_Ibelowdot
		swigIntConstant( XKB_KEY_Ibelowdot, "XKB_KEY_Ibelowdot" );
	#endif
	#ifdef XKB_KEY_ibelowdot
		swigIntConstant( XKB_KEY_ibelowdot, "XKB_KEY_ibelowdot" );
	#endif
	#ifdef XKB_KEY_Obelowdot
		swigIntConstant( XKB_KEY_Obelowdot, "XKB_KEY_Obelowdot" );
	#endif
	#ifdef XKB_KEY_obelowdot
		swigIntConstant( XKB_KEY_obelowdot, "XKB_KEY_obelowdot" );
	#endif
	#ifdef XKB_KEY_Ohook
		swigIntConstant( XKB_KEY_Ohook, "XKB_KEY_Ohook" );
	#endif
	#ifdef XKB_KEY_ohook
		swigIntConstant( XKB_KEY_ohook, "XKB_KEY_ohook" );
	#endif
	#ifdef XKB_KEY_Ocircumflexacute
		swigIntConstant( XKB_KEY_Ocircumflexacute, "XKB_KEY_Ocircumflexacute" );
	#endif
	#ifdef XKB_KEY_ocircumflexacute
		swigIntConstant( XKB_KEY_ocircumflexacute, "XKB_KEY_ocircumflexacute" );
	#endif
	#ifdef XKB_KEY_Ocircumflexgrave
		swigIntConstant( XKB_KEY_Ocircumflexgrave, "XKB_KEY_Ocircumflexgrave" );
	#endif
	#ifdef XKB_KEY_ocircumflexgrave
		swigIntConstant( XKB_KEY_ocircumflexgrave, "XKB_KEY_ocircumflexgrave" );
	#endif
	#ifdef XKB_KEY_Ocircumflexhook
		swigIntConstant( XKB_KEY_Ocircumflexhook, "XKB_KEY_Ocircumflexhook" );
	#endif
	#ifdef XKB_KEY_ocircumflexhook
		swigIntConstant( XKB_KEY_ocircumflexhook, "XKB_KEY_ocircumflexhook" );
	#endif
	#ifdef XKB_KEY_Ocircumflextilde
		swigIntConstant( XKB_KEY_Ocircumflextilde, "XKB_KEY_Ocircumflextilde" );
	#endif
	#ifdef XKB_KEY_ocircumflextilde
		swigIntConstant( XKB_KEY_ocircumflextilde, "XKB_KEY_ocircumflextilde" );
	#endif
	#ifdef XKB_KEY_Ocircumflexbelowdot
		swigIntConstant( XKB_KEY_Ocircumflexbelowdot, "XKB_KEY_Ocircumflexbelowdot" );
	#endif
	#ifdef XKB_KEY_ocircumflexbelowdot
		swigIntConstant( XKB_KEY_ocircumflexbelowdot, "XKB_KEY_ocircumflexbelowdot" );
	#endif
	#ifdef XKB_KEY_Ohornacute
		swigIntConstant( XKB_KEY_Ohornacute, "XKB_KEY_Ohornacute" );
	#endif
	#ifdef XKB_KEY_ohornacute
		swigIntConstant( XKB_KEY_ohornacute, "XKB_KEY_ohornacute" );
	#endif
	#ifdef XKB_KEY_Ohorngrave
		swigIntConstant( XKB_KEY_Ohorngrave, "XKB_KEY_Ohorngrave" );
	#endif
	#ifdef XKB_KEY_ohorngrave
		swigIntConstant( XKB_KEY_ohorngrave, "XKB_KEY_ohorngrave" );
	#endif
	#ifdef XKB_KEY_Ohornhook
		swigIntConstant( XKB_KEY_Ohornhook, "XKB_KEY_Ohornhook" );
	#endif
	#ifdef XKB_KEY_ohornhook
		swigIntConstant( XKB_KEY_ohornhook, "XKB_KEY_ohornhook" );
	#endif
	#ifdef XKB_KEY_Ohorntilde
		swigIntConstant( XKB_KEY_Ohorntilde, "XKB_KEY_Ohorntilde" );
	#endif
	#ifdef XKB_KEY_ohorntilde
		swigIntConstant( XKB_KEY_ohorntilde, "XKB_KEY_ohorntilde" );
	#endif
	#ifdef XKB_KEY_Ohornbelowdot
		swigIntConstant( XKB_KEY_Ohornbelowdot, "XKB_KEY_Ohornbelowdot" );
	#endif
	#ifdef XKB_KEY_ohornbelowdot
		swigIntConstant( XKB_KEY_ohornbelowdot, "XKB_KEY_ohornbelowdot" );
	#endif
	#ifdef XKB_KEY_Ubelowdot
		swigIntConstant( XKB_KEY_Ubelowdot, "XKB_KEY_Ubelowdot" );
	#endif
	#ifdef XKB_KEY_ubelowdot
		swigIntConstant( XKB_KEY_ubelowdot, "XKB_KEY_ubelowdot" );
	#endif
	#ifdef XKB_KEY_Uhook
		swigIntConstant( XKB_KEY_Uhook, "XKB_KEY_Uhook" );
	#endif
	#ifdef XKB_KEY_uhook
		swigIntConstant( XKB_KEY_uhook, "XKB_KEY_uhook" );
	#endif
	#ifdef XKB_KEY_Uhornacute
		swigIntConstant( XKB_KEY_Uhornacute, "XKB_KEY_Uhornacute" );
	#endif
	#ifdef XKB_KEY_uhornacute
		swigIntConstant( XKB_KEY_uhornacute, "XKB_KEY_uhornacute" );
	#endif
	#ifdef XKB_KEY_Uhorngrave
		swigIntConstant( XKB_KEY_Uhorngrave, "XKB_KEY_Uhorngrave" );
	#endif
	#ifdef XKB_KEY_uhorngrave
		swigIntConstant( XKB_KEY_uhorngrave, "XKB_KEY_uhorngrave" );
	#endif
	#ifdef XKB_KEY_Uhornhook
		swigIntConstant( XKB_KEY_Uhornhook, "XKB_KEY_Uhornhook" );
	#endif
	#ifdef XKB_KEY_uhornhook
		swigIntConstant( XKB_KEY_uhornhook, "XKB_KEY_uhornhook" );
	#endif
	#ifdef XKB_KEY_Uhorntilde
		swigIntConstant( XKB_KEY_Uhorntilde, "XKB_KEY_Uhorntilde" );
	#endif
	#ifdef XKB_KEY_uhorntilde
		swigIntConstant( XKB_KEY_uhorntilde, "XKB_KEY_uhorntilde" );
	#endif
	#ifdef XKB_KEY_Uhornbelowdot
		swigIntConstant( XKB_KEY_Uhornbelowdot, "XKB_KEY_Uhornbelowdot" );
	#endif
	#ifdef XKB_KEY_uhornbelowdot
		swigIntConstant( XKB_KEY_uhornbelowdot, "XKB_KEY_uhornbelowdot" );
	#endif
	#ifdef XKB_KEY_Ybelowdot
		swigIntConstant( XKB_KEY_Ybelowdot, "XKB_KEY_Ybelowdot" );
	#endif
	#ifdef XKB_KEY_ybelowdot
		swigIntConstant( XKB_KEY_ybelowdot, "XKB_KEY_ybelowdot" );
	#endif
	#ifdef XKB_KEY_Yhook
		swigIntConstant( XKB_KEY_Yhook, "XKB_KEY_Yhook" );
	#endif
	#ifdef XKB_KEY_yhook
		swigIntConstant( XKB_KEY_yhook, "XKB_KEY_yhook" );
	#endif
	#ifdef XKB_KEY_Ytilde
		swigIntConstant( XKB_KEY_Ytilde, "XKB_KEY_Ytilde" );
	#endif
	#ifdef XKB_KEY_ytilde
		swigIntConstant( XKB_KEY_ytilde, "XKB_KEY_ytilde" );
	#endif
	#ifdef XKB_KEY_Ohorn
		swigIntConstant( XKB_KEY_Ohorn, "XKB_KEY_Ohorn" );
	#endif
	#ifdef XKB_KEY_ohorn
		swigIntConstant( XKB_KEY_ohorn, "XKB_KEY_ohorn" );
	#endif
	#ifdef XKB_KEY_Uhorn
		swigIntConstant( XKB_KEY_Uhorn, "XKB_KEY_Uhorn" );
	#endif
	#ifdef XKB_KEY_uhorn
		swigIntConstant( XKB_KEY_uhorn, "XKB_KEY_uhorn" );
	#endif
	#ifdef XKB_KEY_combining_tilde
		swigIntConstant( XKB_KEY_combining_tilde, "XKB_KEY_combining_tilde" );
	#endif
	#ifdef XKB_KEY_combining_grave
		swigIntConstant( XKB_KEY_combining_grave, "XKB_KEY_combining_grave" );
	#endif
	#ifdef XKB_KEY_combining_acute
		swigIntConstant( XKB_KEY_combining_acute, "XKB_KEY_combining_acute" );
	#endif
	#ifdef XKB_KEY_combining_hook
		swigIntConstant( XKB_KEY_combining_hook, "XKB_KEY_combining_hook" );
	#endif
	#ifdef XKB_KEY_combining_belowdot
		swigIntConstant( XKB_KEY_combining_belowdot, "XKB_KEY_combining_belowdot" );
	#endif
	#ifdef XKB_KEY_EcuSign
		swigIntConstant( XKB_KEY_EcuSign, "XKB_KEY_EcuSign" );
	#endif
	#ifdef XKB_KEY_ColonSign
		swigIntConstant( XKB_KEY_ColonSign, "XKB_KEY_ColonSign" );
	#endif
	#ifdef XKB_KEY_CruzeiroSign
		swigIntConstant( XKB_KEY_CruzeiroSign, "XKB_KEY_CruzeiroSign" );
	#endif
	#ifdef XKB_KEY_FFrancSign
		swigIntConstant( XKB_KEY_FFrancSign, "XKB_KEY_FFrancSign" );
	#endif
	#ifdef XKB_KEY_LiraSign
		swigIntConstant( XKB_KEY_LiraSign, "XKB_KEY_LiraSign" );
	#endif
	#ifdef XKB_KEY_MillSign
		swigIntConstant( XKB_KEY_MillSign, "XKB_KEY_MillSign" );
	#endif
	#ifdef XKB_KEY_NairaSign
		swigIntConstant( XKB_KEY_NairaSign, "XKB_KEY_NairaSign" );
	#endif
	#ifdef XKB_KEY_PesetaSign
		swigIntConstant( XKB_KEY_PesetaSign, "XKB_KEY_PesetaSign" );
	#endif
	#ifdef XKB_KEY_RupeeSign
		swigIntConstant( XKB_KEY_RupeeSign, "XKB_KEY_RupeeSign" );
	#endif
	#ifdef XKB_KEY_WonSign
		swigIntConstant( XKB_KEY_WonSign, "XKB_KEY_WonSign" );
	#endif
	#ifdef XKB_KEY_NewSheqelSign
		swigIntConstant( XKB_KEY_NewSheqelSign, "XKB_KEY_NewSheqelSign" );
	#endif
	#ifdef XKB_KEY_DongSign
		swigIntConstant( XKB_KEY_DongSign, "XKB_KEY_DongSign" );
	#endif
	#ifdef XKB_KEY_EuroSign
		swigIntConstant( XKB_KEY_EuroSign, "XKB_KEY_EuroSign" );
	#endif
	#ifdef XKB_KEY_zerosuperior
		swigIntConstant( XKB_KEY_zerosuperior, "XKB_KEY_zerosuperior" );
	#endif
	#ifdef XKB_KEY_foursuperior
		swigIntConstant( XKB_KEY_foursuperior, "XKB_KEY_foursuperior" );
	#endif
	#ifdef XKB_KEY_fivesuperior
		swigIntConstant( XKB_KEY_fivesuperior, "XKB_KEY_fivesuperior" );
	#endif
	#ifdef XKB_KEY_sixsuperior
		swigIntConstant( XKB_KEY_sixsuperior, "XKB_KEY_sixsuperior" );
	#endif
	#ifdef XKB_KEY_sevensuperior
		swigIntConstant( XKB_KEY_sevensuperior, "XKB_KEY_sevensuperior" );
	#endif
	#ifdef XKB_KEY_eightsuperior
		swigIntConstant( XKB_KEY_eightsuperior, "XKB_KEY_eightsuperior" );
	#endif
	#ifdef XKB_KEY_ninesuperior
		swigIntConstant( XKB_KEY_ninesuperior, "XKB_KEY_ninesuperior" );
	#endif
	#ifdef XKB_KEY_zerosubscript
		swigIntConstant( XKB_KEY_zerosubscript, "XKB_KEY_zerosubscript" );
	#endif
	#ifdef XKB_KEY_onesubscript
		swigIntConstant( XKB_KEY_onesubscript, "XKB_KEY_onesubscript" );
	#endif
	#ifdef XKB_KEY_twosubscript
		swigIntConstant( XKB_KEY_twosubscript, "XKB_KEY_twosubscript" );
	#endif
	#ifdef XKB_KEY_threesubscript
		swigIntConstant( XKB_KEY_threesubscript, "XKB_KEY_threesubscript" );
	#endif
	#ifdef XKB_KEY_foursubscript
		swigIntConstant( XKB_KEY_foursubscript, "XKB_KEY_foursubscript" );
	#endif
	#ifdef XKB_KEY_fivesubscript
		swigIntConstant( XKB_KEY_fivesubscript, "XKB_KEY_fivesubscript" );
	#endif
	#ifdef XKB_KEY_sixsubscript
		swigIntConstant( XKB_KEY_sixsubscript, "XKB_KEY_sixsubscript" );
	#endif
	#ifdef XKB_KEY_sevensubscript
		swigIntConstant( XKB_KEY_sevensubscript, "XKB_KEY_sevensubscript" );
	#endif
	#ifdef XKB_KEY_eightsubscript
		swigIntConstant( XKB_KEY_eightsubscript, "XKB_KEY_eightsubscript" );
	#endif
	#ifdef XKB_KEY_ninesubscript
		swigIntConstant( XKB_KEY_ninesubscript, "XKB_KEY_ninesubscript" );
	#endif
	#ifdef XKB_KEY_partdifferential
		swigIntConstant( XKB_KEY_partdifferential, "XKB_KEY_partdifferential" );
	#endif
	#ifdef XKB_KEY_emptyset
		swigIntConstant( XKB_KEY_emptyset, "XKB_KEY_emptyset" );
	#endif
	#ifdef XKB_KEY_elementof
		swigIntConstant( XKB_KEY_elementof, "XKB_KEY_elementof" );
	#endif
	#ifdef XKB_KEY_notelementof
		swigIntConstant( XKB_KEY_notelementof, "XKB_KEY_notelementof" );
	#endif
	#ifdef XKB_KEY_containsas
		swigIntConstant( XKB_KEY_containsas, "XKB_KEY_containsas" );
	#endif
	#ifdef XKB_KEY_squareroot
		swigIntConstant( XKB_KEY_squareroot, "XKB_KEY_squareroot" );
	#endif
	#ifdef XKB_KEY_cuberoot
		swigIntConstant( XKB_KEY_cuberoot, "XKB_KEY_cuberoot" );
	#endif
	#ifdef XKB_KEY_fourthroot
		swigIntConstant( XKB_KEY_fourthroot, "XKB_KEY_fourthroot" );
	#endif
	#ifdef XKB_KEY_dintegral
		swigIntConstant( XKB_KEY_dintegral, "XKB_KEY_dintegral" );
	#endif
	#ifdef XKB_KEY_tintegral
		swigIntConstant( XKB_KEY_tintegral, "XKB_KEY_tintegral" );
	#endif
	#ifdef XKB_KEY_because
		swigIntConstant( XKB_KEY_because, "XKB_KEY_because" );
	#endif
	#ifdef XKB_KEY_approxeq
		swigIntConstant( XKB_KEY_approxeq, "XKB_KEY_approxeq" );
	#endif
	#ifdef XKB_KEY_notapproxeq
		swigIntConstant( XKB_KEY_notapproxeq, "XKB_KEY_notapproxeq" );
	#endif
	#ifdef XKB_KEY_notidentical
		swigIntConstant( XKB_KEY_notidentical, "XKB_KEY_notidentical" );
	#endif
	#ifdef XKB_KEY_stricteq
		swigIntConstant( XKB_KEY_stricteq, "XKB_KEY_stricteq" );
	#endif
	#ifdef XKB_KEY_braille_dot_1
		swigIntConstant( XKB_KEY_braille_dot_1, "XKB_KEY_braille_dot_1" );
	#endif
	#ifdef XKB_KEY_braille_dot_2
		swigIntConstant( XKB_KEY_braille_dot_2, "XKB_KEY_braille_dot_2" );
	#endif
	#ifdef XKB_KEY_braille_dot_3
		swigIntConstant( XKB_KEY_braille_dot_3, "XKB_KEY_braille_dot_3" );
	#endif
	#ifdef XKB_KEY_braille_dot_4
		swigIntConstant( XKB_KEY_braille_dot_4, "XKB_KEY_braille_dot_4" );
	#endif
	#ifdef XKB_KEY_braille_dot_5
		swigIntConstant( XKB_KEY_braille_dot_5, "XKB_KEY_braille_dot_5" );
	#endif
	#ifdef XKB_KEY_braille_dot_6
		swigIntConstant( XKB_KEY_braille_dot_6, "XKB_KEY_braille_dot_6" );
	#endif
	#ifdef XKB_KEY_braille_dot_7
		swigIntConstant( XKB_KEY_braille_dot_7, "XKB_KEY_braille_dot_7" );
	#endif
	#ifdef XKB_KEY_braille_dot_8
		swigIntConstant( XKB_KEY_braille_dot_8, "XKB_KEY_braille_dot_8" );
	#endif
	#ifdef XKB_KEY_braille_dot_9
		swigIntConstant( XKB_KEY_braille_dot_9, "XKB_KEY_braille_dot_9" );
	#endif
	#ifdef XKB_KEY_braille_dot_10
		swigIntConstant( XKB_KEY_braille_dot_10, "XKB_KEY_braille_dot_10" );
	#endif
	#ifdef XKB_KEY_braille_blank
		swigIntConstant( XKB_KEY_braille_blank, "XKB_KEY_braille_blank" );
	#endif
	#ifdef XKB_KEY_braille_dots_1
		swigIntConstant( XKB_KEY_braille_dots_1, "XKB_KEY_braille_dots_1" );
	#endif
	#ifdef XKB_KEY_braille_dots_2
		swigIntConstant( XKB_KEY_braille_dots_2, "XKB_KEY_braille_dots_2" );
	#endif
	#ifdef XKB_KEY_braille_dots_12
		swigIntConstant( XKB_KEY_braille_dots_12, "XKB_KEY_braille_dots_12" );
	#endif
	#ifdef XKB_KEY_braille_dots_3
		swigIntConstant( XKB_KEY_braille_dots_3, "XKB_KEY_braille_dots_3" );
	#endif
	#ifdef XKB_KEY_braille_dots_13
		swigIntConstant( XKB_KEY_braille_dots_13, "XKB_KEY_braille_dots_13" );
	#endif
	#ifdef XKB_KEY_braille_dots_23
		swigIntConstant( XKB_KEY_braille_dots_23, "XKB_KEY_braille_dots_23" );
	#endif
	#ifdef XKB_KEY_braille_dots_123
		swigIntConstant( XKB_KEY_braille_dots_123, "XKB_KEY_braille_dots_123" );
	#endif
	#ifdef XKB_KEY_braille_dots_4
		swigIntConstant( XKB_KEY_braille_dots_4, "XKB_KEY_braille_dots_4" );
	#endif
	#ifdef XKB_KEY_braille_dots_14
		swigIntConstant( XKB_KEY_braille_dots_14, "XKB_KEY_braille_dots_14" );
	#endif
	#ifdef XKB_KEY_braille_dots_24
		swigIntConstant( XKB_KEY_braille_dots_24, "XKB_KEY_braille_dots_24" );
	#endif
	#ifdef XKB_KEY_braille_dots_124
		swigIntConstant( XKB_KEY_braille_dots_124, "XKB_KEY_braille_dots_124" );
	#endif
	#ifdef XKB_KEY_braille_dots_34
		swigIntConstant( XKB_KEY_braille_dots_34, "XKB_KEY_braille_dots_34" );
	#endif
	#ifdef XKB_KEY_braille_dots_134
		swigIntConstant( XKB_KEY_braille_dots_134, "XKB_KEY_braille_dots_134" );
	#endif
	#ifdef XKB_KEY_braille_dots_234
		swigIntConstant( XKB_KEY_braille_dots_234, "XKB_KEY_braille_dots_234" );
	#endif
	#ifdef XKB_KEY_braille_dots_1234
		swigIntConstant( XKB_KEY_braille_dots_1234, "XKB_KEY_braille_dots_1234" );
	#endif
	#ifdef XKB_KEY_braille_dots_5
		swigIntConstant( XKB_KEY_braille_dots_5, "XKB_KEY_braille_dots_5" );
	#endif
	#ifdef XKB_KEY_braille_dots_15
		swigIntConstant( XKB_KEY_braille_dots_15, "XKB_KEY_braille_dots_15" );
	#endif
	#ifdef XKB_KEY_braille_dots_25
		swigIntConstant( XKB_KEY_braille_dots_25, "XKB_KEY_braille_dots_25" );
	#endif
	#ifdef XKB_KEY_braille_dots_125
		swigIntConstant( XKB_KEY_braille_dots_125, "XKB_KEY_braille_dots_125" );
	#endif
	#ifdef XKB_KEY_braille_dots_35
		swigIntConstant( XKB_KEY_braille_dots_35, "XKB_KEY_braille_dots_35" );
	#endif
	#ifdef XKB_KEY_braille_dots_135
		swigIntConstant( XKB_KEY_braille_dots_135, "XKB_KEY_braille_dots_135" );
	#endif
	#ifdef XKB_KEY_braille_dots_235
		swigIntConstant( XKB_KEY_braille_dots_235, "XKB_KEY_braille_dots_235" );
	#endif
	#ifdef XKB_KEY_braille_dots_1235
		swigIntConstant( XKB_KEY_braille_dots_1235, "XKB_KEY_braille_dots_1235" );
	#endif
	#ifdef XKB_KEY_braille_dots_45
		swigIntConstant( XKB_KEY_braille_dots_45, "XKB_KEY_braille_dots_45" );
	#endif
	#ifdef XKB_KEY_braille_dots_145
		swigIntConstant( XKB_KEY_braille_dots_145, "XKB_KEY_braille_dots_145" );
	#endif
	#ifdef XKB_KEY_braille_dots_245
		swigIntConstant( XKB_KEY_braille_dots_245, "XKB_KEY_braille_dots_245" );
	#endif
	#ifdef XKB_KEY_braille_dots_1245
		swigIntConstant( XKB_KEY_braille_dots_1245, "XKB_KEY_braille_dots_1245" );
	#endif
	#ifdef XKB_KEY_braille_dots_345
		swigIntConstant( XKB_KEY_braille_dots_345, "XKB_KEY_braille_dots_345" );
	#endif
	#ifdef XKB_KEY_braille_dots_1345
		swigIntConstant( XKB_KEY_braille_dots_1345, "XKB_KEY_braille_dots_1345" );
	#endif
	#ifdef XKB_KEY_braille_dots_2345
		swigIntConstant( XKB_KEY_braille_dots_2345, "XKB_KEY_braille_dots_2345" );
	#endif
	#ifdef XKB_KEY_braille_dots_12345
		swigIntConstant( XKB_KEY_braille_dots_12345, "XKB_KEY_braille_dots_12345" );
	#endif
	#ifdef XKB_KEY_braille_dots_6
		swigIntConstant( XKB_KEY_braille_dots_6, "XKB_KEY_braille_dots_6" );
	#endif
	#ifdef XKB_KEY_braille_dots_16
		swigIntConstant( XKB_KEY_braille_dots_16, "XKB_KEY_braille_dots_16" );
	#endif
	#ifdef XKB_KEY_braille_dots_26
		swigIntConstant( XKB_KEY_braille_dots_26, "XKB_KEY_braille_dots_26" );
	#endif
	#ifdef XKB_KEY_braille_dots_126
		swigIntConstant( XKB_KEY_braille_dots_126, "XKB_KEY_braille_dots_126" );
	#endif
	#ifdef XKB_KEY_braille_dots_36
		swigIntConstant( XKB_KEY_braille_dots_36, "XKB_KEY_braille_dots_36" );
	#endif
	#ifdef XKB_KEY_braille_dots_136
		swigIntConstant( XKB_KEY_braille_dots_136, "XKB_KEY_braille_dots_136" );
	#endif
	#ifdef XKB_KEY_braille_dots_236
		swigIntConstant( XKB_KEY_braille_dots_236, "XKB_KEY_braille_dots_236" );
	#endif
	#ifdef XKB_KEY_braille_dots_1236
		swigIntConstant( XKB_KEY_braille_dots_1236, "XKB_KEY_braille_dots_1236" );
	#endif
	#ifdef XKB_KEY_braille_dots_46
		swigIntConstant( XKB_KEY_braille_dots_46, "XKB_KEY_braille_dots_46" );
	#endif
	#ifdef XKB_KEY_braille_dots_146
		swigIntConstant( XKB_KEY_braille_dots_146, "XKB_KEY_braille_dots_146" );
	#endif
	#ifdef XKB_KEY_braille_dots_246
		swigIntConstant( XKB_KEY_braille_dots_246, "XKB_KEY_braille_dots_246" );
	#endif
	#ifdef XKB_KEY_braille_dots_1246
		swigIntConstant( XKB_KEY_braille_dots_1246, "XKB_KEY_braille_dots_1246" );
	#endif
	#ifdef XKB_KEY_braille_dots_346
		swigIntConstant( XKB_KEY_braille_dots_346, "XKB_KEY_braille_dots_346" );
	#endif
	#ifdef XKB_KEY_braille_dots_1346
		swigIntConstant( XKB_KEY_braille_dots_1346, "XKB_KEY_braille_dots_1346" );
	#endif
	#ifdef XKB_KEY_braille_dots_2346
		swigIntConstant( XKB_KEY_braille_dots_2346, "XKB_KEY_braille_dots_2346" );
	#endif
	#ifdef XKB_KEY_braille_dots_12346
		swigIntConstant( XKB_KEY_braille_dots_12346, "XKB_KEY_braille_dots_12346" );
	#endif
	#ifdef XKB_KEY_braille_dots_56
		swigIntConstant( XKB_KEY_braille_dots_56, "XKB_KEY_braille_dots_56" );
	#endif
	#ifdef XKB_KEY_braille_dots_156
		swigIntConstant( XKB_KEY_braille_dots_156, "XKB_KEY_braille_dots_156" );
	#endif
	#ifdef XKB_KEY_braille_dots_256
		swigIntConstant( XKB_KEY_braille_dots_256, "XKB_KEY_braille_dots_256" );
	#endif
	#ifdef XKB_KEY_braille_dots_1256
		swigIntConstant( XKB_KEY_braille_dots_1256, "XKB_KEY_braille_dots_1256" );
	#endif
	#ifdef XKB_KEY_braille_dots_356
		swigIntConstant( XKB_KEY_braille_dots_356, "XKB_KEY_braille_dots_356" );
	#endif
	#ifdef XKB_KEY_braille_dots_1356
		swigIntConstant( XKB_KEY_braille_dots_1356, "XKB_KEY_braille_dots_1356" );
	#endif
	#ifdef XKB_KEY_braille_dots_2356
		swigIntConstant( XKB_KEY_braille_dots_2356, "XKB_KEY_braille_dots_2356" );
	#endif
	#ifdef XKB_KEY_braille_dots_12356
		swigIntConstant( XKB_KEY_braille_dots_12356, "XKB_KEY_braille_dots_12356" );
	#endif
	#ifdef XKB_KEY_braille_dots_456
		swigIntConstant( XKB_KEY_braille_dots_456, "XKB_KEY_braille_dots_456" );
	#endif
	#ifdef XKB_KEY_braille_dots_1456
		swigIntConstant( XKB_KEY_braille_dots_1456, "XKB_KEY_braille_dots_1456" );
	#endif
	#ifdef XKB_KEY_braille_dots_2456
		swigIntConstant( XKB_KEY_braille_dots_2456, "XKB_KEY_braille_dots_2456" );
	#endif
	#ifdef XKB_KEY_braille_dots_12456
		swigIntConstant( XKB_KEY_braille_dots_12456, "XKB_KEY_braille_dots_12456" );
	#endif
	#ifdef XKB_KEY_braille_dots_3456
		swigIntConstant( XKB_KEY_braille_dots_3456, "XKB_KEY_braille_dots_3456" );
	#endif
	#ifdef XKB_KEY_braille_dots_13456
		swigIntConstant( XKB_KEY_braille_dots_13456, "XKB_KEY_braille_dots_13456" );
	#endif
	#ifdef XKB_KEY_braille_dots_23456
		swigIntConstant( XKB_KEY_braille_dots_23456, "XKB_KEY_braille_dots_23456" );
	#endif
	#ifdef XKB_KEY_braille_dots_123456
		swigIntConstant( XKB_KEY_braille_dots_123456, "XKB_KEY_braille_dots_123456" );
	#endif
	#ifdef XKB_KEY_braille_dots_7
		swigIntConstant( XKB_KEY_braille_dots_7, "XKB_KEY_braille_dots_7" );
	#endif
	#ifdef XKB_KEY_braille_dots_17
		swigIntConstant( XKB_KEY_braille_dots_17, "XKB_KEY_braille_dots_17" );
	#endif
	#ifdef XKB_KEY_braille_dots_27
		swigIntConstant( XKB_KEY_braille_dots_27, "XKB_KEY_braille_dots_27" );
	#endif
	#ifdef XKB_KEY_braille_dots_127
		swigIntConstant( XKB_KEY_braille_dots_127, "XKB_KEY_braille_dots_127" );
	#endif
	#ifdef XKB_KEY_braille_dots_37
		swigIntConstant( XKB_KEY_braille_dots_37, "XKB_KEY_braille_dots_37" );
	#endif
	#ifdef XKB_KEY_braille_dots_137
		swigIntConstant( XKB_KEY_braille_dots_137, "XKB_KEY_braille_dots_137" );
	#endif
	#ifdef XKB_KEY_braille_dots_237
		swigIntConstant( XKB_KEY_braille_dots_237, "XKB_KEY_braille_dots_237" );
	#endif
	#ifdef XKB_KEY_braille_dots_1237
		swigIntConstant( XKB_KEY_braille_dots_1237, "XKB_KEY_braille_dots_1237" );
	#endif
	#ifdef XKB_KEY_braille_dots_47
		swigIntConstant( XKB_KEY_braille_dots_47, "XKB_KEY_braille_dots_47" );
	#endif
	#ifdef XKB_KEY_braille_dots_147
		swigIntConstant( XKB_KEY_braille_dots_147, "XKB_KEY_braille_dots_147" );
	#endif
	#ifdef XKB_KEY_braille_dots_247
		swigIntConstant( XKB_KEY_braille_dots_247, "XKB_KEY_braille_dots_247" );
	#endif
	#ifdef XKB_KEY_braille_dots_1247
		swigIntConstant( XKB_KEY_braille_dots_1247, "XKB_KEY_braille_dots_1247" );
	#endif
	#ifdef XKB_KEY_braille_dots_347
		swigIntConstant( XKB_KEY_braille_dots_347, "XKB_KEY_braille_dots_347" );
	#endif
	#ifdef XKB_KEY_braille_dots_1347
		swigIntConstant( XKB_KEY_braille_dots_1347, "XKB_KEY_braille_dots_1347" );
	#endif
	#ifdef XKB_KEY_braille_dots_2347
		swigIntConstant( XKB_KEY_braille_dots_2347, "XKB_KEY_braille_dots_2347" );
	#endif
	#ifdef XKB_KEY_braille_dots_12347
		swigIntConstant( XKB_KEY_braille_dots_12347, "XKB_KEY_braille_dots_12347" );
	#endif
	#ifdef XKB_KEY_braille_dots_57
		swigIntConstant( XKB_KEY_braille_dots_57, "XKB_KEY_braille_dots_57" );
	#endif
	#ifdef XKB_KEY_braille_dots_157
		swigIntConstant( XKB_KEY_braille_dots_157, "XKB_KEY_braille_dots_157" );
	#endif
	#ifdef XKB_KEY_braille_dots_257
		swigIntConstant( XKB_KEY_braille_dots_257, "XKB_KEY_braille_dots_257" );
	#endif
	#ifdef XKB_KEY_braille_dots_1257
		swigIntConstant( XKB_KEY_braille_dots_1257, "XKB_KEY_braille_dots_1257" );
	#endif
	#ifdef XKB_KEY_braille_dots_357
		swigIntConstant( XKB_KEY_braille_dots_357, "XKB_KEY_braille_dots_357" );
	#endif
	#ifdef XKB_KEY_braille_dots_1357
		swigIntConstant( XKB_KEY_braille_dots_1357, "XKB_KEY_braille_dots_1357" );
	#endif
	#ifdef XKB_KEY_braille_dots_2357
		swigIntConstant( XKB_KEY_braille_dots_2357, "XKB_KEY_braille_dots_2357" );
	#endif
	#ifdef XKB_KEY_braille_dots_12357
		swigIntConstant( XKB_KEY_braille_dots_12357, "XKB_KEY_braille_dots_12357" );
	#endif
	#ifdef XKB_KEY_braille_dots_457
		swigIntConstant( XKB_KEY_braille_dots_457, "XKB_KEY_braille_dots_457" );
	#endif
	#ifdef XKB_KEY_braille_dots_1457
		swigIntConstant( XKB_KEY_braille_dots_1457, "XKB_KEY_braille_dots_1457" );
	#endif
	#ifdef XKB_KEY_braille_dots_2457
		swigIntConstant( XKB_KEY_braille_dots_2457, "XKB_KEY_braille_dots_2457" );
	#endif
	#ifdef XKB_KEY_braille_dots_12457
		swigIntConstant( XKB_KEY_braille_dots_12457, "XKB_KEY_braille_dots_12457" );
	#endif
	#ifdef XKB_KEY_braille_dots_3457
		swigIntConstant( XKB_KEY_braille_dots_3457, "XKB_KEY_braille_dots_3457" );
	#endif
	#ifdef XKB_KEY_braille_dots_13457
		swigIntConstant( XKB_KEY_braille_dots_13457, "XKB_KEY_braille_dots_13457" );
	#endif
	#ifdef XKB_KEY_braille_dots_23457
		swigIntConstant( XKB_KEY_braille_dots_23457, "XKB_KEY_braille_dots_23457" );
	#endif
	#ifdef XKB_KEY_braille_dots_123457
		swigIntConstant( XKB_KEY_braille_dots_123457, "XKB_KEY_braille_dots_123457" );
	#endif
	#ifdef XKB_KEY_braille_dots_67
		swigIntConstant( XKB_KEY_braille_dots_67, "XKB_KEY_braille_dots_67" );
	#endif
	#ifdef XKB_KEY_braille_dots_167
		swigIntConstant( XKB_KEY_braille_dots_167, "XKB_KEY_braille_dots_167" );
	#endif
	#ifdef XKB_KEY_braille_dots_267
		swigIntConstant( XKB_KEY_braille_dots_267, "XKB_KEY_braille_dots_267" );
	#endif
	#ifdef XKB_KEY_braille_dots_1267
		swigIntConstant( XKB_KEY_braille_dots_1267, "XKB_KEY_braille_dots_1267" );
	#endif
	#ifdef XKB_KEY_braille_dots_367
		swigIntConstant( XKB_KEY_braille_dots_367, "XKB_KEY_braille_dots_367" );
	#endif
	#ifdef XKB_KEY_braille_dots_1367
		swigIntConstant( XKB_KEY_braille_dots_1367, "XKB_KEY_braille_dots_1367" );
	#endif
	#ifdef XKB_KEY_braille_dots_2367
		swigIntConstant( XKB_KEY_braille_dots_2367, "XKB_KEY_braille_dots_2367" );
	#endif
	#ifdef XKB_KEY_braille_dots_12367
		swigIntConstant( XKB_KEY_braille_dots_12367, "XKB_KEY_braille_dots_12367" );
	#endif
	#ifdef XKB_KEY_braille_dots_467
		swigIntConstant( XKB_KEY_braille_dots_467, "XKB_KEY_braille_dots_467" );
	#endif
	#ifdef XKB_KEY_braille_dots_1467
		swigIntConstant( XKB_KEY_braille_dots_1467, "XKB_KEY_braille_dots_1467" );
	#endif
	#ifdef XKB_KEY_braille_dots_2467
		swigIntConstant( XKB_KEY_braille_dots_2467, "XKB_KEY_braille_dots_2467" );
	#endif
	#ifdef XKB_KEY_braille_dots_12467
		swigIntConstant( XKB_KEY_braille_dots_12467, "XKB_KEY_braille_dots_12467" );
	#endif
	#ifdef XKB_KEY_braille_dots_3467
		swigIntConstant( XKB_KEY_braille_dots_3467, "XKB_KEY_braille_dots_3467" );
	#endif
	#ifdef XKB_KEY_braille_dots_13467
		swigIntConstant( XKB_KEY_braille_dots_13467, "XKB_KEY_braille_dots_13467" );
	#endif
	#ifdef XKB_KEY_braille_dots_23467
		swigIntConstant( XKB_KEY_braille_dots_23467, "XKB_KEY_braille_dots_23467" );
	#endif
	#ifdef XKB_KEY_braille_dots_123467
		swigIntConstant( XKB_KEY_braille_dots_123467, "XKB_KEY_braille_dots_123467" );
	#endif
	#ifdef XKB_KEY_braille_dots_567
		swigIntConstant( XKB_KEY_braille_dots_567, "XKB_KEY_braille_dots_567" );
	#endif
	#ifdef XKB_KEY_braille_dots_1567
		swigIntConstant( XKB_KEY_braille_dots_1567, "XKB_KEY_braille_dots_1567" );
	#endif
	#ifdef XKB_KEY_braille_dots_2567
		swigIntConstant( XKB_KEY_braille_dots_2567, "XKB_KEY_braille_dots_2567" );
	#endif
	#ifdef XKB_KEY_braille_dots_12567
		swigIntConstant( XKB_KEY_braille_dots_12567, "XKB_KEY_braille_dots_12567" );
	#endif
	#ifdef XKB_KEY_braille_dots_3567
		swigIntConstant( XKB_KEY_braille_dots_3567, "XKB_KEY_braille_dots_3567" );
	#endif
	#ifdef XKB_KEY_braille_dots_13567
		swigIntConstant( XKB_KEY_braille_dots_13567, "XKB_KEY_braille_dots_13567" );
	#endif
	#ifdef XKB_KEY_braille_dots_23567
		swigIntConstant( XKB_KEY_braille_dots_23567, "XKB_KEY_braille_dots_23567" );
	#endif
	#ifdef XKB_KEY_braille_dots_123567
		swigIntConstant( XKB_KEY_braille_dots_123567, "XKB_KEY_braille_dots_123567" );
	#endif
	#ifdef XKB_KEY_braille_dots_4567
		swigIntConstant( XKB_KEY_braille_dots_4567, "XKB_KEY_braille_dots_4567" );
	#endif
	#ifdef XKB_KEY_braille_dots_14567
		swigIntConstant( XKB_KEY_braille_dots_14567, "XKB_KEY_braille_dots_14567" );
	#endif
	#ifdef XKB_KEY_braille_dots_24567
		swigIntConstant( XKB_KEY_braille_dots_24567, "XKB_KEY_braille_dots_24567" );
	#endif
	#ifdef XKB_KEY_braille_dots_124567
		swigIntConstant( XKB_KEY_braille_dots_124567, "XKB_KEY_braille_dots_124567" );
	#endif
	#ifdef XKB_KEY_braille_dots_34567
		swigIntConstant( XKB_KEY_braille_dots_34567, "XKB_KEY_braille_dots_34567" );
	#endif
	#ifdef XKB_KEY_braille_dots_134567
		swigIntConstant( XKB_KEY_braille_dots_134567, "XKB_KEY_braille_dots_134567" );
	#endif
	#ifdef XKB_KEY_braille_dots_234567
		swigIntConstant( XKB_KEY_braille_dots_234567, "XKB_KEY_braille_dots_234567" );
	#endif
	#ifdef XKB_KEY_braille_dots_1234567
		swigIntConstant( XKB_KEY_braille_dots_1234567, "XKB_KEY_braille_dots_1234567" );
	#endif
	#ifdef XKB_KEY_braille_dots_8
		swigIntConstant( XKB_KEY_braille_dots_8, "XKB_KEY_braille_dots_8" );
	#endif
	#ifdef XKB_KEY_braille_dots_18
		swigIntConstant( XKB_KEY_braille_dots_18, "XKB_KEY_braille_dots_18" );
	#endif
	#ifdef XKB_KEY_braille_dots_28
		swigIntConstant( XKB_KEY_braille_dots_28, "XKB_KEY_braille_dots_28" );
	#endif
	#ifdef XKB_KEY_braille_dots_128
		swigIntConstant( XKB_KEY_braille_dots_128, "XKB_KEY_braille_dots_128" );
	#endif
	#ifdef XKB_KEY_braille_dots_38
		swigIntConstant( XKB_KEY_braille_dots_38, "XKB_KEY_braille_dots_38" );
	#endif
	#ifdef XKB_KEY_braille_dots_138
		swigIntConstant( XKB_KEY_braille_dots_138, "XKB_KEY_braille_dots_138" );
	#endif
	#ifdef XKB_KEY_braille_dots_238
		swigIntConstant( XKB_KEY_braille_dots_238, "XKB_KEY_braille_dots_238" );
	#endif
	#ifdef XKB_KEY_braille_dots_1238
		swigIntConstant( XKB_KEY_braille_dots_1238, "XKB_KEY_braille_dots_1238" );
	#endif
	#ifdef XKB_KEY_braille_dots_48
		swigIntConstant( XKB_KEY_braille_dots_48, "XKB_KEY_braille_dots_48" );
	#endif
	#ifdef XKB_KEY_braille_dots_148
		swigIntConstant( XKB_KEY_braille_dots_148, "XKB_KEY_braille_dots_148" );
	#endif
	#ifdef XKB_KEY_braille_dots_248
		swigIntConstant( XKB_KEY_braille_dots_248, "XKB_KEY_braille_dots_248" );
	#endif
	#ifdef XKB_KEY_braille_dots_1248
		swigIntConstant( XKB_KEY_braille_dots_1248, "XKB_KEY_braille_dots_1248" );
	#endif
	#ifdef XKB_KEY_braille_dots_348
		swigIntConstant( XKB_KEY_braille_dots_348, "XKB_KEY_braille_dots_348" );
	#endif
	#ifdef XKB_KEY_braille_dots_1348
		swigIntConstant( XKB_KEY_braille_dots_1348, "XKB_KEY_braille_dots_1348" );
	#endif
	#ifdef XKB_KEY_braille_dots_2348
		swigIntConstant( XKB_KEY_braille_dots_2348, "XKB_KEY_braille_dots_2348" );
	#endif
	#ifdef XKB_KEY_braille_dots_12348
		swigIntConstant( XKB_KEY_braille_dots_12348, "XKB_KEY_braille_dots_12348" );
	#endif
	#ifdef XKB_KEY_braille_dots_58
		swigIntConstant( XKB_KEY_braille_dots_58, "XKB_KEY_braille_dots_58" );
	#endif
	#ifdef XKB_KEY_braille_dots_158
		swigIntConstant( XKB_KEY_braille_dots_158, "XKB_KEY_braille_dots_158" );
	#endif
	#ifdef XKB_KEY_braille_dots_258
		swigIntConstant( XKB_KEY_braille_dots_258, "XKB_KEY_braille_dots_258" );
	#endif
	#ifdef XKB_KEY_braille_dots_1258
		swigIntConstant( XKB_KEY_braille_dots_1258, "XKB_KEY_braille_dots_1258" );
	#endif
	#ifdef XKB_KEY_braille_dots_358
		swigIntConstant( XKB_KEY_braille_dots_358, "XKB_KEY_braille_dots_358" );
	#endif
	#ifdef XKB_KEY_braille_dots_1358
		swigIntConstant( XKB_KEY_braille_dots_1358, "XKB_KEY_braille_dots_1358" );
	#endif
	#ifdef XKB_KEY_braille_dots_2358
		swigIntConstant( XKB_KEY_braille_dots_2358, "XKB_KEY_braille_dots_2358" );
	#endif
	#ifdef XKB_KEY_braille_dots_12358
		swigIntConstant( XKB_KEY_braille_dots_12358, "XKB_KEY_braille_dots_12358" );
	#endif
	#ifdef XKB_KEY_braille_dots_458
		swigIntConstant( XKB_KEY_braille_dots_458, "XKB_KEY_braille_dots_458" );
	#endif
	#ifdef XKB_KEY_braille_dots_1458
		swigIntConstant( XKB_KEY_braille_dots_1458, "XKB_KEY_braille_dots_1458" );
	#endif
	#ifdef XKB_KEY_braille_dots_2458
		swigIntConstant( XKB_KEY_braille_dots_2458, "XKB_KEY_braille_dots_2458" );
	#endif
	#ifdef XKB_KEY_braille_dots_12458
		swigIntConstant( XKB_KEY_braille_dots_12458, "XKB_KEY_braille_dots_12458" );
	#endif
	#ifdef XKB_KEY_braille_dots_3458
		swigIntConstant( XKB_KEY_braille_dots_3458, "XKB_KEY_braille_dots_3458" );
	#endif
	#ifdef XKB_KEY_braille_dots_13458
		swigIntConstant( XKB_KEY_braille_dots_13458, "XKB_KEY_braille_dots_13458" );
	#endif
	#ifdef XKB_KEY_braille_dots_23458
		swigIntConstant( XKB_KEY_braille_dots_23458, "XKB_KEY_braille_dots_23458" );
	#endif
	#ifdef XKB_KEY_braille_dots_123458
		swigIntConstant( XKB_KEY_braille_dots_123458, "XKB_KEY_braille_dots_123458" );
	#endif
	#ifdef XKB_KEY_braille_dots_68
		swigIntConstant( XKB_KEY_braille_dots_68, "XKB_KEY_braille_dots_68" );
	#endif
	#ifdef XKB_KEY_braille_dots_168
		swigIntConstant( XKB_KEY_braille_dots_168, "XKB_KEY_braille_dots_168" );
	#endif
	#ifdef XKB_KEY_braille_dots_268
		swigIntConstant( XKB_KEY_braille_dots_268, "XKB_KEY_braille_dots_268" );
	#endif
	#ifdef XKB_KEY_braille_dots_1268
		swigIntConstant( XKB_KEY_braille_dots_1268, "XKB_KEY_braille_dots_1268" );
	#endif
	#ifdef XKB_KEY_braille_dots_368
		swigIntConstant( XKB_KEY_braille_dots_368, "XKB_KEY_braille_dots_368" );
	#endif
	#ifdef XKB_KEY_braille_dots_1368
		swigIntConstant( XKB_KEY_braille_dots_1368, "XKB_KEY_braille_dots_1368" );
	#endif
	#ifdef XKB_KEY_braille_dots_2368
		swigIntConstant( XKB_KEY_braille_dots_2368, "XKB_KEY_braille_dots_2368" );
	#endif
	#ifdef XKB_KEY_braille_dots_12368
		swigIntConstant( XKB_KEY_braille_dots_12368, "XKB_KEY_braille_dots_12368" );
	#endif
	#ifdef XKB_KEY_braille_dots_468
		swigIntConstant( XKB_KEY_braille_dots_468, "XKB_KEY_braille_dots_468" );
	#endif
	#ifdef XKB_KEY_braille_dots_1468
		swigIntConstant( XKB_KEY_braille_dots_1468, "XKB_KEY_braille_dots_1468" );
	#endif
	#ifdef XKB_KEY_braille_dots_2468
		swigIntConstant( XKB_KEY_braille_dots_2468, "XKB_KEY_braille_dots_2468" );
	#endif
	#ifdef XKB_KEY_braille_dots_12468
		swigIntConstant( XKB_KEY_braille_dots_12468, "XKB_KEY_braille_dots_12468" );
	#endif
	#ifdef XKB_KEY_braille_dots_3468
		swigIntConstant( XKB_KEY_braille_dots_3468, "XKB_KEY_braille_dots_3468" );
	#endif
	#ifdef XKB_KEY_braille_dots_13468
		swigIntConstant( XKB_KEY_braille_dots_13468, "XKB_KEY_braille_dots_13468" );
	#endif
	#ifdef XKB_KEY_braille_dots_23468
		swigIntConstant( XKB_KEY_braille_dots_23468, "XKB_KEY_braille_dots_23468" );
	#endif
	#ifdef XKB_KEY_braille_dots_123468
		swigIntConstant( XKB_KEY_braille_dots_123468, "XKB_KEY_braille_dots_123468" );
	#endif
	#ifdef XKB_KEY_braille_dots_568
		swigIntConstant( XKB_KEY_braille_dots_568, "XKB_KEY_braille_dots_568" );
	#endif
	#ifdef XKB_KEY_braille_dots_1568
		swigIntConstant( XKB_KEY_braille_dots_1568, "XKB_KEY_braille_dots_1568" );
	#endif
	#ifdef XKB_KEY_braille_dots_2568
		swigIntConstant( XKB_KEY_braille_dots_2568, "XKB_KEY_braille_dots_2568" );
	#endif
	#ifdef XKB_KEY_braille_dots_12568
		swigIntConstant( XKB_KEY_braille_dots_12568, "XKB_KEY_braille_dots_12568" );
	#endif
	#ifdef XKB_KEY_braille_dots_3568
		swigIntConstant( XKB_KEY_braille_dots_3568, "XKB_KEY_braille_dots_3568" );
	#endif
	#ifdef XKB_KEY_braille_dots_13568
		swigIntConstant( XKB_KEY_braille_dots_13568, "XKB_KEY_braille_dots_13568" );
	#endif
	#ifdef XKB_KEY_braille_dots_23568
		swigIntConstant( XKB_KEY_braille_dots_23568, "XKB_KEY_braille_dots_23568" );
	#endif
	#ifdef XKB_KEY_braille_dots_123568
		swigIntConstant( XKB_KEY_braille_dots_123568, "XKB_KEY_braille_dots_123568" );
	#endif
	#ifdef XKB_KEY_braille_dots_4568
		swigIntConstant( XKB_KEY_braille_dots_4568, "XKB_KEY_braille_dots_4568" );
	#endif
	#ifdef XKB_KEY_braille_dots_14568
		swigIntConstant( XKB_KEY_braille_dots_14568, "XKB_KEY_braille_dots_14568" );
	#endif
	#ifdef XKB_KEY_braille_dots_24568
		swigIntConstant( XKB_KEY_braille_dots_24568, "XKB_KEY_braille_dots_24568" );
	#endif
	#ifdef XKB_KEY_braille_dots_124568
		swigIntConstant( XKB_KEY_braille_dots_124568, "XKB_KEY_braille_dots_124568" );
	#endif
	#ifdef XKB_KEY_braille_dots_34568
		swigIntConstant( XKB_KEY_braille_dots_34568, "XKB_KEY_braille_dots_34568" );
	#endif
	#ifdef XKB_KEY_braille_dots_134568
		swigIntConstant( XKB_KEY_braille_dots_134568, "XKB_KEY_braille_dots_134568" );
	#endif
	#ifdef XKB_KEY_braille_dots_234568
		swigIntConstant( XKB_KEY_braille_dots_234568, "XKB_KEY_braille_dots_234568" );
	#endif
	#ifdef XKB_KEY_braille_dots_1234568
		swigIntConstant( XKB_KEY_braille_dots_1234568, "XKB_KEY_braille_dots_1234568" );
	#endif
	#ifdef XKB_KEY_braille_dots_78
		swigIntConstant( XKB_KEY_braille_dots_78, "XKB_KEY_braille_dots_78" );
	#endif
	#ifdef XKB_KEY_braille_dots_178
		swigIntConstant( XKB_KEY_braille_dots_178, "XKB_KEY_braille_dots_178" );
	#endif
	#ifdef XKB_KEY_braille_dots_278
		swigIntConstant( XKB_KEY_braille_dots_278, "XKB_KEY_braille_dots_278" );
	#endif
	#ifdef XKB_KEY_braille_dots_1278
		swigIntConstant( XKB_KEY_braille_dots_1278, "XKB_KEY_braille_dots_1278" );
	#endif
	#ifdef XKB_KEY_braille_dots_378
		swigIntConstant( XKB_KEY_braille_dots_378, "XKB_KEY_braille_dots_378" );
	#endif
	#ifdef XKB_KEY_braille_dots_1378
		swigIntConstant( XKB_KEY_braille_dots_1378, "XKB_KEY_braille_dots_1378" );
	#endif
	#ifdef XKB_KEY_braille_dots_2378
		swigIntConstant( XKB_KEY_braille_dots_2378, "XKB_KEY_braille_dots_2378" );
	#endif
	#ifdef XKB_KEY_braille_dots_12378
		swigIntConstant( XKB_KEY_braille_dots_12378, "XKB_KEY_braille_dots_12378" );
	#endif
	#ifdef XKB_KEY_braille_dots_478
		swigIntConstant( XKB_KEY_braille_dots_478, "XKB_KEY_braille_dots_478" );
	#endif
	#ifdef XKB_KEY_braille_dots_1478
		swigIntConstant( XKB_KEY_braille_dots_1478, "XKB_KEY_braille_dots_1478" );
	#endif
	#ifdef XKB_KEY_braille_dots_2478
		swigIntConstant( XKB_KEY_braille_dots_2478, "XKB_KEY_braille_dots_2478" );
	#endif
	#ifdef XKB_KEY_braille_dots_12478
		swigIntConstant( XKB_KEY_braille_dots_12478, "XKB_KEY_braille_dots_12478" );
	#endif
	#ifdef XKB_KEY_braille_dots_3478
		swigIntConstant( XKB_KEY_braille_dots_3478, "XKB_KEY_braille_dots_3478" );
	#endif
	#ifdef XKB_KEY_braille_dots_13478
		swigIntConstant( XKB_KEY_braille_dots_13478, "XKB_KEY_braille_dots_13478" );
	#endif
	#ifdef XKB_KEY_braille_dots_23478
		swigIntConstant( XKB_KEY_braille_dots_23478, "XKB_KEY_braille_dots_23478" );
	#endif
	#ifdef XKB_KEY_braille_dots_123478
		swigIntConstant( XKB_KEY_braille_dots_123478, "XKB_KEY_braille_dots_123478" );
	#endif
	#ifdef XKB_KEY_braille_dots_578
		swigIntConstant( XKB_KEY_braille_dots_578, "XKB_KEY_braille_dots_578" );
	#endif
	#ifdef XKB_KEY_braille_dots_1578
		swigIntConstant( XKB_KEY_braille_dots_1578, "XKB_KEY_braille_dots_1578" );
	#endif
	#ifdef XKB_KEY_braille_dots_2578
		swigIntConstant( XKB_KEY_braille_dots_2578, "XKB_KEY_braille_dots_2578" );
	#endif
	#ifdef XKB_KEY_braille_dots_12578
		swigIntConstant( XKB_KEY_braille_dots_12578, "XKB_KEY_braille_dots_12578" );
	#endif
	#ifdef XKB_KEY_braille_dots_3578
		swigIntConstant( XKB_KEY_braille_dots_3578, "XKB_KEY_braille_dots_3578" );
	#endif
	#ifdef XKB_KEY_braille_dots_13578
		swigIntConstant( XKB_KEY_braille_dots_13578, "XKB_KEY_braille_dots_13578" );
	#endif
	#ifdef XKB_KEY_braille_dots_23578
		swigIntConstant( XKB_KEY_braille_dots_23578, "XKB_KEY_braille_dots_23578" );
	#endif
	#ifdef XKB_KEY_braille_dots_123578
		swigIntConstant( XKB_KEY_braille_dots_123578, "XKB_KEY_braille_dots_123578" );
	#endif
	#ifdef XKB_KEY_braille_dots_4578
		swigIntConstant( XKB_KEY_braille_dots_4578, "XKB_KEY_braille_dots_4578" );
	#endif
	#ifdef XKB_KEY_braille_dots_14578
		swigIntConstant( XKB_KEY_braille_dots_14578, "XKB_KEY_braille_dots_14578" );
	#endif
	#ifdef XKB_KEY_braille_dots_24578
		swigIntConstant( XKB_KEY_braille_dots_24578, "XKB_KEY_braille_dots_24578" );
	#endif
	#ifdef XKB_KEY_braille_dots_124578
		swigIntConstant( XKB_KEY_braille_dots_124578, "XKB_KEY_braille_dots_124578" );
	#endif
	#ifdef XKB_KEY_braille_dots_34578
		swigIntConstant( XKB_KEY_braille_dots_34578, "XKB_KEY_braille_dots_34578" );
	#endif
	#ifdef XKB_KEY_braille_dots_134578
		swigIntConstant( XKB_KEY_braille_dots_134578, "XKB_KEY_braille_dots_134578" );
	#endif
	#ifdef XKB_KEY_braille_dots_234578
		swigIntConstant( XKB_KEY_braille_dots_234578, "XKB_KEY_braille_dots_234578" );
	#endif
	#ifdef XKB_KEY_braille_dots_1234578
		swigIntConstant( XKB_KEY_braille_dots_1234578, "XKB_KEY_braille_dots_1234578" );
	#endif
	#ifdef XKB_KEY_braille_dots_678
		swigIntConstant( XKB_KEY_braille_dots_678, "XKB_KEY_braille_dots_678" );
	#endif
	#ifdef XKB_KEY_braille_dots_1678
		swigIntConstant( XKB_KEY_braille_dots_1678, "XKB_KEY_braille_dots_1678" );
	#endif
	#ifdef XKB_KEY_braille_dots_2678
		swigIntConstant( XKB_KEY_braille_dots_2678, "XKB_KEY_braille_dots_2678" );
	#endif
	#ifdef XKB_KEY_braille_dots_12678
		swigIntConstant( XKB_KEY_braille_dots_12678, "XKB_KEY_braille_dots_12678" );
	#endif
	#ifdef XKB_KEY_braille_dots_3678
		swigIntConstant( XKB_KEY_braille_dots_3678, "XKB_KEY_braille_dots_3678" );
	#endif
	#ifdef XKB_KEY_braille_dots_13678
		swigIntConstant( XKB_KEY_braille_dots_13678, "XKB_KEY_braille_dots_13678" );
	#endif
	#ifdef XKB_KEY_braille_dots_23678
		swigIntConstant( XKB_KEY_braille_dots_23678, "XKB_KEY_braille_dots_23678" );
	#endif
	#ifdef XKB_KEY_braille_dots_123678
		swigIntConstant( XKB_KEY_braille_dots_123678, "XKB_KEY_braille_dots_123678" );
	#endif
	#ifdef XKB_KEY_braille_dots_4678
		swigIntConstant( XKB_KEY_braille_dots_4678, "XKB_KEY_braille_dots_4678" );
	#endif
	#ifdef XKB_KEY_braille_dots_14678
		swigIntConstant( XKB_KEY_braille_dots_14678, "XKB_KEY_braille_dots_14678" );
	#endif
	#ifdef XKB_KEY_braille_dots_24678
		swigIntConstant( XKB_KEY_braille_dots_24678, "XKB_KEY_braille_dots_24678" );
	#endif
	#ifdef XKB_KEY_braille_dots_124678
		swigIntConstant( XKB_KEY_braille_dots_124678, "XKB_KEY_braille_dots_124678" );
	#endif
	#ifdef XKB_KEY_braille_dots_34678
		swigIntConstant( XKB_KEY_braille_dots_34678, "XKB_KEY_braille_dots_34678" );
	#endif
	#ifdef XKB_KEY_braille_dots_134678
		swigIntConstant( XKB_KEY_braille_dots_134678, "XKB_KEY_braille_dots_134678" );
	#endif
	#ifdef XKB_KEY_braille_dots_234678
		swigIntConstant( XKB_KEY_braille_dots_234678, "XKB_KEY_braille_dots_234678" );
	#endif
	#ifdef XKB_KEY_braille_dots_1234678
		swigIntConstant( XKB_KEY_braille_dots_1234678, "XKB_KEY_braille_dots_1234678" );
	#endif
	#ifdef XKB_KEY_braille_dots_5678
		swigIntConstant( XKB_KEY_braille_dots_5678, "XKB_KEY_braille_dots_5678" );
	#endif
	#ifdef XKB_KEY_braille_dots_15678
		swigIntConstant( XKB_KEY_braille_dots_15678, "XKB_KEY_braille_dots_15678" );
	#endif
	#ifdef XKB_KEY_braille_dots_25678
		swigIntConstant( XKB_KEY_braille_dots_25678, "XKB_KEY_braille_dots_25678" );
	#endif
	#ifdef XKB_KEY_braille_dots_125678
		swigIntConstant( XKB_KEY_braille_dots_125678, "XKB_KEY_braille_dots_125678" );
	#endif
	#ifdef XKB_KEY_braille_dots_35678
		swigIntConstant( XKB_KEY_braille_dots_35678, "XKB_KEY_braille_dots_35678" );
	#endif
	#ifdef XKB_KEY_braille_dots_135678
		swigIntConstant( XKB_KEY_braille_dots_135678, "XKB_KEY_braille_dots_135678" );
	#endif
	#ifdef XKB_KEY_braille_dots_235678
		swigIntConstant( XKB_KEY_braille_dots_235678, "XKB_KEY_braille_dots_235678" );
	#endif
	#ifdef XKB_KEY_braille_dots_1235678
		swigIntConstant( XKB_KEY_braille_dots_1235678, "XKB_KEY_braille_dots_1235678" );
	#endif
	#ifdef XKB_KEY_braille_dots_45678
		swigIntConstant( XKB_KEY_braille_dots_45678, "XKB_KEY_braille_dots_45678" );
	#endif
	#ifdef XKB_KEY_braille_dots_145678
		swigIntConstant( XKB_KEY_braille_dots_145678, "XKB_KEY_braille_dots_145678" );
	#endif
	#ifdef XKB_KEY_braille_dots_245678
		swigIntConstant( XKB_KEY_braille_dots_245678, "XKB_KEY_braille_dots_245678" );
	#endif
	#ifdef XKB_KEY_braille_dots_1245678
		swigIntConstant( XKB_KEY_braille_dots_1245678, "XKB_KEY_braille_dots_1245678" );
	#endif
	#ifdef XKB_KEY_braille_dots_345678
		swigIntConstant( XKB_KEY_braille_dots_345678, "XKB_KEY_braille_dots_345678" );
	#endif
	#ifdef XKB_KEY_braille_dots_1345678
		swigIntConstant( XKB_KEY_braille_dots_1345678, "XKB_KEY_braille_dots_1345678" );
	#endif
	#ifdef XKB_KEY_braille_dots_2345678
		swigIntConstant( XKB_KEY_braille_dots_2345678, "XKB_KEY_braille_dots_2345678" );
	#endif
	#ifdef XKB_KEY_braille_dots_12345678
		swigIntConstant( XKB_KEY_braille_dots_12345678, "XKB_KEY_braille_dots_12345678" );
	#endif
	#ifdef XKB_KEY_Sinh_ng
		swigIntConstant( XKB_KEY_Sinh_ng, "XKB_KEY_Sinh_ng" );
	#endif
	#ifdef XKB_KEY_Sinh_h2
		swigIntConstant( XKB_KEY_Sinh_h2, "XKB_KEY_Sinh_h2" );
	#endif
	#ifdef XKB_KEY_Sinh_a
		swigIntConstant( XKB_KEY_Sinh_a, "XKB_KEY_Sinh_a" );
	#endif
	#ifdef XKB_KEY_Sinh_aa
		swigIntConstant( XKB_KEY_Sinh_aa, "XKB_KEY_Sinh_aa" );
	#endif
	#ifdef XKB_KEY_Sinh_ae
		swigIntConstant( XKB_KEY_Sinh_ae, "XKB_KEY_Sinh_ae" );
	#endif
	#ifdef XKB_KEY_Sinh_aee
		swigIntConstant( XKB_KEY_Sinh_aee, "XKB_KEY_Sinh_aee" );
	#endif
	#ifdef XKB_KEY_Sinh_i
		swigIntConstant( XKB_KEY_Sinh_i, "XKB_KEY_Sinh_i" );
	#endif
	#ifdef XKB_KEY_Sinh_ii
		swigIntConstant( XKB_KEY_Sinh_ii, "XKB_KEY_Sinh_ii" );
	#endif
	#ifdef XKB_KEY_Sinh_u
		swigIntConstant( XKB_KEY_Sinh_u, "XKB_KEY_Sinh_u" );
	#endif
	#ifdef XKB_KEY_Sinh_uu
		swigIntConstant( XKB_KEY_Sinh_uu, "XKB_KEY_Sinh_uu" );
	#endif
	#ifdef XKB_KEY_Sinh_ri
		swigIntConstant( XKB_KEY_Sinh_ri, "XKB_KEY_Sinh_ri" );
	#endif
	#ifdef XKB_KEY_Sinh_rii
		swigIntConstant( XKB_KEY_Sinh_rii, "XKB_KEY_Sinh_rii" );
	#endif
	#ifdef XKB_KEY_Sinh_lu
		swigIntConstant( XKB_KEY_Sinh_lu, "XKB_KEY_Sinh_lu" );
	#endif
	#ifdef XKB_KEY_Sinh_luu
		swigIntConstant( XKB_KEY_Sinh_luu, "XKB_KEY_Sinh_luu" );
	#endif
	#ifdef XKB_KEY_Sinh_e
		swigIntConstant( XKB_KEY_Sinh_e, "XKB_KEY_Sinh_e" );
	#endif
	#ifdef XKB_KEY_Sinh_ee
		swigIntConstant( XKB_KEY_Sinh_ee, "XKB_KEY_Sinh_ee" );
	#endif
	#ifdef XKB_KEY_Sinh_ai
		swigIntConstant( XKB_KEY_Sinh_ai, "XKB_KEY_Sinh_ai" );
	#endif
	#ifdef XKB_KEY_Sinh_o
		swigIntConstant( XKB_KEY_Sinh_o, "XKB_KEY_Sinh_o" );
	#endif
	#ifdef XKB_KEY_Sinh_oo
		swigIntConstant( XKB_KEY_Sinh_oo, "XKB_KEY_Sinh_oo" );
	#endif
	#ifdef XKB_KEY_Sinh_au
		swigIntConstant( XKB_KEY_Sinh_au, "XKB_KEY_Sinh_au" );
	#endif
	#ifdef XKB_KEY_Sinh_ka
		swigIntConstant( XKB_KEY_Sinh_ka, "XKB_KEY_Sinh_ka" );
	#endif
	#ifdef XKB_KEY_Sinh_kha
		swigIntConstant( XKB_KEY_Sinh_kha, "XKB_KEY_Sinh_kha" );
	#endif
	#ifdef XKB_KEY_Sinh_ga
		swigIntConstant( XKB_KEY_Sinh_ga, "XKB_KEY_Sinh_ga" );
	#endif
	#ifdef XKB_KEY_Sinh_gha
		swigIntConstant( XKB_KEY_Sinh_gha, "XKB_KEY_Sinh_gha" );
	#endif
	#ifdef XKB_KEY_Sinh_ng2
		swigIntConstant( XKB_KEY_Sinh_ng2, "XKB_KEY_Sinh_ng2" );
	#endif
	#ifdef XKB_KEY_Sinh_nga
		swigIntConstant( XKB_KEY_Sinh_nga, "XKB_KEY_Sinh_nga" );
	#endif
	#ifdef XKB_KEY_Sinh_ca
		swigIntConstant( XKB_KEY_Sinh_ca, "XKB_KEY_Sinh_ca" );
	#endif
	#ifdef XKB_KEY_Sinh_cha
		swigIntConstant( XKB_KEY_Sinh_cha, "XKB_KEY_Sinh_cha" );
	#endif
	#ifdef XKB_KEY_Sinh_ja
		swigIntConstant( XKB_KEY_Sinh_ja, "XKB_KEY_Sinh_ja" );
	#endif
	#ifdef XKB_KEY_Sinh_jha
		swigIntConstant( XKB_KEY_Sinh_jha, "XKB_KEY_Sinh_jha" );
	#endif
	#ifdef XKB_KEY_Sinh_nya
		swigIntConstant( XKB_KEY_Sinh_nya, "XKB_KEY_Sinh_nya" );
	#endif
	#ifdef XKB_KEY_Sinh_jnya
		swigIntConstant( XKB_KEY_Sinh_jnya, "XKB_KEY_Sinh_jnya" );
	#endif
	#ifdef XKB_KEY_Sinh_nja
		swigIntConstant( XKB_KEY_Sinh_nja, "XKB_KEY_Sinh_nja" );
	#endif
	#ifdef XKB_KEY_Sinh_tta
		swigIntConstant( XKB_KEY_Sinh_tta, "XKB_KEY_Sinh_tta" );
	#endif
	#ifdef XKB_KEY_Sinh_ttha
		swigIntConstant( XKB_KEY_Sinh_ttha, "XKB_KEY_Sinh_ttha" );
	#endif
	#ifdef XKB_KEY_Sinh_dda
		swigIntConstant( XKB_KEY_Sinh_dda, "XKB_KEY_Sinh_dda" );
	#endif
	#ifdef XKB_KEY_Sinh_ddha
		swigIntConstant( XKB_KEY_Sinh_ddha, "XKB_KEY_Sinh_ddha" );
	#endif
	#ifdef XKB_KEY_Sinh_nna
		swigIntConstant( XKB_KEY_Sinh_nna, "XKB_KEY_Sinh_nna" );
	#endif
	#ifdef XKB_KEY_Sinh_ndda
		swigIntConstant( XKB_KEY_Sinh_ndda, "XKB_KEY_Sinh_ndda" );
	#endif
	#ifdef XKB_KEY_Sinh_tha
		swigIntConstant( XKB_KEY_Sinh_tha, "XKB_KEY_Sinh_tha" );
	#endif
	#ifdef XKB_KEY_Sinh_thha
		swigIntConstant( XKB_KEY_Sinh_thha, "XKB_KEY_Sinh_thha" );
	#endif
	#ifdef XKB_KEY_Sinh_dha
		swigIntConstant( XKB_KEY_Sinh_dha, "XKB_KEY_Sinh_dha" );
	#endif
	#ifdef XKB_KEY_Sinh_dhha
		swigIntConstant( XKB_KEY_Sinh_dhha, "XKB_KEY_Sinh_dhha" );
	#endif
	#ifdef XKB_KEY_Sinh_na
		swigIntConstant( XKB_KEY_Sinh_na, "XKB_KEY_Sinh_na" );
	#endif
	#ifdef XKB_KEY_Sinh_ndha
		swigIntConstant( XKB_KEY_Sinh_ndha, "XKB_KEY_Sinh_ndha" );
	#endif
	#ifdef XKB_KEY_Sinh_pa
		swigIntConstant( XKB_KEY_Sinh_pa, "XKB_KEY_Sinh_pa" );
	#endif
	#ifdef XKB_KEY_Sinh_pha
		swigIntConstant( XKB_KEY_Sinh_pha, "XKB_KEY_Sinh_pha" );
	#endif
	#ifdef XKB_KEY_Sinh_ba
		swigIntConstant( XKB_KEY_Sinh_ba, "XKB_KEY_Sinh_ba" );
	#endif
	#ifdef XKB_KEY_Sinh_bha
		swigIntConstant( XKB_KEY_Sinh_bha, "XKB_KEY_Sinh_bha" );
	#endif
	#ifdef XKB_KEY_Sinh_ma
		swigIntConstant( XKB_KEY_Sinh_ma, "XKB_KEY_Sinh_ma" );
	#endif
	#ifdef XKB_KEY_Sinh_mba
		swigIntConstant( XKB_KEY_Sinh_mba, "XKB_KEY_Sinh_mba" );
	#endif
	#ifdef XKB_KEY_Sinh_ya
		swigIntConstant( XKB_KEY_Sinh_ya, "XKB_KEY_Sinh_ya" );
	#endif
	#ifdef XKB_KEY_Sinh_ra
		swigIntConstant( XKB_KEY_Sinh_ra, "XKB_KEY_Sinh_ra" );
	#endif
	#ifdef XKB_KEY_Sinh_la
		swigIntConstant( XKB_KEY_Sinh_la, "XKB_KEY_Sinh_la" );
	#endif
	#ifdef XKB_KEY_Sinh_va
		swigIntConstant( XKB_KEY_Sinh_va, "XKB_KEY_Sinh_va" );
	#endif
	#ifdef XKB_KEY_Sinh_sha
		swigIntConstant( XKB_KEY_Sinh_sha, "XKB_KEY_Sinh_sha" );
	#endif
	#ifdef XKB_KEY_Sinh_ssha
		swigIntConstant( XKB_KEY_Sinh_ssha, "XKB_KEY_Sinh_ssha" );
	#endif
	#ifdef XKB_KEY_Sinh_sa
		swigIntConstant( XKB_KEY_Sinh_sa, "XKB_KEY_Sinh_sa" );
	#endif
	#ifdef XKB_KEY_Sinh_ha
		swigIntConstant( XKB_KEY_Sinh_ha, "XKB_KEY_Sinh_ha" );
	#endif
	#ifdef XKB_KEY_Sinh_lla
		swigIntConstant( XKB_KEY_Sinh_lla, "XKB_KEY_Sinh_lla" );
	#endif
	#ifdef XKB_KEY_Sinh_fa
		swigIntConstant( XKB_KEY_Sinh_fa, "XKB_KEY_Sinh_fa" );
	#endif
	#ifdef XKB_KEY_Sinh_al
		swigIntConstant( XKB_KEY_Sinh_al, "XKB_KEY_Sinh_al" );
	#endif
	#ifdef XKB_KEY_Sinh_aa2
		swigIntConstant( XKB_KEY_Sinh_aa2, "XKB_KEY_Sinh_aa2" );
	#endif
	#ifdef XKB_KEY_Sinh_ae2
		swigIntConstant( XKB_KEY_Sinh_ae2, "XKB_KEY_Sinh_ae2" );
	#endif
	#ifdef XKB_KEY_Sinh_aee2
		swigIntConstant( XKB_KEY_Sinh_aee2, "XKB_KEY_Sinh_aee2" );
	#endif
	#ifdef XKB_KEY_Sinh_i2
		swigIntConstant( XKB_KEY_Sinh_i2, "XKB_KEY_Sinh_i2" );
	#endif
	#ifdef XKB_KEY_Sinh_ii2
		swigIntConstant( XKB_KEY_Sinh_ii2, "XKB_KEY_Sinh_ii2" );
	#endif
	#ifdef XKB_KEY_Sinh_u2
		swigIntConstant( XKB_KEY_Sinh_u2, "XKB_KEY_Sinh_u2" );
	#endif
	#ifdef XKB_KEY_Sinh_uu2
		swigIntConstant( XKB_KEY_Sinh_uu2, "XKB_KEY_Sinh_uu2" );
	#endif
	#ifdef XKB_KEY_Sinh_ru2
		swigIntConstant( XKB_KEY_Sinh_ru2, "XKB_KEY_Sinh_ru2" );
	#endif
	#ifdef XKB_KEY_Sinh_e2
		swigIntConstant( XKB_KEY_Sinh_e2, "XKB_KEY_Sinh_e2" );
	#endif
	#ifdef XKB_KEY_Sinh_ee2
		swigIntConstant( XKB_KEY_Sinh_ee2, "XKB_KEY_Sinh_ee2" );
	#endif
	#ifdef XKB_KEY_Sinh_ai2
		swigIntConstant( XKB_KEY_Sinh_ai2, "XKB_KEY_Sinh_ai2" );
	#endif
	#ifdef XKB_KEY_Sinh_o2
		swigIntConstant( XKB_KEY_Sinh_o2, "XKB_KEY_Sinh_o2" );
	#endif
	#ifdef XKB_KEY_Sinh_oo2
		swigIntConstant( XKB_KEY_Sinh_oo2, "XKB_KEY_Sinh_oo2" );
	#endif
	#ifdef XKB_KEY_Sinh_au2
		swigIntConstant( XKB_KEY_Sinh_au2, "XKB_KEY_Sinh_au2" );
	#endif
	#ifdef XKB_KEY_Sinh_lu2
		swigIntConstant( XKB_KEY_Sinh_lu2, "XKB_KEY_Sinh_lu2" );
	#endif
	#ifdef XKB_KEY_Sinh_ruu2
		swigIntConstant( XKB_KEY_Sinh_ruu2, "XKB_KEY_Sinh_ruu2" );
	#endif
	#ifdef XKB_KEY_Sinh_luu2
		swigIntConstant( XKB_KEY_Sinh_luu2, "XKB_KEY_Sinh_luu2" );
	#endif
	#ifdef XKB_KEY_Sinh_kunddaliya
		swigIntConstant( XKB_KEY_Sinh_kunddaliya, "XKB_KEY_Sinh_kunddaliya" );
	#endif
	#ifdef XKB_KEY_XF86ModeLock
		swigIntConstant( XKB_KEY_XF86ModeLock, "XKB_KEY_XF86ModeLock" );
	#endif
	#ifdef XKB_KEY_XF86MonBrightnessUp
		swigIntConstant( XKB_KEY_XF86MonBrightnessUp, "XKB_KEY_XF86MonBrightnessUp" );
	#endif
	#ifdef XKB_KEY_XF86MonBrightnessDown
		swigIntConstant( XKB_KEY_XF86MonBrightnessDown, "XKB_KEY_XF86MonBrightnessDown" );
	#endif
	#ifdef XKB_KEY_XF86KbdLightOnOff
		swigIntConstant( XKB_KEY_XF86KbdLightOnOff, "XKB_KEY_XF86KbdLightOnOff" );
	#endif
	#ifdef XKB_KEY_XF86KbdBrightnessUp
		swigIntConstant( XKB_KEY_XF86KbdBrightnessUp, "XKB_KEY_XF86KbdBrightnessUp" );
	#endif
	#ifdef XKB_KEY_XF86KbdBrightnessDown
		swigIntConstant( XKB_KEY_XF86KbdBrightnessDown, "XKB_KEY_XF86KbdBrightnessDown" );
	#endif
	#ifdef XKB_KEY_XF86MonBrightnessCycle
		swigIntConstant( XKB_KEY_XF86MonBrightnessCycle, "XKB_KEY_XF86MonBrightnessCycle" );
	#endif
	#ifdef XKB_KEY_XF86Standby
		swigIntConstant( XKB_KEY_XF86Standby, "XKB_KEY_XF86Standby" );
	#endif
	#ifdef XKB_KEY_XF86AudioLowerVolume
		swigIntConstant( XKB_KEY_XF86AudioLowerVolume, "XKB_KEY_XF86AudioLowerVolume" );
	#endif
	#ifdef XKB_KEY_XF86AudioMute
		swigIntConstant( XKB_KEY_XF86AudioMute, "XKB_KEY_XF86AudioMute" );
	#endif
	#ifdef XKB_KEY_XF86AudioRaiseVolume
		swigIntConstant( XKB_KEY_XF86AudioRaiseVolume, "XKB_KEY_XF86AudioRaiseVolume" );
	#endif
	#ifdef XKB_KEY_XF86AudioPlay
		swigIntConstant( XKB_KEY_XF86AudioPlay, "XKB_KEY_XF86AudioPlay" );
	#endif
	#ifdef XKB_KEY_XF86AudioStop
		swigIntConstant( XKB_KEY_XF86AudioStop, "XKB_KEY_XF86AudioStop" );
	#endif
	#ifdef XKB_KEY_XF86AudioPrev
		swigIntConstant( XKB_KEY_XF86AudioPrev, "XKB_KEY_XF86AudioPrev" );
	#endif
	#ifdef XKB_KEY_XF86AudioNext
		swigIntConstant( XKB_KEY_XF86AudioNext, "XKB_KEY_XF86AudioNext" );
	#endif
	#ifdef XKB_KEY_XF86HomePage
		swigIntConstant( XKB_KEY_XF86HomePage, "XKB_KEY_XF86HomePage" );
	#endif
	#ifdef XKB_KEY_XF86Mail
		swigIntConstant( XKB_KEY_XF86Mail, "XKB_KEY_XF86Mail" );
	#endif
	#ifdef XKB_KEY_XF86Start
		swigIntConstant( XKB_KEY_XF86Start, "XKB_KEY_XF86Start" );
	#endif
	#ifdef XKB_KEY_XF86Search
		swigIntConstant( XKB_KEY_XF86Search, "XKB_KEY_XF86Search" );
	#endif
	#ifdef XKB_KEY_XF86AudioRecord
		swigIntConstant( XKB_KEY_XF86AudioRecord, "XKB_KEY_XF86AudioRecord" );
	#endif
	#ifdef XKB_KEY_XF86Calculator
		swigIntConstant( XKB_KEY_XF86Calculator, "XKB_KEY_XF86Calculator" );
	#endif
	#ifdef XKB_KEY_XF86Memo
		swigIntConstant( XKB_KEY_XF86Memo, "XKB_KEY_XF86Memo" );
	#endif
	#ifdef XKB_KEY_XF86ToDoList
		swigIntConstant( XKB_KEY_XF86ToDoList, "XKB_KEY_XF86ToDoList" );
	#endif
	#ifdef XKB_KEY_XF86Calendar
		swigIntConstant( XKB_KEY_XF86Calendar, "XKB_KEY_XF86Calendar" );
	#endif
	#ifdef XKB_KEY_XF86PowerDown
		swigIntConstant( XKB_KEY_XF86PowerDown, "XKB_KEY_XF86PowerDown" );
	#endif
	#ifdef XKB_KEY_XF86ContrastAdjust
		swigIntConstant( XKB_KEY_XF86ContrastAdjust, "XKB_KEY_XF86ContrastAdjust" );
	#endif
	#ifdef XKB_KEY_XF86RockerUp
		swigIntConstant( XKB_KEY_XF86RockerUp, "XKB_KEY_XF86RockerUp" );
	#endif
	#ifdef XKB_KEY_XF86RockerDown
		swigIntConstant( XKB_KEY_XF86RockerDown, "XKB_KEY_XF86RockerDown" );
	#endif
	#ifdef XKB_KEY_XF86RockerEnter
		swigIntConstant( XKB_KEY_XF86RockerEnter, "XKB_KEY_XF86RockerEnter" );
	#endif
	#ifdef XKB_KEY_XF86Back
		swigIntConstant( XKB_KEY_XF86Back, "XKB_KEY_XF86Back" );
	#endif
	#ifdef XKB_KEY_XF86Forward
		swigIntConstant( XKB_KEY_XF86Forward, "XKB_KEY_XF86Forward" );
	#endif
	#ifdef XKB_KEY_XF86Stop
		swigIntConstant( XKB_KEY_XF86Stop, "XKB_KEY_XF86Stop" );
	#endif
	#ifdef XKB_KEY_XF86Refresh
		swigIntConstant( XKB_KEY_XF86Refresh, "XKB_KEY_XF86Refresh" );
	#endif
	#ifdef XKB_KEY_XF86PowerOff
		swigIntConstant( XKB_KEY_XF86PowerOff, "XKB_KEY_XF86PowerOff" );
	#endif
	#ifdef XKB_KEY_XF86WakeUp
		swigIntConstant( XKB_KEY_XF86WakeUp, "XKB_KEY_XF86WakeUp" );
	#endif
	#ifdef XKB_KEY_XF86Eject
		swigIntConstant( XKB_KEY_XF86Eject, "XKB_KEY_XF86Eject" );
	#endif
	#ifdef XKB_KEY_XF86ScreenSaver
		swigIntConstant( XKB_KEY_XF86ScreenSaver, "XKB_KEY_XF86ScreenSaver" );
	#endif
	#ifdef XKB_KEY_XF86WWW
		swigIntConstant( XKB_KEY_XF86WWW, "XKB_KEY_XF86WWW" );
	#endif
	#ifdef XKB_KEY_XF86Sleep
		swigIntConstant( XKB_KEY_XF86Sleep, "XKB_KEY_XF86Sleep" );
	#endif
	#ifdef XKB_KEY_XF86Favorites
		swigIntConstant( XKB_KEY_XF86Favorites, "XKB_KEY_XF86Favorites" );
	#endif
	#ifdef XKB_KEY_XF86AudioPause
		swigIntConstant( XKB_KEY_XF86AudioPause, "XKB_KEY_XF86AudioPause" );
	#endif
	#ifdef XKB_KEY_XF86AudioMedia
		swigIntConstant( XKB_KEY_XF86AudioMedia, "XKB_KEY_XF86AudioMedia" );
	#endif
	#ifdef XKB_KEY_XF86MyComputer
		swigIntConstant( XKB_KEY_XF86MyComputer, "XKB_KEY_XF86MyComputer" );
	#endif
	#ifdef XKB_KEY_XF86VendorHome
		swigIntConstant( XKB_KEY_XF86VendorHome, "XKB_KEY_XF86VendorHome" );
	#endif
	#ifdef XKB_KEY_XF86LightBulb
		swigIntConstant( XKB_KEY_XF86LightBulb, "XKB_KEY_XF86LightBulb" );
	#endif
	#ifdef XKB_KEY_XF86Shop
		swigIntConstant( XKB_KEY_XF86Shop, "XKB_KEY_XF86Shop" );
	#endif
	#ifdef XKB_KEY_XF86History
		swigIntConstant( XKB_KEY_XF86History, "XKB_KEY_XF86History" );
	#endif
	#ifdef XKB_KEY_XF86OpenURL
		swigIntConstant( XKB_KEY_XF86OpenURL, "XKB_KEY_XF86OpenURL" );
	#endif
	#ifdef XKB_KEY_XF86AddFavorite
		swigIntConstant( XKB_KEY_XF86AddFavorite, "XKB_KEY_XF86AddFavorite" );
	#endif
	#ifdef XKB_KEY_XF86HotLinks
		swigIntConstant( XKB_KEY_XF86HotLinks, "XKB_KEY_XF86HotLinks" );
	#endif
	#ifdef XKB_KEY_XF86BrightnessAdjust
		swigIntConstant( XKB_KEY_XF86BrightnessAdjust, "XKB_KEY_XF86BrightnessAdjust" );
	#endif
	#ifdef XKB_KEY_XF86Finance
		swigIntConstant( XKB_KEY_XF86Finance, "XKB_KEY_XF86Finance" );
	#endif
	#ifdef XKB_KEY_XF86Community
		swigIntConstant( XKB_KEY_XF86Community, "XKB_KEY_XF86Community" );
	#endif
	#ifdef XKB_KEY_XF86AudioRewind
		swigIntConstant( XKB_KEY_XF86AudioRewind, "XKB_KEY_XF86AudioRewind" );
	#endif
	#ifdef XKB_KEY_XF86BackForward
		swigIntConstant( XKB_KEY_XF86BackForward, "XKB_KEY_XF86BackForward" );
	#endif
	#ifdef XKB_KEY_XF86Launch0
		swigIntConstant( XKB_KEY_XF86Launch0, "XKB_KEY_XF86Launch0" );
	#endif
	#ifdef XKB_KEY_XF86Launch1
		swigIntConstant( XKB_KEY_XF86Launch1, "XKB_KEY_XF86Launch1" );
	#endif
	#ifdef XKB_KEY_XF86Launch2
		swigIntConstant( XKB_KEY_XF86Launch2, "XKB_KEY_XF86Launch2" );
	#endif
	#ifdef XKB_KEY_XF86Launch3
		swigIntConstant( XKB_KEY_XF86Launch3, "XKB_KEY_XF86Launch3" );
	#endif
	#ifdef XKB_KEY_XF86Launch4
		swigIntConstant( XKB_KEY_XF86Launch4, "XKB_KEY_XF86Launch4" );
	#endif
	#ifdef XKB_KEY_XF86Launch5
		swigIntConstant( XKB_KEY_XF86Launch5, "XKB_KEY_XF86Launch5" );
	#endif
	#ifdef XKB_KEY_XF86Launch6
		swigIntConstant( XKB_KEY_XF86Launch6, "XKB_KEY_XF86Launch6" );
	#endif
	#ifdef XKB_KEY_XF86Launch7
		swigIntConstant( XKB_KEY_XF86Launch7, "XKB_KEY_XF86Launch7" );
	#endif
	#ifdef XKB_KEY_XF86Launch8
		swigIntConstant( XKB_KEY_XF86Launch8, "XKB_KEY_XF86Launch8" );
	#endif
	#ifdef XKB_KEY_XF86Launch9
		swigIntConstant( XKB_KEY_XF86Launch9, "XKB_KEY_XF86Launch9" );
	#endif
	#ifdef XKB_KEY_XF86LaunchA
		swigIntConstant( XKB_KEY_XF86LaunchA, "XKB_KEY_XF86LaunchA" );
	#endif
	#ifdef XKB_KEY_XF86LaunchB
		swigIntConstant( XKB_KEY_XF86LaunchB, "XKB_KEY_XF86LaunchB" );
	#endif
	#ifdef XKB_KEY_XF86LaunchC
		swigIntConstant( XKB_KEY_XF86LaunchC, "XKB_KEY_XF86LaunchC" );
	#endif
	#ifdef XKB_KEY_XF86LaunchD
		swigIntConstant( XKB_KEY_XF86LaunchD, "XKB_KEY_XF86LaunchD" );
	#endif
	#ifdef XKB_KEY_XF86LaunchE
		swigIntConstant( XKB_KEY_XF86LaunchE, "XKB_KEY_XF86LaunchE" );
	#endif
	#ifdef XKB_KEY_XF86LaunchF
		swigIntConstant( XKB_KEY_XF86LaunchF, "XKB_KEY_XF86LaunchF" );
	#endif
	#ifdef XKB_KEY_XF86ApplicationLeft
		swigIntConstant( XKB_KEY_XF86ApplicationLeft, "XKB_KEY_XF86ApplicationLeft" );
	#endif
	#ifdef XKB_KEY_XF86ApplicationRight
		swigIntConstant( XKB_KEY_XF86ApplicationRight, "XKB_KEY_XF86ApplicationRight" );
	#endif
	#ifdef XKB_KEY_XF86Book
		swigIntConstant( XKB_KEY_XF86Book, "XKB_KEY_XF86Book" );
	#endif
	#ifdef XKB_KEY_XF86CD
		swigIntConstant( XKB_KEY_XF86CD, "XKB_KEY_XF86CD" );
	#endif
	#ifdef XKB_KEY_XF86MediaSelectCD
		swigIntConstant( XKB_KEY_XF86MediaSelectCD, "XKB_KEY_XF86MediaSelectCD" );
	#endif
	#ifdef XKB_KEY_XF86Calculater
		swigIntConstant( XKB_KEY_XF86Calculater, "XKB_KEY_XF86Calculater" );
	#endif
	#ifdef XKB_KEY_XF86Clear
		swigIntConstant( XKB_KEY_XF86Clear, "XKB_KEY_XF86Clear" );
	#endif
	#ifdef XKB_KEY_XF86Close
		swigIntConstant( XKB_KEY_XF86Close, "XKB_KEY_XF86Close" );
	#endif
	#ifdef XKB_KEY_XF86Copy
		swigIntConstant( XKB_KEY_XF86Copy, "XKB_KEY_XF86Copy" );
	#endif
	#ifdef XKB_KEY_XF86Cut
		swigIntConstant( XKB_KEY_XF86Cut, "XKB_KEY_XF86Cut" );
	#endif
	#ifdef XKB_KEY_XF86Display
		swigIntConstant( XKB_KEY_XF86Display, "XKB_KEY_XF86Display" );
	#endif
	#ifdef XKB_KEY_XF86DOS
		swigIntConstant( XKB_KEY_XF86DOS, "XKB_KEY_XF86DOS" );
	#endif
	#ifdef XKB_KEY_XF86Documents
		swigIntConstant( XKB_KEY_XF86Documents, "XKB_KEY_XF86Documents" );
	#endif
	#ifdef XKB_KEY_XF86Excel
		swigIntConstant( XKB_KEY_XF86Excel, "XKB_KEY_XF86Excel" );
	#endif
	#ifdef XKB_KEY_XF86Explorer
		swigIntConstant( XKB_KEY_XF86Explorer, "XKB_KEY_XF86Explorer" );
	#endif
	#ifdef XKB_KEY_XF86Game
		swigIntConstant( XKB_KEY_XF86Game, "XKB_KEY_XF86Game" );
	#endif
	#ifdef XKB_KEY_XF86Go
		swigIntConstant( XKB_KEY_XF86Go, "XKB_KEY_XF86Go" );
	#endif
	#ifdef XKB_KEY_XF86iTouch
		swigIntConstant( XKB_KEY_XF86iTouch, "XKB_KEY_XF86iTouch" );
	#endif
	#ifdef XKB_KEY_XF86LogOff
		swigIntConstant( XKB_KEY_XF86LogOff, "XKB_KEY_XF86LogOff" );
	#endif
	#ifdef XKB_KEY_XF86Market
		swigIntConstant( XKB_KEY_XF86Market, "XKB_KEY_XF86Market" );
	#endif
	#ifdef XKB_KEY_XF86Meeting
		swigIntConstant( XKB_KEY_XF86Meeting, "XKB_KEY_XF86Meeting" );
	#endif
	#ifdef XKB_KEY_XF86MenuKB
		swigIntConstant( XKB_KEY_XF86MenuKB, "XKB_KEY_XF86MenuKB" );
	#endif
	#ifdef XKB_KEY_XF86MenuPB
		swigIntConstant( XKB_KEY_XF86MenuPB, "XKB_KEY_XF86MenuPB" );
	#endif
	#ifdef XKB_KEY_XF86MySites
		swigIntConstant( XKB_KEY_XF86MySites, "XKB_KEY_XF86MySites" );
	#endif
	#ifdef XKB_KEY_XF86New
		swigIntConstant( XKB_KEY_XF86New, "XKB_KEY_XF86New" );
	#endif
	#ifdef XKB_KEY_XF86News
		swigIntConstant( XKB_KEY_XF86News, "XKB_KEY_XF86News" );
	#endif
	#ifdef XKB_KEY_XF86OfficeHome
		swigIntConstant( XKB_KEY_XF86OfficeHome, "XKB_KEY_XF86OfficeHome" );
	#endif
	#ifdef XKB_KEY_XF86Open
		swigIntConstant( XKB_KEY_XF86Open, "XKB_KEY_XF86Open" );
	#endif
	#ifdef XKB_KEY_XF86Option
		swigIntConstant( XKB_KEY_XF86Option, "XKB_KEY_XF86Option" );
	#endif
	#ifdef XKB_KEY_XF86Paste
		swigIntConstant( XKB_KEY_XF86Paste, "XKB_KEY_XF86Paste" );
	#endif
	#ifdef XKB_KEY_XF86Phone
		swigIntConstant( XKB_KEY_XF86Phone, "XKB_KEY_XF86Phone" );
	#endif
	#ifdef XKB_KEY_XF86Q
		swigIntConstant( XKB_KEY_XF86Q, "XKB_KEY_XF86Q" );
	#endif
	#ifdef XKB_KEY_XF86Reply
		swigIntConstant( XKB_KEY_XF86Reply, "XKB_KEY_XF86Reply" );
	#endif
	#ifdef XKB_KEY_XF86Reload
		swigIntConstant( XKB_KEY_XF86Reload, "XKB_KEY_XF86Reload" );
	#endif
	#ifdef XKB_KEY_XF86RotateWindows
		swigIntConstant( XKB_KEY_XF86RotateWindows, "XKB_KEY_XF86RotateWindows" );
	#endif
	#ifdef XKB_KEY_XF86RotationPB
		swigIntConstant( XKB_KEY_XF86RotationPB, "XKB_KEY_XF86RotationPB" );
	#endif
	#ifdef XKB_KEY_XF86RotationKB
		swigIntConstant( XKB_KEY_XF86RotationKB, "XKB_KEY_XF86RotationKB" );
	#endif
	#ifdef XKB_KEY_XF86Save
		swigIntConstant( XKB_KEY_XF86Save, "XKB_KEY_XF86Save" );
	#endif
	#ifdef XKB_KEY_XF86ScrollUp
		swigIntConstant( XKB_KEY_XF86ScrollUp, "XKB_KEY_XF86ScrollUp" );
	#endif
	#ifdef XKB_KEY_XF86ScrollDown
		swigIntConstant( XKB_KEY_XF86ScrollDown, "XKB_KEY_XF86ScrollDown" );
	#endif
	#ifdef XKB_KEY_XF86ScrollClick
		swigIntConstant( XKB_KEY_XF86ScrollClick, "XKB_KEY_XF86ScrollClick" );
	#endif
	#ifdef XKB_KEY_XF86Send
		swigIntConstant( XKB_KEY_XF86Send, "XKB_KEY_XF86Send" );
	#endif
	#ifdef XKB_KEY_XF86Spell
		swigIntConstant( XKB_KEY_XF86Spell, "XKB_KEY_XF86Spell" );
	#endif
	#ifdef XKB_KEY_XF86SplitScreen
		swigIntConstant( XKB_KEY_XF86SplitScreen, "XKB_KEY_XF86SplitScreen" );
	#endif
	#ifdef XKB_KEY_XF86Support
		swigIntConstant( XKB_KEY_XF86Support, "XKB_KEY_XF86Support" );
	#endif
	#ifdef XKB_KEY_XF86TaskPane
		swigIntConstant( XKB_KEY_XF86TaskPane, "XKB_KEY_XF86TaskPane" );
	#endif
	#ifdef XKB_KEY_XF86Terminal
		swigIntConstant( XKB_KEY_XF86Terminal, "XKB_KEY_XF86Terminal" );
	#endif
	#ifdef XKB_KEY_XF86Tools
		swigIntConstant( XKB_KEY_XF86Tools, "XKB_KEY_XF86Tools" );
	#endif
	#ifdef XKB_KEY_XF86Travel
		swigIntConstant( XKB_KEY_XF86Travel, "XKB_KEY_XF86Travel" );
	#endif
	#ifdef XKB_KEY_XF86UserPB
		swigIntConstant( XKB_KEY_XF86UserPB, "XKB_KEY_XF86UserPB" );
	#endif
	#ifdef XKB_KEY_XF86User1KB
		swigIntConstant( XKB_KEY_XF86User1KB, "XKB_KEY_XF86User1KB" );
	#endif
	#ifdef XKB_KEY_XF86User2KB
		swigIntConstant( XKB_KEY_XF86User2KB, "XKB_KEY_XF86User2KB" );
	#endif
	#ifdef XKB_KEY_XF86Video
		swigIntConstant( XKB_KEY_XF86Video, "XKB_KEY_XF86Video" );
	#endif
	#ifdef XKB_KEY_XF86WheelButton
		swigIntConstant( XKB_KEY_XF86WheelButton, "XKB_KEY_XF86WheelButton" );
	#endif
	#ifdef XKB_KEY_XF86Word
		swigIntConstant( XKB_KEY_XF86Word, "XKB_KEY_XF86Word" );
	#endif
	#ifdef XKB_KEY_XF86Xfer
		swigIntConstant( XKB_KEY_XF86Xfer, "XKB_KEY_XF86Xfer" );
	#endif
	#ifdef XKB_KEY_XF86ZoomIn
		swigIntConstant( XKB_KEY_XF86ZoomIn, "XKB_KEY_XF86ZoomIn" );
	#endif
	#ifdef XKB_KEY_XF86ZoomOut
		swigIntConstant( XKB_KEY_XF86ZoomOut, "XKB_KEY_XF86ZoomOut" );
	#endif
	#ifdef XKB_KEY_XF86Away
		swigIntConstant( XKB_KEY_XF86Away, "XKB_KEY_XF86Away" );
	#endif
	#ifdef XKB_KEY_XF86Messenger
		swigIntConstant( XKB_KEY_XF86Messenger, "XKB_KEY_XF86Messenger" );
	#endif
	#ifdef XKB_KEY_XF86WebCam
		swigIntConstant( XKB_KEY_XF86WebCam, "XKB_KEY_XF86WebCam" );
	#endif
	#ifdef XKB_KEY_XF86MailForward
		swigIntConstant( XKB_KEY_XF86MailForward, "XKB_KEY_XF86MailForward" );
	#endif
	#ifdef XKB_KEY_XF86Pictures
		swigIntConstant( XKB_KEY_XF86Pictures, "XKB_KEY_XF86Pictures" );
	#endif
	#ifdef XKB_KEY_XF86Music
		swigIntConstant( XKB_KEY_XF86Music, "XKB_KEY_XF86Music" );
	#endif
	#ifdef XKB_KEY_XF86Battery
		swigIntConstant( XKB_KEY_XF86Battery, "XKB_KEY_XF86Battery" );
	#endif
	#ifdef XKB_KEY_XF86Bluetooth
		swigIntConstant( XKB_KEY_XF86Bluetooth, "XKB_KEY_XF86Bluetooth" );
	#endif
	#ifdef XKB_KEY_XF86WLAN
		swigIntConstant( XKB_KEY_XF86WLAN, "XKB_KEY_XF86WLAN" );
	#endif
	#ifdef XKB_KEY_XF86UWB
		swigIntConstant( XKB_KEY_XF86UWB, "XKB_KEY_XF86UWB" );
	#endif
	#ifdef XKB_KEY_XF86AudioForward
		swigIntConstant( XKB_KEY_XF86AudioForward, "XKB_KEY_XF86AudioForward" );
	#endif
	#ifdef XKB_KEY_XF86AudioRepeat
		swigIntConstant( XKB_KEY_XF86AudioRepeat, "XKB_KEY_XF86AudioRepeat" );
	#endif
	#ifdef XKB_KEY_XF86AudioRandomPlay
		swigIntConstant( XKB_KEY_XF86AudioRandomPlay, "XKB_KEY_XF86AudioRandomPlay" );
	#endif
	#ifdef XKB_KEY_XF86Subtitle
		swigIntConstant( XKB_KEY_XF86Subtitle, "XKB_KEY_XF86Subtitle" );
	#endif
	#ifdef XKB_KEY_XF86AudioCycleTrack
		swigIntConstant( XKB_KEY_XF86AudioCycleTrack, "XKB_KEY_XF86AudioCycleTrack" );
	#endif
	#ifdef XKB_KEY_XF86CycleAngle
		swigIntConstant( XKB_KEY_XF86CycleAngle, "XKB_KEY_XF86CycleAngle" );
	#endif
	#ifdef XKB_KEY_XF86FrameBack
		swigIntConstant( XKB_KEY_XF86FrameBack, "XKB_KEY_XF86FrameBack" );
	#endif
	#ifdef XKB_KEY_XF86FrameForward
		swigIntConstant( XKB_KEY_XF86FrameForward, "XKB_KEY_XF86FrameForward" );
	#endif
	#ifdef XKB_KEY_XF86Time
		swigIntConstant( XKB_KEY_XF86Time, "XKB_KEY_XF86Time" );
	#endif
	#ifdef XKB_KEY_XF86Select
		swigIntConstant( XKB_KEY_XF86Select, "XKB_KEY_XF86Select" );
	#endif
	#ifdef XKB_KEY_XF86View
		swigIntConstant( XKB_KEY_XF86View, "XKB_KEY_XF86View" );
	#endif
	#ifdef XKB_KEY_XF86TopMenu
		swigIntConstant( XKB_KEY_XF86TopMenu, "XKB_KEY_XF86TopMenu" );
	#endif
	#ifdef XKB_KEY_XF86Red
		swigIntConstant( XKB_KEY_XF86Red, "XKB_KEY_XF86Red" );
	#endif
	#ifdef XKB_KEY_XF86Green
		swigIntConstant( XKB_KEY_XF86Green, "XKB_KEY_XF86Green" );
	#endif
	#ifdef XKB_KEY_XF86Yellow
		swigIntConstant( XKB_KEY_XF86Yellow, "XKB_KEY_XF86Yellow" );
	#endif
	#ifdef XKB_KEY_XF86Blue
		swigIntConstant( XKB_KEY_XF86Blue, "XKB_KEY_XF86Blue" );
	#endif
	#ifdef XKB_KEY_XF86Suspend
		swigIntConstant( XKB_KEY_XF86Suspend, "XKB_KEY_XF86Suspend" );
	#endif
	#ifdef XKB_KEY_XF86Hibernate
		swigIntConstant( XKB_KEY_XF86Hibernate, "XKB_KEY_XF86Hibernate" );
	#endif
	#ifdef XKB_KEY_XF86TouchpadToggle
		swigIntConstant( XKB_KEY_XF86TouchpadToggle, "XKB_KEY_XF86TouchpadToggle" );
	#endif
	#ifdef XKB_KEY_XF86TouchpadOn
		swigIntConstant( XKB_KEY_XF86TouchpadOn, "XKB_KEY_XF86TouchpadOn" );
	#endif
	#ifdef XKB_KEY_XF86TouchpadOff
		swigIntConstant( XKB_KEY_XF86TouchpadOff, "XKB_KEY_XF86TouchpadOff" );
	#endif
	#ifdef XKB_KEY_XF86AudioMicMute
		swigIntConstant( XKB_KEY_XF86AudioMicMute, "XKB_KEY_XF86AudioMicMute" );
	#endif
	#ifdef XKB_KEY_XF86Keyboard
		swigIntConstant( XKB_KEY_XF86Keyboard, "XKB_KEY_XF86Keyboard" );
	#endif
	#ifdef XKB_KEY_XF86WWAN
		swigIntConstant( XKB_KEY_XF86WWAN, "XKB_KEY_XF86WWAN" );
	#endif
	#ifdef XKB_KEY_XF86RFKill
		swigIntConstant( XKB_KEY_XF86RFKill, "XKB_KEY_XF86RFKill" );
	#endif
	#ifdef XKB_KEY_XF86AudioPreset
		swigIntConstant( XKB_KEY_XF86AudioPreset, "XKB_KEY_XF86AudioPreset" );
	#endif
	#ifdef XKB_KEY_XF86RotationLockToggle
		swigIntConstant( XKB_KEY_XF86RotationLockToggle, "XKB_KEY_XF86RotationLockToggle" );
	#endif
	#ifdef XKB_KEY_XF86FullScreen
		swigIntConstant( XKB_KEY_XF86FullScreen, "XKB_KEY_XF86FullScreen" );
	#endif
	#ifdef XKB_KEY_XF86Switch_VT_1
		swigIntConstant( XKB_KEY_XF86Switch_VT_1, "XKB_KEY_XF86Switch_VT_1" );
	#endif
	#ifdef XKB_KEY_XF86Switch_VT_2
		swigIntConstant( XKB_KEY_XF86Switch_VT_2, "XKB_KEY_XF86Switch_VT_2" );
	#endif
	#ifdef XKB_KEY_XF86Switch_VT_3
		swigIntConstant( XKB_KEY_XF86Switch_VT_3, "XKB_KEY_XF86Switch_VT_3" );
	#endif
	#ifdef XKB_KEY_XF86Switch_VT_4
		swigIntConstant( XKB_KEY_XF86Switch_VT_4, "XKB_KEY_XF86Switch_VT_4" );
	#endif
	#ifdef XKB_KEY_XF86Switch_VT_5
		swigIntConstant( XKB_KEY_XF86Switch_VT_5, "XKB_KEY_XF86Switch_VT_5" );
	#endif
	#ifdef XKB_KEY_XF86Switch_VT_6
		swigIntConstant( XKB_KEY_XF86Switch_VT_6, "XKB_KEY_XF86Switch_VT_6" );
	#endif
	#ifdef XKB_KEY_XF86Switch_VT_7
		swigIntConstant( XKB_KEY_XF86Switch_VT_7, "XKB_KEY_XF86Switch_VT_7" );
	#endif
	#ifdef XKB_KEY_XF86Switch_VT_8
		swigIntConstant( XKB_KEY_XF86Switch_VT_8, "XKB_KEY_XF86Switch_VT_8" );
	#endif
	#ifdef XKB_KEY_XF86Switch_VT_9
		swigIntConstant( XKB_KEY_XF86Switch_VT_9, "XKB_KEY_XF86Switch_VT_9" );
	#endif
	#ifdef XKB_KEY_XF86Switch_VT_10
		swigIntConstant( XKB_KEY_XF86Switch_VT_10, "XKB_KEY_XF86Switch_VT_10" );
	#endif
	#ifdef XKB_KEY_XF86Switch_VT_11
		swigIntConstant( XKB_KEY_XF86Switch_VT_11, "XKB_KEY_XF86Switch_VT_11" );
	#endif
	#ifdef XKB_KEY_XF86Switch_VT_12
		swigIntConstant( XKB_KEY_XF86Switch_VT_12, "XKB_KEY_XF86Switch_VT_12" );
	#endif
	#ifdef XKB_KEY_XF86Ungrab
		swigIntConstant( XKB_KEY_XF86Ungrab, "XKB_KEY_XF86Ungrab" );
	#endif
	#ifdef XKB_KEY_XF86ClearGrab
		swigIntConstant( XKB_KEY_XF86ClearGrab, "XKB_KEY_XF86ClearGrab" );
	#endif
	#ifdef XKB_KEY_XF86Next_VMode
		swigIntConstant( XKB_KEY_XF86Next_VMode, "XKB_KEY_XF86Next_VMode" );
	#endif
	#ifdef XKB_KEY_XF86Prev_VMode
		swigIntConstant( XKB_KEY_XF86Prev_VMode, "XKB_KEY_XF86Prev_VMode" );
	#endif
	#ifdef XKB_KEY_XF86LogWindowTree
		swigIntConstant( XKB_KEY_XF86LogWindowTree, "XKB_KEY_XF86LogWindowTree" );
	#endif
	#ifdef XKB_KEY_XF86LogGrabInfo
		swigIntConstant( XKB_KEY_XF86LogGrabInfo, "XKB_KEY_XF86LogGrabInfo" );
	#endif
	#ifdef XKB_KEY_XF86BrightnessAuto
		swigIntConstant( XKB_KEY_XF86BrightnessAuto, "XKB_KEY_XF86BrightnessAuto" );
	#endif
	#ifdef XKB_KEY_XF86DisplayOff
		swigIntConstant( XKB_KEY_XF86DisplayOff, "XKB_KEY_XF86DisplayOff" );
	#endif
	#ifdef XKB_KEY_XF86OK
		swigIntConstant( XKB_KEY_XF86OK, "XKB_KEY_XF86OK" );
	#endif
	#ifdef XKB_KEY_XF86GoTo
		swigIntConstant( XKB_KEY_XF86GoTo, "XKB_KEY_XF86GoTo" );
	#endif
	#ifdef XKB_KEY_XF86Info
		swigIntConstant( XKB_KEY_XF86Info, "XKB_KEY_XF86Info" );
	#endif
	#ifdef XKB_KEY_XF86VendorLogo
		swigIntConstant( XKB_KEY_XF86VendorLogo, "XKB_KEY_XF86VendorLogo" );
	#endif
	#ifdef XKB_KEY_XF86MediaSelectProgramGuide
		swigIntConstant( XKB_KEY_XF86MediaSelectProgramGuide, "XKB_KEY_XF86MediaSelectProgramGuide" );
	#endif
	#ifdef XKB_KEY_XF86MediaSelectHome
		swigIntConstant( XKB_KEY_XF86MediaSelectHome, "XKB_KEY_XF86MediaSelectHome" );
	#endif
	#ifdef XKB_KEY_XF86MediaLanguageMenu
		swigIntConstant( XKB_KEY_XF86MediaLanguageMenu, "XKB_KEY_XF86MediaLanguageMenu" );
	#endif
	#ifdef XKB_KEY_XF86MediaTitleMenu
		swigIntConstant( XKB_KEY_XF86MediaTitleMenu, "XKB_KEY_XF86MediaTitleMenu" );
	#endif
	#ifdef XKB_KEY_XF86AudioChannelMode
		swigIntConstant( XKB_KEY_XF86AudioChannelMode, "XKB_KEY_XF86AudioChannelMode" );
	#endif
	#ifdef XKB_KEY_XF86AspectRatio
		swigIntConstant( XKB_KEY_XF86AspectRatio, "XKB_KEY_XF86AspectRatio" );
	#endif
	#ifdef XKB_KEY_XF86MediaSelectPC
		swigIntConstant( XKB_KEY_XF86MediaSelectPC, "XKB_KEY_XF86MediaSelectPC" );
	#endif
	#ifdef XKB_KEY_XF86MediaSelectTV
		swigIntConstant( XKB_KEY_XF86MediaSelectTV, "XKB_KEY_XF86MediaSelectTV" );
	#endif
	#ifdef XKB_KEY_XF86MediaSelectCable
		swigIntConstant( XKB_KEY_XF86MediaSelectCable, "XKB_KEY_XF86MediaSelectCable" );
	#endif
	#ifdef XKB_KEY_XF86MediaSelectVCR
		swigIntConstant( XKB_KEY_XF86MediaSelectVCR, "XKB_KEY_XF86MediaSelectVCR" );
	#endif
	#ifdef XKB_KEY_XF86MediaSelectVCRPlus
		swigIntConstant( XKB_KEY_XF86MediaSelectVCRPlus, "XKB_KEY_XF86MediaSelectVCRPlus" );
	#endif
	#ifdef XKB_KEY_XF86MediaSelectSatellite
		swigIntConstant( XKB_KEY_XF86MediaSelectSatellite, "XKB_KEY_XF86MediaSelectSatellite" );
	#endif
	#ifdef XKB_KEY_XF86MediaSelectTape
		swigIntConstant( XKB_KEY_XF86MediaSelectTape, "XKB_KEY_XF86MediaSelectTape" );
	#endif
	#ifdef XKB_KEY_XF86MediaSelectRadio
		swigIntConstant( XKB_KEY_XF86MediaSelectRadio, "XKB_KEY_XF86MediaSelectRadio" );
	#endif
	#ifdef XKB_KEY_XF86MediaSelectTuner
		swigIntConstant( XKB_KEY_XF86MediaSelectTuner, "XKB_KEY_XF86MediaSelectTuner" );
	#endif
	#ifdef XKB_KEY_XF86MediaPlayer
		swigIntConstant( XKB_KEY_XF86MediaPlayer, "XKB_KEY_XF86MediaPlayer" );
	#endif
	#ifdef XKB_KEY_XF86MediaSelectTeletext
		swigIntConstant( XKB_KEY_XF86MediaSelectTeletext, "XKB_KEY_XF86MediaSelectTeletext" );
	#endif
	#ifdef XKB_KEY_XF86DVD
		swigIntConstant( XKB_KEY_XF86DVD, "XKB_KEY_XF86DVD" );
	#endif
	#ifdef XKB_KEY_XF86MediaSelectDVD
		swigIntConstant( XKB_KEY_XF86MediaSelectDVD, "XKB_KEY_XF86MediaSelectDVD" );
	#endif
	#ifdef XKB_KEY_XF86MediaSelectAuxiliary
		swigIntConstant( XKB_KEY_XF86MediaSelectAuxiliary, "XKB_KEY_XF86MediaSelectAuxiliary" );
	#endif
	#ifdef XKB_KEY_XF86Audio
		swigIntConstant( XKB_KEY_XF86Audio, "XKB_KEY_XF86Audio" );
	#endif
	#ifdef XKB_KEY_XF86ChannelUp
		swigIntConstant( XKB_KEY_XF86ChannelUp, "XKB_KEY_XF86ChannelUp" );
	#endif
	#ifdef XKB_KEY_XF86ChannelDown
		swigIntConstant( XKB_KEY_XF86ChannelDown, "XKB_KEY_XF86ChannelDown" );
	#endif
	#ifdef XKB_KEY_XF86MediaPlaySlow
		swigIntConstant( XKB_KEY_XF86MediaPlaySlow, "XKB_KEY_XF86MediaPlaySlow" );
	#endif
	#ifdef XKB_KEY_XF86Break
		swigIntConstant( XKB_KEY_XF86Break, "XKB_KEY_XF86Break" );
	#endif
	#ifdef XKB_KEY_XF86NumberEntryMode
		swigIntConstant( XKB_KEY_XF86NumberEntryMode, "XKB_KEY_XF86NumberEntryMode" );
	#endif
	#ifdef XKB_KEY_XF86VideoPhone
		swigIntConstant( XKB_KEY_XF86VideoPhone, "XKB_KEY_XF86VideoPhone" );
	#endif
	#ifdef XKB_KEY_XF86ZoomReset
		swigIntConstant( XKB_KEY_XF86ZoomReset, "XKB_KEY_XF86ZoomReset" );
	#endif
	#ifdef XKB_KEY_XF86Editor
		swigIntConstant( XKB_KEY_XF86Editor, "XKB_KEY_XF86Editor" );
	#endif
	#ifdef XKB_KEY_XF86GraphicsEditor
		swigIntConstant( XKB_KEY_XF86GraphicsEditor, "XKB_KEY_XF86GraphicsEditor" );
	#endif
	#ifdef XKB_KEY_XF86Presentation
		swigIntConstant( XKB_KEY_XF86Presentation, "XKB_KEY_XF86Presentation" );
	#endif
	#ifdef XKB_KEY_XF86Database
		swigIntConstant( XKB_KEY_XF86Database, "XKB_KEY_XF86Database" );
	#endif
	#ifdef XKB_KEY_XF86Voicemail
		swigIntConstant( XKB_KEY_XF86Voicemail, "XKB_KEY_XF86Voicemail" );
	#endif
	#ifdef XKB_KEY_XF86Addressbook
		swigIntConstant( XKB_KEY_XF86Addressbook, "XKB_KEY_XF86Addressbook" );
	#endif
	#ifdef XKB_KEY_XF86DisplayToggle
		swigIntConstant( XKB_KEY_XF86DisplayToggle, "XKB_KEY_XF86DisplayToggle" );
	#endif
	#ifdef XKB_KEY_XF86SpellCheck
		swigIntConstant( XKB_KEY_XF86SpellCheck, "XKB_KEY_XF86SpellCheck" );
	#endif
	#ifdef XKB_KEY_XF86ContextMenu
		swigIntConstant( XKB_KEY_XF86ContextMenu, "XKB_KEY_XF86ContextMenu" );
	#endif
	#ifdef XKB_KEY_XF86MediaRepeat
		swigIntConstant( XKB_KEY_XF86MediaRepeat, "XKB_KEY_XF86MediaRepeat" );
	#endif
	#ifdef XKB_KEY_XF8610ChannelsUp
		swigIntConstant( XKB_KEY_XF8610ChannelsUp, "XKB_KEY_XF8610ChannelsUp" );
	#endif
	#ifdef XKB_KEY_XF8610ChannelsDown
		swigIntConstant( XKB_KEY_XF8610ChannelsDown, "XKB_KEY_XF8610ChannelsDown" );
	#endif
	#ifdef XKB_KEY_XF86Images
		swigIntConstant( XKB_KEY_XF86Images, "XKB_KEY_XF86Images" );
	#endif
	#ifdef XKB_KEY_XF86NotificationCenter
		swigIntConstant( XKB_KEY_XF86NotificationCenter, "XKB_KEY_XF86NotificationCenter" );
	#endif
	#ifdef XKB_KEY_XF86PickupPhone
		swigIntConstant( XKB_KEY_XF86PickupPhone, "XKB_KEY_XF86PickupPhone" );
	#endif
	#ifdef XKB_KEY_XF86HangupPhone
		swigIntConstant( XKB_KEY_XF86HangupPhone, "XKB_KEY_XF86HangupPhone" );
	#endif
	#ifdef XKB_KEY_XF86Fn
		swigIntConstant( XKB_KEY_XF86Fn, "XKB_KEY_XF86Fn" );
	#endif
	#ifdef XKB_KEY_XF86Fn_Esc
		swigIntConstant( XKB_KEY_XF86Fn_Esc, "XKB_KEY_XF86Fn_Esc" );
	#endif
	#ifdef XKB_KEY_XF86FnRightShift
		swigIntConstant( XKB_KEY_XF86FnRightShift, "XKB_KEY_XF86FnRightShift" );
	#endif
	#ifdef XKB_KEY_XF86Numeric0
		swigIntConstant( XKB_KEY_XF86Numeric0, "XKB_KEY_XF86Numeric0" );
	#endif
	#ifdef XKB_KEY_XF86Numeric1
		swigIntConstant( XKB_KEY_XF86Numeric1, "XKB_KEY_XF86Numeric1" );
	#endif
	#ifdef XKB_KEY_XF86Numeric2
		swigIntConstant( XKB_KEY_XF86Numeric2, "XKB_KEY_XF86Numeric2" );
	#endif
	#ifdef XKB_KEY_XF86Numeric3
		swigIntConstant( XKB_KEY_XF86Numeric3, "XKB_KEY_XF86Numeric3" );
	#endif
	#ifdef XKB_KEY_XF86Numeric4
		swigIntConstant( XKB_KEY_XF86Numeric4, "XKB_KEY_XF86Numeric4" );
	#endif
	#ifdef XKB_KEY_XF86Numeric5
		swigIntConstant( XKB_KEY_XF86Numeric5, "XKB_KEY_XF86Numeric5" );
	#endif
	#ifdef XKB_KEY_XF86Numeric6
		swigIntConstant( XKB_KEY_XF86Numeric6, "XKB_KEY_XF86Numeric6" );
	#endif
	#ifdef XKB_KEY_XF86Numeric7
		swigIntConstant( XKB_KEY_XF86Numeric7, "XKB_KEY_XF86Numeric7" );
	#endif
	#ifdef XKB_KEY_XF86Numeric8
		swigIntConstant( XKB_KEY_XF86Numeric8, "XKB_KEY_XF86Numeric8" );
	#endif
	#ifdef XKB_KEY_XF86Numeric9
		swigIntConstant( XKB_KEY_XF86Numeric9, "XKB_KEY_XF86Numeric9" );
	#endif
	#ifdef XKB_KEY_XF86NumericStar
		swigIntConstant( XKB_KEY_XF86NumericStar, "XKB_KEY_XF86NumericStar" );
	#endif
	#ifdef XKB_KEY_XF86NumericPound
		swigIntConstant( XKB_KEY_XF86NumericPound, "XKB_KEY_XF86NumericPound" );
	#endif
	#ifdef XKB_KEY_XF86NumericA
		swigIntConstant( XKB_KEY_XF86NumericA, "XKB_KEY_XF86NumericA" );
	#endif
	#ifdef XKB_KEY_XF86NumericB
		swigIntConstant( XKB_KEY_XF86NumericB, "XKB_KEY_XF86NumericB" );
	#endif
	#ifdef XKB_KEY_XF86NumericC
		swigIntConstant( XKB_KEY_XF86NumericC, "XKB_KEY_XF86NumericC" );
	#endif
	#ifdef XKB_KEY_XF86NumericD
		swigIntConstant( XKB_KEY_XF86NumericD, "XKB_KEY_XF86NumericD" );
	#endif
	#ifdef XKB_KEY_XF86CameraFocus
		swigIntConstant( XKB_KEY_XF86CameraFocus, "XKB_KEY_XF86CameraFocus" );
	#endif
	#ifdef XKB_KEY_XF86WPSButton
		swigIntConstant( XKB_KEY_XF86WPSButton, "XKB_KEY_XF86WPSButton" );
	#endif
	#ifdef XKB_KEY_XF86CameraZoomIn
		swigIntConstant( XKB_KEY_XF86CameraZoomIn, "XKB_KEY_XF86CameraZoomIn" );
	#endif
	#ifdef XKB_KEY_XF86CameraZoomOut
		swigIntConstant( XKB_KEY_XF86CameraZoomOut, "XKB_KEY_XF86CameraZoomOut" );
	#endif
	#ifdef XKB_KEY_XF86CameraUp
		swigIntConstant( XKB_KEY_XF86CameraUp, "XKB_KEY_XF86CameraUp" );
	#endif
	#ifdef XKB_KEY_XF86CameraDown
		swigIntConstant( XKB_KEY_XF86CameraDown, "XKB_KEY_XF86CameraDown" );
	#endif
	#ifdef XKB_KEY_XF86CameraLeft
		swigIntConstant( XKB_KEY_XF86CameraLeft, "XKB_KEY_XF86CameraLeft" );
	#endif
	#ifdef XKB_KEY_XF86CameraRight
		swigIntConstant( XKB_KEY_XF86CameraRight, "XKB_KEY_XF86CameraRight" );
	#endif
	#ifdef XKB_KEY_XF86AttendantOn
		swigIntConstant( XKB_KEY_XF86AttendantOn, "XKB_KEY_XF86AttendantOn" );
	#endif
	#ifdef XKB_KEY_XF86AttendantOff
		swigIntConstant( XKB_KEY_XF86AttendantOff, "XKB_KEY_XF86AttendantOff" );
	#endif
	#ifdef XKB_KEY_XF86AttendantToggle
		swigIntConstant( XKB_KEY_XF86AttendantToggle, "XKB_KEY_XF86AttendantToggle" );
	#endif
	#ifdef XKB_KEY_XF86LightsToggle
		swigIntConstant( XKB_KEY_XF86LightsToggle, "XKB_KEY_XF86LightsToggle" );
	#endif
	#ifdef XKB_KEY_XF86ALSToggle
		swigIntConstant( XKB_KEY_XF86ALSToggle, "XKB_KEY_XF86ALSToggle" );
	#endif
	#ifdef XKB_KEY_XF86RefreshRateToggle
		swigIntConstant( XKB_KEY_XF86RefreshRateToggle, "XKB_KEY_XF86RefreshRateToggle" );
	#endif
	#ifdef XKB_KEY_XF86Buttonconfig
		swigIntConstant( XKB_KEY_XF86Buttonconfig, "XKB_KEY_XF86Buttonconfig" );
	#endif
	#ifdef XKB_KEY_XF86Taskmanager
		swigIntConstant( XKB_KEY_XF86Taskmanager, "XKB_KEY_XF86Taskmanager" );
	#endif
	#ifdef XKB_KEY_XF86Journal
		swigIntConstant( XKB_KEY_XF86Journal, "XKB_KEY_XF86Journal" );
	#endif
	#ifdef XKB_KEY_XF86ControlPanel
		swigIntConstant( XKB_KEY_XF86ControlPanel, "XKB_KEY_XF86ControlPanel" );
	#endif
	#ifdef XKB_KEY_XF86AppSelect
		swigIntConstant( XKB_KEY_XF86AppSelect, "XKB_KEY_XF86AppSelect" );
	#endif
	#ifdef XKB_KEY_XF86Screensaver
		swigIntConstant( XKB_KEY_XF86Screensaver, "XKB_KEY_XF86Screensaver" );
	#endif
	#ifdef XKB_KEY_XF86VoiceCommand
		swigIntConstant( XKB_KEY_XF86VoiceCommand, "XKB_KEY_XF86VoiceCommand" );
	#endif
	#ifdef XKB_KEY_XF86Assistant
		swigIntConstant( XKB_KEY_XF86Assistant, "XKB_KEY_XF86Assistant" );
	#endif
	#ifdef XKB_KEY_XF86EmojiPicker
		swigIntConstant( XKB_KEY_XF86EmojiPicker, "XKB_KEY_XF86EmojiPicker" );
	#endif
	#ifdef XKB_KEY_XF86Dictate
		swigIntConstant( XKB_KEY_XF86Dictate, "XKB_KEY_XF86Dictate" );
	#endif
	#ifdef XKB_KEY_XF86CameraAccessEnable
		swigIntConstant( XKB_KEY_XF86CameraAccessEnable, "XKB_KEY_XF86CameraAccessEnable" );
	#endif
	#ifdef XKB_KEY_XF86CameraAccessDisable
		swigIntConstant( XKB_KEY_XF86CameraAccessDisable, "XKB_KEY_XF86CameraAccessDisable" );
	#endif
	#ifdef XKB_KEY_XF86CameraAccessToggle
		swigIntConstant( XKB_KEY_XF86CameraAccessToggle, "XKB_KEY_XF86CameraAccessToggle" );
	#endif
	#ifdef XKB_KEY_XF86Accessibility
		swigIntConstant( XKB_KEY_XF86Accessibility, "XKB_KEY_XF86Accessibility" );
	#endif
	#ifdef XKB_KEY_XF86DoNotDisturb
		swigIntConstant( XKB_KEY_XF86DoNotDisturb, "XKB_KEY_XF86DoNotDisturb" );
	#endif
	#ifdef XKB_KEY_XF86BrightnessMin
		swigIntConstant( XKB_KEY_XF86BrightnessMin, "XKB_KEY_XF86BrightnessMin" );
	#endif
	#ifdef XKB_KEY_XF86BrightnessMax
		swigIntConstant( XKB_KEY_XF86BrightnessMax, "XKB_KEY_XF86BrightnessMax" );
	#endif
	#ifdef XKB_KEY_XF86KbdInputAssistPrev
		swigIntConstant( XKB_KEY_XF86KbdInputAssistPrev, "XKB_KEY_XF86KbdInputAssistPrev" );
	#endif
	#ifdef XKB_KEY_XF86KbdInputAssistNext
		swigIntConstant( XKB_KEY_XF86KbdInputAssistNext, "XKB_KEY_XF86KbdInputAssistNext" );
	#endif
	#ifdef XKB_KEY_XF86KbdInputAssistPrevgroup
		swigIntConstant( XKB_KEY_XF86KbdInputAssistPrevgroup, "XKB_KEY_XF86KbdInputAssistPrevgroup" );
	#endif
	#ifdef XKB_KEY_XF86KbdInputAssistNextgroup
		swigIntConstant( XKB_KEY_XF86KbdInputAssistNextgroup, "XKB_KEY_XF86KbdInputAssistNextgroup" );
	#endif
	#ifdef XKB_KEY_XF86KbdInputAssistAccept
		swigIntConstant( XKB_KEY_XF86KbdInputAssistAccept, "XKB_KEY_XF86KbdInputAssistAccept" );
	#endif
	#ifdef XKB_KEY_XF86KbdInputAssistCancel
		swigIntConstant( XKB_KEY_XF86KbdInputAssistCancel, "XKB_KEY_XF86KbdInputAssistCancel" );
	#endif
	#ifdef XKB_KEY_XF86RightUp
		swigIntConstant( XKB_KEY_XF86RightUp, "XKB_KEY_XF86RightUp" );
	#endif
	#ifdef XKB_KEY_XF86RightDown
		swigIntConstant( XKB_KEY_XF86RightDown, "XKB_KEY_XF86RightDown" );
	#endif
	#ifdef XKB_KEY_XF86LeftUp
		swigIntConstant( XKB_KEY_XF86LeftUp, "XKB_KEY_XF86LeftUp" );
	#endif
	#ifdef XKB_KEY_XF86LeftDown
		swigIntConstant( XKB_KEY_XF86LeftDown, "XKB_KEY_XF86LeftDown" );
	#endif
	#ifdef XKB_KEY_XF86RootMenu
		swigIntConstant( XKB_KEY_XF86RootMenu, "XKB_KEY_XF86RootMenu" );
	#endif
	#ifdef XKB_KEY_XF86MediaTopMenu
		swigIntConstant( XKB_KEY_XF86MediaTopMenu, "XKB_KEY_XF86MediaTopMenu" );
	#endif
	#ifdef XKB_KEY_XF86Numeric11
		swigIntConstant( XKB_KEY_XF86Numeric11, "XKB_KEY_XF86Numeric11" );
	#endif
	#ifdef XKB_KEY_XF86Numeric12
		swigIntConstant( XKB_KEY_XF86Numeric12, "XKB_KEY_XF86Numeric12" );
	#endif
	#ifdef XKB_KEY_XF86AudioDesc
		swigIntConstant( XKB_KEY_XF86AudioDesc, "XKB_KEY_XF86AudioDesc" );
	#endif
	#ifdef XKB_KEY_XF863DMode
		swigIntConstant( XKB_KEY_XF863DMode, "XKB_KEY_XF863DMode" );
	#endif
	#ifdef XKB_KEY_XF86NextFavorite
		swigIntConstant( XKB_KEY_XF86NextFavorite, "XKB_KEY_XF86NextFavorite" );
	#endif
	#ifdef XKB_KEY_XF86StopRecord
		swigIntConstant( XKB_KEY_XF86StopRecord, "XKB_KEY_XF86StopRecord" );
	#endif
	#ifdef XKB_KEY_XF86PauseRecord
		swigIntConstant( XKB_KEY_XF86PauseRecord, "XKB_KEY_XF86PauseRecord" );
	#endif
	#ifdef XKB_KEY_XF86VOD
		swigIntConstant( XKB_KEY_XF86VOD, "XKB_KEY_XF86VOD" );
	#endif
	#ifdef XKB_KEY_XF86Unmute
		swigIntConstant( XKB_KEY_XF86Unmute, "XKB_KEY_XF86Unmute" );
	#endif
	#ifdef XKB_KEY_XF86FastReverse
		swigIntConstant( XKB_KEY_XF86FastReverse, "XKB_KEY_XF86FastReverse" );
	#endif
	#ifdef XKB_KEY_XF86SlowReverse
		swigIntConstant( XKB_KEY_XF86SlowReverse, "XKB_KEY_XF86SlowReverse" );
	#endif
	#ifdef XKB_KEY_XF86Data
		swigIntConstant( XKB_KEY_XF86Data, "XKB_KEY_XF86Data" );
	#endif
	#ifdef XKB_KEY_XF86OnScreenKeyboard
		swigIntConstant( XKB_KEY_XF86OnScreenKeyboard, "XKB_KEY_XF86OnScreenKeyboard" );
	#endif
	#ifdef XKB_KEY_XF86PrivacyScreenToggle
		swigIntConstant( XKB_KEY_XF86PrivacyScreenToggle, "XKB_KEY_XF86PrivacyScreenToggle" );
	#endif
	#ifdef XKB_KEY_XF86SelectiveScreenshot
		swigIntConstant( XKB_KEY_XF86SelectiveScreenshot, "XKB_KEY_XF86SelectiveScreenshot" );
	#endif
	#ifdef XKB_KEY_XF86NextElement
		swigIntConstant( XKB_KEY_XF86NextElement, "XKB_KEY_XF86NextElement" );
	#endif
	#ifdef XKB_KEY_XF86PreviousElement
		swigIntConstant( XKB_KEY_XF86PreviousElement, "XKB_KEY_XF86PreviousElement" );
	#endif
	#ifdef XKB_KEY_XF86AutopilotEngageToggle
		swigIntConstant( XKB_KEY_XF86AutopilotEngageToggle, "XKB_KEY_XF86AutopilotEngageToggle" );
	#endif
	#ifdef XKB_KEY_XF86MarkWaypoint
		swigIntConstant( XKB_KEY_XF86MarkWaypoint, "XKB_KEY_XF86MarkWaypoint" );
	#endif
	#ifdef XKB_KEY_XF86Sos
		swigIntConstant( XKB_KEY_XF86Sos, "XKB_KEY_XF86Sos" );
	#endif
	#ifdef XKB_KEY_XF86NavChart
		swigIntConstant( XKB_KEY_XF86NavChart, "XKB_KEY_XF86NavChart" );
	#endif
	#ifdef XKB_KEY_XF86FishingChart
		swigIntConstant( XKB_KEY_XF86FishingChart, "XKB_KEY_XF86FishingChart" );
	#endif
	#ifdef XKB_KEY_XF86SingleRangeRadar
		swigIntConstant( XKB_KEY_XF86SingleRangeRadar, "XKB_KEY_XF86SingleRangeRadar" );
	#endif
	#ifdef XKB_KEY_XF86DualRangeRadar
		swigIntConstant( XKB_KEY_XF86DualRangeRadar, "XKB_KEY_XF86DualRangeRadar" );
	#endif
	#ifdef XKB_KEY_XF86RadarOverlay
		swigIntConstant( XKB_KEY_XF86RadarOverlay, "XKB_KEY_XF86RadarOverlay" );
	#endif
	#ifdef XKB_KEY_XF86TraditionalSonar
		swigIntConstant( XKB_KEY_XF86TraditionalSonar, "XKB_KEY_XF86TraditionalSonar" );
	#endif
	#ifdef XKB_KEY_XF86ClearvuSonar
		swigIntConstant( XKB_KEY_XF86ClearvuSonar, "XKB_KEY_XF86ClearvuSonar" );
	#endif
	#ifdef XKB_KEY_XF86SidevuSonar
		swigIntConstant( XKB_KEY_XF86SidevuSonar, "XKB_KEY_XF86SidevuSonar" );
	#endif
	#ifdef XKB_KEY_XF86NavInfo
		swigIntConstant( XKB_KEY_XF86NavInfo, "XKB_KEY_XF86NavInfo" );
	#endif
	#ifdef XKB_KEY_XF86Macro1
		swigIntConstant( XKB_KEY_XF86Macro1, "XKB_KEY_XF86Macro1" );
	#endif
	#ifdef XKB_KEY_XF86Macro2
		swigIntConstant( XKB_KEY_XF86Macro2, "XKB_KEY_XF86Macro2" );
	#endif
	#ifdef XKB_KEY_XF86Macro3
		swigIntConstant( XKB_KEY_XF86Macro3, "XKB_KEY_XF86Macro3" );
	#endif
	#ifdef XKB_KEY_XF86Macro4
		swigIntConstant( XKB_KEY_XF86Macro4, "XKB_KEY_XF86Macro4" );
	#endif
	#ifdef XKB_KEY_XF86Macro5
		swigIntConstant( XKB_KEY_XF86Macro5, "XKB_KEY_XF86Macro5" );
	#endif
	#ifdef XKB_KEY_XF86Macro6
		swigIntConstant( XKB_KEY_XF86Macro6, "XKB_KEY_XF86Macro6" );
	#endif
	#ifdef XKB_KEY_XF86Macro7
		swigIntConstant( XKB_KEY_XF86Macro7, "XKB_KEY_XF86Macro7" );
	#endif
	#ifdef XKB_KEY_XF86Macro8
		swigIntConstant( XKB_KEY_XF86Macro8, "XKB_KEY_XF86Macro8" );
	#endif
	#ifdef XKB_KEY_XF86Macro9
		swigIntConstant( XKB_KEY_XF86Macro9, "XKB_KEY_XF86Macro9" );
	#endif
	#ifdef XKB_KEY_XF86Macro10
		swigIntConstant( XKB_KEY_XF86Macro10, "XKB_KEY_XF86Macro10" );
	#endif
	#ifdef XKB_KEY_XF86Macro11
		swigIntConstant( XKB_KEY_XF86Macro11, "XKB_KEY_XF86Macro11" );
	#endif
	#ifdef XKB_KEY_XF86Macro12
		swigIntConstant( XKB_KEY_XF86Macro12, "XKB_KEY_XF86Macro12" );
	#endif
	#ifdef XKB_KEY_XF86Macro13
		swigIntConstant( XKB_KEY_XF86Macro13, "XKB_KEY_XF86Macro13" );
	#endif
	#ifdef XKB_KEY_XF86Macro14
		swigIntConstant( XKB_KEY_XF86Macro14, "XKB_KEY_XF86Macro14" );
	#endif
	#ifdef XKB_KEY_XF86Macro15
		swigIntConstant( XKB_KEY_XF86Macro15, "XKB_KEY_XF86Macro15" );
	#endif
	#ifdef XKB_KEY_XF86Macro16
		swigIntConstant( XKB_KEY_XF86Macro16, "XKB_KEY_XF86Macro16" );
	#endif
	#ifdef XKB_KEY_XF86Macro17
		swigIntConstant( XKB_KEY_XF86Macro17, "XKB_KEY_XF86Macro17" );
	#endif
	#ifdef XKB_KEY_XF86Macro18
		swigIntConstant( XKB_KEY_XF86Macro18, "XKB_KEY_XF86Macro18" );
	#endif
	#ifdef XKB_KEY_XF86Macro19
		swigIntConstant( XKB_KEY_XF86Macro19, "XKB_KEY_XF86Macro19" );
	#endif
	#ifdef XKB_KEY_XF86Macro20
		swigIntConstant( XKB_KEY_XF86Macro20, "XKB_KEY_XF86Macro20" );
	#endif
	#ifdef XKB_KEY_XF86Macro21
		swigIntConstant( XKB_KEY_XF86Macro21, "XKB_KEY_XF86Macro21" );
	#endif
	#ifdef XKB_KEY_XF86Macro22
		swigIntConstant( XKB_KEY_XF86Macro22, "XKB_KEY_XF86Macro22" );
	#endif
	#ifdef XKB_KEY_XF86Macro23
		swigIntConstant( XKB_KEY_XF86Macro23, "XKB_KEY_XF86Macro23" );
	#endif
	#ifdef XKB_KEY_XF86Macro24
		swigIntConstant( XKB_KEY_XF86Macro24, "XKB_KEY_XF86Macro24" );
	#endif
	#ifdef XKB_KEY_XF86Macro25
		swigIntConstant( XKB_KEY_XF86Macro25, "XKB_KEY_XF86Macro25" );
	#endif
	#ifdef XKB_KEY_XF86Macro26
		swigIntConstant( XKB_KEY_XF86Macro26, "XKB_KEY_XF86Macro26" );
	#endif
	#ifdef XKB_KEY_XF86Macro27
		swigIntConstant( XKB_KEY_XF86Macro27, "XKB_KEY_XF86Macro27" );
	#endif
	#ifdef XKB_KEY_XF86Macro28
		swigIntConstant( XKB_KEY_XF86Macro28, "XKB_KEY_XF86Macro28" );
	#endif
	#ifdef XKB_KEY_XF86Macro29
		swigIntConstant( XKB_KEY_XF86Macro29, "XKB_KEY_XF86Macro29" );
	#endif
	#ifdef XKB_KEY_XF86Macro30
		swigIntConstant( XKB_KEY_XF86Macro30, "XKB_KEY_XF86Macro30" );
	#endif
	#ifdef XKB_KEY_XF86MacroRecordStart
		swigIntConstant( XKB_KEY_XF86MacroRecordStart, "XKB_KEY_XF86MacroRecordStart" );
	#endif
	#ifdef XKB_KEY_XF86MacroRecordStop
		swigIntConstant( XKB_KEY_XF86MacroRecordStop, "XKB_KEY_XF86MacroRecordStop" );
	#endif
	#ifdef XKB_KEY_XF86MacroPresetCycle
		swigIntConstant( XKB_KEY_XF86MacroPresetCycle, "XKB_KEY_XF86MacroPresetCycle" );
	#endif
	#ifdef XKB_KEY_XF86MacroPreset1
		swigIntConstant( XKB_KEY_XF86MacroPreset1, "XKB_KEY_XF86MacroPreset1" );
	#endif
	#ifdef XKB_KEY_XF86MacroPreset2
		swigIntConstant( XKB_KEY_XF86MacroPreset2, "XKB_KEY_XF86MacroPreset2" );
	#endif
	#ifdef XKB_KEY_XF86MacroPreset3
		swigIntConstant( XKB_KEY_XF86MacroPreset3, "XKB_KEY_XF86MacroPreset3" );
	#endif
	#ifdef XKB_KEY_XF86KbdLcdMenu1
		swigIntConstant( XKB_KEY_XF86KbdLcdMenu1, "XKB_KEY_XF86KbdLcdMenu1" );
	#endif
	#ifdef XKB_KEY_XF86KbdLcdMenu2
		swigIntConstant( XKB_KEY_XF86KbdLcdMenu2, "XKB_KEY_XF86KbdLcdMenu2" );
	#endif
	#ifdef XKB_KEY_XF86KbdLcdMenu3
		swigIntConstant( XKB_KEY_XF86KbdLcdMenu3, "XKB_KEY_XF86KbdLcdMenu3" );
	#endif
	#ifdef XKB_KEY_XF86KbdLcdMenu4
		swigIntConstant( XKB_KEY_XF86KbdLcdMenu4, "XKB_KEY_XF86KbdLcdMenu4" );
	#endif
	#ifdef XKB_KEY_XF86KbdLcdMenu5
		swigIntConstant( XKB_KEY_XF86KbdLcdMenu5, "XKB_KEY_XF86KbdLcdMenu5" );
	#endif
	#ifdef XKB_KEY_SunFA_Grave
		swigIntConstant( XKB_KEY_SunFA_Grave, "XKB_KEY_SunFA_Grave" );
	#endif
	#ifdef XKB_KEY_SunFA_Circum
		swigIntConstant( XKB_KEY_SunFA_Circum, "XKB_KEY_SunFA_Circum" );
	#endif
	#ifdef XKB_KEY_SunFA_Tilde
		swigIntConstant( XKB_KEY_SunFA_Tilde, "XKB_KEY_SunFA_Tilde" );
	#endif
	#ifdef XKB_KEY_SunFA_Acute
		swigIntConstant( XKB_KEY_SunFA_Acute, "XKB_KEY_SunFA_Acute" );
	#endif
	#ifdef XKB_KEY_SunFA_Diaeresis
		swigIntConstant( XKB_KEY_SunFA_Diaeresis, "XKB_KEY_SunFA_Diaeresis" );
	#endif
	#ifdef XKB_KEY_SunFA_Cedilla
		swigIntConstant( XKB_KEY_SunFA_Cedilla, "XKB_KEY_SunFA_Cedilla" );
	#endif
	#ifdef XKB_KEY_SunF36
		swigIntConstant( XKB_KEY_SunF36, "XKB_KEY_SunF36" );
	#endif
	#ifdef XKB_KEY_SunF37
		swigIntConstant( XKB_KEY_SunF37, "XKB_KEY_SunF37" );
	#endif
	#ifdef XKB_KEY_SunSys_Req
		swigIntConstant( XKB_KEY_SunSys_Req, "XKB_KEY_SunSys_Req" );
	#endif
	#ifdef XKB_KEY_SunPrint_Screen
		swigIntConstant( XKB_KEY_SunPrint_Screen, "XKB_KEY_SunPrint_Screen" );
	#endif
	#ifdef XKB_KEY_SunCompose
		swigIntConstant( XKB_KEY_SunCompose, "XKB_KEY_SunCompose" );
	#endif
	#ifdef XKB_KEY_SunAltGraph
		swigIntConstant( XKB_KEY_SunAltGraph, "XKB_KEY_SunAltGraph" );
	#endif
	#ifdef XKB_KEY_SunPageUp
		swigIntConstant( XKB_KEY_SunPageUp, "XKB_KEY_SunPageUp" );
	#endif
	#ifdef XKB_KEY_SunPageDown
		swigIntConstant( XKB_KEY_SunPageDown, "XKB_KEY_SunPageDown" );
	#endif
	#ifdef XKB_KEY_SunUndo
		swigIntConstant( XKB_KEY_SunUndo, "XKB_KEY_SunUndo" );
	#endif
	#ifdef XKB_KEY_SunAgain
		swigIntConstant( XKB_KEY_SunAgain, "XKB_KEY_SunAgain" );
	#endif
	#ifdef XKB_KEY_SunFind
		swigIntConstant( XKB_KEY_SunFind, "XKB_KEY_SunFind" );
	#endif
	#ifdef XKB_KEY_SunStop
		swigIntConstant( XKB_KEY_SunStop, "XKB_KEY_SunStop" );
	#endif
	#ifdef XKB_KEY_SunProps
		swigIntConstant( XKB_KEY_SunProps, "XKB_KEY_SunProps" );
	#endif
	#ifdef XKB_KEY_SunFront
		swigIntConstant( XKB_KEY_SunFront, "XKB_KEY_SunFront" );
	#endif
	#ifdef XKB_KEY_SunCopy
		swigIntConstant( XKB_KEY_SunCopy, "XKB_KEY_SunCopy" );
	#endif
	#ifdef XKB_KEY_SunOpen
		swigIntConstant( XKB_KEY_SunOpen, "XKB_KEY_SunOpen" );
	#endif
	#ifdef XKB_KEY_SunPaste
		swigIntConstant( XKB_KEY_SunPaste, "XKB_KEY_SunPaste" );
	#endif
	#ifdef XKB_KEY_SunCut
		swigIntConstant( XKB_KEY_SunCut, "XKB_KEY_SunCut" );
	#endif
	#ifdef XKB_KEY_SunPowerSwitch
		swigIntConstant( XKB_KEY_SunPowerSwitch, "XKB_KEY_SunPowerSwitch" );
	#endif
	#ifdef XKB_KEY_SunAudioLowerVolume
		swigIntConstant( XKB_KEY_SunAudioLowerVolume, "XKB_KEY_SunAudioLowerVolume" );
	#endif
	#ifdef XKB_KEY_SunAudioMute
		swigIntConstant( XKB_KEY_SunAudioMute, "XKB_KEY_SunAudioMute" );
	#endif
	#ifdef XKB_KEY_SunAudioRaiseVolume
		swigIntConstant( XKB_KEY_SunAudioRaiseVolume, "XKB_KEY_SunAudioRaiseVolume" );
	#endif
	#ifdef XKB_KEY_SunVideoDegauss
		swigIntConstant( XKB_KEY_SunVideoDegauss, "XKB_KEY_SunVideoDegauss" );
	#endif
	#ifdef XKB_KEY_SunVideoLowerBrightness
		swigIntConstant( XKB_KEY_SunVideoLowerBrightness, "XKB_KEY_SunVideoLowerBrightness" );
	#endif
	#ifdef XKB_KEY_SunVideoRaiseBrightness
		swigIntConstant( XKB_KEY_SunVideoRaiseBrightness, "XKB_KEY_SunVideoRaiseBrightness" );
	#endif
	#ifdef XKB_KEY_SunPowerSwitchShift
		swigIntConstant( XKB_KEY_SunPowerSwitchShift, "XKB_KEY_SunPowerSwitchShift" );
	#endif
	#ifdef XKB_KEY_Dring_accent
		swigIntConstant( XKB_KEY_Dring_accent, "XKB_KEY_Dring_accent" );
	#endif
	#ifdef XKB_KEY_Dcircumflex_accent
		swigIntConstant( XKB_KEY_Dcircumflex_accent, "XKB_KEY_Dcircumflex_accent" );
	#endif
	#ifdef XKB_KEY_Dcedilla_accent
		swigIntConstant( XKB_KEY_Dcedilla_accent, "XKB_KEY_Dcedilla_accent" );
	#endif
	#ifdef XKB_KEY_Dacute_accent
		swigIntConstant( XKB_KEY_Dacute_accent, "XKB_KEY_Dacute_accent" );
	#endif
	#ifdef XKB_KEY_Dgrave_accent
		swigIntConstant( XKB_KEY_Dgrave_accent, "XKB_KEY_Dgrave_accent" );
	#endif
	#ifdef XKB_KEY_Dtilde
		swigIntConstant( XKB_KEY_Dtilde, "XKB_KEY_Dtilde" );
	#endif
	#ifdef XKB_KEY_Ddiaeresis
		swigIntConstant( XKB_KEY_Ddiaeresis, "XKB_KEY_Ddiaeresis" );
	#endif
	#ifdef XKB_KEY_DRemove
		swigIntConstant( XKB_KEY_DRemove, "XKB_KEY_DRemove" );
	#endif
	#ifdef XKB_KEY_hpClearLine
		swigIntConstant( XKB_KEY_hpClearLine, "XKB_KEY_hpClearLine" );
	#endif
	#ifdef XKB_KEY_hpInsertLine
		swigIntConstant( XKB_KEY_hpInsertLine, "XKB_KEY_hpInsertLine" );
	#endif
	#ifdef XKB_KEY_hpDeleteLine
		swigIntConstant( XKB_KEY_hpDeleteLine, "XKB_KEY_hpDeleteLine" );
	#endif
	#ifdef XKB_KEY_hpInsertChar
		swigIntConstant( XKB_KEY_hpInsertChar, "XKB_KEY_hpInsertChar" );
	#endif
	#ifdef XKB_KEY_hpDeleteChar
		swigIntConstant( XKB_KEY_hpDeleteChar, "XKB_KEY_hpDeleteChar" );
	#endif
	#ifdef XKB_KEY_hpBackTab
		swigIntConstant( XKB_KEY_hpBackTab, "XKB_KEY_hpBackTab" );
	#endif
	#ifdef XKB_KEY_hpKP_BackTab
		swigIntConstant( XKB_KEY_hpKP_BackTab, "XKB_KEY_hpKP_BackTab" );
	#endif
	#ifdef XKB_KEY_hpModelock1
		swigIntConstant( XKB_KEY_hpModelock1, "XKB_KEY_hpModelock1" );
	#endif
	#ifdef XKB_KEY_hpModelock2
		swigIntConstant( XKB_KEY_hpModelock2, "XKB_KEY_hpModelock2" );
	#endif
	#ifdef XKB_KEY_hpReset
		swigIntConstant( XKB_KEY_hpReset, "XKB_KEY_hpReset" );
	#endif
	#ifdef XKB_KEY_hpSystem
		swigIntConstant( XKB_KEY_hpSystem, "XKB_KEY_hpSystem" );
	#endif
	#ifdef XKB_KEY_hpUser
		swigIntConstant( XKB_KEY_hpUser, "XKB_KEY_hpUser" );
	#endif
	#ifdef XKB_KEY_hpmute_acute
		swigIntConstant( XKB_KEY_hpmute_acute, "XKB_KEY_hpmute_acute" );
	#endif
	#ifdef XKB_KEY_hpmute_grave
		swigIntConstant( XKB_KEY_hpmute_grave, "XKB_KEY_hpmute_grave" );
	#endif
	#ifdef XKB_KEY_hpmute_asciicircum
		swigIntConstant( XKB_KEY_hpmute_asciicircum, "XKB_KEY_hpmute_asciicircum" );
	#endif
	#ifdef XKB_KEY_hpmute_diaeresis
		swigIntConstant( XKB_KEY_hpmute_diaeresis, "XKB_KEY_hpmute_diaeresis" );
	#endif
	#ifdef XKB_KEY_hpmute_asciitilde
		swigIntConstant( XKB_KEY_hpmute_asciitilde, "XKB_KEY_hpmute_asciitilde" );
	#endif
	#ifdef XKB_KEY_hplira
		swigIntConstant( XKB_KEY_hplira, "XKB_KEY_hplira" );
	#endif
	#ifdef XKB_KEY_hpguilder
		swigIntConstant( XKB_KEY_hpguilder, "XKB_KEY_hpguilder" );
	#endif
	#ifdef XKB_KEY_hpYdiaeresis
		swigIntConstant( XKB_KEY_hpYdiaeresis, "XKB_KEY_hpYdiaeresis" );
	#endif
	#ifdef XKB_KEY_hpIO
		swigIntConstant( XKB_KEY_hpIO, "XKB_KEY_hpIO" );
	#endif
	#ifdef XKB_KEY_hplongminus
		swigIntConstant( XKB_KEY_hplongminus, "XKB_KEY_hplongminus" );
	#endif
	#ifdef XKB_KEY_hpblock
		swigIntConstant( XKB_KEY_hpblock, "XKB_KEY_hpblock" );
	#endif
	#ifdef XKB_KEY_osfCopy
		swigIntConstant( XKB_KEY_osfCopy, "XKB_KEY_osfCopy" );
	#endif
	#ifdef XKB_KEY_osfCut
		swigIntConstant( XKB_KEY_osfCut, "XKB_KEY_osfCut" );
	#endif
	#ifdef XKB_KEY_osfPaste
		swigIntConstant( XKB_KEY_osfPaste, "XKB_KEY_osfPaste" );
	#endif
	#ifdef XKB_KEY_osfBackTab
		swigIntConstant( XKB_KEY_osfBackTab, "XKB_KEY_osfBackTab" );
	#endif
	#ifdef XKB_KEY_osfBackSpace
		swigIntConstant( XKB_KEY_osfBackSpace, "XKB_KEY_osfBackSpace" );
	#endif
	#ifdef XKB_KEY_osfClear
		swigIntConstant( XKB_KEY_osfClear, "XKB_KEY_osfClear" );
	#endif
	#ifdef XKB_KEY_osfEscape
		swigIntConstant( XKB_KEY_osfEscape, "XKB_KEY_osfEscape" );
	#endif
	#ifdef XKB_KEY_osfAddMode
		swigIntConstant( XKB_KEY_osfAddMode, "XKB_KEY_osfAddMode" );
	#endif
	#ifdef XKB_KEY_osfPrimaryPaste
		swigIntConstant( XKB_KEY_osfPrimaryPaste, "XKB_KEY_osfPrimaryPaste" );
	#endif
	#ifdef XKB_KEY_osfQuickPaste
		swigIntConstant( XKB_KEY_osfQuickPaste, "XKB_KEY_osfQuickPaste" );
	#endif
	#ifdef XKB_KEY_osfPageLeft
		swigIntConstant( XKB_KEY_osfPageLeft, "XKB_KEY_osfPageLeft" );
	#endif
	#ifdef XKB_KEY_osfPageUp
		swigIntConstant( XKB_KEY_osfPageUp, "XKB_KEY_osfPageUp" );
	#endif
	#ifdef XKB_KEY_osfPageDown
		swigIntConstant( XKB_KEY_osfPageDown, "XKB_KEY_osfPageDown" );
	#endif
	#ifdef XKB_KEY_osfPageRight
		swigIntConstant( XKB_KEY_osfPageRight, "XKB_KEY_osfPageRight" );
	#endif
	#ifdef XKB_KEY_osfActivate
		swigIntConstant( XKB_KEY_osfActivate, "XKB_KEY_osfActivate" );
	#endif
	#ifdef XKB_KEY_osfMenuBar
		swigIntConstant( XKB_KEY_osfMenuBar, "XKB_KEY_osfMenuBar" );
	#endif
	#ifdef XKB_KEY_osfLeft
		swigIntConstant( XKB_KEY_osfLeft, "XKB_KEY_osfLeft" );
	#endif
	#ifdef XKB_KEY_osfUp
		swigIntConstant( XKB_KEY_osfUp, "XKB_KEY_osfUp" );
	#endif
	#ifdef XKB_KEY_osfRight
		swigIntConstant( XKB_KEY_osfRight, "XKB_KEY_osfRight" );
	#endif
	#ifdef XKB_KEY_osfDown
		swigIntConstant( XKB_KEY_osfDown, "XKB_KEY_osfDown" );
	#endif
	#ifdef XKB_KEY_osfEndLine
		swigIntConstant( XKB_KEY_osfEndLine, "XKB_KEY_osfEndLine" );
	#endif
	#ifdef XKB_KEY_osfBeginLine
		swigIntConstant( XKB_KEY_osfBeginLine, "XKB_KEY_osfBeginLine" );
	#endif
	#ifdef XKB_KEY_osfEndData
		swigIntConstant( XKB_KEY_osfEndData, "XKB_KEY_osfEndData" );
	#endif
	#ifdef XKB_KEY_osfBeginData
		swigIntConstant( XKB_KEY_osfBeginData, "XKB_KEY_osfBeginData" );
	#endif
	#ifdef XKB_KEY_osfPrevMenu
		swigIntConstant( XKB_KEY_osfPrevMenu, "XKB_KEY_osfPrevMenu" );
	#endif
	#ifdef XKB_KEY_osfNextMenu
		swigIntConstant( XKB_KEY_osfNextMenu, "XKB_KEY_osfNextMenu" );
	#endif
	#ifdef XKB_KEY_osfPrevField
		swigIntConstant( XKB_KEY_osfPrevField, "XKB_KEY_osfPrevField" );
	#endif
	#ifdef XKB_KEY_osfNextField
		swigIntConstant( XKB_KEY_osfNextField, "XKB_KEY_osfNextField" );
	#endif
	#ifdef XKB_KEY_osfSelect
		swigIntConstant( XKB_KEY_osfSelect, "XKB_KEY_osfSelect" );
	#endif
	#ifdef XKB_KEY_osfInsert
		swigIntConstant( XKB_KEY_osfInsert, "XKB_KEY_osfInsert" );
	#endif
	#ifdef XKB_KEY_osfUndo
		swigIntConstant( XKB_KEY_osfUndo, "XKB_KEY_osfUndo" );
	#endif
	#ifdef XKB_KEY_osfMenu
		swigIntConstant( XKB_KEY_osfMenu, "XKB_KEY_osfMenu" );
	#endif
	#ifdef XKB_KEY_osfCancel
		swigIntConstant( XKB_KEY_osfCancel, "XKB_KEY_osfCancel" );
	#endif
	#ifdef XKB_KEY_osfHelp
		swigIntConstant( XKB_KEY_osfHelp, "XKB_KEY_osfHelp" );
	#endif
	#ifdef XKB_KEY_osfSelectAll
		swigIntConstant( XKB_KEY_osfSelectAll, "XKB_KEY_osfSelectAll" );
	#endif
	#ifdef XKB_KEY_osfDeselectAll
		swigIntConstant( XKB_KEY_osfDeselectAll, "XKB_KEY_osfDeselectAll" );
	#endif
	#ifdef XKB_KEY_osfReselect
		swigIntConstant( XKB_KEY_osfReselect, "XKB_KEY_osfReselect" );
	#endif
	#ifdef XKB_KEY_osfExtend
		swigIntConstant( XKB_KEY_osfExtend, "XKB_KEY_osfExtend" );
	#endif
	#ifdef XKB_KEY_osfRestore
		swigIntConstant( XKB_KEY_osfRestore, "XKB_KEY_osfRestore" );
	#endif
	#ifdef XKB_KEY_osfDelete
		swigIntConstant( XKB_KEY_osfDelete, "XKB_KEY_osfDelete" );
	#endif
	#ifdef XKB_KEY_Reset
		swigIntConstant( XKB_KEY_Reset, "XKB_KEY_Reset" );
	#endif
	#ifdef XKB_KEY_System
		swigIntConstant( XKB_KEY_System, "XKB_KEY_System" );
	#endif
	#ifdef XKB_KEY_User
		swigIntConstant( XKB_KEY_User, "XKB_KEY_User" );
	#endif
	#ifdef XKB_KEY_ClearLine
		swigIntConstant( XKB_KEY_ClearLine, "XKB_KEY_ClearLine" );
	#endif
	#ifdef XKB_KEY_InsertLine
		swigIntConstant( XKB_KEY_InsertLine, "XKB_KEY_InsertLine" );
	#endif
	#ifdef XKB_KEY_DeleteLine
		swigIntConstant( XKB_KEY_DeleteLine, "XKB_KEY_DeleteLine" );
	#endif
	#ifdef XKB_KEY_InsertChar
		swigIntConstant( XKB_KEY_InsertChar, "XKB_KEY_InsertChar" );
	#endif
	#ifdef XKB_KEY_DeleteChar
		swigIntConstant( XKB_KEY_DeleteChar, "XKB_KEY_DeleteChar" );
	#endif
	#ifdef XKB_KEY_BackTab
		swigIntConstant( XKB_KEY_BackTab, "XKB_KEY_BackTab" );
	#endif
	#ifdef XKB_KEY_KP_BackTab
		swigIntConstant( XKB_KEY_KP_BackTab, "XKB_KEY_KP_BackTab" );
	#endif
	#ifdef XKB_KEY_Ext16bit_L
		swigIntConstant( XKB_KEY_Ext16bit_L, "XKB_KEY_Ext16bit_L" );
	#endif
	#ifdef XKB_KEY_Ext16bit_R
		swigIntConstant( XKB_KEY_Ext16bit_R, "XKB_KEY_Ext16bit_R" );
	#endif
	#ifdef XKB_KEY_mute_acute
		swigIntConstant( XKB_KEY_mute_acute, "XKB_KEY_mute_acute" );
	#endif
	#ifdef XKB_KEY_mute_grave
		swigIntConstant( XKB_KEY_mute_grave, "XKB_KEY_mute_grave" );
	#endif
	#ifdef XKB_KEY_mute_asciicircum
		swigIntConstant( XKB_KEY_mute_asciicircum, "XKB_KEY_mute_asciicircum" );
	#endif
	#ifdef XKB_KEY_mute_diaeresis
		swigIntConstant( XKB_KEY_mute_diaeresis, "XKB_KEY_mute_diaeresis" );
	#endif
	#ifdef XKB_KEY_mute_asciitilde
		swigIntConstant( XKB_KEY_mute_asciitilde, "XKB_KEY_mute_asciitilde" );
	#endif
	#ifdef XKB_KEY_lira
		swigIntConstant( XKB_KEY_lira, "XKB_KEY_lira" );
	#endif
	#ifdef XKB_KEY_guilder
		swigIntConstant( XKB_KEY_guilder, "XKB_KEY_guilder" );
	#endif
	#ifdef XKB_KEY_IO
		swigIntConstant( XKB_KEY_IO, "XKB_KEY_IO" );
	#endif
	#ifdef XKB_KEY_longminus
		swigIntConstant( XKB_KEY_longminus, "XKB_KEY_longminus" );
	#endif
	#ifdef XKB_KEY_block
		swigIntConstant( XKB_KEY_block, "XKB_KEY_block" );
	#endif

	swigNewline();

	swigComment("--------===< enums >===---------\n");
	swigIntConstant( XKB_RMLVO_BUILDER_NO_FLAGS, "XKB_RMLVO_BUILDER_NO_FLAGS" );
	swigIntConstant( XKB_KEYSYM_NO_FLAGS, "XKB_KEYSYM_NO_FLAGS" );
	swigIntConstant( XKB_KEYSYM_CASE_INSENSITIVE, "XKB_KEYSYM_CASE_INSENSITIVE" );
	swigIntConstant( XKB_CONTEXT_NO_FLAGS, "XKB_CONTEXT_NO_FLAGS" );
	swigIntConstant( XKB_CONTEXT_NO_DEFAULT_INCLUDES, "XKB_CONTEXT_NO_DEFAULT_INCLUDES" );
	swigIntConstant( XKB_CONTEXT_NO_ENVIRONMENT_NAMES, "XKB_CONTEXT_NO_ENVIRONMENT_NAMES" );
	swigIntConstant( XKB_CONTEXT_NO_SECURE_GETENV, "XKB_CONTEXT_NO_SECURE_GETENV" );
	swigIntConstant( XKB_LOG_LEVEL_CRITICAL, "XKB_LOG_LEVEL_CRITICAL" );
	swigIntConstant( XKB_LOG_LEVEL_ERROR, "XKB_LOG_LEVEL_ERROR" );
	swigIntConstant( XKB_LOG_LEVEL_WARNING, "XKB_LOG_LEVEL_WARNING" );
	swigIntConstant( XKB_LOG_LEVEL_INFO, "XKB_LOG_LEVEL_INFO" );
	swigIntConstant( XKB_LOG_LEVEL_DEBUG, "XKB_LOG_LEVEL_DEBUG" );
	swigIntConstant( XKB_KEYMAP_COMPILE_NO_FLAGS, "XKB_KEYMAP_COMPILE_NO_FLAGS" );
	swigIntConstant( XKB_KEYMAP_FORMAT_TEXT_V1, "XKB_KEYMAP_FORMAT_TEXT_V1" );
	swigIntConstant( XKB_KEYMAP_FORMAT_TEXT_V2, "XKB_KEYMAP_FORMAT_TEXT_V2" );
	swigIntConstant( XKB_KEY_UP, "XKB_KEY_UP" );
	swigIntConstant( XKB_KEY_DOWN, "XKB_KEY_DOWN" );
	swigIntConstant( XKB_STATE_MODS_DEPRESSED, "XKB_STATE_MODS_DEPRESSED" );
	swigIntConstant( XKB_STATE_MODS_LATCHED, "XKB_STATE_MODS_LATCHED" );
	swigIntConstant( XKB_STATE_MODS_LOCKED, "XKB_STATE_MODS_LOCKED" );
	swigIntConstant( XKB_STATE_MODS_EFFECTIVE, "XKB_STATE_MODS_EFFECTIVE" );
	swigIntConstant( XKB_STATE_LAYOUT_DEPRESSED, "XKB_STATE_LAYOUT_DEPRESSED" );
	swigIntConstant( XKB_STATE_LAYOUT_LATCHED, "XKB_STATE_LAYOUT_LATCHED" );
	swigIntConstant( XKB_STATE_LAYOUT_LOCKED, "XKB_STATE_LAYOUT_LOCKED" );
	swigIntConstant( XKB_STATE_LAYOUT_EFFECTIVE, "XKB_STATE_LAYOUT_EFFECTIVE" );
	swigIntConstant( XKB_STATE_LEDS, "XKB_STATE_LEDS" );
	swigIntConstant( XKB_STATE_MATCH_ANY, "XKB_STATE_MATCH_ANY" );
	swigIntConstant( XKB_STATE_MATCH_ALL, "XKB_STATE_MATCH_ALL" );
	swigIntConstant( XKB_STATE_MATCH_NON_EXCLUSIVE, "XKB_STATE_MATCH_NON_EXCLUSIVE" );
	swigIntConstant( XKB_CONSUMED_MODE_XKB, "XKB_CONSUMED_MODE_XKB" );
	swigIntConstant( XKB_CONSUMED_MODE_GTK, "XKB_CONSUMED_MODE_GTK" );

	swigNewline();

	swigComment("-------===< structs >===--------\n");

	swigComment("struct xkb_rule_names\n");
	printf( "begin-structure xkb_rule_names\n" );
	swigStructField( "xkb_rule_names-layout", offsetof( struct xkb_rule_names, layout ), sizeof( char const * ) );
	swigStructField( "xkb_rule_names-variant", offsetof( struct xkb_rule_names, variant ), sizeof( char const * ) );
	swigStructField( "xkb_rule_names-rules", offsetof( struct xkb_rule_names, rules ), sizeof( char const * ) );
	swigStructField( "xkb_rule_names-model", offsetof( struct xkb_rule_names, model ), sizeof( char const * ) );
	swigStructField( "xkb_rule_names-options", offsetof( struct xkb_rule_names, options ), sizeof( char const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct xkb_rule_names ) );

	swigComment("struct xkb_component_names\n");
	printf( "begin-structure xkb_component_names\n" );
	swigStructField( "xkb_component_names-keycodes", offsetof( struct xkb_component_names, keycodes ), sizeof( char * ) );
	swigStructField( "xkb_component_names-symbols", offsetof( struct xkb_component_names, symbols ), sizeof( char * ) );
	swigStructField( "xkb_component_names-compatibility", offsetof( struct xkb_component_names, compatibility ), sizeof( char * ) );
	swigStructField( "xkb_component_names-geometry", offsetof( struct xkb_component_names, geometry ), sizeof( char * ) );
	swigStructField( "xkb_component_names-types", offsetof( struct xkb_component_names, types ), sizeof( char * ) );
	printf( "drop %zu end-structure\n", sizeof( struct xkb_component_names ) );

	swigNewline();

	swigComment("------===< callbacks >===-------\n");
	swigCallback( "c-callback xkb_keymap_key_iter_t: a u a -- void", "", "", "	( keymap key data -- )" );

	swigNewline();

	swigComment("------===< functions >===-------\n");
	swigFunction( "c-function xkb_rmlvo_builder_new xkb_rmlvo_builder_new a s s n -- a", "FUNCTION: xkb_rmlvo_builder_new ( context rules model flags -- a )", "EXTERN: \"C\" void * xkb_rmlvo_builder_new( void * context, char * rules, char * model, int flags );", "	( context rules model flags -- )" );
	swigFunction( "c-function xkb_rmlvo_builder_append_layout xkb_rmlvo_builder_append_layout a s s a u -- n", "FUNCTION: xkb_rmlvo_builder_append_layout ( rmlvo layout variant options options_len -- n )", "EXTERN: \"C\" bool xkb_rmlvo_builder_append_layout( void * rmlvo, char * layout, char * variant, void * options, long options_len );", "	( rmlvo layout variant options options_len -- )" );
	swigFunction( "c-function xkb_rmlvo_builder_append_option xkb_rmlvo_builder_append_option a s -- n", "FUNCTION: xkb_rmlvo_builder_append_option ( rmlvo option -- n )", "EXTERN: \"C\" bool xkb_rmlvo_builder_append_option( void * rmlvo, char * option );", "	( rmlvo option -- )" );
	swigFunction( "c-function xkb_rmlvo_builder_ref xkb_rmlvo_builder_ref a -- a", "FUNCTION: xkb_rmlvo_builder_ref ( rmlvo -- a )", "EXTERN: \"C\" void * xkb_rmlvo_builder_ref( void * rmlvo );", "	( rmlvo -- )" );
	swigFunction( "c-function xkb_rmlvo_builder_unref xkb_rmlvo_builder_unref a -- void", "FUNCTION: xkb_rmlvo_builder_unref ( rmlvo -- void )", "EXTERN: \"C\" void xkb_rmlvo_builder_unref( void * rmlvo );", "	( rmlvo -- )" );
#ifdef XKBCOMMON_VERSION_0_10
	swigFunction( "c-function xkb_components_names_from_rules xkb_components_names_from_rules a a a a -- n", "FUNCTION: xkb_components_names_from_rules ( context rmlvo_in rmlvo_out components_out -- n )", "EXTERN: \"C\" bool xkb_components_names_from_rules( void * context, void * rmlvo_in, void * rmlvo_out, void * components_out );", "	( context rmlvo_in rmlvo_out components_out -- )" );
#endif
	swigFunction( "c-function xkb_keysym_get_name xkb_keysym_get_name u a u -- n", "FUNCTION: xkb_keysym_get_name ( keysym buffer size -- n )", "EXTERN: \"C\" int xkb_keysym_get_name( int keysym, void * buffer, long size );", "	( keysym buffer size -- )" );
	swigFunction( "c-function xkb_keysym_from_name xkb_keysym_from_name s n -- u", "FUNCTION: xkb_keysym_from_name ( name flags -- u )", "EXTERN: \"C\" int xkb_keysym_from_name( char * name, int flags );", "	( name flags -- )" );
	swigFunction( "c-function xkb_keysym_to_utf8 xkb_keysym_to_utf8 u a u -- n", "FUNCTION: xkb_keysym_to_utf8 ( keysym buffer size -- n )", "EXTERN: \"C\" int xkb_keysym_to_utf8( int keysym, void * buffer, long size );", "	( keysym buffer size -- )" );
	swigFunction( "c-function xkb_keysym_to_utf32 xkb_keysym_to_utf32 u -- u", "FUNCTION: xkb_keysym_to_utf32 ( keysym -- u )", "EXTERN: \"C\" int xkb_keysym_to_utf32( int keysym );", "	( keysym -- )" );
	swigFunction( "c-function xkb_utf32_to_keysym xkb_utf32_to_keysym u -- u", "FUNCTION: xkb_utf32_to_keysym ( ucs -- u )", "EXTERN: \"C\" int xkb_utf32_to_keysym( int ucs );", "	( ucs -- )" );
	swigFunction( "c-function xkb_keysym_to_upper xkb_keysym_to_upper u -- u", "FUNCTION: xkb_keysym_to_upper ( ks -- u )", "EXTERN: \"C\" int xkb_keysym_to_upper( int ks );", "	( ks -- )" );
	swigFunction( "c-function xkb_keysym_to_lower xkb_keysym_to_lower u -- u", "FUNCTION: xkb_keysym_to_lower ( ks -- u )", "EXTERN: \"C\" int xkb_keysym_to_lower( int ks );", "	( ks -- )" );
	swigFunction( "c-function xkb_context_new xkb_context_new n -- a", "FUNCTION: xkb_context_new ( flags -- a )", "EXTERN: \"C\" void * xkb_context_new( int flags );", "	( flags -- )" );
	swigFunction( "c-function xkb_context_ref xkb_context_ref a -- a", "FUNCTION: xkb_context_ref ( context -- a )", "EXTERN: \"C\" void * xkb_context_ref( void * context );", "	( context -- )" );
	swigFunction( "c-function xkb_context_unref xkb_context_unref a -- void", "FUNCTION: xkb_context_unref ( context -- void )", "EXTERN: \"C\" void xkb_context_unref( void * context );", "	( context -- )" );
	swigFunction( "c-function xkb_context_set_user_data xkb_context_set_user_data a a -- void", "FUNCTION: xkb_context_set_user_data ( context user_data -- void )", "EXTERN: \"C\" void xkb_context_set_user_data( void * context, void * user_data );", "	( context user_data -- )" );
	swigFunction( "c-function xkb_context_get_user_data xkb_context_get_user_data a -- a", "FUNCTION: xkb_context_get_user_data ( context -- a )", "EXTERN: \"C\" void * xkb_context_get_user_data( void * context );", "	( context -- )" );
	swigFunction( "c-function xkb_context_include_path_append xkb_context_include_path_append a s -- n", "FUNCTION: xkb_context_include_path_append ( context path -- n )", "EXTERN: \"C\" int xkb_context_include_path_append( void * context, char * path );", "	( context path -- )" );
	swigFunction( "c-function xkb_context_include_path_append_default xkb_context_include_path_append_default a -- n", "FUNCTION: xkb_context_include_path_append_default ( context -- n )", "EXTERN: \"C\" int xkb_context_include_path_append_default( void * context );", "	( context -- )" );
	swigFunction( "c-function xkb_context_include_path_reset_defaults xkb_context_include_path_reset_defaults a -- n", "FUNCTION: xkb_context_include_path_reset_defaults ( context -- n )", "EXTERN: \"C\" int xkb_context_include_path_reset_defaults( void * context );", "	( context -- )" );
	swigFunction( "c-function xkb_context_include_path_clear xkb_context_include_path_clear a -- void", "FUNCTION: xkb_context_include_path_clear ( context -- void )", "EXTERN: \"C\" void xkb_context_include_path_clear( void * context );", "	( context -- )" );
	swigFunction( "c-function xkb_context_num_include_paths xkb_context_num_include_paths a -- u", "FUNCTION: xkb_context_num_include_paths ( context -- u )", "EXTERN: \"C\" int xkb_context_num_include_paths( void * context );", "	( context -- )" );
	swigFunction( "c-function xkb_context_include_path_get xkb_context_include_path_get a u -- s", "FUNCTION: xkb_context_include_path_get ( context index -- s )", "EXTERN: \"C\" char * xkb_context_include_path_get( void * context, int index );", "	( context index -- )" );
	swigFunction( "c-function xkb_context_set_log_level xkb_context_set_log_level a n -- void", "FUNCTION: xkb_context_set_log_level ( context level -- void )", "EXTERN: \"C\" void xkb_context_set_log_level( void * context, int level );", "	( context level -- )" );
	swigFunction( "c-function xkb_context_get_log_level xkb_context_get_log_level a -- n", "FUNCTION: xkb_context_get_log_level ( context -- n )", "EXTERN: \"C\" int xkb_context_get_log_level( void * context );", "	( context -- )" );
	swigFunction( "c-function xkb_context_set_log_verbosity xkb_context_set_log_verbosity a n -- void", "FUNCTION: xkb_context_set_log_verbosity ( context verbosity -- void )", "EXTERN: \"C\" void xkb_context_set_log_verbosity( void * context, int verbosity );", "	( context verbosity -- )" );
	swigFunction( "c-function xkb_context_get_log_verbosity xkb_context_get_log_verbosity a -- n", "FUNCTION: xkb_context_get_log_verbosity ( context -- n )", "EXTERN: \"C\" int xkb_context_get_log_verbosity( void * context );", "	( context -- )" );
	swigFunction( "c-function xkb_context_set_log_fn xkb_context_set_log_fn a a -- void", "FUNCTION: xkb_context_set_log_fn ( context log_fn -- void )", "EXTERN: \"C\" void xkb_context_set_log_fn( void * context, void * log_fn );", "	( context log_fn -- )" );
	swigFunction( "c-function xkb_keymap_new_from_rmlvo xkb_keymap_new_from_rmlvo a n n -- a", "FUNCTION: xkb_keymap_new_from_rmlvo ( rmlvo format flags -- a )", "EXTERN: \"C\" void * xkb_keymap_new_from_rmlvo( void * rmlvo, int format, int flags );", "	( rmlvo format flags -- )" );
	swigFunction( "c-function xkb_keymap_new_from_names xkb_keymap_new_from_names a a n -- a", "FUNCTION: xkb_keymap_new_from_names ( context names flags -- a )", "EXTERN: \"C\" void * xkb_keymap_new_from_names( void * context, void * names, int flags );", "	( context names flags -- )" );
	swigFunction( "c-function xkb_keymap_new_from_names2 xkb_keymap_new_from_names2 a a n n -- a", "FUNCTION: xkb_keymap_new_from_names2 ( context names format flags -- a )", "EXTERN: \"C\" void * xkb_keymap_new_from_names2( void * context, void * names, int format, int flags );", "	( context names format flags -- )" );
	swigFunction( "c-function xkb_keymap_new_from_file xkb_keymap_new_from_file a a n n -- a", "FUNCTION: xkb_keymap_new_from_file ( context file format flags -- a )", "EXTERN: \"C\" void * xkb_keymap_new_from_file( void * context, void * file, int format, int flags );", "	( context file format flags -- )" );
	swigFunction( "c-function xkb_keymap_new_from_string xkb_keymap_new_from_string a s n n -- a", "FUNCTION: xkb_keymap_new_from_string ( context string format flags -- a )", "EXTERN: \"C\" void * xkb_keymap_new_from_string( void * context, char * string, int format, int flags );", "	( context string format flags -- )" );
	swigFunction( "c-function xkb_keymap_new_from_buffer xkb_keymap_new_from_buffer a s u n n -- a", "FUNCTION: xkb_keymap_new_from_buffer ( context buffer length format flags -- a )", "EXTERN: \"C\" void * xkb_keymap_new_from_buffer( void * context, char * buffer, long length, int format, int flags );", "	( context buffer length format flags -- )" );
	swigFunction( "c-function xkb_keymap_ref xkb_keymap_ref a -- a", "FUNCTION: xkb_keymap_ref ( keymap -- a )", "EXTERN: \"C\" void * xkb_keymap_ref( void * keymap );", "	( keymap -- )" );
	swigFunction( "c-function xkb_keymap_unref xkb_keymap_unref a -- void", "FUNCTION: xkb_keymap_unref ( keymap -- void )", "EXTERN: \"C\" void xkb_keymap_unref( void * keymap );", "	( keymap -- )" );
	swigFunction( "c-function xkb_keymap_get_as_string xkb_keymap_get_as_string a n -- a", "FUNCTION: xkb_keymap_get_as_string ( keymap format -- a )", "EXTERN: \"C\" void * xkb_keymap_get_as_string( void * keymap, int format );", "	( keymap format -- )" );
	swigFunction( "c-function xkb_keymap_min_keycode xkb_keymap_min_keycode a -- u", "FUNCTION: xkb_keymap_min_keycode ( keymap -- u )", "EXTERN: \"C\" int xkb_keymap_min_keycode( void * keymap );", "	( keymap -- )" );
	swigFunction( "c-function xkb_keymap_max_keycode xkb_keymap_max_keycode a -- u", "FUNCTION: xkb_keymap_max_keycode ( keymap -- u )", "EXTERN: \"C\" int xkb_keymap_max_keycode( void * keymap );", "	( keymap -- )" );
	swigFunction( "c-function xkb_keymap_key_for_each xkb_keymap_key_for_each a a a -- void", "FUNCTION: xkb_keymap_key_for_each ( keymap iter data -- void )", "EXTERN: \"C\" void xkb_keymap_key_for_each( void * keymap, void * iter, void * data );", "	( keymap iter data -- )" );
	swigFunction( "c-function xkb_keymap_key_get_name xkb_keymap_key_get_name a u -- s", "FUNCTION: xkb_keymap_key_get_name ( keymap key -- s )", "EXTERN: \"C\" char * xkb_keymap_key_get_name( void * keymap, int key );", "	( keymap key -- )" );
	swigFunction( "c-function xkb_keymap_key_by_name xkb_keymap_key_by_name a s -- u", "FUNCTION: xkb_keymap_key_by_name ( keymap name -- u )", "EXTERN: \"C\" int xkb_keymap_key_by_name( void * keymap, char * name );", "	( keymap name -- )" );
	swigFunction( "c-function xkb_keymap_num_mods xkb_keymap_num_mods a -- u", "FUNCTION: xkb_keymap_num_mods ( keymap -- u )", "EXTERN: \"C\" int xkb_keymap_num_mods( void * keymap );", "	( keymap -- )" );
	swigFunction( "c-function xkb_keymap_mod_get_name xkb_keymap_mod_get_name a u -- s", "FUNCTION: xkb_keymap_mod_get_name ( keymap idx -- s )", "EXTERN: \"C\" char * xkb_keymap_mod_get_name( void * keymap, int idx );", "	( keymap idx -- )" );
	swigFunction( "c-function xkb_keymap_mod_get_index xkb_keymap_mod_get_index a s -- u", "FUNCTION: xkb_keymap_mod_get_index ( keymap name -- u )", "EXTERN: \"C\" int xkb_keymap_mod_get_index( void * keymap, char * name );", "	( keymap name -- )" );
#ifdef XKBCOMMON_VERSION_0_10
	swigFunction( "c-function xkb_keymap_mod_get_mask xkb_keymap_mod_get_mask a s -- u", "FUNCTION: xkb_keymap_mod_get_mask ( keymap name -- u )", "EXTERN: \"C\" int xkb_keymap_mod_get_mask( void * keymap, char * name );", "	( keymap name -- )" );
#endif
#ifdef XKBCOMMON_VERSION_0_10
	swigFunction( "c-function xkb_keymap_mod_get_mask2 xkb_keymap_mod_get_mask2 a u -- u", "FUNCTION: xkb_keymap_mod_get_mask2 ( keymap idx -- u )", "EXTERN: \"C\" int xkb_keymap_mod_get_mask2( void * keymap, int idx );", "	( keymap idx -- )" );
#endif
	swigFunction( "c-function xkb_keymap_num_layouts xkb_keymap_num_layouts a -- u", "FUNCTION: xkb_keymap_num_layouts ( keymap -- u )", "EXTERN: \"C\" int xkb_keymap_num_layouts( void * keymap );", "	( keymap -- )" );
	swigFunction( "c-function xkb_keymap_layout_get_name xkb_keymap_layout_get_name a u -- s", "FUNCTION: xkb_keymap_layout_get_name ( keymap idx -- s )", "EXTERN: \"C\" char * xkb_keymap_layout_get_name( void * keymap, int idx );", "	( keymap idx -- )" );
	swigFunction( "c-function xkb_keymap_layout_get_index xkb_keymap_layout_get_index a s -- u", "FUNCTION: xkb_keymap_layout_get_index ( keymap name -- u )", "EXTERN: \"C\" int xkb_keymap_layout_get_index( void * keymap, char * name );", "	( keymap name -- )" );
	swigFunction( "c-function xkb_keymap_num_leds xkb_keymap_num_leds a -- u", "FUNCTION: xkb_keymap_num_leds ( keymap -- u )", "EXTERN: \"C\" int xkb_keymap_num_leds( void * keymap );", "	( keymap -- )" );
	swigFunction( "c-function xkb_keymap_led_get_name xkb_keymap_led_get_name a u -- s", "FUNCTION: xkb_keymap_led_get_name ( keymap idx -- s )", "EXTERN: \"C\" char * xkb_keymap_led_get_name( void * keymap, int idx );", "	( keymap idx -- )" );
	swigFunction( "c-function xkb_keymap_led_get_index xkb_keymap_led_get_index a s -- u", "FUNCTION: xkb_keymap_led_get_index ( keymap name -- u )", "EXTERN: \"C\" int xkb_keymap_led_get_index( void * keymap, char * name );", "	( keymap name -- )" );
	swigFunction( "c-function xkb_keymap_num_layouts_for_key xkb_keymap_num_layouts_for_key a u -- u", "FUNCTION: xkb_keymap_num_layouts_for_key ( keymap key -- u )", "EXTERN: \"C\" int xkb_keymap_num_layouts_for_key( void * keymap, int key );", "	( keymap key -- )" );
	swigFunction( "c-function xkb_keymap_num_levels_for_key xkb_keymap_num_levels_for_key a u u -- u", "FUNCTION: xkb_keymap_num_levels_for_key ( keymap key layout -- u )", "EXTERN: \"C\" int xkb_keymap_num_levels_for_key( void * keymap, int key, int layout );", "	( keymap key layout -- )" );
	swigFunction( "c-function xkb_keymap_key_get_mods_for_level xkb_keymap_key_get_mods_for_level a u u u a u -- u", "FUNCTION: xkb_keymap_key_get_mods_for_level ( keymap key layout level masks_out masks_size -- u )", "EXTERN: \"C\" long xkb_keymap_key_get_mods_for_level( void * keymap, int key, int layout, int level, void * masks_out, long masks_size );", "	( keymap key layout level masks_out masks_size -- )" );
	swigFunction( "c-function xkb_keymap_key_get_syms_by_level xkb_keymap_key_get_syms_by_level a u u u a -- n", "FUNCTION: xkb_keymap_key_get_syms_by_level ( keymap key layout level syms_out -- n )", "EXTERN: \"C\" int xkb_keymap_key_get_syms_by_level( void * keymap, int key, int layout, int level, void * syms_out );", "	( keymap key layout level syms_out -- )" );
	swigFunction( "c-function xkb_keymap_key_repeats xkb_keymap_key_repeats a u -- n", "FUNCTION: xkb_keymap_key_repeats ( keymap key -- n )", "EXTERN: \"C\" int xkb_keymap_key_repeats( void * keymap, int key );", "	( keymap key -- )" );
	swigFunction( "c-function xkb_state_new xkb_state_new a -- a", "FUNCTION: xkb_state_new ( keymap -- a )", "EXTERN: \"C\" void * xkb_state_new( void * keymap );", "	( keymap -- )" );
	swigFunction( "c-function xkb_state_ref xkb_state_ref a -- a", "FUNCTION: xkb_state_ref ( state -- a )", "EXTERN: \"C\" void * xkb_state_ref( void * state );", "	( state -- )" );
	swigFunction( "c-function xkb_state_unref xkb_state_unref a -- void", "FUNCTION: xkb_state_unref ( state -- void )", "EXTERN: \"C\" void xkb_state_unref( void * state );", "	( state -- )" );
	swigFunction( "c-function xkb_state_get_keymap xkb_state_get_keymap a -- a", "FUNCTION: xkb_state_get_keymap ( state -- a )", "EXTERN: \"C\" void * xkb_state_get_keymap( void * state );", "	( state -- )" );
	swigFunction( "c-function xkb_state_update_key xkb_state_update_key a u n -- n", "FUNCTION: xkb_state_update_key ( state key direction -- n )", "EXTERN: \"C\" int xkb_state_update_key( void * state, int key, int direction );", "	( state key direction -- )" );
#ifdef XKBCOMMON_VERSION_0_10
	swigFunction( "c-function xkb_state_update_latched_locked xkb_state_update_latched_locked a u u n n u u n n -- n", "FUNCTION: xkb_state_update_latched_locked ( state affect_latched_mods latched_mods affect_latched_layout latched_layout affect_locked_mods locked_mods affect_locked_layout locked_layout -- n )", "EXTERN: \"C\" int xkb_state_update_latched_locked( void * state, int affect_latched_mods, int latched_mods, bool affect_latched_layout, long latched_layout, int affect_locked_mods, int locked_mods, bool affect_locked_layout, long locked_layout );", "	( state affect_latched_mods latched_mods affect_latched_layout latched_layout affect_locked_mods locked_mods affect_locked_layout locked_layout -- )" );
#endif
	swigFunction( "c-function xkb_state_update_mask xkb_state_update_mask a u u u u u u -- n", "FUNCTION: xkb_state_update_mask ( state depressed_mods latched_mods locked_mods depressed_layout latched_layout locked_layout -- n )", "EXTERN: \"C\" int xkb_state_update_mask( void * state, int depressed_mods, int latched_mods, int locked_mods, int depressed_layout, int latched_layout, int locked_layout );", "	( state depressed_mods latched_mods locked_mods depressed_layout latched_layout locked_layout -- )" );
	swigFunction( "c-function xkb_state_key_get_syms xkb_state_key_get_syms a u a -- n", "FUNCTION: xkb_state_key_get_syms ( state key syms_out -- n )", "EXTERN: \"C\" int xkb_state_key_get_syms( void * state, int key, void * syms_out );", "	( state key syms_out -- )" );
	swigFunction( "c-function xkb_state_key_get_utf8 xkb_state_key_get_utf8 a u a u -- n", "FUNCTION: xkb_state_key_get_utf8 ( state key buffer size -- n )", "EXTERN: \"C\" int xkb_state_key_get_utf8( void * state, int key, void * buffer, long size );", "	( state key buffer size -- )" );
	swigFunction( "c-function xkb_state_key_get_utf32 xkb_state_key_get_utf32 a u -- u", "FUNCTION: xkb_state_key_get_utf32 ( state key -- u )", "EXTERN: \"C\" int xkb_state_key_get_utf32( void * state, int key );", "	( state key -- )" );
	swigFunction( "c-function xkb_state_key_get_one_sym xkb_state_key_get_one_sym a u -- u", "FUNCTION: xkb_state_key_get_one_sym ( state key -- u )", "EXTERN: \"C\" int xkb_state_key_get_one_sym( void * state, int key );", "	( state key -- )" );
	swigFunction( "c-function xkb_state_key_get_layout xkb_state_key_get_layout a u -- u", "FUNCTION: xkb_state_key_get_layout ( state key -- u )", "EXTERN: \"C\" int xkb_state_key_get_layout( void * state, int key );", "	( state key -- )" );
	swigFunction( "c-function xkb_state_key_get_level xkb_state_key_get_level a u u -- u", "FUNCTION: xkb_state_key_get_level ( state key layout -- u )", "EXTERN: \"C\" int xkb_state_key_get_level( void * state, int key, int layout );", "	( state key layout -- )" );
	swigFunction( "c-function xkb_state_serialize_mods xkb_state_serialize_mods a n -- u", "FUNCTION: xkb_state_serialize_mods ( state components -- u )", "EXTERN: \"C\" int xkb_state_serialize_mods( void * state, int components );", "	( state components -- )" );
	swigFunction( "c-function xkb_state_serialize_layout xkb_state_serialize_layout a n -- u", "FUNCTION: xkb_state_serialize_layout ( state components -- u )", "EXTERN: \"C\" int xkb_state_serialize_layout( void * state, int components );", "	( state components -- )" );
	swigFunction( "c-function xkb_state_mod_name_is_active xkb_state_mod_name_is_active a s n -- n", "FUNCTION: xkb_state_mod_name_is_active ( state name type -- n )", "EXTERN: \"C\" int xkb_state_mod_name_is_active( void * state, char * name, int type );", "	( state name type -- )" );
	swigFunction( "c-function xkb_state_mod_names_are_active xkb_state_mod_names_are_active a n n ... -- n", "FUNCTION: xkb_state_mod_names_are_active ( state type match  -- n )", "EXTERN: \"C\" int xkb_state_mod_names_are_active( void * state, int type, int match, ...  );", "	( state type match <noname> -- )" );
	swigFunction( "c-function xkb_state_mod_index_is_active xkb_state_mod_index_is_active a u n -- n", "FUNCTION: xkb_state_mod_index_is_active ( state idx type -- n )", "EXTERN: \"C\" int xkb_state_mod_index_is_active( void * state, int idx, int type );", "	( state idx type -- )" );
	swigFunction( "c-function xkb_state_mod_indices_are_active xkb_state_mod_indices_are_active a n n ... -- n", "FUNCTION: xkb_state_mod_indices_are_active ( state type match  -- n )", "EXTERN: \"C\" int xkb_state_mod_indices_are_active( void * state, int type, int match, ...  );", "	( state type match <noname> -- )" );
	swigFunction( "c-function xkb_state_key_get_consumed_mods2 xkb_state_key_get_consumed_mods2 a u n -- u", "FUNCTION: xkb_state_key_get_consumed_mods2 ( state key mode -- u )", "EXTERN: \"C\" int xkb_state_key_get_consumed_mods2( void * state, int key, int mode );", "	( state key mode -- )" );
	swigFunction( "c-function xkb_state_key_get_consumed_mods xkb_state_key_get_consumed_mods a u -- u", "FUNCTION: xkb_state_key_get_consumed_mods ( state key -- u )", "EXTERN: \"C\" int xkb_state_key_get_consumed_mods( void * state, int key );", "	( state key -- )" );
	swigFunction( "c-function xkb_state_mod_index_is_consumed2 xkb_state_mod_index_is_consumed2 a u u n -- n", "FUNCTION: xkb_state_mod_index_is_consumed2 ( state key idx mode -- n )", "EXTERN: \"C\" int xkb_state_mod_index_is_consumed2( void * state, int key, int idx, int mode );", "	( state key idx mode -- )" );
	swigFunction( "c-function xkb_state_mod_index_is_consumed xkb_state_mod_index_is_consumed a u u -- n", "FUNCTION: xkb_state_mod_index_is_consumed ( state key idx -- n )", "EXTERN: \"C\" int xkb_state_mod_index_is_consumed( void * state, int key, int idx );", "	( state key idx -- )" );
	swigFunction( "c-function xkb_state_mod_mask_remove_consumed xkb_state_mod_mask_remove_consumed a u u -- u", "FUNCTION: xkb_state_mod_mask_remove_consumed ( state key mask -- u )", "EXTERN: \"C\" int xkb_state_mod_mask_remove_consumed( void * state, int key, int mask );", "	( state key mask -- )" );
	swigFunction( "c-function xkb_state_layout_name_is_active xkb_state_layout_name_is_active a s n -- n", "FUNCTION: xkb_state_layout_name_is_active ( state name type -- n )", "EXTERN: \"C\" int xkb_state_layout_name_is_active( void * state, char * name, int type );", "	( state name type -- )" );
	swigFunction( "c-function xkb_state_layout_index_is_active xkb_state_layout_index_is_active a u n -- n", "FUNCTION: xkb_state_layout_index_is_active ( state idx type -- n )", "EXTERN: \"C\" int xkb_state_layout_index_is_active( void * state, int idx, int type );", "	( state idx type -- )" );
	swigFunction( "c-function xkb_state_led_name_is_active xkb_state_led_name_is_active a s -- n", "FUNCTION: xkb_state_led_name_is_active ( state name -- n )", "EXTERN: \"C\" int xkb_state_led_name_is_active( void * state, char * name );", "	( state name -- )" );
	swigFunction( "c-function xkb_state_led_index_is_active xkb_state_led_index_is_active a u -- n", "FUNCTION: xkb_state_led_index_is_active ( state idx -- n )", "EXTERN: \"C\" int xkb_state_led_index_is_active( void * state, int idx );", "	( state idx -- )" );

	swigNewline();

	swigComment("----===< postfix >===-----\n");

	swigPrint( "end-c-library", "( none )", "( none )" );
	
	return 0;
} /* end of main */



