/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 3.0.9
 *
 * This file is not intended to be easily readable and contains a number of
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG
 * interface file instead.
 * ----------------------------------------------------------------------------- */
#include <stdio.h>
#include <string.h>
#include <stddef.h>
#include <math.h> /* required for special case floating point output */

// Do not edit below this line
// end-of-default-includes


#include <pulse/pulseaudio.h>

typedef enum{ NONE = -1, GFORTH = 0, SWIFTFORTH, VFX } SwigTargetSystem;
SwigTargetSystem swigTargetSystem = NONE;

unsigned char swigPrintStackComments = 1;

/* comments */
void swigNewline()
{
	printf( "\n" );
}

void swigComment( char *comment )
{
	printf( "\\ %s", comment );
}

/* generic print */
void swigPrint( char* gforth, char *swiftForth, char *vfx )
{
	if( swigTargetSystem == GFORTH )
		printf( "%s", gforth );
	else if( swigTargetSystem == SWIFTFORTH )
		printf( "%s", swiftForth );
	else if( swigTargetSystem == VFX )
		printf( "%s", vfx );
	printf( "\n" );
}
void swigPrintSystem( SwigTargetSystem targetSystem, char *text )
{
	if( targetSystem == swigTargetSystem )
	    printf( "%s\n", text );
}

/* constants */
void swigIntConstant( long constant, char *name )
{
	printf( "#%ld\tconstant %s\n", constant, name );
}

void swigUnsignedIntConstant( unsigned long constant, char *name )
{
	printf( "#%lu\tconstant %s\n", constant, name );
}

void swigLongConstant( long long constant, char *name )
{
	printf( "#%lld.\t2constant %s\n", constant, name );
}

void swigUnsignedLongConstant( unsigned long long constant, char *name )
{
	printf( "#%llu.\t2constant %s\n", constant, name );
}

void swigFloatConstant( double constant, char *name )
{
	char buffer[128];
	sprintf( buffer, "%f", constant );

	/* if the constant contains no exponent, add one */
	char *s;
	for( s = buffer; *s != 0; s++ )
		if( *s == 'e' || *s == 'E' )
			break;

	/* exponent found */
	if( *s != 0 )
		printf( "%s\tfconstant %s\n", buffer, name );
	/* no exponent */
	else {
		/* special class? */
		int class = fpclassify( constant );
		if( class == FP_INFINITE )
			printf( "%sInf\tfconstant %s\n", constant < 0.0f ? "-" : "+", name );
		else if( class == FP_NAN )
			printf( "NaN\tfconstant %s\n", name );
		else
			/* treat as generic float */
			printf( "%se0\tfconstant %s\n", buffer, name );
        }
}

void swigStringConstant( char* constant, char *name )
{
	char c;
	printf( ": %s s\\\" ", name );
	while(( c = *constant++ ))
	{
		switch(c)
		{
			case '\b': printf( "\\b" ); break;
			case '\n': printf( "\\n" ); break;
			case '\f': printf( "\\f" ); break;
			case '\r': printf( "\\r" ); break;
			case '\t': printf( "\\t" ); break;
			case '"' : printf( "\\q" ); break;
			default:
				if(c < 0x20)
					printf("\\x%02x", c);
				else
					printf("%c", c); break;
		}
	}
	printf(	"\" ;\n" );
}

/* structs */
void swigStructField( char *name, size_t offset, size_t size )
{
	printf( "\tdrop %zu %zu +field %s\n", offset, size, name );
}

/* functions */
void swigFunction( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	if( swigTargetSystem == GFORTH )
		printf( "%s", gforth );
	else if( swigTargetSystem == SWIFTFORTH )
		printf( "%s", swiftForth );
	else if( swigTargetSystem == VFX )
		printf( "%s", vfx );

	if( swigPrintStackComments )
		printf( "%s", stackComment );

	printf( "\n" );
}

/* function pointers */
void swigFunctionPointer( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	swigFunction( gforth, swiftForth, vfx, stackComment );
}

/* callbacks */
void swigCallback( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	swigFunction( gforth, swiftForth, vfx, stackComment );
}

void swigUsage( char **argv )
{
	fprintf( stderr, "Usage: %s [-gforth|-swiftforth|-vfx]\n", argv[0] );
}

int main( int argc, char **argv )
{
	int i;

	/* check arguments */
	for( i = 1; i < argc; i++ )
		if( strcmp( argv[i], "-gforth" ) == 0 )
			swigTargetSystem = GFORTH;
		else if( strcmp( argv[i], "-swiftforth" ) == 0 )
			swigTargetSystem = SWIFTFORTH;
		else if( strcmp( argv[i], "-vfx" ) == 0 )
			swigTargetSystem = VFX;

	if( swigTargetSystem == NONE )
	{
		fprintf( stderr, "Error: no target system specified\n" );
		swigUsage( argv );
		return 1;
	}

	/* primer */
	printf( "\\ This file has been generated using SWIG and fsi,\n"
		"\\ and is already platform dependent, search for the corresponding\n"
		"\\ fsi-file to compile it where no one has compiled it before ;)\n"
		"\\ Forth systems have their own own dynamic loader and don't need addional C-Code.\n"
		"\\ That's why this file will just print normal forth-code once compiled\n"
		"\\ and can be used directly with include or require.\n"
		"\\ As all comments are stripped during the compilation, please\n"
		"\\ insert the copyright notice of the original file here.\n"
	);



	swigNewline();

	swigComment("----===< prefix >===-----\n");

	swigPrint( "c-library pulse\ns\" pulse\" add-lib\n\\c #include <pulse/pulseaudio.h>", "( none )", "( none )" );

	swigNewline();

	swigComment("----===< int constants >===-----\n");
	#ifdef PA_CHANNELS_MAX
		swigUnsignedIntConstant( PA_CHANNELS_MAX, "PA_CHANNELS_MAX" );
	#endif
	#ifdef PA_RATE_MAX
		swigUnsignedIntConstant( PA_RATE_MAX, "PA_RATE_MAX" );
	#endif
	#ifdef PA_SAMPLE_SPEC_SNPRINT_MAX
		swigIntConstant( PA_SAMPLE_SPEC_SNPRINT_MAX, "PA_SAMPLE_SPEC_SNPRINT_MAX" );
	#endif
	#ifdef PA_BYTES_SNPRINT_MAX
		swigIntConstant( PA_BYTES_SNPRINT_MAX, "PA_BYTES_SNPRINT_MAX" );
	#endif
	#ifdef PA_FORMAT_INFO_SNPRINT_MAX
		swigIntConstant( PA_FORMAT_INFO_SNPRINT_MAX, "PA_FORMAT_INFO_SNPRINT_MAX" );
	#endif
	#ifdef PA_API_VERSION
		swigIntConstant( PA_API_VERSION, "PA_API_VERSION" );
	#endif
	#ifdef PA_PROTOCOL_VERSION
		swigIntConstant( PA_PROTOCOL_VERSION, "PA_PROTOCOL_VERSION" );
	#endif
	#ifdef PA_MAJOR
		swigIntConstant( PA_MAJOR, "PA_MAJOR" );
	#endif
	#ifdef PA_MINOR
		swigIntConstant( PA_MINOR, "PA_MINOR" );
	#endif
	#ifdef PA_MICRO
		swigIntConstant( PA_MICRO, "PA_MICRO" );
	#endif
	#ifdef PA_CHANNEL_MAP_SNPRINT_MAX
		swigIntConstant( PA_CHANNEL_MAP_SNPRINT_MAX, "PA_CHANNEL_MAP_SNPRINT_MAX" );
	#endif
	#ifdef PA_CVOLUME_SNPRINT_MAX
		swigIntConstant( PA_CVOLUME_SNPRINT_MAX, "PA_CVOLUME_SNPRINT_MAX" );
	#endif
	#ifdef PA_SW_CVOLUME_SNPRINT_DB_MAX
		swigIntConstant( PA_SW_CVOLUME_SNPRINT_DB_MAX, "PA_SW_CVOLUME_SNPRINT_DB_MAX" );
	#endif
	#ifdef PA_CVOLUME_SNPRINT_VERBOSE_MAX
		swigIntConstant( PA_CVOLUME_SNPRINT_VERBOSE_MAX, "PA_CVOLUME_SNPRINT_VERBOSE_MAX" );
	#endif
	#ifdef PA_VOLUME_SNPRINT_MAX
		swigIntConstant( PA_VOLUME_SNPRINT_MAX, "PA_VOLUME_SNPRINT_MAX" );
	#endif
	#ifdef PA_SW_VOLUME_SNPRINT_DB_MAX
		swigIntConstant( PA_SW_VOLUME_SNPRINT_DB_MAX, "PA_SW_VOLUME_SNPRINT_DB_MAX" );
	#endif
	#ifdef PA_VOLUME_SNPRINT_VERBOSE_MAX
		swigIntConstant( PA_VOLUME_SNPRINT_VERBOSE_MAX, "PA_VOLUME_SNPRINT_VERBOSE_MAX" );
	#endif

	swigNewline();

	swigComment("--------===< enums >===---------\n");
	swigIntConstant( PA_IO_EVENT_NULL, "PA_IO_EVENT_NULL" );
	swigIntConstant( PA_IO_EVENT_INPUT, "PA_IO_EVENT_INPUT" );
	swigIntConstant( PA_IO_EVENT_OUTPUT, "PA_IO_EVENT_OUTPUT" );
	swigIntConstant( PA_IO_EVENT_HANGUP, "PA_IO_EVENT_HANGUP" );
	swigIntConstant( PA_IO_EVENT_ERROR, "PA_IO_EVENT_ERROR" );
	swigIntConstant( PA_SAMPLE_U8, "PA_SAMPLE_U8" );
	swigIntConstant( PA_SAMPLE_ALAW, "PA_SAMPLE_ALAW" );
	swigIntConstant( PA_SAMPLE_ULAW, "PA_SAMPLE_ULAW" );
	swigIntConstant( PA_SAMPLE_S16LE, "PA_SAMPLE_S16LE" );
	swigIntConstant( PA_SAMPLE_S16BE, "PA_SAMPLE_S16BE" );
	swigIntConstant( PA_SAMPLE_FLOAT32LE, "PA_SAMPLE_FLOAT32LE" );
	swigIntConstant( PA_SAMPLE_FLOAT32BE, "PA_SAMPLE_FLOAT32BE" );
	swigIntConstant( PA_SAMPLE_S32LE, "PA_SAMPLE_S32LE" );
	swigIntConstant( PA_SAMPLE_S32BE, "PA_SAMPLE_S32BE" );
	swigIntConstant( PA_SAMPLE_S24LE, "PA_SAMPLE_S24LE" );
	swigIntConstant( PA_SAMPLE_S24BE, "PA_SAMPLE_S24BE" );
	swigIntConstant( PA_SAMPLE_S24_32LE, "PA_SAMPLE_S24_32LE" );
	swigIntConstant( PA_SAMPLE_S24_32BE, "PA_SAMPLE_S24_32BE" );
	swigIntConstant( PA_SAMPLE_MAX, "PA_SAMPLE_MAX" );
	swigIntConstant( PA_SAMPLE_INVALID, "PA_SAMPLE_INVALID" );
	swigIntConstant( PA_ENCODING_ANY, "PA_ENCODING_ANY" );
	swigIntConstant( PA_ENCODING_PCM, "PA_ENCODING_PCM" );
	swigIntConstant( PA_ENCODING_AC3_IEC61937, "PA_ENCODING_AC3_IEC61937" );
	swigIntConstant( PA_ENCODING_EAC3_IEC61937, "PA_ENCODING_EAC3_IEC61937" );
	swigIntConstant( PA_ENCODING_MPEG_IEC61937, "PA_ENCODING_MPEG_IEC61937" );
	swigIntConstant( PA_ENCODING_DTS_IEC61937, "PA_ENCODING_DTS_IEC61937" );
	swigIntConstant( PA_ENCODING_MPEG2_AAC_IEC61937, "PA_ENCODING_MPEG2_AAC_IEC61937" );
	swigIntConstant( PA_ENCODING_TRUEHD_IEC61937, "PA_ENCODING_TRUEHD_IEC61937" );
	swigIntConstant( PA_ENCODING_DTSHD_IEC61937, "PA_ENCODING_DTSHD_IEC61937" );
	swigIntConstant( PA_ENCODING_MAX, "PA_ENCODING_MAX" );
	swigIntConstant( PA_ENCODING_INVALID, "PA_ENCODING_INVALID" );
	swigIntConstant( PA_PROP_TYPE_INT, "PA_PROP_TYPE_INT" );
	swigIntConstant( PA_PROP_TYPE_INT_RANGE, "PA_PROP_TYPE_INT_RANGE" );
	swigIntConstant( PA_PROP_TYPE_INT_ARRAY, "PA_PROP_TYPE_INT_ARRAY" );
	swigIntConstant( PA_PROP_TYPE_STRING, "PA_PROP_TYPE_STRING" );
	swigIntConstant( PA_PROP_TYPE_STRING_ARRAY, "PA_PROP_TYPE_STRING_ARRAY" );
	swigIntConstant( PA_PROP_TYPE_INVALID, "PA_PROP_TYPE_INVALID" );
	swigIntConstant( PA_CONTEXT_UNCONNECTED, "PA_CONTEXT_UNCONNECTED" );
	swigIntConstant( PA_CONTEXT_CONNECTING, "PA_CONTEXT_CONNECTING" );
	swigIntConstant( PA_CONTEXT_AUTHORIZING, "PA_CONTEXT_AUTHORIZING" );
	swigIntConstant( PA_CONTEXT_SETTING_NAME, "PA_CONTEXT_SETTING_NAME" );
	swigIntConstant( PA_CONTEXT_READY, "PA_CONTEXT_READY" );
	swigIntConstant( PA_CONTEXT_FAILED, "PA_CONTEXT_FAILED" );
	swigIntConstant( PA_CONTEXT_TERMINATED, "PA_CONTEXT_TERMINATED" );
	swigIntConstant( PA_STREAM_UNCONNECTED, "PA_STREAM_UNCONNECTED" );
	swigIntConstant( PA_STREAM_CREATING, "PA_STREAM_CREATING" );
	swigIntConstant( PA_STREAM_READY, "PA_STREAM_READY" );
	swigIntConstant( PA_STREAM_FAILED, "PA_STREAM_FAILED" );
	swigIntConstant( PA_STREAM_TERMINATED, "PA_STREAM_TERMINATED" );
	swigIntConstant( PA_OPERATION_RUNNING, "PA_OPERATION_RUNNING" );
	swigIntConstant( PA_OPERATION_DONE, "PA_OPERATION_DONE" );
	swigIntConstant( PA_OPERATION_CANCELLED, "PA_OPERATION_CANCELLED" );
	swigIntConstant( PA_CONTEXT_NOFLAGS, "PA_CONTEXT_NOFLAGS" );
	swigIntConstant( PA_CONTEXT_NOAUTOSPAWN, "PA_CONTEXT_NOAUTOSPAWN" );
	swigIntConstant( PA_CONTEXT_NOFAIL, "PA_CONTEXT_NOFAIL" );
	swigIntConstant( PA_DIRECTION_OUTPUT, "PA_DIRECTION_OUTPUT" );
	swigIntConstant( PA_DIRECTION_INPUT, "PA_DIRECTION_INPUT" );
	swigIntConstant( PA_DEVICE_TYPE_SINK, "PA_DEVICE_TYPE_SINK" );
	swigIntConstant( PA_DEVICE_TYPE_SOURCE, "PA_DEVICE_TYPE_SOURCE" );
	swigIntConstant( PA_STREAM_NODIRECTION, "PA_STREAM_NODIRECTION" );
	swigIntConstant( PA_STREAM_PLAYBACK, "PA_STREAM_PLAYBACK" );
	swigIntConstant( PA_STREAM_RECORD, "PA_STREAM_RECORD" );
	swigIntConstant( PA_STREAM_UPLOAD, "PA_STREAM_UPLOAD" );
	swigIntConstant( PA_STREAM_NOFLAGS, "PA_STREAM_NOFLAGS" );
	swigIntConstant( PA_STREAM_START_CORKED, "PA_STREAM_START_CORKED" );
	swigIntConstant( PA_STREAM_INTERPOLATE_TIMING, "PA_STREAM_INTERPOLATE_TIMING" );
	swigIntConstant( PA_STREAM_NOT_MONOTONIC, "PA_STREAM_NOT_MONOTONIC" );
	swigIntConstant( PA_STREAM_AUTO_TIMING_UPDATE, "PA_STREAM_AUTO_TIMING_UPDATE" );
	swigIntConstant( PA_STREAM_NO_REMAP_CHANNELS, "PA_STREAM_NO_REMAP_CHANNELS" );
	swigIntConstant( PA_STREAM_NO_REMIX_CHANNELS, "PA_STREAM_NO_REMIX_CHANNELS" );
	swigIntConstant( PA_STREAM_FIX_FORMAT, "PA_STREAM_FIX_FORMAT" );
	swigIntConstant( PA_STREAM_FIX_RATE, "PA_STREAM_FIX_RATE" );
	swigIntConstant( PA_STREAM_FIX_CHANNELS, "PA_STREAM_FIX_CHANNELS" );
	swigIntConstant( PA_STREAM_DONT_MOVE, "PA_STREAM_DONT_MOVE" );
	swigIntConstant( PA_STREAM_VARIABLE_RATE, "PA_STREAM_VARIABLE_RATE" );
	swigIntConstant( PA_STREAM_PEAK_DETECT, "PA_STREAM_PEAK_DETECT" );
	swigIntConstant( PA_STREAM_START_MUTED, "PA_STREAM_START_MUTED" );
	swigIntConstant( PA_STREAM_ADJUST_LATENCY, "PA_STREAM_ADJUST_LATENCY" );
	swigIntConstant( PA_STREAM_EARLY_REQUESTS, "PA_STREAM_EARLY_REQUESTS" );
	swigIntConstant( PA_STREAM_DONT_INHIBIT_AUTO_SUSPEND, "PA_STREAM_DONT_INHIBIT_AUTO_SUSPEND" );
	swigIntConstant( PA_STREAM_START_UNMUTED, "PA_STREAM_START_UNMUTED" );
	swigIntConstant( PA_STREAM_FAIL_ON_SUSPEND, "PA_STREAM_FAIL_ON_SUSPEND" );
	swigIntConstant( PA_STREAM_RELATIVE_VOLUME, "PA_STREAM_RELATIVE_VOLUME" );
	swigIntConstant( PA_STREAM_PASSTHROUGH, "PA_STREAM_PASSTHROUGH" );
	swigIntConstant( PA_OK, "PA_OK" );
	swigIntConstant( PA_ERR_ACCESS, "PA_ERR_ACCESS" );
	swigIntConstant( PA_ERR_COMMAND, "PA_ERR_COMMAND" );
	swigIntConstant( PA_ERR_INVALID, "PA_ERR_INVALID" );
	swigIntConstant( PA_ERR_EXIST, "PA_ERR_EXIST" );
	swigIntConstant( PA_ERR_NOENTITY, "PA_ERR_NOENTITY" );
	swigIntConstant( PA_ERR_CONNECTIONREFUSED, "PA_ERR_CONNECTIONREFUSED" );
	swigIntConstant( PA_ERR_PROTOCOL, "PA_ERR_PROTOCOL" );
	swigIntConstant( PA_ERR_TIMEOUT, "PA_ERR_TIMEOUT" );
	swigIntConstant( PA_ERR_AUTHKEY, "PA_ERR_AUTHKEY" );
	swigIntConstant( PA_ERR_INTERNAL, "PA_ERR_INTERNAL" );
	swigIntConstant( PA_ERR_CONNECTIONTERMINATED, "PA_ERR_CONNECTIONTERMINATED" );
	swigIntConstant( PA_ERR_KILLED, "PA_ERR_KILLED" );
	swigIntConstant( PA_ERR_INVALIDSERVER, "PA_ERR_INVALIDSERVER" );
	swigIntConstant( PA_ERR_MODINITFAILED, "PA_ERR_MODINITFAILED" );
	swigIntConstant( PA_ERR_BADSTATE, "PA_ERR_BADSTATE" );
	swigIntConstant( PA_ERR_NODATA, "PA_ERR_NODATA" );
	swigIntConstant( PA_ERR_VERSION, "PA_ERR_VERSION" );
	swigIntConstant( PA_ERR_TOOLARGE, "PA_ERR_TOOLARGE" );
	swigIntConstant( PA_ERR_NOTSUPPORTED, "PA_ERR_NOTSUPPORTED" );
	swigIntConstant( PA_ERR_UNKNOWN, "PA_ERR_UNKNOWN" );
	swigIntConstant( PA_ERR_NOEXTENSION, "PA_ERR_NOEXTENSION" );
	swigIntConstant( PA_ERR_OBSOLETE, "PA_ERR_OBSOLETE" );
	swigIntConstant( PA_ERR_NOTIMPLEMENTED, "PA_ERR_NOTIMPLEMENTED" );
	swigIntConstant( PA_ERR_FORKED, "PA_ERR_FORKED" );
	swigIntConstant( PA_ERR_IO, "PA_ERR_IO" );
	swigIntConstant( PA_ERR_BUSY, "PA_ERR_BUSY" );
	swigIntConstant( PA_ERR_MAX, "PA_ERR_MAX" );
	swigIntConstant( PA_SUBSCRIPTION_MASK_NULL, "PA_SUBSCRIPTION_MASK_NULL" );
	swigIntConstant( PA_SUBSCRIPTION_MASK_SINK, "PA_SUBSCRIPTION_MASK_SINK" );
	swigIntConstant( PA_SUBSCRIPTION_MASK_SOURCE, "PA_SUBSCRIPTION_MASK_SOURCE" );
	swigIntConstant( PA_SUBSCRIPTION_MASK_SINK_INPUT, "PA_SUBSCRIPTION_MASK_SINK_INPUT" );
	swigIntConstant( PA_SUBSCRIPTION_MASK_SOURCE_OUTPUT, "PA_SUBSCRIPTION_MASK_SOURCE_OUTPUT" );
	swigIntConstant( PA_SUBSCRIPTION_MASK_MODULE, "PA_SUBSCRIPTION_MASK_MODULE" );
	swigIntConstant( PA_SUBSCRIPTION_MASK_CLIENT, "PA_SUBSCRIPTION_MASK_CLIENT" );
	swigIntConstant( PA_SUBSCRIPTION_MASK_SAMPLE_CACHE, "PA_SUBSCRIPTION_MASK_SAMPLE_CACHE" );
	swigIntConstant( PA_SUBSCRIPTION_MASK_SERVER, "PA_SUBSCRIPTION_MASK_SERVER" );
	swigIntConstant( PA_SUBSCRIPTION_MASK_AUTOLOAD, "PA_SUBSCRIPTION_MASK_AUTOLOAD" );
	swigIntConstant( PA_SUBSCRIPTION_MASK_CARD, "PA_SUBSCRIPTION_MASK_CARD" );
	swigIntConstant( PA_SUBSCRIPTION_MASK_ALL, "PA_SUBSCRIPTION_MASK_ALL" );
	swigIntConstant( PA_SUBSCRIPTION_EVENT_SINK, "PA_SUBSCRIPTION_EVENT_SINK" );
	swigIntConstant( PA_SUBSCRIPTION_EVENT_SOURCE, "PA_SUBSCRIPTION_EVENT_SOURCE" );
	swigIntConstant( PA_SUBSCRIPTION_EVENT_SINK_INPUT, "PA_SUBSCRIPTION_EVENT_SINK_INPUT" );
	swigIntConstant( PA_SUBSCRIPTION_EVENT_SOURCE_OUTPUT, "PA_SUBSCRIPTION_EVENT_SOURCE_OUTPUT" );
	swigIntConstant( PA_SUBSCRIPTION_EVENT_MODULE, "PA_SUBSCRIPTION_EVENT_MODULE" );
	swigIntConstant( PA_SUBSCRIPTION_EVENT_CLIENT, "PA_SUBSCRIPTION_EVENT_CLIENT" );
	swigIntConstant( PA_SUBSCRIPTION_EVENT_SAMPLE_CACHE, "PA_SUBSCRIPTION_EVENT_SAMPLE_CACHE" );
	swigIntConstant( PA_SUBSCRIPTION_EVENT_SERVER, "PA_SUBSCRIPTION_EVENT_SERVER" );
	swigIntConstant( PA_SUBSCRIPTION_EVENT_AUTOLOAD, "PA_SUBSCRIPTION_EVENT_AUTOLOAD" );
	swigIntConstant( PA_SUBSCRIPTION_EVENT_CARD, "PA_SUBSCRIPTION_EVENT_CARD" );
	swigIntConstant( PA_SUBSCRIPTION_EVENT_FACILITY_MASK, "PA_SUBSCRIPTION_EVENT_FACILITY_MASK" );
	swigIntConstant( PA_SUBSCRIPTION_EVENT_NEW, "PA_SUBSCRIPTION_EVENT_NEW" );
	swigIntConstant( PA_SUBSCRIPTION_EVENT_CHANGE, "PA_SUBSCRIPTION_EVENT_CHANGE" );
	swigIntConstant( PA_SUBSCRIPTION_EVENT_REMOVE, "PA_SUBSCRIPTION_EVENT_REMOVE" );
	swigIntConstant( PA_SUBSCRIPTION_EVENT_TYPE_MASK, "PA_SUBSCRIPTION_EVENT_TYPE_MASK" );
	swigIntConstant( PA_SEEK_RELATIVE, "PA_SEEK_RELATIVE" );
	swigIntConstant( PA_SEEK_ABSOLUTE, "PA_SEEK_ABSOLUTE" );
	swigIntConstant( PA_SEEK_RELATIVE_ON_READ, "PA_SEEK_RELATIVE_ON_READ" );
	swigIntConstant( PA_SEEK_RELATIVE_END, "PA_SEEK_RELATIVE_END" );
	swigIntConstant( PA_SINK_NOFLAGS, "PA_SINK_NOFLAGS" );
	swigIntConstant( PA_SINK_HW_VOLUME_CTRL, "PA_SINK_HW_VOLUME_CTRL" );
	swigIntConstant( PA_SINK_LATENCY, "PA_SINK_LATENCY" );
	swigIntConstant( PA_SINK_HARDWARE, "PA_SINK_HARDWARE" );
	swigIntConstant( PA_SINK_NETWORK, "PA_SINK_NETWORK" );
	swigIntConstant( PA_SINK_HW_MUTE_CTRL, "PA_SINK_HW_MUTE_CTRL" );
	swigIntConstant( PA_SINK_DECIBEL_VOLUME, "PA_SINK_DECIBEL_VOLUME" );
	swigIntConstant( PA_SINK_FLAT_VOLUME, "PA_SINK_FLAT_VOLUME" );
	swigIntConstant( PA_SINK_DYNAMIC_LATENCY, "PA_SINK_DYNAMIC_LATENCY" );
	swigIntConstant( PA_SINK_SET_FORMATS, "PA_SINK_SET_FORMATS" );
	swigIntConstant( PA_SINK_INVALID_STATE, "PA_SINK_INVALID_STATE" );
	swigIntConstant( PA_SINK_RUNNING, "PA_SINK_RUNNING" );
	swigIntConstant( PA_SINK_IDLE, "PA_SINK_IDLE" );
	swigIntConstant( PA_SINK_SUSPENDED, "PA_SINK_SUSPENDED" );
	swigIntConstant( PA_SINK_INIT, "PA_SINK_INIT" );
	swigIntConstant( PA_SINK_UNLINKED, "PA_SINK_UNLINKED" );
	swigIntConstant( PA_SOURCE_NOFLAGS, "PA_SOURCE_NOFLAGS" );
	swigIntConstant( PA_SOURCE_HW_VOLUME_CTRL, "PA_SOURCE_HW_VOLUME_CTRL" );
	swigIntConstant( PA_SOURCE_LATENCY, "PA_SOURCE_LATENCY" );
	swigIntConstant( PA_SOURCE_HARDWARE, "PA_SOURCE_HARDWARE" );
	swigIntConstant( PA_SOURCE_NETWORK, "PA_SOURCE_NETWORK" );
	swigIntConstant( PA_SOURCE_HW_MUTE_CTRL, "PA_SOURCE_HW_MUTE_CTRL" );
	swigIntConstant( PA_SOURCE_DECIBEL_VOLUME, "PA_SOURCE_DECIBEL_VOLUME" );
	swigIntConstant( PA_SOURCE_DYNAMIC_LATENCY, "PA_SOURCE_DYNAMIC_LATENCY" );
	swigIntConstant( PA_SOURCE_FLAT_VOLUME, "PA_SOURCE_FLAT_VOLUME" );
	swigIntConstant( PA_SOURCE_INVALID_STATE, "PA_SOURCE_INVALID_STATE" );
	swigIntConstant( PA_SOURCE_RUNNING, "PA_SOURCE_RUNNING" );
	swigIntConstant( PA_SOURCE_IDLE, "PA_SOURCE_IDLE" );
	swigIntConstant( PA_SOURCE_SUSPENDED, "PA_SOURCE_SUSPENDED" );
	swigIntConstant( PA_SOURCE_INIT, "PA_SOURCE_INIT" );
	swigIntConstant( PA_SOURCE_UNLINKED, "PA_SOURCE_UNLINKED" );
	swigIntConstant( PA_PORT_AVAILABLE_UNKNOWN, "PA_PORT_AVAILABLE_UNKNOWN" );
	swigIntConstant( PA_PORT_AVAILABLE_NO, "PA_PORT_AVAILABLE_NO" );
	swigIntConstant( PA_PORT_AVAILABLE_YES, "PA_PORT_AVAILABLE_YES" );
	swigIntConstant( PA_DEVICE_PORT_TYPE_UNKNOWN, "PA_DEVICE_PORT_TYPE_UNKNOWN" );
	swigIntConstant( PA_DEVICE_PORT_TYPE_AUX, "PA_DEVICE_PORT_TYPE_AUX" );
	swigIntConstant( PA_DEVICE_PORT_TYPE_SPEAKER, "PA_DEVICE_PORT_TYPE_SPEAKER" );
	swigIntConstant( PA_DEVICE_PORT_TYPE_HEADPHONES, "PA_DEVICE_PORT_TYPE_HEADPHONES" );
	swigIntConstant( PA_DEVICE_PORT_TYPE_LINE, "PA_DEVICE_PORT_TYPE_LINE" );
	swigIntConstant( PA_DEVICE_PORT_TYPE_MIC, "PA_DEVICE_PORT_TYPE_MIC" );
	swigIntConstant( PA_DEVICE_PORT_TYPE_HEADSET, "PA_DEVICE_PORT_TYPE_HEADSET" );
	swigIntConstant( PA_DEVICE_PORT_TYPE_HANDSET, "PA_DEVICE_PORT_TYPE_HANDSET" );
	swigIntConstant( PA_DEVICE_PORT_TYPE_EARPIECE, "PA_DEVICE_PORT_TYPE_EARPIECE" );
	swigIntConstant( PA_DEVICE_PORT_TYPE_SPDIF, "PA_DEVICE_PORT_TYPE_SPDIF" );
	swigIntConstant( PA_DEVICE_PORT_TYPE_HDMI, "PA_DEVICE_PORT_TYPE_HDMI" );
	swigIntConstant( PA_DEVICE_PORT_TYPE_TV, "PA_DEVICE_PORT_TYPE_TV" );
	swigIntConstant( PA_DEVICE_PORT_TYPE_RADIO, "PA_DEVICE_PORT_TYPE_RADIO" );
	swigIntConstant( PA_DEVICE_PORT_TYPE_VIDEO, "PA_DEVICE_PORT_TYPE_VIDEO" );
	swigIntConstant( PA_DEVICE_PORT_TYPE_USB, "PA_DEVICE_PORT_TYPE_USB" );
	swigIntConstant( PA_DEVICE_PORT_TYPE_BLUETOOTH, "PA_DEVICE_PORT_TYPE_BLUETOOTH" );
	swigIntConstant( PA_DEVICE_PORT_TYPE_PORTABLE, "PA_DEVICE_PORT_TYPE_PORTABLE" );
	swigIntConstant( PA_DEVICE_PORT_TYPE_HANDSFREE, "PA_DEVICE_PORT_TYPE_HANDSFREE" );
	swigIntConstant( PA_DEVICE_PORT_TYPE_CAR, "PA_DEVICE_PORT_TYPE_CAR" );
	swigIntConstant( PA_DEVICE_PORT_TYPE_HIFI, "PA_DEVICE_PORT_TYPE_HIFI" );
	swigIntConstant( PA_DEVICE_PORT_TYPE_PHONE, "PA_DEVICE_PORT_TYPE_PHONE" );
	swigIntConstant( PA_DEVICE_PORT_TYPE_NETWORK, "PA_DEVICE_PORT_TYPE_NETWORK" );
	swigIntConstant( PA_DEVICE_PORT_TYPE_ANALOG, "PA_DEVICE_PORT_TYPE_ANALOG" );
	swigIntConstant( PA_AUTOLOAD_SINK, "PA_AUTOLOAD_SINK" );
	swigIntConstant( PA_AUTOLOAD_SOURCE, "PA_AUTOLOAD_SOURCE" );
	swigIntConstant( PA_CHANNEL_POSITION_INVALID, "PA_CHANNEL_POSITION_INVALID" );
	swigIntConstant( PA_CHANNEL_POSITION_MONO, "PA_CHANNEL_POSITION_MONO" );
	swigIntConstant( PA_CHANNEL_POSITION_FRONT_LEFT, "PA_CHANNEL_POSITION_FRONT_LEFT" );
	swigIntConstant( PA_CHANNEL_POSITION_FRONT_RIGHT, "PA_CHANNEL_POSITION_FRONT_RIGHT" );
	swigIntConstant( PA_CHANNEL_POSITION_FRONT_CENTER, "PA_CHANNEL_POSITION_FRONT_CENTER" );
	swigIntConstant( PA_CHANNEL_POSITION_LEFT, "PA_CHANNEL_POSITION_LEFT" );
	swigIntConstant( PA_CHANNEL_POSITION_RIGHT, "PA_CHANNEL_POSITION_RIGHT" );
	swigIntConstant( PA_CHANNEL_POSITION_CENTER, "PA_CHANNEL_POSITION_CENTER" );
	swigIntConstant( PA_CHANNEL_POSITION_REAR_CENTER, "PA_CHANNEL_POSITION_REAR_CENTER" );
	swigIntConstant( PA_CHANNEL_POSITION_REAR_LEFT, "PA_CHANNEL_POSITION_REAR_LEFT" );
	swigIntConstant( PA_CHANNEL_POSITION_REAR_RIGHT, "PA_CHANNEL_POSITION_REAR_RIGHT" );
	swigIntConstant( PA_CHANNEL_POSITION_LFE, "PA_CHANNEL_POSITION_LFE" );
	swigIntConstant( PA_CHANNEL_POSITION_SUBWOOFER, "PA_CHANNEL_POSITION_SUBWOOFER" );
	swigIntConstant( PA_CHANNEL_POSITION_FRONT_LEFT_OF_CENTER, "PA_CHANNEL_POSITION_FRONT_LEFT_OF_CENTER" );
	swigIntConstant( PA_CHANNEL_POSITION_FRONT_RIGHT_OF_CENTER, "PA_CHANNEL_POSITION_FRONT_RIGHT_OF_CENTER" );
	swigIntConstant( PA_CHANNEL_POSITION_SIDE_LEFT, "PA_CHANNEL_POSITION_SIDE_LEFT" );
	swigIntConstant( PA_CHANNEL_POSITION_SIDE_RIGHT, "PA_CHANNEL_POSITION_SIDE_RIGHT" );
	swigIntConstant( PA_CHANNEL_POSITION_AUX0, "PA_CHANNEL_POSITION_AUX0" );
	swigIntConstant( PA_CHANNEL_POSITION_AUX1, "PA_CHANNEL_POSITION_AUX1" );
	swigIntConstant( PA_CHANNEL_POSITION_AUX2, "PA_CHANNEL_POSITION_AUX2" );
	swigIntConstant( PA_CHANNEL_POSITION_AUX3, "PA_CHANNEL_POSITION_AUX3" );
	swigIntConstant( PA_CHANNEL_POSITION_AUX4, "PA_CHANNEL_POSITION_AUX4" );
	swigIntConstant( PA_CHANNEL_POSITION_AUX5, "PA_CHANNEL_POSITION_AUX5" );
	swigIntConstant( PA_CHANNEL_POSITION_AUX6, "PA_CHANNEL_POSITION_AUX6" );
	swigIntConstant( PA_CHANNEL_POSITION_AUX7, "PA_CHANNEL_POSITION_AUX7" );
	swigIntConstant( PA_CHANNEL_POSITION_AUX8, "PA_CHANNEL_POSITION_AUX8" );
	swigIntConstant( PA_CHANNEL_POSITION_AUX9, "PA_CHANNEL_POSITION_AUX9" );
	swigIntConstant( PA_CHANNEL_POSITION_AUX10, "PA_CHANNEL_POSITION_AUX10" );
	swigIntConstant( PA_CHANNEL_POSITION_AUX11, "PA_CHANNEL_POSITION_AUX11" );
	swigIntConstant( PA_CHANNEL_POSITION_AUX12, "PA_CHANNEL_POSITION_AUX12" );
	swigIntConstant( PA_CHANNEL_POSITION_AUX13, "PA_CHANNEL_POSITION_AUX13" );
	swigIntConstant( PA_CHANNEL_POSITION_AUX14, "PA_CHANNEL_POSITION_AUX14" );
	swigIntConstant( PA_CHANNEL_POSITION_AUX15, "PA_CHANNEL_POSITION_AUX15" );
	swigIntConstant( PA_CHANNEL_POSITION_AUX16, "PA_CHANNEL_POSITION_AUX16" );
	swigIntConstant( PA_CHANNEL_POSITION_AUX17, "PA_CHANNEL_POSITION_AUX17" );
	swigIntConstant( PA_CHANNEL_POSITION_AUX18, "PA_CHANNEL_POSITION_AUX18" );
	swigIntConstant( PA_CHANNEL_POSITION_AUX19, "PA_CHANNEL_POSITION_AUX19" );
	swigIntConstant( PA_CHANNEL_POSITION_AUX20, "PA_CHANNEL_POSITION_AUX20" );
	swigIntConstant( PA_CHANNEL_POSITION_AUX21, "PA_CHANNEL_POSITION_AUX21" );
	swigIntConstant( PA_CHANNEL_POSITION_AUX22, "PA_CHANNEL_POSITION_AUX22" );
	swigIntConstant( PA_CHANNEL_POSITION_AUX23, "PA_CHANNEL_POSITION_AUX23" );
	swigIntConstant( PA_CHANNEL_POSITION_AUX24, "PA_CHANNEL_POSITION_AUX24" );
	swigIntConstant( PA_CHANNEL_POSITION_AUX25, "PA_CHANNEL_POSITION_AUX25" );
	swigIntConstant( PA_CHANNEL_POSITION_AUX26, "PA_CHANNEL_POSITION_AUX26" );
	swigIntConstant( PA_CHANNEL_POSITION_AUX27, "PA_CHANNEL_POSITION_AUX27" );
	swigIntConstant( PA_CHANNEL_POSITION_AUX28, "PA_CHANNEL_POSITION_AUX28" );
	swigIntConstant( PA_CHANNEL_POSITION_AUX29, "PA_CHANNEL_POSITION_AUX29" );
	swigIntConstant( PA_CHANNEL_POSITION_AUX30, "PA_CHANNEL_POSITION_AUX30" );
	swigIntConstant( PA_CHANNEL_POSITION_AUX31, "PA_CHANNEL_POSITION_AUX31" );
	swigIntConstant( PA_CHANNEL_POSITION_TOP_CENTER, "PA_CHANNEL_POSITION_TOP_CENTER" );
	swigIntConstant( PA_CHANNEL_POSITION_TOP_FRONT_LEFT, "PA_CHANNEL_POSITION_TOP_FRONT_LEFT" );
	swigIntConstant( PA_CHANNEL_POSITION_TOP_FRONT_RIGHT, "PA_CHANNEL_POSITION_TOP_FRONT_RIGHT" );
	swigIntConstant( PA_CHANNEL_POSITION_TOP_FRONT_CENTER, "PA_CHANNEL_POSITION_TOP_FRONT_CENTER" );
	swigIntConstant( PA_CHANNEL_POSITION_TOP_REAR_LEFT, "PA_CHANNEL_POSITION_TOP_REAR_LEFT" );
	swigIntConstant( PA_CHANNEL_POSITION_TOP_REAR_RIGHT, "PA_CHANNEL_POSITION_TOP_REAR_RIGHT" );
	swigIntConstant( PA_CHANNEL_POSITION_TOP_REAR_CENTER, "PA_CHANNEL_POSITION_TOP_REAR_CENTER" );
	swigIntConstant( PA_CHANNEL_POSITION_MAX, "PA_CHANNEL_POSITION_MAX" );
	swigIntConstant( PA_CHANNEL_MAP_AIFF, "PA_CHANNEL_MAP_AIFF" );
	swigIntConstant( PA_CHANNEL_MAP_ALSA, "PA_CHANNEL_MAP_ALSA" );
	swigIntConstant( PA_CHANNEL_MAP_AUX, "PA_CHANNEL_MAP_AUX" );
	swigIntConstant( PA_CHANNEL_MAP_WAVEEX, "PA_CHANNEL_MAP_WAVEEX" );
	swigIntConstant( PA_CHANNEL_MAP_OSS, "PA_CHANNEL_MAP_OSS" );
	swigIntConstant( PA_CHANNEL_MAP_DEF_MAX, "PA_CHANNEL_MAP_DEF_MAX" );
	swigIntConstant( PA_CHANNEL_MAP_DEFAULT, "PA_CHANNEL_MAP_DEFAULT" );
	swigIntConstant( PA_UPDATE_SET, "PA_UPDATE_SET" );
	swigIntConstant( PA_UPDATE_MERGE, "PA_UPDATE_MERGE" );
	swigIntConstant( PA_UPDATE_REPLACE, "PA_UPDATE_REPLACE" );

	swigNewline();

	swigComment("-------===< structs >===--------\n");

	swigComment("struct pa_mainloop_api\n");
	printf( "begin-structure pa_mainloop_api\n" );
	swigStructField( "pa_mainloop_api-io_free", offsetof( struct pa_mainloop_api, io_free ), sizeof( void (*)(pa_io_event *) ) );
	swigStructField( "pa_mainloop_api-time_restart", offsetof( struct pa_mainloop_api, time_restart ), sizeof( void (*)(pa_time_event *,struct timeval const *) ) );
	swigStructField( "pa_mainloop_api-defer_free", offsetof( struct pa_mainloop_api, defer_free ), sizeof( void (*)(pa_defer_event *) ) );
	swigStructField( "pa_mainloop_api-io_new", offsetof( struct pa_mainloop_api, io_new ), sizeof( pa_io_event *(*)(pa_mainloop_api *,int,pa_io_event_flags_t,pa_io_event_cb_t,void *) ) );
	swigStructField( "pa_mainloop_api-userdata", offsetof( struct pa_mainloop_api, userdata ), sizeof( void * ) );
	swigStructField( "pa_mainloop_api-defer_enable", offsetof( struct pa_mainloop_api, defer_enable ), sizeof( void (*)(pa_defer_event *,int) ) );
	swigStructField( "pa_mainloop_api-io_enable", offsetof( struct pa_mainloop_api, io_enable ), sizeof( void (*)(pa_io_event *,pa_io_event_flags_t) ) );
	swigStructField( "pa_mainloop_api-quit", offsetof( struct pa_mainloop_api, quit ), sizeof( void (*)(pa_mainloop_api *,int) ) );
	swigStructField( "pa_mainloop_api-defer_set_destroy", offsetof( struct pa_mainloop_api, defer_set_destroy ), sizeof( void (*)(pa_defer_event *,pa_defer_event_destroy_cb_t) ) );
	swigStructField( "pa_mainloop_api-time_set_destroy", offsetof( struct pa_mainloop_api, time_set_destroy ), sizeof( void (*)(pa_time_event *,pa_time_event_destroy_cb_t) ) );
	swigStructField( "pa_mainloop_api-time_new", offsetof( struct pa_mainloop_api, time_new ), sizeof( pa_time_event *(*)(pa_mainloop_api *,struct timeval const *,pa_time_event_cb_t,void *) ) );
	swigStructField( "pa_mainloop_api-io_set_destroy", offsetof( struct pa_mainloop_api, io_set_destroy ), sizeof( void (*)(pa_io_event *,pa_io_event_destroy_cb_t) ) );
	swigStructField( "pa_mainloop_api-time_free", offsetof( struct pa_mainloop_api, time_free ), sizeof( void (*)(pa_time_event *) ) );
	swigStructField( "pa_mainloop_api-defer_new", offsetof( struct pa_mainloop_api, defer_new ), sizeof( pa_defer_event *(*)(pa_mainloop_api *,pa_defer_event_cb_t,void *) ) );
	printf( "drop %zu end-structure\n", sizeof( struct pa_mainloop_api ) );

	swigComment("struct pa_sample_spec\n");
	printf( "begin-structure pa_sample_spec\n" );
	swigStructField( "pa_sample_spec-channels", offsetof( struct pa_sample_spec, channels ), sizeof( uint8_t ) );
	swigStructField( "pa_sample_spec-format", offsetof( struct pa_sample_spec, format ), sizeof( pa_sample_format_t ) );
	swigStructField( "pa_sample_spec-rate", offsetof( struct pa_sample_spec, rate ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct pa_sample_spec ) );

	swigComment("struct pa_format_info\n");
	printf( "begin-structure pa_format_info\n" );
	swigStructField( "pa_format_info-encoding", offsetof( struct pa_format_info, encoding ), sizeof( pa_encoding_t ) );
	swigStructField( "pa_format_info-plist", offsetof( struct pa_format_info, plist ), sizeof( pa_proplist * ) );
	printf( "drop %zu end-structure\n", sizeof( struct pa_format_info ) );

	swigComment("struct pa_buffer_attr\n");
	printf( "begin-structure pa_buffer_attr\n" );
	swigStructField( "pa_buffer_attr-minreq", offsetof( struct pa_buffer_attr, minreq ), sizeof( uint32_t ) );
	swigStructField( "pa_buffer_attr-maxlength", offsetof( struct pa_buffer_attr, maxlength ), sizeof( uint32_t ) );
	swigStructField( "pa_buffer_attr-tlength", offsetof( struct pa_buffer_attr, tlength ), sizeof( uint32_t ) );
	swigStructField( "pa_buffer_attr-prebuf", offsetof( struct pa_buffer_attr, prebuf ), sizeof( uint32_t ) );
	swigStructField( "pa_buffer_attr-fragsize", offsetof( struct pa_buffer_attr, fragsize ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct pa_buffer_attr ) );

	swigComment("struct pa_timing_info\n");
	printf( "begin-structure pa_timing_info\n" );
	swigStructField( "pa_timing_info-sink_usec", offsetof( struct pa_timing_info, sink_usec ), sizeof( pa_usec_t ) );
	swigStructField( "pa_timing_info-read_index", offsetof( struct pa_timing_info, read_index ), sizeof( int64_t ) );
	swigStructField( "pa_timing_info-configured_sink_usec", offsetof( struct pa_timing_info, configured_sink_usec ), sizeof( pa_usec_t ) );
	swigStructField( "pa_timing_info-source_usec", offsetof( struct pa_timing_info, source_usec ), sizeof( pa_usec_t ) );
	swigStructField( "pa_timing_info-configured_source_usec", offsetof( struct pa_timing_info, configured_source_usec ), sizeof( pa_usec_t ) );
	swigStructField( "pa_timing_info-synchronized_clocks", offsetof( struct pa_timing_info, synchronized_clocks ), sizeof( int ) );
	swigStructField( "pa_timing_info-since_underrun", offsetof( struct pa_timing_info, since_underrun ), sizeof( int64_t ) );
	swigStructField( "pa_timing_info-transport_usec", offsetof( struct pa_timing_info, transport_usec ), sizeof( pa_usec_t ) );
	swigStructField( "pa_timing_info-timestamp", offsetof( struct pa_timing_info, timestamp ), sizeof( struct timeval ) );
	swigStructField( "pa_timing_info-write_index_corrupt", offsetof( struct pa_timing_info, write_index_corrupt ), sizeof( int ) );
	swigStructField( "pa_timing_info-read_index_corrupt", offsetof( struct pa_timing_info, read_index_corrupt ), sizeof( int ) );
	swigStructField( "pa_timing_info-playing", offsetof( struct pa_timing_info, playing ), sizeof( int ) );
	swigStructField( "pa_timing_info-write_index", offsetof( struct pa_timing_info, write_index ), sizeof( int64_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct pa_timing_info ) );

	swigComment("struct pa_spawn_api\n");
	printf( "begin-structure pa_spawn_api\n" );
	swigStructField( "pa_spawn_api-postfork", offsetof( struct pa_spawn_api, postfork ), sizeof( void (*)(void) ) );
	swigStructField( "pa_spawn_api-atfork", offsetof( struct pa_spawn_api, atfork ), sizeof( void (*)(void) ) );
	swigStructField( "pa_spawn_api-prefork", offsetof( struct pa_spawn_api, prefork ), sizeof( void (*)(void) ) );
	printf( "drop %zu end-structure\n", sizeof( struct pa_spawn_api ) );

	swigComment("struct pa_sink_port_info\n");
	printf( "begin-structure pa_sink_port_info\n" );
	swigStructField( "pa_sink_port_info-priority", offsetof( struct pa_sink_port_info, priority ), sizeof( uint32_t ) );
	swigStructField( "pa_sink_port_info-name", offsetof( struct pa_sink_port_info, name ), sizeof( char const * ) );
	swigStructField( "pa_sink_port_info-available", offsetof( struct pa_sink_port_info, available ), sizeof( int ) );
	swigStructField( "pa_sink_port_info-description", offsetof( struct pa_sink_port_info, description ), sizeof( char const * ) );
	swigStructField( "pa_sink_port_info-availability_group", offsetof( struct pa_sink_port_info, availability_group ), sizeof( char const * ) );
	swigStructField( "pa_sink_port_info-type", offsetof( struct pa_sink_port_info, type ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct pa_sink_port_info ) );

	swigComment("struct pa_sink_info\n");
	printf( "begin-structure pa_sink_info\n" );
	swigStructField( "pa_sink_info-channel_map", offsetof( struct pa_sink_info, channel_map ), sizeof( pa_channel_map ) );
	swigStructField( "pa_sink_info-proplist", offsetof( struct pa_sink_info, proplist ), sizeof( pa_proplist * ) );
	swigStructField( "pa_sink_info-ports", offsetof( struct pa_sink_info, ports ), sizeof( pa_sink_port_info ** ) );
	swigStructField( "pa_sink_info-monitor_source_name", offsetof( struct pa_sink_info, monitor_source_name ), sizeof( char const * ) );
	swigStructField( "pa_sink_info-name", offsetof( struct pa_sink_info, name ), sizeof( char const * ) );
	swigStructField( "pa_sink_info-n_formats", offsetof( struct pa_sink_info, n_formats ), sizeof( uint8_t ) );
	swigStructField( "pa_sink_info-formats", offsetof( struct pa_sink_info, formats ), sizeof( pa_format_info ** ) );
	swigStructField( "pa_sink_info-mute", offsetof( struct pa_sink_info, mute ), sizeof( int ) );
	swigStructField( "pa_sink_info-active_port", offsetof( struct pa_sink_info, active_port ), sizeof( pa_sink_port_info * ) );
	swigStructField( "pa_sink_info-flags", offsetof( struct pa_sink_info, flags ), sizeof( pa_sink_flags_t ) );
	swigStructField( "pa_sink_info-volume", offsetof( struct pa_sink_info, volume ), sizeof( pa_cvolume ) );
	swigStructField( "pa_sink_info-driver", offsetof( struct pa_sink_info, driver ), sizeof( char const * ) );
	swigStructField( "pa_sink_info-owner_module", offsetof( struct pa_sink_info, owner_module ), sizeof( uint32_t ) );
	swigStructField( "pa_sink_info-card", offsetof( struct pa_sink_info, card ), sizeof( uint32_t ) );
	swigStructField( "pa_sink_info-description", offsetof( struct pa_sink_info, description ), sizeof( char const * ) );
	swigStructField( "pa_sink_info-monitor_source", offsetof( struct pa_sink_info, monitor_source ), sizeof( uint32_t ) );
	swigStructField( "pa_sink_info-index", offsetof( struct pa_sink_info, index ), sizeof( uint32_t ) );
	swigStructField( "pa_sink_info-state", offsetof( struct pa_sink_info, state ), sizeof( pa_sink_state_t ) );
	swigStructField( "pa_sink_info-n_ports", offsetof( struct pa_sink_info, n_ports ), sizeof( uint32_t ) );
	swigStructField( "pa_sink_info-latency", offsetof( struct pa_sink_info, latency ), sizeof( pa_usec_t ) );
	swigStructField( "pa_sink_info-configured_latency", offsetof( struct pa_sink_info, configured_latency ), sizeof( pa_usec_t ) );
	swigStructField( "pa_sink_info-base_volume", offsetof( struct pa_sink_info, base_volume ), sizeof( pa_volume_t ) );
	swigStructField( "pa_sink_info-n_volume_steps", offsetof( struct pa_sink_info, n_volume_steps ), sizeof( uint32_t ) );
	swigStructField( "pa_sink_info-sample_spec", offsetof( struct pa_sink_info, sample_spec ), sizeof( pa_sample_spec ) );
	printf( "drop %zu end-structure\n", sizeof( struct pa_sink_info ) );

	swigComment("struct pa_source_port_info\n");
	printf( "begin-structure pa_source_port_info\n" );
	swigStructField( "pa_source_port_info-priority", offsetof( struct pa_source_port_info, priority ), sizeof( uint32_t ) );
	swigStructField( "pa_source_port_info-name", offsetof( struct pa_source_port_info, name ), sizeof( char const * ) );
	swigStructField( "pa_source_port_info-available", offsetof( struct pa_source_port_info, available ), sizeof( int ) );
	swigStructField( "pa_source_port_info-description", offsetof( struct pa_source_port_info, description ), sizeof( char const * ) );
	swigStructField( "pa_source_port_info-availability_group", offsetof( struct pa_source_port_info, availability_group ), sizeof( char const * ) );
	swigStructField( "pa_source_port_info-type", offsetof( struct pa_source_port_info, type ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct pa_source_port_info ) );

	swigComment("struct pa_source_info\n");
	printf( "begin-structure pa_source_info\n" );
	swigStructField( "pa_source_info-monitor_of_sink", offsetof( struct pa_source_info, monitor_of_sink ), sizeof( uint32_t ) );
	swigStructField( "pa_source_info-channel_map", offsetof( struct pa_source_info, channel_map ), sizeof( pa_channel_map ) );
	swigStructField( "pa_source_info-proplist", offsetof( struct pa_source_info, proplist ), sizeof( pa_proplist * ) );
	swigStructField( "pa_source_info-ports", offsetof( struct pa_source_info, ports ), sizeof( pa_source_port_info ** ) );
	swigStructField( "pa_source_info-name", offsetof( struct pa_source_info, name ), sizeof( char const * ) );
	swigStructField( "pa_source_info-n_formats", offsetof( struct pa_source_info, n_formats ), sizeof( uint8_t ) );
	swigStructField( "pa_source_info-formats", offsetof( struct pa_source_info, formats ), sizeof( pa_format_info ** ) );
	swigStructField( "pa_source_info-mute", offsetof( struct pa_source_info, mute ), sizeof( int ) );
	swigStructField( "pa_source_info-active_port", offsetof( struct pa_source_info, active_port ), sizeof( pa_source_port_info * ) );
	swigStructField( "pa_source_info-flags", offsetof( struct pa_source_info, flags ), sizeof( pa_source_flags_t ) );
	swigStructField( "pa_source_info-monitor_of_sink_name", offsetof( struct pa_source_info, monitor_of_sink_name ), sizeof( char const * ) );
	swigStructField( "pa_source_info-volume", offsetof( struct pa_source_info, volume ), sizeof( pa_cvolume ) );
	swigStructField( "pa_source_info-driver", offsetof( struct pa_source_info, driver ), sizeof( char const * ) );
	swigStructField( "pa_source_info-owner_module", offsetof( struct pa_source_info, owner_module ), sizeof( uint32_t ) );
	swigStructField( "pa_source_info-card", offsetof( struct pa_source_info, card ), sizeof( uint32_t ) );
	swigStructField( "pa_source_info-description", offsetof( struct pa_source_info, description ), sizeof( char const * ) );
	swigStructField( "pa_source_info-index", offsetof( struct pa_source_info, index ), sizeof( uint32_t ) );
	swigStructField( "pa_source_info-state", offsetof( struct pa_source_info, state ), sizeof( pa_source_state_t ) );
	swigStructField( "pa_source_info-n_ports", offsetof( struct pa_source_info, n_ports ), sizeof( uint32_t ) );
	swigStructField( "pa_source_info-latency", offsetof( struct pa_source_info, latency ), sizeof( pa_usec_t ) );
	swigStructField( "pa_source_info-configured_latency", offsetof( struct pa_source_info, configured_latency ), sizeof( pa_usec_t ) );
	swigStructField( "pa_source_info-base_volume", offsetof( struct pa_source_info, base_volume ), sizeof( pa_volume_t ) );
	swigStructField( "pa_source_info-n_volume_steps", offsetof( struct pa_source_info, n_volume_steps ), sizeof( uint32_t ) );
	swigStructField( "pa_source_info-sample_spec", offsetof( struct pa_source_info, sample_spec ), sizeof( pa_sample_spec ) );
	printf( "drop %zu end-structure\n", sizeof( struct pa_source_info ) );

	swigComment("struct pa_server_info\n");
	printf( "begin-structure pa_server_info\n" );
	swigStructField( "pa_server_info-host_name", offsetof( struct pa_server_info, host_name ), sizeof( char const * ) );
	swigStructField( "pa_server_info-sample_spec", offsetof( struct pa_server_info, sample_spec ), sizeof( pa_sample_spec ) );
	swigStructField( "pa_server_info-server_version", offsetof( struct pa_server_info, server_version ), sizeof( char const * ) );
	swigStructField( "pa_server_info-cookie", offsetof( struct pa_server_info, cookie ), sizeof( uint32_t ) );
	swigStructField( "pa_server_info-channel_map", offsetof( struct pa_server_info, channel_map ), sizeof( pa_channel_map ) );
	swigStructField( "pa_server_info-user_name", offsetof( struct pa_server_info, user_name ), sizeof( char const * ) );
	swigStructField( "pa_server_info-server_name", offsetof( struct pa_server_info, server_name ), sizeof( char const * ) );
	swigStructField( "pa_server_info-default_sink_name", offsetof( struct pa_server_info, default_sink_name ), sizeof( char const * ) );
	swigStructField( "pa_server_info-default_source_name", offsetof( struct pa_server_info, default_source_name ), sizeof( char const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct pa_server_info ) );

	swigComment("struct pa_module_info\n");
	printf( "begin-structure pa_module_info\n" );
	swigStructField( "pa_module_info-n_used", offsetof( struct pa_module_info, n_used ), sizeof( uint32_t ) );
	swigStructField( "pa_module_info-index", offsetof( struct pa_module_info, index ), sizeof( uint32_t ) );
	swigStructField( "pa_module_info-name", offsetof( struct pa_module_info, name ), sizeof( char const * ) );
	swigStructField( "pa_module_info-proplist", offsetof( struct pa_module_info, proplist ), sizeof( pa_proplist * ) );
	swigStructField( "pa_module_info-auto_unload", offsetof( struct pa_module_info, auto_unload ), sizeof( int ) );
	swigStructField( "pa_module_info-argument", offsetof( struct pa_module_info, argument ), sizeof( char const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct pa_module_info ) );

	swigComment("struct pa_client_info\n");
	printf( "begin-structure pa_client_info\n" );
	swigStructField( "pa_client_info-owner_module", offsetof( struct pa_client_info, owner_module ), sizeof( uint32_t ) );
	swigStructField( "pa_client_info-index", offsetof( struct pa_client_info, index ), sizeof( uint32_t ) );
	swigStructField( "pa_client_info-name", offsetof( struct pa_client_info, name ), sizeof( char const * ) );
	swigStructField( "pa_client_info-driver", offsetof( struct pa_client_info, driver ), sizeof( char const * ) );
	swigStructField( "pa_client_info-proplist", offsetof( struct pa_client_info, proplist ), sizeof( pa_proplist * ) );
	printf( "drop %zu end-structure\n", sizeof( struct pa_client_info ) );

	swigComment("struct pa_card_profile_info\n");
	printf( "begin-structure pa_card_profile_info\n" );
	swigStructField( "pa_card_profile_info-priority", offsetof( struct pa_card_profile_info, priority ), sizeof( uint32_t ) );
	swigStructField( "pa_card_profile_info-name", offsetof( struct pa_card_profile_info, name ), sizeof( char const * ) );
	swigStructField( "pa_card_profile_info-description", offsetof( struct pa_card_profile_info, description ), sizeof( char const * ) );
	swigStructField( "pa_card_profile_info-n_sinks", offsetof( struct pa_card_profile_info, n_sinks ), sizeof( uint32_t ) );
	swigStructField( "pa_card_profile_info-n_sources", offsetof( struct pa_card_profile_info, n_sources ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct pa_card_profile_info ) );

	swigComment("struct pa_card_profile_info2\n");
	printf( "begin-structure pa_card_profile_info2\n" );
	swigStructField( "pa_card_profile_info2-priority", offsetof( struct pa_card_profile_info2, priority ), sizeof( uint32_t ) );
	swigStructField( "pa_card_profile_info2-name", offsetof( struct pa_card_profile_info2, name ), sizeof( char const * ) );
	swigStructField( "pa_card_profile_info2-available", offsetof( struct pa_card_profile_info2, available ), sizeof( int ) );
	swigStructField( "pa_card_profile_info2-description", offsetof( struct pa_card_profile_info2, description ), sizeof( char const * ) );
	swigStructField( "pa_card_profile_info2-n_sinks", offsetof( struct pa_card_profile_info2, n_sinks ), sizeof( uint32_t ) );
	swigStructField( "pa_card_profile_info2-n_sources", offsetof( struct pa_card_profile_info2, n_sources ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct pa_card_profile_info2 ) );

	swigComment("struct pa_card_port_info\n");
	printf( "begin-structure pa_card_port_info\n" );
	swigStructField( "pa_card_port_info-priority", offsetof( struct pa_card_port_info, priority ), sizeof( uint32_t ) );
	swigStructField( "pa_card_port_info-name", offsetof( struct pa_card_port_info, name ), sizeof( char const * ) );
	swigStructField( "pa_card_port_info-proplist", offsetof( struct pa_card_port_info, proplist ), sizeof( pa_proplist * ) );
	swigStructField( "pa_card_port_info-available", offsetof( struct pa_card_port_info, available ), sizeof( int ) );
	swigStructField( "pa_card_port_info-latency_offset", offsetof( struct pa_card_port_info, latency_offset ), sizeof( int64_t ) );
	swigStructField( "pa_card_port_info-description", offsetof( struct pa_card_port_info, description ), sizeof( char const * ) );
	swigStructField( "pa_card_port_info-availability_group", offsetof( struct pa_card_port_info, availability_group ), sizeof( char const * ) );
	swigStructField( "pa_card_port_info-type", offsetof( struct pa_card_port_info, type ), sizeof( uint32_t ) );
	swigStructField( "pa_card_port_info-n_profiles", offsetof( struct pa_card_port_info, n_profiles ), sizeof( uint32_t ) );
	swigStructField( "pa_card_port_info-profiles", offsetof( struct pa_card_port_info, profiles ), sizeof( pa_card_profile_info ** ) );
	swigStructField( "pa_card_port_info-direction", offsetof( struct pa_card_port_info, direction ), sizeof( int ) );
	swigStructField( "pa_card_port_info-profiles2", offsetof( struct pa_card_port_info, profiles2 ), sizeof( pa_card_profile_info2 ** ) );
	printf( "drop %zu end-structure\n", sizeof( struct pa_card_port_info ) );

	swigComment("struct pa_card_info\n");
	printf( "begin-structure pa_card_info\n" );
	swigStructField( "pa_card_info-owner_module", offsetof( struct pa_card_info, owner_module ), sizeof( uint32_t ) );
	swigStructField( "pa_card_info-n_ports", offsetof( struct pa_card_info, n_ports ), sizeof( uint32_t ) );
	swigStructField( "pa_card_info-index", offsetof( struct pa_card_info, index ), sizeof( uint32_t ) );
	swigStructField( "pa_card_info-name", offsetof( struct pa_card_info, name ), sizeof( char const * ) );
	swigStructField( "pa_card_info-driver", offsetof( struct pa_card_info, driver ), sizeof( char const * ) );
	swigStructField( "pa_card_info-proplist", offsetof( struct pa_card_info, proplist ), sizeof( pa_proplist * ) );
	swigStructField( "pa_card_info-ports", offsetof( struct pa_card_info, ports ), sizeof( pa_card_port_info ** ) );
	swigStructField( "pa_card_info-active_profile", offsetof( struct pa_card_info, active_profile ), sizeof( pa_card_profile_info * ) );
	swigStructField( "pa_card_info-active_profile2", offsetof( struct pa_card_info, active_profile2 ), sizeof( pa_card_profile_info2 * ) );
	swigStructField( "pa_card_info-n_profiles", offsetof( struct pa_card_info, n_profiles ), sizeof( uint32_t ) );
	swigStructField( "pa_card_info-profiles", offsetof( struct pa_card_info, profiles ), sizeof( pa_card_profile_info * ) );
	swigStructField( "pa_card_info-profiles2", offsetof( struct pa_card_info, profiles2 ), sizeof( pa_card_profile_info2 ** ) );
	printf( "drop %zu end-structure\n", sizeof( struct pa_card_info ) );

	swigComment("struct pa_sink_input_info\n");
	printf( "begin-structure pa_sink_input_info\n" );
	swigStructField( "pa_sink_input_info-client", offsetof( struct pa_sink_input_info, client ), sizeof( uint32_t ) );
	swigStructField( "pa_sink_input_info-channel_map", offsetof( struct pa_sink_input_info, channel_map ), sizeof( pa_channel_map ) );
	swigStructField( "pa_sink_input_info-proplist", offsetof( struct pa_sink_input_info, proplist ), sizeof( pa_proplist * ) );
	swigStructField( "pa_sink_input_info-corked", offsetof( struct pa_sink_input_info, corked ), sizeof( int ) );
	swigStructField( "pa_sink_input_info-name", offsetof( struct pa_sink_input_info, name ), sizeof( char const * ) );
	swigStructField( "pa_sink_input_info-resample_method", offsetof( struct pa_sink_input_info, resample_method ), sizeof( char const * ) );
	swigStructField( "pa_sink_input_info-format", offsetof( struct pa_sink_input_info, format ), sizeof( pa_format_info * ) );
	swigStructField( "pa_sink_input_info-sink_usec", offsetof( struct pa_sink_input_info, sink_usec ), sizeof( pa_usec_t ) );
	swigStructField( "pa_sink_input_info-buffer_usec", offsetof( struct pa_sink_input_info, buffer_usec ), sizeof( pa_usec_t ) );
	swigStructField( "pa_sink_input_info-mute", offsetof( struct pa_sink_input_info, mute ), sizeof( int ) );
	swigStructField( "pa_sink_input_info-volume", offsetof( struct pa_sink_input_info, volume ), sizeof( pa_cvolume ) );
	swigStructField( "pa_sink_input_info-volume_writable", offsetof( struct pa_sink_input_info, volume_writable ), sizeof( int ) );
	swigStructField( "pa_sink_input_info-driver", offsetof( struct pa_sink_input_info, driver ), sizeof( char const * ) );
	swigStructField( "pa_sink_input_info-owner_module", offsetof( struct pa_sink_input_info, owner_module ), sizeof( uint32_t ) );
	swigStructField( "pa_sink_input_info-index", offsetof( struct pa_sink_input_info, index ), sizeof( uint32_t ) );
	swigStructField( "pa_sink_input_info-has_volume", offsetof( struct pa_sink_input_info, has_volume ), sizeof( int ) );
	swigStructField( "pa_sink_input_info-sink", offsetof( struct pa_sink_input_info, sink ), sizeof( uint32_t ) );
	swigStructField( "pa_sink_input_info-sample_spec", offsetof( struct pa_sink_input_info, sample_spec ), sizeof( pa_sample_spec ) );
	printf( "drop %zu end-structure\n", sizeof( struct pa_sink_input_info ) );

	swigComment("struct pa_source_output_info\n");
	printf( "begin-structure pa_source_output_info\n" );
	swigStructField( "pa_source_output_info-client", offsetof( struct pa_source_output_info, client ), sizeof( uint32_t ) );
	swigStructField( "pa_source_output_info-channel_map", offsetof( struct pa_source_output_info, channel_map ), sizeof( pa_channel_map ) );
	swigStructField( "pa_source_output_info-corked", offsetof( struct pa_source_output_info, corked ), sizeof( int ) );
	swigStructField( "pa_source_output_info-proplist", offsetof( struct pa_source_output_info, proplist ), sizeof( pa_proplist * ) );
	swigStructField( "pa_source_output_info-name", offsetof( struct pa_source_output_info, name ), sizeof( char const * ) );
	swigStructField( "pa_source_output_info-resample_method", offsetof( struct pa_source_output_info, resample_method ), sizeof( char const * ) );
	swigStructField( "pa_source_output_info-format", offsetof( struct pa_source_output_info, format ), sizeof( pa_format_info * ) );
	swigStructField( "pa_source_output_info-buffer_usec", offsetof( struct pa_source_output_info, buffer_usec ), sizeof( pa_usec_t ) );
	swigStructField( "pa_source_output_info-source", offsetof( struct pa_source_output_info, source ), sizeof( uint32_t ) );
	swigStructField( "pa_source_output_info-mute", offsetof( struct pa_source_output_info, mute ), sizeof( int ) );
	swigStructField( "pa_source_output_info-volume", offsetof( struct pa_source_output_info, volume ), sizeof( pa_cvolume ) );
	swigStructField( "pa_source_output_info-volume_writable", offsetof( struct pa_source_output_info, volume_writable ), sizeof( int ) );
	swigStructField( "pa_source_output_info-driver", offsetof( struct pa_source_output_info, driver ), sizeof( char const * ) );
	swigStructField( "pa_source_output_info-owner_module", offsetof( struct pa_source_output_info, owner_module ), sizeof( uint32_t ) );
	swigStructField( "pa_source_output_info-index", offsetof( struct pa_source_output_info, index ), sizeof( uint32_t ) );
	swigStructField( "pa_source_output_info-has_volume", offsetof( struct pa_source_output_info, has_volume ), sizeof( int ) );
	swigStructField( "pa_source_output_info-source_usec", offsetof( struct pa_source_output_info, source_usec ), sizeof( pa_usec_t ) );
	swigStructField( "pa_source_output_info-sample_spec", offsetof( struct pa_source_output_info, sample_spec ), sizeof( pa_sample_spec ) );
	printf( "drop %zu end-structure\n", sizeof( struct pa_source_output_info ) );

	swigComment("struct pa_stat_info\n");
	printf( "begin-structure pa_stat_info\n" );
	swigStructField( "pa_stat_info-memblock_allocated", offsetof( struct pa_stat_info, memblock_allocated ), sizeof( uint32_t ) );
	swigStructField( "pa_stat_info-memblock_allocated_size", offsetof( struct pa_stat_info, memblock_allocated_size ), sizeof( uint32_t ) );
	swigStructField( "pa_stat_info-memblock_total_size", offsetof( struct pa_stat_info, memblock_total_size ), sizeof( uint32_t ) );
	swigStructField( "pa_stat_info-scache_size", offsetof( struct pa_stat_info, scache_size ), sizeof( uint32_t ) );
	swigStructField( "pa_stat_info-memblock_total", offsetof( struct pa_stat_info, memblock_total ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct pa_stat_info ) );

	swigComment("struct pa_sample_info\n");
	printf( "begin-structure pa_sample_info\n" );
	swigStructField( "pa_sample_info-index", offsetof( struct pa_sample_info, index ), sizeof( uint32_t ) );
	swigStructField( "pa_sample_info-name", offsetof( struct pa_sample_info, name ), sizeof( char const * ) );
	swigStructField( "pa_sample_info-sample_spec", offsetof( struct pa_sample_info, sample_spec ), sizeof( pa_sample_spec ) );
	swigStructField( "pa_sample_info-lazy", offsetof( struct pa_sample_info, lazy ), sizeof( int ) );
	swigStructField( "pa_sample_info-proplist", offsetof( struct pa_sample_info, proplist ), sizeof( pa_proplist * ) );
	swigStructField( "pa_sample_info-duration", offsetof( struct pa_sample_info, duration ), sizeof( pa_usec_t ) );
	swigStructField( "pa_sample_info-filename", offsetof( struct pa_sample_info, filename ), sizeof( char const * ) );
	swigStructField( "pa_sample_info-volume", offsetof( struct pa_sample_info, volume ), sizeof( pa_cvolume ) );
	swigStructField( "pa_sample_info-channel_map", offsetof( struct pa_sample_info, channel_map ), sizeof( pa_channel_map ) );
	swigStructField( "pa_sample_info-bytes", offsetof( struct pa_sample_info, bytes ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct pa_sample_info ) );

	swigComment("struct pa_autoload_info\n");
	printf( "begin-structure pa_autoload_info\n" );
	swigStructField( "pa_autoload_info-index", offsetof( struct pa_autoload_info, index ), sizeof( uint32_t ) );
	swigStructField( "pa_autoload_info-name", offsetof( struct pa_autoload_info, name ), sizeof( char const * ) );
	swigStructField( "pa_autoload_info-module", offsetof( struct pa_autoload_info, module ), sizeof( char const * ) );
	swigStructField( "pa_autoload_info-type", offsetof( struct pa_autoload_info, type ), sizeof( pa_autoload_type_t ) );
	swigStructField( "pa_autoload_info-argument", offsetof( struct pa_autoload_info, argument ), sizeof( char const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct pa_autoload_info ) );

	swigComment("struct pa_channel_map\n");
	printf( "begin-structure pa_channel_map\n" );
	swigStructField( "pa_channel_map-channels", offsetof( struct pa_channel_map, channels ), sizeof( uint8_t ) );
	swigStructField( "pa_channel_map-map", offsetof( struct pa_channel_map, map ), sizeof( pa_channel_position_t [32U] ) );
	printf( "drop %zu end-structure\n", sizeof( struct pa_channel_map ) );

	swigComment("struct pa_cvolume\n");
	printf( "begin-structure pa_cvolume\n" );
	swigStructField( "pa_cvolume-channels", offsetof( struct pa_cvolume, channels ), sizeof( uint8_t ) );
	swigStructField( "pa_cvolume-values", offsetof( struct pa_cvolume, values ), sizeof( pa_volume_t [32U] ) );
	printf( "drop %zu end-structure\n", sizeof( struct pa_cvolume ) );

	swigNewline();

	swigComment("--===< function pointers >===---\n");
	if(offsetof(struct pa_mainloop_api, io_new) >= 0) swigFunctionPointer( "c-funptr pa_mainloop_api-io_new() {((struct pa_mainloop_api*)ptr)->io_new} a n n a a -- a", "", "", "	( a fd events cb userdata -- )" );
	if(offsetof(struct pa_mainloop_api, io_enable) >= 0) swigFunctionPointer( "c-funptr pa_mainloop_api-io_enable() {((struct pa_mainloop_api*)ptr)->io_enable} a n -- void", "", "", "	( e events -- )" );
	if(offsetof(struct pa_mainloop_api, io_free) >= 0) swigFunctionPointer( "c-funptr pa_mainloop_api-io_free() {((struct pa_mainloop_api*)ptr)->io_free} a -- void", "", "", "	( e -- )" );
	if(offsetof(struct pa_mainloop_api, io_set_destroy) >= 0) swigFunctionPointer( "c-funptr pa_mainloop_api-io_set_destroy() {((struct pa_mainloop_api*)ptr)->io_set_destroy} a a -- void", "", "", "	( e cb -- )" );
	if(offsetof(struct pa_mainloop_api, time_new) >= 0) swigFunctionPointer( "c-funptr pa_mainloop_api-time_new() {((struct pa_mainloop_api*)ptr)->time_new} a a a a -- a", "", "", "	( a tv cb userdata -- )" );
	if(offsetof(struct pa_mainloop_api, time_restart) >= 0) swigFunctionPointer( "c-funptr pa_mainloop_api-time_restart() {((struct pa_mainloop_api*)ptr)->time_restart} a a -- void", "", "", "	( e tv -- )" );
	if(offsetof(struct pa_mainloop_api, time_free) >= 0) swigFunctionPointer( "c-funptr pa_mainloop_api-time_free() {((struct pa_mainloop_api*)ptr)->time_free} a -- void", "", "", "	( e -- )" );
	if(offsetof(struct pa_mainloop_api, time_set_destroy) >= 0) swigFunctionPointer( "c-funptr pa_mainloop_api-time_set_destroy() {((struct pa_mainloop_api*)ptr)->time_set_destroy} a a -- void", "", "", "	( e cb -- )" );
	if(offsetof(struct pa_mainloop_api, defer_new) >= 0) swigFunctionPointer( "c-funptr pa_mainloop_api-defer_new() {((struct pa_mainloop_api*)ptr)->defer_new} a a a -- a", "", "", "	( a cb userdata -- )" );
	if(offsetof(struct pa_mainloop_api, defer_enable) >= 0) swigFunctionPointer( "c-funptr pa_mainloop_api-defer_enable() {((struct pa_mainloop_api*)ptr)->defer_enable} a n -- void", "", "", "	( e b -- )" );
	if(offsetof(struct pa_mainloop_api, defer_free) >= 0) swigFunctionPointer( "c-funptr pa_mainloop_api-defer_free() {((struct pa_mainloop_api*)ptr)->defer_free} a -- void", "", "", "	( e -- )" );
	if(offsetof(struct pa_mainloop_api, defer_set_destroy) >= 0) swigFunctionPointer( "c-funptr pa_mainloop_api-defer_set_destroy() {((struct pa_mainloop_api*)ptr)->defer_set_destroy} a a -- void", "", "", "	( e cb -- )" );
	if(offsetof(struct pa_mainloop_api, quit) >= 0) swigFunctionPointer( "c-funptr pa_mainloop_api-quit() {((struct pa_mainloop_api*)ptr)->quit} a n -- void", "", "", "	( a retval -- )" );
	if(offsetof(struct pa_spawn_api, prefork) >= 0) swigFunctionPointer( "c-funptr pa_spawn_api-prefork() {((struct pa_spawn_api*)ptr)->prefork}  -- void", "", "", "	( <noname> -- )" );
	if(offsetof(struct pa_spawn_api, postfork) >= 0) swigFunctionPointer( "c-funptr pa_spawn_api-postfork() {((struct pa_spawn_api*)ptr)->postfork}  -- void", "", "", "	( <noname> -- )" );
	if(offsetof(struct pa_spawn_api, atfork) >= 0) swigFunctionPointer( "c-funptr pa_spawn_api-atfork() {((struct pa_spawn_api*)ptr)->atfork}  -- void", "", "", "	( <noname> -- )" );

	swigNewline();

	swigComment("------===< callbacks >===-------\n");
	swigCallback( "c-callback pa_io_event_cb_t: a a n n a -- void", "", "", "	( ea e fd events userdata -- )" );
	swigCallback( "c-callback pa_io_event_destroy_cb_t: a a a -- void", "", "", "	( a e userdata -- )" );
	swigCallback( "c-callback pa_time_event_cb_t: a a a a -- void", "", "", "	( a e tv userdata -- )" );
	swigCallback( "c-callback pa_time_event_destroy_cb_t: a a a -- void", "", "", "	( a e userdata -- )" );
	swigCallback( "c-callback pa_defer_event_cb_t: a a a -- void", "", "", "	( a e userdata -- )" );
	swigCallback( "c-callback pa_defer_event_destroy_cb_t: a a a -- void", "", "", "	( a e userdata -- )" );
	swigCallback( "c-callback pa_free_cb_t: a -- void", "", "", "	( p -- )" );
	swigCallback( "c-callback pa_context_notify_cb_t: a a -- void", "", "", "	( c userdata -- )" );
	swigCallback( "c-callback pa_context_success_cb_t: a n a -- void", "", "", "	( c success userdata -- )" );
	swigCallback( "c-callback pa_context_event_cb_t: a s a a -- void", "", "", "	( c name p userdata -- )" );
	swigCallback( "c-callback pa_stream_success_cb_t: a n a -- void", "", "", "	( s success userdata -- )" );
	swigCallback( "c-callback pa_stream_request_cb_t: a u a -- void", "", "", "	( p nbytes userdata -- )" );
	swigCallback( "c-callback pa_stream_notify_cb_t: a a -- void", "", "", "	( p userdata -- )" );
	swigCallback( "c-callback pa_stream_event_cb_t: a s a a -- void", "", "", "	( p name pl userdata -- )" );
	swigCallback( "c-callback pa_sink_info_cb_t: a a n a -- void", "", "", "	( c i eol userdata -- )" );
	swigCallback( "c-callback pa_source_info_cb_t: a a n a -- void", "", "", "	( c i eol userdata -- )" );
	swigCallback( "c-callback pa_server_info_cb_t: a a a -- void", "", "", "	( c i userdata -- )" );
	swigCallback( "c-callback pa_module_info_cb_t: a a n a -- void", "", "", "	( c i eol userdata -- )" );
	swigCallback( "c-callback pa_context_index_cb_t: a u a -- void", "", "", "	( c idx userdata -- )" );
	swigCallback( "c-callback pa_context_string_cb_t: a n a a -- void", "", "", "	( c success response userdata -- )" );
	swigCallback( "c-callback pa_client_info_cb_t: a a n a -- void", "", "", "	( c i eol userdata -- )" );
	swigCallback( "c-callback pa_card_info_cb_t: a a n a -- void", "", "", "	( c i eol userdata -- )" );
	swigCallback( "c-callback pa_sink_input_info_cb_t: a a n a -- void", "", "", "	( c i eol userdata -- )" );
	swigCallback( "c-callback pa_source_output_info_cb_t: a a n a -- void", "", "", "	( c i eol userdata -- )" );
	swigCallback( "c-callback pa_stat_info_cb_t: a a a -- void", "", "", "	( c i userdata -- )" );
	swigCallback( "c-callback pa_sample_info_cb_t: a a n a -- void", "", "", "	( c i eol userdata -- )" );
	swigCallback( "c-callback pa_autoload_info_cb_t: a a n a -- void", "", "", "	( c i eol userdata -- )" );
	swigCallback( "c-callback pa_context_subscribe_cb_t: a n u a -- void", "", "", "	( c t idx userdata -- )" );
	swigCallback( "c-callback pa_context_play_sample_cb_t: a u a -- void", "", "", "	( c idx userdata -- )" );
	swigCallback( "c-callback pa_operation_notify_cb_t: a a -- void", "", "", "	( o userdata -- )" );
	swigCallback( "c-callback pa_poll_func: a u n a -- n", "", "", "	( ufds nfds timeout userdata -- )" );
	swigCallback( "c-callback pa_signal_cb_t: a a n a -- void", "", "", "	( api e sig userdata -- )" );
	swigCallback( "c-callback pa_signal_destroy_cb_t: a a a -- void", "", "", "	( api e userdata -- )" );

	swigNewline();

	swigComment("------===< functions >===-------\n");
	swigFunction( "c-function pa_direction_valid pa_direction_valid n -- n", "FUNCTION: pa_direction_valid ( direction -- n )", "EXTERN: \"C\" int pa_direction_valid( int direction );", "	( direction -- )" );
	swigFunction( "c-function pa_direction_to_string pa_direction_to_string n -- s", "FUNCTION: pa_direction_to_string ( direction -- s )", "EXTERN: \"C\" char * pa_direction_to_string( int direction );", "	( direction -- )" );
	swigFunction( "c-function pa_mainloop_api_once pa_mainloop_api_once a a a -- void", "FUNCTION: pa_mainloop_api_once ( m callback userdata -- void )", "EXTERN: \"C\" void pa_mainloop_api_once( void * m, void * callback, void * userdata );", "	( m callback userdata -- )" );
	swigFunction( "c-function pa_bytes_per_second pa_bytes_per_second a -- u", "FUNCTION: pa_bytes_per_second ( spec -- u )", "EXTERN: \"C\" int pa_bytes_per_second( void * spec );", "	( spec -- )" );
	swigFunction( "c-function pa_frame_size pa_frame_size a -- u", "FUNCTION: pa_frame_size ( spec -- u )", "EXTERN: \"C\" int pa_frame_size( void * spec );", "	( spec -- )" );
	swigFunction( "c-function pa_sample_size pa_sample_size a -- u", "FUNCTION: pa_sample_size ( spec -- u )", "EXTERN: \"C\" int pa_sample_size( void * spec );", "	( spec -- )" );
	swigFunction( "c-function pa_sample_size_of_format pa_sample_size_of_format n -- u", "FUNCTION: pa_sample_size_of_format ( f -- u )", "EXTERN: \"C\" int pa_sample_size_of_format( int f );", "	( f -- )" );
	swigFunction( "c-function pa_bytes_to_usec pa_bytes_to_usec ud a -- u", "FUNCTION: pa_bytes_to_usec ( length spec -- u )", "EXTERN: \"C\" int pa_bytes_to_usec( long long length, void * spec );", "	( length spec -- )" );
	swigFunction( "c-function pa_usec_to_bytes pa_usec_to_bytes u a -- u", "FUNCTION: pa_usec_to_bytes ( t spec -- u )", "EXTERN: \"C\" int pa_usec_to_bytes( int t, void * spec );", "	( t spec -- )" );
	swigFunction( "c-function pa_sample_spec_init pa_sample_spec_init a -- a", "FUNCTION: pa_sample_spec_init ( spec -- a )", "EXTERN: \"C\" void * pa_sample_spec_init( void * spec );", "	( spec -- )" );
	swigFunction( "c-function pa_sample_format_valid pa_sample_format_valid u -- n", "FUNCTION: pa_sample_format_valid ( format -- n )", "EXTERN: \"C\" int pa_sample_format_valid( int format );", "	( format -- )" );
	swigFunction( "c-function pa_sample_rate_valid pa_sample_rate_valid u -- n", "FUNCTION: pa_sample_rate_valid ( rate -- n )", "EXTERN: \"C\" int pa_sample_rate_valid( int rate );", "	( rate -- )" );
	swigFunction( "c-function pa_channels_valid pa_channels_valid u -- n", "FUNCTION: pa_channels_valid ( channels -- n )", "EXTERN: \"C\" int pa_channels_valid( char channels );", "	( channels -- )" );
	swigFunction( "c-function pa_sample_spec_valid pa_sample_spec_valid a -- n", "FUNCTION: pa_sample_spec_valid ( spec -- n )", "EXTERN: \"C\" int pa_sample_spec_valid( void * spec );", "	( spec -- )" );
	swigFunction( "c-function pa_sample_spec_equal pa_sample_spec_equal a a -- n", "FUNCTION: pa_sample_spec_equal ( a b -- n )", "EXTERN: \"C\" int pa_sample_spec_equal( void * a, void * b );", "	( a b -- )" );
	swigFunction( "c-function pa_sample_format_to_string pa_sample_format_to_string n -- s", "FUNCTION: pa_sample_format_to_string ( f -- s )", "EXTERN: \"C\" char * pa_sample_format_to_string( int f );", "	( f -- )" );
	swigFunction( "c-function pa_parse_sample_format pa_parse_sample_format s -- n", "FUNCTION: pa_parse_sample_format ( format -- n )", "EXTERN: \"C\" int pa_parse_sample_format( char * format );", "	( format -- )" );
	swigFunction( "c-function pa_sample_spec_snprint pa_sample_spec_snprint a u a -- a", "FUNCTION: pa_sample_spec_snprint ( s l spec -- a )", "EXTERN: \"C\" void * pa_sample_spec_snprint( void * s, int l, void * spec );", "	( s l spec -- )" );
	swigFunction( "c-function pa_bytes_snprint pa_bytes_snprint a u u -- a", "FUNCTION: pa_bytes_snprint ( s l v -- a )", "EXTERN: \"C\" void * pa_bytes_snprint( void * s, int l, int v );", "	( s l v -- )" );
	swigFunction( "c-function pa_sample_format_is_le pa_sample_format_is_le n -- n", "FUNCTION: pa_sample_format_is_le ( f -- n )", "EXTERN: \"C\" int pa_sample_format_is_le( int f );", "	( f -- )" );
	swigFunction( "c-function pa_sample_format_is_be pa_sample_format_is_be n -- n", "FUNCTION: pa_sample_format_is_be ( f -- n )", "EXTERN: \"C\" int pa_sample_format_is_be( int f );", "	( f -- )" );
	swigFunction( "c-function pa_encoding_to_string pa_encoding_to_string n -- s", "FUNCTION: pa_encoding_to_string ( e -- s )", "EXTERN: \"C\" char * pa_encoding_to_string( int e );", "	( e -- )" );
	swigFunction( "c-function pa_encoding_from_string pa_encoding_from_string s -- n", "FUNCTION: pa_encoding_from_string ( encoding -- n )", "EXTERN: \"C\" int pa_encoding_from_string( char * encoding );", "	( encoding -- )" );
	swigFunction( "c-function pa_format_info_new pa_format_info_new  -- a", "FUNCTION: pa_format_info_new (  -- a )", "EXTERN: \"C\" void * pa_format_info_new(  );", "	( -- )" );
	swigFunction( "c-function pa_format_info_copy pa_format_info_copy a -- a", "FUNCTION: pa_format_info_copy ( src -- a )", "EXTERN: \"C\" void * pa_format_info_copy( void * src );", "	( src -- )" );
	swigFunction( "c-function pa_format_info_free pa_format_info_free a -- void", "FUNCTION: pa_format_info_free ( f -- void )", "EXTERN: \"C\" void pa_format_info_free( void * f );", "	( f -- )" );
	swigFunction( "c-function pa_format_info_valid pa_format_info_valid a -- n", "FUNCTION: pa_format_info_valid ( f -- n )", "EXTERN: \"C\" int pa_format_info_valid( void * f );", "	( f -- )" );
	swigFunction( "c-function pa_format_info_is_pcm pa_format_info_is_pcm a -- n", "FUNCTION: pa_format_info_is_pcm ( f -- n )", "EXTERN: \"C\" int pa_format_info_is_pcm( void * f );", "	( f -- )" );
	swigFunction( "c-function pa_format_info_is_compatible pa_format_info_is_compatible a a -- n", "FUNCTION: pa_format_info_is_compatible ( first second -- n )", "EXTERN: \"C\" int pa_format_info_is_compatible( void * first, void * second );", "	( first second -- )" );
	swigFunction( "c-function pa_format_info_snprint pa_format_info_snprint a u a -- a", "FUNCTION: pa_format_info_snprint ( s l f -- a )", "EXTERN: \"C\" void * pa_format_info_snprint( void * s, int l, void * f );", "	( s l f -- )" );
	swigFunction( "c-function pa_format_info_from_string pa_format_info_from_string s -- a", "FUNCTION: pa_format_info_from_string ( str -- a )", "EXTERN: \"C\" void * pa_format_info_from_string( char * str );", "	( str -- )" );
	swigFunction( "c-function pa_format_info_from_sample_spec pa_format_info_from_sample_spec a a -- a", "FUNCTION: pa_format_info_from_sample_spec ( ss map -- a )", "EXTERN: \"C\" void * pa_format_info_from_sample_spec( void * ss, void * map );", "	( ss map -- )" );
	swigFunction( "c-function pa_format_info_to_sample_spec pa_format_info_to_sample_spec a a a -- n", "FUNCTION: pa_format_info_to_sample_spec ( f ss map -- n )", "EXTERN: \"C\" int pa_format_info_to_sample_spec( void * f, void * ss, void * map );", "	( f ss map -- )" );
	swigFunction( "c-function pa_format_info_get_prop_type pa_format_info_get_prop_type a s -- n", "FUNCTION: pa_format_info_get_prop_type ( f key -- n )", "EXTERN: \"C\" int pa_format_info_get_prop_type( void * f, char * key );", "	( f key -- )" );
	swigFunction( "c-function pa_format_info_get_prop_int pa_format_info_get_prop_int a s a -- n", "FUNCTION: pa_format_info_get_prop_int ( f key v -- n )", "EXTERN: \"C\" int pa_format_info_get_prop_int( void * f, char * key, void * v );", "	( f key v -- )" );
	swigFunction( "c-function pa_format_info_get_prop_int_range pa_format_info_get_prop_int_range a s a a -- n", "FUNCTION: pa_format_info_get_prop_int_range ( f key min max -- n )", "EXTERN: \"C\" int pa_format_info_get_prop_int_range( void * f, char * key, void * min, void * max );", "	( f key min max -- )" );
	swigFunction( "c-function pa_format_info_get_prop_int_array pa_format_info_get_prop_int_array a s a a -- n", "FUNCTION: pa_format_info_get_prop_int_array ( f key values n_values -- n )", "EXTERN: \"C\" int pa_format_info_get_prop_int_array( void * f, char * key, void * values, void * n_values );", "	( f key values n_values -- )" );
	swigFunction( "c-function pa_format_info_get_prop_string pa_format_info_get_prop_string a s a -- n", "FUNCTION: pa_format_info_get_prop_string ( f key v -- n )", "EXTERN: \"C\" int pa_format_info_get_prop_string( void * f, char * key, void * v );", "	( f key v -- )" );
	swigFunction( "c-function pa_format_info_get_prop_string_array pa_format_info_get_prop_string_array a s a a -- n", "FUNCTION: pa_format_info_get_prop_string_array ( f key values n_values -- n )", "EXTERN: \"C\" int pa_format_info_get_prop_string_array( void * f, char * key, void * values, void * n_values );", "	( f key values n_values -- )" );
	swigFunction( "c-function pa_format_info_free_string_array pa_format_info_free_string_array a n -- void", "FUNCTION: pa_format_info_free_string_array ( values n_values -- void )", "EXTERN: \"C\" void pa_format_info_free_string_array( void * values, int n_values );", "	( values n_values -- )" );
	swigFunction( "c-function pa_format_info_get_sample_format pa_format_info_get_sample_format a a -- n", "FUNCTION: pa_format_info_get_sample_format ( f sf -- n )", "EXTERN: \"C\" int pa_format_info_get_sample_format( void * f, void * sf );", "	( f sf -- )" );
	swigFunction( "c-function pa_format_info_get_rate pa_format_info_get_rate a a -- n", "FUNCTION: pa_format_info_get_rate ( f rate -- n )", "EXTERN: \"C\" int pa_format_info_get_rate( void * f, void * rate );", "	( f rate -- )" );
	swigFunction( "c-function pa_format_info_get_channels pa_format_info_get_channels a a -- n", "FUNCTION: pa_format_info_get_channels ( f channels -- n )", "EXTERN: \"C\" int pa_format_info_get_channels( void * f, void * channels );", "	( f channels -- )" );
	swigFunction( "c-function pa_format_info_get_channel_map pa_format_info_get_channel_map a a -- n", "FUNCTION: pa_format_info_get_channel_map ( f map -- n )", "EXTERN: \"C\" int pa_format_info_get_channel_map( void * f, void * map );", "	( f map -- )" );
	swigFunction( "c-function pa_format_info_set_prop_int pa_format_info_set_prop_int a s n -- void", "FUNCTION: pa_format_info_set_prop_int ( f key value -- void )", "EXTERN: \"C\" void pa_format_info_set_prop_int( void * f, char * key, int value );", "	( f key value -- )" );
	swigFunction( "c-function pa_format_info_set_prop_int_array pa_format_info_set_prop_int_array a s a n -- void", "FUNCTION: pa_format_info_set_prop_int_array ( f key values n_values -- void )", "EXTERN: \"C\" void pa_format_info_set_prop_int_array( void * f, char * key, void * values, int n_values );", "	( f key values n_values -- )" );
	swigFunction( "c-function pa_format_info_set_prop_int_range pa_format_info_set_prop_int_range a s n n -- void", "FUNCTION: pa_format_info_set_prop_int_range ( f key min max -- void )", "EXTERN: \"C\" void pa_format_info_set_prop_int_range( void * f, char * key, int min, int max );", "	( f key min max -- )" );
	swigFunction( "c-function pa_format_info_set_prop_string pa_format_info_set_prop_string a s s -- void", "FUNCTION: pa_format_info_set_prop_string ( f key value -- void )", "EXTERN: \"C\" void pa_format_info_set_prop_string( void * f, char * key, char * value );", "	( f key value -- )" );
	swigFunction( "c-function pa_format_info_set_prop_string_array pa_format_info_set_prop_string_array a s a n -- void", "FUNCTION: pa_format_info_set_prop_string_array ( f key values n_values -- void )", "EXTERN: \"C\" void pa_format_info_set_prop_string_array( void * f, char * key, void * values, int n_values );", "	( f key values n_values -- )" );
	swigFunction( "c-function pa_format_info_set_sample_format pa_format_info_set_sample_format a n -- void", "FUNCTION: pa_format_info_set_sample_format ( f sf -- void )", "EXTERN: \"C\" void pa_format_info_set_sample_format( void * f, int sf );", "	( f sf -- )" );
	swigFunction( "c-function pa_format_info_set_rate pa_format_info_set_rate a n -- void", "FUNCTION: pa_format_info_set_rate ( f rate -- void )", "EXTERN: \"C\" void pa_format_info_set_rate( void * f, int rate );", "	( f rate -- )" );
	swigFunction( "c-function pa_format_info_set_channels pa_format_info_set_channels a n -- void", "FUNCTION: pa_format_info_set_channels ( f channels -- void )", "EXTERN: \"C\" void pa_format_info_set_channels( void * f, int channels );", "	( f channels -- )" );
	swigFunction( "c-function pa_format_info_set_channel_map pa_format_info_set_channel_map a a -- void", "FUNCTION: pa_format_info_set_channel_map ( f map -- void )", "EXTERN: \"C\" void pa_format_info_set_channel_map( void * f, void * map );", "	( f map -- )" );
	swigFunction( "c-function PA_CONTEXT_IS_GOOD PA_CONTEXT_IS_GOOD n -- n", "FUNCTION: PA_CONTEXT_IS_GOOD ( x -- n )", "EXTERN: \"C\" int PA_CONTEXT_IS_GOOD( int x );", "	( x -- )" );
	swigFunction( "c-function PA_STREAM_IS_GOOD PA_STREAM_IS_GOOD n -- n", "FUNCTION: PA_STREAM_IS_GOOD ( x -- n )", "EXTERN: \"C\" int PA_STREAM_IS_GOOD( int x );", "	( x -- )" );
	swigFunction( "c-function PA_SINK_IS_OPENED PA_SINK_IS_OPENED n -- n", "FUNCTION: PA_SINK_IS_OPENED ( x -- n )", "EXTERN: \"C\" int PA_SINK_IS_OPENED( int x );", "	( x -- )" );
	swigFunction( "c-function PA_SINK_IS_RUNNING PA_SINK_IS_RUNNING n -- n", "FUNCTION: PA_SINK_IS_RUNNING ( x -- n )", "EXTERN: \"C\" int PA_SINK_IS_RUNNING( int x );", "	( x -- )" );
	swigFunction( "c-function PA_SOURCE_IS_OPENED PA_SOURCE_IS_OPENED n -- n", "FUNCTION: PA_SOURCE_IS_OPENED ( x -- n )", "EXTERN: \"C\" int PA_SOURCE_IS_OPENED( int x );", "	( x -- )" );
	swigFunction( "c-function PA_SOURCE_IS_RUNNING PA_SOURCE_IS_RUNNING n -- n", "FUNCTION: PA_SOURCE_IS_RUNNING ( x -- n )", "EXTERN: \"C\" int PA_SOURCE_IS_RUNNING( int x );", "	( x -- )" );
	swigFunction( "c-function pa_context_new pa_context_new a s -- a", "FUNCTION: pa_context_new ( mainloop name -- a )", "EXTERN: \"C\" void * pa_context_new( void * mainloop, char * name );", "	( mainloop name -- )" );
	swigFunction( "c-function pa_context_new_with_proplist pa_context_new_with_proplist a s a -- a", "FUNCTION: pa_context_new_with_proplist ( mainloop name proplist -- a )", "EXTERN: \"C\" void * pa_context_new_with_proplist( void * mainloop, char * name, void * proplist );", "	( mainloop name proplist -- )" );
	swigFunction( "c-function pa_context_unref pa_context_unref a -- void", "FUNCTION: pa_context_unref ( c -- void )", "EXTERN: \"C\" void pa_context_unref( void * c );", "	( c -- )" );
	swigFunction( "c-function pa_context_ref pa_context_ref a -- a", "FUNCTION: pa_context_ref ( c -- a )", "EXTERN: \"C\" void * pa_context_ref( void * c );", "	( c -- )" );
	swigFunction( "c-function pa_context_set_state_callback pa_context_set_state_callback a a a -- void", "FUNCTION: pa_context_set_state_callback ( c cb userdata -- void )", "EXTERN: \"C\" void pa_context_set_state_callback( void * c, void * cb, void * userdata );", "	( c cb userdata -- )" );
	swigFunction( "c-function pa_context_set_event_callback pa_context_set_event_callback a a a -- void", "FUNCTION: pa_context_set_event_callback ( p cb userdata -- void )", "EXTERN: \"C\" void pa_context_set_event_callback( void * p, void * cb, void * userdata );", "	( p cb userdata -- )" );
	swigFunction( "c-function pa_context_errno pa_context_errno a -- n", "FUNCTION: pa_context_errno ( c -- n )", "EXTERN: \"C\" int pa_context_errno( void * c );", "	( c -- )" );
	swigFunction( "c-function pa_context_is_pending pa_context_is_pending a -- n", "FUNCTION: pa_context_is_pending ( c -- n )", "EXTERN: \"C\" int pa_context_is_pending( void * c );", "	( c -- )" );
	swigFunction( "c-function pa_context_get_state pa_context_get_state a -- n", "FUNCTION: pa_context_get_state ( c -- n )", "EXTERN: \"C\" int pa_context_get_state( void * c );", "	( c -- )" );
	swigFunction( "c-function pa_context_connect pa_context_connect a s n a -- n", "FUNCTION: pa_context_connect ( c server flags api -- n )", "EXTERN: \"C\" int pa_context_connect( void * c, char * server, int flags, void * api );", "	( c server flags api -- )" );
	swigFunction( "c-function pa_context_disconnect pa_context_disconnect a -- void", "FUNCTION: pa_context_disconnect ( c -- void )", "EXTERN: \"C\" void pa_context_disconnect( void * c );", "	( c -- )" );
	swigFunction( "c-function pa_context_drain pa_context_drain a a a -- a", "FUNCTION: pa_context_drain ( c cb userdata -- a )", "EXTERN: \"C\" void * pa_context_drain( void * c, void * cb, void * userdata );", "	( c cb userdata -- )" );
	swigFunction( "c-function pa_context_exit_daemon pa_context_exit_daemon a a a -- a", "FUNCTION: pa_context_exit_daemon ( c cb userdata -- a )", "EXTERN: \"C\" void * pa_context_exit_daemon( void * c, void * cb, void * userdata );", "	( c cb userdata -- )" );
	swigFunction( "c-function pa_context_set_default_sink pa_context_set_default_sink a s a a -- a", "FUNCTION: pa_context_set_default_sink ( c name cb userdata -- a )", "EXTERN: \"C\" void * pa_context_set_default_sink( void * c, char * name, void * cb, void * userdata );", "	( c name cb userdata -- )" );
	swigFunction( "c-function pa_context_set_default_source pa_context_set_default_source a s a a -- a", "FUNCTION: pa_context_set_default_source ( c name cb userdata -- a )", "EXTERN: \"C\" void * pa_context_set_default_source( void * c, char * name, void * cb, void * userdata );", "	( c name cb userdata -- )" );
	swigFunction( "c-function pa_context_is_local pa_context_is_local a -- n", "FUNCTION: pa_context_is_local ( c -- n )", "EXTERN: \"C\" int pa_context_is_local( void * c );", "	( c -- )" );
	swigFunction( "c-function pa_context_set_name pa_context_set_name a s a a -- a", "FUNCTION: pa_context_set_name ( c name cb userdata -- a )", "EXTERN: \"C\" void * pa_context_set_name( void * c, char * name, void * cb, void * userdata );", "	( c name cb userdata -- )" );
	swigFunction( "c-function pa_context_get_server pa_context_get_server a -- s", "FUNCTION: pa_context_get_server ( c -- s )", "EXTERN: \"C\" char * pa_context_get_server( void * c );", "	( c -- )" );
	swigFunction( "c-function pa_context_get_protocol_version pa_context_get_protocol_version a -- u", "FUNCTION: pa_context_get_protocol_version ( c -- u )", "EXTERN: \"C\" int pa_context_get_protocol_version( void * c );", "	( c -- )" );
	swigFunction( "c-function pa_context_get_server_protocol_version pa_context_get_server_protocol_version a -- u", "FUNCTION: pa_context_get_server_protocol_version ( c -- u )", "EXTERN: \"C\" int pa_context_get_server_protocol_version( void * c );", "	( c -- )" );
	swigFunction( "c-function pa_context_proplist_update pa_context_proplist_update a n a a a -- a", "FUNCTION: pa_context_proplist_update ( c mode p cb userdata -- a )", "EXTERN: \"C\" void * pa_context_proplist_update( void * c, int mode, void * p, void * cb, void * userdata );", "	( c mode p cb userdata -- )" );
	swigFunction( "c-function pa_context_proplist_remove pa_context_proplist_remove a a a a -- a", "FUNCTION: pa_context_proplist_remove ( c keys cb userdata -- a )", "EXTERN: \"C\" void * pa_context_proplist_remove( void * c, void * keys, void * cb, void * userdata );", "	( c keys cb userdata -- )" );
	swigFunction( "c-function pa_context_get_index pa_context_get_index a -- u", "FUNCTION: pa_context_get_index ( s -- u )", "EXTERN: \"C\" int pa_context_get_index( void * s );", "	( s -- )" );
	swigFunction( "c-function pa_context_rttime_new pa_context_rttime_new a u a a -- a", "FUNCTION: pa_context_rttime_new ( c usec cb userdata -- a )", "EXTERN: \"C\" void * pa_context_rttime_new( void * c, int usec, void * cb, void * userdata );", "	( c usec cb userdata -- )" );
	swigFunction( "c-function pa_context_rttime_restart pa_context_rttime_restart a a u -- void", "FUNCTION: pa_context_rttime_restart ( c e usec -- void )", "EXTERN: \"C\" void pa_context_rttime_restart( void * c, void * e, int usec );", "	( c e usec -- )" );
	swigFunction( "c-function pa_context_get_tile_size pa_context_get_tile_size a a -- u", "FUNCTION: pa_context_get_tile_size ( c ss -- u )", "EXTERN: \"C\" int pa_context_get_tile_size( void * c, void * ss );", "	( c ss -- )" );
	swigFunction( "c-function pa_context_load_cookie_from_file pa_context_load_cookie_from_file a s -- n", "FUNCTION: pa_context_load_cookie_from_file ( c cookie_file_path -- n )", "EXTERN: \"C\" int pa_context_load_cookie_from_file( void * c, char * cookie_file_path );", "	( c cookie_file_path -- )" );
	swigFunction( "c-function pa_stream_new pa_stream_new a s a a -- a", "FUNCTION: pa_stream_new ( c name ss map -- a )", "EXTERN: \"C\" void * pa_stream_new( void * c, char * name, void * ss, void * map );", "	( c name ss map -- )" );
	swigFunction( "c-function pa_stream_new_with_proplist pa_stream_new_with_proplist a s a a a -- a", "FUNCTION: pa_stream_new_with_proplist ( c name ss map p -- a )", "EXTERN: \"C\" void * pa_stream_new_with_proplist( void * c, char * name, void * ss, void * map, void * p );", "	( c name ss map p -- )" );
	swigFunction( "c-function pa_stream_new_extended pa_stream_new_extended a s a u a -- a", "FUNCTION: pa_stream_new_extended ( c name formats n_formats p -- a )", "EXTERN: \"C\" void * pa_stream_new_extended( void * c, char * name, void * formats, int n_formats, void * p );", "	( c name formats n_formats p -- )" );
	swigFunction( "c-function pa_stream_unref pa_stream_unref a -- void", "FUNCTION: pa_stream_unref ( s -- void )", "EXTERN: \"C\" void pa_stream_unref( void * s );", "	( s -- )" );
	swigFunction( "c-function pa_stream_ref pa_stream_ref a -- a", "FUNCTION: pa_stream_ref ( s -- a )", "EXTERN: \"C\" void * pa_stream_ref( void * s );", "	( s -- )" );
	swigFunction( "c-function pa_stream_get_state pa_stream_get_state a -- n", "FUNCTION: pa_stream_get_state ( p -- n )", "EXTERN: \"C\" int pa_stream_get_state( void * p );", "	( p -- )" );
	swigFunction( "c-function pa_stream_get_context pa_stream_get_context a -- a", "FUNCTION: pa_stream_get_context ( p -- a )", "EXTERN: \"C\" void * pa_stream_get_context( void * p );", "	( p -- )" );
	swigFunction( "c-function pa_stream_get_index pa_stream_get_index a -- u", "FUNCTION: pa_stream_get_index ( s -- u )", "EXTERN: \"C\" int pa_stream_get_index( void * s );", "	( s -- )" );
	swigFunction( "c-function pa_stream_get_device_index pa_stream_get_device_index a -- u", "FUNCTION: pa_stream_get_device_index ( s -- u )", "EXTERN: \"C\" int pa_stream_get_device_index( void * s );", "	( s -- )" );
	swigFunction( "c-function pa_stream_get_device_name pa_stream_get_device_name a -- s", "FUNCTION: pa_stream_get_device_name ( s -- s )", "EXTERN: \"C\" char * pa_stream_get_device_name( void * s );", "	( s -- )" );
	swigFunction( "c-function pa_stream_is_suspended pa_stream_is_suspended a -- n", "FUNCTION: pa_stream_is_suspended ( s -- n )", "EXTERN: \"C\" int pa_stream_is_suspended( void * s );", "	( s -- )" );
	swigFunction( "c-function pa_stream_is_corked pa_stream_is_corked a -- n", "FUNCTION: pa_stream_is_corked ( s -- n )", "EXTERN: \"C\" int pa_stream_is_corked( void * s );", "	( s -- )" );
	swigFunction( "c-function pa_stream_connect_playback pa_stream_connect_playback a s a n a a -- n", "FUNCTION: pa_stream_connect_playback ( s dev attr flags volume sync_stream -- n )", "EXTERN: \"C\" int pa_stream_connect_playback( void * s, char * dev, void * attr, int flags, void * volume, void * sync_stream );", "	( s dev attr flags volume sync_stream -- )" );
	swigFunction( "c-function pa_stream_connect_record pa_stream_connect_record a s a n -- n", "FUNCTION: pa_stream_connect_record ( s dev attr flags -- n )", "EXTERN: \"C\" int pa_stream_connect_record( void * s, char * dev, void * attr, int flags );", "	( s dev attr flags -- )" );
	swigFunction( "c-function pa_stream_disconnect pa_stream_disconnect a -- n", "FUNCTION: pa_stream_disconnect ( s -- n )", "EXTERN: \"C\" int pa_stream_disconnect( void * s );", "	( s -- )" );
	swigFunction( "c-function pa_stream_begin_write pa_stream_begin_write a a a -- n", "FUNCTION: pa_stream_begin_write ( p data nbytes -- n )", "EXTERN: \"C\" int pa_stream_begin_write( void * p, void * data, void * nbytes );", "	( p data nbytes -- )" );
	swigFunction( "c-function pa_stream_cancel_write pa_stream_cancel_write a -- n", "FUNCTION: pa_stream_cancel_write ( p -- n )", "EXTERN: \"C\" int pa_stream_cancel_write( void * p );", "	( p -- )" );
	swigFunction( "c-function pa_stream_write pa_stream_write a a u a d n -- n", "FUNCTION: pa_stream_write ( p data nbytes free_cb offset seek -- n )", "EXTERN: \"C\" int pa_stream_write( void * p, void * data, int nbytes, void * free_cb, long long offset, int seek );", "	( p data nbytes free_cb offset seek -- )" );
	swigFunction( "c-function pa_stream_write_ext_free pa_stream_write_ext_free a a u a a d n -- n", "FUNCTION: pa_stream_write_ext_free ( p data nbytes free_cb free_cb_data offset seek -- n )", "EXTERN: \"C\" int pa_stream_write_ext_free( void * p, void * data, int nbytes, void * free_cb, void * free_cb_data, long long offset, int seek );", "	( p data nbytes free_cb free_cb_data offset seek -- )" );
	swigFunction( "c-function pa_stream_peek pa_stream_peek a a a -- n", "FUNCTION: pa_stream_peek ( p data nbytes -- n )", "EXTERN: \"C\" int pa_stream_peek( void * p, void * data, void * nbytes );", "	( p data nbytes -- )" );
	swigFunction( "c-function pa_stream_drop pa_stream_drop a -- n", "FUNCTION: pa_stream_drop ( p -- n )", "EXTERN: \"C\" int pa_stream_drop( void * p );", "	( p -- )" );
	swigFunction( "c-function pa_stream_writable_size pa_stream_writable_size a -- u", "FUNCTION: pa_stream_writable_size ( p -- u )", "EXTERN: \"C\" int pa_stream_writable_size( void * p );", "	( p -- )" );
	swigFunction( "c-function pa_stream_readable_size pa_stream_readable_size a -- u", "FUNCTION: pa_stream_readable_size ( p -- u )", "EXTERN: \"C\" int pa_stream_readable_size( void * p );", "	( p -- )" );
	swigFunction( "c-function pa_stream_drain pa_stream_drain a a a -- a", "FUNCTION: pa_stream_drain ( s cb userdata -- a )", "EXTERN: \"C\" void * pa_stream_drain( void * s, void * cb, void * userdata );", "	( s cb userdata -- )" );
	swigFunction( "c-function pa_stream_update_timing_info pa_stream_update_timing_info a a a -- a", "FUNCTION: pa_stream_update_timing_info ( p cb userdata -- a )", "EXTERN: \"C\" void * pa_stream_update_timing_info( void * p, void * cb, void * userdata );", "	( p cb userdata -- )" );
	swigFunction( "c-function pa_stream_set_state_callback pa_stream_set_state_callback a a a -- void", "FUNCTION: pa_stream_set_state_callback ( s cb userdata -- void )", "EXTERN: \"C\" void pa_stream_set_state_callback( void * s, void * cb, void * userdata );", "	( s cb userdata -- )" );
	swigFunction( "c-function pa_stream_set_write_callback pa_stream_set_write_callback a a a -- void", "FUNCTION: pa_stream_set_write_callback ( p cb userdata -- void )", "EXTERN: \"C\" void pa_stream_set_write_callback( void * p, void * cb, void * userdata );", "	( p cb userdata -- )" );
	swigFunction( "c-function pa_stream_set_read_callback pa_stream_set_read_callback a a a -- void", "FUNCTION: pa_stream_set_read_callback ( p cb userdata -- void )", "EXTERN: \"C\" void pa_stream_set_read_callback( void * p, void * cb, void * userdata );", "	( p cb userdata -- )" );
	swigFunction( "c-function pa_stream_set_overflow_callback pa_stream_set_overflow_callback a a a -- void", "FUNCTION: pa_stream_set_overflow_callback ( p cb userdata -- void )", "EXTERN: \"C\" void pa_stream_set_overflow_callback( void * p, void * cb, void * userdata );", "	( p cb userdata -- )" );
	swigFunction( "c-function pa_stream_get_underflow_index pa_stream_get_underflow_index a -- d", "FUNCTION: pa_stream_get_underflow_index ( p -- d )", "EXTERN: \"C\" long long pa_stream_get_underflow_index( void * p );", "	( p -- )" );
	swigFunction( "c-function pa_stream_set_underflow_callback pa_stream_set_underflow_callback a a a -- void", "FUNCTION: pa_stream_set_underflow_callback ( p cb userdata -- void )", "EXTERN: \"C\" void pa_stream_set_underflow_callback( void * p, void * cb, void * userdata );", "	( p cb userdata -- )" );
	swigFunction( "c-function pa_stream_set_started_callback pa_stream_set_started_callback a a a -- void", "FUNCTION: pa_stream_set_started_callback ( p cb userdata -- void )", "EXTERN: \"C\" void pa_stream_set_started_callback( void * p, void * cb, void * userdata );", "	( p cb userdata -- )" );
	swigFunction( "c-function pa_stream_set_latency_update_callback pa_stream_set_latency_update_callback a a a -- void", "FUNCTION: pa_stream_set_latency_update_callback ( p cb userdata -- void )", "EXTERN: \"C\" void pa_stream_set_latency_update_callback( void * p, void * cb, void * userdata );", "	( p cb userdata -- )" );
	swigFunction( "c-function pa_stream_set_moved_callback pa_stream_set_moved_callback a a a -- void", "FUNCTION: pa_stream_set_moved_callback ( p cb userdata -- void )", "EXTERN: \"C\" void pa_stream_set_moved_callback( void * p, void * cb, void * userdata );", "	( p cb userdata -- )" );
	swigFunction( "c-function pa_stream_set_suspended_callback pa_stream_set_suspended_callback a a a -- void", "FUNCTION: pa_stream_set_suspended_callback ( p cb userdata -- void )", "EXTERN: \"C\" void pa_stream_set_suspended_callback( void * p, void * cb, void * userdata );", "	( p cb userdata -- )" );
	swigFunction( "c-function pa_stream_set_event_callback pa_stream_set_event_callback a a a -- void", "FUNCTION: pa_stream_set_event_callback ( p cb userdata -- void )", "EXTERN: \"C\" void pa_stream_set_event_callback( void * p, void * cb, void * userdata );", "	( p cb userdata -- )" );
	swigFunction( "c-function pa_stream_set_buffer_attr_callback pa_stream_set_buffer_attr_callback a a a -- void", "FUNCTION: pa_stream_set_buffer_attr_callback ( p cb userdata -- void )", "EXTERN: \"C\" void pa_stream_set_buffer_attr_callback( void * p, void * cb, void * userdata );", "	( p cb userdata -- )" );
	swigFunction( "c-function pa_stream_cork pa_stream_cork a n a a -- a", "FUNCTION: pa_stream_cork ( s b cb userdata -- a )", "EXTERN: \"C\" void * pa_stream_cork( void * s, int b, void * cb, void * userdata );", "	( s b cb userdata -- )" );
	swigFunction( "c-function pa_stream_flush pa_stream_flush a a a -- a", "FUNCTION: pa_stream_flush ( s cb userdata -- a )", "EXTERN: \"C\" void * pa_stream_flush( void * s, void * cb, void * userdata );", "	( s cb userdata -- )" );
	swigFunction( "c-function pa_stream_prebuf pa_stream_prebuf a a a -- a", "FUNCTION: pa_stream_prebuf ( s cb userdata -- a )", "EXTERN: \"C\" void * pa_stream_prebuf( void * s, void * cb, void * userdata );", "	( s cb userdata -- )" );
	swigFunction( "c-function pa_stream_trigger pa_stream_trigger a a a -- a", "FUNCTION: pa_stream_trigger ( s cb userdata -- a )", "EXTERN: \"C\" void * pa_stream_trigger( void * s, void * cb, void * userdata );", "	( s cb userdata -- )" );
	swigFunction( "c-function pa_stream_set_name pa_stream_set_name a s a a -- a", "FUNCTION: pa_stream_set_name ( s name cb userdata -- a )", "EXTERN: \"C\" void * pa_stream_set_name( void * s, char * name, void * cb, void * userdata );", "	( s name cb userdata -- )" );
	swigFunction( "c-function pa_stream_get_time pa_stream_get_time a a -- n", "FUNCTION: pa_stream_get_time ( s r_usec -- n )", "EXTERN: \"C\" int pa_stream_get_time( void * s, void * r_usec );", "	( s r_usec -- )" );
	swigFunction( "c-function pa_stream_get_latency pa_stream_get_latency a a a -- n", "FUNCTION: pa_stream_get_latency ( s r_usec negative -- n )", "EXTERN: \"C\" int pa_stream_get_latency( void * s, void * r_usec, void * negative );", "	( s r_usec negative -- )" );
	swigFunction( "c-function pa_stream_get_timing_info pa_stream_get_timing_info a -- a", "FUNCTION: pa_stream_get_timing_info ( s -- a )", "EXTERN: \"C\" void * pa_stream_get_timing_info( void * s );", "	( s -- )" );
	swigFunction( "c-function pa_stream_get_sample_spec pa_stream_get_sample_spec a -- a", "FUNCTION: pa_stream_get_sample_spec ( s -- a )", "EXTERN: \"C\" void * pa_stream_get_sample_spec( void * s );", "	( s -- )" );
	swigFunction( "c-function pa_stream_get_channel_map pa_stream_get_channel_map a -- a", "FUNCTION: pa_stream_get_channel_map ( s -- a )", "EXTERN: \"C\" void * pa_stream_get_channel_map( void * s );", "	( s -- )" );
	swigFunction( "c-function pa_stream_get_format_info pa_stream_get_format_info a -- a", "FUNCTION: pa_stream_get_format_info ( s -- a )", "EXTERN: \"C\" void * pa_stream_get_format_info( void * s );", "	( s -- )" );
	swigFunction( "c-function pa_stream_get_buffer_attr pa_stream_get_buffer_attr a -- a", "FUNCTION: pa_stream_get_buffer_attr ( s -- a )", "EXTERN: \"C\" void * pa_stream_get_buffer_attr( void * s );", "	( s -- )" );
	swigFunction( "c-function pa_stream_set_buffer_attr pa_stream_set_buffer_attr a a a a -- a", "FUNCTION: pa_stream_set_buffer_attr ( s attr cb userdata -- a )", "EXTERN: \"C\" void * pa_stream_set_buffer_attr( void * s, void * attr, void * cb, void * userdata );", "	( s attr cb userdata -- )" );
	swigFunction( "c-function pa_stream_update_sample_rate pa_stream_update_sample_rate a u a a -- a", "FUNCTION: pa_stream_update_sample_rate ( s rate cb userdata -- a )", "EXTERN: \"C\" void * pa_stream_update_sample_rate( void * s, int rate, void * cb, void * userdata );", "	( s rate cb userdata -- )" );
	swigFunction( "c-function pa_stream_proplist_update pa_stream_proplist_update a n a a a -- a", "FUNCTION: pa_stream_proplist_update ( s mode p cb userdata -- a )", "EXTERN: \"C\" void * pa_stream_proplist_update( void * s, int mode, void * p, void * cb, void * userdata );", "	( s mode p cb userdata -- )" );
	swigFunction( "c-function pa_stream_proplist_remove pa_stream_proplist_remove a a a a -- a", "FUNCTION: pa_stream_proplist_remove ( s keys cb userdata -- a )", "EXTERN: \"C\" void * pa_stream_proplist_remove( void * s, void * keys, void * cb, void * userdata );", "	( s keys cb userdata -- )" );
	swigFunction( "c-function pa_stream_set_monitor_stream pa_stream_set_monitor_stream a u -- n", "FUNCTION: pa_stream_set_monitor_stream ( s sink_input_idx -- n )", "EXTERN: \"C\" int pa_stream_set_monitor_stream( void * s, int sink_input_idx );", "	( s sink_input_idx -- )" );
	swigFunction( "c-function pa_stream_get_monitor_stream pa_stream_get_monitor_stream a -- u", "FUNCTION: pa_stream_get_monitor_stream ( s -- u )", "EXTERN: \"C\" int pa_stream_get_monitor_stream( void * s );", "	( s -- )" );
	swigFunction( "c-function pa_context_get_sink_info_by_name pa_context_get_sink_info_by_name a s a a -- a", "FUNCTION: pa_context_get_sink_info_by_name ( c name cb userdata -- a )", "EXTERN: \"C\" void * pa_context_get_sink_info_by_name( void * c, char * name, void * cb, void * userdata );", "	( c name cb userdata -- )" );
	swigFunction( "c-function pa_context_get_sink_info_by_index pa_context_get_sink_info_by_index a u a a -- a", "FUNCTION: pa_context_get_sink_info_by_index ( c idx cb userdata -- a )", "EXTERN: \"C\" void * pa_context_get_sink_info_by_index( void * c, int idx, void * cb, void * userdata );", "	( c idx cb userdata -- )" );
	swigFunction( "c-function pa_context_get_sink_info_list pa_context_get_sink_info_list a a a -- a", "FUNCTION: pa_context_get_sink_info_list ( c cb userdata -- a )", "EXTERN: \"C\" void * pa_context_get_sink_info_list( void * c, void * cb, void * userdata );", "	( c cb userdata -- )" );
	swigFunction( "c-function pa_context_set_sink_volume_by_index pa_context_set_sink_volume_by_index a u a a a -- a", "FUNCTION: pa_context_set_sink_volume_by_index ( c idx volume cb userdata -- a )", "EXTERN: \"C\" void * pa_context_set_sink_volume_by_index( void * c, int idx, void * volume, void * cb, void * userdata );", "	( c idx volume cb userdata -- )" );
	swigFunction( "c-function pa_context_set_sink_volume_by_name pa_context_set_sink_volume_by_name a s a a a -- a", "FUNCTION: pa_context_set_sink_volume_by_name ( c name volume cb userdata -- a )", "EXTERN: \"C\" void * pa_context_set_sink_volume_by_name( void * c, char * name, void * volume, void * cb, void * userdata );", "	( c name volume cb userdata -- )" );
	swigFunction( "c-function pa_context_set_sink_mute_by_index pa_context_set_sink_mute_by_index a u n a a -- a", "FUNCTION: pa_context_set_sink_mute_by_index ( c idx mute cb userdata -- a )", "EXTERN: \"C\" void * pa_context_set_sink_mute_by_index( void * c, int idx, int mute, void * cb, void * userdata );", "	( c idx mute cb userdata -- )" );
	swigFunction( "c-function pa_context_set_sink_mute_by_name pa_context_set_sink_mute_by_name a s n a a -- a", "FUNCTION: pa_context_set_sink_mute_by_name ( c name mute cb userdata -- a )", "EXTERN: \"C\" void * pa_context_set_sink_mute_by_name( void * c, char * name, int mute, void * cb, void * userdata );", "	( c name mute cb userdata -- )" );
	swigFunction( "c-function pa_context_suspend_sink_by_name pa_context_suspend_sink_by_name a s n a a -- a", "FUNCTION: pa_context_suspend_sink_by_name ( c sink_name suspend cb userdata -- a )", "EXTERN: \"C\" void * pa_context_suspend_sink_by_name( void * c, char * sink_name, int suspend, void * cb, void * userdata );", "	( c sink_name suspend cb userdata -- )" );
	swigFunction( "c-function pa_context_suspend_sink_by_index pa_context_suspend_sink_by_index a u n a a -- a", "FUNCTION: pa_context_suspend_sink_by_index ( c idx suspend cb userdata -- a )", "EXTERN: \"C\" void * pa_context_suspend_sink_by_index( void * c, int idx, int suspend, void * cb, void * userdata );", "	( c idx suspend cb userdata -- )" );
	swigFunction( "c-function pa_context_set_sink_port_by_index pa_context_set_sink_port_by_index a u s a a -- a", "FUNCTION: pa_context_set_sink_port_by_index ( c idx port cb userdata -- a )", "EXTERN: \"C\" void * pa_context_set_sink_port_by_index( void * c, int idx, char * port, void * cb, void * userdata );", "	( c idx port cb userdata -- )" );
	swigFunction( "c-function pa_context_set_sink_port_by_name pa_context_set_sink_port_by_name a s s a a -- a", "FUNCTION: pa_context_set_sink_port_by_name ( c name port cb userdata -- a )", "EXTERN: \"C\" void * pa_context_set_sink_port_by_name( void * c, char * name, char * port, void * cb, void * userdata );", "	( c name port cb userdata -- )" );
	swigFunction( "c-function pa_context_get_source_info_by_name pa_context_get_source_info_by_name a s a a -- a", "FUNCTION: pa_context_get_source_info_by_name ( c name cb userdata -- a )", "EXTERN: \"C\" void * pa_context_get_source_info_by_name( void * c, char * name, void * cb, void * userdata );", "	( c name cb userdata -- )" );
	swigFunction( "c-function pa_context_get_source_info_by_index pa_context_get_source_info_by_index a u a a -- a", "FUNCTION: pa_context_get_source_info_by_index ( c idx cb userdata -- a )", "EXTERN: \"C\" void * pa_context_get_source_info_by_index( void * c, int idx, void * cb, void * userdata );", "	( c idx cb userdata -- )" );
	swigFunction( "c-function pa_context_get_source_info_list pa_context_get_source_info_list a a a -- a", "FUNCTION: pa_context_get_source_info_list ( c cb userdata -- a )", "EXTERN: \"C\" void * pa_context_get_source_info_list( void * c, void * cb, void * userdata );", "	( c cb userdata -- )" );
	swigFunction( "c-function pa_context_set_source_volume_by_index pa_context_set_source_volume_by_index a u a a a -- a", "FUNCTION: pa_context_set_source_volume_by_index ( c idx volume cb userdata -- a )", "EXTERN: \"C\" void * pa_context_set_source_volume_by_index( void * c, int idx, void * volume, void * cb, void * userdata );", "	( c idx volume cb userdata -- )" );
	swigFunction( "c-function pa_context_set_source_volume_by_name pa_context_set_source_volume_by_name a s a a a -- a", "FUNCTION: pa_context_set_source_volume_by_name ( c name volume cb userdata -- a )", "EXTERN: \"C\" void * pa_context_set_source_volume_by_name( void * c, char * name, void * volume, void * cb, void * userdata );", "	( c name volume cb userdata -- )" );
	swigFunction( "c-function pa_context_set_source_mute_by_index pa_context_set_source_mute_by_index a u n a a -- a", "FUNCTION: pa_context_set_source_mute_by_index ( c idx mute cb userdata -- a )", "EXTERN: \"C\" void * pa_context_set_source_mute_by_index( void * c, int idx, int mute, void * cb, void * userdata );", "	( c idx mute cb userdata -- )" );
	swigFunction( "c-function pa_context_set_source_mute_by_name pa_context_set_source_mute_by_name a s n a a -- a", "FUNCTION: pa_context_set_source_mute_by_name ( c name mute cb userdata -- a )", "EXTERN: \"C\" void * pa_context_set_source_mute_by_name( void * c, char * name, int mute, void * cb, void * userdata );", "	( c name mute cb userdata -- )" );
	swigFunction( "c-function pa_context_suspend_source_by_name pa_context_suspend_source_by_name a s n a a -- a", "FUNCTION: pa_context_suspend_source_by_name ( c source_name suspend cb userdata -- a )", "EXTERN: \"C\" void * pa_context_suspend_source_by_name( void * c, char * source_name, int suspend, void * cb, void * userdata );", "	( c source_name suspend cb userdata -- )" );
	swigFunction( "c-function pa_context_suspend_source_by_index pa_context_suspend_source_by_index a u n a a -- a", "FUNCTION: pa_context_suspend_source_by_index ( c idx suspend cb userdata -- a )", "EXTERN: \"C\" void * pa_context_suspend_source_by_index( void * c, int idx, int suspend, void * cb, void * userdata );", "	( c idx suspend cb userdata -- )" );
	swigFunction( "c-function pa_context_set_source_port_by_index pa_context_set_source_port_by_index a u s a a -- a", "FUNCTION: pa_context_set_source_port_by_index ( c idx port cb userdata -- a )", "EXTERN: \"C\" void * pa_context_set_source_port_by_index( void * c, int idx, char * port, void * cb, void * userdata );", "	( c idx port cb userdata -- )" );
	swigFunction( "c-function pa_context_set_source_port_by_name pa_context_set_source_port_by_name a s s a a -- a", "FUNCTION: pa_context_set_source_port_by_name ( c name port cb userdata -- a )", "EXTERN: \"C\" void * pa_context_set_source_port_by_name( void * c, char * name, char * port, void * cb, void * userdata );", "	( c name port cb userdata -- )" );
	swigFunction( "c-function pa_context_get_server_info pa_context_get_server_info a a a -- a", "FUNCTION: pa_context_get_server_info ( c cb userdata -- a )", "EXTERN: \"C\" void * pa_context_get_server_info( void * c, void * cb, void * userdata );", "	( c cb userdata -- )" );
	swigFunction( "c-function pa_context_get_module_info pa_context_get_module_info a u a a -- a", "FUNCTION: pa_context_get_module_info ( c idx cb userdata -- a )", "EXTERN: \"C\" void * pa_context_get_module_info( void * c, int idx, void * cb, void * userdata );", "	( c idx cb userdata -- )" );
	swigFunction( "c-function pa_context_get_module_info_list pa_context_get_module_info_list a a a -- a", "FUNCTION: pa_context_get_module_info_list ( c cb userdata -- a )", "EXTERN: \"C\" void * pa_context_get_module_info_list( void * c, void * cb, void * userdata );", "	( c cb userdata -- )" );
	swigFunction( "c-function pa_context_load_module pa_context_load_module a s s a a -- a", "FUNCTION: pa_context_load_module ( c name argument cb userdata -- a )", "EXTERN: \"C\" void * pa_context_load_module( void * c, char * name, char * argument, void * cb, void * userdata );", "	( c name argument cb userdata -- )" );
	swigFunction( "c-function pa_context_unload_module pa_context_unload_module a u a a -- a", "FUNCTION: pa_context_unload_module ( c idx cb userdata -- a )", "EXTERN: \"C\" void * pa_context_unload_module( void * c, int idx, void * cb, void * userdata );", "	( c idx cb userdata -- )" );
	swigFunction( "c-function pa_context_send_message_to_object pa_context_send_message_to_object a s s s a a -- a", "FUNCTION: pa_context_send_message_to_object ( c recipient_name message message_parameters cb userdata -- a )", "EXTERN: \"C\" void * pa_context_send_message_to_object( void * c, char * recipient_name, char * message, char * message_parameters, void * cb, void * userdata );", "	( c recipient_name message message_parameters cb userdata -- )" );
	swigFunction( "c-function pa_context_get_client_info pa_context_get_client_info a u a a -- a", "FUNCTION: pa_context_get_client_info ( c idx cb userdata -- a )", "EXTERN: \"C\" void * pa_context_get_client_info( void * c, int idx, void * cb, void * userdata );", "	( c idx cb userdata -- )" );
	swigFunction( "c-function pa_context_get_client_info_list pa_context_get_client_info_list a a a -- a", "FUNCTION: pa_context_get_client_info_list ( c cb userdata -- a )", "EXTERN: \"C\" void * pa_context_get_client_info_list( void * c, void * cb, void * userdata );", "	( c cb userdata -- )" );
	swigFunction( "c-function pa_context_kill_client pa_context_kill_client a u a a -- a", "FUNCTION: pa_context_kill_client ( c idx cb userdata -- a )", "EXTERN: \"C\" void * pa_context_kill_client( void * c, int idx, void * cb, void * userdata );", "	( c idx cb userdata -- )" );
	swigFunction( "c-function pa_context_get_card_info_by_index pa_context_get_card_info_by_index a u a a -- a", "FUNCTION: pa_context_get_card_info_by_index ( c idx cb userdata -- a )", "EXTERN: \"C\" void * pa_context_get_card_info_by_index( void * c, int idx, void * cb, void * userdata );", "	( c idx cb userdata -- )" );
	swigFunction( "c-function pa_context_get_card_info_by_name pa_context_get_card_info_by_name a s a a -- a", "FUNCTION: pa_context_get_card_info_by_name ( c name cb userdata -- a )", "EXTERN: \"C\" void * pa_context_get_card_info_by_name( void * c, char * name, void * cb, void * userdata );", "	( c name cb userdata -- )" );
	swigFunction( "c-function pa_context_get_card_info_list pa_context_get_card_info_list a a a -- a", "FUNCTION: pa_context_get_card_info_list ( c cb userdata -- a )", "EXTERN: \"C\" void * pa_context_get_card_info_list( void * c, void * cb, void * userdata );", "	( c cb userdata -- )" );
	swigFunction( "c-function pa_context_set_card_profile_by_index pa_context_set_card_profile_by_index a u s a a -- a", "FUNCTION: pa_context_set_card_profile_by_index ( c idx profile cb userdata -- a )", "EXTERN: \"C\" void * pa_context_set_card_profile_by_index( void * c, int idx, char * profile, void * cb, void * userdata );", "	( c idx profile cb userdata -- )" );
	swigFunction( "c-function pa_context_set_card_profile_by_name pa_context_set_card_profile_by_name a s s a a -- a", "FUNCTION: pa_context_set_card_profile_by_name ( c name profile cb userdata -- a )", "EXTERN: \"C\" void * pa_context_set_card_profile_by_name( void * c, char * name, char * profile, void * cb, void * userdata );", "	( c name profile cb userdata -- )" );
	swigFunction( "c-function pa_context_set_port_latency_offset pa_context_set_port_latency_offset a s s d a a -- a", "FUNCTION: pa_context_set_port_latency_offset ( c card_name port_name offset cb userdata -- a )", "EXTERN: \"C\" void * pa_context_set_port_latency_offset( void * c, char * card_name, char * port_name, long long offset, void * cb, void * userdata );", "	( c card_name port_name offset cb userdata -- )" );
	swigFunction( "c-function pa_context_get_sink_input_info pa_context_get_sink_input_info a u a a -- a", "FUNCTION: pa_context_get_sink_input_info ( c idx cb userdata -- a )", "EXTERN: \"C\" void * pa_context_get_sink_input_info( void * c, int idx, void * cb, void * userdata );", "	( c idx cb userdata -- )" );
	swigFunction( "c-function pa_context_get_sink_input_info_list pa_context_get_sink_input_info_list a a a -- a", "FUNCTION: pa_context_get_sink_input_info_list ( c cb userdata -- a )", "EXTERN: \"C\" void * pa_context_get_sink_input_info_list( void * c, void * cb, void * userdata );", "	( c cb userdata -- )" );
	swigFunction( "c-function pa_context_move_sink_input_by_name pa_context_move_sink_input_by_name a u s a a -- a", "FUNCTION: pa_context_move_sink_input_by_name ( c idx sink_name cb userdata -- a )", "EXTERN: \"C\" void * pa_context_move_sink_input_by_name( void * c, int idx, char * sink_name, void * cb, void * userdata );", "	( c idx sink_name cb userdata -- )" );
	swigFunction( "c-function pa_context_move_sink_input_by_index pa_context_move_sink_input_by_index a u u a a -- a", "FUNCTION: pa_context_move_sink_input_by_index ( c idx sink_idx cb userdata -- a )", "EXTERN: \"C\" void * pa_context_move_sink_input_by_index( void * c, int idx, int sink_idx, void * cb, void * userdata );", "	( c idx sink_idx cb userdata -- )" );
	swigFunction( "c-function pa_context_set_sink_input_volume pa_context_set_sink_input_volume a u a a a -- a", "FUNCTION: pa_context_set_sink_input_volume ( c idx volume cb userdata -- a )", "EXTERN: \"C\" void * pa_context_set_sink_input_volume( void * c, int idx, void * volume, void * cb, void * userdata );", "	( c idx volume cb userdata -- )" );
	swigFunction( "c-function pa_context_set_sink_input_mute pa_context_set_sink_input_mute a u n a a -- a", "FUNCTION: pa_context_set_sink_input_mute ( c idx mute cb userdata -- a )", "EXTERN: \"C\" void * pa_context_set_sink_input_mute( void * c, int idx, int mute, void * cb, void * userdata );", "	( c idx mute cb userdata -- )" );
	swigFunction( "c-function pa_context_kill_sink_input pa_context_kill_sink_input a u a a -- a", "FUNCTION: pa_context_kill_sink_input ( c idx cb userdata -- a )", "EXTERN: \"C\" void * pa_context_kill_sink_input( void * c, int idx, void * cb, void * userdata );", "	( c idx cb userdata -- )" );
	swigFunction( "c-function pa_context_get_source_output_info pa_context_get_source_output_info a u a a -- a", "FUNCTION: pa_context_get_source_output_info ( c idx cb userdata -- a )", "EXTERN: \"C\" void * pa_context_get_source_output_info( void * c, int idx, void * cb, void * userdata );", "	( c idx cb userdata -- )" );
	swigFunction( "c-function pa_context_get_source_output_info_list pa_context_get_source_output_info_list a a a -- a", "FUNCTION: pa_context_get_source_output_info_list ( c cb userdata -- a )", "EXTERN: \"C\" void * pa_context_get_source_output_info_list( void * c, void * cb, void * userdata );", "	( c cb userdata -- )" );
	swigFunction( "c-function pa_context_move_source_output_by_name pa_context_move_source_output_by_name a u s a a -- a", "FUNCTION: pa_context_move_source_output_by_name ( c idx source_name cb userdata -- a )", "EXTERN: \"C\" void * pa_context_move_source_output_by_name( void * c, int idx, char * source_name, void * cb, void * userdata );", "	( c idx source_name cb userdata -- )" );
	swigFunction( "c-function pa_context_move_source_output_by_index pa_context_move_source_output_by_index a u u a a -- a", "FUNCTION: pa_context_move_source_output_by_index ( c idx source_idx cb userdata -- a )", "EXTERN: \"C\" void * pa_context_move_source_output_by_index( void * c, int idx, int source_idx, void * cb, void * userdata );", "	( c idx source_idx cb userdata -- )" );
	swigFunction( "c-function pa_context_set_source_output_volume pa_context_set_source_output_volume a u a a a -- a", "FUNCTION: pa_context_set_source_output_volume ( c idx volume cb userdata -- a )", "EXTERN: \"C\" void * pa_context_set_source_output_volume( void * c, int idx, void * volume, void * cb, void * userdata );", "	( c idx volume cb userdata -- )" );
	swigFunction( "c-function pa_context_set_source_output_mute pa_context_set_source_output_mute a u n a a -- a", "FUNCTION: pa_context_set_source_output_mute ( c idx mute cb userdata -- a )", "EXTERN: \"C\" void * pa_context_set_source_output_mute( void * c, int idx, int mute, void * cb, void * userdata );", "	( c idx mute cb userdata -- )" );
	swigFunction( "c-function pa_context_kill_source_output pa_context_kill_source_output a u a a -- a", "FUNCTION: pa_context_kill_source_output ( c idx cb userdata -- a )", "EXTERN: \"C\" void * pa_context_kill_source_output( void * c, int idx, void * cb, void * userdata );", "	( c idx cb userdata -- )" );
	swigFunction( "c-function pa_context_stat pa_context_stat a a a -- a", "FUNCTION: pa_context_stat ( c cb userdata -- a )", "EXTERN: \"C\" void * pa_context_stat( void * c, void * cb, void * userdata );", "	( c cb userdata -- )" );
	swigFunction( "c-function pa_context_get_sample_info_by_name pa_context_get_sample_info_by_name a s a a -- a", "FUNCTION: pa_context_get_sample_info_by_name ( c name cb userdata -- a )", "EXTERN: \"C\" void * pa_context_get_sample_info_by_name( void * c, char * name, void * cb, void * userdata );", "	( c name cb userdata -- )" );
	swigFunction( "c-function pa_context_get_sample_info_by_index pa_context_get_sample_info_by_index a u a a -- a", "FUNCTION: pa_context_get_sample_info_by_index ( c idx cb userdata -- a )", "EXTERN: \"C\" void * pa_context_get_sample_info_by_index( void * c, int idx, void * cb, void * userdata );", "	( c idx cb userdata -- )" );
	swigFunction( "c-function pa_context_get_sample_info_list pa_context_get_sample_info_list a a a -- a", "FUNCTION: pa_context_get_sample_info_list ( c cb userdata -- a )", "EXTERN: \"C\" void * pa_context_get_sample_info_list( void * c, void * cb, void * userdata );", "	( c cb userdata -- )" );
	swigFunction( "c-function pa_context_get_autoload_info_by_name pa_context_get_autoload_info_by_name a s n a a -- a", "FUNCTION: pa_context_get_autoload_info_by_name ( c name type cb userdata -- a )", "EXTERN: \"C\" void * pa_context_get_autoload_info_by_name( void * c, char * name, int type, void * cb, void * userdata );", "	( c name type cb userdata -- )" );
	swigFunction( "c-function pa_context_get_autoload_info_by_index pa_context_get_autoload_info_by_index a u a a -- a", "FUNCTION: pa_context_get_autoload_info_by_index ( c idx cb userdata -- a )", "EXTERN: \"C\" void * pa_context_get_autoload_info_by_index( void * c, int idx, void * cb, void * userdata );", "	( c idx cb userdata -- )" );
	swigFunction( "c-function pa_context_get_autoload_info_list pa_context_get_autoload_info_list a a a -- a", "FUNCTION: pa_context_get_autoload_info_list ( c cb userdata -- a )", "EXTERN: \"C\" void * pa_context_get_autoload_info_list( void * c, void * cb, void * userdata );", "	( c cb userdata -- )" );
	swigFunction( "c-function pa_context_add_autoload pa_context_add_autoload a s n s s a a -- a", "FUNCTION: pa_context_add_autoload ( c name type module argument  userdata -- a )", "EXTERN: \"C\" void * pa_context_add_autoload( void * c, char * name, int type, char * module, char * argument, void * , void * userdata );", "	( c name type module argument <noname> userdata -- )" );
	swigFunction( "c-function pa_context_remove_autoload_by_name pa_context_remove_autoload_by_name a s n a a -- a", "FUNCTION: pa_context_remove_autoload_by_name ( c name type cb userdata -- a )", "EXTERN: \"C\" void * pa_context_remove_autoload_by_name( void * c, char * name, int type, void * cb, void * userdata );", "	( c name type cb userdata -- )" );
	swigFunction( "c-function pa_context_remove_autoload_by_index pa_context_remove_autoload_by_index a u a a -- a", "FUNCTION: pa_context_remove_autoload_by_index ( c idx cb userdata -- a )", "EXTERN: \"C\" void * pa_context_remove_autoload_by_index( void * c, int idx, void * cb, void * userdata );", "	( c idx cb userdata -- )" );
	swigFunction( "c-function pa_context_subscribe pa_context_subscribe a n a a -- a", "FUNCTION: pa_context_subscribe ( c m cb userdata -- a )", "EXTERN: \"C\" void * pa_context_subscribe( void * c, int m, void * cb, void * userdata );", "	( c m cb userdata -- )" );
	swigFunction( "c-function pa_context_set_subscribe_callback pa_context_set_subscribe_callback a a a -- void", "FUNCTION: pa_context_set_subscribe_callback ( c cb userdata -- void )", "EXTERN: \"C\" void pa_context_set_subscribe_callback( void * c, void * cb, void * userdata );", "	( c cb userdata -- )" );
	swigFunction( "c-function pa_stream_connect_upload pa_stream_connect_upload a u -- n", "FUNCTION: pa_stream_connect_upload ( s length -- n )", "EXTERN: \"C\" int pa_stream_connect_upload( void * s, int length );", "	( s length -- )" );
	swigFunction( "c-function pa_stream_finish_upload pa_stream_finish_upload a -- n", "FUNCTION: pa_stream_finish_upload ( s -- n )", "EXTERN: \"C\" int pa_stream_finish_upload( void * s );", "	( s -- )" );
	swigFunction( "c-function pa_context_remove_sample pa_context_remove_sample a s a a -- a", "FUNCTION: pa_context_remove_sample ( c name cb userdata -- a )", "EXTERN: \"C\" void * pa_context_remove_sample( void * c, char * name, void * cb, void * userdata );", "	( c name cb userdata -- )" );
	swigFunction( "c-function pa_context_play_sample pa_context_play_sample a s s u a a -- a", "FUNCTION: pa_context_play_sample ( c name dev volume cb userdata -- a )", "EXTERN: \"C\" void * pa_context_play_sample( void * c, char * name, char * dev, int volume, void * cb, void * userdata );", "	( c name dev volume cb userdata -- )" );
	swigFunction( "c-function pa_context_play_sample_with_proplist pa_context_play_sample_with_proplist a s s u a a a -- a", "FUNCTION: pa_context_play_sample_with_proplist ( c name dev volume proplist cb userdata -- a )", "EXTERN: \"C\" void * pa_context_play_sample_with_proplist( void * c, char * name, char * dev, int volume, void * proplist, void * cb, void * userdata );", "	( c name dev volume proplist cb userdata -- )" );
	swigFunction( "c-function pa_get_library_version pa_get_library_version  -- s", "FUNCTION: pa_get_library_version (  -- s )", "EXTERN: \"C\" char * pa_get_library_version(  );", "	( -- )" );
	swigFunction( "c-function pa_strerror pa_strerror n -- s", "FUNCTION: pa_strerror ( error -- s )", "EXTERN: \"C\" char * pa_strerror( int error );", "	( error -- )" );
	swigFunction( "c-function pa_operation_ref pa_operation_ref a -- a", "FUNCTION: pa_operation_ref ( o -- a )", "EXTERN: \"C\" void * pa_operation_ref( void * o );", "	( o -- )" );
	swigFunction( "c-function pa_operation_unref pa_operation_unref a -- void", "FUNCTION: pa_operation_unref ( o -- void )", "EXTERN: \"C\" void pa_operation_unref( void * o );", "	( o -- )" );
	swigFunction( "c-function pa_operation_cancel pa_operation_cancel a -- void", "FUNCTION: pa_operation_cancel ( o -- void )", "EXTERN: \"C\" void pa_operation_cancel( void * o );", "	( o -- )" );
	swigFunction( "c-function pa_operation_get_state pa_operation_get_state a -- n", "FUNCTION: pa_operation_get_state ( o -- n )", "EXTERN: \"C\" int pa_operation_get_state( void * o );", "	( o -- )" );
	swigFunction( "c-function pa_operation_set_state_callback pa_operation_set_state_callback a a a -- void", "FUNCTION: pa_operation_set_state_callback ( o cb userdata -- void )", "EXTERN: \"C\" void pa_operation_set_state_callback( void * o, void * cb, void * userdata );", "	( o cb userdata -- )" );
	swigFunction( "c-function pa_channel_map_init pa_channel_map_init a -- a", "FUNCTION: pa_channel_map_init ( m -- a )", "EXTERN: \"C\" void * pa_channel_map_init( void * m );", "	( m -- )" );
	swigFunction( "c-function pa_channel_map_init_mono pa_channel_map_init_mono a -- a", "FUNCTION: pa_channel_map_init_mono ( m -- a )", "EXTERN: \"C\" void * pa_channel_map_init_mono( void * m );", "	( m -- )" );
	swigFunction( "c-function pa_channel_map_init_stereo pa_channel_map_init_stereo a -- a", "FUNCTION: pa_channel_map_init_stereo ( m -- a )", "EXTERN: \"C\" void * pa_channel_map_init_stereo( void * m );", "	( m -- )" );
	swigFunction( "c-function pa_channel_map_init_auto pa_channel_map_init_auto a u n -- a", "FUNCTION: pa_channel_map_init_auto ( m channels def -- a )", "EXTERN: \"C\" void * pa_channel_map_init_auto( void * m, int channels, int def );", "	( m channels def -- )" );
	swigFunction( "c-function pa_channel_map_init_extend pa_channel_map_init_extend a u n -- a", "FUNCTION: pa_channel_map_init_extend ( m channels def -- a )", "EXTERN: \"C\" void * pa_channel_map_init_extend( void * m, int channels, int def );", "	( m channels def -- )" );
	swigFunction( "c-function pa_channel_position_to_string pa_channel_position_to_string n -- s", "FUNCTION: pa_channel_position_to_string ( pos -- s )", "EXTERN: \"C\" char * pa_channel_position_to_string( int pos );", "	( pos -- )" );
	swigFunction( "c-function pa_channel_position_from_string pa_channel_position_from_string s -- n", "FUNCTION: pa_channel_position_from_string ( s -- n )", "EXTERN: \"C\" int pa_channel_position_from_string( char * s );", "	( s -- )" );
	swigFunction( "c-function pa_channel_position_to_pretty_string pa_channel_position_to_pretty_string n -- s", "FUNCTION: pa_channel_position_to_pretty_string ( pos -- s )", "EXTERN: \"C\" char * pa_channel_position_to_pretty_string( int pos );", "	( pos -- )" );
	swigFunction( "c-function pa_channel_map_snprint pa_channel_map_snprint a u a -- a", "FUNCTION: pa_channel_map_snprint ( s l map -- a )", "EXTERN: \"C\" void * pa_channel_map_snprint( void * s, int l, void * map );", "	( s l map -- )" );
	swigFunction( "c-function pa_channel_map_parse pa_channel_map_parse a s -- a", "FUNCTION: pa_channel_map_parse ( map s -- a )", "EXTERN: \"C\" void * pa_channel_map_parse( void * map, char * s );", "	( map s -- )" );
	swigFunction( "c-function pa_channel_map_equal pa_channel_map_equal a a -- n", "FUNCTION: pa_channel_map_equal ( a b -- n )", "EXTERN: \"C\" int pa_channel_map_equal( void * a, void * b );", "	( a b -- )" );
	swigFunction( "c-function pa_channel_map_valid pa_channel_map_valid a -- n", "FUNCTION: pa_channel_map_valid ( map -- n )", "EXTERN: \"C\" int pa_channel_map_valid( void * map );", "	( map -- )" );
	swigFunction( "c-function pa_channel_map_compatible pa_channel_map_compatible a a -- n", "FUNCTION: pa_channel_map_compatible ( map ss -- n )", "EXTERN: \"C\" int pa_channel_map_compatible( void * map, void * ss );", "	( map ss -- )" );
	swigFunction( "c-function pa_channel_map_superset pa_channel_map_superset a a -- n", "FUNCTION: pa_channel_map_superset ( a b -- n )", "EXTERN: \"C\" int pa_channel_map_superset( void * a, void * b );", "	( a b -- )" );
	swigFunction( "c-function pa_channel_map_can_balance pa_channel_map_can_balance a -- n", "FUNCTION: pa_channel_map_can_balance ( map -- n )", "EXTERN: \"C\" int pa_channel_map_can_balance( void * map );", "	( map -- )" );
	swigFunction( "c-function pa_channel_map_can_fade pa_channel_map_can_fade a -- n", "FUNCTION: pa_channel_map_can_fade ( map -- n )", "EXTERN: \"C\" int pa_channel_map_can_fade( void * map );", "	( map -- )" );
	swigFunction( "c-function pa_channel_map_can_lfe_balance pa_channel_map_can_lfe_balance a -- n", "FUNCTION: pa_channel_map_can_lfe_balance ( map -- n )", "EXTERN: \"C\" int pa_channel_map_can_lfe_balance( void * map );", "	( map -- )" );
	swigFunction( "c-function pa_channel_map_to_name pa_channel_map_to_name a -- s", "FUNCTION: pa_channel_map_to_name ( map -- s )", "EXTERN: \"C\" char * pa_channel_map_to_name( void * map );", "	( map -- )" );
	swigFunction( "c-function pa_channel_map_to_pretty_name pa_channel_map_to_pretty_name a -- s", "FUNCTION: pa_channel_map_to_pretty_name ( map -- s )", "EXTERN: \"C\" char * pa_channel_map_to_pretty_name( void * map );", "	( map -- )" );
	swigFunction( "c-function pa_channel_map_has_position pa_channel_map_has_position a n -- n", "FUNCTION: pa_channel_map_has_position ( map p -- n )", "EXTERN: \"C\" int pa_channel_map_has_position( void * map, int p );", "	( map p -- )" );
	swigFunction( "c-function pa_channel_map_mask pa_channel_map_mask a -- ud", "FUNCTION: pa_channel_map_mask ( map -- ud )", "EXTERN: \"C\" long long pa_channel_map_mask( void * map );", "	( map -- )" );
	swigFunction( "c-function pa_cvolume_equal pa_cvolume_equal a a -- n", "FUNCTION: pa_cvolume_equal ( a b -- n )", "EXTERN: \"C\" int pa_cvolume_equal( void * a, void * b );", "	( a b -- )" );
	swigFunction( "c-function pa_cvolume_init pa_cvolume_init a -- a", "FUNCTION: pa_cvolume_init ( a -- a )", "EXTERN: \"C\" void * pa_cvolume_init( void * a );", "	( a -- )" );
	swigFunction( "c-function pa_cvolume_set pa_cvolume_set a u u -- a", "FUNCTION: pa_cvolume_set ( a channels v -- a )", "EXTERN: \"C\" void * pa_cvolume_set( void * a, int channels, int v );", "	( a channels v -- )" );
	swigFunction( "c-function pa_cvolume_snprint pa_cvolume_snprint a u a -- a", "FUNCTION: pa_cvolume_snprint ( s l c -- a )", "EXTERN: \"C\" void * pa_cvolume_snprint( void * s, int l, void * c );", "	( s l c -- )" );
	swigFunction( "c-function pa_sw_cvolume_snprint_dB pa_sw_cvolume_snprint_dB a u a -- a", "FUNCTION: pa_sw_cvolume_snprint_dB ( s l c -- a )", "EXTERN: \"C\" void * pa_sw_cvolume_snprint_dB( void * s, int l, void * c );", "	( s l c -- )" );
	swigFunction( "c-function pa_cvolume_snprint_verbose pa_cvolume_snprint_verbose a u a a n -- a", "FUNCTION: pa_cvolume_snprint_verbose ( s l c map print_dB -- a )", "EXTERN: \"C\" void * pa_cvolume_snprint_verbose( void * s, int l, void * c, void * map, int print_dB );", "	( s l c map print_dB -- )" );
	swigFunction( "c-function pa_volume_snprint pa_volume_snprint a u u -- a", "FUNCTION: pa_volume_snprint ( s l v -- a )", "EXTERN: \"C\" void * pa_volume_snprint( void * s, int l, int v );", "	( s l v -- )" );
	swigFunction( "c-function pa_sw_volume_snprint_dB pa_sw_volume_snprint_dB a u u -- a", "FUNCTION: pa_sw_volume_snprint_dB ( s l v -- a )", "EXTERN: \"C\" void * pa_sw_volume_snprint_dB( void * s, int l, int v );", "	( s l v -- )" );
	swigFunction( "c-function pa_volume_snprint_verbose pa_volume_snprint_verbose a u u n -- a", "FUNCTION: pa_volume_snprint_verbose ( s l v print_dB -- a )", "EXTERN: \"C\" void * pa_volume_snprint_verbose( void * s, int l, int v, int print_dB );", "	( s l v print_dB -- )" );
	swigFunction( "c-function pa_cvolume_avg pa_cvolume_avg a -- u", "FUNCTION: pa_cvolume_avg ( a -- u )", "EXTERN: \"C\" int pa_cvolume_avg( void * a );", "	( a -- )" );
	swigFunction( "c-function pa_cvolume_avg_mask pa_cvolume_avg_mask a a ud -- u", "FUNCTION: pa_cvolume_avg_mask ( a cm mask -- u )", "EXTERN: \"C\" int pa_cvolume_avg_mask( void * a, void * cm, long long mask );", "	( a cm mask -- )" );
	swigFunction( "c-function pa_cvolume_max pa_cvolume_max a -- u", "FUNCTION: pa_cvolume_max ( a -- u )", "EXTERN: \"C\" int pa_cvolume_max( void * a );", "	( a -- )" );
	swigFunction( "c-function pa_cvolume_max_mask pa_cvolume_max_mask a a ud -- u", "FUNCTION: pa_cvolume_max_mask ( a cm mask -- u )", "EXTERN: \"C\" int pa_cvolume_max_mask( void * a, void * cm, long long mask );", "	( a cm mask -- )" );
	swigFunction( "c-function pa_cvolume_min pa_cvolume_min a -- u", "FUNCTION: pa_cvolume_min ( a -- u )", "EXTERN: \"C\" int pa_cvolume_min( void * a );", "	( a -- )" );
	swigFunction( "c-function pa_cvolume_min_mask pa_cvolume_min_mask a a ud -- u", "FUNCTION: pa_cvolume_min_mask ( a cm mask -- u )", "EXTERN: \"C\" int pa_cvolume_min_mask( void * a, void * cm, long long mask );", "	( a cm mask -- )" );
	swigFunction( "c-function pa_cvolume_valid pa_cvolume_valid a -- n", "FUNCTION: pa_cvolume_valid ( v -- n )", "EXTERN: \"C\" int pa_cvolume_valid( void * v );", "	( v -- )" );
	swigFunction( "c-function pa_cvolume_channels_equal_to pa_cvolume_channels_equal_to a u -- n", "FUNCTION: pa_cvolume_channels_equal_to ( a v -- n )", "EXTERN: \"C\" int pa_cvolume_channels_equal_to( void * a, int v );", "	( a v -- )" );
	swigFunction( "c-function pa_sw_volume_multiply pa_sw_volume_multiply u u -- u", "FUNCTION: pa_sw_volume_multiply ( a b -- u )", "EXTERN: \"C\" int pa_sw_volume_multiply( int a, int b );", "	( a b -- )" );
	swigFunction( "c-function pa_sw_cvolume_multiply pa_sw_cvolume_multiply a a a -- a", "FUNCTION: pa_sw_cvolume_multiply ( dest a b -- a )", "EXTERN: \"C\" void * pa_sw_cvolume_multiply( void * dest, void * a, void * b );", "	( dest a b -- )" );
	swigFunction( "c-function pa_sw_cvolume_multiply_scalar pa_sw_cvolume_multiply_scalar a a u -- a", "FUNCTION: pa_sw_cvolume_multiply_scalar ( dest a b -- a )", "EXTERN: \"C\" void * pa_sw_cvolume_multiply_scalar( void * dest, void * a, int b );", "	( dest a b -- )" );
	swigFunction( "c-function pa_sw_volume_divide pa_sw_volume_divide u u -- u", "FUNCTION: pa_sw_volume_divide ( a b -- u )", "EXTERN: \"C\" int pa_sw_volume_divide( int a, int b );", "	( a b -- )" );
	swigFunction( "c-function pa_sw_cvolume_divide pa_sw_cvolume_divide a a a -- a", "FUNCTION: pa_sw_cvolume_divide ( dest a b -- a )", "EXTERN: \"C\" void * pa_sw_cvolume_divide( void * dest, void * a, void * b );", "	( dest a b -- )" );
	swigFunction( "c-function pa_sw_cvolume_divide_scalar pa_sw_cvolume_divide_scalar a a u -- a", "FUNCTION: pa_sw_cvolume_divide_scalar ( dest a b -- a )", "EXTERN: \"C\" void * pa_sw_cvolume_divide_scalar( void * dest, void * a, int b );", "	( dest a b -- )" );
	swigFunction( "c-function pa_sw_volume_from_dB pa_sw_volume_from_dB r -- u", "FUNCTION: pa_sw_volume_from_dB ( f -- u )", "EXTERN: \"C\" int pa_sw_volume_from_dB( double f );", "	( f -- )" );
	swigFunction( "c-function pa_sw_volume_to_dB pa_sw_volume_to_dB u -- r", "FUNCTION: pa_sw_volume_to_dB ( v -- r )", "EXTERN: \"C\" double pa_sw_volume_to_dB( int v );", "	( v -- )" );
	swigFunction( "c-function pa_sw_volume_from_linear pa_sw_volume_from_linear r -- u", "FUNCTION: pa_sw_volume_from_linear ( v -- u )", "EXTERN: \"C\" int pa_sw_volume_from_linear( double v );", "	( v -- )" );
	swigFunction( "c-function pa_sw_volume_to_linear pa_sw_volume_to_linear u -- r", "FUNCTION: pa_sw_volume_to_linear ( v -- r )", "EXTERN: \"C\" double pa_sw_volume_to_linear( int v );", "	( v -- )" );
	swigFunction( "c-function pa_cvolume_remap pa_cvolume_remap a a a -- a", "FUNCTION: pa_cvolume_remap ( v from to -- a )", "EXTERN: \"C\" void * pa_cvolume_remap( void * v, void * from, void * to );", "	( v from to -- )" );
	swigFunction( "c-function pa_cvolume_compatible pa_cvolume_compatible a a -- n", "FUNCTION: pa_cvolume_compatible ( v ss -- n )", "EXTERN: \"C\" int pa_cvolume_compatible( void * v, void * ss );", "	( v ss -- )" );
	swigFunction( "c-function pa_cvolume_compatible_with_channel_map pa_cvolume_compatible_with_channel_map a a -- n", "FUNCTION: pa_cvolume_compatible_with_channel_map ( v cm -- n )", "EXTERN: \"C\" int pa_cvolume_compatible_with_channel_map( void * v, void * cm );", "	( v cm -- )" );
	swigFunction( "c-function pa_cvolume_get_balance pa_cvolume_get_balance a a -- r", "FUNCTION: pa_cvolume_get_balance ( v map -- r )", "EXTERN: \"C\" float pa_cvolume_get_balance( void * v, void * map );", "	( v map -- )" );
	swigFunction( "c-function pa_cvolume_set_balance pa_cvolume_set_balance a a r -- a", "FUNCTION: pa_cvolume_set_balance ( v map new_balance -- a )", "EXTERN: \"C\" void * pa_cvolume_set_balance( void * v, void * map, float new_balance );", "	( v map new_balance -- )" );
	swigFunction( "c-function pa_cvolume_get_fade pa_cvolume_get_fade a a -- r", "FUNCTION: pa_cvolume_get_fade ( v map -- r )", "EXTERN: \"C\" float pa_cvolume_get_fade( void * v, void * map );", "	( v map -- )" );
	swigFunction( "c-function pa_cvolume_set_fade pa_cvolume_set_fade a a r -- a", "FUNCTION: pa_cvolume_set_fade ( v map new_fade -- a )", "EXTERN: \"C\" void * pa_cvolume_set_fade( void * v, void * map, float new_fade );", "	( v map new_fade -- )" );
	swigFunction( "c-function pa_cvolume_get_lfe_balance pa_cvolume_get_lfe_balance a a -- r", "FUNCTION: pa_cvolume_get_lfe_balance ( v map -- r )", "EXTERN: \"C\" float pa_cvolume_get_lfe_balance( void * v, void * map );", "	( v map -- )" );
	swigFunction( "c-function pa_cvolume_set_lfe_balance pa_cvolume_set_lfe_balance a a r -- a", "FUNCTION: pa_cvolume_set_lfe_balance ( v map new_balance -- a )", "EXTERN: \"C\" void * pa_cvolume_set_lfe_balance( void * v, void * map, float new_balance );", "	( v map new_balance -- )" );
	swigFunction( "c-function pa_cvolume_scale pa_cvolume_scale a u -- a", "FUNCTION: pa_cvolume_scale ( v max -- a )", "EXTERN: \"C\" void * pa_cvolume_scale( void * v, int max );", "	( v max -- )" );
	swigFunction( "c-function pa_cvolume_scale_mask pa_cvolume_scale_mask a u a ud -- a", "FUNCTION: pa_cvolume_scale_mask ( v max cm mask -- a )", "EXTERN: \"C\" void * pa_cvolume_scale_mask( void * v, int max, void * cm, long long mask );", "	( v max cm mask -- )" );
	swigFunction( "c-function pa_cvolume_set_position pa_cvolume_set_position a a n u -- a", "FUNCTION: pa_cvolume_set_position ( cv map t v -- a )", "EXTERN: \"C\" void * pa_cvolume_set_position( void * cv, void * map, int t, int v );", "	( cv map t v -- )" );
	swigFunction( "c-function pa_cvolume_get_position pa_cvolume_get_position a a n -- u", "FUNCTION: pa_cvolume_get_position ( cv map t -- u )", "EXTERN: \"C\" int pa_cvolume_get_position( void * cv, void * map, int t );", "	( cv map t -- )" );
	swigFunction( "c-function pa_cvolume_merge pa_cvolume_merge a a a -- a", "FUNCTION: pa_cvolume_merge ( dest a b -- a )", "EXTERN: \"C\" void * pa_cvolume_merge( void * dest, void * a, void * b );", "	( dest a b -- )" );
	swigFunction( "c-function pa_cvolume_inc_clamp pa_cvolume_inc_clamp a u u -- a", "FUNCTION: pa_cvolume_inc_clamp ( v inc limit -- a )", "EXTERN: \"C\" void * pa_cvolume_inc_clamp( void * v, int inc, int limit );", "	( v inc limit -- )" );
	swigFunction( "c-function pa_cvolume_inc pa_cvolume_inc a u -- a", "FUNCTION: pa_cvolume_inc ( v inc -- a )", "EXTERN: \"C\" void * pa_cvolume_inc( void * v, int inc );", "	( v inc -- )" );
	swigFunction( "c-function pa_cvolume_dec pa_cvolume_dec a u -- a", "FUNCTION: pa_cvolume_dec ( v dec -- a )", "EXTERN: \"C\" void * pa_cvolume_dec( void * v, int dec );", "	( v dec -- )" );
	swigFunction( "c-function pa_xmalloc pa_xmalloc u -- a", "FUNCTION: pa_xmalloc ( l -- a )", "EXTERN: \"C\" void * pa_xmalloc( int l );", "	( l -- )" );
	swigFunction( "c-function pa_xmalloc0 pa_xmalloc0 u -- a", "FUNCTION: pa_xmalloc0 ( l -- a )", "EXTERN: \"C\" void * pa_xmalloc0( int l );", "	( l -- )" );
	swigFunction( "c-function pa_xrealloc pa_xrealloc a u -- a", "FUNCTION: pa_xrealloc ( ptr size -- a )", "EXTERN: \"C\" void * pa_xrealloc( void * ptr, int size );", "	( ptr size -- )" );
	swigFunction( "c-function pa_xfree pa_xfree a -- void", "FUNCTION: pa_xfree ( p -- void )", "EXTERN: \"C\" void pa_xfree( void * p );", "	( p -- )" );
	swigFunction( "c-function pa_xstrdup pa_xstrdup s -- a", "FUNCTION: pa_xstrdup ( s -- a )", "EXTERN: \"C\" void * pa_xstrdup( char * s );", "	( s -- )" );
	swigFunction( "c-function pa_xstrndup pa_xstrndup s u -- a", "FUNCTION: pa_xstrndup ( s l -- a )", "EXTERN: \"C\" void * pa_xstrndup( char * s, int l );", "	( s l -- )" );
	swigFunction( "c-function pa_xmemdup pa_xmemdup a u -- a", "FUNCTION: pa_xmemdup ( p l -- a )", "EXTERN: \"C\" void * pa_xmemdup( void * p, int l );", "	( p l -- )" );
	swigFunction( "c-function _pa_xnew_internal _pa_xnew_internal u u -- a", "FUNCTION: _pa_xnew_internal ( n k -- a )", "EXTERN: \"C\" void * _pa_xnew_internal( int n, int k );", "	( n k -- )" );
	swigFunction( "c-function _pa_xnew0_internal _pa_xnew0_internal u u -- a", "FUNCTION: _pa_xnew0_internal ( n k -- a )", "EXTERN: \"C\" void * _pa_xnew0_internal( int n, int k );", "	( n k -- )" );
	swigFunction( "c-function _pa_xnewdup_internal _pa_xnewdup_internal a u u -- a", "FUNCTION: _pa_xnewdup_internal ( p n k -- a )", "EXTERN: \"C\" void * _pa_xnewdup_internal( void * p, int n, int k );", "	( p n k -- )" );
	swigFunction( "c-function _pa_xrenew_internal _pa_xrenew_internal a u u -- a", "FUNCTION: _pa_xrenew_internal ( p n k -- a )", "EXTERN: \"C\" void * _pa_xrenew_internal( void * p, int n, int k );", "	( p n k -- )" );
	swigFunction( "c-function pa_utf8_valid pa_utf8_valid s -- a", "FUNCTION: pa_utf8_valid ( str -- a )", "EXTERN: \"C\" void * pa_utf8_valid( char * str );", "	( str -- )" );
	swigFunction( "c-function pa_ascii_valid pa_ascii_valid s -- a", "FUNCTION: pa_ascii_valid ( str -- a )", "EXTERN: \"C\" void * pa_ascii_valid( char * str );", "	( str -- )" );
	swigFunction( "c-function pa_utf8_filter pa_utf8_filter s -- a", "FUNCTION: pa_utf8_filter ( str -- a )", "EXTERN: \"C\" void * pa_utf8_filter( char * str );", "	( str -- )" );
	swigFunction( "c-function pa_ascii_filter pa_ascii_filter s -- a", "FUNCTION: pa_ascii_filter ( str -- a )", "EXTERN: \"C\" void * pa_ascii_filter( char * str );", "	( str -- )" );
	swigFunction( "c-function pa_utf8_to_locale pa_utf8_to_locale s -- a", "FUNCTION: pa_utf8_to_locale ( str -- a )", "EXTERN: \"C\" void * pa_utf8_to_locale( char * str );", "	( str -- )" );
	swigFunction( "c-function pa_locale_to_utf8 pa_locale_to_utf8 s -- a", "FUNCTION: pa_locale_to_utf8 ( str -- a )", "EXTERN: \"C\" void * pa_locale_to_utf8( char * str );", "	( str -- )" );
	swigFunction( "c-function pa_threaded_mainloop_new pa_threaded_mainloop_new  -- a", "FUNCTION: pa_threaded_mainloop_new (  -- a )", "EXTERN: \"C\" void * pa_threaded_mainloop_new(  );", "	( -- )" );
	swigFunction( "c-function pa_threaded_mainloop_free pa_threaded_mainloop_free a -- void", "FUNCTION: pa_threaded_mainloop_free ( m -- void )", "EXTERN: \"C\" void pa_threaded_mainloop_free( void * m );", "	( m -- )" );
	swigFunction( "c-function pa_threaded_mainloop_start pa_threaded_mainloop_start a -- n", "FUNCTION: pa_threaded_mainloop_start ( m -- n )", "EXTERN: \"C\" int pa_threaded_mainloop_start( void * m );", "	( m -- )" );
	swigFunction( "c-function pa_threaded_mainloop_stop pa_threaded_mainloop_stop a -- void", "FUNCTION: pa_threaded_mainloop_stop ( m -- void )", "EXTERN: \"C\" void pa_threaded_mainloop_stop( void * m );", "	( m -- )" );
	swigFunction( "c-function pa_threaded_mainloop_lock pa_threaded_mainloop_lock a -- void", "FUNCTION: pa_threaded_mainloop_lock ( m -- void )", "EXTERN: \"C\" void pa_threaded_mainloop_lock( void * m );", "	( m -- )" );
	swigFunction( "c-function pa_threaded_mainloop_unlock pa_threaded_mainloop_unlock a -- void", "FUNCTION: pa_threaded_mainloop_unlock ( m -- void )", "EXTERN: \"C\" void pa_threaded_mainloop_unlock( void * m );", "	( m -- )" );
	swigFunction( "c-function pa_threaded_mainloop_wait pa_threaded_mainloop_wait a -- void", "FUNCTION: pa_threaded_mainloop_wait ( m -- void )", "EXTERN: \"C\" void pa_threaded_mainloop_wait( void * m );", "	( m -- )" );
	swigFunction( "c-function pa_threaded_mainloop_signal pa_threaded_mainloop_signal a n -- void", "FUNCTION: pa_threaded_mainloop_signal ( m wait_for_accept -- void )", "EXTERN: \"C\" void pa_threaded_mainloop_signal( void * m, int wait_for_accept );", "	( m wait_for_accept -- )" );
	swigFunction( "c-function pa_threaded_mainloop_accept pa_threaded_mainloop_accept a -- void", "FUNCTION: pa_threaded_mainloop_accept ( m -- void )", "EXTERN: \"C\" void pa_threaded_mainloop_accept( void * m );", "	( m -- )" );
	swigFunction( "c-function pa_threaded_mainloop_get_retval pa_threaded_mainloop_get_retval a -- n", "FUNCTION: pa_threaded_mainloop_get_retval ( m -- n )", "EXTERN: \"C\" int pa_threaded_mainloop_get_retval( void * m );", "	( m -- )" );
	swigFunction( "c-function pa_threaded_mainloop_get_api pa_threaded_mainloop_get_api a -- a", "FUNCTION: pa_threaded_mainloop_get_api ( m -- a )", "EXTERN: \"C\" void * pa_threaded_mainloop_get_api( void * m );", "	( m -- )" );
	swigFunction( "c-function pa_threaded_mainloop_in_thread pa_threaded_mainloop_in_thread a -- n", "FUNCTION: pa_threaded_mainloop_in_thread ( m -- n )", "EXTERN: \"C\" int pa_threaded_mainloop_in_thread( void * m );", "	( m -- )" );
	swigFunction( "c-function pa_threaded_mainloop_set_name pa_threaded_mainloop_set_name a s -- void", "FUNCTION: pa_threaded_mainloop_set_name ( m name -- void )", "EXTERN: \"C\" void pa_threaded_mainloop_set_name( void * m, char * name );", "	( m name -- )" );
	swigFunction( "c-function pa_threaded_mainloop_once_unlocked pa_threaded_mainloop_once_unlocked a a a -- void", "FUNCTION: pa_threaded_mainloop_once_unlocked ( m callback userdata -- void )", "EXTERN: \"C\" void pa_threaded_mainloop_once_unlocked( void * m, void * callback, void * userdata );", "	( m callback userdata -- )" );
	swigFunction( "c-function pa_mainloop_new pa_mainloop_new  -- a", "FUNCTION: pa_mainloop_new (  -- a )", "EXTERN: \"C\" void * pa_mainloop_new(  );", "	( -- )" );
	swigFunction( "c-function pa_mainloop_free pa_mainloop_free a -- void", "FUNCTION: pa_mainloop_free ( m -- void )", "EXTERN: \"C\" void pa_mainloop_free( void * m );", "	( m -- )" );
	swigFunction( "c-function pa_mainloop_prepare pa_mainloop_prepare a n -- n", "FUNCTION: pa_mainloop_prepare ( m timeout -- n )", "EXTERN: \"C\" int pa_mainloop_prepare( void * m, int timeout );", "	( m timeout -- )" );
	swigFunction( "c-function pa_mainloop_poll pa_mainloop_poll a -- n", "FUNCTION: pa_mainloop_poll ( m -- n )", "EXTERN: \"C\" int pa_mainloop_poll( void * m );", "	( m -- )" );
	swigFunction( "c-function pa_mainloop_dispatch pa_mainloop_dispatch a -- n", "FUNCTION: pa_mainloop_dispatch ( m -- n )", "EXTERN: \"C\" int pa_mainloop_dispatch( void * m );", "	( m -- )" );
	swigFunction( "c-function pa_mainloop_get_retval pa_mainloop_get_retval a -- n", "FUNCTION: pa_mainloop_get_retval ( m -- n )", "EXTERN: \"C\" int pa_mainloop_get_retval( void * m );", "	( m -- )" );
	swigFunction( "c-function pa_mainloop_iterate pa_mainloop_iterate a n a -- n", "FUNCTION: pa_mainloop_iterate ( m block retval -- n )", "EXTERN: \"C\" int pa_mainloop_iterate( void * m, int block, void * retval );", "	( m block retval -- )" );
	swigFunction( "c-function pa_mainloop_run pa_mainloop_run a a -- n", "FUNCTION: pa_mainloop_run ( m retval -- n )", "EXTERN: \"C\" int pa_mainloop_run( void * m, void * retval );", "	( m retval -- )" );
	swigFunction( "c-function pa_mainloop_get_api pa_mainloop_get_api a -- a", "FUNCTION: pa_mainloop_get_api ( m -- a )", "EXTERN: \"C\" void * pa_mainloop_get_api( void * m );", "	( m -- )" );
	swigFunction( "c-function pa_mainloop_quit pa_mainloop_quit a n -- void", "FUNCTION: pa_mainloop_quit ( m retval -- void )", "EXTERN: \"C\" void pa_mainloop_quit( void * m, int retval );", "	( m retval -- )" );
	swigFunction( "c-function pa_mainloop_wakeup pa_mainloop_wakeup a -- void", "FUNCTION: pa_mainloop_wakeup ( m -- void )", "EXTERN: \"C\" void pa_mainloop_wakeup( void * m );", "	( m -- )" );
	swigFunction( "c-function pa_mainloop_set_poll_func pa_mainloop_set_poll_func a a a -- void", "FUNCTION: pa_mainloop_set_poll_func ( m poll_func userdata -- void )", "EXTERN: \"C\" void pa_mainloop_set_poll_func( void * m, void * poll_func, void * userdata );", "	( m poll_func userdata -- )" );
	swigFunction( "c-function pa_signal_init pa_signal_init a -- n", "FUNCTION: pa_signal_init ( api -- n )", "EXTERN: \"C\" int pa_signal_init( void * api );", "	( api -- )" );
	swigFunction( "c-function pa_signal_done pa_signal_done  -- void", "FUNCTION: pa_signal_done (  -- void )", "EXTERN: \"C\" void pa_signal_done(  );", "	( -- )" );
	swigFunction( "c-function pa_signal_new pa_signal_new n a a -- a", "FUNCTION: pa_signal_new ( sig callback userdata -- a )", "EXTERN: \"C\" void * pa_signal_new( int sig, void * callback, void * userdata );", "	( sig callback userdata -- )" );
	swigFunction( "c-function pa_signal_free pa_signal_free a -- void", "FUNCTION: pa_signal_free ( e -- void )", "EXTERN: \"C\" void pa_signal_free( void * e );", "	( e -- )" );
	swigFunction( "c-function pa_signal_set_destroy pa_signal_set_destroy a a -- void", "FUNCTION: pa_signal_set_destroy ( e callback -- void )", "EXTERN: \"C\" void pa_signal_set_destroy( void * e, void * callback );", "	( e callback -- )" );
	swigFunction( "c-function pa_get_user_name pa_get_user_name a u -- a", "FUNCTION: pa_get_user_name ( s l -- a )", "EXTERN: \"C\" void * pa_get_user_name( void * s, int l );", "	( s l -- )" );
	swigFunction( "c-function pa_get_host_name pa_get_host_name a u -- a", "FUNCTION: pa_get_host_name ( s l -- a )", "EXTERN: \"C\" void * pa_get_host_name( void * s, int l );", "	( s l -- )" );
	swigFunction( "c-function pa_get_fqdn pa_get_fqdn a u -- a", "FUNCTION: pa_get_fqdn ( s l -- a )", "EXTERN: \"C\" void * pa_get_fqdn( void * s, int l );", "	( s l -- )" );
	swigFunction( "c-function pa_get_home_dir pa_get_home_dir a u -- a", "FUNCTION: pa_get_home_dir ( s l -- a )", "EXTERN: \"C\" void * pa_get_home_dir( void * s, int l );", "	( s l -- )" );
	swigFunction( "c-function pa_get_binary_name pa_get_binary_name a u -- a", "FUNCTION: pa_get_binary_name ( s l -- a )", "EXTERN: \"C\" void * pa_get_binary_name( void * s, int l );", "	( s l -- )" );
	swigFunction( "c-function pa_path_get_filename pa_path_get_filename s -- a", "FUNCTION: pa_path_get_filename ( p -- a )", "EXTERN: \"C\" void * pa_path_get_filename( char * p );", "	( p -- )" );
	swigFunction( "c-function pa_msleep pa_msleep u -- n", "FUNCTION: pa_msleep ( t -- n )", "EXTERN: \"C\" int pa_msleep( long t );", "	( t -- )" );
	swigFunction( "c-function pa_thread_make_realtime pa_thread_make_realtime n -- n", "FUNCTION: pa_thread_make_realtime ( rtprio -- n )", "EXTERN: \"C\" int pa_thread_make_realtime( int rtprio );", "	( rtprio -- )" );
	swigFunction( "c-function pa_gettimeofday pa_gettimeofday a -- a", "FUNCTION: pa_gettimeofday ( tv -- a )", "EXTERN: \"C\" void * pa_gettimeofday( void * tv );", "	( tv -- )" );
	swigFunction( "c-function pa_timeval_diff pa_timeval_diff a a -- u", "FUNCTION: pa_timeval_diff ( a b -- u )", "EXTERN: \"C\" int pa_timeval_diff( void * a, void * b );", "	( a b -- )" );
	swigFunction( "c-function pa_timeval_cmp pa_timeval_cmp a a -- n", "FUNCTION: pa_timeval_cmp ( a b -- n )", "EXTERN: \"C\" int pa_timeval_cmp( void * a, void * b );", "	( a b -- )" );
	swigFunction( "c-function pa_timeval_age pa_timeval_age a -- u", "FUNCTION: pa_timeval_age ( tv -- u )", "EXTERN: \"C\" int pa_timeval_age( void * tv );", "	( tv -- )" );
	swigFunction( "c-function pa_timeval_add pa_timeval_add a u -- a", "FUNCTION: pa_timeval_add ( tv v -- a )", "EXTERN: \"C\" void * pa_timeval_add( void * tv, int v );", "	( tv v -- )" );
	swigFunction( "c-function pa_timeval_sub pa_timeval_sub a u -- a", "FUNCTION: pa_timeval_sub ( tv v -- a )", "EXTERN: \"C\" void * pa_timeval_sub( void * tv, int v );", "	( tv v -- )" );
	swigFunction( "c-function pa_timeval_store pa_timeval_store a u -- a", "FUNCTION: pa_timeval_store ( tv v -- a )", "EXTERN: \"C\" void * pa_timeval_store( void * tv, int v );", "	( tv v -- )" );
	swigFunction( "c-function pa_timeval_load pa_timeval_load a -- u", "FUNCTION: pa_timeval_load ( tv -- u )", "EXTERN: \"C\" int pa_timeval_load( void * tv );", "	( tv -- )" );
	swigFunction( "c-function pa_proplist_new pa_proplist_new  -- a", "FUNCTION: pa_proplist_new (  -- a )", "EXTERN: \"C\" void * pa_proplist_new(  );", "	( -- )" );
	swigFunction( "c-function pa_proplist_free pa_proplist_free a -- void", "FUNCTION: pa_proplist_free ( p -- void )", "EXTERN: \"C\" void pa_proplist_free( void * p );", "	( p -- )" );
	swigFunction( "c-function pa_proplist_key_valid pa_proplist_key_valid s -- n", "FUNCTION: pa_proplist_key_valid ( key -- n )", "EXTERN: \"C\" int pa_proplist_key_valid( char * key );", "	( key -- )" );
	swigFunction( "c-function pa_proplist_sets pa_proplist_sets a s s -- n", "FUNCTION: pa_proplist_sets ( p key value -- n )", "EXTERN: \"C\" int pa_proplist_sets( void * p, char * key, char * value );", "	( p key value -- )" );
	swigFunction( "c-function pa_proplist_setp pa_proplist_setp a s -- n", "FUNCTION: pa_proplist_setp ( p pair -- n )", "EXTERN: \"C\" int pa_proplist_setp( void * p, char * pair );", "	( p pair -- )" );
	swigFunction( "c-function pa_proplist_setf pa_proplist_setf a s s ... -- n", "FUNCTION: pa_proplist_setf ( p key format  -- n )", "EXTERN: \"C\" int pa_proplist_setf( void * p, char * key, char * format, ...  );", "	( p key format <noname> -- )" );
	swigFunction( "c-function pa_proplist_set pa_proplist_set a s a u -- n", "FUNCTION: pa_proplist_set ( p key data nbytes -- n )", "EXTERN: \"C\" int pa_proplist_set( void * p, char * key, void * data, int nbytes );", "	( p key data nbytes -- )" );
	swigFunction( "c-function pa_proplist_gets pa_proplist_gets a s -- s", "FUNCTION: pa_proplist_gets ( p key -- s )", "EXTERN: \"C\" char * pa_proplist_gets( void * p, char * key );", "	( p key -- )" );
	swigFunction( "c-function pa_proplist_get pa_proplist_get a s a a -- n", "FUNCTION: pa_proplist_get ( p key data nbytes -- n )", "EXTERN: \"C\" int pa_proplist_get( void * p, char * key, void * data, void * nbytes );", "	( p key data nbytes -- )" );
	swigFunction( "c-function pa_proplist_update pa_proplist_update a n a -- void", "FUNCTION: pa_proplist_update ( p mode other -- void )", "EXTERN: \"C\" void pa_proplist_update( void * p, int mode, void * other );", "	( p mode other -- )" );
	swigFunction( "c-function pa_proplist_unset pa_proplist_unset a s -- n", "FUNCTION: pa_proplist_unset ( p key -- n )", "EXTERN: \"C\" int pa_proplist_unset( void * p, char * key );", "	( p key -- )" );
	swigFunction( "c-function pa_proplist_unset_many pa_proplist_unset_many a a -- n", "FUNCTION: pa_proplist_unset_many ( p keys -- n )", "EXTERN: \"C\" int pa_proplist_unset_many( void * p, void * keys );", "	( p keys -- )" );
	swigFunction( "c-function pa_proplist_iterate pa_proplist_iterate a a -- s", "FUNCTION: pa_proplist_iterate ( p state -- s )", "EXTERN: \"C\" char * pa_proplist_iterate( void * p, void * state );", "	( p state -- )" );
	swigFunction( "c-function pa_proplist_to_string pa_proplist_to_string a -- a", "FUNCTION: pa_proplist_to_string ( p -- a )", "EXTERN: \"C\" void * pa_proplist_to_string( void * p );", "	( p -- )" );
	swigFunction( "c-function pa_proplist_to_string_sep pa_proplist_to_string_sep a s -- a", "FUNCTION: pa_proplist_to_string_sep ( p sep -- a )", "EXTERN: \"C\" void * pa_proplist_to_string_sep( void * p, char * sep );", "	( p sep -- )" );
	swigFunction( "c-function pa_proplist_from_string pa_proplist_from_string s -- a", "FUNCTION: pa_proplist_from_string ( str -- a )", "EXTERN: \"C\" void * pa_proplist_from_string( char * str );", "	( str -- )" );
	swigFunction( "c-function pa_proplist_contains pa_proplist_contains a s -- n", "FUNCTION: pa_proplist_contains ( p key -- n )", "EXTERN: \"C\" int pa_proplist_contains( void * p, char * key );", "	( p key -- )" );
	swigFunction( "c-function pa_proplist_clear pa_proplist_clear a -- void", "FUNCTION: pa_proplist_clear ( p -- void )", "EXTERN: \"C\" void pa_proplist_clear( void * p );", "	( p -- )" );
	swigFunction( "c-function pa_proplist_copy pa_proplist_copy a -- a", "FUNCTION: pa_proplist_copy ( p -- a )", "EXTERN: \"C\" void * pa_proplist_copy( void * p );", "	( p -- )" );
	swigFunction( "c-function pa_proplist_size pa_proplist_size a -- u", "FUNCTION: pa_proplist_size ( p -- u )", "EXTERN: \"C\" int pa_proplist_size( void * p );", "	( p -- )" );
	swigFunction( "c-function pa_proplist_isempty pa_proplist_isempty a -- n", "FUNCTION: pa_proplist_isempty ( p -- n )", "EXTERN: \"C\" int pa_proplist_isempty( void * p );", "	( p -- )" );
	swigFunction( "c-function pa_proplist_equal pa_proplist_equal a a -- n", "FUNCTION: pa_proplist_equal ( a b -- n )", "EXTERN: \"C\" int pa_proplist_equal( void * a, void * b );", "	( a b -- )" );
	swigFunction( "c-function pa_rtclock_now pa_rtclock_now  -- u", "FUNCTION: pa_rtclock_now (  -- u )", "EXTERN: \"C\" int pa_rtclock_now(  );", "	( -- )" );

	swigNewline();

	swigComment("----===< postfix >===-----\n");

	swigPrint( "end-c-library", "( none )", "( none )" );
	
	return 0;
} /* end of main */



