# Gforth README

[![Build Status Travis](https://travis-ci.org/forthy42/gforth.png?branch=master)](https://travis-ci.org/forthy42/gforth)
[![pipeline status](https://gitlab.com/forthy42/gforth/badges/master/pipeline.svg)](https://gitlab.com/forthy42/gforth/commits/master)
[![pipeline status](https://git.net2o.de/bernd/gforth/badges/master/pipeline.svg)](https://git.net2o.de/bernd/gforth/commits/master)

Gforth is a fast and portable implementation of the ANS Forth/Forth 200x
language. It works nicely with the Emacs editor, offers some nice features
such as input completion and history, backtraces, a decompiler and a powerful
locals facility, and it has a comprehensive manual. Gforth combines
traditional implementation techniques with newer techniques for portability
and performance: its inner interpreter is direct threaded with several
optimizations, but you can also use a traditional-style indirect threaded
interpreter.  Gforth is distributed under the GNU General Public license (see
COPYING).

Gforth is part of the GNU Operating System, developed by the GNU Project.  To
learn more about Free (libre) Software, you can read this page:
[https://gnu.org/philosophy/free-sw.html](https://gnu.org/philosophy/free-sw.html)

If you are the author of an awesome program and want to join us in
writing Free (libre) Software, please consider making it an official
GNU program and become a GNU Maintainer.  You can find instructions 
on how to do this here: [https://www.gnu.org/help/evaluation](https://www.gnu.org/help/evaluation)

Another way to contribute to the Forth community is by uploading your program
as a package to the Forth Net: [https://theforth.net](https://theforth.net)

## Supported Systems

Gforth runs under GNU, BSD, and similar systems, MS Windows and MacOS X
and should not be hard to port to other systems supported by GCC. This
version has been tested successfully on the following platforms:

* GNU/Linux
  * amd64
  * arm64
  * armel
  * armhf
  * i386
  * mips
  * mipsel
  * powerpc
* Android/Linux
  * amd64
  * arm64
  * arm
  * i386
  * mips
* Gforth EC(embedded): r8c, 4stack, misc, 8086
* Windows
  * amd64
  * i386
* MacOS
  * amd64
  * i386

## Installation

Read `INSTALL` for installation instructions from tarball,\
or `INSTALL.md` for from git,\
or `INSTALL.BINDIST` if you have a binary package distributed as `.tar.xz` file.\
If you received a self-installing executable,
just run it and follow the instructions.

To start the system, just say `gforth` (after installing it).

## Download

You can find new versions of Gforth at\
[www.complang.tuwien.ac.at/forth/gforth/](https://www.complang.tuwien.ac.at/forth/gforth/)\
and current snapshots on\
[www.complang.tuwien.ac.at/forth/gforth/Snapshots/current/](https://www.complang.tuwien.ac.at/forth/gforth/Snapshots/current/)\
or at\
[ftp://ftp.gnu.org/gnu/gforth/](ftp://ftp.gnu.org/gnu/gforth/)

## Files

On popular request, here are the meanings of unusual file extensions:

`\*.fs`	Forth stream source file (include with "`include _<file>_`" from within
        gforth, or start with "`gforth _<file1> <file2>_ ...`")\
`\*.fi`	Forth image files (start with "`gforth -i _<image file>_`")\
`\*.fb`	Forth blocks file (load with "`use _<block file>_ 1 load`")\
`\*.i`	C include files\
`\*.texi.in`	documenation source\
`\*TAGS`	etags files

A number of Forth source files are included in this package that are
not necessary for building Gforth. Not all of them are mentioned in
the rest of the documentation, so here's a short overview:

__Add-ons:__

    code.fs random.fs more.fs ansi.fs colorize.fs
    oof.fs oofsampl.fs objects.fs blocked.fb tasker.fs

__Utilities:__

    ans-report.fs etags.fs glosgen.fs filedump.fs

__Games:__

    tt.fs sokoban.fs

__Test programs (for testing Forth systems):__

    test/*.fs

__Benchmarks:__

    bubble.fs siev.fs matrix.fs fib.fs

__ANS Forth implementations of Gforth extensions:__

    compat/*.fs

__C-Bindings:__

    unix/*.fs

## Support

For discussions about Gforth, use the Usenet newsgroup
comp.lang.forth.  If you prefer not to post on Usenet, there is also a
mailing list: gforth@gnu.org.  You have to subsribe to post there.
You can subscribe through
[http://lists.gnu.org/mailman/listinfo/gforth](http://lists.gnu.org/mailman/listinfo/gforth).  The list is archived
at [http://lists.gnu.org/pipermail/gforth/](http://lists.gnu.org/pipermail/gforth).

You can also report bugs through these channels, or you can report
them through our bug database:

[https://savannah.gnu.org/bugs/?func=addbug&group=gforth](https://savannah.gnu.org/bugs/?func=addbug&group=gforth)

- anton
anton@mips.complang.tuwien.ac.at
[http://www.complang.tuwien.ac.at/anton/home.html](http://www.complang.tuwien.ac.at/anton/home.html)

---

Authors: Bernd Paysan, Anton Ertl, Gerald Wodni
Copyright (C) 1995,1996,1997,1998,2000,2003,2004,2006,2007,2008,2009,2016,2017,2018,2019,2020,2021,2022,2023 Free Software Foundation, Inc.

This file is part of Gforth.

Gforth is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, either version 3
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program. If not, see http://www.gnu.org/licenses/.
