#include<stdlib.h>
#include<stdio.h>
#include<asm/page.h>
#include<sys/time.h>
#include<unistd.h>


int main( int argc, char **argv )
{
  unsigned long* mem,* p,* end;
  unsigned long i;
  unsigned long msize,megs;
  struct timeval tv1,tv2;
  struct timezone tz;
  int mps;
  int errs=0,ep;

  if (!argv[1]) {
    printf("You must give the size of memory blocks in MB as argument.\n");
    exit(0);
  }
  
  nice(19); /* This task is really not important */

  megs = atoi(argv[1]);
  if(megs==0) exit(1);
  printf("Allocating %lu MB\n",megs);
  msize=megs*1024*1024;

  mem = (long* )malloc((size_t)msize);
  if(mem == 0) exit(1);
  
  printf("Writing nice pattern to mem\n");

  end=mem+msize/sizeof(unsigned long);
  p=mem;
  i=1;
  while(p<end)
    {
      *p = i;
      i=i*987+123;
      p++;
    }
  
  printf("verifying mem contents\n");

  while(1)
    {
      p=mem;
      i=1;
      ep=0;
      gettimeofday(&tv1,&tz);
      while(p<end)
	{
	  if(*p != i) 
	    {
	      /* printf("%p read: %lu  should be: %lu\n",p,*p,i); */
	      errs++;
	      /* skip to next page */
	      p = (unsigned long* )((unsigned long)
		  (p + ((PAGE_SIZE)/sizeof(unsigned long))) & PAGE_MASK);
	      ep++;
	      i=*p;
	    }
	  i=i*987+123;
	  p++;
	}  
      gettimeofday(&tv2,&tz);
      mps = (10000000*megs)/
	 ((tv2.tv_sec-tv1.tv_sec)*1000000+tv2.tv_usec-tv1.tv_usec);
      
      printf("%d.%d MB/sec | errs=%d | erronous pages=%d  \r"
	     ,mps/10,mps%10,errs,ep);
      fflush(stdout);
    }
  

  return 0; /* never reached */
} /* main */

  
  
  
