/*
  mergemod.h
  
  This file is part of mergemem by Philipp Richter & Philipp Reisner

  mergemem is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.
  
  mergemem is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with mergemem; see the file COPYING.  If not, write to
  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef _MERGEMOD_H
#define _MERGEMOD_H

#ifdef __KERNEL__
#include <linux/types.h>
#include <linux/ioctl.h>
#else
#include <sys/types.h>
#include <sys/wait.h>
#endif

/* return values issued by mergemem() */

#define MERGEMEM_SUCCESS 0
#define MERGEMEM_NOTASK1 1
#define MERGEMEM_NOTASK2 2
#define MERGEMEM_NOPAGE1 3
#define MERGEMEM_NOPAGE2 4
#define MERGEMEM_NOTEQUAL 5
#define MERGEMEM_ALREADYSH 6
/* #define MERGEMEM_MOREMAP 7  OBSOLETE: mergemod will never return this */
#define MERGEMEM_NOANO 8
#define MERGEMEM_PLOCKED 9
#define MERGEMEM_MOVED 10

#define MERGEMEM_LAST_ERROR 10

/* minor of the mergemem device */
#define MERGEMEM_MINOR 153
/* module name as printed in printk msgs */
#define MODULE_NAME "mergemod: "

/* ioctl structures */

struct mergemem_mmem
{
  /* in */
  pid_t pid1;
  unsigned long addr1;
  pid_t pid2;
  unsigned long addr2;
};

struct mergemem_chksum
{
  /* in */
  pid_t pid;
  unsigned long addr;
  /* out */
  unsigned long chksum;
  int nrefs;
};

struct mergemem_get_phys_addr
{
  /* in */
  pid_t pid;
  unsigned long addr;
  /* out */
  unsigned long phys_addr;
};

/* ioctl commands */
#define MERGEMEM_CHECK_VER       _IOR(  'M', 0x00, int )
#define MERGEMEM_MERGE_MEM       _IOW(  'M', 0x01, struct mergemem_mmem )
#define MERGEMEM_GEN_CHECKSUM    _IOWR( 'M', 0x02, struct mergemem_chksum )
#define MERGEMEM_RESET_STAT      _IO(   'M', 0x03 )
#define MERGEMEM_GET_PHYS_ADDR   _IOWR( 'M', 0x06, struct mergemem_get_phys_addr )

#endif /* _MERGEMOD_H */
