/*
   mergemem.h by Marnix Coppens

   This file is part of mergemem by Philipp Richter & Philipp Reisner

   mergemem is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   mergemem is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with mergemem; see the file COPYING.  If not, write to
   the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <fcntl.h>
#include <stdio.h>
#include <limits.h>
#include <string.h>
#include <unistd.h>

#define TRUE		1
#define FALSE		0
#define LOGFILE		"/var/log/mergemem.log"

void        parse_options(int argc, char **argv);

typedef struct CmdList CmdList;
typedef struct LibList LibList;
typedef struct MapList MapList;
typedef struct MrgList MrgList;
typedef struct PidList PidList;

extern CmdList *cmd_list;
extern CmdList *ign_list;
extern LibList *lib_list;
extern MrgList *mrg_list;
extern PidList *pid_list;

extern FILE *flog;
extern int  interval;
extern int  loglevel;
extern int  nicelevel;
extern int  mergemod_fd;
extern char mergeall;
extern char run_as_daemon;
extern char logfile[PATH_MAX];

struct CmdList
{
    char       *cmd;
    int         interval, counter;
    CmdList    *next;
};

struct LibList
{
    dev_t       dev;
    ino_t       ino;
    LibList    *next;
};

struct MapList
{
    ulong       vmstart;
    ulong       vmend;
    dev_t       dev;
    ino_t       ino;
    ulong      *chksum;
    char       *chksumvalid;
    MapList    *next;
};

struct MrgList
{
    pid_t       pid;
    MapList    *map;
    MrgList    *next;
};
struct PidList
{
    pid_t       pid;
    int         valid;
    PidList    *next;
};
