/*
   merge_utils.h by Marnix Coppens

   This file is part of mergemem by Philipp Richter & Philipp Reisner

   mergemem is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   mergemem is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with mergemem; see the file COPYING.  If not, write to
   the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <stdlib.h>

#ifdef DEBUG
int         nmallsize, nmallocs, nfrees;

#define the_free(ptr)	free(ptr)
#define free(ptr)	if (ptr) nfrees++, the_free(ptr);
#endif

enum logmsg_errs
{
    NO_ERROR = 0, ERR_USAGE, ERR_NOMEM, ERR_NOPROC, ERR_NICE, ERR_LOG, ERR_PID,
    ERR_LIB, ERR_ARGS, ERR_VERSION, ERR_MODULE, ERR_FORK, ERR_INTERVAL
};

void        err_exit(int exitval, char *errstr);
void        logmsg(int level, char *fmt,...);
void        normal_exit(int dummy);
void       *safe_malloc(size_t size);

CmdList    *add_cmd_by_name(CmdList **pcmdlist, char *name);
PidList    *add_cmd_by_pid(PidList **ppidlist, pid_t pid);
LibList    *add_lib_by_devino(LibList **pliblist, dev_t dev, ino_t ino);

PidList    *find_cmd_by_pid(PidList *pidlist, pid_t pid);
CmdList    *find_cmd_by_name(CmdList *cmdlist, char *cmdname);
LibList    *find_lib_by_devino(LibList *liblist, dev_t dev, ino_t ino);
MapList    *find_map_in_maplist(MapList *maplist, MapList *mapl1);
