/*
  mergemem.h
  
  This file is part of mergemem by Philipp Richter & Philipp Reisner

  mergemem is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.
  
  mergemem is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with mergemem; see the file COPYING.  If not, write to
  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <sys/types.h>
#include <sys/resource.h>
#include <sys/wait.h>
#include <sys/ptrace.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <unistd.h>
#include <fcntl.h>

#include <asm/page.h>

#include <string.h>
#include <stdio.h>
#include <errno.h>
#include <dirent.h>
#include <stdlib.h>
#include <unistd.h>
#include <getopt.h>
#include <ctype.h>
#include <time.h>
#include <stdarg.h>
#include <signal.h>

#include "../mergemod/mergemod.h"

#define CFG_NAME "/etc/mergemem.cfg"
#define MAPLLEN 100         /* linelength of map-file */
#define MAX_MAPCOUNT 512    /* maximum number of map entries */

/* for debugging purposes */
#define DEBUG

#define TRUE (1==1)
#define FALSE (!TRUE)

#define min(a, b) ((a) < (b) ? (a) : (b))
#define max(a, b) ((a) > (b) ? (a) : (b))

/*struct PageInfo*/
/*{*/
/*  unsigned long chksum; */         /* Checksum */
/*  int nr_of_refs;  */              /* Number of mappings */
/*};*/


struct PidList
{
  int pid;
  int maps;                       /* count of maps */
  int id;                         /* id for merging (all pids with same id can be merged) */
                                  /* some vars for the statistics...: */
                                  /* for one mapping */
  int mpages_mrg;                 /* merged pages */
  int mpages_err;                 /* pages with errors on merging */
  int mpages_nmrg;                /* pages not merged */
  int mpages_ashr;                /* pages already shared */
  int mpages_mov_to;              /* pages moved */
  int mpages_mov_from;            /* pages moved */
                                  /* for the process */
  int pages_mrg;                  /* merged pages */
  int pages_err;                  /* pages with errors on merging */
  int pages_nmrg;                 /* pages not merged */
  int pages_ashr;                 /* pages already shared */
  int pages_mov_to;               /* pages moved */
  int pages_mov_from;             /* pages moved */

  unsigned long vm_begin[ 512 ];  /* array of vm beginnings */
  unsigned long vm_end[ 512 ];    /* array of vm endings */
  /*struct PageInfo *page_info;*/       /* pointer to dynamically allocated array of checksums */

  unsigned long chksum;           /* checksum of current page */
  int nr_of_refs;                 /* number if refs for cur page */

  struct PidList *next;
};

struct CmdList
{
  char *cmd;
  unsigned long iv;
  unsigned long cntr;
  struct CmdList *next;
};

struct DontMerge
{
  char *cmd;
  struct DontMerge *next;
};

void read_cfg_file();
char *cfg_next_token( char **str );
void cfg_error( int line, const char *text );
void parse_options( int argc, char **argv );
void free_all();
void err_exit( const char *msg );
void logmsg( int lev, char *fmt, ...);
void wait_loop();
void inst_sig();
void cfg_reread();
void ok_exit();
void merge_singleshot();
void merge_command( const char *cmd );
void merge_pids( struct PidList **pl );
int init_maps( struct PidList *pl );
int stop_processes( struct PidList **pl );
void cont_processes( struct PidList *pl );
void merge_memory( struct PidList *pl );
int open_mem( struct PidList *pl );
void close_mem( struct PidList *pl );
/*void gen_checksums( unsigned long beg, unsigned long end, struct PidList *pl );
void chk_checksums( unsigned long beg, unsigned long end, struct PidList *pl );*/
void check_and_merge( unsigned long beg, unsigned long end, struct PidList *pl );
unsigned long checksum( unsigned long l, const char *buf );
void merge_all_commands();
void check_running();
#ifdef DEBUG
void dump_vars();
#endif
