/*
  mergelib.h
  
  This file is part of mergemem by Philipp Richter & Philipp Reisner
  Created by Joe Object (e9226558@stud1.tuwien.ac.at).

  mergemem is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.
  
  mergemem is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with mergemem; see the file COPYING.  If not, write to
  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef _MERGELIB_H
#define _MERGELIB_H

#include <sys/types.h>
#include <stdio.h>
#include <asm/page.h>

#include "../mergemod/mergemod.h"

 /* I really need these :) Note: These come from NeXT!! */
typedef char BOOL;
#define NO	(char)0
#define YES	(char)!NO


/* Diagnostics: Negative values mean a 'real' system error (access denied,...)
   The values 0 ... MERGEMEM_LAST_ERROR (~13) are reserved for info returned
   by the module (pages shared successful,...), starting from 1000 
   are lib errors which usually denote a severe failure (for example if 
   the module isn't loaded) -- should exit then. */


#define MERGELIB_ERROR_OFFSET 		1000
#define MERGELIB_NO_MODULE 		1000
#define MERGELIB_VERSION_MISMATCH 	1001
#define MERGELIB_FD_NOT_OPEN 		1002
/* drop that sys_error bogus -- syerrors are < 0 */
#define MERGELIB_SYS_ERROR 		1003
#define MERGELIB_LAST_ERROR 		1003


/* static char _mergemem_loglevels[MERGEMEM_LAST_ERROR] = {0,  */

#define MERGEMEM_LOG_ANYWAY     0
#define MERGEMEM_LOG_MESSAGE    MERGEMEM_LOG_ANYWAY     
#define MERGEMEM_LOG_ERROR 	1
#define MERGEMEM_LOG_WARNING 	2
#define MERGEMEM_LOG_WARN 	MERGEMEM_LOG_WARNING 	
#define MERGEMEM_LOG_STATS 	3
#define MERGEMEM_LOG_EVENT 	4
#define MERGEMEM_LOG_NOTICE	MERGEMEM_LOG_EVENT
#define MERGEMEM_LOG_INFO	MERGEMEM_LOG_EVENT
#define MERGEMEM_LOG_DEBUG 	5

extern int mergemem_errno; 

/* Set this to have mergelib logging errors, warnings, events, debug msgs. */
extern FILE *mergemem_logfile; 
extern int mergemem_loglevel;
extern BOOL mergemem_echolog; 
extern BOOL mergemem_always_probe; 

extern const char *mergemod_errmsgs[MERGEMEM_LAST_ERROR + 2];
extern const char *mergelib_errmsgs[MERGELIB_LAST_ERROR-MERGELIB_ERROR_OFFSET+1];

/* We have two of them, since one might be interested in 'local' stats (like
   how many pages merged for a particular process) as well as in 'global'
   ones. 
   In addition, when just probing only the *local* stats are updated. 
   The global ones always reflect pages that are really merged. */


#define MERGEMEM_GLOBAL_STATS 0
#define MERGEMEM_LOCAL_STATS  1

    /* MERGEMEM_LAST_ERROR+1 counts all other results */
extern int mergemem_stats[2][MERGEMEM_LAST_ERROR+2];

extern const char *mergemem_errmsg(void);
extern void mergemem_perror(char *s);
extern void mergemem_always_exit_on_error(BOOL flag); 

#if (__GNUC__ == 2) && (__GNUC_MINOR__ >= 5)
extern void mergemem_log(unsigned int level, const char *fmt, ...)
       __attribute__ ((format (printf, 2, 3)));
#elif
extern void mergemem_log(unsigned int level, const char *fmt, ...);
#endif

extern int mergemem_logtofile (char * file, unsigned int level);

       /* perhaps rename this to mergemem_open */
extern int mergemem_init(void);
   /* Opens fd, checks version. Returns non-zero error code on failure. */

extern int mergemem_modversion(void);
extern int mergemem_myversion(void);
extern const char * mergemem_myversion_info(void);

	/* Attempt to merge those virtual mappings. Returns 0 if
	   successful */
extern int mergemem_merge(pid_t pid1, long addr1, pid_t pid2, long addr2);
extern int mergemem_merge_probe(pid_t pid1, long addr1, pid_t pid2, long addr2);
extern int mergemem_merge_area(pid_t pid1, long addr, long length,
			pid_t pid2, long offset);

extern int mergemem_cross_merge_area(pid_t pid1, long addr, long length,
			      pid_t pid2, long offset);

extern unsigned long mergemem_checksum (pid_t pid, long addr);
extern int mergemem_get_chksums (pid_t pid, long addr, long length, long *sums);

extern void mergemem_reset_stats (unsigned int set);
extern void mergemem_print_stats (unsigned int set);


#endif /* _MERGELIB_H */






