/* 

usage: grep " 0$" /proc/<star>/maps | grep -v self | merge_areas

 */

#include "mergelib.h"
#include <stdlib.h>
#include <stdio.h>


#define MAX_AREAS 100

struct area {
	pid_t pid; 
	long from, to; 
} areas[MAX_AREAS];

struct chksum {
	pid_t pid; 
	long addr; 
	long sum; 
} *chksum; 

int read_areas (void)
{
	int i; 
	char s[100]; 

	i=0; 
	while (!feof (stdin)) {
		fgets (s, 100, stdin); 
		sscanf (s, "/proc/%d/maps:%lx-%lx", &areas[i].pid,
				&areas[i].from, &areas[i].to); 
		if (++i>MAX_AREAS) return MAX_AREAS; 
	}
	return i; 
}

int compare_chksums (const struct chksum *a1, const struct chksum *a2)
{
	return (a1->sum==a2->sum) ? 0 : ((a1->sum<a2->sum) ? -1 : 1); 
}

int main (int argc, char **argv) 
{
	int cnt, pages; 
	int i, j, k;
	struct chksum last={-1, -1, -1}; 

	mergemem_logtofile ("/tmp/log", MERGEMEM_LOG_NOTICE); 

	cnt=read_areas (); 
	pages=0; 
	for (i=0; i<cnt; ++i) pages+=(areas[i].to-areas[i].from) >> PAGE_SHIFT;
fprintf (stderr, "PAGES: %d\n", pages); 
	chksum=malloc (pages*sizeof (struct chksum)); 
	k=0; 
	for (i=0; i<cnt; ++i) {
		for (j=areas[i].from;j<areas[i].to;j+=PAGE_SIZE) {
			if ((chksum[k].sum=mergemem_checksum (areas[i].pid, j))!=-1) {
				chksum[k].pid=areas[i].pid; 
				chksum[k].addr=j;
				
				++k; 
			}
		}
	}
	
	qsort (chksum, k, sizeof (*chksum), compare_chksums); 

	for (i=0; i<k; ++i) {
printf ("sum: %d %lx: %lx\n", chksum[i].pid, chksum[i].addr, chksum[i].sum);  
		if (last.sum!=chksum[i].sum) {
			last=chksum[i]; 
		} else {
			mergemem_merge (last.pid, last.addr, chksum[i].pid, chksum[i].addr);
		}
	}
	mergemem_print_stats(0); 
	return 0; 
}
	
	
	

