/* -*- c -*- */

/*
 * symtab.h
 *
 * chpp
 *
 * Copyright (C) 1997-1998 Mark Probst
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SYMTAB_H__
#define __SYMTAB_H__

#include "chash.h"
#include "avl.h"

#include "dynstring.h"
#include "internals.h"
#include "builtins/builtins.h"
#include "output.h"
#include "value.h"

struct _symbol;

typedef struct _parameter
{
    dynstring name;
    struct _parameter *next;
} parameter;

typedef struct _scopeLevel
{
    struct _symbol *firstSymbol;
    struct _scopeLevel *previous;
} scopeLevel;

#define SYMBOL_UNDEFINED     0
#define SYMBOL_PARAMETER     1
#define SYMBOL_VALUE         2

typedef struct _symbol
{
    dynstring name;
    int type;
    value *value;

    unsigned long hash;

    struct _symbol *scopeNext;
    struct _symbol *hashNext;

    scopeLevel *scope;
} symbol;

void initSymtab (void);

symbol* lookupSymbol (dynstring *name);
symbol* lookupValueSymbolOfType (dynstring *name, int valueType);
symbol* lookupFunction (dynstring *name);

int existsSymbol (dynstring *name);

void defineScalar (symbol *entry, dynstring *value);
symbol* defineLocalScalar (dynstring *name, dynstring *value);
symbol* defineLocalVariable (dynstring *name, value *defValue);
symbol* defineGlobalScalar (dynstring *name, dynstring *value);
symbol* defineScalarForCurrentScope (dynstring *name, dynstring *value);
symbol* defineVariableForCurrentScope (dynstring *name, value *value);

symbol* defineGlobalInternal (dynstring *name, internalSet setFunc, internalGet getFunc);
symbol* defineGlobalBuiltIn (dynstring *name, builtIn function, int evalParams);
symbol* defineGlobalUserDefined (dynstring *name, int numArgs, int minVarArgs, int maxVarArgs,
				 dynstring *args, dynstring *value);

void undefineSymbol (symbol *entry);

void pushScopeLevel (void);
void popScopeLevel (void);

symbol* lookupHash (dynstring *name, int define);
void hashDefine (symbol *entry, dynstring *key, dynstring *value);
dynstring* hashLookup (symbol *entry, dynstring *key);

symbol* lookupList (dynstring *name, int define);
int listLength (symbol *entry);
dynstring* listGetElement (symbol *entry, int index);
void listSetElement (symbol *entry, int index, dynstring *value);
void listDeleteElement (symbol *entry, int index);
void listClear (symbol *entry);

#endif
