/* -*- c -*- */

/*
 * output.c
 *
 * chpp
 *
 * Copyright (C) 1997-1998 Mark Probst
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "output.h"

extern int generateDependencies;

void
dummyOutChar (void *state, char c)
{
}

void
dummyOutString (void *state, const char *str, int length)
{
}

void
dummyOutValue (void *state, value *theValue)
{
}

void
dynstringOutChar (void *state, char c)
{
    dsAppendChar((dynstring*)state, c);
}

void
dynstringOutString (void *state, const char *str, int length)
{
    dsAppendString((dynstring*)state, str, length);
}

void
dynstringOutValue (void *state, value *theValue)
{
    if (theValue->type == VALUE_SCALAR)
	dsAppendString((dynstring*)state,
		       theValue->v.scalar.scalar.data, theValue->v.scalar.scalar.length);
    else
    {
	value *scalarValue = valueNewScalarFromValue(theValue);

	dsAppendString((dynstring*)state,
		       scalarValue->v.scalar.scalar.data, scalarValue->v.scalar.scalar.length);
	valueFree(scalarValue);
    }
}

void
fileOutChar (void *state, char c)
{
    if (!generateDependencies)
	putc(c, (FILE*)state);
}

void
fileOutString (void *state, const char *str, int length)
{
    if (!generateDependencies)
	fwrite(str, length, 1, (FILE*)state);
}

void
fileOutValue (void *state, value *theValue)
{
    if (!generateDependencies)
    {
	if (theValue->type == VALUE_SCALAR)
	    fwrite(theValue->v.scalar.scalar.data, theValue->v.scalar.scalar.length, 1, (FILE*)state);
	else
	{
	    value *scalarValue = valueNewScalarFromValue(theValue);
	    
	    fwrite(scalarValue->v.scalar.scalar.data, scalarValue->v.scalar.scalar.length, 1, (FILE*)state);
	    valueFree(scalarValue);
	}
    }
}

void
valueOutChar (void *state, char c)
{
    value *theValue = (value*)state;

    valueTransformToScalar(theValue);
    dsAppendChar(&theValue->v.scalar.scalar, c);
}

void
valueOutString (void *state, const char *str, int length)
{
    value *theValue = (value*)state;

    valueTransformToScalar(theValue);
    dsAppendString(&theValue->v.scalar.scalar, str, length);
}

void
valueOutValue (void *state, value *appendedValue)
{
    value *theValue = (value*)state;

    if (theValue->type == VALUE_UNDEFINED)
	valueAssign(theValue, appendedValue, 0);
    else if (theValue->type == VALUE_LIST && appendedValue->type == VALUE_LIST)
	valueListAppendList(theValue, appendedValue, 0);
    else
    {
	int freeAppended = 0;

	if (theValue->type != VALUE_SCALAR)
	    valueTransformToScalar(theValue);
	if (appendedValue->type != VALUE_SCALAR)
	{
	    appendedValue = valueNewScalarFromValue(appendedValue);
	    freeAppended = 1;
	}

	dsAppendString(&theValue->v.scalar.scalar,
		       appendedValue->v.scalar.scalar.data,
		       appendedValue->v.scalar.scalar.length);

	if (freeAppended)
	    valueFree(appendedValue);
    }
}

outputWriter
owNewDummy (void)
{
    outputWriter ow;

    ow.outChar = dummyOutChar;
    ow.outString = dummyOutString;
    ow.outValue = dummyOutValue;
    ow.enabled = 1;
    ow.state = 0;

    return ow;
}

void
owFreeDummy (outputWriter *ow)
{
}

outputWriter
owNewDynstring (dynstring *ds)
{
    outputWriter ow;

    ow.outChar = dynstringOutChar;
    ow.outString = dynstringOutString;
    ow.outValue = dynstringOutValue;
    ow.enabled = 1;
    ow.state = ds;

    return ow;
}

void
owFreeDynstring (outputWriter *ow)
{
}

outputWriter
owNewFile (FILE *file)
{
    outputWriter ow;

    ow.outChar = fileOutChar;
    ow.outString = fileOutString;
    ow.outValue = fileOutValue;
    ow.enabled = 1;
    ow.state = file;

    return ow;
}

void
owFreeFile (outputWriter *ow)
{
}

outputWriter
owNewValue (value *theValue)
{
    outputWriter ow;

    ow.outChar = valueOutChar;
    ow.outString = valueOutString;
    ow.outValue = valueOutValue;
    ow.enabled = 1;
    ow.state = theValue;

    return ow;
}

void
owFreeValue (outputWriter *ow)
{
}
