/* -*- c -*- */

/*
 * macros.h
 *
 * chpp
 *
 * Copyright (C) 1997-1998 Mark Probst
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __MACROS_H__
#define __MACROS_H__

#include "dynstring.h"
#include "input.h"
#include "output.h"
#include "symtab.h"
#include "value.h"

void evalUntil (inputReader *ir, const char *delimiters, outputWriter *ow);
void eval (inputReader *ir, outputWriter *ow);
void evalDSIntoOW (dynstring *ds, outputWriter *ow);
dynstring evalIntoDSUntil (inputReader *ir, const char *delimiters);
value* evalIntoValueUntil (inputReader *ir, const char *delimiters);
value* evalDSIntoValue (dynstring *ds);
dynstring evalDS (dynstring *ds);
value* evalDSIntoValue (dynstring *ds);

void eatUntil (inputReader *ir, const char *delimiter, outputWriter *ow);
dynstring eatDSUntil (dynstring *ds, int *pos, const char *delimiters);
dynstring eatIntoDSUntil (inputReader *ir, const char *delimiters);

void evalVariable (symbol *entry, outputWriter *ow);
dynstring evalVariableIntoDS (symbol *entry);

#endif
