/* -*- c -*- */

/*
 * internals.c
 *
 * chpp
 *
 * Copyright (C) 1997-1998 Mark Probst
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <assert.h>
#include <stdlib.h>
#include <stdio.h>
#ifdef _NEXT
#include <libc.h>
#endif

#include "dynstring.h"
#include "symtab.h"
#include "main.h"
#include "builtins/builtins.h"

extern int generateDependencies;
extern dynstring mainFileName;

char topLevelMetaChar = '%';

char *metaChar = &topLevelMetaChar;
char quoteChar = '\\';

void
internalSetMetaChar (value *val)
{
    assert(val->type == VALUE_SCALAR && val->v.scalar.scalar.length == 1);

    *metaChar = val->v.scalar.scalar.data[0];
}

void
internalGetMetaChar (outputWriter *ow)
{
    OUT_CHAR(ow, *metaChar);
}

void
internalSetQuoteChar (value *val)
{
    assert(val->type == VALUE_SCALAR && val->v.scalar.scalar.length == 1);

    quoteChar = val->v.scalar.scalar.data[0];
}

void
internalGetQuoteChar (outputWriter *ow)
{
    OUT_CHAR(ow, quoteChar);
}

void
internalSetOutputenabled (value *val)
{
    toplevelOutputWriter.enabled = BOOL_VALUE(val);
}

void
internalGetOutputenabled (outputWriter *ow)
{
    if (toplevelOutputWriter.enabled)
    {
	OUT_CHAR(ow, '1');
    }
    else
    {
	OUT_CHAR(ow, '0');
    }
}

void
internalGetDependencing (outputWriter *ow)
{
    if (generateDependencies)
    {
	OUT_CHAR(ow, '1');
    }
    else
    {
	OUT_CHAR(ow, '0');
    }
}

void
internalGetMainfilename (outputWriter *ow)
{
    OUT_STRING(ow, mainFileName.data, mainFileName.length);
}

void
registerInternals (void)
{
    dynstring ds;

    ds = dsNewFrom("v_metachar");
    defineGlobalInternal(&ds, internalSetMetaChar, internalGetMetaChar);

    ds = dsNewFrom("v_quotechar");
    defineGlobalInternal(&ds, internalSetQuoteChar, internalGetQuoteChar);

    ds = dsNewFrom("outputenabled");
    defineGlobalInternal(&ds, internalSetOutputenabled, internalGetOutputenabled);

    ds = dsNewFrom("dependencing");
    defineGlobalInternal(&ds, 0, internalGetDependencing);

    ds = dsNewFrom("mainfilename");
    defineGlobalInternal(&ds, 0, internalGetMainfilename);
}
