/* -*- c -*- */

/*
 * builtins/hashops.c
 *
 * chpp
 *
 * Copyright (C) 1997-1998 Mark Probst
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <assert.h>

#include "../error.h"
#include "../symtab.h"

#include "builtins.h"

void
builtInHashcount (int numArgs, value **args, outputWriter *ow)
{
    char lengthString[64];

    if (!(numArgs == 1))
    {
	issueError(ERRMAC_WRONG_NUM_ARGS, "chr");
	return;
    }

    if (args[0]->type != VALUE_HASH)
	issueError(ERRMAC_VALUE_WRONG_TYPE,
		   cStringForValueType(args[0]->type),
		   cStringForValueType(VALUE_HASH));
    else
	OUT_STRING(ow, lengthString, sprintf(lengthString, "%d", valueHashCount(args[0])));
}

void
builtInKeys (int numArgs, value **args, outputWriter *ow)
{
    if (!(numArgs == 1))
    {
	issueError(ERRMAC_WRONG_NUM_ARGS, "chr");
	return;
    }

    if (args[0]->type != VALUE_HASH)
	issueError(ERRMAC_VALUE_WRONG_TYPE,
		   cStringForValueType(args[0]->type),
		   cStringForValueType(VALUE_HASH));
    else
    {
	value *result = valueNewList();
	hstate state;
	value *aValue;
	char *aKey;
	int i = 0;

	state = hash_state(args[0]->v.hash.hash);
	while ((aValue = (value*)hash_next(&state, &aKey)) != 0)
	    valueListSetElement(result, i++, valueNewScalarFromCString(aKey));
	OUT_VALUE(ow, result);
	valueFree(result);
    }
}

void
registerHashOps (void)
{
    dynstring ds;

    ds = dsNewFrom("hashcount"); defineGlobalBuiltIn(&ds, builtInHashcount, 1);
    ds = dsNewFrom("keys"); defineGlobalBuiltIn(&ds, builtInKeys, 1);
}
