/* -*- c -*- */

/*
 * builtins/builtins.h
 *
 * chpp
 *
 * Copyright (C) 1997-1998 Mark Probst
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __BUILTINS_H__
#define __BUILTINS_H__

struct _value;
struct _outputWriter;
struct _dynstring;

#define BOOL_VALUE(va)      ((va)->type != VALUE_SCALAR ? 1 : \
                             !((va)->v.scalar.scalar.length == 0 || !strcmp((va)->v.scalar.scalar.data, "0")))

void removeWSAndEvalValue (struct _value *val, struct _outputWriter *ow);
struct _value* removeWSAndEvalValueIntoValue (struct _value *val);
struct _dynstring removeWSAndEvalValueIntoDS (struct _value *val);
struct _value* makeValueScalar (struct _value *val);

void registerBuiltIns (void);

void registerFileOps (void);
void registerStringOps (void);
void registerFlowCtl (void);
void registerArrayOps (void);
void registerHashOps (void);
void registerValues (void);

typedef void (*builtIn) (int numArgs, struct _value **args, struct _outputWriter *ow);

#endif
