I_noop:	/* noop ( -- ) */
/*  */
NAME("noop")
{
DEF_CA
NEXT_P0;
{
#line 107 "/a5/anton/gforth/prim"
;
}
NEXT_P1;
NEXT_P2;
}

I_lit:	/* lit ( -- w ) */
/*  */
NAME("lit")
{
DEF_CA
Cell w;
NEXT_P0;
IF_TOS(sp[0] = TOS);
sp += -1;
{
#line 112 "/a5/anton/gforth/prim"
w = (Cell)NEXT_INST;
INC_IP(1);
}
NEXT_P1;
TOS = (Cell)w;
NEXT_P2;
}

I_execute:	/* execute ( xt -- ) */
/* Perform the semantics represented by the execution token, @i{xt}. */
NAME("execute")
{
DEF_CA
Xt xt;
NEXT_P0;
xt = (Xt) TOS;
sp += 1;
{
#line 119 "/a5/anton/gforth/prim"
ip=IP;
IF_TOS(TOS = sp[0]);
EXEC(xt);
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_perform:	/* perform ( a_addr -- ) */
/* Equivalent to @code{@ execute}. */
NAME("perform")
{
DEF_CA
Cell * a_addr;
NEXT_P0;
a_addr = (Cell *) TOS;
sp += 1;
{
#line 125 "/a5/anton/gforth/prim"
/* and pfe */
ip=IP;
IF_TOS(TOS = sp[0]);
EXEC(*(Xt *)a_addr);
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

#ifdef HAS_GLOCALS
I_branch_lp_plus_store_number:	/* branch-lp+!# ( -- ) */
/*  */
NAME("branch-lp+!#")
{
DEF_CA
NEXT_P0;
{
#line 136 "/a5/anton/gforth/prim"
/* this will probably not be used */
branch_adjust_lp:
lp += (Cell)(IP[1]);
goto branch;
}
NEXT_P1;
NEXT_P2;
}

#endif
I_branch:	/* branch ( -- ) */
/*  */
NAME("branch")
{
DEF_CA
NEXT_P0;
{
#line 144 "/a5/anton/gforth/prim"
branch:
SET_IP((Xt *)(((Cell)IP)+(Cell)NEXT_INST));
}
NEXT_P1;
NEXT_P2;
}

I_question_branch:	/* ?branch ( f -- ) */
/*  */
NAME("?branch")
{
DEF_CA
Bool f;
NEXT_P0;
f = (Bool) TOS;
sp += 1;
{
#line 179 "/a5/anton/gforth/prim"
if (f==0) {
#line 179
    IF_TOS(TOS = sp[0]);
#line 179
	SET_IP((Xt *)(((Cell)IP)+(Cell)NEXT_INST));
#line 179
	NEXT;
#line 179
}
#line 179
else
#line 179
    INC_IP(1);
#line 179
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

#ifdef HAS_GLOCALS
I_question_branch_lp_plus_store_number:	/* ?branch-lp+!# ( f -- ) */
/*  */
NAME("?branch-lp+!#")
{
DEF_CA
Bool f;
NEXT_P0;
f = (Bool) TOS;
sp += 1;
{
#line 179 "/a5/anton/gforth/prim"
if (f==0) {
#line 179
    IF_TOS(TOS = sp[0]);
#line 179
    goto branch_adjust_lp;
#line 179
}
#line 179
else
#line 179
    INC_IP(2);
#line 179
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

#endif
#ifdef HAS_XCONDS
I_question_dupe_question_branch:	/* ?dup-?branch ( f -- f ) */
/* The run-time procedure compiled by @code{?DUP-IF}. */
NAME("?dup-?branch")
{
DEF_CA
Bool f;
NEXT_P0;
f = (Bool) TOS;
{
#line 188 "/a5/anton/gforth/prim"
if (f==0) {
  sp++;
  IF_TOS(TOS = sp[0]);
  SET_IP((Xt *)(((Cell)IP)+(Cell)NEXT_INST));
  NEXT;
}
else
  INC_IP(1);
}
NEXT_P1;
NEXT_P2;
}

I_question_dupe_zero_equals_question_branch:	/* ?dup-0=-?branch ( f -- ) */
/* The run-time procedure compiled by @code{?DUP-0=-IF}. */
NAME("?dup-0=-?branch")
{
DEF_CA
Bool f;
NEXT_P0;
f = (Bool) TOS;
sp += 1;
{
#line 199 "/a5/anton/gforth/prim"
/* the approach taken here of declaring the word as having the stack
effect ( f -- ) and correcting for it in the branch-taken case costs a
few cycles in that case, but is easy to convert to a CONDBRANCH
invocation */
if (f!=0) {
  sp--;
  SET_IP((Xt *)(((Cell)IP)+(Cell)NEXT_INST));
  NEXT;
}
else
  INC_IP(1);
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

#endif
I_paren_next:	/* (next) ( -- ) */
/*  */
NAME("(next)")
{
DEF_CA
NEXT_P0;
{
#line 219 "/a5/anton/gforth/prim"
if ((*rp)--) {
#line 219
	SET_IP((Xt *)(((Cell)IP)+(Cell)NEXT_INST));
#line 219
	NEXT;
#line 219
}
#line 219
else
#line 219
    INC_IP(1);
#line 219
}
NEXT_P1;
NEXT_P2;
}

#ifdef HAS_GLOCALS
I_paren_next_lp_plus_store_number:	/* (next)-lp+!# ( -- ) */
/*  */
NAME("(next)-lp+!#")
{
DEF_CA
NEXT_P0;
{
#line 219 "/a5/anton/gforth/prim"
if ((*rp)--) {
#line 219
    goto branch_adjust_lp;
#line 219
}
#line 219
else
#line 219
    INC_IP(2);
#line 219
}
NEXT_P1;
NEXT_P2;
}

#endif
I_paren_loop:	/* (loop) ( -- ) */
/*  */
NAME("(loop)")
{
DEF_CA
NEXT_P0;
{
#line 229 "/a5/anton/gforth/prim"
Cell index = *rp+1;
#line 229
Cell limit = rp[1];
#line 229
if (index != limit) {
#line 229
    *rp = index;
#line 229
	SET_IP((Xt *)(((Cell)IP)+(Cell)NEXT_INST));
#line 229
	NEXT;
#line 229
}
#line 229
else
#line 229
    INC_IP(1);
#line 229
}
NEXT_P1;
NEXT_P2;
}

#ifdef HAS_GLOCALS
I_paren_loop_lp_plus_store_number:	/* (loop)-lp+!# ( -- ) */
/*  */
NAME("(loop)-lp+!#")
{
DEF_CA
NEXT_P0;
{
#line 229 "/a5/anton/gforth/prim"
Cell index = *rp+1;
#line 229
Cell limit = rp[1];
#line 229
if (index != limit) {
#line 229
    *rp = index;
#line 229
    goto branch_adjust_lp;
#line 229
}
#line 229
else
#line 229
    INC_IP(2);
#line 229
}
NEXT_P1;
NEXT_P2;
}

#endif
I_paren_plus_loop:	/* (+loop) ( n -- ) */
/*  */
NAME("(+loop)")
{
DEF_CA
Cell n;
NEXT_P0;
n = (Cell) TOS;
sp += 1;
{
#line 251 "/a5/anton/gforth/prim"
/* !! check this thoroughly */
#line 251
Cell index = *rp;
#line 251
/* sign bit manipulation and test: (x^y)<0 is equivalent to (x<0) != (y<0) */
#line 251
/* dependent upon two's complement arithmetic */
#line 251
Cell olddiff = index-rp[1];
#line 251
if ((olddiff^(olddiff+n))>=0   /* the limit is not crossed */
#line 251
    || (olddiff^n)>=0          /* it is a wrap-around effect */) {
#line 251
#ifdef i386
#line 251
    *rp += n;
#line 251
#else
#line 251
    *rp = index + n;
#line 251
#endif
#line 251
    IF_TOS(TOS = sp[0]);
#line 251
	SET_IP((Xt *)(((Cell)IP)+(Cell)NEXT_INST));
#line 251
	NEXT;
#line 251
}
#line 251
else
#line 251
    INC_IP(1);
#line 251
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

#ifdef HAS_GLOCALS
I_paren_plus_loop_lp_plus_store_number:	/* (+loop)-lp+!# ( n -- ) */
/*  */
NAME("(+loop)-lp+!#")
{
DEF_CA
Cell n;
NEXT_P0;
n = (Cell) TOS;
sp += 1;
{
#line 251 "/a5/anton/gforth/prim"
/* !! check this thoroughly */
#line 251
Cell index = *rp;
#line 251
/* sign bit manipulation and test: (x^y)<0 is equivalent to (x<0) != (y<0) */
#line 251
/* dependent upon two's complement arithmetic */
#line 251
Cell olddiff = index-rp[1];
#line 251
if ((olddiff^(olddiff+n))>=0   /* the limit is not crossed */
#line 251
    || (olddiff^n)>=0          /* it is a wrap-around effect */) {
#line 251
#ifdef i386
#line 251
    *rp += n;
#line 251
#else
#line 251
    *rp = index + n;
#line 251
#endif
#line 251
    IF_TOS(TOS = sp[0]);
#line 251
    goto branch_adjust_lp;
#line 251
}
#line 251
else
#line 251
    INC_IP(2);
#line 251
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

#endif
#ifdef HAS_XCONDS
I_paren_minus_loop:	/* (-loop) ( u -- ) */
/*  */
NAME("(-loop)")
{
DEF_CA
UCell u;
NEXT_P0;
u = (UCell) TOS;
sp += 1;
{
#line 266 "/a5/anton/gforth/prim"
/* !! check this thoroughly */
#line 266
Cell index = *rp;
#line 266
UCell olddiff = index-rp[1];
#line 266
if (olddiff>u) {
#line 266
#ifdef i386
#line 266
    *rp -= u;
#line 266
#else
#line 266
    *rp = index - u;
#line 266
#endif
#line 266
    IF_TOS(TOS = sp[0]);
#line 266
	SET_IP((Xt *)(((Cell)IP)+(Cell)NEXT_INST));
#line 266
	NEXT;
#line 266
}
#line 266
else
#line 266
    INC_IP(1);
#line 266
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

#ifdef HAS_GLOCALS
I_paren_minus_loop_lp_plus_store_number:	/* (-loop)-lp+!# ( u -- ) */
/*  */
NAME("(-loop)-lp+!#")
{
DEF_CA
UCell u;
NEXT_P0;
u = (UCell) TOS;
sp += 1;
{
#line 266 "/a5/anton/gforth/prim"
/* !! check this thoroughly */
#line 266
Cell index = *rp;
#line 266
UCell olddiff = index-rp[1];
#line 266
if (olddiff>u) {
#line 266
#ifdef i386
#line 266
    *rp -= u;
#line 266
#else
#line 266
    *rp = index - u;
#line 266
#endif
#line 266
    IF_TOS(TOS = sp[0]);
#line 266
    goto branch_adjust_lp;
#line 266
}
#line 266
else
#line 266
    INC_IP(2);
#line 266
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

#endif
I_paren_symmetric_plus_loop:	/* (s+loop) ( n -- ) */
/* The run-time procedure compiled by S+LOOP. It loops until the index
crosses the boundary between limit and limit-sign(n). I.e. a symmetric
version of (+LOOP). */
NAME("(s+loop)")
{
DEF_CA
Cell n;
NEXT_P0;
n = (Cell) TOS;
sp += 1;
{
#line 287 "/a5/anton/gforth/prim"
/* !! check this thoroughly */
#line 287
Cell index = *rp;
#line 287
Cell diff = index-rp[1];
#line 287
Cell newdiff = diff+n;
#line 287
if (n<0) {
#line 287
    diff = -diff;
#line 287
    newdiff = -newdiff;
#line 287
}
#line 287
if (diff>=0 || newdiff<0) {
#line 287
#ifdef i386
#line 287
    *rp += n;
#line 287
#else
#line 287
    *rp = index + n;
#line 287
#endif
#line 287
    IF_TOS(TOS = sp[0]);
#line 287
	SET_IP((Xt *)(((Cell)IP)+(Cell)NEXT_INST));
#line 287
	NEXT;
#line 287
}
#line 287
else
#line 287
    INC_IP(1);
#line 287
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

#ifdef HAS_GLOCALS
I_paren_symmetric_plus_loop_lp_plus_store_number:	/* (s+loop)-lp+!# ( n -- ) */
/* The run-time procedure compiled by S+LOOP. It loops until the index
crosses the boundary between limit and limit-sign(n). I.e. a symmetric
version of (+LOOP). */
NAME("(s+loop)-lp+!#")
{
DEF_CA
Cell n;
NEXT_P0;
n = (Cell) TOS;
sp += 1;
{
#line 287 "/a5/anton/gforth/prim"
/* !! check this thoroughly */
#line 287
Cell index = *rp;
#line 287
Cell diff = index-rp[1];
#line 287
Cell newdiff = diff+n;
#line 287
if (n<0) {
#line 287
    diff = -diff;
#line 287
    newdiff = -newdiff;
#line 287
}
#line 287
if (diff>=0 || newdiff<0) {
#line 287
#ifdef i386
#line 287
    *rp += n;
#line 287
#else
#line 287
    *rp = index + n;
#line 287
#endif
#line 287
    IF_TOS(TOS = sp[0]);
#line 287
    goto branch_adjust_lp;
#line 287
}
#line 287
else
#line 287
    INC_IP(2);
#line 287
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

#endif
#endif
I_unloop:	/* unloop ( -- ) */
/*  */
NAME("unloop")
{
DEF_CA
NEXT_P0;
{
#line 292 "/a5/anton/gforth/prim"
rp += 2;
}
NEXT_P1;
NEXT_P2;
}

I_paren_for:	/* (for) ( ncount -- ) */
/*  */
NAME("(for)")
{
DEF_CA
Cell ncount;
NEXT_P0;
ncount = (Cell) TOS;
sp += 1;
{
#line 297 "/a5/anton/gforth/prim"
/* or (for) = >r -- collides with unloop! */
*--rp = 0;
*--rp = ncount;
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_paren_do:	/* (do) ( nlimit nstart -- ) */
/*  */
NAME("(do)")
{
DEF_CA
Cell nlimit;
Cell nstart;
NEXT_P0;
nlimit = (Cell) sp[1];
nstart = (Cell) TOS;
sp += 2;
{
#line 304 "/a5/anton/gforth/prim"
/* or do it in high-level? 0.09/0.23% */
*--rp = nlimit;
*--rp = nstart;
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_paren_question_do:	/* (?do) ( nlimit nstart -- ) */
/*  */
NAME("(?do)")
{
DEF_CA
Cell nlimit;
Cell nstart;
NEXT_P0;
nlimit = (Cell) sp[1];
nstart = (Cell) TOS;
sp += 2;
{
#line 311 "/a5/anton/gforth/prim"
*--rp = nlimit;
*--rp = nstart;
if (nstart == nlimit) {
    IF_TOS(TOS = sp[0]);
    goto branch;
    }
else {
    INC_IP(1);
}
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

#ifdef HAS_XCONDS
I_paren_plus_do:	/* (+do) ( nlimit nstart -- ) */
/*  */
NAME("(+do)")
{
DEF_CA
Cell nlimit;
Cell nstart;
NEXT_P0;
nlimit = (Cell) sp[1];
nstart = (Cell) TOS;
sp += 2;
{
#line 331 "/a5/anton/gforth/prim"
*--rp = nlimit;
*--rp = nstart;
if (nstart >= nlimit) {
    IF_TOS(TOS = sp[0]);
    goto branch;
    }
else {
    INC_IP(1);
}
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_paren_u_plus_do:	/* (u+do) ( ulimit ustart -- ) */
/*  */
NAME("(u+do)")
{
DEF_CA
UCell ulimit;
UCell ustart;
NEXT_P0;
ulimit = (UCell) sp[1];
ustart = (UCell) TOS;
sp += 2;
{
#line 351 "/a5/anton/gforth/prim"
*--rp = ulimit;
*--rp = ustart;
if (ustart >= ulimit) {
    IF_TOS(TOS = sp[0]);
    goto branch;
    }
else {
    INC_IP(1);
}
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_paren_minus_do:	/* (-do) ( nlimit nstart -- ) */
/*  */
NAME("(-do)")
{
DEF_CA
Cell nlimit;
Cell nstart;
NEXT_P0;
nlimit = (Cell) sp[1];
nstart = (Cell) TOS;
sp += 2;
{
#line 371 "/a5/anton/gforth/prim"
*--rp = nlimit;
*--rp = nstart;
if (nstart <= nlimit) {
    IF_TOS(TOS = sp[0]);
    goto branch;
    }
else {
    INC_IP(1);
}
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_paren_u_minus_do:	/* (u-do) ( ulimit ustart -- ) */
/*  */
NAME("(u-do)")
{
DEF_CA
UCell ulimit;
UCell ustart;
NEXT_P0;
ulimit = (UCell) sp[1];
ustart = (UCell) TOS;
sp += 2;
{
#line 391 "/a5/anton/gforth/prim"
*--rp = ulimit;
*--rp = ustart;
if (ustart <= ulimit) {
    IF_TOS(TOS = sp[0]);
    goto branch;
    }
else {
    INC_IP(1);
}
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

#endif
I_i:	/* i ( -- n ) */
/*  */
NAME("i")
{
DEF_CA
Cell n;
NEXT_P0;
IF_TOS(sp[0] = TOS);
sp += -1;
{
#line 416 "/a5/anton/gforth/prim"
n = *rp;
}
NEXT_P1;
TOS = (Cell)n;
NEXT_P2;
}

I_i_tick:	/* i' ( -- w ) */
/* loop end value */
NAME("i'")
{
DEF_CA
Cell w;
NEXT_P0;
IF_TOS(sp[0] = TOS);
sp += -1;
{
#line 423 "/a5/anton/gforth/prim"
w = rp[1];
}
NEXT_P1;
TOS = (Cell)w;
NEXT_P2;
}

I_j:	/* j ( -- n ) */
/*  */
NAME("j")
{
DEF_CA
Cell n;
NEXT_P0;
IF_TOS(sp[0] = TOS);
sp += -1;
{
#line 430 "/a5/anton/gforth/prim"
n = rp[2];
}
NEXT_P1;
TOS = (Cell)n;
NEXT_P2;
}

I_k:	/* k ( -- n ) */
/*  */
NAME("k")
{
DEF_CA
Cell n;
NEXT_P0;
IF_TOS(sp[0] = TOS);
sp += -1;
{
#line 437 "/a5/anton/gforth/prim"
n = rp[4];
}
NEXT_P1;
TOS = (Cell)n;
NEXT_P2;
}

I_move:	/* move ( c_from c_to ucount -- ) */
/* Copy the contents of @i{ucount} address units at @i{c-from} to
@i{c-to}. @code{move} works correctly even if the two areas overlap. */
NAME("move")
{
DEF_CA
Char * c_from;
Char * c_to;
UCell ucount;
NEXT_P0;
c_from = (Char *) sp[2];
c_to = (Char *) sp[1];
ucount = (UCell) TOS;
sp += 3;
{
#line 450 "/a5/anton/gforth/prim"
memmove(c_to,c_from,ucount);
/* make an Ifdef for bsd and others? */
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_c_move:	/* cmove ( c_from c_to u -- ) */
/* Copy the contents of @i{ucount} characters from data space at
@i{c-from} to @i{c-to}. The copy proceeds @code{char}-by-@code{char}
from low address to high address; i.e., for overlapping areas it is
safe if @i{c-to}=<@i{c-from}. */
NAME("cmove")
{
DEF_CA
Char * c_from;
Char * c_to;
UCell u;
NEXT_P0;
c_from = (Char *) sp[2];
c_to = (Char *) sp[1];
u = (UCell) TOS;
sp += 3;
{
#line 460 "/a5/anton/gforth/prim"
while (u-- > 0)
  *c_to++ = *c_from++;
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_c_move_up:	/* cmove> ( c_from c_to u -- ) */
/* Copy the contents of @i{ucount} characters from data space at
@i{c-from} to @i{c-to}. The copy proceeds @code{char}-by-@code{char}
from high address to low address; i.e., for overlapping areas it is
safe if @i{c-to}>=@i{c-from}. */
NAME("cmove>")
{
DEF_CA
Char * c_from;
Char * c_to;
UCell u;
NEXT_P0;
c_from = (Char *) sp[2];
c_to = (Char *) sp[1];
u = (UCell) TOS;
sp += 3;
{
#line 470 "/a5/anton/gforth/prim"
while (u-- > 0)
  c_to[u] = c_from[u];
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_fill:	/* fill ( c_addr u c -- ) */
/*  If @i{u}>0, store character @i{c} in each of @i{u} consecutive
@code{char} addresses in memory, starting at address @i{c-addr}. */
NAME("fill")
{
DEF_CA
Char * c_addr;
UCell u;
Char c;
NEXT_P0;
c_addr = (Char *) sp[2];
u = (UCell) sp[1];
c = (Char) TOS;
sp += 3;
{
#line 480 "/a5/anton/gforth/prim"
memset(c_addr,c,u);
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_compare:	/* compare ( c_addr1 u1 c_addr2 u2 -- n ) */
/* Compare two strings lexicographically. If they are equal, @i{n} is 0; if
the first string is smaller, @i{n} is -1; if the first string is larger, @i{n}
is 1. Currently this is based on the machine's character
comparison. In the future, this may change to consider the current
locale and its collation order. */
NAME("compare")
{
DEF_CA
Char * c_addr1;
UCell u1;
Char * c_addr2;
UCell u2;
Cell n;
NEXT_P0;
c_addr1 = (Char *) sp[3];
u1 = (UCell) sp[2];
c_addr2 = (Char *) sp[1];
u2 = (UCell) TOS;
sp += 3;
{
#line 491 "/a5/anton/gforth/prim"
/* close ' to keep fontify happy */ 
n = memcmp(c_addr1, c_addr2, u1<u2 ? u1 : u2);
if (n==0)
  n = u1-u2;
if (n<0)
  n = -1;
else if (n>0)
  n = 1;
}
NEXT_P1;
TOS = (Cell)n;
NEXT_P2;
}

I_dash_text:	/* -text ( c_addr1 u c_addr2 -- n ) */
/*  */
NAME("-text")
{
DEF_CA
Char * c_addr1;
UCell u;
Char * c_addr2;
Cell n;
NEXT_P0;
c_addr1 = (Char *) sp[2];
u = (UCell) sp[1];
c_addr2 = (Char *) TOS;
sp += 2;
{
#line 506 "/a5/anton/gforth/prim"
n = memcmp(c_addr1, c_addr2, u);
if (n<0)
  n = -1;
else if (n>0)
  n = 1;
}
NEXT_P1;
TOS = (Cell)n;
NEXT_P2;
}

I_toupper:	/* toupper ( c1 -- c2 ) */
/* If @i{c1} is a lower-case character (in the current locale), @i{c2}
is the equivalent upper-case character. All other characters are unchanged. */
NAME("toupper")
{
DEF_CA
Char c1;
Char c2;
NEXT_P0;
c1 = (Char) TOS;
{
#line 521 "/a5/anton/gforth/prim"
c2 = toupper(c1);
}
NEXT_P1;
TOS = (Cell)c2;
NEXT_P2;
}

I_capscomp:	/* capscomp ( c_addr1 u c_addr2 -- n ) */
/*  */
NAME("capscomp")
{
DEF_CA
Char * c_addr1;
UCell u;
Char * c_addr2;
Cell n;
NEXT_P0;
c_addr1 = (Char *) sp[2];
u = (UCell) sp[1];
c_addr2 = (Char *) TOS;
sp += 2;
{
#line 526 "/a5/anton/gforth/prim"
n = memcasecmp(c_addr1, c_addr2, u); /* !! use something that works in all locales */
if (n<0)
  n = -1;
else if (n>0)
  n = 1;
}
NEXT_P1;
TOS = (Cell)n;
NEXT_P2;
}

I_dash_trailing:	/* -trailing ( c_addr u1 -- c_addr u2 ) */
/* Adjust the string specified by @i{c-addr, u1} to remove all trailing
spaces. @i{u2} is the length of the modified string. */
NAME("-trailing")
{
DEF_CA
Char * c_addr;
UCell u1;
UCell u2;
NEXT_P0;
c_addr = (Char *) sp[1];
u1 = (UCell) TOS;
{
#line 541 "/a5/anton/gforth/prim"
u2 = u1;
while (u2>0 && c_addr[u2-1] == ' ')
  u2--;
}
NEXT_P1;
TOS = (Cell)u2;
NEXT_P2;
}

I_slash_string:	/* /string ( c_addr1 u1 n -- c_addr2 u2 ) */
/* Adjust the string specified by @i{c-addr1, u1} to remove @i{n}
characters from the start of the string. */
NAME("/string")
{
DEF_CA
Char * c_addr1;
UCell u1;
Cell n;
Char * c_addr2;
UCell u2;
NEXT_P0;
c_addr1 = (Char *) sp[2];
u1 = (UCell) sp[1];
n = (Cell) TOS;
sp += 1;
{
#line 551 "/a5/anton/gforth/prim"
c_addr2 = c_addr1+n;
u2 = u1-n;
}
NEXT_P1;
sp[1] = (Cell)c_addr2;
TOS = (Cell)u2;
NEXT_P2;
}

I_plus:	/* + ( n1 n2 -- n ) */
/*  */
NAME("+")
{
DEF_CA
Cell n1;
Cell n2;
Cell n;
NEXT_P0;
n1 = (Cell) sp[1];
n2 = (Cell) TOS;
sp += 1;
{
#line 557 "/a5/anton/gforth/prim"
n = n1+n2;
}
NEXT_P1;
TOS = (Cell)n;
NEXT_P2;
}

I_under_plus:	/* under+ ( n1 n2 n3 -- n n2 ) */
/* add @i{n3} to @i{n1} (giving @i{n}) */
NAME("under+")
{
DEF_CA
Cell n1;
Cell n2;
Cell n3;
Cell n;
NEXT_P0;
n1 = (Cell) sp[2];
n2 = (Cell) sp[1];
n3 = (Cell) TOS;
sp += 1;
{
#line 562 "/a5/anton/gforth/prim"
n = n1+n3;
}
NEXT_P1;
sp[1] = (Cell)n;
IF_TOS(TOS = (Cell)n2;);
NEXT_P2;
}

I_minus:	/* - ( n1 n2 -- n ) */
/*  */
NAME("-")
{
DEF_CA
Cell n1;
Cell n2;
Cell n;
NEXT_P0;
n1 = (Cell) sp[1];
n2 = (Cell) TOS;
sp += 1;
{
#line 567 "/a5/anton/gforth/prim"
n = n1-n2;
}
NEXT_P1;
TOS = (Cell)n;
NEXT_P2;
}

I_negate:	/* negate ( n1 -- n2 ) */
/*  */
NAME("negate")
{
DEF_CA
Cell n1;
Cell n2;
NEXT_P0;
n1 = (Cell) TOS;
{
#line 572 "/a5/anton/gforth/prim"
/* use minus as alias */
n2 = -n1;
}
NEXT_P1;
TOS = (Cell)n2;
NEXT_P2;
}

I_one_plus:	/* 1+ ( n1 -- n2 ) */
/*  */
NAME("1+")
{
DEF_CA
Cell n1;
Cell n2;
NEXT_P0;
n1 = (Cell) TOS;
{
#line 578 "/a5/anton/gforth/prim"
n2 = n1+1;
}
NEXT_P1;
TOS = (Cell)n2;
NEXT_P2;
}

I_one_minus:	/* 1- ( n1 -- n2 ) */
/*  */
NAME("1-")
{
DEF_CA
Cell n1;
Cell n2;
NEXT_P0;
n1 = (Cell) TOS;
{
#line 583 "/a5/anton/gforth/prim"
n2 = n1-1;
}
NEXT_P1;
TOS = (Cell)n2;
NEXT_P2;
}

I_max:	/* max ( n1 n2 -- n ) */
/*  */
NAME("max")
{
DEF_CA
Cell n1;
Cell n2;
Cell n;
NEXT_P0;
n1 = (Cell) sp[1];
n2 = (Cell) TOS;
sp += 1;
{
#line 588 "/a5/anton/gforth/prim"
if (n1<n2)
  n = n2;
else
  n = n1;
}
NEXT_P1;
TOS = (Cell)n;
NEXT_P2;
}

I_min:	/* min ( n1 n2 -- n ) */
/*  */
NAME("min")
{
DEF_CA
Cell n1;
Cell n2;
Cell n;
NEXT_P0;
n1 = (Cell) sp[1];
n2 = (Cell) TOS;
sp += 1;
{
#line 596 "/a5/anton/gforth/prim"
if (n1<n2)
  n = n1;
else
  n = n2;
}
NEXT_P1;
TOS = (Cell)n;
NEXT_P2;
}

I_abs:	/* abs ( n1 -- n2 ) */
/*  */
NAME("abs")
{
DEF_CA
Cell n1;
Cell n2;
NEXT_P0;
n1 = (Cell) TOS;
{
#line 604 "/a5/anton/gforth/prim"
if (n1<0)
  n2 = -n1;
else
  n2 = n1;
}
NEXT_P1;
TOS = (Cell)n2;
NEXT_P2;
}

I_star:	/* * ( n1 n2 -- n ) */
/*  */
NAME("*")
{
DEF_CA
Cell n1;
Cell n2;
Cell n;
NEXT_P0;
n1 = (Cell) sp[1];
n2 = (Cell) TOS;
sp += 1;
{
#line 612 "/a5/anton/gforth/prim"
n = n1*n2;
}
NEXT_P1;
TOS = (Cell)n;
NEXT_P2;
}

I_slash:	/* / ( n1 n2 -- n ) */
/*  */
NAME("/")
{
DEF_CA
Cell n1;
Cell n2;
Cell n;
NEXT_P0;
n1 = (Cell) sp[1];
n2 = (Cell) TOS;
sp += 1;
{
#line 617 "/a5/anton/gforth/prim"
n = n1/n2;
}
NEXT_P1;
TOS = (Cell)n;
NEXT_P2;
}

I_mod:	/* mod ( n1 n2 -- n ) */
/*  */
NAME("mod")
{
DEF_CA
Cell n1;
Cell n2;
Cell n;
NEXT_P0;
n1 = (Cell) sp[1];
n2 = (Cell) TOS;
sp += 1;
{
#line 622 "/a5/anton/gforth/prim"
n = n1%n2;
}
NEXT_P1;
TOS = (Cell)n;
NEXT_P2;
}

I_slash_mod:	/* /mod ( n1 n2 -- n3 n4 ) */
/*  */
NAME("/mod")
{
DEF_CA
Cell n1;
Cell n2;
Cell n3;
Cell n4;
NEXT_P0;
n1 = (Cell) sp[1];
n2 = (Cell) TOS;
{
#line 627 "/a5/anton/gforth/prim"
n4 = n1/n2;
n3 = n1%n2; /* !! is this correct? look into C standard! */
}
NEXT_P1;
sp[1] = (Cell)n3;
TOS = (Cell)n4;
NEXT_P2;
}

I_two_star:	/* 2* ( n1 -- n2 ) */
/*  */
NAME("2*")
{
DEF_CA
Cell n1;
Cell n2;
NEXT_P0;
n1 = (Cell) TOS;
{
#line 633 "/a5/anton/gforth/prim"
n2 = 2*n1;
}
NEXT_P1;
TOS = (Cell)n2;
NEXT_P2;
}

I_two_slash:	/* 2/ ( n1 -- n2 ) */
/*  */
NAME("2/")
{
DEF_CA
Cell n1;
Cell n2;
NEXT_P0;
n1 = (Cell) TOS;
{
#line 638 "/a5/anton/gforth/prim"
/* !! is this still correct? */
n2 = n1>>1;
}
NEXT_P1;
TOS = (Cell)n2;
NEXT_P2;
}

I_f_m_slash_mod:	/* fm/mod ( d1 n1 -- n2 n3 ) */
/* Floored division: @i{d1} = @i{n3}*@i{n1}+@i{n2}, @i{n1}>@i{n2}>=0 or 0>=@i{n2}>@i{n1}. */
NAME("fm/mod")
{
DEF_CA
DCell d1;
Cell n1;
Cell n2;
Cell n3;
NEXT_P0;
FETCH_DCELL(d1, sp[2], sp[1]);
n1 = (Cell) TOS;
sp += 1;
{
#line 649 "/a5/anton/gforth/prim"
#ifdef BUGGY_LONG_LONG
DCell r = fmdiv(d1,n1);
n2=r.hi;
n3=r.lo;
#else
/* assumes that the processor uses either floored or symmetric division */
n3 = d1/n1;
n2 = d1%n1;
/* note that this 1%-3>0 is optimized by the compiler */
if (1%-3>0 && (d1<0) != (n1<0) && n2!=0) {
  n3--;
  n2+=n1;
}
#endif
}
NEXT_P1;
sp[1] = (Cell)n2;
TOS = (Cell)n3;
NEXT_P2;
}

I_s_m_slash_rem:	/* sm/rem ( d1 n1 -- n2 n3 ) */
/* Symmetric division: @i{d1} = @i{n3}*@i{n1}+@i{n2}, sign(@i{n2})=sign(@i{d1}) or 0. */
NAME("sm/rem")
{
DEF_CA
DCell d1;
Cell n1;
Cell n2;
Cell n3;
NEXT_P0;
FETCH_DCELL(d1, sp[2], sp[1]);
n1 = (Cell) TOS;
sp += 1;
{
#line 671 "/a5/anton/gforth/prim"
#ifdef BUGGY_LONG_LONG
DCell r = smdiv(d1,n1);
n2=r.hi;
n3=r.lo;
#else
/* assumes that the processor uses either floored or symmetric division */
n3 = d1/n1;
n2 = d1%n1;
/* note that this 1%-3<0 is optimized by the compiler */
if (1%-3<0 && (d1<0) != (n1<0) && n2!=0) {
  n3++;
  n2-=n1;
}
#endif
}
NEXT_P1;
sp[1] = (Cell)n2;
TOS = (Cell)n3;
NEXT_P2;
}

I_m_star:	/* m* ( n1 n2 -- d ) */
/*  */
NAME("m*")
{
DEF_CA
Cell n1;
Cell n2;
DCell d;
NEXT_P0;
n1 = (Cell) sp[1];
n2 = (Cell) TOS;
{
#line 692 "/a5/anton/gforth/prim"
#ifdef BUGGY_LONG_LONG
d = mmul(n1,n2);
#else
d = (DCell)n1 * (DCell)n2;
#endif
}
NEXT_P1;
STORE_DCELL(d, sp[1], TOS);
NEXT_P2;
}

I_u_m_star:	/* um* ( u1 u2 -- ud ) */
/*  */
NAME("um*")
{
DEF_CA
UCell u1;
UCell u2;
UDCell ud;
NEXT_P0;
u1 = (UCell) sp[1];
u2 = (UCell) TOS;
{
#line 703 "/a5/anton/gforth/prim"
/* use u* as alias */
#ifdef BUGGY_LONG_LONG
ud = ummul(u1,u2);
#else
ud = (UDCell)u1 * (UDCell)u2;
#endif
}
NEXT_P1;
STORE_DCELL(ud, sp[1], TOS);
NEXT_P2;
}

I_u_m_slash_mod:	/* um/mod ( ud u1 -- u2 u3 ) */
/* ud=u3*u1+u2, u1>u2>=0 */
NAME("um/mod")
{
DEF_CA
UDCell ud;
UCell u1;
UCell u2;
UCell u3;
NEXT_P0;
FETCH_DCELL(ud, sp[2], sp[1]);
u1 = (UCell) TOS;
sp += 1;
{
#line 721 "/a5/anton/gforth/prim"
#ifdef BUGGY_LONG_LONG
UDCell r = umdiv(ud,u1);
u2=r.hi;
u3=r.lo;
#else
u3 = ud/u1;
u2 = ud%u1;
#endif
}
NEXT_P1;
sp[1] = (Cell)u2;
TOS = (Cell)u3;
NEXT_P2;
}

I_m_plus:	/* m+ ( d1 n -- d2 ) */
/*  */
NAME("m+")
{
DEF_CA
DCell d1;
Cell n;
DCell d2;
NEXT_P0;
FETCH_DCELL(d1, sp[2], sp[1]);
n = (Cell) TOS;
sp += 1;
{
#line 740 "/a5/anton/gforth/prim"
#ifdef BUGGY_LONG_LONG
d2.lo = d1.lo+n;
d2.hi = d1.hi - (n<0) + (d2.lo<d1.lo);
#else
d2 = d1+n;
#endif
}
NEXT_P1;
STORE_DCELL(d2, sp[1], TOS);
NEXT_P2;
}

I_d_plus:	/* d+ ( d1 d2 -- d ) */
/*  */
NAME("d+")
{
DEF_CA
DCell d1;
DCell d2;
DCell d;
NEXT_P0;
FETCH_DCELL(d1, sp[3], sp[2]);
FETCH_DCELL(d2, sp[1], TOS);
sp += 2;
{
#line 750 "/a5/anton/gforth/prim"
#ifdef BUGGY_LONG_LONG
d.lo = d1.lo+d2.lo;
d.hi = d1.hi + d2.hi + (d.lo<d1.lo);
#else
d = d1+d2;
#endif
}
NEXT_P1;
STORE_DCELL(d, sp[1], TOS);
NEXT_P2;
}

I_d_minus:	/* d- ( d1 d2 -- d ) */
/*  */
NAME("d-")
{
DEF_CA
DCell d1;
DCell d2;
DCell d;
NEXT_P0;
FETCH_DCELL(d1, sp[3], sp[2]);
FETCH_DCELL(d2, sp[1], TOS);
sp += 2;
{
#line 760 "/a5/anton/gforth/prim"
#ifdef BUGGY_LONG_LONG
d.lo = d1.lo - d2.lo;
d.hi = d1.hi-d2.hi-(d1.lo<d2.lo);
#else
d = d1-d2;
#endif
}
NEXT_P1;
STORE_DCELL(d, sp[1], TOS);
NEXT_P2;
}

I_d_negate:	/* dnegate ( d1 -- d2 ) */
/*  */
NAME("dnegate")
{
DEF_CA
DCell d1;
DCell d2;
NEXT_P0;
FETCH_DCELL(d1, sp[1], TOS);
{
#line 770 "/a5/anton/gforth/prim"
/* use dminus as alias */
#ifdef BUGGY_LONG_LONG
d2 = dnegate(d1);
#else
d2 = -d1;
#endif
}
NEXT_P1;
STORE_DCELL(d2, sp[1], TOS);
NEXT_P2;
}

I_d_two_star:	/* d2* ( d1 -- d2 ) */
/*  */
NAME("d2*")
{
DEF_CA
DCell d1;
DCell d2;
NEXT_P0;
FETCH_DCELL(d1, sp[1], TOS);
{
#line 780 "/a5/anton/gforth/prim"
#ifdef BUGGY_LONG_LONG
d2.lo = d1.lo<<1;
d2.hi = (d1.hi<<1) | (d1.lo>>(CELL_BITS-1));
#else
d2 = 2*d1;
#endif
}
NEXT_P1;
STORE_DCELL(d2, sp[1], TOS);
NEXT_P2;
}

I_d_two_slash:	/* d2/ ( d1 -- d2 ) */
/*  */
NAME("d2/")
{
DEF_CA
DCell d1;
DCell d2;
NEXT_P0;
FETCH_DCELL(d1, sp[1], TOS);
{
#line 790 "/a5/anton/gforth/prim"
#ifdef BUGGY_LONG_LONG
d2.hi = d1.hi>>1;
d2.lo= (d1.lo>>1) | (d1.hi<<(CELL_BITS-1));
#else
d2 = d1>>1;
#endif
}
NEXT_P1;
STORE_DCELL(d2, sp[1], TOS);
NEXT_P2;
}

I_and:	/* and ( w1 w2 -- w ) */
/*  */
NAME("and")
{
DEF_CA
Cell w1;
Cell w2;
Cell w;
NEXT_P0;
w1 = (Cell) sp[1];
w2 = (Cell) TOS;
sp += 1;
{
#line 801 "/a5/anton/gforth/prim"
w = w1&w2;
}
NEXT_P1;
TOS = (Cell)w;
NEXT_P2;
}

I_or:	/* or ( w1 w2 -- w ) */
/*  */
NAME("or")
{
DEF_CA
Cell w1;
Cell w2;
Cell w;
NEXT_P0;
w1 = (Cell) sp[1];
w2 = (Cell) TOS;
sp += 1;
{
#line 804 "/a5/anton/gforth/prim"
w = w1|w2;
}
NEXT_P1;
TOS = (Cell)w;
NEXT_P2;
}

I_x_or:	/* xor ( w1 w2 -- w ) */
/*  */
NAME("xor")
{
DEF_CA
Cell w1;
Cell w2;
Cell w;
NEXT_P0;
w1 = (Cell) sp[1];
w2 = (Cell) TOS;
sp += 1;
{
#line 809 "/a5/anton/gforth/prim"
w = w1^w2;
}
NEXT_P1;
TOS = (Cell)w;
NEXT_P2;
}

I_invert:	/* invert ( w1 -- w2 ) */
/*  */
NAME("invert")
{
DEF_CA
Cell w1;
Cell w2;
NEXT_P0;
w1 = (Cell) TOS;
{
#line 812 "/a5/anton/gforth/prim"
w2 = ~w1;
}
NEXT_P1;
TOS = (Cell)w2;
NEXT_P2;
}

I_r_shift:	/* rshift ( u1 n -- u2 ) */
/*  */
NAME("rshift")
{
DEF_CA
UCell u1;
Cell n;
UCell u2;
NEXT_P0;
u1 = (UCell) sp[1];
n = (Cell) TOS;
sp += 1;
{
#line 817 "/a5/anton/gforth/prim"
  u2 = u1>>n;
}
NEXT_P1;
TOS = (Cell)u2;
NEXT_P2;
}

I_l_shift:	/* lshift ( u1 n -- u2 ) */
/*  */
NAME("lshift")
{
DEF_CA
UCell u1;
Cell n;
UCell u2;
NEXT_P0;
u1 = (UCell) sp[1];
n = (Cell) TOS;
sp += 1;
{
#line 822 "/a5/anton/gforth/prim"
  u2 = u1<<n;
}
NEXT_P1;
TOS = (Cell)u2;
NEXT_P2;
}

I_zero_equals:	/* 0= ( n -- f ) */
/*  */
NAME("0=")
{
DEF_CA
Cell n;
Bool f;
NEXT_P0;
n = (Cell) TOS;
{
#line 877 "/a5/anton/gforth/prim"
f = FLAG(n==0);
#line 877
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_zero_not_equals:	/* 0<> ( n -- f ) */
/*  */
NAME("0<>")
{
DEF_CA
Cell n;
Bool f;
NEXT_P0;
n = (Cell) TOS;
{
#line 877 "/a5/anton/gforth/prim"
f = FLAG(n!=0);
#line 877
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_zero_less_than:	/* 0< ( n -- f ) */
/*  */
NAME("0<")
{
DEF_CA
Cell n;
Bool f;
NEXT_P0;
n = (Cell) TOS;
{
#line 877 "/a5/anton/gforth/prim"
f = FLAG(n<0);
#line 877
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_zero_greater_than:	/* 0> ( n -- f ) */
/*  */
NAME("0>")
{
DEF_CA
Cell n;
Bool f;
NEXT_P0;
n = (Cell) TOS;
{
#line 877 "/a5/anton/gforth/prim"
f = FLAG(n>0);
#line 877
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_zero_less_or_equal:	/* 0<= ( n -- f ) */
/*  */
NAME("0<=")
{
DEF_CA
Cell n;
Bool f;
NEXT_P0;
n = (Cell) TOS;
{
#line 877 "/a5/anton/gforth/prim"
f = FLAG(n<=0);
#line 877
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_zero_greater_or_equal:	/* 0>= ( n -- f ) */
/*  */
NAME("0>=")
{
DEF_CA
Cell n;
Bool f;
NEXT_P0;
n = (Cell) TOS;
{
#line 877 "/a5/anton/gforth/prim"
f = FLAG(n>=0);
#line 877
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_equals:	/* = ( n1 n2 -- f ) */
/*  */
NAME("=")
{
DEF_CA
Cell n1;
Cell n2;
Bool f;
NEXT_P0;
n1 = (Cell) sp[1];
n2 = (Cell) TOS;
sp += 1;
{
#line 878 "/a5/anton/gforth/prim"
f = FLAG(n1==n2);
#line 878
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_not_equals:	/* <> ( n1 n2 -- f ) */
/*  */
NAME("<>")
{
DEF_CA
Cell n1;
Cell n2;
Bool f;
NEXT_P0;
n1 = (Cell) sp[1];
n2 = (Cell) TOS;
sp += 1;
{
#line 878 "/a5/anton/gforth/prim"
f = FLAG(n1!=n2);
#line 878
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_less_than:	/* < ( n1 n2 -- f ) */
/*  */
NAME("<")
{
DEF_CA
Cell n1;
Cell n2;
Bool f;
NEXT_P0;
n1 = (Cell) sp[1];
n2 = (Cell) TOS;
sp += 1;
{
#line 878 "/a5/anton/gforth/prim"
f = FLAG(n1<n2);
#line 878
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_greater_than:	/* > ( n1 n2 -- f ) */
/*  */
NAME(">")
{
DEF_CA
Cell n1;
Cell n2;
Bool f;
NEXT_P0;
n1 = (Cell) sp[1];
n2 = (Cell) TOS;
sp += 1;
{
#line 878 "/a5/anton/gforth/prim"
f = FLAG(n1>n2);
#line 878
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_less_or_equal:	/* <= ( n1 n2 -- f ) */
/*  */
NAME("<=")
{
DEF_CA
Cell n1;
Cell n2;
Bool f;
NEXT_P0;
n1 = (Cell) sp[1];
n2 = (Cell) TOS;
sp += 1;
{
#line 878 "/a5/anton/gforth/prim"
f = FLAG(n1<=n2);
#line 878
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_greater_or_equal:	/* >= ( n1 n2 -- f ) */
/*  */
NAME(">=")
{
DEF_CA
Cell n1;
Cell n2;
Bool f;
NEXT_P0;
n1 = (Cell) sp[1];
n2 = (Cell) TOS;
sp += 1;
{
#line 878 "/a5/anton/gforth/prim"
f = FLAG(n1>=n2);
#line 878
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_u_equals:	/* u= ( u1 u2 -- f ) */
/*  */
NAME("u=")
{
DEF_CA
UCell u1;
UCell u2;
Bool f;
NEXT_P0;
u1 = (UCell) sp[1];
u2 = (UCell) TOS;
sp += 1;
{
#line 879 "/a5/anton/gforth/prim"
f = FLAG(u1==u2);
#line 879
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_u_not_equals:	/* u<> ( u1 u2 -- f ) */
/*  */
NAME("u<>")
{
DEF_CA
UCell u1;
UCell u2;
Bool f;
NEXT_P0;
u1 = (UCell) sp[1];
u2 = (UCell) TOS;
sp += 1;
{
#line 879 "/a5/anton/gforth/prim"
f = FLAG(u1!=u2);
#line 879
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_u_less_than:	/* u< ( u1 u2 -- f ) */
/*  */
NAME("u<")
{
DEF_CA
UCell u1;
UCell u2;
Bool f;
NEXT_P0;
u1 = (UCell) sp[1];
u2 = (UCell) TOS;
sp += 1;
{
#line 879 "/a5/anton/gforth/prim"
f = FLAG(u1<u2);
#line 879
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_u_greater_than:	/* u> ( u1 u2 -- f ) */
/*  */
NAME("u>")
{
DEF_CA
UCell u1;
UCell u2;
Bool f;
NEXT_P0;
u1 = (UCell) sp[1];
u2 = (UCell) TOS;
sp += 1;
{
#line 879 "/a5/anton/gforth/prim"
f = FLAG(u1>u2);
#line 879
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_u_less_or_equal:	/* u<= ( u1 u2 -- f ) */
/*  */
NAME("u<=")
{
DEF_CA
UCell u1;
UCell u2;
Bool f;
NEXT_P0;
u1 = (UCell) sp[1];
u2 = (UCell) TOS;
sp += 1;
{
#line 879 "/a5/anton/gforth/prim"
f = FLAG(u1<=u2);
#line 879
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_u_greater_or_equal:	/* u>= ( u1 u2 -- f ) */
/*  */
NAME("u>=")
{
DEF_CA
UCell u1;
UCell u2;
Bool f;
NEXT_P0;
u1 = (UCell) sp[1];
u2 = (UCell) TOS;
sp += 1;
{
#line 879 "/a5/anton/gforth/prim"
f = FLAG(u1>=u2);
#line 879
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

#ifdef HAS_DCOMPS
I_d_equals:	/* d= ( d1 d2 -- f ) */
/*  */
NAME("d=")
{
DEF_CA
DCell d1;
DCell d2;
Bool f;
NEXT_P0;
FETCH_DCELL(d1, sp[3], sp[2]);
FETCH_DCELL(d2, sp[1], TOS);
sp += 3;
{
#line 929 "/a5/anton/gforth/prim"
#ifdef BUGGY_LONG_LONG
#line 929
f = FLAG(d1.lo==d2.lo && d1.hi==d2.hi);
#line 929
#else
#line 929
f = FLAG(d1==d2);
#line 929
#endif
#line 929
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_d_not_equals:	/* d<> ( d1 d2 -- f ) */
/*  */
NAME("d<>")
{
DEF_CA
DCell d1;
DCell d2;
Bool f;
NEXT_P0;
FETCH_DCELL(d1, sp[3], sp[2]);
FETCH_DCELL(d2, sp[1], TOS);
sp += 3;
{
#line 929 "/a5/anton/gforth/prim"
#ifdef BUGGY_LONG_LONG
#line 929
f = FLAG(d1.lo!=d2.lo || d1.hi!=d2.hi);
#line 929
#else
#line 929
f = FLAG(d1!=d2);
#line 929
#endif
#line 929
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_d_less_than:	/* d< ( d1 d2 -- f ) */
/*  */
NAME("d<")
{
DEF_CA
DCell d1;
DCell d2;
Bool f;
NEXT_P0;
FETCH_DCELL(d1, sp[3], sp[2]);
FETCH_DCELL(d2, sp[1], TOS);
sp += 3;
{
#line 929 "/a5/anton/gforth/prim"
#ifdef BUGGY_LONG_LONG
#line 929
f = FLAG(d1.hi==d2.hi ? d1.lo<d2.lo : d1.hi<d2.hi);
#line 929
#else
#line 929
f = FLAG(d1<d2);
#line 929
#endif
#line 929
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_d_greater_than:	/* d> ( d1 d2 -- f ) */
/*  */
NAME("d>")
{
DEF_CA
DCell d1;
DCell d2;
Bool f;
NEXT_P0;
FETCH_DCELL(d1, sp[3], sp[2]);
FETCH_DCELL(d2, sp[1], TOS);
sp += 3;
{
#line 929 "/a5/anton/gforth/prim"
#ifdef BUGGY_LONG_LONG
#line 929
f = FLAG(d1.hi==d2.hi ? d1.lo>d2.lo : d1.hi>d2.hi);
#line 929
#else
#line 929
f = FLAG(d1>d2);
#line 929
#endif
#line 929
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_d_less_or_equal:	/* d<= ( d1 d2 -- f ) */
/*  */
NAME("d<=")
{
DEF_CA
DCell d1;
DCell d2;
Bool f;
NEXT_P0;
FETCH_DCELL(d1, sp[3], sp[2]);
FETCH_DCELL(d2, sp[1], TOS);
sp += 3;
{
#line 929 "/a5/anton/gforth/prim"
#ifdef BUGGY_LONG_LONG
#line 929
f = FLAG(d1.hi==d2.hi ? d1.lo<=d2.lo : d1.hi<=d2.hi);
#line 929
#else
#line 929
f = FLAG(d1<=d2);
#line 929
#endif
#line 929
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_d_greater_or_equal:	/* d>= ( d1 d2 -- f ) */
/*  */
NAME("d>=")
{
DEF_CA
DCell d1;
DCell d2;
Bool f;
NEXT_P0;
FETCH_DCELL(d1, sp[3], sp[2]);
FETCH_DCELL(d2, sp[1], TOS);
sp += 3;
{
#line 929 "/a5/anton/gforth/prim"
#ifdef BUGGY_LONG_LONG
#line 929
f = FLAG(d1.hi==d2.hi ? d1.lo>=d2.lo : d1.hi>=d2.hi);
#line 929
#else
#line 929
f = FLAG(d1>=d2);
#line 929
#endif
#line 929
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_d_zero_equals:	/* d0= ( d -- f ) */
/*  */
NAME("d0=")
{
DEF_CA
DCell d;
Bool f;
NEXT_P0;
FETCH_DCELL(d, sp[1], TOS);
sp += 1;
{
#line 930 "/a5/anton/gforth/prim"
#ifdef BUGGY_LONG_LONG
#line 930
f = FLAG(d.lo==DZERO.lo && d.hi==DZERO.hi);
#line 930
#else
#line 930
f = FLAG(d==DZERO);
#line 930
#endif
#line 930
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_d_zero_not_equals:	/* d0<> ( d -- f ) */
/*  */
NAME("d0<>")
{
DEF_CA
DCell d;
Bool f;
NEXT_P0;
FETCH_DCELL(d, sp[1], TOS);
sp += 1;
{
#line 930 "/a5/anton/gforth/prim"
#ifdef BUGGY_LONG_LONG
#line 930
f = FLAG(d.lo!=DZERO.lo || d.hi!=DZERO.hi);
#line 930
#else
#line 930
f = FLAG(d!=DZERO);
#line 930
#endif
#line 930
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_d_zero_less_than:	/* d0< ( d -- f ) */
/*  */
NAME("d0<")
{
DEF_CA
DCell d;
Bool f;
NEXT_P0;
FETCH_DCELL(d, sp[1], TOS);
sp += 1;
{
#line 930 "/a5/anton/gforth/prim"
#ifdef BUGGY_LONG_LONG
#line 930
f = FLAG(d.hi==DZERO.hi ? d.lo<DZERO.lo : d.hi<DZERO.hi);
#line 930
#else
#line 930
f = FLAG(d<DZERO);
#line 930
#endif
#line 930
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_d_zero_greater_than:	/* d0> ( d -- f ) */
/*  */
NAME("d0>")
{
DEF_CA
DCell d;
Bool f;
NEXT_P0;
FETCH_DCELL(d, sp[1], TOS);
sp += 1;
{
#line 930 "/a5/anton/gforth/prim"
#ifdef BUGGY_LONG_LONG
#line 930
f = FLAG(d.hi==DZERO.hi ? d.lo>DZERO.lo : d.hi>DZERO.hi);
#line 930
#else
#line 930
f = FLAG(d>DZERO);
#line 930
#endif
#line 930
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_d_zero_less_or_equal:	/* d0<= ( d -- f ) */
/*  */
NAME("d0<=")
{
DEF_CA
DCell d;
Bool f;
NEXT_P0;
FETCH_DCELL(d, sp[1], TOS);
sp += 1;
{
#line 930 "/a5/anton/gforth/prim"
#ifdef BUGGY_LONG_LONG
#line 930
f = FLAG(d.hi==DZERO.hi ? d.lo<=DZERO.lo : d.hi<=DZERO.hi);
#line 930
#else
#line 930
f = FLAG(d<=DZERO);
#line 930
#endif
#line 930
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_d_zero_greater_or_equal:	/* d0>= ( d -- f ) */
/*  */
NAME("d0>=")
{
DEF_CA
DCell d;
Bool f;
NEXT_P0;
FETCH_DCELL(d, sp[1], TOS);
sp += 1;
{
#line 930 "/a5/anton/gforth/prim"
#ifdef BUGGY_LONG_LONG
#line 930
f = FLAG(d.hi==DZERO.hi ? d.lo>=DZERO.lo : d.hi>=DZERO.hi);
#line 930
#else
#line 930
f = FLAG(d>=DZERO);
#line 930
#endif
#line 930
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_d_u_equals:	/* du= ( ud1 ud2 -- f ) */
/*  */
NAME("du=")
{
DEF_CA
UDCell ud1;
UDCell ud2;
Bool f;
NEXT_P0;
FETCH_DCELL(ud1, sp[3], sp[2]);
FETCH_DCELL(ud2, sp[1], TOS);
sp += 3;
{
#line 931 "/a5/anton/gforth/prim"
#ifdef BUGGY_LONG_LONG
#line 931
f = FLAG(ud1.lo==ud2.lo && ud1.hi==ud2.hi);
#line 931
#else
#line 931
f = FLAG(ud1==ud2);
#line 931
#endif
#line 931
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_d_u_not_equals:	/* du<> ( ud1 ud2 -- f ) */
/*  */
NAME("du<>")
{
DEF_CA
UDCell ud1;
UDCell ud2;
Bool f;
NEXT_P0;
FETCH_DCELL(ud1, sp[3], sp[2]);
FETCH_DCELL(ud2, sp[1], TOS);
sp += 3;
{
#line 931 "/a5/anton/gforth/prim"
#ifdef BUGGY_LONG_LONG
#line 931
f = FLAG(ud1.lo!=ud2.lo || ud1.hi!=ud2.hi);
#line 931
#else
#line 931
f = FLAG(ud1!=ud2);
#line 931
#endif
#line 931
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_d_u_less_than:	/* du< ( ud1 ud2 -- f ) */
/*  */
NAME("du<")
{
DEF_CA
UDCell ud1;
UDCell ud2;
Bool f;
NEXT_P0;
FETCH_DCELL(ud1, sp[3], sp[2]);
FETCH_DCELL(ud2, sp[1], TOS);
sp += 3;
{
#line 931 "/a5/anton/gforth/prim"
#ifdef BUGGY_LONG_LONG
#line 931
f = FLAG(ud1.hi==ud2.hi ? ud1.lo<ud2.lo : ud1.hi<ud2.hi);
#line 931
#else
#line 931
f = FLAG(ud1<ud2);
#line 931
#endif
#line 931
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_d_u_greater_than:	/* du> ( ud1 ud2 -- f ) */
/*  */
NAME("du>")
{
DEF_CA
UDCell ud1;
UDCell ud2;
Bool f;
NEXT_P0;
FETCH_DCELL(ud1, sp[3], sp[2]);
FETCH_DCELL(ud2, sp[1], TOS);
sp += 3;
{
#line 931 "/a5/anton/gforth/prim"
#ifdef BUGGY_LONG_LONG
#line 931
f = FLAG(ud1.hi==ud2.hi ? ud1.lo>ud2.lo : ud1.hi>ud2.hi);
#line 931
#else
#line 931
f = FLAG(ud1>ud2);
#line 931
#endif
#line 931
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_d_u_less_or_equal:	/* du<= ( ud1 ud2 -- f ) */
/*  */
NAME("du<=")
{
DEF_CA
UDCell ud1;
UDCell ud2;
Bool f;
NEXT_P0;
FETCH_DCELL(ud1, sp[3], sp[2]);
FETCH_DCELL(ud2, sp[1], TOS);
sp += 3;
{
#line 931 "/a5/anton/gforth/prim"
#ifdef BUGGY_LONG_LONG
#line 931
f = FLAG(ud1.hi==ud2.hi ? ud1.lo<=ud2.lo : ud1.hi<=ud2.hi);
#line 931
#else
#line 931
f = FLAG(ud1<=ud2);
#line 931
#endif
#line 931
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_d_u_greater_or_equal:	/* du>= ( ud1 ud2 -- f ) */
/*  */
NAME("du>=")
{
DEF_CA
UDCell ud1;
UDCell ud2;
Bool f;
NEXT_P0;
FETCH_DCELL(ud1, sp[3], sp[2]);
FETCH_DCELL(ud2, sp[1], TOS);
sp += 3;
{
#line 931 "/a5/anton/gforth/prim"
#ifdef BUGGY_LONG_LONG
#line 931
f = FLAG(ud1.hi==ud2.hi ? ud1.lo>=ud2.lo : ud1.hi>=ud2.hi);
#line 931
#else
#line 931
f = FLAG(ud1>=ud2);
#line 931
#endif
#line 931
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

#endif
I_within:	/* within ( u1 u2 u3 -- f ) */
/* u2=<u1<u3 or: u3=<u2 and u1 is not in [u3,u2).  This works for
unsigned and signed numbers (but not a mixture).  Another way to think
about this word is to consider the numbers as a circle (wrapping
around from @code{max-u} to 0 for unsigned, and from @code{max-n} to
min-n for signed numbers); now consider the range from u2 towards
increasing numbers up to and excluding u3 (giving an empty range if
u2=u3; if u1 is in this range, @code{within} returns true. */
NAME("within")
{
DEF_CA
UCell u1;
UCell u2;
UCell u3;
Bool f;
NEXT_P0;
u1 = (UCell) sp[2];
u2 = (UCell) sp[1];
u3 = (UCell) TOS;
sp += 2;
{
#line 943 "/a5/anton/gforth/prim"
f = FLAG(u1-u2 < u3-u2);
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_sp_fetch:	/* sp@ ( -- a_addr ) */
/*  */
NAME("sp@")
{
DEF_CA
Cell * a_addr;
NEXT_P0;
IF_TOS(sp[0] = TOS);
sp += -1;
{
#line 948 "/a5/anton/gforth/prim"
a_addr = sp+1;
}
NEXT_P1;
TOS = (Cell)a_addr;
NEXT_P2;
}

I_sp_store:	/* sp! ( a_addr -- ) */
/*  */
NAME("sp!")
{
DEF_CA
Cell * a_addr;
NEXT_P0;
a_addr = (Cell *) TOS;
sp += 1;
{
#line 951 "/a5/anton/gforth/prim"
sp = a_addr;
/* works with and without TOS caching */
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_rp_fetch:	/* rp@ ( -- a_addr ) */
/*  */
NAME("rp@")
{
DEF_CA
Cell * a_addr;
NEXT_P0;
IF_TOS(sp[0] = TOS);
sp += -1;
{
#line 955 "/a5/anton/gforth/prim"
a_addr = rp;
}
NEXT_P1;
TOS = (Cell)a_addr;
NEXT_P2;
}

I_rp_store:	/* rp! ( a_addr -- ) */
/*  */
NAME("rp!")
{
DEF_CA
Cell * a_addr;
NEXT_P0;
a_addr = (Cell *) TOS;
sp += 1;
{
#line 958 "/a5/anton/gforth/prim"
rp = a_addr;
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

#ifdef HAS_FLOATING
I_fp_fetch:	/* fp@ ( -- f_addr ) */
/*  */
NAME("fp@")
{
DEF_CA
Float * f_addr;
NEXT_P0;
IF_TOS(sp[0] = TOS);
sp += -1;
{
#line 963 "/a5/anton/gforth/prim"
f_addr = fp;
}
NEXT_P1;
TOS = (Cell)f_addr;
NEXT_P2;
}

I_fp_store:	/* fp! ( f_addr -- ) */
/*  */
NAME("fp!")
{
DEF_CA
Float * f_addr;
NEXT_P0;
f_addr = (Float *) TOS;
sp += 1;
{
#line 966 "/a5/anton/gforth/prim"
fp = f_addr;
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

#endif
I_semis:	/* ;s ( -- ) */
/* The primitive compiled by @code{EXIT}. */
NAME(";s")
{
DEF_CA
NEXT_P0;
{
#line 972 "/a5/anton/gforth/prim"
SET_IP((Xt *)(*rp++));
}
NEXT_P1;
NEXT_P2;
}

I_to_r:	/* >r ( w -- ) */
/*  */
NAME(">r")
{
DEF_CA
Cell w;
NEXT_P0;
w = (Cell) TOS;
sp += 1;
{
#line 975 "/a5/anton/gforth/prim"
*--rp = w;
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_r_from:	/* r> ( -- w ) */
/*  */
NAME("r>")
{
DEF_CA
Cell w;
NEXT_P0;
IF_TOS(sp[0] = TOS);
sp += -1;
{
#line 981 "/a5/anton/gforth/prim"
w = *rp++;
}
NEXT_P1;
TOS = (Cell)w;
NEXT_P2;
}

I_rdrop:	/* rdrop ( -- ) */
/*  */
NAME("rdrop")
{
DEF_CA
NEXT_P0;
{
#line 987 "/a5/anton/gforth/prim"
rp++;
}
NEXT_P1;
NEXT_P2;
}

I_two_to_r:	/* 2>r ( w1 w2 -- ) */
/*  */
NAME("2>r")
{
DEF_CA
Cell w1;
Cell w2;
NEXT_P0;
w1 = (Cell) sp[1];
w2 = (Cell) TOS;
sp += 2;
{
#line 992 "/a5/anton/gforth/prim"
*--rp = w1;
*--rp = w2;
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_two_r_from:	/* 2r> ( -- w1 w2 ) */
/*  */
NAME("2r>")
{
DEF_CA
Cell w1;
Cell w2;
NEXT_P0;
IF_TOS(sp[0] = TOS);
sp += -2;
{
#line 998 "/a5/anton/gforth/prim"
w2 = *rp++;
w1 = *rp++;
}
NEXT_P1;
sp[1] = (Cell)w1;
TOS = (Cell)w2;
NEXT_P2;
}

I_two_r_fetch:	/* 2r@ ( -- w1 w2 ) */
/*  */
NAME("2r@")
{
DEF_CA
Cell w1;
Cell w2;
NEXT_P0;
IF_TOS(sp[0] = TOS);
sp += -2;
{
#line 1004 "/a5/anton/gforth/prim"
w2 = rp[0];
w1 = rp[1];
}
NEXT_P1;
sp[1] = (Cell)w1;
TOS = (Cell)w2;
NEXT_P2;
}

I_two_r_drop:	/* 2rdrop ( -- ) */
/*  */
NAME("2rdrop")
{
DEF_CA
NEXT_P0;
{
#line 1010 "/a5/anton/gforth/prim"
rp+=2;
}
NEXT_P1;
NEXT_P2;
}

I_over:	/* over ( w1 w2 -- w1 w2 w1 ) */
/*  */
NAME("over")
{
DEF_CA
Cell w1;
Cell w2;
NEXT_P0;
w1 = (Cell) sp[1];
w2 = (Cell) TOS;
sp += -1;
{
#line 1015 "/a5/anton/gforth/prim"
}
NEXT_P1;
IF_TOS(sp[1] = (Cell)w2;);
TOS = (Cell)w1;
NEXT_P2;
}

I_drop:	/* drop ( w -- ) */
/*  */
NAME("drop")
{
DEF_CA
Cell w;
NEXT_P0;
w = (Cell) TOS;
sp += 1;
{
#line 1019 "/a5/anton/gforth/prim"
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_swap:	/* swap ( w1 w2 -- w2 w1 ) */
/*  */
NAME("swap")
{
DEF_CA
Cell w1;
Cell w2;
NEXT_P0;
w1 = (Cell) sp[1];
w2 = (Cell) TOS;
{
#line 1023 "/a5/anton/gforth/prim"
}
NEXT_P1;
sp[1] = (Cell)w2;
TOS = (Cell)w1;
NEXT_P2;
}

I_dupe:	/* dup ( w -- w w ) */
/*  */
NAME("dup")
{
DEF_CA
Cell w;
NEXT_P0;
w = (Cell) TOS;
sp += -1;
{
#line 1028 "/a5/anton/gforth/prim"
}
NEXT_P1;
IF_TOS(sp[1] = (Cell)w;);
TOS = (Cell)w;
NEXT_P2;
}

I_rote:	/* rot ( w1 w2 w3 -- w2 w3 w1 ) */
/*  */
NAME("rot")
{
DEF_CA
Cell w1;
Cell w2;
Cell w3;
NEXT_P0;
w1 = (Cell) sp[2];
w2 = (Cell) sp[1];
w3 = (Cell) TOS;
{
#line 1032 "/a5/anton/gforth/prim"
}
NEXT_P1;
sp[2] = (Cell)w2;
sp[1] = (Cell)w3;
TOS = (Cell)w1;
NEXT_P2;
}

I_not_rote:	/* -rot ( w1 w2 w3 -- w3 w1 w2 ) */
/*  */
NAME("-rot")
{
DEF_CA
Cell w1;
Cell w2;
Cell w3;
NEXT_P0;
w1 = (Cell) sp[2];
w2 = (Cell) sp[1];
w3 = (Cell) TOS;
{
#line 1041 "/a5/anton/gforth/prim"
}
NEXT_P1;
sp[2] = (Cell)w3;
sp[1] = (Cell)w1;
TOS = (Cell)w2;
NEXT_P2;
}

I_nip:	/* nip ( w1 w2 -- w2 ) */
/*  */
NAME("nip")
{
DEF_CA
Cell w1;
Cell w2;
NEXT_P0;
w1 = (Cell) sp[1];
w2 = (Cell) TOS;
sp += 1;
{
#line 1045 "/a5/anton/gforth/prim"
}
NEXT_P1;
TOS = (Cell)w2;
NEXT_P2;
}

I_tuck:	/* tuck ( w1 w2 -- w2 w1 w2 ) */
/*  */
NAME("tuck")
{
DEF_CA
Cell w1;
Cell w2;
NEXT_P0;
w1 = (Cell) sp[1];
w2 = (Cell) TOS;
sp += -1;
{
#line 1049 "/a5/anton/gforth/prim"
}
NEXT_P1;
sp[2] = (Cell)w2;
sp[1] = (Cell)w1;
TOS = (Cell)w2;
NEXT_P2;
}

I_question_dupe:	/* ?dup ( w -- w ) */
/*  */
NAME("?dup")
{
DEF_CA
Cell w;
NEXT_P0;
w = (Cell) TOS;
{
#line 1053 "/a5/anton/gforth/prim"
if (w!=0) {
  IF_TOS(*sp-- = w;)
#ifndef USE_TOS
  *--sp = w;
#endif
}
}
NEXT_P1;
NEXT_P2;
}

I_pick:	/* pick ( u -- w ) */
/*  */
NAME("pick")
{
DEF_CA
UCell u;
Cell w;
NEXT_P0;
u = (UCell) TOS;
{
#line 1063 "/a5/anton/gforth/prim"
w = sp[u+1];
}
NEXT_P1;
TOS = (Cell)w;
NEXT_P2;
}

I_two_drop:	/* 2drop ( w1 w2 -- ) */
/*  */
NAME("2drop")
{
DEF_CA
Cell w1;
Cell w2;
NEXT_P0;
w1 = (Cell) sp[1];
w2 = (Cell) TOS;
sp += 2;
{
#line 1068 "/a5/anton/gforth/prim"
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_two_dupe:	/* 2dup ( w1 w2 -- w1 w2 w1 w2 ) */
/*  */
NAME("2dup")
{
DEF_CA
Cell w1;
Cell w2;
NEXT_P0;
w1 = (Cell) sp[1];
w2 = (Cell) TOS;
sp += -2;
{
#line 1072 "/a5/anton/gforth/prim"
}
NEXT_P1;
IF_TOS(sp[2] = (Cell)w2;);
sp[1] = (Cell)w1;
TOS = (Cell)w2;
NEXT_P2;
}

I_two_over:	/* 2over ( w1 w2 w3 w4 -- w1 w2 w3 w4 w1 w2 ) */
/*  */
NAME("2over")
{
DEF_CA
Cell w1;
Cell w2;
Cell w3;
Cell w4;
NEXT_P0;
w1 = (Cell) sp[3];
w2 = (Cell) sp[2];
w3 = (Cell) sp[1];
w4 = (Cell) TOS;
sp += -2;
{
#line 1076 "/a5/anton/gforth/prim"
}
NEXT_P1;
IF_TOS(sp[2] = (Cell)w4;);
sp[1] = (Cell)w1;
TOS = (Cell)w2;
NEXT_P2;
}

I_two_swap:	/* 2swap ( w1 w2 w3 w4 -- w3 w4 w1 w2 ) */
/*  */
NAME("2swap")
{
DEF_CA
Cell w1;
Cell w2;
Cell w3;
Cell w4;
NEXT_P0;
w1 = (Cell) sp[3];
w2 = (Cell) sp[2];
w3 = (Cell) sp[1];
w4 = (Cell) TOS;
{
#line 1080 "/a5/anton/gforth/prim"
}
NEXT_P1;
sp[3] = (Cell)w3;
sp[2] = (Cell)w4;
sp[1] = (Cell)w1;
TOS = (Cell)w2;
NEXT_P2;
}

I_two_rote:	/* 2rot ( w1 w2 w3 w4 w5 w6 -- w3 w4 w5 w6 w1 w2 ) */
/*  */
NAME("2rot")
{
DEF_CA
Cell w1;
Cell w2;
Cell w3;
Cell w4;
Cell w5;
Cell w6;
NEXT_P0;
w1 = (Cell) sp[5];
w2 = (Cell) sp[4];
w3 = (Cell) sp[3];
w4 = (Cell) sp[2];
w5 = (Cell) sp[1];
w6 = (Cell) TOS;
{
#line 1084 "/a5/anton/gforth/prim"
}
NEXT_P1;
sp[5] = (Cell)w3;
sp[4] = (Cell)w4;
sp[3] = (Cell)w5;
sp[2] = (Cell)w6;
sp[1] = (Cell)w1;
TOS = (Cell)w2;
NEXT_P2;
}

I_two_nip:	/* 2nip ( w1 w2 w3 w4 -- w3 w4 ) */
/*  */
NAME("2nip")
{
DEF_CA
Cell w1;
Cell w2;
Cell w3;
Cell w4;
NEXT_P0;
w1 = (Cell) sp[3];
w2 = (Cell) sp[2];
w3 = (Cell) sp[1];
w4 = (Cell) TOS;
sp += 2;
{
#line 1088 "/a5/anton/gforth/prim"
}
NEXT_P1;
sp[1] = (Cell)w3;
TOS = (Cell)w4;
NEXT_P2;
}

I_two_tuck:	/* 2tuck ( w1 w2 w3 w4 -- w3 w4 w1 w2 w3 w4 ) */
/*  */
NAME("2tuck")
{
DEF_CA
Cell w1;
Cell w2;
Cell w3;
Cell w4;
NEXT_P0;
w1 = (Cell) sp[3];
w2 = (Cell) sp[2];
w3 = (Cell) sp[1];
w4 = (Cell) TOS;
sp += -2;
{
#line 1092 "/a5/anton/gforth/prim"
}
NEXT_P1;
sp[5] = (Cell)w3;
sp[4] = (Cell)w4;
sp[3] = (Cell)w1;
sp[2] = (Cell)w2;
sp[1] = (Cell)w3;
TOS = (Cell)w4;
NEXT_P2;
}

I_fetch:	/* @ ( a_addr -- w ) */
/*  Read from the cell at address @i{a-addr}, and return its contents, @i{w}. */
NAME("@")
{
DEF_CA
Cell * a_addr;
Cell w;
NEXT_P0;
a_addr = (Cell *) TOS;
{
#line 1099 "/a5/anton/gforth/prim"
w = *a_addr;
}
NEXT_P1;
TOS = (Cell)w;
NEXT_P2;
}

I_store:	/* ! ( w a_addr -- ) */
/*  Write the value @i{w} to the cell at address @i{a-addr}. */
NAME("!")
{
DEF_CA
Cell w;
Cell * a_addr;
NEXT_P0;
w = (Cell) sp[1];
a_addr = (Cell *) TOS;
sp += 2;
{
#line 1103 "/a5/anton/gforth/prim"
*a_addr = w;
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_plus_store:	/* +! ( n a_addr -- ) */
/*  Add @i{n} to the value stored in the cell at address @i{a-addr}. */
NAME("+!")
{
DEF_CA
Cell n;
Cell * a_addr;
NEXT_P0;
n = (Cell) sp[1];
a_addr = (Cell *) TOS;
sp += 2;
{
#line 1107 "/a5/anton/gforth/prim"
*a_addr += n;
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_c_fetch:	/* c@ ( c_addr -- c ) */
/*  Read from the char at address @i{c-addr}, and return its contents, @i{c}. */
NAME("c@")
{
DEF_CA
Char * c_addr;
Char c;
NEXT_P0;
c_addr = (Char *) TOS;
{
#line 1113 "/a5/anton/gforth/prim"
c = *c_addr;
}
NEXT_P1;
TOS = (Cell)c;
NEXT_P2;
}

I_c_store:	/* c! ( c c_addr -- ) */
/*  Write the value @i{c} to the char at address @i{c-addr}. */
NAME("c!")
{
DEF_CA
Char c;
Char * c_addr;
NEXT_P0;
c = (Char) sp[1];
c_addr = (Char *) TOS;
sp += 2;
{
#line 1139 "/a5/anton/gforth/prim"
*c_addr = c;
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_two_store:	/* 2! ( w1 w2 a_addr -- ) */
/*  Write the value @i{w1, w2} to the double at address @i{a-addr}. */
NAME("2!")
{
DEF_CA
Cell w1;
Cell w2;
Cell * a_addr;
NEXT_P0;
w1 = (Cell) sp[2];
w2 = (Cell) sp[1];
a_addr = (Cell *) TOS;
sp += 3;
{
#line 1169 "/a5/anton/gforth/prim"
a_addr[0] = w2;
a_addr[1] = w1;
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_two_fetch:	/* 2@ ( a_addr -- w1 w2 ) */
/*  Read from the double at address @i{a-addr}, and return its contents, @i{w1, w2}. */
NAME("2@")
{
DEF_CA
Cell * a_addr;
Cell w1;
Cell w2;
NEXT_P0;
a_addr = (Cell *) TOS;
sp += -1;
{
#line 1176 "/a5/anton/gforth/prim"
w2 = a_addr[0];
w1 = a_addr[1];
}
NEXT_P1;
sp[1] = (Cell)w1;
TOS = (Cell)w2;
NEXT_P2;
}

I_cell_plus:	/* cell+ ( a_addr1 -- a_addr2 ) */
/*  Increment @i{a-addr1} by the number of address units corresponding to the size of
one cell, to give @i{a-addr2}. */
NAME("cell+")
{
DEF_CA
Cell * a_addr1;
Cell * a_addr2;
NEXT_P0;
a_addr1 = (Cell *) TOS;
{
#line 1184 "/a5/anton/gforth/prim"
a_addr2 = a_addr1+1;
}
NEXT_P1;
TOS = (Cell)a_addr2;
NEXT_P2;
}

I_cells:	/* cells ( n1 -- n2 ) */
/*  @i{n2} is the number of address units corresponding to @i{n1} cells. */
NAME("cells")
{
DEF_CA
Cell n1;
Cell n2;
NEXT_P0;
n1 = (Cell) TOS;
{
#line 1190 "/a5/anton/gforth/prim"
n2 = n1 * sizeof(Cell);
}
NEXT_P1;
TOS = (Cell)n2;
NEXT_P2;
}

I_char_plus:	/* char+ ( c_addr1 -- c_addr2 ) */
/*  Increment @i{c-addr1} by the number of address units corresponding to the size of
one char, to give @i{c-addr2}. */
NAME("char+")
{
DEF_CA
Char * c_addr1;
Char * c_addr2;
NEXT_P0;
c_addr1 = (Char *) TOS;
{
#line 1202 "/a5/anton/gforth/prim"
c_addr2 = c_addr1 + 1;
}
NEXT_P1;
TOS = (Cell)c_addr2;
NEXT_P2;
}

I_paren_chars:	/* (chars) ( n1 -- n2 ) */
/*  */
NAME("(chars)")
{
DEF_CA
Cell n1;
Cell n2;
NEXT_P0;
n1 = (Cell) TOS;
{
#line 1207 "/a5/anton/gforth/prim"
n2 = n1 * sizeof(Char);
}
NEXT_P1;
TOS = (Cell)n2;
NEXT_P2;
}

I_count:	/* count ( c_addr1 -- c_addr2 u ) */
/*  If @i{c-add1} is the address of a counted string return the length of
the string, @i{u}, and the address of its first character, @i{c-addr2}. */
NAME("count")
{
DEF_CA
Char * c_addr1;
Char * c_addr2;
UCell u;
NEXT_P0;
c_addr1 = (Char *) TOS;
sp += -1;
{
#line 1214 "/a5/anton/gforth/prim"
u = *c_addr1;
c_addr2 = c_addr1+1;
}
NEXT_P1;
sp[1] = (Cell)c_addr2;
TOS = (Cell)u;
NEXT_P2;
}

I_paren_f83find:	/* (f83find) ( c_addr u f83name1 -- f83name2 ) */
/*  */
NAME("(f83find)")
{
DEF_CA
Char * c_addr;
UCell u;
struct F83Name * f83name1;
struct F83Name * f83name2;
NEXT_P0;
c_addr = (Char *) sp[2];
u = (UCell) sp[1];
f83name1 = (struct F83Name *) TOS;
sp += 2;
{
#line 1220 "/a5/anton/gforth/prim"
for (; f83name1 != NULL; f83name1 = (struct F83Name *)(f83name1->next))
  if ((UCell)F83NAME_COUNT(f83name1)==u &&
      memcasecmp(c_addr, f83name1->name, u)== 0 /* or inline? */)
    break;
f83name2=f83name1;
}
NEXT_P1;
TOS = (Cell)f83name2;
NEXT_P2;
}

#ifdef HAS_HASH
I_paren_hashfind:	/* (hashfind) ( c_addr u a_addr -- f83name2 ) */
/*  */
NAME("(hashfind)")
{
DEF_CA
Char * c_addr;
UCell u;
Cell * a_addr;
struct F83Name * f83name2;
NEXT_P0;
c_addr = (Char *) sp[2];
u = (UCell) sp[1];
a_addr = (Cell *) TOS;
sp += 2;
{
#line 1237 "/a5/anton/gforth/prim"
struct F83Name *f83name1;
f83name2=NULL;
while(a_addr != NULL)
{
   f83name1=(struct F83Name *)(a_addr[1]);
   a_addr=(Cell *)(a_addr[0]);
   if ((UCell)F83NAME_COUNT(f83name1)==u &&
       memcasecmp(c_addr, f83name1->name, u)== 0 /* or inline? */)
     {
	f83name2=f83name1;
	break;
     }
}
}
NEXT_P1;
TOS = (Cell)f83name2;
NEXT_P2;
}

I_paren_tablefind:	/* (tablefind) ( c_addr u a_addr -- f83name2 ) */
/* A case-sensitive variant of @code{(hashfind)} */
NAME("(tablefind)")
{
DEF_CA
Char * c_addr;
UCell u;
Cell * a_addr;
struct F83Name * f83name2;
NEXT_P0;
c_addr = (Char *) sp[2];
u = (UCell) sp[1];
a_addr = (Cell *) TOS;
sp += 2;
{
#line 1260 "/a5/anton/gforth/prim"
struct F83Name *f83name1;
f83name2=NULL;
while(a_addr != NULL)
{
   f83name1=(struct F83Name *)(a_addr[1]);
   a_addr=(Cell *)(a_addr[0]);
   if ((UCell)F83NAME_COUNT(f83name1)==u &&
       memcmp(c_addr, f83name1->name, u)== 0 /* or inline? */)
     {
	f83name2=f83name1;
	break;
     }
}
}
NEXT_P1;
TOS = (Cell)f83name2;
NEXT_P2;
}

I_paren_hashkey:	/* (hashkey) ( c_addr u1 -- u2 ) */
/*  */
NAME("(hashkey)")
{
DEF_CA
Char * c_addr;
UCell u1;
UCell u2;
NEXT_P0;
c_addr = (Char *) sp[1];
u1 = (UCell) TOS;
sp += 1;
{
#line 1282 "/a5/anton/gforth/prim"
u2=0;
while(u1--)
   u2+=(Cell)toupper(*c_addr++);
}
NEXT_P1;
TOS = (Cell)u2;
NEXT_P2;
}

I_paren_hashkey1:	/* (hashkey1) ( c_addr u ubits -- ukey ) */
/* ukey is the hash key for the string c_addr u fitting in ubits bits */
NAME("(hashkey1)")
{
DEF_CA
Char * c_addr;
UCell u;
UCell ubits;
UCell ukey;
NEXT_P0;
c_addr = (Char *) sp[2];
u = (UCell) sp[1];
ubits = (UCell) TOS;
sp += 2;
{
#line 1290 "/a5/anton/gforth/prim"
/* this hash function rotates the key at every step by rot bits within
   ubits bits and xors it with the character. This function does ok in
   the chi-sqare-test.  Rot should be <=7 (preferably <=5) for
   ASCII strings (larger if ubits is large), and should share no
   divisors with ubits.
*/
unsigned rot = ((char []){5,0,1,2,3,4,5,5,5,5,3,5,5,5,5,7,5,5,5,5,7,5,5,5,5,6,5,5,5,5,7,5,5})[ubits];
Char *cp = c_addr;
for (ukey=0; cp<c_addr+u; cp++)
    ukey = ((((ukey<<rot) | (ukey>>(ubits-rot))) 
	     ^ toupper(*cp))
	    & ((1<<ubits)-1));
}
NEXT_P1;
TOS = (Cell)ukey;
NEXT_P2;
}

#endif
I_paren_parse_white:	/* (parse-white) ( c_addr1 u1 -- c_addr2 u2 ) */
/*  */
NAME("(parse-white)")
{
DEF_CA
Char * c_addr1;
UCell u1;
Char * c_addr2;
UCell u2;
NEXT_P0;
c_addr1 = (Char *) sp[1];
u1 = (UCell) TOS;
{
#line 1318 "/a5/anton/gforth/prim"
/* use !isgraph instead of isspace? */
Char *endp = c_addr1+u1;
while (c_addr1<endp && isspace(*c_addr1))
  c_addr1++;
if (c_addr1<endp) {
  for (c_addr2 = c_addr1; c_addr1<endp && !isspace(*c_addr1); c_addr1++)
    ;
  u2 = c_addr1-c_addr2;
}
else {
  c_addr2 = c_addr1;
  u2 = 0;
}
}
NEXT_P1;
sp[1] = (Cell)c_addr2;
TOS = (Cell)u2;
NEXT_P2;
}

I_aligned:	/* aligned ( c_addr -- a_addr ) */
/*  @i{a-addr} is the first aligned address greater than or equal to @i{c-addr}. */
NAME("aligned")
{
DEF_CA
Char * c_addr;
Cell * a_addr;
NEXT_P0;
c_addr = (Char *) TOS;
{
#line 1339 "/a5/anton/gforth/prim"
a_addr = (Cell *)((((Cell)c_addr)+(sizeof(Cell)-1))&(-sizeof(Cell)));
}
NEXT_P1;
TOS = (Cell)a_addr;
NEXT_P2;
}

I_f_aligned:	/* faligned ( c_addr -- f_addr ) */
/*  @i{f-addr} is the first float-aligned address greater than or equal to @i{c-addr}. */
NAME("faligned")
{
DEF_CA
Char * c_addr;
Float * f_addr;
NEXT_P0;
c_addr = (Char *) TOS;
{
#line 1345 "/a5/anton/gforth/prim"
f_addr = (Float *)((((Cell)c_addr)+(sizeof(Float)-1))&(-sizeof(Float)));
}
NEXT_P1;
TOS = (Cell)f_addr;
NEXT_P2;
}

I_to_body:	/* >body ( xt -- a_addr ) */
/*  Get the address of the body of the word represented by @i{xt} (the address
of the word's data field). */
NAME(">body")
{
DEF_CA
Xt xt;
Cell * a_addr;
NEXT_P0;
xt = (Xt) TOS;
{
#line 1352 "/a5/anton/gforth/prim"
a_addr = PFA(xt);
}
NEXT_P1;
TOS = (Cell)a_addr;
NEXT_P2;
}

I_to_code_address:	/* >code-address ( xt -- c_addr ) */
/* @i{c-addr} is the code address of the word @i{xt}. */
NAME(">code-address")
{
DEF_CA
Xt xt;
Char * c_addr;
NEXT_P0;
xt = (Xt) TOS;
{
#line 1361 "/a5/anton/gforth/prim"
/* !! This behaves installation-dependently for DOES-words */
c_addr = (Address)CODE_ADDRESS(xt);
}
NEXT_P1;
TOS = (Cell)c_addr;
NEXT_P2;
}

I_to_does_code:	/* >does-code ( xt -- a_addr ) */
/* If @i{xt} is the execution token of a defining-word-defined word,
@i{a-addr} is the start of the Forth code after the @code{DOES>};
Otherwise @i{a-addr} is 0. */
NAME(">does-code")
{
DEF_CA
Xt xt;
Cell * a_addr;
NEXT_P0;
xt = (Xt) TOS;
{
#line 1370 "/a5/anton/gforth/prim"
a_addr = (Cell *)DOES_CODE(xt);
}
NEXT_P1;
TOS = (Cell)a_addr;
NEXT_P2;
}

I_code_address_store:	/* code-address! ( c_addr xt -- ) */
/* Create a code field with code address @i{c-addr} at @i{xt}. */
NAME("code-address!")
{
DEF_CA
Char * c_addr;
Xt xt;
NEXT_P0;
c_addr = (Char *) sp[1];
xt = (Xt) TOS;
sp += 2;
{
#line 1376 "/a5/anton/gforth/prim"
MAKE_CF(xt, c_addr);
CACHE_FLUSH(xt,(size_t)PFA(0));
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_does_code_store:	/* does-code! ( a_addr xt -- ) */
/* Create a code field at @i{xt} for a defining-word-defined word; @i{a-addr}
is the start of the Forth code after @code{DOES>}. */
NAME("does-code!")
{
DEF_CA
Cell * a_addr;
Xt xt;
NEXT_P0;
a_addr = (Cell *) sp[1];
xt = (Xt) TOS;
sp += 2;
{
#line 1384 "/a5/anton/gforth/prim"
MAKE_DOES_CF(xt, a_addr);
CACHE_FLUSH(xt,(size_t)PFA(0));
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_does_handler_store:	/* does-handler! ( a_addr -- ) */
/* Create a @code{DOES>}-handler at address @i{a-addr}. Usually, @i{a-addr} points
just behind a @code{DOES>}. */
NAME("does-handler!")
{
DEF_CA
Cell * a_addr;
NEXT_P0;
a_addr = (Cell *) TOS;
sp += 1;
{
#line 1392 "/a5/anton/gforth/prim"
MAKE_DOES_HANDLER(a_addr);
CACHE_FLUSH((caddr_t)a_addr,DOES_HANDLER_SIZE);
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_slash_does_handler:	/* /does-handler ( -- n ) */
/* The size of a @code{DOES>}-handler (includes possible padding). */
NAME("/does-handler")
{
DEF_CA
Cell n;
NEXT_P0;
IF_TOS(sp[0] = TOS);
sp += -1;
{
#line 1399 "/a5/anton/gforth/prim"
/* !! a constant or environmental query might be better */
n = DOES_HANDLER_SIZE;
}
NEXT_P1;
TOS = (Cell)n;
NEXT_P2;
}

I_threading_method:	/* threading-method ( -- n ) */
/* 0 if the engine is direct threaded. Note that this may change during
the lifetime of an image. */
NAME("threading-method")
{
DEF_CA
Cell n;
NEXT_P0;
IF_TOS(sp[0] = TOS);
sp += -1;
{
#line 1407 "/a5/anton/gforth/prim"
#if defined(DOUBLY_INDIRECT)
n=2;
#else
# if defined(DIRECT_THREADED)
n=0;
# else
n=1;
# endif
#endif
}
NEXT_P1;
TOS = (Cell)n;
NEXT_P2;
}

I_paren_key_file:	/* key-file ( wfileid -- n ) */
/*  */
NAME("key-file")
{
DEF_CA
Cell wfileid;
Cell n;
NEXT_P0;
wfileid = (Cell) TOS;
{
#line 1422 "/a5/anton/gforth/prim"
#ifdef HAS_FILE
fflush(stdout);
n = key((FILE*)wfileid);
#else
n = key(stdin);
#endif
}
NEXT_P1;
TOS = (Cell)n;
NEXT_P2;
}

I_key_q_file:	/* key?-file ( wfileid -- n ) */
/*  */
NAME("key?-file")
{
DEF_CA
Cell wfileid;
Cell n;
NEXT_P0;
wfileid = (Cell) TOS;
{
#line 1430 "/a5/anton/gforth/prim"
#ifdef HAS_FILE
fflush(stdout);
n = key_query((FILE*)wfileid);
#else
n = key_query(stdin);
#endif
}
NEXT_P1;
TOS = (Cell)n;
NEXT_P2;
}

#ifdef HAS_OS
I_stdin:	/* stdin ( -- wfileid ) */
/*  */
NAME("stdin")
{
DEF_CA
Cell wfileid;
NEXT_P0;
IF_TOS(sp[0] = TOS);
sp += -1;
{
#line 1440 "/a5/anton/gforth/prim"
wfileid = (Cell)stdin;
}
NEXT_P1;
TOS = (Cell)wfileid;
NEXT_P2;
}

I_stdout:	/* stdout ( -- wfileid ) */
/*  */
NAME("stdout")
{
DEF_CA
Cell wfileid;
NEXT_P0;
IF_TOS(sp[0] = TOS);
sp += -1;
{
#line 1443 "/a5/anton/gforth/prim"
wfileid = (Cell)stdout;
}
NEXT_P1;
TOS = (Cell)wfileid;
NEXT_P2;
}

I_stderr:	/* stderr ( -- wfileid ) */
/*  */
NAME("stderr")
{
DEF_CA
Cell wfileid;
NEXT_P0;
IF_TOS(sp[0] = TOS);
sp += -1;
{
#line 1446 "/a5/anton/gforth/prim"
wfileid = (Cell)stderr;
}
NEXT_P1;
TOS = (Cell)wfileid;
NEXT_P2;
}

I_form:	/* form ( -- urows ucols ) */
/* The number of lines and columns in the terminal. These numbers may change
with the window size. */
NAME("form")
{
DEF_CA
UCell urows;
UCell ucols;
NEXT_P0;
IF_TOS(sp[0] = TOS);
sp += -2;
{
#line 1451 "/a5/anton/gforth/prim"
/* we could block SIGWINCH here to get a consistent size, but I don't
 think this is necessary or always beneficial */
urows=rows;
ucols=cols;
}
NEXT_P1;
sp[1] = (Cell)urows;
TOS = (Cell)ucols;
NEXT_P2;
}

I_flush_icache:	/* flush-icache ( c_addr u -- ) */
/* Make sure that the instruction cache of the processor (if there is
one) does not contain stale data at @i{c-addr} and @i{u} bytes
afterwards. @code{END-CODE} performs a @code{flush-icache}
automatically. Caveat: @code{flush-icache} might not work on your
installation; this is usually the case if direct threading is not
supported on your machine (take a look at your @file{machine.h}) and
your machine has a separate instruction cache. In such cases,
@code{flush-icache} does nothing instead of flushing the instruction
cache. */
NAME("flush-icache")
{
DEF_CA
Char * c_addr;
UCell u;
NEXT_P0;
c_addr = (Char *) sp[1];
u = (UCell) TOS;
sp += 2;
{
#line 1466 "/a5/anton/gforth/prim"
FLUSH_ICACHE(c_addr,u);
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_paren_bye:	/* (bye) ( n -- ) */
/*  */
NAME("(bye)")
{
DEF_CA
Cell n;
NEXT_P0;
n = (Cell) TOS;
sp += 1;
{
#line 1469 "/a5/anton/gforth/prim"
return (Label *)n;
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_peren_system:	/* (system) ( c_addr u -- wretval wior ) */
/*  */
NAME("(system)")
{
DEF_CA
Char * c_addr;
UCell u;
Cell wretval;
Cell wior;
NEXT_P0;
c_addr = (Char *) sp[1];
u = (UCell) TOS;
{
#line 1472 "/a5/anton/gforth/prim"
#ifndef MSDOS
int old_tp=terminal_prepped;
deprep_terminal();
#endif
wretval=system(cstr(c_addr,u,1)); /* ~ expansion on first part of string? */
wior = IOR(wretval==-1 || (wretval==127 && errno != 0));
#ifndef MSDOS
if (old_tp)
  prep_terminal();
#endif
}
NEXT_P1;
sp[1] = (Cell)wretval;
TOS = (Cell)wior;
NEXT_P2;
}

I_getenv:	/* getenv ( c_addr1 u1 -- c_addr2 u2 ) */
/* The string @i{c-addr1 u1} specifies an environment variable. The string @i{c-addr2 u2}
is the host operating system's expansion of that environment variable. If the
environment variable does not exist, @i{c-addr2 u2} specifies a string 0 characters
in length. */
NAME("getenv")
{
DEF_CA
Char * c_addr1;
UCell u1;
Char * c_addr2;
UCell u2;
NEXT_P0;
c_addr1 = (Char *) sp[1];
u1 = (UCell) TOS;
{
#line 1488 "/a5/anton/gforth/prim"
/* close ' to keep fontify happy */
c_addr2 = getenv(cstr(c_addr1,u1,1));
u2 = (c_addr2 == NULL ? 0 : strlen(c_addr2));
}
NEXT_P1;
sp[1] = (Cell)c_addr2;
TOS = (Cell)u2;
NEXT_P2;
}

I_open_pipe:	/* open-pipe ( c_addr u ntype -- wfileid wior ) */
/*  */
NAME("open-pipe")
{
DEF_CA
Char * c_addr;
UCell u;
Cell ntype;
Cell wfileid;
Cell wior;
NEXT_P0;
c_addr = (Char *) sp[2];
u = (UCell) sp[1];
ntype = (Cell) TOS;
sp += 1;
{
#line 1493 "/a5/anton/gforth/prim"
wfileid=(Cell)popen(cstr(c_addr,u,1),fileattr[ntype]); /* ~ expansion of 1st arg? */
wior = IOR(wfileid==0); /* !! the man page says that errno is not set reliably */
}
NEXT_P1;
sp[1] = (Cell)wfileid;
TOS = (Cell)wior;
NEXT_P2;
}

I_close_pipe:	/* close-pipe ( wfileid -- wretval wior ) */
/*  */
NAME("close-pipe")
{
DEF_CA
Cell wfileid;
Cell wretval;
Cell wior;
NEXT_P0;
wfileid = (Cell) TOS;
sp += -1;
{
#line 1497 "/a5/anton/gforth/prim"
wretval = pclose((FILE *)wfileid);
wior = IOR(wretval==-1);
}
NEXT_P1;
sp[1] = (Cell)wretval;
TOS = (Cell)wior;
NEXT_P2;
}

I_time_and_date:	/* time&date ( -- nsec nmin nhour nday nmonth nyear ) */
/* Report the current time of day. Seconds, minutes and hours are numbered from 0.
Months are numbered from 1. */
NAME("time&date")
{
DEF_CA
Cell nsec;
Cell nmin;
Cell nhour;
Cell nday;
Cell nmonth;
Cell nyear;
NEXT_P0;
IF_TOS(sp[0] = TOS);
sp += -6;
{
#line 1503 "/a5/anton/gforth/prim"
struct timeval time1;
struct timezone zone1;
struct tm *ltime;
gettimeofday(&time1,&zone1);
ltime=localtime((time_t *)&time1.tv_sec);
nyear =ltime->tm_year+1900;
nmonth=ltime->tm_mon+1;
nday  =ltime->tm_mday;
nhour =ltime->tm_hour;
nmin  =ltime->tm_min;
nsec  =ltime->tm_sec;
}
NEXT_P1;
sp[5] = (Cell)nsec;
sp[4] = (Cell)nmin;
sp[3] = (Cell)nhour;
sp[2] = (Cell)nday;
sp[1] = (Cell)nmonth;
TOS = (Cell)nyear;
NEXT_P2;
}

I_ms:	/* ms ( n -- ) */
/* Wait at least @i{n} milli-second. */
NAME("ms")
{
DEF_CA
Cell n;
NEXT_P0;
n = (Cell) TOS;
sp += 1;
{
#line 1517 "/a5/anton/gforth/prim"
struct timeval timeout;
timeout.tv_sec=n/1000;
timeout.tv_usec=1000*(n%1000);
(void)select(0,0,0,0,&timeout);
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_allocate:	/* allocate ( u -- a_addr wior ) */
/* Allocate @i{u} address units of contiguous data space. The initial
contents of the data space is undefined. If the allocation is successful,
@i{a-addr} is the start address of the allocated region and @i{wior}
is 0. If the allocation fails, @i{a-addr} is undefined and @i{wior}
is an implementation-defined I/O result code. */
NAME("allocate")
{
DEF_CA
UCell u;
Cell * a_addr;
Cell wior;
NEXT_P0;
u = (UCell) TOS;
sp += -1;
{
#line 1528 "/a5/anton/gforth/prim"
a_addr = (Cell *)malloc(u?u:1);
wior = IOR(a_addr==NULL);
}
NEXT_P1;
sp[1] = (Cell)a_addr;
TOS = (Cell)wior;
NEXT_P2;
}

I_free:	/* free ( a_addr -- wior ) */
/* Return the region of data space starting at @i{a-addr} to the system.
The regon must originally have been obtained using @code{allocate} or
@code{resize}. If the operational is successful, @i{wior} is 0.
If the operation fails, @i{wior} is an implementation-defined
I/O result code. */
NAME("free")
{
DEF_CA
Cell * a_addr;
Cell wior;
NEXT_P0;
a_addr = (Cell *) TOS;
{
#line 1537 "/a5/anton/gforth/prim"
free(a_addr);
wior = 0;
}
NEXT_P1;
TOS = (Cell)wior;
NEXT_P2;
}

I_resize:	/* resize ( a_addr1 u -- a_addr2 wior ) */
/* Change the size of the allocated area at @i{a-addr1} to @i{u}
address units, possibly moving the contents to a different
area. @i{a-addr2} is the address of the resulting area.
If the operational is successful, @i{wior} is 0.
If the operation fails, @i{wior} is an implementation-defined
I/O result code. If @i{a-addr1} is 0, Gforth's (but not the Standard)
@code{resize} @code{allocate}s @i{u} address units. */
NAME("resize")
{
DEF_CA
Cell * a_addr1;
UCell u;
Cell * a_addr2;
Cell wior;
NEXT_P0;
a_addr1 = (Cell *) sp[1];
u = (UCell) TOS;
{
#line 1548 "/a5/anton/gforth/prim"
/* the following check is not necessary on most OSs, but it is needed
   on SunOS 4.1.2. */
/* close ' to keep fontify happy */
if (a_addr1==NULL)
  a_addr2 = (Cell *)malloc(u);
else
  a_addr2 = (Cell *)realloc(a_addr1, u);
wior = IOR(a_addr2==NULL);	/* !! Define a return code */
}
NEXT_P1;
sp[1] = (Cell)a_addr2;
TOS = (Cell)wior;
NEXT_P2;
}

I_strerror:	/* strerror ( n -- c_addr u ) */
/*  */
NAME("strerror")
{
DEF_CA
Cell n;
Char * c_addr;
UCell u;
NEXT_P0;
n = (Cell) TOS;
sp += -1;
{
#line 1558 "/a5/anton/gforth/prim"
c_addr = strerror(n);
u = strlen(c_addr);
}
NEXT_P1;
sp[1] = (Cell)c_addr;
TOS = (Cell)u;
NEXT_P2;
}

I_strsignal:	/* strsignal ( n -- c_addr u ) */
/*  */
NAME("strsignal")
{
DEF_CA
Cell n;
Char * c_addr;
UCell u;
NEXT_P0;
n = (Cell) TOS;
sp += -1;
{
#line 1562 "/a5/anton/gforth/prim"
c_addr = strsignal(n);
u = strlen(c_addr);
}
NEXT_P1;
sp[1] = (Cell)c_addr;
TOS = (Cell)u;
NEXT_P2;
}

I_call_c:	/* call-c ( w -- ) */
/* Call the C function pointed to by @i{w}. The C function has to
access the stack itself. The stack pointers are exported in the global
variables @code{SP} and @code{FP}. */
NAME("call-c")
{
DEF_CA
Cell w;
NEXT_P0;
w = (Cell) TOS;
sp += 1;
{
#line 1569 "/a5/anton/gforth/prim"
/* This is a first attempt at support for calls to C. This may change in
   the future */
IF_FTOS(fp[0]=FTOS);
FP=fp;
SP=sp;
((void (*)())w)();
sp=SP;
fp=FP;
IF_TOS(TOS=sp[0]);
IF_FTOS(FTOS=fp[0]);
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

#endif
#ifdef HAS_FILE
I_close_file:	/* close-file ( wfileid -- wior ) */
/*  */
NAME("close-file")
{
DEF_CA
Cell wfileid;
Cell wior;
NEXT_P0;
wfileid = (Cell) TOS;
{
#line 1584 "/a5/anton/gforth/prim"
wior = IOR(fclose((FILE *)wfileid)==EOF);
}
NEXT_P1;
TOS = (Cell)wior;
NEXT_P2;
}

I_open_file:	/* open-file ( c_addr u ntype -- wfileid wior ) */
/*  */
NAME("open-file")
{
DEF_CA
Char * c_addr;
UCell u;
Cell ntype;
Cell wfileid;
Cell wior;
NEXT_P0;
c_addr = (Char *) sp[2];
u = (UCell) sp[1];
ntype = (Cell) TOS;
sp += 1;
{
#line 1587 "/a5/anton/gforth/prim"
wfileid = (Cell)fopen(tilde_cstr(c_addr, u, 1), fileattr[ntype]);
#if defined(GO32) && defined(MSDOS)
if(wfileid && !(ntype & 1))
  setbuf((FILE*)wfileid, NULL);
#endif
wior =  IOR(wfileid == 0);
}
NEXT_P1;
sp[1] = (Cell)wfileid;
TOS = (Cell)wior;
NEXT_P2;
}

I_create_file:	/* create-file ( c_addr u ntype -- wfileid wior ) */
/*  */
NAME("create-file")
{
DEF_CA
Char * c_addr;
UCell u;
Cell ntype;
Cell wfileid;
Cell wior;
NEXT_P0;
c_addr = (Char *) sp[2];
u = (UCell) sp[1];
ntype = (Cell) TOS;
sp += 1;
{
#line 1595 "/a5/anton/gforth/prim"
Cell	fd;
fd = open(tilde_cstr(c_addr, u, 1), O_CREAT|O_TRUNC|ufileattr[ntype], 0666);
if (fd != -1) {
  wfileid = (Cell)fdopen(fd, fileattr[ntype]);
#if defined(GO32) && defined(MSDOS)
  if(wfileid && !(ntype & 1))
    setbuf((FILE*)wfileid, NULL);
#endif
  wior = IOR(wfileid == 0);
} else {
  wfileid = 0;
  wior = IOR(1);
}
}
NEXT_P1;
sp[1] = (Cell)wfileid;
TOS = (Cell)wior;
NEXT_P2;
}

I_delete_file:	/* delete-file ( c_addr u -- wior ) */
/*  */
NAME("delete-file")
{
DEF_CA
Char * c_addr;
UCell u;
Cell wior;
NEXT_P0;
c_addr = (Char *) sp[1];
u = (UCell) TOS;
sp += 1;
{
#line 1610 "/a5/anton/gforth/prim"
wior = IOR(unlink(tilde_cstr(c_addr, u, 1))==-1);
}
NEXT_P1;
TOS = (Cell)wior;
NEXT_P2;
}

I_rename_file:	/* rename-file ( c_addr1 u1 c_addr2 u2 -- wior ) */
/* Rename file @i{c_addr1 u1} to new name @i{c_addr2 u2} */
NAME("rename-file")
{
DEF_CA
Char * c_addr1;
UCell u1;
Char * c_addr2;
UCell u2;
Cell wior;
NEXT_P0;
c_addr1 = (Char *) sp[3];
u1 = (UCell) sp[2];
c_addr2 = (Char *) sp[1];
u2 = (UCell) TOS;
sp += 3;
{
#line 1614 "/a5/anton/gforth/prim"
char *s1=tilde_cstr(c_addr2, u2, 1);
wior = IOR(rename(tilde_cstr(c_addr1, u1, 0), s1)==-1);
}
NEXT_P1;
TOS = (Cell)wior;
NEXT_P2;
}

I_file_position:	/* file-position ( wfileid -- ud wior ) */
/*  */
NAME("file-position")
{
DEF_CA
Cell wfileid;
UDCell ud;
Cell wior;
NEXT_P0;
wfileid = (Cell) TOS;
sp += -2;
{
#line 1618 "/a5/anton/gforth/prim"
/* !! use tell and lseek? */
ud = LONG2UD(ftell((FILE *)wfileid));
wior = IOR(UD2LONG(ud)==-1);
}
NEXT_P1;
STORE_DCELL(ud, sp[2], sp[1]);
TOS = (Cell)wior;
NEXT_P2;
}

I_reposition_file:	/* reposition-file ( ud wfileid -- wior ) */
/*  */
NAME("reposition-file")
{
DEF_CA
UDCell ud;
Cell wfileid;
Cell wior;
NEXT_P0;
FETCH_DCELL(ud, sp[2], sp[1]);
wfileid = (Cell) TOS;
sp += 2;
{
#line 1623 "/a5/anton/gforth/prim"
wior = IOR(fseek((FILE *)wfileid, UD2LONG(ud), SEEK_SET)==-1);
}
NEXT_P1;
TOS = (Cell)wior;
NEXT_P2;
}

I_file_size:	/* file-size ( wfileid -- ud wior ) */
/*  */
NAME("file-size")
{
DEF_CA
Cell wfileid;
UDCell ud;
Cell wior;
NEXT_P0;
wfileid = (Cell) TOS;
sp += -2;
{
#line 1626 "/a5/anton/gforth/prim"
struct stat buf;
wior = IOR(fstat(fileno((FILE *)wfileid), &buf)==-1);
ud = LONG2UD(buf.st_size);
}
NEXT_P1;
STORE_DCELL(ud, sp[2], sp[1]);
TOS = (Cell)wior;
NEXT_P2;
}

I_resize_file:	/* resize-file ( ud wfileid -- wior ) */
/*  */
NAME("resize-file")
{
DEF_CA
UDCell ud;
Cell wfileid;
Cell wior;
NEXT_P0;
FETCH_DCELL(ud, sp[2], sp[1]);
wfileid = (Cell) TOS;
sp += 2;
{
#line 1631 "/a5/anton/gforth/prim"
wior = IOR(ftruncate(fileno((FILE *)wfileid), UD2LONG(ud))==-1);
}
NEXT_P1;
TOS = (Cell)wior;
NEXT_P2;
}

I_read_file:	/* read-file ( c_addr u1 wfileid -- u2 wior ) */
/*  */
NAME("read-file")
{
DEF_CA
Char * c_addr;
UCell u1;
Cell wfileid;
UCell u2;
Cell wior;
NEXT_P0;
c_addr = (Char *) sp[2];
u1 = (UCell) sp[1];
wfileid = (Cell) TOS;
sp += 1;
{
#line 1634 "/a5/anton/gforth/prim"
/* !! fread does not guarantee enough */
u2 = fread(c_addr, sizeof(Char), u1, (FILE *)wfileid);
wior = FILEIO(u2<u1 && ferror((FILE *)wfileid));
/* !! is the value of ferror errno-compatible? */
if (wior)
  clearerr((FILE *)wfileid);
}
NEXT_P1;
sp[1] = (Cell)u2;
TOS = (Cell)wior;
NEXT_P2;
}

I_read_line:	/* read-line ( c_addr u1 wfileid -- u2 flag wior ) */
/*  */
NAME("read-line")
{
DEF_CA
Char * c_addr;
UCell u1;
Cell wfileid;
UCell u2;
Bool flag;
Cell wior;
NEXT_P0;
c_addr = (Char *) sp[2];
u1 = (UCell) sp[1];
wfileid = (Cell) TOS;
{
#line 1642 "/a5/anton/gforth/prim"
#if 1
Cell c;
flag=-1;
for(u2=0; u2<u1; u2++)
{
   c = getc((FILE *)wfileid);
   if (c=='\n') break;
   if (c=='\r') {
     if ((c = getc((FILE *)wfileid))!='\n')
       ungetc(c,(FILE *)wfileid);
     break;
   }
   if (c==EOF) {
	flag=FLAG(u2!=0);
	break;
     }
   c_addr[u2] = (Char)c;
}
wior=FILEIO(ferror((FILE *)wfileid));
#else
if ((flag=FLAG(!feof((FILE *)wfileid) &&
	       fgets(c_addr,u1+1,(FILE *)wfileid) != NULL))) {
  wior=FILEIO(ferror((FILE *)wfileid)!=0); /* !! ior? */
  if (wior)
    clearerr((FILE *)wfileid);
  u2 = strlen(c_addr);
  u2-=((u2>0) && (c_addr[u2-1]==NEWLINE));
}
else {
  wior=0;
  u2=0;
}
#endif
}
NEXT_P1;
sp[2] = (Cell)u2;
sp[1] = (Cell)flag;
TOS = (Cell)wior;
NEXT_P2;
}

#endif
I_write_file:	/* write-file ( c_addr u1 wfileid -- wior ) */
/*  */
NAME("write-file")
{
DEF_CA
Char * c_addr;
UCell u1;
Cell wfileid;
Cell wior;
NEXT_P0;
c_addr = (Char *) sp[2];
u1 = (UCell) sp[1];
wfileid = (Cell) TOS;
sp += 2;
{
#line 1679 "/a5/anton/gforth/prim"
/* !! fwrite does not guarantee enough */
#ifdef HAS_FILE
{
  UCell u2 = fwrite(c_addr, sizeof(Char), u1, (FILE *)wfileid);
  wior = FILEIO(u2<u1 && ferror((FILE *)wfileid));
  if (wior)
    clearerr((FILE *)wfileid);
}
#else
TYPE(c_addr, u1);
#endif
}
NEXT_P1;
TOS = (Cell)wior;
NEXT_P2;
}

I_emit_file:	/* emit-file ( c wfileid -- wior ) */
/*  */
NAME("emit-file")
{
DEF_CA
Char c;
Cell wfileid;
Cell wior;
NEXT_P0;
c = (Char) sp[1];
wfileid = (Cell) TOS;
sp += 1;
{
#line 1692 "/a5/anton/gforth/prim"
#ifdef HAS_FILE
wior = FILEIO(putc(c, (FILE *)wfileid)==EOF);
if (wior)
  clearerr((FILE *)wfileid);
#else
PUTC(c);
#endif
}
NEXT_P1;
TOS = (Cell)wior;
NEXT_P2;
}

#ifdef HAS_FILE
I_flush_file:	/* flush-file ( wfileid -- wior ) */
/*  */
NAME("flush-file")
{
DEF_CA
Cell wfileid;
Cell wior;
NEXT_P0;
wfileid = (Cell) TOS;
{
#line 1703 "/a5/anton/gforth/prim"
wior = IOR(fflush((FILE *) wfileid)==EOF);
}
NEXT_P1;
TOS = (Cell)wior;
NEXT_P2;
}

I_file_status:	/* file-status ( c_addr u -- ntype wior ) */
/*  */
NAME("file-status")
{
DEF_CA
Char * c_addr;
UCell u;
Cell ntype;
Cell wior;
NEXT_P0;
c_addr = (Char *) sp[1];
u = (UCell) TOS;
{
#line 1706 "/a5/anton/gforth/prim"
char *filename=tilde_cstr(c_addr, u, 1);
if (access (filename, F_OK) != 0) {
  ntype=0;
  wior=IOR(1);
}
else if (access (filename, R_OK | W_OK) == 0) {
  ntype=2; /* r/w */
  wior=0;
}
else if (access (filename, R_OK) == 0) {
  ntype=0; /* r/o */
  wior=0;
}
else if (access (filename, W_OK) == 0) {
  ntype=4; /* w/o */
  wior=0;
}
else {
  ntype=1; /* well, we cannot access the file, but better deliver a legal
	    access mode (r/o bin), so we get a decent error later upon open. */
  wior=0;
}
}
NEXT_P1;
sp[1] = (Cell)ntype;
TOS = (Cell)wior;
NEXT_P2;
}

#endif
#ifdef HAS_FLOATING
I_f_equals:	/* f= ( r1 r2 -- f ) */
/*  */
NAME("f=")
{
DEF_CA
Float r1;
Float r2;
Bool f;
NEXT_P0;
IF_TOS(sp[0] = TOS);
r1 = fp[1];
r2 = FTOS;
sp += -1;
fp += 2;
{
#line 1732 "/a5/anton/gforth/prim"
f = FLAG(r1==r2);
#line 1732
}
NEXT_P1;
TOS = (Cell)f;
IF_FTOS(FTOS = fp[0]);
NEXT_P2;
}

I_f_not_equals:	/* f<> ( r1 r2 -- f ) */
/*  */
NAME("f<>")
{
DEF_CA
Float r1;
Float r2;
Bool f;
NEXT_P0;
IF_TOS(sp[0] = TOS);
r1 = fp[1];
r2 = FTOS;
sp += -1;
fp += 2;
{
#line 1732 "/a5/anton/gforth/prim"
f = FLAG(r1!=r2);
#line 1732
}
NEXT_P1;
TOS = (Cell)f;
IF_FTOS(FTOS = fp[0]);
NEXT_P2;
}

I_f_less_than:	/* f< ( r1 r2 -- f ) */
/*  */
NAME("f<")
{
DEF_CA
Float r1;
Float r2;
Bool f;
NEXT_P0;
IF_TOS(sp[0] = TOS);
r1 = fp[1];
r2 = FTOS;
sp += -1;
fp += 2;
{
#line 1732 "/a5/anton/gforth/prim"
f = FLAG(r1<r2);
#line 1732
}
NEXT_P1;
TOS = (Cell)f;
IF_FTOS(FTOS = fp[0]);
NEXT_P2;
}

I_f_greater_than:	/* f> ( r1 r2 -- f ) */
/*  */
NAME("f>")
{
DEF_CA
Float r1;
Float r2;
Bool f;
NEXT_P0;
IF_TOS(sp[0] = TOS);
r1 = fp[1];
r2 = FTOS;
sp += -1;
fp += 2;
{
#line 1732 "/a5/anton/gforth/prim"
f = FLAG(r1>r2);
#line 1732
}
NEXT_P1;
TOS = (Cell)f;
IF_FTOS(FTOS = fp[0]);
NEXT_P2;
}

I_f_less_or_equal:	/* f<= ( r1 r2 -- f ) */
/*  */
NAME("f<=")
{
DEF_CA
Float r1;
Float r2;
Bool f;
NEXT_P0;
IF_TOS(sp[0] = TOS);
r1 = fp[1];
r2 = FTOS;
sp += -1;
fp += 2;
{
#line 1732 "/a5/anton/gforth/prim"
f = FLAG(r1<=r2);
#line 1732
}
NEXT_P1;
TOS = (Cell)f;
IF_FTOS(FTOS = fp[0]);
NEXT_P2;
}

I_f_greater_or_equal:	/* f>= ( r1 r2 -- f ) */
/*  */
NAME("f>=")
{
DEF_CA
Float r1;
Float r2;
Bool f;
NEXT_P0;
IF_TOS(sp[0] = TOS);
r1 = fp[1];
r2 = FTOS;
sp += -1;
fp += 2;
{
#line 1732 "/a5/anton/gforth/prim"
f = FLAG(r1>=r2);
#line 1732
}
NEXT_P1;
TOS = (Cell)f;
IF_FTOS(FTOS = fp[0]);
NEXT_P2;
}

I_f_zero_equals:	/* f0= ( r -- f ) */
/*  */
NAME("f0=")
{
DEF_CA
Float r;
Bool f;
NEXT_P0;
IF_TOS(sp[0] = TOS);
r = FTOS;
sp += -1;
fp += 1;
{
#line 1733 "/a5/anton/gforth/prim"
f = FLAG(r==0.);
#line 1733
}
NEXT_P1;
TOS = (Cell)f;
IF_FTOS(FTOS = fp[0]);
NEXT_P2;
}

I_f_zero_not_equals:	/* f0<> ( r -- f ) */
/*  */
NAME("f0<>")
{
DEF_CA
Float r;
Bool f;
NEXT_P0;
IF_TOS(sp[0] = TOS);
r = FTOS;
sp += -1;
fp += 1;
{
#line 1733 "/a5/anton/gforth/prim"
f = FLAG(r!=0.);
#line 1733
}
NEXT_P1;
TOS = (Cell)f;
IF_FTOS(FTOS = fp[0]);
NEXT_P2;
}

I_f_zero_less_than:	/* f0< ( r -- f ) */
/*  */
NAME("f0<")
{
DEF_CA
Float r;
Bool f;
NEXT_P0;
IF_TOS(sp[0] = TOS);
r = FTOS;
sp += -1;
fp += 1;
{
#line 1733 "/a5/anton/gforth/prim"
f = FLAG(r<0.);
#line 1733
}
NEXT_P1;
TOS = (Cell)f;
IF_FTOS(FTOS = fp[0]);
NEXT_P2;
}

I_f_zero_greater_than:	/* f0> ( r -- f ) */
/*  */
NAME("f0>")
{
DEF_CA
Float r;
Bool f;
NEXT_P0;
IF_TOS(sp[0] = TOS);
r = FTOS;
sp += -1;
fp += 1;
{
#line 1733 "/a5/anton/gforth/prim"
f = FLAG(r>0.);
#line 1733
}
NEXT_P1;
TOS = (Cell)f;
IF_FTOS(FTOS = fp[0]);
NEXT_P2;
}

I_f_zero_less_or_equal:	/* f0<= ( r -- f ) */
/*  */
NAME("f0<=")
{
DEF_CA
Float r;
Bool f;
NEXT_P0;
IF_TOS(sp[0] = TOS);
r = FTOS;
sp += -1;
fp += 1;
{
#line 1733 "/a5/anton/gforth/prim"
f = FLAG(r<=0.);
#line 1733
}
NEXT_P1;
TOS = (Cell)f;
IF_FTOS(FTOS = fp[0]);
NEXT_P2;
}

I_f_zero_greater_or_equal:	/* f0>= ( r -- f ) */
/*  */
NAME("f0>=")
{
DEF_CA
Float r;
Bool f;
NEXT_P0;
IF_TOS(sp[0] = TOS);
r = FTOS;
sp += -1;
fp += 1;
{
#line 1733 "/a5/anton/gforth/prim"
f = FLAG(r>=0.);
#line 1733
}
NEXT_P1;
TOS = (Cell)f;
IF_FTOS(FTOS = fp[0]);
NEXT_P2;
}

I_d_to_f:	/* d>f ( d -- r ) */
/*  */
NAME("d>f")
{
DEF_CA
DCell d;
Float r;
NEXT_P0;
IF_FTOS(fp[0] = FTOS);
FETCH_DCELL(d, sp[1], TOS);
sp += 2;
fp += -1;
{
#line 1736 "/a5/anton/gforth/prim"
#ifdef BUGGY_LONG_LONG
extern double ldexp(double x, int exp);
r = ldexp((Float)d.hi,CELL_BITS) + (Float)d.lo;
#else
r = d;
#endif
}
NEXT_P1;
FTOS = r;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_f_to_d:	/* f>d ( r -- d ) */
/*  */
NAME("f>d")
{
DEF_CA
Float r;
DCell d;
NEXT_P0;
IF_TOS(sp[0] = TOS);
r = FTOS;
sp += -2;
fp += 1;
{
#line 1744 "/a5/anton/gforth/prim"
#ifdef BUGGY_LONG_LONG
d.hi = ldexp(r,-(int)(CELL_BITS)) - (r<0);
d.lo = r-ldexp((Float)d.hi,CELL_BITS);
#else
d = r;
#endif
}
NEXT_P1;
STORE_DCELL(d, sp[1], TOS);
IF_FTOS(FTOS = fp[0]);
NEXT_P2;
}

I_f_store:	/* f! ( r f_addr -- ) */
/*  Store the floating-point value @i{r} to address @i{f-addr}. */
NAME("f!")
{
DEF_CA
Float r;
Float * f_addr;
NEXT_P0;
r = FTOS;
f_addr = (Float *) TOS;
sp += 1;
fp += 1;
{
#line 1753 "/a5/anton/gforth/prim"
*f_addr = r;
}
NEXT_P1;
IF_FTOS(FTOS = fp[0]);
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_f_fetch:	/* f@ ( f_addr -- r ) */
/*  Fetch floating-point value @i{r} from address @i{f-addr}. */
NAME("f@")
{
DEF_CA
Float * f_addr;
Float r;
NEXT_P0;
IF_FTOS(fp[0] = FTOS);
f_addr = (Float *) TOS;
sp += 1;
fp += -1;
{
#line 1757 "/a5/anton/gforth/prim"
r = *f_addr;
}
NEXT_P1;
FTOS = r;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_d_f_fetch:	/* df@ ( df_addr -- r ) */
/*  Fetch the double-precision IEEE floating-point value @i{r} from the address @i{df-addr}. */
NAME("df@")
{
DEF_CA
DFloat * df_addr;
Float r;
NEXT_P0;
IF_FTOS(fp[0] = FTOS);
df_addr = (DFloat *) TOS;
sp += 1;
fp += -1;
{
#line 1761 "/a5/anton/gforth/prim"
#ifdef IEEE_FP
r = *df_addr;
#else
!! df@
#endif
}
NEXT_P1;
FTOS = r;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_d_f_store:	/* df! ( r df_addr -- ) */
/*  Store the double-precision IEEE floating-point value @i{r} to the address @i{df-addr}. */
NAME("df!")
{
DEF_CA
Float r;
DFloat * df_addr;
NEXT_P0;
r = FTOS;
df_addr = (DFloat *) TOS;
sp += 1;
fp += 1;
{
#line 1769 "/a5/anton/gforth/prim"
#ifdef IEEE_FP
*df_addr = r;
#else
!! df!
#endif
}
NEXT_P1;
IF_FTOS(FTOS = fp[0]);
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_s_f_fetch:	/* sf@ ( sf_addr -- r ) */
/*  Fetch the single-precision IEEE floating-point value @i{r} from the address @i{sf-addr}. */
NAME("sf@")
{
DEF_CA
SFloat * sf_addr;
Float r;
NEXT_P0;
IF_FTOS(fp[0] = FTOS);
sf_addr = (SFloat *) TOS;
sp += 1;
fp += -1;
{
#line 1777 "/a5/anton/gforth/prim"
#ifdef IEEE_FP
r = *sf_addr;
#else
!! sf@
#endif
}
NEXT_P1;
FTOS = r;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_s_f_store:	/* sf! ( r sf_addr -- ) */
/*  Store the single-precision IEEE floating-point value @i{r} to the address @i{sf-addr}. */
NAME("sf!")
{
DEF_CA
Float r;
SFloat * sf_addr;
NEXT_P0;
r = FTOS;
sf_addr = (SFloat *) TOS;
sp += 1;
fp += 1;
{
#line 1785 "/a5/anton/gforth/prim"
#ifdef IEEE_FP
*sf_addr = r;
#else
!! sf!
#endif
}
NEXT_P1;
IF_FTOS(FTOS = fp[0]);
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_f_plus:	/* f+ ( r1 r2 -- r3 ) */
/*  */
NAME("f+")
{
DEF_CA
Float r1;
Float r2;
Float r3;
NEXT_P0;
r1 = fp[1];
r2 = FTOS;
fp += 1;
{
#line 1792 "/a5/anton/gforth/prim"
r3 = r1+r2;
}
NEXT_P1;
FTOS = r3;
NEXT_P2;
}

I_f_minus:	/* f- ( r1 r2 -- r3 ) */
/*  */
NAME("f-")
{
DEF_CA
Float r1;
Float r2;
Float r3;
NEXT_P0;
r1 = fp[1];
r2 = FTOS;
fp += 1;
{
#line 1795 "/a5/anton/gforth/prim"
r3 = r1-r2;
}
NEXT_P1;
FTOS = r3;
NEXT_P2;
}

I_f_star:	/* f* ( r1 r2 -- r3 ) */
/*  */
NAME("f*")
{
DEF_CA
Float r1;
Float r2;
Float r3;
NEXT_P0;
r1 = fp[1];
r2 = FTOS;
fp += 1;
{
#line 1798 "/a5/anton/gforth/prim"
r3 = r1*r2;
}
NEXT_P1;
FTOS = r3;
NEXT_P2;
}

I_f_slash:	/* f/ ( r1 r2 -- r3 ) */
/*  */
NAME("f/")
{
DEF_CA
Float r1;
Float r2;
Float r3;
NEXT_P0;
r1 = fp[1];
r2 = FTOS;
fp += 1;
{
#line 1801 "/a5/anton/gforth/prim"
r3 = r1/r2;
}
NEXT_P1;
FTOS = r3;
NEXT_P2;
}

I_f_star_star:	/* f** ( r1 r2 -- r3 ) */
/* @i{r3} is @i{r1} raised to the @i{r2}th power. */
NAME("f**")
{
DEF_CA
Float r1;
Float r2;
Float r3;
NEXT_P0;
r1 = fp[1];
r2 = FTOS;
fp += 1;
{
#line 1805 "/a5/anton/gforth/prim"
r3 = pow(r1,r2);
}
NEXT_P1;
FTOS = r3;
NEXT_P2;
}

I_f_negate:	/* fnegate ( r1 -- r2 ) */
/*  */
NAME("fnegate")
{
DEF_CA
Float r1;
Float r2;
NEXT_P0;
r1 = FTOS;
{
#line 1808 "/a5/anton/gforth/prim"
r2 = - r1;
}
NEXT_P1;
FTOS = r2;
NEXT_P2;
}

I_f_drop:	/* fdrop ( r -- ) */
/*  */
NAME("fdrop")
{
DEF_CA
Float r;
NEXT_P0;
r = FTOS;
fp += 1;
{
#line 1811 "/a5/anton/gforth/prim"
}
NEXT_P1;
IF_FTOS(FTOS = fp[0]);
NEXT_P2;
}

I_f_dupe:	/* fdup ( r -- r r ) */
/*  */
NAME("fdup")
{
DEF_CA
Float r;
NEXT_P0;
r = FTOS;
fp += -1;
{
#line 1813 "/a5/anton/gforth/prim"
}
NEXT_P1;
IF_FTOS(fp[1] = r;);
FTOS = r;
NEXT_P2;
}

I_f_swap:	/* fswap ( r1 r2 -- r2 r1 ) */
/*  */
NAME("fswap")
{
DEF_CA
Float r1;
Float r2;
NEXT_P0;
r1 = fp[1];
r2 = FTOS;
{
#line 1815 "/a5/anton/gforth/prim"
}
NEXT_P1;
fp[1] = r2;
FTOS = r1;
NEXT_P2;
}

I_f_over:	/* fover ( r1 r2 -- r1 r2 r1 ) */
/*  */
NAME("fover")
{
DEF_CA
Float r1;
Float r2;
NEXT_P0;
r1 = fp[1];
r2 = FTOS;
fp += -1;
{
#line 1817 "/a5/anton/gforth/prim"
}
NEXT_P1;
IF_FTOS(fp[1] = r2;);
FTOS = r1;
NEXT_P2;
}

I_f_rote:	/* frot ( r1 r2 r3 -- r2 r3 r1 ) */
/*  */
NAME("frot")
{
DEF_CA
Float r1;
Float r2;
Float r3;
NEXT_P0;
r1 = fp[2];
r2 = fp[1];
r3 = FTOS;
{
#line 1819 "/a5/anton/gforth/prim"
}
NEXT_P1;
fp[2] = r2;
fp[1] = r3;
FTOS = r1;
NEXT_P2;
}

I_f_nip:	/* fnip ( r1 r2 -- r2 ) */
/*  */
NAME("fnip")
{
DEF_CA
Float r1;
Float r2;
NEXT_P0;
r1 = fp[1];
r2 = FTOS;
fp += 1;
{
#line 1821 "/a5/anton/gforth/prim"
}
NEXT_P1;
FTOS = r2;
NEXT_P2;
}

I_f_tuck:	/* ftuck ( r1 r2 -- r2 r1 r2 ) */
/*  */
NAME("ftuck")
{
DEF_CA
Float r1;
Float r2;
NEXT_P0;
r1 = fp[1];
r2 = FTOS;
fp += -1;
{
#line 1823 "/a5/anton/gforth/prim"
}
NEXT_P1;
fp[2] = r2;
fp[1] = r1;
FTOS = r2;
NEXT_P2;
}

I_float_plus:	/* float+ ( f_addr1 -- f_addr2 ) */
/*  Increment @i{f-addr1} by the number of address units corresponding to the size of
one floating-point number, to give @i{f-addr2}. */
NAME("float+")
{
DEF_CA
Float * f_addr1;
Float * f_addr2;
NEXT_P0;
f_addr1 = (Float *) TOS;
{
#line 1827 "/a5/anton/gforth/prim"
f_addr2 = f_addr1+1;
}
NEXT_P1;
TOS = (Cell)f_addr2;
NEXT_P2;
}

I_floats:	/* floats ( n1 -- n2 ) */
/* @i{n2} is the number of address units corresponding to @i{n1} floating-point numbers. */
NAME("floats")
{
DEF_CA
Cell n1;
Cell n2;
NEXT_P0;
n1 = (Cell) TOS;
{
#line 1831 "/a5/anton/gforth/prim"
n2 = n1*sizeof(Float);
}
NEXT_P1;
TOS = (Cell)n2;
NEXT_P2;
}

I_floor:	/* floor ( r1 -- r2 ) */
/* Round towards the next smaller integral value, i.e., round toward negative infinity. */
NAME("floor")
{
DEF_CA
Float r1;
Float r2;
NEXT_P0;
r1 = FTOS;
{
#line 1835 "/a5/anton/gforth/prim"
/* !! unclear wording */
r2 = floor(r1);
}
NEXT_P1;
FTOS = r2;
NEXT_P2;
}

I_f_round:	/* fround ( r1 -- r2 ) */
/* Round to the nearest integral value. */
NAME("fround")
{
DEF_CA
Float r1;
Float r2;
NEXT_P0;
r1 = FTOS;
{
#line 1840 "/a5/anton/gforth/prim"
/* !! unclear wording */
#ifdef HAVE_RINT
r2 = rint(r1);
#else
r2 = floor(r1+0.5);
/* !! This is not quite true to the rounding rules given in the standard */
#endif
}
NEXT_P1;
FTOS = r2;
NEXT_P2;
}

I_f_max:	/* fmax ( r1 r2 -- r3 ) */
/*  */
NAME("fmax")
{
DEF_CA
Float r1;
Float r2;
Float r3;
NEXT_P0;
r1 = fp[1];
r2 = FTOS;
fp += 1;
{
#line 1849 "/a5/anton/gforth/prim"
if (r1<r2)
  r3 = r2;
else
  r3 = r1;
}
NEXT_P1;
FTOS = r3;
NEXT_P2;
}

I_f_min:	/* fmin ( r1 r2 -- r3 ) */
/*  */
NAME("fmin")
{
DEF_CA
Float r1;
Float r2;
Float r3;
NEXT_P0;
r1 = fp[1];
r2 = FTOS;
fp += 1;
{
#line 1855 "/a5/anton/gforth/prim"
if (r1<r2)
  r3 = r1;
else
  r3 = r2;
}
NEXT_P1;
FTOS = r3;
NEXT_P2;
}

I_represent:	/* represent ( r c_addr u -- n f1 f2 ) */
/*  */
NAME("represent")
{
DEF_CA
Float r;
Char * c_addr;
UCell u;
Cell n;
Bool f1;
Bool f2;
NEXT_P0;
r = FTOS;
c_addr = (Char *) sp[1];
u = (UCell) TOS;
sp += -1;
fp += 1;
{
#line 1861 "/a5/anton/gforth/prim"
char *sig;
int flag;
int decpt;
sig=ecvt(r, u, &decpt, &flag);
n=(r==0 ? 1 : decpt);
f1=FLAG(flag!=0);
f2=FLAG(isdigit((unsigned)(sig[0]))!=0);
memmove(c_addr,sig,u);
}
NEXT_P1;
sp[2] = (Cell)n;
sp[1] = (Cell)f1;
TOS = (Cell)f2;
IF_FTOS(FTOS = fp[0]);
NEXT_P2;
}

I_to_float:	/* >float ( c_addr u -- flag ) */
/* Attempt to convert the character string @i{c-addr u} to
internal floating-point representation. If the string
represents a valid floating-point number @i{r} is placed
on the floating-point stack and @i{flag} is true. Otherwise,
@i{flag} is false. A string of blanks is a special case
and represents the floating-point number 0. */
NAME(">float")
{
DEF_CA
Char * c_addr;
UCell u;
Bool flag;
NEXT_P0;
c_addr = (Char *) sp[1];
u = (UCell) TOS;
sp += 1;
{
#line 1877 "/a5/anton/gforth/prim"
/* real signature: c_addr u -- r t / f */
Float r;
char *number=cstr(c_addr, u, 1);
char *endconv;
int sign = 0;
if(number[0]=='-') {
   sign = 1;
   number++;
   u--;
}
while(isspace((unsigned)(number[--u])) && u>0);
switch(number[u])
{
   case 'd':
   case 'D':
   case 'e':
   case 'E':  break;
   default :  u++; break;
}
number[u]='\0';
r=strtod(number,&endconv);
if((flag=FLAG(!(Cell)*endconv)))
{
   IF_FTOS(fp[0] = FTOS);
   fp += -1;
   FTOS = sign ? -r : r;
}
else if(*endconv=='d' || *endconv=='D')
{
   *endconv='E';
   r=strtod(number,&endconv);
   if((flag=FLAG(!(Cell)*endconv)))
     {
	IF_FTOS(fp[0] = FTOS);
	fp += -1;
	FTOS = sign ? -r : r;
     }
}
}
NEXT_P1;
TOS = (Cell)flag;
NEXT_P2;
}

I_f_abs:	/* fabs ( r1 -- r2 ) */
/*  */
NAME("fabs")
{
DEF_CA
Float r1;
Float r2;
NEXT_P0;
r1 = FTOS;
{
#line 1917 "/a5/anton/gforth/prim"
r2 = fabs(r1);
}
NEXT_P1;
FTOS = r2;
NEXT_P2;
}

I_f_a_cos:	/* facos ( r1 -- r2 ) */
/*  */
NAME("facos")
{
DEF_CA
Float r1;
Float r2;
NEXT_P0;
r1 = FTOS;
{
#line 1920 "/a5/anton/gforth/prim"
r2 = acos(r1);
}
NEXT_P1;
FTOS = r2;
NEXT_P2;
}

I_f_a_sine:	/* fasin ( r1 -- r2 ) */
/*  */
NAME("fasin")
{
DEF_CA
Float r1;
Float r2;
NEXT_P0;
r1 = FTOS;
{
#line 1923 "/a5/anton/gforth/prim"
r2 = asin(r1);
}
NEXT_P1;
FTOS = r2;
NEXT_P2;
}

I_f_a_tan:	/* fatan ( r1 -- r2 ) */
/*  */
NAME("fatan")
{
DEF_CA
Float r1;
Float r2;
NEXT_P0;
r1 = FTOS;
{
#line 1926 "/a5/anton/gforth/prim"
r2 = atan(r1);
}
NEXT_P1;
FTOS = r2;
NEXT_P2;
}

I_f_a_tan_two:	/* fatan2 ( r1 r2 -- r3 ) */
/* @i{r1/r2}=tan(@i{r3}). ANS Forth does not require, but probably
intends this to be the inverse of @code{fsincos}. In gforth it is. */
NAME("fatan2")
{
DEF_CA
Float r1;
Float r2;
Float r3;
NEXT_P0;
r1 = fp[1];
r2 = FTOS;
fp += 1;
{
#line 1931 "/a5/anton/gforth/prim"
r3 = atan2(r1,r2);
}
NEXT_P1;
FTOS = r3;
NEXT_P2;
}

I_f_cos:	/* fcos ( r1 -- r2 ) */
/*  */
NAME("fcos")
{
DEF_CA
Float r1;
Float r2;
NEXT_P0;
r1 = FTOS;
{
#line 1934 "/a5/anton/gforth/prim"
r2 = cos(r1);
}
NEXT_P1;
FTOS = r2;
NEXT_P2;
}

I_f_e_x_p:	/* fexp ( r1 -- r2 ) */
/*  */
NAME("fexp")
{
DEF_CA
Float r1;
Float r2;
NEXT_P0;
r1 = FTOS;
{
#line 1937 "/a5/anton/gforth/prim"
r2 = exp(r1);
}
NEXT_P1;
FTOS = r2;
NEXT_P2;
}

I_f_e_x_p_m_one:	/* fexpm1 ( r1 -- r2 ) */
/* @i{r2}=@i{e}**@i{r1}@minus{}1 */
NAME("fexpm1")
{
DEF_CA
Float r1;
Float r2;
NEXT_P0;
r1 = FTOS;
{
#line 1941 "/a5/anton/gforth/prim"
#ifdef HAVE_EXPM1
extern double
#ifdef NeXT
              const
#endif
                    expm1(double);
r2 = expm1(r1);
#else
r2 = exp(r1)-1.;
#endif
}
NEXT_P1;
FTOS = r2;
NEXT_P2;
}

I_f_l_n:	/* fln ( r1 -- r2 ) */
/*  */
NAME("fln")
{
DEF_CA
Float r1;
Float r2;
NEXT_P0;
r1 = FTOS;
{
#line 1953 "/a5/anton/gforth/prim"
r2 = log(r1);
}
NEXT_P1;
FTOS = r2;
NEXT_P2;
}

I_f_l_n_p_one:	/* flnp1 ( r1 -- r2 ) */
/* @i{r2}=ln(@i{r1}+1) */
NAME("flnp1")
{
DEF_CA
Float r1;
Float r2;
NEXT_P0;
r1 = FTOS;
{
#line 1957 "/a5/anton/gforth/prim"
#ifdef HAVE_LOG1P
extern double
#ifdef NeXT
              const
#endif
                    log1p(double);
r2 = log1p(r1);
#else
r2 = log(r1+1.);
#endif
}
NEXT_P1;
FTOS = r2;
NEXT_P2;
}

I_f_log:	/* flog ( r1 -- r2 ) */
/* The decimal logarithm. */
NAME("flog")
{
DEF_CA
Float r1;
Float r2;
NEXT_P0;
r1 = FTOS;
{
#line 1970 "/a5/anton/gforth/prim"
r2 = log10(r1);
}
NEXT_P1;
FTOS = r2;
NEXT_P2;
}

I_f_a_log:	/* falog ( r1 -- r2 ) */
/* @i{r2}=10**@i{r1} */
NAME("falog")
{
DEF_CA
Float r1;
Float r2;
NEXT_P0;
r1 = FTOS;
{
#line 1974 "/a5/anton/gforth/prim"
extern double pow10(double);
r2 = pow10(r1);
}
NEXT_P1;
FTOS = r2;
NEXT_P2;
}

I_f_sine:	/* fsin ( r1 -- r2 ) */
/*  */
NAME("fsin")
{
DEF_CA
Float r1;
Float r2;
NEXT_P0;
r1 = FTOS;
{
#line 1978 "/a5/anton/gforth/prim"
r2 = sin(r1);
}
NEXT_P1;
FTOS = r2;
NEXT_P2;
}

I_f_sine_cos:	/* fsincos ( r1 -- r2 r3 ) */
/* @i{r2}=sin(@i{r1}), @i{r3}=cos(@i{r1}) */
NAME("fsincos")
{
DEF_CA
Float r1;
Float r2;
Float r3;
NEXT_P0;
r1 = FTOS;
fp += -1;
{
#line 1982 "/a5/anton/gforth/prim"
r2 = sin(r1);
r3 = cos(r1);
}
NEXT_P1;
fp[1] = r2;
FTOS = r3;
NEXT_P2;
}

I_f_square_root:	/* fsqrt ( r1 -- r2 ) */
/*  */
NAME("fsqrt")
{
DEF_CA
Float r1;
Float r2;
NEXT_P0;
r1 = FTOS;
{
#line 1986 "/a5/anton/gforth/prim"
r2 = sqrt(r1);
}
NEXT_P1;
FTOS = r2;
NEXT_P2;
}

I_f_tan:	/* ftan ( r1 -- r2 ) */
/*  */
NAME("ftan")
{
DEF_CA
Float r1;
Float r2;
NEXT_P0;
r1 = FTOS;
{
#line 1989 "/a5/anton/gforth/prim"
r2 = tan(r1);
}
NEXT_P1;
FTOS = r2;
NEXT_P2;
}

I_f_cinch:	/* fsinh ( r1 -- r2 ) */
/*  */
NAME("fsinh")
{
DEF_CA
Float r1;
Float r2;
NEXT_P0;
r1 = FTOS;
{
#line 1994 "/a5/anton/gforth/prim"
r2 = sinh(r1);
}
NEXT_P1;
FTOS = r2;
NEXT_P2;
}

I_f_cosh:	/* fcosh ( r1 -- r2 ) */
/*  */
NAME("fcosh")
{
DEF_CA
Float r1;
Float r2;
NEXT_P0;
r1 = FTOS;
{
#line 1999 "/a5/anton/gforth/prim"
r2 = cosh(r1);
}
NEXT_P1;
FTOS = r2;
NEXT_P2;
}

I_f_tan_h:	/* ftanh ( r1 -- r2 ) */
/*  */
NAME("ftanh")
{
DEF_CA
Float r1;
Float r2;
NEXT_P0;
r1 = FTOS;
{
#line 2004 "/a5/anton/gforth/prim"
r2 = tanh(r1);
}
NEXT_P1;
FTOS = r2;
NEXT_P2;
}

I_f_a_cinch:	/* fasinh ( r1 -- r2 ) */
/*  */
NAME("fasinh")
{
DEF_CA
Float r1;
Float r2;
NEXT_P0;
r1 = FTOS;
{
#line 2009 "/a5/anton/gforth/prim"
r2 = asinh(r1);
}
NEXT_P1;
FTOS = r2;
NEXT_P2;
}

I_f_a_cosh:	/* facosh ( r1 -- r2 ) */
/*  */
NAME("facosh")
{
DEF_CA
Float r1;
Float r2;
NEXT_P0;
r1 = FTOS;
{
#line 2014 "/a5/anton/gforth/prim"
r2 = acosh(r1);
}
NEXT_P1;
FTOS = r2;
NEXT_P2;
}

I_f_a_tan_h:	/* fatanh ( r1 -- r2 ) */
/*  */
NAME("fatanh")
{
DEF_CA
Float r1;
Float r2;
NEXT_P0;
r1 = FTOS;
{
#line 2019 "/a5/anton/gforth/prim"
r2 = atanh(r1);
}
NEXT_P1;
FTOS = r2;
NEXT_P2;
}

I_s_floats:	/* sfloats ( n1 -- n2 ) */
/* @i{n2} is the number of address units corresponding to @i{n1}
single-precision IEEE floating-point numbers. */
NAME("sfloats")
{
DEF_CA
Cell n1;
Cell n2;
NEXT_P0;
n1 = (Cell) TOS;
{
#line 2027 "/a5/anton/gforth/prim"
n2 = n1*sizeof(SFloat);
}
NEXT_P1;
TOS = (Cell)n2;
NEXT_P2;
}

I_d_floats:	/* dfloats ( n1 -- n2 ) */
/* @i{n2} is the number of address units corresponding to @i{n1}
double-precision IEEE floating-point numbers. */
NAME("dfloats")
{
DEF_CA
Cell n1;
Cell n2;
NEXT_P0;
n1 = (Cell) TOS;
{
#line 2032 "/a5/anton/gforth/prim"
n2 = n1*sizeof(DFloat);
}
NEXT_P1;
TOS = (Cell)n2;
NEXT_P2;
}

I_s_f_aligned:	/* sfaligned ( c_addr -- sf_addr ) */
/*  @i{sf-addr} is the first single-float-aligned address greater
than or equal to @i{c-addr}. */
NAME("sfaligned")
{
DEF_CA
Char * c_addr;
SFloat * sf_addr;
NEXT_P0;
c_addr = (Char *) TOS;
{
#line 2037 "/a5/anton/gforth/prim"
sf_addr = (SFloat *)((((Cell)c_addr)+(sizeof(SFloat)-1))&(-sizeof(SFloat)));
}
NEXT_P1;
TOS = (Cell)sf_addr;
NEXT_P2;
}

I_d_f_aligned:	/* dfaligned ( c_addr -- df_addr ) */
/*  @i{df-addr} is the first double-float-aligned address greater
than or equal to @i{c-addr}. */
NAME("dfaligned")
{
DEF_CA
Char * c_addr;
DFloat * df_addr;
NEXT_P0;
c_addr = (Char *) TOS;
{
#line 2044 "/a5/anton/gforth/prim"
df_addr = (DFloat *)((((Cell)c_addr)+(sizeof(DFloat)-1))&(-sizeof(DFloat)));
}
NEXT_P1;
TOS = (Cell)df_addr;
NEXT_P2;
}

#endif
#ifdef HAS_GLOCALS
I_fetch_local_number:	/* @local# ( -- w ) */
/*  */
NAME("@local#")
{
DEF_CA
Cell w;
NEXT_P0;
IF_TOS(sp[0] = TOS);
sp += -1;
{
#line 2058 "/a5/anton/gforth/prim"
w = *(Cell *)(lp+(Cell)NEXT_INST);
INC_IP(1);
}
NEXT_P1;
TOS = (Cell)w;
NEXT_P2;
}

I_fetch_local_zero:	/* @local0 ( -- w ) */
/*  */
NAME("@local0")
{
DEF_CA
Cell w;
NEXT_P0;
IF_TOS(sp[0] = TOS);
sp += -1;
{
#line 2062 "/a5/anton/gforth/prim"
w = *(Cell *)(lp+0*sizeof(Cell));
}
NEXT_P1;
TOS = (Cell)w;
NEXT_P2;
}

I_fetch_local_four:	/* @local1 ( -- w ) */
/*  */
NAME("@local1")
{
DEF_CA
Cell w;
NEXT_P0;
IF_TOS(sp[0] = TOS);
sp += -1;
{
#line 2065 "/a5/anton/gforth/prim"
w = *(Cell *)(lp+1*sizeof(Cell));
}
NEXT_P1;
TOS = (Cell)w;
NEXT_P2;
}

I_fetch_local_eight:	/* @local2 ( -- w ) */
/*  */
NAME("@local2")
{
DEF_CA
Cell w;
NEXT_P0;
IF_TOS(sp[0] = TOS);
sp += -1;
{
#line 2068 "/a5/anton/gforth/prim"
w = *(Cell *)(lp+2*sizeof(Cell));
}
NEXT_P1;
TOS = (Cell)w;
NEXT_P2;
}

I_fetch_local_twelve:	/* @local3 ( -- w ) */
/*  */
NAME("@local3")
{
DEF_CA
Cell w;
NEXT_P0;
IF_TOS(sp[0] = TOS);
sp += -1;
{
#line 2071 "/a5/anton/gforth/prim"
w = *(Cell *)(lp+3*sizeof(Cell));
}
NEXT_P1;
TOS = (Cell)w;
NEXT_P2;
}

#ifdef HAS_FLOATING
I_f_fetch_local_number:	/* f@local# ( -- r ) */
/*  */
NAME("f@local#")
{
DEF_CA
Float r;
NEXT_P0;
IF_FTOS(fp[0] = FTOS);
fp += -1;
{
#line 2076 "/a5/anton/gforth/prim"
r = *(Float *)(lp+(Cell)NEXT_INST);
INC_IP(1);
}
NEXT_P1;
FTOS = r;
NEXT_P2;
}

I_f_fetch_local_zero:	/* f@local0 ( -- r ) */
/*  */
NAME("f@local0")
{
DEF_CA
Float r;
NEXT_P0;
IF_FTOS(fp[0] = FTOS);
fp += -1;
{
#line 2080 "/a5/anton/gforth/prim"
r = *(Float *)(lp+0*sizeof(Float));
}
NEXT_P1;
FTOS = r;
NEXT_P2;
}

I_f_fetch_local_eight:	/* f@local1 ( -- r ) */
/*  */
NAME("f@local1")
{
DEF_CA
Float r;
NEXT_P0;
IF_FTOS(fp[0] = FTOS);
fp += -1;
{
#line 2083 "/a5/anton/gforth/prim"
r = *(Float *)(lp+1*sizeof(Float));
}
NEXT_P1;
FTOS = r;
NEXT_P2;
}

#endif
I_laddr_number:	/* laddr# ( -- c_addr ) */
/*  */
NAME("laddr#")
{
DEF_CA
Char * c_addr;
NEXT_P0;
IF_TOS(sp[0] = TOS);
sp += -1;
{
#line 2088 "/a5/anton/gforth/prim"
/* this can also be used to implement lp@ */
c_addr = (Char *)(lp+(Cell)NEXT_INST);
INC_IP(1);
}
NEXT_P1;
TOS = (Cell)c_addr;
NEXT_P2;
}

I_lp_plus_store_number:	/* lp+!# ( -- ) */
/* used with negative immediate values it allocates memory on the
local stack, a positive immediate argument drops memory from the local
stack */
NAME("lp+!#")
{
DEF_CA
NEXT_P0;
{
#line 2096 "/a5/anton/gforth/prim"
lp += (Cell)NEXT_INST;
INC_IP(1);
}
NEXT_P1;
NEXT_P2;
}

I_minus_four_lp_plus_store:	/* lp- ( -- ) */
/*  */
NAME("lp-")
{
DEF_CA
NEXT_P0;
{
#line 2100 "/a5/anton/gforth/prim"
lp += -sizeof(Cell);
}
NEXT_P1;
NEXT_P2;
}

I_eight_lp_plus_store:	/* lp+ ( -- ) */
/*  */
NAME("lp+")
{
DEF_CA
NEXT_P0;
{
#line 2103 "/a5/anton/gforth/prim"
lp += sizeof(Float);
}
NEXT_P1;
NEXT_P2;
}

I_sixteen_lp_plus_store:	/* lp+2 ( -- ) */
/*  */
NAME("lp+2")
{
DEF_CA
NEXT_P0;
{
#line 2106 "/a5/anton/gforth/prim"
lp += 2*sizeof(Float);
}
NEXT_P1;
NEXT_P2;
}

I_lp_store:	/* lp! ( c_addr -- ) */
/*  */
NAME("lp!")
{
DEF_CA
Char * c_addr;
NEXT_P0;
c_addr = (Char *) TOS;
sp += 1;
{
#line 2109 "/a5/anton/gforth/prim"
lp = (Address)c_addr;
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_to_l:	/* >l ( w -- ) */
/*  */
NAME(">l")
{
DEF_CA
Cell w;
NEXT_P0;
w = (Cell) TOS;
sp += 1;
{
#line 2112 "/a5/anton/gforth/prim"
lp -= sizeof(Cell);
*(Cell *)lp = w;
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

#ifdef HAS_FLOATING
I_f_to_l:	/* f>l ( r -- ) */
/*  */
NAME("f>l")
{
DEF_CA
Float r;
NEXT_P0;
r = FTOS;
fp += 1;
{
#line 2118 "/a5/anton/gforth/prim"
lp -= sizeof(Float);
*(Float *)lp = r;
}
NEXT_P1;
IF_FTOS(FTOS = fp[0]);
NEXT_P2;
}

I_fpick:	/* fpick ( u -- r ) */
/*  */
NAME("fpick")
{
DEF_CA
UCell u;
Float r;
NEXT_P0;
IF_FTOS(fp[0] = FTOS);
u = (UCell) TOS;
sp += 1;
fp += -1;
{
#line 2122 "/a5/anton/gforth/prim"
r = fp[u+1]; /* +1, because update of fp happens before this fragment */
}
NEXT_P1;
FTOS = r;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

#endif
#endif
#ifdef HAS_OS
I_open_lib:	/* open-lib ( c_addr1 u1 -- u2 ) */
/*  */
NAME("open-lib")
{
DEF_CA
Char * c_addr1;
UCell u1;
UCell u2;
NEXT_P0;
c_addr1 = (Char *) sp[1];
u1 = (UCell) TOS;
sp += 1;
{
#line 2163 "/a5/anton/gforth/prim"
#if defined(HAVE_LIBDL) || defined(HAVE_DLOPEN)
#ifndef RTLD_GLOBAL
#define RTLD_GLOBAL 0
#endif
u2=(UCell) dlopen(cstr(c_addr1, u1, 1), RTLD_GLOBAL | RTLD_LAZY);
#else
#  ifdef _WIN32
u2 = (Cell) GetModuleHandle(cstr(c_addr1, u1, 1));
#  else
#warning Define open-lib!
u2 = 0;
#  endif
#endif
}
NEXT_P1;
TOS = (Cell)u2;
NEXT_P2;
}

I_lib_sym:	/* lib-sym ( c_addr1 u1 u2 -- u3 ) */
/*  */
NAME("lib-sym")
{
DEF_CA
Char * c_addr1;
UCell u1;
UCell u2;
UCell u3;
NEXT_P0;
c_addr1 = (Char *) sp[2];
u1 = (UCell) sp[1];
u2 = (UCell) TOS;
sp += 2;
{
#line 2178 "/a5/anton/gforth/prim"
#if defined(HAVE_LIBDL) || defined(HAVE_DLOPEN)
u3 = (UCell) dlsym((void*)u2,cstr(c_addr1, u1, 1));
#else
#  ifdef _WIN32
u3 = (Cell) GetProcAddress((HMODULE)u2, cstr(c_addr1, u1, 1));
#  else
#warning Define lib-sym!
u3 = 0;
#  endif
#endif
}
NEXT_P1;
TOS = (Cell)u3;
NEXT_P2;
}

I_icall0:	/* icall0 ( u -- uret ) */
/*  */
NAME("icall0")
{
DEF_CA
UCell u;
UCell uret;
NEXT_P0;
u = (UCell) TOS;
{
#line 2189 "/a5/anton/gforth/prim"
uret = (SYSCALL(Cell(*)())u)();
#line 2189
}
NEXT_P1;
TOS = (Cell)uret;
NEXT_P2;
}

I_icall1:	/* icall1 ( u1 u -- uret ) */
/*  */
NAME("icall1")
{
DEF_CA
UCell u1;
UCell u;
UCell uret;
NEXT_P0;
u1 = (UCell) sp[1];
u = (UCell) TOS;
sp += 1;
{
#line 2189 "/a5/anton/gforth/prim"
uret = (SYSCALL(Cell(*)(Cell))u)(u1);
#line 2189
}
NEXT_P1;
TOS = (Cell)uret;
NEXT_P2;
}

I_icall2:	/* icall2 ( u1 u2 u -- uret ) */
/*  */
NAME("icall2")
{
DEF_CA
UCell u1;
UCell u2;
UCell u;
UCell uret;
NEXT_P0;
u1 = (UCell) sp[2];
u2 = (UCell) sp[1];
u = (UCell) TOS;
sp += 2;
{
#line 2189 "/a5/anton/gforth/prim"
uret = (SYSCALL(Cell(*)(Cell, Cell))u)(u1, u2);
#line 2189
}
NEXT_P1;
TOS = (Cell)uret;
NEXT_P2;
}

I_icall3:	/* icall3 ( u1 u2 u3 u -- uret ) */
/*  */
NAME("icall3")
{
DEF_CA
UCell u1;
UCell u2;
UCell u3;
UCell u;
UCell uret;
NEXT_P0;
u1 = (UCell) sp[3];
u2 = (UCell) sp[2];
u3 = (UCell) sp[1];
u = (UCell) TOS;
sp += 3;
{
#line 2189 "/a5/anton/gforth/prim"
uret = (SYSCALL(Cell(*)(Cell, Cell, Cell))u)(u1, u2, u3);
#line 2189
}
NEXT_P1;
TOS = (Cell)uret;
NEXT_P2;
}

I_icall4:	/* icall4 ( u1 u2 u3 u4 u -- uret ) */
/*  */
NAME("icall4")
{
DEF_CA
UCell u1;
UCell u2;
UCell u3;
UCell u4;
UCell u;
UCell uret;
NEXT_P0;
u1 = (UCell) sp[4];
u2 = (UCell) sp[3];
u3 = (UCell) sp[2];
u4 = (UCell) sp[1];
u = (UCell) TOS;
sp += 4;
{
#line 2189 "/a5/anton/gforth/prim"
uret = (SYSCALL(Cell(*)(Cell, Cell, Cell, Cell))u)(u1, u2, u3, u4);
#line 2189
}
NEXT_P1;
TOS = (Cell)uret;
NEXT_P2;
}

I_icall5:	/* icall5 ( u1 u2 u3 u4 u5 u -- uret ) */
/*  */
NAME("icall5")
{
DEF_CA
UCell u1;
UCell u2;
UCell u3;
UCell u4;
UCell u5;
UCell u;
UCell uret;
NEXT_P0;
u1 = (UCell) sp[5];
u2 = (UCell) sp[4];
u3 = (UCell) sp[3];
u4 = (UCell) sp[2];
u5 = (UCell) sp[1];
u = (UCell) TOS;
sp += 5;
{
#line 2189 "/a5/anton/gforth/prim"
uret = (SYSCALL(Cell(*)(Cell, Cell, Cell, Cell, Cell))u)(u1, u2, u3, u4, u5);
#line 2189
}
NEXT_P1;
TOS = (Cell)uret;
NEXT_P2;
}

I_icall6:	/* icall6 ( u1 u2 u3 u4 u5 u6 u -- uret ) */
/*  */
NAME("icall6")
{
DEF_CA
UCell u1;
UCell u2;
UCell u3;
UCell u4;
UCell u5;
UCell u6;
UCell u;
UCell uret;
NEXT_P0;
u1 = (UCell) sp[6];
u2 = (UCell) sp[5];
u3 = (UCell) sp[4];
u4 = (UCell) sp[3];
u5 = (UCell) sp[2];
u6 = (UCell) sp[1];
u = (UCell) TOS;
sp += 6;
{
#line 2189 "/a5/anton/gforth/prim"
uret = (SYSCALL(Cell(*)(Cell, Cell, Cell, Cell, Cell, Cell))u)(u1, u2, u3, u4, u5, u6);
#line 2189
}
NEXT_P1;
TOS = (Cell)uret;
NEXT_P2;
}

I_icall20:	/* icall20 ( u1 u2 u3 u4 u5 u6 u7 u8 u9 u10 u11 u12 u13 u14 u15 u16 u17 u18 u19 u20 u -- uret ) */
/*  */
NAME("icall20")
{
DEF_CA
UCell u1;
UCell u2;
UCell u3;
UCell u4;
UCell u5;
UCell u6;
UCell u7;
UCell u8;
UCell u9;
UCell u10;
UCell u11;
UCell u12;
UCell u13;
UCell u14;
UCell u15;
UCell u16;
UCell u17;
UCell u18;
UCell u19;
UCell u20;
UCell u;
UCell uret;
NEXT_P0;
u1 = (UCell) sp[20];
u2 = (UCell) sp[19];
u3 = (UCell) sp[18];
u4 = (UCell) sp[17];
u5 = (UCell) sp[16];
u6 = (UCell) sp[15];
u7 = (UCell) sp[14];
u8 = (UCell) sp[13];
u9 = (UCell) sp[12];
u10 = (UCell) sp[11];
u11 = (UCell) sp[10];
u12 = (UCell) sp[9];
u13 = (UCell) sp[8];
u14 = (UCell) sp[7];
u15 = (UCell) sp[6];
u16 = (UCell) sp[5];
u17 = (UCell) sp[4];
u18 = (UCell) sp[3];
u19 = (UCell) sp[2];
u20 = (UCell) sp[1];
u = (UCell) TOS;
sp += 20;
{
#line 2190 "/a5/anton/gforth/prim"
uret = (SYSCALL(Cell(*)(Cell, Cell, Cell, Cell, Cell, Cell, Cell, Cell, Cell, Cell, Cell, Cell, Cell, Cell, Cell, Cell, Cell, Cell, Cell, Cell))u)(u1, u2, u3, u4, u5, u6, u7, u8, u9, u10, u11, u12, u13, u14, u15, u16, u17, u18, u19, u20);
#line 2190
}
NEXT_P1;
TOS = (Cell)uret;
NEXT_P2;
}

I_fcall0:	/* fcall0 ( u -- rret ) */
/*  */
NAME("fcall0")
{
DEF_CA
UCell u;
Float rret;
NEXT_P0;
IF_FTOS(fp[0] = FTOS);
u = (UCell) TOS;
sp += 1;
fp += -1;
{
#line 2191 "/a5/anton/gforth/prim"
rret = (SYSCALL(Float(*)())u)();
#line 2191
}
NEXT_P1;
FTOS = rret;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_fcall1:	/* fcall1 ( u1 u -- rret ) */
/*  */
NAME("fcall1")
{
DEF_CA
UCell u1;
UCell u;
Float rret;
NEXT_P0;
IF_FTOS(fp[0] = FTOS);
u1 = (UCell) sp[1];
u = (UCell) TOS;
sp += 2;
fp += -1;
{
#line 2191 "/a5/anton/gforth/prim"
rret = (SYSCALL(Float(*)(Cell))u)(u1);
#line 2191
}
NEXT_P1;
FTOS = rret;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_fcall2:	/* fcall2 ( u1 u2 u -- rret ) */
/*  */
NAME("fcall2")
{
DEF_CA
UCell u1;
UCell u2;
UCell u;
Float rret;
NEXT_P0;
IF_FTOS(fp[0] = FTOS);
u1 = (UCell) sp[2];
u2 = (UCell) sp[1];
u = (UCell) TOS;
sp += 3;
fp += -1;
{
#line 2191 "/a5/anton/gforth/prim"
rret = (SYSCALL(Float(*)(Cell, Cell))u)(u1, u2);
#line 2191
}
NEXT_P1;
FTOS = rret;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_fcall3:	/* fcall3 ( u1 u2 u3 u -- rret ) */
/*  */
NAME("fcall3")
{
DEF_CA
UCell u1;
UCell u2;
UCell u3;
UCell u;
Float rret;
NEXT_P0;
IF_FTOS(fp[0] = FTOS);
u1 = (UCell) sp[3];
u2 = (UCell) sp[2];
u3 = (UCell) sp[1];
u = (UCell) TOS;
sp += 4;
fp += -1;
{
#line 2191 "/a5/anton/gforth/prim"
rret = (SYSCALL(Float(*)(Cell, Cell, Cell))u)(u1, u2, u3);
#line 2191
}
NEXT_P1;
FTOS = rret;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_fcall4:	/* fcall4 ( u1 u2 u3 u4 u -- rret ) */
/*  */
NAME("fcall4")
{
DEF_CA
UCell u1;
UCell u2;
UCell u3;
UCell u4;
UCell u;
Float rret;
NEXT_P0;
IF_FTOS(fp[0] = FTOS);
u1 = (UCell) sp[4];
u2 = (UCell) sp[3];
u3 = (UCell) sp[2];
u4 = (UCell) sp[1];
u = (UCell) TOS;
sp += 5;
fp += -1;
{
#line 2191 "/a5/anton/gforth/prim"
rret = (SYSCALL(Float(*)(Cell, Cell, Cell, Cell))u)(u1, u2, u3, u4);
#line 2191
}
NEXT_P1;
FTOS = rret;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_fcall5:	/* fcall5 ( u1 u2 u3 u4 u5 u -- rret ) */
/*  */
NAME("fcall5")
{
DEF_CA
UCell u1;
UCell u2;
UCell u3;
UCell u4;
UCell u5;
UCell u;
Float rret;
NEXT_P0;
IF_FTOS(fp[0] = FTOS);
u1 = (UCell) sp[5];
u2 = (UCell) sp[4];
u3 = (UCell) sp[3];
u4 = (UCell) sp[2];
u5 = (UCell) sp[1];
u = (UCell) TOS;
sp += 6;
fp += -1;
{
#line 2191 "/a5/anton/gforth/prim"
rret = (SYSCALL(Float(*)(Cell, Cell, Cell, Cell, Cell))u)(u1, u2, u3, u4, u5);
#line 2191
}
NEXT_P1;
FTOS = rret;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_fcall6:	/* fcall6 ( u1 u2 u3 u4 u5 u6 u -- rret ) */
/*  */
NAME("fcall6")
{
DEF_CA
UCell u1;
UCell u2;
UCell u3;
UCell u4;
UCell u5;
UCell u6;
UCell u;
Float rret;
NEXT_P0;
IF_FTOS(fp[0] = FTOS);
u1 = (UCell) sp[6];
u2 = (UCell) sp[5];
u3 = (UCell) sp[4];
u4 = (UCell) sp[3];
u5 = (UCell) sp[2];
u6 = (UCell) sp[1];
u = (UCell) TOS;
sp += 7;
fp += -1;
{
#line 2191 "/a5/anton/gforth/prim"
rret = (SYSCALL(Float(*)(Cell, Cell, Cell, Cell, Cell, Cell))u)(u1, u2, u3, u4, u5, u6);
#line 2191
}
NEXT_P1;
FTOS = rret;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_fcall20:	/* fcall20 ( u1 u2 u3 u4 u5 u6 u7 u8 u9 u10 u11 u12 u13 u14 u15 u16 u17 u18 u19 u20 u -- rret ) */
/*  */
NAME("fcall20")
{
DEF_CA
UCell u1;
UCell u2;
UCell u3;
UCell u4;
UCell u5;
UCell u6;
UCell u7;
UCell u8;
UCell u9;
UCell u10;
UCell u11;
UCell u12;
UCell u13;
UCell u14;
UCell u15;
UCell u16;
UCell u17;
UCell u18;
UCell u19;
UCell u20;
UCell u;
Float rret;
NEXT_P0;
IF_FTOS(fp[0] = FTOS);
u1 = (UCell) sp[20];
u2 = (UCell) sp[19];
u3 = (UCell) sp[18];
u4 = (UCell) sp[17];
u5 = (UCell) sp[16];
u6 = (UCell) sp[15];
u7 = (UCell) sp[14];
u8 = (UCell) sp[13];
u9 = (UCell) sp[12];
u10 = (UCell) sp[11];
u11 = (UCell) sp[10];
u12 = (UCell) sp[9];
u13 = (UCell) sp[8];
u14 = (UCell) sp[7];
u15 = (UCell) sp[6];
u16 = (UCell) sp[5];
u17 = (UCell) sp[4];
u18 = (UCell) sp[3];
u19 = (UCell) sp[2];
u20 = (UCell) sp[1];
u = (UCell) TOS;
sp += 21;
fp += -1;
{
#line 2192 "/a5/anton/gforth/prim"
rret = (SYSCALL(Float(*)(Cell, Cell, Cell, Cell, Cell, Cell, Cell, Cell, Cell, Cell, Cell, Cell, Cell, Cell, Cell, Cell, Cell, Cell, Cell, Cell))u)(u1, u2, u3, u4, u5, u6, u7, u8, u9, u10, u11, u12, u13, u14, u15, u16, u17, u18, u19, u20);
#line 2192
}
NEXT_P1;
FTOS = rret;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

#endif
I_up_store:	/* up! ( a_addr -- ) */
/*  */
NAME("up!")
{
DEF_CA
Cell * a_addr;
NEXT_P0;
a_addr = (Cell *) TOS;
sp += 1;
{
#line 2197 "/a5/anton/gforth/prim"
UP=up=(char *)a_addr;
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_wcall:	/* wcall ( u -- ) */
/*  */
NAME("wcall")
{
DEF_CA
UCell u;
NEXT_P0;
u = (UCell) TOS;
sp += 1;
{
#line 2203 "/a5/anton/gforth/prim"
IF_FTOS(fp[0]=FTOS);
FP=fp;
sp=(SYSCALL(Cell(*)(Cell *, void *))u)(sp, &FP);
fp=FP;
IF_TOS(TOS=sp[0];)
IF_FTOS(FTOS=fp[0]);
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

#ifdef HAS_FILE
I_open_dir:	/* open-dir ( c_addr u -- wdirid wior ) */
/*  */
NAME("open-dir")
{
DEF_CA
Char * c_addr;
UCell u;
Cell wdirid;
Cell wior;
NEXT_P0;
c_addr = (Char *) sp[1];
u = (UCell) TOS;
{
#line 2213 "/a5/anton/gforth/prim"
wdirid = (Cell)opendir(tilde_cstr(c_addr, u, 1));
wior =  IOR(wdirid == 0);
}
NEXT_P1;
sp[1] = (Cell)wdirid;
TOS = (Cell)wior;
NEXT_P2;
}

I_read_dir:	/* read-dir ( c_addr u1 wdirid -- u2 flag wior ) */
/*  */
NAME("read-dir")
{
DEF_CA
Char * c_addr;
UCell u1;
Cell wdirid;
UCell u2;
Bool flag;
Cell wior;
NEXT_P0;
c_addr = (Char *) sp[2];
u1 = (UCell) sp[1];
wdirid = (Cell) TOS;
{
#line 2217 "/a5/anton/gforth/prim"
struct dirent * dent;
dent = readdir((DIR *)wdirid);
wior = 0;
flag = -1;
if(dent == NULL) {
  u2 = 0;
  flag = 0;
} else {
  u2 = strlen(dent->d_name);
  if(u2 > u1)
    u2 = u1;
  memmove(c_addr, dent->d_name, u2);
}
}
NEXT_P1;
sp[2] = (Cell)u2;
sp[1] = (Cell)flag;
TOS = (Cell)wior;
NEXT_P2;
}

I_close_dir:	/* close-dir ( wdirid -- wior ) */
/*  */
NAME("close-dir")
{
DEF_CA
Cell wdirid;
Cell wior;
NEXT_P0;
wdirid = (Cell) TOS;
{
#line 2232 "/a5/anton/gforth/prim"
wior = IOR(closedir((DIR *)wdirid));
}
NEXT_P1;
TOS = (Cell)wior;
NEXT_P2;
}

I_match_file:	/* filename-match ( c_addr1 u1 c_addr2 u2 -- flag ) */
/*  */
NAME("filename-match")
{
DEF_CA
Char * c_addr1;
UCell u1;
Char * c_addr2;
UCell u2;
Bool flag;
NEXT_P0;
c_addr1 = (Char *) sp[3];
u1 = (UCell) sp[2];
c_addr2 = (Char *) sp[1];
u2 = (UCell) TOS;
sp += 3;
{
#line 2235 "/a5/anton/gforth/prim"
char * string = cstr(c_addr1, u1, 1);
char * pattern = cstr(c_addr2, u2, 0);
flag = FLAG(!fnmatch(pattern, string, 0));
}
NEXT_P1;
TOS = (Cell)flag;
NEXT_P2;
}

#endif
I_newline:	/* newline ( -- c_addr u ) */
/* String containing the newline sequence of the host OS */
NAME("newline")
{
DEF_CA
Char * c_addr;
UCell u;
NEXT_P0;
IF_TOS(sp[0] = TOS);
sp += -2;
{
#line 2243 "/a5/anton/gforth/prim"
char newline[] = {
#ifdef unix
'\n'
#else
'\r','\n'
#endif
};
c_addr=newline;
u=sizeof(newline);
}
NEXT_P1;
sp[1] = (Cell)c_addr;
TOS = (Cell)u;
NEXT_P2;
}

