/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 3.0.9
 *
 * This file is not intended to be easily readable and contains a number of
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG
 * interface file instead.
 * ----------------------------------------------------------------------------- */
#include <stdio.h>
#include <string.h>
#include <stddef.h>
#include <math.h> /* required for special case floating point output */

// Do not edit below this line
// end-of-default-includes


#include <X11/extensions/Xrandr.h>
#define _EVDEVK(x) x

typedef enum{ NONE = -1, GFORTH = 0, SWIFTFORTH, VFX } SwigTargetSystem;
SwigTargetSystem swigTargetSystem = NONE;

unsigned char swigPrintStackComments = 1;

/* comments */
void swigNewline()
{
	printf( "\n" );
}

void swigComment( char *comment )
{
	printf( "\\ %s", comment );
}

/* generic print */
void swigPrint( char* gforth, char *swiftForth, char *vfx )
{
	if( swigTargetSystem == GFORTH )
		printf( "%s", gforth );
	else if( swigTargetSystem == SWIFTFORTH )
		printf( "%s", swiftForth );
	else if( swigTargetSystem == VFX )
		printf( "%s", vfx );
	printf( "\n" );
}
void swigPrintSystem( SwigTargetSystem targetSystem, char *text )
{
	if( targetSystem == swigTargetSystem )
	    printf( "%s\n", text );
}

/* constants */
void swigIntConstant( long constant, char *name )
{
	printf( "#%ld\tconstant %s\n", constant, name );
}

void swigUnsignedIntConstant( unsigned long constant, char *name )
{
	printf( "#%lu\tconstant %s\n", constant, name );
}

void swigLongConstant( long long constant, char *name )
{
	printf( "#%lld.\t2constant %s\n", constant, name );
}

void swigUnsignedLongConstant( unsigned long long constant, char *name )
{
	printf( "#%llu.\t2constant %s\n", constant, name );
}

void swigFloatConstant( double constant, char *name )
{
	char buffer[128];
	sprintf( buffer, "%f", constant );

	/* if the constant contains no exponent, add one */
	char *s;
	for( s = buffer; *s != 0; s++ )
		if( *s == 'e' || *s == 'E' )
			break;

	/* exponent found */
	if( *s != 0 )
		printf( "%s\tfconstant %s\n", buffer, name );
	/* no exponent */
	else {
		/* special class? */
		int class = fpclassify( constant );
		if( class == FP_INFINITE )
			printf( "%sInf\tfconstant %s\n", constant < 0.0f ? "-" : "+", name );
		else if( class == FP_NAN )
			printf( "NaN\tfconstant %s\n", name );
		else
			/* treat as generic float */
			printf( "%se0\tfconstant %s\n", buffer, name );
        }
}

void swigStringConstant( char* constant, char *name )
{
	char c;
	printf( ": %s s\\\" ", name );
	while(( c = *constant++ ))
	{
		switch(c)
		{
			case '\b': printf( "\\b" ); break;
			case '\n': printf( "\\n" ); break;
			case '\f': printf( "\\f" ); break;
			case '\r': printf( "\\r" ); break;
			case '\t': printf( "\\t" ); break;
			case '"' : printf( "\\q" ); break;
			default:
				if(c < 0x20)
					printf("\\x%02x", c);
				else
					printf("%c", c); break;
		}
	}
	printf(	"\" ;\n" );
}

/* structs */
void swigStructField( char *name, size_t offset, size_t size )
{
	printf( "\tdrop %zu %zu +field %s\n", offset, size, name );
}

/* functions */
void swigFunction( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	if( swigTargetSystem == GFORTH )
		printf( "%s", gforth );
	else if( swigTargetSystem == SWIFTFORTH )
		printf( "%s", swiftForth );
	else if( swigTargetSystem == VFX )
		printf( "%s", vfx );

	if( swigPrintStackComments )
		printf( "%s", stackComment );

	printf( "\n" );
}

/* function pointers */
void swigFunctionPointer( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	swigFunction( gforth, swiftForth, vfx, stackComment );
}

/* callbacks */
void swigCallback( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	swigFunction( gforth, swiftForth, vfx, stackComment );
}

void swigUsage( char **argv )
{
	fprintf( stderr, "Usage: %s [-gforth|-swiftforth|-vfx]\n", argv[0] );
}

int main( int argc, char **argv )
{
	int i;

	/* check arguments */
	for( i = 1; i < argc; i++ )
		if( strcmp( argv[i], "-gforth" ) == 0 )
			swigTargetSystem = GFORTH;
		else if( strcmp( argv[i], "-swiftforth" ) == 0 )
			swigTargetSystem = SWIFTFORTH;
		else if( strcmp( argv[i], "-vfx" ) == 0 )
			swigTargetSystem = VFX;

	if( swigTargetSystem == NONE )
	{
		fprintf( stderr, "Error: no target system specified\n" );
		swigUsage( argv );
		return 1;
	}

	/* primer */
	printf( "\\ This file has been generated using SWIG and fsi,\n"
		"\\ and is already platform dependent, search for the corresponding\n"
		"\\ fsi-file to compile it where no one has compiled it before ;)\n"
		"\\ Forth systems have their own own dynamic loader and don't need addional C-Code.\n"
		"\\ That's why this file will just print normal forth-code once compiled\n"
		"\\ and can be used directly with include or require.\n"
		"\\ As all comments are stripped during the compilation, please\n"
		"\\ insert the copyright notice of the original file here.\n"
	);



	swigNewline();

	swigComment("----===< prefix >===-----\n");

	swigPrint( "c-library xrandr\ns\" Xrandr\" add-lib\n\\c #include <X11/extensions/Xrandr.h>\n\\c #define _EVDEVK(x) x", "( none )", "( none )" );

	swigNewline();

	swigComment("-------===< structs >===--------\n");

	swigComment("XRRScreenSize\n");
	printf( "begin-structure XRRScreenSize\n" );
	swigStructField( "XRRScreenSize-mheight", offsetof( XRRScreenSize, mheight ), sizeof( int ) );
	swigStructField( "XRRScreenSize-height", offsetof( XRRScreenSize, height ), sizeof( int ) );
	swigStructField( "XRRScreenSize-mwidth", offsetof( XRRScreenSize, mwidth ), sizeof( int ) );
	swigStructField( "XRRScreenSize-width", offsetof( XRRScreenSize, width ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( XRRScreenSize ) );

	swigComment("XRRScreenChangeNotifyEvent\n");
	printf( "begin-structure XRRScreenChangeNotifyEvent\n" );
	swigStructField( "XRRScreenChangeNotifyEvent-window", offsetof( XRRScreenChangeNotifyEvent, window ), sizeof( Window ) );
	swigStructField( "XRRScreenChangeNotifyEvent-serial", offsetof( XRRScreenChangeNotifyEvent, serial ), sizeof( unsigned long ) );
	swigStructField( "XRRScreenChangeNotifyEvent-rotation", offsetof( XRRScreenChangeNotifyEvent, rotation ), sizeof( Rotation ) );
	swigStructField( "XRRScreenChangeNotifyEvent-height", offsetof( XRRScreenChangeNotifyEvent, height ), sizeof( int ) );
	swigStructField( "XRRScreenChangeNotifyEvent-root", offsetof( XRRScreenChangeNotifyEvent, root ), sizeof( Window ) );
	swigStructField( "XRRScreenChangeNotifyEvent-mheight", offsetof( XRRScreenChangeNotifyEvent, mheight ), sizeof( int ) );
	swigStructField( "XRRScreenChangeNotifyEvent-display", offsetof( XRRScreenChangeNotifyEvent, display ), sizeof( Display * ) );
	swigStructField( "XRRScreenChangeNotifyEvent-width", offsetof( XRRScreenChangeNotifyEvent, width ), sizeof( int ) );
	swigStructField( "XRRScreenChangeNotifyEvent-size_index", offsetof( XRRScreenChangeNotifyEvent, size_index ), sizeof( SizeID ) );
	swigStructField( "XRRScreenChangeNotifyEvent-type", offsetof( XRRScreenChangeNotifyEvent, type ), sizeof( int ) );
	swigStructField( "XRRScreenChangeNotifyEvent-config_timestamp", offsetof( XRRScreenChangeNotifyEvent, config_timestamp ), sizeof( Time ) );
	swigStructField( "XRRScreenChangeNotifyEvent-timestamp", offsetof( XRRScreenChangeNotifyEvent, timestamp ), sizeof( Time ) );
	swigStructField( "XRRScreenChangeNotifyEvent-send_event", offsetof( XRRScreenChangeNotifyEvent, send_event ), sizeof( Bool ) );
	swigStructField( "XRRScreenChangeNotifyEvent-subpixel_order", offsetof( XRRScreenChangeNotifyEvent, subpixel_order ), sizeof( SubpixelOrder ) );
	swigStructField( "XRRScreenChangeNotifyEvent-mwidth", offsetof( XRRScreenChangeNotifyEvent, mwidth ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( XRRScreenChangeNotifyEvent ) );

	swigComment("XRRNotifyEvent\n");
	printf( "begin-structure XRRNotifyEvent\n" );
	swigStructField( "XRRNotifyEvent-display", offsetof( XRRNotifyEvent, display ), sizeof( Display * ) );
	swigStructField( "XRRNotifyEvent-serial", offsetof( XRRNotifyEvent, serial ), sizeof( unsigned long ) );
	swigStructField( "XRRNotifyEvent-window", offsetof( XRRNotifyEvent, window ), sizeof( Window ) );
	swigStructField( "XRRNotifyEvent-type", offsetof( XRRNotifyEvent, type ), sizeof( int ) );
	swigStructField( "XRRNotifyEvent-subtype", offsetof( XRRNotifyEvent, subtype ), sizeof( int ) );
	swigStructField( "XRRNotifyEvent-send_event", offsetof( XRRNotifyEvent, send_event ), sizeof( Bool ) );
	printf( "drop %zu end-structure\n", sizeof( XRRNotifyEvent ) );

	swigComment("XRROutputChangeNotifyEvent\n");
	printf( "begin-structure XRROutputChangeNotifyEvent\n" );
	swigStructField( "XRROutputChangeNotifyEvent-display", offsetof( XRROutputChangeNotifyEvent, display ), sizeof( Display * ) );
	swigStructField( "XRROutputChangeNotifyEvent-crtc", offsetof( XRROutputChangeNotifyEvent, crtc ), sizeof( RRCrtc ) );
	swigStructField( "XRROutputChangeNotifyEvent-subpixel_order", offsetof( XRROutputChangeNotifyEvent, subpixel_order ), sizeof( SubpixelOrder ) );
	swigStructField( "XRROutputChangeNotifyEvent-output", offsetof( XRROutputChangeNotifyEvent, output ), sizeof( RROutput ) );
	swigStructField( "XRROutputChangeNotifyEvent-serial", offsetof( XRROutputChangeNotifyEvent, serial ), sizeof( unsigned long ) );
	swigStructField( "XRROutputChangeNotifyEvent-window", offsetof( XRROutputChangeNotifyEvent, window ), sizeof( Window ) );
	swigStructField( "XRROutputChangeNotifyEvent-type", offsetof( XRROutputChangeNotifyEvent, type ), sizeof( int ) );
	swigStructField( "XRROutputChangeNotifyEvent-subtype", offsetof( XRROutputChangeNotifyEvent, subtype ), sizeof( int ) );
	swigStructField( "XRROutputChangeNotifyEvent-send_event", offsetof( XRROutputChangeNotifyEvent, send_event ), sizeof( Bool ) );
	swigStructField( "XRROutputChangeNotifyEvent-mode", offsetof( XRROutputChangeNotifyEvent, mode ), sizeof( RRMode ) );
	swigStructField( "XRROutputChangeNotifyEvent-rotation", offsetof( XRROutputChangeNotifyEvent, rotation ), sizeof( Rotation ) );
	swigStructField( "XRROutputChangeNotifyEvent-connection", offsetof( XRROutputChangeNotifyEvent, connection ), sizeof( Connection ) );
	printf( "drop %zu end-structure\n", sizeof( XRROutputChangeNotifyEvent ) );

	swigComment("XRRCrtcChangeNotifyEvent\n");
	printf( "begin-structure XRRCrtcChangeNotifyEvent\n" );
	swigStructField( "XRRCrtcChangeNotifyEvent-display", offsetof( XRRCrtcChangeNotifyEvent, display ), sizeof( Display * ) );
	swigStructField( "XRRCrtcChangeNotifyEvent-crtc", offsetof( XRRCrtcChangeNotifyEvent, crtc ), sizeof( RRCrtc ) );
	swigStructField( "XRRCrtcChangeNotifyEvent-x", offsetof( XRRCrtcChangeNotifyEvent, x ), sizeof( int ) );
	swigStructField( "XRRCrtcChangeNotifyEvent-y", offsetof( XRRCrtcChangeNotifyEvent, y ), sizeof( int ) );
	swigStructField( "XRRCrtcChangeNotifyEvent-serial", offsetof( XRRCrtcChangeNotifyEvent, serial ), sizeof( unsigned long ) );
	swigStructField( "XRRCrtcChangeNotifyEvent-window", offsetof( XRRCrtcChangeNotifyEvent, window ), sizeof( Window ) );
	swigStructField( "XRRCrtcChangeNotifyEvent-type", offsetof( XRRCrtcChangeNotifyEvent, type ), sizeof( int ) );
	swigStructField( "XRRCrtcChangeNotifyEvent-subtype", offsetof( XRRCrtcChangeNotifyEvent, subtype ), sizeof( int ) );
	swigStructField( "XRRCrtcChangeNotifyEvent-height", offsetof( XRRCrtcChangeNotifyEvent, height ), sizeof( unsigned int ) );
	swigStructField( "XRRCrtcChangeNotifyEvent-send_event", offsetof( XRRCrtcChangeNotifyEvent, send_event ), sizeof( Bool ) );
	swigStructField( "XRRCrtcChangeNotifyEvent-width", offsetof( XRRCrtcChangeNotifyEvent, width ), sizeof( unsigned int ) );
	swigStructField( "XRRCrtcChangeNotifyEvent-mode", offsetof( XRRCrtcChangeNotifyEvent, mode ), sizeof( RRMode ) );
	swigStructField( "XRRCrtcChangeNotifyEvent-rotation", offsetof( XRRCrtcChangeNotifyEvent, rotation ), sizeof( Rotation ) );
	printf( "drop %zu end-structure\n", sizeof( XRRCrtcChangeNotifyEvent ) );

	swigComment("XRROutputPropertyNotifyEvent\n");
	printf( "begin-structure XRROutputPropertyNotifyEvent\n" );
	swigStructField( "XRROutputPropertyNotifyEvent-display", offsetof( XRROutputPropertyNotifyEvent, display ), sizeof( Display * ) );
	swigStructField( "XRROutputPropertyNotifyEvent-property", offsetof( XRROutputPropertyNotifyEvent, property ), sizeof( Atom ) );
	swigStructField( "XRROutputPropertyNotifyEvent-output", offsetof( XRROutputPropertyNotifyEvent, output ), sizeof( RROutput ) );
	swigStructField( "XRROutputPropertyNotifyEvent-serial", offsetof( XRROutputPropertyNotifyEvent, serial ), sizeof( unsigned long ) );
	swigStructField( "XRROutputPropertyNotifyEvent-window", offsetof( XRROutputPropertyNotifyEvent, window ), sizeof( Window ) );
	swigStructField( "XRROutputPropertyNotifyEvent-type", offsetof( XRROutputPropertyNotifyEvent, type ), sizeof( int ) );
	swigStructField( "XRROutputPropertyNotifyEvent-subtype", offsetof( XRROutputPropertyNotifyEvent, subtype ), sizeof( int ) );
	swigStructField( "XRROutputPropertyNotifyEvent-send_event", offsetof( XRROutputPropertyNotifyEvent, send_event ), sizeof( Bool ) );
	swigStructField( "XRROutputPropertyNotifyEvent-timestamp", offsetof( XRROutputPropertyNotifyEvent, timestamp ), sizeof( Time ) );
	swigStructField( "XRROutputPropertyNotifyEvent-state", offsetof( XRROutputPropertyNotifyEvent, state ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( XRROutputPropertyNotifyEvent ) );

	swigComment("XRRProviderChangeNotifyEvent\n");
	printf( "begin-structure XRRProviderChangeNotifyEvent\n" );
	swigStructField( "XRRProviderChangeNotifyEvent-display", offsetof( XRRProviderChangeNotifyEvent, display ), sizeof( Display * ) );
	swigStructField( "XRRProviderChangeNotifyEvent-current_role", offsetof( XRRProviderChangeNotifyEvent, current_role ), sizeof( unsigned int ) );
	swigStructField( "XRRProviderChangeNotifyEvent-serial", offsetof( XRRProviderChangeNotifyEvent, serial ), sizeof( unsigned long ) );
	swigStructField( "XRRProviderChangeNotifyEvent-window", offsetof( XRRProviderChangeNotifyEvent, window ), sizeof( Window ) );
	swigStructField( "XRRProviderChangeNotifyEvent-provider", offsetof( XRRProviderChangeNotifyEvent, provider ), sizeof( RRProvider ) );
	swigStructField( "XRRProviderChangeNotifyEvent-type", offsetof( XRRProviderChangeNotifyEvent, type ), sizeof( int ) );
	swigStructField( "XRRProviderChangeNotifyEvent-subtype", offsetof( XRRProviderChangeNotifyEvent, subtype ), sizeof( int ) );
	swigStructField( "XRRProviderChangeNotifyEvent-send_event", offsetof( XRRProviderChangeNotifyEvent, send_event ), sizeof( Bool ) );
	swigStructField( "XRRProviderChangeNotifyEvent-timestamp", offsetof( XRRProviderChangeNotifyEvent, timestamp ), sizeof( Time ) );
	printf( "drop %zu end-structure\n", sizeof( XRRProviderChangeNotifyEvent ) );

	swigComment("XRRProviderPropertyNotifyEvent\n");
	printf( "begin-structure XRRProviderPropertyNotifyEvent\n" );
	swigStructField( "XRRProviderPropertyNotifyEvent-display", offsetof( XRRProviderPropertyNotifyEvent, display ), sizeof( Display * ) );
	swigStructField( "XRRProviderPropertyNotifyEvent-property", offsetof( XRRProviderPropertyNotifyEvent, property ), sizeof( Atom ) );
	swigStructField( "XRRProviderPropertyNotifyEvent-serial", offsetof( XRRProviderPropertyNotifyEvent, serial ), sizeof( unsigned long ) );
	swigStructField( "XRRProviderPropertyNotifyEvent-window", offsetof( XRRProviderPropertyNotifyEvent, window ), sizeof( Window ) );
	swigStructField( "XRRProviderPropertyNotifyEvent-provider", offsetof( XRRProviderPropertyNotifyEvent, provider ), sizeof( RRProvider ) );
	swigStructField( "XRRProviderPropertyNotifyEvent-type", offsetof( XRRProviderPropertyNotifyEvent, type ), sizeof( int ) );
	swigStructField( "XRRProviderPropertyNotifyEvent-subtype", offsetof( XRRProviderPropertyNotifyEvent, subtype ), sizeof( int ) );
	swigStructField( "XRRProviderPropertyNotifyEvent-send_event", offsetof( XRRProviderPropertyNotifyEvent, send_event ), sizeof( Bool ) );
	swigStructField( "XRRProviderPropertyNotifyEvent-timestamp", offsetof( XRRProviderPropertyNotifyEvent, timestamp ), sizeof( Time ) );
	swigStructField( "XRRProviderPropertyNotifyEvent-state", offsetof( XRRProviderPropertyNotifyEvent, state ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( XRRProviderPropertyNotifyEvent ) );

	swigComment("XRRResourceChangeNotifyEvent\n");
	printf( "begin-structure XRRResourceChangeNotifyEvent\n" );
	swigStructField( "XRRResourceChangeNotifyEvent-display", offsetof( XRRResourceChangeNotifyEvent, display ), sizeof( Display * ) );
	swigStructField( "XRRResourceChangeNotifyEvent-serial", offsetof( XRRResourceChangeNotifyEvent, serial ), sizeof( unsigned long ) );
	swigStructField( "XRRResourceChangeNotifyEvent-window", offsetof( XRRResourceChangeNotifyEvent, window ), sizeof( Window ) );
	swigStructField( "XRRResourceChangeNotifyEvent-type", offsetof( XRRResourceChangeNotifyEvent, type ), sizeof( int ) );
	swigStructField( "XRRResourceChangeNotifyEvent-subtype", offsetof( XRRResourceChangeNotifyEvent, subtype ), sizeof( int ) );
	swigStructField( "XRRResourceChangeNotifyEvent-send_event", offsetof( XRRResourceChangeNotifyEvent, send_event ), sizeof( Bool ) );
	swigStructField( "XRRResourceChangeNotifyEvent-timestamp", offsetof( XRRResourceChangeNotifyEvent, timestamp ), sizeof( Time ) );
	printf( "drop %zu end-structure\n", sizeof( XRRResourceChangeNotifyEvent ) );

	swigComment("XRRModeInfo\n");
	printf( "begin-structure XRRModeInfo\n" );
	swigStructField( "XRRModeInfo-vSyncEnd", offsetof( XRRModeInfo, vSyncEnd ), sizeof( unsigned int ) );
	swigStructField( "XRRModeInfo-hSyncEnd", offsetof( XRRModeInfo, hSyncEnd ), sizeof( unsigned int ) );
	swigStructField( "XRRModeInfo-hSkew", offsetof( XRRModeInfo, hSkew ), sizeof( unsigned int ) );
	swigStructField( "XRRModeInfo-nameLength", offsetof( XRRModeInfo, nameLength ), sizeof( unsigned int ) );
	swigStructField( "XRRModeInfo-height", offsetof( XRRModeInfo, height ), sizeof( unsigned int ) );
	swigStructField( "XRRModeInfo-name", offsetof( XRRModeInfo, name ), sizeof( char * ) );
	swigStructField( "XRRModeInfo-dotClock", offsetof( XRRModeInfo, dotClock ), sizeof( unsigned long ) );
	swigStructField( "XRRModeInfo-vTotal", offsetof( XRRModeInfo, vTotal ), sizeof( unsigned int ) );
	swigStructField( "XRRModeInfo-id", offsetof( XRRModeInfo, id ), sizeof( RRMode ) );
	swigStructField( "XRRModeInfo-width", offsetof( XRRModeInfo, width ), sizeof( unsigned int ) );
	swigStructField( "XRRModeInfo-hTotal", offsetof( XRRModeInfo, hTotal ), sizeof( unsigned int ) );
	swigStructField( "XRRModeInfo-vSyncStart", offsetof( XRRModeInfo, vSyncStart ), sizeof( unsigned int ) );
	swigStructField( "XRRModeInfo-hSyncStart", offsetof( XRRModeInfo, hSyncStart ), sizeof( unsigned int ) );
	swigStructField( "XRRModeInfo-modeFlags", offsetof( XRRModeInfo, modeFlags ), sizeof( XRRModeFlags ) );
	printf( "drop %zu end-structure\n", sizeof( XRRModeInfo ) );

	swigComment("XRRScreenResources\n");
	printf( "begin-structure XRRScreenResources\n" );
	swigStructField( "XRRScreenResources-ncrtc", offsetof( XRRScreenResources, ncrtc ), sizeof( int ) );
	swigStructField( "XRRScreenResources-crtcs", offsetof( XRRScreenResources, crtcs ), sizeof( RRCrtc * ) );
	swigStructField( "XRRScreenResources-noutput", offsetof( XRRScreenResources, noutput ), sizeof( int ) );
	swigStructField( "XRRScreenResources-outputs", offsetof( XRRScreenResources, outputs ), sizeof( RROutput * ) );
	swigStructField( "XRRScreenResources-timestamp", offsetof( XRRScreenResources, timestamp ), sizeof( Time ) );
	swigStructField( "XRRScreenResources-configTimestamp", offsetof( XRRScreenResources, configTimestamp ), sizeof( Time ) );
	swigStructField( "XRRScreenResources-nmode", offsetof( XRRScreenResources, nmode ), sizeof( int ) );
	swigStructField( "XRRScreenResources-modes", offsetof( XRRScreenResources, modes ), sizeof( XRRModeInfo * ) );
	printf( "drop %zu end-structure\n", sizeof( XRRScreenResources ) );

	swigComment("XRROutputInfo\n");
	printf( "begin-structure XRROutputInfo\n" );
	swigStructField( "XRROutputInfo-connection", offsetof( XRROutputInfo, connection ), sizeof( Connection ) );
	swigStructField( "XRROutputInfo-name", offsetof( XRROutputInfo, name ), sizeof( char * ) );
	swigStructField( "XRROutputInfo-clones", offsetof( XRROutputInfo, clones ), sizeof( RROutput * ) );
	swigStructField( "XRROutputInfo-mm_height", offsetof( XRROutputInfo, mm_height ), sizeof( unsigned long ) );
	swigStructField( "XRROutputInfo-nameLen", offsetof( XRROutputInfo, nameLen ), sizeof( int ) );
	swigStructField( "XRROutputInfo-crtc", offsetof( XRROutputInfo, crtc ), sizeof( RRCrtc ) );
	swigStructField( "XRROutputInfo-mm_width", offsetof( XRROutputInfo, mm_width ), sizeof( unsigned long ) );
	swigStructField( "XRROutputInfo-nmode", offsetof( XRROutputInfo, nmode ), sizeof( int ) );
	swigStructField( "XRROutputInfo-modes", offsetof( XRROutputInfo, modes ), sizeof( RRMode * ) );
	swigStructField( "XRROutputInfo-timestamp", offsetof( XRROutputInfo, timestamp ), sizeof( Time ) );
	swigStructField( "XRROutputInfo-subpixel_order", offsetof( XRROutputInfo, subpixel_order ), sizeof( SubpixelOrder ) );
	swigStructField( "XRROutputInfo-nclone", offsetof( XRROutputInfo, nclone ), sizeof( int ) );
	swigStructField( "XRROutputInfo-npreferred", offsetof( XRROutputInfo, npreferred ), sizeof( int ) );
	swigStructField( "XRROutputInfo-crtcs", offsetof( XRROutputInfo, crtcs ), sizeof( RRCrtc * ) );
	swigStructField( "XRROutputInfo-ncrtc", offsetof( XRROutputInfo, ncrtc ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( XRROutputInfo ) );

	swigComment("XRRPropertyInfo\n");
	printf( "begin-structure XRRPropertyInfo\n" );
	swigStructField( "XRRPropertyInfo-pending", offsetof( XRRPropertyInfo, pending ), sizeof( Bool ) );
	swigStructField( "XRRPropertyInfo-immutable", offsetof( XRRPropertyInfo, immutable ), sizeof( Bool ) );
	swigStructField( "XRRPropertyInfo-range", offsetof( XRRPropertyInfo, range ), sizeof( Bool ) );
	swigStructField( "XRRPropertyInfo-num_values", offsetof( XRRPropertyInfo, num_values ), sizeof( int ) );
	swigStructField( "XRRPropertyInfo-values", offsetof( XRRPropertyInfo, values ), sizeof( long * ) );
	printf( "drop %zu end-structure\n", sizeof( XRRPropertyInfo ) );

	swigComment("XRRCrtcInfo\n");
	printf( "begin-structure XRRCrtcInfo\n" );
	swigStructField( "XRRCrtcInfo-x", offsetof( XRRCrtcInfo, x ), sizeof( int ) );
	swigStructField( "XRRCrtcInfo-y", offsetof( XRRCrtcInfo, y ), sizeof( int ) );
	swigStructField( "XRRCrtcInfo-noutput", offsetof( XRRCrtcInfo, noutput ), sizeof( int ) );
	swigStructField( "XRRCrtcInfo-npossible", offsetof( XRRCrtcInfo, npossible ), sizeof( int ) );
	swigStructField( "XRRCrtcInfo-possible", offsetof( XRRCrtcInfo, possible ), sizeof( RROutput * ) );
	swigStructField( "XRRCrtcInfo-outputs", offsetof( XRRCrtcInfo, outputs ), sizeof( RROutput * ) );
	swigStructField( "XRRCrtcInfo-height", offsetof( XRRCrtcInfo, height ), sizeof( unsigned int ) );
	swigStructField( "XRRCrtcInfo-timestamp", offsetof( XRRCrtcInfo, timestamp ), sizeof( Time ) );
	swigStructField( "XRRCrtcInfo-width", offsetof( XRRCrtcInfo, width ), sizeof( unsigned int ) );
	swigStructField( "XRRCrtcInfo-rotations", offsetof( XRRCrtcInfo, rotations ), sizeof( Rotation ) );
	swigStructField( "XRRCrtcInfo-mode", offsetof( XRRCrtcInfo, mode ), sizeof( RRMode ) );
	swigStructField( "XRRCrtcInfo-rotation", offsetof( XRRCrtcInfo, rotation ), sizeof( Rotation ) );
	printf( "drop %zu end-structure\n", sizeof( XRRCrtcInfo ) );

	swigComment("XRRCrtcGamma\n");
	printf( "begin-structure XRRCrtcGamma\n" );
	swigStructField( "XRRCrtcGamma-blue", offsetof( XRRCrtcGamma, blue ), sizeof( unsigned short * ) );
	swigStructField( "XRRCrtcGamma-green", offsetof( XRRCrtcGamma, green ), sizeof( unsigned short * ) );
	swigStructField( "XRRCrtcGamma-size", offsetof( XRRCrtcGamma, size ), sizeof( int ) );
	swigStructField( "XRRCrtcGamma-red", offsetof( XRRCrtcGamma, red ), sizeof( unsigned short * ) );
	printf( "drop %zu end-structure\n", sizeof( XRRCrtcGamma ) );

	swigComment("XRRCrtcTransformAttributes\n");
	printf( "begin-structure XRRCrtcTransformAttributes\n" );
	swigStructField( "XRRCrtcTransformAttributes-currentFilter", offsetof( XRRCrtcTransformAttributes, currentFilter ), sizeof( char * ) );
	swigStructField( "XRRCrtcTransformAttributes-pendingFilter", offsetof( XRRCrtcTransformAttributes, pendingFilter ), sizeof( char * ) );
	swigStructField( "XRRCrtcTransformAttributes-pendingTransform", offsetof( XRRCrtcTransformAttributes, pendingTransform ), sizeof( XTransform ) );
	swigStructField( "XRRCrtcTransformAttributes-currentTransform", offsetof( XRRCrtcTransformAttributes, currentTransform ), sizeof( XTransform ) );
	swigStructField( "XRRCrtcTransformAttributes-currentParams", offsetof( XRRCrtcTransformAttributes, currentParams ), sizeof( XFixed * ) );
	swigStructField( "XRRCrtcTransformAttributes-pendingNparams", offsetof( XRRCrtcTransformAttributes, pendingNparams ), sizeof( int ) );
	swigStructField( "XRRCrtcTransformAttributes-pendingParams", offsetof( XRRCrtcTransformAttributes, pendingParams ), sizeof( XFixed * ) );
	swigStructField( "XRRCrtcTransformAttributes-currentNparams", offsetof( XRRCrtcTransformAttributes, currentNparams ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( XRRCrtcTransformAttributes ) );

	swigComment("XRRPanning\n");
	printf( "begin-structure XRRPanning\n" );
	swigStructField( "XRRPanning-left", offsetof( XRRPanning, left ), sizeof( unsigned int ) );
	swigStructField( "XRRPanning-track_top", offsetof( XRRPanning, track_top ), sizeof( unsigned int ) );
	swigStructField( "XRRPanning-track_width", offsetof( XRRPanning, track_width ), sizeof( unsigned int ) );
	swigStructField( "XRRPanning-track_height", offsetof( XRRPanning, track_height ), sizeof( unsigned int ) );
	swigStructField( "XRRPanning-border_right", offsetof( XRRPanning, border_right ), sizeof( int ) );
	swigStructField( "XRRPanning-top", offsetof( XRRPanning, top ), sizeof( unsigned int ) );
	swigStructField( "XRRPanning-height", offsetof( XRRPanning, height ), sizeof( unsigned int ) );
	swigStructField( "XRRPanning-track_left", offsetof( XRRPanning, track_left ), sizeof( unsigned int ) );
	swigStructField( "XRRPanning-border_left", offsetof( XRRPanning, border_left ), sizeof( int ) );
	swigStructField( "XRRPanning-timestamp", offsetof( XRRPanning, timestamp ), sizeof( Time ) );
	swigStructField( "XRRPanning-width", offsetof( XRRPanning, width ), sizeof( unsigned int ) );
	swigStructField( "XRRPanning-border_bottom", offsetof( XRRPanning, border_bottom ), sizeof( int ) );
	swigStructField( "XRRPanning-border_top", offsetof( XRRPanning, border_top ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( XRRPanning ) );

	swigComment("XRRProviderResources\n");
	printf( "begin-structure XRRProviderResources\n" );
	swigStructField( "XRRProviderResources-nproviders", offsetof( XRRProviderResources, nproviders ), sizeof( int ) );
	swigStructField( "XRRProviderResources-providers", offsetof( XRRProviderResources, providers ), sizeof( RRProvider * ) );
	swigStructField( "XRRProviderResources-timestamp", offsetof( XRRProviderResources, timestamp ), sizeof( Time ) );
	printf( "drop %zu end-structure\n", sizeof( XRRProviderResources ) );

	swigComment("XRRProviderInfo\n");
	printf( "begin-structure XRRProviderInfo\n" );
	swigStructField( "XRRProviderInfo-crtcs", offsetof( XRRProviderInfo, crtcs ), sizeof( RRCrtc * ) );
	swigStructField( "XRRProviderInfo-nassociatedproviders", offsetof( XRRProviderInfo, nassociatedproviders ), sizeof( int ) );
	swigStructField( "XRRProviderInfo-associated_providers", offsetof( XRRProviderInfo, associated_providers ), sizeof( RRProvider * ) );
	swigStructField( "XRRProviderInfo-capabilities", offsetof( XRRProviderInfo, capabilities ), sizeof( unsigned int ) );
	swigStructField( "XRRProviderInfo-ncrtcs", offsetof( XRRProviderInfo, ncrtcs ), sizeof( int ) );
	swigStructField( "XRRProviderInfo-name", offsetof( XRRProviderInfo, name ), sizeof( char * ) );
	swigStructField( "XRRProviderInfo-nameLen", offsetof( XRRProviderInfo, nameLen ), sizeof( int ) );
	swigStructField( "XRRProviderInfo-noutputs", offsetof( XRRProviderInfo, noutputs ), sizeof( int ) );
	swigStructField( "XRRProviderInfo-outputs", offsetof( XRRProviderInfo, outputs ), sizeof( RROutput * ) );
	swigStructField( "XRRProviderInfo-associated_capability", offsetof( XRRProviderInfo, associated_capability ), sizeof( unsigned int * ) );
	printf( "drop %zu end-structure\n", sizeof( XRRProviderInfo ) );

	swigComment("XRRMonitorInfo\n");
	printf( "begin-structure XRRMonitorInfo\n" );
	swigStructField( "XRRMonitorInfo-primary", offsetof( XRRMonitorInfo, primary ), sizeof( Bool ) );
	swigStructField( "XRRMonitorInfo-name", offsetof( XRRMonitorInfo, name ), sizeof( Atom ) );
	swigStructField( "XRRMonitorInfo-x", offsetof( XRRMonitorInfo, x ), sizeof( int ) );
	swigStructField( "XRRMonitorInfo-noutput", offsetof( XRRMonitorInfo, noutput ), sizeof( int ) );
	swigStructField( "XRRMonitorInfo-y", offsetof( XRRMonitorInfo, y ), sizeof( int ) );
	swigStructField( "XRRMonitorInfo-mheight", offsetof( XRRMonitorInfo, mheight ), sizeof( int ) );
	swigStructField( "XRRMonitorInfo-outputs", offsetof( XRRMonitorInfo, outputs ), sizeof( RROutput * ) );
	swigStructField( "XRRMonitorInfo-height", offsetof( XRRMonitorInfo, height ), sizeof( int ) );
	swigStructField( "XRRMonitorInfo-mwidth", offsetof( XRRMonitorInfo, mwidth ), sizeof( int ) );
	swigStructField( "XRRMonitorInfo-width", offsetof( XRRMonitorInfo, width ), sizeof( int ) );
	swigStructField( "XRRMonitorInfo-automatic", offsetof( XRRMonitorInfo, automatic ), sizeof( Bool ) );
	printf( "drop %zu end-structure\n", sizeof( XRRMonitorInfo ) );

	swigNewline();

	swigComment("------===< functions >===-------\n");
	swigFunction( "c-function XRRQueryExtension XRRQueryExtension a a a -- n", "FUNCTION: XRRQueryExtension ( dpy event_base_return error_base_return -- n )", "EXTERN: \"C\" int XRRQueryExtension( void * dpy, void * event_base_return, void * error_base_return );", "	( dpy event_base_return error_base_return -- )" );
	swigFunction( "c-function XRRQueryVersion XRRQueryVersion a a a -- n", "FUNCTION: XRRQueryVersion ( dpy major_version_return minor_version_return -- n )", "EXTERN: \"C\" int XRRQueryVersion( void * dpy, void * major_version_return, void * minor_version_return );", "	( dpy major_version_return minor_version_return -- )" );
	swigFunction( "c-function XRRGetScreenInfo XRRGetScreenInfo a u -- a", "FUNCTION: XRRGetScreenInfo ( dpy window -- a )", "EXTERN: \"C\" void * XRRGetScreenInfo( void * dpy, int window );", "	( dpy window -- )" );
	swigFunction( "c-function XRRFreeScreenConfigInfo XRRFreeScreenConfigInfo a -- void", "FUNCTION: XRRFreeScreenConfigInfo ( config -- void )", "EXTERN: \"C\" void XRRFreeScreenConfigInfo( void * config );", "	( config -- )" );
	swigFunction( "c-function XRRSetScreenConfig XRRSetScreenConfig a a u n n u -- n", "FUNCTION: XRRSetScreenConfig ( dpy config draw size_index rotation timestamp -- n )", "EXTERN: \"C\" int XRRSetScreenConfig( void * dpy, void * config, int draw, int size_index, int rotation, int timestamp );", "	( dpy config draw size_index rotation timestamp -- )" );
	swigFunction( "c-function XRRSetScreenConfigAndRate XRRSetScreenConfigAndRate a a u n n n u -- n", "FUNCTION: XRRSetScreenConfigAndRate ( dpy config draw size_index rotation rate timestamp -- n )", "EXTERN: \"C\" int XRRSetScreenConfigAndRate( void * dpy, void * config, int draw, int size_index, int rotation, short rate, int timestamp );", "	( dpy config draw size_index rotation rate timestamp -- )" );
	swigFunction( "c-function XRRConfigRotations XRRConfigRotations a a -- n", "FUNCTION: XRRConfigRotations ( config current_rotation -- n )", "EXTERN: \"C\" int XRRConfigRotations( void * config, void * current_rotation );", "	( config current_rotation -- )" );
	swigFunction( "c-function XRRConfigTimes XRRConfigTimes a a -- u", "FUNCTION: XRRConfigTimes ( config config_timestamp -- u )", "EXTERN: \"C\" int XRRConfigTimes( void * config, void * config_timestamp );", "	( config config_timestamp -- )" );
	swigFunction( "c-function XRRConfigSizes XRRConfigSizes a a -- a", "FUNCTION: XRRConfigSizes ( config nsizes -- a )", "EXTERN: \"C\" void * XRRConfigSizes( void * config, void * nsizes );", "	( config nsizes -- )" );
	swigFunction( "c-function XRRConfigRates XRRConfigRates a n a -- a", "FUNCTION: XRRConfigRates ( config sizeID nrates -- a )", "EXTERN: \"C\" void * XRRConfigRates( void * config, int sizeID, void * nrates );", "	( config sizeID nrates -- )" );
	swigFunction( "c-function XRRConfigCurrentConfiguration XRRConfigCurrentConfiguration a a -- u", "FUNCTION: XRRConfigCurrentConfiguration ( config rotation -- u )", "EXTERN: \"C\" short XRRConfigCurrentConfiguration( void * config, void * rotation );", "	( config rotation -- )" );
	swigFunction( "c-function XRRConfigCurrentRate XRRConfigCurrentRate a -- n", "FUNCTION: XRRConfigCurrentRate ( config -- n )", "EXTERN: \"C\" short XRRConfigCurrentRate( void * config );", "	( config -- )" );
	swigFunction( "c-function XRRRootToScreen XRRRootToScreen a u -- n", "FUNCTION: XRRRootToScreen ( dpy root -- n )", "EXTERN: \"C\" int XRRRootToScreen( void * dpy, int root );", "	( dpy root -- )" );
	swigFunction( "c-function XRRSelectInput XRRSelectInput a u n -- void", "FUNCTION: XRRSelectInput ( dpy window mask -- void )", "EXTERN: \"C\" void XRRSelectInput( void * dpy, int window, int mask );", "	( dpy window mask -- )" );
	swigFunction( "c-function XRRRotations XRRRotations a n a -- n", "FUNCTION: XRRRotations ( dpy screen current_rotation -- n )", "EXTERN: \"C\" int XRRRotations( void * dpy, int screen, void * current_rotation );", "	( dpy screen current_rotation -- )" );
	swigFunction( "c-function XRRSizes XRRSizes a n a -- a", "FUNCTION: XRRSizes ( dpy screen nsizes -- a )", "EXTERN: \"C\" void * XRRSizes( void * dpy, int screen, void * nsizes );", "	( dpy screen nsizes -- )" );
	swigFunction( "c-function XRRRates XRRRates a n n a -- a", "FUNCTION: XRRRates ( dpy screen sizeID nrates -- a )", "EXTERN: \"C\" void * XRRRates( void * dpy, int screen, int sizeID, void * nrates );", "	( dpy screen sizeID nrates -- )" );
	swigFunction( "c-function XRRTimes XRRTimes a n a -- u", "FUNCTION: XRRTimes ( dpy screen config_timestamp -- u )", "EXTERN: \"C\" int XRRTimes( void * dpy, int screen, void * config_timestamp );", "	( dpy screen config_timestamp -- )" );
	swigFunction( "c-function XRRGetScreenSizeRange XRRGetScreenSizeRange a u a a a a -- n", "FUNCTION: XRRGetScreenSizeRange ( dpy window minWidth minHeight maxWidth maxHeight -- n )", "EXTERN: \"C\" int XRRGetScreenSizeRange( void * dpy, int window, void * minWidth, void * minHeight, void * maxWidth, void * maxHeight );", "	( dpy window minWidth minHeight maxWidth maxHeight -- )" );
	swigFunction( "c-function XRRSetScreenSize XRRSetScreenSize a u n n n n -- void", "FUNCTION: XRRSetScreenSize ( dpy window width height mmWidth mmHeight -- void )", "EXTERN: \"C\" void XRRSetScreenSize( void * dpy, int window, int width, int height, int mmWidth, int mmHeight );", "	( dpy window width height mmWidth mmHeight -- )" );
	swigFunction( "c-function XRRGetScreenResources XRRGetScreenResources a u -- a", "FUNCTION: XRRGetScreenResources ( dpy window -- a )", "EXTERN: \"C\" void * XRRGetScreenResources( void * dpy, int window );", "	( dpy window -- )" );
	swigFunction( "c-function XRRFreeScreenResources XRRFreeScreenResources a -- void", "FUNCTION: XRRFreeScreenResources ( resources -- void )", "EXTERN: \"C\" void XRRFreeScreenResources( void * resources );", "	( resources -- )" );
	swigFunction( "c-function XRRGetOutputInfo XRRGetOutputInfo a a u -- a", "FUNCTION: XRRGetOutputInfo ( dpy resources output -- a )", "EXTERN: \"C\" void * XRRGetOutputInfo( void * dpy, void * resources, int output );", "	( dpy resources output -- )" );
	swigFunction( "c-function XRRFreeOutputInfo XRRFreeOutputInfo a -- void", "FUNCTION: XRRFreeOutputInfo ( outputInfo -- void )", "EXTERN: \"C\" void XRRFreeOutputInfo( void * outputInfo );", "	( outputInfo -- )" );
	swigFunction( "c-function XRRListOutputProperties XRRListOutputProperties a u a -- a", "FUNCTION: XRRListOutputProperties ( dpy output nprop -- a )", "EXTERN: \"C\" void * XRRListOutputProperties( void * dpy, int output, void * nprop );", "	( dpy output nprop -- )" );
	swigFunction( "c-function XRRQueryOutputProperty XRRQueryOutputProperty a u u -- a", "FUNCTION: XRRQueryOutputProperty ( dpy output property -- a )", "EXTERN: \"C\" void * XRRQueryOutputProperty( void * dpy, int output, int property );", "	( dpy output property -- )" );
	swigFunction( "c-function XRRConfigureOutputProperty XRRConfigureOutputProperty a u u n n n a -- void", "FUNCTION: XRRConfigureOutputProperty ( dpy output property pending range num_values values -- void )", "EXTERN: \"C\" void XRRConfigureOutputProperty( void * dpy, int output, int property, int pending, int range, int num_values, void * values );", "	( dpy output property pending range num_values values -- )" );
	swigFunction( "c-function XRRChangeOutputProperty XRRChangeOutputProperty a u u u n n a n -- void", "FUNCTION: XRRChangeOutputProperty ( dpy output property type format mode data nelements -- void )", "EXTERN: \"C\" void XRRChangeOutputProperty( void * dpy, int output, int property, int type, int format, int mode, void * data, int nelements );", "	( dpy output property type format mode data nelements -- )" );
	swigFunction( "c-function XRRDeleteOutputProperty XRRDeleteOutputProperty a u u -- void", "FUNCTION: XRRDeleteOutputProperty ( dpy output property -- void )", "EXTERN: \"C\" void XRRDeleteOutputProperty( void * dpy, int output, int property );", "	( dpy output property -- )" );
	swigFunction( "c-function XRRGetOutputProperty XRRGetOutputProperty a u u n n n n u a a a a a -- n", "FUNCTION: XRRGetOutputProperty ( dpy output property offset length _delete pending req_type actual_type actual_format nitems bytes_after prop -- n )", "EXTERN: \"C\" int XRRGetOutputProperty( void * dpy, int output, int property, long offset, long length, int _delete, int pending, int req_type, void * actual_type, void * actual_format, void * nitems, void * bytes_after, void * prop );", "	( dpy output property offset length _delete pending req_type actual_type actual_format nitems bytes_after prop -- )" );
	swigFunction( "c-function XRRAllocModeInfo XRRAllocModeInfo s n -- a", "FUNCTION: XRRAllocModeInfo ( name nameLength -- a )", "EXTERN: \"C\" void * XRRAllocModeInfo( char * name, int nameLength );", "	( name nameLength -- )" );
	swigFunction( "c-function XRRCreateMode XRRCreateMode a u a -- u", "FUNCTION: XRRCreateMode ( dpy window modeInfo -- u )", "EXTERN: \"C\" int XRRCreateMode( void * dpy, int window, void * modeInfo );", "	( dpy window modeInfo -- )" );
	swigFunction( "c-function XRRDestroyMode XRRDestroyMode a u -- void", "FUNCTION: XRRDestroyMode ( dpy mode -- void )", "EXTERN: \"C\" void XRRDestroyMode( void * dpy, int mode );", "	( dpy mode -- )" );
	swigFunction( "c-function XRRAddOutputMode XRRAddOutputMode a u u -- void", "FUNCTION: XRRAddOutputMode ( dpy output mode -- void )", "EXTERN: \"C\" void XRRAddOutputMode( void * dpy, int output, int mode );", "	( dpy output mode -- )" );
	swigFunction( "c-function XRRDeleteOutputMode XRRDeleteOutputMode a u u -- void", "FUNCTION: XRRDeleteOutputMode ( dpy output mode -- void )", "EXTERN: \"C\" void XRRDeleteOutputMode( void * dpy, int output, int mode );", "	( dpy output mode -- )" );
	swigFunction( "c-function XRRFreeModeInfo XRRFreeModeInfo a -- void", "FUNCTION: XRRFreeModeInfo ( modeInfo -- void )", "EXTERN: \"C\" void XRRFreeModeInfo( void * modeInfo );", "	( modeInfo -- )" );
	swigFunction( "c-function XRRGetCrtcInfo XRRGetCrtcInfo a a u -- a", "FUNCTION: XRRGetCrtcInfo ( dpy resources crtc -- a )", "EXTERN: \"C\" void * XRRGetCrtcInfo( void * dpy, void * resources, int crtc );", "	( dpy resources crtc -- )" );
	swigFunction( "c-function XRRFreeCrtcInfo XRRFreeCrtcInfo a -- void", "FUNCTION: XRRFreeCrtcInfo ( crtcInfo -- void )", "EXTERN: \"C\" void XRRFreeCrtcInfo( void * crtcInfo );", "	( crtcInfo -- )" );
	swigFunction( "c-function XRRSetCrtcConfig XRRSetCrtcConfig a a u u n n u n a n -- n", "FUNCTION: XRRSetCrtcConfig ( dpy resources crtc timestamp x y mode rotation outputs noutputs -- n )", "EXTERN: \"C\" int XRRSetCrtcConfig( void * dpy, void * resources, int crtc, int timestamp, int x, int y, int mode, int rotation, void * outputs, int noutputs );", "	( dpy resources crtc timestamp x y mode rotation outputs noutputs -- )" );
	swigFunction( "c-function XRRGetCrtcGammaSize XRRGetCrtcGammaSize a u -- n", "FUNCTION: XRRGetCrtcGammaSize ( dpy crtc -- n )", "EXTERN: \"C\" int XRRGetCrtcGammaSize( void * dpy, int crtc );", "	( dpy crtc -- )" );
	swigFunction( "c-function XRRGetCrtcGamma XRRGetCrtcGamma a u -- a", "FUNCTION: XRRGetCrtcGamma ( dpy crtc -- a )", "EXTERN: \"C\" void * XRRGetCrtcGamma( void * dpy, int crtc );", "	( dpy crtc -- )" );
	swigFunction( "c-function XRRAllocGamma XRRAllocGamma n -- a", "FUNCTION: XRRAllocGamma ( size -- a )", "EXTERN: \"C\" void * XRRAllocGamma( int size );", "	( size -- )" );
	swigFunction( "c-function XRRSetCrtcGamma XRRSetCrtcGamma a u a -- void", "FUNCTION: XRRSetCrtcGamma ( dpy crtc gamma -- void )", "EXTERN: \"C\" void XRRSetCrtcGamma( void * dpy, int crtc, void * gamma );", "	( dpy crtc gamma -- )" );
	swigFunction( "c-function XRRFreeGamma XRRFreeGamma a -- void", "FUNCTION: XRRFreeGamma ( gamma -- void )", "EXTERN: \"C\" void XRRFreeGamma( void * gamma );", "	( gamma -- )" );
	swigFunction( "c-function XRRGetScreenResourcesCurrent XRRGetScreenResourcesCurrent a u -- a", "FUNCTION: XRRGetScreenResourcesCurrent ( dpy window -- a )", "EXTERN: \"C\" void * XRRGetScreenResourcesCurrent( void * dpy, int window );", "	( dpy window -- )" );
	swigFunction( "c-function XRRSetCrtcTransform XRRSetCrtcTransform a u a s a n -- void", "FUNCTION: XRRSetCrtcTransform ( dpy crtc transform filter params nparams -- void )", "EXTERN: \"C\" void XRRSetCrtcTransform( void * dpy, int crtc, void * transform, char * filter, void * params, int nparams );", "	( dpy crtc transform filter params nparams -- )" );
	swigFunction( "c-function XRRGetCrtcTransform XRRGetCrtcTransform a u a -- n", "FUNCTION: XRRGetCrtcTransform ( dpy crtc attributes -- n )", "EXTERN: \"C\" int XRRGetCrtcTransform( void * dpy, int crtc, void * attributes );", "	( dpy crtc attributes -- )" );
	swigFunction( "c-function XRRUpdateConfiguration XRRUpdateConfiguration a -- n", "FUNCTION: XRRUpdateConfiguration ( event -- n )", "EXTERN: \"C\" int XRRUpdateConfiguration( void * event );", "	( event -- )" );
	swigFunction( "c-function XRRGetPanning XRRGetPanning a a u -- a", "FUNCTION: XRRGetPanning ( dpy resources crtc -- a )", "EXTERN: \"C\" void * XRRGetPanning( void * dpy, void * resources, int crtc );", "	( dpy resources crtc -- )" );
	swigFunction( "c-function XRRFreePanning XRRFreePanning a -- void", "FUNCTION: XRRFreePanning ( panning -- void )", "EXTERN: \"C\" void XRRFreePanning( void * panning );", "	( panning -- )" );
	swigFunction( "c-function XRRSetPanning XRRSetPanning a a u a -- n", "FUNCTION: XRRSetPanning ( dpy resources crtc panning -- n )", "EXTERN: \"C\" int XRRSetPanning( void * dpy, void * resources, int crtc, void * panning );", "	( dpy resources crtc panning -- )" );
	swigFunction( "c-function XRRSetOutputPrimary XRRSetOutputPrimary a u u -- void", "FUNCTION: XRRSetOutputPrimary ( dpy window output -- void )", "EXTERN: \"C\" void XRRSetOutputPrimary( void * dpy, int window, int output );", "	( dpy window output -- )" );
	swigFunction( "c-function XRRGetOutputPrimary XRRGetOutputPrimary a u -- u", "FUNCTION: XRRGetOutputPrimary ( dpy window -- u )", "EXTERN: \"C\" int XRRGetOutputPrimary( void * dpy, int window );", "	( dpy window -- )" );
	swigFunction( "c-function XRRGetProviderResources XRRGetProviderResources a u -- a", "FUNCTION: XRRGetProviderResources ( dpy window -- a )", "EXTERN: \"C\" void * XRRGetProviderResources( void * dpy, int window );", "	( dpy window -- )" );
	swigFunction( "c-function XRRFreeProviderResources XRRFreeProviderResources a -- void", "FUNCTION: XRRFreeProviderResources ( resources -- void )", "EXTERN: \"C\" void XRRFreeProviderResources( void * resources );", "	( resources -- )" );
	swigFunction( "c-function XRRGetProviderInfo XRRGetProviderInfo a a u -- a", "FUNCTION: XRRGetProviderInfo ( dpy resources provider -- a )", "EXTERN: \"C\" void * XRRGetProviderInfo( void * dpy, void * resources, int provider );", "	( dpy resources provider -- )" );
	swigFunction( "c-function XRRFreeProviderInfo XRRFreeProviderInfo a -- void", "FUNCTION: XRRFreeProviderInfo ( provider -- void )", "EXTERN: \"C\" void XRRFreeProviderInfo( void * provider );", "	( provider -- )" );
	swigFunction( "c-function XRRSetProviderOutputSource XRRSetProviderOutputSource a u u -- n", "FUNCTION: XRRSetProviderOutputSource ( dpy provider source_provider -- n )", "EXTERN: \"C\" int XRRSetProviderOutputSource( void * dpy, int provider, int source_provider );", "	( dpy provider source_provider -- )" );
	swigFunction( "c-function XRRSetProviderOffloadSink XRRSetProviderOffloadSink a u u -- n", "FUNCTION: XRRSetProviderOffloadSink ( dpy provider sink_provider -- n )", "EXTERN: \"C\" int XRRSetProviderOffloadSink( void * dpy, int provider, int sink_provider );", "	( dpy provider sink_provider -- )" );
	swigFunction( "c-function XRRListProviderProperties XRRListProviderProperties a u a -- a", "FUNCTION: XRRListProviderProperties ( dpy provider nprop -- a )", "EXTERN: \"C\" void * XRRListProviderProperties( void * dpy, int provider, void * nprop );", "	( dpy provider nprop -- )" );
	swigFunction( "c-function XRRQueryProviderProperty XRRQueryProviderProperty a u u -- a", "FUNCTION: XRRQueryProviderProperty ( dpy provider property -- a )", "EXTERN: \"C\" void * XRRQueryProviderProperty( void * dpy, int provider, int property );", "	( dpy provider property -- )" );
	swigFunction( "c-function XRRConfigureProviderProperty XRRConfigureProviderProperty a u u n n n a -- void", "FUNCTION: XRRConfigureProviderProperty ( dpy provider property pending range num_values values -- void )", "EXTERN: \"C\" void XRRConfigureProviderProperty( void * dpy, int provider, int property, int pending, int range, int num_values, void * values );", "	( dpy provider property pending range num_values values -- )" );
	swigFunction( "c-function XRRChangeProviderProperty XRRChangeProviderProperty a u u u n n a n -- void", "FUNCTION: XRRChangeProviderProperty ( dpy provider property type format mode data nelements -- void )", "EXTERN: \"C\" void XRRChangeProviderProperty( void * dpy, int provider, int property, int type, int format, int mode, void * data, int nelements );", "	( dpy provider property type format mode data nelements -- )" );
	swigFunction( "c-function XRRDeleteProviderProperty XRRDeleteProviderProperty a u u -- void", "FUNCTION: XRRDeleteProviderProperty ( dpy provider property -- void )", "EXTERN: \"C\" void XRRDeleteProviderProperty( void * dpy, int provider, int property );", "	( dpy provider property -- )" );
	swigFunction( "c-function XRRGetProviderProperty XRRGetProviderProperty a u u n n n n u a a a a a -- n", "FUNCTION: XRRGetProviderProperty ( dpy provider property offset length _delete pending req_type actual_type actual_format nitems bytes_after prop -- n )", "EXTERN: \"C\" int XRRGetProviderProperty( void * dpy, int provider, int property, long offset, long length, int _delete, int pending, int req_type, void * actual_type, void * actual_format, void * nitems, void * bytes_after, void * prop );", "	( dpy provider property offset length _delete pending req_type actual_type actual_format nitems bytes_after prop -- )" );
	swigFunction( "c-function XRRAllocateMonitor XRRAllocateMonitor a n -- a", "FUNCTION: XRRAllocateMonitor ( dpy noutput -- a )", "EXTERN: \"C\" void * XRRAllocateMonitor( void * dpy, int noutput );", "	( dpy noutput -- )" );
	swigFunction( "c-function XRRGetMonitors XRRGetMonitors a u n a -- a", "FUNCTION: XRRGetMonitors ( dpy window get_active nmonitors -- a )", "EXTERN: \"C\" void * XRRGetMonitors( void * dpy, int window, int get_active, void * nmonitors );", "	( dpy window get_active nmonitors -- )" );
	swigFunction( "c-function XRRSetMonitor XRRSetMonitor a u a -- void", "FUNCTION: XRRSetMonitor ( dpy window monitor -- void )", "EXTERN: \"C\" void XRRSetMonitor( void * dpy, int window, void * monitor );", "	( dpy window monitor -- )" );
	swigFunction( "c-function XRRDeleteMonitor XRRDeleteMonitor a u u -- void", "FUNCTION: XRRDeleteMonitor ( dpy window name -- void )", "EXTERN: \"C\" void XRRDeleteMonitor( void * dpy, int window, int name );", "	( dpy window name -- )" );
	swigFunction( "c-function XRRFreeMonitors XRRFreeMonitors a -- void", "FUNCTION: XRRFreeMonitors ( monitors -- void )", "EXTERN: \"C\" void XRRFreeMonitors( void * monitors );", "	( monitors -- )" );

	swigNewline();

	swigComment("----===< postfix >===-----\n");

	swigPrint( "end-c-library", "( none )", "( none )" );
	
	return 0;
} /* end of main */



