/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 3.0.9
 *
 * This file is not intended to be easily readable and contains a number of
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG
 * interface file instead.
 * ----------------------------------------------------------------------------- */
#include <stdio.h>
#include <string.h>
#include <stddef.h>
#include <math.h> /* required for special case floating point output */

// Do not edit below this line
// end-of-default-includes


#include <webp/decode.h>
#include <webp/encode.h>
#ifdef __gnu_linux__
#undef stderr
extern struct _IO_FILE *stderr;
#endif

typedef enum{ NONE = -1, GFORTH = 0, SWIFTFORTH, VFX } SwigTargetSystem;
SwigTargetSystem swigTargetSystem = NONE;

unsigned char swigPrintStackComments = 1;

/* comments */
void swigNewline()
{
	printf( "\n" );
}

void swigComment( char *comment )
{
	printf( "\\ %s", comment );
}

/* generic print */
void swigPrint( char* gforth, char *swiftForth, char *vfx )
{
	if( swigTargetSystem == GFORTH )
		printf( "%s", gforth );
	else if( swigTargetSystem == SWIFTFORTH )
		printf( "%s", swiftForth );
	else if( swigTargetSystem == VFX )
		printf( "%s", vfx );
	printf( "\n" );
}
void swigPrintSystem( SwigTargetSystem targetSystem, char *text )
{
	if( targetSystem == swigTargetSystem )
	    printf( "%s\n", text );
}

/* constants */
void swigIntConstant( long constant, char *name )
{
	printf( "#%ld\tconstant %s\n", constant, name );
}

void swigUnsignedIntConstant( unsigned long constant, char *name )
{
	printf( "#%lu\tconstant %s\n", constant, name );
}

void swigLongConstant( long long constant, char *name )
{
	printf( "#%lld.\t2constant %s\n", constant, name );
}

void swigUnsignedLongConstant( unsigned long long constant, char *name )
{
	printf( "#%llu.\t2constant %s\n", constant, name );
}

void swigFloatConstant( double constant, char *name )
{
	char buffer[128];
	sprintf( buffer, "%f", constant );

	/* if the constant contains no exponent, add one */
	char *s;
	for( s = buffer; *s != 0; s++ )
		if( *s == 'e' || *s == 'E' )
			break;

	/* exponent found */
	if( *s != 0 )
		printf( "%s\tfconstant %s\n", buffer, name );
	/* no exponent */
	else {
		/* special class? */
		int class = fpclassify( constant );
		if( class == FP_INFINITE )
			printf( "%sInf\tfconstant %s\n", constant < 0.0f ? "-" : "+", name );
		else if( class == FP_NAN )
			printf( "NaN\tfconstant %s\n", name );
		else
			/* treat as generic float */
			printf( "%se0\tfconstant %s\n", buffer, name );
        }
}

void swigStringConstant( char* constant, char *name )
{
	char c;
	printf( ": %s s\\\" ", name );
	while(( c = *constant++ ))
	{
		switch(c)
		{
			case '\b': printf( "\\b" ); break;
			case '\n': printf( "\\n" ); break;
			case '\f': printf( "\\f" ); break;
			case '\r': printf( "\\r" ); break;
			case '\t': printf( "\\t" ); break;
			case '"' : printf( "\\q" ); break;
			default:
				if(c < 0x20)
					printf("\\x%02x", c);
				else
					printf("%c", c); break;
		}
	}
	printf(	"\" ;\n" );
}

/* structs */
void swigStructField( char *name, size_t offset, size_t size )
{
	printf( "\tdrop %zu %zu +field %s\n", offset, size, name );
}

/* functions */
void swigFunction( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	if( swigTargetSystem == GFORTH )
		printf( "%s", gforth );
	else if( swigTargetSystem == SWIFTFORTH )
		printf( "%s", swiftForth );
	else if( swigTargetSystem == VFX )
		printf( "%s", vfx );

	if( swigPrintStackComments )
		printf( "%s", stackComment );

	printf( "\n" );
}

/* function pointers */
void swigFunctionPointer( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	swigFunction( gforth, swiftForth, vfx, stackComment );
}

/* callbacks */
void swigCallback( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	swigFunction( gforth, swiftForth, vfx, stackComment );
}

void swigUsage( char **argv )
{
	fprintf( stderr, "Usage: %s [-gforth|-swiftforth|-vfx]\n", argv[0] );
}

int main( int argc, char **argv )
{
	int i;

	/* check arguments */
	for( i = 1; i < argc; i++ )
		if( strcmp( argv[i], "-gforth" ) == 0 )
			swigTargetSystem = GFORTH;
		else if( strcmp( argv[i], "-swiftforth" ) == 0 )
			swigTargetSystem = SWIFTFORTH;
		else if( strcmp( argv[i], "-vfx" ) == 0 )
			swigTargetSystem = VFX;

	if( swigTargetSystem == NONE )
	{
		fprintf( stderr, "Error: no target system specified\n" );
		swigUsage( argv );
		return 1;
	}

	/* primer */
	printf( "\\ This file has been generated using SWIG and fsi,\n"
		"\\ and is already platform dependent, search for the corresponding\n"
		"\\ fsi-file to compile it where no one has compiled it before ;)\n"
		"\\ Forth systems have their own own dynamic loader and don't need addional C-Code.\n"
		"\\ That's why this file will just print normal forth-code once compiled\n"
		"\\ and can be used directly with include or require.\n"
		"\\ As all comments are stripped during the compilation, please\n"
		"\\ insert the copyright notice of the original file here.\n"
	);


typedef union {
  WebPRGBABuffer RGBA;
  WebPYUVABuffer YUVA;
} WebPDecBuffer_u;


	swigNewline();

	swigComment("----===< prefix >===-----\n");

	swigPrint( "c-library webp\ns\" webp\" add-lib\n\\c #include <webp/decode.h>\n\\c #include <webp/encode.h>\n\\c #ifdef __gnu_linux__\n\\c #undef stderr\n\\c extern struct _IO_FILE *stderr;\n\\c #endif", "( none )", "( none )" );

	swigNewline();

	swigComment("----===< int constants >===-----\n");
	#ifdef WEBP_DECODER_ABI_VERSION
		swigIntConstant( WEBP_DECODER_ABI_VERSION, "WEBP_DECODER_ABI_VERSION" );
	#endif
	#ifdef WEBP_ENCODER_ABI_VERSION
		swigIntConstant( WEBP_ENCODER_ABI_VERSION, "WEBP_ENCODER_ABI_VERSION" );
	#endif
	#ifdef WEBP_MAX_DIMENSION
		swigIntConstant( WEBP_MAX_DIMENSION, "WEBP_MAX_DIMENSION" );
	#endif

	swigNewline();

	swigComment("--------===< enums >===---------\n");
	swigIntConstant( MODE_RGB, "MODE_RGB" );
	swigIntConstant( MODE_RGBA, "MODE_RGBA" );
	swigIntConstant( MODE_BGR, "MODE_BGR" );
	swigIntConstant( MODE_BGRA, "MODE_BGRA" );
	swigIntConstant( MODE_ARGB, "MODE_ARGB" );
	swigIntConstant( MODE_RGBA_4444, "MODE_RGBA_4444" );
	swigIntConstant( MODE_RGB_565, "MODE_RGB_565" );
	swigIntConstant( MODE_rgbA, "MODE_rgbA" );
	swigIntConstant( MODE_bgrA, "MODE_bgrA" );
	swigIntConstant( MODE_Argb, "MODE_Argb" );
	swigIntConstant( MODE_rgbA_4444, "MODE_rgbA_4444" );
	swigIntConstant( MODE_YUV, "MODE_YUV" );
	swigIntConstant( MODE_YUVA, "MODE_YUVA" );
	swigIntConstant( MODE_LAST, "MODE_LAST" );
	swigIntConstant( VP8_STATUS_OK, "VP8_STATUS_OK" );
	swigIntConstant( VP8_STATUS_OUT_OF_MEMORY, "VP8_STATUS_OUT_OF_MEMORY" );
	swigIntConstant( VP8_STATUS_INVALID_PARAM, "VP8_STATUS_INVALID_PARAM" );
	swigIntConstant( VP8_STATUS_BITSTREAM_ERROR, "VP8_STATUS_BITSTREAM_ERROR" );
	swigIntConstant( VP8_STATUS_UNSUPPORTED_FEATURE, "VP8_STATUS_UNSUPPORTED_FEATURE" );
	swigIntConstant( VP8_STATUS_SUSPENDED, "VP8_STATUS_SUSPENDED" );
	swigIntConstant( VP8_STATUS_USER_ABORT, "VP8_STATUS_USER_ABORT" );
	swigIntConstant( VP8_STATUS_NOT_ENOUGH_DATA, "VP8_STATUS_NOT_ENOUGH_DATA" );
	swigIntConstant( WEBP_HINT_DEFAULT, "WEBP_HINT_DEFAULT" );
	swigIntConstant( WEBP_HINT_PICTURE, "WEBP_HINT_PICTURE" );
	swigIntConstant( WEBP_HINT_PHOTO, "WEBP_HINT_PHOTO" );
	swigIntConstant( WEBP_HINT_GRAPH, "WEBP_HINT_GRAPH" );
	swigIntConstant( WEBP_HINT_LAST, "WEBP_HINT_LAST" );
	swigIntConstant( WEBP_PRESET_DEFAULT, "WEBP_PRESET_DEFAULT" );
	swigIntConstant( WEBP_PRESET_PICTURE, "WEBP_PRESET_PICTURE" );
	swigIntConstant( WEBP_PRESET_PHOTO, "WEBP_PRESET_PHOTO" );
	swigIntConstant( WEBP_PRESET_DRAWING, "WEBP_PRESET_DRAWING" );
	swigIntConstant( WEBP_PRESET_ICON, "WEBP_PRESET_ICON" );
	swigIntConstant( WEBP_PRESET_TEXT, "WEBP_PRESET_TEXT" );
	swigIntConstant( WEBP_YUV420, "WEBP_YUV420" );
	swigIntConstant( WEBP_YUV420A, "WEBP_YUV420A" );
	swigIntConstant( WEBP_CSP_UV_MASK, "WEBP_CSP_UV_MASK" );
	swigIntConstant( WEBP_CSP_ALPHA_BIT, "WEBP_CSP_ALPHA_BIT" );
	swigIntConstant( VP8_ENC_OK, "VP8_ENC_OK" );
	swigIntConstant( VP8_ENC_ERROR_OUT_OF_MEMORY, "VP8_ENC_ERROR_OUT_OF_MEMORY" );
	swigIntConstant( VP8_ENC_ERROR_BITSTREAM_OUT_OF_MEMORY, "VP8_ENC_ERROR_BITSTREAM_OUT_OF_MEMORY" );
	swigIntConstant( VP8_ENC_ERROR_NULL_PARAMETER, "VP8_ENC_ERROR_NULL_PARAMETER" );
	swigIntConstant( VP8_ENC_ERROR_INVALID_CONFIGURATION, "VP8_ENC_ERROR_INVALID_CONFIGURATION" );
	swigIntConstant( VP8_ENC_ERROR_BAD_DIMENSION, "VP8_ENC_ERROR_BAD_DIMENSION" );
	swigIntConstant( VP8_ENC_ERROR_PARTITION0_OVERFLOW, "VP8_ENC_ERROR_PARTITION0_OVERFLOW" );
	swigIntConstant( VP8_ENC_ERROR_PARTITION_OVERFLOW, "VP8_ENC_ERROR_PARTITION_OVERFLOW" );
	swigIntConstant( VP8_ENC_ERROR_BAD_WRITE, "VP8_ENC_ERROR_BAD_WRITE" );
	swigIntConstant( VP8_ENC_ERROR_FILE_TOO_BIG, "VP8_ENC_ERROR_FILE_TOO_BIG" );
	swigIntConstant( VP8_ENC_ERROR_USER_ABORT, "VP8_ENC_ERROR_USER_ABORT" );
	swigIntConstant( VP8_ENC_ERROR_LAST, "VP8_ENC_ERROR_LAST" );

	swigNewline();

	swigComment("-------===< structs >===--------\n");

	swigComment("struct WebPRGBABuffer\n");
	printf( "begin-structure WebPRGBABuffer\n" );
	swigStructField( "WebPRGBABuffer-rgba", offsetof( struct WebPRGBABuffer, rgba ), sizeof( uint8_t * ) );
	swigStructField( "WebPRGBABuffer-size", offsetof( struct WebPRGBABuffer, size ), sizeof( size_t ) );
	swigStructField( "WebPRGBABuffer-stride", offsetof( struct WebPRGBABuffer, stride ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( struct WebPRGBABuffer ) );

	swigComment("struct WebPYUVABuffer\n");
	printf( "begin-structure WebPYUVABuffer\n" );
	swigStructField( "WebPYUVABuffer-u_size", offsetof( struct WebPYUVABuffer, u_size ), sizeof( size_t ) );
	swigStructField( "WebPYUVABuffer-y_size", offsetof( struct WebPYUVABuffer, y_size ), sizeof( size_t ) );
	swigStructField( "WebPYUVABuffer-y", offsetof( struct WebPYUVABuffer, y ), sizeof( uint8_t * ) );
	swigStructField( "WebPYUVABuffer-v_size", offsetof( struct WebPYUVABuffer, v_size ), sizeof( size_t ) );
	swigStructField( "WebPYUVABuffer-a_size", offsetof( struct WebPYUVABuffer, a_size ), sizeof( size_t ) );
	swigStructField( "WebPYUVABuffer-y_stride", offsetof( struct WebPYUVABuffer, y_stride ), sizeof( int ) );
	swigStructField( "WebPYUVABuffer-u_stride", offsetof( struct WebPYUVABuffer, u_stride ), sizeof( int ) );
	swigStructField( "WebPYUVABuffer-v_stride", offsetof( struct WebPYUVABuffer, v_stride ), sizeof( int ) );
	swigStructField( "WebPYUVABuffer-a_stride", offsetof( struct WebPYUVABuffer, a_stride ), sizeof( int ) );
	swigStructField( "WebPYUVABuffer-u", offsetof( struct WebPYUVABuffer, u ), sizeof( uint8_t * ) );
	swigStructField( "WebPYUVABuffer-v", offsetof( struct WebPYUVABuffer, v ), sizeof( uint8_t * ) );
	swigStructField( "WebPYUVABuffer-a", offsetof( struct WebPYUVABuffer, a ), sizeof( uint8_t * ) );
	printf( "drop %zu end-structure\n", sizeof( struct WebPYUVABuffer ) );

	swigComment("struct WebPDecBuffer\n");
	printf( "begin-structure WebPDecBuffer\n" );
	swigStructField( "WebPDecBuffer-is_external_memory", offsetof( struct WebPDecBuffer, is_external_memory ), sizeof( int ) );
	swigStructField( "WebPDecBuffer-private_memory", offsetof( struct WebPDecBuffer, private_memory ), sizeof( uint8_t * ) );
	swigStructField( "WebPDecBuffer-colorspace", offsetof( struct WebPDecBuffer, colorspace ), sizeof( WEBP_CSP_MODE ) );
	swigStructField( "WebPDecBuffer-height", offsetof( struct WebPDecBuffer, height ), sizeof( int ) );
	swigStructField( "WebPDecBuffer-width", offsetof( struct WebPDecBuffer, width ), sizeof( int ) );
	swigStructField( "WebPDecBuffer-u", offsetof( struct WebPDecBuffer, u ), sizeof( WebPDecBuffer_u ) );
	swigStructField( "WebPDecBuffer-pad", offsetof( struct WebPDecBuffer, pad ), sizeof( uint32_t [4] ) );
	printf( "drop %zu end-structure\n", sizeof( struct WebPDecBuffer ) );

	swigComment("WebPDecBuffer_u\n");
	printf( "begin-structure WebPDecBuffer_u\n" );
	swigStructField( "WebPDecBuffer_u-RGBA", offsetof( WebPDecBuffer_u, RGBA ), sizeof( WebPRGBABuffer ) );
	swigStructField( "WebPDecBuffer_u-YUVA", offsetof( WebPDecBuffer_u, YUVA ), sizeof( WebPYUVABuffer ) );
	printf( "drop %zu end-structure\n", sizeof( WebPDecBuffer_u ) );

	swigComment("struct WebPBitstreamFeatures\n");
	printf( "begin-structure WebPBitstreamFeatures\n" );
	swigStructField( "WebPBitstreamFeatures-height", offsetof( struct WebPBitstreamFeatures, height ), sizeof( int ) );
	swigStructField( "WebPBitstreamFeatures-width", offsetof( struct WebPBitstreamFeatures, width ), sizeof( int ) );
	swigStructField( "WebPBitstreamFeatures-format", offsetof( struct WebPBitstreamFeatures, format ), sizeof( int ) );
	swigStructField( "WebPBitstreamFeatures-pad", offsetof( struct WebPBitstreamFeatures, pad ), sizeof( uint32_t [5] ) );
	swigStructField( "WebPBitstreamFeatures-has_alpha", offsetof( struct WebPBitstreamFeatures, has_alpha ), sizeof( int ) );
	swigStructField( "WebPBitstreamFeatures-has_animation", offsetof( struct WebPBitstreamFeatures, has_animation ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( struct WebPBitstreamFeatures ) );

	swigComment("struct WebPDecoderOptions\n");
	printf( "begin-structure WebPDecoderOptions\n" );
	swigStructField( "WebPDecoderOptions-crop_top", offsetof( struct WebPDecoderOptions, crop_top ), sizeof( int ) );
	swigStructField( "WebPDecoderOptions-crop_left", offsetof( struct WebPDecoderOptions, crop_left ), sizeof( int ) );
	swigStructField( "WebPDecoderOptions-use_cropping", offsetof( struct WebPDecoderOptions, use_cropping ), sizeof( int ) );
	swigStructField( "WebPDecoderOptions-scaled_width", offsetof( struct WebPDecoderOptions, scaled_width ), sizeof( int ) );
	swigStructField( "WebPDecoderOptions-crop_width", offsetof( struct WebPDecoderOptions, crop_width ), sizeof( int ) );
	swigStructField( "WebPDecoderOptions-use_threads", offsetof( struct WebPDecoderOptions, use_threads ), sizeof( int ) );
	swigStructField( "WebPDecoderOptions-bypass_filtering", offsetof( struct WebPDecoderOptions, bypass_filtering ), sizeof( int ) );
	swigStructField( "WebPDecoderOptions-scaled_height", offsetof( struct WebPDecoderOptions, scaled_height ), sizeof( int ) );
	swigStructField( "WebPDecoderOptions-crop_height", offsetof( struct WebPDecoderOptions, crop_height ), sizeof( int ) );
	swigStructField( "WebPDecoderOptions-flip", offsetof( struct WebPDecoderOptions, flip ), sizeof( int ) );
	swigStructField( "WebPDecoderOptions-use_scaling", offsetof( struct WebPDecoderOptions, use_scaling ), sizeof( int ) );
	swigStructField( "WebPDecoderOptions-pad", offsetof( struct WebPDecoderOptions, pad ), sizeof( uint32_t [5] ) );
	swigStructField( "WebPDecoderOptions-alpha_dithering_strength", offsetof( struct WebPDecoderOptions, alpha_dithering_strength ), sizeof( int ) );
	swigStructField( "WebPDecoderOptions-dithering_strength", offsetof( struct WebPDecoderOptions, dithering_strength ), sizeof( int ) );
	swigStructField( "WebPDecoderOptions-no_fancy_upsampling", offsetof( struct WebPDecoderOptions, no_fancy_upsampling ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( struct WebPDecoderOptions ) );

	swigComment("struct WebPDecoderConfig\n");
	printf( "begin-structure WebPDecoderConfig\n" );
	swigStructField( "WebPDecoderConfig-input", offsetof( struct WebPDecoderConfig, input ), sizeof( WebPBitstreamFeatures ) );
	swigStructField( "WebPDecoderConfig-output", offsetof( struct WebPDecoderConfig, output ), sizeof( WebPDecBuffer ) );
	swigStructField( "WebPDecoderConfig-options", offsetof( struct WebPDecoderConfig, options ), sizeof( WebPDecoderOptions ) );
	printf( "drop %zu end-structure\n", sizeof( struct WebPDecoderConfig ) );

	swigComment("struct WebPConfig\n");
	printf( "begin-structure WebPConfig\n" );
	swigStructField( "WebPConfig-partition_limit", offsetof( struct WebPConfig, partition_limit ), sizeof( int ) );
	swigStructField( "WebPConfig-thread_level", offsetof( struct WebPConfig, thread_level ), sizeof( int ) );
	swigStructField( "WebPConfig-method", offsetof( struct WebPConfig, method ), sizeof( int ) );
	swigStructField( "WebPConfig-quality", offsetof( struct WebPConfig, quality ), sizeof( float ) );
	swigStructField( "WebPConfig-alpha_quality", offsetof( struct WebPConfig, alpha_quality ), sizeof( int ) );
	swigStructField( "WebPConfig-low_memory", offsetof( struct WebPConfig, low_memory ), sizeof( int ) );
	swigStructField( "WebPConfig-qmax", offsetof( struct WebPConfig, qmax ), sizeof( int ) );
	swigStructField( "WebPConfig-filter_type", offsetof( struct WebPConfig, filter_type ), sizeof( int ) );
	swigStructField( "WebPConfig-target_PSNR", offsetof( struct WebPConfig, target_PSNR ), sizeof( float ) );
	swigStructField( "WebPConfig-alpha_filtering", offsetof( struct WebPConfig, alpha_filtering ), sizeof( int ) );
	swigStructField( "WebPConfig-pass", offsetof( struct WebPConfig, pass ), sizeof( int ) );
	swigStructField( "WebPConfig-emulate_jpeg_size", offsetof( struct WebPConfig, emulate_jpeg_size ), sizeof( int ) );
	swigStructField( "WebPConfig-use_sharp_yuv", offsetof( struct WebPConfig, use_sharp_yuv ), sizeof( int ) );
	swigStructField( "WebPConfig-preprocessing", offsetof( struct WebPConfig, preprocessing ), sizeof( int ) );
	swigStructField( "WebPConfig-partitions", offsetof( struct WebPConfig, partitions ), sizeof( int ) );
	swigStructField( "WebPConfig-alpha_compression", offsetof( struct WebPConfig, alpha_compression ), sizeof( int ) );
	swigStructField( "WebPConfig-exact", offsetof( struct WebPConfig, exact ), sizeof( int ) );
	swigStructField( "WebPConfig-use_delta_palette", offsetof( struct WebPConfig, use_delta_palette ), sizeof( int ) );
	swigStructField( "WebPConfig-qmin", offsetof( struct WebPConfig, qmin ), sizeof( int ) );
	swigStructField( "WebPConfig-lossless", offsetof( struct WebPConfig, lossless ), sizeof( int ) );
	swigStructField( "WebPConfig-image_hint", offsetof( struct WebPConfig, image_hint ), sizeof( WebPImageHint ) );
	swigStructField( "WebPConfig-near_lossless", offsetof( struct WebPConfig, near_lossless ), sizeof( int ) );
	swigStructField( "WebPConfig-filter_sharpness", offsetof( struct WebPConfig, filter_sharpness ), sizeof( int ) );
	swigStructField( "WebPConfig-autofilter", offsetof( struct WebPConfig, autofilter ), sizeof( int ) );
	swigStructField( "WebPConfig-segments", offsetof( struct WebPConfig, segments ), sizeof( int ) );
	swigStructField( "WebPConfig-filter_strength", offsetof( struct WebPConfig, filter_strength ), sizeof( int ) );
	swigStructField( "WebPConfig-sns_strength", offsetof( struct WebPConfig, sns_strength ), sizeof( int ) );
	swigStructField( "WebPConfig-show_compressed", offsetof( struct WebPConfig, show_compressed ), sizeof( int ) );
	swigStructField( "WebPConfig-target_size", offsetof( struct WebPConfig, target_size ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( struct WebPConfig ) );

	swigComment("struct WebPAuxStats\n");
	printf( "begin-structure WebPAuxStats\n" );
	swigStructField( "WebPAuxStats-segment_level", offsetof( struct WebPAuxStats, segment_level ), sizeof( int [4] ) );
	swigStructField( "WebPAuxStats-coded_size", offsetof( struct WebPAuxStats, coded_size ), sizeof( int ) );
	swigStructField( "WebPAuxStats-residual_bytes", offsetof( struct WebPAuxStats, residual_bytes ), sizeof( int [3][4] ) );
	swigStructField( "WebPAuxStats-header_bytes", offsetof( struct WebPAuxStats, header_bytes ), sizeof( int [2] ) );
	swigStructField( "WebPAuxStats-block_count", offsetof( struct WebPAuxStats, block_count ), sizeof( int [3] ) );
	swigStructField( "WebPAuxStats-transform_bits", offsetof( struct WebPAuxStats, transform_bits ), sizeof( int ) );
	swigStructField( "WebPAuxStats-cross_color_transform_bits", offsetof( struct WebPAuxStats, cross_color_transform_bits ), sizeof( int ) );
	swigStructField( "WebPAuxStats-cache_bits", offsetof( struct WebPAuxStats, cache_bits ), sizeof( int ) );
	swigStructField( "WebPAuxStats-layer_data_size", offsetof( struct WebPAuxStats, layer_data_size ), sizeof( int ) );
	swigStructField( "WebPAuxStats-alpha_data_size", offsetof( struct WebPAuxStats, alpha_data_size ), sizeof( int ) );
	swigStructField( "WebPAuxStats-lossless_hdr_size", offsetof( struct WebPAuxStats, lossless_hdr_size ), sizeof( int ) );
	swigStructField( "WebPAuxStats-lossless_data_size", offsetof( struct WebPAuxStats, lossless_data_size ), sizeof( int ) );
	swigStructField( "WebPAuxStats-PSNR", offsetof( struct WebPAuxStats, PSNR ), sizeof( float [5] ) );
	swigStructField( "WebPAuxStats-histogram_bits", offsetof( struct WebPAuxStats, histogram_bits ), sizeof( int ) );
	swigStructField( "WebPAuxStats-segment_quant", offsetof( struct WebPAuxStats, segment_quant ), sizeof( int [4] ) );
	swigStructField( "WebPAuxStats-segment_size", offsetof( struct WebPAuxStats, segment_size ), sizeof( int [4] ) );
	swigStructField( "WebPAuxStats-lossless_size", offsetof( struct WebPAuxStats, lossless_size ), sizeof( int ) );
	swigStructField( "WebPAuxStats-pad", offsetof( struct WebPAuxStats, pad ), sizeof( uint32_t [1] ) );
	swigStructField( "WebPAuxStats-lossless_features", offsetof( struct WebPAuxStats, lossless_features ), sizeof( uint32_t ) );
	swigStructField( "WebPAuxStats-palette_size", offsetof( struct WebPAuxStats, palette_size ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( struct WebPAuxStats ) );

	swigComment("struct WebPMemoryWriter\n");
	printf( "begin-structure WebPMemoryWriter\n" );
	swigStructField( "WebPMemoryWriter-mem", offsetof( struct WebPMemoryWriter, mem ), sizeof( uint8_t * ) );
	swigStructField( "WebPMemoryWriter-size", offsetof( struct WebPMemoryWriter, size ), sizeof( size_t ) );
	swigStructField( "WebPMemoryWriter-max_size", offsetof( struct WebPMemoryWriter, max_size ), sizeof( size_t ) );
	swigStructField( "WebPMemoryWriter-pad", offsetof( struct WebPMemoryWriter, pad ), sizeof( uint32_t [1] ) );
	printf( "drop %zu end-structure\n", sizeof( struct WebPMemoryWriter ) );

	swigComment("struct WebPPicture\n");
	printf( "begin-structure WebPPicture\n" );
	swigStructField( "WebPPicture-progress_hook", offsetof( struct WebPPicture, progress_hook ), sizeof( WebPProgressHook ) );
	swigStructField( "WebPPicture-y", offsetof( struct WebPPicture, y ), sizeof( uint8_t * ) );
	swigStructField( "WebPPicture-memory_", offsetof( struct WebPPicture, memory_ ), sizeof( void * ) );
	swigStructField( "WebPPicture-height", offsetof( struct WebPPicture, height ), sizeof( int ) );
	swigStructField( "WebPPicture-pad1", offsetof( struct WebPPicture, pad1 ), sizeof( uint32_t [2] ) );
	swigStructField( "WebPPicture-error_code", offsetof( struct WebPPicture, error_code ), sizeof( WebPEncodingError ) );
	swigStructField( "WebPPicture-pad2", offsetof( struct WebPPicture, pad2 ), sizeof( uint32_t [3] ) );
	swigStructField( "WebPPicture-extra_info", offsetof( struct WebPPicture, extra_info ), sizeof( uint8_t * ) );
	swigStructField( "WebPPicture-user_data", offsetof( struct WebPPicture, user_data ), sizeof( void * ) );
	swigStructField( "WebPPicture-pad3", offsetof( struct WebPPicture, pad3 ), sizeof( uint32_t [3] ) );
	swigStructField( "WebPPicture-pad4", offsetof( struct WebPPicture, pad4 ), sizeof( uint8_t * ) );
	swigStructField( "WebPPicture-writer", offsetof( struct WebPPicture, writer ), sizeof( WebPWriterFunction ) );
	swigStructField( "WebPPicture-pad5", offsetof( struct WebPPicture, pad5 ), sizeof( uint8_t * ) );
	swigStructField( "WebPPicture-pad6", offsetof( struct WebPPicture, pad6 ), sizeof( uint32_t [8] ) );
	swigStructField( "WebPPicture-width", offsetof( struct WebPPicture, width ), sizeof( int ) );
	swigStructField( "WebPPicture-extra_info_type", offsetof( struct WebPPicture, extra_info_type ), sizeof( int ) );
	swigStructField( "WebPPicture-stats", offsetof( struct WebPPicture, stats ), sizeof( WebPAuxStats * ) );
	swigStructField( "WebPPicture-pad7", offsetof( struct WebPPicture, pad7 ), sizeof( void *[2] ) );
	swigStructField( "WebPPicture-argb_stride", offsetof( struct WebPPicture, argb_stride ), sizeof( int ) );
	swigStructField( "WebPPicture-a_stride", offsetof( struct WebPPicture, a_stride ), sizeof( int ) );
	swigStructField( "WebPPicture-uv_stride", offsetof( struct WebPPicture, uv_stride ), sizeof( int ) );
	swigStructField( "WebPPicture-y_stride", offsetof( struct WebPPicture, y_stride ), sizeof( int ) );
	swigStructField( "WebPPicture-a", offsetof( struct WebPPicture, a ), sizeof( uint8_t * ) );
	swigStructField( "WebPPicture-colorspace", offsetof( struct WebPPicture, colorspace ), sizeof( WebPEncCSP ) );
	swigStructField( "WebPPicture-argb", offsetof( struct WebPPicture, argb ), sizeof( uint32_t * ) );
	swigStructField( "WebPPicture-use_argb", offsetof( struct WebPPicture, use_argb ), sizeof( int ) );
	swigStructField( "WebPPicture-custom_ptr", offsetof( struct WebPPicture, custom_ptr ), sizeof( void * ) );
	swigStructField( "WebPPicture-memory_argb_", offsetof( struct WebPPicture, memory_argb_ ), sizeof( void * ) );
	swigStructField( "WebPPicture-u", offsetof( struct WebPPicture, u ), sizeof( uint8_t * ) );
	swigStructField( "WebPPicture-v", offsetof( struct WebPPicture, v ), sizeof( uint8_t * ) );
	printf( "drop %zu end-structure\n", sizeof( struct WebPPicture ) );

	swigNewline();

	swigComment("------===< callbacks >===-------\n");
	swigCallback( "c-callback WebPWriterFunction: a u a -- n", "", "", "	( data data_size picture -- )" );
	swigCallback( "c-callback WebPProgressHook: n a -- n", "", "", "	( percent picture -- )" );

	swigNewline();

	swigComment("------===< functions >===-------\n");
	swigFunction( "c-function WebPMalloc WebPMalloc u -- a", "FUNCTION: WebPMalloc ( size -- a )", "EXTERN: \"C\" void * WebPMalloc( long size );", "	( size -- )" );
	swigFunction( "c-function WebPFree WebPFree a -- void", "FUNCTION: WebPFree ( ptr -- void )", "EXTERN: \"C\" void WebPFree( void * ptr );", "	( ptr -- )" );
	swigFunction( "c-function WebPGetDecoderVersion WebPGetDecoderVersion  -- n", "FUNCTION: WebPGetDecoderVersion (  -- n )", "EXTERN: \"C\" int WebPGetDecoderVersion(  );", "	( -- )" );
	swigFunction( "c-function WebPGetInfo WebPGetInfo a u a a -- n", "FUNCTION: WebPGetInfo ( data data_size width height -- n )", "EXTERN: \"C\" int WebPGetInfo( void * data, long data_size, void * width, void * height );", "	( data data_size width height -- )" );
	swigFunction( "c-function WebPDecodeRGBA WebPDecodeRGBA a u a a -- a", "FUNCTION: WebPDecodeRGBA ( data data_size width height -- a )", "EXTERN: \"C\" void * WebPDecodeRGBA( void * data, long data_size, void * width, void * height );", "	( data data_size width height -- )" );
	swigFunction( "c-function WebPDecodeARGB WebPDecodeARGB a u a a -- a", "FUNCTION: WebPDecodeARGB ( data data_size width height -- a )", "EXTERN: \"C\" void * WebPDecodeARGB( void * data, long data_size, void * width, void * height );", "	( data data_size width height -- )" );
	swigFunction( "c-function WebPDecodeBGRA WebPDecodeBGRA a u a a -- a", "FUNCTION: WebPDecodeBGRA ( data data_size width height -- a )", "EXTERN: \"C\" void * WebPDecodeBGRA( void * data, long data_size, void * width, void * height );", "	( data data_size width height -- )" );
	swigFunction( "c-function WebPDecodeRGB WebPDecodeRGB a u a a -- a", "FUNCTION: WebPDecodeRGB ( data data_size width height -- a )", "EXTERN: \"C\" void * WebPDecodeRGB( void * data, long data_size, void * width, void * height );", "	( data data_size width height -- )" );
	swigFunction( "c-function WebPDecodeBGR WebPDecodeBGR a u a a -- a", "FUNCTION: WebPDecodeBGR ( data data_size width height -- a )", "EXTERN: \"C\" void * WebPDecodeBGR( void * data, long data_size, void * width, void * height );", "	( data data_size width height -- )" );
	swigFunction( "c-function WebPDecodeYUV WebPDecodeYUV a u a a a a a a -- a", "FUNCTION: WebPDecodeYUV ( data data_size width height u v stride uv_stride -- a )", "EXTERN: \"C\" void * WebPDecodeYUV( void * data, long data_size, void * width, void * height, void * u, void * v, void * stride, void * uv_stride );", "	( data data_size width height u v stride uv_stride -- )" );
	swigFunction( "c-function WebPDecodeRGBAInto WebPDecodeRGBAInto a u a u n -- a", "FUNCTION: WebPDecodeRGBAInto ( data data_size output_buffer output_buffer_size output_stride -- a )", "EXTERN: \"C\" void * WebPDecodeRGBAInto( void * data, long data_size, void * output_buffer, long output_buffer_size, int output_stride );", "	( data data_size output_buffer output_buffer_size output_stride -- )" );
	swigFunction( "c-function WebPDecodeARGBInto WebPDecodeARGBInto a u a u n -- a", "FUNCTION: WebPDecodeARGBInto ( data data_size output_buffer output_buffer_size output_stride -- a )", "EXTERN: \"C\" void * WebPDecodeARGBInto( void * data, long data_size, void * output_buffer, long output_buffer_size, int output_stride );", "	( data data_size output_buffer output_buffer_size output_stride -- )" );
	swigFunction( "c-function WebPDecodeBGRAInto WebPDecodeBGRAInto a u a u n -- a", "FUNCTION: WebPDecodeBGRAInto ( data data_size output_buffer output_buffer_size output_stride -- a )", "EXTERN: \"C\" void * WebPDecodeBGRAInto( void * data, long data_size, void * output_buffer, long output_buffer_size, int output_stride );", "	( data data_size output_buffer output_buffer_size output_stride -- )" );
	swigFunction( "c-function WebPDecodeRGBInto WebPDecodeRGBInto a u a u n -- a", "FUNCTION: WebPDecodeRGBInto ( data data_size output_buffer output_buffer_size output_stride -- a )", "EXTERN: \"C\" void * WebPDecodeRGBInto( void * data, long data_size, void * output_buffer, long output_buffer_size, int output_stride );", "	( data data_size output_buffer output_buffer_size output_stride -- )" );
	swigFunction( "c-function WebPDecodeBGRInto WebPDecodeBGRInto a u a u n -- a", "FUNCTION: WebPDecodeBGRInto ( data data_size output_buffer output_buffer_size output_stride -- a )", "EXTERN: \"C\" void * WebPDecodeBGRInto( void * data, long data_size, void * output_buffer, long output_buffer_size, int output_stride );", "	( data data_size output_buffer output_buffer_size output_stride -- )" );
	swigFunction( "c-function WebPDecodeYUVInto WebPDecodeYUVInto a u a u n a u n a u n -- a", "FUNCTION: WebPDecodeYUVInto ( data data_size luma luma_size luma_stride u u_size u_stride v v_size v_stride -- a )", "EXTERN: \"C\" void * WebPDecodeYUVInto( void * data, long data_size, void * luma, long luma_size, int luma_stride, void * u, long u_size, int u_stride, void * v, long v_size, int v_stride );", "	( data data_size luma luma_size luma_stride u u_size u_stride v v_size v_stride -- )" );
	swigFunction( "c-function WebPIsPremultipliedMode WebPIsPremultipliedMode n -- n", "FUNCTION: WebPIsPremultipliedMode ( mode -- n )", "EXTERN: \"C\" int WebPIsPremultipliedMode( int mode );", "	( mode -- )" );
	swigFunction( "c-function WebPIsAlphaMode WebPIsAlphaMode n -- n", "FUNCTION: WebPIsAlphaMode ( mode -- n )", "EXTERN: \"C\" int WebPIsAlphaMode( int mode );", "	( mode -- )" );
	swigFunction( "c-function WebPIsRGBMode WebPIsRGBMode n -- n", "FUNCTION: WebPIsRGBMode ( mode -- n )", "EXTERN: \"C\" int WebPIsRGBMode( int mode );", "	( mode -- )" );
	swigFunction( "c-function WebPInitDecBufferInternal WebPInitDecBufferInternal a n -- n", "FUNCTION: WebPInitDecBufferInternal (   -- n )", "EXTERN: \"C\" int WebPInitDecBufferInternal( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function WebPInitDecBuffer WebPInitDecBuffer a -- n", "FUNCTION: WebPInitDecBuffer ( buffer -- n )", "EXTERN: \"C\" int WebPInitDecBuffer( void * buffer );", "	( buffer -- )" );
	swigFunction( "c-function WebPFreeDecBuffer WebPFreeDecBuffer a -- void", "FUNCTION: WebPFreeDecBuffer ( buffer -- void )", "EXTERN: \"C\" void WebPFreeDecBuffer( void * buffer );", "	( buffer -- )" );
	swigFunction( "c-function WebPINewDecoder WebPINewDecoder a -- a", "FUNCTION: WebPINewDecoder ( output_buffer -- a )", "EXTERN: \"C\" void * WebPINewDecoder( void * output_buffer );", "	( output_buffer -- )" );
	swigFunction( "c-function WebPINewRGB WebPINewRGB n a u n -- a", "FUNCTION: WebPINewRGB ( csp output_buffer output_buffer_size output_stride -- a )", "EXTERN: \"C\" void * WebPINewRGB( int csp, void * output_buffer, long output_buffer_size, int output_stride );", "	( csp output_buffer output_buffer_size output_stride -- )" );
	swigFunction( "c-function WebPINewYUVA WebPINewYUVA a u n a u n a u n a u n -- a", "FUNCTION: WebPINewYUVA ( luma luma_size luma_stride u u_size u_stride v v_size v_stride a a_size a_stride -- a )", "EXTERN: \"C\" void * WebPINewYUVA( void * luma, long luma_size, int luma_stride, void * u, long u_size, int u_stride, void * v, long v_size, int v_stride, void * a, long a_size, int a_stride );", "	( luma luma_size luma_stride u u_size u_stride v v_size v_stride a a_size a_stride -- )" );
	swigFunction( "c-function WebPINewYUV WebPINewYUV a u n a u n a u n -- a", "FUNCTION: WebPINewYUV ( luma luma_size luma_stride u u_size u_stride v v_size v_stride -- a )", "EXTERN: \"C\" void * WebPINewYUV( void * luma, long luma_size, int luma_stride, void * u, long u_size, int u_stride, void * v, long v_size, int v_stride );", "	( luma luma_size luma_stride u u_size u_stride v v_size v_stride -- )" );
	swigFunction( "c-function WebPIDelete WebPIDelete a -- void", "FUNCTION: WebPIDelete ( idec -- void )", "EXTERN: \"C\" void WebPIDelete( void * idec );", "	( idec -- )" );
	swigFunction( "c-function WebPIAppend WebPIAppend a a u -- n", "FUNCTION: WebPIAppend ( idec data data_size -- n )", "EXTERN: \"C\" int WebPIAppend( void * idec, void * data, long data_size );", "	( idec data data_size -- )" );
	swigFunction( "c-function WebPIUpdate WebPIUpdate a a u -- n", "FUNCTION: WebPIUpdate ( idec data data_size -- n )", "EXTERN: \"C\" int WebPIUpdate( void * idec, void * data, long data_size );", "	( idec data data_size -- )" );
	swigFunction( "c-function WebPIDecGetRGB WebPIDecGetRGB a a a a a -- a", "FUNCTION: WebPIDecGetRGB ( idec last_y width height stride -- a )", "EXTERN: \"C\" void * WebPIDecGetRGB( void * idec, void * last_y, void * width, void * height, void * stride );", "	( idec last_y width height stride -- )" );
	swigFunction( "c-function WebPIDecGetYUVA WebPIDecGetYUVA a a a a a a a a a a -- a", "FUNCTION: WebPIDecGetYUVA ( idec last_y u v a width height stride uv_stride a_stride -- a )", "EXTERN: \"C\" void * WebPIDecGetYUVA( void * idec, void * last_y, void * u, void * v, void * a, void * width, void * height, void * stride, void * uv_stride, void * a_stride );", "	( idec last_y u v a width height stride uv_stride a_stride -- )" );
	swigFunction( "c-function WebPIDecGetYUV WebPIDecGetYUV a a a a a a a a -- a", "FUNCTION: WebPIDecGetYUV ( idec last_y u v width height stride uv_stride -- a )", "EXTERN: \"C\" void * WebPIDecGetYUV( void * idec, void * last_y, void * u, void * v, void * width, void * height, void * stride, void * uv_stride );", "	( idec last_y u v width height stride uv_stride -- )" );
	swigFunction( "c-function WebPIDecodedArea WebPIDecodedArea a a a a a -- a", "FUNCTION: WebPIDecodedArea ( idec left top width height -- a )", "EXTERN: \"C\" void * WebPIDecodedArea( void * idec, void * left, void * top, void * width, void * height );", "	( idec left top width height -- )" );
	swigFunction( "c-function WebPGetFeaturesInternal WebPGetFeaturesInternal a u a n -- n", "FUNCTION: WebPGetFeaturesInternal (     -- n )", "EXTERN: \"C\" int WebPGetFeaturesInternal( void * , long , void * , int  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function WebPGetFeatures WebPGetFeatures a u a -- n", "FUNCTION: WebPGetFeatures ( data data_size features -- n )", "EXTERN: \"C\" int WebPGetFeatures( void * data, long data_size, void * features );", "	( data data_size features -- )" );
	swigFunction( "c-function WebPInitDecoderConfigInternal WebPInitDecoderConfigInternal a n -- n", "FUNCTION: WebPInitDecoderConfigInternal (   -- n )", "EXTERN: \"C\" int WebPInitDecoderConfigInternal( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function WebPInitDecoderConfig WebPInitDecoderConfig a -- n", "FUNCTION: WebPInitDecoderConfig ( config -- n )", "EXTERN: \"C\" int WebPInitDecoderConfig( void * config );", "	( config -- )" );
	swigFunction( "c-function WebPIDecode WebPIDecode a u a -- a", "FUNCTION: WebPIDecode ( data data_size config -- a )", "EXTERN: \"C\" void * WebPIDecode( void * data, long data_size, void * config );", "	( data data_size config -- )" );
	swigFunction( "c-function WebPDecode WebPDecode a u a -- n", "FUNCTION: WebPDecode ( data data_size config -- n )", "EXTERN: \"C\" int WebPDecode( void * data, long data_size, void * config );", "	( data data_size config -- )" );
	swigFunction( "c-function WebPGetEncoderVersion WebPGetEncoderVersion  -- n", "FUNCTION: WebPGetEncoderVersion (  -- n )", "EXTERN: \"C\" int WebPGetEncoderVersion(  );", "	( -- )" );
	swigFunction( "c-function WebPEncodeRGB WebPEncodeRGB a n n n r a -- u", "FUNCTION: WebPEncodeRGB ( rgb width height stride quality_factor output -- u )", "EXTERN: \"C\" long WebPEncodeRGB( void * rgb, int width, int height, int stride, float quality_factor, void * output );", "	( rgb width height stride quality_factor output -- )" );
	swigFunction( "c-function WebPEncodeBGR WebPEncodeBGR a n n n r a -- u", "FUNCTION: WebPEncodeBGR ( bgr width height stride quality_factor output -- u )", "EXTERN: \"C\" long WebPEncodeBGR( void * bgr, int width, int height, int stride, float quality_factor, void * output );", "	( bgr width height stride quality_factor output -- )" );
	swigFunction( "c-function WebPEncodeRGBA WebPEncodeRGBA a n n n r a -- u", "FUNCTION: WebPEncodeRGBA ( rgba width height stride quality_factor output -- u )", "EXTERN: \"C\" long WebPEncodeRGBA( void * rgba, int width, int height, int stride, float quality_factor, void * output );", "	( rgba width height stride quality_factor output -- )" );
	swigFunction( "c-function WebPEncodeBGRA WebPEncodeBGRA a n n n r a -- u", "FUNCTION: WebPEncodeBGRA ( bgra width height stride quality_factor output -- u )", "EXTERN: \"C\" long WebPEncodeBGRA( void * bgra, int width, int height, int stride, float quality_factor, void * output );", "	( bgra width height stride quality_factor output -- )" );
	swigFunction( "c-function WebPEncodeLosslessRGB WebPEncodeLosslessRGB a n n n a -- u", "FUNCTION: WebPEncodeLosslessRGB ( rgb width height stride output -- u )", "EXTERN: \"C\" long WebPEncodeLosslessRGB( void * rgb, int width, int height, int stride, void * output );", "	( rgb width height stride output -- )" );
	swigFunction( "c-function WebPEncodeLosslessBGR WebPEncodeLosslessBGR a n n n a -- u", "FUNCTION: WebPEncodeLosslessBGR ( bgr width height stride output -- u )", "EXTERN: \"C\" long WebPEncodeLosslessBGR( void * bgr, int width, int height, int stride, void * output );", "	( bgr width height stride output -- )" );
	swigFunction( "c-function WebPEncodeLosslessRGBA WebPEncodeLosslessRGBA a n n n a -- u", "FUNCTION: WebPEncodeLosslessRGBA ( rgba width height stride output -- u )", "EXTERN: \"C\" long WebPEncodeLosslessRGBA( void * rgba, int width, int height, int stride, void * output );", "	( rgba width height stride output -- )" );
	swigFunction( "c-function WebPEncodeLosslessBGRA WebPEncodeLosslessBGRA a n n n a -- u", "FUNCTION: WebPEncodeLosslessBGRA ( bgra width height stride output -- u )", "EXTERN: \"C\" long WebPEncodeLosslessBGRA( void * bgra, int width, int height, int stride, void * output );", "	( bgra width height stride output -- )" );
	swigFunction( "c-function WebPConfigInitInternal WebPConfigInitInternal a n r n -- n", "FUNCTION: WebPConfigInitInternal (     -- n )", "EXTERN: \"C\" int WebPConfigInitInternal( void * , int , float , int  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function WebPConfigInit WebPConfigInit a -- n", "FUNCTION: WebPConfigInit ( config -- n )", "EXTERN: \"C\" int WebPConfigInit( void * config );", "	( config -- )" );
	swigFunction( "c-function WebPConfigPreset WebPConfigPreset a n r -- n", "FUNCTION: WebPConfigPreset ( config preset quality -- n )", "EXTERN: \"C\" int WebPConfigPreset( void * config, int preset, float quality );", "	( config preset quality -- )" );
	swigFunction( "c-function WebPConfigLosslessPreset WebPConfigLosslessPreset a n -- n", "FUNCTION: WebPConfigLosslessPreset ( config level -- n )", "EXTERN: \"C\" int WebPConfigLosslessPreset( void * config, int level );", "	( config level -- )" );
	swigFunction( "c-function WebPValidateConfig WebPValidateConfig a -- n", "FUNCTION: WebPValidateConfig ( config -- n )", "EXTERN: \"C\" int WebPValidateConfig( void * config );", "	( config -- )" );
	swigFunction( "c-function WebPMemoryWriterInit WebPMemoryWriterInit a -- void", "FUNCTION: WebPMemoryWriterInit ( writer -- void )", "EXTERN: \"C\" void WebPMemoryWriterInit( void * writer );", "	( writer -- )" );
	swigFunction( "c-function WebPMemoryWriterClear WebPMemoryWriterClear a -- void", "FUNCTION: WebPMemoryWriterClear ( writer -- void )", "EXTERN: \"C\" void WebPMemoryWriterClear( void * writer );", "	( writer -- )" );
	swigFunction( "c-function WebPMemoryWrite WebPMemoryWrite a u a -- n", "FUNCTION: WebPMemoryWrite ( data data_size picture -- n )", "EXTERN: \"C\" int WebPMemoryWrite( void * data, long data_size, void * picture );", "	( data data_size picture -- )" );
	swigFunction( "c-function WebPPictureInitInternal WebPPictureInitInternal a n -- n", "FUNCTION: WebPPictureInitInternal (   -- n )", "EXTERN: \"C\" int WebPPictureInitInternal( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function WebPPictureInit WebPPictureInit a -- n", "FUNCTION: WebPPictureInit ( picture -- n )", "EXTERN: \"C\" int WebPPictureInit( void * picture );", "	( picture -- )" );
	swigFunction( "c-function WebPPictureAlloc WebPPictureAlloc a -- n", "FUNCTION: WebPPictureAlloc ( picture -- n )", "EXTERN: \"C\" int WebPPictureAlloc( void * picture );", "	( picture -- )" );
	swigFunction( "c-function WebPPictureFree WebPPictureFree a -- void", "FUNCTION: WebPPictureFree ( picture -- void )", "EXTERN: \"C\" void WebPPictureFree( void * picture );", "	( picture -- )" );
	swigFunction( "c-function WebPPictureCopy WebPPictureCopy a a -- n", "FUNCTION: WebPPictureCopy ( src dst -- n )", "EXTERN: \"C\" int WebPPictureCopy( void * src, void * dst );", "	( src dst -- )" );
	swigFunction( "c-function WebPPlaneDistortion WebPPlaneDistortion a u a u n n u n a a -- n", "FUNCTION: WebPPlaneDistortion ( src src_stride ref ref_stride width height x_step type distortion result -- n )", "EXTERN: \"C\" int WebPPlaneDistortion( void * src, long src_stride, void * ref, long ref_stride, int width, int height, long x_step, int type, void * distortion, void * result );", "	( src src_stride ref ref_stride width height x_step type distortion result -- )" );
	swigFunction( "c-function WebPPictureDistortion WebPPictureDistortion a a n a -- n", "FUNCTION: WebPPictureDistortion ( src ref metric_type result -- n )", "EXTERN: \"C\" int WebPPictureDistortion( void * src, void * ref, int metric_type, void * result );", "	( src ref metric_type result -- )" );
	swigFunction( "c-function WebPPictureCrop WebPPictureCrop a n n n n -- n", "FUNCTION: WebPPictureCrop ( picture left top width height -- n )", "EXTERN: \"C\" int WebPPictureCrop( void * picture, int left, int top, int width, int height );", "	( picture left top width height -- )" );
	swigFunction( "c-function WebPPictureView WebPPictureView a n n n n a -- n", "FUNCTION: WebPPictureView ( src left top width height dst -- n )", "EXTERN: \"C\" int WebPPictureView( void * src, int left, int top, int width, int height, void * dst );", "	( src left top width height dst -- )" );
	swigFunction( "c-function WebPPictureIsView WebPPictureIsView a -- n", "FUNCTION: WebPPictureIsView ( picture -- n )", "EXTERN: \"C\" int WebPPictureIsView( void * picture );", "	( picture -- )" );
	swigFunction( "c-function WebPPictureRescale WebPPictureRescale a n n -- n", "FUNCTION: WebPPictureRescale ( picture width height -- n )", "EXTERN: \"C\" int WebPPictureRescale( void * picture, int width, int height );", "	( picture width height -- )" );
	swigFunction( "c-function WebPPictureImportRGB WebPPictureImportRGB a a n -- n", "FUNCTION: WebPPictureImportRGB ( picture rgb rgb_stride -- n )", "EXTERN: \"C\" int WebPPictureImportRGB( void * picture, void * rgb, int rgb_stride );", "	( picture rgb rgb_stride -- )" );
	swigFunction( "c-function WebPPictureImportRGBA WebPPictureImportRGBA a a n -- n", "FUNCTION: WebPPictureImportRGBA ( picture rgba rgba_stride -- n )", "EXTERN: \"C\" int WebPPictureImportRGBA( void * picture, void * rgba, int rgba_stride );", "	( picture rgba rgba_stride -- )" );
	swigFunction( "c-function WebPPictureImportRGBX WebPPictureImportRGBX a a n -- n", "FUNCTION: WebPPictureImportRGBX ( picture rgbx rgbx_stride -- n )", "EXTERN: \"C\" int WebPPictureImportRGBX( void * picture, void * rgbx, int rgbx_stride );", "	( picture rgbx rgbx_stride -- )" );
	swigFunction( "c-function WebPPictureImportBGR WebPPictureImportBGR a a n -- n", "FUNCTION: WebPPictureImportBGR ( picture bgr bgr_stride -- n )", "EXTERN: \"C\" int WebPPictureImportBGR( void * picture, void * bgr, int bgr_stride );", "	( picture bgr bgr_stride -- )" );
	swigFunction( "c-function WebPPictureImportBGRA WebPPictureImportBGRA a a n -- n", "FUNCTION: WebPPictureImportBGRA ( picture bgra bgra_stride -- n )", "EXTERN: \"C\" int WebPPictureImportBGRA( void * picture, void * bgra, int bgra_stride );", "	( picture bgra bgra_stride -- )" );
	swigFunction( "c-function WebPPictureImportBGRX WebPPictureImportBGRX a a n -- n", "FUNCTION: WebPPictureImportBGRX ( picture bgrx bgrx_stride -- n )", "EXTERN: \"C\" int WebPPictureImportBGRX( void * picture, void * bgrx, int bgrx_stride );", "	( picture bgrx bgrx_stride -- )" );
	swigFunction( "c-function WebPPictureARGBToYUVA WebPPictureARGBToYUVA a n -- n", "FUNCTION: WebPPictureARGBToYUVA ( picture  -- n )", "EXTERN: \"C\" int WebPPictureARGBToYUVA( void * picture, int  );", "	( picture <noname> -- )" );
	swigFunction( "c-function WebPPictureARGBToYUVADithered WebPPictureARGBToYUVADithered a n r -- n", "FUNCTION: WebPPictureARGBToYUVADithered ( picture colorspace dithering -- n )", "EXTERN: \"C\" int WebPPictureARGBToYUVADithered( void * picture, int colorspace, float dithering );", "	( picture colorspace dithering -- )" );
	swigFunction( "c-function WebPPictureSharpARGBToYUVA WebPPictureSharpARGBToYUVA a -- n", "FUNCTION: WebPPictureSharpARGBToYUVA ( picture -- n )", "EXTERN: \"C\" int WebPPictureSharpARGBToYUVA( void * picture );", "	( picture -- )" );
	swigFunction( "c-function WebPPictureSmartARGBToYUVA WebPPictureSmartARGBToYUVA a -- n", "FUNCTION: WebPPictureSmartARGBToYUVA ( picture -- n )", "EXTERN: \"C\" int WebPPictureSmartARGBToYUVA( void * picture );", "	( picture -- )" );
	swigFunction( "c-function WebPPictureYUVAToARGB WebPPictureYUVAToARGB a -- n", "FUNCTION: WebPPictureYUVAToARGB ( picture -- n )", "EXTERN: \"C\" int WebPPictureYUVAToARGB( void * picture );", "	( picture -- )" );
	swigFunction( "c-function WebPCleanupTransparentArea WebPCleanupTransparentArea a -- void", "FUNCTION: WebPCleanupTransparentArea ( picture -- void )", "EXTERN: \"C\" void WebPCleanupTransparentArea( void * picture );", "	( picture -- )" );
	swigFunction( "c-function WebPPictureHasTransparency WebPPictureHasTransparency a -- n", "FUNCTION: WebPPictureHasTransparency ( picture -- n )", "EXTERN: \"C\" int WebPPictureHasTransparency( void * picture );", "	( picture -- )" );
	swigFunction( "c-function WebPBlendAlpha WebPBlendAlpha a u -- void", "FUNCTION: WebPBlendAlpha ( picture background_rgb -- void )", "EXTERN: \"C\" void WebPBlendAlpha( void * picture, int background_rgb );", "	( picture background_rgb -- )" );
	swigFunction( "c-function WebPEncode WebPEncode a a -- n", "FUNCTION: WebPEncode ( config picture -- n )", "EXTERN: \"C\" int WebPEncode( void * config, void * picture );", "	( config picture -- )" );

	swigNewline();

	swigComment("----===< postfix >===-----\n");

	swigPrint( "end-c-library", "( none )", "( none )" );
	
	return 0;
} /* end of main */



