/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 3.0.9
 *
 * This file is not intended to be easily readable and contains a number of
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG
 * interface file instead.
 * ----------------------------------------------------------------------------- */
#include <stdio.h>
#include <string.h>
#include <stddef.h>
#include <math.h> /* required for special case floating point output */

// Do not edit below this line
// end-of-default-includes


#include <wayland-egl.h>
#include <wayland-util.h>
#include <wayland-client-protocol.h>
#include <wayland-cursor.h>
#include <text-input-unstable-v3-client.h>
#include <xdg-shell-client.h>
#include <xdg-decoration-unstable-v1-client.h>
#include <primary-selection-unstable-v1-client.h>
#include <tablet-unstable-v2-client.h>

typedef enum{ NONE = -1, GFORTH = 0, SWIFTFORTH, VFX } SwigTargetSystem;
SwigTargetSystem swigTargetSystem = NONE;

unsigned char swigPrintStackComments = 1;

/* comments */
void swigNewline()
{
	printf( "\n" );
}

void swigComment( char *comment )
{
	printf( "\\ %s", comment );
}

/* generic print */
void swigPrint( char* gforth, char *swiftForth, char *vfx )
{
	if( swigTargetSystem == GFORTH )
		printf( "%s", gforth );
	else if( swigTargetSystem == SWIFTFORTH )
		printf( "%s", swiftForth );
	else if( swigTargetSystem == VFX )
		printf( "%s", vfx );
	printf( "\n" );
}
void swigPrintSystem( SwigTargetSystem targetSystem, char *text )
{
	if( targetSystem == swigTargetSystem )
	    printf( "%s\n", text );
}

/* constants */
void swigIntConstant( long constant, char *name )
{
	printf( "#%ld\tconstant %s\n", constant, name );
}

void swigUnsignedIntConstant( unsigned long constant, char *name )
{
	printf( "#%lu\tconstant %s\n", constant, name );
}

void swigLongConstant( long long constant, char *name )
{
	printf( "#%lld.\t2constant %s\n", constant, name );
}

void swigUnsignedLongConstant( unsigned long long constant, char *name )
{
	printf( "#%llu.\t2constant %s\n", constant, name );
}

void swigFloatConstant( double constant, char *name )
{
	char buffer[128];
	sprintf( buffer, "%f", constant );

	/* if the constant contains no exponent, add one */
	char *s;
	for( s = buffer; *s != 0; s++ )
		if( *s == 'e' || *s == 'E' )
			break;

	/* exponent found */
	if( *s != 0 )
		printf( "%s\tfconstant %s\n", buffer, name );
	/* no exponent */
	else {
		/* special class? */
		int class = fpclassify( constant );
		if( class == FP_INFINITE )
			printf( "%sInf\tfconstant %s\n", constant < 0.0f ? "-" : "+", name );
		else if( class == FP_NAN )
			printf( "NaN\tfconstant %s\n", name );
		else
			/* treat as generic float */
			printf( "%se0\tfconstant %s\n", buffer, name );
        }
}

void swigStringConstant( char* constant, char *name )
{
	char c;
	printf( ": %s s\\\" ", name );
	while(( c = *constant++ ))
	{
		switch(c)
		{
			case '\b': printf( "\\b" ); break;
			case '\n': printf( "\\n" ); break;
			case '\f': printf( "\\f" ); break;
			case '\r': printf( "\\r" ); break;
			case '\t': printf( "\\t" ); break;
			case '"' : printf( "\\q" ); break;
			default:
				if(c < 0x20)
					printf("\\x%02x", c);
				else
					printf("%c", c); break;
		}
	}
	printf(	"\" ;\n" );
}

/* structs */
void swigStructField( char *name, size_t offset, size_t size )
{
	printf( "\tdrop %zu %zu +field %s\n", offset, size, name );
}

/* functions */
void swigFunction( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	if( swigTargetSystem == GFORTH )
		printf( "%s", gforth );
	else if( swigTargetSystem == SWIFTFORTH )
		printf( "%s", swiftForth );
	else if( swigTargetSystem == VFX )
		printf( "%s", vfx );

	if( swigPrintStackComments )
		printf( "%s", stackComment );

	printf( "\n" );
}

/* function pointers */
void swigFunctionPointer( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	swigFunction( gforth, swiftForth, vfx, stackComment );
}

/* callbacks */
void swigCallback( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	swigFunction( gforth, swiftForth, vfx, stackComment );
}

void swigUsage( char **argv )
{
	fprintf( stderr, "Usage: %s [-gforth|-swiftforth|-vfx]\n", argv[0] );
}

int main( int argc, char **argv )
{
	int i;

	/* check arguments */
	for( i = 1; i < argc; i++ )
		if( strcmp( argv[i], "-gforth" ) == 0 )
			swigTargetSystem = GFORTH;
		else if( strcmp( argv[i], "-swiftforth" ) == 0 )
			swigTargetSystem = SWIFTFORTH;
		else if( strcmp( argv[i], "-vfx" ) == 0 )
			swigTargetSystem = VFX;

	if( swigTargetSystem == NONE )
	{
		fprintf( stderr, "Error: no target system specified\n" );
		swigUsage( argv );
		return 1;
	}

	/* primer */
	printf( "\\ This file has been generated using SWIG and fsi,\n"
		"\\ and is already platform dependent, search for the corresponding\n"
		"\\ fsi-file to compile it where no one has compiled it before ;)\n"
		"\\ Forth systems have their own own dynamic loader and don't need addional C-Code.\n"
		"\\ That's why this file will just print normal forth-code once compiled\n"
		"\\ and can be used directly with include or require.\n"
		"\\ As all comments are stripped during the compilation, please\n"
		"\\ insert the copyright notice of the original file here.\n"
	);



	swigNewline();

	swigComment("----===< prefix >===-----\n");

	swigPrint( "c-library wayland\ns\" wayland\" add-lib\n\\c #include <wayland-egl.h>\n\\c #include <wayland-util.h>\n\\c #include <wayland-client-protocol.h>\n\\c #include <wayland-cursor.h>\n\\c #include <text-input-unstable-v3-client.h>\n\\c #include <xdg-shell-client.h>\n\\c #include <xdg-decoration-unstable-v1-client.h>\n\\c #include <primary-selection-unstable-v1-client.h>\n\\c #include <tablet-unstable-v2-client.h>", "( none )", "( none )" );

	swigNewline();

	swigComment("----===< int constants >===-----\n");
	#ifdef WL_MARSHAL_FLAG_DESTROY
		swigIntConstant( WL_MARSHAL_FLAG_DESTROY, "WL_MARSHAL_FLAG_DESTROY" );
	#endif
	#ifdef WL_DISPLAY_SYNC
		swigIntConstant( WL_DISPLAY_SYNC, "WL_DISPLAY_SYNC" );
	#endif
	#ifdef WL_DISPLAY_GET_REGISTRY
		swigIntConstant( WL_DISPLAY_GET_REGISTRY, "WL_DISPLAY_GET_REGISTRY" );
	#endif
	#ifdef WL_DISPLAY_ERROR_SINCE_VERSION
		swigIntConstant( WL_DISPLAY_ERROR_SINCE_VERSION, "WL_DISPLAY_ERROR_SINCE_VERSION" );
	#endif
	#ifdef WL_DISPLAY_DELETE_ID_SINCE_VERSION
		swigIntConstant( WL_DISPLAY_DELETE_ID_SINCE_VERSION, "WL_DISPLAY_DELETE_ID_SINCE_VERSION" );
	#endif
	#ifdef WL_DISPLAY_SYNC_SINCE_VERSION
		swigIntConstant( WL_DISPLAY_SYNC_SINCE_VERSION, "WL_DISPLAY_SYNC_SINCE_VERSION" );
	#endif
	#ifdef WL_DISPLAY_GET_REGISTRY_SINCE_VERSION
		swigIntConstant( WL_DISPLAY_GET_REGISTRY_SINCE_VERSION, "WL_DISPLAY_GET_REGISTRY_SINCE_VERSION" );
	#endif
	#ifdef WL_REGISTRY_BIND
		swigIntConstant( WL_REGISTRY_BIND, "WL_REGISTRY_BIND" );
	#endif
	#ifdef WL_REGISTRY_GLOBAL_SINCE_VERSION
		swigIntConstant( WL_REGISTRY_GLOBAL_SINCE_VERSION, "WL_REGISTRY_GLOBAL_SINCE_VERSION" );
	#endif
	#ifdef WL_REGISTRY_GLOBAL_REMOVE_SINCE_VERSION
		swigIntConstant( WL_REGISTRY_GLOBAL_REMOVE_SINCE_VERSION, "WL_REGISTRY_GLOBAL_REMOVE_SINCE_VERSION" );
	#endif
	#ifdef WL_REGISTRY_BIND_SINCE_VERSION
		swigIntConstant( WL_REGISTRY_BIND_SINCE_VERSION, "WL_REGISTRY_BIND_SINCE_VERSION" );
	#endif
	#ifdef WL_CALLBACK_DONE_SINCE_VERSION
		swigIntConstant( WL_CALLBACK_DONE_SINCE_VERSION, "WL_CALLBACK_DONE_SINCE_VERSION" );
	#endif
	#ifdef WL_COMPOSITOR_CREATE_SURFACE
		swigIntConstant( WL_COMPOSITOR_CREATE_SURFACE, "WL_COMPOSITOR_CREATE_SURFACE" );
	#endif
	#ifdef WL_COMPOSITOR_CREATE_REGION
		swigIntConstant( WL_COMPOSITOR_CREATE_REGION, "WL_COMPOSITOR_CREATE_REGION" );
	#endif
	#ifdef WL_COMPOSITOR_CREATE_SURFACE_SINCE_VERSION
		swigIntConstant( WL_COMPOSITOR_CREATE_SURFACE_SINCE_VERSION, "WL_COMPOSITOR_CREATE_SURFACE_SINCE_VERSION" );
	#endif
	#ifdef WL_COMPOSITOR_CREATE_REGION_SINCE_VERSION
		swigIntConstant( WL_COMPOSITOR_CREATE_REGION_SINCE_VERSION, "WL_COMPOSITOR_CREATE_REGION_SINCE_VERSION" );
	#endif
	#ifdef WL_SHM_POOL_CREATE_BUFFER
		swigIntConstant( WL_SHM_POOL_CREATE_BUFFER, "WL_SHM_POOL_CREATE_BUFFER" );
	#endif
	#ifdef WL_SHM_POOL_DESTROY
		swigIntConstant( WL_SHM_POOL_DESTROY, "WL_SHM_POOL_DESTROY" );
	#endif
	#ifdef WL_SHM_POOL_RESIZE
		swigIntConstant( WL_SHM_POOL_RESIZE, "WL_SHM_POOL_RESIZE" );
	#endif
	#ifdef WL_SHM_POOL_CREATE_BUFFER_SINCE_VERSION
		swigIntConstant( WL_SHM_POOL_CREATE_BUFFER_SINCE_VERSION, "WL_SHM_POOL_CREATE_BUFFER_SINCE_VERSION" );
	#endif
	#ifdef WL_SHM_POOL_DESTROY_SINCE_VERSION
		swigIntConstant( WL_SHM_POOL_DESTROY_SINCE_VERSION, "WL_SHM_POOL_DESTROY_SINCE_VERSION" );
	#endif
	#ifdef WL_SHM_POOL_RESIZE_SINCE_VERSION
		swigIntConstant( WL_SHM_POOL_RESIZE_SINCE_VERSION, "WL_SHM_POOL_RESIZE_SINCE_VERSION" );
	#endif
	#ifdef WL_SHM_CREATE_POOL
		swigIntConstant( WL_SHM_CREATE_POOL, "WL_SHM_CREATE_POOL" );
	#endif
	#ifdef WL_SHM_FORMAT_SINCE_VERSION
		swigIntConstant( WL_SHM_FORMAT_SINCE_VERSION, "WL_SHM_FORMAT_SINCE_VERSION" );
	#endif
	#ifdef WL_SHM_CREATE_POOL_SINCE_VERSION
		swigIntConstant( WL_SHM_CREATE_POOL_SINCE_VERSION, "WL_SHM_CREATE_POOL_SINCE_VERSION" );
	#endif
	#ifdef WL_BUFFER_DESTROY
		swigIntConstant( WL_BUFFER_DESTROY, "WL_BUFFER_DESTROY" );
	#endif
	#ifdef WL_BUFFER_RELEASE_SINCE_VERSION
		swigIntConstant( WL_BUFFER_RELEASE_SINCE_VERSION, "WL_BUFFER_RELEASE_SINCE_VERSION" );
	#endif
	#ifdef WL_BUFFER_DESTROY_SINCE_VERSION
		swigIntConstant( WL_BUFFER_DESTROY_SINCE_VERSION, "WL_BUFFER_DESTROY_SINCE_VERSION" );
	#endif
	#ifdef WL_DATA_OFFER_ACCEPT
		swigIntConstant( WL_DATA_OFFER_ACCEPT, "WL_DATA_OFFER_ACCEPT" );
	#endif
	#ifdef WL_DATA_OFFER_RECEIVE
		swigIntConstant( WL_DATA_OFFER_RECEIVE, "WL_DATA_OFFER_RECEIVE" );
	#endif
	#ifdef WL_DATA_OFFER_DESTROY
		swigIntConstant( WL_DATA_OFFER_DESTROY, "WL_DATA_OFFER_DESTROY" );
	#endif
	#ifdef WL_DATA_OFFER_FINISH
		swigIntConstant( WL_DATA_OFFER_FINISH, "WL_DATA_OFFER_FINISH" );
	#endif
	#ifdef WL_DATA_OFFER_SET_ACTIONS
		swigIntConstant( WL_DATA_OFFER_SET_ACTIONS, "WL_DATA_OFFER_SET_ACTIONS" );
	#endif
	#ifdef WL_DATA_OFFER_OFFER_SINCE_VERSION
		swigIntConstant( WL_DATA_OFFER_OFFER_SINCE_VERSION, "WL_DATA_OFFER_OFFER_SINCE_VERSION" );
	#endif
	#ifdef WL_DATA_OFFER_SOURCE_ACTIONS_SINCE_VERSION
		swigIntConstant( WL_DATA_OFFER_SOURCE_ACTIONS_SINCE_VERSION, "WL_DATA_OFFER_SOURCE_ACTIONS_SINCE_VERSION" );
	#endif
	#ifdef WL_DATA_OFFER_ACTION_SINCE_VERSION
		swigIntConstant( WL_DATA_OFFER_ACTION_SINCE_VERSION, "WL_DATA_OFFER_ACTION_SINCE_VERSION" );
	#endif
	#ifdef WL_DATA_OFFER_ACCEPT_SINCE_VERSION
		swigIntConstant( WL_DATA_OFFER_ACCEPT_SINCE_VERSION, "WL_DATA_OFFER_ACCEPT_SINCE_VERSION" );
	#endif
	#ifdef WL_DATA_OFFER_RECEIVE_SINCE_VERSION
		swigIntConstant( WL_DATA_OFFER_RECEIVE_SINCE_VERSION, "WL_DATA_OFFER_RECEIVE_SINCE_VERSION" );
	#endif
	#ifdef WL_DATA_OFFER_DESTROY_SINCE_VERSION
		swigIntConstant( WL_DATA_OFFER_DESTROY_SINCE_VERSION, "WL_DATA_OFFER_DESTROY_SINCE_VERSION" );
	#endif
	#ifdef WL_DATA_OFFER_FINISH_SINCE_VERSION
		swigIntConstant( WL_DATA_OFFER_FINISH_SINCE_VERSION, "WL_DATA_OFFER_FINISH_SINCE_VERSION" );
	#endif
	#ifdef WL_DATA_OFFER_SET_ACTIONS_SINCE_VERSION
		swigIntConstant( WL_DATA_OFFER_SET_ACTIONS_SINCE_VERSION, "WL_DATA_OFFER_SET_ACTIONS_SINCE_VERSION" );
	#endif
	#ifdef WL_DATA_SOURCE_OFFER
		swigIntConstant( WL_DATA_SOURCE_OFFER, "WL_DATA_SOURCE_OFFER" );
	#endif
	#ifdef WL_DATA_SOURCE_DESTROY
		swigIntConstant( WL_DATA_SOURCE_DESTROY, "WL_DATA_SOURCE_DESTROY" );
	#endif
	#ifdef WL_DATA_SOURCE_SET_ACTIONS
		swigIntConstant( WL_DATA_SOURCE_SET_ACTIONS, "WL_DATA_SOURCE_SET_ACTIONS" );
	#endif
	#ifdef WL_DATA_SOURCE_TARGET_SINCE_VERSION
		swigIntConstant( WL_DATA_SOURCE_TARGET_SINCE_VERSION, "WL_DATA_SOURCE_TARGET_SINCE_VERSION" );
	#endif
	#ifdef WL_DATA_SOURCE_SEND_SINCE_VERSION
		swigIntConstant( WL_DATA_SOURCE_SEND_SINCE_VERSION, "WL_DATA_SOURCE_SEND_SINCE_VERSION" );
	#endif
	#ifdef WL_DATA_SOURCE_CANCELLED_SINCE_VERSION
		swigIntConstant( WL_DATA_SOURCE_CANCELLED_SINCE_VERSION, "WL_DATA_SOURCE_CANCELLED_SINCE_VERSION" );
	#endif
	#ifdef WL_DATA_SOURCE_DND_DROP_PERFORMED_SINCE_VERSION
		swigIntConstant( WL_DATA_SOURCE_DND_DROP_PERFORMED_SINCE_VERSION, "WL_DATA_SOURCE_DND_DROP_PERFORMED_SINCE_VERSION" );
	#endif
	#ifdef WL_DATA_SOURCE_DND_FINISHED_SINCE_VERSION
		swigIntConstant( WL_DATA_SOURCE_DND_FINISHED_SINCE_VERSION, "WL_DATA_SOURCE_DND_FINISHED_SINCE_VERSION" );
	#endif
	#ifdef WL_DATA_SOURCE_ACTION_SINCE_VERSION
		swigIntConstant( WL_DATA_SOURCE_ACTION_SINCE_VERSION, "WL_DATA_SOURCE_ACTION_SINCE_VERSION" );
	#endif
	#ifdef WL_DATA_SOURCE_OFFER_SINCE_VERSION
		swigIntConstant( WL_DATA_SOURCE_OFFER_SINCE_VERSION, "WL_DATA_SOURCE_OFFER_SINCE_VERSION" );
	#endif
	#ifdef WL_DATA_SOURCE_DESTROY_SINCE_VERSION
		swigIntConstant( WL_DATA_SOURCE_DESTROY_SINCE_VERSION, "WL_DATA_SOURCE_DESTROY_SINCE_VERSION" );
	#endif
	#ifdef WL_DATA_SOURCE_SET_ACTIONS_SINCE_VERSION
		swigIntConstant( WL_DATA_SOURCE_SET_ACTIONS_SINCE_VERSION, "WL_DATA_SOURCE_SET_ACTIONS_SINCE_VERSION" );
	#endif
	#ifdef WL_DATA_DEVICE_START_DRAG
		swigIntConstant( WL_DATA_DEVICE_START_DRAG, "WL_DATA_DEVICE_START_DRAG" );
	#endif
	#ifdef WL_DATA_DEVICE_SET_SELECTION
		swigIntConstant( WL_DATA_DEVICE_SET_SELECTION, "WL_DATA_DEVICE_SET_SELECTION" );
	#endif
	#ifdef WL_DATA_DEVICE_RELEASE
		swigIntConstant( WL_DATA_DEVICE_RELEASE, "WL_DATA_DEVICE_RELEASE" );
	#endif
	#ifdef WL_DATA_DEVICE_DATA_OFFER_SINCE_VERSION
		swigIntConstant( WL_DATA_DEVICE_DATA_OFFER_SINCE_VERSION, "WL_DATA_DEVICE_DATA_OFFER_SINCE_VERSION" );
	#endif
	#ifdef WL_DATA_DEVICE_ENTER_SINCE_VERSION
		swigIntConstant( WL_DATA_DEVICE_ENTER_SINCE_VERSION, "WL_DATA_DEVICE_ENTER_SINCE_VERSION" );
	#endif
	#ifdef WL_DATA_DEVICE_LEAVE_SINCE_VERSION
		swigIntConstant( WL_DATA_DEVICE_LEAVE_SINCE_VERSION, "WL_DATA_DEVICE_LEAVE_SINCE_VERSION" );
	#endif
	#ifdef WL_DATA_DEVICE_MOTION_SINCE_VERSION
		swigIntConstant( WL_DATA_DEVICE_MOTION_SINCE_VERSION, "WL_DATA_DEVICE_MOTION_SINCE_VERSION" );
	#endif
	#ifdef WL_DATA_DEVICE_DROP_SINCE_VERSION
		swigIntConstant( WL_DATA_DEVICE_DROP_SINCE_VERSION, "WL_DATA_DEVICE_DROP_SINCE_VERSION" );
	#endif
	#ifdef WL_DATA_DEVICE_SELECTION_SINCE_VERSION
		swigIntConstant( WL_DATA_DEVICE_SELECTION_SINCE_VERSION, "WL_DATA_DEVICE_SELECTION_SINCE_VERSION" );
	#endif
	#ifdef WL_DATA_DEVICE_START_DRAG_SINCE_VERSION
		swigIntConstant( WL_DATA_DEVICE_START_DRAG_SINCE_VERSION, "WL_DATA_DEVICE_START_DRAG_SINCE_VERSION" );
	#endif
	#ifdef WL_DATA_DEVICE_SET_SELECTION_SINCE_VERSION
		swigIntConstant( WL_DATA_DEVICE_SET_SELECTION_SINCE_VERSION, "WL_DATA_DEVICE_SET_SELECTION_SINCE_VERSION" );
	#endif
	#ifdef WL_DATA_DEVICE_RELEASE_SINCE_VERSION
		swigIntConstant( WL_DATA_DEVICE_RELEASE_SINCE_VERSION, "WL_DATA_DEVICE_RELEASE_SINCE_VERSION" );
	#endif
	#ifdef WL_DATA_DEVICE_MANAGER_CREATE_DATA_SOURCE
		swigIntConstant( WL_DATA_DEVICE_MANAGER_CREATE_DATA_SOURCE, "WL_DATA_DEVICE_MANAGER_CREATE_DATA_SOURCE" );
	#endif
	#ifdef WL_DATA_DEVICE_MANAGER_GET_DATA_DEVICE
		swigIntConstant( WL_DATA_DEVICE_MANAGER_GET_DATA_DEVICE, "WL_DATA_DEVICE_MANAGER_GET_DATA_DEVICE" );
	#endif
	#ifdef WL_DATA_DEVICE_MANAGER_CREATE_DATA_SOURCE_SINCE_VERSION
		swigIntConstant( WL_DATA_DEVICE_MANAGER_CREATE_DATA_SOURCE_SINCE_VERSION, "WL_DATA_DEVICE_MANAGER_CREATE_DATA_SOURCE_SINCE_VERSION" );
	#endif
	#ifdef WL_DATA_DEVICE_MANAGER_GET_DATA_DEVICE_SINCE_VERSION
		swigIntConstant( WL_DATA_DEVICE_MANAGER_GET_DATA_DEVICE_SINCE_VERSION, "WL_DATA_DEVICE_MANAGER_GET_DATA_DEVICE_SINCE_VERSION" );
	#endif
	#ifdef WL_SHELL_GET_SHELL_SURFACE
		swigIntConstant( WL_SHELL_GET_SHELL_SURFACE, "WL_SHELL_GET_SHELL_SURFACE" );
	#endif
	#ifdef WL_SHELL_GET_SHELL_SURFACE_SINCE_VERSION
		swigIntConstant( WL_SHELL_GET_SHELL_SURFACE_SINCE_VERSION, "WL_SHELL_GET_SHELL_SURFACE_SINCE_VERSION" );
	#endif
	#ifdef WL_SHELL_SURFACE_PONG
		swigIntConstant( WL_SHELL_SURFACE_PONG, "WL_SHELL_SURFACE_PONG" );
	#endif
	#ifdef WL_SHELL_SURFACE_MOVE
		swigIntConstant( WL_SHELL_SURFACE_MOVE, "WL_SHELL_SURFACE_MOVE" );
	#endif
	#ifdef WL_SHELL_SURFACE_RESIZE
		swigIntConstant( WL_SHELL_SURFACE_RESIZE, "WL_SHELL_SURFACE_RESIZE" );
	#endif
	#ifdef WL_SHELL_SURFACE_SET_TOPLEVEL
		swigIntConstant( WL_SHELL_SURFACE_SET_TOPLEVEL, "WL_SHELL_SURFACE_SET_TOPLEVEL" );
	#endif
	#ifdef WL_SHELL_SURFACE_SET_TRANSIENT
		swigIntConstant( WL_SHELL_SURFACE_SET_TRANSIENT, "WL_SHELL_SURFACE_SET_TRANSIENT" );
	#endif
	#ifdef WL_SHELL_SURFACE_SET_FULLSCREEN
		swigIntConstant( WL_SHELL_SURFACE_SET_FULLSCREEN, "WL_SHELL_SURFACE_SET_FULLSCREEN" );
	#endif
	#ifdef WL_SHELL_SURFACE_SET_POPUP
		swigIntConstant( WL_SHELL_SURFACE_SET_POPUP, "WL_SHELL_SURFACE_SET_POPUP" );
	#endif
	#ifdef WL_SHELL_SURFACE_SET_MAXIMIZED
		swigIntConstant( WL_SHELL_SURFACE_SET_MAXIMIZED, "WL_SHELL_SURFACE_SET_MAXIMIZED" );
	#endif
	#ifdef WL_SHELL_SURFACE_SET_TITLE
		swigIntConstant( WL_SHELL_SURFACE_SET_TITLE, "WL_SHELL_SURFACE_SET_TITLE" );
	#endif
	#ifdef WL_SHELL_SURFACE_SET_CLASS
		swigIntConstant( WL_SHELL_SURFACE_SET_CLASS, "WL_SHELL_SURFACE_SET_CLASS" );
	#endif
	#ifdef WL_SHELL_SURFACE_PING_SINCE_VERSION
		swigIntConstant( WL_SHELL_SURFACE_PING_SINCE_VERSION, "WL_SHELL_SURFACE_PING_SINCE_VERSION" );
	#endif
	#ifdef WL_SHELL_SURFACE_CONFIGURE_SINCE_VERSION
		swigIntConstant( WL_SHELL_SURFACE_CONFIGURE_SINCE_VERSION, "WL_SHELL_SURFACE_CONFIGURE_SINCE_VERSION" );
	#endif
	#ifdef WL_SHELL_SURFACE_POPUP_DONE_SINCE_VERSION
		swigIntConstant( WL_SHELL_SURFACE_POPUP_DONE_SINCE_VERSION, "WL_SHELL_SURFACE_POPUP_DONE_SINCE_VERSION" );
	#endif
	#ifdef WL_SHELL_SURFACE_PONG_SINCE_VERSION
		swigIntConstant( WL_SHELL_SURFACE_PONG_SINCE_VERSION, "WL_SHELL_SURFACE_PONG_SINCE_VERSION" );
	#endif
	#ifdef WL_SHELL_SURFACE_MOVE_SINCE_VERSION
		swigIntConstant( WL_SHELL_SURFACE_MOVE_SINCE_VERSION, "WL_SHELL_SURFACE_MOVE_SINCE_VERSION" );
	#endif
	#ifdef WL_SHELL_SURFACE_RESIZE_SINCE_VERSION
		swigIntConstant( WL_SHELL_SURFACE_RESIZE_SINCE_VERSION, "WL_SHELL_SURFACE_RESIZE_SINCE_VERSION" );
	#endif
	#ifdef WL_SHELL_SURFACE_SET_TOPLEVEL_SINCE_VERSION
		swigIntConstant( WL_SHELL_SURFACE_SET_TOPLEVEL_SINCE_VERSION, "WL_SHELL_SURFACE_SET_TOPLEVEL_SINCE_VERSION" );
	#endif
	#ifdef WL_SHELL_SURFACE_SET_TRANSIENT_SINCE_VERSION
		swigIntConstant( WL_SHELL_SURFACE_SET_TRANSIENT_SINCE_VERSION, "WL_SHELL_SURFACE_SET_TRANSIENT_SINCE_VERSION" );
	#endif
	#ifdef WL_SHELL_SURFACE_SET_FULLSCREEN_SINCE_VERSION
		swigIntConstant( WL_SHELL_SURFACE_SET_FULLSCREEN_SINCE_VERSION, "WL_SHELL_SURFACE_SET_FULLSCREEN_SINCE_VERSION" );
	#endif
	#ifdef WL_SHELL_SURFACE_SET_POPUP_SINCE_VERSION
		swigIntConstant( WL_SHELL_SURFACE_SET_POPUP_SINCE_VERSION, "WL_SHELL_SURFACE_SET_POPUP_SINCE_VERSION" );
	#endif
	#ifdef WL_SHELL_SURFACE_SET_MAXIMIZED_SINCE_VERSION
		swigIntConstant( WL_SHELL_SURFACE_SET_MAXIMIZED_SINCE_VERSION, "WL_SHELL_SURFACE_SET_MAXIMIZED_SINCE_VERSION" );
	#endif
	#ifdef WL_SHELL_SURFACE_SET_TITLE_SINCE_VERSION
		swigIntConstant( WL_SHELL_SURFACE_SET_TITLE_SINCE_VERSION, "WL_SHELL_SURFACE_SET_TITLE_SINCE_VERSION" );
	#endif
	#ifdef WL_SHELL_SURFACE_SET_CLASS_SINCE_VERSION
		swigIntConstant( WL_SHELL_SURFACE_SET_CLASS_SINCE_VERSION, "WL_SHELL_SURFACE_SET_CLASS_SINCE_VERSION" );
	#endif
	#ifdef WL_SURFACE_DESTROY
		swigIntConstant( WL_SURFACE_DESTROY, "WL_SURFACE_DESTROY" );
	#endif
	#ifdef WL_SURFACE_ATTACH
		swigIntConstant( WL_SURFACE_ATTACH, "WL_SURFACE_ATTACH" );
	#endif
	#ifdef WL_SURFACE_DAMAGE
		swigIntConstant( WL_SURFACE_DAMAGE, "WL_SURFACE_DAMAGE" );
	#endif
	#ifdef WL_SURFACE_FRAME
		swigIntConstant( WL_SURFACE_FRAME, "WL_SURFACE_FRAME" );
	#endif
	#ifdef WL_SURFACE_SET_OPAQUE_REGION
		swigIntConstant( WL_SURFACE_SET_OPAQUE_REGION, "WL_SURFACE_SET_OPAQUE_REGION" );
	#endif
	#ifdef WL_SURFACE_SET_INPUT_REGION
		swigIntConstant( WL_SURFACE_SET_INPUT_REGION, "WL_SURFACE_SET_INPUT_REGION" );
	#endif
	#ifdef WL_SURFACE_COMMIT
		swigIntConstant( WL_SURFACE_COMMIT, "WL_SURFACE_COMMIT" );
	#endif
	#ifdef WL_SURFACE_SET_BUFFER_TRANSFORM
		swigIntConstant( WL_SURFACE_SET_BUFFER_TRANSFORM, "WL_SURFACE_SET_BUFFER_TRANSFORM" );
	#endif
	#ifdef WL_SURFACE_SET_BUFFER_SCALE
		swigIntConstant( WL_SURFACE_SET_BUFFER_SCALE, "WL_SURFACE_SET_BUFFER_SCALE" );
	#endif
	#ifdef WL_SURFACE_DAMAGE_BUFFER
		swigIntConstant( WL_SURFACE_DAMAGE_BUFFER, "WL_SURFACE_DAMAGE_BUFFER" );
	#endif
	#ifdef WL_SURFACE_OFFSET
		swigIntConstant( WL_SURFACE_OFFSET, "WL_SURFACE_OFFSET" );
	#endif
	#ifdef WL_SURFACE_ENTER_SINCE_VERSION
		swigIntConstant( WL_SURFACE_ENTER_SINCE_VERSION, "WL_SURFACE_ENTER_SINCE_VERSION" );
	#endif
	#ifdef WL_SURFACE_LEAVE_SINCE_VERSION
		swigIntConstant( WL_SURFACE_LEAVE_SINCE_VERSION, "WL_SURFACE_LEAVE_SINCE_VERSION" );
	#endif
	#ifdef WL_SURFACE_PREFERRED_BUFFER_SCALE_SINCE_VERSION
		swigIntConstant( WL_SURFACE_PREFERRED_BUFFER_SCALE_SINCE_VERSION, "WL_SURFACE_PREFERRED_BUFFER_SCALE_SINCE_VERSION" );
	#endif
	#ifdef WL_SURFACE_PREFERRED_BUFFER_TRANSFORM_SINCE_VERSION
		swigIntConstant( WL_SURFACE_PREFERRED_BUFFER_TRANSFORM_SINCE_VERSION, "WL_SURFACE_PREFERRED_BUFFER_TRANSFORM_SINCE_VERSION" );
	#endif
	#ifdef WL_SURFACE_DESTROY_SINCE_VERSION
		swigIntConstant( WL_SURFACE_DESTROY_SINCE_VERSION, "WL_SURFACE_DESTROY_SINCE_VERSION" );
	#endif
	#ifdef WL_SURFACE_ATTACH_SINCE_VERSION
		swigIntConstant( WL_SURFACE_ATTACH_SINCE_VERSION, "WL_SURFACE_ATTACH_SINCE_VERSION" );
	#endif
	#ifdef WL_SURFACE_DAMAGE_SINCE_VERSION
		swigIntConstant( WL_SURFACE_DAMAGE_SINCE_VERSION, "WL_SURFACE_DAMAGE_SINCE_VERSION" );
	#endif
	#ifdef WL_SURFACE_FRAME_SINCE_VERSION
		swigIntConstant( WL_SURFACE_FRAME_SINCE_VERSION, "WL_SURFACE_FRAME_SINCE_VERSION" );
	#endif
	#ifdef WL_SURFACE_SET_OPAQUE_REGION_SINCE_VERSION
		swigIntConstant( WL_SURFACE_SET_OPAQUE_REGION_SINCE_VERSION, "WL_SURFACE_SET_OPAQUE_REGION_SINCE_VERSION" );
	#endif
	#ifdef WL_SURFACE_SET_INPUT_REGION_SINCE_VERSION
		swigIntConstant( WL_SURFACE_SET_INPUT_REGION_SINCE_VERSION, "WL_SURFACE_SET_INPUT_REGION_SINCE_VERSION" );
	#endif
	#ifdef WL_SURFACE_COMMIT_SINCE_VERSION
		swigIntConstant( WL_SURFACE_COMMIT_SINCE_VERSION, "WL_SURFACE_COMMIT_SINCE_VERSION" );
	#endif
	#ifdef WL_SURFACE_SET_BUFFER_TRANSFORM_SINCE_VERSION
		swigIntConstant( WL_SURFACE_SET_BUFFER_TRANSFORM_SINCE_VERSION, "WL_SURFACE_SET_BUFFER_TRANSFORM_SINCE_VERSION" );
	#endif
	#ifdef WL_SURFACE_SET_BUFFER_SCALE_SINCE_VERSION
		swigIntConstant( WL_SURFACE_SET_BUFFER_SCALE_SINCE_VERSION, "WL_SURFACE_SET_BUFFER_SCALE_SINCE_VERSION" );
	#endif
	#ifdef WL_SURFACE_DAMAGE_BUFFER_SINCE_VERSION
		swigIntConstant( WL_SURFACE_DAMAGE_BUFFER_SINCE_VERSION, "WL_SURFACE_DAMAGE_BUFFER_SINCE_VERSION" );
	#endif
	#ifdef WL_SURFACE_OFFSET_SINCE_VERSION
		swigIntConstant( WL_SURFACE_OFFSET_SINCE_VERSION, "WL_SURFACE_OFFSET_SINCE_VERSION" );
	#endif
	#ifdef WL_SEAT_GET_POINTER
		swigIntConstant( WL_SEAT_GET_POINTER, "WL_SEAT_GET_POINTER" );
	#endif
	#ifdef WL_SEAT_GET_KEYBOARD
		swigIntConstant( WL_SEAT_GET_KEYBOARD, "WL_SEAT_GET_KEYBOARD" );
	#endif
	#ifdef WL_SEAT_GET_TOUCH
		swigIntConstant( WL_SEAT_GET_TOUCH, "WL_SEAT_GET_TOUCH" );
	#endif
	#ifdef WL_SEAT_RELEASE
		swigIntConstant( WL_SEAT_RELEASE, "WL_SEAT_RELEASE" );
	#endif
	#ifdef WL_SEAT_CAPABILITIES_SINCE_VERSION
		swigIntConstant( WL_SEAT_CAPABILITIES_SINCE_VERSION, "WL_SEAT_CAPABILITIES_SINCE_VERSION" );
	#endif
	#ifdef WL_SEAT_NAME_SINCE_VERSION
		swigIntConstant( WL_SEAT_NAME_SINCE_VERSION, "WL_SEAT_NAME_SINCE_VERSION" );
	#endif
	#ifdef WL_SEAT_GET_POINTER_SINCE_VERSION
		swigIntConstant( WL_SEAT_GET_POINTER_SINCE_VERSION, "WL_SEAT_GET_POINTER_SINCE_VERSION" );
	#endif
	#ifdef WL_SEAT_GET_KEYBOARD_SINCE_VERSION
		swigIntConstant( WL_SEAT_GET_KEYBOARD_SINCE_VERSION, "WL_SEAT_GET_KEYBOARD_SINCE_VERSION" );
	#endif
	#ifdef WL_SEAT_GET_TOUCH_SINCE_VERSION
		swigIntConstant( WL_SEAT_GET_TOUCH_SINCE_VERSION, "WL_SEAT_GET_TOUCH_SINCE_VERSION" );
	#endif
	#ifdef WL_SEAT_RELEASE_SINCE_VERSION
		swigIntConstant( WL_SEAT_RELEASE_SINCE_VERSION, "WL_SEAT_RELEASE_SINCE_VERSION" );
	#endif
	#ifdef WL_POINTER_AXIS_SOURCE_WHEEL_TILT_SINCE_VERSION
		swigIntConstant( WL_POINTER_AXIS_SOURCE_WHEEL_TILT_SINCE_VERSION, "WL_POINTER_AXIS_SOURCE_WHEEL_TILT_SINCE_VERSION" );
	#endif
	#ifdef WL_POINTER_SET_CURSOR
		swigIntConstant( WL_POINTER_SET_CURSOR, "WL_POINTER_SET_CURSOR" );
	#endif
	#ifdef WL_POINTER_RELEASE
		swigIntConstant( WL_POINTER_RELEASE, "WL_POINTER_RELEASE" );
	#endif
	#ifdef WL_POINTER_ENTER_SINCE_VERSION
		swigIntConstant( WL_POINTER_ENTER_SINCE_VERSION, "WL_POINTER_ENTER_SINCE_VERSION" );
	#endif
	#ifdef WL_POINTER_LEAVE_SINCE_VERSION
		swigIntConstant( WL_POINTER_LEAVE_SINCE_VERSION, "WL_POINTER_LEAVE_SINCE_VERSION" );
	#endif
	#ifdef WL_POINTER_MOTION_SINCE_VERSION
		swigIntConstant( WL_POINTER_MOTION_SINCE_VERSION, "WL_POINTER_MOTION_SINCE_VERSION" );
	#endif
	#ifdef WL_POINTER_BUTTON_SINCE_VERSION
		swigIntConstant( WL_POINTER_BUTTON_SINCE_VERSION, "WL_POINTER_BUTTON_SINCE_VERSION" );
	#endif
	#ifdef WL_POINTER_AXIS_SINCE_VERSION
		swigIntConstant( WL_POINTER_AXIS_SINCE_VERSION, "WL_POINTER_AXIS_SINCE_VERSION" );
	#endif
	#ifdef WL_POINTER_FRAME_SINCE_VERSION
		swigIntConstant( WL_POINTER_FRAME_SINCE_VERSION, "WL_POINTER_FRAME_SINCE_VERSION" );
	#endif
	#ifdef WL_POINTER_AXIS_SOURCE_SINCE_VERSION
		swigIntConstant( WL_POINTER_AXIS_SOURCE_SINCE_VERSION, "WL_POINTER_AXIS_SOURCE_SINCE_VERSION" );
	#endif
	#ifdef WL_POINTER_AXIS_STOP_SINCE_VERSION
		swigIntConstant( WL_POINTER_AXIS_STOP_SINCE_VERSION, "WL_POINTER_AXIS_STOP_SINCE_VERSION" );
	#endif
	#ifdef WL_POINTER_AXIS_DISCRETE_SINCE_VERSION
		swigIntConstant( WL_POINTER_AXIS_DISCRETE_SINCE_VERSION, "WL_POINTER_AXIS_DISCRETE_SINCE_VERSION" );
	#endif
	#ifdef WL_POINTER_AXIS_VALUE120_SINCE_VERSION
		swigIntConstant( WL_POINTER_AXIS_VALUE120_SINCE_VERSION, "WL_POINTER_AXIS_VALUE120_SINCE_VERSION" );
	#endif
	#ifdef WL_POINTER_AXIS_RELATIVE_DIRECTION_SINCE_VERSION
		swigIntConstant( WL_POINTER_AXIS_RELATIVE_DIRECTION_SINCE_VERSION, "WL_POINTER_AXIS_RELATIVE_DIRECTION_SINCE_VERSION" );
	#endif
	#ifdef WL_POINTER_SET_CURSOR_SINCE_VERSION
		swigIntConstant( WL_POINTER_SET_CURSOR_SINCE_VERSION, "WL_POINTER_SET_CURSOR_SINCE_VERSION" );
	#endif
	#ifdef WL_POINTER_RELEASE_SINCE_VERSION
		swigIntConstant( WL_POINTER_RELEASE_SINCE_VERSION, "WL_POINTER_RELEASE_SINCE_VERSION" );
	#endif
	#ifdef WL_KEYBOARD_RELEASE
		swigIntConstant( WL_KEYBOARD_RELEASE, "WL_KEYBOARD_RELEASE" );
	#endif
	#ifdef WL_KEYBOARD_KEYMAP_SINCE_VERSION
		swigIntConstant( WL_KEYBOARD_KEYMAP_SINCE_VERSION, "WL_KEYBOARD_KEYMAP_SINCE_VERSION" );
	#endif
	#ifdef WL_KEYBOARD_ENTER_SINCE_VERSION
		swigIntConstant( WL_KEYBOARD_ENTER_SINCE_VERSION, "WL_KEYBOARD_ENTER_SINCE_VERSION" );
	#endif
	#ifdef WL_KEYBOARD_LEAVE_SINCE_VERSION
		swigIntConstant( WL_KEYBOARD_LEAVE_SINCE_VERSION, "WL_KEYBOARD_LEAVE_SINCE_VERSION" );
	#endif
	#ifdef WL_KEYBOARD_KEY_SINCE_VERSION
		swigIntConstant( WL_KEYBOARD_KEY_SINCE_VERSION, "WL_KEYBOARD_KEY_SINCE_VERSION" );
	#endif
	#ifdef WL_KEYBOARD_MODIFIERS_SINCE_VERSION
		swigIntConstant( WL_KEYBOARD_MODIFIERS_SINCE_VERSION, "WL_KEYBOARD_MODIFIERS_SINCE_VERSION" );
	#endif
	#ifdef WL_KEYBOARD_REPEAT_INFO_SINCE_VERSION
		swigIntConstant( WL_KEYBOARD_REPEAT_INFO_SINCE_VERSION, "WL_KEYBOARD_REPEAT_INFO_SINCE_VERSION" );
	#endif
	#ifdef WL_KEYBOARD_RELEASE_SINCE_VERSION
		swigIntConstant( WL_KEYBOARD_RELEASE_SINCE_VERSION, "WL_KEYBOARD_RELEASE_SINCE_VERSION" );
	#endif
	#ifdef WL_TOUCH_RELEASE
		swigIntConstant( WL_TOUCH_RELEASE, "WL_TOUCH_RELEASE" );
	#endif
	#ifdef WL_TOUCH_DOWN_SINCE_VERSION
		swigIntConstant( WL_TOUCH_DOWN_SINCE_VERSION, "WL_TOUCH_DOWN_SINCE_VERSION" );
	#endif
	#ifdef WL_TOUCH_UP_SINCE_VERSION
		swigIntConstant( WL_TOUCH_UP_SINCE_VERSION, "WL_TOUCH_UP_SINCE_VERSION" );
	#endif
	#ifdef WL_TOUCH_MOTION_SINCE_VERSION
		swigIntConstant( WL_TOUCH_MOTION_SINCE_VERSION, "WL_TOUCH_MOTION_SINCE_VERSION" );
	#endif
	#ifdef WL_TOUCH_FRAME_SINCE_VERSION
		swigIntConstant( WL_TOUCH_FRAME_SINCE_VERSION, "WL_TOUCH_FRAME_SINCE_VERSION" );
	#endif
	#ifdef WL_TOUCH_CANCEL_SINCE_VERSION
		swigIntConstant( WL_TOUCH_CANCEL_SINCE_VERSION, "WL_TOUCH_CANCEL_SINCE_VERSION" );
	#endif
	#ifdef WL_TOUCH_SHAPE_SINCE_VERSION
		swigIntConstant( WL_TOUCH_SHAPE_SINCE_VERSION, "WL_TOUCH_SHAPE_SINCE_VERSION" );
	#endif
	#ifdef WL_TOUCH_ORIENTATION_SINCE_VERSION
		swigIntConstant( WL_TOUCH_ORIENTATION_SINCE_VERSION, "WL_TOUCH_ORIENTATION_SINCE_VERSION" );
	#endif
	#ifdef WL_TOUCH_RELEASE_SINCE_VERSION
		swigIntConstant( WL_TOUCH_RELEASE_SINCE_VERSION, "WL_TOUCH_RELEASE_SINCE_VERSION" );
	#endif
	#ifdef WL_OUTPUT_RELEASE
		swigIntConstant( WL_OUTPUT_RELEASE, "WL_OUTPUT_RELEASE" );
	#endif
	#ifdef WL_OUTPUT_GEOMETRY_SINCE_VERSION
		swigIntConstant( WL_OUTPUT_GEOMETRY_SINCE_VERSION, "WL_OUTPUT_GEOMETRY_SINCE_VERSION" );
	#endif
	#ifdef WL_OUTPUT_MODE_SINCE_VERSION
		swigIntConstant( WL_OUTPUT_MODE_SINCE_VERSION, "WL_OUTPUT_MODE_SINCE_VERSION" );
	#endif
	#ifdef WL_OUTPUT_DONE_SINCE_VERSION
		swigIntConstant( WL_OUTPUT_DONE_SINCE_VERSION, "WL_OUTPUT_DONE_SINCE_VERSION" );
	#endif
	#ifdef WL_OUTPUT_SCALE_SINCE_VERSION
		swigIntConstant( WL_OUTPUT_SCALE_SINCE_VERSION, "WL_OUTPUT_SCALE_SINCE_VERSION" );
	#endif
	#ifdef WL_OUTPUT_NAME_SINCE_VERSION
		swigIntConstant( WL_OUTPUT_NAME_SINCE_VERSION, "WL_OUTPUT_NAME_SINCE_VERSION" );
	#endif
	#ifdef WL_OUTPUT_DESCRIPTION_SINCE_VERSION
		swigIntConstant( WL_OUTPUT_DESCRIPTION_SINCE_VERSION, "WL_OUTPUT_DESCRIPTION_SINCE_VERSION" );
	#endif
	#ifdef WL_OUTPUT_RELEASE_SINCE_VERSION
		swigIntConstant( WL_OUTPUT_RELEASE_SINCE_VERSION, "WL_OUTPUT_RELEASE_SINCE_VERSION" );
	#endif
	#ifdef WL_REGION_DESTROY
		swigIntConstant( WL_REGION_DESTROY, "WL_REGION_DESTROY" );
	#endif
	#ifdef WL_REGION_ADD
		swigIntConstant( WL_REGION_ADD, "WL_REGION_ADD" );
	#endif
	#ifdef WL_REGION_SUBTRACT
		swigIntConstant( WL_REGION_SUBTRACT, "WL_REGION_SUBTRACT" );
	#endif
	#ifdef WL_REGION_DESTROY_SINCE_VERSION
		swigIntConstant( WL_REGION_DESTROY_SINCE_VERSION, "WL_REGION_DESTROY_SINCE_VERSION" );
	#endif
	#ifdef WL_REGION_ADD_SINCE_VERSION
		swigIntConstant( WL_REGION_ADD_SINCE_VERSION, "WL_REGION_ADD_SINCE_VERSION" );
	#endif
	#ifdef WL_REGION_SUBTRACT_SINCE_VERSION
		swigIntConstant( WL_REGION_SUBTRACT_SINCE_VERSION, "WL_REGION_SUBTRACT_SINCE_VERSION" );
	#endif
	#ifdef WL_SUBCOMPOSITOR_DESTROY
		swigIntConstant( WL_SUBCOMPOSITOR_DESTROY, "WL_SUBCOMPOSITOR_DESTROY" );
	#endif
	#ifdef WL_SUBCOMPOSITOR_GET_SUBSURFACE
		swigIntConstant( WL_SUBCOMPOSITOR_GET_SUBSURFACE, "WL_SUBCOMPOSITOR_GET_SUBSURFACE" );
	#endif
	#ifdef WL_SUBCOMPOSITOR_DESTROY_SINCE_VERSION
		swigIntConstant( WL_SUBCOMPOSITOR_DESTROY_SINCE_VERSION, "WL_SUBCOMPOSITOR_DESTROY_SINCE_VERSION" );
	#endif
	#ifdef WL_SUBCOMPOSITOR_GET_SUBSURFACE_SINCE_VERSION
		swigIntConstant( WL_SUBCOMPOSITOR_GET_SUBSURFACE_SINCE_VERSION, "WL_SUBCOMPOSITOR_GET_SUBSURFACE_SINCE_VERSION" );
	#endif
	#ifdef WL_SUBSURFACE_DESTROY
		swigIntConstant( WL_SUBSURFACE_DESTROY, "WL_SUBSURFACE_DESTROY" );
	#endif
	#ifdef WL_SUBSURFACE_SET_POSITION
		swigIntConstant( WL_SUBSURFACE_SET_POSITION, "WL_SUBSURFACE_SET_POSITION" );
	#endif
	#ifdef WL_SUBSURFACE_PLACE_ABOVE
		swigIntConstant( WL_SUBSURFACE_PLACE_ABOVE, "WL_SUBSURFACE_PLACE_ABOVE" );
	#endif
	#ifdef WL_SUBSURFACE_PLACE_BELOW
		swigIntConstant( WL_SUBSURFACE_PLACE_BELOW, "WL_SUBSURFACE_PLACE_BELOW" );
	#endif
	#ifdef WL_SUBSURFACE_SET_SYNC
		swigIntConstant( WL_SUBSURFACE_SET_SYNC, "WL_SUBSURFACE_SET_SYNC" );
	#endif
	#ifdef WL_SUBSURFACE_SET_DESYNC
		swigIntConstant( WL_SUBSURFACE_SET_DESYNC, "WL_SUBSURFACE_SET_DESYNC" );
	#endif
	#ifdef WL_SUBSURFACE_DESTROY_SINCE_VERSION
		swigIntConstant( WL_SUBSURFACE_DESTROY_SINCE_VERSION, "WL_SUBSURFACE_DESTROY_SINCE_VERSION" );
	#endif
	#ifdef WL_SUBSURFACE_SET_POSITION_SINCE_VERSION
		swigIntConstant( WL_SUBSURFACE_SET_POSITION_SINCE_VERSION, "WL_SUBSURFACE_SET_POSITION_SINCE_VERSION" );
	#endif
	#ifdef WL_SUBSURFACE_PLACE_ABOVE_SINCE_VERSION
		swigIntConstant( WL_SUBSURFACE_PLACE_ABOVE_SINCE_VERSION, "WL_SUBSURFACE_PLACE_ABOVE_SINCE_VERSION" );
	#endif
	#ifdef WL_SUBSURFACE_PLACE_BELOW_SINCE_VERSION
		swigIntConstant( WL_SUBSURFACE_PLACE_BELOW_SINCE_VERSION, "WL_SUBSURFACE_PLACE_BELOW_SINCE_VERSION" );
	#endif
	#ifdef WL_SUBSURFACE_SET_SYNC_SINCE_VERSION
		swigIntConstant( WL_SUBSURFACE_SET_SYNC_SINCE_VERSION, "WL_SUBSURFACE_SET_SYNC_SINCE_VERSION" );
	#endif
	#ifdef WL_SUBSURFACE_SET_DESYNC_SINCE_VERSION
		swigIntConstant( WL_SUBSURFACE_SET_DESYNC_SINCE_VERSION, "WL_SUBSURFACE_SET_DESYNC_SINCE_VERSION" );
	#endif
	#ifdef WL_EGL_PLATFORM
		swigIntConstant( WL_EGL_PLATFORM, "WL_EGL_PLATFORM" );
	#endif
	#ifdef ZWP_TEXT_INPUT_V3_DESTROY
		swigIntConstant( ZWP_TEXT_INPUT_V3_DESTROY, "ZWP_TEXT_INPUT_V3_DESTROY" );
	#endif
	#ifdef ZWP_TEXT_INPUT_V3_ENABLE
		swigIntConstant( ZWP_TEXT_INPUT_V3_ENABLE, "ZWP_TEXT_INPUT_V3_ENABLE" );
	#endif
	#ifdef ZWP_TEXT_INPUT_V3_DISABLE
		swigIntConstant( ZWP_TEXT_INPUT_V3_DISABLE, "ZWP_TEXT_INPUT_V3_DISABLE" );
	#endif
	#ifdef ZWP_TEXT_INPUT_V3_SET_SURROUNDING_TEXT
		swigIntConstant( ZWP_TEXT_INPUT_V3_SET_SURROUNDING_TEXT, "ZWP_TEXT_INPUT_V3_SET_SURROUNDING_TEXT" );
	#endif
	#ifdef ZWP_TEXT_INPUT_V3_SET_TEXT_CHANGE_CAUSE
		swigIntConstant( ZWP_TEXT_INPUT_V3_SET_TEXT_CHANGE_CAUSE, "ZWP_TEXT_INPUT_V3_SET_TEXT_CHANGE_CAUSE" );
	#endif
	#ifdef ZWP_TEXT_INPUT_V3_SET_CONTENT_TYPE
		swigIntConstant( ZWP_TEXT_INPUT_V3_SET_CONTENT_TYPE, "ZWP_TEXT_INPUT_V3_SET_CONTENT_TYPE" );
	#endif
	#ifdef ZWP_TEXT_INPUT_V3_SET_CURSOR_RECTANGLE
		swigIntConstant( ZWP_TEXT_INPUT_V3_SET_CURSOR_RECTANGLE, "ZWP_TEXT_INPUT_V3_SET_CURSOR_RECTANGLE" );
	#endif
	#ifdef ZWP_TEXT_INPUT_V3_COMMIT
		swigIntConstant( ZWP_TEXT_INPUT_V3_COMMIT, "ZWP_TEXT_INPUT_V3_COMMIT" );
	#endif
	#ifdef ZWP_TEXT_INPUT_V3_ENTER_SINCE_VERSION
		swigIntConstant( ZWP_TEXT_INPUT_V3_ENTER_SINCE_VERSION, "ZWP_TEXT_INPUT_V3_ENTER_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TEXT_INPUT_V3_LEAVE_SINCE_VERSION
		swigIntConstant( ZWP_TEXT_INPUT_V3_LEAVE_SINCE_VERSION, "ZWP_TEXT_INPUT_V3_LEAVE_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TEXT_INPUT_V3_PREEDIT_STRING_SINCE_VERSION
		swigIntConstant( ZWP_TEXT_INPUT_V3_PREEDIT_STRING_SINCE_VERSION, "ZWP_TEXT_INPUT_V3_PREEDIT_STRING_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TEXT_INPUT_V3_COMMIT_STRING_SINCE_VERSION
		swigIntConstant( ZWP_TEXT_INPUT_V3_COMMIT_STRING_SINCE_VERSION, "ZWP_TEXT_INPUT_V3_COMMIT_STRING_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TEXT_INPUT_V3_DELETE_SURROUNDING_TEXT_SINCE_VERSION
		swigIntConstant( ZWP_TEXT_INPUT_V3_DELETE_SURROUNDING_TEXT_SINCE_VERSION, "ZWP_TEXT_INPUT_V3_DELETE_SURROUNDING_TEXT_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TEXT_INPUT_V3_DONE_SINCE_VERSION
		swigIntConstant( ZWP_TEXT_INPUT_V3_DONE_SINCE_VERSION, "ZWP_TEXT_INPUT_V3_DONE_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TEXT_INPUT_V3_DESTROY_SINCE_VERSION
		swigIntConstant( ZWP_TEXT_INPUT_V3_DESTROY_SINCE_VERSION, "ZWP_TEXT_INPUT_V3_DESTROY_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TEXT_INPUT_V3_ENABLE_SINCE_VERSION
		swigIntConstant( ZWP_TEXT_INPUT_V3_ENABLE_SINCE_VERSION, "ZWP_TEXT_INPUT_V3_ENABLE_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TEXT_INPUT_V3_DISABLE_SINCE_VERSION
		swigIntConstant( ZWP_TEXT_INPUT_V3_DISABLE_SINCE_VERSION, "ZWP_TEXT_INPUT_V3_DISABLE_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TEXT_INPUT_V3_SET_SURROUNDING_TEXT_SINCE_VERSION
		swigIntConstant( ZWP_TEXT_INPUT_V3_SET_SURROUNDING_TEXT_SINCE_VERSION, "ZWP_TEXT_INPUT_V3_SET_SURROUNDING_TEXT_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TEXT_INPUT_V3_SET_TEXT_CHANGE_CAUSE_SINCE_VERSION
		swigIntConstant( ZWP_TEXT_INPUT_V3_SET_TEXT_CHANGE_CAUSE_SINCE_VERSION, "ZWP_TEXT_INPUT_V3_SET_TEXT_CHANGE_CAUSE_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TEXT_INPUT_V3_SET_CONTENT_TYPE_SINCE_VERSION
		swigIntConstant( ZWP_TEXT_INPUT_V3_SET_CONTENT_TYPE_SINCE_VERSION, "ZWP_TEXT_INPUT_V3_SET_CONTENT_TYPE_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TEXT_INPUT_V3_SET_CURSOR_RECTANGLE_SINCE_VERSION
		swigIntConstant( ZWP_TEXT_INPUT_V3_SET_CURSOR_RECTANGLE_SINCE_VERSION, "ZWP_TEXT_INPUT_V3_SET_CURSOR_RECTANGLE_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TEXT_INPUT_V3_COMMIT_SINCE_VERSION
		swigIntConstant( ZWP_TEXT_INPUT_V3_COMMIT_SINCE_VERSION, "ZWP_TEXT_INPUT_V3_COMMIT_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TEXT_INPUT_MANAGER_V3_DESTROY
		swigIntConstant( ZWP_TEXT_INPUT_MANAGER_V3_DESTROY, "ZWP_TEXT_INPUT_MANAGER_V3_DESTROY" );
	#endif
	#ifdef ZWP_TEXT_INPUT_MANAGER_V3_GET_TEXT_INPUT
		swigIntConstant( ZWP_TEXT_INPUT_MANAGER_V3_GET_TEXT_INPUT, "ZWP_TEXT_INPUT_MANAGER_V3_GET_TEXT_INPUT" );
	#endif
	#ifdef ZWP_TEXT_INPUT_MANAGER_V3_DESTROY_SINCE_VERSION
		swigIntConstant( ZWP_TEXT_INPUT_MANAGER_V3_DESTROY_SINCE_VERSION, "ZWP_TEXT_INPUT_MANAGER_V3_DESTROY_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TEXT_INPUT_MANAGER_V3_GET_TEXT_INPUT_SINCE_VERSION
		swigIntConstant( ZWP_TEXT_INPUT_MANAGER_V3_GET_TEXT_INPUT_SINCE_VERSION, "ZWP_TEXT_INPUT_MANAGER_V3_GET_TEXT_INPUT_SINCE_VERSION" );
	#endif
	#ifdef XDG_WM_BASE_DESTROY
		swigIntConstant( XDG_WM_BASE_DESTROY, "XDG_WM_BASE_DESTROY" );
	#endif
	#ifdef XDG_WM_BASE_CREATE_POSITIONER
		swigIntConstant( XDG_WM_BASE_CREATE_POSITIONER, "XDG_WM_BASE_CREATE_POSITIONER" );
	#endif
	#ifdef XDG_WM_BASE_GET_XDG_SURFACE
		swigIntConstant( XDG_WM_BASE_GET_XDG_SURFACE, "XDG_WM_BASE_GET_XDG_SURFACE" );
	#endif
	#ifdef XDG_WM_BASE_PONG
		swigIntConstant( XDG_WM_BASE_PONG, "XDG_WM_BASE_PONG" );
	#endif
	#ifdef XDG_WM_BASE_PING_SINCE_VERSION
		swigIntConstant( XDG_WM_BASE_PING_SINCE_VERSION, "XDG_WM_BASE_PING_SINCE_VERSION" );
	#endif
	#ifdef XDG_WM_BASE_DESTROY_SINCE_VERSION
		swigIntConstant( XDG_WM_BASE_DESTROY_SINCE_VERSION, "XDG_WM_BASE_DESTROY_SINCE_VERSION" );
	#endif
	#ifdef XDG_WM_BASE_CREATE_POSITIONER_SINCE_VERSION
		swigIntConstant( XDG_WM_BASE_CREATE_POSITIONER_SINCE_VERSION, "XDG_WM_BASE_CREATE_POSITIONER_SINCE_VERSION" );
	#endif
	#ifdef XDG_WM_BASE_GET_XDG_SURFACE_SINCE_VERSION
		swigIntConstant( XDG_WM_BASE_GET_XDG_SURFACE_SINCE_VERSION, "XDG_WM_BASE_GET_XDG_SURFACE_SINCE_VERSION" );
	#endif
	#ifdef XDG_WM_BASE_PONG_SINCE_VERSION
		swigIntConstant( XDG_WM_BASE_PONG_SINCE_VERSION, "XDG_WM_BASE_PONG_SINCE_VERSION" );
	#endif
	#ifdef XDG_POSITIONER_DESTROY
		swigIntConstant( XDG_POSITIONER_DESTROY, "XDG_POSITIONER_DESTROY" );
	#endif
	#ifdef XDG_POSITIONER_SET_SIZE
		swigIntConstant( XDG_POSITIONER_SET_SIZE, "XDG_POSITIONER_SET_SIZE" );
	#endif
	#ifdef XDG_POSITIONER_SET_ANCHOR_RECT
		swigIntConstant( XDG_POSITIONER_SET_ANCHOR_RECT, "XDG_POSITIONER_SET_ANCHOR_RECT" );
	#endif
	#ifdef XDG_POSITIONER_SET_ANCHOR
		swigIntConstant( XDG_POSITIONER_SET_ANCHOR, "XDG_POSITIONER_SET_ANCHOR" );
	#endif
	#ifdef XDG_POSITIONER_SET_GRAVITY
		swigIntConstant( XDG_POSITIONER_SET_GRAVITY, "XDG_POSITIONER_SET_GRAVITY" );
	#endif
	#ifdef XDG_POSITIONER_SET_CONSTRAINT_ADJUSTMENT
		swigIntConstant( XDG_POSITIONER_SET_CONSTRAINT_ADJUSTMENT, "XDG_POSITIONER_SET_CONSTRAINT_ADJUSTMENT" );
	#endif
	#ifdef XDG_POSITIONER_SET_OFFSET
		swigIntConstant( XDG_POSITIONER_SET_OFFSET, "XDG_POSITIONER_SET_OFFSET" );
	#endif
	#ifdef XDG_POSITIONER_SET_REACTIVE
		swigIntConstant( XDG_POSITIONER_SET_REACTIVE, "XDG_POSITIONER_SET_REACTIVE" );
	#endif
	#ifdef XDG_POSITIONER_SET_PARENT_SIZE
		swigIntConstant( XDG_POSITIONER_SET_PARENT_SIZE, "XDG_POSITIONER_SET_PARENT_SIZE" );
	#endif
	#ifdef XDG_POSITIONER_SET_PARENT_CONFIGURE
		swigIntConstant( XDG_POSITIONER_SET_PARENT_CONFIGURE, "XDG_POSITIONER_SET_PARENT_CONFIGURE" );
	#endif
	#ifdef XDG_POSITIONER_DESTROY_SINCE_VERSION
		swigIntConstant( XDG_POSITIONER_DESTROY_SINCE_VERSION, "XDG_POSITIONER_DESTROY_SINCE_VERSION" );
	#endif
	#ifdef XDG_POSITIONER_SET_SIZE_SINCE_VERSION
		swigIntConstant( XDG_POSITIONER_SET_SIZE_SINCE_VERSION, "XDG_POSITIONER_SET_SIZE_SINCE_VERSION" );
	#endif
	#ifdef XDG_POSITIONER_SET_ANCHOR_RECT_SINCE_VERSION
		swigIntConstant( XDG_POSITIONER_SET_ANCHOR_RECT_SINCE_VERSION, "XDG_POSITIONER_SET_ANCHOR_RECT_SINCE_VERSION" );
	#endif
	#ifdef XDG_POSITIONER_SET_ANCHOR_SINCE_VERSION
		swigIntConstant( XDG_POSITIONER_SET_ANCHOR_SINCE_VERSION, "XDG_POSITIONER_SET_ANCHOR_SINCE_VERSION" );
	#endif
	#ifdef XDG_POSITIONER_SET_GRAVITY_SINCE_VERSION
		swigIntConstant( XDG_POSITIONER_SET_GRAVITY_SINCE_VERSION, "XDG_POSITIONER_SET_GRAVITY_SINCE_VERSION" );
	#endif
	#ifdef XDG_POSITIONER_SET_CONSTRAINT_ADJUSTMENT_SINCE_VERSION
		swigIntConstant( XDG_POSITIONER_SET_CONSTRAINT_ADJUSTMENT_SINCE_VERSION, "XDG_POSITIONER_SET_CONSTRAINT_ADJUSTMENT_SINCE_VERSION" );
	#endif
	#ifdef XDG_POSITIONER_SET_OFFSET_SINCE_VERSION
		swigIntConstant( XDG_POSITIONER_SET_OFFSET_SINCE_VERSION, "XDG_POSITIONER_SET_OFFSET_SINCE_VERSION" );
	#endif
	#ifdef XDG_POSITIONER_SET_REACTIVE_SINCE_VERSION
		swigIntConstant( XDG_POSITIONER_SET_REACTIVE_SINCE_VERSION, "XDG_POSITIONER_SET_REACTIVE_SINCE_VERSION" );
	#endif
	#ifdef XDG_POSITIONER_SET_PARENT_SIZE_SINCE_VERSION
		swigIntConstant( XDG_POSITIONER_SET_PARENT_SIZE_SINCE_VERSION, "XDG_POSITIONER_SET_PARENT_SIZE_SINCE_VERSION" );
	#endif
	#ifdef XDG_POSITIONER_SET_PARENT_CONFIGURE_SINCE_VERSION
		swigIntConstant( XDG_POSITIONER_SET_PARENT_CONFIGURE_SINCE_VERSION, "XDG_POSITIONER_SET_PARENT_CONFIGURE_SINCE_VERSION" );
	#endif
	#ifdef XDG_SURFACE_DESTROY
		swigIntConstant( XDG_SURFACE_DESTROY, "XDG_SURFACE_DESTROY" );
	#endif
	#ifdef XDG_SURFACE_GET_TOPLEVEL
		swigIntConstant( XDG_SURFACE_GET_TOPLEVEL, "XDG_SURFACE_GET_TOPLEVEL" );
	#endif
	#ifdef XDG_SURFACE_GET_POPUP
		swigIntConstant( XDG_SURFACE_GET_POPUP, "XDG_SURFACE_GET_POPUP" );
	#endif
	#ifdef XDG_SURFACE_SET_WINDOW_GEOMETRY
		swigIntConstant( XDG_SURFACE_SET_WINDOW_GEOMETRY, "XDG_SURFACE_SET_WINDOW_GEOMETRY" );
	#endif
	#ifdef XDG_SURFACE_ACK_CONFIGURE
		swigIntConstant( XDG_SURFACE_ACK_CONFIGURE, "XDG_SURFACE_ACK_CONFIGURE" );
	#endif
	#ifdef XDG_SURFACE_CONFIGURE_SINCE_VERSION
		swigIntConstant( XDG_SURFACE_CONFIGURE_SINCE_VERSION, "XDG_SURFACE_CONFIGURE_SINCE_VERSION" );
	#endif
	#ifdef XDG_SURFACE_DESTROY_SINCE_VERSION
		swigIntConstant( XDG_SURFACE_DESTROY_SINCE_VERSION, "XDG_SURFACE_DESTROY_SINCE_VERSION" );
	#endif
	#ifdef XDG_SURFACE_GET_TOPLEVEL_SINCE_VERSION
		swigIntConstant( XDG_SURFACE_GET_TOPLEVEL_SINCE_VERSION, "XDG_SURFACE_GET_TOPLEVEL_SINCE_VERSION" );
	#endif
	#ifdef XDG_SURFACE_GET_POPUP_SINCE_VERSION
		swigIntConstant( XDG_SURFACE_GET_POPUP_SINCE_VERSION, "XDG_SURFACE_GET_POPUP_SINCE_VERSION" );
	#endif
	#ifdef XDG_SURFACE_SET_WINDOW_GEOMETRY_SINCE_VERSION
		swigIntConstant( XDG_SURFACE_SET_WINDOW_GEOMETRY_SINCE_VERSION, "XDG_SURFACE_SET_WINDOW_GEOMETRY_SINCE_VERSION" );
	#endif
	#ifdef XDG_SURFACE_ACK_CONFIGURE_SINCE_VERSION
		swigIntConstant( XDG_SURFACE_ACK_CONFIGURE_SINCE_VERSION, "XDG_SURFACE_ACK_CONFIGURE_SINCE_VERSION" );
	#endif
	#ifdef XDG_TOPLEVEL_STATE_TILED_LEFT_SINCE_VERSION
		swigIntConstant( XDG_TOPLEVEL_STATE_TILED_LEFT_SINCE_VERSION, "XDG_TOPLEVEL_STATE_TILED_LEFT_SINCE_VERSION" );
	#endif
	#ifdef XDG_TOPLEVEL_STATE_TILED_RIGHT_SINCE_VERSION
		swigIntConstant( XDG_TOPLEVEL_STATE_TILED_RIGHT_SINCE_VERSION, "XDG_TOPLEVEL_STATE_TILED_RIGHT_SINCE_VERSION" );
	#endif
	#ifdef XDG_TOPLEVEL_STATE_TILED_TOP_SINCE_VERSION
		swigIntConstant( XDG_TOPLEVEL_STATE_TILED_TOP_SINCE_VERSION, "XDG_TOPLEVEL_STATE_TILED_TOP_SINCE_VERSION" );
	#endif
	#ifdef XDG_TOPLEVEL_STATE_TILED_BOTTOM_SINCE_VERSION
		swigIntConstant( XDG_TOPLEVEL_STATE_TILED_BOTTOM_SINCE_VERSION, "XDG_TOPLEVEL_STATE_TILED_BOTTOM_SINCE_VERSION" );
	#endif
	#ifdef XDG_TOPLEVEL_STATE_SUSPENDED_SINCE_VERSION
		swigIntConstant( XDG_TOPLEVEL_STATE_SUSPENDED_SINCE_VERSION, "XDG_TOPLEVEL_STATE_SUSPENDED_SINCE_VERSION" );
	#endif
	#ifdef XDG_TOPLEVEL_DESTROY
		swigIntConstant( XDG_TOPLEVEL_DESTROY, "XDG_TOPLEVEL_DESTROY" );
	#endif
	#ifdef XDG_TOPLEVEL_SET_PARENT
		swigIntConstant( XDG_TOPLEVEL_SET_PARENT, "XDG_TOPLEVEL_SET_PARENT" );
	#endif
	#ifdef XDG_TOPLEVEL_SET_TITLE
		swigIntConstant( XDG_TOPLEVEL_SET_TITLE, "XDG_TOPLEVEL_SET_TITLE" );
	#endif
	#ifdef XDG_TOPLEVEL_SET_APP_ID
		swigIntConstant( XDG_TOPLEVEL_SET_APP_ID, "XDG_TOPLEVEL_SET_APP_ID" );
	#endif
	#ifdef XDG_TOPLEVEL_SHOW_WINDOW_MENU
		swigIntConstant( XDG_TOPLEVEL_SHOW_WINDOW_MENU, "XDG_TOPLEVEL_SHOW_WINDOW_MENU" );
	#endif
	#ifdef XDG_TOPLEVEL_MOVE
		swigIntConstant( XDG_TOPLEVEL_MOVE, "XDG_TOPLEVEL_MOVE" );
	#endif
	#ifdef XDG_TOPLEVEL_RESIZE
		swigIntConstant( XDG_TOPLEVEL_RESIZE, "XDG_TOPLEVEL_RESIZE" );
	#endif
	#ifdef XDG_TOPLEVEL_SET_MAX_SIZE
		swigIntConstant( XDG_TOPLEVEL_SET_MAX_SIZE, "XDG_TOPLEVEL_SET_MAX_SIZE" );
	#endif
	#ifdef XDG_TOPLEVEL_SET_MIN_SIZE
		swigIntConstant( XDG_TOPLEVEL_SET_MIN_SIZE, "XDG_TOPLEVEL_SET_MIN_SIZE" );
	#endif
	#ifdef XDG_TOPLEVEL_SET_MAXIMIZED
		swigIntConstant( XDG_TOPLEVEL_SET_MAXIMIZED, "XDG_TOPLEVEL_SET_MAXIMIZED" );
	#endif
	#ifdef XDG_TOPLEVEL_UNSET_MAXIMIZED
		swigIntConstant( XDG_TOPLEVEL_UNSET_MAXIMIZED, "XDG_TOPLEVEL_UNSET_MAXIMIZED" );
	#endif
	#ifdef XDG_TOPLEVEL_SET_FULLSCREEN
		swigIntConstant( XDG_TOPLEVEL_SET_FULLSCREEN, "XDG_TOPLEVEL_SET_FULLSCREEN" );
	#endif
	#ifdef XDG_TOPLEVEL_UNSET_FULLSCREEN
		swigIntConstant( XDG_TOPLEVEL_UNSET_FULLSCREEN, "XDG_TOPLEVEL_UNSET_FULLSCREEN" );
	#endif
	#ifdef XDG_TOPLEVEL_SET_MINIMIZED
		swigIntConstant( XDG_TOPLEVEL_SET_MINIMIZED, "XDG_TOPLEVEL_SET_MINIMIZED" );
	#endif
	#ifdef XDG_TOPLEVEL_CONFIGURE_SINCE_VERSION
		swigIntConstant( XDG_TOPLEVEL_CONFIGURE_SINCE_VERSION, "XDG_TOPLEVEL_CONFIGURE_SINCE_VERSION" );
	#endif
	#ifdef XDG_TOPLEVEL_CLOSE_SINCE_VERSION
		swigIntConstant( XDG_TOPLEVEL_CLOSE_SINCE_VERSION, "XDG_TOPLEVEL_CLOSE_SINCE_VERSION" );
	#endif
	#ifdef XDG_TOPLEVEL_CONFIGURE_BOUNDS_SINCE_VERSION
		swigIntConstant( XDG_TOPLEVEL_CONFIGURE_BOUNDS_SINCE_VERSION, "XDG_TOPLEVEL_CONFIGURE_BOUNDS_SINCE_VERSION" );
	#endif
	#ifdef XDG_TOPLEVEL_WM_CAPABILITIES_SINCE_VERSION
		swigIntConstant( XDG_TOPLEVEL_WM_CAPABILITIES_SINCE_VERSION, "XDG_TOPLEVEL_WM_CAPABILITIES_SINCE_VERSION" );
	#endif
	#ifdef XDG_TOPLEVEL_DESTROY_SINCE_VERSION
		swigIntConstant( XDG_TOPLEVEL_DESTROY_SINCE_VERSION, "XDG_TOPLEVEL_DESTROY_SINCE_VERSION" );
	#endif
	#ifdef XDG_TOPLEVEL_SET_PARENT_SINCE_VERSION
		swigIntConstant( XDG_TOPLEVEL_SET_PARENT_SINCE_VERSION, "XDG_TOPLEVEL_SET_PARENT_SINCE_VERSION" );
	#endif
	#ifdef XDG_TOPLEVEL_SET_TITLE_SINCE_VERSION
		swigIntConstant( XDG_TOPLEVEL_SET_TITLE_SINCE_VERSION, "XDG_TOPLEVEL_SET_TITLE_SINCE_VERSION" );
	#endif
	#ifdef XDG_TOPLEVEL_SET_APP_ID_SINCE_VERSION
		swigIntConstant( XDG_TOPLEVEL_SET_APP_ID_SINCE_VERSION, "XDG_TOPLEVEL_SET_APP_ID_SINCE_VERSION" );
	#endif
	#ifdef XDG_TOPLEVEL_SHOW_WINDOW_MENU_SINCE_VERSION
		swigIntConstant( XDG_TOPLEVEL_SHOW_WINDOW_MENU_SINCE_VERSION, "XDG_TOPLEVEL_SHOW_WINDOW_MENU_SINCE_VERSION" );
	#endif
	#ifdef XDG_TOPLEVEL_MOVE_SINCE_VERSION
		swigIntConstant( XDG_TOPLEVEL_MOVE_SINCE_VERSION, "XDG_TOPLEVEL_MOVE_SINCE_VERSION" );
	#endif
	#ifdef XDG_TOPLEVEL_RESIZE_SINCE_VERSION
		swigIntConstant( XDG_TOPLEVEL_RESIZE_SINCE_VERSION, "XDG_TOPLEVEL_RESIZE_SINCE_VERSION" );
	#endif
	#ifdef XDG_TOPLEVEL_SET_MAX_SIZE_SINCE_VERSION
		swigIntConstant( XDG_TOPLEVEL_SET_MAX_SIZE_SINCE_VERSION, "XDG_TOPLEVEL_SET_MAX_SIZE_SINCE_VERSION" );
	#endif
	#ifdef XDG_TOPLEVEL_SET_MIN_SIZE_SINCE_VERSION
		swigIntConstant( XDG_TOPLEVEL_SET_MIN_SIZE_SINCE_VERSION, "XDG_TOPLEVEL_SET_MIN_SIZE_SINCE_VERSION" );
	#endif
	#ifdef XDG_TOPLEVEL_SET_MAXIMIZED_SINCE_VERSION
		swigIntConstant( XDG_TOPLEVEL_SET_MAXIMIZED_SINCE_VERSION, "XDG_TOPLEVEL_SET_MAXIMIZED_SINCE_VERSION" );
	#endif
	#ifdef XDG_TOPLEVEL_UNSET_MAXIMIZED_SINCE_VERSION
		swigIntConstant( XDG_TOPLEVEL_UNSET_MAXIMIZED_SINCE_VERSION, "XDG_TOPLEVEL_UNSET_MAXIMIZED_SINCE_VERSION" );
	#endif
	#ifdef XDG_TOPLEVEL_SET_FULLSCREEN_SINCE_VERSION
		swigIntConstant( XDG_TOPLEVEL_SET_FULLSCREEN_SINCE_VERSION, "XDG_TOPLEVEL_SET_FULLSCREEN_SINCE_VERSION" );
	#endif
	#ifdef XDG_TOPLEVEL_UNSET_FULLSCREEN_SINCE_VERSION
		swigIntConstant( XDG_TOPLEVEL_UNSET_FULLSCREEN_SINCE_VERSION, "XDG_TOPLEVEL_UNSET_FULLSCREEN_SINCE_VERSION" );
	#endif
	#ifdef XDG_TOPLEVEL_SET_MINIMIZED_SINCE_VERSION
		swigIntConstant( XDG_TOPLEVEL_SET_MINIMIZED_SINCE_VERSION, "XDG_TOPLEVEL_SET_MINIMIZED_SINCE_VERSION" );
	#endif
	#ifdef XDG_POPUP_DESTROY
		swigIntConstant( XDG_POPUP_DESTROY, "XDG_POPUP_DESTROY" );
	#endif
	#ifdef XDG_POPUP_GRAB
		swigIntConstant( XDG_POPUP_GRAB, "XDG_POPUP_GRAB" );
	#endif
	#ifdef XDG_POPUP_REPOSITION
		swigIntConstant( XDG_POPUP_REPOSITION, "XDG_POPUP_REPOSITION" );
	#endif
	#ifdef XDG_POPUP_CONFIGURE_SINCE_VERSION
		swigIntConstant( XDG_POPUP_CONFIGURE_SINCE_VERSION, "XDG_POPUP_CONFIGURE_SINCE_VERSION" );
	#endif
	#ifdef XDG_POPUP_POPUP_DONE_SINCE_VERSION
		swigIntConstant( XDG_POPUP_POPUP_DONE_SINCE_VERSION, "XDG_POPUP_POPUP_DONE_SINCE_VERSION" );
	#endif
	#ifdef XDG_POPUP_REPOSITIONED_SINCE_VERSION
		swigIntConstant( XDG_POPUP_REPOSITIONED_SINCE_VERSION, "XDG_POPUP_REPOSITIONED_SINCE_VERSION" );
	#endif
	#ifdef XDG_POPUP_DESTROY_SINCE_VERSION
		swigIntConstant( XDG_POPUP_DESTROY_SINCE_VERSION, "XDG_POPUP_DESTROY_SINCE_VERSION" );
	#endif
	#ifdef XDG_POPUP_GRAB_SINCE_VERSION
		swigIntConstant( XDG_POPUP_GRAB_SINCE_VERSION, "XDG_POPUP_GRAB_SINCE_VERSION" );
	#endif
	#ifdef XDG_POPUP_REPOSITION_SINCE_VERSION
		swigIntConstant( XDG_POPUP_REPOSITION_SINCE_VERSION, "XDG_POPUP_REPOSITION_SINCE_VERSION" );
	#endif
	#ifdef ZXDG_DECORATION_MANAGER_V1_DESTROY
		swigIntConstant( ZXDG_DECORATION_MANAGER_V1_DESTROY, "ZXDG_DECORATION_MANAGER_V1_DESTROY" );
	#endif
	#ifdef ZXDG_DECORATION_MANAGER_V1_GET_TOPLEVEL_DECORATION
		swigIntConstant( ZXDG_DECORATION_MANAGER_V1_GET_TOPLEVEL_DECORATION, "ZXDG_DECORATION_MANAGER_V1_GET_TOPLEVEL_DECORATION" );
	#endif
	#ifdef ZXDG_DECORATION_MANAGER_V1_DESTROY_SINCE_VERSION
		swigIntConstant( ZXDG_DECORATION_MANAGER_V1_DESTROY_SINCE_VERSION, "ZXDG_DECORATION_MANAGER_V1_DESTROY_SINCE_VERSION" );
	#endif
	#ifdef ZXDG_DECORATION_MANAGER_V1_GET_TOPLEVEL_DECORATION_SINCE_VERSION
		swigIntConstant( ZXDG_DECORATION_MANAGER_V1_GET_TOPLEVEL_DECORATION_SINCE_VERSION, "ZXDG_DECORATION_MANAGER_V1_GET_TOPLEVEL_DECORATION_SINCE_VERSION" );
	#endif
	#ifdef ZXDG_TOPLEVEL_DECORATION_V1_DESTROY
		swigIntConstant( ZXDG_TOPLEVEL_DECORATION_V1_DESTROY, "ZXDG_TOPLEVEL_DECORATION_V1_DESTROY" );
	#endif
	#ifdef ZXDG_TOPLEVEL_DECORATION_V1_SET_MODE
		swigIntConstant( ZXDG_TOPLEVEL_DECORATION_V1_SET_MODE, "ZXDG_TOPLEVEL_DECORATION_V1_SET_MODE" );
	#endif
	#ifdef ZXDG_TOPLEVEL_DECORATION_V1_UNSET_MODE
		swigIntConstant( ZXDG_TOPLEVEL_DECORATION_V1_UNSET_MODE, "ZXDG_TOPLEVEL_DECORATION_V1_UNSET_MODE" );
	#endif
	#ifdef ZXDG_TOPLEVEL_DECORATION_V1_CONFIGURE_SINCE_VERSION
		swigIntConstant( ZXDG_TOPLEVEL_DECORATION_V1_CONFIGURE_SINCE_VERSION, "ZXDG_TOPLEVEL_DECORATION_V1_CONFIGURE_SINCE_VERSION" );
	#endif
	#ifdef ZXDG_TOPLEVEL_DECORATION_V1_DESTROY_SINCE_VERSION
		swigIntConstant( ZXDG_TOPLEVEL_DECORATION_V1_DESTROY_SINCE_VERSION, "ZXDG_TOPLEVEL_DECORATION_V1_DESTROY_SINCE_VERSION" );
	#endif
	#ifdef ZXDG_TOPLEVEL_DECORATION_V1_SET_MODE_SINCE_VERSION
		swigIntConstant( ZXDG_TOPLEVEL_DECORATION_V1_SET_MODE_SINCE_VERSION, "ZXDG_TOPLEVEL_DECORATION_V1_SET_MODE_SINCE_VERSION" );
	#endif
	#ifdef ZXDG_TOPLEVEL_DECORATION_V1_UNSET_MODE_SINCE_VERSION
		swigIntConstant( ZXDG_TOPLEVEL_DECORATION_V1_UNSET_MODE_SINCE_VERSION, "ZXDG_TOPLEVEL_DECORATION_V1_UNSET_MODE_SINCE_VERSION" );
	#endif
	#ifdef ZWP_PRIMARY_SELECTION_DEVICE_MANAGER_V1_CREATE_SOURCE
		swigIntConstant( ZWP_PRIMARY_SELECTION_DEVICE_MANAGER_V1_CREATE_SOURCE, "ZWP_PRIMARY_SELECTION_DEVICE_MANAGER_V1_CREATE_SOURCE" );
	#endif
	#ifdef ZWP_PRIMARY_SELECTION_DEVICE_MANAGER_V1_GET_DEVICE
		swigIntConstant( ZWP_PRIMARY_SELECTION_DEVICE_MANAGER_V1_GET_DEVICE, "ZWP_PRIMARY_SELECTION_DEVICE_MANAGER_V1_GET_DEVICE" );
	#endif
	#ifdef ZWP_PRIMARY_SELECTION_DEVICE_MANAGER_V1_DESTROY
		swigIntConstant( ZWP_PRIMARY_SELECTION_DEVICE_MANAGER_V1_DESTROY, "ZWP_PRIMARY_SELECTION_DEVICE_MANAGER_V1_DESTROY" );
	#endif
	#ifdef ZWP_PRIMARY_SELECTION_DEVICE_MANAGER_V1_CREATE_SOURCE_SINCE_VERSION
		swigIntConstant( ZWP_PRIMARY_SELECTION_DEVICE_MANAGER_V1_CREATE_SOURCE_SINCE_VERSION, "ZWP_PRIMARY_SELECTION_DEVICE_MANAGER_V1_CREATE_SOURCE_SINCE_VERSION" );
	#endif
	#ifdef ZWP_PRIMARY_SELECTION_DEVICE_MANAGER_V1_GET_DEVICE_SINCE_VERSION
		swigIntConstant( ZWP_PRIMARY_SELECTION_DEVICE_MANAGER_V1_GET_DEVICE_SINCE_VERSION, "ZWP_PRIMARY_SELECTION_DEVICE_MANAGER_V1_GET_DEVICE_SINCE_VERSION" );
	#endif
	#ifdef ZWP_PRIMARY_SELECTION_DEVICE_MANAGER_V1_DESTROY_SINCE_VERSION
		swigIntConstant( ZWP_PRIMARY_SELECTION_DEVICE_MANAGER_V1_DESTROY_SINCE_VERSION, "ZWP_PRIMARY_SELECTION_DEVICE_MANAGER_V1_DESTROY_SINCE_VERSION" );
	#endif
	#ifdef ZWP_PRIMARY_SELECTION_DEVICE_V1_SET_SELECTION
		swigIntConstant( ZWP_PRIMARY_SELECTION_DEVICE_V1_SET_SELECTION, "ZWP_PRIMARY_SELECTION_DEVICE_V1_SET_SELECTION" );
	#endif
	#ifdef ZWP_PRIMARY_SELECTION_DEVICE_V1_DESTROY
		swigIntConstant( ZWP_PRIMARY_SELECTION_DEVICE_V1_DESTROY, "ZWP_PRIMARY_SELECTION_DEVICE_V1_DESTROY" );
	#endif
	#ifdef ZWP_PRIMARY_SELECTION_DEVICE_V1_DATA_OFFER_SINCE_VERSION
		swigIntConstant( ZWP_PRIMARY_SELECTION_DEVICE_V1_DATA_OFFER_SINCE_VERSION, "ZWP_PRIMARY_SELECTION_DEVICE_V1_DATA_OFFER_SINCE_VERSION" );
	#endif
	#ifdef ZWP_PRIMARY_SELECTION_DEVICE_V1_SELECTION_SINCE_VERSION
		swigIntConstant( ZWP_PRIMARY_SELECTION_DEVICE_V1_SELECTION_SINCE_VERSION, "ZWP_PRIMARY_SELECTION_DEVICE_V1_SELECTION_SINCE_VERSION" );
	#endif
	#ifdef ZWP_PRIMARY_SELECTION_DEVICE_V1_SET_SELECTION_SINCE_VERSION
		swigIntConstant( ZWP_PRIMARY_SELECTION_DEVICE_V1_SET_SELECTION_SINCE_VERSION, "ZWP_PRIMARY_SELECTION_DEVICE_V1_SET_SELECTION_SINCE_VERSION" );
	#endif
	#ifdef ZWP_PRIMARY_SELECTION_DEVICE_V1_DESTROY_SINCE_VERSION
		swigIntConstant( ZWP_PRIMARY_SELECTION_DEVICE_V1_DESTROY_SINCE_VERSION, "ZWP_PRIMARY_SELECTION_DEVICE_V1_DESTROY_SINCE_VERSION" );
	#endif
	#ifdef ZWP_PRIMARY_SELECTION_OFFER_V1_RECEIVE
		swigIntConstant( ZWP_PRIMARY_SELECTION_OFFER_V1_RECEIVE, "ZWP_PRIMARY_SELECTION_OFFER_V1_RECEIVE" );
	#endif
	#ifdef ZWP_PRIMARY_SELECTION_OFFER_V1_DESTROY
		swigIntConstant( ZWP_PRIMARY_SELECTION_OFFER_V1_DESTROY, "ZWP_PRIMARY_SELECTION_OFFER_V1_DESTROY" );
	#endif
	#ifdef ZWP_PRIMARY_SELECTION_OFFER_V1_OFFER_SINCE_VERSION
		swigIntConstant( ZWP_PRIMARY_SELECTION_OFFER_V1_OFFER_SINCE_VERSION, "ZWP_PRIMARY_SELECTION_OFFER_V1_OFFER_SINCE_VERSION" );
	#endif
	#ifdef ZWP_PRIMARY_SELECTION_OFFER_V1_RECEIVE_SINCE_VERSION
		swigIntConstant( ZWP_PRIMARY_SELECTION_OFFER_V1_RECEIVE_SINCE_VERSION, "ZWP_PRIMARY_SELECTION_OFFER_V1_RECEIVE_SINCE_VERSION" );
	#endif
	#ifdef ZWP_PRIMARY_SELECTION_OFFER_V1_DESTROY_SINCE_VERSION
		swigIntConstant( ZWP_PRIMARY_SELECTION_OFFER_V1_DESTROY_SINCE_VERSION, "ZWP_PRIMARY_SELECTION_OFFER_V1_DESTROY_SINCE_VERSION" );
	#endif
	#ifdef ZWP_PRIMARY_SELECTION_SOURCE_V1_OFFER
		swigIntConstant( ZWP_PRIMARY_SELECTION_SOURCE_V1_OFFER, "ZWP_PRIMARY_SELECTION_SOURCE_V1_OFFER" );
	#endif
	#ifdef ZWP_PRIMARY_SELECTION_SOURCE_V1_DESTROY
		swigIntConstant( ZWP_PRIMARY_SELECTION_SOURCE_V1_DESTROY, "ZWP_PRIMARY_SELECTION_SOURCE_V1_DESTROY" );
	#endif
	#ifdef ZWP_PRIMARY_SELECTION_SOURCE_V1_SEND_SINCE_VERSION
		swigIntConstant( ZWP_PRIMARY_SELECTION_SOURCE_V1_SEND_SINCE_VERSION, "ZWP_PRIMARY_SELECTION_SOURCE_V1_SEND_SINCE_VERSION" );
	#endif
	#ifdef ZWP_PRIMARY_SELECTION_SOURCE_V1_CANCELLED_SINCE_VERSION
		swigIntConstant( ZWP_PRIMARY_SELECTION_SOURCE_V1_CANCELLED_SINCE_VERSION, "ZWP_PRIMARY_SELECTION_SOURCE_V1_CANCELLED_SINCE_VERSION" );
	#endif
	#ifdef ZWP_PRIMARY_SELECTION_SOURCE_V1_OFFER_SINCE_VERSION
		swigIntConstant( ZWP_PRIMARY_SELECTION_SOURCE_V1_OFFER_SINCE_VERSION, "ZWP_PRIMARY_SELECTION_SOURCE_V1_OFFER_SINCE_VERSION" );
	#endif
	#ifdef ZWP_PRIMARY_SELECTION_SOURCE_V1_DESTROY_SINCE_VERSION
		swigIntConstant( ZWP_PRIMARY_SELECTION_SOURCE_V1_DESTROY_SINCE_VERSION, "ZWP_PRIMARY_SELECTION_SOURCE_V1_DESTROY_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_MANAGER_V2_GET_TABLET_SEAT
		swigIntConstant( ZWP_TABLET_MANAGER_V2_GET_TABLET_SEAT, "ZWP_TABLET_MANAGER_V2_GET_TABLET_SEAT" );
	#endif
	#ifdef ZWP_TABLET_MANAGER_V2_DESTROY
		swigIntConstant( ZWP_TABLET_MANAGER_V2_DESTROY, "ZWP_TABLET_MANAGER_V2_DESTROY" );
	#endif
	#ifdef ZWP_TABLET_MANAGER_V2_GET_TABLET_SEAT_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_MANAGER_V2_GET_TABLET_SEAT_SINCE_VERSION, "ZWP_TABLET_MANAGER_V2_GET_TABLET_SEAT_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_MANAGER_V2_DESTROY_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_MANAGER_V2_DESTROY_SINCE_VERSION, "ZWP_TABLET_MANAGER_V2_DESTROY_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_SEAT_V2_DESTROY
		swigIntConstant( ZWP_TABLET_SEAT_V2_DESTROY, "ZWP_TABLET_SEAT_V2_DESTROY" );
	#endif
	#ifdef ZWP_TABLET_SEAT_V2_TABLET_ADDED_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_SEAT_V2_TABLET_ADDED_SINCE_VERSION, "ZWP_TABLET_SEAT_V2_TABLET_ADDED_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_SEAT_V2_TOOL_ADDED_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_SEAT_V2_TOOL_ADDED_SINCE_VERSION, "ZWP_TABLET_SEAT_V2_TOOL_ADDED_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_SEAT_V2_PAD_ADDED_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_SEAT_V2_PAD_ADDED_SINCE_VERSION, "ZWP_TABLET_SEAT_V2_PAD_ADDED_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_SEAT_V2_DESTROY_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_SEAT_V2_DESTROY_SINCE_VERSION, "ZWP_TABLET_SEAT_V2_DESTROY_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_TOOL_V2_SET_CURSOR
		swigIntConstant( ZWP_TABLET_TOOL_V2_SET_CURSOR, "ZWP_TABLET_TOOL_V2_SET_CURSOR" );
	#endif
	#ifdef ZWP_TABLET_TOOL_V2_DESTROY
		swigIntConstant( ZWP_TABLET_TOOL_V2_DESTROY, "ZWP_TABLET_TOOL_V2_DESTROY" );
	#endif
	#ifdef ZWP_TABLET_TOOL_V2_TYPE_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_TOOL_V2_TYPE_SINCE_VERSION, "ZWP_TABLET_TOOL_V2_TYPE_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_TOOL_V2_HARDWARE_SERIAL_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_TOOL_V2_HARDWARE_SERIAL_SINCE_VERSION, "ZWP_TABLET_TOOL_V2_HARDWARE_SERIAL_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_TOOL_V2_HARDWARE_ID_WACOM_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_TOOL_V2_HARDWARE_ID_WACOM_SINCE_VERSION, "ZWP_TABLET_TOOL_V2_HARDWARE_ID_WACOM_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_TOOL_V2_CAPABILITY_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_TOOL_V2_CAPABILITY_SINCE_VERSION, "ZWP_TABLET_TOOL_V2_CAPABILITY_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_TOOL_V2_DONE_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_TOOL_V2_DONE_SINCE_VERSION, "ZWP_TABLET_TOOL_V2_DONE_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_TOOL_V2_REMOVED_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_TOOL_V2_REMOVED_SINCE_VERSION, "ZWP_TABLET_TOOL_V2_REMOVED_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_TOOL_V2_PROXIMITY_IN_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_TOOL_V2_PROXIMITY_IN_SINCE_VERSION, "ZWP_TABLET_TOOL_V2_PROXIMITY_IN_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_TOOL_V2_PROXIMITY_OUT_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_TOOL_V2_PROXIMITY_OUT_SINCE_VERSION, "ZWP_TABLET_TOOL_V2_PROXIMITY_OUT_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_TOOL_V2_DOWN_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_TOOL_V2_DOWN_SINCE_VERSION, "ZWP_TABLET_TOOL_V2_DOWN_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_TOOL_V2_UP_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_TOOL_V2_UP_SINCE_VERSION, "ZWP_TABLET_TOOL_V2_UP_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_TOOL_V2_MOTION_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_TOOL_V2_MOTION_SINCE_VERSION, "ZWP_TABLET_TOOL_V2_MOTION_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_TOOL_V2_PRESSURE_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_TOOL_V2_PRESSURE_SINCE_VERSION, "ZWP_TABLET_TOOL_V2_PRESSURE_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_TOOL_V2_DISTANCE_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_TOOL_V2_DISTANCE_SINCE_VERSION, "ZWP_TABLET_TOOL_V2_DISTANCE_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_TOOL_V2_TILT_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_TOOL_V2_TILT_SINCE_VERSION, "ZWP_TABLET_TOOL_V2_TILT_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_TOOL_V2_ROTATION_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_TOOL_V2_ROTATION_SINCE_VERSION, "ZWP_TABLET_TOOL_V2_ROTATION_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_TOOL_V2_SLIDER_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_TOOL_V2_SLIDER_SINCE_VERSION, "ZWP_TABLET_TOOL_V2_SLIDER_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_TOOL_V2_WHEEL_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_TOOL_V2_WHEEL_SINCE_VERSION, "ZWP_TABLET_TOOL_V2_WHEEL_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_TOOL_V2_BUTTON_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_TOOL_V2_BUTTON_SINCE_VERSION, "ZWP_TABLET_TOOL_V2_BUTTON_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_TOOL_V2_FRAME_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_TOOL_V2_FRAME_SINCE_VERSION, "ZWP_TABLET_TOOL_V2_FRAME_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_TOOL_V2_SET_CURSOR_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_TOOL_V2_SET_CURSOR_SINCE_VERSION, "ZWP_TABLET_TOOL_V2_SET_CURSOR_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_TOOL_V2_DESTROY_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_TOOL_V2_DESTROY_SINCE_VERSION, "ZWP_TABLET_TOOL_V2_DESTROY_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_V2_DESTROY
		swigIntConstant( ZWP_TABLET_V2_DESTROY, "ZWP_TABLET_V2_DESTROY" );
	#endif
	#ifdef ZWP_TABLET_V2_NAME_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_V2_NAME_SINCE_VERSION, "ZWP_TABLET_V2_NAME_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_V2_ID_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_V2_ID_SINCE_VERSION, "ZWP_TABLET_V2_ID_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_V2_PATH_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_V2_PATH_SINCE_VERSION, "ZWP_TABLET_V2_PATH_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_V2_DONE_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_V2_DONE_SINCE_VERSION, "ZWP_TABLET_V2_DONE_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_V2_REMOVED_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_V2_REMOVED_SINCE_VERSION, "ZWP_TABLET_V2_REMOVED_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_V2_DESTROY_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_V2_DESTROY_SINCE_VERSION, "ZWP_TABLET_V2_DESTROY_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_PAD_RING_V2_SET_FEEDBACK
		swigIntConstant( ZWP_TABLET_PAD_RING_V2_SET_FEEDBACK, "ZWP_TABLET_PAD_RING_V2_SET_FEEDBACK" );
	#endif
	#ifdef ZWP_TABLET_PAD_RING_V2_DESTROY
		swigIntConstant( ZWP_TABLET_PAD_RING_V2_DESTROY, "ZWP_TABLET_PAD_RING_V2_DESTROY" );
	#endif
	#ifdef ZWP_TABLET_PAD_RING_V2_SOURCE_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_PAD_RING_V2_SOURCE_SINCE_VERSION, "ZWP_TABLET_PAD_RING_V2_SOURCE_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_PAD_RING_V2_ANGLE_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_PAD_RING_V2_ANGLE_SINCE_VERSION, "ZWP_TABLET_PAD_RING_V2_ANGLE_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_PAD_RING_V2_STOP_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_PAD_RING_V2_STOP_SINCE_VERSION, "ZWP_TABLET_PAD_RING_V2_STOP_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_PAD_RING_V2_FRAME_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_PAD_RING_V2_FRAME_SINCE_VERSION, "ZWP_TABLET_PAD_RING_V2_FRAME_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_PAD_RING_V2_SET_FEEDBACK_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_PAD_RING_V2_SET_FEEDBACK_SINCE_VERSION, "ZWP_TABLET_PAD_RING_V2_SET_FEEDBACK_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_PAD_RING_V2_DESTROY_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_PAD_RING_V2_DESTROY_SINCE_VERSION, "ZWP_TABLET_PAD_RING_V2_DESTROY_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_PAD_STRIP_V2_SET_FEEDBACK
		swigIntConstant( ZWP_TABLET_PAD_STRIP_V2_SET_FEEDBACK, "ZWP_TABLET_PAD_STRIP_V2_SET_FEEDBACK" );
	#endif
	#ifdef ZWP_TABLET_PAD_STRIP_V2_DESTROY
		swigIntConstant( ZWP_TABLET_PAD_STRIP_V2_DESTROY, "ZWP_TABLET_PAD_STRIP_V2_DESTROY" );
	#endif
	#ifdef ZWP_TABLET_PAD_STRIP_V2_SOURCE_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_PAD_STRIP_V2_SOURCE_SINCE_VERSION, "ZWP_TABLET_PAD_STRIP_V2_SOURCE_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_PAD_STRIP_V2_POSITION_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_PAD_STRIP_V2_POSITION_SINCE_VERSION, "ZWP_TABLET_PAD_STRIP_V2_POSITION_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_PAD_STRIP_V2_STOP_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_PAD_STRIP_V2_STOP_SINCE_VERSION, "ZWP_TABLET_PAD_STRIP_V2_STOP_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_PAD_STRIP_V2_FRAME_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_PAD_STRIP_V2_FRAME_SINCE_VERSION, "ZWP_TABLET_PAD_STRIP_V2_FRAME_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_PAD_STRIP_V2_SET_FEEDBACK_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_PAD_STRIP_V2_SET_FEEDBACK_SINCE_VERSION, "ZWP_TABLET_PAD_STRIP_V2_SET_FEEDBACK_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_PAD_STRIP_V2_DESTROY_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_PAD_STRIP_V2_DESTROY_SINCE_VERSION, "ZWP_TABLET_PAD_STRIP_V2_DESTROY_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_PAD_GROUP_V2_DESTROY
		swigIntConstant( ZWP_TABLET_PAD_GROUP_V2_DESTROY, "ZWP_TABLET_PAD_GROUP_V2_DESTROY" );
	#endif
	#ifdef ZWP_TABLET_PAD_GROUP_V2_BUTTONS_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_PAD_GROUP_V2_BUTTONS_SINCE_VERSION, "ZWP_TABLET_PAD_GROUP_V2_BUTTONS_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_PAD_GROUP_V2_RING_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_PAD_GROUP_V2_RING_SINCE_VERSION, "ZWP_TABLET_PAD_GROUP_V2_RING_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_PAD_GROUP_V2_STRIP_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_PAD_GROUP_V2_STRIP_SINCE_VERSION, "ZWP_TABLET_PAD_GROUP_V2_STRIP_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_PAD_GROUP_V2_MODES_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_PAD_GROUP_V2_MODES_SINCE_VERSION, "ZWP_TABLET_PAD_GROUP_V2_MODES_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_PAD_GROUP_V2_DONE_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_PAD_GROUP_V2_DONE_SINCE_VERSION, "ZWP_TABLET_PAD_GROUP_V2_DONE_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_PAD_GROUP_V2_MODE_SWITCH_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_PAD_GROUP_V2_MODE_SWITCH_SINCE_VERSION, "ZWP_TABLET_PAD_GROUP_V2_MODE_SWITCH_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_PAD_GROUP_V2_DESTROY_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_PAD_GROUP_V2_DESTROY_SINCE_VERSION, "ZWP_TABLET_PAD_GROUP_V2_DESTROY_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_PAD_V2_SET_FEEDBACK
		swigIntConstant( ZWP_TABLET_PAD_V2_SET_FEEDBACK, "ZWP_TABLET_PAD_V2_SET_FEEDBACK" );
	#endif
	#ifdef ZWP_TABLET_PAD_V2_DESTROY
		swigIntConstant( ZWP_TABLET_PAD_V2_DESTROY, "ZWP_TABLET_PAD_V2_DESTROY" );
	#endif
	#ifdef ZWP_TABLET_PAD_V2_GROUP_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_PAD_V2_GROUP_SINCE_VERSION, "ZWP_TABLET_PAD_V2_GROUP_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_PAD_V2_PATH_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_PAD_V2_PATH_SINCE_VERSION, "ZWP_TABLET_PAD_V2_PATH_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_PAD_V2_BUTTONS_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_PAD_V2_BUTTONS_SINCE_VERSION, "ZWP_TABLET_PAD_V2_BUTTONS_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_PAD_V2_DONE_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_PAD_V2_DONE_SINCE_VERSION, "ZWP_TABLET_PAD_V2_DONE_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_PAD_V2_BUTTON_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_PAD_V2_BUTTON_SINCE_VERSION, "ZWP_TABLET_PAD_V2_BUTTON_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_PAD_V2_ENTER_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_PAD_V2_ENTER_SINCE_VERSION, "ZWP_TABLET_PAD_V2_ENTER_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_PAD_V2_LEAVE_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_PAD_V2_LEAVE_SINCE_VERSION, "ZWP_TABLET_PAD_V2_LEAVE_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_PAD_V2_REMOVED_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_PAD_V2_REMOVED_SINCE_VERSION, "ZWP_TABLET_PAD_V2_REMOVED_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_PAD_V2_SET_FEEDBACK_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_PAD_V2_SET_FEEDBACK_SINCE_VERSION, "ZWP_TABLET_PAD_V2_SET_FEEDBACK_SINCE_VERSION" );
	#endif
	#ifdef ZWP_TABLET_PAD_V2_DESTROY_SINCE_VERSION
		swigIntConstant( ZWP_TABLET_PAD_V2_DESTROY_SINCE_VERSION, "ZWP_TABLET_PAD_V2_DESTROY_SINCE_VERSION" );
	#endif

	swigNewline();

	swigComment("--------===< enums >===---------\n");
	swigIntConstant( WL_DISPLAY_ERROR_INVALID_OBJECT, "WL_DISPLAY_ERROR_INVALID_OBJECT" );
	swigIntConstant( WL_DISPLAY_ERROR_INVALID_METHOD, "WL_DISPLAY_ERROR_INVALID_METHOD" );
	swigIntConstant( WL_DISPLAY_ERROR_NO_MEMORY, "WL_DISPLAY_ERROR_NO_MEMORY" );
	swigIntConstant( WL_DISPLAY_ERROR_IMPLEMENTATION, "WL_DISPLAY_ERROR_IMPLEMENTATION" );
	swigIntConstant( WL_SHM_ERROR_INVALID_FORMAT, "WL_SHM_ERROR_INVALID_FORMAT" );
	swigIntConstant( WL_SHM_ERROR_INVALID_STRIDE, "WL_SHM_ERROR_INVALID_STRIDE" );
	swigIntConstant( WL_SHM_ERROR_INVALID_FD, "WL_SHM_ERROR_INVALID_FD" );
	swigIntConstant( WL_SHM_FORMAT_ARGB8888, "WL_SHM_FORMAT_ARGB8888" );
	swigIntConstant( WL_SHM_FORMAT_XRGB8888, "WL_SHM_FORMAT_XRGB8888" );
	swigIntConstant( WL_SHM_FORMAT_C8, "WL_SHM_FORMAT_C8" );
	swigIntConstant( WL_SHM_FORMAT_RGB332, "WL_SHM_FORMAT_RGB332" );
	swigIntConstant( WL_SHM_FORMAT_BGR233, "WL_SHM_FORMAT_BGR233" );
	swigIntConstant( WL_SHM_FORMAT_XRGB4444, "WL_SHM_FORMAT_XRGB4444" );
	swigIntConstant( WL_SHM_FORMAT_XBGR4444, "WL_SHM_FORMAT_XBGR4444" );
	swigIntConstant( WL_SHM_FORMAT_RGBX4444, "WL_SHM_FORMAT_RGBX4444" );
	swigIntConstant( WL_SHM_FORMAT_BGRX4444, "WL_SHM_FORMAT_BGRX4444" );
	swigIntConstant( WL_SHM_FORMAT_ARGB4444, "WL_SHM_FORMAT_ARGB4444" );
	swigIntConstant( WL_SHM_FORMAT_ABGR4444, "WL_SHM_FORMAT_ABGR4444" );
	swigIntConstant( WL_SHM_FORMAT_RGBA4444, "WL_SHM_FORMAT_RGBA4444" );
	swigIntConstant( WL_SHM_FORMAT_BGRA4444, "WL_SHM_FORMAT_BGRA4444" );
	swigIntConstant( WL_SHM_FORMAT_XRGB1555, "WL_SHM_FORMAT_XRGB1555" );
	swigIntConstant( WL_SHM_FORMAT_XBGR1555, "WL_SHM_FORMAT_XBGR1555" );
	swigIntConstant( WL_SHM_FORMAT_RGBX5551, "WL_SHM_FORMAT_RGBX5551" );
	swigIntConstant( WL_SHM_FORMAT_BGRX5551, "WL_SHM_FORMAT_BGRX5551" );
	swigIntConstant( WL_SHM_FORMAT_ARGB1555, "WL_SHM_FORMAT_ARGB1555" );
	swigIntConstant( WL_SHM_FORMAT_ABGR1555, "WL_SHM_FORMAT_ABGR1555" );
	swigIntConstant( WL_SHM_FORMAT_RGBA5551, "WL_SHM_FORMAT_RGBA5551" );
	swigIntConstant( WL_SHM_FORMAT_BGRA5551, "WL_SHM_FORMAT_BGRA5551" );
	swigIntConstant( WL_SHM_FORMAT_RGB565, "WL_SHM_FORMAT_RGB565" );
	swigIntConstant( WL_SHM_FORMAT_BGR565, "WL_SHM_FORMAT_BGR565" );
	swigIntConstant( WL_SHM_FORMAT_RGB888, "WL_SHM_FORMAT_RGB888" );
	swigIntConstant( WL_SHM_FORMAT_BGR888, "WL_SHM_FORMAT_BGR888" );
	swigIntConstant( WL_SHM_FORMAT_XBGR8888, "WL_SHM_FORMAT_XBGR8888" );
	swigIntConstant( WL_SHM_FORMAT_RGBX8888, "WL_SHM_FORMAT_RGBX8888" );
	swigIntConstant( WL_SHM_FORMAT_BGRX8888, "WL_SHM_FORMAT_BGRX8888" );
	swigIntConstant( WL_SHM_FORMAT_ABGR8888, "WL_SHM_FORMAT_ABGR8888" );
	swigIntConstant( WL_SHM_FORMAT_RGBA8888, "WL_SHM_FORMAT_RGBA8888" );
	swigIntConstant( WL_SHM_FORMAT_BGRA8888, "WL_SHM_FORMAT_BGRA8888" );
	swigIntConstant( WL_SHM_FORMAT_XRGB2101010, "WL_SHM_FORMAT_XRGB2101010" );
	swigIntConstant( WL_SHM_FORMAT_XBGR2101010, "WL_SHM_FORMAT_XBGR2101010" );
	swigIntConstant( WL_SHM_FORMAT_RGBX1010102, "WL_SHM_FORMAT_RGBX1010102" );
	swigIntConstant( WL_SHM_FORMAT_BGRX1010102, "WL_SHM_FORMAT_BGRX1010102" );
	swigIntConstant( WL_SHM_FORMAT_ARGB2101010, "WL_SHM_FORMAT_ARGB2101010" );
	swigIntConstant( WL_SHM_FORMAT_ABGR2101010, "WL_SHM_FORMAT_ABGR2101010" );
	swigIntConstant( WL_SHM_FORMAT_RGBA1010102, "WL_SHM_FORMAT_RGBA1010102" );
	swigIntConstant( WL_SHM_FORMAT_BGRA1010102, "WL_SHM_FORMAT_BGRA1010102" );
	swigIntConstant( WL_SHM_FORMAT_YUYV, "WL_SHM_FORMAT_YUYV" );
	swigIntConstant( WL_SHM_FORMAT_YVYU, "WL_SHM_FORMAT_YVYU" );
	swigIntConstant( WL_SHM_FORMAT_UYVY, "WL_SHM_FORMAT_UYVY" );
	swigIntConstant( WL_SHM_FORMAT_VYUY, "WL_SHM_FORMAT_VYUY" );
	swigIntConstant( WL_SHM_FORMAT_AYUV, "WL_SHM_FORMAT_AYUV" );
	swigIntConstant( WL_SHM_FORMAT_NV12, "WL_SHM_FORMAT_NV12" );
	swigIntConstant( WL_SHM_FORMAT_NV21, "WL_SHM_FORMAT_NV21" );
	swigIntConstant( WL_SHM_FORMAT_NV16, "WL_SHM_FORMAT_NV16" );
	swigIntConstant( WL_SHM_FORMAT_NV61, "WL_SHM_FORMAT_NV61" );
	swigIntConstant( WL_SHM_FORMAT_YUV410, "WL_SHM_FORMAT_YUV410" );
	swigIntConstant( WL_SHM_FORMAT_YVU410, "WL_SHM_FORMAT_YVU410" );
	swigIntConstant( WL_SHM_FORMAT_YUV411, "WL_SHM_FORMAT_YUV411" );
	swigIntConstant( WL_SHM_FORMAT_YVU411, "WL_SHM_FORMAT_YVU411" );
	swigIntConstant( WL_SHM_FORMAT_YUV420, "WL_SHM_FORMAT_YUV420" );
	swigIntConstant( WL_SHM_FORMAT_YVU420, "WL_SHM_FORMAT_YVU420" );
	swigIntConstant( WL_SHM_FORMAT_YUV422, "WL_SHM_FORMAT_YUV422" );
	swigIntConstant( WL_SHM_FORMAT_YVU422, "WL_SHM_FORMAT_YVU422" );
	swigIntConstant( WL_SHM_FORMAT_YUV444, "WL_SHM_FORMAT_YUV444" );
	swigIntConstant( WL_SHM_FORMAT_YVU444, "WL_SHM_FORMAT_YVU444" );
	swigIntConstant( WL_SHM_FORMAT_R8, "WL_SHM_FORMAT_R8" );
	swigIntConstant( WL_SHM_FORMAT_R16, "WL_SHM_FORMAT_R16" );
	swigIntConstant( WL_SHM_FORMAT_RG88, "WL_SHM_FORMAT_RG88" );
	swigIntConstant( WL_SHM_FORMAT_GR88, "WL_SHM_FORMAT_GR88" );
	swigIntConstant( WL_SHM_FORMAT_RG1616, "WL_SHM_FORMAT_RG1616" );
	swigIntConstant( WL_SHM_FORMAT_GR1616, "WL_SHM_FORMAT_GR1616" );
	swigIntConstant( WL_SHM_FORMAT_XRGB16161616F, "WL_SHM_FORMAT_XRGB16161616F" );
	swigIntConstant( WL_SHM_FORMAT_XBGR16161616F, "WL_SHM_FORMAT_XBGR16161616F" );
	swigIntConstant( WL_SHM_FORMAT_ARGB16161616F, "WL_SHM_FORMAT_ARGB16161616F" );
	swigIntConstant( WL_SHM_FORMAT_ABGR16161616F, "WL_SHM_FORMAT_ABGR16161616F" );
	swigIntConstant( WL_SHM_FORMAT_XYUV8888, "WL_SHM_FORMAT_XYUV8888" );
	swigIntConstant( WL_SHM_FORMAT_VUY888, "WL_SHM_FORMAT_VUY888" );
	swigIntConstant( WL_SHM_FORMAT_VUY101010, "WL_SHM_FORMAT_VUY101010" );
	swigIntConstant( WL_SHM_FORMAT_Y210, "WL_SHM_FORMAT_Y210" );
	swigIntConstant( WL_SHM_FORMAT_Y212, "WL_SHM_FORMAT_Y212" );
	swigIntConstant( WL_SHM_FORMAT_Y216, "WL_SHM_FORMAT_Y216" );
	swigIntConstant( WL_SHM_FORMAT_Y410, "WL_SHM_FORMAT_Y410" );
	swigIntConstant( WL_SHM_FORMAT_Y412, "WL_SHM_FORMAT_Y412" );
	swigIntConstant( WL_SHM_FORMAT_Y416, "WL_SHM_FORMAT_Y416" );
	swigIntConstant( WL_SHM_FORMAT_XVYU2101010, "WL_SHM_FORMAT_XVYU2101010" );
	swigIntConstant( WL_SHM_FORMAT_XVYU12_16161616, "WL_SHM_FORMAT_XVYU12_16161616" );
	swigIntConstant( WL_SHM_FORMAT_XVYU16161616, "WL_SHM_FORMAT_XVYU16161616" );
	swigIntConstant( WL_SHM_FORMAT_Y0L0, "WL_SHM_FORMAT_Y0L0" );
	swigIntConstant( WL_SHM_FORMAT_X0L0, "WL_SHM_FORMAT_X0L0" );
	swigIntConstant( WL_SHM_FORMAT_Y0L2, "WL_SHM_FORMAT_Y0L2" );
	swigIntConstant( WL_SHM_FORMAT_X0L2, "WL_SHM_FORMAT_X0L2" );
	swigIntConstant( WL_SHM_FORMAT_YUV420_8BIT, "WL_SHM_FORMAT_YUV420_8BIT" );
	swigIntConstant( WL_SHM_FORMAT_YUV420_10BIT, "WL_SHM_FORMAT_YUV420_10BIT" );
	swigIntConstant( WL_SHM_FORMAT_XRGB8888_A8, "WL_SHM_FORMAT_XRGB8888_A8" );
	swigIntConstant( WL_SHM_FORMAT_XBGR8888_A8, "WL_SHM_FORMAT_XBGR8888_A8" );
	swigIntConstant( WL_SHM_FORMAT_RGBX8888_A8, "WL_SHM_FORMAT_RGBX8888_A8" );
	swigIntConstant( WL_SHM_FORMAT_BGRX8888_A8, "WL_SHM_FORMAT_BGRX8888_A8" );
	swigIntConstant( WL_SHM_FORMAT_RGB888_A8, "WL_SHM_FORMAT_RGB888_A8" );
	swigIntConstant( WL_SHM_FORMAT_BGR888_A8, "WL_SHM_FORMAT_BGR888_A8" );
	swigIntConstant( WL_SHM_FORMAT_RGB565_A8, "WL_SHM_FORMAT_RGB565_A8" );
	swigIntConstant( WL_SHM_FORMAT_BGR565_A8, "WL_SHM_FORMAT_BGR565_A8" );
	swigIntConstant( WL_SHM_FORMAT_NV24, "WL_SHM_FORMAT_NV24" );
	swigIntConstant( WL_SHM_FORMAT_NV42, "WL_SHM_FORMAT_NV42" );
	swigIntConstant( WL_SHM_FORMAT_P210, "WL_SHM_FORMAT_P210" );
	swigIntConstant( WL_SHM_FORMAT_P010, "WL_SHM_FORMAT_P010" );
	swigIntConstant( WL_SHM_FORMAT_P012, "WL_SHM_FORMAT_P012" );
	swigIntConstant( WL_SHM_FORMAT_P016, "WL_SHM_FORMAT_P016" );
	swigIntConstant( WL_SHM_FORMAT_AXBXGXRX106106106106, "WL_SHM_FORMAT_AXBXGXRX106106106106" );
	swigIntConstant( WL_SHM_FORMAT_NV15, "WL_SHM_FORMAT_NV15" );
	swigIntConstant( WL_SHM_FORMAT_Q410, "WL_SHM_FORMAT_Q410" );
	swigIntConstant( WL_SHM_FORMAT_Q401, "WL_SHM_FORMAT_Q401" );
	swigIntConstant( WL_SHM_FORMAT_XRGB16161616, "WL_SHM_FORMAT_XRGB16161616" );
	swigIntConstant( WL_SHM_FORMAT_XBGR16161616, "WL_SHM_FORMAT_XBGR16161616" );
	swigIntConstant( WL_SHM_FORMAT_ARGB16161616, "WL_SHM_FORMAT_ARGB16161616" );
	swigIntConstant( WL_SHM_FORMAT_ABGR16161616, "WL_SHM_FORMAT_ABGR16161616" );
	swigIntConstant( WL_DATA_OFFER_ERROR_INVALID_FINISH, "WL_DATA_OFFER_ERROR_INVALID_FINISH" );
	swigIntConstant( WL_DATA_OFFER_ERROR_INVALID_ACTION_MASK, "WL_DATA_OFFER_ERROR_INVALID_ACTION_MASK" );
	swigIntConstant( WL_DATA_OFFER_ERROR_INVALID_ACTION, "WL_DATA_OFFER_ERROR_INVALID_ACTION" );
	swigIntConstant( WL_DATA_OFFER_ERROR_INVALID_OFFER, "WL_DATA_OFFER_ERROR_INVALID_OFFER" );
	swigIntConstant( WL_DATA_SOURCE_ERROR_INVALID_ACTION_MASK, "WL_DATA_SOURCE_ERROR_INVALID_ACTION_MASK" );
	swigIntConstant( WL_DATA_SOURCE_ERROR_INVALID_SOURCE, "WL_DATA_SOURCE_ERROR_INVALID_SOURCE" );
	swigIntConstant( WL_DATA_DEVICE_ERROR_ROLE, "WL_DATA_DEVICE_ERROR_ROLE" );
	swigIntConstant( WL_DATA_DEVICE_MANAGER_DND_ACTION_NONE, "WL_DATA_DEVICE_MANAGER_DND_ACTION_NONE" );
	swigIntConstant( WL_DATA_DEVICE_MANAGER_DND_ACTION_COPY, "WL_DATA_DEVICE_MANAGER_DND_ACTION_COPY" );
	swigIntConstant( WL_DATA_DEVICE_MANAGER_DND_ACTION_MOVE, "WL_DATA_DEVICE_MANAGER_DND_ACTION_MOVE" );
	swigIntConstant( WL_DATA_DEVICE_MANAGER_DND_ACTION_ASK, "WL_DATA_DEVICE_MANAGER_DND_ACTION_ASK" );
	swigIntConstant( WL_SHELL_ERROR_ROLE, "WL_SHELL_ERROR_ROLE" );
	swigIntConstant( WL_SHELL_SURFACE_RESIZE_NONE, "WL_SHELL_SURFACE_RESIZE_NONE" );
	swigIntConstant( WL_SHELL_SURFACE_RESIZE_TOP, "WL_SHELL_SURFACE_RESIZE_TOP" );
	swigIntConstant( WL_SHELL_SURFACE_RESIZE_BOTTOM, "WL_SHELL_SURFACE_RESIZE_BOTTOM" );
	swigIntConstant( WL_SHELL_SURFACE_RESIZE_LEFT, "WL_SHELL_SURFACE_RESIZE_LEFT" );
	swigIntConstant( WL_SHELL_SURFACE_RESIZE_TOP_LEFT, "WL_SHELL_SURFACE_RESIZE_TOP_LEFT" );
	swigIntConstant( WL_SHELL_SURFACE_RESIZE_BOTTOM_LEFT, "WL_SHELL_SURFACE_RESIZE_BOTTOM_LEFT" );
	swigIntConstant( WL_SHELL_SURFACE_RESIZE_RIGHT, "WL_SHELL_SURFACE_RESIZE_RIGHT" );
	swigIntConstant( WL_SHELL_SURFACE_RESIZE_TOP_RIGHT, "WL_SHELL_SURFACE_RESIZE_TOP_RIGHT" );
	swigIntConstant( WL_SHELL_SURFACE_RESIZE_BOTTOM_RIGHT, "WL_SHELL_SURFACE_RESIZE_BOTTOM_RIGHT" );
	swigIntConstant( WL_SHELL_SURFACE_TRANSIENT_INACTIVE, "WL_SHELL_SURFACE_TRANSIENT_INACTIVE" );
	swigIntConstant( WL_SHELL_SURFACE_FULLSCREEN_METHOD_DEFAULT, "WL_SHELL_SURFACE_FULLSCREEN_METHOD_DEFAULT" );
	swigIntConstant( WL_SHELL_SURFACE_FULLSCREEN_METHOD_SCALE, "WL_SHELL_SURFACE_FULLSCREEN_METHOD_SCALE" );
	swigIntConstant( WL_SHELL_SURFACE_FULLSCREEN_METHOD_DRIVER, "WL_SHELL_SURFACE_FULLSCREEN_METHOD_DRIVER" );
	swigIntConstant( WL_SHELL_SURFACE_FULLSCREEN_METHOD_FILL, "WL_SHELL_SURFACE_FULLSCREEN_METHOD_FILL" );
	swigIntConstant( WL_SURFACE_ERROR_INVALID_SCALE, "WL_SURFACE_ERROR_INVALID_SCALE" );
	swigIntConstant( WL_SURFACE_ERROR_INVALID_TRANSFORM, "WL_SURFACE_ERROR_INVALID_TRANSFORM" );
	swigIntConstant( WL_SURFACE_ERROR_INVALID_SIZE, "WL_SURFACE_ERROR_INVALID_SIZE" );
	swigIntConstant( WL_SURFACE_ERROR_INVALID_OFFSET, "WL_SURFACE_ERROR_INVALID_OFFSET" );
	swigIntConstant( WL_SURFACE_ERROR_DEFUNCT_ROLE_OBJECT, "WL_SURFACE_ERROR_DEFUNCT_ROLE_OBJECT" );
	swigIntConstant( WL_SEAT_CAPABILITY_POINTER, "WL_SEAT_CAPABILITY_POINTER" );
	swigIntConstant( WL_SEAT_CAPABILITY_KEYBOARD, "WL_SEAT_CAPABILITY_KEYBOARD" );
	swigIntConstant( WL_SEAT_CAPABILITY_TOUCH, "WL_SEAT_CAPABILITY_TOUCH" );
	swigIntConstant( WL_SEAT_ERROR_MISSING_CAPABILITY, "WL_SEAT_ERROR_MISSING_CAPABILITY" );
	swigIntConstant( WL_POINTER_ERROR_ROLE, "WL_POINTER_ERROR_ROLE" );
	swigIntConstant( WL_POINTER_BUTTON_STATE_RELEASED, "WL_POINTER_BUTTON_STATE_RELEASED" );
	swigIntConstant( WL_POINTER_BUTTON_STATE_PRESSED, "WL_POINTER_BUTTON_STATE_PRESSED" );
	swigIntConstant( WL_POINTER_AXIS_VERTICAL_SCROLL, "WL_POINTER_AXIS_VERTICAL_SCROLL" );
	swigIntConstant( WL_POINTER_AXIS_HORIZONTAL_SCROLL, "WL_POINTER_AXIS_HORIZONTAL_SCROLL" );
	swigIntConstant( WL_POINTER_AXIS_SOURCE_WHEEL, "WL_POINTER_AXIS_SOURCE_WHEEL" );
	swigIntConstant( WL_POINTER_AXIS_SOURCE_FINGER, "WL_POINTER_AXIS_SOURCE_FINGER" );
	swigIntConstant( WL_POINTER_AXIS_SOURCE_CONTINUOUS, "WL_POINTER_AXIS_SOURCE_CONTINUOUS" );
	swigIntConstant( WL_POINTER_AXIS_SOURCE_WHEEL_TILT, "WL_POINTER_AXIS_SOURCE_WHEEL_TILT" );
	swigIntConstant( WL_POINTER_AXIS_RELATIVE_DIRECTION_IDENTICAL, "WL_POINTER_AXIS_RELATIVE_DIRECTION_IDENTICAL" );
	swigIntConstant( WL_POINTER_AXIS_RELATIVE_DIRECTION_INVERTED, "WL_POINTER_AXIS_RELATIVE_DIRECTION_INVERTED" );
	swigIntConstant( WL_KEYBOARD_KEYMAP_FORMAT_NO_KEYMAP, "WL_KEYBOARD_KEYMAP_FORMAT_NO_KEYMAP" );
	swigIntConstant( WL_KEYBOARD_KEYMAP_FORMAT_XKB_V1, "WL_KEYBOARD_KEYMAP_FORMAT_XKB_V1" );
	swigIntConstant( WL_KEYBOARD_KEY_STATE_RELEASED, "WL_KEYBOARD_KEY_STATE_RELEASED" );
	swigIntConstant( WL_KEYBOARD_KEY_STATE_PRESSED, "WL_KEYBOARD_KEY_STATE_PRESSED" );
	swigIntConstant( WL_OUTPUT_SUBPIXEL_UNKNOWN, "WL_OUTPUT_SUBPIXEL_UNKNOWN" );
	swigIntConstant( WL_OUTPUT_SUBPIXEL_NONE, "WL_OUTPUT_SUBPIXEL_NONE" );
	swigIntConstant( WL_OUTPUT_SUBPIXEL_HORIZONTAL_RGB, "WL_OUTPUT_SUBPIXEL_HORIZONTAL_RGB" );
	swigIntConstant( WL_OUTPUT_SUBPIXEL_HORIZONTAL_BGR, "WL_OUTPUT_SUBPIXEL_HORIZONTAL_BGR" );
	swigIntConstant( WL_OUTPUT_SUBPIXEL_VERTICAL_RGB, "WL_OUTPUT_SUBPIXEL_VERTICAL_RGB" );
	swigIntConstant( WL_OUTPUT_SUBPIXEL_VERTICAL_BGR, "WL_OUTPUT_SUBPIXEL_VERTICAL_BGR" );
	swigIntConstant( WL_OUTPUT_TRANSFORM_NORMAL, "WL_OUTPUT_TRANSFORM_NORMAL" );
	swigIntConstant( WL_OUTPUT_TRANSFORM_90, "WL_OUTPUT_TRANSFORM_90" );
	swigIntConstant( WL_OUTPUT_TRANSFORM_180, "WL_OUTPUT_TRANSFORM_180" );
	swigIntConstant( WL_OUTPUT_TRANSFORM_270, "WL_OUTPUT_TRANSFORM_270" );
	swigIntConstant( WL_OUTPUT_TRANSFORM_FLIPPED, "WL_OUTPUT_TRANSFORM_FLIPPED" );
	swigIntConstant( WL_OUTPUT_TRANSFORM_FLIPPED_90, "WL_OUTPUT_TRANSFORM_FLIPPED_90" );
	swigIntConstant( WL_OUTPUT_TRANSFORM_FLIPPED_180, "WL_OUTPUT_TRANSFORM_FLIPPED_180" );
	swigIntConstant( WL_OUTPUT_TRANSFORM_FLIPPED_270, "WL_OUTPUT_TRANSFORM_FLIPPED_270" );
	swigIntConstant( WL_OUTPUT_MODE_CURRENT, "WL_OUTPUT_MODE_CURRENT" );
	swigIntConstant( WL_OUTPUT_MODE_PREFERRED, "WL_OUTPUT_MODE_PREFERRED" );
	swigIntConstant( WL_SUBCOMPOSITOR_ERROR_BAD_SURFACE, "WL_SUBCOMPOSITOR_ERROR_BAD_SURFACE" );
	swigIntConstant( WL_SUBCOMPOSITOR_ERROR_BAD_PARENT, "WL_SUBCOMPOSITOR_ERROR_BAD_PARENT" );
	swigIntConstant( WL_SUBSURFACE_ERROR_BAD_SURFACE, "WL_SUBSURFACE_ERROR_BAD_SURFACE" );
	swigIntConstant( WL_ITERATOR_STOP, "WL_ITERATOR_STOP" );
	swigIntConstant( WL_ITERATOR_CONTINUE, "WL_ITERATOR_CONTINUE" );
	swigIntConstant( ZWP_TEXT_INPUT_V3_CHANGE_CAUSE_INPUT_METHOD, "ZWP_TEXT_INPUT_V3_CHANGE_CAUSE_INPUT_METHOD" );
	swigIntConstant( ZWP_TEXT_INPUT_V3_CHANGE_CAUSE_OTHER, "ZWP_TEXT_INPUT_V3_CHANGE_CAUSE_OTHER" );
	swigIntConstant( ZWP_TEXT_INPUT_V3_CONTENT_HINT_NONE, "ZWP_TEXT_INPUT_V3_CONTENT_HINT_NONE" );
	swigIntConstant( ZWP_TEXT_INPUT_V3_CONTENT_HINT_COMPLETION, "ZWP_TEXT_INPUT_V3_CONTENT_HINT_COMPLETION" );
	swigIntConstant( ZWP_TEXT_INPUT_V3_CONTENT_HINT_SPELLCHECK, "ZWP_TEXT_INPUT_V3_CONTENT_HINT_SPELLCHECK" );
	swigIntConstant( ZWP_TEXT_INPUT_V3_CONTENT_HINT_AUTO_CAPITALIZATION, "ZWP_TEXT_INPUT_V3_CONTENT_HINT_AUTO_CAPITALIZATION" );
	swigIntConstant( ZWP_TEXT_INPUT_V3_CONTENT_HINT_LOWERCASE, "ZWP_TEXT_INPUT_V3_CONTENT_HINT_LOWERCASE" );
	swigIntConstant( ZWP_TEXT_INPUT_V3_CONTENT_HINT_UPPERCASE, "ZWP_TEXT_INPUT_V3_CONTENT_HINT_UPPERCASE" );
	swigIntConstant( ZWP_TEXT_INPUT_V3_CONTENT_HINT_TITLECASE, "ZWP_TEXT_INPUT_V3_CONTENT_HINT_TITLECASE" );
	swigIntConstant( ZWP_TEXT_INPUT_V3_CONTENT_HINT_HIDDEN_TEXT, "ZWP_TEXT_INPUT_V3_CONTENT_HINT_HIDDEN_TEXT" );
	swigIntConstant( ZWP_TEXT_INPUT_V3_CONTENT_HINT_SENSITIVE_DATA, "ZWP_TEXT_INPUT_V3_CONTENT_HINT_SENSITIVE_DATA" );
	swigIntConstant( ZWP_TEXT_INPUT_V3_CONTENT_HINT_LATIN, "ZWP_TEXT_INPUT_V3_CONTENT_HINT_LATIN" );
	swigIntConstant( ZWP_TEXT_INPUT_V3_CONTENT_HINT_MULTILINE, "ZWP_TEXT_INPUT_V3_CONTENT_HINT_MULTILINE" );
	swigIntConstant( ZWP_TEXT_INPUT_V3_CONTENT_PURPOSE_NORMAL, "ZWP_TEXT_INPUT_V3_CONTENT_PURPOSE_NORMAL" );
	swigIntConstant( ZWP_TEXT_INPUT_V3_CONTENT_PURPOSE_ALPHA, "ZWP_TEXT_INPUT_V3_CONTENT_PURPOSE_ALPHA" );
	swigIntConstant( ZWP_TEXT_INPUT_V3_CONTENT_PURPOSE_DIGITS, "ZWP_TEXT_INPUT_V3_CONTENT_PURPOSE_DIGITS" );
	swigIntConstant( ZWP_TEXT_INPUT_V3_CONTENT_PURPOSE_NUMBER, "ZWP_TEXT_INPUT_V3_CONTENT_PURPOSE_NUMBER" );
	swigIntConstant( ZWP_TEXT_INPUT_V3_CONTENT_PURPOSE_PHONE, "ZWP_TEXT_INPUT_V3_CONTENT_PURPOSE_PHONE" );
	swigIntConstant( ZWP_TEXT_INPUT_V3_CONTENT_PURPOSE_URL, "ZWP_TEXT_INPUT_V3_CONTENT_PURPOSE_URL" );
	swigIntConstant( ZWP_TEXT_INPUT_V3_CONTENT_PURPOSE_EMAIL, "ZWP_TEXT_INPUT_V3_CONTENT_PURPOSE_EMAIL" );
	swigIntConstant( ZWP_TEXT_INPUT_V3_CONTENT_PURPOSE_NAME, "ZWP_TEXT_INPUT_V3_CONTENT_PURPOSE_NAME" );
	swigIntConstant( ZWP_TEXT_INPUT_V3_CONTENT_PURPOSE_PASSWORD, "ZWP_TEXT_INPUT_V3_CONTENT_PURPOSE_PASSWORD" );
	swigIntConstant( ZWP_TEXT_INPUT_V3_CONTENT_PURPOSE_PIN, "ZWP_TEXT_INPUT_V3_CONTENT_PURPOSE_PIN" );
	swigIntConstant( ZWP_TEXT_INPUT_V3_CONTENT_PURPOSE_DATE, "ZWP_TEXT_INPUT_V3_CONTENT_PURPOSE_DATE" );
	swigIntConstant( ZWP_TEXT_INPUT_V3_CONTENT_PURPOSE_TIME, "ZWP_TEXT_INPUT_V3_CONTENT_PURPOSE_TIME" );
	swigIntConstant( ZWP_TEXT_INPUT_V3_CONTENT_PURPOSE_DATETIME, "ZWP_TEXT_INPUT_V3_CONTENT_PURPOSE_DATETIME" );
	swigIntConstant( ZWP_TEXT_INPUT_V3_CONTENT_PURPOSE_TERMINAL, "ZWP_TEXT_INPUT_V3_CONTENT_PURPOSE_TERMINAL" );
	swigIntConstant( XDG_WM_BASE_ERROR_ROLE, "XDG_WM_BASE_ERROR_ROLE" );
	swigIntConstant( XDG_WM_BASE_ERROR_DEFUNCT_SURFACES, "XDG_WM_BASE_ERROR_DEFUNCT_SURFACES" );
	swigIntConstant( XDG_WM_BASE_ERROR_NOT_THE_TOPMOST_POPUP, "XDG_WM_BASE_ERROR_NOT_THE_TOPMOST_POPUP" );
	swigIntConstant( XDG_WM_BASE_ERROR_INVALID_POPUP_PARENT, "XDG_WM_BASE_ERROR_INVALID_POPUP_PARENT" );
	swigIntConstant( XDG_WM_BASE_ERROR_INVALID_SURFACE_STATE, "XDG_WM_BASE_ERROR_INVALID_SURFACE_STATE" );
	swigIntConstant( XDG_WM_BASE_ERROR_INVALID_POSITIONER, "XDG_WM_BASE_ERROR_INVALID_POSITIONER" );
	swigIntConstant( XDG_WM_BASE_ERROR_UNRESPONSIVE, "XDG_WM_BASE_ERROR_UNRESPONSIVE" );
	swigIntConstant( XDG_POSITIONER_ERROR_INVALID_INPUT, "XDG_POSITIONER_ERROR_INVALID_INPUT" );
	swigIntConstant( XDG_POSITIONER_ANCHOR_NONE, "XDG_POSITIONER_ANCHOR_NONE" );
	swigIntConstant( XDG_POSITIONER_ANCHOR_TOP, "XDG_POSITIONER_ANCHOR_TOP" );
	swigIntConstant( XDG_POSITIONER_ANCHOR_BOTTOM, "XDG_POSITIONER_ANCHOR_BOTTOM" );
	swigIntConstant( XDG_POSITIONER_ANCHOR_LEFT, "XDG_POSITIONER_ANCHOR_LEFT" );
	swigIntConstant( XDG_POSITIONER_ANCHOR_RIGHT, "XDG_POSITIONER_ANCHOR_RIGHT" );
	swigIntConstant( XDG_POSITIONER_ANCHOR_TOP_LEFT, "XDG_POSITIONER_ANCHOR_TOP_LEFT" );
	swigIntConstant( XDG_POSITIONER_ANCHOR_BOTTOM_LEFT, "XDG_POSITIONER_ANCHOR_BOTTOM_LEFT" );
	swigIntConstant( XDG_POSITIONER_ANCHOR_TOP_RIGHT, "XDG_POSITIONER_ANCHOR_TOP_RIGHT" );
	swigIntConstant( XDG_POSITIONER_ANCHOR_BOTTOM_RIGHT, "XDG_POSITIONER_ANCHOR_BOTTOM_RIGHT" );
	swigIntConstant( XDG_POSITIONER_GRAVITY_NONE, "XDG_POSITIONER_GRAVITY_NONE" );
	swigIntConstant( XDG_POSITIONER_GRAVITY_TOP, "XDG_POSITIONER_GRAVITY_TOP" );
	swigIntConstant( XDG_POSITIONER_GRAVITY_BOTTOM, "XDG_POSITIONER_GRAVITY_BOTTOM" );
	swigIntConstant( XDG_POSITIONER_GRAVITY_LEFT, "XDG_POSITIONER_GRAVITY_LEFT" );
	swigIntConstant( XDG_POSITIONER_GRAVITY_RIGHT, "XDG_POSITIONER_GRAVITY_RIGHT" );
	swigIntConstant( XDG_POSITIONER_GRAVITY_TOP_LEFT, "XDG_POSITIONER_GRAVITY_TOP_LEFT" );
	swigIntConstant( XDG_POSITIONER_GRAVITY_BOTTOM_LEFT, "XDG_POSITIONER_GRAVITY_BOTTOM_LEFT" );
	swigIntConstant( XDG_POSITIONER_GRAVITY_TOP_RIGHT, "XDG_POSITIONER_GRAVITY_TOP_RIGHT" );
	swigIntConstant( XDG_POSITIONER_GRAVITY_BOTTOM_RIGHT, "XDG_POSITIONER_GRAVITY_BOTTOM_RIGHT" );
	swigIntConstant( XDG_POSITIONER_CONSTRAINT_ADJUSTMENT_NONE, "XDG_POSITIONER_CONSTRAINT_ADJUSTMENT_NONE" );
	swigIntConstant( XDG_POSITIONER_CONSTRAINT_ADJUSTMENT_SLIDE_X, "XDG_POSITIONER_CONSTRAINT_ADJUSTMENT_SLIDE_X" );
	swigIntConstant( XDG_POSITIONER_CONSTRAINT_ADJUSTMENT_SLIDE_Y, "XDG_POSITIONER_CONSTRAINT_ADJUSTMENT_SLIDE_Y" );
	swigIntConstant( XDG_POSITIONER_CONSTRAINT_ADJUSTMENT_FLIP_X, "XDG_POSITIONER_CONSTRAINT_ADJUSTMENT_FLIP_X" );
	swigIntConstant( XDG_POSITIONER_CONSTRAINT_ADJUSTMENT_FLIP_Y, "XDG_POSITIONER_CONSTRAINT_ADJUSTMENT_FLIP_Y" );
	swigIntConstant( XDG_POSITIONER_CONSTRAINT_ADJUSTMENT_RESIZE_X, "XDG_POSITIONER_CONSTRAINT_ADJUSTMENT_RESIZE_X" );
	swigIntConstant( XDG_POSITIONER_CONSTRAINT_ADJUSTMENT_RESIZE_Y, "XDG_POSITIONER_CONSTRAINT_ADJUSTMENT_RESIZE_Y" );
	swigIntConstant( XDG_SURFACE_ERROR_NOT_CONSTRUCTED, "XDG_SURFACE_ERROR_NOT_CONSTRUCTED" );
	swigIntConstant( XDG_SURFACE_ERROR_ALREADY_CONSTRUCTED, "XDG_SURFACE_ERROR_ALREADY_CONSTRUCTED" );
	swigIntConstant( XDG_SURFACE_ERROR_UNCONFIGURED_BUFFER, "XDG_SURFACE_ERROR_UNCONFIGURED_BUFFER" );
	swigIntConstant( XDG_SURFACE_ERROR_INVALID_SERIAL, "XDG_SURFACE_ERROR_INVALID_SERIAL" );
	swigIntConstant( XDG_SURFACE_ERROR_INVALID_SIZE, "XDG_SURFACE_ERROR_INVALID_SIZE" );
	swigIntConstant( XDG_SURFACE_ERROR_DEFUNCT_ROLE_OBJECT, "XDG_SURFACE_ERROR_DEFUNCT_ROLE_OBJECT" );
	swigIntConstant( XDG_TOPLEVEL_ERROR_INVALID_RESIZE_EDGE, "XDG_TOPLEVEL_ERROR_INVALID_RESIZE_EDGE" );
	swigIntConstant( XDG_TOPLEVEL_ERROR_INVALID_PARENT, "XDG_TOPLEVEL_ERROR_INVALID_PARENT" );
	swigIntConstant( XDG_TOPLEVEL_ERROR_INVALID_SIZE, "XDG_TOPLEVEL_ERROR_INVALID_SIZE" );
	swigIntConstant( XDG_TOPLEVEL_RESIZE_EDGE_NONE, "XDG_TOPLEVEL_RESIZE_EDGE_NONE" );
	swigIntConstant( XDG_TOPLEVEL_RESIZE_EDGE_TOP, "XDG_TOPLEVEL_RESIZE_EDGE_TOP" );
	swigIntConstant( XDG_TOPLEVEL_RESIZE_EDGE_BOTTOM, "XDG_TOPLEVEL_RESIZE_EDGE_BOTTOM" );
	swigIntConstant( XDG_TOPLEVEL_RESIZE_EDGE_LEFT, "XDG_TOPLEVEL_RESIZE_EDGE_LEFT" );
	swigIntConstant( XDG_TOPLEVEL_RESIZE_EDGE_TOP_LEFT, "XDG_TOPLEVEL_RESIZE_EDGE_TOP_LEFT" );
	swigIntConstant( XDG_TOPLEVEL_RESIZE_EDGE_BOTTOM_LEFT, "XDG_TOPLEVEL_RESIZE_EDGE_BOTTOM_LEFT" );
	swigIntConstant( XDG_TOPLEVEL_RESIZE_EDGE_RIGHT, "XDG_TOPLEVEL_RESIZE_EDGE_RIGHT" );
	swigIntConstant( XDG_TOPLEVEL_RESIZE_EDGE_TOP_RIGHT, "XDG_TOPLEVEL_RESIZE_EDGE_TOP_RIGHT" );
	swigIntConstant( XDG_TOPLEVEL_RESIZE_EDGE_BOTTOM_RIGHT, "XDG_TOPLEVEL_RESIZE_EDGE_BOTTOM_RIGHT" );
	swigIntConstant( XDG_TOPLEVEL_STATE_MAXIMIZED, "XDG_TOPLEVEL_STATE_MAXIMIZED" );
	swigIntConstant( XDG_TOPLEVEL_STATE_FULLSCREEN, "XDG_TOPLEVEL_STATE_FULLSCREEN" );
	swigIntConstant( XDG_TOPLEVEL_STATE_RESIZING, "XDG_TOPLEVEL_STATE_RESIZING" );
	swigIntConstant( XDG_TOPLEVEL_STATE_ACTIVATED, "XDG_TOPLEVEL_STATE_ACTIVATED" );
	swigIntConstant( XDG_TOPLEVEL_STATE_TILED_LEFT, "XDG_TOPLEVEL_STATE_TILED_LEFT" );
	swigIntConstant( XDG_TOPLEVEL_STATE_TILED_RIGHT, "XDG_TOPLEVEL_STATE_TILED_RIGHT" );
	swigIntConstant( XDG_TOPLEVEL_STATE_TILED_TOP, "XDG_TOPLEVEL_STATE_TILED_TOP" );
	swigIntConstant( XDG_TOPLEVEL_STATE_TILED_BOTTOM, "XDG_TOPLEVEL_STATE_TILED_BOTTOM" );
	swigIntConstant( XDG_TOPLEVEL_STATE_SUSPENDED, "XDG_TOPLEVEL_STATE_SUSPENDED" );
	swigIntConstant( XDG_TOPLEVEL_WM_CAPABILITIES_WINDOW_MENU, "XDG_TOPLEVEL_WM_CAPABILITIES_WINDOW_MENU" );
	swigIntConstant( XDG_TOPLEVEL_WM_CAPABILITIES_MAXIMIZE, "XDG_TOPLEVEL_WM_CAPABILITIES_MAXIMIZE" );
	swigIntConstant( XDG_TOPLEVEL_WM_CAPABILITIES_FULLSCREEN, "XDG_TOPLEVEL_WM_CAPABILITIES_FULLSCREEN" );
	swigIntConstant( XDG_TOPLEVEL_WM_CAPABILITIES_MINIMIZE, "XDG_TOPLEVEL_WM_CAPABILITIES_MINIMIZE" );
	swigIntConstant( XDG_POPUP_ERROR_INVALID_GRAB, "XDG_POPUP_ERROR_INVALID_GRAB" );
	swigIntConstant( ZXDG_TOPLEVEL_DECORATION_V1_ERROR_UNCONFIGURED_BUFFER, "ZXDG_TOPLEVEL_DECORATION_V1_ERROR_UNCONFIGURED_BUFFER" );
	swigIntConstant( ZXDG_TOPLEVEL_DECORATION_V1_ERROR_ALREADY_CONSTRUCTED, "ZXDG_TOPLEVEL_DECORATION_V1_ERROR_ALREADY_CONSTRUCTED" );
	swigIntConstant( ZXDG_TOPLEVEL_DECORATION_V1_ERROR_ORPHANED, "ZXDG_TOPLEVEL_DECORATION_V1_ERROR_ORPHANED" );
	swigIntConstant( ZXDG_TOPLEVEL_DECORATION_V1_MODE_CLIENT_SIDE, "ZXDG_TOPLEVEL_DECORATION_V1_MODE_CLIENT_SIDE" );
	swigIntConstant( ZXDG_TOPLEVEL_DECORATION_V1_MODE_SERVER_SIDE, "ZXDG_TOPLEVEL_DECORATION_V1_MODE_SERVER_SIDE" );
	swigIntConstant( ZWP_TABLET_TOOL_V2_TYPE_PEN, "ZWP_TABLET_TOOL_V2_TYPE_PEN" );
	swigIntConstant( ZWP_TABLET_TOOL_V2_TYPE_ERASER, "ZWP_TABLET_TOOL_V2_TYPE_ERASER" );
	swigIntConstant( ZWP_TABLET_TOOL_V2_TYPE_BRUSH, "ZWP_TABLET_TOOL_V2_TYPE_BRUSH" );
	swigIntConstant( ZWP_TABLET_TOOL_V2_TYPE_PENCIL, "ZWP_TABLET_TOOL_V2_TYPE_PENCIL" );
	swigIntConstant( ZWP_TABLET_TOOL_V2_TYPE_AIRBRUSH, "ZWP_TABLET_TOOL_V2_TYPE_AIRBRUSH" );
	swigIntConstant( ZWP_TABLET_TOOL_V2_TYPE_FINGER, "ZWP_TABLET_TOOL_V2_TYPE_FINGER" );
	swigIntConstant( ZWP_TABLET_TOOL_V2_TYPE_MOUSE, "ZWP_TABLET_TOOL_V2_TYPE_MOUSE" );
	swigIntConstant( ZWP_TABLET_TOOL_V2_TYPE_LENS, "ZWP_TABLET_TOOL_V2_TYPE_LENS" );
	swigIntConstant( ZWP_TABLET_TOOL_V2_CAPABILITY_TILT, "ZWP_TABLET_TOOL_V2_CAPABILITY_TILT" );
	swigIntConstant( ZWP_TABLET_TOOL_V2_CAPABILITY_PRESSURE, "ZWP_TABLET_TOOL_V2_CAPABILITY_PRESSURE" );
	swigIntConstant( ZWP_TABLET_TOOL_V2_CAPABILITY_DISTANCE, "ZWP_TABLET_TOOL_V2_CAPABILITY_DISTANCE" );
	swigIntConstant( ZWP_TABLET_TOOL_V2_CAPABILITY_ROTATION, "ZWP_TABLET_TOOL_V2_CAPABILITY_ROTATION" );
	swigIntConstant( ZWP_TABLET_TOOL_V2_CAPABILITY_SLIDER, "ZWP_TABLET_TOOL_V2_CAPABILITY_SLIDER" );
	swigIntConstant( ZWP_TABLET_TOOL_V2_CAPABILITY_WHEEL, "ZWP_TABLET_TOOL_V2_CAPABILITY_WHEEL" );
	swigIntConstant( ZWP_TABLET_TOOL_V2_BUTTON_STATE_RELEASED, "ZWP_TABLET_TOOL_V2_BUTTON_STATE_RELEASED" );
	swigIntConstant( ZWP_TABLET_TOOL_V2_BUTTON_STATE_PRESSED, "ZWP_TABLET_TOOL_V2_BUTTON_STATE_PRESSED" );
	swigIntConstant( ZWP_TABLET_TOOL_V2_ERROR_ROLE, "ZWP_TABLET_TOOL_V2_ERROR_ROLE" );
	swigIntConstant( ZWP_TABLET_PAD_RING_V2_SOURCE_FINGER, "ZWP_TABLET_PAD_RING_V2_SOURCE_FINGER" );
	swigIntConstant( ZWP_TABLET_PAD_STRIP_V2_SOURCE_FINGER, "ZWP_TABLET_PAD_STRIP_V2_SOURCE_FINGER" );
	swigIntConstant( ZWP_TABLET_PAD_V2_BUTTON_STATE_RELEASED, "ZWP_TABLET_PAD_V2_BUTTON_STATE_RELEASED" );
	swigIntConstant( ZWP_TABLET_PAD_V2_BUTTON_STATE_PRESSED, "ZWP_TABLET_PAD_V2_BUTTON_STATE_PRESSED" );

	swigNewline();

	swigComment("-------===< structs >===--------\n");

	swigComment("struct wl_display_listener\n");
	printf( "begin-structure wl_display_listener\n" );
	swigStructField( "wl_display_listener-error", offsetof( struct wl_display_listener, error ), sizeof( void (*)(void *,struct wl_display *,void *,uint32_t,char const *) ) );
	swigStructField( "wl_display_listener-delete_id", offsetof( struct wl_display_listener, delete_id ), sizeof( void (*)(void *,struct wl_display *,uint32_t) ) );
	printf( "drop %zu end-structure\n", sizeof( struct wl_display_listener ) );

	swigComment("struct wl_registry_listener\n");
	printf( "begin-structure wl_registry_listener\n" );
	swigStructField( "wl_registry_listener-global_remove", offsetof( struct wl_registry_listener, global_remove ), sizeof( void (*)(void *,struct wl_registry *,uint32_t) ) );
	swigStructField( "wl_registry_listener-global", offsetof( struct wl_registry_listener, global ), sizeof( void (*)(void *,struct wl_registry *,uint32_t,char const *,uint32_t) ) );
	printf( "drop %zu end-structure\n", sizeof( struct wl_registry_listener ) );

	swigComment("struct wl_callback_listener\n");
	printf( "begin-structure wl_callback_listener\n" );
	swigStructField( "wl_callback_listener-done", offsetof( struct wl_callback_listener, done ), sizeof( void (*)(void *,struct wl_callback *,uint32_t) ) );
	printf( "drop %zu end-structure\n", sizeof( struct wl_callback_listener ) );

	swigComment("struct wl_shm_listener\n");
	printf( "begin-structure wl_shm_listener\n" );
	swigStructField( "wl_shm_listener-format", offsetof( struct wl_shm_listener, format ), sizeof( void (*)(void *,struct wl_shm *,uint32_t) ) );
	printf( "drop %zu end-structure\n", sizeof( struct wl_shm_listener ) );

	swigComment("struct wl_buffer_listener\n");
	printf( "begin-structure wl_buffer_listener\n" );
	swigStructField( "wl_buffer_listener-release", offsetof( struct wl_buffer_listener, release ), sizeof( void (*)(void *,struct wl_buffer *) ) );
	printf( "drop %zu end-structure\n", sizeof( struct wl_buffer_listener ) );

	swigComment("struct wl_data_offer_listener\n");
	printf( "begin-structure wl_data_offer_listener\n" );
	swigStructField( "wl_data_offer_listener-offer", offsetof( struct wl_data_offer_listener, offer ), sizeof( void (*)(void *,struct wl_data_offer *,char const *) ) );
	swigStructField( "wl_data_offer_listener-source_actions", offsetof( struct wl_data_offer_listener, source_actions ), sizeof( void (*)(void *,struct wl_data_offer *,uint32_t) ) );
	swigStructField( "wl_data_offer_listener-action", offsetof( struct wl_data_offer_listener, action ), sizeof( void (*)(void *,struct wl_data_offer *,uint32_t) ) );
	printf( "drop %zu end-structure\n", sizeof( struct wl_data_offer_listener ) );

	swigComment("struct wl_data_source_listener\n");
	printf( "begin-structure wl_data_source_listener\n" );
	swigStructField( "wl_data_source_listener-cancelled", offsetof( struct wl_data_source_listener, cancelled ), sizeof( void (*)(void *,struct wl_data_source *) ) );
	swigStructField( "wl_data_source_listener-dnd_finished", offsetof( struct wl_data_source_listener, dnd_finished ), sizeof( void (*)(void *,struct wl_data_source *) ) );
	swigStructField( "wl_data_source_listener-target", offsetof( struct wl_data_source_listener, target ), sizeof( void (*)(void *,struct wl_data_source *,char const *) ) );
	swigStructField( "wl_data_source_listener-send", offsetof( struct wl_data_source_listener, send ), sizeof( void (*)(void *,struct wl_data_source *,char const *,int32_t) ) );
	swigStructField( "wl_data_source_listener-dnd_drop_performed", offsetof( struct wl_data_source_listener, dnd_drop_performed ), sizeof( void (*)(void *,struct wl_data_source *) ) );
	swigStructField( "wl_data_source_listener-action", offsetof( struct wl_data_source_listener, action ), sizeof( void (*)(void *,struct wl_data_source *,uint32_t) ) );
	printf( "drop %zu end-structure\n", sizeof( struct wl_data_source_listener ) );

	swigComment("struct wl_data_device_listener\n");
	printf( "begin-structure wl_data_device_listener\n" );
	swigStructField( "wl_data_device_listener-motion", offsetof( struct wl_data_device_listener, motion ), sizeof( void (*)(void *,struct wl_data_device *,uint32_t,wl_fixed_t,wl_fixed_t) ) );
	swigStructField( "wl_data_device_listener-drop", offsetof( struct wl_data_device_listener, drop ), sizeof( void (*)(void *,struct wl_data_device *) ) );
	swigStructField( "wl_data_device_listener-enter", offsetof( struct wl_data_device_listener, enter ), sizeof( void (*)(void *,struct wl_data_device *,uint32_t,struct wl_surface *,wl_fixed_t,wl_fixed_t,struct wl_data_offer *) ) );
	swigStructField( "wl_data_device_listener-leave", offsetof( struct wl_data_device_listener, leave ), sizeof( void (*)(void *,struct wl_data_device *) ) );
	swigStructField( "wl_data_device_listener-data_offer", offsetof( struct wl_data_device_listener, data_offer ), sizeof( void (*)(void *,struct wl_data_device *,struct wl_data_offer *) ) );
	swigStructField( "wl_data_device_listener-selection", offsetof( struct wl_data_device_listener, selection ), sizeof( void (*)(void *,struct wl_data_device *,struct wl_data_offer *) ) );
	printf( "drop %zu end-structure\n", sizeof( struct wl_data_device_listener ) );

	swigComment("struct wl_shell_surface_listener\n");
	printf( "begin-structure wl_shell_surface_listener\n" );
	swigStructField( "wl_shell_surface_listener-popup_done", offsetof( struct wl_shell_surface_listener, popup_done ), sizeof( void (*)(void *,struct wl_shell_surface *) ) );
	swigStructField( "wl_shell_surface_listener-ping", offsetof( struct wl_shell_surface_listener, ping ), sizeof( void (*)(void *,struct wl_shell_surface *,uint32_t) ) );
	swigStructField( "wl_shell_surface_listener-configure", offsetof( struct wl_shell_surface_listener, configure ), sizeof( void (*)(void *,struct wl_shell_surface *,uint32_t,int32_t,int32_t) ) );
	printf( "drop %zu end-structure\n", sizeof( struct wl_shell_surface_listener ) );

	swigComment("struct wl_surface_listener\n");
	printf( "begin-structure wl_surface_listener\n" );
	swigStructField( "wl_surface_listener-enter", offsetof( struct wl_surface_listener, enter ), sizeof( void (*)(void *,struct wl_surface *,struct wl_output *) ) );
	swigStructField( "wl_surface_listener-preferred_buffer_scale", offsetof( struct wl_surface_listener, preferred_buffer_scale ), sizeof( void (*)(void *,struct wl_surface *,int32_t) ) );
	swigStructField( "wl_surface_listener-leave", offsetof( struct wl_surface_listener, leave ), sizeof( void (*)(void *,struct wl_surface *,struct wl_output *) ) );
	swigStructField( "wl_surface_listener-preferred_buffer_transform", offsetof( struct wl_surface_listener, preferred_buffer_transform ), sizeof( void (*)(void *,struct wl_surface *,uint32_t) ) );
	printf( "drop %zu end-structure\n", sizeof( struct wl_surface_listener ) );

	swigComment("struct wl_seat_listener\n");
	printf( "begin-structure wl_seat_listener\n" );
	swigStructField( "wl_seat_listener-capabilities", offsetof( struct wl_seat_listener, capabilities ), sizeof( void (*)(void *,struct wl_seat *,uint32_t) ) );
	swigStructField( "wl_seat_listener-name", offsetof( struct wl_seat_listener, name ), sizeof( void (*)(void *,struct wl_seat *,char const *) ) );
	printf( "drop %zu end-structure\n", sizeof( struct wl_seat_listener ) );

	swigComment("struct wl_pointer_listener\n");
	printf( "begin-structure wl_pointer_listener\n" );
	swigStructField( "wl_pointer_listener-motion", offsetof( struct wl_pointer_listener, motion ), sizeof( void (*)(void *,struct wl_pointer *,uint32_t,wl_fixed_t,wl_fixed_t) ) );
	swigStructField( "wl_pointer_listener-frame", offsetof( struct wl_pointer_listener, frame ), sizeof( void (*)(void *,struct wl_pointer *) ) );
	swigStructField( "wl_pointer_listener-axis_source", offsetof( struct wl_pointer_listener, axis_source ), sizeof( void (*)(void *,struct wl_pointer *,uint32_t) ) );
	swigStructField( "wl_pointer_listener-axis_value120", offsetof( struct wl_pointer_listener, axis_value120 ), sizeof( void (*)(void *,struct wl_pointer *,uint32_t,int32_t) ) );
	swigStructField( "wl_pointer_listener-button", offsetof( struct wl_pointer_listener, button ), sizeof( void (*)(void *,struct wl_pointer *,uint32_t,uint32_t,uint32_t,uint32_t) ) );
	swigStructField( "wl_pointer_listener-enter", offsetof( struct wl_pointer_listener, enter ), sizeof( void (*)(void *,struct wl_pointer *,uint32_t,struct wl_surface *,wl_fixed_t,wl_fixed_t) ) );
	swigStructField( "wl_pointer_listener-axis", offsetof( struct wl_pointer_listener, axis ), sizeof( void (*)(void *,struct wl_pointer *,uint32_t,uint32_t,wl_fixed_t) ) );
	swigStructField( "wl_pointer_listener-leave", offsetof( struct wl_pointer_listener, leave ), sizeof( void (*)(void *,struct wl_pointer *,uint32_t,struct wl_surface *) ) );
	swigStructField( "wl_pointer_listener-axis_stop", offsetof( struct wl_pointer_listener, axis_stop ), sizeof( void (*)(void *,struct wl_pointer *,uint32_t,uint32_t) ) );
	swigStructField( "wl_pointer_listener-axis_discrete", offsetof( struct wl_pointer_listener, axis_discrete ), sizeof( void (*)(void *,struct wl_pointer *,uint32_t,int32_t) ) );
	swigStructField( "wl_pointer_listener-axis_relative_direction", offsetof( struct wl_pointer_listener, axis_relative_direction ), sizeof( void (*)(void *,struct wl_pointer *,uint32_t,uint32_t) ) );
	printf( "drop %zu end-structure\n", sizeof( struct wl_pointer_listener ) );

	swigComment("struct wl_keyboard_listener\n");
	printf( "begin-structure wl_keyboard_listener\n" );
	swigStructField( "wl_keyboard_listener-modifiers", offsetof( struct wl_keyboard_listener, modifiers ), sizeof( void (*)(void *,struct wl_keyboard *,uint32_t,uint32_t,uint32_t,uint32_t,uint32_t) ) );
	swigStructField( "wl_keyboard_listener-enter", offsetof( struct wl_keyboard_listener, enter ), sizeof( void (*)(void *,struct wl_keyboard *,uint32_t,struct wl_surface *,struct wl_array *) ) );
	swigStructField( "wl_keyboard_listener-key", offsetof( struct wl_keyboard_listener, key ), sizeof( void (*)(void *,struct wl_keyboard *,uint32_t,uint32_t,uint32_t,uint32_t) ) );
	swigStructField( "wl_keyboard_listener-repeat_info", offsetof( struct wl_keyboard_listener, repeat_info ), sizeof( void (*)(void *,struct wl_keyboard *,int32_t,int32_t) ) );
	swigStructField( "wl_keyboard_listener-leave", offsetof( struct wl_keyboard_listener, leave ), sizeof( void (*)(void *,struct wl_keyboard *,uint32_t,struct wl_surface *) ) );
	swigStructField( "wl_keyboard_listener-keymap", offsetof( struct wl_keyboard_listener, keymap ), sizeof( void (*)(void *,struct wl_keyboard *,uint32_t,int32_t,uint32_t) ) );
	printf( "drop %zu end-structure\n", sizeof( struct wl_keyboard_listener ) );

	swigComment("struct wl_touch_listener\n");
	printf( "begin-structure wl_touch_listener\n" );
	swigStructField( "wl_touch_listener-motion", offsetof( struct wl_touch_listener, motion ), sizeof( void (*)(void *,struct wl_touch *,uint32_t,int32_t,wl_fixed_t,wl_fixed_t) ) );
	swigStructField( "wl_touch_listener-frame", offsetof( struct wl_touch_listener, frame ), sizeof( void (*)(void *,struct wl_touch *) ) );
	swigStructField( "wl_touch_listener-orientation", offsetof( struct wl_touch_listener, orientation ), sizeof( void (*)(void *,struct wl_touch *,int32_t,wl_fixed_t) ) );
	swigStructField( "wl_touch_listener-cancel", offsetof( struct wl_touch_listener, cancel ), sizeof( void (*)(void *,struct wl_touch *) ) );
	swigStructField( "wl_touch_listener-down", offsetof( struct wl_touch_listener, down ), sizeof( void (*)(void *,struct wl_touch *,uint32_t,uint32_t,struct wl_surface *,int32_t,wl_fixed_t,wl_fixed_t) ) );
	swigStructField( "wl_touch_listener-shape", offsetof( struct wl_touch_listener, shape ), sizeof( void (*)(void *,struct wl_touch *,int32_t,wl_fixed_t,wl_fixed_t) ) );
	swigStructField( "wl_touch_listener-up", offsetof( struct wl_touch_listener, up ), sizeof( void (*)(void *,struct wl_touch *,uint32_t,uint32_t,int32_t) ) );
	printf( "drop %zu end-structure\n", sizeof( struct wl_touch_listener ) );

	swigComment("struct wl_output_listener\n");
	printf( "begin-structure wl_output_listener\n" );
	swigStructField( "wl_output_listener-name", offsetof( struct wl_output_listener, name ), sizeof( void (*)(void *,struct wl_output *,char const *) ) );
	swigStructField( "wl_output_listener-done", offsetof( struct wl_output_listener, done ), sizeof( void (*)(void *,struct wl_output *) ) );
	swigStructField( "wl_output_listener-description", offsetof( struct wl_output_listener, description ), sizeof( void (*)(void *,struct wl_output *,char const *) ) );
	swigStructField( "wl_output_listener-geometry", offsetof( struct wl_output_listener, geometry ), sizeof( void (*)(void *,struct wl_output *,int32_t,int32_t,int32_t,int32_t,int32_t,char const *,char const *,int32_t) ) );
	swigStructField( "wl_output_listener-scale", offsetof( struct wl_output_listener, scale ), sizeof( void (*)(void *,struct wl_output *,int32_t) ) );
	swigStructField( "wl_output_listener-mode", offsetof( struct wl_output_listener, mode ), sizeof( void (*)(void *,struct wl_output *,uint32_t,int32_t,int32_t,int32_t) ) );
	printf( "drop %zu end-structure\n", sizeof( struct wl_output_listener ) );

	swigComment("struct wl_cursor_image\n");
	printf( "begin-structure wl_cursor_image\n" );
	swigStructField( "wl_cursor_image-hotspot_x", offsetof( struct wl_cursor_image, hotspot_x ), sizeof( uint32_t ) );
	swigStructField( "wl_cursor_image-hotspot_y", offsetof( struct wl_cursor_image, hotspot_y ), sizeof( uint32_t ) );
	swigStructField( "wl_cursor_image-delay", offsetof( struct wl_cursor_image, delay ), sizeof( uint32_t ) );
	swigStructField( "wl_cursor_image-height", offsetof( struct wl_cursor_image, height ), sizeof( uint32_t ) );
	swigStructField( "wl_cursor_image-width", offsetof( struct wl_cursor_image, width ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct wl_cursor_image ) );

	swigComment("struct wl_cursor\n");
	printf( "begin-structure wl_cursor\n" );
	swigStructField( "wl_cursor-image_count", offsetof( struct wl_cursor, image_count ), sizeof( unsigned int ) );
	swigStructField( "wl_cursor-name", offsetof( struct wl_cursor, name ), sizeof( char * ) );
	swigStructField( "wl_cursor-images", offsetof( struct wl_cursor, images ), sizeof( struct wl_cursor_image ** ) );
	printf( "drop %zu end-structure\n", sizeof( struct wl_cursor ) );

	swigComment("struct wl_message\n");
	printf( "begin-structure wl_message\n" );
	swigStructField( "wl_message-signature", offsetof( struct wl_message, signature ), sizeof( char const * ) );
	swigStructField( "wl_message-name", offsetof( struct wl_message, name ), sizeof( char const * ) );
	swigStructField( "wl_message-types", offsetof( struct wl_message, types ), sizeof( struct wl_interface const ** ) );
	printf( "drop %zu end-structure\n", sizeof( struct wl_message ) );

	swigComment("struct wl_interface\n");
	printf( "begin-structure wl_interface\n" );
	swigStructField( "wl_interface-name", offsetof( struct wl_interface, name ), sizeof( char const * ) );
	swigStructField( "wl_interface-method_count", offsetof( struct wl_interface, method_count ), sizeof( int ) );
	swigStructField( "wl_interface-event_count", offsetof( struct wl_interface, event_count ), sizeof( int ) );
	swigStructField( "wl_interface-version", offsetof( struct wl_interface, version ), sizeof( int ) );
	swigStructField( "wl_interface-events", offsetof( struct wl_interface, events ), sizeof( struct wl_message const * ) );
	swigStructField( "wl_interface-methods", offsetof( struct wl_interface, methods ), sizeof( struct wl_message const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct wl_interface ) );

	swigComment("struct wl_list\n");
	printf( "begin-structure wl_list\n" );
	swigStructField( "wl_list-prev", offsetof( struct wl_list, prev ), sizeof( struct wl_list * ) );
	swigStructField( "wl_list-next", offsetof( struct wl_list, next ), sizeof( struct wl_list * ) );
	printf( "drop %zu end-structure\n", sizeof( struct wl_list ) );

	swigComment("struct wl_array\n");
	printf( "begin-structure wl_array\n" );
	swigStructField( "wl_array-data", offsetof( struct wl_array, data ), sizeof( void * ) );
	swigStructField( "wl_array-alloc", offsetof( struct wl_array, alloc ), sizeof( size_t ) );
	swigStructField( "wl_array-size", offsetof( struct wl_array, size ), sizeof( size_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct wl_array ) );

	swigComment("union wl_argument\n");
	printf( "begin-structure wl_argument\n" );
	swigStructField( "wl_argument-i", offsetof( union wl_argument, i ), sizeof( int32_t ) );
	swigStructField( "wl_argument-s", offsetof( union wl_argument, s ), sizeof( char const * ) );
	swigStructField( "wl_argument-f", offsetof( union wl_argument, f ), sizeof( wl_fixed_t ) );
	swigStructField( "wl_argument-u", offsetof( union wl_argument, u ), sizeof( uint32_t ) );
	swigStructField( "wl_argument-n", offsetof( union wl_argument, n ), sizeof( uint32_t ) );
	swigStructField( "wl_argument-o", offsetof( union wl_argument, o ), sizeof( struct wl_object * ) );
	swigStructField( "wl_argument-a", offsetof( union wl_argument, a ), sizeof( struct wl_array * ) );
	swigStructField( "wl_argument-h", offsetof( union wl_argument, h ), sizeof( int32_t ) );
	printf( "drop %zu end-structure\n", sizeof( union wl_argument ) );

	swigComment("struct zwp_text_input_v3_listener\n");
	printf( "begin-structure zwp_text_input_v3_listener\n" );
	swigStructField( "zwp_text_input_v3_listener-delete_surrounding_text", offsetof( struct zwp_text_input_v3_listener, delete_surrounding_text ), sizeof( void (*)(void *,struct zwp_text_input_v3 *,uint32_t,uint32_t) ) );
	swigStructField( "zwp_text_input_v3_listener-done", offsetof( struct zwp_text_input_v3_listener, done ), sizeof( void (*)(void *,struct zwp_text_input_v3 *,uint32_t) ) );
	swigStructField( "zwp_text_input_v3_listener-enter", offsetof( struct zwp_text_input_v3_listener, enter ), sizeof( void (*)(void *,struct zwp_text_input_v3 *,struct wl_surface *) ) );
	swigStructField( "zwp_text_input_v3_listener-preedit_string", offsetof( struct zwp_text_input_v3_listener, preedit_string ), sizeof( void (*)(void *,struct zwp_text_input_v3 *,char const *,int32_t,int32_t) ) );
	swigStructField( "zwp_text_input_v3_listener-commit_string", offsetof( struct zwp_text_input_v3_listener, commit_string ), sizeof( void (*)(void *,struct zwp_text_input_v3 *,char const *) ) );
	swigStructField( "zwp_text_input_v3_listener-leave", offsetof( struct zwp_text_input_v3_listener, leave ), sizeof( void (*)(void *,struct zwp_text_input_v3 *,struct wl_surface *) ) );
	printf( "drop %zu end-structure\n", sizeof( struct zwp_text_input_v3_listener ) );

	swigComment("struct xdg_wm_base_listener\n");
	printf( "begin-structure xdg_wm_base_listener\n" );
	swigStructField( "xdg_wm_base_listener-ping", offsetof( struct xdg_wm_base_listener, ping ), sizeof( void (*)(void *,struct xdg_wm_base *,uint32_t) ) );
	printf( "drop %zu end-structure\n", sizeof( struct xdg_wm_base_listener ) );

	swigComment("struct xdg_surface_listener\n");
	printf( "begin-structure xdg_surface_listener\n" );
	swigStructField( "xdg_surface_listener-configure", offsetof( struct xdg_surface_listener, configure ), sizeof( void (*)(void *,struct xdg_surface *,uint32_t) ) );
	printf( "drop %zu end-structure\n", sizeof( struct xdg_surface_listener ) );

	swigComment("struct xdg_toplevel_listener\n");
	printf( "begin-structure xdg_toplevel_listener\n" );
	swigStructField( "xdg_toplevel_listener-wm_capabilities", offsetof( struct xdg_toplevel_listener, wm_capabilities ), sizeof( void (*)(void *,struct xdg_toplevel *,struct wl_array *) ) );
	swigStructField( "xdg_toplevel_listener-configure", offsetof( struct xdg_toplevel_listener, configure ), sizeof( void (*)(void *,struct xdg_toplevel *,int32_t,int32_t,struct wl_array *) ) );
	swigStructField( "xdg_toplevel_listener-configure_bounds", offsetof( struct xdg_toplevel_listener, configure_bounds ), sizeof( void (*)(void *,struct xdg_toplevel *,int32_t,int32_t) ) );
	swigStructField( "xdg_toplevel_listener-close", offsetof( struct xdg_toplevel_listener, close ), sizeof( void (*)(void *,struct xdg_toplevel *) ) );
	printf( "drop %zu end-structure\n", sizeof( struct xdg_toplevel_listener ) );

	swigComment("struct xdg_popup_listener\n");
	printf( "begin-structure xdg_popup_listener\n" );
	swigStructField( "xdg_popup_listener-repositioned", offsetof( struct xdg_popup_listener, repositioned ), sizeof( void (*)(void *,struct xdg_popup *,uint32_t) ) );
	swigStructField( "xdg_popup_listener-popup_done", offsetof( struct xdg_popup_listener, popup_done ), sizeof( void (*)(void *,struct xdg_popup *) ) );
	swigStructField( "xdg_popup_listener-configure", offsetof( struct xdg_popup_listener, configure ), sizeof( void (*)(void *,struct xdg_popup *,int32_t,int32_t,int32_t,int32_t) ) );
	printf( "drop %zu end-structure\n", sizeof( struct xdg_popup_listener ) );

	swigComment("struct zxdg_toplevel_decoration_v1_listener\n");
	printf( "begin-structure zxdg_toplevel_decoration_v1_listener\n" );
	swigStructField( "zxdg_toplevel_decoration_v1_listener-configure", offsetof( struct zxdg_toplevel_decoration_v1_listener, configure ), sizeof( void (*)(void *,struct zxdg_toplevel_decoration_v1 *,uint32_t) ) );
	printf( "drop %zu end-structure\n", sizeof( struct zxdg_toplevel_decoration_v1_listener ) );

	swigComment("struct zwp_primary_selection_device_v1_listener\n");
	printf( "begin-structure zwp_primary_selection_device_v1_listener\n" );
	swigStructField( "zwp_primary_selection_device_v1_listener-data_offer", offsetof( struct zwp_primary_selection_device_v1_listener, data_offer ), sizeof( void (*)(void *,struct zwp_primary_selection_device_v1 *,struct zwp_primary_selection_offer_v1 *) ) );
	swigStructField( "zwp_primary_selection_device_v1_listener-selection", offsetof( struct zwp_primary_selection_device_v1_listener, selection ), sizeof( void (*)(void *,struct zwp_primary_selection_device_v1 *,struct zwp_primary_selection_offer_v1 *) ) );
	printf( "drop %zu end-structure\n", sizeof( struct zwp_primary_selection_device_v1_listener ) );

	swigComment("struct zwp_primary_selection_offer_v1_listener\n");
	printf( "begin-structure zwp_primary_selection_offer_v1_listener\n" );
	swigStructField( "zwp_primary_selection_offer_v1_listener-offer", offsetof( struct zwp_primary_selection_offer_v1_listener, offer ), sizeof( void (*)(void *,struct zwp_primary_selection_offer_v1 *,char const *) ) );
	printf( "drop %zu end-structure\n", sizeof( struct zwp_primary_selection_offer_v1_listener ) );

	swigComment("struct zwp_primary_selection_source_v1_listener\n");
	printf( "begin-structure zwp_primary_selection_source_v1_listener\n" );
	swigStructField( "zwp_primary_selection_source_v1_listener-cancelled", offsetof( struct zwp_primary_selection_source_v1_listener, cancelled ), sizeof( void (*)(void *,struct zwp_primary_selection_source_v1 *) ) );
	swigStructField( "zwp_primary_selection_source_v1_listener-send", offsetof( struct zwp_primary_selection_source_v1_listener, send ), sizeof( void (*)(void *,struct zwp_primary_selection_source_v1 *,char const *,int32_t) ) );
	printf( "drop %zu end-structure\n", sizeof( struct zwp_primary_selection_source_v1_listener ) );

	swigComment("struct zwp_tablet_seat_v2_listener\n");
	printf( "begin-structure zwp_tablet_seat_v2_listener\n" );
	swigStructField( "zwp_tablet_seat_v2_listener-tablet_added", offsetof( struct zwp_tablet_seat_v2_listener, tablet_added ), sizeof( void (*)(void *,struct zwp_tablet_seat_v2 *,struct zwp_tablet_v2 *) ) );
	swigStructField( "zwp_tablet_seat_v2_listener-tool_added", offsetof( struct zwp_tablet_seat_v2_listener, tool_added ), sizeof( void (*)(void *,struct zwp_tablet_seat_v2 *,struct zwp_tablet_tool_v2 *) ) );
	swigStructField( "zwp_tablet_seat_v2_listener-pad_added", offsetof( struct zwp_tablet_seat_v2_listener, pad_added ), sizeof( void (*)(void *,struct zwp_tablet_seat_v2 *,struct zwp_tablet_pad_v2 *) ) );
	printf( "drop %zu end-structure\n", sizeof( struct zwp_tablet_seat_v2_listener ) );

	swigComment("struct zwp_tablet_tool_v2_listener\n");
	printf( "begin-structure zwp_tablet_tool_v2_listener\n" );
	swigStructField( "zwp_tablet_tool_v2_listener-done", offsetof( struct zwp_tablet_tool_v2_listener, done ), sizeof( void (*)(void *,struct zwp_tablet_tool_v2 *) ) );
	swigStructField( "zwp_tablet_tool_v2_listener-rotation", offsetof( struct zwp_tablet_tool_v2_listener, rotation ), sizeof( void (*)(void *,struct zwp_tablet_tool_v2 *,wl_fixed_t) ) );
	swigStructField( "zwp_tablet_tool_v2_listener-tilt", offsetof( struct zwp_tablet_tool_v2_listener, tilt ), sizeof( void (*)(void *,struct zwp_tablet_tool_v2 *,wl_fixed_t,wl_fixed_t) ) );
	swigStructField( "zwp_tablet_tool_v2_listener-button", offsetof( struct zwp_tablet_tool_v2_listener, button ), sizeof( void (*)(void *,struct zwp_tablet_tool_v2 *,uint32_t,uint32_t,uint32_t) ) );
	swigStructField( "zwp_tablet_tool_v2_listener-hardware_serial", offsetof( struct zwp_tablet_tool_v2_listener, hardware_serial ), sizeof( void (*)(void *,struct zwp_tablet_tool_v2 *,uint32_t,uint32_t) ) );
	swigStructField( "zwp_tablet_tool_v2_listener-motion", offsetof( struct zwp_tablet_tool_v2_listener, motion ), sizeof( void (*)(void *,struct zwp_tablet_tool_v2 *,wl_fixed_t,wl_fixed_t) ) );
	swigStructField( "zwp_tablet_tool_v2_listener-wheel", offsetof( struct zwp_tablet_tool_v2_listener, wheel ), sizeof( void (*)(void *,struct zwp_tablet_tool_v2 *,wl_fixed_t,int32_t) ) );
	swigStructField( "zwp_tablet_tool_v2_listener-frame", offsetof( struct zwp_tablet_tool_v2_listener, frame ), sizeof( void (*)(void *,struct zwp_tablet_tool_v2 *,uint32_t) ) );
	swigStructField( "zwp_tablet_tool_v2_listener-capability", offsetof( struct zwp_tablet_tool_v2_listener, capability ), sizeof( void (*)(void *,struct zwp_tablet_tool_v2 *,uint32_t) ) );
	swigStructField( "zwp_tablet_tool_v2_listener-removed", offsetof( struct zwp_tablet_tool_v2_listener, removed ), sizeof( void (*)(void *,struct zwp_tablet_tool_v2 *) ) );
	swigStructField( "zwp_tablet_tool_v2_listener-pressure", offsetof( struct zwp_tablet_tool_v2_listener, pressure ), sizeof( void (*)(void *,struct zwp_tablet_tool_v2 *,uint32_t) ) );
	swigStructField( "zwp_tablet_tool_v2_listener-down", offsetof( struct zwp_tablet_tool_v2_listener, down ), sizeof( void (*)(void *,struct zwp_tablet_tool_v2 *,uint32_t) ) );
	swigStructField( "zwp_tablet_tool_v2_listener-slider", offsetof( struct zwp_tablet_tool_v2_listener, slider ), sizeof( void (*)(void *,struct zwp_tablet_tool_v2 *,int32_t) ) );
	swigStructField( "zwp_tablet_tool_v2_listener-type", offsetof( struct zwp_tablet_tool_v2_listener, type ), sizeof( void (*)(void *,struct zwp_tablet_tool_v2 *,uint32_t) ) );
	swigStructField( "zwp_tablet_tool_v2_listener-hardware_id_wacom", offsetof( struct zwp_tablet_tool_v2_listener, hardware_id_wacom ), sizeof( void (*)(void *,struct zwp_tablet_tool_v2 *,uint32_t,uint32_t) ) );
	swigStructField( "zwp_tablet_tool_v2_listener-proximity_out", offsetof( struct zwp_tablet_tool_v2_listener, proximity_out ), sizeof( void (*)(void *,struct zwp_tablet_tool_v2 *) ) );
	swigStructField( "zwp_tablet_tool_v2_listener-proximity_in", offsetof( struct zwp_tablet_tool_v2_listener, proximity_in ), sizeof( void (*)(void *,struct zwp_tablet_tool_v2 *,uint32_t,struct zwp_tablet_v2 *,struct wl_surface *) ) );
	swigStructField( "zwp_tablet_tool_v2_listener-up", offsetof( struct zwp_tablet_tool_v2_listener, up ), sizeof( void (*)(void *,struct zwp_tablet_tool_v2 *) ) );
	swigStructField( "zwp_tablet_tool_v2_listener-distance", offsetof( struct zwp_tablet_tool_v2_listener, distance ), sizeof( void (*)(void *,struct zwp_tablet_tool_v2 *,uint32_t) ) );
	printf( "drop %zu end-structure\n", sizeof( struct zwp_tablet_tool_v2_listener ) );

	swigComment("struct zwp_tablet_v2_listener\n");
	printf( "begin-structure zwp_tablet_v2_listener\n" );
	swigStructField( "zwp_tablet_v2_listener-name", offsetof( struct zwp_tablet_v2_listener, name ), sizeof( void (*)(void *,struct zwp_tablet_v2 *,char const *) ) );
	swigStructField( "zwp_tablet_v2_listener-id", offsetof( struct zwp_tablet_v2_listener, id ), sizeof( void (*)(void *,struct zwp_tablet_v2 *,uint32_t,uint32_t) ) );
	swigStructField( "zwp_tablet_v2_listener-done", offsetof( struct zwp_tablet_v2_listener, done ), sizeof( void (*)(void *,struct zwp_tablet_v2 *) ) );
	swigStructField( "zwp_tablet_v2_listener-removed", offsetof( struct zwp_tablet_v2_listener, removed ), sizeof( void (*)(void *,struct zwp_tablet_v2 *) ) );
	swigStructField( "zwp_tablet_v2_listener-path", offsetof( struct zwp_tablet_v2_listener, path ), sizeof( void (*)(void *,struct zwp_tablet_v2 *,char const *) ) );
	printf( "drop %zu end-structure\n", sizeof( struct zwp_tablet_v2_listener ) );

	swigComment("struct zwp_tablet_pad_ring_v2_listener\n");
	printf( "begin-structure zwp_tablet_pad_ring_v2_listener\n" );
	swigStructField( "zwp_tablet_pad_ring_v2_listener-stop", offsetof( struct zwp_tablet_pad_ring_v2_listener, stop ), sizeof( void (*)(void *,struct zwp_tablet_pad_ring_v2 *) ) );
	swigStructField( "zwp_tablet_pad_ring_v2_listener-frame", offsetof( struct zwp_tablet_pad_ring_v2_listener, frame ), sizeof( void (*)(void *,struct zwp_tablet_pad_ring_v2 *,uint32_t) ) );
	swigStructField( "zwp_tablet_pad_ring_v2_listener-source", offsetof( struct zwp_tablet_pad_ring_v2_listener, source ), sizeof( void (*)(void *,struct zwp_tablet_pad_ring_v2 *,uint32_t) ) );
	swigStructField( "zwp_tablet_pad_ring_v2_listener-angle", offsetof( struct zwp_tablet_pad_ring_v2_listener, angle ), sizeof( void (*)(void *,struct zwp_tablet_pad_ring_v2 *,wl_fixed_t) ) );
	printf( "drop %zu end-structure\n", sizeof( struct zwp_tablet_pad_ring_v2_listener ) );

	swigComment("struct zwp_tablet_pad_strip_v2_listener\n");
	printf( "begin-structure zwp_tablet_pad_strip_v2_listener\n" );
	swigStructField( "zwp_tablet_pad_strip_v2_listener-stop", offsetof( struct zwp_tablet_pad_strip_v2_listener, stop ), sizeof( void (*)(void *,struct zwp_tablet_pad_strip_v2 *) ) );
	swigStructField( "zwp_tablet_pad_strip_v2_listener-frame", offsetof( struct zwp_tablet_pad_strip_v2_listener, frame ), sizeof( void (*)(void *,struct zwp_tablet_pad_strip_v2 *,uint32_t) ) );
	swigStructField( "zwp_tablet_pad_strip_v2_listener-position", offsetof( struct zwp_tablet_pad_strip_v2_listener, position ), sizeof( void (*)(void *,struct zwp_tablet_pad_strip_v2 *,uint32_t) ) );
	swigStructField( "zwp_tablet_pad_strip_v2_listener-source", offsetof( struct zwp_tablet_pad_strip_v2_listener, source ), sizeof( void (*)(void *,struct zwp_tablet_pad_strip_v2 *,uint32_t) ) );
	printf( "drop %zu end-structure\n", sizeof( struct zwp_tablet_pad_strip_v2_listener ) );

	swigComment("struct zwp_tablet_pad_group_v2_listener\n");
	printf( "begin-structure zwp_tablet_pad_group_v2_listener\n" );
	swigStructField( "zwp_tablet_pad_group_v2_listener-buttons", offsetof( struct zwp_tablet_pad_group_v2_listener, buttons ), sizeof( void (*)(void *,struct zwp_tablet_pad_group_v2 *,struct wl_array *) ) );
	swigStructField( "zwp_tablet_pad_group_v2_listener-mode_switch", offsetof( struct zwp_tablet_pad_group_v2_listener, mode_switch ), sizeof( void (*)(void *,struct zwp_tablet_pad_group_v2 *,uint32_t,uint32_t,uint32_t) ) );
	swigStructField( "zwp_tablet_pad_group_v2_listener-done", offsetof( struct zwp_tablet_pad_group_v2_listener, done ), sizeof( void (*)(void *,struct zwp_tablet_pad_group_v2 *) ) );
	swigStructField( "zwp_tablet_pad_group_v2_listener-ring", offsetof( struct zwp_tablet_pad_group_v2_listener, ring ), sizeof( void (*)(void *,struct zwp_tablet_pad_group_v2 *,struct zwp_tablet_pad_ring_v2 *) ) );
	swigStructField( "zwp_tablet_pad_group_v2_listener-strip", offsetof( struct zwp_tablet_pad_group_v2_listener, strip ), sizeof( void (*)(void *,struct zwp_tablet_pad_group_v2 *,struct zwp_tablet_pad_strip_v2 *) ) );
	swigStructField( "zwp_tablet_pad_group_v2_listener-modes", offsetof( struct zwp_tablet_pad_group_v2_listener, modes ), sizeof( void (*)(void *,struct zwp_tablet_pad_group_v2 *,uint32_t) ) );
	printf( "drop %zu end-structure\n", sizeof( struct zwp_tablet_pad_group_v2_listener ) );

	swigComment("struct zwp_tablet_pad_v2_listener\n");
	printf( "begin-structure zwp_tablet_pad_v2_listener\n" );
	swigStructField( "zwp_tablet_pad_v2_listener-buttons", offsetof( struct zwp_tablet_pad_v2_listener, buttons ), sizeof( void (*)(void *,struct zwp_tablet_pad_v2 *,uint32_t) ) );
	swigStructField( "zwp_tablet_pad_v2_listener-done", offsetof( struct zwp_tablet_pad_v2_listener, done ), sizeof( void (*)(void *,struct zwp_tablet_pad_v2 *) ) );
	swigStructField( "zwp_tablet_pad_v2_listener-button", offsetof( struct zwp_tablet_pad_v2_listener, button ), sizeof( void (*)(void *,struct zwp_tablet_pad_v2 *,uint32_t,uint32_t,uint32_t) ) );
	swigStructField( "zwp_tablet_pad_v2_listener-removed", offsetof( struct zwp_tablet_pad_v2_listener, removed ), sizeof( void (*)(void *,struct zwp_tablet_pad_v2 *) ) );
	swigStructField( "zwp_tablet_pad_v2_listener-enter", offsetof( struct zwp_tablet_pad_v2_listener, enter ), sizeof( void (*)(void *,struct zwp_tablet_pad_v2 *,uint32_t,struct zwp_tablet_v2 *,struct wl_surface *) ) );
	swigStructField( "zwp_tablet_pad_v2_listener-group", offsetof( struct zwp_tablet_pad_v2_listener, group ), sizeof( void (*)(void *,struct zwp_tablet_pad_v2 *,struct zwp_tablet_pad_group_v2 *) ) );
	swigStructField( "zwp_tablet_pad_v2_listener-leave", offsetof( struct zwp_tablet_pad_v2_listener, leave ), sizeof( void (*)(void *,struct zwp_tablet_pad_v2 *,uint32_t,struct wl_surface *) ) );
	swigStructField( "zwp_tablet_pad_v2_listener-path", offsetof( struct zwp_tablet_pad_v2_listener, path ), sizeof( void (*)(void *,struct zwp_tablet_pad_v2 *,char const *) ) );
	printf( "drop %zu end-structure\n", sizeof( struct zwp_tablet_pad_v2_listener ) );

	swigNewline();

	swigComment("--===< function pointers >===---\n");
	swigFunctionPointer( "c-funptr wl_display_listener-error() {((struct wl_display_listener*)ptr)->error} a a a u s -- void", "", "", "	( data wl_display object_id code message -- )" );
	swigFunctionPointer( "c-funptr wl_display_listener-delete_id() {((struct wl_display_listener*)ptr)->delete_id} a a u -- void", "", "", "	( data wl_display id -- )" );
	swigFunctionPointer( "c-funptr wl_registry_listener-global() {((struct wl_registry_listener*)ptr)->global} a a u s u -- void", "", "", "	( data wl_registry name interface version -- )" );
	swigFunctionPointer( "c-funptr wl_registry_listener-global_remove() {((struct wl_registry_listener*)ptr)->global_remove} a a u -- void", "", "", "	( data wl_registry name -- )" );
	swigFunctionPointer( "c-funptr wl_callback_listener-done() {((struct wl_callback_listener*)ptr)->done} a a u -- void", "", "", "	( data wl_callback callback_data -- )" );
	swigFunctionPointer( "c-funptr wl_shm_listener-format() {((struct wl_shm_listener*)ptr)->format} a a u -- void", "", "", "	( data wl_shm format -- )" );
	swigFunctionPointer( "c-funptr wl_buffer_listener-release() {((struct wl_buffer_listener*)ptr)->release} a a -- void", "", "", "	( data wl_buffer -- )" );
	swigFunctionPointer( "c-funptr wl_data_offer_listener-offer() {((struct wl_data_offer_listener*)ptr)->offer} a a s -- void", "", "", "	( data wl_data_offer mime_type -- )" );
	swigFunctionPointer( "c-funptr wl_data_offer_listener-source_actions() {((struct wl_data_offer_listener*)ptr)->source_actions} a a u -- void", "", "", "	( data wl_data_offer source_actions -- )" );
	swigFunctionPointer( "c-funptr wl_data_offer_listener-action() {((struct wl_data_offer_listener*)ptr)->action} a a u -- void", "", "", "	( data wl_data_offer dnd_action -- )" );
	swigFunctionPointer( "c-funptr wl_data_source_listener-target() {((struct wl_data_source_listener*)ptr)->target} a a s -- void", "", "", "	( data wl_data_source mime_type -- )" );
	swigFunctionPointer( "c-funptr wl_data_source_listener-send() {((struct wl_data_source_listener*)ptr)->send} a a s n -- void", "", "", "	( data wl_data_source mime_type fd -- )" );
	swigFunctionPointer( "c-funptr wl_data_source_listener-cancelled() {((struct wl_data_source_listener*)ptr)->cancelled} a a -- void", "", "", "	( data wl_data_source -- )" );
	swigFunctionPointer( "c-funptr wl_data_source_listener-dnd_drop_performed() {((struct wl_data_source_listener*)ptr)->dnd_drop_performed} a a -- void", "", "", "	( data wl_data_source -- )" );
	swigFunctionPointer( "c-funptr wl_data_source_listener-dnd_finished() {((struct wl_data_source_listener*)ptr)->dnd_finished} a a -- void", "", "", "	( data wl_data_source -- )" );
	swigFunctionPointer( "c-funptr wl_data_source_listener-action() {((struct wl_data_source_listener*)ptr)->action} a a u -- void", "", "", "	( data wl_data_source dnd_action -- )" );
	swigFunctionPointer( "c-funptr wl_data_device_listener-data_offer() {((struct wl_data_device_listener*)ptr)->data_offer} a a a -- void", "", "", "	( data wl_data_device id -- )" );
	swigFunctionPointer( "c-funptr wl_data_device_listener-enter() {((struct wl_data_device_listener*)ptr)->enter} a a u a n n a -- void", "", "", "	( data wl_data_device serial surface x y id -- )" );
	swigFunctionPointer( "c-funptr wl_data_device_listener-leave() {((struct wl_data_device_listener*)ptr)->leave} a a -- void", "", "", "	( data wl_data_device -- )" );
	swigFunctionPointer( "c-funptr wl_data_device_listener-motion() {((struct wl_data_device_listener*)ptr)->motion} a a u n n -- void", "", "", "	( data wl_data_device time x y -- )" );
	swigFunctionPointer( "c-funptr wl_data_device_listener-drop() {((struct wl_data_device_listener*)ptr)->drop} a a -- void", "", "", "	( data wl_data_device -- )" );
	swigFunctionPointer( "c-funptr wl_data_device_listener-selection() {((struct wl_data_device_listener*)ptr)->selection} a a a -- void", "", "", "	( data wl_data_device id -- )" );
	swigFunctionPointer( "c-funptr wl_shell_surface_listener-ping() {((struct wl_shell_surface_listener*)ptr)->ping} a a u -- void", "", "", "	( data wl_shell_surface serial -- )" );
	swigFunctionPointer( "c-funptr wl_shell_surface_listener-configure() {((struct wl_shell_surface_listener*)ptr)->configure} a a u n n -- void", "", "", "	( data wl_shell_surface edges width height -- )" );
	swigFunctionPointer( "c-funptr wl_shell_surface_listener-popup_done() {((struct wl_shell_surface_listener*)ptr)->popup_done} a a -- void", "", "", "	( data wl_shell_surface -- )" );
	swigFunctionPointer( "c-funptr wl_surface_listener-enter() {((struct wl_surface_listener*)ptr)->enter} a a a -- void", "", "", "	( data wl_surface output -- )" );
	swigFunctionPointer( "c-funptr wl_surface_listener-leave() {((struct wl_surface_listener*)ptr)->leave} a a a -- void", "", "", "	( data wl_surface output -- )" );
	swigFunctionPointer( "c-funptr wl_surface_listener-preferred_buffer_scale() {((struct wl_surface_listener*)ptr)->preferred_buffer_scale} a a n -- void", "", "", "	( data wl_surface factor -- )" );
	swigFunctionPointer( "c-funptr wl_surface_listener-preferred_buffer_transform() {((struct wl_surface_listener*)ptr)->preferred_buffer_transform} a a u -- void", "", "", "	( data wl_surface transform -- )" );
	swigFunctionPointer( "c-funptr wl_seat_listener-capabilities() {((struct wl_seat_listener*)ptr)->capabilities} a a u -- void", "", "", "	( data wl_seat capabilities -- )" );
	swigFunctionPointer( "c-funptr wl_seat_listener-name() {((struct wl_seat_listener*)ptr)->name} a a s -- void", "", "", "	( data wl_seat name -- )" );
	swigFunctionPointer( "c-funptr wl_pointer_listener-enter() {((struct wl_pointer_listener*)ptr)->enter} a a u a n n -- void", "", "", "	( data wl_pointer serial surface surface_x surface_y -- )" );
	swigFunctionPointer( "c-funptr wl_pointer_listener-leave() {((struct wl_pointer_listener*)ptr)->leave} a a u a -- void", "", "", "	( data wl_pointer serial surface -- )" );
	swigFunctionPointer( "c-funptr wl_pointer_listener-motion() {((struct wl_pointer_listener*)ptr)->motion} a a u n n -- void", "", "", "	( data wl_pointer time surface_x surface_y -- )" );
	swigFunctionPointer( "c-funptr wl_pointer_listener-button() {((struct wl_pointer_listener*)ptr)->button} a a u u u u -- void", "", "", "	( data wl_pointer serial time button state -- )" );
	swigFunctionPointer( "c-funptr wl_pointer_listener-axis() {((struct wl_pointer_listener*)ptr)->axis} a a u u n -- void", "", "", "	( data wl_pointer time axis value -- )" );
	swigFunctionPointer( "c-funptr wl_pointer_listener-frame() {((struct wl_pointer_listener*)ptr)->frame} a a -- void", "", "", "	( data wl_pointer -- )" );
	swigFunctionPointer( "c-funptr wl_pointer_listener-axis_source() {((struct wl_pointer_listener*)ptr)->axis_source} a a u -- void", "", "", "	( data wl_pointer axis_source -- )" );
	swigFunctionPointer( "c-funptr wl_pointer_listener-axis_stop() {((struct wl_pointer_listener*)ptr)->axis_stop} a a u u -- void", "", "", "	( data wl_pointer time axis -- )" );
	swigFunctionPointer( "c-funptr wl_pointer_listener-axis_discrete() {((struct wl_pointer_listener*)ptr)->axis_discrete} a a u n -- void", "", "", "	( data wl_pointer axis discrete -- )" );
	swigFunctionPointer( "c-funptr wl_pointer_listener-axis_value120() {((struct wl_pointer_listener*)ptr)->axis_value120} a a u n -- void", "", "", "	( data wl_pointer axis value120 -- )" );
	swigFunctionPointer( "c-funptr wl_pointer_listener-axis_relative_direction() {((struct wl_pointer_listener*)ptr)->axis_relative_direction} a a u u -- void", "", "", "	( data wl_pointer axis direction -- )" );
	swigFunctionPointer( "c-funptr wl_keyboard_listener-keymap() {((struct wl_keyboard_listener*)ptr)->keymap} a a u n u -- void", "", "", "	( data wl_keyboard format fd size -- )" );
	swigFunctionPointer( "c-funptr wl_keyboard_listener-enter() {((struct wl_keyboard_listener*)ptr)->enter} a a u a a -- void", "", "", "	( data wl_keyboard serial surface keys -- )" );
	swigFunctionPointer( "c-funptr wl_keyboard_listener-leave() {((struct wl_keyboard_listener*)ptr)->leave} a a u a -- void", "", "", "	( data wl_keyboard serial surface -- )" );
	swigFunctionPointer( "c-funptr wl_keyboard_listener-key() {((struct wl_keyboard_listener*)ptr)->key} a a u u u u -- void", "", "", "	( data wl_keyboard serial time key state -- )" );
	swigFunctionPointer( "c-funptr wl_keyboard_listener-modifiers() {((struct wl_keyboard_listener*)ptr)->modifiers} a a u u u u u -- void", "", "", "	( data wl_keyboard serial mods_depressed mods_latched mods_locked group -- )" );
	swigFunctionPointer( "c-funptr wl_keyboard_listener-repeat_info() {((struct wl_keyboard_listener*)ptr)->repeat_info} a a n n -- void", "", "", "	( data wl_keyboard rate delay -- )" );
	swigFunctionPointer( "c-funptr wl_touch_listener-down() {((struct wl_touch_listener*)ptr)->down} a a u u a n n n -- void", "", "", "	( data wl_touch serial time surface id x y -- )" );
	swigFunctionPointer( "c-funptr wl_touch_listener-up() {((struct wl_touch_listener*)ptr)->up} a a u u n -- void", "", "", "	( data wl_touch serial time id -- )" );
	swigFunctionPointer( "c-funptr wl_touch_listener-motion() {((struct wl_touch_listener*)ptr)->motion} a a u n n n -- void", "", "", "	( data wl_touch time id x y -- )" );
	swigFunctionPointer( "c-funptr wl_touch_listener-frame() {((struct wl_touch_listener*)ptr)->frame} a a -- void", "", "", "	( data wl_touch -- )" );
	swigFunctionPointer( "c-funptr wl_touch_listener-cancel() {((struct wl_touch_listener*)ptr)->cancel} a a -- void", "", "", "	( data wl_touch -- )" );
	swigFunctionPointer( "c-funptr wl_touch_listener-shape() {((struct wl_touch_listener*)ptr)->shape} a a n n n -- void", "", "", "	( data wl_touch id major minor -- )" );
	swigFunctionPointer( "c-funptr wl_touch_listener-orientation() {((struct wl_touch_listener*)ptr)->orientation} a a n n -- void", "", "", "	( data wl_touch id orientation -- )" );
	swigFunctionPointer( "c-funptr wl_output_listener-geometry() {((struct wl_output_listener*)ptr)->geometry} a a n n n n n s s n -- void", "", "", "	( data wl_output x y physical_width physical_height subpixel make model transform -- )" );
	swigFunctionPointer( "c-funptr wl_output_listener-mode() {((struct wl_output_listener*)ptr)->mode} a a u n n n -- void", "", "", "	( data wl_output flags width height refresh -- )" );
	swigFunctionPointer( "c-funptr wl_output_listener-done() {((struct wl_output_listener*)ptr)->done} a a -- void", "", "", "	( data wl_output -- )" );
	swigFunctionPointer( "c-funptr wl_output_listener-scale() {((struct wl_output_listener*)ptr)->scale} a a n -- void", "", "", "	( data wl_output factor -- )" );
	swigFunctionPointer( "c-funptr wl_output_listener-name() {((struct wl_output_listener*)ptr)->name} a a s -- void", "", "", "	( data wl_output name -- )" );
	swigFunctionPointer( "c-funptr wl_output_listener-description() {((struct wl_output_listener*)ptr)->description} a a s -- void", "", "", "	( data wl_output description -- )" );
	swigFunctionPointer( "c-funptr zwp_text_input_v3_listener-enter() {((struct zwp_text_input_v3_listener*)ptr)->enter} a a a -- void", "", "", "	( data zwp_text_input_v3 surface -- )" );
	swigFunctionPointer( "c-funptr zwp_text_input_v3_listener-leave() {((struct zwp_text_input_v3_listener*)ptr)->leave} a a a -- void", "", "", "	( data zwp_text_input_v3 surface -- )" );
	swigFunctionPointer( "c-funptr zwp_text_input_v3_listener-preedit_string() {((struct zwp_text_input_v3_listener*)ptr)->preedit_string} a a s n n -- void", "", "", "	( data zwp_text_input_v3 text cursor_begin cursor_end -- )" );
	swigFunctionPointer( "c-funptr zwp_text_input_v3_listener-commit_string() {((struct zwp_text_input_v3_listener*)ptr)->commit_string} a a s -- void", "", "", "	( data zwp_text_input_v3 text -- )" );
	swigFunctionPointer( "c-funptr zwp_text_input_v3_listener-delete_surrounding_text() {((struct zwp_text_input_v3_listener*)ptr)->delete_surrounding_text} a a u u -- void", "", "", "	( data zwp_text_input_v3 before_length after_length -- )" );
	swigFunctionPointer( "c-funptr zwp_text_input_v3_listener-done() {((struct zwp_text_input_v3_listener*)ptr)->done} a a u -- void", "", "", "	( data zwp_text_input_v3 serial -- )" );
	swigFunctionPointer( "c-funptr xdg_wm_base_listener-ping() {((struct xdg_wm_base_listener*)ptr)->ping} a a u -- void", "", "", "	( data xdg_wm_base serial -- )" );
	swigFunctionPointer( "c-funptr xdg_surface_listener-configure() {((struct xdg_surface_listener*)ptr)->configure} a a u -- void", "", "", "	( data xdg_surface serial -- )" );
	swigFunctionPointer( "c-funptr xdg_toplevel_listener-configure() {((struct xdg_toplevel_listener*)ptr)->configure} a a n n a -- void", "", "", "	( data xdg_toplevel width height states -- )" );
	swigFunctionPointer( "c-funptr xdg_toplevel_listener-close() {((struct xdg_toplevel_listener*)ptr)->close} a a -- void", "", "", "	( data xdg_toplevel -- )" );
	swigFunctionPointer( "c-funptr xdg_toplevel_listener-configure_bounds() {((struct xdg_toplevel_listener*)ptr)->configure_bounds} a a n n -- void", "", "", "	( data xdg_toplevel width height -- )" );
	swigFunctionPointer( "c-funptr xdg_toplevel_listener-wm_capabilities() {((struct xdg_toplevel_listener*)ptr)->wm_capabilities} a a a -- void", "", "", "	( data xdg_toplevel capabilities -- )" );
	swigFunctionPointer( "c-funptr xdg_popup_listener-configure() {((struct xdg_popup_listener*)ptr)->configure} a a n n n n -- void", "", "", "	( data xdg_popup x y width height -- )" );
	swigFunctionPointer( "c-funptr xdg_popup_listener-popup_done() {((struct xdg_popup_listener*)ptr)->popup_done} a a -- void", "", "", "	( data xdg_popup -- )" );
	swigFunctionPointer( "c-funptr xdg_popup_listener-repositioned() {((struct xdg_popup_listener*)ptr)->repositioned} a a u -- void", "", "", "	( data xdg_popup token -- )" );
	swigFunctionPointer( "c-funptr zxdg_toplevel_decoration_v1_listener-configure() {((struct zxdg_toplevel_decoration_v1_listener*)ptr)->configure} a a u -- void", "", "", "	( data zxdg_toplevel_decoration_v1 mode -- )" );
	swigFunctionPointer( "c-funptr zwp_primary_selection_device_v1_listener-data_offer() {((struct zwp_primary_selection_device_v1_listener*)ptr)->data_offer} a a a -- void", "", "", "	( data zwp_primary_selection_device_v1 offer -- )" );
	swigFunctionPointer( "c-funptr zwp_primary_selection_device_v1_listener-selection() {((struct zwp_primary_selection_device_v1_listener*)ptr)->selection} a a a -- void", "", "", "	( data zwp_primary_selection_device_v1 id -- )" );
	swigFunctionPointer( "c-funptr zwp_primary_selection_offer_v1_listener-offer() {((struct zwp_primary_selection_offer_v1_listener*)ptr)->offer} a a s -- void", "", "", "	( data zwp_primary_selection_offer_v1 mime_type -- )" );
	swigFunctionPointer( "c-funptr zwp_primary_selection_source_v1_listener-send() {((struct zwp_primary_selection_source_v1_listener*)ptr)->send} a a s n -- void", "", "", "	( data zwp_primary_selection_source_v1 mime_type fd -- )" );
	swigFunctionPointer( "c-funptr zwp_primary_selection_source_v1_listener-cancelled() {((struct zwp_primary_selection_source_v1_listener*)ptr)->cancelled} a a -- void", "", "", "	( data zwp_primary_selection_source_v1 -- )" );
	swigFunctionPointer( "c-funptr zwp_tablet_seat_v2_listener-tablet_added() {((struct zwp_tablet_seat_v2_listener*)ptr)->tablet_added} a a a -- void", "", "", "	( data zwp_tablet_seat_v2 id -- )" );
	swigFunctionPointer( "c-funptr zwp_tablet_seat_v2_listener-tool_added() {((struct zwp_tablet_seat_v2_listener*)ptr)->tool_added} a a a -- void", "", "", "	( data zwp_tablet_seat_v2 id -- )" );
	swigFunctionPointer( "c-funptr zwp_tablet_seat_v2_listener-pad_added() {((struct zwp_tablet_seat_v2_listener*)ptr)->pad_added} a a a -- void", "", "", "	( data zwp_tablet_seat_v2 id -- )" );
	swigFunctionPointer( "c-funptr zwp_tablet_tool_v2_listener-type() {((struct zwp_tablet_tool_v2_listener*)ptr)->type} a a u -- void", "", "", "	( data zwp_tablet_tool_v2 tool_type -- )" );
	swigFunctionPointer( "c-funptr zwp_tablet_tool_v2_listener-hardware_serial() {((struct zwp_tablet_tool_v2_listener*)ptr)->hardware_serial} a a u u -- void", "", "", "	( data zwp_tablet_tool_v2 hardware_serial_hi hardware_serial_lo -- )" );
	swigFunctionPointer( "c-funptr zwp_tablet_tool_v2_listener-hardware_id_wacom() {((struct zwp_tablet_tool_v2_listener*)ptr)->hardware_id_wacom} a a u u -- void", "", "", "	( data zwp_tablet_tool_v2 hardware_id_hi hardware_id_lo -- )" );
	swigFunctionPointer( "c-funptr zwp_tablet_tool_v2_listener-capability() {((struct zwp_tablet_tool_v2_listener*)ptr)->capability} a a u -- void", "", "", "	( data zwp_tablet_tool_v2 capability -- )" );
	swigFunctionPointer( "c-funptr zwp_tablet_tool_v2_listener-done() {((struct zwp_tablet_tool_v2_listener*)ptr)->done} a a -- void", "", "", "	( data zwp_tablet_tool_v2 -- )" );
	swigFunctionPointer( "c-funptr zwp_tablet_tool_v2_listener-removed() {((struct zwp_tablet_tool_v2_listener*)ptr)->removed} a a -- void", "", "", "	( data zwp_tablet_tool_v2 -- )" );
	swigFunctionPointer( "c-funptr zwp_tablet_tool_v2_listener-proximity_in() {((struct zwp_tablet_tool_v2_listener*)ptr)->proximity_in} a a u a a -- void", "", "", "	( data zwp_tablet_tool_v2 serial tablet surface -- )" );
	swigFunctionPointer( "c-funptr zwp_tablet_tool_v2_listener-proximity_out() {((struct zwp_tablet_tool_v2_listener*)ptr)->proximity_out} a a -- void", "", "", "	( data zwp_tablet_tool_v2 -- )" );
	swigFunctionPointer( "c-funptr zwp_tablet_tool_v2_listener-down() {((struct zwp_tablet_tool_v2_listener*)ptr)->down} a a u -- void", "", "", "	( data zwp_tablet_tool_v2 serial -- )" );
	swigFunctionPointer( "c-funptr zwp_tablet_tool_v2_listener-up() {((struct zwp_tablet_tool_v2_listener*)ptr)->up} a a -- void", "", "", "	( data zwp_tablet_tool_v2 -- )" );
	swigFunctionPointer( "c-funptr zwp_tablet_tool_v2_listener-motion() {((struct zwp_tablet_tool_v2_listener*)ptr)->motion} a a n n -- void", "", "", "	( data zwp_tablet_tool_v2 x y -- )" );
	swigFunctionPointer( "c-funptr zwp_tablet_tool_v2_listener-pressure() {((struct zwp_tablet_tool_v2_listener*)ptr)->pressure} a a u -- void", "", "", "	( data zwp_tablet_tool_v2 pressure -- )" );
	swigFunctionPointer( "c-funptr zwp_tablet_tool_v2_listener-distance() {((struct zwp_tablet_tool_v2_listener*)ptr)->distance} a a u -- void", "", "", "	( data zwp_tablet_tool_v2 distance -- )" );
	swigFunctionPointer( "c-funptr zwp_tablet_tool_v2_listener-tilt() {((struct zwp_tablet_tool_v2_listener*)ptr)->tilt} a a n n -- void", "", "", "	( data zwp_tablet_tool_v2 tilt_x tilt_y -- )" );
	swigFunctionPointer( "c-funptr zwp_tablet_tool_v2_listener-rotation() {((struct zwp_tablet_tool_v2_listener*)ptr)->rotation} a a n -- void", "", "", "	( data zwp_tablet_tool_v2 degrees -- )" );
	swigFunctionPointer( "c-funptr zwp_tablet_tool_v2_listener-slider() {((struct zwp_tablet_tool_v2_listener*)ptr)->slider} a a n -- void", "", "", "	( data zwp_tablet_tool_v2 position -- )" );
	swigFunctionPointer( "c-funptr zwp_tablet_tool_v2_listener-wheel() {((struct zwp_tablet_tool_v2_listener*)ptr)->wheel} a a n n -- void", "", "", "	( data zwp_tablet_tool_v2 degrees clicks -- )" );
	swigFunctionPointer( "c-funptr zwp_tablet_tool_v2_listener-button() {((struct zwp_tablet_tool_v2_listener*)ptr)->button} a a u u u -- void", "", "", "	( data zwp_tablet_tool_v2 serial button state -- )" );
	swigFunctionPointer( "c-funptr zwp_tablet_tool_v2_listener-frame() {((struct zwp_tablet_tool_v2_listener*)ptr)->frame} a a u -- void", "", "", "	( data zwp_tablet_tool_v2 time -- )" );
	swigFunctionPointer( "c-funptr zwp_tablet_v2_listener-name() {((struct zwp_tablet_v2_listener*)ptr)->name} a a s -- void", "", "", "	( data zwp_tablet_v2 name -- )" );
	swigFunctionPointer( "c-funptr zwp_tablet_v2_listener-id() {((struct zwp_tablet_v2_listener*)ptr)->id} a a u u -- void", "", "", "	( data zwp_tablet_v2 vid pid -- )" );
	swigFunctionPointer( "c-funptr zwp_tablet_v2_listener-path() {((struct zwp_tablet_v2_listener*)ptr)->path} a a s -- void", "", "", "	( data zwp_tablet_v2 path -- )" );
	swigFunctionPointer( "c-funptr zwp_tablet_v2_listener-done() {((struct zwp_tablet_v2_listener*)ptr)->done} a a -- void", "", "", "	( data zwp_tablet_v2 -- )" );
	swigFunctionPointer( "c-funptr zwp_tablet_v2_listener-removed() {((struct zwp_tablet_v2_listener*)ptr)->removed} a a -- void", "", "", "	( data zwp_tablet_v2 -- )" );
	swigFunctionPointer( "c-funptr zwp_tablet_pad_ring_v2_listener-source() {((struct zwp_tablet_pad_ring_v2_listener*)ptr)->source} a a u -- void", "", "", "	( data zwp_tablet_pad_ring_v2 source -- )" );
	swigFunctionPointer( "c-funptr zwp_tablet_pad_ring_v2_listener-angle() {((struct zwp_tablet_pad_ring_v2_listener*)ptr)->angle} a a n -- void", "", "", "	( data zwp_tablet_pad_ring_v2 degrees -- )" );
	swigFunctionPointer( "c-funptr zwp_tablet_pad_ring_v2_listener-stop() {((struct zwp_tablet_pad_ring_v2_listener*)ptr)->stop} a a -- void", "", "", "	( data zwp_tablet_pad_ring_v2 -- )" );
	swigFunctionPointer( "c-funptr zwp_tablet_pad_ring_v2_listener-frame() {((struct zwp_tablet_pad_ring_v2_listener*)ptr)->frame} a a u -- void", "", "", "	( data zwp_tablet_pad_ring_v2 time -- )" );
	swigFunctionPointer( "c-funptr zwp_tablet_pad_strip_v2_listener-source() {((struct zwp_tablet_pad_strip_v2_listener*)ptr)->source} a a u -- void", "", "", "	( data zwp_tablet_pad_strip_v2 source -- )" );
	swigFunctionPointer( "c-funptr zwp_tablet_pad_strip_v2_listener-position() {((struct zwp_tablet_pad_strip_v2_listener*)ptr)->position} a a u -- void", "", "", "	( data zwp_tablet_pad_strip_v2 position -- )" );
	swigFunctionPointer( "c-funptr zwp_tablet_pad_strip_v2_listener-stop() {((struct zwp_tablet_pad_strip_v2_listener*)ptr)->stop} a a -- void", "", "", "	( data zwp_tablet_pad_strip_v2 -- )" );
	swigFunctionPointer( "c-funptr zwp_tablet_pad_strip_v2_listener-frame() {((struct zwp_tablet_pad_strip_v2_listener*)ptr)->frame} a a u -- void", "", "", "	( data zwp_tablet_pad_strip_v2 time -- )" );
	swigFunctionPointer( "c-funptr zwp_tablet_pad_group_v2_listener-buttons() {((struct zwp_tablet_pad_group_v2_listener*)ptr)->buttons} a a a -- void", "", "", "	( data zwp_tablet_pad_group_v2 buttons -- )" );
	swigFunctionPointer( "c-funptr zwp_tablet_pad_group_v2_listener-ring() {((struct zwp_tablet_pad_group_v2_listener*)ptr)->ring} a a a -- void", "", "", "	( data zwp_tablet_pad_group_v2 ring -- )" );
	swigFunctionPointer( "c-funptr zwp_tablet_pad_group_v2_listener-strip() {((struct zwp_tablet_pad_group_v2_listener*)ptr)->strip} a a a -- void", "", "", "	( data zwp_tablet_pad_group_v2 strip -- )" );
	swigFunctionPointer( "c-funptr zwp_tablet_pad_group_v2_listener-modes() {((struct zwp_tablet_pad_group_v2_listener*)ptr)->modes} a a u -- void", "", "", "	( data zwp_tablet_pad_group_v2 modes -- )" );
	swigFunctionPointer( "c-funptr zwp_tablet_pad_group_v2_listener-done() {((struct zwp_tablet_pad_group_v2_listener*)ptr)->done} a a -- void", "", "", "	( data zwp_tablet_pad_group_v2 -- )" );
	swigFunctionPointer( "c-funptr zwp_tablet_pad_group_v2_listener-mode_switch() {((struct zwp_tablet_pad_group_v2_listener*)ptr)->mode_switch} a a u u u -- void", "", "", "	( data zwp_tablet_pad_group_v2 time serial mode -- )" );
	swigFunctionPointer( "c-funptr zwp_tablet_pad_v2_listener-group() {((struct zwp_tablet_pad_v2_listener*)ptr)->group} a a a -- void", "", "", "	( data zwp_tablet_pad_v2 pad_group -- )" );
	swigFunctionPointer( "c-funptr zwp_tablet_pad_v2_listener-path() {((struct zwp_tablet_pad_v2_listener*)ptr)->path} a a s -- void", "", "", "	( data zwp_tablet_pad_v2 path -- )" );
	swigFunctionPointer( "c-funptr zwp_tablet_pad_v2_listener-buttons() {((struct zwp_tablet_pad_v2_listener*)ptr)->buttons} a a u -- void", "", "", "	( data zwp_tablet_pad_v2 buttons -- )" );
	swigFunctionPointer( "c-funptr zwp_tablet_pad_v2_listener-done() {((struct zwp_tablet_pad_v2_listener*)ptr)->done} a a -- void", "", "", "	( data zwp_tablet_pad_v2 -- )" );
	swigFunctionPointer( "c-funptr zwp_tablet_pad_v2_listener-button() {((struct zwp_tablet_pad_v2_listener*)ptr)->button} a a u u u -- void", "", "", "	( data zwp_tablet_pad_v2 time button state -- )" );
	swigFunctionPointer( "c-funptr zwp_tablet_pad_v2_listener-enter() {((struct zwp_tablet_pad_v2_listener*)ptr)->enter} a a u a a -- void", "", "", "	( data zwp_tablet_pad_v2 serial tablet surface -- )" );
	swigFunctionPointer( "c-funptr zwp_tablet_pad_v2_listener-leave() {((struct zwp_tablet_pad_v2_listener*)ptr)->leave} a a u a -- void", "", "", "	( data zwp_tablet_pad_v2 serial surface -- )" );
	swigFunctionPointer( "c-funptr zwp_tablet_pad_v2_listener-removed() {((struct zwp_tablet_pad_v2_listener*)ptr)->removed} a a -- void", "", "", "	( data zwp_tablet_pad_v2 -- )" );

	swigNewline();

	swigComment("------===< callbacks >===-------\n");
	swigCallback( "c-callback wl_dispatcher_func_t: a a u a a -- n", "", "", "	( user_data target opcode msg args -- )" );

	swigNewline();

	swigComment("------===< functions >===-------\n");
	swigFunction( "c-function wl_event_queue_destroy wl_event_queue_destroy a -- void", "FUNCTION: wl_event_queue_destroy ( queue -- void )", "EXTERN: \"C\" void wl_event_queue_destroy( void * queue );", "	( queue -- )" );
	swigFunction( "c-function wl_proxy_marshal_flags wl_proxy_marshal_flags a u a u u ... -- a", "FUNCTION: wl_proxy_marshal_flags ( proxy opcode interface version flags  -- a )", "EXTERN: \"C\" void * wl_proxy_marshal_flags( void * proxy, int opcode, void * interface, int version, int flags, ...  );", "	( proxy opcode interface version flags <noname> -- )" );
	swigFunction( "c-function wl_proxy_marshal_array_flags wl_proxy_marshal_array_flags a u a u u a -- a", "FUNCTION: wl_proxy_marshal_array_flags ( proxy opcode interface version flags args -- a )", "EXTERN: \"C\" void * wl_proxy_marshal_array_flags( void * proxy, int opcode, void * interface, int version, int flags, void * args );", "	( proxy opcode interface version flags args -- )" );
	swigFunction( "c-function wl_proxy_marshal wl_proxy_marshal a u ... -- void", "FUNCTION: wl_proxy_marshal ( p opcode  -- void )", "EXTERN: \"C\" void wl_proxy_marshal( void * p, int opcode, ...  );", "	( p opcode <noname> -- )" );
	swigFunction( "c-function wl_proxy_marshal_array wl_proxy_marshal_array a u a -- void", "FUNCTION: wl_proxy_marshal_array ( p opcode args -- void )", "EXTERN: \"C\" void wl_proxy_marshal_array( void * p, int opcode, void * args );", "	( p opcode args -- )" );
	swigFunction( "c-function wl_proxy_create wl_proxy_create a a -- a", "FUNCTION: wl_proxy_create ( factory interface -- a )", "EXTERN: \"C\" void * wl_proxy_create( void * factory, void * interface );", "	( factory interface -- )" );
	swigFunction( "c-function wl_proxy_create_wrapper wl_proxy_create_wrapper a -- a", "FUNCTION: wl_proxy_create_wrapper ( proxy -- a )", "EXTERN: \"C\" void * wl_proxy_create_wrapper( void * proxy );", "	( proxy -- )" );
	swigFunction( "c-function wl_proxy_wrapper_destroy wl_proxy_wrapper_destroy a -- void", "FUNCTION: wl_proxy_wrapper_destroy ( proxy_wrapper -- void )", "EXTERN: \"C\" void wl_proxy_wrapper_destroy( void * proxy_wrapper );", "	( proxy_wrapper -- )" );
	swigFunction( "c-function wl_proxy_marshal_constructor wl_proxy_marshal_constructor a u a ... -- a", "FUNCTION: wl_proxy_marshal_constructor ( proxy opcode interface  -- a )", "EXTERN: \"C\" void * wl_proxy_marshal_constructor( void * proxy, int opcode, void * interface, ...  );", "	( proxy opcode interface <noname> -- )" );
	swigFunction( "c-function wl_proxy_marshal_constructor_versioned wl_proxy_marshal_constructor_versioned a u a u ... -- a", "FUNCTION: wl_proxy_marshal_constructor_versioned ( proxy opcode interface version  -- a )", "EXTERN: \"C\" void * wl_proxy_marshal_constructor_versioned( void * proxy, int opcode, void * interface, int version, ...  );", "	( proxy opcode interface version <noname> -- )" );
	swigFunction( "c-function wl_proxy_marshal_array_constructor wl_proxy_marshal_array_constructor a u a a -- a", "FUNCTION: wl_proxy_marshal_array_constructor ( proxy opcode args interface -- a )", "EXTERN: \"C\" void * wl_proxy_marshal_array_constructor( void * proxy, int opcode, void * args, void * interface );", "	( proxy opcode args interface -- )" );
	swigFunction( "c-function wl_proxy_marshal_array_constructor_versioned wl_proxy_marshal_array_constructor_versioned a u a a u -- a", "FUNCTION: wl_proxy_marshal_array_constructor_versioned ( proxy opcode args interface version -- a )", "EXTERN: \"C\" void * wl_proxy_marshal_array_constructor_versioned( void * proxy, int opcode, void * args, void * interface, int version );", "	( proxy opcode args interface version -- )" );
	swigFunction( "c-function wl_proxy_destroy wl_proxy_destroy a -- void", "FUNCTION: wl_proxy_destroy ( proxy -- void )", "EXTERN: \"C\" void wl_proxy_destroy( void * proxy );", "	( proxy -- )" );
	swigFunction( "c-function wl_proxy_add_listener wl_proxy_add_listener a a a -- n", "FUNCTION: wl_proxy_add_listener ( proxy implementation data -- n )", "EXTERN: \"C\" int wl_proxy_add_listener( void * proxy, void * implementation, void * data );", "	( proxy implementation data -- )" );
	swigFunction( "c-function wl_proxy_get_listener wl_proxy_get_listener a -- a", "FUNCTION: wl_proxy_get_listener ( proxy -- a )", "EXTERN: \"C\" void * wl_proxy_get_listener( void * proxy );", "	( proxy -- )" );
	swigFunction( "c-function wl_proxy_add_dispatcher wl_proxy_add_dispatcher a a a a -- n", "FUNCTION: wl_proxy_add_dispatcher ( proxy dispatcher_func dispatcher_data data -- n )", "EXTERN: \"C\" int wl_proxy_add_dispatcher( void * proxy, void * dispatcher_func, void * dispatcher_data, void * data );", "	( proxy dispatcher_func dispatcher_data data -- )" );
	swigFunction( "c-function wl_proxy_set_user_data wl_proxy_set_user_data a a -- void", "FUNCTION: wl_proxy_set_user_data ( proxy user_data -- void )", "EXTERN: \"C\" void wl_proxy_set_user_data( void * proxy, void * user_data );", "	( proxy user_data -- )" );
	swigFunction( "c-function wl_proxy_get_user_data wl_proxy_get_user_data a -- a", "FUNCTION: wl_proxy_get_user_data ( proxy -- a )", "EXTERN: \"C\" void * wl_proxy_get_user_data( void * proxy );", "	( proxy -- )" );
	swigFunction( "c-function wl_proxy_get_version wl_proxy_get_version a -- u", "FUNCTION: wl_proxy_get_version ( proxy -- u )", "EXTERN: \"C\" int wl_proxy_get_version( void * proxy );", "	( proxy -- )" );
	swigFunction( "c-function wl_proxy_get_id wl_proxy_get_id a -- u", "FUNCTION: wl_proxy_get_id ( proxy -- u )", "EXTERN: \"C\" int wl_proxy_get_id( void * proxy );", "	( proxy -- )" );
	swigFunction( "c-function wl_proxy_set_tag wl_proxy_set_tag a a -- void", "FUNCTION: wl_proxy_set_tag ( proxy tag -- void )", "EXTERN: \"C\" void wl_proxy_set_tag( void * proxy, void * tag );", "	( proxy tag -- )" );
	swigFunction( "c-function wl_proxy_get_tag wl_proxy_get_tag a -- a", "FUNCTION: wl_proxy_get_tag ( proxy -- a )", "EXTERN: \"C\" void * wl_proxy_get_tag( void * proxy );", "	( proxy -- )" );
	swigFunction( "c-function wl_proxy_get_class wl_proxy_get_class a -- s", "FUNCTION: wl_proxy_get_class ( proxy -- s )", "EXTERN: \"C\" char * wl_proxy_get_class( void * proxy );", "	( proxy -- )" );
	swigFunction( "c-function wl_proxy_set_queue wl_proxy_set_queue a a -- void", "FUNCTION: wl_proxy_set_queue ( proxy queue -- void )", "EXTERN: \"C\" void wl_proxy_set_queue( void * proxy, void * queue );", "	( proxy queue -- )" );
	swigFunction( "c-function wl_display_connect wl_display_connect s -- a", "FUNCTION: wl_display_connect ( name -- a )", "EXTERN: \"C\" void * wl_display_connect( char * name );", "	( name -- )" );
	swigFunction( "c-function wl_display_connect_to_fd wl_display_connect_to_fd n -- a", "FUNCTION: wl_display_connect_to_fd ( fd -- a )", "EXTERN: \"C\" void * wl_display_connect_to_fd( int fd );", "	( fd -- )" );
	swigFunction( "c-function wl_display_disconnect wl_display_disconnect a -- void", "FUNCTION: wl_display_disconnect ( display -- void )", "EXTERN: \"C\" void wl_display_disconnect( void * display );", "	( display -- )" );
	swigFunction( "c-function wl_display_get_fd wl_display_get_fd a -- n", "FUNCTION: wl_display_get_fd ( display -- n )", "EXTERN: \"C\" int wl_display_get_fd( void * display );", "	( display -- )" );
	swigFunction( "c-function wl_display_dispatch wl_display_dispatch a -- n", "FUNCTION: wl_display_dispatch ( display -- n )", "EXTERN: \"C\" int wl_display_dispatch( void * display );", "	( display -- )" );
	swigFunction( "c-function wl_display_dispatch_queue wl_display_dispatch_queue a a -- n", "FUNCTION: wl_display_dispatch_queue ( display queue -- n )", "EXTERN: \"C\" int wl_display_dispatch_queue( void * display, void * queue );", "	( display queue -- )" );
	swigFunction( "c-function wl_display_dispatch_queue_pending wl_display_dispatch_queue_pending a a -- n", "FUNCTION: wl_display_dispatch_queue_pending ( display queue -- n )", "EXTERN: \"C\" int wl_display_dispatch_queue_pending( void * display, void * queue );", "	( display queue -- )" );
	swigFunction( "c-function wl_display_dispatch_pending wl_display_dispatch_pending a -- n", "FUNCTION: wl_display_dispatch_pending ( display -- n )", "EXTERN: \"C\" int wl_display_dispatch_pending( void * display );", "	( display -- )" );
	swigFunction( "c-function wl_display_get_error wl_display_get_error a -- n", "FUNCTION: wl_display_get_error ( display -- n )", "EXTERN: \"C\" int wl_display_get_error( void * display );", "	( display -- )" );
	swigFunction( "c-function wl_display_get_protocol_error wl_display_get_protocol_error a a a -- u", "FUNCTION: wl_display_get_protocol_error ( display interface id -- u )", "EXTERN: \"C\" int wl_display_get_protocol_error( void * display, void * interface, void * id );", "	( display interface id -- )" );
	swigFunction( "c-function wl_display_flush wl_display_flush a -- n", "FUNCTION: wl_display_flush ( display -- n )", "EXTERN: \"C\" int wl_display_flush( void * display );", "	( display -- )" );
	swigFunction( "c-function wl_display_roundtrip_queue wl_display_roundtrip_queue a a -- n", "FUNCTION: wl_display_roundtrip_queue ( display queue -- n )", "EXTERN: \"C\" int wl_display_roundtrip_queue( void * display, void * queue );", "	( display queue -- )" );
	swigFunction( "c-function wl_display_roundtrip wl_display_roundtrip a -- n", "FUNCTION: wl_display_roundtrip ( display -- n )", "EXTERN: \"C\" int wl_display_roundtrip( void * display );", "	( display -- )" );
	swigFunction( "c-function wl_display_create_queue wl_display_create_queue a -- a", "FUNCTION: wl_display_create_queue ( display -- a )", "EXTERN: \"C\" void * wl_display_create_queue( void * display );", "	( display -- )" );
	swigFunction( "c-function wl_display_prepare_read_queue wl_display_prepare_read_queue a a -- n", "FUNCTION: wl_display_prepare_read_queue ( display queue -- n )", "EXTERN: \"C\" int wl_display_prepare_read_queue( void * display, void * queue );", "	( display queue -- )" );
	swigFunction( "c-function wl_display_prepare_read wl_display_prepare_read a -- n", "FUNCTION: wl_display_prepare_read ( display -- n )", "EXTERN: \"C\" int wl_display_prepare_read( void * display );", "	( display -- )" );
	swigFunction( "c-function wl_display_cancel_read wl_display_cancel_read a -- void", "FUNCTION: wl_display_cancel_read ( display -- void )", "EXTERN: \"C\" void wl_display_cancel_read( void * display );", "	( display -- )" );
	swigFunction( "c-function wl_display_read_events wl_display_read_events a -- n", "FUNCTION: wl_display_read_events ( display -- n )", "EXTERN: \"C\" int wl_display_read_events( void * display );", "	( display -- )" );
	swigFunction( "c-function wl_log_set_handler_client wl_log_set_handler_client a -- void", "FUNCTION: wl_log_set_handler_client ( handler -- void )", "EXTERN: \"C\" void wl_log_set_handler_client( void * handler );", "	( handler -- )" );
	swigFunction( "c-function wl_display_add_listener wl_display_add_listener a a a -- n", "FUNCTION: wl_display_add_listener ( wl_display listener data -- n )", "EXTERN: \"C\" int wl_display_add_listener( void * wl_display, void * listener, void * data );", "	( wl_display listener data -- )" );
	swigFunction( "c-function wl_display_set_user_data wl_display_set_user_data a a -- void", "FUNCTION: wl_display_set_user_data ( wl_display user_data -- void )", "EXTERN: \"C\" void wl_display_set_user_data( void * wl_display, void * user_data );", "	( wl_display user_data -- )" );
	swigFunction( "c-function wl_display_get_user_data wl_display_get_user_data a -- a", "FUNCTION: wl_display_get_user_data ( wl_display -- a )", "EXTERN: \"C\" void * wl_display_get_user_data( void * wl_display );", "	( wl_display -- )" );
	swigFunction( "c-function wl_display_get_version wl_display_get_version a -- u", "FUNCTION: wl_display_get_version ( wl_display -- u )", "EXTERN: \"C\" int wl_display_get_version( void * wl_display );", "	( wl_display -- )" );
	swigFunction( "c-function wl_display_sync wl_display_sync a -- a", "FUNCTION: wl_display_sync ( wl_display -- a )", "EXTERN: \"C\" void * wl_display_sync( void * wl_display );", "	( wl_display -- )" );
	swigFunction( "c-function wl_display_get_registry wl_display_get_registry a -- a", "FUNCTION: wl_display_get_registry ( wl_display -- a )", "EXTERN: \"C\" void * wl_display_get_registry( void * wl_display );", "	( wl_display -- )" );
	swigFunction( "c-function wl_registry_add_listener wl_registry_add_listener a a a -- n", "FUNCTION: wl_registry_add_listener ( wl_registry listener data -- n )", "EXTERN: \"C\" int wl_registry_add_listener( void * wl_registry, void * listener, void * data );", "	( wl_registry listener data -- )" );
	swigFunction( "c-function wl_registry_set_user_data wl_registry_set_user_data a a -- void", "FUNCTION: wl_registry_set_user_data ( wl_registry user_data -- void )", "EXTERN: \"C\" void wl_registry_set_user_data( void * wl_registry, void * user_data );", "	( wl_registry user_data -- )" );
	swigFunction( "c-function wl_registry_get_user_data wl_registry_get_user_data a -- a", "FUNCTION: wl_registry_get_user_data ( wl_registry -- a )", "EXTERN: \"C\" void * wl_registry_get_user_data( void * wl_registry );", "	( wl_registry -- )" );
	swigFunction( "c-function wl_registry_get_version wl_registry_get_version a -- u", "FUNCTION: wl_registry_get_version ( wl_registry -- u )", "EXTERN: \"C\" int wl_registry_get_version( void * wl_registry );", "	( wl_registry -- )" );
	swigFunction( "c-function wl_registry_destroy wl_registry_destroy a -- void", "FUNCTION: wl_registry_destroy ( wl_registry -- void )", "EXTERN: \"C\" void wl_registry_destroy( void * wl_registry );", "	( wl_registry -- )" );
	swigFunction( "c-function wl_registry_bind wl_registry_bind a u a u -- a", "FUNCTION: wl_registry_bind ( wl_registry name interface version -- a )", "EXTERN: \"C\" void * wl_registry_bind( void * wl_registry, int name, void * interface, int version );", "	( wl_registry name interface version -- )" );
	swigFunction( "c-function wl_callback_add_listener wl_callback_add_listener a a a -- n", "FUNCTION: wl_callback_add_listener ( wl_callback listener data -- n )", "EXTERN: \"C\" int wl_callback_add_listener( void * wl_callback, void * listener, void * data );", "	( wl_callback listener data -- )" );
	swigFunction( "c-function wl_callback_set_user_data wl_callback_set_user_data a a -- void", "FUNCTION: wl_callback_set_user_data ( wl_callback user_data -- void )", "EXTERN: \"C\" void wl_callback_set_user_data( void * wl_callback, void * user_data );", "	( wl_callback user_data -- )" );
	swigFunction( "c-function wl_callback_get_user_data wl_callback_get_user_data a -- a", "FUNCTION: wl_callback_get_user_data ( wl_callback -- a )", "EXTERN: \"C\" void * wl_callback_get_user_data( void * wl_callback );", "	( wl_callback -- )" );
	swigFunction( "c-function wl_callback_get_version wl_callback_get_version a -- u", "FUNCTION: wl_callback_get_version ( wl_callback -- u )", "EXTERN: \"C\" int wl_callback_get_version( void * wl_callback );", "	( wl_callback -- )" );
	swigFunction( "c-function wl_callback_destroy wl_callback_destroy a -- void", "FUNCTION: wl_callback_destroy ( wl_callback -- void )", "EXTERN: \"C\" void wl_callback_destroy( void * wl_callback );", "	( wl_callback -- )" );
	swigFunction( "c-function wl_compositor_set_user_data wl_compositor_set_user_data a a -- void", "FUNCTION: wl_compositor_set_user_data ( wl_compositor user_data -- void )", "EXTERN: \"C\" void wl_compositor_set_user_data( void * wl_compositor, void * user_data );", "	( wl_compositor user_data -- )" );
	swigFunction( "c-function wl_compositor_get_user_data wl_compositor_get_user_data a -- a", "FUNCTION: wl_compositor_get_user_data ( wl_compositor -- a )", "EXTERN: \"C\" void * wl_compositor_get_user_data( void * wl_compositor );", "	( wl_compositor -- )" );
	swigFunction( "c-function wl_compositor_get_version wl_compositor_get_version a -- u", "FUNCTION: wl_compositor_get_version ( wl_compositor -- u )", "EXTERN: \"C\" int wl_compositor_get_version( void * wl_compositor );", "	( wl_compositor -- )" );
	swigFunction( "c-function wl_compositor_destroy wl_compositor_destroy a -- void", "FUNCTION: wl_compositor_destroy ( wl_compositor -- void )", "EXTERN: \"C\" void wl_compositor_destroy( void * wl_compositor );", "	( wl_compositor -- )" );
	swigFunction( "c-function wl_compositor_create_surface wl_compositor_create_surface a -- a", "FUNCTION: wl_compositor_create_surface ( wl_compositor -- a )", "EXTERN: \"C\" void * wl_compositor_create_surface( void * wl_compositor );", "	( wl_compositor -- )" );
	swigFunction( "c-function wl_compositor_create_region wl_compositor_create_region a -- a", "FUNCTION: wl_compositor_create_region ( wl_compositor -- a )", "EXTERN: \"C\" void * wl_compositor_create_region( void * wl_compositor );", "	( wl_compositor -- )" );
	swigFunction( "c-function wl_shm_pool_set_user_data wl_shm_pool_set_user_data a a -- void", "FUNCTION: wl_shm_pool_set_user_data ( wl_shm_pool user_data -- void )", "EXTERN: \"C\" void wl_shm_pool_set_user_data( void * wl_shm_pool, void * user_data );", "	( wl_shm_pool user_data -- )" );
	swigFunction( "c-function wl_shm_pool_get_user_data wl_shm_pool_get_user_data a -- a", "FUNCTION: wl_shm_pool_get_user_data ( wl_shm_pool -- a )", "EXTERN: \"C\" void * wl_shm_pool_get_user_data( void * wl_shm_pool );", "	( wl_shm_pool -- )" );
	swigFunction( "c-function wl_shm_pool_get_version wl_shm_pool_get_version a -- u", "FUNCTION: wl_shm_pool_get_version ( wl_shm_pool -- u )", "EXTERN: \"C\" int wl_shm_pool_get_version( void * wl_shm_pool );", "	( wl_shm_pool -- )" );
	swigFunction( "c-function wl_shm_pool_create_buffer wl_shm_pool_create_buffer a n n n n u -- a", "FUNCTION: wl_shm_pool_create_buffer ( wl_shm_pool offset width height stride format -- a )", "EXTERN: \"C\" void * wl_shm_pool_create_buffer( void * wl_shm_pool, int offset, int width, int height, int stride, int format );", "	( wl_shm_pool offset width height stride format -- )" );
	swigFunction( "c-function wl_shm_pool_destroy wl_shm_pool_destroy a -- void", "FUNCTION: wl_shm_pool_destroy ( wl_shm_pool -- void )", "EXTERN: \"C\" void wl_shm_pool_destroy( void * wl_shm_pool );", "	( wl_shm_pool -- )" );
	swigFunction( "c-function wl_shm_pool_resize wl_shm_pool_resize a n -- void", "FUNCTION: wl_shm_pool_resize ( wl_shm_pool size -- void )", "EXTERN: \"C\" void wl_shm_pool_resize( void * wl_shm_pool, int size );", "	( wl_shm_pool size -- )" );
	swigFunction( "c-function wl_shm_add_listener wl_shm_add_listener a a a -- n", "FUNCTION: wl_shm_add_listener ( wl_shm listener data -- n )", "EXTERN: \"C\" int wl_shm_add_listener( void * wl_shm, void * listener, void * data );", "	( wl_shm listener data -- )" );
	swigFunction( "c-function wl_shm_set_user_data wl_shm_set_user_data a a -- void", "FUNCTION: wl_shm_set_user_data ( wl_shm user_data -- void )", "EXTERN: \"C\" void wl_shm_set_user_data( void * wl_shm, void * user_data );", "	( wl_shm user_data -- )" );
	swigFunction( "c-function wl_shm_get_user_data wl_shm_get_user_data a -- a", "FUNCTION: wl_shm_get_user_data ( wl_shm -- a )", "EXTERN: \"C\" void * wl_shm_get_user_data( void * wl_shm );", "	( wl_shm -- )" );
	swigFunction( "c-function wl_shm_get_version wl_shm_get_version a -- u", "FUNCTION: wl_shm_get_version ( wl_shm -- u )", "EXTERN: \"C\" int wl_shm_get_version( void * wl_shm );", "	( wl_shm -- )" );
	swigFunction( "c-function wl_shm_destroy wl_shm_destroy a -- void", "FUNCTION: wl_shm_destroy ( wl_shm -- void )", "EXTERN: \"C\" void wl_shm_destroy( void * wl_shm );", "	( wl_shm -- )" );
	swigFunction( "c-function wl_shm_create_pool wl_shm_create_pool a n n -- a", "FUNCTION: wl_shm_create_pool ( wl_shm fd size -- a )", "EXTERN: \"C\" void * wl_shm_create_pool( void * wl_shm, int fd, int size );", "	( wl_shm fd size -- )" );
	swigFunction( "c-function wl_buffer_add_listener wl_buffer_add_listener a a a -- n", "FUNCTION: wl_buffer_add_listener ( wl_buffer listener data -- n )", "EXTERN: \"C\" int wl_buffer_add_listener( void * wl_buffer, void * listener, void * data );", "	( wl_buffer listener data -- )" );
	swigFunction( "c-function wl_buffer_set_user_data wl_buffer_set_user_data a a -- void", "FUNCTION: wl_buffer_set_user_data ( wl_buffer user_data -- void )", "EXTERN: \"C\" void wl_buffer_set_user_data( void * wl_buffer, void * user_data );", "	( wl_buffer user_data -- )" );
	swigFunction( "c-function wl_buffer_get_user_data wl_buffer_get_user_data a -- a", "FUNCTION: wl_buffer_get_user_data ( wl_buffer -- a )", "EXTERN: \"C\" void * wl_buffer_get_user_data( void * wl_buffer );", "	( wl_buffer -- )" );
	swigFunction( "c-function wl_buffer_get_version wl_buffer_get_version a -- u", "FUNCTION: wl_buffer_get_version ( wl_buffer -- u )", "EXTERN: \"C\" int wl_buffer_get_version( void * wl_buffer );", "	( wl_buffer -- )" );
	swigFunction( "c-function wl_buffer_destroy wl_buffer_destroy a -- void", "FUNCTION: wl_buffer_destroy ( wl_buffer -- void )", "EXTERN: \"C\" void wl_buffer_destroy( void * wl_buffer );", "	( wl_buffer -- )" );
	swigFunction( "c-function wl_data_offer_add_listener wl_data_offer_add_listener a a a -- n", "FUNCTION: wl_data_offer_add_listener ( wl_data_offer listener data -- n )", "EXTERN: \"C\" int wl_data_offer_add_listener( void * wl_data_offer, void * listener, void * data );", "	( wl_data_offer listener data -- )" );
	swigFunction( "c-function wl_data_offer_set_user_data wl_data_offer_set_user_data a a -- void", "FUNCTION: wl_data_offer_set_user_data ( wl_data_offer user_data -- void )", "EXTERN: \"C\" void wl_data_offer_set_user_data( void * wl_data_offer, void * user_data );", "	( wl_data_offer user_data -- )" );
	swigFunction( "c-function wl_data_offer_get_user_data wl_data_offer_get_user_data a -- a", "FUNCTION: wl_data_offer_get_user_data ( wl_data_offer -- a )", "EXTERN: \"C\" void * wl_data_offer_get_user_data( void * wl_data_offer );", "	( wl_data_offer -- )" );
	swigFunction( "c-function wl_data_offer_get_version wl_data_offer_get_version a -- u", "FUNCTION: wl_data_offer_get_version ( wl_data_offer -- u )", "EXTERN: \"C\" int wl_data_offer_get_version( void * wl_data_offer );", "	( wl_data_offer -- )" );
	swigFunction( "c-function wl_data_offer_accept wl_data_offer_accept a u s -- void", "FUNCTION: wl_data_offer_accept ( wl_data_offer serial mime_type -- void )", "EXTERN: \"C\" void wl_data_offer_accept( void * wl_data_offer, int serial, char * mime_type );", "	( wl_data_offer serial mime_type -- )" );
	swigFunction( "c-function wl_data_offer_receive wl_data_offer_receive a s n -- void", "FUNCTION: wl_data_offer_receive ( wl_data_offer mime_type fd -- void )", "EXTERN: \"C\" void wl_data_offer_receive( void * wl_data_offer, char * mime_type, int fd );", "	( wl_data_offer mime_type fd -- )" );
	swigFunction( "c-function wl_data_offer_destroy wl_data_offer_destroy a -- void", "FUNCTION: wl_data_offer_destroy ( wl_data_offer -- void )", "EXTERN: \"C\" void wl_data_offer_destroy( void * wl_data_offer );", "	( wl_data_offer -- )" );
	swigFunction( "c-function wl_data_offer_finish wl_data_offer_finish a -- void", "FUNCTION: wl_data_offer_finish ( wl_data_offer -- void )", "EXTERN: \"C\" void wl_data_offer_finish( void * wl_data_offer );", "	( wl_data_offer -- )" );
	swigFunction( "c-function wl_data_offer_set_actions wl_data_offer_set_actions a u u -- void", "FUNCTION: wl_data_offer_set_actions ( wl_data_offer dnd_actions preferred_action -- void )", "EXTERN: \"C\" void wl_data_offer_set_actions( void * wl_data_offer, int dnd_actions, int preferred_action );", "	( wl_data_offer dnd_actions preferred_action -- )" );
	swigFunction( "c-function wl_data_source_add_listener wl_data_source_add_listener a a a -- n", "FUNCTION: wl_data_source_add_listener ( wl_data_source listener data -- n )", "EXTERN: \"C\" int wl_data_source_add_listener( void * wl_data_source, void * listener, void * data );", "	( wl_data_source listener data -- )" );
	swigFunction( "c-function wl_data_source_set_user_data wl_data_source_set_user_data a a -- void", "FUNCTION: wl_data_source_set_user_data ( wl_data_source user_data -- void )", "EXTERN: \"C\" void wl_data_source_set_user_data( void * wl_data_source, void * user_data );", "	( wl_data_source user_data -- )" );
	swigFunction( "c-function wl_data_source_get_user_data wl_data_source_get_user_data a -- a", "FUNCTION: wl_data_source_get_user_data ( wl_data_source -- a )", "EXTERN: \"C\" void * wl_data_source_get_user_data( void * wl_data_source );", "	( wl_data_source -- )" );
	swigFunction( "c-function wl_data_source_get_version wl_data_source_get_version a -- u", "FUNCTION: wl_data_source_get_version ( wl_data_source -- u )", "EXTERN: \"C\" int wl_data_source_get_version( void * wl_data_source );", "	( wl_data_source -- )" );
	swigFunction( "c-function wl_data_source_offer wl_data_source_offer a s -- void", "FUNCTION: wl_data_source_offer ( wl_data_source mime_type -- void )", "EXTERN: \"C\" void wl_data_source_offer( void * wl_data_source, char * mime_type );", "	( wl_data_source mime_type -- )" );
	swigFunction( "c-function wl_data_source_destroy wl_data_source_destroy a -- void", "FUNCTION: wl_data_source_destroy ( wl_data_source -- void )", "EXTERN: \"C\" void wl_data_source_destroy( void * wl_data_source );", "	( wl_data_source -- )" );
	swigFunction( "c-function wl_data_source_set_actions wl_data_source_set_actions a u -- void", "FUNCTION: wl_data_source_set_actions ( wl_data_source dnd_actions -- void )", "EXTERN: \"C\" void wl_data_source_set_actions( void * wl_data_source, int dnd_actions );", "	( wl_data_source dnd_actions -- )" );
	swigFunction( "c-function wl_data_device_add_listener wl_data_device_add_listener a a a -- n", "FUNCTION: wl_data_device_add_listener ( wl_data_device listener data -- n )", "EXTERN: \"C\" int wl_data_device_add_listener( void * wl_data_device, void * listener, void * data );", "	( wl_data_device listener data -- )" );
	swigFunction( "c-function wl_data_device_set_user_data wl_data_device_set_user_data a a -- void", "FUNCTION: wl_data_device_set_user_data ( wl_data_device user_data -- void )", "EXTERN: \"C\" void wl_data_device_set_user_data( void * wl_data_device, void * user_data );", "	( wl_data_device user_data -- )" );
	swigFunction( "c-function wl_data_device_get_user_data wl_data_device_get_user_data a -- a", "FUNCTION: wl_data_device_get_user_data ( wl_data_device -- a )", "EXTERN: \"C\" void * wl_data_device_get_user_data( void * wl_data_device );", "	( wl_data_device -- )" );
	swigFunction( "c-function wl_data_device_get_version wl_data_device_get_version a -- u", "FUNCTION: wl_data_device_get_version ( wl_data_device -- u )", "EXTERN: \"C\" int wl_data_device_get_version( void * wl_data_device );", "	( wl_data_device -- )" );
	swigFunction( "c-function wl_data_device_destroy wl_data_device_destroy a -- void", "FUNCTION: wl_data_device_destroy ( wl_data_device -- void )", "EXTERN: \"C\" void wl_data_device_destroy( void * wl_data_device );", "	( wl_data_device -- )" );
	swigFunction( "c-function wl_data_device_start_drag wl_data_device_start_drag a a a a u -- void", "FUNCTION: wl_data_device_start_drag ( wl_data_device source origin icon serial -- void )", "EXTERN: \"C\" void wl_data_device_start_drag( void * wl_data_device, void * source, void * origin, void * icon, int serial );", "	( wl_data_device source origin icon serial -- )" );
	swigFunction( "c-function wl_data_device_set_selection wl_data_device_set_selection a a u -- void", "FUNCTION: wl_data_device_set_selection ( wl_data_device source serial -- void )", "EXTERN: \"C\" void wl_data_device_set_selection( void * wl_data_device, void * source, int serial );", "	( wl_data_device source serial -- )" );
	swigFunction( "c-function wl_data_device_release wl_data_device_release a -- void", "FUNCTION: wl_data_device_release ( wl_data_device -- void )", "EXTERN: \"C\" void wl_data_device_release( void * wl_data_device );", "	( wl_data_device -- )" );
	swigFunction( "c-function wl_data_device_manager_set_user_data wl_data_device_manager_set_user_data a a -- void", "FUNCTION: wl_data_device_manager_set_user_data ( wl_data_device_manager user_data -- void )", "EXTERN: \"C\" void wl_data_device_manager_set_user_data( void * wl_data_device_manager, void * user_data );", "	( wl_data_device_manager user_data -- )" );
	swigFunction( "c-function wl_data_device_manager_get_user_data wl_data_device_manager_get_user_data a -- a", "FUNCTION: wl_data_device_manager_get_user_data ( wl_data_device_manager -- a )", "EXTERN: \"C\" void * wl_data_device_manager_get_user_data( void * wl_data_device_manager );", "	( wl_data_device_manager -- )" );
	swigFunction( "c-function wl_data_device_manager_get_version wl_data_device_manager_get_version a -- u", "FUNCTION: wl_data_device_manager_get_version ( wl_data_device_manager -- u )", "EXTERN: \"C\" int wl_data_device_manager_get_version( void * wl_data_device_manager );", "	( wl_data_device_manager -- )" );
	swigFunction( "c-function wl_data_device_manager_destroy wl_data_device_manager_destroy a -- void", "FUNCTION: wl_data_device_manager_destroy ( wl_data_device_manager -- void )", "EXTERN: \"C\" void wl_data_device_manager_destroy( void * wl_data_device_manager );", "	( wl_data_device_manager -- )" );
	swigFunction( "c-function wl_data_device_manager_create_data_source wl_data_device_manager_create_data_source a -- a", "FUNCTION: wl_data_device_manager_create_data_source ( wl_data_device_manager -- a )", "EXTERN: \"C\" void * wl_data_device_manager_create_data_source( void * wl_data_device_manager );", "	( wl_data_device_manager -- )" );
	swigFunction( "c-function wl_data_device_manager_get_data_device wl_data_device_manager_get_data_device a a -- a", "FUNCTION: wl_data_device_manager_get_data_device ( wl_data_device_manager seat -- a )", "EXTERN: \"C\" void * wl_data_device_manager_get_data_device( void * wl_data_device_manager, void * seat );", "	( wl_data_device_manager seat -- )" );
	swigFunction( "c-function wl_shell_set_user_data wl_shell_set_user_data a a -- void", "FUNCTION: wl_shell_set_user_data ( wl_shell user_data -- void )", "EXTERN: \"C\" void wl_shell_set_user_data( void * wl_shell, void * user_data );", "	( wl_shell user_data -- )" );
	swigFunction( "c-function wl_shell_get_user_data wl_shell_get_user_data a -- a", "FUNCTION: wl_shell_get_user_data ( wl_shell -- a )", "EXTERN: \"C\" void * wl_shell_get_user_data( void * wl_shell );", "	( wl_shell -- )" );
	swigFunction( "c-function wl_shell_get_version wl_shell_get_version a -- u", "FUNCTION: wl_shell_get_version ( wl_shell -- u )", "EXTERN: \"C\" int wl_shell_get_version( void * wl_shell );", "	( wl_shell -- )" );
	swigFunction( "c-function wl_shell_destroy wl_shell_destroy a -- void", "FUNCTION: wl_shell_destroy ( wl_shell -- void )", "EXTERN: \"C\" void wl_shell_destroy( void * wl_shell );", "	( wl_shell -- )" );
	swigFunction( "c-function wl_shell_get_shell_surface wl_shell_get_shell_surface a a -- a", "FUNCTION: wl_shell_get_shell_surface ( wl_shell surface -- a )", "EXTERN: \"C\" void * wl_shell_get_shell_surface( void * wl_shell, void * surface );", "	( wl_shell surface -- )" );
	swigFunction( "c-function wl_shell_surface_add_listener wl_shell_surface_add_listener a a a -- n", "FUNCTION: wl_shell_surface_add_listener ( wl_shell_surface listener data -- n )", "EXTERN: \"C\" int wl_shell_surface_add_listener( void * wl_shell_surface, void * listener, void * data );", "	( wl_shell_surface listener data -- )" );
	swigFunction( "c-function wl_shell_surface_set_user_data wl_shell_surface_set_user_data a a -- void", "FUNCTION: wl_shell_surface_set_user_data ( wl_shell_surface user_data -- void )", "EXTERN: \"C\" void wl_shell_surface_set_user_data( void * wl_shell_surface, void * user_data );", "	( wl_shell_surface user_data -- )" );
	swigFunction( "c-function wl_shell_surface_get_user_data wl_shell_surface_get_user_data a -- a", "FUNCTION: wl_shell_surface_get_user_data ( wl_shell_surface -- a )", "EXTERN: \"C\" void * wl_shell_surface_get_user_data( void * wl_shell_surface );", "	( wl_shell_surface -- )" );
	swigFunction( "c-function wl_shell_surface_get_version wl_shell_surface_get_version a -- u", "FUNCTION: wl_shell_surface_get_version ( wl_shell_surface -- u )", "EXTERN: \"C\" int wl_shell_surface_get_version( void * wl_shell_surface );", "	( wl_shell_surface -- )" );
	swigFunction( "c-function wl_shell_surface_destroy wl_shell_surface_destroy a -- void", "FUNCTION: wl_shell_surface_destroy ( wl_shell_surface -- void )", "EXTERN: \"C\" void wl_shell_surface_destroy( void * wl_shell_surface );", "	( wl_shell_surface -- )" );
	swigFunction( "c-function wl_shell_surface_pong wl_shell_surface_pong a u -- void", "FUNCTION: wl_shell_surface_pong ( wl_shell_surface serial -- void )", "EXTERN: \"C\" void wl_shell_surface_pong( void * wl_shell_surface, int serial );", "	( wl_shell_surface serial -- )" );
	swigFunction( "c-function wl_shell_surface_move wl_shell_surface_move a a u -- void", "FUNCTION: wl_shell_surface_move ( wl_shell_surface seat serial -- void )", "EXTERN: \"C\" void wl_shell_surface_move( void * wl_shell_surface, void * seat, int serial );", "	( wl_shell_surface seat serial -- )" );
	swigFunction( "c-function wl_shell_surface_set_toplevel wl_shell_surface_set_toplevel a -- void", "FUNCTION: wl_shell_surface_set_toplevel ( wl_shell_surface -- void )", "EXTERN: \"C\" void wl_shell_surface_set_toplevel( void * wl_shell_surface );", "	( wl_shell_surface -- )" );
	swigFunction( "c-function wl_shell_surface_set_transient wl_shell_surface_set_transient a a n n u -- void", "FUNCTION: wl_shell_surface_set_transient ( wl_shell_surface parent x y flags -- void )", "EXTERN: \"C\" void wl_shell_surface_set_transient( void * wl_shell_surface, void * parent, int x, int y, int flags );", "	( wl_shell_surface parent x y flags -- )" );
	swigFunction( "c-function wl_shell_surface_set_fullscreen wl_shell_surface_set_fullscreen a u u a -- void", "FUNCTION: wl_shell_surface_set_fullscreen ( wl_shell_surface method framerate output -- void )", "EXTERN: \"C\" void wl_shell_surface_set_fullscreen( void * wl_shell_surface, int method, int framerate, void * output );", "	( wl_shell_surface method framerate output -- )" );
	swigFunction( "c-function wl_shell_surface_set_popup wl_shell_surface_set_popup a a u a n n u -- void", "FUNCTION: wl_shell_surface_set_popup ( wl_shell_surface seat serial parent x y flags -- void )", "EXTERN: \"C\" void wl_shell_surface_set_popup( void * wl_shell_surface, void * seat, int serial, void * parent, int x, int y, int flags );", "	( wl_shell_surface seat serial parent x y flags -- )" );
	swigFunction( "c-function wl_shell_surface_set_maximized wl_shell_surface_set_maximized a a -- void", "FUNCTION: wl_shell_surface_set_maximized ( wl_shell_surface output -- void )", "EXTERN: \"C\" void wl_shell_surface_set_maximized( void * wl_shell_surface, void * output );", "	( wl_shell_surface output -- )" );
	swigFunction( "c-function wl_shell_surface_set_title wl_shell_surface_set_title a s -- void", "FUNCTION: wl_shell_surface_set_title ( wl_shell_surface title -- void )", "EXTERN: \"C\" void wl_shell_surface_set_title( void * wl_shell_surface, char * title );", "	( wl_shell_surface title -- )" );
	swigFunction( "c-function wl_shell_surface_set_class wl_shell_surface_set_class a s -- void", "FUNCTION: wl_shell_surface_set_class ( wl_shell_surface class_ -- void )", "EXTERN: \"C\" void wl_shell_surface_set_class( void * wl_shell_surface, char * class_ );", "	( wl_shell_surface class_ -- )" );
	swigFunction( "c-function wl_surface_add_listener wl_surface_add_listener a a a -- n", "FUNCTION: wl_surface_add_listener ( wl_surface listener data -- n )", "EXTERN: \"C\" int wl_surface_add_listener( void * wl_surface, void * listener, void * data );", "	( wl_surface listener data -- )" );
	swigFunction( "c-function wl_surface_set_user_data wl_surface_set_user_data a a -- void", "FUNCTION: wl_surface_set_user_data ( wl_surface user_data -- void )", "EXTERN: \"C\" void wl_surface_set_user_data( void * wl_surface, void * user_data );", "	( wl_surface user_data -- )" );
	swigFunction( "c-function wl_surface_get_user_data wl_surface_get_user_data a -- a", "FUNCTION: wl_surface_get_user_data ( wl_surface -- a )", "EXTERN: \"C\" void * wl_surface_get_user_data( void * wl_surface );", "	( wl_surface -- )" );
	swigFunction( "c-function wl_surface_get_version wl_surface_get_version a -- u", "FUNCTION: wl_surface_get_version ( wl_surface -- u )", "EXTERN: \"C\" int wl_surface_get_version( void * wl_surface );", "	( wl_surface -- )" );
	swigFunction( "c-function wl_surface_destroy wl_surface_destroy a -- void", "FUNCTION: wl_surface_destroy ( wl_surface -- void )", "EXTERN: \"C\" void wl_surface_destroy( void * wl_surface );", "	( wl_surface -- )" );
	swigFunction( "c-function wl_surface_attach wl_surface_attach a a n n -- void", "FUNCTION: wl_surface_attach ( wl_surface buffer x y -- void )", "EXTERN: \"C\" void wl_surface_attach( void * wl_surface, void * buffer, int x, int y );", "	( wl_surface buffer x y -- )" );
	swigFunction( "c-function wl_surface_damage wl_surface_damage a n n n n -- void", "FUNCTION: wl_surface_damage ( wl_surface x y width height -- void )", "EXTERN: \"C\" void wl_surface_damage( void * wl_surface, int x, int y, int width, int height );", "	( wl_surface x y width height -- )" );
	swigFunction( "c-function wl_surface_frame wl_surface_frame a -- a", "FUNCTION: wl_surface_frame ( wl_surface -- a )", "EXTERN: \"C\" void * wl_surface_frame( void * wl_surface );", "	( wl_surface -- )" );
	swigFunction( "c-function wl_surface_set_opaque_region wl_surface_set_opaque_region a a -- void", "FUNCTION: wl_surface_set_opaque_region ( wl_surface region -- void )", "EXTERN: \"C\" void wl_surface_set_opaque_region( void * wl_surface, void * region );", "	( wl_surface region -- )" );
	swigFunction( "c-function wl_surface_set_input_region wl_surface_set_input_region a a -- void", "FUNCTION: wl_surface_set_input_region ( wl_surface region -- void )", "EXTERN: \"C\" void wl_surface_set_input_region( void * wl_surface, void * region );", "	( wl_surface region -- )" );
	swigFunction( "c-function wl_surface_commit wl_surface_commit a -- void", "FUNCTION: wl_surface_commit ( wl_surface -- void )", "EXTERN: \"C\" void wl_surface_commit( void * wl_surface );", "	( wl_surface -- )" );
	swigFunction( "c-function wl_surface_set_buffer_transform wl_surface_set_buffer_transform a n -- void", "FUNCTION: wl_surface_set_buffer_transform ( wl_surface transform -- void )", "EXTERN: \"C\" void wl_surface_set_buffer_transform( void * wl_surface, int transform );", "	( wl_surface transform -- )" );
	swigFunction( "c-function wl_surface_set_buffer_scale wl_surface_set_buffer_scale a n -- void", "FUNCTION: wl_surface_set_buffer_scale ( wl_surface scale -- void )", "EXTERN: \"C\" void wl_surface_set_buffer_scale( void * wl_surface, int scale );", "	( wl_surface scale -- )" );
	swigFunction( "c-function wl_surface_damage_buffer wl_surface_damage_buffer a n n n n -- void", "FUNCTION: wl_surface_damage_buffer ( wl_surface x y width height -- void )", "EXTERN: \"C\" void wl_surface_damage_buffer( void * wl_surface, int x, int y, int width, int height );", "	( wl_surface x y width height -- )" );
	swigFunction( "c-function wl_surface_offset wl_surface_offset a n n -- void", "FUNCTION: wl_surface_offset ( wl_surface x y -- void )", "EXTERN: \"C\" void wl_surface_offset( void * wl_surface, int x, int y );", "	( wl_surface x y -- )" );
	swigFunction( "c-function wl_seat_add_listener wl_seat_add_listener a a a -- n", "FUNCTION: wl_seat_add_listener ( wl_seat listener data -- n )", "EXTERN: \"C\" int wl_seat_add_listener( void * wl_seat, void * listener, void * data );", "	( wl_seat listener data -- )" );
	swigFunction( "c-function wl_seat_set_user_data wl_seat_set_user_data a a -- void", "FUNCTION: wl_seat_set_user_data ( wl_seat user_data -- void )", "EXTERN: \"C\" void wl_seat_set_user_data( void * wl_seat, void * user_data );", "	( wl_seat user_data -- )" );
	swigFunction( "c-function wl_seat_get_user_data wl_seat_get_user_data a -- a", "FUNCTION: wl_seat_get_user_data ( wl_seat -- a )", "EXTERN: \"C\" void * wl_seat_get_user_data( void * wl_seat );", "	( wl_seat -- )" );
	swigFunction( "c-function wl_seat_get_version wl_seat_get_version a -- u", "FUNCTION: wl_seat_get_version ( wl_seat -- u )", "EXTERN: \"C\" int wl_seat_get_version( void * wl_seat );", "	( wl_seat -- )" );
	swigFunction( "c-function wl_seat_destroy wl_seat_destroy a -- void", "FUNCTION: wl_seat_destroy ( wl_seat -- void )", "EXTERN: \"C\" void wl_seat_destroy( void * wl_seat );", "	( wl_seat -- )" );
	swigFunction( "c-function wl_seat_get_pointer wl_seat_get_pointer a -- a", "FUNCTION: wl_seat_get_pointer ( wl_seat -- a )", "EXTERN: \"C\" void * wl_seat_get_pointer( void * wl_seat );", "	( wl_seat -- )" );
	swigFunction( "c-function wl_seat_get_keyboard wl_seat_get_keyboard a -- a", "FUNCTION: wl_seat_get_keyboard ( wl_seat -- a )", "EXTERN: \"C\" void * wl_seat_get_keyboard( void * wl_seat );", "	( wl_seat -- )" );
	swigFunction( "c-function wl_seat_get_touch wl_seat_get_touch a -- a", "FUNCTION: wl_seat_get_touch ( wl_seat -- a )", "EXTERN: \"C\" void * wl_seat_get_touch( void * wl_seat );", "	( wl_seat -- )" );
	swigFunction( "c-function wl_seat_release wl_seat_release a -- void", "FUNCTION: wl_seat_release ( wl_seat -- void )", "EXTERN: \"C\" void wl_seat_release( void * wl_seat );", "	( wl_seat -- )" );
	swigFunction( "c-function wl_pointer_add_listener wl_pointer_add_listener a a a -- n", "FUNCTION: wl_pointer_add_listener ( wl_pointer listener data -- n )", "EXTERN: \"C\" int wl_pointer_add_listener( void * wl_pointer, void * listener, void * data );", "	( wl_pointer listener data -- )" );
	swigFunction( "c-function wl_pointer_set_user_data wl_pointer_set_user_data a a -- void", "FUNCTION: wl_pointer_set_user_data ( wl_pointer user_data -- void )", "EXTERN: \"C\" void wl_pointer_set_user_data( void * wl_pointer, void * user_data );", "	( wl_pointer user_data -- )" );
	swigFunction( "c-function wl_pointer_get_user_data wl_pointer_get_user_data a -- a", "FUNCTION: wl_pointer_get_user_data ( wl_pointer -- a )", "EXTERN: \"C\" void * wl_pointer_get_user_data( void * wl_pointer );", "	( wl_pointer -- )" );
	swigFunction( "c-function wl_pointer_get_version wl_pointer_get_version a -- u", "FUNCTION: wl_pointer_get_version ( wl_pointer -- u )", "EXTERN: \"C\" int wl_pointer_get_version( void * wl_pointer );", "	( wl_pointer -- )" );
	swigFunction( "c-function wl_pointer_destroy wl_pointer_destroy a -- void", "FUNCTION: wl_pointer_destroy ( wl_pointer -- void )", "EXTERN: \"C\" void wl_pointer_destroy( void * wl_pointer );", "	( wl_pointer -- )" );
	swigFunction( "c-function wl_pointer_set_cursor wl_pointer_set_cursor a u a n n -- void", "FUNCTION: wl_pointer_set_cursor ( wl_pointer serial surface hotspot_x hotspot_y -- void )", "EXTERN: \"C\" void wl_pointer_set_cursor( void * wl_pointer, int serial, void * surface, int hotspot_x, int hotspot_y );", "	( wl_pointer serial surface hotspot_x hotspot_y -- )" );
	swigFunction( "c-function wl_pointer_release wl_pointer_release a -- void", "FUNCTION: wl_pointer_release ( wl_pointer -- void )", "EXTERN: \"C\" void wl_pointer_release( void * wl_pointer );", "	( wl_pointer -- )" );
	swigFunction( "c-function wl_keyboard_add_listener wl_keyboard_add_listener a a a -- n", "FUNCTION: wl_keyboard_add_listener ( wl_keyboard listener data -- n )", "EXTERN: \"C\" int wl_keyboard_add_listener( void * wl_keyboard, void * listener, void * data );", "	( wl_keyboard listener data -- )" );
	swigFunction( "c-function wl_keyboard_set_user_data wl_keyboard_set_user_data a a -- void", "FUNCTION: wl_keyboard_set_user_data ( wl_keyboard user_data -- void )", "EXTERN: \"C\" void wl_keyboard_set_user_data( void * wl_keyboard, void * user_data );", "	( wl_keyboard user_data -- )" );
	swigFunction( "c-function wl_keyboard_get_user_data wl_keyboard_get_user_data a -- a", "FUNCTION: wl_keyboard_get_user_data ( wl_keyboard -- a )", "EXTERN: \"C\" void * wl_keyboard_get_user_data( void * wl_keyboard );", "	( wl_keyboard -- )" );
	swigFunction( "c-function wl_keyboard_get_version wl_keyboard_get_version a -- u", "FUNCTION: wl_keyboard_get_version ( wl_keyboard -- u )", "EXTERN: \"C\" int wl_keyboard_get_version( void * wl_keyboard );", "	( wl_keyboard -- )" );
	swigFunction( "c-function wl_keyboard_destroy wl_keyboard_destroy a -- void", "FUNCTION: wl_keyboard_destroy ( wl_keyboard -- void )", "EXTERN: \"C\" void wl_keyboard_destroy( void * wl_keyboard );", "	( wl_keyboard -- )" );
	swigFunction( "c-function wl_keyboard_release wl_keyboard_release a -- void", "FUNCTION: wl_keyboard_release ( wl_keyboard -- void )", "EXTERN: \"C\" void wl_keyboard_release( void * wl_keyboard );", "	( wl_keyboard -- )" );
	swigFunction( "c-function wl_touch_add_listener wl_touch_add_listener a a a -- n", "FUNCTION: wl_touch_add_listener ( wl_touch listener data -- n )", "EXTERN: \"C\" int wl_touch_add_listener( void * wl_touch, void * listener, void * data );", "	( wl_touch listener data -- )" );
	swigFunction( "c-function wl_touch_set_user_data wl_touch_set_user_data a a -- void", "FUNCTION: wl_touch_set_user_data ( wl_touch user_data -- void )", "EXTERN: \"C\" void wl_touch_set_user_data( void * wl_touch, void * user_data );", "	( wl_touch user_data -- )" );
	swigFunction( "c-function wl_touch_get_user_data wl_touch_get_user_data a -- a", "FUNCTION: wl_touch_get_user_data ( wl_touch -- a )", "EXTERN: \"C\" void * wl_touch_get_user_data( void * wl_touch );", "	( wl_touch -- )" );
	swigFunction( "c-function wl_touch_get_version wl_touch_get_version a -- u", "FUNCTION: wl_touch_get_version ( wl_touch -- u )", "EXTERN: \"C\" int wl_touch_get_version( void * wl_touch );", "	( wl_touch -- )" );
	swigFunction( "c-function wl_touch_destroy wl_touch_destroy a -- void", "FUNCTION: wl_touch_destroy ( wl_touch -- void )", "EXTERN: \"C\" void wl_touch_destroy( void * wl_touch );", "	( wl_touch -- )" );
	swigFunction( "c-function wl_touch_release wl_touch_release a -- void", "FUNCTION: wl_touch_release ( wl_touch -- void )", "EXTERN: \"C\" void wl_touch_release( void * wl_touch );", "	( wl_touch -- )" );
	swigFunction( "c-function wl_output_add_listener wl_output_add_listener a a a -- n", "FUNCTION: wl_output_add_listener ( wl_output listener data -- n )", "EXTERN: \"C\" int wl_output_add_listener( void * wl_output, void * listener, void * data );", "	( wl_output listener data -- )" );
	swigFunction( "c-function wl_output_set_user_data wl_output_set_user_data a a -- void", "FUNCTION: wl_output_set_user_data ( wl_output user_data -- void )", "EXTERN: \"C\" void wl_output_set_user_data( void * wl_output, void * user_data );", "	( wl_output user_data -- )" );
	swigFunction( "c-function wl_output_get_user_data wl_output_get_user_data a -- a", "FUNCTION: wl_output_get_user_data ( wl_output -- a )", "EXTERN: \"C\" void * wl_output_get_user_data( void * wl_output );", "	( wl_output -- )" );
	swigFunction( "c-function wl_output_get_version wl_output_get_version a -- u", "FUNCTION: wl_output_get_version ( wl_output -- u )", "EXTERN: \"C\" int wl_output_get_version( void * wl_output );", "	( wl_output -- )" );
	swigFunction( "c-function wl_output_destroy wl_output_destroy a -- void", "FUNCTION: wl_output_destroy ( wl_output -- void )", "EXTERN: \"C\" void wl_output_destroy( void * wl_output );", "	( wl_output -- )" );
	swigFunction( "c-function wl_output_release wl_output_release a -- void", "FUNCTION: wl_output_release ( wl_output -- void )", "EXTERN: \"C\" void wl_output_release( void * wl_output );", "	( wl_output -- )" );
	swigFunction( "c-function wl_region_set_user_data wl_region_set_user_data a a -- void", "FUNCTION: wl_region_set_user_data ( wl_region user_data -- void )", "EXTERN: \"C\" void wl_region_set_user_data( void * wl_region, void * user_data );", "	( wl_region user_data -- )" );
	swigFunction( "c-function wl_region_get_user_data wl_region_get_user_data a -- a", "FUNCTION: wl_region_get_user_data ( wl_region -- a )", "EXTERN: \"C\" void * wl_region_get_user_data( void * wl_region );", "	( wl_region -- )" );
	swigFunction( "c-function wl_region_get_version wl_region_get_version a -- u", "FUNCTION: wl_region_get_version ( wl_region -- u )", "EXTERN: \"C\" int wl_region_get_version( void * wl_region );", "	( wl_region -- )" );
	swigFunction( "c-function wl_region_destroy wl_region_destroy a -- void", "FUNCTION: wl_region_destroy ( wl_region -- void )", "EXTERN: \"C\" void wl_region_destroy( void * wl_region );", "	( wl_region -- )" );
	swigFunction( "c-function wl_region_add wl_region_add a n n n n -- void", "FUNCTION: wl_region_add ( wl_region x y width height -- void )", "EXTERN: \"C\" void wl_region_add( void * wl_region, int x, int y, int width, int height );", "	( wl_region x y width height -- )" );
	swigFunction( "c-function wl_region_subtract wl_region_subtract a n n n n -- void", "FUNCTION: wl_region_subtract ( wl_region x y width height -- void )", "EXTERN: \"C\" void wl_region_subtract( void * wl_region, int x, int y, int width, int height );", "	( wl_region x y width height -- )" );
	swigFunction( "c-function wl_subcompositor_set_user_data wl_subcompositor_set_user_data a a -- void", "FUNCTION: wl_subcompositor_set_user_data ( wl_subcompositor user_data -- void )", "EXTERN: \"C\" void wl_subcompositor_set_user_data( void * wl_subcompositor, void * user_data );", "	( wl_subcompositor user_data -- )" );
	swigFunction( "c-function wl_subcompositor_get_user_data wl_subcompositor_get_user_data a -- a", "FUNCTION: wl_subcompositor_get_user_data ( wl_subcompositor -- a )", "EXTERN: \"C\" void * wl_subcompositor_get_user_data( void * wl_subcompositor );", "	( wl_subcompositor -- )" );
	swigFunction( "c-function wl_subcompositor_get_version wl_subcompositor_get_version a -- u", "FUNCTION: wl_subcompositor_get_version ( wl_subcompositor -- u )", "EXTERN: \"C\" int wl_subcompositor_get_version( void * wl_subcompositor );", "	( wl_subcompositor -- )" );
	swigFunction( "c-function wl_subcompositor_destroy wl_subcompositor_destroy a -- void", "FUNCTION: wl_subcompositor_destroy ( wl_subcompositor -- void )", "EXTERN: \"C\" void wl_subcompositor_destroy( void * wl_subcompositor );", "	( wl_subcompositor -- )" );
	swigFunction( "c-function wl_subcompositor_get_subsurface wl_subcompositor_get_subsurface a a a -- a", "FUNCTION: wl_subcompositor_get_subsurface ( wl_subcompositor surface parent -- a )", "EXTERN: \"C\" void * wl_subcompositor_get_subsurface( void * wl_subcompositor, void * surface, void * parent );", "	( wl_subcompositor surface parent -- )" );
	swigFunction( "c-function wl_subsurface_set_user_data wl_subsurface_set_user_data a a -- void", "FUNCTION: wl_subsurface_set_user_data ( wl_subsurface user_data -- void )", "EXTERN: \"C\" void wl_subsurface_set_user_data( void * wl_subsurface, void * user_data );", "	( wl_subsurface user_data -- )" );
	swigFunction( "c-function wl_subsurface_get_user_data wl_subsurface_get_user_data a -- a", "FUNCTION: wl_subsurface_get_user_data ( wl_subsurface -- a )", "EXTERN: \"C\" void * wl_subsurface_get_user_data( void * wl_subsurface );", "	( wl_subsurface -- )" );
	swigFunction( "c-function wl_subsurface_get_version wl_subsurface_get_version a -- u", "FUNCTION: wl_subsurface_get_version ( wl_subsurface -- u )", "EXTERN: \"C\" int wl_subsurface_get_version( void * wl_subsurface );", "	( wl_subsurface -- )" );
	swigFunction( "c-function wl_subsurface_destroy wl_subsurface_destroy a -- void", "FUNCTION: wl_subsurface_destroy ( wl_subsurface -- void )", "EXTERN: \"C\" void wl_subsurface_destroy( void * wl_subsurface );", "	( wl_subsurface -- )" );
	swigFunction( "c-function wl_subsurface_set_position wl_subsurface_set_position a n n -- void", "FUNCTION: wl_subsurface_set_position ( wl_subsurface x y -- void )", "EXTERN: \"C\" void wl_subsurface_set_position( void * wl_subsurface, int x, int y );", "	( wl_subsurface x y -- )" );
	swigFunction( "c-function wl_subsurface_place_above wl_subsurface_place_above a a -- void", "FUNCTION: wl_subsurface_place_above ( wl_subsurface sibling -- void )", "EXTERN: \"C\" void wl_subsurface_place_above( void * wl_subsurface, void * sibling );", "	( wl_subsurface sibling -- )" );
	swigFunction( "c-function wl_subsurface_place_below wl_subsurface_place_below a a -- void", "FUNCTION: wl_subsurface_place_below ( wl_subsurface sibling -- void )", "EXTERN: \"C\" void wl_subsurface_place_below( void * wl_subsurface, void * sibling );", "	( wl_subsurface sibling -- )" );
	swigFunction( "c-function wl_subsurface_set_sync wl_subsurface_set_sync a -- void", "FUNCTION: wl_subsurface_set_sync ( wl_subsurface -- void )", "EXTERN: \"C\" void wl_subsurface_set_sync( void * wl_subsurface );", "	( wl_subsurface -- )" );
	swigFunction( "c-function wl_subsurface_set_desync wl_subsurface_set_desync a -- void", "FUNCTION: wl_subsurface_set_desync ( wl_subsurface -- void )", "EXTERN: \"C\" void wl_subsurface_set_desync( void * wl_subsurface );", "	( wl_subsurface -- )" );
	swigFunction( "c-function wl_egl_window_create wl_egl_window_create a n n -- a", "FUNCTION: wl_egl_window_create ( surface width height -- a )", "EXTERN: \"C\" void * wl_egl_window_create( void * surface, int width, int height );", "	( surface width height -- )" );
	swigFunction( "c-function wl_egl_window_destroy wl_egl_window_destroy a -- void", "FUNCTION: wl_egl_window_destroy ( egl_window -- void )", "EXTERN: \"C\" void wl_egl_window_destroy( void * egl_window );", "	( egl_window -- )" );
	swigFunction( "c-function wl_egl_window_resize wl_egl_window_resize a n n n n -- void", "FUNCTION: wl_egl_window_resize ( egl_window width height dx dy -- void )", "EXTERN: \"C\" void wl_egl_window_resize( void * egl_window, int width, int height, int dx, int dy );", "	( egl_window width height dx dy -- )" );
	swigFunction( "c-function wl_egl_window_get_attached_size wl_egl_window_get_attached_size a a a -- void", "FUNCTION: wl_egl_window_get_attached_size ( egl_window width height -- void )", "EXTERN: \"C\" void wl_egl_window_get_attached_size( void * egl_window, void * width, void * height );", "	( egl_window width height -- )" );
	swigFunction( "c-function wl_cursor_theme_load wl_cursor_theme_load s n a -- a", "FUNCTION: wl_cursor_theme_load ( name size shm -- a )", "EXTERN: \"C\" void * wl_cursor_theme_load( char * name, int size, void * shm );", "	( name size shm -- )" );
	swigFunction( "c-function wl_cursor_theme_destroy wl_cursor_theme_destroy a -- void", "FUNCTION: wl_cursor_theme_destroy ( theme -- void )", "EXTERN: \"C\" void wl_cursor_theme_destroy( void * theme );", "	( theme -- )" );
	swigFunction( "c-function wl_cursor_theme_get_cursor wl_cursor_theme_get_cursor a s -- a", "FUNCTION: wl_cursor_theme_get_cursor ( theme name -- a )", "EXTERN: \"C\" void * wl_cursor_theme_get_cursor( void * theme, char * name );", "	( theme name -- )" );
	swigFunction( "c-function wl_cursor_image_get_buffer wl_cursor_image_get_buffer a -- a", "FUNCTION: wl_cursor_image_get_buffer ( image -- a )", "EXTERN: \"C\" void * wl_cursor_image_get_buffer( void * image );", "	( image -- )" );
	swigFunction( "c-function wl_cursor_frame wl_cursor_frame a u -- n", "FUNCTION: wl_cursor_frame ( cursor time -- n )", "EXTERN: \"C\" int wl_cursor_frame( void * cursor, int time );", "	( cursor time -- )" );
	swigFunction( "c-function wl_cursor_frame_and_duration wl_cursor_frame_and_duration a u a -- n", "FUNCTION: wl_cursor_frame_and_duration ( cursor time duration -- n )", "EXTERN: \"C\" int wl_cursor_frame_and_duration( void * cursor, int time, void * duration );", "	( cursor time duration -- )" );
	swigFunction( "c-function wl_list_init wl_list_init a -- void", "FUNCTION: wl_list_init ( list -- void )", "EXTERN: \"C\" void wl_list_init( void * list );", "	( list -- )" );
	swigFunction( "c-function wl_list_insert wl_list_insert a a -- void", "FUNCTION: wl_list_insert ( list elm -- void )", "EXTERN: \"C\" void wl_list_insert( void * list, void * elm );", "	( list elm -- )" );
	swigFunction( "c-function wl_list_remove wl_list_remove a -- void", "FUNCTION: wl_list_remove ( elm -- void )", "EXTERN: \"C\" void wl_list_remove( void * elm );", "	( elm -- )" );
	swigFunction( "c-function wl_list_length wl_list_length a -- n", "FUNCTION: wl_list_length ( list -- n )", "EXTERN: \"C\" int wl_list_length( void * list );", "	( list -- )" );
	swigFunction( "c-function wl_list_empty wl_list_empty a -- n", "FUNCTION: wl_list_empty ( list -- n )", "EXTERN: \"C\" int wl_list_empty( void * list );", "	( list -- )" );
	swigFunction( "c-function wl_list_insert_list wl_list_insert_list a a -- void", "FUNCTION: wl_list_insert_list ( list other -- void )", "EXTERN: \"C\" void wl_list_insert_list( void * list, void * other );", "	( list other -- )" );
	swigFunction( "c-function wl_array_init wl_array_init a -- void", "FUNCTION: wl_array_init ( array -- void )", "EXTERN: \"C\" void wl_array_init( void * array );", "	( array -- )" );
	swigFunction( "c-function wl_array_release wl_array_release a -- void", "FUNCTION: wl_array_release ( array -- void )", "EXTERN: \"C\" void wl_array_release( void * array );", "	( array -- )" );
	swigFunction( "c-function wl_array_add wl_array_add a n -- a", "FUNCTION: wl_array_add ( array size -- a )", "EXTERN: \"C\" void * wl_array_add( void * array, long size );", "	( array size -- )" );
	swigFunction( "c-function wl_array_copy wl_array_copy a a -- n", "FUNCTION: wl_array_copy ( array source -- n )", "EXTERN: \"C\" int wl_array_copy( void * array, void * source );", "	( array source -- )" );
	swigFunction( "c-function wl_fixed_to_double wl_fixed_to_double n -- r", "FUNCTION: wl_fixed_to_double ( f -- r )", "EXTERN: \"C\" double wl_fixed_to_double( int f );", "	( f -- )" );
	swigFunction( "c-function wl_fixed_from_double wl_fixed_from_double r -- n", "FUNCTION: wl_fixed_from_double ( d -- n )", "EXTERN: \"C\" int wl_fixed_from_double( double d );", "	( d -- )" );
	swigFunction( "c-function wl_fixed_to_int wl_fixed_to_int n -- n", "FUNCTION: wl_fixed_to_int ( f -- n )", "EXTERN: \"C\" int wl_fixed_to_int( int f );", "	( f -- )" );
	swigFunction( "c-function wl_fixed_from_int wl_fixed_from_int n -- n", "FUNCTION: wl_fixed_from_int ( i -- n )", "EXTERN: \"C\" int wl_fixed_from_int( int i );", "	( i -- )" );
	swigFunction( "c-function zwp_text_input_v3_add_listener zwp_text_input_v3_add_listener a a a -- n", "FUNCTION: zwp_text_input_v3_add_listener ( zwp_text_input_v3 listener data -- n )", "EXTERN: \"C\" int zwp_text_input_v3_add_listener( void * zwp_text_input_v3, void * listener, void * data );", "	( zwp_text_input_v3 listener data -- )" );
	swigFunction( "c-function zwp_text_input_v3_set_user_data zwp_text_input_v3_set_user_data a a -- void", "FUNCTION: zwp_text_input_v3_set_user_data ( zwp_text_input_v3 user_data -- void )", "EXTERN: \"C\" void zwp_text_input_v3_set_user_data( void * zwp_text_input_v3, void * user_data );", "	( zwp_text_input_v3 user_data -- )" );
	swigFunction( "c-function zwp_text_input_v3_get_user_data zwp_text_input_v3_get_user_data a -- a", "FUNCTION: zwp_text_input_v3_get_user_data ( zwp_text_input_v3 -- a )", "EXTERN: \"C\" void * zwp_text_input_v3_get_user_data( void * zwp_text_input_v3 );", "	( zwp_text_input_v3 -- )" );
	swigFunction( "c-function zwp_text_input_v3_get_version zwp_text_input_v3_get_version a -- u", "FUNCTION: zwp_text_input_v3_get_version ( zwp_text_input_v3 -- u )", "EXTERN: \"C\" int zwp_text_input_v3_get_version( void * zwp_text_input_v3 );", "	( zwp_text_input_v3 -- )" );
	swigFunction( "c-function zwp_text_input_v3_destroy zwp_text_input_v3_destroy a -- void", "FUNCTION: zwp_text_input_v3_destroy ( zwp_text_input_v3 -- void )", "EXTERN: \"C\" void zwp_text_input_v3_destroy( void * zwp_text_input_v3 );", "	( zwp_text_input_v3 -- )" );
	swigFunction( "c-function zwp_text_input_v3_enable zwp_text_input_v3_enable a -- void", "FUNCTION: zwp_text_input_v3_enable ( zwp_text_input_v3 -- void )", "EXTERN: \"C\" void zwp_text_input_v3_enable( void * zwp_text_input_v3 );", "	( zwp_text_input_v3 -- )" );
	swigFunction( "c-function zwp_text_input_v3_disable zwp_text_input_v3_disable a -- void", "FUNCTION: zwp_text_input_v3_disable ( zwp_text_input_v3 -- void )", "EXTERN: \"C\" void zwp_text_input_v3_disable( void * zwp_text_input_v3 );", "	( zwp_text_input_v3 -- )" );
	swigFunction( "c-function zwp_text_input_v3_set_surrounding_text zwp_text_input_v3_set_surrounding_text a s n n -- void", "FUNCTION: zwp_text_input_v3_set_surrounding_text ( zwp_text_input_v3 text cursor anchor -- void )", "EXTERN: \"C\" void zwp_text_input_v3_set_surrounding_text( void * zwp_text_input_v3, char * text, int cursor, int anchor );", "	( zwp_text_input_v3 text cursor anchor -- )" );
	swigFunction( "c-function zwp_text_input_v3_set_text_change_cause zwp_text_input_v3_set_text_change_cause a u -- void", "FUNCTION: zwp_text_input_v3_set_text_change_cause ( zwp_text_input_v3 cause -- void )", "EXTERN: \"C\" void zwp_text_input_v3_set_text_change_cause( void * zwp_text_input_v3, int cause );", "	( zwp_text_input_v3 cause -- )" );
	swigFunction( "c-function zwp_text_input_v3_set_content_type zwp_text_input_v3_set_content_type a u u -- void", "FUNCTION: zwp_text_input_v3_set_content_type ( zwp_text_input_v3 hint purpose -- void )", "EXTERN: \"C\" void zwp_text_input_v3_set_content_type( void * zwp_text_input_v3, int hint, int purpose );", "	( zwp_text_input_v3 hint purpose -- )" );
	swigFunction( "c-function zwp_text_input_v3_set_cursor_rectangle zwp_text_input_v3_set_cursor_rectangle a n n n n -- void", "FUNCTION: zwp_text_input_v3_set_cursor_rectangle ( zwp_text_input_v3 x y width height -- void )", "EXTERN: \"C\" void zwp_text_input_v3_set_cursor_rectangle( void * zwp_text_input_v3, int x, int y, int width, int height );", "	( zwp_text_input_v3 x y width height -- )" );
	swigFunction( "c-function zwp_text_input_v3_commit zwp_text_input_v3_commit a -- void", "FUNCTION: zwp_text_input_v3_commit ( zwp_text_input_v3 -- void )", "EXTERN: \"C\" void zwp_text_input_v3_commit( void * zwp_text_input_v3 );", "	( zwp_text_input_v3 -- )" );
	swigFunction( "c-function zwp_text_input_manager_v3_set_user_data zwp_text_input_manager_v3_set_user_data a a -- void", "FUNCTION: zwp_text_input_manager_v3_set_user_data ( zwp_text_input_manager_v3 user_data -- void )", "EXTERN: \"C\" void zwp_text_input_manager_v3_set_user_data( void * zwp_text_input_manager_v3, void * user_data );", "	( zwp_text_input_manager_v3 user_data -- )" );
	swigFunction( "c-function zwp_text_input_manager_v3_get_user_data zwp_text_input_manager_v3_get_user_data a -- a", "FUNCTION: zwp_text_input_manager_v3_get_user_data ( zwp_text_input_manager_v3 -- a )", "EXTERN: \"C\" void * zwp_text_input_manager_v3_get_user_data( void * zwp_text_input_manager_v3 );", "	( zwp_text_input_manager_v3 -- )" );
	swigFunction( "c-function zwp_text_input_manager_v3_get_version zwp_text_input_manager_v3_get_version a -- u", "FUNCTION: zwp_text_input_manager_v3_get_version ( zwp_text_input_manager_v3 -- u )", "EXTERN: \"C\" int zwp_text_input_manager_v3_get_version( void * zwp_text_input_manager_v3 );", "	( zwp_text_input_manager_v3 -- )" );
	swigFunction( "c-function zwp_text_input_manager_v3_destroy zwp_text_input_manager_v3_destroy a -- void", "FUNCTION: zwp_text_input_manager_v3_destroy ( zwp_text_input_manager_v3 -- void )", "EXTERN: \"C\" void zwp_text_input_manager_v3_destroy( void * zwp_text_input_manager_v3 );", "	( zwp_text_input_manager_v3 -- )" );
	swigFunction( "c-function zwp_text_input_manager_v3_get_text_input zwp_text_input_manager_v3_get_text_input a a -- a", "FUNCTION: zwp_text_input_manager_v3_get_text_input ( zwp_text_input_manager_v3 seat -- a )", "EXTERN: \"C\" void * zwp_text_input_manager_v3_get_text_input( void * zwp_text_input_manager_v3, void * seat );", "	( zwp_text_input_manager_v3 seat -- )" );
	swigFunction( "c-function xdg_wm_base_add_listener xdg_wm_base_add_listener a a a -- n", "FUNCTION: xdg_wm_base_add_listener ( xdg_wm_base listener data -- n )", "EXTERN: \"C\" int xdg_wm_base_add_listener( void * xdg_wm_base, void * listener, void * data );", "	( xdg_wm_base listener data -- )" );
	swigFunction( "c-function xdg_wm_base_set_user_data xdg_wm_base_set_user_data a a -- void", "FUNCTION: xdg_wm_base_set_user_data ( xdg_wm_base user_data -- void )", "EXTERN: \"C\" void xdg_wm_base_set_user_data( void * xdg_wm_base, void * user_data );", "	( xdg_wm_base user_data -- )" );
	swigFunction( "c-function xdg_wm_base_get_user_data xdg_wm_base_get_user_data a -- a", "FUNCTION: xdg_wm_base_get_user_data ( xdg_wm_base -- a )", "EXTERN: \"C\" void * xdg_wm_base_get_user_data( void * xdg_wm_base );", "	( xdg_wm_base -- )" );
	swigFunction( "c-function xdg_wm_base_get_version xdg_wm_base_get_version a -- u", "FUNCTION: xdg_wm_base_get_version ( xdg_wm_base -- u )", "EXTERN: \"C\" int xdg_wm_base_get_version( void * xdg_wm_base );", "	( xdg_wm_base -- )" );
	swigFunction( "c-function xdg_wm_base_destroy xdg_wm_base_destroy a -- void", "FUNCTION: xdg_wm_base_destroy ( xdg_wm_base -- void )", "EXTERN: \"C\" void xdg_wm_base_destroy( void * xdg_wm_base );", "	( xdg_wm_base -- )" );
	swigFunction( "c-function xdg_wm_base_create_positioner xdg_wm_base_create_positioner a -- a", "FUNCTION: xdg_wm_base_create_positioner ( xdg_wm_base -- a )", "EXTERN: \"C\" void * xdg_wm_base_create_positioner( void * xdg_wm_base );", "	( xdg_wm_base -- )" );
	swigFunction( "c-function xdg_wm_base_get_xdg_surface xdg_wm_base_get_xdg_surface a a -- a", "FUNCTION: xdg_wm_base_get_xdg_surface ( xdg_wm_base surface -- a )", "EXTERN: \"C\" void * xdg_wm_base_get_xdg_surface( void * xdg_wm_base, void * surface );", "	( xdg_wm_base surface -- )" );
	swigFunction( "c-function xdg_wm_base_pong xdg_wm_base_pong a u -- void", "FUNCTION: xdg_wm_base_pong ( xdg_wm_base serial -- void )", "EXTERN: \"C\" void xdg_wm_base_pong( void * xdg_wm_base, int serial );", "	( xdg_wm_base serial -- )" );
	swigFunction( "c-function xdg_positioner_set_user_data xdg_positioner_set_user_data a a -- void", "FUNCTION: xdg_positioner_set_user_data ( xdg_positioner user_data -- void )", "EXTERN: \"C\" void xdg_positioner_set_user_data( void * xdg_positioner, void * user_data );", "	( xdg_positioner user_data -- )" );
	swigFunction( "c-function xdg_positioner_get_user_data xdg_positioner_get_user_data a -- a", "FUNCTION: xdg_positioner_get_user_data ( xdg_positioner -- a )", "EXTERN: \"C\" void * xdg_positioner_get_user_data( void * xdg_positioner );", "	( xdg_positioner -- )" );
	swigFunction( "c-function xdg_positioner_get_version xdg_positioner_get_version a -- u", "FUNCTION: xdg_positioner_get_version ( xdg_positioner -- u )", "EXTERN: \"C\" int xdg_positioner_get_version( void * xdg_positioner );", "	( xdg_positioner -- )" );
	swigFunction( "c-function xdg_positioner_destroy xdg_positioner_destroy a -- void", "FUNCTION: xdg_positioner_destroy ( xdg_positioner -- void )", "EXTERN: \"C\" void xdg_positioner_destroy( void * xdg_positioner );", "	( xdg_positioner -- )" );
	swigFunction( "c-function xdg_positioner_set_size xdg_positioner_set_size a n n -- void", "FUNCTION: xdg_positioner_set_size ( xdg_positioner width height -- void )", "EXTERN: \"C\" void xdg_positioner_set_size( void * xdg_positioner, int width, int height );", "	( xdg_positioner width height -- )" );
	swigFunction( "c-function xdg_positioner_set_anchor_rect xdg_positioner_set_anchor_rect a n n n n -- void", "FUNCTION: xdg_positioner_set_anchor_rect ( xdg_positioner x y width height -- void )", "EXTERN: \"C\" void xdg_positioner_set_anchor_rect( void * xdg_positioner, int x, int y, int width, int height );", "	( xdg_positioner x y width height -- )" );
	swigFunction( "c-function xdg_positioner_set_anchor xdg_positioner_set_anchor a u -- void", "FUNCTION: xdg_positioner_set_anchor ( xdg_positioner anchor -- void )", "EXTERN: \"C\" void xdg_positioner_set_anchor( void * xdg_positioner, int anchor );", "	( xdg_positioner anchor -- )" );
	swigFunction( "c-function xdg_positioner_set_gravity xdg_positioner_set_gravity a u -- void", "FUNCTION: xdg_positioner_set_gravity ( xdg_positioner gravity -- void )", "EXTERN: \"C\" void xdg_positioner_set_gravity( void * xdg_positioner, int gravity );", "	( xdg_positioner gravity -- )" );
	swigFunction( "c-function xdg_positioner_set_constraint_adjustment xdg_positioner_set_constraint_adjustment a u -- void", "FUNCTION: xdg_positioner_set_constraint_adjustment ( xdg_positioner constraint_adjustment -- void )", "EXTERN: \"C\" void xdg_positioner_set_constraint_adjustment( void * xdg_positioner, int constraint_adjustment );", "	( xdg_positioner constraint_adjustment -- )" );
	swigFunction( "c-function xdg_positioner_set_offset xdg_positioner_set_offset a n n -- void", "FUNCTION: xdg_positioner_set_offset ( xdg_positioner x y -- void )", "EXTERN: \"C\" void xdg_positioner_set_offset( void * xdg_positioner, int x, int y );", "	( xdg_positioner x y -- )" );
	swigFunction( "c-function xdg_positioner_set_reactive xdg_positioner_set_reactive a -- void", "FUNCTION: xdg_positioner_set_reactive ( xdg_positioner -- void )", "EXTERN: \"C\" void xdg_positioner_set_reactive( void * xdg_positioner );", "	( xdg_positioner -- )" );
	swigFunction( "c-function xdg_positioner_set_parent_size xdg_positioner_set_parent_size a n n -- void", "FUNCTION: xdg_positioner_set_parent_size ( xdg_positioner parent_width parent_height -- void )", "EXTERN: \"C\" void xdg_positioner_set_parent_size( void * xdg_positioner, int parent_width, int parent_height );", "	( xdg_positioner parent_width parent_height -- )" );
	swigFunction( "c-function xdg_positioner_set_parent_configure xdg_positioner_set_parent_configure a u -- void", "FUNCTION: xdg_positioner_set_parent_configure ( xdg_positioner serial -- void )", "EXTERN: \"C\" void xdg_positioner_set_parent_configure( void * xdg_positioner, int serial );", "	( xdg_positioner serial -- )" );
	swigFunction( "c-function xdg_surface_add_listener xdg_surface_add_listener a a a -- n", "FUNCTION: xdg_surface_add_listener ( xdg_surface listener data -- n )", "EXTERN: \"C\" int xdg_surface_add_listener( void * xdg_surface, void * listener, void * data );", "	( xdg_surface listener data -- )" );
	swigFunction( "c-function xdg_surface_set_user_data xdg_surface_set_user_data a a -- void", "FUNCTION: xdg_surface_set_user_data ( xdg_surface user_data -- void )", "EXTERN: \"C\" void xdg_surface_set_user_data( void * xdg_surface, void * user_data );", "	( xdg_surface user_data -- )" );
	swigFunction( "c-function xdg_surface_get_user_data xdg_surface_get_user_data a -- a", "FUNCTION: xdg_surface_get_user_data ( xdg_surface -- a )", "EXTERN: \"C\" void * xdg_surface_get_user_data( void * xdg_surface );", "	( xdg_surface -- )" );
	swigFunction( "c-function xdg_surface_get_version xdg_surface_get_version a -- u", "FUNCTION: xdg_surface_get_version ( xdg_surface -- u )", "EXTERN: \"C\" int xdg_surface_get_version( void * xdg_surface );", "	( xdg_surface -- )" );
	swigFunction( "c-function xdg_surface_destroy xdg_surface_destroy a -- void", "FUNCTION: xdg_surface_destroy ( xdg_surface -- void )", "EXTERN: \"C\" void xdg_surface_destroy( void * xdg_surface );", "	( xdg_surface -- )" );
	swigFunction( "c-function xdg_surface_get_toplevel xdg_surface_get_toplevel a -- a", "FUNCTION: xdg_surface_get_toplevel ( xdg_surface -- a )", "EXTERN: \"C\" void * xdg_surface_get_toplevel( void * xdg_surface );", "	( xdg_surface -- )" );
	swigFunction( "c-function xdg_surface_get_popup xdg_surface_get_popup a a a -- a", "FUNCTION: xdg_surface_get_popup ( xdg_surface parent positioner -- a )", "EXTERN: \"C\" void * xdg_surface_get_popup( void * xdg_surface, void * parent, void * positioner );", "	( xdg_surface parent positioner -- )" );
	swigFunction( "c-function xdg_surface_set_window_geometry xdg_surface_set_window_geometry a n n n n -- void", "FUNCTION: xdg_surface_set_window_geometry ( xdg_surface x y width height -- void )", "EXTERN: \"C\" void xdg_surface_set_window_geometry( void * xdg_surface, int x, int y, int width, int height );", "	( xdg_surface x y width height -- )" );
	swigFunction( "c-function xdg_surface_ack_configure xdg_surface_ack_configure a u -- void", "FUNCTION: xdg_surface_ack_configure ( xdg_surface serial -- void )", "EXTERN: \"C\" void xdg_surface_ack_configure( void * xdg_surface, int serial );", "	( xdg_surface serial -- )" );
	swigFunction( "c-function xdg_toplevel_add_listener xdg_toplevel_add_listener a a a -- n", "FUNCTION: xdg_toplevel_add_listener ( xdg_toplevel listener data -- n )", "EXTERN: \"C\" int xdg_toplevel_add_listener( void * xdg_toplevel, void * listener, void * data );", "	( xdg_toplevel listener data -- )" );
	swigFunction( "c-function xdg_toplevel_set_user_data xdg_toplevel_set_user_data a a -- void", "FUNCTION: xdg_toplevel_set_user_data ( xdg_toplevel user_data -- void )", "EXTERN: \"C\" void xdg_toplevel_set_user_data( void * xdg_toplevel, void * user_data );", "	( xdg_toplevel user_data -- )" );
	swigFunction( "c-function xdg_toplevel_get_user_data xdg_toplevel_get_user_data a -- a", "FUNCTION: xdg_toplevel_get_user_data ( xdg_toplevel -- a )", "EXTERN: \"C\" void * xdg_toplevel_get_user_data( void * xdg_toplevel );", "	( xdg_toplevel -- )" );
	swigFunction( "c-function xdg_toplevel_get_version xdg_toplevel_get_version a -- u", "FUNCTION: xdg_toplevel_get_version ( xdg_toplevel -- u )", "EXTERN: \"C\" int xdg_toplevel_get_version( void * xdg_toplevel );", "	( xdg_toplevel -- )" );
	swigFunction( "c-function xdg_toplevel_destroy xdg_toplevel_destroy a -- void", "FUNCTION: xdg_toplevel_destroy ( xdg_toplevel -- void )", "EXTERN: \"C\" void xdg_toplevel_destroy( void * xdg_toplevel );", "	( xdg_toplevel -- )" );
	swigFunction( "c-function xdg_toplevel_set_parent xdg_toplevel_set_parent a a -- void", "FUNCTION: xdg_toplevel_set_parent ( xdg_toplevel parent -- void )", "EXTERN: \"C\" void xdg_toplevel_set_parent( void * xdg_toplevel, void * parent );", "	( xdg_toplevel parent -- )" );
	swigFunction( "c-function xdg_toplevel_set_title xdg_toplevel_set_title a s -- void", "FUNCTION: xdg_toplevel_set_title ( xdg_toplevel title -- void )", "EXTERN: \"C\" void xdg_toplevel_set_title( void * xdg_toplevel, char * title );", "	( xdg_toplevel title -- )" );
	swigFunction( "c-function xdg_toplevel_set_app_id xdg_toplevel_set_app_id a s -- void", "FUNCTION: xdg_toplevel_set_app_id ( xdg_toplevel app_id -- void )", "EXTERN: \"C\" void xdg_toplevel_set_app_id( void * xdg_toplevel, char * app_id );", "	( xdg_toplevel app_id -- )" );
	swigFunction( "c-function xdg_toplevel_show_window_menu xdg_toplevel_show_window_menu a a u n n -- void", "FUNCTION: xdg_toplevel_show_window_menu ( xdg_toplevel seat serial x y -- void )", "EXTERN: \"C\" void xdg_toplevel_show_window_menu( void * xdg_toplevel, void * seat, int serial, int x, int y );", "	( xdg_toplevel seat serial x y -- )" );
	swigFunction( "c-function xdg_toplevel_move xdg_toplevel_move a a u -- void", "FUNCTION: xdg_toplevel_move ( xdg_toplevel seat serial -- void )", "EXTERN: \"C\" void xdg_toplevel_move( void * xdg_toplevel, void * seat, int serial );", "	( xdg_toplevel seat serial -- )" );
	swigFunction( "c-function xdg_toplevel_resize xdg_toplevel_resize a a u u -- void", "FUNCTION: xdg_toplevel_resize ( xdg_toplevel seat serial edges -- void )", "EXTERN: \"C\" void xdg_toplevel_resize( void * xdg_toplevel, void * seat, int serial, int edges );", "	( xdg_toplevel seat serial edges -- )" );
	swigFunction( "c-function xdg_toplevel_set_max_size xdg_toplevel_set_max_size a n n -- void", "FUNCTION: xdg_toplevel_set_max_size ( xdg_toplevel width height -- void )", "EXTERN: \"C\" void xdg_toplevel_set_max_size( void * xdg_toplevel, int width, int height );", "	( xdg_toplevel width height -- )" );
	swigFunction( "c-function xdg_toplevel_set_min_size xdg_toplevel_set_min_size a n n -- void", "FUNCTION: xdg_toplevel_set_min_size ( xdg_toplevel width height -- void )", "EXTERN: \"C\" void xdg_toplevel_set_min_size( void * xdg_toplevel, int width, int height );", "	( xdg_toplevel width height -- )" );
	swigFunction( "c-function xdg_toplevel_set_maximized xdg_toplevel_set_maximized a -- void", "FUNCTION: xdg_toplevel_set_maximized ( xdg_toplevel -- void )", "EXTERN: \"C\" void xdg_toplevel_set_maximized( void * xdg_toplevel );", "	( xdg_toplevel -- )" );
	swigFunction( "c-function xdg_toplevel_unset_maximized xdg_toplevel_unset_maximized a -- void", "FUNCTION: xdg_toplevel_unset_maximized ( xdg_toplevel -- void )", "EXTERN: \"C\" void xdg_toplevel_unset_maximized( void * xdg_toplevel );", "	( xdg_toplevel -- )" );
	swigFunction( "c-function xdg_toplevel_set_fullscreen xdg_toplevel_set_fullscreen a a -- void", "FUNCTION: xdg_toplevel_set_fullscreen ( xdg_toplevel output -- void )", "EXTERN: \"C\" void xdg_toplevel_set_fullscreen( void * xdg_toplevel, void * output );", "	( xdg_toplevel output -- )" );
	swigFunction( "c-function xdg_toplevel_unset_fullscreen xdg_toplevel_unset_fullscreen a -- void", "FUNCTION: xdg_toplevel_unset_fullscreen ( xdg_toplevel -- void )", "EXTERN: \"C\" void xdg_toplevel_unset_fullscreen( void * xdg_toplevel );", "	( xdg_toplevel -- )" );
	swigFunction( "c-function xdg_toplevel_set_minimized xdg_toplevel_set_minimized a -- void", "FUNCTION: xdg_toplevel_set_minimized ( xdg_toplevel -- void )", "EXTERN: \"C\" void xdg_toplevel_set_minimized( void * xdg_toplevel );", "	( xdg_toplevel -- )" );
	swigFunction( "c-function xdg_popup_add_listener xdg_popup_add_listener a a a -- n", "FUNCTION: xdg_popup_add_listener ( xdg_popup listener data -- n )", "EXTERN: \"C\" int xdg_popup_add_listener( void * xdg_popup, void * listener, void * data );", "	( xdg_popup listener data -- )" );
	swigFunction( "c-function xdg_popup_set_user_data xdg_popup_set_user_data a a -- void", "FUNCTION: xdg_popup_set_user_data ( xdg_popup user_data -- void )", "EXTERN: \"C\" void xdg_popup_set_user_data( void * xdg_popup, void * user_data );", "	( xdg_popup user_data -- )" );
	swigFunction( "c-function xdg_popup_get_user_data xdg_popup_get_user_data a -- a", "FUNCTION: xdg_popup_get_user_data ( xdg_popup -- a )", "EXTERN: \"C\" void * xdg_popup_get_user_data( void * xdg_popup );", "	( xdg_popup -- )" );
	swigFunction( "c-function xdg_popup_get_version xdg_popup_get_version a -- u", "FUNCTION: xdg_popup_get_version ( xdg_popup -- u )", "EXTERN: \"C\" int xdg_popup_get_version( void * xdg_popup );", "	( xdg_popup -- )" );
	swigFunction( "c-function xdg_popup_destroy xdg_popup_destroy a -- void", "FUNCTION: xdg_popup_destroy ( xdg_popup -- void )", "EXTERN: \"C\" void xdg_popup_destroy( void * xdg_popup );", "	( xdg_popup -- )" );
	swigFunction( "c-function xdg_popup_grab xdg_popup_grab a a u -- void", "FUNCTION: xdg_popup_grab ( xdg_popup seat serial -- void )", "EXTERN: \"C\" void xdg_popup_grab( void * xdg_popup, void * seat, int serial );", "	( xdg_popup seat serial -- )" );
	swigFunction( "c-function xdg_popup_reposition xdg_popup_reposition a a u -- void", "FUNCTION: xdg_popup_reposition ( xdg_popup positioner token -- void )", "EXTERN: \"C\" void xdg_popup_reposition( void * xdg_popup, void * positioner, int token );", "	( xdg_popup positioner token -- )" );
	swigFunction( "c-function zxdg_decoration_manager_v1_set_user_data zxdg_decoration_manager_v1_set_user_data a a -- void", "FUNCTION: zxdg_decoration_manager_v1_set_user_data ( zxdg_decoration_manager_v1 user_data -- void )", "EXTERN: \"C\" void zxdg_decoration_manager_v1_set_user_data( void * zxdg_decoration_manager_v1, void * user_data );", "	( zxdg_decoration_manager_v1 user_data -- )" );
	swigFunction( "c-function zxdg_decoration_manager_v1_get_user_data zxdg_decoration_manager_v1_get_user_data a -- a", "FUNCTION: zxdg_decoration_manager_v1_get_user_data ( zxdg_decoration_manager_v1 -- a )", "EXTERN: \"C\" void * zxdg_decoration_manager_v1_get_user_data( void * zxdg_decoration_manager_v1 );", "	( zxdg_decoration_manager_v1 -- )" );
	swigFunction( "c-function zxdg_decoration_manager_v1_get_version zxdg_decoration_manager_v1_get_version a -- u", "FUNCTION: zxdg_decoration_manager_v1_get_version ( zxdg_decoration_manager_v1 -- u )", "EXTERN: \"C\" int zxdg_decoration_manager_v1_get_version( void * zxdg_decoration_manager_v1 );", "	( zxdg_decoration_manager_v1 -- )" );
	swigFunction( "c-function zxdg_decoration_manager_v1_destroy zxdg_decoration_manager_v1_destroy a -- void", "FUNCTION: zxdg_decoration_manager_v1_destroy ( zxdg_decoration_manager_v1 -- void )", "EXTERN: \"C\" void zxdg_decoration_manager_v1_destroy( void * zxdg_decoration_manager_v1 );", "	( zxdg_decoration_manager_v1 -- )" );
	swigFunction( "c-function zxdg_decoration_manager_v1_get_toplevel_decoration zxdg_decoration_manager_v1_get_toplevel_decoration a a -- a", "FUNCTION: zxdg_decoration_manager_v1_get_toplevel_decoration ( zxdg_decoration_manager_v1 toplevel -- a )", "EXTERN: \"C\" void * zxdg_decoration_manager_v1_get_toplevel_decoration( void * zxdg_decoration_manager_v1, void * toplevel );", "	( zxdg_decoration_manager_v1 toplevel -- )" );
	swigFunction( "c-function zxdg_toplevel_decoration_v1_add_listener zxdg_toplevel_decoration_v1_add_listener a a a -- n", "FUNCTION: zxdg_toplevel_decoration_v1_add_listener ( zxdg_toplevel_decoration_v1 listener data -- n )", "EXTERN: \"C\" int zxdg_toplevel_decoration_v1_add_listener( void * zxdg_toplevel_decoration_v1, void * listener, void * data );", "	( zxdg_toplevel_decoration_v1 listener data -- )" );
	swigFunction( "c-function zxdg_toplevel_decoration_v1_set_user_data zxdg_toplevel_decoration_v1_set_user_data a a -- void", "FUNCTION: zxdg_toplevel_decoration_v1_set_user_data ( zxdg_toplevel_decoration_v1 user_data -- void )", "EXTERN: \"C\" void zxdg_toplevel_decoration_v1_set_user_data( void * zxdg_toplevel_decoration_v1, void * user_data );", "	( zxdg_toplevel_decoration_v1 user_data -- )" );
	swigFunction( "c-function zxdg_toplevel_decoration_v1_get_user_data zxdg_toplevel_decoration_v1_get_user_data a -- a", "FUNCTION: zxdg_toplevel_decoration_v1_get_user_data ( zxdg_toplevel_decoration_v1 -- a )", "EXTERN: \"C\" void * zxdg_toplevel_decoration_v1_get_user_data( void * zxdg_toplevel_decoration_v1 );", "	( zxdg_toplevel_decoration_v1 -- )" );
	swigFunction( "c-function zxdg_toplevel_decoration_v1_get_version zxdg_toplevel_decoration_v1_get_version a -- u", "FUNCTION: zxdg_toplevel_decoration_v1_get_version ( zxdg_toplevel_decoration_v1 -- u )", "EXTERN: \"C\" int zxdg_toplevel_decoration_v1_get_version( void * zxdg_toplevel_decoration_v1 );", "	( zxdg_toplevel_decoration_v1 -- )" );
	swigFunction( "c-function zxdg_toplevel_decoration_v1_destroy zxdg_toplevel_decoration_v1_destroy a -- void", "FUNCTION: zxdg_toplevel_decoration_v1_destroy ( zxdg_toplevel_decoration_v1 -- void )", "EXTERN: \"C\" void zxdg_toplevel_decoration_v1_destroy( void * zxdg_toplevel_decoration_v1 );", "	( zxdg_toplevel_decoration_v1 -- )" );
	swigFunction( "c-function zxdg_toplevel_decoration_v1_set_mode zxdg_toplevel_decoration_v1_set_mode a u -- void", "FUNCTION: zxdg_toplevel_decoration_v1_set_mode ( zxdg_toplevel_decoration_v1 mode -- void )", "EXTERN: \"C\" void zxdg_toplevel_decoration_v1_set_mode( void * zxdg_toplevel_decoration_v1, int mode );", "	( zxdg_toplevel_decoration_v1 mode -- )" );
	swigFunction( "c-function zxdg_toplevel_decoration_v1_unset_mode zxdg_toplevel_decoration_v1_unset_mode a -- void", "FUNCTION: zxdg_toplevel_decoration_v1_unset_mode ( zxdg_toplevel_decoration_v1 -- void )", "EXTERN: \"C\" void zxdg_toplevel_decoration_v1_unset_mode( void * zxdg_toplevel_decoration_v1 );", "	( zxdg_toplevel_decoration_v1 -- )" );
	swigFunction( "c-function zwp_primary_selection_device_manager_v1_set_user_data zwp_primary_selection_device_manager_v1_set_user_data a a -- void", "FUNCTION: zwp_primary_selection_device_manager_v1_set_user_data ( zwp_primary_selection_device_manager_v1 user_data -- void )", "EXTERN: \"C\" void zwp_primary_selection_device_manager_v1_set_user_data( void * zwp_primary_selection_device_manager_v1, void * user_data );", "	( zwp_primary_selection_device_manager_v1 user_data -- )" );
	swigFunction( "c-function zwp_primary_selection_device_manager_v1_get_user_data zwp_primary_selection_device_manager_v1_get_user_data a -- a", "FUNCTION: zwp_primary_selection_device_manager_v1_get_user_data ( zwp_primary_selection_device_manager_v1 -- a )", "EXTERN: \"C\" void * zwp_primary_selection_device_manager_v1_get_user_data( void * zwp_primary_selection_device_manager_v1 );", "	( zwp_primary_selection_device_manager_v1 -- )" );
	swigFunction( "c-function zwp_primary_selection_device_manager_v1_get_version zwp_primary_selection_device_manager_v1_get_version a -- u", "FUNCTION: zwp_primary_selection_device_manager_v1_get_version ( zwp_primary_selection_device_manager_v1 -- u )", "EXTERN: \"C\" int zwp_primary_selection_device_manager_v1_get_version( void * zwp_primary_selection_device_manager_v1 );", "	( zwp_primary_selection_device_manager_v1 -- )" );
	swigFunction( "c-function zwp_primary_selection_device_manager_v1_create_source zwp_primary_selection_device_manager_v1_create_source a -- a", "FUNCTION: zwp_primary_selection_device_manager_v1_create_source ( zwp_primary_selection_device_manager_v1 -- a )", "EXTERN: \"C\" void * zwp_primary_selection_device_manager_v1_create_source( void * zwp_primary_selection_device_manager_v1 );", "	( zwp_primary_selection_device_manager_v1 -- )" );
	swigFunction( "c-function zwp_primary_selection_device_manager_v1_get_device zwp_primary_selection_device_manager_v1_get_device a a -- a", "FUNCTION: zwp_primary_selection_device_manager_v1_get_device ( zwp_primary_selection_device_manager_v1 seat -- a )", "EXTERN: \"C\" void * zwp_primary_selection_device_manager_v1_get_device( void * zwp_primary_selection_device_manager_v1, void * seat );", "	( zwp_primary_selection_device_manager_v1 seat -- )" );
	swigFunction( "c-function zwp_primary_selection_device_manager_v1_destroy zwp_primary_selection_device_manager_v1_destroy a -- void", "FUNCTION: zwp_primary_selection_device_manager_v1_destroy ( zwp_primary_selection_device_manager_v1 -- void )", "EXTERN: \"C\" void zwp_primary_selection_device_manager_v1_destroy( void * zwp_primary_selection_device_manager_v1 );", "	( zwp_primary_selection_device_manager_v1 -- )" );
	swigFunction( "c-function zwp_primary_selection_device_v1_add_listener zwp_primary_selection_device_v1_add_listener a a a -- n", "FUNCTION: zwp_primary_selection_device_v1_add_listener ( zwp_primary_selection_device_v1 listener data -- n )", "EXTERN: \"C\" int zwp_primary_selection_device_v1_add_listener( void * zwp_primary_selection_device_v1, void * listener, void * data );", "	( zwp_primary_selection_device_v1 listener data -- )" );
	swigFunction( "c-function zwp_primary_selection_device_v1_set_user_data zwp_primary_selection_device_v1_set_user_data a a -- void", "FUNCTION: zwp_primary_selection_device_v1_set_user_data ( zwp_primary_selection_device_v1 user_data -- void )", "EXTERN: \"C\" void zwp_primary_selection_device_v1_set_user_data( void * zwp_primary_selection_device_v1, void * user_data );", "	( zwp_primary_selection_device_v1 user_data -- )" );
	swigFunction( "c-function zwp_primary_selection_device_v1_get_user_data zwp_primary_selection_device_v1_get_user_data a -- a", "FUNCTION: zwp_primary_selection_device_v1_get_user_data ( zwp_primary_selection_device_v1 -- a )", "EXTERN: \"C\" void * zwp_primary_selection_device_v1_get_user_data( void * zwp_primary_selection_device_v1 );", "	( zwp_primary_selection_device_v1 -- )" );
	swigFunction( "c-function zwp_primary_selection_device_v1_get_version zwp_primary_selection_device_v1_get_version a -- u", "FUNCTION: zwp_primary_selection_device_v1_get_version ( zwp_primary_selection_device_v1 -- u )", "EXTERN: \"C\" int zwp_primary_selection_device_v1_get_version( void * zwp_primary_selection_device_v1 );", "	( zwp_primary_selection_device_v1 -- )" );
	swigFunction( "c-function zwp_primary_selection_device_v1_set_selection zwp_primary_selection_device_v1_set_selection a a u -- void", "FUNCTION: zwp_primary_selection_device_v1_set_selection ( zwp_primary_selection_device_v1 source serial -- void )", "EXTERN: \"C\" void zwp_primary_selection_device_v1_set_selection( void * zwp_primary_selection_device_v1, void * source, int serial );", "	( zwp_primary_selection_device_v1 source serial -- )" );
	swigFunction( "c-function zwp_primary_selection_device_v1_destroy zwp_primary_selection_device_v1_destroy a -- void", "FUNCTION: zwp_primary_selection_device_v1_destroy ( zwp_primary_selection_device_v1 -- void )", "EXTERN: \"C\" void zwp_primary_selection_device_v1_destroy( void * zwp_primary_selection_device_v1 );", "	( zwp_primary_selection_device_v1 -- )" );
	swigFunction( "c-function zwp_primary_selection_offer_v1_add_listener zwp_primary_selection_offer_v1_add_listener a a a -- n", "FUNCTION: zwp_primary_selection_offer_v1_add_listener ( zwp_primary_selection_offer_v1 listener data -- n )", "EXTERN: \"C\" int zwp_primary_selection_offer_v1_add_listener( void * zwp_primary_selection_offer_v1, void * listener, void * data );", "	( zwp_primary_selection_offer_v1 listener data -- )" );
	swigFunction( "c-function zwp_primary_selection_offer_v1_set_user_data zwp_primary_selection_offer_v1_set_user_data a a -- void", "FUNCTION: zwp_primary_selection_offer_v1_set_user_data ( zwp_primary_selection_offer_v1 user_data -- void )", "EXTERN: \"C\" void zwp_primary_selection_offer_v1_set_user_data( void * zwp_primary_selection_offer_v1, void * user_data );", "	( zwp_primary_selection_offer_v1 user_data -- )" );
	swigFunction( "c-function zwp_primary_selection_offer_v1_get_user_data zwp_primary_selection_offer_v1_get_user_data a -- a", "FUNCTION: zwp_primary_selection_offer_v1_get_user_data ( zwp_primary_selection_offer_v1 -- a )", "EXTERN: \"C\" void * zwp_primary_selection_offer_v1_get_user_data( void * zwp_primary_selection_offer_v1 );", "	( zwp_primary_selection_offer_v1 -- )" );
	swigFunction( "c-function zwp_primary_selection_offer_v1_get_version zwp_primary_selection_offer_v1_get_version a -- u", "FUNCTION: zwp_primary_selection_offer_v1_get_version ( zwp_primary_selection_offer_v1 -- u )", "EXTERN: \"C\" int zwp_primary_selection_offer_v1_get_version( void * zwp_primary_selection_offer_v1 );", "	( zwp_primary_selection_offer_v1 -- )" );
	swigFunction( "c-function zwp_primary_selection_offer_v1_receive zwp_primary_selection_offer_v1_receive a s n -- void", "FUNCTION: zwp_primary_selection_offer_v1_receive ( zwp_primary_selection_offer_v1 mime_type fd -- void )", "EXTERN: \"C\" void zwp_primary_selection_offer_v1_receive( void * zwp_primary_selection_offer_v1, char * mime_type, int fd );", "	( zwp_primary_selection_offer_v1 mime_type fd -- )" );
	swigFunction( "c-function zwp_primary_selection_offer_v1_destroy zwp_primary_selection_offer_v1_destroy a -- void", "FUNCTION: zwp_primary_selection_offer_v1_destroy ( zwp_primary_selection_offer_v1 -- void )", "EXTERN: \"C\" void zwp_primary_selection_offer_v1_destroy( void * zwp_primary_selection_offer_v1 );", "	( zwp_primary_selection_offer_v1 -- )" );
	swigFunction( "c-function zwp_primary_selection_source_v1_add_listener zwp_primary_selection_source_v1_add_listener a a a -- n", "FUNCTION: zwp_primary_selection_source_v1_add_listener ( zwp_primary_selection_source_v1 listener data -- n )", "EXTERN: \"C\" int zwp_primary_selection_source_v1_add_listener( void * zwp_primary_selection_source_v1, void * listener, void * data );", "	( zwp_primary_selection_source_v1 listener data -- )" );
	swigFunction( "c-function zwp_primary_selection_source_v1_set_user_data zwp_primary_selection_source_v1_set_user_data a a -- void", "FUNCTION: zwp_primary_selection_source_v1_set_user_data ( zwp_primary_selection_source_v1 user_data -- void )", "EXTERN: \"C\" void zwp_primary_selection_source_v1_set_user_data( void * zwp_primary_selection_source_v1, void * user_data );", "	( zwp_primary_selection_source_v1 user_data -- )" );
	swigFunction( "c-function zwp_primary_selection_source_v1_get_user_data zwp_primary_selection_source_v1_get_user_data a -- a", "FUNCTION: zwp_primary_selection_source_v1_get_user_data ( zwp_primary_selection_source_v1 -- a )", "EXTERN: \"C\" void * zwp_primary_selection_source_v1_get_user_data( void * zwp_primary_selection_source_v1 );", "	( zwp_primary_selection_source_v1 -- )" );
	swigFunction( "c-function zwp_primary_selection_source_v1_get_version zwp_primary_selection_source_v1_get_version a -- u", "FUNCTION: zwp_primary_selection_source_v1_get_version ( zwp_primary_selection_source_v1 -- u )", "EXTERN: \"C\" int zwp_primary_selection_source_v1_get_version( void * zwp_primary_selection_source_v1 );", "	( zwp_primary_selection_source_v1 -- )" );
	swigFunction( "c-function zwp_primary_selection_source_v1_offer zwp_primary_selection_source_v1_offer a s -- void", "FUNCTION: zwp_primary_selection_source_v1_offer ( zwp_primary_selection_source_v1 mime_type -- void )", "EXTERN: \"C\" void zwp_primary_selection_source_v1_offer( void * zwp_primary_selection_source_v1, char * mime_type );", "	( zwp_primary_selection_source_v1 mime_type -- )" );
	swigFunction( "c-function zwp_primary_selection_source_v1_destroy zwp_primary_selection_source_v1_destroy a -- void", "FUNCTION: zwp_primary_selection_source_v1_destroy ( zwp_primary_selection_source_v1 -- void )", "EXTERN: \"C\" void zwp_primary_selection_source_v1_destroy( void * zwp_primary_selection_source_v1 );", "	( zwp_primary_selection_source_v1 -- )" );
	swigFunction( "c-function zwp_tablet_manager_v2_set_user_data zwp_tablet_manager_v2_set_user_data a a -- void", "FUNCTION: zwp_tablet_manager_v2_set_user_data ( zwp_tablet_manager_v2 user_data -- void )", "EXTERN: \"C\" void zwp_tablet_manager_v2_set_user_data( void * zwp_tablet_manager_v2, void * user_data );", "	( zwp_tablet_manager_v2 user_data -- )" );
	swigFunction( "c-function zwp_tablet_manager_v2_get_user_data zwp_tablet_manager_v2_get_user_data a -- a", "FUNCTION: zwp_tablet_manager_v2_get_user_data ( zwp_tablet_manager_v2 -- a )", "EXTERN: \"C\" void * zwp_tablet_manager_v2_get_user_data( void * zwp_tablet_manager_v2 );", "	( zwp_tablet_manager_v2 -- )" );
	swigFunction( "c-function zwp_tablet_manager_v2_get_version zwp_tablet_manager_v2_get_version a -- u", "FUNCTION: zwp_tablet_manager_v2_get_version ( zwp_tablet_manager_v2 -- u )", "EXTERN: \"C\" int zwp_tablet_manager_v2_get_version( void * zwp_tablet_manager_v2 );", "	( zwp_tablet_manager_v2 -- )" );
	swigFunction( "c-function zwp_tablet_manager_v2_get_tablet_seat zwp_tablet_manager_v2_get_tablet_seat a a -- a", "FUNCTION: zwp_tablet_manager_v2_get_tablet_seat ( zwp_tablet_manager_v2 seat -- a )", "EXTERN: \"C\" void * zwp_tablet_manager_v2_get_tablet_seat( void * zwp_tablet_manager_v2, void * seat );", "	( zwp_tablet_manager_v2 seat -- )" );
	swigFunction( "c-function zwp_tablet_manager_v2_destroy zwp_tablet_manager_v2_destroy a -- void", "FUNCTION: zwp_tablet_manager_v2_destroy ( zwp_tablet_manager_v2 -- void )", "EXTERN: \"C\" void zwp_tablet_manager_v2_destroy( void * zwp_tablet_manager_v2 );", "	( zwp_tablet_manager_v2 -- )" );
	swigFunction( "c-function zwp_tablet_seat_v2_add_listener zwp_tablet_seat_v2_add_listener a a a -- n", "FUNCTION: zwp_tablet_seat_v2_add_listener ( zwp_tablet_seat_v2 listener data -- n )", "EXTERN: \"C\" int zwp_tablet_seat_v2_add_listener( void * zwp_tablet_seat_v2, void * listener, void * data );", "	( zwp_tablet_seat_v2 listener data -- )" );
	swigFunction( "c-function zwp_tablet_seat_v2_set_user_data zwp_tablet_seat_v2_set_user_data a a -- void", "FUNCTION: zwp_tablet_seat_v2_set_user_data ( zwp_tablet_seat_v2 user_data -- void )", "EXTERN: \"C\" void zwp_tablet_seat_v2_set_user_data( void * zwp_tablet_seat_v2, void * user_data );", "	( zwp_tablet_seat_v2 user_data -- )" );
	swigFunction( "c-function zwp_tablet_seat_v2_get_user_data zwp_tablet_seat_v2_get_user_data a -- a", "FUNCTION: zwp_tablet_seat_v2_get_user_data ( zwp_tablet_seat_v2 -- a )", "EXTERN: \"C\" void * zwp_tablet_seat_v2_get_user_data( void * zwp_tablet_seat_v2 );", "	( zwp_tablet_seat_v2 -- )" );
	swigFunction( "c-function zwp_tablet_seat_v2_get_version zwp_tablet_seat_v2_get_version a -- u", "FUNCTION: zwp_tablet_seat_v2_get_version ( zwp_tablet_seat_v2 -- u )", "EXTERN: \"C\" int zwp_tablet_seat_v2_get_version( void * zwp_tablet_seat_v2 );", "	( zwp_tablet_seat_v2 -- )" );
	swigFunction( "c-function zwp_tablet_seat_v2_destroy zwp_tablet_seat_v2_destroy a -- void", "FUNCTION: zwp_tablet_seat_v2_destroy ( zwp_tablet_seat_v2 -- void )", "EXTERN: \"C\" void zwp_tablet_seat_v2_destroy( void * zwp_tablet_seat_v2 );", "	( zwp_tablet_seat_v2 -- )" );
	swigFunction( "c-function zwp_tablet_tool_v2_add_listener zwp_tablet_tool_v2_add_listener a a a -- n", "FUNCTION: zwp_tablet_tool_v2_add_listener ( zwp_tablet_tool_v2 listener data -- n )", "EXTERN: \"C\" int zwp_tablet_tool_v2_add_listener( void * zwp_tablet_tool_v2, void * listener, void * data );", "	( zwp_tablet_tool_v2 listener data -- )" );
	swigFunction( "c-function zwp_tablet_tool_v2_set_user_data zwp_tablet_tool_v2_set_user_data a a -- void", "FUNCTION: zwp_tablet_tool_v2_set_user_data ( zwp_tablet_tool_v2 user_data -- void )", "EXTERN: \"C\" void zwp_tablet_tool_v2_set_user_data( void * zwp_tablet_tool_v2, void * user_data );", "	( zwp_tablet_tool_v2 user_data -- )" );
	swigFunction( "c-function zwp_tablet_tool_v2_get_user_data zwp_tablet_tool_v2_get_user_data a -- a", "FUNCTION: zwp_tablet_tool_v2_get_user_data ( zwp_tablet_tool_v2 -- a )", "EXTERN: \"C\" void * zwp_tablet_tool_v2_get_user_data( void * zwp_tablet_tool_v2 );", "	( zwp_tablet_tool_v2 -- )" );
	swigFunction( "c-function zwp_tablet_tool_v2_get_version zwp_tablet_tool_v2_get_version a -- u", "FUNCTION: zwp_tablet_tool_v2_get_version ( zwp_tablet_tool_v2 -- u )", "EXTERN: \"C\" int zwp_tablet_tool_v2_get_version( void * zwp_tablet_tool_v2 );", "	( zwp_tablet_tool_v2 -- )" );
	swigFunction( "c-function zwp_tablet_tool_v2_set_cursor zwp_tablet_tool_v2_set_cursor a u a n n -- void", "FUNCTION: zwp_tablet_tool_v2_set_cursor ( zwp_tablet_tool_v2 serial surface hotspot_x hotspot_y -- void )", "EXTERN: \"C\" void zwp_tablet_tool_v2_set_cursor( void * zwp_tablet_tool_v2, int serial, void * surface, int hotspot_x, int hotspot_y );", "	( zwp_tablet_tool_v2 serial surface hotspot_x hotspot_y -- )" );
	swigFunction( "c-function zwp_tablet_tool_v2_destroy zwp_tablet_tool_v2_destroy a -- void", "FUNCTION: zwp_tablet_tool_v2_destroy ( zwp_tablet_tool_v2 -- void )", "EXTERN: \"C\" void zwp_tablet_tool_v2_destroy( void * zwp_tablet_tool_v2 );", "	( zwp_tablet_tool_v2 -- )" );
	swigFunction( "c-function zwp_tablet_v2_add_listener zwp_tablet_v2_add_listener a a a -- n", "FUNCTION: zwp_tablet_v2_add_listener ( zwp_tablet_v2 listener data -- n )", "EXTERN: \"C\" int zwp_tablet_v2_add_listener( void * zwp_tablet_v2, void * listener, void * data );", "	( zwp_tablet_v2 listener data -- )" );
	swigFunction( "c-function zwp_tablet_v2_set_user_data zwp_tablet_v2_set_user_data a a -- void", "FUNCTION: zwp_tablet_v2_set_user_data ( zwp_tablet_v2 user_data -- void )", "EXTERN: \"C\" void zwp_tablet_v2_set_user_data( void * zwp_tablet_v2, void * user_data );", "	( zwp_tablet_v2 user_data -- )" );
	swigFunction( "c-function zwp_tablet_v2_get_user_data zwp_tablet_v2_get_user_data a -- a", "FUNCTION: zwp_tablet_v2_get_user_data ( zwp_tablet_v2 -- a )", "EXTERN: \"C\" void * zwp_tablet_v2_get_user_data( void * zwp_tablet_v2 );", "	( zwp_tablet_v2 -- )" );
	swigFunction( "c-function zwp_tablet_v2_get_version zwp_tablet_v2_get_version a -- u", "FUNCTION: zwp_tablet_v2_get_version ( zwp_tablet_v2 -- u )", "EXTERN: \"C\" int zwp_tablet_v2_get_version( void * zwp_tablet_v2 );", "	( zwp_tablet_v2 -- )" );
	swigFunction( "c-function zwp_tablet_v2_destroy zwp_tablet_v2_destroy a -- void", "FUNCTION: zwp_tablet_v2_destroy ( zwp_tablet_v2 -- void )", "EXTERN: \"C\" void zwp_tablet_v2_destroy( void * zwp_tablet_v2 );", "	( zwp_tablet_v2 -- )" );
	swigFunction( "c-function zwp_tablet_pad_ring_v2_add_listener zwp_tablet_pad_ring_v2_add_listener a a a -- n", "FUNCTION: zwp_tablet_pad_ring_v2_add_listener ( zwp_tablet_pad_ring_v2 listener data -- n )", "EXTERN: \"C\" int zwp_tablet_pad_ring_v2_add_listener( void * zwp_tablet_pad_ring_v2, void * listener, void * data );", "	( zwp_tablet_pad_ring_v2 listener data -- )" );
	swigFunction( "c-function zwp_tablet_pad_ring_v2_set_user_data zwp_tablet_pad_ring_v2_set_user_data a a -- void", "FUNCTION: zwp_tablet_pad_ring_v2_set_user_data ( zwp_tablet_pad_ring_v2 user_data -- void )", "EXTERN: \"C\" void zwp_tablet_pad_ring_v2_set_user_data( void * zwp_tablet_pad_ring_v2, void * user_data );", "	( zwp_tablet_pad_ring_v2 user_data -- )" );
	swigFunction( "c-function zwp_tablet_pad_ring_v2_get_user_data zwp_tablet_pad_ring_v2_get_user_data a -- a", "FUNCTION: zwp_tablet_pad_ring_v2_get_user_data ( zwp_tablet_pad_ring_v2 -- a )", "EXTERN: \"C\" void * zwp_tablet_pad_ring_v2_get_user_data( void * zwp_tablet_pad_ring_v2 );", "	( zwp_tablet_pad_ring_v2 -- )" );
	swigFunction( "c-function zwp_tablet_pad_ring_v2_get_version zwp_tablet_pad_ring_v2_get_version a -- u", "FUNCTION: zwp_tablet_pad_ring_v2_get_version ( zwp_tablet_pad_ring_v2 -- u )", "EXTERN: \"C\" int zwp_tablet_pad_ring_v2_get_version( void * zwp_tablet_pad_ring_v2 );", "	( zwp_tablet_pad_ring_v2 -- )" );
	swigFunction( "c-function zwp_tablet_pad_ring_v2_set_feedback zwp_tablet_pad_ring_v2_set_feedback a s u -- void", "FUNCTION: zwp_tablet_pad_ring_v2_set_feedback ( zwp_tablet_pad_ring_v2 description serial -- void )", "EXTERN: \"C\" void zwp_tablet_pad_ring_v2_set_feedback( void * zwp_tablet_pad_ring_v2, char * description, int serial );", "	( zwp_tablet_pad_ring_v2 description serial -- )" );
	swigFunction( "c-function zwp_tablet_pad_ring_v2_destroy zwp_tablet_pad_ring_v2_destroy a -- void", "FUNCTION: zwp_tablet_pad_ring_v2_destroy ( zwp_tablet_pad_ring_v2 -- void )", "EXTERN: \"C\" void zwp_tablet_pad_ring_v2_destroy( void * zwp_tablet_pad_ring_v2 );", "	( zwp_tablet_pad_ring_v2 -- )" );
	swigFunction( "c-function zwp_tablet_pad_strip_v2_add_listener zwp_tablet_pad_strip_v2_add_listener a a a -- n", "FUNCTION: zwp_tablet_pad_strip_v2_add_listener ( zwp_tablet_pad_strip_v2 listener data -- n )", "EXTERN: \"C\" int zwp_tablet_pad_strip_v2_add_listener( void * zwp_tablet_pad_strip_v2, void * listener, void * data );", "	( zwp_tablet_pad_strip_v2 listener data -- )" );
	swigFunction( "c-function zwp_tablet_pad_strip_v2_set_user_data zwp_tablet_pad_strip_v2_set_user_data a a -- void", "FUNCTION: zwp_tablet_pad_strip_v2_set_user_data ( zwp_tablet_pad_strip_v2 user_data -- void )", "EXTERN: \"C\" void zwp_tablet_pad_strip_v2_set_user_data( void * zwp_tablet_pad_strip_v2, void * user_data );", "	( zwp_tablet_pad_strip_v2 user_data -- )" );
	swigFunction( "c-function zwp_tablet_pad_strip_v2_get_user_data zwp_tablet_pad_strip_v2_get_user_data a -- a", "FUNCTION: zwp_tablet_pad_strip_v2_get_user_data ( zwp_tablet_pad_strip_v2 -- a )", "EXTERN: \"C\" void * zwp_tablet_pad_strip_v2_get_user_data( void * zwp_tablet_pad_strip_v2 );", "	( zwp_tablet_pad_strip_v2 -- )" );
	swigFunction( "c-function zwp_tablet_pad_strip_v2_get_version zwp_tablet_pad_strip_v2_get_version a -- u", "FUNCTION: zwp_tablet_pad_strip_v2_get_version ( zwp_tablet_pad_strip_v2 -- u )", "EXTERN: \"C\" int zwp_tablet_pad_strip_v2_get_version( void * zwp_tablet_pad_strip_v2 );", "	( zwp_tablet_pad_strip_v2 -- )" );
	swigFunction( "c-function zwp_tablet_pad_strip_v2_set_feedback zwp_tablet_pad_strip_v2_set_feedback a s u -- void", "FUNCTION: zwp_tablet_pad_strip_v2_set_feedback ( zwp_tablet_pad_strip_v2 description serial -- void )", "EXTERN: \"C\" void zwp_tablet_pad_strip_v2_set_feedback( void * zwp_tablet_pad_strip_v2, char * description, int serial );", "	( zwp_tablet_pad_strip_v2 description serial -- )" );
	swigFunction( "c-function zwp_tablet_pad_strip_v2_destroy zwp_tablet_pad_strip_v2_destroy a -- void", "FUNCTION: zwp_tablet_pad_strip_v2_destroy ( zwp_tablet_pad_strip_v2 -- void )", "EXTERN: \"C\" void zwp_tablet_pad_strip_v2_destroy( void * zwp_tablet_pad_strip_v2 );", "	( zwp_tablet_pad_strip_v2 -- )" );
	swigFunction( "c-function zwp_tablet_pad_group_v2_add_listener zwp_tablet_pad_group_v2_add_listener a a a -- n", "FUNCTION: zwp_tablet_pad_group_v2_add_listener ( zwp_tablet_pad_group_v2 listener data -- n )", "EXTERN: \"C\" int zwp_tablet_pad_group_v2_add_listener( void * zwp_tablet_pad_group_v2, void * listener, void * data );", "	( zwp_tablet_pad_group_v2 listener data -- )" );
	swigFunction( "c-function zwp_tablet_pad_group_v2_set_user_data zwp_tablet_pad_group_v2_set_user_data a a -- void", "FUNCTION: zwp_tablet_pad_group_v2_set_user_data ( zwp_tablet_pad_group_v2 user_data -- void )", "EXTERN: \"C\" void zwp_tablet_pad_group_v2_set_user_data( void * zwp_tablet_pad_group_v2, void * user_data );", "	( zwp_tablet_pad_group_v2 user_data -- )" );
	swigFunction( "c-function zwp_tablet_pad_group_v2_get_user_data zwp_tablet_pad_group_v2_get_user_data a -- a", "FUNCTION: zwp_tablet_pad_group_v2_get_user_data ( zwp_tablet_pad_group_v2 -- a )", "EXTERN: \"C\" void * zwp_tablet_pad_group_v2_get_user_data( void * zwp_tablet_pad_group_v2 );", "	( zwp_tablet_pad_group_v2 -- )" );
	swigFunction( "c-function zwp_tablet_pad_group_v2_get_version zwp_tablet_pad_group_v2_get_version a -- u", "FUNCTION: zwp_tablet_pad_group_v2_get_version ( zwp_tablet_pad_group_v2 -- u )", "EXTERN: \"C\" int zwp_tablet_pad_group_v2_get_version( void * zwp_tablet_pad_group_v2 );", "	( zwp_tablet_pad_group_v2 -- )" );
	swigFunction( "c-function zwp_tablet_pad_group_v2_destroy zwp_tablet_pad_group_v2_destroy a -- void", "FUNCTION: zwp_tablet_pad_group_v2_destroy ( zwp_tablet_pad_group_v2 -- void )", "EXTERN: \"C\" void zwp_tablet_pad_group_v2_destroy( void * zwp_tablet_pad_group_v2 );", "	( zwp_tablet_pad_group_v2 -- )" );
	swigFunction( "c-function zwp_tablet_pad_v2_add_listener zwp_tablet_pad_v2_add_listener a a a -- n", "FUNCTION: zwp_tablet_pad_v2_add_listener ( zwp_tablet_pad_v2 listener data -- n )", "EXTERN: \"C\" int zwp_tablet_pad_v2_add_listener( void * zwp_tablet_pad_v2, void * listener, void * data );", "	( zwp_tablet_pad_v2 listener data -- )" );
	swigFunction( "c-function zwp_tablet_pad_v2_set_user_data zwp_tablet_pad_v2_set_user_data a a -- void", "FUNCTION: zwp_tablet_pad_v2_set_user_data ( zwp_tablet_pad_v2 user_data -- void )", "EXTERN: \"C\" void zwp_tablet_pad_v2_set_user_data( void * zwp_tablet_pad_v2, void * user_data );", "	( zwp_tablet_pad_v2 user_data -- )" );
	swigFunction( "c-function zwp_tablet_pad_v2_get_user_data zwp_tablet_pad_v2_get_user_data a -- a", "FUNCTION: zwp_tablet_pad_v2_get_user_data ( zwp_tablet_pad_v2 -- a )", "EXTERN: \"C\" void * zwp_tablet_pad_v2_get_user_data( void * zwp_tablet_pad_v2 );", "	( zwp_tablet_pad_v2 -- )" );
	swigFunction( "c-function zwp_tablet_pad_v2_get_version zwp_tablet_pad_v2_get_version a -- u", "FUNCTION: zwp_tablet_pad_v2_get_version ( zwp_tablet_pad_v2 -- u )", "EXTERN: \"C\" int zwp_tablet_pad_v2_get_version( void * zwp_tablet_pad_v2 );", "	( zwp_tablet_pad_v2 -- )" );
	swigFunction( "c-function zwp_tablet_pad_v2_set_feedback zwp_tablet_pad_v2_set_feedback a u s u -- void", "FUNCTION: zwp_tablet_pad_v2_set_feedback ( zwp_tablet_pad_v2 button description serial -- void )", "EXTERN: \"C\" void zwp_tablet_pad_v2_set_feedback( void * zwp_tablet_pad_v2, int button, char * description, int serial );", "	( zwp_tablet_pad_v2 button description serial -- )" );
	swigFunction( "c-function zwp_tablet_pad_v2_destroy zwp_tablet_pad_v2_destroy a -- void", "FUNCTION: zwp_tablet_pad_v2_destroy ( zwp_tablet_pad_v2 -- void )", "EXTERN: \"C\" void zwp_tablet_pad_v2_destroy( void * zwp_tablet_pad_v2 );", "	( zwp_tablet_pad_v2 -- )" );

	swigNewline();

	swigComment("----===< postfix >===-----\n");

	swigPrint( "end-c-library", "( none )", "( none )" );
	
	return 0;
} /* end of main */



