/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 3.0.9
 *
 * This file is not intended to be easily readable and contains a number of
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG
 * interface file instead.
 * ----------------------------------------------------------------------------- */
#include <stdio.h>
#include <string.h>
#include <stddef.h>
#include <math.h> /* required for special case floating point output */

// Do not edit below this line
// end-of-default-includes


#include <pipewire/pipewire.h>
#include <spa/pod/pod.h>
#include <spa/pod/builder.h>
#include <spa/pod/parser.h>
#include <spa/param/format.h>
#include <spa/param/audio/format.h>
#include <spa/param/audio/raw-utils.h>
#include <spa/param/audio/ape-utils.h>
#include <spa/param/audio/format-utils.h>
#include <spa/param/video/format.h>
#include <spa/param/video/format-utils.h>
#include <spa/utils/result.h>
#include <spa/param/props.h>

typedef enum{ NONE = -1, GFORTH = 0, SWIFTFORTH, VFX } SwigTargetSystem;
SwigTargetSystem swigTargetSystem = NONE;

unsigned char swigPrintStackComments = 1;

/* comments */
void swigNewline()
{
	printf( "\n" );
}

void swigComment( char *comment )
{
	printf( "\\ %s", comment );
}

/* generic print */
void swigPrint( char* gforth, char *swiftForth, char *vfx )
{
	if( swigTargetSystem == GFORTH )
		printf( "%s", gforth );
	else if( swigTargetSystem == SWIFTFORTH )
		printf( "%s", swiftForth );
	else if( swigTargetSystem == VFX )
		printf( "%s", vfx );
	printf( "\n" );
}
void swigPrintSystem( SwigTargetSystem targetSystem, char *text )
{
	if( targetSystem == swigTargetSystem )
	    printf( "%s\n", text );
}

/* constants */
void swigIntConstant( long constant, char *name )
{
	printf( "#%ld\tconstant %s\n", constant, name );
}

void swigUnsignedIntConstant( unsigned long constant, char *name )
{
	printf( "#%lu\tconstant %s\n", constant, name );
}

void swigLongConstant( long long constant, char *name )
{
	printf( "#%lld.\t2constant %s\n", constant, name );
}

void swigUnsignedLongConstant( unsigned long long constant, char *name )
{
	printf( "#%llu.\t2constant %s\n", constant, name );
}

void swigFloatConstant( double constant, char *name )
{
	char buffer[128];
	sprintf( buffer, "%f", constant );

	/* if the constant contains no exponent, add one */
	char *s;
	for( s = buffer; *s != 0; s++ )
		if( *s == 'e' || *s == 'E' )
			break;

	/* exponent found */
	if( *s != 0 )
		printf( "%s\tfconstant %s\n", buffer, name );
	/* no exponent */
	else {
		/* special class? */
		int class = fpclassify( constant );
		if( class == FP_INFINITE )
			printf( "%sInf\tfconstant %s\n", constant < 0.0f ? "-" : "+", name );
		else if( class == FP_NAN )
			printf( "NaN\tfconstant %s\n", name );
		else
			/* treat as generic float */
			printf( "%se0\tfconstant %s\n", buffer, name );
        }
}

void swigStringConstant( char* constant, char *name )
{
	char c;
	printf( ": %s s\\\" ", name );
	while(( c = *constant++ ))
	{
		switch(c)
		{
			case '\b': printf( "\\b" ); break;
			case '\n': printf( "\\n" ); break;
			case '\f': printf( "\\f" ); break;
			case '\r': printf( "\\r" ); break;
			case '\t': printf( "\\t" ); break;
			case '"' : printf( "\\q" ); break;
			default:
				if(c < 0x20)
					printf("\\x%02x", c);
				else
					printf("%c", c); break;
		}
	}
	printf(	"\" ;\n" );
}

/* structs */
void swigStructField( char *name, size_t offset, size_t size )
{
	printf( "\tdrop %zu %zu +field %s\n", offset, size, name );
}

/* functions */
void swigFunction( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	if( swigTargetSystem == GFORTH )
		printf( "%s", gforth );
	else if( swigTargetSystem == SWIFTFORTH )
		printf( "%s", swiftForth );
	else if( swigTargetSystem == VFX )
		printf( "%s", vfx );

	if( swigPrintStackComments )
		printf( "%s", stackComment );

	printf( "\n" );
}

/* function pointers */
void swigFunctionPointer( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	swigFunction( gforth, swiftForth, vfx, stackComment );
}

/* callbacks */
void swigCallback( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	swigFunction( gforth, swiftForth, vfx, stackComment );
}

void swigUsage( char **argv )
{
	fprintf( stderr, "Usage: %s [-gforth|-swiftforth|-vfx]\n", argv[0] );
}

int main( int argc, char **argv )
{
	int i;

	/* check arguments */
	for( i = 1; i < argc; i++ )
		if( strcmp( argv[i], "-gforth" ) == 0 )
			swigTargetSystem = GFORTH;
		else if( strcmp( argv[i], "-swiftforth" ) == 0 )
			swigTargetSystem = SWIFTFORTH;
		else if( strcmp( argv[i], "-vfx" ) == 0 )
			swigTargetSystem = VFX;

	if( swigTargetSystem == NONE )
	{
		fprintf( stderr, "Error: no target system specified\n" );
		swigUsage( argv );
		return 1;
	}

	/* primer */
	printf( "\\ This file has been generated using SWIG and fsi,\n"
		"\\ and is already platform dependent, search for the corresponding\n"
		"\\ fsi-file to compile it where no one has compiled it before ;)\n"
		"\\ Forth systems have their own own dynamic loader and don't need addional C-Code.\n"
		"\\ That's why this file will just print normal forth-code once compiled\n"
		"\\ and can be used directly with include or require.\n"
		"\\ As all comments are stripped during the compilation, please\n"
		"\\ insert the copyright notice of the original file here.\n"
	);


typedef union {
  struct spa_audio_info_raw raw;
  struct spa_audio_info_dsp dsp;
  struct spa_audio_info_iec958 iec958;
  struct spa_audio_info_dsd dsd;
  struct spa_audio_info_mp3 mp3;
  struct spa_audio_info_aac aac;
  struct spa_audio_info_vorbis vorbis;
  struct spa_audio_info_wma wma;
  struct spa_audio_info_ra ra;
  struct spa_audio_info_amr amr;
  struct spa_audio_info_alac alac;
  struct spa_audio_info_flac flac;
  struct spa_audio_info_ape ape;
  struct spa_audio_info_ape opus;
} spa_audio_info_info;

typedef union {
  struct spa_video_info_raw raw;
  struct spa_video_info_dsp dsp;
  struct spa_video_info_h264 h264;
  struct spa_video_info_mjpg mjpg;
} spa_video_info_info;


	swigNewline();

	swigComment("----===< prefix >===-----\n");

	swigPrint( "c-library pipewire\ns\" pipewire\" add-lib\n\\c #include <pipewire/pipewire.h>\n\\c #include <spa/pod/pod.h>\n\\c #include <spa/pod/builder.h>\n\\c #include <spa/pod/parser.h>\n\\c #include <spa/param/format.h>\n\\c #include <spa/param/audio/format.h>\n\\c #include <spa/param/audio/raw-utils.h>\n\\c #include <spa/param/audio/ape-utils.h>\n\\c #include <spa/param/audio/format-utils.h>\n\\c #include <spa/param/video/format.h>\n\\c #include <spa/param/video/format-utils.h>\n\\c #include <spa/utils/result.h>\n\\c #include <spa/param/props.h>", "( none )", "( none )" );

	swigNewline();

	swigComment("----===< int constants >===-----\n");
	#ifdef PW_VERSION_CLIENT
		swigIntConstant( PW_VERSION_CLIENT, "PW_VERSION_CLIENT" );
	#endif
	#ifdef PW_ID_CLIENT
		swigIntConstant( PW_ID_CLIENT, "PW_ID_CLIENT" );
	#endif
	#ifdef PW_CLIENT_CHANGE_MASK_PROPS
		swigIntConstant( PW_CLIENT_CHANGE_MASK_PROPS, "PW_CLIENT_CHANGE_MASK_PROPS" );
	#endif
	#ifdef PW_CLIENT_CHANGE_MASK_ALL
		swigIntConstant( PW_CLIENT_CHANGE_MASK_ALL, "PW_CLIENT_CHANGE_MASK_ALL" );
	#endif
	#ifdef PW_CLIENT_EVENT_INFO
		swigIntConstant( PW_CLIENT_EVENT_INFO, "PW_CLIENT_EVENT_INFO" );
	#endif
	#ifdef PW_CLIENT_EVENT_PERMISSIONS
		swigIntConstant( PW_CLIENT_EVENT_PERMISSIONS, "PW_CLIENT_EVENT_PERMISSIONS" );
	#endif
	#ifdef PW_CLIENT_EVENT_NUM
		swigIntConstant( PW_CLIENT_EVENT_NUM, "PW_CLIENT_EVENT_NUM" );
	#endif
	#ifdef PW_VERSION_CLIENT_EVENTS
		swigIntConstant( PW_VERSION_CLIENT_EVENTS, "PW_VERSION_CLIENT_EVENTS" );
	#endif
	#ifdef PW_CLIENT_METHOD_ADD_LISTENER
		swigIntConstant( PW_CLIENT_METHOD_ADD_LISTENER, "PW_CLIENT_METHOD_ADD_LISTENER" );
	#endif
	#ifdef PW_CLIENT_METHOD_ERROR
		swigIntConstant( PW_CLIENT_METHOD_ERROR, "PW_CLIENT_METHOD_ERROR" );
	#endif
	#ifdef PW_CLIENT_METHOD_UPDATE_PROPERTIES
		swigIntConstant( PW_CLIENT_METHOD_UPDATE_PROPERTIES, "PW_CLIENT_METHOD_UPDATE_PROPERTIES" );
	#endif
	#ifdef PW_CLIENT_METHOD_GET_PERMISSIONS
		swigIntConstant( PW_CLIENT_METHOD_GET_PERMISSIONS, "PW_CLIENT_METHOD_GET_PERMISSIONS" );
	#endif
	#ifdef PW_CLIENT_METHOD_UPDATE_PERMISSIONS
		swigIntConstant( PW_CLIENT_METHOD_UPDATE_PERMISSIONS, "PW_CLIENT_METHOD_UPDATE_PERMISSIONS" );
	#endif
	#ifdef PW_CLIENT_METHOD_NUM
		swigIntConstant( PW_CLIENT_METHOD_NUM, "PW_CLIENT_METHOD_NUM" );
	#endif
	#ifdef PW_VERSION_CLIENT_METHODS
		swigIntConstant( PW_VERSION_CLIENT_METHODS, "PW_VERSION_CLIENT_METHODS" );
	#endif
	#ifdef PW_VERSION_CONTEXT_EVENTS
		swigIntConstant( PW_VERSION_CONTEXT_EVENTS, "PW_VERSION_CONTEXT_EVENTS" );
	#endif
	#ifdef PW_VERSION_DEVICE
		swigIntConstant( PW_VERSION_DEVICE, "PW_VERSION_DEVICE" );
	#endif
	#ifdef PW_DEVICE_CHANGE_MASK_PROPS
		swigIntConstant( PW_DEVICE_CHANGE_MASK_PROPS, "PW_DEVICE_CHANGE_MASK_PROPS" );
	#endif
	#ifdef PW_DEVICE_CHANGE_MASK_PARAMS
		swigIntConstant( PW_DEVICE_CHANGE_MASK_PARAMS, "PW_DEVICE_CHANGE_MASK_PARAMS" );
	#endif
	#ifdef PW_DEVICE_CHANGE_MASK_ALL
		swigIntConstant( PW_DEVICE_CHANGE_MASK_ALL, "PW_DEVICE_CHANGE_MASK_ALL" );
	#endif
	#ifdef PW_DEVICE_EVENT_INFO
		swigIntConstant( PW_DEVICE_EVENT_INFO, "PW_DEVICE_EVENT_INFO" );
	#endif
	#ifdef PW_DEVICE_EVENT_PARAM
		swigIntConstant( PW_DEVICE_EVENT_PARAM, "PW_DEVICE_EVENT_PARAM" );
	#endif
	#ifdef PW_DEVICE_EVENT_NUM
		swigIntConstant( PW_DEVICE_EVENT_NUM, "PW_DEVICE_EVENT_NUM" );
	#endif
	#ifdef PW_VERSION_DEVICE_EVENTS
		swigIntConstant( PW_VERSION_DEVICE_EVENTS, "PW_VERSION_DEVICE_EVENTS" );
	#endif
	#ifdef PW_DEVICE_METHOD_ADD_LISTENER
		swigIntConstant( PW_DEVICE_METHOD_ADD_LISTENER, "PW_DEVICE_METHOD_ADD_LISTENER" );
	#endif
	#ifdef PW_DEVICE_METHOD_SUBSCRIBE_PARAMS
		swigIntConstant( PW_DEVICE_METHOD_SUBSCRIBE_PARAMS, "PW_DEVICE_METHOD_SUBSCRIBE_PARAMS" );
	#endif
	#ifdef PW_DEVICE_METHOD_ENUM_PARAMS
		swigIntConstant( PW_DEVICE_METHOD_ENUM_PARAMS, "PW_DEVICE_METHOD_ENUM_PARAMS" );
	#endif
	#ifdef PW_DEVICE_METHOD_SET_PARAM
		swigIntConstant( PW_DEVICE_METHOD_SET_PARAM, "PW_DEVICE_METHOD_SET_PARAM" );
	#endif
	#ifdef PW_DEVICE_METHOD_NUM
		swigIntConstant( PW_DEVICE_METHOD_NUM, "PW_DEVICE_METHOD_NUM" );
	#endif
	#ifdef PW_VERSION_DEVICE_METHODS
		swigIntConstant( PW_VERSION_DEVICE_METHODS, "PW_VERSION_DEVICE_METHODS" );
	#endif
	#ifdef PW_BUFFERS_FLAG_NONE
		swigIntConstant( PW_BUFFERS_FLAG_NONE, "PW_BUFFERS_FLAG_NONE" );
	#endif
	#ifdef PW_BUFFERS_FLAG_NO_MEM
		swigIntConstant( PW_BUFFERS_FLAG_NO_MEM, "PW_BUFFERS_FLAG_NO_MEM" );
	#endif
	#ifdef PW_BUFFERS_FLAG_SHARED
		swigIntConstant( PW_BUFFERS_FLAG_SHARED, "PW_BUFFERS_FLAG_SHARED" );
	#endif
	#ifdef PW_BUFFERS_FLAG_DYNAMIC
		swigIntConstant( PW_BUFFERS_FLAG_DYNAMIC, "PW_BUFFERS_FLAG_DYNAMIC" );
	#endif
	#ifdef PW_BUFFERS_FLAG_SHARED_MEM
		swigIntConstant( PW_BUFFERS_FLAG_SHARED_MEM, "PW_BUFFERS_FLAG_SHARED_MEM" );
	#endif
	#ifdef PW_BUFFERS_FLAG_IN_PRIORITY
		swigIntConstant( PW_BUFFERS_FLAG_IN_PRIORITY, "PW_BUFFERS_FLAG_IN_PRIORITY" );
	#endif
	#ifdef PW_BUFFERS_FLAG_ASYNC
		swigIntConstant( PW_BUFFERS_FLAG_ASYNC, "PW_BUFFERS_FLAG_ASYNC" );
	#endif
	#ifdef PW_VERSION_CORE
		swigIntConstant( PW_VERSION_CORE, "PW_VERSION_CORE" );
	#endif
	#ifdef PW_VERSION_REGISTRY
		swigIntConstant( PW_VERSION_REGISTRY, "PW_VERSION_REGISTRY" );
	#endif
	#ifdef PW_ID_CORE
		swigIntConstant( PW_ID_CORE, "PW_ID_CORE" );
	#endif
	#ifdef PW_CORE_CHANGE_MASK_PROPS
		swigIntConstant( PW_CORE_CHANGE_MASK_PROPS, "PW_CORE_CHANGE_MASK_PROPS" );
	#endif
	#ifdef PW_CORE_CHANGE_MASK_ALL
		swigIntConstant( PW_CORE_CHANGE_MASK_ALL, "PW_CORE_CHANGE_MASK_ALL" );
	#endif
	#ifdef PW_CORE_EVENT_INFO
		swigIntConstant( PW_CORE_EVENT_INFO, "PW_CORE_EVENT_INFO" );
	#endif
	#ifdef PW_CORE_EVENT_DONE
		swigIntConstant( PW_CORE_EVENT_DONE, "PW_CORE_EVENT_DONE" );
	#endif
	#ifdef PW_CORE_EVENT_PING
		swigIntConstant( PW_CORE_EVENT_PING, "PW_CORE_EVENT_PING" );
	#endif
	#ifdef PW_CORE_EVENT_ERROR
		swigIntConstant( PW_CORE_EVENT_ERROR, "PW_CORE_EVENT_ERROR" );
	#endif
	#ifdef PW_CORE_EVENT_REMOVE_ID
		swigIntConstant( PW_CORE_EVENT_REMOVE_ID, "PW_CORE_EVENT_REMOVE_ID" );
	#endif
	#ifdef PW_CORE_EVENT_BOUND_ID
		swigIntConstant( PW_CORE_EVENT_BOUND_ID, "PW_CORE_EVENT_BOUND_ID" );
	#endif
	#ifdef PW_CORE_EVENT_ADD_MEM
		swigIntConstant( PW_CORE_EVENT_ADD_MEM, "PW_CORE_EVENT_ADD_MEM" );
	#endif
	#ifdef PW_CORE_EVENT_REMOVE_MEM
		swigIntConstant( PW_CORE_EVENT_REMOVE_MEM, "PW_CORE_EVENT_REMOVE_MEM" );
	#endif
	#ifdef PW_CORE_EVENT_BOUND_PROPS
		swigIntConstant( PW_CORE_EVENT_BOUND_PROPS, "PW_CORE_EVENT_BOUND_PROPS" );
	#endif
	#ifdef PW_CORE_EVENT_NUM
		swigIntConstant( PW_CORE_EVENT_NUM, "PW_CORE_EVENT_NUM" );
	#endif
	#ifdef PW_VERSION_CORE_EVENTS
		swigIntConstant( PW_VERSION_CORE_EVENTS, "PW_VERSION_CORE_EVENTS" );
	#endif
	#ifdef PW_CORE_METHOD_ADD_LISTENER
		swigIntConstant( PW_CORE_METHOD_ADD_LISTENER, "PW_CORE_METHOD_ADD_LISTENER" );
	#endif
	#ifdef PW_CORE_METHOD_HELLO
		swigIntConstant( PW_CORE_METHOD_HELLO, "PW_CORE_METHOD_HELLO" );
	#endif
	#ifdef PW_CORE_METHOD_SYNC
		swigIntConstant( PW_CORE_METHOD_SYNC, "PW_CORE_METHOD_SYNC" );
	#endif
	#ifdef PW_CORE_METHOD_PONG
		swigIntConstant( PW_CORE_METHOD_PONG, "PW_CORE_METHOD_PONG" );
	#endif
	#ifdef PW_CORE_METHOD_ERROR
		swigIntConstant( PW_CORE_METHOD_ERROR, "PW_CORE_METHOD_ERROR" );
	#endif
	#ifdef PW_CORE_METHOD_GET_REGISTRY
		swigIntConstant( PW_CORE_METHOD_GET_REGISTRY, "PW_CORE_METHOD_GET_REGISTRY" );
	#endif
	#ifdef PW_CORE_METHOD_CREATE_OBJECT
		swigIntConstant( PW_CORE_METHOD_CREATE_OBJECT, "PW_CORE_METHOD_CREATE_OBJECT" );
	#endif
	#ifdef PW_CORE_METHOD_DESTROY
		swigIntConstant( PW_CORE_METHOD_DESTROY, "PW_CORE_METHOD_DESTROY" );
	#endif
	#ifdef PW_CORE_METHOD_NUM
		swigIntConstant( PW_CORE_METHOD_NUM, "PW_CORE_METHOD_NUM" );
	#endif
	#ifdef PW_VERSION_CORE_METHODS
		swigIntConstant( PW_VERSION_CORE_METHODS, "PW_VERSION_CORE_METHODS" );
	#endif
	#ifdef PW_REGISTRY_EVENT_GLOBAL
		swigIntConstant( PW_REGISTRY_EVENT_GLOBAL, "PW_REGISTRY_EVENT_GLOBAL" );
	#endif
	#ifdef PW_REGISTRY_EVENT_GLOBAL_REMOVE
		swigIntConstant( PW_REGISTRY_EVENT_GLOBAL_REMOVE, "PW_REGISTRY_EVENT_GLOBAL_REMOVE" );
	#endif
	#ifdef PW_REGISTRY_EVENT_NUM
		swigIntConstant( PW_REGISTRY_EVENT_NUM, "PW_REGISTRY_EVENT_NUM" );
	#endif
	#ifdef PW_VERSION_REGISTRY_EVENTS
		swigIntConstant( PW_VERSION_REGISTRY_EVENTS, "PW_VERSION_REGISTRY_EVENTS" );
	#endif
	#ifdef PW_REGISTRY_METHOD_ADD_LISTENER
		swigIntConstant( PW_REGISTRY_METHOD_ADD_LISTENER, "PW_REGISTRY_METHOD_ADD_LISTENER" );
	#endif
	#ifdef PW_REGISTRY_METHOD_BIND
		swigIntConstant( PW_REGISTRY_METHOD_BIND, "PW_REGISTRY_METHOD_BIND" );
	#endif
	#ifdef PW_REGISTRY_METHOD_DESTROY
		swigIntConstant( PW_REGISTRY_METHOD_DESTROY, "PW_REGISTRY_METHOD_DESTROY" );
	#endif
	#ifdef PW_REGISTRY_METHOD_NUM
		swigIntConstant( PW_REGISTRY_METHOD_NUM, "PW_REGISTRY_METHOD_NUM" );
	#endif
	#ifdef PW_VERSION_REGISTRY_METHODS
		swigIntConstant( PW_VERSION_REGISTRY_METHODS, "PW_VERSION_REGISTRY_METHODS" );
	#endif
	#ifdef PW_VERSION_FACTORY
		swigIntConstant( PW_VERSION_FACTORY, "PW_VERSION_FACTORY" );
	#endif
	#ifdef PW_FACTORY_CHANGE_MASK_PROPS
		swigIntConstant( PW_FACTORY_CHANGE_MASK_PROPS, "PW_FACTORY_CHANGE_MASK_PROPS" );
	#endif
	#ifdef PW_FACTORY_CHANGE_MASK_ALL
		swigIntConstant( PW_FACTORY_CHANGE_MASK_ALL, "PW_FACTORY_CHANGE_MASK_ALL" );
	#endif
	#ifdef PW_FACTORY_EVENT_INFO
		swigIntConstant( PW_FACTORY_EVENT_INFO, "PW_FACTORY_EVENT_INFO" );
	#endif
	#ifdef PW_FACTORY_EVENT_NUM
		swigIntConstant( PW_FACTORY_EVENT_NUM, "PW_FACTORY_EVENT_NUM" );
	#endif
	#ifdef PW_VERSION_FACTORY_EVENTS
		swigIntConstant( PW_VERSION_FACTORY_EVENTS, "PW_VERSION_FACTORY_EVENTS" );
	#endif
	#ifdef PW_FACTORY_METHOD_ADD_LISTENER
		swigIntConstant( PW_FACTORY_METHOD_ADD_LISTENER, "PW_FACTORY_METHOD_ADD_LISTENER" );
	#endif
	#ifdef PW_FACTORY_METHOD_NUM
		swigIntConstant( PW_FACTORY_METHOD_NUM, "PW_FACTORY_METHOD_NUM" );
	#endif
	#ifdef PW_VERSION_FACTORY_METHODS
		swigIntConstant( PW_VERSION_FACTORY_METHODS, "PW_VERSION_FACTORY_METHODS" );
	#endif
	#ifdef PW_VERSION_LINK
		swigIntConstant( PW_VERSION_LINK, "PW_VERSION_LINK" );
	#endif
	#ifdef PW_LINK_CHANGE_MASK_STATE
		swigIntConstant( PW_LINK_CHANGE_MASK_STATE, "PW_LINK_CHANGE_MASK_STATE" );
	#endif
	#ifdef PW_LINK_CHANGE_MASK_FORMAT
		swigIntConstant( PW_LINK_CHANGE_MASK_FORMAT, "PW_LINK_CHANGE_MASK_FORMAT" );
	#endif
	#ifdef PW_LINK_CHANGE_MASK_PROPS
		swigIntConstant( PW_LINK_CHANGE_MASK_PROPS, "PW_LINK_CHANGE_MASK_PROPS" );
	#endif
	#ifdef PW_LINK_CHANGE_MASK_ALL
		swigIntConstant( PW_LINK_CHANGE_MASK_ALL, "PW_LINK_CHANGE_MASK_ALL" );
	#endif
	#ifdef PW_LINK_EVENT_INFO
		swigIntConstant( PW_LINK_EVENT_INFO, "PW_LINK_EVENT_INFO" );
	#endif
	#ifdef PW_LINK_EVENT_NUM
		swigIntConstant( PW_LINK_EVENT_NUM, "PW_LINK_EVENT_NUM" );
	#endif
	#ifdef PW_VERSION_LINK_EVENTS
		swigIntConstant( PW_VERSION_LINK_EVENTS, "PW_VERSION_LINK_EVENTS" );
	#endif
	#ifdef PW_LINK_METHOD_ADD_LISTENER
		swigIntConstant( PW_LINK_METHOD_ADD_LISTENER, "PW_LINK_METHOD_ADD_LISTENER" );
	#endif
	#ifdef PW_LINK_METHOD_NUM
		swigIntConstant( PW_LINK_METHOD_NUM, "PW_LINK_METHOD_NUM" );
	#endif
	#ifdef PW_VERSION_LINK_METHODS
		swigIntConstant( PW_VERSION_LINK_METHODS, "PW_VERSION_LINK_METHODS" );
	#endif
	#ifdef PW_VERSION_MAIN_LOOP_EVENTS
		swigIntConstant( PW_VERSION_MAIN_LOOP_EVENTS, "PW_VERSION_MAIN_LOOP_EVENTS" );
	#endif
	#ifdef PW_VERSION_MEMPOOL_EVENTS
		swigIntConstant( PW_VERSION_MEMPOOL_EVENTS, "PW_VERSION_MEMPOOL_EVENTS" );
	#endif
	#ifdef PW_VERSION_MODULE
		swigIntConstant( PW_VERSION_MODULE, "PW_VERSION_MODULE" );
	#endif
	#ifdef PW_MODULE_CHANGE_MASK_PROPS
		swigIntConstant( PW_MODULE_CHANGE_MASK_PROPS, "PW_MODULE_CHANGE_MASK_PROPS" );
	#endif
	#ifdef PW_MODULE_CHANGE_MASK_ALL
		swigIntConstant( PW_MODULE_CHANGE_MASK_ALL, "PW_MODULE_CHANGE_MASK_ALL" );
	#endif
	#ifdef PW_MODULE_EVENT_INFO
		swigIntConstant( PW_MODULE_EVENT_INFO, "PW_MODULE_EVENT_INFO" );
	#endif
	#ifdef PW_MODULE_EVENT_NUM
		swigIntConstant( PW_MODULE_EVENT_NUM, "PW_MODULE_EVENT_NUM" );
	#endif
	#ifdef PW_VERSION_MODULE_EVENTS
		swigIntConstant( PW_VERSION_MODULE_EVENTS, "PW_VERSION_MODULE_EVENTS" );
	#endif
	#ifdef PW_MODULE_METHOD_ADD_LISTENER
		swigIntConstant( PW_MODULE_METHOD_ADD_LISTENER, "PW_MODULE_METHOD_ADD_LISTENER" );
	#endif
	#ifdef PW_MODULE_METHOD_NUM
		swigIntConstant( PW_MODULE_METHOD_NUM, "PW_MODULE_METHOD_NUM" );
	#endif
	#ifdef PW_VERSION_MODULE_METHODS
		swigIntConstant( PW_VERSION_MODULE_METHODS, "PW_VERSION_MODULE_METHODS" );
	#endif
	#ifdef PW_VERSION_NODE
		swigIntConstant( PW_VERSION_NODE, "PW_VERSION_NODE" );
	#endif
	#ifdef PW_NODE_CHANGE_MASK_INPUT_PORTS
		swigIntConstant( PW_NODE_CHANGE_MASK_INPUT_PORTS, "PW_NODE_CHANGE_MASK_INPUT_PORTS" );
	#endif
	#ifdef PW_NODE_CHANGE_MASK_OUTPUT_PORTS
		swigIntConstant( PW_NODE_CHANGE_MASK_OUTPUT_PORTS, "PW_NODE_CHANGE_MASK_OUTPUT_PORTS" );
	#endif
	#ifdef PW_NODE_CHANGE_MASK_STATE
		swigIntConstant( PW_NODE_CHANGE_MASK_STATE, "PW_NODE_CHANGE_MASK_STATE" );
	#endif
	#ifdef PW_NODE_CHANGE_MASK_PROPS
		swigIntConstant( PW_NODE_CHANGE_MASK_PROPS, "PW_NODE_CHANGE_MASK_PROPS" );
	#endif
	#ifdef PW_NODE_CHANGE_MASK_PARAMS
		swigIntConstant( PW_NODE_CHANGE_MASK_PARAMS, "PW_NODE_CHANGE_MASK_PARAMS" );
	#endif
	#ifdef PW_NODE_CHANGE_MASK_ALL
		swigIntConstant( PW_NODE_CHANGE_MASK_ALL, "PW_NODE_CHANGE_MASK_ALL" );
	#endif
	#ifdef PW_NODE_EVENT_INFO
		swigIntConstant( PW_NODE_EVENT_INFO, "PW_NODE_EVENT_INFO" );
	#endif
	#ifdef PW_NODE_EVENT_PARAM
		swigIntConstant( PW_NODE_EVENT_PARAM, "PW_NODE_EVENT_PARAM" );
	#endif
	#ifdef PW_NODE_EVENT_NUM
		swigIntConstant( PW_NODE_EVENT_NUM, "PW_NODE_EVENT_NUM" );
	#endif
	#ifdef PW_VERSION_NODE_EVENTS
		swigIntConstant( PW_VERSION_NODE_EVENTS, "PW_VERSION_NODE_EVENTS" );
	#endif
	#ifdef PW_NODE_METHOD_ADD_LISTENER
		swigIntConstant( PW_NODE_METHOD_ADD_LISTENER, "PW_NODE_METHOD_ADD_LISTENER" );
	#endif
	#ifdef PW_NODE_METHOD_SUBSCRIBE_PARAMS
		swigIntConstant( PW_NODE_METHOD_SUBSCRIBE_PARAMS, "PW_NODE_METHOD_SUBSCRIBE_PARAMS" );
	#endif
	#ifdef PW_NODE_METHOD_ENUM_PARAMS
		swigIntConstant( PW_NODE_METHOD_ENUM_PARAMS, "PW_NODE_METHOD_ENUM_PARAMS" );
	#endif
	#ifdef PW_NODE_METHOD_SET_PARAM
		swigIntConstant( PW_NODE_METHOD_SET_PARAM, "PW_NODE_METHOD_SET_PARAM" );
	#endif
	#ifdef PW_NODE_METHOD_SEND_COMMAND
		swigIntConstant( PW_NODE_METHOD_SEND_COMMAND, "PW_NODE_METHOD_SEND_COMMAND" );
	#endif
	#ifdef PW_NODE_METHOD_NUM
		swigIntConstant( PW_NODE_METHOD_NUM, "PW_NODE_METHOD_NUM" );
	#endif
	#ifdef PW_VERSION_NODE_METHODS
		swigIntConstant( PW_VERSION_NODE_METHODS, "PW_VERSION_NODE_METHODS" );
	#endif
	#ifdef PW_PROPERTIES_FLAG_NL
		swigIntConstant( PW_PROPERTIES_FLAG_NL, "PW_PROPERTIES_FLAG_NL" );
	#endif
	#ifdef PW_PROPERTIES_FLAG_RECURSE
		swigIntConstant( PW_PROPERTIES_FLAG_RECURSE, "PW_PROPERTIES_FLAG_RECURSE" );
	#endif
	#ifdef PW_PROPERTIES_FLAG_ENCLOSE
		swigIntConstant( PW_PROPERTIES_FLAG_ENCLOSE, "PW_PROPERTIES_FLAG_ENCLOSE" );
	#endif
	#ifdef PW_PROPERTIES_FLAG_ARRAY
		swigIntConstant( PW_PROPERTIES_FLAG_ARRAY, "PW_PROPERTIES_FLAG_ARRAY" );
	#endif
	#ifdef PW_PROPERTIES_FLAG_COLORS
		swigIntConstant( PW_PROPERTIES_FLAG_COLORS, "PW_PROPERTIES_FLAG_COLORS" );
	#endif
	#ifdef PW_VERSION_PROXY_EVENTS
		swigIntConstant( PW_VERSION_PROXY_EVENTS, "PW_VERSION_PROXY_EVENTS" );
	#endif
	#ifdef PW_PERM_R
		swigIntConstant( PW_PERM_R, "PW_PERM_R" );
	#endif
	#ifdef PW_PERM_W
		swigIntConstant( PW_PERM_W, "PW_PERM_W" );
	#endif
	#ifdef PW_PERM_X
		swigIntConstant( PW_PERM_X, "PW_PERM_X" );
	#endif
	#ifdef PW_PERM_M
		swigIntConstant( PW_PERM_M, "PW_PERM_M" );
	#endif
	#ifdef PW_PERM_L
		swigIntConstant( PW_PERM_L, "PW_PERM_L" );
	#endif
	#ifdef PW_PERM_RW
		swigIntConstant( PW_PERM_RW, "PW_PERM_RW" );
	#endif
	#ifdef PW_PERM_RWX
		swigIntConstant( PW_PERM_RWX, "PW_PERM_RWX" );
	#endif
	#ifdef PW_PERM_RWXM
		swigIntConstant( PW_PERM_RWXM, "PW_PERM_RWXM" );
	#endif
	#ifdef PW_PERM_RWXML
		swigIntConstant( PW_PERM_RWXML, "PW_PERM_RWXML" );
	#endif
	#ifdef PW_PERM_ALL
		swigIntConstant( PW_PERM_ALL, "PW_PERM_ALL" );
	#endif
	#ifdef PW_PROTOCOL_MARSHAL_FLAG_IMPL
		swigIntConstant( PW_PROTOCOL_MARSHAL_FLAG_IMPL, "PW_PROTOCOL_MARSHAL_FLAG_IMPL" );
	#endif
	#ifdef PW_VERSION_PROTOCOL_IMPLEMENTATION
		swigIntConstant( PW_VERSION_PROTOCOL_IMPLEMENTATION, "PW_VERSION_PROTOCOL_IMPLEMENTATION" );
	#endif
	#ifdef PW_VERSION_PROTOCOL_EVENTS
		swigIntConstant( PW_VERSION_PROTOCOL_EVENTS, "PW_VERSION_PROTOCOL_EVENTS" );
	#endif
	#ifdef PW_PORT_PERM_MASK
		swigIntConstant( PW_PORT_PERM_MASK, "PW_PORT_PERM_MASK" );
	#endif
	#ifdef PW_VERSION_PORT
		swigIntConstant( PW_VERSION_PORT, "PW_VERSION_PORT" );
	#endif
	#ifdef PW_PORT_CHANGE_MASK_PROPS
		swigIntConstant( PW_PORT_CHANGE_MASK_PROPS, "PW_PORT_CHANGE_MASK_PROPS" );
	#endif
	#ifdef PW_PORT_CHANGE_MASK_PARAMS
		swigIntConstant( PW_PORT_CHANGE_MASK_PARAMS, "PW_PORT_CHANGE_MASK_PARAMS" );
	#endif
	#ifdef PW_PORT_CHANGE_MASK_ALL
		swigIntConstant( PW_PORT_CHANGE_MASK_ALL, "PW_PORT_CHANGE_MASK_ALL" );
	#endif
	#ifdef PW_PORT_EVENT_INFO
		swigIntConstant( PW_PORT_EVENT_INFO, "PW_PORT_EVENT_INFO" );
	#endif
	#ifdef PW_PORT_EVENT_PARAM
		swigIntConstant( PW_PORT_EVENT_PARAM, "PW_PORT_EVENT_PARAM" );
	#endif
	#ifdef PW_PORT_EVENT_NUM
		swigIntConstant( PW_PORT_EVENT_NUM, "PW_PORT_EVENT_NUM" );
	#endif
	#ifdef PW_VERSION_PORT_EVENTS
		swigIntConstant( PW_VERSION_PORT_EVENTS, "PW_VERSION_PORT_EVENTS" );
	#endif
	#ifdef PW_PORT_METHOD_ADD_LISTENER
		swigIntConstant( PW_PORT_METHOD_ADD_LISTENER, "PW_PORT_METHOD_ADD_LISTENER" );
	#endif
	#ifdef PW_PORT_METHOD_SUBSCRIBE_PARAMS
		swigIntConstant( PW_PORT_METHOD_SUBSCRIBE_PARAMS, "PW_PORT_METHOD_SUBSCRIBE_PARAMS" );
	#endif
	#ifdef PW_PORT_METHOD_ENUM_PARAMS
		swigIntConstant( PW_PORT_METHOD_ENUM_PARAMS, "PW_PORT_METHOD_ENUM_PARAMS" );
	#endif
	#ifdef PW_PORT_METHOD_NUM
		swigIntConstant( PW_PORT_METHOD_NUM, "PW_PORT_METHOD_NUM" );
	#endif
	#ifdef PW_VERSION_PORT_METHODS
		swigIntConstant( PW_VERSION_PORT_METHODS, "PW_VERSION_PORT_METHODS" );
	#endif
	#ifdef PW_VERSION_STREAM_EVENTS
		swigIntConstant( PW_VERSION_STREAM_EVENTS, "PW_VERSION_STREAM_EVENTS" );
	#endif
	#ifdef PW_VERSION_FILTER_EVENTS
		swigIntConstant( PW_VERSION_FILTER_EVENTS, "PW_VERSION_FILTER_EVENTS" );
	#endif
	#ifdef PW_VERSION_THREAD_LOOP_EVENTS
		swigIntConstant( PW_VERSION_THREAD_LOOP_EVENTS, "PW_VERSION_THREAD_LOOP_EVENTS" );
	#endif
	#ifdef PW_VERSION_DATA_LOOP_EVENTS
		swigIntConstant( PW_VERSION_DATA_LOOP_EVENTS, "PW_VERSION_DATA_LOOP_EVENTS" );
	#endif
	#ifdef ENODATA
		swigIntConstant( ENODATA, "ENODATA" );
	#endif
	#ifdef PW_MAJOR
		swigIntConstant( PW_MAJOR, "PW_MAJOR" );
	#endif
	#ifdef PW_MINOR
		swigIntConstant( PW_MINOR, "PW_MINOR" );
	#endif
	#ifdef PW_MICRO
		swigIntConstant( PW_MICRO, "PW_MICRO" );
	#endif
	#ifdef SPA_POD_BUILDER_FLAG_BODY
		swigIntConstant( SPA_POD_BUILDER_FLAG_BODY, "SPA_POD_BUILDER_FLAG_BODY" );
	#endif
	#ifdef SPA_POD_BUILDER_FLAG_FIRST
		swigIntConstant( SPA_POD_BUILDER_FLAG_FIRST, "SPA_POD_BUILDER_FLAG_FIRST" );
	#endif
	#ifdef SPA_VERSION_POD_BUILDER_CALLBACKS
		swigIntConstant( SPA_VERSION_POD_BUILDER_CALLBACKS, "SPA_VERSION_POD_BUILDER_CALLBACKS" );
	#endif
	#ifdef SPA_ASYNC_BIT
		swigIntConstant( SPA_ASYNC_BIT, "SPA_ASYNC_BIT" );
	#endif
	#ifdef SPA_ASYNC_SEQ_MASK
		swigIntConstant( SPA_ASYNC_SEQ_MASK, "SPA_ASYNC_SEQ_MASK" );
	#endif
	#ifdef SPA_ASYNC_MASK
		swigIntConstant( SPA_ASYNC_MASK, "SPA_ASYNC_MASK" );
	#endif

	swigNewline();

	swigComment("--------===< enums >===---------\n");
	swigIntConstant( PW_LINK_STATE_ERROR, "PW_LINK_STATE_ERROR" );
	swigIntConstant( PW_LINK_STATE_UNLINKED, "PW_LINK_STATE_UNLINKED" );
	swigIntConstant( PW_LINK_STATE_INIT, "PW_LINK_STATE_INIT" );
	swigIntConstant( PW_LINK_STATE_NEGOTIATING, "PW_LINK_STATE_NEGOTIATING" );
	swigIntConstant( PW_LINK_STATE_ALLOCATING, "PW_LINK_STATE_ALLOCATING" );
	swigIntConstant( PW_LINK_STATE_PAUSED, "PW_LINK_STATE_PAUSED" );
	swigIntConstant( PW_LINK_STATE_ACTIVE, "PW_LINK_STATE_ACTIVE" );
	swigIntConstant( PW_MEMBLOCK_FLAG_NONE, "PW_MEMBLOCK_FLAG_NONE" );
	swigIntConstant( PW_MEMBLOCK_FLAG_READABLE, "PW_MEMBLOCK_FLAG_READABLE" );
	swigIntConstant( PW_MEMBLOCK_FLAG_WRITABLE, "PW_MEMBLOCK_FLAG_WRITABLE" );
	swigIntConstant( PW_MEMBLOCK_FLAG_SEAL, "PW_MEMBLOCK_FLAG_SEAL" );
	swigIntConstant( PW_MEMBLOCK_FLAG_MAP, "PW_MEMBLOCK_FLAG_MAP" );
	swigIntConstant( PW_MEMBLOCK_FLAG_DONT_CLOSE, "PW_MEMBLOCK_FLAG_DONT_CLOSE" );
	swigIntConstant( PW_MEMBLOCK_FLAG_DONT_NOTIFY, "PW_MEMBLOCK_FLAG_DONT_NOTIFY" );
	swigIntConstant( PW_MEMBLOCK_FLAG_READWRITE, "PW_MEMBLOCK_FLAG_READWRITE" );
	swigIntConstant( PW_MEMMAP_FLAG_NONE, "PW_MEMMAP_FLAG_NONE" );
	swigIntConstant( PW_MEMMAP_FLAG_READ, "PW_MEMMAP_FLAG_READ" );
	swigIntConstant( PW_MEMMAP_FLAG_WRITE, "PW_MEMMAP_FLAG_WRITE" );
	swigIntConstant( PW_MEMMAP_FLAG_TWICE, "PW_MEMMAP_FLAG_TWICE" );
	swigIntConstant( PW_MEMMAP_FLAG_PRIVATE, "PW_MEMMAP_FLAG_PRIVATE" );
	swigIntConstant( PW_MEMMAP_FLAG_LOCKED, "PW_MEMMAP_FLAG_LOCKED" );
	swigIntConstant( PW_MEMMAP_FLAG_READWRITE, "PW_MEMMAP_FLAG_READWRITE" );
	swigIntConstant( PW_NODE_STATE_ERROR, "PW_NODE_STATE_ERROR" );
	swigIntConstant( PW_NODE_STATE_CREATING, "PW_NODE_STATE_CREATING" );
	swigIntConstant( PW_NODE_STATE_SUSPENDED, "PW_NODE_STATE_SUSPENDED" );
	swigIntConstant( PW_NODE_STATE_IDLE, "PW_NODE_STATE_IDLE" );
	swigIntConstant( PW_NODE_STATE_RUNNING, "PW_NODE_STATE_RUNNING" );
	swigIntConstant( PW_STREAM_STATE_ERROR, "PW_STREAM_STATE_ERROR" );
	swigIntConstant( PW_STREAM_STATE_UNCONNECTED, "PW_STREAM_STATE_UNCONNECTED" );
	swigIntConstant( PW_STREAM_STATE_CONNECTING, "PW_STREAM_STATE_CONNECTING" );
	swigIntConstant( PW_STREAM_STATE_PAUSED, "PW_STREAM_STATE_PAUSED" );
	swigIntConstant( PW_STREAM_STATE_STREAMING, "PW_STREAM_STATE_STREAMING" );
	swigIntConstant( PW_STREAM_FLAG_NONE, "PW_STREAM_FLAG_NONE" );
	swigIntConstant( PW_STREAM_FLAG_AUTOCONNECT, "PW_STREAM_FLAG_AUTOCONNECT" );
	swigIntConstant( PW_STREAM_FLAG_INACTIVE, "PW_STREAM_FLAG_INACTIVE" );
	swigIntConstant( PW_STREAM_FLAG_MAP_BUFFERS, "PW_STREAM_FLAG_MAP_BUFFERS" );
	swigIntConstant( PW_STREAM_FLAG_DRIVER, "PW_STREAM_FLAG_DRIVER" );
	swigIntConstant( PW_STREAM_FLAG_RT_PROCESS, "PW_STREAM_FLAG_RT_PROCESS" );
	swigIntConstant( PW_STREAM_FLAG_NO_CONVERT, "PW_STREAM_FLAG_NO_CONVERT" );
	swigIntConstant( PW_STREAM_FLAG_EXCLUSIVE, "PW_STREAM_FLAG_EXCLUSIVE" );
	swigIntConstant( PW_STREAM_FLAG_DONT_RECONNECT, "PW_STREAM_FLAG_DONT_RECONNECT" );
	swigIntConstant( PW_STREAM_FLAG_ALLOC_BUFFERS, "PW_STREAM_FLAG_ALLOC_BUFFERS" );
	swigIntConstant( PW_STREAM_FLAG_TRIGGER, "PW_STREAM_FLAG_TRIGGER" );
	swigIntConstant( PW_STREAM_FLAG_ASYNC, "PW_STREAM_FLAG_ASYNC" );
	swigIntConstant( PW_STREAM_FLAG_EARLY_PROCESS, "PW_STREAM_FLAG_EARLY_PROCESS" );
	swigIntConstant( PW_FILTER_STATE_ERROR, "PW_FILTER_STATE_ERROR" );
	swigIntConstant( PW_FILTER_STATE_UNCONNECTED, "PW_FILTER_STATE_UNCONNECTED" );
	swigIntConstant( PW_FILTER_STATE_CONNECTING, "PW_FILTER_STATE_CONNECTING" );
	swigIntConstant( PW_FILTER_STATE_PAUSED, "PW_FILTER_STATE_PAUSED" );
	swigIntConstant( PW_FILTER_STATE_STREAMING, "PW_FILTER_STATE_STREAMING" );
	swigIntConstant( PW_FILTER_FLAG_NONE, "PW_FILTER_FLAG_NONE" );
	swigIntConstant( PW_FILTER_FLAG_INACTIVE, "PW_FILTER_FLAG_INACTIVE" );
	swigIntConstant( PW_FILTER_FLAG_DRIVER, "PW_FILTER_FLAG_DRIVER" );
	swigIntConstant( PW_FILTER_FLAG_RT_PROCESS, "PW_FILTER_FLAG_RT_PROCESS" );
	swigIntConstant( PW_FILTER_FLAG_CUSTOM_LATENCY, "PW_FILTER_FLAG_CUSTOM_LATENCY" );
	swigIntConstant( PW_FILTER_FLAG_TRIGGER, "PW_FILTER_FLAG_TRIGGER" );
	swigIntConstant( PW_FILTER_FLAG_ASYNC, "PW_FILTER_FLAG_ASYNC" );
	swigIntConstant( PW_FILTER_PORT_FLAG_NONE, "PW_FILTER_PORT_FLAG_NONE" );
	swigIntConstant( PW_FILTER_PORT_FLAG_MAP_BUFFERS, "PW_FILTER_PORT_FLAG_MAP_BUFFERS" );
	swigIntConstant( PW_FILTER_PORT_FLAG_ALLOC_BUFFERS, "PW_FILTER_PORT_FLAG_ALLOC_BUFFERS" );
	swigIntConstant( PW_TYPE_FIRST, "PW_TYPE_FIRST" );
	swigIntConstant( SPA_PROP_INFO_START, "SPA_PROP_INFO_START" );
	swigIntConstant( SPA_PROP_INFO_id, "SPA_PROP_INFO_id" );
	swigIntConstant( SPA_PROP_INFO_name, "SPA_PROP_INFO_name" );
	swigIntConstant( SPA_PROP_INFO_type, "SPA_PROP_INFO_type" );
	swigIntConstant( SPA_PROP_INFO_labels, "SPA_PROP_INFO_labels" );
	swigIntConstant( SPA_PROP_INFO_container, "SPA_PROP_INFO_container" );
	swigIntConstant( SPA_PROP_INFO_params, "SPA_PROP_INFO_params" );
	swigIntConstant( SPA_PROP_INFO_description, "SPA_PROP_INFO_description" );
	swigIntConstant( SPA_PROP_START, "SPA_PROP_START" );
	swigIntConstant( SPA_PROP_unknown, "SPA_PROP_unknown" );
	swigIntConstant( SPA_PROP_START_Device, "SPA_PROP_START_Device" );
	swigIntConstant( SPA_PROP_device, "SPA_PROP_device" );
	swigIntConstant( SPA_PROP_deviceName, "SPA_PROP_deviceName" );
	swigIntConstant( SPA_PROP_deviceFd, "SPA_PROP_deviceFd" );
	swigIntConstant( SPA_PROP_card, "SPA_PROP_card" );
	swigIntConstant( SPA_PROP_cardName, "SPA_PROP_cardName" );
	swigIntConstant( SPA_PROP_minLatency, "SPA_PROP_minLatency" );
	swigIntConstant( SPA_PROP_maxLatency, "SPA_PROP_maxLatency" );
	swigIntConstant( SPA_PROP_periods, "SPA_PROP_periods" );
	swigIntConstant( SPA_PROP_periodSize, "SPA_PROP_periodSize" );
	swigIntConstant( SPA_PROP_periodEvent, "SPA_PROP_periodEvent" );
	swigIntConstant( SPA_PROP_live, "SPA_PROP_live" );
	swigIntConstant( SPA_PROP_rate, "SPA_PROP_rate" );
	swigIntConstant( SPA_PROP_quality, "SPA_PROP_quality" );
	swigIntConstant( SPA_PROP_bluetoothAudioCodec, "SPA_PROP_bluetoothAudioCodec" );
	swigIntConstant( SPA_PROP_bluetoothOffloadActive, "SPA_PROP_bluetoothOffloadActive" );
	swigIntConstant( SPA_PROP_START_Audio, "SPA_PROP_START_Audio" );
	swigIntConstant( SPA_PROP_waveType, "SPA_PROP_waveType" );
	swigIntConstant( SPA_PROP_frequency, "SPA_PROP_frequency" );
	swigIntConstant( SPA_PROP_volume, "SPA_PROP_volume" );
	swigIntConstant( SPA_PROP_mute, "SPA_PROP_mute" );
	swigIntConstant( SPA_PROP_patternType, "SPA_PROP_patternType" );
	swigIntConstant( SPA_PROP_ditherType, "SPA_PROP_ditherType" );
	swigIntConstant( SPA_PROP_truncate, "SPA_PROP_truncate" );
	swigIntConstant( SPA_PROP_channelVolumes, "SPA_PROP_channelVolumes" );
	swigIntConstant( SPA_PROP_volumeBase, "SPA_PROP_volumeBase" );
	swigIntConstant( SPA_PROP_volumeStep, "SPA_PROP_volumeStep" );
	swigIntConstant( SPA_PROP_channelMap, "SPA_PROP_channelMap" );
	swigIntConstant( SPA_PROP_monitorMute, "SPA_PROP_monitorMute" );
	swigIntConstant( SPA_PROP_monitorVolumes, "SPA_PROP_monitorVolumes" );
	swigIntConstant( SPA_PROP_latencyOffsetNsec, "SPA_PROP_latencyOffsetNsec" );
	swigIntConstant( SPA_PROP_softMute, "SPA_PROP_softMute" );
	swigIntConstant( SPA_PROP_softVolumes, "SPA_PROP_softVolumes" );
	swigIntConstant( SPA_PROP_iec958Codecs, "SPA_PROP_iec958Codecs" );
	swigIntConstant( SPA_PROP_volumeRampSamples, "SPA_PROP_volumeRampSamples" );
	swigIntConstant( SPA_PROP_volumeRampStepSamples, "SPA_PROP_volumeRampStepSamples" );
	swigIntConstant( SPA_PROP_volumeRampTime, "SPA_PROP_volumeRampTime" );
	swigIntConstant( SPA_PROP_volumeRampStepTime, "SPA_PROP_volumeRampStepTime" );
	swigIntConstant( SPA_PROP_volumeRampScale, "SPA_PROP_volumeRampScale" );
	swigIntConstant( SPA_PROP_START_Video, "SPA_PROP_START_Video" );
	swigIntConstant( SPA_PROP_brightness, "SPA_PROP_brightness" );
	swigIntConstant( SPA_PROP_contrast, "SPA_PROP_contrast" );
	swigIntConstant( SPA_PROP_saturation, "SPA_PROP_saturation" );
	swigIntConstant( SPA_PROP_hue, "SPA_PROP_hue" );
	swigIntConstant( SPA_PROP_gamma, "SPA_PROP_gamma" );
	swigIntConstant( SPA_PROP_exposure, "SPA_PROP_exposure" );
	swigIntConstant( SPA_PROP_gain, "SPA_PROP_gain" );
	swigIntConstant( SPA_PROP_sharpness, "SPA_PROP_sharpness" );
	swigIntConstant( SPA_PROP_START_Other, "SPA_PROP_START_Other" );
	swigIntConstant( SPA_PROP_params, "SPA_PROP_params" );
	swigIntConstant( SPA_PROP_START_CUSTOM, "SPA_PROP_START_CUSTOM" );

	swigNewline();

	swigComment("-------===< structs >===--------\n");

	swigComment("struct pw_array\n");
	printf( "begin-structure pw_array\n" );
	swigStructField( "pw_array-data", offsetof( struct pw_array, data ), sizeof( void * ) );
	swigStructField( "pw_array-alloc", offsetof( struct pw_array, alloc ), sizeof( size_t ) );
	swigStructField( "pw_array-size", offsetof( struct pw_array, size ), sizeof( size_t ) );
	swigStructField( "pw_array-extend", offsetof( struct pw_array, extend ), sizeof( size_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct pw_array ) );

	swigComment("struct pw_client_info\n");
	printf( "begin-structure pw_client_info\n" );
	swigStructField( "pw_client_info-change_mask", offsetof( struct pw_client_info, change_mask ), sizeof( uint64_t ) );
	swigStructField( "pw_client_info-id", offsetof( struct pw_client_info, id ), sizeof( uint32_t ) );
	swigStructField( "pw_client_info-props", offsetof( struct pw_client_info, props ), sizeof( struct spa_dict * ) );
	printf( "drop %zu end-structure\n", sizeof( struct pw_client_info ) );

	swigComment("struct pw_client_events\n");
	printf( "begin-structure pw_client_events\n" );
	swigStructField( "pw_client_events-permissions", offsetof( struct pw_client_events, permissions ), sizeof( void (*)(void *,uint32_t,uint32_t,struct pw_permission const *) ) );
	swigStructField( "pw_client_events-version", offsetof( struct pw_client_events, version ), sizeof( uint32_t ) );
	swigStructField( "pw_client_events-info", offsetof( struct pw_client_events, info ), sizeof( void (*)(void *,struct pw_client_info const *) ) );
	printf( "drop %zu end-structure\n", sizeof( struct pw_client_events ) );

	swigComment("struct pw_client_methods\n");
	printf( "begin-structure pw_client_methods\n" );
	swigStructField( "pw_client_methods-get_permissions", offsetof( struct pw_client_methods, get_permissions ), sizeof( int (*)(void *,uint32_t,uint32_t) ) );
	swigStructField( "pw_client_methods-update_permissions", offsetof( struct pw_client_methods, update_permissions ), sizeof( int (*)(void *,uint32_t,struct pw_permission const *) ) );
	swigStructField( "pw_client_methods-version", offsetof( struct pw_client_methods, version ), sizeof( uint32_t ) );
	swigStructField( "pw_client_methods-error", offsetof( struct pw_client_methods, error ), sizeof( int (*)(void *,uint32_t,int,char const *) ) );
	swigStructField( "pw_client_methods-update_properties", offsetof( struct pw_client_methods, update_properties ), sizeof( int (*)(void *,struct spa_dict const *) ) );
	swigStructField( "pw_client_methods-add_listener", offsetof( struct pw_client_methods, add_listener ), sizeof( int (*)(void *,struct spa_hook *,struct pw_client_events const *,void *) ) );
	printf( "drop %zu end-structure\n", sizeof( struct pw_client_methods ) );

	swigComment("struct pw_context_events\n");
	printf( "begin-structure pw_context_events\n" );
	swigStructField( "pw_context_events-check_access", offsetof( struct pw_context_events, check_access ), sizeof( void (*)(void *,struct pw_impl_client *) ) );
	swigStructField( "pw_context_events-destroy", offsetof( struct pw_context_events, destroy ), sizeof( void (*)(void *) ) );
	swigStructField( "pw_context_events-global_added", offsetof( struct pw_context_events, global_added ), sizeof( void (*)(void *,struct pw_global *) ) );
	swigStructField( "pw_context_events-driver_added", offsetof( struct pw_context_events, driver_added ), sizeof( void (*)(void *,struct pw_impl_node *) ) );
	swigStructField( "pw_context_events-version", offsetof( struct pw_context_events, version ), sizeof( uint32_t ) );
	swigStructField( "pw_context_events-free", offsetof( struct pw_context_events, free ), sizeof( void (*)(void *) ) );
	swigStructField( "pw_context_events-global_removed", offsetof( struct pw_context_events, global_removed ), sizeof( void (*)(void *,struct pw_global *) ) );
	swigStructField( "pw_context_events-driver_removed", offsetof( struct pw_context_events, driver_removed ), sizeof( void (*)(void *,struct pw_impl_node *) ) );
	printf( "drop %zu end-structure\n", sizeof( struct pw_context_events ) );

	swigComment("struct pw_export_type\n");
	printf( "begin-structure pw_export_type\n" );
	swigStructField( "pw_export_type-func", offsetof( struct pw_export_type, func ), sizeof( struct pw_proxy *(*)(struct pw_core *,char const *,struct spa_dict const *,void *,size_t) ) );
	swigStructField( "pw_export_type-link", offsetof( struct pw_export_type, link ), sizeof( struct spa_list ) );
	swigStructField( "pw_export_type-type", offsetof( struct pw_export_type, type ), sizeof( char const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct pw_export_type ) );

	swigComment("struct pw_device_info\n");
	printf( "begin-structure pw_device_info\n" );
	swigStructField( "pw_device_info-change_mask", offsetof( struct pw_device_info, change_mask ), sizeof( uint64_t ) );
	swigStructField( "pw_device_info-id", offsetof( struct pw_device_info, id ), sizeof( uint32_t ) );
	swigStructField( "pw_device_info-props", offsetof( struct pw_device_info, props ), sizeof( struct spa_dict * ) );
	swigStructField( "pw_device_info-n_params", offsetof( struct pw_device_info, n_params ), sizeof( uint32_t ) );
	swigStructField( "pw_device_info-params", offsetof( struct pw_device_info, params ), sizeof( struct spa_param_info * ) );
	printf( "drop %zu end-structure\n", sizeof( struct pw_device_info ) );

	swigComment("struct pw_device_events\n");
	printf( "begin-structure pw_device_events\n" );
	swigStructField( "pw_device_events-version", offsetof( struct pw_device_events, version ), sizeof( uint32_t ) );
	swigStructField( "pw_device_events-param", offsetof( struct pw_device_events, param ), sizeof( void (*)(void *,int,uint32_t,uint32_t,uint32_t,struct spa_pod const *) ) );
	swigStructField( "pw_device_events-info", offsetof( struct pw_device_events, info ), sizeof( void (*)(void *,struct pw_device_info const *) ) );
	printf( "drop %zu end-structure\n", sizeof( struct pw_device_events ) );

	swigComment("struct pw_device_methods\n");
	printf( "begin-structure pw_device_methods\n" );
	swigStructField( "pw_device_methods-version", offsetof( struct pw_device_methods, version ), sizeof( uint32_t ) );
	swigStructField( "pw_device_methods-set_param", offsetof( struct pw_device_methods, set_param ), sizeof( int (*)(void *,uint32_t,uint32_t,struct spa_pod const *) ) );
	swigStructField( "pw_device_methods-add_listener", offsetof( struct pw_device_methods, add_listener ), sizeof( int (*)(void *,struct spa_hook *,struct pw_device_events const *,void *) ) );
	swigStructField( "pw_device_methods-subscribe_params", offsetof( struct pw_device_methods, subscribe_params ), sizeof( int (*)(void *,uint32_t *,uint32_t) ) );
	swigStructField( "pw_device_methods-enum_params", offsetof( struct pw_device_methods, enum_params ), sizeof( int (*)(void *,int,uint32_t,uint32_t,uint32_t,struct spa_pod const *) ) );
	printf( "drop %zu end-structure\n", sizeof( struct pw_device_methods ) );

	swigComment("struct pw_buffers\n");
	printf( "begin-structure pw_buffers\n" );
	swigStructField( "pw_buffers-mem", offsetof( struct pw_buffers, mem ), sizeof( struct pw_memblock * ) );
	swigStructField( "pw_buffers-buffers", offsetof( struct pw_buffers, buffers ), sizeof( struct spa_buffer ** ) );
	swigStructField( "pw_buffers-n_buffers", offsetof( struct pw_buffers, n_buffers ), sizeof( uint32_t ) );
	swigStructField( "pw_buffers-flags", offsetof( struct pw_buffers, flags ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct pw_buffers ) );

	swigComment("struct pw_core_info\n");
	printf( "begin-structure pw_core_info\n" );
	swigStructField( "pw_core_info-change_mask", offsetof( struct pw_core_info, change_mask ), sizeof( uint64_t ) );
	swigStructField( "pw_core_info-host_name", offsetof( struct pw_core_info, host_name ), sizeof( char const * ) );
	swigStructField( "pw_core_info-name", offsetof( struct pw_core_info, name ), sizeof( char const * ) );
	swigStructField( "pw_core_info-id", offsetof( struct pw_core_info, id ), sizeof( uint32_t ) );
	swigStructField( "pw_core_info-cookie", offsetof( struct pw_core_info, cookie ), sizeof( uint32_t ) );
	swigStructField( "pw_core_info-version", offsetof( struct pw_core_info, version ), sizeof( char const * ) );
	swigStructField( "pw_core_info-props", offsetof( struct pw_core_info, props ), sizeof( struct spa_dict * ) );
	swigStructField( "pw_core_info-user_name", offsetof( struct pw_core_info, user_name ), sizeof( char const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct pw_core_info ) );

	swigComment("struct pw_core_events\n");
	printf( "begin-structure pw_core_events\n" );
	swigStructField( "pw_core_events-remove_mem", offsetof( struct pw_core_events, remove_mem ), sizeof( void (*)(void *,uint32_t) ) );
	swigStructField( "pw_core_events-version", offsetof( struct pw_core_events, version ), sizeof( uint32_t ) );
	swigStructField( "pw_core_events-done", offsetof( struct pw_core_events, done ), sizeof( void (*)(void *,uint32_t,int) ) );
	swigStructField( "pw_core_events-error", offsetof( struct pw_core_events, error ), sizeof( void (*)(void *,uint32_t,int,int,char const *) ) );
	swigStructField( "pw_core_events-add_mem", offsetof( struct pw_core_events, add_mem ), sizeof( void (*)(void *,uint32_t,uint32_t,int,uint32_t) ) );
	swigStructField( "pw_core_events-bound_props", offsetof( struct pw_core_events, bound_props ), sizeof( void (*)(void *,uint32_t,uint32_t,struct spa_dict const *) ) );
	swigStructField( "pw_core_events-info", offsetof( struct pw_core_events, info ), sizeof( void (*)(void *,struct pw_core_info const *) ) );
	swigStructField( "pw_core_events-ping", offsetof( struct pw_core_events, ping ), sizeof( void (*)(void *,uint32_t,int) ) );
	swigStructField( "pw_core_events-remove_id", offsetof( struct pw_core_events, remove_id ), sizeof( void (*)(void *,uint32_t) ) );
	swigStructField( "pw_core_events-bound_id", offsetof( struct pw_core_events, bound_id ), sizeof( void (*)(void *,uint32_t,uint32_t) ) );
	printf( "drop %zu end-structure\n", sizeof( struct pw_core_events ) );

	swigComment("struct pw_core_methods\n");
	printf( "begin-structure pw_core_methods\n" );
	swigStructField( "pw_core_methods-sync", offsetof( struct pw_core_methods, sync ), sizeof( int (*)(void *,uint32_t,int) ) );
	swigStructField( "pw_core_methods-get_registry", offsetof( struct pw_core_methods, get_registry ), sizeof( struct pw_registry *(*)(void *,uint32_t,size_t) ) );
	swigStructField( "pw_core_methods-destroy", offsetof( struct pw_core_methods, destroy ), sizeof( int (*)(void *,void *) ) );
	swigStructField( "pw_core_methods-version", offsetof( struct pw_core_methods, version ), sizeof( uint32_t ) );
	swigStructField( "pw_core_methods-hello", offsetof( struct pw_core_methods, hello ), sizeof( int (*)(void *,uint32_t) ) );
	swigStructField( "pw_core_methods-pong", offsetof( struct pw_core_methods, pong ), sizeof( int (*)(void *,uint32_t,int) ) );
	swigStructField( "pw_core_methods-error", offsetof( struct pw_core_methods, error ), sizeof( int (*)(void *,uint32_t,int,int,char const *) ) );
	swigStructField( "pw_core_methods-create_object", offsetof( struct pw_core_methods, create_object ), sizeof( void *(*)(void *,char const *,char const *,uint32_t,struct spa_dict const *,size_t) ) );
	swigStructField( "pw_core_methods-add_listener", offsetof( struct pw_core_methods, add_listener ), sizeof( int (*)(void *,struct spa_hook *,struct pw_core_events const *,void *) ) );
	printf( "drop %zu end-structure\n", sizeof( struct pw_core_methods ) );

	swigComment("struct pw_registry_events\n");
	printf( "begin-structure pw_registry_events\n" );
	swigStructField( "pw_registry_events-global_remove", offsetof( struct pw_registry_events, global_remove ), sizeof( void (*)(void *,uint32_t) ) );
	swigStructField( "pw_registry_events-version", offsetof( struct pw_registry_events, version ), sizeof( uint32_t ) );
	swigStructField( "pw_registry_events-global", offsetof( struct pw_registry_events, global ), sizeof( void (*)(void *,uint32_t,uint32_t,char const *,uint32_t,struct spa_dict const *) ) );
	printf( "drop %zu end-structure\n", sizeof( struct pw_registry_events ) );

	swigComment("struct pw_registry_methods\n");
	printf( "begin-structure pw_registry_methods\n" );
	swigStructField( "pw_registry_methods-bind", offsetof( struct pw_registry_methods, bind ), sizeof( void *(*)(void *,uint32_t,char const *,uint32_t,size_t) ) );
	swigStructField( "pw_registry_methods-destroy", offsetof( struct pw_registry_methods, destroy ), sizeof( int (*)(void *,uint32_t) ) );
	swigStructField( "pw_registry_methods-version", offsetof( struct pw_registry_methods, version ), sizeof( uint32_t ) );
	swigStructField( "pw_registry_methods-add_listener", offsetof( struct pw_registry_methods, add_listener ), sizeof( int (*)(void *,struct spa_hook *,struct pw_registry_events const *,void *) ) );
	printf( "drop %zu end-structure\n", sizeof( struct pw_registry_methods ) );

	swigComment("struct pw_factory_info\n");
	printf( "begin-structure pw_factory_info\n" );
	swigStructField( "pw_factory_info-change_mask", offsetof( struct pw_factory_info, change_mask ), sizeof( uint64_t ) );
	swigStructField( "pw_factory_info-name", offsetof( struct pw_factory_info, name ), sizeof( char const * ) );
	swigStructField( "pw_factory_info-id", offsetof( struct pw_factory_info, id ), sizeof( uint32_t ) );
	swigStructField( "pw_factory_info-version", offsetof( struct pw_factory_info, version ), sizeof( uint32_t ) );
	swigStructField( "pw_factory_info-props", offsetof( struct pw_factory_info, props ), sizeof( struct spa_dict * ) );
	swigStructField( "pw_factory_info-type", offsetof( struct pw_factory_info, type ), sizeof( char const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct pw_factory_info ) );

	swigComment("struct pw_factory_events\n");
	printf( "begin-structure pw_factory_events\n" );
	swigStructField( "pw_factory_events-version", offsetof( struct pw_factory_events, version ), sizeof( uint32_t ) );
	swigStructField( "pw_factory_events-info", offsetof( struct pw_factory_events, info ), sizeof( void (*)(void *,struct pw_factory_info const *) ) );
	printf( "drop %zu end-structure\n", sizeof( struct pw_factory_events ) );

	swigComment("struct pw_factory_methods\n");
	printf( "begin-structure pw_factory_methods\n" );
	swigStructField( "pw_factory_methods-version", offsetof( struct pw_factory_methods, version ), sizeof( uint32_t ) );
	swigStructField( "pw_factory_methods-add_listener", offsetof( struct pw_factory_methods, add_listener ), sizeof( int (*)(void *,struct spa_hook *,struct pw_factory_events const *,void *) ) );
	printf( "drop %zu end-structure\n", sizeof( struct pw_factory_methods ) );

	swigComment("struct pw_loop\n");
	printf( "begin-structure pw_loop\n" );
	swigStructField( "pw_loop-control", offsetof( struct pw_loop, control ), sizeof( struct spa_loop_control * ) );
	swigStructField( "pw_loop-system", offsetof( struct pw_loop, system ), sizeof( struct spa_system * ) );
	swigStructField( "pw_loop-loop", offsetof( struct pw_loop, loop ), sizeof( struct spa_loop * ) );
	swigStructField( "pw_loop-utils", offsetof( struct pw_loop, utils ), sizeof( struct spa_loop_utils * ) );
	printf( "drop %zu end-structure\n", sizeof( struct pw_loop ) );

	swigComment("struct pw_link_info\n");
	printf( "begin-structure pw_link_info\n" );
	swigStructField( "pw_link_info-change_mask", offsetof( struct pw_link_info, change_mask ), sizeof( uint64_t ) );
	swigStructField( "pw_link_info-id", offsetof( struct pw_link_info, id ), sizeof( uint32_t ) );
	swigStructField( "pw_link_info-error", offsetof( struct pw_link_info, error ), sizeof( char const * ) );
	swigStructField( "pw_link_info-output_node_id", offsetof( struct pw_link_info, output_node_id ), sizeof( uint32_t ) );
	swigStructField( "pw_link_info-input_node_id", offsetof( struct pw_link_info, input_node_id ), sizeof( uint32_t ) );
	swigStructField( "pw_link_info-props", offsetof( struct pw_link_info, props ), sizeof( struct spa_dict * ) );
	swigStructField( "pw_link_info-output_port_id", offsetof( struct pw_link_info, output_port_id ), sizeof( uint32_t ) );
	swigStructField( "pw_link_info-input_port_id", offsetof( struct pw_link_info, input_port_id ), sizeof( uint32_t ) );
	swigStructField( "pw_link_info-state", offsetof( struct pw_link_info, state ), sizeof( enum pw_link_state ) );
	swigStructField( "pw_link_info-format", offsetof( struct pw_link_info, format ), sizeof( struct spa_pod * ) );
	printf( "drop %zu end-structure\n", sizeof( struct pw_link_info ) );

	swigComment("struct pw_link_events\n");
	printf( "begin-structure pw_link_events\n" );
	swigStructField( "pw_link_events-version", offsetof( struct pw_link_events, version ), sizeof( uint32_t ) );
	swigStructField( "pw_link_events-info", offsetof( struct pw_link_events, info ), sizeof( void (*)(void *,struct pw_link_info const *) ) );
	printf( "drop %zu end-structure\n", sizeof( struct pw_link_events ) );

	swigComment("struct pw_link_methods\n");
	printf( "begin-structure pw_link_methods\n" );
	swigStructField( "pw_link_methods-version", offsetof( struct pw_link_methods, version ), sizeof( uint32_t ) );
	swigStructField( "pw_link_methods-add_listener", offsetof( struct pw_link_methods, add_listener ), sizeof( int (*)(void *,struct spa_hook *,struct pw_link_events const *,void *) ) );
	printf( "drop %zu end-structure\n", sizeof( struct pw_link_methods ) );

	swigComment("struct pw_main_loop_events\n");
	printf( "begin-structure pw_main_loop_events\n" );
	swigStructField( "pw_main_loop_events-destroy", offsetof( struct pw_main_loop_events, destroy ), sizeof( void (*)(void *) ) );
	swigStructField( "pw_main_loop_events-version", offsetof( struct pw_main_loop_events, version ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct pw_main_loop_events ) );

	swigComment("union pw_map_item\n");
	printf( "begin-structure pw_map_item\n" );
	swigStructField( "pw_map_item-data", offsetof( union pw_map_item, data ), sizeof( void * ) );
	swigStructField( "pw_map_item-next", offsetof( union pw_map_item, next ), sizeof( uintptr_t ) );
	printf( "drop %zu end-structure\n", sizeof( union pw_map_item ) );

	swigComment("struct pw_map\n");
	printf( "begin-structure pw_map\n" );
	swigStructField( "pw_map-items", offsetof( struct pw_map, items ), sizeof( struct pw_array ) );
	swigStructField( "pw_map-free_list", offsetof( struct pw_map, free_list ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct pw_map ) );

	swigComment("struct pw_mempool\n");
	printf( "begin-structure pw_mempool\n" );
	swigStructField( "pw_mempool-props", offsetof( struct pw_mempool, props ), sizeof( struct pw_properties * ) );
	printf( "drop %zu end-structure\n", sizeof( struct pw_mempool ) );

	swigComment("struct pw_memblock\n");
	printf( "begin-structure pw_memblock\n" );
	swigStructField( "pw_memblock-id", offsetof( struct pw_memblock, id ), sizeof( uint32_t ) );
	swigStructField( "pw_memblock-pool", offsetof( struct pw_memblock, pool ), sizeof( struct pw_mempool * ) );
	swigStructField( "pw_memblock-type", offsetof( struct pw_memblock, type ), sizeof( uint32_t ) );
	swigStructField( "pw_memblock-fd", offsetof( struct pw_memblock, fd ), sizeof( int ) );
	swigStructField( "pw_memblock-size", offsetof( struct pw_memblock, size ), sizeof( uint32_t ) );
	swigStructField( "pw_memblock-map", offsetof( struct pw_memblock, map ), sizeof( struct pw_memmap * ) );
	swigStructField( "pw_memblock-flags", offsetof( struct pw_memblock, flags ), sizeof( uint32_t ) );
	swigStructField( "pw_memblock-ref", offsetof( struct pw_memblock, ref ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( struct pw_memblock ) );

	swigComment("struct pw_memmap\n");
	printf( "begin-structure pw_memmap\n" );
	swigStructField( "pw_memmap-block", offsetof( struct pw_memmap, block ), sizeof( struct pw_memblock * ) );
	swigStructField( "pw_memmap-tag", offsetof( struct pw_memmap, tag ), sizeof( uint32_t [5] ) );
	swigStructField( "pw_memmap-offset", offsetof( struct pw_memmap, offset ), sizeof( uint32_t ) );
	swigStructField( "pw_memmap-ptr", offsetof( struct pw_memmap, ptr ), sizeof( void * ) );
	swigStructField( "pw_memmap-size", offsetof( struct pw_memmap, size ), sizeof( uint32_t ) );
	swigStructField( "pw_memmap-flags", offsetof( struct pw_memmap, flags ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct pw_memmap ) );

	swigComment("struct pw_mempool_events\n");
	printf( "begin-structure pw_mempool_events\n" );
	swigStructField( "pw_mempool_events-destroy", offsetof( struct pw_mempool_events, destroy ), sizeof( void (*)(void *) ) );
	swigStructField( "pw_mempool_events-version", offsetof( struct pw_mempool_events, version ), sizeof( uint32_t ) );
	swigStructField( "pw_mempool_events-added", offsetof( struct pw_mempool_events, added ), sizeof( void (*)(void *,struct pw_memblock *) ) );
	swigStructField( "pw_mempool_events-removed", offsetof( struct pw_mempool_events, removed ), sizeof( void (*)(void *,struct pw_memblock *) ) );
	printf( "drop %zu end-structure\n", sizeof( struct pw_mempool_events ) );

	swigComment("struct pw_map_range\n");
	printf( "begin-structure pw_map_range\n" );
	swigStructField( "pw_map_range-offset", offsetof( struct pw_map_range, offset ), sizeof( uint32_t ) );
	swigStructField( "pw_map_range-size", offsetof( struct pw_map_range, size ), sizeof( uint32_t ) );
	swigStructField( "pw_map_range-start", offsetof( struct pw_map_range, start ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct pw_map_range ) );

	swigComment("struct pw_module_info\n");
	printf( "begin-structure pw_module_info\n" );
	swigStructField( "pw_module_info-change_mask", offsetof( struct pw_module_info, change_mask ), sizeof( uint64_t ) );
	swigStructField( "pw_module_info-name", offsetof( struct pw_module_info, name ), sizeof( char const * ) );
	swigStructField( "pw_module_info-id", offsetof( struct pw_module_info, id ), sizeof( uint32_t ) );
	swigStructField( "pw_module_info-filename", offsetof( struct pw_module_info, filename ), sizeof( char const * ) );
	swigStructField( "pw_module_info-props", offsetof( struct pw_module_info, props ), sizeof( struct spa_dict * ) );
	swigStructField( "pw_module_info-args", offsetof( struct pw_module_info, args ), sizeof( char const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct pw_module_info ) );

	swigComment("struct pw_module_events\n");
	printf( "begin-structure pw_module_events\n" );
	swigStructField( "pw_module_events-version", offsetof( struct pw_module_events, version ), sizeof( uint32_t ) );
	swigStructField( "pw_module_events-info", offsetof( struct pw_module_events, info ), sizeof( void (*)(void *,struct pw_module_info const *) ) );
	printf( "drop %zu end-structure\n", sizeof( struct pw_module_events ) );

	swigComment("struct pw_module_methods\n");
	printf( "begin-structure pw_module_methods\n" );
	swigStructField( "pw_module_methods-version", offsetof( struct pw_module_methods, version ), sizeof( uint32_t ) );
	swigStructField( "pw_module_methods-add_listener", offsetof( struct pw_module_methods, add_listener ), sizeof( int (*)(void *,struct spa_hook *,struct pw_module_events const *,void *) ) );
	printf( "drop %zu end-structure\n", sizeof( struct pw_module_methods ) );

	swigComment("struct pw_node_info\n");
	printf( "begin-structure pw_node_info\n" );
	swigStructField( "pw_node_info-max_input_ports", offsetof( struct pw_node_info, max_input_ports ), sizeof( uint32_t ) );
	swigStructField( "pw_node_info-max_output_ports", offsetof( struct pw_node_info, max_output_ports ), sizeof( uint32_t ) );
	swigStructField( "pw_node_info-change_mask", offsetof( struct pw_node_info, change_mask ), sizeof( uint64_t ) );
	swigStructField( "pw_node_info-n_input_ports", offsetof( struct pw_node_info, n_input_ports ), sizeof( uint32_t ) );
	swigStructField( "pw_node_info-n_output_ports", offsetof( struct pw_node_info, n_output_ports ), sizeof( uint32_t ) );
	swigStructField( "pw_node_info-id", offsetof( struct pw_node_info, id ), sizeof( uint32_t ) );
	swigStructField( "pw_node_info-error", offsetof( struct pw_node_info, error ), sizeof( char const * ) );
	swigStructField( "pw_node_info-props", offsetof( struct pw_node_info, props ), sizeof( struct spa_dict * ) );
	swigStructField( "pw_node_info-state", offsetof( struct pw_node_info, state ), sizeof( enum pw_node_state ) );
	swigStructField( "pw_node_info-n_params", offsetof( struct pw_node_info, n_params ), sizeof( uint32_t ) );
	swigStructField( "pw_node_info-params", offsetof( struct pw_node_info, params ), sizeof( struct spa_param_info * ) );
	printf( "drop %zu end-structure\n", sizeof( struct pw_node_info ) );

	swigComment("struct pw_node_events\n");
	printf( "begin-structure pw_node_events\n" );
	swigStructField( "pw_node_events-version", offsetof( struct pw_node_events, version ), sizeof( uint32_t ) );
	swigStructField( "pw_node_events-param", offsetof( struct pw_node_events, param ), sizeof( void (*)(void *,int,uint32_t,uint32_t,uint32_t,struct spa_pod const *) ) );
	swigStructField( "pw_node_events-info", offsetof( struct pw_node_events, info ), sizeof( void (*)(void *,struct pw_node_info const *) ) );
	printf( "drop %zu end-structure\n", sizeof( struct pw_node_events ) );

	swigComment("struct pw_node_methods\n");
	printf( "begin-structure pw_node_methods\n" );
	swigStructField( "pw_node_methods-send_command", offsetof( struct pw_node_methods, send_command ), sizeof( int (*)(void *,struct spa_command const *) ) );
	swigStructField( "pw_node_methods-version", offsetof( struct pw_node_methods, version ), sizeof( uint32_t ) );
	swigStructField( "pw_node_methods-set_param", offsetof( struct pw_node_methods, set_param ), sizeof( int (*)(void *,uint32_t,uint32_t,struct spa_pod const *) ) );
	swigStructField( "pw_node_methods-add_listener", offsetof( struct pw_node_methods, add_listener ), sizeof( int (*)(void *,struct spa_hook *,struct pw_node_events const *,void *) ) );
	swigStructField( "pw_node_methods-subscribe_params", offsetof( struct pw_node_methods, subscribe_params ), sizeof( int (*)(void *,uint32_t *,uint32_t) ) );
	swigStructField( "pw_node_methods-enum_params", offsetof( struct pw_node_methods, enum_params ), sizeof( int (*)(void *,int,uint32_t,uint32_t,uint32_t,struct spa_pod const *) ) );
	printf( "drop %zu end-structure\n", sizeof( struct pw_node_methods ) );

	swigComment("struct pw_properties\n");
	printf( "begin-structure pw_properties\n" );
	swigStructField( "pw_properties-dict", offsetof( struct pw_properties, dict ), sizeof( struct spa_dict ) );
	swigStructField( "pw_properties-flags", offsetof( struct pw_properties, flags ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct pw_properties ) );

	swigComment("struct pw_proxy_events\n");
	printf( "begin-structure pw_proxy_events\n" );
	swigStructField( "pw_proxy_events-destroy", offsetof( struct pw_proxy_events, destroy ), sizeof( void (*)(void *) ) );
	swigStructField( "pw_proxy_events-version", offsetof( struct pw_proxy_events, version ), sizeof( uint32_t ) );
	swigStructField( "pw_proxy_events-done", offsetof( struct pw_proxy_events, done ), sizeof( void (*)(void *,int) ) );
	swigStructField( "pw_proxy_events-error", offsetof( struct pw_proxy_events, error ), sizeof( void (*)(void *,int,int,char const *) ) );
	swigStructField( "pw_proxy_events-bound_props", offsetof( struct pw_proxy_events, bound_props ), sizeof( void (*)(void *,uint32_t,struct spa_dict const *) ) );
	swigStructField( "pw_proxy_events-bound", offsetof( struct pw_proxy_events, bound ), sizeof( void (*)(void *,uint32_t) ) );
	swigStructField( "pw_proxy_events-removed", offsetof( struct pw_proxy_events, removed ), sizeof( void (*)(void *) ) );
	printf( "drop %zu end-structure\n", sizeof( struct pw_proxy_events ) );

	swigComment("struct pw_permission\n");
	printf( "begin-structure pw_permission\n" );
	swigStructField( "pw_permission-permissions", offsetof( struct pw_permission, permissions ), sizeof( uint32_t ) );
	swigStructField( "pw_permission-id", offsetof( struct pw_permission, id ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct pw_permission ) );

	swigComment("struct pw_protocol_client\n");
	printf( "begin-structure pw_protocol_client\n" );
	swigStructField( "pw_protocol_client-steal_fd", offsetof( struct pw_protocol_client, steal_fd ), sizeof( int (*)(struct pw_protocol_client *) ) );
	swigStructField( "pw_protocol_client-destroy", offsetof( struct pw_protocol_client, destroy ), sizeof( void (*)(struct pw_protocol_client *) ) );
	swigStructField( "pw_protocol_client-core", offsetof( struct pw_protocol_client, core ), sizeof( struct pw_core * ) );
	swigStructField( "pw_protocol_client-connect_fd", offsetof( struct pw_protocol_client, connect_fd ), sizeof( int (*)(struct pw_protocol_client *,int,bool) ) );
	swigStructField( "pw_protocol_client-link", offsetof( struct pw_protocol_client, link ), sizeof( struct spa_list ) );
	swigStructField( "pw_protocol_client-set_paused", offsetof( struct pw_protocol_client, set_paused ), sizeof( int (*)(struct pw_protocol_client *,bool) ) );
	swigStructField( "pw_protocol_client-protocol", offsetof( struct pw_protocol_client, protocol ), sizeof( struct pw_protocol * ) );
	swigStructField( "pw_protocol_client-connect", offsetof( struct pw_protocol_client, connect ), sizeof( int (*)(struct pw_protocol_client *,struct spa_dict const *,void (*)(void *,int),void *) ) );
	swigStructField( "pw_protocol_client-disconnect", offsetof( struct pw_protocol_client, disconnect ), sizeof( void (*)(struct pw_protocol_client *) ) );
	printf( "drop %zu end-structure\n", sizeof( struct pw_protocol_client ) );

	swigComment("struct pw_protocol_server\n");
	printf( "begin-structure pw_protocol_server\n" );
	swigStructField( "pw_protocol_server-destroy", offsetof( struct pw_protocol_server, destroy ), sizeof( void (*)(struct pw_protocol_server *) ) );
	swigStructField( "pw_protocol_server-core", offsetof( struct pw_protocol_server, core ), sizeof( struct pw_impl_core * ) );
	swigStructField( "pw_protocol_server-link", offsetof( struct pw_protocol_server, link ), sizeof( struct spa_list ) );
	swigStructField( "pw_protocol_server-protocol", offsetof( struct pw_protocol_server, protocol ), sizeof( struct pw_protocol * ) );
	swigStructField( "pw_protocol_server-client_list", offsetof( struct pw_protocol_server, client_list ), sizeof( struct spa_list ) );
	printf( "drop %zu end-structure\n", sizeof( struct pw_protocol_server ) );

	swigComment("struct pw_protocol_marshal\n");
	printf( "begin-structure pw_protocol_marshal\n" );
	swigStructField( "pw_protocol_marshal-version", offsetof( struct pw_protocol_marshal, version ), sizeof( uint32_t ) );
	swigStructField( "pw_protocol_marshal-client_marshal", offsetof( struct pw_protocol_marshal, client_marshal ), sizeof( void const * ) );
	swigStructField( "pw_protocol_marshal-server_demarshal", offsetof( struct pw_protocol_marshal, server_demarshal ), sizeof( void const * ) );
	swigStructField( "pw_protocol_marshal-server_marshal", offsetof( struct pw_protocol_marshal, server_marshal ), sizeof( void const * ) );
	swigStructField( "pw_protocol_marshal-client_demarshal", offsetof( struct pw_protocol_marshal, client_demarshal ), sizeof( void const * ) );
	swigStructField( "pw_protocol_marshal-type", offsetof( struct pw_protocol_marshal, type ), sizeof( char const * ) );
	swigStructField( "pw_protocol_marshal-flags", offsetof( struct pw_protocol_marshal, flags ), sizeof( uint32_t ) );
	swigStructField( "pw_protocol_marshal-n_client_methods", offsetof( struct pw_protocol_marshal, n_client_methods ), sizeof( uint32_t ) );
	swigStructField( "pw_protocol_marshal-n_server_methods", offsetof( struct pw_protocol_marshal, n_server_methods ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct pw_protocol_marshal ) );

	swigComment("struct pw_protocol_implementation\n");
	printf( "begin-structure pw_protocol_implementation\n" );
	swigStructField( "pw_protocol_implementation-add_server", offsetof( struct pw_protocol_implementation, add_server ), sizeof( struct pw_protocol_server *(*)(struct pw_protocol *,struct pw_impl_core *,struct spa_dict const *) ) );
	swigStructField( "pw_protocol_implementation-version", offsetof( struct pw_protocol_implementation, version ), sizeof( uint32_t ) );
	swigStructField( "pw_protocol_implementation-new_client", offsetof( struct pw_protocol_implementation, new_client ), sizeof( struct pw_protocol_client *(*)(struct pw_protocol *,struct pw_core *,struct spa_dict const *) ) );
	printf( "drop %zu end-structure\n", sizeof( struct pw_protocol_implementation ) );

	swigComment("struct pw_protocol_events\n");
	printf( "begin-structure pw_protocol_events\n" );
	swigStructField( "pw_protocol_events-destroy", offsetof( struct pw_protocol_events, destroy ), sizeof( void (*)(void *) ) );
	swigStructField( "pw_protocol_events-version", offsetof( struct pw_protocol_events, version ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct pw_protocol_events ) );

	swigComment("struct pw_port_info\n");
	printf( "begin-structure pw_port_info\n" );
	swigStructField( "pw_port_info-change_mask", offsetof( struct pw_port_info, change_mask ), sizeof( uint64_t ) );
	swigStructField( "pw_port_info-id", offsetof( struct pw_port_info, id ), sizeof( uint32_t ) );
	swigStructField( "pw_port_info-props", offsetof( struct pw_port_info, props ), sizeof( struct spa_dict * ) );
	swigStructField( "pw_port_info-n_params", offsetof( struct pw_port_info, n_params ), sizeof( uint32_t ) );
	swigStructField( "pw_port_info-direction", offsetof( struct pw_port_info, direction ), sizeof( enum spa_direction ) );
	swigStructField( "pw_port_info-params", offsetof( struct pw_port_info, params ), sizeof( struct spa_param_info * ) );
	printf( "drop %zu end-structure\n", sizeof( struct pw_port_info ) );

	swigComment("struct pw_port_events\n");
	printf( "begin-structure pw_port_events\n" );
	swigStructField( "pw_port_events-version", offsetof( struct pw_port_events, version ), sizeof( uint32_t ) );
	swigStructField( "pw_port_events-param", offsetof( struct pw_port_events, param ), sizeof( void (*)(void *,int,uint32_t,uint32_t,uint32_t,struct spa_pod const *) ) );
	swigStructField( "pw_port_events-info", offsetof( struct pw_port_events, info ), sizeof( void (*)(void *,struct pw_port_info const *) ) );
	printf( "drop %zu end-structure\n", sizeof( struct pw_port_events ) );

	swigComment("struct pw_port_methods\n");
	printf( "begin-structure pw_port_methods\n" );
	swigStructField( "pw_port_methods-version", offsetof( struct pw_port_methods, version ), sizeof( uint32_t ) );
	swigStructField( "pw_port_methods-add_listener", offsetof( struct pw_port_methods, add_listener ), sizeof( int (*)(void *,struct spa_hook *,struct pw_port_events const *,void *) ) );
	swigStructField( "pw_port_methods-subscribe_params", offsetof( struct pw_port_methods, subscribe_params ), sizeof( int (*)(void *,uint32_t *,uint32_t) ) );
	swigStructField( "pw_port_methods-enum_params", offsetof( struct pw_port_methods, enum_params ), sizeof( int (*)(void *,int,uint32_t,uint32_t,uint32_t,struct spa_pod const *) ) );
	printf( "drop %zu end-structure\n", sizeof( struct pw_port_methods ) );

	swigComment("struct pw_buffer\n");
	printf( "begin-structure pw_buffer\n" );
	swigStructField( "pw_buffer-buffer", offsetof( struct pw_buffer, buffer ), sizeof( struct spa_buffer * ) );
	swigStructField( "pw_buffer-requested", offsetof( struct pw_buffer, requested ), sizeof( uint64_t ) );
	swigStructField( "pw_buffer-user_data", offsetof( struct pw_buffer, user_data ), sizeof( void * ) );
	swigStructField( "pw_buffer-size", offsetof( struct pw_buffer, size ), sizeof( uint64_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct pw_buffer ) );

	swigComment("struct pw_stream_control\n");
	printf( "begin-structure pw_stream_control\n" );
	swigStructField( "pw_stream_control-name", offsetof( struct pw_stream_control, name ), sizeof( char const * ) );
	swigStructField( "pw_stream_control-flags", offsetof( struct pw_stream_control, flags ), sizeof( uint32_t ) );
	swigStructField( "pw_stream_control-max", offsetof( struct pw_stream_control, max ), sizeof( float ) );
	swigStructField( "pw_stream_control-n_values", offsetof( struct pw_stream_control, n_values ), sizeof( uint32_t ) );
	swigStructField( "pw_stream_control-max_values", offsetof( struct pw_stream_control, max_values ), sizeof( uint32_t ) );
	swigStructField( "pw_stream_control-def", offsetof( struct pw_stream_control, def ), sizeof( float ) );
	swigStructField( "pw_stream_control-min", offsetof( struct pw_stream_control, min ), sizeof( float ) );
	swigStructField( "pw_stream_control-values", offsetof( struct pw_stream_control, values ), sizeof( float * ) );
	printf( "drop %zu end-structure\n", sizeof( struct pw_stream_control ) );

	swigComment("struct pw_time\n");
	printf( "begin-structure pw_time\n" );
	swigStructField( "pw_time-buffered", offsetof( struct pw_time, buffered ), sizeof( uint64_t ) );
	swigStructField( "pw_time-ticks", offsetof( struct pw_time, ticks ), sizeof( uint64_t ) );
	swigStructField( "pw_time-delay", offsetof( struct pw_time, delay ), sizeof( int64_t ) );
	swigStructField( "pw_time-queued_buffers", offsetof( struct pw_time, queued_buffers ), sizeof( uint32_t ) );
	swigStructField( "pw_time-avail_buffers", offsetof( struct pw_time, avail_buffers ), sizeof( uint32_t ) );
	swigStructField( "pw_time-rate", offsetof( struct pw_time, rate ), sizeof( struct spa_fraction ) );
	swigStructField( "pw_time-queued", offsetof( struct pw_time, queued ), sizeof( uint64_t ) );
	swigStructField( "pw_time-now", offsetof( struct pw_time, now ), sizeof( int64_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct pw_time ) );

	swigComment("struct pw_stream_events\n");
	printf( "begin-structure pw_stream_events\n" );
	swigStructField( "pw_stream_events-command", offsetof( struct pw_stream_events, command ), sizeof( void (*)(void *,struct spa_command const *) ) );
	swigStructField( "pw_stream_events-destroy", offsetof( struct pw_stream_events, destroy ), sizeof( void (*)(void *) ) );
	swigStructField( "pw_stream_events-add_buffer", offsetof( struct pw_stream_events, add_buffer ), sizeof( void (*)(void *,struct pw_buffer *) ) );
	swigStructField( "pw_stream_events-remove_buffer", offsetof( struct pw_stream_events, remove_buffer ), sizeof( void (*)(void *,struct pw_buffer *) ) );
	swigStructField( "pw_stream_events-drained", offsetof( struct pw_stream_events, drained ), sizeof( void (*)(void *) ) );
	swigStructField( "pw_stream_events-version", offsetof( struct pw_stream_events, version ), sizeof( uint32_t ) );
	swigStructField( "pw_stream_events-control_info", offsetof( struct pw_stream_events, control_info ), sizeof( void (*)(void *,uint32_t,struct pw_stream_control const *) ) );
	swigStructField( "pw_stream_events-trigger_done", offsetof( struct pw_stream_events, trigger_done ), sizeof( void (*)(void *) ) );
	swigStructField( "pw_stream_events-state_changed", offsetof( struct pw_stream_events, state_changed ), sizeof( void (*)(void *,enum pw_stream_state,enum pw_stream_state,char const *) ) );
	swigStructField( "pw_stream_events-io_changed", offsetof( struct pw_stream_events, io_changed ), sizeof( void (*)(void *,uint32_t,void *,uint32_t) ) );
	swigStructField( "pw_stream_events-param_changed", offsetof( struct pw_stream_events, param_changed ), sizeof( void (*)(void *,uint32_t,struct spa_pod const *) ) );
	swigStructField( "pw_stream_events-process", offsetof( struct pw_stream_events, process ), sizeof( void (*)(void *) ) );
	printf( "drop %zu end-structure\n", sizeof( struct pw_stream_events ) );

	swigComment("struct pw_filter_events\n");
	printf( "begin-structure pw_filter_events\n" );
	swigStructField( "pw_filter_events-command", offsetof( struct pw_filter_events, command ), sizeof( void (*)(void *,struct spa_command const *) ) );
	swigStructField( "pw_filter_events-destroy", offsetof( struct pw_filter_events, destroy ), sizeof( void (*)(void *) ) );
	swigStructField( "pw_filter_events-add_buffer", offsetof( struct pw_filter_events, add_buffer ), sizeof( void (*)(void *,void *,struct pw_buffer *) ) );
	swigStructField( "pw_filter_events-remove_buffer", offsetof( struct pw_filter_events, remove_buffer ), sizeof( void (*)(void *,void *,struct pw_buffer *) ) );
	swigStructField( "pw_filter_events-drained", offsetof( struct pw_filter_events, drained ), sizeof( void (*)(void *) ) );
	swigStructField( "pw_filter_events-version", offsetof( struct pw_filter_events, version ), sizeof( uint32_t ) );
	swigStructField( "pw_filter_events-state_changed", offsetof( struct pw_filter_events, state_changed ), sizeof( void (*)(void *,enum pw_filter_state,enum pw_filter_state,char const *) ) );
	swigStructField( "pw_filter_events-io_changed", offsetof( struct pw_filter_events, io_changed ), sizeof( void (*)(void *,void *,uint32_t,void *,uint32_t) ) );
	swigStructField( "pw_filter_events-param_changed", offsetof( struct pw_filter_events, param_changed ), sizeof( void (*)(void *,void *,uint32_t,struct spa_pod const *) ) );
	swigStructField( "pw_filter_events-process", offsetof( struct pw_filter_events, process ), sizeof( void (*)(void *,struct spa_io_position *) ) );
	printf( "drop %zu end-structure\n", sizeof( struct pw_filter_events ) );

	swigComment("struct pw_thread_loop_events\n");
	printf( "begin-structure pw_thread_loop_events\n" );
	swigStructField( "pw_thread_loop_events-destroy", offsetof( struct pw_thread_loop_events, destroy ), sizeof( void (*)(void *) ) );
	swigStructField( "pw_thread_loop_events-version", offsetof( struct pw_thread_loop_events, version ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct pw_thread_loop_events ) );

	swigComment("struct pw_data_loop_events\n");
	printf( "begin-structure pw_data_loop_events\n" );
	swigStructField( "pw_data_loop_events-destroy", offsetof( struct pw_data_loop_events, destroy ), sizeof( void (*)(void *) ) );
	swigStructField( "pw_data_loop_events-version", offsetof( struct pw_data_loop_events, version ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct pw_data_loop_events ) );

	swigComment("struct spa_pod_parser_state\n");
	printf( "begin-structure spa_pod_parser_state\n" );
	swigStructField( "spa_pod_parser_state-frame", offsetof( struct spa_pod_parser_state, frame ), sizeof( struct spa_pod_frame * ) );
	swigStructField( "spa_pod_parser_state-offset", offsetof( struct spa_pod_parser_state, offset ), sizeof( uint32_t ) );
	swigStructField( "spa_pod_parser_state-flags", offsetof( struct spa_pod_parser_state, flags ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct spa_pod_parser_state ) );

	swigComment("struct spa_pod_parser\n");
	printf( "begin-structure spa_pod_parser\n" );
	swigStructField( "spa_pod_parser-data", offsetof( struct spa_pod_parser, data ), sizeof( void const * ) );
	swigStructField( "spa_pod_parser-_padding", offsetof( struct spa_pod_parser, _padding ), sizeof( uint32_t ) );
	swigStructField( "spa_pod_parser-size", offsetof( struct spa_pod_parser, size ), sizeof( uint32_t ) );
	swigStructField( "spa_pod_parser-state", offsetof( struct spa_pod_parser, state ), sizeof( struct spa_pod_parser_state ) );
	printf( "drop %zu end-structure\n", sizeof( struct spa_pod_parser ) );

	swigComment("struct spa_pod_builder_state\n");
	printf( "begin-structure spa_pod_builder_state\n" );
	swigStructField( "spa_pod_builder_state-frame", offsetof( struct spa_pod_builder_state, frame ), sizeof( struct spa_pod_frame * ) );
	swigStructField( "spa_pod_builder_state-offset", offsetof( struct spa_pod_builder_state, offset ), sizeof( uint32_t ) );
	swigStructField( "spa_pod_builder_state-flags", offsetof( struct spa_pod_builder_state, flags ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct spa_pod_builder_state ) );

	swigComment("struct spa_pod_builder_callbacks\n");
	printf( "begin-structure spa_pod_builder_callbacks\n" );
	swigStructField( "spa_pod_builder_callbacks-version", offsetof( struct spa_pod_builder_callbacks, version ), sizeof( uint32_t ) );
	swigStructField( "spa_pod_builder_callbacks-overflow", offsetof( struct spa_pod_builder_callbacks, overflow ), sizeof( int (*)(void *,uint32_t) ) );
	printf( "drop %zu end-structure\n", sizeof( struct spa_pod_builder_callbacks ) );

	swigComment("struct spa_pod_builder\n");
	printf( "begin-structure spa_pod_builder\n" );
	swigStructField( "spa_pod_builder-data", offsetof( struct spa_pod_builder, data ), sizeof( void * ) );
	swigStructField( "spa_pod_builder-callbacks", offsetof( struct spa_pod_builder, callbacks ), sizeof( struct spa_callbacks ) );
	swigStructField( "spa_pod_builder-_padding", offsetof( struct spa_pod_builder, _padding ), sizeof( uint32_t ) );
	swigStructField( "spa_pod_builder-size", offsetof( struct spa_pod_builder, size ), sizeof( uint32_t ) );
	swigStructField( "spa_pod_builder-state", offsetof( struct spa_pod_builder, state ), sizeof( struct spa_pod_builder_state ) );
	printf( "drop %zu end-structure\n", sizeof( struct spa_pod_builder ) );

	swigComment("struct spa_audio_info\n");
	printf( "begin-structure spa_audio_info\n" );
	swigStructField( "spa_audio_info-media_type", offsetof( struct spa_audio_info, media_type ), sizeof( uint32_t ) );
	swigStructField( "spa_audio_info-media_subtype", offsetof( struct spa_audio_info, media_subtype ), sizeof( uint32_t ) );
	swigStructField( "spa_audio_info-info", offsetof( struct spa_audio_info, info ), sizeof( spa_audio_info_info ) );
	printf( "drop %zu end-structure\n", sizeof( struct spa_audio_info ) );

	swigComment("spa_audio_info_info\n");
	printf( "begin-structure spa_audio_info_info\n" );
	swigStructField( "spa_audio_info_info-opus", offsetof( spa_audio_info_info, opus ), sizeof( struct spa_audio_info_ape ) );
	swigStructField( "spa_audio_info_info-alac", offsetof( spa_audio_info_info, alac ), sizeof( struct spa_audio_info_alac ) );
	swigStructField( "spa_audio_info_info-aac", offsetof( spa_audio_info_info, aac ), sizeof( struct spa_audio_info_aac ) );
	swigStructField( "spa_audio_info_info-ra", offsetof( spa_audio_info_info, ra ), sizeof( struct spa_audio_info_ra ) );
	swigStructField( "spa_audio_info_info-raw", offsetof( spa_audio_info_info, raw ), sizeof( struct spa_audio_info_raw ) );
	swigStructField( "spa_audio_info_info-mp3", offsetof( spa_audio_info_info, mp3 ), sizeof( struct spa_audio_info_mp3 ) );
	swigStructField( "spa_audio_info_info-dsp", offsetof( spa_audio_info_info, dsp ), sizeof( struct spa_audio_info_dsp ) );
	swigStructField( "spa_audio_info_info-ape", offsetof( spa_audio_info_info, ape ), sizeof( struct spa_audio_info_ape ) );
	swigStructField( "spa_audio_info_info-vorbis", offsetof( spa_audio_info_info, vorbis ), sizeof( struct spa_audio_info_vorbis ) );
	swigStructField( "spa_audio_info_info-amr", offsetof( spa_audio_info_info, amr ), sizeof( struct spa_audio_info_amr ) );
	swigStructField( "spa_audio_info_info-iec958", offsetof( spa_audio_info_info, iec958 ), sizeof( struct spa_audio_info_iec958 ) );
	swigStructField( "spa_audio_info_info-flac", offsetof( spa_audio_info_info, flac ), sizeof( struct spa_audio_info_flac ) );
	swigStructField( "spa_audio_info_info-dsd", offsetof( spa_audio_info_info, dsd ), sizeof( struct spa_audio_info_dsd ) );
	swigStructField( "spa_audio_info_info-wma", offsetof( spa_audio_info_info, wma ), sizeof( struct spa_audio_info_wma ) );
	printf( "drop %zu end-structure\n", sizeof( spa_audio_info_info ) );

	swigComment("struct spa_video_info\n");
	printf( "begin-structure spa_video_info\n" );
	swigStructField( "spa_video_info-media_type", offsetof( struct spa_video_info, media_type ), sizeof( uint32_t ) );
	swigStructField( "spa_video_info-media_subtype", offsetof( struct spa_video_info, media_subtype ), sizeof( uint32_t ) );
	swigStructField( "spa_video_info-info", offsetof( struct spa_video_info, info ), sizeof( spa_video_info_info ) );
	printf( "drop %zu end-structure\n", sizeof( struct spa_video_info ) );

	swigComment("spa_video_info_info\n");
	printf( "begin-structure spa_video_info_info\n" );
	swigStructField( "spa_video_info_info-raw", offsetof( spa_video_info_info, raw ), sizeof( struct spa_video_info_raw ) );
	swigStructField( "spa_video_info_info-dsp", offsetof( spa_video_info_info, dsp ), sizeof( struct spa_video_info_dsp ) );
	swigStructField( "spa_video_info_info-h264", offsetof( spa_video_info_info, h264 ), sizeof( struct spa_video_info_h264 ) );
	swigStructField( "spa_video_info_info-mjpg", offsetof( spa_video_info_info, mjpg ), sizeof( struct spa_video_info_mjpg ) );
	printf( "drop %zu end-structure\n", sizeof( spa_video_info_info ) );

	swigNewline();

	swigComment("--===< function pointers >===---\n");
	swigFunctionPointer( "c-funptr pw_client_events-info() {((struct pw_client_events*)ptr)->info} a a -- void", "", "", "	( data info -- )" );
	swigFunctionPointer( "c-funptr pw_client_events-permissions() {((struct pw_client_events*)ptr)->permissions} a u u a -- void", "", "", "	( data index n_permissions permissions -- )" );
	swigFunctionPointer( "c-funptr pw_client_methods-add_listener() {((struct pw_client_methods*)ptr)->add_listener} a a a a -- n", "", "", "	( object listener events data -- )" );
	swigFunctionPointer( "c-funptr pw_client_methods-error() {((struct pw_client_methods*)ptr)->error} a u n s -- n", "", "", "	( object id res message -- )" );
	swigFunctionPointer( "c-funptr pw_client_methods-update_properties() {((struct pw_client_methods*)ptr)->update_properties} a a -- n", "", "", "	( object props -- )" );
	swigFunctionPointer( "c-funptr pw_client_methods-get_permissions() {((struct pw_client_methods*)ptr)->get_permissions} a u u -- n", "", "", "	( object index num -- )" );
	swigFunctionPointer( "c-funptr pw_client_methods-update_permissions() {((struct pw_client_methods*)ptr)->update_permissions} a u a -- n", "", "", "	( object n_permissions permissions -- )" );
	swigFunctionPointer( "c-funptr pw_context_events-destroy() {((struct pw_context_events*)ptr)->destroy} a -- void", "", "", "	( data -- )" );
	swigFunctionPointer( "c-funptr pw_context_events-free() {((struct pw_context_events*)ptr)->free} a -- void", "", "", "	( data -- )" );
	swigFunctionPointer( "c-funptr pw_context_events-check_access() {((struct pw_context_events*)ptr)->check_access} a a -- void", "", "", "	( data client -- )" );
	swigFunctionPointer( "c-funptr pw_context_events-global_added() {((struct pw_context_events*)ptr)->global_added} a a -- void", "", "", "	( data global -- )" );
	swigFunctionPointer( "c-funptr pw_context_events-global_removed() {((struct pw_context_events*)ptr)->global_removed} a a -- void", "", "", "	( data global -- )" );
	swigFunctionPointer( "c-funptr pw_context_events-driver_added() {((struct pw_context_events*)ptr)->driver_added} a a -- void", "", "", "	( data node -- )" );
	swigFunctionPointer( "c-funptr pw_context_events-driver_removed() {((struct pw_context_events*)ptr)->driver_removed} a a -- void", "", "", "	( data node -- )" );
	swigFunctionPointer( "c-funptr pw_export_type-func() {((struct pw_export_type*)ptr)->func} a s a a d -- a", "", "", "	( core type props object user_data_size -- )" );
	swigFunctionPointer( "c-funptr pw_device_events-info() {((struct pw_device_events*)ptr)->info} a a -- void", "", "", "	( data info -- )" );
	swigFunctionPointer( "c-funptr pw_device_events-param() {((struct pw_device_events*)ptr)->param} a n u u u a -- void", "", "", "	( data seq id index next param -- )" );
	swigFunctionPointer( "c-funptr pw_device_methods-add_listener() {((struct pw_device_methods*)ptr)->add_listener} a a a a -- n", "", "", "	( object listener events data -- )" );
	swigFunctionPointer( "c-funptr pw_device_methods-subscribe_params() {((struct pw_device_methods*)ptr)->subscribe_params} a a u -- n", "", "", "	( object ids n_ids -- )" );
	swigFunctionPointer( "c-funptr pw_device_methods-enum_params() {((struct pw_device_methods*)ptr)->enum_params} a n u u u a -- n", "", "", "	( object seq id start num filter -- )" );
	swigFunctionPointer( "c-funptr pw_device_methods-set_param() {((struct pw_device_methods*)ptr)->set_param} a u u a -- n", "", "", "	( object id flags param -- )" );
	swigFunctionPointer( "c-funptr pw_core_events-info() {((struct pw_core_events*)ptr)->info} a a -- void", "", "", "	( data info -- )" );
	swigFunctionPointer( "c-funptr pw_core_events-done() {((struct pw_core_events*)ptr)->done} a u n -- void", "", "", "	( data id seq -- )" );
	swigFunctionPointer( "c-funptr pw_core_events-ping() {((struct pw_core_events*)ptr)->ping} a u n -- void", "", "", "	( data id seq -- )" );
	swigFunctionPointer( "c-funptr pw_core_events-error() {((struct pw_core_events*)ptr)->error} a u n n s -- void", "", "", "	( data id seq res message -- )" );
	swigFunctionPointer( "c-funptr pw_core_events-remove_id() {((struct pw_core_events*)ptr)->remove_id} a u -- void", "", "", "	( data id -- )" );
	swigFunctionPointer( "c-funptr pw_core_events-bound_id() {((struct pw_core_events*)ptr)->bound_id} a u u -- void", "", "", "	( data id global_id -- )" );
	swigFunctionPointer( "c-funptr pw_core_events-add_mem() {((struct pw_core_events*)ptr)->add_mem} a u u n u -- void", "", "", "	( data id type fd flags -- )" );
	swigFunctionPointer( "c-funptr pw_core_events-remove_mem() {((struct pw_core_events*)ptr)->remove_mem} a u -- void", "", "", "	( data id -- )" );
	swigFunctionPointer( "c-funptr pw_core_events-bound_props() {((struct pw_core_events*)ptr)->bound_props} a u u a -- void", "", "", "	( data id global_id props -- )" );
	swigFunctionPointer( "c-funptr pw_core_methods-add_listener() {((struct pw_core_methods*)ptr)->add_listener} a a a a -- n", "", "", "	( object listener events data -- )" );
	swigFunctionPointer( "c-funptr pw_core_methods-hello() {((struct pw_core_methods*)ptr)->hello} a u -- n", "", "", "	( object version -- )" );
	swigFunctionPointer( "c-funptr pw_core_methods-sync() {((struct pw_core_methods*)ptr)->sync} a u n -- n", "", "", "	( object id seq -- )" );
	swigFunctionPointer( "c-funptr pw_core_methods-pong() {((struct pw_core_methods*)ptr)->pong} a u n -- n", "", "", "	( object id seq -- )" );
	swigFunctionPointer( "c-funptr pw_core_methods-error() {((struct pw_core_methods*)ptr)->error} a u n n s -- n", "", "", "	( object id seq res message -- )" );
	swigFunctionPointer( "c-funptr pw_core_methods-get_registry() {((struct pw_core_methods*)ptr)->get_registry} a u d -- a", "", "", "	( object version user_data_size -- )" );
	swigFunctionPointer( "c-funptr pw_core_methods-create_object() {((struct pw_core_methods*)ptr)->create_object} a s s u a d -- a", "", "", "	( object factory_name type version props user_data_size -- )" );
	swigFunctionPointer( "c-funptr pw_core_methods-destroy() {((struct pw_core_methods*)ptr)->destroy} a a -- n", "", "", "	( object proxy -- )" );
	swigFunctionPointer( "c-funptr pw_registry_events-global() {((struct pw_registry_events*)ptr)->global} a u u s u a -- void", "", "", "	( data id permissions type version props -- )" );
	swigFunctionPointer( "c-funptr pw_registry_events-global_remove() {((struct pw_registry_events*)ptr)->global_remove} a u -- void", "", "", "	( data id -- )" );
	swigFunctionPointer( "c-funptr pw_registry_methods-add_listener() {((struct pw_registry_methods*)ptr)->add_listener} a a a a -- n", "", "", "	( object listener events data -- )" );
	swigFunctionPointer( "c-funptr pw_registry_methods-bind() {((struct pw_registry_methods*)ptr)->bind} a u s u d -- a", "", "", "	( object id type version use_data_size -- )" );
	swigFunctionPointer( "c-funptr pw_registry_methods-destroy() {((struct pw_registry_methods*)ptr)->destroy} a u -- n", "", "", "	( object id -- )" );
	swigFunctionPointer( "c-funptr pw_factory_events-info() {((struct pw_factory_events*)ptr)->info} a a -- void", "", "", "	( data info -- )" );
	swigFunctionPointer( "c-funptr pw_factory_methods-add_listener() {((struct pw_factory_methods*)ptr)->add_listener} a a a a -- n", "", "", "	( object listener events data -- )" );
	swigFunctionPointer( "c-funptr pw_link_events-info() {((struct pw_link_events*)ptr)->info} a a -- void", "", "", "	( data info -- )" );
	swigFunctionPointer( "c-funptr pw_link_methods-add_listener() {((struct pw_link_methods*)ptr)->add_listener} a a a a -- n", "", "", "	( object listener events data -- )" );
	swigFunctionPointer( "c-funptr pw_main_loop_events-destroy() {((struct pw_main_loop_events*)ptr)->destroy} a -- void", "", "", "	( data -- )" );
	swigFunctionPointer( "c-funptr pw_mempool_events-destroy() {((struct pw_mempool_events*)ptr)->destroy} a -- void", "", "", "	( data -- )" );
	swigFunctionPointer( "c-funptr pw_mempool_events-added() {((struct pw_mempool_events*)ptr)->added} a a -- void", "", "", "	( data block -- )" );
	swigFunctionPointer( "c-funptr pw_mempool_events-removed() {((struct pw_mempool_events*)ptr)->removed} a a -- void", "", "", "	( data block -- )" );
	swigFunctionPointer( "c-funptr pw_module_events-info() {((struct pw_module_events*)ptr)->info} a a -- void", "", "", "	( data info -- )" );
	swigFunctionPointer( "c-funptr pw_module_methods-add_listener() {((struct pw_module_methods*)ptr)->add_listener} a a a a -- n", "", "", "	( object listener events data -- )" );
	swigFunctionPointer( "c-funptr pw_node_events-info() {((struct pw_node_events*)ptr)->info} a a -- void", "", "", "	( data info -- )" );
	swigFunctionPointer( "c-funptr pw_node_events-param() {((struct pw_node_events*)ptr)->param} a n u u u a -- void", "", "", "	( data seq id index next param -- )" );
	swigFunctionPointer( "c-funptr pw_node_methods-add_listener() {((struct pw_node_methods*)ptr)->add_listener} a a a a -- n", "", "", "	( object listener events data -- )" );
	swigFunctionPointer( "c-funptr pw_node_methods-subscribe_params() {((struct pw_node_methods*)ptr)->subscribe_params} a a u -- n", "", "", "	( object ids n_ids -- )" );
	swigFunctionPointer( "c-funptr pw_node_methods-enum_params() {((struct pw_node_methods*)ptr)->enum_params} a n u u u a -- n", "", "", "	( object seq id start num filter -- )" );
	swigFunctionPointer( "c-funptr pw_node_methods-set_param() {((struct pw_node_methods*)ptr)->set_param} a u u a -- n", "", "", "	( object id flags param -- )" );
	swigFunctionPointer( "c-funptr pw_node_methods-send_command() {((struct pw_node_methods*)ptr)->send_command} a a -- n", "", "", "	( object command -- )" );
	swigFunctionPointer( "c-funptr pw_proxy_events-destroy() {((struct pw_proxy_events*)ptr)->destroy} a -- void", "", "", "	( data -- )" );
	swigFunctionPointer( "c-funptr pw_proxy_events-bound() {((struct pw_proxy_events*)ptr)->bound} a u -- void", "", "", "	( data global_id -- )" );
	swigFunctionPointer( "c-funptr pw_proxy_events-removed() {((struct pw_proxy_events*)ptr)->removed} a -- void", "", "", "	( data -- )" );
	swigFunctionPointer( "c-funptr pw_proxy_events-done() {((struct pw_proxy_events*)ptr)->done} a n -- void", "", "", "	( data seq -- )" );
	swigFunctionPointer( "c-funptr pw_proxy_events-error() {((struct pw_proxy_events*)ptr)->error} a n n s -- void", "", "", "	( data seq res message -- )" );
	swigFunctionPointer( "c-funptr pw_proxy_events-bound_props() {((struct pw_proxy_events*)ptr)->bound_props} a u a -- void", "", "", "	( data global_id props -- )" );
	swigFunctionPointer( "c-funptr pw_protocol_client-connect() {((struct pw_protocol_client*)ptr)->connect} a a a a -- n", "", "", "	( client props done_callback data -- )" );
	swigFunctionPointer( "c-funptr pw_protocol_client-connect_fd() {((struct pw_protocol_client*)ptr)->connect_fd} a n n -- n", "", "", "	( client fd close -- )" );
	swigFunctionPointer( "c-funptr pw_protocol_client-steal_fd() {((struct pw_protocol_client*)ptr)->steal_fd} a -- n", "", "", "	( client -- )" );
	swigFunctionPointer( "c-funptr pw_protocol_client-disconnect() {((struct pw_protocol_client*)ptr)->disconnect} a -- void", "", "", "	( client -- )" );
	swigFunctionPointer( "c-funptr pw_protocol_client-destroy() {((struct pw_protocol_client*)ptr)->destroy} a -- void", "", "", "	( client -- )" );
	swigFunctionPointer( "c-funptr pw_protocol_client-set_paused() {((struct pw_protocol_client*)ptr)->set_paused} a n -- n", "", "", "	( client paused -- )" );
	swigFunctionPointer( "c-funptr pw_protocol_server-destroy() {((struct pw_protocol_server*)ptr)->destroy} a -- void", "", "", "	( listen -- )" );
	swigFunctionPointer( "c-funptr pw_protocol_implementation-new_client() {((struct pw_protocol_implementation*)ptr)->new_client} a a a -- a", "", "", "	( protocol core props -- )" );
	swigFunctionPointer( "c-funptr pw_protocol_implementation-add_server() {((struct pw_protocol_implementation*)ptr)->add_server} a a a -- a", "", "", "	( protocol core props -- )" );
	swigFunctionPointer( "c-funptr pw_protocol_events-destroy() {((struct pw_protocol_events*)ptr)->destroy} a -- void", "", "", "	( data -- )" );
	swigFunctionPointer( "c-funptr pw_port_events-info() {((struct pw_port_events*)ptr)->info} a a -- void", "", "", "	( data info -- )" );
	swigFunctionPointer( "c-funptr pw_port_events-param() {((struct pw_port_events*)ptr)->param} a n u u u a -- void", "", "", "	( data seq id index next param -- )" );
	swigFunctionPointer( "c-funptr pw_port_methods-add_listener() {((struct pw_port_methods*)ptr)->add_listener} a a a a -- n", "", "", "	( object listener events data -- )" );
	swigFunctionPointer( "c-funptr pw_port_methods-subscribe_params() {((struct pw_port_methods*)ptr)->subscribe_params} a a u -- n", "", "", "	( object ids n_ids -- )" );
	swigFunctionPointer( "c-funptr pw_port_methods-enum_params() {((struct pw_port_methods*)ptr)->enum_params} a n u u u a -- n", "", "", "	( object seq id start num filter -- )" );
	swigFunctionPointer( "c-funptr pw_stream_events-destroy() {((struct pw_stream_events*)ptr)->destroy} a -- void", "", "", "	( data -- )" );
	swigFunctionPointer( "c-funptr pw_stream_events-state_changed() {((struct pw_stream_events*)ptr)->state_changed} a n n s -- void", "", "", "	( data old state error -- )" );
	swigFunctionPointer( "c-funptr pw_stream_events-control_info() {((struct pw_stream_events*)ptr)->control_info} a u a -- void", "", "", "	( data id control -- )" );
	swigFunctionPointer( "c-funptr pw_stream_events-io_changed() {((struct pw_stream_events*)ptr)->io_changed} a u a u -- void", "", "", "	( data id area size -- )" );
	swigFunctionPointer( "c-funptr pw_stream_events-param_changed() {((struct pw_stream_events*)ptr)->param_changed} a u a -- void", "", "", "	( data id param -- )" );
	swigFunctionPointer( "c-funptr pw_stream_events-add_buffer() {((struct pw_stream_events*)ptr)->add_buffer} a a -- void", "", "", "	( data buffer -- )" );
	swigFunctionPointer( "c-funptr pw_stream_events-remove_buffer() {((struct pw_stream_events*)ptr)->remove_buffer} a a -- void", "", "", "	( data buffer -- )" );
	swigFunctionPointer( "c-funptr pw_stream_events-process() {((struct pw_stream_events*)ptr)->process} a -- void", "", "", "	( data -- )" );
	swigFunctionPointer( "c-funptr pw_stream_events-drained() {((struct pw_stream_events*)ptr)->drained} a -- void", "", "", "	( data -- )" );
	swigFunctionPointer( "c-funptr pw_stream_events-command() {((struct pw_stream_events*)ptr)->command} a a -- void", "", "", "	( data command -- )" );
	swigFunctionPointer( "c-funptr pw_stream_events-trigger_done() {((struct pw_stream_events*)ptr)->trigger_done} a -- void", "", "", "	( data -- )" );
	swigFunctionPointer( "c-funptr pw_filter_events-destroy() {((struct pw_filter_events*)ptr)->destroy} a -- void", "", "", "	( data -- )" );
	swigFunctionPointer( "c-funptr pw_filter_events-state_changed() {((struct pw_filter_events*)ptr)->state_changed} a n n s -- void", "", "", "	( data old state error -- )" );
	swigFunctionPointer( "c-funptr pw_filter_events-io_changed() {((struct pw_filter_events*)ptr)->io_changed} a a u a u -- void", "", "", "	( data port_data id area size -- )" );
	swigFunctionPointer( "c-funptr pw_filter_events-param_changed() {((struct pw_filter_events*)ptr)->param_changed} a a u a -- void", "", "", "	( data port_data id param -- )" );
	swigFunctionPointer( "c-funptr pw_filter_events-add_buffer() {((struct pw_filter_events*)ptr)->add_buffer} a a a -- void", "", "", "	( data port_data buffer -- )" );
	swigFunctionPointer( "c-funptr pw_filter_events-remove_buffer() {((struct pw_filter_events*)ptr)->remove_buffer} a a a -- void", "", "", "	( data port_data buffer -- )" );
	swigFunctionPointer( "c-funptr pw_filter_events-process() {((struct pw_filter_events*)ptr)->process} a a -- void", "", "", "	( data position -- )" );
	swigFunctionPointer( "c-funptr pw_filter_events-drained() {((struct pw_filter_events*)ptr)->drained} a -- void", "", "", "	( data -- )" );
	swigFunctionPointer( "c-funptr pw_filter_events-command() {((struct pw_filter_events*)ptr)->command} a a -- void", "", "", "	( data command -- )" );
	swigFunctionPointer( "c-funptr pw_thread_loop_events-destroy() {((struct pw_thread_loop_events*)ptr)->destroy} a -- void", "", "", "	( data -- )" );
	swigFunctionPointer( "c-funptr pw_data_loop_events-destroy() {((struct pw_data_loop_events*)ptr)->destroy} a -- void", "", "", "	( data -- )" );
	swigFunctionPointer( "c-funptr spa_pod_builder_callbacks-overflow() {((struct spa_pod_builder_callbacks*)ptr)->overflow} a u -- n", "", "", "	( data size -- )" );

	swigNewline();

	swigComment("------===< callbacks >===-------\n");
	swigCallback( "c-callback pw_destroy_t: a -- void", "", "", "	( object -- )" );

	swigNewline();

	swigComment("------===< functions >===-------\n");
	swigFunction( "c-function pw_array_init pw_array_init a d -- void", "FUNCTION: pw_array_init ( arr extend -- void )", "EXTERN: \"C\" void pw_array_init( void * arr, long long extend );", "	( arr extend -- )" );
	swigFunction( "c-function pw_array_clear pw_array_clear a -- void", "FUNCTION: pw_array_clear ( arr -- void )", "EXTERN: \"C\" void pw_array_clear( void * arr );", "	( arr -- )" );
	swigFunction( "c-function pw_array_reset pw_array_reset a -- void", "FUNCTION: pw_array_reset ( arr -- void )", "EXTERN: \"C\" void pw_array_reset( void * arr );", "	( arr -- )" );
	swigFunction( "c-function pw_array_ensure_size pw_array_ensure_size a d -- n", "FUNCTION: pw_array_ensure_size ( arr size -- n )", "EXTERN: \"C\" int pw_array_ensure_size( void * arr, long long size );", "	( arr size -- )" );
	swigFunction( "c-function pw_array_add pw_array_add a d -- a", "FUNCTION: pw_array_add ( arr size -- a )", "EXTERN: \"C\" void * pw_array_add( void * arr, long long size );", "	( arr size -- )" );
	swigFunction( "c-function pw_array_add_fixed pw_array_add_fixed a d -- a", "FUNCTION: pw_array_add_fixed ( arr size -- a )", "EXTERN: \"C\" void * pw_array_add_fixed( void * arr, long long size );", "	( arr size -- )" );
	swigFunction( "c-function pw_client_info_update pw_client_info_update a a -- a", "FUNCTION: pw_client_info_update ( info update -- a )", "EXTERN: \"C\" void * pw_client_info_update( void * info, void * update );", "	( info update -- )" );
	swigFunction( "c-function pw_client_info_merge pw_client_info_merge a a n -- a", "FUNCTION: pw_client_info_merge ( info update reset -- a )", "EXTERN: \"C\" void * pw_client_info_merge( void * info, void * update, bool reset );", "	( info update reset -- )" );
	swigFunction( "c-function pw_client_info_free pw_client_info_free a -- void", "FUNCTION: pw_client_info_free ( info -- void )", "EXTERN: \"C\" void pw_client_info_free( void * info );", "	( info -- )" );
	swigFunction( "c-function pw_conf_load_conf_for_context pw_conf_load_conf_for_context a a -- n", "FUNCTION: pw_conf_load_conf_for_context ( props conf -- n )", "EXTERN: \"C\" int pw_conf_load_conf_for_context( void * props, void * conf );", "	( props conf -- )" );
	swigFunction( "c-function pw_conf_load_conf pw_conf_load_conf s s a -- n", "FUNCTION: pw_conf_load_conf ( prefix name conf -- n )", "EXTERN: \"C\" int pw_conf_load_conf( char * prefix, char * name, void * conf );", "	( prefix name conf -- )" );
	swigFunction( "c-function pw_conf_load_state pw_conf_load_state s s a -- n", "FUNCTION: pw_conf_load_state ( prefix name conf -- n )", "EXTERN: \"C\" int pw_conf_load_state( char * prefix, char * name, void * conf );", "	( prefix name conf -- )" );
	swigFunction( "c-function pw_conf_save_state pw_conf_save_state s s a -- n", "FUNCTION: pw_conf_save_state ( prefix name conf -- n )", "EXTERN: \"C\" int pw_conf_save_state( char * prefix, char * name, void * conf );", "	( prefix name conf -- )" );
	swigFunction( "c-function pw_conf_section_update_props pw_conf_section_update_props a s a -- n", "FUNCTION: pw_conf_section_update_props ( conf section props -- n )", "EXTERN: \"C\" int pw_conf_section_update_props( void * conf, char * section, void * props );", "	( conf section props -- )" );
	swigFunction( "c-function pw_conf_section_for_each pw_conf_section_for_each a s a a -- n", "FUNCTION: pw_conf_section_for_each ( conf section callback data -- n )", "EXTERN: \"C\" int pw_conf_section_for_each( void * conf, char * section, void * callback, void * data );", "	( conf section callback data -- )" );
	swigFunction( "c-function pw_conf_match_rules pw_conf_match_rules s d s a a a -- n", "FUNCTION: pw_conf_match_rules ( str len location props callback data -- n )", "EXTERN: \"C\" int pw_conf_match_rules( char * str, long long len, char * location, void * props, void * callback, void * data );", "	( str len location props callback data -- )" );
	swigFunction( "c-function pw_conf_section_match_rules pw_conf_section_match_rules a s a a a -- n", "FUNCTION: pw_conf_section_match_rules ( conf section props callback data -- n )", "EXTERN: \"C\" int pw_conf_section_match_rules( void * conf, char * section, void * props, void * callback, void * data );", "	( conf section props callback data -- )" );
	swigFunction( "c-function pw_context_new pw_context_new a a d -- a", "FUNCTION: pw_context_new ( main_loop props user_data_size -- a )", "EXTERN: \"C\" void * pw_context_new( void * main_loop, void * props, long long user_data_size );", "	( main_loop props user_data_size -- )" );
	swigFunction( "c-function pw_context_destroy pw_context_destroy a -- void", "FUNCTION: pw_context_destroy ( context -- void )", "EXTERN: \"C\" void pw_context_destroy( void * context );", "	( context -- )" );
	swigFunction( "c-function pw_context_get_user_data pw_context_get_user_data a -- a", "FUNCTION: pw_context_get_user_data ( context -- a )", "EXTERN: \"C\" void * pw_context_get_user_data( void * context );", "	( context -- )" );
	swigFunction( "c-function pw_context_add_listener pw_context_add_listener a a a a -- void", "FUNCTION: pw_context_add_listener ( context listener events data -- void )", "EXTERN: \"C\" void pw_context_add_listener( void * context, void * listener, void * events, void * data );", "	( context listener events data -- )" );
	swigFunction( "c-function pw_context_get_properties pw_context_get_properties a -- a", "FUNCTION: pw_context_get_properties ( context -- a )", "EXTERN: \"C\" void * pw_context_get_properties( void * context );", "	( context -- )" );
	swigFunction( "c-function pw_context_update_properties pw_context_update_properties a a -- n", "FUNCTION: pw_context_update_properties ( context dict -- n )", "EXTERN: \"C\" int pw_context_update_properties( void * context, void * dict );", "	( context dict -- )" );
	swigFunction( "c-function pw_context_get_conf_section pw_context_get_conf_section a s -- s", "FUNCTION: pw_context_get_conf_section ( context section -- s )", "EXTERN: \"C\" char * pw_context_get_conf_section( void * context, char * section );", "	( context section -- )" );
	swigFunction( "c-function pw_context_parse_conf_section pw_context_parse_conf_section a a s -- n", "FUNCTION: pw_context_parse_conf_section ( context conf section -- n )", "EXTERN: \"C\" int pw_context_parse_conf_section( void * context, void * conf, char * section );", "	( context conf section -- )" );
	swigFunction( "c-function pw_context_conf_update_props pw_context_conf_update_props a s a -- n", "FUNCTION: pw_context_conf_update_props ( context section props -- n )", "EXTERN: \"C\" int pw_context_conf_update_props( void * context, char * section, void * props );", "	( context section props -- )" );
	swigFunction( "c-function pw_context_conf_section_for_each pw_context_conf_section_for_each a s a a -- n", "FUNCTION: pw_context_conf_section_for_each ( context section callback data -- n )", "EXTERN: \"C\" int pw_context_conf_section_for_each( void * context, char * section, void * callback, void * data );", "	( context section callback data -- )" );
	swigFunction( "c-function pw_context_conf_section_match_rules pw_context_conf_section_match_rules a s a a a -- n", "FUNCTION: pw_context_conf_section_match_rules ( context section props callback data -- n )", "EXTERN: \"C\" int pw_context_conf_section_match_rules( void * context, char * section, void * props, void * callback, void * data );", "	( context section props callback data -- )" );
	swigFunction( "c-function pw_context_get_support pw_context_get_support a a -- a", "FUNCTION: pw_context_get_support ( context n_support -- a )", "EXTERN: \"C\" void * pw_context_get_support( void * context, void * n_support );", "	( context n_support -- )" );
	swigFunction( "c-function pw_context_get_main_loop pw_context_get_main_loop a -- a", "FUNCTION: pw_context_get_main_loop ( context -- a )", "EXTERN: \"C\" void * pw_context_get_main_loop( void * context );", "	( context -- )" );
	swigFunction( "c-function pw_context_get_data_loop pw_context_get_data_loop a -- a", "FUNCTION: pw_context_get_data_loop ( context -- a )", "EXTERN: \"C\" void * pw_context_get_data_loop( void * context );", "	( context -- )" );
	swigFunction( "c-function pw_context_get_work_queue pw_context_get_work_queue a -- a", "FUNCTION: pw_context_get_work_queue ( context -- a )", "EXTERN: \"C\" void * pw_context_get_work_queue( void * context );", "	( context -- )" );
	swigFunction( "c-function pw_context_get_mempool pw_context_get_mempool a -- a", "FUNCTION: pw_context_get_mempool ( context -- a )", "EXTERN: \"C\" void * pw_context_get_mempool( void * context );", "	( context -- )" );
	swigFunction( "c-function pw_context_for_each_global pw_context_for_each_global a a a -- n", "FUNCTION: pw_context_for_each_global ( context callback data -- n )", "EXTERN: \"C\" int pw_context_for_each_global( void * context, void * callback, void * data );", "	( context callback data -- )" );
	swigFunction( "c-function pw_context_find_global pw_context_find_global a u -- a", "FUNCTION: pw_context_find_global ( context id -- a )", "EXTERN: \"C\" void * pw_context_find_global( void * context, int id );", "	( context id -- )" );
	swigFunction( "c-function pw_context_add_spa_lib pw_context_add_spa_lib a s s -- n", "FUNCTION: pw_context_add_spa_lib ( context factory_regex lib -- n )", "EXTERN: \"C\" int pw_context_add_spa_lib( void * context, char * factory_regex, char * lib );", "	( context factory_regex lib -- )" );
	swigFunction( "c-function pw_context_find_spa_lib pw_context_find_spa_lib a s -- s", "FUNCTION: pw_context_find_spa_lib ( context factory_name -- s )", "EXTERN: \"C\" char * pw_context_find_spa_lib( void * context, char * factory_name );", "	( context factory_name -- )" );
	swigFunction( "c-function pw_context_load_spa_handle pw_context_load_spa_handle a s a -- a", "FUNCTION: pw_context_load_spa_handle ( context factory_name info -- a )", "EXTERN: \"C\" void * pw_context_load_spa_handle( void * context, char * factory_name, void * info );", "	( context factory_name info -- )" );
	swigFunction( "c-function pw_context_register_export_type pw_context_register_export_type a a -- n", "FUNCTION: pw_context_register_export_type ( context type -- n )", "EXTERN: \"C\" int pw_context_register_export_type( void * context, void * type );", "	( context type -- )" );
	swigFunction( "c-function pw_context_find_export_type pw_context_find_export_type a s -- a", "FUNCTION: pw_context_find_export_type ( context type -- a )", "EXTERN: \"C\" void * pw_context_find_export_type( void * context, char * type );", "	( context type -- )" );
	swigFunction( "c-function pw_context_set_object pw_context_set_object a s a -- n", "FUNCTION: pw_context_set_object ( context type value -- n )", "EXTERN: \"C\" int pw_context_set_object( void * context, char * type, void * value );", "	( context type value -- )" );
	swigFunction( "c-function pw_context_get_object pw_context_get_object a s -- a", "FUNCTION: pw_context_get_object ( context type -- a )", "EXTERN: \"C\" void * pw_context_get_object( void * context, char * type );", "	( context type -- )" );
	swigFunction( "c-function pw_device_info_update pw_device_info_update a a -- a", "FUNCTION: pw_device_info_update ( info update -- a )", "EXTERN: \"C\" void * pw_device_info_update( void * info, void * update );", "	( info update -- )" );
	swigFunction( "c-function pw_device_info_merge pw_device_info_merge a a n -- a", "FUNCTION: pw_device_info_merge ( info update reset -- a )", "EXTERN: \"C\" void * pw_device_info_merge( void * info, void * update, bool reset );", "	( info update reset -- )" );
	swigFunction( "c-function pw_device_info_free pw_device_info_free a -- void", "FUNCTION: pw_device_info_free ( info -- void )", "EXTERN: \"C\" void pw_device_info_free( void * info );", "	( info -- )" );
	swigFunction( "c-function pw_buffers_negotiate pw_buffers_negotiate a u a u a u a -- n", "FUNCTION: pw_buffers_negotiate ( context flags outnode out_port_id innode in_port_id result -- n )", "EXTERN: \"C\" int pw_buffers_negotiate( void * context, int flags, void * outnode, int out_port_id, void * innode, int in_port_id, void * result );", "	( context flags outnode out_port_id innode in_port_id result -- )" );
	swigFunction( "c-function pw_buffers_clear pw_buffers_clear a -- void", "FUNCTION: pw_buffers_clear ( buffers -- void )", "EXTERN: \"C\" void pw_buffers_clear( void * buffers );", "	( buffers -- )" );
	swigFunction( "c-function pw_core_info_update pw_core_info_update a a -- a", "FUNCTION: pw_core_info_update ( info update -- a )", "EXTERN: \"C\" void * pw_core_info_update( void * info, void * update );", "	( info update -- )" );
	swigFunction( "c-function pw_core_info_merge pw_core_info_merge a a n -- a", "FUNCTION: pw_core_info_merge ( info update reset -- a )", "EXTERN: \"C\" void * pw_core_info_merge( void * info, void * update, bool reset );", "	( info update reset -- )" );
	swigFunction( "c-function pw_core_info_free pw_core_info_free a -- void", "FUNCTION: pw_core_info_free ( info -- void )", "EXTERN: \"C\" void pw_core_info_free( void * info );", "	( info -- )" );
	swigFunction( "c-function pw_core_errorv pw_core_errorv a u n n s a -- n", "FUNCTION: pw_core_errorv ( core id seq res message args -- n )", "EXTERN: \"C\" int pw_core_errorv( void * core, int id, int seq, int res, char * message, void * args );", "	( core id seq res message args -- )" );
	swigFunction( "c-function pw_core_errorf pw_core_errorf a u n n s ... -- n", "FUNCTION: pw_core_errorf ( core id seq res message  -- n )", "EXTERN: \"C\" int pw_core_errorf( void * core, int id, int seq, int res, char * message, ...  );", "	( core id seq res message <noname> -- )" );
	swigFunction( "c-function pw_core_get_registry pw_core_get_registry a u d -- a", "FUNCTION: pw_core_get_registry ( core version user_data_size -- a )", "EXTERN: \"C\" void * pw_core_get_registry( void * core, int version, long long user_data_size );", "	( core version user_data_size -- )" );
	swigFunction( "c-function pw_core_create_object pw_core_create_object a s s u a d -- a", "FUNCTION: pw_core_create_object ( core factory_name type version props user_data_size -- a )", "EXTERN: \"C\" void * pw_core_create_object( void * core, char * factory_name, char * type, int version, void * props, long long user_data_size );", "	( core factory_name type version props user_data_size -- )" );
	swigFunction( "c-function pw_registry_bind pw_registry_bind a u s u d -- a", "FUNCTION: pw_registry_bind ( registry id type version user_data_size -- a )", "EXTERN: \"C\" void * pw_registry_bind( void * registry, int id, char * type, int version, long long user_data_size );", "	( registry id type version user_data_size -- )" );
	swigFunction( "c-function pw_context_connect pw_context_connect a a d -- a", "FUNCTION: pw_context_connect ( context properties user_data_size -- a )", "EXTERN: \"C\" void * pw_context_connect( void * context, void * properties, long long user_data_size );", "	( context properties user_data_size -- )" );
	swigFunction( "c-function pw_context_connect_fd pw_context_connect_fd a n a d -- a", "FUNCTION: pw_context_connect_fd ( context fd properties user_data_size -- a )", "EXTERN: \"C\" void * pw_context_connect_fd( void * context, int fd, void * properties, long long user_data_size );", "	( context fd properties user_data_size -- )" );
	swigFunction( "c-function pw_context_connect_self pw_context_connect_self a a d -- a", "FUNCTION: pw_context_connect_self ( context properties user_data_size -- a )", "EXTERN: \"C\" void * pw_context_connect_self( void * context, void * properties, long long user_data_size );", "	( context properties user_data_size -- )" );
	swigFunction( "c-function pw_core_steal_fd pw_core_steal_fd a -- n", "FUNCTION: pw_core_steal_fd ( core -- n )", "EXTERN: \"C\" int pw_core_steal_fd( void * core );", "	( core -- )" );
	swigFunction( "c-function pw_core_set_paused pw_core_set_paused a n -- n", "FUNCTION: pw_core_set_paused ( core paused -- n )", "EXTERN: \"C\" int pw_core_set_paused( void * core, bool paused );", "	( core paused -- )" );
	swigFunction( "c-function pw_core_disconnect pw_core_disconnect a -- n", "FUNCTION: pw_core_disconnect ( core -- n )", "EXTERN: \"C\" int pw_core_disconnect( void * core );", "	( core -- )" );
	swigFunction( "c-function pw_core_get_user_data pw_core_get_user_data a -- a", "FUNCTION: pw_core_get_user_data ( core -- a )", "EXTERN: \"C\" void * pw_core_get_user_data( void * core );", "	( core -- )" );
	swigFunction( "c-function pw_core_get_client pw_core_get_client a -- a", "FUNCTION: pw_core_get_client ( core -- a )", "EXTERN: \"C\" void * pw_core_get_client( void * core );", "	( core -- )" );
	swigFunction( "c-function pw_core_get_context pw_core_get_context a -- a", "FUNCTION: pw_core_get_context ( core -- a )", "EXTERN: \"C\" void * pw_core_get_context( void * core );", "	( core -- )" );
	swigFunction( "c-function pw_core_get_properties pw_core_get_properties a -- a", "FUNCTION: pw_core_get_properties ( core -- a )", "EXTERN: \"C\" void * pw_core_get_properties( void * core );", "	( core -- )" );
	swigFunction( "c-function pw_core_update_properties pw_core_update_properties a a -- n", "FUNCTION: pw_core_update_properties ( core dict -- n )", "EXTERN: \"C\" int pw_core_update_properties( void * core, void * dict );", "	( core dict -- )" );
	swigFunction( "c-function pw_core_get_mempool pw_core_get_mempool a -- a", "FUNCTION: pw_core_get_mempool ( core -- a )", "EXTERN: \"C\" void * pw_core_get_mempool( void * core );", "	( core -- )" );
	swigFunction( "c-function pw_core_find_proxy pw_core_find_proxy a u -- a", "FUNCTION: pw_core_find_proxy ( core id -- a )", "EXTERN: \"C\" void * pw_core_find_proxy( void * core, int id );", "	( core id -- )" );
	swigFunction( "c-function pw_core_export pw_core_export a s a a d -- a", "FUNCTION: pw_core_export ( core type props object user_data_size -- a )", "EXTERN: \"C\" void * pw_core_export( void * core, char * type, void * props, void * object, long long user_data_size );", "	( core type props object user_data_size -- )" );
	swigFunction( "c-function pw_factory_info_update pw_factory_info_update a a -- a", "FUNCTION: pw_factory_info_update ( info update -- a )", "EXTERN: \"C\" void * pw_factory_info_update( void * info, void * update );", "	( info update -- )" );
	swigFunction( "c-function pw_factory_info_merge pw_factory_info_merge a a n -- a", "FUNCTION: pw_factory_info_merge ( info update reset -- a )", "EXTERN: \"C\" void * pw_factory_info_merge( void * info, void * update, bool reset );", "	( info update reset -- )" );
	swigFunction( "c-function pw_factory_info_free pw_factory_info_free a -- void", "FUNCTION: pw_factory_info_free ( info -- void )", "EXTERN: \"C\" void pw_factory_info_free( void * info );", "	( info -- )" );
	swigFunction( "c-function pw_log_set pw_log_set a -- void", "FUNCTION: pw_log_set ( log -- void )", "EXTERN: \"C\" void pw_log_set( void * log );", "	( log -- )" );
	swigFunction( "c-function pw_log_get pw_log_get  -- a", "FUNCTION: pw_log_get (  -- a )", "EXTERN: \"C\" void * pw_log_get(  );", "	( -- )" );
	swigFunction( "c-function pw_log_set_level pw_log_set_level n -- void", "FUNCTION: pw_log_set_level ( level -- void )", "EXTERN: \"C\" void pw_log_set_level( int level );", "	( level -- )" );
	swigFunction( "c-function pw_log_logt pw_log_logt n a s n s s ... -- void", "FUNCTION: pw_log_logt ( level topic file line func fmt  -- void )", "EXTERN: \"C\" void pw_log_logt( int level, void * topic, char * file, int line, char * func, char * fmt, ...  );", "	( level topic file line func fmt <noname> -- )" );
	swigFunction( "c-function pw_log_logtv pw_log_logtv n a s n s s a -- void", "FUNCTION: pw_log_logtv ( level topic file line func fmt args -- void )", "EXTERN: \"C\" void pw_log_logtv( int level, void * topic, char * file, int line, char * func, char * fmt, void * args );", "	( level topic file line func fmt args -- )" );
	swigFunction( "c-function pw_log_log pw_log_log n s n s s ... -- void", "FUNCTION: pw_log_log ( level file line func fmt  -- void )", "EXTERN: \"C\" void pw_log_log( int level, char * file, int line, char * func, char * fmt, ...  );", "	( level file line func fmt <noname> -- )" );
	swigFunction( "c-function pw_log_logv pw_log_logv n s n s s a -- void", "FUNCTION: pw_log_logv ( level file line func fmt args -- void )", "EXTERN: \"C\" void pw_log_logv( int level, char * file, int line, char * func, char * fmt, void * args );", "	( level file line func fmt args -- )" );
	swigFunction( "c-function pw_loop_new pw_loop_new a -- a", "FUNCTION: pw_loop_new ( props -- a )", "EXTERN: \"C\" void * pw_loop_new( void * props );", "	( props -- )" );
	swigFunction( "c-function pw_loop_destroy pw_loop_destroy a -- void", "FUNCTION: pw_loop_destroy ( loop -- void )", "EXTERN: \"C\" void pw_loop_destroy( void * loop );", "	( loop -- )" );
	swigFunction( "c-function pw_link_state_as_string pw_link_state_as_string n -- s", "FUNCTION: pw_link_state_as_string ( state -- s )", "EXTERN: \"C\" char * pw_link_state_as_string( int state );", "	( state -- )" );
	swigFunction( "c-function pw_link_info_update pw_link_info_update a a -- a", "FUNCTION: pw_link_info_update ( info update -- a )", "EXTERN: \"C\" void * pw_link_info_update( void * info, void * update );", "	( info update -- )" );
	swigFunction( "c-function pw_link_info_merge pw_link_info_merge a a n -- a", "FUNCTION: pw_link_info_merge ( info update reset -- a )", "EXTERN: \"C\" void * pw_link_info_merge( void * info, void * update, bool reset );", "	( info update reset -- )" );
	swigFunction( "c-function pw_link_info_free pw_link_info_free a -- void", "FUNCTION: pw_link_info_free ( info -- void )", "EXTERN: \"C\" void pw_link_info_free( void * info );", "	( info -- )" );
	swigFunction( "c-function pw_main_loop_new pw_main_loop_new a -- a", "FUNCTION: pw_main_loop_new ( props -- a )", "EXTERN: \"C\" void * pw_main_loop_new( void * props );", "	( props -- )" );
	swigFunction( "c-function pw_main_loop_add_listener pw_main_loop_add_listener a a a a -- void", "FUNCTION: pw_main_loop_add_listener ( loop listener events data -- void )", "EXTERN: \"C\" void pw_main_loop_add_listener( void * loop, void * listener, void * events, void * data );", "	( loop listener events data -- )" );
	swigFunction( "c-function pw_main_loop_get_loop pw_main_loop_get_loop a -- a", "FUNCTION: pw_main_loop_get_loop ( loop -- a )", "EXTERN: \"C\" void * pw_main_loop_get_loop( void * loop );", "	( loop -- )" );
	swigFunction( "c-function pw_main_loop_destroy pw_main_loop_destroy a -- void", "FUNCTION: pw_main_loop_destroy ( loop -- void )", "EXTERN: \"C\" void pw_main_loop_destroy( void * loop );", "	( loop -- )" );
	swigFunction( "c-function pw_main_loop_run pw_main_loop_run a -- n", "FUNCTION: pw_main_loop_run ( loop -- n )", "EXTERN: \"C\" int pw_main_loop_run( void * loop );", "	( loop -- )" );
	swigFunction( "c-function pw_main_loop_quit pw_main_loop_quit a -- n", "FUNCTION: pw_main_loop_quit ( loop -- n )", "EXTERN: \"C\" int pw_main_loop_quit( void * loop );", "	( loop -- )" );
	swigFunction( "c-function pw_map_init pw_map_init a d d -- void", "FUNCTION: pw_map_init ( map size extend -- void )", "EXTERN: \"C\" void pw_map_init( void * map, long long size, long long extend );", "	( map size extend -- )" );
	swigFunction( "c-function pw_map_clear pw_map_clear a -- void", "FUNCTION: pw_map_clear ( map -- void )", "EXTERN: \"C\" void pw_map_clear( void * map );", "	( map -- )" );
	swigFunction( "c-function pw_map_reset pw_map_reset a -- void", "FUNCTION: pw_map_reset ( map -- void )", "EXTERN: \"C\" void pw_map_reset( void * map );", "	( map -- )" );
	swigFunction( "c-function pw_map_insert_new pw_map_insert_new a a -- u", "FUNCTION: pw_map_insert_new ( map data -- u )", "EXTERN: \"C\" int pw_map_insert_new( void * map, void * data );", "	( map data -- )" );
	swigFunction( "c-function pw_map_insert_at pw_map_insert_at a u a -- n", "FUNCTION: pw_map_insert_at ( map id data -- n )", "EXTERN: \"C\" int pw_map_insert_at( void * map, int id, void * data );", "	( map id data -- )" );
	swigFunction( "c-function pw_map_remove pw_map_remove a u -- void", "FUNCTION: pw_map_remove ( map id -- void )", "EXTERN: \"C\" void pw_map_remove( void * map, int id );", "	( map id -- )" );
	swigFunction( "c-function pw_map_lookup pw_map_lookup a u -- a", "FUNCTION: pw_map_lookup ( map id -- a )", "EXTERN: \"C\" void * pw_map_lookup( void * map, int id );", "	( map id -- )" );
	swigFunction( "c-function pw_map_for_each pw_map_for_each a a a -- n", "FUNCTION: pw_map_for_each ( map func data -- n )", "EXTERN: \"C\" int pw_map_for_each( void * map, void * func, void * data );", "	( map func data -- )" );
	swigFunction( "c-function pw_mempool_new pw_mempool_new a -- a", "FUNCTION: pw_mempool_new ( props -- a )", "EXTERN: \"C\" void * pw_mempool_new( void * props );", "	( props -- )" );
	swigFunction( "c-function pw_mempool_add_listener pw_mempool_add_listener a a a a -- void", "FUNCTION: pw_mempool_add_listener ( pool listener events data -- void )", "EXTERN: \"C\" void pw_mempool_add_listener( void * pool, void * listener, void * events, void * data );", "	( pool listener events data -- )" );
	swigFunction( "c-function pw_mempool_clear pw_mempool_clear a -- void", "FUNCTION: pw_mempool_clear ( pool -- void )", "EXTERN: \"C\" void pw_mempool_clear( void * pool );", "	( pool -- )" );
	swigFunction( "c-function pw_mempool_destroy pw_mempool_destroy a -- void", "FUNCTION: pw_mempool_destroy ( pool -- void )", "EXTERN: \"C\" void pw_mempool_destroy( void * pool );", "	( pool -- )" );
	swigFunction( "c-function pw_mempool_alloc pw_mempool_alloc a n u d -- a", "FUNCTION: pw_mempool_alloc ( pool flags type size -- a )", "EXTERN: \"C\" void * pw_mempool_alloc( void * pool, int flags, int type, long long size );", "	( pool flags type size -- )" );
	swigFunction( "c-function pw_mempool_import_block pw_mempool_import_block a a -- a", "FUNCTION: pw_mempool_import_block ( pool mem -- a )", "EXTERN: \"C\" void * pw_mempool_import_block( void * pool, void * mem );", "	( pool mem -- )" );
	swigFunction( "c-function pw_mempool_import pw_mempool_import a n u n -- a", "FUNCTION: pw_mempool_import ( pool flags type fd -- a )", "EXTERN: \"C\" void * pw_mempool_import( void * pool, int flags, int type, int fd );", "	( pool flags type fd -- )" );
	swigFunction( "c-function pw_memblock_free pw_memblock_free a -- void", "FUNCTION: pw_memblock_free ( mem -- void )", "EXTERN: \"C\" void pw_memblock_free( void * mem );", "	( mem -- )" );
	swigFunction( "c-function pw_memblock_unref pw_memblock_unref a -- void", "FUNCTION: pw_memblock_unref ( mem -- void )", "EXTERN: \"C\" void pw_memblock_unref( void * mem );", "	( mem -- )" );
	swigFunction( "c-function pw_mempool_remove_id pw_mempool_remove_id a u -- n", "FUNCTION: pw_mempool_remove_id ( pool id -- n )", "EXTERN: \"C\" int pw_mempool_remove_id( void * pool, int id );", "	( pool id -- )" );
	swigFunction( "c-function pw_mempool_find_ptr pw_mempool_find_ptr a a -- a", "FUNCTION: pw_mempool_find_ptr ( pool ptr -- a )", "EXTERN: \"C\" void * pw_mempool_find_ptr( void * pool, void * ptr );", "	( pool ptr -- )" );
	swigFunction( "c-function pw_mempool_find_id pw_mempool_find_id a u -- a", "FUNCTION: pw_mempool_find_id ( pool id -- a )", "EXTERN: \"C\" void * pw_mempool_find_id( void * pool, int id );", "	( pool id -- )" );
	swigFunction( "c-function pw_mempool_find_fd pw_mempool_find_fd a n -- a", "FUNCTION: pw_mempool_find_fd ( pool fd -- a )", "EXTERN: \"C\" void * pw_mempool_find_fd( void * pool, int fd );", "	( pool fd -- )" );
	swigFunction( "c-function pw_memblock_map pw_memblock_map a n u u a -- a", "FUNCTION: pw_memblock_map ( block flags offset size tag -- a )", "EXTERN: \"C\" void * pw_memblock_map( void * block, int flags, int offset, int size, void * tag );", "	( block flags offset size tag -- )" );
	swigFunction( "c-function pw_mempool_map_id pw_mempool_map_id a u n u u a -- a", "FUNCTION: pw_mempool_map_id ( pool id flags offset size tag -- a )", "EXTERN: \"C\" void * pw_mempool_map_id( void * pool, int id, int flags, int offset, int size, void * tag );", "	( pool id flags offset size tag -- )" );
	swigFunction( "c-function pw_mempool_import_map pw_mempool_import_map a a a u a -- a", "FUNCTION: pw_mempool_import_map ( pool other data size tag -- a )", "EXTERN: \"C\" void * pw_mempool_import_map( void * pool, void * other, void * data, int size, void * tag );", "	( pool other data size tag -- )" );
	swigFunction( "c-function pw_mempool_find_tag pw_mempool_find_tag a a d -- a", "FUNCTION: pw_mempool_find_tag ( pool tag size -- a )", "EXTERN: \"C\" void * pw_mempool_find_tag( void * pool, void * tag, long long size );", "	( pool tag size -- )" );
	swigFunction( "c-function pw_memmap_free pw_memmap_free a -- n", "FUNCTION: pw_memmap_free ( map -- n )", "EXTERN: \"C\" int pw_memmap_free( void * map );", "	( map -- )" );
	swigFunction( "c-function pw_map_range_init pw_map_range_init a u u u -- void", "FUNCTION: pw_map_range_init ( range offset size page_size -- void )", "EXTERN: \"C\" void pw_map_range_init( void * range, int offset, int size, int page_size );", "	( range offset size page_size -- )" );
	swigFunction( "c-function pw_module_info_update pw_module_info_update a a -- a", "FUNCTION: pw_module_info_update ( info update -- a )", "EXTERN: \"C\" void * pw_module_info_update( void * info, void * update );", "	( info update -- )" );
	swigFunction( "c-function pw_module_info_merge pw_module_info_merge a a n -- a", "FUNCTION: pw_module_info_merge ( info update reset -- a )", "EXTERN: \"C\" void * pw_module_info_merge( void * info, void * update, bool reset );", "	( info update reset -- )" );
	swigFunction( "c-function pw_module_info_free pw_module_info_free a -- void", "FUNCTION: pw_module_info_free ( info -- void )", "EXTERN: \"C\" void pw_module_info_free( void * info );", "	( info -- )" );
	swigFunction( "c-function pw_node_state_as_string pw_node_state_as_string n -- s", "FUNCTION: pw_node_state_as_string ( state -- s )", "EXTERN: \"C\" char * pw_node_state_as_string( int state );", "	( state -- )" );
	swigFunction( "c-function pw_node_info_update pw_node_info_update a a -- a", "FUNCTION: pw_node_info_update ( info update -- a )", "EXTERN: \"C\" void * pw_node_info_update( void * info, void * update );", "	( info update -- )" );
	swigFunction( "c-function pw_node_info_merge pw_node_info_merge a a n -- a", "FUNCTION: pw_node_info_merge ( info update reset -- a )", "EXTERN: \"C\" void * pw_node_info_merge( void * info, void * update, bool reset );", "	( info update reset -- )" );
	swigFunction( "c-function pw_node_info_free pw_node_info_free a -- void", "FUNCTION: pw_node_info_free ( info -- void )", "EXTERN: \"C\" void pw_node_info_free( void * info );", "	( info -- )" );
	swigFunction( "c-function pw_properties_new pw_properties_new s ... -- a", "FUNCTION: pw_properties_new ( key  -- a )", "EXTERN: \"C\" void * pw_properties_new( char * key, ...  );", "	( key <noname> -- )" );
	swigFunction( "c-function pw_properties_new_dict pw_properties_new_dict a -- a", "FUNCTION: pw_properties_new_dict ( dict -- a )", "EXTERN: \"C\" void * pw_properties_new_dict( void * dict );", "	( dict -- )" );
	swigFunction( "c-function pw_properties_new_string pw_properties_new_string s -- a", "FUNCTION: pw_properties_new_string ( args -- a )", "EXTERN: \"C\" void * pw_properties_new_string( char * args );", "	( args -- )" );
	swigFunction( "c-function pw_properties_copy pw_properties_copy a -- a", "FUNCTION: pw_properties_copy ( properties -- a )", "EXTERN: \"C\" void * pw_properties_copy( void * properties );", "	( properties -- )" );
	swigFunction( "c-function pw_properties_update_keys pw_properties_update_keys a a a -- n", "FUNCTION: pw_properties_update_keys ( props dict keys -- n )", "EXTERN: \"C\" int pw_properties_update_keys( void * props, void * dict, void * keys );", "	( props dict keys -- )" );
	swigFunction( "c-function pw_properties_update_ignore pw_properties_update_ignore a a a -- n", "FUNCTION: pw_properties_update_ignore ( props dict ignore -- n )", "EXTERN: \"C\" int pw_properties_update_ignore( void * props, void * dict, void * ignore );", "	( props dict ignore -- )" );
	swigFunction( "c-function pw_properties_update pw_properties_update a a -- n", "FUNCTION: pw_properties_update ( props dict -- n )", "EXTERN: \"C\" int pw_properties_update( void * props, void * dict );", "	( props dict -- )" );
	swigFunction( "c-function pw_properties_update_string pw_properties_update_string a s d -- n", "FUNCTION: pw_properties_update_string ( props str size -- n )", "EXTERN: \"C\" int pw_properties_update_string( void * props, char * str, long long size );", "	( props str size -- )" );
	swigFunction( "c-function pw_properties_add pw_properties_add a a -- n", "FUNCTION: pw_properties_add ( oldprops dict -- n )", "EXTERN: \"C\" int pw_properties_add( void * oldprops, void * dict );", "	( oldprops dict -- )" );
	swigFunction( "c-function pw_properties_add_keys pw_properties_add_keys a a a -- n", "FUNCTION: pw_properties_add_keys ( oldprops dict keys -- n )", "EXTERN: \"C\" int pw_properties_add_keys( void * oldprops, void * dict, void * keys );", "	( oldprops dict keys -- )" );
	swigFunction( "c-function pw_properties_clear pw_properties_clear a -- void", "FUNCTION: pw_properties_clear ( properties -- void )", "EXTERN: \"C\" void pw_properties_clear( void * properties );", "	( properties -- )" );
	swigFunction( "c-function pw_properties_free pw_properties_free a -- void", "FUNCTION: pw_properties_free ( properties -- void )", "EXTERN: \"C\" void pw_properties_free( void * properties );", "	( properties -- )" );
	swigFunction( "c-function pw_properties_set pw_properties_set a s s -- n", "FUNCTION: pw_properties_set ( properties key value -- n )", "EXTERN: \"C\" int pw_properties_set( void * properties, char * key, char * value );", "	( properties key value -- )" );
	swigFunction( "c-function pw_properties_setf pw_properties_setf a s s ... -- n", "FUNCTION: pw_properties_setf ( properties key format  -- n )", "EXTERN: \"C\" int pw_properties_setf( void * properties, char * key, char * format, ...  );", "	( properties key format <noname> -- )" );
	swigFunction( "c-function pw_properties_setva pw_properties_setva a s s a -- n", "FUNCTION: pw_properties_setva ( properties key format args -- n )", "EXTERN: \"C\" int pw_properties_setva( void * properties, char * key, char * format, void * args );", "	( properties key format args -- )" );
	swigFunction( "c-function pw_properties_get pw_properties_get a s -- s", "FUNCTION: pw_properties_get ( properties key -- s )", "EXTERN: \"C\" char * pw_properties_get( void * properties, char * key );", "	( properties key -- )" );
	swigFunction( "c-function pw_properties_fetch_uint32 pw_properties_fetch_uint32 a s a -- n", "FUNCTION: pw_properties_fetch_uint32 ( properties key value -- n )", "EXTERN: \"C\" int pw_properties_fetch_uint32( void * properties, char * key, void * value );", "	( properties key value -- )" );
	swigFunction( "c-function pw_properties_fetch_int32 pw_properties_fetch_int32 a s a -- n", "FUNCTION: pw_properties_fetch_int32 ( properties key value -- n )", "EXTERN: \"C\" int pw_properties_fetch_int32( void * properties, char * key, void * value );", "	( properties key value -- )" );
	swigFunction( "c-function pw_properties_fetch_uint64 pw_properties_fetch_uint64 a s a -- n", "FUNCTION: pw_properties_fetch_uint64 ( properties key value -- n )", "EXTERN: \"C\" int pw_properties_fetch_uint64( void * properties, char * key, void * value );", "	( properties key value -- )" );
	swigFunction( "c-function pw_properties_fetch_int64 pw_properties_fetch_int64 a s a -- n", "FUNCTION: pw_properties_fetch_int64 ( properties key value -- n )", "EXTERN: \"C\" int pw_properties_fetch_int64( void * properties, char * key, void * value );", "	( properties key value -- )" );
	swigFunction( "c-function pw_properties_fetch_bool pw_properties_fetch_bool a s a -- n", "FUNCTION: pw_properties_fetch_bool ( properties key value -- n )", "EXTERN: \"C\" int pw_properties_fetch_bool( void * properties, char * key, void * value );", "	( properties key value -- )" );
	swigFunction( "c-function pw_properties_get_uint32 pw_properties_get_uint32 a s u -- u", "FUNCTION: pw_properties_get_uint32 ( properties key deflt -- u )", "EXTERN: \"C\" int pw_properties_get_uint32( void * properties, char * key, int deflt );", "	( properties key deflt -- )" );
	swigFunction( "c-function pw_properties_get_int32 pw_properties_get_int32 a s n -- n", "FUNCTION: pw_properties_get_int32 ( properties key deflt -- n )", "EXTERN: \"C\" int pw_properties_get_int32( void * properties, char * key, int deflt );", "	( properties key deflt -- )" );
	swigFunction( "c-function pw_properties_get_uint64 pw_properties_get_uint64 a s n -- n", "FUNCTION: pw_properties_get_uint64 ( properties key deflt -- n )", "EXTERN: \"C\" long pw_properties_get_uint64( void * properties, char * key, long deflt );", "	( properties key deflt -- )" );
	swigFunction( "c-function pw_properties_get_int64 pw_properties_get_int64 a s d -- d", "FUNCTION: pw_properties_get_int64 ( properties key deflt -- d )", "EXTERN: \"C\" long long pw_properties_get_int64( void * properties, char * key, long long deflt );", "	( properties key deflt -- )" );
	swigFunction( "c-function pw_properties_get_bool pw_properties_get_bool a s n -- n", "FUNCTION: pw_properties_get_bool ( properties key deflt -- n )", "EXTERN: \"C\" bool pw_properties_get_bool( void * properties, char * key, bool deflt );", "	( properties key deflt -- )" );
	swigFunction( "c-function pw_properties_iterate pw_properties_iterate a a -- s", "FUNCTION: pw_properties_iterate ( properties state -- s )", "EXTERN: \"C\" char * pw_properties_iterate( void * properties, void * state );", "	( properties state -- )" );
	swigFunction( "c-function pw_properties_serialize_dict pw_properties_serialize_dict a a u -- n", "FUNCTION: pw_properties_serialize_dict ( f dict flags -- n )", "EXTERN: \"C\" int pw_properties_serialize_dict( void * f, void * dict, int flags );", "	( f dict flags -- )" );
	swigFunction( "c-function pw_properties_parse_bool pw_properties_parse_bool s -- n", "FUNCTION: pw_properties_parse_bool ( value -- n )", "EXTERN: \"C\" bool pw_properties_parse_bool( char * value );", "	( value -- )" );
	swigFunction( "c-function pw_properties_parse_int pw_properties_parse_int s -- n", "FUNCTION: pw_properties_parse_int ( value -- n )", "EXTERN: \"C\" int pw_properties_parse_int( char * value );", "	( value -- )" );
	swigFunction( "c-function pw_properties_parse_int64 pw_properties_parse_int64 s -- d", "FUNCTION: pw_properties_parse_int64 ( value -- d )", "EXTERN: \"C\" long long pw_properties_parse_int64( char * value );", "	( value -- )" );
	swigFunction( "c-function pw_properties_parse_uint64 pw_properties_parse_uint64 s -- n", "FUNCTION: pw_properties_parse_uint64 ( value -- n )", "EXTERN: \"C\" long pw_properties_parse_uint64( char * value );", "	( value -- )" );
	swigFunction( "c-function pw_properties_parse_float pw_properties_parse_float s -- r", "FUNCTION: pw_properties_parse_float ( value -- r )", "EXTERN: \"C\" float pw_properties_parse_float( char * value );", "	( value -- )" );
	swigFunction( "c-function pw_properties_parse_double pw_properties_parse_double s -- r", "FUNCTION: pw_properties_parse_double ( value -- r )", "EXTERN: \"C\" double pw_properties_parse_double( char * value );", "	( value -- )" );
	swigFunction( "c-function pw_proxy_new pw_proxy_new a s u d -- a", "FUNCTION: pw_proxy_new ( factory type version user_data_size -- a )", "EXTERN: \"C\" void * pw_proxy_new( void * factory, char * type, int version, long long user_data_size );", "	( factory type version user_data_size -- )" );
	swigFunction( "c-function pw_proxy_add_listener pw_proxy_add_listener a a a a -- void", "FUNCTION: pw_proxy_add_listener ( proxy listener events data -- void )", "EXTERN: \"C\" void pw_proxy_add_listener( void * proxy, void * listener, void * events, void * data );", "	( proxy listener events data -- )" );
	swigFunction( "c-function pw_proxy_add_object_listener pw_proxy_add_object_listener a a a a -- void", "FUNCTION: pw_proxy_add_object_listener ( proxy listener funcs data -- void )", "EXTERN: \"C\" void pw_proxy_add_object_listener( void * proxy, void * listener, void * funcs, void * data );", "	( proxy listener funcs data -- )" );
	swigFunction( "c-function pw_proxy_destroy pw_proxy_destroy a -- void", "FUNCTION: pw_proxy_destroy ( proxy -- void )", "EXTERN: \"C\" void pw_proxy_destroy( void * proxy );", "	( proxy -- )" );
	swigFunction( "c-function pw_proxy_ref pw_proxy_ref a -- void", "FUNCTION: pw_proxy_ref ( proxy -- void )", "EXTERN: \"C\" void pw_proxy_ref( void * proxy );", "	( proxy -- )" );
	swigFunction( "c-function pw_proxy_unref pw_proxy_unref a -- void", "FUNCTION: pw_proxy_unref ( proxy -- void )", "EXTERN: \"C\" void pw_proxy_unref( void * proxy );", "	( proxy -- )" );
	swigFunction( "c-function pw_proxy_get_user_data pw_proxy_get_user_data a -- a", "FUNCTION: pw_proxy_get_user_data ( proxy -- a )", "EXTERN: \"C\" void * pw_proxy_get_user_data( void * proxy );", "	( proxy -- )" );
	swigFunction( "c-function pw_proxy_get_id pw_proxy_get_id a -- u", "FUNCTION: pw_proxy_get_id ( proxy -- u )", "EXTERN: \"C\" int pw_proxy_get_id( void * proxy );", "	( proxy -- )" );
	swigFunction( "c-function pw_proxy_get_type pw_proxy_get_type a a -- s", "FUNCTION: pw_proxy_get_type ( proxy version -- s )", "EXTERN: \"C\" char * pw_proxy_get_type( void * proxy, void * version );", "	( proxy version -- )" );
	swigFunction( "c-function pw_proxy_get_protocol pw_proxy_get_protocol a -- a", "FUNCTION: pw_proxy_get_protocol ( proxy -- a )", "EXTERN: \"C\" void * pw_proxy_get_protocol( void * proxy );", "	( proxy -- )" );
	swigFunction( "c-function pw_proxy_sync pw_proxy_sync a n -- n", "FUNCTION: pw_proxy_sync ( proxy seq -- n )", "EXTERN: \"C\" int pw_proxy_sync( void * proxy, int seq );", "	( proxy seq -- )" );
	swigFunction( "c-function pw_proxy_set_bound_id pw_proxy_set_bound_id a u -- n", "FUNCTION: pw_proxy_set_bound_id ( proxy global_id -- n )", "EXTERN: \"C\" int pw_proxy_set_bound_id( void * proxy, int global_id );", "	( proxy global_id -- )" );
	swigFunction( "c-function pw_proxy_get_bound_id pw_proxy_get_bound_id a -- u", "FUNCTION: pw_proxy_get_bound_id ( proxy -- u )", "EXTERN: \"C\" int pw_proxy_get_bound_id( void * proxy );", "	( proxy -- )" );
	swigFunction( "c-function pw_proxy_error pw_proxy_error a n s -- n", "FUNCTION: pw_proxy_error ( proxy res error -- n )", "EXTERN: \"C\" int pw_proxy_error( void * proxy, int res, char * error );", "	( proxy res error -- )" );
	swigFunction( "c-function pw_proxy_errorf pw_proxy_errorf a n s ... -- n", "FUNCTION: pw_proxy_errorf ( proxy res error  -- n )", "EXTERN: \"C\" int pw_proxy_errorf( void * proxy, int res, char * error, ...  );", "	( proxy res error <noname> -- )" );
	swigFunction( "c-function pw_proxy_get_object_listeners pw_proxy_get_object_listeners a -- a", "FUNCTION: pw_proxy_get_object_listeners ( proxy -- a )", "EXTERN: \"C\" void * pw_proxy_get_object_listeners( void * proxy );", "	( proxy -- )" );
	swigFunction( "c-function pw_proxy_get_marshal pw_proxy_get_marshal a -- a", "FUNCTION: pw_proxy_get_marshal ( proxy -- a )", "EXTERN: \"C\" void * pw_proxy_get_marshal( void * proxy );", "	( proxy -- )" );
	swigFunction( "c-function pw_proxy_install_marshal pw_proxy_install_marshal a n -- n", "FUNCTION: pw_proxy_install_marshal ( proxy implementor -- n )", "EXTERN: \"C\" int pw_proxy_install_marshal( void * proxy, bool implementor );", "	( proxy implementor -- )" );
	swigFunction( "c-function pw_protocol_new pw_protocol_new a s d -- a", "FUNCTION: pw_protocol_new ( context name user_data_size -- a )", "EXTERN: \"C\" void * pw_protocol_new( void * context, char * name, long long user_data_size );", "	( context name user_data_size -- )" );
	swigFunction( "c-function pw_protocol_destroy pw_protocol_destroy a -- void", "FUNCTION: pw_protocol_destroy ( protocol -- void )", "EXTERN: \"C\" void pw_protocol_destroy( void * protocol );", "	( protocol -- )" );
	swigFunction( "c-function pw_protocol_get_context pw_protocol_get_context a -- a", "FUNCTION: pw_protocol_get_context ( protocol -- a )", "EXTERN: \"C\" void * pw_protocol_get_context( void * protocol );", "	( protocol -- )" );
	swigFunction( "c-function pw_protocol_get_user_data pw_protocol_get_user_data a -- a", "FUNCTION: pw_protocol_get_user_data ( protocol -- a )", "EXTERN: \"C\" void * pw_protocol_get_user_data( void * protocol );", "	( protocol -- )" );
	swigFunction( "c-function pw_protocol_get_implementation pw_protocol_get_implementation a -- a", "FUNCTION: pw_protocol_get_implementation ( protocol -- a )", "EXTERN: \"C\" void * pw_protocol_get_implementation( void * protocol );", "	( protocol -- )" );
	swigFunction( "c-function pw_protocol_get_extension pw_protocol_get_extension a -- a", "FUNCTION: pw_protocol_get_extension ( protocol -- a )", "EXTERN: \"C\" void * pw_protocol_get_extension( void * protocol );", "	( protocol -- )" );
	swigFunction( "c-function pw_protocol_add_listener pw_protocol_add_listener a a a a -- void", "FUNCTION: pw_protocol_add_listener ( protocol listener events data -- void )", "EXTERN: \"C\" void pw_protocol_add_listener( void * protocol, void * listener, void * events, void * data );", "	( protocol listener events data -- )" );
	swigFunction( "c-function pw_protocol_add_marshal pw_protocol_add_marshal a a -- n", "FUNCTION: pw_protocol_add_marshal ( protocol marshal -- n )", "EXTERN: \"C\" int pw_protocol_add_marshal( void * protocol, void * marshal );", "	( protocol marshal -- )" );
	swigFunction( "c-function pw_protocol_get_marshal pw_protocol_get_marshal a s u u -- a", "FUNCTION: pw_protocol_get_marshal ( protocol type version flags -- a )", "EXTERN: \"C\" void * pw_protocol_get_marshal( void * protocol, char * type, int version, int flags );", "	( protocol type version flags -- )" );
	swigFunction( "c-function pw_context_find_protocol pw_context_find_protocol a s -- a", "FUNCTION: pw_context_find_protocol ( context name -- a )", "EXTERN: \"C\" void * pw_context_find_protocol( void * context, char * name );", "	( context name -- )" );
	swigFunction( "c-function pw_direction_as_string pw_direction_as_string n -- s", "FUNCTION: pw_direction_as_string ( direction -- s )", "EXTERN: \"C\" char * pw_direction_as_string( int direction );", "	( direction -- )" );
	swigFunction( "c-function pw_port_info_update pw_port_info_update a a -- a", "FUNCTION: pw_port_info_update ( info update -- a )", "EXTERN: \"C\" void * pw_port_info_update( void * info, void * update );", "	( info update -- )" );
	swigFunction( "c-function pw_port_info_merge pw_port_info_merge a a n -- a", "FUNCTION: pw_port_info_merge ( info update reset -- a )", "EXTERN: \"C\" void * pw_port_info_merge( void * info, void * update, bool reset );", "	( info update reset -- )" );
	swigFunction( "c-function pw_port_info_free pw_port_info_free a -- void", "FUNCTION: pw_port_info_free ( info -- void )", "EXTERN: \"C\" void pw_port_info_free( void * info );", "	( info -- )" );
	swigFunction( "c-function pw_stream_state_as_string pw_stream_state_as_string n -- s", "FUNCTION: pw_stream_state_as_string ( state -- s )", "EXTERN: \"C\" char * pw_stream_state_as_string( int state );", "	( state -- )" );
	swigFunction( "c-function pw_stream_new pw_stream_new a s a -- a", "FUNCTION: pw_stream_new ( core name props -- a )", "EXTERN: \"C\" void * pw_stream_new( void * core, char * name, void * props );", "	( core name props -- )" );
	swigFunction( "c-function pw_stream_new_simple pw_stream_new_simple a s a a a -- a", "FUNCTION: pw_stream_new_simple ( loop name props events data -- a )", "EXTERN: \"C\" void * pw_stream_new_simple( void * loop, char * name, void * props, void * events, void * data );", "	( loop name props events data -- )" );
	swigFunction( "c-function pw_stream_destroy pw_stream_destroy a -- void", "FUNCTION: pw_stream_destroy ( stream -- void )", "EXTERN: \"C\" void pw_stream_destroy( void * stream );", "	( stream -- )" );
	swigFunction( "c-function pw_stream_add_listener pw_stream_add_listener a a a a -- void", "FUNCTION: pw_stream_add_listener ( stream listener events data -- void )", "EXTERN: \"C\" void pw_stream_add_listener( void * stream, void * listener, void * events, void * data );", "	( stream listener events data -- )" );
	swigFunction( "c-function pw_stream_get_state pw_stream_get_state a a -- n", "FUNCTION: pw_stream_get_state ( stream error -- n )", "EXTERN: \"C\" int pw_stream_get_state( void * stream, void * error );", "	( stream error -- )" );
	swigFunction( "c-function pw_stream_get_name pw_stream_get_name a -- s", "FUNCTION: pw_stream_get_name ( stream -- s )", "EXTERN: \"C\" char * pw_stream_get_name( void * stream );", "	( stream -- )" );
	swigFunction( "c-function pw_stream_get_core pw_stream_get_core a -- a", "FUNCTION: pw_stream_get_core ( stream -- a )", "EXTERN: \"C\" void * pw_stream_get_core( void * stream );", "	( stream -- )" );
	swigFunction( "c-function pw_stream_get_properties pw_stream_get_properties a -- a", "FUNCTION: pw_stream_get_properties ( stream -- a )", "EXTERN: \"C\" void * pw_stream_get_properties( void * stream );", "	( stream -- )" );
	swigFunction( "c-function pw_stream_update_properties pw_stream_update_properties a a -- n", "FUNCTION: pw_stream_update_properties ( stream dict -- n )", "EXTERN: \"C\" int pw_stream_update_properties( void * stream, void * dict );", "	( stream dict -- )" );
	swigFunction( "c-function pw_stream_connect pw_stream_connect a n u n a u -- n", "FUNCTION: pw_stream_connect ( stream direction target_id flags params n_params -- n )", "EXTERN: \"C\" int pw_stream_connect( void * stream, int direction, int target_id, int flags, void * params, int n_params );", "	( stream direction target_id flags params n_params -- )" );
	swigFunction( "c-function pw_stream_get_node_id pw_stream_get_node_id a -- u", "FUNCTION: pw_stream_get_node_id ( stream -- u )", "EXTERN: \"C\" int pw_stream_get_node_id( void * stream );", "	( stream -- )" );
	swigFunction( "c-function pw_stream_disconnect pw_stream_disconnect a -- n", "FUNCTION: pw_stream_disconnect ( stream -- n )", "EXTERN: \"C\" int pw_stream_disconnect( void * stream );", "	( stream -- )" );
	swigFunction( "c-function pw_stream_set_error pw_stream_set_error a n s ... -- n", "FUNCTION: pw_stream_set_error ( stream res error  -- n )", "EXTERN: \"C\" int pw_stream_set_error( void * stream, int res, char * error, ...  );", "	( stream res error <noname> -- )" );
	swigFunction( "c-function pw_stream_update_params pw_stream_update_params a a u -- n", "FUNCTION: pw_stream_update_params ( stream params n_params -- n )", "EXTERN: \"C\" int pw_stream_update_params( void * stream, void * params, int n_params );", "	( stream params n_params -- )" );
	swigFunction( "c-function pw_stream_set_param pw_stream_set_param a u a -- n", "FUNCTION: pw_stream_set_param ( stream id param -- n )", "EXTERN: \"C\" int pw_stream_set_param( void * stream, int id, void * param );", "	( stream id param -- )" );
	swigFunction( "c-function pw_stream_get_control pw_stream_get_control a u -- a", "FUNCTION: pw_stream_get_control ( stream id -- a )", "EXTERN: \"C\" void * pw_stream_get_control( void * stream, int id );", "	( stream id -- )" );
	swigFunction( "c-function pw_stream_set_control pw_stream_set_control a u u a ... -- n", "FUNCTION: pw_stream_set_control ( stream id n_values values  -- n )", "EXTERN: \"C\" int pw_stream_set_control( void * stream, int id, int n_values, void * values, ...  );", "	( stream id n_values values <noname> -- )" );
	swigFunction( "c-function pw_stream_get_time_n pw_stream_get_time_n a a d -- n", "FUNCTION: pw_stream_get_time_n ( stream time size -- n )", "EXTERN: \"C\" int pw_stream_get_time_n( void * stream, void * time, long long size );", "	( stream time size -- )" );
	swigFunction( "c-function pw_stream_get_time pw_stream_get_time a a -- n", "FUNCTION: pw_stream_get_time ( stream time -- n )", "EXTERN: \"C\" int pw_stream_get_time( void * stream, void * time );", "	( stream time -- )" );
	swigFunction( "c-function pw_stream_dequeue_buffer pw_stream_dequeue_buffer a -- a", "FUNCTION: pw_stream_dequeue_buffer ( stream -- a )", "EXTERN: \"C\" void * pw_stream_dequeue_buffer( void * stream );", "	( stream -- )" );
	swigFunction( "c-function pw_stream_queue_buffer pw_stream_queue_buffer a a -- n", "FUNCTION: pw_stream_queue_buffer ( stream buffer -- n )", "EXTERN: \"C\" int pw_stream_queue_buffer( void * stream, void * buffer );", "	( stream buffer -- )" );
	swigFunction( "c-function pw_stream_set_active pw_stream_set_active a n -- n", "FUNCTION: pw_stream_set_active ( stream active -- n )", "EXTERN: \"C\" int pw_stream_set_active( void * stream, bool active );", "	( stream active -- )" );
	swigFunction( "c-function pw_stream_flush pw_stream_flush a n -- n", "FUNCTION: pw_stream_flush ( stream drain -- n )", "EXTERN: \"C\" int pw_stream_flush( void * stream, bool drain );", "	( stream drain -- )" );
	swigFunction( "c-function pw_stream_is_driving pw_stream_is_driving a -- n", "FUNCTION: pw_stream_is_driving ( stream -- n )", "EXTERN: \"C\" bool pw_stream_is_driving( void * stream );", "	( stream -- )" );
	swigFunction( "c-function pw_stream_trigger_process pw_stream_trigger_process a -- n", "FUNCTION: pw_stream_trigger_process ( stream -- n )", "EXTERN: \"C\" int pw_stream_trigger_process( void * stream );", "	( stream -- )" );
	swigFunction( "c-function pw_filter_state_as_string pw_filter_state_as_string n -- s", "FUNCTION: pw_filter_state_as_string ( state -- s )", "EXTERN: \"C\" char * pw_filter_state_as_string( int state );", "	( state -- )" );
	swigFunction( "c-function pw_filter_new pw_filter_new a s a -- a", "FUNCTION: pw_filter_new ( core name props -- a )", "EXTERN: \"C\" void * pw_filter_new( void * core, char * name, void * props );", "	( core name props -- )" );
	swigFunction( "c-function pw_filter_new_simple pw_filter_new_simple a s a a a -- a", "FUNCTION: pw_filter_new_simple ( loop name props events data -- a )", "EXTERN: \"C\" void * pw_filter_new_simple( void * loop, char * name, void * props, void * events, void * data );", "	( loop name props events data -- )" );
	swigFunction( "c-function pw_filter_destroy pw_filter_destroy a -- void", "FUNCTION: pw_filter_destroy ( filter -- void )", "EXTERN: \"C\" void pw_filter_destroy( void * filter );", "	( filter -- )" );
	swigFunction( "c-function pw_filter_add_listener pw_filter_add_listener a a a a -- void", "FUNCTION: pw_filter_add_listener ( filter listener events data -- void )", "EXTERN: \"C\" void pw_filter_add_listener( void * filter, void * listener, void * events, void * data );", "	( filter listener events data -- )" );
	swigFunction( "c-function pw_filter_get_state pw_filter_get_state a a -- n", "FUNCTION: pw_filter_get_state ( filter error -- n )", "EXTERN: \"C\" int pw_filter_get_state( void * filter, void * error );", "	( filter error -- )" );
	swigFunction( "c-function pw_filter_get_name pw_filter_get_name a -- s", "FUNCTION: pw_filter_get_name ( filter -- s )", "EXTERN: \"C\" char * pw_filter_get_name( void * filter );", "	( filter -- )" );
	swigFunction( "c-function pw_filter_get_core pw_filter_get_core a -- a", "FUNCTION: pw_filter_get_core ( filter -- a )", "EXTERN: \"C\" void * pw_filter_get_core( void * filter );", "	( filter -- )" );
	swigFunction( "c-function pw_filter_connect pw_filter_connect a n a u -- n", "FUNCTION: pw_filter_connect ( filter flags params n_params -- n )", "EXTERN: \"C\" int pw_filter_connect( void * filter, int flags, void * params, int n_params );", "	( filter flags params n_params -- )" );
	swigFunction( "c-function pw_filter_get_node_id pw_filter_get_node_id a -- u", "FUNCTION: pw_filter_get_node_id ( filter -- u )", "EXTERN: \"C\" int pw_filter_get_node_id( void * filter );", "	( filter -- )" );
	swigFunction( "c-function pw_filter_disconnect pw_filter_disconnect a -- n", "FUNCTION: pw_filter_disconnect ( filter -- n )", "EXTERN: \"C\" int pw_filter_disconnect( void * filter );", "	( filter -- )" );
	swigFunction( "c-function pw_filter_add_port pw_filter_add_port a n n d a a u -- a", "FUNCTION: pw_filter_add_port ( filter direction flags port_data_size props params n_params -- a )", "EXTERN: \"C\" void * pw_filter_add_port( void * filter, int direction, int flags, long long port_data_size, void * props, void * params, int n_params );", "	( filter direction flags port_data_size props params n_params -- )" );
	swigFunction( "c-function pw_filter_remove_port pw_filter_remove_port a -- n", "FUNCTION: pw_filter_remove_port ( port_data -- n )", "EXTERN: \"C\" int pw_filter_remove_port( void * port_data );", "	( port_data -- )" );
	swigFunction( "c-function pw_filter_get_properties pw_filter_get_properties a a -- a", "FUNCTION: pw_filter_get_properties ( filter port_data -- a )", "EXTERN: \"C\" void * pw_filter_get_properties( void * filter, void * port_data );", "	( filter port_data -- )" );
	swigFunction( "c-function pw_filter_update_properties pw_filter_update_properties a a a -- n", "FUNCTION: pw_filter_update_properties ( filter port_data dict -- n )", "EXTERN: \"C\" int pw_filter_update_properties( void * filter, void * port_data, void * dict );", "	( filter port_data dict -- )" );
	swigFunction( "c-function pw_filter_set_error pw_filter_set_error a n s ... -- n", "FUNCTION: pw_filter_set_error ( filter res error  -- n )", "EXTERN: \"C\" int pw_filter_set_error( void * filter, int res, char * error, ...  );", "	( filter res error <noname> -- )" );
	swigFunction( "c-function pw_filter_update_params pw_filter_update_params a a a u -- n", "FUNCTION: pw_filter_update_params ( filter port_data params n_params -- n )", "EXTERN: \"C\" int pw_filter_update_params( void * filter, void * port_data, void * params, int n_params );", "	( filter port_data params n_params -- )" );
	swigFunction( "c-function pw_filter_get_time pw_filter_get_time a a -- n", "FUNCTION: pw_filter_get_time ( filter time -- n )", "EXTERN: \"C\" int pw_filter_get_time( void * filter, void * time );", "	( filter time -- )" );
	swigFunction( "c-function pw_filter_dequeue_buffer pw_filter_dequeue_buffer a -- a", "FUNCTION: pw_filter_dequeue_buffer ( port_data -- a )", "EXTERN: \"C\" void * pw_filter_dequeue_buffer( void * port_data );", "	( port_data -- )" );
	swigFunction( "c-function pw_filter_queue_buffer pw_filter_queue_buffer a a -- n", "FUNCTION: pw_filter_queue_buffer ( port_data buffer -- n )", "EXTERN: \"C\" int pw_filter_queue_buffer( void * port_data, void * buffer );", "	( port_data buffer -- )" );
	swigFunction( "c-function pw_filter_get_dsp_buffer pw_filter_get_dsp_buffer a u -- a", "FUNCTION: pw_filter_get_dsp_buffer ( port_data n_samples -- a )", "EXTERN: \"C\" void * pw_filter_get_dsp_buffer( void * port_data, int n_samples );", "	( port_data n_samples -- )" );
	swigFunction( "c-function pw_filter_set_active pw_filter_set_active a n -- n", "FUNCTION: pw_filter_set_active ( filter active -- n )", "EXTERN: \"C\" int pw_filter_set_active( void * filter, bool active );", "	( filter active -- )" );
	swigFunction( "c-function pw_filter_flush pw_filter_flush a n -- n", "FUNCTION: pw_filter_flush ( filter drain -- n )", "EXTERN: \"C\" int pw_filter_flush( void * filter, bool drain );", "	( filter drain -- )" );
	swigFunction( "c-function pw_filter_is_driving pw_filter_is_driving a -- n", "FUNCTION: pw_filter_is_driving ( filter -- n )", "EXTERN: \"C\" bool pw_filter_is_driving( void * filter );", "	( filter -- )" );
	swigFunction( "c-function pw_filter_trigger_process pw_filter_trigger_process a -- n", "FUNCTION: pw_filter_trigger_process ( filter -- n )", "EXTERN: \"C\" int pw_filter_trigger_process( void * filter );", "	( filter -- )" );
	swigFunction( "c-function pw_thread_loop_new pw_thread_loop_new s a -- a", "FUNCTION: pw_thread_loop_new ( name props -- a )", "EXTERN: \"C\" void * pw_thread_loop_new( char * name, void * props );", "	( name props -- )" );
	swigFunction( "c-function pw_thread_loop_new_full pw_thread_loop_new_full a s a -- a", "FUNCTION: pw_thread_loop_new_full ( loop name props -- a )", "EXTERN: \"C\" void * pw_thread_loop_new_full( void * loop, char * name, void * props );", "	( loop name props -- )" );
	swigFunction( "c-function pw_thread_loop_destroy pw_thread_loop_destroy a -- void", "FUNCTION: pw_thread_loop_destroy ( loop -- void )", "EXTERN: \"C\" void pw_thread_loop_destroy( void * loop );", "	( loop -- )" );
	swigFunction( "c-function pw_thread_loop_add_listener pw_thread_loop_add_listener a a a a -- void", "FUNCTION: pw_thread_loop_add_listener ( loop listener events data -- void )", "EXTERN: \"C\" void pw_thread_loop_add_listener( void * loop, void * listener, void * events, void * data );", "	( loop listener events data -- )" );
	swigFunction( "c-function pw_thread_loop_get_loop pw_thread_loop_get_loop a -- a", "FUNCTION: pw_thread_loop_get_loop ( loop -- a )", "EXTERN: \"C\" void * pw_thread_loop_get_loop( void * loop );", "	( loop -- )" );
	swigFunction( "c-function pw_thread_loop_start pw_thread_loop_start a -- n", "FUNCTION: pw_thread_loop_start ( loop -- n )", "EXTERN: \"C\" int pw_thread_loop_start( void * loop );", "	( loop -- )" );
	swigFunction( "c-function pw_thread_loop_stop pw_thread_loop_stop a -- void", "FUNCTION: pw_thread_loop_stop ( loop -- void )", "EXTERN: \"C\" void pw_thread_loop_stop( void * loop );", "	( loop -- )" );
	swigFunction( "c-function pw_thread_loop_lock pw_thread_loop_lock a -- void", "FUNCTION: pw_thread_loop_lock ( loop -- void )", "EXTERN: \"C\" void pw_thread_loop_lock( void * loop );", "	( loop -- )" );
	swigFunction( "c-function pw_thread_loop_unlock pw_thread_loop_unlock a -- void", "FUNCTION: pw_thread_loop_unlock ( loop -- void )", "EXTERN: \"C\" void pw_thread_loop_unlock( void * loop );", "	( loop -- )" );
	swigFunction( "c-function pw_thread_loop_wait pw_thread_loop_wait a -- void", "FUNCTION: pw_thread_loop_wait ( loop -- void )", "EXTERN: \"C\" void pw_thread_loop_wait( void * loop );", "	( loop -- )" );
	swigFunction( "c-function pw_thread_loop_timed_wait pw_thread_loop_timed_wait a n -- n", "FUNCTION: pw_thread_loop_timed_wait ( loop wait_max_sec -- n )", "EXTERN: \"C\" int pw_thread_loop_timed_wait( void * loop, int wait_max_sec );", "	( loop wait_max_sec -- )" );
	swigFunction( "c-function pw_thread_loop_get_time pw_thread_loop_get_time a a d -- n", "FUNCTION: pw_thread_loop_get_time ( loop abstime timeout -- n )", "EXTERN: \"C\" int pw_thread_loop_get_time( void * loop, void * abstime, long long timeout );", "	( loop abstime timeout -- )" );
	swigFunction( "c-function pw_thread_loop_timed_wait_full pw_thread_loop_timed_wait_full a a -- n", "FUNCTION: pw_thread_loop_timed_wait_full ( loop abstime -- n )", "EXTERN: \"C\" int pw_thread_loop_timed_wait_full( void * loop, void * abstime );", "	( loop abstime -- )" );
	swigFunction( "c-function pw_thread_loop_signal pw_thread_loop_signal a n -- void", "FUNCTION: pw_thread_loop_signal ( loop wait_for_accept -- void )", "EXTERN: \"C\" void pw_thread_loop_signal( void * loop, bool wait_for_accept );", "	( loop wait_for_accept -- )" );
	swigFunction( "c-function pw_thread_loop_accept pw_thread_loop_accept a -- void", "FUNCTION: pw_thread_loop_accept ( loop -- void )", "EXTERN: \"C\" void pw_thread_loop_accept( void * loop );", "	( loop -- )" );
	swigFunction( "c-function pw_thread_loop_in_thread pw_thread_loop_in_thread a -- n", "FUNCTION: pw_thread_loop_in_thread ( loop -- n )", "EXTERN: \"C\" bool pw_thread_loop_in_thread( void * loop );", "	( loop -- )" );
	swigFunction( "c-function pw_data_loop_new pw_data_loop_new a -- a", "FUNCTION: pw_data_loop_new ( props -- a )", "EXTERN: \"C\" void * pw_data_loop_new( void * props );", "	( props -- )" );
	swigFunction( "c-function pw_data_loop_add_listener pw_data_loop_add_listener a a a a -- void", "FUNCTION: pw_data_loop_add_listener ( loop listener events data -- void )", "EXTERN: \"C\" void pw_data_loop_add_listener( void * loop, void * listener, void * events, void * data );", "	( loop listener events data -- )" );
	swigFunction( "c-function pw_data_loop_wait pw_data_loop_wait a n -- n", "FUNCTION: pw_data_loop_wait ( loop timeout -- n )", "EXTERN: \"C\" int pw_data_loop_wait( void * loop, int timeout );", "	( loop timeout -- )" );
	swigFunction( "c-function pw_data_loop_exit pw_data_loop_exit a -- void", "FUNCTION: pw_data_loop_exit ( loop -- void )", "EXTERN: \"C\" void pw_data_loop_exit( void * loop );", "	( loop -- )" );
	swigFunction( "c-function pw_data_loop_get_loop pw_data_loop_get_loop a -- a", "FUNCTION: pw_data_loop_get_loop ( loop -- a )", "EXTERN: \"C\" void * pw_data_loop_get_loop( void * loop );", "	( loop -- )" );
	swigFunction( "c-function pw_data_loop_destroy pw_data_loop_destroy a -- void", "FUNCTION: pw_data_loop_destroy ( loop -- void )", "EXTERN: \"C\" void pw_data_loop_destroy( void * loop );", "	( loop -- )" );
	swigFunction( "c-function pw_data_loop_start pw_data_loop_start a -- n", "FUNCTION: pw_data_loop_start ( loop -- n )", "EXTERN: \"C\" int pw_data_loop_start( void * loop );", "	( loop -- )" );
	swigFunction( "c-function pw_data_loop_stop pw_data_loop_stop a -- n", "FUNCTION: pw_data_loop_stop ( loop -- n )", "EXTERN: \"C\" int pw_data_loop_stop( void * loop );", "	( loop -- )" );
	swigFunction( "c-function pw_data_loop_in_thread pw_data_loop_in_thread a -- n", "FUNCTION: pw_data_loop_in_thread ( loop -- n )", "EXTERN: \"C\" bool pw_data_loop_in_thread( void * loop );", "	( loop -- )" );
	swigFunction( "c-function pw_data_loop_get_thread pw_data_loop_get_thread a -- a", "FUNCTION: pw_data_loop_get_thread ( loop -- a )", "EXTERN: \"C\" void * pw_data_loop_get_thread( void * loop );", "	( loop -- )" );
	swigFunction( "c-function pw_data_loop_invoke pw_data_loop_invoke a a u a d n a -- n", "FUNCTION: pw_data_loop_invoke ( loop func seq data size block user_data -- n )", "EXTERN: \"C\" int pw_data_loop_invoke( void * loop, void * func, int seq, void * data, long long size, bool block, void * user_data );", "	( loop func seq data size block user_data -- )" );
	swigFunction( "c-function pw_data_loop_set_thread_utils pw_data_loop_set_thread_utils a a -- void", "FUNCTION: pw_data_loop_set_thread_utils ( loop impl -- void )", "EXTERN: \"C\" void pw_data_loop_set_thread_utils( void * loop, void * impl );", "	( loop impl -- )" );
	swigFunction( "c-function pw_type_info pw_type_info  -- a", "FUNCTION: pw_type_info (  -- a )", "EXTERN: \"C\" void * pw_type_info(  );", "	( -- )" );
	swigFunction( "c-function pw_split_walk pw_split_walk s s a a -- s", "FUNCTION: pw_split_walk ( str delimiter len state -- s )", "EXTERN: \"C\" char * pw_split_walk( char * str, char * delimiter, void * len, void * state );", "	( str delimiter len state -- )" );
	swigFunction( "c-function pw_split_strv pw_split_strv s s n a -- a", "FUNCTION: pw_split_strv ( str delimiter max_tokens n_tokens -- a )", "EXTERN: \"C\" void * pw_split_strv( char * str, char * delimiter, int max_tokens, void * n_tokens );", "	( str delimiter max_tokens n_tokens -- )" );
	swigFunction( "c-function pw_split_ip pw_split_ip a s n a -- n", "FUNCTION: pw_split_ip ( str delimiter max_tokens tokens -- n )", "EXTERN: \"C\" int pw_split_ip( void * str, char * delimiter, int max_tokens, void * tokens );", "	( str delimiter max_tokens tokens -- )" );
	swigFunction( "c-function pw_strv_parse pw_strv_parse s d n a -- a", "FUNCTION: pw_strv_parse ( val len max_tokens n_tokens -- a )", "EXTERN: \"C\" void * pw_strv_parse( char * val, long long len, int max_tokens, void * n_tokens );", "	( val len max_tokens n_tokens -- )" );
	swigFunction( "c-function pw_strv_find pw_strv_find a s -- n", "FUNCTION: pw_strv_find ( a b -- n )", "EXTERN: \"C\" int pw_strv_find( void * a, char * b );", "	( a b -- )" );
	swigFunction( "c-function pw_strv_find_common pw_strv_find_common a a -- n", "FUNCTION: pw_strv_find_common ( a b -- n )", "EXTERN: \"C\" int pw_strv_find_common( void * a, void * b );", "	( a b -- )" );
	swigFunction( "c-function pw_free_strv pw_free_strv a -- void", "FUNCTION: pw_free_strv ( str -- void )", "EXTERN: \"C\" void pw_free_strv( void * str );", "	( str -- )" );
	swigFunction( "c-function pw_strip pw_strip a s -- a", "FUNCTION: pw_strip ( str whitespace -- a )", "EXTERN: \"C\" void * pw_strip( void * str, char * whitespace );", "	( str whitespace -- )" );
	swigFunction( "c-function pw_getrandom pw_getrandom a d u -- n", "FUNCTION: pw_getrandom ( buf buflen flags -- n )", "EXTERN: \"C\" long pw_getrandom( void * buf, long long buflen, int flags );", "	( buf buflen flags -- )" );
	swigFunction( "c-function pw_random pw_random a d -- void", "FUNCTION: pw_random ( buf buflen -- void )", "EXTERN: \"C\" void pw_random( void * buf, long long buflen );", "	( buf buflen -- )" );
	swigFunction( "c-function pw_reallocarray pw_reallocarray a d d -- a", "FUNCTION: pw_reallocarray ( ptr nmemb size -- a )", "EXTERN: \"C\" void * pw_reallocarray( void * ptr, long long nmemb, long long size );", "	( ptr nmemb size -- )" );
	swigFunction( "c-function pw_get_library_version pw_get_library_version  -- s", "FUNCTION: pw_get_library_version (  -- s )", "EXTERN: \"C\" char * pw_get_library_version(  );", "	( -- )" );
	swigFunction( "c-function pw_check_library_version pw_check_library_version n n n -- n", "FUNCTION: pw_check_library_version ( major minor micro -- n )", "EXTERN: \"C\" bool pw_check_library_version( int major, int minor, int micro );", "	( major minor micro -- )" );
	swigFunction( "c-function spa_pod_parser_init spa_pod_parser_init a a u -- void", "FUNCTION: spa_pod_parser_init ( parser data size -- void )", "EXTERN: \"C\" void spa_pod_parser_init( void * parser, void * data, int size );", "	( parser data size -- )" );
	swigFunction( "c-function spa_pod_parser_pod spa_pod_parser_pod a a -- void", "FUNCTION: spa_pod_parser_pod ( parser pod -- void )", "EXTERN: \"C\" void spa_pod_parser_pod( void * parser, void * pod );", "	( parser pod -- )" );
	swigFunction( "c-function spa_pod_parser_get_state spa_pod_parser_get_state a a -- void", "FUNCTION: spa_pod_parser_get_state ( parser state -- void )", "EXTERN: \"C\" void spa_pod_parser_get_state( void * parser, void * state );", "	( parser state -- )" );
	swigFunction( "c-function spa_pod_parser_reset spa_pod_parser_reset a a -- void", "FUNCTION: spa_pod_parser_reset ( parser state -- void )", "EXTERN: \"C\" void spa_pod_parser_reset( void * parser, void * state );", "	( parser state -- )" );
	swigFunction( "c-function spa_pod_parser_deref spa_pod_parser_deref a u u -- a", "FUNCTION: spa_pod_parser_deref ( parser offset size -- a )", "EXTERN: \"C\" void * spa_pod_parser_deref( void * parser, int offset, int size );", "	( parser offset size -- )" );
	swigFunction( "c-function spa_pod_parser_frame spa_pod_parser_frame a a -- a", "FUNCTION: spa_pod_parser_frame ( parser frame -- a )", "EXTERN: \"C\" void * spa_pod_parser_frame( void * parser, void * frame );", "	( parser frame -- )" );
	swigFunction( "c-function spa_pod_parser_push spa_pod_parser_push a a a u -- void", "FUNCTION: spa_pod_parser_push ( parser frame pod offset -- void )", "EXTERN: \"C\" void spa_pod_parser_push( void * parser, void * frame, void * pod, int offset );", "	( parser frame pod offset -- )" );
	swigFunction( "c-function spa_pod_parser_current spa_pod_parser_current a -- a", "FUNCTION: spa_pod_parser_current ( parser -- a )", "EXTERN: \"C\" void * spa_pod_parser_current( void * parser );", "	( parser -- )" );
	swigFunction( "c-function spa_pod_parser_advance spa_pod_parser_advance a a -- void", "FUNCTION: spa_pod_parser_advance ( parser pod -- void )", "EXTERN: \"C\" void spa_pod_parser_advance( void * parser, void * pod );", "	( parser pod -- )" );
	swigFunction( "c-function spa_pod_parser_next spa_pod_parser_next a -- a", "FUNCTION: spa_pod_parser_next ( parser -- a )", "EXTERN: \"C\" void * spa_pod_parser_next( void * parser );", "	( parser -- )" );
	swigFunction( "c-function spa_pod_parser_pop spa_pod_parser_pop a a -- n", "FUNCTION: spa_pod_parser_pop ( parser frame -- n )", "EXTERN: \"C\" int spa_pod_parser_pop( void * parser, void * frame );", "	( parser frame -- )" );
	swigFunction( "c-function spa_pod_parser_get_bool spa_pod_parser_get_bool a a -- n", "FUNCTION: spa_pod_parser_get_bool ( parser value -- n )", "EXTERN: \"C\" int spa_pod_parser_get_bool( void * parser, void * value );", "	( parser value -- )" );
	swigFunction( "c-function spa_pod_parser_get_id spa_pod_parser_get_id a a -- n", "FUNCTION: spa_pod_parser_get_id ( parser value -- n )", "EXTERN: \"C\" int spa_pod_parser_get_id( void * parser, void * value );", "	( parser value -- )" );
	swigFunction( "c-function spa_pod_parser_get_int spa_pod_parser_get_int a a -- n", "FUNCTION: spa_pod_parser_get_int ( parser value -- n )", "EXTERN: \"C\" int spa_pod_parser_get_int( void * parser, void * value );", "	( parser value -- )" );
	swigFunction( "c-function spa_pod_parser_get_long spa_pod_parser_get_long a a -- n", "FUNCTION: spa_pod_parser_get_long ( parser value -- n )", "EXTERN: \"C\" int spa_pod_parser_get_long( void * parser, void * value );", "	( parser value -- )" );
	swigFunction( "c-function spa_pod_parser_get_float spa_pod_parser_get_float a a -- n", "FUNCTION: spa_pod_parser_get_float ( parser value -- n )", "EXTERN: \"C\" int spa_pod_parser_get_float( void * parser, void * value );", "	( parser value -- )" );
	swigFunction( "c-function spa_pod_parser_get_double spa_pod_parser_get_double a a -- n", "FUNCTION: spa_pod_parser_get_double ( parser value -- n )", "EXTERN: \"C\" int spa_pod_parser_get_double( void * parser, void * value );", "	( parser value -- )" );
	swigFunction( "c-function spa_pod_parser_get_string spa_pod_parser_get_string a a -- n", "FUNCTION: spa_pod_parser_get_string ( parser value -- n )", "EXTERN: \"C\" int spa_pod_parser_get_string( void * parser, void * value );", "	( parser value -- )" );
	swigFunction( "c-function spa_pod_parser_get_bytes spa_pod_parser_get_bytes a a a -- n", "FUNCTION: spa_pod_parser_get_bytes ( parser value len -- n )", "EXTERN: \"C\" int spa_pod_parser_get_bytes( void * parser, void * value, void * len );", "	( parser value len -- )" );
	swigFunction( "c-function spa_pod_parser_get_pointer spa_pod_parser_get_pointer a a a -- n", "FUNCTION: spa_pod_parser_get_pointer ( parser type value -- n )", "EXTERN: \"C\" int spa_pod_parser_get_pointer( void * parser, void * type, void * value );", "	( parser type value -- )" );
	swigFunction( "c-function spa_pod_parser_get_fd spa_pod_parser_get_fd a a -- n", "FUNCTION: spa_pod_parser_get_fd ( parser value -- n )", "EXTERN: \"C\" int spa_pod_parser_get_fd( void * parser, void * value );", "	( parser value -- )" );
	swigFunction( "c-function spa_pod_parser_get_rectangle spa_pod_parser_get_rectangle a a -- n", "FUNCTION: spa_pod_parser_get_rectangle ( parser value -- n )", "EXTERN: \"C\" int spa_pod_parser_get_rectangle( void * parser, void * value );", "	( parser value -- )" );
	swigFunction( "c-function spa_pod_parser_get_fraction spa_pod_parser_get_fraction a a -- n", "FUNCTION: spa_pod_parser_get_fraction ( parser value -- n )", "EXTERN: \"C\" int spa_pod_parser_get_fraction( void * parser, void * value );", "	( parser value -- )" );
	swigFunction( "c-function spa_pod_parser_get_pod spa_pod_parser_get_pod a a -- n", "FUNCTION: spa_pod_parser_get_pod ( parser value -- n )", "EXTERN: \"C\" int spa_pod_parser_get_pod( void * parser, void * value );", "	( parser value -- )" );
	swigFunction( "c-function spa_pod_parser_push_struct spa_pod_parser_push_struct a a -- n", "FUNCTION: spa_pod_parser_push_struct ( parser frame -- n )", "EXTERN: \"C\" int spa_pod_parser_push_struct( void * parser, void * frame );", "	( parser frame -- )" );
	swigFunction( "c-function spa_pod_parser_push_object spa_pod_parser_push_object a a u a -- n", "FUNCTION: spa_pod_parser_push_object ( parser frame type id -- n )", "EXTERN: \"C\" int spa_pod_parser_push_object( void * parser, void * frame, int type, void * id );", "	( parser frame type id -- )" );
	swigFunction( "c-function spa_pod_parser_can_collect spa_pod_parser_can_collect a u -- n", "FUNCTION: spa_pod_parser_can_collect ( pod type -- n )", "EXTERN: \"C\" bool spa_pod_parser_can_collect( void * pod, char type );", "	( pod type -- )" );
	swigFunction( "c-function spa_pod_parser_getv spa_pod_parser_getv a a -- n", "FUNCTION: spa_pod_parser_getv ( parser args -- n )", "EXTERN: \"C\" int spa_pod_parser_getv( void * parser, void * args );", "	( parser args -- )" );
	swigFunction( "c-function spa_pod_parser_get spa_pod_parser_get a ... -- n", "FUNCTION: spa_pod_parser_get ( parser  -- n )", "EXTERN: \"C\" int spa_pod_parser_get( void * parser, ...  );", "	( parser <noname> -- )" );
	swigFunction( "c-function spa_pod_builder_get_state spa_pod_builder_get_state a a -- void", "FUNCTION: spa_pod_builder_get_state ( builder state -- void )", "EXTERN: \"C\" void spa_pod_builder_get_state( void * builder, void * state );", "	( builder state -- )" );
	swigFunction( "c-function spa_pod_builder_set_callbacks spa_pod_builder_set_callbacks a a a -- void", "FUNCTION: spa_pod_builder_set_callbacks ( builder callbacks data -- void )", "EXTERN: \"C\" void spa_pod_builder_set_callbacks( void * builder, void * callbacks, void * data );", "	( builder callbacks data -- )" );
	swigFunction( "c-function spa_pod_builder_reset spa_pod_builder_reset a a -- void", "FUNCTION: spa_pod_builder_reset ( builder state -- void )", "EXTERN: \"C\" void spa_pod_builder_reset( void * builder, void * state );", "	( builder state -- )" );
	swigFunction( "c-function spa_pod_builder_init spa_pod_builder_init a a u -- void", "FUNCTION: spa_pod_builder_init ( builder data size -- void )", "EXTERN: \"C\" void spa_pod_builder_init( void * builder, void * data, int size );", "	( builder data size -- )" );
	swigFunction( "c-function spa_pod_builder_deref spa_pod_builder_deref a u -- a", "FUNCTION: spa_pod_builder_deref ( builder offset -- a )", "EXTERN: \"C\" void * spa_pod_builder_deref( void * builder, int offset );", "	( builder offset -- )" );
	swigFunction( "c-function spa_pod_builder_frame spa_pod_builder_frame a a -- a", "FUNCTION: spa_pod_builder_frame ( builder frame -- a )", "EXTERN: \"C\" void * spa_pod_builder_frame( void * builder, void * frame );", "	( builder frame -- )" );
	swigFunction( "c-function spa_pod_builder_push spa_pod_builder_push a a a u -- void", "FUNCTION: spa_pod_builder_push ( builder frame pod offset -- void )", "EXTERN: \"C\" void spa_pod_builder_push( void * builder, void * frame, void * pod, int offset );", "	( builder frame pod offset -- )" );
	swigFunction( "c-function spa_pod_builder_raw spa_pod_builder_raw a a u -- n", "FUNCTION: spa_pod_builder_raw ( builder data size -- n )", "EXTERN: \"C\" int spa_pod_builder_raw( void * builder, void * data, int size );", "	( builder data size -- )" );
	swigFunction( "c-function spa_pod_builder_pad spa_pod_builder_pad a u -- n", "FUNCTION: spa_pod_builder_pad ( builder size -- n )", "EXTERN: \"C\" int spa_pod_builder_pad( void * builder, int size );", "	( builder size -- )" );
	swigFunction( "c-function spa_pod_builder_raw_padded spa_pod_builder_raw_padded a a u -- n", "FUNCTION: spa_pod_builder_raw_padded ( builder data size -- n )", "EXTERN: \"C\" int spa_pod_builder_raw_padded( void * builder, void * data, int size );", "	( builder data size -- )" );
	swigFunction( "c-function spa_pod_builder_pop spa_pod_builder_pop a a -- a", "FUNCTION: spa_pod_builder_pop ( builder frame -- a )", "EXTERN: \"C\" void * spa_pod_builder_pop( void * builder, void * frame );", "	( builder frame -- )" );
	swigFunction( "c-function spa_pod_builder_primitive spa_pod_builder_primitive a a -- n", "FUNCTION: spa_pod_builder_primitive ( builder p -- n )", "EXTERN: \"C\" int spa_pod_builder_primitive( void * builder, void * p );", "	( builder p -- )" );
	swigFunction( "c-function spa_pod_builder_none spa_pod_builder_none a -- n", "FUNCTION: spa_pod_builder_none ( builder -- n )", "EXTERN: \"C\" int spa_pod_builder_none( void * builder );", "	( builder -- )" );
	swigFunction( "c-function spa_pod_builder_child spa_pod_builder_child a u u -- n", "FUNCTION: spa_pod_builder_child ( builder size type -- n )", "EXTERN: \"C\" int spa_pod_builder_child( void * builder, int size, int type );", "	( builder size type -- )" );
	swigFunction( "c-function spa_pod_builder_bool spa_pod_builder_bool a n -- n", "FUNCTION: spa_pod_builder_bool ( builder val -- n )", "EXTERN: \"C\" int spa_pod_builder_bool( void * builder, bool val );", "	( builder val -- )" );
	swigFunction( "c-function spa_pod_builder_id spa_pod_builder_id a u -- n", "FUNCTION: spa_pod_builder_id ( builder val -- n )", "EXTERN: \"C\" int spa_pod_builder_id( void * builder, int val );", "	( builder val -- )" );
	swigFunction( "c-function spa_pod_builder_int spa_pod_builder_int a n -- n", "FUNCTION: spa_pod_builder_int ( builder val -- n )", "EXTERN: \"C\" int spa_pod_builder_int( void * builder, int val );", "	( builder val -- )" );
	swigFunction( "c-function spa_pod_builder_long spa_pod_builder_long a d -- n", "FUNCTION: spa_pod_builder_long ( builder val -- n )", "EXTERN: \"C\" int spa_pod_builder_long( void * builder, long long val );", "	( builder val -- )" );
	swigFunction( "c-function spa_pod_builder_float spa_pod_builder_float a r -- n", "FUNCTION: spa_pod_builder_float ( builder val -- n )", "EXTERN: \"C\" int spa_pod_builder_float( void * builder, float val );", "	( builder val -- )" );
	swigFunction( "c-function spa_pod_builder_double spa_pod_builder_double a r -- n", "FUNCTION: spa_pod_builder_double ( builder val -- n )", "EXTERN: \"C\" int spa_pod_builder_double( void * builder, double val );", "	( builder val -- )" );
	swigFunction( "c-function spa_pod_builder_write_string spa_pod_builder_write_string a s u -- n", "FUNCTION: spa_pod_builder_write_string ( builder str len -- n )", "EXTERN: \"C\" int spa_pod_builder_write_string( void * builder, char * str, int len );", "	( builder str len -- )" );
	swigFunction( "c-function spa_pod_builder_string_len spa_pod_builder_string_len a s u -- n", "FUNCTION: spa_pod_builder_string_len ( builder str len -- n )", "EXTERN: \"C\" int spa_pod_builder_string_len( void * builder, char * str, int len );", "	( builder str len -- )" );
	swigFunction( "c-function spa_pod_builder_string spa_pod_builder_string a s -- n", "FUNCTION: spa_pod_builder_string ( builder str -- n )", "EXTERN: \"C\" int spa_pod_builder_string( void * builder, char * str );", "	( builder str -- )" );
	swigFunction( "c-function spa_pod_builder_bytes spa_pod_builder_bytes a a u -- n", "FUNCTION: spa_pod_builder_bytes ( builder bytes len -- n )", "EXTERN: \"C\" int spa_pod_builder_bytes( void * builder, void * bytes, int len );", "	( builder bytes len -- )" );
	swigFunction( "c-function spa_pod_builder_reserve_bytes spa_pod_builder_reserve_bytes a u -- a", "FUNCTION: spa_pod_builder_reserve_bytes ( builder len -- a )", "EXTERN: \"C\" void * spa_pod_builder_reserve_bytes( void * builder, int len );", "	( builder len -- )" );
	swigFunction( "c-function spa_pod_builder_pointer spa_pod_builder_pointer a u a -- n", "FUNCTION: spa_pod_builder_pointer ( builder type val -- n )", "EXTERN: \"C\" int spa_pod_builder_pointer( void * builder, int type, void * val );", "	( builder type val -- )" );
	swigFunction( "c-function spa_pod_builder_fd spa_pod_builder_fd a d -- n", "FUNCTION: spa_pod_builder_fd ( builder fd -- n )", "EXTERN: \"C\" int spa_pod_builder_fd( void * builder, long long fd );", "	( builder fd -- )" );
	swigFunction( "c-function spa_pod_builder_rectangle spa_pod_builder_rectangle a u u -- n", "FUNCTION: spa_pod_builder_rectangle ( builder width height -- n )", "EXTERN: \"C\" int spa_pod_builder_rectangle( void * builder, int width, int height );", "	( builder width height -- )" );
	swigFunction( "c-function spa_pod_builder_fraction spa_pod_builder_fraction a u u -- n", "FUNCTION: spa_pod_builder_fraction ( builder num denom -- n )", "EXTERN: \"C\" int spa_pod_builder_fraction( void * builder, int num, int denom );", "	( builder num denom -- )" );
	swigFunction( "c-function spa_pod_builder_push_array spa_pod_builder_push_array a a -- n", "FUNCTION: spa_pod_builder_push_array ( builder frame -- n )", "EXTERN: \"C\" int spa_pod_builder_push_array( void * builder, void * frame );", "	( builder frame -- )" );
	swigFunction( "c-function spa_pod_builder_array spa_pod_builder_array a u u u a -- n", "FUNCTION: spa_pod_builder_array ( builder child_size child_type n_elems elems -- n )", "EXTERN: \"C\" int spa_pod_builder_array( void * builder, int child_size, int child_type, int n_elems, void * elems );", "	( builder child_size child_type n_elems elems -- )" );
	swigFunction( "c-function spa_pod_builder_push_choice spa_pod_builder_push_choice a a u u -- n", "FUNCTION: spa_pod_builder_push_choice ( builder frame type flags -- n )", "EXTERN: \"C\" int spa_pod_builder_push_choice( void * builder, void * frame, int type, int flags );", "	( builder frame type flags -- )" );
	swigFunction( "c-function spa_pod_builder_push_struct spa_pod_builder_push_struct a a -- n", "FUNCTION: spa_pod_builder_push_struct ( builder frame -- n )", "EXTERN: \"C\" int spa_pod_builder_push_struct( void * builder, void * frame );", "	( builder frame -- )" );
	swigFunction( "c-function spa_pod_builder_push_object spa_pod_builder_push_object a a u u -- n", "FUNCTION: spa_pod_builder_push_object ( builder frame type id -- n )", "EXTERN: \"C\" int spa_pod_builder_push_object( void * builder, void * frame, int type, int id );", "	( builder frame type id -- )" );
	swigFunction( "c-function spa_pod_builder_prop spa_pod_builder_prop a u u -- n", "FUNCTION: spa_pod_builder_prop ( builder key flags -- n )", "EXTERN: \"C\" int spa_pod_builder_prop( void * builder, int key, int flags );", "	( builder key flags -- )" );
	swigFunction( "c-function spa_pod_builder_push_sequence spa_pod_builder_push_sequence a a u -- n", "FUNCTION: spa_pod_builder_push_sequence ( builder frame unit -- n )", "EXTERN: \"C\" int spa_pod_builder_push_sequence( void * builder, void * frame, int unit );", "	( builder frame unit -- )" );
	swigFunction( "c-function spa_pod_builder_control spa_pod_builder_control a u u -- n", "FUNCTION: spa_pod_builder_control ( builder offset type -- n )", "EXTERN: \"C\" int spa_pod_builder_control( void * builder, int offset, int type );", "	( builder offset type -- )" );
	swigFunction( "c-function spa_choice_from_id spa_choice_from_id u -- u", "FUNCTION: spa_choice_from_id ( id -- u )", "EXTERN: \"C\" int spa_choice_from_id( char id );", "	( id -- )" );
	swigFunction( "c-function spa_pod_builder_addv spa_pod_builder_addv a a -- n", "FUNCTION: spa_pod_builder_addv ( builder args -- n )", "EXTERN: \"C\" int spa_pod_builder_addv( void * builder, void * args );", "	( builder args -- )" );
	swigFunction( "c-function spa_pod_builder_add spa_pod_builder_add a ... -- n", "FUNCTION: spa_pod_builder_add ( builder  -- n )", "EXTERN: \"C\" int spa_pod_builder_add( void * builder, ...  );", "	( builder <noname> -- )" );
	swigFunction( "c-function spa_pod_copy spa_pod_copy a -- a", "FUNCTION: spa_pod_copy ( pod -- a )", "EXTERN: \"C\" void * spa_pod_copy( void * pod );", "	( pod -- )" );
	swigFunction( "c-function spa_format_parse spa_format_parse a a a -- n", "FUNCTION: spa_format_parse ( format media_type media_subtype -- n )", "EXTERN: \"C\" int spa_format_parse( void * format, void * media_type, void * media_subtype );", "	( format media_type media_subtype -- )" );
	swigFunction( "c-function spa_format_audio_raw_parse spa_format_audio_raw_parse a a -- n", "FUNCTION: spa_format_audio_raw_parse ( format info -- n )", "EXTERN: \"C\" int spa_format_audio_raw_parse( void * format, void * info );", "	( format info -- )" );
	swigFunction( "c-function spa_format_audio_raw_build spa_format_audio_raw_build a u a -- a", "FUNCTION: spa_format_audio_raw_build ( builder id info -- a )", "EXTERN: \"C\" void * spa_format_audio_raw_build( void * builder, int id, void * info );", "	( builder id info -- )" );
	swigFunction( "c-function spa_format_audio_dsp_parse spa_format_audio_dsp_parse a a -- n", "FUNCTION: spa_format_audio_dsp_parse ( format info -- n )", "EXTERN: \"C\" int spa_format_audio_dsp_parse( void * format, void * info );", "	( format info -- )" );
	swigFunction( "c-function spa_format_audio_dsp_build spa_format_audio_dsp_build a u a -- a", "FUNCTION: spa_format_audio_dsp_build ( builder id info -- a )", "EXTERN: \"C\" void * spa_format_audio_dsp_build( void * builder, int id, void * info );", "	( builder id info -- )" );
	swigFunction( "c-function spa_format_audio_iec958_parse spa_format_audio_iec958_parse a a -- n", "FUNCTION: spa_format_audio_iec958_parse ( format info -- n )", "EXTERN: \"C\" int spa_format_audio_iec958_parse( void * format, void * info );", "	( format info -- )" );
	swigFunction( "c-function spa_format_audio_iec958_build spa_format_audio_iec958_build a u a -- a", "FUNCTION: spa_format_audio_iec958_build ( builder id info -- a )", "EXTERN: \"C\" void * spa_format_audio_iec958_build( void * builder, int id, void * info );", "	( builder id info -- )" );
	swigFunction( "c-function spa_format_audio_dsd_parse spa_format_audio_dsd_parse a a -- n", "FUNCTION: spa_format_audio_dsd_parse ( format info -- n )", "EXTERN: \"C\" int spa_format_audio_dsd_parse( void * format, void * info );", "	( format info -- )" );
	swigFunction( "c-function spa_format_audio_dsd_build spa_format_audio_dsd_build a u a -- a", "FUNCTION: spa_format_audio_dsd_build ( builder id info -- a )", "EXTERN: \"C\" void * spa_format_audio_dsd_build( void * builder, int id, void * info );", "	( builder id info -- )" );
	swigFunction( "c-function spa_format_audio_mp3_parse spa_format_audio_mp3_parse a a -- n", "FUNCTION: spa_format_audio_mp3_parse ( format info -- n )", "EXTERN: \"C\" int spa_format_audio_mp3_parse( void * format, void * info );", "	( format info -- )" );
	swigFunction( "c-function spa_format_audio_mp3_build spa_format_audio_mp3_build a u a -- a", "FUNCTION: spa_format_audio_mp3_build ( builder id info -- a )", "EXTERN: \"C\" void * spa_format_audio_mp3_build( void * builder, int id, void * info );", "	( builder id info -- )" );
	swigFunction( "c-function spa_format_audio_aac_parse spa_format_audio_aac_parse a a -- n", "FUNCTION: spa_format_audio_aac_parse ( format info -- n )", "EXTERN: \"C\" int spa_format_audio_aac_parse( void * format, void * info );", "	( format info -- )" );
	swigFunction( "c-function spa_format_audio_aac_build spa_format_audio_aac_build a u a -- a", "FUNCTION: spa_format_audio_aac_build ( builder id info -- a )", "EXTERN: \"C\" void * spa_format_audio_aac_build( void * builder, int id, void * info );", "	( builder id info -- )" );
	swigFunction( "c-function spa_format_audio_vorbis_parse spa_format_audio_vorbis_parse a a -- n", "FUNCTION: spa_format_audio_vorbis_parse ( format info -- n )", "EXTERN: \"C\" int spa_format_audio_vorbis_parse( void * format, void * info );", "	( format info -- )" );
	swigFunction( "c-function spa_format_audio_vorbis_build spa_format_audio_vorbis_build a u a -- a", "FUNCTION: spa_format_audio_vorbis_build ( builder id info -- a )", "EXTERN: \"C\" void * spa_format_audio_vorbis_build( void * builder, int id, void * info );", "	( builder id info -- )" );
	swigFunction( "c-function spa_format_audio_wma_parse spa_format_audio_wma_parse a a -- n", "FUNCTION: spa_format_audio_wma_parse ( format info -- n )", "EXTERN: \"C\" int spa_format_audio_wma_parse( void * format, void * info );", "	( format info -- )" );
	swigFunction( "c-function spa_format_audio_wma_build spa_format_audio_wma_build a u a -- a", "FUNCTION: spa_format_audio_wma_build ( builder id info -- a )", "EXTERN: \"C\" void * spa_format_audio_wma_build( void * builder, int id, void * info );", "	( builder id info -- )" );
	swigFunction( "c-function spa_format_audio_ra_parse spa_format_audio_ra_parse a a -- n", "FUNCTION: spa_format_audio_ra_parse ( format info -- n )", "EXTERN: \"C\" int spa_format_audio_ra_parse( void * format, void * info );", "	( format info -- )" );
	swigFunction( "c-function spa_format_audio_ra_build spa_format_audio_ra_build a u a -- a", "FUNCTION: spa_format_audio_ra_build ( builder id info -- a )", "EXTERN: \"C\" void * spa_format_audio_ra_build( void * builder, int id, void * info );", "	( builder id info -- )" );
	swigFunction( "c-function spa_format_audio_amr_parse spa_format_audio_amr_parse a a -- n", "FUNCTION: spa_format_audio_amr_parse ( format info -- n )", "EXTERN: \"C\" int spa_format_audio_amr_parse( void * format, void * info );", "	( format info -- )" );
	swigFunction( "c-function spa_format_audio_amr_build spa_format_audio_amr_build a u a -- a", "FUNCTION: spa_format_audio_amr_build ( builder id info -- a )", "EXTERN: \"C\" void * spa_format_audio_amr_build( void * builder, int id, void * info );", "	( builder id info -- )" );
	swigFunction( "c-function spa_format_audio_alac_parse spa_format_audio_alac_parse a a -- n", "FUNCTION: spa_format_audio_alac_parse ( format info -- n )", "EXTERN: \"C\" int spa_format_audio_alac_parse( void * format, void * info );", "	( format info -- )" );
	swigFunction( "c-function spa_format_audio_alac_build spa_format_audio_alac_build a u a -- a", "FUNCTION: spa_format_audio_alac_build ( builder id info -- a )", "EXTERN: \"C\" void * spa_format_audio_alac_build( void * builder, int id, void * info );", "	( builder id info -- )" );
	swigFunction( "c-function spa_format_audio_flac_parse spa_format_audio_flac_parse a a -- n", "FUNCTION: spa_format_audio_flac_parse ( format info -- n )", "EXTERN: \"C\" int spa_format_audio_flac_parse( void * format, void * info );", "	( format info -- )" );
	swigFunction( "c-function spa_format_audio_flac_build spa_format_audio_flac_build a u a -- a", "FUNCTION: spa_format_audio_flac_build ( builder id info -- a )", "EXTERN: \"C\" void * spa_format_audio_flac_build( void * builder, int id, void * info );", "	( builder id info -- )" );
	swigFunction( "c-function spa_format_audio_ape_parse spa_format_audio_ape_parse a a -- n", "FUNCTION: spa_format_audio_ape_parse ( format info -- n )", "EXTERN: \"C\" int spa_format_audio_ape_parse( void * format, void * info );", "	( format info -- )" );
	swigFunction( "c-function spa_format_audio_ape_build spa_format_audio_ape_build a u a -- a", "FUNCTION: spa_format_audio_ape_build ( builder id info -- a )", "EXTERN: \"C\" void * spa_format_audio_ape_build( void * builder, int id, void * info );", "	( builder id info -- )" );
	swigFunction( "c-function spa_format_audio_parse spa_format_audio_parse a a -- n", "FUNCTION: spa_format_audio_parse ( format info -- n )", "EXTERN: \"C\" int spa_format_audio_parse( void * format, void * info );", "	( format info -- )" );
	swigFunction( "c-function spa_format_audio_build spa_format_audio_build a u a -- a", "FUNCTION: spa_format_audio_build ( builder id info -- a )", "EXTERN: \"C\" void * spa_format_audio_build( void * builder, int id, void * info );", "	( builder id info -- )" );
	swigFunction( "c-function spa_format_video_raw_parse spa_format_video_raw_parse a a -- n", "FUNCTION: spa_format_video_raw_parse ( format info -- n )", "EXTERN: \"C\" int spa_format_video_raw_parse( void * format, void * info );", "	( format info -- )" );
	swigFunction( "c-function spa_format_video_raw_build spa_format_video_raw_build a u a -- a", "FUNCTION: spa_format_video_raw_build ( builder id info -- a )", "EXTERN: \"C\" void * spa_format_video_raw_build( void * builder, int id, void * info );", "	( builder id info -- )" );
	swigFunction( "c-function spa_format_video_dsp_parse spa_format_video_dsp_parse a a -- n", "FUNCTION: spa_format_video_dsp_parse ( format info -- n )", "EXTERN: \"C\" int spa_format_video_dsp_parse( void * format, void * info );", "	( format info -- )" );
	swigFunction( "c-function spa_format_video_dsp_build spa_format_video_dsp_build a u a -- a", "FUNCTION: spa_format_video_dsp_build ( builder id info -- a )", "EXTERN: \"C\" void * spa_format_video_dsp_build( void * builder, int id, void * info );", "	( builder id info -- )" );
	swigFunction( "c-function spa_format_video_h264_parse spa_format_video_h264_parse a a -- n", "FUNCTION: spa_format_video_h264_parse ( format info -- n )", "EXTERN: \"C\" int spa_format_video_h264_parse( void * format, void * info );", "	( format info -- )" );
	swigFunction( "c-function spa_format_video_h264_build spa_format_video_h264_build a u a -- a", "FUNCTION: spa_format_video_h264_build ( builder id info -- a )", "EXTERN: \"C\" void * spa_format_video_h264_build( void * builder, int id, void * info );", "	( builder id info -- )" );
	swigFunction( "c-function spa_format_video_mjpg_parse spa_format_video_mjpg_parse a a -- n", "FUNCTION: spa_format_video_mjpg_parse ( format info -- n )", "EXTERN: \"C\" int spa_format_video_mjpg_parse( void * format, void * info );", "	( format info -- )" );
	swigFunction( "c-function spa_format_video_mjpg_build spa_format_video_mjpg_build a u a -- a", "FUNCTION: spa_format_video_mjpg_build ( builder id info -- a )", "EXTERN: \"C\" void * spa_format_video_mjpg_build( void * builder, int id, void * info );", "	( builder id info -- )" );
	swigFunction( "c-function spa_format_video_parse spa_format_video_parse a a -- n", "FUNCTION: spa_format_video_parse ( format info -- n )", "EXTERN: \"C\" int spa_format_video_parse( void * format, void * info );", "	( format info -- )" );
	swigFunction( "c-function spa_format_video_build spa_format_video_build a u a -- a", "FUNCTION: spa_format_video_build ( builder id info -- a )", "EXTERN: \"C\" void * spa_format_video_build( void * builder, int id, void * info );", "	( builder id info -- )" );

	swigNewline();

	swigComment("----===< postfix >===-----\n");

	swigPrint( "end-c-library", "( none )", "( none )" );
	
	return 0;
} /* end of main */



