/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 3.0.9
 *
 * This file is not intended to be easily readable and contains a number of
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG
 * interface file instead.
 * ----------------------------------------------------------------------------- */
#include <stdio.h>
#include <string.h>
#include <stddef.h>

// Do not edit below this line
// end-of-default-includes


#include <harfbuzz/hb.h>
#include <harfbuzz/hb-ft.h>
#ifdef __gnu_linux__
#undef stderr
extern struct _IO_FILE *stderr;
#endif
#undef hb_glyph_info_get_glyph_flags
#define HB_MIN_VER(x, y) (HB_VERSION_MAJOR > x || (HB_VERSION_MAJOR == x && HB_VERSION_MINOR >= y))

typedef enum{ NONE = -1, GFORTH = 0, SWIFTFORTH, VFX } SwigTargetSystem;
SwigTargetSystem swigTargetSystem = NONE;

unsigned char swigPrintStackComments = 1;

/* comments */
void swigNewline()
{
	printf( "\n" );
}

void swigComment( char *comment )
{
	printf( "\\ %s", comment );
}

/* generic print */
void swigPrint( char* gforth, char *swiftForth, char *vfx )
{
	if( swigTargetSystem == GFORTH )
		printf( "%s", gforth );
	else if( swigTargetSystem == SWIFTFORTH )
		printf( "%s", swiftForth );
	else if( swigTargetSystem == VFX )
		printf( "%s", vfx );
	printf( "\n" );
}
void swigPrintSystem( SwigTargetSystem targetSystem, char *text )
{
	if( targetSystem == swigTargetSystem )
	    printf( "%s\n", text );
}

/* constants */
void swigIntConstant( long constant, char *name )
{
	printf( "#%ld\tconstant %s\n", constant, name );
}

void swigUnsignedIntConstant( unsigned long constant, char *name )
{
	printf( "#%lu\tconstant %s\n", constant, name );
}

void swigLongConstant( long long constant, char *name )
{
	printf( "#%lld.\t2constant %s\n", constant, name );
}

void swigUnsignedLongConstant( unsigned long long constant, char *name )
{
	printf( "#%llu.\t2constant %s\n", constant, name );
}

void swigFloatConstant( double constant, char *name )
{
	char buffer[128];
	sprintf( buffer, "%f", constant );

	/* if the constant contains no exponent, add one */
	char *s;
	for( s = buffer; *s != 0; s++ )
		if( *s == 'e' || *s == 'E' )
			break;

	/* exponent found */
	if( *s != 0 )
		printf( "%s\tfconstant %s\n", buffer, name );
	/* not found */
	else
		printf( "%se0\tfconstant %s\n", buffer, name );
}

void swigStringConstant( char* constant, char *name )
{
	char c;
	printf( ": %s s\\\" ", name );
	while(( c = *constant++ ))
	{
		switch(c)
		{
			case '\b': printf( "\\b" ); break;
			case '\n': printf( "\\n" ); break;
			case '\f': printf( "\\f" ); break;
			case '\r': printf( "\\r" ); break;
			case '\t': printf( "\\t" ); break;
			case '"' : printf( "\\q" ); break;
			default:
				if(c < 0x20)
					printf("\\x%02x", c);
				else
					printf("%c", c); break;
		}
	}
	printf(	"\" ;\n" );
}

/* structs */
void swigStructField( char *name, size_t offset, size_t size )
{
	printf( "\tdrop %zu %zu +field %s\n", offset, size, name );
}

/* functions */
void swigFunction( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	if( swigTargetSystem == GFORTH )
		printf( "%s", gforth );
	else if( swigTargetSystem == SWIFTFORTH )
		printf( "%s", swiftForth );
	else if( swigTargetSystem == VFX )
		printf( "%s", vfx );

	if( swigPrintStackComments )
		printf( "%s", stackComment );

	printf( "\n" );
}

/* function pointers */
void swigFunctionPointer( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	swigFunction( gforth, swiftForth, vfx, stackComment );
}

/* callbacks */
void swigCallback( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	swigFunction( gforth, swiftForth, vfx, stackComment );
}

void swigUsage( char **argv )
{
	fprintf( stderr, "Usage: %s [-gforth|-swiftforth|-vfx]\n", argv[0] );
}

int main( int argc, char **argv )
{
	int i;

	/* check arguments */
	for( i = 1; i < argc; i++ )
		if( strcmp( argv[i], "-gforth" ) == 0 )
			swigTargetSystem = GFORTH;
		else if( strcmp( argv[i], "-swiftforth" ) == 0 )
			swigTargetSystem = SWIFTFORTH;
		else if( strcmp( argv[i], "-vfx" ) == 0 )
			swigTargetSystem = VFX;

	if( swigTargetSystem == NONE )
	{
		fprintf( stderr, "Error: no target system specified\n" );
		swigUsage( argv );
		return 1;
	}

	/* primer */
	printf( "\\ This file has been generated using SWIG and fsi,\n"
		"\\ and is already platform dependent, search for the corresponding\n"
		"\\ fsi-file to compile it where no one has compiled it before ;)\n"
		"\\ Forth systems have their own own dynamic loader and don't need addional C-Code.\n"
		"\\ That's why this file will just print normal forth-code once compiled\n"
		"\\ and can be used directly with include or require.\n"
		"\\ As all comments are stripped during the compilation, please\n"
		"\\ insert the copyright notice of the original file here.\n"
	);



	swigNewline();

	swigComment("----===< prefix >===-----\n");

	swigPrint( "c-library harfbuzz\ns\" harfbuzz\" add-lib\n\\c #include <harfbuzz/hb.h>\n\\c #include <harfbuzz/hb-ft.h>\n\\c #ifdef __gnu_linux__\n\\c #undef stderr\n\\c extern struct _IO_FILE *stderr;\n\\c #endif\n\\c #undef hb_glyph_info_get_glyph_flags\n\\c #define HB_MIN_VER(x, y) (HB_VERSION_MAJOR > x || (HB_VERSION_MAJOR == x && HB_VERSION_MINOR >= y))", "( none )", "( none )" );

	swigNewline();

	swigComment("----===< int constants >===-----\n");
	#ifdef HB_BUFFER_REPLACEMENT_CODEPOINT_DEFAULT
		swigUnsignedIntConstant( HB_BUFFER_REPLACEMENT_CODEPOINT_DEFAULT, "HB_BUFFER_REPLACEMENT_CODEPOINT_DEFAULT" );
	#endif
	#ifdef HB_FEATURE_GLOBAL_START
		swigIntConstant( HB_FEATURE_GLOBAL_START, "HB_FEATURE_GLOBAL_START" );
	#endif
	#ifdef HB_FONT_NO_VAR_NAMED_INSTANCE
		swigIntConstant( HB_FONT_NO_VAR_NAMED_INSTANCE, "HB_FONT_NO_VAR_NAMED_INSTANCE" );
	#endif
	#ifdef HB_UNICODE_MAX
		swigUnsignedIntConstant( HB_UNICODE_MAX, "HB_UNICODE_MAX" );
	#endif
	#ifdef HB_VERSION_MAJOR
		swigIntConstant( HB_VERSION_MAJOR, "HB_VERSION_MAJOR" );
	#endif
	#ifdef HB_VERSION_MINOR
		swigIntConstant( HB_VERSION_MINOR, "HB_VERSION_MINOR" );
	#endif
	#ifdef HB_VERSION_MICRO
		swigIntConstant( HB_VERSION_MICRO, "HB_VERSION_MICRO" );
	#endif

	swigNewline();

	swigComment("--------===< enums >===---------\n");
	swigIntConstant( HB_MEMORY_MODE_DUPLICATE, "HB_MEMORY_MODE_DUPLICATE" );
	swigIntConstant( HB_MEMORY_MODE_READONLY, "HB_MEMORY_MODE_READONLY" );
	swigIntConstant( HB_MEMORY_MODE_WRITABLE, "HB_MEMORY_MODE_WRITABLE" );
	swigIntConstant( HB_MEMORY_MODE_READONLY_MAY_MAKE_WRITABLE, "HB_MEMORY_MODE_READONLY_MAY_MAKE_WRITABLE" );
	swigIntConstant( HB_GLYPH_FLAG_UNSAFE_TO_BREAK, "HB_GLYPH_FLAG_UNSAFE_TO_BREAK" );
	swigIntConstant( HB_GLYPH_FLAG_UNSAFE_TO_CONCAT, "HB_GLYPH_FLAG_UNSAFE_TO_CONCAT" );
	swigIntConstant( HB_GLYPH_FLAG_SAFE_TO_INSERT_TATWEEL, "HB_GLYPH_FLAG_SAFE_TO_INSERT_TATWEEL" );
	swigIntConstant( HB_GLYPH_FLAG_DEFINED, "HB_GLYPH_FLAG_DEFINED" );
	swigIntConstant( HB_BUFFER_CONTENT_TYPE_INVALID, "HB_BUFFER_CONTENT_TYPE_INVALID" );
	swigIntConstant( HB_BUFFER_CONTENT_TYPE_UNICODE, "HB_BUFFER_CONTENT_TYPE_UNICODE" );
	swigIntConstant( HB_BUFFER_CONTENT_TYPE_GLYPHS, "HB_BUFFER_CONTENT_TYPE_GLYPHS" );
	swigIntConstant( HB_BUFFER_FLAG_DEFAULT, "HB_BUFFER_FLAG_DEFAULT" );
	swigIntConstant( HB_BUFFER_FLAG_BOT, "HB_BUFFER_FLAG_BOT" );
	swigIntConstant( HB_BUFFER_FLAG_EOT, "HB_BUFFER_FLAG_EOT" );
	swigIntConstant( HB_BUFFER_FLAG_PRESERVE_DEFAULT_IGNORABLES, "HB_BUFFER_FLAG_PRESERVE_DEFAULT_IGNORABLES" );
	swigIntConstant( HB_BUFFER_FLAG_REMOVE_DEFAULT_IGNORABLES, "HB_BUFFER_FLAG_REMOVE_DEFAULT_IGNORABLES" );
	swigIntConstant( HB_BUFFER_FLAG_DO_NOT_INSERT_DOTTED_CIRCLE, "HB_BUFFER_FLAG_DO_NOT_INSERT_DOTTED_CIRCLE" );
	swigIntConstant( HB_BUFFER_FLAG_VERIFY, "HB_BUFFER_FLAG_VERIFY" );
	swigIntConstant( HB_BUFFER_FLAG_PRODUCE_UNSAFE_TO_CONCAT, "HB_BUFFER_FLAG_PRODUCE_UNSAFE_TO_CONCAT" );
	swigIntConstant( HB_BUFFER_FLAG_PRODUCE_SAFE_TO_INSERT_TATWEEL, "HB_BUFFER_FLAG_PRODUCE_SAFE_TO_INSERT_TATWEEL" );
	swigIntConstant( HB_BUFFER_FLAG_DEFINED, "HB_BUFFER_FLAG_DEFINED" );
	swigIntConstant( HB_BUFFER_CLUSTER_LEVEL_MONOTONE_GRAPHEMES, "HB_BUFFER_CLUSTER_LEVEL_MONOTONE_GRAPHEMES" );
	swigIntConstant( HB_BUFFER_CLUSTER_LEVEL_MONOTONE_CHARACTERS, "HB_BUFFER_CLUSTER_LEVEL_MONOTONE_CHARACTERS" );
	swigIntConstant( HB_BUFFER_CLUSTER_LEVEL_CHARACTERS, "HB_BUFFER_CLUSTER_LEVEL_CHARACTERS" );
	swigIntConstant( HB_BUFFER_CLUSTER_LEVEL_DEFAULT, "HB_BUFFER_CLUSTER_LEVEL_DEFAULT" );
	swigIntConstant( HB_BUFFER_SERIALIZE_FLAG_DEFAULT, "HB_BUFFER_SERIALIZE_FLAG_DEFAULT" );
	swigIntConstant( HB_BUFFER_SERIALIZE_FLAG_NO_CLUSTERS, "HB_BUFFER_SERIALIZE_FLAG_NO_CLUSTERS" );
	swigIntConstant( HB_BUFFER_SERIALIZE_FLAG_NO_POSITIONS, "HB_BUFFER_SERIALIZE_FLAG_NO_POSITIONS" );
	swigIntConstant( HB_BUFFER_SERIALIZE_FLAG_NO_GLYPH_NAMES, "HB_BUFFER_SERIALIZE_FLAG_NO_GLYPH_NAMES" );
	swigIntConstant( HB_BUFFER_SERIALIZE_FLAG_GLYPH_EXTENTS, "HB_BUFFER_SERIALIZE_FLAG_GLYPH_EXTENTS" );
	swigIntConstant( HB_BUFFER_SERIALIZE_FLAG_GLYPH_FLAGS, "HB_BUFFER_SERIALIZE_FLAG_GLYPH_FLAGS" );
	swigIntConstant( HB_BUFFER_SERIALIZE_FLAG_NO_ADVANCES, "HB_BUFFER_SERIALIZE_FLAG_NO_ADVANCES" );
	swigIntConstant( HB_BUFFER_SERIALIZE_FLAG_DEFINED, "HB_BUFFER_SERIALIZE_FLAG_DEFINED" );
	swigIntConstant( HB_BUFFER_SERIALIZE_FORMAT_TEXT, "HB_BUFFER_SERIALIZE_FORMAT_TEXT" );
	swigIntConstant( HB_BUFFER_SERIALIZE_FORMAT_JSON, "HB_BUFFER_SERIALIZE_FORMAT_JSON" );
	swigIntConstant( HB_BUFFER_SERIALIZE_FORMAT_INVALID, "HB_BUFFER_SERIALIZE_FORMAT_INVALID" );
	swigIntConstant( HB_BUFFER_DIFF_FLAG_EQUAL, "HB_BUFFER_DIFF_FLAG_EQUAL" );
	swigIntConstant( HB_BUFFER_DIFF_FLAG_CONTENT_TYPE_MISMATCH, "HB_BUFFER_DIFF_FLAG_CONTENT_TYPE_MISMATCH" );
	swigIntConstant( HB_BUFFER_DIFF_FLAG_LENGTH_MISMATCH, "HB_BUFFER_DIFF_FLAG_LENGTH_MISMATCH" );
	swigIntConstant( HB_BUFFER_DIFF_FLAG_NOTDEF_PRESENT, "HB_BUFFER_DIFF_FLAG_NOTDEF_PRESENT" );
	swigIntConstant( HB_BUFFER_DIFF_FLAG_DOTTED_CIRCLE_PRESENT, "HB_BUFFER_DIFF_FLAG_DOTTED_CIRCLE_PRESENT" );
	swigIntConstant( HB_BUFFER_DIFF_FLAG_CODEPOINT_MISMATCH, "HB_BUFFER_DIFF_FLAG_CODEPOINT_MISMATCH" );
	swigIntConstant( HB_BUFFER_DIFF_FLAG_CLUSTER_MISMATCH, "HB_BUFFER_DIFF_FLAG_CLUSTER_MISMATCH" );
	swigIntConstant( HB_BUFFER_DIFF_FLAG_GLYPH_FLAGS_MISMATCH, "HB_BUFFER_DIFF_FLAG_GLYPH_FLAGS_MISMATCH" );
	swigIntConstant( HB_BUFFER_DIFF_FLAG_POSITION_MISMATCH, "HB_BUFFER_DIFF_FLAG_POSITION_MISMATCH" );
	swigIntConstant( HB_DIRECTION_INVALID, "HB_DIRECTION_INVALID" );
	swigIntConstant( HB_DIRECTION_LTR, "HB_DIRECTION_LTR" );
	swigIntConstant( HB_DIRECTION_RTL, "HB_DIRECTION_RTL" );
	swigIntConstant( HB_DIRECTION_TTB, "HB_DIRECTION_TTB" );
	swigIntConstant( HB_DIRECTION_BTT, "HB_DIRECTION_BTT" );
	swigIntConstant( HB_SCRIPT_COMMON, "HB_SCRIPT_COMMON" );
	swigIntConstant( HB_SCRIPT_INHERITED, "HB_SCRIPT_INHERITED" );
	swigIntConstant( HB_SCRIPT_UNKNOWN, "HB_SCRIPT_UNKNOWN" );
	swigIntConstant( HB_SCRIPT_ARABIC, "HB_SCRIPT_ARABIC" );
	swigIntConstant( HB_SCRIPT_ARMENIAN, "HB_SCRIPT_ARMENIAN" );
	swigIntConstant( HB_SCRIPT_BENGALI, "HB_SCRIPT_BENGALI" );
	swigIntConstant( HB_SCRIPT_CYRILLIC, "HB_SCRIPT_CYRILLIC" );
	swigIntConstant( HB_SCRIPT_DEVANAGARI, "HB_SCRIPT_DEVANAGARI" );
	swigIntConstant( HB_SCRIPT_GEORGIAN, "HB_SCRIPT_GEORGIAN" );
	swigIntConstant( HB_SCRIPT_GREEK, "HB_SCRIPT_GREEK" );
	swigIntConstant( HB_SCRIPT_GUJARATI, "HB_SCRIPT_GUJARATI" );
	swigIntConstant( HB_SCRIPT_GURMUKHI, "HB_SCRIPT_GURMUKHI" );
	swigIntConstant( HB_SCRIPT_HANGUL, "HB_SCRIPT_HANGUL" );
	swigIntConstant( HB_SCRIPT_HAN, "HB_SCRIPT_HAN" );
	swigIntConstant( HB_SCRIPT_HEBREW, "HB_SCRIPT_HEBREW" );
	swigIntConstant( HB_SCRIPT_HIRAGANA, "HB_SCRIPT_HIRAGANA" );
	swigIntConstant( HB_SCRIPT_KANNADA, "HB_SCRIPT_KANNADA" );
	swigIntConstant( HB_SCRIPT_KATAKANA, "HB_SCRIPT_KATAKANA" );
	swigIntConstant( HB_SCRIPT_LAO, "HB_SCRIPT_LAO" );
	swigIntConstant( HB_SCRIPT_LATIN, "HB_SCRIPT_LATIN" );
	swigIntConstant( HB_SCRIPT_MALAYALAM, "HB_SCRIPT_MALAYALAM" );
	swigIntConstant( HB_SCRIPT_ORIYA, "HB_SCRIPT_ORIYA" );
	swigIntConstant( HB_SCRIPT_TAMIL, "HB_SCRIPT_TAMIL" );
	swigIntConstant( HB_SCRIPT_TELUGU, "HB_SCRIPT_TELUGU" );
	swigIntConstant( HB_SCRIPT_THAI, "HB_SCRIPT_THAI" );
	swigIntConstant( HB_SCRIPT_TIBETAN, "HB_SCRIPT_TIBETAN" );
	swigIntConstant( HB_SCRIPT_BOPOMOFO, "HB_SCRIPT_BOPOMOFO" );
	swigIntConstant( HB_SCRIPT_BRAILLE, "HB_SCRIPT_BRAILLE" );
	swigIntConstant( HB_SCRIPT_CANADIAN_SYLLABICS, "HB_SCRIPT_CANADIAN_SYLLABICS" );
	swigIntConstant( HB_SCRIPT_CHEROKEE, "HB_SCRIPT_CHEROKEE" );
	swigIntConstant( HB_SCRIPT_ETHIOPIC, "HB_SCRIPT_ETHIOPIC" );
	swigIntConstant( HB_SCRIPT_KHMER, "HB_SCRIPT_KHMER" );
	swigIntConstant( HB_SCRIPT_MONGOLIAN, "HB_SCRIPT_MONGOLIAN" );
	swigIntConstant( HB_SCRIPT_MYANMAR, "HB_SCRIPT_MYANMAR" );
	swigIntConstant( HB_SCRIPT_OGHAM, "HB_SCRIPT_OGHAM" );
	swigIntConstant( HB_SCRIPT_RUNIC, "HB_SCRIPT_RUNIC" );
	swigIntConstant( HB_SCRIPT_SINHALA, "HB_SCRIPT_SINHALA" );
	swigIntConstant( HB_SCRIPT_SYRIAC, "HB_SCRIPT_SYRIAC" );
	swigIntConstant( HB_SCRIPT_THAANA, "HB_SCRIPT_THAANA" );
	swigIntConstant( HB_SCRIPT_YI, "HB_SCRIPT_YI" );
	swigIntConstant( HB_SCRIPT_DESERET, "HB_SCRIPT_DESERET" );
	swigIntConstant( HB_SCRIPT_GOTHIC, "HB_SCRIPT_GOTHIC" );
	swigIntConstant( HB_SCRIPT_OLD_ITALIC, "HB_SCRIPT_OLD_ITALIC" );
	swigIntConstant( HB_SCRIPT_BUHID, "HB_SCRIPT_BUHID" );
	swigIntConstant( HB_SCRIPT_HANUNOO, "HB_SCRIPT_HANUNOO" );
	swigIntConstant( HB_SCRIPT_TAGALOG, "HB_SCRIPT_TAGALOG" );
	swigIntConstant( HB_SCRIPT_TAGBANWA, "HB_SCRIPT_TAGBANWA" );
	swigIntConstant( HB_SCRIPT_CYPRIOT, "HB_SCRIPT_CYPRIOT" );
	swigIntConstant( HB_SCRIPT_LIMBU, "HB_SCRIPT_LIMBU" );
	swigIntConstant( HB_SCRIPT_LINEAR_B, "HB_SCRIPT_LINEAR_B" );
	swigIntConstant( HB_SCRIPT_OSMANYA, "HB_SCRIPT_OSMANYA" );
	swigIntConstant( HB_SCRIPT_SHAVIAN, "HB_SCRIPT_SHAVIAN" );
	swigIntConstant( HB_SCRIPT_TAI_LE, "HB_SCRIPT_TAI_LE" );
	swigIntConstant( HB_SCRIPT_UGARITIC, "HB_SCRIPT_UGARITIC" );
	swigIntConstant( HB_SCRIPT_BUGINESE, "HB_SCRIPT_BUGINESE" );
	swigIntConstant( HB_SCRIPT_COPTIC, "HB_SCRIPT_COPTIC" );
	swigIntConstant( HB_SCRIPT_GLAGOLITIC, "HB_SCRIPT_GLAGOLITIC" );
	swigIntConstant( HB_SCRIPT_KHAROSHTHI, "HB_SCRIPT_KHAROSHTHI" );
	swigIntConstant( HB_SCRIPT_NEW_TAI_LUE, "HB_SCRIPT_NEW_TAI_LUE" );
	swigIntConstant( HB_SCRIPT_OLD_PERSIAN, "HB_SCRIPT_OLD_PERSIAN" );
	swigIntConstant( HB_SCRIPT_SYLOTI_NAGRI, "HB_SCRIPT_SYLOTI_NAGRI" );
	swigIntConstant( HB_SCRIPT_TIFINAGH, "HB_SCRIPT_TIFINAGH" );
	swigIntConstant( HB_SCRIPT_BALINESE, "HB_SCRIPT_BALINESE" );
	swigIntConstant( HB_SCRIPT_CUNEIFORM, "HB_SCRIPT_CUNEIFORM" );
	swigIntConstant( HB_SCRIPT_NKO, "HB_SCRIPT_NKO" );
	swigIntConstant( HB_SCRIPT_PHAGS_PA, "HB_SCRIPT_PHAGS_PA" );
	swigIntConstant( HB_SCRIPT_PHOENICIAN, "HB_SCRIPT_PHOENICIAN" );
	swigIntConstant( HB_SCRIPT_CARIAN, "HB_SCRIPT_CARIAN" );
	swigIntConstant( HB_SCRIPT_CHAM, "HB_SCRIPT_CHAM" );
	swigIntConstant( HB_SCRIPT_KAYAH_LI, "HB_SCRIPT_KAYAH_LI" );
	swigIntConstant( HB_SCRIPT_LEPCHA, "HB_SCRIPT_LEPCHA" );
	swigIntConstant( HB_SCRIPT_LYCIAN, "HB_SCRIPT_LYCIAN" );
	swigIntConstant( HB_SCRIPT_LYDIAN, "HB_SCRIPT_LYDIAN" );
	swigIntConstant( HB_SCRIPT_OL_CHIKI, "HB_SCRIPT_OL_CHIKI" );
	swigIntConstant( HB_SCRIPT_REJANG, "HB_SCRIPT_REJANG" );
	swigIntConstant( HB_SCRIPT_SAURASHTRA, "HB_SCRIPT_SAURASHTRA" );
	swigIntConstant( HB_SCRIPT_SUNDANESE, "HB_SCRIPT_SUNDANESE" );
	swigIntConstant( HB_SCRIPT_VAI, "HB_SCRIPT_VAI" );
	swigIntConstant( HB_SCRIPT_AVESTAN, "HB_SCRIPT_AVESTAN" );
	swigIntConstant( HB_SCRIPT_BAMUM, "HB_SCRIPT_BAMUM" );
	swigIntConstant( HB_SCRIPT_EGYPTIAN_HIEROGLYPHS, "HB_SCRIPT_EGYPTIAN_HIEROGLYPHS" );
	swigIntConstant( HB_SCRIPT_IMPERIAL_ARAMAIC, "HB_SCRIPT_IMPERIAL_ARAMAIC" );
	swigIntConstant( HB_SCRIPT_INSCRIPTIONAL_PAHLAVI, "HB_SCRIPT_INSCRIPTIONAL_PAHLAVI" );
	swigIntConstant( HB_SCRIPT_INSCRIPTIONAL_PARTHIAN, "HB_SCRIPT_INSCRIPTIONAL_PARTHIAN" );
	swigIntConstant( HB_SCRIPT_JAVANESE, "HB_SCRIPT_JAVANESE" );
	swigIntConstant( HB_SCRIPT_KAITHI, "HB_SCRIPT_KAITHI" );
	swigIntConstant( HB_SCRIPT_LISU, "HB_SCRIPT_LISU" );
	swigIntConstant( HB_SCRIPT_MEETEI_MAYEK, "HB_SCRIPT_MEETEI_MAYEK" );
	swigIntConstant( HB_SCRIPT_OLD_SOUTH_ARABIAN, "HB_SCRIPT_OLD_SOUTH_ARABIAN" );
	swigIntConstant( HB_SCRIPT_OLD_TURKIC, "HB_SCRIPT_OLD_TURKIC" );
	swigIntConstant( HB_SCRIPT_SAMARITAN, "HB_SCRIPT_SAMARITAN" );
	swigIntConstant( HB_SCRIPT_TAI_THAM, "HB_SCRIPT_TAI_THAM" );
	swigIntConstant( HB_SCRIPT_TAI_VIET, "HB_SCRIPT_TAI_VIET" );
	swigIntConstant( HB_SCRIPT_BATAK, "HB_SCRIPT_BATAK" );
	swigIntConstant( HB_SCRIPT_BRAHMI, "HB_SCRIPT_BRAHMI" );
	swigIntConstant( HB_SCRIPT_MANDAIC, "HB_SCRIPT_MANDAIC" );
	swigIntConstant( HB_SCRIPT_CHAKMA, "HB_SCRIPT_CHAKMA" );
	swigIntConstant( HB_SCRIPT_MEROITIC_CURSIVE, "HB_SCRIPT_MEROITIC_CURSIVE" );
	swigIntConstant( HB_SCRIPT_MEROITIC_HIEROGLYPHS, "HB_SCRIPT_MEROITIC_HIEROGLYPHS" );
	swigIntConstant( HB_SCRIPT_MIAO, "HB_SCRIPT_MIAO" );
	swigIntConstant( HB_SCRIPT_SHARADA, "HB_SCRIPT_SHARADA" );
	swigIntConstant( HB_SCRIPT_SORA_SOMPENG, "HB_SCRIPT_SORA_SOMPENG" );
	swigIntConstant( HB_SCRIPT_TAKRI, "HB_SCRIPT_TAKRI" );
	swigIntConstant( HB_SCRIPT_BASSA_VAH, "HB_SCRIPT_BASSA_VAH" );
	swigIntConstant( HB_SCRIPT_CAUCASIAN_ALBANIAN, "HB_SCRIPT_CAUCASIAN_ALBANIAN" );
	swigIntConstant( HB_SCRIPT_DUPLOYAN, "HB_SCRIPT_DUPLOYAN" );
	swigIntConstant( HB_SCRIPT_ELBASAN, "HB_SCRIPT_ELBASAN" );
	swigIntConstant( HB_SCRIPT_GRANTHA, "HB_SCRIPT_GRANTHA" );
	swigIntConstant( HB_SCRIPT_KHOJKI, "HB_SCRIPT_KHOJKI" );
	swigIntConstant( HB_SCRIPT_KHUDAWADI, "HB_SCRIPT_KHUDAWADI" );
	swigIntConstant( HB_SCRIPT_LINEAR_A, "HB_SCRIPT_LINEAR_A" );
	swigIntConstant( HB_SCRIPT_MAHAJANI, "HB_SCRIPT_MAHAJANI" );
	swigIntConstant( HB_SCRIPT_MANICHAEAN, "HB_SCRIPT_MANICHAEAN" );
	swigIntConstant( HB_SCRIPT_MENDE_KIKAKUI, "HB_SCRIPT_MENDE_KIKAKUI" );
	swigIntConstant( HB_SCRIPT_MODI, "HB_SCRIPT_MODI" );
	swigIntConstant( HB_SCRIPT_MRO, "HB_SCRIPT_MRO" );
	swigIntConstant( HB_SCRIPT_NABATAEAN, "HB_SCRIPT_NABATAEAN" );
	swigIntConstant( HB_SCRIPT_OLD_NORTH_ARABIAN, "HB_SCRIPT_OLD_NORTH_ARABIAN" );
	swigIntConstant( HB_SCRIPT_OLD_PERMIC, "HB_SCRIPT_OLD_PERMIC" );
	swigIntConstant( HB_SCRIPT_PAHAWH_HMONG, "HB_SCRIPT_PAHAWH_HMONG" );
	swigIntConstant( HB_SCRIPT_PALMYRENE, "HB_SCRIPT_PALMYRENE" );
	swigIntConstant( HB_SCRIPT_PAU_CIN_HAU, "HB_SCRIPT_PAU_CIN_HAU" );
	swigIntConstant( HB_SCRIPT_PSALTER_PAHLAVI, "HB_SCRIPT_PSALTER_PAHLAVI" );
	swigIntConstant( HB_SCRIPT_SIDDHAM, "HB_SCRIPT_SIDDHAM" );
	swigIntConstant( HB_SCRIPT_TIRHUTA, "HB_SCRIPT_TIRHUTA" );
	swigIntConstant( HB_SCRIPT_WARANG_CITI, "HB_SCRIPT_WARANG_CITI" );
	swigIntConstant( HB_SCRIPT_AHOM, "HB_SCRIPT_AHOM" );
	swigIntConstant( HB_SCRIPT_ANATOLIAN_HIEROGLYPHS, "HB_SCRIPT_ANATOLIAN_HIEROGLYPHS" );
	swigIntConstant( HB_SCRIPT_HATRAN, "HB_SCRIPT_HATRAN" );
	swigIntConstant( HB_SCRIPT_MULTANI, "HB_SCRIPT_MULTANI" );
	swigIntConstant( HB_SCRIPT_OLD_HUNGARIAN, "HB_SCRIPT_OLD_HUNGARIAN" );
	swigIntConstant( HB_SCRIPT_SIGNWRITING, "HB_SCRIPT_SIGNWRITING" );
	swigIntConstant( HB_SCRIPT_ADLAM, "HB_SCRIPT_ADLAM" );
	swigIntConstant( HB_SCRIPT_BHAIKSUKI, "HB_SCRIPT_BHAIKSUKI" );
	swigIntConstant( HB_SCRIPT_MARCHEN, "HB_SCRIPT_MARCHEN" );
	swigIntConstant( HB_SCRIPT_OSAGE, "HB_SCRIPT_OSAGE" );
	swigIntConstant( HB_SCRIPT_TANGUT, "HB_SCRIPT_TANGUT" );
	swigIntConstant( HB_SCRIPT_NEWA, "HB_SCRIPT_NEWA" );
	swigIntConstant( HB_SCRIPT_MASARAM_GONDI, "HB_SCRIPT_MASARAM_GONDI" );
	swigIntConstant( HB_SCRIPT_NUSHU, "HB_SCRIPT_NUSHU" );
	swigIntConstant( HB_SCRIPT_SOYOMBO, "HB_SCRIPT_SOYOMBO" );
	swigIntConstant( HB_SCRIPT_ZANABAZAR_SQUARE, "HB_SCRIPT_ZANABAZAR_SQUARE" );
	swigIntConstant( HB_SCRIPT_DOGRA, "HB_SCRIPT_DOGRA" );
	swigIntConstant( HB_SCRIPT_GUNJALA_GONDI, "HB_SCRIPT_GUNJALA_GONDI" );
	swigIntConstant( HB_SCRIPT_HANIFI_ROHINGYA, "HB_SCRIPT_HANIFI_ROHINGYA" );
	swigIntConstant( HB_SCRIPT_MAKASAR, "HB_SCRIPT_MAKASAR" );
	swigIntConstant( HB_SCRIPT_MEDEFAIDRIN, "HB_SCRIPT_MEDEFAIDRIN" );
	swigIntConstant( HB_SCRIPT_OLD_SOGDIAN, "HB_SCRIPT_OLD_SOGDIAN" );
	swigIntConstant( HB_SCRIPT_SOGDIAN, "HB_SCRIPT_SOGDIAN" );
	swigIntConstant( HB_SCRIPT_ELYMAIC, "HB_SCRIPT_ELYMAIC" );
	swigIntConstant( HB_SCRIPT_NANDINAGARI, "HB_SCRIPT_NANDINAGARI" );
	swigIntConstant( HB_SCRIPT_NYIAKENG_PUACHUE_HMONG, "HB_SCRIPT_NYIAKENG_PUACHUE_HMONG" );
	swigIntConstant( HB_SCRIPT_WANCHO, "HB_SCRIPT_WANCHO" );
	swigIntConstant( HB_SCRIPT_CHORASMIAN, "HB_SCRIPT_CHORASMIAN" );
	swigIntConstant( HB_SCRIPT_DIVES_AKURU, "HB_SCRIPT_DIVES_AKURU" );
	swigIntConstant( HB_SCRIPT_KHITAN_SMALL_SCRIPT, "HB_SCRIPT_KHITAN_SMALL_SCRIPT" );
	swigIntConstant( HB_SCRIPT_YEZIDI, "HB_SCRIPT_YEZIDI" );
	swigIntConstant( HB_SCRIPT_CYPRO_MINOAN, "HB_SCRIPT_CYPRO_MINOAN" );
	swigIntConstant( HB_SCRIPT_OLD_UYGHUR, "HB_SCRIPT_OLD_UYGHUR" );
	swigIntConstant( HB_SCRIPT_TANGSA, "HB_SCRIPT_TANGSA" );
	swigIntConstant( HB_SCRIPT_TOTO, "HB_SCRIPT_TOTO" );
	swigIntConstant( HB_SCRIPT_VITHKUQI, "HB_SCRIPT_VITHKUQI" );
	swigIntConstant( HB_SCRIPT_MATH, "HB_SCRIPT_MATH" );
	swigIntConstant( HB_SCRIPT_KAWI, "HB_SCRIPT_KAWI" );
	swigIntConstant( HB_SCRIPT_NAG_MUNDARI, "HB_SCRIPT_NAG_MUNDARI" );
	swigIntConstant( HB_SCRIPT_INVALID, "HB_SCRIPT_INVALID" );
	swigIntConstant( _HB_SCRIPT_MAX_VALUE, "_HB_SCRIPT_MAX_VALUE" );
	swigIntConstant( _HB_SCRIPT_MAX_VALUE_SIGNED, "_HB_SCRIPT_MAX_VALUE_SIGNED" );
	swigIntConstant( HB_UNICODE_GENERAL_CATEGORY_CONTROL, "HB_UNICODE_GENERAL_CATEGORY_CONTROL" );
	swigIntConstant( HB_UNICODE_GENERAL_CATEGORY_FORMAT, "HB_UNICODE_GENERAL_CATEGORY_FORMAT" );
	swigIntConstant( HB_UNICODE_GENERAL_CATEGORY_UNASSIGNED, "HB_UNICODE_GENERAL_CATEGORY_UNASSIGNED" );
	swigIntConstant( HB_UNICODE_GENERAL_CATEGORY_PRIVATE_USE, "HB_UNICODE_GENERAL_CATEGORY_PRIVATE_USE" );
	swigIntConstant( HB_UNICODE_GENERAL_CATEGORY_SURROGATE, "HB_UNICODE_GENERAL_CATEGORY_SURROGATE" );
	swigIntConstant( HB_UNICODE_GENERAL_CATEGORY_LOWERCASE_LETTER, "HB_UNICODE_GENERAL_CATEGORY_LOWERCASE_LETTER" );
	swigIntConstant( HB_UNICODE_GENERAL_CATEGORY_MODIFIER_LETTER, "HB_UNICODE_GENERAL_CATEGORY_MODIFIER_LETTER" );
	swigIntConstant( HB_UNICODE_GENERAL_CATEGORY_OTHER_LETTER, "HB_UNICODE_GENERAL_CATEGORY_OTHER_LETTER" );
	swigIntConstant( HB_UNICODE_GENERAL_CATEGORY_TITLECASE_LETTER, "HB_UNICODE_GENERAL_CATEGORY_TITLECASE_LETTER" );
	swigIntConstant( HB_UNICODE_GENERAL_CATEGORY_UPPERCASE_LETTER, "HB_UNICODE_GENERAL_CATEGORY_UPPERCASE_LETTER" );
	swigIntConstant( HB_UNICODE_GENERAL_CATEGORY_SPACING_MARK, "HB_UNICODE_GENERAL_CATEGORY_SPACING_MARK" );
	swigIntConstant( HB_UNICODE_GENERAL_CATEGORY_ENCLOSING_MARK, "HB_UNICODE_GENERAL_CATEGORY_ENCLOSING_MARK" );
	swigIntConstant( HB_UNICODE_GENERAL_CATEGORY_NON_SPACING_MARK, "HB_UNICODE_GENERAL_CATEGORY_NON_SPACING_MARK" );
	swigIntConstant( HB_UNICODE_GENERAL_CATEGORY_DECIMAL_NUMBER, "HB_UNICODE_GENERAL_CATEGORY_DECIMAL_NUMBER" );
	swigIntConstant( HB_UNICODE_GENERAL_CATEGORY_LETTER_NUMBER, "HB_UNICODE_GENERAL_CATEGORY_LETTER_NUMBER" );
	swigIntConstant( HB_UNICODE_GENERAL_CATEGORY_OTHER_NUMBER, "HB_UNICODE_GENERAL_CATEGORY_OTHER_NUMBER" );
	swigIntConstant( HB_UNICODE_GENERAL_CATEGORY_CONNECT_PUNCTUATION, "HB_UNICODE_GENERAL_CATEGORY_CONNECT_PUNCTUATION" );
	swigIntConstant( HB_UNICODE_GENERAL_CATEGORY_DASH_PUNCTUATION, "HB_UNICODE_GENERAL_CATEGORY_DASH_PUNCTUATION" );
	swigIntConstant( HB_UNICODE_GENERAL_CATEGORY_CLOSE_PUNCTUATION, "HB_UNICODE_GENERAL_CATEGORY_CLOSE_PUNCTUATION" );
	swigIntConstant( HB_UNICODE_GENERAL_CATEGORY_FINAL_PUNCTUATION, "HB_UNICODE_GENERAL_CATEGORY_FINAL_PUNCTUATION" );
	swigIntConstant( HB_UNICODE_GENERAL_CATEGORY_INITIAL_PUNCTUATION, "HB_UNICODE_GENERAL_CATEGORY_INITIAL_PUNCTUATION" );
	swigIntConstant( HB_UNICODE_GENERAL_CATEGORY_OTHER_PUNCTUATION, "HB_UNICODE_GENERAL_CATEGORY_OTHER_PUNCTUATION" );
	swigIntConstant( HB_UNICODE_GENERAL_CATEGORY_OPEN_PUNCTUATION, "HB_UNICODE_GENERAL_CATEGORY_OPEN_PUNCTUATION" );
	swigIntConstant( HB_UNICODE_GENERAL_CATEGORY_CURRENCY_SYMBOL, "HB_UNICODE_GENERAL_CATEGORY_CURRENCY_SYMBOL" );
	swigIntConstant( HB_UNICODE_GENERAL_CATEGORY_MODIFIER_SYMBOL, "HB_UNICODE_GENERAL_CATEGORY_MODIFIER_SYMBOL" );
	swigIntConstant( HB_UNICODE_GENERAL_CATEGORY_MATH_SYMBOL, "HB_UNICODE_GENERAL_CATEGORY_MATH_SYMBOL" );
	swigIntConstant( HB_UNICODE_GENERAL_CATEGORY_OTHER_SYMBOL, "HB_UNICODE_GENERAL_CATEGORY_OTHER_SYMBOL" );
	swigIntConstant( HB_UNICODE_GENERAL_CATEGORY_LINE_SEPARATOR, "HB_UNICODE_GENERAL_CATEGORY_LINE_SEPARATOR" );
	swigIntConstant( HB_UNICODE_GENERAL_CATEGORY_PARAGRAPH_SEPARATOR, "HB_UNICODE_GENERAL_CATEGORY_PARAGRAPH_SEPARATOR" );
	swigIntConstant( HB_UNICODE_GENERAL_CATEGORY_SPACE_SEPARATOR, "HB_UNICODE_GENERAL_CATEGORY_SPACE_SEPARATOR" );
	swigIntConstant( HB_UNICODE_COMBINING_CLASS_NOT_REORDERED, "HB_UNICODE_COMBINING_CLASS_NOT_REORDERED" );
	swigIntConstant( HB_UNICODE_COMBINING_CLASS_OVERLAY, "HB_UNICODE_COMBINING_CLASS_OVERLAY" );
	swigIntConstant( HB_UNICODE_COMBINING_CLASS_NUKTA, "HB_UNICODE_COMBINING_CLASS_NUKTA" );
	swigIntConstant( HB_UNICODE_COMBINING_CLASS_KANA_VOICING, "HB_UNICODE_COMBINING_CLASS_KANA_VOICING" );
	swigIntConstant( HB_UNICODE_COMBINING_CLASS_VIRAMA, "HB_UNICODE_COMBINING_CLASS_VIRAMA" );
	swigIntConstant( HB_UNICODE_COMBINING_CLASS_CCC10, "HB_UNICODE_COMBINING_CLASS_CCC10" );
	swigIntConstant( HB_UNICODE_COMBINING_CLASS_CCC11, "HB_UNICODE_COMBINING_CLASS_CCC11" );
	swigIntConstant( HB_UNICODE_COMBINING_CLASS_CCC12, "HB_UNICODE_COMBINING_CLASS_CCC12" );
	swigIntConstant( HB_UNICODE_COMBINING_CLASS_CCC13, "HB_UNICODE_COMBINING_CLASS_CCC13" );
	swigIntConstant( HB_UNICODE_COMBINING_CLASS_CCC14, "HB_UNICODE_COMBINING_CLASS_CCC14" );
	swigIntConstant( HB_UNICODE_COMBINING_CLASS_CCC15, "HB_UNICODE_COMBINING_CLASS_CCC15" );
	swigIntConstant( HB_UNICODE_COMBINING_CLASS_CCC16, "HB_UNICODE_COMBINING_CLASS_CCC16" );
	swigIntConstant( HB_UNICODE_COMBINING_CLASS_CCC17, "HB_UNICODE_COMBINING_CLASS_CCC17" );
	swigIntConstant( HB_UNICODE_COMBINING_CLASS_CCC18, "HB_UNICODE_COMBINING_CLASS_CCC18" );
	swigIntConstant( HB_UNICODE_COMBINING_CLASS_CCC19, "HB_UNICODE_COMBINING_CLASS_CCC19" );
	swigIntConstant( HB_UNICODE_COMBINING_CLASS_CCC20, "HB_UNICODE_COMBINING_CLASS_CCC20" );
	swigIntConstant( HB_UNICODE_COMBINING_CLASS_CCC21, "HB_UNICODE_COMBINING_CLASS_CCC21" );
	swigIntConstant( HB_UNICODE_COMBINING_CLASS_CCC22, "HB_UNICODE_COMBINING_CLASS_CCC22" );
	swigIntConstant( HB_UNICODE_COMBINING_CLASS_CCC23, "HB_UNICODE_COMBINING_CLASS_CCC23" );
	swigIntConstant( HB_UNICODE_COMBINING_CLASS_CCC24, "HB_UNICODE_COMBINING_CLASS_CCC24" );
	swigIntConstant( HB_UNICODE_COMBINING_CLASS_CCC25, "HB_UNICODE_COMBINING_CLASS_CCC25" );
	swigIntConstant( HB_UNICODE_COMBINING_CLASS_CCC26, "HB_UNICODE_COMBINING_CLASS_CCC26" );
	swigIntConstant( HB_UNICODE_COMBINING_CLASS_CCC27, "HB_UNICODE_COMBINING_CLASS_CCC27" );
	swigIntConstant( HB_UNICODE_COMBINING_CLASS_CCC28, "HB_UNICODE_COMBINING_CLASS_CCC28" );
	swigIntConstant( HB_UNICODE_COMBINING_CLASS_CCC29, "HB_UNICODE_COMBINING_CLASS_CCC29" );
	swigIntConstant( HB_UNICODE_COMBINING_CLASS_CCC30, "HB_UNICODE_COMBINING_CLASS_CCC30" );
	swigIntConstant( HB_UNICODE_COMBINING_CLASS_CCC31, "HB_UNICODE_COMBINING_CLASS_CCC31" );
	swigIntConstant( HB_UNICODE_COMBINING_CLASS_CCC32, "HB_UNICODE_COMBINING_CLASS_CCC32" );
	swigIntConstant( HB_UNICODE_COMBINING_CLASS_CCC33, "HB_UNICODE_COMBINING_CLASS_CCC33" );
	swigIntConstant( HB_UNICODE_COMBINING_CLASS_CCC34, "HB_UNICODE_COMBINING_CLASS_CCC34" );
	swigIntConstant( HB_UNICODE_COMBINING_CLASS_CCC35, "HB_UNICODE_COMBINING_CLASS_CCC35" );
	swigIntConstant( HB_UNICODE_COMBINING_CLASS_CCC36, "HB_UNICODE_COMBINING_CLASS_CCC36" );
	swigIntConstant( HB_UNICODE_COMBINING_CLASS_CCC84, "HB_UNICODE_COMBINING_CLASS_CCC84" );
	swigIntConstant( HB_UNICODE_COMBINING_CLASS_CCC91, "HB_UNICODE_COMBINING_CLASS_CCC91" );
	swigIntConstant( HB_UNICODE_COMBINING_CLASS_CCC103, "HB_UNICODE_COMBINING_CLASS_CCC103" );
	swigIntConstant( HB_UNICODE_COMBINING_CLASS_CCC107, "HB_UNICODE_COMBINING_CLASS_CCC107" );
	swigIntConstant( HB_UNICODE_COMBINING_CLASS_CCC118, "HB_UNICODE_COMBINING_CLASS_CCC118" );
	swigIntConstant( HB_UNICODE_COMBINING_CLASS_CCC122, "HB_UNICODE_COMBINING_CLASS_CCC122" );
	swigIntConstant( HB_UNICODE_COMBINING_CLASS_CCC129, "HB_UNICODE_COMBINING_CLASS_CCC129" );
	swigIntConstant( HB_UNICODE_COMBINING_CLASS_CCC130, "HB_UNICODE_COMBINING_CLASS_CCC130" );
	swigIntConstant( HB_UNICODE_COMBINING_CLASS_CCC132, "HB_UNICODE_COMBINING_CLASS_CCC132" );
	swigIntConstant( HB_UNICODE_COMBINING_CLASS_ATTACHED_BELOW_LEFT, "HB_UNICODE_COMBINING_CLASS_ATTACHED_BELOW_LEFT" );
	swigIntConstant( HB_UNICODE_COMBINING_CLASS_ATTACHED_BELOW, "HB_UNICODE_COMBINING_CLASS_ATTACHED_BELOW" );
	swigIntConstant( HB_UNICODE_COMBINING_CLASS_ATTACHED_ABOVE, "HB_UNICODE_COMBINING_CLASS_ATTACHED_ABOVE" );
	swigIntConstant( HB_UNICODE_COMBINING_CLASS_ATTACHED_ABOVE_RIGHT, "HB_UNICODE_COMBINING_CLASS_ATTACHED_ABOVE_RIGHT" );
	swigIntConstant( HB_UNICODE_COMBINING_CLASS_BELOW_LEFT, "HB_UNICODE_COMBINING_CLASS_BELOW_LEFT" );
	swigIntConstant( HB_UNICODE_COMBINING_CLASS_BELOW, "HB_UNICODE_COMBINING_CLASS_BELOW" );
	swigIntConstant( HB_UNICODE_COMBINING_CLASS_BELOW_RIGHT, "HB_UNICODE_COMBINING_CLASS_BELOW_RIGHT" );
	swigIntConstant( HB_UNICODE_COMBINING_CLASS_LEFT, "HB_UNICODE_COMBINING_CLASS_LEFT" );
	swigIntConstant( HB_UNICODE_COMBINING_CLASS_RIGHT, "HB_UNICODE_COMBINING_CLASS_RIGHT" );
	swigIntConstant( HB_UNICODE_COMBINING_CLASS_ABOVE_LEFT, "HB_UNICODE_COMBINING_CLASS_ABOVE_LEFT" );
	swigIntConstant( HB_UNICODE_COMBINING_CLASS_ABOVE, "HB_UNICODE_COMBINING_CLASS_ABOVE" );
	swigIntConstant( HB_UNICODE_COMBINING_CLASS_ABOVE_RIGHT, "HB_UNICODE_COMBINING_CLASS_ABOVE_RIGHT" );
	swigIntConstant( HB_UNICODE_COMBINING_CLASS_DOUBLE_BELOW, "HB_UNICODE_COMBINING_CLASS_DOUBLE_BELOW" );
	swigIntConstant( HB_UNICODE_COMBINING_CLASS_DOUBLE_ABOVE, "HB_UNICODE_COMBINING_CLASS_DOUBLE_ABOVE" );
	swigIntConstant( HB_UNICODE_COMBINING_CLASS_IOTA_SUBSCRIPT, "HB_UNICODE_COMBINING_CLASS_IOTA_SUBSCRIPT" );
	swigIntConstant( HB_UNICODE_COMBINING_CLASS_INVALID, "HB_UNICODE_COMBINING_CLASS_INVALID" );

	swigNewline();

	swigComment("-------===< structs >===--------\n");

	swigComment("struct hb_glyph_info_t\n");
	printf( "begin-structure hb_glyph_info_t\n" );
	swigStructField( "hb_glyph_info_t-mask", offsetof( struct hb_glyph_info_t, mask ), sizeof( hb_mask_t ) );
	swigStructField( "hb_glyph_info_t-var1", offsetof( struct hb_glyph_info_t, var1 ), sizeof( hb_var_int_t ) );
	swigStructField( "hb_glyph_info_t-codepoint", offsetof( struct hb_glyph_info_t, codepoint ), sizeof( hb_codepoint_t ) );
	swigStructField( "hb_glyph_info_t-cluster", offsetof( struct hb_glyph_info_t, cluster ), sizeof( uint32_t ) );
	swigStructField( "hb_glyph_info_t-var2", offsetof( struct hb_glyph_info_t, var2 ), sizeof( hb_var_int_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct hb_glyph_info_t ) );

	swigComment("struct hb_glyph_position_t\n");
	printf( "begin-structure hb_glyph_position_t\n" );
	swigStructField( "hb_glyph_position_t-x_offset", offsetof( struct hb_glyph_position_t, x_offset ), sizeof( hb_position_t ) );
	swigStructField( "hb_glyph_position_t-y_offset", offsetof( struct hb_glyph_position_t, y_offset ), sizeof( hb_position_t ) );
	swigStructField( "hb_glyph_position_t-var", offsetof( struct hb_glyph_position_t, var ), sizeof( hb_var_int_t ) );
	swigStructField( "hb_glyph_position_t-x_advance", offsetof( struct hb_glyph_position_t, x_advance ), sizeof( hb_position_t ) );
	swigStructField( "hb_glyph_position_t-y_advance", offsetof( struct hb_glyph_position_t, y_advance ), sizeof( hb_position_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct hb_glyph_position_t ) );

	swigComment("struct hb_segment_properties_t\n");
	printf( "begin-structure hb_segment_properties_t\n" );
	swigStructField( "hb_segment_properties_t-script", offsetof( struct hb_segment_properties_t, script ), sizeof( hb_script_t ) );
	swigStructField( "hb_segment_properties_t-reserved1", offsetof( struct hb_segment_properties_t, reserved1 ), sizeof( void * ) );
	swigStructField( "hb_segment_properties_t-language", offsetof( struct hb_segment_properties_t, language ), sizeof( hb_language_t ) );
	swigStructField( "hb_segment_properties_t-reserved2", offsetof( struct hb_segment_properties_t, reserved2 ), sizeof( void * ) );
	swigStructField( "hb_segment_properties_t-direction", offsetof( struct hb_segment_properties_t, direction ), sizeof( hb_direction_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct hb_segment_properties_t ) );

	swigComment("union _hb_var_int_t\n");
	printf( "begin-structure hb_var_int_t\n" );
	printf( "drop %zu end-structure\n", sizeof( union _hb_var_int_t ) );

/* 	swigComment("union _hb_var_num_t\n"); */
/* 	printf( "begin-structure hb_var_num_t\n" ); */
/* 	printf( "drop %zu end-structure\n", sizeof( union _hb_var_num_t ) ); */

	swigComment("struct hb_user_data_key_t\n");
	printf( "begin-structure hb_user_data_key_t\n" );
	swigStructField( "hb_user_data_key_t-unused", offsetof( struct hb_user_data_key_t, unused ), sizeof( char ) );
	printf( "drop %zu end-structure\n", sizeof( struct hb_user_data_key_t ) );

	swigComment("struct hb_feature_t\n");
	printf( "begin-structure hb_feature_t\n" );
	swigStructField( "hb_feature_t-end", offsetof( struct hb_feature_t, end ), sizeof( unsigned int ) );
	swigStructField( "hb_feature_t-tag", offsetof( struct hb_feature_t, tag ), sizeof( hb_tag_t ) );
	swigStructField( "hb_feature_t-value", offsetof( struct hb_feature_t, value ), sizeof( uint32_t ) );
	swigStructField( "hb_feature_t-start", offsetof( struct hb_feature_t, start ), sizeof( unsigned int ) );
	printf( "drop %zu end-structure\n", sizeof( struct hb_feature_t ) );

	swigComment("struct hb_variation_t\n");
	printf( "begin-structure hb_variation_t\n" );
	swigStructField( "hb_variation_t-tag", offsetof( struct hb_variation_t, tag ), sizeof( hb_tag_t ) );
	swigStructField( "hb_variation_t-value", offsetof( struct hb_variation_t, value ), sizeof( float ) );
	printf( "drop %zu end-structure\n", sizeof( struct hb_variation_t ) );

	swigComment("struct hb_glyph_extents_t\n");
	printf( "begin-structure hb_glyph_extents_t\n" );
	swigStructField( "hb_glyph_extents_t-height", offsetof( struct hb_glyph_extents_t, height ), sizeof( hb_position_t ) );
	swigStructField( "hb_glyph_extents_t-width", offsetof( struct hb_glyph_extents_t, width ), sizeof( hb_position_t ) );
	swigStructField( "hb_glyph_extents_t-x_bearing", offsetof( struct hb_glyph_extents_t, x_bearing ), sizeof( hb_position_t ) );
	swigStructField( "hb_glyph_extents_t-y_bearing", offsetof( struct hb_glyph_extents_t, y_bearing ), sizeof( hb_position_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct hb_glyph_extents_t ) );

	swigComment("struct hb_font_extents_t\n");
	printf( "begin-structure hb_font_extents_t\n" );
	swigStructField( "hb_font_extents_t-reserved5", offsetof( struct hb_font_extents_t, reserved5 ), sizeof( hb_position_t ) );
	swigStructField( "hb_font_extents_t-line_gap", offsetof( struct hb_font_extents_t, line_gap ), sizeof( hb_position_t ) );
	swigStructField( "hb_font_extents_t-reserved6", offsetof( struct hb_font_extents_t, reserved6 ), sizeof( hb_position_t ) );
	swigStructField( "hb_font_extents_t-reserved7", offsetof( struct hb_font_extents_t, reserved7 ), sizeof( hb_position_t ) );
	swigStructField( "hb_font_extents_t-reserved8", offsetof( struct hb_font_extents_t, reserved8 ), sizeof( hb_position_t ) );
	swigStructField( "hb_font_extents_t-reserved1", offsetof( struct hb_font_extents_t, reserved1 ), sizeof( hb_position_t ) );
	swigStructField( "hb_font_extents_t-reserved9", offsetof( struct hb_font_extents_t, reserved9 ), sizeof( hb_position_t ) );
	swigStructField( "hb_font_extents_t-reserved2", offsetof( struct hb_font_extents_t, reserved2 ), sizeof( hb_position_t ) );
	swigStructField( "hb_font_extents_t-reserved3", offsetof( struct hb_font_extents_t, reserved3 ), sizeof( hb_position_t ) );
	swigStructField( "hb_font_extents_t-ascender", offsetof( struct hb_font_extents_t, ascender ), sizeof( hb_position_t ) );
	swigStructField( "hb_font_extents_t-descender", offsetof( struct hb_font_extents_t, descender ), sizeof( hb_position_t ) );
	swigStructField( "hb_font_extents_t-reserved4", offsetof( struct hb_font_extents_t, reserved4 ), sizeof( hb_position_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct hb_font_extents_t ) );

	swigNewline();

	swigComment("------===< callbacks >===-------\n");
	swigCallback( "c-callback hb_buffer_message_func_t: a a s a -- n", "", "", "	( buffer font message user_data -- )" );
	swigCallback( "c-callback hb_destroy_func_t: a -- void", "", "", "	( user_data -- )" );
	swigCallback( "c-callback hb_reference_table_func_t: a u a -- a", "", "", "	( face tag user_data -- )" );
	swigCallback( "c-callback hb_font_get_font_extents_func_t: a a a a -- n", "", "", "	( font font_data extents user_data -- )" );
	swigCallback( "c-callback hb_font_get_nominal_glyph_func_t: a a u a a -- n", "", "", "	( font font_data unicode glyph user_data -- )" );
	swigCallback( "c-callback hb_font_get_variation_glyph_func_t: a a u u a a -- n", "", "", "	( font font_data unicode variation_selector glyph user_data -- )" );
	swigCallback( "c-callback hb_font_get_nominal_glyphs_func_t: a a u a u a u a -- u", "", "", "	( font font_data count first_unicode unicode_stride first_glyph glyph_stride user_data -- )" );
	swigCallback( "c-callback hb_font_get_glyph_advance_func_t: a a u a -- n", "", "", "	( font font_data glyph user_data -- )" );
	swigCallback( "c-callback hb_font_get_glyph_advances_func_t: a a u a u a u a -- void", "", "", "	( font font_data count first_glyph glyph_stride first_advance advance_stride user_data -- )" );
	swigCallback( "c-callback hb_font_get_glyph_origin_func_t: a a u a a a -- n", "", "", "	( font font_data glyph x y user_data -- )" );
	swigCallback( "c-callback hb_font_get_glyph_kerning_func_t: a a u u a -- n", "", "", "	( font font_data first_glyph second_glyph user_data -- )" );
	swigCallback( "c-callback hb_font_get_glyph_extents_func_t: a a u a a -- n", "", "", "	( font font_data glyph extents user_data -- )" );
	swigCallback( "c-callback hb_font_get_glyph_contour_point_func_t: a a u u a a a -- n", "", "", "	( font font_data glyph point_index x y user_data -- )" );
	swigCallback( "c-callback hb_font_get_glyph_name_func_t: a a u a u a -- n", "", "", "	( font font_data glyph name size user_data -- )" );
	swigCallback( "c-callback hb_font_get_glyph_from_name_func_t: a a s n a a -- n", "", "", "	( font font_data name len glyph user_data -- )" );
#if HB_MIN_VER(7,0)
	swigCallback( "c-callback hb_font_draw_glyph_func_t: a a u a a a -- void", "", "", "	( font font_data glyph draw_funcs draw_data user_data -- )" );
#endif
#if HB_MIN_VER(7,0)
	swigCallback( "c-callback hb_font_paint_glyph_func_t: a a u a a u u a -- void", "", "", "	( font font_data glyph paint_funcs paint_data palette_index foreground user_data -- )" );
#endif
	swigCallback( "c-callback hb_unicode_combining_class_func_t: a u a -- n", "", "", "	( ufuncs unicode user_data -- )" );
	swigCallback( "c-callback hb_unicode_general_category_func_t: a u a -- n", "", "", "	( ufuncs unicode user_data -- )" );
	swigCallback( "c-callback hb_unicode_mirroring_func_t: a u a -- u", "", "", "	( ufuncs unicode user_data -- )" );
	swigCallback( "c-callback hb_unicode_script_func_t: a u a -- n", "", "", "	( ufuncs unicode user_data -- )" );
	swigCallback( "c-callback hb_unicode_compose_func_t: a u u a a -- n", "", "", "	( ufuncs a b ab user_data -- )" );
	swigCallback( "c-callback hb_unicode_decompose_func_t: a u a a a -- n", "", "", "	( ufuncs ab a b user_data -- )" );

	swigNewline();

	swigComment("------===< functions >===-------\n");
	swigFunction( "c-function hb_blob_create hb_blob_create s u n a a -- a", "FUNCTION: hb_blob_create ( data length mode user_data destroy -- a )", "EXTERN: \"C\" void * hb_blob_create( char * data, int length, int mode, void * user_data, void * destroy );", "	( data length mode user_data destroy -- )" );
	swigFunction( "c-function hb_blob_create_or_fail hb_blob_create_or_fail s u n a a -- a", "FUNCTION: hb_blob_create_or_fail ( data length mode user_data destroy -- a )", "EXTERN: \"C\" void * hb_blob_create_or_fail( char * data, int length, int mode, void * user_data, void * destroy );", "	( data length mode user_data destroy -- )" );
	swigFunction( "c-function hb_blob_create_from_file hb_blob_create_from_file s -- a", "FUNCTION: hb_blob_create_from_file ( file_name -- a )", "EXTERN: \"C\" void * hb_blob_create_from_file( char * file_name );", "	( file_name -- )" );
	swigFunction( "c-function hb_blob_create_from_file_or_fail hb_blob_create_from_file_or_fail s -- a", "FUNCTION: hb_blob_create_from_file_or_fail ( file_name -- a )", "EXTERN: \"C\" void * hb_blob_create_from_file_or_fail( char * file_name );", "	( file_name -- )" );
	swigFunction( "c-function hb_blob_create_sub_blob hb_blob_create_sub_blob a u u -- a", "FUNCTION: hb_blob_create_sub_blob ( parent offset length -- a )", "EXTERN: \"C\" void * hb_blob_create_sub_blob( void * parent, int offset, int length );", "	( parent offset length -- )" );
	swigFunction( "c-function hb_blob_copy_writable_or_fail hb_blob_copy_writable_or_fail a -- a", "FUNCTION: hb_blob_copy_writable_or_fail ( blob -- a )", "EXTERN: \"C\" void * hb_blob_copy_writable_or_fail( void * blob );", "	( blob -- )" );
	swigFunction( "c-function hb_blob_get_empty hb_blob_get_empty  -- a", "FUNCTION: hb_blob_get_empty (  -- a )", "EXTERN: \"C\" void * hb_blob_get_empty(  );", "	( -- )" );
	swigFunction( "c-function hb_blob_reference hb_blob_reference a -- a", "FUNCTION: hb_blob_reference ( blob -- a )", "EXTERN: \"C\" void * hb_blob_reference( void * blob );", "	( blob -- )" );
	swigFunction( "c-function hb_blob_destroy hb_blob_destroy a -- void", "FUNCTION: hb_blob_destroy ( blob -- void )", "EXTERN: \"C\" void hb_blob_destroy( void * blob );", "	( blob -- )" );
	swigFunction( "c-function hb_blob_set_user_data hb_blob_set_user_data a a a a n -- n", "FUNCTION: hb_blob_set_user_data ( blob key data destroy replace -- n )", "EXTERN: \"C\" int hb_blob_set_user_data( void * blob, void * key, void * data, void * destroy, int replace );", "	( blob key data destroy replace -- )" );
	swigFunction( "c-function hb_blob_get_user_data hb_blob_get_user_data a a -- a", "FUNCTION: hb_blob_get_user_data ( blob key -- a )", "EXTERN: \"C\" void * hb_blob_get_user_data( void * blob, void * key );", "	( blob key -- )" );
	swigFunction( "c-function hb_blob_make_immutable hb_blob_make_immutable a -- void", "FUNCTION: hb_blob_make_immutable ( blob -- void )", "EXTERN: \"C\" void hb_blob_make_immutable( void * blob );", "	( blob -- )" );
	swigFunction( "c-function hb_blob_is_immutable hb_blob_is_immutable a -- n", "FUNCTION: hb_blob_is_immutable ( blob -- n )", "EXTERN: \"C\" int hb_blob_is_immutable( void * blob );", "	( blob -- )" );
	swigFunction( "c-function hb_blob_get_length hb_blob_get_length a -- u", "FUNCTION: hb_blob_get_length ( blob -- u )", "EXTERN: \"C\" int hb_blob_get_length( void * blob );", "	( blob -- )" );
	swigFunction( "c-function hb_blob_get_data hb_blob_get_data a a -- s", "FUNCTION: hb_blob_get_data ( blob length -- s )", "EXTERN: \"C\" char * hb_blob_get_data( void * blob, void * length );", "	( blob length -- )" );
	swigFunction( "c-function hb_blob_get_data_writable hb_blob_get_data_writable a a -- a", "FUNCTION: hb_blob_get_data_writable ( blob length -- a )", "EXTERN: \"C\" void * hb_blob_get_data_writable( void * blob, void * length );", "	( blob length -- )" );
	swigFunction( "c-function hb_glyph_info_get_glyph_flags hb_glyph_info_get_glyph_flags a -- n", "FUNCTION: hb_glyph_info_get_glyph_flags ( info -- n )", "EXTERN: \"C\" int hb_glyph_info_get_glyph_flags( void * info );", "	( info -- )" );
	swigFunction( "c-function hb_segment_properties_equal hb_segment_properties_equal a a -- n", "FUNCTION: hb_segment_properties_equal ( a b -- n )", "EXTERN: \"C\" int hb_segment_properties_equal( void * a, void * b );", "	( a b -- )" );
	swigFunction( "c-function hb_segment_properties_hash hb_segment_properties_hash a -- u", "FUNCTION: hb_segment_properties_hash ( p -- u )", "EXTERN: \"C\" int hb_segment_properties_hash( void * p );", "	( p -- )" );
#if HB_MIN_VER(3,3)
	swigFunction( "c-function hb_segment_properties_overlay hb_segment_properties_overlay a a -- void", "FUNCTION: hb_segment_properties_overlay ( p src -- void )", "EXTERN: \"C\" void hb_segment_properties_overlay( void * p, void * src );", "	( p src -- )" );
#endif
	swigFunction( "c-function hb_buffer_create hb_buffer_create  -- a", "FUNCTION: hb_buffer_create (  -- a )", "EXTERN: \"C\" void * hb_buffer_create(  );", "	( -- )" );
#if HB_MIN_VER(3,3)
	swigFunction( "c-function hb_buffer_create_similar hb_buffer_create_similar a -- a", "FUNCTION: hb_buffer_create_similar ( src -- a )", "EXTERN: \"C\" void * hb_buffer_create_similar( void * src );", "	( src -- )" );
#endif
	swigFunction( "c-function hb_buffer_reset hb_buffer_reset a -- void", "FUNCTION: hb_buffer_reset ( buffer -- void )", "EXTERN: \"C\" void hb_buffer_reset( void * buffer );", "	( buffer -- )" );
	swigFunction( "c-function hb_buffer_get_empty hb_buffer_get_empty  -- a", "FUNCTION: hb_buffer_get_empty (  -- a )", "EXTERN: \"C\" void * hb_buffer_get_empty(  );", "	( -- )" );
	swigFunction( "c-function hb_buffer_reference hb_buffer_reference a -- a", "FUNCTION: hb_buffer_reference ( buffer -- a )", "EXTERN: \"C\" void * hb_buffer_reference( void * buffer );", "	( buffer -- )" );
	swigFunction( "c-function hb_buffer_destroy hb_buffer_destroy a -- void", "FUNCTION: hb_buffer_destroy ( buffer -- void )", "EXTERN: \"C\" void hb_buffer_destroy( void * buffer );", "	( buffer -- )" );
	swigFunction( "c-function hb_buffer_set_user_data hb_buffer_set_user_data a a a a n -- n", "FUNCTION: hb_buffer_set_user_data ( buffer key data destroy replace -- n )", "EXTERN: \"C\" int hb_buffer_set_user_data( void * buffer, void * key, void * data, void * destroy, int replace );", "	( buffer key data destroy replace -- )" );
	swigFunction( "c-function hb_buffer_get_user_data hb_buffer_get_user_data a a -- a", "FUNCTION: hb_buffer_get_user_data ( buffer key -- a )", "EXTERN: \"C\" void * hb_buffer_get_user_data( void * buffer, void * key );", "	( buffer key -- )" );
	swigFunction( "c-function hb_buffer_set_content_type hb_buffer_set_content_type a n -- void", "FUNCTION: hb_buffer_set_content_type ( buffer content_type -- void )", "EXTERN: \"C\" void hb_buffer_set_content_type( void * buffer, int content_type );", "	( buffer content_type -- )" );
	swigFunction( "c-function hb_buffer_get_content_type hb_buffer_get_content_type a -- n", "FUNCTION: hb_buffer_get_content_type ( buffer -- n )", "EXTERN: \"C\" int hb_buffer_get_content_type( void * buffer );", "	( buffer -- )" );
	swigFunction( "c-function hb_buffer_set_unicode_funcs hb_buffer_set_unicode_funcs a a -- void", "FUNCTION: hb_buffer_set_unicode_funcs ( buffer unicode_funcs -- void )", "EXTERN: \"C\" void hb_buffer_set_unicode_funcs( void * buffer, void * unicode_funcs );", "	( buffer unicode_funcs -- )" );
	swigFunction( "c-function hb_buffer_get_unicode_funcs hb_buffer_get_unicode_funcs a -- a", "FUNCTION: hb_buffer_get_unicode_funcs ( buffer -- a )", "EXTERN: \"C\" void * hb_buffer_get_unicode_funcs( void * buffer );", "	( buffer -- )" );
	swigFunction( "c-function hb_buffer_set_direction hb_buffer_set_direction a n -- void", "FUNCTION: hb_buffer_set_direction ( buffer direction -- void )", "EXTERN: \"C\" void hb_buffer_set_direction( void * buffer, int direction );", "	( buffer direction -- )" );
	swigFunction( "c-function hb_buffer_get_direction hb_buffer_get_direction a -- n", "FUNCTION: hb_buffer_get_direction ( buffer -- n )", "EXTERN: \"C\" int hb_buffer_get_direction( void * buffer );", "	( buffer -- )" );
	swigFunction( "c-function hb_buffer_set_script hb_buffer_set_script a n -- void", "FUNCTION: hb_buffer_set_script ( buffer script -- void )", "EXTERN: \"C\" void hb_buffer_set_script( void * buffer, int script );", "	( buffer script -- )" );
	swigFunction( "c-function hb_buffer_get_script hb_buffer_get_script a -- n", "FUNCTION: hb_buffer_get_script ( buffer -- n )", "EXTERN: \"C\" int hb_buffer_get_script( void * buffer );", "	( buffer -- )" );
	swigFunction( "c-function hb_buffer_set_language hb_buffer_set_language a a -- void", "FUNCTION: hb_buffer_set_language ( buffer language -- void )", "EXTERN: \"C\" void hb_buffer_set_language( void * buffer, void * language );", "	( buffer language -- )" );
	swigFunction( "c-function hb_buffer_get_language hb_buffer_get_language a -- a", "FUNCTION: hb_buffer_get_language ( buffer -- a )", "EXTERN: \"C\" void * hb_buffer_get_language( void * buffer );", "	( buffer -- )" );
	swigFunction( "c-function hb_buffer_set_segment_properties hb_buffer_set_segment_properties a a -- void", "FUNCTION: hb_buffer_set_segment_properties ( buffer props -- void )", "EXTERN: \"C\" void hb_buffer_set_segment_properties( void * buffer, void * props );", "	( buffer props -- )" );
	swigFunction( "c-function hb_buffer_get_segment_properties hb_buffer_get_segment_properties a a -- void", "FUNCTION: hb_buffer_get_segment_properties ( buffer props -- void )", "EXTERN: \"C\" void hb_buffer_get_segment_properties( void * buffer, void * props );", "	( buffer props -- )" );
	swigFunction( "c-function hb_buffer_guess_segment_properties hb_buffer_guess_segment_properties a -- void", "FUNCTION: hb_buffer_guess_segment_properties ( buffer -- void )", "EXTERN: \"C\" void hb_buffer_guess_segment_properties( void * buffer );", "	( buffer -- )" );
	swigFunction( "c-function hb_buffer_set_flags hb_buffer_set_flags a n -- void", "FUNCTION: hb_buffer_set_flags ( buffer flags -- void )", "EXTERN: \"C\" void hb_buffer_set_flags( void * buffer, int flags );", "	( buffer flags -- )" );
	swigFunction( "c-function hb_buffer_get_flags hb_buffer_get_flags a -- n", "FUNCTION: hb_buffer_get_flags ( buffer -- n )", "EXTERN: \"C\" int hb_buffer_get_flags( void * buffer );", "	( buffer -- )" );
	swigFunction( "c-function hb_buffer_set_cluster_level hb_buffer_set_cluster_level a n -- void", "FUNCTION: hb_buffer_set_cluster_level ( buffer cluster_level -- void )", "EXTERN: \"C\" void hb_buffer_set_cluster_level( void * buffer, int cluster_level );", "	( buffer cluster_level -- )" );
	swigFunction( "c-function hb_buffer_get_cluster_level hb_buffer_get_cluster_level a -- n", "FUNCTION: hb_buffer_get_cluster_level ( buffer -- n )", "EXTERN: \"C\" int hb_buffer_get_cluster_level( void * buffer );", "	( buffer -- )" );
	swigFunction( "c-function hb_buffer_set_replacement_codepoint hb_buffer_set_replacement_codepoint a u -- void", "FUNCTION: hb_buffer_set_replacement_codepoint ( buffer replacement -- void )", "EXTERN: \"C\" void hb_buffer_set_replacement_codepoint( void * buffer, int replacement );", "	( buffer replacement -- )" );
	swigFunction( "c-function hb_buffer_get_replacement_codepoint hb_buffer_get_replacement_codepoint a -- u", "FUNCTION: hb_buffer_get_replacement_codepoint ( buffer -- u )", "EXTERN: \"C\" int hb_buffer_get_replacement_codepoint( void * buffer );", "	( buffer -- )" );
	swigFunction( "c-function hb_buffer_set_invisible_glyph hb_buffer_set_invisible_glyph a u -- void", "FUNCTION: hb_buffer_set_invisible_glyph ( buffer invisible -- void )", "EXTERN: \"C\" void hb_buffer_set_invisible_glyph( void * buffer, int invisible );", "	( buffer invisible -- )" );
	swigFunction( "c-function hb_buffer_get_invisible_glyph hb_buffer_get_invisible_glyph a -- u", "FUNCTION: hb_buffer_get_invisible_glyph ( buffer -- u )", "EXTERN: \"C\" int hb_buffer_get_invisible_glyph( void * buffer );", "	( buffer -- )" );
#if HB_MIN_VER(3,1)
	swigFunction( "c-function hb_buffer_set_not_found_glyph hb_buffer_set_not_found_glyph a u -- void", "FUNCTION: hb_buffer_set_not_found_glyph ( buffer not_found -- void )", "EXTERN: \"C\" void hb_buffer_set_not_found_glyph( void * buffer, int not_found );", "	( buffer not_found -- )" );
#endif
#if HB_MIN_VER(3,1)
	swigFunction( "c-function hb_buffer_get_not_found_glyph hb_buffer_get_not_found_glyph a -- u", "FUNCTION: hb_buffer_get_not_found_glyph ( buffer -- u )", "EXTERN: \"C\" int hb_buffer_get_not_found_glyph( void * buffer );", "	( buffer -- )" );
#endif
	swigFunction( "c-function hb_buffer_clear_contents hb_buffer_clear_contents a -- void", "FUNCTION: hb_buffer_clear_contents ( buffer -- void )", "EXTERN: \"C\" void hb_buffer_clear_contents( void * buffer );", "	( buffer -- )" );
	swigFunction( "c-function hb_buffer_pre_allocate hb_buffer_pre_allocate a u -- n", "FUNCTION: hb_buffer_pre_allocate ( buffer size -- n )", "EXTERN: \"C\" int hb_buffer_pre_allocate( void * buffer, int size );", "	( buffer size -- )" );
	swigFunction( "c-function hb_buffer_allocation_successful hb_buffer_allocation_successful a -- n", "FUNCTION: hb_buffer_allocation_successful ( buffer -- n )", "EXTERN: \"C\" int hb_buffer_allocation_successful( void * buffer );", "	( buffer -- )" );
	swigFunction( "c-function hb_buffer_reverse hb_buffer_reverse a -- void", "FUNCTION: hb_buffer_reverse ( buffer -- void )", "EXTERN: \"C\" void hb_buffer_reverse( void * buffer );", "	( buffer -- )" );
	swigFunction( "c-function hb_buffer_reverse_range hb_buffer_reverse_range a u u -- void", "FUNCTION: hb_buffer_reverse_range ( buffer start end -- void )", "EXTERN: \"C\" void hb_buffer_reverse_range( void * buffer, int start, int end );", "	( buffer start end -- )" );
	swigFunction( "c-function hb_buffer_reverse_clusters hb_buffer_reverse_clusters a -- void", "FUNCTION: hb_buffer_reverse_clusters ( buffer -- void )", "EXTERN: \"C\" void hb_buffer_reverse_clusters( void * buffer );", "	( buffer -- )" );
	swigFunction( "c-function hb_buffer_add hb_buffer_add a u u -- void", "FUNCTION: hb_buffer_add ( buffer codepoint cluster -- void )", "EXTERN: \"C\" void hb_buffer_add( void * buffer, int codepoint, int cluster );", "	( buffer codepoint cluster -- )" );
	swigFunction( "c-function hb_buffer_add_utf8 hb_buffer_add_utf8 a s n u n -- void", "FUNCTION: hb_buffer_add_utf8 ( buffer text text_length item_offset item_length -- void )", "EXTERN: \"C\" void hb_buffer_add_utf8( void * buffer, char * text, int text_length, int item_offset, int item_length );", "	( buffer text text_length item_offset item_length -- )" );
	swigFunction( "c-function hb_buffer_add_utf16 hb_buffer_add_utf16 a a n u n -- void", "FUNCTION: hb_buffer_add_utf16 ( buffer text text_length item_offset item_length -- void )", "EXTERN: \"C\" void hb_buffer_add_utf16( void * buffer, void * text, int text_length, int item_offset, int item_length );", "	( buffer text text_length item_offset item_length -- )" );
	swigFunction( "c-function hb_buffer_add_utf32 hb_buffer_add_utf32 a a n u n -- void", "FUNCTION: hb_buffer_add_utf32 ( buffer text text_length item_offset item_length -- void )", "EXTERN: \"C\" void hb_buffer_add_utf32( void * buffer, void * text, int text_length, int item_offset, int item_length );", "	( buffer text text_length item_offset item_length -- )" );
	swigFunction( "c-function hb_buffer_add_latin1 hb_buffer_add_latin1 a a n u n -- void", "FUNCTION: hb_buffer_add_latin1 ( buffer text text_length item_offset item_length -- void )", "EXTERN: \"C\" void hb_buffer_add_latin1( void * buffer, void * text, int text_length, int item_offset, int item_length );", "	( buffer text text_length item_offset item_length -- )" );
	swigFunction( "c-function hb_buffer_add_codepoints hb_buffer_add_codepoints a a n u n -- void", "FUNCTION: hb_buffer_add_codepoints ( buffer text text_length item_offset item_length -- void )", "EXTERN: \"C\" void hb_buffer_add_codepoints( void * buffer, void * text, int text_length, int item_offset, int item_length );", "	( buffer text text_length item_offset item_length -- )" );
	swigFunction( "c-function hb_buffer_append hb_buffer_append a a u u -- void", "FUNCTION: hb_buffer_append ( buffer source start end -- void )", "EXTERN: \"C\" void hb_buffer_append( void * buffer, void * source, int start, int end );", "	( buffer source start end -- )" );
	swigFunction( "c-function hb_buffer_set_length hb_buffer_set_length a u -- n", "FUNCTION: hb_buffer_set_length ( buffer length -- n )", "EXTERN: \"C\" int hb_buffer_set_length( void * buffer, int length );", "	( buffer length -- )" );
	swigFunction( "c-function hb_buffer_get_length hb_buffer_get_length a -- u", "FUNCTION: hb_buffer_get_length ( buffer -- u )", "EXTERN: \"C\" int hb_buffer_get_length( void * buffer );", "	( buffer -- )" );
	swigFunction( "c-function hb_buffer_get_glyph_infos hb_buffer_get_glyph_infos a a -- a", "FUNCTION: hb_buffer_get_glyph_infos ( buffer length -- a )", "EXTERN: \"C\" void * hb_buffer_get_glyph_infos( void * buffer, void * length );", "	( buffer length -- )" );
	swigFunction( "c-function hb_buffer_get_glyph_positions hb_buffer_get_glyph_positions a a -- a", "FUNCTION: hb_buffer_get_glyph_positions ( buffer length -- a )", "EXTERN: \"C\" void * hb_buffer_get_glyph_positions( void * buffer, void * length );", "	( buffer length -- )" );
	swigFunction( "c-function hb_buffer_has_positions hb_buffer_has_positions a -- n", "FUNCTION: hb_buffer_has_positions ( buffer -- n )", "EXTERN: \"C\" int hb_buffer_has_positions( void * buffer );", "	( buffer -- )" );
	swigFunction( "c-function hb_buffer_normalize_glyphs hb_buffer_normalize_glyphs a -- void", "FUNCTION: hb_buffer_normalize_glyphs ( buffer -- void )", "EXTERN: \"C\" void hb_buffer_normalize_glyphs( void * buffer );", "	( buffer -- )" );
	swigFunction( "c-function hb_buffer_serialize_format_from_string hb_buffer_serialize_format_from_string s n -- n", "FUNCTION: hb_buffer_serialize_format_from_string ( str len -- n )", "EXTERN: \"C\" int hb_buffer_serialize_format_from_string( char * str, int len );", "	( str len -- )" );
	swigFunction( "c-function hb_buffer_serialize_format_to_string hb_buffer_serialize_format_to_string n -- s", "FUNCTION: hb_buffer_serialize_format_to_string ( format -- s )", "EXTERN: \"C\" char * hb_buffer_serialize_format_to_string( int format );", "	( format -- )" );
	swigFunction( "c-function hb_buffer_serialize_list_formats hb_buffer_serialize_list_formats  -- a", "FUNCTION: hb_buffer_serialize_list_formats (  -- a )", "EXTERN: \"C\" void * hb_buffer_serialize_list_formats(  );", "	( -- )" );
	swigFunction( "c-function hb_buffer_serialize_glyphs hb_buffer_serialize_glyphs a u u a u a a n n -- u", "FUNCTION: hb_buffer_serialize_glyphs ( buffer start end buf buf_size buf_consumed font format flags -- u )", "EXTERN: \"C\" int hb_buffer_serialize_glyphs( void * buffer, int start, int end, void * buf, int buf_size, void * buf_consumed, void * font, int format, int flags );", "	( buffer start end buf buf_size buf_consumed font format flags -- )" );
	swigFunction( "c-function hb_buffer_serialize_unicode hb_buffer_serialize_unicode a u u a u a n n -- u", "FUNCTION: hb_buffer_serialize_unicode ( buffer start end buf buf_size buf_consumed format flags -- u )", "EXTERN: \"C\" int hb_buffer_serialize_unicode( void * buffer, int start, int end, void * buf, int buf_size, void * buf_consumed, int format, int flags );", "	( buffer start end buf buf_size buf_consumed format flags -- )" );
	swigFunction( "c-function hb_buffer_serialize hb_buffer_serialize a u u a u a a n n -- u", "FUNCTION: hb_buffer_serialize ( buffer start end buf buf_size buf_consumed font format flags -- u )", "EXTERN: \"C\" int hb_buffer_serialize( void * buffer, int start, int end, void * buf, int buf_size, void * buf_consumed, void * font, int format, int flags );", "	( buffer start end buf buf_size buf_consumed font format flags -- )" );
	swigFunction( "c-function hb_buffer_deserialize_glyphs hb_buffer_deserialize_glyphs a s n a a n -- n", "FUNCTION: hb_buffer_deserialize_glyphs ( buffer buf buf_len end_ptr font format -- n )", "EXTERN: \"C\" int hb_buffer_deserialize_glyphs( void * buffer, char * buf, int buf_len, void * end_ptr, void * font, int format );", "	( buffer buf buf_len end_ptr font format -- )" );
	swigFunction( "c-function hb_buffer_deserialize_unicode hb_buffer_deserialize_unicode a s n a n -- n", "FUNCTION: hb_buffer_deserialize_unicode ( buffer buf buf_len end_ptr format -- n )", "EXTERN: \"C\" int hb_buffer_deserialize_unicode( void * buffer, char * buf, int buf_len, void * end_ptr, int format );", "	( buffer buf buf_len end_ptr format -- )" );
	swigFunction( "c-function hb_buffer_diff hb_buffer_diff a a u u -- n", "FUNCTION: hb_buffer_diff ( buffer reference dottedcircle_glyph position_fuzz -- n )", "EXTERN: \"C\" int hb_buffer_diff( void * buffer, void * reference, int dottedcircle_glyph, int position_fuzz );", "	( buffer reference dottedcircle_glyph position_fuzz -- )" );
	swigFunction( "c-function hb_buffer_set_message_func hb_buffer_set_message_func a a a a -- void", "FUNCTION: hb_buffer_set_message_func ( buffer func user_data destroy -- void )", "EXTERN: \"C\" void hb_buffer_set_message_func( void * buffer, void * func, void * user_data, void * destroy );", "	( buffer func user_data destroy -- )" );
	swigFunction( "c-function hb_tag_from_string hb_tag_from_string s n -- u", "FUNCTION: hb_tag_from_string ( str len -- u )", "EXTERN: \"C\" int hb_tag_from_string( char * str, int len );", "	( str len -- )" );
	swigFunction( "c-function hb_tag_to_string hb_tag_to_string u a -- void", "FUNCTION: hb_tag_to_string ( tag buf -- void )", "EXTERN: \"C\" void hb_tag_to_string( int tag, void * buf );", "	( tag buf -- )" );
	swigFunction( "c-function hb_direction_from_string hb_direction_from_string s n -- n", "FUNCTION: hb_direction_from_string ( str len -- n )", "EXTERN: \"C\" int hb_direction_from_string( char * str, int len );", "	( str len -- )" );
	swigFunction( "c-function hb_direction_to_string hb_direction_to_string n -- s", "FUNCTION: hb_direction_to_string ( direction -- s )", "EXTERN: \"C\" char * hb_direction_to_string( int direction );", "	( direction -- )" );
	swigFunction( "c-function hb_language_from_string hb_language_from_string s n -- a", "FUNCTION: hb_language_from_string ( str len -- a )", "EXTERN: \"C\" void * hb_language_from_string( char * str, int len );", "	( str len -- )" );
	swigFunction( "c-function hb_language_to_string hb_language_to_string a -- s", "FUNCTION: hb_language_to_string ( language -- s )", "EXTERN: \"C\" char * hb_language_to_string( void * language );", "	( language -- )" );
	swigFunction( "c-function hb_language_get_default hb_language_get_default  -- a", "FUNCTION: hb_language_get_default (  -- a )", "EXTERN: \"C\" void * hb_language_get_default(  );", "	( -- )" );
#if HB_MIN_VER(5,0)
	swigFunction( "c-function hb_language_matches hb_language_matches a a -- n", "FUNCTION: hb_language_matches ( language specific -- n )", "EXTERN: \"C\" int hb_language_matches( void * language, void * specific );", "	( language specific -- )" );
#endif
	swigFunction( "c-function hb_script_from_iso15924_tag hb_script_from_iso15924_tag u -- n", "FUNCTION: hb_script_from_iso15924_tag ( tag -- n )", "EXTERN: \"C\" int hb_script_from_iso15924_tag( int tag );", "	( tag -- )" );
	swigFunction( "c-function hb_script_from_string hb_script_from_string s n -- n", "FUNCTION: hb_script_from_string ( str len -- n )", "EXTERN: \"C\" int hb_script_from_string( char * str, int len );", "	( str len -- )" );
	swigFunction( "c-function hb_script_to_iso15924_tag hb_script_to_iso15924_tag n -- u", "FUNCTION: hb_script_to_iso15924_tag ( script -- u )", "EXTERN: \"C\" int hb_script_to_iso15924_tag( int script );", "	( script -- )" );
	swigFunction( "c-function hb_script_get_horizontal_direction hb_script_get_horizontal_direction n -- n", "FUNCTION: hb_script_get_horizontal_direction ( script -- n )", "EXTERN: \"C\" int hb_script_get_horizontal_direction( int script );", "	( script -- )" );
	swigFunction( "c-function hb_feature_from_string hb_feature_from_string s n a -- n", "FUNCTION: hb_feature_from_string ( str len feature -- n )", "EXTERN: \"C\" int hb_feature_from_string( char * str, int len, void * feature );", "	( str len feature -- )" );
	swigFunction( "c-function hb_feature_to_string hb_feature_to_string a a u -- void", "FUNCTION: hb_feature_to_string ( feature buf size -- void )", "EXTERN: \"C\" void hb_feature_to_string( void * feature, void * buf, int size );", "	( feature buf size -- )" );
	swigFunction( "c-function hb_variation_from_string hb_variation_from_string s n a -- n", "FUNCTION: hb_variation_from_string ( str len variation -- n )", "EXTERN: \"C\" int hb_variation_from_string( char * str, int len, void * variation );", "	( str len variation -- )" );
	swigFunction( "c-function hb_variation_to_string hb_variation_to_string a a u -- void", "FUNCTION: hb_variation_to_string ( variation buf size -- void )", "EXTERN: \"C\" void hb_variation_to_string( void * variation, void * buf, int size );", "	( variation buf size -- )" );
	swigFunction( "c-function hb_color_get_alpha hb_color_get_alpha u -- u", "FUNCTION: hb_color_get_alpha ( color -- u )", "EXTERN: \"C\" char hb_color_get_alpha( int color );", "	( color -- )" );
	swigFunction( "c-function hb_color_get_red hb_color_get_red u -- u", "FUNCTION: hb_color_get_red ( color -- u )", "EXTERN: \"C\" char hb_color_get_red( int color );", "	( color -- )" );
	swigFunction( "c-function hb_color_get_green hb_color_get_green u -- u", "FUNCTION: hb_color_get_green ( color -- u )", "EXTERN: \"C\" char hb_color_get_green( int color );", "	( color -- )" );
	swigFunction( "c-function hb_color_get_blue hb_color_get_blue u -- u", "FUNCTION: hb_color_get_blue ( color -- u )", "EXTERN: \"C\" char hb_color_get_blue( int color );", "	( color -- )" );
	swigFunction( "c-function hb_face_count hb_face_count a -- u", "FUNCTION: hb_face_count ( blob -- u )", "EXTERN: \"C\" int hb_face_count( void * blob );", "	( blob -- )" );
	swigFunction( "c-function hb_face_create hb_face_create a u -- a", "FUNCTION: hb_face_create ( blob index -- a )", "EXTERN: \"C\" void * hb_face_create( void * blob, int index );", "	( blob index -- )" );
	swigFunction( "c-function hb_face_create_for_tables hb_face_create_for_tables a a a -- a", "FUNCTION: hb_face_create_for_tables ( reference_table_func user_data destroy -- a )", "EXTERN: \"C\" void * hb_face_create_for_tables( void * reference_table_func, void * user_data, void * destroy );", "	( reference_table_func user_data destroy -- )" );
	swigFunction( "c-function hb_face_get_empty hb_face_get_empty  -- a", "FUNCTION: hb_face_get_empty (  -- a )", "EXTERN: \"C\" void * hb_face_get_empty(  );", "	( -- )" );
	swigFunction( "c-function hb_face_reference hb_face_reference a -- a", "FUNCTION: hb_face_reference ( face -- a )", "EXTERN: \"C\" void * hb_face_reference( void * face );", "	( face -- )" );
	swigFunction( "c-function hb_face_destroy hb_face_destroy a -- void", "FUNCTION: hb_face_destroy ( face -- void )", "EXTERN: \"C\" void hb_face_destroy( void * face );", "	( face -- )" );
	swigFunction( "c-function hb_face_set_user_data hb_face_set_user_data a a a a n -- n", "FUNCTION: hb_face_set_user_data ( face key data destroy replace -- n )", "EXTERN: \"C\" int hb_face_set_user_data( void * face, void * key, void * data, void * destroy, int replace );", "	( face key data destroy replace -- )" );
	swigFunction( "c-function hb_face_get_user_data hb_face_get_user_data a a -- a", "FUNCTION: hb_face_get_user_data ( face key -- a )", "EXTERN: \"C\" void * hb_face_get_user_data( void * face, void * key );", "	( face key -- )" );
	swigFunction( "c-function hb_face_make_immutable hb_face_make_immutable a -- void", "FUNCTION: hb_face_make_immutable ( face -- void )", "EXTERN: \"C\" void hb_face_make_immutable( void * face );", "	( face -- )" );
	swigFunction( "c-function hb_face_is_immutable hb_face_is_immutable a -- n", "FUNCTION: hb_face_is_immutable ( face -- n )", "EXTERN: \"C\" int hb_face_is_immutable( void * face );", "	( face -- )" );
	swigFunction( "c-function hb_face_reference_table hb_face_reference_table a u -- a", "FUNCTION: hb_face_reference_table ( face tag -- a )", "EXTERN: \"C\" void * hb_face_reference_table( void * face, int tag );", "	( face tag -- )" );
	swigFunction( "c-function hb_face_reference_blob hb_face_reference_blob a -- a", "FUNCTION: hb_face_reference_blob ( face -- a )", "EXTERN: \"C\" void * hb_face_reference_blob( void * face );", "	( face -- )" );
	swigFunction( "c-function hb_face_set_index hb_face_set_index a u -- void", "FUNCTION: hb_face_set_index ( face index -- void )", "EXTERN: \"C\" void hb_face_set_index( void * face, int index );", "	( face index -- )" );
	swigFunction( "c-function hb_face_get_index hb_face_get_index a -- u", "FUNCTION: hb_face_get_index ( face -- u )", "EXTERN: \"C\" int hb_face_get_index( void * face );", "	( face -- )" );
	swigFunction( "c-function hb_face_set_upem hb_face_set_upem a u -- void", "FUNCTION: hb_face_set_upem ( face upem -- void )", "EXTERN: \"C\" void hb_face_set_upem( void * face, int upem );", "	( face upem -- )" );
	swigFunction( "c-function hb_face_get_upem hb_face_get_upem a -- u", "FUNCTION: hb_face_get_upem ( face -- u )", "EXTERN: \"C\" int hb_face_get_upem( void * face );", "	( face -- )" );
	swigFunction( "c-function hb_face_set_glyph_count hb_face_set_glyph_count a u -- void", "FUNCTION: hb_face_set_glyph_count ( face glyph_count -- void )", "EXTERN: \"C\" void hb_face_set_glyph_count( void * face, int glyph_count );", "	( face glyph_count -- )" );
	swigFunction( "c-function hb_face_get_glyph_count hb_face_get_glyph_count a -- u", "FUNCTION: hb_face_get_glyph_count ( face -- u )", "EXTERN: \"C\" int hb_face_get_glyph_count( void * face );", "	( face -- )" );
	swigFunction( "c-function hb_face_get_table_tags hb_face_get_table_tags a u a a -- u", "FUNCTION: hb_face_get_table_tags ( face start_offset table_count table_tags -- u )", "EXTERN: \"C\" int hb_face_get_table_tags( void * face, int start_offset, void * table_count, void * table_tags );", "	( face start_offset table_count table_tags -- )" );
	swigFunction( "c-function hb_face_collect_unicodes hb_face_collect_unicodes a a -- void", "FUNCTION: hb_face_collect_unicodes ( face out -- void )", "EXTERN: \"C\" void hb_face_collect_unicodes( void * face, void * out );", "	( face out -- )" );
#if HB_MIN_VER(7,0)
	swigFunction( "c-function hb_face_collect_nominal_glyph_mapping hb_face_collect_nominal_glyph_mapping a a a -- void", "FUNCTION: hb_face_collect_nominal_glyph_mapping ( face mapping unicodes -- void )", "EXTERN: \"C\" void hb_face_collect_nominal_glyph_mapping( void * face, void * mapping, void * unicodes );", "	( face mapping unicodes -- )" );
#endif
	swigFunction( "c-function hb_face_collect_variation_selectors hb_face_collect_variation_selectors a a -- void", "FUNCTION: hb_face_collect_variation_selectors ( face out -- void )", "EXTERN: \"C\" void hb_face_collect_variation_selectors( void * face, void * out );", "	( face out -- )" );
	swigFunction( "c-function hb_face_collect_variation_unicodes hb_face_collect_variation_unicodes a u a -- void", "FUNCTION: hb_face_collect_variation_unicodes ( face variation_selector out -- void )", "EXTERN: \"C\" void hb_face_collect_variation_unicodes( void * face, int variation_selector, void * out );", "	( face variation_selector out -- )" );
	swigFunction( "c-function hb_face_builder_create hb_face_builder_create  -- a", "FUNCTION: hb_face_builder_create (  -- a )", "EXTERN: \"C\" void * hb_face_builder_create(  );", "	( -- )" );
	swigFunction( "c-function hb_face_builder_add_table hb_face_builder_add_table a u a -- n", "FUNCTION: hb_face_builder_add_table ( face tag blob -- n )", "EXTERN: \"C\" int hb_face_builder_add_table( void * face, int tag, void * blob );", "	( face tag blob -- )" );
#if HB_MIN_VER(5,3)
	swigFunction( "c-function hb_face_builder_sort_tables hb_face_builder_sort_tables a a -- void", "FUNCTION: hb_face_builder_sort_tables ( face tags -- void )", "EXTERN: \"C\" void hb_face_builder_sort_tables( void * face, void * tags );", "	( face tags -- )" );
#endif
	swigFunction( "c-function hb_font_funcs_create hb_font_funcs_create  -- a", "FUNCTION: hb_font_funcs_create (  -- a )", "EXTERN: \"C\" void * hb_font_funcs_create(  );", "	( -- )" );
	swigFunction( "c-function hb_font_funcs_get_empty hb_font_funcs_get_empty  -- a", "FUNCTION: hb_font_funcs_get_empty (  -- a )", "EXTERN: \"C\" void * hb_font_funcs_get_empty(  );", "	( -- )" );
	swigFunction( "c-function hb_font_funcs_reference hb_font_funcs_reference a -- a", "FUNCTION: hb_font_funcs_reference ( ffuncs -- a )", "EXTERN: \"C\" void * hb_font_funcs_reference( void * ffuncs );", "	( ffuncs -- )" );
	swigFunction( "c-function hb_font_funcs_destroy hb_font_funcs_destroy a -- void", "FUNCTION: hb_font_funcs_destroy ( ffuncs -- void )", "EXTERN: \"C\" void hb_font_funcs_destroy( void * ffuncs );", "	( ffuncs -- )" );
	swigFunction( "c-function hb_font_funcs_set_user_data hb_font_funcs_set_user_data a a a a n -- n", "FUNCTION: hb_font_funcs_set_user_data ( ffuncs key data destroy replace -- n )", "EXTERN: \"C\" int hb_font_funcs_set_user_data( void * ffuncs, void * key, void * data, void * destroy, int replace );", "	( ffuncs key data destroy replace -- )" );
	swigFunction( "c-function hb_font_funcs_get_user_data hb_font_funcs_get_user_data a a -- a", "FUNCTION: hb_font_funcs_get_user_data ( ffuncs key -- a )", "EXTERN: \"C\" void * hb_font_funcs_get_user_data( void * ffuncs, void * key );", "	( ffuncs key -- )" );
	swigFunction( "c-function hb_font_funcs_make_immutable hb_font_funcs_make_immutable a -- void", "FUNCTION: hb_font_funcs_make_immutable ( ffuncs -- void )", "EXTERN: \"C\" void hb_font_funcs_make_immutable( void * ffuncs );", "	( ffuncs -- )" );
	swigFunction( "c-function hb_font_funcs_is_immutable hb_font_funcs_is_immutable a -- n", "FUNCTION: hb_font_funcs_is_immutable ( ffuncs -- n )", "EXTERN: \"C\" int hb_font_funcs_is_immutable( void * ffuncs );", "	( ffuncs -- )" );
	swigFunction( "c-function hb_font_funcs_set_font_h_extents_func hb_font_funcs_set_font_h_extents_func a a a a -- void", "FUNCTION: hb_font_funcs_set_font_h_extents_func ( ffuncs func user_data destroy -- void )", "EXTERN: \"C\" void hb_font_funcs_set_font_h_extents_func( void * ffuncs, void * func, void * user_data, void * destroy );", "	( ffuncs func user_data destroy -- )" );
	swigFunction( "c-function hb_font_funcs_set_font_v_extents_func hb_font_funcs_set_font_v_extents_func a a a a -- void", "FUNCTION: hb_font_funcs_set_font_v_extents_func ( ffuncs func user_data destroy -- void )", "EXTERN: \"C\" void hb_font_funcs_set_font_v_extents_func( void * ffuncs, void * func, void * user_data, void * destroy );", "	( ffuncs func user_data destroy -- )" );
	swigFunction( "c-function hb_font_funcs_set_nominal_glyph_func hb_font_funcs_set_nominal_glyph_func a a a a -- void", "FUNCTION: hb_font_funcs_set_nominal_glyph_func ( ffuncs func user_data destroy -- void )", "EXTERN: \"C\" void hb_font_funcs_set_nominal_glyph_func( void * ffuncs, void * func, void * user_data, void * destroy );", "	( ffuncs func user_data destroy -- )" );
	swigFunction( "c-function hb_font_funcs_set_nominal_glyphs_func hb_font_funcs_set_nominal_glyphs_func a a a a -- void", "FUNCTION: hb_font_funcs_set_nominal_glyphs_func ( ffuncs func user_data destroy -- void )", "EXTERN: \"C\" void hb_font_funcs_set_nominal_glyphs_func( void * ffuncs, void * func, void * user_data, void * destroy );", "	( ffuncs func user_data destroy -- )" );
	swigFunction( "c-function hb_font_funcs_set_variation_glyph_func hb_font_funcs_set_variation_glyph_func a a a a -- void", "FUNCTION: hb_font_funcs_set_variation_glyph_func ( ffuncs func user_data destroy -- void )", "EXTERN: \"C\" void hb_font_funcs_set_variation_glyph_func( void * ffuncs, void * func, void * user_data, void * destroy );", "	( ffuncs func user_data destroy -- )" );
	swigFunction( "c-function hb_font_funcs_set_glyph_h_advance_func hb_font_funcs_set_glyph_h_advance_func a a a a -- void", "FUNCTION: hb_font_funcs_set_glyph_h_advance_func ( ffuncs func user_data destroy -- void )", "EXTERN: \"C\" void hb_font_funcs_set_glyph_h_advance_func( void * ffuncs, void * func, void * user_data, void * destroy );", "	( ffuncs func user_data destroy -- )" );
	swigFunction( "c-function hb_font_funcs_set_glyph_v_advance_func hb_font_funcs_set_glyph_v_advance_func a a a a -- void", "FUNCTION: hb_font_funcs_set_glyph_v_advance_func ( ffuncs func user_data destroy -- void )", "EXTERN: \"C\" void hb_font_funcs_set_glyph_v_advance_func( void * ffuncs, void * func, void * user_data, void * destroy );", "	( ffuncs func user_data destroy -- )" );
	swigFunction( "c-function hb_font_funcs_set_glyph_h_advances_func hb_font_funcs_set_glyph_h_advances_func a a a a -- void", "FUNCTION: hb_font_funcs_set_glyph_h_advances_func ( ffuncs func user_data destroy -- void )", "EXTERN: \"C\" void hb_font_funcs_set_glyph_h_advances_func( void * ffuncs, void * func, void * user_data, void * destroy );", "	( ffuncs func user_data destroy -- )" );
	swigFunction( "c-function hb_font_funcs_set_glyph_v_advances_func hb_font_funcs_set_glyph_v_advances_func a a a a -- void", "FUNCTION: hb_font_funcs_set_glyph_v_advances_func ( ffuncs func user_data destroy -- void )", "EXTERN: \"C\" void hb_font_funcs_set_glyph_v_advances_func( void * ffuncs, void * func, void * user_data, void * destroy );", "	( ffuncs func user_data destroy -- )" );
	swigFunction( "c-function hb_font_funcs_set_glyph_h_origin_func hb_font_funcs_set_glyph_h_origin_func a a a a -- void", "FUNCTION: hb_font_funcs_set_glyph_h_origin_func ( ffuncs func user_data destroy -- void )", "EXTERN: \"C\" void hb_font_funcs_set_glyph_h_origin_func( void * ffuncs, void * func, void * user_data, void * destroy );", "	( ffuncs func user_data destroy -- )" );
	swigFunction( "c-function hb_font_funcs_set_glyph_v_origin_func hb_font_funcs_set_glyph_v_origin_func a a a a -- void", "FUNCTION: hb_font_funcs_set_glyph_v_origin_func ( ffuncs func user_data destroy -- void )", "EXTERN: \"C\" void hb_font_funcs_set_glyph_v_origin_func( void * ffuncs, void * func, void * user_data, void * destroy );", "	( ffuncs func user_data destroy -- )" );
	swigFunction( "c-function hb_font_funcs_set_glyph_h_kerning_func hb_font_funcs_set_glyph_h_kerning_func a a a a -- void", "FUNCTION: hb_font_funcs_set_glyph_h_kerning_func ( ffuncs func user_data destroy -- void )", "EXTERN: \"C\" void hb_font_funcs_set_glyph_h_kerning_func( void * ffuncs, void * func, void * user_data, void * destroy );", "	( ffuncs func user_data destroy -- )" );
	swigFunction( "c-function hb_font_funcs_set_glyph_extents_func hb_font_funcs_set_glyph_extents_func a a a a -- void", "FUNCTION: hb_font_funcs_set_glyph_extents_func ( ffuncs func user_data destroy -- void )", "EXTERN: \"C\" void hb_font_funcs_set_glyph_extents_func( void * ffuncs, void * func, void * user_data, void * destroy );", "	( ffuncs func user_data destroy -- )" );
	swigFunction( "c-function hb_font_funcs_set_glyph_contour_point_func hb_font_funcs_set_glyph_contour_point_func a a a a -- void", "FUNCTION: hb_font_funcs_set_glyph_contour_point_func ( ffuncs func user_data destroy -- void )", "EXTERN: \"C\" void hb_font_funcs_set_glyph_contour_point_func( void * ffuncs, void * func, void * user_data, void * destroy );", "	( ffuncs func user_data destroy -- )" );
	swigFunction( "c-function hb_font_funcs_set_glyph_name_func hb_font_funcs_set_glyph_name_func a a a a -- void", "FUNCTION: hb_font_funcs_set_glyph_name_func ( ffuncs func user_data destroy -- void )", "EXTERN: \"C\" void hb_font_funcs_set_glyph_name_func( void * ffuncs, void * func, void * user_data, void * destroy );", "	( ffuncs func user_data destroy -- )" );
	swigFunction( "c-function hb_font_funcs_set_glyph_from_name_func hb_font_funcs_set_glyph_from_name_func a a a a -- void", "FUNCTION: hb_font_funcs_set_glyph_from_name_func ( ffuncs func user_data destroy -- void )", "EXTERN: \"C\" void hb_font_funcs_set_glyph_from_name_func( void * ffuncs, void * func, void * user_data, void * destroy );", "	( ffuncs func user_data destroy -- )" );
#if HB_MIN_VER(7,0)
	swigFunction( "c-function hb_font_funcs_set_draw_glyph_func hb_font_funcs_set_draw_glyph_func a a a a -- void", "FUNCTION: hb_font_funcs_set_draw_glyph_func ( ffuncs func user_data destroy -- void )", "EXTERN: \"C\" void hb_font_funcs_set_draw_glyph_func( void * ffuncs, void * func, void * user_data, void * destroy );", "	( ffuncs func user_data destroy -- )" );
#endif
#if HB_MIN_VER(7,0)
	swigFunction( "c-function hb_font_funcs_set_paint_glyph_func hb_font_funcs_set_paint_glyph_func a a a a -- void", "FUNCTION: hb_font_funcs_set_paint_glyph_func ( ffuncs func user_data destroy -- void )", "EXTERN: \"C\" void hb_font_funcs_set_paint_glyph_func( void * ffuncs, void * func, void * user_data, void * destroy );", "	( ffuncs func user_data destroy -- )" );
#endif
	swigFunction( "c-function hb_font_get_h_extents hb_font_get_h_extents a a -- n", "FUNCTION: hb_font_get_h_extents ( font extents -- n )", "EXTERN: \"C\" int hb_font_get_h_extents( void * font, void * extents );", "	( font extents -- )" );
	swigFunction( "c-function hb_font_get_v_extents hb_font_get_v_extents a a -- n", "FUNCTION: hb_font_get_v_extents ( font extents -- n )", "EXTERN: \"C\" int hb_font_get_v_extents( void * font, void * extents );", "	( font extents -- )" );
	swigFunction( "c-function hb_font_get_nominal_glyph hb_font_get_nominal_glyph a u a -- n", "FUNCTION: hb_font_get_nominal_glyph ( font unicode glyph -- n )", "EXTERN: \"C\" int hb_font_get_nominal_glyph( void * font, int unicode, void * glyph );", "	( font unicode glyph -- )" );
	swigFunction( "c-function hb_font_get_variation_glyph hb_font_get_variation_glyph a u u a -- n", "FUNCTION: hb_font_get_variation_glyph ( font unicode variation_selector glyph -- n )", "EXTERN: \"C\" int hb_font_get_variation_glyph( void * font, int unicode, int variation_selector, void * glyph );", "	( font unicode variation_selector glyph -- )" );
	swigFunction( "c-function hb_font_get_nominal_glyphs hb_font_get_nominal_glyphs a u a u a u -- u", "FUNCTION: hb_font_get_nominal_glyphs ( font count first_unicode unicode_stride first_glyph glyph_stride -- u )", "EXTERN: \"C\" int hb_font_get_nominal_glyphs( void * font, int count, void * first_unicode, int unicode_stride, void * first_glyph, int glyph_stride );", "	( font count first_unicode unicode_stride first_glyph glyph_stride -- )" );
	swigFunction( "c-function hb_font_get_glyph_h_advance hb_font_get_glyph_h_advance a u -- n", "FUNCTION: hb_font_get_glyph_h_advance ( font glyph -- n )", "EXTERN: \"C\" int hb_font_get_glyph_h_advance( void * font, int glyph );", "	( font glyph -- )" );
	swigFunction( "c-function hb_font_get_glyph_v_advance hb_font_get_glyph_v_advance a u -- n", "FUNCTION: hb_font_get_glyph_v_advance ( font glyph -- n )", "EXTERN: \"C\" int hb_font_get_glyph_v_advance( void * font, int glyph );", "	( font glyph -- )" );
	swigFunction( "c-function hb_font_get_glyph_h_advances hb_font_get_glyph_h_advances a u a u a u -- void", "FUNCTION: hb_font_get_glyph_h_advances ( font count first_glyph glyph_stride first_advance advance_stride -- void )", "EXTERN: \"C\" void hb_font_get_glyph_h_advances( void * font, int count, void * first_glyph, int glyph_stride, void * first_advance, int advance_stride );", "	( font count first_glyph glyph_stride first_advance advance_stride -- )" );
	swigFunction( "c-function hb_font_get_glyph_v_advances hb_font_get_glyph_v_advances a u a u a u -- void", "FUNCTION: hb_font_get_glyph_v_advances ( font count first_glyph glyph_stride first_advance advance_stride -- void )", "EXTERN: \"C\" void hb_font_get_glyph_v_advances( void * font, int count, void * first_glyph, int glyph_stride, void * first_advance, int advance_stride );", "	( font count first_glyph glyph_stride first_advance advance_stride -- )" );
	swigFunction( "c-function hb_font_get_glyph_h_origin hb_font_get_glyph_h_origin a u a a -- n", "FUNCTION: hb_font_get_glyph_h_origin ( font glyph x y -- n )", "EXTERN: \"C\" int hb_font_get_glyph_h_origin( void * font, int glyph, void * x, void * y );", "	( font glyph x y -- )" );
	swigFunction( "c-function hb_font_get_glyph_v_origin hb_font_get_glyph_v_origin a u a a -- n", "FUNCTION: hb_font_get_glyph_v_origin ( font glyph x y -- n )", "EXTERN: \"C\" int hb_font_get_glyph_v_origin( void * font, int glyph, void * x, void * y );", "	( font glyph x y -- )" );
	swigFunction( "c-function hb_font_get_glyph_h_kerning hb_font_get_glyph_h_kerning a u u -- n", "FUNCTION: hb_font_get_glyph_h_kerning ( font left_glyph right_glyph -- n )", "EXTERN: \"C\" int hb_font_get_glyph_h_kerning( void * font, int left_glyph, int right_glyph );", "	( font left_glyph right_glyph -- )" );
	swigFunction( "c-function hb_font_get_glyph_extents hb_font_get_glyph_extents a u a -- n", "FUNCTION: hb_font_get_glyph_extents ( font glyph extents -- n )", "EXTERN: \"C\" int hb_font_get_glyph_extents( void * font, int glyph, void * extents );", "	( font glyph extents -- )" );
	swigFunction( "c-function hb_font_get_glyph_contour_point hb_font_get_glyph_contour_point a u u a a -- n", "FUNCTION: hb_font_get_glyph_contour_point ( font glyph point_index x y -- n )", "EXTERN: \"C\" int hb_font_get_glyph_contour_point( void * font, int glyph, int point_index, void * x, void * y );", "	( font glyph point_index x y -- )" );
	swigFunction( "c-function hb_font_get_glyph_name hb_font_get_glyph_name a u a u -- n", "FUNCTION: hb_font_get_glyph_name ( font glyph name size -- n )", "EXTERN: \"C\" int hb_font_get_glyph_name( void * font, int glyph, void * name, int size );", "	( font glyph name size -- )" );
	swigFunction( "c-function hb_font_get_glyph_from_name hb_font_get_glyph_from_name a s n a -- n", "FUNCTION: hb_font_get_glyph_from_name ( font name len glyph -- n )", "EXTERN: \"C\" int hb_font_get_glyph_from_name( void * font, char * name, int len, void * glyph );", "	( font name len glyph -- )" );
#if HB_MIN_VER(7,0)
	swigFunction( "c-function hb_font_draw_glyph hb_font_draw_glyph a u a a -- void", "FUNCTION: hb_font_draw_glyph ( font glyph dfuncs draw_data -- void )", "EXTERN: \"C\" void hb_font_draw_glyph( void * font, int glyph, void * dfuncs, void * draw_data );", "	( font glyph dfuncs draw_data -- )" );
#endif
#if HB_MIN_VER(7,0)
	swigFunction( "c-function hb_font_paint_glyph hb_font_paint_glyph a u a a u u -- void", "FUNCTION: hb_font_paint_glyph ( font glyph pfuncs paint_data palette_index foreground -- void )", "EXTERN: \"C\" void hb_font_paint_glyph( void * font, int glyph, void * pfuncs, void * paint_data, int palette_index, int foreground );", "	( font glyph pfuncs paint_data palette_index foreground -- )" );
#endif
	swigFunction( "c-function hb_font_get_glyph hb_font_get_glyph a u u a -- n", "FUNCTION: hb_font_get_glyph ( font unicode variation_selector glyph -- n )", "EXTERN: \"C\" int hb_font_get_glyph( void * font, int unicode, int variation_selector, void * glyph );", "	( font unicode variation_selector glyph -- )" );
	swigFunction( "c-function hb_font_get_extents_for_direction hb_font_get_extents_for_direction a n a -- void", "FUNCTION: hb_font_get_extents_for_direction ( font direction extents -- void )", "EXTERN: \"C\" void hb_font_get_extents_for_direction( void * font, int direction, void * extents );", "	( font direction extents -- )" );
	swigFunction( "c-function hb_font_get_glyph_advance_for_direction hb_font_get_glyph_advance_for_direction a u n a a -- void", "FUNCTION: hb_font_get_glyph_advance_for_direction ( font glyph direction x y -- void )", "EXTERN: \"C\" void hb_font_get_glyph_advance_for_direction( void * font, int glyph, int direction, void * x, void * y );", "	( font glyph direction x y -- )" );
	swigFunction( "c-function hb_font_get_glyph_advances_for_direction hb_font_get_glyph_advances_for_direction a n u a u a u -- void", "FUNCTION: hb_font_get_glyph_advances_for_direction ( font direction count first_glyph glyph_stride first_advance advance_stride -- void )", "EXTERN: \"C\" void hb_font_get_glyph_advances_for_direction( void * font, int direction, int count, void * first_glyph, int glyph_stride, void * first_advance, int advance_stride );", "	( font direction count first_glyph glyph_stride first_advance advance_stride -- )" );
	swigFunction( "c-function hb_font_get_glyph_origin_for_direction hb_font_get_glyph_origin_for_direction a u n a a -- void", "FUNCTION: hb_font_get_glyph_origin_for_direction ( font glyph direction x y -- void )", "EXTERN: \"C\" void hb_font_get_glyph_origin_for_direction( void * font, int glyph, int direction, void * x, void * y );", "	( font glyph direction x y -- )" );
	swigFunction( "c-function hb_font_add_glyph_origin_for_direction hb_font_add_glyph_origin_for_direction a u n a a -- void", "FUNCTION: hb_font_add_glyph_origin_for_direction ( font glyph direction x y -- void )", "EXTERN: \"C\" void hb_font_add_glyph_origin_for_direction( void * font, int glyph, int direction, void * x, void * y );", "	( font glyph direction x y -- )" );
	swigFunction( "c-function hb_font_subtract_glyph_origin_for_direction hb_font_subtract_glyph_origin_for_direction a u n a a -- void", "FUNCTION: hb_font_subtract_glyph_origin_for_direction ( font glyph direction x y -- void )", "EXTERN: \"C\" void hb_font_subtract_glyph_origin_for_direction( void * font, int glyph, int direction, void * x, void * y );", "	( font glyph direction x y -- )" );
	swigFunction( "c-function hb_font_get_glyph_kerning_for_direction hb_font_get_glyph_kerning_for_direction a u u n a a -- void", "FUNCTION: hb_font_get_glyph_kerning_for_direction ( font first_glyph second_glyph direction x y -- void )", "EXTERN: \"C\" void hb_font_get_glyph_kerning_for_direction( void * font, int first_glyph, int second_glyph, int direction, void * x, void * y );", "	( font first_glyph second_glyph direction x y -- )" );
	swigFunction( "c-function hb_font_get_glyph_extents_for_origin hb_font_get_glyph_extents_for_origin a u n a -- n", "FUNCTION: hb_font_get_glyph_extents_for_origin ( font glyph direction extents -- n )", "EXTERN: \"C\" int hb_font_get_glyph_extents_for_origin( void * font, int glyph, int direction, void * extents );", "	( font glyph direction extents -- )" );
	swigFunction( "c-function hb_font_get_glyph_contour_point_for_origin hb_font_get_glyph_contour_point_for_origin a u u n a a -- n", "FUNCTION: hb_font_get_glyph_contour_point_for_origin ( font glyph point_index direction x y -- n )", "EXTERN: \"C\" int hb_font_get_glyph_contour_point_for_origin( void * font, int glyph, int point_index, int direction, void * x, void * y );", "	( font glyph point_index direction x y -- )" );
	swigFunction( "c-function hb_font_glyph_to_string hb_font_glyph_to_string a u a u -- void", "FUNCTION: hb_font_glyph_to_string ( font glyph s size -- void )", "EXTERN: \"C\" void hb_font_glyph_to_string( void * font, int glyph, void * s, int size );", "	( font glyph s size -- )" );
	swigFunction( "c-function hb_font_glyph_from_string hb_font_glyph_from_string a s n a -- n", "FUNCTION: hb_font_glyph_from_string ( font s len glyph -- n )", "EXTERN: \"C\" int hb_font_glyph_from_string( void * font, char * s, int len, void * glyph );", "	( font s len glyph -- )" );
	swigFunction( "c-function hb_font_create hb_font_create a -- a", "FUNCTION: hb_font_create ( face -- a )", "EXTERN: \"C\" void * hb_font_create( void * face );", "	( face -- )" );
	swigFunction( "c-function hb_font_create_sub_font hb_font_create_sub_font a -- a", "FUNCTION: hb_font_create_sub_font ( parent -- a )", "EXTERN: \"C\" void * hb_font_create_sub_font( void * parent );", "	( parent -- )" );
	swigFunction( "c-function hb_font_get_empty hb_font_get_empty  -- a", "FUNCTION: hb_font_get_empty (  -- a )", "EXTERN: \"C\" void * hb_font_get_empty(  );", "	( -- )" );
	swigFunction( "c-function hb_font_reference hb_font_reference a -- a", "FUNCTION: hb_font_reference ( font -- a )", "EXTERN: \"C\" void * hb_font_reference( void * font );", "	( font -- )" );
	swigFunction( "c-function hb_font_destroy hb_font_destroy a -- void", "FUNCTION: hb_font_destroy ( font -- void )", "EXTERN: \"C\" void hb_font_destroy( void * font );", "	( font -- )" );
	swigFunction( "c-function hb_font_set_user_data hb_font_set_user_data a a a a n -- n", "FUNCTION: hb_font_set_user_data ( font key data destroy replace -- n )", "EXTERN: \"C\" int hb_font_set_user_data( void * font, void * key, void * data, void * destroy, int replace );", "	( font key data destroy replace -- )" );
	swigFunction( "c-function hb_font_get_user_data hb_font_get_user_data a a -- a", "FUNCTION: hb_font_get_user_data ( font key -- a )", "EXTERN: \"C\" void * hb_font_get_user_data( void * font, void * key );", "	( font key -- )" );
	swigFunction( "c-function hb_font_make_immutable hb_font_make_immutable a -- void", "FUNCTION: hb_font_make_immutable ( font -- void )", "EXTERN: \"C\" void hb_font_make_immutable( void * font );", "	( font -- )" );
	swigFunction( "c-function hb_font_is_immutable hb_font_is_immutable a -- n", "FUNCTION: hb_font_is_immutable ( font -- n )", "EXTERN: \"C\" int hb_font_is_immutable( void * font );", "	( font -- )" );
#if HB_MIN_VER(4,4)
	swigFunction( "c-function hb_font_get_serial hb_font_get_serial a -- u", "FUNCTION: hb_font_get_serial ( font -- u )", "EXTERN: \"C\" int hb_font_get_serial( void * font );", "	( font -- )" );
#endif
#if HB_MIN_VER(4,4)
	swigFunction( "c-function hb_font_changed hb_font_changed a -- void", "FUNCTION: hb_font_changed ( font -- void )", "EXTERN: \"C\" void hb_font_changed( void * font );", "	( font -- )" );
#endif
	swigFunction( "c-function hb_font_set_parent hb_font_set_parent a a -- void", "FUNCTION: hb_font_set_parent ( font parent -- void )", "EXTERN: \"C\" void hb_font_set_parent( void * font, void * parent );", "	( font parent -- )" );
	swigFunction( "c-function hb_font_get_parent hb_font_get_parent a -- a", "FUNCTION: hb_font_get_parent ( font -- a )", "EXTERN: \"C\" void * hb_font_get_parent( void * font );", "	( font -- )" );
	swigFunction( "c-function hb_font_set_face hb_font_set_face a a -- void", "FUNCTION: hb_font_set_face ( font face -- void )", "EXTERN: \"C\" void hb_font_set_face( void * font, void * face );", "	( font face -- )" );
	swigFunction( "c-function hb_font_get_face hb_font_get_face a -- a", "FUNCTION: hb_font_get_face ( font -- a )", "EXTERN: \"C\" void * hb_font_get_face( void * font );", "	( font -- )" );
	swigFunction( "c-function hb_font_set_funcs hb_font_set_funcs a a a a -- void", "FUNCTION: hb_font_set_funcs ( font klass font_data destroy -- void )", "EXTERN: \"C\" void hb_font_set_funcs( void * font, void * klass, void * font_data, void * destroy );", "	( font klass font_data destroy -- )" );
	swigFunction( "c-function hb_font_set_funcs_data hb_font_set_funcs_data a a a -- void", "FUNCTION: hb_font_set_funcs_data ( font font_data destroy -- void )", "EXTERN: \"C\" void hb_font_set_funcs_data( void * font, void * font_data, void * destroy );", "	( font font_data destroy -- )" );
	swigFunction( "c-function hb_font_set_scale hb_font_set_scale a n n -- void", "FUNCTION: hb_font_set_scale ( font x_scale y_scale -- void )", "EXTERN: \"C\" void hb_font_set_scale( void * font, int x_scale, int y_scale );", "	( font x_scale y_scale -- )" );
	swigFunction( "c-function hb_font_get_scale hb_font_get_scale a a a -- void", "FUNCTION: hb_font_get_scale ( font x_scale y_scale -- void )", "EXTERN: \"C\" void hb_font_get_scale( void * font, void * x_scale, void * y_scale );", "	( font x_scale y_scale -- )" );
	swigFunction( "c-function hb_font_set_ppem hb_font_set_ppem a u u -- void", "FUNCTION: hb_font_set_ppem ( font x_ppem y_ppem -- void )", "EXTERN: \"C\" void hb_font_set_ppem( void * font, int x_ppem, int y_ppem );", "	( font x_ppem y_ppem -- )" );
	swigFunction( "c-function hb_font_get_ppem hb_font_get_ppem a a a -- void", "FUNCTION: hb_font_get_ppem ( font x_ppem y_ppem -- void )", "EXTERN: \"C\" void hb_font_get_ppem( void * font, void * x_ppem, void * y_ppem );", "	( font x_ppem y_ppem -- )" );
	swigFunction( "c-function hb_font_set_ptem hb_font_set_ptem a r -- void", "FUNCTION: hb_font_set_ptem ( font ptem -- void )", "EXTERN: \"C\" void hb_font_set_ptem( void * font, float ptem );", "	( font ptem -- )" );
	swigFunction( "c-function hb_font_get_ptem hb_font_get_ptem a -- r", "FUNCTION: hb_font_get_ptem ( font -- r )", "EXTERN: \"C\" float hb_font_get_ptem( void * font );", "	( font -- )" );
#if HB_MIN_VER(7,0)
	swigFunction( "c-function hb_font_set_synthetic_bold hb_font_set_synthetic_bold a r r n -- void", "FUNCTION: hb_font_set_synthetic_bold ( font x_embolden y_embolden in_place -- void )", "EXTERN: \"C\" void hb_font_set_synthetic_bold( void * font, float x_embolden, float y_embolden, int in_place );", "	( font x_embolden y_embolden in_place -- )" );
#endif
#if HB_MIN_VER(7,0)
	swigFunction( "c-function hb_font_get_synthetic_bold hb_font_get_synthetic_bold a a a a -- void", "FUNCTION: hb_font_get_synthetic_bold ( font x_embolden y_embolden in_place -- void )", "EXTERN: \"C\" void hb_font_get_synthetic_bold( void * font, void * x_embolden, void * y_embolden, void * in_place );", "	( font x_embolden y_embolden in_place -- )" );
#endif
#if HB_MIN_VER(3,3)
	swigFunction( "c-function hb_font_set_synthetic_slant hb_font_set_synthetic_slant a r -- void", "FUNCTION: hb_font_set_synthetic_slant ( font slant -- void )", "EXTERN: \"C\" void hb_font_set_synthetic_slant( void * font, float slant );", "	( font slant -- )" );
#endif
#if HB_MIN_VER(3,3)
	swigFunction( "c-function hb_font_get_synthetic_slant hb_font_get_synthetic_slant a -- r", "FUNCTION: hb_font_get_synthetic_slant ( font -- r )", "EXTERN: \"C\" float hb_font_get_synthetic_slant( void * font );", "	( font -- )" );
#endif
#if HB_MIN_VER(7,0)
	swigFunction( "c-function hb_font_set_variations hb_font_set_variations a a u -- void", "FUNCTION: hb_font_set_variations ( font variations variations_length -- void )", "EXTERN: \"C\" void hb_font_set_variations( void * font, void * variations, int variations_length );", "	( font variations variations_length -- )" );
#endif
#if HB_MIN_VER(7,0)
	swigFunction( "c-function hb_font_set_variation hb_font_set_variation a u r -- void", "FUNCTION: hb_font_set_variation ( font tag value -- void )", "EXTERN: \"C\" void hb_font_set_variation( void * font, int tag, float value );", "	( font tag value -- )" );
#endif
	swigFunction( "c-function hb_font_set_var_coords_design hb_font_set_var_coords_design a a u -- void", "FUNCTION: hb_font_set_var_coords_design ( font coords coords_length -- void )", "EXTERN: \"C\" void hb_font_set_var_coords_design( void * font, void * coords, int coords_length );", "	( font coords coords_length -- )" );
#if HB_MIN_VER(3,3)
	swigFunction( "c-function hb_font_get_var_coords_design hb_font_get_var_coords_design a a -- a", "FUNCTION: hb_font_get_var_coords_design ( font length -- a )", "EXTERN: \"C\" void * hb_font_get_var_coords_design( void * font, void * length );", "	( font length -- )" );
#endif
	swigFunction( "c-function hb_font_set_var_coords_normalized hb_font_set_var_coords_normalized a a u -- void", "FUNCTION: hb_font_set_var_coords_normalized ( font coords coords_length -- void )", "EXTERN: \"C\" void hb_font_set_var_coords_normalized( void * font, void * coords, int coords_length );", "	( font coords coords_length -- )" );
	swigFunction( "c-function hb_font_get_var_coords_normalized hb_font_get_var_coords_normalized a a -- a", "FUNCTION: hb_font_get_var_coords_normalized ( font length -- a )", "EXTERN: \"C\" void * hb_font_get_var_coords_normalized( void * font, void * length );", "	( font length -- )" );
	swigFunction( "c-function hb_font_set_var_named_instance hb_font_set_var_named_instance a u -- void", "FUNCTION: hb_font_set_var_named_instance ( font instance_index -- void )", "EXTERN: \"C\" void hb_font_set_var_named_instance( void * font, int instance_index );", "	( font instance_index -- )" );
#if HB_MIN_VER(7,0)
	swigFunction( "c-function hb_font_get_var_named_instance hb_font_get_var_named_instance a -- u", "FUNCTION: hb_font_get_var_named_instance ( font -- u )", "EXTERN: \"C\" int hb_font_get_var_named_instance( void * font );", "	( font -- )" );
#endif
	swigFunction( "c-function hb_set_create hb_set_create  -- a", "FUNCTION: hb_set_create (  -- a )", "EXTERN: \"C\" void * hb_set_create(  );", "	( -- )" );
	swigFunction( "c-function hb_set_get_empty hb_set_get_empty  -- a", "FUNCTION: hb_set_get_empty (  -- a )", "EXTERN: \"C\" void * hb_set_get_empty(  );", "	( -- )" );
	swigFunction( "c-function hb_set_reference hb_set_reference a -- a", "FUNCTION: hb_set_reference ( set -- a )", "EXTERN: \"C\" void * hb_set_reference( void * set );", "	( set -- )" );
	swigFunction( "c-function hb_set_destroy hb_set_destroy a -- void", "FUNCTION: hb_set_destroy ( set -- void )", "EXTERN: \"C\" void hb_set_destroy( void * set );", "	( set -- )" );
	swigFunction( "c-function hb_set_set_user_data hb_set_set_user_data a a a a n -- n", "FUNCTION: hb_set_set_user_data ( set key data destroy replace -- n )", "EXTERN: \"C\" int hb_set_set_user_data( void * set, void * key, void * data, void * destroy, int replace );", "	( set key data destroy replace -- )" );
	swigFunction( "c-function hb_set_get_user_data hb_set_get_user_data a a -- a", "FUNCTION: hb_set_get_user_data ( set key -- a )", "EXTERN: \"C\" void * hb_set_get_user_data( void * set, void * key );", "	( set key -- )" );
	swigFunction( "c-function hb_set_allocation_successful hb_set_allocation_successful a -- n", "FUNCTION: hb_set_allocation_successful ( set -- n )", "EXTERN: \"C\" int hb_set_allocation_successful( void * set );", "	( set -- )" );
	swigFunction( "c-function hb_set_copy hb_set_copy a -- a", "FUNCTION: hb_set_copy ( set -- a )", "EXTERN: \"C\" void * hb_set_copy( void * set );", "	( set -- )" );
	swigFunction( "c-function hb_set_clear hb_set_clear a -- void", "FUNCTION: hb_set_clear ( set -- void )", "EXTERN: \"C\" void hb_set_clear( void * set );", "	( set -- )" );
	swigFunction( "c-function hb_set_is_empty hb_set_is_empty a -- n", "FUNCTION: hb_set_is_empty ( set -- n )", "EXTERN: \"C\" int hb_set_is_empty( void * set );", "	( set -- )" );
#if HB_MIN_VER(3,0)
	swigFunction( "c-function hb_set_invert hb_set_invert a -- void", "FUNCTION: hb_set_invert ( set -- void )", "EXTERN: \"C\" void hb_set_invert( void * set );", "	( set -- )" );
#endif
#if HB_MIN_VER(7,0)
	swigFunction( "c-function hb_set_is_inverted hb_set_is_inverted a -- n", "FUNCTION: hb_set_is_inverted ( set -- n )", "EXTERN: \"C\" int hb_set_is_inverted( void * set );", "	( set -- )" );
#endif
	swigFunction( "c-function hb_set_has hb_set_has a u -- n", "FUNCTION: hb_set_has ( set codepoint -- n )", "EXTERN: \"C\" int hb_set_has( void * set, int codepoint );", "	( set codepoint -- )" );
	swigFunction( "c-function hb_set_add hb_set_add a u -- void", "FUNCTION: hb_set_add ( set codepoint -- void )", "EXTERN: \"C\" void hb_set_add( void * set, int codepoint );", "	( set codepoint -- )" );
	swigFunction( "c-function hb_set_add_range hb_set_add_range a u u -- void", "FUNCTION: hb_set_add_range ( set first last -- void )", "EXTERN: \"C\" void hb_set_add_range( void * set, int first, int last );", "	( set first last -- )" );
#if HB_MIN_VER(4,1)
	swigFunction( "c-function hb_set_add_sorted_array hb_set_add_sorted_array a a u -- void", "FUNCTION: hb_set_add_sorted_array ( set sorted_codepoints num_codepoints -- void )", "EXTERN: \"C\" void hb_set_add_sorted_array( void * set, void * sorted_codepoints, int num_codepoints );", "	( set sorted_codepoints num_codepoints -- )" );
#endif
	swigFunction( "c-function hb_set_del hb_set_del a u -- void", "FUNCTION: hb_set_del ( set codepoint -- void )", "EXTERN: \"C\" void hb_set_del( void * set, int codepoint );", "	( set codepoint -- )" );
	swigFunction( "c-function hb_set_del_range hb_set_del_range a u u -- void", "FUNCTION: hb_set_del_range ( set first last -- void )", "EXTERN: \"C\" void hb_set_del_range( void * set, int first, int last );", "	( set first last -- )" );
	swigFunction( "c-function hb_set_is_equal hb_set_is_equal a a -- n", "FUNCTION: hb_set_is_equal ( set other -- n )", "EXTERN: \"C\" int hb_set_is_equal( void * set, void * other );", "	( set other -- )" );
#if HB_MIN_VER(4,4)
	swigFunction( "c-function hb_set_hash hb_set_hash a -- u", "FUNCTION: hb_set_hash ( set -- u )", "EXTERN: \"C\" int hb_set_hash( void * set );", "	( set -- )" );
#endif
	swigFunction( "c-function hb_set_is_subset hb_set_is_subset a a -- n", "FUNCTION: hb_set_is_subset ( set larger_set -- n )", "EXTERN: \"C\" int hb_set_is_subset( void * set, void * larger_set );", "	( set larger_set -- )" );
	swigFunction( "c-function hb_set_set hb_set_set a a -- void", "FUNCTION: hb_set_set ( set other -- void )", "EXTERN: \"C\" void hb_set_set( void * set, void * other );", "	( set other -- )" );
	swigFunction( "c-function hb_set_union hb_set_union a a -- void", "FUNCTION: hb_set_union ( set other -- void )", "EXTERN: \"C\" void hb_set_union( void * set, void * other );", "	( set other -- )" );
	swigFunction( "c-function hb_set_intersect hb_set_intersect a a -- void", "FUNCTION: hb_set_intersect ( set other -- void )", "EXTERN: \"C\" void hb_set_intersect( void * set, void * other );", "	( set other -- )" );
	swigFunction( "c-function hb_set_subtract hb_set_subtract a a -- void", "FUNCTION: hb_set_subtract ( set other -- void )", "EXTERN: \"C\" void hb_set_subtract( void * set, void * other );", "	( set other -- )" );
	swigFunction( "c-function hb_set_symmetric_difference hb_set_symmetric_difference a a -- void", "FUNCTION: hb_set_symmetric_difference ( set other -- void )", "EXTERN: \"C\" void hb_set_symmetric_difference( void * set, void * other );", "	( set other -- )" );
	swigFunction( "c-function hb_set_get_population hb_set_get_population a -- u", "FUNCTION: hb_set_get_population ( set -- u )", "EXTERN: \"C\" int hb_set_get_population( void * set );", "	( set -- )" );
	swigFunction( "c-function hb_set_get_min hb_set_get_min a -- u", "FUNCTION: hb_set_get_min ( set -- u )", "EXTERN: \"C\" int hb_set_get_min( void * set );", "	( set -- )" );
	swigFunction( "c-function hb_set_get_max hb_set_get_max a -- u", "FUNCTION: hb_set_get_max ( set -- u )", "EXTERN: \"C\" int hb_set_get_max( void * set );", "	( set -- )" );
	swigFunction( "c-function hb_set_next hb_set_next a a -- n", "FUNCTION: hb_set_next ( set codepoint -- n )", "EXTERN: \"C\" int hb_set_next( void * set, void * codepoint );", "	( set codepoint -- )" );
	swigFunction( "c-function hb_set_previous hb_set_previous a a -- n", "FUNCTION: hb_set_previous ( set codepoint -- n )", "EXTERN: \"C\" int hb_set_previous( void * set, void * codepoint );", "	( set codepoint -- )" );
	swigFunction( "c-function hb_set_next_range hb_set_next_range a a a -- n", "FUNCTION: hb_set_next_range ( set first last -- n )", "EXTERN: \"C\" int hb_set_next_range( void * set, void * first, void * last );", "	( set first last -- )" );
	swigFunction( "c-function hb_set_previous_range hb_set_previous_range a a a -- n", "FUNCTION: hb_set_previous_range ( set first last -- n )", "EXTERN: \"C\" int hb_set_previous_range( void * set, void * first, void * last );", "	( set first last -- )" );
#if HB_MIN_VER(4,2)
	swigFunction( "c-function hb_set_next_many hb_set_next_many a u a u -- u", "FUNCTION: hb_set_next_many ( set codepoint out size -- u )", "EXTERN: \"C\" int hb_set_next_many( void * set, int codepoint, void * out, int size );", "	( set codepoint out size -- )" );
#endif
	swigFunction( "c-function hb_shape hb_shape a a a u -- void", "FUNCTION: hb_shape ( font buffer features num_features -- void )", "EXTERN: \"C\" void hb_shape( void * font, void * buffer, void * features, int num_features );", "	( font buffer features num_features -- )" );
	swigFunction( "c-function hb_shape_full hb_shape_full a a a u a -- n", "FUNCTION: hb_shape_full ( font buffer features num_features shaper_list -- n )", "EXTERN: \"C\" int hb_shape_full( void * font, void * buffer, void * features, int num_features, void * shaper_list );", "	( font buffer features num_features shaper_list -- )" );
#if HB_MIN_VER(7,0)
	swigFunction( "c-function hb_shape_justify hb_shape_justify a a a u a r r a a a -- n", "FUNCTION: hb_shape_justify ( font buffer features num_features shaper_list min_target_advance max_target_advance advance var_tag var_value -- n )", "EXTERN: \"C\" int hb_shape_justify( void * font, void * buffer, void * features, int num_features, void * shaper_list, float min_target_advance, float max_target_advance, void * advance, void * var_tag, void * var_value );", "	( font buffer features num_features shaper_list min_target_advance max_target_advance advance var_tag var_value -- )" );
#endif
	swigFunction( "c-function hb_shape_list_shapers hb_shape_list_shapers  -- a", "FUNCTION: hb_shape_list_shapers (  -- a )", "EXTERN: \"C\" void * hb_shape_list_shapers(  );", "	( -- )" );
	swigFunction( "c-function hb_shape_plan_create hb_shape_plan_create a a a u a -- a", "FUNCTION: hb_shape_plan_create ( face props user_features num_user_features shaper_list -- a )", "EXTERN: \"C\" void * hb_shape_plan_create( void * face, void * props, void * user_features, int num_user_features, void * shaper_list );", "	( face props user_features num_user_features shaper_list -- )" );
	swigFunction( "c-function hb_shape_plan_create_cached hb_shape_plan_create_cached a a a u a -- a", "FUNCTION: hb_shape_plan_create_cached ( face props user_features num_user_features shaper_list -- a )", "EXTERN: \"C\" void * hb_shape_plan_create_cached( void * face, void * props, void * user_features, int num_user_features, void * shaper_list );", "	( face props user_features num_user_features shaper_list -- )" );
	swigFunction( "c-function hb_shape_plan_create2 hb_shape_plan_create2 a a a u a u a -- a", "FUNCTION: hb_shape_plan_create2 ( face props user_features num_user_features coords num_coords shaper_list -- a )", "EXTERN: \"C\" void * hb_shape_plan_create2( void * face, void * props, void * user_features, int num_user_features, void * coords, int num_coords, void * shaper_list );", "	( face props user_features num_user_features coords num_coords shaper_list -- )" );
	swigFunction( "c-function hb_shape_plan_create_cached2 hb_shape_plan_create_cached2 a a a u a u a -- a", "FUNCTION: hb_shape_plan_create_cached2 ( face props user_features num_user_features coords num_coords shaper_list -- a )", "EXTERN: \"C\" void * hb_shape_plan_create_cached2( void * face, void * props, void * user_features, int num_user_features, void * coords, int num_coords, void * shaper_list );", "	( face props user_features num_user_features coords num_coords shaper_list -- )" );
	swigFunction( "c-function hb_shape_plan_get_empty hb_shape_plan_get_empty  -- a", "FUNCTION: hb_shape_plan_get_empty (  -- a )", "EXTERN: \"C\" void * hb_shape_plan_get_empty(  );", "	( -- )" );
	swigFunction( "c-function hb_shape_plan_reference hb_shape_plan_reference a -- a", "FUNCTION: hb_shape_plan_reference ( shape_plan -- a )", "EXTERN: \"C\" void * hb_shape_plan_reference( void * shape_plan );", "	( shape_plan -- )" );
	swigFunction( "c-function hb_shape_plan_destroy hb_shape_plan_destroy a -- void", "FUNCTION: hb_shape_plan_destroy ( shape_plan -- void )", "EXTERN: \"C\" void hb_shape_plan_destroy( void * shape_plan );", "	( shape_plan -- )" );
	swigFunction( "c-function hb_shape_plan_set_user_data hb_shape_plan_set_user_data a a a a n -- n", "FUNCTION: hb_shape_plan_set_user_data ( shape_plan key data destroy replace -- n )", "EXTERN: \"C\" int hb_shape_plan_set_user_data( void * shape_plan, void * key, void * data, void * destroy, int replace );", "	( shape_plan key data destroy replace -- )" );
	swigFunction( "c-function hb_shape_plan_get_user_data hb_shape_plan_get_user_data a a -- a", "FUNCTION: hb_shape_plan_get_user_data ( shape_plan key -- a )", "EXTERN: \"C\" void * hb_shape_plan_get_user_data( void * shape_plan, void * key );", "	( shape_plan key -- )" );
	swigFunction( "c-function hb_shape_plan_execute hb_shape_plan_execute a a a a u -- n", "FUNCTION: hb_shape_plan_execute ( shape_plan font buffer features num_features -- n )", "EXTERN: \"C\" int hb_shape_plan_execute( void * shape_plan, void * font, void * buffer, void * features, int num_features );", "	( shape_plan font buffer features num_features -- )" );
	swigFunction( "c-function hb_shape_plan_get_shaper hb_shape_plan_get_shaper a -- s", "FUNCTION: hb_shape_plan_get_shaper ( shape_plan -- s )", "EXTERN: \"C\" char * hb_shape_plan_get_shaper( void * shape_plan );", "	( shape_plan -- )" );
	swigFunction( "c-function hb_unicode_funcs_get_default hb_unicode_funcs_get_default  -- a", "FUNCTION: hb_unicode_funcs_get_default (  -- a )", "EXTERN: \"C\" void * hb_unicode_funcs_get_default(  );", "	( -- )" );
	swigFunction( "c-function hb_unicode_funcs_create hb_unicode_funcs_create a -- a", "FUNCTION: hb_unicode_funcs_create ( parent -- a )", "EXTERN: \"C\" void * hb_unicode_funcs_create( void * parent );", "	( parent -- )" );
	swigFunction( "c-function hb_unicode_funcs_get_empty hb_unicode_funcs_get_empty  -- a", "FUNCTION: hb_unicode_funcs_get_empty (  -- a )", "EXTERN: \"C\" void * hb_unicode_funcs_get_empty(  );", "	( -- )" );
	swigFunction( "c-function hb_unicode_funcs_reference hb_unicode_funcs_reference a -- a", "FUNCTION: hb_unicode_funcs_reference ( ufuncs -- a )", "EXTERN: \"C\" void * hb_unicode_funcs_reference( void * ufuncs );", "	( ufuncs -- )" );
	swigFunction( "c-function hb_unicode_funcs_destroy hb_unicode_funcs_destroy a -- void", "FUNCTION: hb_unicode_funcs_destroy ( ufuncs -- void )", "EXTERN: \"C\" void hb_unicode_funcs_destroy( void * ufuncs );", "	( ufuncs -- )" );
	swigFunction( "c-function hb_unicode_funcs_set_user_data hb_unicode_funcs_set_user_data a a a a n -- n", "FUNCTION: hb_unicode_funcs_set_user_data ( ufuncs key data destroy replace -- n )", "EXTERN: \"C\" int hb_unicode_funcs_set_user_data( void * ufuncs, void * key, void * data, void * destroy, int replace );", "	( ufuncs key data destroy replace -- )" );
	swigFunction( "c-function hb_unicode_funcs_get_user_data hb_unicode_funcs_get_user_data a a -- a", "FUNCTION: hb_unicode_funcs_get_user_data ( ufuncs key -- a )", "EXTERN: \"C\" void * hb_unicode_funcs_get_user_data( void * ufuncs, void * key );", "	( ufuncs key -- )" );
	swigFunction( "c-function hb_unicode_funcs_make_immutable hb_unicode_funcs_make_immutable a -- void", "FUNCTION: hb_unicode_funcs_make_immutable ( ufuncs -- void )", "EXTERN: \"C\" void hb_unicode_funcs_make_immutable( void * ufuncs );", "	( ufuncs -- )" );
	swigFunction( "c-function hb_unicode_funcs_is_immutable hb_unicode_funcs_is_immutable a -- n", "FUNCTION: hb_unicode_funcs_is_immutable ( ufuncs -- n )", "EXTERN: \"C\" int hb_unicode_funcs_is_immutable( void * ufuncs );", "	( ufuncs -- )" );
	swigFunction( "c-function hb_unicode_funcs_get_parent hb_unicode_funcs_get_parent a -- a", "FUNCTION: hb_unicode_funcs_get_parent ( ufuncs -- a )", "EXTERN: \"C\" void * hb_unicode_funcs_get_parent( void * ufuncs );", "	( ufuncs -- )" );
	swigFunction( "c-function hb_unicode_funcs_set_combining_class_func hb_unicode_funcs_set_combining_class_func a a a a -- void", "FUNCTION: hb_unicode_funcs_set_combining_class_func ( ufuncs func user_data destroy -- void )", "EXTERN: \"C\" void hb_unicode_funcs_set_combining_class_func( void * ufuncs, void * func, void * user_data, void * destroy );", "	( ufuncs func user_data destroy -- )" );
	swigFunction( "c-function hb_unicode_funcs_set_general_category_func hb_unicode_funcs_set_general_category_func a a a a -- void", "FUNCTION: hb_unicode_funcs_set_general_category_func ( ufuncs func user_data destroy -- void )", "EXTERN: \"C\" void hb_unicode_funcs_set_general_category_func( void * ufuncs, void * func, void * user_data, void * destroy );", "	( ufuncs func user_data destroy -- )" );
	swigFunction( "c-function hb_unicode_funcs_set_mirroring_func hb_unicode_funcs_set_mirroring_func a a a a -- void", "FUNCTION: hb_unicode_funcs_set_mirroring_func ( ufuncs func user_data destroy -- void )", "EXTERN: \"C\" void hb_unicode_funcs_set_mirroring_func( void * ufuncs, void * func, void * user_data, void * destroy );", "	( ufuncs func user_data destroy -- )" );
	swigFunction( "c-function hb_unicode_funcs_set_script_func hb_unicode_funcs_set_script_func a a a a -- void", "FUNCTION: hb_unicode_funcs_set_script_func ( ufuncs func user_data destroy -- void )", "EXTERN: \"C\" void hb_unicode_funcs_set_script_func( void * ufuncs, void * func, void * user_data, void * destroy );", "	( ufuncs func user_data destroy -- )" );
	swigFunction( "c-function hb_unicode_funcs_set_compose_func hb_unicode_funcs_set_compose_func a a a a -- void", "FUNCTION: hb_unicode_funcs_set_compose_func ( ufuncs func user_data destroy -- void )", "EXTERN: \"C\" void hb_unicode_funcs_set_compose_func( void * ufuncs, void * func, void * user_data, void * destroy );", "	( ufuncs func user_data destroy -- )" );
	swigFunction( "c-function hb_unicode_funcs_set_decompose_func hb_unicode_funcs_set_decompose_func a a a a -- void", "FUNCTION: hb_unicode_funcs_set_decompose_func ( ufuncs func user_data destroy -- void )", "EXTERN: \"C\" void hb_unicode_funcs_set_decompose_func( void * ufuncs, void * func, void * user_data, void * destroy );", "	( ufuncs func user_data destroy -- )" );
	swigFunction( "c-function hb_unicode_combining_class hb_unicode_combining_class a u -- n", "FUNCTION: hb_unicode_combining_class ( ufuncs unicode -- n )", "EXTERN: \"C\" int hb_unicode_combining_class( void * ufuncs, int unicode );", "	( ufuncs unicode -- )" );
	swigFunction( "c-function hb_unicode_general_category hb_unicode_general_category a u -- n", "FUNCTION: hb_unicode_general_category ( ufuncs unicode -- n )", "EXTERN: \"C\" int hb_unicode_general_category( void * ufuncs, int unicode );", "	( ufuncs unicode -- )" );
	swigFunction( "c-function hb_unicode_mirroring hb_unicode_mirroring a u -- u", "FUNCTION: hb_unicode_mirroring ( ufuncs unicode -- u )", "EXTERN: \"C\" int hb_unicode_mirroring( void * ufuncs, int unicode );", "	( ufuncs unicode -- )" );
	swigFunction( "c-function hb_unicode_script hb_unicode_script a u -- n", "FUNCTION: hb_unicode_script ( ufuncs unicode -- n )", "EXTERN: \"C\" int hb_unicode_script( void * ufuncs, int unicode );", "	( ufuncs unicode -- )" );
	swigFunction( "c-function hb_unicode_compose hb_unicode_compose a u u a -- n", "FUNCTION: hb_unicode_compose ( ufuncs a b ab -- n )", "EXTERN: \"C\" int hb_unicode_compose( void * ufuncs, int a, int b, void * ab );", "	( ufuncs a b ab -- )" );
	swigFunction( "c-function hb_unicode_decompose hb_unicode_decompose a u a a -- n", "FUNCTION: hb_unicode_decompose ( ufuncs ab a b -- n )", "EXTERN: \"C\" int hb_unicode_decompose( void * ufuncs, int ab, void * a, void * b );", "	( ufuncs ab a b -- )" );
	swigFunction( "c-function hb_version hb_version a a a -- void", "FUNCTION: hb_version ( major minor micro -- void )", "EXTERN: \"C\" void hb_version( void * major, void * minor, void * micro );", "	( major minor micro -- )" );
	swigFunction( "c-function hb_version_string hb_version_string  -- s", "FUNCTION: hb_version_string (  -- s )", "EXTERN: \"C\" char * hb_version_string(  );", "	( -- )" );
	swigFunction( "c-function hb_version_atleast hb_version_atleast u u u -- n", "FUNCTION: hb_version_atleast ( major minor micro -- n )", "EXTERN: \"C\" int hb_version_atleast( int major, int minor, int micro );", "	( major minor micro -- )" );
	swigFunction( "c-function hb_ft_face_create hb_ft_face_create a a -- a", "FUNCTION: hb_ft_face_create ( ft_face destroy -- a )", "EXTERN: \"C\" void * hb_ft_face_create( void * ft_face, void * destroy );", "	( ft_face destroy -- )" );
	swigFunction( "c-function hb_ft_face_create_cached hb_ft_face_create_cached a -- a", "FUNCTION: hb_ft_face_create_cached ( ft_face -- a )", "EXTERN: \"C\" void * hb_ft_face_create_cached( void * ft_face );", "	( ft_face -- )" );
	swigFunction( "c-function hb_ft_face_create_referenced hb_ft_face_create_referenced a -- a", "FUNCTION: hb_ft_face_create_referenced ( ft_face -- a )", "EXTERN: \"C\" void * hb_ft_face_create_referenced( void * ft_face );", "	( ft_face -- )" );
	swigFunction( "c-function hb_ft_font_create hb_ft_font_create a a -- a", "FUNCTION: hb_ft_font_create ( ft_face destroy -- a )", "EXTERN: \"C\" void * hb_ft_font_create( void * ft_face, void * destroy );", "	( ft_face destroy -- )" );
	swigFunction( "c-function hb_ft_font_create_referenced hb_ft_font_create_referenced a -- a", "FUNCTION: hb_ft_font_create_referenced ( ft_face -- a )", "EXTERN: \"C\" void * hb_ft_font_create_referenced( void * ft_face );", "	( ft_face -- )" );
	swigFunction( "c-function hb_ft_font_get_face hb_ft_font_get_face a -- a", "FUNCTION: hb_ft_font_get_face ( font -- a )", "EXTERN: \"C\" void * hb_ft_font_get_face( void * font );", "	( font -- )" );
	swigFunction( "c-function hb_ft_font_lock_face hb_ft_font_lock_face a -- a", "FUNCTION: hb_ft_font_lock_face ( font -- a )", "EXTERN: \"C\" void * hb_ft_font_lock_face( void * font );", "	( font -- )" );
	swigFunction( "c-function hb_ft_font_unlock_face hb_ft_font_unlock_face a -- void", "FUNCTION: hb_ft_font_unlock_face ( font -- void )", "EXTERN: \"C\" void hb_ft_font_unlock_face( void * font );", "	( font -- )" );
	swigFunction( "c-function hb_ft_font_set_load_flags hb_ft_font_set_load_flags a n -- void", "FUNCTION: hb_ft_font_set_load_flags ( font load_flags -- void )", "EXTERN: \"C\" void hb_ft_font_set_load_flags( void * font, int load_flags );", "	( font load_flags -- )" );
	swigFunction( "c-function hb_ft_font_get_load_flags hb_ft_font_get_load_flags a -- n", "FUNCTION: hb_ft_font_get_load_flags ( font -- n )", "EXTERN: \"C\" int hb_ft_font_get_load_flags( void * font );", "	( font -- )" );
	swigFunction( "c-function hb_ft_font_changed hb_ft_font_changed a -- void", "FUNCTION: hb_ft_font_changed ( font -- void )", "EXTERN: \"C\" void hb_ft_font_changed( void * font );", "	( font -- )" );
#if HB_MIN_VER(4,4)
	swigFunction( "c-function hb_ft_hb_font_changed hb_ft_hb_font_changed a -- n", "FUNCTION: hb_ft_hb_font_changed ( font -- n )", "EXTERN: \"C\" int hb_ft_hb_font_changed( void * font );", "	( font -- )" );
#endif
	swigFunction( "c-function hb_ft_font_set_funcs hb_ft_font_set_funcs a -- void", "FUNCTION: hb_ft_font_set_funcs ( font -- void )", "EXTERN: \"C\" void hb_ft_font_set_funcs( void * font );", "	( font -- )" );

	swigNewline();

	swigComment("----===< postfix >===-----\n");

	swigPrint( "end-c-library", "( none )", "( none )" );
	
	return 0;
} /* end of main */



