/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 3.0.9
 *
 * This file is not intended to be easily readable and contains a number of
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG
 * interface file instead.
 * ----------------------------------------------------------------------------- */
#include <stdio.h>
#include <string.h>
#include <stddef.h>

// Do not edit below this line
// end-of-default-includes


#define GLX_GLXEXT_PROTOTYPES
#include <GL/glx.h>

typedef enum{ NONE = -1, GFORTH = 0, SWIFTFORTH, VFX } SwigTargetSystem;
SwigTargetSystem swigTargetSystem = NONE;

unsigned char swigPrintStackComments = 1;

/* comments */
void swigNewline()
{
	printf( "\n" );
}

void swigComment( char *comment )
{
	printf( "\\ %s", comment );
}

/* generic print */
void swigPrint( char* gforth, char *swiftForth, char *vfx )
{
	if( swigTargetSystem == GFORTH )
		printf( "%s", gforth );
	else if( swigTargetSystem == SWIFTFORTH )
		printf( "%s", swiftForth );
	else if( swigTargetSystem == VFX )
		printf( "%s", vfx );
	printf( "\n" );
}
void swigPrintSystem( SwigTargetSystem targetSystem, char *text )
{
	if( targetSystem == swigTargetSystem )
	    printf( "%s\n", text );
}

/* constants */
void swigIntConstant( long constant, char *name )
{
	printf( "#%ld\tconstant %s\n", constant, name );
}

void swigUnsignedIntConstant( unsigned long constant, char *name )
{
	printf( "#%lu\tconstant %s\n", constant, name );
}

void swigLongConstant( long long constant, char *name )
{
	printf( "#%lld.\t2constant %s\n", constant, name );
}

void swigUnsignedLongConstant( unsigned long long constant, char *name )
{
	printf( "#%llu.\t2constant %s\n", constant, name );
}

void swigFloatConstant( double constant, char *name )
{
	char buffer[128];
	sprintf( buffer, "%f", constant );

	/* if the constant contains no exponent, add one */
	char *s;
	for( s = buffer; *s != 0; s++ )
		if( *s == 'e' || *s == 'E' )
			break;

	/* exponent found */
	if( *s != 0 )
		printf( "%s\tfconstant %s\n", buffer, name );
	/* not found */
	else
		printf( "%se0\tfconstant %s\n", buffer, name );
}

void swigStringConstant( char* constant, char *name )
{
	char c;
	printf( ": %s s\\\" ", name );
	while(( c = *constant++ ))
	{
		switch(c)
		{
			case '\b': printf( "\\b" ); break;
			case '\n': printf( "\\n" ); break;
			case '\f': printf( "\\f" ); break;
			case '\r': printf( "\\r" ); break;
			case '\t': printf( "\\t" ); break;
			case '"' : printf( "\\q" ); break;
			default:
				if(c < 0x20)
					printf("\\x%02x", c);
				else
					printf("%c", c); break;
		}
	}
	printf(	"\" ;\n" );
}

/* structs */
void swigStructField( char *name, size_t offset, size_t size )
{
	printf( "\tdrop %zu %zu +field %s\n", offset, size, name );
}

/* functions */
void swigFunction( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	if( swigTargetSystem == GFORTH )
		printf( "%s", gforth );
	else if( swigTargetSystem == SWIFTFORTH )
		printf( "%s", swiftForth );
	else if( swigTargetSystem == VFX )
		printf( "%s", vfx );

	if( swigPrintStackComments )
		printf( "%s", stackComment );

	printf( "\n" );
}

/* function pointers */
void swigFunctionPointer( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	swigFunction( gforth, swiftForth, vfx, stackComment );
}

/* callbacks */
void swigCallback( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	swigFunction( gforth, swiftForth, vfx, stackComment );
}

void swigUsage( char **argv )
{
	fprintf( stderr, "Usage: %s [-gforth|-swiftforth|-vfx]\n", argv[0] );
}

int main( int argc, char **argv )
{
	int i;

	/* check arguments */
	for( i = 1; i < argc; i++ )
		if( strcmp( argv[i], "-gforth" ) == 0 )
			swigTargetSystem = GFORTH;
		else if( strcmp( argv[i], "-swiftforth" ) == 0 )
			swigTargetSystem = SWIFTFORTH;
		else if( strcmp( argv[i], "-vfx" ) == 0 )
			swigTargetSystem = VFX;

	if( swigTargetSystem == NONE )
	{
		fprintf( stderr, "Error: no target system specified\n" );
		swigUsage( argv );
		return 1;
	}

	/* primer */
	printf( "\\ This file has been generated using SWIG and fsi,\n"
		"\\ and is already platform dependent, search for the corresponding\n"
		"\\ fsi-file to compile it where no one has compiled it before ;)\n"
		"\\ Forth systems have their own own dynamic loader and don't need addional C-Code.\n"
		"\\ That's why this file will just print normal forth-code once compiled\n"
		"\\ and can be used directly with include or require.\n"
		"\\ As all comments are stripped during the compilation, please\n"
		"\\ insert the copyright notice of the original file here.\n"
	);



	swigNewline();

	swigComment("----===< prefix >===-----\n");

	swigPrint( "c-library glx\ns\" GLX\" add-lib\n\\c #define GLX_GLXEXT_PROTOTYPES\n\\c #include <GL/glx.h>", "( none )", "( none )" );

	swigNewline();

	swigComment("----===< int constants >===-----\n");
	#ifdef GLX_VERSION_1_1
		swigIntConstant( GLX_VERSION_1_1, "GLX_VERSION_1_1" );
	#endif
	#ifdef GLX_VERSION_1_2
		swigIntConstant( GLX_VERSION_1_2, "GLX_VERSION_1_2" );
	#endif
	#ifdef GLX_VERSION_1_3
		swigIntConstant( GLX_VERSION_1_3, "GLX_VERSION_1_3" );
	#endif
	#ifdef GLX_VERSION_1_4
		swigIntConstant( GLX_VERSION_1_4, "GLX_VERSION_1_4" );
	#endif
	#ifdef GLX_USE_GL
		swigIntConstant( GLX_USE_GL, "GLX_USE_GL" );
	#endif
	#ifdef GLX_BUFFER_SIZE
		swigIntConstant( GLX_BUFFER_SIZE, "GLX_BUFFER_SIZE" );
	#endif
	#ifdef GLX_LEVEL
		swigIntConstant( GLX_LEVEL, "GLX_LEVEL" );
	#endif
	#ifdef GLX_RGBA
		swigIntConstant( GLX_RGBA, "GLX_RGBA" );
	#endif
	#ifdef GLX_DOUBLEBUFFER
		swigIntConstant( GLX_DOUBLEBUFFER, "GLX_DOUBLEBUFFER" );
	#endif
	#ifdef GLX_STEREO
		swigIntConstant( GLX_STEREO, "GLX_STEREO" );
	#endif
	#ifdef GLX_AUX_BUFFERS
		swigIntConstant( GLX_AUX_BUFFERS, "GLX_AUX_BUFFERS" );
	#endif
	#ifdef GLX_RED_SIZE
		swigIntConstant( GLX_RED_SIZE, "GLX_RED_SIZE" );
	#endif
	#ifdef GLX_GREEN_SIZE
		swigIntConstant( GLX_GREEN_SIZE, "GLX_GREEN_SIZE" );
	#endif
	#ifdef GLX_BLUE_SIZE
		swigIntConstant( GLX_BLUE_SIZE, "GLX_BLUE_SIZE" );
	#endif
	#ifdef GLX_ALPHA_SIZE
		swigIntConstant( GLX_ALPHA_SIZE, "GLX_ALPHA_SIZE" );
	#endif
	#ifdef GLX_DEPTH_SIZE
		swigIntConstant( GLX_DEPTH_SIZE, "GLX_DEPTH_SIZE" );
	#endif
	#ifdef GLX_STENCIL_SIZE
		swigIntConstant( GLX_STENCIL_SIZE, "GLX_STENCIL_SIZE" );
	#endif
	#ifdef GLX_ACCUM_RED_SIZE
		swigIntConstant( GLX_ACCUM_RED_SIZE, "GLX_ACCUM_RED_SIZE" );
	#endif
	#ifdef GLX_ACCUM_GREEN_SIZE
		swigIntConstant( GLX_ACCUM_GREEN_SIZE, "GLX_ACCUM_GREEN_SIZE" );
	#endif
	#ifdef GLX_ACCUM_BLUE_SIZE
		swigIntConstant( GLX_ACCUM_BLUE_SIZE, "GLX_ACCUM_BLUE_SIZE" );
	#endif
	#ifdef GLX_ACCUM_ALPHA_SIZE
		swigIntConstant( GLX_ACCUM_ALPHA_SIZE, "GLX_ACCUM_ALPHA_SIZE" );
	#endif
	#ifdef GLX_BAD_SCREEN
		swigIntConstant( GLX_BAD_SCREEN, "GLX_BAD_SCREEN" );
	#endif
	#ifdef GLX_BAD_ATTRIBUTE
		swigIntConstant( GLX_BAD_ATTRIBUTE, "GLX_BAD_ATTRIBUTE" );
	#endif
	#ifdef GLX_NO_EXTENSION
		swigIntConstant( GLX_NO_EXTENSION, "GLX_NO_EXTENSION" );
	#endif
	#ifdef GLX_BAD_VISUAL
		swigIntConstant( GLX_BAD_VISUAL, "GLX_BAD_VISUAL" );
	#endif
	#ifdef GLX_BAD_CONTEXT
		swigIntConstant( GLX_BAD_CONTEXT, "GLX_BAD_CONTEXT" );
	#endif
	#ifdef GLX_BAD_VALUE
		swigIntConstant( GLX_BAD_VALUE, "GLX_BAD_VALUE" );
	#endif
	#ifdef GLX_BAD_ENUM
		swigIntConstant( GLX_BAD_ENUM, "GLX_BAD_ENUM" );
	#endif
	#ifdef GLX_VENDOR
		swigIntConstant( GLX_VENDOR, "GLX_VENDOR" );
	#endif
	#ifdef GLX_VERSION
		swigIntConstant( GLX_VERSION, "GLX_VERSION" );
	#endif
	#ifdef GLX_EXTENSIONS
		swigIntConstant( GLX_EXTENSIONS, "GLX_EXTENSIONS" );
	#endif
	#ifdef GLX_CONFIG_CAVEAT
		swigIntConstant( GLX_CONFIG_CAVEAT, "GLX_CONFIG_CAVEAT" );
	#endif
	#ifdef GLX_DONT_CARE
		swigIntConstant( GLX_DONT_CARE, "GLX_DONT_CARE" );
	#endif
	#ifdef GLX_X_VISUAL_TYPE
		swigIntConstant( GLX_X_VISUAL_TYPE, "GLX_X_VISUAL_TYPE" );
	#endif
	#ifdef GLX_TRANSPARENT_TYPE
		swigIntConstant( GLX_TRANSPARENT_TYPE, "GLX_TRANSPARENT_TYPE" );
	#endif
	#ifdef GLX_TRANSPARENT_INDEX_VALUE
		swigIntConstant( GLX_TRANSPARENT_INDEX_VALUE, "GLX_TRANSPARENT_INDEX_VALUE" );
	#endif
	#ifdef GLX_TRANSPARENT_RED_VALUE
		swigIntConstant( GLX_TRANSPARENT_RED_VALUE, "GLX_TRANSPARENT_RED_VALUE" );
	#endif
	#ifdef GLX_TRANSPARENT_GREEN_VALUE
		swigIntConstant( GLX_TRANSPARENT_GREEN_VALUE, "GLX_TRANSPARENT_GREEN_VALUE" );
	#endif
	#ifdef GLX_TRANSPARENT_BLUE_VALUE
		swigIntConstant( GLX_TRANSPARENT_BLUE_VALUE, "GLX_TRANSPARENT_BLUE_VALUE" );
	#endif
	#ifdef GLX_TRANSPARENT_ALPHA_VALUE
		swigIntConstant( GLX_TRANSPARENT_ALPHA_VALUE, "GLX_TRANSPARENT_ALPHA_VALUE" );
	#endif
	#ifdef GLX_WINDOW_BIT
		swigIntConstant( GLX_WINDOW_BIT, "GLX_WINDOW_BIT" );
	#endif
	#ifdef GLX_PIXMAP_BIT
		swigIntConstant( GLX_PIXMAP_BIT, "GLX_PIXMAP_BIT" );
	#endif
	#ifdef GLX_PBUFFER_BIT
		swigIntConstant( GLX_PBUFFER_BIT, "GLX_PBUFFER_BIT" );
	#endif
	#ifdef GLX_AUX_BUFFERS_BIT
		swigIntConstant( GLX_AUX_BUFFERS_BIT, "GLX_AUX_BUFFERS_BIT" );
	#endif
	#ifdef GLX_FRONT_LEFT_BUFFER_BIT
		swigIntConstant( GLX_FRONT_LEFT_BUFFER_BIT, "GLX_FRONT_LEFT_BUFFER_BIT" );
	#endif
	#ifdef GLX_FRONT_RIGHT_BUFFER_BIT
		swigIntConstant( GLX_FRONT_RIGHT_BUFFER_BIT, "GLX_FRONT_RIGHT_BUFFER_BIT" );
	#endif
	#ifdef GLX_BACK_LEFT_BUFFER_BIT
		swigIntConstant( GLX_BACK_LEFT_BUFFER_BIT, "GLX_BACK_LEFT_BUFFER_BIT" );
	#endif
	#ifdef GLX_BACK_RIGHT_BUFFER_BIT
		swigIntConstant( GLX_BACK_RIGHT_BUFFER_BIT, "GLX_BACK_RIGHT_BUFFER_BIT" );
	#endif
	#ifdef GLX_DEPTH_BUFFER_BIT
		swigIntConstant( GLX_DEPTH_BUFFER_BIT, "GLX_DEPTH_BUFFER_BIT" );
	#endif
	#ifdef GLX_STENCIL_BUFFER_BIT
		swigIntConstant( GLX_STENCIL_BUFFER_BIT, "GLX_STENCIL_BUFFER_BIT" );
	#endif
	#ifdef GLX_ACCUM_BUFFER_BIT
		swigIntConstant( GLX_ACCUM_BUFFER_BIT, "GLX_ACCUM_BUFFER_BIT" );
	#endif
	#ifdef GLX_NONE
		swigIntConstant( GLX_NONE, "GLX_NONE" );
	#endif
	#ifdef GLX_SLOW_CONFIG
		swigIntConstant( GLX_SLOW_CONFIG, "GLX_SLOW_CONFIG" );
	#endif
	#ifdef GLX_TRUE_COLOR
		swigIntConstant( GLX_TRUE_COLOR, "GLX_TRUE_COLOR" );
	#endif
	#ifdef GLX_DIRECT_COLOR
		swigIntConstant( GLX_DIRECT_COLOR, "GLX_DIRECT_COLOR" );
	#endif
	#ifdef GLX_PSEUDO_COLOR
		swigIntConstant( GLX_PSEUDO_COLOR, "GLX_PSEUDO_COLOR" );
	#endif
	#ifdef GLX_STATIC_COLOR
		swigIntConstant( GLX_STATIC_COLOR, "GLX_STATIC_COLOR" );
	#endif
	#ifdef GLX_GRAY_SCALE
		swigIntConstant( GLX_GRAY_SCALE, "GLX_GRAY_SCALE" );
	#endif
	#ifdef GLX_STATIC_GRAY
		swigIntConstant( GLX_STATIC_GRAY, "GLX_STATIC_GRAY" );
	#endif
	#ifdef GLX_TRANSPARENT_RGB
		swigIntConstant( GLX_TRANSPARENT_RGB, "GLX_TRANSPARENT_RGB" );
	#endif
	#ifdef GLX_TRANSPARENT_INDEX
		swigIntConstant( GLX_TRANSPARENT_INDEX, "GLX_TRANSPARENT_INDEX" );
	#endif
	#ifdef GLX_VISUAL_ID
		swigIntConstant( GLX_VISUAL_ID, "GLX_VISUAL_ID" );
	#endif
	#ifdef GLX_SCREEN
		swigIntConstant( GLX_SCREEN, "GLX_SCREEN" );
	#endif
	#ifdef GLX_NON_CONFORMANT_CONFIG
		swigIntConstant( GLX_NON_CONFORMANT_CONFIG, "GLX_NON_CONFORMANT_CONFIG" );
	#endif
	#ifdef GLX_DRAWABLE_TYPE
		swigIntConstant( GLX_DRAWABLE_TYPE, "GLX_DRAWABLE_TYPE" );
	#endif
	#ifdef GLX_RENDER_TYPE
		swigIntConstant( GLX_RENDER_TYPE, "GLX_RENDER_TYPE" );
	#endif
	#ifdef GLX_X_RENDERABLE
		swigIntConstant( GLX_X_RENDERABLE, "GLX_X_RENDERABLE" );
	#endif
	#ifdef GLX_FBCONFIG_ID
		swigIntConstant( GLX_FBCONFIG_ID, "GLX_FBCONFIG_ID" );
	#endif
	#ifdef GLX_RGBA_TYPE
		swigIntConstant( GLX_RGBA_TYPE, "GLX_RGBA_TYPE" );
	#endif
	#ifdef GLX_COLOR_INDEX_TYPE
		swigIntConstant( GLX_COLOR_INDEX_TYPE, "GLX_COLOR_INDEX_TYPE" );
	#endif
	#ifdef GLX_MAX_PBUFFER_WIDTH
		swigIntConstant( GLX_MAX_PBUFFER_WIDTH, "GLX_MAX_PBUFFER_WIDTH" );
	#endif
	#ifdef GLX_MAX_PBUFFER_HEIGHT
		swigIntConstant( GLX_MAX_PBUFFER_HEIGHT, "GLX_MAX_PBUFFER_HEIGHT" );
	#endif
	#ifdef GLX_MAX_PBUFFER_PIXELS
		swigIntConstant( GLX_MAX_PBUFFER_PIXELS, "GLX_MAX_PBUFFER_PIXELS" );
	#endif
	#ifdef GLX_PRESERVED_CONTENTS
		swigIntConstant( GLX_PRESERVED_CONTENTS, "GLX_PRESERVED_CONTENTS" );
	#endif
	#ifdef GLX_LARGEST_PBUFFER
		swigIntConstant( GLX_LARGEST_PBUFFER, "GLX_LARGEST_PBUFFER" );
	#endif
	#ifdef GLX_WIDTH
		swigIntConstant( GLX_WIDTH, "GLX_WIDTH" );
	#endif
	#ifdef GLX_HEIGHT
		swigIntConstant( GLX_HEIGHT, "GLX_HEIGHT" );
	#endif
	#ifdef GLX_EVENT_MASK
		swigIntConstant( GLX_EVENT_MASK, "GLX_EVENT_MASK" );
	#endif
	#ifdef GLX_DAMAGED
		swigIntConstant( GLX_DAMAGED, "GLX_DAMAGED" );
	#endif
	#ifdef GLX_SAVED
		swigIntConstant( GLX_SAVED, "GLX_SAVED" );
	#endif
	#ifdef GLX_WINDOW
		swigIntConstant( GLX_WINDOW, "GLX_WINDOW" );
	#endif
	#ifdef GLX_PBUFFER
		swigIntConstant( GLX_PBUFFER, "GLX_PBUFFER" );
	#endif
	#ifdef GLX_PBUFFER_HEIGHT
		swigIntConstant( GLX_PBUFFER_HEIGHT, "GLX_PBUFFER_HEIGHT" );
	#endif
	#ifdef GLX_PBUFFER_WIDTH
		swigIntConstant( GLX_PBUFFER_WIDTH, "GLX_PBUFFER_WIDTH" );
	#endif
	#ifdef GLX_RGBA_BIT
		swigIntConstant( GLX_RGBA_BIT, "GLX_RGBA_BIT" );
	#endif
	#ifdef GLX_COLOR_INDEX_BIT
		swigIntConstant( GLX_COLOR_INDEX_BIT, "GLX_COLOR_INDEX_BIT" );
	#endif
	#ifdef GLX_PBUFFER_CLOBBER_MASK
		swigIntConstant( GLX_PBUFFER_CLOBBER_MASK, "GLX_PBUFFER_CLOBBER_MASK" );
	#endif
	#ifdef GLX_SAMPLE_BUFFERS
		swigIntConstant( GLX_SAMPLE_BUFFERS, "GLX_SAMPLE_BUFFERS" );
	#endif
	#ifdef GLX_SAMPLES
		swigIntConstant( GLX_SAMPLES, "GLX_SAMPLES" );
	#endif
	#ifdef GLX_PbufferClobber
		swigIntConstant( GLX_PbufferClobber, "GLX_PbufferClobber" );
	#endif
	#ifdef GLX_BufferSwapComplete
		swigIntConstant( GLX_BufferSwapComplete, "GLX_BufferSwapComplete" );
	#endif
	#ifdef __GLX_NUMBER_EVENTS
		swigIntConstant( __GLX_NUMBER_EVENTS, "__GLX_NUMBER_EVENTS" );
	#endif
	#ifdef GLX_ARB_get_proc_address
		swigIntConstant( GLX_ARB_get_proc_address, "GLX_ARB_get_proc_address" );
	#endif
	#ifdef GLX_ARB_render_texture
		swigIntConstant( GLX_ARB_render_texture, "GLX_ARB_render_texture" );
	#endif
	#ifdef GLX_MESA_swap_frame_usage
		swigIntConstant( GLX_MESA_swap_frame_usage, "GLX_MESA_swap_frame_usage" );
	#endif
	#ifdef GLX_MESA_swap_control
		swigIntConstant( GLX_MESA_swap_control, "GLX_MESA_swap_control" );
	#endif

	swigNewline();

	swigComment("-------===< structs >===--------\n");

	swigComment("GLXPbufferClobberEvent\n");
	printf( "begin-structure GLXPbufferClobberEvent\n" );
	swigStructField( "GLXPbufferClobberEvent-display", offsetof( GLXPbufferClobberEvent, display ), sizeof( Display * ) );
	swigStructField( "GLXPbufferClobberEvent-aux_buffer", offsetof( GLXPbufferClobberEvent, aux_buffer ), sizeof( unsigned int ) );
	swigStructField( "GLXPbufferClobberEvent-x", offsetof( GLXPbufferClobberEvent, x ), sizeof( int ) );
	swigStructField( "GLXPbufferClobberEvent-y", offsetof( GLXPbufferClobberEvent, y ), sizeof( int ) );
	swigStructField( "GLXPbufferClobberEvent-count", offsetof( GLXPbufferClobberEvent, count ), sizeof( int ) );
	swigStructField( "GLXPbufferClobberEvent-draw_type", offsetof( GLXPbufferClobberEvent, draw_type ), sizeof( int ) );
	swigStructField( "GLXPbufferClobberEvent-serial", offsetof( GLXPbufferClobberEvent, serial ), sizeof( unsigned long ) );
	swigStructField( "GLXPbufferClobberEvent-drawable", offsetof( GLXPbufferClobberEvent, drawable ), sizeof( GLXDrawable ) );
	swigStructField( "GLXPbufferClobberEvent-height", offsetof( GLXPbufferClobberEvent, height ), sizeof( int ) );
	swigStructField( "GLXPbufferClobberEvent-event_type", offsetof( GLXPbufferClobberEvent, event_type ), sizeof( int ) );
	swigStructField( "GLXPbufferClobberEvent-send_event", offsetof( GLXPbufferClobberEvent, send_event ), sizeof( Bool ) );
	swigStructField( "GLXPbufferClobberEvent-buffer_mask", offsetof( GLXPbufferClobberEvent, buffer_mask ), sizeof( unsigned int ) );
	swigStructField( "GLXPbufferClobberEvent-width", offsetof( GLXPbufferClobberEvent, width ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( GLXPbufferClobberEvent ) );

	swigComment("GLXBufferSwapComplete\n");
	printf( "begin-structure GLXBufferSwapComplete\n" );
	swigStructField( "GLXBufferSwapComplete-display", offsetof( GLXBufferSwapComplete, display ), sizeof( Display * ) );
	swigStructField( "GLXBufferSwapComplete-msc", offsetof( GLXBufferSwapComplete, msc ), sizeof( int64_t ) );
	swigStructField( "GLXBufferSwapComplete-sbc", offsetof( GLXBufferSwapComplete, sbc ), sizeof( int64_t ) );
	swigStructField( "GLXBufferSwapComplete-serial", offsetof( GLXBufferSwapComplete, serial ), sizeof( unsigned long ) );
	swigStructField( "GLXBufferSwapComplete-drawable", offsetof( GLXBufferSwapComplete, drawable ), sizeof( Drawable ) );
	swigStructField( "GLXBufferSwapComplete-type", offsetof( GLXBufferSwapComplete, type ), sizeof( int ) );
	swigStructField( "GLXBufferSwapComplete-send_event", offsetof( GLXBufferSwapComplete, send_event ), sizeof( Bool ) );
	swigStructField( "GLXBufferSwapComplete-event_type", offsetof( GLXBufferSwapComplete, event_type ), sizeof( int ) );
	swigStructField( "GLXBufferSwapComplete-ust", offsetof( GLXBufferSwapComplete, ust ), sizeof( int64_t ) );
	printf( "drop %zu end-structure\n", sizeof( GLXBufferSwapComplete ) );

	swigComment("union __GLXEvent\n");
	printf( "begin-structure GLXEvent\n" );
	printf( "drop %zu end-structure\n", sizeof( union __GLXEvent ) );

	swigNewline();

	swigComment("------===< callbacks >===-------\n");
	swigCallback( "c-callback PFNGLXGETFBCONFIGSPROC: a n a -- a", "", "", "	( dpy screen nelements -- )" );
	swigCallback( "c-callback PFNGLXCHOOSEFBCONFIGPROC: a n a a -- a", "", "", "	( dpy screen attrib_list nelements -- )" );
	swigCallback( "c-callback PFNGLXGETFBCONFIGATTRIBPROC: a a n a -- n", "", "", "	( dpy config attribute value -- )" );
	swigCallback( "c-callback PFNGLXGETVISUALFROMFBCONFIGPROC: a a -- a", "", "", "	( dpy config -- )" );
	swigCallback( "c-callback PFNGLXCREATEWINDOWPROC: a a n a -- n", "", "", "	( dpy config win attrib_list -- )" );
	swigCallback( "c-callback PFNGLXDESTROYWINDOWPROC: a n -- void", "", "", "	( dpy win -- )" );
	swigCallback( "c-callback PFNGLXCREATEPIXMAPPROC: a a n a -- n", "", "", "	( dpy config pixmap attrib_list -- )" );
	swigCallback( "c-callback PFNGLXDESTROYPIXMAPPROC: a n -- void", "", "", "	( dpy pixmap -- )" );
	swigCallback( "c-callback PFNGLXCREATEPBUFFERPROC: a a a -- n", "", "", "	( dpy config attrib_list -- )" );
	swigCallback( "c-callback PFNGLXDESTROYPBUFFERPROC: a n -- void", "", "", "	( dpy pbuf -- )" );
	swigCallback( "c-callback PFNGLXQUERYDRAWABLEPROC: a n n a -- void", "", "", "	( dpy draw attribute value -- )" );
	swigCallback( "c-callback PFNGLXCREATENEWCONTEXTPROC: a a n a n -- a", "", "", "	( dpy config render_type share_list direct -- )" );
	swigCallback( "c-callback PFNGLXMAKECONTEXTCURRENTPROC: a n n a -- n", "", "", "	( dpy draw read ctx -- )" );
	swigCallback( "c-callback PFNGLXGETCURRENTREADDRAWABLEPROC:  -- n", "", "", "	( <noname> -- )" );
	swigCallback( "c-callback PFNGLXGETCURRENTDISPLAYPROC:  -- a", "", "", "	( <noname> -- )" );
	swigCallback( "c-callback PFNGLXQUERYCONTEXTPROC: a a n a -- n", "", "", "	( dpy ctx attribute value -- )" );
	swigCallback( "c-callback PFNGLXSELECTEVENTPROC: a n u -- void", "", "", "	( dpy draw event_mask -- )" );
	swigCallback( "c-callback PFNGLXGETSELECTEDEVENTPROC: a n a -- void", "", "", "	( dpy draw event_mask -- )" );
	swigCallback( "c-callback __GLXextFuncPtr:  -- void", "", "", "	( <noname> -- )" );
	swigCallback( "c-callback PFNGLXGETPROCADDRESSPROC: a -- a", "", "", "	( procName -- )" );
	swigCallback( "c-callback PFNGLXALLOCATEMEMORYNVPROC: n r r r -- a", "", "", "	( size readfreq writefreq priority -- )" );
	swigCallback( "c-callback PFNGLXFREEMEMORYNVPROC: a -- void", "", "", "	( pointer -- )" );
	swigCallback( "c-callback PFNGLXGETFRAMEUSAGEMESAPROC: a n a -- n", "", "", "	( dpy drawable usage -- )" );
	swigCallback( "c-callback PFNGLXBEGINFRAMETRACKINGMESAPROC: a n -- n", "", "", "	( dpy drawable -- )" );
	swigCallback( "c-callback PFNGLXENDFRAMETRACKINGMESAPROC: a n -- n", "", "", "	( dpy drawable -- )" );
	swigCallback( "c-callback PFNGLXQUERYFRAMETRACKINGMESAPROC: a n a a a -- n", "", "", "	( dpy drawable swapCount missedFrames lastMissedUsage -- )" );
	swigCallback( "c-callback PFNGLXSWAPINTERVALMESAPROC: u -- n", "", "", "	( interval -- )" );
	swigCallback( "c-callback PFNGLXGETSWAPINTERVALMESAPROC:  -- n", "", "", "	( <noname> -- )" );

	swigNewline();

	swigComment("------===< functions >===-------\n");
	swigFunction( "c-function glXChooseVisual glXChooseVisual a n a -- a", "FUNCTION: glXChooseVisual ( dpy screen attribList -- a )", "EXTERN: \"C\" void * glXChooseVisual( void * dpy, int screen, void * attribList );", "	( dpy screen attribList -- )" );
	swigFunction( "c-function glXCreateContext glXCreateContext a a a n -- a", "FUNCTION: glXCreateContext ( dpy vis shareList direct -- a )", "EXTERN: \"C\" void * glXCreateContext( void * dpy, void * vis, void * shareList, int direct );", "	( dpy vis shareList direct -- )" );
	swigFunction( "c-function glXDestroyContext glXDestroyContext a a -- void", "FUNCTION: glXDestroyContext ( dpy ctx -- void )", "EXTERN: \"C\" void glXDestroyContext( void * dpy, void * ctx );", "	( dpy ctx -- )" );
	swigFunction( "c-function glXMakeCurrent glXMakeCurrent a n a -- n", "FUNCTION: glXMakeCurrent ( dpy drawable ctx -- n )", "EXTERN: \"C\" int glXMakeCurrent( void * dpy, int drawable, void * ctx );", "	( dpy drawable ctx -- )" );
	swigFunction( "c-function glXCopyContext glXCopyContext a a a u -- void", "FUNCTION: glXCopyContext ( dpy src dst mask -- void )", "EXTERN: \"C\" void glXCopyContext( void * dpy, void * src, void * dst, long mask );", "	( dpy src dst mask -- )" );
	swigFunction( "c-function glXSwapBuffers glXSwapBuffers a n -- void", "FUNCTION: glXSwapBuffers ( dpy drawable -- void )", "EXTERN: \"C\" void glXSwapBuffers( void * dpy, int drawable );", "	( dpy drawable -- )" );
	swigFunction( "c-function glXCreateGLXPixmap glXCreateGLXPixmap a a n -- n", "FUNCTION: glXCreateGLXPixmap ( dpy visual pixmap -- n )", "EXTERN: \"C\" int glXCreateGLXPixmap( void * dpy, void * visual, int pixmap );", "	( dpy visual pixmap -- )" );
	swigFunction( "c-function glXDestroyGLXPixmap glXDestroyGLXPixmap a n -- void", "FUNCTION: glXDestroyGLXPixmap ( dpy pixmap -- void )", "EXTERN: \"C\" void glXDestroyGLXPixmap( void * dpy, int pixmap );", "	( dpy pixmap -- )" );
	swigFunction( "c-function glXQueryExtension glXQueryExtension a a a -- n", "FUNCTION: glXQueryExtension ( dpy errorb event -- n )", "EXTERN: \"C\" int glXQueryExtension( void * dpy, void * errorb, void * event );", "	( dpy errorb event -- )" );
	swigFunction( "c-function glXQueryVersion glXQueryVersion a a a -- n", "FUNCTION: glXQueryVersion ( dpy maj min -- n )", "EXTERN: \"C\" int glXQueryVersion( void * dpy, void * maj, void * min );", "	( dpy maj min -- )" );
	swigFunction( "c-function glXIsDirect glXIsDirect a a -- n", "FUNCTION: glXIsDirect ( dpy ctx -- n )", "EXTERN: \"C\" int glXIsDirect( void * dpy, void * ctx );", "	( dpy ctx -- )" );
	swigFunction( "c-function glXGetConfig glXGetConfig a a n a -- n", "FUNCTION: glXGetConfig ( dpy visual attrib value -- n )", "EXTERN: \"C\" int glXGetConfig( void * dpy, void * visual, int attrib, void * value );", "	( dpy visual attrib value -- )" );
	swigFunction( "c-function glXGetCurrentContext glXGetCurrentContext  -- a", "FUNCTION: glXGetCurrentContext (  -- a )", "EXTERN: \"C\" void * glXGetCurrentContext(  );", "	( -- )" );
	swigFunction( "c-function glXGetCurrentDrawable glXGetCurrentDrawable  -- n", "FUNCTION: glXGetCurrentDrawable (  -- n )", "EXTERN: \"C\" int glXGetCurrentDrawable(  );", "	( -- )" );
	swigFunction( "c-function glXWaitGL glXWaitGL  -- void", "FUNCTION: glXWaitGL (  -- void )", "EXTERN: \"C\" void glXWaitGL(  );", "	( -- )" );
	swigFunction( "c-function glXWaitX glXWaitX  -- void", "FUNCTION: glXWaitX (  -- void )", "EXTERN: \"C\" void glXWaitX(  );", "	( -- )" );
	swigFunction( "c-function glXUseXFont glXUseXFont n n n n -- void", "FUNCTION: glXUseXFont ( font first count list -- void )", "EXTERN: \"C\" void glXUseXFont( int font, int first, int count, int list );", "	( font first count list -- )" );
	swigFunction( "c-function glXQueryExtensionsString glXQueryExtensionsString a n -- s", "FUNCTION: glXQueryExtensionsString ( dpy screen -- s )", "EXTERN: \"C\" char * glXQueryExtensionsString( void * dpy, int screen );", "	( dpy screen -- )" );
	swigFunction( "c-function glXQueryServerString glXQueryServerString a n n -- s", "FUNCTION: glXQueryServerString ( dpy screen name -- s )", "EXTERN: \"C\" char * glXQueryServerString( void * dpy, int screen, int name );", "	( dpy screen name -- )" );
	swigFunction( "c-function glXGetClientString glXGetClientString a n -- s", "FUNCTION: glXGetClientString ( dpy name -- s )", "EXTERN: \"C\" char * glXGetClientString( void * dpy, int name );", "	( dpy name -- )" );
	swigFunction( "c-function glXGetCurrentDisplay glXGetCurrentDisplay  -- a", "FUNCTION: glXGetCurrentDisplay (  -- a )", "EXTERN: \"C\" void * glXGetCurrentDisplay(  );", "	( -- )" );
	swigFunction( "c-function glXChooseFBConfig glXChooseFBConfig a n a a -- a", "FUNCTION: glXChooseFBConfig ( dpy screen attribList nitems -- a )", "EXTERN: \"C\" void * glXChooseFBConfig( void * dpy, int screen, void * attribList, void * nitems );", "	( dpy screen attribList nitems -- )" );
	swigFunction( "c-function glXGetFBConfigAttrib glXGetFBConfigAttrib a a n a -- n", "FUNCTION: glXGetFBConfigAttrib ( dpy config attribute value -- n )", "EXTERN: \"C\" int glXGetFBConfigAttrib( void * dpy, void * config, int attribute, void * value );", "	( dpy config attribute value -- )" );
	swigFunction( "c-function glXGetFBConfigs glXGetFBConfigs a n a -- a", "FUNCTION: glXGetFBConfigs ( dpy screen nelements -- a )", "EXTERN: \"C\" void * glXGetFBConfigs( void * dpy, int screen, void * nelements );", "	( dpy screen nelements -- )" );
	swigFunction( "c-function glXGetVisualFromFBConfig glXGetVisualFromFBConfig a a -- a", "FUNCTION: glXGetVisualFromFBConfig ( dpy config -- a )", "EXTERN: \"C\" void * glXGetVisualFromFBConfig( void * dpy, void * config );", "	( dpy config -- )" );
	swigFunction( "c-function glXCreateWindow glXCreateWindow a a n a -- n", "FUNCTION: glXCreateWindow ( dpy config win attribList -- n )", "EXTERN: \"C\" int glXCreateWindow( void * dpy, void * config, int win, void * attribList );", "	( dpy config win attribList -- )" );
	swigFunction( "c-function glXDestroyWindow glXDestroyWindow a n -- void", "FUNCTION: glXDestroyWindow ( dpy window -- void )", "EXTERN: \"C\" void glXDestroyWindow( void * dpy, int window );", "	( dpy window -- )" );
	swigFunction( "c-function glXCreatePixmap glXCreatePixmap a a n a -- n", "FUNCTION: glXCreatePixmap ( dpy config pixmap attribList -- n )", "EXTERN: \"C\" int glXCreatePixmap( void * dpy, void * config, int pixmap, void * attribList );", "	( dpy config pixmap attribList -- )" );
	swigFunction( "c-function glXDestroyPixmap glXDestroyPixmap a n -- void", "FUNCTION: glXDestroyPixmap ( dpy pixmap -- void )", "EXTERN: \"C\" void glXDestroyPixmap( void * dpy, int pixmap );", "	( dpy pixmap -- )" );
	swigFunction( "c-function glXCreatePbuffer glXCreatePbuffer a a a -- n", "FUNCTION: glXCreatePbuffer ( dpy config attribList -- n )", "EXTERN: \"C\" int glXCreatePbuffer( void * dpy, void * config, void * attribList );", "	( dpy config attribList -- )" );
	swigFunction( "c-function glXDestroyPbuffer glXDestroyPbuffer a n -- void", "FUNCTION: glXDestroyPbuffer ( dpy pbuf -- void )", "EXTERN: \"C\" void glXDestroyPbuffer( void * dpy, int pbuf );", "	( dpy pbuf -- )" );
	swigFunction( "c-function glXQueryDrawable glXQueryDrawable a n n a -- void", "FUNCTION: glXQueryDrawable ( dpy draw attribute value -- void )", "EXTERN: \"C\" void glXQueryDrawable( void * dpy, int draw, int attribute, void * value );", "	( dpy draw attribute value -- )" );
	swigFunction( "c-function glXCreateNewContext glXCreateNewContext a a n a n -- a", "FUNCTION: glXCreateNewContext ( dpy config renderType shareList direct -- a )", "EXTERN: \"C\" void * glXCreateNewContext( void * dpy, void * config, int renderType, void * shareList, int direct );", "	( dpy config renderType shareList direct -- )" );
	swigFunction( "c-function glXMakeContextCurrent glXMakeContextCurrent a n n a -- n", "FUNCTION: glXMakeContextCurrent ( dpy draw read ctx -- n )", "EXTERN: \"C\" int glXMakeContextCurrent( void * dpy, int draw, int read, void * ctx );", "	( dpy draw read ctx -- )" );
	swigFunction( "c-function glXGetCurrentReadDrawable glXGetCurrentReadDrawable  -- n", "FUNCTION: glXGetCurrentReadDrawable (  -- n )", "EXTERN: \"C\" int glXGetCurrentReadDrawable(  );", "	( -- )" );
	swigFunction( "c-function glXQueryContext glXQueryContext a a n a -- n", "FUNCTION: glXQueryContext ( dpy ctx attribute value -- n )", "EXTERN: \"C\" int glXQueryContext( void * dpy, void * ctx, int attribute, void * value );", "	( dpy ctx attribute value -- )" );
	swigFunction( "c-function glXSelectEvent glXSelectEvent a n u -- void", "FUNCTION: glXSelectEvent ( dpy drawable mask -- void )", "EXTERN: \"C\" void glXSelectEvent( void * dpy, int drawable, long mask );", "	( dpy drawable mask -- )" );
	swigFunction( "c-function glXGetSelectedEvent glXGetSelectedEvent a n a -- void", "FUNCTION: glXGetSelectedEvent ( dpy drawable mask -- void )", "EXTERN: \"C\" void glXGetSelectedEvent( void * dpy, int drawable, void * mask );", "	( dpy drawable mask -- )" );
	swigFunction( "c-function glXGetProcAddressARB glXGetProcAddressARB a -- a", "FUNCTION: glXGetProcAddressARB (  -- a )", "EXTERN: \"C\" void * glXGetProcAddressARB( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function glXGetProcAddress glXGetProcAddress a -- a", "FUNCTION: glXGetProcAddress ( procname -- a )", "EXTERN: \"C\" void * glXGetProcAddress( void * procname );", "	( procname -- )" );
	swigFunction( "c-function glXAllocateMemoryNV glXAllocateMemoryNV n r r r -- a", "FUNCTION: glXAllocateMemoryNV ( size readfreq writefreq priority -- a )", "EXTERN: \"C\" void * glXAllocateMemoryNV( int size, float readfreq, float writefreq, float priority );", "	( size readfreq writefreq priority -- )" );
	swigFunction( "c-function glXFreeMemoryNV glXFreeMemoryNV a -- void", "FUNCTION: glXFreeMemoryNV ( pointer -- void )", "EXTERN: \"C\" void glXFreeMemoryNV( void * pointer );", "	( pointer -- )" );
	swigFunction( "c-function glXBindTexImageARB glXBindTexImageARB a n n -- n", "FUNCTION: glXBindTexImageARB ( dpy pbuffer buffer -- n )", "EXTERN: \"C\" int glXBindTexImageARB( void * dpy, int pbuffer, int buffer );", "	( dpy pbuffer buffer -- )" );
	swigFunction( "c-function glXReleaseTexImageARB glXReleaseTexImageARB a n n -- n", "FUNCTION: glXReleaseTexImageARB ( dpy pbuffer buffer -- n )", "EXTERN: \"C\" int glXReleaseTexImageARB( void * dpy, int pbuffer, int buffer );", "	( dpy pbuffer buffer -- )" );
	swigFunction( "c-function glXDrawableAttribARB glXDrawableAttribARB a n a -- n", "FUNCTION: glXDrawableAttribARB ( dpy draw attribList -- n )", "EXTERN: \"C\" int glXDrawableAttribARB( void * dpy, int draw, void * attribList );", "	( dpy draw attribList -- )" );
	swigFunction( "c-function glXGetFrameUsageMESA glXGetFrameUsageMESA a n a -- n", "FUNCTION: glXGetFrameUsageMESA ( dpy drawable usage -- n )", "EXTERN: \"C\" int glXGetFrameUsageMESA( void * dpy, int drawable, void * usage );", "	( dpy drawable usage -- )" );
	swigFunction( "c-function glXBeginFrameTrackingMESA glXBeginFrameTrackingMESA a n -- n", "FUNCTION: glXBeginFrameTrackingMESA ( dpy drawable -- n )", "EXTERN: \"C\" int glXBeginFrameTrackingMESA( void * dpy, int drawable );", "	( dpy drawable -- )" );
	swigFunction( "c-function glXEndFrameTrackingMESA glXEndFrameTrackingMESA a n -- n", "FUNCTION: glXEndFrameTrackingMESA ( dpy drawable -- n )", "EXTERN: \"C\" int glXEndFrameTrackingMESA( void * dpy, int drawable );", "	( dpy drawable -- )" );
	swigFunction( "c-function glXQueryFrameTrackingMESA glXQueryFrameTrackingMESA a n a a a -- n", "FUNCTION: glXQueryFrameTrackingMESA ( dpy drawable swapCount missedFrames lastMissedUsage -- n )", "EXTERN: \"C\" int glXQueryFrameTrackingMESA( void * dpy, int drawable, void * swapCount, void * missedFrames, void * lastMissedUsage );", "	( dpy drawable swapCount missedFrames lastMissedUsage -- )" );
	swigFunction( "c-function glXSwapIntervalMESA glXSwapIntervalMESA u -- n", "FUNCTION: glXSwapIntervalMESA ( interval -- n )", "EXTERN: \"C\" int glXSwapIntervalMESA( int interval );", "	( interval -- )" );
	swigFunction( "c-function glXGetSwapIntervalMESA glXGetSwapIntervalMESA  -- n", "FUNCTION: glXGetSwapIntervalMESA (  -- n )", "EXTERN: \"C\" int glXGetSwapIntervalMESA(  );", "	( -- )" );

	swigNewline();

	swigComment("----===< postfix >===-----\n");

	swigPrint( "end-c-library", "( none )", "( none )" );
	
	return 0;
} /* end of main */



