/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 3.0.9
 *
 * This file is not intended to be easily readable and contains a number of
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG
 * interface file instead.
 * ----------------------------------------------------------------------------- */
#include <stdio.h>
#include <string.h>
#include <stddef.h>

// Do not edit below this line
// end-of-default-includes


#include <va/va.h>
#include <va/va_vpp.h>
#include <va/va_backend.h>

typedef enum{ NONE = -1, GFORTH = 0, SWIFTFORTH, VFX } SwigTargetSystem;
SwigTargetSystem swigTargetSystem = NONE;

unsigned char swigPrintStackComments = 1;

/* comments */
void swigNewline()
{
	printf( "\n" );
}

void swigComment( char *comment )
{
	printf( "\\ %s", comment );
}

/* generic print */
void swigPrint( char* gforth, char *swiftForth, char *vfx )
{
	if( swigTargetSystem == GFORTH )
		printf( "%s", gforth );
	else if( swigTargetSystem == SWIFTFORTH )
		printf( "%s", swiftForth );
	else if( swigTargetSystem == VFX )
		printf( "%s", vfx );
	printf( "\n" );
}
void swigPrintSystem( SwigTargetSystem targetSystem, char *text )
{
	if( targetSystem == swigTargetSystem )
	    printf( "%s\n", text );
}

/* constants */
void swigIntConstant( long constant, char *name )
{
	printf( "#%ld\tconstant %s\n", constant, name );
}

void swigUnsignedIntConstant( unsigned long constant, char *name )
{
	printf( "#%lu\tconstant %s\n", constant, name );
}

void swigLongConstant( long long constant, char *name )
{
	printf( "#%lld.\t2constant %s\n", constant, name );
}

void swigUnsignedLongConstant( unsigned long long constant, char *name )
{
	printf( "#%llu.\t2constant %s\n", constant, name );
}

void swigFloatConstant( double constant, char *name )
{
	char buffer[128];
	sprintf( buffer, "%f", constant );

	/* if the constant contains no exponent, add one */
	char *s;
	for( s = buffer; *s != 0; s++ )
		if( *s == 'e' || *s == 'E' )
			break;

	/* exponent found */
	if( *s != 0 )
		printf( "%s\tfconstant %s\n", buffer, name );
	/* not found */
	else
		printf( "%se0\tfconstant %s\n", buffer, name );
}

void swigStringConstant( char* constant, char *name )
{
	char c;
	printf( ": %s s\\\" ", name );
	while(( c = *constant++ ))
	{
		switch(c)
		{
			case '\b': printf( "\\b" ); break;
			case '\n': printf( "\\n" ); break;
			case '\f': printf( "\\f" ); break;
			case '\r': printf( "\\r" ); break;
			case '\t': printf( "\\t" ); break;
			case '"' : printf( "\\q" ); break;
			default:
				if(c < 0x20)
					printf("\\x%02x", c);
				else
					printf("%c", c); break;
		}
	}
	printf(	"\" ;\n" );
}

/* structs */
void swigStructField( char *name, size_t offset, size_t size )
{
	printf( "\tdrop %zu %zu +field %s\n", offset, size, name );
}

/* functions */
void swigFunction( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	if( swigTargetSystem == GFORTH )
		printf( "%s", gforth );
	else if( swigTargetSystem == SWIFTFORTH )
		printf( "%s", swiftForth );
	else if( swigTargetSystem == VFX )
		printf( "%s", vfx );

	if( swigPrintStackComments )
		printf( "%s", stackComment );

	printf( "\n" );
}

/* function pointers */
void swigFunctionPointer( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	swigFunction( gforth, swiftForth, vfx, stackComment );
}

/* callbacks */
void swigCallback( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	swigFunction( gforth, swiftForth, vfx, stackComment );
}

void swigUsage( char **argv )
{
	fprintf( stderr, "Usage: %s [-gforth|-swiftforth|-vfx]\n", argv[0] );
}

int main( int argc, char **argv )
{
	int i;

	/* check arguments */
	for( i = 1; i < argc; i++ )
		if( strcmp( argv[i], "-gforth" ) == 0 )
			swigTargetSystem = GFORTH;
		else if( strcmp( argv[i], "-swiftforth" ) == 0 )
			swigTargetSystem = SWIFTFORTH;
		else if( strcmp( argv[i], "-vfx" ) == 0 )
			swigTargetSystem = VFX;

	if( swigTargetSystem == NONE )
	{
		fprintf( stderr, "Error: no target system specified\n" );
		swigUsage( argv );
		return 1;
	}

	/* primer */
	printf( "\\ This file has been generated using SWIG and fsi,\n"
		"\\ and is already platform dependent, search for the corresponding\n"
		"\\ fsi-file to compile it where no one has compiled it before ;)\n"
		"\\ Forth systems have their own own dynamic loader and don't need addional C-Code.\n"
		"\\ That's why this file will just print normal forth-code once compiled\n"
		"\\ and can be used directly with include or require.\n"
		"\\ As all comments are stripped during the compilation, please\n"
		"\\ insert the copyright notice of the original file here.\n"
	);


typedef struct {
  uint32_t rotation : 4;
  
  uint32_t reserved : 28;
} _VAConfigAttribValDecJPEG_bits;

typedef struct {
  uint32_t max_frame_size : 1;
  
  uint32_t multiple_pass  : 1;
  
  uint32_t reserved       : 30;
} _VAConfigAttribValMaxFrameSize_bits;

typedef struct {
  uint32_t arithmatic_coding_mode : 1;
  
  uint32_t progressive_dct_mode : 1;
  
  uint32_t non_interleaved_mode : 1;
  
  uint32_t differential_mode : 1;
  uint32_t max_num_components : 3;
  uint32_t max_num_scans : 4;
  uint32_t max_num_huffman_tables : 3;
  uint32_t max_num_quantization_tables : 3;
} _VAConfigAttribValEncJPEG_bits;

typedef struct {
  uint32_t num_roi_regions        : 8;
  
  uint32_t roi_rc_priority_support    : 1;
  
  uint32_t roi_rc_qp_delta_support    : 1;
  uint32_t reserved                   : 22;
} _VAConfigAttribValEncROI_bits;

typedef struct {
  uint32_t max_num_temporal_layers_minus1      : 8;
  
  
//   uint32_t temporal_layer_bitrate_control_flag : 1;
  uint32_t reserved                            : 23;
} _VAConfigAttribValEncRateControlExt_bits;

typedef struct {
  uint32_t max_num_concurrent_frames      : 8;
  
  uint32_t mixed_quality_level            : 1;
  
  uint32_t reserved                       : 23;
} _VAConfigAttribValMultipleFrame_bits;

typedef struct {
  uint32_t priority     : 16;
  
  uint32_t reserved     : 16;
} _VAConfigAttribValContextPriority_bits;

typedef struct {
  uint32_t delta_qp_support         : 1;
  
  uint32_t log2_delta_qp_block_size : 4;
  
  uint32_t delta_qp_size_in_bytes   : 3;
  
  uint32_t reserved                 : 24;
} _VAConfigAttribValEncPerBlockControl_bits;

typedef union {
  int32_t             i;
  
  float           f;
  
  void           *p;
  
  VAGenericFunc   fn;
} _VAGenericValue_value;

typedef union {
  struct {
    uint32_t context_priority_update : 1;
    
    uint32_t reserved                : 31;
  } bits;
  uint32_t value;
} _VAContextParameterUpdateBuffer_flags;

typedef struct {
  uint32_t context_priority_update : 1;
  
  uint32_t reserved                : 31;
} _VAContextParameterUpdateBuffer_flags_bits;

typedef union {
  struct {
    uint32_t reset : 1;
    
    uint32_t disable_frame_skip : 1;
    
//     uint32_t disable_bit_stuffing : 1;
    
    uint32_t mb_rate_control : 4;
    
    uint32_t temporal_id : 8;
    
    uint32_t cfs_I_frames : 1;
    
    uint32_t enable_parallel_brc    : 1;
    uint32_t enable_dynamic_scaling : 1;
    
    uint32_t frame_tolerance_mode   : 2;
    
    uint32_t reserved               : 12;
  } bits;
  uint32_t value;
} _VAEncMiscParameterRateControl_rc_flags;

typedef struct {
  uint32_t reset : 1;
  
  uint32_t disable_frame_skip : 1;
  
//   uint32_t disable_bit_stuffing : 1;
  
  uint32_t mb_rate_control : 4;
  
  uint32_t temporal_id : 8;
  
  uint32_t cfs_I_frames : 1;
  
  uint32_t enable_parallel_brc    : 1;
  uint32_t enable_dynamic_scaling : 1;
  
  uint32_t frame_tolerance_mode   : 2;
  
  uint32_t reserved               : 12;
} _VAEncMiscParameterRateControl_rc_flags_bits;

typedef union {
  struct {
    uint32_t temporal_id : 8;
    
    uint32_t reserved : 24;
  } bits;
  uint32_t value;
} _VAEncMiscParameterFrameRate_framerate_flags;

typedef struct {
  uint32_t temporal_id : 8;
  
  uint32_t reserved : 24;
} _VAEncMiscParameterFrameRate_framerate_flags_bits;

typedef union {
  struct                                                                                                                                                                                                                                                               {
    uint32_t enable_rir_column : 1;
    
    uint32_t enable_rir_row : 1;
    uint32_t reserved : 30;
  } bits;
  uint32_t value;
} _VAEncMiscParameterRIR_rir_flags;

typedef struct {
  uint32_t enable_rir_column : 1;
  
  uint32_t enable_rir_row : 1;
  uint32_t reserved : 30;
} _VAEncMiscParameterRIR_rir_flags_bits;

typedef union {
  struct {
    uint32_t disable_trellis : 1;
    
    uint32_t enable_trellis_I : 1;
    
    uint32_t enable_trellis_P : 1;
    
    uint32_t enable_trellis_B : 1;
    uint32_t reserved : 28;
  } bits;
  uint32_t value;
} _VAEncMiscParameterQuantization_quantization_flags;

typedef struct {
  uint32_t disable_trellis : 1;
  
  uint32_t enable_trellis_I : 1;
  
  uint32_t enable_trellis_P : 1;
  
  uint32_t enable_trellis_B : 1;
  uint32_t reserved : 28;
} _VAEncMiscParameterQuantization_quantization_flags_bits;

typedef union {
  struct {
    uint32_t  roi_value_is_qp_delta    : 1;
    uint32_t  reserved                 : 31;
  } bits;
  uint32_t value;
} _VAEncMiscParameterBufferROI_roi_flags;

typedef struct {
  uint32_t  roi_value_is_qp_delta    : 1;
  uint32_t  reserved                 : 31;
} _VAEncMiscParameterBufferROI_roi_flags_bits;

typedef union {
  struct {
    uint32_t    enable_custom_rouding_intra     : 1 ;
    
    
    uint32_t    rounding_offset_intra           : 7;
    
    
    uint32_t    enable_custom_rounding_inter    : 1 ;
    
    
    uint32_t    rounding_offset_inter           : 7;
    
    
    uint32_t    reserved                        : 16;
  }  bits;
  uint32_t    value;
} _VAEncMiscParameterCustomRoundingControl_rounding_offset_setting;

typedef struct {
  uint32_t    enable_custom_rouding_intra     : 1 ;
  
  
  uint32_t    rounding_offset_intra           : 7;
  
  
  uint32_t    enable_custom_rounding_inter    : 1 ;
  
  
  uint32_t    rounding_offset_inter           : 7;
  
  
  uint32_t    reserved                        : 16;
} _VAEncMiscParameterCustomRoundingControl_rounding_offset_setting_bits;

typedef struct {
  uint8_t   num_dc_codes[16];
  
  uint8_t   dc_values[12];
  
  
  
  
  uint8_t   num_ac_codes[16];
  
  uint8_t   ac_values[162];
  
  uint8_t   pad[2];
  
} _VAHuffmanTableBufferJPEGBaseline_huffman_table;

typedef union {
  struct {
    uint32_t intra_dc_precision     : 2;
    uint32_t picture_structure      : 2;
    uint32_t top_field_first        : 1;
    uint32_t frame_pred_frame_dct       : 1;
    uint32_t concealment_motion_vectors : 1;
    uint32_t q_scale_type           : 1;
    uint32_t intra_vlc_format       : 1;
    uint32_t alternate_scan         : 1;
    uint32_t repeat_first_field     : 1;
    uint32_t progressive_frame      : 1;
    uint32_t is_first_field         : 1;                                                                                                                                                                                                            
  } bits;
  uint32_t value;
} _VAPictureParameterBufferMPEG2_picture_coding_extension;

typedef struct {
  uint32_t intra_dc_precision     : 2;
  uint32_t picture_structure      : 2;
  uint32_t top_field_first        : 1;
  uint32_t frame_pred_frame_dct       : 1;
  uint32_t concealment_motion_vectors : 1;
  uint32_t q_scale_type           : 1;
  uint32_t intra_vlc_format       : 1;
  uint32_t alternate_scan         : 1;
  uint32_t repeat_first_field     : 1;
  uint32_t progressive_frame      : 1;
  uint32_t is_first_field         : 1;                                                                                                                                                                                                            
} _VAPictureParameterBufferMPEG2_picture_coding_extension_bits;

typedef union {
  struct {
    uint32_t frame_motion_type      : 2;
    uint32_t field_motion_type      : 2;
    uint32_t dct_type           : 1;
  } bits;
  uint32_t value;
} _VAMacroblockParameterBufferMPEG2_macroblock_modes;

typedef struct {
  uint32_t frame_motion_type      : 2;
  uint32_t field_motion_type      : 2;
  uint32_t dct_type           : 1;
} _VAMacroblockParameterBufferMPEG2_macroblock_modes_bits;

typedef union {
  struct {
    uint32_t short_video_header     : 1;
    uint32_t chroma_format          : 2;
    uint32_t interlaced         : 1;
    uint32_t obmc_disable           : 1;
    uint32_t sprite_enable          : 2;
    uint32_t sprite_warping_accuracy    : 2;
    uint32_t quant_type         : 1;
    uint32_t quarter_sample         : 1;
    uint32_t data_partitioned       : 1;
    uint32_t reversible_vlc         : 1;
    uint32_t resync_marker_disable      : 1;
  } bits;
  uint32_t value;
} _VAPictureParameterBufferMPEG4_vol_fields;

typedef union {
  struct {
    uint32_t vop_coding_type        : 2;
    uint32_t backward_reference_vop_coding_type : 2;
    uint32_t vop_rounding_type      : 1;
    uint32_t intra_dc_vlc_thr       : 3;
    uint32_t top_field_first        : 1;
    uint32_t alternate_vertical_scan_flag   : 1;
  } bits;
  uint32_t value;
} _VAPictureParameterBufferMPEG4_vop_fields;

typedef struct {
  uint32_t vop_coding_type        : 2;
  uint32_t backward_reference_vop_coding_type : 2;
  uint32_t vop_rounding_type      : 1;
  uint32_t intra_dc_vlc_thr       : 3;
  uint32_t top_field_first        : 1;
  uint32_t alternate_vertical_scan_flag   : 1;
} _VAPictureParameterBufferMPEG4_vop_fields_bits;

typedef struct {
  uint32_t short_video_header     : 1;
  uint32_t chroma_format          : 2;
  uint32_t interlaced         : 1;
  uint32_t obmc_disable           : 1;
  uint32_t sprite_enable          : 2;
  uint32_t sprite_warping_accuracy    : 2;
  uint32_t quant_type         : 1;
  uint32_t quarter_sample         : 1;
  uint32_t data_partitioned       : 1;
  uint32_t reversible_vlc         : 1;
  uint32_t resync_marker_disable      : 1;
} _VAPictureParameterBufferMPEG4_vol_fields_bits;

typedef union {
  struct {
    uint32_t pulldown   : 1;                               
    uint32_t interlace  : 1;                                
    uint32_t tfcntrflag : 1;                                 
    uint32_t finterpflag    : 1;                                  
    uint32_t psf        : 1;                          
    uint32_t multires   : 1;                         
    uint32_t overlap    : 1;                        
    uint32_t syncmarker : 1;                           
    uint32_t rangered   : 1;                         
    uint32_t max_b_frames   : 3;                           
    uint32_t profile    : 2;                                                              
  } bits;
  uint32_t value;
} _VAPictureParameterBufferVC1_sequence_fields;

typedef union {
  struct {
    uint32_t broken_link    : 1;                                     
    uint32_t closed_entry   : 1;                                      
    uint32_t panscan_flag   : 1;                                      
    uint32_t loopfilter : 1;                                    
  } bits;
  uint32_t value;
} _VAPictureParameterBufferVC1_entrypoint_fields;

typedef union {
  struct {
    uint32_t luma_flag  : 1;                                         
    uint32_t luma       : 3;                                    
    uint32_t chroma_flag    : 1;                                          
    uint32_t chroma     : 3;                                     
  } bits;
  uint32_t value;
} _VAPictureParameterBufferVC1_range_mapping_fields;

typedef union {
  struct {
    uint32_t picture_type       : 3;                           
    uint32_t frame_coding_mode  : 3;                         
    uint32_t top_field_first    : 1;                         
    uint32_t is_first_field     : 1;                                        
    uint32_t intensity_compensation : 1;                             
  } bits;
  uint32_t value;
} _VAPictureParameterBufferVC1_picture_fields;

typedef union {
  struct {
//     uint32_t mv_type_mb : 1;                           
//     uint32_t direct_mb  : 1;                           
//     uint32_t skip_mb    : 1;                         
    uint32_t field_tx   : 1;                          
//     uint32_t forward_mb : 1;                            
    uint32_t ac_pred    : 1;                         
    uint32_t overflags  : 1;                            
  } flags;
  uint32_t value;
} _VAPictureParameterBufferVC1_raw_coding;

typedef union {
  struct {
//     uint32_t bp_mv_type_mb   : 1;                           
//     uint32_t bp_direct_mb    : 1;                           
//     uint32_t bp_skip_mb      : 1;                         
    uint32_t bp_field_tx     : 1;                          
//     uint32_t bp_forward_mb   : 1;                            
    uint32_t bp_ac_pred      : 1;                         
    uint32_t bp_overflags    : 1;                            
  } flags;
  uint32_t value;
} _VAPictureParameterBufferVC1_bitplane_present;

typedef union {
  struct {
    uint32_t reference_distance_flag : 1;                                 
    uint32_t reference_distance : 5;                            
    uint32_t num_reference_pictures: 1;                           
    uint32_t reference_field_pic_indicator  : 1;                             
  } bits;
  uint32_t value;
} _VAPictureParameterBufferVC1_reference_fields;

typedef union {
  struct {
    uint32_t mv_mode        : 3;                            
    uint32_t mv_mode2       : 3;                             
    uint32_t mv_table       : 3;                                  
    uint32_t two_mv_block_pattern_table: 2;                              
    uint32_t four_mv_switch     : 1;                               
    uint32_t four_mv_block_pattern_table : 2;                              
    uint32_t extended_mv_flag   : 1;                                     
    uint32_t extended_mv_range  : 2;                             
    uint32_t extended_dmv_flag  : 1;                                      
    uint32_t extended_dmv_range : 2;                              
  } bits;
  uint32_t value;
} _VAPictureParameterBufferVC1_mv_fields;

typedef union {
  struct {
    uint32_t dquant : 2;                                   
    uint32_t quantizer     : 2;                                       
    uint32_t half_qp    : 1;                               
    uint32_t pic_quantizer_scale : 5;                           
    uint32_t pic_quantizer_type : 1;                               
    uint32_t dq_frame   : 1;                              
    uint32_t dq_profile : 2;                              
    uint32_t dq_sb_edge : 2;                             
    uint32_t dq_db_edge     : 2;                             
    uint32_t dq_binary_level : 1;                             
    uint32_t alt_pic_quantizer : 5;                          
  } bits;
  uint32_t value;
} _VAPictureParameterBufferVC1_pic_quantizer_fields;

typedef union {
  struct {
    uint32_t variable_sized_transform_flag  : 1;                                    
    uint32_t mb_level_transform_type_flag   : 1;                          
    uint32_t frame_level_transform_type : 2;                          
    uint32_t transform_ac_codingset_idx1    : 2;                               
    uint32_t transform_ac_codingset_idx2    : 2;                                
    uint32_t intra_transform_dc_table   : 1;                               
  } bits;
  uint32_t value;
} _VAPictureParameterBufferVC1_transform_fields;

typedef struct {
  uint32_t variable_sized_transform_flag  : 1;                                    
  uint32_t mb_level_transform_type_flag   : 1;                          
  uint32_t frame_level_transform_type : 2;                          
  uint32_t transform_ac_codingset_idx1    : 2;                               
  uint32_t transform_ac_codingset_idx2    : 2;                                
  uint32_t intra_transform_dc_table   : 1;                               
} _VAPictureParameterBufferVC1_transform_fields_bits;

typedef struct {
  uint32_t dquant : 2;                                   
  uint32_t quantizer     : 2;                                       
  uint32_t half_qp    : 1;                               
  uint32_t pic_quantizer_scale : 5;                           
  uint32_t pic_quantizer_type : 1;                               
  uint32_t dq_frame   : 1;                              
  uint32_t dq_profile : 2;                              
  uint32_t dq_sb_edge : 2;                             
  uint32_t dq_db_edge     : 2;                             
  uint32_t dq_binary_level : 1;                             
  uint32_t alt_pic_quantizer : 5;                          
} _VAPictureParameterBufferVC1_pic_quantizer_fields_bits;

typedef struct {
  uint32_t mv_mode        : 3;                            
  uint32_t mv_mode2       : 3;                             
  uint32_t mv_table       : 3;                                  
  uint32_t two_mv_block_pattern_table: 2;                              
  uint32_t four_mv_switch     : 1;                               
  uint32_t four_mv_block_pattern_table : 2;                              
  uint32_t extended_mv_flag   : 1;                                     
  uint32_t extended_mv_range  : 2;                             
  uint32_t extended_dmv_flag  : 1;                                      
  uint32_t extended_dmv_range : 2;                              
} _VAPictureParameterBufferVC1_mv_fields_bits;

typedef struct {
  uint32_t reference_distance_flag : 1;                                 
  uint32_t reference_distance : 5;                            
  uint32_t num_reference_pictures: 1;                           
  uint32_t reference_field_pic_indicator  : 1;                             
} _VAPictureParameterBufferVC1_reference_fields_bits;

typedef struct {
//   uint32_t bp_mv_type_mb   : 1;                           
//   uint32_t bp_direct_mb    : 1;                           
//   uint32_t bp_skip_mb      : 1;                         
  uint32_t bp_field_tx     : 1;                          
//   uint32_t bp_forward_mb   : 1;                            
  uint32_t bp_ac_pred      : 1;                         
  uint32_t bp_overflags    : 1;                            
} _VAPictureParameterBufferVC1_bitplane_present_flags;

typedef struct {
//   uint32_t mv_type_mb : 1;                           
//   uint32_t direct_mb  : 1;                           
//   uint32_t skip_mb    : 1;                         
  uint32_t field_tx   : 1;                          
//   uint32_t forward_mb : 1;                            
  uint32_t ac_pred    : 1;                         
  uint32_t overflags  : 1;                            
} _VAPictureParameterBufferVC1_raw_coding_flags;

typedef struct {
  uint32_t picture_type       : 3;                           
  uint32_t frame_coding_mode  : 3;                         
  uint32_t top_field_first    : 1;                         
  uint32_t is_first_field     : 1;                                        
  uint32_t intensity_compensation : 1;                             
} _VAPictureParameterBufferVC1_picture_fields_bits;

typedef struct {
  uint32_t luma_flag  : 1;                                         
  uint32_t luma       : 3;                                    
  uint32_t chroma_flag    : 1;                                          
  uint32_t chroma     : 3;                                     
} _VAPictureParameterBufferVC1_range_mapping_fields_bits;

typedef struct {
  uint32_t broken_link    : 1;                                     
  uint32_t closed_entry   : 1;                                      
  uint32_t panscan_flag   : 1;                                      
  uint32_t loopfilter : 1;                                    
} _VAPictureParameterBufferVC1_entrypoint_fields_bits;

typedef struct {
  uint32_t pulldown   : 1;                               
  uint32_t interlace  : 1;                                
  uint32_t tfcntrflag : 1;                                 
  uint32_t finterpflag    : 1;                                  
  uint32_t psf        : 1;                          
  uint32_t multires   : 1;                         
  uint32_t overlap    : 1;                        
  uint32_t syncmarker : 1;                           
  uint32_t rangered   : 1;                         
  uint32_t max_b_frames   : 3;                           
  uint32_t profile    : 2;                                                              
} _VAPictureParameterBufferVC1_sequence_fields_bits;

typedef union {
  struct {
    uint32_t chroma_format_idc          : 2;
    uint32_t residual_colour_transform_flag     : 1;                                                                        
    uint32_t gaps_in_frame_num_value_allowed_flag   : 1;
//     uint32_t frame_mbs_only_flag            : 1;
    uint32_t mb_adaptive_frame_field_flag       : 1;
    uint32_t direct_8x8_inference_flag      : 1;
    uint32_t MinLumaBiPredSize8x8           : 1;                  
    uint32_t log2_max_frame_num_minus4      : 4;
    uint32_t pic_order_cnt_type         : 2;
    uint32_t log2_max_pic_order_cnt_lsb_minus4  : 4;
    uint32_t delta_pic_order_always_zero_flag   : 1;
  } bits;
  uint32_t value;
} _VAPictureParameterBufferH264_seq_fields;

typedef union {
  struct {
    uint32_t entropy_coding_mode_flag   : 1;
    uint32_t weighted_pred_flag     : 1;
    uint32_t weighted_bipred_idc        : 2;
    uint32_t transform_8x8_mode_flag    : 1;
    uint32_t field_pic_flag         : 1;
    uint32_t constrained_intra_pred_flag    : 1;
    uint32_t pic_order_present_flag         : 1;                                                                                          
    uint32_t deblocking_filter_control_present_flag : 1;
    uint32_t redundant_pic_cnt_present_flag     : 1;
    uint32_t reference_pic_flag         : 1;                       
  } bits;
  uint32_t value;
} _VAPictureParameterBufferH264_pic_fields;

typedef struct {
  uint32_t entropy_coding_mode_flag   : 1;
  uint32_t weighted_pred_flag     : 1;
  uint32_t weighted_bipred_idc        : 2;
  uint32_t transform_8x8_mode_flag    : 1;
  uint32_t field_pic_flag         : 1;
  uint32_t constrained_intra_pred_flag    : 1;
  uint32_t pic_order_present_flag         : 1;                                                                                          
  uint32_t deblocking_filter_control_present_flag : 1;
  uint32_t redundant_pic_cnt_present_flag     : 1;
  uint32_t reference_pic_flag         : 1;                       
} _VAPictureParameterBufferH264_pic_fields_bits;

typedef struct {
  uint32_t chroma_format_idc          : 2;
  uint32_t residual_colour_transform_flag     : 1;                                                                        
  uint32_t gaps_in_frame_num_value_allowed_flag   : 1;
//   uint32_t frame_mbs_only_flag            : 1;
  uint32_t mb_adaptive_frame_field_flag       : 1;
  uint32_t direct_8x8_inference_flag      : 1;
  uint32_t MinLumaBiPredSize8x8           : 1;                  
  uint32_t log2_max_frame_num_minus4      : 4;
  uint32_t pic_order_cnt_type         : 2;
  uint32_t log2_max_pic_order_cnt_lsb_minus4  : 4;
  uint32_t delta_pic_order_always_zero_flag   : 1;
} _VAPictureParameterBufferH264_seq_fields_bits;

typedef union {
  struct {
    uint32_t is_intra   : 1;
    uint32_t disable_deblocking_filter_idc : 2;
    uint32_t uses_long_term_ref     : 1;
    uint32_t is_long_term_ref       : 1;
  } bits;
  uint32_t value;
} _VAEncSliceParameterBuffer_slice_flags;

typedef struct {
  uint32_t is_intra   : 1;
  uint32_t disable_deblocking_filter_idc : 2;
  uint32_t uses_long_term_ref     : 1;
  uint32_t is_long_term_ref       : 1;
} _VAEncSliceParameterBuffer_slice_flags_bits;

typedef struct {
  uint32_t current_sub_device     : 4;
  
  uint32_t sub_device_count       : 4;
  
  uint32_t reserved               : 8;
  
  uint32_t sub_device_mask       : 16;
} _VADisplayAttribValSubDevice_bits;

typedef union {
  VASurfaceID surface_id;
  VABufferID  buffer_id;
} _VACopyObject_object;

typedef struct {
  uint32_t va_copy_sync : 2;
  
  uint32_t va_copy_mode : 4;
  uint32_t reserved     : 26;
} _VACopyOption_bits;


	swigNewline();

	swigComment("----===< prefix >===-----\n");

	swigPrint( "c-library va\ns\" va\" add-lib\n\\c #include <va/va.h>\n\\c #include <va/va_vpp.h>\n\\c #include <va/va_backend.h>", "( none )", "( none )" );

	swigNewline();

	swigComment("----===< int constants >===-----\n");
	#ifdef VA_STATUS_SUCCESS
		swigIntConstant( VA_STATUS_SUCCESS, "VA_STATUS_SUCCESS" );
	#endif
	#ifdef VA_STATUS_ERROR_OPERATION_FAILED
		swigIntConstant( VA_STATUS_ERROR_OPERATION_FAILED, "VA_STATUS_ERROR_OPERATION_FAILED" );
	#endif
	#ifdef VA_STATUS_ERROR_ALLOCATION_FAILED
		swigIntConstant( VA_STATUS_ERROR_ALLOCATION_FAILED, "VA_STATUS_ERROR_ALLOCATION_FAILED" );
	#endif
	#ifdef VA_STATUS_ERROR_INVALID_DISPLAY
		swigIntConstant( VA_STATUS_ERROR_INVALID_DISPLAY, "VA_STATUS_ERROR_INVALID_DISPLAY" );
	#endif
	#ifdef VA_STATUS_ERROR_INVALID_CONFIG
		swigIntConstant( VA_STATUS_ERROR_INVALID_CONFIG, "VA_STATUS_ERROR_INVALID_CONFIG" );
	#endif
	#ifdef VA_STATUS_ERROR_INVALID_CONTEXT
		swigIntConstant( VA_STATUS_ERROR_INVALID_CONTEXT, "VA_STATUS_ERROR_INVALID_CONTEXT" );
	#endif
	#ifdef VA_STATUS_ERROR_INVALID_SURFACE
		swigIntConstant( VA_STATUS_ERROR_INVALID_SURFACE, "VA_STATUS_ERROR_INVALID_SURFACE" );
	#endif
	#ifdef VA_STATUS_ERROR_INVALID_BUFFER
		swigIntConstant( VA_STATUS_ERROR_INVALID_BUFFER, "VA_STATUS_ERROR_INVALID_BUFFER" );
	#endif
	#ifdef VA_STATUS_ERROR_INVALID_IMAGE
		swigIntConstant( VA_STATUS_ERROR_INVALID_IMAGE, "VA_STATUS_ERROR_INVALID_IMAGE" );
	#endif
	#ifdef VA_STATUS_ERROR_INVALID_SUBPICTURE
		swigIntConstant( VA_STATUS_ERROR_INVALID_SUBPICTURE, "VA_STATUS_ERROR_INVALID_SUBPICTURE" );
	#endif
	#ifdef VA_STATUS_ERROR_ATTR_NOT_SUPPORTED
		swigIntConstant( VA_STATUS_ERROR_ATTR_NOT_SUPPORTED, "VA_STATUS_ERROR_ATTR_NOT_SUPPORTED" );
	#endif
	#ifdef VA_STATUS_ERROR_MAX_NUM_EXCEEDED
		swigIntConstant( VA_STATUS_ERROR_MAX_NUM_EXCEEDED, "VA_STATUS_ERROR_MAX_NUM_EXCEEDED" );
	#endif
	#ifdef VA_STATUS_ERROR_UNSUPPORTED_PROFILE
		swigIntConstant( VA_STATUS_ERROR_UNSUPPORTED_PROFILE, "VA_STATUS_ERROR_UNSUPPORTED_PROFILE" );
	#endif
	#ifdef VA_STATUS_ERROR_UNSUPPORTED_ENTRYPOINT
		swigIntConstant( VA_STATUS_ERROR_UNSUPPORTED_ENTRYPOINT, "VA_STATUS_ERROR_UNSUPPORTED_ENTRYPOINT" );
	#endif
	#ifdef VA_STATUS_ERROR_UNSUPPORTED_RT_FORMAT
		swigIntConstant( VA_STATUS_ERROR_UNSUPPORTED_RT_FORMAT, "VA_STATUS_ERROR_UNSUPPORTED_RT_FORMAT" );
	#endif
	#ifdef VA_STATUS_ERROR_UNSUPPORTED_BUFFERTYPE
		swigIntConstant( VA_STATUS_ERROR_UNSUPPORTED_BUFFERTYPE, "VA_STATUS_ERROR_UNSUPPORTED_BUFFERTYPE" );
	#endif
	#ifdef VA_STATUS_ERROR_SURFACE_BUSY
		swigIntConstant( VA_STATUS_ERROR_SURFACE_BUSY, "VA_STATUS_ERROR_SURFACE_BUSY" );
	#endif
	#ifdef VA_STATUS_ERROR_FLAG_NOT_SUPPORTED
		swigIntConstant( VA_STATUS_ERROR_FLAG_NOT_SUPPORTED, "VA_STATUS_ERROR_FLAG_NOT_SUPPORTED" );
	#endif
	#ifdef VA_STATUS_ERROR_INVALID_PARAMETER
		swigIntConstant( VA_STATUS_ERROR_INVALID_PARAMETER, "VA_STATUS_ERROR_INVALID_PARAMETER" );
	#endif
	#ifdef VA_STATUS_ERROR_RESOLUTION_NOT_SUPPORTED
		swigIntConstant( VA_STATUS_ERROR_RESOLUTION_NOT_SUPPORTED, "VA_STATUS_ERROR_RESOLUTION_NOT_SUPPORTED" );
	#endif
	#ifdef VA_STATUS_ERROR_UNIMPLEMENTED
		swigIntConstant( VA_STATUS_ERROR_UNIMPLEMENTED, "VA_STATUS_ERROR_UNIMPLEMENTED" );
	#endif
	#ifdef VA_STATUS_ERROR_SURFACE_IN_DISPLAYING
		swigIntConstant( VA_STATUS_ERROR_SURFACE_IN_DISPLAYING, "VA_STATUS_ERROR_SURFACE_IN_DISPLAYING" );
	#endif
	#ifdef VA_STATUS_ERROR_INVALID_IMAGE_FORMAT
		swigIntConstant( VA_STATUS_ERROR_INVALID_IMAGE_FORMAT, "VA_STATUS_ERROR_INVALID_IMAGE_FORMAT" );
	#endif
	#ifdef VA_STATUS_ERROR_DECODING_ERROR
		swigIntConstant( VA_STATUS_ERROR_DECODING_ERROR, "VA_STATUS_ERROR_DECODING_ERROR" );
	#endif
	#ifdef VA_STATUS_ERROR_ENCODING_ERROR
		swigIntConstant( VA_STATUS_ERROR_ENCODING_ERROR, "VA_STATUS_ERROR_ENCODING_ERROR" );
	#endif
	#ifdef VA_STATUS_ERROR_INVALID_VALUE
		swigIntConstant( VA_STATUS_ERROR_INVALID_VALUE, "VA_STATUS_ERROR_INVALID_VALUE" );
	#endif
	#ifdef VA_STATUS_ERROR_UNSUPPORTED_FILTER
		swigIntConstant( VA_STATUS_ERROR_UNSUPPORTED_FILTER, "VA_STATUS_ERROR_UNSUPPORTED_FILTER" );
	#endif
	#ifdef VA_STATUS_ERROR_INVALID_FILTER_CHAIN
		swigIntConstant( VA_STATUS_ERROR_INVALID_FILTER_CHAIN, "VA_STATUS_ERROR_INVALID_FILTER_CHAIN" );
	#endif
	#ifdef VA_STATUS_ERROR_HW_BUSY
		swigIntConstant( VA_STATUS_ERROR_HW_BUSY, "VA_STATUS_ERROR_HW_BUSY" );
	#endif
	#ifdef VA_STATUS_ERROR_UNSUPPORTED_MEMORY_TYPE
		swigIntConstant( VA_STATUS_ERROR_UNSUPPORTED_MEMORY_TYPE, "VA_STATUS_ERROR_UNSUPPORTED_MEMORY_TYPE" );
	#endif
	#ifdef VA_STATUS_ERROR_NOT_ENOUGH_BUFFER
		swigIntConstant( VA_STATUS_ERROR_NOT_ENOUGH_BUFFER, "VA_STATUS_ERROR_NOT_ENOUGH_BUFFER" );
	#endif
	#ifdef VA_STATUS_ERROR_TIMEDOUT
		swigIntConstant( VA_STATUS_ERROR_TIMEDOUT, "VA_STATUS_ERROR_TIMEDOUT" );
	#endif
	#ifdef VA_STATUS_ERROR_UNKNOWN
		swigIntConstant( VA_STATUS_ERROR_UNKNOWN, "VA_STATUS_ERROR_UNKNOWN" );
	#endif
	#ifdef VA_FRAME_PICTURE
		swigIntConstant( VA_FRAME_PICTURE, "VA_FRAME_PICTURE" );
	#endif
	#ifdef VA_TOP_FIELD
		swigIntConstant( VA_TOP_FIELD, "VA_TOP_FIELD" );
	#endif
	#ifdef VA_BOTTOM_FIELD
		swigIntConstant( VA_BOTTOM_FIELD, "VA_BOTTOM_FIELD" );
	#endif
	#ifdef VA_TOP_FIELD_FIRST
		swigIntConstant( VA_TOP_FIELD_FIRST, "VA_TOP_FIELD_FIRST" );
	#endif
	#ifdef VA_BOTTOM_FIELD_FIRST
		swigIntConstant( VA_BOTTOM_FIELD_FIRST, "VA_BOTTOM_FIELD_FIRST" );
	#endif
	#ifdef VA_ENABLE_BLEND
		swigIntConstant( VA_ENABLE_BLEND, "VA_ENABLE_BLEND" );
	#endif
	#ifdef VA_CLEAR_DRAWABLE
		swigIntConstant( VA_CLEAR_DRAWABLE, "VA_CLEAR_DRAWABLE" );
	#endif
	#ifdef VA_SRC_COLOR_MASK
		swigIntConstant( VA_SRC_COLOR_MASK, "VA_SRC_COLOR_MASK" );
	#endif
	#ifdef VA_SRC_BT601
		swigIntConstant( VA_SRC_BT601, "VA_SRC_BT601" );
	#endif
	#ifdef VA_SRC_BT709
		swigIntConstant( VA_SRC_BT709, "VA_SRC_BT709" );
	#endif
	#ifdef VA_SRC_SMPTE_240
		swigIntConstant( VA_SRC_SMPTE_240, "VA_SRC_SMPTE_240" );
	#endif
	#ifdef VA_FILTER_SCALING_DEFAULT
		swigIntConstant( VA_FILTER_SCALING_DEFAULT, "VA_FILTER_SCALING_DEFAULT" );
	#endif
	#ifdef VA_FILTER_SCALING_FAST
		swigIntConstant( VA_FILTER_SCALING_FAST, "VA_FILTER_SCALING_FAST" );
	#endif
	#ifdef VA_FILTER_SCALING_HQ
		swigIntConstant( VA_FILTER_SCALING_HQ, "VA_FILTER_SCALING_HQ" );
	#endif
	#ifdef VA_FILTER_SCALING_NL_ANAMORPHIC
		swigIntConstant( VA_FILTER_SCALING_NL_ANAMORPHIC, "VA_FILTER_SCALING_NL_ANAMORPHIC" );
	#endif
	#ifdef VA_FILTER_SCALING_MASK
		swigIntConstant( VA_FILTER_SCALING_MASK, "VA_FILTER_SCALING_MASK" );
	#endif
	#ifdef VA_FILTER_INTERPOLATION_DEFAULT
		swigIntConstant( VA_FILTER_INTERPOLATION_DEFAULT, "VA_FILTER_INTERPOLATION_DEFAULT" );
	#endif
	#ifdef VA_FILTER_INTERPOLATION_NEAREST_NEIGHBOR
		swigIntConstant( VA_FILTER_INTERPOLATION_NEAREST_NEIGHBOR, "VA_FILTER_INTERPOLATION_NEAREST_NEIGHBOR" );
	#endif
	#ifdef VA_FILTER_INTERPOLATION_BILINEAR
		swigIntConstant( VA_FILTER_INTERPOLATION_BILINEAR, "VA_FILTER_INTERPOLATION_BILINEAR" );
	#endif
	#ifdef VA_FILTER_INTERPOLATION_ADVANCED
		swigIntConstant( VA_FILTER_INTERPOLATION_ADVANCED, "VA_FILTER_INTERPOLATION_ADVANCED" );
	#endif
	#ifdef VA_FILTER_INTERPOLATION_MASK
		swigIntConstant( VA_FILTER_INTERPOLATION_MASK, "VA_FILTER_INTERPOLATION_MASK" );
	#endif
	#ifdef VA_PADDING_LOW
		swigIntConstant( VA_PADDING_LOW, "VA_PADDING_LOW" );
	#endif
	#ifdef VA_PADDING_MEDIUM
		swigIntConstant( VA_PADDING_MEDIUM, "VA_PADDING_MEDIUM" );
	#endif
	#ifdef VA_PADDING_HIGH
		swigIntConstant( VA_PADDING_HIGH, "VA_PADDING_HIGH" );
	#endif
	#ifdef VA_PADDING_LARGE
		swigIntConstant( VA_PADDING_LARGE, "VA_PADDING_LARGE" );
	#endif
	#ifdef VA_EXEC_SYNC
		swigIntConstant( VA_EXEC_SYNC, "VA_EXEC_SYNC" );
	#endif
	#ifdef VA_EXEC_ASYNC
		swigIntConstant( VA_EXEC_ASYNC, "VA_EXEC_ASYNC" );
	#endif
	#ifdef VA_EXEC_MODE_DEFAULT
		swigIntConstant( VA_EXEC_MODE_DEFAULT, "VA_EXEC_MODE_DEFAULT" );
	#endif
	#ifdef VA_EXEC_MODE_POWER_SAVING
		swigIntConstant( VA_EXEC_MODE_POWER_SAVING, "VA_EXEC_MODE_POWER_SAVING" );
	#endif
	#ifdef VA_EXEC_MODE_PERFORMANCE
		swigIntConstant( VA_EXEC_MODE_PERFORMANCE, "VA_EXEC_MODE_PERFORMANCE" );
	#endif
	#ifdef VA_FEATURE_NOT_SUPPORTED
		swigIntConstant( VA_FEATURE_NOT_SUPPORTED, "VA_FEATURE_NOT_SUPPORTED" );
	#endif
	#ifdef VA_FEATURE_SUPPORTED
		swigIntConstant( VA_FEATURE_SUPPORTED, "VA_FEATURE_SUPPORTED" );
	#endif
	#ifdef VA_FEATURE_REQUIRED
		swigIntConstant( VA_FEATURE_REQUIRED, "VA_FEATURE_REQUIRED" );
	#endif
	#ifdef VA_RT_FORMAT_YUV420
		swigIntConstant( VA_RT_FORMAT_YUV420, "VA_RT_FORMAT_YUV420" );
	#endif
	#ifdef VA_RT_FORMAT_YUV422
		swigIntConstant( VA_RT_FORMAT_YUV422, "VA_RT_FORMAT_YUV422" );
	#endif
	#ifdef VA_RT_FORMAT_YUV444
		swigIntConstant( VA_RT_FORMAT_YUV444, "VA_RT_FORMAT_YUV444" );
	#endif
	#ifdef VA_RT_FORMAT_YUV411
		swigIntConstant( VA_RT_FORMAT_YUV411, "VA_RT_FORMAT_YUV411" );
	#endif
	#ifdef VA_RT_FORMAT_YUV400
		swigIntConstant( VA_RT_FORMAT_YUV400, "VA_RT_FORMAT_YUV400" );
	#endif
	#ifdef VA_RT_FORMAT_YUV420_10
		swigIntConstant( VA_RT_FORMAT_YUV420_10, "VA_RT_FORMAT_YUV420_10" );
	#endif
	#ifdef VA_RT_FORMAT_YUV422_10
		swigIntConstant( VA_RT_FORMAT_YUV422_10, "VA_RT_FORMAT_YUV422_10" );
	#endif
	#ifdef VA_RT_FORMAT_YUV444_10
		swigIntConstant( VA_RT_FORMAT_YUV444_10, "VA_RT_FORMAT_YUV444_10" );
	#endif
	#ifdef VA_RT_FORMAT_YUV420_12
		swigIntConstant( VA_RT_FORMAT_YUV420_12, "VA_RT_FORMAT_YUV420_12" );
	#endif
	#ifdef VA_RT_FORMAT_YUV422_12
		swigIntConstant( VA_RT_FORMAT_YUV422_12, "VA_RT_FORMAT_YUV422_12" );
	#endif
	#ifdef VA_RT_FORMAT_YUV444_12
		swigIntConstant( VA_RT_FORMAT_YUV444_12, "VA_RT_FORMAT_YUV444_12" );
	#endif
	#ifdef VA_RT_FORMAT_RGB16
		swigIntConstant( VA_RT_FORMAT_RGB16, "VA_RT_FORMAT_RGB16" );
	#endif
	#ifdef VA_RT_FORMAT_RGB32
		swigIntConstant( VA_RT_FORMAT_RGB32, "VA_RT_FORMAT_RGB32" );
	#endif
	#ifdef VA_RT_FORMAT_RGBP
		swigIntConstant( VA_RT_FORMAT_RGBP, "VA_RT_FORMAT_RGBP" );
	#endif
	#ifdef VA_RT_FORMAT_RGB32_10
		swigIntConstant( VA_RT_FORMAT_RGB32_10, "VA_RT_FORMAT_RGB32_10" );
	#endif
	#ifdef VA_RT_FORMAT_PROTECTED
		swigIntConstant( VA_RT_FORMAT_PROTECTED, "VA_RT_FORMAT_PROTECTED" );
	#endif
	#ifdef VA_RT_FORMAT_RGB32_10BPP
		swigIntConstant( VA_RT_FORMAT_RGB32_10BPP, "VA_RT_FORMAT_RGB32_10BPP" );
	#endif
	#ifdef VA_RT_FORMAT_YUV420_10BPP
		swigIntConstant( VA_RT_FORMAT_YUV420_10BPP, "VA_RT_FORMAT_YUV420_10BPP" );
	#endif
	#ifdef VA_RC_NONE
		swigIntConstant( VA_RC_NONE, "VA_RC_NONE" );
	#endif
	#ifdef VA_RC_CBR
		swigIntConstant( VA_RC_CBR, "VA_RC_CBR" );
	#endif
	#ifdef VA_RC_VBR
		swigIntConstant( VA_RC_VBR, "VA_RC_VBR" );
	#endif
	#ifdef VA_RC_VCM
		swigIntConstant( VA_RC_VCM, "VA_RC_VCM" );
	#endif
	#ifdef VA_RC_CQP
		swigIntConstant( VA_RC_CQP, "VA_RC_CQP" );
	#endif
	#ifdef VA_RC_VBR_CONSTRAINED
		swigIntConstant( VA_RC_VBR_CONSTRAINED, "VA_RC_VBR_CONSTRAINED" );
	#endif
	#ifdef VA_RC_ICQ
		swigIntConstant( VA_RC_ICQ, "VA_RC_ICQ" );
	#endif
	#ifdef VA_RC_MB
		swigIntConstant( VA_RC_MB, "VA_RC_MB" );
	#endif
	#ifdef VA_RC_CFS
		swigIntConstant( VA_RC_CFS, "VA_RC_CFS" );
	#endif
	#ifdef VA_RC_PARALLEL
		swigIntConstant( VA_RC_PARALLEL, "VA_RC_PARALLEL" );
	#endif
	#ifdef VA_RC_QVBR
		swigIntConstant( VA_RC_QVBR, "VA_RC_QVBR" );
	#endif
	#ifdef VA_RC_AVBR
		swigIntConstant( VA_RC_AVBR, "VA_RC_AVBR" );
	#endif
	#ifdef VA_RC_TCBRC
		swigIntConstant( VA_RC_TCBRC, "VA_RC_TCBRC" );
	#endif
	#ifdef VA_DEC_SLICE_MODE_NORMAL
		swigIntConstant( VA_DEC_SLICE_MODE_NORMAL, "VA_DEC_SLICE_MODE_NORMAL" );
	#endif
	#ifdef VA_DEC_SLICE_MODE_BASE
		swigIntConstant( VA_DEC_SLICE_MODE_BASE, "VA_DEC_SLICE_MODE_BASE" );
	#endif
	#ifdef VA_DEC_PROCESSING_NONE
		swigIntConstant( VA_DEC_PROCESSING_NONE, "VA_DEC_PROCESSING_NONE" );
	#endif
	#ifdef VA_DEC_PROCESSING
		swigIntConstant( VA_DEC_PROCESSING, "VA_DEC_PROCESSING" );
	#endif
	#ifdef VA_ENC_PACKED_HEADER_NONE
		swigIntConstant( VA_ENC_PACKED_HEADER_NONE, "VA_ENC_PACKED_HEADER_NONE" );
	#endif
	#ifdef VA_ENC_PACKED_HEADER_SEQUENCE
		swigIntConstant( VA_ENC_PACKED_HEADER_SEQUENCE, "VA_ENC_PACKED_HEADER_SEQUENCE" );
	#endif
	#ifdef VA_ENC_PACKED_HEADER_PICTURE
		swigIntConstant( VA_ENC_PACKED_HEADER_PICTURE, "VA_ENC_PACKED_HEADER_PICTURE" );
	#endif
	#ifdef VA_ENC_PACKED_HEADER_SLICE
		swigIntConstant( VA_ENC_PACKED_HEADER_SLICE, "VA_ENC_PACKED_HEADER_SLICE" );
	#endif
	#ifdef VA_ENC_PACKED_HEADER_MISC
		swigIntConstant( VA_ENC_PACKED_HEADER_MISC, "VA_ENC_PACKED_HEADER_MISC" );
	#endif
	#ifdef VA_ENC_PACKED_HEADER_RAW_DATA
		swigIntConstant( VA_ENC_PACKED_HEADER_RAW_DATA, "VA_ENC_PACKED_HEADER_RAW_DATA" );
	#endif
	#ifdef VA_ENC_INTERLACED_NONE
		swigIntConstant( VA_ENC_INTERLACED_NONE, "VA_ENC_INTERLACED_NONE" );
	#endif
	#ifdef VA_ENC_INTERLACED_FRAME
		swigIntConstant( VA_ENC_INTERLACED_FRAME, "VA_ENC_INTERLACED_FRAME" );
	#endif
	#ifdef VA_ENC_INTERLACED_FIELD
		swigIntConstant( VA_ENC_INTERLACED_FIELD, "VA_ENC_INTERLACED_FIELD" );
	#endif
	#ifdef VA_ENC_INTERLACED_MBAFF
		swigIntConstant( VA_ENC_INTERLACED_MBAFF, "VA_ENC_INTERLACED_MBAFF" );
	#endif
	#ifdef VA_ENC_INTERLACED_PAFF
		swigIntConstant( VA_ENC_INTERLACED_PAFF, "VA_ENC_INTERLACED_PAFF" );
	#endif
	#ifdef VA_ENC_SLICE_STRUCTURE_POWER_OF_TWO_ROWS
		swigIntConstant( VA_ENC_SLICE_STRUCTURE_POWER_OF_TWO_ROWS, "VA_ENC_SLICE_STRUCTURE_POWER_OF_TWO_ROWS" );
	#endif
	#ifdef VA_ENC_SLICE_STRUCTURE_ARBITRARY_MACROBLOCKS
		swigIntConstant( VA_ENC_SLICE_STRUCTURE_ARBITRARY_MACROBLOCKS, "VA_ENC_SLICE_STRUCTURE_ARBITRARY_MACROBLOCKS" );
	#endif
	#ifdef VA_ENC_SLICE_STRUCTURE_EQUAL_ROWS
		swigIntConstant( VA_ENC_SLICE_STRUCTURE_EQUAL_ROWS, "VA_ENC_SLICE_STRUCTURE_EQUAL_ROWS" );
	#endif
	#ifdef VA_ENC_SLICE_STRUCTURE_MAX_SLICE_SIZE
		swigIntConstant( VA_ENC_SLICE_STRUCTURE_MAX_SLICE_SIZE, "VA_ENC_SLICE_STRUCTURE_MAX_SLICE_SIZE" );
	#endif
	#ifdef VA_ENC_SLICE_STRUCTURE_ARBITRARY_ROWS
		swigIntConstant( VA_ENC_SLICE_STRUCTURE_ARBITRARY_ROWS, "VA_ENC_SLICE_STRUCTURE_ARBITRARY_ROWS" );
	#endif
	#ifdef VA_ENC_SLICE_STRUCTURE_EQUAL_MULTI_ROWS
		swigIntConstant( VA_ENC_SLICE_STRUCTURE_EQUAL_MULTI_ROWS, "VA_ENC_SLICE_STRUCTURE_EQUAL_MULTI_ROWS" );
	#endif
	#ifdef VA_ENC_QUANTIZATION_NONE
		swigIntConstant( VA_ENC_QUANTIZATION_NONE, "VA_ENC_QUANTIZATION_NONE" );
	#endif
	#ifdef VA_ENC_QUANTIZATION_TRELLIS_SUPPORTED
		swigIntConstant( VA_ENC_QUANTIZATION_TRELLIS_SUPPORTED, "VA_ENC_QUANTIZATION_TRELLIS_SUPPORTED" );
	#endif
	#ifdef VA_PREDICTION_DIRECTION_PREVIOUS
		swigIntConstant( VA_PREDICTION_DIRECTION_PREVIOUS, "VA_PREDICTION_DIRECTION_PREVIOUS" );
	#endif
	#ifdef VA_PREDICTION_DIRECTION_FUTURE
		swigIntConstant( VA_PREDICTION_DIRECTION_FUTURE, "VA_PREDICTION_DIRECTION_FUTURE" );
	#endif
	#ifdef VA_PREDICTION_DIRECTION_BI_NOT_EMPTY
		swigIntConstant( VA_PREDICTION_DIRECTION_BI_NOT_EMPTY, "VA_PREDICTION_DIRECTION_BI_NOT_EMPTY" );
	#endif
	#ifdef VA_ENC_INTRA_REFRESH_NONE
		swigIntConstant( VA_ENC_INTRA_REFRESH_NONE, "VA_ENC_INTRA_REFRESH_NONE" );
	#endif
	#ifdef VA_ENC_INTRA_REFRESH_ROLLING_COLUMN
		swigIntConstant( VA_ENC_INTRA_REFRESH_ROLLING_COLUMN, "VA_ENC_INTRA_REFRESH_ROLLING_COLUMN" );
	#endif
	#ifdef VA_ENC_INTRA_REFRESH_ROLLING_ROW
		swigIntConstant( VA_ENC_INTRA_REFRESH_ROLLING_ROW, "VA_ENC_INTRA_REFRESH_ROLLING_ROW" );
	#endif
	#ifdef VA_ENC_INTRA_REFRESH_ADAPTIVE
		swigIntConstant( VA_ENC_INTRA_REFRESH_ADAPTIVE, "VA_ENC_INTRA_REFRESH_ADAPTIVE" );
	#endif
	#ifdef VA_ENC_INTRA_REFRESH_CYCLIC
		swigIntConstant( VA_ENC_INTRA_REFRESH_CYCLIC, "VA_ENC_INTRA_REFRESH_CYCLIC" );
	#endif
	#ifdef VA_ENC_INTRA_REFRESH_P_FRAME
		swigIntConstant( VA_ENC_INTRA_REFRESH_P_FRAME, "VA_ENC_INTRA_REFRESH_P_FRAME" );
	#endif
	#ifdef VA_ENC_INTRA_REFRESH_B_FRAME
		swigIntConstant( VA_ENC_INTRA_REFRESH_B_FRAME, "VA_ENC_INTRA_REFRESH_B_FRAME" );
	#endif
	#ifdef VA_ENC_INTRA_REFRESH_MULTI_REF
		swigIntConstant( VA_ENC_INTRA_REFRESH_MULTI_REF, "VA_ENC_INTRA_REFRESH_MULTI_REF" );
	#endif
	#ifdef VA_PC_CIPHER_AES
		swigIntConstant( VA_PC_CIPHER_AES, "VA_PC_CIPHER_AES" );
	#endif
	#ifdef VA_PC_BLOCK_SIZE_128
		swigIntConstant( VA_PC_BLOCK_SIZE_128, "VA_PC_BLOCK_SIZE_128" );
	#endif
	#ifdef VA_PC_BLOCK_SIZE_192
		swigIntConstant( VA_PC_BLOCK_SIZE_192, "VA_PC_BLOCK_SIZE_192" );
	#endif
	#ifdef VA_PC_BLOCK_SIZE_256
		swigIntConstant( VA_PC_BLOCK_SIZE_256, "VA_PC_BLOCK_SIZE_256" );
	#endif
	#ifdef VA_PC_CIPHER_MODE_ECB
		swigIntConstant( VA_PC_CIPHER_MODE_ECB, "VA_PC_CIPHER_MODE_ECB" );
	#endif
	#ifdef VA_PC_CIPHER_MODE_CBC
		swigIntConstant( VA_PC_CIPHER_MODE_CBC, "VA_PC_CIPHER_MODE_CBC" );
	#endif
	#ifdef VA_PC_CIPHER_MODE_CTR
		swigIntConstant( VA_PC_CIPHER_MODE_CTR, "VA_PC_CIPHER_MODE_CTR" );
	#endif
	#ifdef VA_PC_SAMPLE_TYPE_FULLSAMPLE
		swigIntConstant( VA_PC_SAMPLE_TYPE_FULLSAMPLE, "VA_PC_SAMPLE_TYPE_FULLSAMPLE" );
	#endif
	#ifdef VA_PC_SAMPLE_TYPE_SUBSAMPLE
		swigIntConstant( VA_PC_SAMPLE_TYPE_SUBSAMPLE, "VA_PC_SAMPLE_TYPE_SUBSAMPLE" );
	#endif
	#ifdef VA_PC_USAGE_DEFAULT
		swigIntConstant( VA_PC_USAGE_DEFAULT, "VA_PC_USAGE_DEFAULT" );
	#endif
	#ifdef VA_PC_USAGE_WIDEVINE
		swigIntConstant( VA_PC_USAGE_WIDEVINE, "VA_PC_USAGE_WIDEVINE" );
	#endif
	#ifdef VA_PROCESSING_RATE_NONE
		swigIntConstant( VA_PROCESSING_RATE_NONE, "VA_PROCESSING_RATE_NONE" );
	#endif
	#ifdef VA_PROCESSING_RATE_ENCODE
		swigIntConstant( VA_PROCESSING_RATE_ENCODE, "VA_PROCESSING_RATE_ENCODE" );
	#endif
	#ifdef VA_PROCESSING_RATE_DECODE
		swigIntConstant( VA_PROCESSING_RATE_DECODE, "VA_PROCESSING_RATE_DECODE" );
	#endif
	#ifdef VA_ATTRIB_NOT_SUPPORTED
		swigIntConstant( VA_ATTRIB_NOT_SUPPORTED, "VA_ATTRIB_NOT_SUPPORTED" );
	#endif
	#ifdef VA_INVALID_ID
		swigIntConstant( VA_INVALID_ID, "VA_INVALID_ID" );
	#endif
	#ifdef VA_INVALID_SURFACE
		swigIntConstant( VA_INVALID_SURFACE, "VA_INVALID_SURFACE" );
	#endif
	#ifdef VA_SURFACE_ATTRIB_NOT_SUPPORTED
		swigIntConstant( VA_SURFACE_ATTRIB_NOT_SUPPORTED, "VA_SURFACE_ATTRIB_NOT_SUPPORTED" );
	#endif
	#ifdef VA_SURFACE_ATTRIB_GETTABLE
		swigIntConstant( VA_SURFACE_ATTRIB_GETTABLE, "VA_SURFACE_ATTRIB_GETTABLE" );
	#endif
	#ifdef VA_SURFACE_ATTRIB_SETTABLE
		swigIntConstant( VA_SURFACE_ATTRIB_SETTABLE, "VA_SURFACE_ATTRIB_SETTABLE" );
	#endif
	#ifdef VA_SURFACE_ATTRIB_MEM_TYPE_VA
		swigIntConstant( VA_SURFACE_ATTRIB_MEM_TYPE_VA, "VA_SURFACE_ATTRIB_MEM_TYPE_VA" );
	#endif
	#ifdef VA_SURFACE_ATTRIB_MEM_TYPE_V4L2
		swigIntConstant( VA_SURFACE_ATTRIB_MEM_TYPE_V4L2, "VA_SURFACE_ATTRIB_MEM_TYPE_V4L2" );
	#endif
	#ifdef VA_SURFACE_ATTRIB_MEM_TYPE_USER_PTR
		swigIntConstant( VA_SURFACE_ATTRIB_MEM_TYPE_USER_PTR, "VA_SURFACE_ATTRIB_MEM_TYPE_USER_PTR" );
	#endif
	#ifdef VA_SURFACE_EXTBUF_DESC_ENABLE_TILING
		swigIntConstant( VA_SURFACE_EXTBUF_DESC_ENABLE_TILING, "VA_SURFACE_EXTBUF_DESC_ENABLE_TILING" );
	#endif
	#ifdef VA_SURFACE_EXTBUF_DESC_CACHED
		swigIntConstant( VA_SURFACE_EXTBUF_DESC_CACHED, "VA_SURFACE_EXTBUF_DESC_CACHED" );
	#endif
	#ifdef VA_SURFACE_EXTBUF_DESC_UNCACHED
		swigIntConstant( VA_SURFACE_EXTBUF_DESC_UNCACHED, "VA_SURFACE_EXTBUF_DESC_UNCACHED" );
	#endif
	#ifdef VA_SURFACE_EXTBUF_DESC_WC
		swigIntConstant( VA_SURFACE_EXTBUF_DESC_WC, "VA_SURFACE_EXTBUF_DESC_WC" );
	#endif
	#ifdef VA_SURFACE_EXTBUF_DESC_PROTECTED
		swigIntConstant( VA_SURFACE_EXTBUF_DESC_PROTECTED, "VA_SURFACE_EXTBUF_DESC_PROTECTED" );
	#endif
	#ifdef VA_SURFACE_ATTRIB_USAGE_HINT_GENERIC
		swigIntConstant( VA_SURFACE_ATTRIB_USAGE_HINT_GENERIC, "VA_SURFACE_ATTRIB_USAGE_HINT_GENERIC" );
	#endif
	#ifdef VA_SURFACE_ATTRIB_USAGE_HINT_DECODER
		swigIntConstant( VA_SURFACE_ATTRIB_USAGE_HINT_DECODER, "VA_SURFACE_ATTRIB_USAGE_HINT_DECODER" );
	#endif
	#ifdef VA_SURFACE_ATTRIB_USAGE_HINT_ENCODER
		swigIntConstant( VA_SURFACE_ATTRIB_USAGE_HINT_ENCODER, "VA_SURFACE_ATTRIB_USAGE_HINT_ENCODER" );
	#endif
	#ifdef VA_SURFACE_ATTRIB_USAGE_HINT_VPP_READ
		swigIntConstant( VA_SURFACE_ATTRIB_USAGE_HINT_VPP_READ, "VA_SURFACE_ATTRIB_USAGE_HINT_VPP_READ" );
	#endif
	#ifdef VA_SURFACE_ATTRIB_USAGE_HINT_VPP_WRITE
		swigIntConstant( VA_SURFACE_ATTRIB_USAGE_HINT_VPP_WRITE, "VA_SURFACE_ATTRIB_USAGE_HINT_VPP_WRITE" );
	#endif
	#ifdef VA_SURFACE_ATTRIB_USAGE_HINT_DISPLAY
		swigIntConstant( VA_SURFACE_ATTRIB_USAGE_HINT_DISPLAY, "VA_SURFACE_ATTRIB_USAGE_HINT_DISPLAY" );
	#endif
	#ifdef VA_SURFACE_ATTRIB_USAGE_HINT_EXPORT
		swigIntConstant( VA_SURFACE_ATTRIB_USAGE_HINT_EXPORT, "VA_SURFACE_ATTRIB_USAGE_HINT_EXPORT" );
	#endif
	#ifdef VA_PROGRESSIVE
		swigIntConstant( VA_PROGRESSIVE, "VA_PROGRESSIVE" );
	#endif
	#ifdef VA_ENCRYPTION_TYPE_FULLSAMPLE_CTR
		swigIntConstant( VA_ENCRYPTION_TYPE_FULLSAMPLE_CTR, "VA_ENCRYPTION_TYPE_FULLSAMPLE_CTR" );
	#endif
	#ifdef VA_ENCRYPTION_TYPE_FULLSAMPLE_CBC
		swigIntConstant( VA_ENCRYPTION_TYPE_FULLSAMPLE_CBC, "VA_ENCRYPTION_TYPE_FULLSAMPLE_CBC" );
	#endif
	#ifdef VA_ENCRYPTION_TYPE_SUBSAMPLE_CTR
		swigIntConstant( VA_ENCRYPTION_TYPE_SUBSAMPLE_CTR, "VA_ENCRYPTION_TYPE_SUBSAMPLE_CTR" );
	#endif
	#ifdef VA_ENCRYPTION_TYPE_SUBSAMPLE_CBC
		swigIntConstant( VA_ENCRYPTION_TYPE_SUBSAMPLE_CBC, "VA_ENCRYPTION_TYPE_SUBSAMPLE_CBC" );
	#endif
	#ifdef VA_SLICE_DATA_FLAG_ALL
		swigIntConstant( VA_SLICE_DATA_FLAG_ALL, "VA_SLICE_DATA_FLAG_ALL" );
	#endif
	#ifdef VA_SLICE_DATA_FLAG_BEGIN
		swigIntConstant( VA_SLICE_DATA_FLAG_BEGIN, "VA_SLICE_DATA_FLAG_BEGIN" );
	#endif
	#ifdef VA_SLICE_DATA_FLAG_MIDDLE
		swigIntConstant( VA_SLICE_DATA_FLAG_MIDDLE, "VA_SLICE_DATA_FLAG_MIDDLE" );
	#endif
	#ifdef VA_SLICE_DATA_FLAG_END
		swigIntConstant( VA_SLICE_DATA_FLAG_END, "VA_SLICE_DATA_FLAG_END" );
	#endif
	#ifdef VA_MB_TYPE_MOTION_FORWARD
		swigIntConstant( VA_MB_TYPE_MOTION_FORWARD, "VA_MB_TYPE_MOTION_FORWARD" );
	#endif
	#ifdef VA_MB_TYPE_MOTION_BACKWARD
		swigIntConstant( VA_MB_TYPE_MOTION_BACKWARD, "VA_MB_TYPE_MOTION_BACKWARD" );
	#endif
	#ifdef VA_MB_TYPE_MOTION_PATTERN
		swigIntConstant( VA_MB_TYPE_MOTION_PATTERN, "VA_MB_TYPE_MOTION_PATTERN" );
	#endif
	#ifdef VA_MB_TYPE_MOTION_INTRA
		swigIntConstant( VA_MB_TYPE_MOTION_INTRA, "VA_MB_TYPE_MOTION_INTRA" );
	#endif
	#ifdef VA_PICTURE_H264_INVALID
		swigIntConstant( VA_PICTURE_H264_INVALID, "VA_PICTURE_H264_INVALID" );
	#endif
	#ifdef VA_PICTURE_H264_TOP_FIELD
		swigIntConstant( VA_PICTURE_H264_TOP_FIELD, "VA_PICTURE_H264_TOP_FIELD" );
	#endif
	#ifdef VA_PICTURE_H264_BOTTOM_FIELD
		swigIntConstant( VA_PICTURE_H264_BOTTOM_FIELD, "VA_PICTURE_H264_BOTTOM_FIELD" );
	#endif
	#ifdef VA_PICTURE_H264_SHORT_TERM_REFERENCE
		swigIntConstant( VA_PICTURE_H264_SHORT_TERM_REFERENCE, "VA_PICTURE_H264_SHORT_TERM_REFERENCE" );
	#endif
	#ifdef VA_PICTURE_H264_LONG_TERM_REFERENCE
		swigIntConstant( VA_PICTURE_H264_LONG_TERM_REFERENCE, "VA_PICTURE_H264_LONG_TERM_REFERENCE" );
	#endif
	#ifdef VA_CODED_BUF_STATUS_PICTURE_AVE_QP_MASK
		swigIntConstant( VA_CODED_BUF_STATUS_PICTURE_AVE_QP_MASK, "VA_CODED_BUF_STATUS_PICTURE_AVE_QP_MASK" );
	#endif
	#ifdef VA_CODED_BUF_STATUS_LARGE_SLICE_MASK
		swigIntConstant( VA_CODED_BUF_STATUS_LARGE_SLICE_MASK, "VA_CODED_BUF_STATUS_LARGE_SLICE_MASK" );
	#endif
	#ifdef VA_CODED_BUF_STATUS_SLICE_OVERFLOW_MASK
		swigIntConstant( VA_CODED_BUF_STATUS_SLICE_OVERFLOW_MASK, "VA_CODED_BUF_STATUS_SLICE_OVERFLOW_MASK" );
	#endif
	#ifdef VA_CODED_BUF_STATUS_BITRATE_OVERFLOW
		swigIntConstant( VA_CODED_BUF_STATUS_BITRATE_OVERFLOW, "VA_CODED_BUF_STATUS_BITRATE_OVERFLOW" );
	#endif
	#ifdef VA_CODED_BUF_STATUS_BITRATE_HIGH
		swigIntConstant( VA_CODED_BUF_STATUS_BITRATE_HIGH, "VA_CODED_BUF_STATUS_BITRATE_HIGH" );
	#endif
	#ifdef VA_CODED_BUF_STATUS_FRAME_SIZE_OVERFLOW
		swigIntConstant( VA_CODED_BUF_STATUS_FRAME_SIZE_OVERFLOW, "VA_CODED_BUF_STATUS_FRAME_SIZE_OVERFLOW" );
	#endif
	#ifdef VA_CODED_BUF_STATUS_BAD_BITSTREAM
		swigIntConstant( VA_CODED_BUF_STATUS_BAD_BITSTREAM, "VA_CODED_BUF_STATUS_BAD_BITSTREAM" );
	#endif
	#ifdef VA_CODED_BUF_STATUS_AIR_MB_OVER_THRESHOLD
		swigIntConstant( VA_CODED_BUF_STATUS_AIR_MB_OVER_THRESHOLD, "VA_CODED_BUF_STATUS_AIR_MB_OVER_THRESHOLD" );
	#endif
	#ifdef VA_CODED_BUF_STATUS_NUMBER_PASSES_MASK
		swigIntConstant( VA_CODED_BUF_STATUS_NUMBER_PASSES_MASK, "VA_CODED_BUF_STATUS_NUMBER_PASSES_MASK" );
	#endif
	#ifdef VA_CODED_BUF_STATUS_SINGLE_NALU
		swigIntConstant( VA_CODED_BUF_STATUS_SINGLE_NALU, "VA_CODED_BUF_STATUS_SINGLE_NALU" );
	#endif
	#ifdef VA_EXPORT_SURFACE_READ_ONLY
		swigIntConstant( VA_EXPORT_SURFACE_READ_ONLY, "VA_EXPORT_SURFACE_READ_ONLY" );
	#endif
	#ifdef VA_EXPORT_SURFACE_WRITE_ONLY
		swigIntConstant( VA_EXPORT_SURFACE_WRITE_ONLY, "VA_EXPORT_SURFACE_WRITE_ONLY" );
	#endif
	#ifdef VA_EXPORT_SURFACE_READ_WRITE
		swigIntConstant( VA_EXPORT_SURFACE_READ_WRITE, "VA_EXPORT_SURFACE_READ_WRITE" );
	#endif
	#ifdef VA_EXPORT_SURFACE_SEPARATE_LAYERS
		swigIntConstant( VA_EXPORT_SURFACE_SEPARATE_LAYERS, "VA_EXPORT_SURFACE_SEPARATE_LAYERS" );
	#endif
	#ifdef VA_EXPORT_SURFACE_COMPOSED_LAYERS
		swigIntConstant( VA_EXPORT_SURFACE_COMPOSED_LAYERS, "VA_EXPORT_SURFACE_COMPOSED_LAYERS" );
	#endif
	#ifdef VA_TIMEOUT_INFINITE
		swigIntConstant( VA_TIMEOUT_INFINITE, "VA_TIMEOUT_INFINITE" );
	#endif
	#ifdef VA_FOURCC_NV12
		swigIntConstant( VA_FOURCC_NV12, "VA_FOURCC_NV12" );
	#endif
	#ifdef VA_FOURCC_NV21
		swigIntConstant( VA_FOURCC_NV21, "VA_FOURCC_NV21" );
	#endif
	#ifdef VA_FOURCC_AI44
		swigIntConstant( VA_FOURCC_AI44, "VA_FOURCC_AI44" );
	#endif
	#ifdef VA_FOURCC_RGBA
		swigIntConstant( VA_FOURCC_RGBA, "VA_FOURCC_RGBA" );
	#endif
	#ifdef VA_FOURCC_RGBX
		swigIntConstant( VA_FOURCC_RGBX, "VA_FOURCC_RGBX" );
	#endif
	#ifdef VA_FOURCC_BGRA
		swigIntConstant( VA_FOURCC_BGRA, "VA_FOURCC_BGRA" );
	#endif
	#ifdef VA_FOURCC_BGRX
		swigIntConstant( VA_FOURCC_BGRX, "VA_FOURCC_BGRX" );
	#endif
	#ifdef VA_FOURCC_ARGB
		swigIntConstant( VA_FOURCC_ARGB, "VA_FOURCC_ARGB" );
	#endif
	#ifdef VA_FOURCC_XRGB
		swigIntConstant( VA_FOURCC_XRGB, "VA_FOURCC_XRGB" );
	#endif
	#ifdef VA_FOURCC_ABGR
		swigIntConstant( VA_FOURCC_ABGR, "VA_FOURCC_ABGR" );
	#endif
	#ifdef VA_FOURCC_XBGR
		swigIntConstant( VA_FOURCC_XBGR, "VA_FOURCC_XBGR" );
	#endif
	#ifdef VA_FOURCC_UYVY
		swigIntConstant( VA_FOURCC_UYVY, "VA_FOURCC_UYVY" );
	#endif
	#ifdef VA_FOURCC_YUY2
		swigIntConstant( VA_FOURCC_YUY2, "VA_FOURCC_YUY2" );
	#endif
	#ifdef VA_FOURCC_AYUV
		swigIntConstant( VA_FOURCC_AYUV, "VA_FOURCC_AYUV" );
	#endif
	#ifdef VA_FOURCC_NV11
		swigIntConstant( VA_FOURCC_NV11, "VA_FOURCC_NV11" );
	#endif
	#ifdef VA_FOURCC_YV12
		swigIntConstant( VA_FOURCC_YV12, "VA_FOURCC_YV12" );
	#endif
	#ifdef VA_FOURCC_P208
		swigIntConstant( VA_FOURCC_P208, "VA_FOURCC_P208" );
	#endif
	#ifdef VA_FOURCC_I420
		swigIntConstant( VA_FOURCC_I420, "VA_FOURCC_I420" );
	#endif
	#ifdef VA_FOURCC_YV24
		swigIntConstant( VA_FOURCC_YV24, "VA_FOURCC_YV24" );
	#endif
	#ifdef VA_FOURCC_YV32
		swigIntConstant( VA_FOURCC_YV32, "VA_FOURCC_YV32" );
	#endif
	#ifdef VA_FOURCC_Y800
		swigIntConstant( VA_FOURCC_Y800, "VA_FOURCC_Y800" );
	#endif
	#ifdef VA_FOURCC_IMC3
		swigIntConstant( VA_FOURCC_IMC3, "VA_FOURCC_IMC3" );
	#endif
	#ifdef VA_FOURCC_411P
		swigIntConstant( VA_FOURCC_411P, "VA_FOURCC_411P" );
	#endif
	#ifdef VA_FOURCC_411R
		swigIntConstant( VA_FOURCC_411R, "VA_FOURCC_411R" );
	#endif
	#ifdef VA_FOURCC_422H
		swigIntConstant( VA_FOURCC_422H, "VA_FOURCC_422H" );
	#endif
	#ifdef VA_FOURCC_422V
		swigIntConstant( VA_FOURCC_422V, "VA_FOURCC_422V" );
	#endif
	#ifdef VA_FOURCC_444P
		swigIntConstant( VA_FOURCC_444P, "VA_FOURCC_444P" );
	#endif
	#ifdef VA_FOURCC_RGBP
		swigIntConstant( VA_FOURCC_RGBP, "VA_FOURCC_RGBP" );
	#endif
	#ifdef VA_FOURCC_BGRP
		swigIntConstant( VA_FOURCC_BGRP, "VA_FOURCC_BGRP" );
	#endif
	#ifdef VA_FOURCC_RGB565
		swigIntConstant( VA_FOURCC_RGB565, "VA_FOURCC_RGB565" );
	#endif
	#ifdef VA_FOURCC_BGR565
		swigIntConstant( VA_FOURCC_BGR565, "VA_FOURCC_BGR565" );
	#endif
	#ifdef VA_FOURCC_Y210
		swigIntConstant( VA_FOURCC_Y210, "VA_FOURCC_Y210" );
	#endif
	#ifdef VA_FOURCC_Y212
		swigIntConstant( VA_FOURCC_Y212, "VA_FOURCC_Y212" );
	#endif
	#ifdef VA_FOURCC_Y216
		swigIntConstant( VA_FOURCC_Y216, "VA_FOURCC_Y216" );
	#endif
	#ifdef VA_FOURCC_Y410
		swigIntConstant( VA_FOURCC_Y410, "VA_FOURCC_Y410" );
	#endif
	#ifdef VA_FOURCC_Y412
		swigIntConstant( VA_FOURCC_Y412, "VA_FOURCC_Y412" );
	#endif
	#ifdef VA_FOURCC_Y416
		swigIntConstant( VA_FOURCC_Y416, "VA_FOURCC_Y416" );
	#endif
	#ifdef VA_FOURCC_YV16
		swigIntConstant( VA_FOURCC_YV16, "VA_FOURCC_YV16" );
	#endif
	#ifdef VA_FOURCC_P010
		swigIntConstant( VA_FOURCC_P010, "VA_FOURCC_P010" );
	#endif
	#ifdef VA_FOURCC_P012
		swigIntConstant( VA_FOURCC_P012, "VA_FOURCC_P012" );
	#endif
	#ifdef VA_FOURCC_P016
		swigIntConstant( VA_FOURCC_P016, "VA_FOURCC_P016" );
	#endif
	#ifdef VA_FOURCC_I010
		swigIntConstant( VA_FOURCC_I010, "VA_FOURCC_I010" );
	#endif
	#ifdef VA_FOURCC_IYUV
		swigIntConstant( VA_FOURCC_IYUV, "VA_FOURCC_IYUV" );
	#endif
	#ifdef VA_FOURCC_A2R10G10B10
		swigIntConstant( VA_FOURCC_A2R10G10B10, "VA_FOURCC_A2R10G10B10" );
	#endif
	#ifdef VA_FOURCC_A2B10G10R10
		swigIntConstant( VA_FOURCC_A2B10G10R10, "VA_FOURCC_A2B10G10R10" );
	#endif
	#ifdef VA_FOURCC_X2R10G10B10
		swigIntConstant( VA_FOURCC_X2R10G10B10, "VA_FOURCC_X2R10G10B10" );
	#endif
	#ifdef VA_FOURCC_X2B10G10R10
		swigIntConstant( VA_FOURCC_X2B10G10R10, "VA_FOURCC_X2B10G10R10" );
	#endif
	#ifdef VA_FOURCC_Y8
		swigIntConstant( VA_FOURCC_Y8, "VA_FOURCC_Y8" );
	#endif
	#ifdef VA_FOURCC_Y16
		swigIntConstant( VA_FOURCC_Y16, "VA_FOURCC_Y16" );
	#endif
	#ifdef VA_FOURCC_VYUY
		swigIntConstant( VA_FOURCC_VYUY, "VA_FOURCC_VYUY" );
	#endif
	#ifdef VA_FOURCC_YVYU
		swigIntConstant( VA_FOURCC_YVYU, "VA_FOURCC_YVYU" );
	#endif
	#ifdef VA_FOURCC_ARGB64
		swigIntConstant( VA_FOURCC_ARGB64, "VA_FOURCC_ARGB64" );
	#endif
	#ifdef VA_FOURCC_ABGR64
		swigIntConstant( VA_FOURCC_ABGR64, "VA_FOURCC_ABGR64" );
	#endif
	#ifdef VA_FOURCC_XYUV
		swigIntConstant( VA_FOURCC_XYUV, "VA_FOURCC_XYUV" );
	#endif
	#ifdef VA_LSB_FIRST
		swigIntConstant( VA_LSB_FIRST, "VA_LSB_FIRST" );
	#endif
	#ifdef VA_MSB_FIRST
		swigIntConstant( VA_MSB_FIRST, "VA_MSB_FIRST" );
	#endif
	#ifdef VA_SUBPICTURE_CHROMA_KEYING
		swigIntConstant( VA_SUBPICTURE_CHROMA_KEYING, "VA_SUBPICTURE_CHROMA_KEYING" );
	#endif
	#ifdef VA_SUBPICTURE_GLOBAL_ALPHA
		swigIntConstant( VA_SUBPICTURE_GLOBAL_ALPHA, "VA_SUBPICTURE_GLOBAL_ALPHA" );
	#endif
	#ifdef VA_SUBPICTURE_DESTINATION_IS_SCREEN_COORD
		swigIntConstant( VA_SUBPICTURE_DESTINATION_IS_SCREEN_COORD, "VA_SUBPICTURE_DESTINATION_IS_SCREEN_COORD" );
	#endif
	#ifdef VA_ROTATION_NONE
		swigIntConstant( VA_ROTATION_NONE, "VA_ROTATION_NONE" );
	#endif
	#ifdef VA_ROTATION_90
		swigIntConstant( VA_ROTATION_90, "VA_ROTATION_90" );
	#endif
	#ifdef VA_ROTATION_180
		swigIntConstant( VA_ROTATION_180, "VA_ROTATION_180" );
	#endif
	#ifdef VA_ROTATION_270
		swigIntConstant( VA_ROTATION_270, "VA_ROTATION_270" );
	#endif
	#ifdef VA_MIRROR_NONE
		swigIntConstant( VA_MIRROR_NONE, "VA_MIRROR_NONE" );
	#endif
	#ifdef VA_MIRROR_HORIZONTAL
		swigIntConstant( VA_MIRROR_HORIZONTAL, "VA_MIRROR_HORIZONTAL" );
	#endif
	#ifdef VA_MIRROR_VERTICAL
		swigIntConstant( VA_MIRROR_VERTICAL, "VA_MIRROR_VERTICAL" );
	#endif
	#ifdef VA_OOL_DEBLOCKING_FALSE
		swigIntConstant( VA_OOL_DEBLOCKING_FALSE, "VA_OOL_DEBLOCKING_FALSE" );
	#endif
	#ifdef VA_OOL_DEBLOCKING_TRUE
		swigIntConstant( VA_OOL_DEBLOCKING_TRUE, "VA_OOL_DEBLOCKING_TRUE" );
	#endif
	#ifdef VA_RENDER_MODE_UNDEFINED
		swigIntConstant( VA_RENDER_MODE_UNDEFINED, "VA_RENDER_MODE_UNDEFINED" );
	#endif
	#ifdef VA_RENDER_MODE_LOCAL_OVERLAY
		swigIntConstant( VA_RENDER_MODE_LOCAL_OVERLAY, "VA_RENDER_MODE_LOCAL_OVERLAY" );
	#endif
	#ifdef VA_RENDER_MODE_LOCAL_GPU
		swigIntConstant( VA_RENDER_MODE_LOCAL_GPU, "VA_RENDER_MODE_LOCAL_GPU" );
	#endif
	#ifdef VA_RENDER_MODE_EXTERNAL_OVERLAY
		swigIntConstant( VA_RENDER_MODE_EXTERNAL_OVERLAY, "VA_RENDER_MODE_EXTERNAL_OVERLAY" );
	#endif
	#ifdef VA_RENDER_MODE_EXTERNAL_GPU
		swigIntConstant( VA_RENDER_MODE_EXTERNAL_GPU, "VA_RENDER_MODE_EXTERNAL_GPU" );
	#endif
	#ifdef VA_RENDER_DEVICE_UNDEFINED
		swigIntConstant( VA_RENDER_DEVICE_UNDEFINED, "VA_RENDER_DEVICE_UNDEFINED" );
	#endif
	#ifdef VA_RENDER_DEVICE_LOCAL
		swigIntConstant( VA_RENDER_DEVICE_LOCAL, "VA_RENDER_DEVICE_LOCAL" );
	#endif
	#ifdef VA_RENDER_DEVICE_EXTERNAL
		swigIntConstant( VA_RENDER_DEVICE_EXTERNAL, "VA_RENDER_DEVICE_EXTERNAL" );
	#endif
	#ifdef VA_DISPLAY_ATTRIB_NOT_SUPPORTED
		swigIntConstant( VA_DISPLAY_ATTRIB_NOT_SUPPORTED, "VA_DISPLAY_ATTRIB_NOT_SUPPORTED" );
	#endif
	#ifdef VA_DISPLAY_ATTRIB_GETTABLE
		swigIntConstant( VA_DISPLAY_ATTRIB_GETTABLE, "VA_DISPLAY_ATTRIB_GETTABLE" );
	#endif
	#ifdef VA_DISPLAY_ATTRIB_SETTABLE
		swigIntConstant( VA_DISPLAY_ATTRIB_SETTABLE, "VA_DISPLAY_ATTRIB_SETTABLE" );
	#endif
	#ifdef VA_PICTURE_HEVC_INVALID
		swigIntConstant( VA_PICTURE_HEVC_INVALID, "VA_PICTURE_HEVC_INVALID" );
	#endif
	#ifdef VA_PICTURE_HEVC_FIELD_PIC
		swigIntConstant( VA_PICTURE_HEVC_FIELD_PIC, "VA_PICTURE_HEVC_FIELD_PIC" );
	#endif
	#ifdef VA_PICTURE_HEVC_BOTTOM_FIELD
		swigIntConstant( VA_PICTURE_HEVC_BOTTOM_FIELD, "VA_PICTURE_HEVC_BOTTOM_FIELD" );
	#endif
	#ifdef VA_PICTURE_HEVC_LONG_TERM_REFERENCE
		swigIntConstant( VA_PICTURE_HEVC_LONG_TERM_REFERENCE, "VA_PICTURE_HEVC_LONG_TERM_REFERENCE" );
	#endif
	#ifdef VA_PICTURE_HEVC_RPS_ST_CURR_BEFORE
		swigIntConstant( VA_PICTURE_HEVC_RPS_ST_CURR_BEFORE, "VA_PICTURE_HEVC_RPS_ST_CURR_BEFORE" );
	#endif
	#ifdef VA_PICTURE_HEVC_RPS_ST_CURR_AFTER
		swigIntConstant( VA_PICTURE_HEVC_RPS_ST_CURR_AFTER, "VA_PICTURE_HEVC_RPS_ST_CURR_AFTER" );
	#endif
	#ifdef VA_PICTURE_HEVC_RPS_LT_CURR
		swigIntConstant( VA_PICTURE_HEVC_RPS_LT_CURR, "VA_PICTURE_HEVC_RPS_LT_CURR" );
	#endif
	#ifdef VA_BLEND_GLOBAL_ALPHA
		swigIntConstant( VA_BLEND_GLOBAL_ALPHA, "VA_BLEND_GLOBAL_ALPHA" );
	#endif
	#ifdef VA_BLEND_PREMULTIPLIED_ALPHA
		swigIntConstant( VA_BLEND_PREMULTIPLIED_ALPHA, "VA_BLEND_PREMULTIPLIED_ALPHA" );
	#endif
	#ifdef VA_BLEND_LUMA_KEY
		swigIntConstant( VA_BLEND_LUMA_KEY, "VA_BLEND_LUMA_KEY" );
	#endif
	#ifdef VA_PROC_PIPELINE_SUBPICTURES
		swigIntConstant( VA_PROC_PIPELINE_SUBPICTURES, "VA_PROC_PIPELINE_SUBPICTURES" );
	#endif
	#ifdef VA_PROC_PIPELINE_FAST
		swigIntConstant( VA_PROC_PIPELINE_FAST, "VA_PROC_PIPELINE_FAST" );
	#endif
	#ifdef VA_PROC_FILTER_MANDATORY
		swigIntConstant( VA_PROC_FILTER_MANDATORY, "VA_PROC_FILTER_MANDATORY" );
	#endif
	#ifdef VA_PIPELINE_FLAG_END
		swigIntConstant( VA_PIPELINE_FLAG_END, "VA_PIPELINE_FLAG_END" );
	#endif
	#ifdef VA_CHROMA_SITING_UNKNOWN
		swigIntConstant( VA_CHROMA_SITING_UNKNOWN, "VA_CHROMA_SITING_UNKNOWN" );
	#endif
	#ifdef VA_CHROMA_SITING_VERTICAL_TOP
		swigIntConstant( VA_CHROMA_SITING_VERTICAL_TOP, "VA_CHROMA_SITING_VERTICAL_TOP" );
	#endif
	#ifdef VA_CHROMA_SITING_VERTICAL_CENTER
		swigIntConstant( VA_CHROMA_SITING_VERTICAL_CENTER, "VA_CHROMA_SITING_VERTICAL_CENTER" );
	#endif
	#ifdef VA_CHROMA_SITING_VERTICAL_BOTTOM
		swigIntConstant( VA_CHROMA_SITING_VERTICAL_BOTTOM, "VA_CHROMA_SITING_VERTICAL_BOTTOM" );
	#endif
	#ifdef VA_CHROMA_SITING_HORIZONTAL_LEFT
		swigIntConstant( VA_CHROMA_SITING_HORIZONTAL_LEFT, "VA_CHROMA_SITING_HORIZONTAL_LEFT" );
	#endif
	#ifdef VA_CHROMA_SITING_HORIZONTAL_CENTER
		swigIntConstant( VA_CHROMA_SITING_HORIZONTAL_CENTER, "VA_CHROMA_SITING_HORIZONTAL_CENTER" );
	#endif
	#ifdef VA_SOURCE_RANGE_UNKNOWN
		swigIntConstant( VA_SOURCE_RANGE_UNKNOWN, "VA_SOURCE_RANGE_UNKNOWN" );
	#endif
	#ifdef VA_SOURCE_RANGE_REDUCED
		swigIntConstant( VA_SOURCE_RANGE_REDUCED, "VA_SOURCE_RANGE_REDUCED" );
	#endif
	#ifdef VA_SOURCE_RANGE_FULL
		swigIntConstant( VA_SOURCE_RANGE_FULL, "VA_SOURCE_RANGE_FULL" );
	#endif
	#ifdef VA_TONE_MAPPING_HDR_TO_HDR
		swigIntConstant( VA_TONE_MAPPING_HDR_TO_HDR, "VA_TONE_MAPPING_HDR_TO_HDR" );
	#endif
	#ifdef VA_TONE_MAPPING_HDR_TO_SDR
		swigIntConstant( VA_TONE_MAPPING_HDR_TO_SDR, "VA_TONE_MAPPING_HDR_TO_SDR" );
	#endif
	#ifdef VA_TONE_MAPPING_HDR_TO_EDR
		swigIntConstant( VA_TONE_MAPPING_HDR_TO_EDR, "VA_TONE_MAPPING_HDR_TO_EDR" );
	#endif
	#ifdef VA_TONE_MAPPING_SDR_TO_HDR
		swigIntConstant( VA_TONE_MAPPING_SDR_TO_HDR, "VA_TONE_MAPPING_SDR_TO_HDR" );
	#endif
	#ifdef VA_DEINTERLACING_BOTTOM_FIELD_FIRST
		swigIntConstant( VA_DEINTERLACING_BOTTOM_FIELD_FIRST, "VA_DEINTERLACING_BOTTOM_FIELD_FIRST" );
	#endif
	#ifdef VA_DEINTERLACING_BOTTOM_FIELD
		swigIntConstant( VA_DEINTERLACING_BOTTOM_FIELD, "VA_DEINTERLACING_BOTTOM_FIELD" );
	#endif
	#ifdef VA_DEINTERLACING_ONE_FIELD
		swigIntConstant( VA_DEINTERLACING_ONE_FIELD, "VA_DEINTERLACING_ONE_FIELD" );
	#endif
	#ifdef VA_DEINTERLACING_FMD_ENABLE
		swigIntConstant( VA_DEINTERLACING_FMD_ENABLE, "VA_DEINTERLACING_FMD_ENABLE" );
	#endif
	#ifdef VA_DEINTERLACING_SCD_ENABLE
		swigIntConstant( VA_DEINTERLACING_SCD_ENABLE, "VA_DEINTERLACING_SCD_ENABLE" );
	#endif
	#ifdef VA_PROC_HVS_DENOISE_DEFAULT
		swigIntConstant( VA_PROC_HVS_DENOISE_DEFAULT, "VA_PROC_HVS_DENOISE_DEFAULT" );
	#endif
	#ifdef VA_PROC_HVS_DENOISE_AUTO_BDRATE
		swigIntConstant( VA_PROC_HVS_DENOISE_AUTO_BDRATE, "VA_PROC_HVS_DENOISE_AUTO_BDRATE" );
	#endif
	#ifdef VA_PROC_HVS_DENOISE_AUTO_SUBJECTIVE
		swigIntConstant( VA_PROC_HVS_DENOISE_AUTO_SUBJECTIVE, "VA_PROC_HVS_DENOISE_AUTO_SUBJECTIVE" );
	#endif
	#ifdef VA_PROC_HVS_DENOISE_MANUAL
		swigIntConstant( VA_PROC_HVS_DENOISE_MANUAL, "VA_PROC_HVS_DENOISE_MANUAL" );
	#endif
	#ifdef VA_3DLUT_CHANNEL_UNKNOWN
		swigIntConstant( VA_3DLUT_CHANNEL_UNKNOWN, "VA_3DLUT_CHANNEL_UNKNOWN" );
	#endif
	#ifdef VA_3DLUT_CHANNEL_RGB_RGB
		swigIntConstant( VA_3DLUT_CHANNEL_RGB_RGB, "VA_3DLUT_CHANNEL_RGB_RGB" );
	#endif
	#ifdef VA_3DLUT_CHANNEL_YUV_RGB
		swigIntConstant( VA_3DLUT_CHANNEL_YUV_RGB, "VA_3DLUT_CHANNEL_YUV_RGB" );
	#endif
	#ifdef VA_3DLUT_CHANNEL_VUY_RGB
		swigIntConstant( VA_3DLUT_CHANNEL_VUY_RGB, "VA_3DLUT_CHANNEL_VUY_RGB" );
	#endif
	#ifdef VA_DISPLAY_MAGIC
		swigIntConstant( VA_DISPLAY_MAGIC, "VA_DISPLAY_MAGIC" );
	#endif
	#ifdef VA_WAYLAND_API_VERSION
		swigIntConstant( VA_WAYLAND_API_VERSION, "VA_WAYLAND_API_VERSION" );
	#endif
	#ifdef VA_DRIVER_VTABLE_VPP_VERSION
		swigIntConstant( VA_DRIVER_VTABLE_VPP_VERSION, "VA_DRIVER_VTABLE_VPP_VERSION" );
	#endif

	swigNewline();

	swigComment("--------===< enums >===---------\n");
	swigIntConstant( VAProfileNone, "VAProfileNone" );
	swigIntConstant( VAProfileMPEG2Simple, "VAProfileMPEG2Simple" );
	swigIntConstant( VAProfileMPEG2Main, "VAProfileMPEG2Main" );
	swigIntConstant( VAProfileMPEG4Simple, "VAProfileMPEG4Simple" );
	swigIntConstant( VAProfileMPEG4AdvancedSimple, "VAProfileMPEG4AdvancedSimple" );
	swigIntConstant( VAProfileMPEG4Main, "VAProfileMPEG4Main" );
	swigIntConstant( VAProfileH264Baseline, "VAProfileH264Baseline" );
	swigIntConstant( VAProfileH264Main, "VAProfileH264Main" );
	swigIntConstant( VAProfileH264High, "VAProfileH264High" );
	swigIntConstant( VAProfileVC1Simple, "VAProfileVC1Simple" );
	swigIntConstant( VAProfileVC1Main, "VAProfileVC1Main" );
	swigIntConstant( VAProfileVC1Advanced, "VAProfileVC1Advanced" );
	swigIntConstant( VAProfileH263Baseline, "VAProfileH263Baseline" );
	swigIntConstant( VAProfileJPEGBaseline, "VAProfileJPEGBaseline" );
	swigIntConstant( VAProfileH264ConstrainedBaseline, "VAProfileH264ConstrainedBaseline" );
	swigIntConstant( VAProfileVP8Version0_3, "VAProfileVP8Version0_3" );
	swigIntConstant( VAProfileH264MultiviewHigh, "VAProfileH264MultiviewHigh" );
	swigIntConstant( VAProfileH264StereoHigh, "VAProfileH264StereoHigh" );
	swigIntConstant( VAProfileHEVCMain, "VAProfileHEVCMain" );
	swigIntConstant( VAProfileHEVCMain10, "VAProfileHEVCMain10" );
	swigIntConstant( VAProfileVP9Profile0, "VAProfileVP9Profile0" );
	swigIntConstant( VAProfileVP9Profile1, "VAProfileVP9Profile1" );
	swigIntConstant( VAProfileVP9Profile2, "VAProfileVP9Profile2" );
	swigIntConstant( VAProfileVP9Profile3, "VAProfileVP9Profile3" );
	swigIntConstant( VAProfileHEVCMain12, "VAProfileHEVCMain12" );
	swigIntConstant( VAProfileHEVCMain422_10, "VAProfileHEVCMain422_10" );
	swigIntConstant( VAProfileHEVCMain422_12, "VAProfileHEVCMain422_12" );
	swigIntConstant( VAProfileHEVCMain444, "VAProfileHEVCMain444" );
	swigIntConstant( VAProfileHEVCMain444_10, "VAProfileHEVCMain444_10" );
	swigIntConstant( VAProfileHEVCMain444_12, "VAProfileHEVCMain444_12" );
	swigIntConstant( VAProfileHEVCSccMain, "VAProfileHEVCSccMain" );
	swigIntConstant( VAProfileHEVCSccMain10, "VAProfileHEVCSccMain10" );
	swigIntConstant( VAProfileHEVCSccMain444, "VAProfileHEVCSccMain444" );
	swigIntConstant( VAProfileAV1Profile0, "VAProfileAV1Profile0" );
	swigIntConstant( VAProfileAV1Profile1, "VAProfileAV1Profile1" );
	swigIntConstant( VAProfileHEVCSccMain444_10, "VAProfileHEVCSccMain444_10" );
	swigIntConstant( VAProfileProtected, "VAProfileProtected" );
	swigIntConstant( VAEntrypointVLD, "VAEntrypointVLD" );
	swigIntConstant( VAEntrypointIZZ, "VAEntrypointIZZ" );
	swigIntConstant( VAEntrypointIDCT, "VAEntrypointIDCT" );
	swigIntConstant( VAEntrypointMoComp, "VAEntrypointMoComp" );
	swigIntConstant( VAEntrypointDeblocking, "VAEntrypointDeblocking" );
	swigIntConstant( VAEntrypointEncSlice, "VAEntrypointEncSlice" );
	swigIntConstant( VAEntrypointEncPicture, "VAEntrypointEncPicture" );
	swigIntConstant( VAEntrypointEncSliceLP, "VAEntrypointEncSliceLP" );
	swigIntConstant( VAEntrypointVideoProc, "VAEntrypointVideoProc" );
	swigIntConstant( VAEntrypointFEI, "VAEntrypointFEI" );
	swigIntConstant( VAEntrypointStats, "VAEntrypointStats" );
	swigIntConstant( VAEntrypointProtectedTEEComm, "VAEntrypointProtectedTEEComm" );
	swigIntConstant( VAEntrypointProtectedContent, "VAEntrypointProtectedContent" );
	swigIntConstant( VAConfigAttribRTFormat, "VAConfigAttribRTFormat" );
	swigIntConstant( VAConfigAttribSpatialResidual, "VAConfigAttribSpatialResidual" );
	swigIntConstant( VAConfigAttribSpatialClipping, "VAConfigAttribSpatialClipping" );
	swigIntConstant( VAConfigAttribIntraResidual, "VAConfigAttribIntraResidual" );
	swigIntConstant( VAConfigAttribEncryption, "VAConfigAttribEncryption" );
	swigIntConstant( VAConfigAttribRateControl, "VAConfigAttribRateControl" );
	swigIntConstant( VAConfigAttribDecSliceMode, "VAConfigAttribDecSliceMode" );
	swigIntConstant( VAConfigAttribDecJPEG, "VAConfigAttribDecJPEG" );
	swigIntConstant( VAConfigAttribDecProcessing, "VAConfigAttribDecProcessing" );
	swigIntConstant( VAConfigAttribEncPackedHeaders, "VAConfigAttribEncPackedHeaders" );
	swigIntConstant( VAConfigAttribEncInterlaced, "VAConfigAttribEncInterlaced" );
	swigIntConstant( VAConfigAttribEncMaxRefFrames, "VAConfigAttribEncMaxRefFrames" );
	swigIntConstant( VAConfigAttribEncMaxSlices, "VAConfigAttribEncMaxSlices" );
	swigIntConstant( VAConfigAttribEncSliceStructure, "VAConfigAttribEncSliceStructure" );
	swigIntConstant( VAConfigAttribEncMacroblockInfo, "VAConfigAttribEncMacroblockInfo" );
	swigIntConstant( VAConfigAttribMaxPictureWidth, "VAConfigAttribMaxPictureWidth" );
	swigIntConstant( VAConfigAttribMaxPictureHeight, "VAConfigAttribMaxPictureHeight" );
	swigIntConstant( VAConfigAttribEncJPEG, "VAConfigAttribEncJPEG" );
	swigIntConstant( VAConfigAttribEncQualityRange, "VAConfigAttribEncQualityRange" );
	swigIntConstant( VAConfigAttribEncQuantization, "VAConfigAttribEncQuantization" );
	swigIntConstant( VAConfigAttribEncIntraRefresh, "VAConfigAttribEncIntraRefresh" );
	swigIntConstant( VAConfigAttribEncSkipFrame, "VAConfigAttribEncSkipFrame" );
	swigIntConstant( VAConfigAttribEncROI, "VAConfigAttribEncROI" );
	swigIntConstant( VAConfigAttribEncRateControlExt, "VAConfigAttribEncRateControlExt" );
	swigIntConstant( VAConfigAttribProcessingRate, "VAConfigAttribProcessingRate" );
	swigIntConstant( VAConfigAttribEncDirtyRect, "VAConfigAttribEncDirtyRect" );
	swigIntConstant( VAConfigAttribEncParallelRateControl, "VAConfigAttribEncParallelRateControl" );
	swigIntConstant( VAConfigAttribEncDynamicScaling, "VAConfigAttribEncDynamicScaling" );
	swigIntConstant( VAConfigAttribFrameSizeToleranceSupport, "VAConfigAttribFrameSizeToleranceSupport" );
	swigIntConstant( VAConfigAttribFEIFunctionType, "VAConfigAttribFEIFunctionType" );
	swigIntConstant( VAConfigAttribFEIMVPredictors, "VAConfigAttribFEIMVPredictors" );
	swigIntConstant( VAConfigAttribStats, "VAConfigAttribStats" );
	swigIntConstant( VAConfigAttribEncTileSupport, "VAConfigAttribEncTileSupport" );
	swigIntConstant( VAConfigAttribCustomRoundingControl, "VAConfigAttribCustomRoundingControl" );
	swigIntConstant( VAConfigAttribQPBlockSize, "VAConfigAttribQPBlockSize" );
	swigIntConstant( VAConfigAttribMaxFrameSize, "VAConfigAttribMaxFrameSize" );
	swigIntConstant( VAConfigAttribPredictionDirection, "VAConfigAttribPredictionDirection" );
	swigIntConstant( VAConfigAttribMultipleFrame, "VAConfigAttribMultipleFrame" );
	swigIntConstant( VAConfigAttribContextPriority, "VAConfigAttribContextPriority" );
	swigIntConstant( VAConfigAttribDecAV1Features, "VAConfigAttribDecAV1Features" );
	swigIntConstant( VAConfigAttribTEEType, "VAConfigAttribTEEType" );
	swigIntConstant( VAConfigAttribTEETypeClient, "VAConfigAttribTEETypeClient" );
	swigIntConstant( VAConfigAttribProtectedContentCipherAlgorithm, "VAConfigAttribProtectedContentCipherAlgorithm" );
	swigIntConstant( VAConfigAttribProtectedContentCipherBlockSize, "VAConfigAttribProtectedContentCipherBlockSize" );
	swigIntConstant( VAConfigAttribProtectedContentCipherMode, "VAConfigAttribProtectedContentCipherMode" );
	swigIntConstant( VAConfigAttribProtectedContentCipherSampleType, "VAConfigAttribProtectedContentCipherSampleType" );
	swigIntConstant( VAConfigAttribProtectedContentUsage, "VAConfigAttribProtectedContentUsage" );
	swigIntConstant( VAConfigAttribEncHEVCFeatures, "VAConfigAttribEncHEVCFeatures" );
	swigIntConstant( VAConfigAttribEncHEVCBlockSizes, "VAConfigAttribEncHEVCBlockSizes" );
	swigIntConstant( VAConfigAttribEncAV1, "VAConfigAttribEncAV1" );
	swigIntConstant( VAConfigAttribEncAV1Ext1, "VAConfigAttribEncAV1Ext1" );
	swigIntConstant( VAConfigAttribEncAV1Ext2, "VAConfigAttribEncAV1Ext2" );
	swigIntConstant( VAConfigAttribEncPerBlockControl, "VAConfigAttribEncPerBlockControl" );
	swigIntConstant( VAConfigAttribTypeMax, "VAConfigAttribTypeMax" );
	swigIntConstant( VAGenericValueTypeInteger, "VAGenericValueTypeInteger" );
	swigIntConstant( VAGenericValueTypeFloat, "VAGenericValueTypeFloat" );
	swigIntConstant( VAGenericValueTypePointer, "VAGenericValueTypePointer" );
	swigIntConstant( VAGenericValueTypeFunc, "VAGenericValueTypeFunc" );
	swigIntConstant( VASurfaceAttribNone, "VASurfaceAttribNone" );
	swigIntConstant( VASurfaceAttribPixelFormat, "VASurfaceAttribPixelFormat" );
	swigIntConstant( VASurfaceAttribMinWidth, "VASurfaceAttribMinWidth" );
	swigIntConstant( VASurfaceAttribMaxWidth, "VASurfaceAttribMaxWidth" );
	swigIntConstant( VASurfaceAttribMinHeight, "VASurfaceAttribMinHeight" );
	swigIntConstant( VASurfaceAttribMaxHeight, "VASurfaceAttribMaxHeight" );
	swigIntConstant( VASurfaceAttribMemoryType, "VASurfaceAttribMemoryType" );
	swigIntConstant( VASurfaceAttribExternalBufferDescriptor, "VASurfaceAttribExternalBufferDescriptor" );
	swigIntConstant( VASurfaceAttribUsageHint, "VASurfaceAttribUsageHint" );
	swigIntConstant( VASurfaceAttribDRMFormatModifiers, "VASurfaceAttribDRMFormatModifiers" );
	swigIntConstant( VASurfaceAttribCount, "VASurfaceAttribCount" );
	swigIntConstant( VAPictureParameterBufferType, "VAPictureParameterBufferType" );
	swigIntConstant( VAIQMatrixBufferType, "VAIQMatrixBufferType" );
	swigIntConstant( VABitPlaneBufferType, "VABitPlaneBufferType" );
	swigIntConstant( VASliceGroupMapBufferType, "VASliceGroupMapBufferType" );
	swigIntConstant( VASliceParameterBufferType, "VASliceParameterBufferType" );
	swigIntConstant( VASliceDataBufferType, "VASliceDataBufferType" );
	swigIntConstant( VAMacroblockParameterBufferType, "VAMacroblockParameterBufferType" );
	swigIntConstant( VAResidualDataBufferType, "VAResidualDataBufferType" );
	swigIntConstant( VADeblockingParameterBufferType, "VADeblockingParameterBufferType" );
	swigIntConstant( VAImageBufferType, "VAImageBufferType" );
	swigIntConstant( VAProtectedSliceDataBufferType, "VAProtectedSliceDataBufferType" );
	swigIntConstant( VAQMatrixBufferType, "VAQMatrixBufferType" );
	swigIntConstant( VAHuffmanTableBufferType, "VAHuffmanTableBufferType" );
	swigIntConstant( VAProbabilityBufferType, "VAProbabilityBufferType" );
	swigIntConstant( VAEncCodedBufferType, "VAEncCodedBufferType" );
	swigIntConstant( VAEncSequenceParameterBufferType, "VAEncSequenceParameterBufferType" );
	swigIntConstant( VAEncPictureParameterBufferType, "VAEncPictureParameterBufferType" );
	swigIntConstant( VAEncSliceParameterBufferType, "VAEncSliceParameterBufferType" );
	swigIntConstant( VAEncPackedHeaderParameterBufferType, "VAEncPackedHeaderParameterBufferType" );
	swigIntConstant( VAEncPackedHeaderDataBufferType, "VAEncPackedHeaderDataBufferType" );
	swigIntConstant( VAEncMiscParameterBufferType, "VAEncMiscParameterBufferType" );
	swigIntConstant( VAEncMacroblockParameterBufferType, "VAEncMacroblockParameterBufferType" );
	swigIntConstant( VAEncMacroblockMapBufferType, "VAEncMacroblockMapBufferType" );
	swigIntConstant( VAEncQPBufferType, "VAEncQPBufferType" );
	swigIntConstant( VAProcPipelineParameterBufferType, "VAProcPipelineParameterBufferType" );
	swigIntConstant( VAProcFilterParameterBufferType, "VAProcFilterParameterBufferType" );
	swigIntConstant( VAEncFEIMVBufferType, "VAEncFEIMVBufferType" );
	swigIntConstant( VAEncFEIMBCodeBufferType, "VAEncFEIMBCodeBufferType" );
	swigIntConstant( VAEncFEIDistortionBufferType, "VAEncFEIDistortionBufferType" );
	swigIntConstant( VAEncFEIMBControlBufferType, "VAEncFEIMBControlBufferType" );
	swigIntConstant( VAEncFEIMVPredictorBufferType, "VAEncFEIMVPredictorBufferType" );
	swigIntConstant( VAStatsStatisticsParameterBufferType, "VAStatsStatisticsParameterBufferType" );
	swigIntConstant( VAStatsStatisticsBufferType, "VAStatsStatisticsBufferType" );
	swigIntConstant( VAStatsStatisticsBottomFieldBufferType, "VAStatsStatisticsBottomFieldBufferType" );
	swigIntConstant( VAStatsMVBufferType, "VAStatsMVBufferType" );
	swigIntConstant( VAStatsMVPredictorBufferType, "VAStatsMVPredictorBufferType" );
	swigIntConstant( VAEncMacroblockDisableSkipMapBufferType, "VAEncMacroblockDisableSkipMapBufferType" );
	swigIntConstant( VAEncFEICTBCmdBufferType, "VAEncFEICTBCmdBufferType" );
	swigIntConstant( VAEncFEICURecordBufferType, "VAEncFEICURecordBufferType" );
	swigIntConstant( VADecodeStreamoutBufferType, "VADecodeStreamoutBufferType" );
	swigIntConstant( VASubsetsParameterBufferType, "VASubsetsParameterBufferType" );
	swigIntConstant( VAContextParameterUpdateBufferType, "VAContextParameterUpdateBufferType" );
	swigIntConstant( VAProtectedSessionExecuteBufferType, "VAProtectedSessionExecuteBufferType" );
	swigIntConstant( VAEncryptionParameterBufferType, "VAEncryptionParameterBufferType" );
	swigIntConstant( VAEncDeltaQpPerBlockBufferType, "VAEncDeltaQpPerBlockBufferType" );
	swigIntConstant( VABufferTypeMax, "VABufferTypeMax" );
	swigIntConstant( VAEncMiscParameterTypeFrameRate, "VAEncMiscParameterTypeFrameRate" );
	swigIntConstant( VAEncMiscParameterTypeRateControl, "VAEncMiscParameterTypeRateControl" );
	swigIntConstant( VAEncMiscParameterTypeMaxSliceSize, "VAEncMiscParameterTypeMaxSliceSize" );
	swigIntConstant( VAEncMiscParameterTypeAIR, "VAEncMiscParameterTypeAIR" );
	swigIntConstant( VAEncMiscParameterTypeMaxFrameSize, "VAEncMiscParameterTypeMaxFrameSize" );
	swigIntConstant( VAEncMiscParameterTypeHRD, "VAEncMiscParameterTypeHRD" );
	swigIntConstant( VAEncMiscParameterTypeQualityLevel, "VAEncMiscParameterTypeQualityLevel" );
	swigIntConstant( VAEncMiscParameterTypeRIR, "VAEncMiscParameterTypeRIR" );
	swigIntConstant( VAEncMiscParameterTypeQuantization, "VAEncMiscParameterTypeQuantization" );
	swigIntConstant( VAEncMiscParameterTypeSkipFrame, "VAEncMiscParameterTypeSkipFrame" );
	swigIntConstant( VAEncMiscParameterTypeROI, "VAEncMiscParameterTypeROI" );
	swigIntConstant( VAEncMiscParameterTypeMultiPassFrameSize, "VAEncMiscParameterTypeMultiPassFrameSize" );
	swigIntConstant( VAEncMiscParameterTypeTemporalLayerStructure, "VAEncMiscParameterTypeTemporalLayerStructure" );
	swigIntConstant( VAEncMiscParameterTypeDirtyRect, "VAEncMiscParameterTypeDirtyRect" );
	swigIntConstant( VAEncMiscParameterTypeParallelBRC, "VAEncMiscParameterTypeParallelBRC" );
	swigIntConstant( VAEncMiscParameterTypeSubMbPartPel, "VAEncMiscParameterTypeSubMbPartPel" );
	swigIntConstant( VAEncMiscParameterTypeEncQuality, "VAEncMiscParameterTypeEncQuality" );
	swigIntConstant( VAEncMiscParameterTypeCustomRoundingControl, "VAEncMiscParameterTypeCustomRoundingControl" );
	swigIntConstant( VAEncMiscParameterTypeFEIFrameControl, "VAEncMiscParameterTypeFEIFrameControl" );
	swigIntConstant( VAEncMiscParameterTypeExtensionData, "VAEncMiscParameterTypeExtensionData" );
	swigIntConstant( VAEncPackedHeaderSequence, "VAEncPackedHeaderSequence" );
	swigIntConstant( VAEncPackedHeaderPicture, "VAEncPackedHeaderPicture" );
	swigIntConstant( VAEncPackedHeaderSlice, "VAEncPackedHeaderSlice" );
	swigIntConstant( VAEncPackedHeaderRawData, "VAEncPackedHeaderRawData" );
	swigIntConstant( VAEncPackedHeaderMiscMask, "VAEncPackedHeaderMiscMask" );
	swigIntConstant( VAMvMode1Mv, "VAMvMode1Mv" );
	swigIntConstant( VAMvMode1MvHalfPel, "VAMvMode1MvHalfPel" );
	swigIntConstant( VAMvMode1MvHalfPelBilinear, "VAMvMode1MvHalfPelBilinear" );
	swigIntConstant( VAMvModeMixedMv, "VAMvModeMixedMv" );
	swigIntConstant( VAMvModeIntensityCompensation, "VAMvModeIntensityCompensation" );
	swigIntConstant( VAEncPictureTypeIntra, "VAEncPictureTypeIntra" );
	swigIntConstant( VAEncPictureTypePredictive, "VAEncPictureTypePredictive" );
	swigIntConstant( VAEncPictureTypeBidirectional, "VAEncPictureTypeBidirectional" );
	swigIntConstant( VASurfaceRendering, "VASurfaceRendering" );
	swigIntConstant( VASurfaceDisplaying, "VASurfaceDisplaying" );
	swigIntConstant( VASurfaceReady, "VASurfaceReady" );
	swigIntConstant( VASurfaceSkipped, "VASurfaceSkipped" );
	swigIntConstant( VADecodeSliceMissing, "VADecodeSliceMissing" );
	swigIntConstant( VADecodeMBError, "VADecodeMBError" );
	swigIntConstant( VADISPLAYATTRIB_BLE_OFF, "VADISPLAYATTRIB_BLE_OFF" );
	swigIntConstant( VADISPLAYATTRIB_BLE_LOW, "VADISPLAYATTRIB_BLE_LOW" );
	swigIntConstant( VADISPLAYATTRIB_BLE_MEDIUM, "VADISPLAYATTRIB_BLE_MEDIUM" );
	swigIntConstant( VADISPLAYATTRIB_BLE_HIGH, "VADISPLAYATTRIB_BLE_HIGH" );
	swigIntConstant( VADISPLAYATTRIB_BLE_NONE, "VADISPLAYATTRIB_BLE_NONE" );
	swigIntConstant( VADisplayAttribBrightness, "VADisplayAttribBrightness" );
	swigIntConstant( VADisplayAttribContrast, "VADisplayAttribContrast" );
	swigIntConstant( VADisplayAttribHue, "VADisplayAttribHue" );
	swigIntConstant( VADisplayAttribSaturation, "VADisplayAttribSaturation" );
	swigIntConstant( VADisplayAttribBackgroundColor, "VADisplayAttribBackgroundColor" );
	swigIntConstant( VADisplayAttribDirectSurface, "VADisplayAttribDirectSurface" );
	swigIntConstant( VADisplayAttribRotation, "VADisplayAttribRotation" );
	swigIntConstant( VADisplayAttribOutofLoopDeblock, "VADisplayAttribOutofLoopDeblock" );
	swigIntConstant( VADisplayAttribBLEBlackMode, "VADisplayAttribBLEBlackMode" );
	swigIntConstant( VADisplayAttribBLEWhiteMode, "VADisplayAttribBLEWhiteMode" );
	swigIntConstant( VADisplayAttribBlueStretch, "VADisplayAttribBlueStretch" );
	swigIntConstant( VADisplayAttribSkinColorCorrection, "VADisplayAttribSkinColorCorrection" );
	swigIntConstant( VADisplayAttribCSCMatrix, "VADisplayAttribCSCMatrix" );
	swigIntConstant( VADisplayAttribBlendColor, "VADisplayAttribBlendColor" );
	swigIntConstant( VADisplayAttribOverlayAutoPaintColorKey, "VADisplayAttribOverlayAutoPaintColorKey" );
	swigIntConstant( VADisplayAttribOverlayColorKey, "VADisplayAttribOverlayColorKey" );
	swigIntConstant( VADisplayAttribRenderMode, "VADisplayAttribRenderMode" );
	swigIntConstant( VADisplayAttribRenderDevice, "VADisplayAttribRenderDevice" );
	swigIntConstant( VADisplayAttribRenderRect, "VADisplayAttribRenderRect" );
	swigIntConstant( VADisplayAttribSubDevice, "VADisplayAttribSubDevice" );
	swigIntConstant( VADisplayAttribCopy, "VADisplayAttribCopy" );
	swigIntConstant( VADisplayPCIID, "VADisplayPCIID" );
	swigIntConstant( VACopyObjectSurface, "VACopyObjectSurface" );
	swigIntConstant( VACopyObjectBuffer, "VACopyObjectBuffer" );
	swigIntConstant( VAProcFilterNone, "VAProcFilterNone" );
	swigIntConstant( VAProcFilterNoiseReduction, "VAProcFilterNoiseReduction" );
	swigIntConstant( VAProcFilterDeinterlacing, "VAProcFilterDeinterlacing" );
	swigIntConstant( VAProcFilterSharpening, "VAProcFilterSharpening" );
	swigIntConstant( VAProcFilterColorBalance, "VAProcFilterColorBalance" );
	swigIntConstant( VAProcFilterSkinToneEnhancement, "VAProcFilterSkinToneEnhancement" );
	swigIntConstant( VAProcFilterTotalColorCorrection, "VAProcFilterTotalColorCorrection" );
	swigIntConstant( VAProcFilterHVSNoiseReduction, "VAProcFilterHVSNoiseReduction" );
	swigIntConstant( VAProcFilterHighDynamicRangeToneMapping, "VAProcFilterHighDynamicRangeToneMapping" );
	swigIntConstant( VAProcFilter3DLUT, "VAProcFilter3DLUT" );
	swigIntConstant( VAProcFilterCount, "VAProcFilterCount" );
	swigIntConstant( VAProcDeinterlacingNone, "VAProcDeinterlacingNone" );
	swigIntConstant( VAProcDeinterlacingBob, "VAProcDeinterlacingBob" );
	swigIntConstant( VAProcDeinterlacingWeave, "VAProcDeinterlacingWeave" );
	swigIntConstant( VAProcDeinterlacingMotionAdaptive, "VAProcDeinterlacingMotionAdaptive" );
	swigIntConstant( VAProcDeinterlacingMotionCompensated, "VAProcDeinterlacingMotionCompensated" );
	swigIntConstant( VAProcDeinterlacingCount, "VAProcDeinterlacingCount" );
	swigIntConstant( VAProcColorBalanceNone, "VAProcColorBalanceNone" );
	swigIntConstant( VAProcColorBalanceHue, "VAProcColorBalanceHue" );
	swigIntConstant( VAProcColorBalanceSaturation, "VAProcColorBalanceSaturation" );
	swigIntConstant( VAProcColorBalanceBrightness, "VAProcColorBalanceBrightness" );
	swigIntConstant( VAProcColorBalanceContrast, "VAProcColorBalanceContrast" );
	swigIntConstant( VAProcColorBalanceAutoSaturation, "VAProcColorBalanceAutoSaturation" );
	swigIntConstant( VAProcColorBalanceAutoBrightness, "VAProcColorBalanceAutoBrightness" );
	swigIntConstant( VAProcColorBalanceAutoContrast, "VAProcColorBalanceAutoContrast" );
	swigIntConstant( VAProcColorBalanceCount, "VAProcColorBalanceCount" );
	swigIntConstant( VAProcColorStandardNone, "VAProcColorStandardNone" );
	swigIntConstant( VAProcColorStandardBT601, "VAProcColorStandardBT601" );
	swigIntConstant( VAProcColorStandardBT709, "VAProcColorStandardBT709" );
	swigIntConstant( VAProcColorStandardBT470M, "VAProcColorStandardBT470M" );
	swigIntConstant( VAProcColorStandardBT470BG, "VAProcColorStandardBT470BG" );
	swigIntConstant( VAProcColorStandardSMPTE170M, "VAProcColorStandardSMPTE170M" );
	swigIntConstant( VAProcColorStandardSMPTE240M, "VAProcColorStandardSMPTE240M" );
	swigIntConstant( VAProcColorStandardGenericFilm, "VAProcColorStandardGenericFilm" );
	swigIntConstant( VAProcColorStandardSRGB, "VAProcColorStandardSRGB" );
	swigIntConstant( VAProcColorStandardSTRGB, "VAProcColorStandardSTRGB" );
	swigIntConstant( VAProcColorStandardXVYCC601, "VAProcColorStandardXVYCC601" );
	swigIntConstant( VAProcColorStandardXVYCC709, "VAProcColorStandardXVYCC709" );
	swigIntConstant( VAProcColorStandardBT2020, "VAProcColorStandardBT2020" );
	swigIntConstant( VAProcColorStandardExplicit, "VAProcColorStandardExplicit" );
	swigIntConstant( VAProcColorStandardCount, "VAProcColorStandardCount" );
	swigIntConstant( VAProcTotalColorCorrectionNone, "VAProcTotalColorCorrectionNone" );
	swigIntConstant( VAProcTotalColorCorrectionRed, "VAProcTotalColorCorrectionRed" );
	swigIntConstant( VAProcTotalColorCorrectionGreen, "VAProcTotalColorCorrectionGreen" );
	swigIntConstant( VAProcTotalColorCorrectionBlue, "VAProcTotalColorCorrectionBlue" );
	swigIntConstant( VAProcTotalColorCorrectionCyan, "VAProcTotalColorCorrectionCyan" );
	swigIntConstant( VAProcTotalColorCorrectionMagenta, "VAProcTotalColorCorrectionMagenta" );
	swigIntConstant( VAProcTotalColorCorrectionYellow, "VAProcTotalColorCorrectionYellow" );
	swigIntConstant( VAProcTotalColorCorrectionCount, "VAProcTotalColorCorrectionCount" );
	swigIntConstant( VAProcHighDynamicRangeMetadataNone, "VAProcHighDynamicRangeMetadataNone" );
	swigIntConstant( VAProcHighDynamicRangeMetadataHDR10, "VAProcHighDynamicRangeMetadataHDR10" );
	swigIntConstant( VAProcHighDynamicRangeMetadataTypeCount, "VAProcHighDynamicRangeMetadataTypeCount" );
	swigIntConstant( VAProcDefaultMode, "VAProcDefaultMode" );
	swigIntConstant( VAProcPowerSavingMode, "VAProcPowerSavingMode" );
	swigIntConstant( VAProcPerformanceMode, "VAProcPerformanceMode" );
	swigIntConstant( VA_DISPLAY_MAJOR_MASK, "VA_DISPLAY_MAJOR_MASK" );
	swigIntConstant( VA_DISPLAY_X11, "VA_DISPLAY_X11" );
	swigIntConstant( VA_DISPLAY_GLX, "VA_DISPLAY_GLX" );
	swigIntConstant( VA_DISPLAY_ANDROID, "VA_DISPLAY_ANDROID" );
	swigIntConstant( VA_DISPLAY_DRM, "VA_DISPLAY_DRM" );
	swigIntConstant( VA_DISPLAY_DRM_RENDERNODES, "VA_DISPLAY_DRM_RENDERNODES" );
	swigIntConstant( VA_DISPLAY_WAYLAND, "VA_DISPLAY_WAYLAND" );

	swigNewline();

	swigComment("-------===< structs >===--------\n");

	swigComment("struct _VARectangle\n");
	printf( "begin-structure VARectangle\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VARectangle ) );

	swigComment("struct _VAMotionVector\n");
	printf( "begin-structure VAMotionVector\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAMotionVector ) );

	swigComment("struct _VAConfigAttrib\n");
	printf( "begin-structure VAConfigAttrib\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAConfigAttrib ) );

	swigComment("union _VAConfigAttribValDecJPEG\n");
	printf( "begin-structure VAConfigAttribValDecJPEG\n" );
	printf( "drop %zu end-structure\n", sizeof( union _VAConfigAttribValDecJPEG ) );

// 	swigComment("_VAConfigAttribValDecJPEG_bits\n");
// 	printf( "begin-structure _VAConfigAttribValDecJPEG_bits\n" );
// 	swigStructField( "_VAConfigAttribValDecJPEG_bits-reserved", offsetof( _VAConfigAttribValDecJPEG_bits, reserved ), sizeof( uint32_t ) );
// 	swigStructField( "_VAConfigAttribValDecJPEG_bits-rotation", offsetof( _VAConfigAttribValDecJPEG_bits, rotation ), sizeof( uint32_t ) );
// 	printf( "drop %zu end-structure\n", sizeof( _VAConfigAttribValDecJPEG_bits ) );

	swigComment("union _VAConfigAttribValMaxFrameSize\n");
	printf( "begin-structure VAConfigAttribValMaxFrameSize\n" );
	printf( "drop %zu end-structure\n", sizeof( union _VAConfigAttribValMaxFrameSize ) );

// 	swigComment("_VAConfigAttribValMaxFrameSize_bits\n");
// 	printf( "begin-structure _VAConfigAttribValMaxFrameSize_bits\n" );
// 	swigStructField( "_VAConfigAttribValMaxFrameSize_bits-reserved", offsetof( _VAConfigAttribValMaxFrameSize_bits, reserved ), sizeof( uint32_t ) );
// 	swigStructField( "_VAConfigAttribValMaxFrameSize_bits-max_frame_size", offsetof( _VAConfigAttribValMaxFrameSize_bits, max_frame_size ), sizeof( uint32_t ) );
// 	swigStructField( "_VAConfigAttribValMaxFrameSize_bits-multiple_pass", offsetof( _VAConfigAttribValMaxFrameSize_bits, multiple_pass ), sizeof( uint32_t ) );
// 	printf( "drop %zu end-structure\n", sizeof( _VAConfigAttribValMaxFrameSize_bits ) );

	swigComment("union _VAConfigAttribValEncJPEG\n");
	printf( "begin-structure VAConfigAttribValEncJPEG\n" );
	printf( "drop %zu end-structure\n", sizeof( union _VAConfigAttribValEncJPEG ) );

// 	swigComment("_VAConfigAttribValEncJPEG_bits\n");
// 	printf( "begin-structure _VAConfigAttribValEncJPEG_bits\n" );
// 	swigStructField( "_VAConfigAttribValEncJPEG_bits-max_num_huffman_tables", offsetof( _VAConfigAttribValEncJPEG_bits, max_num_huffman_tables ), sizeof( uint32_t ) );
// 	swigStructField( "_VAConfigAttribValEncJPEG_bits-max_num_quantization_tables", offsetof( _VAConfigAttribValEncJPEG_bits, max_num_quantization_tables ), sizeof( uint32_t ) );
// 	swigStructField( "_VAConfigAttribValEncJPEG_bits-arithmatic_coding_mode", offsetof( _VAConfigAttribValEncJPEG_bits, arithmatic_coding_mode ), sizeof( uint32_t ) );
// 	swigStructField( "_VAConfigAttribValEncJPEG_bits-non_interleaved_mode", offsetof( _VAConfigAttribValEncJPEG_bits, non_interleaved_mode ), sizeof( uint32_t ) );
// 	swigStructField( "_VAConfigAttribValEncJPEG_bits-differential_mode", offsetof( _VAConfigAttribValEncJPEG_bits, differential_mode ), sizeof( uint32_t ) );
// 	swigStructField( "_VAConfigAttribValEncJPEG_bits-max_num_scans", offsetof( _VAConfigAttribValEncJPEG_bits, max_num_scans ), sizeof( uint32_t ) );
// 	swigStructField( "_VAConfigAttribValEncJPEG_bits-progressive_dct_mode", offsetof( _VAConfigAttribValEncJPEG_bits, progressive_dct_mode ), sizeof( uint32_t ) );
// 	swigStructField( "_VAConfigAttribValEncJPEG_bits-max_num_components", offsetof( _VAConfigAttribValEncJPEG_bits, max_num_components ), sizeof( uint32_t ) );
// 	printf( "drop %zu end-structure\n", sizeof( _VAConfigAttribValEncJPEG_bits ) );

	swigComment("union _VAConfigAttribValEncROI\n");
	printf( "begin-structure VAConfigAttribValEncROI\n" );
	printf( "drop %zu end-structure\n", sizeof( union _VAConfigAttribValEncROI ) );

// 	swigComment("_VAConfigAttribValEncROI_bits\n");
// 	printf( "begin-structure _VAConfigAttribValEncROI_bits\n" );
// 	swigStructField( "_VAConfigAttribValEncROI_bits-reserved", offsetof( _VAConfigAttribValEncROI_bits, reserved ), sizeof( uint32_t ) );
// 	swigStructField( "_VAConfigAttribValEncROI_bits-num_roi_regions", offsetof( _VAConfigAttribValEncROI_bits, num_roi_regions ), sizeof( uint32_t ) );
// 	swigStructField( "_VAConfigAttribValEncROI_bits-roi_rc_priority_support", offsetof( _VAConfigAttribValEncROI_bits, roi_rc_priority_support ), sizeof( uint32_t ) );
// 	swigStructField( "_VAConfigAttribValEncROI_bits-roi_rc_qp_delta_support", offsetof( _VAConfigAttribValEncROI_bits, roi_rc_qp_delta_support ), sizeof( uint32_t ) );
// 	printf( "drop %zu end-structure\n", sizeof( _VAConfigAttribValEncROI_bits ) );

	swigComment("union _VAConfigAttribValEncRateControlExt\n");
	printf( "begin-structure VAConfigAttribValEncRateControlExt\n" );
	printf( "drop %zu end-structure\n", sizeof( union _VAConfigAttribValEncRateControlExt ) );

// 	swigComment("_VAConfigAttribValEncRateControlExt_bits\n");
// 	printf( "begin-structure _VAConfigAttribValEncRateControlExt_bits\n" );
// 	swigStructField( "_VAConfigAttribValEncRateControlExt_bits-reserved", offsetof( _VAConfigAttribValEncRateControlExt_bits, reserved ), sizeof( uint32_t ) );
// 	swigStructField( "_VAConfigAttribValEncRateControlExt_bits-temporal_layer_bitrate_control_flag", offsetof( _VAConfigAttribValEncRateControlExt_bits, temporal_layer_bitrate_control_flag ), sizeof( uint32_t ) );
// 	swigStructField( "_VAConfigAttribValEncRateControlExt_bits-max_num_temporal_layers_minus1", offsetof( _VAConfigAttribValEncRateControlExt_bits, max_num_temporal_layers_minus1 ), sizeof( uint32_t ) );
// 	printf( "drop %zu end-structure\n", sizeof( _VAConfigAttribValEncRateControlExt_bits ) );

	swigComment("union _VAConfigAttribValMultipleFrame\n");
	printf( "begin-structure VAConfigAttribValMultipleFrame\n" );
	printf( "drop %zu end-structure\n", sizeof( union _VAConfigAttribValMultipleFrame ) );

// 	swigComment("_VAConfigAttribValMultipleFrame_bits\n");
// 	printf( "begin-structure _VAConfigAttribValMultipleFrame_bits\n" );
// 	swigStructField( "_VAConfigAttribValMultipleFrame_bits-max_num_concurrent_frames", offsetof( _VAConfigAttribValMultipleFrame_bits, max_num_concurrent_frames ), sizeof( uint32_t ) );
// 	swigStructField( "_VAConfigAttribValMultipleFrame_bits-reserved", offsetof( _VAConfigAttribValMultipleFrame_bits, reserved ), sizeof( uint32_t ) );
// 	swigStructField( "_VAConfigAttribValMultipleFrame_bits-mixed_quality_level", offsetof( _VAConfigAttribValMultipleFrame_bits, mixed_quality_level ), sizeof( uint32_t ) );
// 	printf( "drop %zu end-structure\n", sizeof( _VAConfigAttribValMultipleFrame_bits ) );

	swigComment("union _VAConfigAttribValContextPriority\n");
	printf( "begin-structure VAConfigAttribValContextPriority\n" );
	printf( "drop %zu end-structure\n", sizeof( union _VAConfigAttribValContextPriority ) );

// 	swigComment("_VAConfigAttribValContextPriority_bits\n");
// 	printf( "begin-structure _VAConfigAttribValContextPriority_bits\n" );
// 	swigStructField( "_VAConfigAttribValContextPriority_bits-priority", offsetof( _VAConfigAttribValContextPriority_bits, priority ), sizeof( uint32_t ) );
// 	swigStructField( "_VAConfigAttribValContextPriority_bits-reserved", offsetof( _VAConfigAttribValContextPriority_bits, reserved ), sizeof( uint32_t ) );
// 	printf( "drop %zu end-structure\n", sizeof( _VAConfigAttribValContextPriority_bits ) );

	swigComment("union _VAConfigAttribValEncPerBlockControl\n");
	printf( "begin-structure VAConfigAttribValEncPerBlockControl\n" );
	printf( "drop %zu end-structure\n", sizeof( union _VAConfigAttribValEncPerBlockControl ) );

// 	swigComment("_VAConfigAttribValEncPerBlockControl_bits\n");
// 	printf( "begin-structure _VAConfigAttribValEncPerBlockControl_bits\n" );
// 	swigStructField( "_VAConfigAttribValEncPerBlockControl_bits-log2_delta_qp_block_size", offsetof( _VAConfigAttribValEncPerBlockControl_bits, log2_delta_qp_block_size ), sizeof( uint32_t ) );
// 	swigStructField( "_VAConfigAttribValEncPerBlockControl_bits-reserved", offsetof( _VAConfigAttribValEncPerBlockControl_bits, reserved ), sizeof( uint32_t ) );
// 	swigStructField( "_VAConfigAttribValEncPerBlockControl_bits-delta_qp_support", offsetof( _VAConfigAttribValEncPerBlockControl_bits, delta_qp_support ), sizeof( uint32_t ) );
// 	swigStructField( "_VAConfigAttribValEncPerBlockControl_bits-delta_qp_size_in_bytes", offsetof( _VAConfigAttribValEncPerBlockControl_bits, delta_qp_size_in_bytes ), sizeof( uint32_t ) );
// 	printf( "drop %zu end-structure\n", sizeof( _VAConfigAttribValEncPerBlockControl_bits ) );

	swigComment("struct _VAGenericValue\n");
	printf( "begin-structure VAGenericValue\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAGenericValue ) );

	swigComment("_VAGenericValue_value\n");
	printf( "begin-structure _VAGenericValue_value\n" );
	swigStructField( "_VAGenericValue_value-i", offsetof( _VAGenericValue_value, i ), sizeof( int32_t ) );
	swigStructField( "_VAGenericValue_value-p", offsetof( _VAGenericValue_value, p ), sizeof( void * ) );
	swigStructField( "_VAGenericValue_value-fn", offsetof( _VAGenericValue_value, fn ), sizeof( VAGenericFunc ) );
	swigStructField( "_VAGenericValue_value-f", offsetof( _VAGenericValue_value, f ), sizeof( float ) );
	printf( "drop %zu end-structure\n", sizeof( _VAGenericValue_value ) );

	swigComment("struct _VASurfaceAttrib\n");
	printf( "begin-structure VASurfaceAttrib\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VASurfaceAttrib ) );

	swigComment("struct _VASurfaceAttribExternalBuffers\n");
	printf( "begin-structure VASurfaceAttribExternalBuffers\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VASurfaceAttribExternalBuffers ) );

	swigComment("struct _VAContextParameterUpdateBuffer\n");
	printf( "begin-structure VAContextParameterUpdateBuffer\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAContextParameterUpdateBuffer ) );

// 	swigComment("_VAContextParameterUpdateBuffer_flags\n");
// 	printf( "begin-structure _VAContextParameterUpdateBuffer_flags\n" );
// 	swigStructField( "_VAContextParameterUpdateBuffer_flags-value", offsetof( _VAContextParameterUpdateBuffer_flags, value ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAContextParameterUpdateBuffer_flags-bits", offsetof( _VAContextParameterUpdateBuffer_flags, bits ), sizeof( _VAContextParameterUpdateBuffer_flags_bits ) );
// 	printf( "drop %zu end-structure\n", sizeof( _VAContextParameterUpdateBuffer_flags ) );

// // 	swigComment("_VAContextParameterUpdateBuffer_flags_bits\n");
// // 	printf( "begin-structure _VAContextParameterUpdateBuffer_flags_bits\n" );
// // 	swigStructField( "_VAContextParameterUpdateBuffer_flags_bits-reserved", offsetof( _VAContextParameterUpdateBuffer_flags_bits, reserved ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAContextParameterUpdateBuffer_flags_bits-context_priority_update", offsetof( _VAContextParameterUpdateBuffer_flags_bits, context_priority_update ), sizeof( uint32_t ) );
// // 	printf( "drop %zu end-structure\n", sizeof( _VAContextParameterUpdateBuffer_flags_bits ) );

	swigComment("struct _VAEncryptionSegmentInfo\n");
	printf( "begin-structure VAEncryptionSegmentInfo\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAEncryptionSegmentInfo ) );

	swigComment("struct _VAEncryptionParameters\n");
	printf( "begin-structure VAEncryptionParameters\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAEncryptionParameters ) );

	swigComment("struct _VAProcessingRateParameterEnc\n");
	printf( "begin-structure VAProcessingRateParameterEnc\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAProcessingRateParameterEnc ) );

	swigComment("struct _VAProcessingRateParameterDec\n");
	printf( "begin-structure VAProcessingRateParameterDec\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAProcessingRateParameterDec ) );

	swigComment("struct _VAProcessingRateParameter\n");
	printf( "begin-structure VAProcessingRateParameter\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAProcessingRateParameter ) );

	swigComment("struct _VAEncPackedHeaderParameterBuffer\n");
	printf( "begin-structure VAEncPackedHeaderParameterBuffer\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAEncPackedHeaderParameterBuffer ) );

	swigComment("struct _VAEncMiscParameterBuffer\n");
	printf( "begin-structure VAEncMiscParameterBuffer\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAEncMiscParameterBuffer ) );

	swigComment("struct _VAEncMiscParameterTemporalLayerStructure\n");
	printf( "begin-structure VAEncMiscParameterTemporalLayerStructure\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAEncMiscParameterTemporalLayerStructure ) );

	swigComment("struct _VAEncMiscParameterRateControl\n");
	printf( "begin-structure VAEncMiscParameterRateControl\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAEncMiscParameterRateControl ) );

// 	swigComment("_VAEncMiscParameterRateControl_rc_flags\n");
// 	printf( "begin-structure _VAEncMiscParameterRateControl_rc_flags\n" );
// 	swigStructField( "_VAEncMiscParameterRateControl_rc_flags-value", offsetof( _VAEncMiscParameterRateControl_rc_flags, value ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAEncMiscParameterRateControl_rc_flags-bits", offsetof( _VAEncMiscParameterRateControl_rc_flags, bits ), sizeof( _VAEncMiscParameterRateControl_rc_flags_bits ) );
// 	printf( "drop %zu end-structure\n", sizeof( _VAEncMiscParameterRateControl_rc_flags ) );

// // 	swigComment("_VAEncMiscParameterRateControl_rc_flags_bits\n");
// // 	printf( "begin-structure _VAEncMiscParameterRateControl_rc_flags_bits\n" );
// // 	swigStructField( "_VAEncMiscParameterRateControl_rc_flags_bits-cfs_I_frames", offsetof( _VAEncMiscParameterRateControl_rc_flags_bits, cfs_I_frames ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAEncMiscParameterRateControl_rc_flags_bits-mb_rate_control", offsetof( _VAEncMiscParameterRateControl_rc_flags_bits, mb_rate_control ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAEncMiscParameterRateControl_rc_flags_bits-enable_parallel_brc", offsetof( _VAEncMiscParameterRateControl_rc_flags_bits, enable_parallel_brc ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAEncMiscParameterRateControl_rc_flags_bits-reserved", offsetof( _VAEncMiscParameterRateControl_rc_flags_bits, reserved ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAEncMiscParameterRateControl_rc_flags_bits-enable_dynamic_scaling", offsetof( _VAEncMiscParameterRateControl_rc_flags_bits, enable_dynamic_scaling ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAEncMiscParameterRateControl_rc_flags_bits-temporal_id", offsetof( _VAEncMiscParameterRateControl_rc_flags_bits, temporal_id ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAEncMiscParameterRateControl_rc_flags_bits-disable_bit_stuffing", offsetof( _VAEncMiscParameterRateControl_rc_flags_bits, disable_bit_stuffing ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAEncMiscParameterRateControl_rc_flags_bits-frame_tolerance_mode", offsetof( _VAEncMiscParameterRateControl_rc_flags_bits, frame_tolerance_mode ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAEncMiscParameterRateControl_rc_flags_bits-reset", offsetof( _VAEncMiscParameterRateControl_rc_flags_bits, reset ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAEncMiscParameterRateControl_rc_flags_bits-disable_frame_skip", offsetof( _VAEncMiscParameterRateControl_rc_flags_bits, disable_frame_skip ), sizeof( uint32_t ) );
// // 	printf( "drop %zu end-structure\n", sizeof( _VAEncMiscParameterRateControl_rc_flags_bits ) );

	swigComment("struct _VAEncMiscParameterFrameRate\n");
	printf( "begin-structure VAEncMiscParameterFrameRate\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAEncMiscParameterFrameRate ) );

// 	swigComment("_VAEncMiscParameterFrameRate_framerate_flags\n");
// 	printf( "begin-structure _VAEncMiscParameterFrameRate_framerate_flags\n" );
// 	swigStructField( "_VAEncMiscParameterFrameRate_framerate_flags-value", offsetof( _VAEncMiscParameterFrameRate_framerate_flags, value ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAEncMiscParameterFrameRate_framerate_flags-bits", offsetof( _VAEncMiscParameterFrameRate_framerate_flags, bits ), sizeof( _VAEncMiscParameterFrameRate_framerate_flags_bits ) );
// 	printf( "drop %zu end-structure\n", sizeof( _VAEncMiscParameterFrameRate_framerate_flags ) );

// // 	swigComment("_VAEncMiscParameterFrameRate_framerate_flags_bits\n");
// // 	printf( "begin-structure _VAEncMiscParameterFrameRate_framerate_flags_bits\n" );
// // 	swigStructField( "_VAEncMiscParameterFrameRate_framerate_flags_bits-reserved", offsetof( _VAEncMiscParameterFrameRate_framerate_flags_bits, reserved ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAEncMiscParameterFrameRate_framerate_flags_bits-temporal_id", offsetof( _VAEncMiscParameterFrameRate_framerate_flags_bits, temporal_id ), sizeof( uint32_t ) );
// // 	printf( "drop %zu end-structure\n", sizeof( _VAEncMiscParameterFrameRate_framerate_flags_bits ) );

	swigComment("struct _VAEncMiscParameterMaxSliceSize\n");
	printf( "begin-structure VAEncMiscParameterMaxSliceSize\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAEncMiscParameterMaxSliceSize ) );

	swigComment("struct _VAEncMiscParameterAIR\n");
	printf( "begin-structure VAEncMiscParameterAIR\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAEncMiscParameterAIR ) );

	swigComment("struct _VAEncMiscParameterRIR\n");
	printf( "begin-structure VAEncMiscParameterRIR\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAEncMiscParameterRIR ) );

// 	swigComment("_VAEncMiscParameterRIR_rir_flags\n");
// 	printf( "begin-structure _VAEncMiscParameterRIR_rir_flags\n" );
// 	swigStructField( "_VAEncMiscParameterRIR_rir_flags-value", offsetof( _VAEncMiscParameterRIR_rir_flags, value ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAEncMiscParameterRIR_rir_flags-bits", offsetof( _VAEncMiscParameterRIR_rir_flags, bits ), sizeof( _VAEncMiscParameterRIR_rir_flags_bits ) );
// 	printf( "drop %zu end-structure\n", sizeof( _VAEncMiscParameterRIR_rir_flags ) );

// // 	swigComment("_VAEncMiscParameterRIR_rir_flags_bits\n");
// // 	printf( "begin-structure _VAEncMiscParameterRIR_rir_flags_bits\n" );
// // 	swigStructField( "_VAEncMiscParameterRIR_rir_flags_bits-enable_rir_column", offsetof( _VAEncMiscParameterRIR_rir_flags_bits, enable_rir_column ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAEncMiscParameterRIR_rir_flags_bits-reserved", offsetof( _VAEncMiscParameterRIR_rir_flags_bits, reserved ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAEncMiscParameterRIR_rir_flags_bits-enable_rir_row", offsetof( _VAEncMiscParameterRIR_rir_flags_bits, enable_rir_row ), sizeof( uint32_t ) );
// // 	printf( "drop %zu end-structure\n", sizeof( _VAEncMiscParameterRIR_rir_flags_bits ) );

	swigComment("struct _VAEncMiscParameterHRD\n");
	printf( "begin-structure VAEncMiscParameterHRD\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAEncMiscParameterHRD ) );

	swigComment("struct _VAEncMiscParameterBufferMaxFrameSize\n");
	printf( "begin-structure VAEncMiscParameterBufferMaxFrameSize\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAEncMiscParameterBufferMaxFrameSize ) );

	swigComment("struct _VAEncMiscParameterBufferMultiPassFrameSize\n");
	printf( "begin-structure VAEncMiscParameterBufferMultiPassFrameSize\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAEncMiscParameterBufferMultiPassFrameSize ) );

	swigComment("struct _VAEncMiscParameterBufferQualityLevel\n");
	printf( "begin-structure VAEncMiscParameterBufferQualityLevel\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAEncMiscParameterBufferQualityLevel ) );

	swigComment("struct _VAEncMiscParameterQuantization\n");
	printf( "begin-structure VAEncMiscParameterQuantization\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAEncMiscParameterQuantization ) );

// 	swigComment("_VAEncMiscParameterQuantization_quantization_flags\n");
// 	printf( "begin-structure _VAEncMiscParameterQuantization_quantization_flags\n" );
// 	swigStructField( "_VAEncMiscParameterQuantization_quantization_flags-value", offsetof( _VAEncMiscParameterQuantization_quantization_flags, value ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAEncMiscParameterQuantization_quantization_flags-bits", offsetof( _VAEncMiscParameterQuantization_quantization_flags, bits ), sizeof( _VAEncMiscParameterQuantization_quantization_flags_bits ) );
// 	printf( "drop %zu end-structure\n", sizeof( _VAEncMiscParameterQuantization_quantization_flags ) );

// // 	swigComment("_VAEncMiscParameterQuantization_quantization_flags_bits\n");
// // 	printf( "begin-structure _VAEncMiscParameterQuantization_quantization_flags_bits\n" );
// // 	swigStructField( "_VAEncMiscParameterQuantization_quantization_flags_bits-reserved", offsetof( _VAEncMiscParameterQuantization_quantization_flags_bits, reserved ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAEncMiscParameterQuantization_quantization_flags_bits-disable_trellis", offsetof( _VAEncMiscParameterQuantization_quantization_flags_bits, disable_trellis ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAEncMiscParameterQuantization_quantization_flags_bits-enable_trellis_I", offsetof( _VAEncMiscParameterQuantization_quantization_flags_bits, enable_trellis_I ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAEncMiscParameterQuantization_quantization_flags_bits-enable_trellis_P", offsetof( _VAEncMiscParameterQuantization_quantization_flags_bits, enable_trellis_P ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAEncMiscParameterQuantization_quantization_flags_bits-enable_trellis_B", offsetof( _VAEncMiscParameterQuantization_quantization_flags_bits, enable_trellis_B ), sizeof( uint32_t ) );
// // 	printf( "drop %zu end-structure\n", sizeof( _VAEncMiscParameterQuantization_quantization_flags_bits ) );

	swigComment("struct _VAEncMiscParameterSkipFrame\n");
	printf( "begin-structure VAEncMiscParameterSkipFrame\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAEncMiscParameterSkipFrame ) );

	swigComment("struct _VAEncROI\n");
	printf( "begin-structure VAEncROI\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAEncROI ) );

	swigComment("struct _VAEncMiscParameterBufferROI\n");
	printf( "begin-structure VAEncMiscParameterBufferROI\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAEncMiscParameterBufferROI ) );

// 	swigComment("_VAEncMiscParameterBufferROI_roi_flags\n");
// 	printf( "begin-structure _VAEncMiscParameterBufferROI_roi_flags\n" );
// 	swigStructField( "_VAEncMiscParameterBufferROI_roi_flags-value", offsetof( _VAEncMiscParameterBufferROI_roi_flags, value ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAEncMiscParameterBufferROI_roi_flags-bits", offsetof( _VAEncMiscParameterBufferROI_roi_flags, bits ), sizeof( _VAEncMiscParameterBufferROI_roi_flags_bits ) );
// 	printf( "drop %zu end-structure\n", sizeof( _VAEncMiscParameterBufferROI_roi_flags ) );

// // 	swigComment("_VAEncMiscParameterBufferROI_roi_flags_bits\n");
// // 	printf( "begin-structure _VAEncMiscParameterBufferROI_roi_flags_bits\n" );
// // 	swigStructField( "_VAEncMiscParameterBufferROI_roi_flags_bits-reserved", offsetof( _VAEncMiscParameterBufferROI_roi_flags_bits, reserved ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAEncMiscParameterBufferROI_roi_flags_bits-roi_value_is_qp_delta", offsetof( _VAEncMiscParameterBufferROI_roi_flags_bits, roi_value_is_qp_delta ), sizeof( uint32_t ) );
// // 	printf( "drop %zu end-structure\n", sizeof( _VAEncMiscParameterBufferROI_roi_flags_bits ) );

	swigComment("struct _VAEncMiscParameterBufferDirtyRect\n");
	printf( "begin-structure VAEncMiscParameterBufferDirtyRect\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAEncMiscParameterBufferDirtyRect ) );

	swigComment("struct _VAEncMiscParameterParallelRateControl\n");
	printf( "begin-structure VAEncMiscParameterParallelRateControl\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAEncMiscParameterParallelRateControl ) );

	swigComment("struct _VAEncMiscParameterEncQuality\n");
	printf( "begin-structure VAEncMiscParameterEncQuality\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAEncMiscParameterEncQuality ) );

	swigComment("struct _VAEncMiscParameterCustomRoundingControl\n");
	printf( "begin-structure VAEncMiscParameterCustomRoundingControl\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAEncMiscParameterCustomRoundingControl ) );

	swigComment("_VAEncMiscParameterCustomRoundingControl_rounding_offset_setting\n");
	printf( "begin-structure _VAEncMiscParameterCustomRoundingControl_rounding_offset_setting\n" );
	swigStructField( "_VAEncMiscParameterCustomRoundingControl_rounding_offset_setting-value", offsetof( _VAEncMiscParameterCustomRoundingControl_rounding_offset_setting, value ), sizeof( uint32_t ) );
// 	swigStructField( "_VAEncMiscParameterCustomRoundingControl_rounding_offset_setting-bits", offsetof( _VAEncMiscParameterCustomRoundingControl_rounding_offset_setting, bits ), sizeof( _VAEncMiscParameterCustomRoundingControl_rounding_offset_setting_bits ) );
	printf( "drop %zu end-structure\n", sizeof( _VAEncMiscParameterCustomRoundingControl_rounding_offset_setting ) );

// 	swigComment("_VAEncMiscParameterCustomRoundingControl_rounding_offset_setting_bits\n");
// 	printf( "begin-structure _VAEncMiscParameterCustomRoundingControl_rounding_offset_setting_bits\n" );
// 	swigStructField( "_VAEncMiscParameterCustomRoundingControl_rounding_offset_setting_bits-reserved", offsetof( _VAEncMiscParameterCustomRoundingControl_rounding_offset_setting_bits, reserved ), sizeof( uint32_t ) );
// 	swigStructField( "_VAEncMiscParameterCustomRoundingControl_rounding_offset_setting_bits-enable_custom_rouding_intra", offsetof( _VAEncMiscParameterCustomRoundingControl_rounding_offset_setting_bits, enable_custom_rouding_intra ), sizeof( uint32_t ) );
// 	swigStructField( "_VAEncMiscParameterCustomRoundingControl_rounding_offset_setting_bits-enable_custom_rounding_inter", offsetof( _VAEncMiscParameterCustomRoundingControl_rounding_offset_setting_bits, enable_custom_rounding_inter ), sizeof( uint32_t ) );
// 	swigStructField( "_VAEncMiscParameterCustomRoundingControl_rounding_offset_setting_bits-rounding_offset_intra", offsetof( _VAEncMiscParameterCustomRoundingControl_rounding_offset_setting_bits, rounding_offset_intra ), sizeof( uint32_t ) );
// 	swigStructField( "_VAEncMiscParameterCustomRoundingControl_rounding_offset_setting_bits-rounding_offset_inter", offsetof( _VAEncMiscParameterCustomRoundingControl_rounding_offset_setting_bits, rounding_offset_inter ), sizeof( uint32_t ) );
// 	printf( "drop %zu end-structure\n", sizeof( _VAEncMiscParameterCustomRoundingControl_rounding_offset_setting_bits ) );

	swigComment("struct _VASliceParameterBufferBase\n");
	printf( "begin-structure VASliceParameterBufferBase\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VASliceParameterBufferBase ) );

	swigComment("struct _VAHuffmanTableBufferJPEGBaseline\n");
	printf( "begin-structure VAHuffmanTableBufferJPEGBaseline\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAHuffmanTableBufferJPEGBaseline ) );

	swigComment("_VAHuffmanTableBufferJPEGBaseline_huffman_table\n");
	printf( "begin-structure _VAHuffmanTableBufferJPEGBaseline_huffman_table\n" );
	swigStructField( "_VAHuffmanTableBufferJPEGBaseline_huffman_table-dc_values", offsetof( _VAHuffmanTableBufferJPEGBaseline_huffman_table, dc_values ), sizeof( uint8_t [12] ) );
	swigStructField( "_VAHuffmanTableBufferJPEGBaseline_huffman_table-ac_values", offsetof( _VAHuffmanTableBufferJPEGBaseline_huffman_table, ac_values ), sizeof( uint8_t [162] ) );
	swigStructField( "_VAHuffmanTableBufferJPEGBaseline_huffman_table-pad", offsetof( _VAHuffmanTableBufferJPEGBaseline_huffman_table, pad ), sizeof( uint8_t [2] ) );
	swigStructField( "_VAHuffmanTableBufferJPEGBaseline_huffman_table-num_dc_codes", offsetof( _VAHuffmanTableBufferJPEGBaseline_huffman_table, num_dc_codes ), sizeof( uint8_t [16] ) );
	swigStructField( "_VAHuffmanTableBufferJPEGBaseline_huffman_table-num_ac_codes", offsetof( _VAHuffmanTableBufferJPEGBaseline_huffman_table, num_ac_codes ), sizeof( uint8_t [16] ) );
	printf( "drop %zu end-structure\n", sizeof( _VAHuffmanTableBufferJPEGBaseline_huffman_table ) );

	swigComment("struct _VAPictureParameterBufferMPEG2\n");
	printf( "begin-structure VAPictureParameterBufferMPEG2\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAPictureParameterBufferMPEG2 ) );

	swigComment("_VAPictureParameterBufferMPEG2_picture_coding_extension\n");
	printf( "begin-structure _VAPictureParameterBufferMPEG2_picture_coding_extension\n" );
	swigStructField( "_VAPictureParameterBufferMPEG2_picture_coding_extension-value", offsetof( _VAPictureParameterBufferMPEG2_picture_coding_extension, value ), sizeof( uint32_t ) );
// 	swigStructField( "_VAPictureParameterBufferMPEG2_picture_coding_extension-bits", offsetof( _VAPictureParameterBufferMPEG2_picture_coding_extension, bits ), sizeof( _VAPictureParameterBufferMPEG2_picture_coding_extension_bits ) );
	printf( "drop %zu end-structure\n", sizeof( _VAPictureParameterBufferMPEG2_picture_coding_extension ) );

// 	swigComment("_VAPictureParameterBufferMPEG2_picture_coding_extension_bits\n");
// 	printf( "begin-structure _VAPictureParameterBufferMPEG2_picture_coding_extension_bits\n" );
// 	swigStructField( "_VAPictureParameterBufferMPEG2_picture_coding_extension_bits-top_field_first", offsetof( _VAPictureParameterBufferMPEG2_picture_coding_extension_bits, top_field_first ), sizeof( uint32_t ) );
// 	swigStructField( "_VAPictureParameterBufferMPEG2_picture_coding_extension_bits-concealment_motion_vectors", offsetof( _VAPictureParameterBufferMPEG2_picture_coding_extension_bits, concealment_motion_vectors ), sizeof( uint32_t ) );
// 	swigStructField( "_VAPictureParameterBufferMPEG2_picture_coding_extension_bits-repeat_first_field", offsetof( _VAPictureParameterBufferMPEG2_picture_coding_extension_bits, repeat_first_field ), sizeof( uint32_t ) );
// 	swigStructField( "_VAPictureParameterBufferMPEG2_picture_coding_extension_bits-is_first_field", offsetof( _VAPictureParameterBufferMPEG2_picture_coding_extension_bits, is_first_field ), sizeof( uint32_t ) );
// 	swigStructField( "_VAPictureParameterBufferMPEG2_picture_coding_extension_bits-picture_structure", offsetof( _VAPictureParameterBufferMPEG2_picture_coding_extension_bits, picture_structure ), sizeof( uint32_t ) );
// 	swigStructField( "_VAPictureParameterBufferMPEG2_picture_coding_extension_bits-intra_dc_precision", offsetof( _VAPictureParameterBufferMPEG2_picture_coding_extension_bits, intra_dc_precision ), sizeof( uint32_t ) );
// 	swigStructField( "_VAPictureParameterBufferMPEG2_picture_coding_extension_bits-q_scale_type", offsetof( _VAPictureParameterBufferMPEG2_picture_coding_extension_bits, q_scale_type ), sizeof( uint32_t ) );
// 	swigStructField( "_VAPictureParameterBufferMPEG2_picture_coding_extension_bits-intra_vlc_format", offsetof( _VAPictureParameterBufferMPEG2_picture_coding_extension_bits, intra_vlc_format ), sizeof( uint32_t ) );
// 	swigStructField( "_VAPictureParameterBufferMPEG2_picture_coding_extension_bits-frame_pred_frame_dct", offsetof( _VAPictureParameterBufferMPEG2_picture_coding_extension_bits, frame_pred_frame_dct ), sizeof( uint32_t ) );
// 	swigStructField( "_VAPictureParameterBufferMPEG2_picture_coding_extension_bits-alternate_scan", offsetof( _VAPictureParameterBufferMPEG2_picture_coding_extension_bits, alternate_scan ), sizeof( uint32_t ) );
// 	swigStructField( "_VAPictureParameterBufferMPEG2_picture_coding_extension_bits-progressive_frame", offsetof( _VAPictureParameterBufferMPEG2_picture_coding_extension_bits, progressive_frame ), sizeof( uint32_t ) );
// 	printf( "drop %zu end-structure\n", sizeof( _VAPictureParameterBufferMPEG2_picture_coding_extension_bits ) );

	swigComment("struct _VAIQMatrixBufferMPEG2\n");
	printf( "begin-structure VAIQMatrixBufferMPEG2\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAIQMatrixBufferMPEG2 ) );

	swigComment("struct _VASliceParameterBufferMPEG2\n");
	printf( "begin-structure VASliceParameterBufferMPEG2\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VASliceParameterBufferMPEG2 ) );

	swigComment("struct _VAMacroblockParameterBufferMPEG2\n");
	printf( "begin-structure VAMacroblockParameterBufferMPEG2\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAMacroblockParameterBufferMPEG2 ) );

	swigComment("_VAMacroblockParameterBufferMPEG2_macroblock_modes\n");
	printf( "begin-structure _VAMacroblockParameterBufferMPEG2_macroblock_modes\n" );
	swigStructField( "_VAMacroblockParameterBufferMPEG2_macroblock_modes-value", offsetof( _VAMacroblockParameterBufferMPEG2_macroblock_modes, value ), sizeof( uint32_t ) );
// 	swigStructField( "_VAMacroblockParameterBufferMPEG2_macroblock_modes-bits", offsetof( _VAMacroblockParameterBufferMPEG2_macroblock_modes, bits ), sizeof( _VAMacroblockParameterBufferMPEG2_macroblock_modes_bits ) );
	printf( "drop %zu end-structure\n", sizeof( _VAMacroblockParameterBufferMPEG2_macroblock_modes ) );

// 	swigComment("_VAMacroblockParameterBufferMPEG2_macroblock_modes_bits\n");
// 	printf( "begin-structure _VAMacroblockParameterBufferMPEG2_macroblock_modes_bits\n" );
// 	swigStructField( "_VAMacroblockParameterBufferMPEG2_macroblock_modes_bits-dct_type", offsetof( _VAMacroblockParameterBufferMPEG2_macroblock_modes_bits, dct_type ), sizeof( uint32_t ) );
// 	swigStructField( "_VAMacroblockParameterBufferMPEG2_macroblock_modes_bits-frame_motion_type", offsetof( _VAMacroblockParameterBufferMPEG2_macroblock_modes_bits, frame_motion_type ), sizeof( uint32_t ) );
// 	swigStructField( "_VAMacroblockParameterBufferMPEG2_macroblock_modes_bits-field_motion_type", offsetof( _VAMacroblockParameterBufferMPEG2_macroblock_modes_bits, field_motion_type ), sizeof( uint32_t ) );
// 	printf( "drop %zu end-structure\n", sizeof( _VAMacroblockParameterBufferMPEG2_macroblock_modes_bits ) );

	swigComment("struct _VAPictureParameterBufferMPEG4\n");
	printf( "begin-structure VAPictureParameterBufferMPEG4\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAPictureParameterBufferMPEG4 ) );

// 	swigComment("_VAPictureParameterBufferMPEG4_vop_fields\n");
// 	printf( "begin-structure _VAPictureParameterBufferMPEG4_vop_fields\n" );
// 	swigStructField( "_VAPictureParameterBufferMPEG4_vop_fields-value", offsetof( _VAPictureParameterBufferMPEG4_vop_fields, value ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferMPEG4_vop_fields-bits", offsetof( _VAPictureParameterBufferMPEG4_vop_fields, bits ), sizeof( _VAPictureParameterBufferMPEG4_vop_fields_bits ) );
// 	printf( "drop %zu end-structure\n", sizeof( _VAPictureParameterBufferMPEG4_vop_fields ) );

// // 	swigComment("_VAPictureParameterBufferMPEG4_vop_fields_bits\n");
// // 	printf( "begin-structure _VAPictureParameterBufferMPEG4_vop_fields_bits\n" );
// // 	swigStructField( "_VAPictureParameterBufferMPEG4_vop_fields_bits-vop_coding_type", offsetof( _VAPictureParameterBufferMPEG4_vop_fields_bits, vop_coding_type ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferMPEG4_vop_fields_bits-backward_reference_vop_coding_type", offsetof( _VAPictureParameterBufferMPEG4_vop_fields_bits, backward_reference_vop_coding_type ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferMPEG4_vop_fields_bits-vop_rounding_type", offsetof( _VAPictureParameterBufferMPEG4_vop_fields_bits, vop_rounding_type ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferMPEG4_vop_fields_bits-top_field_first", offsetof( _VAPictureParameterBufferMPEG4_vop_fields_bits, top_field_first ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferMPEG4_vop_fields_bits-intra_dc_vlc_thr", offsetof( _VAPictureParameterBufferMPEG4_vop_fields_bits, intra_dc_vlc_thr ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferMPEG4_vop_fields_bits-alternate_vertical_scan_flag", offsetof( _VAPictureParameterBufferMPEG4_vop_fields_bits, alternate_vertical_scan_flag ), sizeof( uint32_t ) );
// // 	printf( "drop %zu end-structure\n", sizeof( _VAPictureParameterBufferMPEG4_vop_fields_bits ) );

// 	swigComment("_VAPictureParameterBufferMPEG4_vol_fields\n");
// 	printf( "begin-structure _VAPictureParameterBufferMPEG4_vol_fields\n" );
// 	swigStructField( "_VAPictureParameterBufferMPEG4_vol_fields-value", offsetof( _VAPictureParameterBufferMPEG4_vol_fields, value ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferMPEG4_vol_fields-bits", offsetof( _VAPictureParameterBufferMPEG4_vol_fields, bits ), sizeof( _VAPictureParameterBufferMPEG4_vol_fields_bits ) );
// 	printf( "drop %zu end-structure\n", sizeof( _VAPictureParameterBufferMPEG4_vol_fields ) );

// // 	swigComment("_VAPictureParameterBufferMPEG4_vol_fields_bits\n");
// // 	printf( "begin-structure _VAPictureParameterBufferMPEG4_vol_fields_bits\n" );
// // 	swigStructField( "_VAPictureParameterBufferMPEG4_vol_fields_bits-interlaced", offsetof( _VAPictureParameterBufferMPEG4_vol_fields_bits, interlaced ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferMPEG4_vol_fields_bits-data_partitioned", offsetof( _VAPictureParameterBufferMPEG4_vol_fields_bits, data_partitioned ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferMPEG4_vol_fields_bits-sprite_enable", offsetof( _VAPictureParameterBufferMPEG4_vol_fields_bits, sprite_enable ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferMPEG4_vol_fields_bits-short_video_header", offsetof( _VAPictureParameterBufferMPEG4_vol_fields_bits, short_video_header ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferMPEG4_vol_fields_bits-obmc_disable", offsetof( _VAPictureParameterBufferMPEG4_vol_fields_bits, obmc_disable ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferMPEG4_vol_fields_bits-reversible_vlc", offsetof( _VAPictureParameterBufferMPEG4_vol_fields_bits, reversible_vlc ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferMPEG4_vol_fields_bits-resync_marker_disable", offsetof( _VAPictureParameterBufferMPEG4_vol_fields_bits, resync_marker_disable ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferMPEG4_vol_fields_bits-chroma_format", offsetof( _VAPictureParameterBufferMPEG4_vol_fields_bits, chroma_format ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferMPEG4_vol_fields_bits-sprite_warping_accuracy", offsetof( _VAPictureParameterBufferMPEG4_vol_fields_bits, sprite_warping_accuracy ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferMPEG4_vol_fields_bits-quarter_sample", offsetof( _VAPictureParameterBufferMPEG4_vol_fields_bits, quarter_sample ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferMPEG4_vol_fields_bits-quant_type", offsetof( _VAPictureParameterBufferMPEG4_vol_fields_bits, quant_type ), sizeof( uint32_t ) );
// // 	printf( "drop %zu end-structure\n", sizeof( _VAPictureParameterBufferMPEG4_vol_fields_bits ) );

	swigComment("struct _VAIQMatrixBufferMPEG4\n");
	printf( "begin-structure VAIQMatrixBufferMPEG4\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAIQMatrixBufferMPEG4 ) );

	swigComment("struct _VASliceParameterBufferMPEG4\n");
	printf( "begin-structure VASliceParameterBufferMPEG4\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VASliceParameterBufferMPEG4 ) );

	swigComment("struct _VAPictureParameterBufferVC1\n");
	printf( "begin-structure VAPictureParameterBufferVC1\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAPictureParameterBufferVC1 ) );

// 	swigComment("_VAPictureParameterBufferVC1_transform_fields\n");
// 	printf( "begin-structure _VAPictureParameterBufferVC1_transform_fields\n" );
// 	swigStructField( "_VAPictureParameterBufferVC1_transform_fields-value", offsetof( _VAPictureParameterBufferVC1_transform_fields, value ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_transform_fields-bits", offsetof( _VAPictureParameterBufferVC1_transform_fields, bits ), sizeof( _VAPictureParameterBufferVC1_transform_fields_bits ) );
// 	printf( "drop %zu end-structure\n", sizeof( _VAPictureParameterBufferVC1_transform_fields ) );

// // 	swigComment("_VAPictureParameterBufferVC1_transform_fields_bits\n");
// // 	printf( "begin-structure _VAPictureParameterBufferVC1_transform_fields_bits\n" );
// // 	swigStructField( "_VAPictureParameterBufferVC1_transform_fields_bits-intra_transform_dc_table", offsetof( _VAPictureParameterBufferVC1_transform_fields_bits, intra_transform_dc_table ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_transform_fields_bits-transform_ac_codingset_idx1", offsetof( _VAPictureParameterBufferVC1_transform_fields_bits, transform_ac_codingset_idx1 ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_transform_fields_bits-transform_ac_codingset_idx2", offsetof( _VAPictureParameterBufferVC1_transform_fields_bits, transform_ac_codingset_idx2 ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_transform_fields_bits-mb_level_transform_type_flag", offsetof( _VAPictureParameterBufferVC1_transform_fields_bits, mb_level_transform_type_flag ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_transform_fields_bits-variable_sized_transform_flag", offsetof( _VAPictureParameterBufferVC1_transform_fields_bits, variable_sized_transform_flag ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_transform_fields_bits-frame_level_transform_type", offsetof( _VAPictureParameterBufferVC1_transform_fields_bits, frame_level_transform_type ), sizeof( uint32_t ) );
// // 	printf( "drop %zu end-structure\n", sizeof( _VAPictureParameterBufferVC1_transform_fields_bits ) );

// 	swigComment("_VAPictureParameterBufferVC1_pic_quantizer_fields\n");
// 	printf( "begin-structure _VAPictureParameterBufferVC1_pic_quantizer_fields\n" );
// 	swigStructField( "_VAPictureParameterBufferVC1_pic_quantizer_fields-value", offsetof( _VAPictureParameterBufferVC1_pic_quantizer_fields, value ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_pic_quantizer_fields-bits", offsetof( _VAPictureParameterBufferVC1_pic_quantizer_fields, bits ), sizeof( _VAPictureParameterBufferVC1_pic_quantizer_fields_bits ) );
// 	printf( "drop %zu end-structure\n", sizeof( _VAPictureParameterBufferVC1_pic_quantizer_fields ) );

// // 	swigComment("_VAPictureParameterBufferVC1_pic_quantizer_fields_bits\n");
// // 	printf( "begin-structure _VAPictureParameterBufferVC1_pic_quantizer_fields_bits\n" );
// // 	swigStructField( "_VAPictureParameterBufferVC1_pic_quantizer_fields_bits-pic_quantizer_type", offsetof( _VAPictureParameterBufferVC1_pic_quantizer_fields_bits, pic_quantizer_type ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_pic_quantizer_fields_bits-quantizer", offsetof( _VAPictureParameterBufferVC1_pic_quantizer_fields_bits, quantizer ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_pic_quantizer_fields_bits-dq_sb_edge", offsetof( _VAPictureParameterBufferVC1_pic_quantizer_fields_bits, dq_sb_edge ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_pic_quantizer_fields_bits-alt_pic_quantizer", offsetof( _VAPictureParameterBufferVC1_pic_quantizer_fields_bits, alt_pic_quantizer ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_pic_quantizer_fields_bits-dq_db_edge", offsetof( _VAPictureParameterBufferVC1_pic_quantizer_fields_bits, dq_db_edge ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_pic_quantizer_fields_bits-half_qp", offsetof( _VAPictureParameterBufferVC1_pic_quantizer_fields_bits, half_qp ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_pic_quantizer_fields_bits-dq_profile", offsetof( _VAPictureParameterBufferVC1_pic_quantizer_fields_bits, dq_profile ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_pic_quantizer_fields_bits-pic_quantizer_scale", offsetof( _VAPictureParameterBufferVC1_pic_quantizer_fields_bits, pic_quantizer_scale ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_pic_quantizer_fields_bits-dquant", offsetof( _VAPictureParameterBufferVC1_pic_quantizer_fields_bits, dquant ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_pic_quantizer_fields_bits-dq_frame", offsetof( _VAPictureParameterBufferVC1_pic_quantizer_fields_bits, dq_frame ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_pic_quantizer_fields_bits-dq_binary_level", offsetof( _VAPictureParameterBufferVC1_pic_quantizer_fields_bits, dq_binary_level ), sizeof( uint32_t ) );
// // 	printf( "drop %zu end-structure\n", sizeof( _VAPictureParameterBufferVC1_pic_quantizer_fields_bits ) );

// 	swigComment("_VAPictureParameterBufferVC1_mv_fields\n");
// 	printf( "begin-structure _VAPictureParameterBufferVC1_mv_fields\n" );
// 	swigStructField( "_VAPictureParameterBufferVC1_mv_fields-value", offsetof( _VAPictureParameterBufferVC1_mv_fields, value ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_mv_fields-bits", offsetof( _VAPictureParameterBufferVC1_mv_fields, bits ), sizeof( _VAPictureParameterBufferVC1_mv_fields_bits ) );
// 	printf( "drop %zu end-structure\n", sizeof( _VAPictureParameterBufferVC1_mv_fields ) );

// // 	swigComment("_VAPictureParameterBufferVC1_mv_fields_bits\n");
// // 	printf( "begin-structure _VAPictureParameterBufferVC1_mv_fields_bits\n" );
// // 	swigStructField( "_VAPictureParameterBufferVC1_mv_fields_bits-four_mv_switch", offsetof( _VAPictureParameterBufferVC1_mv_fields_bits, four_mv_switch ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_mv_fields_bits-mv_table", offsetof( _VAPictureParameterBufferVC1_mv_fields_bits, mv_table ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_mv_fields_bits-two_mv_block_pattern_table", offsetof( _VAPictureParameterBufferVC1_mv_fields_bits, two_mv_block_pattern_table ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_mv_fields_bits-four_mv_block_pattern_table", offsetof( _VAPictureParameterBufferVC1_mv_fields_bits, four_mv_block_pattern_table ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_mv_fields_bits-extended_mv_flag", offsetof( _VAPictureParameterBufferVC1_mv_fields_bits, extended_mv_flag ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_mv_fields_bits-extended_dmv_flag", offsetof( _VAPictureParameterBufferVC1_mv_fields_bits, extended_dmv_flag ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_mv_fields_bits-mv_mode", offsetof( _VAPictureParameterBufferVC1_mv_fields_bits, mv_mode ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_mv_fields_bits-mv_mode2", offsetof( _VAPictureParameterBufferVC1_mv_fields_bits, mv_mode2 ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_mv_fields_bits-extended_mv_range", offsetof( _VAPictureParameterBufferVC1_mv_fields_bits, extended_mv_range ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_mv_fields_bits-extended_dmv_range", offsetof( _VAPictureParameterBufferVC1_mv_fields_bits, extended_dmv_range ), sizeof( uint32_t ) );
// // 	printf( "drop %zu end-structure\n", sizeof( _VAPictureParameterBufferVC1_mv_fields_bits ) );

// 	swigComment("_VAPictureParameterBufferVC1_reference_fields\n");
// 	printf( "begin-structure _VAPictureParameterBufferVC1_reference_fields\n" );
// 	swigStructField( "_VAPictureParameterBufferVC1_reference_fields-value", offsetof( _VAPictureParameterBufferVC1_reference_fields, value ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_reference_fields-bits", offsetof( _VAPictureParameterBufferVC1_reference_fields, bits ), sizeof( _VAPictureParameterBufferVC1_reference_fields_bits ) );
// 	printf( "drop %zu end-structure\n", sizeof( _VAPictureParameterBufferVC1_reference_fields ) );

// // 	swigComment("_VAPictureParameterBufferVC1_reference_fields_bits\n");
// // 	printf( "begin-structure _VAPictureParameterBufferVC1_reference_fields_bits\n" );
// // 	swigStructField( "_VAPictureParameterBufferVC1_reference_fields_bits-reference_distance", offsetof( _VAPictureParameterBufferVC1_reference_fields_bits, reference_distance ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_reference_fields_bits-reference_field_pic_indicator", offsetof( _VAPictureParameterBufferVC1_reference_fields_bits, reference_field_pic_indicator ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_reference_fields_bits-reference_distance_flag", offsetof( _VAPictureParameterBufferVC1_reference_fields_bits, reference_distance_flag ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_reference_fields_bits-num_reference_pictures", offsetof( _VAPictureParameterBufferVC1_reference_fields_bits, num_reference_pictures ), sizeof( uint32_t ) );
// // 	printf( "drop %zu end-structure\n", sizeof( _VAPictureParameterBufferVC1_reference_fields_bits ) );

// 	swigComment("_VAPictureParameterBufferVC1_bitplane_present\n");
// 	printf( "begin-structure _VAPictureParameterBufferVC1_bitplane_present\n" );
// 	swigStructField( "_VAPictureParameterBufferVC1_bitplane_present-value", offsetof( _VAPictureParameterBufferVC1_bitplane_present, value ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_bitplane_present-flags", offsetof( _VAPictureParameterBufferVC1_bitplane_present, flags ), sizeof( _VAPictureParameterBufferVC1_bitplane_present_flags ) );
// 	printf( "drop %zu end-structure\n", sizeof( _VAPictureParameterBufferVC1_bitplane_present ) );

// // 	swigComment("_VAPictureParameterBufferVC1_bitplane_present_flags\n");
// // 	printf( "begin-structure _VAPictureParameterBufferVC1_bitplane_present_flags\n" );
// // 	swigStructField( "_VAPictureParameterBufferVC1_bitplane_present_flags-bp_field_tx", offsetof( _VAPictureParameterBufferVC1_bitplane_present_flags, bp_field_tx ), sizeof( uint32_t ) );
// // // 	swigStructField( "_VAPictureParameterBufferVC1_bitplane_present_flags-bp_mv_type_mb", offsetof( _VAPictureParameterBufferVC1_bitplane_present_flags, bp_mv_type_mb ), sizeof( uint32_t ) );
// // // 	swigStructField( "_VAPictureParameterBufferVC1_bitplane_present_flags-bp_direct_mb", offsetof( _VAPictureParameterBufferVC1_bitplane_present_flags, bp_direct_mb ), sizeof( uint32_t ) );
// // // 	swigStructField( "_VAPictureParameterBufferVC1_bitplane_present_flags-bp_forward_mb", offsetof( _VAPictureParameterBufferVC1_bitplane_present_flags, bp_forward_mb ), sizeof( uint32_t ) );
// // // 	swigStructField( "_VAPictureParameterBufferVC1_bitplane_present_flags-bp_skip_mb", offsetof( _VAPictureParameterBufferVC1_bitplane_present_flags, bp_skip_mb ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_bitplane_present_flags-bp_ac_pred", offsetof( _VAPictureParameterBufferVC1_bitplane_present_flags, bp_ac_pred ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_bitplane_present_flags-bp_overflags", offsetof( _VAPictureParameterBufferVC1_bitplane_present_flags, bp_overflags ), sizeof( uint32_t ) );
// // 	printf( "drop %zu end-structure\n", sizeof( _VAPictureParameterBufferVC1_bitplane_present_flags ) );

	swigComment("_VAPictureParameterBufferVC1_raw_coding\n");
	printf( "begin-structure _VAPictureParameterBufferVC1_raw_coding\n" );
	swigStructField( "_VAPictureParameterBufferVC1_raw_coding-value", offsetof( _VAPictureParameterBufferVC1_raw_coding, value ), sizeof( uint32_t ) );
// 	swigStructField( "_VAPictureParameterBufferVC1_raw_coding-flags", offsetof( _VAPictureParameterBufferVC1_raw_coding, flags ), sizeof( _VAPictureParameterBufferVC1_raw_coding_flags ) );
	printf( "drop %zu end-structure\n", sizeof( _VAPictureParameterBufferVC1_raw_coding ) );

// 	swigComment("_VAPictureParameterBufferVC1_raw_coding_flags\n");
// 	printf( "begin-structure _VAPictureParameterBufferVC1_raw_coding_flags\n" );
// 	swigStructField( "_VAPictureParameterBufferVC1_raw_coding_flags-field_tx", offsetof( _VAPictureParameterBufferVC1_raw_coding_flags, field_tx ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_raw_coding_flags-mv_type_mb", offsetof( _VAPictureParameterBufferVC1_raw_coding_flags, mv_type_mb ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_raw_coding_flags-direct_mb", offsetof( _VAPictureParameterBufferVC1_raw_coding_flags, direct_mb ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_raw_coding_flags-forward_mb", offsetof( _VAPictureParameterBufferVC1_raw_coding_flags, forward_mb ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_raw_coding_flags-skip_mb", offsetof( _VAPictureParameterBufferVC1_raw_coding_flags, skip_mb ), sizeof( uint32_t ) );
// 	swigStructField( "_VAPictureParameterBufferVC1_raw_coding_flags-ac_pred", offsetof( _VAPictureParameterBufferVC1_raw_coding_flags, ac_pred ), sizeof( uint32_t ) );
// 	swigStructField( "_VAPictureParameterBufferVC1_raw_coding_flags-overflags", offsetof( _VAPictureParameterBufferVC1_raw_coding_flags, overflags ), sizeof( uint32_t ) );
// 	printf( "drop %zu end-structure\n", sizeof( _VAPictureParameterBufferVC1_raw_coding_flags ) );

// 	swigComment("_VAPictureParameterBufferVC1_picture_fields\n");
// 	printf( "begin-structure _VAPictureParameterBufferVC1_picture_fields\n" );
// 	swigStructField( "_VAPictureParameterBufferVC1_picture_fields-value", offsetof( _VAPictureParameterBufferVC1_picture_fields, value ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_picture_fields-bits", offsetof( _VAPictureParameterBufferVC1_picture_fields, bits ), sizeof( _VAPictureParameterBufferVC1_picture_fields_bits ) );
// 	printf( "drop %zu end-structure\n", sizeof( _VAPictureParameterBufferVC1_picture_fields ) );

// // 	swigComment("_VAPictureParameterBufferVC1_picture_fields_bits\n");
// // 	printf( "begin-structure _VAPictureParameterBufferVC1_picture_fields_bits\n" );
// // 	swigStructField( "_VAPictureParameterBufferVC1_picture_fields_bits-top_field_first", offsetof( _VAPictureParameterBufferVC1_picture_fields_bits, top_field_first ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_picture_fields_bits-is_first_field", offsetof( _VAPictureParameterBufferVC1_picture_fields_bits, is_first_field ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_picture_fields_bits-frame_coding_mode", offsetof( _VAPictureParameterBufferVC1_picture_fields_bits, frame_coding_mode ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_picture_fields_bits-picture_type", offsetof( _VAPictureParameterBufferVC1_picture_fields_bits, picture_type ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_picture_fields_bits-intensity_compensation", offsetof( _VAPictureParameterBufferVC1_picture_fields_bits, intensity_compensation ), sizeof( uint32_t ) );
// // 	printf( "drop %zu end-structure\n", sizeof( _VAPictureParameterBufferVC1_picture_fields_bits ) );

// 	swigComment("_VAPictureParameterBufferVC1_range_mapping_fields\n");
// 	printf( "begin-structure _VAPictureParameterBufferVC1_range_mapping_fields\n" );
// 	swigStructField( "_VAPictureParameterBufferVC1_range_mapping_fields-value", offsetof( _VAPictureParameterBufferVC1_range_mapping_fields, value ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_range_mapping_fields-bits", offsetof( _VAPictureParameterBufferVC1_range_mapping_fields, bits ), sizeof( _VAPictureParameterBufferVC1_range_mapping_fields_bits ) );
// 	printf( "drop %zu end-structure\n", sizeof( _VAPictureParameterBufferVC1_range_mapping_fields ) );

// // 	swigComment("_VAPictureParameterBufferVC1_range_mapping_fields_bits\n");
// // 	printf( "begin-structure _VAPictureParameterBufferVC1_range_mapping_fields_bits\n" );
// // 	swigStructField( "_VAPictureParameterBufferVC1_range_mapping_fields_bits-luma", offsetof( _VAPictureParameterBufferVC1_range_mapping_fields_bits, luma ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_range_mapping_fields_bits-luma_flag", offsetof( _VAPictureParameterBufferVC1_range_mapping_fields_bits, luma_flag ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_range_mapping_fields_bits-chroma_flag", offsetof( _VAPictureParameterBufferVC1_range_mapping_fields_bits, chroma_flag ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_range_mapping_fields_bits-chroma", offsetof( _VAPictureParameterBufferVC1_range_mapping_fields_bits, chroma ), sizeof( uint32_t ) );
// // 	printf( "drop %zu end-structure\n", sizeof( _VAPictureParameterBufferVC1_range_mapping_fields_bits ) );

// 	swigComment("_VAPictureParameterBufferVC1_entrypoint_fields\n");
// 	printf( "begin-structure _VAPictureParameterBufferVC1_entrypoint_fields\n" );
// 	swigStructField( "_VAPictureParameterBufferVC1_entrypoint_fields-value", offsetof( _VAPictureParameterBufferVC1_entrypoint_fields, value ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_entrypoint_fields-bits", offsetof( _VAPictureParameterBufferVC1_entrypoint_fields, bits ), sizeof( _VAPictureParameterBufferVC1_entrypoint_fields_bits ) );
// 	printf( "drop %zu end-structure\n", sizeof( _VAPictureParameterBufferVC1_entrypoint_fields ) );

// // 	swigComment("_VAPictureParameterBufferVC1_entrypoint_fields_bits\n");
// // 	printf( "begin-structure _VAPictureParameterBufferVC1_entrypoint_fields_bits\n" );
// // 	swigStructField( "_VAPictureParameterBufferVC1_entrypoint_fields_bits-loopfilter", offsetof( _VAPictureParameterBufferVC1_entrypoint_fields_bits, loopfilter ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_entrypoint_fields_bits-broken_link", offsetof( _VAPictureParameterBufferVC1_entrypoint_fields_bits, broken_link ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_entrypoint_fields_bits-closed_entry", offsetof( _VAPictureParameterBufferVC1_entrypoint_fields_bits, closed_entry ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_entrypoint_fields_bits-panscan_flag", offsetof( _VAPictureParameterBufferVC1_entrypoint_fields_bits, panscan_flag ), sizeof( uint32_t ) );
// // 	printf( "drop %zu end-structure\n", sizeof( _VAPictureParameterBufferVC1_entrypoint_fields_bits ) );

// 	swigComment("_VAPictureParameterBufferVC1_sequence_fields\n");
// 	printf( "begin-structure _VAPictureParameterBufferVC1_sequence_fields\n" );
// 	swigStructField( "_VAPictureParameterBufferVC1_sequence_fields-value", offsetof( _VAPictureParameterBufferVC1_sequence_fields, value ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_sequence_fields-bits", offsetof( _VAPictureParameterBufferVC1_sequence_fields, bits ), sizeof( _VAPictureParameterBufferVC1_sequence_fields_bits ) );
// 	printf( "drop %zu end-structure\n", sizeof( _VAPictureParameterBufferVC1_sequence_fields ) );

// // 	swigComment("_VAPictureParameterBufferVC1_sequence_fields_bits\n");
// // 	printf( "begin-structure _VAPictureParameterBufferVC1_sequence_fields_bits\n" );
// // 	swigStructField( "_VAPictureParameterBufferVC1_sequence_fields_bits-syncmarker", offsetof( _VAPictureParameterBufferVC1_sequence_fields_bits, syncmarker ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_sequence_fields_bits-max_b_frames", offsetof( _VAPictureParameterBufferVC1_sequence_fields_bits, max_b_frames ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_sequence_fields_bits-psf", offsetof( _VAPictureParameterBufferVC1_sequence_fields_bits, psf ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_sequence_fields_bits-multires", offsetof( _VAPictureParameterBufferVC1_sequence_fields_bits, multires ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_sequence_fields_bits-profile", offsetof( _VAPictureParameterBufferVC1_sequence_fields_bits, profile ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_sequence_fields_bits-tfcntrflag", offsetof( _VAPictureParameterBufferVC1_sequence_fields_bits, tfcntrflag ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_sequence_fields_bits-overlap", offsetof( _VAPictureParameterBufferVC1_sequence_fields_bits, overlap ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_sequence_fields_bits-finterpflag", offsetof( _VAPictureParameterBufferVC1_sequence_fields_bits, finterpflag ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_sequence_fields_bits-pulldown", offsetof( _VAPictureParameterBufferVC1_sequence_fields_bits, pulldown ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_sequence_fields_bits-interlace", offsetof( _VAPictureParameterBufferVC1_sequence_fields_bits, interlace ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferVC1_sequence_fields_bits-rangered", offsetof( _VAPictureParameterBufferVC1_sequence_fields_bits, rangered ), sizeof( uint32_t ) );
// // 	printf( "drop %zu end-structure\n", sizeof( _VAPictureParameterBufferVC1_sequence_fields_bits ) );

	swigComment("struct _VASliceParameterBufferVC1\n");
	printf( "begin-structure VASliceParameterBufferVC1\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VASliceParameterBufferVC1 ) );

	swigComment("struct _VAPictureH264\n");
	printf( "begin-structure VAPictureH264\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAPictureH264 ) );

	swigComment("struct _VAPictureParameterBufferH264\n");
	printf( "begin-structure VAPictureParameterBufferH264\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAPictureParameterBufferH264 ) );

// 	swigComment("_VAPictureParameterBufferH264_pic_fields\n");
// 	printf( "begin-structure _VAPictureParameterBufferH264_pic_fields\n" );
// 	swigStructField( "_VAPictureParameterBufferH264_pic_fields-value", offsetof( _VAPictureParameterBufferH264_pic_fields, value ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferH264_pic_fields-bits", offsetof( _VAPictureParameterBufferH264_pic_fields, bits ), sizeof( _VAPictureParameterBufferH264_pic_fields_bits ) );
// 	printf( "drop %zu end-structure\n", sizeof( _VAPictureParameterBufferH264_pic_fields ) );

// // 	swigComment("_VAPictureParameterBufferH264_pic_fields_bits\n");
// // 	printf( "begin-structure _VAPictureParameterBufferH264_pic_fields_bits\n" );
// // 	swigStructField( "_VAPictureParameterBufferH264_pic_fields_bits-weighted_pred_flag", offsetof( _VAPictureParameterBufferH264_pic_fields_bits, weighted_pred_flag ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferH264_pic_fields_bits-constrained_intra_pred_flag", offsetof( _VAPictureParameterBufferH264_pic_fields_bits, constrained_intra_pred_flag ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferH264_pic_fields_bits-entropy_coding_mode_flag", offsetof( _VAPictureParameterBufferH264_pic_fields_bits, entropy_coding_mode_flag ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferH264_pic_fields_bits-transform_8x8_mode_flag", offsetof( _VAPictureParameterBufferH264_pic_fields_bits, transform_8x8_mode_flag ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferH264_pic_fields_bits-weighted_bipred_idc", offsetof( _VAPictureParameterBufferH264_pic_fields_bits, weighted_bipred_idc ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferH264_pic_fields_bits-field_pic_flag", offsetof( _VAPictureParameterBufferH264_pic_fields_bits, field_pic_flag ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferH264_pic_fields_bits-pic_order_present_flag", offsetof( _VAPictureParameterBufferH264_pic_fields_bits, pic_order_present_flag ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferH264_pic_fields_bits-deblocking_filter_control_present_flag", offsetof( _VAPictureParameterBufferH264_pic_fields_bits, deblocking_filter_control_present_flag ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferH264_pic_fields_bits-redundant_pic_cnt_present_flag", offsetof( _VAPictureParameterBufferH264_pic_fields_bits, redundant_pic_cnt_present_flag ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferH264_pic_fields_bits-reference_pic_flag", offsetof( _VAPictureParameterBufferH264_pic_fields_bits, reference_pic_flag ), sizeof( uint32_t ) );
// // 	printf( "drop %zu end-structure\n", sizeof( _VAPictureParameterBufferH264_pic_fields_bits ) );

// 	swigComment("_VAPictureParameterBufferH264_seq_fields\n");
// 	printf( "begin-structure _VAPictureParameterBufferH264_seq_fields\n" );
// 	swigStructField( "_VAPictureParameterBufferH264_seq_fields-value", offsetof( _VAPictureParameterBufferH264_seq_fields, value ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferH264_seq_fields-bits", offsetof( _VAPictureParameterBufferH264_seq_fields, bits ), sizeof( _VAPictureParameterBufferH264_seq_fields_bits ) );
// 	printf( "drop %zu end-structure\n", sizeof( _VAPictureParameterBufferH264_seq_fields ) );

// // 	swigComment("_VAPictureParameterBufferH264_seq_fields_bits\n");
// // 	printf( "begin-structure _VAPictureParameterBufferH264_seq_fields_bits\n" );
// // 	swigStructField( "_VAPictureParameterBufferH264_seq_fields_bits-gaps_in_frame_num_value_allowed_flag", offsetof( _VAPictureParameterBufferH264_seq_fields_bits, gaps_in_frame_num_value_allowed_flag ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferH264_seq_fields_bits-log2_max_frame_num_minus4", offsetof( _VAPictureParameterBufferH264_seq_fields_bits, log2_max_frame_num_minus4 ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferH264_seq_fields_bits-log2_max_pic_order_cnt_lsb_minus4", offsetof( _VAPictureParameterBufferH264_seq_fields_bits, log2_max_pic_order_cnt_lsb_minus4 ), sizeof( uint32_t ) );
// // // 	swigStructField( "_VAPictureParameterBufferH264_seq_fields_bits-frame_mbs_only_flag", offsetof( _VAPictureParameterBufferH264_seq_fields_bits, frame_mbs_only_flag ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferH264_seq_fields_bits-mb_adaptive_frame_field_flag", offsetof( _VAPictureParameterBufferH264_seq_fields_bits, mb_adaptive_frame_field_flag ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferH264_seq_fields_bits-direct_8x8_inference_flag", offsetof( _VAPictureParameterBufferH264_seq_fields_bits, direct_8x8_inference_flag ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferH264_seq_fields_bits-MinLumaBiPredSize8x8", offsetof( _VAPictureParameterBufferH264_seq_fields_bits, MinLumaBiPredSize8x8 ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferH264_seq_fields_bits-delta_pic_order_always_zero_flag", offsetof( _VAPictureParameterBufferH264_seq_fields_bits, delta_pic_order_always_zero_flag ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferH264_seq_fields_bits-chroma_format_idc", offsetof( _VAPictureParameterBufferH264_seq_fields_bits, chroma_format_idc ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferH264_seq_fields_bits-residual_colour_transform_flag", offsetof( _VAPictureParameterBufferH264_seq_fields_bits, residual_colour_transform_flag ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAPictureParameterBufferH264_seq_fields_bits-pic_order_cnt_type", offsetof( _VAPictureParameterBufferH264_seq_fields_bits, pic_order_cnt_type ), sizeof( uint32_t ) );
// // 	printf( "drop %zu end-structure\n", sizeof( _VAPictureParameterBufferH264_seq_fields_bits ) );

	swigComment("struct _VAIQMatrixBufferH264\n");
	printf( "begin-structure VAIQMatrixBufferH264\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAIQMatrixBufferH264 ) );

	swigComment("struct _VASliceParameterBufferH264\n");
	printf( "begin-structure VASliceParameterBufferH264\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VASliceParameterBufferH264 ) );

	swigComment("struct _VAEncSliceParameterBuffer\n");
	printf( "begin-structure VAEncSliceParameterBuffer\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAEncSliceParameterBuffer ) );

// 	swigComment("_VAEncSliceParameterBuffer_slice_flags\n");
// 	printf( "begin-structure _VAEncSliceParameterBuffer_slice_flags\n" );
// 	swigStructField( "_VAEncSliceParameterBuffer_slice_flags-value", offsetof( _VAEncSliceParameterBuffer_slice_flags, value ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAEncSliceParameterBuffer_slice_flags-bits", offsetof( _VAEncSliceParameterBuffer_slice_flags, bits ), sizeof( _VAEncSliceParameterBuffer_slice_flags_bits ) );
// 	printf( "drop %zu end-structure\n", sizeof( _VAEncSliceParameterBuffer_slice_flags ) );

// // 	swigComment("_VAEncSliceParameterBuffer_slice_flags_bits\n");
// // 	printf( "begin-structure _VAEncSliceParameterBuffer_slice_flags_bits\n" );
// // 	swigStructField( "_VAEncSliceParameterBuffer_slice_flags_bits-is_intra", offsetof( _VAEncSliceParameterBuffer_slice_flags_bits, is_intra ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAEncSliceParameterBuffer_slice_flags_bits-disable_deblocking_filter_idc", offsetof( _VAEncSliceParameterBuffer_slice_flags_bits, disable_deblocking_filter_idc ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAEncSliceParameterBuffer_slice_flags_bits-uses_long_term_ref", offsetof( _VAEncSliceParameterBuffer_slice_flags_bits, uses_long_term_ref ), sizeof( uint32_t ) );
// // 	swigStructField( "_VAEncSliceParameterBuffer_slice_flags_bits-is_long_term_ref", offsetof( _VAEncSliceParameterBuffer_slice_flags_bits, is_long_term_ref ), sizeof( uint32_t ) );
// // 	printf( "drop %zu end-structure\n", sizeof( _VAEncSliceParameterBuffer_slice_flags_bits ) );

	swigComment("struct _VAEncSequenceParameterBufferH263\n");
	printf( "begin-structure VAEncSequenceParameterBufferH263\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAEncSequenceParameterBufferH263 ) );

	swigComment("struct _VAEncPictureParameterBufferH263\n");
	printf( "begin-structure VAEncPictureParameterBufferH263\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAEncPictureParameterBufferH263 ) );

	swigComment("struct _VAEncSequenceParameterBufferMPEG4\n");
	printf( "begin-structure VAEncSequenceParameterBufferMPEG4\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAEncSequenceParameterBufferMPEG4 ) );

	swigComment("struct _VAEncPictureParameterBufferMPEG4\n");
	printf( "begin-structure VAEncPictureParameterBufferMPEG4\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAEncPictureParameterBufferMPEG4 ) );

	swigComment("struct _VACodedBufferSegment\n");
	printf( "begin-structure VACodedBufferSegment\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VACodedBufferSegment ) );

	swigComment("VABufferInfo\n");
	printf( "begin-structure VABufferInfo\n" );
	swigStructField( "VABufferInfo-va_reserved", offsetof( VABufferInfo, va_reserved ), sizeof( uint32_t [4] ) );
	swigStructField( "VABufferInfo-handle", offsetof( VABufferInfo, handle ), sizeof( uintptr_t ) );
	swigStructField( "VABufferInfo-type", offsetof( VABufferInfo, type ), sizeof( uint32_t ) );
	swigStructField( "VABufferInfo-mem_type", offsetof( VABufferInfo, mem_type ), sizeof( uint32_t ) );
	swigStructField( "VABufferInfo-mem_size", offsetof( VABufferInfo, mem_size ), sizeof( size_t ) );
	printf( "drop %zu end-structure\n", sizeof( VABufferInfo ) );

	swigComment("struct _VASurfaceDecodeMBErrors\n");
	printf( "begin-structure VASurfaceDecodeMBErrors\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VASurfaceDecodeMBErrors ) );

	swigComment("struct _VAImageFormat\n");
	printf( "begin-structure VAImageFormat\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAImageFormat ) );

	swigComment("struct _VAImage\n");
	printf( "begin-structure VAImage\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAImage ) );

	swigComment("union _VADisplayAttribValSubDevice\n");
	printf( "begin-structure VADisplayAttribValSubDevice\n" );
	printf( "drop %zu end-structure\n", sizeof( union _VADisplayAttribValSubDevice ) );

// 	swigComment("_VADisplayAttribValSubDevice_bits\n");
// 	printf( "begin-structure _VADisplayAttribValSubDevice_bits\n" );
// 	swigStructField( "_VADisplayAttribValSubDevice_bits-sub_device_count", offsetof( _VADisplayAttribValSubDevice_bits, sub_device_count ), sizeof( uint32_t ) );
// 	swigStructField( "_VADisplayAttribValSubDevice_bits-sub_device_mask", offsetof( _VADisplayAttribValSubDevice_bits, sub_device_mask ), sizeof( uint32_t ) );
// 	swigStructField( "_VADisplayAttribValSubDevice_bits-reserved", offsetof( _VADisplayAttribValSubDevice_bits, reserved ), sizeof( uint32_t ) );
// 	swigStructField( "_VADisplayAttribValSubDevice_bits-current_sub_device", offsetof( _VADisplayAttribValSubDevice_bits, current_sub_device ), sizeof( uint32_t ) );
// 	printf( "drop %zu end-structure\n", sizeof( _VADisplayAttribValSubDevice_bits ) );

	swigComment("struct _VADisplayAttribute\n");
	printf( "begin-structure VADisplayAttribute\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VADisplayAttribute ) );

	swigComment("struct _VAPictureHEVC\n");
	printf( "begin-structure VAPictureHEVC\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAPictureHEVC ) );

	swigComment("struct _VACopyObject\n");
	printf( "begin-structure VACopyObject\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VACopyObject ) );

	swigComment("_VACopyObject_object\n");
	printf( "begin-structure _VACopyObject_object\n" );
	swigStructField( "_VACopyObject_object-buffer_id", offsetof( _VACopyObject_object, buffer_id ), sizeof( VABufferID ) );
	swigStructField( "_VACopyObject_object-surface_id", offsetof( _VACopyObject_object, surface_id ), sizeof( VASurfaceID ) );
	printf( "drop %zu end-structure\n", sizeof( _VACopyObject_object ) );

	swigComment("union _VACopyOption\n");
	printf( "begin-structure VACopyOption\n" );
	printf( "drop %zu end-structure\n", sizeof( union _VACopyOption ) );

// 	swigComment("_VACopyOption_bits\n");
// 	printf( "begin-structure _VACopyOption_bits\n" );
// 	swigStructField( "_VACopyOption_bits-reserved", offsetof( _VACopyOption_bits, reserved ), sizeof( uint32_t ) );
// 	swigStructField( "_VACopyOption_bits-va_copy_mode", offsetof( _VACopyOption_bits, va_copy_mode ), sizeof( uint32_t ) );
// 	swigStructField( "_VACopyOption_bits-va_copy_sync", offsetof( _VACopyOption_bits, va_copy_sync ), sizeof( uint32_t ) );
// 	printf( "drop %zu end-structure\n", sizeof( _VACopyOption_bits ) );

	swigComment("struct _VABlendState\n");
	printf( "begin-structure VABlendState\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VABlendState ) );

	swigComment("struct _VAProcPipelineCaps\n");
	printf( "begin-structure VAProcPipelineCaps\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAProcPipelineCaps ) );

	swigComment("struct _VAProcFilterValueRange\n");
	printf( "begin-structure VAProcFilterValueRange\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAProcFilterValueRange ) );

	swigComment("struct _VAProcColorProperties\n");
	printf( "begin-structure VAProcColorProperties\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAProcColorProperties ) );

	swigComment("struct _VAHdrMetaDataHDR10\n");
	printf( "begin-structure VAHdrMetaDataHDR10\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAHdrMetaDataHDR10 ) );

	swigComment("struct _VAProcFilterCapHighDynamicRange\n");
	printf( "begin-structure VAProcFilterCapHighDynamicRange\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAProcFilterCapHighDynamicRange ) );

	swigComment("struct _VAHdrMetaData\n");
	printf( "begin-structure VAHdrMetaData\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAHdrMetaData ) );

	swigComment("struct _VAProcPipelineParameterBuffer\n");
	printf( "begin-structure VAProcPipelineParameterBuffer\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAProcPipelineParameterBuffer ) );

	swigComment("struct _VAProcFilterParameterBufferBase\n");
	printf( "begin-structure VAProcFilterParameterBufferBase\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAProcFilterParameterBufferBase ) );

	swigComment("struct _VAProcFilterParameterBuffer\n");
	printf( "begin-structure VAProcFilterParameterBuffer\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAProcFilterParameterBuffer ) );

	swigComment("struct _VAProcFilterParameterBufferDeinterlacing\n");
	printf( "begin-structure VAProcFilterParameterBufferDeinterlacing\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAProcFilterParameterBufferDeinterlacing ) );

	swigComment("struct _VAProcFilterParameterBufferColorBalance\n");
	printf( "begin-structure VAProcFilterParameterBufferColorBalance\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAProcFilterParameterBufferColorBalance ) );

	swigComment("struct _VAProcFilterParameterBufferTotalColorCorrection\n");
	printf( "begin-structure VAProcFilterParameterBufferTotalColorCorrection\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAProcFilterParameterBufferTotalColorCorrection ) );

	swigComment("struct _VAProcFilterParameterBufferHVSNoiseReduction\n");
	printf( "begin-structure VAProcFilterParameterBufferHVSNoiseReduction\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAProcFilterParameterBufferHVSNoiseReduction ) );

	swigComment("struct _VAProcFilterParameterBufferHDRToneMapping\n");
	printf( "begin-structure VAProcFilterParameterBufferHDRToneMapping\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAProcFilterParameterBufferHDRToneMapping ) );

	swigComment("struct _VAProcFilterParameterBuffer3DLUT\n");
	printf( "begin-structure VAProcFilterParameterBuffer3DLUT\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAProcFilterParameterBuffer3DLUT ) );

	swigComment("struct _VAProcFilterCap3DLUT\n");
	printf( "begin-structure VAProcFilterCap3DLUT\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAProcFilterCap3DLUT ) );

	swigComment("struct _VAProcFilterCap\n");
	printf( "begin-structure VAProcFilterCap\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAProcFilterCap ) );

	swigComment("struct _VAProcFilterCapDeinterlacing\n");
	printf( "begin-structure VAProcFilterCapDeinterlacing\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAProcFilterCapDeinterlacing ) );

	swigComment("struct _VAProcFilterCapColorBalance\n");
	printf( "begin-structure VAProcFilterCapColorBalance\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAProcFilterCapColorBalance ) );

	swigComment("struct _VAProcFilterCapTotalColorCorrection\n");
	printf( "begin-structure VAProcFilterCapTotalColorCorrection\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _VAProcFilterCapTotalColorCorrection ) );

// 	swigComment("struct VADriverVTable\n");
// 	printf( "begin-structure VADriverVTable\n" );
// 	swigStructField( "VADriverVTable-vaQuerySurfaceStatus", offsetof( struct VADriverVTable, vaQuerySurfaceStatus ), sizeof( VAStatus (*)(VADriverContextP,VASurfaceID,VASurfaceStatus *) ) );
// 	swigStructField( "VADriverVTable-vaQueryProcessingRate", offsetof( struct VADriverVTable, vaQueryProcessingRate ), sizeof( VAStatus (*)(VADriverContextP,VAConfigID,VAProcessingRateParameter *,unsigned int *) ) );
// 	swigStructField( "VADriverVTable-reserved", offsetof( struct VADriverVTable, reserved ), sizeof( unsigned long [54] ) );
// 	swigStructField( "VADriverVTable-vaPutImage", offsetof( struct VADriverVTable, vaPutImage ), sizeof( VAStatus (*)(VADriverContextP,VASurfaceID,VAImageID,int,int,unsigned int,unsigned int,int,int,unsigned int,unsigned int) ) );
// 	swigStructField( "VADriverVTable-vaGetImage", offsetof( struct VADriverVTable, vaGetImage ), sizeof( VAStatus (*)(VADriverContextP,VASurfaceID,int,int,unsigned int,unsigned int,VAImageID) ) );
// 	swigStructField( "VADriverVTable-vaQueryConfigProfiles", offsetof( struct VADriverVTable, vaQueryConfigProfiles ), sizeof( VAStatus (*)(VADriverContextP,VAProfile *,int *) ) );
// 	swigStructField( "VADriverVTable-vaGetConfigAttributes", offsetof( struct VADriverVTable, vaGetConfigAttributes ), sizeof( VAStatus (*)(VADriverContextP,VAProfile,VAEntrypoint,VAConfigAttrib *,int) ) );
// 	swigStructField( "VADriverVTable-vaQueryConfigAttributes", offsetof( struct VADriverVTable, vaQueryConfigAttributes ), sizeof( VAStatus (*)(VADriverContextP,VAConfigID,VAProfile *,VAEntrypoint *,VAConfigAttrib *,int *) ) );
// 	swigStructField( "VADriverVTable-vaQueryDisplayAttributes", offsetof( struct VADriverVTable, vaQueryDisplayAttributes ), sizeof( VAStatus (*)(VADriverContextP,VADisplayAttribute *,int *) ) );
// 	swigStructField( "VADriverVTable-vaGetDisplayAttributes", offsetof( struct VADriverVTable, vaGetDisplayAttributes ), sizeof( VAStatus (*)(VADriverContextP,VADisplayAttribute *,int) ) );
// 	swigStructField( "VADriverVTable-vaSetDisplayAttributes", offsetof( struct VADriverVTable, vaSetDisplayAttributes ), sizeof( VAStatus (*)(VADriverContextP,VADisplayAttribute *,int) ) );
// 	swigStructField( "VADriverVTable-vaGetSurfaceAttributes", offsetof( struct VADriverVTable, vaGetSurfaceAttributes ), sizeof( VAStatus (*)(VADriverContextP,VAConfigID,VASurfaceAttrib *,unsigned int) ) );
// 	swigStructField( "VADriverVTable-vaQuerySurfaceAttributes", offsetof( struct VADriverVTable, vaQuerySurfaceAttributes ), sizeof( VAStatus (*)(VADriverContextP,VAConfigID,VASurfaceAttrib *,unsigned int *) ) );
// 	swigStructField( "VADriverVTable-vaMFSubmit", offsetof( struct VADriverVTable, vaMFSubmit ), sizeof( VAStatus (*)(VADriverContextP,VAMFContextID,VAContextID *,int) ) );
// 	swigStructField( "VADriverVTable-vaUnmapBuffer", offsetof( struct VADriverVTable, vaUnmapBuffer ), sizeof( VAStatus (*)(VADriverContextP,VABufferID) ) );
// 	swigStructField( "VADriverVTable-vaMapBuffer", offsetof( struct VADriverVTable, vaMapBuffer ), sizeof( VAStatus (*)(VADriverContextP,VABufferID,void **) ) );
// 	swigStructField( "VADriverVTable-vaSetSubpictureImage", offsetof( struct VADriverVTable, vaSetSubpictureImage ), sizeof( VAStatus (*)(VADriverContextP,VASubpictureID,VAImageID) ) );
// 	swigStructField( "VADriverVTable-vaDeriveImage", offsetof( struct VADriverVTable, vaDeriveImage ), sizeof( VAStatus (*)(VADriverContextP,VASurfaceID,VAImage *) ) );
// 	swigStructField( "VADriverVTable-vaCreateImage", offsetof( struct VADriverVTable, vaCreateImage ), sizeof( VAStatus (*)(VADriverContextP,VAImageFormat *,int,int,VAImage *) ) );
// 	swigStructField( "VADriverVTable-vaQuerySurfaceError", offsetof( struct VADriverVTable, vaQuerySurfaceError ), sizeof( VAStatus (*)(VADriverContextP,VASurfaceID,VAStatus,void **) ) );
// 	swigStructField( "VADriverVTable-vaCreateBuffer2", offsetof( struct VADriverVTable, vaCreateBuffer2 ), sizeof( VAStatus (*)(VADriverContextP,VAContextID,VABufferType,unsigned int,unsigned int,unsigned int *,unsigned int *,VABufferID *) ) );
// 	swigStructField( "VADriverVTable-vaExportSurfaceHandle", offsetof( struct VADriverVTable, vaExportSurfaceHandle ), sizeof( VAStatus (*)(VADriverContextP,VASurfaceID,uint32_t,uint32_t,void *) ) );
// 	swigStructField( "VADriverVTable-vaPutSurface", offsetof( struct VADriverVTable, vaPutSurface ), sizeof( VAStatus (*)(VADriverContextP,VASurfaceID,void *,short,short,unsigned short,unsigned short,short,short,unsigned short,unsigned short,VARectangle *,unsigned int,unsigned int) ) );
// 	swigStructField( "VADriverVTable-vaSyncSurface", offsetof( struct VADriverVTable, vaSyncSurface ), sizeof( VAStatus (*)(VADriverContextP,VASurfaceID) ) );
// 	swigStructField( "VADriverVTable-vaLockSurface", offsetof( struct VADriverVTable, vaLockSurface ), sizeof( VAStatus (*)(VADriverContextP,VASurfaceID,unsigned int *,unsigned int *,unsigned int *,unsigned int *,unsigned int *,unsigned int *,unsigned int *,unsigned int *,void **) ) );
// 	swigStructField( "VADriverVTable-vaUnlockSurface", offsetof( struct VADriverVTable, vaUnlockSurface ), sizeof( VAStatus (*)(VADriverContextP,VASurfaceID) ) );
// 	swigStructField( "VADriverVTable-vaCreateSurfaces", offsetof( struct VADriverVTable, vaCreateSurfaces ), sizeof( VAStatus (*)(VADriverContextP,int,int,int,int,VASurfaceID *) ) );
// 	swigStructField( "VADriverVTable-vaDestroySurfaces", offsetof( struct VADriverVTable, vaDestroySurfaces ), sizeof( VAStatus (*)(VADriverContextP,VASurfaceID *,int) ) );
// 	swigStructField( "VADriverVTable-vaSetImagePalette", offsetof( struct VADriverVTable, vaSetImagePalette ), sizeof( VAStatus (*)(VADriverContextP,VAImageID,unsigned char *) ) );
// 	swigStructField( "VADriverVTable-vaDestroyBuffer", offsetof( struct VADriverVTable, vaDestroyBuffer ), sizeof( VAStatus (*)(VADriverContextP,VABufferID) ) );
// 	swigStructField( "VADriverVTable-vaCreateBuffer", offsetof( struct VADriverVTable, vaCreateBuffer ), sizeof( VAStatus (*)(VADriverContextP,VAContextID,VABufferType,unsigned int,unsigned int,void *,VABufferID *) ) );
// 	swigStructField( "VADriverVTable-vaCreateContext", offsetof( struct VADriverVTable, vaCreateContext ), sizeof( VAStatus (*)(VADriverContextP,VAConfigID,int,int,int,VASurfaceID *,int,VAContextID *) ) );
// 	swigStructField( "VADriverVTable-vaDestroyContext", offsetof( struct VADriverVTable, vaDestroyContext ), sizeof( VAStatus (*)(VADriverContextP,VAContextID) ) );
// 	swigStructField( "VADriverVTable-vaCreateMFContext", offsetof( struct VADriverVTable, vaCreateMFContext ), sizeof( VAStatus (*)(VADriverContextP,VAMFContextID *) ) );
// 	swigStructField( "VADriverVTable-vaMFAddContext", offsetof( struct VADriverVTable, vaMFAddContext ), sizeof( VAStatus (*)(VADriverContextP,VAMFContextID,VAContextID) ) );
// 	swigStructField( "VADriverVTable-vaMFReleaseContext", offsetof( struct VADriverVTable, vaMFReleaseContext ), sizeof( VAStatus (*)(VADriverContextP,VAMFContextID,VAContextID) ) );
// 	swigStructField( "VADriverVTable-vaSyncBuffer", offsetof( struct VADriverVTable, vaSyncBuffer ), sizeof( VAStatus (*)(VADriverContextP,VABufferID,uint64_t) ) );
// 	swigStructField( "VADriverVTable-vaCopy", offsetof( struct VADriverVTable, vaCopy ), sizeof( VAStatus (*)(VADriverContextP,VACopyObject *,VACopyObject *,VACopyOption) ) );
// 	swigStructField( "VADriverVTable-vaBufferInfo", offsetof( struct VADriverVTable, vaBufferInfo ), sizeof( VAStatus (*)(VADriverContextP,VABufferID,VABufferType *,unsigned int *,unsigned int *) ) );
// 	swigStructField( "VADriverVTable-vaSyncSurface2", offsetof( struct VADriverVTable, vaSyncSurface2 ), sizeof( VAStatus (*)(VADriverContextP,VASurfaceID,uint64_t) ) );
// 	swigStructField( "VADriverVTable-vaCreateSurfaces2", offsetof( struct VADriverVTable, vaCreateSurfaces2 ), sizeof( VAStatus (*)(VADriverContextP,unsigned int,unsigned int,unsigned int,VASurfaceID *,unsigned int,VASurfaceAttrib *,unsigned int) ) );
// 	swigStructField( "VADriverVTable-vaQueryConfigEntrypoints", offsetof( struct VADriverVTable, vaQueryConfigEntrypoints ), sizeof( VAStatus (*)(VADriverContextP,VAProfile,VAEntrypoint *,int *) ) );
// 	swigStructField( "VADriverVTable-vaDestroyImage", offsetof( struct VADriverVTable, vaDestroyImage ), sizeof( VAStatus (*)(VADriverContextP,VAImageID) ) );
// 	swigStructField( "VADriverVTable-vaBufferSetNumElements", offsetof( struct VADriverVTable, vaBufferSetNumElements ), sizeof( VAStatus (*)(VADriverContextP,VABufferID,unsigned int) ) );
// 	swigStructField( "VADriverVTable-vaCreateConfig", offsetof( struct VADriverVTable, vaCreateConfig ), sizeof( VAStatus (*)(VADriverContextP,VAProfile,VAEntrypoint,VAConfigAttrib *,int,VAConfigID *) ) );
// 	swigStructField( "VADriverVTable-vaDestroyConfig", offsetof( struct VADriverVTable, vaDestroyConfig ), sizeof( VAStatus (*)(VADriverContextP,VAConfigID) ) );
// 	swigStructField( "VADriverVTable-vaQuerySubpictureFormats", offsetof( struct VADriverVTable, vaQuerySubpictureFormats ), sizeof( VAStatus (*)(VADriverContextP,VAImageFormat *,unsigned int *,unsigned int *) ) );
// 	swigStructField( "VADriverVTable-vaQueryImageFormats", offsetof( struct VADriverVTable, vaQueryImageFormats ), sizeof( VAStatus (*)(VADriverContextP,VAImageFormat *,int *) ) );
// 	swigStructField( "VADriverVTable-vaSetSubpictureChromakey", offsetof( struct VADriverVTable, vaSetSubpictureChromakey ), sizeof( VAStatus (*)(VADriverContextP,VASubpictureID,unsigned int,unsigned int,unsigned int) ) );
// 	swigStructField( "VADriverVTable-vaSetSubpictureGlobalAlpha", offsetof( struct VADriverVTable, vaSetSubpictureGlobalAlpha ), sizeof( VAStatus (*)(VADriverContextP,VASubpictureID,float) ) );
// 	swigStructField( "VADriverVTable-vaAcquireBufferHandle", offsetof( struct VADriverVTable, vaAcquireBufferHandle ), sizeof( VAStatus (*)(VADriverContextP,VABufferID,VABufferInfo *) ) );
// 	swigStructField( "VADriverVTable-vaReleaseBufferHandle", offsetof( struct VADriverVTable, vaReleaseBufferHandle ), sizeof( VAStatus (*)(VADriverContextP,VABufferID) ) );
// 	swigStructField( "VADriverVTable-vaDestroySubpicture", offsetof( struct VADriverVTable, vaDestroySubpicture ), sizeof( VAStatus (*)(VADriverContextP,VASubpictureID) ) );
// 	swigStructField( "VADriverVTable-vaCreateSubpicture", offsetof( struct VADriverVTable, vaCreateSubpicture ), sizeof( VAStatus (*)(VADriverContextP,VAImageID,VASubpictureID *) ) );
// 	swigStructField( "VADriverVTable-vaEndPicture", offsetof( struct VADriverVTable, vaEndPicture ), sizeof( VAStatus (*)(VADriverContextP,VAContextID) ) );
// 	swigStructField( "VADriverVTable-vaRenderPicture", offsetof( struct VADriverVTable, vaRenderPicture ), sizeof( VAStatus (*)(VADriverContextP,VAContextID,VABufferID *,int) ) );
// 	swigStructField( "VADriverVTable-vaBeginPicture", offsetof( struct VADriverVTable, vaBeginPicture ), sizeof( VAStatus (*)(VADriverContextP,VAContextID,VASurfaceID) ) );
// 	swigStructField( "VADriverVTable-vaTerminate", offsetof( struct VADriverVTable, vaTerminate ), sizeof( VAStatus (*)(VADriverContextP) ) );
// 	swigStructField( "VADriverVTable-vaAssociateSubpicture", offsetof( struct VADriverVTable, vaAssociateSubpicture ), sizeof( VAStatus (*)(VADriverContextP,VASubpictureID,VASurfaceID *,int,short,short,unsigned short,unsigned short,short,short,unsigned short,unsigned short,unsigned int) ) );
// 	swigStructField( "VADriverVTable-vaDeassociateSubpicture", offsetof( struct VADriverVTable, vaDeassociateSubpicture ), sizeof( VAStatus (*)(VADriverContextP,VASubpictureID,VASurfaceID *,int) ) );
// 	printf( "drop %zu end-structure\n", sizeof( struct VADriverVTable ) );

	swigComment("struct VADriverContext\n");
	printf( "begin-structure VADriverContext\n" );
	swigStructField( "VADriverContext-handle", offsetof( struct VADriverContext, handle ), sizeof( void * ) );
	swigStructField( "VADriverContext-display_type", offsetof( struct VADriverContext, display_type ), sizeof( unsigned long ) );
	swigStructField( "VADriverContext-str_vendor", offsetof( struct VADriverContext, str_vendor ), sizeof( char const * ) );
	swigStructField( "VADriverContext-x11_screen", offsetof( struct VADriverContext, x11_screen ), sizeof( int ) );
// 	swigStructField( "VADriverContext-vtable_glx", offsetof( struct VADriverContext, vtable_glx ), sizeof( struct VADriverVTableGLX * ) );
	swigStructField( "VADriverContext-max_attributes", offsetof( struct VADriverContext, max_attributes ), sizeof( int ) );
// 	swigStructField( "VADriverContext-vtable", offsetof( struct VADriverContext, vtable ), sizeof( struct VADriverVTable * ) );
	swigStructField( "VADriverContext-version_major", offsetof( struct VADriverContext, version_major ), sizeof( int ) );
	swigStructField( "VADriverContext-max_display_attributes", offsetof( struct VADriverContext, max_display_attributes ), sizeof( int ) );
	swigStructField( "VADriverContext-pDisplayContext", offsetof( struct VADriverContext, pDisplayContext ), sizeof( void * ) );
	swigStructField( "VADriverContext-version_minor", offsetof( struct VADriverContext, version_minor ), sizeof( int ) );
	swigStructField( "VADriverContext-max_profiles", offsetof( struct VADriverContext, max_profiles ), sizeof( int ) );
	swigStructField( "VADriverContext-native_dpy", offsetof( struct VADriverContext, native_dpy ), sizeof( void * ) );
	swigStructField( "VADriverContext-error_callback", offsetof( struct VADriverContext, error_callback ), sizeof( void (*)(VADriverContextP,char const *) ) );
	swigStructField( "VADriverContext-info_callback", offsetof( struct VADriverContext, info_callback ), sizeof( void (*)(VADriverContextP,char const *) ) );
	swigStructField( "VADriverContext-reserved", offsetof( struct VADriverContext, reserved ), sizeof( unsigned long [37] ) );
	swigStructField( "VADriverContext-max_subpic_formats", offsetof( struct VADriverContext, max_subpic_formats ), sizeof( int ) );
	swigStructField( "VADriverContext-max_image_formats", offsetof( struct VADriverContext, max_image_formats ), sizeof( int ) );
	swigStructField( "VADriverContext-pDriverData", offsetof( struct VADriverContext, pDriverData ), sizeof( void * ) );
// 	swigStructField( "VADriverContext-vtable_egl", offsetof( struct VADriverContext, vtable_egl ), sizeof( struct VADriverVTableEGL * ) );
	swigStructField( "VADriverContext-glx", offsetof( struct VADriverContext, glx ), sizeof( void * ) );
	swigStructField( "VADriverContext-drm_state", offsetof( struct VADriverContext, drm_state ), sizeof( void * ) );
// 	swigStructField( "VADriverContext-vtable_prot", offsetof( struct VADriverContext, vtable_prot ), sizeof( struct VADriverVTableProt * ) );
// 	swigStructField( "VADriverContext-vtable_vpp", offsetof( struct VADriverContext, vtable_vpp ), sizeof( struct VADriverVTableVPP * ) );
	swigStructField( "VADriverContext-override_driver_name", offsetof( struct VADriverContext, override_driver_name ), sizeof( char * ) );
	swigStructField( "VADriverContext-vtable_tpi", offsetof( struct VADriverContext, vtable_tpi ), sizeof( void * ) );
	swigStructField( "VADriverContext-max_entrypoints", offsetof( struct VADriverContext, max_entrypoints ), sizeof( int ) );
// 	swigStructField( "VADriverContext-vtable_wayland", offsetof( struct VADriverContext, vtable_wayland ), sizeof( struct VADriverVTableWayland * ) );
	printf( "drop %zu end-structure\n", sizeof( struct VADriverContext ) );

	swigComment("struct VADisplayContext\n");
	printf( "begin-structure VADisplayContext\n" );
	swigStructField( "VADisplayContext-opaque", offsetof( struct VADisplayContext, opaque ), sizeof( void * ) );
	swigStructField( "VADisplayContext-vafool", offsetof( struct VADisplayContext, vafool ), sizeof( void * ) );
	swigStructField( "VADisplayContext-info_callback_user_context", offsetof( struct VADisplayContext, info_callback_user_context ), sizeof( void * ) );
	swigStructField( "VADisplayContext-error_callback_user_context", offsetof( struct VADisplayContext, error_callback_user_context ), sizeof( void * ) );
	swigStructField( "VADisplayContext-pDriverContext", offsetof( struct VADisplayContext, pDriverContext ), sizeof( VADriverContextP ) );
	swigStructField( "VADisplayContext-pNext", offsetof( struct VADisplayContext, pNext ), sizeof( VADisplayContextP ) );
	swigStructField( "VADisplayContext-vaGetDriverNameByIndex", offsetof( struct VADisplayContext, vaGetDriverNameByIndex ), sizeof( VAStatus (*)(VADisplayContextP,char **,int) ) );
	swigStructField( "VADisplayContext-info_callback", offsetof( struct VADisplayContext, info_callback ), sizeof( VAMessageCallback ) );
	swigStructField( "VADisplayContext-error_callback", offsetof( struct VADisplayContext, error_callback ), sizeof( VAMessageCallback ) );
	swigStructField( "VADisplayContext-reserved", offsetof( struct VADisplayContext, reserved ), sizeof( unsigned long [30] ) );
	swigStructField( "VADisplayContext-vaIsValid", offsetof( struct VADisplayContext, vaIsValid ), sizeof( int (*)(VADisplayContextP) ) );
	swigStructField( "VADisplayContext-vaGetNumCandidates", offsetof( struct VADisplayContext, vaGetNumCandidates ), sizeof( VAStatus (*)(VADisplayContextP,int *) ) );
	swigStructField( "VADisplayContext-vatrace", offsetof( struct VADisplayContext, vatrace ), sizeof( void * ) );
	swigStructField( "VADisplayContext-vadpy_magic", offsetof( struct VADisplayContext, vadpy_magic ), sizeof( int ) );
	swigStructField( "VADisplayContext-vaGetDriverName", offsetof( struct VADisplayContext, vaGetDriverName ), sizeof( VAStatus (*)(VADisplayContextP,char **) ) );
	swigStructField( "VADisplayContext-vaDestroy", offsetof( struct VADisplayContext, vaDestroy ), sizeof( void (*)(VADisplayContextP) ) );
	printf( "drop %zu end-structure\n", sizeof( struct VADisplayContext ) );

// 	swigComment("struct VADriverVTableWayland\n");
// 	printf( "begin-structure VADriverVTableWayland\n" );
// 	swigStructField( "VADriverVTableWayland-wl_interface", offsetof( struct VADriverVTableWayland, wl_interface ), sizeof( void const * ) );
// 	swigStructField( "VADriverVTableWayland-vaGetSurfaceBufferWl", offsetof( struct VADriverVTableWayland, vaGetSurfaceBufferWl ), sizeof( VAStatus (*)(struct VADriverContext *,VASurfaceID,unsigned int,struct wl_buffer **) ) );
// 	swigStructField( "VADriverVTableWayland-vaGetImageBufferWl", offsetof( struct VADriverVTableWayland, vaGetImageBufferWl ), sizeof( VAStatus (*)(struct VADriverContext *,VAImageID,unsigned int,struct wl_buffer **) ) );
// 	swigStructField( "VADriverVTableWayland-reserved", offsetof( struct VADriverVTableWayland, reserved ), sizeof( unsigned long [7] ) );
// 	swigStructField( "VADriverVTableWayland-version", offsetof( struct VADriverVTableWayland, version ), sizeof( unsigned int ) );
// 	swigStructField( "VADriverVTableWayland-has_prime_sharing", offsetof( struct VADriverVTableWayland, has_prime_sharing ), sizeof( unsigned int ) );
// 	printf( "drop %zu end-structure\n", sizeof( struct VADriverVTableWayland ) );

// 	swigComment("struct VADriverVTableGLX\n");
// 	printf( "begin-structure VADriverVTableGLX\n" );
// 	swigStructField( "VADriverVTableGLX-vaCreateSurfaceGLX", offsetof( struct VADriverVTableGLX, vaCreateSurfaceGLX ), sizeof( VAStatus (*)(struct VADriverContext *,unsigned int,unsigned int,void **) ) );
// 	swigStructField( "VADriverVTableGLX-vaDestroySurfaceGLX", offsetof( struct VADriverVTableGLX, vaDestroySurfaceGLX ), sizeof( VAStatus (*)(struct VADriverContext *,void *) ) );
// 	swigStructField( "VADriverVTableGLX-vaCopySurfaceGLX", offsetof( struct VADriverVTableGLX, vaCopySurfaceGLX ), sizeof( VAStatus (*)(struct VADriverContext *,void *,VASurfaceID,unsigned int) ) );
// 	printf( "drop %zu end-structure\n", sizeof( struct VADriverVTableGLX ) );

// 	swigComment("struct VADriverVTableVPP\n");
// 	printf( "begin-structure VADriverVTableVPP\n" );
// 	swigStructField( "VADriverVTableVPP-reserved", offsetof( struct VADriverVTableVPP, reserved ), sizeof( unsigned long [16] ) );
// 	swigStructField( "VADriverVTableVPP-version", offsetof( struct VADriverVTableVPP, version ), sizeof( unsigned int ) );
// 	swigStructField( "VADriverVTableVPP-vaQueryVideoProcFilters", offsetof( struct VADriverVTableVPP, vaQueryVideoProcFilters ), sizeof( VAStatus (*)(VADriverContextP,VAContextID,VAProcFilterType *,unsigned int *) ) );
// 	swigStructField( "VADriverVTableVPP-vaQueryVideoProcFilterCaps", offsetof( struct VADriverVTableVPP, vaQueryVideoProcFilterCaps ), sizeof( VAStatus (*)(VADriverContextP,VAContextID,VAProcFilterType,void *,unsigned int *) ) );
// 	swigStructField( "VADriverVTableVPP-vaQueryVideoProcPipelineCaps", offsetof( struct VADriverVTableVPP, vaQueryVideoProcPipelineCaps ), sizeof( VAStatus (*)(VADriverContextP,VAContextID,VABufferID *,unsigned int,VAProcPipelineCaps *) ) );
// 	printf( "drop %zu end-structure\n", sizeof( struct VADriverVTableVPP ) );

	swigNewline();

	swigComment("--===< function pointers >===---\n");
// 	swigFunctionPointer( "c-funptr VADriverVTable-vaTerminate() {((struct VADriverVTable*)ptr)->vaTerminate} a -- n", "", "", "	( ctx -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTable-vaQueryConfigProfiles() {((struct VADriverVTable*)ptr)->vaQueryConfigProfiles} a a a -- n", "", "", "	( ctx profile_list num_profiles -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTable-vaQueryConfigEntrypoints() {((struct VADriverVTable*)ptr)->vaQueryConfigEntrypoints} a n a a -- n", "", "", "	( ctx profile entrypoint_list num_entrypoints -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTable-vaGetConfigAttributes() {((struct VADriverVTable*)ptr)->vaGetConfigAttributes} a n n a n -- n", "", "", "	( ctx profile entrypoint attrib_list num_attribs -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTable-vaCreateConfig() {((struct VADriverVTable*)ptr)->vaCreateConfig} a n n a n a -- n", "", "", "	( ctx profile entrypoint attrib_list num_attribs config_id -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTable-vaDestroyConfig() {((struct VADriverVTable*)ptr)->vaDestroyConfig} a u -- n", "", "", "	( ctx config_id -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTable-vaQueryConfigAttributes() {((struct VADriverVTable*)ptr)->vaQueryConfigAttributes} a u a a a a -- n", "", "", "	( ctx config_id profile entrypoint attrib_list num_attribs -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTable-vaCreateSurfaces() {((struct VADriverVTable*)ptr)->vaCreateSurfaces} a n n n n a -- n", "", "", "	( ctx width height format num_surfaces surfaces -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTable-vaDestroySurfaces() {((struct VADriverVTable*)ptr)->vaDestroySurfaces} a a n -- n", "", "", "	( ctx surface_list num_surfaces -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTable-vaCreateContext() {((struct VADriverVTable*)ptr)->vaCreateContext} a u n n n a n a -- n", "", "", "	( ctx config_id picture_width picture_height flag render_targets num_render_targets context -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTable-vaDestroyContext() {((struct VADriverVTable*)ptr)->vaDestroyContext} a u -- n", "", "", "	( ctx context -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTable-vaCreateBuffer() {((struct VADriverVTable*)ptr)->vaCreateBuffer} a u n u u a a -- n", "", "", "	( ctx context type size num_elements data buf_id -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTable-vaBufferSetNumElements() {((struct VADriverVTable*)ptr)->vaBufferSetNumElements} a u u -- n", "", "", "	( ctx buf_id num_elements -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTable-vaMapBuffer() {((struct VADriverVTable*)ptr)->vaMapBuffer} a u a -- n", "", "", "	( ctx buf_id pbuf -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTable-vaUnmapBuffer() {((struct VADriverVTable*)ptr)->vaUnmapBuffer} a u -- n", "", "", "	( ctx buf_id -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTable-vaDestroyBuffer() {((struct VADriverVTable*)ptr)->vaDestroyBuffer} a u -- n", "", "", "	( ctx buffer_id -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTable-vaBeginPicture() {((struct VADriverVTable*)ptr)->vaBeginPicture} a u u -- n", "", "", "	( ctx context render_target -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTable-vaRenderPicture() {((struct VADriverVTable*)ptr)->vaRenderPicture} a u a n -- n", "", "", "	( ctx context buffers num_buffers -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTable-vaEndPicture() {((struct VADriverVTable*)ptr)->vaEndPicture} a u -- n", "", "", "	( ctx context -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTable-vaSyncSurface() {((struct VADriverVTable*)ptr)->vaSyncSurface} a u -- n", "", "", "	( ctx render_target -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTable-vaQuerySurfaceStatus() {((struct VADriverVTable*)ptr)->vaQuerySurfaceStatus} a u a -- n", "", "", "	( ctx render_target status -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTable-vaQuerySurfaceError() {((struct VADriverVTable*)ptr)->vaQuerySurfaceError} a u n a -- n", "", "", "	( ctx render_target error_status error_info -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTable-vaPutSurface() {((struct VADriverVTable*)ptr)->vaPutSurface} a u a n n u u n n u u a u u -- n", "", "", "	( ctx surface draw srcx srcy srcw srch destx desty destw desth cliprects number_cliprects flags -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTable-vaQueryImageFormats() {((struct VADriverVTable*)ptr)->vaQueryImageFormats} a a a -- n", "", "", "	( ctx format_list num_formats -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTable-vaCreateImage() {((struct VADriverVTable*)ptr)->vaCreateImage} a a n n a -- n", "", "", "	( ctx format width height image -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTable-vaDeriveImage() {((struct VADriverVTable*)ptr)->vaDeriveImage} a u a -- n", "", "", "	( ctx surface image -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTable-vaDestroyImage() {((struct VADriverVTable*)ptr)->vaDestroyImage} a u -- n", "", "", "	( ctx image -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTable-vaSetImagePalette() {((struct VADriverVTable*)ptr)->vaSetImagePalette} a u a -- n", "", "", "	( ctx image palette -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTable-vaGetImage() {((struct VADriverVTable*)ptr)->vaGetImage} a u n n u u u -- n", "", "", "	( ctx surface x y width height image -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTable-vaPutImage() {((struct VADriverVTable*)ptr)->vaPutImage} a u u n n u u n n u u -- n", "", "", "	( ctx surface image src_x src_y src_width src_height dest_x dest_y dest_width dest_height -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTable-vaQuerySubpictureFormats() {((struct VADriverVTable*)ptr)->vaQuerySubpictureFormats} a a a a -- n", "", "", "	( ctx format_list flags num_formats -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTable-vaCreateSubpicture() {((struct VADriverVTable*)ptr)->vaCreateSubpicture} a u a -- n", "", "", "	( ctx image subpicture -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTable-vaDestroySubpicture() {((struct VADriverVTable*)ptr)->vaDestroySubpicture} a u -- n", "", "", "	( ctx subpicture -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTable-vaSetSubpictureImage() {((struct VADriverVTable*)ptr)->vaSetSubpictureImage} a u u -- n", "", "", "	( ctx subpicture image -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTable-vaSetSubpictureChromakey() {((struct VADriverVTable*)ptr)->vaSetSubpictureChromakey} a u u u u -- n", "", "", "	( ctx subpicture chromakey_min chromakey_max chromakey_mask -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTable-vaSetSubpictureGlobalAlpha() {((struct VADriverVTable*)ptr)->vaSetSubpictureGlobalAlpha} a u r -- n", "", "", "	( ctx subpicture global_alpha -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTable-vaAssociateSubpicture() {((struct VADriverVTable*)ptr)->vaAssociateSubpicture} a u a n n n u u n n u u u -- n", "", "", "	( ctx subpicture target_surfaces num_surfaces src_x src_y src_width src_height dest_x dest_y dest_width dest_height flags -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTable-vaDeassociateSubpicture() {((struct VADriverVTable*)ptr)->vaDeassociateSubpicture} a u a n -- n", "", "", "	( ctx subpicture target_surfaces num_surfaces -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTable-vaQueryDisplayAttributes() {((struct VADriverVTable*)ptr)->vaQueryDisplayAttributes} a a a -- n", "", "", "	( ctx attr_list num_attributes -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTable-vaGetDisplayAttributes() {((struct VADriverVTable*)ptr)->vaGetDisplayAttributes} a a n -- n", "", "", "	( ctx attr_list num_attributes -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTable-vaSetDisplayAttributes() {((struct VADriverVTable*)ptr)->vaSetDisplayAttributes} a a n -- n", "", "", "	( ctx attr_list num_attributes -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTable-vaBufferInfo() {((struct VADriverVTable*)ptr)->vaBufferInfo} a u a a a -- n", "", "", "	( ctx buf_id type size num_elements -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTable-vaLockSurface() {((struct VADriverVTable*)ptr)->vaLockSurface} a u a a a a a a a a a -- n", "", "", "	( ctx surface fourcc luma_stride chroma_u_stride chroma_v_stride luma_offset chroma_u_offset chroma_v_offset buffer_name buffer -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTable-vaUnlockSurface() {((struct VADriverVTable*)ptr)->vaUnlockSurface} a u -- n", "", "", "	( ctx surface -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTable-vaGetSurfaceAttributes() {((struct VADriverVTable*)ptr)->vaGetSurfaceAttributes} a u a u -- n", "", "", "	( dpy config attrib_list num_attribs -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTable-vaCreateSurfaces2() {((struct VADriverVTable*)ptr)->vaCreateSurfaces2} a u u u a u a u -- n", "", "", "	( ctx format width height surfaces num_surfaces attrib_list num_attribs -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTable-vaQuerySurfaceAttributes() {((struct VADriverVTable*)ptr)->vaQuerySurfaceAttributes} a u a a -- n", "", "", "	( dpy config attrib_list num_attribs -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTable-vaAcquireBufferHandle() {((struct VADriverVTable*)ptr)->vaAcquireBufferHandle} a u a -- n", "", "", "	( ctx buf_id buf_info -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTable-vaReleaseBufferHandle() {((struct VADriverVTable*)ptr)->vaReleaseBufferHandle} a u -- n", "", "", "	( ctx buf_id -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTable-vaCreateMFContext() {((struct VADriverVTable*)ptr)->vaCreateMFContext} a a -- n", "", "", "	( ctx mfe_context -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTable-vaMFAddContext() {((struct VADriverVTable*)ptr)->vaMFAddContext} a u u -- n", "", "", "	( ctx mf_context context -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTable-vaMFReleaseContext() {((struct VADriverVTable*)ptr)->vaMFReleaseContext} a u u -- n", "", "", "	( ctx mf_context context -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTable-vaMFSubmit() {((struct VADriverVTable*)ptr)->vaMFSubmit} a u a n -- n", "", "", "	( ctx mf_context contexts num_contexts -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTable-vaCreateBuffer2() {((struct VADriverVTable*)ptr)->vaCreateBuffer2} a u n u u a a a -- n", "", "", "	( ctx context type width height unit_size pitch buf_id -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTable-vaQueryProcessingRate() {((struct VADriverVTable*)ptr)->vaQueryProcessingRate} a u a a -- n", "", "", "	( ctx config_id proc_buf processing_rate -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTable-vaExportSurfaceHandle() {((struct VADriverVTable*)ptr)->vaExportSurfaceHandle} a u u u a -- n", "", "", "	( ctx surface_id mem_type flags descriptor -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTable-vaSyncSurface2() {((struct VADriverVTable*)ptr)->vaSyncSurface2} a u n -- n", "", "", "	( ctx surface timeout_ns -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTable-vaSyncBuffer() {((struct VADriverVTable*)ptr)->vaSyncBuffer} a u n -- n", "", "", "	( ctx buf_id timeout_ns -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTable-vaCopy() {((struct VADriverVTable*)ptr)->vaCopy} a a a a{*(VACopyOption*)} -- n", "", "", "	( ctx dst src option -- )" );
	swigFunctionPointer( "c-funptr VADriverContext-error_callback() {((struct VADriverContext*)ptr)->error_callback} a s -- void", "", "", "	( pDriverContext message -- )" );
	swigFunctionPointer( "c-funptr VADriverContext-info_callback() {((struct VADriverContext*)ptr)->info_callback} a s -- void", "", "", "	( pDriverContext message -- )" );
	swigFunctionPointer( "c-funptr VADisplayContext-vaIsValid() {((struct VADisplayContext*)ptr)->vaIsValid} a -- n", "", "", "	( ctx -- )" );
	swigFunctionPointer( "c-funptr VADisplayContext-vaDestroy() {((struct VADisplayContext*)ptr)->vaDestroy} a -- void", "", "", "	( ctx -- )" );
	swigFunctionPointer( "c-funptr VADisplayContext-vaGetDriverName() {((struct VADisplayContext*)ptr)->vaGetDriverName} a a -- n", "", "", "	( ctx driver_name -- )" );
	swigFunctionPointer( "c-funptr VADisplayContext-vaGetNumCandidates() {((struct VADisplayContext*)ptr)->vaGetNumCandidates} a a -- n", "", "", "	( ctx num_candidates -- )" );
	swigFunctionPointer( "c-funptr VADisplayContext-vaGetDriverNameByIndex() {((struct VADisplayContext*)ptr)->vaGetDriverNameByIndex} a a n -- n", "", "", "	( ctx driver_name candidate_index -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTableWayland-vaGetSurfaceBufferWl() {((struct VADriverVTableWayland*)ptr)->vaGetSurfaceBufferWl} a u u a -- n", "", "", "	( ctx surface flags out_buffer -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTableWayland-vaGetImageBufferWl() {((struct VADriverVTableWayland*)ptr)->vaGetImageBufferWl} a u u a -- n", "", "", "	( ctx image flags out_buffer -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTableGLX-vaCreateSurfaceGLX() {((struct VADriverVTableGLX*)ptr)->vaCreateSurfaceGLX} a u u a -- n", "", "", "	( ctx gl_target gl_texture gl_surface -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTableGLX-vaDestroySurfaceGLX() {((struct VADriverVTableGLX*)ptr)->vaDestroySurfaceGLX} a a -- n", "", "", "	( ctx gl_surface -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTableGLX-vaCopySurfaceGLX() {((struct VADriverVTableGLX*)ptr)->vaCopySurfaceGLX} a a u u -- n", "", "", "	( ctx gl_surface surface flags -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTableVPP-vaQueryVideoProcFilters() {((struct VADriverVTableVPP*)ptr)->vaQueryVideoProcFilters} a u a a -- n", "", "", "	( ctx context filters num_filters -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTableVPP-vaQueryVideoProcFilterCaps() {((struct VADriverVTableVPP*)ptr)->vaQueryVideoProcFilterCaps} a u n a a -- n", "", "", "	( ctx context type filter_caps num_filter_caps -- )" );
// 	swigFunctionPointer( "c-funptr VADriverVTableVPP-vaQueryVideoProcPipelineCaps() {((struct VADriverVTableVPP*)ptr)->vaQueryVideoProcPipelineCaps} a u a u a -- n", "", "", "	( ctx context filters num_filters pipeline_caps -- )" );

	swigNewline();

	swigComment("------===< callbacks >===-------\n");
	swigCallback( "c-callback VAMessageCallback: a s -- void", "", "", "	( user_context message -- )" );
	swigCallback( "c-callback VAPrivFunc:  -- n", "", "", "	( <noname> -- )" );
	swigCallback( "c-callback VAGenericFunc:  -- void", "", "", "	( <noname> -- )" );
	swigCallback( "c-callback VADriverInit: a -- n", "", "", "	( driver_context -- )" );

	swigNewline();

	swigComment("------===< functions >===-------\n");
	swigFunction( "c-function vaErrorStr vaErrorStr n -- s", "FUNCTION: vaErrorStr ( error_status -- s )", "EXTERN: \"C\" char * vaErrorStr( int error_status );", "	( error_status -- )" );
	swigFunction( "c-function vaSetErrorCallback vaSetErrorCallback a a a -- a", "FUNCTION: vaSetErrorCallback ( dpy callback user_context -- a )", "EXTERN: \"C\" void * vaSetErrorCallback( void * dpy, void * callback, void * user_context );", "	( dpy callback user_context -- )" );
	swigFunction( "c-function vaSetInfoCallback vaSetInfoCallback a a a -- a", "FUNCTION: vaSetInfoCallback ( dpy callback user_context -- a )", "EXTERN: \"C\" void * vaSetInfoCallback( void * dpy, void * callback, void * user_context );", "	( dpy callback user_context -- )" );
	swigFunction( "c-function vaDisplayIsValid vaDisplayIsValid a -- n", "FUNCTION: vaDisplayIsValid ( dpy -- n )", "EXTERN: \"C\" int vaDisplayIsValid( void * dpy );", "	( dpy -- )" );
	swigFunction( "c-function vaSetDriverName vaSetDriverName a a -- n", "FUNCTION: vaSetDriverName ( dpy driver_name -- n )", "EXTERN: \"C\" int vaSetDriverName( void * dpy, void * driver_name );", "	( dpy driver_name -- )" );
	swigFunction( "c-function vaInitialize vaInitialize a a a -- n", "FUNCTION: vaInitialize ( dpy major_version minor_version -- n )", "EXTERN: \"C\" int vaInitialize( void * dpy, void * major_version, void * minor_version );", "	( dpy major_version minor_version -- )" );
	swigFunction( "c-function vaTerminate vaTerminate a -- n", "FUNCTION: vaTerminate ( dpy -- n )", "EXTERN: \"C\" int vaTerminate( void * dpy );", "	( dpy -- )" );
	swigFunction( "c-function vaQueryVendorString vaQueryVendorString a -- s", "FUNCTION: vaQueryVendorString ( dpy -- s )", "EXTERN: \"C\" char * vaQueryVendorString( void * dpy );", "	( dpy -- )" );
	swigFunction( "c-function vaGetLibFunc vaGetLibFunc a s -- a", "FUNCTION: vaGetLibFunc ( dpy func -- a )", "EXTERN: \"C\" void * vaGetLibFunc( void * dpy, char * func );", "	( dpy func -- )" );
	swigFunction( "c-function vaMaxNumProfiles vaMaxNumProfiles a -- n", "FUNCTION: vaMaxNumProfiles ( dpy -- n )", "EXTERN: \"C\" int vaMaxNumProfiles( void * dpy );", "	( dpy -- )" );
	swigFunction( "c-function vaMaxNumEntrypoints vaMaxNumEntrypoints a -- n", "FUNCTION: vaMaxNumEntrypoints ( dpy -- n )", "EXTERN: \"C\" int vaMaxNumEntrypoints( void * dpy );", "	( dpy -- )" );
	swigFunction( "c-function vaMaxNumConfigAttributes vaMaxNumConfigAttributes a -- n", "FUNCTION: vaMaxNumConfigAttributes ( dpy -- n )", "EXTERN: \"C\" int vaMaxNumConfigAttributes( void * dpy );", "	( dpy -- )" );
	swigFunction( "c-function vaQueryConfigProfiles vaQueryConfigProfiles a a a -- n", "FUNCTION: vaQueryConfigProfiles ( dpy profile_list num_profiles -- n )", "EXTERN: \"C\" int vaQueryConfigProfiles( void * dpy, void * profile_list, void * num_profiles );", "	( dpy profile_list num_profiles -- )" );
	swigFunction( "c-function vaQueryConfigEntrypoints vaQueryConfigEntrypoints a n a a -- n", "FUNCTION: vaQueryConfigEntrypoints ( dpy profile entrypoint_list num_entrypoints -- n )", "EXTERN: \"C\" int vaQueryConfigEntrypoints( void * dpy, int profile, void * entrypoint_list, void * num_entrypoints );", "	( dpy profile entrypoint_list num_entrypoints -- )" );
	swigFunction( "c-function vaGetConfigAttributes vaGetConfigAttributes a n n a n -- n", "FUNCTION: vaGetConfigAttributes ( dpy profile entrypoint attrib_list num_attribs -- n )", "EXTERN: \"C\" int vaGetConfigAttributes( void * dpy, int profile, int entrypoint, void * attrib_list, int num_attribs );", "	( dpy profile entrypoint attrib_list num_attribs -- )" );
	swigFunction( "c-function vaCreateConfig vaCreateConfig a n n a n a -- n", "FUNCTION: vaCreateConfig ( dpy profile entrypoint attrib_list num_attribs config_id -- n )", "EXTERN: \"C\" int vaCreateConfig( void * dpy, int profile, int entrypoint, void * attrib_list, int num_attribs, void * config_id );", "	( dpy profile entrypoint attrib_list num_attribs config_id -- )" );
	swigFunction( "c-function vaDestroyConfig vaDestroyConfig a u -- n", "FUNCTION: vaDestroyConfig ( dpy config_id -- n )", "EXTERN: \"C\" int vaDestroyConfig( void * dpy, int config_id );", "	( dpy config_id -- )" );
	swigFunction( "c-function vaQueryConfigAttributes vaQueryConfigAttributes a u a a a a -- n", "FUNCTION: vaQueryConfigAttributes ( dpy config_id profile entrypoint attrib_list num_attribs -- n )", "EXTERN: \"C\" int vaQueryConfigAttributes( void * dpy, int config_id, void * profile, void * entrypoint, void * attrib_list, void * num_attribs );", "	( dpy config_id profile entrypoint attrib_list num_attribs -- )" );
	swigFunction( "c-function vaQuerySurfaceAttributes vaQuerySurfaceAttributes a u a a -- n", "FUNCTION: vaQuerySurfaceAttributes ( dpy config attrib_list num_attribs -- n )", "EXTERN: \"C\" int vaQuerySurfaceAttributes( void * dpy, int config, void * attrib_list, void * num_attribs );", "	( dpy config attrib_list num_attribs -- )" );
	swigFunction( "c-function vaCreateSurfaces vaCreateSurfaces a u u u a u a u -- n", "FUNCTION: vaCreateSurfaces ( dpy format width height surfaces num_surfaces attrib_list num_attribs -- n )", "EXTERN: \"C\" int vaCreateSurfaces( void * dpy, int format, int width, int height, void * surfaces, int num_surfaces, void * attrib_list, int num_attribs );", "	( dpy format width height surfaces num_surfaces attrib_list num_attribs -- )" );
	swigFunction( "c-function vaDestroySurfaces vaDestroySurfaces a a n -- n", "FUNCTION: vaDestroySurfaces ( dpy surfaces num_surfaces -- n )", "EXTERN: \"C\" int vaDestroySurfaces( void * dpy, void * surfaces, int num_surfaces );", "	( dpy surfaces num_surfaces -- )" );
	swigFunction( "c-function vaCreateContext vaCreateContext a u n n n a n a -- n", "FUNCTION: vaCreateContext ( dpy config_id picture_width picture_height flag render_targets num_render_targets context -- n )", "EXTERN: \"C\" int vaCreateContext( void * dpy, int config_id, int picture_width, int picture_height, int flag, void * render_targets, int num_render_targets, void * context );", "	( dpy config_id picture_width picture_height flag render_targets num_render_targets context -- )" );
	swigFunction( "c-function vaDestroyContext vaDestroyContext a u -- n", "FUNCTION: vaDestroyContext ( dpy context -- n )", "EXTERN: \"C\" int vaDestroyContext( void * dpy, int context );", "	( dpy context -- )" );
	swigFunction( "c-function vaCreateMFContext vaCreateMFContext a a -- n", "FUNCTION: vaCreateMFContext ( dpy mf_context -- n )", "EXTERN: \"C\" int vaCreateMFContext( void * dpy, void * mf_context );", "	( dpy mf_context -- )" );
	swigFunction( "c-function vaMFAddContext vaMFAddContext a u u -- n", "FUNCTION: vaMFAddContext ( dpy mf_context context -- n )", "EXTERN: \"C\" int vaMFAddContext( void * dpy, int mf_context, int context );", "	( dpy mf_context context -- )" );
	swigFunction( "c-function vaMFReleaseContext vaMFReleaseContext a u u -- n", "FUNCTION: vaMFReleaseContext ( dpy mf_context context -- n )", "EXTERN: \"C\" int vaMFReleaseContext( void * dpy, int mf_context, int context );", "	( dpy mf_context context -- )" );
	swigFunction( "c-function vaQueryProcessingRate vaQueryProcessingRate a u a a -- n", "FUNCTION: vaQueryProcessingRate ( dpy config proc_buf processing_rate -- n )", "EXTERN: \"C\" int vaQueryProcessingRate( void * dpy, int config, void * proc_buf, void * processing_rate );", "	( dpy config proc_buf processing_rate -- )" );
	swigFunction( "c-function vaCreateBuffer vaCreateBuffer a u n u u a a -- n", "FUNCTION: vaCreateBuffer ( dpy context type size num_elements data buf_id -- n )", "EXTERN: \"C\" int vaCreateBuffer( void * dpy, int context, int type, int size, int num_elements, void * data, void * buf_id );", "	( dpy context type size num_elements data buf_id -- )" );
	swigFunction( "c-function vaCreateBuffer2 vaCreateBuffer2 a u n u u a a a -- n", "FUNCTION: vaCreateBuffer2 ( dpy context type width height unit_size pitch buf_id -- n )", "EXTERN: \"C\" int vaCreateBuffer2( void * dpy, int context, int type, int width, int height, void * unit_size, void * pitch, void * buf_id );", "	( dpy context type width height unit_size pitch buf_id -- )" );
	swigFunction( "c-function vaBufferSetNumElements vaBufferSetNumElements a u u -- n", "FUNCTION: vaBufferSetNumElements ( dpy buf_id num_elements -- n )", "EXTERN: \"C\" int vaBufferSetNumElements( void * dpy, int buf_id, int num_elements );", "	( dpy buf_id num_elements -- )" );
	swigFunction( "c-function vaMapBuffer vaMapBuffer a u a -- n", "FUNCTION: vaMapBuffer ( dpy buf_id pbuf -- n )", "EXTERN: \"C\" int vaMapBuffer( void * dpy, int buf_id, void * pbuf );", "	( dpy buf_id pbuf -- )" );
	swigFunction( "c-function vaUnmapBuffer vaUnmapBuffer a u -- n", "FUNCTION: vaUnmapBuffer ( dpy buf_id -- n )", "EXTERN: \"C\" int vaUnmapBuffer( void * dpy, int buf_id );", "	( dpy buf_id -- )" );
	swigFunction( "c-function vaDestroyBuffer vaDestroyBuffer a u -- n", "FUNCTION: vaDestroyBuffer ( dpy buffer_id -- n )", "EXTERN: \"C\" int vaDestroyBuffer( void * dpy, int buffer_id );", "	( dpy buffer_id -- )" );
	swigFunction( "c-function vaAcquireBufferHandle vaAcquireBufferHandle a u a -- n", "FUNCTION: vaAcquireBufferHandle ( dpy buf_id buf_info -- n )", "EXTERN: \"C\" int vaAcquireBufferHandle( void * dpy, int buf_id, void * buf_info );", "	( dpy buf_id buf_info -- )" );
	swigFunction( "c-function vaReleaseBufferHandle vaReleaseBufferHandle a u -- n", "FUNCTION: vaReleaseBufferHandle ( dpy buf_id -- n )", "EXTERN: \"C\" int vaReleaseBufferHandle( void * dpy, int buf_id );", "	( dpy buf_id -- )" );
	swigFunction( "c-function vaExportSurfaceHandle vaExportSurfaceHandle a u u u a -- n", "FUNCTION: vaExportSurfaceHandle ( dpy surface_id mem_type flags descriptor -- n )", "EXTERN: \"C\" int vaExportSurfaceHandle( void * dpy, int surface_id, int mem_type, int flags, void * descriptor );", "	( dpy surface_id mem_type flags descriptor -- )" );
	swigFunction( "c-function vaBeginPicture vaBeginPicture a u u -- n", "FUNCTION: vaBeginPicture ( dpy context render_target -- n )", "EXTERN: \"C\" int vaBeginPicture( void * dpy, int context, int render_target );", "	( dpy context render_target -- )" );
	swigFunction( "c-function vaRenderPicture vaRenderPicture a u a n -- n", "FUNCTION: vaRenderPicture ( dpy context buffers num_buffers -- n )", "EXTERN: \"C\" int vaRenderPicture( void * dpy, int context, void * buffers, int num_buffers );", "	( dpy context buffers num_buffers -- )" );
	swigFunction( "c-function vaEndPicture vaEndPicture a u -- n", "FUNCTION: vaEndPicture ( dpy context -- n )", "EXTERN: \"C\" int vaEndPicture( void * dpy, int context );", "	( dpy context -- )" );
	swigFunction( "c-function vaMFSubmit vaMFSubmit a u a n -- n", "FUNCTION: vaMFSubmit ( dpy mf_context contexts num_contexts -- n )", "EXTERN: \"C\" int vaMFSubmit( void * dpy, int mf_context, void * contexts, int num_contexts );", "	( dpy mf_context contexts num_contexts -- )" );
	swigFunction( "c-function vaSyncSurface vaSyncSurface a u -- n", "FUNCTION: vaSyncSurface ( dpy render_target -- n )", "EXTERN: \"C\" int vaSyncSurface( void * dpy, int render_target );", "	( dpy render_target -- )" );
	swigFunction( "c-function vaSyncSurface2 vaSyncSurface2 a u n -- n", "FUNCTION: vaSyncSurface2 ( dpy surface timeout_ns -- n )", "EXTERN: \"C\" int vaSyncSurface2( void * dpy, int surface, long timeout_ns );", "	( dpy surface timeout_ns -- )" );
	swigFunction( "c-function vaQuerySurfaceStatus vaQuerySurfaceStatus a u a -- n", "FUNCTION: vaQuerySurfaceStatus ( dpy render_target status -- n )", "EXTERN: \"C\" int vaQuerySurfaceStatus( void * dpy, int render_target, void * status );", "	( dpy render_target status -- )" );
	swigFunction( "c-function vaQuerySurfaceError vaQuerySurfaceError a u n a -- n", "FUNCTION: vaQuerySurfaceError ( dpy surface error_status error_info -- n )", "EXTERN: \"C\" int vaQuerySurfaceError( void * dpy, int surface, int error_status, void * error_info );", "	( dpy surface error_status error_info -- )" );
	swigFunction( "c-function vaSyncBuffer vaSyncBuffer a u n -- n", "FUNCTION: vaSyncBuffer ( dpy buf_id timeout_ns -- n )", "EXTERN: \"C\" int vaSyncBuffer( void * dpy, int buf_id, long timeout_ns );", "	( dpy buf_id timeout_ns -- )" );
	swigFunction( "c-function vaMaxNumImageFormats vaMaxNumImageFormats a -- n", "FUNCTION: vaMaxNumImageFormats ( dpy -- n )", "EXTERN: \"C\" int vaMaxNumImageFormats( void * dpy );", "	( dpy -- )" );
	swigFunction( "c-function vaQueryImageFormats vaQueryImageFormats a a a -- n", "FUNCTION: vaQueryImageFormats ( dpy format_list num_formats -- n )", "EXTERN: \"C\" int vaQueryImageFormats( void * dpy, void * format_list, void * num_formats );", "	( dpy format_list num_formats -- )" );
	swigFunction( "c-function vaCreateImage vaCreateImage a a n n a -- n", "FUNCTION: vaCreateImage ( dpy format width height image -- n )", "EXTERN: \"C\" int vaCreateImage( void * dpy, void * format, int width, int height, void * image );", "	( dpy format width height image -- )" );
	swigFunction( "c-function vaDestroyImage vaDestroyImage a u -- n", "FUNCTION: vaDestroyImage ( dpy image -- n )", "EXTERN: \"C\" int vaDestroyImage( void * dpy, int image );", "	( dpy image -- )" );
	swigFunction( "c-function vaSetImagePalette vaSetImagePalette a u a -- n", "FUNCTION: vaSetImagePalette ( dpy image palette -- n )", "EXTERN: \"C\" int vaSetImagePalette( void * dpy, int image, void * palette );", "	( dpy image palette -- )" );
	swigFunction( "c-function vaGetImage vaGetImage a u n n u u u -- n", "FUNCTION: vaGetImage ( dpy surface x y width height image -- n )", "EXTERN: \"C\" int vaGetImage( void * dpy, int surface, int x, int y, int width, int height, int image );", "	( dpy surface x y width height image -- )" );
	swigFunction( "c-function vaPutImage vaPutImage a u u n n u u n n u u -- n", "FUNCTION: vaPutImage ( dpy surface image src_x src_y src_width src_height dest_x dest_y dest_width dest_height -- n )", "EXTERN: \"C\" int vaPutImage( void * dpy, int surface, int image, int src_x, int src_y, int src_width, int src_height, int dest_x, int dest_y, int dest_width, int dest_height );", "	( dpy surface image src_x src_y src_width src_height dest_x dest_y dest_width dest_height -- )" );
	swigFunction( "c-function vaDeriveImage vaDeriveImage a u a -- n", "FUNCTION: vaDeriveImage ( dpy surface image -- n )", "EXTERN: \"C\" int vaDeriveImage( void * dpy, int surface, void * image );", "	( dpy surface image -- )" );
	swigFunction( "c-function vaMaxNumSubpictureFormats vaMaxNumSubpictureFormats a -- n", "FUNCTION: vaMaxNumSubpictureFormats ( dpy -- n )", "EXTERN: \"C\" int vaMaxNumSubpictureFormats( void * dpy );", "	( dpy -- )" );
	swigFunction( "c-function vaQuerySubpictureFormats vaQuerySubpictureFormats a a a a -- n", "FUNCTION: vaQuerySubpictureFormats ( dpy format_list flags num_formats -- n )", "EXTERN: \"C\" int vaQuerySubpictureFormats( void * dpy, void * format_list, void * flags, void * num_formats );", "	( dpy format_list flags num_formats -- )" );
	swigFunction( "c-function vaCreateSubpicture vaCreateSubpicture a u a -- n", "FUNCTION: vaCreateSubpicture ( dpy image subpicture -- n )", "EXTERN: \"C\" int vaCreateSubpicture( void * dpy, int image, void * subpicture );", "	( dpy image subpicture -- )" );
	swigFunction( "c-function vaDestroySubpicture vaDestroySubpicture a u -- n", "FUNCTION: vaDestroySubpicture ( dpy subpicture -- n )", "EXTERN: \"C\" int vaDestroySubpicture( void * dpy, int subpicture );", "	( dpy subpicture -- )" );
	swigFunction( "c-function vaSetSubpictureImage vaSetSubpictureImage a u u -- n", "FUNCTION: vaSetSubpictureImage ( dpy subpicture image -- n )", "EXTERN: \"C\" int vaSetSubpictureImage( void * dpy, int subpicture, int image );", "	( dpy subpicture image -- )" );
	swigFunction( "c-function vaSetSubpictureChromakey vaSetSubpictureChromakey a u u u u -- n", "FUNCTION: vaSetSubpictureChromakey ( dpy subpicture chromakey_min chromakey_max chromakey_mask -- n )", "EXTERN: \"C\" int vaSetSubpictureChromakey( void * dpy, int subpicture, int chromakey_min, int chromakey_max, int chromakey_mask );", "	( dpy subpicture chromakey_min chromakey_max chromakey_mask -- )" );
	swigFunction( "c-function vaSetSubpictureGlobalAlpha vaSetSubpictureGlobalAlpha a u r -- n", "FUNCTION: vaSetSubpictureGlobalAlpha ( dpy subpicture global_alpha -- n )", "EXTERN: \"C\" int vaSetSubpictureGlobalAlpha( void * dpy, int subpicture, float global_alpha );", "	( dpy subpicture global_alpha -- )" );
	swigFunction( "c-function vaAssociateSubpicture vaAssociateSubpicture a u a n n n u u n n u u u -- n", "FUNCTION: vaAssociateSubpicture ( dpy subpicture target_surfaces num_surfaces src_x src_y src_width src_height dest_x dest_y dest_width dest_height flags -- n )", "EXTERN: \"C\" int vaAssociateSubpicture( void * dpy, int subpicture, void * target_surfaces, int num_surfaces, int src_x, int src_y, int src_width, int src_height, int dest_x, int dest_y, int dest_width, int dest_height, int flags );", "	( dpy subpicture target_surfaces num_surfaces src_x src_y src_width src_height dest_x dest_y dest_width dest_height flags -- )" );
	swigFunction( "c-function vaDeassociateSubpicture vaDeassociateSubpicture a u a n -- n", "FUNCTION: vaDeassociateSubpicture ( dpy subpicture target_surfaces num_surfaces -- n )", "EXTERN: \"C\" int vaDeassociateSubpicture( void * dpy, int subpicture, void * target_surfaces, int num_surfaces );", "	( dpy subpicture target_surfaces num_surfaces -- )" );
	swigFunction( "c-function vaMaxNumDisplayAttributes vaMaxNumDisplayAttributes a -- n", "FUNCTION: vaMaxNumDisplayAttributes ( dpy -- n )", "EXTERN: \"C\" int vaMaxNumDisplayAttributes( void * dpy );", "	( dpy -- )" );
	swigFunction( "c-function vaQueryDisplayAttributes vaQueryDisplayAttributes a a a -- n", "FUNCTION: vaQueryDisplayAttributes ( dpy attr_list num_attributes -- n )", "EXTERN: \"C\" int vaQueryDisplayAttributes( void * dpy, void * attr_list, void * num_attributes );", "	( dpy attr_list num_attributes -- )" );
	swigFunction( "c-function vaGetDisplayAttributes vaGetDisplayAttributes a a n -- n", "FUNCTION: vaGetDisplayAttributes ( dpy attr_list num_attributes -- n )", "EXTERN: \"C\" int vaGetDisplayAttributes( void * dpy, void * attr_list, int num_attributes );", "	( dpy attr_list num_attributes -- )" );
	swigFunction( "c-function vaSetDisplayAttributes vaSetDisplayAttributes a a n -- n", "FUNCTION: vaSetDisplayAttributes ( dpy attr_list num_attributes -- n )", "EXTERN: \"C\" int vaSetDisplayAttributes( void * dpy, void * attr_list, int num_attributes );", "	( dpy attr_list num_attributes -- )" );
	swigFunction( "c-function vaCopy vaCopy a a a a{*(VACopyOption*)} -- n", "FUNCTION: vaCopy ( dpy dst src option -- n )", "EXTERN: \"C\" int vaCopy( void * dpy, void * dst, void * src, void * option );", "	( dpy dst src option -- )" );
	swigFunction( "c-function vaQueryVideoProcFilters vaQueryVideoProcFilters a u a a -- n", "FUNCTION: vaQueryVideoProcFilters ( dpy context filters num_filters -- n )", "EXTERN: \"C\" int vaQueryVideoProcFilters( void * dpy, int context, void * filters, void * num_filters );", "	( dpy context filters num_filters -- )" );
	swigFunction( "c-function vaQueryVideoProcFilterCaps vaQueryVideoProcFilterCaps a u n a a -- n", "FUNCTION: vaQueryVideoProcFilterCaps ( dpy context type filter_caps num_filter_caps -- n )", "EXTERN: \"C\" int vaQueryVideoProcFilterCaps( void * dpy, int context, int type, void * filter_caps, void * num_filter_caps );", "	( dpy context type filter_caps num_filter_caps -- )" );
	swigFunction( "c-function vaQueryVideoProcPipelineCaps vaQueryVideoProcPipelineCaps a u a u a -- n", "FUNCTION: vaQueryVideoProcPipelineCaps ( dpy context filters num_filters pipeline_caps -- n )", "EXTERN: \"C\" int vaQueryVideoProcPipelineCaps( void * dpy, int context, void * filters, int num_filters, void * pipeline_caps );", "	( dpy context filters num_filters pipeline_caps -- )" );

	swigNewline();

	swigComment("----===< postfix >===-----\n");

	swigPrint( "end-c-library", "( none )", "( none )" );
	
	return 0;
} /* end of main */



