/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 3.0.9
 *
 * This file is not intended to be easily readable and contains a number of
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG
 * interface file instead.
 * ----------------------------------------------------------------------------- */
#include <stdio.h>
#include <string.h>
#include <stddef.h>

// Do not edit below this line
// end-of-default-includes


#include <linux/videodev2.h>
#include <linux/v4l2-mediabus.h>
#include <linux/v4l2-subdev.h>
#include <linux/v4l2-dv-timings.h>
#ifdef __gnu_linux__
#undef stderr
extern struct _IO_FILE *stderr;
#endif

typedef enum{ NONE = -1, GFORTH = 0, SWIFTFORTH, VFX } SwigTargetSystem;
SwigTargetSystem swigTargetSystem = NONE;

unsigned char swigPrintStackComments = 1;

/* comments */
void swigNewline()
{
	printf( "\n" );
}

void swigComment( char *comment )
{
	printf( "\\ %s", comment );
}

/* generic print */
void swigPrint( char* gforth, char *swiftForth, char *vfx )
{
	if( swigTargetSystem == GFORTH )
		printf( "%s", gforth );
	else if( swigTargetSystem == SWIFTFORTH )
		printf( "%s", swiftForth );
	else if( swigTargetSystem == VFX )
		printf( "%s", vfx );
	printf( "\n" );
}
void swigPrintSystem( SwigTargetSystem targetSystem, char *text )
{
	if( targetSystem == swigTargetSystem )
	    printf( "%s\n", text );
}

/* constants */
void swigIntConstant( long constant, char *name )
{
	printf( "#%ld\tconstant %s\n", constant, name );
}

void swigUnsignedIntConstant( unsigned long constant, char *name )
{
	printf( "#%lu\tconstant %s\n", constant, name );
}

void swigLongConstant( long long constant, char *name )
{
	printf( "#%lld.\t2constant %s\n", constant, name );
}

void swigUnsignedLongConstant( unsigned long long constant, char *name )
{
	printf( "#%llu.\t2constant %s\n", constant, name );
}

void swigFloatConstant( double constant, char *name )
{
	char buffer[128];
	sprintf( buffer, "%f", constant );

	/* if the constant contains no exponent, add one */
	char *s;
	for( s = buffer; *s != 0; s++ )
		if( *s == 'e' || *s == 'E' )
			break;

	/* exponent found */
	if( *s != 0 )
		printf( "%s\tfconstant %s\n", buffer, name );
	/* not found */
	else
		printf( "%se0\tfconstant %s\n", buffer, name );
}

void swigStringConstant( char* constant, char *name )
{
	char c;
	printf( ": %s s\\\" ", name );
	while(( c = *constant++ ))
	{
		switch(c)
		{
			case '\b': printf( "\\b" ); break;
			case '\n': printf( "\\n" ); break;
			case '\f': printf( "\\f" ); break;
			case '\r': printf( "\\r" ); break;
			case '\t': printf( "\\t" ); break;
			case '"' : printf( "\\q" ); break;
			default:
				if(c < 0x20)
					printf("\\x%02x", c);
				else
					printf("%c", c); break;
		}
	}
	printf(	"\" ;\n" );
}

/* structs */
void swigStructField( char *name, size_t offset, size_t size )
{
	printf( "\tdrop %zu %zu +field %s\n", offset, size, name );
}

/* functions */
void swigFunction( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	if( swigTargetSystem == GFORTH )
		printf( "%s", gforth );
	else if( swigTargetSystem == SWIFTFORTH )
		printf( "%s", swiftForth );
	else if( swigTargetSystem == VFX )
		printf( "%s", vfx );

	if( swigPrintStackComments )
		printf( "%s", stackComment );

	printf( "\n" );
}

/* function pointers */
void swigFunctionPointer( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	swigFunction( gforth, swiftForth, vfx, stackComment );
}

/* callbacks */
void swigCallback( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	swigFunction( gforth, swiftForth, vfx, stackComment );
}

void swigUsage( char **argv )
{
	fprintf( stderr, "Usage: %s [-gforth|-swiftforth|-vfx]\n", argv[0] );
}

int main( int argc, char **argv )
{
	int i;

	/* check arguments */
	for( i = 1; i < argc; i++ )
		if( strcmp( argv[i], "-gforth" ) == 0 )
			swigTargetSystem = GFORTH;
		else if( strcmp( argv[i], "-swiftforth" ) == 0 )
			swigTargetSystem = SWIFTFORTH;
		else if( strcmp( argv[i], "-vfx" ) == 0 )
			swigTargetSystem = VFX;

	if( swigTargetSystem == NONE )
	{
		fprintf( stderr, "Error: no target system specified\n" );
		swigUsage( argv );
		return 1;
	}

	/* primer */
	printf( "\\ This file has been generated using SWIG and fsi,\n"
		"\\ and is already platform dependent, search for the corresponding\n"
		"\\ fsi-file to compile it where no one has compiled it before ;)\n"
		"\\ Forth systems have their own own dynamic loader and don't need addional C-Code.\n"
		"\\ That's why this file will just print normal forth-code once compiled\n"
		"\\ and can be used directly with include or require.\n"
		"\\ As all comments are stripped during the compilation, please\n"
		"\\ insert the copyright notice of the original file here.\n"
	);


typedef union {
  __u32		mem_offset;
  unsigned long	userptr;
  __s32		fd;
} v4l2_plane_m;

typedef union {
  __u32           offset;
  unsigned long   userptr;
  struct v4l2_plane *planes;
  __s32		fd;
} v4l2_buffer_m;

typedef struct {
  __u32		width;
  __u32		height;
  __u32		pixelformat;
  __u32		field;		                     
  __u32		bytesperline;	                                 
  __u32		sizeimage;
  __u32		colorspace;	                          
  __u32		priv;		                              
} v4l2_framebuffer_fmt;

typedef struct {
  __u32 data[8];
} _raw_enc;

typedef struct {
  __u64 pts;
} _stop;

typedef struct {
  __s32 speed;
  __u32 format;
} _start;

typedef struct {
  __u32 data[16];
} _raw_dec;

typedef union {
  struct v4l2_pix_format		pix;                                      
  struct v4l2_pix_format_mplane	pix_mp;                                          
  struct v4l2_window		win;                                      
  struct v4l2_vbi_format		vbi;                                    
  struct v4l2_sliced_vbi_format	sliced;                                        
  struct v4l2_sdr_format		sdr;                                    
  struct v4l2_meta_format		meta;                                    
  __u8	raw_data[200];                                     
} v4l2_format_fmt;

typedef union {
  struct v4l2_captureparm	capture;
  struct v4l2_outputparm	output;
  __u8	raw_data[200];                    
} v4l2_streamparm_parm;

typedef union {
  struct v4l2_event_vsync		vsync;
  struct v4l2_event_ctrl		ctrl;
  struct v4l2_event_frame_sync	frame_sync;
  struct v4l2_event_src_change	src_change;
  struct v4l2_event_motion_det	motion_det;
  __u8				data[64];
} v4l2_event_u;


	swigNewline();

	swigComment("----===< int constants >===-----\n");
	#ifdef VIDEO_MAX_FRAME
		swigIntConstant( VIDEO_MAX_FRAME, "VIDEO_MAX_FRAME" );
	#endif
	#ifdef VIDEO_MAX_PLANES
		swigIntConstant( VIDEO_MAX_PLANES, "VIDEO_MAX_PLANES" );
	#endif
	#ifdef V4L2_CAP_VIDEO_CAPTURE
		swigIntConstant( V4L2_CAP_VIDEO_CAPTURE, "V4L2_CAP_VIDEO_CAPTURE" );
	#endif
	#ifdef V4L2_CAP_VIDEO_OUTPUT
		swigIntConstant( V4L2_CAP_VIDEO_OUTPUT, "V4L2_CAP_VIDEO_OUTPUT" );
	#endif
	#ifdef V4L2_CAP_VIDEO_OVERLAY
		swigIntConstant( V4L2_CAP_VIDEO_OVERLAY, "V4L2_CAP_VIDEO_OVERLAY" );
	#endif
	#ifdef V4L2_CAP_VBI_CAPTURE
		swigIntConstant( V4L2_CAP_VBI_CAPTURE, "V4L2_CAP_VBI_CAPTURE" );
	#endif
	#ifdef V4L2_CAP_VBI_OUTPUT
		swigIntConstant( V4L2_CAP_VBI_OUTPUT, "V4L2_CAP_VBI_OUTPUT" );
	#endif
	#ifdef V4L2_CAP_SLICED_VBI_CAPTURE
		swigIntConstant( V4L2_CAP_SLICED_VBI_CAPTURE, "V4L2_CAP_SLICED_VBI_CAPTURE" );
	#endif
	#ifdef V4L2_CAP_SLICED_VBI_OUTPUT
		swigIntConstant( V4L2_CAP_SLICED_VBI_OUTPUT, "V4L2_CAP_SLICED_VBI_OUTPUT" );
	#endif
	#ifdef V4L2_CAP_RDS_CAPTURE
		swigIntConstant( V4L2_CAP_RDS_CAPTURE, "V4L2_CAP_RDS_CAPTURE" );
	#endif
	#ifdef V4L2_CAP_VIDEO_OUTPUT_OVERLAY
		swigIntConstant( V4L2_CAP_VIDEO_OUTPUT_OVERLAY, "V4L2_CAP_VIDEO_OUTPUT_OVERLAY" );
	#endif
	#ifdef V4L2_CAP_HW_FREQ_SEEK
		swigIntConstant( V4L2_CAP_HW_FREQ_SEEK, "V4L2_CAP_HW_FREQ_SEEK" );
	#endif
	#ifdef V4L2_CAP_RDS_OUTPUT
		swigIntConstant( V4L2_CAP_RDS_OUTPUT, "V4L2_CAP_RDS_OUTPUT" );
	#endif
	#ifdef V4L2_CAP_VIDEO_CAPTURE_MPLANE
		swigIntConstant( V4L2_CAP_VIDEO_CAPTURE_MPLANE, "V4L2_CAP_VIDEO_CAPTURE_MPLANE" );
	#endif
	#ifdef V4L2_CAP_VIDEO_OUTPUT_MPLANE
		swigIntConstant( V4L2_CAP_VIDEO_OUTPUT_MPLANE, "V4L2_CAP_VIDEO_OUTPUT_MPLANE" );
	#endif
	#ifdef V4L2_CAP_VIDEO_M2M_MPLANE
		swigIntConstant( V4L2_CAP_VIDEO_M2M_MPLANE, "V4L2_CAP_VIDEO_M2M_MPLANE" );
	#endif
	#ifdef V4L2_CAP_VIDEO_M2M
		swigIntConstant( V4L2_CAP_VIDEO_M2M, "V4L2_CAP_VIDEO_M2M" );
	#endif
	#ifdef V4L2_CAP_TUNER
		swigIntConstant( V4L2_CAP_TUNER, "V4L2_CAP_TUNER" );
	#endif
	#ifdef V4L2_CAP_AUDIO
		swigIntConstant( V4L2_CAP_AUDIO, "V4L2_CAP_AUDIO" );
	#endif
	#ifdef V4L2_CAP_RADIO
		swigIntConstant( V4L2_CAP_RADIO, "V4L2_CAP_RADIO" );
	#endif
	#ifdef V4L2_CAP_MODULATOR
		swigIntConstant( V4L2_CAP_MODULATOR, "V4L2_CAP_MODULATOR" );
	#endif
	#ifdef V4L2_CAP_SDR_CAPTURE
		swigIntConstant( V4L2_CAP_SDR_CAPTURE, "V4L2_CAP_SDR_CAPTURE" );
	#endif
	#ifdef V4L2_CAP_EXT_PIX_FORMAT
		swigIntConstant( V4L2_CAP_EXT_PIX_FORMAT, "V4L2_CAP_EXT_PIX_FORMAT" );
	#endif
	#ifdef V4L2_CAP_SDR_OUTPUT
		swigIntConstant( V4L2_CAP_SDR_OUTPUT, "V4L2_CAP_SDR_OUTPUT" );
	#endif
	#ifdef V4L2_CAP_META_CAPTURE
		swigIntConstant( V4L2_CAP_META_CAPTURE, "V4L2_CAP_META_CAPTURE" );
	#endif
	#ifdef V4L2_CAP_READWRITE
		swigIntConstant( V4L2_CAP_READWRITE, "V4L2_CAP_READWRITE" );
	#endif
	#ifdef V4L2_CAP_ASYNCIO
		swigIntConstant( V4L2_CAP_ASYNCIO, "V4L2_CAP_ASYNCIO" );
	#endif
	#ifdef V4L2_CAP_STREAMING
		swigIntConstant( V4L2_CAP_STREAMING, "V4L2_CAP_STREAMING" );
	#endif
	#ifdef V4L2_CAP_META_OUTPUT
		swigIntConstant( V4L2_CAP_META_OUTPUT, "V4L2_CAP_META_OUTPUT" );
	#endif
	#ifdef V4L2_CAP_TOUCH
		swigIntConstant( V4L2_CAP_TOUCH, "V4L2_CAP_TOUCH" );
	#endif
	#ifdef V4L2_CAP_IO_MC
		swigIntConstant( V4L2_CAP_IO_MC, "V4L2_CAP_IO_MC" );
	#endif
	#ifdef V4L2_CAP_DEVICE_CAPS
		swigIntConstant( V4L2_CAP_DEVICE_CAPS, "V4L2_CAP_DEVICE_CAPS" );
	#endif
	#ifdef V4L2_PIX_FMT_PRIV_MAGIC
		swigIntConstant( V4L2_PIX_FMT_PRIV_MAGIC, "V4L2_PIX_FMT_PRIV_MAGIC" );
	#endif
	#ifdef V4L2_PIX_FMT_FLAG_PREMUL_ALPHA
		swigIntConstant( V4L2_PIX_FMT_FLAG_PREMUL_ALPHA, "V4L2_PIX_FMT_FLAG_PREMUL_ALPHA" );
	#endif
	#ifdef V4L2_PIX_FMT_FLAG_SET_CSC
		swigIntConstant( V4L2_PIX_FMT_FLAG_SET_CSC, "V4L2_PIX_FMT_FLAG_SET_CSC" );
	#endif
	#ifdef V4L2_FMT_FLAG_COMPRESSED
		swigIntConstant( V4L2_FMT_FLAG_COMPRESSED, "V4L2_FMT_FLAG_COMPRESSED" );
	#endif
	#ifdef V4L2_FMT_FLAG_EMULATED
		swigIntConstant( V4L2_FMT_FLAG_EMULATED, "V4L2_FMT_FLAG_EMULATED" );
	#endif
	#ifdef V4L2_FMT_FLAG_CONTINUOUS_BYTESTREAM
		swigIntConstant( V4L2_FMT_FLAG_CONTINUOUS_BYTESTREAM, "V4L2_FMT_FLAG_CONTINUOUS_BYTESTREAM" );
	#endif
	#ifdef V4L2_FMT_FLAG_DYN_RESOLUTION
		swigIntConstant( V4L2_FMT_FLAG_DYN_RESOLUTION, "V4L2_FMT_FLAG_DYN_RESOLUTION" );
	#endif
	#ifdef V4L2_FMT_FLAG_ENC_CAP_FRAME_INTERVAL
		swigIntConstant( V4L2_FMT_FLAG_ENC_CAP_FRAME_INTERVAL, "V4L2_FMT_FLAG_ENC_CAP_FRAME_INTERVAL" );
	#endif
	#ifdef V4L2_FMT_FLAG_CSC_COLORSPACE
		swigIntConstant( V4L2_FMT_FLAG_CSC_COLORSPACE, "V4L2_FMT_FLAG_CSC_COLORSPACE" );
	#endif
	#ifdef V4L2_FMT_FLAG_CSC_XFER_FUNC
		swigIntConstant( V4L2_FMT_FLAG_CSC_XFER_FUNC, "V4L2_FMT_FLAG_CSC_XFER_FUNC" );
	#endif
	#ifdef V4L2_FMT_FLAG_CSC_YCBCR_ENC
		swigIntConstant( V4L2_FMT_FLAG_CSC_YCBCR_ENC, "V4L2_FMT_FLAG_CSC_YCBCR_ENC" );
	#endif
	#ifdef V4L2_FMT_FLAG_CSC_HSV_ENC
		swigIntConstant( V4L2_FMT_FLAG_CSC_HSV_ENC, "V4L2_FMT_FLAG_CSC_HSV_ENC" );
	#endif
	#ifdef V4L2_FMT_FLAG_CSC_QUANTIZATION
		swigIntConstant( V4L2_FMT_FLAG_CSC_QUANTIZATION, "V4L2_FMT_FLAG_CSC_QUANTIZATION" );
	#endif
	#ifdef V4L2_TC_TYPE_24FPS
		swigIntConstant( V4L2_TC_TYPE_24FPS, "V4L2_TC_TYPE_24FPS" );
	#endif
	#ifdef V4L2_TC_TYPE_25FPS
		swigIntConstant( V4L2_TC_TYPE_25FPS, "V4L2_TC_TYPE_25FPS" );
	#endif
	#ifdef V4L2_TC_TYPE_30FPS
		swigIntConstant( V4L2_TC_TYPE_30FPS, "V4L2_TC_TYPE_30FPS" );
	#endif
	#ifdef V4L2_TC_TYPE_50FPS
		swigIntConstant( V4L2_TC_TYPE_50FPS, "V4L2_TC_TYPE_50FPS" );
	#endif
	#ifdef V4L2_TC_TYPE_60FPS
		swigIntConstant( V4L2_TC_TYPE_60FPS, "V4L2_TC_TYPE_60FPS" );
	#endif
	#ifdef V4L2_TC_FLAG_DROPFRAME
		swigIntConstant( V4L2_TC_FLAG_DROPFRAME, "V4L2_TC_FLAG_DROPFRAME" );
	#endif
	#ifdef V4L2_TC_FLAG_COLORFRAME
		swigIntConstant( V4L2_TC_FLAG_COLORFRAME, "V4L2_TC_FLAG_COLORFRAME" );
	#endif
	#ifdef V4L2_TC_USERBITS_field
		swigIntConstant( V4L2_TC_USERBITS_field, "V4L2_TC_USERBITS_field" );
	#endif
	#ifdef V4L2_TC_USERBITS_USERDEFINED
		swigIntConstant( V4L2_TC_USERBITS_USERDEFINED, "V4L2_TC_USERBITS_USERDEFINED" );
	#endif
	#ifdef V4L2_TC_USERBITS_8BITCHARS
		swigIntConstant( V4L2_TC_USERBITS_8BITCHARS, "V4L2_TC_USERBITS_8BITCHARS" );
	#endif
	#ifdef V4L2_JPEG_MARKER_DHT
		swigIntConstant( V4L2_JPEG_MARKER_DHT, "V4L2_JPEG_MARKER_DHT" );
	#endif
	#ifdef V4L2_JPEG_MARKER_DQT
		swigIntConstant( V4L2_JPEG_MARKER_DQT, "V4L2_JPEG_MARKER_DQT" );
	#endif
	#ifdef V4L2_JPEG_MARKER_DRI
		swigIntConstant( V4L2_JPEG_MARKER_DRI, "V4L2_JPEG_MARKER_DRI" );
	#endif
	#ifdef V4L2_JPEG_MARKER_COM
		swigIntConstant( V4L2_JPEG_MARKER_COM, "V4L2_JPEG_MARKER_COM" );
	#endif
	#ifdef V4L2_JPEG_MARKER_APP
		swigIntConstant( V4L2_JPEG_MARKER_APP, "V4L2_JPEG_MARKER_APP" );
	#endif
	#ifdef V4L2_MEMORY_FLAG_NON_COHERENT
		swigIntConstant( V4L2_MEMORY_FLAG_NON_COHERENT, "V4L2_MEMORY_FLAG_NON_COHERENT" );
	#endif
	#ifdef V4L2_BUF_CAP_SUPPORTS_MMAP
		swigIntConstant( V4L2_BUF_CAP_SUPPORTS_MMAP, "V4L2_BUF_CAP_SUPPORTS_MMAP" );
	#endif
	#ifdef V4L2_BUF_CAP_SUPPORTS_USERPTR
		swigIntConstant( V4L2_BUF_CAP_SUPPORTS_USERPTR, "V4L2_BUF_CAP_SUPPORTS_USERPTR" );
	#endif
	#ifdef V4L2_BUF_CAP_SUPPORTS_DMABUF
		swigIntConstant( V4L2_BUF_CAP_SUPPORTS_DMABUF, "V4L2_BUF_CAP_SUPPORTS_DMABUF" );
	#endif
	#ifdef V4L2_BUF_CAP_SUPPORTS_REQUESTS
		swigIntConstant( V4L2_BUF_CAP_SUPPORTS_REQUESTS, "V4L2_BUF_CAP_SUPPORTS_REQUESTS" );
	#endif
	#ifdef V4L2_BUF_CAP_SUPPORTS_ORPHANED_BUFS
		swigIntConstant( V4L2_BUF_CAP_SUPPORTS_ORPHANED_BUFS, "V4L2_BUF_CAP_SUPPORTS_ORPHANED_BUFS" );
	#endif
	#ifdef V4L2_BUF_CAP_SUPPORTS_M2M_HOLD_CAPTURE_BUF
		swigIntConstant( V4L2_BUF_CAP_SUPPORTS_M2M_HOLD_CAPTURE_BUF, "V4L2_BUF_CAP_SUPPORTS_M2M_HOLD_CAPTURE_BUF" );
	#endif
	#ifdef V4L2_BUF_CAP_SUPPORTS_MMAP_CACHE_HINTS
		swigIntConstant( V4L2_BUF_CAP_SUPPORTS_MMAP_CACHE_HINTS, "V4L2_BUF_CAP_SUPPORTS_MMAP_CACHE_HINTS" );
	#endif
	#ifdef V4L2_BUF_FLAG_MAPPED
		swigIntConstant( V4L2_BUF_FLAG_MAPPED, "V4L2_BUF_FLAG_MAPPED" );
	#endif
	#ifdef V4L2_BUF_FLAG_QUEUED
		swigIntConstant( V4L2_BUF_FLAG_QUEUED, "V4L2_BUF_FLAG_QUEUED" );
	#endif
	#ifdef V4L2_BUF_FLAG_DONE
		swigIntConstant( V4L2_BUF_FLAG_DONE, "V4L2_BUF_FLAG_DONE" );
	#endif
	#ifdef V4L2_BUF_FLAG_KEYFRAME
		swigIntConstant( V4L2_BUF_FLAG_KEYFRAME, "V4L2_BUF_FLAG_KEYFRAME" );
	#endif
	#ifdef V4L2_BUF_FLAG_PFRAME
		swigIntConstant( V4L2_BUF_FLAG_PFRAME, "V4L2_BUF_FLAG_PFRAME" );
	#endif
	#ifdef V4L2_BUF_FLAG_BFRAME
		swigIntConstant( V4L2_BUF_FLAG_BFRAME, "V4L2_BUF_FLAG_BFRAME" );
	#endif
	#ifdef V4L2_BUF_FLAG_ERROR
		swigIntConstant( V4L2_BUF_FLAG_ERROR, "V4L2_BUF_FLAG_ERROR" );
	#endif
	#ifdef V4L2_BUF_FLAG_IN_REQUEST
		swigIntConstant( V4L2_BUF_FLAG_IN_REQUEST, "V4L2_BUF_FLAG_IN_REQUEST" );
	#endif
	#ifdef V4L2_BUF_FLAG_TIMECODE
		swigIntConstant( V4L2_BUF_FLAG_TIMECODE, "V4L2_BUF_FLAG_TIMECODE" );
	#endif
	#ifdef V4L2_BUF_FLAG_M2M_HOLD_CAPTURE_BUF
		swigIntConstant( V4L2_BUF_FLAG_M2M_HOLD_CAPTURE_BUF, "V4L2_BUF_FLAG_M2M_HOLD_CAPTURE_BUF" );
	#endif
	#ifdef V4L2_BUF_FLAG_PREPARED
		swigIntConstant( V4L2_BUF_FLAG_PREPARED, "V4L2_BUF_FLAG_PREPARED" );
	#endif
	#ifdef V4L2_BUF_FLAG_NO_CACHE_INVALIDATE
		swigIntConstant( V4L2_BUF_FLAG_NO_CACHE_INVALIDATE, "V4L2_BUF_FLAG_NO_CACHE_INVALIDATE" );
	#endif
	#ifdef V4L2_BUF_FLAG_NO_CACHE_CLEAN
		swigIntConstant( V4L2_BUF_FLAG_NO_CACHE_CLEAN, "V4L2_BUF_FLAG_NO_CACHE_CLEAN" );
	#endif
	#ifdef V4L2_BUF_FLAG_TIMESTAMP_MASK
		swigIntConstant( V4L2_BUF_FLAG_TIMESTAMP_MASK, "V4L2_BUF_FLAG_TIMESTAMP_MASK" );
	#endif
	#ifdef V4L2_BUF_FLAG_TIMESTAMP_UNKNOWN
		swigIntConstant( V4L2_BUF_FLAG_TIMESTAMP_UNKNOWN, "V4L2_BUF_FLAG_TIMESTAMP_UNKNOWN" );
	#endif
	#ifdef V4L2_BUF_FLAG_TIMESTAMP_MONOTONIC
		swigIntConstant( V4L2_BUF_FLAG_TIMESTAMP_MONOTONIC, "V4L2_BUF_FLAG_TIMESTAMP_MONOTONIC" );
	#endif
	#ifdef V4L2_BUF_FLAG_TIMESTAMP_COPY
		swigIntConstant( V4L2_BUF_FLAG_TIMESTAMP_COPY, "V4L2_BUF_FLAG_TIMESTAMP_COPY" );
	#endif
	#ifdef V4L2_BUF_FLAG_TSTAMP_SRC_MASK
		swigIntConstant( V4L2_BUF_FLAG_TSTAMP_SRC_MASK, "V4L2_BUF_FLAG_TSTAMP_SRC_MASK" );
	#endif
	#ifdef V4L2_BUF_FLAG_TSTAMP_SRC_EOF
		swigIntConstant( V4L2_BUF_FLAG_TSTAMP_SRC_EOF, "V4L2_BUF_FLAG_TSTAMP_SRC_EOF" );
	#endif
	#ifdef V4L2_BUF_FLAG_TSTAMP_SRC_SOE
		swigIntConstant( V4L2_BUF_FLAG_TSTAMP_SRC_SOE, "V4L2_BUF_FLAG_TSTAMP_SRC_SOE" );
	#endif
	#ifdef V4L2_BUF_FLAG_LAST
		swigIntConstant( V4L2_BUF_FLAG_LAST, "V4L2_BUF_FLAG_LAST" );
	#endif
	#ifdef V4L2_BUF_FLAG_REQUEST_FD
		swigIntConstant( V4L2_BUF_FLAG_REQUEST_FD, "V4L2_BUF_FLAG_REQUEST_FD" );
	#endif
	#ifdef V4L2_FBUF_CAP_EXTERNOVERLAY
		swigIntConstant( V4L2_FBUF_CAP_EXTERNOVERLAY, "V4L2_FBUF_CAP_EXTERNOVERLAY" );
	#endif
	#ifdef V4L2_FBUF_CAP_CHROMAKEY
		swigIntConstant( V4L2_FBUF_CAP_CHROMAKEY, "V4L2_FBUF_CAP_CHROMAKEY" );
	#endif
	#ifdef V4L2_FBUF_CAP_LIST_CLIPPING
		swigIntConstant( V4L2_FBUF_CAP_LIST_CLIPPING, "V4L2_FBUF_CAP_LIST_CLIPPING" );
	#endif
	#ifdef V4L2_FBUF_CAP_BITMAP_CLIPPING
		swigIntConstant( V4L2_FBUF_CAP_BITMAP_CLIPPING, "V4L2_FBUF_CAP_BITMAP_CLIPPING" );
	#endif
	#ifdef V4L2_FBUF_CAP_LOCAL_ALPHA
		swigIntConstant( V4L2_FBUF_CAP_LOCAL_ALPHA, "V4L2_FBUF_CAP_LOCAL_ALPHA" );
	#endif
	#ifdef V4L2_FBUF_CAP_GLOBAL_ALPHA
		swigIntConstant( V4L2_FBUF_CAP_GLOBAL_ALPHA, "V4L2_FBUF_CAP_GLOBAL_ALPHA" );
	#endif
	#ifdef V4L2_FBUF_CAP_LOCAL_INV_ALPHA
		swigIntConstant( V4L2_FBUF_CAP_LOCAL_INV_ALPHA, "V4L2_FBUF_CAP_LOCAL_INV_ALPHA" );
	#endif
	#ifdef V4L2_FBUF_CAP_SRC_CHROMAKEY
		swigIntConstant( V4L2_FBUF_CAP_SRC_CHROMAKEY, "V4L2_FBUF_CAP_SRC_CHROMAKEY" );
	#endif
	#ifdef V4L2_FBUF_FLAG_PRIMARY
		swigIntConstant( V4L2_FBUF_FLAG_PRIMARY, "V4L2_FBUF_FLAG_PRIMARY" );
	#endif
	#ifdef V4L2_FBUF_FLAG_OVERLAY
		swigIntConstant( V4L2_FBUF_FLAG_OVERLAY, "V4L2_FBUF_FLAG_OVERLAY" );
	#endif
	#ifdef V4L2_FBUF_FLAG_CHROMAKEY
		swigIntConstant( V4L2_FBUF_FLAG_CHROMAKEY, "V4L2_FBUF_FLAG_CHROMAKEY" );
	#endif
	#ifdef V4L2_FBUF_FLAG_LOCAL_ALPHA
		swigIntConstant( V4L2_FBUF_FLAG_LOCAL_ALPHA, "V4L2_FBUF_FLAG_LOCAL_ALPHA" );
	#endif
	#ifdef V4L2_FBUF_FLAG_GLOBAL_ALPHA
		swigIntConstant( V4L2_FBUF_FLAG_GLOBAL_ALPHA, "V4L2_FBUF_FLAG_GLOBAL_ALPHA" );
	#endif
	#ifdef V4L2_FBUF_FLAG_LOCAL_INV_ALPHA
		swigIntConstant( V4L2_FBUF_FLAG_LOCAL_INV_ALPHA, "V4L2_FBUF_FLAG_LOCAL_INV_ALPHA" );
	#endif
	#ifdef V4L2_FBUF_FLAG_SRC_CHROMAKEY
		swigIntConstant( V4L2_FBUF_FLAG_SRC_CHROMAKEY, "V4L2_FBUF_FLAG_SRC_CHROMAKEY" );
	#endif
	#ifdef V4L2_MODE_HIGHQUALITY
		swigIntConstant( V4L2_MODE_HIGHQUALITY, "V4L2_MODE_HIGHQUALITY" );
	#endif
	#ifdef V4L2_CAP_TIMEPERFRAME
		swigIntConstant( V4L2_CAP_TIMEPERFRAME, "V4L2_CAP_TIMEPERFRAME" );
	#endif
	#ifdef V4L2_STD_UNKNOWN
		swigIntConstant( V4L2_STD_UNKNOWN, "V4L2_STD_UNKNOWN" );
	#endif
	#ifdef V4L2_DV_PROGRESSIVE
		swigIntConstant( V4L2_DV_PROGRESSIVE, "V4L2_DV_PROGRESSIVE" );
	#endif
	#ifdef V4L2_DV_INTERLACED
		swigIntConstant( V4L2_DV_INTERLACED, "V4L2_DV_INTERLACED" );
	#endif
	#ifdef V4L2_DV_VSYNC_POS_POL
		swigIntConstant( V4L2_DV_VSYNC_POS_POL, "V4L2_DV_VSYNC_POS_POL" );
	#endif
	#ifdef V4L2_DV_HSYNC_POS_POL
		swigIntConstant( V4L2_DV_HSYNC_POS_POL, "V4L2_DV_HSYNC_POS_POL" );
	#endif
	#ifdef V4L2_DV_BT_STD_CEA861
		swigIntConstant( V4L2_DV_BT_STD_CEA861, "V4L2_DV_BT_STD_CEA861" );
	#endif
	#ifdef V4L2_DV_BT_STD_DMT
		swigIntConstant( V4L2_DV_BT_STD_DMT, "V4L2_DV_BT_STD_DMT" );
	#endif
	#ifdef V4L2_DV_BT_STD_CVT
		swigIntConstant( V4L2_DV_BT_STD_CVT, "V4L2_DV_BT_STD_CVT" );
	#endif
	#ifdef V4L2_DV_BT_STD_GTF
		swigIntConstant( V4L2_DV_BT_STD_GTF, "V4L2_DV_BT_STD_GTF" );
	#endif
	#ifdef V4L2_DV_BT_STD_SDI
		swigIntConstant( V4L2_DV_BT_STD_SDI, "V4L2_DV_BT_STD_SDI" );
	#endif
	#ifdef V4L2_DV_FL_REDUCED_BLANKING
		swigIntConstant( V4L2_DV_FL_REDUCED_BLANKING, "V4L2_DV_FL_REDUCED_BLANKING" );
	#endif
	#ifdef V4L2_DV_FL_CAN_REDUCE_FPS
		swigIntConstant( V4L2_DV_FL_CAN_REDUCE_FPS, "V4L2_DV_FL_CAN_REDUCE_FPS" );
	#endif
	#ifdef V4L2_DV_FL_REDUCED_FPS
		swigIntConstant( V4L2_DV_FL_REDUCED_FPS, "V4L2_DV_FL_REDUCED_FPS" );
	#endif
	#ifdef V4L2_DV_FL_HALF_LINE
		swigIntConstant( V4L2_DV_FL_HALF_LINE, "V4L2_DV_FL_HALF_LINE" );
	#endif
	#ifdef V4L2_DV_FL_IS_CE_VIDEO
		swigIntConstant( V4L2_DV_FL_IS_CE_VIDEO, "V4L2_DV_FL_IS_CE_VIDEO" );
	#endif
	#ifdef V4L2_DV_FL_FIRST_FIELD_EXTRA_LINE
		swigIntConstant( V4L2_DV_FL_FIRST_FIELD_EXTRA_LINE, "V4L2_DV_FL_FIRST_FIELD_EXTRA_LINE" );
	#endif
	#ifdef V4L2_DV_FL_HAS_PICTURE_ASPECT
		swigIntConstant( V4L2_DV_FL_HAS_PICTURE_ASPECT, "V4L2_DV_FL_HAS_PICTURE_ASPECT" );
	#endif
	#ifdef V4L2_DV_FL_HAS_CEA861_VIC
		swigIntConstant( V4L2_DV_FL_HAS_CEA861_VIC, "V4L2_DV_FL_HAS_CEA861_VIC" );
	#endif
	#ifdef V4L2_DV_FL_HAS_HDMI_VIC
		swigIntConstant( V4L2_DV_FL_HAS_HDMI_VIC, "V4L2_DV_FL_HAS_HDMI_VIC" );
	#endif
	#ifdef V4L2_DV_FL_CAN_DETECT_REDUCED_FPS
		swigIntConstant( V4L2_DV_FL_CAN_DETECT_REDUCED_FPS, "V4L2_DV_FL_CAN_DETECT_REDUCED_FPS" );
	#endif
	#ifdef V4L2_DV_BT_656_1120
		swigIntConstant( V4L2_DV_BT_656_1120, "V4L2_DV_BT_656_1120" );
	#endif
	#ifdef V4L2_DV_BT_CAP_INTERLACED
		swigIntConstant( V4L2_DV_BT_CAP_INTERLACED, "V4L2_DV_BT_CAP_INTERLACED" );
	#endif
	#ifdef V4L2_DV_BT_CAP_PROGRESSIVE
		swigIntConstant( V4L2_DV_BT_CAP_PROGRESSIVE, "V4L2_DV_BT_CAP_PROGRESSIVE" );
	#endif
	#ifdef V4L2_DV_BT_CAP_REDUCED_BLANKING
		swigIntConstant( V4L2_DV_BT_CAP_REDUCED_BLANKING, "V4L2_DV_BT_CAP_REDUCED_BLANKING" );
	#endif
	#ifdef V4L2_DV_BT_CAP_CUSTOM
		swigIntConstant( V4L2_DV_BT_CAP_CUSTOM, "V4L2_DV_BT_CAP_CUSTOM" );
	#endif
	#ifdef V4L2_INPUT_TYPE_TUNER
		swigIntConstant( V4L2_INPUT_TYPE_TUNER, "V4L2_INPUT_TYPE_TUNER" );
	#endif
	#ifdef V4L2_INPUT_TYPE_CAMERA
		swigIntConstant( V4L2_INPUT_TYPE_CAMERA, "V4L2_INPUT_TYPE_CAMERA" );
	#endif
	#ifdef V4L2_INPUT_TYPE_TOUCH
		swigIntConstant( V4L2_INPUT_TYPE_TOUCH, "V4L2_INPUT_TYPE_TOUCH" );
	#endif
	#ifdef V4L2_IN_ST_NO_POWER
		swigIntConstant( V4L2_IN_ST_NO_POWER, "V4L2_IN_ST_NO_POWER" );
	#endif
	#ifdef V4L2_IN_ST_NO_SIGNAL
		swigIntConstant( V4L2_IN_ST_NO_SIGNAL, "V4L2_IN_ST_NO_SIGNAL" );
	#endif
	#ifdef V4L2_IN_ST_NO_COLOR
		swigIntConstant( V4L2_IN_ST_NO_COLOR, "V4L2_IN_ST_NO_COLOR" );
	#endif
	#ifdef V4L2_IN_ST_HFLIP
		swigIntConstant( V4L2_IN_ST_HFLIP, "V4L2_IN_ST_HFLIP" );
	#endif
	#ifdef V4L2_IN_ST_VFLIP
		swigIntConstant( V4L2_IN_ST_VFLIP, "V4L2_IN_ST_VFLIP" );
	#endif
	#ifdef V4L2_IN_ST_NO_H_LOCK
		swigIntConstant( V4L2_IN_ST_NO_H_LOCK, "V4L2_IN_ST_NO_H_LOCK" );
	#endif
	#ifdef V4L2_IN_ST_COLOR_KILL
		swigIntConstant( V4L2_IN_ST_COLOR_KILL, "V4L2_IN_ST_COLOR_KILL" );
	#endif
	#ifdef V4L2_IN_ST_NO_V_LOCK
		swigIntConstant( V4L2_IN_ST_NO_V_LOCK, "V4L2_IN_ST_NO_V_LOCK" );
	#endif
	#ifdef V4L2_IN_ST_NO_STD_LOCK
		swigIntConstant( V4L2_IN_ST_NO_STD_LOCK, "V4L2_IN_ST_NO_STD_LOCK" );
	#endif
	#ifdef V4L2_IN_ST_NO_SYNC
		swigIntConstant( V4L2_IN_ST_NO_SYNC, "V4L2_IN_ST_NO_SYNC" );
	#endif
	#ifdef V4L2_IN_ST_NO_EQU
		swigIntConstant( V4L2_IN_ST_NO_EQU, "V4L2_IN_ST_NO_EQU" );
	#endif
	#ifdef V4L2_IN_ST_NO_CARRIER
		swigIntConstant( V4L2_IN_ST_NO_CARRIER, "V4L2_IN_ST_NO_CARRIER" );
	#endif
	#ifdef V4L2_IN_ST_MACROVISION
		swigIntConstant( V4L2_IN_ST_MACROVISION, "V4L2_IN_ST_MACROVISION" );
	#endif
	#ifdef V4L2_IN_ST_NO_ACCESS
		swigIntConstant( V4L2_IN_ST_NO_ACCESS, "V4L2_IN_ST_NO_ACCESS" );
	#endif
	#ifdef V4L2_IN_ST_VTR
		swigIntConstant( V4L2_IN_ST_VTR, "V4L2_IN_ST_VTR" );
	#endif
	#ifdef V4L2_IN_CAP_DV_TIMINGS
		swigIntConstant( V4L2_IN_CAP_DV_TIMINGS, "V4L2_IN_CAP_DV_TIMINGS" );
	#endif
	#ifdef V4L2_IN_CAP_CUSTOM_TIMINGS
		swigIntConstant( V4L2_IN_CAP_CUSTOM_TIMINGS, "V4L2_IN_CAP_CUSTOM_TIMINGS" );
	#endif
	#ifdef V4L2_IN_CAP_STD
		swigIntConstant( V4L2_IN_CAP_STD, "V4L2_IN_CAP_STD" );
	#endif
	#ifdef V4L2_IN_CAP_NATIVE_SIZE
		swigIntConstant( V4L2_IN_CAP_NATIVE_SIZE, "V4L2_IN_CAP_NATIVE_SIZE" );
	#endif
	#ifdef V4L2_OUTPUT_TYPE_MODULATOR
		swigIntConstant( V4L2_OUTPUT_TYPE_MODULATOR, "V4L2_OUTPUT_TYPE_MODULATOR" );
	#endif
	#ifdef V4L2_OUTPUT_TYPE_ANALOG
		swigIntConstant( V4L2_OUTPUT_TYPE_ANALOG, "V4L2_OUTPUT_TYPE_ANALOG" );
	#endif
	#ifdef V4L2_OUTPUT_TYPE_ANALOGVGAOVERLAY
		swigIntConstant( V4L2_OUTPUT_TYPE_ANALOGVGAOVERLAY, "V4L2_OUTPUT_TYPE_ANALOGVGAOVERLAY" );
	#endif
	#ifdef V4L2_OUT_CAP_DV_TIMINGS
		swigIntConstant( V4L2_OUT_CAP_DV_TIMINGS, "V4L2_OUT_CAP_DV_TIMINGS" );
	#endif
	#ifdef V4L2_OUT_CAP_CUSTOM_TIMINGS
		swigIntConstant( V4L2_OUT_CAP_CUSTOM_TIMINGS, "V4L2_OUT_CAP_CUSTOM_TIMINGS" );
	#endif
	#ifdef V4L2_OUT_CAP_STD
		swigIntConstant( V4L2_OUT_CAP_STD, "V4L2_OUT_CAP_STD" );
	#endif
	#ifdef V4L2_OUT_CAP_NATIVE_SIZE
		swigIntConstant( V4L2_OUT_CAP_NATIVE_SIZE, "V4L2_OUT_CAP_NATIVE_SIZE" );
	#endif
	#ifdef V4L2_CTRL_ID_MASK
		swigIntConstant( V4L2_CTRL_ID_MASK, "V4L2_CTRL_ID_MASK" );
	#endif
	#ifdef V4L2_CTRL_MAX_DIMS
		swigIntConstant( V4L2_CTRL_MAX_DIMS, "V4L2_CTRL_MAX_DIMS" );
	#endif
	#ifdef V4L2_CTRL_WHICH_CUR_VAL
		swigIntConstant( V4L2_CTRL_WHICH_CUR_VAL, "V4L2_CTRL_WHICH_CUR_VAL" );
	#endif
	#ifdef V4L2_CTRL_WHICH_DEF_VAL
		swigIntConstant( V4L2_CTRL_WHICH_DEF_VAL, "V4L2_CTRL_WHICH_DEF_VAL" );
	#endif
	#ifdef V4L2_CTRL_WHICH_REQUEST_VAL
		swigIntConstant( V4L2_CTRL_WHICH_REQUEST_VAL, "V4L2_CTRL_WHICH_REQUEST_VAL" );
	#endif
	#ifdef V4L2_CTRL_FLAG_DISABLED
		swigIntConstant( V4L2_CTRL_FLAG_DISABLED, "V4L2_CTRL_FLAG_DISABLED" );
	#endif
	#ifdef V4L2_CTRL_FLAG_GRABBED
		swigIntConstant( V4L2_CTRL_FLAG_GRABBED, "V4L2_CTRL_FLAG_GRABBED" );
	#endif
	#ifdef V4L2_CTRL_FLAG_READ_ONLY
		swigIntConstant( V4L2_CTRL_FLAG_READ_ONLY, "V4L2_CTRL_FLAG_READ_ONLY" );
	#endif
	#ifdef V4L2_CTRL_FLAG_UPDATE
		swigIntConstant( V4L2_CTRL_FLAG_UPDATE, "V4L2_CTRL_FLAG_UPDATE" );
	#endif
	#ifdef V4L2_CTRL_FLAG_INACTIVE
		swigIntConstant( V4L2_CTRL_FLAG_INACTIVE, "V4L2_CTRL_FLAG_INACTIVE" );
	#endif
	#ifdef V4L2_CTRL_FLAG_SLIDER
		swigIntConstant( V4L2_CTRL_FLAG_SLIDER, "V4L2_CTRL_FLAG_SLIDER" );
	#endif
	#ifdef V4L2_CTRL_FLAG_WRITE_ONLY
		swigIntConstant( V4L2_CTRL_FLAG_WRITE_ONLY, "V4L2_CTRL_FLAG_WRITE_ONLY" );
	#endif
	#ifdef V4L2_CTRL_FLAG_VOLATILE
		swigIntConstant( V4L2_CTRL_FLAG_VOLATILE, "V4L2_CTRL_FLAG_VOLATILE" );
	#endif
	#ifdef V4L2_CTRL_FLAG_HAS_PAYLOAD
		swigIntConstant( V4L2_CTRL_FLAG_HAS_PAYLOAD, "V4L2_CTRL_FLAG_HAS_PAYLOAD" );
	#endif
	#ifdef V4L2_CTRL_FLAG_EXECUTE_ON_WRITE
		swigIntConstant( V4L2_CTRL_FLAG_EXECUTE_ON_WRITE, "V4L2_CTRL_FLAG_EXECUTE_ON_WRITE" );
	#endif
	#ifdef V4L2_CTRL_FLAG_MODIFY_LAYOUT
		swigIntConstant( V4L2_CTRL_FLAG_MODIFY_LAYOUT, "V4L2_CTRL_FLAG_MODIFY_LAYOUT" );
	#endif
	#ifdef V4L2_CTRL_FLAG_NEXT_CTRL
		swigIntConstant( V4L2_CTRL_FLAG_NEXT_CTRL, "V4L2_CTRL_FLAG_NEXT_CTRL" );
	#endif
	#ifdef V4L2_CTRL_FLAG_NEXT_COMPOUND
		swigIntConstant( V4L2_CTRL_FLAG_NEXT_COMPOUND, "V4L2_CTRL_FLAG_NEXT_COMPOUND" );
	#endif
	#ifdef V4L2_CID_MAX_CTRLS
		swigIntConstant( V4L2_CID_MAX_CTRLS, "V4L2_CID_MAX_CTRLS" );
	#endif
	#ifdef V4L2_CID_PRIVATE_BASE
		swigIntConstant( V4L2_CID_PRIVATE_BASE, "V4L2_CID_PRIVATE_BASE" );
	#endif
	#ifdef V4L2_TUNER_CAP_LOW
		swigIntConstant( V4L2_TUNER_CAP_LOW, "V4L2_TUNER_CAP_LOW" );
	#endif
	#ifdef V4L2_TUNER_CAP_NORM
		swigIntConstant( V4L2_TUNER_CAP_NORM, "V4L2_TUNER_CAP_NORM" );
	#endif
	#ifdef V4L2_TUNER_CAP_HWSEEK_BOUNDED
		swigIntConstant( V4L2_TUNER_CAP_HWSEEK_BOUNDED, "V4L2_TUNER_CAP_HWSEEK_BOUNDED" );
	#endif
	#ifdef V4L2_TUNER_CAP_HWSEEK_WRAP
		swigIntConstant( V4L2_TUNER_CAP_HWSEEK_WRAP, "V4L2_TUNER_CAP_HWSEEK_WRAP" );
	#endif
	#ifdef V4L2_TUNER_CAP_STEREO
		swigIntConstant( V4L2_TUNER_CAP_STEREO, "V4L2_TUNER_CAP_STEREO" );
	#endif
	#ifdef V4L2_TUNER_CAP_LANG2
		swigIntConstant( V4L2_TUNER_CAP_LANG2, "V4L2_TUNER_CAP_LANG2" );
	#endif
	#ifdef V4L2_TUNER_CAP_SAP
		swigIntConstant( V4L2_TUNER_CAP_SAP, "V4L2_TUNER_CAP_SAP" );
	#endif
	#ifdef V4L2_TUNER_CAP_LANG1
		swigIntConstant( V4L2_TUNER_CAP_LANG1, "V4L2_TUNER_CAP_LANG1" );
	#endif
	#ifdef V4L2_TUNER_CAP_RDS
		swigIntConstant( V4L2_TUNER_CAP_RDS, "V4L2_TUNER_CAP_RDS" );
	#endif
	#ifdef V4L2_TUNER_CAP_RDS_BLOCK_IO
		swigIntConstant( V4L2_TUNER_CAP_RDS_BLOCK_IO, "V4L2_TUNER_CAP_RDS_BLOCK_IO" );
	#endif
	#ifdef V4L2_TUNER_CAP_RDS_CONTROLS
		swigIntConstant( V4L2_TUNER_CAP_RDS_CONTROLS, "V4L2_TUNER_CAP_RDS_CONTROLS" );
	#endif
	#ifdef V4L2_TUNER_CAP_FREQ_BANDS
		swigIntConstant( V4L2_TUNER_CAP_FREQ_BANDS, "V4L2_TUNER_CAP_FREQ_BANDS" );
	#endif
	#ifdef V4L2_TUNER_CAP_HWSEEK_PROG_LIM
		swigIntConstant( V4L2_TUNER_CAP_HWSEEK_PROG_LIM, "V4L2_TUNER_CAP_HWSEEK_PROG_LIM" );
	#endif
	#ifdef V4L2_TUNER_CAP_1HZ
		swigIntConstant( V4L2_TUNER_CAP_1HZ, "V4L2_TUNER_CAP_1HZ" );
	#endif
	#ifdef V4L2_TUNER_SUB_MONO
		swigIntConstant( V4L2_TUNER_SUB_MONO, "V4L2_TUNER_SUB_MONO" );
	#endif
	#ifdef V4L2_TUNER_SUB_STEREO
		swigIntConstant( V4L2_TUNER_SUB_STEREO, "V4L2_TUNER_SUB_STEREO" );
	#endif
	#ifdef V4L2_TUNER_SUB_LANG2
		swigIntConstant( V4L2_TUNER_SUB_LANG2, "V4L2_TUNER_SUB_LANG2" );
	#endif
	#ifdef V4L2_TUNER_SUB_SAP
		swigIntConstant( V4L2_TUNER_SUB_SAP, "V4L2_TUNER_SUB_SAP" );
	#endif
	#ifdef V4L2_TUNER_SUB_LANG1
		swigIntConstant( V4L2_TUNER_SUB_LANG1, "V4L2_TUNER_SUB_LANG1" );
	#endif
	#ifdef V4L2_TUNER_SUB_RDS
		swigIntConstant( V4L2_TUNER_SUB_RDS, "V4L2_TUNER_SUB_RDS" );
	#endif
	#ifdef V4L2_TUNER_MODE_MONO
		swigIntConstant( V4L2_TUNER_MODE_MONO, "V4L2_TUNER_MODE_MONO" );
	#endif
	#ifdef V4L2_TUNER_MODE_STEREO
		swigIntConstant( V4L2_TUNER_MODE_STEREO, "V4L2_TUNER_MODE_STEREO" );
	#endif
	#ifdef V4L2_TUNER_MODE_LANG2
		swigIntConstant( V4L2_TUNER_MODE_LANG2, "V4L2_TUNER_MODE_LANG2" );
	#endif
	#ifdef V4L2_TUNER_MODE_SAP
		swigIntConstant( V4L2_TUNER_MODE_SAP, "V4L2_TUNER_MODE_SAP" );
	#endif
	#ifdef V4L2_TUNER_MODE_LANG1
		swigIntConstant( V4L2_TUNER_MODE_LANG1, "V4L2_TUNER_MODE_LANG1" );
	#endif
	#ifdef V4L2_TUNER_MODE_LANG1_LANG2
		swigIntConstant( V4L2_TUNER_MODE_LANG1_LANG2, "V4L2_TUNER_MODE_LANG1_LANG2" );
	#endif
	#ifdef V4L2_BAND_MODULATION_VSB
		swigIntConstant( V4L2_BAND_MODULATION_VSB, "V4L2_BAND_MODULATION_VSB" );
	#endif
	#ifdef V4L2_BAND_MODULATION_FM
		swigIntConstant( V4L2_BAND_MODULATION_FM, "V4L2_BAND_MODULATION_FM" );
	#endif
	#ifdef V4L2_BAND_MODULATION_AM
		swigIntConstant( V4L2_BAND_MODULATION_AM, "V4L2_BAND_MODULATION_AM" );
	#endif
	#ifdef V4L2_RDS_BLOCK_MSK
		swigIntConstant( V4L2_RDS_BLOCK_MSK, "V4L2_RDS_BLOCK_MSK" );
	#endif
	#ifdef V4L2_RDS_BLOCK_A
		swigIntConstant( V4L2_RDS_BLOCK_A, "V4L2_RDS_BLOCK_A" );
	#endif
	#ifdef V4L2_RDS_BLOCK_B
		swigIntConstant( V4L2_RDS_BLOCK_B, "V4L2_RDS_BLOCK_B" );
	#endif
	#ifdef V4L2_RDS_BLOCK_C
		swigIntConstant( V4L2_RDS_BLOCK_C, "V4L2_RDS_BLOCK_C" );
	#endif
	#ifdef V4L2_RDS_BLOCK_D
		swigIntConstant( V4L2_RDS_BLOCK_D, "V4L2_RDS_BLOCK_D" );
	#endif
	#ifdef V4L2_RDS_BLOCK_C_ALT
		swigIntConstant( V4L2_RDS_BLOCK_C_ALT, "V4L2_RDS_BLOCK_C_ALT" );
	#endif
	#ifdef V4L2_RDS_BLOCK_INVALID
		swigIntConstant( V4L2_RDS_BLOCK_INVALID, "V4L2_RDS_BLOCK_INVALID" );
	#endif
	#ifdef V4L2_RDS_BLOCK_CORRECTED
		swigIntConstant( V4L2_RDS_BLOCK_CORRECTED, "V4L2_RDS_BLOCK_CORRECTED" );
	#endif
	#ifdef V4L2_RDS_BLOCK_ERROR
		swigIntConstant( V4L2_RDS_BLOCK_ERROR, "V4L2_RDS_BLOCK_ERROR" );
	#endif
	#ifdef V4L2_AUDCAP_STEREO
		swigIntConstant( V4L2_AUDCAP_STEREO, "V4L2_AUDCAP_STEREO" );
	#endif
	#ifdef V4L2_AUDCAP_AVL
		swigIntConstant( V4L2_AUDCAP_AVL, "V4L2_AUDCAP_AVL" );
	#endif
	#ifdef V4L2_AUDMODE_AVL
		swigIntConstant( V4L2_AUDMODE_AVL, "V4L2_AUDMODE_AVL" );
	#endif
	#ifdef V4L2_ENC_IDX_FRAME_I
		swigIntConstant( V4L2_ENC_IDX_FRAME_I, "V4L2_ENC_IDX_FRAME_I" );
	#endif
	#ifdef V4L2_ENC_IDX_FRAME_P
		swigIntConstant( V4L2_ENC_IDX_FRAME_P, "V4L2_ENC_IDX_FRAME_P" );
	#endif
	#ifdef V4L2_ENC_IDX_FRAME_B
		swigIntConstant( V4L2_ENC_IDX_FRAME_B, "V4L2_ENC_IDX_FRAME_B" );
	#endif
	#ifdef V4L2_ENC_IDX_FRAME_MASK
		swigIntConstant( V4L2_ENC_IDX_FRAME_MASK, "V4L2_ENC_IDX_FRAME_MASK" );
	#endif
	#ifdef V4L2_ENC_IDX_ENTRIES
		swigIntConstant( V4L2_ENC_IDX_ENTRIES, "V4L2_ENC_IDX_ENTRIES" );
	#endif
	#ifdef V4L2_ENC_CMD_START
		swigIntConstant( V4L2_ENC_CMD_START, "V4L2_ENC_CMD_START" );
	#endif
	#ifdef V4L2_ENC_CMD_STOP
		swigIntConstant( V4L2_ENC_CMD_STOP, "V4L2_ENC_CMD_STOP" );
	#endif
	#ifdef V4L2_ENC_CMD_PAUSE
		swigIntConstant( V4L2_ENC_CMD_PAUSE, "V4L2_ENC_CMD_PAUSE" );
	#endif
	#ifdef V4L2_ENC_CMD_RESUME
		swigIntConstant( V4L2_ENC_CMD_RESUME, "V4L2_ENC_CMD_RESUME" );
	#endif
	#ifdef V4L2_ENC_CMD_STOP_AT_GOP_END
		swigIntConstant( V4L2_ENC_CMD_STOP_AT_GOP_END, "V4L2_ENC_CMD_STOP_AT_GOP_END" );
	#endif
	#ifdef V4L2_DEC_CMD_START
		swigIntConstant( V4L2_DEC_CMD_START, "V4L2_DEC_CMD_START" );
	#endif
	#ifdef V4L2_DEC_CMD_STOP
		swigIntConstant( V4L2_DEC_CMD_STOP, "V4L2_DEC_CMD_STOP" );
	#endif
	#ifdef V4L2_DEC_CMD_PAUSE
		swigIntConstant( V4L2_DEC_CMD_PAUSE, "V4L2_DEC_CMD_PAUSE" );
	#endif
	#ifdef V4L2_DEC_CMD_RESUME
		swigIntConstant( V4L2_DEC_CMD_RESUME, "V4L2_DEC_CMD_RESUME" );
	#endif
	#ifdef V4L2_DEC_CMD_FLUSH
		swigIntConstant( V4L2_DEC_CMD_FLUSH, "V4L2_DEC_CMD_FLUSH" );
	#endif
	#ifdef V4L2_DEC_CMD_START_MUTE_AUDIO
		swigIntConstant( V4L2_DEC_CMD_START_MUTE_AUDIO, "V4L2_DEC_CMD_START_MUTE_AUDIO" );
	#endif
	#ifdef V4L2_DEC_CMD_PAUSE_TO_BLACK
		swigIntConstant( V4L2_DEC_CMD_PAUSE_TO_BLACK, "V4L2_DEC_CMD_PAUSE_TO_BLACK" );
	#endif
	#ifdef V4L2_DEC_CMD_STOP_TO_BLACK
		swigIntConstant( V4L2_DEC_CMD_STOP_TO_BLACK, "V4L2_DEC_CMD_STOP_TO_BLACK" );
	#endif
	#ifdef V4L2_DEC_CMD_STOP_IMMEDIATELY
		swigIntConstant( V4L2_DEC_CMD_STOP_IMMEDIATELY, "V4L2_DEC_CMD_STOP_IMMEDIATELY" );
	#endif
	#ifdef V4L2_DEC_START_FMT_NONE
		swigIntConstant( V4L2_DEC_START_FMT_NONE, "V4L2_DEC_START_FMT_NONE" );
	#endif
	#ifdef V4L2_DEC_START_FMT_GOP
		swigIntConstant( V4L2_DEC_START_FMT_GOP, "V4L2_DEC_START_FMT_GOP" );
	#endif
	#ifdef V4L2_VBI_UNSYNC
		swigIntConstant( V4L2_VBI_UNSYNC, "V4L2_VBI_UNSYNC" );
	#endif
	#ifdef V4L2_VBI_INTERLACED
		swigIntConstant( V4L2_VBI_INTERLACED, "V4L2_VBI_INTERLACED" );
	#endif
	#ifdef V4L2_VBI_ITU_525_F1_START
		swigIntConstant( V4L2_VBI_ITU_525_F1_START, "V4L2_VBI_ITU_525_F1_START" );
	#endif
	#ifdef V4L2_VBI_ITU_525_F2_START
		swigIntConstant( V4L2_VBI_ITU_525_F2_START, "V4L2_VBI_ITU_525_F2_START" );
	#endif
	#ifdef V4L2_VBI_ITU_625_F1_START
		swigIntConstant( V4L2_VBI_ITU_625_F1_START, "V4L2_VBI_ITU_625_F1_START" );
	#endif
	#ifdef V4L2_VBI_ITU_625_F2_START
		swigIntConstant( V4L2_VBI_ITU_625_F2_START, "V4L2_VBI_ITU_625_F2_START" );
	#endif
	#ifdef V4L2_SLICED_TELETEXT_B
		swigIntConstant( V4L2_SLICED_TELETEXT_B, "V4L2_SLICED_TELETEXT_B" );
	#endif
	#ifdef V4L2_SLICED_VPS
		swigIntConstant( V4L2_SLICED_VPS, "V4L2_SLICED_VPS" );
	#endif
	#ifdef V4L2_SLICED_CAPTION_525
		swigIntConstant( V4L2_SLICED_CAPTION_525, "V4L2_SLICED_CAPTION_525" );
	#endif
	#ifdef V4L2_SLICED_WSS_625
		swigIntConstant( V4L2_SLICED_WSS_625, "V4L2_SLICED_WSS_625" );
	#endif
	#ifdef V4L2_SLICED_VBI_525
		swigIntConstant( V4L2_SLICED_VBI_525, "V4L2_SLICED_VBI_525" );
	#endif
	#ifdef V4L2_SLICED_VBI_625
		swigIntConstant( V4L2_SLICED_VBI_625, "V4L2_SLICED_VBI_625" );
	#endif
	#ifdef V4L2_MPEG_VBI_IVTV_TELETEXT_B
		swigIntConstant( V4L2_MPEG_VBI_IVTV_TELETEXT_B, "V4L2_MPEG_VBI_IVTV_TELETEXT_B" );
	#endif
	#ifdef V4L2_MPEG_VBI_IVTV_CAPTION_525
		swigIntConstant( V4L2_MPEG_VBI_IVTV_CAPTION_525, "V4L2_MPEG_VBI_IVTV_CAPTION_525" );
	#endif
	#ifdef V4L2_MPEG_VBI_IVTV_WSS_625
		swigIntConstant( V4L2_MPEG_VBI_IVTV_WSS_625, "V4L2_MPEG_VBI_IVTV_WSS_625" );
	#endif
	#ifdef V4L2_MPEG_VBI_IVTV_VPS
		swigIntConstant( V4L2_MPEG_VBI_IVTV_VPS, "V4L2_MPEG_VBI_IVTV_VPS" );
	#endif
	#ifdef V4L2_EVENT_ALL
		swigIntConstant( V4L2_EVENT_ALL, "V4L2_EVENT_ALL" );
	#endif
	#ifdef V4L2_EVENT_VSYNC
		swigIntConstant( V4L2_EVENT_VSYNC, "V4L2_EVENT_VSYNC" );
	#endif
	#ifdef V4L2_EVENT_EOS
		swigIntConstant( V4L2_EVENT_EOS, "V4L2_EVENT_EOS" );
	#endif
	#ifdef V4L2_EVENT_CTRL
		swigIntConstant( V4L2_EVENT_CTRL, "V4L2_EVENT_CTRL" );
	#endif
	#ifdef V4L2_EVENT_FRAME_SYNC
		swigIntConstant( V4L2_EVENT_FRAME_SYNC, "V4L2_EVENT_FRAME_SYNC" );
	#endif
	#ifdef V4L2_EVENT_SOURCE_CHANGE
		swigIntConstant( V4L2_EVENT_SOURCE_CHANGE, "V4L2_EVENT_SOURCE_CHANGE" );
	#endif
	#ifdef V4L2_EVENT_MOTION_DET
		swigIntConstant( V4L2_EVENT_MOTION_DET, "V4L2_EVENT_MOTION_DET" );
	#endif
	#ifdef V4L2_EVENT_PRIVATE_START
		swigIntConstant( V4L2_EVENT_PRIVATE_START, "V4L2_EVENT_PRIVATE_START" );
	#endif
	#ifdef V4L2_EVENT_CTRL_CH_VALUE
		swigIntConstant( V4L2_EVENT_CTRL_CH_VALUE, "V4L2_EVENT_CTRL_CH_VALUE" );
	#endif
	#ifdef V4L2_EVENT_CTRL_CH_FLAGS
		swigIntConstant( V4L2_EVENT_CTRL_CH_FLAGS, "V4L2_EVENT_CTRL_CH_FLAGS" );
	#endif
	#ifdef V4L2_EVENT_CTRL_CH_RANGE
		swigIntConstant( V4L2_EVENT_CTRL_CH_RANGE, "V4L2_EVENT_CTRL_CH_RANGE" );
	#endif
	#ifdef V4L2_EVENT_SRC_CH_RESOLUTION
		swigIntConstant( V4L2_EVENT_SRC_CH_RESOLUTION, "V4L2_EVENT_SRC_CH_RESOLUTION" );
	#endif
	#ifdef V4L2_EVENT_MD_FL_HAVE_FRAME_SEQ
		swigIntConstant( V4L2_EVENT_MD_FL_HAVE_FRAME_SEQ, "V4L2_EVENT_MD_FL_HAVE_FRAME_SEQ" );
	#endif
	#ifdef V4L2_EVENT_SUB_FL_SEND_INITIAL
		swigIntConstant( V4L2_EVENT_SUB_FL_SEND_INITIAL, "V4L2_EVENT_SUB_FL_SEND_INITIAL" );
	#endif
	#ifdef V4L2_EVENT_SUB_FL_ALLOW_FEEDBACK
		swigIntConstant( V4L2_EVENT_SUB_FL_ALLOW_FEEDBACK, "V4L2_EVENT_SUB_FL_ALLOW_FEEDBACK" );
	#endif
	#ifdef V4L2_CHIP_MATCH_BRIDGE
		swigIntConstant( V4L2_CHIP_MATCH_BRIDGE, "V4L2_CHIP_MATCH_BRIDGE" );
	#endif
	#ifdef V4L2_CHIP_MATCH_SUBDEV
		swigIntConstant( V4L2_CHIP_MATCH_SUBDEV, "V4L2_CHIP_MATCH_SUBDEV" );
	#endif
	#ifdef V4L2_CHIP_MATCH_HOST
		swigIntConstant( V4L2_CHIP_MATCH_HOST, "V4L2_CHIP_MATCH_HOST" );
	#endif
	#ifdef V4L2_CHIP_MATCH_I2C_DRIVER
		swigIntConstant( V4L2_CHIP_MATCH_I2C_DRIVER, "V4L2_CHIP_MATCH_I2C_DRIVER" );
	#endif
	#ifdef V4L2_CHIP_MATCH_I2C_ADDR
		swigIntConstant( V4L2_CHIP_MATCH_I2C_ADDR, "V4L2_CHIP_MATCH_I2C_ADDR" );
	#endif
	#ifdef V4L2_CHIP_MATCH_AC97
		swigIntConstant( V4L2_CHIP_MATCH_AC97, "V4L2_CHIP_MATCH_AC97" );
	#endif
	#ifdef V4L2_CHIP_FL_READABLE
		swigIntConstant( V4L2_CHIP_FL_READABLE, "V4L2_CHIP_FL_READABLE" );
	#endif
	#ifdef V4L2_CHIP_FL_WRITABLE
		swigIntConstant( V4L2_CHIP_FL_WRITABLE, "V4L2_CHIP_FL_WRITABLE" );
	#endif
	#ifdef BASE_VIDIOC_PRIVATE
		swigIntConstant( BASE_VIDIOC_PRIVATE, "BASE_VIDIOC_PRIVATE" );
	#endif
	#ifdef V4L2_SEL_TGT_CROP
		swigIntConstant( V4L2_SEL_TGT_CROP, "V4L2_SEL_TGT_CROP" );
	#endif
	#ifdef V4L2_SEL_TGT_CROP_DEFAULT
		swigIntConstant( V4L2_SEL_TGT_CROP_DEFAULT, "V4L2_SEL_TGT_CROP_DEFAULT" );
	#endif
	#ifdef V4L2_SEL_TGT_CROP_BOUNDS
		swigIntConstant( V4L2_SEL_TGT_CROP_BOUNDS, "V4L2_SEL_TGT_CROP_BOUNDS" );
	#endif
	#ifdef V4L2_SEL_TGT_NATIVE_SIZE
		swigIntConstant( V4L2_SEL_TGT_NATIVE_SIZE, "V4L2_SEL_TGT_NATIVE_SIZE" );
	#endif
	#ifdef V4L2_SEL_TGT_COMPOSE
		swigIntConstant( V4L2_SEL_TGT_COMPOSE, "V4L2_SEL_TGT_COMPOSE" );
	#endif
	#ifdef V4L2_SEL_TGT_COMPOSE_DEFAULT
		swigIntConstant( V4L2_SEL_TGT_COMPOSE_DEFAULT, "V4L2_SEL_TGT_COMPOSE_DEFAULT" );
	#endif
	#ifdef V4L2_SEL_TGT_COMPOSE_BOUNDS
		swigIntConstant( V4L2_SEL_TGT_COMPOSE_BOUNDS, "V4L2_SEL_TGT_COMPOSE_BOUNDS" );
	#endif
	#ifdef V4L2_SEL_TGT_COMPOSE_PADDED
		swigIntConstant( V4L2_SEL_TGT_COMPOSE_PADDED, "V4L2_SEL_TGT_COMPOSE_PADDED" );
	#endif
	#ifdef V4L2_SEL_FLAG_GE
		swigIntConstant( V4L2_SEL_FLAG_GE, "V4L2_SEL_FLAG_GE" );
	#endif
	#ifdef V4L2_SEL_FLAG_LE
		swigIntConstant( V4L2_SEL_FLAG_LE, "V4L2_SEL_FLAG_LE" );
	#endif
	#ifdef V4L2_SEL_FLAG_KEEP_CONFIG
		swigIntConstant( V4L2_SEL_FLAG_KEEP_CONFIG, "V4L2_SEL_FLAG_KEEP_CONFIG" );
	#endif
	#ifdef V4L2_SEL_TGT_CROP_ACTIVE
		swigIntConstant( V4L2_SEL_TGT_CROP_ACTIVE, "V4L2_SEL_TGT_CROP_ACTIVE" );
	#endif
	#ifdef V4L2_SEL_TGT_COMPOSE_ACTIVE
		swigIntConstant( V4L2_SEL_TGT_COMPOSE_ACTIVE, "V4L2_SEL_TGT_COMPOSE_ACTIVE" );
	#endif
	#ifdef V4L2_SUBDEV_SEL_TGT_CROP_ACTUAL
		swigIntConstant( V4L2_SUBDEV_SEL_TGT_CROP_ACTUAL, "V4L2_SUBDEV_SEL_TGT_CROP_ACTUAL" );
	#endif
	#ifdef V4L2_SUBDEV_SEL_TGT_COMPOSE_ACTUAL
		swigIntConstant( V4L2_SUBDEV_SEL_TGT_COMPOSE_ACTUAL, "V4L2_SUBDEV_SEL_TGT_COMPOSE_ACTUAL" );
	#endif
	#ifdef V4L2_SUBDEV_SEL_TGT_CROP_BOUNDS
		swigIntConstant( V4L2_SUBDEV_SEL_TGT_CROP_BOUNDS, "V4L2_SUBDEV_SEL_TGT_CROP_BOUNDS" );
	#endif
	#ifdef V4L2_SUBDEV_SEL_TGT_COMPOSE_BOUNDS
		swigIntConstant( V4L2_SUBDEV_SEL_TGT_COMPOSE_BOUNDS, "V4L2_SUBDEV_SEL_TGT_COMPOSE_BOUNDS" );
	#endif
	#ifdef V4L2_SUBDEV_SEL_FLAG_SIZE_GE
		swigIntConstant( V4L2_SUBDEV_SEL_FLAG_SIZE_GE, "V4L2_SUBDEV_SEL_FLAG_SIZE_GE" );
	#endif
	#ifdef V4L2_SUBDEV_SEL_FLAG_SIZE_LE
		swigIntConstant( V4L2_SUBDEV_SEL_FLAG_SIZE_LE, "V4L2_SUBDEV_SEL_FLAG_SIZE_LE" );
	#endif
	#ifdef V4L2_SUBDEV_SEL_FLAG_KEEP_CONFIG
		swigIntConstant( V4L2_SUBDEV_SEL_FLAG_KEEP_CONFIG, "V4L2_SUBDEV_SEL_FLAG_KEEP_CONFIG" );
	#endif
	#ifdef V4L2_CTRL_CLASS_USER
		swigIntConstant( V4L2_CTRL_CLASS_USER, "V4L2_CTRL_CLASS_USER" );
	#endif
	#ifdef V4L2_CTRL_CLASS_CODEC
		swigIntConstant( V4L2_CTRL_CLASS_CODEC, "V4L2_CTRL_CLASS_CODEC" );
	#endif
	#ifdef V4L2_CTRL_CLASS_CAMERA
		swigIntConstant( V4L2_CTRL_CLASS_CAMERA, "V4L2_CTRL_CLASS_CAMERA" );
	#endif
	#ifdef V4L2_CTRL_CLASS_FM_TX
		swigIntConstant( V4L2_CTRL_CLASS_FM_TX, "V4L2_CTRL_CLASS_FM_TX" );
	#endif
	#ifdef V4L2_CTRL_CLASS_FLASH
		swigIntConstant( V4L2_CTRL_CLASS_FLASH, "V4L2_CTRL_CLASS_FLASH" );
	#endif
	#ifdef V4L2_CTRL_CLASS_JPEG
		swigIntConstant( V4L2_CTRL_CLASS_JPEG, "V4L2_CTRL_CLASS_JPEG" );
	#endif
	#ifdef V4L2_CTRL_CLASS_IMAGE_SOURCE
		swigIntConstant( V4L2_CTRL_CLASS_IMAGE_SOURCE, "V4L2_CTRL_CLASS_IMAGE_SOURCE" );
	#endif
	#ifdef V4L2_CTRL_CLASS_IMAGE_PROC
		swigIntConstant( V4L2_CTRL_CLASS_IMAGE_PROC, "V4L2_CTRL_CLASS_IMAGE_PROC" );
	#endif
	#ifdef V4L2_CTRL_CLASS_DV
		swigIntConstant( V4L2_CTRL_CLASS_DV, "V4L2_CTRL_CLASS_DV" );
	#endif
	#ifdef V4L2_CTRL_CLASS_FM_RX
		swigIntConstant( V4L2_CTRL_CLASS_FM_RX, "V4L2_CTRL_CLASS_FM_RX" );
	#endif
	#ifdef V4L2_CTRL_CLASS_RF_TUNER
		swigIntConstant( V4L2_CTRL_CLASS_RF_TUNER, "V4L2_CTRL_CLASS_RF_TUNER" );
	#endif
	#ifdef V4L2_CTRL_CLASS_DETECT
		swigIntConstant( V4L2_CTRL_CLASS_DETECT, "V4L2_CTRL_CLASS_DETECT" );
	#endif
	#ifdef V4L2_CTRL_CLASS_CODEC_STATELESS
		swigIntConstant( V4L2_CTRL_CLASS_CODEC_STATELESS, "V4L2_CTRL_CLASS_CODEC_STATELESS" );
	#endif
	#ifdef V4L2_CTRL_CLASS_COLORIMETRY
		swigIntConstant( V4L2_CTRL_CLASS_COLORIMETRY, "V4L2_CTRL_CLASS_COLORIMETRY" );
	#endif
	#ifdef V4L2_CID_BASE
		swigIntConstant( V4L2_CID_BASE, "V4L2_CID_BASE" );
	#endif
	#ifdef V4L2_CID_USER_BASE
		swigIntConstant( V4L2_CID_USER_BASE, "V4L2_CID_USER_BASE" );
	#endif
	#ifdef V4L2_CID_USER_CLASS
		swigIntConstant( V4L2_CID_USER_CLASS, "V4L2_CID_USER_CLASS" );
	#endif
	#ifdef V4L2_CID_BRIGHTNESS
		swigIntConstant( V4L2_CID_BRIGHTNESS, "V4L2_CID_BRIGHTNESS" );
	#endif
	#ifdef V4L2_CID_CONTRAST
		swigIntConstant( V4L2_CID_CONTRAST, "V4L2_CID_CONTRAST" );
	#endif
	#ifdef V4L2_CID_SATURATION
		swigIntConstant( V4L2_CID_SATURATION, "V4L2_CID_SATURATION" );
	#endif
	#ifdef V4L2_CID_HUE
		swigIntConstant( V4L2_CID_HUE, "V4L2_CID_HUE" );
	#endif
	#ifdef V4L2_CID_AUDIO_VOLUME
		swigIntConstant( V4L2_CID_AUDIO_VOLUME, "V4L2_CID_AUDIO_VOLUME" );
	#endif
	#ifdef V4L2_CID_AUDIO_BALANCE
		swigIntConstant( V4L2_CID_AUDIO_BALANCE, "V4L2_CID_AUDIO_BALANCE" );
	#endif
	#ifdef V4L2_CID_AUDIO_BASS
		swigIntConstant( V4L2_CID_AUDIO_BASS, "V4L2_CID_AUDIO_BASS" );
	#endif
	#ifdef V4L2_CID_AUDIO_TREBLE
		swigIntConstant( V4L2_CID_AUDIO_TREBLE, "V4L2_CID_AUDIO_TREBLE" );
	#endif
	#ifdef V4L2_CID_AUDIO_MUTE
		swigIntConstant( V4L2_CID_AUDIO_MUTE, "V4L2_CID_AUDIO_MUTE" );
	#endif
	#ifdef V4L2_CID_AUDIO_LOUDNESS
		swigIntConstant( V4L2_CID_AUDIO_LOUDNESS, "V4L2_CID_AUDIO_LOUDNESS" );
	#endif
	#ifdef V4L2_CID_BLACK_LEVEL
		swigIntConstant( V4L2_CID_BLACK_LEVEL, "V4L2_CID_BLACK_LEVEL" );
	#endif
	#ifdef V4L2_CID_AUTO_WHITE_BALANCE
		swigIntConstant( V4L2_CID_AUTO_WHITE_BALANCE, "V4L2_CID_AUTO_WHITE_BALANCE" );
	#endif
	#ifdef V4L2_CID_DO_WHITE_BALANCE
		swigIntConstant( V4L2_CID_DO_WHITE_BALANCE, "V4L2_CID_DO_WHITE_BALANCE" );
	#endif
	#ifdef V4L2_CID_RED_BALANCE
		swigIntConstant( V4L2_CID_RED_BALANCE, "V4L2_CID_RED_BALANCE" );
	#endif
	#ifdef V4L2_CID_BLUE_BALANCE
		swigIntConstant( V4L2_CID_BLUE_BALANCE, "V4L2_CID_BLUE_BALANCE" );
	#endif
	#ifdef V4L2_CID_GAMMA
		swigIntConstant( V4L2_CID_GAMMA, "V4L2_CID_GAMMA" );
	#endif
	#ifdef V4L2_CID_WHITENESS
		swigIntConstant( V4L2_CID_WHITENESS, "V4L2_CID_WHITENESS" );
	#endif
	#ifdef V4L2_CID_EXPOSURE
		swigIntConstant( V4L2_CID_EXPOSURE, "V4L2_CID_EXPOSURE" );
	#endif
	#ifdef V4L2_CID_AUTOGAIN
		swigIntConstant( V4L2_CID_AUTOGAIN, "V4L2_CID_AUTOGAIN" );
	#endif
	#ifdef V4L2_CID_GAIN
		swigIntConstant( V4L2_CID_GAIN, "V4L2_CID_GAIN" );
	#endif
	#ifdef V4L2_CID_HFLIP
		swigIntConstant( V4L2_CID_HFLIP, "V4L2_CID_HFLIP" );
	#endif
	#ifdef V4L2_CID_VFLIP
		swigIntConstant( V4L2_CID_VFLIP, "V4L2_CID_VFLIP" );
	#endif
	#ifdef V4L2_CID_POWER_LINE_FREQUENCY
		swigIntConstant( V4L2_CID_POWER_LINE_FREQUENCY, "V4L2_CID_POWER_LINE_FREQUENCY" );
	#endif
	#ifdef V4L2_CID_HUE_AUTO
		swigIntConstant( V4L2_CID_HUE_AUTO, "V4L2_CID_HUE_AUTO" );
	#endif
	#ifdef V4L2_CID_WHITE_BALANCE_TEMPERATURE
		swigIntConstant( V4L2_CID_WHITE_BALANCE_TEMPERATURE, "V4L2_CID_WHITE_BALANCE_TEMPERATURE" );
	#endif
	#ifdef V4L2_CID_SHARPNESS
		swigIntConstant( V4L2_CID_SHARPNESS, "V4L2_CID_SHARPNESS" );
	#endif
	#ifdef V4L2_CID_BACKLIGHT_COMPENSATION
		swigIntConstant( V4L2_CID_BACKLIGHT_COMPENSATION, "V4L2_CID_BACKLIGHT_COMPENSATION" );
	#endif
	#ifdef V4L2_CID_CHROMA_AGC
		swigIntConstant( V4L2_CID_CHROMA_AGC, "V4L2_CID_CHROMA_AGC" );
	#endif
	#ifdef V4L2_CID_COLOR_KILLER
		swigIntConstant( V4L2_CID_COLOR_KILLER, "V4L2_CID_COLOR_KILLER" );
	#endif
	#ifdef V4L2_CID_COLORFX
		swigIntConstant( V4L2_CID_COLORFX, "V4L2_CID_COLORFX" );
	#endif
	#ifdef V4L2_CID_AUTOBRIGHTNESS
		swigIntConstant( V4L2_CID_AUTOBRIGHTNESS, "V4L2_CID_AUTOBRIGHTNESS" );
	#endif
	#ifdef V4L2_CID_BAND_STOP_FILTER
		swigIntConstant( V4L2_CID_BAND_STOP_FILTER, "V4L2_CID_BAND_STOP_FILTER" );
	#endif
	#ifdef V4L2_CID_ROTATE
		swigIntConstant( V4L2_CID_ROTATE, "V4L2_CID_ROTATE" );
	#endif
	#ifdef V4L2_CID_BG_COLOR
		swigIntConstant( V4L2_CID_BG_COLOR, "V4L2_CID_BG_COLOR" );
	#endif
	#ifdef V4L2_CID_CHROMA_GAIN
		swigIntConstant( V4L2_CID_CHROMA_GAIN, "V4L2_CID_CHROMA_GAIN" );
	#endif
	#ifdef V4L2_CID_ILLUMINATORS_1
		swigIntConstant( V4L2_CID_ILLUMINATORS_1, "V4L2_CID_ILLUMINATORS_1" );
	#endif
	#ifdef V4L2_CID_ILLUMINATORS_2
		swigIntConstant( V4L2_CID_ILLUMINATORS_2, "V4L2_CID_ILLUMINATORS_2" );
	#endif
	#ifdef V4L2_CID_MIN_BUFFERS_FOR_CAPTURE
		swigIntConstant( V4L2_CID_MIN_BUFFERS_FOR_CAPTURE, "V4L2_CID_MIN_BUFFERS_FOR_CAPTURE" );
	#endif
	#ifdef V4L2_CID_MIN_BUFFERS_FOR_OUTPUT
		swigIntConstant( V4L2_CID_MIN_BUFFERS_FOR_OUTPUT, "V4L2_CID_MIN_BUFFERS_FOR_OUTPUT" );
	#endif
	#ifdef V4L2_CID_ALPHA_COMPONENT
		swigIntConstant( V4L2_CID_ALPHA_COMPONENT, "V4L2_CID_ALPHA_COMPONENT" );
	#endif
	#ifdef V4L2_CID_COLORFX_CBCR
		swigIntConstant( V4L2_CID_COLORFX_CBCR, "V4L2_CID_COLORFX_CBCR" );
	#endif
	#ifdef V4L2_CID_COLORFX_RGB
		swigIntConstant( V4L2_CID_COLORFX_RGB, "V4L2_CID_COLORFX_RGB" );
	#endif
	#ifdef V4L2_CID_LASTP1
		swigIntConstant( V4L2_CID_LASTP1, "V4L2_CID_LASTP1" );
	#endif
	#ifdef V4L2_CID_USER_MEYE_BASE
		swigIntConstant( V4L2_CID_USER_MEYE_BASE, "V4L2_CID_USER_MEYE_BASE" );
	#endif
	#ifdef V4L2_CID_USER_BTTV_BASE
		swigIntConstant( V4L2_CID_USER_BTTV_BASE, "V4L2_CID_USER_BTTV_BASE" );
	#endif
	#ifdef V4L2_CID_USER_S2255_BASE
		swigIntConstant( V4L2_CID_USER_S2255_BASE, "V4L2_CID_USER_S2255_BASE" );
	#endif
	#ifdef V4L2_CID_USER_SI476X_BASE
		swigIntConstant( V4L2_CID_USER_SI476X_BASE, "V4L2_CID_USER_SI476X_BASE" );
	#endif
	#ifdef V4L2_CID_USER_TI_VPE_BASE
		swigIntConstant( V4L2_CID_USER_TI_VPE_BASE, "V4L2_CID_USER_TI_VPE_BASE" );
	#endif
	#ifdef V4L2_CID_USER_SAA7134_BASE
		swigIntConstant( V4L2_CID_USER_SAA7134_BASE, "V4L2_CID_USER_SAA7134_BASE" );
	#endif
	#ifdef V4L2_CID_USER_ADV7180_BASE
		swigIntConstant( V4L2_CID_USER_ADV7180_BASE, "V4L2_CID_USER_ADV7180_BASE" );
	#endif
	#ifdef V4L2_CID_USER_TC358743_BASE
		swigIntConstant( V4L2_CID_USER_TC358743_BASE, "V4L2_CID_USER_TC358743_BASE" );
	#endif
	#ifdef V4L2_CID_USER_MAX217X_BASE
		swigIntConstant( V4L2_CID_USER_MAX217X_BASE, "V4L2_CID_USER_MAX217X_BASE" );
	#endif
	#ifdef V4L2_CID_USER_IMX_BASE
		swigIntConstant( V4L2_CID_USER_IMX_BASE, "V4L2_CID_USER_IMX_BASE" );
	#endif
	#ifdef V4L2_CID_USER_ATMEL_ISC_BASE
		swigIntConstant( V4L2_CID_USER_ATMEL_ISC_BASE, "V4L2_CID_USER_ATMEL_ISC_BASE" );
	#endif
	#ifdef V4L2_CID_USER_CODA_BASE
		swigIntConstant( V4L2_CID_USER_CODA_BASE, "V4L2_CID_USER_CODA_BASE" );
	#endif
	#ifdef V4L2_CID_USER_CCS_BASE
		swigIntConstant( V4L2_CID_USER_CCS_BASE, "V4L2_CID_USER_CCS_BASE" );
	#endif
	#ifdef V4L2_CID_USER_ALLEGRO_BASE
		swigIntConstant( V4L2_CID_USER_ALLEGRO_BASE, "V4L2_CID_USER_ALLEGRO_BASE" );
	#endif
	#ifdef V4L2_CID_CODEC_BASE
		swigIntConstant( V4L2_CID_CODEC_BASE, "V4L2_CID_CODEC_BASE" );
	#endif
	#ifdef V4L2_CID_CODEC_CLASS
		swigIntConstant( V4L2_CID_CODEC_CLASS, "V4L2_CID_CODEC_CLASS" );
	#endif
	#ifdef V4L2_CID_MPEG_STREAM_TYPE
		swigIntConstant( V4L2_CID_MPEG_STREAM_TYPE, "V4L2_CID_MPEG_STREAM_TYPE" );
	#endif
	#ifdef V4L2_CID_MPEG_STREAM_PID_PMT
		swigIntConstant( V4L2_CID_MPEG_STREAM_PID_PMT, "V4L2_CID_MPEG_STREAM_PID_PMT" );
	#endif
	#ifdef V4L2_CID_MPEG_STREAM_PID_AUDIO
		swigIntConstant( V4L2_CID_MPEG_STREAM_PID_AUDIO, "V4L2_CID_MPEG_STREAM_PID_AUDIO" );
	#endif
	#ifdef V4L2_CID_MPEG_STREAM_PID_VIDEO
		swigIntConstant( V4L2_CID_MPEG_STREAM_PID_VIDEO, "V4L2_CID_MPEG_STREAM_PID_VIDEO" );
	#endif
	#ifdef V4L2_CID_MPEG_STREAM_PID_PCR
		swigIntConstant( V4L2_CID_MPEG_STREAM_PID_PCR, "V4L2_CID_MPEG_STREAM_PID_PCR" );
	#endif
	#ifdef V4L2_CID_MPEG_STREAM_PES_ID_AUDIO
		swigIntConstant( V4L2_CID_MPEG_STREAM_PES_ID_AUDIO, "V4L2_CID_MPEG_STREAM_PES_ID_AUDIO" );
	#endif
	#ifdef V4L2_CID_MPEG_STREAM_PES_ID_VIDEO
		swigIntConstant( V4L2_CID_MPEG_STREAM_PES_ID_VIDEO, "V4L2_CID_MPEG_STREAM_PES_ID_VIDEO" );
	#endif
	#ifdef V4L2_CID_MPEG_STREAM_VBI_FMT
		swigIntConstant( V4L2_CID_MPEG_STREAM_VBI_FMT, "V4L2_CID_MPEG_STREAM_VBI_FMT" );
	#endif
	#ifdef V4L2_CID_MPEG_AUDIO_SAMPLING_FREQ
		swigIntConstant( V4L2_CID_MPEG_AUDIO_SAMPLING_FREQ, "V4L2_CID_MPEG_AUDIO_SAMPLING_FREQ" );
	#endif
	#ifdef V4L2_CID_MPEG_AUDIO_ENCODING
		swigIntConstant( V4L2_CID_MPEG_AUDIO_ENCODING, "V4L2_CID_MPEG_AUDIO_ENCODING" );
	#endif
	#ifdef V4L2_CID_MPEG_AUDIO_L1_BITRATE
		swigIntConstant( V4L2_CID_MPEG_AUDIO_L1_BITRATE, "V4L2_CID_MPEG_AUDIO_L1_BITRATE" );
	#endif
	#ifdef V4L2_CID_MPEG_AUDIO_L2_BITRATE
		swigIntConstant( V4L2_CID_MPEG_AUDIO_L2_BITRATE, "V4L2_CID_MPEG_AUDIO_L2_BITRATE" );
	#endif
	#ifdef V4L2_CID_MPEG_AUDIO_L3_BITRATE
		swigIntConstant( V4L2_CID_MPEG_AUDIO_L3_BITRATE, "V4L2_CID_MPEG_AUDIO_L3_BITRATE" );
	#endif
	#ifdef V4L2_CID_MPEG_AUDIO_MODE
		swigIntConstant( V4L2_CID_MPEG_AUDIO_MODE, "V4L2_CID_MPEG_AUDIO_MODE" );
	#endif
	#ifdef V4L2_CID_MPEG_AUDIO_MODE_EXTENSION
		swigIntConstant( V4L2_CID_MPEG_AUDIO_MODE_EXTENSION, "V4L2_CID_MPEG_AUDIO_MODE_EXTENSION" );
	#endif
	#ifdef V4L2_CID_MPEG_AUDIO_EMPHASIS
		swigIntConstant( V4L2_CID_MPEG_AUDIO_EMPHASIS, "V4L2_CID_MPEG_AUDIO_EMPHASIS" );
	#endif
	#ifdef V4L2_CID_MPEG_AUDIO_CRC
		swigIntConstant( V4L2_CID_MPEG_AUDIO_CRC, "V4L2_CID_MPEG_AUDIO_CRC" );
	#endif
	#ifdef V4L2_CID_MPEG_AUDIO_MUTE
		swigIntConstant( V4L2_CID_MPEG_AUDIO_MUTE, "V4L2_CID_MPEG_AUDIO_MUTE" );
	#endif
	#ifdef V4L2_CID_MPEG_AUDIO_AAC_BITRATE
		swigIntConstant( V4L2_CID_MPEG_AUDIO_AAC_BITRATE, "V4L2_CID_MPEG_AUDIO_AAC_BITRATE" );
	#endif
	#ifdef V4L2_CID_MPEG_AUDIO_AC3_BITRATE
		swigIntConstant( V4L2_CID_MPEG_AUDIO_AC3_BITRATE, "V4L2_CID_MPEG_AUDIO_AC3_BITRATE" );
	#endif
	#ifdef V4L2_CID_MPEG_AUDIO_DEC_PLAYBACK
		swigIntConstant( V4L2_CID_MPEG_AUDIO_DEC_PLAYBACK, "V4L2_CID_MPEG_AUDIO_DEC_PLAYBACK" );
	#endif
	#ifdef V4L2_CID_MPEG_AUDIO_DEC_MULTILINGUAL_PLAYBACK
		swigIntConstant( V4L2_CID_MPEG_AUDIO_DEC_MULTILINGUAL_PLAYBACK, "V4L2_CID_MPEG_AUDIO_DEC_MULTILINGUAL_PLAYBACK" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_ENCODING
		swigIntConstant( V4L2_CID_MPEG_VIDEO_ENCODING, "V4L2_CID_MPEG_VIDEO_ENCODING" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_ASPECT
		swigIntConstant( V4L2_CID_MPEG_VIDEO_ASPECT, "V4L2_CID_MPEG_VIDEO_ASPECT" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_B_FRAMES
		swigIntConstant( V4L2_CID_MPEG_VIDEO_B_FRAMES, "V4L2_CID_MPEG_VIDEO_B_FRAMES" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_GOP_SIZE
		swigIntConstant( V4L2_CID_MPEG_VIDEO_GOP_SIZE, "V4L2_CID_MPEG_VIDEO_GOP_SIZE" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_GOP_CLOSURE
		swigIntConstant( V4L2_CID_MPEG_VIDEO_GOP_CLOSURE, "V4L2_CID_MPEG_VIDEO_GOP_CLOSURE" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_PULLDOWN
		swigIntConstant( V4L2_CID_MPEG_VIDEO_PULLDOWN, "V4L2_CID_MPEG_VIDEO_PULLDOWN" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_BITRATE_MODE
		swigIntConstant( V4L2_CID_MPEG_VIDEO_BITRATE_MODE, "V4L2_CID_MPEG_VIDEO_BITRATE_MODE" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_BITRATE
		swigIntConstant( V4L2_CID_MPEG_VIDEO_BITRATE, "V4L2_CID_MPEG_VIDEO_BITRATE" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_BITRATE_PEAK
		swigIntConstant( V4L2_CID_MPEG_VIDEO_BITRATE_PEAK, "V4L2_CID_MPEG_VIDEO_BITRATE_PEAK" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_TEMPORAL_DECIMATION
		swigIntConstant( V4L2_CID_MPEG_VIDEO_TEMPORAL_DECIMATION, "V4L2_CID_MPEG_VIDEO_TEMPORAL_DECIMATION" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_MUTE
		swigIntConstant( V4L2_CID_MPEG_VIDEO_MUTE, "V4L2_CID_MPEG_VIDEO_MUTE" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_MUTE_YUV
		swigIntConstant( V4L2_CID_MPEG_VIDEO_MUTE_YUV, "V4L2_CID_MPEG_VIDEO_MUTE_YUV" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_DECODER_SLICE_INTERFACE
		swigIntConstant( V4L2_CID_MPEG_VIDEO_DECODER_SLICE_INTERFACE, "V4L2_CID_MPEG_VIDEO_DECODER_SLICE_INTERFACE" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_DECODER_MPEG4_DEBLOCK_FILTER
		swigIntConstant( V4L2_CID_MPEG_VIDEO_DECODER_MPEG4_DEBLOCK_FILTER, "V4L2_CID_MPEG_VIDEO_DECODER_MPEG4_DEBLOCK_FILTER" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_CYCLIC_INTRA_REFRESH_MB
		swigIntConstant( V4L2_CID_MPEG_VIDEO_CYCLIC_INTRA_REFRESH_MB, "V4L2_CID_MPEG_VIDEO_CYCLIC_INTRA_REFRESH_MB" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_FRAME_RC_ENABLE
		swigIntConstant( V4L2_CID_MPEG_VIDEO_FRAME_RC_ENABLE, "V4L2_CID_MPEG_VIDEO_FRAME_RC_ENABLE" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_HEADER_MODE
		swigIntConstant( V4L2_CID_MPEG_VIDEO_HEADER_MODE, "V4L2_CID_MPEG_VIDEO_HEADER_MODE" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_MAX_REF_PIC
		swigIntConstant( V4L2_CID_MPEG_VIDEO_MAX_REF_PIC, "V4L2_CID_MPEG_VIDEO_MAX_REF_PIC" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_MB_RC_ENABLE
		swigIntConstant( V4L2_CID_MPEG_VIDEO_MB_RC_ENABLE, "V4L2_CID_MPEG_VIDEO_MB_RC_ENABLE" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_MULTI_SLICE_MAX_BYTES
		swigIntConstant( V4L2_CID_MPEG_VIDEO_MULTI_SLICE_MAX_BYTES, "V4L2_CID_MPEG_VIDEO_MULTI_SLICE_MAX_BYTES" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_MULTI_SLICE_MAX_MB
		swigIntConstant( V4L2_CID_MPEG_VIDEO_MULTI_SLICE_MAX_MB, "V4L2_CID_MPEG_VIDEO_MULTI_SLICE_MAX_MB" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_MULTI_SLICE_MODE
		swigIntConstant( V4L2_CID_MPEG_VIDEO_MULTI_SLICE_MODE, "V4L2_CID_MPEG_VIDEO_MULTI_SLICE_MODE" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_VBV_SIZE
		swigIntConstant( V4L2_CID_MPEG_VIDEO_VBV_SIZE, "V4L2_CID_MPEG_VIDEO_VBV_SIZE" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_DEC_PTS
		swigIntConstant( V4L2_CID_MPEG_VIDEO_DEC_PTS, "V4L2_CID_MPEG_VIDEO_DEC_PTS" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_DEC_FRAME
		swigIntConstant( V4L2_CID_MPEG_VIDEO_DEC_FRAME, "V4L2_CID_MPEG_VIDEO_DEC_FRAME" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_VBV_DELAY
		swigIntConstant( V4L2_CID_MPEG_VIDEO_VBV_DELAY, "V4L2_CID_MPEG_VIDEO_VBV_DELAY" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_REPEAT_SEQ_HEADER
		swigIntConstant( V4L2_CID_MPEG_VIDEO_REPEAT_SEQ_HEADER, "V4L2_CID_MPEG_VIDEO_REPEAT_SEQ_HEADER" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_MV_H_SEARCH_RANGE
		swigIntConstant( V4L2_CID_MPEG_VIDEO_MV_H_SEARCH_RANGE, "V4L2_CID_MPEG_VIDEO_MV_H_SEARCH_RANGE" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_MV_V_SEARCH_RANGE
		swigIntConstant( V4L2_CID_MPEG_VIDEO_MV_V_SEARCH_RANGE, "V4L2_CID_MPEG_VIDEO_MV_V_SEARCH_RANGE" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_FORCE_KEY_FRAME
		swigIntConstant( V4L2_CID_MPEG_VIDEO_FORCE_KEY_FRAME, "V4L2_CID_MPEG_VIDEO_FORCE_KEY_FRAME" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_BASELAYER_PRIORITY_ID
		swigIntConstant( V4L2_CID_MPEG_VIDEO_BASELAYER_PRIORITY_ID, "V4L2_CID_MPEG_VIDEO_BASELAYER_PRIORITY_ID" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_AU_DELIMITER
		swigIntConstant( V4L2_CID_MPEG_VIDEO_AU_DELIMITER, "V4L2_CID_MPEG_VIDEO_AU_DELIMITER" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_LTR_COUNT
		swigIntConstant( V4L2_CID_MPEG_VIDEO_LTR_COUNT, "V4L2_CID_MPEG_VIDEO_LTR_COUNT" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_FRAME_LTR_INDEX
		swigIntConstant( V4L2_CID_MPEG_VIDEO_FRAME_LTR_INDEX, "V4L2_CID_MPEG_VIDEO_FRAME_LTR_INDEX" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_USE_LTR_FRAMES
		swigIntConstant( V4L2_CID_MPEG_VIDEO_USE_LTR_FRAMES, "V4L2_CID_MPEG_VIDEO_USE_LTR_FRAMES" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_DEC_CONCEAL_COLOR
		swigIntConstant( V4L2_CID_MPEG_VIDEO_DEC_CONCEAL_COLOR, "V4L2_CID_MPEG_VIDEO_DEC_CONCEAL_COLOR" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_INTRA_REFRESH_PERIOD
		swigIntConstant( V4L2_CID_MPEG_VIDEO_INTRA_REFRESH_PERIOD, "V4L2_CID_MPEG_VIDEO_INTRA_REFRESH_PERIOD" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_MPEG2_LEVEL
		swigIntConstant( V4L2_CID_MPEG_VIDEO_MPEG2_LEVEL, "V4L2_CID_MPEG_VIDEO_MPEG2_LEVEL" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_MPEG2_PROFILE
		swigIntConstant( V4L2_CID_MPEG_VIDEO_MPEG2_PROFILE, "V4L2_CID_MPEG_VIDEO_MPEG2_PROFILE" );
	#endif
	#ifdef V4L2_CID_FWHT_I_FRAME_QP
		swigIntConstant( V4L2_CID_FWHT_I_FRAME_QP, "V4L2_CID_FWHT_I_FRAME_QP" );
	#endif
	#ifdef V4L2_CID_FWHT_P_FRAME_QP
		swigIntConstant( V4L2_CID_FWHT_P_FRAME_QP, "V4L2_CID_FWHT_P_FRAME_QP" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_H263_I_FRAME_QP
		swigIntConstant( V4L2_CID_MPEG_VIDEO_H263_I_FRAME_QP, "V4L2_CID_MPEG_VIDEO_H263_I_FRAME_QP" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_H263_P_FRAME_QP
		swigIntConstant( V4L2_CID_MPEG_VIDEO_H263_P_FRAME_QP, "V4L2_CID_MPEG_VIDEO_H263_P_FRAME_QP" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_H263_B_FRAME_QP
		swigIntConstant( V4L2_CID_MPEG_VIDEO_H263_B_FRAME_QP, "V4L2_CID_MPEG_VIDEO_H263_B_FRAME_QP" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_H263_MIN_QP
		swigIntConstant( V4L2_CID_MPEG_VIDEO_H263_MIN_QP, "V4L2_CID_MPEG_VIDEO_H263_MIN_QP" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_H263_MAX_QP
		swigIntConstant( V4L2_CID_MPEG_VIDEO_H263_MAX_QP, "V4L2_CID_MPEG_VIDEO_H263_MAX_QP" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_H264_I_FRAME_QP
		swigIntConstant( V4L2_CID_MPEG_VIDEO_H264_I_FRAME_QP, "V4L2_CID_MPEG_VIDEO_H264_I_FRAME_QP" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_H264_P_FRAME_QP
		swigIntConstant( V4L2_CID_MPEG_VIDEO_H264_P_FRAME_QP, "V4L2_CID_MPEG_VIDEO_H264_P_FRAME_QP" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_H264_B_FRAME_QP
		swigIntConstant( V4L2_CID_MPEG_VIDEO_H264_B_FRAME_QP, "V4L2_CID_MPEG_VIDEO_H264_B_FRAME_QP" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_H264_MIN_QP
		swigIntConstant( V4L2_CID_MPEG_VIDEO_H264_MIN_QP, "V4L2_CID_MPEG_VIDEO_H264_MIN_QP" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_H264_MAX_QP
		swigIntConstant( V4L2_CID_MPEG_VIDEO_H264_MAX_QP, "V4L2_CID_MPEG_VIDEO_H264_MAX_QP" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_H264_8X8_TRANSFORM
		swigIntConstant( V4L2_CID_MPEG_VIDEO_H264_8X8_TRANSFORM, "V4L2_CID_MPEG_VIDEO_H264_8X8_TRANSFORM" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_H264_CPB_SIZE
		swigIntConstant( V4L2_CID_MPEG_VIDEO_H264_CPB_SIZE, "V4L2_CID_MPEG_VIDEO_H264_CPB_SIZE" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_H264_ENTROPY_MODE
		swigIntConstant( V4L2_CID_MPEG_VIDEO_H264_ENTROPY_MODE, "V4L2_CID_MPEG_VIDEO_H264_ENTROPY_MODE" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_H264_I_PERIOD
		swigIntConstant( V4L2_CID_MPEG_VIDEO_H264_I_PERIOD, "V4L2_CID_MPEG_VIDEO_H264_I_PERIOD" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_H264_LEVEL
		swigIntConstant( V4L2_CID_MPEG_VIDEO_H264_LEVEL, "V4L2_CID_MPEG_VIDEO_H264_LEVEL" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_H264_LOOP_FILTER_ALPHA
		swigIntConstant( V4L2_CID_MPEG_VIDEO_H264_LOOP_FILTER_ALPHA, "V4L2_CID_MPEG_VIDEO_H264_LOOP_FILTER_ALPHA" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_H264_LOOP_FILTER_BETA
		swigIntConstant( V4L2_CID_MPEG_VIDEO_H264_LOOP_FILTER_BETA, "V4L2_CID_MPEG_VIDEO_H264_LOOP_FILTER_BETA" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_H264_LOOP_FILTER_MODE
		swigIntConstant( V4L2_CID_MPEG_VIDEO_H264_LOOP_FILTER_MODE, "V4L2_CID_MPEG_VIDEO_H264_LOOP_FILTER_MODE" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_H264_PROFILE
		swigIntConstant( V4L2_CID_MPEG_VIDEO_H264_PROFILE, "V4L2_CID_MPEG_VIDEO_H264_PROFILE" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_H264_VUI_EXT_SAR_HEIGHT
		swigIntConstant( V4L2_CID_MPEG_VIDEO_H264_VUI_EXT_SAR_HEIGHT, "V4L2_CID_MPEG_VIDEO_H264_VUI_EXT_SAR_HEIGHT" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_H264_VUI_EXT_SAR_WIDTH
		swigIntConstant( V4L2_CID_MPEG_VIDEO_H264_VUI_EXT_SAR_WIDTH, "V4L2_CID_MPEG_VIDEO_H264_VUI_EXT_SAR_WIDTH" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_H264_VUI_SAR_ENABLE
		swigIntConstant( V4L2_CID_MPEG_VIDEO_H264_VUI_SAR_ENABLE, "V4L2_CID_MPEG_VIDEO_H264_VUI_SAR_ENABLE" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_H264_VUI_SAR_IDC
		swigIntConstant( V4L2_CID_MPEG_VIDEO_H264_VUI_SAR_IDC, "V4L2_CID_MPEG_VIDEO_H264_VUI_SAR_IDC" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_H264_SEI_FRAME_PACKING
		swigIntConstant( V4L2_CID_MPEG_VIDEO_H264_SEI_FRAME_PACKING, "V4L2_CID_MPEG_VIDEO_H264_SEI_FRAME_PACKING" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_H264_SEI_FP_CURRENT_FRAME_0
		swigIntConstant( V4L2_CID_MPEG_VIDEO_H264_SEI_FP_CURRENT_FRAME_0, "V4L2_CID_MPEG_VIDEO_H264_SEI_FP_CURRENT_FRAME_0" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_H264_SEI_FP_ARRANGEMENT_TYPE
		swigIntConstant( V4L2_CID_MPEG_VIDEO_H264_SEI_FP_ARRANGEMENT_TYPE, "V4L2_CID_MPEG_VIDEO_H264_SEI_FP_ARRANGEMENT_TYPE" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_H264_FMO
		swigIntConstant( V4L2_CID_MPEG_VIDEO_H264_FMO, "V4L2_CID_MPEG_VIDEO_H264_FMO" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_H264_FMO_MAP_TYPE
		swigIntConstant( V4L2_CID_MPEG_VIDEO_H264_FMO_MAP_TYPE, "V4L2_CID_MPEG_VIDEO_H264_FMO_MAP_TYPE" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_H264_FMO_SLICE_GROUP
		swigIntConstant( V4L2_CID_MPEG_VIDEO_H264_FMO_SLICE_GROUP, "V4L2_CID_MPEG_VIDEO_H264_FMO_SLICE_GROUP" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_H264_FMO_CHANGE_DIRECTION
		swigIntConstant( V4L2_CID_MPEG_VIDEO_H264_FMO_CHANGE_DIRECTION, "V4L2_CID_MPEG_VIDEO_H264_FMO_CHANGE_DIRECTION" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_H264_FMO_CHANGE_RATE
		swigIntConstant( V4L2_CID_MPEG_VIDEO_H264_FMO_CHANGE_RATE, "V4L2_CID_MPEG_VIDEO_H264_FMO_CHANGE_RATE" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_H264_FMO_RUN_LENGTH
		swigIntConstant( V4L2_CID_MPEG_VIDEO_H264_FMO_RUN_LENGTH, "V4L2_CID_MPEG_VIDEO_H264_FMO_RUN_LENGTH" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_H264_ASO
		swigIntConstant( V4L2_CID_MPEG_VIDEO_H264_ASO, "V4L2_CID_MPEG_VIDEO_H264_ASO" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_H264_ASO_SLICE_ORDER
		swigIntConstant( V4L2_CID_MPEG_VIDEO_H264_ASO_SLICE_ORDER, "V4L2_CID_MPEG_VIDEO_H264_ASO_SLICE_ORDER" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_H264_HIERARCHICAL_CODING
		swigIntConstant( V4L2_CID_MPEG_VIDEO_H264_HIERARCHICAL_CODING, "V4L2_CID_MPEG_VIDEO_H264_HIERARCHICAL_CODING" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_H264_HIERARCHICAL_CODING_TYPE
		swigIntConstant( V4L2_CID_MPEG_VIDEO_H264_HIERARCHICAL_CODING_TYPE, "V4L2_CID_MPEG_VIDEO_H264_HIERARCHICAL_CODING_TYPE" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_H264_HIERARCHICAL_CODING_LAYER
		swigIntConstant( V4L2_CID_MPEG_VIDEO_H264_HIERARCHICAL_CODING_LAYER, "V4L2_CID_MPEG_VIDEO_H264_HIERARCHICAL_CODING_LAYER" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_H264_HIERARCHICAL_CODING_LAYER_QP
		swigIntConstant( V4L2_CID_MPEG_VIDEO_H264_HIERARCHICAL_CODING_LAYER_QP, "V4L2_CID_MPEG_VIDEO_H264_HIERARCHICAL_CODING_LAYER_QP" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_H264_CONSTRAINED_INTRA_PREDICTION
		swigIntConstant( V4L2_CID_MPEG_VIDEO_H264_CONSTRAINED_INTRA_PREDICTION, "V4L2_CID_MPEG_VIDEO_H264_CONSTRAINED_INTRA_PREDICTION" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_H264_CHROMA_QP_INDEX_OFFSET
		swigIntConstant( V4L2_CID_MPEG_VIDEO_H264_CHROMA_QP_INDEX_OFFSET, "V4L2_CID_MPEG_VIDEO_H264_CHROMA_QP_INDEX_OFFSET" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_H264_I_FRAME_MIN_QP
		swigIntConstant( V4L2_CID_MPEG_VIDEO_H264_I_FRAME_MIN_QP, "V4L2_CID_MPEG_VIDEO_H264_I_FRAME_MIN_QP" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_H264_I_FRAME_MAX_QP
		swigIntConstant( V4L2_CID_MPEG_VIDEO_H264_I_FRAME_MAX_QP, "V4L2_CID_MPEG_VIDEO_H264_I_FRAME_MAX_QP" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_H264_P_FRAME_MIN_QP
		swigIntConstant( V4L2_CID_MPEG_VIDEO_H264_P_FRAME_MIN_QP, "V4L2_CID_MPEG_VIDEO_H264_P_FRAME_MIN_QP" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_H264_P_FRAME_MAX_QP
		swigIntConstant( V4L2_CID_MPEG_VIDEO_H264_P_FRAME_MAX_QP, "V4L2_CID_MPEG_VIDEO_H264_P_FRAME_MAX_QP" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_H264_B_FRAME_MIN_QP
		swigIntConstant( V4L2_CID_MPEG_VIDEO_H264_B_FRAME_MIN_QP, "V4L2_CID_MPEG_VIDEO_H264_B_FRAME_MIN_QP" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_H264_B_FRAME_MAX_QP
		swigIntConstant( V4L2_CID_MPEG_VIDEO_H264_B_FRAME_MAX_QP, "V4L2_CID_MPEG_VIDEO_H264_B_FRAME_MAX_QP" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_H264_HIER_CODING_L0_BR
		swigIntConstant( V4L2_CID_MPEG_VIDEO_H264_HIER_CODING_L0_BR, "V4L2_CID_MPEG_VIDEO_H264_HIER_CODING_L0_BR" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_H264_HIER_CODING_L1_BR
		swigIntConstant( V4L2_CID_MPEG_VIDEO_H264_HIER_CODING_L1_BR, "V4L2_CID_MPEG_VIDEO_H264_HIER_CODING_L1_BR" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_H264_HIER_CODING_L2_BR
		swigIntConstant( V4L2_CID_MPEG_VIDEO_H264_HIER_CODING_L2_BR, "V4L2_CID_MPEG_VIDEO_H264_HIER_CODING_L2_BR" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_H264_HIER_CODING_L3_BR
		swigIntConstant( V4L2_CID_MPEG_VIDEO_H264_HIER_CODING_L3_BR, "V4L2_CID_MPEG_VIDEO_H264_HIER_CODING_L3_BR" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_H264_HIER_CODING_L4_BR
		swigIntConstant( V4L2_CID_MPEG_VIDEO_H264_HIER_CODING_L4_BR, "V4L2_CID_MPEG_VIDEO_H264_HIER_CODING_L4_BR" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_H264_HIER_CODING_L5_BR
		swigIntConstant( V4L2_CID_MPEG_VIDEO_H264_HIER_CODING_L5_BR, "V4L2_CID_MPEG_VIDEO_H264_HIER_CODING_L5_BR" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_H264_HIER_CODING_L6_BR
		swigIntConstant( V4L2_CID_MPEG_VIDEO_H264_HIER_CODING_L6_BR, "V4L2_CID_MPEG_VIDEO_H264_HIER_CODING_L6_BR" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_MPEG4_I_FRAME_QP
		swigIntConstant( V4L2_CID_MPEG_VIDEO_MPEG4_I_FRAME_QP, "V4L2_CID_MPEG_VIDEO_MPEG4_I_FRAME_QP" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_MPEG4_P_FRAME_QP
		swigIntConstant( V4L2_CID_MPEG_VIDEO_MPEG4_P_FRAME_QP, "V4L2_CID_MPEG_VIDEO_MPEG4_P_FRAME_QP" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_MPEG4_B_FRAME_QP
		swigIntConstant( V4L2_CID_MPEG_VIDEO_MPEG4_B_FRAME_QP, "V4L2_CID_MPEG_VIDEO_MPEG4_B_FRAME_QP" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_MPEG4_MIN_QP
		swigIntConstant( V4L2_CID_MPEG_VIDEO_MPEG4_MIN_QP, "V4L2_CID_MPEG_VIDEO_MPEG4_MIN_QP" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_MPEG4_MAX_QP
		swigIntConstant( V4L2_CID_MPEG_VIDEO_MPEG4_MAX_QP, "V4L2_CID_MPEG_VIDEO_MPEG4_MAX_QP" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_MPEG4_LEVEL
		swigIntConstant( V4L2_CID_MPEG_VIDEO_MPEG4_LEVEL, "V4L2_CID_MPEG_VIDEO_MPEG4_LEVEL" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_MPEG4_PROFILE
		swigIntConstant( V4L2_CID_MPEG_VIDEO_MPEG4_PROFILE, "V4L2_CID_MPEG_VIDEO_MPEG4_PROFILE" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_MPEG4_QPEL
		swigIntConstant( V4L2_CID_MPEG_VIDEO_MPEG4_QPEL, "V4L2_CID_MPEG_VIDEO_MPEG4_QPEL" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_VPX_NUM_PARTITIONS
		swigIntConstant( V4L2_CID_MPEG_VIDEO_VPX_NUM_PARTITIONS, "V4L2_CID_MPEG_VIDEO_VPX_NUM_PARTITIONS" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_VPX_IMD_DISABLE_4X4
		swigIntConstant( V4L2_CID_MPEG_VIDEO_VPX_IMD_DISABLE_4X4, "V4L2_CID_MPEG_VIDEO_VPX_IMD_DISABLE_4X4" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_VPX_NUM_REF_FRAMES
		swigIntConstant( V4L2_CID_MPEG_VIDEO_VPX_NUM_REF_FRAMES, "V4L2_CID_MPEG_VIDEO_VPX_NUM_REF_FRAMES" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_VPX_FILTER_LEVEL
		swigIntConstant( V4L2_CID_MPEG_VIDEO_VPX_FILTER_LEVEL, "V4L2_CID_MPEG_VIDEO_VPX_FILTER_LEVEL" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_VPX_FILTER_SHARPNESS
		swigIntConstant( V4L2_CID_MPEG_VIDEO_VPX_FILTER_SHARPNESS, "V4L2_CID_MPEG_VIDEO_VPX_FILTER_SHARPNESS" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_VPX_GOLDEN_FRAME_REF_PERIOD
		swigIntConstant( V4L2_CID_MPEG_VIDEO_VPX_GOLDEN_FRAME_REF_PERIOD, "V4L2_CID_MPEG_VIDEO_VPX_GOLDEN_FRAME_REF_PERIOD" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_VPX_GOLDEN_FRAME_SEL
		swigIntConstant( V4L2_CID_MPEG_VIDEO_VPX_GOLDEN_FRAME_SEL, "V4L2_CID_MPEG_VIDEO_VPX_GOLDEN_FRAME_SEL" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_VPX_MIN_QP
		swigIntConstant( V4L2_CID_MPEG_VIDEO_VPX_MIN_QP, "V4L2_CID_MPEG_VIDEO_VPX_MIN_QP" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_VPX_MAX_QP
		swigIntConstant( V4L2_CID_MPEG_VIDEO_VPX_MAX_QP, "V4L2_CID_MPEG_VIDEO_VPX_MAX_QP" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_VPX_I_FRAME_QP
		swigIntConstant( V4L2_CID_MPEG_VIDEO_VPX_I_FRAME_QP, "V4L2_CID_MPEG_VIDEO_VPX_I_FRAME_QP" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_VPX_P_FRAME_QP
		swigIntConstant( V4L2_CID_MPEG_VIDEO_VPX_P_FRAME_QP, "V4L2_CID_MPEG_VIDEO_VPX_P_FRAME_QP" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_VP8_PROFILE
		swigIntConstant( V4L2_CID_MPEG_VIDEO_VP8_PROFILE, "V4L2_CID_MPEG_VIDEO_VP8_PROFILE" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_VPX_PROFILE
		swigIntConstant( V4L2_CID_MPEG_VIDEO_VPX_PROFILE, "V4L2_CID_MPEG_VIDEO_VPX_PROFILE" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_VP9_PROFILE
		swigIntConstant( V4L2_CID_MPEG_VIDEO_VP9_PROFILE, "V4L2_CID_MPEG_VIDEO_VP9_PROFILE" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_VP9_LEVEL
		swigIntConstant( V4L2_CID_MPEG_VIDEO_VP9_LEVEL, "V4L2_CID_MPEG_VIDEO_VP9_LEVEL" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_HEVC_MIN_QP
		swigIntConstant( V4L2_CID_MPEG_VIDEO_HEVC_MIN_QP, "V4L2_CID_MPEG_VIDEO_HEVC_MIN_QP" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_HEVC_MAX_QP
		swigIntConstant( V4L2_CID_MPEG_VIDEO_HEVC_MAX_QP, "V4L2_CID_MPEG_VIDEO_HEVC_MAX_QP" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_HEVC_I_FRAME_QP
		swigIntConstant( V4L2_CID_MPEG_VIDEO_HEVC_I_FRAME_QP, "V4L2_CID_MPEG_VIDEO_HEVC_I_FRAME_QP" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_HEVC_P_FRAME_QP
		swigIntConstant( V4L2_CID_MPEG_VIDEO_HEVC_P_FRAME_QP, "V4L2_CID_MPEG_VIDEO_HEVC_P_FRAME_QP" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_HEVC_B_FRAME_QP
		swigIntConstant( V4L2_CID_MPEG_VIDEO_HEVC_B_FRAME_QP, "V4L2_CID_MPEG_VIDEO_HEVC_B_FRAME_QP" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_HEVC_HIER_QP
		swigIntConstant( V4L2_CID_MPEG_VIDEO_HEVC_HIER_QP, "V4L2_CID_MPEG_VIDEO_HEVC_HIER_QP" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_TYPE
		swigIntConstant( V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_TYPE, "V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_TYPE" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_LAYER
		swigIntConstant( V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_LAYER, "V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_LAYER" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_L0_QP
		swigIntConstant( V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_L0_QP, "V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_L0_QP" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_L1_QP
		swigIntConstant( V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_L1_QP, "V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_L1_QP" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_L2_QP
		swigIntConstant( V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_L2_QP, "V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_L2_QP" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_L3_QP
		swigIntConstant( V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_L3_QP, "V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_L3_QP" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_L4_QP
		swigIntConstant( V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_L4_QP, "V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_L4_QP" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_L5_QP
		swigIntConstant( V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_L5_QP, "V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_L5_QP" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_L6_QP
		swigIntConstant( V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_L6_QP, "V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_L6_QP" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_HEVC_PROFILE
		swigIntConstant( V4L2_CID_MPEG_VIDEO_HEVC_PROFILE, "V4L2_CID_MPEG_VIDEO_HEVC_PROFILE" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_HEVC_LEVEL
		swigIntConstant( V4L2_CID_MPEG_VIDEO_HEVC_LEVEL, "V4L2_CID_MPEG_VIDEO_HEVC_LEVEL" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_HEVC_FRAME_RATE_RESOLUTION
		swigIntConstant( V4L2_CID_MPEG_VIDEO_HEVC_FRAME_RATE_RESOLUTION, "V4L2_CID_MPEG_VIDEO_HEVC_FRAME_RATE_RESOLUTION" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_HEVC_TIER
		swigIntConstant( V4L2_CID_MPEG_VIDEO_HEVC_TIER, "V4L2_CID_MPEG_VIDEO_HEVC_TIER" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_HEVC_MAX_PARTITION_DEPTH
		swigIntConstant( V4L2_CID_MPEG_VIDEO_HEVC_MAX_PARTITION_DEPTH, "V4L2_CID_MPEG_VIDEO_HEVC_MAX_PARTITION_DEPTH" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_HEVC_LOOP_FILTER_MODE
		swigIntConstant( V4L2_CID_MPEG_VIDEO_HEVC_LOOP_FILTER_MODE, "V4L2_CID_MPEG_VIDEO_HEVC_LOOP_FILTER_MODE" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_HEVC_LF_BETA_OFFSET_DIV2
		swigIntConstant( V4L2_CID_MPEG_VIDEO_HEVC_LF_BETA_OFFSET_DIV2, "V4L2_CID_MPEG_VIDEO_HEVC_LF_BETA_OFFSET_DIV2" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_HEVC_LF_TC_OFFSET_DIV2
		swigIntConstant( V4L2_CID_MPEG_VIDEO_HEVC_LF_TC_OFFSET_DIV2, "V4L2_CID_MPEG_VIDEO_HEVC_LF_TC_OFFSET_DIV2" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_HEVC_REFRESH_TYPE
		swigIntConstant( V4L2_CID_MPEG_VIDEO_HEVC_REFRESH_TYPE, "V4L2_CID_MPEG_VIDEO_HEVC_REFRESH_TYPE" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_HEVC_REFRESH_PERIOD
		swigIntConstant( V4L2_CID_MPEG_VIDEO_HEVC_REFRESH_PERIOD, "V4L2_CID_MPEG_VIDEO_HEVC_REFRESH_PERIOD" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_HEVC_LOSSLESS_CU
		swigIntConstant( V4L2_CID_MPEG_VIDEO_HEVC_LOSSLESS_CU, "V4L2_CID_MPEG_VIDEO_HEVC_LOSSLESS_CU" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_HEVC_CONST_INTRA_PRED
		swigIntConstant( V4L2_CID_MPEG_VIDEO_HEVC_CONST_INTRA_PRED, "V4L2_CID_MPEG_VIDEO_HEVC_CONST_INTRA_PRED" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_HEVC_WAVEFRONT
		swigIntConstant( V4L2_CID_MPEG_VIDEO_HEVC_WAVEFRONT, "V4L2_CID_MPEG_VIDEO_HEVC_WAVEFRONT" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_HEVC_GENERAL_PB
		swigIntConstant( V4L2_CID_MPEG_VIDEO_HEVC_GENERAL_PB, "V4L2_CID_MPEG_VIDEO_HEVC_GENERAL_PB" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_HEVC_TEMPORAL_ID
		swigIntConstant( V4L2_CID_MPEG_VIDEO_HEVC_TEMPORAL_ID, "V4L2_CID_MPEG_VIDEO_HEVC_TEMPORAL_ID" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_HEVC_STRONG_SMOOTHING
		swigIntConstant( V4L2_CID_MPEG_VIDEO_HEVC_STRONG_SMOOTHING, "V4L2_CID_MPEG_VIDEO_HEVC_STRONG_SMOOTHING" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_HEVC_MAX_NUM_MERGE_MV_MINUS1
		swigIntConstant( V4L2_CID_MPEG_VIDEO_HEVC_MAX_NUM_MERGE_MV_MINUS1, "V4L2_CID_MPEG_VIDEO_HEVC_MAX_NUM_MERGE_MV_MINUS1" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_HEVC_INTRA_PU_SPLIT
		swigIntConstant( V4L2_CID_MPEG_VIDEO_HEVC_INTRA_PU_SPLIT, "V4L2_CID_MPEG_VIDEO_HEVC_INTRA_PU_SPLIT" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_HEVC_TMV_PREDICTION
		swigIntConstant( V4L2_CID_MPEG_VIDEO_HEVC_TMV_PREDICTION, "V4L2_CID_MPEG_VIDEO_HEVC_TMV_PREDICTION" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_HEVC_WITHOUT_STARTCODE
		swigIntConstant( V4L2_CID_MPEG_VIDEO_HEVC_WITHOUT_STARTCODE, "V4L2_CID_MPEG_VIDEO_HEVC_WITHOUT_STARTCODE" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_HEVC_SIZE_OF_LENGTH_FIELD
		swigIntConstant( V4L2_CID_MPEG_VIDEO_HEVC_SIZE_OF_LENGTH_FIELD, "V4L2_CID_MPEG_VIDEO_HEVC_SIZE_OF_LENGTH_FIELD" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_L0_BR
		swigIntConstant( V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_L0_BR, "V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_L0_BR" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_L1_BR
		swigIntConstant( V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_L1_BR, "V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_L1_BR" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_L2_BR
		swigIntConstant( V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_L2_BR, "V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_L2_BR" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_L3_BR
		swigIntConstant( V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_L3_BR, "V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_L3_BR" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_L4_BR
		swigIntConstant( V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_L4_BR, "V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_L4_BR" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_L5_BR
		swigIntConstant( V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_L5_BR, "V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_L5_BR" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_L6_BR
		swigIntConstant( V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_L6_BR, "V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_L6_BR" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_REF_NUMBER_FOR_PFRAMES
		swigIntConstant( V4L2_CID_MPEG_VIDEO_REF_NUMBER_FOR_PFRAMES, "V4L2_CID_MPEG_VIDEO_REF_NUMBER_FOR_PFRAMES" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_PREPEND_SPSPPS_TO_IDR
		swigIntConstant( V4L2_CID_MPEG_VIDEO_PREPEND_SPSPPS_TO_IDR, "V4L2_CID_MPEG_VIDEO_PREPEND_SPSPPS_TO_IDR" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_CONSTANT_QUALITY
		swigIntConstant( V4L2_CID_MPEG_VIDEO_CONSTANT_QUALITY, "V4L2_CID_MPEG_VIDEO_CONSTANT_QUALITY" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_FRAME_SKIP_MODE
		swigIntConstant( V4L2_CID_MPEG_VIDEO_FRAME_SKIP_MODE, "V4L2_CID_MPEG_VIDEO_FRAME_SKIP_MODE" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_HEVC_I_FRAME_MIN_QP
		swigIntConstant( V4L2_CID_MPEG_VIDEO_HEVC_I_FRAME_MIN_QP, "V4L2_CID_MPEG_VIDEO_HEVC_I_FRAME_MIN_QP" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_HEVC_I_FRAME_MAX_QP
		swigIntConstant( V4L2_CID_MPEG_VIDEO_HEVC_I_FRAME_MAX_QP, "V4L2_CID_MPEG_VIDEO_HEVC_I_FRAME_MAX_QP" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_HEVC_P_FRAME_MIN_QP
		swigIntConstant( V4L2_CID_MPEG_VIDEO_HEVC_P_FRAME_MIN_QP, "V4L2_CID_MPEG_VIDEO_HEVC_P_FRAME_MIN_QP" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_HEVC_P_FRAME_MAX_QP
		swigIntConstant( V4L2_CID_MPEG_VIDEO_HEVC_P_FRAME_MAX_QP, "V4L2_CID_MPEG_VIDEO_HEVC_P_FRAME_MAX_QP" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_HEVC_B_FRAME_MIN_QP
		swigIntConstant( V4L2_CID_MPEG_VIDEO_HEVC_B_FRAME_MIN_QP, "V4L2_CID_MPEG_VIDEO_HEVC_B_FRAME_MIN_QP" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_HEVC_B_FRAME_MAX_QP
		swigIntConstant( V4L2_CID_MPEG_VIDEO_HEVC_B_FRAME_MAX_QP, "V4L2_CID_MPEG_VIDEO_HEVC_B_FRAME_MAX_QP" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_DEC_DISPLAY_DELAY
		swigIntConstant( V4L2_CID_MPEG_VIDEO_DEC_DISPLAY_DELAY, "V4L2_CID_MPEG_VIDEO_DEC_DISPLAY_DELAY" );
	#endif
	#ifdef V4L2_CID_MPEG_VIDEO_DEC_DISPLAY_DELAY_ENABLE
		swigIntConstant( V4L2_CID_MPEG_VIDEO_DEC_DISPLAY_DELAY_ENABLE, "V4L2_CID_MPEG_VIDEO_DEC_DISPLAY_DELAY_ENABLE" );
	#endif
	#ifdef V4L2_CID_CODEC_CX2341X_BASE
		swigIntConstant( V4L2_CID_CODEC_CX2341X_BASE, "V4L2_CID_CODEC_CX2341X_BASE" );
	#endif
	#ifdef V4L2_CID_MPEG_CX2341X_VIDEO_SPATIAL_FILTER_MODE
		swigIntConstant( V4L2_CID_MPEG_CX2341X_VIDEO_SPATIAL_FILTER_MODE, "V4L2_CID_MPEG_CX2341X_VIDEO_SPATIAL_FILTER_MODE" );
	#endif
	#ifdef V4L2_CID_MPEG_CX2341X_VIDEO_SPATIAL_FILTER
		swigIntConstant( V4L2_CID_MPEG_CX2341X_VIDEO_SPATIAL_FILTER, "V4L2_CID_MPEG_CX2341X_VIDEO_SPATIAL_FILTER" );
	#endif
	#ifdef V4L2_CID_MPEG_CX2341X_VIDEO_LUMA_SPATIAL_FILTER_TYPE
		swigIntConstant( V4L2_CID_MPEG_CX2341X_VIDEO_LUMA_SPATIAL_FILTER_TYPE, "V4L2_CID_MPEG_CX2341X_VIDEO_LUMA_SPATIAL_FILTER_TYPE" );
	#endif
	#ifdef V4L2_CID_MPEG_CX2341X_VIDEO_CHROMA_SPATIAL_FILTER_TYPE
		swigIntConstant( V4L2_CID_MPEG_CX2341X_VIDEO_CHROMA_SPATIAL_FILTER_TYPE, "V4L2_CID_MPEG_CX2341X_VIDEO_CHROMA_SPATIAL_FILTER_TYPE" );
	#endif
	#ifdef V4L2_CID_MPEG_CX2341X_VIDEO_TEMPORAL_FILTER_MODE
		swigIntConstant( V4L2_CID_MPEG_CX2341X_VIDEO_TEMPORAL_FILTER_MODE, "V4L2_CID_MPEG_CX2341X_VIDEO_TEMPORAL_FILTER_MODE" );
	#endif
	#ifdef V4L2_CID_MPEG_CX2341X_VIDEO_TEMPORAL_FILTER
		swigIntConstant( V4L2_CID_MPEG_CX2341X_VIDEO_TEMPORAL_FILTER, "V4L2_CID_MPEG_CX2341X_VIDEO_TEMPORAL_FILTER" );
	#endif
	#ifdef V4L2_CID_MPEG_CX2341X_VIDEO_MEDIAN_FILTER_TYPE
		swigIntConstant( V4L2_CID_MPEG_CX2341X_VIDEO_MEDIAN_FILTER_TYPE, "V4L2_CID_MPEG_CX2341X_VIDEO_MEDIAN_FILTER_TYPE" );
	#endif
	#ifdef V4L2_CID_MPEG_CX2341X_VIDEO_LUMA_MEDIAN_FILTER_BOTTOM
		swigIntConstant( V4L2_CID_MPEG_CX2341X_VIDEO_LUMA_MEDIAN_FILTER_BOTTOM, "V4L2_CID_MPEG_CX2341X_VIDEO_LUMA_MEDIAN_FILTER_BOTTOM" );
	#endif
	#ifdef V4L2_CID_MPEG_CX2341X_VIDEO_LUMA_MEDIAN_FILTER_TOP
		swigIntConstant( V4L2_CID_MPEG_CX2341X_VIDEO_LUMA_MEDIAN_FILTER_TOP, "V4L2_CID_MPEG_CX2341X_VIDEO_LUMA_MEDIAN_FILTER_TOP" );
	#endif
	#ifdef V4L2_CID_MPEG_CX2341X_VIDEO_CHROMA_MEDIAN_FILTER_BOTTOM
		swigIntConstant( V4L2_CID_MPEG_CX2341X_VIDEO_CHROMA_MEDIAN_FILTER_BOTTOM, "V4L2_CID_MPEG_CX2341X_VIDEO_CHROMA_MEDIAN_FILTER_BOTTOM" );
	#endif
	#ifdef V4L2_CID_MPEG_CX2341X_VIDEO_CHROMA_MEDIAN_FILTER_TOP
		swigIntConstant( V4L2_CID_MPEG_CX2341X_VIDEO_CHROMA_MEDIAN_FILTER_TOP, "V4L2_CID_MPEG_CX2341X_VIDEO_CHROMA_MEDIAN_FILTER_TOP" );
	#endif
	#ifdef V4L2_CID_MPEG_CX2341X_STREAM_INSERT_NAV_PACKETS
		swigIntConstant( V4L2_CID_MPEG_CX2341X_STREAM_INSERT_NAV_PACKETS, "V4L2_CID_MPEG_CX2341X_STREAM_INSERT_NAV_PACKETS" );
	#endif
	#ifdef V4L2_CID_CODEC_MFC51_BASE
		swigIntConstant( V4L2_CID_CODEC_MFC51_BASE, "V4L2_CID_CODEC_MFC51_BASE" );
	#endif
	#ifdef V4L2_CID_MPEG_MFC51_VIDEO_DECODER_H264_DISPLAY_DELAY
		swigIntConstant( V4L2_CID_MPEG_MFC51_VIDEO_DECODER_H264_DISPLAY_DELAY, "V4L2_CID_MPEG_MFC51_VIDEO_DECODER_H264_DISPLAY_DELAY" );
	#endif
	#ifdef V4L2_CID_MPEG_MFC51_VIDEO_DECODER_H264_DISPLAY_DELAY_ENABLE
		swigIntConstant( V4L2_CID_MPEG_MFC51_VIDEO_DECODER_H264_DISPLAY_DELAY_ENABLE, "V4L2_CID_MPEG_MFC51_VIDEO_DECODER_H264_DISPLAY_DELAY_ENABLE" );
	#endif
	#ifdef V4L2_CID_MPEG_MFC51_VIDEO_FRAME_SKIP_MODE
		swigIntConstant( V4L2_CID_MPEG_MFC51_VIDEO_FRAME_SKIP_MODE, "V4L2_CID_MPEG_MFC51_VIDEO_FRAME_SKIP_MODE" );
	#endif
	#ifdef V4L2_CID_MPEG_MFC51_VIDEO_FORCE_FRAME_TYPE
		swigIntConstant( V4L2_CID_MPEG_MFC51_VIDEO_FORCE_FRAME_TYPE, "V4L2_CID_MPEG_MFC51_VIDEO_FORCE_FRAME_TYPE" );
	#endif
	#ifdef V4L2_CID_MPEG_MFC51_VIDEO_PADDING
		swigIntConstant( V4L2_CID_MPEG_MFC51_VIDEO_PADDING, "V4L2_CID_MPEG_MFC51_VIDEO_PADDING" );
	#endif
	#ifdef V4L2_CID_MPEG_MFC51_VIDEO_PADDING_YUV
		swigIntConstant( V4L2_CID_MPEG_MFC51_VIDEO_PADDING_YUV, "V4L2_CID_MPEG_MFC51_VIDEO_PADDING_YUV" );
	#endif
	#ifdef V4L2_CID_MPEG_MFC51_VIDEO_RC_FIXED_TARGET_BIT
		swigIntConstant( V4L2_CID_MPEG_MFC51_VIDEO_RC_FIXED_TARGET_BIT, "V4L2_CID_MPEG_MFC51_VIDEO_RC_FIXED_TARGET_BIT" );
	#endif
	#ifdef V4L2_CID_MPEG_MFC51_VIDEO_RC_REACTION_COEFF
		swigIntConstant( V4L2_CID_MPEG_MFC51_VIDEO_RC_REACTION_COEFF, "V4L2_CID_MPEG_MFC51_VIDEO_RC_REACTION_COEFF" );
	#endif
	#ifdef V4L2_CID_MPEG_MFC51_VIDEO_H264_ADAPTIVE_RC_ACTIVITY
		swigIntConstant( V4L2_CID_MPEG_MFC51_VIDEO_H264_ADAPTIVE_RC_ACTIVITY, "V4L2_CID_MPEG_MFC51_VIDEO_H264_ADAPTIVE_RC_ACTIVITY" );
	#endif
	#ifdef V4L2_CID_MPEG_MFC51_VIDEO_H264_ADAPTIVE_RC_DARK
		swigIntConstant( V4L2_CID_MPEG_MFC51_VIDEO_H264_ADAPTIVE_RC_DARK, "V4L2_CID_MPEG_MFC51_VIDEO_H264_ADAPTIVE_RC_DARK" );
	#endif
	#ifdef V4L2_CID_MPEG_MFC51_VIDEO_H264_ADAPTIVE_RC_SMOOTH
		swigIntConstant( V4L2_CID_MPEG_MFC51_VIDEO_H264_ADAPTIVE_RC_SMOOTH, "V4L2_CID_MPEG_MFC51_VIDEO_H264_ADAPTIVE_RC_SMOOTH" );
	#endif
	#ifdef V4L2_CID_MPEG_MFC51_VIDEO_H264_ADAPTIVE_RC_STATIC
		swigIntConstant( V4L2_CID_MPEG_MFC51_VIDEO_H264_ADAPTIVE_RC_STATIC, "V4L2_CID_MPEG_MFC51_VIDEO_H264_ADAPTIVE_RC_STATIC" );
	#endif
	#ifdef V4L2_CID_MPEG_MFC51_VIDEO_H264_NUM_REF_PIC_FOR_P
		swigIntConstant( V4L2_CID_MPEG_MFC51_VIDEO_H264_NUM_REF_PIC_FOR_P, "V4L2_CID_MPEG_MFC51_VIDEO_H264_NUM_REF_PIC_FOR_P" );
	#endif
	#ifdef V4L2_CID_CAMERA_CLASS_BASE
		swigIntConstant( V4L2_CID_CAMERA_CLASS_BASE, "V4L2_CID_CAMERA_CLASS_BASE" );
	#endif
	#ifdef V4L2_CID_CAMERA_CLASS
		swigIntConstant( V4L2_CID_CAMERA_CLASS, "V4L2_CID_CAMERA_CLASS" );
	#endif
	#ifdef V4L2_CID_EXPOSURE_AUTO
		swigIntConstant( V4L2_CID_EXPOSURE_AUTO, "V4L2_CID_EXPOSURE_AUTO" );
	#endif
	#ifdef V4L2_CID_EXPOSURE_ABSOLUTE
		swigIntConstant( V4L2_CID_EXPOSURE_ABSOLUTE, "V4L2_CID_EXPOSURE_ABSOLUTE" );
	#endif
	#ifdef V4L2_CID_EXPOSURE_AUTO_PRIORITY
		swigIntConstant( V4L2_CID_EXPOSURE_AUTO_PRIORITY, "V4L2_CID_EXPOSURE_AUTO_PRIORITY" );
	#endif
	#ifdef V4L2_CID_PAN_RELATIVE
		swigIntConstant( V4L2_CID_PAN_RELATIVE, "V4L2_CID_PAN_RELATIVE" );
	#endif
	#ifdef V4L2_CID_TILT_RELATIVE
		swigIntConstant( V4L2_CID_TILT_RELATIVE, "V4L2_CID_TILT_RELATIVE" );
	#endif
	#ifdef V4L2_CID_PAN_RESET
		swigIntConstant( V4L2_CID_PAN_RESET, "V4L2_CID_PAN_RESET" );
	#endif
	#ifdef V4L2_CID_TILT_RESET
		swigIntConstant( V4L2_CID_TILT_RESET, "V4L2_CID_TILT_RESET" );
	#endif
	#ifdef V4L2_CID_PAN_ABSOLUTE
		swigIntConstant( V4L2_CID_PAN_ABSOLUTE, "V4L2_CID_PAN_ABSOLUTE" );
	#endif
	#ifdef V4L2_CID_TILT_ABSOLUTE
		swigIntConstant( V4L2_CID_TILT_ABSOLUTE, "V4L2_CID_TILT_ABSOLUTE" );
	#endif
	#ifdef V4L2_CID_FOCUS_ABSOLUTE
		swigIntConstant( V4L2_CID_FOCUS_ABSOLUTE, "V4L2_CID_FOCUS_ABSOLUTE" );
	#endif
	#ifdef V4L2_CID_FOCUS_RELATIVE
		swigIntConstant( V4L2_CID_FOCUS_RELATIVE, "V4L2_CID_FOCUS_RELATIVE" );
	#endif
	#ifdef V4L2_CID_FOCUS_AUTO
		swigIntConstant( V4L2_CID_FOCUS_AUTO, "V4L2_CID_FOCUS_AUTO" );
	#endif
	#ifdef V4L2_CID_ZOOM_ABSOLUTE
		swigIntConstant( V4L2_CID_ZOOM_ABSOLUTE, "V4L2_CID_ZOOM_ABSOLUTE" );
	#endif
	#ifdef V4L2_CID_ZOOM_RELATIVE
		swigIntConstant( V4L2_CID_ZOOM_RELATIVE, "V4L2_CID_ZOOM_RELATIVE" );
	#endif
	#ifdef V4L2_CID_ZOOM_CONTINUOUS
		swigIntConstant( V4L2_CID_ZOOM_CONTINUOUS, "V4L2_CID_ZOOM_CONTINUOUS" );
	#endif
	#ifdef V4L2_CID_PRIVACY
		swigIntConstant( V4L2_CID_PRIVACY, "V4L2_CID_PRIVACY" );
	#endif
	#ifdef V4L2_CID_IRIS_ABSOLUTE
		swigIntConstant( V4L2_CID_IRIS_ABSOLUTE, "V4L2_CID_IRIS_ABSOLUTE" );
	#endif
	#ifdef V4L2_CID_IRIS_RELATIVE
		swigIntConstant( V4L2_CID_IRIS_RELATIVE, "V4L2_CID_IRIS_RELATIVE" );
	#endif
	#ifdef V4L2_CID_AUTO_EXPOSURE_BIAS
		swigIntConstant( V4L2_CID_AUTO_EXPOSURE_BIAS, "V4L2_CID_AUTO_EXPOSURE_BIAS" );
	#endif
	#ifdef V4L2_CID_AUTO_N_PRESET_WHITE_BALANCE
		swigIntConstant( V4L2_CID_AUTO_N_PRESET_WHITE_BALANCE, "V4L2_CID_AUTO_N_PRESET_WHITE_BALANCE" );
	#endif
	#ifdef V4L2_CID_WIDE_DYNAMIC_RANGE
		swigIntConstant( V4L2_CID_WIDE_DYNAMIC_RANGE, "V4L2_CID_WIDE_DYNAMIC_RANGE" );
	#endif
	#ifdef V4L2_CID_IMAGE_STABILIZATION
		swigIntConstant( V4L2_CID_IMAGE_STABILIZATION, "V4L2_CID_IMAGE_STABILIZATION" );
	#endif
	#ifdef V4L2_CID_ISO_SENSITIVITY
		swigIntConstant( V4L2_CID_ISO_SENSITIVITY, "V4L2_CID_ISO_SENSITIVITY" );
	#endif
	#ifdef V4L2_CID_ISO_SENSITIVITY_AUTO
		swigIntConstant( V4L2_CID_ISO_SENSITIVITY_AUTO, "V4L2_CID_ISO_SENSITIVITY_AUTO" );
	#endif
	#ifdef V4L2_CID_EXPOSURE_METERING
		swigIntConstant( V4L2_CID_EXPOSURE_METERING, "V4L2_CID_EXPOSURE_METERING" );
	#endif
	#ifdef V4L2_CID_SCENE_MODE
		swigIntConstant( V4L2_CID_SCENE_MODE, "V4L2_CID_SCENE_MODE" );
	#endif
	#ifdef V4L2_CID_3A_LOCK
		swigIntConstant( V4L2_CID_3A_LOCK, "V4L2_CID_3A_LOCK" );
	#endif
	#ifdef V4L2_LOCK_EXPOSURE
		swigIntConstant( V4L2_LOCK_EXPOSURE, "V4L2_LOCK_EXPOSURE" );
	#endif
	#ifdef V4L2_LOCK_WHITE_BALANCE
		swigIntConstant( V4L2_LOCK_WHITE_BALANCE, "V4L2_LOCK_WHITE_BALANCE" );
	#endif
	#ifdef V4L2_LOCK_FOCUS
		swigIntConstant( V4L2_LOCK_FOCUS, "V4L2_LOCK_FOCUS" );
	#endif
	#ifdef V4L2_CID_AUTO_FOCUS_START
		swigIntConstant( V4L2_CID_AUTO_FOCUS_START, "V4L2_CID_AUTO_FOCUS_START" );
	#endif
	#ifdef V4L2_CID_AUTO_FOCUS_STOP
		swigIntConstant( V4L2_CID_AUTO_FOCUS_STOP, "V4L2_CID_AUTO_FOCUS_STOP" );
	#endif
	#ifdef V4L2_CID_AUTO_FOCUS_STATUS
		swigIntConstant( V4L2_CID_AUTO_FOCUS_STATUS, "V4L2_CID_AUTO_FOCUS_STATUS" );
	#endif
	#ifdef V4L2_AUTO_FOCUS_STATUS_IDLE
		swigIntConstant( V4L2_AUTO_FOCUS_STATUS_IDLE, "V4L2_AUTO_FOCUS_STATUS_IDLE" );
	#endif
	#ifdef V4L2_AUTO_FOCUS_STATUS_BUSY
		swigIntConstant( V4L2_AUTO_FOCUS_STATUS_BUSY, "V4L2_AUTO_FOCUS_STATUS_BUSY" );
	#endif
	#ifdef V4L2_AUTO_FOCUS_STATUS_REACHED
		swigIntConstant( V4L2_AUTO_FOCUS_STATUS_REACHED, "V4L2_AUTO_FOCUS_STATUS_REACHED" );
	#endif
	#ifdef V4L2_AUTO_FOCUS_STATUS_FAILED
		swigIntConstant( V4L2_AUTO_FOCUS_STATUS_FAILED, "V4L2_AUTO_FOCUS_STATUS_FAILED" );
	#endif
	#ifdef V4L2_CID_AUTO_FOCUS_RANGE
		swigIntConstant( V4L2_CID_AUTO_FOCUS_RANGE, "V4L2_CID_AUTO_FOCUS_RANGE" );
	#endif
	#ifdef V4L2_CID_PAN_SPEED
		swigIntConstant( V4L2_CID_PAN_SPEED, "V4L2_CID_PAN_SPEED" );
	#endif
	#ifdef V4L2_CID_TILT_SPEED
		swigIntConstant( V4L2_CID_TILT_SPEED, "V4L2_CID_TILT_SPEED" );
	#endif
	#ifdef V4L2_CID_CAMERA_ORIENTATION
		swigIntConstant( V4L2_CID_CAMERA_ORIENTATION, "V4L2_CID_CAMERA_ORIENTATION" );
	#endif
	#ifdef V4L2_CAMERA_ORIENTATION_FRONT
		swigIntConstant( V4L2_CAMERA_ORIENTATION_FRONT, "V4L2_CAMERA_ORIENTATION_FRONT" );
	#endif
	#ifdef V4L2_CAMERA_ORIENTATION_BACK
		swigIntConstant( V4L2_CAMERA_ORIENTATION_BACK, "V4L2_CAMERA_ORIENTATION_BACK" );
	#endif
	#ifdef V4L2_CAMERA_ORIENTATION_EXTERNAL
		swigIntConstant( V4L2_CAMERA_ORIENTATION_EXTERNAL, "V4L2_CAMERA_ORIENTATION_EXTERNAL" );
	#endif
	#ifdef V4L2_CID_CAMERA_SENSOR_ROTATION
		swigIntConstant( V4L2_CID_CAMERA_SENSOR_ROTATION, "V4L2_CID_CAMERA_SENSOR_ROTATION" );
	#endif
	#ifdef V4L2_CID_FM_TX_CLASS_BASE
		swigIntConstant( V4L2_CID_FM_TX_CLASS_BASE, "V4L2_CID_FM_TX_CLASS_BASE" );
	#endif
	#ifdef V4L2_CID_FM_TX_CLASS
		swigIntConstant( V4L2_CID_FM_TX_CLASS, "V4L2_CID_FM_TX_CLASS" );
	#endif
	#ifdef V4L2_CID_RDS_TX_DEVIATION
		swigIntConstant( V4L2_CID_RDS_TX_DEVIATION, "V4L2_CID_RDS_TX_DEVIATION" );
	#endif
	#ifdef V4L2_CID_RDS_TX_PI
		swigIntConstant( V4L2_CID_RDS_TX_PI, "V4L2_CID_RDS_TX_PI" );
	#endif
	#ifdef V4L2_CID_RDS_TX_PTY
		swigIntConstant( V4L2_CID_RDS_TX_PTY, "V4L2_CID_RDS_TX_PTY" );
	#endif
	#ifdef V4L2_CID_RDS_TX_PS_NAME
		swigIntConstant( V4L2_CID_RDS_TX_PS_NAME, "V4L2_CID_RDS_TX_PS_NAME" );
	#endif
	#ifdef V4L2_CID_RDS_TX_RADIO_TEXT
		swigIntConstant( V4L2_CID_RDS_TX_RADIO_TEXT, "V4L2_CID_RDS_TX_RADIO_TEXT" );
	#endif
	#ifdef V4L2_CID_RDS_TX_MONO_STEREO
		swigIntConstant( V4L2_CID_RDS_TX_MONO_STEREO, "V4L2_CID_RDS_TX_MONO_STEREO" );
	#endif
	#ifdef V4L2_CID_RDS_TX_ARTIFICIAL_HEAD
		swigIntConstant( V4L2_CID_RDS_TX_ARTIFICIAL_HEAD, "V4L2_CID_RDS_TX_ARTIFICIAL_HEAD" );
	#endif
	#ifdef V4L2_CID_RDS_TX_COMPRESSED
		swigIntConstant( V4L2_CID_RDS_TX_COMPRESSED, "V4L2_CID_RDS_TX_COMPRESSED" );
	#endif
	#ifdef V4L2_CID_RDS_TX_DYNAMIC_PTY
		swigIntConstant( V4L2_CID_RDS_TX_DYNAMIC_PTY, "V4L2_CID_RDS_TX_DYNAMIC_PTY" );
	#endif
	#ifdef V4L2_CID_RDS_TX_TRAFFIC_ANNOUNCEMENT
		swigIntConstant( V4L2_CID_RDS_TX_TRAFFIC_ANNOUNCEMENT, "V4L2_CID_RDS_TX_TRAFFIC_ANNOUNCEMENT" );
	#endif
	#ifdef V4L2_CID_RDS_TX_TRAFFIC_PROGRAM
		swigIntConstant( V4L2_CID_RDS_TX_TRAFFIC_PROGRAM, "V4L2_CID_RDS_TX_TRAFFIC_PROGRAM" );
	#endif
	#ifdef V4L2_CID_RDS_TX_MUSIC_SPEECH
		swigIntConstant( V4L2_CID_RDS_TX_MUSIC_SPEECH, "V4L2_CID_RDS_TX_MUSIC_SPEECH" );
	#endif
	#ifdef V4L2_CID_RDS_TX_ALT_FREQS_ENABLE
		swigIntConstant( V4L2_CID_RDS_TX_ALT_FREQS_ENABLE, "V4L2_CID_RDS_TX_ALT_FREQS_ENABLE" );
	#endif
	#ifdef V4L2_CID_RDS_TX_ALT_FREQS
		swigIntConstant( V4L2_CID_RDS_TX_ALT_FREQS, "V4L2_CID_RDS_TX_ALT_FREQS" );
	#endif
	#ifdef V4L2_CID_AUDIO_LIMITER_ENABLED
		swigIntConstant( V4L2_CID_AUDIO_LIMITER_ENABLED, "V4L2_CID_AUDIO_LIMITER_ENABLED" );
	#endif
	#ifdef V4L2_CID_AUDIO_LIMITER_RELEASE_TIME
		swigIntConstant( V4L2_CID_AUDIO_LIMITER_RELEASE_TIME, "V4L2_CID_AUDIO_LIMITER_RELEASE_TIME" );
	#endif
	#ifdef V4L2_CID_AUDIO_LIMITER_DEVIATION
		swigIntConstant( V4L2_CID_AUDIO_LIMITER_DEVIATION, "V4L2_CID_AUDIO_LIMITER_DEVIATION" );
	#endif
	#ifdef V4L2_CID_AUDIO_COMPRESSION_ENABLED
		swigIntConstant( V4L2_CID_AUDIO_COMPRESSION_ENABLED, "V4L2_CID_AUDIO_COMPRESSION_ENABLED" );
	#endif
	#ifdef V4L2_CID_AUDIO_COMPRESSION_GAIN
		swigIntConstant( V4L2_CID_AUDIO_COMPRESSION_GAIN, "V4L2_CID_AUDIO_COMPRESSION_GAIN" );
	#endif
	#ifdef V4L2_CID_AUDIO_COMPRESSION_THRESHOLD
		swigIntConstant( V4L2_CID_AUDIO_COMPRESSION_THRESHOLD, "V4L2_CID_AUDIO_COMPRESSION_THRESHOLD" );
	#endif
	#ifdef V4L2_CID_AUDIO_COMPRESSION_ATTACK_TIME
		swigIntConstant( V4L2_CID_AUDIO_COMPRESSION_ATTACK_TIME, "V4L2_CID_AUDIO_COMPRESSION_ATTACK_TIME" );
	#endif
	#ifdef V4L2_CID_AUDIO_COMPRESSION_RELEASE_TIME
		swigIntConstant( V4L2_CID_AUDIO_COMPRESSION_RELEASE_TIME, "V4L2_CID_AUDIO_COMPRESSION_RELEASE_TIME" );
	#endif
	#ifdef V4L2_CID_PILOT_TONE_ENABLED
		swigIntConstant( V4L2_CID_PILOT_TONE_ENABLED, "V4L2_CID_PILOT_TONE_ENABLED" );
	#endif
	#ifdef V4L2_CID_PILOT_TONE_DEVIATION
		swigIntConstant( V4L2_CID_PILOT_TONE_DEVIATION, "V4L2_CID_PILOT_TONE_DEVIATION" );
	#endif
	#ifdef V4L2_CID_PILOT_TONE_FREQUENCY
		swigIntConstant( V4L2_CID_PILOT_TONE_FREQUENCY, "V4L2_CID_PILOT_TONE_FREQUENCY" );
	#endif
	#ifdef V4L2_CID_TUNE_PREEMPHASIS
		swigIntConstant( V4L2_CID_TUNE_PREEMPHASIS, "V4L2_CID_TUNE_PREEMPHASIS" );
	#endif
	#ifdef V4L2_CID_TUNE_POWER_LEVEL
		swigIntConstant( V4L2_CID_TUNE_POWER_LEVEL, "V4L2_CID_TUNE_POWER_LEVEL" );
	#endif
	#ifdef V4L2_CID_TUNE_ANTENNA_CAPACITOR
		swigIntConstant( V4L2_CID_TUNE_ANTENNA_CAPACITOR, "V4L2_CID_TUNE_ANTENNA_CAPACITOR" );
	#endif
	#ifdef V4L2_CID_FLASH_CLASS_BASE
		swigIntConstant( V4L2_CID_FLASH_CLASS_BASE, "V4L2_CID_FLASH_CLASS_BASE" );
	#endif
	#ifdef V4L2_CID_FLASH_CLASS
		swigIntConstant( V4L2_CID_FLASH_CLASS, "V4L2_CID_FLASH_CLASS" );
	#endif
	#ifdef V4L2_CID_FLASH_LED_MODE
		swigIntConstant( V4L2_CID_FLASH_LED_MODE, "V4L2_CID_FLASH_LED_MODE" );
	#endif
	#ifdef V4L2_CID_FLASH_STROBE_SOURCE
		swigIntConstant( V4L2_CID_FLASH_STROBE_SOURCE, "V4L2_CID_FLASH_STROBE_SOURCE" );
	#endif
	#ifdef V4L2_CID_FLASH_STROBE
		swigIntConstant( V4L2_CID_FLASH_STROBE, "V4L2_CID_FLASH_STROBE" );
	#endif
	#ifdef V4L2_CID_FLASH_STROBE_STOP
		swigIntConstant( V4L2_CID_FLASH_STROBE_STOP, "V4L2_CID_FLASH_STROBE_STOP" );
	#endif
	#ifdef V4L2_CID_FLASH_STROBE_STATUS
		swigIntConstant( V4L2_CID_FLASH_STROBE_STATUS, "V4L2_CID_FLASH_STROBE_STATUS" );
	#endif
	#ifdef V4L2_CID_FLASH_TIMEOUT
		swigIntConstant( V4L2_CID_FLASH_TIMEOUT, "V4L2_CID_FLASH_TIMEOUT" );
	#endif
	#ifdef V4L2_CID_FLASH_INTENSITY
		swigIntConstant( V4L2_CID_FLASH_INTENSITY, "V4L2_CID_FLASH_INTENSITY" );
	#endif
	#ifdef V4L2_CID_FLASH_TORCH_INTENSITY
		swigIntConstant( V4L2_CID_FLASH_TORCH_INTENSITY, "V4L2_CID_FLASH_TORCH_INTENSITY" );
	#endif
	#ifdef V4L2_CID_FLASH_INDICATOR_INTENSITY
		swigIntConstant( V4L2_CID_FLASH_INDICATOR_INTENSITY, "V4L2_CID_FLASH_INDICATOR_INTENSITY" );
	#endif
	#ifdef V4L2_CID_FLASH_FAULT
		swigIntConstant( V4L2_CID_FLASH_FAULT, "V4L2_CID_FLASH_FAULT" );
	#endif
	#ifdef V4L2_FLASH_FAULT_OVER_VOLTAGE
		swigIntConstant( V4L2_FLASH_FAULT_OVER_VOLTAGE, "V4L2_FLASH_FAULT_OVER_VOLTAGE" );
	#endif
	#ifdef V4L2_FLASH_FAULT_TIMEOUT
		swigIntConstant( V4L2_FLASH_FAULT_TIMEOUT, "V4L2_FLASH_FAULT_TIMEOUT" );
	#endif
	#ifdef V4L2_FLASH_FAULT_OVER_TEMPERATURE
		swigIntConstant( V4L2_FLASH_FAULT_OVER_TEMPERATURE, "V4L2_FLASH_FAULT_OVER_TEMPERATURE" );
	#endif
	#ifdef V4L2_FLASH_FAULT_SHORT_CIRCUIT
		swigIntConstant( V4L2_FLASH_FAULT_SHORT_CIRCUIT, "V4L2_FLASH_FAULT_SHORT_CIRCUIT" );
	#endif
	#ifdef V4L2_FLASH_FAULT_OVER_CURRENT
		swigIntConstant( V4L2_FLASH_FAULT_OVER_CURRENT, "V4L2_FLASH_FAULT_OVER_CURRENT" );
	#endif
	#ifdef V4L2_FLASH_FAULT_INDICATOR
		swigIntConstant( V4L2_FLASH_FAULT_INDICATOR, "V4L2_FLASH_FAULT_INDICATOR" );
	#endif
	#ifdef V4L2_FLASH_FAULT_UNDER_VOLTAGE
		swigIntConstant( V4L2_FLASH_FAULT_UNDER_VOLTAGE, "V4L2_FLASH_FAULT_UNDER_VOLTAGE" );
	#endif
	#ifdef V4L2_FLASH_FAULT_INPUT_VOLTAGE
		swigIntConstant( V4L2_FLASH_FAULT_INPUT_VOLTAGE, "V4L2_FLASH_FAULT_INPUT_VOLTAGE" );
	#endif
	#ifdef V4L2_FLASH_FAULT_LED_OVER_TEMPERATURE
		swigIntConstant( V4L2_FLASH_FAULT_LED_OVER_TEMPERATURE, "V4L2_FLASH_FAULT_LED_OVER_TEMPERATURE" );
	#endif
	#ifdef V4L2_CID_FLASH_CHARGE
		swigIntConstant( V4L2_CID_FLASH_CHARGE, "V4L2_CID_FLASH_CHARGE" );
	#endif
	#ifdef V4L2_CID_FLASH_READY
		swigIntConstant( V4L2_CID_FLASH_READY, "V4L2_CID_FLASH_READY" );
	#endif
	#ifdef V4L2_CID_JPEG_CLASS_BASE
		swigIntConstant( V4L2_CID_JPEG_CLASS_BASE, "V4L2_CID_JPEG_CLASS_BASE" );
	#endif
	#ifdef V4L2_CID_JPEG_CLASS
		swigIntConstant( V4L2_CID_JPEG_CLASS, "V4L2_CID_JPEG_CLASS" );
	#endif
	#ifdef V4L2_CID_JPEG_CHROMA_SUBSAMPLING
		swigIntConstant( V4L2_CID_JPEG_CHROMA_SUBSAMPLING, "V4L2_CID_JPEG_CHROMA_SUBSAMPLING" );
	#endif
	#ifdef V4L2_CID_JPEG_RESTART_INTERVAL
		swigIntConstant( V4L2_CID_JPEG_RESTART_INTERVAL, "V4L2_CID_JPEG_RESTART_INTERVAL" );
	#endif
	#ifdef V4L2_CID_JPEG_COMPRESSION_QUALITY
		swigIntConstant( V4L2_CID_JPEG_COMPRESSION_QUALITY, "V4L2_CID_JPEG_COMPRESSION_QUALITY" );
	#endif
	#ifdef V4L2_CID_JPEG_ACTIVE_MARKER
		swigIntConstant( V4L2_CID_JPEG_ACTIVE_MARKER, "V4L2_CID_JPEG_ACTIVE_MARKER" );
	#endif
	#ifdef V4L2_JPEG_ACTIVE_MARKER_APP0
		swigIntConstant( V4L2_JPEG_ACTIVE_MARKER_APP0, "V4L2_JPEG_ACTIVE_MARKER_APP0" );
	#endif
	#ifdef V4L2_JPEG_ACTIVE_MARKER_APP1
		swigIntConstant( V4L2_JPEG_ACTIVE_MARKER_APP1, "V4L2_JPEG_ACTIVE_MARKER_APP1" );
	#endif
	#ifdef V4L2_JPEG_ACTIVE_MARKER_COM
		swigIntConstant( V4L2_JPEG_ACTIVE_MARKER_COM, "V4L2_JPEG_ACTIVE_MARKER_COM" );
	#endif
	#ifdef V4L2_JPEG_ACTIVE_MARKER_DQT
		swigIntConstant( V4L2_JPEG_ACTIVE_MARKER_DQT, "V4L2_JPEG_ACTIVE_MARKER_DQT" );
	#endif
	#ifdef V4L2_JPEG_ACTIVE_MARKER_DHT
		swigIntConstant( V4L2_JPEG_ACTIVE_MARKER_DHT, "V4L2_JPEG_ACTIVE_MARKER_DHT" );
	#endif
	#ifdef V4L2_CID_IMAGE_SOURCE_CLASS_BASE
		swigIntConstant( V4L2_CID_IMAGE_SOURCE_CLASS_BASE, "V4L2_CID_IMAGE_SOURCE_CLASS_BASE" );
	#endif
	#ifdef V4L2_CID_IMAGE_SOURCE_CLASS
		swigIntConstant( V4L2_CID_IMAGE_SOURCE_CLASS, "V4L2_CID_IMAGE_SOURCE_CLASS" );
	#endif
	#ifdef V4L2_CID_VBLANK
		swigIntConstant( V4L2_CID_VBLANK, "V4L2_CID_VBLANK" );
	#endif
	#ifdef V4L2_CID_HBLANK
		swigIntConstant( V4L2_CID_HBLANK, "V4L2_CID_HBLANK" );
	#endif
	#ifdef V4L2_CID_ANALOGUE_GAIN
		swigIntConstant( V4L2_CID_ANALOGUE_GAIN, "V4L2_CID_ANALOGUE_GAIN" );
	#endif
	#ifdef V4L2_CID_TEST_PATTERN_RED
		swigIntConstant( V4L2_CID_TEST_PATTERN_RED, "V4L2_CID_TEST_PATTERN_RED" );
	#endif
	#ifdef V4L2_CID_TEST_PATTERN_GREENR
		swigIntConstant( V4L2_CID_TEST_PATTERN_GREENR, "V4L2_CID_TEST_PATTERN_GREENR" );
	#endif
	#ifdef V4L2_CID_TEST_PATTERN_BLUE
		swigIntConstant( V4L2_CID_TEST_PATTERN_BLUE, "V4L2_CID_TEST_PATTERN_BLUE" );
	#endif
	#ifdef V4L2_CID_TEST_PATTERN_GREENB
		swigIntConstant( V4L2_CID_TEST_PATTERN_GREENB, "V4L2_CID_TEST_PATTERN_GREENB" );
	#endif
	#ifdef V4L2_CID_UNIT_CELL_SIZE
		swigIntConstant( V4L2_CID_UNIT_CELL_SIZE, "V4L2_CID_UNIT_CELL_SIZE" );
	#endif
	#ifdef V4L2_CID_NOTIFY_GAINS
		swigIntConstant( V4L2_CID_NOTIFY_GAINS, "V4L2_CID_NOTIFY_GAINS" );
	#endif
	#ifdef V4L2_CID_IMAGE_PROC_CLASS_BASE
		swigIntConstant( V4L2_CID_IMAGE_PROC_CLASS_BASE, "V4L2_CID_IMAGE_PROC_CLASS_BASE" );
	#endif
	#ifdef V4L2_CID_IMAGE_PROC_CLASS
		swigIntConstant( V4L2_CID_IMAGE_PROC_CLASS, "V4L2_CID_IMAGE_PROC_CLASS" );
	#endif
	#ifdef V4L2_CID_LINK_FREQ
		swigIntConstant( V4L2_CID_LINK_FREQ, "V4L2_CID_LINK_FREQ" );
	#endif
	#ifdef V4L2_CID_PIXEL_RATE
		swigIntConstant( V4L2_CID_PIXEL_RATE, "V4L2_CID_PIXEL_RATE" );
	#endif
	#ifdef V4L2_CID_TEST_PATTERN
		swigIntConstant( V4L2_CID_TEST_PATTERN, "V4L2_CID_TEST_PATTERN" );
	#endif
	#ifdef V4L2_CID_DEINTERLACING_MODE
		swigIntConstant( V4L2_CID_DEINTERLACING_MODE, "V4L2_CID_DEINTERLACING_MODE" );
	#endif
	#ifdef V4L2_CID_DIGITAL_GAIN
		swigIntConstant( V4L2_CID_DIGITAL_GAIN, "V4L2_CID_DIGITAL_GAIN" );
	#endif
	#ifdef V4L2_CID_DV_CLASS_BASE
		swigIntConstant( V4L2_CID_DV_CLASS_BASE, "V4L2_CID_DV_CLASS_BASE" );
	#endif
	#ifdef V4L2_CID_DV_CLASS
		swigIntConstant( V4L2_CID_DV_CLASS, "V4L2_CID_DV_CLASS" );
	#endif
	#ifdef V4L2_CID_DV_TX_HOTPLUG
		swigIntConstant( V4L2_CID_DV_TX_HOTPLUG, "V4L2_CID_DV_TX_HOTPLUG" );
	#endif
	#ifdef V4L2_CID_DV_TX_RXSENSE
		swigIntConstant( V4L2_CID_DV_TX_RXSENSE, "V4L2_CID_DV_TX_RXSENSE" );
	#endif
	#ifdef V4L2_CID_DV_TX_EDID_PRESENT
		swigIntConstant( V4L2_CID_DV_TX_EDID_PRESENT, "V4L2_CID_DV_TX_EDID_PRESENT" );
	#endif
	#ifdef V4L2_CID_DV_TX_MODE
		swigIntConstant( V4L2_CID_DV_TX_MODE, "V4L2_CID_DV_TX_MODE" );
	#endif
	#ifdef V4L2_CID_DV_TX_RGB_RANGE
		swigIntConstant( V4L2_CID_DV_TX_RGB_RANGE, "V4L2_CID_DV_TX_RGB_RANGE" );
	#endif
	#ifdef V4L2_CID_DV_TX_IT_CONTENT_TYPE
		swigIntConstant( V4L2_CID_DV_TX_IT_CONTENT_TYPE, "V4L2_CID_DV_TX_IT_CONTENT_TYPE" );
	#endif
	#ifdef V4L2_CID_DV_RX_POWER_PRESENT
		swigIntConstant( V4L2_CID_DV_RX_POWER_PRESENT, "V4L2_CID_DV_RX_POWER_PRESENT" );
	#endif
	#ifdef V4L2_CID_DV_RX_RGB_RANGE
		swigIntConstant( V4L2_CID_DV_RX_RGB_RANGE, "V4L2_CID_DV_RX_RGB_RANGE" );
	#endif
	#ifdef V4L2_CID_DV_RX_IT_CONTENT_TYPE
		swigIntConstant( V4L2_CID_DV_RX_IT_CONTENT_TYPE, "V4L2_CID_DV_RX_IT_CONTENT_TYPE" );
	#endif
	#ifdef V4L2_CID_FM_RX_CLASS_BASE
		swigIntConstant( V4L2_CID_FM_RX_CLASS_BASE, "V4L2_CID_FM_RX_CLASS_BASE" );
	#endif
	#ifdef V4L2_CID_FM_RX_CLASS
		swigIntConstant( V4L2_CID_FM_RX_CLASS, "V4L2_CID_FM_RX_CLASS" );
	#endif
	#ifdef V4L2_CID_TUNE_DEEMPHASIS
		swigIntConstant( V4L2_CID_TUNE_DEEMPHASIS, "V4L2_CID_TUNE_DEEMPHASIS" );
	#endif
	#ifdef V4L2_CID_RDS_RECEPTION
		swigIntConstant( V4L2_CID_RDS_RECEPTION, "V4L2_CID_RDS_RECEPTION" );
	#endif
	#ifdef V4L2_CID_RDS_RX_PTY
		swigIntConstant( V4L2_CID_RDS_RX_PTY, "V4L2_CID_RDS_RX_PTY" );
	#endif
	#ifdef V4L2_CID_RDS_RX_PS_NAME
		swigIntConstant( V4L2_CID_RDS_RX_PS_NAME, "V4L2_CID_RDS_RX_PS_NAME" );
	#endif
	#ifdef V4L2_CID_RDS_RX_RADIO_TEXT
		swigIntConstant( V4L2_CID_RDS_RX_RADIO_TEXT, "V4L2_CID_RDS_RX_RADIO_TEXT" );
	#endif
	#ifdef V4L2_CID_RDS_RX_TRAFFIC_ANNOUNCEMENT
		swigIntConstant( V4L2_CID_RDS_RX_TRAFFIC_ANNOUNCEMENT, "V4L2_CID_RDS_RX_TRAFFIC_ANNOUNCEMENT" );
	#endif
	#ifdef V4L2_CID_RDS_RX_TRAFFIC_PROGRAM
		swigIntConstant( V4L2_CID_RDS_RX_TRAFFIC_PROGRAM, "V4L2_CID_RDS_RX_TRAFFIC_PROGRAM" );
	#endif
	#ifdef V4L2_CID_RDS_RX_MUSIC_SPEECH
		swigIntConstant( V4L2_CID_RDS_RX_MUSIC_SPEECH, "V4L2_CID_RDS_RX_MUSIC_SPEECH" );
	#endif
	#ifdef V4L2_CID_RF_TUNER_CLASS_BASE
		swigIntConstant( V4L2_CID_RF_TUNER_CLASS_BASE, "V4L2_CID_RF_TUNER_CLASS_BASE" );
	#endif
	#ifdef V4L2_CID_RF_TUNER_CLASS
		swigIntConstant( V4L2_CID_RF_TUNER_CLASS, "V4L2_CID_RF_TUNER_CLASS" );
	#endif
	#ifdef V4L2_CID_RF_TUNER_BANDWIDTH_AUTO
		swigIntConstant( V4L2_CID_RF_TUNER_BANDWIDTH_AUTO, "V4L2_CID_RF_TUNER_BANDWIDTH_AUTO" );
	#endif
	#ifdef V4L2_CID_RF_TUNER_BANDWIDTH
		swigIntConstant( V4L2_CID_RF_TUNER_BANDWIDTH, "V4L2_CID_RF_TUNER_BANDWIDTH" );
	#endif
	#ifdef V4L2_CID_RF_TUNER_RF_GAIN
		swigIntConstant( V4L2_CID_RF_TUNER_RF_GAIN, "V4L2_CID_RF_TUNER_RF_GAIN" );
	#endif
	#ifdef V4L2_CID_RF_TUNER_LNA_GAIN_AUTO
		swigIntConstant( V4L2_CID_RF_TUNER_LNA_GAIN_AUTO, "V4L2_CID_RF_TUNER_LNA_GAIN_AUTO" );
	#endif
	#ifdef V4L2_CID_RF_TUNER_LNA_GAIN
		swigIntConstant( V4L2_CID_RF_TUNER_LNA_GAIN, "V4L2_CID_RF_TUNER_LNA_GAIN" );
	#endif
	#ifdef V4L2_CID_RF_TUNER_MIXER_GAIN_AUTO
		swigIntConstant( V4L2_CID_RF_TUNER_MIXER_GAIN_AUTO, "V4L2_CID_RF_TUNER_MIXER_GAIN_AUTO" );
	#endif
	#ifdef V4L2_CID_RF_TUNER_MIXER_GAIN
		swigIntConstant( V4L2_CID_RF_TUNER_MIXER_GAIN, "V4L2_CID_RF_TUNER_MIXER_GAIN" );
	#endif
	#ifdef V4L2_CID_RF_TUNER_IF_GAIN_AUTO
		swigIntConstant( V4L2_CID_RF_TUNER_IF_GAIN_AUTO, "V4L2_CID_RF_TUNER_IF_GAIN_AUTO" );
	#endif
	#ifdef V4L2_CID_RF_TUNER_IF_GAIN
		swigIntConstant( V4L2_CID_RF_TUNER_IF_GAIN, "V4L2_CID_RF_TUNER_IF_GAIN" );
	#endif
	#ifdef V4L2_CID_RF_TUNER_PLL_LOCK
		swigIntConstant( V4L2_CID_RF_TUNER_PLL_LOCK, "V4L2_CID_RF_TUNER_PLL_LOCK" );
	#endif
	#ifdef V4L2_CID_DETECT_CLASS_BASE
		swigIntConstant( V4L2_CID_DETECT_CLASS_BASE, "V4L2_CID_DETECT_CLASS_BASE" );
	#endif
	#ifdef V4L2_CID_DETECT_CLASS
		swigIntConstant( V4L2_CID_DETECT_CLASS, "V4L2_CID_DETECT_CLASS" );
	#endif
	#ifdef V4L2_CID_DETECT_MD_MODE
		swigIntConstant( V4L2_CID_DETECT_MD_MODE, "V4L2_CID_DETECT_MD_MODE" );
	#endif
	#ifdef V4L2_CID_DETECT_MD_GLOBAL_THRESHOLD
		swigIntConstant( V4L2_CID_DETECT_MD_GLOBAL_THRESHOLD, "V4L2_CID_DETECT_MD_GLOBAL_THRESHOLD" );
	#endif
	#ifdef V4L2_CID_DETECT_MD_THRESHOLD_GRID
		swigIntConstant( V4L2_CID_DETECT_MD_THRESHOLD_GRID, "V4L2_CID_DETECT_MD_THRESHOLD_GRID" );
	#endif
	#ifdef V4L2_CID_DETECT_MD_REGION_GRID
		swigIntConstant( V4L2_CID_DETECT_MD_REGION_GRID, "V4L2_CID_DETECT_MD_REGION_GRID" );
	#endif
	#ifdef V4L2_CID_CODEC_STATELESS_BASE
		swigIntConstant( V4L2_CID_CODEC_STATELESS_BASE, "V4L2_CID_CODEC_STATELESS_BASE" );
	#endif
	#ifdef V4L2_CID_CODEC_STATELESS_CLASS
		swigIntConstant( V4L2_CID_CODEC_STATELESS_CLASS, "V4L2_CID_CODEC_STATELESS_CLASS" );
	#endif
	#ifdef V4L2_CID_STATELESS_H264_DECODE_MODE
		swigIntConstant( V4L2_CID_STATELESS_H264_DECODE_MODE, "V4L2_CID_STATELESS_H264_DECODE_MODE" );
	#endif
	#ifdef V4L2_CID_STATELESS_H264_START_CODE
		swigIntConstant( V4L2_CID_STATELESS_H264_START_CODE, "V4L2_CID_STATELESS_H264_START_CODE" );
	#endif
	#ifdef V4L2_H264_SPS_CONSTRAINT_SET0_FLAG
		swigIntConstant( V4L2_H264_SPS_CONSTRAINT_SET0_FLAG, "V4L2_H264_SPS_CONSTRAINT_SET0_FLAG" );
	#endif
	#ifdef V4L2_H264_SPS_CONSTRAINT_SET1_FLAG
		swigIntConstant( V4L2_H264_SPS_CONSTRAINT_SET1_FLAG, "V4L2_H264_SPS_CONSTRAINT_SET1_FLAG" );
	#endif
	#ifdef V4L2_H264_SPS_CONSTRAINT_SET2_FLAG
		swigIntConstant( V4L2_H264_SPS_CONSTRAINT_SET2_FLAG, "V4L2_H264_SPS_CONSTRAINT_SET2_FLAG" );
	#endif
	#ifdef V4L2_H264_SPS_CONSTRAINT_SET3_FLAG
		swigIntConstant( V4L2_H264_SPS_CONSTRAINT_SET3_FLAG, "V4L2_H264_SPS_CONSTRAINT_SET3_FLAG" );
	#endif
	#ifdef V4L2_H264_SPS_CONSTRAINT_SET4_FLAG
		swigIntConstant( V4L2_H264_SPS_CONSTRAINT_SET4_FLAG, "V4L2_H264_SPS_CONSTRAINT_SET4_FLAG" );
	#endif
	#ifdef V4L2_H264_SPS_CONSTRAINT_SET5_FLAG
		swigIntConstant( V4L2_H264_SPS_CONSTRAINT_SET5_FLAG, "V4L2_H264_SPS_CONSTRAINT_SET5_FLAG" );
	#endif
	#ifdef V4L2_H264_SPS_FLAG_SEPARATE_COLOUR_PLANE
		swigIntConstant( V4L2_H264_SPS_FLAG_SEPARATE_COLOUR_PLANE, "V4L2_H264_SPS_FLAG_SEPARATE_COLOUR_PLANE" );
	#endif
	#ifdef V4L2_H264_SPS_FLAG_QPPRIME_Y_ZERO_TRANSFORM_BYPASS
		swigIntConstant( V4L2_H264_SPS_FLAG_QPPRIME_Y_ZERO_TRANSFORM_BYPASS, "V4L2_H264_SPS_FLAG_QPPRIME_Y_ZERO_TRANSFORM_BYPASS" );
	#endif
	#ifdef V4L2_H264_SPS_FLAG_DELTA_PIC_ORDER_ALWAYS_ZERO
		swigIntConstant( V4L2_H264_SPS_FLAG_DELTA_PIC_ORDER_ALWAYS_ZERO, "V4L2_H264_SPS_FLAG_DELTA_PIC_ORDER_ALWAYS_ZERO" );
	#endif
	#ifdef V4L2_H264_SPS_FLAG_GAPS_IN_FRAME_NUM_VALUE_ALLOWED
		swigIntConstant( V4L2_H264_SPS_FLAG_GAPS_IN_FRAME_NUM_VALUE_ALLOWED, "V4L2_H264_SPS_FLAG_GAPS_IN_FRAME_NUM_VALUE_ALLOWED" );
	#endif
	#ifdef V4L2_H264_SPS_FLAG_FRAME_MBS_ONLY
		swigIntConstant( V4L2_H264_SPS_FLAG_FRAME_MBS_ONLY, "V4L2_H264_SPS_FLAG_FRAME_MBS_ONLY" );
	#endif
	#ifdef V4L2_H264_SPS_FLAG_MB_ADAPTIVE_FRAME_FIELD
		swigIntConstant( V4L2_H264_SPS_FLAG_MB_ADAPTIVE_FRAME_FIELD, "V4L2_H264_SPS_FLAG_MB_ADAPTIVE_FRAME_FIELD" );
	#endif
	#ifdef V4L2_H264_SPS_FLAG_DIRECT_8X8_INFERENCE
		swigIntConstant( V4L2_H264_SPS_FLAG_DIRECT_8X8_INFERENCE, "V4L2_H264_SPS_FLAG_DIRECT_8X8_INFERENCE" );
	#endif
	#ifdef V4L2_CID_STATELESS_H264_SPS
		swigIntConstant( V4L2_CID_STATELESS_H264_SPS, "V4L2_CID_STATELESS_H264_SPS" );
	#endif
	#ifdef V4L2_H264_PPS_FLAG_ENTROPY_CODING_MODE
		swigIntConstant( V4L2_H264_PPS_FLAG_ENTROPY_CODING_MODE, "V4L2_H264_PPS_FLAG_ENTROPY_CODING_MODE" );
	#endif
	#ifdef V4L2_H264_PPS_FLAG_BOTTOM_FIELD_PIC_ORDER_IN_FRAME_PRESENT
		swigIntConstant( V4L2_H264_PPS_FLAG_BOTTOM_FIELD_PIC_ORDER_IN_FRAME_PRESENT, "V4L2_H264_PPS_FLAG_BOTTOM_FIELD_PIC_ORDER_IN_FRAME_PRESENT" );
	#endif
	#ifdef V4L2_H264_PPS_FLAG_WEIGHTED_PRED
		swigIntConstant( V4L2_H264_PPS_FLAG_WEIGHTED_PRED, "V4L2_H264_PPS_FLAG_WEIGHTED_PRED" );
	#endif
	#ifdef V4L2_H264_PPS_FLAG_DEBLOCKING_FILTER_CONTROL_PRESENT
		swigIntConstant( V4L2_H264_PPS_FLAG_DEBLOCKING_FILTER_CONTROL_PRESENT, "V4L2_H264_PPS_FLAG_DEBLOCKING_FILTER_CONTROL_PRESENT" );
	#endif
	#ifdef V4L2_H264_PPS_FLAG_CONSTRAINED_INTRA_PRED
		swigIntConstant( V4L2_H264_PPS_FLAG_CONSTRAINED_INTRA_PRED, "V4L2_H264_PPS_FLAG_CONSTRAINED_INTRA_PRED" );
	#endif
	#ifdef V4L2_H264_PPS_FLAG_REDUNDANT_PIC_CNT_PRESENT
		swigIntConstant( V4L2_H264_PPS_FLAG_REDUNDANT_PIC_CNT_PRESENT, "V4L2_H264_PPS_FLAG_REDUNDANT_PIC_CNT_PRESENT" );
	#endif
	#ifdef V4L2_H264_PPS_FLAG_TRANSFORM_8X8_MODE
		swigIntConstant( V4L2_H264_PPS_FLAG_TRANSFORM_8X8_MODE, "V4L2_H264_PPS_FLAG_TRANSFORM_8X8_MODE" );
	#endif
	#ifdef V4L2_H264_PPS_FLAG_SCALING_MATRIX_PRESENT
		swigIntConstant( V4L2_H264_PPS_FLAG_SCALING_MATRIX_PRESENT, "V4L2_H264_PPS_FLAG_SCALING_MATRIX_PRESENT" );
	#endif
	#ifdef V4L2_CID_STATELESS_H264_PPS
		swigIntConstant( V4L2_CID_STATELESS_H264_PPS, "V4L2_CID_STATELESS_H264_PPS" );
	#endif
	#ifdef V4L2_CID_STATELESS_H264_SCALING_MATRIX
		swigIntConstant( V4L2_CID_STATELESS_H264_SCALING_MATRIX, "V4L2_CID_STATELESS_H264_SCALING_MATRIX" );
	#endif
	#ifdef V4L2_CID_STATELESS_H264_PRED_WEIGHTS
		swigIntConstant( V4L2_CID_STATELESS_H264_PRED_WEIGHTS, "V4L2_CID_STATELESS_H264_PRED_WEIGHTS" );
	#endif
	#ifdef V4L2_H264_SLICE_TYPE_P
		swigIntConstant( V4L2_H264_SLICE_TYPE_P, "V4L2_H264_SLICE_TYPE_P" );
	#endif
	#ifdef V4L2_H264_SLICE_TYPE_B
		swigIntConstant( V4L2_H264_SLICE_TYPE_B, "V4L2_H264_SLICE_TYPE_B" );
	#endif
	#ifdef V4L2_H264_SLICE_TYPE_I
		swigIntConstant( V4L2_H264_SLICE_TYPE_I, "V4L2_H264_SLICE_TYPE_I" );
	#endif
	#ifdef V4L2_H264_SLICE_TYPE_SP
		swigIntConstant( V4L2_H264_SLICE_TYPE_SP, "V4L2_H264_SLICE_TYPE_SP" );
	#endif
	#ifdef V4L2_H264_SLICE_TYPE_SI
		swigIntConstant( V4L2_H264_SLICE_TYPE_SI, "V4L2_H264_SLICE_TYPE_SI" );
	#endif
	#ifdef V4L2_H264_SLICE_FLAG_DIRECT_SPATIAL_MV_PRED
		swigIntConstant( V4L2_H264_SLICE_FLAG_DIRECT_SPATIAL_MV_PRED, "V4L2_H264_SLICE_FLAG_DIRECT_SPATIAL_MV_PRED" );
	#endif
	#ifdef V4L2_H264_SLICE_FLAG_SP_FOR_SWITCH
		swigIntConstant( V4L2_H264_SLICE_FLAG_SP_FOR_SWITCH, "V4L2_H264_SLICE_FLAG_SP_FOR_SWITCH" );
	#endif
	#ifdef V4L2_H264_TOP_FIELD_REF
		swigIntConstant( V4L2_H264_TOP_FIELD_REF, "V4L2_H264_TOP_FIELD_REF" );
	#endif
	#ifdef V4L2_H264_BOTTOM_FIELD_REF
		swigIntConstant( V4L2_H264_BOTTOM_FIELD_REF, "V4L2_H264_BOTTOM_FIELD_REF" );
	#endif
	#ifdef V4L2_H264_FRAME_REF
		swigIntConstant( V4L2_H264_FRAME_REF, "V4L2_H264_FRAME_REF" );
	#endif
	#ifdef V4L2_H264_NUM_DPB_ENTRIES
		swigIntConstant( V4L2_H264_NUM_DPB_ENTRIES, "V4L2_H264_NUM_DPB_ENTRIES" );
	#endif
	#ifdef V4L2_H264_REF_LIST_LEN
		swigIntConstant( V4L2_H264_REF_LIST_LEN, "V4L2_H264_REF_LIST_LEN" );
	#endif
	#ifdef V4L2_CID_STATELESS_H264_SLICE_PARAMS
		swigIntConstant( V4L2_CID_STATELESS_H264_SLICE_PARAMS, "V4L2_CID_STATELESS_H264_SLICE_PARAMS" );
	#endif
	#ifdef V4L2_H264_DPB_ENTRY_FLAG_VALID
		swigIntConstant( V4L2_H264_DPB_ENTRY_FLAG_VALID, "V4L2_H264_DPB_ENTRY_FLAG_VALID" );
	#endif
	#ifdef V4L2_H264_DPB_ENTRY_FLAG_ACTIVE
		swigIntConstant( V4L2_H264_DPB_ENTRY_FLAG_ACTIVE, "V4L2_H264_DPB_ENTRY_FLAG_ACTIVE" );
	#endif
	#ifdef V4L2_H264_DPB_ENTRY_FLAG_LONG_TERM
		swigIntConstant( V4L2_H264_DPB_ENTRY_FLAG_LONG_TERM, "V4L2_H264_DPB_ENTRY_FLAG_LONG_TERM" );
	#endif
	#ifdef V4L2_H264_DPB_ENTRY_FLAG_FIELD
		swigIntConstant( V4L2_H264_DPB_ENTRY_FLAG_FIELD, "V4L2_H264_DPB_ENTRY_FLAG_FIELD" );
	#endif
	#ifdef V4L2_H264_DECODE_PARAM_FLAG_IDR_PIC
		swigIntConstant( V4L2_H264_DECODE_PARAM_FLAG_IDR_PIC, "V4L2_H264_DECODE_PARAM_FLAG_IDR_PIC" );
	#endif
	#ifdef V4L2_H264_DECODE_PARAM_FLAG_FIELD_PIC
		swigIntConstant( V4L2_H264_DECODE_PARAM_FLAG_FIELD_PIC, "V4L2_H264_DECODE_PARAM_FLAG_FIELD_PIC" );
	#endif
	#ifdef V4L2_H264_DECODE_PARAM_FLAG_BOTTOM_FIELD
		swigIntConstant( V4L2_H264_DECODE_PARAM_FLAG_BOTTOM_FIELD, "V4L2_H264_DECODE_PARAM_FLAG_BOTTOM_FIELD" );
	#endif
	#ifdef V4L2_CID_STATELESS_H264_DECODE_PARAMS
		swigIntConstant( V4L2_CID_STATELESS_H264_DECODE_PARAMS, "V4L2_CID_STATELESS_H264_DECODE_PARAMS" );
	#endif
	#ifdef V4L2_FWHT_VERSION
		swigIntConstant( V4L2_FWHT_VERSION, "V4L2_FWHT_VERSION" );
	#endif
	#ifdef V4L2_FWHT_FL_COMPONENTS_NUM_OFFSET
		swigIntConstant( V4L2_FWHT_FL_COMPONENTS_NUM_OFFSET, "V4L2_FWHT_FL_COMPONENTS_NUM_OFFSET" );
	#endif
	#ifdef V4L2_FWHT_FL_PIXENC_OFFSET
		swigIntConstant( V4L2_FWHT_FL_PIXENC_OFFSET, "V4L2_FWHT_FL_PIXENC_OFFSET" );
	#endif
	#ifdef V4L2_FWHT_FL_PIXENC_YUV
		swigIntConstant( V4L2_FWHT_FL_PIXENC_YUV, "V4L2_FWHT_FL_PIXENC_YUV" );
	#endif
	#ifdef V4L2_FWHT_FL_PIXENC_RGB
		swigIntConstant( V4L2_FWHT_FL_PIXENC_RGB, "V4L2_FWHT_FL_PIXENC_RGB" );
	#endif
	#ifdef V4L2_FWHT_FL_PIXENC_HSV
		swigIntConstant( V4L2_FWHT_FL_PIXENC_HSV, "V4L2_FWHT_FL_PIXENC_HSV" );
	#endif
	#ifdef V4L2_CID_STATELESS_FWHT_PARAMS
		swigIntConstant( V4L2_CID_STATELESS_FWHT_PARAMS, "V4L2_CID_STATELESS_FWHT_PARAMS" );
	#endif
	#ifdef V4L2_VP8_SEGMENT_FLAG_ENABLED
		swigIntConstant( V4L2_VP8_SEGMENT_FLAG_ENABLED, "V4L2_VP8_SEGMENT_FLAG_ENABLED" );
	#endif
	#ifdef V4L2_VP8_SEGMENT_FLAG_UPDATE_MAP
		swigIntConstant( V4L2_VP8_SEGMENT_FLAG_UPDATE_MAP, "V4L2_VP8_SEGMENT_FLAG_UPDATE_MAP" );
	#endif
	#ifdef V4L2_VP8_SEGMENT_FLAG_UPDATE_FEATURE_DATA
		swigIntConstant( V4L2_VP8_SEGMENT_FLAG_UPDATE_FEATURE_DATA, "V4L2_VP8_SEGMENT_FLAG_UPDATE_FEATURE_DATA" );
	#endif
	#ifdef V4L2_VP8_SEGMENT_FLAG_DELTA_VALUE_MODE
		swigIntConstant( V4L2_VP8_SEGMENT_FLAG_DELTA_VALUE_MODE, "V4L2_VP8_SEGMENT_FLAG_DELTA_VALUE_MODE" );
	#endif
	#ifdef V4L2_VP8_LF_ADJ_ENABLE
		swigIntConstant( V4L2_VP8_LF_ADJ_ENABLE, "V4L2_VP8_LF_ADJ_ENABLE" );
	#endif
	#ifdef V4L2_VP8_LF_DELTA_UPDATE
		swigIntConstant( V4L2_VP8_LF_DELTA_UPDATE, "V4L2_VP8_LF_DELTA_UPDATE" );
	#endif
	#ifdef V4L2_VP8_LF_FILTER_TYPE_SIMPLE
		swigIntConstant( V4L2_VP8_LF_FILTER_TYPE_SIMPLE, "V4L2_VP8_LF_FILTER_TYPE_SIMPLE" );
	#endif
	#ifdef V4L2_VP8_COEFF_PROB_CNT
		swigIntConstant( V4L2_VP8_COEFF_PROB_CNT, "V4L2_VP8_COEFF_PROB_CNT" );
	#endif
	#ifdef V4L2_VP8_MV_PROB_CNT
		swigIntConstant( V4L2_VP8_MV_PROB_CNT, "V4L2_VP8_MV_PROB_CNT" );
	#endif
	#ifdef V4L2_VP8_FRAME_FLAG_KEY_FRAME
		swigIntConstant( V4L2_VP8_FRAME_FLAG_KEY_FRAME, "V4L2_VP8_FRAME_FLAG_KEY_FRAME" );
	#endif
	#ifdef V4L2_VP8_FRAME_FLAG_EXPERIMENTAL
		swigIntConstant( V4L2_VP8_FRAME_FLAG_EXPERIMENTAL, "V4L2_VP8_FRAME_FLAG_EXPERIMENTAL" );
	#endif
	#ifdef V4L2_VP8_FRAME_FLAG_SHOW_FRAME
		swigIntConstant( V4L2_VP8_FRAME_FLAG_SHOW_FRAME, "V4L2_VP8_FRAME_FLAG_SHOW_FRAME" );
	#endif
	#ifdef V4L2_VP8_FRAME_FLAG_MB_NO_SKIP_COEFF
		swigIntConstant( V4L2_VP8_FRAME_FLAG_MB_NO_SKIP_COEFF, "V4L2_VP8_FRAME_FLAG_MB_NO_SKIP_COEFF" );
	#endif
	#ifdef V4L2_VP8_FRAME_FLAG_SIGN_BIAS_GOLDEN
		swigIntConstant( V4L2_VP8_FRAME_FLAG_SIGN_BIAS_GOLDEN, "V4L2_VP8_FRAME_FLAG_SIGN_BIAS_GOLDEN" );
	#endif
	#ifdef V4L2_VP8_FRAME_FLAG_SIGN_BIAS_ALT
		swigIntConstant( V4L2_VP8_FRAME_FLAG_SIGN_BIAS_ALT, "V4L2_VP8_FRAME_FLAG_SIGN_BIAS_ALT" );
	#endif
	#ifdef V4L2_CID_STATELESS_VP8_FRAME
		swigIntConstant( V4L2_CID_STATELESS_VP8_FRAME, "V4L2_CID_STATELESS_VP8_FRAME" );
	#endif
	#ifdef V4L2_MPEG2_SEQ_FLAG_PROGRESSIVE
		swigIntConstant( V4L2_MPEG2_SEQ_FLAG_PROGRESSIVE, "V4L2_MPEG2_SEQ_FLAG_PROGRESSIVE" );
	#endif
	#ifdef V4L2_CID_STATELESS_MPEG2_SEQUENCE
		swigIntConstant( V4L2_CID_STATELESS_MPEG2_SEQUENCE, "V4L2_CID_STATELESS_MPEG2_SEQUENCE" );
	#endif
	#ifdef V4L2_MPEG2_PIC_CODING_TYPE_I
		swigIntConstant( V4L2_MPEG2_PIC_CODING_TYPE_I, "V4L2_MPEG2_PIC_CODING_TYPE_I" );
	#endif
	#ifdef V4L2_MPEG2_PIC_CODING_TYPE_P
		swigIntConstant( V4L2_MPEG2_PIC_CODING_TYPE_P, "V4L2_MPEG2_PIC_CODING_TYPE_P" );
	#endif
	#ifdef V4L2_MPEG2_PIC_CODING_TYPE_B
		swigIntConstant( V4L2_MPEG2_PIC_CODING_TYPE_B, "V4L2_MPEG2_PIC_CODING_TYPE_B" );
	#endif
	#ifdef V4L2_MPEG2_PIC_CODING_TYPE_D
		swigIntConstant( V4L2_MPEG2_PIC_CODING_TYPE_D, "V4L2_MPEG2_PIC_CODING_TYPE_D" );
	#endif
	#ifdef V4L2_MPEG2_PIC_TOP_FIELD
		swigIntConstant( V4L2_MPEG2_PIC_TOP_FIELD, "V4L2_MPEG2_PIC_TOP_FIELD" );
	#endif
	#ifdef V4L2_MPEG2_PIC_BOTTOM_FIELD
		swigIntConstant( V4L2_MPEG2_PIC_BOTTOM_FIELD, "V4L2_MPEG2_PIC_BOTTOM_FIELD" );
	#endif
	#ifdef V4L2_MPEG2_PIC_FRAME
		swigIntConstant( V4L2_MPEG2_PIC_FRAME, "V4L2_MPEG2_PIC_FRAME" );
	#endif
	#ifdef V4L2_MPEG2_PIC_FLAG_TOP_FIELD_FIRST
		swigIntConstant( V4L2_MPEG2_PIC_FLAG_TOP_FIELD_FIRST, "V4L2_MPEG2_PIC_FLAG_TOP_FIELD_FIRST" );
	#endif
	#ifdef V4L2_MPEG2_PIC_FLAG_FRAME_PRED_DCT
		swigIntConstant( V4L2_MPEG2_PIC_FLAG_FRAME_PRED_DCT, "V4L2_MPEG2_PIC_FLAG_FRAME_PRED_DCT" );
	#endif
	#ifdef V4L2_MPEG2_PIC_FLAG_CONCEALMENT_MV
		swigIntConstant( V4L2_MPEG2_PIC_FLAG_CONCEALMENT_MV, "V4L2_MPEG2_PIC_FLAG_CONCEALMENT_MV" );
	#endif
	#ifdef V4L2_MPEG2_PIC_FLAG_Q_SCALE_TYPE
		swigIntConstant( V4L2_MPEG2_PIC_FLAG_Q_SCALE_TYPE, "V4L2_MPEG2_PIC_FLAG_Q_SCALE_TYPE" );
	#endif
	#ifdef V4L2_MPEG2_PIC_FLAG_INTRA_VLC
		swigIntConstant( V4L2_MPEG2_PIC_FLAG_INTRA_VLC, "V4L2_MPEG2_PIC_FLAG_INTRA_VLC" );
	#endif
	#ifdef V4L2_MPEG2_PIC_FLAG_ALT_SCAN
		swigIntConstant( V4L2_MPEG2_PIC_FLAG_ALT_SCAN, "V4L2_MPEG2_PIC_FLAG_ALT_SCAN" );
	#endif
	#ifdef V4L2_MPEG2_PIC_FLAG_REPEAT_FIRST
		swigIntConstant( V4L2_MPEG2_PIC_FLAG_REPEAT_FIRST, "V4L2_MPEG2_PIC_FLAG_REPEAT_FIRST" );
	#endif
	#ifdef V4L2_MPEG2_PIC_FLAG_PROGRESSIVE
		swigIntConstant( V4L2_MPEG2_PIC_FLAG_PROGRESSIVE, "V4L2_MPEG2_PIC_FLAG_PROGRESSIVE" );
	#endif
	#ifdef V4L2_CID_STATELESS_MPEG2_PICTURE
		swigIntConstant( V4L2_CID_STATELESS_MPEG2_PICTURE, "V4L2_CID_STATELESS_MPEG2_PICTURE" );
	#endif
	#ifdef V4L2_CID_STATELESS_MPEG2_QUANTISATION
		swigIntConstant( V4L2_CID_STATELESS_MPEG2_QUANTISATION, "V4L2_CID_STATELESS_MPEG2_QUANTISATION" );
	#endif
	#ifdef V4L2_CID_COLORIMETRY_CLASS_BASE
		swigIntConstant( V4L2_CID_COLORIMETRY_CLASS_BASE, "V4L2_CID_COLORIMETRY_CLASS_BASE" );
	#endif
	#ifdef V4L2_CID_COLORIMETRY_CLASS
		swigIntConstant( V4L2_CID_COLORIMETRY_CLASS, "V4L2_CID_COLORIMETRY_CLASS" );
	#endif
	#ifdef V4L2_CID_COLORIMETRY_HDR10_CLL_INFO
		swigIntConstant( V4L2_CID_COLORIMETRY_HDR10_CLL_INFO, "V4L2_CID_COLORIMETRY_HDR10_CLL_INFO" );
	#endif
	#ifdef V4L2_CID_COLORIMETRY_HDR10_MASTERING_DISPLAY
		swigIntConstant( V4L2_CID_COLORIMETRY_HDR10_MASTERING_DISPLAY, "V4L2_CID_COLORIMETRY_HDR10_MASTERING_DISPLAY" );
	#endif
	#ifdef V4L2_HDR10_MASTERING_PRIMARIES_X_LOW
		swigIntConstant( V4L2_HDR10_MASTERING_PRIMARIES_X_LOW, "V4L2_HDR10_MASTERING_PRIMARIES_X_LOW" );
	#endif
	#ifdef V4L2_HDR10_MASTERING_PRIMARIES_X_HIGH
		swigIntConstant( V4L2_HDR10_MASTERING_PRIMARIES_X_HIGH, "V4L2_HDR10_MASTERING_PRIMARIES_X_HIGH" );
	#endif
	#ifdef V4L2_HDR10_MASTERING_PRIMARIES_Y_LOW
		swigIntConstant( V4L2_HDR10_MASTERING_PRIMARIES_Y_LOW, "V4L2_HDR10_MASTERING_PRIMARIES_Y_LOW" );
	#endif
	#ifdef V4L2_HDR10_MASTERING_PRIMARIES_Y_HIGH
		swigIntConstant( V4L2_HDR10_MASTERING_PRIMARIES_Y_HIGH, "V4L2_HDR10_MASTERING_PRIMARIES_Y_HIGH" );
	#endif
	#ifdef V4L2_HDR10_MASTERING_WHITE_POINT_X_LOW
		swigIntConstant( V4L2_HDR10_MASTERING_WHITE_POINT_X_LOW, "V4L2_HDR10_MASTERING_WHITE_POINT_X_LOW" );
	#endif
	#ifdef V4L2_HDR10_MASTERING_WHITE_POINT_X_HIGH
		swigIntConstant( V4L2_HDR10_MASTERING_WHITE_POINT_X_HIGH, "V4L2_HDR10_MASTERING_WHITE_POINT_X_HIGH" );
	#endif
	#ifdef V4L2_HDR10_MASTERING_WHITE_POINT_Y_LOW
		swigIntConstant( V4L2_HDR10_MASTERING_WHITE_POINT_Y_LOW, "V4L2_HDR10_MASTERING_WHITE_POINT_Y_LOW" );
	#endif
	#ifdef V4L2_HDR10_MASTERING_WHITE_POINT_Y_HIGH
		swigIntConstant( V4L2_HDR10_MASTERING_WHITE_POINT_Y_HIGH, "V4L2_HDR10_MASTERING_WHITE_POINT_Y_HIGH" );
	#endif
	#ifdef V4L2_HDR10_MASTERING_MAX_LUMA_LOW
		swigIntConstant( V4L2_HDR10_MASTERING_MAX_LUMA_LOW, "V4L2_HDR10_MASTERING_MAX_LUMA_LOW" );
	#endif
	#ifdef V4L2_HDR10_MASTERING_MAX_LUMA_HIGH
		swigIntConstant( V4L2_HDR10_MASTERING_MAX_LUMA_HIGH, "V4L2_HDR10_MASTERING_MAX_LUMA_HIGH" );
	#endif
	#ifdef V4L2_HDR10_MASTERING_MIN_LUMA_LOW
		swigIntConstant( V4L2_HDR10_MASTERING_MIN_LUMA_LOW, "V4L2_HDR10_MASTERING_MIN_LUMA_LOW" );
	#endif
	#ifdef V4L2_HDR10_MASTERING_MIN_LUMA_HIGH
		swigIntConstant( V4L2_HDR10_MASTERING_MIN_LUMA_HIGH, "V4L2_HDR10_MASTERING_MIN_LUMA_HIGH" );
	#endif
	#ifdef V4L2_VP9_LOOP_FILTER_FLAG_DELTA_ENABLED
		swigIntConstant( V4L2_VP9_LOOP_FILTER_FLAG_DELTA_ENABLED, "V4L2_VP9_LOOP_FILTER_FLAG_DELTA_ENABLED" );
	#endif
	#ifdef V4L2_VP9_LOOP_FILTER_FLAG_DELTA_UPDATE
		swigIntConstant( V4L2_VP9_LOOP_FILTER_FLAG_DELTA_UPDATE, "V4L2_VP9_LOOP_FILTER_FLAG_DELTA_UPDATE" );
	#endif
	#ifdef V4L2_VP9_SEGMENTATION_FLAG_ENABLED
		swigIntConstant( V4L2_VP9_SEGMENTATION_FLAG_ENABLED, "V4L2_VP9_SEGMENTATION_FLAG_ENABLED" );
	#endif
	#ifdef V4L2_VP9_SEGMENTATION_FLAG_UPDATE_MAP
		swigIntConstant( V4L2_VP9_SEGMENTATION_FLAG_UPDATE_MAP, "V4L2_VP9_SEGMENTATION_FLAG_UPDATE_MAP" );
	#endif
	#ifdef V4L2_VP9_SEGMENTATION_FLAG_TEMPORAL_UPDATE
		swigIntConstant( V4L2_VP9_SEGMENTATION_FLAG_TEMPORAL_UPDATE, "V4L2_VP9_SEGMENTATION_FLAG_TEMPORAL_UPDATE" );
	#endif
	#ifdef V4L2_VP9_SEGMENTATION_FLAG_UPDATE_DATA
		swigIntConstant( V4L2_VP9_SEGMENTATION_FLAG_UPDATE_DATA, "V4L2_VP9_SEGMENTATION_FLAG_UPDATE_DATA" );
	#endif
	#ifdef V4L2_VP9_SEGMENTATION_FLAG_ABS_OR_DELTA_UPDATE
		swigIntConstant( V4L2_VP9_SEGMENTATION_FLAG_ABS_OR_DELTA_UPDATE, "V4L2_VP9_SEGMENTATION_FLAG_ABS_OR_DELTA_UPDATE" );
	#endif
	#ifdef V4L2_VP9_SEG_LVL_ALT_Q
		swigIntConstant( V4L2_VP9_SEG_LVL_ALT_Q, "V4L2_VP9_SEG_LVL_ALT_Q" );
	#endif
	#ifdef V4L2_VP9_SEG_LVL_ALT_L
		swigIntConstant( V4L2_VP9_SEG_LVL_ALT_L, "V4L2_VP9_SEG_LVL_ALT_L" );
	#endif
	#ifdef V4L2_VP9_SEG_LVL_REF_FRAME
		swigIntConstant( V4L2_VP9_SEG_LVL_REF_FRAME, "V4L2_VP9_SEG_LVL_REF_FRAME" );
	#endif
	#ifdef V4L2_VP9_SEG_LVL_SKIP
		swigIntConstant( V4L2_VP9_SEG_LVL_SKIP, "V4L2_VP9_SEG_LVL_SKIP" );
	#endif
	#ifdef V4L2_VP9_SEG_LVL_MAX
		swigIntConstant( V4L2_VP9_SEG_LVL_MAX, "V4L2_VP9_SEG_LVL_MAX" );
	#endif
	#ifdef V4L2_VP9_SEGMENT_FEATURE_ENABLED_MASK
		swigIntConstant( V4L2_VP9_SEGMENT_FEATURE_ENABLED_MASK, "V4L2_VP9_SEGMENT_FEATURE_ENABLED_MASK" );
	#endif
	#ifdef V4L2_VP9_FRAME_FLAG_KEY_FRAME
		swigIntConstant( V4L2_VP9_FRAME_FLAG_KEY_FRAME, "V4L2_VP9_FRAME_FLAG_KEY_FRAME" );
	#endif
	#ifdef V4L2_VP9_FRAME_FLAG_SHOW_FRAME
		swigIntConstant( V4L2_VP9_FRAME_FLAG_SHOW_FRAME, "V4L2_VP9_FRAME_FLAG_SHOW_FRAME" );
	#endif
	#ifdef V4L2_VP9_FRAME_FLAG_ERROR_RESILIENT
		swigIntConstant( V4L2_VP9_FRAME_FLAG_ERROR_RESILIENT, "V4L2_VP9_FRAME_FLAG_ERROR_RESILIENT" );
	#endif
	#ifdef V4L2_VP9_FRAME_FLAG_INTRA_ONLY
		swigIntConstant( V4L2_VP9_FRAME_FLAG_INTRA_ONLY, "V4L2_VP9_FRAME_FLAG_INTRA_ONLY" );
	#endif
	#ifdef V4L2_VP9_FRAME_FLAG_ALLOW_HIGH_PREC_MV
		swigIntConstant( V4L2_VP9_FRAME_FLAG_ALLOW_HIGH_PREC_MV, "V4L2_VP9_FRAME_FLAG_ALLOW_HIGH_PREC_MV" );
	#endif
	#ifdef V4L2_VP9_FRAME_FLAG_REFRESH_FRAME_CTX
		swigIntConstant( V4L2_VP9_FRAME_FLAG_REFRESH_FRAME_CTX, "V4L2_VP9_FRAME_FLAG_REFRESH_FRAME_CTX" );
	#endif
	#ifdef V4L2_VP9_FRAME_FLAG_PARALLEL_DEC_MODE
		swigIntConstant( V4L2_VP9_FRAME_FLAG_PARALLEL_DEC_MODE, "V4L2_VP9_FRAME_FLAG_PARALLEL_DEC_MODE" );
	#endif
	#ifdef V4L2_VP9_FRAME_FLAG_X_SUBSAMPLING
		swigIntConstant( V4L2_VP9_FRAME_FLAG_X_SUBSAMPLING, "V4L2_VP9_FRAME_FLAG_X_SUBSAMPLING" );
	#endif
	#ifdef V4L2_VP9_FRAME_FLAG_Y_SUBSAMPLING
		swigIntConstant( V4L2_VP9_FRAME_FLAG_Y_SUBSAMPLING, "V4L2_VP9_FRAME_FLAG_Y_SUBSAMPLING" );
	#endif
	#ifdef V4L2_VP9_FRAME_FLAG_COLOR_RANGE_FULL_SWING
		swigIntConstant( V4L2_VP9_FRAME_FLAG_COLOR_RANGE_FULL_SWING, "V4L2_VP9_FRAME_FLAG_COLOR_RANGE_FULL_SWING" );
	#endif
	#ifdef V4L2_VP9_SIGN_BIAS_LAST
		swigIntConstant( V4L2_VP9_SIGN_BIAS_LAST, "V4L2_VP9_SIGN_BIAS_LAST" );
	#endif
	#ifdef V4L2_VP9_SIGN_BIAS_GOLDEN
		swigIntConstant( V4L2_VP9_SIGN_BIAS_GOLDEN, "V4L2_VP9_SIGN_BIAS_GOLDEN" );
	#endif
	#ifdef V4L2_VP9_SIGN_BIAS_ALT
		swigIntConstant( V4L2_VP9_SIGN_BIAS_ALT, "V4L2_VP9_SIGN_BIAS_ALT" );
	#endif
	#ifdef V4L2_VP9_RESET_FRAME_CTX_NONE
		swigIntConstant( V4L2_VP9_RESET_FRAME_CTX_NONE, "V4L2_VP9_RESET_FRAME_CTX_NONE" );
	#endif
	#ifdef V4L2_VP9_RESET_FRAME_CTX_SPEC
		swigIntConstant( V4L2_VP9_RESET_FRAME_CTX_SPEC, "V4L2_VP9_RESET_FRAME_CTX_SPEC" );
	#endif
	#ifdef V4L2_VP9_RESET_FRAME_CTX_ALL
		swigIntConstant( V4L2_VP9_RESET_FRAME_CTX_ALL, "V4L2_VP9_RESET_FRAME_CTX_ALL" );
	#endif
	#ifdef V4L2_VP9_INTERP_FILTER_EIGHTTAP
		swigIntConstant( V4L2_VP9_INTERP_FILTER_EIGHTTAP, "V4L2_VP9_INTERP_FILTER_EIGHTTAP" );
	#endif
	#ifdef V4L2_VP9_INTERP_FILTER_EIGHTTAP_SMOOTH
		swigIntConstant( V4L2_VP9_INTERP_FILTER_EIGHTTAP_SMOOTH, "V4L2_VP9_INTERP_FILTER_EIGHTTAP_SMOOTH" );
	#endif
	#ifdef V4L2_VP9_INTERP_FILTER_EIGHTTAP_SHARP
		swigIntConstant( V4L2_VP9_INTERP_FILTER_EIGHTTAP_SHARP, "V4L2_VP9_INTERP_FILTER_EIGHTTAP_SHARP" );
	#endif
	#ifdef V4L2_VP9_INTERP_FILTER_BILINEAR
		swigIntConstant( V4L2_VP9_INTERP_FILTER_BILINEAR, "V4L2_VP9_INTERP_FILTER_BILINEAR" );
	#endif
	#ifdef V4L2_VP9_INTERP_FILTER_SWITCHABLE
		swigIntConstant( V4L2_VP9_INTERP_FILTER_SWITCHABLE, "V4L2_VP9_INTERP_FILTER_SWITCHABLE" );
	#endif
	#ifdef V4L2_VP9_REFERENCE_MODE_SINGLE_REFERENCE
		swigIntConstant( V4L2_VP9_REFERENCE_MODE_SINGLE_REFERENCE, "V4L2_VP9_REFERENCE_MODE_SINGLE_REFERENCE" );
	#endif
	#ifdef V4L2_VP9_REFERENCE_MODE_COMPOUND_REFERENCE
		swigIntConstant( V4L2_VP9_REFERENCE_MODE_COMPOUND_REFERENCE, "V4L2_VP9_REFERENCE_MODE_COMPOUND_REFERENCE" );
	#endif
	#ifdef V4L2_VP9_REFERENCE_MODE_SELECT
		swigIntConstant( V4L2_VP9_REFERENCE_MODE_SELECT, "V4L2_VP9_REFERENCE_MODE_SELECT" );
	#endif
	#ifdef V4L2_VP9_PROFILE_MAX
		swigIntConstant( V4L2_VP9_PROFILE_MAX, "V4L2_VP9_PROFILE_MAX" );
	#endif
	#ifdef V4L2_CID_STATELESS_VP9_FRAME
		swigIntConstant( V4L2_CID_STATELESS_VP9_FRAME, "V4L2_CID_STATELESS_VP9_FRAME" );
	#endif
	#ifdef V4L2_VP9_NUM_FRAME_CTX
		swigIntConstant( V4L2_VP9_NUM_FRAME_CTX, "V4L2_VP9_NUM_FRAME_CTX" );
	#endif
	#ifdef V4L2_CID_STATELESS_VP9_COMPRESSED_HDR
		swigIntConstant( V4L2_CID_STATELESS_VP9_COMPRESSED_HDR, "V4L2_CID_STATELESS_VP9_COMPRESSED_HDR" );
	#endif
	#ifdef V4L2_VP9_TX_MODE_ONLY_4X4
		swigIntConstant( V4L2_VP9_TX_MODE_ONLY_4X4, "V4L2_VP9_TX_MODE_ONLY_4X4" );
	#endif
	#ifdef V4L2_VP9_TX_MODE_ALLOW_8X8
		swigIntConstant( V4L2_VP9_TX_MODE_ALLOW_8X8, "V4L2_VP9_TX_MODE_ALLOW_8X8" );
	#endif
	#ifdef V4L2_VP9_TX_MODE_ALLOW_16X16
		swigIntConstant( V4L2_VP9_TX_MODE_ALLOW_16X16, "V4L2_VP9_TX_MODE_ALLOW_16X16" );
	#endif
	#ifdef V4L2_VP9_TX_MODE_ALLOW_32X32
		swigIntConstant( V4L2_VP9_TX_MODE_ALLOW_32X32, "V4L2_VP9_TX_MODE_ALLOW_32X32" );
	#endif
	#ifdef V4L2_VP9_TX_MODE_SELECT
		swigIntConstant( V4L2_VP9_TX_MODE_SELECT, "V4L2_VP9_TX_MODE_SELECT" );
	#endif
	#ifdef V4L2_CTRL_CLASS_MPEG
		swigIntConstant( V4L2_CTRL_CLASS_MPEG, "V4L2_CTRL_CLASS_MPEG" );
	#endif
	#ifdef V4L2_CID_MPEG_CLASS
		swigIntConstant( V4L2_CID_MPEG_CLASS, "V4L2_CID_MPEG_CLASS" );
	#endif
	#ifdef V4L2_CID_MPEG_BASE
		swigIntConstant( V4L2_CID_MPEG_BASE, "V4L2_CID_MPEG_BASE" );
	#endif
	#ifdef V4L2_CID_MPEG_CX2341X_BASE
		swigIntConstant( V4L2_CID_MPEG_CX2341X_BASE, "V4L2_CID_MPEG_CX2341X_BASE" );
	#endif
	#ifdef V4L2_CID_MPEG_MFC51_BASE
		swigIntConstant( V4L2_CID_MPEG_MFC51_BASE, "V4L2_CID_MPEG_MFC51_BASE" );
	#endif
	#ifdef V4L2_MBUS_FRAMEFMT_SET_CSC
		swigIntConstant( V4L2_MBUS_FRAMEFMT_SET_CSC, "V4L2_MBUS_FRAMEFMT_SET_CSC" );
	#endif
	#ifdef V4L2_SUBDEV_MBUS_CODE_CSC_COLORSPACE
		swigIntConstant( V4L2_SUBDEV_MBUS_CODE_CSC_COLORSPACE, "V4L2_SUBDEV_MBUS_CODE_CSC_COLORSPACE" );
	#endif
	#ifdef V4L2_SUBDEV_MBUS_CODE_CSC_XFER_FUNC
		swigIntConstant( V4L2_SUBDEV_MBUS_CODE_CSC_XFER_FUNC, "V4L2_SUBDEV_MBUS_CODE_CSC_XFER_FUNC" );
	#endif
	#ifdef V4L2_SUBDEV_MBUS_CODE_CSC_YCBCR_ENC
		swigIntConstant( V4L2_SUBDEV_MBUS_CODE_CSC_YCBCR_ENC, "V4L2_SUBDEV_MBUS_CODE_CSC_YCBCR_ENC" );
	#endif
	#ifdef V4L2_SUBDEV_MBUS_CODE_CSC_HSV_ENC
		swigIntConstant( V4L2_SUBDEV_MBUS_CODE_CSC_HSV_ENC, "V4L2_SUBDEV_MBUS_CODE_CSC_HSV_ENC" );
	#endif
	#ifdef V4L2_SUBDEV_MBUS_CODE_CSC_QUANTIZATION
		swigIntConstant( V4L2_SUBDEV_MBUS_CODE_CSC_QUANTIZATION, "V4L2_SUBDEV_MBUS_CODE_CSC_QUANTIZATION" );
	#endif
	#ifdef V4L2_SUBDEV_CAP_RO_SUBDEV
		swigIntConstant( V4L2_SUBDEV_CAP_RO_SUBDEV, "V4L2_SUBDEV_CAP_RO_SUBDEV" );
	#endif

	swigNewline();

	swigComment("--------===< enums >===---------\n");
	swigIntConstant( V4L2_FIELD_ANY, "V4L2_FIELD_ANY" );
	swigIntConstant( V4L2_FIELD_NONE, "V4L2_FIELD_NONE" );
	swigIntConstant( V4L2_FIELD_TOP, "V4L2_FIELD_TOP" );
	swigIntConstant( V4L2_FIELD_BOTTOM, "V4L2_FIELD_BOTTOM" );
	swigIntConstant( V4L2_FIELD_INTERLACED, "V4L2_FIELD_INTERLACED" );
	swigIntConstant( V4L2_FIELD_SEQ_TB, "V4L2_FIELD_SEQ_TB" );
	swigIntConstant( V4L2_FIELD_SEQ_BT, "V4L2_FIELD_SEQ_BT" );
	swigIntConstant( V4L2_FIELD_ALTERNATE, "V4L2_FIELD_ALTERNATE" );
	swigIntConstant( V4L2_FIELD_INTERLACED_TB, "V4L2_FIELD_INTERLACED_TB" );
	swigIntConstant( V4L2_FIELD_INTERLACED_BT, "V4L2_FIELD_INTERLACED_BT" );
	swigIntConstant( V4L2_BUF_TYPE_VIDEO_CAPTURE, "V4L2_BUF_TYPE_VIDEO_CAPTURE" );
	swigIntConstant( V4L2_BUF_TYPE_VIDEO_OUTPUT, "V4L2_BUF_TYPE_VIDEO_OUTPUT" );
	swigIntConstant( V4L2_BUF_TYPE_VIDEO_OVERLAY, "V4L2_BUF_TYPE_VIDEO_OVERLAY" );
	swigIntConstant( V4L2_BUF_TYPE_VBI_CAPTURE, "V4L2_BUF_TYPE_VBI_CAPTURE" );
	swigIntConstant( V4L2_BUF_TYPE_VBI_OUTPUT, "V4L2_BUF_TYPE_VBI_OUTPUT" );
	swigIntConstant( V4L2_BUF_TYPE_SLICED_VBI_CAPTURE, "V4L2_BUF_TYPE_SLICED_VBI_CAPTURE" );
	swigIntConstant( V4L2_BUF_TYPE_SLICED_VBI_OUTPUT, "V4L2_BUF_TYPE_SLICED_VBI_OUTPUT" );
	swigIntConstant( V4L2_BUF_TYPE_VIDEO_OUTPUT_OVERLAY, "V4L2_BUF_TYPE_VIDEO_OUTPUT_OVERLAY" );
	swigIntConstant( V4L2_BUF_TYPE_VIDEO_CAPTURE_MPLANE, "V4L2_BUF_TYPE_VIDEO_CAPTURE_MPLANE" );
	swigIntConstant( V4L2_BUF_TYPE_VIDEO_OUTPUT_MPLANE, "V4L2_BUF_TYPE_VIDEO_OUTPUT_MPLANE" );
	swigIntConstant( V4L2_BUF_TYPE_SDR_CAPTURE, "V4L2_BUF_TYPE_SDR_CAPTURE" );
	swigIntConstant( V4L2_BUF_TYPE_SDR_OUTPUT, "V4L2_BUF_TYPE_SDR_OUTPUT" );
	swigIntConstant( V4L2_BUF_TYPE_META_CAPTURE, "V4L2_BUF_TYPE_META_CAPTURE" );
	swigIntConstant( V4L2_BUF_TYPE_META_OUTPUT, "V4L2_BUF_TYPE_META_OUTPUT" );
	swigIntConstant( V4L2_BUF_TYPE_PRIVATE, "V4L2_BUF_TYPE_PRIVATE" );
	swigIntConstant( V4L2_TUNER_RADIO, "V4L2_TUNER_RADIO" );
	swigIntConstant( V4L2_TUNER_ANALOG_TV, "V4L2_TUNER_ANALOG_TV" );
	swigIntConstant( V4L2_TUNER_DIGITAL_TV, "V4L2_TUNER_DIGITAL_TV" );
	swigIntConstant( V4L2_TUNER_SDR, "V4L2_TUNER_SDR" );
	swigIntConstant( V4L2_TUNER_RF, "V4L2_TUNER_RF" );
	swigIntConstant( V4L2_MEMORY_MMAP, "V4L2_MEMORY_MMAP" );
	swigIntConstant( V4L2_MEMORY_USERPTR, "V4L2_MEMORY_USERPTR" );
	swigIntConstant( V4L2_MEMORY_OVERLAY, "V4L2_MEMORY_OVERLAY" );
	swigIntConstant( V4L2_MEMORY_DMABUF, "V4L2_MEMORY_DMABUF" );
	swigIntConstant( V4L2_COLORSPACE_DEFAULT, "V4L2_COLORSPACE_DEFAULT" );
	swigIntConstant( V4L2_COLORSPACE_SMPTE170M, "V4L2_COLORSPACE_SMPTE170M" );
	swigIntConstant( V4L2_COLORSPACE_SMPTE240M, "V4L2_COLORSPACE_SMPTE240M" );
	swigIntConstant( V4L2_COLORSPACE_REC709, "V4L2_COLORSPACE_REC709" );
	swigIntConstant( V4L2_COLORSPACE_BT878, "V4L2_COLORSPACE_BT878" );
	swigIntConstant( V4L2_COLORSPACE_470_SYSTEM_M, "V4L2_COLORSPACE_470_SYSTEM_M" );
	swigIntConstant( V4L2_COLORSPACE_470_SYSTEM_BG, "V4L2_COLORSPACE_470_SYSTEM_BG" );
	swigIntConstant( V4L2_COLORSPACE_JPEG, "V4L2_COLORSPACE_JPEG" );
	swigIntConstant( V4L2_COLORSPACE_SRGB, "V4L2_COLORSPACE_SRGB" );
	swigIntConstant( V4L2_COLORSPACE_OPRGB, "V4L2_COLORSPACE_OPRGB" );
	swigIntConstant( V4L2_COLORSPACE_BT2020, "V4L2_COLORSPACE_BT2020" );
	swigIntConstant( V4L2_COLORSPACE_RAW, "V4L2_COLORSPACE_RAW" );
	swigIntConstant( V4L2_COLORSPACE_DCI_P3, "V4L2_COLORSPACE_DCI_P3" );
	swigIntConstant( V4L2_XFER_FUNC_DEFAULT, "V4L2_XFER_FUNC_DEFAULT" );
	swigIntConstant( V4L2_XFER_FUNC_709, "V4L2_XFER_FUNC_709" );
	swigIntConstant( V4L2_XFER_FUNC_SRGB, "V4L2_XFER_FUNC_SRGB" );
	swigIntConstant( V4L2_XFER_FUNC_OPRGB, "V4L2_XFER_FUNC_OPRGB" );
	swigIntConstant( V4L2_XFER_FUNC_SMPTE240M, "V4L2_XFER_FUNC_SMPTE240M" );
	swigIntConstant( V4L2_XFER_FUNC_NONE, "V4L2_XFER_FUNC_NONE" );
	swigIntConstant( V4L2_XFER_FUNC_DCI_P3, "V4L2_XFER_FUNC_DCI_P3" );
	swigIntConstant( V4L2_XFER_FUNC_SMPTE2084, "V4L2_XFER_FUNC_SMPTE2084" );
	swigIntConstant( V4L2_YCBCR_ENC_DEFAULT, "V4L2_YCBCR_ENC_DEFAULT" );
	swigIntConstant( V4L2_YCBCR_ENC_601, "V4L2_YCBCR_ENC_601" );
	swigIntConstant( V4L2_YCBCR_ENC_709, "V4L2_YCBCR_ENC_709" );
	swigIntConstant( V4L2_YCBCR_ENC_XV601, "V4L2_YCBCR_ENC_XV601" );
	swigIntConstant( V4L2_YCBCR_ENC_XV709, "V4L2_YCBCR_ENC_XV709" );
	swigIntConstant( V4L2_YCBCR_ENC_SYCC, "V4L2_YCBCR_ENC_SYCC" );
	swigIntConstant( V4L2_YCBCR_ENC_BT2020, "V4L2_YCBCR_ENC_BT2020" );
	swigIntConstant( V4L2_YCBCR_ENC_BT2020_CONST_LUM, "V4L2_YCBCR_ENC_BT2020_CONST_LUM" );
	swigIntConstant( V4L2_YCBCR_ENC_SMPTE240M, "V4L2_YCBCR_ENC_SMPTE240M" );
	swigIntConstant( V4L2_HSV_ENC_180, "V4L2_HSV_ENC_180" );
	swigIntConstant( V4L2_HSV_ENC_256, "V4L2_HSV_ENC_256" );
	swigIntConstant( V4L2_QUANTIZATION_DEFAULT, "V4L2_QUANTIZATION_DEFAULT" );
	swigIntConstant( V4L2_QUANTIZATION_FULL_RANGE, "V4L2_QUANTIZATION_FULL_RANGE" );
	swigIntConstant( V4L2_QUANTIZATION_LIM_RANGE, "V4L2_QUANTIZATION_LIM_RANGE" );
	swigIntConstant( V4L2_PRIORITY_UNSET, "V4L2_PRIORITY_UNSET" );
	swigIntConstant( V4L2_PRIORITY_BACKGROUND, "V4L2_PRIORITY_BACKGROUND" );
	swigIntConstant( V4L2_PRIORITY_INTERACTIVE, "V4L2_PRIORITY_INTERACTIVE" );
	swigIntConstant( V4L2_PRIORITY_RECORD, "V4L2_PRIORITY_RECORD" );
	swigIntConstant( V4L2_PRIORITY_DEFAULT, "V4L2_PRIORITY_DEFAULT" );
	swigIntConstant( V4L2_FRMSIZE_TYPE_DISCRETE, "V4L2_FRMSIZE_TYPE_DISCRETE" );
	swigIntConstant( V4L2_FRMSIZE_TYPE_CONTINUOUS, "V4L2_FRMSIZE_TYPE_CONTINUOUS" );
	swigIntConstant( V4L2_FRMSIZE_TYPE_STEPWISE, "V4L2_FRMSIZE_TYPE_STEPWISE" );
	swigIntConstant( V4L2_FRMIVAL_TYPE_DISCRETE, "V4L2_FRMIVAL_TYPE_DISCRETE" );
	swigIntConstant( V4L2_FRMIVAL_TYPE_CONTINUOUS, "V4L2_FRMIVAL_TYPE_CONTINUOUS" );
	swigIntConstant( V4L2_FRMIVAL_TYPE_STEPWISE, "V4L2_FRMIVAL_TYPE_STEPWISE" );
	swigIntConstant( V4L2_CTRL_TYPE_INTEGER, "V4L2_CTRL_TYPE_INTEGER" );
	swigIntConstant( V4L2_CTRL_TYPE_BOOLEAN, "V4L2_CTRL_TYPE_BOOLEAN" );
	swigIntConstant( V4L2_CTRL_TYPE_MENU, "V4L2_CTRL_TYPE_MENU" );
	swigIntConstant( V4L2_CTRL_TYPE_BUTTON, "V4L2_CTRL_TYPE_BUTTON" );
	swigIntConstant( V4L2_CTRL_TYPE_INTEGER64, "V4L2_CTRL_TYPE_INTEGER64" );
	swigIntConstant( V4L2_CTRL_TYPE_CTRL_CLASS, "V4L2_CTRL_TYPE_CTRL_CLASS" );
	swigIntConstant( V4L2_CTRL_TYPE_STRING, "V4L2_CTRL_TYPE_STRING" );
	swigIntConstant( V4L2_CTRL_TYPE_BITMASK, "V4L2_CTRL_TYPE_BITMASK" );
	swigIntConstant( V4L2_CTRL_TYPE_INTEGER_MENU, "V4L2_CTRL_TYPE_INTEGER_MENU" );
	swigIntConstant( V4L2_CTRL_COMPOUND_TYPES, "V4L2_CTRL_COMPOUND_TYPES" );
	swigIntConstant( V4L2_CTRL_TYPE_U8, "V4L2_CTRL_TYPE_U8" );
	swigIntConstant( V4L2_CTRL_TYPE_U16, "V4L2_CTRL_TYPE_U16" );
	swigIntConstant( V4L2_CTRL_TYPE_U32, "V4L2_CTRL_TYPE_U32" );
	swigIntConstant( V4L2_CTRL_TYPE_AREA, "V4L2_CTRL_TYPE_AREA" );
	swigIntConstant( V4L2_CTRL_TYPE_HDR10_CLL_INFO, "V4L2_CTRL_TYPE_HDR10_CLL_INFO" );
	swigIntConstant( V4L2_CTRL_TYPE_HDR10_MASTERING_DISPLAY, "V4L2_CTRL_TYPE_HDR10_MASTERING_DISPLAY" );
	swigIntConstant( V4L2_CTRL_TYPE_H264_SPS, "V4L2_CTRL_TYPE_H264_SPS" );
	swigIntConstant( V4L2_CTRL_TYPE_H264_PPS, "V4L2_CTRL_TYPE_H264_PPS" );
	swigIntConstant( V4L2_CTRL_TYPE_H264_SCALING_MATRIX, "V4L2_CTRL_TYPE_H264_SCALING_MATRIX" );
	swigIntConstant( V4L2_CTRL_TYPE_H264_SLICE_PARAMS, "V4L2_CTRL_TYPE_H264_SLICE_PARAMS" );
	swigIntConstant( V4L2_CTRL_TYPE_H264_DECODE_PARAMS, "V4L2_CTRL_TYPE_H264_DECODE_PARAMS" );
	swigIntConstant( V4L2_CTRL_TYPE_H264_PRED_WEIGHTS, "V4L2_CTRL_TYPE_H264_PRED_WEIGHTS" );
	swigIntConstant( V4L2_CTRL_TYPE_FWHT_PARAMS, "V4L2_CTRL_TYPE_FWHT_PARAMS" );
	swigIntConstant( V4L2_CTRL_TYPE_VP8_FRAME, "V4L2_CTRL_TYPE_VP8_FRAME" );
	swigIntConstant( V4L2_CTRL_TYPE_MPEG2_QUANTISATION, "V4L2_CTRL_TYPE_MPEG2_QUANTISATION" );
	swigIntConstant( V4L2_CTRL_TYPE_MPEG2_SEQUENCE, "V4L2_CTRL_TYPE_MPEG2_SEQUENCE" );
	swigIntConstant( V4L2_CTRL_TYPE_MPEG2_PICTURE, "V4L2_CTRL_TYPE_MPEG2_PICTURE" );
	swigIntConstant( V4L2_CTRL_TYPE_VP9_COMPRESSED_HDR, "V4L2_CTRL_TYPE_VP9_COMPRESSED_HDR" );
	swigIntConstant( V4L2_CTRL_TYPE_VP9_FRAME, "V4L2_CTRL_TYPE_VP9_FRAME" );
	swigIntConstant( V4L2_CID_POWER_LINE_FREQUENCY_DISABLED, "V4L2_CID_POWER_LINE_FREQUENCY_DISABLED" );
	swigIntConstant( V4L2_CID_POWER_LINE_FREQUENCY_50HZ, "V4L2_CID_POWER_LINE_FREQUENCY_50HZ" );
	swigIntConstant( V4L2_CID_POWER_LINE_FREQUENCY_60HZ, "V4L2_CID_POWER_LINE_FREQUENCY_60HZ" );
	swigIntConstant( V4L2_CID_POWER_LINE_FREQUENCY_AUTO, "V4L2_CID_POWER_LINE_FREQUENCY_AUTO" );
	swigIntConstant( V4L2_COLORFX_NONE, "V4L2_COLORFX_NONE" );
	swigIntConstant( V4L2_COLORFX_BW, "V4L2_COLORFX_BW" );
	swigIntConstant( V4L2_COLORFX_SEPIA, "V4L2_COLORFX_SEPIA" );
	swigIntConstant( V4L2_COLORFX_NEGATIVE, "V4L2_COLORFX_NEGATIVE" );
	swigIntConstant( V4L2_COLORFX_EMBOSS, "V4L2_COLORFX_EMBOSS" );
	swigIntConstant( V4L2_COLORFX_SKETCH, "V4L2_COLORFX_SKETCH" );
	swigIntConstant( V4L2_COLORFX_SKY_BLUE, "V4L2_COLORFX_SKY_BLUE" );
	swigIntConstant( V4L2_COLORFX_GRASS_GREEN, "V4L2_COLORFX_GRASS_GREEN" );
	swigIntConstant( V4L2_COLORFX_SKIN_WHITEN, "V4L2_COLORFX_SKIN_WHITEN" );
	swigIntConstant( V4L2_COLORFX_VIVID, "V4L2_COLORFX_VIVID" );
	swigIntConstant( V4L2_COLORFX_AQUA, "V4L2_COLORFX_AQUA" );
	swigIntConstant( V4L2_COLORFX_ART_FREEZE, "V4L2_COLORFX_ART_FREEZE" );
	swigIntConstant( V4L2_COLORFX_SILHOUETTE, "V4L2_COLORFX_SILHOUETTE" );
	swigIntConstant( V4L2_COLORFX_SOLARIZATION, "V4L2_COLORFX_SOLARIZATION" );
	swigIntConstant( V4L2_COLORFX_ANTIQUE, "V4L2_COLORFX_ANTIQUE" );
	swigIntConstant( V4L2_COLORFX_SET_CBCR, "V4L2_COLORFX_SET_CBCR" );
	swigIntConstant( V4L2_COLORFX_SET_RGB, "V4L2_COLORFX_SET_RGB" );
	swigIntConstant( V4L2_MPEG_STREAM_TYPE_MPEG2_PS, "V4L2_MPEG_STREAM_TYPE_MPEG2_PS" );
	swigIntConstant( V4L2_MPEG_STREAM_TYPE_MPEG2_TS, "V4L2_MPEG_STREAM_TYPE_MPEG2_TS" );
	swigIntConstant( V4L2_MPEG_STREAM_TYPE_MPEG1_SS, "V4L2_MPEG_STREAM_TYPE_MPEG1_SS" );
	swigIntConstant( V4L2_MPEG_STREAM_TYPE_MPEG2_DVD, "V4L2_MPEG_STREAM_TYPE_MPEG2_DVD" );
	swigIntConstant( V4L2_MPEG_STREAM_TYPE_MPEG1_VCD, "V4L2_MPEG_STREAM_TYPE_MPEG1_VCD" );
	swigIntConstant( V4L2_MPEG_STREAM_TYPE_MPEG2_SVCD, "V4L2_MPEG_STREAM_TYPE_MPEG2_SVCD" );
	swigIntConstant( V4L2_MPEG_STREAM_VBI_FMT_NONE, "V4L2_MPEG_STREAM_VBI_FMT_NONE" );
	swigIntConstant( V4L2_MPEG_STREAM_VBI_FMT_IVTV, "V4L2_MPEG_STREAM_VBI_FMT_IVTV" );
	swigIntConstant( V4L2_MPEG_AUDIO_SAMPLING_FREQ_44100, "V4L2_MPEG_AUDIO_SAMPLING_FREQ_44100" );
	swigIntConstant( V4L2_MPEG_AUDIO_SAMPLING_FREQ_48000, "V4L2_MPEG_AUDIO_SAMPLING_FREQ_48000" );
	swigIntConstant( V4L2_MPEG_AUDIO_SAMPLING_FREQ_32000, "V4L2_MPEG_AUDIO_SAMPLING_FREQ_32000" );
	swigIntConstant( V4L2_MPEG_AUDIO_ENCODING_LAYER_1, "V4L2_MPEG_AUDIO_ENCODING_LAYER_1" );
	swigIntConstant( V4L2_MPEG_AUDIO_ENCODING_LAYER_2, "V4L2_MPEG_AUDIO_ENCODING_LAYER_2" );
	swigIntConstant( V4L2_MPEG_AUDIO_ENCODING_LAYER_3, "V4L2_MPEG_AUDIO_ENCODING_LAYER_3" );
	swigIntConstant( V4L2_MPEG_AUDIO_ENCODING_AAC, "V4L2_MPEG_AUDIO_ENCODING_AAC" );
	swigIntConstant( V4L2_MPEG_AUDIO_ENCODING_AC3, "V4L2_MPEG_AUDIO_ENCODING_AC3" );
	swigIntConstant( V4L2_MPEG_AUDIO_L1_BITRATE_32K, "V4L2_MPEG_AUDIO_L1_BITRATE_32K" );
	swigIntConstant( V4L2_MPEG_AUDIO_L1_BITRATE_64K, "V4L2_MPEG_AUDIO_L1_BITRATE_64K" );
	swigIntConstant( V4L2_MPEG_AUDIO_L1_BITRATE_96K, "V4L2_MPEG_AUDIO_L1_BITRATE_96K" );
	swigIntConstant( V4L2_MPEG_AUDIO_L1_BITRATE_128K, "V4L2_MPEG_AUDIO_L1_BITRATE_128K" );
	swigIntConstant( V4L2_MPEG_AUDIO_L1_BITRATE_160K, "V4L2_MPEG_AUDIO_L1_BITRATE_160K" );
	swigIntConstant( V4L2_MPEG_AUDIO_L1_BITRATE_192K, "V4L2_MPEG_AUDIO_L1_BITRATE_192K" );
	swigIntConstant( V4L2_MPEG_AUDIO_L1_BITRATE_224K, "V4L2_MPEG_AUDIO_L1_BITRATE_224K" );
	swigIntConstant( V4L2_MPEG_AUDIO_L1_BITRATE_256K, "V4L2_MPEG_AUDIO_L1_BITRATE_256K" );
	swigIntConstant( V4L2_MPEG_AUDIO_L1_BITRATE_288K, "V4L2_MPEG_AUDIO_L1_BITRATE_288K" );
	swigIntConstant( V4L2_MPEG_AUDIO_L1_BITRATE_320K, "V4L2_MPEG_AUDIO_L1_BITRATE_320K" );
	swigIntConstant( V4L2_MPEG_AUDIO_L1_BITRATE_352K, "V4L2_MPEG_AUDIO_L1_BITRATE_352K" );
	swigIntConstant( V4L2_MPEG_AUDIO_L1_BITRATE_384K, "V4L2_MPEG_AUDIO_L1_BITRATE_384K" );
	swigIntConstant( V4L2_MPEG_AUDIO_L1_BITRATE_416K, "V4L2_MPEG_AUDIO_L1_BITRATE_416K" );
	swigIntConstant( V4L2_MPEG_AUDIO_L1_BITRATE_448K, "V4L2_MPEG_AUDIO_L1_BITRATE_448K" );
	swigIntConstant( V4L2_MPEG_AUDIO_L2_BITRATE_32K, "V4L2_MPEG_AUDIO_L2_BITRATE_32K" );
	swigIntConstant( V4L2_MPEG_AUDIO_L2_BITRATE_48K, "V4L2_MPEG_AUDIO_L2_BITRATE_48K" );
	swigIntConstant( V4L2_MPEG_AUDIO_L2_BITRATE_56K, "V4L2_MPEG_AUDIO_L2_BITRATE_56K" );
	swigIntConstant( V4L2_MPEG_AUDIO_L2_BITRATE_64K, "V4L2_MPEG_AUDIO_L2_BITRATE_64K" );
	swigIntConstant( V4L2_MPEG_AUDIO_L2_BITRATE_80K, "V4L2_MPEG_AUDIO_L2_BITRATE_80K" );
	swigIntConstant( V4L2_MPEG_AUDIO_L2_BITRATE_96K, "V4L2_MPEG_AUDIO_L2_BITRATE_96K" );
	swigIntConstant( V4L2_MPEG_AUDIO_L2_BITRATE_112K, "V4L2_MPEG_AUDIO_L2_BITRATE_112K" );
	swigIntConstant( V4L2_MPEG_AUDIO_L2_BITRATE_128K, "V4L2_MPEG_AUDIO_L2_BITRATE_128K" );
	swigIntConstant( V4L2_MPEG_AUDIO_L2_BITRATE_160K, "V4L2_MPEG_AUDIO_L2_BITRATE_160K" );
	swigIntConstant( V4L2_MPEG_AUDIO_L2_BITRATE_192K, "V4L2_MPEG_AUDIO_L2_BITRATE_192K" );
	swigIntConstant( V4L2_MPEG_AUDIO_L2_BITRATE_224K, "V4L2_MPEG_AUDIO_L2_BITRATE_224K" );
	swigIntConstant( V4L2_MPEG_AUDIO_L2_BITRATE_256K, "V4L2_MPEG_AUDIO_L2_BITRATE_256K" );
	swigIntConstant( V4L2_MPEG_AUDIO_L2_BITRATE_320K, "V4L2_MPEG_AUDIO_L2_BITRATE_320K" );
	swigIntConstant( V4L2_MPEG_AUDIO_L2_BITRATE_384K, "V4L2_MPEG_AUDIO_L2_BITRATE_384K" );
	swigIntConstant( V4L2_MPEG_AUDIO_L3_BITRATE_32K, "V4L2_MPEG_AUDIO_L3_BITRATE_32K" );
	swigIntConstant( V4L2_MPEG_AUDIO_L3_BITRATE_40K, "V4L2_MPEG_AUDIO_L3_BITRATE_40K" );
	swigIntConstant( V4L2_MPEG_AUDIO_L3_BITRATE_48K, "V4L2_MPEG_AUDIO_L3_BITRATE_48K" );
	swigIntConstant( V4L2_MPEG_AUDIO_L3_BITRATE_56K, "V4L2_MPEG_AUDIO_L3_BITRATE_56K" );
	swigIntConstant( V4L2_MPEG_AUDIO_L3_BITRATE_64K, "V4L2_MPEG_AUDIO_L3_BITRATE_64K" );
	swigIntConstant( V4L2_MPEG_AUDIO_L3_BITRATE_80K, "V4L2_MPEG_AUDIO_L3_BITRATE_80K" );
	swigIntConstant( V4L2_MPEG_AUDIO_L3_BITRATE_96K, "V4L2_MPEG_AUDIO_L3_BITRATE_96K" );
	swigIntConstant( V4L2_MPEG_AUDIO_L3_BITRATE_112K, "V4L2_MPEG_AUDIO_L3_BITRATE_112K" );
	swigIntConstant( V4L2_MPEG_AUDIO_L3_BITRATE_128K, "V4L2_MPEG_AUDIO_L3_BITRATE_128K" );
	swigIntConstant( V4L2_MPEG_AUDIO_L3_BITRATE_160K, "V4L2_MPEG_AUDIO_L3_BITRATE_160K" );
	swigIntConstant( V4L2_MPEG_AUDIO_L3_BITRATE_192K, "V4L2_MPEG_AUDIO_L3_BITRATE_192K" );
	swigIntConstant( V4L2_MPEG_AUDIO_L3_BITRATE_224K, "V4L2_MPEG_AUDIO_L3_BITRATE_224K" );
	swigIntConstant( V4L2_MPEG_AUDIO_L3_BITRATE_256K, "V4L2_MPEG_AUDIO_L3_BITRATE_256K" );
	swigIntConstant( V4L2_MPEG_AUDIO_L3_BITRATE_320K, "V4L2_MPEG_AUDIO_L3_BITRATE_320K" );
	swigIntConstant( V4L2_MPEG_AUDIO_MODE_STEREO, "V4L2_MPEG_AUDIO_MODE_STEREO" );
	swigIntConstant( V4L2_MPEG_AUDIO_MODE_JOINT_STEREO, "V4L2_MPEG_AUDIO_MODE_JOINT_STEREO" );
	swigIntConstant( V4L2_MPEG_AUDIO_MODE_DUAL, "V4L2_MPEG_AUDIO_MODE_DUAL" );
	swigIntConstant( V4L2_MPEG_AUDIO_MODE_MONO, "V4L2_MPEG_AUDIO_MODE_MONO" );
	swigIntConstant( V4L2_MPEG_AUDIO_MODE_EXTENSION_BOUND_4, "V4L2_MPEG_AUDIO_MODE_EXTENSION_BOUND_4" );
	swigIntConstant( V4L2_MPEG_AUDIO_MODE_EXTENSION_BOUND_8, "V4L2_MPEG_AUDIO_MODE_EXTENSION_BOUND_8" );
	swigIntConstant( V4L2_MPEG_AUDIO_MODE_EXTENSION_BOUND_12, "V4L2_MPEG_AUDIO_MODE_EXTENSION_BOUND_12" );
	swigIntConstant( V4L2_MPEG_AUDIO_MODE_EXTENSION_BOUND_16, "V4L2_MPEG_AUDIO_MODE_EXTENSION_BOUND_16" );
	swigIntConstant( V4L2_MPEG_AUDIO_EMPHASIS_NONE, "V4L2_MPEG_AUDIO_EMPHASIS_NONE" );
	swigIntConstant( V4L2_MPEG_AUDIO_EMPHASIS_50_DIV_15_uS, "V4L2_MPEG_AUDIO_EMPHASIS_50_DIV_15_uS" );
	swigIntConstant( V4L2_MPEG_AUDIO_EMPHASIS_CCITT_J17, "V4L2_MPEG_AUDIO_EMPHASIS_CCITT_J17" );
	swigIntConstant( V4L2_MPEG_AUDIO_CRC_NONE, "V4L2_MPEG_AUDIO_CRC_NONE" );
	swigIntConstant( V4L2_MPEG_AUDIO_CRC_CRC16, "V4L2_MPEG_AUDIO_CRC_CRC16" );
	swigIntConstant( V4L2_MPEG_AUDIO_AC3_BITRATE_32K, "V4L2_MPEG_AUDIO_AC3_BITRATE_32K" );
	swigIntConstant( V4L2_MPEG_AUDIO_AC3_BITRATE_40K, "V4L2_MPEG_AUDIO_AC3_BITRATE_40K" );
	swigIntConstant( V4L2_MPEG_AUDIO_AC3_BITRATE_48K, "V4L2_MPEG_AUDIO_AC3_BITRATE_48K" );
	swigIntConstant( V4L2_MPEG_AUDIO_AC3_BITRATE_56K, "V4L2_MPEG_AUDIO_AC3_BITRATE_56K" );
	swigIntConstant( V4L2_MPEG_AUDIO_AC3_BITRATE_64K, "V4L2_MPEG_AUDIO_AC3_BITRATE_64K" );
	swigIntConstant( V4L2_MPEG_AUDIO_AC3_BITRATE_80K, "V4L2_MPEG_AUDIO_AC3_BITRATE_80K" );
	swigIntConstant( V4L2_MPEG_AUDIO_AC3_BITRATE_96K, "V4L2_MPEG_AUDIO_AC3_BITRATE_96K" );
	swigIntConstant( V4L2_MPEG_AUDIO_AC3_BITRATE_112K, "V4L2_MPEG_AUDIO_AC3_BITRATE_112K" );
	swigIntConstant( V4L2_MPEG_AUDIO_AC3_BITRATE_128K, "V4L2_MPEG_AUDIO_AC3_BITRATE_128K" );
	swigIntConstant( V4L2_MPEG_AUDIO_AC3_BITRATE_160K, "V4L2_MPEG_AUDIO_AC3_BITRATE_160K" );
	swigIntConstant( V4L2_MPEG_AUDIO_AC3_BITRATE_192K, "V4L2_MPEG_AUDIO_AC3_BITRATE_192K" );
	swigIntConstant( V4L2_MPEG_AUDIO_AC3_BITRATE_224K, "V4L2_MPEG_AUDIO_AC3_BITRATE_224K" );
	swigIntConstant( V4L2_MPEG_AUDIO_AC3_BITRATE_256K, "V4L2_MPEG_AUDIO_AC3_BITRATE_256K" );
	swigIntConstant( V4L2_MPEG_AUDIO_AC3_BITRATE_320K, "V4L2_MPEG_AUDIO_AC3_BITRATE_320K" );
	swigIntConstant( V4L2_MPEG_AUDIO_AC3_BITRATE_384K, "V4L2_MPEG_AUDIO_AC3_BITRATE_384K" );
	swigIntConstant( V4L2_MPEG_AUDIO_AC3_BITRATE_448K, "V4L2_MPEG_AUDIO_AC3_BITRATE_448K" );
	swigIntConstant( V4L2_MPEG_AUDIO_AC3_BITRATE_512K, "V4L2_MPEG_AUDIO_AC3_BITRATE_512K" );
	swigIntConstant( V4L2_MPEG_AUDIO_AC3_BITRATE_576K, "V4L2_MPEG_AUDIO_AC3_BITRATE_576K" );
	swigIntConstant( V4L2_MPEG_AUDIO_AC3_BITRATE_640K, "V4L2_MPEG_AUDIO_AC3_BITRATE_640K" );
	swigIntConstant( V4L2_MPEG_AUDIO_DEC_PLAYBACK_AUTO, "V4L2_MPEG_AUDIO_DEC_PLAYBACK_AUTO" );
	swigIntConstant( V4L2_MPEG_AUDIO_DEC_PLAYBACK_STEREO, "V4L2_MPEG_AUDIO_DEC_PLAYBACK_STEREO" );
	swigIntConstant( V4L2_MPEG_AUDIO_DEC_PLAYBACK_LEFT, "V4L2_MPEG_AUDIO_DEC_PLAYBACK_LEFT" );
	swigIntConstant( V4L2_MPEG_AUDIO_DEC_PLAYBACK_RIGHT, "V4L2_MPEG_AUDIO_DEC_PLAYBACK_RIGHT" );
	swigIntConstant( V4L2_MPEG_AUDIO_DEC_PLAYBACK_MONO, "V4L2_MPEG_AUDIO_DEC_PLAYBACK_MONO" );
	swigIntConstant( V4L2_MPEG_AUDIO_DEC_PLAYBACK_SWAPPED_STEREO, "V4L2_MPEG_AUDIO_DEC_PLAYBACK_SWAPPED_STEREO" );
	swigIntConstant( V4L2_MPEG_VIDEO_ENCODING_MPEG_1, "V4L2_MPEG_VIDEO_ENCODING_MPEG_1" );
	swigIntConstant( V4L2_MPEG_VIDEO_ENCODING_MPEG_2, "V4L2_MPEG_VIDEO_ENCODING_MPEG_2" );
	swigIntConstant( V4L2_MPEG_VIDEO_ENCODING_MPEG_4_AVC, "V4L2_MPEG_VIDEO_ENCODING_MPEG_4_AVC" );
	swigIntConstant( V4L2_MPEG_VIDEO_ASPECT_1x1, "V4L2_MPEG_VIDEO_ASPECT_1x1" );
	swigIntConstant( V4L2_MPEG_VIDEO_ASPECT_4x3, "V4L2_MPEG_VIDEO_ASPECT_4x3" );
	swigIntConstant( V4L2_MPEG_VIDEO_ASPECT_16x9, "V4L2_MPEG_VIDEO_ASPECT_16x9" );
	swigIntConstant( V4L2_MPEG_VIDEO_ASPECT_221x100, "V4L2_MPEG_VIDEO_ASPECT_221x100" );
	swigIntConstant( V4L2_MPEG_VIDEO_BITRATE_MODE_VBR, "V4L2_MPEG_VIDEO_BITRATE_MODE_VBR" );
	swigIntConstant( V4L2_MPEG_VIDEO_BITRATE_MODE_CBR, "V4L2_MPEG_VIDEO_BITRATE_MODE_CBR" );
	swigIntConstant( V4L2_MPEG_VIDEO_BITRATE_MODE_CQ, "V4L2_MPEG_VIDEO_BITRATE_MODE_CQ" );
	swigIntConstant( V4L2_MPEG_VIDEO_HEADER_MODE_SEPARATE, "V4L2_MPEG_VIDEO_HEADER_MODE_SEPARATE" );
	swigIntConstant( V4L2_MPEG_VIDEO_HEADER_MODE_JOINED_WITH_1ST_FRAME, "V4L2_MPEG_VIDEO_HEADER_MODE_JOINED_WITH_1ST_FRAME" );
	swigIntConstant( V4L2_MPEG_VIDEO_MULTI_SLICE_MODE_SINGLE, "V4L2_MPEG_VIDEO_MULTI_SLICE_MODE_SINGLE" );
	swigIntConstant( V4L2_MPEG_VIDEO_MULTI_SLICE_MODE_MAX_MB, "V4L2_MPEG_VIDEO_MULTI_SLICE_MODE_MAX_MB" );
	swigIntConstant( V4L2_MPEG_VIDEO_MULTI_SLICE_MODE_MAX_BYTES, "V4L2_MPEG_VIDEO_MULTI_SLICE_MODE_MAX_BYTES" );
	swigIntConstant( V4L2_MPEG_VIDEO_MULTI_SICE_MODE_MAX_MB, "V4L2_MPEG_VIDEO_MULTI_SICE_MODE_MAX_MB" );
	swigIntConstant( V4L2_MPEG_VIDEO_MULTI_SICE_MODE_MAX_BYTES, "V4L2_MPEG_VIDEO_MULTI_SICE_MODE_MAX_BYTES" );
	swigIntConstant( V4L2_MPEG_VIDEO_MPEG2_LEVEL_LOW, "V4L2_MPEG_VIDEO_MPEG2_LEVEL_LOW" );
	swigIntConstant( V4L2_MPEG_VIDEO_MPEG2_LEVEL_MAIN, "V4L2_MPEG_VIDEO_MPEG2_LEVEL_MAIN" );
	swigIntConstant( V4L2_MPEG_VIDEO_MPEG2_LEVEL_HIGH_1440, "V4L2_MPEG_VIDEO_MPEG2_LEVEL_HIGH_1440" );
	swigIntConstant( V4L2_MPEG_VIDEO_MPEG2_LEVEL_HIGH, "V4L2_MPEG_VIDEO_MPEG2_LEVEL_HIGH" );
	swigIntConstant( V4L2_MPEG_VIDEO_MPEG2_PROFILE_SIMPLE, "V4L2_MPEG_VIDEO_MPEG2_PROFILE_SIMPLE" );
	swigIntConstant( V4L2_MPEG_VIDEO_MPEG2_PROFILE_MAIN, "V4L2_MPEG_VIDEO_MPEG2_PROFILE_MAIN" );
	swigIntConstant( V4L2_MPEG_VIDEO_MPEG2_PROFILE_SNR_SCALABLE, "V4L2_MPEG_VIDEO_MPEG2_PROFILE_SNR_SCALABLE" );
	swigIntConstant( V4L2_MPEG_VIDEO_MPEG2_PROFILE_SPATIALLY_SCALABLE, "V4L2_MPEG_VIDEO_MPEG2_PROFILE_SPATIALLY_SCALABLE" );
	swigIntConstant( V4L2_MPEG_VIDEO_MPEG2_PROFILE_HIGH, "V4L2_MPEG_VIDEO_MPEG2_PROFILE_HIGH" );
	swigIntConstant( V4L2_MPEG_VIDEO_MPEG2_PROFILE_MULTIVIEW, "V4L2_MPEG_VIDEO_MPEG2_PROFILE_MULTIVIEW" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_ENTROPY_MODE_CAVLC, "V4L2_MPEG_VIDEO_H264_ENTROPY_MODE_CAVLC" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_ENTROPY_MODE_CABAC, "V4L2_MPEG_VIDEO_H264_ENTROPY_MODE_CABAC" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_LEVEL_1_0, "V4L2_MPEG_VIDEO_H264_LEVEL_1_0" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_LEVEL_1B, "V4L2_MPEG_VIDEO_H264_LEVEL_1B" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_LEVEL_1_1, "V4L2_MPEG_VIDEO_H264_LEVEL_1_1" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_LEVEL_1_2, "V4L2_MPEG_VIDEO_H264_LEVEL_1_2" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_LEVEL_1_3, "V4L2_MPEG_VIDEO_H264_LEVEL_1_3" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_LEVEL_2_0, "V4L2_MPEG_VIDEO_H264_LEVEL_2_0" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_LEVEL_2_1, "V4L2_MPEG_VIDEO_H264_LEVEL_2_1" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_LEVEL_2_2, "V4L2_MPEG_VIDEO_H264_LEVEL_2_2" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_LEVEL_3_0, "V4L2_MPEG_VIDEO_H264_LEVEL_3_0" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_LEVEL_3_1, "V4L2_MPEG_VIDEO_H264_LEVEL_3_1" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_LEVEL_3_2, "V4L2_MPEG_VIDEO_H264_LEVEL_3_2" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_LEVEL_4_0, "V4L2_MPEG_VIDEO_H264_LEVEL_4_0" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_LEVEL_4_1, "V4L2_MPEG_VIDEO_H264_LEVEL_4_1" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_LEVEL_4_2, "V4L2_MPEG_VIDEO_H264_LEVEL_4_2" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_LEVEL_5_0, "V4L2_MPEG_VIDEO_H264_LEVEL_5_0" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_LEVEL_5_1, "V4L2_MPEG_VIDEO_H264_LEVEL_5_1" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_LEVEL_5_2, "V4L2_MPEG_VIDEO_H264_LEVEL_5_2" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_LEVEL_6_0, "V4L2_MPEG_VIDEO_H264_LEVEL_6_0" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_LEVEL_6_1, "V4L2_MPEG_VIDEO_H264_LEVEL_6_1" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_LEVEL_6_2, "V4L2_MPEG_VIDEO_H264_LEVEL_6_2" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_LOOP_FILTER_MODE_ENABLED, "V4L2_MPEG_VIDEO_H264_LOOP_FILTER_MODE_ENABLED" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_LOOP_FILTER_MODE_DISABLED, "V4L2_MPEG_VIDEO_H264_LOOP_FILTER_MODE_DISABLED" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_LOOP_FILTER_MODE_DISABLED_AT_SLICE_BOUNDARY, "V4L2_MPEG_VIDEO_H264_LOOP_FILTER_MODE_DISABLED_AT_SLICE_BOUNDARY" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_PROFILE_BASELINE, "V4L2_MPEG_VIDEO_H264_PROFILE_BASELINE" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_PROFILE_CONSTRAINED_BASELINE, "V4L2_MPEG_VIDEO_H264_PROFILE_CONSTRAINED_BASELINE" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_PROFILE_MAIN, "V4L2_MPEG_VIDEO_H264_PROFILE_MAIN" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_PROFILE_EXTENDED, "V4L2_MPEG_VIDEO_H264_PROFILE_EXTENDED" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_PROFILE_HIGH, "V4L2_MPEG_VIDEO_H264_PROFILE_HIGH" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_PROFILE_HIGH_10, "V4L2_MPEG_VIDEO_H264_PROFILE_HIGH_10" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_PROFILE_HIGH_422, "V4L2_MPEG_VIDEO_H264_PROFILE_HIGH_422" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_PROFILE_HIGH_444_PREDICTIVE, "V4L2_MPEG_VIDEO_H264_PROFILE_HIGH_444_PREDICTIVE" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_PROFILE_HIGH_10_INTRA, "V4L2_MPEG_VIDEO_H264_PROFILE_HIGH_10_INTRA" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_PROFILE_HIGH_422_INTRA, "V4L2_MPEG_VIDEO_H264_PROFILE_HIGH_422_INTRA" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_PROFILE_HIGH_444_INTRA, "V4L2_MPEG_VIDEO_H264_PROFILE_HIGH_444_INTRA" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_PROFILE_CAVLC_444_INTRA, "V4L2_MPEG_VIDEO_H264_PROFILE_CAVLC_444_INTRA" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_PROFILE_SCALABLE_BASELINE, "V4L2_MPEG_VIDEO_H264_PROFILE_SCALABLE_BASELINE" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_PROFILE_SCALABLE_HIGH, "V4L2_MPEG_VIDEO_H264_PROFILE_SCALABLE_HIGH" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_PROFILE_SCALABLE_HIGH_INTRA, "V4L2_MPEG_VIDEO_H264_PROFILE_SCALABLE_HIGH_INTRA" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_PROFILE_STEREO_HIGH, "V4L2_MPEG_VIDEO_H264_PROFILE_STEREO_HIGH" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_PROFILE_MULTIVIEW_HIGH, "V4L2_MPEG_VIDEO_H264_PROFILE_MULTIVIEW_HIGH" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_PROFILE_CONSTRAINED_HIGH, "V4L2_MPEG_VIDEO_H264_PROFILE_CONSTRAINED_HIGH" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_VUI_SAR_IDC_UNSPECIFIED, "V4L2_MPEG_VIDEO_H264_VUI_SAR_IDC_UNSPECIFIED" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_VUI_SAR_IDC_1x1, "V4L2_MPEG_VIDEO_H264_VUI_SAR_IDC_1x1" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_VUI_SAR_IDC_12x11, "V4L2_MPEG_VIDEO_H264_VUI_SAR_IDC_12x11" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_VUI_SAR_IDC_10x11, "V4L2_MPEG_VIDEO_H264_VUI_SAR_IDC_10x11" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_VUI_SAR_IDC_16x11, "V4L2_MPEG_VIDEO_H264_VUI_SAR_IDC_16x11" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_VUI_SAR_IDC_40x33, "V4L2_MPEG_VIDEO_H264_VUI_SAR_IDC_40x33" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_VUI_SAR_IDC_24x11, "V4L2_MPEG_VIDEO_H264_VUI_SAR_IDC_24x11" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_VUI_SAR_IDC_20x11, "V4L2_MPEG_VIDEO_H264_VUI_SAR_IDC_20x11" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_VUI_SAR_IDC_32x11, "V4L2_MPEG_VIDEO_H264_VUI_SAR_IDC_32x11" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_VUI_SAR_IDC_80x33, "V4L2_MPEG_VIDEO_H264_VUI_SAR_IDC_80x33" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_VUI_SAR_IDC_18x11, "V4L2_MPEG_VIDEO_H264_VUI_SAR_IDC_18x11" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_VUI_SAR_IDC_15x11, "V4L2_MPEG_VIDEO_H264_VUI_SAR_IDC_15x11" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_VUI_SAR_IDC_64x33, "V4L2_MPEG_VIDEO_H264_VUI_SAR_IDC_64x33" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_VUI_SAR_IDC_160x99, "V4L2_MPEG_VIDEO_H264_VUI_SAR_IDC_160x99" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_VUI_SAR_IDC_4x3, "V4L2_MPEG_VIDEO_H264_VUI_SAR_IDC_4x3" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_VUI_SAR_IDC_3x2, "V4L2_MPEG_VIDEO_H264_VUI_SAR_IDC_3x2" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_VUI_SAR_IDC_2x1, "V4L2_MPEG_VIDEO_H264_VUI_SAR_IDC_2x1" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_VUI_SAR_IDC_EXTENDED, "V4L2_MPEG_VIDEO_H264_VUI_SAR_IDC_EXTENDED" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_SEI_FP_ARRANGEMENT_TYPE_CHECKERBOARD, "V4L2_MPEG_VIDEO_H264_SEI_FP_ARRANGEMENT_TYPE_CHECKERBOARD" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_SEI_FP_ARRANGEMENT_TYPE_COLUMN, "V4L2_MPEG_VIDEO_H264_SEI_FP_ARRANGEMENT_TYPE_COLUMN" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_SEI_FP_ARRANGEMENT_TYPE_ROW, "V4L2_MPEG_VIDEO_H264_SEI_FP_ARRANGEMENT_TYPE_ROW" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_SEI_FP_ARRANGEMENT_TYPE_SIDE_BY_SIDE, "V4L2_MPEG_VIDEO_H264_SEI_FP_ARRANGEMENT_TYPE_SIDE_BY_SIDE" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_SEI_FP_ARRANGEMENT_TYPE_TOP_BOTTOM, "V4L2_MPEG_VIDEO_H264_SEI_FP_ARRANGEMENT_TYPE_TOP_BOTTOM" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_SEI_FP_ARRANGEMENT_TYPE_TEMPORAL, "V4L2_MPEG_VIDEO_H264_SEI_FP_ARRANGEMENT_TYPE_TEMPORAL" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_FMO_MAP_TYPE_INTERLEAVED_SLICES, "V4L2_MPEG_VIDEO_H264_FMO_MAP_TYPE_INTERLEAVED_SLICES" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_FMO_MAP_TYPE_SCATTERED_SLICES, "V4L2_MPEG_VIDEO_H264_FMO_MAP_TYPE_SCATTERED_SLICES" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_FMO_MAP_TYPE_FOREGROUND_WITH_LEFT_OVER, "V4L2_MPEG_VIDEO_H264_FMO_MAP_TYPE_FOREGROUND_WITH_LEFT_OVER" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_FMO_MAP_TYPE_BOX_OUT, "V4L2_MPEG_VIDEO_H264_FMO_MAP_TYPE_BOX_OUT" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_FMO_MAP_TYPE_RASTER_SCAN, "V4L2_MPEG_VIDEO_H264_FMO_MAP_TYPE_RASTER_SCAN" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_FMO_MAP_TYPE_WIPE_SCAN, "V4L2_MPEG_VIDEO_H264_FMO_MAP_TYPE_WIPE_SCAN" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_FMO_MAP_TYPE_EXPLICIT, "V4L2_MPEG_VIDEO_H264_FMO_MAP_TYPE_EXPLICIT" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_FMO_CHANGE_DIR_RIGHT, "V4L2_MPEG_VIDEO_H264_FMO_CHANGE_DIR_RIGHT" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_FMO_CHANGE_DIR_LEFT, "V4L2_MPEG_VIDEO_H264_FMO_CHANGE_DIR_LEFT" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_HIERARCHICAL_CODING_B, "V4L2_MPEG_VIDEO_H264_HIERARCHICAL_CODING_B" );
	swigIntConstant( V4L2_MPEG_VIDEO_H264_HIERARCHICAL_CODING_P, "V4L2_MPEG_VIDEO_H264_HIERARCHICAL_CODING_P" );
	swigIntConstant( V4L2_MPEG_VIDEO_MPEG4_LEVEL_0, "V4L2_MPEG_VIDEO_MPEG4_LEVEL_0" );
	swigIntConstant( V4L2_MPEG_VIDEO_MPEG4_LEVEL_0B, "V4L2_MPEG_VIDEO_MPEG4_LEVEL_0B" );
	swigIntConstant( V4L2_MPEG_VIDEO_MPEG4_LEVEL_1, "V4L2_MPEG_VIDEO_MPEG4_LEVEL_1" );
	swigIntConstant( V4L2_MPEG_VIDEO_MPEG4_LEVEL_2, "V4L2_MPEG_VIDEO_MPEG4_LEVEL_2" );
	swigIntConstant( V4L2_MPEG_VIDEO_MPEG4_LEVEL_3, "V4L2_MPEG_VIDEO_MPEG4_LEVEL_3" );
	swigIntConstant( V4L2_MPEG_VIDEO_MPEG4_LEVEL_3B, "V4L2_MPEG_VIDEO_MPEG4_LEVEL_3B" );
	swigIntConstant( V4L2_MPEG_VIDEO_MPEG4_LEVEL_4, "V4L2_MPEG_VIDEO_MPEG4_LEVEL_4" );
	swigIntConstant( V4L2_MPEG_VIDEO_MPEG4_LEVEL_5, "V4L2_MPEG_VIDEO_MPEG4_LEVEL_5" );
	swigIntConstant( V4L2_MPEG_VIDEO_MPEG4_PROFILE_SIMPLE, "V4L2_MPEG_VIDEO_MPEG4_PROFILE_SIMPLE" );
	swigIntConstant( V4L2_MPEG_VIDEO_MPEG4_PROFILE_ADVANCED_SIMPLE, "V4L2_MPEG_VIDEO_MPEG4_PROFILE_ADVANCED_SIMPLE" );
	swigIntConstant( V4L2_MPEG_VIDEO_MPEG4_PROFILE_CORE, "V4L2_MPEG_VIDEO_MPEG4_PROFILE_CORE" );
	swigIntConstant( V4L2_MPEG_VIDEO_MPEG4_PROFILE_SIMPLE_SCALABLE, "V4L2_MPEG_VIDEO_MPEG4_PROFILE_SIMPLE_SCALABLE" );
	swigIntConstant( V4L2_MPEG_VIDEO_MPEG4_PROFILE_ADVANCED_CODING_EFFICIENCY, "V4L2_MPEG_VIDEO_MPEG4_PROFILE_ADVANCED_CODING_EFFICIENCY" );
	swigIntConstant( V4L2_CID_MPEG_VIDEO_VPX_1_PARTITION, "V4L2_CID_MPEG_VIDEO_VPX_1_PARTITION" );
	swigIntConstant( V4L2_CID_MPEG_VIDEO_VPX_2_PARTITIONS, "V4L2_CID_MPEG_VIDEO_VPX_2_PARTITIONS" );
	swigIntConstant( V4L2_CID_MPEG_VIDEO_VPX_4_PARTITIONS, "V4L2_CID_MPEG_VIDEO_VPX_4_PARTITIONS" );
	swigIntConstant( V4L2_CID_MPEG_VIDEO_VPX_8_PARTITIONS, "V4L2_CID_MPEG_VIDEO_VPX_8_PARTITIONS" );
	swigIntConstant( V4L2_CID_MPEG_VIDEO_VPX_1_REF_FRAME, "V4L2_CID_MPEG_VIDEO_VPX_1_REF_FRAME" );
	swigIntConstant( V4L2_CID_MPEG_VIDEO_VPX_2_REF_FRAME, "V4L2_CID_MPEG_VIDEO_VPX_2_REF_FRAME" );
	swigIntConstant( V4L2_CID_MPEG_VIDEO_VPX_3_REF_FRAME, "V4L2_CID_MPEG_VIDEO_VPX_3_REF_FRAME" );
	swigIntConstant( V4L2_CID_MPEG_VIDEO_VPX_GOLDEN_FRAME_USE_PREV, "V4L2_CID_MPEG_VIDEO_VPX_GOLDEN_FRAME_USE_PREV" );
	swigIntConstant( V4L2_CID_MPEG_VIDEO_VPX_GOLDEN_FRAME_USE_REF_PERIOD, "V4L2_CID_MPEG_VIDEO_VPX_GOLDEN_FRAME_USE_REF_PERIOD" );
	swigIntConstant( V4L2_MPEG_VIDEO_VP8_PROFILE_0, "V4L2_MPEG_VIDEO_VP8_PROFILE_0" );
	swigIntConstant( V4L2_MPEG_VIDEO_VP8_PROFILE_1, "V4L2_MPEG_VIDEO_VP8_PROFILE_1" );
	swigIntConstant( V4L2_MPEG_VIDEO_VP8_PROFILE_2, "V4L2_MPEG_VIDEO_VP8_PROFILE_2" );
	swigIntConstant( V4L2_MPEG_VIDEO_VP8_PROFILE_3, "V4L2_MPEG_VIDEO_VP8_PROFILE_3" );
	swigIntConstant( V4L2_MPEG_VIDEO_VP9_PROFILE_0, "V4L2_MPEG_VIDEO_VP9_PROFILE_0" );
	swigIntConstant( V4L2_MPEG_VIDEO_VP9_PROFILE_1, "V4L2_MPEG_VIDEO_VP9_PROFILE_1" );
	swigIntConstant( V4L2_MPEG_VIDEO_VP9_PROFILE_2, "V4L2_MPEG_VIDEO_VP9_PROFILE_2" );
	swigIntConstant( V4L2_MPEG_VIDEO_VP9_PROFILE_3, "V4L2_MPEG_VIDEO_VP9_PROFILE_3" );
	swigIntConstant( V4L2_MPEG_VIDEO_VP9_LEVEL_1_0, "V4L2_MPEG_VIDEO_VP9_LEVEL_1_0" );
	swigIntConstant( V4L2_MPEG_VIDEO_VP9_LEVEL_1_1, "V4L2_MPEG_VIDEO_VP9_LEVEL_1_1" );
	swigIntConstant( V4L2_MPEG_VIDEO_VP9_LEVEL_2_0, "V4L2_MPEG_VIDEO_VP9_LEVEL_2_0" );
	swigIntConstant( V4L2_MPEG_VIDEO_VP9_LEVEL_2_1, "V4L2_MPEG_VIDEO_VP9_LEVEL_2_1" );
	swigIntConstant( V4L2_MPEG_VIDEO_VP9_LEVEL_3_0, "V4L2_MPEG_VIDEO_VP9_LEVEL_3_0" );
	swigIntConstant( V4L2_MPEG_VIDEO_VP9_LEVEL_3_1, "V4L2_MPEG_VIDEO_VP9_LEVEL_3_1" );
	swigIntConstant( V4L2_MPEG_VIDEO_VP9_LEVEL_4_0, "V4L2_MPEG_VIDEO_VP9_LEVEL_4_0" );
	swigIntConstant( V4L2_MPEG_VIDEO_VP9_LEVEL_4_1, "V4L2_MPEG_VIDEO_VP9_LEVEL_4_1" );
	swigIntConstant( V4L2_MPEG_VIDEO_VP9_LEVEL_5_0, "V4L2_MPEG_VIDEO_VP9_LEVEL_5_0" );
	swigIntConstant( V4L2_MPEG_VIDEO_VP9_LEVEL_5_1, "V4L2_MPEG_VIDEO_VP9_LEVEL_5_1" );
	swigIntConstant( V4L2_MPEG_VIDEO_VP9_LEVEL_5_2, "V4L2_MPEG_VIDEO_VP9_LEVEL_5_2" );
	swigIntConstant( V4L2_MPEG_VIDEO_VP9_LEVEL_6_0, "V4L2_MPEG_VIDEO_VP9_LEVEL_6_0" );
	swigIntConstant( V4L2_MPEG_VIDEO_VP9_LEVEL_6_1, "V4L2_MPEG_VIDEO_VP9_LEVEL_6_1" );
	swigIntConstant( V4L2_MPEG_VIDEO_VP9_LEVEL_6_2, "V4L2_MPEG_VIDEO_VP9_LEVEL_6_2" );
	swigIntConstant( V4L2_MPEG_VIDEO_HEVC_HIERARCHICAL_CODING_B, "V4L2_MPEG_VIDEO_HEVC_HIERARCHICAL_CODING_B" );
	swigIntConstant( V4L2_MPEG_VIDEO_HEVC_HIERARCHICAL_CODING_P, "V4L2_MPEG_VIDEO_HEVC_HIERARCHICAL_CODING_P" );
	swigIntConstant( V4L2_MPEG_VIDEO_HEVC_PROFILE_MAIN, "V4L2_MPEG_VIDEO_HEVC_PROFILE_MAIN" );
	swigIntConstant( V4L2_MPEG_VIDEO_HEVC_PROFILE_MAIN_STILL_PICTURE, "V4L2_MPEG_VIDEO_HEVC_PROFILE_MAIN_STILL_PICTURE" );
	swigIntConstant( V4L2_MPEG_VIDEO_HEVC_PROFILE_MAIN_10, "V4L2_MPEG_VIDEO_HEVC_PROFILE_MAIN_10" );
	swigIntConstant( V4L2_MPEG_VIDEO_HEVC_LEVEL_1, "V4L2_MPEG_VIDEO_HEVC_LEVEL_1" );
	swigIntConstant( V4L2_MPEG_VIDEO_HEVC_LEVEL_2, "V4L2_MPEG_VIDEO_HEVC_LEVEL_2" );
	swigIntConstant( V4L2_MPEG_VIDEO_HEVC_LEVEL_2_1, "V4L2_MPEG_VIDEO_HEVC_LEVEL_2_1" );
	swigIntConstant( V4L2_MPEG_VIDEO_HEVC_LEVEL_3, "V4L2_MPEG_VIDEO_HEVC_LEVEL_3" );
	swigIntConstant( V4L2_MPEG_VIDEO_HEVC_LEVEL_3_1, "V4L2_MPEG_VIDEO_HEVC_LEVEL_3_1" );
	swigIntConstant( V4L2_MPEG_VIDEO_HEVC_LEVEL_4, "V4L2_MPEG_VIDEO_HEVC_LEVEL_4" );
	swigIntConstant( V4L2_MPEG_VIDEO_HEVC_LEVEL_4_1, "V4L2_MPEG_VIDEO_HEVC_LEVEL_4_1" );
	swigIntConstant( V4L2_MPEG_VIDEO_HEVC_LEVEL_5, "V4L2_MPEG_VIDEO_HEVC_LEVEL_5" );
	swigIntConstant( V4L2_MPEG_VIDEO_HEVC_LEVEL_5_1, "V4L2_MPEG_VIDEO_HEVC_LEVEL_5_1" );
	swigIntConstant( V4L2_MPEG_VIDEO_HEVC_LEVEL_5_2, "V4L2_MPEG_VIDEO_HEVC_LEVEL_5_2" );
	swigIntConstant( V4L2_MPEG_VIDEO_HEVC_LEVEL_6, "V4L2_MPEG_VIDEO_HEVC_LEVEL_6" );
	swigIntConstant( V4L2_MPEG_VIDEO_HEVC_LEVEL_6_1, "V4L2_MPEG_VIDEO_HEVC_LEVEL_6_1" );
	swigIntConstant( V4L2_MPEG_VIDEO_HEVC_LEVEL_6_2, "V4L2_MPEG_VIDEO_HEVC_LEVEL_6_2" );
	swigIntConstant( V4L2_MPEG_VIDEO_HEVC_TIER_MAIN, "V4L2_MPEG_VIDEO_HEVC_TIER_MAIN" );
	swigIntConstant( V4L2_MPEG_VIDEO_HEVC_TIER_HIGH, "V4L2_MPEG_VIDEO_HEVC_TIER_HIGH" );
	swigIntConstant( V4L2_MPEG_VIDEO_HEVC_LOOP_FILTER_MODE_DISABLED, "V4L2_MPEG_VIDEO_HEVC_LOOP_FILTER_MODE_DISABLED" );
	swigIntConstant( V4L2_MPEG_VIDEO_HEVC_LOOP_FILTER_MODE_ENABLED, "V4L2_MPEG_VIDEO_HEVC_LOOP_FILTER_MODE_ENABLED" );
	swigIntConstant( V4L2_MPEG_VIDEO_HEVC_LOOP_FILTER_MODE_DISABLED_AT_SLICE_BOUNDARY, "V4L2_MPEG_VIDEO_HEVC_LOOP_FILTER_MODE_DISABLED_AT_SLICE_BOUNDARY" );
	swigIntConstant( V4L2_MPEG_VIDEO_HEVC_REFRESH_NONE, "V4L2_MPEG_VIDEO_HEVC_REFRESH_NONE" );
	swigIntConstant( V4L2_MPEG_VIDEO_HEVC_REFRESH_CRA, "V4L2_MPEG_VIDEO_HEVC_REFRESH_CRA" );
	swigIntConstant( V4L2_MPEG_VIDEO_HEVC_REFRESH_IDR, "V4L2_MPEG_VIDEO_HEVC_REFRESH_IDR" );
	swigIntConstant( V4L2_MPEG_VIDEO_HEVC_SIZE_0, "V4L2_MPEG_VIDEO_HEVC_SIZE_0" );
	swigIntConstant( V4L2_MPEG_VIDEO_HEVC_SIZE_1, "V4L2_MPEG_VIDEO_HEVC_SIZE_1" );
	swigIntConstant( V4L2_MPEG_VIDEO_HEVC_SIZE_2, "V4L2_MPEG_VIDEO_HEVC_SIZE_2" );
	swigIntConstant( V4L2_MPEG_VIDEO_HEVC_SIZE_4, "V4L2_MPEG_VIDEO_HEVC_SIZE_4" );
	swigIntConstant( V4L2_MPEG_VIDEO_FRAME_SKIP_MODE_DISABLED, "V4L2_MPEG_VIDEO_FRAME_SKIP_MODE_DISABLED" );
	swigIntConstant( V4L2_MPEG_VIDEO_FRAME_SKIP_MODE_LEVEL_LIMIT, "V4L2_MPEG_VIDEO_FRAME_SKIP_MODE_LEVEL_LIMIT" );
	swigIntConstant( V4L2_MPEG_VIDEO_FRAME_SKIP_MODE_BUF_LIMIT, "V4L2_MPEG_VIDEO_FRAME_SKIP_MODE_BUF_LIMIT" );
	swigIntConstant( V4L2_MPEG_CX2341X_VIDEO_SPATIAL_FILTER_MODE_MANUAL, "V4L2_MPEG_CX2341X_VIDEO_SPATIAL_FILTER_MODE_MANUAL" );
	swigIntConstant( V4L2_MPEG_CX2341X_VIDEO_SPATIAL_FILTER_MODE_AUTO, "V4L2_MPEG_CX2341X_VIDEO_SPATIAL_FILTER_MODE_AUTO" );
	swigIntConstant( V4L2_MPEG_CX2341X_VIDEO_LUMA_SPATIAL_FILTER_TYPE_OFF, "V4L2_MPEG_CX2341X_VIDEO_LUMA_SPATIAL_FILTER_TYPE_OFF" );
	swigIntConstant( V4L2_MPEG_CX2341X_VIDEO_LUMA_SPATIAL_FILTER_TYPE_1D_HOR, "V4L2_MPEG_CX2341X_VIDEO_LUMA_SPATIAL_FILTER_TYPE_1D_HOR" );
	swigIntConstant( V4L2_MPEG_CX2341X_VIDEO_LUMA_SPATIAL_FILTER_TYPE_1D_VERT, "V4L2_MPEG_CX2341X_VIDEO_LUMA_SPATIAL_FILTER_TYPE_1D_VERT" );
	swigIntConstant( V4L2_MPEG_CX2341X_VIDEO_LUMA_SPATIAL_FILTER_TYPE_2D_HV_SEPARABLE, "V4L2_MPEG_CX2341X_VIDEO_LUMA_SPATIAL_FILTER_TYPE_2D_HV_SEPARABLE" );
	swigIntConstant( V4L2_MPEG_CX2341X_VIDEO_LUMA_SPATIAL_FILTER_TYPE_2D_SYM_NON_SEPARABLE, "V4L2_MPEG_CX2341X_VIDEO_LUMA_SPATIAL_FILTER_TYPE_2D_SYM_NON_SEPARABLE" );
	swigIntConstant( V4L2_MPEG_CX2341X_VIDEO_CHROMA_SPATIAL_FILTER_TYPE_OFF, "V4L2_MPEG_CX2341X_VIDEO_CHROMA_SPATIAL_FILTER_TYPE_OFF" );
	swigIntConstant( V4L2_MPEG_CX2341X_VIDEO_CHROMA_SPATIAL_FILTER_TYPE_1D_HOR, "V4L2_MPEG_CX2341X_VIDEO_CHROMA_SPATIAL_FILTER_TYPE_1D_HOR" );
	swigIntConstant( V4L2_MPEG_CX2341X_VIDEO_TEMPORAL_FILTER_MODE_MANUAL, "V4L2_MPEG_CX2341X_VIDEO_TEMPORAL_FILTER_MODE_MANUAL" );
	swigIntConstant( V4L2_MPEG_CX2341X_VIDEO_TEMPORAL_FILTER_MODE_AUTO, "V4L2_MPEG_CX2341X_VIDEO_TEMPORAL_FILTER_MODE_AUTO" );
	swigIntConstant( V4L2_MPEG_CX2341X_VIDEO_MEDIAN_FILTER_TYPE_OFF, "V4L2_MPEG_CX2341X_VIDEO_MEDIAN_FILTER_TYPE_OFF" );
	swigIntConstant( V4L2_MPEG_CX2341X_VIDEO_MEDIAN_FILTER_TYPE_HOR, "V4L2_MPEG_CX2341X_VIDEO_MEDIAN_FILTER_TYPE_HOR" );
	swigIntConstant( V4L2_MPEG_CX2341X_VIDEO_MEDIAN_FILTER_TYPE_VERT, "V4L2_MPEG_CX2341X_VIDEO_MEDIAN_FILTER_TYPE_VERT" );
	swigIntConstant( V4L2_MPEG_CX2341X_VIDEO_MEDIAN_FILTER_TYPE_HOR_VERT, "V4L2_MPEG_CX2341X_VIDEO_MEDIAN_FILTER_TYPE_HOR_VERT" );
	swigIntConstant( V4L2_MPEG_CX2341X_VIDEO_MEDIAN_FILTER_TYPE_DIAG, "V4L2_MPEG_CX2341X_VIDEO_MEDIAN_FILTER_TYPE_DIAG" );
	swigIntConstant( V4L2_MPEG_MFC51_VIDEO_FRAME_SKIP_MODE_DISABLED, "V4L2_MPEG_MFC51_VIDEO_FRAME_SKIP_MODE_DISABLED" );
	swigIntConstant( V4L2_MPEG_MFC51_VIDEO_FRAME_SKIP_MODE_LEVEL_LIMIT, "V4L2_MPEG_MFC51_VIDEO_FRAME_SKIP_MODE_LEVEL_LIMIT" );
	swigIntConstant( V4L2_MPEG_MFC51_VIDEO_FRAME_SKIP_MODE_BUF_LIMIT, "V4L2_MPEG_MFC51_VIDEO_FRAME_SKIP_MODE_BUF_LIMIT" );
	swigIntConstant( V4L2_MPEG_MFC51_VIDEO_FORCE_FRAME_TYPE_DISABLED, "V4L2_MPEG_MFC51_VIDEO_FORCE_FRAME_TYPE_DISABLED" );
	swigIntConstant( V4L2_MPEG_MFC51_VIDEO_FORCE_FRAME_TYPE_I_FRAME, "V4L2_MPEG_MFC51_VIDEO_FORCE_FRAME_TYPE_I_FRAME" );
	swigIntConstant( V4L2_MPEG_MFC51_VIDEO_FORCE_FRAME_TYPE_NOT_CODED, "V4L2_MPEG_MFC51_VIDEO_FORCE_FRAME_TYPE_NOT_CODED" );
	swigIntConstant( V4L2_EXPOSURE_AUTO, "V4L2_EXPOSURE_AUTO" );
	swigIntConstant( V4L2_EXPOSURE_MANUAL, "V4L2_EXPOSURE_MANUAL" );
	swigIntConstant( V4L2_EXPOSURE_SHUTTER_PRIORITY, "V4L2_EXPOSURE_SHUTTER_PRIORITY" );
	swigIntConstant( V4L2_EXPOSURE_APERTURE_PRIORITY, "V4L2_EXPOSURE_APERTURE_PRIORITY" );
	swigIntConstant( V4L2_WHITE_BALANCE_MANUAL, "V4L2_WHITE_BALANCE_MANUAL" );
	swigIntConstant( V4L2_WHITE_BALANCE_AUTO, "V4L2_WHITE_BALANCE_AUTO" );
	swigIntConstant( V4L2_WHITE_BALANCE_INCANDESCENT, "V4L2_WHITE_BALANCE_INCANDESCENT" );
	swigIntConstant( V4L2_WHITE_BALANCE_FLUORESCENT, "V4L2_WHITE_BALANCE_FLUORESCENT" );
	swigIntConstant( V4L2_WHITE_BALANCE_FLUORESCENT_H, "V4L2_WHITE_BALANCE_FLUORESCENT_H" );
	swigIntConstant( V4L2_WHITE_BALANCE_HORIZON, "V4L2_WHITE_BALANCE_HORIZON" );
	swigIntConstant( V4L2_WHITE_BALANCE_DAYLIGHT, "V4L2_WHITE_BALANCE_DAYLIGHT" );
	swigIntConstant( V4L2_WHITE_BALANCE_FLASH, "V4L2_WHITE_BALANCE_FLASH" );
	swigIntConstant( V4L2_WHITE_BALANCE_CLOUDY, "V4L2_WHITE_BALANCE_CLOUDY" );
	swigIntConstant( V4L2_WHITE_BALANCE_SHADE, "V4L2_WHITE_BALANCE_SHADE" );
	swigIntConstant( V4L2_ISO_SENSITIVITY_MANUAL, "V4L2_ISO_SENSITIVITY_MANUAL" );
	swigIntConstant( V4L2_ISO_SENSITIVITY_AUTO, "V4L2_ISO_SENSITIVITY_AUTO" );
	swigIntConstant( V4L2_EXPOSURE_METERING_AVERAGE, "V4L2_EXPOSURE_METERING_AVERAGE" );
	swigIntConstant( V4L2_EXPOSURE_METERING_CENTER_WEIGHTED, "V4L2_EXPOSURE_METERING_CENTER_WEIGHTED" );
	swigIntConstant( V4L2_EXPOSURE_METERING_SPOT, "V4L2_EXPOSURE_METERING_SPOT" );
	swigIntConstant( V4L2_EXPOSURE_METERING_MATRIX, "V4L2_EXPOSURE_METERING_MATRIX" );
	swigIntConstant( V4L2_SCENE_MODE_NONE, "V4L2_SCENE_MODE_NONE" );
	swigIntConstant( V4L2_SCENE_MODE_BACKLIGHT, "V4L2_SCENE_MODE_BACKLIGHT" );
	swigIntConstant( V4L2_SCENE_MODE_BEACH_SNOW, "V4L2_SCENE_MODE_BEACH_SNOW" );
	swigIntConstant( V4L2_SCENE_MODE_CANDLE_LIGHT, "V4L2_SCENE_MODE_CANDLE_LIGHT" );
	swigIntConstant( V4L2_SCENE_MODE_DAWN_DUSK, "V4L2_SCENE_MODE_DAWN_DUSK" );
	swigIntConstant( V4L2_SCENE_MODE_FALL_COLORS, "V4L2_SCENE_MODE_FALL_COLORS" );
	swigIntConstant( V4L2_SCENE_MODE_FIREWORKS, "V4L2_SCENE_MODE_FIREWORKS" );
	swigIntConstant( V4L2_SCENE_MODE_LANDSCAPE, "V4L2_SCENE_MODE_LANDSCAPE" );
	swigIntConstant( V4L2_SCENE_MODE_NIGHT, "V4L2_SCENE_MODE_NIGHT" );
	swigIntConstant( V4L2_SCENE_MODE_PARTY_INDOOR, "V4L2_SCENE_MODE_PARTY_INDOOR" );
	swigIntConstant( V4L2_SCENE_MODE_PORTRAIT, "V4L2_SCENE_MODE_PORTRAIT" );
	swigIntConstant( V4L2_SCENE_MODE_SPORTS, "V4L2_SCENE_MODE_SPORTS" );
	swigIntConstant( V4L2_SCENE_MODE_SUNSET, "V4L2_SCENE_MODE_SUNSET" );
	swigIntConstant( V4L2_SCENE_MODE_TEXT, "V4L2_SCENE_MODE_TEXT" );
	swigIntConstant( V4L2_AUTO_FOCUS_RANGE_AUTO, "V4L2_AUTO_FOCUS_RANGE_AUTO" );
	swigIntConstant( V4L2_AUTO_FOCUS_RANGE_NORMAL, "V4L2_AUTO_FOCUS_RANGE_NORMAL" );
	swigIntConstant( V4L2_AUTO_FOCUS_RANGE_MACRO, "V4L2_AUTO_FOCUS_RANGE_MACRO" );
	swigIntConstant( V4L2_AUTO_FOCUS_RANGE_INFINITY, "V4L2_AUTO_FOCUS_RANGE_INFINITY" );
	swigIntConstant( V4L2_PREEMPHASIS_DISABLED, "V4L2_PREEMPHASIS_DISABLED" );
	swigIntConstant( V4L2_PREEMPHASIS_50_uS, "V4L2_PREEMPHASIS_50_uS" );
	swigIntConstant( V4L2_PREEMPHASIS_75_uS, "V4L2_PREEMPHASIS_75_uS" );
	swigIntConstant( V4L2_FLASH_LED_MODE_NONE, "V4L2_FLASH_LED_MODE_NONE" );
	swigIntConstant( V4L2_FLASH_LED_MODE_FLASH, "V4L2_FLASH_LED_MODE_FLASH" );
	swigIntConstant( V4L2_FLASH_LED_MODE_TORCH, "V4L2_FLASH_LED_MODE_TORCH" );
	swigIntConstant( V4L2_FLASH_STROBE_SOURCE_SOFTWARE, "V4L2_FLASH_STROBE_SOURCE_SOFTWARE" );
	swigIntConstant( V4L2_FLASH_STROBE_SOURCE_EXTERNAL, "V4L2_FLASH_STROBE_SOURCE_EXTERNAL" );
	swigIntConstant( V4L2_JPEG_CHROMA_SUBSAMPLING_444, "V4L2_JPEG_CHROMA_SUBSAMPLING_444" );
	swigIntConstant( V4L2_JPEG_CHROMA_SUBSAMPLING_422, "V4L2_JPEG_CHROMA_SUBSAMPLING_422" );
	swigIntConstant( V4L2_JPEG_CHROMA_SUBSAMPLING_420, "V4L2_JPEG_CHROMA_SUBSAMPLING_420" );
	swigIntConstant( V4L2_JPEG_CHROMA_SUBSAMPLING_411, "V4L2_JPEG_CHROMA_SUBSAMPLING_411" );
	swigIntConstant( V4L2_JPEG_CHROMA_SUBSAMPLING_410, "V4L2_JPEG_CHROMA_SUBSAMPLING_410" );
	swigIntConstant( V4L2_JPEG_CHROMA_SUBSAMPLING_GRAY, "V4L2_JPEG_CHROMA_SUBSAMPLING_GRAY" );
	swigIntConstant( V4L2_DV_TX_MODE_DVI_D, "V4L2_DV_TX_MODE_DVI_D" );
	swigIntConstant( V4L2_DV_TX_MODE_HDMI, "V4L2_DV_TX_MODE_HDMI" );
	swigIntConstant( V4L2_DV_RGB_RANGE_AUTO, "V4L2_DV_RGB_RANGE_AUTO" );
	swigIntConstant( V4L2_DV_RGB_RANGE_LIMITED, "V4L2_DV_RGB_RANGE_LIMITED" );
	swigIntConstant( V4L2_DV_RGB_RANGE_FULL, "V4L2_DV_RGB_RANGE_FULL" );
	swigIntConstant( V4L2_DV_IT_CONTENT_TYPE_GRAPHICS, "V4L2_DV_IT_CONTENT_TYPE_GRAPHICS" );
	swigIntConstant( V4L2_DV_IT_CONTENT_TYPE_PHOTO, "V4L2_DV_IT_CONTENT_TYPE_PHOTO" );
	swigIntConstant( V4L2_DV_IT_CONTENT_TYPE_CINEMA, "V4L2_DV_IT_CONTENT_TYPE_CINEMA" );
	swigIntConstant( V4L2_DV_IT_CONTENT_TYPE_GAME, "V4L2_DV_IT_CONTENT_TYPE_GAME" );
	swigIntConstant( V4L2_DV_IT_CONTENT_TYPE_NO_ITC, "V4L2_DV_IT_CONTENT_TYPE_NO_ITC" );
	swigIntConstant( V4L2_DEEMPHASIS_DISABLED, "V4L2_DEEMPHASIS_DISABLED" );
	swigIntConstant( V4L2_DEEMPHASIS_50_uS, "V4L2_DEEMPHASIS_50_uS" );
	swigIntConstant( V4L2_DEEMPHASIS_75_uS, "V4L2_DEEMPHASIS_75_uS" );
	swigIntConstant( V4L2_DETECT_MD_MODE_DISABLED, "V4L2_DETECT_MD_MODE_DISABLED" );
	swigIntConstant( V4L2_DETECT_MD_MODE_GLOBAL, "V4L2_DETECT_MD_MODE_GLOBAL" );
	swigIntConstant( V4L2_DETECT_MD_MODE_THRESHOLD_GRID, "V4L2_DETECT_MD_MODE_THRESHOLD_GRID" );
	swigIntConstant( V4L2_DETECT_MD_MODE_REGION_GRID, "V4L2_DETECT_MD_MODE_REGION_GRID" );
	swigIntConstant( V4L2_STATELESS_H264_DECODE_MODE_SLICE_BASED, "V4L2_STATELESS_H264_DECODE_MODE_SLICE_BASED" );
	swigIntConstant( V4L2_STATELESS_H264_DECODE_MODE_FRAME_BASED, "V4L2_STATELESS_H264_DECODE_MODE_FRAME_BASED" );
	swigIntConstant( V4L2_STATELESS_H264_START_CODE_NONE, "V4L2_STATELESS_H264_START_CODE_NONE" );
	swigIntConstant( V4L2_STATELESS_H264_START_CODE_ANNEX_B, "V4L2_STATELESS_H264_START_CODE_ANNEX_B" );
	swigIntConstant( V4L2_MBUS_FMT_FIXED, "V4L2_MBUS_FMT_FIXED" );
	swigIntConstant( V4L2_MBUS_FMT_RGB444_2X8_PADHI_BE, "V4L2_MBUS_FMT_RGB444_2X8_PADHI_BE" );
	swigIntConstant( V4L2_MBUS_FMT_RGB444_2X8_PADHI_LE, "V4L2_MBUS_FMT_RGB444_2X8_PADHI_LE" );
	swigIntConstant( V4L2_MBUS_FMT_RGB555_2X8_PADHI_BE, "V4L2_MBUS_FMT_RGB555_2X8_PADHI_BE" );
	swigIntConstant( V4L2_MBUS_FMT_RGB555_2X8_PADHI_LE, "V4L2_MBUS_FMT_RGB555_2X8_PADHI_LE" );
	swigIntConstant( V4L2_MBUS_FMT_BGR565_2X8_BE, "V4L2_MBUS_FMT_BGR565_2X8_BE" );
	swigIntConstant( V4L2_MBUS_FMT_BGR565_2X8_LE, "V4L2_MBUS_FMT_BGR565_2X8_LE" );
	swigIntConstant( V4L2_MBUS_FMT_RGB565_2X8_BE, "V4L2_MBUS_FMT_RGB565_2X8_BE" );
	swigIntConstant( V4L2_MBUS_FMT_RGB565_2X8_LE, "V4L2_MBUS_FMT_RGB565_2X8_LE" );
	swigIntConstant( V4L2_MBUS_FMT_RGB666_1X18, "V4L2_MBUS_FMT_RGB666_1X18" );
	swigIntConstant( V4L2_MBUS_FMT_RGB888_1X24, "V4L2_MBUS_FMT_RGB888_1X24" );
	swigIntConstant( V4L2_MBUS_FMT_RGB888_2X12_BE, "V4L2_MBUS_FMT_RGB888_2X12_BE" );
	swigIntConstant( V4L2_MBUS_FMT_RGB888_2X12_LE, "V4L2_MBUS_FMT_RGB888_2X12_LE" );
	swigIntConstant( V4L2_MBUS_FMT_ARGB8888_1X32, "V4L2_MBUS_FMT_ARGB8888_1X32" );
	swigIntConstant( V4L2_MBUS_FMT_Y8_1X8, "V4L2_MBUS_FMT_Y8_1X8" );
	swigIntConstant( V4L2_MBUS_FMT_UV8_1X8, "V4L2_MBUS_FMT_UV8_1X8" );
	swigIntConstant( V4L2_MBUS_FMT_UYVY8_1_5X8, "V4L2_MBUS_FMT_UYVY8_1_5X8" );
	swigIntConstant( V4L2_MBUS_FMT_VYUY8_1_5X8, "V4L2_MBUS_FMT_VYUY8_1_5X8" );
	swigIntConstant( V4L2_MBUS_FMT_YUYV8_1_5X8, "V4L2_MBUS_FMT_YUYV8_1_5X8" );
	swigIntConstant( V4L2_MBUS_FMT_YVYU8_1_5X8, "V4L2_MBUS_FMT_YVYU8_1_5X8" );
	swigIntConstant( V4L2_MBUS_FMT_UYVY8_2X8, "V4L2_MBUS_FMT_UYVY8_2X8" );
	swigIntConstant( V4L2_MBUS_FMT_VYUY8_2X8, "V4L2_MBUS_FMT_VYUY8_2X8" );
	swigIntConstant( V4L2_MBUS_FMT_YUYV8_2X8, "V4L2_MBUS_FMT_YUYV8_2X8" );
	swigIntConstant( V4L2_MBUS_FMT_YVYU8_2X8, "V4L2_MBUS_FMT_YVYU8_2X8" );
	swigIntConstant( V4L2_MBUS_FMT_Y10_1X10, "V4L2_MBUS_FMT_Y10_1X10" );
	swigIntConstant( V4L2_MBUS_FMT_UYVY10_2X10, "V4L2_MBUS_FMT_UYVY10_2X10" );
	swigIntConstant( V4L2_MBUS_FMT_VYUY10_2X10, "V4L2_MBUS_FMT_VYUY10_2X10" );
	swigIntConstant( V4L2_MBUS_FMT_YUYV10_2X10, "V4L2_MBUS_FMT_YUYV10_2X10" );
	swigIntConstant( V4L2_MBUS_FMT_YVYU10_2X10, "V4L2_MBUS_FMT_YVYU10_2X10" );
	swigIntConstant( V4L2_MBUS_FMT_Y12_1X12, "V4L2_MBUS_FMT_Y12_1X12" );
	swigIntConstant( V4L2_MBUS_FMT_UYVY8_1X16, "V4L2_MBUS_FMT_UYVY8_1X16" );
	swigIntConstant( V4L2_MBUS_FMT_VYUY8_1X16, "V4L2_MBUS_FMT_VYUY8_1X16" );
	swigIntConstant( V4L2_MBUS_FMT_YUYV8_1X16, "V4L2_MBUS_FMT_YUYV8_1X16" );
	swigIntConstant( V4L2_MBUS_FMT_YVYU8_1X16, "V4L2_MBUS_FMT_YVYU8_1X16" );
	swigIntConstant( V4L2_MBUS_FMT_YDYUYDYV8_1X16, "V4L2_MBUS_FMT_YDYUYDYV8_1X16" );
	swigIntConstant( V4L2_MBUS_FMT_UYVY10_1X20, "V4L2_MBUS_FMT_UYVY10_1X20" );
	swigIntConstant( V4L2_MBUS_FMT_VYUY10_1X20, "V4L2_MBUS_FMT_VYUY10_1X20" );
	swigIntConstant( V4L2_MBUS_FMT_YUYV10_1X20, "V4L2_MBUS_FMT_YUYV10_1X20" );
	swigIntConstant( V4L2_MBUS_FMT_YVYU10_1X20, "V4L2_MBUS_FMT_YVYU10_1X20" );
	swigIntConstant( V4L2_MBUS_FMT_YUV10_1X30, "V4L2_MBUS_FMT_YUV10_1X30" );
	swigIntConstant( V4L2_MBUS_FMT_AYUV8_1X32, "V4L2_MBUS_FMT_AYUV8_1X32" );
	swigIntConstant( V4L2_MBUS_FMT_UYVY12_2X12, "V4L2_MBUS_FMT_UYVY12_2X12" );
	swigIntConstant( V4L2_MBUS_FMT_VYUY12_2X12, "V4L2_MBUS_FMT_VYUY12_2X12" );
	swigIntConstant( V4L2_MBUS_FMT_YUYV12_2X12, "V4L2_MBUS_FMT_YUYV12_2X12" );
	swigIntConstant( V4L2_MBUS_FMT_YVYU12_2X12, "V4L2_MBUS_FMT_YVYU12_2X12" );
	swigIntConstant( V4L2_MBUS_FMT_UYVY12_1X24, "V4L2_MBUS_FMT_UYVY12_1X24" );
	swigIntConstant( V4L2_MBUS_FMT_VYUY12_1X24, "V4L2_MBUS_FMT_VYUY12_1X24" );
	swigIntConstant( V4L2_MBUS_FMT_YUYV12_1X24, "V4L2_MBUS_FMT_YUYV12_1X24" );
	swigIntConstant( V4L2_MBUS_FMT_YVYU12_1X24, "V4L2_MBUS_FMT_YVYU12_1X24" );
	swigIntConstant( V4L2_MBUS_FMT_SBGGR8_1X8, "V4L2_MBUS_FMT_SBGGR8_1X8" );
	swigIntConstant( V4L2_MBUS_FMT_SGBRG8_1X8, "V4L2_MBUS_FMT_SGBRG8_1X8" );
	swigIntConstant( V4L2_MBUS_FMT_SGRBG8_1X8, "V4L2_MBUS_FMT_SGRBG8_1X8" );
	swigIntConstant( V4L2_MBUS_FMT_SRGGB8_1X8, "V4L2_MBUS_FMT_SRGGB8_1X8" );
	swigIntConstant( V4L2_MBUS_FMT_SBGGR10_ALAW8_1X8, "V4L2_MBUS_FMT_SBGGR10_ALAW8_1X8" );
	swigIntConstant( V4L2_MBUS_FMT_SGBRG10_ALAW8_1X8, "V4L2_MBUS_FMT_SGBRG10_ALAW8_1X8" );
	swigIntConstant( V4L2_MBUS_FMT_SGRBG10_ALAW8_1X8, "V4L2_MBUS_FMT_SGRBG10_ALAW8_1X8" );
	swigIntConstant( V4L2_MBUS_FMT_SRGGB10_ALAW8_1X8, "V4L2_MBUS_FMT_SRGGB10_ALAW8_1X8" );
	swigIntConstant( V4L2_MBUS_FMT_SBGGR10_DPCM8_1X8, "V4L2_MBUS_FMT_SBGGR10_DPCM8_1X8" );
	swigIntConstant( V4L2_MBUS_FMT_SGBRG10_DPCM8_1X8, "V4L2_MBUS_FMT_SGBRG10_DPCM8_1X8" );
	swigIntConstant( V4L2_MBUS_FMT_SGRBG10_DPCM8_1X8, "V4L2_MBUS_FMT_SGRBG10_DPCM8_1X8" );
	swigIntConstant( V4L2_MBUS_FMT_SRGGB10_DPCM8_1X8, "V4L2_MBUS_FMT_SRGGB10_DPCM8_1X8" );
	swigIntConstant( V4L2_MBUS_FMT_SBGGR10_2X8_PADHI_BE, "V4L2_MBUS_FMT_SBGGR10_2X8_PADHI_BE" );
	swigIntConstant( V4L2_MBUS_FMT_SBGGR10_2X8_PADHI_LE, "V4L2_MBUS_FMT_SBGGR10_2X8_PADHI_LE" );
	swigIntConstant( V4L2_MBUS_FMT_SBGGR10_2X8_PADLO_BE, "V4L2_MBUS_FMT_SBGGR10_2X8_PADLO_BE" );
	swigIntConstant( V4L2_MBUS_FMT_SBGGR10_2X8_PADLO_LE, "V4L2_MBUS_FMT_SBGGR10_2X8_PADLO_LE" );
	swigIntConstant( V4L2_MBUS_FMT_SBGGR10_1X10, "V4L2_MBUS_FMT_SBGGR10_1X10" );
	swigIntConstant( V4L2_MBUS_FMT_SGBRG10_1X10, "V4L2_MBUS_FMT_SGBRG10_1X10" );
	swigIntConstant( V4L2_MBUS_FMT_SGRBG10_1X10, "V4L2_MBUS_FMT_SGRBG10_1X10" );
	swigIntConstant( V4L2_MBUS_FMT_SRGGB10_1X10, "V4L2_MBUS_FMT_SRGGB10_1X10" );
	swigIntConstant( V4L2_MBUS_FMT_SBGGR12_1X12, "V4L2_MBUS_FMT_SBGGR12_1X12" );
	swigIntConstant( V4L2_MBUS_FMT_SGBRG12_1X12, "V4L2_MBUS_FMT_SGBRG12_1X12" );
	swigIntConstant( V4L2_MBUS_FMT_SGRBG12_1X12, "V4L2_MBUS_FMT_SGRBG12_1X12" );
	swigIntConstant( V4L2_MBUS_FMT_SRGGB12_1X12, "V4L2_MBUS_FMT_SRGGB12_1X12" );
	swigIntConstant( V4L2_MBUS_FMT_JPEG_1X8, "V4L2_MBUS_FMT_JPEG_1X8" );
	swigIntConstant( V4L2_MBUS_FMT_S5C_UYVY_JPEG_1X8, "V4L2_MBUS_FMT_S5C_UYVY_JPEG_1X8" );
	swigIntConstant( V4L2_MBUS_FMT_AHSV8888_1X32, "V4L2_MBUS_FMT_AHSV8888_1X32" );
	swigIntConstant( V4L2_SUBDEV_FORMAT_TRY, "V4L2_SUBDEV_FORMAT_TRY" );
	swigIntConstant( V4L2_SUBDEV_FORMAT_ACTIVE, "V4L2_SUBDEV_FORMAT_ACTIVE" );

	swigNewline();

	swigComment("-------===< structs >===--------\n");

	swigComment("struct v4l2_rect\n");
	printf( "begin-structure v4l2_rect\n" );
	swigStructField( "v4l2_rect-left", offsetof( struct v4l2_rect, left ), sizeof( __s32 ) );
	swigStructField( "v4l2_rect-top", offsetof( struct v4l2_rect, top ), sizeof( __s32 ) );
	swigStructField( "v4l2_rect-height", offsetof( struct v4l2_rect, height ), sizeof( __u32 ) );
	swigStructField( "v4l2_rect-width", offsetof( struct v4l2_rect, width ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_rect ) );

	swigComment("struct v4l2_fract\n");
	printf( "begin-structure v4l2_fract\n" );
	swigStructField( "v4l2_fract-denominator", offsetof( struct v4l2_fract, denominator ), sizeof( __u32 ) );
	swigStructField( "v4l2_fract-numerator", offsetof( struct v4l2_fract, numerator ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_fract ) );

	swigComment("struct v4l2_area\n");
	printf( "begin-structure v4l2_area\n" );
	swigStructField( "v4l2_area-height", offsetof( struct v4l2_area, height ), sizeof( __u32 ) );
	swigStructField( "v4l2_area-width", offsetof( struct v4l2_area, width ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_area ) );

	swigComment("struct v4l2_capability\n");
	printf( "begin-structure v4l2_capability\n" );
	swigStructField( "v4l2_capability-device_caps", offsetof( struct v4l2_capability, device_caps ), sizeof( __u32 ) );
	swigStructField( "v4l2_capability-driver", offsetof( struct v4l2_capability, driver ), sizeof( __u8 [16] ) );
	swigStructField( "v4l2_capability-capabilities", offsetof( struct v4l2_capability, capabilities ), sizeof( __u32 ) );
	swigStructField( "v4l2_capability-reserved", offsetof( struct v4l2_capability, reserved ), sizeof( __u32 [3] ) );
	swigStructField( "v4l2_capability-card", offsetof( struct v4l2_capability, card ), sizeof( __u8 [32] ) );
	swigStructField( "v4l2_capability-bus_info", offsetof( struct v4l2_capability, bus_info ), sizeof( __u8 [32] ) );
	swigStructField( "v4l2_capability-version", offsetof( struct v4l2_capability, version ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_capability ) );

	swigComment("struct v4l2_pix_format\n");
	printf( "begin-structure v4l2_pix_format\n" );
	swigStructField( "v4l2_pix_format-field", offsetof( struct v4l2_pix_format, field ), sizeof( __u32 ) );
	swigStructField( "v4l2_pix_format-sizeimage", offsetof( struct v4l2_pix_format, sizeimage ), sizeof( __u32 ) );
	swigStructField( "v4l2_pix_format-bytesperline", offsetof( struct v4l2_pix_format, bytesperline ), sizeof( __u32 ) );
	swigStructField( "v4l2_pix_format-priv", offsetof( struct v4l2_pix_format, priv ), sizeof( __u32 ) );
	swigStructField( "v4l2_pix_format-hsv_enc", offsetof( struct v4l2_pix_format, hsv_enc ), sizeof( __u32 ) );
	swigStructField( "v4l2_pix_format-xfer_func", offsetof( struct v4l2_pix_format, xfer_func ), sizeof( __u32 ) );
	swigStructField( "v4l2_pix_format-height", offsetof( struct v4l2_pix_format, height ), sizeof( __u32 ) );
	swigStructField( "v4l2_pix_format-colorspace", offsetof( struct v4l2_pix_format, colorspace ), sizeof( __u32 ) );
	swigStructField( "v4l2_pix_format-ycbcr_enc", offsetof( struct v4l2_pix_format, ycbcr_enc ), sizeof( __u32 ) );
	swigStructField( "v4l2_pix_format-quantization", offsetof( struct v4l2_pix_format, quantization ), sizeof( __u32 ) );
	swigStructField( "v4l2_pix_format-width", offsetof( struct v4l2_pix_format, width ), sizeof( __u32 ) );
	swigStructField( "v4l2_pix_format-pixelformat", offsetof( struct v4l2_pix_format, pixelformat ), sizeof( __u32 ) );
	swigStructField( "v4l2_pix_format-flags", offsetof( struct v4l2_pix_format, flags ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_pix_format ) );

	swigComment("struct v4l2_fmtdesc\n");
	printf( "begin-structure v4l2_fmtdesc\n" );
	swigStructField( "v4l2_fmtdesc-index", offsetof( struct v4l2_fmtdesc, index ), sizeof( __u32 ) );
	swigStructField( "v4l2_fmtdesc-mbus_code", offsetof( struct v4l2_fmtdesc, mbus_code ), sizeof( __u32 ) );
	swigStructField( "v4l2_fmtdesc-reserved", offsetof( struct v4l2_fmtdesc, reserved ), sizeof( __u32 [3] ) );
	swigStructField( "v4l2_fmtdesc-description", offsetof( struct v4l2_fmtdesc, description ), sizeof( __u8 [32] ) );
	swigStructField( "v4l2_fmtdesc-type", offsetof( struct v4l2_fmtdesc, type ), sizeof( __u32 ) );
	swigStructField( "v4l2_fmtdesc-flags", offsetof( struct v4l2_fmtdesc, flags ), sizeof( __u32 ) );
	swigStructField( "v4l2_fmtdesc-pixelformat", offsetof( struct v4l2_fmtdesc, pixelformat ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_fmtdesc ) );

	swigComment("struct v4l2_frmsize_discrete\n");
	printf( "begin-structure v4l2_frmsize_discrete\n" );
	swigStructField( "v4l2_frmsize_discrete-height", offsetof( struct v4l2_frmsize_discrete, height ), sizeof( __u32 ) );
	swigStructField( "v4l2_frmsize_discrete-width", offsetof( struct v4l2_frmsize_discrete, width ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_frmsize_discrete ) );

	swigComment("struct v4l2_frmsize_stepwise\n");
	printf( "begin-structure v4l2_frmsize_stepwise\n" );
	swigStructField( "v4l2_frmsize_stepwise-min_height", offsetof( struct v4l2_frmsize_stepwise, min_height ), sizeof( __u32 ) );
	swigStructField( "v4l2_frmsize_stepwise-max_height", offsetof( struct v4l2_frmsize_stepwise, max_height ), sizeof( __u32 ) );
	swigStructField( "v4l2_frmsize_stepwise-step_height", offsetof( struct v4l2_frmsize_stepwise, step_height ), sizeof( __u32 ) );
	swigStructField( "v4l2_frmsize_stepwise-min_width", offsetof( struct v4l2_frmsize_stepwise, min_width ), sizeof( __u32 ) );
	swigStructField( "v4l2_frmsize_stepwise-max_width", offsetof( struct v4l2_frmsize_stepwise, max_width ), sizeof( __u32 ) );
	swigStructField( "v4l2_frmsize_stepwise-step_width", offsetof( struct v4l2_frmsize_stepwise, step_width ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_frmsize_stepwise ) );

	swigComment("struct v4l2_frmsizeenum\n");
	printf( "begin-structure v4l2_frmsizeenum\n" );
	swigStructField( "v4l2_frmsizeenum-index", offsetof( struct v4l2_frmsizeenum, index ), sizeof( __u32 ) );
	swigStructField( "v4l2_frmsizeenum-reserved", offsetof( struct v4l2_frmsizeenum, reserved ), sizeof( __u32 [2] ) );
	swigStructField( "v4l2_frmsizeenum-pixel_format", offsetof( struct v4l2_frmsizeenum, pixel_format ), sizeof( __u32 ) );
	swigStructField( "v4l2_frmsizeenum-type", offsetof( struct v4l2_frmsizeenum, type ), sizeof( __u32 ) );
	swigStructField( "v4l2_frmsizeenum-stepwise", offsetof( struct v4l2_frmsizeenum, stepwise ), sizeof( struct v4l2_frmsize_stepwise ) );
	swigStructField( "v4l2_frmsizeenum-discrete", offsetof( struct v4l2_frmsizeenum, discrete ), sizeof( struct v4l2_frmsize_discrete ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_frmsizeenum ) );

	swigComment("struct v4l2_frmival_stepwise\n");
	printf( "begin-structure v4l2_frmival_stepwise\n" );
	swigStructField( "v4l2_frmival_stepwise-step", offsetof( struct v4l2_frmival_stepwise, step ), sizeof( struct v4l2_fract ) );
	swigStructField( "v4l2_frmival_stepwise-max", offsetof( struct v4l2_frmival_stepwise, max ), sizeof( struct v4l2_fract ) );
	swigStructField( "v4l2_frmival_stepwise-min", offsetof( struct v4l2_frmival_stepwise, min ), sizeof( struct v4l2_fract ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_frmival_stepwise ) );

	swigComment("struct v4l2_frmivalenum\n");
	printf( "begin-structure v4l2_frmivalenum\n" );
	swigStructField( "v4l2_frmivalenum-index", offsetof( struct v4l2_frmivalenum, index ), sizeof( __u32 ) );
	swigStructField( "v4l2_frmivalenum-reserved", offsetof( struct v4l2_frmivalenum, reserved ), sizeof( __u32 [2] ) );
	swigStructField( "v4l2_frmivalenum-pixel_format", offsetof( struct v4l2_frmivalenum, pixel_format ), sizeof( __u32 ) );
	swigStructField( "v4l2_frmivalenum-height", offsetof( struct v4l2_frmivalenum, height ), sizeof( __u32 ) );
	swigStructField( "v4l2_frmivalenum-type", offsetof( struct v4l2_frmivalenum, type ), sizeof( __u32 ) );
	swigStructField( "v4l2_frmivalenum-width", offsetof( struct v4l2_frmivalenum, width ), sizeof( __u32 ) );
	swigStructField( "v4l2_frmivalenum-stepwise", offsetof( struct v4l2_frmivalenum, stepwise ), sizeof( struct v4l2_frmival_stepwise ) );
	swigStructField( "v4l2_frmivalenum-discrete", offsetof( struct v4l2_frmivalenum, discrete ), sizeof( struct v4l2_fract ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_frmivalenum ) );

	swigComment("struct v4l2_timecode\n");
	printf( "begin-structure v4l2_timecode\n" );
	swigStructField( "v4l2_timecode-frames", offsetof( struct v4l2_timecode, frames ), sizeof( __u8 ) );
	swigStructField( "v4l2_timecode-hours", offsetof( struct v4l2_timecode, hours ), sizeof( __u8 ) );
	swigStructField( "v4l2_timecode-userbits", offsetof( struct v4l2_timecode, userbits ), sizeof( __u8 [4] ) );
	swigStructField( "v4l2_timecode-minutes", offsetof( struct v4l2_timecode, minutes ), sizeof( __u8 ) );
	swigStructField( "v4l2_timecode-type", offsetof( struct v4l2_timecode, type ), sizeof( __u32 ) );
	swigStructField( "v4l2_timecode-flags", offsetof( struct v4l2_timecode, flags ), sizeof( __u32 ) );
	swigStructField( "v4l2_timecode-seconds", offsetof( struct v4l2_timecode, seconds ), sizeof( __u8 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_timecode ) );

	swigComment("struct v4l2_jpegcompression\n");
	printf( "begin-structure v4l2_jpegcompression\n" );
	swigStructField( "v4l2_jpegcompression-APP_data", offsetof( struct v4l2_jpegcompression, APP_data ), sizeof( char [60] ) );
	swigStructField( "v4l2_jpegcompression-jpeg_markers", offsetof( struct v4l2_jpegcompression, jpeg_markers ), sizeof( __u32 ) );
	swigStructField( "v4l2_jpegcompression-APP_len", offsetof( struct v4l2_jpegcompression, APP_len ), sizeof( int ) );
	swigStructField( "v4l2_jpegcompression-COM_len", offsetof( struct v4l2_jpegcompression, COM_len ), sizeof( int ) );
	swigStructField( "v4l2_jpegcompression-COM_data", offsetof( struct v4l2_jpegcompression, COM_data ), sizeof( char [60] ) );
	swigStructField( "v4l2_jpegcompression-quality", offsetof( struct v4l2_jpegcompression, quality ), sizeof( int ) );
	swigStructField( "v4l2_jpegcompression-APPn", offsetof( struct v4l2_jpegcompression, APPn ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_jpegcompression ) );

	swigComment("struct v4l2_requestbuffers\n");
	printf( "begin-structure v4l2_requestbuffers\n" );
	swigStructField( "v4l2_requestbuffers-capabilities", offsetof( struct v4l2_requestbuffers, capabilities ), sizeof( __u32 ) );
	swigStructField( "v4l2_requestbuffers-reserved", offsetof( struct v4l2_requestbuffers, reserved ), sizeof( __u8 [3] ) );
	swigStructField( "v4l2_requestbuffers-count", offsetof( struct v4l2_requestbuffers, count ), sizeof( __u32 ) );
	swigStructField( "v4l2_requestbuffers-memory", offsetof( struct v4l2_requestbuffers, memory ), sizeof( __u32 ) );
	swigStructField( "v4l2_requestbuffers-type", offsetof( struct v4l2_requestbuffers, type ), sizeof( __u32 ) );
	swigStructField( "v4l2_requestbuffers-flags", offsetof( struct v4l2_requestbuffers, flags ), sizeof( __u8 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_requestbuffers ) );

	swigComment("struct v4l2_plane\n");
	printf( "begin-structure v4l2_plane\n" );
	swigStructField( "v4l2_plane-reserved", offsetof( struct v4l2_plane, reserved ), sizeof( __u32 [11] ) );
	swigStructField( "v4l2_plane-data_offset", offsetof( struct v4l2_plane, data_offset ), sizeof( __u32 ) );
	swigStructField( "v4l2_plane-length", offsetof( struct v4l2_plane, length ), sizeof( __u32 ) );
	swigStructField( "v4l2_plane-m", offsetof( struct v4l2_plane, m ), sizeof( v4l2_plane_m ) );
	swigStructField( "v4l2_plane-bytesused", offsetof( struct v4l2_plane, bytesused ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_plane ) );

	swigComment("v4l2_plane_m\n");
	printf( "begin-structure v4l2_plane_m\n" );
	swigStructField( "v4l2_plane_m-userptr", offsetof( v4l2_plane_m, userptr ), sizeof( unsigned long ) );
	swigStructField( "v4l2_plane_m-mem_offset", offsetof( v4l2_plane_m, mem_offset ), sizeof( __u32 ) );
	swigStructField( "v4l2_plane_m-fd", offsetof( v4l2_plane_m, fd ), sizeof( __s32 ) );
	printf( "drop %zu end-structure\n", sizeof( v4l2_plane_m ) );

	swigComment("struct v4l2_buffer\n");
	printf( "begin-structure v4l2_buffer\n" );
	swigStructField( "v4l2_buffer-length", offsetof( struct v4l2_buffer, length ), sizeof( __u32 ) );
	swigStructField( "v4l2_buffer-timecode", offsetof( struct v4l2_buffer, timecode ), sizeof( struct v4l2_timecode ) );
	swigStructField( "v4l2_buffer-reserved2", offsetof( struct v4l2_buffer, reserved2 ), sizeof( __u32 ) );
	swigStructField( "v4l2_buffer-m", offsetof( struct v4l2_buffer, m ), sizeof( v4l2_buffer_m ) );
	swigStructField( "v4l2_buffer-reserved", offsetof( struct v4l2_buffer, reserved ), sizeof( __u32 ) );
	swigStructField( "v4l2_buffer-request_fd", offsetof( struct v4l2_buffer, request_fd ), sizeof( __s32 ) );
	swigStructField( "v4l2_buffer-field", offsetof( struct v4l2_buffer, field ), sizeof( __u32 ) );
	swigStructField( "v4l2_buffer-bytesused", offsetof( struct v4l2_buffer, bytesused ), sizeof( __u32 ) );
	swigStructField( "v4l2_buffer-flags", offsetof( struct v4l2_buffer, flags ), sizeof( __u32 ) );
	swigStructField( "v4l2_buffer-type", offsetof( struct v4l2_buffer, type ), sizeof( __u32 ) );
	swigStructField( "v4l2_buffer-sequence", offsetof( struct v4l2_buffer, sequence ), sizeof( __u32 ) );
	swigStructField( "v4l2_buffer-index", offsetof( struct v4l2_buffer, index ), sizeof( __u32 ) );
	swigStructField( "v4l2_buffer-timestamp", offsetof( struct v4l2_buffer, timestamp ), sizeof( struct timeval ) );
	swigStructField( "v4l2_buffer-memory", offsetof( struct v4l2_buffer, memory ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_buffer ) );

	swigComment("v4l2_buffer_m\n");
	printf( "begin-structure v4l2_buffer_m\n" );
	swigStructField( "v4l2_buffer_m-userptr", offsetof( v4l2_buffer_m, userptr ), sizeof( unsigned long ) );
	swigStructField( "v4l2_buffer_m-offset", offsetof( v4l2_buffer_m, offset ), sizeof( __u32 ) );
	swigStructField( "v4l2_buffer_m-fd", offsetof( v4l2_buffer_m, fd ), sizeof( __s32 ) );
	swigStructField( "v4l2_buffer_m-planes", offsetof( v4l2_buffer_m, planes ), sizeof( struct v4l2_plane * ) );
	printf( "drop %zu end-structure\n", sizeof( v4l2_buffer_m ) );

	swigComment("struct v4l2_exportbuffer\n");
	printf( "begin-structure v4l2_exportbuffer\n" );
	swigStructField( "v4l2_exportbuffer-index", offsetof( struct v4l2_exportbuffer, index ), sizeof( __u32 ) );
	swigStructField( "v4l2_exportbuffer-reserved", offsetof( struct v4l2_exportbuffer, reserved ), sizeof( __u32 [11] ) );
	swigStructField( "v4l2_exportbuffer-plane", offsetof( struct v4l2_exportbuffer, plane ), sizeof( __u32 ) );
	swigStructField( "v4l2_exportbuffer-type", offsetof( struct v4l2_exportbuffer, type ), sizeof( __u32 ) );
	swigStructField( "v4l2_exportbuffer-fd", offsetof( struct v4l2_exportbuffer, fd ), sizeof( __s32 ) );
	swigStructField( "v4l2_exportbuffer-flags", offsetof( struct v4l2_exportbuffer, flags ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_exportbuffer ) );

	swigComment("struct v4l2_framebuffer\n");
	printf( "begin-structure v4l2_framebuffer\n" );
	swigStructField( "v4l2_framebuffer-fmt", offsetof( struct v4l2_framebuffer, fmt ), sizeof( v4l2_framebuffer_fmt ) );
	swigStructField( "v4l2_framebuffer-capability", offsetof( struct v4l2_framebuffer, capability ), sizeof( __u32 ) );
	swigStructField( "v4l2_framebuffer-flags", offsetof( struct v4l2_framebuffer, flags ), sizeof( __u32 ) );
	swigStructField( "v4l2_framebuffer-base", offsetof( struct v4l2_framebuffer, base ), sizeof( void * ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_framebuffer ) );

	swigComment("v4l2_framebuffer_fmt\n");
	printf( "begin-structure v4l2_framebuffer_fmt\n" );
	swigStructField( "v4l2_framebuffer_fmt-field", offsetof( v4l2_framebuffer_fmt, field ), sizeof( __u32 ) );
	swigStructField( "v4l2_framebuffer_fmt-sizeimage", offsetof( v4l2_framebuffer_fmt, sizeimage ), sizeof( __u32 ) );
	swigStructField( "v4l2_framebuffer_fmt-bytesperline", offsetof( v4l2_framebuffer_fmt, bytesperline ), sizeof( __u32 ) );
	swigStructField( "v4l2_framebuffer_fmt-priv", offsetof( v4l2_framebuffer_fmt, priv ), sizeof( __u32 ) );
	swigStructField( "v4l2_framebuffer_fmt-height", offsetof( v4l2_framebuffer_fmt, height ), sizeof( __u32 ) );
	swigStructField( "v4l2_framebuffer_fmt-colorspace", offsetof( v4l2_framebuffer_fmt, colorspace ), sizeof( __u32 ) );
	swigStructField( "v4l2_framebuffer_fmt-width", offsetof( v4l2_framebuffer_fmt, width ), sizeof( __u32 ) );
	swigStructField( "v4l2_framebuffer_fmt-pixelformat", offsetof( v4l2_framebuffer_fmt, pixelformat ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( v4l2_framebuffer_fmt ) );

	swigComment("struct v4l2_clip\n");
	printf( "begin-structure v4l2_clip\n" );
	swigStructField( "v4l2_clip-c", offsetof( struct v4l2_clip, c ), sizeof( struct v4l2_rect ) );
	swigStructField( "v4l2_clip-next", offsetof( struct v4l2_clip, next ), sizeof( struct v4l2_clip * ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_clip ) );

	swigComment("struct v4l2_window\n");
	printf( "begin-structure v4l2_window\n" );
	swigStructField( "v4l2_window-w", offsetof( struct v4l2_window, w ), sizeof( struct v4l2_rect ) );
	swigStructField( "v4l2_window-global_alpha", offsetof( struct v4l2_window, global_alpha ), sizeof( __u8 ) );
	swigStructField( "v4l2_window-field", offsetof( struct v4l2_window, field ), sizeof( __u32 ) );
	swigStructField( "v4l2_window-chromakey", offsetof( struct v4l2_window, chromakey ), sizeof( __u32 ) );
	swigStructField( "v4l2_window-clips", offsetof( struct v4l2_window, clips ), sizeof( struct v4l2_clip * ) );
	swigStructField( "v4l2_window-clipcount", offsetof( struct v4l2_window, clipcount ), sizeof( __u32 ) );
	swigStructField( "v4l2_window-bitmap", offsetof( struct v4l2_window, bitmap ), sizeof( void * ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_window ) );

	swigComment("struct v4l2_captureparm\n");
	printf( "begin-structure v4l2_captureparm\n" );
	swigStructField( "v4l2_captureparm-timeperframe", offsetof( struct v4l2_captureparm, timeperframe ), sizeof( struct v4l2_fract ) );
	swigStructField( "v4l2_captureparm-reserved", offsetof( struct v4l2_captureparm, reserved ), sizeof( __u32 [4] ) );
	swigStructField( "v4l2_captureparm-readbuffers", offsetof( struct v4l2_captureparm, readbuffers ), sizeof( __u32 ) );
	swigStructField( "v4l2_captureparm-capability", offsetof( struct v4l2_captureparm, capability ), sizeof( __u32 ) );
	swigStructField( "v4l2_captureparm-extendedmode", offsetof( struct v4l2_captureparm, extendedmode ), sizeof( __u32 ) );
	swigStructField( "v4l2_captureparm-capturemode", offsetof( struct v4l2_captureparm, capturemode ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_captureparm ) );

	swigComment("struct v4l2_outputparm\n");
	printf( "begin-structure v4l2_outputparm\n" );
	swigStructField( "v4l2_outputparm-timeperframe", offsetof( struct v4l2_outputparm, timeperframe ), sizeof( struct v4l2_fract ) );
	swigStructField( "v4l2_outputparm-reserved", offsetof( struct v4l2_outputparm, reserved ), sizeof( __u32 [4] ) );
	swigStructField( "v4l2_outputparm-outputmode", offsetof( struct v4l2_outputparm, outputmode ), sizeof( __u32 ) );
	swigStructField( "v4l2_outputparm-writebuffers", offsetof( struct v4l2_outputparm, writebuffers ), sizeof( __u32 ) );
	swigStructField( "v4l2_outputparm-capability", offsetof( struct v4l2_outputparm, capability ), sizeof( __u32 ) );
	swigStructField( "v4l2_outputparm-extendedmode", offsetof( struct v4l2_outputparm, extendedmode ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_outputparm ) );

	swigComment("struct v4l2_cropcap\n");
	printf( "begin-structure v4l2_cropcap\n" );
	swigStructField( "v4l2_cropcap-defrect", offsetof( struct v4l2_cropcap, defrect ), sizeof( struct v4l2_rect ) );
	swigStructField( "v4l2_cropcap-pixelaspect", offsetof( struct v4l2_cropcap, pixelaspect ), sizeof( struct v4l2_fract ) );
	swigStructField( "v4l2_cropcap-type", offsetof( struct v4l2_cropcap, type ), sizeof( __u32 ) );
	swigStructField( "v4l2_cropcap-bounds", offsetof( struct v4l2_cropcap, bounds ), sizeof( struct v4l2_rect ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_cropcap ) );

	swigComment("struct v4l2_crop\n");
	printf( "begin-structure v4l2_crop\n" );
	swigStructField( "v4l2_crop-c", offsetof( struct v4l2_crop, c ), sizeof( struct v4l2_rect ) );
	swigStructField( "v4l2_crop-type", offsetof( struct v4l2_crop, type ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_crop ) );

	swigComment("struct v4l2_selection\n");
	printf( "begin-structure v4l2_selection\n" );
	swigStructField( "v4l2_selection-reserved", offsetof( struct v4l2_selection, reserved ), sizeof( __u32 [9] ) );
	swigStructField( "v4l2_selection-target", offsetof( struct v4l2_selection, target ), sizeof( __u32 ) );
	swigStructField( "v4l2_selection-r", offsetof( struct v4l2_selection, r ), sizeof( struct v4l2_rect ) );
	swigStructField( "v4l2_selection-type", offsetof( struct v4l2_selection, type ), sizeof( __u32 ) );
	swigStructField( "v4l2_selection-flags", offsetof( struct v4l2_selection, flags ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_selection ) );

	swigComment("struct v4l2_standard\n");
	printf( "begin-structure v4l2_standard\n" );
	swigStructField( "v4l2_standard-index", offsetof( struct v4l2_standard, index ), sizeof( __u32 ) );
	swigStructField( "v4l2_standard-name", offsetof( struct v4l2_standard, name ), sizeof( __u8 [24] ) );
	swigStructField( "v4l2_standard-reserved", offsetof( struct v4l2_standard, reserved ), sizeof( __u32 [4] ) );
	swigStructField( "v4l2_standard-id", offsetof( struct v4l2_standard, id ), sizeof( v4l2_std_id ) );
	swigStructField( "v4l2_standard-frameperiod", offsetof( struct v4l2_standard, frameperiod ), sizeof( struct v4l2_fract ) );
	swigStructField( "v4l2_standard-framelines", offsetof( struct v4l2_standard, framelines ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_standard ) );

	swigComment("struct v4l2_bt_timings\n");
	printf( "begin-structure v4l2_bt_timings\n" );
	swigStructField( "v4l2_bt_timings-cea861_vic", offsetof( struct v4l2_bt_timings, cea861_vic ), sizeof( __u8 ) );
	swigStructField( "v4l2_bt_timings-hsync", offsetof( struct v4l2_bt_timings, hsync ), sizeof( __u32 ) );
	swigStructField( "v4l2_bt_timings-height", offsetof( struct v4l2_bt_timings, height ), sizeof( __u32 ) );
	swigStructField( "v4l2_bt_timings-vsync", offsetof( struct v4l2_bt_timings, vsync ), sizeof( __u32 ) );
	swigStructField( "v4l2_bt_timings-interlaced", offsetof( struct v4l2_bt_timings, interlaced ), sizeof( __u32 ) );
	swigStructField( "v4l2_bt_timings-reserved", offsetof( struct v4l2_bt_timings, reserved ), sizeof( __u8 [46] ) );
	swigStructField( "v4l2_bt_timings-pixelclock", offsetof( struct v4l2_bt_timings, pixelclock ), sizeof( __u64 ) );
	swigStructField( "v4l2_bt_timings-il_vfrontporch", offsetof( struct v4l2_bt_timings, il_vfrontporch ), sizeof( __u32 ) );
	swigStructField( "v4l2_bt_timings-vfrontporch", offsetof( struct v4l2_bt_timings, vfrontporch ), sizeof( __u32 ) );
	swigStructField( "v4l2_bt_timings-hfrontporch", offsetof( struct v4l2_bt_timings, hfrontporch ), sizeof( __u32 ) );
	swigStructField( "v4l2_bt_timings-width", offsetof( struct v4l2_bt_timings, width ), sizeof( __u32 ) );
	swigStructField( "v4l2_bt_timings-picture_aspect", offsetof( struct v4l2_bt_timings, picture_aspect ), sizeof( struct v4l2_fract ) );
	swigStructField( "v4l2_bt_timings-flags", offsetof( struct v4l2_bt_timings, flags ), sizeof( __u32 ) );
	swigStructField( "v4l2_bt_timings-hdmi_vic", offsetof( struct v4l2_bt_timings, hdmi_vic ), sizeof( __u8 ) );
	swigStructField( "v4l2_bt_timings-il_vbackporch", offsetof( struct v4l2_bt_timings, il_vbackporch ), sizeof( __u32 ) );
	swigStructField( "v4l2_bt_timings-vbackporch", offsetof( struct v4l2_bt_timings, vbackporch ), sizeof( __u32 ) );
	swigStructField( "v4l2_bt_timings-hbackporch", offsetof( struct v4l2_bt_timings, hbackporch ), sizeof( __u32 ) );
	swigStructField( "v4l2_bt_timings-polarities", offsetof( struct v4l2_bt_timings, polarities ), sizeof( __u32 ) );
	swigStructField( "v4l2_bt_timings-il_vsync", offsetof( struct v4l2_bt_timings, il_vsync ), sizeof( __u32 ) );
	swigStructField( "v4l2_bt_timings-standards", offsetof( struct v4l2_bt_timings, standards ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_bt_timings ) );

	swigComment("struct v4l2_dv_timings\n");
	printf( "begin-structure v4l2_dv_timings\n" );
	swigStructField( "v4l2_dv_timings-reserved", offsetof( struct v4l2_dv_timings, reserved ), sizeof( __u32 [32] ) );
	swigStructField( "v4l2_dv_timings-type", offsetof( struct v4l2_dv_timings, type ), sizeof( __u32 ) );
	swigStructField( "v4l2_dv_timings-bt", offsetof( struct v4l2_dv_timings, bt ), sizeof( struct v4l2_bt_timings ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_dv_timings ) );

	swigComment("struct v4l2_enum_dv_timings\n");
	printf( "begin-structure v4l2_enum_dv_timings\n" );
	swigStructField( "v4l2_enum_dv_timings-index", offsetof( struct v4l2_enum_dv_timings, index ), sizeof( __u32 ) );
	swigStructField( "v4l2_enum_dv_timings-reserved", offsetof( struct v4l2_enum_dv_timings, reserved ), sizeof( __u32 [2] ) );
	swigStructField( "v4l2_enum_dv_timings-pad", offsetof( struct v4l2_enum_dv_timings, pad ), sizeof( __u32 ) );
	swigStructField( "v4l2_enum_dv_timings-timings", offsetof( struct v4l2_enum_dv_timings, timings ), sizeof( struct v4l2_dv_timings ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_enum_dv_timings ) );

	swigComment("struct v4l2_bt_timings_cap\n");
	printf( "begin-structure v4l2_bt_timings_cap\n" );
	swigStructField( "v4l2_bt_timings_cap-min_pixelclock", offsetof( struct v4l2_bt_timings_cap, min_pixelclock ), sizeof( __u64 ) );
	swigStructField( "v4l2_bt_timings_cap-max_pixelclock", offsetof( struct v4l2_bt_timings_cap, max_pixelclock ), sizeof( __u64 ) );
	swigStructField( "v4l2_bt_timings_cap-standards", offsetof( struct v4l2_bt_timings_cap, standards ), sizeof( __u32 ) );
	swigStructField( "v4l2_bt_timings_cap-capabilities", offsetof( struct v4l2_bt_timings_cap, capabilities ), sizeof( __u32 ) );
	swigStructField( "v4l2_bt_timings_cap-reserved", offsetof( struct v4l2_bt_timings_cap, reserved ), sizeof( __u32 [16] ) );
	swigStructField( "v4l2_bt_timings_cap-min_height", offsetof( struct v4l2_bt_timings_cap, min_height ), sizeof( __u32 ) );
	swigStructField( "v4l2_bt_timings_cap-max_height", offsetof( struct v4l2_bt_timings_cap, max_height ), sizeof( __u32 ) );
	swigStructField( "v4l2_bt_timings_cap-min_width", offsetof( struct v4l2_bt_timings_cap, min_width ), sizeof( __u32 ) );
	swigStructField( "v4l2_bt_timings_cap-max_width", offsetof( struct v4l2_bt_timings_cap, max_width ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_bt_timings_cap ) );

	swigComment("struct v4l2_dv_timings_cap\n");
	printf( "begin-structure v4l2_dv_timings_cap\n" );
	swigStructField( "v4l2_dv_timings_cap-raw_data", offsetof( struct v4l2_dv_timings_cap, raw_data ), sizeof( __u32 [32] ) );
	swigStructField( "v4l2_dv_timings_cap-reserved", offsetof( struct v4l2_dv_timings_cap, reserved ), sizeof( __u32 [2] ) );
	swigStructField( "v4l2_dv_timings_cap-type", offsetof( struct v4l2_dv_timings_cap, type ), sizeof( __u32 ) );
	swigStructField( "v4l2_dv_timings_cap-bt", offsetof( struct v4l2_dv_timings_cap, bt ), sizeof( struct v4l2_bt_timings_cap ) );
	swigStructField( "v4l2_dv_timings_cap-pad", offsetof( struct v4l2_dv_timings_cap, pad ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_dv_timings_cap ) );

	swigComment("struct v4l2_input\n");
	printf( "begin-structure v4l2_input\n" );
	swigStructField( "v4l2_input-index", offsetof( struct v4l2_input, index ), sizeof( __u32 ) );
	swigStructField( "v4l2_input-name", offsetof( struct v4l2_input, name ), sizeof( __u8 [32] ) );
	swigStructField( "v4l2_input-audioset", offsetof( struct v4l2_input, audioset ), sizeof( __u32 ) );
	swigStructField( "v4l2_input-status", offsetof( struct v4l2_input, status ), sizeof( __u32 ) );
	swigStructField( "v4l2_input-capabilities", offsetof( struct v4l2_input, capabilities ), sizeof( __u32 ) );
	swigStructField( "v4l2_input-reserved", offsetof( struct v4l2_input, reserved ), sizeof( __u32 [3] ) );
	swigStructField( "v4l2_input-tuner", offsetof( struct v4l2_input, tuner ), sizeof( __u32 ) );
	swigStructField( "v4l2_input-std", offsetof( struct v4l2_input, std ), sizeof( v4l2_std_id ) );
	swigStructField( "v4l2_input-type", offsetof( struct v4l2_input, type ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_input ) );

	swigComment("struct v4l2_output\n");
	printf( "begin-structure v4l2_output\n" );
	swigStructField( "v4l2_output-index", offsetof( struct v4l2_output, index ), sizeof( __u32 ) );
	swigStructField( "v4l2_output-name", offsetof( struct v4l2_output, name ), sizeof( __u8 [32] ) );
	swigStructField( "v4l2_output-audioset", offsetof( struct v4l2_output, audioset ), sizeof( __u32 ) );
	swigStructField( "v4l2_output-capabilities", offsetof( struct v4l2_output, capabilities ), sizeof( __u32 ) );
	swigStructField( "v4l2_output-reserved", offsetof( struct v4l2_output, reserved ), sizeof( __u32 [3] ) );
	swigStructField( "v4l2_output-std", offsetof( struct v4l2_output, std ), sizeof( v4l2_std_id ) );
	swigStructField( "v4l2_output-type", offsetof( struct v4l2_output, type ), sizeof( __u32 ) );
	swigStructField( "v4l2_output-modulator", offsetof( struct v4l2_output, modulator ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_output ) );

	swigComment("struct v4l2_control\n");
	printf( "begin-structure v4l2_control\n" );
	swigStructField( "v4l2_control-id", offsetof( struct v4l2_control, id ), sizeof( __u32 ) );
	swigStructField( "v4l2_control-value", offsetof( struct v4l2_control, value ), sizeof( __s32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_control ) );

	swigComment("struct v4l2_ext_control\n");
	printf( "begin-structure v4l2_ext_control\n" );
	swigStructField( "v4l2_ext_control-value", offsetof( struct v4l2_ext_control, value ), sizeof( __s32 ) );
	swigStructField( "v4l2_ext_control-p_area", offsetof( struct v4l2_ext_control, p_area ), sizeof( struct v4l2_area * ) );
	swigStructField( "v4l2_ext_control-p_mpeg2_quantisation", offsetof( struct v4l2_ext_control, p_mpeg2_quantisation ), sizeof( struct v4l2_ctrl_mpeg2_quantisation * ) );
	swigStructField( "v4l2_ext_control-size", offsetof( struct v4l2_ext_control, size ), sizeof( __u32 ) );
	swigStructField( "v4l2_ext_control-p_u32", offsetof( struct v4l2_ext_control, p_u32 ), sizeof( __u32 * ) );
	swigStructField( "v4l2_ext_control-p_u8", offsetof( struct v4l2_ext_control, p_u8 ), sizeof( __u8 * ) );
	swigStructField( "v4l2_ext_control-p_vp9_frame", offsetof( struct v4l2_ext_control, p_vp9_frame ), sizeof( struct v4l2_ctrl_vp9_frame * ) );
	swigStructField( "v4l2_ext_control-p_h264_sps", offsetof( struct v4l2_ext_control, p_h264_sps ), sizeof( struct v4l2_ctrl_h264_sps * ) );
	swigStructField( "v4l2_ext_control-reserved2", offsetof( struct v4l2_ext_control, reserved2 ), sizeof( __u32 [1] ) );
	swigStructField( "v4l2_ext_control-p_h264_slice_params", offsetof( struct v4l2_ext_control, p_h264_slice_params ), sizeof( struct v4l2_ctrl_h264_slice_params * ) );
	swigStructField( "v4l2_ext_control-p_h264_decode_params", offsetof( struct v4l2_ext_control, p_h264_decode_params ), sizeof( struct v4l2_ctrl_h264_decode_params * ) );
	swigStructField( "v4l2_ext_control-p_fwht_params", offsetof( struct v4l2_ext_control, p_fwht_params ), sizeof( struct v4l2_ctrl_fwht_params * ) );
	swigStructField( "v4l2_ext_control-string", offsetof( struct v4l2_ext_control, string ), sizeof( char * ) );
	swigStructField( "v4l2_ext_control-ptr", offsetof( struct v4l2_ext_control, ptr ), sizeof( void * ) );
	swigStructField( "v4l2_ext_control-p_mpeg2_picture", offsetof( struct v4l2_ext_control, p_mpeg2_picture ), sizeof( struct v4l2_ctrl_mpeg2_picture * ) );
	swigStructField( "v4l2_ext_control-p_h264_pred_weights", offsetof( struct v4l2_ext_control, p_h264_pred_weights ), sizeof( struct v4l2_ctrl_h264_pred_weights * ) );
	swigStructField( "v4l2_ext_control-id", offsetof( struct v4l2_ext_control, id ), sizeof( __u32 ) );
	swigStructField( "v4l2_ext_control-p_h264_pps", offsetof( struct v4l2_ext_control, p_h264_pps ), sizeof( struct v4l2_ctrl_h264_pps * ) );
	swigStructField( "v4l2_ext_control-p_u16", offsetof( struct v4l2_ext_control, p_u16 ), sizeof( __u16 * ) );
	swigStructField( "v4l2_ext_control-p_h264_scaling_matrix", offsetof( struct v4l2_ext_control, p_h264_scaling_matrix ), sizeof( struct v4l2_ctrl_h264_scaling_matrix * ) );
	swigStructField( "v4l2_ext_control-p_mpeg2_sequence", offsetof( struct v4l2_ext_control, p_mpeg2_sequence ), sizeof( struct v4l2_ctrl_mpeg2_sequence * ) );
	swigStructField( "v4l2_ext_control-p_vp9_compressed_hdr_probs", offsetof( struct v4l2_ext_control, p_vp9_compressed_hdr_probs ), sizeof( struct v4l2_ctrl_vp9_compressed_hdr * ) );
	swigStructField( "v4l2_ext_control-value64", offsetof( struct v4l2_ext_control, value64 ), sizeof( __s64 ) );
	swigStructField( "v4l2_ext_control-p_vp8_frame", offsetof( struct v4l2_ext_control, p_vp8_frame ), sizeof( struct v4l2_ctrl_vp8_frame * ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_ext_control ) );

	swigComment("struct v4l2_ext_controls\n");
	printf( "begin-structure v4l2_ext_controls\n" );
	swigStructField( "v4l2_ext_controls-reserved", offsetof( struct v4l2_ext_controls, reserved ), sizeof( __u32 [1] ) );
	swigStructField( "v4l2_ext_controls-which", offsetof( struct v4l2_ext_controls, which ), sizeof( __u32 ) );
	swigStructField( "v4l2_ext_controls-count", offsetof( struct v4l2_ext_controls, count ), sizeof( __u32 ) );
	swigStructField( "v4l2_ext_controls-error_idx", offsetof( struct v4l2_ext_controls, error_idx ), sizeof( __u32 ) );
	swigStructField( "v4l2_ext_controls-request_fd", offsetof( struct v4l2_ext_controls, request_fd ), sizeof( __s32 ) );
	swigStructField( "v4l2_ext_controls-controls", offsetof( struct v4l2_ext_controls, controls ), sizeof( struct v4l2_ext_control * ) );
	swigStructField( "v4l2_ext_controls-ctrl_class", offsetof( struct v4l2_ext_controls, ctrl_class ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_ext_controls ) );

	swigComment("struct v4l2_queryctrl\n");
	printf( "begin-structure v4l2_queryctrl\n" );
	swigStructField( "v4l2_queryctrl-minimum", offsetof( struct v4l2_queryctrl, minimum ), sizeof( __s32 ) );
	swigStructField( "v4l2_queryctrl-name", offsetof( struct v4l2_queryctrl, name ), sizeof( __u8 [32] ) );
	swigStructField( "v4l2_queryctrl-reserved", offsetof( struct v4l2_queryctrl, reserved ), sizeof( __u32 [2] ) );
	swigStructField( "v4l2_queryctrl-id", offsetof( struct v4l2_queryctrl, id ), sizeof( __u32 ) );
	swigStructField( "v4l2_queryctrl-step", offsetof( struct v4l2_queryctrl, step ), sizeof( __s32 ) );
	swigStructField( "v4l2_queryctrl-default_value", offsetof( struct v4l2_queryctrl, default_value ), sizeof( __s32 ) );
	swigStructField( "v4l2_queryctrl-maximum", offsetof( struct v4l2_queryctrl, maximum ), sizeof( __s32 ) );
	swigStructField( "v4l2_queryctrl-type", offsetof( struct v4l2_queryctrl, type ), sizeof( __u32 ) );
	swigStructField( "v4l2_queryctrl-flags", offsetof( struct v4l2_queryctrl, flags ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_queryctrl ) );

	swigComment("struct v4l2_query_ext_ctrl\n");
	printf( "begin-structure v4l2_query_ext_ctrl\n" );
	swigStructField( "v4l2_query_ext_ctrl-minimum", offsetof( struct v4l2_query_ext_ctrl, minimum ), sizeof( __s64 ) );
	swigStructField( "v4l2_query_ext_ctrl-nr_of_dims", offsetof( struct v4l2_query_ext_ctrl, nr_of_dims ), sizeof( __u32 ) );
	swigStructField( "v4l2_query_ext_ctrl-dims", offsetof( struct v4l2_query_ext_ctrl, dims ), sizeof( __u32 [(4)] ) );
	swigStructField( "v4l2_query_ext_ctrl-name", offsetof( struct v4l2_query_ext_ctrl, name ), sizeof( char [32] ) );
	swigStructField( "v4l2_query_ext_ctrl-reserved", offsetof( struct v4l2_query_ext_ctrl, reserved ), sizeof( __u32 [32] ) );
	swigStructField( "v4l2_query_ext_ctrl-id", offsetof( struct v4l2_query_ext_ctrl, id ), sizeof( __u32 ) );
	swigStructField( "v4l2_query_ext_ctrl-step", offsetof( struct v4l2_query_ext_ctrl, step ), sizeof( __u64 ) );
	swigStructField( "v4l2_query_ext_ctrl-default_value", offsetof( struct v4l2_query_ext_ctrl, default_value ), sizeof( __s64 ) );
	swigStructField( "v4l2_query_ext_ctrl-maximum", offsetof( struct v4l2_query_ext_ctrl, maximum ), sizeof( __s64 ) );
	swigStructField( "v4l2_query_ext_ctrl-type", offsetof( struct v4l2_query_ext_ctrl, type ), sizeof( __u32 ) );
	swigStructField( "v4l2_query_ext_ctrl-elem_size", offsetof( struct v4l2_query_ext_ctrl, elem_size ), sizeof( __u32 ) );
	swigStructField( "v4l2_query_ext_ctrl-flags", offsetof( struct v4l2_query_ext_ctrl, flags ), sizeof( __u32 ) );
	swigStructField( "v4l2_query_ext_ctrl-elems", offsetof( struct v4l2_query_ext_ctrl, elems ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_query_ext_ctrl ) );

	swigComment("struct v4l2_querymenu\n");
	printf( "begin-structure v4l2_querymenu\n" );
	swigStructField( "v4l2_querymenu-index", offsetof( struct v4l2_querymenu, index ), sizeof( __u32 ) );
	swigStructField( "v4l2_querymenu-name", offsetof( struct v4l2_querymenu, name ), sizeof( __u8 [32] ) );
	swigStructField( "v4l2_querymenu-reserved", offsetof( struct v4l2_querymenu, reserved ), sizeof( __u32 ) );
	swigStructField( "v4l2_querymenu-id", offsetof( struct v4l2_querymenu, id ), sizeof( __u32 ) );
	swigStructField( "v4l2_querymenu-value", offsetof( struct v4l2_querymenu, value ), sizeof( __s64 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_querymenu ) );

	swigComment("struct v4l2_tuner\n");
	printf( "begin-structure v4l2_tuner\n" );
	swigStructField( "v4l2_tuner-rxsubchans", offsetof( struct v4l2_tuner, rxsubchans ), sizeof( __u32 ) );
	swigStructField( "v4l2_tuner-audmode", offsetof( struct v4l2_tuner, audmode ), sizeof( __u32 ) );
	swigStructField( "v4l2_tuner-index", offsetof( struct v4l2_tuner, index ), sizeof( __u32 ) );
	swigStructField( "v4l2_tuner-name", offsetof( struct v4l2_tuner, name ), sizeof( __u8 [32] ) );
	swigStructField( "v4l2_tuner-afc", offsetof( struct v4l2_tuner, afc ), sizeof( __s32 ) );
	swigStructField( "v4l2_tuner-reserved", offsetof( struct v4l2_tuner, reserved ), sizeof( __u32 [4] ) );
	swigStructField( "v4l2_tuner-rangehigh", offsetof( struct v4l2_tuner, rangehigh ), sizeof( __u32 ) );
	swigStructField( "v4l2_tuner-type", offsetof( struct v4l2_tuner, type ), sizeof( __u32 ) );
	swigStructField( "v4l2_tuner-capability", offsetof( struct v4l2_tuner, capability ), sizeof( __u32 ) );
	swigStructField( "v4l2_tuner-rangelow", offsetof( struct v4l2_tuner, rangelow ), sizeof( __u32 ) );
	swigStructField( "v4l2_tuner-signal", offsetof( struct v4l2_tuner, signal ), sizeof( __s32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_tuner ) );

	swigComment("struct v4l2_modulator\n");
	printf( "begin-structure v4l2_modulator\n" );
	swigStructField( "v4l2_modulator-txsubchans", offsetof( struct v4l2_modulator, txsubchans ), sizeof( __u32 ) );
	swigStructField( "v4l2_modulator-index", offsetof( struct v4l2_modulator, index ), sizeof( __u32 ) );
	swigStructField( "v4l2_modulator-name", offsetof( struct v4l2_modulator, name ), sizeof( __u8 [32] ) );
	swigStructField( "v4l2_modulator-reserved", offsetof( struct v4l2_modulator, reserved ), sizeof( __u32 [3] ) );
	swigStructField( "v4l2_modulator-rangehigh", offsetof( struct v4l2_modulator, rangehigh ), sizeof( __u32 ) );
	swigStructField( "v4l2_modulator-capability", offsetof( struct v4l2_modulator, capability ), sizeof( __u32 ) );
	swigStructField( "v4l2_modulator-rangelow", offsetof( struct v4l2_modulator, rangelow ), sizeof( __u32 ) );
	swigStructField( "v4l2_modulator-type", offsetof( struct v4l2_modulator, type ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_modulator ) );

	swigComment("struct v4l2_frequency\n");
	printf( "begin-structure v4l2_frequency\n" );
	swigStructField( "v4l2_frequency-reserved", offsetof( struct v4l2_frequency, reserved ), sizeof( __u32 [8] ) );
	swigStructField( "v4l2_frequency-tuner", offsetof( struct v4l2_frequency, tuner ), sizeof( __u32 ) );
	swigStructField( "v4l2_frequency-frequency", offsetof( struct v4l2_frequency, frequency ), sizeof( __u32 ) );
	swigStructField( "v4l2_frequency-type", offsetof( struct v4l2_frequency, type ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_frequency ) );

	swigComment("struct v4l2_frequency_band\n");
	printf( "begin-structure v4l2_frequency_band\n" );
	swigStructField( "v4l2_frequency_band-index", offsetof( struct v4l2_frequency_band, index ), sizeof( __u32 ) );
	swigStructField( "v4l2_frequency_band-reserved", offsetof( struct v4l2_frequency_band, reserved ), sizeof( __u32 [9] ) );
	swigStructField( "v4l2_frequency_band-tuner", offsetof( struct v4l2_frequency_band, tuner ), sizeof( __u32 ) );
	swigStructField( "v4l2_frequency_band-rangehigh", offsetof( struct v4l2_frequency_band, rangehigh ), sizeof( __u32 ) );
	swigStructField( "v4l2_frequency_band-type", offsetof( struct v4l2_frequency_band, type ), sizeof( __u32 ) );
	swigStructField( "v4l2_frequency_band-capability", offsetof( struct v4l2_frequency_band, capability ), sizeof( __u32 ) );
	swigStructField( "v4l2_frequency_band-rangelow", offsetof( struct v4l2_frequency_band, rangelow ), sizeof( __u32 ) );
	swigStructField( "v4l2_frequency_band-modulation", offsetof( struct v4l2_frequency_band, modulation ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_frequency_band ) );

	swigComment("struct v4l2_hw_freq_seek\n");
	printf( "begin-structure v4l2_hw_freq_seek\n" );
	swigStructField( "v4l2_hw_freq_seek-seek_upward", offsetof( struct v4l2_hw_freq_seek, seek_upward ), sizeof( __u32 ) );
	swigStructField( "v4l2_hw_freq_seek-reserved", offsetof( struct v4l2_hw_freq_seek, reserved ), sizeof( __u32 [5] ) );
	swigStructField( "v4l2_hw_freq_seek-tuner", offsetof( struct v4l2_hw_freq_seek, tuner ), sizeof( __u32 ) );
	swigStructField( "v4l2_hw_freq_seek-rangehigh", offsetof( struct v4l2_hw_freq_seek, rangehigh ), sizeof( __u32 ) );
	swigStructField( "v4l2_hw_freq_seek-type", offsetof( struct v4l2_hw_freq_seek, type ), sizeof( __u32 ) );
	swigStructField( "v4l2_hw_freq_seek-rangelow", offsetof( struct v4l2_hw_freq_seek, rangelow ), sizeof( __u32 ) );
	swigStructField( "v4l2_hw_freq_seek-spacing", offsetof( struct v4l2_hw_freq_seek, spacing ), sizeof( __u32 ) );
	swigStructField( "v4l2_hw_freq_seek-wrap_around", offsetof( struct v4l2_hw_freq_seek, wrap_around ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_hw_freq_seek ) );

	swigComment("struct v4l2_rds_data\n");
	printf( "begin-structure v4l2_rds_data\n" );
	swigStructField( "v4l2_rds_data-block", offsetof( struct v4l2_rds_data, block ), sizeof( __u8 ) );
	swigStructField( "v4l2_rds_data-lsb", offsetof( struct v4l2_rds_data, lsb ), sizeof( __u8 ) );
	swigStructField( "v4l2_rds_data-msb", offsetof( struct v4l2_rds_data, msb ), sizeof( __u8 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_rds_data ) );

	swigComment("struct v4l2_audio\n");
	printf( "begin-structure v4l2_audio\n" );
	swigStructField( "v4l2_audio-index", offsetof( struct v4l2_audio, index ), sizeof( __u32 ) );
	swigStructField( "v4l2_audio-name", offsetof( struct v4l2_audio, name ), sizeof( __u8 [32] ) );
	swigStructField( "v4l2_audio-reserved", offsetof( struct v4l2_audio, reserved ), sizeof( __u32 [2] ) );
	swigStructField( "v4l2_audio-capability", offsetof( struct v4l2_audio, capability ), sizeof( __u32 ) );
	swigStructField( "v4l2_audio-mode", offsetof( struct v4l2_audio, mode ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_audio ) );

	swigComment("struct v4l2_audioout\n");
	printf( "begin-structure v4l2_audioout\n" );
	swigStructField( "v4l2_audioout-index", offsetof( struct v4l2_audioout, index ), sizeof( __u32 ) );
	swigStructField( "v4l2_audioout-name", offsetof( struct v4l2_audioout, name ), sizeof( __u8 [32] ) );
	swigStructField( "v4l2_audioout-reserved", offsetof( struct v4l2_audioout, reserved ), sizeof( __u32 [2] ) );
	swigStructField( "v4l2_audioout-capability", offsetof( struct v4l2_audioout, capability ), sizeof( __u32 ) );
	swigStructField( "v4l2_audioout-mode", offsetof( struct v4l2_audioout, mode ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_audioout ) );

	swigComment("struct v4l2_enc_idx_entry\n");
	printf( "begin-structure v4l2_enc_idx_entry\n" );
	swigStructField( "v4l2_enc_idx_entry-reserved", offsetof( struct v4l2_enc_idx_entry, reserved ), sizeof( __u32 [2] ) );
	swigStructField( "v4l2_enc_idx_entry-offset", offsetof( struct v4l2_enc_idx_entry, offset ), sizeof( __u64 ) );
	swigStructField( "v4l2_enc_idx_entry-length", offsetof( struct v4l2_enc_idx_entry, length ), sizeof( __u32 ) );
	swigStructField( "v4l2_enc_idx_entry-pts", offsetof( struct v4l2_enc_idx_entry, pts ), sizeof( __u64 ) );
	swigStructField( "v4l2_enc_idx_entry-flags", offsetof( struct v4l2_enc_idx_entry, flags ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_enc_idx_entry ) );

	swigComment("struct v4l2_enc_idx\n");
	printf( "begin-structure v4l2_enc_idx\n" );
	swigStructField( "v4l2_enc_idx-entry", offsetof( struct v4l2_enc_idx, entry ), sizeof( struct v4l2_enc_idx_entry [(64)] ) );
	swigStructField( "v4l2_enc_idx-reserved", offsetof( struct v4l2_enc_idx, reserved ), sizeof( __u32 [4] ) );
	swigStructField( "v4l2_enc_idx-entries_cap", offsetof( struct v4l2_enc_idx, entries_cap ), sizeof( __u32 ) );
	swigStructField( "v4l2_enc_idx-entries", offsetof( struct v4l2_enc_idx, entries ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_enc_idx ) );

	swigComment("struct v4l2_encoder_cmd\n");
	printf( "begin-structure v4l2_encoder_cmd\n" );
	swigStructField( "v4l2_encoder_cmd-raw", offsetof( struct v4l2_encoder_cmd, raw ), sizeof( _raw_enc ) );
	swigStructField( "v4l2_encoder_cmd-flags", offsetof( struct v4l2_encoder_cmd, flags ), sizeof( __u32 ) );
	swigStructField( "v4l2_encoder_cmd-cmd", offsetof( struct v4l2_encoder_cmd, cmd ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_encoder_cmd ) );

	swigComment("struct v4l2_decoder_cmd\n");
	printf( "begin-structure v4l2_decoder_cmd\n" );
	swigStructField( "v4l2_decoder_cmd-stop", offsetof( struct v4l2_decoder_cmd, stop ), sizeof( _stop ) );
	swigStructField( "v4l2_decoder_cmd-raw", offsetof( struct v4l2_decoder_cmd, raw ), sizeof( _raw_dec ) );
	swigStructField( "v4l2_decoder_cmd-flags", offsetof( struct v4l2_decoder_cmd, flags ), sizeof( __u32 ) );
	swigStructField( "v4l2_decoder_cmd-start", offsetof( struct v4l2_decoder_cmd, start ), sizeof( _start ) );
	swigStructField( "v4l2_decoder_cmd-cmd", offsetof( struct v4l2_decoder_cmd, cmd ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_decoder_cmd ) );

	swigComment("struct v4l2_vbi_format\n");
	printf( "begin-structure v4l2_vbi_format\n" );
	swigStructField( "v4l2_vbi_format-sampling_rate", offsetof( struct v4l2_vbi_format, sampling_rate ), sizeof( __u32 ) );
	swigStructField( "v4l2_vbi_format-samples_per_line", offsetof( struct v4l2_vbi_format, samples_per_line ), sizeof( __u32 ) );
	swigStructField( "v4l2_vbi_format-reserved", offsetof( struct v4l2_vbi_format, reserved ), sizeof( __u32 [2] ) );
	swigStructField( "v4l2_vbi_format-count", offsetof( struct v4l2_vbi_format, count ), sizeof( __u32 [2] ) );
	swigStructField( "v4l2_vbi_format-offset", offsetof( struct v4l2_vbi_format, offset ), sizeof( __u32 ) );
	swigStructField( "v4l2_vbi_format-sample_format", offsetof( struct v4l2_vbi_format, sample_format ), sizeof( __u32 ) );
	swigStructField( "v4l2_vbi_format-start", offsetof( struct v4l2_vbi_format, start ), sizeof( __s32 [2] ) );
	swigStructField( "v4l2_vbi_format-flags", offsetof( struct v4l2_vbi_format, flags ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_vbi_format ) );

	swigComment("struct v4l2_sliced_vbi_format\n");
	printf( "begin-structure v4l2_sliced_vbi_format\n" );
	swigStructField( "v4l2_sliced_vbi_format-service_lines", offsetof( struct v4l2_sliced_vbi_format, service_lines ), sizeof( __u16 [2][24] ) );
	swigStructField( "v4l2_sliced_vbi_format-io_size", offsetof( struct v4l2_sliced_vbi_format, io_size ), sizeof( __u32 ) );
	swigStructField( "v4l2_sliced_vbi_format-reserved", offsetof( struct v4l2_sliced_vbi_format, reserved ), sizeof( __u32 [2] ) );
	swigStructField( "v4l2_sliced_vbi_format-service_set", offsetof( struct v4l2_sliced_vbi_format, service_set ), sizeof( __u16 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_sliced_vbi_format ) );

	swigComment("struct v4l2_sliced_vbi_cap\n");
	printf( "begin-structure v4l2_sliced_vbi_cap\n" );
	swigStructField( "v4l2_sliced_vbi_cap-service_lines", offsetof( struct v4l2_sliced_vbi_cap, service_lines ), sizeof( __u16 [2][24] ) );
	swigStructField( "v4l2_sliced_vbi_cap-reserved", offsetof( struct v4l2_sliced_vbi_cap, reserved ), sizeof( __u32 [3] ) );
	swigStructField( "v4l2_sliced_vbi_cap-service_set", offsetof( struct v4l2_sliced_vbi_cap, service_set ), sizeof( __u16 ) );
	swigStructField( "v4l2_sliced_vbi_cap-type", offsetof( struct v4l2_sliced_vbi_cap, type ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_sliced_vbi_cap ) );

	swigComment("struct v4l2_sliced_vbi_data\n");
	printf( "begin-structure v4l2_sliced_vbi_data\n" );
	swigStructField( "v4l2_sliced_vbi_data-field", offsetof( struct v4l2_sliced_vbi_data, field ), sizeof( __u32 ) );
	swigStructField( "v4l2_sliced_vbi_data-reserved", offsetof( struct v4l2_sliced_vbi_data, reserved ), sizeof( __u32 ) );
	swigStructField( "v4l2_sliced_vbi_data-data", offsetof( struct v4l2_sliced_vbi_data, data ), sizeof( __u8 [48] ) );
	swigStructField( "v4l2_sliced_vbi_data-id", offsetof( struct v4l2_sliced_vbi_data, id ), sizeof( __u32 ) );
	swigStructField( "v4l2_sliced_vbi_data-line", offsetof( struct v4l2_sliced_vbi_data, line ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_sliced_vbi_data ) );

	swigComment("struct v4l2_mpeg_vbi_itv0_line\n");
	printf( "begin-structure v4l2_mpeg_vbi_itv0_line\n" );
	swigStructField( "v4l2_mpeg_vbi_itv0_line-data", offsetof( struct v4l2_mpeg_vbi_itv0_line, data ), sizeof( __u8 [42] ) );
	swigStructField( "v4l2_mpeg_vbi_itv0_line-id", offsetof( struct v4l2_mpeg_vbi_itv0_line, id ), sizeof( __u8 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_mpeg_vbi_itv0_line ) );

	swigComment("struct v4l2_mpeg_vbi_itv0\n");
	printf( "begin-structure v4l2_mpeg_vbi_itv0\n" );
	swigStructField( "v4l2_mpeg_vbi_itv0-linemask", offsetof( struct v4l2_mpeg_vbi_itv0, linemask ), sizeof( __le32 [2] ) );
	swigStructField( "v4l2_mpeg_vbi_itv0-line", offsetof( struct v4l2_mpeg_vbi_itv0, line ), sizeof( struct v4l2_mpeg_vbi_itv0_line [35] ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_mpeg_vbi_itv0 ) );

	swigComment("struct v4l2_mpeg_vbi_ITV0\n");
	printf( "begin-structure v4l2_mpeg_vbi_ITV0\n" );
	swigStructField( "v4l2_mpeg_vbi_ITV0-line", offsetof( struct v4l2_mpeg_vbi_ITV0, line ), sizeof( struct v4l2_mpeg_vbi_itv0_line [36] ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_mpeg_vbi_ITV0 ) );

	swigComment("struct v4l2_mpeg_vbi_fmt_ivtv\n");
	printf( "begin-structure v4l2_mpeg_vbi_fmt_ivtv\n" );
	swigStructField( "v4l2_mpeg_vbi_fmt_ivtv-itv0", offsetof( struct v4l2_mpeg_vbi_fmt_ivtv, itv0 ), sizeof( struct v4l2_mpeg_vbi_itv0 ) );
	swigStructField( "v4l2_mpeg_vbi_fmt_ivtv-ITV0", offsetof( struct v4l2_mpeg_vbi_fmt_ivtv, ITV0 ), sizeof( struct v4l2_mpeg_vbi_ITV0 ) );
	swigStructField( "v4l2_mpeg_vbi_fmt_ivtv-magic", offsetof( struct v4l2_mpeg_vbi_fmt_ivtv, magic ), sizeof( __u8 [4] ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_mpeg_vbi_fmt_ivtv ) );

	swigComment("struct v4l2_plane_pix_format\n");
	printf( "begin-structure v4l2_plane_pix_format\n" );
	swigStructField( "v4l2_plane_pix_format-sizeimage", offsetof( struct v4l2_plane_pix_format, sizeimage ), sizeof( __u32 ) );
	swigStructField( "v4l2_plane_pix_format-reserved", offsetof( struct v4l2_plane_pix_format, reserved ), sizeof( __u16 [6] ) );
	swigStructField( "v4l2_plane_pix_format-bytesperline", offsetof( struct v4l2_plane_pix_format, bytesperline ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_plane_pix_format ) );

	swigComment("struct v4l2_pix_format_mplane\n");
	printf( "begin-structure v4l2_pix_format_mplane\n" );
	swigStructField( "v4l2_pix_format_mplane-field", offsetof( struct v4l2_pix_format_mplane, field ), sizeof( __u32 ) );
	swigStructField( "v4l2_pix_format_mplane-reserved", offsetof( struct v4l2_pix_format_mplane, reserved ), sizeof( __u8 [7] ) );
	swigStructField( "v4l2_pix_format_mplane-plane_fmt", offsetof( struct v4l2_pix_format_mplane, plane_fmt ), sizeof( struct v4l2_plane_pix_format [8] ) );
	swigStructField( "v4l2_pix_format_mplane-hsv_enc", offsetof( struct v4l2_pix_format_mplane, hsv_enc ), sizeof( __u8 ) );
	swigStructField( "v4l2_pix_format_mplane-xfer_func", offsetof( struct v4l2_pix_format_mplane, xfer_func ), sizeof( __u8 ) );
	swigStructField( "v4l2_pix_format_mplane-height", offsetof( struct v4l2_pix_format_mplane, height ), sizeof( __u32 ) );
	swigStructField( "v4l2_pix_format_mplane-colorspace", offsetof( struct v4l2_pix_format_mplane, colorspace ), sizeof( __u32 ) );
	swigStructField( "v4l2_pix_format_mplane-ycbcr_enc", offsetof( struct v4l2_pix_format_mplane, ycbcr_enc ), sizeof( __u8 ) );
	swigStructField( "v4l2_pix_format_mplane-quantization", offsetof( struct v4l2_pix_format_mplane, quantization ), sizeof( __u8 ) );
	swigStructField( "v4l2_pix_format_mplane-width", offsetof( struct v4l2_pix_format_mplane, width ), sizeof( __u32 ) );
	swigStructField( "v4l2_pix_format_mplane-pixelformat", offsetof( struct v4l2_pix_format_mplane, pixelformat ), sizeof( __u32 ) );
	swigStructField( "v4l2_pix_format_mplane-num_planes", offsetof( struct v4l2_pix_format_mplane, num_planes ), sizeof( __u8 ) );
	swigStructField( "v4l2_pix_format_mplane-flags", offsetof( struct v4l2_pix_format_mplane, flags ), sizeof( __u8 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_pix_format_mplane ) );

	swigComment("struct v4l2_sdr_format\n");
	printf( "begin-structure v4l2_sdr_format\n" );
	swigStructField( "v4l2_sdr_format-reserved", offsetof( struct v4l2_sdr_format, reserved ), sizeof( __u8 [24] ) );
	swigStructField( "v4l2_sdr_format-buffersize", offsetof( struct v4l2_sdr_format, buffersize ), sizeof( __u32 ) );
	swigStructField( "v4l2_sdr_format-pixelformat", offsetof( struct v4l2_sdr_format, pixelformat ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_sdr_format ) );

	swigComment("struct v4l2_meta_format\n");
	printf( "begin-structure v4l2_meta_format\n" );
	swigStructField( "v4l2_meta_format-buffersize", offsetof( struct v4l2_meta_format, buffersize ), sizeof( __u32 ) );
	swigStructField( "v4l2_meta_format-dataformat", offsetof( struct v4l2_meta_format, dataformat ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_meta_format ) );

	swigComment("struct v4l2_format\n");
	printf( "begin-structure v4l2_format\n" );
	swigStructField( "v4l2_format-fmt", offsetof( struct v4l2_format, fmt ), sizeof( v4l2_format_fmt ) );
	swigStructField( "v4l2_format-type", offsetof( struct v4l2_format, type ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_format ) );

	swigComment("v4l2_format_fmt\n");
	printf( "begin-structure v4l2_format_fmt\n" );
	swigStructField( "v4l2_format_fmt-raw_data", offsetof( v4l2_format_fmt, raw_data ), sizeof( __u8 [200] ) );
	swigStructField( "v4l2_format_fmt-pix", offsetof( v4l2_format_fmt, pix ), sizeof( struct v4l2_pix_format ) );
	swigStructField( "v4l2_format_fmt-pix_mp", offsetof( v4l2_format_fmt, pix_mp ), sizeof( struct v4l2_pix_format_mplane ) );
	swigStructField( "v4l2_format_fmt-sdr", offsetof( v4l2_format_fmt, sdr ), sizeof( struct v4l2_sdr_format ) );
	swigStructField( "v4l2_format_fmt-sliced", offsetof( v4l2_format_fmt, sliced ), sizeof( struct v4l2_sliced_vbi_format ) );
	swigStructField( "v4l2_format_fmt-meta", offsetof( v4l2_format_fmt, meta ), sizeof( struct v4l2_meta_format ) );
	swigStructField( "v4l2_format_fmt-win", offsetof( v4l2_format_fmt, win ), sizeof( struct v4l2_window ) );
	swigStructField( "v4l2_format_fmt-vbi", offsetof( v4l2_format_fmt, vbi ), sizeof( struct v4l2_vbi_format ) );
	printf( "drop %zu end-structure\n", sizeof( v4l2_format_fmt ) );

	swigComment("struct v4l2_streamparm\n");
	printf( "begin-structure v4l2_streamparm\n" );
	swigStructField( "v4l2_streamparm-parm", offsetof( struct v4l2_streamparm, parm ), sizeof( v4l2_streamparm_parm ) );
	swigStructField( "v4l2_streamparm-type", offsetof( struct v4l2_streamparm, type ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_streamparm ) );

	swigComment("v4l2_streamparm_parm\n");
	printf( "begin-structure v4l2_streamparm_parm\n" );
	swigStructField( "v4l2_streamparm_parm-raw_data", offsetof( v4l2_streamparm_parm, raw_data ), sizeof( __u8 [200] ) );
	swigStructField( "v4l2_streamparm_parm-output", offsetof( v4l2_streamparm_parm, output ), sizeof( struct v4l2_outputparm ) );
	swigStructField( "v4l2_streamparm_parm-capture", offsetof( v4l2_streamparm_parm, capture ), sizeof( struct v4l2_captureparm ) );
	printf( "drop %zu end-structure\n", sizeof( v4l2_streamparm_parm ) );

	swigComment("struct v4l2_event_vsync\n");
	printf( "begin-structure v4l2_event_vsync\n" );
	swigStructField( "v4l2_event_vsync-field", offsetof( struct v4l2_event_vsync, field ), sizeof( __u8 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_event_vsync ) );

	swigComment("struct v4l2_event_ctrl\n");
	printf( "begin-structure v4l2_event_ctrl\n" );
	swigStructField( "v4l2_event_ctrl-changes", offsetof( struct v4l2_event_ctrl, changes ), sizeof( __u32 ) );
	swigStructField( "v4l2_event_ctrl-value64", offsetof( struct v4l2_event_ctrl, value64 ), sizeof( __s64 ) );
	swigStructField( "v4l2_event_ctrl-minimum", offsetof( struct v4l2_event_ctrl, minimum ), sizeof( __s32 ) );
	swigStructField( "v4l2_event_ctrl-step", offsetof( struct v4l2_event_ctrl, step ), sizeof( __s32 ) );
	swigStructField( "v4l2_event_ctrl-default_value", offsetof( struct v4l2_event_ctrl, default_value ), sizeof( __s32 ) );
	swigStructField( "v4l2_event_ctrl-value", offsetof( struct v4l2_event_ctrl, value ), sizeof( __s32 ) );
	swigStructField( "v4l2_event_ctrl-maximum", offsetof( struct v4l2_event_ctrl, maximum ), sizeof( __s32 ) );
	swigStructField( "v4l2_event_ctrl-type", offsetof( struct v4l2_event_ctrl, type ), sizeof( __u32 ) );
	swigStructField( "v4l2_event_ctrl-flags", offsetof( struct v4l2_event_ctrl, flags ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_event_ctrl ) );

	swigComment("struct v4l2_event_frame_sync\n");
	printf( "begin-structure v4l2_event_frame_sync\n" );
	swigStructField( "v4l2_event_frame_sync-frame_sequence", offsetof( struct v4l2_event_frame_sync, frame_sequence ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_event_frame_sync ) );

	swigComment("struct v4l2_event_src_change\n");
	printf( "begin-structure v4l2_event_src_change\n" );
	swigStructField( "v4l2_event_src_change-changes", offsetof( struct v4l2_event_src_change, changes ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_event_src_change ) );

	swigComment("struct v4l2_event_motion_det\n");
	printf( "begin-structure v4l2_event_motion_det\n" );
	swigStructField( "v4l2_event_motion_det-frame_sequence", offsetof( struct v4l2_event_motion_det, frame_sequence ), sizeof( __u32 ) );
	swigStructField( "v4l2_event_motion_det-region_mask", offsetof( struct v4l2_event_motion_det, region_mask ), sizeof( __u32 ) );
	swigStructField( "v4l2_event_motion_det-flags", offsetof( struct v4l2_event_motion_det, flags ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_event_motion_det ) );

	swigComment("struct v4l2_event\n");
	printf( "begin-structure v4l2_event\n" );
	swigStructField( "v4l2_event-reserved", offsetof( struct v4l2_event, reserved ), sizeof( __u32 [8] ) );
	swigStructField( "v4l2_event-pending", offsetof( struct v4l2_event, pending ), sizeof( __u32 ) );
	swigStructField( "v4l2_event-id", offsetof( struct v4l2_event, id ), sizeof( __u32 ) );
	swigStructField( "v4l2_event-type", offsetof( struct v4l2_event, type ), sizeof( __u32 ) );
	swigStructField( "v4l2_event-sequence", offsetof( struct v4l2_event, sequence ), sizeof( __u32 ) );
	swigStructField( "v4l2_event-u", offsetof( struct v4l2_event, u ), sizeof( v4l2_event_u ) );
	swigStructField( "v4l2_event-timestamp", offsetof( struct v4l2_event, timestamp ), sizeof( struct timespec ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_event ) );

	swigComment("v4l2_event_u\n");
	printf( "begin-structure v4l2_event_u\n" );
	swigStructField( "v4l2_event_u-data", offsetof( v4l2_event_u, data ), sizeof( __u8 [64] ) );
	swigStructField( "v4l2_event_u-vsync", offsetof( v4l2_event_u, vsync ), sizeof( struct v4l2_event_vsync ) );
	swigStructField( "v4l2_event_u-motion_det", offsetof( v4l2_event_u, motion_det ), sizeof( struct v4l2_event_motion_det ) );
	swigStructField( "v4l2_event_u-frame_sync", offsetof( v4l2_event_u, frame_sync ), sizeof( struct v4l2_event_frame_sync ) );
	swigStructField( "v4l2_event_u-ctrl", offsetof( v4l2_event_u, ctrl ), sizeof( struct v4l2_event_ctrl ) );
	swigStructField( "v4l2_event_u-src_change", offsetof( v4l2_event_u, src_change ), sizeof( struct v4l2_event_src_change ) );
	printf( "drop %zu end-structure\n", sizeof( v4l2_event_u ) );

	swigComment("struct v4l2_event_subscription\n");
	printf( "begin-structure v4l2_event_subscription\n" );
	swigStructField( "v4l2_event_subscription-reserved", offsetof( struct v4l2_event_subscription, reserved ), sizeof( __u32 [5] ) );
	swigStructField( "v4l2_event_subscription-id", offsetof( struct v4l2_event_subscription, id ), sizeof( __u32 ) );
	swigStructField( "v4l2_event_subscription-type", offsetof( struct v4l2_event_subscription, type ), sizeof( __u32 ) );
	swigStructField( "v4l2_event_subscription-flags", offsetof( struct v4l2_event_subscription, flags ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_event_subscription ) );

	swigComment("struct v4l2_dbg_match\n");
	printf( "begin-structure v4l2_dbg_match\n" );
	swigStructField( "v4l2_dbg_match-name", offsetof( struct v4l2_dbg_match, name ), sizeof( char [32] ) );
	swigStructField( "v4l2_dbg_match-type", offsetof( struct v4l2_dbg_match, type ), sizeof( __u32 ) );
	swigStructField( "v4l2_dbg_match-addr", offsetof( struct v4l2_dbg_match, addr ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_dbg_match ) );

	swigComment("struct v4l2_dbg_register\n");
	printf( "begin-structure v4l2_dbg_register\n" );
	swigStructField( "v4l2_dbg_register-reg", offsetof( struct v4l2_dbg_register, reg ), sizeof( __u64 ) );
	swigStructField( "v4l2_dbg_register-size", offsetof( struct v4l2_dbg_register, size ), sizeof( __u32 ) );
	swigStructField( "v4l2_dbg_register-val", offsetof( struct v4l2_dbg_register, val ), sizeof( __u64 ) );
	swigStructField( "v4l2_dbg_register-match", offsetof( struct v4l2_dbg_register, match ), sizeof( struct v4l2_dbg_match ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_dbg_register ) );

	swigComment("struct v4l2_dbg_chip_info\n");
	printf( "begin-structure v4l2_dbg_chip_info\n" );
	swigStructField( "v4l2_dbg_chip_info-name", offsetof( struct v4l2_dbg_chip_info, name ), sizeof( char [32] ) );
	swigStructField( "v4l2_dbg_chip_info-reserved", offsetof( struct v4l2_dbg_chip_info, reserved ), sizeof( __u32 [32] ) );
	swigStructField( "v4l2_dbg_chip_info-match", offsetof( struct v4l2_dbg_chip_info, match ), sizeof( struct v4l2_dbg_match ) );
	swigStructField( "v4l2_dbg_chip_info-flags", offsetof( struct v4l2_dbg_chip_info, flags ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_dbg_chip_info ) );

	swigComment("struct v4l2_create_buffers\n");
	printf( "begin-structure v4l2_create_buffers\n" );
	swigStructField( "v4l2_create_buffers-index", offsetof( struct v4l2_create_buffers, index ), sizeof( __u32 ) );
	swigStructField( "v4l2_create_buffers-capabilities", offsetof( struct v4l2_create_buffers, capabilities ), sizeof( __u32 ) );
	swigStructField( "v4l2_create_buffers-reserved", offsetof( struct v4l2_create_buffers, reserved ), sizeof( __u32 [6] ) );
	swigStructField( "v4l2_create_buffers-count", offsetof( struct v4l2_create_buffers, count ), sizeof( __u32 ) );
	swigStructField( "v4l2_create_buffers-memory", offsetof( struct v4l2_create_buffers, memory ), sizeof( __u32 ) );
	swigStructField( "v4l2_create_buffers-format", offsetof( struct v4l2_create_buffers, format ), sizeof( struct v4l2_format ) );
	swigStructField( "v4l2_create_buffers-flags", offsetof( struct v4l2_create_buffers, flags ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_create_buffers ) );

	swigComment("struct v4l2_edid\n");
	printf( "begin-structure v4l2_edid\n" );
	swigStructField( "v4l2_edid-blocks", offsetof( struct v4l2_edid, blocks ), sizeof( __u32 ) );
	swigStructField( "v4l2_edid-reserved", offsetof( struct v4l2_edid, reserved ), sizeof( __u32 [5] ) );
	swigStructField( "v4l2_edid-edid", offsetof( struct v4l2_edid, edid ), sizeof( __u8 * ) );
	swigStructField( "v4l2_edid-pad", offsetof( struct v4l2_edid, pad ), sizeof( __u32 ) );
	swigStructField( "v4l2_edid-start_block", offsetof( struct v4l2_edid, start_block ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_edid ) );

	swigComment("struct v4l2_ctrl_h264_sps\n");
	printf( "begin-structure v4l2_ctrl_h264_sps\n" );
	swigStructField( "v4l2_ctrl_h264_sps-level_idc", offsetof( struct v4l2_ctrl_h264_sps, level_idc ), sizeof( __u8 ) );
	swigStructField( "v4l2_ctrl_h264_sps-pic_order_cnt_type", offsetof( struct v4l2_ctrl_h264_sps, pic_order_cnt_type ), sizeof( __u8 ) );
	swigStructField( "v4l2_ctrl_h264_sps-constraint_set_flags", offsetof( struct v4l2_ctrl_h264_sps, constraint_set_flags ), sizeof( __u8 ) );
	swigStructField( "v4l2_ctrl_h264_sps-chroma_format_idc", offsetof( struct v4l2_ctrl_h264_sps, chroma_format_idc ), sizeof( __u8 ) );
	swigStructField( "v4l2_ctrl_h264_sps-num_ref_frames_in_pic_order_cnt_cycle", offsetof( struct v4l2_ctrl_h264_sps, num_ref_frames_in_pic_order_cnt_cycle ), sizeof( __u8 ) );
	swigStructField( "v4l2_ctrl_h264_sps-offset_for_top_to_bottom_field", offsetof( struct v4l2_ctrl_h264_sps, offset_for_top_to_bottom_field ), sizeof( __s32 ) );
	swigStructField( "v4l2_ctrl_h264_sps-offset_for_non_ref_pic", offsetof( struct v4l2_ctrl_h264_sps, offset_for_non_ref_pic ), sizeof( __s32 ) );
	swigStructField( "v4l2_ctrl_h264_sps-pic_width_in_mbs_minus1", offsetof( struct v4l2_ctrl_h264_sps, pic_width_in_mbs_minus1 ), sizeof( __u16 ) );
	swigStructField( "v4l2_ctrl_h264_sps-pic_height_in_map_units_minus1", offsetof( struct v4l2_ctrl_h264_sps, pic_height_in_map_units_minus1 ), sizeof( __u16 ) );
	swigStructField( "v4l2_ctrl_h264_sps-profile_idc", offsetof( struct v4l2_ctrl_h264_sps, profile_idc ), sizeof( __u8 ) );
	swigStructField( "v4l2_ctrl_h264_sps-seq_parameter_set_id", offsetof( struct v4l2_ctrl_h264_sps, seq_parameter_set_id ), sizeof( __u8 ) );
	swigStructField( "v4l2_ctrl_h264_sps-log2_max_pic_order_cnt_lsb_minus4", offsetof( struct v4l2_ctrl_h264_sps, log2_max_pic_order_cnt_lsb_minus4 ), sizeof( __u8 ) );
	swigStructField( "v4l2_ctrl_h264_sps-log2_max_frame_num_minus4", offsetof( struct v4l2_ctrl_h264_sps, log2_max_frame_num_minus4 ), sizeof( __u8 ) );
	swigStructField( "v4l2_ctrl_h264_sps-flags", offsetof( struct v4l2_ctrl_h264_sps, flags ), sizeof( __u32 ) );
	swigStructField( "v4l2_ctrl_h264_sps-bit_depth_chroma_minus8", offsetof( struct v4l2_ctrl_h264_sps, bit_depth_chroma_minus8 ), sizeof( __u8 ) );
	swigStructField( "v4l2_ctrl_h264_sps-bit_depth_luma_minus8", offsetof( struct v4l2_ctrl_h264_sps, bit_depth_luma_minus8 ), sizeof( __u8 ) );
	swigStructField( "v4l2_ctrl_h264_sps-max_num_ref_frames", offsetof( struct v4l2_ctrl_h264_sps, max_num_ref_frames ), sizeof( __u8 ) );
	swigStructField( "v4l2_ctrl_h264_sps-offset_for_ref_frame", offsetof( struct v4l2_ctrl_h264_sps, offset_for_ref_frame ), sizeof( __s32 [255] ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_ctrl_h264_sps ) );

	swigComment("struct v4l2_ctrl_h264_pps\n");
	printf( "begin-structure v4l2_ctrl_h264_pps\n" );
	swigStructField( "v4l2_ctrl_h264_pps-pic_parameter_set_id", offsetof( struct v4l2_ctrl_h264_pps, pic_parameter_set_id ), sizeof( __u8 ) );
	swigStructField( "v4l2_ctrl_h264_pps-seq_parameter_set_id", offsetof( struct v4l2_ctrl_h264_pps, seq_parameter_set_id ), sizeof( __u8 ) );
	swigStructField( "v4l2_ctrl_h264_pps-pic_init_qp_minus26", offsetof( struct v4l2_ctrl_h264_pps, pic_init_qp_minus26 ), sizeof( __s8 ) );
	swigStructField( "v4l2_ctrl_h264_pps-pic_init_qs_minus26", offsetof( struct v4l2_ctrl_h264_pps, pic_init_qs_minus26 ), sizeof( __s8 ) );
	swigStructField( "v4l2_ctrl_h264_pps-chroma_qp_index_offset", offsetof( struct v4l2_ctrl_h264_pps, chroma_qp_index_offset ), sizeof( __s8 ) );
	swigStructField( "v4l2_ctrl_h264_pps-second_chroma_qp_index_offset", offsetof( struct v4l2_ctrl_h264_pps, second_chroma_qp_index_offset ), sizeof( __s8 ) );
	swigStructField( "v4l2_ctrl_h264_pps-num_slice_groups_minus1", offsetof( struct v4l2_ctrl_h264_pps, num_slice_groups_minus1 ), sizeof( __u8 ) );
	swigStructField( "v4l2_ctrl_h264_pps-num_ref_idx_l0_default_active_minus1", offsetof( struct v4l2_ctrl_h264_pps, num_ref_idx_l0_default_active_minus1 ), sizeof( __u8 ) );
	swigStructField( "v4l2_ctrl_h264_pps-num_ref_idx_l1_default_active_minus1", offsetof( struct v4l2_ctrl_h264_pps, num_ref_idx_l1_default_active_minus1 ), sizeof( __u8 ) );
	swigStructField( "v4l2_ctrl_h264_pps-weighted_bipred_idc", offsetof( struct v4l2_ctrl_h264_pps, weighted_bipred_idc ), sizeof( __u8 ) );
	swigStructField( "v4l2_ctrl_h264_pps-flags", offsetof( struct v4l2_ctrl_h264_pps, flags ), sizeof( __u16 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_ctrl_h264_pps ) );

	swigComment("struct v4l2_ctrl_h264_scaling_matrix\n");
	printf( "begin-structure v4l2_ctrl_h264_scaling_matrix\n" );
	swigStructField( "v4l2_ctrl_h264_scaling_matrix-scaling_list_4x4", offsetof( struct v4l2_ctrl_h264_scaling_matrix, scaling_list_4x4 ), sizeof( __u8 [6][16] ) );
	swigStructField( "v4l2_ctrl_h264_scaling_matrix-scaling_list_8x8", offsetof( struct v4l2_ctrl_h264_scaling_matrix, scaling_list_8x8 ), sizeof( __u8 [6][64] ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_ctrl_h264_scaling_matrix ) );

	swigComment("struct v4l2_h264_weight_factors\n");
	printf( "begin-structure v4l2_h264_weight_factors\n" );
	swigStructField( "v4l2_h264_weight_factors-luma_offset", offsetof( struct v4l2_h264_weight_factors, luma_offset ), sizeof( __s16 [32] ) );
	swigStructField( "v4l2_h264_weight_factors-chroma_offset", offsetof( struct v4l2_h264_weight_factors, chroma_offset ), sizeof( __s16 [32][2] ) );
	swigStructField( "v4l2_h264_weight_factors-luma_weight", offsetof( struct v4l2_h264_weight_factors, luma_weight ), sizeof( __s16 [32] ) );
	swigStructField( "v4l2_h264_weight_factors-chroma_weight", offsetof( struct v4l2_h264_weight_factors, chroma_weight ), sizeof( __s16 [32][2] ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_h264_weight_factors ) );

	swigComment("struct v4l2_ctrl_h264_pred_weights\n");
	printf( "begin-structure v4l2_ctrl_h264_pred_weights\n" );
	swigStructField( "v4l2_ctrl_h264_pred_weights-luma_log2_weight_denom", offsetof( struct v4l2_ctrl_h264_pred_weights, luma_log2_weight_denom ), sizeof( __u16 ) );
	swigStructField( "v4l2_ctrl_h264_pred_weights-chroma_log2_weight_denom", offsetof( struct v4l2_ctrl_h264_pred_weights, chroma_log2_weight_denom ), sizeof( __u16 ) );
	swigStructField( "v4l2_ctrl_h264_pred_weights-weight_factors", offsetof( struct v4l2_ctrl_h264_pred_weights, weight_factors ), sizeof( struct v4l2_h264_weight_factors [2] ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_ctrl_h264_pred_weights ) );

	swigComment("struct v4l2_h264_reference\n");
	printf( "begin-structure v4l2_h264_reference\n" );
	swigStructField( "v4l2_h264_reference-index", offsetof( struct v4l2_h264_reference, index ), sizeof( __u8 ) );
	swigStructField( "v4l2_h264_reference-fields", offsetof( struct v4l2_h264_reference, fields ), sizeof( __u8 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_h264_reference ) );

	swigComment("struct v4l2_ctrl_h264_slice_params\n");
	printf( "begin-structure v4l2_ctrl_h264_slice_params\n" );
	swigStructField( "v4l2_ctrl_h264_slice_params-cabac_init_idc", offsetof( struct v4l2_ctrl_h264_slice_params, cabac_init_idc ), sizeof( __u8 ) );
	swigStructField( "v4l2_ctrl_h264_slice_params-first_mb_in_slice", offsetof( struct v4l2_ctrl_h264_slice_params, first_mb_in_slice ), sizeof( __u32 ) );
	swigStructField( "v4l2_ctrl_h264_slice_params-ref_pic_list0", offsetof( struct v4l2_ctrl_h264_slice_params, ref_pic_list0 ), sizeof( struct v4l2_h264_reference [(2*16)] ) );
	swigStructField( "v4l2_ctrl_h264_slice_params-reserved", offsetof( struct v4l2_ctrl_h264_slice_params, reserved ), sizeof( __u8 ) );
	swigStructField( "v4l2_ctrl_h264_slice_params-ref_pic_list1", offsetof( struct v4l2_ctrl_h264_slice_params, ref_pic_list1 ), sizeof( struct v4l2_h264_reference [(2*16)] ) );
	swigStructField( "v4l2_ctrl_h264_slice_params-slice_beta_offset_div2", offsetof( struct v4l2_ctrl_h264_slice_params, slice_beta_offset_div2 ), sizeof( __s8 ) );
	swigStructField( "v4l2_ctrl_h264_slice_params-slice_alpha_c0_offset_div2", offsetof( struct v4l2_ctrl_h264_slice_params, slice_alpha_c0_offset_div2 ), sizeof( __s8 ) );
	swigStructField( "v4l2_ctrl_h264_slice_params-num_ref_idx_l1_active_minus1", offsetof( struct v4l2_ctrl_h264_slice_params, num_ref_idx_l1_active_minus1 ), sizeof( __u8 ) );
	swigStructField( "v4l2_ctrl_h264_slice_params-num_ref_idx_l0_active_minus1", offsetof( struct v4l2_ctrl_h264_slice_params, num_ref_idx_l0_active_minus1 ), sizeof( __u8 ) );
	swigStructField( "v4l2_ctrl_h264_slice_params-redundant_pic_cnt", offsetof( struct v4l2_ctrl_h264_slice_params, redundant_pic_cnt ), sizeof( __u8 ) );
	swigStructField( "v4l2_ctrl_h264_slice_params-slice_type", offsetof( struct v4l2_ctrl_h264_slice_params, slice_type ), sizeof( __u8 ) );
	swigStructField( "v4l2_ctrl_h264_slice_params-flags", offsetof( struct v4l2_ctrl_h264_slice_params, flags ), sizeof( __u32 ) );
	swigStructField( "v4l2_ctrl_h264_slice_params-disable_deblocking_filter_idc", offsetof( struct v4l2_ctrl_h264_slice_params, disable_deblocking_filter_idc ), sizeof( __u8 ) );
	swigStructField( "v4l2_ctrl_h264_slice_params-slice_qp_delta", offsetof( struct v4l2_ctrl_h264_slice_params, slice_qp_delta ), sizeof( __s8 ) );
	swigStructField( "v4l2_ctrl_h264_slice_params-colour_plane_id", offsetof( struct v4l2_ctrl_h264_slice_params, colour_plane_id ), sizeof( __u8 ) );
	swigStructField( "v4l2_ctrl_h264_slice_params-header_bit_size", offsetof( struct v4l2_ctrl_h264_slice_params, header_bit_size ), sizeof( __u32 ) );
	swigStructField( "v4l2_ctrl_h264_slice_params-slice_qs_delta", offsetof( struct v4l2_ctrl_h264_slice_params, slice_qs_delta ), sizeof( __s8 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_ctrl_h264_slice_params ) );

	swigComment("struct v4l2_h264_dpb_entry\n");
	printf( "begin-structure v4l2_h264_dpb_entry\n" );
	swigStructField( "v4l2_h264_dpb_entry-top_field_order_cnt", offsetof( struct v4l2_h264_dpb_entry, top_field_order_cnt ), sizeof( __s32 ) );
	swigStructField( "v4l2_h264_dpb_entry-bottom_field_order_cnt", offsetof( struct v4l2_h264_dpb_entry, bottom_field_order_cnt ), sizeof( __s32 ) );
	swigStructField( "v4l2_h264_dpb_entry-reserved", offsetof( struct v4l2_h264_dpb_entry, reserved ), sizeof( __u8 [5] ) );
	swigStructField( "v4l2_h264_dpb_entry-pic_num", offsetof( struct v4l2_h264_dpb_entry, pic_num ), sizeof( __u32 ) );
	swigStructField( "v4l2_h264_dpb_entry-fields", offsetof( struct v4l2_h264_dpb_entry, fields ), sizeof( __u8 ) );
	swigStructField( "v4l2_h264_dpb_entry-flags", offsetof( struct v4l2_h264_dpb_entry, flags ), sizeof( __u32 ) );
	swigStructField( "v4l2_h264_dpb_entry-reference_ts", offsetof( struct v4l2_h264_dpb_entry, reference_ts ), sizeof( __u64 ) );
	swigStructField( "v4l2_h264_dpb_entry-frame_num", offsetof( struct v4l2_h264_dpb_entry, frame_num ), sizeof( __u16 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_h264_dpb_entry ) );

	swigComment("struct v4l2_ctrl_h264_decode_params\n");
	printf( "begin-structure v4l2_ctrl_h264_decode_params\n" );
	swigStructField( "v4l2_ctrl_h264_decode_params-delta_pic_order_cnt0", offsetof( struct v4l2_ctrl_h264_decode_params, delta_pic_order_cnt0 ), sizeof( __s32 ) );
	swigStructField( "v4l2_ctrl_h264_decode_params-idr_pic_id", offsetof( struct v4l2_ctrl_h264_decode_params, idr_pic_id ), sizeof( __u16 ) );
	swigStructField( "v4l2_ctrl_h264_decode_params-delta_pic_order_cnt1", offsetof( struct v4l2_ctrl_h264_decode_params, delta_pic_order_cnt1 ), sizeof( __s32 ) );
	swigStructField( "v4l2_ctrl_h264_decode_params-dpb", offsetof( struct v4l2_ctrl_h264_decode_params, dpb ), sizeof( struct v4l2_h264_dpb_entry [16] ) );
	swigStructField( "v4l2_ctrl_h264_decode_params-bottom_field_order_cnt", offsetof( struct v4l2_ctrl_h264_decode_params, bottom_field_order_cnt ), sizeof( __s32 ) );
	swigStructField( "v4l2_ctrl_h264_decode_params-top_field_order_cnt", offsetof( struct v4l2_ctrl_h264_decode_params, top_field_order_cnt ), sizeof( __s32 ) );
	swigStructField( "v4l2_ctrl_h264_decode_params-frame_num", offsetof( struct v4l2_ctrl_h264_decode_params, frame_num ), sizeof( __u16 ) );
	swigStructField( "v4l2_ctrl_h264_decode_params-nal_ref_idc", offsetof( struct v4l2_ctrl_h264_decode_params, nal_ref_idc ), sizeof( __u16 ) );
	swigStructField( "v4l2_ctrl_h264_decode_params-reserved", offsetof( struct v4l2_ctrl_h264_decode_params, reserved ), sizeof( __u32 ) );
	swigStructField( "v4l2_ctrl_h264_decode_params-slice_group_change_cycle", offsetof( struct v4l2_ctrl_h264_decode_params, slice_group_change_cycle ), sizeof( __u32 ) );
	swigStructField( "v4l2_ctrl_h264_decode_params-flags", offsetof( struct v4l2_ctrl_h264_decode_params, flags ), sizeof( __u32 ) );
	swigStructField( "v4l2_ctrl_h264_decode_params-delta_pic_order_cnt_bottom", offsetof( struct v4l2_ctrl_h264_decode_params, delta_pic_order_cnt_bottom ), sizeof( __s32 ) );
	swigStructField( "v4l2_ctrl_h264_decode_params-pic_order_cnt_lsb", offsetof( struct v4l2_ctrl_h264_decode_params, pic_order_cnt_lsb ), sizeof( __u16 ) );
	swigStructField( "v4l2_ctrl_h264_decode_params-pic_order_cnt_bit_size", offsetof( struct v4l2_ctrl_h264_decode_params, pic_order_cnt_bit_size ), sizeof( __u32 ) );
	swigStructField( "v4l2_ctrl_h264_decode_params-dec_ref_pic_marking_bit_size", offsetof( struct v4l2_ctrl_h264_decode_params, dec_ref_pic_marking_bit_size ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_ctrl_h264_decode_params ) );

	swigComment("struct v4l2_ctrl_fwht_params\n");
	printf( "begin-structure v4l2_ctrl_fwht_params\n" );
	swigStructField( "v4l2_ctrl_fwht_params-backward_ref_ts", offsetof( struct v4l2_ctrl_fwht_params, backward_ref_ts ), sizeof( __u64 ) );
	swigStructField( "v4l2_ctrl_fwht_params-version", offsetof( struct v4l2_ctrl_fwht_params, version ), sizeof( __u32 ) );
	swigStructField( "v4l2_ctrl_fwht_params-xfer_func", offsetof( struct v4l2_ctrl_fwht_params, xfer_func ), sizeof( __u32 ) );
	swigStructField( "v4l2_ctrl_fwht_params-height", offsetof( struct v4l2_ctrl_fwht_params, height ), sizeof( __u32 ) );
	swigStructField( "v4l2_ctrl_fwht_params-colorspace", offsetof( struct v4l2_ctrl_fwht_params, colorspace ), sizeof( __u32 ) );
	swigStructField( "v4l2_ctrl_fwht_params-ycbcr_enc", offsetof( struct v4l2_ctrl_fwht_params, ycbcr_enc ), sizeof( __u32 ) );
	swigStructField( "v4l2_ctrl_fwht_params-quantization", offsetof( struct v4l2_ctrl_fwht_params, quantization ), sizeof( __u32 ) );
	swigStructField( "v4l2_ctrl_fwht_params-width", offsetof( struct v4l2_ctrl_fwht_params, width ), sizeof( __u32 ) );
	swigStructField( "v4l2_ctrl_fwht_params-flags", offsetof( struct v4l2_ctrl_fwht_params, flags ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_ctrl_fwht_params ) );

	swigComment("struct v4l2_vp8_segment\n");
	printf( "begin-structure v4l2_vp8_segment\n" );
	swigStructField( "v4l2_vp8_segment-segment_probs", offsetof( struct v4l2_vp8_segment, segment_probs ), sizeof( __u8 [3] ) );
	swigStructField( "v4l2_vp8_segment-padding", offsetof( struct v4l2_vp8_segment, padding ), sizeof( __u8 ) );
	swigStructField( "v4l2_vp8_segment-quant_update", offsetof( struct v4l2_vp8_segment, quant_update ), sizeof( __s8 [4] ) );
	swigStructField( "v4l2_vp8_segment-lf_update", offsetof( struct v4l2_vp8_segment, lf_update ), sizeof( __s8 [4] ) );
	swigStructField( "v4l2_vp8_segment-flags", offsetof( struct v4l2_vp8_segment, flags ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_vp8_segment ) );

	swigComment("struct v4l2_vp8_loop_filter\n");
	printf( "begin-structure v4l2_vp8_loop_filter\n" );
	swigStructField( "v4l2_vp8_loop_filter-level", offsetof( struct v4l2_vp8_loop_filter, level ), sizeof( __u8 ) );
	swigStructField( "v4l2_vp8_loop_filter-ref_frm_delta", offsetof( struct v4l2_vp8_loop_filter, ref_frm_delta ), sizeof( __s8 [4] ) );
	swigStructField( "v4l2_vp8_loop_filter-mb_mode_delta", offsetof( struct v4l2_vp8_loop_filter, mb_mode_delta ), sizeof( __s8 [4] ) );
	swigStructField( "v4l2_vp8_loop_filter-padding", offsetof( struct v4l2_vp8_loop_filter, padding ), sizeof( __u16 ) );
	swigStructField( "v4l2_vp8_loop_filter-sharpness_level", offsetof( struct v4l2_vp8_loop_filter, sharpness_level ), sizeof( __u8 ) );
	swigStructField( "v4l2_vp8_loop_filter-flags", offsetof( struct v4l2_vp8_loop_filter, flags ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_vp8_loop_filter ) );

	swigComment("struct v4l2_vp8_quantization\n");
	printf( "begin-structure v4l2_vp8_quantization\n" );
	swigStructField( "v4l2_vp8_quantization-y_ac_qi", offsetof( struct v4l2_vp8_quantization, y_ac_qi ), sizeof( __u8 ) );
	swigStructField( "v4l2_vp8_quantization-y_dc_delta", offsetof( struct v4l2_vp8_quantization, y_dc_delta ), sizeof( __s8 ) );
	swigStructField( "v4l2_vp8_quantization-y2_dc_delta", offsetof( struct v4l2_vp8_quantization, y2_dc_delta ), sizeof( __s8 ) );
	swigStructField( "v4l2_vp8_quantization-y2_ac_delta", offsetof( struct v4l2_vp8_quantization, y2_ac_delta ), sizeof( __s8 ) );
	swigStructField( "v4l2_vp8_quantization-uv_dc_delta", offsetof( struct v4l2_vp8_quantization, uv_dc_delta ), sizeof( __s8 ) );
	swigStructField( "v4l2_vp8_quantization-uv_ac_delta", offsetof( struct v4l2_vp8_quantization, uv_ac_delta ), sizeof( __s8 ) );
	swigStructField( "v4l2_vp8_quantization-padding", offsetof( struct v4l2_vp8_quantization, padding ), sizeof( __u16 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_vp8_quantization ) );

	swigComment("struct v4l2_vp8_entropy\n");
	printf( "begin-structure v4l2_vp8_entropy\n" );
	swigStructField( "v4l2_vp8_entropy-y_mode_probs", offsetof( struct v4l2_vp8_entropy, y_mode_probs ), sizeof( __u8 [4] ) );
	swigStructField( "v4l2_vp8_entropy-uv_mode_probs", offsetof( struct v4l2_vp8_entropy, uv_mode_probs ), sizeof( __u8 [3] ) );
	swigStructField( "v4l2_vp8_entropy-coeff_probs", offsetof( struct v4l2_vp8_entropy, coeff_probs ), sizeof( __u8 [4][8][3][11] ) );
	swigStructField( "v4l2_vp8_entropy-mv_probs", offsetof( struct v4l2_vp8_entropy, mv_probs ), sizeof( __u8 [2][19] ) );
	swigStructField( "v4l2_vp8_entropy-padding", offsetof( struct v4l2_vp8_entropy, padding ), sizeof( __u8 [3] ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_vp8_entropy ) );

	swigComment("struct v4l2_vp8_entropy_coder_state\n");
	printf( "begin-structure v4l2_vp8_entropy_coder_state\n" );
	swigStructField( "v4l2_vp8_entropy_coder_state-bit_count", offsetof( struct v4l2_vp8_entropy_coder_state, bit_count ), sizeof( __u8 ) );
	swigStructField( "v4l2_vp8_entropy_coder_state-value", offsetof( struct v4l2_vp8_entropy_coder_state, value ), sizeof( __u8 ) );
	swigStructField( "v4l2_vp8_entropy_coder_state-padding", offsetof( struct v4l2_vp8_entropy_coder_state, padding ), sizeof( __u8 ) );
	swigStructField( "v4l2_vp8_entropy_coder_state-range", offsetof( struct v4l2_vp8_entropy_coder_state, range ), sizeof( __u8 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_vp8_entropy_coder_state ) );

	swigComment("struct v4l2_ctrl_vp8_frame\n");
	printf( "begin-structure v4l2_ctrl_vp8_frame\n" );
	swigStructField( "v4l2_ctrl_vp8_frame-quant", offsetof( struct v4l2_ctrl_vp8_frame, quant ), sizeof( struct v4l2_vp8_quantization ) );
	swigStructField( "v4l2_ctrl_vp8_frame-dct_part_sizes", offsetof( struct v4l2_ctrl_vp8_frame, dct_part_sizes ), sizeof( __u32 [8] ) );
	swigStructField( "v4l2_ctrl_vp8_frame-height", offsetof( struct v4l2_ctrl_vp8_frame, height ), sizeof( __u16 ) );
	swigStructField( "v4l2_ctrl_vp8_frame-entropy", offsetof( struct v4l2_ctrl_vp8_frame, entropy ), sizeof( struct v4l2_vp8_entropy ) );
	swigStructField( "v4l2_ctrl_vp8_frame-first_part_header_bits", offsetof( struct v4l2_ctrl_vp8_frame, first_part_header_bits ), sizeof( __u32 ) );
	swigStructField( "v4l2_ctrl_vp8_frame-prob_intra", offsetof( struct v4l2_ctrl_vp8_frame, prob_intra ), sizeof( __u8 ) );
	swigStructField( "v4l2_ctrl_vp8_frame-lf", offsetof( struct v4l2_ctrl_vp8_frame, lf ), sizeof( struct v4l2_vp8_loop_filter ) );
	swigStructField( "v4l2_ctrl_vp8_frame-vertical_scale", offsetof( struct v4l2_ctrl_vp8_frame, vertical_scale ), sizeof( __u8 ) );
	swigStructField( "v4l2_ctrl_vp8_frame-horizontal_scale", offsetof( struct v4l2_ctrl_vp8_frame, horizontal_scale ), sizeof( __u8 ) );
	swigStructField( "v4l2_ctrl_vp8_frame-num_dct_parts", offsetof( struct v4l2_ctrl_vp8_frame, num_dct_parts ), sizeof( __u8 ) );
	swigStructField( "v4l2_ctrl_vp8_frame-coder_state", offsetof( struct v4l2_ctrl_vp8_frame, coder_state ), sizeof( struct v4l2_vp8_entropy_coder_state ) );
	swigStructField( "v4l2_ctrl_vp8_frame-last_frame_ts", offsetof( struct v4l2_ctrl_vp8_frame, last_frame_ts ), sizeof( __u64 ) );
	swigStructField( "v4l2_ctrl_vp8_frame-golden_frame_ts", offsetof( struct v4l2_ctrl_vp8_frame, golden_frame_ts ), sizeof( __u64 ) );
	swigStructField( "v4l2_ctrl_vp8_frame-alt_frame_ts", offsetof( struct v4l2_ctrl_vp8_frame, alt_frame_ts ), sizeof( __u64 ) );
	swigStructField( "v4l2_ctrl_vp8_frame-prob_gf", offsetof( struct v4l2_ctrl_vp8_frame, prob_gf ), sizeof( __u8 ) );
	swigStructField( "v4l2_ctrl_vp8_frame-width", offsetof( struct v4l2_ctrl_vp8_frame, width ), sizeof( __u16 ) );
	swigStructField( "v4l2_ctrl_vp8_frame-version", offsetof( struct v4l2_ctrl_vp8_frame, version ), sizeof( __u8 ) );
	swigStructField( "v4l2_ctrl_vp8_frame-flags", offsetof( struct v4l2_ctrl_vp8_frame, flags ), sizeof( __u64 ) );
	swigStructField( "v4l2_ctrl_vp8_frame-first_part_size", offsetof( struct v4l2_ctrl_vp8_frame, first_part_size ), sizeof( __u32 ) );
	swigStructField( "v4l2_ctrl_vp8_frame-prob_skip_false", offsetof( struct v4l2_ctrl_vp8_frame, prob_skip_false ), sizeof( __u8 ) );
	swigStructField( "v4l2_ctrl_vp8_frame-segment", offsetof( struct v4l2_ctrl_vp8_frame, segment ), sizeof( struct v4l2_vp8_segment ) );
	swigStructField( "v4l2_ctrl_vp8_frame-prob_last", offsetof( struct v4l2_ctrl_vp8_frame, prob_last ), sizeof( __u8 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_ctrl_vp8_frame ) );

	swigComment("struct v4l2_ctrl_mpeg2_sequence\n");
	printf( "begin-structure v4l2_ctrl_mpeg2_sequence\n" );
	swigStructField( "v4l2_ctrl_mpeg2_sequence-vbv_buffer_size", offsetof( struct v4l2_ctrl_mpeg2_sequence, vbv_buffer_size ), sizeof( __u32 ) );
	swigStructField( "v4l2_ctrl_mpeg2_sequence-profile_and_level_indication", offsetof( struct v4l2_ctrl_mpeg2_sequence, profile_and_level_indication ), sizeof( __u16 ) );
	swigStructField( "v4l2_ctrl_mpeg2_sequence-horizontal_size", offsetof( struct v4l2_ctrl_mpeg2_sequence, horizontal_size ), sizeof( __u16 ) );
	swigStructField( "v4l2_ctrl_mpeg2_sequence-vertical_size", offsetof( struct v4l2_ctrl_mpeg2_sequence, vertical_size ), sizeof( __u16 ) );
	swigStructField( "v4l2_ctrl_mpeg2_sequence-chroma_format", offsetof( struct v4l2_ctrl_mpeg2_sequence, chroma_format ), sizeof( __u8 ) );
	swigStructField( "v4l2_ctrl_mpeg2_sequence-flags", offsetof( struct v4l2_ctrl_mpeg2_sequence, flags ), sizeof( __u8 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_ctrl_mpeg2_sequence ) );

	swigComment("struct v4l2_ctrl_mpeg2_picture\n");
	printf( "begin-structure v4l2_ctrl_mpeg2_picture\n" );
	swigStructField( "v4l2_ctrl_mpeg2_picture-picture_coding_type", offsetof( struct v4l2_ctrl_mpeg2_picture, picture_coding_type ), sizeof( __u8 ) );
	swigStructField( "v4l2_ctrl_mpeg2_picture-reserved", offsetof( struct v4l2_ctrl_mpeg2_picture, reserved ), sizeof( __u8 [5] ) );
	swigStructField( "v4l2_ctrl_mpeg2_picture-backward_ref_ts", offsetof( struct v4l2_ctrl_mpeg2_picture, backward_ref_ts ), sizeof( __u64 ) );
	swigStructField( "v4l2_ctrl_mpeg2_picture-forward_ref_ts", offsetof( struct v4l2_ctrl_mpeg2_picture, forward_ref_ts ), sizeof( __u64 ) );
	swigStructField( "v4l2_ctrl_mpeg2_picture-picture_structure", offsetof( struct v4l2_ctrl_mpeg2_picture, picture_structure ), sizeof( __u8 ) );
	swigStructField( "v4l2_ctrl_mpeg2_picture-intra_dc_precision", offsetof( struct v4l2_ctrl_mpeg2_picture, intra_dc_precision ), sizeof( __u8 ) );
	swigStructField( "v4l2_ctrl_mpeg2_picture-f_code", offsetof( struct v4l2_ctrl_mpeg2_picture, f_code ), sizeof( __u8 [2][2] ) );
	swigStructField( "v4l2_ctrl_mpeg2_picture-flags", offsetof( struct v4l2_ctrl_mpeg2_picture, flags ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_ctrl_mpeg2_picture ) );

	swigComment("struct v4l2_ctrl_mpeg2_quantisation\n");
	printf( "begin-structure v4l2_ctrl_mpeg2_quantisation\n" );
	swigStructField( "v4l2_ctrl_mpeg2_quantisation-intra_quantiser_matrix", offsetof( struct v4l2_ctrl_mpeg2_quantisation, intra_quantiser_matrix ), sizeof( __u8 [64] ) );
	swigStructField( "v4l2_ctrl_mpeg2_quantisation-non_intra_quantiser_matrix", offsetof( struct v4l2_ctrl_mpeg2_quantisation, non_intra_quantiser_matrix ), sizeof( __u8 [64] ) );
	swigStructField( "v4l2_ctrl_mpeg2_quantisation-chroma_intra_quantiser_matrix", offsetof( struct v4l2_ctrl_mpeg2_quantisation, chroma_intra_quantiser_matrix ), sizeof( __u8 [64] ) );
	swigStructField( "v4l2_ctrl_mpeg2_quantisation-chroma_non_intra_quantiser_matrix", offsetof( struct v4l2_ctrl_mpeg2_quantisation, chroma_non_intra_quantiser_matrix ), sizeof( __u8 [64] ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_ctrl_mpeg2_quantisation ) );

	swigComment("struct v4l2_ctrl_hdr10_cll_info\n");
	printf( "begin-structure v4l2_ctrl_hdr10_cll_info\n" );
	swigStructField( "v4l2_ctrl_hdr10_cll_info-max_content_light_level", offsetof( struct v4l2_ctrl_hdr10_cll_info, max_content_light_level ), sizeof( __u16 ) );
	swigStructField( "v4l2_ctrl_hdr10_cll_info-max_pic_average_light_level", offsetof( struct v4l2_ctrl_hdr10_cll_info, max_pic_average_light_level ), sizeof( __u16 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_ctrl_hdr10_cll_info ) );

	swigComment("struct v4l2_ctrl_hdr10_mastering_display\n");
	printf( "begin-structure v4l2_ctrl_hdr10_mastering_display\n" );
	swigStructField( "v4l2_ctrl_hdr10_mastering_display-display_primaries_y", offsetof( struct v4l2_ctrl_hdr10_mastering_display, display_primaries_y ), sizeof( __u16 [3] ) );
	swigStructField( "v4l2_ctrl_hdr10_mastering_display-white_point_x", offsetof( struct v4l2_ctrl_hdr10_mastering_display, white_point_x ), sizeof( __u16 ) );
	swigStructField( "v4l2_ctrl_hdr10_mastering_display-max_display_mastering_luminance", offsetof( struct v4l2_ctrl_hdr10_mastering_display, max_display_mastering_luminance ), sizeof( __u32 ) );
	swigStructField( "v4l2_ctrl_hdr10_mastering_display-min_display_mastering_luminance", offsetof( struct v4l2_ctrl_hdr10_mastering_display, min_display_mastering_luminance ), sizeof( __u32 ) );
	swigStructField( "v4l2_ctrl_hdr10_mastering_display-display_primaries_x", offsetof( struct v4l2_ctrl_hdr10_mastering_display, display_primaries_x ), sizeof( __u16 [3] ) );
	swigStructField( "v4l2_ctrl_hdr10_mastering_display-white_point_y", offsetof( struct v4l2_ctrl_hdr10_mastering_display, white_point_y ), sizeof( __u16 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_ctrl_hdr10_mastering_display ) );

	swigComment("struct v4l2_vp9_loop_filter\n");
	printf( "begin-structure v4l2_vp9_loop_filter\n" );
	swigStructField( "v4l2_vp9_loop_filter-level", offsetof( struct v4l2_vp9_loop_filter, level ), sizeof( __u8 ) );
	swigStructField( "v4l2_vp9_loop_filter-reserved", offsetof( struct v4l2_vp9_loop_filter, reserved ), sizeof( __u8 [7] ) );
	swigStructField( "v4l2_vp9_loop_filter-ref_deltas", offsetof( struct v4l2_vp9_loop_filter, ref_deltas ), sizeof( __s8 [4] ) );
	swigStructField( "v4l2_vp9_loop_filter-mode_deltas", offsetof( struct v4l2_vp9_loop_filter, mode_deltas ), sizeof( __s8 [2] ) );
	swigStructField( "v4l2_vp9_loop_filter-flags", offsetof( struct v4l2_vp9_loop_filter, flags ), sizeof( __u8 ) );
	swigStructField( "v4l2_vp9_loop_filter-sharpness", offsetof( struct v4l2_vp9_loop_filter, sharpness ), sizeof( __u8 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_vp9_loop_filter ) );

	swigComment("struct v4l2_vp9_quantization\n");
	printf( "begin-structure v4l2_vp9_quantization\n" );
	swigStructField( "v4l2_vp9_quantization-base_q_idx", offsetof( struct v4l2_vp9_quantization, base_q_idx ), sizeof( __u8 ) );
	swigStructField( "v4l2_vp9_quantization-delta_q_uv_ac", offsetof( struct v4l2_vp9_quantization, delta_q_uv_ac ), sizeof( __s8 ) );
	swigStructField( "v4l2_vp9_quantization-reserved", offsetof( struct v4l2_vp9_quantization, reserved ), sizeof( __u8 [4] ) );
	swigStructField( "v4l2_vp9_quantization-delta_q_y_dc", offsetof( struct v4l2_vp9_quantization, delta_q_y_dc ), sizeof( __s8 ) );
	swigStructField( "v4l2_vp9_quantization-delta_q_uv_dc", offsetof( struct v4l2_vp9_quantization, delta_q_uv_dc ), sizeof( __s8 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_vp9_quantization ) );

	swigComment("struct v4l2_vp9_segmentation\n");
	printf( "begin-structure v4l2_vp9_segmentation\n" );
	swigStructField( "v4l2_vp9_segmentation-feature_data", offsetof( struct v4l2_vp9_segmentation, feature_data ), sizeof( __s16 [8][4] ) );
	swigStructField( "v4l2_vp9_segmentation-tree_probs", offsetof( struct v4l2_vp9_segmentation, tree_probs ), sizeof( __u8 [7] ) );
	swigStructField( "v4l2_vp9_segmentation-reserved", offsetof( struct v4l2_vp9_segmentation, reserved ), sizeof( __u8 [5] ) );
	swigStructField( "v4l2_vp9_segmentation-feature_enabled", offsetof( struct v4l2_vp9_segmentation, feature_enabled ), sizeof( __u8 [8] ) );
	swigStructField( "v4l2_vp9_segmentation-pred_probs", offsetof( struct v4l2_vp9_segmentation, pred_probs ), sizeof( __u8 [3] ) );
	swigStructField( "v4l2_vp9_segmentation-flags", offsetof( struct v4l2_vp9_segmentation, flags ), sizeof( __u8 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_vp9_segmentation ) );

	swigComment("struct v4l2_ctrl_vp9_frame\n");
	printf( "begin-structure v4l2_ctrl_vp9_frame\n" );
	swigStructField( "v4l2_ctrl_vp9_frame-quant", offsetof( struct v4l2_ctrl_vp9_frame, quant ), sizeof( struct v4l2_vp9_quantization ) );
	swigStructField( "v4l2_ctrl_vp9_frame-ref_frame_sign_bias", offsetof( struct v4l2_ctrl_vp9_frame, ref_frame_sign_bias ), sizeof( __u8 ) );
	swigStructField( "v4l2_ctrl_vp9_frame-reference_mode", offsetof( struct v4l2_ctrl_vp9_frame, reference_mode ), sizeof( __u8 ) );
	swigStructField( "v4l2_ctrl_vp9_frame-bit_depth", offsetof( struct v4l2_ctrl_vp9_frame, bit_depth ), sizeof( __u8 ) );
	swigStructField( "v4l2_ctrl_vp9_frame-reset_frame_context", offsetof( struct v4l2_ctrl_vp9_frame, reset_frame_context ), sizeof( __u8 ) );
	swigStructField( "v4l2_ctrl_vp9_frame-seg", offsetof( struct v4l2_ctrl_vp9_frame, seg ), sizeof( struct v4l2_vp9_segmentation ) );
	swigStructField( "v4l2_ctrl_vp9_frame-render_height_minus_1", offsetof( struct v4l2_ctrl_vp9_frame, render_height_minus_1 ), sizeof( __u16 ) );
	swigStructField( "v4l2_ctrl_vp9_frame-render_width_minus_1", offsetof( struct v4l2_ctrl_vp9_frame, render_width_minus_1 ), sizeof( __u16 ) );
	swigStructField( "v4l2_ctrl_vp9_frame-frame_height_minus_1", offsetof( struct v4l2_ctrl_vp9_frame, frame_height_minus_1 ), sizeof( __u16 ) );
	swigStructField( "v4l2_ctrl_vp9_frame-frame_width_minus_1", offsetof( struct v4l2_ctrl_vp9_frame, frame_width_minus_1 ), sizeof( __u16 ) );
	swigStructField( "v4l2_ctrl_vp9_frame-lf", offsetof( struct v4l2_ctrl_vp9_frame, lf ), sizeof( struct v4l2_vp9_loop_filter ) );
	swigStructField( "v4l2_ctrl_vp9_frame-frame_context_idx", offsetof( struct v4l2_ctrl_vp9_frame, frame_context_idx ), sizeof( __u8 ) );
	swigStructField( "v4l2_ctrl_vp9_frame-profile", offsetof( struct v4l2_ctrl_vp9_frame, profile ), sizeof( __u8 ) );
	swigStructField( "v4l2_ctrl_vp9_frame-alt_frame_ts", offsetof( struct v4l2_ctrl_vp9_frame, alt_frame_ts ), sizeof( __u64 ) );
	swigStructField( "v4l2_ctrl_vp9_frame-golden_frame_ts", offsetof( struct v4l2_ctrl_vp9_frame, golden_frame_ts ), sizeof( __u64 ) );
	swigStructField( "v4l2_ctrl_vp9_frame-last_frame_ts", offsetof( struct v4l2_ctrl_vp9_frame, last_frame_ts ), sizeof( __u64 ) );
	swigStructField( "v4l2_ctrl_vp9_frame-reserved", offsetof( struct v4l2_ctrl_vp9_frame, reserved ), sizeof( __u8 [7] ) );
	swigStructField( "v4l2_ctrl_vp9_frame-tile_cols_log2", offsetof( struct v4l2_ctrl_vp9_frame, tile_cols_log2 ), sizeof( __u8 ) );
	swigStructField( "v4l2_ctrl_vp9_frame-flags", offsetof( struct v4l2_ctrl_vp9_frame, flags ), sizeof( __u32 ) );
	swigStructField( "v4l2_ctrl_vp9_frame-uncompressed_header_size", offsetof( struct v4l2_ctrl_vp9_frame, uncompressed_header_size ), sizeof( __u16 ) );
	swigStructField( "v4l2_ctrl_vp9_frame-compressed_header_size", offsetof( struct v4l2_ctrl_vp9_frame, compressed_header_size ), sizeof( __u16 ) );
	swigStructField( "v4l2_ctrl_vp9_frame-tile_rows_log2", offsetof( struct v4l2_ctrl_vp9_frame, tile_rows_log2 ), sizeof( __u8 ) );
	swigStructField( "v4l2_ctrl_vp9_frame-interpolation_filter", offsetof( struct v4l2_ctrl_vp9_frame, interpolation_filter ), sizeof( __u8 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_ctrl_vp9_frame ) );

	swigComment("struct v4l2_vp9_mv_probs\n");
	printf( "begin-structure v4l2_vp9_mv_probs\n" );
	swigStructField( "v4l2_vp9_mv_probs-sign", offsetof( struct v4l2_vp9_mv_probs, sign ), sizeof( __u8 [2] ) );
	swigStructField( "v4l2_vp9_mv_probs-class0_bit", offsetof( struct v4l2_vp9_mv_probs, class0_bit ), sizeof( __u8 [2] ) );
	swigStructField( "v4l2_vp9_mv_probs-classes", offsetof( struct v4l2_vp9_mv_probs, classes ), sizeof( __u8 [2][10] ) );
	swigStructField( "v4l2_vp9_mv_probs-hp", offsetof( struct v4l2_vp9_mv_probs, hp ), sizeof( __u8 [2] ) );
	swigStructField( "v4l2_vp9_mv_probs-fr", offsetof( struct v4l2_vp9_mv_probs, fr ), sizeof( __u8 [2][3] ) );
	swigStructField( "v4l2_vp9_mv_probs-class0_hp", offsetof( struct v4l2_vp9_mv_probs, class0_hp ), sizeof( __u8 [2] ) );
	swigStructField( "v4l2_vp9_mv_probs-bits", offsetof( struct v4l2_vp9_mv_probs, bits ), sizeof( __u8 [2][10] ) );
	swigStructField( "v4l2_vp9_mv_probs-class0_fr", offsetof( struct v4l2_vp9_mv_probs, class0_fr ), sizeof( __u8 [2][2][3] ) );
	swigStructField( "v4l2_vp9_mv_probs-joint", offsetof( struct v4l2_vp9_mv_probs, joint ), sizeof( __u8 [3] ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_vp9_mv_probs ) );

	swigComment("struct v4l2_ctrl_vp9_compressed_hdr\n");
	printf( "begin-structure v4l2_ctrl_vp9_compressed_hdr\n" );
	swigStructField( "v4l2_ctrl_vp9_compressed_hdr-uv_mode", offsetof( struct v4l2_ctrl_vp9_compressed_hdr, uv_mode ), sizeof( __u8 [10][9] ) );
	swigStructField( "v4l2_ctrl_vp9_compressed_hdr-tx_mode", offsetof( struct v4l2_ctrl_vp9_compressed_hdr, tx_mode ), sizeof( __u8 ) );
	swigStructField( "v4l2_ctrl_vp9_compressed_hdr-is_inter", offsetof( struct v4l2_ctrl_vp9_compressed_hdr, is_inter ), sizeof( __u8 [4] ) );
	swigStructField( "v4l2_ctrl_vp9_compressed_hdr-tx16", offsetof( struct v4l2_ctrl_vp9_compressed_hdr, tx16 ), sizeof( __u8 [2][2] ) );
	swigStructField( "v4l2_ctrl_vp9_compressed_hdr-y_mode", offsetof( struct v4l2_ctrl_vp9_compressed_hdr, y_mode ), sizeof( __u8 [4][9] ) );
	swigStructField( "v4l2_ctrl_vp9_compressed_hdr-mv", offsetof( struct v4l2_ctrl_vp9_compressed_hdr, mv ), sizeof( struct v4l2_vp9_mv_probs ) );
	swigStructField( "v4l2_ctrl_vp9_compressed_hdr-comp_ref", offsetof( struct v4l2_ctrl_vp9_compressed_hdr, comp_ref ), sizeof( __u8 [5] ) );
	swigStructField( "v4l2_ctrl_vp9_compressed_hdr-comp_mode", offsetof( struct v4l2_ctrl_vp9_compressed_hdr, comp_mode ), sizeof( __u8 [5] ) );
	swigStructField( "v4l2_ctrl_vp9_compressed_hdr-skip", offsetof( struct v4l2_ctrl_vp9_compressed_hdr, skip ), sizeof( __u8 [3] ) );
	swigStructField( "v4l2_ctrl_vp9_compressed_hdr-tx8", offsetof( struct v4l2_ctrl_vp9_compressed_hdr, tx8 ), sizeof( __u8 [2][1] ) );
	swigStructField( "v4l2_ctrl_vp9_compressed_hdr-partition", offsetof( struct v4l2_ctrl_vp9_compressed_hdr, partition ), sizeof( __u8 [16][3] ) );
	swigStructField( "v4l2_ctrl_vp9_compressed_hdr-inter_mode", offsetof( struct v4l2_ctrl_vp9_compressed_hdr, inter_mode ), sizeof( __u8 [7][3] ) );
	swigStructField( "v4l2_ctrl_vp9_compressed_hdr-tx32", offsetof( struct v4l2_ctrl_vp9_compressed_hdr, tx32 ), sizeof( __u8 [2][3] ) );
	swigStructField( "v4l2_ctrl_vp9_compressed_hdr-coef", offsetof( struct v4l2_ctrl_vp9_compressed_hdr, coef ), sizeof( __u8 [4][2][2][6][6][3] ) );
	swigStructField( "v4l2_ctrl_vp9_compressed_hdr-single_ref", offsetof( struct v4l2_ctrl_vp9_compressed_hdr, single_ref ), sizeof( __u8 [5][2] ) );
	swigStructField( "v4l2_ctrl_vp9_compressed_hdr-interp_filter", offsetof( struct v4l2_ctrl_vp9_compressed_hdr, interp_filter ), sizeof( __u8 [4][2] ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_ctrl_vp9_compressed_hdr ) );

	swigComment("struct v4l2_mbus_framefmt\n");
	printf( "begin-structure v4l2_mbus_framefmt\n" );
	swigStructField( "v4l2_mbus_framefmt-field", offsetof( struct v4l2_mbus_framefmt, field ), sizeof( __u32 ) );
	swigStructField( "v4l2_mbus_framefmt-reserved", offsetof( struct v4l2_mbus_framefmt, reserved ), sizeof( __u16 [10] ) );
	swigStructField( "v4l2_mbus_framefmt-code", offsetof( struct v4l2_mbus_framefmt, code ), sizeof( __u32 ) );
	swigStructField( "v4l2_mbus_framefmt-hsv_enc", offsetof( struct v4l2_mbus_framefmt, hsv_enc ), sizeof( __u16 ) );
	swigStructField( "v4l2_mbus_framefmt-xfer_func", offsetof( struct v4l2_mbus_framefmt, xfer_func ), sizeof( __u16 ) );
	swigStructField( "v4l2_mbus_framefmt-height", offsetof( struct v4l2_mbus_framefmt, height ), sizeof( __u32 ) );
	swigStructField( "v4l2_mbus_framefmt-colorspace", offsetof( struct v4l2_mbus_framefmt, colorspace ), sizeof( __u32 ) );
	swigStructField( "v4l2_mbus_framefmt-ycbcr_enc", offsetof( struct v4l2_mbus_framefmt, ycbcr_enc ), sizeof( __u16 ) );
	swigStructField( "v4l2_mbus_framefmt-quantization", offsetof( struct v4l2_mbus_framefmt, quantization ), sizeof( __u16 ) );
	swigStructField( "v4l2_mbus_framefmt-width", offsetof( struct v4l2_mbus_framefmt, width ), sizeof( __u32 ) );
	swigStructField( "v4l2_mbus_framefmt-flags", offsetof( struct v4l2_mbus_framefmt, flags ), sizeof( __u16 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_mbus_framefmt ) );

	swigComment("struct v4l2_subdev_format\n");
	printf( "begin-structure v4l2_subdev_format\n" );
	swigStructField( "v4l2_subdev_format-reserved", offsetof( struct v4l2_subdev_format, reserved ), sizeof( __u32 [8] ) );
	swigStructField( "v4l2_subdev_format-which", offsetof( struct v4l2_subdev_format, which ), sizeof( __u32 ) );
	swigStructField( "v4l2_subdev_format-pad", offsetof( struct v4l2_subdev_format, pad ), sizeof( __u32 ) );
	swigStructField( "v4l2_subdev_format-format", offsetof( struct v4l2_subdev_format, format ), sizeof( struct v4l2_mbus_framefmt ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_subdev_format ) );

	swigComment("struct v4l2_subdev_crop\n");
	printf( "begin-structure v4l2_subdev_crop\n" );
	swigStructField( "v4l2_subdev_crop-reserved", offsetof( struct v4l2_subdev_crop, reserved ), sizeof( __u32 [8] ) );
	swigStructField( "v4l2_subdev_crop-which", offsetof( struct v4l2_subdev_crop, which ), sizeof( __u32 ) );
	swigStructField( "v4l2_subdev_crop-rect", offsetof( struct v4l2_subdev_crop, rect ), sizeof( struct v4l2_rect ) );
	swigStructField( "v4l2_subdev_crop-pad", offsetof( struct v4l2_subdev_crop, pad ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_subdev_crop ) );

	swigComment("struct v4l2_subdev_mbus_code_enum\n");
	printf( "begin-structure v4l2_subdev_mbus_code_enum\n" );
	swigStructField( "v4l2_subdev_mbus_code_enum-index", offsetof( struct v4l2_subdev_mbus_code_enum, index ), sizeof( __u32 ) );
	swigStructField( "v4l2_subdev_mbus_code_enum-reserved", offsetof( struct v4l2_subdev_mbus_code_enum, reserved ), sizeof( __u32 [7] ) );
	swigStructField( "v4l2_subdev_mbus_code_enum-which", offsetof( struct v4l2_subdev_mbus_code_enum, which ), sizeof( __u32 ) );
	swigStructField( "v4l2_subdev_mbus_code_enum-code", offsetof( struct v4l2_subdev_mbus_code_enum, code ), sizeof( __u32 ) );
	swigStructField( "v4l2_subdev_mbus_code_enum-pad", offsetof( struct v4l2_subdev_mbus_code_enum, pad ), sizeof( __u32 ) );
	swigStructField( "v4l2_subdev_mbus_code_enum-flags", offsetof( struct v4l2_subdev_mbus_code_enum, flags ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_subdev_mbus_code_enum ) );

	swigComment("struct v4l2_subdev_frame_size_enum\n");
	printf( "begin-structure v4l2_subdev_frame_size_enum\n" );
	swigStructField( "v4l2_subdev_frame_size_enum-index", offsetof( struct v4l2_subdev_frame_size_enum, index ), sizeof( __u32 ) );
	swigStructField( "v4l2_subdev_frame_size_enum-reserved", offsetof( struct v4l2_subdev_frame_size_enum, reserved ), sizeof( __u32 [8] ) );
	swigStructField( "v4l2_subdev_frame_size_enum-which", offsetof( struct v4l2_subdev_frame_size_enum, which ), sizeof( __u32 ) );
	swigStructField( "v4l2_subdev_frame_size_enum-code", offsetof( struct v4l2_subdev_frame_size_enum, code ), sizeof( __u32 ) );
	swigStructField( "v4l2_subdev_frame_size_enum-min_height", offsetof( struct v4l2_subdev_frame_size_enum, min_height ), sizeof( __u32 ) );
	swigStructField( "v4l2_subdev_frame_size_enum-max_height", offsetof( struct v4l2_subdev_frame_size_enum, max_height ), sizeof( __u32 ) );
	swigStructField( "v4l2_subdev_frame_size_enum-min_width", offsetof( struct v4l2_subdev_frame_size_enum, min_width ), sizeof( __u32 ) );
	swigStructField( "v4l2_subdev_frame_size_enum-max_width", offsetof( struct v4l2_subdev_frame_size_enum, max_width ), sizeof( __u32 ) );
	swigStructField( "v4l2_subdev_frame_size_enum-pad", offsetof( struct v4l2_subdev_frame_size_enum, pad ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_subdev_frame_size_enum ) );

	swigComment("struct v4l2_subdev_frame_interval\n");
	printf( "begin-structure v4l2_subdev_frame_interval\n" );
	swigStructField( "v4l2_subdev_frame_interval-reserved", offsetof( struct v4l2_subdev_frame_interval, reserved ), sizeof( __u32 [9] ) );
	swigStructField( "v4l2_subdev_frame_interval-interval", offsetof( struct v4l2_subdev_frame_interval, interval ), sizeof( struct v4l2_fract ) );
	swigStructField( "v4l2_subdev_frame_interval-pad", offsetof( struct v4l2_subdev_frame_interval, pad ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_subdev_frame_interval ) );

	swigComment("struct v4l2_subdev_frame_interval_enum\n");
	printf( "begin-structure v4l2_subdev_frame_interval_enum\n" );
	swigStructField( "v4l2_subdev_frame_interval_enum-index", offsetof( struct v4l2_subdev_frame_interval_enum, index ), sizeof( __u32 ) );
	swigStructField( "v4l2_subdev_frame_interval_enum-reserved", offsetof( struct v4l2_subdev_frame_interval_enum, reserved ), sizeof( __u32 [8] ) );
	swigStructField( "v4l2_subdev_frame_interval_enum-which", offsetof( struct v4l2_subdev_frame_interval_enum, which ), sizeof( __u32 ) );
	swigStructField( "v4l2_subdev_frame_interval_enum-code", offsetof( struct v4l2_subdev_frame_interval_enum, code ), sizeof( __u32 ) );
	swigStructField( "v4l2_subdev_frame_interval_enum-interval", offsetof( struct v4l2_subdev_frame_interval_enum, interval ), sizeof( struct v4l2_fract ) );
	swigStructField( "v4l2_subdev_frame_interval_enum-height", offsetof( struct v4l2_subdev_frame_interval_enum, height ), sizeof( __u32 ) );
	swigStructField( "v4l2_subdev_frame_interval_enum-pad", offsetof( struct v4l2_subdev_frame_interval_enum, pad ), sizeof( __u32 ) );
	swigStructField( "v4l2_subdev_frame_interval_enum-width", offsetof( struct v4l2_subdev_frame_interval_enum, width ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_subdev_frame_interval_enum ) );

	swigComment("struct v4l2_subdev_selection\n");
	printf( "begin-structure v4l2_subdev_selection\n" );
	swigStructField( "v4l2_subdev_selection-reserved", offsetof( struct v4l2_subdev_selection, reserved ), sizeof( __u32 [8] ) );
	swigStructField( "v4l2_subdev_selection-which", offsetof( struct v4l2_subdev_selection, which ), sizeof( __u32 ) );
	swigStructField( "v4l2_subdev_selection-target", offsetof( struct v4l2_subdev_selection, target ), sizeof( __u32 ) );
	swigStructField( "v4l2_subdev_selection-r", offsetof( struct v4l2_subdev_selection, r ), sizeof( struct v4l2_rect ) );
	swigStructField( "v4l2_subdev_selection-pad", offsetof( struct v4l2_subdev_selection, pad ), sizeof( __u32 ) );
	swigStructField( "v4l2_subdev_selection-flags", offsetof( struct v4l2_subdev_selection, flags ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_subdev_selection ) );

	swigComment("struct v4l2_subdev_capability\n");
	printf( "begin-structure v4l2_subdev_capability\n" );
	swigStructField( "v4l2_subdev_capability-capabilities", offsetof( struct v4l2_subdev_capability, capabilities ), sizeof( __u32 ) );
	swigStructField( "v4l2_subdev_capability-reserved", offsetof( struct v4l2_subdev_capability, reserved ), sizeof( __u32 [14] ) );
	swigStructField( "v4l2_subdev_capability-version", offsetof( struct v4l2_subdev_capability, version ), sizeof( __u32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct v4l2_subdev_capability ) );

	swigNewline();

	swigComment("------===< functions >===-------\n");
	swigFunction( "\\ c-function v4l2_timeval_to_ns v4l2_timeval_to_ns a -- n", "FUNCTION: v4l2_timeval_to_ns ( tv -- n )", "EXTERN: \"C\" long v4l2_timeval_to_ns( void * tv );", "	( tv -- )" );
	
	return 0;
} /* end of main */



