/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 3.0.9
 *
 * This file is not intended to be easily readable and contains a number of
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG
 * interface file instead.
 * ----------------------------------------------------------------------------- */
#include <stdio.h>
#include <string.h>
#include <stddef.h>

// Do not edit below this line
// end-of-default-includes


#include <linux/i2c.h>
#include <linux/i2c-dev.h>
#ifdef __gnu_linux__
#undef stderr
extern struct _IO_FILE *stderr;
#endif

typedef enum{ NONE = -1, GFORTH = 0, SWIFTFORTH, VFX } SwigTargetSystem;
SwigTargetSystem swigTargetSystem = NONE;

unsigned char swigPrintStackComments = 1;

/* comments */
void swigNewline()
{
	printf( "\n" );
}

void swigComment( char *comment )
{
	printf( "\\ %s", comment );
}

/* generic print */
void swigPrint( char* gforth, char *swiftForth, char *vfx )
{
	if( swigTargetSystem == GFORTH )
		printf( "%s", gforth );
	else if( swigTargetSystem == SWIFTFORTH )
		printf( "%s", swiftForth );
	else if( swigTargetSystem == VFX )
		printf( "%s", vfx );
	printf( "\n" );
}
void swigPrintSystem( SwigTargetSystem targetSystem, char *text )
{
	if( targetSystem == swigTargetSystem )
	    printf( "%s\n", text );
}

/* constants */
void swigIntConstant( long constant, char *name )
{
	printf( "#%ld\tconstant %s\n", constant, name );
}

void swigUnsignedIntConstant( unsigned long constant, char *name )
{
	printf( "#%lu\tconstant %s\n", constant, name );
}

void swigLongConstant( long long constant, char *name )
{
	printf( "#%lld.\t2constant %s\n", constant, name );
}

void swigUnsignedLongConstant( unsigned long long constant, char *name )
{
	printf( "#%llu.\t2constant %s\n", constant, name );
}

void swigFloatConstant( double constant, char *name )
{
	char buffer[128];
	sprintf( buffer, "%f", constant );

	/* if the constant contains no exponent, add one */
	char *s;
	for( s = buffer; *s != 0; s++ )
		if( *s == 'e' || *s == 'E' )
			break;

	/* exponent found */
	if( *s != 0 )
		printf( "%s\tfconstant %s\n", buffer, name );
	/* not found */
	else
		printf( "%se0\tfconstant %s\n", buffer, name );
}

void swigStringConstant( char* constant, char *name )
{
	char c;
	printf( ": %s s\\\" ", name );
	while(( c = *constant++ ))
	{
		switch(c)
		{
			case '\b': printf( "\\b" ); break;
			case '\n': printf( "\\n" ); break;
			case '\f': printf( "\\f" ); break;
			case '\r': printf( "\\r" ); break;
			case '\t': printf( "\\t" ); break;
			case '"' : printf( "\\q" ); break;
			default:
				if(c < 0x20)
					printf("\\x%02x", c);
				else
					printf("%c", c); break;
		}
	}
	printf(	"\" ;\n" );
}

/* structs */
void swigStructField( char *name, size_t offset, size_t size )
{
	printf( "\tdrop %zu %zu +field %s\n", offset, size, name );
}

/* functions */
void swigFunction( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	if( swigTargetSystem == GFORTH )
		printf( "%s", gforth );
	else if( swigTargetSystem == SWIFTFORTH )
		printf( "%s", swiftForth );
	else if( swigTargetSystem == VFX )
		printf( "%s", vfx );

	if( swigPrintStackComments )
		printf( "%s", stackComment );

	printf( "\n" );
}

/* function pointers */
void swigFunctionPointer( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	swigFunction( gforth, swiftForth, vfx, stackComment );
}

/* callbacks */
void swigCallback( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	swigFunction( gforth, swiftForth, vfx, stackComment );
}

void swigUsage( char **argv )
{
	fprintf( stderr, "Usage: %s [-gforth|-swiftforth|-vfx]\n", argv[0] );
}

int main( int argc, char **argv )
{
	int i;

	/* check arguments */
	for( i = 1; i < argc; i++ )
		if( strcmp( argv[i], "-gforth" ) == 0 )
			swigTargetSystem = GFORTH;
		else if( strcmp( argv[i], "-swiftforth" ) == 0 )
			swigTargetSystem = SWIFTFORTH;
		else if( strcmp( argv[i], "-vfx" ) == 0 )
			swigTargetSystem = VFX;

	if( swigTargetSystem == NONE )
	{
		fprintf( stderr, "Error: no target system specified\n" );
		swigUsage( argv );
		return 1;
	}

	/* primer */
	printf( "\\ This file has been generated using SWIG and fsi,\n"
		"\\ and is already platform dependent, search for the corresponding\n"
		"\\ fsi-file to compile it where no one has compiled it before ;)\n"
		"\\ Forth systems have their own own dynamic loader and don't need addional C-Code.\n"
		"\\ That's why this file will just print normal forth-code once compiled\n"
		"\\ and can be used directly with include or require.\n"
		"\\ As all comments are stripped during the compilation, please\n"
		"\\ insert the copyright notice of the original file here.\n"
	);



	swigNewline();

	swigComment("----===< int constants >===-----\n");
	#ifdef I2C_M_RD
		swigIntConstant( I2C_M_RD, "I2C_M_RD" );
	#endif
	#ifdef I2C_M_TEN
		swigIntConstant( I2C_M_TEN, "I2C_M_TEN" );
	#endif
	#ifdef I2C_M_DMA_SAFE
		swigIntConstant( I2C_M_DMA_SAFE, "I2C_M_DMA_SAFE" );
	#endif
	#ifdef I2C_M_RECV_LEN
		swigIntConstant( I2C_M_RECV_LEN, "I2C_M_RECV_LEN" );
	#endif
	#ifdef I2C_M_NO_RD_ACK
		swigIntConstant( I2C_M_NO_RD_ACK, "I2C_M_NO_RD_ACK" );
	#endif
	#ifdef I2C_M_IGNORE_NAK
		swigIntConstant( I2C_M_IGNORE_NAK, "I2C_M_IGNORE_NAK" );
	#endif
	#ifdef I2C_M_REV_DIR_ADDR
		swigIntConstant( I2C_M_REV_DIR_ADDR, "I2C_M_REV_DIR_ADDR" );
	#endif
	#ifdef I2C_M_NOSTART
		swigIntConstant( I2C_M_NOSTART, "I2C_M_NOSTART" );
	#endif
	#ifdef I2C_M_STOP
		swigIntConstant( I2C_M_STOP, "I2C_M_STOP" );
	#endif
	#ifdef I2C_FUNC_I2C
		swigIntConstant( I2C_FUNC_I2C, "I2C_FUNC_I2C" );
	#endif
	#ifdef I2C_FUNC_10BIT_ADDR
		swigIntConstant( I2C_FUNC_10BIT_ADDR, "I2C_FUNC_10BIT_ADDR" );
	#endif
	#ifdef I2C_FUNC_PROTOCOL_MANGLING
		swigIntConstant( I2C_FUNC_PROTOCOL_MANGLING, "I2C_FUNC_PROTOCOL_MANGLING" );
	#endif
	#ifdef I2C_FUNC_SMBUS_PEC
		swigIntConstant( I2C_FUNC_SMBUS_PEC, "I2C_FUNC_SMBUS_PEC" );
	#endif
	#ifdef I2C_FUNC_NOSTART
		swigIntConstant( I2C_FUNC_NOSTART, "I2C_FUNC_NOSTART" );
	#endif
	#ifdef I2C_FUNC_SLAVE
		swigIntConstant( I2C_FUNC_SLAVE, "I2C_FUNC_SLAVE" );
	#endif
	#ifdef I2C_FUNC_SMBUS_BLOCK_PROC_CALL
		swigIntConstant( I2C_FUNC_SMBUS_BLOCK_PROC_CALL, "I2C_FUNC_SMBUS_BLOCK_PROC_CALL" );
	#endif
	#ifdef I2C_FUNC_SMBUS_QUICK
		swigIntConstant( I2C_FUNC_SMBUS_QUICK, "I2C_FUNC_SMBUS_QUICK" );
	#endif
	#ifdef I2C_FUNC_SMBUS_READ_BYTE
		swigIntConstant( I2C_FUNC_SMBUS_READ_BYTE, "I2C_FUNC_SMBUS_READ_BYTE" );
	#endif
	#ifdef I2C_FUNC_SMBUS_WRITE_BYTE
		swigIntConstant( I2C_FUNC_SMBUS_WRITE_BYTE, "I2C_FUNC_SMBUS_WRITE_BYTE" );
	#endif
	#ifdef I2C_FUNC_SMBUS_READ_BYTE_DATA
		swigIntConstant( I2C_FUNC_SMBUS_READ_BYTE_DATA, "I2C_FUNC_SMBUS_READ_BYTE_DATA" );
	#endif
	#ifdef I2C_FUNC_SMBUS_WRITE_BYTE_DATA
		swigIntConstant( I2C_FUNC_SMBUS_WRITE_BYTE_DATA, "I2C_FUNC_SMBUS_WRITE_BYTE_DATA" );
	#endif
	#ifdef I2C_FUNC_SMBUS_READ_WORD_DATA
		swigIntConstant( I2C_FUNC_SMBUS_READ_WORD_DATA, "I2C_FUNC_SMBUS_READ_WORD_DATA" );
	#endif
	#ifdef I2C_FUNC_SMBUS_WRITE_WORD_DATA
		swigIntConstant( I2C_FUNC_SMBUS_WRITE_WORD_DATA, "I2C_FUNC_SMBUS_WRITE_WORD_DATA" );
	#endif
	#ifdef I2C_FUNC_SMBUS_PROC_CALL
		swigIntConstant( I2C_FUNC_SMBUS_PROC_CALL, "I2C_FUNC_SMBUS_PROC_CALL" );
	#endif
	#ifdef I2C_FUNC_SMBUS_READ_BLOCK_DATA
		swigIntConstant( I2C_FUNC_SMBUS_READ_BLOCK_DATA, "I2C_FUNC_SMBUS_READ_BLOCK_DATA" );
	#endif
	#ifdef I2C_FUNC_SMBUS_WRITE_BLOCK_DATA
		swigIntConstant( I2C_FUNC_SMBUS_WRITE_BLOCK_DATA, "I2C_FUNC_SMBUS_WRITE_BLOCK_DATA" );
	#endif
	#ifdef I2C_FUNC_SMBUS_READ_I2C_BLOCK
		swigIntConstant( I2C_FUNC_SMBUS_READ_I2C_BLOCK, "I2C_FUNC_SMBUS_READ_I2C_BLOCK" );
	#endif
	#ifdef I2C_FUNC_SMBUS_WRITE_I2C_BLOCK
		swigIntConstant( I2C_FUNC_SMBUS_WRITE_I2C_BLOCK, "I2C_FUNC_SMBUS_WRITE_I2C_BLOCK" );
	#endif
	#ifdef I2C_FUNC_SMBUS_HOST_NOTIFY
		swigIntConstant( I2C_FUNC_SMBUS_HOST_NOTIFY, "I2C_FUNC_SMBUS_HOST_NOTIFY" );
	#endif
	#ifdef I2C_FUNC_SMBUS_BYTE
		swigIntConstant( I2C_FUNC_SMBUS_BYTE, "I2C_FUNC_SMBUS_BYTE" );
	#endif
	#ifdef I2C_FUNC_SMBUS_BYTE_DATA
		swigIntConstant( I2C_FUNC_SMBUS_BYTE_DATA, "I2C_FUNC_SMBUS_BYTE_DATA" );
	#endif
	#ifdef I2C_FUNC_SMBUS_WORD_DATA
		swigIntConstant( I2C_FUNC_SMBUS_WORD_DATA, "I2C_FUNC_SMBUS_WORD_DATA" );
	#endif
	#ifdef I2C_FUNC_SMBUS_BLOCK_DATA
		swigIntConstant( I2C_FUNC_SMBUS_BLOCK_DATA, "I2C_FUNC_SMBUS_BLOCK_DATA" );
	#endif
	#ifdef I2C_FUNC_SMBUS_I2C_BLOCK
		swigIntConstant( I2C_FUNC_SMBUS_I2C_BLOCK, "I2C_FUNC_SMBUS_I2C_BLOCK" );
	#endif
	#ifdef I2C_FUNC_SMBUS_EMUL
		swigIntConstant( I2C_FUNC_SMBUS_EMUL, "I2C_FUNC_SMBUS_EMUL" );
	#endif
	#ifdef I2C_FUNC_SMBUS_EMUL_ALL
		swigIntConstant( I2C_FUNC_SMBUS_EMUL_ALL, "I2C_FUNC_SMBUS_EMUL_ALL" );
	#endif
	#ifdef I2C_SMBUS_BLOCK_MAX
		swigIntConstant( I2C_SMBUS_BLOCK_MAX, "I2C_SMBUS_BLOCK_MAX" );
	#endif
	#ifdef I2C_SMBUS_READ
		swigIntConstant( I2C_SMBUS_READ, "I2C_SMBUS_READ" );
	#endif
	#ifdef I2C_SMBUS_WRITE
		swigIntConstant( I2C_SMBUS_WRITE, "I2C_SMBUS_WRITE" );
	#endif
	#ifdef I2C_SMBUS_QUICK
		swigIntConstant( I2C_SMBUS_QUICK, "I2C_SMBUS_QUICK" );
	#endif
	#ifdef I2C_SMBUS_BYTE
		swigIntConstant( I2C_SMBUS_BYTE, "I2C_SMBUS_BYTE" );
	#endif
	#ifdef I2C_SMBUS_BYTE_DATA
		swigIntConstant( I2C_SMBUS_BYTE_DATA, "I2C_SMBUS_BYTE_DATA" );
	#endif
	#ifdef I2C_SMBUS_WORD_DATA
		swigIntConstant( I2C_SMBUS_WORD_DATA, "I2C_SMBUS_WORD_DATA" );
	#endif
	#ifdef I2C_SMBUS_PROC_CALL
		swigIntConstant( I2C_SMBUS_PROC_CALL, "I2C_SMBUS_PROC_CALL" );
	#endif
	#ifdef I2C_SMBUS_BLOCK_DATA
		swigIntConstant( I2C_SMBUS_BLOCK_DATA, "I2C_SMBUS_BLOCK_DATA" );
	#endif
	#ifdef I2C_SMBUS_I2C_BLOCK_BROKEN
		swigIntConstant( I2C_SMBUS_I2C_BLOCK_BROKEN, "I2C_SMBUS_I2C_BLOCK_BROKEN" );
	#endif
	#ifdef I2C_SMBUS_BLOCK_PROC_CALL
		swigIntConstant( I2C_SMBUS_BLOCK_PROC_CALL, "I2C_SMBUS_BLOCK_PROC_CALL" );
	#endif
	#ifdef I2C_SMBUS_I2C_BLOCK_DATA
		swigIntConstant( I2C_SMBUS_I2C_BLOCK_DATA, "I2C_SMBUS_I2C_BLOCK_DATA" );
	#endif
	#ifdef I2C_RETRIES
		swigIntConstant( I2C_RETRIES, "I2C_RETRIES" );
	#endif
	#ifdef I2C_TIMEOUT
		swigIntConstant( I2C_TIMEOUT, "I2C_TIMEOUT" );
	#endif
	#ifdef I2C_SLAVE
		swigIntConstant( I2C_SLAVE, "I2C_SLAVE" );
	#endif
	#ifdef I2C_SLAVE_FORCE
		swigIntConstant( I2C_SLAVE_FORCE, "I2C_SLAVE_FORCE" );
	#endif
	#ifdef I2C_TENBIT
		swigIntConstant( I2C_TENBIT, "I2C_TENBIT" );
	#endif
	#ifdef I2C_FUNCS
		swigIntConstant( I2C_FUNCS, "I2C_FUNCS" );
	#endif
	#ifdef I2C_RDWR
		swigIntConstant( I2C_RDWR, "I2C_RDWR" );
	#endif
	#ifdef I2C_PEC
		swigIntConstant( I2C_PEC, "I2C_PEC" );
	#endif
	#ifdef I2C_SMBUS
		swigIntConstant( I2C_SMBUS, "I2C_SMBUS" );
	#endif
	#ifdef I2C_RDWR_IOCTL_MAX_MSGS
		swigIntConstant( I2C_RDWR_IOCTL_MAX_MSGS, "I2C_RDWR_IOCTL_MAX_MSGS" );
	#endif
	#ifdef I2C_RDRW_IOCTL_MAX_MSGS
		swigIntConstant( I2C_RDRW_IOCTL_MAX_MSGS, "I2C_RDRW_IOCTL_MAX_MSGS" );
	#endif

	swigNewline();

	swigComment("-------===< structs >===--------\n");

	swigComment("struct i2c_msg\n");
	printf( "begin-structure i2c_msg\n" );
	swigStructField( "i2c_msg-len", offsetof( struct i2c_msg, len ), sizeof( __u16 ) );
	swigStructField( "i2c_msg-buf", offsetof( struct i2c_msg, buf ), sizeof( __u8 * ) );
	swigStructField( "i2c_msg-flags", offsetof( struct i2c_msg, flags ), sizeof( __u16 ) );
	swigStructField( "i2c_msg-addr", offsetof( struct i2c_msg, addr ), sizeof( __u16 ) );
	printf( "drop %zu end-structure\n", sizeof( struct i2c_msg ) );

	swigComment("union i2c_smbus_data\n");
	printf( "begin-structure i2c_smbus_data\n" );
	swigStructField( "i2c_smbus_data-block", offsetof( union i2c_smbus_data, block ), sizeof( __u8 [32+2] ) );
	swigStructField( "i2c_smbus_data-word", offsetof( union i2c_smbus_data, word ), sizeof( __u16 ) );
	swigStructField( "i2c_smbus_data-byte", offsetof( union i2c_smbus_data, byte ), sizeof( __u8 ) );
	printf( "drop %zu end-structure\n", sizeof( union i2c_smbus_data ) );

	swigComment("struct i2c_smbus_ioctl_data\n");
	printf( "begin-structure i2c_smbus_ioctl_data\n" );
	swigStructField( "i2c_smbus_ioctl_data-command", offsetof( struct i2c_smbus_ioctl_data, command ), sizeof( __u8 ) );
	swigStructField( "i2c_smbus_ioctl_data-data", offsetof( struct i2c_smbus_ioctl_data, data ), sizeof( union i2c_smbus_data * ) );
	swigStructField( "i2c_smbus_ioctl_data-size", offsetof( struct i2c_smbus_ioctl_data, size ), sizeof( __u32 ) );
	swigStructField( "i2c_smbus_ioctl_data-read_write", offsetof( struct i2c_smbus_ioctl_data, read_write ), sizeof( __u8 ) );
	printf( "drop %zu end-structure\n", sizeof( struct i2c_smbus_ioctl_data ) );

	swigComment("struct i2c_rdwr_ioctl_data\n");
	printf( "begin-structure i2c_rdwr_ioctl_data\n" );
	swigStructField( "i2c_rdwr_ioctl_data-nmsgs", offsetof( struct i2c_rdwr_ioctl_data, nmsgs ), sizeof( __u32 ) );
	swigStructField( "i2c_rdwr_ioctl_data-msgs", offsetof( struct i2c_rdwr_ioctl_data, msgs ), sizeof( struct i2c_msg * ) );
	printf( "drop %zu end-structure\n", sizeof( struct i2c_rdwr_ioctl_data ) );
	
	return 0;
} /* end of main */



