/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 3.0.9
 *
 * This file is not intended to be easily readable and contains a number of
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG
 * interface file instead.
 * ----------------------------------------------------------------------------- */
#include <stdio.h>
#include <string.h>
#include <stddef.h>

// Do not edit below this line
// end-of-default-includes


#include <SDL2/SDL.h>
#ifdef __gnu_linux__
#undef stderr
extern struct _IO_FILE *stderr;
#endif

typedef enum{ NONE = -1, GFORTH = 0, SWIFTFORTH, VFX } SwigTargetSystem;
SwigTargetSystem swigTargetSystem = NONE;

unsigned char swigPrintStackComments = 1;

/* comments */
void swigNewline()
{
	printf( "\n" );
}

void swigComment( char *comment )
{
	printf( "\\ %s", comment );
}

/* generic print */
void swigPrint( char* gforth, char *swiftForth, char *vfx )
{
	if( swigTargetSystem == GFORTH )
		printf( "%s", gforth );
	else if( swigTargetSystem == SWIFTFORTH )
		printf( "%s", swiftForth );
	else if( swigTargetSystem == VFX )
		printf( "%s", vfx );
	printf( "\n" );
}
void swigPrintSystem( SwigTargetSystem targetSystem, char *text )
{
	if( targetSystem == swigTargetSystem )
	    printf( "%s\n", text );
}

/* constants */
void swigIntConstant( long constant, char *name )
{
	printf( "#%ld\tconstant %s\n", constant, name );
}

void swigUnsignedIntConstant( unsigned long constant, char *name )
{
	printf( "#%lu\tconstant %s\n", constant, name );
}

void swigLongConstant( long long constant, char *name )
{
	printf( "#%lld.\t2constant %s\n", constant, name );
}

void swigUnsignedLongConstant( unsigned long long constant, char *name )
{
	printf( "#%llu.\t2constant %s\n", constant, name );
}

void swigFloatConstant( double constant, char *name )
{
	char buffer[128];
	sprintf( buffer, "%f", constant );

	/* if the constant contains no exponent, add one */
	char *s;
	for( s = buffer; *s != 0; s++ )
		if( *s == 'e' || *s == 'E' )
			break;

	/* exponent found */
	if( *s != 0 )
		printf( "%s\tfconstant %s\n", buffer, name );
	/* not found */
	else
		printf( "%se0\tfconstant %s\n", buffer, name );
}

void swigStringConstant( char* constant, char *name )
{
	char c;
	printf( ": %s s\\\" ", name );
	while(( c = *constant++ ))
	{
		switch(c)
		{
			case '\b': printf( "\\b" ); break;
			case '\n': printf( "\\n" ); break;
			case '\f': printf( "\\f" ); break;
			case '\r': printf( "\\r" ); break;
			case '\t': printf( "\\t" ); break;
			case '"' : printf( "\\q" ); break;
			default:
				if(c < 0x20)
					printf("\\x%02x", c);
				else
					printf("%c", c); break;
		}
	}
	printf(	"\" ;\n" );
}

/* structs */
void swigStructField( char *name, size_t offset, size_t size )
{
	printf( "\tdrop %zu %zu +field %s\n", offset, size, name );
}

/* functions */
void swigFunction( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	if( swigTargetSystem == GFORTH )
		printf( "%s", gforth );
	else if( swigTargetSystem == SWIFTFORTH )
		printf( "%s", swiftForth );
	else if( swigTargetSystem == VFX )
		printf( "%s", vfx );

	if( swigPrintStackComments )
		printf( "%s", stackComment );

	printf( "\n" );
}

/* function pointers */
void swigFunctionPointer( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	swigFunction( gforth, swiftForth, vfx, stackComment );
}

/* callbacks */
void swigCallback( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	swigFunction( gforth, swiftForth, vfx, stackComment );
}

void swigUsage( char **argv )
{
	fprintf( stderr, "Usage: %s [-gforth|-swiftforth|-vfx]\n", argv[0] );
}

int main( int argc, char **argv )
{
	int i;

	/* check arguments */
	for( i = 1; i < argc; i++ )
		if( strcmp( argv[i], "-gforth" ) == 0 )
			swigTargetSystem = GFORTH;
		else if( strcmp( argv[i], "-swiftforth" ) == 0 )
			swigTargetSystem = SWIFTFORTH;
		else if( strcmp( argv[i], "-vfx" ) == 0 )
			swigTargetSystem = VFX;

	if( swigTargetSystem == NONE )
	{
		fprintf( stderr, "Error: no target system specified\n" );
		swigUsage( argv );
		return 1;
	}

	/* primer */
	printf( "\\ This file has been generated using SWIG and fsi,\n"
		"\\ and is already platform dependent, search for the corresponding\n"
		"\\ fsi-file to compile it where no one has compiled it before ;)\n"
		"\\ Forth systems have their own own dynamic loader and don't need addional C-Code.\n"
		"\\ That's why this file will just print normal forth-code once compiled\n"
		"\\ and can be used directly with include or require.\n"
		"\\ As all comments are stripped during the compilation, please\n"
		"\\ insert the copyright notice of the original file here.\n"
	);


typedef union {
  struct         {
    Uint8 *base;
    Uint8 *here;
    Uint8 *stop;
  } mem;
  struct         {
    void *data1;
    void *data2;
  } unknown;
} SDL_RWops_hidden;

typedef struct {
  Uint8 *base;
  Uint8 *here;
  Uint8 *stop;
} SDL_RWops_hidden_mem;

typedef struct {
  void *data1;
  void *data2;
} SDL_RWops_hidden_unknown;


	swigNewline();

	swigComment("----===< prefix >===-----\n");

	swigPrint( "c-library SDL\ns\" SDL\" add-lib\n\\c #include <SDL2/SDL.h>\n\\c #ifdef __gnu_linux__\n\\c #undef stderr\n\\c extern struct _IO_FILE *stderr;\n\\c #endif", "( none )", "( none )" );

	swigNewline();

	swigComment("----===< int constants >===-----\n");
	#ifdef SDL_ASSERT_LEVEL
		swigIntConstant( SDL_ASSERT_LEVEL, "SDL_ASSERT_LEVEL" );
	#endif
	#ifdef SDL_LINE
		swigIntConstant( SDL_LINE, "SDL_LINE" );
	#endif
	#ifdef SDL_NULL_WHILE_LOOP_CONDITION
		swigIntConstant( SDL_NULL_WHILE_LOOP_CONDITION, "SDL_NULL_WHILE_LOOP_CONDITION" );
	#endif
	#ifdef SDL_AUDIO_MASK_BITSIZE
		swigIntConstant( SDL_AUDIO_MASK_BITSIZE, "SDL_AUDIO_MASK_BITSIZE" );
	#endif
	#ifdef SDL_AUDIO_MASK_DATATYPE
		swigIntConstant( SDL_AUDIO_MASK_DATATYPE, "SDL_AUDIO_MASK_DATATYPE" );
	#endif
	#ifdef SDL_AUDIO_MASK_ENDIAN
		swigIntConstant( SDL_AUDIO_MASK_ENDIAN, "SDL_AUDIO_MASK_ENDIAN" );
	#endif
	#ifdef SDL_AUDIO_MASK_SIGNED
		swigIntConstant( SDL_AUDIO_MASK_SIGNED, "SDL_AUDIO_MASK_SIGNED" );
	#endif
	#ifdef AUDIO_U8
		swigIntConstant( AUDIO_U8, "AUDIO_U8" );
	#endif
	#ifdef AUDIO_S8
		swigIntConstant( AUDIO_S8, "AUDIO_S8" );
	#endif
	#ifdef AUDIO_U16LSB
		swigIntConstant( AUDIO_U16LSB, "AUDIO_U16LSB" );
	#endif
	#ifdef AUDIO_S16LSB
		swigIntConstant( AUDIO_S16LSB, "AUDIO_S16LSB" );
	#endif
	#ifdef AUDIO_U16MSB
		swigIntConstant( AUDIO_U16MSB, "AUDIO_U16MSB" );
	#endif
	#ifdef AUDIO_S16MSB
		swigIntConstant( AUDIO_S16MSB, "AUDIO_S16MSB" );
	#endif
	#ifdef AUDIO_U16
		swigIntConstant( AUDIO_U16, "AUDIO_U16" );
	#endif
	#ifdef AUDIO_S16
		swigIntConstant( AUDIO_S16, "AUDIO_S16" );
	#endif
	#ifdef AUDIO_S32LSB
		swigIntConstant( AUDIO_S32LSB, "AUDIO_S32LSB" );
	#endif
	#ifdef AUDIO_S32MSB
		swigIntConstant( AUDIO_S32MSB, "AUDIO_S32MSB" );
	#endif
	#ifdef AUDIO_S32
		swigIntConstant( AUDIO_S32, "AUDIO_S32" );
	#endif
	#ifdef AUDIO_F32LSB
		swigIntConstant( AUDIO_F32LSB, "AUDIO_F32LSB" );
	#endif
	#ifdef AUDIO_F32MSB
		swigIntConstant( AUDIO_F32MSB, "AUDIO_F32MSB" );
	#endif
	#ifdef AUDIO_F32
		swigIntConstant( AUDIO_F32, "AUDIO_F32" );
	#endif
	#ifdef AUDIO_U16SYS
		swigIntConstant( AUDIO_U16SYS, "AUDIO_U16SYS" );
	#endif
	#ifdef AUDIO_S16SYS
		swigIntConstant( AUDIO_S16SYS, "AUDIO_S16SYS" );
	#endif
	#ifdef AUDIO_S32SYS
		swigIntConstant( AUDIO_S32SYS, "AUDIO_S32SYS" );
	#endif
	#ifdef AUDIO_F32SYS
		swigIntConstant( AUDIO_F32SYS, "AUDIO_F32SYS" );
	#endif
	#ifdef SDL_AUDIO_ALLOW_FREQUENCY_CHANGE
		swigIntConstant( SDL_AUDIO_ALLOW_FREQUENCY_CHANGE, "SDL_AUDIO_ALLOW_FREQUENCY_CHANGE" );
	#endif
	#ifdef SDL_AUDIO_ALLOW_FORMAT_CHANGE
		swigIntConstant( SDL_AUDIO_ALLOW_FORMAT_CHANGE, "SDL_AUDIO_ALLOW_FORMAT_CHANGE" );
	#endif
	#ifdef SDL_AUDIO_ALLOW_CHANNELS_CHANGE
		swigIntConstant( SDL_AUDIO_ALLOW_CHANNELS_CHANGE, "SDL_AUDIO_ALLOW_CHANNELS_CHANGE" );
	#endif
	#ifdef SDL_AUDIO_ALLOW_SAMPLES_CHANGE
		swigIntConstant( SDL_AUDIO_ALLOW_SAMPLES_CHANGE, "SDL_AUDIO_ALLOW_SAMPLES_CHANGE" );
	#endif
	#ifdef SDL_AUDIO_ALLOW_ANY_CHANGE
		swigIntConstant( SDL_AUDIO_ALLOW_ANY_CHANGE, "SDL_AUDIO_ALLOW_ANY_CHANGE" );
	#endif
	#ifdef SDL_AUDIOCVT_MAX_FILTERS
		swigIntConstant( SDL_AUDIOCVT_MAX_FILTERS, "SDL_AUDIOCVT_MAX_FILTERS" );
	#endif
	#ifdef SDL_MIX_MAXVOLUME
		swigIntConstant( SDL_MIX_MAXVOLUME, "SDL_MIX_MAXVOLUME" );
	#endif
	#ifdef SDL_CACHELINE_SIZE
		swigIntConstant( SDL_CACHELINE_SIZE, "SDL_CACHELINE_SIZE" );
	#endif
	#ifdef SDL_LIL_ENDIAN
		swigIntConstant( SDL_LIL_ENDIAN, "SDL_LIL_ENDIAN" );
	#endif
	#ifdef SDL_BIG_ENDIAN
		swigIntConstant( SDL_BIG_ENDIAN, "SDL_BIG_ENDIAN" );
	#endif
	#ifdef SDL_BYTEORDER
		swigIntConstant( SDL_BYTEORDER, "SDL_BYTEORDER" );
	#endif
	#ifdef HAS_BUILTIN_BSWAP16
		swigIntConstant( HAS_BUILTIN_BSWAP16, "HAS_BUILTIN_BSWAP16" );
	#endif
	#ifdef HAS_BUILTIN_BSWAP32
		swigIntConstant( HAS_BUILTIN_BSWAP32, "HAS_BUILTIN_BSWAP32" );
	#endif
	#ifdef HAS_BUILTIN_BSWAP64
		swigIntConstant( HAS_BUILTIN_BSWAP64, "HAS_BUILTIN_BSWAP64" );
	#endif
	#ifdef HAS_BROKEN_BSWAP
		swigIntConstant( HAS_BROKEN_BSWAP, "HAS_BROKEN_BSWAP" );
	#endif
	#ifdef SDL_RELEASED
		swigIntConstant( SDL_RELEASED, "SDL_RELEASED" );
	#endif
	#ifdef SDL_PRESSED
		swigIntConstant( SDL_PRESSED, "SDL_PRESSED" );
	#endif
	#ifdef SDL_TEXTEDITINGEVENT_TEXT_SIZE
		swigIntConstant( SDL_TEXTEDITINGEVENT_TEXT_SIZE, "SDL_TEXTEDITINGEVENT_TEXT_SIZE" );
	#endif
	#ifdef SDL_TEXTINPUTEVENT_TEXT_SIZE
		swigIntConstant( SDL_TEXTINPUTEVENT_TEXT_SIZE, "SDL_TEXTINPUTEVENT_TEXT_SIZE" );
	#endif
	#ifdef SDL_QUERY
		swigIntConstant( SDL_QUERY, "SDL_QUERY" );
	#endif
	#ifdef SDL_IGNORE
		swigIntConstant( SDL_IGNORE, "SDL_IGNORE" );
	#endif
	#ifdef SDL_DISABLE
		swigIntConstant( SDL_DISABLE, "SDL_DISABLE" );
	#endif
	#ifdef SDL_ENABLE
		swigIntConstant( SDL_ENABLE, "SDL_ENABLE" );
	#endif
	#ifdef SDL_HAPTIC_CONSTANT
		swigUnsignedIntConstant( SDL_HAPTIC_CONSTANT, "SDL_HAPTIC_CONSTANT" );
	#endif
	#ifdef SDL_HAPTIC_SINE
		swigUnsignedIntConstant( SDL_HAPTIC_SINE, "SDL_HAPTIC_SINE" );
	#endif
	#ifdef SDL_HAPTIC_LEFTRIGHT
		swigUnsignedIntConstant( SDL_HAPTIC_LEFTRIGHT, "SDL_HAPTIC_LEFTRIGHT" );
	#endif
	#ifdef SDL_HAPTIC_TRIANGLE
		swigUnsignedIntConstant( SDL_HAPTIC_TRIANGLE, "SDL_HAPTIC_TRIANGLE" );
	#endif
	#ifdef SDL_HAPTIC_SAWTOOTHUP
		swigUnsignedIntConstant( SDL_HAPTIC_SAWTOOTHUP, "SDL_HAPTIC_SAWTOOTHUP" );
	#endif
	#ifdef SDL_HAPTIC_SAWTOOTHDOWN
		swigUnsignedIntConstant( SDL_HAPTIC_SAWTOOTHDOWN, "SDL_HAPTIC_SAWTOOTHDOWN" );
	#endif
	#ifdef SDL_HAPTIC_RAMP
		swigUnsignedIntConstant( SDL_HAPTIC_RAMP, "SDL_HAPTIC_RAMP" );
	#endif
	#ifdef SDL_HAPTIC_SPRING
		swigUnsignedIntConstant( SDL_HAPTIC_SPRING, "SDL_HAPTIC_SPRING" );
	#endif
	#ifdef SDL_HAPTIC_DAMPER
		swigUnsignedIntConstant( SDL_HAPTIC_DAMPER, "SDL_HAPTIC_DAMPER" );
	#endif
	#ifdef SDL_HAPTIC_INERTIA
		swigUnsignedIntConstant( SDL_HAPTIC_INERTIA, "SDL_HAPTIC_INERTIA" );
	#endif
	#ifdef SDL_HAPTIC_FRICTION
		swigUnsignedIntConstant( SDL_HAPTIC_FRICTION, "SDL_HAPTIC_FRICTION" );
	#endif
	#ifdef SDL_HAPTIC_CUSTOM
		swigUnsignedIntConstant( SDL_HAPTIC_CUSTOM, "SDL_HAPTIC_CUSTOM" );
	#endif
	#ifdef SDL_HAPTIC_GAIN
		swigUnsignedIntConstant( SDL_HAPTIC_GAIN, "SDL_HAPTIC_GAIN" );
	#endif
	#ifdef SDL_HAPTIC_AUTOCENTER
		swigUnsignedIntConstant( SDL_HAPTIC_AUTOCENTER, "SDL_HAPTIC_AUTOCENTER" );
	#endif
	#ifdef SDL_HAPTIC_STATUS
		swigUnsignedIntConstant( SDL_HAPTIC_STATUS, "SDL_HAPTIC_STATUS" );
	#endif
	#ifdef SDL_HAPTIC_PAUSE
		swigUnsignedIntConstant( SDL_HAPTIC_PAUSE, "SDL_HAPTIC_PAUSE" );
	#endif
	#ifdef SDL_HAPTIC_POLAR
		swigIntConstant( SDL_HAPTIC_POLAR, "SDL_HAPTIC_POLAR" );
	#endif
	#ifdef SDL_HAPTIC_CARTESIAN
		swigIntConstant( SDL_HAPTIC_CARTESIAN, "SDL_HAPTIC_CARTESIAN" );
	#endif
	#ifdef SDL_HAPTIC_SPHERICAL
		swigIntConstant( SDL_HAPTIC_SPHERICAL, "SDL_HAPTIC_SPHERICAL" );
	#endif
	#ifdef SDL_HAPTIC_STEERING_AXIS
		swigIntConstant( SDL_HAPTIC_STEERING_AXIS, "SDL_HAPTIC_STEERING_AXIS" );
	#endif
	#ifdef SDL_HAPTIC_INFINITY
		swigUnsignedIntConstant( SDL_HAPTIC_INFINITY, "SDL_HAPTIC_INFINITY" );
	#endif
	#ifdef SDL_MAX_LOG_MESSAGE
		swigIntConstant( SDL_MAX_LOG_MESSAGE, "SDL_MAX_LOG_MESSAGE" );
	#endif
	#ifdef SDL_MUTEX_TIMEDOUT
		swigIntConstant( SDL_MUTEX_TIMEDOUT, "SDL_MUTEX_TIMEDOUT" );
	#endif
	#ifdef SDL_RWOPS_UNKNOWN
		swigUnsignedIntConstant( SDL_RWOPS_UNKNOWN, "SDL_RWOPS_UNKNOWN" );
	#endif
	#ifdef SDL_RWOPS_WINFILE
		swigUnsignedIntConstant( SDL_RWOPS_WINFILE, "SDL_RWOPS_WINFILE" );
	#endif
	#ifdef SDL_RWOPS_STDFILE
		swigUnsignedIntConstant( SDL_RWOPS_STDFILE, "SDL_RWOPS_STDFILE" );
	#endif
	#ifdef SDL_RWOPS_JNIFILE
		swigUnsignedIntConstant( SDL_RWOPS_JNIFILE, "SDL_RWOPS_JNIFILE" );
	#endif
	#ifdef SDL_RWOPS_MEMORY
		swigUnsignedIntConstant( SDL_RWOPS_MEMORY, "SDL_RWOPS_MEMORY" );
	#endif
	#ifdef SDL_RWOPS_MEMORY_RO
		swigUnsignedIntConstant( SDL_RWOPS_MEMORY_RO, "SDL_RWOPS_MEMORY_RO" );
	#endif
	#ifdef RW_SEEK_SET
		swigIntConstant( RW_SEEK_SET, "RW_SEEK_SET" );
	#endif
	#ifdef RW_SEEK_CUR
		swigIntConstant( RW_SEEK_CUR, "RW_SEEK_CUR" );
	#endif
	#ifdef RW_SEEK_END
		swigIntConstant( RW_SEEK_END, "RW_SEEK_END" );
	#endif
	#ifdef SDL_NONSHAPEABLE_WINDOW
		swigIntConstant( SDL_NONSHAPEABLE_WINDOW, "SDL_NONSHAPEABLE_WINDOW" );
	#endif
	#ifdef SDL_INVALID_SHAPE_ARGUMENT
		swigIntConstant( SDL_INVALID_SHAPE_ARGUMENT, "SDL_INVALID_SHAPE_ARGUMENT" );
	#endif
	#ifdef SDL_WINDOW_LACKS_SHAPE
		swigIntConstant( SDL_WINDOW_LACKS_SHAPE, "SDL_WINDOW_LACKS_SHAPE" );
	#endif
	#ifdef SDL_MAJOR_VERSION
		swigIntConstant( SDL_MAJOR_VERSION, "SDL_MAJOR_VERSION" );
	#endif
	#ifdef SDL_MINOR_VERSION
		swigIntConstant( SDL_MINOR_VERSION, "SDL_MINOR_VERSION" );
	#endif
	#ifdef SDL_PATCHLEVEL
		swigIntConstant( SDL_PATCHLEVEL, "SDL_PATCHLEVEL" );
	#endif
	#ifdef SDL_COMPILEDVERSION
		swigIntConstant( SDL_COMPILEDVERSION, "SDL_COMPILEDVERSION" );
	#endif
	#ifdef SDL_WINDOWPOS_UNDEFINED_MASK
		swigUnsignedIntConstant( SDL_WINDOWPOS_UNDEFINED_MASK, "SDL_WINDOWPOS_UNDEFINED_MASK" );
	#endif
	#ifdef SDL_WINDOWPOS_UNDEFINED
		swigUnsignedIntConstant( SDL_WINDOWPOS_UNDEFINED, "SDL_WINDOWPOS_UNDEFINED" );
	#endif
	#ifdef SDL_WINDOWPOS_CENTERED_MASK
		swigUnsignedIntConstant( SDL_WINDOWPOS_CENTERED_MASK, "SDL_WINDOWPOS_CENTERED_MASK" );
	#endif
	#ifdef SDL_WINDOWPOS_CENTERED
		swigUnsignedIntConstant( SDL_WINDOWPOS_CENTERED, "SDL_WINDOWPOS_CENTERED" );
	#endif

	swigNewline();

	swigComment("---===< float constants >===----\n");
	#ifdef SDL_FLT_EPSILON
		swigFloatConstant( SDL_FLT_EPSILON, "SDL_FLT_EPSILON" );
	#endif
	#ifdef M_PI
		swigFloatConstant( M_PI, "M_PI" );
	#endif
	#ifdef SDL_STANDARD_GRAVITY
		swigFloatConstant( SDL_STANDARD_GRAVITY, "SDL_STANDARD_GRAVITY" );
	#endif

	swigNewline();

	swigComment("--------===< enums >===---------\n");
	swigIntConstant( SDL_FALSE, "SDL_FALSE" );
	swigIntConstant( SDL_TRUE, "SDL_TRUE" );
	swigIntConstant( DUMMY_ENUM_VALUE, "DUMMY_ENUM_VALUE" );
	swigIntConstant( SDL_ASSERTION_RETRY, "SDL_ASSERTION_RETRY" );
	swigIntConstant( SDL_ASSERTION_BREAK, "SDL_ASSERTION_BREAK" );
	swigIntConstant( SDL_ASSERTION_ABORT, "SDL_ASSERTION_ABORT" );
	swigIntConstant( SDL_ASSERTION_IGNORE, "SDL_ASSERTION_IGNORE" );
	swigIntConstant( SDL_ASSERTION_ALWAYS_IGNORE, "SDL_ASSERTION_ALWAYS_IGNORE" );
	swigIntConstant( SDL_AUDIO_STOPPED, "SDL_AUDIO_STOPPED" );
	swigIntConstant( SDL_AUDIO_PLAYING, "SDL_AUDIO_PLAYING" );
	swigIntConstant( SDL_AUDIO_PAUSED, "SDL_AUDIO_PAUSED" );
	swigIntConstant( SDL_ENOMEM, "SDL_ENOMEM" );
	swigIntConstant( SDL_EFREAD, "SDL_EFREAD" );
	swigIntConstant( SDL_EFWRITE, "SDL_EFWRITE" );
	swigIntConstant( SDL_EFSEEK, "SDL_EFSEEK" );
	swigIntConstant( SDL_UNSUPPORTED, "SDL_UNSUPPORTED" );
	swigIntConstant( SDL_LASTERROR, "SDL_LASTERROR" );
	swigIntConstant( SDL_FIRSTEVENT, "SDL_FIRSTEVENT" );
	swigIntConstant( SDL_QUIT, "SDL_QUIT" );
	swigIntConstant( SDL_APP_TERMINATING, "SDL_APP_TERMINATING" );
	swigIntConstant( SDL_APP_LOWMEMORY, "SDL_APP_LOWMEMORY" );
	swigIntConstant( SDL_APP_WILLENTERBACKGROUND, "SDL_APP_WILLENTERBACKGROUND" );
	swigIntConstant( SDL_APP_DIDENTERBACKGROUND, "SDL_APP_DIDENTERBACKGROUND" );
	swigIntConstant( SDL_APP_WILLENTERFOREGROUND, "SDL_APP_WILLENTERFOREGROUND" );
	swigIntConstant( SDL_APP_DIDENTERFOREGROUND, "SDL_APP_DIDENTERFOREGROUND" );
	swigIntConstant( SDL_LOCALECHANGED, "SDL_LOCALECHANGED" );
	swigIntConstant( SDL_DISPLAYEVENT, "SDL_DISPLAYEVENT" );
	swigIntConstant( SDL_WINDOWEVENT, "SDL_WINDOWEVENT" );
	swigIntConstant( SDL_SYSWMEVENT, "SDL_SYSWMEVENT" );
	swigIntConstant( SDL_KEYDOWN, "SDL_KEYDOWN" );
	swigIntConstant( SDL_KEYUP, "SDL_KEYUP" );
	swigIntConstant( SDL_TEXTEDITING, "SDL_TEXTEDITING" );
	swigIntConstant( SDL_TEXTINPUT, "SDL_TEXTINPUT" );
	swigIntConstant( SDL_KEYMAPCHANGED, "SDL_KEYMAPCHANGED" );
	swigIntConstant( SDL_TEXTEDITING_EXT, "SDL_TEXTEDITING_EXT" );
	swigIntConstant( SDL_MOUSEMOTION, "SDL_MOUSEMOTION" );
	swigIntConstant( SDL_MOUSEBUTTONDOWN, "SDL_MOUSEBUTTONDOWN" );
	swigIntConstant( SDL_MOUSEBUTTONUP, "SDL_MOUSEBUTTONUP" );
	swigIntConstant( SDL_MOUSEWHEEL, "SDL_MOUSEWHEEL" );
	swigIntConstant( SDL_JOYAXISMOTION, "SDL_JOYAXISMOTION" );
	swigIntConstant( SDL_JOYBALLMOTION, "SDL_JOYBALLMOTION" );
	swigIntConstant( SDL_JOYHATMOTION, "SDL_JOYHATMOTION" );
	swigIntConstant( SDL_JOYBUTTONDOWN, "SDL_JOYBUTTONDOWN" );
	swigIntConstant( SDL_JOYBUTTONUP, "SDL_JOYBUTTONUP" );
	swigIntConstant( SDL_JOYDEVICEADDED, "SDL_JOYDEVICEADDED" );
	swigIntConstant( SDL_JOYDEVICEREMOVED, "SDL_JOYDEVICEREMOVED" );
	swigIntConstant( SDL_CONTROLLERAXISMOTION, "SDL_CONTROLLERAXISMOTION" );
	swigIntConstant( SDL_CONTROLLERBUTTONDOWN, "SDL_CONTROLLERBUTTONDOWN" );
	swigIntConstant( SDL_CONTROLLERBUTTONUP, "SDL_CONTROLLERBUTTONUP" );
	swigIntConstant( SDL_CONTROLLERDEVICEADDED, "SDL_CONTROLLERDEVICEADDED" );
	swigIntConstant( SDL_CONTROLLERDEVICEREMOVED, "SDL_CONTROLLERDEVICEREMOVED" );
	swigIntConstant( SDL_CONTROLLERDEVICEREMAPPED, "SDL_CONTROLLERDEVICEREMAPPED" );
	swigIntConstant( SDL_CONTROLLERTOUCHPADDOWN, "SDL_CONTROLLERTOUCHPADDOWN" );
	swigIntConstant( SDL_CONTROLLERTOUCHPADMOTION, "SDL_CONTROLLERTOUCHPADMOTION" );
	swigIntConstant( SDL_CONTROLLERTOUCHPADUP, "SDL_CONTROLLERTOUCHPADUP" );
	swigIntConstant( SDL_CONTROLLERSENSORUPDATE, "SDL_CONTROLLERSENSORUPDATE" );
	swigIntConstant( SDL_FINGERDOWN, "SDL_FINGERDOWN" );
	swigIntConstant( SDL_FINGERUP, "SDL_FINGERUP" );
	swigIntConstant( SDL_FINGERMOTION, "SDL_FINGERMOTION" );
	swigIntConstant( SDL_DOLLARGESTURE, "SDL_DOLLARGESTURE" );
	swigIntConstant( SDL_DOLLARRECORD, "SDL_DOLLARRECORD" );
	swigIntConstant( SDL_MULTIGESTURE, "SDL_MULTIGESTURE" );
	swigIntConstant( SDL_CLIPBOARDUPDATE, "SDL_CLIPBOARDUPDATE" );
	swigIntConstant( SDL_DROPFILE, "SDL_DROPFILE" );
	swigIntConstant( SDL_DROPTEXT, "SDL_DROPTEXT" );
	swigIntConstant( SDL_DROPBEGIN, "SDL_DROPBEGIN" );
	swigIntConstant( SDL_DROPCOMPLETE, "SDL_DROPCOMPLETE" );
	swigIntConstant( SDL_AUDIODEVICEADDED, "SDL_AUDIODEVICEADDED" );
	swigIntConstant( SDL_AUDIODEVICEREMOVED, "SDL_AUDIODEVICEREMOVED" );
	swigIntConstant( SDL_SENSORUPDATE, "SDL_SENSORUPDATE" );
	swigIntConstant( SDL_RENDER_TARGETS_RESET, "SDL_RENDER_TARGETS_RESET" );
	swigIntConstant( SDL_RENDER_DEVICE_RESET, "SDL_RENDER_DEVICE_RESET" );
	swigIntConstant( SDL_POLLSENTINEL, "SDL_POLLSENTINEL" );
	swigIntConstant( SDL_USEREVENT, "SDL_USEREVENT" );
	swigIntConstant( SDL_LASTEVENT, "SDL_LASTEVENT" );
	swigIntConstant( SDL_ADDEVENT, "SDL_ADDEVENT" );
	swigIntConstant( SDL_PEEKEVENT, "SDL_PEEKEVENT" );
	swigIntConstant( SDL_GETEVENT, "SDL_GETEVENT" );
	swigIntConstant( SDL_HINT_DEFAULT, "SDL_HINT_DEFAULT" );
	swigIntConstant( SDL_HINT_NORMAL, "SDL_HINT_NORMAL" );
	swigIntConstant( SDL_HINT_OVERRIDE, "SDL_HINT_OVERRIDE" );
	swigIntConstant( SDL_LOG_CATEGORY_APPLICATION, "SDL_LOG_CATEGORY_APPLICATION" );
	swigIntConstant( SDL_LOG_CATEGORY_ERROR, "SDL_LOG_CATEGORY_ERROR" );
	swigIntConstant( SDL_LOG_CATEGORY_ASSERT, "SDL_LOG_CATEGORY_ASSERT" );
	swigIntConstant( SDL_LOG_CATEGORY_SYSTEM, "SDL_LOG_CATEGORY_SYSTEM" );
	swigIntConstant( SDL_LOG_CATEGORY_AUDIO, "SDL_LOG_CATEGORY_AUDIO" );
	swigIntConstant( SDL_LOG_CATEGORY_VIDEO, "SDL_LOG_CATEGORY_VIDEO" );
	swigIntConstant( SDL_LOG_CATEGORY_RENDER, "SDL_LOG_CATEGORY_RENDER" );
	swigIntConstant( SDL_LOG_CATEGORY_INPUT, "SDL_LOG_CATEGORY_INPUT" );
	swigIntConstant( SDL_LOG_CATEGORY_TEST, "SDL_LOG_CATEGORY_TEST" );
	swigIntConstant( SDL_LOG_CATEGORY_RESERVED1, "SDL_LOG_CATEGORY_RESERVED1" );
	swigIntConstant( SDL_LOG_CATEGORY_RESERVED2, "SDL_LOG_CATEGORY_RESERVED2" );
	swigIntConstant( SDL_LOG_CATEGORY_RESERVED3, "SDL_LOG_CATEGORY_RESERVED3" );
	swigIntConstant( SDL_LOG_CATEGORY_RESERVED4, "SDL_LOG_CATEGORY_RESERVED4" );
	swigIntConstant( SDL_LOG_CATEGORY_RESERVED5, "SDL_LOG_CATEGORY_RESERVED5" );
	swigIntConstant( SDL_LOG_CATEGORY_RESERVED6, "SDL_LOG_CATEGORY_RESERVED6" );
	swigIntConstant( SDL_LOG_CATEGORY_RESERVED7, "SDL_LOG_CATEGORY_RESERVED7" );
	swigIntConstant( SDL_LOG_CATEGORY_RESERVED8, "SDL_LOG_CATEGORY_RESERVED8" );
	swigIntConstant( SDL_LOG_CATEGORY_RESERVED9, "SDL_LOG_CATEGORY_RESERVED9" );
	swigIntConstant( SDL_LOG_CATEGORY_RESERVED10, "SDL_LOG_CATEGORY_RESERVED10" );
	swigIntConstant( SDL_LOG_CATEGORY_CUSTOM, "SDL_LOG_CATEGORY_CUSTOM" );
	swigIntConstant( SDL_LOG_PRIORITY_VERBOSE, "SDL_LOG_PRIORITY_VERBOSE" );
	swigIntConstant( SDL_LOG_PRIORITY_DEBUG, "SDL_LOG_PRIORITY_DEBUG" );
	swigIntConstant( SDL_LOG_PRIORITY_INFO, "SDL_LOG_PRIORITY_INFO" );
	swigIntConstant( SDL_LOG_PRIORITY_WARN, "SDL_LOG_PRIORITY_WARN" );
	swigIntConstant( SDL_LOG_PRIORITY_ERROR, "SDL_LOG_PRIORITY_ERROR" );
	swigIntConstant( SDL_LOG_PRIORITY_CRITICAL, "SDL_LOG_PRIORITY_CRITICAL" );
	swigIntConstant( SDL_NUM_LOG_PRIORITIES, "SDL_NUM_LOG_PRIORITIES" );
	swigIntConstant( SDL_MESSAGEBOX_ERROR, "SDL_MESSAGEBOX_ERROR" );
	swigIntConstant( SDL_MESSAGEBOX_WARNING, "SDL_MESSAGEBOX_WARNING" );
	swigIntConstant( SDL_MESSAGEBOX_INFORMATION, "SDL_MESSAGEBOX_INFORMATION" );
	swigIntConstant( SDL_MESSAGEBOX_BUTTONS_LEFT_TO_RIGHT, "SDL_MESSAGEBOX_BUTTONS_LEFT_TO_RIGHT" );
	swigIntConstant( SDL_MESSAGEBOX_BUTTONS_RIGHT_TO_LEFT, "SDL_MESSAGEBOX_BUTTONS_RIGHT_TO_LEFT" );
	swigIntConstant( SDL_MESSAGEBOX_BUTTON_RETURNKEY_DEFAULT, "SDL_MESSAGEBOX_BUTTON_RETURNKEY_DEFAULT" );
	swigIntConstant( SDL_MESSAGEBOX_BUTTON_ESCAPEKEY_DEFAULT, "SDL_MESSAGEBOX_BUTTON_ESCAPEKEY_DEFAULT" );
	swigIntConstant( SDL_MESSAGEBOX_COLOR_BACKGROUND, "SDL_MESSAGEBOX_COLOR_BACKGROUND" );
	swigIntConstant( SDL_MESSAGEBOX_COLOR_TEXT, "SDL_MESSAGEBOX_COLOR_TEXT" );
	swigIntConstant( SDL_MESSAGEBOX_COLOR_BUTTON_BORDER, "SDL_MESSAGEBOX_COLOR_BUTTON_BORDER" );
	swigIntConstant( SDL_MESSAGEBOX_COLOR_BUTTON_BACKGROUND, "SDL_MESSAGEBOX_COLOR_BUTTON_BACKGROUND" );
	swigIntConstant( SDL_MESSAGEBOX_COLOR_BUTTON_SELECTED, "SDL_MESSAGEBOX_COLOR_BUTTON_SELECTED" );
	swigIntConstant( SDL_MESSAGEBOX_COLOR_MAX, "SDL_MESSAGEBOX_COLOR_MAX" );
	swigIntConstant( SDL_POWERSTATE_UNKNOWN, "SDL_POWERSTATE_UNKNOWN" );
	swigIntConstant( SDL_POWERSTATE_ON_BATTERY, "SDL_POWERSTATE_ON_BATTERY" );
	swigIntConstant( SDL_POWERSTATE_NO_BATTERY, "SDL_POWERSTATE_NO_BATTERY" );
	swigIntConstant( SDL_POWERSTATE_CHARGING, "SDL_POWERSTATE_CHARGING" );
	swigIntConstant( SDL_POWERSTATE_CHARGED, "SDL_POWERSTATE_CHARGED" );
	swigIntConstant( SDL_RENDERER_SOFTWARE, "SDL_RENDERER_SOFTWARE" );
	swigIntConstant( SDL_RENDERER_ACCELERATED, "SDL_RENDERER_ACCELERATED" );
	swigIntConstant( SDL_RENDERER_PRESENTVSYNC, "SDL_RENDERER_PRESENTVSYNC" );
	swigIntConstant( SDL_RENDERER_TARGETTEXTURE, "SDL_RENDERER_TARGETTEXTURE" );
	swigIntConstant( SDL_ScaleModeNearest, "SDL_ScaleModeNearest" );
	swigIntConstant( SDL_ScaleModeLinear, "SDL_ScaleModeLinear" );
	swigIntConstant( SDL_ScaleModeBest, "SDL_ScaleModeBest" );
	swigIntConstant( SDL_TEXTUREACCESS_STATIC, "SDL_TEXTUREACCESS_STATIC" );
	swigIntConstant( SDL_TEXTUREACCESS_STREAMING, "SDL_TEXTUREACCESS_STREAMING" );
	swigIntConstant( SDL_TEXTUREACCESS_TARGET, "SDL_TEXTUREACCESS_TARGET" );
	swigIntConstant( SDL_TEXTUREMODULATE_NONE, "SDL_TEXTUREMODULATE_NONE" );
	swigIntConstant( SDL_TEXTUREMODULATE_COLOR, "SDL_TEXTUREMODULATE_COLOR" );
	swigIntConstant( SDL_TEXTUREMODULATE_ALPHA, "SDL_TEXTUREMODULATE_ALPHA" );
	swigIntConstant( SDL_FLIP_NONE, "SDL_FLIP_NONE" );
	swigIntConstant( SDL_FLIP_HORIZONTAL, "SDL_FLIP_HORIZONTAL" );
	swigIntConstant( SDL_FLIP_VERTICAL, "SDL_FLIP_VERTICAL" );
	swigIntConstant( SDL_SENSOR_INVALID, "SDL_SENSOR_INVALID" );
	swigIntConstant( SDL_SENSOR_UNKNOWN, "SDL_SENSOR_UNKNOWN" );
	swigIntConstant( SDL_SENSOR_ACCEL, "SDL_SENSOR_ACCEL" );
	swigIntConstant( SDL_SENSOR_GYRO, "SDL_SENSOR_GYRO" );
	swigIntConstant( ShapeModeDefault, "ShapeModeDefault" );
	swigIntConstant( ShapeModeBinarizeAlpha, "ShapeModeBinarizeAlpha" );
	swigIntConstant( ShapeModeReverseBinarizeAlpha, "ShapeModeReverseBinarizeAlpha" );
	swigIntConstant( ShapeModeColorKey, "ShapeModeColorKey" );
	swigIntConstant( SDL_THREAD_PRIORITY_LOW, "SDL_THREAD_PRIORITY_LOW" );
	swigIntConstant( SDL_THREAD_PRIORITY_NORMAL, "SDL_THREAD_PRIORITY_NORMAL" );
	swigIntConstant( SDL_THREAD_PRIORITY_HIGH, "SDL_THREAD_PRIORITY_HIGH" );
	swigIntConstant( SDL_THREAD_PRIORITY_TIME_CRITICAL, "SDL_THREAD_PRIORITY_TIME_CRITICAL" );
	swigIntConstant( SDL_WINDOW_FULLSCREEN, "SDL_WINDOW_FULLSCREEN" );
	swigIntConstant( SDL_WINDOW_OPENGL, "SDL_WINDOW_OPENGL" );
	swigIntConstant( SDL_WINDOW_SHOWN, "SDL_WINDOW_SHOWN" );
	swigIntConstant( SDL_WINDOW_HIDDEN, "SDL_WINDOW_HIDDEN" );
	swigIntConstant( SDL_WINDOW_BORDERLESS, "SDL_WINDOW_BORDERLESS" );
	swigIntConstant( SDL_WINDOW_RESIZABLE, "SDL_WINDOW_RESIZABLE" );
	swigIntConstant( SDL_WINDOW_MINIMIZED, "SDL_WINDOW_MINIMIZED" );
	swigIntConstant( SDL_WINDOW_MAXIMIZED, "SDL_WINDOW_MAXIMIZED" );
	swigIntConstant( SDL_WINDOW_MOUSE_GRABBED, "SDL_WINDOW_MOUSE_GRABBED" );
	swigIntConstant( SDL_WINDOW_INPUT_FOCUS, "SDL_WINDOW_INPUT_FOCUS" );
	swigIntConstant( SDL_WINDOW_MOUSE_FOCUS, "SDL_WINDOW_MOUSE_FOCUS" );
	swigIntConstant( SDL_WINDOW_FULLSCREEN_DESKTOP, "SDL_WINDOW_FULLSCREEN_DESKTOP" );
	swigIntConstant( SDL_WINDOW_FOREIGN, "SDL_WINDOW_FOREIGN" );
	swigIntConstant( SDL_WINDOW_ALLOW_HIGHDPI, "SDL_WINDOW_ALLOW_HIGHDPI" );
	swigIntConstant( SDL_WINDOW_MOUSE_CAPTURE, "SDL_WINDOW_MOUSE_CAPTURE" );
	swigIntConstant( SDL_WINDOW_ALWAYS_ON_TOP, "SDL_WINDOW_ALWAYS_ON_TOP" );
	swigIntConstant( SDL_WINDOW_SKIP_TASKBAR, "SDL_WINDOW_SKIP_TASKBAR" );
	swigIntConstant( SDL_WINDOW_UTILITY, "SDL_WINDOW_UTILITY" );
	swigIntConstant( SDL_WINDOW_TOOLTIP, "SDL_WINDOW_TOOLTIP" );
	swigIntConstant( SDL_WINDOW_POPUP_MENU, "SDL_WINDOW_POPUP_MENU" );
	swigIntConstant( SDL_WINDOW_KEYBOARD_GRABBED, "SDL_WINDOW_KEYBOARD_GRABBED" );
	swigIntConstant( SDL_WINDOW_VULKAN, "SDL_WINDOW_VULKAN" );
	swigIntConstant( SDL_WINDOW_METAL, "SDL_WINDOW_METAL" );
	swigIntConstant( SDL_WINDOW_INPUT_GRABBED, "SDL_WINDOW_INPUT_GRABBED" );
	swigIntConstant( SDL_WINDOWEVENT_NONE, "SDL_WINDOWEVENT_NONE" );
	swigIntConstant( SDL_WINDOWEVENT_SHOWN, "SDL_WINDOWEVENT_SHOWN" );
	swigIntConstant( SDL_WINDOWEVENT_HIDDEN, "SDL_WINDOWEVENT_HIDDEN" );
	swigIntConstant( SDL_WINDOWEVENT_EXPOSED, "SDL_WINDOWEVENT_EXPOSED" );
	swigIntConstant( SDL_WINDOWEVENT_MOVED, "SDL_WINDOWEVENT_MOVED" );
	swigIntConstant( SDL_WINDOWEVENT_RESIZED, "SDL_WINDOWEVENT_RESIZED" );
	swigIntConstant( SDL_WINDOWEVENT_SIZE_CHANGED, "SDL_WINDOWEVENT_SIZE_CHANGED" );
	swigIntConstant( SDL_WINDOWEVENT_MINIMIZED, "SDL_WINDOWEVENT_MINIMIZED" );
	swigIntConstant( SDL_WINDOWEVENT_MAXIMIZED, "SDL_WINDOWEVENT_MAXIMIZED" );
	swigIntConstant( SDL_WINDOWEVENT_RESTORED, "SDL_WINDOWEVENT_RESTORED" );
	swigIntConstant( SDL_WINDOWEVENT_ENTER, "SDL_WINDOWEVENT_ENTER" );
	swigIntConstant( SDL_WINDOWEVENT_LEAVE, "SDL_WINDOWEVENT_LEAVE" );
	swigIntConstant( SDL_WINDOWEVENT_FOCUS_GAINED, "SDL_WINDOWEVENT_FOCUS_GAINED" );
	swigIntConstant( SDL_WINDOWEVENT_FOCUS_LOST, "SDL_WINDOWEVENT_FOCUS_LOST" );
	swigIntConstant( SDL_WINDOWEVENT_CLOSE, "SDL_WINDOWEVENT_CLOSE" );
	swigIntConstant( SDL_WINDOWEVENT_TAKE_FOCUS, "SDL_WINDOWEVENT_TAKE_FOCUS" );
	swigIntConstant( SDL_WINDOWEVENT_HIT_TEST, "SDL_WINDOWEVENT_HIT_TEST" );
	swigIntConstant( SDL_WINDOWEVENT_ICCPROF_CHANGED, "SDL_WINDOWEVENT_ICCPROF_CHANGED" );
	swigIntConstant( SDL_WINDOWEVENT_DISPLAY_CHANGED, "SDL_WINDOWEVENT_DISPLAY_CHANGED" );
	swigIntConstant( SDL_DISPLAYEVENT_NONE, "SDL_DISPLAYEVENT_NONE" );
	swigIntConstant( SDL_DISPLAYEVENT_ORIENTATION, "SDL_DISPLAYEVENT_ORIENTATION" );
	swigIntConstant( SDL_DISPLAYEVENT_CONNECTED, "SDL_DISPLAYEVENT_CONNECTED" );
	swigIntConstant( SDL_DISPLAYEVENT_DISCONNECTED, "SDL_DISPLAYEVENT_DISCONNECTED" );
	swigIntConstant( SDL_ORIENTATION_UNKNOWN, "SDL_ORIENTATION_UNKNOWN" );
	swigIntConstant( SDL_ORIENTATION_LANDSCAPE, "SDL_ORIENTATION_LANDSCAPE" );
	swigIntConstant( SDL_ORIENTATION_LANDSCAPE_FLIPPED, "SDL_ORIENTATION_LANDSCAPE_FLIPPED" );
	swigIntConstant( SDL_ORIENTATION_PORTRAIT, "SDL_ORIENTATION_PORTRAIT" );
	swigIntConstant( SDL_ORIENTATION_PORTRAIT_FLIPPED, "SDL_ORIENTATION_PORTRAIT_FLIPPED" );
	swigIntConstant( SDL_FLASH_CANCEL, "SDL_FLASH_CANCEL" );
	swigIntConstant( SDL_FLASH_BRIEFLY, "SDL_FLASH_BRIEFLY" );
	swigIntConstant( SDL_FLASH_UNTIL_FOCUSED, "SDL_FLASH_UNTIL_FOCUSED" );
	swigIntConstant( SDL_GL_RED_SIZE, "SDL_GL_RED_SIZE" );
	swigIntConstant( SDL_GL_GREEN_SIZE, "SDL_GL_GREEN_SIZE" );
	swigIntConstant( SDL_GL_BLUE_SIZE, "SDL_GL_BLUE_SIZE" );
	swigIntConstant( SDL_GL_ALPHA_SIZE, "SDL_GL_ALPHA_SIZE" );
	swigIntConstant( SDL_GL_BUFFER_SIZE, "SDL_GL_BUFFER_SIZE" );
	swigIntConstant( SDL_GL_DOUBLEBUFFER, "SDL_GL_DOUBLEBUFFER" );
	swigIntConstant( SDL_GL_DEPTH_SIZE, "SDL_GL_DEPTH_SIZE" );
	swigIntConstant( SDL_GL_STENCIL_SIZE, "SDL_GL_STENCIL_SIZE" );
	swigIntConstant( SDL_GL_ACCUM_RED_SIZE, "SDL_GL_ACCUM_RED_SIZE" );
	swigIntConstant( SDL_GL_ACCUM_GREEN_SIZE, "SDL_GL_ACCUM_GREEN_SIZE" );
	swigIntConstant( SDL_GL_ACCUM_BLUE_SIZE, "SDL_GL_ACCUM_BLUE_SIZE" );
	swigIntConstant( SDL_GL_ACCUM_ALPHA_SIZE, "SDL_GL_ACCUM_ALPHA_SIZE" );
	swigIntConstant( SDL_GL_STEREO, "SDL_GL_STEREO" );
	swigIntConstant( SDL_GL_MULTISAMPLEBUFFERS, "SDL_GL_MULTISAMPLEBUFFERS" );
	swigIntConstant( SDL_GL_MULTISAMPLESAMPLES, "SDL_GL_MULTISAMPLESAMPLES" );
	swigIntConstant( SDL_GL_ACCELERATED_VISUAL, "SDL_GL_ACCELERATED_VISUAL" );
	swigIntConstant( SDL_GL_RETAINED_BACKING, "SDL_GL_RETAINED_BACKING" );
	swigIntConstant( SDL_GL_CONTEXT_MAJOR_VERSION, "SDL_GL_CONTEXT_MAJOR_VERSION" );
	swigIntConstant( SDL_GL_CONTEXT_MINOR_VERSION, "SDL_GL_CONTEXT_MINOR_VERSION" );
	swigIntConstant( SDL_GL_CONTEXT_EGL, "SDL_GL_CONTEXT_EGL" );
	swigIntConstant( SDL_GL_CONTEXT_FLAGS, "SDL_GL_CONTEXT_FLAGS" );
	swigIntConstant( SDL_GL_CONTEXT_PROFILE_MASK, "SDL_GL_CONTEXT_PROFILE_MASK" );
	swigIntConstant( SDL_GL_SHARE_WITH_CURRENT_CONTEXT, "SDL_GL_SHARE_WITH_CURRENT_CONTEXT" );
	swigIntConstant( SDL_GL_FRAMEBUFFER_SRGB_CAPABLE, "SDL_GL_FRAMEBUFFER_SRGB_CAPABLE" );
	swigIntConstant( SDL_GL_CONTEXT_RELEASE_BEHAVIOR, "SDL_GL_CONTEXT_RELEASE_BEHAVIOR" );
	swigIntConstant( SDL_GL_CONTEXT_RESET_NOTIFICATION, "SDL_GL_CONTEXT_RESET_NOTIFICATION" );
	swigIntConstant( SDL_GL_CONTEXT_NO_ERROR, "SDL_GL_CONTEXT_NO_ERROR" );
	swigIntConstant( SDL_GL_CONTEXT_PROFILE_CORE, "SDL_GL_CONTEXT_PROFILE_CORE" );
	swigIntConstant( SDL_GL_CONTEXT_PROFILE_COMPATIBILITY, "SDL_GL_CONTEXT_PROFILE_COMPATIBILITY" );
	swigIntConstant( SDL_GL_CONTEXT_PROFILE_ES, "SDL_GL_CONTEXT_PROFILE_ES" );
	swigIntConstant( SDL_GL_CONTEXT_DEBUG_FLAG, "SDL_GL_CONTEXT_DEBUG_FLAG" );
	swigIntConstant( SDL_GL_CONTEXT_FORWARD_COMPATIBLE_FLAG, "SDL_GL_CONTEXT_FORWARD_COMPATIBLE_FLAG" );
	swigIntConstant( SDL_GL_CONTEXT_ROBUST_ACCESS_FLAG, "SDL_GL_CONTEXT_ROBUST_ACCESS_FLAG" );
	swigIntConstant( SDL_GL_CONTEXT_RESET_ISOLATION_FLAG, "SDL_GL_CONTEXT_RESET_ISOLATION_FLAG" );
	swigIntConstant( SDL_GL_CONTEXT_RELEASE_BEHAVIOR_NONE, "SDL_GL_CONTEXT_RELEASE_BEHAVIOR_NONE" );
	swigIntConstant( SDL_GL_CONTEXT_RELEASE_BEHAVIOR_FLUSH, "SDL_GL_CONTEXT_RELEASE_BEHAVIOR_FLUSH" );
	swigIntConstant( SDL_GL_CONTEXT_RESET_NO_NOTIFICATION, "SDL_GL_CONTEXT_RESET_NO_NOTIFICATION" );
	swigIntConstant( SDL_GL_CONTEXT_RESET_LOSE_CONTEXT, "SDL_GL_CONTEXT_RESET_LOSE_CONTEXT" );
	swigIntConstant( SDL_HITTEST_NORMAL, "SDL_HITTEST_NORMAL" );
	swigIntConstant( SDL_HITTEST_DRAGGABLE, "SDL_HITTEST_DRAGGABLE" );
	swigIntConstant( SDL_HITTEST_RESIZE_TOPLEFT, "SDL_HITTEST_RESIZE_TOPLEFT" );
	swigIntConstant( SDL_HITTEST_RESIZE_TOP, "SDL_HITTEST_RESIZE_TOP" );
	swigIntConstant( SDL_HITTEST_RESIZE_TOPRIGHT, "SDL_HITTEST_RESIZE_TOPRIGHT" );
	swigIntConstant( SDL_HITTEST_RESIZE_RIGHT, "SDL_HITTEST_RESIZE_RIGHT" );
	swigIntConstant( SDL_HITTEST_RESIZE_BOTTOMRIGHT, "SDL_HITTEST_RESIZE_BOTTOMRIGHT" );
	swigIntConstant( SDL_HITTEST_RESIZE_BOTTOM, "SDL_HITTEST_RESIZE_BOTTOM" );
	swigIntConstant( SDL_HITTEST_RESIZE_BOTTOMLEFT, "SDL_HITTEST_RESIZE_BOTTOMLEFT" );
	swigIntConstant( SDL_HITTEST_RESIZE_LEFT, "SDL_HITTEST_RESIZE_LEFT" );

	swigNewline();

	swigComment("-------===< structs >===--------\n");

	swigComment("struct SDL_AssertData\n");
	printf( "begin-structure SDL_AssertData\n" );
	swigStructField( "SDL_AssertData-condition", offsetof( struct SDL_AssertData, condition ), sizeof( char const * ) );
	swigStructField( "SDL_AssertData-trigger_count", offsetof( struct SDL_AssertData, trigger_count ), sizeof( unsigned int ) );
	swigStructField( "SDL_AssertData-filename", offsetof( struct SDL_AssertData, filename ), sizeof( char const * ) );
	swigStructField( "SDL_AssertData-function", offsetof( struct SDL_AssertData, function ), sizeof( char const * ) );
	swigStructField( "SDL_AssertData-always_ignore", offsetof( struct SDL_AssertData, always_ignore ), sizeof( int ) );
	swigStructField( "SDL_AssertData-next", offsetof( struct SDL_AssertData, next ), sizeof( struct SDL_AssertData const * ) );
	swigStructField( "SDL_AssertData-linenum", offsetof( struct SDL_AssertData, linenum ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( struct SDL_AssertData ) );

	swigComment("SDL_atomic_t\n");
	printf( "begin-structure SDL_atomic_t\n" );
	swigStructField( "SDL_atomic_t-value", offsetof( SDL_atomic_t, value ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( SDL_atomic_t ) );

	swigComment("struct SDL_AudioSpec\n");
	printf( "begin-structure SDL_AudioSpec\n" );
	swigStructField( "SDL_AudioSpec-freq", offsetof( struct SDL_AudioSpec, freq ), sizeof( int ) );
	swigStructField( "SDL_AudioSpec-channels", offsetof( struct SDL_AudioSpec, channels ), sizeof( Uint8 ) );
	swigStructField( "SDL_AudioSpec-silence", offsetof( struct SDL_AudioSpec, silence ), sizeof( Uint8 ) );
	swigStructField( "SDL_AudioSpec-padding", offsetof( struct SDL_AudioSpec, padding ), sizeof( Uint16 ) );
	swigStructField( "SDL_AudioSpec-samples", offsetof( struct SDL_AudioSpec, samples ), sizeof( Uint16 ) );
	swigStructField( "SDL_AudioSpec-size", offsetof( struct SDL_AudioSpec, size ), sizeof( Uint32 ) );
	swigStructField( "SDL_AudioSpec-format", offsetof( struct SDL_AudioSpec, format ), sizeof( SDL_AudioFormat ) );
	swigStructField( "SDL_AudioSpec-callback", offsetof( struct SDL_AudioSpec, callback ), sizeof( SDL_AudioCallback ) );
	swigStructField( "SDL_AudioSpec-userdata", offsetof( struct SDL_AudioSpec, userdata ), sizeof( void * ) );
	printf( "drop %zu end-structure\n", sizeof( struct SDL_AudioSpec ) );

	swigComment("struct SDL_AudioCVT\n");
	printf( "begin-structure SDL_AudioCVT\n" );
	swigStructField( "SDL_AudioCVT-filter_index", offsetof( struct SDL_AudioCVT, filter_index ), sizeof( int ) );
	swigStructField( "SDL_AudioCVT-rate_incr", offsetof( struct SDL_AudioCVT, rate_incr ), sizeof( double ) );
	swigStructField( "SDL_AudioCVT-len", offsetof( struct SDL_AudioCVT, len ), sizeof( int ) );
	swigStructField( "SDL_AudioCVT-len_cvt", offsetof( struct SDL_AudioCVT, len_cvt ), sizeof( int ) );
	swigStructField( "SDL_AudioCVT-buf", offsetof( struct SDL_AudioCVT, buf ), sizeof( Uint8 * ) );
	swigStructField( "SDL_AudioCVT-filters", offsetof( struct SDL_AudioCVT, filters ), sizeof( SDL_AudioFilter [9+1] ) );
	swigStructField( "SDL_AudioCVT-src_format", offsetof( struct SDL_AudioCVT, src_format ), sizeof( SDL_AudioFormat ) );
	swigStructField( "SDL_AudioCVT-dst_format", offsetof( struct SDL_AudioCVT, dst_format ), sizeof( SDL_AudioFormat ) );
	swigStructField( "SDL_AudioCVT-len_mult", offsetof( struct SDL_AudioCVT, len_mult ), sizeof( int ) );
	swigStructField( "SDL_AudioCVT-needed", offsetof( struct SDL_AudioCVT, needed ), sizeof( int ) );
	swigStructField( "SDL_AudioCVT-len_ratio", offsetof( struct SDL_AudioCVT, len_ratio ), sizeof( double ) );
	printf( "drop %zu end-structure\n", sizeof( struct SDL_AudioCVT ) );

	swigComment("struct SDL_CommonEvent\n");
	printf( "begin-structure SDL_CommonEvent\n" );
	swigStructField( "SDL_CommonEvent-type", offsetof( struct SDL_CommonEvent, type ), sizeof( Uint32 ) );
	swigStructField( "SDL_CommonEvent-timestamp", offsetof( struct SDL_CommonEvent, timestamp ), sizeof( Uint32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct SDL_CommonEvent ) );

	swigComment("struct SDL_DisplayEvent\n");
	printf( "begin-structure SDL_DisplayEvent\n" );
	swigStructField( "SDL_DisplayEvent-display", offsetof( struct SDL_DisplayEvent, display ), sizeof( Uint32 ) );
	swigStructField( "SDL_DisplayEvent-type", offsetof( struct SDL_DisplayEvent, type ), sizeof( Uint32 ) );
	swigStructField( "SDL_DisplayEvent-padding1", offsetof( struct SDL_DisplayEvent, padding1 ), sizeof( Uint8 ) );
	swigStructField( "SDL_DisplayEvent-data1", offsetof( struct SDL_DisplayEvent, data1 ), sizeof( Sint32 ) );
	swigStructField( "SDL_DisplayEvent-timestamp", offsetof( struct SDL_DisplayEvent, timestamp ), sizeof( Uint32 ) );
	swigStructField( "SDL_DisplayEvent-padding2", offsetof( struct SDL_DisplayEvent, padding2 ), sizeof( Uint8 ) );
	swigStructField( "SDL_DisplayEvent-event", offsetof( struct SDL_DisplayEvent, event ), sizeof( Uint8 ) );
	swigStructField( "SDL_DisplayEvent-padding3", offsetof( struct SDL_DisplayEvent, padding3 ), sizeof( Uint8 ) );
	printf( "drop %zu end-structure\n", sizeof( struct SDL_DisplayEvent ) );

	swigComment("struct SDL_WindowEvent\n");
	printf( "begin-structure SDL_WindowEvent\n" );
	swigStructField( "SDL_WindowEvent-windowID", offsetof( struct SDL_WindowEvent, windowID ), sizeof( Uint32 ) );
	swigStructField( "SDL_WindowEvent-type", offsetof( struct SDL_WindowEvent, type ), sizeof( Uint32 ) );
	swigStructField( "SDL_WindowEvent-padding1", offsetof( struct SDL_WindowEvent, padding1 ), sizeof( Uint8 ) );
	swigStructField( "SDL_WindowEvent-data1", offsetof( struct SDL_WindowEvent, data1 ), sizeof( Sint32 ) );
	swigStructField( "SDL_WindowEvent-timestamp", offsetof( struct SDL_WindowEvent, timestamp ), sizeof( Uint32 ) );
	swigStructField( "SDL_WindowEvent-padding2", offsetof( struct SDL_WindowEvent, padding2 ), sizeof( Uint8 ) );
	swigStructField( "SDL_WindowEvent-data2", offsetof( struct SDL_WindowEvent, data2 ), sizeof( Sint32 ) );
	swigStructField( "SDL_WindowEvent-event", offsetof( struct SDL_WindowEvent, event ), sizeof( Uint8 ) );
	swigStructField( "SDL_WindowEvent-padding3", offsetof( struct SDL_WindowEvent, padding3 ), sizeof( Uint8 ) );
	printf( "drop %zu end-structure\n", sizeof( struct SDL_WindowEvent ) );

	swigComment("struct SDL_KeyboardEvent\n");
	printf( "begin-structure SDL_KeyboardEvent\n" );
	swigStructField( "SDL_KeyboardEvent-windowID", offsetof( struct SDL_KeyboardEvent, windowID ), sizeof( Uint32 ) );
	swigStructField( "SDL_KeyboardEvent-type", offsetof( struct SDL_KeyboardEvent, type ), sizeof( Uint32 ) );
	swigStructField( "SDL_KeyboardEvent-timestamp", offsetof( struct SDL_KeyboardEvent, timestamp ), sizeof( Uint32 ) );
	swigStructField( "SDL_KeyboardEvent-state", offsetof( struct SDL_KeyboardEvent, state ), sizeof( Uint8 ) );
	swigStructField( "SDL_KeyboardEvent-padding2", offsetof( struct SDL_KeyboardEvent, padding2 ), sizeof( Uint8 ) );
	swigStructField( "SDL_KeyboardEvent-repeat", offsetof( struct SDL_KeyboardEvent, repeat ), sizeof( Uint8 ) );
	swigStructField( "SDL_KeyboardEvent-padding3", offsetof( struct SDL_KeyboardEvent, padding3 ), sizeof( Uint8 ) );
	swigStructField( "SDL_KeyboardEvent-keysym", offsetof( struct SDL_KeyboardEvent, keysym ), sizeof( SDL_Keysym ) );
	printf( "drop %zu end-structure\n", sizeof( struct SDL_KeyboardEvent ) );

	swigComment("struct SDL_TextEditingEvent\n");
	printf( "begin-structure SDL_TextEditingEvent\n" );
	swigStructField( "SDL_TextEditingEvent-windowID", offsetof( struct SDL_TextEditingEvent, windowID ), sizeof( Uint32 ) );
	swigStructField( "SDL_TextEditingEvent-type", offsetof( struct SDL_TextEditingEvent, type ), sizeof( Uint32 ) );
	swigStructField( "SDL_TextEditingEvent-text", offsetof( struct SDL_TextEditingEvent, text ), sizeof( char [(32)] ) );
	swigStructField( "SDL_TextEditingEvent-length", offsetof( struct SDL_TextEditingEvent, length ), sizeof( Sint32 ) );
	swigStructField( "SDL_TextEditingEvent-timestamp", offsetof( struct SDL_TextEditingEvent, timestamp ), sizeof( Uint32 ) );
	swigStructField( "SDL_TextEditingEvent-start", offsetof( struct SDL_TextEditingEvent, start ), sizeof( Sint32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct SDL_TextEditingEvent ) );

	swigComment("struct SDL_TextEditingExtEvent\n");
	printf( "begin-structure SDL_TextEditingExtEvent\n" );
	swigStructField( "SDL_TextEditingExtEvent-windowID", offsetof( struct SDL_TextEditingExtEvent, windowID ), sizeof( Uint32 ) );
	swigStructField( "SDL_TextEditingExtEvent-type", offsetof( struct SDL_TextEditingExtEvent, type ), sizeof( Uint32 ) );
	swigStructField( "SDL_TextEditingExtEvent-text", offsetof( struct SDL_TextEditingExtEvent, text ), sizeof( char * ) );
	swigStructField( "SDL_TextEditingExtEvent-length", offsetof( struct SDL_TextEditingExtEvent, length ), sizeof( Sint32 ) );
	swigStructField( "SDL_TextEditingExtEvent-timestamp", offsetof( struct SDL_TextEditingExtEvent, timestamp ), sizeof( Uint32 ) );
	swigStructField( "SDL_TextEditingExtEvent-start", offsetof( struct SDL_TextEditingExtEvent, start ), sizeof( Sint32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct SDL_TextEditingExtEvent ) );

	swigComment("struct SDL_TextInputEvent\n");
	printf( "begin-structure SDL_TextInputEvent\n" );
	swigStructField( "SDL_TextInputEvent-windowID", offsetof( struct SDL_TextInputEvent, windowID ), sizeof( Uint32 ) );
	swigStructField( "SDL_TextInputEvent-type", offsetof( struct SDL_TextInputEvent, type ), sizeof( Uint32 ) );
	swigStructField( "SDL_TextInputEvent-text", offsetof( struct SDL_TextInputEvent, text ), sizeof( char [(32)] ) );
	swigStructField( "SDL_TextInputEvent-timestamp", offsetof( struct SDL_TextInputEvent, timestamp ), sizeof( Uint32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct SDL_TextInputEvent ) );

	swigComment("struct SDL_MouseMotionEvent\n");
	printf( "begin-structure SDL_MouseMotionEvent\n" );
	swigStructField( "SDL_MouseMotionEvent-yrel", offsetof( struct SDL_MouseMotionEvent, yrel ), sizeof( Sint32 ) );
	swigStructField( "SDL_MouseMotionEvent-x", offsetof( struct SDL_MouseMotionEvent, x ), sizeof( Sint32 ) );
	swigStructField( "SDL_MouseMotionEvent-which", offsetof( struct SDL_MouseMotionEvent, which ), sizeof( Uint32 ) );
	swigStructField( "SDL_MouseMotionEvent-y", offsetof( struct SDL_MouseMotionEvent, y ), sizeof( Sint32 ) );
	swigStructField( "SDL_MouseMotionEvent-windowID", offsetof( struct SDL_MouseMotionEvent, windowID ), sizeof( Uint32 ) );
	swigStructField( "SDL_MouseMotionEvent-type", offsetof( struct SDL_MouseMotionEvent, type ), sizeof( Uint32 ) );
	swigStructField( "SDL_MouseMotionEvent-timestamp", offsetof( struct SDL_MouseMotionEvent, timestamp ), sizeof( Uint32 ) );
	swigStructField( "SDL_MouseMotionEvent-state", offsetof( struct SDL_MouseMotionEvent, state ), sizeof( Uint32 ) );
	swigStructField( "SDL_MouseMotionEvent-xrel", offsetof( struct SDL_MouseMotionEvent, xrel ), sizeof( Sint32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct SDL_MouseMotionEvent ) );

	swigComment("struct SDL_MouseButtonEvent\n");
	printf( "begin-structure SDL_MouseButtonEvent\n" );
	swigStructField( "SDL_MouseButtonEvent-x", offsetof( struct SDL_MouseButtonEvent, x ), sizeof( Sint32 ) );
	swigStructField( "SDL_MouseButtonEvent-which", offsetof( struct SDL_MouseButtonEvent, which ), sizeof( Uint32 ) );
	swigStructField( "SDL_MouseButtonEvent-y", offsetof( struct SDL_MouseButtonEvent, y ), sizeof( Sint32 ) );
	swigStructField( "SDL_MouseButtonEvent-windowID", offsetof( struct SDL_MouseButtonEvent, windowID ), sizeof( Uint32 ) );
	swigStructField( "SDL_MouseButtonEvent-button", offsetof( struct SDL_MouseButtonEvent, button ), sizeof( Uint8 ) );
	swigStructField( "SDL_MouseButtonEvent-type", offsetof( struct SDL_MouseButtonEvent, type ), sizeof( Uint32 ) );
	swigStructField( "SDL_MouseButtonEvent-clicks", offsetof( struct SDL_MouseButtonEvent, clicks ), sizeof( Uint8 ) );
	swigStructField( "SDL_MouseButtonEvent-padding1", offsetof( struct SDL_MouseButtonEvent, padding1 ), sizeof( Uint8 ) );
	swigStructField( "SDL_MouseButtonEvent-timestamp", offsetof( struct SDL_MouseButtonEvent, timestamp ), sizeof( Uint32 ) );
	swigStructField( "SDL_MouseButtonEvent-state", offsetof( struct SDL_MouseButtonEvent, state ), sizeof( Uint8 ) );
	printf( "drop %zu end-structure\n", sizeof( struct SDL_MouseButtonEvent ) );

	swigComment("struct SDL_MouseWheelEvent\n");
	printf( "begin-structure SDL_MouseWheelEvent\n" );
	swigStructField( "SDL_MouseWheelEvent-x", offsetof( struct SDL_MouseWheelEvent, x ), sizeof( Sint32 ) );
	swigStructField( "SDL_MouseWheelEvent-which", offsetof( struct SDL_MouseWheelEvent, which ), sizeof( Uint32 ) );
	swigStructField( "SDL_MouseWheelEvent-y", offsetof( struct SDL_MouseWheelEvent, y ), sizeof( Sint32 ) );
	swigStructField( "SDL_MouseWheelEvent-preciseX", offsetof( struct SDL_MouseWheelEvent, preciseX ), sizeof( float ) );
	swigStructField( "SDL_MouseWheelEvent-windowID", offsetof( struct SDL_MouseWheelEvent, windowID ), sizeof( Uint32 ) );
	swigStructField( "SDL_MouseWheelEvent-preciseY", offsetof( struct SDL_MouseWheelEvent, preciseY ), sizeof( float ) );
	swigStructField( "SDL_MouseWheelEvent-type", offsetof( struct SDL_MouseWheelEvent, type ), sizeof( Uint32 ) );
	swigStructField( "SDL_MouseWheelEvent-timestamp", offsetof( struct SDL_MouseWheelEvent, timestamp ), sizeof( Uint32 ) );
	swigStructField( "SDL_MouseWheelEvent-direction", offsetof( struct SDL_MouseWheelEvent, direction ), sizeof( Uint32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct SDL_MouseWheelEvent ) );

	swigComment("struct SDL_JoyAxisEvent\n");
	printf( "begin-structure SDL_JoyAxisEvent\n" );
	swigStructField( "SDL_JoyAxisEvent-padding4", offsetof( struct SDL_JoyAxisEvent, padding4 ), sizeof( Uint16 ) );
	swigStructField( "SDL_JoyAxisEvent-which", offsetof( struct SDL_JoyAxisEvent, which ), sizeof( SDL_JoystickID ) );
	swigStructField( "SDL_JoyAxisEvent-value", offsetof( struct SDL_JoyAxisEvent, value ), sizeof( Sint16 ) );
	swigStructField( "SDL_JoyAxisEvent-type", offsetof( struct SDL_JoyAxisEvent, type ), sizeof( Uint32 ) );
	swigStructField( "SDL_JoyAxisEvent-axis", offsetof( struct SDL_JoyAxisEvent, axis ), sizeof( Uint8 ) );
	swigStructField( "SDL_JoyAxisEvent-padding1", offsetof( struct SDL_JoyAxisEvent, padding1 ), sizeof( Uint8 ) );
	swigStructField( "SDL_JoyAxisEvent-timestamp", offsetof( struct SDL_JoyAxisEvent, timestamp ), sizeof( Uint32 ) );
	swigStructField( "SDL_JoyAxisEvent-padding2", offsetof( struct SDL_JoyAxisEvent, padding2 ), sizeof( Uint8 ) );
	swigStructField( "SDL_JoyAxisEvent-padding3", offsetof( struct SDL_JoyAxisEvent, padding3 ), sizeof( Uint8 ) );
	printf( "drop %zu end-structure\n", sizeof( struct SDL_JoyAxisEvent ) );

	swigComment("struct SDL_JoyBallEvent\n");
	printf( "begin-structure SDL_JoyBallEvent\n" );
	swigStructField( "SDL_JoyBallEvent-yrel", offsetof( struct SDL_JoyBallEvent, yrel ), sizeof( Sint16 ) );
	swigStructField( "SDL_JoyBallEvent-which", offsetof( struct SDL_JoyBallEvent, which ), sizeof( SDL_JoystickID ) );
	swigStructField( "SDL_JoyBallEvent-type", offsetof( struct SDL_JoyBallEvent, type ), sizeof( Uint32 ) );
	swigStructField( "SDL_JoyBallEvent-padding1", offsetof( struct SDL_JoyBallEvent, padding1 ), sizeof( Uint8 ) );
	swigStructField( "SDL_JoyBallEvent-timestamp", offsetof( struct SDL_JoyBallEvent, timestamp ), sizeof( Uint32 ) );
	swigStructField( "SDL_JoyBallEvent-padding2", offsetof( struct SDL_JoyBallEvent, padding2 ), sizeof( Uint8 ) );
	swigStructField( "SDL_JoyBallEvent-ball", offsetof( struct SDL_JoyBallEvent, ball ), sizeof( Uint8 ) );
	swigStructField( "SDL_JoyBallEvent-padding3", offsetof( struct SDL_JoyBallEvent, padding3 ), sizeof( Uint8 ) );
	swigStructField( "SDL_JoyBallEvent-xrel", offsetof( struct SDL_JoyBallEvent, xrel ), sizeof( Sint16 ) );
	printf( "drop %zu end-structure\n", sizeof( struct SDL_JoyBallEvent ) );

	swigComment("struct SDL_JoyHatEvent\n");
	printf( "begin-structure SDL_JoyHatEvent\n" );
	swigStructField( "SDL_JoyHatEvent-which", offsetof( struct SDL_JoyHatEvent, which ), sizeof( SDL_JoystickID ) );
	swigStructField( "SDL_JoyHatEvent-value", offsetof( struct SDL_JoyHatEvent, value ), sizeof( Uint8 ) );
	swigStructField( "SDL_JoyHatEvent-type", offsetof( struct SDL_JoyHatEvent, type ), sizeof( Uint32 ) );
	swigStructField( "SDL_JoyHatEvent-padding1", offsetof( struct SDL_JoyHatEvent, padding1 ), sizeof( Uint8 ) );
	swigStructField( "SDL_JoyHatEvent-timestamp", offsetof( struct SDL_JoyHatEvent, timestamp ), sizeof( Uint32 ) );
	swigStructField( "SDL_JoyHatEvent-hat", offsetof( struct SDL_JoyHatEvent, hat ), sizeof( Uint8 ) );
	swigStructField( "SDL_JoyHatEvent-padding2", offsetof( struct SDL_JoyHatEvent, padding2 ), sizeof( Uint8 ) );
	printf( "drop %zu end-structure\n", sizeof( struct SDL_JoyHatEvent ) );

	swigComment("struct SDL_JoyButtonEvent\n");
	printf( "begin-structure SDL_JoyButtonEvent\n" );
	swigStructField( "SDL_JoyButtonEvent-which", offsetof( struct SDL_JoyButtonEvent, which ), sizeof( SDL_JoystickID ) );
	swigStructField( "SDL_JoyButtonEvent-button", offsetof( struct SDL_JoyButtonEvent, button ), sizeof( Uint8 ) );
	swigStructField( "SDL_JoyButtonEvent-type", offsetof( struct SDL_JoyButtonEvent, type ), sizeof( Uint32 ) );
	swigStructField( "SDL_JoyButtonEvent-padding1", offsetof( struct SDL_JoyButtonEvent, padding1 ), sizeof( Uint8 ) );
	swigStructField( "SDL_JoyButtonEvent-timestamp", offsetof( struct SDL_JoyButtonEvent, timestamp ), sizeof( Uint32 ) );
	swigStructField( "SDL_JoyButtonEvent-state", offsetof( struct SDL_JoyButtonEvent, state ), sizeof( Uint8 ) );
	swigStructField( "SDL_JoyButtonEvent-padding2", offsetof( struct SDL_JoyButtonEvent, padding2 ), sizeof( Uint8 ) );
	printf( "drop %zu end-structure\n", sizeof( struct SDL_JoyButtonEvent ) );

	swigComment("struct SDL_JoyDeviceEvent\n");
	printf( "begin-structure SDL_JoyDeviceEvent\n" );
	swigStructField( "SDL_JoyDeviceEvent-which", offsetof( struct SDL_JoyDeviceEvent, which ), sizeof( Sint32 ) );
	swigStructField( "SDL_JoyDeviceEvent-type", offsetof( struct SDL_JoyDeviceEvent, type ), sizeof( Uint32 ) );
	swigStructField( "SDL_JoyDeviceEvent-timestamp", offsetof( struct SDL_JoyDeviceEvent, timestamp ), sizeof( Uint32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct SDL_JoyDeviceEvent ) );

	swigComment("struct SDL_ControllerAxisEvent\n");
	printf( "begin-structure SDL_ControllerAxisEvent\n" );
	swigStructField( "SDL_ControllerAxisEvent-padding4", offsetof( struct SDL_ControllerAxisEvent, padding4 ), sizeof( Uint16 ) );
	swigStructField( "SDL_ControllerAxisEvent-which", offsetof( struct SDL_ControllerAxisEvent, which ), sizeof( SDL_JoystickID ) );
	swigStructField( "SDL_ControllerAxisEvent-value", offsetof( struct SDL_ControllerAxisEvent, value ), sizeof( Sint16 ) );
	swigStructField( "SDL_ControllerAxisEvent-type", offsetof( struct SDL_ControllerAxisEvent, type ), sizeof( Uint32 ) );
	swigStructField( "SDL_ControllerAxisEvent-axis", offsetof( struct SDL_ControllerAxisEvent, axis ), sizeof( Uint8 ) );
	swigStructField( "SDL_ControllerAxisEvent-padding1", offsetof( struct SDL_ControllerAxisEvent, padding1 ), sizeof( Uint8 ) );
	swigStructField( "SDL_ControllerAxisEvent-timestamp", offsetof( struct SDL_ControllerAxisEvent, timestamp ), sizeof( Uint32 ) );
	swigStructField( "SDL_ControllerAxisEvent-padding2", offsetof( struct SDL_ControllerAxisEvent, padding2 ), sizeof( Uint8 ) );
	swigStructField( "SDL_ControllerAxisEvent-padding3", offsetof( struct SDL_ControllerAxisEvent, padding3 ), sizeof( Uint8 ) );
	printf( "drop %zu end-structure\n", sizeof( struct SDL_ControllerAxisEvent ) );

	swigComment("struct SDL_ControllerButtonEvent\n");
	printf( "begin-structure SDL_ControllerButtonEvent\n" );
	swigStructField( "SDL_ControllerButtonEvent-which", offsetof( struct SDL_ControllerButtonEvent, which ), sizeof( SDL_JoystickID ) );
	swigStructField( "SDL_ControllerButtonEvent-button", offsetof( struct SDL_ControllerButtonEvent, button ), sizeof( Uint8 ) );
	swigStructField( "SDL_ControllerButtonEvent-type", offsetof( struct SDL_ControllerButtonEvent, type ), sizeof( Uint32 ) );
	swigStructField( "SDL_ControllerButtonEvent-padding1", offsetof( struct SDL_ControllerButtonEvent, padding1 ), sizeof( Uint8 ) );
	swigStructField( "SDL_ControllerButtonEvent-timestamp", offsetof( struct SDL_ControllerButtonEvent, timestamp ), sizeof( Uint32 ) );
	swigStructField( "SDL_ControllerButtonEvent-state", offsetof( struct SDL_ControllerButtonEvent, state ), sizeof( Uint8 ) );
	swigStructField( "SDL_ControllerButtonEvent-padding2", offsetof( struct SDL_ControllerButtonEvent, padding2 ), sizeof( Uint8 ) );
	printf( "drop %zu end-structure\n", sizeof( struct SDL_ControllerButtonEvent ) );

	swigComment("struct SDL_ControllerDeviceEvent\n");
	printf( "begin-structure SDL_ControllerDeviceEvent\n" );
	swigStructField( "SDL_ControllerDeviceEvent-which", offsetof( struct SDL_ControllerDeviceEvent, which ), sizeof( Sint32 ) );
	swigStructField( "SDL_ControllerDeviceEvent-type", offsetof( struct SDL_ControllerDeviceEvent, type ), sizeof( Uint32 ) );
	swigStructField( "SDL_ControllerDeviceEvent-timestamp", offsetof( struct SDL_ControllerDeviceEvent, timestamp ), sizeof( Uint32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct SDL_ControllerDeviceEvent ) );

	swigComment("struct SDL_ControllerTouchpadEvent\n");
	printf( "begin-structure SDL_ControllerTouchpadEvent\n" );
	swigStructField( "SDL_ControllerTouchpadEvent-finger", offsetof( struct SDL_ControllerTouchpadEvent, finger ), sizeof( Sint32 ) );
	swigStructField( "SDL_ControllerTouchpadEvent-touchpad", offsetof( struct SDL_ControllerTouchpadEvent, touchpad ), sizeof( Sint32 ) );
	swigStructField( "SDL_ControllerTouchpadEvent-x", offsetof( struct SDL_ControllerTouchpadEvent, x ), sizeof( float ) );
	swigStructField( "SDL_ControllerTouchpadEvent-which", offsetof( struct SDL_ControllerTouchpadEvent, which ), sizeof( SDL_JoystickID ) );
	swigStructField( "SDL_ControllerTouchpadEvent-y", offsetof( struct SDL_ControllerTouchpadEvent, y ), sizeof( float ) );
	swigStructField( "SDL_ControllerTouchpadEvent-type", offsetof( struct SDL_ControllerTouchpadEvent, type ), sizeof( Uint32 ) );
	swigStructField( "SDL_ControllerTouchpadEvent-timestamp", offsetof( struct SDL_ControllerTouchpadEvent, timestamp ), sizeof( Uint32 ) );
	swigStructField( "SDL_ControllerTouchpadEvent-pressure", offsetof( struct SDL_ControllerTouchpadEvent, pressure ), sizeof( float ) );
	printf( "drop %zu end-structure\n", sizeof( struct SDL_ControllerTouchpadEvent ) );

	swigComment("struct SDL_ControllerSensorEvent\n");
	printf( "begin-structure SDL_ControllerSensorEvent\n" );
	swigStructField( "SDL_ControllerSensorEvent-data", offsetof( struct SDL_ControllerSensorEvent, data ), sizeof( float [3] ) );
	swigStructField( "SDL_ControllerSensorEvent-which", offsetof( struct SDL_ControllerSensorEvent, which ), sizeof( SDL_JoystickID ) );
	swigStructField( "SDL_ControllerSensorEvent-type", offsetof( struct SDL_ControllerSensorEvent, type ), sizeof( Uint32 ) );
	swigStructField( "SDL_ControllerSensorEvent-sensor", offsetof( struct SDL_ControllerSensorEvent, sensor ), sizeof( Sint32 ) );
	swigStructField( "SDL_ControllerSensorEvent-timestamp", offsetof( struct SDL_ControllerSensorEvent, timestamp ), sizeof( Uint32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct SDL_ControllerSensorEvent ) );

	swigComment("struct SDL_AudioDeviceEvent\n");
	printf( "begin-structure SDL_AudioDeviceEvent\n" );
	swigStructField( "SDL_AudioDeviceEvent-which", offsetof( struct SDL_AudioDeviceEvent, which ), sizeof( Uint32 ) );
	swigStructField( "SDL_AudioDeviceEvent-type", offsetof( struct SDL_AudioDeviceEvent, type ), sizeof( Uint32 ) );
	swigStructField( "SDL_AudioDeviceEvent-padding1", offsetof( struct SDL_AudioDeviceEvent, padding1 ), sizeof( Uint8 ) );
	swigStructField( "SDL_AudioDeviceEvent-timestamp", offsetof( struct SDL_AudioDeviceEvent, timestamp ), sizeof( Uint32 ) );
	swigStructField( "SDL_AudioDeviceEvent-padding2", offsetof( struct SDL_AudioDeviceEvent, padding2 ), sizeof( Uint8 ) );
	swigStructField( "SDL_AudioDeviceEvent-iscapture", offsetof( struct SDL_AudioDeviceEvent, iscapture ), sizeof( Uint8 ) );
	swigStructField( "SDL_AudioDeviceEvent-padding3", offsetof( struct SDL_AudioDeviceEvent, padding3 ), sizeof( Uint8 ) );
	printf( "drop %zu end-structure\n", sizeof( struct SDL_AudioDeviceEvent ) );

	swigComment("struct SDL_TouchFingerEvent\n");
	printf( "begin-structure SDL_TouchFingerEvent\n" );
	swigStructField( "SDL_TouchFingerEvent-touchId", offsetof( struct SDL_TouchFingerEvent, touchId ), sizeof( SDL_TouchID ) );
	swigStructField( "SDL_TouchFingerEvent-x", offsetof( struct SDL_TouchFingerEvent, x ), sizeof( float ) );
	swigStructField( "SDL_TouchFingerEvent-y", offsetof( struct SDL_TouchFingerEvent, y ), sizeof( float ) );
	swigStructField( "SDL_TouchFingerEvent-dx", offsetof( struct SDL_TouchFingerEvent, dx ), sizeof( float ) );
	swigStructField( "SDL_TouchFingerEvent-dy", offsetof( struct SDL_TouchFingerEvent, dy ), sizeof( float ) );
	swigStructField( "SDL_TouchFingerEvent-windowID", offsetof( struct SDL_TouchFingerEvent, windowID ), sizeof( Uint32 ) );
	swigStructField( "SDL_TouchFingerEvent-type", offsetof( struct SDL_TouchFingerEvent, type ), sizeof( Uint32 ) );
	swigStructField( "SDL_TouchFingerEvent-timestamp", offsetof( struct SDL_TouchFingerEvent, timestamp ), sizeof( Uint32 ) );
	swigStructField( "SDL_TouchFingerEvent-pressure", offsetof( struct SDL_TouchFingerEvent, pressure ), sizeof( float ) );
	swigStructField( "SDL_TouchFingerEvent-fingerId", offsetof( struct SDL_TouchFingerEvent, fingerId ), sizeof( SDL_FingerID ) );
	printf( "drop %zu end-structure\n", sizeof( struct SDL_TouchFingerEvent ) );

	swigComment("struct SDL_MultiGestureEvent\n");
	printf( "begin-structure SDL_MultiGestureEvent\n" );
	swigStructField( "SDL_MultiGestureEvent-touchId", offsetof( struct SDL_MultiGestureEvent, touchId ), sizeof( SDL_TouchID ) );
	swigStructField( "SDL_MultiGestureEvent-dTheta", offsetof( struct SDL_MultiGestureEvent, dTheta ), sizeof( float ) );
	swigStructField( "SDL_MultiGestureEvent-dDist", offsetof( struct SDL_MultiGestureEvent, dDist ), sizeof( float ) );
	swigStructField( "SDL_MultiGestureEvent-x", offsetof( struct SDL_MultiGestureEvent, x ), sizeof( float ) );
	swigStructField( "SDL_MultiGestureEvent-y", offsetof( struct SDL_MultiGestureEvent, y ), sizeof( float ) );
	swigStructField( "SDL_MultiGestureEvent-padding", offsetof( struct SDL_MultiGestureEvent, padding ), sizeof( Uint16 ) );
	swigStructField( "SDL_MultiGestureEvent-type", offsetof( struct SDL_MultiGestureEvent, type ), sizeof( Uint32 ) );
	swigStructField( "SDL_MultiGestureEvent-timestamp", offsetof( struct SDL_MultiGestureEvent, timestamp ), sizeof( Uint32 ) );
	swigStructField( "SDL_MultiGestureEvent-numFingers", offsetof( struct SDL_MultiGestureEvent, numFingers ), sizeof( Uint16 ) );
	printf( "drop %zu end-structure\n", sizeof( struct SDL_MultiGestureEvent ) );

	swigComment("struct SDL_DollarGestureEvent\n");
	printf( "begin-structure SDL_DollarGestureEvent\n" );
	swigStructField( "SDL_DollarGestureEvent-touchId", offsetof( struct SDL_DollarGestureEvent, touchId ), sizeof( SDL_TouchID ) );
	swigStructField( "SDL_DollarGestureEvent-x", offsetof( struct SDL_DollarGestureEvent, x ), sizeof( float ) );
	swigStructField( "SDL_DollarGestureEvent-error", offsetof( struct SDL_DollarGestureEvent, error ), sizeof( float ) );
	swigStructField( "SDL_DollarGestureEvent-y", offsetof( struct SDL_DollarGestureEvent, y ), sizeof( float ) );
	swigStructField( "SDL_DollarGestureEvent-type", offsetof( struct SDL_DollarGestureEvent, type ), sizeof( Uint32 ) );
	swigStructField( "SDL_DollarGestureEvent-timestamp", offsetof( struct SDL_DollarGestureEvent, timestamp ), sizeof( Uint32 ) );
	swigStructField( "SDL_DollarGestureEvent-gestureId", offsetof( struct SDL_DollarGestureEvent, gestureId ), sizeof( SDL_GestureID ) );
	swigStructField( "SDL_DollarGestureEvent-numFingers", offsetof( struct SDL_DollarGestureEvent, numFingers ), sizeof( Uint32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct SDL_DollarGestureEvent ) );

	swigComment("struct SDL_DropEvent\n");
	printf( "begin-structure SDL_DropEvent\n" );
	swigStructField( "SDL_DropEvent-windowID", offsetof( struct SDL_DropEvent, windowID ), sizeof( Uint32 ) );
	swigStructField( "SDL_DropEvent-type", offsetof( struct SDL_DropEvent, type ), sizeof( Uint32 ) );
	swigStructField( "SDL_DropEvent-timestamp", offsetof( struct SDL_DropEvent, timestamp ), sizeof( Uint32 ) );
	swigStructField( "SDL_DropEvent-file", offsetof( struct SDL_DropEvent, file ), sizeof( char * ) );
	printf( "drop %zu end-structure\n", sizeof( struct SDL_DropEvent ) );

	swigComment("struct SDL_SensorEvent\n");
	printf( "begin-structure SDL_SensorEvent\n" );
	swigStructField( "SDL_SensorEvent-data", offsetof( struct SDL_SensorEvent, data ), sizeof( float [6] ) );
	swigStructField( "SDL_SensorEvent-which", offsetof( struct SDL_SensorEvent, which ), sizeof( Sint32 ) );
	swigStructField( "SDL_SensorEvent-type", offsetof( struct SDL_SensorEvent, type ), sizeof( Uint32 ) );
	swigStructField( "SDL_SensorEvent-timestamp", offsetof( struct SDL_SensorEvent, timestamp ), sizeof( Uint32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct SDL_SensorEvent ) );

	swigComment("struct SDL_QuitEvent\n");
	printf( "begin-structure SDL_QuitEvent\n" );
	swigStructField( "SDL_QuitEvent-type", offsetof( struct SDL_QuitEvent, type ), sizeof( Uint32 ) );
	swigStructField( "SDL_QuitEvent-timestamp", offsetof( struct SDL_QuitEvent, timestamp ), sizeof( Uint32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct SDL_QuitEvent ) );

	swigComment("struct SDL_OSEvent\n");
	printf( "begin-structure SDL_OSEvent\n" );
	swigStructField( "SDL_OSEvent-type", offsetof( struct SDL_OSEvent, type ), sizeof( Uint32 ) );
	swigStructField( "SDL_OSEvent-timestamp", offsetof( struct SDL_OSEvent, timestamp ), sizeof( Uint32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct SDL_OSEvent ) );

	swigComment("struct SDL_UserEvent\n");
	printf( "begin-structure SDL_UserEvent\n" );
	swigStructField( "SDL_UserEvent-windowID", offsetof( struct SDL_UserEvent, windowID ), sizeof( Uint32 ) );
	swigStructField( "SDL_UserEvent-code", offsetof( struct SDL_UserEvent, code ), sizeof( Sint32 ) );
	swigStructField( "SDL_UserEvent-type", offsetof( struct SDL_UserEvent, type ), sizeof( Uint32 ) );
	swigStructField( "SDL_UserEvent-data1", offsetof( struct SDL_UserEvent, data1 ), sizeof( void * ) );
	swigStructField( "SDL_UserEvent-timestamp", offsetof( struct SDL_UserEvent, timestamp ), sizeof( Uint32 ) );
	swigStructField( "SDL_UserEvent-data2", offsetof( struct SDL_UserEvent, data2 ), sizeof( void * ) );
	printf( "drop %zu end-structure\n", sizeof( struct SDL_UserEvent ) );

	swigComment("struct SDL_SysWMEvent\n");
	printf( "begin-structure SDL_SysWMEvent\n" );
	swigStructField( "SDL_SysWMEvent-type", offsetof( struct SDL_SysWMEvent, type ), sizeof( Uint32 ) );
	swigStructField( "SDL_SysWMEvent-msg", offsetof( struct SDL_SysWMEvent, msg ), sizeof( SDL_SysWMmsg * ) );
	swigStructField( "SDL_SysWMEvent-timestamp", offsetof( struct SDL_SysWMEvent, timestamp ), sizeof( Uint32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct SDL_SysWMEvent ) );

	swigComment("union SDL_Event\n");
	printf( "begin-structure SDL_Event\n" );
	swigStructField( "SDL_Event-jhat", offsetof( union SDL_Event, jhat ), sizeof( SDL_JoyHatEvent ) );
	swigStructField( "SDL_Event-window", offsetof( union SDL_Event, window ), sizeof( SDL_WindowEvent ) );
	swigStructField( "SDL_Event-cdevice", offsetof( union SDL_Event, cdevice ), sizeof( SDL_ControllerDeviceEvent ) );
	swigStructField( "SDL_Event-adevice", offsetof( union SDL_Event, adevice ), sizeof( SDL_AudioDeviceEvent ) );
	swigStructField( "SDL_Event-sensor", offsetof( union SDL_Event, sensor ), sizeof( SDL_SensorEvent ) );
	swigStructField( "SDL_Event-jball", offsetof( union SDL_Event, jball ), sizeof( SDL_JoyBallEvent ) );
	swigStructField( "SDL_Event-caxis", offsetof( union SDL_Event, caxis ), sizeof( SDL_ControllerAxisEvent ) );
	swigStructField( "SDL_Event-button", offsetof( union SDL_Event, button ), sizeof( SDL_MouseButtonEvent ) );
	swigStructField( "SDL_Event-jbutton", offsetof( union SDL_Event, jbutton ), sizeof( SDL_JoyButtonEvent ) );
	swigStructField( "SDL_Event-csensor", offsetof( union SDL_Event, csensor ), sizeof( SDL_ControllerSensorEvent ) );
	swigStructField( "SDL_Event-wheel", offsetof( union SDL_Event, wheel ), sizeof( SDL_MouseWheelEvent ) );
	swigStructField( "SDL_Event-motion", offsetof( union SDL_Event, motion ), sizeof( SDL_MouseMotionEvent ) );
	swigStructField( "SDL_Event-mgesture", offsetof( union SDL_Event, mgesture ), sizeof( SDL_MultiGestureEvent ) );
	swigStructField( "SDL_Event-dgesture", offsetof( union SDL_Event, dgesture ), sizeof( SDL_DollarGestureEvent ) );
	swigStructField( "SDL_Event-drop", offsetof( union SDL_Event, drop ), sizeof( SDL_DropEvent ) );
	swigStructField( "SDL_Event-common", offsetof( union SDL_Event, common ), sizeof( SDL_CommonEvent ) );
	swigStructField( "SDL_Event-key", offsetof( union SDL_Event, key ), sizeof( SDL_KeyboardEvent ) );
	swigStructField( "SDL_Event-edit", offsetof( union SDL_Event, edit ), sizeof( SDL_TextEditingEvent ) );
	swigStructField( "SDL_Event-display", offsetof( union SDL_Event, display ), sizeof( SDL_DisplayEvent ) );
	swigStructField( "SDL_Event-cbutton", offsetof( union SDL_Event, cbutton ), sizeof( SDL_ControllerButtonEvent ) );
	swigStructField( "SDL_Event-ctouchpad", offsetof( union SDL_Event, ctouchpad ), sizeof( SDL_ControllerTouchpadEvent ) );
	swigStructField( "SDL_Event-tfinger", offsetof( union SDL_Event, tfinger ), sizeof( SDL_TouchFingerEvent ) );
	swigStructField( "SDL_Event-editExt", offsetof( union SDL_Event, editExt ), sizeof( SDL_TextEditingExtEvent ) );
	swigStructField( "SDL_Event-type", offsetof( union SDL_Event, type ), sizeof( Uint32 ) );
	swigStructField( "SDL_Event-jaxis", offsetof( union SDL_Event, jaxis ), sizeof( SDL_JoyAxisEvent ) );
	swigStructField( "SDL_Event-jdevice", offsetof( union SDL_Event, jdevice ), sizeof( SDL_JoyDeviceEvent ) );
	swigStructField( "SDL_Event-syswm", offsetof( union SDL_Event, syswm ), sizeof( SDL_SysWMEvent ) );
	swigStructField( "SDL_Event-padding", offsetof( union SDL_Event, padding ), sizeof( Uint8 [sizeof(void *) <= 8?56:sizeof(void *)==16?64:3*sizeof(void *)] ) );
	swigStructField( "SDL_Event-quit", offsetof( union SDL_Event, quit ), sizeof( SDL_QuitEvent ) );
	swigStructField( "SDL_Event-user", offsetof( union SDL_Event, user ), sizeof( SDL_UserEvent ) );
	swigStructField( "SDL_Event-text", offsetof( union SDL_Event, text ), sizeof( SDL_TextInputEvent ) );
	printf( "drop %zu end-structure\n", sizeof( union SDL_Event ) );

	swigComment("struct SDL_HapticDirection\n");
	printf( "begin-structure SDL_HapticDirection\n" );
	swigStructField( "SDL_HapticDirection-type", offsetof( struct SDL_HapticDirection, type ), sizeof( Uint8 ) );
	swigStructField( "SDL_HapticDirection-dir", offsetof( struct SDL_HapticDirection, dir ), sizeof( Sint32 [3] ) );
	printf( "drop %zu end-structure\n", sizeof( struct SDL_HapticDirection ) );

	swigComment("struct SDL_HapticConstant\n");
	printf( "begin-structure SDL_HapticConstant\n" );
	swigStructField( "SDL_HapticConstant-level", offsetof( struct SDL_HapticConstant, level ), sizeof( Sint16 ) );
	swigStructField( "SDL_HapticConstant-delay", offsetof( struct SDL_HapticConstant, delay ), sizeof( Uint16 ) );
	swigStructField( "SDL_HapticConstant-button", offsetof( struct SDL_HapticConstant, button ), sizeof( Uint16 ) );
	swigStructField( "SDL_HapticConstant-interval", offsetof( struct SDL_HapticConstant, interval ), sizeof( Uint16 ) );
	swigStructField( "SDL_HapticConstant-attack_length", offsetof( struct SDL_HapticConstant, attack_length ), sizeof( Uint16 ) );
	swigStructField( "SDL_HapticConstant-fade_length", offsetof( struct SDL_HapticConstant, fade_length ), sizeof( Uint16 ) );
	swigStructField( "SDL_HapticConstant-type", offsetof( struct SDL_HapticConstant, type ), sizeof( Uint16 ) );
	swigStructField( "SDL_HapticConstant-length", offsetof( struct SDL_HapticConstant, length ), sizeof( Uint32 ) );
	swigStructField( "SDL_HapticConstant-attack_level", offsetof( struct SDL_HapticConstant, attack_level ), sizeof( Uint16 ) );
	swigStructField( "SDL_HapticConstant-fade_level", offsetof( struct SDL_HapticConstant, fade_level ), sizeof( Uint16 ) );
	swigStructField( "SDL_HapticConstant-direction", offsetof( struct SDL_HapticConstant, direction ), sizeof( SDL_HapticDirection ) );
	printf( "drop %zu end-structure\n", sizeof( struct SDL_HapticConstant ) );

	swigComment("struct SDL_HapticPeriodic\n");
	printf( "begin-structure SDL_HapticPeriodic\n" );
	swigStructField( "SDL_HapticPeriodic-direction", offsetof( struct SDL_HapticPeriodic, direction ), sizeof( SDL_HapticDirection ) );
	swigStructField( "SDL_HapticPeriodic-length", offsetof( struct SDL_HapticPeriodic, length ), sizeof( Uint32 ) );
	swigStructField( "SDL_HapticPeriodic-fade_level", offsetof( struct SDL_HapticPeriodic, fade_level ), sizeof( Uint16 ) );
	swigStructField( "SDL_HapticPeriodic-attack_level", offsetof( struct SDL_HapticPeriodic, attack_level ), sizeof( Uint16 ) );
	swigStructField( "SDL_HapticPeriodic-interval", offsetof( struct SDL_HapticPeriodic, interval ), sizeof( Uint16 ) );
	swigStructField( "SDL_HapticPeriodic-button", offsetof( struct SDL_HapticPeriodic, button ), sizeof( Uint16 ) );
	swigStructField( "SDL_HapticPeriodic-fade_length", offsetof( struct SDL_HapticPeriodic, fade_length ), sizeof( Uint16 ) );
	swigStructField( "SDL_HapticPeriodic-attack_length", offsetof( struct SDL_HapticPeriodic, attack_length ), sizeof( Uint16 ) );
	swigStructField( "SDL_HapticPeriodic-offset", offsetof( struct SDL_HapticPeriodic, offset ), sizeof( Sint16 ) );
	swigStructField( "SDL_HapticPeriodic-magnitude", offsetof( struct SDL_HapticPeriodic, magnitude ), sizeof( Sint16 ) );
	swigStructField( "SDL_HapticPeriodic-period", offsetof( struct SDL_HapticPeriodic, period ), sizeof( Uint16 ) );
	swigStructField( "SDL_HapticPeriodic-type", offsetof( struct SDL_HapticPeriodic, type ), sizeof( Uint16 ) );
	swigStructField( "SDL_HapticPeriodic-phase", offsetof( struct SDL_HapticPeriodic, phase ), sizeof( Uint16 ) );
	swigStructField( "SDL_HapticPeriodic-delay", offsetof( struct SDL_HapticPeriodic, delay ), sizeof( Uint16 ) );
	printf( "drop %zu end-structure\n", sizeof( struct SDL_HapticPeriodic ) );

	swigComment("struct SDL_HapticCondition\n");
	printf( "begin-structure SDL_HapticCondition\n" );
	swigStructField( "SDL_HapticCondition-right_sat", offsetof( struct SDL_HapticCondition, right_sat ), sizeof( Uint16 [3] ) );
	swigStructField( "SDL_HapticCondition-right_coeff", offsetof( struct SDL_HapticCondition, right_coeff ), sizeof( Sint16 [3] ) );
	swigStructField( "SDL_HapticCondition-left_coeff", offsetof( struct SDL_HapticCondition, left_coeff ), sizeof( Sint16 [3] ) );
	swigStructField( "SDL_HapticCondition-delay", offsetof( struct SDL_HapticCondition, delay ), sizeof( Uint16 ) );
	swigStructField( "SDL_HapticCondition-deadband", offsetof( struct SDL_HapticCondition, deadband ), sizeof( Uint16 [3] ) );
	swigStructField( "SDL_HapticCondition-button", offsetof( struct SDL_HapticCondition, button ), sizeof( Uint16 ) );
	swigStructField( "SDL_HapticCondition-interval", offsetof( struct SDL_HapticCondition, interval ), sizeof( Uint16 ) );
	swigStructField( "SDL_HapticCondition-left_sat", offsetof( struct SDL_HapticCondition, left_sat ), sizeof( Uint16 [3] ) );
	swigStructField( "SDL_HapticCondition-type", offsetof( struct SDL_HapticCondition, type ), sizeof( Uint16 ) );
	swigStructField( "SDL_HapticCondition-length", offsetof( struct SDL_HapticCondition, length ), sizeof( Uint32 ) );
	swigStructField( "SDL_HapticCondition-center", offsetof( struct SDL_HapticCondition, center ), sizeof( Sint16 [3] ) );
	swigStructField( "SDL_HapticCondition-direction", offsetof( struct SDL_HapticCondition, direction ), sizeof( SDL_HapticDirection ) );
	printf( "drop %zu end-structure\n", sizeof( struct SDL_HapticCondition ) );

	swigComment("struct SDL_HapticRamp\n");
	printf( "begin-structure SDL_HapticRamp\n" );
	swigStructField( "SDL_HapticRamp-end", offsetof( struct SDL_HapticRamp, end ), sizeof( Sint16 ) );
	swigStructField( "SDL_HapticRamp-delay", offsetof( struct SDL_HapticRamp, delay ), sizeof( Uint16 ) );
	swigStructField( "SDL_HapticRamp-button", offsetof( struct SDL_HapticRamp, button ), sizeof( Uint16 ) );
	swigStructField( "SDL_HapticRamp-interval", offsetof( struct SDL_HapticRamp, interval ), sizeof( Uint16 ) );
	swigStructField( "SDL_HapticRamp-attack_length", offsetof( struct SDL_HapticRamp, attack_length ), sizeof( Uint16 ) );
	swigStructField( "SDL_HapticRamp-fade_length", offsetof( struct SDL_HapticRamp, fade_length ), sizeof( Uint16 ) );
	swigStructField( "SDL_HapticRamp-type", offsetof( struct SDL_HapticRamp, type ), sizeof( Uint16 ) );
	swigStructField( "SDL_HapticRamp-length", offsetof( struct SDL_HapticRamp, length ), sizeof( Uint32 ) );
	swigStructField( "SDL_HapticRamp-start", offsetof( struct SDL_HapticRamp, start ), sizeof( Sint16 ) );
	swigStructField( "SDL_HapticRamp-attack_level", offsetof( struct SDL_HapticRamp, attack_level ), sizeof( Uint16 ) );
	swigStructField( "SDL_HapticRamp-fade_level", offsetof( struct SDL_HapticRamp, fade_level ), sizeof( Uint16 ) );
	swigStructField( "SDL_HapticRamp-direction", offsetof( struct SDL_HapticRamp, direction ), sizeof( SDL_HapticDirection ) );
	printf( "drop %zu end-structure\n", sizeof( struct SDL_HapticRamp ) );

	swigComment("struct SDL_HapticLeftRight\n");
	printf( "begin-structure SDL_HapticLeftRight\n" );
	swigStructField( "SDL_HapticLeftRight-type", offsetof( struct SDL_HapticLeftRight, type ), sizeof( Uint16 ) );
	swigStructField( "SDL_HapticLeftRight-length", offsetof( struct SDL_HapticLeftRight, length ), sizeof( Uint32 ) );
	swigStructField( "SDL_HapticLeftRight-large_magnitude", offsetof( struct SDL_HapticLeftRight, large_magnitude ), sizeof( Uint16 ) );
	swigStructField( "SDL_HapticLeftRight-small_magnitude", offsetof( struct SDL_HapticLeftRight, small_magnitude ), sizeof( Uint16 ) );
	printf( "drop %zu end-structure\n", sizeof( struct SDL_HapticLeftRight ) );

	swigComment("struct SDL_HapticCustom\n");
	printf( "begin-structure SDL_HapticCustom\n" );
	swigStructField( "SDL_HapticCustom-direction", offsetof( struct SDL_HapticCustom, direction ), sizeof( SDL_HapticDirection ) );
	swigStructField( "SDL_HapticCustom-length", offsetof( struct SDL_HapticCustom, length ), sizeof( Uint32 ) );
	swigStructField( "SDL_HapticCustom-fade_level", offsetof( struct SDL_HapticCustom, fade_level ), sizeof( Uint16 ) );
	swigStructField( "SDL_HapticCustom-attack_level", offsetof( struct SDL_HapticCustom, attack_level ), sizeof( Uint16 ) );
	swigStructField( "SDL_HapticCustom-interval", offsetof( struct SDL_HapticCustom, interval ), sizeof( Uint16 ) );
	swigStructField( "SDL_HapticCustom-button", offsetof( struct SDL_HapticCustom, button ), sizeof( Uint16 ) );
	swigStructField( "SDL_HapticCustom-samples", offsetof( struct SDL_HapticCustom, samples ), sizeof( Uint16 ) );
	swigStructField( "SDL_HapticCustom-fade_length", offsetof( struct SDL_HapticCustom, fade_length ), sizeof( Uint16 ) );
	swigStructField( "SDL_HapticCustom-attack_length", offsetof( struct SDL_HapticCustom, attack_length ), sizeof( Uint16 ) );
	swigStructField( "SDL_HapticCustom-channels", offsetof( struct SDL_HapticCustom, channels ), sizeof( Uint8 ) );
	swigStructField( "SDL_HapticCustom-period", offsetof( struct SDL_HapticCustom, period ), sizeof( Uint16 ) );
	swigStructField( "SDL_HapticCustom-type", offsetof( struct SDL_HapticCustom, type ), sizeof( Uint16 ) );
	swigStructField( "SDL_HapticCustom-delay", offsetof( struct SDL_HapticCustom, delay ), sizeof( Uint16 ) );
	swigStructField( "SDL_HapticCustom-data", offsetof( struct SDL_HapticCustom, data ), sizeof( Uint16 * ) );
	printf( "drop %zu end-structure\n", sizeof( struct SDL_HapticCustom ) );

	swigComment("union SDL_HapticEffect\n");
	printf( "begin-structure SDL_HapticEffect\n" );
	swigStructField( "SDL_HapticEffect-condition", offsetof( union SDL_HapticEffect, condition ), sizeof( SDL_HapticCondition ) );
	swigStructField( "SDL_HapticEffect-ramp", offsetof( union SDL_HapticEffect, ramp ), sizeof( SDL_HapticRamp ) );
	swigStructField( "SDL_HapticEffect-constant", offsetof( union SDL_HapticEffect, constant ), sizeof( SDL_HapticConstant ) );
	swigStructField( "SDL_HapticEffect-leftright", offsetof( union SDL_HapticEffect, leftright ), sizeof( SDL_HapticLeftRight ) );
	swigStructField( "SDL_HapticEffect-custom", offsetof( union SDL_HapticEffect, custom ), sizeof( SDL_HapticCustom ) );
	swigStructField( "SDL_HapticEffect-type", offsetof( union SDL_HapticEffect, type ), sizeof( Uint16 ) );
	swigStructField( "SDL_HapticEffect-periodic", offsetof( union SDL_HapticEffect, periodic ), sizeof( SDL_HapticPeriodic ) );
	printf( "drop %zu end-structure\n", sizeof( union SDL_HapticEffect ) );

	swigComment("struct SDL_hid_device_info\n");
	printf( "begin-structure SDL_hid_device_info\n" );
	swigStructField( "SDL_hid_device_info-interface_protocol", offsetof( struct SDL_hid_device_info, interface_protocol ), sizeof( int ) );
	swigStructField( "SDL_hid_device_info-interface_class", offsetof( struct SDL_hid_device_info, interface_class ), sizeof( int ) );
	swigStructField( "SDL_hid_device_info-interface_number", offsetof( struct SDL_hid_device_info, interface_number ), sizeof( int ) );
	swigStructField( "SDL_hid_device_info-release_number", offsetof( struct SDL_hid_device_info, release_number ), sizeof( unsigned short ) );
	swigStructField( "SDL_hid_device_info-serial_number", offsetof( struct SDL_hid_device_info, serial_number ), sizeof( wchar_t * ) );
	swigStructField( "SDL_hid_device_info-path", offsetof( struct SDL_hid_device_info, path ), sizeof( char * ) );
	swigStructField( "SDL_hid_device_info-product_string", offsetof( struct SDL_hid_device_info, product_string ), sizeof( wchar_t * ) );
	swigStructField( "SDL_hid_device_info-manufacturer_string", offsetof( struct SDL_hid_device_info, manufacturer_string ), sizeof( wchar_t * ) );
	swigStructField( "SDL_hid_device_info-interface_subclass", offsetof( struct SDL_hid_device_info, interface_subclass ), sizeof( int ) );
	swigStructField( "SDL_hid_device_info-usage", offsetof( struct SDL_hid_device_info, usage ), sizeof( unsigned short ) );
	swigStructField( "SDL_hid_device_info-next", offsetof( struct SDL_hid_device_info, next ), sizeof( struct SDL_hid_device_info * ) );
	swigStructField( "SDL_hid_device_info-product_id", offsetof( struct SDL_hid_device_info, product_id ), sizeof( unsigned short ) );
	swigStructField( "SDL_hid_device_info-usage_page", offsetof( struct SDL_hid_device_info, usage_page ), sizeof( unsigned short ) );
	swigStructField( "SDL_hid_device_info-vendor_id", offsetof( struct SDL_hid_device_info, vendor_id ), sizeof( unsigned short ) );
	printf( "drop %zu end-structure\n", sizeof( struct SDL_hid_device_info ) );

	swigComment("SDL_MessageBoxButtonData\n");
	printf( "begin-structure SDL_MessageBoxButtonData\n" );
	swigStructField( "SDL_MessageBoxButtonData-buttonid", offsetof( SDL_MessageBoxButtonData, buttonid ), sizeof( int ) );
	swigStructField( "SDL_MessageBoxButtonData-text", offsetof( SDL_MessageBoxButtonData, text ), sizeof( char const * ) );
	swigStructField( "SDL_MessageBoxButtonData-flags", offsetof( SDL_MessageBoxButtonData, flags ), sizeof( Uint32 ) );
	printf( "drop %zu end-structure\n", sizeof( SDL_MessageBoxButtonData ) );

	swigComment("SDL_MessageBoxColor\n");
	printf( "begin-structure SDL_MessageBoxColor\n" );
	swigStructField( "SDL_MessageBoxColor-b", offsetof( SDL_MessageBoxColor, b ), sizeof( Uint8 ) );
	swigStructField( "SDL_MessageBoxColor-r", offsetof( SDL_MessageBoxColor, r ), sizeof( Uint8 ) );
	swigStructField( "SDL_MessageBoxColor-g", offsetof( SDL_MessageBoxColor, g ), sizeof( Uint8 ) );
	printf( "drop %zu end-structure\n", sizeof( SDL_MessageBoxColor ) );

	swigComment("SDL_MessageBoxColorScheme\n");
	printf( "begin-structure SDL_MessageBoxColorScheme\n" );
	swigStructField( "SDL_MessageBoxColorScheme-colors", offsetof( SDL_MessageBoxColorScheme, colors ), sizeof( SDL_MessageBoxColor [SDL_MESSAGEBOX_COLOR_MAX] ) );
	printf( "drop %zu end-structure\n", sizeof( SDL_MessageBoxColorScheme ) );

	swigComment("SDL_MessageBoxData\n");
	printf( "begin-structure SDL_MessageBoxData\n" );
	swigStructField( "SDL_MessageBoxData-numbuttons", offsetof( SDL_MessageBoxData, numbuttons ), sizeof( int ) );
	swigStructField( "SDL_MessageBoxData-buttons", offsetof( SDL_MessageBoxData, buttons ), sizeof( SDL_MessageBoxButtonData const * ) );
	swigStructField( "SDL_MessageBoxData-window", offsetof( SDL_MessageBoxData, window ), sizeof( SDL_Window * ) );
	swigStructField( "SDL_MessageBoxData-colorScheme", offsetof( SDL_MessageBoxData, colorScheme ), sizeof( SDL_MessageBoxColorScheme const * ) );
	swigStructField( "SDL_MessageBoxData-title", offsetof( SDL_MessageBoxData, title ), sizeof( char const * ) );
	swigStructField( "SDL_MessageBoxData-message", offsetof( SDL_MessageBoxData, message ), sizeof( char const * ) );
	swigStructField( "SDL_MessageBoxData-flags", offsetof( SDL_MessageBoxData, flags ), sizeof( Uint32 ) );
	printf( "drop %zu end-structure\n", sizeof( SDL_MessageBoxData ) );

	swigComment("struct SDL_RendererInfo\n");
	printf( "begin-structure SDL_RendererInfo\n" );
	swigStructField( "SDL_RendererInfo-name", offsetof( struct SDL_RendererInfo, name ), sizeof( char const * ) );
	swigStructField( "SDL_RendererInfo-max_texture_width", offsetof( struct SDL_RendererInfo, max_texture_width ), sizeof( int ) );
	swigStructField( "SDL_RendererInfo-max_texture_height", offsetof( struct SDL_RendererInfo, max_texture_height ), sizeof( int ) );
	swigStructField( "SDL_RendererInfo-num_texture_formats", offsetof( struct SDL_RendererInfo, num_texture_formats ), sizeof( Uint32 ) );
	swigStructField( "SDL_RendererInfo-texture_formats", offsetof( struct SDL_RendererInfo, texture_formats ), sizeof( Uint32 [16] ) );
	swigStructField( "SDL_RendererInfo-flags", offsetof( struct SDL_RendererInfo, flags ), sizeof( Uint32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct SDL_RendererInfo ) );

	swigComment("struct SDL_Vertex\n");
	printf( "begin-structure SDL_Vertex\n" );
	swigStructField( "SDL_Vertex-color", offsetof( struct SDL_Vertex, color ), sizeof( SDL_Color ) );
	swigStructField( "SDL_Vertex-position", offsetof( struct SDL_Vertex, position ), sizeof( SDL_FPoint ) );
	swigStructField( "SDL_Vertex-tex_coord", offsetof( struct SDL_Vertex, tex_coord ), sizeof( SDL_FPoint ) );
	printf( "drop %zu end-structure\n", sizeof( struct SDL_Vertex ) );

	swigComment("struct SDL_RWops\n");
	printf( "begin-structure SDL_RWops\n" );
	swigStructField( "SDL_RWops-write", offsetof( struct SDL_RWops, write ), sizeof( size_t (*)(struct SDL_RWops *,void const *,size_t,size_t) ) );
	swigStructField( "SDL_RWops-seek", offsetof( struct SDL_RWops, seek ), sizeof( Sint64 (*)(struct SDL_RWops *,Sint64,int) ) );
	swigStructField( "SDL_RWops-size", offsetof( struct SDL_RWops, size ), sizeof( Sint64 (*)(struct SDL_RWops *) ) );
	swigStructField( "SDL_RWops-type", offsetof( struct SDL_RWops, type ), sizeof( Uint32 ) );
	swigStructField( "SDL_RWops-hidden", offsetof( struct SDL_RWops, hidden ), sizeof( SDL_RWops_hidden ) );
	swigStructField( "SDL_RWops-read", offsetof( struct SDL_RWops, read ), sizeof( size_t (*)(struct SDL_RWops *,void *,size_t,size_t) ) );
	swigStructField( "SDL_RWops-close", offsetof( struct SDL_RWops, close ), sizeof( int (*)(struct SDL_RWops *) ) );
	printf( "drop %zu end-structure\n", sizeof( struct SDL_RWops ) );

	swigComment("SDL_RWops_hidden\n");
	printf( "begin-structure SDL_RWops_hidden\n" );
	swigStructField( "SDL_RWops_hidden-unknown", offsetof( SDL_RWops_hidden, unknown ), sizeof( SDL_RWops_hidden_unknown ) );
	swigStructField( "SDL_RWops_hidden-mem", offsetof( SDL_RWops_hidden, mem ), sizeof( SDL_RWops_hidden_mem ) );
	printf( "drop %zu end-structure\n", sizeof( SDL_RWops_hidden ) );

	swigComment("SDL_RWops_hidden_unknown\n");
	printf( "begin-structure SDL_RWops_hidden_unknown\n" );
	swigStructField( "SDL_RWops_hidden_unknown-data1", offsetof( SDL_RWops_hidden_unknown, data1 ), sizeof( void * ) );
	swigStructField( "SDL_RWops_hidden_unknown-data2", offsetof( SDL_RWops_hidden_unknown, data2 ), sizeof( void * ) );
	printf( "drop %zu end-structure\n", sizeof( SDL_RWops_hidden_unknown ) );

	swigComment("SDL_RWops_hidden_mem\n");
	printf( "begin-structure SDL_RWops_hidden_mem\n" );
	swigStructField( "SDL_RWops_hidden_mem-stop", offsetof( SDL_RWops_hidden_mem, stop ), sizeof( Uint8 * ) );
	swigStructField( "SDL_RWops_hidden_mem-here", offsetof( SDL_RWops_hidden_mem, here ), sizeof( Uint8 * ) );
	swigStructField( "SDL_RWops_hidden_mem-base", offsetof( SDL_RWops_hidden_mem, base ), sizeof( Uint8 * ) );
	printf( "drop %zu end-structure\n", sizeof( SDL_RWops_hidden_mem ) );

	swigComment("SDL_WindowShapeParams\n");
	printf( "begin-structure SDL_WindowShapeParams\n" );
	swigStructField( "SDL_WindowShapeParams-colorKey", offsetof( SDL_WindowShapeParams, colorKey ), sizeof( SDL_Color ) );
	swigStructField( "SDL_WindowShapeParams-binarizationCutoff", offsetof( SDL_WindowShapeParams, binarizationCutoff ), sizeof( Uint8 ) );
	printf( "drop %zu end-structure\n", sizeof( SDL_WindowShapeParams ) );

	swigComment("struct SDL_WindowShapeMode\n");
	printf( "begin-structure SDL_WindowShapeMode\n" );
	swigStructField( "SDL_WindowShapeMode-parameters", offsetof( struct SDL_WindowShapeMode, parameters ), sizeof( SDL_WindowShapeParams ) );
	swigStructField( "SDL_WindowShapeMode-mode", offsetof( struct SDL_WindowShapeMode, mode ), sizeof( WindowShapeMode ) );
	printf( "drop %zu end-structure\n", sizeof( struct SDL_WindowShapeMode ) );

	swigComment("struct SDL_version\n");
	printf( "begin-structure SDL_version\n" );
	swigStructField( "SDL_version-major", offsetof( struct SDL_version, major ), sizeof( Uint8 ) );
	swigStructField( "SDL_version-minor", offsetof( struct SDL_version, minor ), sizeof( Uint8 ) );
	swigStructField( "SDL_version-patch", offsetof( struct SDL_version, patch ), sizeof( Uint8 ) );
	printf( "drop %zu end-structure\n", sizeof( struct SDL_version ) );

	swigComment("SDL_DisplayMode\n");
	printf( "begin-structure SDL_DisplayMode\n" );
	swigStructField( "SDL_DisplayMode-w", offsetof( SDL_DisplayMode, w ), sizeof( int ) );
	swigStructField( "SDL_DisplayMode-refresh_rate", offsetof( SDL_DisplayMode, refresh_rate ), sizeof( int ) );
	swigStructField( "SDL_DisplayMode-format", offsetof( SDL_DisplayMode, format ), sizeof( Uint32 ) );
	swigStructField( "SDL_DisplayMode-h", offsetof( SDL_DisplayMode, h ), sizeof( int ) );
	swigStructField( "SDL_DisplayMode-driverdata", offsetof( SDL_DisplayMode, driverdata ), sizeof( void * ) );
	printf( "drop %zu end-structure\n", sizeof( SDL_DisplayMode ) );

	swigComment("struct SDL_Locale\n");
	printf( "begin-structure SDL_Locale\n" );
	swigStructField( "SDL_Locale-country", offsetof( struct SDL_Locale, country ), sizeof( char const * ) );
	swigStructField( "SDL_Locale-language", offsetof( struct SDL_Locale, language ), sizeof( char const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct SDL_Locale ) );

	swigNewline();

	swigComment("--===< function pointers >===---\n");
	swigFunctionPointer( "c-funptr SDL_RWops-size() {((struct SDL_RWops*)ptr)->size} a -- d", "", "", "	( context -- )" );
	swigFunctionPointer( "c-funptr SDL_RWops-seek() {((struct SDL_RWops*)ptr)->seek} a d n -- d", "", "", "	( context offset whence -- )" );
	swigFunctionPointer( "c-funptr SDL_RWops-read() {((struct SDL_RWops*)ptr)->read} a a u u -- u", "", "", "	( context ptr size maxnum -- )" );
	swigFunctionPointer( "c-funptr SDL_RWops-write() {((struct SDL_RWops*)ptr)->write} a a u u -- u", "", "", "	( context ptr size num -- )" );
	swigFunctionPointer( "c-funptr SDL_RWops-close() {((struct SDL_RWops*)ptr)->close} a -- n", "", "", "	( context -- )" );

	swigNewline();

	swigComment("------===< callbacks >===-------\n");
	swigCallback( "c-callback SDL_malloc_func: u -- a", "", "", "	( size -- )" );
	swigCallback( "c-callback SDL_calloc_func: u u -- a", "", "", "	( nmemb size -- )" );
	swigCallback( "c-callback SDL_realloc_func: a u -- a", "", "", "	( mem size -- )" );
	swigCallback( "c-callback SDL_free_func: a -- void", "", "", "	( mem -- )" );
	swigCallback( "c-callback SDL_AssertionHandler: a a -- n", "", "", "	( data userdata -- )" );
	swigCallback( "c-callback SDL_AudioCallback: a a n -- void", "", "", "	( userdata stream len -- )" );
	swigCallback( "c-callback SDL_AudioFilter: a u -- void", "", "", "	( cvt format -- )" );
	swigCallback( "c-callback SDL_EventFilter: a a -- n", "", "", "	( userdata event -- )" );
	swigCallback( "c-callback SDL_HintCallback: a s s s -- void", "", "", "	( userdata name oldValue newValue -- )" );
	swigCallback( "c-callback SDL_LogOutputFunction: a n n s -- void", "", "", "	( userdata category priority message -- )" );
	swigCallback( "c-callback SDL_ThreadFunction: a -- n", "", "", "	( data -- )" );
	swigCallback( "c-callback SDL_TimerCallback: u a -- u", "", "", "	( interval param -- )" );
	swigCallback( "c-callback SDL_HitTest: a a a -- n", "", "", "	( win area data -- )" );

	swigNewline();

	swigComment("------===< functions >===-------\n");
	swigFunction( "c-function SDL_malloc SDL_malloc u -- a", "FUNCTION: SDL_malloc ( size -- a )", "EXTERN: \"C\" void * SDL_malloc( int size );", "	( size -- )" );
	swigFunction( "c-function SDL_calloc SDL_calloc u u -- a", "FUNCTION: SDL_calloc ( nmemb size -- a )", "EXTERN: \"C\" void * SDL_calloc( int nmemb, int size );", "	( nmemb size -- )" );
	swigFunction( "c-function SDL_realloc SDL_realloc a u -- a", "FUNCTION: SDL_realloc ( mem size -- a )", "EXTERN: \"C\" void * SDL_realloc( void * mem, int size );", "	( mem size -- )" );
	swigFunction( "c-function SDL_free SDL_free a -- void", "FUNCTION: SDL_free ( mem -- void )", "EXTERN: \"C\" void SDL_free( void * mem );", "	( mem -- )" );
	swigFunction( "c-function SDL_GetMemoryFunctions SDL_GetMemoryFunctions a a a a -- void", "FUNCTION: SDL_GetMemoryFunctions ( malloc_func calloc_func realloc_func free_func -- void )", "EXTERN: \"C\" void SDL_GetMemoryFunctions( void * malloc_func, void * calloc_func, void * realloc_func, void * free_func );", "	( malloc_func calloc_func realloc_func free_func -- )" );
	swigFunction( "c-function SDL_SetMemoryFunctions SDL_SetMemoryFunctions a a a a -- n", "FUNCTION: SDL_SetMemoryFunctions ( malloc_func calloc_func realloc_func free_func -- n )", "EXTERN: \"C\" int SDL_SetMemoryFunctions( void * malloc_func, void * calloc_func, void * realloc_func, void * free_func );", "	( malloc_func calloc_func realloc_func free_func -- )" );
	swigFunction( "c-function SDL_GetNumAllocations SDL_GetNumAllocations  -- n", "FUNCTION: SDL_GetNumAllocations (  -- n )", "EXTERN: \"C\" int SDL_GetNumAllocations(  );", "	( -- )" );
	swigFunction( "c-function SDL_getenv SDL_getenv s -- a", "FUNCTION: SDL_getenv ( name -- a )", "EXTERN: \"C\" void * SDL_getenv( char * name );", "	( name -- )" );
	swigFunction( "c-function SDL_setenv SDL_setenv s s n -- n", "FUNCTION: SDL_setenv ( name value overwrite -- n )", "EXTERN: \"C\" int SDL_setenv( char * name, char * value, int overwrite );", "	( name value overwrite -- )" );
	swigFunction( "c-function SDL_qsort SDL_qsort a u u a -- void", "FUNCTION: SDL_qsort ( base nmemb size compare -- void )", "EXTERN: \"C\" void SDL_qsort( void * base, int nmemb, int size, void * compare );", "	( base nmemb size compare -- )" );
	swigFunction( "c-function SDL_abs SDL_abs n -- n", "FUNCTION: SDL_abs ( x -- n )", "EXTERN: \"C\" int SDL_abs( int x );", "	( x -- )" );
	swigFunction( "c-function SDL_isalpha SDL_isalpha n -- n", "FUNCTION: SDL_isalpha ( x -- n )", "EXTERN: \"C\" int SDL_isalpha( int x );", "	( x -- )" );
	swigFunction( "c-function SDL_isalnum SDL_isalnum n -- n", "FUNCTION: SDL_isalnum ( x -- n )", "EXTERN: \"C\" int SDL_isalnum( int x );", "	( x -- )" );
	swigFunction( "c-function SDL_isblank SDL_isblank n -- n", "FUNCTION: SDL_isblank ( x -- n )", "EXTERN: \"C\" int SDL_isblank( int x );", "	( x -- )" );
	swigFunction( "c-function SDL_iscntrl SDL_iscntrl n -- n", "FUNCTION: SDL_iscntrl ( x -- n )", "EXTERN: \"C\" int SDL_iscntrl( int x );", "	( x -- )" );
	swigFunction( "c-function SDL_isdigit SDL_isdigit n -- n", "FUNCTION: SDL_isdigit ( x -- n )", "EXTERN: \"C\" int SDL_isdigit( int x );", "	( x -- )" );
	swigFunction( "c-function SDL_isxdigit SDL_isxdigit n -- n", "FUNCTION: SDL_isxdigit ( x -- n )", "EXTERN: \"C\" int SDL_isxdigit( int x );", "	( x -- )" );
	swigFunction( "c-function SDL_ispunct SDL_ispunct n -- n", "FUNCTION: SDL_ispunct ( x -- n )", "EXTERN: \"C\" int SDL_ispunct( int x );", "	( x -- )" );
	swigFunction( "c-function SDL_isspace SDL_isspace n -- n", "FUNCTION: SDL_isspace ( x -- n )", "EXTERN: \"C\" int SDL_isspace( int x );", "	( x -- )" );
	swigFunction( "c-function SDL_isupper SDL_isupper n -- n", "FUNCTION: SDL_isupper ( x -- n )", "EXTERN: \"C\" int SDL_isupper( int x );", "	( x -- )" );
	swigFunction( "c-function SDL_islower SDL_islower n -- n", "FUNCTION: SDL_islower ( x -- n )", "EXTERN: \"C\" int SDL_islower( int x );", "	( x -- )" );
	swigFunction( "c-function SDL_isprint SDL_isprint n -- n", "FUNCTION: SDL_isprint ( x -- n )", "EXTERN: \"C\" int SDL_isprint( int x );", "	( x -- )" );
	swigFunction( "c-function SDL_isgraph SDL_isgraph n -- n", "FUNCTION: SDL_isgraph ( x -- n )", "EXTERN: \"C\" int SDL_isgraph( int x );", "	( x -- )" );
	swigFunction( "c-function SDL_toupper SDL_toupper n -- n", "FUNCTION: SDL_toupper ( x -- n )", "EXTERN: \"C\" int SDL_toupper( int x );", "	( x -- )" );
	swigFunction( "c-function SDL_tolower SDL_tolower n -- n", "FUNCTION: SDL_tolower ( x -- n )", "EXTERN: \"C\" int SDL_tolower( int x );", "	( x -- )" );
	swigFunction( "c-function SDL_crc32 SDL_crc32 u a u -- u", "FUNCTION: SDL_crc32 ( crc data len -- u )", "EXTERN: \"C\" int SDL_crc32( int crc, void * data, int len );", "	( crc data len -- )" );
	swigFunction( "c-function SDL_memset SDL_memset a n u -- a", "FUNCTION: SDL_memset ( dst c len -- a )", "EXTERN: \"C\" void * SDL_memset( void * dst, int c, int len );", "	( dst c len -- )" );
	swigFunction( "c-function SDL_memset4 SDL_memset4 a u u -- void", "FUNCTION: SDL_memset4 ( dst val dwords -- void )", "EXTERN: \"C\" void SDL_memset4( void * dst, int val, int dwords );", "	( dst val dwords -- )" );
	swigFunction( "c-function SDL_memcpy SDL_memcpy a a u -- a", "FUNCTION: SDL_memcpy ( dst src len -- a )", "EXTERN: \"C\" void * SDL_memcpy( void * dst, void * src, int len );", "	( dst src len -- )" );
	swigFunction( "c-function SDL_memmove SDL_memmove a a u -- a", "FUNCTION: SDL_memmove ( dst src len -- a )", "EXTERN: \"C\" void * SDL_memmove( void * dst, void * src, int len );", "	( dst src len -- )" );
	swigFunction( "c-function SDL_memcmp SDL_memcmp a a u -- n", "FUNCTION: SDL_memcmp ( s1 s2 len -- n )", "EXTERN: \"C\" int SDL_memcmp( void * s1, void * s2, int len );", "	( s1 s2 len -- )" );
	swigFunction( "c-function SDL_wcslen SDL_wcslen ws -- u", "FUNCTION: SDL_wcslen ( wstr -- u )", "EXTERN: \"C\" int SDL_wcslen( char * wstr );", "	( wstr -- )" );
	swigFunction( "c-function SDL_wcslcpy SDL_wcslcpy a ws u -- u", "FUNCTION: SDL_wcslcpy ( dst src maxlen -- u )", "EXTERN: \"C\" int SDL_wcslcpy( void * dst, char * src, int maxlen );", "	( dst src maxlen -- )" );
	swigFunction( "c-function SDL_wcslcat SDL_wcslcat a ws u -- u", "FUNCTION: SDL_wcslcat ( dst src maxlen -- u )", "EXTERN: \"C\" int SDL_wcslcat( void * dst, char * src, int maxlen );", "	( dst src maxlen -- )" );
	swigFunction( "c-function SDL_wcsdup SDL_wcsdup ws -- a", "FUNCTION: SDL_wcsdup ( wstr -- a )", "EXTERN: \"C\" void * SDL_wcsdup( char * wstr );", "	( wstr -- )" );
	swigFunction( "c-function SDL_wcsstr SDL_wcsstr ws ws -- a", "FUNCTION: SDL_wcsstr ( haystack needle -- a )", "EXTERN: \"C\" void * SDL_wcsstr( char * haystack, char * needle );", "	( haystack needle -- )" );
	swigFunction( "c-function SDL_wcscmp SDL_wcscmp ws ws -- n", "FUNCTION: SDL_wcscmp ( str1 str2 -- n )", "EXTERN: \"C\" int SDL_wcscmp( char * str1, char * str2 );", "	( str1 str2 -- )" );
	swigFunction( "c-function SDL_wcsncmp SDL_wcsncmp ws ws u -- n", "FUNCTION: SDL_wcsncmp ( str1 str2 maxlen -- n )", "EXTERN: \"C\" int SDL_wcsncmp( char * str1, char * str2, int maxlen );", "	( str1 str2 maxlen -- )" );
	swigFunction( "c-function SDL_wcscasecmp SDL_wcscasecmp ws ws -- n", "FUNCTION: SDL_wcscasecmp ( str1 str2 -- n )", "EXTERN: \"C\" int SDL_wcscasecmp( char * str1, char * str2 );", "	( str1 str2 -- )" );
	swigFunction( "c-function SDL_wcsncasecmp SDL_wcsncasecmp ws ws u -- n", "FUNCTION: SDL_wcsncasecmp ( str1 str2 len -- n )", "EXTERN: \"C\" int SDL_wcsncasecmp( char * str1, char * str2, int len );", "	( str1 str2 len -- )" );
	swigFunction( "c-function SDL_strlen SDL_strlen s -- u", "FUNCTION: SDL_strlen ( str -- u )", "EXTERN: \"C\" int SDL_strlen( char * str );", "	( str -- )" );
	swigFunction( "c-function SDL_strlcpy SDL_strlcpy a s u -- u", "FUNCTION: SDL_strlcpy ( dst src maxlen -- u )", "EXTERN: \"C\" int SDL_strlcpy( void * dst, char * src, int maxlen );", "	( dst src maxlen -- )" );
	swigFunction( "c-function SDL_utf8strlcpy SDL_utf8strlcpy a s u -- u", "FUNCTION: SDL_utf8strlcpy ( dst src dst_bytes -- u )", "EXTERN: \"C\" int SDL_utf8strlcpy( void * dst, char * src, int dst_bytes );", "	( dst src dst_bytes -- )" );
	swigFunction( "c-function SDL_strlcat SDL_strlcat a s u -- u", "FUNCTION: SDL_strlcat ( dst src maxlen -- u )", "EXTERN: \"C\" int SDL_strlcat( void * dst, char * src, int maxlen );", "	( dst src maxlen -- )" );
	swigFunction( "c-function SDL_strdup SDL_strdup s -- a", "FUNCTION: SDL_strdup ( str -- a )", "EXTERN: \"C\" void * SDL_strdup( char * str );", "	( str -- )" );
	swigFunction( "c-function SDL_strrev SDL_strrev a -- a", "FUNCTION: SDL_strrev ( str -- a )", "EXTERN: \"C\" void * SDL_strrev( void * str );", "	( str -- )" );
	swigFunction( "c-function SDL_strupr SDL_strupr a -- a", "FUNCTION: SDL_strupr ( str -- a )", "EXTERN: \"C\" void * SDL_strupr( void * str );", "	( str -- )" );
	swigFunction( "c-function SDL_strlwr SDL_strlwr a -- a", "FUNCTION: SDL_strlwr ( str -- a )", "EXTERN: \"C\" void * SDL_strlwr( void * str );", "	( str -- )" );
	swigFunction( "c-function SDL_strchr SDL_strchr s n -- a", "FUNCTION: SDL_strchr ( str c -- a )", "EXTERN: \"C\" void * SDL_strchr( char * str, int c );", "	( str c -- )" );
	swigFunction( "c-function SDL_strrchr SDL_strrchr s n -- a", "FUNCTION: SDL_strrchr ( str c -- a )", "EXTERN: \"C\" void * SDL_strrchr( char * str, int c );", "	( str c -- )" );
	swigFunction( "c-function SDL_strstr SDL_strstr s s -- a", "FUNCTION: SDL_strstr ( haystack needle -- a )", "EXTERN: \"C\" void * SDL_strstr( char * haystack, char * needle );", "	( haystack needle -- )" );
	swigFunction( "c-function SDL_strtokr SDL_strtokr a s a -- a", "FUNCTION: SDL_strtokr ( s1 s2 saveptr -- a )", "EXTERN: \"C\" void * SDL_strtokr( void * s1, char * s2, void * saveptr );", "	( s1 s2 saveptr -- )" );
	swigFunction( "c-function SDL_utf8strlen SDL_utf8strlen s -- u", "FUNCTION: SDL_utf8strlen ( str -- u )", "EXTERN: \"C\" int SDL_utf8strlen( char * str );", "	( str -- )" );
	swigFunction( "c-function SDL_itoa SDL_itoa n a n -- a", "FUNCTION: SDL_itoa ( value str radix -- a )", "EXTERN: \"C\" void * SDL_itoa( int value, void * str, int radix );", "	( value str radix -- )" );
	swigFunction( "c-function SDL_uitoa SDL_uitoa u a n -- a", "FUNCTION: SDL_uitoa ( value str radix -- a )", "EXTERN: \"C\" void * SDL_uitoa( int value, void * str, int radix );", "	( value str radix -- )" );
	swigFunction( "c-function SDL_ltoa SDL_ltoa n a n -- a", "FUNCTION: SDL_ltoa ( value str radix -- a )", "EXTERN: \"C\" void * SDL_ltoa( long value, void * str, int radix );", "	( value str radix -- )" );
	swigFunction( "c-function SDL_ultoa SDL_ultoa u a n -- a", "FUNCTION: SDL_ultoa ( value str radix -- a )", "EXTERN: \"C\" void * SDL_ultoa( long value, void * str, int radix );", "	( value str radix -- )" );
	swigFunction( "c-function SDL_lltoa SDL_lltoa d a n -- a", "FUNCTION: SDL_lltoa ( value str radix -- a )", "EXTERN: \"C\" void * SDL_lltoa( long long value, void * str, int radix );", "	( value str radix -- )" );
	swigFunction( "c-function SDL_ulltoa SDL_ulltoa ud a n -- a", "FUNCTION: SDL_ulltoa ( value str radix -- a )", "EXTERN: \"C\" void * SDL_ulltoa( long long value, void * str, int radix );", "	( value str radix -- )" );
	swigFunction( "c-function SDL_atoi SDL_atoi s -- n", "FUNCTION: SDL_atoi ( str -- n )", "EXTERN: \"C\" int SDL_atoi( char * str );", "	( str -- )" );
	swigFunction( "c-function SDL_atof SDL_atof s -- r", "FUNCTION: SDL_atof ( str -- r )", "EXTERN: \"C\" double SDL_atof( char * str );", "	( str -- )" );
	swigFunction( "c-function SDL_strtol SDL_strtol s a n -- n", "FUNCTION: SDL_strtol ( str endp base -- n )", "EXTERN: \"C\" long SDL_strtol( char * str, void * endp, int base );", "	( str endp base -- )" );
	swigFunction( "c-function SDL_strtoul SDL_strtoul s a n -- u", "FUNCTION: SDL_strtoul ( str endp base -- u )", "EXTERN: \"C\" long SDL_strtoul( char * str, void * endp, int base );", "	( str endp base -- )" );
	swigFunction( "c-function SDL_strtoll SDL_strtoll s a n -- d", "FUNCTION: SDL_strtoll ( str endp base -- d )", "EXTERN: \"C\" long long SDL_strtoll( char * str, void * endp, int base );", "	( str endp base -- )" );
	swigFunction( "c-function SDL_strtoull SDL_strtoull s a n -- ud", "FUNCTION: SDL_strtoull ( str endp base -- ud )", "EXTERN: \"C\" long long SDL_strtoull( char * str, void * endp, int base );", "	( str endp base -- )" );
	swigFunction( "c-function SDL_strtod SDL_strtod s a -- r", "FUNCTION: SDL_strtod ( str endp -- r )", "EXTERN: \"C\" double SDL_strtod( char * str, void * endp );", "	( str endp -- )" );
	swigFunction( "c-function SDL_strcmp SDL_strcmp s s -- n", "FUNCTION: SDL_strcmp ( str1 str2 -- n )", "EXTERN: \"C\" int SDL_strcmp( char * str1, char * str2 );", "	( str1 str2 -- )" );
	swigFunction( "c-function SDL_strncmp SDL_strncmp s s u -- n", "FUNCTION: SDL_strncmp ( str1 str2 maxlen -- n )", "EXTERN: \"C\" int SDL_strncmp( char * str1, char * str2, int maxlen );", "	( str1 str2 maxlen -- )" );
	swigFunction( "c-function SDL_strcasecmp SDL_strcasecmp s s -- n", "FUNCTION: SDL_strcasecmp ( str1 str2 -- n )", "EXTERN: \"C\" int SDL_strcasecmp( char * str1, char * str2 );", "	( str1 str2 -- )" );
	swigFunction( "c-function SDL_strncasecmp SDL_strncasecmp s s u -- n", "FUNCTION: SDL_strncasecmp ( str1 str2 len -- n )", "EXTERN: \"C\" int SDL_strncasecmp( char * str1, char * str2, int len );", "	( str1 str2 len -- )" );
	swigFunction( "c-function SDL_sscanf SDL_sscanf s s ... -- n", "FUNCTION: SDL_sscanf ( text fmt  -- n )", "EXTERN: \"C\" int SDL_sscanf( char * text, char * fmt, ...  );", "	( text fmt <noname> -- )" );
	swigFunction( "c-function SDL_vsscanf SDL_vsscanf s s n -- n", "FUNCTION: SDL_vsscanf ( text fmt ap -- n )", "EXTERN: \"C\" int SDL_vsscanf( char * text, char * fmt, long ap );", "	( text fmt ap -- )" );
	swigFunction( "c-function SDL_snprintf SDL_snprintf a u s ... -- n", "FUNCTION: SDL_snprintf ( text maxlen fmt  -- n )", "EXTERN: \"C\" int SDL_snprintf( void * text, int maxlen, char * fmt, ...  );", "	( text maxlen fmt <noname> -- )" );
	swigFunction( "c-function SDL_vsnprintf SDL_vsnprintf a u s n -- n", "FUNCTION: SDL_vsnprintf ( text maxlen fmt ap -- n )", "EXTERN: \"C\" int SDL_vsnprintf( void * text, int maxlen, char * fmt, long ap );", "	( text maxlen fmt ap -- )" );
	swigFunction( "c-function SDL_asprintf SDL_asprintf a s ... -- n", "FUNCTION: SDL_asprintf ( strp fmt  -- n )", "EXTERN: \"C\" int SDL_asprintf( void * strp, char * fmt, ...  );", "	( strp fmt <noname> -- )" );
	swigFunction( "c-function SDL_vasprintf SDL_vasprintf a s n -- n", "FUNCTION: SDL_vasprintf ( strp fmt ap -- n )", "EXTERN: \"C\" int SDL_vasprintf( void * strp, char * fmt, long ap );", "	( strp fmt ap -- )" );
	swigFunction( "c-function SDL_acos SDL_acos r -- r", "FUNCTION: SDL_acos ( x -- r )", "EXTERN: \"C\" double SDL_acos( double x );", "	( x -- )" );
	swigFunction( "c-function SDL_acosf SDL_acosf r -- r", "FUNCTION: SDL_acosf ( x -- r )", "EXTERN: \"C\" float SDL_acosf( float x );", "	( x -- )" );
	swigFunction( "c-function SDL_asin SDL_asin r -- r", "FUNCTION: SDL_asin ( x -- r )", "EXTERN: \"C\" double SDL_asin( double x );", "	( x -- )" );
	swigFunction( "c-function SDL_asinf SDL_asinf r -- r", "FUNCTION: SDL_asinf ( x -- r )", "EXTERN: \"C\" float SDL_asinf( float x );", "	( x -- )" );
	swigFunction( "c-function SDL_atan SDL_atan r -- r", "FUNCTION: SDL_atan ( x -- r )", "EXTERN: \"C\" double SDL_atan( double x );", "	( x -- )" );
	swigFunction( "c-function SDL_atanf SDL_atanf r -- r", "FUNCTION: SDL_atanf ( x -- r )", "EXTERN: \"C\" float SDL_atanf( float x );", "	( x -- )" );
	swigFunction( "c-function SDL_atan2 SDL_atan2 r r -- r", "FUNCTION: SDL_atan2 ( y x -- r )", "EXTERN: \"C\" double SDL_atan2( double y, double x );", "	( y x -- )" );
	swigFunction( "c-function SDL_atan2f SDL_atan2f r r -- r", "FUNCTION: SDL_atan2f ( y x -- r )", "EXTERN: \"C\" float SDL_atan2f( float y, float x );", "	( y x -- )" );
	swigFunction( "c-function SDL_ceil SDL_ceil r -- r", "FUNCTION: SDL_ceil ( x -- r )", "EXTERN: \"C\" double SDL_ceil( double x );", "	( x -- )" );
	swigFunction( "c-function SDL_ceilf SDL_ceilf r -- r", "FUNCTION: SDL_ceilf ( x -- r )", "EXTERN: \"C\" float SDL_ceilf( float x );", "	( x -- )" );
	swigFunction( "c-function SDL_copysign SDL_copysign r r -- r", "FUNCTION: SDL_copysign ( x y -- r )", "EXTERN: \"C\" double SDL_copysign( double x, double y );", "	( x y -- )" );
	swigFunction( "c-function SDL_copysignf SDL_copysignf r r -- r", "FUNCTION: SDL_copysignf ( x y -- r )", "EXTERN: \"C\" float SDL_copysignf( float x, float y );", "	( x y -- )" );
	swigFunction( "c-function SDL_cos SDL_cos r -- r", "FUNCTION: SDL_cos ( x -- r )", "EXTERN: \"C\" double SDL_cos( double x );", "	( x -- )" );
	swigFunction( "c-function SDL_cosf SDL_cosf r -- r", "FUNCTION: SDL_cosf ( x -- r )", "EXTERN: \"C\" float SDL_cosf( float x );", "	( x -- )" );
	swigFunction( "c-function SDL_exp SDL_exp r -- r", "FUNCTION: SDL_exp ( x -- r )", "EXTERN: \"C\" double SDL_exp( double x );", "	( x -- )" );
	swigFunction( "c-function SDL_expf SDL_expf r -- r", "FUNCTION: SDL_expf ( x -- r )", "EXTERN: \"C\" float SDL_expf( float x );", "	( x -- )" );
	swigFunction( "c-function SDL_fabs SDL_fabs r -- r", "FUNCTION: SDL_fabs ( x -- r )", "EXTERN: \"C\" double SDL_fabs( double x );", "	( x -- )" );
	swigFunction( "c-function SDL_fabsf SDL_fabsf r -- r", "FUNCTION: SDL_fabsf ( x -- r )", "EXTERN: \"C\" float SDL_fabsf( float x );", "	( x -- )" );
	swigFunction( "c-function SDL_floor SDL_floor r -- r", "FUNCTION: SDL_floor ( x -- r )", "EXTERN: \"C\" double SDL_floor( double x );", "	( x -- )" );
	swigFunction( "c-function SDL_floorf SDL_floorf r -- r", "FUNCTION: SDL_floorf ( x -- r )", "EXTERN: \"C\" float SDL_floorf( float x );", "	( x -- )" );
	swigFunction( "c-function SDL_trunc SDL_trunc r -- r", "FUNCTION: SDL_trunc ( x -- r )", "EXTERN: \"C\" double SDL_trunc( double x );", "	( x -- )" );
	swigFunction( "c-function SDL_truncf SDL_truncf r -- r", "FUNCTION: SDL_truncf ( x -- r )", "EXTERN: \"C\" float SDL_truncf( float x );", "	( x -- )" );
	swigFunction( "c-function SDL_fmod SDL_fmod r r -- r", "FUNCTION: SDL_fmod ( x y -- r )", "EXTERN: \"C\" double SDL_fmod( double x, double y );", "	( x y -- )" );
	swigFunction( "c-function SDL_fmodf SDL_fmodf r r -- r", "FUNCTION: SDL_fmodf ( x y -- r )", "EXTERN: \"C\" float SDL_fmodf( float x, float y );", "	( x y -- )" );
	swigFunction( "c-function SDL_log SDL_log r -- r", "FUNCTION: SDL_log ( x -- r )", "EXTERN: \"C\" double SDL_log( double x );", "	( x -- )" );
	swigFunction( "c-function SDL_logf SDL_logf r -- r", "FUNCTION: SDL_logf ( x -- r )", "EXTERN: \"C\" float SDL_logf( float x );", "	( x -- )" );
	swigFunction( "c-function SDL_log10 SDL_log10 r -- r", "FUNCTION: SDL_log10 ( x -- r )", "EXTERN: \"C\" double SDL_log10( double x );", "	( x -- )" );
	swigFunction( "c-function SDL_log10f SDL_log10f r -- r", "FUNCTION: SDL_log10f ( x -- r )", "EXTERN: \"C\" float SDL_log10f( float x );", "	( x -- )" );
	swigFunction( "c-function SDL_pow SDL_pow r r -- r", "FUNCTION: SDL_pow ( x y -- r )", "EXTERN: \"C\" double SDL_pow( double x, double y );", "	( x y -- )" );
	swigFunction( "c-function SDL_powf SDL_powf r r -- r", "FUNCTION: SDL_powf ( x y -- r )", "EXTERN: \"C\" float SDL_powf( float x, float y );", "	( x y -- )" );
	swigFunction( "c-function SDL_round SDL_round r -- r", "FUNCTION: SDL_round ( x -- r )", "EXTERN: \"C\" double SDL_round( double x );", "	( x -- )" );
	swigFunction( "c-function SDL_roundf SDL_roundf r -- r", "FUNCTION: SDL_roundf ( x -- r )", "EXTERN: \"C\" float SDL_roundf( float x );", "	( x -- )" );
	swigFunction( "c-function SDL_lround SDL_lround r -- n", "FUNCTION: SDL_lround ( x -- n )", "EXTERN: \"C\" long SDL_lround( double x );", "	( x -- )" );
	swigFunction( "c-function SDL_lroundf SDL_lroundf r -- n", "FUNCTION: SDL_lroundf ( x -- n )", "EXTERN: \"C\" long SDL_lroundf( float x );", "	( x -- )" );
	swigFunction( "c-function SDL_scalbn SDL_scalbn r n -- r", "FUNCTION: SDL_scalbn ( x n -- r )", "EXTERN: \"C\" double SDL_scalbn( double x, int n );", "	( x n -- )" );
	swigFunction( "c-function SDL_scalbnf SDL_scalbnf r n -- r", "FUNCTION: SDL_scalbnf ( x n -- r )", "EXTERN: \"C\" float SDL_scalbnf( float x, int n );", "	( x n -- )" );
	swigFunction( "c-function SDL_sin SDL_sin r -- r", "FUNCTION: SDL_sin ( x -- r )", "EXTERN: \"C\" double SDL_sin( double x );", "	( x -- )" );
	swigFunction( "c-function SDL_sinf SDL_sinf r -- r", "FUNCTION: SDL_sinf ( x -- r )", "EXTERN: \"C\" float SDL_sinf( float x );", "	( x -- )" );
	swigFunction( "c-function SDL_sqrt SDL_sqrt r -- r", "FUNCTION: SDL_sqrt ( x -- r )", "EXTERN: \"C\" double SDL_sqrt( double x );", "	( x -- )" );
	swigFunction( "c-function SDL_sqrtf SDL_sqrtf r -- r", "FUNCTION: SDL_sqrtf ( x -- r )", "EXTERN: \"C\" float SDL_sqrtf( float x );", "	( x -- )" );
	swigFunction( "c-function SDL_tan SDL_tan r -- r", "FUNCTION: SDL_tan ( x -- r )", "EXTERN: \"C\" double SDL_tan( double x );", "	( x -- )" );
	swigFunction( "c-function SDL_tanf SDL_tanf r -- r", "FUNCTION: SDL_tanf ( x -- r )", "EXTERN: \"C\" float SDL_tanf( float x );", "	( x -- )" );
	swigFunction( "c-function SDL_iconv_open SDL_iconv_open s s -- a", "FUNCTION: SDL_iconv_open ( tocode fromcode -- a )", "EXTERN: \"C\" void * SDL_iconv_open( char * tocode, char * fromcode );", "	( tocode fromcode -- )" );
	swigFunction( "c-function SDL_iconv_close SDL_iconv_close a -- n", "FUNCTION: SDL_iconv_close ( cd -- n )", "EXTERN: \"C\" int SDL_iconv_close( void * cd );", "	( cd -- )" );
	swigFunction( "c-function SDL_iconv SDL_iconv a a a a a -- u", "FUNCTION: SDL_iconv ( cd inbuf inbytesleft outbuf outbytesleft -- u )", "EXTERN: \"C\" int SDL_iconv( void * cd, void * inbuf, void * inbytesleft, void * outbuf, void * outbytesleft );", "	( cd inbuf inbytesleft outbuf outbytesleft -- )" );
	swigFunction( "c-function SDL_iconv_string SDL_iconv_string s s s u -- a", "FUNCTION: SDL_iconv_string ( tocode fromcode inbuf inbytesleft -- a )", "EXTERN: \"C\" void * SDL_iconv_string( char * tocode, char * fromcode, char * inbuf, int inbytesleft );", "	( tocode fromcode inbuf inbytesleft -- )" );
	swigFunction( "c-function SDL_memcpy4 SDL_memcpy4 a a u -- a", "FUNCTION: SDL_memcpy4 ( dst src dwords -- a )", "EXTERN: \"C\" void * SDL_memcpy4( void * dst, void * src, int dwords );", "	( dst src dwords -- )" );
	swigFunction( "c-function SDL_ReportAssertion SDL_ReportAssertion a s s n -- n", "FUNCTION: SDL_ReportAssertion (     -- n )", "EXTERN: \"C\" int SDL_ReportAssertion( void * , char * , char * , int  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function SDL_SetAssertionHandler SDL_SetAssertionHandler a a -- void", "FUNCTION: SDL_SetAssertionHandler ( handler userdata -- void )", "EXTERN: \"C\" void SDL_SetAssertionHandler( void * handler, void * userdata );", "	( handler userdata -- )" );
	swigFunction( "c-function SDL_GetDefaultAssertionHandler SDL_GetDefaultAssertionHandler  -- a", "FUNCTION: SDL_GetDefaultAssertionHandler (  -- a )", "EXTERN: \"C\" void * SDL_GetDefaultAssertionHandler(  );", "	( -- )" );
	swigFunction( "c-function SDL_GetAssertionHandler SDL_GetAssertionHandler a -- a", "FUNCTION: SDL_GetAssertionHandler ( puserdata -- a )", "EXTERN: \"C\" void * SDL_GetAssertionHandler( void * puserdata );", "	( puserdata -- )" );
	swigFunction( "c-function SDL_GetAssertionReport SDL_GetAssertionReport  -- a", "FUNCTION: SDL_GetAssertionReport (  -- a )", "EXTERN: \"C\" void * SDL_GetAssertionReport(  );", "	( -- )" );
	swigFunction( "c-function SDL_ResetAssertionReport SDL_ResetAssertionReport  -- void", "FUNCTION: SDL_ResetAssertionReport (  -- void )", "EXTERN: \"C\" void SDL_ResetAssertionReport(  );", "	( -- )" );
	swigFunction( "c-function SDL_AtomicTryLock SDL_AtomicTryLock a -- n", "FUNCTION: SDL_AtomicTryLock ( lock -- n )", "EXTERN: \"C\" int SDL_AtomicTryLock( void * lock );", "	( lock -- )" );
	swigFunction( "c-function SDL_AtomicLock SDL_AtomicLock a -- void", "FUNCTION: SDL_AtomicLock ( lock -- void )", "EXTERN: \"C\" void SDL_AtomicLock( void * lock );", "	( lock -- )" );
	swigFunction( "c-function SDL_AtomicUnlock SDL_AtomicUnlock a -- void", "FUNCTION: SDL_AtomicUnlock ( lock -- void )", "EXTERN: \"C\" void SDL_AtomicUnlock( void * lock );", "	( lock -- )" );
	swigFunction( "c-function SDL_MemoryBarrierReleaseFunction SDL_MemoryBarrierReleaseFunction  -- void", "FUNCTION: SDL_MemoryBarrierReleaseFunction (  -- void )", "EXTERN: \"C\" void SDL_MemoryBarrierReleaseFunction(  );", "	( -- )" );
	swigFunction( "c-function SDL_MemoryBarrierAcquireFunction SDL_MemoryBarrierAcquireFunction  -- void", "FUNCTION: SDL_MemoryBarrierAcquireFunction (  -- void )", "EXTERN: \"C\" void SDL_MemoryBarrierAcquireFunction(  );", "	( -- )" );
	swigFunction( "c-function SDL_AtomicCAS SDL_AtomicCAS a n n -- n", "FUNCTION: SDL_AtomicCAS ( a oldval newval -- n )", "EXTERN: \"C\" int SDL_AtomicCAS( void * a, int oldval, int newval );", "	( a oldval newval -- )" );
	swigFunction( "c-function SDL_AtomicSet SDL_AtomicSet a n -- n", "FUNCTION: SDL_AtomicSet ( a v -- n )", "EXTERN: \"C\" int SDL_AtomicSet( void * a, int v );", "	( a v -- )" );
	swigFunction( "c-function SDL_AtomicGet SDL_AtomicGet a -- n", "FUNCTION: SDL_AtomicGet ( a -- n )", "EXTERN: \"C\" int SDL_AtomicGet( void * a );", "	( a -- )" );
	swigFunction( "c-function SDL_AtomicAdd SDL_AtomicAdd a n -- n", "FUNCTION: SDL_AtomicAdd ( a v -- n )", "EXTERN: \"C\" int SDL_AtomicAdd( void * a, int v );", "	( a v -- )" );
	swigFunction( "c-function SDL_AtomicCASPtr SDL_AtomicCASPtr a a a -- n", "FUNCTION: SDL_AtomicCASPtr ( a oldval newval -- n )", "EXTERN: \"C\" int SDL_AtomicCASPtr( void * a, void * oldval, void * newval );", "	( a oldval newval -- )" );
	swigFunction( "c-function SDL_AtomicSetPtr SDL_AtomicSetPtr a a -- a", "FUNCTION: SDL_AtomicSetPtr ( a v -- a )", "EXTERN: \"C\" void * SDL_AtomicSetPtr( void * a, void * v );", "	( a v -- )" );
	swigFunction( "c-function SDL_AtomicGetPtr SDL_AtomicGetPtr a -- a", "FUNCTION: SDL_AtomicGetPtr ( a -- a )", "EXTERN: \"C\" void * SDL_AtomicGetPtr( void * a );", "	( a -- )" );
	swigFunction( "c-function SDL_GetNumAudioDrivers SDL_GetNumAudioDrivers  -- n", "FUNCTION: SDL_GetNumAudioDrivers (  -- n )", "EXTERN: \"C\" int SDL_GetNumAudioDrivers(  );", "	( -- )" );
	swigFunction( "c-function SDL_GetAudioDriver SDL_GetAudioDriver n -- s", "FUNCTION: SDL_GetAudioDriver ( index -- s )", "EXTERN: \"C\" char * SDL_GetAudioDriver( int index );", "	( index -- )" );
	swigFunction( "c-function SDL_AudioInit SDL_AudioInit s -- n", "FUNCTION: SDL_AudioInit ( driver_name -- n )", "EXTERN: \"C\" int SDL_AudioInit( char * driver_name );", "	( driver_name -- )" );
	swigFunction( "c-function SDL_AudioQuit SDL_AudioQuit  -- void", "FUNCTION: SDL_AudioQuit (  -- void )", "EXTERN: \"C\" void SDL_AudioQuit(  );", "	( -- )" );
	swigFunction( "c-function SDL_GetCurrentAudioDriver SDL_GetCurrentAudioDriver  -- s", "FUNCTION: SDL_GetCurrentAudioDriver (  -- s )", "EXTERN: \"C\" char * SDL_GetCurrentAudioDriver(  );", "	( -- )" );
	swigFunction( "c-function SDL_OpenAudio SDL_OpenAudio a a -- n", "FUNCTION: SDL_OpenAudio ( desired obtained -- n )", "EXTERN: \"C\" int SDL_OpenAudio( void * desired, void * obtained );", "	( desired obtained -- )" );
	swigFunction( "c-function SDL_GetNumAudioDevices SDL_GetNumAudioDevices n -- n", "FUNCTION: SDL_GetNumAudioDevices ( iscapture -- n )", "EXTERN: \"C\" int SDL_GetNumAudioDevices( int iscapture );", "	( iscapture -- )" );
	swigFunction( "c-function SDL_GetAudioDeviceName SDL_GetAudioDeviceName n n -- s", "FUNCTION: SDL_GetAudioDeviceName ( index iscapture -- s )", "EXTERN: \"C\" char * SDL_GetAudioDeviceName( int index, int iscapture );", "	( index iscapture -- )" );
	swigFunction( "c-function SDL_GetAudioDeviceSpec SDL_GetAudioDeviceSpec n n a -- n", "FUNCTION: SDL_GetAudioDeviceSpec ( index iscapture spec -- n )", "EXTERN: \"C\" int SDL_GetAudioDeviceSpec( int index, int iscapture, void * spec );", "	( index iscapture spec -- )" );
	swigFunction( "c-function SDL_OpenAudioDevice SDL_OpenAudioDevice s n a a n -- u", "FUNCTION: SDL_OpenAudioDevice ( device iscapture desired obtained allowed_changes -- u )", "EXTERN: \"C\" int SDL_OpenAudioDevice( char * device, int iscapture, void * desired, void * obtained, int allowed_changes );", "	( device iscapture desired obtained allowed_changes -- )" );
	swigFunction( "c-function SDL_GetAudioStatus SDL_GetAudioStatus  -- n", "FUNCTION: SDL_GetAudioStatus (  -- n )", "EXTERN: \"C\" int SDL_GetAudioStatus(  );", "	( -- )" );
	swigFunction( "c-function SDL_GetAudioDeviceStatus SDL_GetAudioDeviceStatus u -- n", "FUNCTION: SDL_GetAudioDeviceStatus ( dev -- n )", "EXTERN: \"C\" int SDL_GetAudioDeviceStatus( int dev );", "	( dev -- )" );
	swigFunction( "c-function SDL_PauseAudio SDL_PauseAudio n -- void", "FUNCTION: SDL_PauseAudio ( pause_on -- void )", "EXTERN: \"C\" void SDL_PauseAudio( int pause_on );", "	( pause_on -- )" );
	swigFunction( "c-function SDL_PauseAudioDevice SDL_PauseAudioDevice u n -- void", "FUNCTION: SDL_PauseAudioDevice ( dev pause_on -- void )", "EXTERN: \"C\" void SDL_PauseAudioDevice( int dev, int pause_on );", "	( dev pause_on -- )" );
	swigFunction( "c-function SDL_LoadWAV_RW SDL_LoadWAV_RW a n a a a -- a", "FUNCTION: SDL_LoadWAV_RW ( src freesrc spec audio_buf audio_len -- a )", "EXTERN: \"C\" void * SDL_LoadWAV_RW( void * src, int freesrc, void * spec, void * audio_buf, void * audio_len );", "	( src freesrc spec audio_buf audio_len -- )" );
	swigFunction( "c-function SDL_FreeWAV SDL_FreeWAV a -- void", "FUNCTION: SDL_FreeWAV ( audio_buf -- void )", "EXTERN: \"C\" void SDL_FreeWAV( void * audio_buf );", "	( audio_buf -- )" );
	swigFunction( "c-function SDL_BuildAudioCVT SDL_BuildAudioCVT a u u n u u n -- n", "FUNCTION: SDL_BuildAudioCVT ( cvt src_format src_channels src_rate dst_format dst_channels dst_rate -- n )", "EXTERN: \"C\" int SDL_BuildAudioCVT( void * cvt, int src_format, int src_channels, int src_rate, int dst_format, int dst_channels, int dst_rate );", "	( cvt src_format src_channels src_rate dst_format dst_channels dst_rate -- )" );
	swigFunction( "c-function SDL_ConvertAudio SDL_ConvertAudio a -- n", "FUNCTION: SDL_ConvertAudio ( cvt -- n )", "EXTERN: \"C\" int SDL_ConvertAudio( void * cvt );", "	( cvt -- )" );
	swigFunction( "c-function SDL_NewAudioStream SDL_NewAudioStream u u n u u n -- a", "FUNCTION: SDL_NewAudioStream ( src_format src_channels src_rate dst_format dst_channels dst_rate -- a )", "EXTERN: \"C\" void * SDL_NewAudioStream( int src_format, int src_channels, int src_rate, int dst_format, int dst_channels, int dst_rate );", "	( src_format src_channels src_rate dst_format dst_channels dst_rate -- )" );
	swigFunction( "c-function SDL_AudioStreamPut SDL_AudioStreamPut a a n -- n", "FUNCTION: SDL_AudioStreamPut ( stream buf len -- n )", "EXTERN: \"C\" int SDL_AudioStreamPut( void * stream, void * buf, int len );", "	( stream buf len -- )" );
	swigFunction( "c-function SDL_AudioStreamGet SDL_AudioStreamGet a a n -- n", "FUNCTION: SDL_AudioStreamGet ( stream buf len -- n )", "EXTERN: \"C\" int SDL_AudioStreamGet( void * stream, void * buf, int len );", "	( stream buf len -- )" );
	swigFunction( "c-function SDL_AudioStreamAvailable SDL_AudioStreamAvailable a -- n", "FUNCTION: SDL_AudioStreamAvailable ( stream -- n )", "EXTERN: \"C\" int SDL_AudioStreamAvailable( void * stream );", "	( stream -- )" );
	swigFunction( "c-function SDL_AudioStreamFlush SDL_AudioStreamFlush a -- n", "FUNCTION: SDL_AudioStreamFlush ( stream -- n )", "EXTERN: \"C\" int SDL_AudioStreamFlush( void * stream );", "	( stream -- )" );
	swigFunction( "c-function SDL_AudioStreamClear SDL_AudioStreamClear a -- void", "FUNCTION: SDL_AudioStreamClear ( stream -- void )", "EXTERN: \"C\" void SDL_AudioStreamClear( void * stream );", "	( stream -- )" );
	swigFunction( "c-function SDL_FreeAudioStream SDL_FreeAudioStream a -- void", "FUNCTION: SDL_FreeAudioStream ( stream -- void )", "EXTERN: \"C\" void SDL_FreeAudioStream( void * stream );", "	( stream -- )" );
	swigFunction( "c-function SDL_MixAudio SDL_MixAudio a a u n -- void", "FUNCTION: SDL_MixAudio ( dst src len volume -- void )", "EXTERN: \"C\" void SDL_MixAudio( void * dst, void * src, int len, int volume );", "	( dst src len volume -- )" );
	swigFunction( "c-function SDL_MixAudioFormat SDL_MixAudioFormat a a u u n -- void", "FUNCTION: SDL_MixAudioFormat ( dst src format len volume -- void )", "EXTERN: \"C\" void SDL_MixAudioFormat( void * dst, void * src, int format, int len, int volume );", "	( dst src format len volume -- )" );
	swigFunction( "c-function SDL_QueueAudio SDL_QueueAudio u a u -- n", "FUNCTION: SDL_QueueAudio ( dev data len -- n )", "EXTERN: \"C\" int SDL_QueueAudio( int dev, void * data, int len );", "	( dev data len -- )" );
	swigFunction( "c-function SDL_DequeueAudio SDL_DequeueAudio u a u -- u", "FUNCTION: SDL_DequeueAudio ( dev data len -- u )", "EXTERN: \"C\" int SDL_DequeueAudio( int dev, void * data, int len );", "	( dev data len -- )" );
	swigFunction( "c-function SDL_GetQueuedAudioSize SDL_GetQueuedAudioSize u -- u", "FUNCTION: SDL_GetQueuedAudioSize ( dev -- u )", "EXTERN: \"C\" int SDL_GetQueuedAudioSize( int dev );", "	( dev -- )" );
	swigFunction( "c-function SDL_ClearQueuedAudio SDL_ClearQueuedAudio u -- void", "FUNCTION: SDL_ClearQueuedAudio ( dev -- void )", "EXTERN: \"C\" void SDL_ClearQueuedAudio( int dev );", "	( dev -- )" );
	swigFunction( "c-function SDL_LockAudio SDL_LockAudio  -- void", "FUNCTION: SDL_LockAudio (  -- void )", "EXTERN: \"C\" void SDL_LockAudio(  );", "	( -- )" );
	swigFunction( "c-function SDL_LockAudioDevice SDL_LockAudioDevice u -- void", "FUNCTION: SDL_LockAudioDevice ( dev -- void )", "EXTERN: \"C\" void SDL_LockAudioDevice( int dev );", "	( dev -- )" );
	swigFunction( "c-function SDL_UnlockAudio SDL_UnlockAudio  -- void", "FUNCTION: SDL_UnlockAudio (  -- void )", "EXTERN: \"C\" void SDL_UnlockAudio(  );", "	( -- )" );
	swigFunction( "c-function SDL_UnlockAudioDevice SDL_UnlockAudioDevice u -- void", "FUNCTION: SDL_UnlockAudioDevice ( dev -- void )", "EXTERN: \"C\" void SDL_UnlockAudioDevice( int dev );", "	( dev -- )" );
	swigFunction( "c-function SDL_CloseAudio SDL_CloseAudio  -- void", "FUNCTION: SDL_CloseAudio (  -- void )", "EXTERN: \"C\" void SDL_CloseAudio(  );", "	( -- )" );
	swigFunction( "c-function SDL_CloseAudioDevice SDL_CloseAudioDevice u -- void", "FUNCTION: SDL_CloseAudioDevice ( dev -- void )", "EXTERN: \"C\" void SDL_CloseAudioDevice( int dev );", "	( dev -- )" );
	swigFunction( "c-function SDL_SetClipboardText SDL_SetClipboardText s -- n", "FUNCTION: SDL_SetClipboardText ( text -- n )", "EXTERN: \"C\" int SDL_SetClipboardText( char * text );", "	( text -- )" );
	swigFunction( "c-function SDL_GetClipboardText SDL_GetClipboardText  -- a", "FUNCTION: SDL_GetClipboardText (  -- a )", "EXTERN: \"C\" void * SDL_GetClipboardText(  );", "	( -- )" );
	swigFunction( "c-function SDL_HasClipboardText SDL_HasClipboardText  -- n", "FUNCTION: SDL_HasClipboardText (  -- n )", "EXTERN: \"C\" int SDL_HasClipboardText(  );", "	( -- )" );
	swigFunction( "c-function SDL_GetCPUCount SDL_GetCPUCount  -- n", "FUNCTION: SDL_GetCPUCount (  -- n )", "EXTERN: \"C\" int SDL_GetCPUCount(  );", "	( -- )" );
	swigFunction( "c-function SDL_GetCPUCacheLineSize SDL_GetCPUCacheLineSize  -- n", "FUNCTION: SDL_GetCPUCacheLineSize (  -- n )", "EXTERN: \"C\" int SDL_GetCPUCacheLineSize(  );", "	( -- )" );
	swigFunction( "c-function SDL_HasRDTSC SDL_HasRDTSC  -- n", "FUNCTION: SDL_HasRDTSC (  -- n )", "EXTERN: \"C\" int SDL_HasRDTSC(  );", "	( -- )" );
	swigFunction( "c-function SDL_HasAltiVec SDL_HasAltiVec  -- n", "FUNCTION: SDL_HasAltiVec (  -- n )", "EXTERN: \"C\" int SDL_HasAltiVec(  );", "	( -- )" );
	swigFunction( "c-function SDL_HasMMX SDL_HasMMX  -- n", "FUNCTION: SDL_HasMMX (  -- n )", "EXTERN: \"C\" int SDL_HasMMX(  );", "	( -- )" );
	swigFunction( "c-function SDL_Has3DNow SDL_Has3DNow  -- n", "FUNCTION: SDL_Has3DNow (  -- n )", "EXTERN: \"C\" int SDL_Has3DNow(  );", "	( -- )" );
	swigFunction( "c-function SDL_HasSSE SDL_HasSSE  -- n", "FUNCTION: SDL_HasSSE (  -- n )", "EXTERN: \"C\" int SDL_HasSSE(  );", "	( -- )" );
	swigFunction( "c-function SDL_HasSSE2 SDL_HasSSE2  -- n", "FUNCTION: SDL_HasSSE2 (  -- n )", "EXTERN: \"C\" int SDL_HasSSE2(  );", "	( -- )" );
	swigFunction( "c-function SDL_HasSSE3 SDL_HasSSE3  -- n", "FUNCTION: SDL_HasSSE3 (  -- n )", "EXTERN: \"C\" int SDL_HasSSE3(  );", "	( -- )" );
	swigFunction( "c-function SDL_HasSSE41 SDL_HasSSE41  -- n", "FUNCTION: SDL_HasSSE41 (  -- n )", "EXTERN: \"C\" int SDL_HasSSE41(  );", "	( -- )" );
	swigFunction( "c-function SDL_HasSSE42 SDL_HasSSE42  -- n", "FUNCTION: SDL_HasSSE42 (  -- n )", "EXTERN: \"C\" int SDL_HasSSE42(  );", "	( -- )" );
	swigFunction( "c-function SDL_HasAVX SDL_HasAVX  -- n", "FUNCTION: SDL_HasAVX (  -- n )", "EXTERN: \"C\" int SDL_HasAVX(  );", "	( -- )" );
	swigFunction( "c-function SDL_HasAVX2 SDL_HasAVX2  -- n", "FUNCTION: SDL_HasAVX2 (  -- n )", "EXTERN: \"C\" int SDL_HasAVX2(  );", "	( -- )" );
	swigFunction( "c-function SDL_HasAVX512F SDL_HasAVX512F  -- n", "FUNCTION: SDL_HasAVX512F (  -- n )", "EXTERN: \"C\" int SDL_HasAVX512F(  );", "	( -- )" );
	swigFunction( "c-function SDL_HasARMSIMD SDL_HasARMSIMD  -- n", "FUNCTION: SDL_HasARMSIMD (  -- n )", "EXTERN: \"C\" int SDL_HasARMSIMD(  );", "	( -- )" );
	swigFunction( "c-function SDL_HasNEON SDL_HasNEON  -- n", "FUNCTION: SDL_HasNEON (  -- n )", "EXTERN: \"C\" int SDL_HasNEON(  );", "	( -- )" );
	swigFunction( "c-function SDL_GetSystemRAM SDL_GetSystemRAM  -- n", "FUNCTION: SDL_GetSystemRAM (  -- n )", "EXTERN: \"C\" int SDL_GetSystemRAM(  );", "	( -- )" );
	swigFunction( "c-function SDL_SIMDGetAlignment SDL_SIMDGetAlignment  -- u", "FUNCTION: SDL_SIMDGetAlignment (  -- u )", "EXTERN: \"C\" int SDL_SIMDGetAlignment(  );", "	( -- )" );
	swigFunction( "c-function SDL_SIMDAlloc SDL_SIMDAlloc u -- a", "FUNCTION: SDL_SIMDAlloc ( len -- a )", "EXTERN: \"C\" void * SDL_SIMDAlloc( int len );", "	( len -- )" );
	swigFunction( "c-function SDL_SIMDRealloc SDL_SIMDRealloc a u -- a", "FUNCTION: SDL_SIMDRealloc ( mem len -- a )", "EXTERN: \"C\" void * SDL_SIMDRealloc( void * mem, int len );", "	( mem len -- )" );
	swigFunction( "c-function SDL_SIMDFree SDL_SIMDFree a -- void", "FUNCTION: SDL_SIMDFree ( ptr -- void )", "EXTERN: \"C\" void SDL_SIMDFree( void * ptr );", "	( ptr -- )" );
	swigFunction( "c-function SDL_Swap16 SDL_Swap16 u -- u", "FUNCTION: SDL_Swap16 ( x -- u )", "EXTERN: \"C\" int SDL_Swap16( int x );", "	( x -- )" );
	swigFunction( "c-function SDL_Swap32 SDL_Swap32 u -- u", "FUNCTION: SDL_Swap32 ( x -- u )", "EXTERN: \"C\" int SDL_Swap32( int x );", "	( x -- )" );
	swigFunction( "c-function SDL_Swap64 SDL_Swap64 ud -- ud", "FUNCTION: SDL_Swap64 ( x -- ud )", "EXTERN: \"C\" long long SDL_Swap64( long long x );", "	( x -- )" );
	swigFunction( "c-function SDL_SwapFloat SDL_SwapFloat r -- r", "FUNCTION: SDL_SwapFloat ( x -- r )", "EXTERN: \"C\" float SDL_SwapFloat( float x );", "	( x -- )" );
	swigFunction( "c-function SDL_SetError SDL_SetError s ... -- n", "FUNCTION: SDL_SetError ( fmt  -- n )", "EXTERN: \"C\" int SDL_SetError( char * fmt, ...  );", "	( fmt <noname> -- )" );
	swigFunction( "c-function SDL_GetError SDL_GetError  -- s", "FUNCTION: SDL_GetError (  -- s )", "EXTERN: \"C\" char * SDL_GetError(  );", "	( -- )" );
	swigFunction( "c-function SDL_GetErrorMsg SDL_GetErrorMsg a n -- a", "FUNCTION: SDL_GetErrorMsg ( errstr maxlen -- a )", "EXTERN: \"C\" void * SDL_GetErrorMsg( void * errstr, int maxlen );", "	( errstr maxlen -- )" );
	swigFunction( "c-function SDL_ClearError SDL_ClearError  -- void", "FUNCTION: SDL_ClearError (  -- void )", "EXTERN: \"C\" void SDL_ClearError(  );", "	( -- )" );
	swigFunction( "c-function SDL_Error SDL_Error n -- n", "FUNCTION: SDL_Error ( code -- n )", "EXTERN: \"C\" int SDL_Error( int code );", "	( code -- )" );
	swigFunction( "c-function SDL_PumpEvents SDL_PumpEvents  -- void", "FUNCTION: SDL_PumpEvents (  -- void )", "EXTERN: \"C\" void SDL_PumpEvents(  );", "	( -- )" );
	swigFunction( "c-function SDL_PeepEvents SDL_PeepEvents a n n u u -- n", "FUNCTION: SDL_PeepEvents ( events numevents action minType maxType -- n )", "EXTERN: \"C\" int SDL_PeepEvents( void * events, int numevents, int action, int minType, int maxType );", "	( events numevents action minType maxType -- )" );
	swigFunction( "c-function SDL_HasEvent SDL_HasEvent u -- n", "FUNCTION: SDL_HasEvent ( type -- n )", "EXTERN: \"C\" int SDL_HasEvent( int type );", "	( type -- )" );
	swigFunction( "c-function SDL_HasEvents SDL_HasEvents u u -- n", "FUNCTION: SDL_HasEvents ( minType maxType -- n )", "EXTERN: \"C\" int SDL_HasEvents( int minType, int maxType );", "	( minType maxType -- )" );
	swigFunction( "c-function SDL_FlushEvent SDL_FlushEvent u -- void", "FUNCTION: SDL_FlushEvent ( type -- void )", "EXTERN: \"C\" void SDL_FlushEvent( int type );", "	( type -- )" );
	swigFunction( "c-function SDL_FlushEvents SDL_FlushEvents u u -- void", "FUNCTION: SDL_FlushEvents ( minType maxType -- void )", "EXTERN: \"C\" void SDL_FlushEvents( int minType, int maxType );", "	( minType maxType -- )" );
	swigFunction( "c-function SDL_PollEvent SDL_PollEvent a -- n", "FUNCTION: SDL_PollEvent ( event -- n )", "EXTERN: \"C\" int SDL_PollEvent( void * event );", "	( event -- )" );
	swigFunction( "c-function SDL_WaitEvent SDL_WaitEvent a -- n", "FUNCTION: SDL_WaitEvent ( event -- n )", "EXTERN: \"C\" int SDL_WaitEvent( void * event );", "	( event -- )" );
	swigFunction( "c-function SDL_WaitEventTimeout SDL_WaitEventTimeout a n -- n", "FUNCTION: SDL_WaitEventTimeout ( event timeout -- n )", "EXTERN: \"C\" int SDL_WaitEventTimeout( void * event, int timeout );", "	( event timeout -- )" );
	swigFunction( "c-function SDL_PushEvent SDL_PushEvent a -- n", "FUNCTION: SDL_PushEvent ( event -- n )", "EXTERN: \"C\" int SDL_PushEvent( void * event );", "	( event -- )" );
	swigFunction( "c-function SDL_SetEventFilter SDL_SetEventFilter a a -- void", "FUNCTION: SDL_SetEventFilter ( filter userdata -- void )", "EXTERN: \"C\" void SDL_SetEventFilter( void * filter, void * userdata );", "	( filter userdata -- )" );
	swigFunction( "c-function SDL_GetEventFilter SDL_GetEventFilter a a -- n", "FUNCTION: SDL_GetEventFilter ( filter userdata -- n )", "EXTERN: \"C\" int SDL_GetEventFilter( void * filter, void * userdata );", "	( filter userdata -- )" );
	swigFunction( "c-function SDL_AddEventWatch SDL_AddEventWatch a a -- void", "FUNCTION: SDL_AddEventWatch ( filter userdata -- void )", "EXTERN: \"C\" void SDL_AddEventWatch( void * filter, void * userdata );", "	( filter userdata -- )" );
	swigFunction( "c-function SDL_DelEventWatch SDL_DelEventWatch a a -- void", "FUNCTION: SDL_DelEventWatch ( filter userdata -- void )", "EXTERN: \"C\" void SDL_DelEventWatch( void * filter, void * userdata );", "	( filter userdata -- )" );
	swigFunction( "c-function SDL_FilterEvents SDL_FilterEvents a a -- void", "FUNCTION: SDL_FilterEvents ( filter userdata -- void )", "EXTERN: \"C\" void SDL_FilterEvents( void * filter, void * userdata );", "	( filter userdata -- )" );
	swigFunction( "c-function SDL_EventState SDL_EventState u n -- u", "FUNCTION: SDL_EventState ( type state -- u )", "EXTERN: \"C\" int SDL_EventState( int type, int state );", "	( type state -- )" );
	swigFunction( "c-function SDL_RegisterEvents SDL_RegisterEvents n -- u", "FUNCTION: SDL_RegisterEvents ( numevents -- u )", "EXTERN: \"C\" int SDL_RegisterEvents( int numevents );", "	( numevents -- )" );
	swigFunction( "c-function SDL_GetBasePath SDL_GetBasePath  -- a", "FUNCTION: SDL_GetBasePath (  -- a )", "EXTERN: \"C\" void * SDL_GetBasePath(  );", "	( -- )" );
	swigFunction( "c-function SDL_GetPrefPath SDL_GetPrefPath s s -- a", "FUNCTION: SDL_GetPrefPath ( org app -- a )", "EXTERN: \"C\" void * SDL_GetPrefPath( char * org, char * app );", "	( org app -- )" );
	swigFunction( "c-function SDL_NumHaptics SDL_NumHaptics  -- n", "FUNCTION: SDL_NumHaptics (  -- n )", "EXTERN: \"C\" int SDL_NumHaptics(  );", "	( -- )" );
	swigFunction( "c-function SDL_HapticName SDL_HapticName n -- s", "FUNCTION: SDL_HapticName ( device_index -- s )", "EXTERN: \"C\" char * SDL_HapticName( int device_index );", "	( device_index -- )" );
	swigFunction( "c-function SDL_HapticOpen SDL_HapticOpen n -- a", "FUNCTION: SDL_HapticOpen ( device_index -- a )", "EXTERN: \"C\" void * SDL_HapticOpen( int device_index );", "	( device_index -- )" );
	swigFunction( "c-function SDL_HapticOpened SDL_HapticOpened n -- n", "FUNCTION: SDL_HapticOpened ( device_index -- n )", "EXTERN: \"C\" int SDL_HapticOpened( int device_index );", "	( device_index -- )" );
	swigFunction( "c-function SDL_HapticIndex SDL_HapticIndex a -- n", "FUNCTION: SDL_HapticIndex ( haptic -- n )", "EXTERN: \"C\" int SDL_HapticIndex( void * haptic );", "	( haptic -- )" );
	swigFunction( "c-function SDL_MouseIsHaptic SDL_MouseIsHaptic  -- n", "FUNCTION: SDL_MouseIsHaptic (  -- n )", "EXTERN: \"C\" int SDL_MouseIsHaptic(  );", "	( -- )" );
	swigFunction( "c-function SDL_HapticOpenFromMouse SDL_HapticOpenFromMouse  -- a", "FUNCTION: SDL_HapticOpenFromMouse (  -- a )", "EXTERN: \"C\" void * SDL_HapticOpenFromMouse(  );", "	( -- )" );
	swigFunction( "c-function SDL_JoystickIsHaptic SDL_JoystickIsHaptic a -- n", "FUNCTION: SDL_JoystickIsHaptic ( joystick -- n )", "EXTERN: \"C\" int SDL_JoystickIsHaptic( void * joystick );", "	( joystick -- )" );
	swigFunction( "c-function SDL_HapticOpenFromJoystick SDL_HapticOpenFromJoystick a -- a", "FUNCTION: SDL_HapticOpenFromJoystick ( joystick -- a )", "EXTERN: \"C\" void * SDL_HapticOpenFromJoystick( void * joystick );", "	( joystick -- )" );
	swigFunction( "c-function SDL_HapticClose SDL_HapticClose a -- void", "FUNCTION: SDL_HapticClose ( haptic -- void )", "EXTERN: \"C\" void SDL_HapticClose( void * haptic );", "	( haptic -- )" );
	swigFunction( "c-function SDL_HapticNumEffects SDL_HapticNumEffects a -- n", "FUNCTION: SDL_HapticNumEffects ( haptic -- n )", "EXTERN: \"C\" int SDL_HapticNumEffects( void * haptic );", "	( haptic -- )" );
	swigFunction( "c-function SDL_HapticNumEffectsPlaying SDL_HapticNumEffectsPlaying a -- n", "FUNCTION: SDL_HapticNumEffectsPlaying ( haptic -- n )", "EXTERN: \"C\" int SDL_HapticNumEffectsPlaying( void * haptic );", "	( haptic -- )" );
	swigFunction( "c-function SDL_HapticQuery SDL_HapticQuery a -- u", "FUNCTION: SDL_HapticQuery ( haptic -- u )", "EXTERN: \"C\" int SDL_HapticQuery( void * haptic );", "	( haptic -- )" );
	swigFunction( "c-function SDL_HapticNumAxes SDL_HapticNumAxes a -- n", "FUNCTION: SDL_HapticNumAxes ( haptic -- n )", "EXTERN: \"C\" int SDL_HapticNumAxes( void * haptic );", "	( haptic -- )" );
	swigFunction( "c-function SDL_HapticEffectSupported SDL_HapticEffectSupported a a -- n", "FUNCTION: SDL_HapticEffectSupported ( haptic effect -- n )", "EXTERN: \"C\" int SDL_HapticEffectSupported( void * haptic, void * effect );", "	( haptic effect -- )" );
	swigFunction( "c-function SDL_HapticNewEffect SDL_HapticNewEffect a a -- n", "FUNCTION: SDL_HapticNewEffect ( haptic effect -- n )", "EXTERN: \"C\" int SDL_HapticNewEffect( void * haptic, void * effect );", "	( haptic effect -- )" );
	swigFunction( "c-function SDL_HapticUpdateEffect SDL_HapticUpdateEffect a n a -- n", "FUNCTION: SDL_HapticUpdateEffect ( haptic effect data -- n )", "EXTERN: \"C\" int SDL_HapticUpdateEffect( void * haptic, int effect, void * data );", "	( haptic effect data -- )" );
	swigFunction( "c-function SDL_HapticRunEffect SDL_HapticRunEffect a n u -- n", "FUNCTION: SDL_HapticRunEffect ( haptic effect iterations -- n )", "EXTERN: \"C\" int SDL_HapticRunEffect( void * haptic, int effect, int iterations );", "	( haptic effect iterations -- )" );
	swigFunction( "c-function SDL_HapticStopEffect SDL_HapticStopEffect a n -- n", "FUNCTION: SDL_HapticStopEffect ( haptic effect -- n )", "EXTERN: \"C\" int SDL_HapticStopEffect( void * haptic, int effect );", "	( haptic effect -- )" );
	swigFunction( "c-function SDL_HapticDestroyEffect SDL_HapticDestroyEffect a n -- void", "FUNCTION: SDL_HapticDestroyEffect ( haptic effect -- void )", "EXTERN: \"C\" void SDL_HapticDestroyEffect( void * haptic, int effect );", "	( haptic effect -- )" );
	swigFunction( "c-function SDL_HapticGetEffectStatus SDL_HapticGetEffectStatus a n -- n", "FUNCTION: SDL_HapticGetEffectStatus ( haptic effect -- n )", "EXTERN: \"C\" int SDL_HapticGetEffectStatus( void * haptic, int effect );", "	( haptic effect -- )" );
	swigFunction( "c-function SDL_HapticSetGain SDL_HapticSetGain a n -- n", "FUNCTION: SDL_HapticSetGain ( haptic gain -- n )", "EXTERN: \"C\" int SDL_HapticSetGain( void * haptic, int gain );", "	( haptic gain -- )" );
	swigFunction( "c-function SDL_HapticSetAutocenter SDL_HapticSetAutocenter a n -- n", "FUNCTION: SDL_HapticSetAutocenter ( haptic autocenter -- n )", "EXTERN: \"C\" int SDL_HapticSetAutocenter( void * haptic, int autocenter );", "	( haptic autocenter -- )" );
	swigFunction( "c-function SDL_HapticPause SDL_HapticPause a -- n", "FUNCTION: SDL_HapticPause ( haptic -- n )", "EXTERN: \"C\" int SDL_HapticPause( void * haptic );", "	( haptic -- )" );
	swigFunction( "c-function SDL_HapticUnpause SDL_HapticUnpause a -- n", "FUNCTION: SDL_HapticUnpause ( haptic -- n )", "EXTERN: \"C\" int SDL_HapticUnpause( void * haptic );", "	( haptic -- )" );
	swigFunction( "c-function SDL_HapticStopAll SDL_HapticStopAll a -- n", "FUNCTION: SDL_HapticStopAll ( haptic -- n )", "EXTERN: \"C\" int SDL_HapticStopAll( void * haptic );", "	( haptic -- )" );
	swigFunction( "c-function SDL_HapticRumbleSupported SDL_HapticRumbleSupported a -- n", "FUNCTION: SDL_HapticRumbleSupported ( haptic -- n )", "EXTERN: \"C\" int SDL_HapticRumbleSupported( void * haptic );", "	( haptic -- )" );
	swigFunction( "c-function SDL_HapticRumbleInit SDL_HapticRumbleInit a -- n", "FUNCTION: SDL_HapticRumbleInit ( haptic -- n )", "EXTERN: \"C\" int SDL_HapticRumbleInit( void * haptic );", "	( haptic -- )" );
	swigFunction( "c-function SDL_HapticRumblePlay SDL_HapticRumblePlay a r u -- n", "FUNCTION: SDL_HapticRumblePlay ( haptic strength length -- n )", "EXTERN: \"C\" int SDL_HapticRumblePlay( void * haptic, float strength, int length );", "	( haptic strength length -- )" );
	swigFunction( "c-function SDL_HapticRumbleStop SDL_HapticRumbleStop a -- n", "FUNCTION: SDL_HapticRumbleStop ( haptic -- n )", "EXTERN: \"C\" int SDL_HapticRumbleStop( void * haptic );", "	( haptic -- )" );
	swigFunction( "c-function SDL_hid_init SDL_hid_init  -- n", "FUNCTION: SDL_hid_init (  -- n )", "EXTERN: \"C\" int SDL_hid_init(  );", "	( -- )" );
	swigFunction( "c-function SDL_hid_exit SDL_hid_exit  -- n", "FUNCTION: SDL_hid_exit (  -- n )", "EXTERN: \"C\" int SDL_hid_exit(  );", "	( -- )" );
	swigFunction( "c-function SDL_hid_device_change_count SDL_hid_device_change_count  -- u", "FUNCTION: SDL_hid_device_change_count (  -- u )", "EXTERN: \"C\" int SDL_hid_device_change_count(  );", "	( -- )" );
	swigFunction( "c-function SDL_hid_enumerate SDL_hid_enumerate u u -- a", "FUNCTION: SDL_hid_enumerate ( vendor_id product_id -- a )", "EXTERN: \"C\" void * SDL_hid_enumerate( short vendor_id, short product_id );", "	( vendor_id product_id -- )" );
	swigFunction( "c-function SDL_hid_free_enumeration SDL_hid_free_enumeration a -- void", "FUNCTION: SDL_hid_free_enumeration ( devs -- void )", "EXTERN: \"C\" void SDL_hid_free_enumeration( void * devs );", "	( devs -- )" );
	swigFunction( "c-function SDL_hid_open SDL_hid_open u u ws -- a", "FUNCTION: SDL_hid_open ( vendor_id product_id serial_number -- a )", "EXTERN: \"C\" void * SDL_hid_open( short vendor_id, short product_id, char * serial_number );", "	( vendor_id product_id serial_number -- )" );
	swigFunction( "c-function SDL_hid_open_path SDL_hid_open_path s n -- a", "FUNCTION: SDL_hid_open_path ( path bExclusive -- a )", "EXTERN: \"C\" void * SDL_hid_open_path( char * path, int bExclusive );", "	( path bExclusive -- )" );
	swigFunction( "c-function SDL_hid_write SDL_hid_write a a u -- n", "FUNCTION: SDL_hid_write ( dev data length -- n )", "EXTERN: \"C\" int SDL_hid_write( void * dev, void * data, int length );", "	( dev data length -- )" );
	swigFunction( "c-function SDL_hid_read_timeout SDL_hid_read_timeout a a u n -- n", "FUNCTION: SDL_hid_read_timeout ( dev data length milliseconds -- n )", "EXTERN: \"C\" int SDL_hid_read_timeout( void * dev, void * data, int length, int milliseconds );", "	( dev data length milliseconds -- )" );
	swigFunction( "c-function SDL_hid_read SDL_hid_read a a u -- n", "FUNCTION: SDL_hid_read ( dev data length -- n )", "EXTERN: \"C\" int SDL_hid_read( void * dev, void * data, int length );", "	( dev data length -- )" );
	swigFunction( "c-function SDL_hid_set_nonblocking SDL_hid_set_nonblocking a n -- n", "FUNCTION: SDL_hid_set_nonblocking ( dev nonblock -- n )", "EXTERN: \"C\" int SDL_hid_set_nonblocking( void * dev, int nonblock );", "	( dev nonblock -- )" );
	swigFunction( "c-function SDL_hid_send_feature_report SDL_hid_send_feature_report a a u -- n", "FUNCTION: SDL_hid_send_feature_report ( dev data length -- n )", "EXTERN: \"C\" int SDL_hid_send_feature_report( void * dev, void * data, int length );", "	( dev data length -- )" );
	swigFunction( "c-function SDL_hid_get_feature_report SDL_hid_get_feature_report a a u -- n", "FUNCTION: SDL_hid_get_feature_report ( dev data length -- n )", "EXTERN: \"C\" int SDL_hid_get_feature_report( void * dev, void * data, int length );", "	( dev data length -- )" );
	swigFunction( "c-function SDL_hid_close SDL_hid_close a -- void", "FUNCTION: SDL_hid_close ( dev -- void )", "EXTERN: \"C\" void SDL_hid_close( void * dev );", "	( dev -- )" );
	swigFunction( "c-function SDL_hid_get_manufacturer_string SDL_hid_get_manufacturer_string a a u -- n", "FUNCTION: SDL_hid_get_manufacturer_string ( dev string maxlen -- n )", "EXTERN: \"C\" int SDL_hid_get_manufacturer_string( void * dev, void * string, int maxlen );", "	( dev string maxlen -- )" );
	swigFunction( "c-function SDL_hid_get_product_string SDL_hid_get_product_string a a u -- n", "FUNCTION: SDL_hid_get_product_string ( dev string maxlen -- n )", "EXTERN: \"C\" int SDL_hid_get_product_string( void * dev, void * string, int maxlen );", "	( dev string maxlen -- )" );
	swigFunction( "c-function SDL_hid_get_serial_number_string SDL_hid_get_serial_number_string a a u -- n", "FUNCTION: SDL_hid_get_serial_number_string ( dev string maxlen -- n )", "EXTERN: \"C\" int SDL_hid_get_serial_number_string( void * dev, void * string, int maxlen );", "	( dev string maxlen -- )" );
	swigFunction( "c-function SDL_hid_get_indexed_string SDL_hid_get_indexed_string a n a u -- n", "FUNCTION: SDL_hid_get_indexed_string ( dev string_index string maxlen -- n )", "EXTERN: \"C\" int SDL_hid_get_indexed_string( void * dev, int string_index, void * string, int maxlen );", "	( dev string_index string maxlen -- )" );
	swigFunction( "c-function SDL_hid_ble_scan SDL_hid_ble_scan n -- void", "FUNCTION: SDL_hid_ble_scan ( active -- void )", "EXTERN: \"C\" void SDL_hid_ble_scan( int active );", "	( active -- )" );
	swigFunction( "c-function SDL_SetHintWithPriority SDL_SetHintWithPriority s s n -- n", "FUNCTION: SDL_SetHintWithPriority ( name value priority -- n )", "EXTERN: \"C\" int SDL_SetHintWithPriority( char * name, char * value, int priority );", "	( name value priority -- )" );
	swigFunction( "c-function SDL_SetHint SDL_SetHint s s -- n", "FUNCTION: SDL_SetHint ( name value -- n )", "EXTERN: \"C\" int SDL_SetHint( char * name, char * value );", "	( name value -- )" );
	swigFunction( "c-function SDL_GetHint SDL_GetHint s -- s", "FUNCTION: SDL_GetHint ( name -- s )", "EXTERN: \"C\" char * SDL_GetHint( char * name );", "	( name -- )" );
	swigFunction( "c-function SDL_GetHintBoolean SDL_GetHintBoolean s n -- n", "FUNCTION: SDL_GetHintBoolean ( name default_value -- n )", "EXTERN: \"C\" int SDL_GetHintBoolean( char * name, int default_value );", "	( name default_value -- )" );
	swigFunction( "c-function SDL_AddHintCallback SDL_AddHintCallback s a a -- void", "FUNCTION: SDL_AddHintCallback ( name callback userdata -- void )", "EXTERN: \"C\" void SDL_AddHintCallback( char * name, void * callback, void * userdata );", "	( name callback userdata -- )" );
	swigFunction( "c-function SDL_DelHintCallback SDL_DelHintCallback s a a -- void", "FUNCTION: SDL_DelHintCallback ( name callback userdata -- void )", "EXTERN: \"C\" void SDL_DelHintCallback( char * name, void * callback, void * userdata );", "	( name callback userdata -- )" );
	swigFunction( "c-function SDL_ClearHints SDL_ClearHints  -- void", "FUNCTION: SDL_ClearHints (  -- void )", "EXTERN: \"C\" void SDL_ClearHints(  );", "	( -- )" );
	swigFunction( "c-function SDL_LoadObject SDL_LoadObject s -- a", "FUNCTION: SDL_LoadObject ( sofile -- a )", "EXTERN: \"C\" void * SDL_LoadObject( char * sofile );", "	( sofile -- )" );
	swigFunction( "c-function SDL_LoadFunction SDL_LoadFunction a s -- a", "FUNCTION: SDL_LoadFunction ( handle name -- a )", "EXTERN: \"C\" void * SDL_LoadFunction( void * handle, char * name );", "	( handle name -- )" );
	swigFunction( "c-function SDL_UnloadObject SDL_UnloadObject a -- void", "FUNCTION: SDL_UnloadObject ( handle -- void )", "EXTERN: \"C\" void SDL_UnloadObject( void * handle );", "	( handle -- )" );
	swigFunction( "c-function SDL_LogSetAllPriority SDL_LogSetAllPriority n -- void", "FUNCTION: SDL_LogSetAllPriority ( priority -- void )", "EXTERN: \"C\" void SDL_LogSetAllPriority( int priority );", "	( priority -- )" );
	swigFunction( "c-function SDL_LogSetPriority SDL_LogSetPriority n n -- void", "FUNCTION: SDL_LogSetPriority ( category priority -- void )", "EXTERN: \"C\" void SDL_LogSetPriority( int category, int priority );", "	( category priority -- )" );
	swigFunction( "c-function SDL_LogGetPriority SDL_LogGetPriority n -- n", "FUNCTION: SDL_LogGetPriority ( category -- n )", "EXTERN: \"C\" int SDL_LogGetPriority( int category );", "	( category -- )" );
	swigFunction( "c-function SDL_LogResetPriorities SDL_LogResetPriorities  -- void", "FUNCTION: SDL_LogResetPriorities (  -- void )", "EXTERN: \"C\" void SDL_LogResetPriorities(  );", "	( -- )" );
	swigFunction( "c-function SDL_Log SDL_Log s ... -- void", "FUNCTION: SDL_Log ( fmt  -- void )", "EXTERN: \"C\" void SDL_Log( char * fmt, ...  );", "	( fmt <noname> -- )" );
	swigFunction( "c-function SDL_LogVerbose SDL_LogVerbose n s ... -- void", "FUNCTION: SDL_LogVerbose ( category fmt  -- void )", "EXTERN: \"C\" void SDL_LogVerbose( int category, char * fmt, ...  );", "	( category fmt <noname> -- )" );
	swigFunction( "c-function SDL_LogDebug SDL_LogDebug n s ... -- void", "FUNCTION: SDL_LogDebug ( category fmt  -- void )", "EXTERN: \"C\" void SDL_LogDebug( int category, char * fmt, ...  );", "	( category fmt <noname> -- )" );
	swigFunction( "c-function SDL_LogInfo SDL_LogInfo n s ... -- void", "FUNCTION: SDL_LogInfo ( category fmt  -- void )", "EXTERN: \"C\" void SDL_LogInfo( int category, char * fmt, ...  );", "	( category fmt <noname> -- )" );
	swigFunction( "c-function SDL_LogWarn SDL_LogWarn n s ... -- void", "FUNCTION: SDL_LogWarn ( category fmt  -- void )", "EXTERN: \"C\" void SDL_LogWarn( int category, char * fmt, ...  );", "	( category fmt <noname> -- )" );
	swigFunction( "c-function SDL_LogError SDL_LogError n s ... -- void", "FUNCTION: SDL_LogError ( category fmt  -- void )", "EXTERN: \"C\" void SDL_LogError( int category, char * fmt, ...  );", "	( category fmt <noname> -- )" );
	swigFunction( "c-function SDL_LogCritical SDL_LogCritical n s ... -- void", "FUNCTION: SDL_LogCritical ( category fmt  -- void )", "EXTERN: \"C\" void SDL_LogCritical( int category, char * fmt, ...  );", "	( category fmt <noname> -- )" );
	swigFunction( "c-function SDL_LogMessage SDL_LogMessage n n s ... -- void", "FUNCTION: SDL_LogMessage ( category priority fmt  -- void )", "EXTERN: \"C\" void SDL_LogMessage( int category, int priority, char * fmt, ...  );", "	( category priority fmt <noname> -- )" );
	swigFunction( "c-function SDL_LogMessageV SDL_LogMessageV n n s n -- void", "FUNCTION: SDL_LogMessageV ( category priority fmt ap -- void )", "EXTERN: \"C\" void SDL_LogMessageV( int category, int priority, char * fmt, long ap );", "	( category priority fmt ap -- )" );
	swigFunction( "c-function SDL_LogGetOutputFunction SDL_LogGetOutputFunction a a -- void", "FUNCTION: SDL_LogGetOutputFunction ( callback userdata -- void )", "EXTERN: \"C\" void SDL_LogGetOutputFunction( void * callback, void * userdata );", "	( callback userdata -- )" );
	swigFunction( "c-function SDL_LogSetOutputFunction SDL_LogSetOutputFunction a a -- void", "FUNCTION: SDL_LogSetOutputFunction ( callback userdata -- void )", "EXTERN: \"C\" void SDL_LogSetOutputFunction( void * callback, void * userdata );", "	( callback userdata -- )" );
	swigFunction( "c-function SDL_ShowMessageBox SDL_ShowMessageBox a a -- n", "FUNCTION: SDL_ShowMessageBox ( messageboxdata buttonid -- n )", "EXTERN: \"C\" int SDL_ShowMessageBox( void * messageboxdata, void * buttonid );", "	( messageboxdata buttonid -- )" );
	swigFunction( "c-function SDL_ShowSimpleMessageBox SDL_ShowSimpleMessageBox u s s a -- n", "FUNCTION: SDL_ShowSimpleMessageBox ( flags title message window -- n )", "EXTERN: \"C\" int SDL_ShowSimpleMessageBox( int flags, char * title, char * message, void * window );", "	( flags title message window -- )" );
	swigFunction( "c-function SDL_Metal_CreateView SDL_Metal_CreateView a -- a", "FUNCTION: SDL_Metal_CreateView ( window -- a )", "EXTERN: \"C\" void * SDL_Metal_CreateView( void * window );", "	( window -- )" );
	swigFunction( "c-function SDL_Metal_DestroyView SDL_Metal_DestroyView a -- void", "FUNCTION: SDL_Metal_DestroyView ( view -- void )", "EXTERN: \"C\" void SDL_Metal_DestroyView( void * view );", "	( view -- )" );
	swigFunction( "c-function SDL_Metal_GetLayer SDL_Metal_GetLayer a -- a", "FUNCTION: SDL_Metal_GetLayer ( view -- a )", "EXTERN: \"C\" void * SDL_Metal_GetLayer( void * view );", "	( view -- )" );
	swigFunction( "c-function SDL_Metal_GetDrawableSize SDL_Metal_GetDrawableSize a a a -- void", "FUNCTION: SDL_Metal_GetDrawableSize ( window w h -- void )", "EXTERN: \"C\" void SDL_Metal_GetDrawableSize( void * window, void * w, void * h );", "	( window w h -- )" );
	swigFunction( "c-function SDL_CreateMutex SDL_CreateMutex  -- a", "FUNCTION: SDL_CreateMutex (  -- a )", "EXTERN: \"C\" void * SDL_CreateMutex(  );", "	( -- )" );
	swigFunction( "c-function SDL_LockMutex SDL_LockMutex a -- n", "FUNCTION: SDL_LockMutex ( mutex -- n )", "EXTERN: \"C\" int SDL_LockMutex( void * mutex );", "	( mutex -- )" );
	swigFunction( "c-function SDL_TryLockMutex SDL_TryLockMutex a -- n", "FUNCTION: SDL_TryLockMutex ( mutex -- n )", "EXTERN: \"C\" int SDL_TryLockMutex( void * mutex );", "	( mutex -- )" );
	swigFunction( "c-function SDL_UnlockMutex SDL_UnlockMutex a -- n", "FUNCTION: SDL_UnlockMutex ( mutex -- n )", "EXTERN: \"C\" int SDL_UnlockMutex( void * mutex );", "	( mutex -- )" );
	swigFunction( "c-function SDL_DestroyMutex SDL_DestroyMutex a -- void", "FUNCTION: SDL_DestroyMutex ( mutex -- void )", "EXTERN: \"C\" void SDL_DestroyMutex( void * mutex );", "	( mutex -- )" );
	swigFunction( "c-function SDL_CreateSemaphore SDL_CreateSemaphore u -- a", "FUNCTION: SDL_CreateSemaphore ( initial_value -- a )", "EXTERN: \"C\" void * SDL_CreateSemaphore( int initial_value );", "	( initial_value -- )" );
	swigFunction( "c-function SDL_DestroySemaphore SDL_DestroySemaphore a -- void", "FUNCTION: SDL_DestroySemaphore ( sem -- void )", "EXTERN: \"C\" void SDL_DestroySemaphore( void * sem );", "	( sem -- )" );
	swigFunction( "c-function SDL_SemWait SDL_SemWait a -- n", "FUNCTION: SDL_SemWait ( sem -- n )", "EXTERN: \"C\" int SDL_SemWait( void * sem );", "	( sem -- )" );
	swigFunction( "c-function SDL_SemTryWait SDL_SemTryWait a -- n", "FUNCTION: SDL_SemTryWait ( sem -- n )", "EXTERN: \"C\" int SDL_SemTryWait( void * sem );", "	( sem -- )" );
	swigFunction( "c-function SDL_SemWaitTimeout SDL_SemWaitTimeout a u -- n", "FUNCTION: SDL_SemWaitTimeout ( sem ms -- n )", "EXTERN: \"C\" int SDL_SemWaitTimeout( void * sem, int ms );", "	( sem ms -- )" );
	swigFunction( "c-function SDL_SemPost SDL_SemPost a -- n", "FUNCTION: SDL_SemPost ( sem -- n )", "EXTERN: \"C\" int SDL_SemPost( void * sem );", "	( sem -- )" );
	swigFunction( "c-function SDL_SemValue SDL_SemValue a -- u", "FUNCTION: SDL_SemValue ( sem -- u )", "EXTERN: \"C\" int SDL_SemValue( void * sem );", "	( sem -- )" );
	swigFunction( "c-function SDL_CreateCond SDL_CreateCond  -- a", "FUNCTION: SDL_CreateCond (  -- a )", "EXTERN: \"C\" void * SDL_CreateCond(  );", "	( -- )" );
	swigFunction( "c-function SDL_DestroyCond SDL_DestroyCond a -- void", "FUNCTION: SDL_DestroyCond ( cond -- void )", "EXTERN: \"C\" void SDL_DestroyCond( void * cond );", "	( cond -- )" );
	swigFunction( "c-function SDL_CondSignal SDL_CondSignal a -- n", "FUNCTION: SDL_CondSignal ( cond -- n )", "EXTERN: \"C\" int SDL_CondSignal( void * cond );", "	( cond -- )" );
	swigFunction( "c-function SDL_CondBroadcast SDL_CondBroadcast a -- n", "FUNCTION: SDL_CondBroadcast ( cond -- n )", "EXTERN: \"C\" int SDL_CondBroadcast( void * cond );", "	( cond -- )" );
	swigFunction( "c-function SDL_CondWait SDL_CondWait a a -- n", "FUNCTION: SDL_CondWait ( cond mutex -- n )", "EXTERN: \"C\" int SDL_CondWait( void * cond, void * mutex );", "	( cond mutex -- )" );
	swigFunction( "c-function SDL_CondWaitTimeout SDL_CondWaitTimeout a a u -- n", "FUNCTION: SDL_CondWaitTimeout ( cond mutex ms -- n )", "EXTERN: \"C\" int SDL_CondWaitTimeout( void * cond, void * mutex, int ms );", "	( cond mutex ms -- )" );
	swigFunction( "c-function SDL_GetPowerInfo SDL_GetPowerInfo a a -- n", "FUNCTION: SDL_GetPowerInfo ( secs pct -- n )", "EXTERN: \"C\" int SDL_GetPowerInfo( void * secs, void * pct );", "	( secs pct -- )" );
	swigFunction( "c-function SDL_GetNumRenderDrivers SDL_GetNumRenderDrivers  -- n", "FUNCTION: SDL_GetNumRenderDrivers (  -- n )", "EXTERN: \"C\" int SDL_GetNumRenderDrivers(  );", "	( -- )" );
	swigFunction( "c-function SDL_GetRenderDriverInfo SDL_GetRenderDriverInfo n a -- n", "FUNCTION: SDL_GetRenderDriverInfo ( index info -- n )", "EXTERN: \"C\" int SDL_GetRenderDriverInfo( int index, void * info );", "	( index info -- )" );
	swigFunction( "c-function SDL_CreateWindowAndRenderer SDL_CreateWindowAndRenderer n n u a a -- n", "FUNCTION: SDL_CreateWindowAndRenderer ( width height window_flags window renderer -- n )", "EXTERN: \"C\" int SDL_CreateWindowAndRenderer( int width, int height, int window_flags, void * window, void * renderer );", "	( width height window_flags window renderer -- )" );
	swigFunction( "c-function SDL_CreateRenderer SDL_CreateRenderer a n u -- a", "FUNCTION: SDL_CreateRenderer ( window index flags -- a )", "EXTERN: \"C\" void * SDL_CreateRenderer( void * window, int index, int flags );", "	( window index flags -- )" );
	swigFunction( "c-function SDL_CreateSoftwareRenderer SDL_CreateSoftwareRenderer a -- a", "FUNCTION: SDL_CreateSoftwareRenderer ( surface -- a )", "EXTERN: \"C\" void * SDL_CreateSoftwareRenderer( void * surface );", "	( surface -- )" );
	swigFunction( "c-function SDL_GetRenderer SDL_GetRenderer a -- a", "FUNCTION: SDL_GetRenderer ( window -- a )", "EXTERN: \"C\" void * SDL_GetRenderer( void * window );", "	( window -- )" );
	swigFunction( "c-function SDL_RenderGetWindow SDL_RenderGetWindow a -- a", "FUNCTION: SDL_RenderGetWindow ( renderer -- a )", "EXTERN: \"C\" void * SDL_RenderGetWindow( void * renderer );", "	( renderer -- )" );
	swigFunction( "c-function SDL_GetRendererInfo SDL_GetRendererInfo a a -- n", "FUNCTION: SDL_GetRendererInfo ( renderer info -- n )", "EXTERN: \"C\" int SDL_GetRendererInfo( void * renderer, void * info );", "	( renderer info -- )" );
	swigFunction( "c-function SDL_GetRendererOutputSize SDL_GetRendererOutputSize a a a -- n", "FUNCTION: SDL_GetRendererOutputSize ( renderer w h -- n )", "EXTERN: \"C\" int SDL_GetRendererOutputSize( void * renderer, void * w, void * h );", "	( renderer w h -- )" );
	swigFunction( "c-function SDL_CreateTexture SDL_CreateTexture a u n n n -- a", "FUNCTION: SDL_CreateTexture ( renderer format access w h -- a )", "EXTERN: \"C\" void * SDL_CreateTexture( void * renderer, int format, int access, int w, int h );", "	( renderer format access w h -- )" );
	swigFunction( "c-function SDL_CreateTextureFromSurface SDL_CreateTextureFromSurface a a -- a", "FUNCTION: SDL_CreateTextureFromSurface ( renderer surface -- a )", "EXTERN: \"C\" void * SDL_CreateTextureFromSurface( void * renderer, void * surface );", "	( renderer surface -- )" );
	swigFunction( "c-function SDL_QueryTexture SDL_QueryTexture a a a a a -- n", "FUNCTION: SDL_QueryTexture ( texture format access w h -- n )", "EXTERN: \"C\" int SDL_QueryTexture( void * texture, void * format, void * access, void * w, void * h );", "	( texture format access w h -- )" );
	swigFunction( "c-function SDL_SetTextureColorMod SDL_SetTextureColorMod a u u u -- n", "FUNCTION: SDL_SetTextureColorMod ( texture r g b -- n )", "EXTERN: \"C\" int SDL_SetTextureColorMod( void * texture, int r, int g, int b );", "	( texture r g b -- )" );
	swigFunction( "c-function SDL_GetTextureColorMod SDL_GetTextureColorMod a a a a -- n", "FUNCTION: SDL_GetTextureColorMod ( texture r g b -- n )", "EXTERN: \"C\" int SDL_GetTextureColorMod( void * texture, void * r, void * g, void * b );", "	( texture r g b -- )" );
	swigFunction( "c-function SDL_SetTextureAlphaMod SDL_SetTextureAlphaMod a u -- n", "FUNCTION: SDL_SetTextureAlphaMod ( texture alpha -- n )", "EXTERN: \"C\" int SDL_SetTextureAlphaMod( void * texture, int alpha );", "	( texture alpha -- )" );
	swigFunction( "c-function SDL_GetTextureAlphaMod SDL_GetTextureAlphaMod a a -- n", "FUNCTION: SDL_GetTextureAlphaMod ( texture alpha -- n )", "EXTERN: \"C\" int SDL_GetTextureAlphaMod( void * texture, void * alpha );", "	( texture alpha -- )" );
	swigFunction( "c-function SDL_SetTextureBlendMode SDL_SetTextureBlendMode a u -- n", "FUNCTION: SDL_SetTextureBlendMode ( texture blendMode -- n )", "EXTERN: \"C\" int SDL_SetTextureBlendMode( void * texture, int blendMode );", "	( texture blendMode -- )" );
	swigFunction( "c-function SDL_GetTextureBlendMode SDL_GetTextureBlendMode a a -- n", "FUNCTION: SDL_GetTextureBlendMode ( texture blendMode -- n )", "EXTERN: \"C\" int SDL_GetTextureBlendMode( void * texture, void * blendMode );", "	( texture blendMode -- )" );
	swigFunction( "c-function SDL_SetTextureScaleMode SDL_SetTextureScaleMode a n -- n", "FUNCTION: SDL_SetTextureScaleMode ( texture scaleMode -- n )", "EXTERN: \"C\" int SDL_SetTextureScaleMode( void * texture, int scaleMode );", "	( texture scaleMode -- )" );
	swigFunction( "c-function SDL_GetTextureScaleMode SDL_GetTextureScaleMode a a -- n", "FUNCTION: SDL_GetTextureScaleMode ( texture scaleMode -- n )", "EXTERN: \"C\" int SDL_GetTextureScaleMode( void * texture, void * scaleMode );", "	( texture scaleMode -- )" );
	swigFunction( "c-function SDL_SetTextureUserData SDL_SetTextureUserData a a -- n", "FUNCTION: SDL_SetTextureUserData ( texture userdata -- n )", "EXTERN: \"C\" int SDL_SetTextureUserData( void * texture, void * userdata );", "	( texture userdata -- )" );
	swigFunction( "c-function SDL_GetTextureUserData SDL_GetTextureUserData a -- a", "FUNCTION: SDL_GetTextureUserData ( texture -- a )", "EXTERN: \"C\" void * SDL_GetTextureUserData( void * texture );", "	( texture -- )" );
	swigFunction( "c-function SDL_UpdateTexture SDL_UpdateTexture a a a n -- n", "FUNCTION: SDL_UpdateTexture ( texture rect pixels pitch -- n )", "EXTERN: \"C\" int SDL_UpdateTexture( void * texture, void * rect, void * pixels, int pitch );", "	( texture rect pixels pitch -- )" );
	swigFunction( "c-function SDL_UpdateYUVTexture SDL_UpdateYUVTexture a a a n a n a n -- n", "FUNCTION: SDL_UpdateYUVTexture ( texture rect Yplane Ypitch Uplane Upitch Vplane Vpitch -- n )", "EXTERN: \"C\" int SDL_UpdateYUVTexture( void * texture, void * rect, void * Yplane, int Ypitch, void * Uplane, int Upitch, void * Vplane, int Vpitch );", "	( texture rect Yplane Ypitch Uplane Upitch Vplane Vpitch -- )" );
	swigFunction( "c-function SDL_UpdateNVTexture SDL_UpdateNVTexture a a a n a n -- n", "FUNCTION: SDL_UpdateNVTexture ( texture rect Yplane Ypitch UVplane UVpitch -- n )", "EXTERN: \"C\" int SDL_UpdateNVTexture( void * texture, void * rect, void * Yplane, int Ypitch, void * UVplane, int UVpitch );", "	( texture rect Yplane Ypitch UVplane UVpitch -- )" );
	swigFunction( "c-function SDL_LockTexture SDL_LockTexture a a a a -- n", "FUNCTION: SDL_LockTexture ( texture rect pixels pitch -- n )", "EXTERN: \"C\" int SDL_LockTexture( void * texture, void * rect, void * pixels, void * pitch );", "	( texture rect pixels pitch -- )" );
	swigFunction( "c-function SDL_LockTextureToSurface SDL_LockTextureToSurface a a a -- n", "FUNCTION: SDL_LockTextureToSurface ( texture rect surface -- n )", "EXTERN: \"C\" int SDL_LockTextureToSurface( void * texture, void * rect, void * surface );", "	( texture rect surface -- )" );
	swigFunction( "c-function SDL_UnlockTexture SDL_UnlockTexture a -- void", "FUNCTION: SDL_UnlockTexture ( texture -- void )", "EXTERN: \"C\" void SDL_UnlockTexture( void * texture );", "	( texture -- )" );
	swigFunction( "c-function SDL_RenderTargetSupported SDL_RenderTargetSupported a -- n", "FUNCTION: SDL_RenderTargetSupported ( renderer -- n )", "EXTERN: \"C\" int SDL_RenderTargetSupported( void * renderer );", "	( renderer -- )" );
	swigFunction( "c-function SDL_SetRenderTarget SDL_SetRenderTarget a a -- n", "FUNCTION: SDL_SetRenderTarget ( renderer texture -- n )", "EXTERN: \"C\" int SDL_SetRenderTarget( void * renderer, void * texture );", "	( renderer texture -- )" );
	swigFunction( "c-function SDL_GetRenderTarget SDL_GetRenderTarget a -- a", "FUNCTION: SDL_GetRenderTarget ( renderer -- a )", "EXTERN: \"C\" void * SDL_GetRenderTarget( void * renderer );", "	( renderer -- )" );
	swigFunction( "c-function SDL_RenderSetLogicalSize SDL_RenderSetLogicalSize a n n -- n", "FUNCTION: SDL_RenderSetLogicalSize ( renderer w h -- n )", "EXTERN: \"C\" int SDL_RenderSetLogicalSize( void * renderer, int w, int h );", "	( renderer w h -- )" );
	swigFunction( "c-function SDL_RenderGetLogicalSize SDL_RenderGetLogicalSize a a a -- void", "FUNCTION: SDL_RenderGetLogicalSize ( renderer w h -- void )", "EXTERN: \"C\" void SDL_RenderGetLogicalSize( void * renderer, void * w, void * h );", "	( renderer w h -- )" );
	swigFunction( "c-function SDL_RenderSetIntegerScale SDL_RenderSetIntegerScale a n -- n", "FUNCTION: SDL_RenderSetIntegerScale ( renderer enable -- n )", "EXTERN: \"C\" int SDL_RenderSetIntegerScale( void * renderer, int enable );", "	( renderer enable -- )" );
	swigFunction( "c-function SDL_RenderGetIntegerScale SDL_RenderGetIntegerScale a -- n", "FUNCTION: SDL_RenderGetIntegerScale ( renderer -- n )", "EXTERN: \"C\" int SDL_RenderGetIntegerScale( void * renderer );", "	( renderer -- )" );
	swigFunction( "c-function SDL_RenderSetViewport SDL_RenderSetViewport a a -- n", "FUNCTION: SDL_RenderSetViewport ( renderer rect -- n )", "EXTERN: \"C\" int SDL_RenderSetViewport( void * renderer, void * rect );", "	( renderer rect -- )" );
	swigFunction( "c-function SDL_RenderGetViewport SDL_RenderGetViewport a a -- void", "FUNCTION: SDL_RenderGetViewport ( renderer rect -- void )", "EXTERN: \"C\" void SDL_RenderGetViewport( void * renderer, void * rect );", "	( renderer rect -- )" );
	swigFunction( "c-function SDL_RenderSetClipRect SDL_RenderSetClipRect a a -- n", "FUNCTION: SDL_RenderSetClipRect ( renderer rect -- n )", "EXTERN: \"C\" int SDL_RenderSetClipRect( void * renderer, void * rect );", "	( renderer rect -- )" );
	swigFunction( "c-function SDL_RenderGetClipRect SDL_RenderGetClipRect a a -- void", "FUNCTION: SDL_RenderGetClipRect ( renderer rect -- void )", "EXTERN: \"C\" void SDL_RenderGetClipRect( void * renderer, void * rect );", "	( renderer rect -- )" );
	swigFunction( "c-function SDL_RenderIsClipEnabled SDL_RenderIsClipEnabled a -- n", "FUNCTION: SDL_RenderIsClipEnabled ( renderer -- n )", "EXTERN: \"C\" int SDL_RenderIsClipEnabled( void * renderer );", "	( renderer -- )" );
	swigFunction( "c-function SDL_RenderSetScale SDL_RenderSetScale a r r -- n", "FUNCTION: SDL_RenderSetScale ( renderer scaleX scaleY -- n )", "EXTERN: \"C\" int SDL_RenderSetScale( void * renderer, float scaleX, float scaleY );", "	( renderer scaleX scaleY -- )" );
	swigFunction( "c-function SDL_RenderGetScale SDL_RenderGetScale a a a -- void", "FUNCTION: SDL_RenderGetScale ( renderer scaleX scaleY -- void )", "EXTERN: \"C\" void SDL_RenderGetScale( void * renderer, void * scaleX, void * scaleY );", "	( renderer scaleX scaleY -- )" );
	swigFunction( "c-function SDL_RenderWindowToLogical SDL_RenderWindowToLogical a n n a a -- void", "FUNCTION: SDL_RenderWindowToLogical ( renderer windowX windowY logicalX logicalY -- void )", "EXTERN: \"C\" void SDL_RenderWindowToLogical( void * renderer, int windowX, int windowY, void * logicalX, void * logicalY );", "	( renderer windowX windowY logicalX logicalY -- )" );
	swigFunction( "c-function SDL_RenderLogicalToWindow SDL_RenderLogicalToWindow a r r a a -- void", "FUNCTION: SDL_RenderLogicalToWindow ( renderer logicalX logicalY windowX windowY -- void )", "EXTERN: \"C\" void SDL_RenderLogicalToWindow( void * renderer, float logicalX, float logicalY, void * windowX, void * windowY );", "	( renderer logicalX logicalY windowX windowY -- )" );
	swigFunction( "c-function SDL_SetRenderDrawColor SDL_SetRenderDrawColor a u u u u -- n", "FUNCTION: SDL_SetRenderDrawColor ( renderer r g b a -- n )", "EXTERN: \"C\" int SDL_SetRenderDrawColor( void * renderer, int r, int g, int b, int a );", "	( renderer r g b a -- )" );
	swigFunction( "c-function SDL_GetRenderDrawColor SDL_GetRenderDrawColor a a a a a -- n", "FUNCTION: SDL_GetRenderDrawColor ( renderer r g b a -- n )", "EXTERN: \"C\" int SDL_GetRenderDrawColor( void * renderer, void * r, void * g, void * b, void * a );", "	( renderer r g b a -- )" );
	swigFunction( "c-function SDL_SetRenderDrawBlendMode SDL_SetRenderDrawBlendMode a u -- n", "FUNCTION: SDL_SetRenderDrawBlendMode ( renderer blendMode -- n )", "EXTERN: \"C\" int SDL_SetRenderDrawBlendMode( void * renderer, int blendMode );", "	( renderer blendMode -- )" );
	swigFunction( "c-function SDL_GetRenderDrawBlendMode SDL_GetRenderDrawBlendMode a a -- n", "FUNCTION: SDL_GetRenderDrawBlendMode ( renderer blendMode -- n )", "EXTERN: \"C\" int SDL_GetRenderDrawBlendMode( void * renderer, void * blendMode );", "	( renderer blendMode -- )" );
	swigFunction( "c-function SDL_RenderClear SDL_RenderClear a -- n", "FUNCTION: SDL_RenderClear ( renderer -- n )", "EXTERN: \"C\" int SDL_RenderClear( void * renderer );", "	( renderer -- )" );
	swigFunction( "c-function SDL_RenderDrawPoint SDL_RenderDrawPoint a n n -- n", "FUNCTION: SDL_RenderDrawPoint ( renderer x y -- n )", "EXTERN: \"C\" int SDL_RenderDrawPoint( void * renderer, int x, int y );", "	( renderer x y -- )" );
	swigFunction( "c-function SDL_RenderDrawPoints SDL_RenderDrawPoints a a n -- n", "FUNCTION: SDL_RenderDrawPoints ( renderer points count -- n )", "EXTERN: \"C\" int SDL_RenderDrawPoints( void * renderer, void * points, int count );", "	( renderer points count -- )" );
	swigFunction( "c-function SDL_RenderDrawLine SDL_RenderDrawLine a n n n n -- n", "FUNCTION: SDL_RenderDrawLine ( renderer x1 y1 x2 y2 -- n )", "EXTERN: \"C\" int SDL_RenderDrawLine( void * renderer, int x1, int y1, int x2, int y2 );", "	( renderer x1 y1 x2 y2 -- )" );
	swigFunction( "c-function SDL_RenderDrawLines SDL_RenderDrawLines a a n -- n", "FUNCTION: SDL_RenderDrawLines ( renderer points count -- n )", "EXTERN: \"C\" int SDL_RenderDrawLines( void * renderer, void * points, int count );", "	( renderer points count -- )" );
	swigFunction( "c-function SDL_RenderDrawRect SDL_RenderDrawRect a a -- n", "FUNCTION: SDL_RenderDrawRect ( renderer rect -- n )", "EXTERN: \"C\" int SDL_RenderDrawRect( void * renderer, void * rect );", "	( renderer rect -- )" );
	swigFunction( "c-function SDL_RenderDrawRects SDL_RenderDrawRects a a n -- n", "FUNCTION: SDL_RenderDrawRects ( renderer rects count -- n )", "EXTERN: \"C\" int SDL_RenderDrawRects( void * renderer, void * rects, int count );", "	( renderer rects count -- )" );
	swigFunction( "c-function SDL_RenderFillRect SDL_RenderFillRect a a -- n", "FUNCTION: SDL_RenderFillRect ( renderer rect -- n )", "EXTERN: \"C\" int SDL_RenderFillRect( void * renderer, void * rect );", "	( renderer rect -- )" );
	swigFunction( "c-function SDL_RenderFillRects SDL_RenderFillRects a a n -- n", "FUNCTION: SDL_RenderFillRects ( renderer rects count -- n )", "EXTERN: \"C\" int SDL_RenderFillRects( void * renderer, void * rects, int count );", "	( renderer rects count -- )" );
	swigFunction( "c-function SDL_RenderCopy SDL_RenderCopy a a a a -- n", "FUNCTION: SDL_RenderCopy ( renderer texture srcrect dstrect -- n )", "EXTERN: \"C\" int SDL_RenderCopy( void * renderer, void * texture, void * srcrect, void * dstrect );", "	( renderer texture srcrect dstrect -- )" );
	swigFunction( "c-function SDL_RenderCopyEx SDL_RenderCopyEx a a a a r a n -- n", "FUNCTION: SDL_RenderCopyEx ( renderer texture srcrect dstrect angle center flip -- n )", "EXTERN: \"C\" int SDL_RenderCopyEx( void * renderer, void * texture, void * srcrect, void * dstrect, double angle, void * center, int flip );", "	( renderer texture srcrect dstrect angle center flip -- )" );
	swigFunction( "c-function SDL_RenderDrawPointF SDL_RenderDrawPointF a r r -- n", "FUNCTION: SDL_RenderDrawPointF ( renderer x y -- n )", "EXTERN: \"C\" int SDL_RenderDrawPointF( void * renderer, float x, float y );", "	( renderer x y -- )" );
	swigFunction( "c-function SDL_RenderDrawPointsF SDL_RenderDrawPointsF a a n -- n", "FUNCTION: SDL_RenderDrawPointsF ( renderer points count -- n )", "EXTERN: \"C\" int SDL_RenderDrawPointsF( void * renderer, void * points, int count );", "	( renderer points count -- )" );
	swigFunction( "c-function SDL_RenderDrawLineF SDL_RenderDrawLineF a r r r r -- n", "FUNCTION: SDL_RenderDrawLineF ( renderer x1 y1 x2 y2 -- n )", "EXTERN: \"C\" int SDL_RenderDrawLineF( void * renderer, float x1, float y1, float x2, float y2 );", "	( renderer x1 y1 x2 y2 -- )" );
	swigFunction( "c-function SDL_RenderDrawLinesF SDL_RenderDrawLinesF a a n -- n", "FUNCTION: SDL_RenderDrawLinesF ( renderer points count -- n )", "EXTERN: \"C\" int SDL_RenderDrawLinesF( void * renderer, void * points, int count );", "	( renderer points count -- )" );
	swigFunction( "c-function SDL_RenderDrawRectF SDL_RenderDrawRectF a a -- n", "FUNCTION: SDL_RenderDrawRectF ( renderer rect -- n )", "EXTERN: \"C\" int SDL_RenderDrawRectF( void * renderer, void * rect );", "	( renderer rect -- )" );
	swigFunction( "c-function SDL_RenderDrawRectsF SDL_RenderDrawRectsF a a n -- n", "FUNCTION: SDL_RenderDrawRectsF ( renderer rects count -- n )", "EXTERN: \"C\" int SDL_RenderDrawRectsF( void * renderer, void * rects, int count );", "	( renderer rects count -- )" );
	swigFunction( "c-function SDL_RenderFillRectF SDL_RenderFillRectF a a -- n", "FUNCTION: SDL_RenderFillRectF ( renderer rect -- n )", "EXTERN: \"C\" int SDL_RenderFillRectF( void * renderer, void * rect );", "	( renderer rect -- )" );
	swigFunction( "c-function SDL_RenderFillRectsF SDL_RenderFillRectsF a a n -- n", "FUNCTION: SDL_RenderFillRectsF ( renderer rects count -- n )", "EXTERN: \"C\" int SDL_RenderFillRectsF( void * renderer, void * rects, int count );", "	( renderer rects count -- )" );
	swigFunction( "c-function SDL_RenderCopyF SDL_RenderCopyF a a a a -- n", "FUNCTION: SDL_RenderCopyF ( renderer texture srcrect dstrect -- n )", "EXTERN: \"C\" int SDL_RenderCopyF( void * renderer, void * texture, void * srcrect, void * dstrect );", "	( renderer texture srcrect dstrect -- )" );
	swigFunction( "c-function SDL_RenderCopyExF SDL_RenderCopyExF a a a a r a n -- n", "FUNCTION: SDL_RenderCopyExF ( renderer texture srcrect dstrect angle center flip -- n )", "EXTERN: \"C\" int SDL_RenderCopyExF( void * renderer, void * texture, void * srcrect, void * dstrect, double angle, void * center, int flip );", "	( renderer texture srcrect dstrect angle center flip -- )" );
	swigFunction( "c-function SDL_RenderGeometry SDL_RenderGeometry a a a n a n -- n", "FUNCTION: SDL_RenderGeometry ( renderer texture vertices num_vertices indices num_indices -- n )", "EXTERN: \"C\" int SDL_RenderGeometry( void * renderer, void * texture, void * vertices, int num_vertices, void * indices, int num_indices );", "	( renderer texture vertices num_vertices indices num_indices -- )" );
	swigFunction( "c-function SDL_RenderGeometryRaw SDL_RenderGeometryRaw a a a n a n a n n a n n -- n", "FUNCTION: SDL_RenderGeometryRaw ( renderer texture xy xy_stride color color_stride uv uv_stride num_vertices indices num_indices size_indices -- n )", "EXTERN: \"C\" int SDL_RenderGeometryRaw( void * renderer, void * texture, void * xy, int xy_stride, void * color, int color_stride, void * uv, int uv_stride, int num_vertices, void * indices, int num_indices, int size_indices );", "	( renderer texture xy xy_stride color color_stride uv uv_stride num_vertices indices num_indices size_indices -- )" );
	swigFunction( "c-function SDL_RenderReadPixels SDL_RenderReadPixels a a u a n -- n", "FUNCTION: SDL_RenderReadPixels ( renderer rect format pixels pitch -- n )", "EXTERN: \"C\" int SDL_RenderReadPixels( void * renderer, void * rect, int format, void * pixels, int pitch );", "	( renderer rect format pixels pitch -- )" );
	swigFunction( "c-function SDL_RenderPresent SDL_RenderPresent a -- void", "FUNCTION: SDL_RenderPresent ( renderer -- void )", "EXTERN: \"C\" void SDL_RenderPresent( void * renderer );", "	( renderer -- )" );
	swigFunction( "c-function SDL_DestroyTexture SDL_DestroyTexture a -- void", "FUNCTION: SDL_DestroyTexture ( texture -- void )", "EXTERN: \"C\" void SDL_DestroyTexture( void * texture );", "	( texture -- )" );
	swigFunction( "c-function SDL_DestroyRenderer SDL_DestroyRenderer a -- void", "FUNCTION: SDL_DestroyRenderer ( renderer -- void )", "EXTERN: \"C\" void SDL_DestroyRenderer( void * renderer );", "	( renderer -- )" );
	swigFunction( "c-function SDL_RenderFlush SDL_RenderFlush a -- n", "FUNCTION: SDL_RenderFlush ( renderer -- n )", "EXTERN: \"C\" int SDL_RenderFlush( void * renderer );", "	( renderer -- )" );
	swigFunction( "c-function SDL_GL_BindTexture SDL_GL_BindTexture a a a -- n", "FUNCTION: SDL_GL_BindTexture ( texture texw texh -- n )", "EXTERN: \"C\" int SDL_GL_BindTexture( void * texture, void * texw, void * texh );", "	( texture texw texh -- )" );
	swigFunction( "c-function SDL_GL_UnbindTexture SDL_GL_UnbindTexture a -- n", "FUNCTION: SDL_GL_UnbindTexture ( texture -- n )", "EXTERN: \"C\" int SDL_GL_UnbindTexture( void * texture );", "	( texture -- )" );
	swigFunction( "c-function SDL_RenderGetMetalLayer SDL_RenderGetMetalLayer a -- a", "FUNCTION: SDL_RenderGetMetalLayer ( renderer -- a )", "EXTERN: \"C\" void * SDL_RenderGetMetalLayer( void * renderer );", "	( renderer -- )" );
	swigFunction( "c-function SDL_RenderGetMetalCommandEncoder SDL_RenderGetMetalCommandEncoder a -- a", "FUNCTION: SDL_RenderGetMetalCommandEncoder ( renderer -- a )", "EXTERN: \"C\" void * SDL_RenderGetMetalCommandEncoder( void * renderer );", "	( renderer -- )" );
	swigFunction( "c-function SDL_RenderSetVSync SDL_RenderSetVSync a n -- n", "FUNCTION: SDL_RenderSetVSync ( renderer vsync -- n )", "EXTERN: \"C\" int SDL_RenderSetVSync( void * renderer, int vsync );", "	( renderer vsync -- )" );
	swigFunction( "c-function SDL_RWFromFile SDL_RWFromFile s s -- a", "FUNCTION: SDL_RWFromFile ( file mode -- a )", "EXTERN: \"C\" void * SDL_RWFromFile( char * file, char * mode );", "	( file mode -- )" );
	swigFunction( "c-function SDL_RWFromFP SDL_RWFromFP a n -- a", "FUNCTION: SDL_RWFromFP ( fp autoclose -- a )", "EXTERN: \"C\" void * SDL_RWFromFP( void * fp, int autoclose );", "	( fp autoclose -- )" );
	swigFunction( "c-function SDL_RWFromMem SDL_RWFromMem a n -- a", "FUNCTION: SDL_RWFromMem ( mem size -- a )", "EXTERN: \"C\" void * SDL_RWFromMem( void * mem, int size );", "	( mem size -- )" );
	swigFunction( "c-function SDL_RWFromConstMem SDL_RWFromConstMem a n -- a", "FUNCTION: SDL_RWFromConstMem ( mem size -- a )", "EXTERN: \"C\" void * SDL_RWFromConstMem( void * mem, int size );", "	( mem size -- )" );
	swigFunction( "c-function SDL_AllocRW SDL_AllocRW  -- a", "FUNCTION: SDL_AllocRW (  -- a )", "EXTERN: \"C\" void * SDL_AllocRW(  );", "	( -- )" );
	swigFunction( "c-function SDL_FreeRW SDL_FreeRW a -- void", "FUNCTION: SDL_FreeRW ( area -- void )", "EXTERN: \"C\" void SDL_FreeRW( void * area );", "	( area -- )" );
	swigFunction( "c-function SDL_RWsize SDL_RWsize a -- d", "FUNCTION: SDL_RWsize ( context -- d )", "EXTERN: \"C\" long long SDL_RWsize( void * context );", "	( context -- )" );
	swigFunction( "c-function SDL_RWseek SDL_RWseek a d n -- d", "FUNCTION: SDL_RWseek ( context offset whence -- d )", "EXTERN: \"C\" long long SDL_RWseek( void * context, long long offset, int whence );", "	( context offset whence -- )" );
	swigFunction( "c-function SDL_RWtell SDL_RWtell a -- d", "FUNCTION: SDL_RWtell ( context -- d )", "EXTERN: \"C\" long long SDL_RWtell( void * context );", "	( context -- )" );
	swigFunction( "c-function SDL_RWread SDL_RWread a a u u -- u", "FUNCTION: SDL_RWread ( context ptr size maxnum -- u )", "EXTERN: \"C\" int SDL_RWread( void * context, void * ptr, int size, int maxnum );", "	( context ptr size maxnum -- )" );
	swigFunction( "c-function SDL_RWwrite SDL_RWwrite a a u u -- u", "FUNCTION: SDL_RWwrite ( context ptr size num -- u )", "EXTERN: \"C\" int SDL_RWwrite( void * context, void * ptr, int size, int num );", "	( context ptr size num -- )" );
	swigFunction( "c-function SDL_RWclose SDL_RWclose a -- n", "FUNCTION: SDL_RWclose ( context -- n )", "EXTERN: \"C\" int SDL_RWclose( void * context );", "	( context -- )" );
	swigFunction( "c-function SDL_LoadFile_RW SDL_LoadFile_RW a a n -- a", "FUNCTION: SDL_LoadFile_RW ( src datasize freesrc -- a )", "EXTERN: \"C\" void * SDL_LoadFile_RW( void * src, void * datasize, int freesrc );", "	( src datasize freesrc -- )" );
	swigFunction( "c-function SDL_LoadFile SDL_LoadFile s a -- a", "FUNCTION: SDL_LoadFile ( file datasize -- a )", "EXTERN: \"C\" void * SDL_LoadFile( char * file, void * datasize );", "	( file datasize -- )" );
	swigFunction( "c-function SDL_ReadU8 SDL_ReadU8 a -- u", "FUNCTION: SDL_ReadU8 ( src -- u )", "EXTERN: \"C\" int SDL_ReadU8( void * src );", "	( src -- )" );
	swigFunction( "c-function SDL_ReadLE16 SDL_ReadLE16 a -- u", "FUNCTION: SDL_ReadLE16 ( src -- u )", "EXTERN: \"C\" int SDL_ReadLE16( void * src );", "	( src -- )" );
	swigFunction( "c-function SDL_ReadBE16 SDL_ReadBE16 a -- u", "FUNCTION: SDL_ReadBE16 ( src -- u )", "EXTERN: \"C\" int SDL_ReadBE16( void * src );", "	( src -- )" );
	swigFunction( "c-function SDL_ReadLE32 SDL_ReadLE32 a -- u", "FUNCTION: SDL_ReadLE32 ( src -- u )", "EXTERN: \"C\" int SDL_ReadLE32( void * src );", "	( src -- )" );
	swigFunction( "c-function SDL_ReadBE32 SDL_ReadBE32 a -- u", "FUNCTION: SDL_ReadBE32 ( src -- u )", "EXTERN: \"C\" int SDL_ReadBE32( void * src );", "	( src -- )" );
	swigFunction( "c-function SDL_ReadLE64 SDL_ReadLE64 a -- ud", "FUNCTION: SDL_ReadLE64 ( src -- ud )", "EXTERN: \"C\" long long SDL_ReadLE64( void * src );", "	( src -- )" );
	swigFunction( "c-function SDL_ReadBE64 SDL_ReadBE64 a -- ud", "FUNCTION: SDL_ReadBE64 ( src -- ud )", "EXTERN: \"C\" long long SDL_ReadBE64( void * src );", "	( src -- )" );
	swigFunction( "c-function SDL_WriteU8 SDL_WriteU8 a u -- u", "FUNCTION: SDL_WriteU8 ( dst value -- u )", "EXTERN: \"C\" int SDL_WriteU8( void * dst, int value );", "	( dst value -- )" );
	swigFunction( "c-function SDL_WriteLE16 SDL_WriteLE16 a u -- u", "FUNCTION: SDL_WriteLE16 ( dst value -- u )", "EXTERN: \"C\" int SDL_WriteLE16( void * dst, int value );", "	( dst value -- )" );
	swigFunction( "c-function SDL_WriteBE16 SDL_WriteBE16 a u -- u", "FUNCTION: SDL_WriteBE16 ( dst value -- u )", "EXTERN: \"C\" int SDL_WriteBE16( void * dst, int value );", "	( dst value -- )" );
	swigFunction( "c-function SDL_WriteLE32 SDL_WriteLE32 a u -- u", "FUNCTION: SDL_WriteLE32 ( dst value -- u )", "EXTERN: \"C\" int SDL_WriteLE32( void * dst, int value );", "	( dst value -- )" );
	swigFunction( "c-function SDL_WriteBE32 SDL_WriteBE32 a u -- u", "FUNCTION: SDL_WriteBE32 ( dst value -- u )", "EXTERN: \"C\" int SDL_WriteBE32( void * dst, int value );", "	( dst value -- )" );
	swigFunction( "c-function SDL_WriteLE64 SDL_WriteLE64 a ud -- u", "FUNCTION: SDL_WriteLE64 ( dst value -- u )", "EXTERN: \"C\" int SDL_WriteLE64( void * dst, long long value );", "	( dst value -- )" );
	swigFunction( "c-function SDL_WriteBE64 SDL_WriteBE64 a ud -- u", "FUNCTION: SDL_WriteBE64 ( dst value -- u )", "EXTERN: \"C\" int SDL_WriteBE64( void * dst, long long value );", "	( dst value -- )" );
	swigFunction( "c-function SDL_LockSensors SDL_LockSensors  -- void", "FUNCTION: SDL_LockSensors (  -- void )", "EXTERN: \"C\" void SDL_LockSensors(  );", "	( -- )" );
	swigFunction( "c-function SDL_UnlockSensors SDL_UnlockSensors  -- void", "FUNCTION: SDL_UnlockSensors (  -- void )", "EXTERN: \"C\" void SDL_UnlockSensors(  );", "	( -- )" );
	swigFunction( "c-function SDL_NumSensors SDL_NumSensors  -- n", "FUNCTION: SDL_NumSensors (  -- n )", "EXTERN: \"C\" int SDL_NumSensors(  );", "	( -- )" );
	swigFunction( "c-function SDL_SensorGetDeviceName SDL_SensorGetDeviceName n -- s", "FUNCTION: SDL_SensorGetDeviceName ( device_index -- s )", "EXTERN: \"C\" char * SDL_SensorGetDeviceName( int device_index );", "	( device_index -- )" );
	swigFunction( "c-function SDL_SensorGetDeviceType SDL_SensorGetDeviceType n -- n", "FUNCTION: SDL_SensorGetDeviceType ( device_index -- n )", "EXTERN: \"C\" int SDL_SensorGetDeviceType( int device_index );", "	( device_index -- )" );
	swigFunction( "c-function SDL_SensorGetDeviceNonPortableType SDL_SensorGetDeviceNonPortableType n -- n", "FUNCTION: SDL_SensorGetDeviceNonPortableType ( device_index -- n )", "EXTERN: \"C\" int SDL_SensorGetDeviceNonPortableType( int device_index );", "	( device_index -- )" );
	swigFunction( "c-function SDL_SensorGetDeviceInstanceID SDL_SensorGetDeviceInstanceID n -- n", "FUNCTION: SDL_SensorGetDeviceInstanceID ( device_index -- n )", "EXTERN: \"C\" int SDL_SensorGetDeviceInstanceID( int device_index );", "	( device_index -- )" );
	swigFunction( "c-function SDL_SensorOpen SDL_SensorOpen n -- a", "FUNCTION: SDL_SensorOpen ( device_index -- a )", "EXTERN: \"C\" void * SDL_SensorOpen( int device_index );", "	( device_index -- )" );
	swigFunction( "c-function SDL_SensorFromInstanceID SDL_SensorFromInstanceID n -- a", "FUNCTION: SDL_SensorFromInstanceID ( instance_id -- a )", "EXTERN: \"C\" void * SDL_SensorFromInstanceID( int instance_id );", "	( instance_id -- )" );
	swigFunction( "c-function SDL_SensorGetName SDL_SensorGetName a -- s", "FUNCTION: SDL_SensorGetName ( sensor -- s )", "EXTERN: \"C\" char * SDL_SensorGetName( void * sensor );", "	( sensor -- )" );
	swigFunction( "c-function SDL_SensorGetType SDL_SensorGetType a -- n", "FUNCTION: SDL_SensorGetType ( sensor -- n )", "EXTERN: \"C\" int SDL_SensorGetType( void * sensor );", "	( sensor -- )" );
	swigFunction( "c-function SDL_SensorGetNonPortableType SDL_SensorGetNonPortableType a -- n", "FUNCTION: SDL_SensorGetNonPortableType ( sensor -- n )", "EXTERN: \"C\" int SDL_SensorGetNonPortableType( void * sensor );", "	( sensor -- )" );
	swigFunction( "c-function SDL_SensorGetInstanceID SDL_SensorGetInstanceID a -- n", "FUNCTION: SDL_SensorGetInstanceID ( sensor -- n )", "EXTERN: \"C\" int SDL_SensorGetInstanceID( void * sensor );", "	( sensor -- )" );
	swigFunction( "c-function SDL_SensorGetData SDL_SensorGetData a a n -- n", "FUNCTION: SDL_SensorGetData ( sensor data num_values -- n )", "EXTERN: \"C\" int SDL_SensorGetData( void * sensor, void * data, int num_values );", "	( sensor data num_values -- )" );
	swigFunction( "c-function SDL_SensorClose SDL_SensorClose a -- void", "FUNCTION: SDL_SensorClose ( sensor -- void )", "EXTERN: \"C\" void SDL_SensorClose( void * sensor );", "	( sensor -- )" );
	swigFunction( "c-function SDL_SensorUpdate SDL_SensorUpdate  -- void", "FUNCTION: SDL_SensorUpdate (  -- void )", "EXTERN: \"C\" void SDL_SensorUpdate(  );", "	( -- )" );
	swigFunction( "c-function SDL_CreateShapedWindow SDL_CreateShapedWindow s u u u u u -- a", "FUNCTION: SDL_CreateShapedWindow ( title x y w h flags -- a )", "EXTERN: \"C\" void * SDL_CreateShapedWindow( char * title, int x, int y, int w, int h, int flags );", "	( title x y w h flags -- )" );
	swigFunction( "c-function SDL_IsShapedWindow SDL_IsShapedWindow a -- n", "FUNCTION: SDL_IsShapedWindow ( window -- n )", "EXTERN: \"C\" int SDL_IsShapedWindow( void * window );", "	( window -- )" );
	swigFunction( "c-function SDL_SetWindowShape SDL_SetWindowShape a a a -- n", "FUNCTION: SDL_SetWindowShape ( window shape shape_mode -- n )", "EXTERN: \"C\" int SDL_SetWindowShape( void * window, void * shape, void * shape_mode );", "	( window shape shape_mode -- )" );
	swigFunction( "c-function SDL_GetShapedWindowMode SDL_GetShapedWindowMode a a -- n", "FUNCTION: SDL_GetShapedWindowMode ( window shape_mode -- n )", "EXTERN: \"C\" int SDL_GetShapedWindowMode( void * window, void * shape_mode );", "	( window shape_mode -- )" );
	swigFunction( "c-function SDL_IsTablet SDL_IsTablet  -- n", "FUNCTION: SDL_IsTablet (  -- n )", "EXTERN: \"C\" int SDL_IsTablet(  );", "	( -- )" );
	swigFunction( "c-function SDL_OnApplicationWillTerminate SDL_OnApplicationWillTerminate  -- void", "FUNCTION: SDL_OnApplicationWillTerminate (  -- void )", "EXTERN: \"C\" void SDL_OnApplicationWillTerminate(  );", "	( -- )" );
	swigFunction( "c-function SDL_OnApplicationDidReceiveMemoryWarning SDL_OnApplicationDidReceiveMemoryWarning  -- void", "FUNCTION: SDL_OnApplicationDidReceiveMemoryWarning (  -- void )", "EXTERN: \"C\" void SDL_OnApplicationDidReceiveMemoryWarning(  );", "	( -- )" );
	swigFunction( "c-function SDL_OnApplicationWillResignActive SDL_OnApplicationWillResignActive  -- void", "FUNCTION: SDL_OnApplicationWillResignActive (  -- void )", "EXTERN: \"C\" void SDL_OnApplicationWillResignActive(  );", "	( -- )" );
	swigFunction( "c-function SDL_OnApplicationDidEnterBackground SDL_OnApplicationDidEnterBackground  -- void", "FUNCTION: SDL_OnApplicationDidEnterBackground (  -- void )", "EXTERN: \"C\" void SDL_OnApplicationDidEnterBackground(  );", "	( -- )" );
	swigFunction( "c-function SDL_OnApplicationWillEnterForeground SDL_OnApplicationWillEnterForeground  -- void", "FUNCTION: SDL_OnApplicationWillEnterForeground (  -- void )", "EXTERN: \"C\" void SDL_OnApplicationWillEnterForeground(  );", "	( -- )" );
	swigFunction( "c-function SDL_OnApplicationDidBecomeActive SDL_OnApplicationDidBecomeActive  -- void", "FUNCTION: SDL_OnApplicationDidBecomeActive (  -- void )", "EXTERN: \"C\" void SDL_OnApplicationDidBecomeActive(  );", "	( -- )" );
	swigFunction( "c-function SDL_CreateThread SDL_CreateThread a s a -- a", "FUNCTION: SDL_CreateThread ( fn name data -- a )", "EXTERN: \"C\" void * SDL_CreateThread( void * fn, char * name, void * data );", "	( fn name data -- )" );
	swigFunction( "c-function SDL_CreateThreadWithStackSize SDL_CreateThreadWithStackSize a s u a -- a", "FUNCTION: SDL_CreateThreadWithStackSize ( fn name stacksize data -- a )", "EXTERN: \"C\" void * SDL_CreateThreadWithStackSize( void * fn, char * name, int stacksize, void * data );", "	( fn name stacksize data -- )" );
	swigFunction( "c-function SDL_GetThreadName SDL_GetThreadName a -- s", "FUNCTION: SDL_GetThreadName ( thread -- s )", "EXTERN: \"C\" char * SDL_GetThreadName( void * thread );", "	( thread -- )" );
	swigFunction( "c-function SDL_ThreadID SDL_ThreadID  -- u", "FUNCTION: SDL_ThreadID (  -- u )", "EXTERN: \"C\" long SDL_ThreadID(  );", "	( -- )" );
	swigFunction( "c-function SDL_GetThreadID SDL_GetThreadID a -- u", "FUNCTION: SDL_GetThreadID ( thread -- u )", "EXTERN: \"C\" long SDL_GetThreadID( void * thread );", "	( thread -- )" );
	swigFunction( "c-function SDL_SetThreadPriority SDL_SetThreadPriority n -- n", "FUNCTION: SDL_SetThreadPriority ( priority -- n )", "EXTERN: \"C\" int SDL_SetThreadPriority( int priority );", "	( priority -- )" );
	swigFunction( "c-function SDL_WaitThread SDL_WaitThread a a -- void", "FUNCTION: SDL_WaitThread ( thread status -- void )", "EXTERN: \"C\" void SDL_WaitThread( void * thread, void * status );", "	( thread status -- )" );
	swigFunction( "c-function SDL_DetachThread SDL_DetachThread a -- void", "FUNCTION: SDL_DetachThread ( thread -- void )", "EXTERN: \"C\" void SDL_DetachThread( void * thread );", "	( thread -- )" );
	swigFunction( "c-function SDL_TLSCreate SDL_TLSCreate  -- u", "FUNCTION: SDL_TLSCreate (  -- u )", "EXTERN: \"C\" int SDL_TLSCreate(  );", "	( -- )" );
	swigFunction( "c-function SDL_TLSGet SDL_TLSGet u -- a", "FUNCTION: SDL_TLSGet ( id -- a )", "EXTERN: \"C\" void * SDL_TLSGet( int id );", "	( id -- )" );
	swigFunction( "c-function SDL_TLSSet SDL_TLSSet u a a -- n", "FUNCTION: SDL_TLSSet ( id value destructor -- n )", "EXTERN: \"C\" int SDL_TLSSet( int id, void * value, void * destructor );", "	( id value destructor -- )" );
	swigFunction( "c-function SDL_TLSCleanup SDL_TLSCleanup  -- void", "FUNCTION: SDL_TLSCleanup (  -- void )", "EXTERN: \"C\" void SDL_TLSCleanup(  );", "	( -- )" );
	swigFunction( "c-function SDL_GetTicks SDL_GetTicks  -- u", "FUNCTION: SDL_GetTicks (  -- u )", "EXTERN: \"C\" int SDL_GetTicks(  );", "	( -- )" );
	swigFunction( "c-function SDL_GetTicks64 SDL_GetTicks64  -- ud", "FUNCTION: SDL_GetTicks64 (  -- ud )", "EXTERN: \"C\" long long SDL_GetTicks64(  );", "	( -- )" );
	swigFunction( "c-function SDL_GetPerformanceCounter SDL_GetPerformanceCounter  -- ud", "FUNCTION: SDL_GetPerformanceCounter (  -- ud )", "EXTERN: \"C\" long long SDL_GetPerformanceCounter(  );", "	( -- )" );
	swigFunction( "c-function SDL_GetPerformanceFrequency SDL_GetPerformanceFrequency  -- ud", "FUNCTION: SDL_GetPerformanceFrequency (  -- ud )", "EXTERN: \"C\" long long SDL_GetPerformanceFrequency(  );", "	( -- )" );
	swigFunction( "c-function SDL_Delay SDL_Delay u -- void", "FUNCTION: SDL_Delay ( ms -- void )", "EXTERN: \"C\" void SDL_Delay( int ms );", "	( ms -- )" );
	swigFunction( "c-function SDL_AddTimer SDL_AddTimer u a a -- n", "FUNCTION: SDL_AddTimer ( interval callback param -- n )", "EXTERN: \"C\" int SDL_AddTimer( int interval, void * callback, void * param );", "	( interval callback param -- )" );
	swigFunction( "c-function SDL_RemoveTimer SDL_RemoveTimer n -- n", "FUNCTION: SDL_RemoveTimer ( id -- n )", "EXTERN: \"C\" int SDL_RemoveTimer( int id );", "	( id -- )" );
	swigFunction( "c-function SDL_GetVersion SDL_GetVersion a -- void", "FUNCTION: SDL_GetVersion ( ver -- void )", "EXTERN: \"C\" void SDL_GetVersion( void * ver );", "	( ver -- )" );
	swigFunction( "c-function SDL_GetRevision SDL_GetRevision  -- s", "FUNCTION: SDL_GetRevision (  -- s )", "EXTERN: \"C\" char * SDL_GetRevision(  );", "	( -- )" );
	swigFunction( "c-function SDL_GetRevisionNumber SDL_GetRevisionNumber  -- n", "FUNCTION: SDL_GetRevisionNumber (  -- n )", "EXTERN: \"C\" int SDL_GetRevisionNumber(  );", "	( -- )" );
	swigFunction( "c-function SDL_GetNumVideoDrivers SDL_GetNumVideoDrivers  -- n", "FUNCTION: SDL_GetNumVideoDrivers (  -- n )", "EXTERN: \"C\" int SDL_GetNumVideoDrivers(  );", "	( -- )" );
	swigFunction( "c-function SDL_GetVideoDriver SDL_GetVideoDriver n -- s", "FUNCTION: SDL_GetVideoDriver ( index -- s )", "EXTERN: \"C\" char * SDL_GetVideoDriver( int index );", "	( index -- )" );
	swigFunction( "c-function SDL_VideoInit SDL_VideoInit s -- n", "FUNCTION: SDL_VideoInit ( driver_name -- n )", "EXTERN: \"C\" int SDL_VideoInit( char * driver_name );", "	( driver_name -- )" );
	swigFunction( "c-function SDL_VideoQuit SDL_VideoQuit  -- void", "FUNCTION: SDL_VideoQuit (  -- void )", "EXTERN: \"C\" void SDL_VideoQuit(  );", "	( -- )" );
	swigFunction( "c-function SDL_GetCurrentVideoDriver SDL_GetCurrentVideoDriver  -- s", "FUNCTION: SDL_GetCurrentVideoDriver (  -- s )", "EXTERN: \"C\" char * SDL_GetCurrentVideoDriver(  );", "	( -- )" );
	swigFunction( "c-function SDL_GetNumVideoDisplays SDL_GetNumVideoDisplays  -- n", "FUNCTION: SDL_GetNumVideoDisplays (  -- n )", "EXTERN: \"C\" int SDL_GetNumVideoDisplays(  );", "	( -- )" );
	swigFunction( "c-function SDL_GetDisplayName SDL_GetDisplayName n -- s", "FUNCTION: SDL_GetDisplayName ( displayIndex -- s )", "EXTERN: \"C\" char * SDL_GetDisplayName( int displayIndex );", "	( displayIndex -- )" );
	swigFunction( "c-function SDL_GetDisplayBounds SDL_GetDisplayBounds n a -- n", "FUNCTION: SDL_GetDisplayBounds ( displayIndex rect -- n )", "EXTERN: \"C\" int SDL_GetDisplayBounds( int displayIndex, void * rect );", "	( displayIndex rect -- )" );
	swigFunction( "c-function SDL_GetDisplayUsableBounds SDL_GetDisplayUsableBounds n a -- n", "FUNCTION: SDL_GetDisplayUsableBounds ( displayIndex rect -- n )", "EXTERN: \"C\" int SDL_GetDisplayUsableBounds( int displayIndex, void * rect );", "	( displayIndex rect -- )" );
	swigFunction( "c-function SDL_GetDisplayDPI SDL_GetDisplayDPI n a a a -- n", "FUNCTION: SDL_GetDisplayDPI ( displayIndex ddpi hdpi vdpi -- n )", "EXTERN: \"C\" int SDL_GetDisplayDPI( int displayIndex, void * ddpi, void * hdpi, void * vdpi );", "	( displayIndex ddpi hdpi vdpi -- )" );
	swigFunction( "c-function SDL_GetDisplayOrientation SDL_GetDisplayOrientation n -- n", "FUNCTION: SDL_GetDisplayOrientation ( displayIndex -- n )", "EXTERN: \"C\" int SDL_GetDisplayOrientation( int displayIndex );", "	( displayIndex -- )" );
	swigFunction( "c-function SDL_GetNumDisplayModes SDL_GetNumDisplayModes n -- n", "FUNCTION: SDL_GetNumDisplayModes ( displayIndex -- n )", "EXTERN: \"C\" int SDL_GetNumDisplayModes( int displayIndex );", "	( displayIndex -- )" );
	swigFunction( "c-function SDL_GetDisplayMode SDL_GetDisplayMode n n a -- n", "FUNCTION: SDL_GetDisplayMode ( displayIndex modeIndex mode -- n )", "EXTERN: \"C\" int SDL_GetDisplayMode( int displayIndex, int modeIndex, void * mode );", "	( displayIndex modeIndex mode -- )" );
	swigFunction( "c-function SDL_GetDesktopDisplayMode SDL_GetDesktopDisplayMode n a -- n", "FUNCTION: SDL_GetDesktopDisplayMode ( displayIndex mode -- n )", "EXTERN: \"C\" int SDL_GetDesktopDisplayMode( int displayIndex, void * mode );", "	( displayIndex mode -- )" );
	swigFunction( "c-function SDL_GetCurrentDisplayMode SDL_GetCurrentDisplayMode n a -- n", "FUNCTION: SDL_GetCurrentDisplayMode ( displayIndex mode -- n )", "EXTERN: \"C\" int SDL_GetCurrentDisplayMode( int displayIndex, void * mode );", "	( displayIndex mode -- )" );
	swigFunction( "c-function SDL_GetClosestDisplayMode SDL_GetClosestDisplayMode n a a -- a", "FUNCTION: SDL_GetClosestDisplayMode ( displayIndex mode closest -- a )", "EXTERN: \"C\" void * SDL_GetClosestDisplayMode( int displayIndex, void * mode, void * closest );", "	( displayIndex mode closest -- )" );
	swigFunction( "c-function SDL_GetWindowDisplayIndex SDL_GetWindowDisplayIndex a -- n", "FUNCTION: SDL_GetWindowDisplayIndex ( window -- n )", "EXTERN: \"C\" int SDL_GetWindowDisplayIndex( void * window );", "	( window -- )" );
	swigFunction( "c-function SDL_SetWindowDisplayMode SDL_SetWindowDisplayMode a a -- n", "FUNCTION: SDL_SetWindowDisplayMode ( window mode -- n )", "EXTERN: \"C\" int SDL_SetWindowDisplayMode( void * window, void * mode );", "	( window mode -- )" );
	swigFunction( "c-function SDL_GetWindowDisplayMode SDL_GetWindowDisplayMode a a -- n", "FUNCTION: SDL_GetWindowDisplayMode ( window mode -- n )", "EXTERN: \"C\" int SDL_GetWindowDisplayMode( void * window, void * mode );", "	( window mode -- )" );
	swigFunction( "c-function SDL_GetWindowICCProfile SDL_GetWindowICCProfile a a -- a", "FUNCTION: SDL_GetWindowICCProfile ( window size -- a )", "EXTERN: \"C\" void * SDL_GetWindowICCProfile( void * window, void * size );", "	( window size -- )" );
	swigFunction( "c-function SDL_GetWindowPixelFormat SDL_GetWindowPixelFormat a -- u", "FUNCTION: SDL_GetWindowPixelFormat ( window -- u )", "EXTERN: \"C\" int SDL_GetWindowPixelFormat( void * window );", "	( window -- )" );
	swigFunction( "c-function SDL_CreateWindow SDL_CreateWindow s n n n n u -- a", "FUNCTION: SDL_CreateWindow ( title x y w h flags -- a )", "EXTERN: \"C\" void * SDL_CreateWindow( char * title, int x, int y, int w, int h, int flags );", "	( title x y w h flags -- )" );
	swigFunction( "c-function SDL_CreateWindowFrom SDL_CreateWindowFrom a -- a", "FUNCTION: SDL_CreateWindowFrom ( data -- a )", "EXTERN: \"C\" void * SDL_CreateWindowFrom( void * data );", "	( data -- )" );
	swigFunction( "c-function SDL_GetWindowID SDL_GetWindowID a -- u", "FUNCTION: SDL_GetWindowID ( window -- u )", "EXTERN: \"C\" int SDL_GetWindowID( void * window );", "	( window -- )" );
	swigFunction( "c-function SDL_GetWindowFromID SDL_GetWindowFromID u -- a", "FUNCTION: SDL_GetWindowFromID ( id -- a )", "EXTERN: \"C\" void * SDL_GetWindowFromID( int id );", "	( id -- )" );
	swigFunction( "c-function SDL_GetWindowFlags SDL_GetWindowFlags a -- u", "FUNCTION: SDL_GetWindowFlags ( window -- u )", "EXTERN: \"C\" int SDL_GetWindowFlags( void * window );", "	( window -- )" );
	swigFunction( "c-function SDL_SetWindowTitle SDL_SetWindowTitle a s -- void", "FUNCTION: SDL_SetWindowTitle ( window title -- void )", "EXTERN: \"C\" void SDL_SetWindowTitle( void * window, char * title );", "	( window title -- )" );
	swigFunction( "c-function SDL_GetWindowTitle SDL_GetWindowTitle a -- s", "FUNCTION: SDL_GetWindowTitle ( window -- s )", "EXTERN: \"C\" char * SDL_GetWindowTitle( void * window );", "	( window -- )" );
	swigFunction( "c-function SDL_SetWindowIcon SDL_SetWindowIcon a a -- void", "FUNCTION: SDL_SetWindowIcon ( window icon -- void )", "EXTERN: \"C\" void SDL_SetWindowIcon( void * window, void * icon );", "	( window icon -- )" );
	swigFunction( "c-function SDL_SetWindowData SDL_SetWindowData a s a -- a", "FUNCTION: SDL_SetWindowData ( window name userdata -- a )", "EXTERN: \"C\" void * SDL_SetWindowData( void * window, char * name, void * userdata );", "	( window name userdata -- )" );
	swigFunction( "c-function SDL_GetWindowData SDL_GetWindowData a s -- a", "FUNCTION: SDL_GetWindowData ( window name -- a )", "EXTERN: \"C\" void * SDL_GetWindowData( void * window, char * name );", "	( window name -- )" );
	swigFunction( "c-function SDL_SetWindowPosition SDL_SetWindowPosition a n n -- void", "FUNCTION: SDL_SetWindowPosition ( window x y -- void )", "EXTERN: \"C\" void SDL_SetWindowPosition( void * window, int x, int y );", "	( window x y -- )" );
	swigFunction( "c-function SDL_GetWindowPosition SDL_GetWindowPosition a a a -- void", "FUNCTION: SDL_GetWindowPosition ( window x y -- void )", "EXTERN: \"C\" void SDL_GetWindowPosition( void * window, void * x, void * y );", "	( window x y -- )" );
	swigFunction( "c-function SDL_SetWindowSize SDL_SetWindowSize a n n -- void", "FUNCTION: SDL_SetWindowSize ( window w h -- void )", "EXTERN: \"C\" void SDL_SetWindowSize( void * window, int w, int h );", "	( window w h -- )" );
	swigFunction( "c-function SDL_GetWindowSize SDL_GetWindowSize a a a -- void", "FUNCTION: SDL_GetWindowSize ( window w h -- void )", "EXTERN: \"C\" void SDL_GetWindowSize( void * window, void * w, void * h );", "	( window w h -- )" );
	swigFunction( "c-function SDL_GetWindowBordersSize SDL_GetWindowBordersSize a a a a a -- n", "FUNCTION: SDL_GetWindowBordersSize ( window top left bottom right -- n )", "EXTERN: \"C\" int SDL_GetWindowBordersSize( void * window, void * top, void * left, void * bottom, void * right );", "	( window top left bottom right -- )" );
	swigFunction( "c-function SDL_SetWindowMinimumSize SDL_SetWindowMinimumSize a n n -- void", "FUNCTION: SDL_SetWindowMinimumSize ( window min_w min_h -- void )", "EXTERN: \"C\" void SDL_SetWindowMinimumSize( void * window, int min_w, int min_h );", "	( window min_w min_h -- )" );
	swigFunction( "c-function SDL_GetWindowMinimumSize SDL_GetWindowMinimumSize a a a -- void", "FUNCTION: SDL_GetWindowMinimumSize ( window w h -- void )", "EXTERN: \"C\" void SDL_GetWindowMinimumSize( void * window, void * w, void * h );", "	( window w h -- )" );
	swigFunction( "c-function SDL_SetWindowMaximumSize SDL_SetWindowMaximumSize a n n -- void", "FUNCTION: SDL_SetWindowMaximumSize ( window max_w max_h -- void )", "EXTERN: \"C\" void SDL_SetWindowMaximumSize( void * window, int max_w, int max_h );", "	( window max_w max_h -- )" );
	swigFunction( "c-function SDL_GetWindowMaximumSize SDL_GetWindowMaximumSize a a a -- void", "FUNCTION: SDL_GetWindowMaximumSize ( window w h -- void )", "EXTERN: \"C\" void SDL_GetWindowMaximumSize( void * window, void * w, void * h );", "	( window w h -- )" );
	swigFunction( "c-function SDL_SetWindowBordered SDL_SetWindowBordered a n -- void", "FUNCTION: SDL_SetWindowBordered ( window bordered -- void )", "EXTERN: \"C\" void SDL_SetWindowBordered( void * window, int bordered );", "	( window bordered -- )" );
	swigFunction( "c-function SDL_SetWindowResizable SDL_SetWindowResizable a n -- void", "FUNCTION: SDL_SetWindowResizable ( window resizable -- void )", "EXTERN: \"C\" void SDL_SetWindowResizable( void * window, int resizable );", "	( window resizable -- )" );
	swigFunction( "c-function SDL_SetWindowAlwaysOnTop SDL_SetWindowAlwaysOnTop a n -- void", "FUNCTION: SDL_SetWindowAlwaysOnTop ( window on_top -- void )", "EXTERN: \"C\" void SDL_SetWindowAlwaysOnTop( void * window, int on_top );", "	( window on_top -- )" );
	swigFunction( "c-function SDL_ShowWindow SDL_ShowWindow a -- void", "FUNCTION: SDL_ShowWindow ( window -- void )", "EXTERN: \"C\" void SDL_ShowWindow( void * window );", "	( window -- )" );
	swigFunction( "c-function SDL_HideWindow SDL_HideWindow a -- void", "FUNCTION: SDL_HideWindow ( window -- void )", "EXTERN: \"C\" void SDL_HideWindow( void * window );", "	( window -- )" );
	swigFunction( "c-function SDL_RaiseWindow SDL_RaiseWindow a -- void", "FUNCTION: SDL_RaiseWindow ( window -- void )", "EXTERN: \"C\" void SDL_RaiseWindow( void * window );", "	( window -- )" );
	swigFunction( "c-function SDL_MaximizeWindow SDL_MaximizeWindow a -- void", "FUNCTION: SDL_MaximizeWindow ( window -- void )", "EXTERN: \"C\" void SDL_MaximizeWindow( void * window );", "	( window -- )" );
	swigFunction( "c-function SDL_MinimizeWindow SDL_MinimizeWindow a -- void", "FUNCTION: SDL_MinimizeWindow ( window -- void )", "EXTERN: \"C\" void SDL_MinimizeWindow( void * window );", "	( window -- )" );
	swigFunction( "c-function SDL_RestoreWindow SDL_RestoreWindow a -- void", "FUNCTION: SDL_RestoreWindow ( window -- void )", "EXTERN: \"C\" void SDL_RestoreWindow( void * window );", "	( window -- )" );
	swigFunction( "c-function SDL_SetWindowFullscreen SDL_SetWindowFullscreen a u -- n", "FUNCTION: SDL_SetWindowFullscreen ( window flags -- n )", "EXTERN: \"C\" int SDL_SetWindowFullscreen( void * window, int flags );", "	( window flags -- )" );
	swigFunction( "c-function SDL_GetWindowSurface SDL_GetWindowSurface a -- a", "FUNCTION: SDL_GetWindowSurface ( window -- a )", "EXTERN: \"C\" void * SDL_GetWindowSurface( void * window );", "	( window -- )" );
	swigFunction( "c-function SDL_UpdateWindowSurface SDL_UpdateWindowSurface a -- n", "FUNCTION: SDL_UpdateWindowSurface ( window -- n )", "EXTERN: \"C\" int SDL_UpdateWindowSurface( void * window );", "	( window -- )" );
	swigFunction( "c-function SDL_UpdateWindowSurfaceRects SDL_UpdateWindowSurfaceRects a a n -- n", "FUNCTION: SDL_UpdateWindowSurfaceRects ( window rects numrects -- n )", "EXTERN: \"C\" int SDL_UpdateWindowSurfaceRects( void * window, void * rects, int numrects );", "	( window rects numrects -- )" );
	swigFunction( "c-function SDL_SetWindowGrab SDL_SetWindowGrab a n -- void", "FUNCTION: SDL_SetWindowGrab ( window grabbed -- void )", "EXTERN: \"C\" void SDL_SetWindowGrab( void * window, int grabbed );", "	( window grabbed -- )" );
	swigFunction( "c-function SDL_SetWindowKeyboardGrab SDL_SetWindowKeyboardGrab a n -- void", "FUNCTION: SDL_SetWindowKeyboardGrab ( window grabbed -- void )", "EXTERN: \"C\" void SDL_SetWindowKeyboardGrab( void * window, int grabbed );", "	( window grabbed -- )" );
	swigFunction( "c-function SDL_SetWindowMouseGrab SDL_SetWindowMouseGrab a n -- void", "FUNCTION: SDL_SetWindowMouseGrab ( window grabbed -- void )", "EXTERN: \"C\" void SDL_SetWindowMouseGrab( void * window, int grabbed );", "	( window grabbed -- )" );
	swigFunction( "c-function SDL_GetWindowGrab SDL_GetWindowGrab a -- n", "FUNCTION: SDL_GetWindowGrab ( window -- n )", "EXTERN: \"C\" int SDL_GetWindowGrab( void * window );", "	( window -- )" );
	swigFunction( "c-function SDL_GetWindowKeyboardGrab SDL_GetWindowKeyboardGrab a -- n", "FUNCTION: SDL_GetWindowKeyboardGrab ( window -- n )", "EXTERN: \"C\" int SDL_GetWindowKeyboardGrab( void * window );", "	( window -- )" );
	swigFunction( "c-function SDL_GetWindowMouseGrab SDL_GetWindowMouseGrab a -- n", "FUNCTION: SDL_GetWindowMouseGrab ( window -- n )", "EXTERN: \"C\" int SDL_GetWindowMouseGrab( void * window );", "	( window -- )" );
	swigFunction( "c-function SDL_GetGrabbedWindow SDL_GetGrabbedWindow  -- a", "FUNCTION: SDL_GetGrabbedWindow (  -- a )", "EXTERN: \"C\" void * SDL_GetGrabbedWindow(  );", "	( -- )" );
	swigFunction( "c-function SDL_SetWindowMouseRect SDL_SetWindowMouseRect a a -- n", "FUNCTION: SDL_SetWindowMouseRect ( window rect -- n )", "EXTERN: \"C\" int SDL_SetWindowMouseRect( void * window, void * rect );", "	( window rect -- )" );
	swigFunction( "c-function SDL_GetWindowMouseRect SDL_GetWindowMouseRect a -- a", "FUNCTION: SDL_GetWindowMouseRect ( window -- a )", "EXTERN: \"C\" void * SDL_GetWindowMouseRect( void * window );", "	( window -- )" );
	swigFunction( "c-function SDL_SetWindowBrightness SDL_SetWindowBrightness a r -- n", "FUNCTION: SDL_SetWindowBrightness ( window brightness -- n )", "EXTERN: \"C\" int SDL_SetWindowBrightness( void * window, float brightness );", "	( window brightness -- )" );
	swigFunction( "c-function SDL_GetWindowBrightness SDL_GetWindowBrightness a -- r", "FUNCTION: SDL_GetWindowBrightness ( window -- r )", "EXTERN: \"C\" float SDL_GetWindowBrightness( void * window );", "	( window -- )" );
	swigFunction( "c-function SDL_SetWindowOpacity SDL_SetWindowOpacity a r -- n", "FUNCTION: SDL_SetWindowOpacity ( window opacity -- n )", "EXTERN: \"C\" int SDL_SetWindowOpacity( void * window, float opacity );", "	( window opacity -- )" );
	swigFunction( "c-function SDL_GetWindowOpacity SDL_GetWindowOpacity a a -- n", "FUNCTION: SDL_GetWindowOpacity ( window out_opacity -- n )", "EXTERN: \"C\" int SDL_GetWindowOpacity( void * window, void * out_opacity );", "	( window out_opacity -- )" );
	swigFunction( "c-function SDL_SetWindowModalFor SDL_SetWindowModalFor a a -- n", "FUNCTION: SDL_SetWindowModalFor ( modal_window parent_window -- n )", "EXTERN: \"C\" int SDL_SetWindowModalFor( void * modal_window, void * parent_window );", "	( modal_window parent_window -- )" );
	swigFunction( "c-function SDL_SetWindowInputFocus SDL_SetWindowInputFocus a -- n", "FUNCTION: SDL_SetWindowInputFocus ( window -- n )", "EXTERN: \"C\" int SDL_SetWindowInputFocus( void * window );", "	( window -- )" );
	swigFunction( "c-function SDL_SetWindowGammaRamp SDL_SetWindowGammaRamp a a a a -- n", "FUNCTION: SDL_SetWindowGammaRamp ( window red green blue -- n )", "EXTERN: \"C\" int SDL_SetWindowGammaRamp( void * window, void * red, void * green, void * blue );", "	( window red green blue -- )" );
	swigFunction( "c-function SDL_GetWindowGammaRamp SDL_GetWindowGammaRamp a a a a -- n", "FUNCTION: SDL_GetWindowGammaRamp ( window red green blue -- n )", "EXTERN: \"C\" int SDL_GetWindowGammaRamp( void * window, void * red, void * green, void * blue );", "	( window red green blue -- )" );
	swigFunction( "c-function SDL_SetWindowHitTest SDL_SetWindowHitTest a a a -- n", "FUNCTION: SDL_SetWindowHitTest ( window callback callback_data -- n )", "EXTERN: \"C\" int SDL_SetWindowHitTest( void * window, void * callback, void * callback_data );", "	( window callback callback_data -- )" );
	swigFunction( "c-function SDL_FlashWindow SDL_FlashWindow a n -- n", "FUNCTION: SDL_FlashWindow ( window operation -- n )", "EXTERN: \"C\" int SDL_FlashWindow( void * window, int operation );", "	( window operation -- )" );
	swigFunction( "c-function SDL_DestroyWindow SDL_DestroyWindow a -- void", "FUNCTION: SDL_DestroyWindow ( window -- void )", "EXTERN: \"C\" void SDL_DestroyWindow( void * window );", "	( window -- )" );
	swigFunction( "c-function SDL_IsScreenSaverEnabled SDL_IsScreenSaverEnabled  -- n", "FUNCTION: SDL_IsScreenSaverEnabled (  -- n )", "EXTERN: \"C\" int SDL_IsScreenSaverEnabled(  );", "	( -- )" );
	swigFunction( "c-function SDL_EnableScreenSaver SDL_EnableScreenSaver  -- void", "FUNCTION: SDL_EnableScreenSaver (  -- void )", "EXTERN: \"C\" void SDL_EnableScreenSaver(  );", "	( -- )" );
	swigFunction( "c-function SDL_DisableScreenSaver SDL_DisableScreenSaver  -- void", "FUNCTION: SDL_DisableScreenSaver (  -- void )", "EXTERN: \"C\" void SDL_DisableScreenSaver(  );", "	( -- )" );
	swigFunction( "c-function SDL_GL_LoadLibrary SDL_GL_LoadLibrary s -- n", "FUNCTION: SDL_GL_LoadLibrary ( path -- n )", "EXTERN: \"C\" int SDL_GL_LoadLibrary( char * path );", "	( path -- )" );
	swigFunction( "c-function SDL_GL_GetProcAddress SDL_GL_GetProcAddress s -- a", "FUNCTION: SDL_GL_GetProcAddress ( proc -- a )", "EXTERN: \"C\" void * SDL_GL_GetProcAddress( char * proc );", "	( proc -- )" );
	swigFunction( "c-function SDL_GL_UnloadLibrary SDL_GL_UnloadLibrary  -- void", "FUNCTION: SDL_GL_UnloadLibrary (  -- void )", "EXTERN: \"C\" void SDL_GL_UnloadLibrary(  );", "	( -- )" );
	swigFunction( "c-function SDL_GL_ExtensionSupported SDL_GL_ExtensionSupported s -- n", "FUNCTION: SDL_GL_ExtensionSupported ( extension -- n )", "EXTERN: \"C\" int SDL_GL_ExtensionSupported( char * extension );", "	( extension -- )" );
	swigFunction( "c-function SDL_GL_ResetAttributes SDL_GL_ResetAttributes  -- void", "FUNCTION: SDL_GL_ResetAttributes (  -- void )", "EXTERN: \"C\" void SDL_GL_ResetAttributes(  );", "	( -- )" );
	swigFunction( "c-function SDL_GL_SetAttribute SDL_GL_SetAttribute n n -- n", "FUNCTION: SDL_GL_SetAttribute ( attr value -- n )", "EXTERN: \"C\" int SDL_GL_SetAttribute( int attr, int value );", "	( attr value -- )" );
	swigFunction( "c-function SDL_GL_GetAttribute SDL_GL_GetAttribute n a -- n", "FUNCTION: SDL_GL_GetAttribute ( attr value -- n )", "EXTERN: \"C\" int SDL_GL_GetAttribute( int attr, void * value );", "	( attr value -- )" );
	swigFunction( "c-function SDL_GL_CreateContext SDL_GL_CreateContext a -- a", "FUNCTION: SDL_GL_CreateContext ( window -- a )", "EXTERN: \"C\" void * SDL_GL_CreateContext( void * window );", "	( window -- )" );
	swigFunction( "c-function SDL_GL_MakeCurrent SDL_GL_MakeCurrent a a -- n", "FUNCTION: SDL_GL_MakeCurrent ( window context -- n )", "EXTERN: \"C\" int SDL_GL_MakeCurrent( void * window, void * context );", "	( window context -- )" );
	swigFunction( "c-function SDL_GL_GetCurrentWindow SDL_GL_GetCurrentWindow  -- a", "FUNCTION: SDL_GL_GetCurrentWindow (  -- a )", "EXTERN: \"C\" void * SDL_GL_GetCurrentWindow(  );", "	( -- )" );
	swigFunction( "c-function SDL_GL_GetCurrentContext SDL_GL_GetCurrentContext  -- a", "FUNCTION: SDL_GL_GetCurrentContext (  -- a )", "EXTERN: \"C\" void * SDL_GL_GetCurrentContext(  );", "	( -- )" );
	swigFunction( "c-function SDL_GL_GetDrawableSize SDL_GL_GetDrawableSize a a a -- void", "FUNCTION: SDL_GL_GetDrawableSize ( window w h -- void )", "EXTERN: \"C\" void SDL_GL_GetDrawableSize( void * window, void * w, void * h );", "	( window w h -- )" );
	swigFunction( "c-function SDL_GL_SetSwapInterval SDL_GL_SetSwapInterval n -- n", "FUNCTION: SDL_GL_SetSwapInterval ( interval -- n )", "EXTERN: \"C\" int SDL_GL_SetSwapInterval( int interval );", "	( interval -- )" );
	swigFunction( "c-function SDL_GL_GetSwapInterval SDL_GL_GetSwapInterval  -- n", "FUNCTION: SDL_GL_GetSwapInterval (  -- n )", "EXTERN: \"C\" int SDL_GL_GetSwapInterval(  );", "	( -- )" );
	swigFunction( "c-function SDL_GL_SwapWindow SDL_GL_SwapWindow a -- void", "FUNCTION: SDL_GL_SwapWindow ( window -- void )", "EXTERN: \"C\" void SDL_GL_SwapWindow( void * window );", "	( window -- )" );
	swigFunction( "c-function SDL_GL_DeleteContext SDL_GL_DeleteContext a -- void", "FUNCTION: SDL_GL_DeleteContext ( context -- void )", "EXTERN: \"C\" void SDL_GL_DeleteContext( void * context );", "	( context -- )" );
	swigFunction( "c-function SDL_GetPreferredLocales SDL_GetPreferredLocales  -- a", "FUNCTION: SDL_GetPreferredLocales (  -- a )", "EXTERN: \"C\" void * SDL_GetPreferredLocales(  );", "	( -- )" );
	swigFunction( "c-function SDL_OpenURL SDL_OpenURL s -- n", "FUNCTION: SDL_OpenURL ( url -- n )", "EXTERN: \"C\" int SDL_OpenURL( char * url );", "	( url -- )" );

	swigNewline();

	swigComment("----===< postfix >===-----\n");

	swigPrint( "end-c-library", "( none )", "( none )" );
	
	return 0;
} /* end of main */



