/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 3.0.9
 *
 * This file is not intended to be easily readable and contains a number of
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG
 * interface file instead.
 * ----------------------------------------------------------------------------- */
#include <stdio.h>
#include <string.h>
#include <stddef.h>

// Do not edit below this line
// end-of-default-includes


#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include <X11/XF86keysym.h>
#include <X11/extensions/sync.h>
#include <X11/extensions/Xrandr.h>
#define _EVDEVK(x) x

typedef enum{ NONE = -1, GFORTH = 0, SWIFTFORTH, VFX } SwigTargetSystem;
SwigTargetSystem swigTargetSystem = NONE;

unsigned char swigPrintStackComments = 1;

/* comments */
void swigNewline()
{
	printf( "\n" );
}

void swigComment( char *comment )
{
	printf( "\\ %s", comment );
}

/* generic print */
void swigPrint( char* gforth, char *swiftForth, char *vfx )
{
	if( swigTargetSystem == GFORTH )
		printf( "%s", gforth );
	else if( swigTargetSystem == SWIFTFORTH )
		printf( "%s", swiftForth );
	else if( swigTargetSystem == VFX )
		printf( "%s", vfx );
	printf( "\n" );
}
void swigPrintSystem( SwigTargetSystem targetSystem, char *text )
{
	if( targetSystem == swigTargetSystem )
	    printf( "%s\n", text );
}

/* constants */
void swigIntConstant( long constant, char *name )
{
	printf( "#%ld\tconstant %s\n", constant, name );
}

void swigUnsignedIntConstant( unsigned long constant, char *name )
{
	printf( "#%lu\tconstant %s\n", constant, name );
}

void swigLongConstant( long long constant, char *name )
{
	printf( "#%lld.\t2constant %s\n", constant, name );
}

void swigUnsignedLongConstant( unsigned long long constant, char *name )
{
	printf( "#%llu.\t2constant %s\n", constant, name );
}

void swigFloatConstant( double constant, char *name )
{
	char buffer[128];
	sprintf( buffer, "%f", constant );

	/* if the constant contains no exponent, add one */
	char *s;
	for( s = buffer; *s != 0; s++ )
		if( *s == 'e' || *s == 'E' )
			break;

	/* exponent found */
	if( *s != 0 )
		printf( "%s\tfconstant %s\n", buffer, name );
	/* not found */
	else
		printf( "%se0\tfconstant %s\n", buffer, name );
}

void swigStringConstant( char* constant, char *name )
{
	char c;
	printf( ": %s s\\\" ", name );
	while(( c = *constant++ ))
	{
		switch(c)
		{
			case '\b': printf( "\\b" ); break;
			case '\n': printf( "\\n" ); break;
			case '\f': printf( "\\f" ); break;
			case '\r': printf( "\\r" ); break;
			case '\t': printf( "\\t" ); break;
			case '"' : printf( "\\q" ); break;
			default:
				if(c < 0x20)
					printf("\\x%02x", c);
				else
					printf("%c", c); break;
		}
	}
	printf(	"\" ;\n" );
}

/* structs */
void swigStructField( char *name, size_t offset, size_t size )
{
	printf( "\tdrop %zu %zu +field %s\n", offset, size, name );
}

/* functions */
void swigFunction( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	if( swigTargetSystem == GFORTH )
		printf( "%s", gforth );
	else if( swigTargetSystem == SWIFTFORTH )
		printf( "%s", swiftForth );
	else if( swigTargetSystem == VFX )
		printf( "%s", vfx );

	if( swigPrintStackComments )
		printf( "%s", stackComment );

	printf( "\n" );
}

/* function pointers */
void swigFunctionPointer( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	swigFunction( gforth, swiftForth, vfx, stackComment );
}

/* callbacks */
void swigCallback( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	swigFunction( gforth, swiftForth, vfx, stackComment );
}

void swigUsage( char **argv )
{
	fprintf( stderr, "Usage: %s [-gforth|-swiftforth|-vfx]\n", argv[0] );
}

int main( int argc, char **argv )
{
	int i;

	/* check arguments */
	for( i = 1; i < argc; i++ )
		if( strcmp( argv[i], "-gforth" ) == 0 )
			swigTargetSystem = GFORTH;
		else if( strcmp( argv[i], "-swiftforth" ) == 0 )
			swigTargetSystem = SWIFTFORTH;
		else if( strcmp( argv[i], "-vfx" ) == 0 )
			swigTargetSystem = VFX;

	if( swigTargetSystem == NONE )
	{
		fprintf( stderr, "Error: no target system specified\n" );
		swigUsage( argv );
		return 1;
	}

	/* primer */
	printf( "\\ This file has been generated using SWIG and fsi,\n"
		"\\ and is already platform dependent, search for the corresponding\n"
		"\\ fsi-file to compile it where no one has compiled it before ;)\n"
		"\\ Forth systems have their own own dynamic loader and don't need addional C-Code.\n"
		"\\ That's why this file will just print normal forth-code once compiled\n"
		"\\ and can be used directly with include or require.\n"
		"\\ As all comments are stripped during the compilation, please\n"
		"\\ insert the copyright notice of the original file here.\n"
	);


typedef union {
  char b[20];
  short s[10];
  long l[5];
} XClientMessageEvent_data;

typedef union {
  char *multi_byte;
  wchar_t *wide_char;
} _XIMText_string;

typedef union {
  char *mbs;
  wchar_t *wcs;
} _XIMStringConversionText_string;

typedef union {
  XIMText *text;
  Pixmap  bitmap;
} _XIMStatusDrawCallbackStruct_data;

typedef struct {
  int x;	               
  int y;	                 
} XSizeHints_min_aspect;


	swigNewline();

	swigComment("----===< prefix >===-----\n");

	swigPrint( "c-library x\ns\" X11 -lXext -lXrandr\" add-lib\n\\c #include <X11/X.h>\n\\c #include <X11/Xlib.h>\n\\c #include <X11/Xutil.h>\n\\c #include <X11/keysym.h>\n\\c #include <X11/XF86keysym.h>\n\\c #include <X11/extensions/sync.h>\n\\c #include <X11/extensions/Xrandr.h>\n\\c #define _EVDEVK(x) x", "( none )", "( none )" );

	swigNewline();

	swigComment("----===< int constants >===-----\n");
	#ifdef X_PROTOCOL
		swigIntConstant( X_PROTOCOL, "X_PROTOCOL" );
	#endif
	#ifdef X_PROTOCOL_REVISION
		swigIntConstant( X_PROTOCOL_REVISION, "X_PROTOCOL_REVISION" );
	#endif
	#ifdef None
		swigIntConstant( None, "None" );
	#endif
	#ifdef ParentRelative
		swigIntConstant( ParentRelative, "ParentRelative" );
	#endif
	#ifdef CopyFromParent
		swigIntConstant( CopyFromParent, "CopyFromParent" );
	#endif
	#ifdef PointerWindow
		swigIntConstant( PointerWindow, "PointerWindow" );
	#endif
	#ifdef InputFocus
		swigIntConstant( InputFocus, "InputFocus" );
	#endif
	#ifdef PointerRoot
		swigIntConstant( PointerRoot, "PointerRoot" );
	#endif
	#ifdef AnyPropertyType
		swigIntConstant( AnyPropertyType, "AnyPropertyType" );
	#endif
	#ifdef AnyKey
		swigIntConstant( AnyKey, "AnyKey" );
	#endif
	#ifdef AnyButton
		swigIntConstant( AnyButton, "AnyButton" );
	#endif
	#ifdef AllTemporary
		swigIntConstant( AllTemporary, "AllTemporary" );
	#endif
	#ifdef CurrentTime
		swigIntConstant( CurrentTime, "CurrentTime" );
	#endif
	#ifdef NoSymbol
		swigIntConstant( NoSymbol, "NoSymbol" );
	#endif
	#ifdef NoEventMask
		swigIntConstant( NoEventMask, "NoEventMask" );
	#endif
	#ifdef KeyPressMask
		swigIntConstant( KeyPressMask, "KeyPressMask" );
	#endif
	#ifdef KeyReleaseMask
		swigIntConstant( KeyReleaseMask, "KeyReleaseMask" );
	#endif
	#ifdef ButtonPressMask
		swigIntConstant( ButtonPressMask, "ButtonPressMask" );
	#endif
	#ifdef ButtonReleaseMask
		swigIntConstant( ButtonReleaseMask, "ButtonReleaseMask" );
	#endif
	#ifdef EnterWindowMask
		swigIntConstant( EnterWindowMask, "EnterWindowMask" );
	#endif
	#ifdef LeaveWindowMask
		swigIntConstant( LeaveWindowMask, "LeaveWindowMask" );
	#endif
	#ifdef PointerMotionMask
		swigIntConstant( PointerMotionMask, "PointerMotionMask" );
	#endif
	#ifdef PointerMotionHintMask
		swigIntConstant( PointerMotionHintMask, "PointerMotionHintMask" );
	#endif
	#ifdef Button1MotionMask
		swigIntConstant( Button1MotionMask, "Button1MotionMask" );
	#endif
	#ifdef Button2MotionMask
		swigIntConstant( Button2MotionMask, "Button2MotionMask" );
	#endif
	#ifdef Button3MotionMask
		swigIntConstant( Button3MotionMask, "Button3MotionMask" );
	#endif
	#ifdef Button4MotionMask
		swigIntConstant( Button4MotionMask, "Button4MotionMask" );
	#endif
	#ifdef Button5MotionMask
		swigIntConstant( Button5MotionMask, "Button5MotionMask" );
	#endif
	#ifdef ButtonMotionMask
		swigIntConstant( ButtonMotionMask, "ButtonMotionMask" );
	#endif
	#ifdef KeymapStateMask
		swigIntConstant( KeymapStateMask, "KeymapStateMask" );
	#endif
	#ifdef ExposureMask
		swigIntConstant( ExposureMask, "ExposureMask" );
	#endif
	#ifdef VisibilityChangeMask
		swigIntConstant( VisibilityChangeMask, "VisibilityChangeMask" );
	#endif
	#ifdef StructureNotifyMask
		swigIntConstant( StructureNotifyMask, "StructureNotifyMask" );
	#endif
	#ifdef ResizeRedirectMask
		swigIntConstant( ResizeRedirectMask, "ResizeRedirectMask" );
	#endif
	#ifdef SubstructureNotifyMask
		swigIntConstant( SubstructureNotifyMask, "SubstructureNotifyMask" );
	#endif
	#ifdef SubstructureRedirectMask
		swigIntConstant( SubstructureRedirectMask, "SubstructureRedirectMask" );
	#endif
	#ifdef FocusChangeMask
		swigIntConstant( FocusChangeMask, "FocusChangeMask" );
	#endif
	#ifdef PropertyChangeMask
		swigIntConstant( PropertyChangeMask, "PropertyChangeMask" );
	#endif
	#ifdef ColormapChangeMask
		swigIntConstant( ColormapChangeMask, "ColormapChangeMask" );
	#endif
	#ifdef OwnerGrabButtonMask
		swigIntConstant( OwnerGrabButtonMask, "OwnerGrabButtonMask" );
	#endif
	#ifdef KeyPress
		swigIntConstant( KeyPress, "KeyPress" );
	#endif
	#ifdef KeyRelease
		swigIntConstant( KeyRelease, "KeyRelease" );
	#endif
	#ifdef ButtonPress
		swigIntConstant( ButtonPress, "ButtonPress" );
	#endif
	#ifdef ButtonRelease
		swigIntConstant( ButtonRelease, "ButtonRelease" );
	#endif
	#ifdef MotionNotify
		swigIntConstant( MotionNotify, "MotionNotify" );
	#endif
	#ifdef EnterNotify
		swigIntConstant( EnterNotify, "EnterNotify" );
	#endif
	#ifdef LeaveNotify
		swigIntConstant( LeaveNotify, "LeaveNotify" );
	#endif
	#ifdef FocusIn
		swigIntConstant( FocusIn, "FocusIn" );
	#endif
	#ifdef FocusOut
		swigIntConstant( FocusOut, "FocusOut" );
	#endif
	#ifdef KeymapNotify
		swigIntConstant( KeymapNotify, "KeymapNotify" );
	#endif
	#ifdef Expose
		swigIntConstant( Expose, "Expose" );
	#endif
	#ifdef GraphicsExpose
		swigIntConstant( GraphicsExpose, "GraphicsExpose" );
	#endif
	#ifdef NoExpose
		swigIntConstant( NoExpose, "NoExpose" );
	#endif
	#ifdef VisibilityNotify
		swigIntConstant( VisibilityNotify, "VisibilityNotify" );
	#endif
	#ifdef CreateNotify
		swigIntConstant( CreateNotify, "CreateNotify" );
	#endif
	#ifdef DestroyNotify
		swigIntConstant( DestroyNotify, "DestroyNotify" );
	#endif
	#ifdef UnmapNotify
		swigIntConstant( UnmapNotify, "UnmapNotify" );
	#endif
	#ifdef MapNotify
		swigIntConstant( MapNotify, "MapNotify" );
	#endif
	#ifdef MapRequest
		swigIntConstant( MapRequest, "MapRequest" );
	#endif
	#ifdef ReparentNotify
		swigIntConstant( ReparentNotify, "ReparentNotify" );
	#endif
	#ifdef ConfigureNotify
		swigIntConstant( ConfigureNotify, "ConfigureNotify" );
	#endif
	#ifdef ConfigureRequest
		swigIntConstant( ConfigureRequest, "ConfigureRequest" );
	#endif
	#ifdef GravityNotify
		swigIntConstant( GravityNotify, "GravityNotify" );
	#endif
	#ifdef ResizeRequest
		swigIntConstant( ResizeRequest, "ResizeRequest" );
	#endif
	#ifdef CirculateNotify
		swigIntConstant( CirculateNotify, "CirculateNotify" );
	#endif
	#ifdef CirculateRequest
		swigIntConstant( CirculateRequest, "CirculateRequest" );
	#endif
	#ifdef PropertyNotify
		swigIntConstant( PropertyNotify, "PropertyNotify" );
	#endif
	#ifdef SelectionClear
		swigIntConstant( SelectionClear, "SelectionClear" );
	#endif
	#ifdef SelectionRequest
		swigIntConstant( SelectionRequest, "SelectionRequest" );
	#endif
	#ifdef SelectionNotify
		swigIntConstant( SelectionNotify, "SelectionNotify" );
	#endif
	#ifdef ColormapNotify
		swigIntConstant( ColormapNotify, "ColormapNotify" );
	#endif
	#ifdef ClientMessage
		swigIntConstant( ClientMessage, "ClientMessage" );
	#endif
	#ifdef MappingNotify
		swigIntConstant( MappingNotify, "MappingNotify" );
	#endif
	#ifdef GenericEvent
		swigIntConstant( GenericEvent, "GenericEvent" );
	#endif
	#ifdef LASTEvent
		swigIntConstant( LASTEvent, "LASTEvent" );
	#endif
	#ifdef ShiftMask
		swigIntConstant( ShiftMask, "ShiftMask" );
	#endif
	#ifdef LockMask
		swigIntConstant( LockMask, "LockMask" );
	#endif
	#ifdef ControlMask
		swigIntConstant( ControlMask, "ControlMask" );
	#endif
	#ifdef Mod1Mask
		swigIntConstant( Mod1Mask, "Mod1Mask" );
	#endif
	#ifdef Mod2Mask
		swigIntConstant( Mod2Mask, "Mod2Mask" );
	#endif
	#ifdef Mod3Mask
		swigIntConstant( Mod3Mask, "Mod3Mask" );
	#endif
	#ifdef Mod4Mask
		swigIntConstant( Mod4Mask, "Mod4Mask" );
	#endif
	#ifdef Mod5Mask
		swigIntConstant( Mod5Mask, "Mod5Mask" );
	#endif
	#ifdef ShiftMapIndex
		swigIntConstant( ShiftMapIndex, "ShiftMapIndex" );
	#endif
	#ifdef LockMapIndex
		swigIntConstant( LockMapIndex, "LockMapIndex" );
	#endif
	#ifdef ControlMapIndex
		swigIntConstant( ControlMapIndex, "ControlMapIndex" );
	#endif
	#ifdef Mod1MapIndex
		swigIntConstant( Mod1MapIndex, "Mod1MapIndex" );
	#endif
	#ifdef Mod2MapIndex
		swigIntConstant( Mod2MapIndex, "Mod2MapIndex" );
	#endif
	#ifdef Mod3MapIndex
		swigIntConstant( Mod3MapIndex, "Mod3MapIndex" );
	#endif
	#ifdef Mod4MapIndex
		swigIntConstant( Mod4MapIndex, "Mod4MapIndex" );
	#endif
	#ifdef Mod5MapIndex
		swigIntConstant( Mod5MapIndex, "Mod5MapIndex" );
	#endif
	#ifdef Button1Mask
		swigIntConstant( Button1Mask, "Button1Mask" );
	#endif
	#ifdef Button2Mask
		swigIntConstant( Button2Mask, "Button2Mask" );
	#endif
	#ifdef Button3Mask
		swigIntConstant( Button3Mask, "Button3Mask" );
	#endif
	#ifdef Button4Mask
		swigIntConstant( Button4Mask, "Button4Mask" );
	#endif
	#ifdef Button5Mask
		swigIntConstant( Button5Mask, "Button5Mask" );
	#endif
	#ifdef AnyModifier
		swigIntConstant( AnyModifier, "AnyModifier" );
	#endif
	#ifdef Button1
		swigIntConstant( Button1, "Button1" );
	#endif
	#ifdef Button2
		swigIntConstant( Button2, "Button2" );
	#endif
	#ifdef Button3
		swigIntConstant( Button3, "Button3" );
	#endif
	#ifdef Button4
		swigIntConstant( Button4, "Button4" );
	#endif
	#ifdef Button5
		swigIntConstant( Button5, "Button5" );
	#endif
	#ifdef NotifyNormal
		swigIntConstant( NotifyNormal, "NotifyNormal" );
	#endif
	#ifdef NotifyGrab
		swigIntConstant( NotifyGrab, "NotifyGrab" );
	#endif
	#ifdef NotifyUngrab
		swigIntConstant( NotifyUngrab, "NotifyUngrab" );
	#endif
	#ifdef NotifyWhileGrabbed
		swigIntConstant( NotifyWhileGrabbed, "NotifyWhileGrabbed" );
	#endif
	#ifdef NotifyHint
		swigIntConstant( NotifyHint, "NotifyHint" );
	#endif
	#ifdef NotifyAncestor
		swigIntConstant( NotifyAncestor, "NotifyAncestor" );
	#endif
	#ifdef NotifyVirtual
		swigIntConstant( NotifyVirtual, "NotifyVirtual" );
	#endif
	#ifdef NotifyInferior
		swigIntConstant( NotifyInferior, "NotifyInferior" );
	#endif
	#ifdef NotifyNonlinear
		swigIntConstant( NotifyNonlinear, "NotifyNonlinear" );
	#endif
	#ifdef NotifyNonlinearVirtual
		swigIntConstant( NotifyNonlinearVirtual, "NotifyNonlinearVirtual" );
	#endif
	#ifdef NotifyPointer
		swigIntConstant( NotifyPointer, "NotifyPointer" );
	#endif
	#ifdef NotifyPointerRoot
		swigIntConstant( NotifyPointerRoot, "NotifyPointerRoot" );
	#endif
	#ifdef NotifyDetailNone
		swigIntConstant( NotifyDetailNone, "NotifyDetailNone" );
	#endif
	#ifdef VisibilityUnobscured
		swigIntConstant( VisibilityUnobscured, "VisibilityUnobscured" );
	#endif
	#ifdef VisibilityPartiallyObscured
		swigIntConstant( VisibilityPartiallyObscured, "VisibilityPartiallyObscured" );
	#endif
	#ifdef VisibilityFullyObscured
		swigIntConstant( VisibilityFullyObscured, "VisibilityFullyObscured" );
	#endif
	#ifdef PlaceOnTop
		swigIntConstant( PlaceOnTop, "PlaceOnTop" );
	#endif
	#ifdef PlaceOnBottom
		swigIntConstant( PlaceOnBottom, "PlaceOnBottom" );
	#endif
	#ifdef FamilyInternet
		swigIntConstant( FamilyInternet, "FamilyInternet" );
	#endif
	#ifdef FamilyDECnet
		swigIntConstant( FamilyDECnet, "FamilyDECnet" );
	#endif
	#ifdef FamilyChaos
		swigIntConstant( FamilyChaos, "FamilyChaos" );
	#endif
	#ifdef FamilyInternet6
		swigIntConstant( FamilyInternet6, "FamilyInternet6" );
	#endif
	#ifdef FamilyServerInterpreted
		swigIntConstant( FamilyServerInterpreted, "FamilyServerInterpreted" );
	#endif
	#ifdef PropertyNewValue
		swigIntConstant( PropertyNewValue, "PropertyNewValue" );
	#endif
	#ifdef PropertyDelete
		swigIntConstant( PropertyDelete, "PropertyDelete" );
	#endif
	#ifdef ColormapUninstalled
		swigIntConstant( ColormapUninstalled, "ColormapUninstalled" );
	#endif
	#ifdef ColormapInstalled
		swigIntConstant( ColormapInstalled, "ColormapInstalled" );
	#endif
	#ifdef GrabModeSync
		swigIntConstant( GrabModeSync, "GrabModeSync" );
	#endif
	#ifdef GrabModeAsync
		swigIntConstant( GrabModeAsync, "GrabModeAsync" );
	#endif
	#ifdef GrabSuccess
		swigIntConstant( GrabSuccess, "GrabSuccess" );
	#endif
	#ifdef AlreadyGrabbed
		swigIntConstant( AlreadyGrabbed, "AlreadyGrabbed" );
	#endif
	#ifdef GrabInvalidTime
		swigIntConstant( GrabInvalidTime, "GrabInvalidTime" );
	#endif
	#ifdef GrabNotViewable
		swigIntConstant( GrabNotViewable, "GrabNotViewable" );
	#endif
	#ifdef GrabFrozen
		swigIntConstant( GrabFrozen, "GrabFrozen" );
	#endif
	#ifdef AsyncPointer
		swigIntConstant( AsyncPointer, "AsyncPointer" );
	#endif
	#ifdef SyncPointer
		swigIntConstant( SyncPointer, "SyncPointer" );
	#endif
	#ifdef ReplayPointer
		swigIntConstant( ReplayPointer, "ReplayPointer" );
	#endif
	#ifdef AsyncKeyboard
		swigIntConstant( AsyncKeyboard, "AsyncKeyboard" );
	#endif
	#ifdef SyncKeyboard
		swigIntConstant( SyncKeyboard, "SyncKeyboard" );
	#endif
	#ifdef ReplayKeyboard
		swigIntConstant( ReplayKeyboard, "ReplayKeyboard" );
	#endif
	#ifdef AsyncBoth
		swigIntConstant( AsyncBoth, "AsyncBoth" );
	#endif
	#ifdef SyncBoth
		swigIntConstant( SyncBoth, "SyncBoth" );
	#endif
	#ifdef RevertToParent
		swigIntConstant( RevertToParent, "RevertToParent" );
	#endif
	#ifdef Success
		swigIntConstant( Success, "Success" );
	#endif
	#ifdef BadRequest
		swigIntConstant( BadRequest, "BadRequest" );
	#endif
	#ifdef BadValue
		swigIntConstant( BadValue, "BadValue" );
	#endif
	#ifdef BadWindow
		swigIntConstant( BadWindow, "BadWindow" );
	#endif
	#ifdef BadPixmap
		swigIntConstant( BadPixmap, "BadPixmap" );
	#endif
	#ifdef BadAtom
		swigIntConstant( BadAtom, "BadAtom" );
	#endif
	#ifdef BadCursor
		swigIntConstant( BadCursor, "BadCursor" );
	#endif
	#ifdef BadFont
		swigIntConstant( BadFont, "BadFont" );
	#endif
	#ifdef BadMatch
		swigIntConstant( BadMatch, "BadMatch" );
	#endif
	#ifdef BadDrawable
		swigIntConstant( BadDrawable, "BadDrawable" );
	#endif
	#ifdef BadAccess
		swigIntConstant( BadAccess, "BadAccess" );
	#endif
	#ifdef BadAlloc
		swigIntConstant( BadAlloc, "BadAlloc" );
	#endif
	#ifdef BadColor
		swigIntConstant( BadColor, "BadColor" );
	#endif
	#ifdef BadGC
		swigIntConstant( BadGC, "BadGC" );
	#endif
	#ifdef BadIDChoice
		swigIntConstant( BadIDChoice, "BadIDChoice" );
	#endif
	#ifdef BadName
		swigIntConstant( BadName, "BadName" );
	#endif
	#ifdef BadLength
		swigIntConstant( BadLength, "BadLength" );
	#endif
	#ifdef BadImplementation
		swigIntConstant( BadImplementation, "BadImplementation" );
	#endif
	#ifdef FirstExtensionError
		swigIntConstant( FirstExtensionError, "FirstExtensionError" );
	#endif
	#ifdef LastExtensionError
		swigIntConstant( LastExtensionError, "LastExtensionError" );
	#endif
	#ifdef InputOutput
		swigIntConstant( InputOutput, "InputOutput" );
	#endif
	#ifdef InputOnly
		swigIntConstant( InputOnly, "InputOnly" );
	#endif
	#ifdef CWBackPixmap
		swigIntConstant( CWBackPixmap, "CWBackPixmap" );
	#endif
	#ifdef CWBackPixel
		swigIntConstant( CWBackPixel, "CWBackPixel" );
	#endif
	#ifdef CWBorderPixmap
		swigIntConstant( CWBorderPixmap, "CWBorderPixmap" );
	#endif
	#ifdef CWBorderPixel
		swigIntConstant( CWBorderPixel, "CWBorderPixel" );
	#endif
	#ifdef CWBitGravity
		swigIntConstant( CWBitGravity, "CWBitGravity" );
	#endif
	#ifdef CWWinGravity
		swigIntConstant( CWWinGravity, "CWWinGravity" );
	#endif
	#ifdef CWBackingStore
		swigIntConstant( CWBackingStore, "CWBackingStore" );
	#endif
	#ifdef CWBackingPlanes
		swigIntConstant( CWBackingPlanes, "CWBackingPlanes" );
	#endif
	#ifdef CWBackingPixel
		swigIntConstant( CWBackingPixel, "CWBackingPixel" );
	#endif
	#ifdef CWOverrideRedirect
		swigIntConstant( CWOverrideRedirect, "CWOverrideRedirect" );
	#endif
	#ifdef CWSaveUnder
		swigIntConstant( CWSaveUnder, "CWSaveUnder" );
	#endif
	#ifdef CWEventMask
		swigIntConstant( CWEventMask, "CWEventMask" );
	#endif
	#ifdef CWDontPropagate
		swigIntConstant( CWDontPropagate, "CWDontPropagate" );
	#endif
	#ifdef CWColormap
		swigIntConstant( CWColormap, "CWColormap" );
	#endif
	#ifdef CWCursor
		swigIntConstant( CWCursor, "CWCursor" );
	#endif
	#ifdef CWX
		swigIntConstant( CWX, "CWX" );
	#endif
	#ifdef CWY
		swigIntConstant( CWY, "CWY" );
	#endif
	#ifdef CWWidth
		swigIntConstant( CWWidth, "CWWidth" );
	#endif
	#ifdef CWHeight
		swigIntConstant( CWHeight, "CWHeight" );
	#endif
	#ifdef CWBorderWidth
		swigIntConstant( CWBorderWidth, "CWBorderWidth" );
	#endif
	#ifdef CWSibling
		swigIntConstant( CWSibling, "CWSibling" );
	#endif
	#ifdef CWStackMode
		swigIntConstant( CWStackMode, "CWStackMode" );
	#endif
	#ifdef ForgetGravity
		swigIntConstant( ForgetGravity, "ForgetGravity" );
	#endif
	#ifdef NorthWestGravity
		swigIntConstant( NorthWestGravity, "NorthWestGravity" );
	#endif
	#ifdef NorthGravity
		swigIntConstant( NorthGravity, "NorthGravity" );
	#endif
	#ifdef NorthEastGravity
		swigIntConstant( NorthEastGravity, "NorthEastGravity" );
	#endif
	#ifdef WestGravity
		swigIntConstant( WestGravity, "WestGravity" );
	#endif
	#ifdef CenterGravity
		swigIntConstant( CenterGravity, "CenterGravity" );
	#endif
	#ifdef EastGravity
		swigIntConstant( EastGravity, "EastGravity" );
	#endif
	#ifdef SouthWestGravity
		swigIntConstant( SouthWestGravity, "SouthWestGravity" );
	#endif
	#ifdef SouthGravity
		swigIntConstant( SouthGravity, "SouthGravity" );
	#endif
	#ifdef SouthEastGravity
		swigIntConstant( SouthEastGravity, "SouthEastGravity" );
	#endif
	#ifdef StaticGravity
		swigIntConstant( StaticGravity, "StaticGravity" );
	#endif
	#ifdef UnmapGravity
		swigIntConstant( UnmapGravity, "UnmapGravity" );
	#endif
	#ifdef NotUseful
		swigIntConstant( NotUseful, "NotUseful" );
	#endif
	#ifdef WhenMapped
		swigIntConstant( WhenMapped, "WhenMapped" );
	#endif
	#ifdef Always
		swigIntConstant( Always, "Always" );
	#endif
	#ifdef IsUnmapped
		swigIntConstant( IsUnmapped, "IsUnmapped" );
	#endif
	#ifdef IsUnviewable
		swigIntConstant( IsUnviewable, "IsUnviewable" );
	#endif
	#ifdef IsViewable
		swigIntConstant( IsViewable, "IsViewable" );
	#endif
	#ifdef SetModeInsert
		swigIntConstant( SetModeInsert, "SetModeInsert" );
	#endif
	#ifdef SetModeDelete
		swigIntConstant( SetModeDelete, "SetModeDelete" );
	#endif
	#ifdef DestroyAll
		swigIntConstant( DestroyAll, "DestroyAll" );
	#endif
	#ifdef RetainPermanent
		swigIntConstant( RetainPermanent, "RetainPermanent" );
	#endif
	#ifdef RetainTemporary
		swigIntConstant( RetainTemporary, "RetainTemporary" );
	#endif
	#ifdef Above
		swigIntConstant( Above, "Above" );
	#endif
	#ifdef Below
		swigIntConstant( Below, "Below" );
	#endif
	#ifdef TopIf
		swigIntConstant( TopIf, "TopIf" );
	#endif
	#ifdef BottomIf
		swigIntConstant( BottomIf, "BottomIf" );
	#endif
	#ifdef Opposite
		swigIntConstant( Opposite, "Opposite" );
	#endif
	#ifdef RaiseLowest
		swigIntConstant( RaiseLowest, "RaiseLowest" );
	#endif
	#ifdef LowerHighest
		swigIntConstant( LowerHighest, "LowerHighest" );
	#endif
	#ifdef PropModeReplace
		swigIntConstant( PropModeReplace, "PropModeReplace" );
	#endif
	#ifdef PropModePrepend
		swigIntConstant( PropModePrepend, "PropModePrepend" );
	#endif
	#ifdef PropModeAppend
		swigIntConstant( PropModeAppend, "PropModeAppend" );
	#endif
	#ifdef GXclear
		swigIntConstant( GXclear, "GXclear" );
	#endif
	#ifdef GXand
		swigIntConstant( GXand, "GXand" );
	#endif
	#ifdef GXandReverse
		swigIntConstant( GXandReverse, "GXandReverse" );
	#endif
	#ifdef GXcopy
		swigIntConstant( GXcopy, "GXcopy" );
	#endif
	#ifdef GXandInverted
		swigIntConstant( GXandInverted, "GXandInverted" );
	#endif
	#ifdef GXnoop
		swigIntConstant( GXnoop, "GXnoop" );
	#endif
	#ifdef GXxor
		swigIntConstant( GXxor, "GXxor" );
	#endif
	#ifdef GXor
		swigIntConstant( GXor, "GXor" );
	#endif
	#ifdef GXnor
		swigIntConstant( GXnor, "GXnor" );
	#endif
	#ifdef GXequiv
		swigIntConstant( GXequiv, "GXequiv" );
	#endif
	#ifdef GXinvert
		swigIntConstant( GXinvert, "GXinvert" );
	#endif
	#ifdef GXorReverse
		swigIntConstant( GXorReverse, "GXorReverse" );
	#endif
	#ifdef GXcopyInverted
		swigIntConstant( GXcopyInverted, "GXcopyInverted" );
	#endif
	#ifdef GXorInverted
		swigIntConstant( GXorInverted, "GXorInverted" );
	#endif
	#ifdef GXnand
		swigIntConstant( GXnand, "GXnand" );
	#endif
	#ifdef GXset
		swigIntConstant( GXset, "GXset" );
	#endif
	#ifdef LineSolid
		swigIntConstant( LineSolid, "LineSolid" );
	#endif
	#ifdef LineOnOffDash
		swigIntConstant( LineOnOffDash, "LineOnOffDash" );
	#endif
	#ifdef LineDoubleDash
		swigIntConstant( LineDoubleDash, "LineDoubleDash" );
	#endif
	#ifdef CapNotLast
		swigIntConstant( CapNotLast, "CapNotLast" );
	#endif
	#ifdef CapButt
		swigIntConstant( CapButt, "CapButt" );
	#endif
	#ifdef CapRound
		swigIntConstant( CapRound, "CapRound" );
	#endif
	#ifdef CapProjecting
		swigIntConstant( CapProjecting, "CapProjecting" );
	#endif
	#ifdef JoinMiter
		swigIntConstant( JoinMiter, "JoinMiter" );
	#endif
	#ifdef JoinRound
		swigIntConstant( JoinRound, "JoinRound" );
	#endif
	#ifdef JoinBevel
		swigIntConstant( JoinBevel, "JoinBevel" );
	#endif
	#ifdef FillSolid
		swigIntConstant( FillSolid, "FillSolid" );
	#endif
	#ifdef FillTiled
		swigIntConstant( FillTiled, "FillTiled" );
	#endif
	#ifdef FillStippled
		swigIntConstant( FillStippled, "FillStippled" );
	#endif
	#ifdef FillOpaqueStippled
		swigIntConstant( FillOpaqueStippled, "FillOpaqueStippled" );
	#endif
	#ifdef EvenOddRule
		swigIntConstant( EvenOddRule, "EvenOddRule" );
	#endif
	#ifdef WindingRule
		swigIntConstant( WindingRule, "WindingRule" );
	#endif
	#ifdef ClipByChildren
		swigIntConstant( ClipByChildren, "ClipByChildren" );
	#endif
	#ifdef IncludeInferiors
		swigIntConstant( IncludeInferiors, "IncludeInferiors" );
	#endif
	#ifdef Unsorted
		swigIntConstant( Unsorted, "Unsorted" );
	#endif
	#ifdef YSorted
		swigIntConstant( YSorted, "YSorted" );
	#endif
	#ifdef YXSorted
		swigIntConstant( YXSorted, "YXSorted" );
	#endif
	#ifdef YXBanded
		swigIntConstant( YXBanded, "YXBanded" );
	#endif
	#ifdef CoordModeOrigin
		swigIntConstant( CoordModeOrigin, "CoordModeOrigin" );
	#endif
	#ifdef CoordModePrevious
		swigIntConstant( CoordModePrevious, "CoordModePrevious" );
	#endif
	#ifdef Complex
		swigIntConstant( Complex, "Complex" );
	#endif
	#ifdef Nonconvex
		swigIntConstant( Nonconvex, "Nonconvex" );
	#endif
	#ifdef Convex
		swigIntConstant( Convex, "Convex" );
	#endif
	#ifdef ArcChord
		swigIntConstant( ArcChord, "ArcChord" );
	#endif
	#ifdef ArcPieSlice
		swigIntConstant( ArcPieSlice, "ArcPieSlice" );
	#endif
	#ifdef GCFunction
		swigIntConstant( GCFunction, "GCFunction" );
	#endif
	#ifdef GCPlaneMask
		swigIntConstant( GCPlaneMask, "GCPlaneMask" );
	#endif
	#ifdef GCForeground
		swigIntConstant( GCForeground, "GCForeground" );
	#endif
	#ifdef GCBackground
		swigIntConstant( GCBackground, "GCBackground" );
	#endif
	#ifdef GCLineWidth
		swigIntConstant( GCLineWidth, "GCLineWidth" );
	#endif
	#ifdef GCLineStyle
		swigIntConstant( GCLineStyle, "GCLineStyle" );
	#endif
	#ifdef GCCapStyle
		swigIntConstant( GCCapStyle, "GCCapStyle" );
	#endif
	#ifdef GCJoinStyle
		swigIntConstant( GCJoinStyle, "GCJoinStyle" );
	#endif
	#ifdef GCFillStyle
		swigIntConstant( GCFillStyle, "GCFillStyle" );
	#endif
	#ifdef GCFillRule
		swigIntConstant( GCFillRule, "GCFillRule" );
	#endif
	#ifdef GCTile
		swigIntConstant( GCTile, "GCTile" );
	#endif
	#ifdef GCStipple
		swigIntConstant( GCStipple, "GCStipple" );
	#endif
	#ifdef GCTileStipXOrigin
		swigIntConstant( GCTileStipXOrigin, "GCTileStipXOrigin" );
	#endif
	#ifdef GCTileStipYOrigin
		swigIntConstant( GCTileStipYOrigin, "GCTileStipYOrigin" );
	#endif
	#ifdef GCFont
		swigIntConstant( GCFont, "GCFont" );
	#endif
	#ifdef GCSubwindowMode
		swigIntConstant( GCSubwindowMode, "GCSubwindowMode" );
	#endif
	#ifdef GCGraphicsExposures
		swigIntConstant( GCGraphicsExposures, "GCGraphicsExposures" );
	#endif
	#ifdef GCClipXOrigin
		swigIntConstant( GCClipXOrigin, "GCClipXOrigin" );
	#endif
	#ifdef GCClipYOrigin
		swigIntConstant( GCClipYOrigin, "GCClipYOrigin" );
	#endif
	#ifdef GCClipMask
		swigIntConstant( GCClipMask, "GCClipMask" );
	#endif
	#ifdef GCDashOffset
		swigIntConstant( GCDashOffset, "GCDashOffset" );
	#endif
	#ifdef GCDashList
		swigIntConstant( GCDashList, "GCDashList" );
	#endif
	#ifdef GCArcMode
		swigIntConstant( GCArcMode, "GCArcMode" );
	#endif
	#ifdef GCLastBit
		swigIntConstant( GCLastBit, "GCLastBit" );
	#endif
	#ifdef FontLeftToRight
		swigIntConstant( FontLeftToRight, "FontLeftToRight" );
	#endif
	#ifdef FontRightToLeft
		swigIntConstant( FontRightToLeft, "FontRightToLeft" );
	#endif
	#ifdef FontChange
		swigIntConstant( FontChange, "FontChange" );
	#endif
	#ifdef XYBitmap
		swigIntConstant( XYBitmap, "XYBitmap" );
	#endif
	#ifdef XYPixmap
		swigIntConstant( XYPixmap, "XYPixmap" );
	#endif
	#ifdef ZPixmap
		swigIntConstant( ZPixmap, "ZPixmap" );
	#endif
	#ifdef AllocNone
		swigIntConstant( AllocNone, "AllocNone" );
	#endif
	#ifdef AllocAll
		swigIntConstant( AllocAll, "AllocAll" );
	#endif
	#ifdef DoRed
		swigIntConstant( DoRed, "DoRed" );
	#endif
	#ifdef DoGreen
		swigIntConstant( DoGreen, "DoGreen" );
	#endif
	#ifdef DoBlue
		swigIntConstant( DoBlue, "DoBlue" );
	#endif
	#ifdef CursorShape
		swigIntConstant( CursorShape, "CursorShape" );
	#endif
	#ifdef TileShape
		swigIntConstant( TileShape, "TileShape" );
	#endif
	#ifdef StippleShape
		swigIntConstant( StippleShape, "StippleShape" );
	#endif
	#ifdef AutoRepeatModeOff
		swigIntConstant( AutoRepeatModeOff, "AutoRepeatModeOff" );
	#endif
	#ifdef AutoRepeatModeOn
		swigIntConstant( AutoRepeatModeOn, "AutoRepeatModeOn" );
	#endif
	#ifdef AutoRepeatModeDefault
		swigIntConstant( AutoRepeatModeDefault, "AutoRepeatModeDefault" );
	#endif
	#ifdef LedModeOff
		swigIntConstant( LedModeOff, "LedModeOff" );
	#endif
	#ifdef LedModeOn
		swigIntConstant( LedModeOn, "LedModeOn" );
	#endif
	#ifdef KBKeyClickPercent
		swigIntConstant( KBKeyClickPercent, "KBKeyClickPercent" );
	#endif
	#ifdef KBBellPercent
		swigIntConstant( KBBellPercent, "KBBellPercent" );
	#endif
	#ifdef KBBellPitch
		swigIntConstant( KBBellPitch, "KBBellPitch" );
	#endif
	#ifdef KBBellDuration
		swigIntConstant( KBBellDuration, "KBBellDuration" );
	#endif
	#ifdef KBLed
		swigIntConstant( KBLed, "KBLed" );
	#endif
	#ifdef KBLedMode
		swigIntConstant( KBLedMode, "KBLedMode" );
	#endif
	#ifdef KBKey
		swigIntConstant( KBKey, "KBKey" );
	#endif
	#ifdef KBAutoRepeatMode
		swigIntConstant( KBAutoRepeatMode, "KBAutoRepeatMode" );
	#endif
	#ifdef MappingSuccess
		swigIntConstant( MappingSuccess, "MappingSuccess" );
	#endif
	#ifdef MappingBusy
		swigIntConstant( MappingBusy, "MappingBusy" );
	#endif
	#ifdef MappingFailed
		swigIntConstant( MappingFailed, "MappingFailed" );
	#endif
	#ifdef MappingModifier
		swigIntConstant( MappingModifier, "MappingModifier" );
	#endif
	#ifdef MappingKeyboard
		swigIntConstant( MappingKeyboard, "MappingKeyboard" );
	#endif
	#ifdef MappingPointer
		swigIntConstant( MappingPointer, "MappingPointer" );
	#endif
	#ifdef DontPreferBlanking
		swigIntConstant( DontPreferBlanking, "DontPreferBlanking" );
	#endif
	#ifdef PreferBlanking
		swigIntConstant( PreferBlanking, "PreferBlanking" );
	#endif
	#ifdef DefaultBlanking
		swigIntConstant( DefaultBlanking, "DefaultBlanking" );
	#endif
	#ifdef DisableScreenSaver
		swigIntConstant( DisableScreenSaver, "DisableScreenSaver" );
	#endif
	#ifdef DisableScreenInterval
		swigIntConstant( DisableScreenInterval, "DisableScreenInterval" );
	#endif
	#ifdef DontAllowExposures
		swigIntConstant( DontAllowExposures, "DontAllowExposures" );
	#endif
	#ifdef AllowExposures
		swigIntConstant( AllowExposures, "AllowExposures" );
	#endif
	#ifdef DefaultExposures
		swigIntConstant( DefaultExposures, "DefaultExposures" );
	#endif
	#ifdef ScreenSaverReset
		swigIntConstant( ScreenSaverReset, "ScreenSaverReset" );
	#endif
	#ifdef ScreenSaverActive
		swigIntConstant( ScreenSaverActive, "ScreenSaverActive" );
	#endif
	#ifdef HostInsert
		swigIntConstant( HostInsert, "HostInsert" );
	#endif
	#ifdef HostDelete
		swigIntConstant( HostDelete, "HostDelete" );
	#endif
	#ifdef EnableAccess
		swigIntConstant( EnableAccess, "EnableAccess" );
	#endif
	#ifdef DisableAccess
		swigIntConstant( DisableAccess, "DisableAccess" );
	#endif
	#ifdef StaticGray
		swigIntConstant( StaticGray, "StaticGray" );
	#endif
	#ifdef GrayScale
		swigIntConstant( GrayScale, "GrayScale" );
	#endif
	#ifdef StaticColor
		swigIntConstant( StaticColor, "StaticColor" );
	#endif
	#ifdef PseudoColor
		swigIntConstant( PseudoColor, "PseudoColor" );
	#endif
	#ifdef TrueColor
		swigIntConstant( TrueColor, "TrueColor" );
	#endif
	#ifdef DirectColor
		swigIntConstant( DirectColor, "DirectColor" );
	#endif
	#ifdef LSBFirst
		swigIntConstant( LSBFirst, "LSBFirst" );
	#endif
	#ifdef MSBFirst
		swigIntConstant( MSBFirst, "MSBFirst" );
	#endif
	#ifdef XlibSpecificationRelease
		swigIntConstant( XlibSpecificationRelease, "XlibSpecificationRelease" );
	#endif
	#ifdef X_HAVE_UTF8_STRING
		swigIntConstant( X_HAVE_UTF8_STRING, "X_HAVE_UTF8_STRING" );
	#endif
	#ifdef True
		swigIntConstant( True, "True" );
	#endif
	#ifdef False
		swigIntConstant( False, "False" );
	#endif
	#ifdef QueuedAlready
		swigIntConstant( QueuedAlready, "QueuedAlready" );
	#endif
	#ifdef QueuedAfterReading
		swigIntConstant( QueuedAfterReading, "QueuedAfterReading" );
	#endif
	#ifdef QueuedAfterFlush
		swigIntConstant( QueuedAfterFlush, "QueuedAfterFlush" );
	#endif
	#ifdef XIMPreeditArea
		swigIntConstant( XIMPreeditArea, "XIMPreeditArea" );
	#endif
	#ifdef XIMPreeditCallbacks
		swigIntConstant( XIMPreeditCallbacks, "XIMPreeditCallbacks" );
	#endif
	#ifdef XIMPreeditPosition
		swigIntConstant( XIMPreeditPosition, "XIMPreeditPosition" );
	#endif
	#ifdef XIMPreeditNothing
		swigIntConstant( XIMPreeditNothing, "XIMPreeditNothing" );
	#endif
	#ifdef XIMPreeditNone
		swigIntConstant( XIMPreeditNone, "XIMPreeditNone" );
	#endif
	#ifdef XIMStatusArea
		swigIntConstant( XIMStatusArea, "XIMStatusArea" );
	#endif
	#ifdef XIMStatusCallbacks
		swigIntConstant( XIMStatusCallbacks, "XIMStatusCallbacks" );
	#endif
	#ifdef XIMStatusNothing
		swigIntConstant( XIMStatusNothing, "XIMStatusNothing" );
	#endif
	#ifdef XIMStatusNone
		swigIntConstant( XIMStatusNone, "XIMStatusNone" );
	#endif
	#ifdef XBufferOverflow
		swigIntConstant( XBufferOverflow, "XBufferOverflow" );
	#endif
	#ifdef XLookupNone
		swigIntConstant( XLookupNone, "XLookupNone" );
	#endif
	#ifdef XLookupChars
		swigIntConstant( XLookupChars, "XLookupChars" );
	#endif
	#ifdef XLookupKeySym
		swigIntConstant( XLookupKeySym, "XLookupKeySym" );
	#endif
	#ifdef XLookupBoth
		swigIntConstant( XLookupBoth, "XLookupBoth" );
	#endif
	#ifdef XIMReverse
		swigIntConstant( XIMReverse, "XIMReverse" );
	#endif
	#ifdef XIMUnderline
		swigIntConstant( XIMUnderline, "XIMUnderline" );
	#endif
	#ifdef XIMHighlight
		swigIntConstant( XIMHighlight, "XIMHighlight" );
	#endif
	#ifdef XIMPrimary
		swigIntConstant( XIMPrimary, "XIMPrimary" );
	#endif
	#ifdef XIMSecondary
		swigIntConstant( XIMSecondary, "XIMSecondary" );
	#endif
	#ifdef XIMTertiary
		swigIntConstant( XIMTertiary, "XIMTertiary" );
	#endif
	#ifdef XIMVisibleToForward
		swigIntConstant( XIMVisibleToForward, "XIMVisibleToForward" );
	#endif
	#ifdef XIMVisibleToBackword
		swigIntConstant( XIMVisibleToBackword, "XIMVisibleToBackword" );
	#endif
	#ifdef XIMVisibleToCenter
		swigIntConstant( XIMVisibleToCenter, "XIMVisibleToCenter" );
	#endif
	#ifdef XIMPreeditUnKnown
		swigIntConstant( XIMPreeditUnKnown, "XIMPreeditUnKnown" );
	#endif
	#ifdef XIMPreeditEnable
		swigIntConstant( XIMPreeditEnable, "XIMPreeditEnable" );
	#endif
	#ifdef XIMPreeditDisable
		swigIntConstant( XIMPreeditDisable, "XIMPreeditDisable" );
	#endif
	#ifdef XIMInitialState
		swigIntConstant( XIMInitialState, "XIMInitialState" );
	#endif
	#ifdef XIMPreserveState
		swigIntConstant( XIMPreserveState, "XIMPreserveState" );
	#endif
	#ifdef XIMStringConversionLeftEdge
		swigIntConstant( XIMStringConversionLeftEdge, "XIMStringConversionLeftEdge" );
	#endif
	#ifdef XIMStringConversionRightEdge
		swigIntConstant( XIMStringConversionRightEdge, "XIMStringConversionRightEdge" );
	#endif
	#ifdef XIMStringConversionTopEdge
		swigIntConstant( XIMStringConversionTopEdge, "XIMStringConversionTopEdge" );
	#endif
	#ifdef XIMStringConversionBottomEdge
		swigIntConstant( XIMStringConversionBottomEdge, "XIMStringConversionBottomEdge" );
	#endif
	#ifdef XIMStringConversionConcealed
		swigIntConstant( XIMStringConversionConcealed, "XIMStringConversionConcealed" );
	#endif
	#ifdef XIMStringConversionWrapped
		swigIntConstant( XIMStringConversionWrapped, "XIMStringConversionWrapped" );
	#endif
	#ifdef XIMStringConversionBuffer
		swigIntConstant( XIMStringConversionBuffer, "XIMStringConversionBuffer" );
	#endif
	#ifdef XIMStringConversionLine
		swigIntConstant( XIMStringConversionLine, "XIMStringConversionLine" );
	#endif
	#ifdef XIMStringConversionWord
		swigIntConstant( XIMStringConversionWord, "XIMStringConversionWord" );
	#endif
	#ifdef XIMStringConversionChar
		swigIntConstant( XIMStringConversionChar, "XIMStringConversionChar" );
	#endif
	#ifdef XIMStringConversionSubstitution
		swigIntConstant( XIMStringConversionSubstitution, "XIMStringConversionSubstitution" );
	#endif
	#ifdef XIMStringConversionRetrieval
		swigIntConstant( XIMStringConversionRetrieval, "XIMStringConversionRetrieval" );
	#endif
	#ifdef XIMHotKeyStateON
		swigIntConstant( XIMHotKeyStateON, "XIMHotKeyStateON" );
	#endif
	#ifdef XIMHotKeyStateOFF
		swigIntConstant( XIMHotKeyStateOFF, "XIMHotKeyStateOFF" );
	#endif
	#ifdef NoValue
		swigIntConstant( NoValue, "NoValue" );
	#endif
	#ifdef XValue
		swigIntConstant( XValue, "XValue" );
	#endif
	#ifdef YValue
		swigIntConstant( YValue, "YValue" );
	#endif
	#ifdef WidthValue
		swigIntConstant( WidthValue, "WidthValue" );
	#endif
	#ifdef HeightValue
		swigIntConstant( HeightValue, "HeightValue" );
	#endif
	#ifdef AllValues
		swigIntConstant( AllValues, "AllValues" );
	#endif
	#ifdef XNegative
		swigIntConstant( XNegative, "XNegative" );
	#endif
	#ifdef YNegative
		swigIntConstant( YNegative, "YNegative" );
	#endif
	#ifdef USPosition
		swigIntConstant( USPosition, "USPosition" );
	#endif
	#ifdef USSize
		swigIntConstant( USSize, "USSize" );
	#endif
	#ifdef PPosition
		swigIntConstant( PPosition, "PPosition" );
	#endif
	#ifdef PSize
		swigIntConstant( PSize, "PSize" );
	#endif
	#ifdef PMinSize
		swigIntConstant( PMinSize, "PMinSize" );
	#endif
	#ifdef PMaxSize
		swigIntConstant( PMaxSize, "PMaxSize" );
	#endif
	#ifdef PResizeInc
		swigIntConstant( PResizeInc, "PResizeInc" );
	#endif
	#ifdef PAspect
		swigIntConstant( PAspect, "PAspect" );
	#endif
	#ifdef PBaseSize
		swigIntConstant( PBaseSize, "PBaseSize" );
	#endif
	#ifdef PWinGravity
		swigIntConstant( PWinGravity, "PWinGravity" );
	#endif
	#ifdef PAllHints
		swigIntConstant( PAllHints, "PAllHints" );
	#endif
	#ifdef InputHint
		swigIntConstant( InputHint, "InputHint" );
	#endif
	#ifdef StateHint
		swigIntConstant( StateHint, "StateHint" );
	#endif
	#ifdef IconPixmapHint
		swigIntConstant( IconPixmapHint, "IconPixmapHint" );
	#endif
	#ifdef IconWindowHint
		swigIntConstant( IconWindowHint, "IconWindowHint" );
	#endif
	#ifdef IconPositionHint
		swigIntConstant( IconPositionHint, "IconPositionHint" );
	#endif
	#ifdef IconMaskHint
		swigIntConstant( IconMaskHint, "IconMaskHint" );
	#endif
	#ifdef WindowGroupHint
		swigIntConstant( WindowGroupHint, "WindowGroupHint" );
	#endif
	#ifdef AllHints
		swigIntConstant( AllHints, "AllHints" );
	#endif
	#ifdef XUrgencyHint
		swigIntConstant( XUrgencyHint, "XUrgencyHint" );
	#endif
	#ifdef WithdrawnState
		swigIntConstant( WithdrawnState, "WithdrawnState" );
	#endif
	#ifdef NormalState
		swigIntConstant( NormalState, "NormalState" );
	#endif
	#ifdef IconicState
		swigIntConstant( IconicState, "IconicState" );
	#endif
	#ifdef DontCareState
		swigIntConstant( DontCareState, "DontCareState" );
	#endif
	#ifdef ZoomState
		swigIntConstant( ZoomState, "ZoomState" );
	#endif
	#ifdef InactiveState
		swigIntConstant( InactiveState, "InactiveState" );
	#endif
	#ifdef XNoMemory
		swigIntConstant( XNoMemory, "XNoMemory" );
	#endif
	#ifdef XLocaleNotSupported
		swigIntConstant( XLocaleNotSupported, "XLocaleNotSupported" );
	#endif
	#ifdef XConverterNotFound
		swigIntConstant( XConverterNotFound, "XConverterNotFound" );
	#endif
	#ifdef RectangleOut
		swigIntConstant( RectangleOut, "RectangleOut" );
	#endif
	#ifdef RectangleIn
		swigIntConstant( RectangleIn, "RectangleIn" );
	#endif
	#ifdef RectanglePart
		swigIntConstant( RectanglePart, "RectanglePart" );
	#endif
	#ifdef VisualNoMask
		swigIntConstant( VisualNoMask, "VisualNoMask" );
	#endif
	#ifdef VisualIDMask
		swigIntConstant( VisualIDMask, "VisualIDMask" );
	#endif
	#ifdef VisualScreenMask
		swigIntConstant( VisualScreenMask, "VisualScreenMask" );
	#endif
	#ifdef VisualDepthMask
		swigIntConstant( VisualDepthMask, "VisualDepthMask" );
	#endif
	#ifdef VisualClassMask
		swigIntConstant( VisualClassMask, "VisualClassMask" );
	#endif
	#ifdef VisualRedMaskMask
		swigIntConstant( VisualRedMaskMask, "VisualRedMaskMask" );
	#endif
	#ifdef VisualGreenMaskMask
		swigIntConstant( VisualGreenMaskMask, "VisualGreenMaskMask" );
	#endif
	#ifdef VisualBlueMaskMask
		swigIntConstant( VisualBlueMaskMask, "VisualBlueMaskMask" );
	#endif
	#ifdef VisualColormapSizeMask
		swigIntConstant( VisualColormapSizeMask, "VisualColormapSizeMask" );
	#endif
	#ifdef VisualBitsPerRGBMask
		swigIntConstant( VisualBitsPerRGBMask, "VisualBitsPerRGBMask" );
	#endif
	#ifdef VisualAllMask
		swigIntConstant( VisualAllMask, "VisualAllMask" );
	#endif
	#ifdef BitmapSuccess
		swigIntConstant( BitmapSuccess, "BitmapSuccess" );
	#endif
	#ifdef BitmapOpenFailed
		swigIntConstant( BitmapOpenFailed, "BitmapOpenFailed" );
	#endif
	#ifdef BitmapFileInvalid
		swigIntConstant( BitmapFileInvalid, "BitmapFileInvalid" );
	#endif
	#ifdef BitmapNoMemory
		swigIntConstant( BitmapNoMemory, "BitmapNoMemory" );
	#endif
	#ifdef XCSUCCESS
		swigIntConstant( XCSUCCESS, "XCSUCCESS" );
	#endif
	#ifdef XCNOMEM
		swigIntConstant( XCNOMEM, "XCNOMEM" );
	#endif
	#ifdef XCNOENT
		swigIntConstant( XCNOENT, "XCNOENT" );
	#endif
	#ifdef XK_VoidSymbol
		swigIntConstant( XK_VoidSymbol, "XK_VoidSymbol" );
	#endif
	#ifdef XK_BackSpace
		swigIntConstant( XK_BackSpace, "XK_BackSpace" );
	#endif
	#ifdef XK_Tab
		swigIntConstant( XK_Tab, "XK_Tab" );
	#endif
	#ifdef XK_Linefeed
		swigIntConstant( XK_Linefeed, "XK_Linefeed" );
	#endif
	#ifdef XK_Clear
		swigIntConstant( XK_Clear, "XK_Clear" );
	#endif
	#ifdef XK_Return
		swigIntConstant( XK_Return, "XK_Return" );
	#endif
	#ifdef XK_Pause
		swigIntConstant( XK_Pause, "XK_Pause" );
	#endif
	#ifdef XK_Scroll_Lock
		swigIntConstant( XK_Scroll_Lock, "XK_Scroll_Lock" );
	#endif
	#ifdef XK_Sys_Req
		swigIntConstant( XK_Sys_Req, "XK_Sys_Req" );
	#endif
	#ifdef XK_Escape
		swigIntConstant( XK_Escape, "XK_Escape" );
	#endif
	#ifdef XK_Delete
		swigIntConstant( XK_Delete, "XK_Delete" );
	#endif
	#ifdef XK_Multi_key
		swigIntConstant( XK_Multi_key, "XK_Multi_key" );
	#endif
	#ifdef XK_Codeinput
		swigIntConstant( XK_Codeinput, "XK_Codeinput" );
	#endif
	#ifdef XK_SingleCandidate
		swigIntConstant( XK_SingleCandidate, "XK_SingleCandidate" );
	#endif
	#ifdef XK_MultipleCandidate
		swigIntConstant( XK_MultipleCandidate, "XK_MultipleCandidate" );
	#endif
	#ifdef XK_PreviousCandidate
		swigIntConstant( XK_PreviousCandidate, "XK_PreviousCandidate" );
	#endif
	#ifdef XK_Kanji
		swigIntConstant( XK_Kanji, "XK_Kanji" );
	#endif
	#ifdef XK_Muhenkan
		swigIntConstant( XK_Muhenkan, "XK_Muhenkan" );
	#endif
	#ifdef XK_Henkan_Mode
		swigIntConstant( XK_Henkan_Mode, "XK_Henkan_Mode" );
	#endif
	#ifdef XK_Henkan
		swigIntConstant( XK_Henkan, "XK_Henkan" );
	#endif
	#ifdef XK_Romaji
		swigIntConstant( XK_Romaji, "XK_Romaji" );
	#endif
	#ifdef XK_Hiragana
		swigIntConstant( XK_Hiragana, "XK_Hiragana" );
	#endif
	#ifdef XK_Katakana
		swigIntConstant( XK_Katakana, "XK_Katakana" );
	#endif
	#ifdef XK_Hiragana_Katakana
		swigIntConstant( XK_Hiragana_Katakana, "XK_Hiragana_Katakana" );
	#endif
	#ifdef XK_Zenkaku
		swigIntConstant( XK_Zenkaku, "XK_Zenkaku" );
	#endif
	#ifdef XK_Hankaku
		swigIntConstant( XK_Hankaku, "XK_Hankaku" );
	#endif
	#ifdef XK_Zenkaku_Hankaku
		swigIntConstant( XK_Zenkaku_Hankaku, "XK_Zenkaku_Hankaku" );
	#endif
	#ifdef XK_Touroku
		swigIntConstant( XK_Touroku, "XK_Touroku" );
	#endif
	#ifdef XK_Massyo
		swigIntConstant( XK_Massyo, "XK_Massyo" );
	#endif
	#ifdef XK_Kana_Lock
		swigIntConstant( XK_Kana_Lock, "XK_Kana_Lock" );
	#endif
	#ifdef XK_Kana_Shift
		swigIntConstant( XK_Kana_Shift, "XK_Kana_Shift" );
	#endif
	#ifdef XK_Eisu_Shift
		swigIntConstant( XK_Eisu_Shift, "XK_Eisu_Shift" );
	#endif
	#ifdef XK_Eisu_toggle
		swigIntConstant( XK_Eisu_toggle, "XK_Eisu_toggle" );
	#endif
	#ifdef XK_Kanji_Bangou
		swigIntConstant( XK_Kanji_Bangou, "XK_Kanji_Bangou" );
	#endif
	#ifdef XK_Zen_Koho
		swigIntConstant( XK_Zen_Koho, "XK_Zen_Koho" );
	#endif
	#ifdef XK_Mae_Koho
		swigIntConstant( XK_Mae_Koho, "XK_Mae_Koho" );
	#endif
	#ifdef XK_Home
		swigIntConstant( XK_Home, "XK_Home" );
	#endif
	#ifdef XK_Left
		swigIntConstant( XK_Left, "XK_Left" );
	#endif
	#ifdef XK_Up
		swigIntConstant( XK_Up, "XK_Up" );
	#endif
	#ifdef XK_Right
		swigIntConstant( XK_Right, "XK_Right" );
	#endif
	#ifdef XK_Down
		swigIntConstant( XK_Down, "XK_Down" );
	#endif
	#ifdef XK_Prior
		swigIntConstant( XK_Prior, "XK_Prior" );
	#endif
	#ifdef XK_Page_Up
		swigIntConstant( XK_Page_Up, "XK_Page_Up" );
	#endif
	#ifdef XK_Next
		swigIntConstant( XK_Next, "XK_Next" );
	#endif
	#ifdef XK_Page_Down
		swigIntConstant( XK_Page_Down, "XK_Page_Down" );
	#endif
	#ifdef XK_End
		swigIntConstant( XK_End, "XK_End" );
	#endif
	#ifdef XK_Begin
		swigIntConstant( XK_Begin, "XK_Begin" );
	#endif
	#ifdef XK_Select
		swigIntConstant( XK_Select, "XK_Select" );
	#endif
	#ifdef XK_Print
		swigIntConstant( XK_Print, "XK_Print" );
	#endif
	#ifdef XK_Execute
		swigIntConstant( XK_Execute, "XK_Execute" );
	#endif
	#ifdef XK_Insert
		swigIntConstant( XK_Insert, "XK_Insert" );
	#endif
	#ifdef XK_Undo
		swigIntConstant( XK_Undo, "XK_Undo" );
	#endif
	#ifdef XK_Redo
		swigIntConstant( XK_Redo, "XK_Redo" );
	#endif
	#ifdef XK_Menu
		swigIntConstant( XK_Menu, "XK_Menu" );
	#endif
	#ifdef XK_Find
		swigIntConstant( XK_Find, "XK_Find" );
	#endif
	#ifdef XK_Cancel
		swigIntConstant( XK_Cancel, "XK_Cancel" );
	#endif
	#ifdef XK_Help
		swigIntConstant( XK_Help, "XK_Help" );
	#endif
	#ifdef XK_Break
		swigIntConstant( XK_Break, "XK_Break" );
	#endif
	#ifdef XK_Mode_switch
		swigIntConstant( XK_Mode_switch, "XK_Mode_switch" );
	#endif
	#ifdef XK_script_switch
		swigIntConstant( XK_script_switch, "XK_script_switch" );
	#endif
	#ifdef XK_Num_Lock
		swigIntConstant( XK_Num_Lock, "XK_Num_Lock" );
	#endif
	#ifdef XK_KP_Space
		swigIntConstant( XK_KP_Space, "XK_KP_Space" );
	#endif
	#ifdef XK_KP_Tab
		swigIntConstant( XK_KP_Tab, "XK_KP_Tab" );
	#endif
	#ifdef XK_KP_Enter
		swigIntConstant( XK_KP_Enter, "XK_KP_Enter" );
	#endif
	#ifdef XK_KP_F1
		swigIntConstant( XK_KP_F1, "XK_KP_F1" );
	#endif
	#ifdef XK_KP_F2
		swigIntConstant( XK_KP_F2, "XK_KP_F2" );
	#endif
	#ifdef XK_KP_F3
		swigIntConstant( XK_KP_F3, "XK_KP_F3" );
	#endif
	#ifdef XK_KP_F4
		swigIntConstant( XK_KP_F4, "XK_KP_F4" );
	#endif
	#ifdef XK_KP_Home
		swigIntConstant( XK_KP_Home, "XK_KP_Home" );
	#endif
	#ifdef XK_KP_Left
		swigIntConstant( XK_KP_Left, "XK_KP_Left" );
	#endif
	#ifdef XK_KP_Up
		swigIntConstant( XK_KP_Up, "XK_KP_Up" );
	#endif
	#ifdef XK_KP_Right
		swigIntConstant( XK_KP_Right, "XK_KP_Right" );
	#endif
	#ifdef XK_KP_Down
		swigIntConstant( XK_KP_Down, "XK_KP_Down" );
	#endif
	#ifdef XK_KP_Prior
		swigIntConstant( XK_KP_Prior, "XK_KP_Prior" );
	#endif
	#ifdef XK_KP_Page_Up
		swigIntConstant( XK_KP_Page_Up, "XK_KP_Page_Up" );
	#endif
	#ifdef XK_KP_Next
		swigIntConstant( XK_KP_Next, "XK_KP_Next" );
	#endif
	#ifdef XK_KP_Page_Down
		swigIntConstant( XK_KP_Page_Down, "XK_KP_Page_Down" );
	#endif
	#ifdef XK_KP_End
		swigIntConstant( XK_KP_End, "XK_KP_End" );
	#endif
	#ifdef XK_KP_Begin
		swigIntConstant( XK_KP_Begin, "XK_KP_Begin" );
	#endif
	#ifdef XK_KP_Insert
		swigIntConstant( XK_KP_Insert, "XK_KP_Insert" );
	#endif
	#ifdef XK_KP_Delete
		swigIntConstant( XK_KP_Delete, "XK_KP_Delete" );
	#endif
	#ifdef XK_KP_Equal
		swigIntConstant( XK_KP_Equal, "XK_KP_Equal" );
	#endif
	#ifdef XK_KP_Multiply
		swigIntConstant( XK_KP_Multiply, "XK_KP_Multiply" );
	#endif
	#ifdef XK_KP_Add
		swigIntConstant( XK_KP_Add, "XK_KP_Add" );
	#endif
	#ifdef XK_KP_Separator
		swigIntConstant( XK_KP_Separator, "XK_KP_Separator" );
	#endif
	#ifdef XK_KP_Subtract
		swigIntConstant( XK_KP_Subtract, "XK_KP_Subtract" );
	#endif
	#ifdef XK_KP_Decimal
		swigIntConstant( XK_KP_Decimal, "XK_KP_Decimal" );
	#endif
	#ifdef XK_KP_Divide
		swigIntConstant( XK_KP_Divide, "XK_KP_Divide" );
	#endif
	#ifdef XK_KP_0
		swigIntConstant( XK_KP_0, "XK_KP_0" );
	#endif
	#ifdef XK_KP_1
		swigIntConstant( XK_KP_1, "XK_KP_1" );
	#endif
	#ifdef XK_KP_2
		swigIntConstant( XK_KP_2, "XK_KP_2" );
	#endif
	#ifdef XK_KP_3
		swigIntConstant( XK_KP_3, "XK_KP_3" );
	#endif
	#ifdef XK_KP_4
		swigIntConstant( XK_KP_4, "XK_KP_4" );
	#endif
	#ifdef XK_KP_5
		swigIntConstant( XK_KP_5, "XK_KP_5" );
	#endif
	#ifdef XK_KP_6
		swigIntConstant( XK_KP_6, "XK_KP_6" );
	#endif
	#ifdef XK_KP_7
		swigIntConstant( XK_KP_7, "XK_KP_7" );
	#endif
	#ifdef XK_KP_8
		swigIntConstant( XK_KP_8, "XK_KP_8" );
	#endif
	#ifdef XK_KP_9
		swigIntConstant( XK_KP_9, "XK_KP_9" );
	#endif
	#ifdef XK_F1
		swigIntConstant( XK_F1, "XK_F1" );
	#endif
	#ifdef XK_F2
		swigIntConstant( XK_F2, "XK_F2" );
	#endif
	#ifdef XK_F3
		swigIntConstant( XK_F3, "XK_F3" );
	#endif
	#ifdef XK_F4
		swigIntConstant( XK_F4, "XK_F4" );
	#endif
	#ifdef XK_F5
		swigIntConstant( XK_F5, "XK_F5" );
	#endif
	#ifdef XK_F6
		swigIntConstant( XK_F6, "XK_F6" );
	#endif
	#ifdef XK_F7
		swigIntConstant( XK_F7, "XK_F7" );
	#endif
	#ifdef XK_F8
		swigIntConstant( XK_F8, "XK_F8" );
	#endif
	#ifdef XK_F9
		swigIntConstant( XK_F9, "XK_F9" );
	#endif
	#ifdef XK_F10
		swigIntConstant( XK_F10, "XK_F10" );
	#endif
	#ifdef XK_F11
		swigIntConstant( XK_F11, "XK_F11" );
	#endif
	#ifdef XK_L1
		swigIntConstant( XK_L1, "XK_L1" );
	#endif
	#ifdef XK_F12
		swigIntConstant( XK_F12, "XK_F12" );
	#endif
	#ifdef XK_L2
		swigIntConstant( XK_L2, "XK_L2" );
	#endif
	#ifdef XK_F13
		swigIntConstant( XK_F13, "XK_F13" );
	#endif
	#ifdef XK_L3
		swigIntConstant( XK_L3, "XK_L3" );
	#endif
	#ifdef XK_F14
		swigIntConstant( XK_F14, "XK_F14" );
	#endif
	#ifdef XK_L4
		swigIntConstant( XK_L4, "XK_L4" );
	#endif
	#ifdef XK_F15
		swigIntConstant( XK_F15, "XK_F15" );
	#endif
	#ifdef XK_L5
		swigIntConstant( XK_L5, "XK_L5" );
	#endif
	#ifdef XK_F16
		swigIntConstant( XK_F16, "XK_F16" );
	#endif
	#ifdef XK_L6
		swigIntConstant( XK_L6, "XK_L6" );
	#endif
	#ifdef XK_F17
		swigIntConstant( XK_F17, "XK_F17" );
	#endif
	#ifdef XK_L7
		swigIntConstant( XK_L7, "XK_L7" );
	#endif
	#ifdef XK_F18
		swigIntConstant( XK_F18, "XK_F18" );
	#endif
	#ifdef XK_L8
		swigIntConstant( XK_L8, "XK_L8" );
	#endif
	#ifdef XK_F19
		swigIntConstant( XK_F19, "XK_F19" );
	#endif
	#ifdef XK_L9
		swigIntConstant( XK_L9, "XK_L9" );
	#endif
	#ifdef XK_F20
		swigIntConstant( XK_F20, "XK_F20" );
	#endif
	#ifdef XK_L10
		swigIntConstant( XK_L10, "XK_L10" );
	#endif
	#ifdef XK_F21
		swigIntConstant( XK_F21, "XK_F21" );
	#endif
	#ifdef XK_R1
		swigIntConstant( XK_R1, "XK_R1" );
	#endif
	#ifdef XK_F22
		swigIntConstant( XK_F22, "XK_F22" );
	#endif
	#ifdef XK_R2
		swigIntConstant( XK_R2, "XK_R2" );
	#endif
	#ifdef XK_F23
		swigIntConstant( XK_F23, "XK_F23" );
	#endif
	#ifdef XK_R3
		swigIntConstant( XK_R3, "XK_R3" );
	#endif
	#ifdef XK_F24
		swigIntConstant( XK_F24, "XK_F24" );
	#endif
	#ifdef XK_R4
		swigIntConstant( XK_R4, "XK_R4" );
	#endif
	#ifdef XK_F25
		swigIntConstant( XK_F25, "XK_F25" );
	#endif
	#ifdef XK_R5
		swigIntConstant( XK_R5, "XK_R5" );
	#endif
	#ifdef XK_F26
		swigIntConstant( XK_F26, "XK_F26" );
	#endif
	#ifdef XK_R6
		swigIntConstant( XK_R6, "XK_R6" );
	#endif
	#ifdef XK_F27
		swigIntConstant( XK_F27, "XK_F27" );
	#endif
	#ifdef XK_R7
		swigIntConstant( XK_R7, "XK_R7" );
	#endif
	#ifdef XK_F28
		swigIntConstant( XK_F28, "XK_F28" );
	#endif
	#ifdef XK_R8
		swigIntConstant( XK_R8, "XK_R8" );
	#endif
	#ifdef XK_F29
		swigIntConstant( XK_F29, "XK_F29" );
	#endif
	#ifdef XK_R9
		swigIntConstant( XK_R9, "XK_R9" );
	#endif
	#ifdef XK_F30
		swigIntConstant( XK_F30, "XK_F30" );
	#endif
	#ifdef XK_R10
		swigIntConstant( XK_R10, "XK_R10" );
	#endif
	#ifdef XK_F31
		swigIntConstant( XK_F31, "XK_F31" );
	#endif
	#ifdef XK_R11
		swigIntConstant( XK_R11, "XK_R11" );
	#endif
	#ifdef XK_F32
		swigIntConstant( XK_F32, "XK_F32" );
	#endif
	#ifdef XK_R12
		swigIntConstant( XK_R12, "XK_R12" );
	#endif
	#ifdef XK_F33
		swigIntConstant( XK_F33, "XK_F33" );
	#endif
	#ifdef XK_R13
		swigIntConstant( XK_R13, "XK_R13" );
	#endif
	#ifdef XK_F34
		swigIntConstant( XK_F34, "XK_F34" );
	#endif
	#ifdef XK_R14
		swigIntConstant( XK_R14, "XK_R14" );
	#endif
	#ifdef XK_F35
		swigIntConstant( XK_F35, "XK_F35" );
	#endif
	#ifdef XK_R15
		swigIntConstant( XK_R15, "XK_R15" );
	#endif
	#ifdef XK_Shift_L
		swigIntConstant( XK_Shift_L, "XK_Shift_L" );
	#endif
	#ifdef XK_Shift_R
		swigIntConstant( XK_Shift_R, "XK_Shift_R" );
	#endif
	#ifdef XK_Control_L
		swigIntConstant( XK_Control_L, "XK_Control_L" );
	#endif
	#ifdef XK_Control_R
		swigIntConstant( XK_Control_R, "XK_Control_R" );
	#endif
	#ifdef XK_Caps_Lock
		swigIntConstant( XK_Caps_Lock, "XK_Caps_Lock" );
	#endif
	#ifdef XK_Shift_Lock
		swigIntConstant( XK_Shift_Lock, "XK_Shift_Lock" );
	#endif
	#ifdef XK_Meta_L
		swigIntConstant( XK_Meta_L, "XK_Meta_L" );
	#endif
	#ifdef XK_Meta_R
		swigIntConstant( XK_Meta_R, "XK_Meta_R" );
	#endif
	#ifdef XK_Alt_L
		swigIntConstant( XK_Alt_L, "XK_Alt_L" );
	#endif
	#ifdef XK_Alt_R
		swigIntConstant( XK_Alt_R, "XK_Alt_R" );
	#endif
	#ifdef XK_Super_L
		swigIntConstant( XK_Super_L, "XK_Super_L" );
	#endif
	#ifdef XK_Super_R
		swigIntConstant( XK_Super_R, "XK_Super_R" );
	#endif
	#ifdef XK_Hyper_L
		swigIntConstant( XK_Hyper_L, "XK_Hyper_L" );
	#endif
	#ifdef XK_Hyper_R
		swigIntConstant( XK_Hyper_R, "XK_Hyper_R" );
	#endif
	#ifdef XF86XK_ModeLock
		swigIntConstant( XF86XK_ModeLock, "XF86XK_ModeLock" );
	#endif
	#ifdef XF86XK_MonBrightnessUp
		swigIntConstant( XF86XK_MonBrightnessUp, "XF86XK_MonBrightnessUp" );
	#endif
	#ifdef XF86XK_MonBrightnessDown
		swigIntConstant( XF86XK_MonBrightnessDown, "XF86XK_MonBrightnessDown" );
	#endif
	#ifdef XF86XK_KbdLightOnOff
		swigIntConstant( XF86XK_KbdLightOnOff, "XF86XK_KbdLightOnOff" );
	#endif
	#ifdef XF86XK_KbdBrightnessUp
		swigIntConstant( XF86XK_KbdBrightnessUp, "XF86XK_KbdBrightnessUp" );
	#endif
	#ifdef XF86XK_KbdBrightnessDown
		swigIntConstant( XF86XK_KbdBrightnessDown, "XF86XK_KbdBrightnessDown" );
	#endif
	#ifdef XF86XK_MonBrightnessCycle
		swigIntConstant( XF86XK_MonBrightnessCycle, "XF86XK_MonBrightnessCycle" );
	#endif
	#ifdef XF86XK_Standby
		swigIntConstant( XF86XK_Standby, "XF86XK_Standby" );
	#endif
	#ifdef XF86XK_AudioLowerVolume
		swigIntConstant( XF86XK_AudioLowerVolume, "XF86XK_AudioLowerVolume" );
	#endif
	#ifdef XF86XK_AudioMute
		swigIntConstant( XF86XK_AudioMute, "XF86XK_AudioMute" );
	#endif
	#ifdef XF86XK_AudioRaiseVolume
		swigIntConstant( XF86XK_AudioRaiseVolume, "XF86XK_AudioRaiseVolume" );
	#endif
	#ifdef XF86XK_AudioPlay
		swigIntConstant( XF86XK_AudioPlay, "XF86XK_AudioPlay" );
	#endif
	#ifdef XF86XK_AudioStop
		swigIntConstant( XF86XK_AudioStop, "XF86XK_AudioStop" );
	#endif
	#ifdef XF86XK_AudioPrev
		swigIntConstant( XF86XK_AudioPrev, "XF86XK_AudioPrev" );
	#endif
	#ifdef XF86XK_AudioNext
		swigIntConstant( XF86XK_AudioNext, "XF86XK_AudioNext" );
	#endif
	#ifdef XF86XK_HomePage
		swigIntConstant( XF86XK_HomePage, "XF86XK_HomePage" );
	#endif
	#ifdef XF86XK_Mail
		swigIntConstant( XF86XK_Mail, "XF86XK_Mail" );
	#endif
	#ifdef XF86XK_Start
		swigIntConstant( XF86XK_Start, "XF86XK_Start" );
	#endif
	#ifdef XF86XK_Search
		swigIntConstant( XF86XK_Search, "XF86XK_Search" );
	#endif
	#ifdef XF86XK_AudioRecord
		swigIntConstant( XF86XK_AudioRecord, "XF86XK_AudioRecord" );
	#endif
	#ifdef XF86XK_Calculator
		swigIntConstant( XF86XK_Calculator, "XF86XK_Calculator" );
	#endif
	#ifdef XF86XK_Memo
		swigIntConstant( XF86XK_Memo, "XF86XK_Memo" );
	#endif
	#ifdef XF86XK_ToDoList
		swigIntConstant( XF86XK_ToDoList, "XF86XK_ToDoList" );
	#endif
	#ifdef XF86XK_Calendar
		swigIntConstant( XF86XK_Calendar, "XF86XK_Calendar" );
	#endif
	#ifdef XF86XK_PowerDown
		swigIntConstant( XF86XK_PowerDown, "XF86XK_PowerDown" );
	#endif
	#ifdef XF86XK_ContrastAdjust
		swigIntConstant( XF86XK_ContrastAdjust, "XF86XK_ContrastAdjust" );
	#endif
	#ifdef XF86XK_RockerUp
		swigIntConstant( XF86XK_RockerUp, "XF86XK_RockerUp" );
	#endif
	#ifdef XF86XK_RockerDown
		swigIntConstant( XF86XK_RockerDown, "XF86XK_RockerDown" );
	#endif
	#ifdef XF86XK_RockerEnter
		swigIntConstant( XF86XK_RockerEnter, "XF86XK_RockerEnter" );
	#endif
	#ifdef XF86XK_Back
		swigIntConstant( XF86XK_Back, "XF86XK_Back" );
	#endif
	#ifdef XF86XK_Forward
		swigIntConstant( XF86XK_Forward, "XF86XK_Forward" );
	#endif
	#ifdef XF86XK_Stop
		swigIntConstant( XF86XK_Stop, "XF86XK_Stop" );
	#endif
	#ifdef XF86XK_Refresh
		swigIntConstant( XF86XK_Refresh, "XF86XK_Refresh" );
	#endif
	#ifdef XF86XK_PowerOff
		swigIntConstant( XF86XK_PowerOff, "XF86XK_PowerOff" );
	#endif
	#ifdef XF86XK_WakeUp
		swigIntConstant( XF86XK_WakeUp, "XF86XK_WakeUp" );
	#endif
	#ifdef XF86XK_Eject
		swigIntConstant( XF86XK_Eject, "XF86XK_Eject" );
	#endif
	#ifdef XF86XK_ScreenSaver
		swigIntConstant( XF86XK_ScreenSaver, "XF86XK_ScreenSaver" );
	#endif
	#ifdef XF86XK_WWW
		swigIntConstant( XF86XK_WWW, "XF86XK_WWW" );
	#endif
	#ifdef XF86XK_Sleep
		swigIntConstant( XF86XK_Sleep, "XF86XK_Sleep" );
	#endif
	#ifdef XF86XK_Favorites
		swigIntConstant( XF86XK_Favorites, "XF86XK_Favorites" );
	#endif
	#ifdef XF86XK_AudioPause
		swigIntConstant( XF86XK_AudioPause, "XF86XK_AudioPause" );
	#endif
	#ifdef XF86XK_AudioMedia
		swigIntConstant( XF86XK_AudioMedia, "XF86XK_AudioMedia" );
	#endif
	#ifdef XF86XK_MyComputer
		swigIntConstant( XF86XK_MyComputer, "XF86XK_MyComputer" );
	#endif
	#ifdef XF86XK_VendorHome
		swigIntConstant( XF86XK_VendorHome, "XF86XK_VendorHome" );
	#endif
	#ifdef XF86XK_LightBulb
		swigIntConstant( XF86XK_LightBulb, "XF86XK_LightBulb" );
	#endif
	#ifdef XF86XK_Shop
		swigIntConstant( XF86XK_Shop, "XF86XK_Shop" );
	#endif
	#ifdef XF86XK_History
		swigIntConstant( XF86XK_History, "XF86XK_History" );
	#endif
	#ifdef XF86XK_OpenURL
		swigIntConstant( XF86XK_OpenURL, "XF86XK_OpenURL" );
	#endif
	#ifdef XF86XK_AddFavorite
		swigIntConstant( XF86XK_AddFavorite, "XF86XK_AddFavorite" );
	#endif
	#ifdef XF86XK_HotLinks
		swigIntConstant( XF86XK_HotLinks, "XF86XK_HotLinks" );
	#endif
	#ifdef XF86XK_BrightnessAdjust
		swigIntConstant( XF86XK_BrightnessAdjust, "XF86XK_BrightnessAdjust" );
	#endif
	#ifdef XF86XK_Finance
		swigIntConstant( XF86XK_Finance, "XF86XK_Finance" );
	#endif
	#ifdef XF86XK_Community
		swigIntConstant( XF86XK_Community, "XF86XK_Community" );
	#endif
	#ifdef XF86XK_AudioRewind
		swigIntConstant( XF86XK_AudioRewind, "XF86XK_AudioRewind" );
	#endif
	#ifdef XF86XK_BackForward
		swigIntConstant( XF86XK_BackForward, "XF86XK_BackForward" );
	#endif
	#ifdef XF86XK_Launch0
		swigIntConstant( XF86XK_Launch0, "XF86XK_Launch0" );
	#endif
	#ifdef XF86XK_Launch1
		swigIntConstant( XF86XK_Launch1, "XF86XK_Launch1" );
	#endif
	#ifdef XF86XK_Launch2
		swigIntConstant( XF86XK_Launch2, "XF86XK_Launch2" );
	#endif
	#ifdef XF86XK_Launch3
		swigIntConstant( XF86XK_Launch3, "XF86XK_Launch3" );
	#endif
	#ifdef XF86XK_Launch4
		swigIntConstant( XF86XK_Launch4, "XF86XK_Launch4" );
	#endif
	#ifdef XF86XK_Launch5
		swigIntConstant( XF86XK_Launch5, "XF86XK_Launch5" );
	#endif
	#ifdef XF86XK_Launch6
		swigIntConstant( XF86XK_Launch6, "XF86XK_Launch6" );
	#endif
	#ifdef XF86XK_Launch7
		swigIntConstant( XF86XK_Launch7, "XF86XK_Launch7" );
	#endif
	#ifdef XF86XK_Launch8
		swigIntConstant( XF86XK_Launch8, "XF86XK_Launch8" );
	#endif
	#ifdef XF86XK_Launch9
		swigIntConstant( XF86XK_Launch9, "XF86XK_Launch9" );
	#endif
	#ifdef XF86XK_LaunchA
		swigIntConstant( XF86XK_LaunchA, "XF86XK_LaunchA" );
	#endif
	#ifdef XF86XK_LaunchB
		swigIntConstant( XF86XK_LaunchB, "XF86XK_LaunchB" );
	#endif
	#ifdef XF86XK_LaunchC
		swigIntConstant( XF86XK_LaunchC, "XF86XK_LaunchC" );
	#endif
	#ifdef XF86XK_LaunchD
		swigIntConstant( XF86XK_LaunchD, "XF86XK_LaunchD" );
	#endif
	#ifdef XF86XK_LaunchE
		swigIntConstant( XF86XK_LaunchE, "XF86XK_LaunchE" );
	#endif
	#ifdef XF86XK_LaunchF
		swigIntConstant( XF86XK_LaunchF, "XF86XK_LaunchF" );
	#endif
	#ifdef XF86XK_ApplicationLeft
		swigIntConstant( XF86XK_ApplicationLeft, "XF86XK_ApplicationLeft" );
	#endif
	#ifdef XF86XK_ApplicationRight
		swigIntConstant( XF86XK_ApplicationRight, "XF86XK_ApplicationRight" );
	#endif
	#ifdef XF86XK_Book
		swigIntConstant( XF86XK_Book, "XF86XK_Book" );
	#endif
	#ifdef XF86XK_CD
		swigIntConstant( XF86XK_CD, "XF86XK_CD" );
	#endif
	#ifdef XF86XK_Calculater
		swigIntConstant( XF86XK_Calculater, "XF86XK_Calculater" );
	#endif
	#ifdef XF86XK_Clear
		swigIntConstant( XF86XK_Clear, "XF86XK_Clear" );
	#endif
	#ifdef XF86XK_Close
		swigIntConstant( XF86XK_Close, "XF86XK_Close" );
	#endif
	#ifdef XF86XK_Copy
		swigIntConstant( XF86XK_Copy, "XF86XK_Copy" );
	#endif
	#ifdef XF86XK_Cut
		swigIntConstant( XF86XK_Cut, "XF86XK_Cut" );
	#endif
	#ifdef XF86XK_Display
		swigIntConstant( XF86XK_Display, "XF86XK_Display" );
	#endif
	#ifdef XF86XK_DOS
		swigIntConstant( XF86XK_DOS, "XF86XK_DOS" );
	#endif
	#ifdef XF86XK_Documents
		swigIntConstant( XF86XK_Documents, "XF86XK_Documents" );
	#endif
	#ifdef XF86XK_Excel
		swigIntConstant( XF86XK_Excel, "XF86XK_Excel" );
	#endif
	#ifdef XF86XK_Explorer
		swigIntConstant( XF86XK_Explorer, "XF86XK_Explorer" );
	#endif
	#ifdef XF86XK_Game
		swigIntConstant( XF86XK_Game, "XF86XK_Game" );
	#endif
	#ifdef XF86XK_Go
		swigIntConstant( XF86XK_Go, "XF86XK_Go" );
	#endif
	#ifdef XF86XK_iTouch
		swigIntConstant( XF86XK_iTouch, "XF86XK_iTouch" );
	#endif
	#ifdef XF86XK_LogOff
		swigIntConstant( XF86XK_LogOff, "XF86XK_LogOff" );
	#endif
	#ifdef XF86XK_Market
		swigIntConstant( XF86XK_Market, "XF86XK_Market" );
	#endif
	#ifdef XF86XK_Meeting
		swigIntConstant( XF86XK_Meeting, "XF86XK_Meeting" );
	#endif
	#ifdef XF86XK_MenuKB
		swigIntConstant( XF86XK_MenuKB, "XF86XK_MenuKB" );
	#endif
	#ifdef XF86XK_MenuPB
		swigIntConstant( XF86XK_MenuPB, "XF86XK_MenuPB" );
	#endif
	#ifdef XF86XK_MySites
		swigIntConstant( XF86XK_MySites, "XF86XK_MySites" );
	#endif
	#ifdef XF86XK_New
		swigIntConstant( XF86XK_New, "XF86XK_New" );
	#endif
	#ifdef XF86XK_News
		swigIntConstant( XF86XK_News, "XF86XK_News" );
	#endif
	#ifdef XF86XK_OfficeHome
		swigIntConstant( XF86XK_OfficeHome, "XF86XK_OfficeHome" );
	#endif
	#ifdef XF86XK_Open
		swigIntConstant( XF86XK_Open, "XF86XK_Open" );
	#endif
	#ifdef XF86XK_Option
		swigIntConstant( XF86XK_Option, "XF86XK_Option" );
	#endif
	#ifdef XF86XK_Paste
		swigIntConstant( XF86XK_Paste, "XF86XK_Paste" );
	#endif
	#ifdef XF86XK_Phone
		swigIntConstant( XF86XK_Phone, "XF86XK_Phone" );
	#endif
	#ifdef XF86XK_Q
		swigIntConstant( XF86XK_Q, "XF86XK_Q" );
	#endif
	#ifdef XF86XK_Reply
		swigIntConstant( XF86XK_Reply, "XF86XK_Reply" );
	#endif
	#ifdef XF86XK_Reload
		swigIntConstant( XF86XK_Reload, "XF86XK_Reload" );
	#endif
	#ifdef XF86XK_RotateWindows
		swigIntConstant( XF86XK_RotateWindows, "XF86XK_RotateWindows" );
	#endif
	#ifdef XF86XK_RotationPB
		swigIntConstant( XF86XK_RotationPB, "XF86XK_RotationPB" );
	#endif
	#ifdef XF86XK_RotationKB
		swigIntConstant( XF86XK_RotationKB, "XF86XK_RotationKB" );
	#endif
	#ifdef XF86XK_Save
		swigIntConstant( XF86XK_Save, "XF86XK_Save" );
	#endif
	#ifdef XF86XK_ScrollUp
		swigIntConstant( XF86XK_ScrollUp, "XF86XK_ScrollUp" );
	#endif
	#ifdef XF86XK_ScrollDown
		swigIntConstant( XF86XK_ScrollDown, "XF86XK_ScrollDown" );
	#endif
	#ifdef XF86XK_ScrollClick
		swigIntConstant( XF86XK_ScrollClick, "XF86XK_ScrollClick" );
	#endif
	#ifdef XF86XK_Send
		swigIntConstant( XF86XK_Send, "XF86XK_Send" );
	#endif
	#ifdef XF86XK_Spell
		swigIntConstant( XF86XK_Spell, "XF86XK_Spell" );
	#endif
	#ifdef XF86XK_SplitScreen
		swigIntConstant( XF86XK_SplitScreen, "XF86XK_SplitScreen" );
	#endif
	#ifdef XF86XK_Support
		swigIntConstant( XF86XK_Support, "XF86XK_Support" );
	#endif
	#ifdef XF86XK_TaskPane
		swigIntConstant( XF86XK_TaskPane, "XF86XK_TaskPane" );
	#endif
	#ifdef XF86XK_Terminal
		swigIntConstant( XF86XK_Terminal, "XF86XK_Terminal" );
	#endif
	#ifdef XF86XK_Tools
		swigIntConstant( XF86XK_Tools, "XF86XK_Tools" );
	#endif
	#ifdef XF86XK_Travel
		swigIntConstant( XF86XK_Travel, "XF86XK_Travel" );
	#endif
	#ifdef XF86XK_UserPB
		swigIntConstant( XF86XK_UserPB, "XF86XK_UserPB" );
	#endif
	#ifdef XF86XK_User1KB
		swigIntConstant( XF86XK_User1KB, "XF86XK_User1KB" );
	#endif
	#ifdef XF86XK_User2KB
		swigIntConstant( XF86XK_User2KB, "XF86XK_User2KB" );
	#endif
	#ifdef XF86XK_Video
		swigIntConstant( XF86XK_Video, "XF86XK_Video" );
	#endif
	#ifdef XF86XK_WheelButton
		swigIntConstant( XF86XK_WheelButton, "XF86XK_WheelButton" );
	#endif
	#ifdef XF86XK_Word
		swigIntConstant( XF86XK_Word, "XF86XK_Word" );
	#endif
	#ifdef XF86XK_Xfer
		swigIntConstant( XF86XK_Xfer, "XF86XK_Xfer" );
	#endif
	#ifdef XF86XK_ZoomIn
		swigIntConstant( XF86XK_ZoomIn, "XF86XK_ZoomIn" );
	#endif
	#ifdef XF86XK_ZoomOut
		swigIntConstant( XF86XK_ZoomOut, "XF86XK_ZoomOut" );
	#endif
	#ifdef XF86XK_Away
		swigIntConstant( XF86XK_Away, "XF86XK_Away" );
	#endif
	#ifdef XF86XK_Messenger
		swigIntConstant( XF86XK_Messenger, "XF86XK_Messenger" );
	#endif
	#ifdef XF86XK_WebCam
		swigIntConstant( XF86XK_WebCam, "XF86XK_WebCam" );
	#endif
	#ifdef XF86XK_MailForward
		swigIntConstant( XF86XK_MailForward, "XF86XK_MailForward" );
	#endif
	#ifdef XF86XK_Pictures
		swigIntConstant( XF86XK_Pictures, "XF86XK_Pictures" );
	#endif
	#ifdef XF86XK_Music
		swigIntConstant( XF86XK_Music, "XF86XK_Music" );
	#endif
	#ifdef XF86XK_Battery
		swigIntConstant( XF86XK_Battery, "XF86XK_Battery" );
	#endif
	#ifdef XF86XK_Bluetooth
		swigIntConstant( XF86XK_Bluetooth, "XF86XK_Bluetooth" );
	#endif
	#ifdef XF86XK_WLAN
		swigIntConstant( XF86XK_WLAN, "XF86XK_WLAN" );
	#endif
	#ifdef XF86XK_UWB
		swigIntConstant( XF86XK_UWB, "XF86XK_UWB" );
	#endif
	#ifdef XF86XK_AudioForward
		swigIntConstant( XF86XK_AudioForward, "XF86XK_AudioForward" );
	#endif
	#ifdef XF86XK_AudioRepeat
		swigIntConstant( XF86XK_AudioRepeat, "XF86XK_AudioRepeat" );
	#endif
	#ifdef XF86XK_AudioRandomPlay
		swigIntConstant( XF86XK_AudioRandomPlay, "XF86XK_AudioRandomPlay" );
	#endif
	#ifdef XF86XK_Subtitle
		swigIntConstant( XF86XK_Subtitle, "XF86XK_Subtitle" );
	#endif
	#ifdef XF86XK_AudioCycleTrack
		swigIntConstant( XF86XK_AudioCycleTrack, "XF86XK_AudioCycleTrack" );
	#endif
	#ifdef XF86XK_CycleAngle
		swigIntConstant( XF86XK_CycleAngle, "XF86XK_CycleAngle" );
	#endif
	#ifdef XF86XK_FrameBack
		swigIntConstant( XF86XK_FrameBack, "XF86XK_FrameBack" );
	#endif
	#ifdef XF86XK_FrameForward
		swigIntConstant( XF86XK_FrameForward, "XF86XK_FrameForward" );
	#endif
	#ifdef XF86XK_Time
		swigIntConstant( XF86XK_Time, "XF86XK_Time" );
	#endif
	#ifdef XF86XK_Select
		swigIntConstant( XF86XK_Select, "XF86XK_Select" );
	#endif
	#ifdef XF86XK_View
		swigIntConstant( XF86XK_View, "XF86XK_View" );
	#endif
	#ifdef XF86XK_TopMenu
		swigIntConstant( XF86XK_TopMenu, "XF86XK_TopMenu" );
	#endif
	#ifdef XF86XK_Red
		swigIntConstant( XF86XK_Red, "XF86XK_Red" );
	#endif
	#ifdef XF86XK_Green
		swigIntConstant( XF86XK_Green, "XF86XK_Green" );
	#endif
	#ifdef XF86XK_Yellow
		swigIntConstant( XF86XK_Yellow, "XF86XK_Yellow" );
	#endif
	#ifdef XF86XK_Blue
		swigIntConstant( XF86XK_Blue, "XF86XK_Blue" );
	#endif
	#ifdef XF86XK_Suspend
		swigIntConstant( XF86XK_Suspend, "XF86XK_Suspend" );
	#endif
	#ifdef XF86XK_Hibernate
		swigIntConstant( XF86XK_Hibernate, "XF86XK_Hibernate" );
	#endif
	#ifdef XF86XK_TouchpadToggle
		swigIntConstant( XF86XK_TouchpadToggle, "XF86XK_TouchpadToggle" );
	#endif
	#ifdef XF86XK_TouchpadOn
		swigIntConstant( XF86XK_TouchpadOn, "XF86XK_TouchpadOn" );
	#endif
	#ifdef XF86XK_TouchpadOff
		swigIntConstant( XF86XK_TouchpadOff, "XF86XK_TouchpadOff" );
	#endif
	#ifdef XF86XK_AudioMicMute
		swigIntConstant( XF86XK_AudioMicMute, "XF86XK_AudioMicMute" );
	#endif
	#ifdef XF86XK_Keyboard
		swigIntConstant( XF86XK_Keyboard, "XF86XK_Keyboard" );
	#endif
	#ifdef XF86XK_WWAN
		swigIntConstant( XF86XK_WWAN, "XF86XK_WWAN" );
	#endif
	#ifdef XF86XK_RFKill
		swigIntConstant( XF86XK_RFKill, "XF86XK_RFKill" );
	#endif
	#ifdef XF86XK_AudioPreset
		swigIntConstant( XF86XK_AudioPreset, "XF86XK_AudioPreset" );
	#endif
	#ifdef XF86XK_RotationLockToggle
		swigIntConstant( XF86XK_RotationLockToggle, "XF86XK_RotationLockToggle" );
	#endif
	#ifdef XF86XK_FullScreen
		swigIntConstant( XF86XK_FullScreen, "XF86XK_FullScreen" );
	#endif
	#ifdef XF86XK_Switch_VT_1
		swigIntConstant( XF86XK_Switch_VT_1, "XF86XK_Switch_VT_1" );
	#endif
	#ifdef XF86XK_Switch_VT_2
		swigIntConstant( XF86XK_Switch_VT_2, "XF86XK_Switch_VT_2" );
	#endif
	#ifdef XF86XK_Switch_VT_3
		swigIntConstant( XF86XK_Switch_VT_3, "XF86XK_Switch_VT_3" );
	#endif
	#ifdef XF86XK_Switch_VT_4
		swigIntConstant( XF86XK_Switch_VT_4, "XF86XK_Switch_VT_4" );
	#endif
	#ifdef XF86XK_Switch_VT_5
		swigIntConstant( XF86XK_Switch_VT_5, "XF86XK_Switch_VT_5" );
	#endif
	#ifdef XF86XK_Switch_VT_6
		swigIntConstant( XF86XK_Switch_VT_6, "XF86XK_Switch_VT_6" );
	#endif
	#ifdef XF86XK_Switch_VT_7
		swigIntConstant( XF86XK_Switch_VT_7, "XF86XK_Switch_VT_7" );
	#endif
	#ifdef XF86XK_Switch_VT_8
		swigIntConstant( XF86XK_Switch_VT_8, "XF86XK_Switch_VT_8" );
	#endif
	#ifdef XF86XK_Switch_VT_9
		swigIntConstant( XF86XK_Switch_VT_9, "XF86XK_Switch_VT_9" );
	#endif
	#ifdef XF86XK_Switch_VT_10
		swigIntConstant( XF86XK_Switch_VT_10, "XF86XK_Switch_VT_10" );
	#endif
	#ifdef XF86XK_Switch_VT_11
		swigIntConstant( XF86XK_Switch_VT_11, "XF86XK_Switch_VT_11" );
	#endif
	#ifdef XF86XK_Switch_VT_12
		swigIntConstant( XF86XK_Switch_VT_12, "XF86XK_Switch_VT_12" );
	#endif
	#ifdef XF86XK_Ungrab
		swigIntConstant( XF86XK_Ungrab, "XF86XK_Ungrab" );
	#endif
	#ifdef XF86XK_ClearGrab
		swigIntConstant( XF86XK_ClearGrab, "XF86XK_ClearGrab" );
	#endif
	#ifdef XF86XK_Next_VMode
		swigIntConstant( XF86XK_Next_VMode, "XF86XK_Next_VMode" );
	#endif
	#ifdef XF86XK_Prev_VMode
		swigIntConstant( XF86XK_Prev_VMode, "XF86XK_Prev_VMode" );
	#endif
	#ifdef XF86XK_LogWindowTree
		swigIntConstant( XF86XK_LogWindowTree, "XF86XK_LogWindowTree" );
	#endif
	#ifdef XF86XK_LogGrabInfo
		swigIntConstant( XF86XK_LogGrabInfo, "XF86XK_LogGrabInfo" );
	#endif
	#ifdef XF86XK_BrightnessAuto
		swigIntConstant( XF86XK_BrightnessAuto, "XF86XK_BrightnessAuto" );
	#endif
	#ifdef XF86XK_DisplayOff
		swigIntConstant( XF86XK_DisplayOff, "XF86XK_DisplayOff" );
	#endif
	#ifdef XF86XK_Info
		swigIntConstant( XF86XK_Info, "XF86XK_Info" );
	#endif
	#ifdef XF86XK_AspectRatio
		swigIntConstant( XF86XK_AspectRatio, "XF86XK_AspectRatio" );
	#endif
	#ifdef XF86XK_DVD
		swigIntConstant( XF86XK_DVD, "XF86XK_DVD" );
	#endif
	#ifdef XF86XK_Audio
		swigIntConstant( XF86XK_Audio, "XF86XK_Audio" );
	#endif
	#ifdef XF86XK_ChannelUp
		swigIntConstant( XF86XK_ChannelUp, "XF86XK_ChannelUp" );
	#endif
	#ifdef XF86XK_ChannelDown
		swigIntConstant( XF86XK_ChannelDown, "XF86XK_ChannelDown" );
	#endif
	#ifdef XF86XK_Break
		swigIntConstant( XF86XK_Break, "XF86XK_Break" );
	#endif
	#ifdef XF86XK_VideoPhone
		swigIntConstant( XF86XK_VideoPhone, "XF86XK_VideoPhone" );
	#endif
	#ifdef XF86XK_ZoomReset
		swigIntConstant( XF86XK_ZoomReset, "XF86XK_ZoomReset" );
	#endif
	#ifdef XF86XK_Editor
		swigIntConstant( XF86XK_Editor, "XF86XK_Editor" );
	#endif
	#ifdef XF86XK_GraphicsEditor
		swigIntConstant( XF86XK_GraphicsEditor, "XF86XK_GraphicsEditor" );
	#endif
	#ifdef XF86XK_Presentation
		swigIntConstant( XF86XK_Presentation, "XF86XK_Presentation" );
	#endif
	#ifdef XF86XK_Database
		swigIntConstant( XF86XK_Database, "XF86XK_Database" );
	#endif
	#ifdef XF86XK_Voicemail
		swigIntConstant( XF86XK_Voicemail, "XF86XK_Voicemail" );
	#endif
	#ifdef XF86XK_Addressbook
		swigIntConstant( XF86XK_Addressbook, "XF86XK_Addressbook" );
	#endif
	#ifdef XF86XK_DisplayToggle
		swigIntConstant( XF86XK_DisplayToggle, "XF86XK_DisplayToggle" );
	#endif
	#ifdef XF86XK_SpellCheck
		swigIntConstant( XF86XK_SpellCheck, "XF86XK_SpellCheck" );
	#endif
	#ifdef XF86XK_ContextMenu
		swigIntConstant( XF86XK_ContextMenu, "XF86XK_ContextMenu" );
	#endif
	#ifdef XF86XK_MediaRepeat
		swigIntConstant( XF86XK_MediaRepeat, "XF86XK_MediaRepeat" );
	#endif
	#ifdef XF86XK_10ChannelsUp
		swigIntConstant( XF86XK_10ChannelsUp, "XF86XK_10ChannelsUp" );
	#endif
	#ifdef XF86XK_10ChannelsDown
		swigIntConstant( XF86XK_10ChannelsDown, "XF86XK_10ChannelsDown" );
	#endif
	#ifdef XF86XK_Images
		swigIntConstant( XF86XK_Images, "XF86XK_Images" );
	#endif
	#ifdef XF86XK_NotificationCenter
		swigIntConstant( XF86XK_NotificationCenter, "XF86XK_NotificationCenter" );
	#endif
	#ifdef XF86XK_PickupPhone
		swigIntConstant( XF86XK_PickupPhone, "XF86XK_PickupPhone" );
	#endif
	#ifdef XF86XK_HangupPhone
		swigIntConstant( XF86XK_HangupPhone, "XF86XK_HangupPhone" );
	#endif
	#ifdef XF86XK_Fn
		swigIntConstant( XF86XK_Fn, "XF86XK_Fn" );
	#endif
	#ifdef XF86XK_Fn_Esc
		swigIntConstant( XF86XK_Fn_Esc, "XF86XK_Fn_Esc" );
	#endif
	#ifdef XF86XK_FnRightShift
		swigIntConstant( XF86XK_FnRightShift, "XF86XK_FnRightShift" );
	#endif
	#ifdef XF86XK_Numeric0
		swigIntConstant( XF86XK_Numeric0, "XF86XK_Numeric0" );
	#endif
	#ifdef XF86XK_Numeric1
		swigIntConstant( XF86XK_Numeric1, "XF86XK_Numeric1" );
	#endif
	#ifdef XF86XK_Numeric2
		swigIntConstant( XF86XK_Numeric2, "XF86XK_Numeric2" );
	#endif
	#ifdef XF86XK_Numeric3
		swigIntConstant( XF86XK_Numeric3, "XF86XK_Numeric3" );
	#endif
	#ifdef XF86XK_Numeric4
		swigIntConstant( XF86XK_Numeric4, "XF86XK_Numeric4" );
	#endif
	#ifdef XF86XK_Numeric5
		swigIntConstant( XF86XK_Numeric5, "XF86XK_Numeric5" );
	#endif
	#ifdef XF86XK_Numeric6
		swigIntConstant( XF86XK_Numeric6, "XF86XK_Numeric6" );
	#endif
	#ifdef XF86XK_Numeric7
		swigIntConstant( XF86XK_Numeric7, "XF86XK_Numeric7" );
	#endif
	#ifdef XF86XK_Numeric8
		swigIntConstant( XF86XK_Numeric8, "XF86XK_Numeric8" );
	#endif
	#ifdef XF86XK_Numeric9
		swigIntConstant( XF86XK_Numeric9, "XF86XK_Numeric9" );
	#endif
	#ifdef XF86XK_NumericStar
		swigIntConstant( XF86XK_NumericStar, "XF86XK_NumericStar" );
	#endif
	#ifdef XF86XK_NumericPound
		swigIntConstant( XF86XK_NumericPound, "XF86XK_NumericPound" );
	#endif
	#ifdef XF86XK_NumericA
		swigIntConstant( XF86XK_NumericA, "XF86XK_NumericA" );
	#endif
	#ifdef XF86XK_NumericB
		swigIntConstant( XF86XK_NumericB, "XF86XK_NumericB" );
	#endif
	#ifdef XF86XK_NumericC
		swigIntConstant( XF86XK_NumericC, "XF86XK_NumericC" );
	#endif
	#ifdef XF86XK_NumericD
		swigIntConstant( XF86XK_NumericD, "XF86XK_NumericD" );
	#endif
	#ifdef XF86XK_CameraFocus
		swigIntConstant( XF86XK_CameraFocus, "XF86XK_CameraFocus" );
	#endif
	#ifdef XF86XK_WPSButton
		swigIntConstant( XF86XK_WPSButton, "XF86XK_WPSButton" );
	#endif
	#ifdef XF86XK_CameraZoomIn
		swigIntConstant( XF86XK_CameraZoomIn, "XF86XK_CameraZoomIn" );
	#endif
	#ifdef XF86XK_CameraZoomOut
		swigIntConstant( XF86XK_CameraZoomOut, "XF86XK_CameraZoomOut" );
	#endif
	#ifdef XF86XK_CameraUp
		swigIntConstant( XF86XK_CameraUp, "XF86XK_CameraUp" );
	#endif
	#ifdef XF86XK_CameraDown
		swigIntConstant( XF86XK_CameraDown, "XF86XK_CameraDown" );
	#endif
	#ifdef XF86XK_CameraLeft
		swigIntConstant( XF86XK_CameraLeft, "XF86XK_CameraLeft" );
	#endif
	#ifdef XF86XK_CameraRight
		swigIntConstant( XF86XK_CameraRight, "XF86XK_CameraRight" );
	#endif
	#ifdef XF86XK_AttendantOn
		swigIntConstant( XF86XK_AttendantOn, "XF86XK_AttendantOn" );
	#endif
	#ifdef XF86XK_AttendantOff
		swigIntConstant( XF86XK_AttendantOff, "XF86XK_AttendantOff" );
	#endif
	#ifdef XF86XK_AttendantToggle
		swigIntConstant( XF86XK_AttendantToggle, "XF86XK_AttendantToggle" );
	#endif
	#ifdef XF86XK_LightsToggle
		swigIntConstant( XF86XK_LightsToggle, "XF86XK_LightsToggle" );
	#endif
	#ifdef XF86XK_ALSToggle
		swigIntConstant( XF86XK_ALSToggle, "XF86XK_ALSToggle" );
	#endif
	#ifdef XF86XK_Buttonconfig
		swigIntConstant( XF86XK_Buttonconfig, "XF86XK_Buttonconfig" );
	#endif
	#ifdef XF86XK_Taskmanager
		swigIntConstant( XF86XK_Taskmanager, "XF86XK_Taskmanager" );
	#endif
	#ifdef XF86XK_Journal
		swigIntConstant( XF86XK_Journal, "XF86XK_Journal" );
	#endif
	#ifdef XF86XK_ControlPanel
		swigIntConstant( XF86XK_ControlPanel, "XF86XK_ControlPanel" );
	#endif
	#ifdef XF86XK_AppSelect
		swigIntConstant( XF86XK_AppSelect, "XF86XK_AppSelect" );
	#endif
	#ifdef XF86XK_Screensaver
		swigIntConstant( XF86XK_Screensaver, "XF86XK_Screensaver" );
	#endif
	#ifdef XF86XK_VoiceCommand
		swigIntConstant( XF86XK_VoiceCommand, "XF86XK_VoiceCommand" );
	#endif
	#ifdef XF86XK_Assistant
		swigIntConstant( XF86XK_Assistant, "XF86XK_Assistant" );
	#endif
	#ifdef XF86XK_BrightnessMin
		swigIntConstant( XF86XK_BrightnessMin, "XF86XK_BrightnessMin" );
	#endif
	#ifdef XF86XK_BrightnessMax
		swigIntConstant( XF86XK_BrightnessMax, "XF86XK_BrightnessMax" );
	#endif
	#ifdef XF86XK_KbdInputAssistPrev
		swigIntConstant( XF86XK_KbdInputAssistPrev, "XF86XK_KbdInputAssistPrev" );
	#endif
	#ifdef XF86XK_KbdInputAssistNext
		swigIntConstant( XF86XK_KbdInputAssistNext, "XF86XK_KbdInputAssistNext" );
	#endif
	#ifdef XF86XK_KbdInputAssistPrevgroup
		swigIntConstant( XF86XK_KbdInputAssistPrevgroup, "XF86XK_KbdInputAssistPrevgroup" );
	#endif
	#ifdef XF86XK_KbdInputAssistNextgroup
		swigIntConstant( XF86XK_KbdInputAssistNextgroup, "XF86XK_KbdInputAssistNextgroup" );
	#endif
	#ifdef XF86XK_KbdInputAssistAccept
		swigIntConstant( XF86XK_KbdInputAssistAccept, "XF86XK_KbdInputAssistAccept" );
	#endif
	#ifdef XF86XK_KbdInputAssistCancel
		swigIntConstant( XF86XK_KbdInputAssistCancel, "XF86XK_KbdInputAssistCancel" );
	#endif
	#ifdef XF86XK_RightUp
		swigIntConstant( XF86XK_RightUp, "XF86XK_RightUp" );
	#endif
	#ifdef XF86XK_RightDown
		swigIntConstant( XF86XK_RightDown, "XF86XK_RightDown" );
	#endif
	#ifdef XF86XK_LeftUp
		swigIntConstant( XF86XK_LeftUp, "XF86XK_LeftUp" );
	#endif
	#ifdef XF86XK_LeftDown
		swigIntConstant( XF86XK_LeftDown, "XF86XK_LeftDown" );
	#endif
	#ifdef XF86XK_RootMenu
		swigIntConstant( XF86XK_RootMenu, "XF86XK_RootMenu" );
	#endif
	#ifdef XF86XK_MediaTopMenu
		swigIntConstant( XF86XK_MediaTopMenu, "XF86XK_MediaTopMenu" );
	#endif
	#ifdef XF86XK_Numeric11
		swigIntConstant( XF86XK_Numeric11, "XF86XK_Numeric11" );
	#endif
	#ifdef XF86XK_Numeric12
		swigIntConstant( XF86XK_Numeric12, "XF86XK_Numeric12" );
	#endif
	#ifdef XF86XK_AudioDesc
		swigIntConstant( XF86XK_AudioDesc, "XF86XK_AudioDesc" );
	#endif
	#ifdef XF86XK_3DMode
		swigIntConstant( XF86XK_3DMode, "XF86XK_3DMode" );
	#endif
	#ifdef XF86XK_NextFavorite
		swigIntConstant( XF86XK_NextFavorite, "XF86XK_NextFavorite" );
	#endif
	#ifdef XF86XK_StopRecord
		swigIntConstant( XF86XK_StopRecord, "XF86XK_StopRecord" );
	#endif
	#ifdef XF86XK_PauseRecord
		swigIntConstant( XF86XK_PauseRecord, "XF86XK_PauseRecord" );
	#endif
	#ifdef XF86XK_VOD
		swigIntConstant( XF86XK_VOD, "XF86XK_VOD" );
	#endif
	#ifdef XF86XK_Unmute
		swigIntConstant( XF86XK_Unmute, "XF86XK_Unmute" );
	#endif
	#ifdef XF86XK_FastReverse
		swigIntConstant( XF86XK_FastReverse, "XF86XK_FastReverse" );
	#endif
	#ifdef XF86XK_SlowReverse
		swigIntConstant( XF86XK_SlowReverse, "XF86XK_SlowReverse" );
	#endif
	#ifdef XF86XK_Data
		swigIntConstant( XF86XK_Data, "XF86XK_Data" );
	#endif
	#ifdef XF86XK_OnScreenKeyboard
		swigIntConstant( XF86XK_OnScreenKeyboard, "XF86XK_OnScreenKeyboard" );
	#endif
	#ifdef XF86XK_PrivacyScreenToggle
		swigIntConstant( XF86XK_PrivacyScreenToggle, "XF86XK_PrivacyScreenToggle" );
	#endif
	#ifdef XF86XK_SelectiveScreenshot
		swigIntConstant( XF86XK_SelectiveScreenshot, "XF86XK_SelectiveScreenshot" );
	#endif
	#ifdef XF86XK_Macro1
		swigIntConstant( XF86XK_Macro1, "XF86XK_Macro1" );
	#endif
	#ifdef XF86XK_Macro2
		swigIntConstant( XF86XK_Macro2, "XF86XK_Macro2" );
	#endif
	#ifdef XF86XK_Macro3
		swigIntConstant( XF86XK_Macro3, "XF86XK_Macro3" );
	#endif
	#ifdef XF86XK_Macro4
		swigIntConstant( XF86XK_Macro4, "XF86XK_Macro4" );
	#endif
	#ifdef XF86XK_Macro5
		swigIntConstant( XF86XK_Macro5, "XF86XK_Macro5" );
	#endif
	#ifdef XF86XK_Macro6
		swigIntConstant( XF86XK_Macro6, "XF86XK_Macro6" );
	#endif
	#ifdef XF86XK_Macro7
		swigIntConstant( XF86XK_Macro7, "XF86XK_Macro7" );
	#endif
	#ifdef XF86XK_Macro8
		swigIntConstant( XF86XK_Macro8, "XF86XK_Macro8" );
	#endif
	#ifdef XF86XK_Macro9
		swigIntConstant( XF86XK_Macro9, "XF86XK_Macro9" );
	#endif
	#ifdef XF86XK_Macro10
		swigIntConstant( XF86XK_Macro10, "XF86XK_Macro10" );
	#endif
	#ifdef XF86XK_Macro11
		swigIntConstant( XF86XK_Macro11, "XF86XK_Macro11" );
	#endif
	#ifdef XF86XK_Macro12
		swigIntConstant( XF86XK_Macro12, "XF86XK_Macro12" );
	#endif
	#ifdef XF86XK_Macro13
		swigIntConstant( XF86XK_Macro13, "XF86XK_Macro13" );
	#endif
	#ifdef XF86XK_Macro14
		swigIntConstant( XF86XK_Macro14, "XF86XK_Macro14" );
	#endif
	#ifdef XF86XK_Macro15
		swigIntConstant( XF86XK_Macro15, "XF86XK_Macro15" );
	#endif
	#ifdef XF86XK_Macro16
		swigIntConstant( XF86XK_Macro16, "XF86XK_Macro16" );
	#endif
	#ifdef XF86XK_Macro17
		swigIntConstant( XF86XK_Macro17, "XF86XK_Macro17" );
	#endif
	#ifdef XF86XK_Macro18
		swigIntConstant( XF86XK_Macro18, "XF86XK_Macro18" );
	#endif
	#ifdef XF86XK_Macro19
		swigIntConstant( XF86XK_Macro19, "XF86XK_Macro19" );
	#endif
	#ifdef XF86XK_Macro20
		swigIntConstant( XF86XK_Macro20, "XF86XK_Macro20" );
	#endif
	#ifdef XF86XK_Macro21
		swigIntConstant( XF86XK_Macro21, "XF86XK_Macro21" );
	#endif
	#ifdef XF86XK_Macro22
		swigIntConstant( XF86XK_Macro22, "XF86XK_Macro22" );
	#endif
	#ifdef XF86XK_Macro23
		swigIntConstant( XF86XK_Macro23, "XF86XK_Macro23" );
	#endif
	#ifdef XF86XK_Macro24
		swigIntConstant( XF86XK_Macro24, "XF86XK_Macro24" );
	#endif
	#ifdef XF86XK_Macro25
		swigIntConstant( XF86XK_Macro25, "XF86XK_Macro25" );
	#endif
	#ifdef XF86XK_Macro26
		swigIntConstant( XF86XK_Macro26, "XF86XK_Macro26" );
	#endif
	#ifdef XF86XK_Macro27
		swigIntConstant( XF86XK_Macro27, "XF86XK_Macro27" );
	#endif
	#ifdef XF86XK_Macro28
		swigIntConstant( XF86XK_Macro28, "XF86XK_Macro28" );
	#endif
	#ifdef XF86XK_Macro29
		swigIntConstant( XF86XK_Macro29, "XF86XK_Macro29" );
	#endif
	#ifdef XF86XK_Macro30
		swigIntConstant( XF86XK_Macro30, "XF86XK_Macro30" );
	#endif
	#ifdef XF86XK_MacroRecordStart
		swigIntConstant( XF86XK_MacroRecordStart, "XF86XK_MacroRecordStart" );
	#endif
	#ifdef XF86XK_MacroRecordStop
		swigIntConstant( XF86XK_MacroRecordStop, "XF86XK_MacroRecordStop" );
	#endif
	#ifdef XF86XK_MacroPresetCycle
		swigIntConstant( XF86XK_MacroPresetCycle, "XF86XK_MacroPresetCycle" );
	#endif
	#ifdef XF86XK_MacroPreset1
		swigIntConstant( XF86XK_MacroPreset1, "XF86XK_MacroPreset1" );
	#endif
	#ifdef XF86XK_MacroPreset2
		swigIntConstant( XF86XK_MacroPreset2, "XF86XK_MacroPreset2" );
	#endif
	#ifdef XF86XK_MacroPreset3
		swigIntConstant( XF86XK_MacroPreset3, "XF86XK_MacroPreset3" );
	#endif
	#ifdef XF86XK_KbdLcdMenu1
		swigIntConstant( XF86XK_KbdLcdMenu1, "XF86XK_KbdLcdMenu1" );
	#endif
	#ifdef XF86XK_KbdLcdMenu2
		swigIntConstant( XF86XK_KbdLcdMenu2, "XF86XK_KbdLcdMenu2" );
	#endif
	#ifdef XF86XK_KbdLcdMenu3
		swigIntConstant( XF86XK_KbdLcdMenu3, "XF86XK_KbdLcdMenu3" );
	#endif
	#ifdef XF86XK_KbdLcdMenu4
		swigIntConstant( XF86XK_KbdLcdMenu4, "XF86XK_KbdLcdMenu4" );
	#endif
	#ifdef XF86XK_KbdLcdMenu5
		swigIntConstant( XF86XK_KbdLcdMenu5, "XF86XK_KbdLcdMenu5" );
	#endif

	swigNewline();

	swigComment("--------===< enums >===---------\n");
	swigIntConstant( XOMOrientation_LTR_TTB, "XOMOrientation_LTR_TTB" );
	swigIntConstant( XOMOrientation_RTL_TTB, "XOMOrientation_RTL_TTB" );
	swigIntConstant( XOMOrientation_TTB_LTR, "XOMOrientation_TTB_LTR" );
	swigIntConstant( XOMOrientation_TTB_RTL, "XOMOrientation_TTB_RTL" );
	swigIntConstant( XOMOrientation_Context, "XOMOrientation_Context" );
	swigIntConstant( XIMForwardChar, "XIMForwardChar" );
	swigIntConstant( XIMBackwardChar, "XIMBackwardChar" );
	swigIntConstant( XIMForwardWord, "XIMForwardWord" );
	swigIntConstant( XIMBackwardWord, "XIMBackwardWord" );
	swigIntConstant( XIMCaretUp, "XIMCaretUp" );
	swigIntConstant( XIMCaretDown, "XIMCaretDown" );
	swigIntConstant( XIMNextLine, "XIMNextLine" );
	swigIntConstant( XIMPreviousLine, "XIMPreviousLine" );
	swigIntConstant( XIMLineStart, "XIMLineStart" );
	swigIntConstant( XIMLineEnd, "XIMLineEnd" );
	swigIntConstant( XIMAbsolutePosition, "XIMAbsolutePosition" );
	swigIntConstant( XIMDontChange, "XIMDontChange" );
	swigIntConstant( XIMIsInvisible, "XIMIsInvisible" );
	swigIntConstant( XIMIsPrimary, "XIMIsPrimary" );
	swigIntConstant( XIMIsSecondary, "XIMIsSecondary" );
	swigIntConstant( XIMTextType, "XIMTextType" );
	swigIntConstant( XIMBitmapType, "XIMBitmapType" );
	swigIntConstant( XStringStyle, "XStringStyle" );
	swigIntConstant( XCompoundTextStyle, "XCompoundTextStyle" );
	swigIntConstant( XTextStyle, "XTextStyle" );
	swigIntConstant( XStdICCTextStyle, "XStdICCTextStyle" );
	swigIntConstant( XUTF8StringStyle, "XUTF8StringStyle" );

	swigNewline();

	swigComment("-------===< structs >===--------\n");

	swigComment("struct _XExtData\n");
	printf( "begin-structure XExtData\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _XExtData ) );

	swigComment("XExtCodes\n");
	printf( "begin-structure XExtCodes\n" );
	swigStructField( "XExtCodes-extension", offsetof( XExtCodes, extension ), sizeof( int ) );
	swigStructField( "XExtCodes-first_error", offsetof( XExtCodes, first_error ), sizeof( int ) );
	swigStructField( "XExtCodes-major_opcode", offsetof( XExtCodes, major_opcode ), sizeof( int ) );
	swigStructField( "XExtCodes-first_event", offsetof( XExtCodes, first_event ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( XExtCodes ) );

	swigComment("XPixmapFormatValues\n");
	printf( "begin-structure XPixmapFormatValues\n" );
	swigStructField( "XPixmapFormatValues-scanline_pad", offsetof( XPixmapFormatValues, scanline_pad ), sizeof( int ) );
	swigStructField( "XPixmapFormatValues-bits_per_pixel", offsetof( XPixmapFormatValues, bits_per_pixel ), sizeof( int ) );
	swigStructField( "XPixmapFormatValues-depth", offsetof( XPixmapFormatValues, depth ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( XPixmapFormatValues ) );

	swigComment("XGCValues\n");
	printf( "begin-structure XGCValues\n" );
	swigStructField( "XGCValues-fill_style", offsetof( XGCValues, fill_style ), sizeof( int ) );
	swigStructField( "XGCValues-join_style", offsetof( XGCValues, join_style ), sizeof( int ) );
	swigStructField( "XGCValues-cap_style", offsetof( XGCValues, cap_style ), sizeof( int ) );
	swigStructField( "XGCValues-ts_x_origin", offsetof( XGCValues, ts_x_origin ), sizeof( int ) );
	swigStructField( "XGCValues-ts_y_origin", offsetof( XGCValues, ts_y_origin ), sizeof( int ) );
	swigStructField( "XGCValues-font", offsetof( XGCValues, font ), sizeof( Font ) );
	swigStructField( "XGCValues-clip_x_origin", offsetof( XGCValues, clip_x_origin ), sizeof( int ) );
	swigStructField( "XGCValues-clip_y_origin", offsetof( XGCValues, clip_y_origin ), sizeof( int ) );
	swigStructField( "XGCValues-stipple", offsetof( XGCValues, stipple ), sizeof( Pixmap ) );
	swigStructField( "XGCValues-plane_mask", offsetof( XGCValues, plane_mask ), sizeof( unsigned long ) );
	swigStructField( "XGCValues-subwindow_mode", offsetof( XGCValues, subwindow_mode ), sizeof( int ) );
	swigStructField( "XGCValues-line_style", offsetof( XGCValues, line_style ), sizeof( int ) );
	swigStructField( "XGCValues-tile", offsetof( XGCValues, tile ), sizeof( Pixmap ) );
	swigStructField( "XGCValues-background", offsetof( XGCValues, background ), sizeof( unsigned long ) );
	swigStructField( "XGCValues-foreground", offsetof( XGCValues, foreground ), sizeof( unsigned long ) );
	swigStructField( "XGCValues-function", offsetof( XGCValues, function ), sizeof( int ) );
	swigStructField( "XGCValues-graphics_exposures", offsetof( XGCValues, graphics_exposures ), sizeof( int ) );
	swigStructField( "XGCValues-line_width", offsetof( XGCValues, line_width ), sizeof( int ) );
	swigStructField( "XGCValues-arc_mode", offsetof( XGCValues, arc_mode ), sizeof( int ) );
	swigStructField( "XGCValues-clip_mask", offsetof( XGCValues, clip_mask ), sizeof( Pixmap ) );
	swigStructField( "XGCValues-fill_rule", offsetof( XGCValues, fill_rule ), sizeof( int ) );
	swigStructField( "XGCValues-dash_offset", offsetof( XGCValues, dash_offset ), sizeof( int ) );
	swigStructField( "XGCValues-dashes", offsetof( XGCValues, dashes ), sizeof( char ) );
	printf( "drop %zu end-structure\n", sizeof( XGCValues ) );

	swigComment("Visual\n");
	printf( "begin-structure Visual\n" );
	swigStructField( "Visual-blue_mask", offsetof( Visual, blue_mask ), sizeof( unsigned long ) );
	swigStructField( "Visual-ext_data", offsetof( Visual, ext_data ), sizeof( XExtData * ) );
	swigStructField( "Visual-visualid", offsetof( Visual, visualid ), sizeof( VisualID ) );
	swigStructField( "Visual-green_mask", offsetof( Visual, green_mask ), sizeof( unsigned long ) );
	swigStructField( "Visual-red_mask", offsetof( Visual, red_mask ), sizeof( unsigned long ) );
	swigStructField( "Visual-bits_per_rgb", offsetof( Visual, bits_per_rgb ), sizeof( int ) );
	swigStructField( "Visual-map_entries", offsetof( Visual, map_entries ), sizeof( int ) );
	swigStructField( "Visual-class", offsetof( Visual, class ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( Visual ) );

	swigComment("Depth\n");
	printf( "begin-structure Depth\n" );
	swigStructField( "Depth-nvisuals", offsetof( Depth, nvisuals ), sizeof( int ) );
	swigStructField( "Depth-visuals", offsetof( Depth, visuals ), sizeof( Visual * ) );
	swigStructField( "Depth-depth", offsetof( Depth, depth ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( Depth ) );

	swigComment("Screen\n");
	printf( "begin-structure Screen\n" );
	swigStructField( "Screen-root_depth", offsetof( Screen, root_depth ), sizeof( int ) );
	swigStructField( "Screen-save_unders", offsetof( Screen, save_unders ), sizeof( int ) );
	swigStructField( "Screen-root_input_mask", offsetof( Screen, root_input_mask ), sizeof( long ) );
	swigStructField( "Screen-height", offsetof( Screen, height ), sizeof( int ) );
	swigStructField( "Screen-min_maps", offsetof( Screen, min_maps ), sizeof( int ) );
	swigStructField( "Screen-backing_store", offsetof( Screen, backing_store ), sizeof( int ) );
	swigStructField( "Screen-cmap", offsetof( Screen, cmap ), sizeof( Colormap ) );
	swigStructField( "Screen-root", offsetof( Screen, root ), sizeof( Window ) );
	swigStructField( "Screen-ext_data", offsetof( Screen, ext_data ), sizeof( XExtData * ) );
	swigStructField( "Screen-max_maps", offsetof( Screen, max_maps ), sizeof( int ) );
	swigStructField( "Screen-mheight", offsetof( Screen, mheight ), sizeof( int ) );
	swigStructField( "Screen-depths", offsetof( Screen, depths ), sizeof( Depth * ) );
	swigStructField( "Screen-ndepths", offsetof( Screen, ndepths ), sizeof( int ) );
	swigStructField( "Screen-display", offsetof( Screen, display ), sizeof( struct _XDisplay * ) );
	swigStructField( "Screen-width", offsetof( Screen, width ), sizeof( int ) );
	swigStructField( "Screen-default_gc", offsetof( Screen, default_gc ), sizeof( GC ) );
	swigStructField( "Screen-white_pixel", offsetof( Screen, white_pixel ), sizeof( unsigned long ) );
	swigStructField( "Screen-black_pixel", offsetof( Screen, black_pixel ), sizeof( unsigned long ) );
	swigStructField( "Screen-root_visual", offsetof( Screen, root_visual ), sizeof( Visual * ) );
	swigStructField( "Screen-mwidth", offsetof( Screen, mwidth ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( Screen ) );

	swigComment("ScreenFormat\n");
	printf( "begin-structure ScreenFormat\n" );
	swigStructField( "ScreenFormat-scanline_pad", offsetof( ScreenFormat, scanline_pad ), sizeof( int ) );
	swigStructField( "ScreenFormat-ext_data", offsetof( ScreenFormat, ext_data ), sizeof( XExtData * ) );
	swigStructField( "ScreenFormat-bits_per_pixel", offsetof( ScreenFormat, bits_per_pixel ), sizeof( int ) );
	swigStructField( "ScreenFormat-depth", offsetof( ScreenFormat, depth ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( ScreenFormat ) );

	swigComment("XSetWindowAttributes\n");
	printf( "begin-structure XSetWindowAttributes\n" );
	swigStructField( "XSetWindowAttributes-colormap", offsetof( XSetWindowAttributes, colormap ), sizeof( Colormap ) );
	swigStructField( "XSetWindowAttributes-border_pixmap", offsetof( XSetWindowAttributes, border_pixmap ), sizeof( Pixmap ) );
	swigStructField( "XSetWindowAttributes-background_pixmap", offsetof( XSetWindowAttributes, background_pixmap ), sizeof( Pixmap ) );
	swigStructField( "XSetWindowAttributes-do_not_propagate_mask", offsetof( XSetWindowAttributes, do_not_propagate_mask ), sizeof( long ) );
	swigStructField( "XSetWindowAttributes-win_gravity", offsetof( XSetWindowAttributes, win_gravity ), sizeof( int ) );
	swigStructField( "XSetWindowAttributes-bit_gravity", offsetof( XSetWindowAttributes, bit_gravity ), sizeof( int ) );
	swigStructField( "XSetWindowAttributes-backing_store", offsetof( XSetWindowAttributes, backing_store ), sizeof( int ) );
	swigStructField( "XSetWindowAttributes-cursor", offsetof( XSetWindowAttributes, cursor ), sizeof( Cursor ) );
	swigStructField( "XSetWindowAttributes-border_pixel", offsetof( XSetWindowAttributes, border_pixel ), sizeof( unsigned long ) );
	swigStructField( "XSetWindowAttributes-background_pixel", offsetof( XSetWindowAttributes, background_pixel ), sizeof( unsigned long ) );
	swigStructField( "XSetWindowAttributes-save_under", offsetof( XSetWindowAttributes, save_under ), sizeof( int ) );
	swigStructField( "XSetWindowAttributes-override_redirect", offsetof( XSetWindowAttributes, override_redirect ), sizeof( int ) );
	swigStructField( "XSetWindowAttributes-backing_pixel", offsetof( XSetWindowAttributes, backing_pixel ), sizeof( unsigned long ) );
	swigStructField( "XSetWindowAttributes-backing_planes", offsetof( XSetWindowAttributes, backing_planes ), sizeof( unsigned long ) );
	swigStructField( "XSetWindowAttributes-event_mask", offsetof( XSetWindowAttributes, event_mask ), sizeof( long ) );
	printf( "drop %zu end-structure\n", sizeof( XSetWindowAttributes ) );

	swigComment("XWindowAttributes\n");
	printf( "begin-structure XWindowAttributes\n" );
	swigStructField( "XWindowAttributes-x", offsetof( XWindowAttributes, x ), sizeof( int ) );
	swigStructField( "XWindowAttributes-win_gravity", offsetof( XWindowAttributes, win_gravity ), sizeof( int ) );
	swigStructField( "XWindowAttributes-bit_gravity", offsetof( XWindowAttributes, bit_gravity ), sizeof( int ) );
	swigStructField( "XWindowAttributes-colormap", offsetof( XWindowAttributes, colormap ), sizeof( Colormap ) );
	swigStructField( "XWindowAttributes-do_not_propagate_mask", offsetof( XWindowAttributes, do_not_propagate_mask ), sizeof( long ) );
	swigStructField( "XWindowAttributes-y", offsetof( XWindowAttributes, y ), sizeof( int ) );
	swigStructField( "XWindowAttributes-height", offsetof( XWindowAttributes, height ), sizeof( int ) );
	swigStructField( "XWindowAttributes-backing_store", offsetof( XWindowAttributes, backing_store ), sizeof( int ) );
	swigStructField( "XWindowAttributes-border_width", offsetof( XWindowAttributes, border_width ), sizeof( int ) );
	swigStructField( "XWindowAttributes-root", offsetof( XWindowAttributes, root ), sizeof( Window ) );
	swigStructField( "XWindowAttributes-map_installed", offsetof( XWindowAttributes, map_installed ), sizeof( int ) );
	swigStructField( "XWindowAttributes-class", offsetof( XWindowAttributes, class ), sizeof( int ) );
	swigStructField( "XWindowAttributes-depth", offsetof( XWindowAttributes, depth ), sizeof( int ) );
	swigStructField( "XWindowAttributes-map_state", offsetof( XWindowAttributes, map_state ), sizeof( int ) );
	swigStructField( "XWindowAttributes-visual", offsetof( XWindowAttributes, visual ), sizeof( Visual * ) );
	swigStructField( "XWindowAttributes-width", offsetof( XWindowAttributes, width ), sizeof( int ) );
	swigStructField( "XWindowAttributes-backing_pixel", offsetof( XWindowAttributes, backing_pixel ), sizeof( unsigned long ) );
	swigStructField( "XWindowAttributes-save_under", offsetof( XWindowAttributes, save_under ), sizeof( int ) );
	swigStructField( "XWindowAttributes-override_redirect", offsetof( XWindowAttributes, override_redirect ), sizeof( int ) );
	swigStructField( "XWindowAttributes-backing_planes", offsetof( XWindowAttributes, backing_planes ), sizeof( unsigned long ) );
	swigStructField( "XWindowAttributes-all_event_masks", offsetof( XWindowAttributes, all_event_masks ), sizeof( long ) );
	swigStructField( "XWindowAttributes-your_event_mask", offsetof( XWindowAttributes, your_event_mask ), sizeof( long ) );
	swigStructField( "XWindowAttributes-screen", offsetof( XWindowAttributes, screen ), sizeof( Screen * ) );
	printf( "drop %zu end-structure\n", sizeof( XWindowAttributes ) );

	swigComment("XHostAddress\n");
	printf( "begin-structure XHostAddress\n" );
	swigStructField( "XHostAddress-length", offsetof( XHostAddress, length ), sizeof( int ) );
	swigStructField( "XHostAddress-address", offsetof( XHostAddress, address ), sizeof( char * ) );
	swigStructField( "XHostAddress-family", offsetof( XHostAddress, family ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( XHostAddress ) );

	swigComment("XServerInterpretedAddress\n");
	printf( "begin-structure XServerInterpretedAddress\n" );
	swigStructField( "XServerInterpretedAddress-typelength", offsetof( XServerInterpretedAddress, typelength ), sizeof( int ) );
	swigStructField( "XServerInterpretedAddress-valuelength", offsetof( XServerInterpretedAddress, valuelength ), sizeof( int ) );
	swigStructField( "XServerInterpretedAddress-value", offsetof( XServerInterpretedAddress, value ), sizeof( char * ) );
	swigStructField( "XServerInterpretedAddress-type", offsetof( XServerInterpretedAddress, type ), sizeof( char * ) );
	printf( "drop %zu end-structure\n", sizeof( XServerInterpretedAddress ) );

	swigComment("struct _XImage\n");
	printf( "begin-structure XImage\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _XImage ) );

	swigComment("struct funcs\n");
	printf( "begin-structure funcs\n" );
	swigStructField( "funcs-create_image", offsetof( struct funcs, create_image ), sizeof( struct _XImage *(*)(struct _XDisplay *,Visual *,unsigned int,int,int,char *,unsigned int,unsigned int,int,int) ) );
	swigStructField( "funcs-destroy_image", offsetof( struct funcs, destroy_image ), sizeof( int (*)(struct _XImage *) ) );
	swigStructField( "funcs-get_pixel", offsetof( struct funcs, get_pixel ), sizeof( unsigned long (*)(struct _XImage *,int,int) ) );
	swigStructField( "funcs-put_pixel", offsetof( struct funcs, put_pixel ), sizeof( int (*)(struct _XImage *,int,int,unsigned long) ) );
	swigStructField( "funcs-add_pixel", offsetof( struct funcs, add_pixel ), sizeof( int (*)(struct _XImage *,long) ) );
	swigStructField( "funcs-sub_image", offsetof( struct funcs, sub_image ), sizeof( struct _XImage *(*)(struct _XImage *,int,int,unsigned int,unsigned int) ) );
	printf( "drop %zu end-structure\n", sizeof( struct funcs ) );

	swigComment("XWindowChanges\n");
	printf( "begin-structure XWindowChanges\n" );
	swigStructField( "XWindowChanges-x", offsetof( XWindowChanges, x ), sizeof( int ) );
	swigStructField( "XWindowChanges-y", offsetof( XWindowChanges, y ), sizeof( int ) );
	swigStructField( "XWindowChanges-stack_mode", offsetof( XWindowChanges, stack_mode ), sizeof( int ) );
	swigStructField( "XWindowChanges-height", offsetof( XWindowChanges, height ), sizeof( int ) );
	swigStructField( "XWindowChanges-border_width", offsetof( XWindowChanges, border_width ), sizeof( int ) );
	swigStructField( "XWindowChanges-sibling", offsetof( XWindowChanges, sibling ), sizeof( Window ) );
	swigStructField( "XWindowChanges-width", offsetof( XWindowChanges, width ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( XWindowChanges ) );

	swigComment("XColor\n");
	printf( "begin-structure XColor\n" );
	swigStructField( "XColor-blue", offsetof( XColor, blue ), sizeof( unsigned short ) );
	swigStructField( "XColor-pixel", offsetof( XColor, pixel ), sizeof( unsigned long ) );
	swigStructField( "XColor-green", offsetof( XColor, green ), sizeof( unsigned short ) );
	swigStructField( "XColor-red", offsetof( XColor, red ), sizeof( unsigned short ) );
	swigStructField( "XColor-flags", offsetof( XColor, flags ), sizeof( char ) );
	swigStructField( "XColor-pad", offsetof( XColor, pad ), sizeof( char ) );
	printf( "drop %zu end-structure\n", sizeof( XColor ) );

	swigComment("XSegment\n");
	printf( "begin-structure XSegment\n" );
	swigStructField( "XSegment-y1", offsetof( XSegment, y1 ), sizeof( short ) );
	swigStructField( "XSegment-y2", offsetof( XSegment, y2 ), sizeof( short ) );
	swigStructField( "XSegment-x1", offsetof( XSegment, x1 ), sizeof( short ) );
	swigStructField( "XSegment-x2", offsetof( XSegment, x2 ), sizeof( short ) );
	printf( "drop %zu end-structure\n", sizeof( XSegment ) );

	swigComment("XPoint\n");
	printf( "begin-structure XPoint\n" );
	swigStructField( "XPoint-x", offsetof( XPoint, x ), sizeof( short ) );
	swigStructField( "XPoint-y", offsetof( XPoint, y ), sizeof( short ) );
	printf( "drop %zu end-structure\n", sizeof( XPoint ) );

	swigComment("XRectangle\n");
	printf( "begin-structure XRectangle\n" );
	swigStructField( "XRectangle-x", offsetof( XRectangle, x ), sizeof( short ) );
	swigStructField( "XRectangle-y", offsetof( XRectangle, y ), sizeof( short ) );
	swigStructField( "XRectangle-height", offsetof( XRectangle, height ), sizeof( unsigned short ) );
	swigStructField( "XRectangle-width", offsetof( XRectangle, width ), sizeof( unsigned short ) );
	printf( "drop %zu end-structure\n", sizeof( XRectangle ) );

	swigComment("XArc\n");
	printf( "begin-structure XArc\n" );
	swigStructField( "XArc-x", offsetof( XArc, x ), sizeof( short ) );
	swigStructField( "XArc-y", offsetof( XArc, y ), sizeof( short ) );
	swigStructField( "XArc-height", offsetof( XArc, height ), sizeof( unsigned short ) );
	swigStructField( "XArc-angle1", offsetof( XArc, angle1 ), sizeof( short ) );
	swigStructField( "XArc-width", offsetof( XArc, width ), sizeof( unsigned short ) );
	swigStructField( "XArc-angle2", offsetof( XArc, angle2 ), sizeof( short ) );
	printf( "drop %zu end-structure\n", sizeof( XArc ) );

	swigComment("XKeyboardControl\n");
	printf( "begin-structure XKeyboardControl\n" );
	swigStructField( "XKeyboardControl-key_click_percent", offsetof( XKeyboardControl, key_click_percent ), sizeof( int ) );
	swigStructField( "XKeyboardControl-bell_percent", offsetof( XKeyboardControl, bell_percent ), sizeof( int ) );
	swigStructField( "XKeyboardControl-bell_duration", offsetof( XKeyboardControl, bell_duration ), sizeof( int ) );
	swigStructField( "XKeyboardControl-led_mode", offsetof( XKeyboardControl, led_mode ), sizeof( int ) );
	swigStructField( "XKeyboardControl-bell_pitch", offsetof( XKeyboardControl, bell_pitch ), sizeof( int ) );
	swigStructField( "XKeyboardControl-key", offsetof( XKeyboardControl, key ), sizeof( int ) );
	swigStructField( "XKeyboardControl-led", offsetof( XKeyboardControl, led ), sizeof( int ) );
	swigStructField( "XKeyboardControl-auto_repeat_mode", offsetof( XKeyboardControl, auto_repeat_mode ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( XKeyboardControl ) );

	swigComment("XKeyboardState\n");
	printf( "begin-structure XKeyboardState\n" );
	swigStructField( "XKeyboardState-key_click_percent", offsetof( XKeyboardState, key_click_percent ), sizeof( int ) );
	swigStructField( "XKeyboardState-bell_percent", offsetof( XKeyboardState, bell_percent ), sizeof( int ) );
	swigStructField( "XKeyboardState-bell_duration", offsetof( XKeyboardState, bell_duration ), sizeof( unsigned int ) );
	swigStructField( "XKeyboardState-bell_pitch", offsetof( XKeyboardState, bell_pitch ), sizeof( unsigned int ) );
	swigStructField( "XKeyboardState-auto_repeats", offsetof( XKeyboardState, auto_repeats ), sizeof( char [32] ) );
	swigStructField( "XKeyboardState-led_mask", offsetof( XKeyboardState, led_mask ), sizeof( unsigned long ) );
	swigStructField( "XKeyboardState-global_auto_repeat", offsetof( XKeyboardState, global_auto_repeat ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( XKeyboardState ) );

	swigComment("XTimeCoord\n");
	printf( "begin-structure XTimeCoord\n" );
	swigStructField( "XTimeCoord-x", offsetof( XTimeCoord, x ), sizeof( short ) );
	swigStructField( "XTimeCoord-time", offsetof( XTimeCoord, time ), sizeof( Time ) );
	swigStructField( "XTimeCoord-y", offsetof( XTimeCoord, y ), sizeof( short ) );
	printf( "drop %zu end-structure\n", sizeof( XTimeCoord ) );

	swigComment("XModifierKeymap\n");
	printf( "begin-structure XModifierKeymap\n" );
	swigStructField( "XModifierKeymap-modifiermap", offsetof( XModifierKeymap, modifiermap ), sizeof( KeyCode * ) );
	swigStructField( "XModifierKeymap-max_keypermod", offsetof( XModifierKeymap, max_keypermod ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( XModifierKeymap ) );

	swigComment("XKeyEvent\n");
	printf( "begin-structure XKeyEvent\n" );
	swigStructField( "XKeyEvent-subwindow", offsetof( XKeyEvent, subwindow ), sizeof( Window ) );
	swigStructField( "XKeyEvent-window", offsetof( XKeyEvent, window ), sizeof( Window ) );
	swigStructField( "XKeyEvent-serial", offsetof( XKeyEvent, serial ), sizeof( unsigned long ) );
	swigStructField( "XKeyEvent-x", offsetof( XKeyEvent, x ), sizeof( int ) );
	swigStructField( "XKeyEvent-y", offsetof( XKeyEvent, y ), sizeof( int ) );
	swigStructField( "XKeyEvent-same_screen", offsetof( XKeyEvent, same_screen ), sizeof( int ) );
	swigStructField( "XKeyEvent-keycode", offsetof( XKeyEvent, keycode ), sizeof( unsigned int ) );
	swigStructField( "XKeyEvent-x_root", offsetof( XKeyEvent, x_root ), sizeof( int ) );
	swigStructField( "XKeyEvent-time", offsetof( XKeyEvent, time ), sizeof( Time ) );
	swigStructField( "XKeyEvent-root", offsetof( XKeyEvent, root ), sizeof( Window ) );
	swigStructField( "XKeyEvent-y_root", offsetof( XKeyEvent, y_root ), sizeof( int ) );
	swigStructField( "XKeyEvent-display", offsetof( XKeyEvent, display ), sizeof( Display * ) );
	swigStructField( "XKeyEvent-type", offsetof( XKeyEvent, type ), sizeof( int ) );
	swigStructField( "XKeyEvent-state", offsetof( XKeyEvent, state ), sizeof( unsigned int ) );
	swigStructField( "XKeyEvent-send_event", offsetof( XKeyEvent, send_event ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( XKeyEvent ) );

	swigComment("XButtonEvent\n");
	printf( "begin-structure XButtonEvent\n" );
	swigStructField( "XButtonEvent-subwindow", offsetof( XButtonEvent, subwindow ), sizeof( Window ) );
	swigStructField( "XButtonEvent-window", offsetof( XButtonEvent, window ), sizeof( Window ) );
	swigStructField( "XButtonEvent-serial", offsetof( XButtonEvent, serial ), sizeof( unsigned long ) );
	swigStructField( "XButtonEvent-x", offsetof( XButtonEvent, x ), sizeof( int ) );
	swigStructField( "XButtonEvent-y", offsetof( XButtonEvent, y ), sizeof( int ) );
	swigStructField( "XButtonEvent-same_screen", offsetof( XButtonEvent, same_screen ), sizeof( int ) );
	swigStructField( "XButtonEvent-button", offsetof( XButtonEvent, button ), sizeof( unsigned int ) );
	swigStructField( "XButtonEvent-x_root", offsetof( XButtonEvent, x_root ), sizeof( int ) );
	swigStructField( "XButtonEvent-time", offsetof( XButtonEvent, time ), sizeof( Time ) );
	swigStructField( "XButtonEvent-root", offsetof( XButtonEvent, root ), sizeof( Window ) );
	swigStructField( "XButtonEvent-y_root", offsetof( XButtonEvent, y_root ), sizeof( int ) );
	swigStructField( "XButtonEvent-display", offsetof( XButtonEvent, display ), sizeof( Display * ) );
	swigStructField( "XButtonEvent-type", offsetof( XButtonEvent, type ), sizeof( int ) );
	swigStructField( "XButtonEvent-state", offsetof( XButtonEvent, state ), sizeof( unsigned int ) );
	swigStructField( "XButtonEvent-send_event", offsetof( XButtonEvent, send_event ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( XButtonEvent ) );

	swigComment("XMotionEvent\n");
	printf( "begin-structure XMotionEvent\n" );
	swigStructField( "XMotionEvent-subwindow", offsetof( XMotionEvent, subwindow ), sizeof( Window ) );
	swigStructField( "XMotionEvent-window", offsetof( XMotionEvent, window ), sizeof( Window ) );
	swigStructField( "XMotionEvent-serial", offsetof( XMotionEvent, serial ), sizeof( unsigned long ) );
	swigStructField( "XMotionEvent-x", offsetof( XMotionEvent, x ), sizeof( int ) );
	swigStructField( "XMotionEvent-y", offsetof( XMotionEvent, y ), sizeof( int ) );
	swigStructField( "XMotionEvent-same_screen", offsetof( XMotionEvent, same_screen ), sizeof( int ) );
	swigStructField( "XMotionEvent-x_root", offsetof( XMotionEvent, x_root ), sizeof( int ) );
	swigStructField( "XMotionEvent-time", offsetof( XMotionEvent, time ), sizeof( Time ) );
	swigStructField( "XMotionEvent-root", offsetof( XMotionEvent, root ), sizeof( Window ) );
	swigStructField( "XMotionEvent-is_hint", offsetof( XMotionEvent, is_hint ), sizeof( char ) );
	swigStructField( "XMotionEvent-y_root", offsetof( XMotionEvent, y_root ), sizeof( int ) );
	swigStructField( "XMotionEvent-display", offsetof( XMotionEvent, display ), sizeof( Display * ) );
	swigStructField( "XMotionEvent-type", offsetof( XMotionEvent, type ), sizeof( int ) );
	swigStructField( "XMotionEvent-state", offsetof( XMotionEvent, state ), sizeof( unsigned int ) );
	swigStructField( "XMotionEvent-send_event", offsetof( XMotionEvent, send_event ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( XMotionEvent ) );

	swigComment("XCrossingEvent\n");
	printf( "begin-structure XCrossingEvent\n" );
	swigStructField( "XCrossingEvent-mode", offsetof( XCrossingEvent, mode ), sizeof( int ) );
	swigStructField( "XCrossingEvent-subwindow", offsetof( XCrossingEvent, subwindow ), sizeof( Window ) );
	swigStructField( "XCrossingEvent-window", offsetof( XCrossingEvent, window ), sizeof( Window ) );
	swigStructField( "XCrossingEvent-serial", offsetof( XCrossingEvent, serial ), sizeof( unsigned long ) );
	swigStructField( "XCrossingEvent-x", offsetof( XCrossingEvent, x ), sizeof( int ) );
	swigStructField( "XCrossingEvent-focus", offsetof( XCrossingEvent, focus ), sizeof( int ) );
	swigStructField( "XCrossingEvent-y", offsetof( XCrossingEvent, y ), sizeof( int ) );
	swigStructField( "XCrossingEvent-same_screen", offsetof( XCrossingEvent, same_screen ), sizeof( int ) );
	swigStructField( "XCrossingEvent-x_root", offsetof( XCrossingEvent, x_root ), sizeof( int ) );
	swigStructField( "XCrossingEvent-time", offsetof( XCrossingEvent, time ), sizeof( Time ) );
	swigStructField( "XCrossingEvent-root", offsetof( XCrossingEvent, root ), sizeof( Window ) );
	swigStructField( "XCrossingEvent-y_root", offsetof( XCrossingEvent, y_root ), sizeof( int ) );
	swigStructField( "XCrossingEvent-display", offsetof( XCrossingEvent, display ), sizeof( Display * ) );
	swigStructField( "XCrossingEvent-detail", offsetof( XCrossingEvent, detail ), sizeof( int ) );
	swigStructField( "XCrossingEvent-type", offsetof( XCrossingEvent, type ), sizeof( int ) );
	swigStructField( "XCrossingEvent-state", offsetof( XCrossingEvent, state ), sizeof( unsigned int ) );
	swigStructField( "XCrossingEvent-send_event", offsetof( XCrossingEvent, send_event ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( XCrossingEvent ) );

	swigComment("XFocusChangeEvent\n");
	printf( "begin-structure XFocusChangeEvent\n" );
	swigStructField( "XFocusChangeEvent-display", offsetof( XFocusChangeEvent, display ), sizeof( Display * ) );
	swigStructField( "XFocusChangeEvent-serial", offsetof( XFocusChangeEvent, serial ), sizeof( unsigned long ) );
	swigStructField( "XFocusChangeEvent-window", offsetof( XFocusChangeEvent, window ), sizeof( Window ) );
	swigStructField( "XFocusChangeEvent-type", offsetof( XFocusChangeEvent, type ), sizeof( int ) );
	swigStructField( "XFocusChangeEvent-send_event", offsetof( XFocusChangeEvent, send_event ), sizeof( int ) );
	swigStructField( "XFocusChangeEvent-detail", offsetof( XFocusChangeEvent, detail ), sizeof( int ) );
	swigStructField( "XFocusChangeEvent-mode", offsetof( XFocusChangeEvent, mode ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( XFocusChangeEvent ) );

	swigComment("XKeymapEvent\n");
	printf( "begin-structure XKeymapEvent\n" );
	swigStructField( "XKeymapEvent-display", offsetof( XKeymapEvent, display ), sizeof( Display * ) );
	swigStructField( "XKeymapEvent-key_vector", offsetof( XKeymapEvent, key_vector ), sizeof( char [32] ) );
	swigStructField( "XKeymapEvent-serial", offsetof( XKeymapEvent, serial ), sizeof( unsigned long ) );
	swigStructField( "XKeymapEvent-window", offsetof( XKeymapEvent, window ), sizeof( Window ) );
	swigStructField( "XKeymapEvent-type", offsetof( XKeymapEvent, type ), sizeof( int ) );
	swigStructField( "XKeymapEvent-send_event", offsetof( XKeymapEvent, send_event ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( XKeymapEvent ) );

	swigComment("XExposeEvent\n");
	printf( "begin-structure XExposeEvent\n" );
	swigStructField( "XExposeEvent-display", offsetof( XExposeEvent, display ), sizeof( Display * ) );
	swigStructField( "XExposeEvent-x", offsetof( XExposeEvent, x ), sizeof( int ) );
	swigStructField( "XExposeEvent-y", offsetof( XExposeEvent, y ), sizeof( int ) );
	swigStructField( "XExposeEvent-count", offsetof( XExposeEvent, count ), sizeof( int ) );
	swigStructField( "XExposeEvent-serial", offsetof( XExposeEvent, serial ), sizeof( unsigned long ) );
	swigStructField( "XExposeEvent-window", offsetof( XExposeEvent, window ), sizeof( Window ) );
	swigStructField( "XExposeEvent-type", offsetof( XExposeEvent, type ), sizeof( int ) );
	swigStructField( "XExposeEvent-height", offsetof( XExposeEvent, height ), sizeof( int ) );
	swigStructField( "XExposeEvent-send_event", offsetof( XExposeEvent, send_event ), sizeof( int ) );
	swigStructField( "XExposeEvent-width", offsetof( XExposeEvent, width ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( XExposeEvent ) );

	swigComment("XGraphicsExposeEvent\n");
	printf( "begin-structure XGraphicsExposeEvent\n" );
	swigStructField( "XGraphicsExposeEvent-display", offsetof( XGraphicsExposeEvent, display ), sizeof( Display * ) );
	swigStructField( "XGraphicsExposeEvent-x", offsetof( XGraphicsExposeEvent, x ), sizeof( int ) );
	swigStructField( "XGraphicsExposeEvent-y", offsetof( XGraphicsExposeEvent, y ), sizeof( int ) );
	swigStructField( "XGraphicsExposeEvent-count", offsetof( XGraphicsExposeEvent, count ), sizeof( int ) );
	swigStructField( "XGraphicsExposeEvent-serial", offsetof( XGraphicsExposeEvent, serial ), sizeof( unsigned long ) );
	swigStructField( "XGraphicsExposeEvent-drawable", offsetof( XGraphicsExposeEvent, drawable ), sizeof( Drawable ) );
	swigStructField( "XGraphicsExposeEvent-type", offsetof( XGraphicsExposeEvent, type ), sizeof( int ) );
	swigStructField( "XGraphicsExposeEvent-height", offsetof( XGraphicsExposeEvent, height ), sizeof( int ) );
	swigStructField( "XGraphicsExposeEvent-send_event", offsetof( XGraphicsExposeEvent, send_event ), sizeof( int ) );
	swigStructField( "XGraphicsExposeEvent-width", offsetof( XGraphicsExposeEvent, width ), sizeof( int ) );
	swigStructField( "XGraphicsExposeEvent-major_code", offsetof( XGraphicsExposeEvent, major_code ), sizeof( int ) );
	swigStructField( "XGraphicsExposeEvent-minor_code", offsetof( XGraphicsExposeEvent, minor_code ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( XGraphicsExposeEvent ) );

	swigComment("XNoExposeEvent\n");
	printf( "begin-structure XNoExposeEvent\n" );
	swigStructField( "XNoExposeEvent-display", offsetof( XNoExposeEvent, display ), sizeof( Display * ) );
	swigStructField( "XNoExposeEvent-serial", offsetof( XNoExposeEvent, serial ), sizeof( unsigned long ) );
	swigStructField( "XNoExposeEvent-drawable", offsetof( XNoExposeEvent, drawable ), sizeof( Drawable ) );
	swigStructField( "XNoExposeEvent-type", offsetof( XNoExposeEvent, type ), sizeof( int ) );
	swigStructField( "XNoExposeEvent-send_event", offsetof( XNoExposeEvent, send_event ), sizeof( int ) );
	swigStructField( "XNoExposeEvent-major_code", offsetof( XNoExposeEvent, major_code ), sizeof( int ) );
	swigStructField( "XNoExposeEvent-minor_code", offsetof( XNoExposeEvent, minor_code ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( XNoExposeEvent ) );

	swigComment("XVisibilityEvent\n");
	printf( "begin-structure XVisibilityEvent\n" );
	swigStructField( "XVisibilityEvent-display", offsetof( XVisibilityEvent, display ), sizeof( Display * ) );
	swigStructField( "XVisibilityEvent-serial", offsetof( XVisibilityEvent, serial ), sizeof( unsigned long ) );
	swigStructField( "XVisibilityEvent-window", offsetof( XVisibilityEvent, window ), sizeof( Window ) );
	swigStructField( "XVisibilityEvent-type", offsetof( XVisibilityEvent, type ), sizeof( int ) );
	swigStructField( "XVisibilityEvent-send_event", offsetof( XVisibilityEvent, send_event ), sizeof( int ) );
	swigStructField( "XVisibilityEvent-state", offsetof( XVisibilityEvent, state ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( XVisibilityEvent ) );

	swigComment("XCreateWindowEvent\n");
	printf( "begin-structure XCreateWindowEvent\n" );
	swigStructField( "XCreateWindowEvent-display", offsetof( XCreateWindowEvent, display ), sizeof( Display * ) );
	swigStructField( "XCreateWindowEvent-x", offsetof( XCreateWindowEvent, x ), sizeof( int ) );
	swigStructField( "XCreateWindowEvent-y", offsetof( XCreateWindowEvent, y ), sizeof( int ) );
	swigStructField( "XCreateWindowEvent-serial", offsetof( XCreateWindowEvent, serial ), sizeof( unsigned long ) );
	swigStructField( "XCreateWindowEvent-window", offsetof( XCreateWindowEvent, window ), sizeof( Window ) );
	swigStructField( "XCreateWindowEvent-override_redirect", offsetof( XCreateWindowEvent, override_redirect ), sizeof( int ) );
	swigStructField( "XCreateWindowEvent-type", offsetof( XCreateWindowEvent, type ), sizeof( int ) );
	swigStructField( "XCreateWindowEvent-height", offsetof( XCreateWindowEvent, height ), sizeof( int ) );
	swigStructField( "XCreateWindowEvent-border_width", offsetof( XCreateWindowEvent, border_width ), sizeof( int ) );
	swigStructField( "XCreateWindowEvent-send_event", offsetof( XCreateWindowEvent, send_event ), sizeof( int ) );
	swigStructField( "XCreateWindowEvent-parent", offsetof( XCreateWindowEvent, parent ), sizeof( Window ) );
	swigStructField( "XCreateWindowEvent-width", offsetof( XCreateWindowEvent, width ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( XCreateWindowEvent ) );

	swigComment("XDestroyWindowEvent\n");
	printf( "begin-structure XDestroyWindowEvent\n" );
	swigStructField( "XDestroyWindowEvent-display", offsetof( XDestroyWindowEvent, display ), sizeof( Display * ) );
	swigStructField( "XDestroyWindowEvent-serial", offsetof( XDestroyWindowEvent, serial ), sizeof( unsigned long ) );
	swigStructField( "XDestroyWindowEvent-window", offsetof( XDestroyWindowEvent, window ), sizeof( Window ) );
	swigStructField( "XDestroyWindowEvent-type", offsetof( XDestroyWindowEvent, type ), sizeof( int ) );
	swigStructField( "XDestroyWindowEvent-send_event", offsetof( XDestroyWindowEvent, send_event ), sizeof( int ) );
	swigStructField( "XDestroyWindowEvent-event", offsetof( XDestroyWindowEvent, event ), sizeof( Window ) );
	printf( "drop %zu end-structure\n", sizeof( XDestroyWindowEvent ) );

	swigComment("XUnmapEvent\n");
	printf( "begin-structure XUnmapEvent\n" );
	swigStructField( "XUnmapEvent-display", offsetof( XUnmapEvent, display ), sizeof( Display * ) );
	swigStructField( "XUnmapEvent-serial", offsetof( XUnmapEvent, serial ), sizeof( unsigned long ) );
	swigStructField( "XUnmapEvent-window", offsetof( XUnmapEvent, window ), sizeof( Window ) );
	swigStructField( "XUnmapEvent-type", offsetof( XUnmapEvent, type ), sizeof( int ) );
	swigStructField( "XUnmapEvent-from_configure", offsetof( XUnmapEvent, from_configure ), sizeof( int ) );
	swigStructField( "XUnmapEvent-send_event", offsetof( XUnmapEvent, send_event ), sizeof( int ) );
	swigStructField( "XUnmapEvent-event", offsetof( XUnmapEvent, event ), sizeof( Window ) );
	printf( "drop %zu end-structure\n", sizeof( XUnmapEvent ) );

	swigComment("XMapEvent\n");
	printf( "begin-structure XMapEvent\n" );
	swigStructField( "XMapEvent-display", offsetof( XMapEvent, display ), sizeof( Display * ) );
	swigStructField( "XMapEvent-serial", offsetof( XMapEvent, serial ), sizeof( unsigned long ) );
	swigStructField( "XMapEvent-window", offsetof( XMapEvent, window ), sizeof( Window ) );
	swigStructField( "XMapEvent-override_redirect", offsetof( XMapEvent, override_redirect ), sizeof( int ) );
	swigStructField( "XMapEvent-type", offsetof( XMapEvent, type ), sizeof( int ) );
	swigStructField( "XMapEvent-send_event", offsetof( XMapEvent, send_event ), sizeof( int ) );
	swigStructField( "XMapEvent-event", offsetof( XMapEvent, event ), sizeof( Window ) );
	printf( "drop %zu end-structure\n", sizeof( XMapEvent ) );

	swigComment("XMapRequestEvent\n");
	printf( "begin-structure XMapRequestEvent\n" );
	swigStructField( "XMapRequestEvent-display", offsetof( XMapRequestEvent, display ), sizeof( Display * ) );
	swigStructField( "XMapRequestEvent-serial", offsetof( XMapRequestEvent, serial ), sizeof( unsigned long ) );
	swigStructField( "XMapRequestEvent-window", offsetof( XMapRequestEvent, window ), sizeof( Window ) );
	swigStructField( "XMapRequestEvent-type", offsetof( XMapRequestEvent, type ), sizeof( int ) );
	swigStructField( "XMapRequestEvent-send_event", offsetof( XMapRequestEvent, send_event ), sizeof( int ) );
	swigStructField( "XMapRequestEvent-parent", offsetof( XMapRequestEvent, parent ), sizeof( Window ) );
	printf( "drop %zu end-structure\n", sizeof( XMapRequestEvent ) );

	swigComment("XReparentEvent\n");
	printf( "begin-structure XReparentEvent\n" );
	swigStructField( "XReparentEvent-display", offsetof( XReparentEvent, display ), sizeof( Display * ) );
	swigStructField( "XReparentEvent-x", offsetof( XReparentEvent, x ), sizeof( int ) );
	swigStructField( "XReparentEvent-y", offsetof( XReparentEvent, y ), sizeof( int ) );
	swigStructField( "XReparentEvent-serial", offsetof( XReparentEvent, serial ), sizeof( unsigned long ) );
	swigStructField( "XReparentEvent-window", offsetof( XReparentEvent, window ), sizeof( Window ) );
	swigStructField( "XReparentEvent-override_redirect", offsetof( XReparentEvent, override_redirect ), sizeof( int ) );
	swigStructField( "XReparentEvent-type", offsetof( XReparentEvent, type ), sizeof( int ) );
	swigStructField( "XReparentEvent-send_event", offsetof( XReparentEvent, send_event ), sizeof( int ) );
	swigStructField( "XReparentEvent-parent", offsetof( XReparentEvent, parent ), sizeof( Window ) );
	swigStructField( "XReparentEvent-event", offsetof( XReparentEvent, event ), sizeof( Window ) );
	printf( "drop %zu end-structure\n", sizeof( XReparentEvent ) );

	swigComment("XConfigureEvent\n");
	printf( "begin-structure XConfigureEvent\n" );
	swigStructField( "XConfigureEvent-display", offsetof( XConfigureEvent, display ), sizeof( Display * ) );
	swigStructField( "XConfigureEvent-above", offsetof( XConfigureEvent, above ), sizeof( Window ) );
	swigStructField( "XConfigureEvent-x", offsetof( XConfigureEvent, x ), sizeof( int ) );
	swigStructField( "XConfigureEvent-y", offsetof( XConfigureEvent, y ), sizeof( int ) );
	swigStructField( "XConfigureEvent-serial", offsetof( XConfigureEvent, serial ), sizeof( unsigned long ) );
	swigStructField( "XConfigureEvent-window", offsetof( XConfigureEvent, window ), sizeof( Window ) );
	swigStructField( "XConfigureEvent-override_redirect", offsetof( XConfigureEvent, override_redirect ), sizeof( int ) );
	swigStructField( "XConfigureEvent-type", offsetof( XConfigureEvent, type ), sizeof( int ) );
	swigStructField( "XConfigureEvent-height", offsetof( XConfigureEvent, height ), sizeof( int ) );
	swigStructField( "XConfigureEvent-border_width", offsetof( XConfigureEvent, border_width ), sizeof( int ) );
	swigStructField( "XConfigureEvent-send_event", offsetof( XConfigureEvent, send_event ), sizeof( int ) );
	swigStructField( "XConfigureEvent-width", offsetof( XConfigureEvent, width ), sizeof( int ) );
	swigStructField( "XConfigureEvent-event", offsetof( XConfigureEvent, event ), sizeof( Window ) );
	printf( "drop %zu end-structure\n", sizeof( XConfigureEvent ) );

	swigComment("XGravityEvent\n");
	printf( "begin-structure XGravityEvent\n" );
	swigStructField( "XGravityEvent-display", offsetof( XGravityEvent, display ), sizeof( Display * ) );
	swigStructField( "XGravityEvent-x", offsetof( XGravityEvent, x ), sizeof( int ) );
	swigStructField( "XGravityEvent-y", offsetof( XGravityEvent, y ), sizeof( int ) );
	swigStructField( "XGravityEvent-serial", offsetof( XGravityEvent, serial ), sizeof( unsigned long ) );
	swigStructField( "XGravityEvent-window", offsetof( XGravityEvent, window ), sizeof( Window ) );
	swigStructField( "XGravityEvent-type", offsetof( XGravityEvent, type ), sizeof( int ) );
	swigStructField( "XGravityEvent-send_event", offsetof( XGravityEvent, send_event ), sizeof( int ) );
	swigStructField( "XGravityEvent-event", offsetof( XGravityEvent, event ), sizeof( Window ) );
	printf( "drop %zu end-structure\n", sizeof( XGravityEvent ) );

	swigComment("XResizeRequestEvent\n");
	printf( "begin-structure XResizeRequestEvent\n" );
	swigStructField( "XResizeRequestEvent-display", offsetof( XResizeRequestEvent, display ), sizeof( Display * ) );
	swigStructField( "XResizeRequestEvent-serial", offsetof( XResizeRequestEvent, serial ), sizeof( unsigned long ) );
	swigStructField( "XResizeRequestEvent-window", offsetof( XResizeRequestEvent, window ), sizeof( Window ) );
	swigStructField( "XResizeRequestEvent-type", offsetof( XResizeRequestEvent, type ), sizeof( int ) );
	swigStructField( "XResizeRequestEvent-height", offsetof( XResizeRequestEvent, height ), sizeof( int ) );
	swigStructField( "XResizeRequestEvent-send_event", offsetof( XResizeRequestEvent, send_event ), sizeof( int ) );
	swigStructField( "XResizeRequestEvent-width", offsetof( XResizeRequestEvent, width ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( XResizeRequestEvent ) );

	swigComment("XConfigureRequestEvent\n");
	printf( "begin-structure XConfigureRequestEvent\n" );
	swigStructField( "XConfigureRequestEvent-window", offsetof( XConfigureRequestEvent, window ), sizeof( Window ) );
	swigStructField( "XConfigureRequestEvent-serial", offsetof( XConfigureRequestEvent, serial ), sizeof( unsigned long ) );
	swigStructField( "XConfigureRequestEvent-x", offsetof( XConfigureRequestEvent, x ), sizeof( int ) );
	swigStructField( "XConfigureRequestEvent-y", offsetof( XConfigureRequestEvent, y ), sizeof( int ) );
	swigStructField( "XConfigureRequestEvent-height", offsetof( XConfigureRequestEvent, height ), sizeof( int ) );
	swigStructField( "XConfigureRequestEvent-border_width", offsetof( XConfigureRequestEvent, border_width ), sizeof( int ) );
	swigStructField( "XConfigureRequestEvent-value_mask", offsetof( XConfigureRequestEvent, value_mask ), sizeof( unsigned long ) );
	swigStructField( "XConfigureRequestEvent-above", offsetof( XConfigureRequestEvent, above ), sizeof( Window ) );
	swigStructField( "XConfigureRequestEvent-display", offsetof( XConfigureRequestEvent, display ), sizeof( Display * ) );
	swigStructField( "XConfigureRequestEvent-detail", offsetof( XConfigureRequestEvent, detail ), sizeof( int ) );
	swigStructField( "XConfigureRequestEvent-width", offsetof( XConfigureRequestEvent, width ), sizeof( int ) );
	swigStructField( "XConfigureRequestEvent-type", offsetof( XConfigureRequestEvent, type ), sizeof( int ) );
	swigStructField( "XConfigureRequestEvent-send_event", offsetof( XConfigureRequestEvent, send_event ), sizeof( int ) );
	swigStructField( "XConfigureRequestEvent-parent", offsetof( XConfigureRequestEvent, parent ), sizeof( Window ) );
	printf( "drop %zu end-structure\n", sizeof( XConfigureRequestEvent ) );

	swigComment("XCirculateEvent\n");
	printf( "begin-structure XCirculateEvent\n" );
	swigStructField( "XCirculateEvent-display", offsetof( XCirculateEvent, display ), sizeof( Display * ) );
	swigStructField( "XCirculateEvent-place", offsetof( XCirculateEvent, place ), sizeof( int ) );
	swigStructField( "XCirculateEvent-serial", offsetof( XCirculateEvent, serial ), sizeof( unsigned long ) );
	swigStructField( "XCirculateEvent-window", offsetof( XCirculateEvent, window ), sizeof( Window ) );
	swigStructField( "XCirculateEvent-type", offsetof( XCirculateEvent, type ), sizeof( int ) );
	swigStructField( "XCirculateEvent-send_event", offsetof( XCirculateEvent, send_event ), sizeof( int ) );
	swigStructField( "XCirculateEvent-event", offsetof( XCirculateEvent, event ), sizeof( Window ) );
	printf( "drop %zu end-structure\n", sizeof( XCirculateEvent ) );

	swigComment("XCirculateRequestEvent\n");
	printf( "begin-structure XCirculateRequestEvent\n" );
	swigStructField( "XCirculateRequestEvent-display", offsetof( XCirculateRequestEvent, display ), sizeof( Display * ) );
	swigStructField( "XCirculateRequestEvent-place", offsetof( XCirculateRequestEvent, place ), sizeof( int ) );
	swigStructField( "XCirculateRequestEvent-serial", offsetof( XCirculateRequestEvent, serial ), sizeof( unsigned long ) );
	swigStructField( "XCirculateRequestEvent-window", offsetof( XCirculateRequestEvent, window ), sizeof( Window ) );
	swigStructField( "XCirculateRequestEvent-type", offsetof( XCirculateRequestEvent, type ), sizeof( int ) );
	swigStructField( "XCirculateRequestEvent-send_event", offsetof( XCirculateRequestEvent, send_event ), sizeof( int ) );
	swigStructField( "XCirculateRequestEvent-parent", offsetof( XCirculateRequestEvent, parent ), sizeof( Window ) );
	printf( "drop %zu end-structure\n", sizeof( XCirculateRequestEvent ) );

	swigComment("XPropertyEvent\n");
	printf( "begin-structure XPropertyEvent\n" );
	swigStructField( "XPropertyEvent-display", offsetof( XPropertyEvent, display ), sizeof( Display * ) );
	swigStructField( "XPropertyEvent-atom", offsetof( XPropertyEvent, atom ), sizeof( Atom ) );
	swigStructField( "XPropertyEvent-time", offsetof( XPropertyEvent, time ), sizeof( Time ) );
	swigStructField( "XPropertyEvent-serial", offsetof( XPropertyEvent, serial ), sizeof( unsigned long ) );
	swigStructField( "XPropertyEvent-window", offsetof( XPropertyEvent, window ), sizeof( Window ) );
	swigStructField( "XPropertyEvent-type", offsetof( XPropertyEvent, type ), sizeof( int ) );
	swigStructField( "XPropertyEvent-send_event", offsetof( XPropertyEvent, send_event ), sizeof( int ) );
	swigStructField( "XPropertyEvent-state", offsetof( XPropertyEvent, state ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( XPropertyEvent ) );

	swigComment("XSelectionClearEvent\n");
	printf( "begin-structure XSelectionClearEvent\n" );
	swigStructField( "XSelectionClearEvent-display", offsetof( XSelectionClearEvent, display ), sizeof( Display * ) );
	swigStructField( "XSelectionClearEvent-time", offsetof( XSelectionClearEvent, time ), sizeof( Time ) );
	swigStructField( "XSelectionClearEvent-serial", offsetof( XSelectionClearEvent, serial ), sizeof( unsigned long ) );
	swigStructField( "XSelectionClearEvent-window", offsetof( XSelectionClearEvent, window ), sizeof( Window ) );
	swigStructField( "XSelectionClearEvent-type", offsetof( XSelectionClearEvent, type ), sizeof( int ) );
	swigStructField( "XSelectionClearEvent-send_event", offsetof( XSelectionClearEvent, send_event ), sizeof( int ) );
	swigStructField( "XSelectionClearEvent-selection", offsetof( XSelectionClearEvent, selection ), sizeof( Atom ) );
	printf( "drop %zu end-structure\n", sizeof( XSelectionClearEvent ) );

	swigComment("XSelectionRequestEvent\n");
	printf( "begin-structure XSelectionRequestEvent\n" );
	swigStructField( "XSelectionRequestEvent-display", offsetof( XSelectionRequestEvent, display ), sizeof( Display * ) );
	swigStructField( "XSelectionRequestEvent-requestor", offsetof( XSelectionRequestEvent, requestor ), sizeof( Window ) );
	swigStructField( "XSelectionRequestEvent-property", offsetof( XSelectionRequestEvent, property ), sizeof( Atom ) );
	swigStructField( "XSelectionRequestEvent-target", offsetof( XSelectionRequestEvent, target ), sizeof( Atom ) );
	swigStructField( "XSelectionRequestEvent-time", offsetof( XSelectionRequestEvent, time ), sizeof( Time ) );
	swigStructField( "XSelectionRequestEvent-serial", offsetof( XSelectionRequestEvent, serial ), sizeof( unsigned long ) );
	swigStructField( "XSelectionRequestEvent-type", offsetof( XSelectionRequestEvent, type ), sizeof( int ) );
	swigStructField( "XSelectionRequestEvent-send_event", offsetof( XSelectionRequestEvent, send_event ), sizeof( int ) );
	swigStructField( "XSelectionRequestEvent-owner", offsetof( XSelectionRequestEvent, owner ), sizeof( Window ) );
	swigStructField( "XSelectionRequestEvent-selection", offsetof( XSelectionRequestEvent, selection ), sizeof( Atom ) );
	printf( "drop %zu end-structure\n", sizeof( XSelectionRequestEvent ) );

	swigComment("XSelectionEvent\n");
	printf( "begin-structure XSelectionEvent\n" );
	swigStructField( "XSelectionEvent-display", offsetof( XSelectionEvent, display ), sizeof( Display * ) );
	swigStructField( "XSelectionEvent-requestor", offsetof( XSelectionEvent, requestor ), sizeof( Window ) );
	swigStructField( "XSelectionEvent-property", offsetof( XSelectionEvent, property ), sizeof( Atom ) );
	swigStructField( "XSelectionEvent-target", offsetof( XSelectionEvent, target ), sizeof( Atom ) );
	swigStructField( "XSelectionEvent-time", offsetof( XSelectionEvent, time ), sizeof( Time ) );
	swigStructField( "XSelectionEvent-serial", offsetof( XSelectionEvent, serial ), sizeof( unsigned long ) );
	swigStructField( "XSelectionEvent-type", offsetof( XSelectionEvent, type ), sizeof( int ) );
	swigStructField( "XSelectionEvent-send_event", offsetof( XSelectionEvent, send_event ), sizeof( int ) );
	swigStructField( "XSelectionEvent-selection", offsetof( XSelectionEvent, selection ), sizeof( Atom ) );
	printf( "drop %zu end-structure\n", sizeof( XSelectionEvent ) );

	swigComment("XColormapEvent\n");
	printf( "begin-structure XColormapEvent\n" );
	swigStructField( "XColormapEvent-display", offsetof( XColormapEvent, display ), sizeof( Display * ) );
	swigStructField( "XColormapEvent-new", offsetof( XColormapEvent, new ), sizeof( int ) );
	swigStructField( "XColormapEvent-serial", offsetof( XColormapEvent, serial ), sizeof( unsigned long ) );
	swigStructField( "XColormapEvent-window", offsetof( XColormapEvent, window ), sizeof( Window ) );
	swigStructField( "XColormapEvent-type", offsetof( XColormapEvent, type ), sizeof( int ) );
	swigStructField( "XColormapEvent-send_event", offsetof( XColormapEvent, send_event ), sizeof( int ) );
	swigStructField( "XColormapEvent-colormap", offsetof( XColormapEvent, colormap ), sizeof( Colormap ) );
	swigStructField( "XColormapEvent-state", offsetof( XColormapEvent, state ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( XColormapEvent ) );

	swigComment("XClientMessageEvent\n");
	printf( "begin-structure XClientMessageEvent\n" );
	swigStructField( "XClientMessageEvent-display", offsetof( XClientMessageEvent, display ), sizeof( Display * ) );
	swigStructField( "XClientMessageEvent-data", offsetof( XClientMessageEvent, data ), sizeof( XClientMessageEvent_data ) );
	swigStructField( "XClientMessageEvent-message_type", offsetof( XClientMessageEvent, message_type ), sizeof( Atom ) );
	swigStructField( "XClientMessageEvent-serial", offsetof( XClientMessageEvent, serial ), sizeof( unsigned long ) );
	swigStructField( "XClientMessageEvent-window", offsetof( XClientMessageEvent, window ), sizeof( Window ) );
	swigStructField( "XClientMessageEvent-type", offsetof( XClientMessageEvent, type ), sizeof( int ) );
	swigStructField( "XClientMessageEvent-send_event", offsetof( XClientMessageEvent, send_event ), sizeof( int ) );
	swigStructField( "XClientMessageEvent-format", offsetof( XClientMessageEvent, format ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( XClientMessageEvent ) );

	swigComment("XClientMessageEvent_data\n");
	printf( "begin-structure XClientMessageEvent_data\n" );
	swigStructField( "XClientMessageEvent_data-b", offsetof( XClientMessageEvent_data, b ), sizeof( char [20] ) );
	swigStructField( "XClientMessageEvent_data-s", offsetof( XClientMessageEvent_data, s ), sizeof( short [10] ) );
	swigStructField( "XClientMessageEvent_data-l", offsetof( XClientMessageEvent_data, l ), sizeof( long [5] ) );
	printf( "drop %zu end-structure\n", sizeof( XClientMessageEvent_data ) );

	swigComment("XMappingEvent\n");
	printf( "begin-structure XMappingEvent\n" );
	swigStructField( "XMappingEvent-display", offsetof( XMappingEvent, display ), sizeof( Display * ) );
	swigStructField( "XMappingEvent-request", offsetof( XMappingEvent, request ), sizeof( int ) );
	swigStructField( "XMappingEvent-first_keycode", offsetof( XMappingEvent, first_keycode ), sizeof( int ) );
	swigStructField( "XMappingEvent-count", offsetof( XMappingEvent, count ), sizeof( int ) );
	swigStructField( "XMappingEvent-serial", offsetof( XMappingEvent, serial ), sizeof( unsigned long ) );
	swigStructField( "XMappingEvent-window", offsetof( XMappingEvent, window ), sizeof( Window ) );
	swigStructField( "XMappingEvent-type", offsetof( XMappingEvent, type ), sizeof( int ) );
	swigStructField( "XMappingEvent-send_event", offsetof( XMappingEvent, send_event ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( XMappingEvent ) );

	swigComment("XErrorEvent\n");
	printf( "begin-structure XErrorEvent\n" );
	swigStructField( "XErrorEvent-display", offsetof( XErrorEvent, display ), sizeof( Display * ) );
	swigStructField( "XErrorEvent-resourceid", offsetof( XErrorEvent, resourceid ), sizeof( XID ) );
	swigStructField( "XErrorEvent-serial", offsetof( XErrorEvent, serial ), sizeof( unsigned long ) );
	swigStructField( "XErrorEvent-request_code", offsetof( XErrorEvent, request_code ), sizeof( unsigned char ) );
	swigStructField( "XErrorEvent-type", offsetof( XErrorEvent, type ), sizeof( int ) );
	swigStructField( "XErrorEvent-error_code", offsetof( XErrorEvent, error_code ), sizeof( unsigned char ) );
	swigStructField( "XErrorEvent-minor_code", offsetof( XErrorEvent, minor_code ), sizeof( unsigned char ) );
	printf( "drop %zu end-structure\n", sizeof( XErrorEvent ) );

	swigComment("XAnyEvent\n");
	printf( "begin-structure XAnyEvent\n" );
	swigStructField( "XAnyEvent-display", offsetof( XAnyEvent, display ), sizeof( Display * ) );
	swigStructField( "XAnyEvent-serial", offsetof( XAnyEvent, serial ), sizeof( unsigned long ) );
	swigStructField( "XAnyEvent-window", offsetof( XAnyEvent, window ), sizeof( Window ) );
	swigStructField( "XAnyEvent-type", offsetof( XAnyEvent, type ), sizeof( int ) );
	swigStructField( "XAnyEvent-send_event", offsetof( XAnyEvent, send_event ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( XAnyEvent ) );

	swigComment("XGenericEvent\n");
	printf( "begin-structure XGenericEvent\n" );
	swigStructField( "XGenericEvent-display", offsetof( XGenericEvent, display ), sizeof( Display * ) );
	swigStructField( "XGenericEvent-extension", offsetof( XGenericEvent, extension ), sizeof( int ) );
	swigStructField( "XGenericEvent-serial", offsetof( XGenericEvent, serial ), sizeof( unsigned long ) );
	swigStructField( "XGenericEvent-type", offsetof( XGenericEvent, type ), sizeof( int ) );
	swigStructField( "XGenericEvent-evtype", offsetof( XGenericEvent, evtype ), sizeof( int ) );
	swigStructField( "XGenericEvent-send_event", offsetof( XGenericEvent, send_event ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( XGenericEvent ) );

	swigComment("XGenericEventCookie\n");
	printf( "begin-structure XGenericEventCookie\n" );
	swigStructField( "XGenericEventCookie-display", offsetof( XGenericEventCookie, display ), sizeof( Display * ) );
	swigStructField( "XGenericEventCookie-extension", offsetof( XGenericEventCookie, extension ), sizeof( int ) );
	swigStructField( "XGenericEventCookie-data", offsetof( XGenericEventCookie, data ), sizeof( void * ) );
	swigStructField( "XGenericEventCookie-cookie", offsetof( XGenericEventCookie, cookie ), sizeof( unsigned int ) );
	swigStructField( "XGenericEventCookie-serial", offsetof( XGenericEventCookie, serial ), sizeof( unsigned long ) );
	swigStructField( "XGenericEventCookie-type", offsetof( XGenericEventCookie, type ), sizeof( int ) );
	swigStructField( "XGenericEventCookie-evtype", offsetof( XGenericEventCookie, evtype ), sizeof( int ) );
	swigStructField( "XGenericEventCookie-send_event", offsetof( XGenericEventCookie, send_event ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( XGenericEventCookie ) );

	swigComment("union _XEvent\n");
	printf( "begin-structure XEvent\n" );
	printf( "drop %zu end-structure\n", sizeof( union _XEvent ) );

	swigComment("XCharStruct\n");
	printf( "begin-structure XCharStruct\n" );
	swigStructField( "XCharStruct-ascent", offsetof( XCharStruct, ascent ), sizeof( short ) );
	swigStructField( "XCharStruct-width", offsetof( XCharStruct, width ), sizeof( short ) );
	swigStructField( "XCharStruct-descent", offsetof( XCharStruct, descent ), sizeof( short ) );
	swigStructField( "XCharStruct-attributes", offsetof( XCharStruct, attributes ), sizeof( unsigned short ) );
	swigStructField( "XCharStruct-lbearing", offsetof( XCharStruct, lbearing ), sizeof( short ) );
	swigStructField( "XCharStruct-rbearing", offsetof( XCharStruct, rbearing ), sizeof( short ) );
	printf( "drop %zu end-structure\n", sizeof( XCharStruct ) );

	swigComment("XFontProp\n");
	printf( "begin-structure XFontProp\n" );
	swigStructField( "XFontProp-name", offsetof( XFontProp, name ), sizeof( Atom ) );
	swigStructField( "XFontProp-card32", offsetof( XFontProp, card32 ), sizeof( unsigned long ) );
	printf( "drop %zu end-structure\n", sizeof( XFontProp ) );

	swigComment("XFontStruct\n");
	printf( "begin-structure XFontStruct\n" );
	swigStructField( "XFontStruct-direction", offsetof( XFontStruct, direction ), sizeof( unsigned int ) );
	swigStructField( "XFontStruct-ascent", offsetof( XFontStruct, ascent ), sizeof( int ) );
	swigStructField( "XFontStruct-max_byte1", offsetof( XFontStruct, max_byte1 ), sizeof( unsigned int ) );
	swigStructField( "XFontStruct-min_byte1", offsetof( XFontStruct, min_byte1 ), sizeof( unsigned int ) );
	swigStructField( "XFontStruct-max_char_or_byte2", offsetof( XFontStruct, max_char_or_byte2 ), sizeof( unsigned int ) );
	swigStructField( "XFontStruct-min_char_or_byte2", offsetof( XFontStruct, min_char_or_byte2 ), sizeof( unsigned int ) );
	swigStructField( "XFontStruct-ext_data", offsetof( XFontStruct, ext_data ), sizeof( XExtData * ) );
	swigStructField( "XFontStruct-all_chars_exist", offsetof( XFontStruct, all_chars_exist ), sizeof( int ) );
	swigStructField( "XFontStruct-max_bounds", offsetof( XFontStruct, max_bounds ), sizeof( XCharStruct ) );
	swigStructField( "XFontStruct-min_bounds", offsetof( XFontStruct, min_bounds ), sizeof( XCharStruct ) );
	swigStructField( "XFontStruct-fid", offsetof( XFontStruct, fid ), sizeof( Font ) );
	swigStructField( "XFontStruct-properties", offsetof( XFontStruct, properties ), sizeof( XFontProp * ) );
	swigStructField( "XFontStruct-n_properties", offsetof( XFontStruct, n_properties ), sizeof( int ) );
	swigStructField( "XFontStruct-descent", offsetof( XFontStruct, descent ), sizeof( int ) );
	swigStructField( "XFontStruct-default_char", offsetof( XFontStruct, default_char ), sizeof( unsigned int ) );
	swigStructField( "XFontStruct-per_char", offsetof( XFontStruct, per_char ), sizeof( XCharStruct * ) );
	printf( "drop %zu end-structure\n", sizeof( XFontStruct ) );

	swigComment("XTextItem\n");
	printf( "begin-structure XTextItem\n" );
	swigStructField( "XTextItem-delta", offsetof( XTextItem, delta ), sizeof( int ) );
	swigStructField( "XTextItem-chars", offsetof( XTextItem, chars ), sizeof( char * ) );
	swigStructField( "XTextItem-font", offsetof( XTextItem, font ), sizeof( Font ) );
	swigStructField( "XTextItem-nchars", offsetof( XTextItem, nchars ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( XTextItem ) );

	swigComment("XChar2b\n");
	printf( "begin-structure XChar2b\n" );
	swigStructField( "XChar2b-byte1", offsetof( XChar2b, byte1 ), sizeof( unsigned char ) );
	swigStructField( "XChar2b-byte2", offsetof( XChar2b, byte2 ), sizeof( unsigned char ) );
	printf( "drop %zu end-structure\n", sizeof( XChar2b ) );

	swigComment("XTextItem16\n");
	printf( "begin-structure XTextItem16\n" );
	swigStructField( "XTextItem16-delta", offsetof( XTextItem16, delta ), sizeof( int ) );
	swigStructField( "XTextItem16-chars", offsetof( XTextItem16, chars ), sizeof( XChar2b * ) );
	swigStructField( "XTextItem16-font", offsetof( XTextItem16, font ), sizeof( Font ) );
	swigStructField( "XTextItem16-nchars", offsetof( XTextItem16, nchars ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( XTextItem16 ) );

	swigComment("XEDataObject\n");
	printf( "begin-structure XEDataObject\n" );
	swigStructField( "XEDataObject-display", offsetof( XEDataObject, display ), sizeof( Display * ) );
	swigStructField( "XEDataObject-gc", offsetof( XEDataObject, gc ), sizeof( GC ) );
	swigStructField( "XEDataObject-visual", offsetof( XEDataObject, visual ), sizeof( Visual * ) );
	swigStructField( "XEDataObject-pixmap_format", offsetof( XEDataObject, pixmap_format ), sizeof( ScreenFormat * ) );
	swigStructField( "XEDataObject-screen", offsetof( XEDataObject, screen ), sizeof( Screen * ) );
	swigStructField( "XEDataObject-font", offsetof( XEDataObject, font ), sizeof( XFontStruct * ) );
	printf( "drop %zu end-structure\n", sizeof( XEDataObject ) );

	swigComment("XFontSetExtents\n");
	printf( "begin-structure XFontSetExtents\n" );
	swigStructField( "XFontSetExtents-max_ink_extent", offsetof( XFontSetExtents, max_ink_extent ), sizeof( XRectangle ) );
	swigStructField( "XFontSetExtents-max_logical_extent", offsetof( XFontSetExtents, max_logical_extent ), sizeof( XRectangle ) );
	printf( "drop %zu end-structure\n", sizeof( XFontSetExtents ) );

	swigComment("XmbTextItem\n");
	printf( "begin-structure XmbTextItem\n" );
	swigStructField( "XmbTextItem-font_set", offsetof( XmbTextItem, font_set ), sizeof( XFontSet ) );
	swigStructField( "XmbTextItem-delta", offsetof( XmbTextItem, delta ), sizeof( int ) );
	swigStructField( "XmbTextItem-chars", offsetof( XmbTextItem, chars ), sizeof( char * ) );
	swigStructField( "XmbTextItem-nchars", offsetof( XmbTextItem, nchars ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( XmbTextItem ) );

	swigComment("XwcTextItem\n");
	printf( "begin-structure XwcTextItem\n" );
	swigStructField( "XwcTextItem-font_set", offsetof( XwcTextItem, font_set ), sizeof( XFontSet ) );
	swigStructField( "XwcTextItem-delta", offsetof( XwcTextItem, delta ), sizeof( int ) );
	swigStructField( "XwcTextItem-chars", offsetof( XwcTextItem, chars ), sizeof( wchar_t * ) );
	swigStructField( "XwcTextItem-nchars", offsetof( XwcTextItem, nchars ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( XwcTextItem ) );

	swigComment("XOMCharSetList\n");
	printf( "begin-structure XOMCharSetList\n" );
	swigStructField( "XOMCharSetList-charset_count", offsetof( XOMCharSetList, charset_count ), sizeof( int ) );
	swigStructField( "XOMCharSetList-charset_list", offsetof( XOMCharSetList, charset_list ), sizeof( char ** ) );
	printf( "drop %zu end-structure\n", sizeof( XOMCharSetList ) );

	swigComment("XOMOrientation\n");
	printf( "begin-structure XOMOrientation\n" );
	swigStructField( "XOMOrientation-num_orientation", offsetof( XOMOrientation, num_orientation ), sizeof( int ) );
	swigStructField( "XOMOrientation-orientation", offsetof( XOMOrientation, orientation ), sizeof( XOrientation * ) );
	printf( "drop %zu end-structure\n", sizeof( XOMOrientation ) );

	swigComment("XOMFontInfo\n");
	printf( "begin-structure XOMFontInfo\n" );
	swigStructField( "XOMFontInfo-font_name_list", offsetof( XOMFontInfo, font_name_list ), sizeof( char ** ) );
	swigStructField( "XOMFontInfo-num_font", offsetof( XOMFontInfo, num_font ), sizeof( int ) );
	swigStructField( "XOMFontInfo-font_struct_list", offsetof( XOMFontInfo, font_struct_list ), sizeof( XFontStruct ** ) );
	printf( "drop %zu end-structure\n", sizeof( XOMFontInfo ) );

	swigComment("XIMStyles\n");
	printf( "begin-structure XIMStyles\n" );
	swigStructField( "XIMStyles-count_styles", offsetof( XIMStyles, count_styles ), sizeof( unsigned short ) );
	swigStructField( "XIMStyles-supported_styles", offsetof( XIMStyles, supported_styles ), sizeof( XIMStyle * ) );
	printf( "drop %zu end-structure\n", sizeof( XIMStyles ) );

	swigComment("XIMCallback\n");
	printf( "begin-structure XIMCallback\n" );
	swigStructField( "XIMCallback-client_data", offsetof( XIMCallback, client_data ), sizeof( XPointer ) );
	swigStructField( "XIMCallback-callback", offsetof( XIMCallback, callback ), sizeof( XIMProc ) );
	printf( "drop %zu end-structure\n", sizeof( XIMCallback ) );

	swigComment("XICCallback\n");
	printf( "begin-structure XICCallback\n" );
	swigStructField( "XICCallback-client_data", offsetof( XICCallback, client_data ), sizeof( XPointer ) );
	swigStructField( "XICCallback-callback", offsetof( XICCallback, callback ), sizeof( XICProc ) );
	printf( "drop %zu end-structure\n", sizeof( XICCallback ) );

	swigComment("struct _XIMText\n");
	printf( "begin-structure XIMText\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _XIMText ) );

	swigComment("_XIMText_string\n");
	printf( "begin-structure _XIMText_string\n" );
	swigStructField( "_XIMText_string-multi_byte", offsetof( _XIMText_string, multi_byte ), sizeof( char * ) );
	swigStructField( "_XIMText_string-wide_char", offsetof( _XIMText_string, wide_char ), sizeof( wchar_t * ) );
	printf( "drop %zu end-structure\n", sizeof( _XIMText_string ) );

	swigComment("struct _XIMPreeditStateNotifyCallbackStruct\n");
	printf( "begin-structure XIMPreeditStateNotifyCallbackStruct\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _XIMPreeditStateNotifyCallbackStruct ) );

	swigComment("struct _XIMStringConversionText\n");
	printf( "begin-structure XIMStringConversionText\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _XIMStringConversionText ) );

	swigComment("_XIMStringConversionText_string\n");
	printf( "begin-structure _XIMStringConversionText_string\n" );
	swigStructField( "_XIMStringConversionText_string-wcs", offsetof( _XIMStringConversionText_string, wcs ), sizeof( wchar_t * ) );
	swigStructField( "_XIMStringConversionText_string-mbs", offsetof( _XIMStringConversionText_string, mbs ), sizeof( char * ) );
	printf( "drop %zu end-structure\n", sizeof( _XIMStringConversionText_string ) );

	swigComment("struct _XIMStringConversionCallbackStruct\n");
	printf( "begin-structure XIMStringConversionCallbackStruct\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _XIMStringConversionCallbackStruct ) );

	swigComment("struct _XIMPreeditDrawCallbackStruct\n");
	printf( "begin-structure XIMPreeditDrawCallbackStruct\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _XIMPreeditDrawCallbackStruct ) );

	swigComment("struct _XIMPreeditCaretCallbackStruct\n");
	printf( "begin-structure XIMPreeditCaretCallbackStruct\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _XIMPreeditCaretCallbackStruct ) );

	swigComment("struct _XIMStatusDrawCallbackStruct\n");
	printf( "begin-structure XIMStatusDrawCallbackStruct\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _XIMStatusDrawCallbackStruct ) );

	swigComment("_XIMStatusDrawCallbackStruct_data\n");
	printf( "begin-structure _XIMStatusDrawCallbackStruct_data\n" );
	swigStructField( "_XIMStatusDrawCallbackStruct_data-text", offsetof( _XIMStatusDrawCallbackStruct_data, text ), sizeof( XIMText * ) );
	swigStructField( "_XIMStatusDrawCallbackStruct_data-bitmap", offsetof( _XIMStatusDrawCallbackStruct_data, bitmap ), sizeof( Pixmap ) );
	printf( "drop %zu end-structure\n", sizeof( _XIMStatusDrawCallbackStruct_data ) );

	swigComment("struct _XIMHotKeyTrigger\n");
	printf( "begin-structure XIMHotKeyTrigger\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _XIMHotKeyTrigger ) );

	swigComment("struct _XIMHotKeyTriggers\n");
	printf( "begin-structure XIMHotKeyTriggers\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _XIMHotKeyTriggers ) );

	swigComment("XIMValuesList\n");
	printf( "begin-structure XIMValuesList\n" );
	swigStructField( "XIMValuesList-count_values", offsetof( XIMValuesList, count_values ), sizeof( unsigned short ) );
	swigStructField( "XIMValuesList-supported_values", offsetof( XIMValuesList, supported_values ), sizeof( char ** ) );
	printf( "drop %zu end-structure\n", sizeof( XIMValuesList ) );

	swigComment("XSizeHints\n");
	printf( "begin-structure XSizeHints\n" );
	swigStructField( "XSizeHints-height_inc", offsetof( XSizeHints, height_inc ), sizeof( int ) );
	swigStructField( "XSizeHints-x", offsetof( XSizeHints, x ), sizeof( int ) );
	swigStructField( "XSizeHints-win_gravity", offsetof( XSizeHints, win_gravity ), sizeof( int ) );
	swigStructField( "XSizeHints-y", offsetof( XSizeHints, y ), sizeof( int ) );
	swigStructField( "XSizeHints-height", offsetof( XSizeHints, height ), sizeof( int ) );
	swigStructField( "XSizeHints-max_width", offsetof( XSizeHints, max_width ), sizeof( int ) );
	swigStructField( "XSizeHints-min_width", offsetof( XSizeHints, min_width ), sizeof( int ) );
	swigStructField( "XSizeHints-max_height", offsetof( XSizeHints, max_height ), sizeof( int ) );
	swigStructField( "XSizeHints-min_height", offsetof( XSizeHints, min_height ), sizeof( int ) );
	swigStructField( "XSizeHints-base_height", offsetof( XSizeHints, base_height ), sizeof( int ) );
	swigStructField( "XSizeHints-base_width", offsetof( XSizeHints, base_width ), sizeof( int ) );
	swigStructField( "XSizeHints-width", offsetof( XSizeHints, width ), sizeof( int ) );
	swigStructField( "XSizeHints-max_aspect", offsetof( XSizeHints, max_aspect ), sizeof( XSizeHints_min_aspect ) );
	swigStructField( "XSizeHints-min_aspect", offsetof( XSizeHints, min_aspect ), sizeof( XSizeHints_min_aspect ) );
	swigStructField( "XSizeHints-flags", offsetof( XSizeHints, flags ), sizeof( long ) );
	swigStructField( "XSizeHints-width_inc", offsetof( XSizeHints, width_inc ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( XSizeHints ) );

	swigComment("XSizeHints_min_aspect\n");
	printf( "begin-structure XSizeHints_min_aspect\n" );
	swigStructField( "XSizeHints_min_aspect-x", offsetof( XSizeHints_min_aspect, x ), sizeof( int ) );
	swigStructField( "XSizeHints_min_aspect-y", offsetof( XSizeHints_min_aspect, y ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( XSizeHints_min_aspect ) );

	swigComment("XWMHints\n");
	printf( "begin-structure XWMHints\n" );
	swigStructField( "XWMHints-icon_x", offsetof( XWMHints, icon_x ), sizeof( int ) );
	swigStructField( "XWMHints-input", offsetof( XWMHints, input ), sizeof( int ) );
	swigStructField( "XWMHints-icon_y", offsetof( XWMHints, icon_y ), sizeof( int ) );
	swigStructField( "XWMHints-icon_pixmap", offsetof( XWMHints, icon_pixmap ), sizeof( Pixmap ) );
	swigStructField( "XWMHints-icon_window", offsetof( XWMHints, icon_window ), sizeof( Window ) );
	swigStructField( "XWMHints-window_group", offsetof( XWMHints, window_group ), sizeof( XID ) );
	swigStructField( "XWMHints-initial_state", offsetof( XWMHints, initial_state ), sizeof( int ) );
	swigStructField( "XWMHints-icon_mask", offsetof( XWMHints, icon_mask ), sizeof( Pixmap ) );
	swigStructField( "XWMHints-flags", offsetof( XWMHints, flags ), sizeof( long ) );
	printf( "drop %zu end-structure\n", sizeof( XWMHints ) );

	swigComment("XTextProperty\n");
	printf( "begin-structure XTextProperty\n" );
	swigStructField( "XTextProperty-encoding", offsetof( XTextProperty, encoding ), sizeof( Atom ) );
	swigStructField( "XTextProperty-nitems", offsetof( XTextProperty, nitems ), sizeof( unsigned long ) );
	swigStructField( "XTextProperty-value", offsetof( XTextProperty, value ), sizeof( unsigned char * ) );
	swigStructField( "XTextProperty-format", offsetof( XTextProperty, format ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( XTextProperty ) );

	swigComment("XIconSize\n");
	printf( "begin-structure XIconSize\n" );
	swigStructField( "XIconSize-height_inc", offsetof( XIconSize, height_inc ), sizeof( int ) );
	swigStructField( "XIconSize-min_height", offsetof( XIconSize, min_height ), sizeof( int ) );
	swigStructField( "XIconSize-max_height", offsetof( XIconSize, max_height ), sizeof( int ) );
	swigStructField( "XIconSize-min_width", offsetof( XIconSize, min_width ), sizeof( int ) );
	swigStructField( "XIconSize-max_width", offsetof( XIconSize, max_width ), sizeof( int ) );
	swigStructField( "XIconSize-width_inc", offsetof( XIconSize, width_inc ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( XIconSize ) );

	swigComment("XClassHint\n");
	printf( "begin-structure XClassHint\n" );
	swigStructField( "XClassHint-res_class", offsetof( XClassHint, res_class ), sizeof( char * ) );
	swigStructField( "XClassHint-res_name", offsetof( XClassHint, res_name ), sizeof( char * ) );
	printf( "drop %zu end-structure\n", sizeof( XClassHint ) );

	swigComment("struct _XComposeStatus\n");
	printf( "begin-structure XComposeStatus\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _XComposeStatus ) );

	swigComment("XVisualInfo\n");
	printf( "begin-structure XVisualInfo\n" );
	swigStructField( "XVisualInfo-blue_mask", offsetof( XVisualInfo, blue_mask ), sizeof( unsigned long ) );
	swigStructField( "XVisualInfo-visual", offsetof( XVisualInfo, visual ), sizeof( Visual * ) );
	swigStructField( "XVisualInfo-visualid", offsetof( XVisualInfo, visualid ), sizeof( VisualID ) );
	swigStructField( "XVisualInfo-colormap_size", offsetof( XVisualInfo, colormap_size ), sizeof( int ) );
	swigStructField( "XVisualInfo-green_mask", offsetof( XVisualInfo, green_mask ), sizeof( unsigned long ) );
	swigStructField( "XVisualInfo-screen", offsetof( XVisualInfo, screen ), sizeof( int ) );
	swigStructField( "XVisualInfo-depth", offsetof( XVisualInfo, depth ), sizeof( int ) );
	swigStructField( "XVisualInfo-red_mask", offsetof( XVisualInfo, red_mask ), sizeof( unsigned long ) );
	swigStructField( "XVisualInfo-bits_per_rgb", offsetof( XVisualInfo, bits_per_rgb ), sizeof( int ) );
	swigStructField( "XVisualInfo-class", offsetof( XVisualInfo, class ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( XVisualInfo ) );

	swigComment("XStandardColormap\n");
	printf( "begin-structure XStandardColormap\n" );
	swigStructField( "XStandardColormap-red_max", offsetof( XStandardColormap, red_max ), sizeof( unsigned long ) );
	swigStructField( "XStandardColormap-blue_mult", offsetof( XStandardColormap, blue_mult ), sizeof( unsigned long ) );
	swigStructField( "XStandardColormap-blue_max", offsetof( XStandardColormap, blue_max ), sizeof( unsigned long ) );
	swigStructField( "XStandardColormap-base_pixel", offsetof( XStandardColormap, base_pixel ), sizeof( unsigned long ) );
	swigStructField( "XStandardColormap-visualid", offsetof( XStandardColormap, visualid ), sizeof( VisualID ) );
	swigStructField( "XStandardColormap-green_max", offsetof( XStandardColormap, green_max ), sizeof( unsigned long ) );
	swigStructField( "XStandardColormap-green_mult", offsetof( XStandardColormap, green_mult ), sizeof( unsigned long ) );
	swigStructField( "XStandardColormap-colormap", offsetof( XStandardColormap, colormap ), sizeof( Colormap ) );
	swigStructField( "XStandardColormap-red_mult", offsetof( XStandardColormap, red_mult ), sizeof( unsigned long ) );
	swigStructField( "XStandardColormap-killid", offsetof( XStandardColormap, killid ), sizeof( XID ) );
	printf( "drop %zu end-structure\n", sizeof( XStandardColormap ) );

	swigComment("struct _XSyncSystemCounter\n");
	printf( "begin-structure XSyncSystemCounter\n" );
	printf( "drop %zu end-structure\n", sizeof( struct _XSyncSystemCounter ) );

	swigComment("XSyncTrigger\n");
	printf( "begin-structure XSyncTrigger\n" );
	swigStructField( "XSyncTrigger-counter", offsetof( XSyncTrigger, counter ), sizeof( XSyncCounter ) );
	swigStructField( "XSyncTrigger-value_type", offsetof( XSyncTrigger, value_type ), sizeof( XSyncValueType ) );
	swigStructField( "XSyncTrigger-wait_value", offsetof( XSyncTrigger, wait_value ), sizeof( XSyncValue ) );
	swigStructField( "XSyncTrigger-test_type", offsetof( XSyncTrigger, test_type ), sizeof( XSyncTestType ) );
	printf( "drop %zu end-structure\n", sizeof( XSyncTrigger ) );

	swigComment("XSyncWaitCondition\n");
	printf( "begin-structure XSyncWaitCondition\n" );
	swigStructField( "XSyncWaitCondition-trigger", offsetof( XSyncWaitCondition, trigger ), sizeof( XSyncTrigger ) );
	swigStructField( "XSyncWaitCondition-event_threshold", offsetof( XSyncWaitCondition, event_threshold ), sizeof( XSyncValue ) );
	printf( "drop %zu end-structure\n", sizeof( XSyncWaitCondition ) );

	swigComment("XSyncAlarmAttributes\n");
	printf( "begin-structure XSyncAlarmAttributes\n" );
	swigStructField( "XSyncAlarmAttributes-trigger", offsetof( XSyncAlarmAttributes, trigger ), sizeof( XSyncTrigger ) );
	swigStructField( "XSyncAlarmAttributes-delta", offsetof( XSyncAlarmAttributes, delta ), sizeof( XSyncValue ) );
	swigStructField( "XSyncAlarmAttributes-events", offsetof( XSyncAlarmAttributes, events ), sizeof( int ) );
	swigStructField( "XSyncAlarmAttributes-state", offsetof( XSyncAlarmAttributes, state ), sizeof( XSyncAlarmState ) );
	printf( "drop %zu end-structure\n", sizeof( XSyncAlarmAttributes ) );

	swigComment("XSyncCounterNotifyEvent\n");
	printf( "begin-structure XSyncCounterNotifyEvent\n" );
	swigStructField( "XSyncCounterNotifyEvent-display", offsetof( XSyncCounterNotifyEvent, display ), sizeof( Display * ) );
	swigStructField( "XSyncCounterNotifyEvent-counter", offsetof( XSyncCounterNotifyEvent, counter ), sizeof( XSyncCounter ) );
	swigStructField( "XSyncCounterNotifyEvent-wait_value", offsetof( XSyncCounterNotifyEvent, wait_value ), sizeof( XSyncValue ) );
	swigStructField( "XSyncCounterNotifyEvent-counter_value", offsetof( XSyncCounterNotifyEvent, counter_value ), sizeof( XSyncValue ) );
	swigStructField( "XSyncCounterNotifyEvent-time", offsetof( XSyncCounterNotifyEvent, time ), sizeof( Time ) );
	swigStructField( "XSyncCounterNotifyEvent-count", offsetof( XSyncCounterNotifyEvent, count ), sizeof( int ) );
	swigStructField( "XSyncCounterNotifyEvent-destroyed", offsetof( XSyncCounterNotifyEvent, destroyed ), sizeof( int ) );
	swigStructField( "XSyncCounterNotifyEvent-serial", offsetof( XSyncCounterNotifyEvent, serial ), sizeof( unsigned long ) );
	swigStructField( "XSyncCounterNotifyEvent-type", offsetof( XSyncCounterNotifyEvent, type ), sizeof( int ) );
	swigStructField( "XSyncCounterNotifyEvent-send_event", offsetof( XSyncCounterNotifyEvent, send_event ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( XSyncCounterNotifyEvent ) );

	swigComment("XSyncAlarmNotifyEvent\n");
	printf( "begin-structure XSyncAlarmNotifyEvent\n" );
	swigStructField( "XSyncAlarmNotifyEvent-display", offsetof( XSyncAlarmNotifyEvent, display ), sizeof( Display * ) );
	swigStructField( "XSyncAlarmNotifyEvent-alarm_value", offsetof( XSyncAlarmNotifyEvent, alarm_value ), sizeof( XSyncValue ) );
	swigStructField( "XSyncAlarmNotifyEvent-alarm", offsetof( XSyncAlarmNotifyEvent, alarm ), sizeof( XSyncAlarm ) );
	swigStructField( "XSyncAlarmNotifyEvent-counter_value", offsetof( XSyncAlarmNotifyEvent, counter_value ), sizeof( XSyncValue ) );
	swigStructField( "XSyncAlarmNotifyEvent-time", offsetof( XSyncAlarmNotifyEvent, time ), sizeof( Time ) );
	swigStructField( "XSyncAlarmNotifyEvent-serial", offsetof( XSyncAlarmNotifyEvent, serial ), sizeof( unsigned long ) );
	swigStructField( "XSyncAlarmNotifyEvent-type", offsetof( XSyncAlarmNotifyEvent, type ), sizeof( int ) );
	swigStructField( "XSyncAlarmNotifyEvent-send_event", offsetof( XSyncAlarmNotifyEvent, send_event ), sizeof( int ) );
	swigStructField( "XSyncAlarmNotifyEvent-state", offsetof( XSyncAlarmNotifyEvent, state ), sizeof( XSyncAlarmState ) );
	printf( "drop %zu end-structure\n", sizeof( XSyncAlarmNotifyEvent ) );

	swigComment("XSyncAlarmError\n");
	printf( "begin-structure XSyncAlarmError\n" );
	swigStructField( "XSyncAlarmError-display", offsetof( XSyncAlarmError, display ), sizeof( Display * ) );
	swigStructField( "XSyncAlarmError-alarm", offsetof( XSyncAlarmError, alarm ), sizeof( XSyncAlarm ) );
	swigStructField( "XSyncAlarmError-serial", offsetof( XSyncAlarmError, serial ), sizeof( unsigned long ) );
	swigStructField( "XSyncAlarmError-request_code", offsetof( XSyncAlarmError, request_code ), sizeof( unsigned char ) );
	swigStructField( "XSyncAlarmError-type", offsetof( XSyncAlarmError, type ), sizeof( int ) );
	swigStructField( "XSyncAlarmError-error_code", offsetof( XSyncAlarmError, error_code ), sizeof( unsigned char ) );
	swigStructField( "XSyncAlarmError-minor_code", offsetof( XSyncAlarmError, minor_code ), sizeof( unsigned char ) );
	printf( "drop %zu end-structure\n", sizeof( XSyncAlarmError ) );

	swigComment("XSyncCounterError\n");
	printf( "begin-structure XSyncCounterError\n" );
	swigStructField( "XSyncCounterError-display", offsetof( XSyncCounterError, display ), sizeof( Display * ) );
	swigStructField( "XSyncCounterError-counter", offsetof( XSyncCounterError, counter ), sizeof( XSyncCounter ) );
	swigStructField( "XSyncCounterError-serial", offsetof( XSyncCounterError, serial ), sizeof( unsigned long ) );
	swigStructField( "XSyncCounterError-request_code", offsetof( XSyncCounterError, request_code ), sizeof( unsigned char ) );
	swigStructField( "XSyncCounterError-type", offsetof( XSyncCounterError, type ), sizeof( int ) );
	swigStructField( "XSyncCounterError-error_code", offsetof( XSyncCounterError, error_code ), sizeof( unsigned char ) );
	swigStructField( "XSyncCounterError-minor_code", offsetof( XSyncCounterError, minor_code ), sizeof( unsigned char ) );
	printf( "drop %zu end-structure\n", sizeof( XSyncCounterError ) );

	swigComment("XRRScreenSize\n");
	printf( "begin-structure XRRScreenSize\n" );
	swigStructField( "XRRScreenSize-mheight", offsetof( XRRScreenSize, mheight ), sizeof( int ) );
	swigStructField( "XRRScreenSize-height", offsetof( XRRScreenSize, height ), sizeof( int ) );
	swigStructField( "XRRScreenSize-mwidth", offsetof( XRRScreenSize, mwidth ), sizeof( int ) );
	swigStructField( "XRRScreenSize-width", offsetof( XRRScreenSize, width ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( XRRScreenSize ) );

	swigComment("XRRScreenChangeNotifyEvent\n");
	printf( "begin-structure XRRScreenChangeNotifyEvent\n" );
	swigStructField( "XRRScreenChangeNotifyEvent-window", offsetof( XRRScreenChangeNotifyEvent, window ), sizeof( Window ) );
	swigStructField( "XRRScreenChangeNotifyEvent-serial", offsetof( XRRScreenChangeNotifyEvent, serial ), sizeof( unsigned long ) );
	swigStructField( "XRRScreenChangeNotifyEvent-rotation", offsetof( XRRScreenChangeNotifyEvent, rotation ), sizeof( Rotation ) );
	swigStructField( "XRRScreenChangeNotifyEvent-height", offsetof( XRRScreenChangeNotifyEvent, height ), sizeof( int ) );
	swigStructField( "XRRScreenChangeNotifyEvent-root", offsetof( XRRScreenChangeNotifyEvent, root ), sizeof( Window ) );
	swigStructField( "XRRScreenChangeNotifyEvent-mheight", offsetof( XRRScreenChangeNotifyEvent, mheight ), sizeof( int ) );
	swigStructField( "XRRScreenChangeNotifyEvent-display", offsetof( XRRScreenChangeNotifyEvent, display ), sizeof( Display * ) );
	swigStructField( "XRRScreenChangeNotifyEvent-width", offsetof( XRRScreenChangeNotifyEvent, width ), sizeof( int ) );
	swigStructField( "XRRScreenChangeNotifyEvent-size_index", offsetof( XRRScreenChangeNotifyEvent, size_index ), sizeof( SizeID ) );
	swigStructField( "XRRScreenChangeNotifyEvent-type", offsetof( XRRScreenChangeNotifyEvent, type ), sizeof( int ) );
	swigStructField( "XRRScreenChangeNotifyEvent-config_timestamp", offsetof( XRRScreenChangeNotifyEvent, config_timestamp ), sizeof( Time ) );
	swigStructField( "XRRScreenChangeNotifyEvent-timestamp", offsetof( XRRScreenChangeNotifyEvent, timestamp ), sizeof( Time ) );
	swigStructField( "XRRScreenChangeNotifyEvent-send_event", offsetof( XRRScreenChangeNotifyEvent, send_event ), sizeof( int ) );
	swigStructField( "XRRScreenChangeNotifyEvent-subpixel_order", offsetof( XRRScreenChangeNotifyEvent, subpixel_order ), sizeof( SubpixelOrder ) );
	swigStructField( "XRRScreenChangeNotifyEvent-mwidth", offsetof( XRRScreenChangeNotifyEvent, mwidth ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( XRRScreenChangeNotifyEvent ) );

	swigComment("XRRNotifyEvent\n");
	printf( "begin-structure XRRNotifyEvent\n" );
	swigStructField( "XRRNotifyEvent-display", offsetof( XRRNotifyEvent, display ), sizeof( Display * ) );
	swigStructField( "XRRNotifyEvent-serial", offsetof( XRRNotifyEvent, serial ), sizeof( unsigned long ) );
	swigStructField( "XRRNotifyEvent-window", offsetof( XRRNotifyEvent, window ), sizeof( Window ) );
	swigStructField( "XRRNotifyEvent-type", offsetof( XRRNotifyEvent, type ), sizeof( int ) );
	swigStructField( "XRRNotifyEvent-subtype", offsetof( XRRNotifyEvent, subtype ), sizeof( int ) );
	swigStructField( "XRRNotifyEvent-send_event", offsetof( XRRNotifyEvent, send_event ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( XRRNotifyEvent ) );

	swigComment("XRROutputChangeNotifyEvent\n");
	printf( "begin-structure XRROutputChangeNotifyEvent\n" );
	swigStructField( "XRROutputChangeNotifyEvent-display", offsetof( XRROutputChangeNotifyEvent, display ), sizeof( Display * ) );
	swigStructField( "XRROutputChangeNotifyEvent-crtc", offsetof( XRROutputChangeNotifyEvent, crtc ), sizeof( RRCrtc ) );
	swigStructField( "XRROutputChangeNotifyEvent-subpixel_order", offsetof( XRROutputChangeNotifyEvent, subpixel_order ), sizeof( SubpixelOrder ) );
	swigStructField( "XRROutputChangeNotifyEvent-output", offsetof( XRROutputChangeNotifyEvent, output ), sizeof( RROutput ) );
	swigStructField( "XRROutputChangeNotifyEvent-serial", offsetof( XRROutputChangeNotifyEvent, serial ), sizeof( unsigned long ) );
	swigStructField( "XRROutputChangeNotifyEvent-window", offsetof( XRROutputChangeNotifyEvent, window ), sizeof( Window ) );
	swigStructField( "XRROutputChangeNotifyEvent-type", offsetof( XRROutputChangeNotifyEvent, type ), sizeof( int ) );
	swigStructField( "XRROutputChangeNotifyEvent-subtype", offsetof( XRROutputChangeNotifyEvent, subtype ), sizeof( int ) );
	swigStructField( "XRROutputChangeNotifyEvent-send_event", offsetof( XRROutputChangeNotifyEvent, send_event ), sizeof( int ) );
	swigStructField( "XRROutputChangeNotifyEvent-mode", offsetof( XRROutputChangeNotifyEvent, mode ), sizeof( RRMode ) );
	swigStructField( "XRROutputChangeNotifyEvent-rotation", offsetof( XRROutputChangeNotifyEvent, rotation ), sizeof( Rotation ) );
	swigStructField( "XRROutputChangeNotifyEvent-connection", offsetof( XRROutputChangeNotifyEvent, connection ), sizeof( Connection ) );
	printf( "drop %zu end-structure\n", sizeof( XRROutputChangeNotifyEvent ) );

	swigComment("XRRCrtcChangeNotifyEvent\n");
	printf( "begin-structure XRRCrtcChangeNotifyEvent\n" );
	swigStructField( "XRRCrtcChangeNotifyEvent-display", offsetof( XRRCrtcChangeNotifyEvent, display ), sizeof( Display * ) );
	swigStructField( "XRRCrtcChangeNotifyEvent-crtc", offsetof( XRRCrtcChangeNotifyEvent, crtc ), sizeof( RRCrtc ) );
	swigStructField( "XRRCrtcChangeNotifyEvent-x", offsetof( XRRCrtcChangeNotifyEvent, x ), sizeof( int ) );
	swigStructField( "XRRCrtcChangeNotifyEvent-y", offsetof( XRRCrtcChangeNotifyEvent, y ), sizeof( int ) );
	swigStructField( "XRRCrtcChangeNotifyEvent-serial", offsetof( XRRCrtcChangeNotifyEvent, serial ), sizeof( unsigned long ) );
	swigStructField( "XRRCrtcChangeNotifyEvent-window", offsetof( XRRCrtcChangeNotifyEvent, window ), sizeof( Window ) );
	swigStructField( "XRRCrtcChangeNotifyEvent-type", offsetof( XRRCrtcChangeNotifyEvent, type ), sizeof( int ) );
	swigStructField( "XRRCrtcChangeNotifyEvent-subtype", offsetof( XRRCrtcChangeNotifyEvent, subtype ), sizeof( int ) );
	swigStructField( "XRRCrtcChangeNotifyEvent-height", offsetof( XRRCrtcChangeNotifyEvent, height ), sizeof( unsigned int ) );
	swigStructField( "XRRCrtcChangeNotifyEvent-send_event", offsetof( XRRCrtcChangeNotifyEvent, send_event ), sizeof( int ) );
	swigStructField( "XRRCrtcChangeNotifyEvent-width", offsetof( XRRCrtcChangeNotifyEvent, width ), sizeof( unsigned int ) );
	swigStructField( "XRRCrtcChangeNotifyEvent-mode", offsetof( XRRCrtcChangeNotifyEvent, mode ), sizeof( RRMode ) );
	swigStructField( "XRRCrtcChangeNotifyEvent-rotation", offsetof( XRRCrtcChangeNotifyEvent, rotation ), sizeof( Rotation ) );
	printf( "drop %zu end-structure\n", sizeof( XRRCrtcChangeNotifyEvent ) );

	swigComment("XRROutputPropertyNotifyEvent\n");
	printf( "begin-structure XRROutputPropertyNotifyEvent\n" );
	swigStructField( "XRROutputPropertyNotifyEvent-display", offsetof( XRROutputPropertyNotifyEvent, display ), sizeof( Display * ) );
	swigStructField( "XRROutputPropertyNotifyEvent-property", offsetof( XRROutputPropertyNotifyEvent, property ), sizeof( Atom ) );
	swigStructField( "XRROutputPropertyNotifyEvent-output", offsetof( XRROutputPropertyNotifyEvent, output ), sizeof( RROutput ) );
	swigStructField( "XRROutputPropertyNotifyEvent-serial", offsetof( XRROutputPropertyNotifyEvent, serial ), sizeof( unsigned long ) );
	swigStructField( "XRROutputPropertyNotifyEvent-window", offsetof( XRROutputPropertyNotifyEvent, window ), sizeof( Window ) );
	swigStructField( "XRROutputPropertyNotifyEvent-type", offsetof( XRROutputPropertyNotifyEvent, type ), sizeof( int ) );
	swigStructField( "XRROutputPropertyNotifyEvent-subtype", offsetof( XRROutputPropertyNotifyEvent, subtype ), sizeof( int ) );
	swigStructField( "XRROutputPropertyNotifyEvent-send_event", offsetof( XRROutputPropertyNotifyEvent, send_event ), sizeof( int ) );
	swigStructField( "XRROutputPropertyNotifyEvent-timestamp", offsetof( XRROutputPropertyNotifyEvent, timestamp ), sizeof( Time ) );
	swigStructField( "XRROutputPropertyNotifyEvent-state", offsetof( XRROutputPropertyNotifyEvent, state ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( XRROutputPropertyNotifyEvent ) );

	swigComment("XRRProviderChangeNotifyEvent\n");
	printf( "begin-structure XRRProviderChangeNotifyEvent\n" );
	swigStructField( "XRRProviderChangeNotifyEvent-display", offsetof( XRRProviderChangeNotifyEvent, display ), sizeof( Display * ) );
	swigStructField( "XRRProviderChangeNotifyEvent-current_role", offsetof( XRRProviderChangeNotifyEvent, current_role ), sizeof( unsigned int ) );
	swigStructField( "XRRProviderChangeNotifyEvent-serial", offsetof( XRRProviderChangeNotifyEvent, serial ), sizeof( unsigned long ) );
	swigStructField( "XRRProviderChangeNotifyEvent-window", offsetof( XRRProviderChangeNotifyEvent, window ), sizeof( Window ) );
	swigStructField( "XRRProviderChangeNotifyEvent-provider", offsetof( XRRProviderChangeNotifyEvent, provider ), sizeof( RRProvider ) );
	swigStructField( "XRRProviderChangeNotifyEvent-type", offsetof( XRRProviderChangeNotifyEvent, type ), sizeof( int ) );
	swigStructField( "XRRProviderChangeNotifyEvent-subtype", offsetof( XRRProviderChangeNotifyEvent, subtype ), sizeof( int ) );
	swigStructField( "XRRProviderChangeNotifyEvent-send_event", offsetof( XRRProviderChangeNotifyEvent, send_event ), sizeof( int ) );
	swigStructField( "XRRProviderChangeNotifyEvent-timestamp", offsetof( XRRProviderChangeNotifyEvent, timestamp ), sizeof( Time ) );
	printf( "drop %zu end-structure\n", sizeof( XRRProviderChangeNotifyEvent ) );

	swigComment("XRRProviderPropertyNotifyEvent\n");
	printf( "begin-structure XRRProviderPropertyNotifyEvent\n" );
	swigStructField( "XRRProviderPropertyNotifyEvent-display", offsetof( XRRProviderPropertyNotifyEvent, display ), sizeof( Display * ) );
	swigStructField( "XRRProviderPropertyNotifyEvent-property", offsetof( XRRProviderPropertyNotifyEvent, property ), sizeof( Atom ) );
	swigStructField( "XRRProviderPropertyNotifyEvent-serial", offsetof( XRRProviderPropertyNotifyEvent, serial ), sizeof( unsigned long ) );
	swigStructField( "XRRProviderPropertyNotifyEvent-window", offsetof( XRRProviderPropertyNotifyEvent, window ), sizeof( Window ) );
	swigStructField( "XRRProviderPropertyNotifyEvent-provider", offsetof( XRRProviderPropertyNotifyEvent, provider ), sizeof( RRProvider ) );
	swigStructField( "XRRProviderPropertyNotifyEvent-type", offsetof( XRRProviderPropertyNotifyEvent, type ), sizeof( int ) );
	swigStructField( "XRRProviderPropertyNotifyEvent-subtype", offsetof( XRRProviderPropertyNotifyEvent, subtype ), sizeof( int ) );
	swigStructField( "XRRProviderPropertyNotifyEvent-send_event", offsetof( XRRProviderPropertyNotifyEvent, send_event ), sizeof( int ) );
	swigStructField( "XRRProviderPropertyNotifyEvent-timestamp", offsetof( XRRProviderPropertyNotifyEvent, timestamp ), sizeof( Time ) );
	swigStructField( "XRRProviderPropertyNotifyEvent-state", offsetof( XRRProviderPropertyNotifyEvent, state ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( XRRProviderPropertyNotifyEvent ) );

	swigComment("XRRResourceChangeNotifyEvent\n");
	printf( "begin-structure XRRResourceChangeNotifyEvent\n" );
	swigStructField( "XRRResourceChangeNotifyEvent-display", offsetof( XRRResourceChangeNotifyEvent, display ), sizeof( Display * ) );
	swigStructField( "XRRResourceChangeNotifyEvent-serial", offsetof( XRRResourceChangeNotifyEvent, serial ), sizeof( unsigned long ) );
	swigStructField( "XRRResourceChangeNotifyEvent-window", offsetof( XRRResourceChangeNotifyEvent, window ), sizeof( Window ) );
	swigStructField( "XRRResourceChangeNotifyEvent-type", offsetof( XRRResourceChangeNotifyEvent, type ), sizeof( int ) );
	swigStructField( "XRRResourceChangeNotifyEvent-subtype", offsetof( XRRResourceChangeNotifyEvent, subtype ), sizeof( int ) );
	swigStructField( "XRRResourceChangeNotifyEvent-send_event", offsetof( XRRResourceChangeNotifyEvent, send_event ), sizeof( int ) );
	swigStructField( "XRRResourceChangeNotifyEvent-timestamp", offsetof( XRRResourceChangeNotifyEvent, timestamp ), sizeof( Time ) );
	printf( "drop %zu end-structure\n", sizeof( XRRResourceChangeNotifyEvent ) );

	swigComment("XRRModeInfo\n");
	printf( "begin-structure XRRModeInfo\n" );
	swigStructField( "XRRModeInfo-vSyncEnd", offsetof( XRRModeInfo, vSyncEnd ), sizeof( unsigned int ) );
	swigStructField( "XRRModeInfo-hSyncEnd", offsetof( XRRModeInfo, hSyncEnd ), sizeof( unsigned int ) );
	swigStructField( "XRRModeInfo-hSkew", offsetof( XRRModeInfo, hSkew ), sizeof( unsigned int ) );
	swigStructField( "XRRModeInfo-nameLength", offsetof( XRRModeInfo, nameLength ), sizeof( unsigned int ) );
	swigStructField( "XRRModeInfo-height", offsetof( XRRModeInfo, height ), sizeof( unsigned int ) );
	swigStructField( "XRRModeInfo-name", offsetof( XRRModeInfo, name ), sizeof( char * ) );
	swigStructField( "XRRModeInfo-dotClock", offsetof( XRRModeInfo, dotClock ), sizeof( unsigned long ) );
	swigStructField( "XRRModeInfo-vTotal", offsetof( XRRModeInfo, vTotal ), sizeof( unsigned int ) );
	swigStructField( "XRRModeInfo-id", offsetof( XRRModeInfo, id ), sizeof( RRMode ) );
	swigStructField( "XRRModeInfo-width", offsetof( XRRModeInfo, width ), sizeof( unsigned int ) );
	swigStructField( "XRRModeInfo-hTotal", offsetof( XRRModeInfo, hTotal ), sizeof( unsigned int ) );
	swigStructField( "XRRModeInfo-vSyncStart", offsetof( XRRModeInfo, vSyncStart ), sizeof( unsigned int ) );
	swigStructField( "XRRModeInfo-hSyncStart", offsetof( XRRModeInfo, hSyncStart ), sizeof( unsigned int ) );
	swigStructField( "XRRModeInfo-modeFlags", offsetof( XRRModeInfo, modeFlags ), sizeof( XRRModeFlags ) );
	printf( "drop %zu end-structure\n", sizeof( XRRModeInfo ) );

	swigComment("XRRScreenResources\n");
	printf( "begin-structure XRRScreenResources\n" );
	swigStructField( "XRRScreenResources-ncrtc", offsetof( XRRScreenResources, ncrtc ), sizeof( int ) );
	swigStructField( "XRRScreenResources-crtcs", offsetof( XRRScreenResources, crtcs ), sizeof( RRCrtc * ) );
	swigStructField( "XRRScreenResources-noutput", offsetof( XRRScreenResources, noutput ), sizeof( int ) );
	swigStructField( "XRRScreenResources-outputs", offsetof( XRRScreenResources, outputs ), sizeof( RROutput * ) );
	swigStructField( "XRRScreenResources-timestamp", offsetof( XRRScreenResources, timestamp ), sizeof( Time ) );
	swigStructField( "XRRScreenResources-configTimestamp", offsetof( XRRScreenResources, configTimestamp ), sizeof( Time ) );
	swigStructField( "XRRScreenResources-nmode", offsetof( XRRScreenResources, nmode ), sizeof( int ) );
	swigStructField( "XRRScreenResources-modes", offsetof( XRRScreenResources, modes ), sizeof( XRRModeInfo * ) );
	printf( "drop %zu end-structure\n", sizeof( XRRScreenResources ) );

	swigComment("XRROutputInfo\n");
	printf( "begin-structure XRROutputInfo\n" );
	swigStructField( "XRROutputInfo-connection", offsetof( XRROutputInfo, connection ), sizeof( Connection ) );
	swigStructField( "XRROutputInfo-name", offsetof( XRROutputInfo, name ), sizeof( char * ) );
	swigStructField( "XRROutputInfo-clones", offsetof( XRROutputInfo, clones ), sizeof( RROutput * ) );
	swigStructField( "XRROutputInfo-mm_height", offsetof( XRROutputInfo, mm_height ), sizeof( unsigned long ) );
	swigStructField( "XRROutputInfo-nameLen", offsetof( XRROutputInfo, nameLen ), sizeof( int ) );
	swigStructField( "XRROutputInfo-crtc", offsetof( XRROutputInfo, crtc ), sizeof( RRCrtc ) );
	swigStructField( "XRROutputInfo-mm_width", offsetof( XRROutputInfo, mm_width ), sizeof( unsigned long ) );
	swigStructField( "XRROutputInfo-nmode", offsetof( XRROutputInfo, nmode ), sizeof( int ) );
	swigStructField( "XRROutputInfo-modes", offsetof( XRROutputInfo, modes ), sizeof( RRMode * ) );
	swigStructField( "XRROutputInfo-timestamp", offsetof( XRROutputInfo, timestamp ), sizeof( Time ) );
	swigStructField( "XRROutputInfo-subpixel_order", offsetof( XRROutputInfo, subpixel_order ), sizeof( SubpixelOrder ) );
	swigStructField( "XRROutputInfo-nclone", offsetof( XRROutputInfo, nclone ), sizeof( int ) );
	swigStructField( "XRROutputInfo-npreferred", offsetof( XRROutputInfo, npreferred ), sizeof( int ) );
	swigStructField( "XRROutputInfo-crtcs", offsetof( XRROutputInfo, crtcs ), sizeof( RRCrtc * ) );
	swigStructField( "XRROutputInfo-ncrtc", offsetof( XRROutputInfo, ncrtc ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( XRROutputInfo ) );

	swigComment("XRRPropertyInfo\n");
	printf( "begin-structure XRRPropertyInfo\n" );
	swigStructField( "XRRPropertyInfo-pending", offsetof( XRRPropertyInfo, pending ), sizeof( int ) );
	swigStructField( "XRRPropertyInfo-immutable", offsetof( XRRPropertyInfo, immutable ), sizeof( int ) );
	swigStructField( "XRRPropertyInfo-range", offsetof( XRRPropertyInfo, range ), sizeof( int ) );
	swigStructField( "XRRPropertyInfo-num_values", offsetof( XRRPropertyInfo, num_values ), sizeof( int ) );
	swigStructField( "XRRPropertyInfo-values", offsetof( XRRPropertyInfo, values ), sizeof( long * ) );
	printf( "drop %zu end-structure\n", sizeof( XRRPropertyInfo ) );

	swigComment("XRRCrtcInfo\n");
	printf( "begin-structure XRRCrtcInfo\n" );
	swigStructField( "XRRCrtcInfo-x", offsetof( XRRCrtcInfo, x ), sizeof( int ) );
	swigStructField( "XRRCrtcInfo-y", offsetof( XRRCrtcInfo, y ), sizeof( int ) );
	swigStructField( "XRRCrtcInfo-noutput", offsetof( XRRCrtcInfo, noutput ), sizeof( int ) );
	swigStructField( "XRRCrtcInfo-npossible", offsetof( XRRCrtcInfo, npossible ), sizeof( int ) );
	swigStructField( "XRRCrtcInfo-possible", offsetof( XRRCrtcInfo, possible ), sizeof( RROutput * ) );
	swigStructField( "XRRCrtcInfo-outputs", offsetof( XRRCrtcInfo, outputs ), sizeof( RROutput * ) );
	swigStructField( "XRRCrtcInfo-height", offsetof( XRRCrtcInfo, height ), sizeof( unsigned int ) );
	swigStructField( "XRRCrtcInfo-timestamp", offsetof( XRRCrtcInfo, timestamp ), sizeof( Time ) );
	swigStructField( "XRRCrtcInfo-width", offsetof( XRRCrtcInfo, width ), sizeof( unsigned int ) );
	swigStructField( "XRRCrtcInfo-rotations", offsetof( XRRCrtcInfo, rotations ), sizeof( Rotation ) );
	swigStructField( "XRRCrtcInfo-mode", offsetof( XRRCrtcInfo, mode ), sizeof( RRMode ) );
	swigStructField( "XRRCrtcInfo-rotation", offsetof( XRRCrtcInfo, rotation ), sizeof( Rotation ) );
	printf( "drop %zu end-structure\n", sizeof( XRRCrtcInfo ) );

	swigComment("XRRCrtcGamma\n");
	printf( "begin-structure XRRCrtcGamma\n" );
	swigStructField( "XRRCrtcGamma-blue", offsetof( XRRCrtcGamma, blue ), sizeof( unsigned short * ) );
	swigStructField( "XRRCrtcGamma-green", offsetof( XRRCrtcGamma, green ), sizeof( unsigned short * ) );
	swigStructField( "XRRCrtcGamma-size", offsetof( XRRCrtcGamma, size ), sizeof( int ) );
	swigStructField( "XRRCrtcGamma-red", offsetof( XRRCrtcGamma, red ), sizeof( unsigned short * ) );
	printf( "drop %zu end-structure\n", sizeof( XRRCrtcGamma ) );

	swigComment("XRRCrtcTransformAttributes\n");
	printf( "begin-structure XRRCrtcTransformAttributes\n" );
	swigStructField( "XRRCrtcTransformAttributes-currentFilter", offsetof( XRRCrtcTransformAttributes, currentFilter ), sizeof( char * ) );
	swigStructField( "XRRCrtcTransformAttributes-pendingFilter", offsetof( XRRCrtcTransformAttributes, pendingFilter ), sizeof( char * ) );
	swigStructField( "XRRCrtcTransformAttributes-pendingTransform", offsetof( XRRCrtcTransformAttributes, pendingTransform ), sizeof( XTransform ) );
	swigStructField( "XRRCrtcTransformAttributes-currentTransform", offsetof( XRRCrtcTransformAttributes, currentTransform ), sizeof( XTransform ) );
	swigStructField( "XRRCrtcTransformAttributes-currentParams", offsetof( XRRCrtcTransformAttributes, currentParams ), sizeof( XFixed * ) );
	swigStructField( "XRRCrtcTransformAttributes-pendingNparams", offsetof( XRRCrtcTransformAttributes, pendingNparams ), sizeof( int ) );
	swigStructField( "XRRCrtcTransformAttributes-pendingParams", offsetof( XRRCrtcTransformAttributes, pendingParams ), sizeof( XFixed * ) );
	swigStructField( "XRRCrtcTransformAttributes-currentNparams", offsetof( XRRCrtcTransformAttributes, currentNparams ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( XRRCrtcTransformAttributes ) );

	swigComment("XRRPanning\n");
	printf( "begin-structure XRRPanning\n" );
	swigStructField( "XRRPanning-left", offsetof( XRRPanning, left ), sizeof( unsigned int ) );
	swigStructField( "XRRPanning-track_top", offsetof( XRRPanning, track_top ), sizeof( unsigned int ) );
	swigStructField( "XRRPanning-track_width", offsetof( XRRPanning, track_width ), sizeof( unsigned int ) );
	swigStructField( "XRRPanning-track_height", offsetof( XRRPanning, track_height ), sizeof( unsigned int ) );
	swigStructField( "XRRPanning-border_right", offsetof( XRRPanning, border_right ), sizeof( int ) );
	swigStructField( "XRRPanning-top", offsetof( XRRPanning, top ), sizeof( unsigned int ) );
	swigStructField( "XRRPanning-height", offsetof( XRRPanning, height ), sizeof( unsigned int ) );
	swigStructField( "XRRPanning-track_left", offsetof( XRRPanning, track_left ), sizeof( unsigned int ) );
	swigStructField( "XRRPanning-border_left", offsetof( XRRPanning, border_left ), sizeof( int ) );
	swigStructField( "XRRPanning-timestamp", offsetof( XRRPanning, timestamp ), sizeof( Time ) );
	swigStructField( "XRRPanning-width", offsetof( XRRPanning, width ), sizeof( unsigned int ) );
	swigStructField( "XRRPanning-border_bottom", offsetof( XRRPanning, border_bottom ), sizeof( int ) );
	swigStructField( "XRRPanning-border_top", offsetof( XRRPanning, border_top ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( XRRPanning ) );

	swigComment("XRRProviderResources\n");
	printf( "begin-structure XRRProviderResources\n" );
	swigStructField( "XRRProviderResources-nproviders", offsetof( XRRProviderResources, nproviders ), sizeof( int ) );
	swigStructField( "XRRProviderResources-providers", offsetof( XRRProviderResources, providers ), sizeof( RRProvider * ) );
	swigStructField( "XRRProviderResources-timestamp", offsetof( XRRProviderResources, timestamp ), sizeof( Time ) );
	printf( "drop %zu end-structure\n", sizeof( XRRProviderResources ) );

	swigComment("XRRProviderInfo\n");
	printf( "begin-structure XRRProviderInfo\n" );
	swigStructField( "XRRProviderInfo-crtcs", offsetof( XRRProviderInfo, crtcs ), sizeof( RRCrtc * ) );
	swigStructField( "XRRProviderInfo-nassociatedproviders", offsetof( XRRProviderInfo, nassociatedproviders ), sizeof( int ) );
	swigStructField( "XRRProviderInfo-associated_providers", offsetof( XRRProviderInfo, associated_providers ), sizeof( RRProvider * ) );
	swigStructField( "XRRProviderInfo-capabilities", offsetof( XRRProviderInfo, capabilities ), sizeof( unsigned int ) );
	swigStructField( "XRRProviderInfo-ncrtcs", offsetof( XRRProviderInfo, ncrtcs ), sizeof( int ) );
	swigStructField( "XRRProviderInfo-name", offsetof( XRRProviderInfo, name ), sizeof( char * ) );
	swigStructField( "XRRProviderInfo-nameLen", offsetof( XRRProviderInfo, nameLen ), sizeof( int ) );
	swigStructField( "XRRProviderInfo-noutputs", offsetof( XRRProviderInfo, noutputs ), sizeof( int ) );
	swigStructField( "XRRProviderInfo-outputs", offsetof( XRRProviderInfo, outputs ), sizeof( RROutput * ) );
	swigStructField( "XRRProviderInfo-associated_capability", offsetof( XRRProviderInfo, associated_capability ), sizeof( unsigned int * ) );
	printf( "drop %zu end-structure\n", sizeof( XRRProviderInfo ) );

	swigComment("XRRMonitorInfo\n");
	printf( "begin-structure XRRMonitorInfo\n" );
	swigStructField( "XRRMonitorInfo-primary", offsetof( XRRMonitorInfo, primary ), sizeof( int ) );
	swigStructField( "XRRMonitorInfo-name", offsetof( XRRMonitorInfo, name ), sizeof( Atom ) );
	swigStructField( "XRRMonitorInfo-x", offsetof( XRRMonitorInfo, x ), sizeof( int ) );
	swigStructField( "XRRMonitorInfo-noutput", offsetof( XRRMonitorInfo, noutput ), sizeof( int ) );
	swigStructField( "XRRMonitorInfo-y", offsetof( XRRMonitorInfo, y ), sizeof( int ) );
	swigStructField( "XRRMonitorInfo-mheight", offsetof( XRRMonitorInfo, mheight ), sizeof( int ) );
	swigStructField( "XRRMonitorInfo-outputs", offsetof( XRRMonitorInfo, outputs ), sizeof( RROutput * ) );
	swigStructField( "XRRMonitorInfo-height", offsetof( XRRMonitorInfo, height ), sizeof( int ) );
	swigStructField( "XRRMonitorInfo-mwidth", offsetof( XRRMonitorInfo, mwidth ), sizeof( int ) );
	swigStructField( "XRRMonitorInfo-width", offsetof( XRRMonitorInfo, width ), sizeof( int ) );
	swigStructField( "XRRMonitorInfo-automatic", offsetof( XRRMonitorInfo, automatic ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( XRRMonitorInfo ) );

	swigNewline();

	swigComment("--===< function pointers >===---\n");
	swigFunctionPointer( "c-funptr _XExtData-free_private() {((struct _XExtData*)ptr)->free_private} a -- n", "", "", "	( extension -- )" );
	swigFunctionPointer( "c-funptr funcs-create_image() {((struct funcs*)ptr)->create_image} a a u n n a u u n n -- a", "", "", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunctionPointer( "c-funptr funcs-destroy_image() {((struct funcs*)ptr)->destroy_image} a -- n", "", "", "	( <noname> -- )" );
	swigFunctionPointer( "c-funptr funcs-get_pixel() {((struct funcs*)ptr)->get_pixel} a n n -- u", "", "", "	( <noname> <noname> <noname> -- )" );
	swigFunctionPointer( "c-funptr funcs-put_pixel() {((struct funcs*)ptr)->put_pixel} a n n u -- n", "", "", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunctionPointer( "c-funptr funcs-sub_image() {((struct funcs*)ptr)->sub_image} a n n u u -- a", "", "", "	( <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunctionPointer( "c-funptr funcs-add_pixel() {((struct funcs*)ptr)->add_pixel} a n -- n", "", "", "	( <noname> <noname> -- )" );

	swigNewline();

	swigComment("------===< callbacks >===-------\n");
	swigCallback( "c-callback XIMProc: a a a -- void", "", "", "	( <noname> <noname> <noname> -- )" );
	swigCallback( "c-callback XICProc: a a a -- n", "", "", "	( <noname> <noname> <noname> -- )" );
	swigCallback( "c-callback XIDProc: a a a -- void", "", "", "	( <noname> <noname> <noname> -- )" );
	swigCallback( "c-callback XErrorHandler: a a -- n", "", "", "	( <noname> <noname> -- )" );
	swigCallback( "c-callback XIOErrorHandler: a -- n", "", "", "	( <noname> -- )" );
	swigCallback( "c-callback XIOErrorExitHandler: a a -- void", "", "", "	( <noname> <noname> -- )" );
	swigCallback( "c-callback XConnectionWatchProc: a a n n a -- void", "", "", "	( <noname> <noname> <noname> <noname> <noname> -- )" );

	swigNewline();

	swigComment("------===< functions >===-------\n");
	swigFunction( "c-function _Xmblen _Xmblen a n -- n", "FUNCTION: _Xmblen ( str len -- n )", "EXTERN: \"C\" int _Xmblen( void * str, int len );", "	( str len -- )" );
	swigFunction( "c-function XLoadQueryFont XLoadQueryFont a s -- a", "FUNCTION: XLoadQueryFont (   -- a )", "EXTERN: \"C\" void * XLoadQueryFont( void * , char *  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XQueryFont XQueryFont a u -- a", "FUNCTION: XQueryFont (   -- a )", "EXTERN: \"C\" void * XQueryFont( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XGetMotionEvents XGetMotionEvents a u u u a -- a", "FUNCTION: XGetMotionEvents (      -- a )", "EXTERN: \"C\" void * XGetMotionEvents( void * , int , long , long , void *  );", "	( <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XDeleteModifiermapEntry XDeleteModifiermapEntry a u n -- a", "FUNCTION: XDeleteModifiermapEntry (    -- a )", "EXTERN: \"C\" void * XDeleteModifiermapEntry( void * , char , int  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XGetModifierMapping XGetModifierMapping a -- a", "FUNCTION: XGetModifierMapping (  -- a )", "EXTERN: \"C\" void * XGetModifierMapping( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XInsertModifiermapEntry XInsertModifiermapEntry a u n -- a", "FUNCTION: XInsertModifiermapEntry (    -- a )", "EXTERN: \"C\" void * XInsertModifiermapEntry( void * , char , int  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XNewModifiermap XNewModifiermap n -- a", "FUNCTION: XNewModifiermap (  -- a )", "EXTERN: \"C\" void * XNewModifiermap( int  );", "	( <noname> -- )" );
	swigFunction( "c-function XCreateImage XCreateImage a a u n n a u u n n -- a", "FUNCTION: XCreateImage (           -- a )", "EXTERN: \"C\" void * XCreateImage( void * , void * , int , int , int , void * , int , int , int , int  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XInitImage XInitImage a -- n", "FUNCTION: XInitImage (  -- n )", "EXTERN: \"C\" int XInitImage( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XGetImage XGetImage a u n n u u u n -- a", "FUNCTION: XGetImage (         -- a )", "EXTERN: \"C\" void * XGetImage( void * , int , int , int , int , int , long , int  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XGetSubImage XGetSubImage a u n n u u u n a n n -- a", "FUNCTION: XGetSubImage (            -- a )", "EXTERN: \"C\" void * XGetSubImage( void * , int , int , int , int , int , long , int , void * , int , int  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XOpenDisplay XOpenDisplay s -- a", "FUNCTION: XOpenDisplay (  -- a )", "EXTERN: \"C\" void * XOpenDisplay( char *  );", "	( <noname> -- )" );
	swigFunction( "c-function XrmInitialize XrmInitialize  -- void", "FUNCTION: XrmInitialize (  -- void )", "EXTERN: \"C\" void XrmInitialize(  );", "	( -- )" );
	swigFunction( "c-function XFetchBytes XFetchBytes a a -- a", "FUNCTION: XFetchBytes (   -- a )", "EXTERN: \"C\" void * XFetchBytes( void * , void *  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XFetchBuffer XFetchBuffer a a n -- a", "FUNCTION: XFetchBuffer (    -- a )", "EXTERN: \"C\" void * XFetchBuffer( void * , void * , int  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XGetAtomName XGetAtomName a u -- a", "FUNCTION: XGetAtomName (   -- a )", "EXTERN: \"C\" void * XGetAtomName( void * , long  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XGetAtomNames XGetAtomNames a a n a -- n", "FUNCTION: XGetAtomNames (     -- n )", "EXTERN: \"C\" int XGetAtomNames( void * , void * , int , void *  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XGetDefault XGetDefault a s s -- a", "FUNCTION: XGetDefault (    -- a )", "EXTERN: \"C\" void * XGetDefault( void * , char * , char *  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XDisplayName XDisplayName s -- a", "FUNCTION: XDisplayName (  -- a )", "EXTERN: \"C\" void * XDisplayName( char *  );", "	( <noname> -- )" );
	swigFunction( "c-function XKeysymToString XKeysymToString u -- a", "FUNCTION: XKeysymToString (  -- a )", "EXTERN: \"C\" void * XKeysymToString( int  );", "	( <noname> -- )" );
	swigFunction( "c-function XSynchronize XSynchronize a n -- a", "FUNCTION: XSynchronize (   -- a )", "EXTERN: \"C\" void * XSynchronize( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XSetAfterFunction XSetAfterFunction a a -- a", "FUNCTION: XSetAfterFunction (   -- a )", "EXTERN: \"C\" void * XSetAfterFunction( void * , void *  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XInternAtom XInternAtom a s n -- u", "FUNCTION: XInternAtom (    -- u )", "EXTERN: \"C\" long XInternAtom( void * , char * , int  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XInternAtoms XInternAtoms a a n n a -- n", "FUNCTION: XInternAtoms (      -- n )", "EXTERN: \"C\" int XInternAtoms( void * , void * , int , int , void *  );", "	( <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XCopyColormapAndFree XCopyColormapAndFree a u -- u", "FUNCTION: XCopyColormapAndFree (   -- u )", "EXTERN: \"C\" int XCopyColormapAndFree( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XCreateColormap XCreateColormap a u a n -- u", "FUNCTION: XCreateColormap (     -- u )", "EXTERN: \"C\" int XCreateColormap( void * , int , void * , int  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XCreatePixmapCursor XCreatePixmapCursor a u u a a u u -- u", "FUNCTION: XCreatePixmapCursor (        -- u )", "EXTERN: \"C\" int XCreatePixmapCursor( void * , int , int , void * , void * , int , int  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XCreateGlyphCursor XCreateGlyphCursor a u u u u a a -- u", "FUNCTION: XCreateGlyphCursor (        -- u )", "EXTERN: \"C\" int XCreateGlyphCursor( void * , int , int , int , int , void * , void *  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XCreateFontCursor XCreateFontCursor a u -- u", "FUNCTION: XCreateFontCursor (   -- u )", "EXTERN: \"C\" int XCreateFontCursor( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XLoadFont XLoadFont a s -- u", "FUNCTION: XLoadFont (   -- u )", "EXTERN: \"C\" int XLoadFont( void * , char *  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XCreateGC XCreateGC a u u a -- a", "FUNCTION: XCreateGC (     -- a )", "EXTERN: \"C\" void * XCreateGC( void * , int , long , void *  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XGContextFromGC XGContextFromGC a -- u", "FUNCTION: XGContextFromGC (  -- u )", "EXTERN: \"C\" int XGContextFromGC( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XFlushGC XFlushGC a a -- void", "FUNCTION: XFlushGC (   -- void )", "EXTERN: \"C\" void XFlushGC( void * , void *  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XCreatePixmap XCreatePixmap a u u u u -- u", "FUNCTION: XCreatePixmap (      -- u )", "EXTERN: \"C\" int XCreatePixmap( void * , int , int , int , int  );", "	( <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XCreateBitmapFromData XCreateBitmapFromData a u s u u -- u", "FUNCTION: XCreateBitmapFromData (      -- u )", "EXTERN: \"C\" int XCreateBitmapFromData( void * , int , char * , int , int  );", "	( <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XCreatePixmapFromBitmapData XCreatePixmapFromBitmapData a u a u u u u u -- u", "FUNCTION: XCreatePixmapFromBitmapData (         -- u )", "EXTERN: \"C\" int XCreatePixmapFromBitmapData( void * , int , void * , int , int , long , long , int  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XCreateSimpleWindow XCreateSimpleWindow a u n n u u u u u -- u", "FUNCTION: XCreateSimpleWindow (          -- u )", "EXTERN: \"C\" int XCreateSimpleWindow( void * , int , int , int , int , int , int , long , long  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XGetSelectionOwner XGetSelectionOwner a u -- u", "FUNCTION: XGetSelectionOwner (   -- u )", "EXTERN: \"C\" int XGetSelectionOwner( void * , long  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XCreateWindow XCreateWindow a u n n u u u n u a u a -- u", "FUNCTION: XCreateWindow (             -- u )", "EXTERN: \"C\" int XCreateWindow( void * , int , int , int , int , int , int , int , int , void * , long , void *  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XListInstalledColormaps XListInstalledColormaps a u a -- a", "FUNCTION: XListInstalledColormaps (    -- a )", "EXTERN: \"C\" void * XListInstalledColormaps( void * , int , void *  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XListFonts XListFonts a s n a -- a", "FUNCTION: XListFonts (     -- a )", "EXTERN: \"C\" void * XListFonts( void * , char * , int , void *  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XListFontsWithInfo XListFontsWithInfo a s n a a -- a", "FUNCTION: XListFontsWithInfo (      -- a )", "EXTERN: \"C\" void * XListFontsWithInfo( void * , char * , int , void * , void *  );", "	( <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XGetFontPath XGetFontPath a a -- a", "FUNCTION: XGetFontPath (   -- a )", "EXTERN: \"C\" void * XGetFontPath( void * , void *  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XListExtensions XListExtensions a a -- a", "FUNCTION: XListExtensions (   -- a )", "EXTERN: \"C\" void * XListExtensions( void * , void *  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XListProperties XListProperties a u a -- a", "FUNCTION: XListProperties (    -- a )", "EXTERN: \"C\" void * XListProperties( void * , int , void *  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XListHosts XListHosts a a a -- a", "FUNCTION: XListHosts (    -- a )", "EXTERN: \"C\" void * XListHosts( void * , void * , void *  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XKeycodeToKeysym XKeycodeToKeysym a u n -- u", "FUNCTION: XKeycodeToKeysym (    -- u )", "EXTERN: \"C\" int XKeycodeToKeysym( void * , char , int  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XLookupKeysym XLookupKeysym a n -- u", "FUNCTION: XLookupKeysym (   -- u )", "EXTERN: \"C\" int XLookupKeysym( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XGetKeyboardMapping XGetKeyboardMapping a u n a -- a", "FUNCTION: XGetKeyboardMapping (     -- a )", "EXTERN: \"C\" void * XGetKeyboardMapping( void * , char , int , void *  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XStringToKeysym XStringToKeysym s -- u", "FUNCTION: XStringToKeysym (  -- u )", "EXTERN: \"C\" int XStringToKeysym( char *  );", "	( <noname> -- )" );
	swigFunction( "c-function XMaxRequestSize XMaxRequestSize a -- n", "FUNCTION: XMaxRequestSize (  -- n )", "EXTERN: \"C\" long XMaxRequestSize( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XExtendedMaxRequestSize XExtendedMaxRequestSize a -- n", "FUNCTION: XExtendedMaxRequestSize (  -- n )", "EXTERN: \"C\" long XExtendedMaxRequestSize( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XResourceManagerString XResourceManagerString a -- a", "FUNCTION: XResourceManagerString (  -- a )", "EXTERN: \"C\" void * XResourceManagerString( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XScreenResourceString XScreenResourceString a -- a", "FUNCTION: XScreenResourceString (  -- a )", "EXTERN: \"C\" void * XScreenResourceString( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XDisplayMotionBufferSize XDisplayMotionBufferSize a -- u", "FUNCTION: XDisplayMotionBufferSize (  -- u )", "EXTERN: \"C\" long XDisplayMotionBufferSize( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XVisualIDFromVisual XVisualIDFromVisual a -- u", "FUNCTION: XVisualIDFromVisual (  -- u )", "EXTERN: \"C\" long XVisualIDFromVisual( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XInitThreads XInitThreads  -- n", "FUNCTION: XInitThreads (  -- n )", "EXTERN: \"C\" int XInitThreads(  );", "	( -- )" );
	swigFunction( "c-function XLockDisplay XLockDisplay a -- void", "FUNCTION: XLockDisplay (  -- void )", "EXTERN: \"C\" void XLockDisplay( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XUnlockDisplay XUnlockDisplay a -- void", "FUNCTION: XUnlockDisplay (  -- void )", "EXTERN: \"C\" void XUnlockDisplay( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XInitExtension XInitExtension a s -- a", "FUNCTION: XInitExtension (   -- a )", "EXTERN: \"C\" void * XInitExtension( void * , char *  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XAddExtension XAddExtension a -- a", "FUNCTION: XAddExtension (  -- a )", "EXTERN: \"C\" void * XAddExtension( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XFindOnExtensionList XFindOnExtensionList a n -- a", "FUNCTION: XFindOnExtensionList (   -- a )", "EXTERN: \"C\" void * XFindOnExtensionList( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XEHeadOfExtensionList XEHeadOfExtensionList a{*(XEDataObject*)} -- a", "FUNCTION: XEHeadOfExtensionList (  -- a )", "EXTERN: \"C\" void * XEHeadOfExtensionList( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XRootWindow XRootWindow a n -- u", "FUNCTION: XRootWindow (   -- u )", "EXTERN: \"C\" int XRootWindow( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XDefaultRootWindow XDefaultRootWindow a -- u", "FUNCTION: XDefaultRootWindow (  -- u )", "EXTERN: \"C\" int XDefaultRootWindow( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XRootWindowOfScreen XRootWindowOfScreen a -- u", "FUNCTION: XRootWindowOfScreen (  -- u )", "EXTERN: \"C\" int XRootWindowOfScreen( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XDefaultVisual XDefaultVisual a n -- a", "FUNCTION: XDefaultVisual (   -- a )", "EXTERN: \"C\" void * XDefaultVisual( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XDefaultVisualOfScreen XDefaultVisualOfScreen a -- a", "FUNCTION: XDefaultVisualOfScreen (  -- a )", "EXTERN: \"C\" void * XDefaultVisualOfScreen( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XDefaultGC XDefaultGC a n -- a", "FUNCTION: XDefaultGC (   -- a )", "EXTERN: \"C\" void * XDefaultGC( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XDefaultGCOfScreen XDefaultGCOfScreen a -- a", "FUNCTION: XDefaultGCOfScreen (  -- a )", "EXTERN: \"C\" void * XDefaultGCOfScreen( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XBlackPixel XBlackPixel a n -- u", "FUNCTION: XBlackPixel (   -- u )", "EXTERN: \"C\" long XBlackPixel( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XWhitePixel XWhitePixel a n -- u", "FUNCTION: XWhitePixel (   -- u )", "EXTERN: \"C\" long XWhitePixel( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XAllPlanes XAllPlanes  -- u", "FUNCTION: XAllPlanes (  -- u )", "EXTERN: \"C\" long XAllPlanes(  );", "	( -- )" );
	swigFunction( "c-function XBlackPixelOfScreen XBlackPixelOfScreen a -- u", "FUNCTION: XBlackPixelOfScreen (  -- u )", "EXTERN: \"C\" long XBlackPixelOfScreen( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XWhitePixelOfScreen XWhitePixelOfScreen a -- u", "FUNCTION: XWhitePixelOfScreen (  -- u )", "EXTERN: \"C\" long XWhitePixelOfScreen( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XNextRequest XNextRequest a -- u", "FUNCTION: XNextRequest (  -- u )", "EXTERN: \"C\" long XNextRequest( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XLastKnownRequestProcessed XLastKnownRequestProcessed a -- u", "FUNCTION: XLastKnownRequestProcessed (  -- u )", "EXTERN: \"C\" long XLastKnownRequestProcessed( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XServerVendor XServerVendor a -- a", "FUNCTION: XServerVendor (  -- a )", "EXTERN: \"C\" void * XServerVendor( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XDisplayString XDisplayString a -- a", "FUNCTION: XDisplayString (  -- a )", "EXTERN: \"C\" void * XDisplayString( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XDefaultColormap XDefaultColormap a n -- u", "FUNCTION: XDefaultColormap (   -- u )", "EXTERN: \"C\" int XDefaultColormap( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XDefaultColormapOfScreen XDefaultColormapOfScreen a -- u", "FUNCTION: XDefaultColormapOfScreen (  -- u )", "EXTERN: \"C\" int XDefaultColormapOfScreen( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XDisplayOfScreen XDisplayOfScreen a -- a", "FUNCTION: XDisplayOfScreen (  -- a )", "EXTERN: \"C\" void * XDisplayOfScreen( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XScreenOfDisplay XScreenOfDisplay a n -- a", "FUNCTION: XScreenOfDisplay (   -- a )", "EXTERN: \"C\" void * XScreenOfDisplay( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XDefaultScreenOfDisplay XDefaultScreenOfDisplay a -- a", "FUNCTION: XDefaultScreenOfDisplay (  -- a )", "EXTERN: \"C\" void * XDefaultScreenOfDisplay( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XEventMaskOfScreen XEventMaskOfScreen a -- n", "FUNCTION: XEventMaskOfScreen (  -- n )", "EXTERN: \"C\" long XEventMaskOfScreen( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XScreenNumberOfScreen XScreenNumberOfScreen a -- n", "FUNCTION: XScreenNumberOfScreen (  -- n )", "EXTERN: \"C\" int XScreenNumberOfScreen( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XSetErrorHandler XSetErrorHandler a -- a", "FUNCTION: XSetErrorHandler (  -- a )", "EXTERN: \"C\" void * XSetErrorHandler( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XSetIOErrorHandler XSetIOErrorHandler a -- a", "FUNCTION: XSetIOErrorHandler (  -- a )", "EXTERN: \"C\" void * XSetIOErrorHandler( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XSetIOErrorExitHandler XSetIOErrorExitHandler a a a -- void", "FUNCTION: XSetIOErrorExitHandler (    -- void )", "EXTERN: \"C\" void XSetIOErrorExitHandler( void * , void * , void *  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XListPixmapFormats XListPixmapFormats a a -- a", "FUNCTION: XListPixmapFormats (   -- a )", "EXTERN: \"C\" void * XListPixmapFormats( void * , void *  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XListDepths XListDepths a n a -- a", "FUNCTION: XListDepths (    -- a )", "EXTERN: \"C\" void * XListDepths( void * , int , void *  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XReconfigureWMWindow XReconfigureWMWindow a u n u a -- n", "FUNCTION: XReconfigureWMWindow (      -- n )", "EXTERN: \"C\" int XReconfigureWMWindow( void * , int , int , int , void *  );", "	( <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XGetWMProtocols XGetWMProtocols a u a a -- n", "FUNCTION: XGetWMProtocols (     -- n )", "EXTERN: \"C\" int XGetWMProtocols( void * , int , void * , void *  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSetWMProtocols XSetWMProtocols a u a n -- n", "FUNCTION: XSetWMProtocols (     -- n )", "EXTERN: \"C\" int XSetWMProtocols( void * , int , void * , int  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XIconifyWindow XIconifyWindow a u n -- n", "FUNCTION: XIconifyWindow (    -- n )", "EXTERN: \"C\" int XIconifyWindow( void * , int , int  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XWithdrawWindow XWithdrawWindow a u n -- n", "FUNCTION: XWithdrawWindow (    -- n )", "EXTERN: \"C\" int XWithdrawWindow( void * , int , int  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XGetCommand XGetCommand a u a a -- n", "FUNCTION: XGetCommand (     -- n )", "EXTERN: \"C\" int XGetCommand( void * , int , void * , void *  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XGetWMColormapWindows XGetWMColormapWindows a u a a -- n", "FUNCTION: XGetWMColormapWindows (     -- n )", "EXTERN: \"C\" int XGetWMColormapWindows( void * , int , void * , void *  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSetWMColormapWindows XSetWMColormapWindows a u a n -- n", "FUNCTION: XSetWMColormapWindows (     -- n )", "EXTERN: \"C\" int XSetWMColormapWindows( void * , int , void * , int  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XFreeStringList XFreeStringList a -- void", "FUNCTION: XFreeStringList (  -- void )", "EXTERN: \"C\" void XFreeStringList( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XSetTransientForHint XSetTransientForHint a u u -- n", "FUNCTION: XSetTransientForHint (    -- n )", "EXTERN: \"C\" int XSetTransientForHint( void * , int , int  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XActivateScreenSaver XActivateScreenSaver a -- n", "FUNCTION: XActivateScreenSaver (  -- n )", "EXTERN: \"C\" int XActivateScreenSaver( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XAddHost XAddHost a a -- n", "FUNCTION: XAddHost (   -- n )", "EXTERN: \"C\" int XAddHost( void * , void *  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XAddHosts XAddHosts a a n -- n", "FUNCTION: XAddHosts (    -- n )", "EXTERN: \"C\" int XAddHosts( void * , void * , int  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XAddToExtensionList XAddToExtensionList a a -- n", "FUNCTION: XAddToExtensionList (   -- n )", "EXTERN: \"C\" int XAddToExtensionList( void * , void *  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XAddToSaveSet XAddToSaveSet a u -- n", "FUNCTION: XAddToSaveSet (   -- n )", "EXTERN: \"C\" int XAddToSaveSet( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XAllocColor XAllocColor a u a -- n", "FUNCTION: XAllocColor (    -- n )", "EXTERN: \"C\" int XAllocColor( void * , int , void *  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XAllocColorCells XAllocColorCells a u n a u a u -- n", "FUNCTION: XAllocColorCells (        -- n )", "EXTERN: \"C\" int XAllocColorCells( void * , int , int , void * , int , void * , int  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XAllocColorPlanes XAllocColorPlanes a u n a n n n n a a a -- n", "FUNCTION: XAllocColorPlanes (            -- n )", "EXTERN: \"C\" int XAllocColorPlanes( void * , int , int , void * , int , int , int , int , void * , void * , void *  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XAllocNamedColor XAllocNamedColor a u s a a -- n", "FUNCTION: XAllocNamedColor (      -- n )", "EXTERN: \"C\" int XAllocNamedColor( void * , int , char * , void * , void *  );", "	( <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XAllowEvents XAllowEvents a n u -- n", "FUNCTION: XAllowEvents (    -- n )", "EXTERN: \"C\" int XAllowEvents( void * , int , long  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XAutoRepeatOff XAutoRepeatOff a -- n", "FUNCTION: XAutoRepeatOff (  -- n )", "EXTERN: \"C\" int XAutoRepeatOff( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XAutoRepeatOn XAutoRepeatOn a -- n", "FUNCTION: XAutoRepeatOn (  -- n )", "EXTERN: \"C\" int XAutoRepeatOn( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XBell XBell a n -- n", "FUNCTION: XBell (   -- n )", "EXTERN: \"C\" int XBell( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XBitmapBitOrder XBitmapBitOrder a -- n", "FUNCTION: XBitmapBitOrder (  -- n )", "EXTERN: \"C\" int XBitmapBitOrder( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XBitmapPad XBitmapPad a -- n", "FUNCTION: XBitmapPad (  -- n )", "EXTERN: \"C\" int XBitmapPad( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XBitmapUnit XBitmapUnit a -- n", "FUNCTION: XBitmapUnit (  -- n )", "EXTERN: \"C\" int XBitmapUnit( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XCellsOfScreen XCellsOfScreen a -- n", "FUNCTION: XCellsOfScreen (  -- n )", "EXTERN: \"C\" int XCellsOfScreen( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XChangeActivePointerGrab XChangeActivePointerGrab a u u u -- n", "FUNCTION: XChangeActivePointerGrab (     -- n )", "EXTERN: \"C\" int XChangeActivePointerGrab( void * , int , int , long  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XChangeGC XChangeGC a a u a -- n", "FUNCTION: XChangeGC (     -- n )", "EXTERN: \"C\" int XChangeGC( void * , void * , long , void *  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XChangeKeyboardControl XChangeKeyboardControl a u a -- n", "FUNCTION: XChangeKeyboardControl (    -- n )", "EXTERN: \"C\" int XChangeKeyboardControl( void * , long , void *  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XChangeKeyboardMapping XChangeKeyboardMapping a n n a n -- n", "FUNCTION: XChangeKeyboardMapping (      -- n )", "EXTERN: \"C\" int XChangeKeyboardMapping( void * , int , int , void * , int  );", "	( <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XChangePointerControl XChangePointerControl a n n n n n -- n", "FUNCTION: XChangePointerControl (       -- n )", "EXTERN: \"C\" int XChangePointerControl( void * , int , int , int , int , int  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XChangeProperty XChangeProperty a u u u n n a n -- n", "FUNCTION: XChangeProperty (         -- n )", "EXTERN: \"C\" int XChangeProperty( void * , int , long , long , int , int , void * , int  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XChangeSaveSet XChangeSaveSet a u n -- n", "FUNCTION: XChangeSaveSet (    -- n )", "EXTERN: \"C\" int XChangeSaveSet( void * , int , int  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XChangeWindowAttributes XChangeWindowAttributes a u u a -- n", "FUNCTION: XChangeWindowAttributes (     -- n )", "EXTERN: \"C\" int XChangeWindowAttributes( void * , int , long , void *  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XCheckIfEvent XCheckIfEvent a a a a -- n", "FUNCTION: XCheckIfEvent (     -- n )", "EXTERN: \"C\" int XCheckIfEvent( void * , void * , void * , void *  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XCheckMaskEvent XCheckMaskEvent a n a -- n", "FUNCTION: XCheckMaskEvent (    -- n )", "EXTERN: \"C\" int XCheckMaskEvent( void * , long , void *  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XCheckTypedEvent XCheckTypedEvent a n a -- n", "FUNCTION: XCheckTypedEvent (    -- n )", "EXTERN: \"C\" int XCheckTypedEvent( void * , int , void *  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XCheckTypedWindowEvent XCheckTypedWindowEvent a u n a -- n", "FUNCTION: XCheckTypedWindowEvent (     -- n )", "EXTERN: \"C\" int XCheckTypedWindowEvent( void * , int , int , void *  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XCheckWindowEvent XCheckWindowEvent a u n a -- n", "FUNCTION: XCheckWindowEvent (     -- n )", "EXTERN: \"C\" int XCheckWindowEvent( void * , int , long , void *  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XCirculateSubwindows XCirculateSubwindows a u n -- n", "FUNCTION: XCirculateSubwindows (    -- n )", "EXTERN: \"C\" int XCirculateSubwindows( void * , int , int  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XCirculateSubwindowsDown XCirculateSubwindowsDown a u -- n", "FUNCTION: XCirculateSubwindowsDown (   -- n )", "EXTERN: \"C\" int XCirculateSubwindowsDown( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XCirculateSubwindowsUp XCirculateSubwindowsUp a u -- n", "FUNCTION: XCirculateSubwindowsUp (   -- n )", "EXTERN: \"C\" int XCirculateSubwindowsUp( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XClearArea XClearArea a u n n u u n -- n", "FUNCTION: XClearArea (        -- n )", "EXTERN: \"C\" int XClearArea( void * , int , int , int , int , int , int  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XClearWindow XClearWindow a u -- n", "FUNCTION: XClearWindow (   -- n )", "EXTERN: \"C\" int XClearWindow( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XCloseDisplay XCloseDisplay a -- n", "FUNCTION: XCloseDisplay (  -- n )", "EXTERN: \"C\" int XCloseDisplay( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XConfigureWindow XConfigureWindow a u u a -- n", "FUNCTION: XConfigureWindow (     -- n )", "EXTERN: \"C\" int XConfigureWindow( void * , int , int , void *  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XConnectionNumber XConnectionNumber a -- n", "FUNCTION: XConnectionNumber (  -- n )", "EXTERN: \"C\" int XConnectionNumber( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XConvertSelection XConvertSelection a u u u u u -- n", "FUNCTION: XConvertSelection (       -- n )", "EXTERN: \"C\" int XConvertSelection( void * , long , long , long , int , long  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XCopyArea XCopyArea a u u a n n u u n n -- n", "FUNCTION: XCopyArea (           -- n )", "EXTERN: \"C\" int XCopyArea( void * , int , int , void * , int , int , int , int , int , int  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XCopyGC XCopyGC a a u a -- n", "FUNCTION: XCopyGC (     -- n )", "EXTERN: \"C\" int XCopyGC( void * , void * , long , void *  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XCopyPlane XCopyPlane a u u a n n u u n n u -- n", "FUNCTION: XCopyPlane (            -- n )", "EXTERN: \"C\" int XCopyPlane( void * , int , int , void * , int , int , int , int , int , int , long  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XDefaultDepth XDefaultDepth a n -- n", "FUNCTION: XDefaultDepth (   -- n )", "EXTERN: \"C\" int XDefaultDepth( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XDefaultDepthOfScreen XDefaultDepthOfScreen a -- n", "FUNCTION: XDefaultDepthOfScreen (  -- n )", "EXTERN: \"C\" int XDefaultDepthOfScreen( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XDefaultScreen XDefaultScreen a -- n", "FUNCTION: XDefaultScreen (  -- n )", "EXTERN: \"C\" int XDefaultScreen( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XDefineCursor XDefineCursor a u u -- n", "FUNCTION: XDefineCursor (    -- n )", "EXTERN: \"C\" int XDefineCursor( void * , int , int  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XDeleteProperty XDeleteProperty a u u -- n", "FUNCTION: XDeleteProperty (    -- n )", "EXTERN: \"C\" int XDeleteProperty( void * , int , long  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XDestroyWindow XDestroyWindow a u -- n", "FUNCTION: XDestroyWindow (   -- n )", "EXTERN: \"C\" int XDestroyWindow( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XDestroySubwindows XDestroySubwindows a u -- n", "FUNCTION: XDestroySubwindows (   -- n )", "EXTERN: \"C\" int XDestroySubwindows( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XDoesBackingStore XDoesBackingStore a -- n", "FUNCTION: XDoesBackingStore (  -- n )", "EXTERN: \"C\" int XDoesBackingStore( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XDoesSaveUnders XDoesSaveUnders a -- n", "FUNCTION: XDoesSaveUnders (  -- n )", "EXTERN: \"C\" int XDoesSaveUnders( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XDisableAccessControl XDisableAccessControl a -- n", "FUNCTION: XDisableAccessControl (  -- n )", "EXTERN: \"C\" int XDisableAccessControl( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XDisplayCells XDisplayCells a n -- n", "FUNCTION: XDisplayCells (   -- n )", "EXTERN: \"C\" int XDisplayCells( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XDisplayHeight XDisplayHeight a n -- n", "FUNCTION: XDisplayHeight (   -- n )", "EXTERN: \"C\" int XDisplayHeight( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XDisplayHeightMM XDisplayHeightMM a n -- n", "FUNCTION: XDisplayHeightMM (   -- n )", "EXTERN: \"C\" int XDisplayHeightMM( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XDisplayKeycodes XDisplayKeycodes a a a -- n", "FUNCTION: XDisplayKeycodes (    -- n )", "EXTERN: \"C\" int XDisplayKeycodes( void * , void * , void *  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XDisplayPlanes XDisplayPlanes a n -- n", "FUNCTION: XDisplayPlanes (   -- n )", "EXTERN: \"C\" int XDisplayPlanes( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XDisplayWidth XDisplayWidth a n -- n", "FUNCTION: XDisplayWidth (   -- n )", "EXTERN: \"C\" int XDisplayWidth( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XDisplayWidthMM XDisplayWidthMM a n -- n", "FUNCTION: XDisplayWidthMM (   -- n )", "EXTERN: \"C\" int XDisplayWidthMM( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XDrawArc XDrawArc a u a n n u u n n -- n", "FUNCTION: XDrawArc (          -- n )", "EXTERN: \"C\" int XDrawArc( void * , int , void * , int , int , int , int , int , int  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XDrawArcs XDrawArcs a u a a n -- n", "FUNCTION: XDrawArcs (      -- n )", "EXTERN: \"C\" int XDrawArcs( void * , int , void * , void * , int  );", "	( <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XDrawImageString XDrawImageString a u a n n s n -- n", "FUNCTION: XDrawImageString (        -- n )", "EXTERN: \"C\" int XDrawImageString( void * , int , void * , int , int , char * , int  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XDrawImageString16 XDrawImageString16 a u a n n a n -- n", "FUNCTION: XDrawImageString16 (        -- n )", "EXTERN: \"C\" int XDrawImageString16( void * , int , void * , int , int , void * , int  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XDrawLine XDrawLine a u a n n n n -- n", "FUNCTION: XDrawLine (        -- n )", "EXTERN: \"C\" int XDrawLine( void * , int , void * , int , int , int , int  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XDrawLines XDrawLines a u a a n n -- n", "FUNCTION: XDrawLines (       -- n )", "EXTERN: \"C\" int XDrawLines( void * , int , void * , void * , int , int  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XDrawPoint XDrawPoint a u a n n -- n", "FUNCTION: XDrawPoint (      -- n )", "EXTERN: \"C\" int XDrawPoint( void * , int , void * , int , int  );", "	( <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XDrawPoints XDrawPoints a u a a n n -- n", "FUNCTION: XDrawPoints (       -- n )", "EXTERN: \"C\" int XDrawPoints( void * , int , void * , void * , int , int  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XDrawRectangle XDrawRectangle a u a n n u u -- n", "FUNCTION: XDrawRectangle (        -- n )", "EXTERN: \"C\" int XDrawRectangle( void * , int , void * , int , int , int , int  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XDrawRectangles XDrawRectangles a u a a n -- n", "FUNCTION: XDrawRectangles (      -- n )", "EXTERN: \"C\" int XDrawRectangles( void * , int , void * , void * , int  );", "	( <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XDrawSegments XDrawSegments a u a a n -- n", "FUNCTION: XDrawSegments (      -- n )", "EXTERN: \"C\" int XDrawSegments( void * , int , void * , void * , int  );", "	( <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XDrawString XDrawString a u a n n s n -- n", "FUNCTION: XDrawString (        -- n )", "EXTERN: \"C\" int XDrawString( void * , int , void * , int , int , char * , int  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XDrawString16 XDrawString16 a u a n n a n -- n", "FUNCTION: XDrawString16 (        -- n )", "EXTERN: \"C\" int XDrawString16( void * , int , void * , int , int , void * , int  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XDrawText XDrawText a u a n n a n -- n", "FUNCTION: XDrawText (        -- n )", "EXTERN: \"C\" int XDrawText( void * , int , void * , int , int , void * , int  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XDrawText16 XDrawText16 a u a n n a n -- n", "FUNCTION: XDrawText16 (        -- n )", "EXTERN: \"C\" int XDrawText16( void * , int , void * , int , int , void * , int  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XEnableAccessControl XEnableAccessControl a -- n", "FUNCTION: XEnableAccessControl (  -- n )", "EXTERN: \"C\" int XEnableAccessControl( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XEventsQueued XEventsQueued a n -- n", "FUNCTION: XEventsQueued (   -- n )", "EXTERN: \"C\" int XEventsQueued( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XFetchName XFetchName a u a -- n", "FUNCTION: XFetchName (    -- n )", "EXTERN: \"C\" int XFetchName( void * , int , void *  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XFillArc XFillArc a u a n n u u n n -- n", "FUNCTION: XFillArc (          -- n )", "EXTERN: \"C\" int XFillArc( void * , int , void * , int , int , int , int , int , int  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XFillArcs XFillArcs a u a a n -- n", "FUNCTION: XFillArcs (      -- n )", "EXTERN: \"C\" int XFillArcs( void * , int , void * , void * , int  );", "	( <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XFillPolygon XFillPolygon a u a a n n n -- n", "FUNCTION: XFillPolygon (        -- n )", "EXTERN: \"C\" int XFillPolygon( void * , int , void * , void * , int , int , int  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XFillRectangle XFillRectangle a u a n n u u -- n", "FUNCTION: XFillRectangle (        -- n )", "EXTERN: \"C\" int XFillRectangle( void * , int , void * , int , int , int , int  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XFillRectangles XFillRectangles a u a a n -- n", "FUNCTION: XFillRectangles (      -- n )", "EXTERN: \"C\" int XFillRectangles( void * , int , void * , void * , int  );", "	( <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XFlush XFlush a -- n", "FUNCTION: XFlush (  -- n )", "EXTERN: \"C\" int XFlush( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XForceScreenSaver XForceScreenSaver a n -- n", "FUNCTION: XForceScreenSaver (   -- n )", "EXTERN: \"C\" int XForceScreenSaver( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XFree XFree a -- n", "FUNCTION: XFree (  -- n )", "EXTERN: \"C\" int XFree( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XFreeColormap XFreeColormap a u -- n", "FUNCTION: XFreeColormap (   -- n )", "EXTERN: \"C\" int XFreeColormap( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XFreeColors XFreeColors a u a n u -- n", "FUNCTION: XFreeColors (      -- n )", "EXTERN: \"C\" int XFreeColors( void * , int , void * , int , long  );", "	( <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XFreeCursor XFreeCursor a u -- n", "FUNCTION: XFreeCursor (   -- n )", "EXTERN: \"C\" int XFreeCursor( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XFreeExtensionList XFreeExtensionList a -- n", "FUNCTION: XFreeExtensionList (  -- n )", "EXTERN: \"C\" int XFreeExtensionList( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XFreeFont XFreeFont a a -- n", "FUNCTION: XFreeFont (   -- n )", "EXTERN: \"C\" int XFreeFont( void * , void *  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XFreeFontInfo XFreeFontInfo a a n -- n", "FUNCTION: XFreeFontInfo (    -- n )", "EXTERN: \"C\" int XFreeFontInfo( void * , void * , int  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XFreeFontNames XFreeFontNames a -- n", "FUNCTION: XFreeFontNames (  -- n )", "EXTERN: \"C\" int XFreeFontNames( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XFreeFontPath XFreeFontPath a -- n", "FUNCTION: XFreeFontPath (  -- n )", "EXTERN: \"C\" int XFreeFontPath( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XFreeGC XFreeGC a a -- n", "FUNCTION: XFreeGC (   -- n )", "EXTERN: \"C\" int XFreeGC( void * , void *  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XFreeModifiermap XFreeModifiermap a -- n", "FUNCTION: XFreeModifiermap (  -- n )", "EXTERN: \"C\" int XFreeModifiermap( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XFreePixmap XFreePixmap a u -- n", "FUNCTION: XFreePixmap (   -- n )", "EXTERN: \"C\" int XFreePixmap( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XGeometry XGeometry a n s s u u u n n a a a a -- n", "FUNCTION: XGeometry (              -- n )", "EXTERN: \"C\" int XGeometry( void * , int , char * , char * , int , int , int , int , int , void * , void * , void * , void *  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XGetErrorDatabaseText XGetErrorDatabaseText a s s s a n -- n", "FUNCTION: XGetErrorDatabaseText (       -- n )", "EXTERN: \"C\" int XGetErrorDatabaseText( void * , char * , char * , char * , void * , int  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XGetErrorText XGetErrorText a n a n -- n", "FUNCTION: XGetErrorText (     -- n )", "EXTERN: \"C\" int XGetErrorText( void * , int , void * , int  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XGetFontProperty XGetFontProperty a u a -- n", "FUNCTION: XGetFontProperty (    -- n )", "EXTERN: \"C\" int XGetFontProperty( void * , long , void *  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XGetGCValues XGetGCValues a a u a -- n", "FUNCTION: XGetGCValues (     -- n )", "EXTERN: \"C\" int XGetGCValues( void * , void * , long , void *  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XGetGeometry XGetGeometry a u a a a a a a a -- n", "FUNCTION: XGetGeometry (          -- n )", "EXTERN: \"C\" int XGetGeometry( void * , int , void * , void * , void * , void * , void * , void * , void *  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XGetIconName XGetIconName a u a -- n", "FUNCTION: XGetIconName (    -- n )", "EXTERN: \"C\" int XGetIconName( void * , int , void *  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XGetInputFocus XGetInputFocus a a a -- n", "FUNCTION: XGetInputFocus (    -- n )", "EXTERN: \"C\" int XGetInputFocus( void * , void * , void *  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XGetKeyboardControl XGetKeyboardControl a a -- n", "FUNCTION: XGetKeyboardControl (   -- n )", "EXTERN: \"C\" int XGetKeyboardControl( void * , void *  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XGetPointerControl XGetPointerControl a a a a -- n", "FUNCTION: XGetPointerControl (     -- n )", "EXTERN: \"C\" int XGetPointerControl( void * , void * , void * , void *  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XGetPointerMapping XGetPointerMapping a a n -- n", "FUNCTION: XGetPointerMapping (    -- n )", "EXTERN: \"C\" int XGetPointerMapping( void * , void * , int  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XGetScreenSaver XGetScreenSaver a a a a a -- n", "FUNCTION: XGetScreenSaver (      -- n )", "EXTERN: \"C\" int XGetScreenSaver( void * , void * , void * , void * , void *  );", "	( <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XGetTransientForHint XGetTransientForHint a u a -- n", "FUNCTION: XGetTransientForHint (    -- n )", "EXTERN: \"C\" int XGetTransientForHint( void * , int , void *  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XGetWindowProperty XGetWindowProperty a u u n n n u a a a a a -- n", "FUNCTION: XGetWindowProperty (             -- n )", "EXTERN: \"C\" int XGetWindowProperty( void * , int , long , long , long , int , long , void * , void * , void * , void * , void *  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XGetWindowAttributes XGetWindowAttributes a u a -- n", "FUNCTION: XGetWindowAttributes (    -- n )", "EXTERN: \"C\" int XGetWindowAttributes( void * , int , void *  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XGrabButton XGrabButton a u u u n u n n u u -- n", "FUNCTION: XGrabButton (           -- n )", "EXTERN: \"C\" int XGrabButton( void * , int , int , int , int , int , int , int , int , int  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XGrabKey XGrabKey a n u u n n n -- n", "FUNCTION: XGrabKey (        -- n )", "EXTERN: \"C\" int XGrabKey( void * , int , int , int , int , int , int  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XGrabKeyboard XGrabKeyboard a u n n n u -- n", "FUNCTION: XGrabKeyboard (       -- n )", "EXTERN: \"C\" int XGrabKeyboard( void * , int , int , int , int , long  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XGrabPointer XGrabPointer a u n u n n u u u -- n", "FUNCTION: XGrabPointer (          -- n )", "EXTERN: \"C\" int XGrabPointer( void * , int , int , int , int , int , int , int , long  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XGrabServer XGrabServer a -- n", "FUNCTION: XGrabServer (  -- n )", "EXTERN: \"C\" int XGrabServer( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XHeightMMOfScreen XHeightMMOfScreen a -- n", "FUNCTION: XHeightMMOfScreen (  -- n )", "EXTERN: \"C\" int XHeightMMOfScreen( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XHeightOfScreen XHeightOfScreen a -- n", "FUNCTION: XHeightOfScreen (  -- n )", "EXTERN: \"C\" int XHeightOfScreen( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XIfEvent XIfEvent a a a a -- n", "FUNCTION: XIfEvent (     -- n )", "EXTERN: \"C\" int XIfEvent( void * , void * , void * , void *  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XImageByteOrder XImageByteOrder a -- n", "FUNCTION: XImageByteOrder (  -- n )", "EXTERN: \"C\" int XImageByteOrder( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XInstallColormap XInstallColormap a u -- n", "FUNCTION: XInstallColormap (   -- n )", "EXTERN: \"C\" int XInstallColormap( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XKeysymToKeycode XKeysymToKeycode a u -- u", "FUNCTION: XKeysymToKeycode (   -- u )", "EXTERN: \"C\" char XKeysymToKeycode( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XKillClient XKillClient a u -- n", "FUNCTION: XKillClient (   -- n )", "EXTERN: \"C\" int XKillClient( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XLookupColor XLookupColor a u s a a -- n", "FUNCTION: XLookupColor (      -- n )", "EXTERN: \"C\" int XLookupColor( void * , int , char * , void * , void *  );", "	( <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XLowerWindow XLowerWindow a u -- n", "FUNCTION: XLowerWindow (   -- n )", "EXTERN: \"C\" int XLowerWindow( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XMapRaised XMapRaised a u -- n", "FUNCTION: XMapRaised (   -- n )", "EXTERN: \"C\" int XMapRaised( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XMapSubwindows XMapSubwindows a u -- n", "FUNCTION: XMapSubwindows (   -- n )", "EXTERN: \"C\" int XMapSubwindows( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XMapWindow XMapWindow a u -- n", "FUNCTION: XMapWindow (   -- n )", "EXTERN: \"C\" int XMapWindow( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XMaskEvent XMaskEvent a n a -- n", "FUNCTION: XMaskEvent (    -- n )", "EXTERN: \"C\" int XMaskEvent( void * , long , void *  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XMaxCmapsOfScreen XMaxCmapsOfScreen a -- n", "FUNCTION: XMaxCmapsOfScreen (  -- n )", "EXTERN: \"C\" int XMaxCmapsOfScreen( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XMinCmapsOfScreen XMinCmapsOfScreen a -- n", "FUNCTION: XMinCmapsOfScreen (  -- n )", "EXTERN: \"C\" int XMinCmapsOfScreen( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XMoveResizeWindow XMoveResizeWindow a u n n u u -- n", "FUNCTION: XMoveResizeWindow (       -- n )", "EXTERN: \"C\" int XMoveResizeWindow( void * , int , int , int , int , int  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XMoveWindow XMoveWindow a u n n -- n", "FUNCTION: XMoveWindow (     -- n )", "EXTERN: \"C\" int XMoveWindow( void * , int , int , int  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XNextEvent XNextEvent a a -- n", "FUNCTION: XNextEvent (   -- n )", "EXTERN: \"C\" int XNextEvent( void * , void *  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XNoOp XNoOp a -- n", "FUNCTION: XNoOp (  -- n )", "EXTERN: \"C\" int XNoOp( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XParseColor XParseColor a u s a -- n", "FUNCTION: XParseColor (     -- n )", "EXTERN: \"C\" int XParseColor( void * , int , char * , void *  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XParseGeometry XParseGeometry s a a a a -- n", "FUNCTION: XParseGeometry (      -- n )", "EXTERN: \"C\" int XParseGeometry( char * , void * , void * , void * , void *  );", "	( <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XPeekEvent XPeekEvent a a -- n", "FUNCTION: XPeekEvent (   -- n )", "EXTERN: \"C\" int XPeekEvent( void * , void *  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XPeekIfEvent XPeekIfEvent a a a a -- n", "FUNCTION: XPeekIfEvent (     -- n )", "EXTERN: \"C\" int XPeekIfEvent( void * , void * , void * , void *  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XPending XPending a -- n", "FUNCTION: XPending (  -- n )", "EXTERN: \"C\" int XPending( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XPlanesOfScreen XPlanesOfScreen a -- n", "FUNCTION: XPlanesOfScreen (  -- n )", "EXTERN: \"C\" int XPlanesOfScreen( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XProtocolRevision XProtocolRevision a -- n", "FUNCTION: XProtocolRevision (  -- n )", "EXTERN: \"C\" int XProtocolRevision( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XProtocolVersion XProtocolVersion a -- n", "FUNCTION: XProtocolVersion (  -- n )", "EXTERN: \"C\" int XProtocolVersion( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XPutBackEvent XPutBackEvent a a -- n", "FUNCTION: XPutBackEvent (   -- n )", "EXTERN: \"C\" int XPutBackEvent( void * , void *  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XPutImage XPutImage a u a a n n n n u u -- n", "FUNCTION: XPutImage (           -- n )", "EXTERN: \"C\" int XPutImage( void * , int , void * , void * , int , int , int , int , int , int  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XQLength XQLength a -- n", "FUNCTION: XQLength (  -- n )", "EXTERN: \"C\" int XQLength( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XQueryBestCursor XQueryBestCursor a u u u a a -- n", "FUNCTION: XQueryBestCursor (       -- n )", "EXTERN: \"C\" int XQueryBestCursor( void * , int , int , int , void * , void *  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XQueryBestSize XQueryBestSize a n u u u a a -- n", "FUNCTION: XQueryBestSize (        -- n )", "EXTERN: \"C\" int XQueryBestSize( void * , int , int , int , int , void * , void *  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XQueryBestStipple XQueryBestStipple a u u u a a -- n", "FUNCTION: XQueryBestStipple (       -- n )", "EXTERN: \"C\" int XQueryBestStipple( void * , int , int , int , void * , void *  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XQueryBestTile XQueryBestTile a u u u a a -- n", "FUNCTION: XQueryBestTile (       -- n )", "EXTERN: \"C\" int XQueryBestTile( void * , int , int , int , void * , void *  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XQueryColor XQueryColor a u a -- n", "FUNCTION: XQueryColor (    -- n )", "EXTERN: \"C\" int XQueryColor( void * , int , void *  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XQueryColors XQueryColors a u a n -- n", "FUNCTION: XQueryColors (     -- n )", "EXTERN: \"C\" int XQueryColors( void * , int , void * , int  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XQueryExtension XQueryExtension a s a a a -- n", "FUNCTION: XQueryExtension (      -- n )", "EXTERN: \"C\" int XQueryExtension( void * , char * , void * , void * , void *  );", "	( <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XQueryKeymap XQueryKeymap a a -- n", "FUNCTION: XQueryKeymap (   -- n )", "EXTERN: \"C\" int XQueryKeymap( void * , void *  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XQueryPointer XQueryPointer a u a a a a a a a -- n", "FUNCTION: XQueryPointer (          -- n )", "EXTERN: \"C\" int XQueryPointer( void * , int , void * , void * , void * , void * , void * , void * , void *  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XQueryTextExtents XQueryTextExtents a u s n a a a a -- n", "FUNCTION: XQueryTextExtents (         -- n )", "EXTERN: \"C\" int XQueryTextExtents( void * , int , char * , int , void * , void * , void * , void *  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XQueryTextExtents16 XQueryTextExtents16 a u a n a a a a -- n", "FUNCTION: XQueryTextExtents16 (         -- n )", "EXTERN: \"C\" int XQueryTextExtents16( void * , int , void * , int , void * , void * , void * , void *  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XQueryTree XQueryTree a u a a a a -- n", "FUNCTION: XQueryTree (       -- n )", "EXTERN: \"C\" int XQueryTree( void * , int , void * , void * , void * , void *  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XRaiseWindow XRaiseWindow a u -- n", "FUNCTION: XRaiseWindow (   -- n )", "EXTERN: \"C\" int XRaiseWindow( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XReadBitmapFile XReadBitmapFile a u s a a a a a -- n", "FUNCTION: XReadBitmapFile (         -- n )", "EXTERN: \"C\" int XReadBitmapFile( void * , int , char * , void * , void * , void * , void * , void *  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XReadBitmapFileData XReadBitmapFileData s a a a a a -- n", "FUNCTION: XReadBitmapFileData (       -- n )", "EXTERN: \"C\" int XReadBitmapFileData( char * , void * , void * , void * , void * , void *  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XRebindKeysym XRebindKeysym a u a n a n -- n", "FUNCTION: XRebindKeysym (       -- n )", "EXTERN: \"C\" int XRebindKeysym( void * , int , void * , int , void * , int  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XRecolorCursor XRecolorCursor a u a a -- n", "FUNCTION: XRecolorCursor (     -- n )", "EXTERN: \"C\" int XRecolorCursor( void * , int , void * , void *  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XRefreshKeyboardMapping XRefreshKeyboardMapping a -- n", "FUNCTION: XRefreshKeyboardMapping (  -- n )", "EXTERN: \"C\" int XRefreshKeyboardMapping( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XRemoveFromSaveSet XRemoveFromSaveSet a u -- n", "FUNCTION: XRemoveFromSaveSet (   -- n )", "EXTERN: \"C\" int XRemoveFromSaveSet( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XRemoveHost XRemoveHost a a -- n", "FUNCTION: XRemoveHost (   -- n )", "EXTERN: \"C\" int XRemoveHost( void * , void *  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XRemoveHosts XRemoveHosts a a n -- n", "FUNCTION: XRemoveHosts (    -- n )", "EXTERN: \"C\" int XRemoveHosts( void * , void * , int  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XReparentWindow XReparentWindow a u u n n -- n", "FUNCTION: XReparentWindow (      -- n )", "EXTERN: \"C\" int XReparentWindow( void * , int , int , int , int  );", "	( <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XResetScreenSaver XResetScreenSaver a -- n", "FUNCTION: XResetScreenSaver (  -- n )", "EXTERN: \"C\" int XResetScreenSaver( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XResizeWindow XResizeWindow a u u u -- n", "FUNCTION: XResizeWindow (     -- n )", "EXTERN: \"C\" int XResizeWindow( void * , int , int , int  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XRestackWindows XRestackWindows a a n -- n", "FUNCTION: XRestackWindows (    -- n )", "EXTERN: \"C\" int XRestackWindows( void * , void * , int  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XRotateBuffers XRotateBuffers a n -- n", "FUNCTION: XRotateBuffers (   -- n )", "EXTERN: \"C\" int XRotateBuffers( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XRotateWindowProperties XRotateWindowProperties a u a n n -- n", "FUNCTION: XRotateWindowProperties (      -- n )", "EXTERN: \"C\" int XRotateWindowProperties( void * , int , void * , int , int  );", "	( <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XScreenCount XScreenCount a -- n", "FUNCTION: XScreenCount (  -- n )", "EXTERN: \"C\" int XScreenCount( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XSelectInput XSelectInput a u n -- n", "FUNCTION: XSelectInput (    -- n )", "EXTERN: \"C\" int XSelectInput( void * , int , long  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSendEvent XSendEvent a u n n a -- n", "FUNCTION: XSendEvent (      -- n )", "EXTERN: \"C\" int XSendEvent( void * , int , int , long , void *  );", "	( <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSetAccessControl XSetAccessControl a n -- n", "FUNCTION: XSetAccessControl (   -- n )", "EXTERN: \"C\" int XSetAccessControl( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XSetArcMode XSetArcMode a a n -- n", "FUNCTION: XSetArcMode (    -- n )", "EXTERN: \"C\" int XSetArcMode( void * , void * , int  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSetBackground XSetBackground a a u -- n", "FUNCTION: XSetBackground (    -- n )", "EXTERN: \"C\" int XSetBackground( void * , void * , long  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSetClipMask XSetClipMask a a u -- n", "FUNCTION: XSetClipMask (    -- n )", "EXTERN: \"C\" int XSetClipMask( void * , void * , int  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSetClipOrigin XSetClipOrigin a a n n -- n", "FUNCTION: XSetClipOrigin (     -- n )", "EXTERN: \"C\" int XSetClipOrigin( void * , void * , int , int  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSetClipRectangles XSetClipRectangles a a n n a n n -- n", "FUNCTION: XSetClipRectangles (        -- n )", "EXTERN: \"C\" int XSetClipRectangles( void * , void * , int , int , void * , int , int  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSetCloseDownMode XSetCloseDownMode a n -- n", "FUNCTION: XSetCloseDownMode (   -- n )", "EXTERN: \"C\" int XSetCloseDownMode( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XSetCommand XSetCommand a u a n -- n", "FUNCTION: XSetCommand (     -- n )", "EXTERN: \"C\" int XSetCommand( void * , int , void * , int  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSetDashes XSetDashes a a n s n -- n", "FUNCTION: XSetDashes (      -- n )", "EXTERN: \"C\" int XSetDashes( void * , void * , int , char * , int  );", "	( <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSetFillRule XSetFillRule a a n -- n", "FUNCTION: XSetFillRule (    -- n )", "EXTERN: \"C\" int XSetFillRule( void * , void * , int  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSetFillStyle XSetFillStyle a a n -- n", "FUNCTION: XSetFillStyle (    -- n )", "EXTERN: \"C\" int XSetFillStyle( void * , void * , int  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSetFont XSetFont a a u -- n", "FUNCTION: XSetFont (    -- n )", "EXTERN: \"C\" int XSetFont( void * , void * , int  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSetFontPath XSetFontPath a a n -- n", "FUNCTION: XSetFontPath (    -- n )", "EXTERN: \"C\" int XSetFontPath( void * , void * , int  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSetForeground XSetForeground a a u -- n", "FUNCTION: XSetForeground (    -- n )", "EXTERN: \"C\" int XSetForeground( void * , void * , long  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSetFunction XSetFunction a a n -- n", "FUNCTION: XSetFunction (    -- n )", "EXTERN: \"C\" int XSetFunction( void * , void * , int  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSetGraphicsExposures XSetGraphicsExposures a a n -- n", "FUNCTION: XSetGraphicsExposures (    -- n )", "EXTERN: \"C\" int XSetGraphicsExposures( void * , void * , int  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSetIconName XSetIconName a u s -- n", "FUNCTION: XSetIconName (    -- n )", "EXTERN: \"C\" int XSetIconName( void * , int , char *  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSetInputFocus XSetInputFocus a u n u -- n", "FUNCTION: XSetInputFocus (     -- n )", "EXTERN: \"C\" int XSetInputFocus( void * , int , int , long  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSetLineAttributes XSetLineAttributes a a u n n n -- n", "FUNCTION: XSetLineAttributes (       -- n )", "EXTERN: \"C\" int XSetLineAttributes( void * , void * , int , int , int , int  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSetModifierMapping XSetModifierMapping a a -- n", "FUNCTION: XSetModifierMapping (   -- n )", "EXTERN: \"C\" int XSetModifierMapping( void * , void *  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XSetPlaneMask XSetPlaneMask a a u -- n", "FUNCTION: XSetPlaneMask (    -- n )", "EXTERN: \"C\" int XSetPlaneMask( void * , void * , long  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSetPointerMapping XSetPointerMapping a a n -- n", "FUNCTION: XSetPointerMapping (    -- n )", "EXTERN: \"C\" int XSetPointerMapping( void * , void * , int  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSetScreenSaver XSetScreenSaver a n n n n -- n", "FUNCTION: XSetScreenSaver (      -- n )", "EXTERN: \"C\" int XSetScreenSaver( void * , int , int , int , int  );", "	( <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSetSelectionOwner XSetSelectionOwner a u u u -- n", "FUNCTION: XSetSelectionOwner (     -- n )", "EXTERN: \"C\" int XSetSelectionOwner( void * , long , int , long  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSetState XSetState a a u u n u -- n", "FUNCTION: XSetState (       -- n )", "EXTERN: \"C\" int XSetState( void * , void * , long , long , int , long  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSetStipple XSetStipple a a u -- n", "FUNCTION: XSetStipple (    -- n )", "EXTERN: \"C\" int XSetStipple( void * , void * , int  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSetSubwindowMode XSetSubwindowMode a a n -- n", "FUNCTION: XSetSubwindowMode (    -- n )", "EXTERN: \"C\" int XSetSubwindowMode( void * , void * , int  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSetTSOrigin XSetTSOrigin a a n n -- n", "FUNCTION: XSetTSOrigin (     -- n )", "EXTERN: \"C\" int XSetTSOrigin( void * , void * , int , int  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSetTile XSetTile a a u -- n", "FUNCTION: XSetTile (    -- n )", "EXTERN: \"C\" int XSetTile( void * , void * , int  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSetWindowBackground XSetWindowBackground a u u -- n", "FUNCTION: XSetWindowBackground (    -- n )", "EXTERN: \"C\" int XSetWindowBackground( void * , int , long  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSetWindowBackgroundPixmap XSetWindowBackgroundPixmap a u u -- n", "FUNCTION: XSetWindowBackgroundPixmap (    -- n )", "EXTERN: \"C\" int XSetWindowBackgroundPixmap( void * , int , int  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSetWindowBorder XSetWindowBorder a u u -- n", "FUNCTION: XSetWindowBorder (    -- n )", "EXTERN: \"C\" int XSetWindowBorder( void * , int , long  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSetWindowBorderPixmap XSetWindowBorderPixmap a u u -- n", "FUNCTION: XSetWindowBorderPixmap (    -- n )", "EXTERN: \"C\" int XSetWindowBorderPixmap( void * , int , int  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSetWindowBorderWidth XSetWindowBorderWidth a u u -- n", "FUNCTION: XSetWindowBorderWidth (    -- n )", "EXTERN: \"C\" int XSetWindowBorderWidth( void * , int , int  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSetWindowColormap XSetWindowColormap a u u -- n", "FUNCTION: XSetWindowColormap (    -- n )", "EXTERN: \"C\" int XSetWindowColormap( void * , int , int  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XStoreBuffer XStoreBuffer a s n n -- n", "FUNCTION: XStoreBuffer (     -- n )", "EXTERN: \"C\" int XStoreBuffer( void * , char * , int , int  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XStoreBytes XStoreBytes a s n -- n", "FUNCTION: XStoreBytes (    -- n )", "EXTERN: \"C\" int XStoreBytes( void * , char * , int  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XStoreColor XStoreColor a u a -- n", "FUNCTION: XStoreColor (    -- n )", "EXTERN: \"C\" int XStoreColor( void * , int , void *  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XStoreColors XStoreColors a u a n -- n", "FUNCTION: XStoreColors (     -- n )", "EXTERN: \"C\" int XStoreColors( void * , int , void * , int  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XStoreName XStoreName a u s -- n", "FUNCTION: XStoreName (    -- n )", "EXTERN: \"C\" int XStoreName( void * , int , char *  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XStoreNamedColor XStoreNamedColor a u s u n -- n", "FUNCTION: XStoreNamedColor (      -- n )", "EXTERN: \"C\" int XStoreNamedColor( void * , int , char * , long , int  );", "	( <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSync XSync a n -- n", "FUNCTION: XSync (   -- n )", "EXTERN: \"C\" int XSync( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XTextExtents XTextExtents a s n a a a a -- n", "FUNCTION: XTextExtents (        -- n )", "EXTERN: \"C\" int XTextExtents( void * , char * , int , void * , void * , void * , void *  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XTextExtents16 XTextExtents16 a a n a a a a -- n", "FUNCTION: XTextExtents16 (        -- n )", "EXTERN: \"C\" int XTextExtents16( void * , void * , int , void * , void * , void * , void *  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XTextWidth XTextWidth a s n -- n", "FUNCTION: XTextWidth (    -- n )", "EXTERN: \"C\" int XTextWidth( void * , char * , int  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XTextWidth16 XTextWidth16 a a n -- n", "FUNCTION: XTextWidth16 (    -- n )", "EXTERN: \"C\" int XTextWidth16( void * , void * , int  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XTranslateCoordinates XTranslateCoordinates a u u n n a a a -- n", "FUNCTION: XTranslateCoordinates (         -- n )", "EXTERN: \"C\" int XTranslateCoordinates( void * , int , int , int , int , void * , void * , void *  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XUndefineCursor XUndefineCursor a u -- n", "FUNCTION: XUndefineCursor (   -- n )", "EXTERN: \"C\" int XUndefineCursor( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XUngrabButton XUngrabButton a u u u -- n", "FUNCTION: XUngrabButton (     -- n )", "EXTERN: \"C\" int XUngrabButton( void * , int , int , int  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XUngrabKey XUngrabKey a n u u -- n", "FUNCTION: XUngrabKey (     -- n )", "EXTERN: \"C\" int XUngrabKey( void * , int , int , int  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XUngrabKeyboard XUngrabKeyboard a u -- n", "FUNCTION: XUngrabKeyboard (   -- n )", "EXTERN: \"C\" int XUngrabKeyboard( void * , long  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XUngrabPointer XUngrabPointer a u -- n", "FUNCTION: XUngrabPointer (   -- n )", "EXTERN: \"C\" int XUngrabPointer( void * , long  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XUngrabServer XUngrabServer a -- n", "FUNCTION: XUngrabServer (  -- n )", "EXTERN: \"C\" int XUngrabServer( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XUninstallColormap XUninstallColormap a u -- n", "FUNCTION: XUninstallColormap (   -- n )", "EXTERN: \"C\" int XUninstallColormap( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XUnloadFont XUnloadFont a u -- n", "FUNCTION: XUnloadFont (   -- n )", "EXTERN: \"C\" int XUnloadFont( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XUnmapSubwindows XUnmapSubwindows a u -- n", "FUNCTION: XUnmapSubwindows (   -- n )", "EXTERN: \"C\" int XUnmapSubwindows( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XUnmapWindow XUnmapWindow a u -- n", "FUNCTION: XUnmapWindow (   -- n )", "EXTERN: \"C\" int XUnmapWindow( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XVendorRelease XVendorRelease a -- n", "FUNCTION: XVendorRelease (  -- n )", "EXTERN: \"C\" int XVendorRelease( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XWarpPointer XWarpPointer a u u n n u u n n -- n", "FUNCTION: XWarpPointer (          -- n )", "EXTERN: \"C\" int XWarpPointer( void * , int , int , int , int , int , int , int , int  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XWidthMMOfScreen XWidthMMOfScreen a -- n", "FUNCTION: XWidthMMOfScreen (  -- n )", "EXTERN: \"C\" int XWidthMMOfScreen( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XWidthOfScreen XWidthOfScreen a -- n", "FUNCTION: XWidthOfScreen (  -- n )", "EXTERN: \"C\" int XWidthOfScreen( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XWindowEvent XWindowEvent a u n a -- n", "FUNCTION: XWindowEvent (     -- n )", "EXTERN: \"C\" int XWindowEvent( void * , int , long , void *  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XWriteBitmapFile XWriteBitmapFile a s u u u n n -- n", "FUNCTION: XWriteBitmapFile (        -- n )", "EXTERN: \"C\" int XWriteBitmapFile( void * , char * , int , int , int , int , int  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSupportsLocale XSupportsLocale  -- n", "FUNCTION: XSupportsLocale (  -- n )", "EXTERN: \"C\" int XSupportsLocale(  );", "	( -- )" );
	swigFunction( "c-function XSetLocaleModifiers XSetLocaleModifiers s -- a", "FUNCTION: XSetLocaleModifiers (  -- a )", "EXTERN: \"C\" void * XSetLocaleModifiers( char *  );", "	( <noname> -- )" );
	swigFunction( "c-function XOpenOM XOpenOM a a s s -- a", "FUNCTION: XOpenOM (     -- a )", "EXTERN: \"C\" void * XOpenOM( void * , void * , char * , char *  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XCloseOM XCloseOM a -- n", "FUNCTION: XCloseOM (  -- n )", "EXTERN: \"C\" int XCloseOM( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XSetOMValues XSetOMValues a ... -- a", "FUNCTION: XSetOMValues (   -- a )", "EXTERN: \"C\" void * XSetOMValues( void * , ...  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XGetOMValues XGetOMValues a ... -- a", "FUNCTION: XGetOMValues (   -- a )", "EXTERN: \"C\" void * XGetOMValues( void * , ...  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XDisplayOfOM XDisplayOfOM a -- a", "FUNCTION: XDisplayOfOM (  -- a )", "EXTERN: \"C\" void * XDisplayOfOM( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XLocaleOfOM XLocaleOfOM a -- a", "FUNCTION: XLocaleOfOM (  -- a )", "EXTERN: \"C\" void * XLocaleOfOM( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XCreateOC XCreateOC a ... -- a", "FUNCTION: XCreateOC (   -- a )", "EXTERN: \"C\" void * XCreateOC( void * , ...  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XDestroyOC XDestroyOC a -- void", "FUNCTION: XDestroyOC (  -- void )", "EXTERN: \"C\" void XDestroyOC( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XOMOfOC XOMOfOC a -- a", "FUNCTION: XOMOfOC (  -- a )", "EXTERN: \"C\" void * XOMOfOC( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XSetOCValues XSetOCValues a ... -- a", "FUNCTION: XSetOCValues (   -- a )", "EXTERN: \"C\" void * XSetOCValues( void * , ...  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XGetOCValues XGetOCValues a ... -- a", "FUNCTION: XGetOCValues (   -- a )", "EXTERN: \"C\" void * XGetOCValues( void * , ...  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XCreateFontSet XCreateFontSet a s a a a -- a", "FUNCTION: XCreateFontSet (      -- a )", "EXTERN: \"C\" void * XCreateFontSet( void * , char * , void * , void * , void *  );", "	( <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XFreeFontSet XFreeFontSet a a -- void", "FUNCTION: XFreeFontSet (   -- void )", "EXTERN: \"C\" void XFreeFontSet( void * , void *  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XFontsOfFontSet XFontsOfFontSet a a a -- n", "FUNCTION: XFontsOfFontSet (    -- n )", "EXTERN: \"C\" int XFontsOfFontSet( void * , void * , void *  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XBaseFontNameListOfFontSet XBaseFontNameListOfFontSet a -- a", "FUNCTION: XBaseFontNameListOfFontSet (  -- a )", "EXTERN: \"C\" void * XBaseFontNameListOfFontSet( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XLocaleOfFontSet XLocaleOfFontSet a -- a", "FUNCTION: XLocaleOfFontSet (  -- a )", "EXTERN: \"C\" void * XLocaleOfFontSet( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XContextDependentDrawing XContextDependentDrawing a -- n", "FUNCTION: XContextDependentDrawing (  -- n )", "EXTERN: \"C\" int XContextDependentDrawing( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XDirectionalDependentDrawing XDirectionalDependentDrawing a -- n", "FUNCTION: XDirectionalDependentDrawing (  -- n )", "EXTERN: \"C\" int XDirectionalDependentDrawing( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XContextualDrawing XContextualDrawing a -- n", "FUNCTION: XContextualDrawing (  -- n )", "EXTERN: \"C\" int XContextualDrawing( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XExtentsOfFontSet XExtentsOfFontSet a -- a", "FUNCTION: XExtentsOfFontSet (  -- a )", "EXTERN: \"C\" void * XExtentsOfFontSet( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XmbTextEscapement XmbTextEscapement a s n -- n", "FUNCTION: XmbTextEscapement (    -- n )", "EXTERN: \"C\" int XmbTextEscapement( void * , char * , int  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XwcTextEscapement XwcTextEscapement a ws n -- n", "FUNCTION: XwcTextEscapement (    -- n )", "EXTERN: \"C\" int XwcTextEscapement( void * , char * , int  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function Xutf8TextEscapement Xutf8TextEscapement a s n -- n", "FUNCTION: Xutf8TextEscapement (    -- n )", "EXTERN: \"C\" int Xutf8TextEscapement( void * , char * , int  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XmbTextExtents XmbTextExtents a s n a a -- n", "FUNCTION: XmbTextExtents (      -- n )", "EXTERN: \"C\" int XmbTextExtents( void * , char * , int , void * , void *  );", "	( <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XwcTextExtents XwcTextExtents a ws n a a -- n", "FUNCTION: XwcTextExtents (      -- n )", "EXTERN: \"C\" int XwcTextExtents( void * , char * , int , void * , void *  );", "	( <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function Xutf8TextExtents Xutf8TextExtents a s n a a -- n", "FUNCTION: Xutf8TextExtents (      -- n )", "EXTERN: \"C\" int Xutf8TextExtents( void * , char * , int , void * , void *  );", "	( <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XmbTextPerCharExtents XmbTextPerCharExtents a s n a a n a a a -- n", "FUNCTION: XmbTextPerCharExtents (          -- n )", "EXTERN: \"C\" int XmbTextPerCharExtents( void * , char * , int , void * , void * , int , void * , void * , void *  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XwcTextPerCharExtents XwcTextPerCharExtents a ws n a a n a a a -- n", "FUNCTION: XwcTextPerCharExtents (          -- n )", "EXTERN: \"C\" int XwcTextPerCharExtents( void * , char * , int , void * , void * , int , void * , void * , void *  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function Xutf8TextPerCharExtents Xutf8TextPerCharExtents a s n a a n a a a -- n", "FUNCTION: Xutf8TextPerCharExtents (          -- n )", "EXTERN: \"C\" int Xutf8TextPerCharExtents( void * , char * , int , void * , void * , int , void * , void * , void *  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XmbDrawText XmbDrawText a u a n n a n -- void", "FUNCTION: XmbDrawText (        -- void )", "EXTERN: \"C\" void XmbDrawText( void * , int , void * , int , int , void * , int  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XwcDrawText XwcDrawText a u a n n a n -- void", "FUNCTION: XwcDrawText (        -- void )", "EXTERN: \"C\" void XwcDrawText( void * , int , void * , int , int , void * , int  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function Xutf8DrawText Xutf8DrawText a u a n n a n -- void", "FUNCTION: Xutf8DrawText (        -- void )", "EXTERN: \"C\" void Xutf8DrawText( void * , int , void * , int , int , void * , int  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XmbDrawString XmbDrawString a u a a n n s n -- void", "FUNCTION: XmbDrawString (         -- void )", "EXTERN: \"C\" void XmbDrawString( void * , int , void * , void * , int , int , char * , int  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XwcDrawString XwcDrawString a u a a n n ws n -- void", "FUNCTION: XwcDrawString (         -- void )", "EXTERN: \"C\" void XwcDrawString( void * , int , void * , void * , int , int , char * , int  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function Xutf8DrawString Xutf8DrawString a u a a n n s n -- void", "FUNCTION: Xutf8DrawString (         -- void )", "EXTERN: \"C\" void Xutf8DrawString( void * , int , void * , void * , int , int , char * , int  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XmbDrawImageString XmbDrawImageString a u a a n n s n -- void", "FUNCTION: XmbDrawImageString (         -- void )", "EXTERN: \"C\" void XmbDrawImageString( void * , int , void * , void * , int , int , char * , int  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XwcDrawImageString XwcDrawImageString a u a a n n ws n -- void", "FUNCTION: XwcDrawImageString (         -- void )", "EXTERN: \"C\" void XwcDrawImageString( void * , int , void * , void * , int , int , char * , int  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function Xutf8DrawImageString Xutf8DrawImageString a u a a n n s n -- void", "FUNCTION: Xutf8DrawImageString (         -- void )", "EXTERN: \"C\" void Xutf8DrawImageString( void * , int , void * , void * , int , int , char * , int  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XOpenIM XOpenIM a a a a -- a", "FUNCTION: XOpenIM (     -- a )", "EXTERN: \"C\" void * XOpenIM( void * , void * , void * , void *  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XCloseIM XCloseIM a -- n", "FUNCTION: XCloseIM (  -- n )", "EXTERN: \"C\" int XCloseIM( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XGetIMValues XGetIMValues a ... -- a", "FUNCTION: XGetIMValues (   -- a )", "EXTERN: \"C\" void * XGetIMValues( void * , ...  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XSetIMValues XSetIMValues a ... -- a", "FUNCTION: XSetIMValues (   -- a )", "EXTERN: \"C\" void * XSetIMValues( void * , ...  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XDisplayOfIM XDisplayOfIM a -- a", "FUNCTION: XDisplayOfIM (  -- a )", "EXTERN: \"C\" void * XDisplayOfIM( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XLocaleOfIM XLocaleOfIM a -- a", "FUNCTION: XLocaleOfIM (  -- a )", "EXTERN: \"C\" void * XLocaleOfIM( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XCreateIC XCreateIC a ... -- a", "FUNCTION: XCreateIC (   -- a )", "EXTERN: \"C\" void * XCreateIC( void * , ...  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XDestroyIC XDestroyIC a -- void", "FUNCTION: XDestroyIC (  -- void )", "EXTERN: \"C\" void XDestroyIC( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XSetICFocus XSetICFocus a -- void", "FUNCTION: XSetICFocus (  -- void )", "EXTERN: \"C\" void XSetICFocus( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XUnsetICFocus XUnsetICFocus a -- void", "FUNCTION: XUnsetICFocus (  -- void )", "EXTERN: \"C\" void XUnsetICFocus( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XwcResetIC XwcResetIC a -- a", "FUNCTION: XwcResetIC (  -- a )", "EXTERN: \"C\" void * XwcResetIC( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XmbResetIC XmbResetIC a -- a", "FUNCTION: XmbResetIC (  -- a )", "EXTERN: \"C\" void * XmbResetIC( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function Xutf8ResetIC Xutf8ResetIC a -- a", "FUNCTION: Xutf8ResetIC (  -- a )", "EXTERN: \"C\" void * Xutf8ResetIC( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XSetICValues XSetICValues a ... -- a", "FUNCTION: XSetICValues (   -- a )", "EXTERN: \"C\" void * XSetICValues( void * , ...  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XGetICValues XGetICValues a ... -- a", "FUNCTION: XGetICValues (   -- a )", "EXTERN: \"C\" void * XGetICValues( void * , ...  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XIMOfIC XIMOfIC a -- a", "FUNCTION: XIMOfIC (  -- a )", "EXTERN: \"C\" void * XIMOfIC( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XFilterEvent XFilterEvent a u -- n", "FUNCTION: XFilterEvent (   -- n )", "EXTERN: \"C\" int XFilterEvent( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XmbLookupString XmbLookupString a a a n a a -- n", "FUNCTION: XmbLookupString (       -- n )", "EXTERN: \"C\" int XmbLookupString( void * , void * , void * , int , void * , void *  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XwcLookupString XwcLookupString a a a n a a -- n", "FUNCTION: XwcLookupString (       -- n )", "EXTERN: \"C\" int XwcLookupString( void * , void * , void * , int , void * , void *  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function Xutf8LookupString Xutf8LookupString a a a n a a -- n", "FUNCTION: Xutf8LookupString (       -- n )", "EXTERN: \"C\" int Xutf8LookupString( void * , void * , void * , int , void * , void *  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XVaCreateNestedList XVaCreateNestedList n ... -- a", "FUNCTION: XVaCreateNestedList (   -- a )", "EXTERN: \"C\" void * XVaCreateNestedList( int , ...  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XRegisterIMInstantiateCallback XRegisterIMInstantiateCallback a a a a a a -- n", "FUNCTION: XRegisterIMInstantiateCallback (       -- n )", "EXTERN: \"C\" int XRegisterIMInstantiateCallback( void * , void * , void * , void * , void * , void *  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XUnregisterIMInstantiateCallback XUnregisterIMInstantiateCallback a a a a a a -- n", "FUNCTION: XUnregisterIMInstantiateCallback (       -- n )", "EXTERN: \"C\" int XUnregisterIMInstantiateCallback( void * , void * , void * , void * , void * , void *  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XInternalConnectionNumbers XInternalConnectionNumbers a a a -- n", "FUNCTION: XInternalConnectionNumbers (    -- n )", "EXTERN: \"C\" int XInternalConnectionNumbers( void * , void * , void *  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XProcessInternalConnection XProcessInternalConnection a n -- void", "FUNCTION: XProcessInternalConnection (   -- void )", "EXTERN: \"C\" void XProcessInternalConnection( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XAddConnectionWatch XAddConnectionWatch a a a -- n", "FUNCTION: XAddConnectionWatch (    -- n )", "EXTERN: \"C\" int XAddConnectionWatch( void * , void * , void *  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XRemoveConnectionWatch XRemoveConnectionWatch a a a -- void", "FUNCTION: XRemoveConnectionWatch (    -- void )", "EXTERN: \"C\" void XRemoveConnectionWatch( void * , void * , void *  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSetAuthorization XSetAuthorization a n a n -- void", "FUNCTION: XSetAuthorization (     -- void )", "EXTERN: \"C\" void XSetAuthorization( void * , int , void * , int  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function _Xmbtowc _Xmbtowc a a n -- n", "FUNCTION: _Xmbtowc (    -- n )", "EXTERN: \"C\" int _Xmbtowc( void * , void * , int  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function _Xwctomb _Xwctomb a n -- n", "FUNCTION: _Xwctomb (   -- n )", "EXTERN: \"C\" int _Xwctomb( void * , short  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XGetEventData XGetEventData a a -- n", "FUNCTION: XGetEventData (   -- n )", "EXTERN: \"C\" int XGetEventData( void * , void *  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XFreeEventData XFreeEventData a a -- void", "FUNCTION: XFreeEventData (   -- void )", "EXTERN: \"C\" void XFreeEventData( void * , void *  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XAllocClassHint XAllocClassHint  -- a", "FUNCTION: XAllocClassHint (  -- a )", "EXTERN: \"C\" void * XAllocClassHint(  );", "	( -- )" );
	swigFunction( "c-function XAllocIconSize XAllocIconSize  -- a", "FUNCTION: XAllocIconSize (  -- a )", "EXTERN: \"C\" void * XAllocIconSize(  );", "	( -- )" );
	swigFunction( "c-function XAllocSizeHints XAllocSizeHints  -- a", "FUNCTION: XAllocSizeHints (  -- a )", "EXTERN: \"C\" void * XAllocSizeHints(  );", "	( -- )" );
	swigFunction( "c-function XAllocStandardColormap XAllocStandardColormap  -- a", "FUNCTION: XAllocStandardColormap (  -- a )", "EXTERN: \"C\" void * XAllocStandardColormap(  );", "	( -- )" );
	swigFunction( "c-function XAllocWMHints XAllocWMHints  -- a", "FUNCTION: XAllocWMHints (  -- a )", "EXTERN: \"C\" void * XAllocWMHints(  );", "	( -- )" );
	swigFunction( "c-function XClipBox XClipBox a a -- n", "FUNCTION: XClipBox (   -- n )", "EXTERN: \"C\" int XClipBox( void * , void *  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XCreateRegion XCreateRegion  -- a", "FUNCTION: XCreateRegion (  -- a )", "EXTERN: \"C\" void * XCreateRegion(  );", "	( -- )" );
	swigFunction( "c-function XDefaultString XDefaultString  -- s", "FUNCTION: XDefaultString (  -- s )", "EXTERN: \"C\" char * XDefaultString(  );", "	( -- )" );
	swigFunction( "c-function XDeleteContext XDeleteContext a u n -- n", "FUNCTION: XDeleteContext (    -- n )", "EXTERN: \"C\" int XDeleteContext( void * , int , int  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XDestroyRegion XDestroyRegion a -- n", "FUNCTION: XDestroyRegion (  -- n )", "EXTERN: \"C\" int XDestroyRegion( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XEmptyRegion XEmptyRegion a -- n", "FUNCTION: XEmptyRegion (  -- n )", "EXTERN: \"C\" int XEmptyRegion( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XEqualRegion XEqualRegion a a -- n", "FUNCTION: XEqualRegion (   -- n )", "EXTERN: \"C\" int XEqualRegion( void * , void *  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XFindContext XFindContext a u n a -- n", "FUNCTION: XFindContext (     -- n )", "EXTERN: \"C\" int XFindContext( void * , int , int , void *  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XGetClassHint XGetClassHint a u a -- n", "FUNCTION: XGetClassHint (    -- n )", "EXTERN: \"C\" int XGetClassHint( void * , int , void *  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XGetIconSizes XGetIconSizes a u a a -- n", "FUNCTION: XGetIconSizes (     -- n )", "EXTERN: \"C\" int XGetIconSizes( void * , int , void * , void *  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XGetNormalHints XGetNormalHints a u a -- n", "FUNCTION: XGetNormalHints (    -- n )", "EXTERN: \"C\" int XGetNormalHints( void * , int , void *  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XGetRGBColormaps XGetRGBColormaps a u a a u -- n", "FUNCTION: XGetRGBColormaps (      -- n )", "EXTERN: \"C\" int XGetRGBColormaps( void * , int , void * , void * , long  );", "	( <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XGetSizeHints XGetSizeHints a u a u -- n", "FUNCTION: XGetSizeHints (     -- n )", "EXTERN: \"C\" int XGetSizeHints( void * , int , void * , long  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XGetStandardColormap XGetStandardColormap a u a u -- n", "FUNCTION: XGetStandardColormap (     -- n )", "EXTERN: \"C\" int XGetStandardColormap( void * , int , void * , long  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XGetTextProperty XGetTextProperty a u a u -- n", "FUNCTION: XGetTextProperty (     -- n )", "EXTERN: \"C\" int XGetTextProperty( void * , int , void * , long  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XGetVisualInfo XGetVisualInfo a n a a -- a", "FUNCTION: XGetVisualInfo (     -- a )", "EXTERN: \"C\" void * XGetVisualInfo( void * , long , void * , void *  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XGetWMClientMachine XGetWMClientMachine a u a -- n", "FUNCTION: XGetWMClientMachine (    -- n )", "EXTERN: \"C\" int XGetWMClientMachine( void * , int , void *  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XGetWMHints XGetWMHints a u -- a", "FUNCTION: XGetWMHints (   -- a )", "EXTERN: \"C\" void * XGetWMHints( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XGetWMIconName XGetWMIconName a u a -- n", "FUNCTION: XGetWMIconName (    -- n )", "EXTERN: \"C\" int XGetWMIconName( void * , int , void *  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XGetWMName XGetWMName a u a -- n", "FUNCTION: XGetWMName (    -- n )", "EXTERN: \"C\" int XGetWMName( void * , int , void *  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XGetWMNormalHints XGetWMNormalHints a u a a -- n", "FUNCTION: XGetWMNormalHints (     -- n )", "EXTERN: \"C\" int XGetWMNormalHints( void * , int , void * , void *  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XGetWMSizeHints XGetWMSizeHints a u a a u -- n", "FUNCTION: XGetWMSizeHints (      -- n )", "EXTERN: \"C\" int XGetWMSizeHints( void * , int , void * , void * , long  );", "	( <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XGetZoomHints XGetZoomHints a u a -- n", "FUNCTION: XGetZoomHints (    -- n )", "EXTERN: \"C\" int XGetZoomHints( void * , int , void *  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XIntersectRegion XIntersectRegion a a a -- n", "FUNCTION: XIntersectRegion (    -- n )", "EXTERN: \"C\" int XIntersectRegion( void * , void * , void *  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XConvertCase XConvertCase u a a -- void", "FUNCTION: XConvertCase (    -- void )", "EXTERN: \"C\" void XConvertCase( int , void * , void *  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XLookupString XLookupString a a n a a -- n", "FUNCTION: XLookupString (      -- n )", "EXTERN: \"C\" int XLookupString( void * , void * , int , void * , void *  );", "	( <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XMatchVisualInfo XMatchVisualInfo a n n n a -- n", "FUNCTION: XMatchVisualInfo (      -- n )", "EXTERN: \"C\" int XMatchVisualInfo( void * , int , int , int , void *  );", "	( <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XOffsetRegion XOffsetRegion a n n -- n", "FUNCTION: XOffsetRegion (    -- n )", "EXTERN: \"C\" int XOffsetRegion( void * , int , int  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XPointInRegion XPointInRegion a n n -- n", "FUNCTION: XPointInRegion (    -- n )", "EXTERN: \"C\" int XPointInRegion( void * , int , int  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XPolygonRegion XPolygonRegion a n n -- a", "FUNCTION: XPolygonRegion (    -- a )", "EXTERN: \"C\" void * XPolygonRegion( void * , int , int  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XRectInRegion XRectInRegion a n n u u -- n", "FUNCTION: XRectInRegion (      -- n )", "EXTERN: \"C\" int XRectInRegion( void * , int , int , int , int  );", "	( <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSaveContext XSaveContext a u n s -- n", "FUNCTION: XSaveContext (     -- n )", "EXTERN: \"C\" int XSaveContext( void * , int , int , char *  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSetClassHint XSetClassHint a u a -- n", "FUNCTION: XSetClassHint (    -- n )", "EXTERN: \"C\" int XSetClassHint( void * , int , void *  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSetIconSizes XSetIconSizes a u a n -- n", "FUNCTION: XSetIconSizes (     -- n )", "EXTERN: \"C\" int XSetIconSizes( void * , int , void * , int  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSetNormalHints XSetNormalHints a u a -- n", "FUNCTION: XSetNormalHints (    -- n )", "EXTERN: \"C\" int XSetNormalHints( void * , int , void *  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSetRGBColormaps XSetRGBColormaps a u a n u -- void", "FUNCTION: XSetRGBColormaps (      -- void )", "EXTERN: \"C\" void XSetRGBColormaps( void * , int , void * , int , long  );", "	( <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSetSizeHints XSetSizeHints a u a u -- n", "FUNCTION: XSetSizeHints (     -- n )", "EXTERN: \"C\" int XSetSizeHints( void * , int , void * , long  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSetStandardProperties XSetStandardProperties a u s s u a n a -- n", "FUNCTION: XSetStandardProperties (         -- n )", "EXTERN: \"C\" int XSetStandardProperties( void * , int , char * , char * , int , void * , int , void *  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSetTextProperty XSetTextProperty a u a u -- void", "FUNCTION: XSetTextProperty (     -- void )", "EXTERN: \"C\" void XSetTextProperty( void * , int , void * , long  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSetWMClientMachine XSetWMClientMachine a u a -- void", "FUNCTION: XSetWMClientMachine (    -- void )", "EXTERN: \"C\" void XSetWMClientMachine( void * , int , void *  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSetWMHints XSetWMHints a u a -- n", "FUNCTION: XSetWMHints (    -- n )", "EXTERN: \"C\" int XSetWMHints( void * , int , void *  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSetWMIconName XSetWMIconName a u a -- void", "FUNCTION: XSetWMIconName (    -- void )", "EXTERN: \"C\" void XSetWMIconName( void * , int , void *  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSetWMName XSetWMName a u a -- void", "FUNCTION: XSetWMName (    -- void )", "EXTERN: \"C\" void XSetWMName( void * , int , void *  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSetWMNormalHints XSetWMNormalHints a u a -- void", "FUNCTION: XSetWMNormalHints (    -- void )", "EXTERN: \"C\" void XSetWMNormalHints( void * , int , void *  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSetWMProperties XSetWMProperties a u a a a n a a a -- void", "FUNCTION: XSetWMProperties (          -- void )", "EXTERN: \"C\" void XSetWMProperties( void * , int , void * , void * , void * , int , void * , void * , void *  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XmbSetWMProperties XmbSetWMProperties a u s s a n a a a -- void", "FUNCTION: XmbSetWMProperties (          -- void )", "EXTERN: \"C\" void XmbSetWMProperties( void * , int , char * , char * , void * , int , void * , void * , void *  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function Xutf8SetWMProperties Xutf8SetWMProperties a u s s a n a a a -- void", "FUNCTION: Xutf8SetWMProperties (          -- void )", "EXTERN: \"C\" void Xutf8SetWMProperties( void * , int , char * , char * , void * , int , void * , void * , void *  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSetWMSizeHints XSetWMSizeHints a u a u -- void", "FUNCTION: XSetWMSizeHints (     -- void )", "EXTERN: \"C\" void XSetWMSizeHints( void * , int , void * , long  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSetRegion XSetRegion a a a -- n", "FUNCTION: XSetRegion (    -- n )", "EXTERN: \"C\" int XSetRegion( void * , void * , void *  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSetStandardColormap XSetStandardColormap a u a u -- void", "FUNCTION: XSetStandardColormap (     -- void )", "EXTERN: \"C\" void XSetStandardColormap( void * , int , void * , long  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSetZoomHints XSetZoomHints a u a -- n", "FUNCTION: XSetZoomHints (    -- n )", "EXTERN: \"C\" int XSetZoomHints( void * , int , void *  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XShrinkRegion XShrinkRegion a n n -- n", "FUNCTION: XShrinkRegion (    -- n )", "EXTERN: \"C\" int XShrinkRegion( void * , int , int  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XStringListToTextProperty XStringListToTextProperty a n a -- n", "FUNCTION: XStringListToTextProperty (    -- n )", "EXTERN: \"C\" int XStringListToTextProperty( void * , int , void *  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSubtractRegion XSubtractRegion a a a -- n", "FUNCTION: XSubtractRegion (    -- n )", "EXTERN: \"C\" int XSubtractRegion( void * , void * , void *  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XmbTextListToTextProperty XmbTextListToTextProperty a a n n a -- n", "FUNCTION: XmbTextListToTextProperty ( display list count style text_prop_return -- n )", "EXTERN: \"C\" int XmbTextListToTextProperty( void * display, void * list, int count, int style, void * text_prop_return );", "	( display list count style text_prop_return -- )" );
	swigFunction( "c-function XwcTextListToTextProperty XwcTextListToTextProperty a a n n a -- n", "FUNCTION: XwcTextListToTextProperty ( display list count style text_prop_return -- n )", "EXTERN: \"C\" int XwcTextListToTextProperty( void * display, void * list, int count, int style, void * text_prop_return );", "	( display list count style text_prop_return -- )" );
	swigFunction( "c-function Xutf8TextListToTextProperty Xutf8TextListToTextProperty a a n n a -- n", "FUNCTION: Xutf8TextListToTextProperty ( display list count style text_prop_return -- n )", "EXTERN: \"C\" int Xutf8TextListToTextProperty( void * display, void * list, int count, int style, void * text_prop_return );", "	( display list count style text_prop_return -- )" );
	swigFunction( "c-function XwcFreeStringList XwcFreeStringList a -- void", "FUNCTION: XwcFreeStringList ( list -- void )", "EXTERN: \"C\" void XwcFreeStringList( void * list );", "	( list -- )" );
	swigFunction( "c-function XTextPropertyToStringList XTextPropertyToStringList a a a -- n", "FUNCTION: XTextPropertyToStringList (    -- n )", "EXTERN: \"C\" int XTextPropertyToStringList( void * , void * , void *  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XmbTextPropertyToTextList XmbTextPropertyToTextList a a a a -- n", "FUNCTION: XmbTextPropertyToTextList ( display text_prop list_return count_return -- n )", "EXTERN: \"C\" int XmbTextPropertyToTextList( void * display, void * text_prop, void * list_return, void * count_return );", "	( display text_prop list_return count_return -- )" );
	swigFunction( "c-function XwcTextPropertyToTextList XwcTextPropertyToTextList a a a a -- n", "FUNCTION: XwcTextPropertyToTextList ( display text_prop list_return count_return -- n )", "EXTERN: \"C\" int XwcTextPropertyToTextList( void * display, void * text_prop, void * list_return, void * count_return );", "	( display text_prop list_return count_return -- )" );
	swigFunction( "c-function Xutf8TextPropertyToTextList Xutf8TextPropertyToTextList a a a a -- n", "FUNCTION: Xutf8TextPropertyToTextList ( display text_prop list_return count_return -- n )", "EXTERN: \"C\" int Xutf8TextPropertyToTextList( void * display, void * text_prop, void * list_return, void * count_return );", "	( display text_prop list_return count_return -- )" );
	swigFunction( "c-function XUnionRectWithRegion XUnionRectWithRegion a a a -- n", "FUNCTION: XUnionRectWithRegion (    -- n )", "EXTERN: \"C\" int XUnionRectWithRegion( void * , void * , void *  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XUnionRegion XUnionRegion a a a -- n", "FUNCTION: XUnionRegion (    -- n )", "EXTERN: \"C\" int XUnionRegion( void * , void * , void *  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XWMGeometry XWMGeometry a n s s u a a a a a a -- n", "FUNCTION: XWMGeometry (            -- n )", "EXTERN: \"C\" int XWMGeometry( void * , int , char * , char * , int , void * , void * , void * , void * , void * , void *  );", "	( <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XXorRegion XXorRegion a a a -- n", "FUNCTION: XXorRegion (    -- n )", "EXTERN: \"C\" int XXorRegion( void * , void * , void *  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSyncIntToValue XSyncIntToValue a n -- void", "FUNCTION: XSyncIntToValue (   -- void )", "EXTERN: \"C\" void XSyncIntToValue( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XSyncIntsToValue XSyncIntsToValue a u n -- void", "FUNCTION: XSyncIntsToValue (    -- void )", "EXTERN: \"C\" void XSyncIntsToValue( void * , int , int  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSyncValueGreaterThan XSyncValueGreaterThan ud ud -- n", "FUNCTION: XSyncValueGreaterThan (   -- n )", "EXTERN: \"C\" int XSyncValueGreaterThan( long long , long long  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XSyncValueLessThan XSyncValueLessThan ud ud -- n", "FUNCTION: XSyncValueLessThan (   -- n )", "EXTERN: \"C\" int XSyncValueLessThan( long long , long long  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XSyncValueGreaterOrEqual XSyncValueGreaterOrEqual ud ud -- n", "FUNCTION: XSyncValueGreaterOrEqual (   -- n )", "EXTERN: \"C\" int XSyncValueGreaterOrEqual( long long , long long  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XSyncValueLessOrEqual XSyncValueLessOrEqual ud ud -- n", "FUNCTION: XSyncValueLessOrEqual (   -- n )", "EXTERN: \"C\" int XSyncValueLessOrEqual( long long , long long  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XSyncValueEqual XSyncValueEqual ud ud -- n", "FUNCTION: XSyncValueEqual (   -- n )", "EXTERN: \"C\" int XSyncValueEqual( long long , long long  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XSyncValueIsNegative XSyncValueIsNegative ud -- n", "FUNCTION: XSyncValueIsNegative (  -- n )", "EXTERN: \"C\" int XSyncValueIsNegative( long long  );", "	( <noname> -- )" );
	swigFunction( "c-function XSyncValueIsZero XSyncValueIsZero ud -- n", "FUNCTION: XSyncValueIsZero (  -- n )", "EXTERN: \"C\" int XSyncValueIsZero( long long  );", "	( <noname> -- )" );
	swigFunction( "c-function XSyncValueIsPositive XSyncValueIsPositive ud -- n", "FUNCTION: XSyncValueIsPositive (  -- n )", "EXTERN: \"C\" int XSyncValueIsPositive( long long  );", "	( <noname> -- )" );
	swigFunction( "c-function XSyncValueLow32 XSyncValueLow32 ud -- u", "FUNCTION: XSyncValueLow32 (  -- u )", "EXTERN: \"C\" int XSyncValueLow32( long long  );", "	( <noname> -- )" );
	swigFunction( "c-function XSyncValueHigh32 XSyncValueHigh32 ud -- n", "FUNCTION: XSyncValueHigh32 (  -- n )", "EXTERN: \"C\" int XSyncValueHigh32( long long  );", "	( <noname> -- )" );
	swigFunction( "c-function XSyncValueAdd XSyncValueAdd a ud ud a -- void", "FUNCTION: XSyncValueAdd (     -- void )", "EXTERN: \"C\" void XSyncValueAdd( void * , long long , long long , void *  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSyncValueSubtract XSyncValueSubtract a ud ud a -- void", "FUNCTION: XSyncValueSubtract (     -- void )", "EXTERN: \"C\" void XSyncValueSubtract( void * , long long , long long , void *  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSyncMaxValue XSyncMaxValue a -- void", "FUNCTION: XSyncMaxValue (  -- void )", "EXTERN: \"C\" void XSyncMaxValue( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XSyncMinValue XSyncMinValue a -- void", "FUNCTION: XSyncMinValue (  -- void )", "EXTERN: \"C\" void XSyncMinValue( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XSyncQueryExtension XSyncQueryExtension a a a -- n", "FUNCTION: XSyncQueryExtension (    -- n )", "EXTERN: \"C\" int XSyncQueryExtension( void * , void * , void *  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSyncInitialize XSyncInitialize a a a -- n", "FUNCTION: XSyncInitialize (    -- n )", "EXTERN: \"C\" int XSyncInitialize( void * , void * , void *  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSyncListSystemCounters XSyncListSystemCounters a a -- a", "FUNCTION: XSyncListSystemCounters (   -- a )", "EXTERN: \"C\" void * XSyncListSystemCounters( void * , void *  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XSyncFreeSystemCounterList XSyncFreeSystemCounterList a -- void", "FUNCTION: XSyncFreeSystemCounterList (  -- void )", "EXTERN: \"C\" void XSyncFreeSystemCounterList( void *  );", "	( <noname> -- )" );
	swigFunction( "c-function XSyncCreateCounter XSyncCreateCounter a ud -- u", "FUNCTION: XSyncCreateCounter (   -- u )", "EXTERN: \"C\" int XSyncCreateCounter( void * , long long  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XSyncSetCounter XSyncSetCounter a u ud -- n", "FUNCTION: XSyncSetCounter (    -- n )", "EXTERN: \"C\" int XSyncSetCounter( void * , int , long long  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSyncChangeCounter XSyncChangeCounter a u ud -- n", "FUNCTION: XSyncChangeCounter (    -- n )", "EXTERN: \"C\" int XSyncChangeCounter( void * , int , long long  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSyncDestroyCounter XSyncDestroyCounter a u -- n", "FUNCTION: XSyncDestroyCounter (   -- n )", "EXTERN: \"C\" int XSyncDestroyCounter( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XSyncQueryCounter XSyncQueryCounter a u a -- n", "FUNCTION: XSyncQueryCounter (    -- n )", "EXTERN: \"C\" int XSyncQueryCounter( void * , int , void *  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSyncAwait XSyncAwait a a n -- n", "FUNCTION: XSyncAwait (    -- n )", "EXTERN: \"C\" int XSyncAwait( void * , void * , int  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSyncCreateAlarm XSyncCreateAlarm a u a -- u", "FUNCTION: XSyncCreateAlarm (    -- u )", "EXTERN: \"C\" int XSyncCreateAlarm( void * , long , void *  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSyncDestroyAlarm XSyncDestroyAlarm a u -- n", "FUNCTION: XSyncDestroyAlarm (   -- n )", "EXTERN: \"C\" int XSyncDestroyAlarm( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XSyncQueryAlarm XSyncQueryAlarm a u a -- n", "FUNCTION: XSyncQueryAlarm (    -- n )", "EXTERN: \"C\" int XSyncQueryAlarm( void * , int , void *  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSyncChangeAlarm XSyncChangeAlarm a u u a -- n", "FUNCTION: XSyncChangeAlarm (     -- n )", "EXTERN: \"C\" int XSyncChangeAlarm( void * , int , long , void *  );", "	( <noname> <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSyncSetPriority XSyncSetPriority a u n -- n", "FUNCTION: XSyncSetPriority (    -- n )", "EXTERN: \"C\" int XSyncSetPriority( void * , int , int  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSyncGetPriority XSyncGetPriority a u a -- n", "FUNCTION: XSyncGetPriority (    -- n )", "EXTERN: \"C\" int XSyncGetPriority( void * , int , void *  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSyncCreateFence XSyncCreateFence a u n -- u", "FUNCTION: XSyncCreateFence (    -- u )", "EXTERN: \"C\" int XSyncCreateFence( void * , int , int  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSyncTriggerFence XSyncTriggerFence a u -- n", "FUNCTION: XSyncTriggerFence (   -- n )", "EXTERN: \"C\" int XSyncTriggerFence( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XSyncResetFence XSyncResetFence a u -- n", "FUNCTION: XSyncResetFence (   -- n )", "EXTERN: \"C\" int XSyncResetFence( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XSyncDestroyFence XSyncDestroyFence a u -- n", "FUNCTION: XSyncDestroyFence (   -- n )", "EXTERN: \"C\" int XSyncDestroyFence( void * , int  );", "	( <noname> <noname> -- )" );
	swigFunction( "c-function XSyncQueryFence XSyncQueryFence a u a -- n", "FUNCTION: XSyncQueryFence (    -- n )", "EXTERN: \"C\" int XSyncQueryFence( void * , int , void *  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XSyncAwaitFence XSyncAwaitFence a a n -- n", "FUNCTION: XSyncAwaitFence (    -- n )", "EXTERN: \"C\" int XSyncAwaitFence( void * , void * , int  );", "	( <noname> <noname> <noname> -- )" );
	swigFunction( "c-function XRRQueryExtension XRRQueryExtension a a a -- n", "FUNCTION: XRRQueryExtension ( dpy event_base_return error_base_return -- n )", "EXTERN: \"C\" int XRRQueryExtension( void * dpy, void * event_base_return, void * error_base_return );", "	( dpy event_base_return error_base_return -- )" );
	swigFunction( "c-function XRRQueryVersion XRRQueryVersion a a a -- n", "FUNCTION: XRRQueryVersion ( dpy major_version_return minor_version_return -- n )", "EXTERN: \"C\" int XRRQueryVersion( void * dpy, void * major_version_return, void * minor_version_return );", "	( dpy major_version_return minor_version_return -- )" );
	swigFunction( "c-function XRRGetScreenInfo XRRGetScreenInfo a u -- a", "FUNCTION: XRRGetScreenInfo ( dpy window -- a )", "EXTERN: \"C\" void * XRRGetScreenInfo( void * dpy, int window );", "	( dpy window -- )" );
	swigFunction( "c-function XRRFreeScreenConfigInfo XRRFreeScreenConfigInfo a -- void", "FUNCTION: XRRFreeScreenConfigInfo ( config -- void )", "EXTERN: \"C\" void XRRFreeScreenConfigInfo( void * config );", "	( config -- )" );
	swigFunction( "c-function XRRSetScreenConfig XRRSetScreenConfig a a u n n u -- n", "FUNCTION: XRRSetScreenConfig ( dpy config draw size_index rotation timestamp -- n )", "EXTERN: \"C\" int XRRSetScreenConfig( void * dpy, void * config, int draw, int size_index, long rotation, long timestamp );", "	( dpy config draw size_index rotation timestamp -- )" );
	swigFunction( "c-function XRRSetScreenConfigAndRate XRRSetScreenConfigAndRate a a u n n n u -- n", "FUNCTION: XRRSetScreenConfigAndRate ( dpy config draw size_index rotation rate timestamp -- n )", "EXTERN: \"C\" int XRRSetScreenConfigAndRate( void * dpy, void * config, int draw, int size_index, long rotation, short rate, long timestamp );", "	( dpy config draw size_index rotation rate timestamp -- )" );
	swigFunction( "c-function XRRConfigRotations XRRConfigRotations a a -- n", "FUNCTION: XRRConfigRotations ( config current_rotation -- n )", "EXTERN: \"C\" long XRRConfigRotations( void * config, void * current_rotation );", "	( config current_rotation -- )" );
	swigFunction( "c-function XRRConfigTimes XRRConfigTimes a a -- u", "FUNCTION: XRRConfigTimes ( config config_timestamp -- u )", "EXTERN: \"C\" long XRRConfigTimes( void * config, void * config_timestamp );", "	( config config_timestamp -- )" );
	swigFunction( "c-function XRRConfigSizes XRRConfigSizes a a -- a", "FUNCTION: XRRConfigSizes ( config nsizes -- a )", "EXTERN: \"C\" void * XRRConfigSizes( void * config, void * nsizes );", "	( config nsizes -- )" );
	swigFunction( "c-function XRRConfigRates XRRConfigRates a n a -- a", "FUNCTION: XRRConfigRates ( config sizeID nrates -- a )", "EXTERN: \"C\" void * XRRConfigRates( void * config, int sizeID, void * nrates );", "	( config sizeID nrates -- )" );
	swigFunction( "c-function XRRConfigCurrentConfiguration XRRConfigCurrentConfiguration a a -- n", "FUNCTION: XRRConfigCurrentConfiguration ( config rotation -- n )", "EXTERN: \"C\" long XRRConfigCurrentConfiguration( void * config, void * rotation );", "	( config rotation -- )" );
	swigFunction( "c-function XRRConfigCurrentRate XRRConfigCurrentRate a -- n", "FUNCTION: XRRConfigCurrentRate ( config -- n )", "EXTERN: \"C\" short XRRConfigCurrentRate( void * config );", "	( config -- )" );
	swigFunction( "c-function XRRRootToScreen XRRRootToScreen a u -- n", "FUNCTION: XRRRootToScreen ( dpy root -- n )", "EXTERN: \"C\" int XRRRootToScreen( void * dpy, int root );", "	( dpy root -- )" );
	swigFunction( "c-function XRRSelectInput XRRSelectInput a u n -- void", "FUNCTION: XRRSelectInput ( dpy window mask -- void )", "EXTERN: \"C\" void XRRSelectInput( void * dpy, int window, int mask );", "	( dpy window mask -- )" );
	swigFunction( "c-function XRRRotations XRRRotations a n a -- n", "FUNCTION: XRRRotations ( dpy screen current_rotation -- n )", "EXTERN: \"C\" long XRRRotations( void * dpy, int screen, void * current_rotation );", "	( dpy screen current_rotation -- )" );
	swigFunction( "c-function XRRSizes XRRSizes a n a -- a", "FUNCTION: XRRSizes ( dpy screen nsizes -- a )", "EXTERN: \"C\" void * XRRSizes( void * dpy, int screen, void * nsizes );", "	( dpy screen nsizes -- )" );
	swigFunction( "c-function XRRRates XRRRates a n n a -- a", "FUNCTION: XRRRates ( dpy screen sizeID nrates -- a )", "EXTERN: \"C\" void * XRRRates( void * dpy, int screen, int sizeID, void * nrates );", "	( dpy screen sizeID nrates -- )" );
	swigFunction( "c-function XRRTimes XRRTimes a n a -- u", "FUNCTION: XRRTimes ( dpy screen config_timestamp -- u )", "EXTERN: \"C\" long XRRTimes( void * dpy, int screen, void * config_timestamp );", "	( dpy screen config_timestamp -- )" );
	swigFunction( "c-function XRRGetScreenSizeRange XRRGetScreenSizeRange a u a a a a -- n", "FUNCTION: XRRGetScreenSizeRange ( dpy window minWidth minHeight maxWidth maxHeight -- n )", "EXTERN: \"C\" int XRRGetScreenSizeRange( void * dpy, int window, void * minWidth, void * minHeight, void * maxWidth, void * maxHeight );", "	( dpy window minWidth minHeight maxWidth maxHeight -- )" );
	swigFunction( "c-function XRRSetScreenSize XRRSetScreenSize a u n n n n -- void", "FUNCTION: XRRSetScreenSize ( dpy window width height mmWidth mmHeight -- void )", "EXTERN: \"C\" void XRRSetScreenSize( void * dpy, int window, int width, int height, int mmWidth, int mmHeight );", "	( dpy window width height mmWidth mmHeight -- )" );
	swigFunction( "c-function XRRGetScreenResources XRRGetScreenResources a u -- a", "FUNCTION: XRRGetScreenResources ( dpy window -- a )", "EXTERN: \"C\" void * XRRGetScreenResources( void * dpy, int window );", "	( dpy window -- )" );
	swigFunction( "c-function XRRFreeScreenResources XRRFreeScreenResources a -- void", "FUNCTION: XRRFreeScreenResources ( resources -- void )", "EXTERN: \"C\" void XRRFreeScreenResources( void * resources );", "	( resources -- )" );
	swigFunction( "c-function XRRGetOutputInfo XRRGetOutputInfo a a u -- a", "FUNCTION: XRRGetOutputInfo ( dpy resources output -- a )", "EXTERN: \"C\" void * XRRGetOutputInfo( void * dpy, void * resources, int output );", "	( dpy resources output -- )" );
	swigFunction( "c-function XRRFreeOutputInfo XRRFreeOutputInfo a -- void", "FUNCTION: XRRFreeOutputInfo ( outputInfo -- void )", "EXTERN: \"C\" void XRRFreeOutputInfo( void * outputInfo );", "	( outputInfo -- )" );
	swigFunction( "c-function XRRListOutputProperties XRRListOutputProperties a u a -- a", "FUNCTION: XRRListOutputProperties ( dpy output nprop -- a )", "EXTERN: \"C\" void * XRRListOutputProperties( void * dpy, int output, void * nprop );", "	( dpy output nprop -- )" );
	swigFunction( "c-function XRRQueryOutputProperty XRRQueryOutputProperty a u u -- a", "FUNCTION: XRRQueryOutputProperty ( dpy output property -- a )", "EXTERN: \"C\" void * XRRQueryOutputProperty( void * dpy, int output, long property );", "	( dpy output property -- )" );
	swigFunction( "c-function XRRConfigureOutputProperty XRRConfigureOutputProperty a u u n n n a -- void", "FUNCTION: XRRConfigureOutputProperty ( dpy output property pending range num_values values -- void )", "EXTERN: \"C\" void XRRConfigureOutputProperty( void * dpy, int output, long property, int pending, int range, int num_values, void * values );", "	( dpy output property pending range num_values values -- )" );
	swigFunction( "c-function XRRChangeOutputProperty XRRChangeOutputProperty a u u u n n a n -- void", "FUNCTION: XRRChangeOutputProperty ( dpy output property type format mode data nelements -- void )", "EXTERN: \"C\" void XRRChangeOutputProperty( void * dpy, int output, long property, long type, int format, int mode, void * data, int nelements );", "	( dpy output property type format mode data nelements -- )" );
	swigFunction( "c-function XRRDeleteOutputProperty XRRDeleteOutputProperty a u u -- void", "FUNCTION: XRRDeleteOutputProperty ( dpy output property -- void )", "EXTERN: \"C\" void XRRDeleteOutputProperty( void * dpy, int output, long property );", "	( dpy output property -- )" );
	swigFunction( "c-function XRRGetOutputProperty XRRGetOutputProperty a u u n n n n u a a a a a -- n", "FUNCTION: XRRGetOutputProperty ( dpy output property offset length _delete pending req_type actual_type actual_format nitems bytes_after prop -- n )", "EXTERN: \"C\" int XRRGetOutputProperty( void * dpy, int output, long property, long offset, long length, int _delete, int pending, long req_type, void * actual_type, void * actual_format, void * nitems, void * bytes_after, void * prop );", "	( dpy output property offset length _delete pending req_type actual_type actual_format nitems bytes_after prop -- )" );
	swigFunction( "c-function XRRAllocModeInfo XRRAllocModeInfo s n -- a", "FUNCTION: XRRAllocModeInfo ( name nameLength -- a )", "EXTERN: \"C\" void * XRRAllocModeInfo( char * name, int nameLength );", "	( name nameLength -- )" );
	swigFunction( "c-function XRRCreateMode XRRCreateMode a u a -- u", "FUNCTION: XRRCreateMode ( dpy window modeInfo -- u )", "EXTERN: \"C\" int XRRCreateMode( void * dpy, int window, void * modeInfo );", "	( dpy window modeInfo -- )" );
	swigFunction( "c-function XRRDestroyMode XRRDestroyMode a u -- void", "FUNCTION: XRRDestroyMode ( dpy mode -- void )", "EXTERN: \"C\" void XRRDestroyMode( void * dpy, int mode );", "	( dpy mode -- )" );
	swigFunction( "c-function XRRAddOutputMode XRRAddOutputMode a u u -- void", "FUNCTION: XRRAddOutputMode ( dpy output mode -- void )", "EXTERN: \"C\" void XRRAddOutputMode( void * dpy, int output, int mode );", "	( dpy output mode -- )" );
	swigFunction( "c-function XRRDeleteOutputMode XRRDeleteOutputMode a u u -- void", "FUNCTION: XRRDeleteOutputMode ( dpy output mode -- void )", "EXTERN: \"C\" void XRRDeleteOutputMode( void * dpy, int output, int mode );", "	( dpy output mode -- )" );
	swigFunction( "c-function XRRFreeModeInfo XRRFreeModeInfo a -- void", "FUNCTION: XRRFreeModeInfo ( modeInfo -- void )", "EXTERN: \"C\" void XRRFreeModeInfo( void * modeInfo );", "	( modeInfo -- )" );
	swigFunction( "c-function XRRGetCrtcInfo XRRGetCrtcInfo a a u -- a", "FUNCTION: XRRGetCrtcInfo ( dpy resources crtc -- a )", "EXTERN: \"C\" void * XRRGetCrtcInfo( void * dpy, void * resources, int crtc );", "	( dpy resources crtc -- )" );
	swigFunction( "c-function XRRFreeCrtcInfo XRRFreeCrtcInfo a -- void", "FUNCTION: XRRFreeCrtcInfo ( crtcInfo -- void )", "EXTERN: \"C\" void XRRFreeCrtcInfo( void * crtcInfo );", "	( crtcInfo -- )" );
	swigFunction( "c-function XRRSetCrtcConfig XRRSetCrtcConfig a a u u n n u n a n -- n", "FUNCTION: XRRSetCrtcConfig ( dpy resources crtc timestamp x y mode rotation outputs noutputs -- n )", "EXTERN: \"C\" int XRRSetCrtcConfig( void * dpy, void * resources, int crtc, long timestamp, int x, int y, int mode, long rotation, void * outputs, int noutputs );", "	( dpy resources crtc timestamp x y mode rotation outputs noutputs -- )" );
	swigFunction( "c-function XRRGetCrtcGammaSize XRRGetCrtcGammaSize a u -- n", "FUNCTION: XRRGetCrtcGammaSize ( dpy crtc -- n )", "EXTERN: \"C\" int XRRGetCrtcGammaSize( void * dpy, int crtc );", "	( dpy crtc -- )" );
	swigFunction( "c-function XRRGetCrtcGamma XRRGetCrtcGamma a u -- a", "FUNCTION: XRRGetCrtcGamma ( dpy crtc -- a )", "EXTERN: \"C\" void * XRRGetCrtcGamma( void * dpy, int crtc );", "	( dpy crtc -- )" );
	swigFunction( "c-function XRRAllocGamma XRRAllocGamma n -- a", "FUNCTION: XRRAllocGamma ( size -- a )", "EXTERN: \"C\" void * XRRAllocGamma( int size );", "	( size -- )" );
	swigFunction( "c-function XRRSetCrtcGamma XRRSetCrtcGamma a u a -- void", "FUNCTION: XRRSetCrtcGamma ( dpy crtc gamma -- void )", "EXTERN: \"C\" void XRRSetCrtcGamma( void * dpy, int crtc, void * gamma );", "	( dpy crtc gamma -- )" );
	swigFunction( "c-function XRRFreeGamma XRRFreeGamma a -- void", "FUNCTION: XRRFreeGamma ( gamma -- void )", "EXTERN: \"C\" void XRRFreeGamma( void * gamma );", "	( gamma -- )" );
	swigFunction( "c-function XRRGetScreenResourcesCurrent XRRGetScreenResourcesCurrent a u -- a", "FUNCTION: XRRGetScreenResourcesCurrent ( dpy window -- a )", "EXTERN: \"C\" void * XRRGetScreenResourcesCurrent( void * dpy, int window );", "	( dpy window -- )" );
	swigFunction( "c-function XRRSetCrtcTransform XRRSetCrtcTransform a u a s a n -- void", "FUNCTION: XRRSetCrtcTransform ( dpy crtc transform filter params nparams -- void )", "EXTERN: \"C\" void XRRSetCrtcTransform( void * dpy, int crtc, void * transform, char * filter, void * params, int nparams );", "	( dpy crtc transform filter params nparams -- )" );
	swigFunction( "c-function XRRGetCrtcTransform XRRGetCrtcTransform a u a -- n", "FUNCTION: XRRGetCrtcTransform ( dpy crtc attributes -- n )", "EXTERN: \"C\" int XRRGetCrtcTransform( void * dpy, int crtc, void * attributes );", "	( dpy crtc attributes -- )" );
	swigFunction( "c-function XRRUpdateConfiguration XRRUpdateConfiguration a -- n", "FUNCTION: XRRUpdateConfiguration ( event -- n )", "EXTERN: \"C\" int XRRUpdateConfiguration( void * event );", "	( event -- )" );
	swigFunction( "c-function XRRGetPanning XRRGetPanning a a u -- a", "FUNCTION: XRRGetPanning ( dpy resources crtc -- a )", "EXTERN: \"C\" void * XRRGetPanning( void * dpy, void * resources, int crtc );", "	( dpy resources crtc -- )" );
	swigFunction( "c-function XRRFreePanning XRRFreePanning a -- void", "FUNCTION: XRRFreePanning ( panning -- void )", "EXTERN: \"C\" void XRRFreePanning( void * panning );", "	( panning -- )" );
	swigFunction( "c-function XRRSetPanning XRRSetPanning a a u a -- n", "FUNCTION: XRRSetPanning ( dpy resources crtc panning -- n )", "EXTERN: \"C\" int XRRSetPanning( void * dpy, void * resources, int crtc, void * panning );", "	( dpy resources crtc panning -- )" );
	swigFunction( "c-function XRRSetOutputPrimary XRRSetOutputPrimary a u u -- void", "FUNCTION: XRRSetOutputPrimary ( dpy window output -- void )", "EXTERN: \"C\" void XRRSetOutputPrimary( void * dpy, int window, int output );", "	( dpy window output -- )" );
	swigFunction( "c-function XRRGetOutputPrimary XRRGetOutputPrimary a u -- u", "FUNCTION: XRRGetOutputPrimary ( dpy window -- u )", "EXTERN: \"C\" int XRRGetOutputPrimary( void * dpy, int window );", "	( dpy window -- )" );
	swigFunction( "c-function XRRGetProviderResources XRRGetProviderResources a u -- a", "FUNCTION: XRRGetProviderResources ( dpy window -- a )", "EXTERN: \"C\" void * XRRGetProviderResources( void * dpy, int window );", "	( dpy window -- )" );
	swigFunction( "c-function XRRFreeProviderResources XRRFreeProviderResources a -- void", "FUNCTION: XRRFreeProviderResources ( resources -- void )", "EXTERN: \"C\" void XRRFreeProviderResources( void * resources );", "	( resources -- )" );
	swigFunction( "c-function XRRGetProviderInfo XRRGetProviderInfo a a u -- a", "FUNCTION: XRRGetProviderInfo ( dpy resources provider -- a )", "EXTERN: \"C\" void * XRRGetProviderInfo( void * dpy, void * resources, int provider );", "	( dpy resources provider -- )" );
	swigFunction( "c-function XRRFreeProviderInfo XRRFreeProviderInfo a -- void", "FUNCTION: XRRFreeProviderInfo ( provider -- void )", "EXTERN: \"C\" void XRRFreeProviderInfo( void * provider );", "	( provider -- )" );
	swigFunction( "c-function XRRSetProviderOutputSource XRRSetProviderOutputSource a u u -- n", "FUNCTION: XRRSetProviderOutputSource ( dpy provider source_provider -- n )", "EXTERN: \"C\" int XRRSetProviderOutputSource( void * dpy, int provider, int source_provider );", "	( dpy provider source_provider -- )" );
	swigFunction( "c-function XRRSetProviderOffloadSink XRRSetProviderOffloadSink a u u -- n", "FUNCTION: XRRSetProviderOffloadSink ( dpy provider sink_provider -- n )", "EXTERN: \"C\" int XRRSetProviderOffloadSink( void * dpy, int provider, int sink_provider );", "	( dpy provider sink_provider -- )" );
	swigFunction( "c-function XRRListProviderProperties XRRListProviderProperties a u a -- a", "FUNCTION: XRRListProviderProperties ( dpy provider nprop -- a )", "EXTERN: \"C\" void * XRRListProviderProperties( void * dpy, int provider, void * nprop );", "	( dpy provider nprop -- )" );
	swigFunction( "c-function XRRQueryProviderProperty XRRQueryProviderProperty a u u -- a", "FUNCTION: XRRQueryProviderProperty ( dpy provider property -- a )", "EXTERN: \"C\" void * XRRQueryProviderProperty( void * dpy, int provider, long property );", "	( dpy provider property -- )" );
	swigFunction( "c-function XRRConfigureProviderProperty XRRConfigureProviderProperty a u u n n n a -- void", "FUNCTION: XRRConfigureProviderProperty ( dpy provider property pending range num_values values -- void )", "EXTERN: \"C\" void XRRConfigureProviderProperty( void * dpy, int provider, long property, int pending, int range, int num_values, void * values );", "	( dpy provider property pending range num_values values -- )" );
	swigFunction( "c-function XRRChangeProviderProperty XRRChangeProviderProperty a u u u n n a n -- void", "FUNCTION: XRRChangeProviderProperty ( dpy provider property type format mode data nelements -- void )", "EXTERN: \"C\" void XRRChangeProviderProperty( void * dpy, int provider, long property, long type, int format, int mode, void * data, int nelements );", "	( dpy provider property type format mode data nelements -- )" );
	swigFunction( "c-function XRRDeleteProviderProperty XRRDeleteProviderProperty a u u -- void", "FUNCTION: XRRDeleteProviderProperty ( dpy provider property -- void )", "EXTERN: \"C\" void XRRDeleteProviderProperty( void * dpy, int provider, long property );", "	( dpy provider property -- )" );
	swigFunction( "c-function XRRGetProviderProperty XRRGetProviderProperty a u u n n n n u a a a a a -- n", "FUNCTION: XRRGetProviderProperty ( dpy provider property offset length _delete pending req_type actual_type actual_format nitems bytes_after prop -- n )", "EXTERN: \"C\" int XRRGetProviderProperty( void * dpy, int provider, long property, long offset, long length, int _delete, int pending, long req_type, void * actual_type, void * actual_format, void * nitems, void * bytes_after, void * prop );", "	( dpy provider property offset length _delete pending req_type actual_type actual_format nitems bytes_after prop -- )" );
	swigFunction( "c-function XRRAllocateMonitor XRRAllocateMonitor a n -- a", "FUNCTION: XRRAllocateMonitor ( dpy noutput -- a )", "EXTERN: \"C\" void * XRRAllocateMonitor( void * dpy, int noutput );", "	( dpy noutput -- )" );
	swigFunction( "c-function XRRGetMonitors XRRGetMonitors a u n a -- a", "FUNCTION: XRRGetMonitors ( dpy window get_active nmonitors -- a )", "EXTERN: \"C\" void * XRRGetMonitors( void * dpy, int window, int get_active, void * nmonitors );", "	( dpy window get_active nmonitors -- )" );
	swigFunction( "c-function XRRSetMonitor XRRSetMonitor a u a -- void", "FUNCTION: XRRSetMonitor ( dpy window monitor -- void )", "EXTERN: \"C\" void XRRSetMonitor( void * dpy, int window, void * monitor );", "	( dpy window monitor -- )" );
	swigFunction( "c-function XRRDeleteMonitor XRRDeleteMonitor a u u -- void", "FUNCTION: XRRDeleteMonitor ( dpy window name -- void )", "EXTERN: \"C\" void XRRDeleteMonitor( void * dpy, int window, long name );", "	( dpy window name -- )" );
	swigFunction( "c-function XRRFreeMonitors XRRFreeMonitors a -- void", "FUNCTION: XRRFreeMonitors ( monitors -- void )", "EXTERN: \"C\" void XRRFreeMonitors( void * monitors );", "	( monitors -- )" );

	swigNewline();

	swigComment("----===< postfix >===-----\n");

	swigPrint( "end-c-library", "( none )", "( none )" );
	
	return 0;
} /* end of main */



