/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 3.0.9
 *
 * This file is not intended to be easily readable and contains a number of
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG
 * interface file instead.
 * ----------------------------------------------------------------------------- */
#include <stdio.h>
#include <string.h>
#include <stddef.h>

// Do not edit below this line
// end-of-default-includes


#include <vulkan/vulkan.h>
#include <vulkan/vulkan_core.h>

typedef enum{ NONE = -1, GFORTH = 0, SWIFTFORTH, VFX } SwigTargetSystem;
SwigTargetSystem swigTargetSystem = NONE;

unsigned char swigPrintStackComments = 1;

/* comments */
void swigNewline()
{
	printf( "\n" );
}

void swigComment( char *comment )
{
	printf( "\\ %s", comment );
}

/* generic print */
void swigPrint( char* gforth, char *swiftForth, char *vfx )
{
	if( swigTargetSystem == GFORTH )
		printf( "%s", gforth );
	else if( swigTargetSystem == SWIFTFORTH )
		printf( "%s", swiftForth );
	else if( swigTargetSystem == VFX )
		printf( "%s", vfx );
	printf( "\n" );
}
void swigPrintSystem( SwigTargetSystem targetSystem, char *text )
{
	if( targetSystem == swigTargetSystem )
	    printf( "%s\n", text );
}

/* constants */
void swigIntConstant( long constant, char *name )
{
	printf( "#%ld\tconstant %s\n", constant, name );
}

void swigUnsignedIntConstant( unsigned long constant, char *name )
{
	printf( "#%lu\tconstant %s\n", constant, name );
}

void swigLongConstant( long long constant, char *name )
{
	printf( "#%lld.\t2constant %s\n", constant, name );
}

void swigUnsignedLongConstant( unsigned long long constant, char *name )
{
	printf( "#%llu.\t2constant %s\n", constant, name );
}

void swigFloatConstant( double constant, char *name )
{
	char buffer[128];
	sprintf( buffer, "%f", constant );

	/* if the constant contains no exponent, add one */
	char *s;
	for( s = buffer; *s != 0; s++ )
		if( *s == 'e' || *s == 'E' )
			break;

	/* exponent found */
	if( *s != 0 )
		printf( "%s\tfconstant %s\n", buffer, name );
	/* not found */
	else
		printf( "%se0\tfconstant %s\n", buffer, name );
}

void swigStringConstant( char* constant, char *name )
{
	char c;
	printf( ": %s s\\\" ", name );
	while(( c = *constant++ ))
	{
		switch(c)
		{
			case '\b': printf( "\\b" ); break;
			case '\n': printf( "\\n" ); break;
			case '\f': printf( "\\f" ); break;
			case '\r': printf( "\\r" ); break;
			case '\t': printf( "\\t" ); break;
			case '"' : printf( "\\q" ); break;
			default:
				if(c < 0x20)
					printf("\\x%02x", c);
				else
					printf("%c", c); break;
		}
	}
	printf(	"\" ;\n" );
}

/* structs */
void swigStructField( char *name, size_t offset, size_t size )
{
	printf( "\tdrop %zu %zu +field %s\n", offset, size, name );
}

/* functions */
void swigFunction( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	if( swigTargetSystem == GFORTH )
		printf( "%s", gforth );
	else if( swigTargetSystem == SWIFTFORTH )
		printf( "%s", swiftForth );
	else if( swigTargetSystem == VFX )
		printf( "%s", vfx );

	if( swigPrintStackComments )
		printf( "%s", stackComment );

	printf( "\n" );
}

/* function pointers */
void swigFunctionPointer( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	swigFunction( gforth, swiftForth, vfx, stackComment );
}

/* callbacks */
void swigCallback( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	swigFunction( gforth, swiftForth, vfx, stackComment );
}

void swigUsage( char **argv )
{
	fprintf( stderr, "Usage: %s [-gforth|-swiftforth|-vfx]\n", argv[0] );
}

int main( int argc, char **argv )
{
	int i;

	/* check arguments */
	for( i = 1; i < argc; i++ )
		if( strcmp( argv[i], "-gforth" ) == 0 )
			swigTargetSystem = GFORTH;
		else if( strcmp( argv[i], "-swiftforth" ) == 0 )
			swigTargetSystem = SWIFTFORTH;
		else if( strcmp( argv[i], "-vfx" ) == 0 )
			swigTargetSystem = VFX;

	if( swigTargetSystem == NONE )
	{
		fprintf( stderr, "Error: no target system specified\n" );
		swigUsage( argv );
		return 1;
	}

	/* primer */
	printf( "\\ This file has been generated using SWIG and fsi,\n"
		"\\ and is already platform dependent, search for the corresponding\n"
		"\\ fsi-file to compile it where no one has compiled it before ;)\n"
		"\\ Forth systems have their own own dynamic loader and don't need addional C-Code.\n"
		"\\ That's why this file will just print normal forth-code once compiled\n"
		"\\ and can be used directly with include or require.\n"
		"\\ As all comments are stripped during the compilation, please\n"
		"\\ insert the copyright notice of the original file here.\n"
	);



	swigNewline();

	swigComment("----===< prefix >===-----\n");

	swigPrint( "c-library vulkan\ns\" vulkan\" add-lib\n\\c #include <vulkan/vulkan.h>\n\\c #include <vulkan/vulkan_core.h>", "( none )", "( none )" );

	swigNewline();

	swigComment("----===< int constants >===-----\n");
	#ifdef VULKAN_H_
		swigIntConstant( VULKAN_H_, "VULKAN_H_" );
	#endif
	#ifdef VULKAN_CORE_H_
		swigIntConstant( VULKAN_CORE_H_, "VULKAN_CORE_H_" );
	#endif
	#ifdef VK_VERSION_1_0
		swigIntConstant( VK_VERSION_1_0, "VK_VERSION_1_0" );
	#endif
	#ifdef VK_USE_64_BIT_PTR_DEFINES
		swigIntConstant( VK_USE_64_BIT_PTR_DEFINES, "VK_USE_64_BIT_PTR_DEFINES" );
	#endif
	#ifdef VK_HEADER_VERSION
		swigIntConstant( VK_HEADER_VERSION, "VK_HEADER_VERSION" );
	#endif
	#ifdef VK_UUID_SIZE
		swigUnsignedIntConstant( VK_UUID_SIZE, "VK_UUID_SIZE" );
	#endif
	#ifdef VK_ATTACHMENT_UNUSED
		swigUnsignedIntConstant( VK_ATTACHMENT_UNUSED, "VK_ATTACHMENT_UNUSED" );
	#endif
	#ifdef VK_FALSE
		swigUnsignedIntConstant( VK_FALSE, "VK_FALSE" );
	#endif
	#ifdef VK_QUEUE_FAMILY_IGNORED
		swigUnsignedIntConstant( VK_QUEUE_FAMILY_IGNORED, "VK_QUEUE_FAMILY_IGNORED" );
	#endif
	#ifdef VK_REMAINING_ARRAY_LAYERS
		swigUnsignedIntConstant( VK_REMAINING_ARRAY_LAYERS, "VK_REMAINING_ARRAY_LAYERS" );
	#endif
	#ifdef VK_REMAINING_MIP_LEVELS
		swigUnsignedIntConstant( VK_REMAINING_MIP_LEVELS, "VK_REMAINING_MIP_LEVELS" );
	#endif
	#ifdef VK_SUBPASS_EXTERNAL
		swigUnsignedIntConstant( VK_SUBPASS_EXTERNAL, "VK_SUBPASS_EXTERNAL" );
	#endif
	#ifdef VK_TRUE
		swigUnsignedIntConstant( VK_TRUE, "VK_TRUE" );
	#endif
	#ifdef VK_MAX_MEMORY_TYPES
		swigUnsignedIntConstant( VK_MAX_MEMORY_TYPES, "VK_MAX_MEMORY_TYPES" );
	#endif
	#ifdef VK_MAX_MEMORY_HEAPS
		swigUnsignedIntConstant( VK_MAX_MEMORY_HEAPS, "VK_MAX_MEMORY_HEAPS" );
	#endif
	#ifdef VK_MAX_PHYSICAL_DEVICE_NAME_SIZE
		swigUnsignedIntConstant( VK_MAX_PHYSICAL_DEVICE_NAME_SIZE, "VK_MAX_PHYSICAL_DEVICE_NAME_SIZE" );
	#endif
	#ifdef VK_MAX_EXTENSION_NAME_SIZE
		swigUnsignedIntConstant( VK_MAX_EXTENSION_NAME_SIZE, "VK_MAX_EXTENSION_NAME_SIZE" );
	#endif
	#ifdef VK_MAX_DESCRIPTION_SIZE
		swigUnsignedIntConstant( VK_MAX_DESCRIPTION_SIZE, "VK_MAX_DESCRIPTION_SIZE" );
	#endif
	#ifdef VK_VERSION_1_1
		swigIntConstant( VK_VERSION_1_1, "VK_VERSION_1_1" );
	#endif
	#ifdef VK_MAX_DEVICE_GROUP_SIZE
		swigUnsignedIntConstant( VK_MAX_DEVICE_GROUP_SIZE, "VK_MAX_DEVICE_GROUP_SIZE" );
	#endif
	#ifdef VK_LUID_SIZE
		swigUnsignedIntConstant( VK_LUID_SIZE, "VK_LUID_SIZE" );
	#endif
	#ifdef VK_QUEUE_FAMILY_EXTERNAL
		swigUnsignedIntConstant( VK_QUEUE_FAMILY_EXTERNAL, "VK_QUEUE_FAMILY_EXTERNAL" );
	#endif
	#ifdef VK_VERSION_1_2
		swigIntConstant( VK_VERSION_1_2, "VK_VERSION_1_2" );
	#endif
	#ifdef VK_MAX_DRIVER_NAME_SIZE
		swigUnsignedIntConstant( VK_MAX_DRIVER_NAME_SIZE, "VK_MAX_DRIVER_NAME_SIZE" );
	#endif
	#ifdef VK_MAX_DRIVER_INFO_SIZE
		swigUnsignedIntConstant( VK_MAX_DRIVER_INFO_SIZE, "VK_MAX_DRIVER_INFO_SIZE" );
	#endif
	#ifdef VK_KHR_surface
		swigIntConstant( VK_KHR_surface, "VK_KHR_surface" );
	#endif
	#ifdef VK_KHR_SURFACE_SPEC_VERSION
		swigIntConstant( VK_KHR_SURFACE_SPEC_VERSION, "VK_KHR_SURFACE_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_swapchain
		swigIntConstant( VK_KHR_swapchain, "VK_KHR_swapchain" );
	#endif
	#ifdef VK_KHR_SWAPCHAIN_SPEC_VERSION
		swigIntConstant( VK_KHR_SWAPCHAIN_SPEC_VERSION, "VK_KHR_SWAPCHAIN_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_display
		swigIntConstant( VK_KHR_display, "VK_KHR_display" );
	#endif
	#ifdef VK_KHR_DISPLAY_SPEC_VERSION
		swigIntConstant( VK_KHR_DISPLAY_SPEC_VERSION, "VK_KHR_DISPLAY_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_display_swapchain
		swigIntConstant( VK_KHR_display_swapchain, "VK_KHR_display_swapchain" );
	#endif
	#ifdef VK_KHR_DISPLAY_SWAPCHAIN_SPEC_VERSION
		swigIntConstant( VK_KHR_DISPLAY_SWAPCHAIN_SPEC_VERSION, "VK_KHR_DISPLAY_SWAPCHAIN_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_sampler_mirror_clamp_to_edge
		swigIntConstant( VK_KHR_sampler_mirror_clamp_to_edge, "VK_KHR_sampler_mirror_clamp_to_edge" );
	#endif
	#ifdef VK_KHR_SAMPLER_MIRROR_CLAMP_TO_EDGE_SPEC_VERSION
		swigIntConstant( VK_KHR_SAMPLER_MIRROR_CLAMP_TO_EDGE_SPEC_VERSION, "VK_KHR_SAMPLER_MIRROR_CLAMP_TO_EDGE_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_dynamic_rendering
		swigIntConstant( VK_KHR_dynamic_rendering, "VK_KHR_dynamic_rendering" );
	#endif
	#ifdef VK_KHR_DYNAMIC_RENDERING_SPEC_VERSION
		swigIntConstant( VK_KHR_DYNAMIC_RENDERING_SPEC_VERSION, "VK_KHR_DYNAMIC_RENDERING_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_multiview
		swigIntConstant( VK_KHR_multiview, "VK_KHR_multiview" );
	#endif
	#ifdef VK_KHR_MULTIVIEW_SPEC_VERSION
		swigIntConstant( VK_KHR_MULTIVIEW_SPEC_VERSION, "VK_KHR_MULTIVIEW_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_get_physical_device_properties2
		swigIntConstant( VK_KHR_get_physical_device_properties2, "VK_KHR_get_physical_device_properties2" );
	#endif
	#ifdef VK_KHR_GET_PHYSICAL_DEVICE_PROPERTIES_2_SPEC_VERSION
		swigIntConstant( VK_KHR_GET_PHYSICAL_DEVICE_PROPERTIES_2_SPEC_VERSION, "VK_KHR_GET_PHYSICAL_DEVICE_PROPERTIES_2_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_device_group
		swigIntConstant( VK_KHR_device_group, "VK_KHR_device_group" );
	#endif
	#ifdef VK_KHR_DEVICE_GROUP_SPEC_VERSION
		swigIntConstant( VK_KHR_DEVICE_GROUP_SPEC_VERSION, "VK_KHR_DEVICE_GROUP_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_shader_draw_parameters
		swigIntConstant( VK_KHR_shader_draw_parameters, "VK_KHR_shader_draw_parameters" );
	#endif
	#ifdef VK_KHR_SHADER_DRAW_PARAMETERS_SPEC_VERSION
		swigIntConstant( VK_KHR_SHADER_DRAW_PARAMETERS_SPEC_VERSION, "VK_KHR_SHADER_DRAW_PARAMETERS_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_maintenance1
		swigIntConstant( VK_KHR_maintenance1, "VK_KHR_maintenance1" );
	#endif
	#ifdef VK_KHR_MAINTENANCE_1_SPEC_VERSION
		swigIntConstant( VK_KHR_MAINTENANCE_1_SPEC_VERSION, "VK_KHR_MAINTENANCE_1_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_MAINTENANCE1_SPEC_VERSION
		swigIntConstant( VK_KHR_MAINTENANCE1_SPEC_VERSION, "VK_KHR_MAINTENANCE1_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_device_group_creation
		swigIntConstant( VK_KHR_device_group_creation, "VK_KHR_device_group_creation" );
	#endif
	#ifdef VK_KHR_DEVICE_GROUP_CREATION_SPEC_VERSION
		swigIntConstant( VK_KHR_DEVICE_GROUP_CREATION_SPEC_VERSION, "VK_KHR_DEVICE_GROUP_CREATION_SPEC_VERSION" );
	#endif
	#ifdef VK_MAX_DEVICE_GROUP_SIZE_KHR
		swigUnsignedIntConstant( VK_MAX_DEVICE_GROUP_SIZE_KHR, "VK_MAX_DEVICE_GROUP_SIZE_KHR" );
	#endif
	#ifdef VK_KHR_external_memory_capabilities
		swigIntConstant( VK_KHR_external_memory_capabilities, "VK_KHR_external_memory_capabilities" );
	#endif
	#ifdef VK_KHR_EXTERNAL_MEMORY_CAPABILITIES_SPEC_VERSION
		swigIntConstant( VK_KHR_EXTERNAL_MEMORY_CAPABILITIES_SPEC_VERSION, "VK_KHR_EXTERNAL_MEMORY_CAPABILITIES_SPEC_VERSION" );
	#endif
	#ifdef VK_LUID_SIZE_KHR
		swigUnsignedIntConstant( VK_LUID_SIZE_KHR, "VK_LUID_SIZE_KHR" );
	#endif
	#ifdef VK_KHR_external_memory
		swigIntConstant( VK_KHR_external_memory, "VK_KHR_external_memory" );
	#endif
	#ifdef VK_KHR_EXTERNAL_MEMORY_SPEC_VERSION
		swigIntConstant( VK_KHR_EXTERNAL_MEMORY_SPEC_VERSION, "VK_KHR_EXTERNAL_MEMORY_SPEC_VERSION" );
	#endif
	#ifdef VK_QUEUE_FAMILY_EXTERNAL_KHR
		swigUnsignedIntConstant( VK_QUEUE_FAMILY_EXTERNAL_KHR, "VK_QUEUE_FAMILY_EXTERNAL_KHR" );
	#endif
	#ifdef VK_KHR_external_memory_fd
		swigIntConstant( VK_KHR_external_memory_fd, "VK_KHR_external_memory_fd" );
	#endif
	#ifdef VK_KHR_EXTERNAL_MEMORY_FD_SPEC_VERSION
		swigIntConstant( VK_KHR_EXTERNAL_MEMORY_FD_SPEC_VERSION, "VK_KHR_EXTERNAL_MEMORY_FD_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_external_semaphore_capabilities
		swigIntConstant( VK_KHR_external_semaphore_capabilities, "VK_KHR_external_semaphore_capabilities" );
	#endif
	#ifdef VK_KHR_EXTERNAL_SEMAPHORE_CAPABILITIES_SPEC_VERSION
		swigIntConstant( VK_KHR_EXTERNAL_SEMAPHORE_CAPABILITIES_SPEC_VERSION, "VK_KHR_EXTERNAL_SEMAPHORE_CAPABILITIES_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_external_semaphore
		swigIntConstant( VK_KHR_external_semaphore, "VK_KHR_external_semaphore" );
	#endif
	#ifdef VK_KHR_EXTERNAL_SEMAPHORE_SPEC_VERSION
		swigIntConstant( VK_KHR_EXTERNAL_SEMAPHORE_SPEC_VERSION, "VK_KHR_EXTERNAL_SEMAPHORE_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_external_semaphore_fd
		swigIntConstant( VK_KHR_external_semaphore_fd, "VK_KHR_external_semaphore_fd" );
	#endif
	#ifdef VK_KHR_EXTERNAL_SEMAPHORE_FD_SPEC_VERSION
		swigIntConstant( VK_KHR_EXTERNAL_SEMAPHORE_FD_SPEC_VERSION, "VK_KHR_EXTERNAL_SEMAPHORE_FD_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_push_descriptor
		swigIntConstant( VK_KHR_push_descriptor, "VK_KHR_push_descriptor" );
	#endif
	#ifdef VK_KHR_PUSH_DESCRIPTOR_SPEC_VERSION
		swigIntConstant( VK_KHR_PUSH_DESCRIPTOR_SPEC_VERSION, "VK_KHR_PUSH_DESCRIPTOR_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_shader_float16_int8
		swigIntConstant( VK_KHR_shader_float16_int8, "VK_KHR_shader_float16_int8" );
	#endif
	#ifdef VK_KHR_SHADER_FLOAT16_INT8_SPEC_VERSION
		swigIntConstant( VK_KHR_SHADER_FLOAT16_INT8_SPEC_VERSION, "VK_KHR_SHADER_FLOAT16_INT8_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_16bit_storage
		swigIntConstant( VK_KHR_16bit_storage, "VK_KHR_16bit_storage" );
	#endif
	#ifdef VK_KHR_16BIT_STORAGE_SPEC_VERSION
		swigIntConstant( VK_KHR_16BIT_STORAGE_SPEC_VERSION, "VK_KHR_16BIT_STORAGE_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_incremental_present
		swigIntConstant( VK_KHR_incremental_present, "VK_KHR_incremental_present" );
	#endif
	#ifdef VK_KHR_INCREMENTAL_PRESENT_SPEC_VERSION
		swigIntConstant( VK_KHR_INCREMENTAL_PRESENT_SPEC_VERSION, "VK_KHR_INCREMENTAL_PRESENT_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_descriptor_update_template
		swigIntConstant( VK_KHR_descriptor_update_template, "VK_KHR_descriptor_update_template" );
	#endif
	#ifdef VK_KHR_DESCRIPTOR_UPDATE_TEMPLATE_SPEC_VERSION
		swigIntConstant( VK_KHR_DESCRIPTOR_UPDATE_TEMPLATE_SPEC_VERSION, "VK_KHR_DESCRIPTOR_UPDATE_TEMPLATE_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_imageless_framebuffer
		swigIntConstant( VK_KHR_imageless_framebuffer, "VK_KHR_imageless_framebuffer" );
	#endif
	#ifdef VK_KHR_IMAGELESS_FRAMEBUFFER_SPEC_VERSION
		swigIntConstant( VK_KHR_IMAGELESS_FRAMEBUFFER_SPEC_VERSION, "VK_KHR_IMAGELESS_FRAMEBUFFER_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_create_renderpass2
		swigIntConstant( VK_KHR_create_renderpass2, "VK_KHR_create_renderpass2" );
	#endif
	#ifdef VK_KHR_CREATE_RENDERPASS_2_SPEC_VERSION
		swigIntConstant( VK_KHR_CREATE_RENDERPASS_2_SPEC_VERSION, "VK_KHR_CREATE_RENDERPASS_2_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_shared_presentable_image
		swigIntConstant( VK_KHR_shared_presentable_image, "VK_KHR_shared_presentable_image" );
	#endif
	#ifdef VK_KHR_SHARED_PRESENTABLE_IMAGE_SPEC_VERSION
		swigIntConstant( VK_KHR_SHARED_PRESENTABLE_IMAGE_SPEC_VERSION, "VK_KHR_SHARED_PRESENTABLE_IMAGE_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_external_fence_capabilities
		swigIntConstant( VK_KHR_external_fence_capabilities, "VK_KHR_external_fence_capabilities" );
	#endif
	#ifdef VK_KHR_EXTERNAL_FENCE_CAPABILITIES_SPEC_VERSION
		swigIntConstant( VK_KHR_EXTERNAL_FENCE_CAPABILITIES_SPEC_VERSION, "VK_KHR_EXTERNAL_FENCE_CAPABILITIES_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_external_fence
		swigIntConstant( VK_KHR_external_fence, "VK_KHR_external_fence" );
	#endif
	#ifdef VK_KHR_EXTERNAL_FENCE_SPEC_VERSION
		swigIntConstant( VK_KHR_EXTERNAL_FENCE_SPEC_VERSION, "VK_KHR_EXTERNAL_FENCE_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_external_fence_fd
		swigIntConstant( VK_KHR_external_fence_fd, "VK_KHR_external_fence_fd" );
	#endif
	#ifdef VK_KHR_EXTERNAL_FENCE_FD_SPEC_VERSION
		swigIntConstant( VK_KHR_EXTERNAL_FENCE_FD_SPEC_VERSION, "VK_KHR_EXTERNAL_FENCE_FD_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_performance_query
		swigIntConstant( VK_KHR_performance_query, "VK_KHR_performance_query" );
	#endif
	#ifdef VK_KHR_PERFORMANCE_QUERY_SPEC_VERSION
		swigIntConstant( VK_KHR_PERFORMANCE_QUERY_SPEC_VERSION, "VK_KHR_PERFORMANCE_QUERY_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_maintenance2
		swigIntConstant( VK_KHR_maintenance2, "VK_KHR_maintenance2" );
	#endif
	#ifdef VK_KHR_MAINTENANCE_2_SPEC_VERSION
		swigIntConstant( VK_KHR_MAINTENANCE_2_SPEC_VERSION, "VK_KHR_MAINTENANCE_2_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_MAINTENANCE2_SPEC_VERSION
		swigIntConstant( VK_KHR_MAINTENANCE2_SPEC_VERSION, "VK_KHR_MAINTENANCE2_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_get_surface_capabilities2
		swigIntConstant( VK_KHR_get_surface_capabilities2, "VK_KHR_get_surface_capabilities2" );
	#endif
	#ifdef VK_KHR_GET_SURFACE_CAPABILITIES_2_SPEC_VERSION
		swigIntConstant( VK_KHR_GET_SURFACE_CAPABILITIES_2_SPEC_VERSION, "VK_KHR_GET_SURFACE_CAPABILITIES_2_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_variable_pointers
		swigIntConstant( VK_KHR_variable_pointers, "VK_KHR_variable_pointers" );
	#endif
	#ifdef VK_KHR_VARIABLE_POINTERS_SPEC_VERSION
		swigIntConstant( VK_KHR_VARIABLE_POINTERS_SPEC_VERSION, "VK_KHR_VARIABLE_POINTERS_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_get_display_properties2
		swigIntConstant( VK_KHR_get_display_properties2, "VK_KHR_get_display_properties2" );
	#endif
	#ifdef VK_KHR_GET_DISPLAY_PROPERTIES_2_SPEC_VERSION
		swigIntConstant( VK_KHR_GET_DISPLAY_PROPERTIES_2_SPEC_VERSION, "VK_KHR_GET_DISPLAY_PROPERTIES_2_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_dedicated_allocation
		swigIntConstant( VK_KHR_dedicated_allocation, "VK_KHR_dedicated_allocation" );
	#endif
	#ifdef VK_KHR_DEDICATED_ALLOCATION_SPEC_VERSION
		swigIntConstant( VK_KHR_DEDICATED_ALLOCATION_SPEC_VERSION, "VK_KHR_DEDICATED_ALLOCATION_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_storage_buffer_storage_class
		swigIntConstant( VK_KHR_storage_buffer_storage_class, "VK_KHR_storage_buffer_storage_class" );
	#endif
	#ifdef VK_KHR_STORAGE_BUFFER_STORAGE_CLASS_SPEC_VERSION
		swigIntConstant( VK_KHR_STORAGE_BUFFER_STORAGE_CLASS_SPEC_VERSION, "VK_KHR_STORAGE_BUFFER_STORAGE_CLASS_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_relaxed_block_layout
		swigIntConstant( VK_KHR_relaxed_block_layout, "VK_KHR_relaxed_block_layout" );
	#endif
	#ifdef VK_KHR_RELAXED_BLOCK_LAYOUT_SPEC_VERSION
		swigIntConstant( VK_KHR_RELAXED_BLOCK_LAYOUT_SPEC_VERSION, "VK_KHR_RELAXED_BLOCK_LAYOUT_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_get_memory_requirements2
		swigIntConstant( VK_KHR_get_memory_requirements2, "VK_KHR_get_memory_requirements2" );
	#endif
	#ifdef VK_KHR_GET_MEMORY_REQUIREMENTS_2_SPEC_VERSION
		swigIntConstant( VK_KHR_GET_MEMORY_REQUIREMENTS_2_SPEC_VERSION, "VK_KHR_GET_MEMORY_REQUIREMENTS_2_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_image_format_list
		swigIntConstant( VK_KHR_image_format_list, "VK_KHR_image_format_list" );
	#endif
	#ifdef VK_KHR_IMAGE_FORMAT_LIST_SPEC_VERSION
		swigIntConstant( VK_KHR_IMAGE_FORMAT_LIST_SPEC_VERSION, "VK_KHR_IMAGE_FORMAT_LIST_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_sampler_ycbcr_conversion
		swigIntConstant( VK_KHR_sampler_ycbcr_conversion, "VK_KHR_sampler_ycbcr_conversion" );
	#endif
	#ifdef VK_KHR_SAMPLER_YCBCR_CONVERSION_SPEC_VERSION
		swigIntConstant( VK_KHR_SAMPLER_YCBCR_CONVERSION_SPEC_VERSION, "VK_KHR_SAMPLER_YCBCR_CONVERSION_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_bind_memory2
		swigIntConstant( VK_KHR_bind_memory2, "VK_KHR_bind_memory2" );
	#endif
	#ifdef VK_KHR_BIND_MEMORY_2_SPEC_VERSION
		swigIntConstant( VK_KHR_BIND_MEMORY_2_SPEC_VERSION, "VK_KHR_BIND_MEMORY_2_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_maintenance3
		swigIntConstant( VK_KHR_maintenance3, "VK_KHR_maintenance3" );
	#endif
	#ifdef VK_KHR_MAINTENANCE_3_SPEC_VERSION
		swigIntConstant( VK_KHR_MAINTENANCE_3_SPEC_VERSION, "VK_KHR_MAINTENANCE_3_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_MAINTENANCE3_SPEC_VERSION
		swigIntConstant( VK_KHR_MAINTENANCE3_SPEC_VERSION, "VK_KHR_MAINTENANCE3_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_draw_indirect_count
		swigIntConstant( VK_KHR_draw_indirect_count, "VK_KHR_draw_indirect_count" );
	#endif
	#ifdef VK_KHR_DRAW_INDIRECT_COUNT_SPEC_VERSION
		swigIntConstant( VK_KHR_DRAW_INDIRECT_COUNT_SPEC_VERSION, "VK_KHR_DRAW_INDIRECT_COUNT_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_shader_subgroup_extended_types
		swigIntConstant( VK_KHR_shader_subgroup_extended_types, "VK_KHR_shader_subgroup_extended_types" );
	#endif
	#ifdef VK_KHR_SHADER_SUBGROUP_EXTENDED_TYPES_SPEC_VERSION
		swigIntConstant( VK_KHR_SHADER_SUBGROUP_EXTENDED_TYPES_SPEC_VERSION, "VK_KHR_SHADER_SUBGROUP_EXTENDED_TYPES_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_8bit_storage
		swigIntConstant( VK_KHR_8bit_storage, "VK_KHR_8bit_storage" );
	#endif
	#ifdef VK_KHR_8BIT_STORAGE_SPEC_VERSION
		swigIntConstant( VK_KHR_8BIT_STORAGE_SPEC_VERSION, "VK_KHR_8BIT_STORAGE_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_shader_atomic_int64
		swigIntConstant( VK_KHR_shader_atomic_int64, "VK_KHR_shader_atomic_int64" );
	#endif
	#ifdef VK_KHR_SHADER_ATOMIC_INT64_SPEC_VERSION
		swigIntConstant( VK_KHR_SHADER_ATOMIC_INT64_SPEC_VERSION, "VK_KHR_SHADER_ATOMIC_INT64_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_shader_clock
		swigIntConstant( VK_KHR_shader_clock, "VK_KHR_shader_clock" );
	#endif
	#ifdef VK_KHR_SHADER_CLOCK_SPEC_VERSION
		swigIntConstant( VK_KHR_SHADER_CLOCK_SPEC_VERSION, "VK_KHR_SHADER_CLOCK_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_driver_properties
		swigIntConstant( VK_KHR_driver_properties, "VK_KHR_driver_properties" );
	#endif
	#ifdef VK_KHR_DRIVER_PROPERTIES_SPEC_VERSION
		swigIntConstant( VK_KHR_DRIVER_PROPERTIES_SPEC_VERSION, "VK_KHR_DRIVER_PROPERTIES_SPEC_VERSION" );
	#endif
	#ifdef VK_MAX_DRIVER_NAME_SIZE_KHR
		swigUnsignedIntConstant( VK_MAX_DRIVER_NAME_SIZE_KHR, "VK_MAX_DRIVER_NAME_SIZE_KHR" );
	#endif
	#ifdef VK_MAX_DRIVER_INFO_SIZE_KHR
		swigUnsignedIntConstant( VK_MAX_DRIVER_INFO_SIZE_KHR, "VK_MAX_DRIVER_INFO_SIZE_KHR" );
	#endif
	#ifdef VK_KHR_shader_float_controls
		swigIntConstant( VK_KHR_shader_float_controls, "VK_KHR_shader_float_controls" );
	#endif
	#ifdef VK_KHR_SHADER_FLOAT_CONTROLS_SPEC_VERSION
		swigIntConstant( VK_KHR_SHADER_FLOAT_CONTROLS_SPEC_VERSION, "VK_KHR_SHADER_FLOAT_CONTROLS_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_depth_stencil_resolve
		swigIntConstant( VK_KHR_depth_stencil_resolve, "VK_KHR_depth_stencil_resolve" );
	#endif
	#ifdef VK_KHR_DEPTH_STENCIL_RESOLVE_SPEC_VERSION
		swigIntConstant( VK_KHR_DEPTH_STENCIL_RESOLVE_SPEC_VERSION, "VK_KHR_DEPTH_STENCIL_RESOLVE_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_swapchain_mutable_format
		swigIntConstant( VK_KHR_swapchain_mutable_format, "VK_KHR_swapchain_mutable_format" );
	#endif
	#ifdef VK_KHR_SWAPCHAIN_MUTABLE_FORMAT_SPEC_VERSION
		swigIntConstant( VK_KHR_SWAPCHAIN_MUTABLE_FORMAT_SPEC_VERSION, "VK_KHR_SWAPCHAIN_MUTABLE_FORMAT_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_timeline_semaphore
		swigIntConstant( VK_KHR_timeline_semaphore, "VK_KHR_timeline_semaphore" );
	#endif
	#ifdef VK_KHR_TIMELINE_SEMAPHORE_SPEC_VERSION
		swigIntConstant( VK_KHR_TIMELINE_SEMAPHORE_SPEC_VERSION, "VK_KHR_TIMELINE_SEMAPHORE_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_vulkan_memory_model
		swigIntConstant( VK_KHR_vulkan_memory_model, "VK_KHR_vulkan_memory_model" );
	#endif
	#ifdef VK_KHR_VULKAN_MEMORY_MODEL_SPEC_VERSION
		swigIntConstant( VK_KHR_VULKAN_MEMORY_MODEL_SPEC_VERSION, "VK_KHR_VULKAN_MEMORY_MODEL_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_shader_terminate_invocation
		swigIntConstant( VK_KHR_shader_terminate_invocation, "VK_KHR_shader_terminate_invocation" );
	#endif
	#ifdef VK_KHR_SHADER_TERMINATE_INVOCATION_SPEC_VERSION
		swigIntConstant( VK_KHR_SHADER_TERMINATE_INVOCATION_SPEC_VERSION, "VK_KHR_SHADER_TERMINATE_INVOCATION_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_fragment_shading_rate
		swigIntConstant( VK_KHR_fragment_shading_rate, "VK_KHR_fragment_shading_rate" );
	#endif
	#ifdef VK_KHR_FRAGMENT_SHADING_RATE_SPEC_VERSION
		swigIntConstant( VK_KHR_FRAGMENT_SHADING_RATE_SPEC_VERSION, "VK_KHR_FRAGMENT_SHADING_RATE_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_spirv_1_4
		swigIntConstant( VK_KHR_spirv_1_4, "VK_KHR_spirv_1_4" );
	#endif
	#ifdef VK_KHR_SPIRV_1_4_SPEC_VERSION
		swigIntConstant( VK_KHR_SPIRV_1_4_SPEC_VERSION, "VK_KHR_SPIRV_1_4_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_surface_protected_capabilities
		swigIntConstant( VK_KHR_surface_protected_capabilities, "VK_KHR_surface_protected_capabilities" );
	#endif
	#ifdef VK_KHR_SURFACE_PROTECTED_CAPABILITIES_SPEC_VERSION
		swigIntConstant( VK_KHR_SURFACE_PROTECTED_CAPABILITIES_SPEC_VERSION, "VK_KHR_SURFACE_PROTECTED_CAPABILITIES_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_separate_depth_stencil_layouts
		swigIntConstant( VK_KHR_separate_depth_stencil_layouts, "VK_KHR_separate_depth_stencil_layouts" );
	#endif
	#ifdef VK_KHR_SEPARATE_DEPTH_STENCIL_LAYOUTS_SPEC_VERSION
		swigIntConstant( VK_KHR_SEPARATE_DEPTH_STENCIL_LAYOUTS_SPEC_VERSION, "VK_KHR_SEPARATE_DEPTH_STENCIL_LAYOUTS_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_present_wait
		swigIntConstant( VK_KHR_present_wait, "VK_KHR_present_wait" );
	#endif
	#ifdef VK_KHR_PRESENT_WAIT_SPEC_VERSION
		swigIntConstant( VK_KHR_PRESENT_WAIT_SPEC_VERSION, "VK_KHR_PRESENT_WAIT_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_uniform_buffer_standard_layout
		swigIntConstant( VK_KHR_uniform_buffer_standard_layout, "VK_KHR_uniform_buffer_standard_layout" );
	#endif
	#ifdef VK_KHR_UNIFORM_BUFFER_STANDARD_LAYOUT_SPEC_VERSION
		swigIntConstant( VK_KHR_UNIFORM_BUFFER_STANDARD_LAYOUT_SPEC_VERSION, "VK_KHR_UNIFORM_BUFFER_STANDARD_LAYOUT_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_buffer_device_address
		swigIntConstant( VK_KHR_buffer_device_address, "VK_KHR_buffer_device_address" );
	#endif
	#ifdef VK_KHR_BUFFER_DEVICE_ADDRESS_SPEC_VERSION
		swigIntConstant( VK_KHR_BUFFER_DEVICE_ADDRESS_SPEC_VERSION, "VK_KHR_BUFFER_DEVICE_ADDRESS_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_deferred_host_operations
		swigIntConstant( VK_KHR_deferred_host_operations, "VK_KHR_deferred_host_operations" );
	#endif
	#ifdef VK_KHR_DEFERRED_HOST_OPERATIONS_SPEC_VERSION
		swigIntConstant( VK_KHR_DEFERRED_HOST_OPERATIONS_SPEC_VERSION, "VK_KHR_DEFERRED_HOST_OPERATIONS_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_pipeline_executable_properties
		swigIntConstant( VK_KHR_pipeline_executable_properties, "VK_KHR_pipeline_executable_properties" );
	#endif
	#ifdef VK_KHR_PIPELINE_EXECUTABLE_PROPERTIES_SPEC_VERSION
		swigIntConstant( VK_KHR_PIPELINE_EXECUTABLE_PROPERTIES_SPEC_VERSION, "VK_KHR_PIPELINE_EXECUTABLE_PROPERTIES_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_shader_integer_dot_product
		swigIntConstant( VK_KHR_shader_integer_dot_product, "VK_KHR_shader_integer_dot_product" );
	#endif
	#ifdef VK_KHR_SHADER_INTEGER_DOT_PRODUCT_SPEC_VERSION
		swigIntConstant( VK_KHR_SHADER_INTEGER_DOT_PRODUCT_SPEC_VERSION, "VK_KHR_SHADER_INTEGER_DOT_PRODUCT_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_pipeline_library
		swigIntConstant( VK_KHR_pipeline_library, "VK_KHR_pipeline_library" );
	#endif
	#ifdef VK_KHR_PIPELINE_LIBRARY_SPEC_VERSION
		swigIntConstant( VK_KHR_PIPELINE_LIBRARY_SPEC_VERSION, "VK_KHR_PIPELINE_LIBRARY_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_shader_non_semantic_info
		swigIntConstant( VK_KHR_shader_non_semantic_info, "VK_KHR_shader_non_semantic_info" );
	#endif
	#ifdef VK_KHR_SHADER_NON_SEMANTIC_INFO_SPEC_VERSION
		swigIntConstant( VK_KHR_SHADER_NON_SEMANTIC_INFO_SPEC_VERSION, "VK_KHR_SHADER_NON_SEMANTIC_INFO_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_present_id
		swigIntConstant( VK_KHR_present_id, "VK_KHR_present_id" );
	#endif
	#ifdef VK_KHR_PRESENT_ID_SPEC_VERSION
		swigIntConstant( VK_KHR_PRESENT_ID_SPEC_VERSION, "VK_KHR_PRESENT_ID_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_synchronization2
		swigIntConstant( VK_KHR_synchronization2, "VK_KHR_synchronization2" );
	#endif
	#ifdef VK_KHR_SYNCHRONIZATION_2_SPEC_VERSION
		swigIntConstant( VK_KHR_SYNCHRONIZATION_2_SPEC_VERSION, "VK_KHR_SYNCHRONIZATION_2_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_shader_subgroup_uniform_control_flow
		swigIntConstant( VK_KHR_shader_subgroup_uniform_control_flow, "VK_KHR_shader_subgroup_uniform_control_flow" );
	#endif
	#ifdef VK_KHR_SHADER_SUBGROUP_UNIFORM_CONTROL_FLOW_SPEC_VERSION
		swigIntConstant( VK_KHR_SHADER_SUBGROUP_UNIFORM_CONTROL_FLOW_SPEC_VERSION, "VK_KHR_SHADER_SUBGROUP_UNIFORM_CONTROL_FLOW_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_zero_initialize_workgroup_memory
		swigIntConstant( VK_KHR_zero_initialize_workgroup_memory, "VK_KHR_zero_initialize_workgroup_memory" );
	#endif
	#ifdef VK_KHR_ZERO_INITIALIZE_WORKGROUP_MEMORY_SPEC_VERSION
		swigIntConstant( VK_KHR_ZERO_INITIALIZE_WORKGROUP_MEMORY_SPEC_VERSION, "VK_KHR_ZERO_INITIALIZE_WORKGROUP_MEMORY_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_workgroup_memory_explicit_layout
		swigIntConstant( VK_KHR_workgroup_memory_explicit_layout, "VK_KHR_workgroup_memory_explicit_layout" );
	#endif
	#ifdef VK_KHR_WORKGROUP_MEMORY_EXPLICIT_LAYOUT_SPEC_VERSION
		swigIntConstant( VK_KHR_WORKGROUP_MEMORY_EXPLICIT_LAYOUT_SPEC_VERSION, "VK_KHR_WORKGROUP_MEMORY_EXPLICIT_LAYOUT_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_copy_commands2
		swigIntConstant( VK_KHR_copy_commands2, "VK_KHR_copy_commands2" );
	#endif
	#ifdef VK_KHR_COPY_COMMANDS_2_SPEC_VERSION
		swigIntConstant( VK_KHR_COPY_COMMANDS_2_SPEC_VERSION, "VK_KHR_COPY_COMMANDS_2_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_format_feature_flags2
		swigIntConstant( VK_KHR_format_feature_flags2, "VK_KHR_format_feature_flags2" );
	#endif
	#ifdef VK_KHR_FORMAT_FEATURE_FLAGS_2_SPEC_VERSION
		swigIntConstant( VK_KHR_FORMAT_FEATURE_FLAGS_2_SPEC_VERSION, "VK_KHR_FORMAT_FEATURE_FLAGS_2_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_maintenance4
		swigIntConstant( VK_KHR_maintenance4, "VK_KHR_maintenance4" );
	#endif
	#ifdef VK_KHR_MAINTENANCE_4_SPEC_VERSION
		swigIntConstant( VK_KHR_MAINTENANCE_4_SPEC_VERSION, "VK_KHR_MAINTENANCE_4_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_debug_report
		swigIntConstant( VK_EXT_debug_report, "VK_EXT_debug_report" );
	#endif
	#ifdef VK_EXT_DEBUG_REPORT_SPEC_VERSION
		swigIntConstant( VK_EXT_DEBUG_REPORT_SPEC_VERSION, "VK_EXT_DEBUG_REPORT_SPEC_VERSION" );
	#endif
	#ifdef VK_NV_glsl_shader
		swigIntConstant( VK_NV_glsl_shader, "VK_NV_glsl_shader" );
	#endif
	#ifdef VK_NV_GLSL_SHADER_SPEC_VERSION
		swigIntConstant( VK_NV_GLSL_SHADER_SPEC_VERSION, "VK_NV_GLSL_SHADER_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_depth_range_unrestricted
		swigIntConstant( VK_EXT_depth_range_unrestricted, "VK_EXT_depth_range_unrestricted" );
	#endif
	#ifdef VK_EXT_DEPTH_RANGE_UNRESTRICTED_SPEC_VERSION
		swigIntConstant( VK_EXT_DEPTH_RANGE_UNRESTRICTED_SPEC_VERSION, "VK_EXT_DEPTH_RANGE_UNRESTRICTED_SPEC_VERSION" );
	#endif
	#ifdef VK_IMG_filter_cubic
		swigIntConstant( VK_IMG_filter_cubic, "VK_IMG_filter_cubic" );
	#endif
	#ifdef VK_IMG_FILTER_CUBIC_SPEC_VERSION
		swigIntConstant( VK_IMG_FILTER_CUBIC_SPEC_VERSION, "VK_IMG_FILTER_CUBIC_SPEC_VERSION" );
	#endif
	#ifdef VK_AMD_rasterization_order
		swigIntConstant( VK_AMD_rasterization_order, "VK_AMD_rasterization_order" );
	#endif
	#ifdef VK_AMD_RASTERIZATION_ORDER_SPEC_VERSION
		swigIntConstant( VK_AMD_RASTERIZATION_ORDER_SPEC_VERSION, "VK_AMD_RASTERIZATION_ORDER_SPEC_VERSION" );
	#endif
	#ifdef VK_AMD_shader_trinary_minmax
		swigIntConstant( VK_AMD_shader_trinary_minmax, "VK_AMD_shader_trinary_minmax" );
	#endif
	#ifdef VK_AMD_SHADER_TRINARY_MINMAX_SPEC_VERSION
		swigIntConstant( VK_AMD_SHADER_TRINARY_MINMAX_SPEC_VERSION, "VK_AMD_SHADER_TRINARY_MINMAX_SPEC_VERSION" );
	#endif
	#ifdef VK_AMD_shader_explicit_vertex_parameter
		swigIntConstant( VK_AMD_shader_explicit_vertex_parameter, "VK_AMD_shader_explicit_vertex_parameter" );
	#endif
	#ifdef VK_AMD_SHADER_EXPLICIT_VERTEX_PARAMETER_SPEC_VERSION
		swigIntConstant( VK_AMD_SHADER_EXPLICIT_VERTEX_PARAMETER_SPEC_VERSION, "VK_AMD_SHADER_EXPLICIT_VERTEX_PARAMETER_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_debug_marker
		swigIntConstant( VK_EXT_debug_marker, "VK_EXT_debug_marker" );
	#endif
	#ifdef VK_EXT_DEBUG_MARKER_SPEC_VERSION
		swigIntConstant( VK_EXT_DEBUG_MARKER_SPEC_VERSION, "VK_EXT_DEBUG_MARKER_SPEC_VERSION" );
	#endif
	#ifdef VK_AMD_gcn_shader
		swigIntConstant( VK_AMD_gcn_shader, "VK_AMD_gcn_shader" );
	#endif
	#ifdef VK_AMD_GCN_SHADER_SPEC_VERSION
		swigIntConstant( VK_AMD_GCN_SHADER_SPEC_VERSION, "VK_AMD_GCN_SHADER_SPEC_VERSION" );
	#endif
	#ifdef VK_NV_dedicated_allocation
		swigIntConstant( VK_NV_dedicated_allocation, "VK_NV_dedicated_allocation" );
	#endif
	#ifdef VK_NV_DEDICATED_ALLOCATION_SPEC_VERSION
		swigIntConstant( VK_NV_DEDICATED_ALLOCATION_SPEC_VERSION, "VK_NV_DEDICATED_ALLOCATION_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_transform_feedback
		swigIntConstant( VK_EXT_transform_feedback, "VK_EXT_transform_feedback" );
	#endif
	#ifdef VK_EXT_TRANSFORM_FEEDBACK_SPEC_VERSION
		swigIntConstant( VK_EXT_TRANSFORM_FEEDBACK_SPEC_VERSION, "VK_EXT_TRANSFORM_FEEDBACK_SPEC_VERSION" );
	#endif
	#ifdef VK_NVX_binary_import
		swigIntConstant( VK_NVX_binary_import, "VK_NVX_binary_import" );
	#endif
	#ifdef VK_NVX_BINARY_IMPORT_SPEC_VERSION
		swigIntConstant( VK_NVX_BINARY_IMPORT_SPEC_VERSION, "VK_NVX_BINARY_IMPORT_SPEC_VERSION" );
	#endif
	#ifdef VK_NVX_image_view_handle
		swigIntConstant( VK_NVX_image_view_handle, "VK_NVX_image_view_handle" );
	#endif
	#ifdef VK_NVX_IMAGE_VIEW_HANDLE_SPEC_VERSION
		swigIntConstant( VK_NVX_IMAGE_VIEW_HANDLE_SPEC_VERSION, "VK_NVX_IMAGE_VIEW_HANDLE_SPEC_VERSION" );
	#endif
	#ifdef VK_AMD_draw_indirect_count
		swigIntConstant( VK_AMD_draw_indirect_count, "VK_AMD_draw_indirect_count" );
	#endif
	#ifdef VK_AMD_DRAW_INDIRECT_COUNT_SPEC_VERSION
		swigIntConstant( VK_AMD_DRAW_INDIRECT_COUNT_SPEC_VERSION, "VK_AMD_DRAW_INDIRECT_COUNT_SPEC_VERSION" );
	#endif
	#ifdef VK_AMD_negative_viewport_height
		swigIntConstant( VK_AMD_negative_viewport_height, "VK_AMD_negative_viewport_height" );
	#endif
	#ifdef VK_AMD_NEGATIVE_VIEWPORT_HEIGHT_SPEC_VERSION
		swigIntConstant( VK_AMD_NEGATIVE_VIEWPORT_HEIGHT_SPEC_VERSION, "VK_AMD_NEGATIVE_VIEWPORT_HEIGHT_SPEC_VERSION" );
	#endif
	#ifdef VK_AMD_gpu_shader_half_float
		swigIntConstant( VK_AMD_gpu_shader_half_float, "VK_AMD_gpu_shader_half_float" );
	#endif
	#ifdef VK_AMD_GPU_SHADER_HALF_FLOAT_SPEC_VERSION
		swigIntConstant( VK_AMD_GPU_SHADER_HALF_FLOAT_SPEC_VERSION, "VK_AMD_GPU_SHADER_HALF_FLOAT_SPEC_VERSION" );
	#endif
	#ifdef VK_AMD_shader_ballot
		swigIntConstant( VK_AMD_shader_ballot, "VK_AMD_shader_ballot" );
	#endif
	#ifdef VK_AMD_SHADER_BALLOT_SPEC_VERSION
		swigIntConstant( VK_AMD_SHADER_BALLOT_SPEC_VERSION, "VK_AMD_SHADER_BALLOT_SPEC_VERSION" );
	#endif
	#ifdef VK_AMD_texture_gather_bias_lod
		swigIntConstant( VK_AMD_texture_gather_bias_lod, "VK_AMD_texture_gather_bias_lod" );
	#endif
	#ifdef VK_AMD_TEXTURE_GATHER_BIAS_LOD_SPEC_VERSION
		swigIntConstant( VK_AMD_TEXTURE_GATHER_BIAS_LOD_SPEC_VERSION, "VK_AMD_TEXTURE_GATHER_BIAS_LOD_SPEC_VERSION" );
	#endif
	#ifdef VK_AMD_shader_info
		swigIntConstant( VK_AMD_shader_info, "VK_AMD_shader_info" );
	#endif
	#ifdef VK_AMD_SHADER_INFO_SPEC_VERSION
		swigIntConstant( VK_AMD_SHADER_INFO_SPEC_VERSION, "VK_AMD_SHADER_INFO_SPEC_VERSION" );
	#endif
	#ifdef VK_AMD_shader_image_load_store_lod
		swigIntConstant( VK_AMD_shader_image_load_store_lod, "VK_AMD_shader_image_load_store_lod" );
	#endif
	#ifdef VK_AMD_SHADER_IMAGE_LOAD_STORE_LOD_SPEC_VERSION
		swigIntConstant( VK_AMD_SHADER_IMAGE_LOAD_STORE_LOD_SPEC_VERSION, "VK_AMD_SHADER_IMAGE_LOAD_STORE_LOD_SPEC_VERSION" );
	#endif
	#ifdef VK_NV_corner_sampled_image
		swigIntConstant( VK_NV_corner_sampled_image, "VK_NV_corner_sampled_image" );
	#endif
	#ifdef VK_NV_CORNER_SAMPLED_IMAGE_SPEC_VERSION
		swigIntConstant( VK_NV_CORNER_SAMPLED_IMAGE_SPEC_VERSION, "VK_NV_CORNER_SAMPLED_IMAGE_SPEC_VERSION" );
	#endif
	#ifdef VK_IMG_format_pvrtc
		swigIntConstant( VK_IMG_format_pvrtc, "VK_IMG_format_pvrtc" );
	#endif
	#ifdef VK_IMG_FORMAT_PVRTC_SPEC_VERSION
		swigIntConstant( VK_IMG_FORMAT_PVRTC_SPEC_VERSION, "VK_IMG_FORMAT_PVRTC_SPEC_VERSION" );
	#endif
	#ifdef VK_NV_external_memory_capabilities
		swigIntConstant( VK_NV_external_memory_capabilities, "VK_NV_external_memory_capabilities" );
	#endif
	#ifdef VK_NV_EXTERNAL_MEMORY_CAPABILITIES_SPEC_VERSION
		swigIntConstant( VK_NV_EXTERNAL_MEMORY_CAPABILITIES_SPEC_VERSION, "VK_NV_EXTERNAL_MEMORY_CAPABILITIES_SPEC_VERSION" );
	#endif
	#ifdef VK_NV_external_memory
		swigIntConstant( VK_NV_external_memory, "VK_NV_external_memory" );
	#endif
	#ifdef VK_NV_EXTERNAL_MEMORY_SPEC_VERSION
		swigIntConstant( VK_NV_EXTERNAL_MEMORY_SPEC_VERSION, "VK_NV_EXTERNAL_MEMORY_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_validation_flags
		swigIntConstant( VK_EXT_validation_flags, "VK_EXT_validation_flags" );
	#endif
	#ifdef VK_EXT_VALIDATION_FLAGS_SPEC_VERSION
		swigIntConstant( VK_EXT_VALIDATION_FLAGS_SPEC_VERSION, "VK_EXT_VALIDATION_FLAGS_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_shader_subgroup_ballot
		swigIntConstant( VK_EXT_shader_subgroup_ballot, "VK_EXT_shader_subgroup_ballot" );
	#endif
	#ifdef VK_EXT_SHADER_SUBGROUP_BALLOT_SPEC_VERSION
		swigIntConstant( VK_EXT_SHADER_SUBGROUP_BALLOT_SPEC_VERSION, "VK_EXT_SHADER_SUBGROUP_BALLOT_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_shader_subgroup_vote
		swigIntConstant( VK_EXT_shader_subgroup_vote, "VK_EXT_shader_subgroup_vote" );
	#endif
	#ifdef VK_EXT_SHADER_SUBGROUP_VOTE_SPEC_VERSION
		swigIntConstant( VK_EXT_SHADER_SUBGROUP_VOTE_SPEC_VERSION, "VK_EXT_SHADER_SUBGROUP_VOTE_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_texture_compression_astc_hdr
		swigIntConstant( VK_EXT_texture_compression_astc_hdr, "VK_EXT_texture_compression_astc_hdr" );
	#endif
	#ifdef VK_EXT_TEXTURE_COMPRESSION_ASTC_HDR_SPEC_VERSION
		swigIntConstant( VK_EXT_TEXTURE_COMPRESSION_ASTC_HDR_SPEC_VERSION, "VK_EXT_TEXTURE_COMPRESSION_ASTC_HDR_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_astc_decode_mode
		swigIntConstant( VK_EXT_astc_decode_mode, "VK_EXT_astc_decode_mode" );
	#endif
	#ifdef VK_EXT_ASTC_DECODE_MODE_SPEC_VERSION
		swigIntConstant( VK_EXT_ASTC_DECODE_MODE_SPEC_VERSION, "VK_EXT_ASTC_DECODE_MODE_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_conditional_rendering
		swigIntConstant( VK_EXT_conditional_rendering, "VK_EXT_conditional_rendering" );
	#endif
	#ifdef VK_EXT_CONDITIONAL_RENDERING_SPEC_VERSION
		swigIntConstant( VK_EXT_CONDITIONAL_RENDERING_SPEC_VERSION, "VK_EXT_CONDITIONAL_RENDERING_SPEC_VERSION" );
	#endif
	#ifdef VK_NV_clip_space_w_scaling
		swigIntConstant( VK_NV_clip_space_w_scaling, "VK_NV_clip_space_w_scaling" );
	#endif
	#ifdef VK_NV_CLIP_SPACE_W_SCALING_SPEC_VERSION
		swigIntConstant( VK_NV_CLIP_SPACE_W_SCALING_SPEC_VERSION, "VK_NV_CLIP_SPACE_W_SCALING_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_direct_mode_display
		swigIntConstant( VK_EXT_direct_mode_display, "VK_EXT_direct_mode_display" );
	#endif
	#ifdef VK_EXT_DIRECT_MODE_DISPLAY_SPEC_VERSION
		swigIntConstant( VK_EXT_DIRECT_MODE_DISPLAY_SPEC_VERSION, "VK_EXT_DIRECT_MODE_DISPLAY_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_display_surface_counter
		swigIntConstant( VK_EXT_display_surface_counter, "VK_EXT_display_surface_counter" );
	#endif
	#ifdef VK_EXT_DISPLAY_SURFACE_COUNTER_SPEC_VERSION
		swigIntConstant( VK_EXT_DISPLAY_SURFACE_COUNTER_SPEC_VERSION, "VK_EXT_DISPLAY_SURFACE_COUNTER_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_display_control
		swigIntConstant( VK_EXT_display_control, "VK_EXT_display_control" );
	#endif
	#ifdef VK_EXT_DISPLAY_CONTROL_SPEC_VERSION
		swigIntConstant( VK_EXT_DISPLAY_CONTROL_SPEC_VERSION, "VK_EXT_DISPLAY_CONTROL_SPEC_VERSION" );
	#endif
	#ifdef VK_GOOGLE_display_timing
		swigIntConstant( VK_GOOGLE_display_timing, "VK_GOOGLE_display_timing" );
	#endif
	#ifdef VK_GOOGLE_DISPLAY_TIMING_SPEC_VERSION
		swigIntConstant( VK_GOOGLE_DISPLAY_TIMING_SPEC_VERSION, "VK_GOOGLE_DISPLAY_TIMING_SPEC_VERSION" );
	#endif
	#ifdef VK_NV_sample_mask_override_coverage
		swigIntConstant( VK_NV_sample_mask_override_coverage, "VK_NV_sample_mask_override_coverage" );
	#endif
	#ifdef VK_NV_SAMPLE_MASK_OVERRIDE_COVERAGE_SPEC_VERSION
		swigIntConstant( VK_NV_SAMPLE_MASK_OVERRIDE_COVERAGE_SPEC_VERSION, "VK_NV_SAMPLE_MASK_OVERRIDE_COVERAGE_SPEC_VERSION" );
	#endif
	#ifdef VK_NV_geometry_shader_passthrough
		swigIntConstant( VK_NV_geometry_shader_passthrough, "VK_NV_geometry_shader_passthrough" );
	#endif
	#ifdef VK_NV_GEOMETRY_SHADER_PASSTHROUGH_SPEC_VERSION
		swigIntConstant( VK_NV_GEOMETRY_SHADER_PASSTHROUGH_SPEC_VERSION, "VK_NV_GEOMETRY_SHADER_PASSTHROUGH_SPEC_VERSION" );
	#endif
	#ifdef VK_NV_viewport_array2
		swigIntConstant( VK_NV_viewport_array2, "VK_NV_viewport_array2" );
	#endif
	#ifdef VK_NV_VIEWPORT_ARRAY_2_SPEC_VERSION
		swigIntConstant( VK_NV_VIEWPORT_ARRAY_2_SPEC_VERSION, "VK_NV_VIEWPORT_ARRAY_2_SPEC_VERSION" );
	#endif
	#ifdef VK_NV_VIEWPORT_ARRAY2_SPEC_VERSION
		swigIntConstant( VK_NV_VIEWPORT_ARRAY2_SPEC_VERSION, "VK_NV_VIEWPORT_ARRAY2_SPEC_VERSION" );
	#endif
	#ifdef VK_NVX_multiview_per_view_attributes
		swigIntConstant( VK_NVX_multiview_per_view_attributes, "VK_NVX_multiview_per_view_attributes" );
	#endif
	#ifdef VK_NVX_MULTIVIEW_PER_VIEW_ATTRIBUTES_SPEC_VERSION
		swigIntConstant( VK_NVX_MULTIVIEW_PER_VIEW_ATTRIBUTES_SPEC_VERSION, "VK_NVX_MULTIVIEW_PER_VIEW_ATTRIBUTES_SPEC_VERSION" );
	#endif
	#ifdef VK_NV_viewport_swizzle
		swigIntConstant( VK_NV_viewport_swizzle, "VK_NV_viewport_swizzle" );
	#endif
	#ifdef VK_NV_VIEWPORT_SWIZZLE_SPEC_VERSION
		swigIntConstant( VK_NV_VIEWPORT_SWIZZLE_SPEC_VERSION, "VK_NV_VIEWPORT_SWIZZLE_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_discard_rectangles
		swigIntConstant( VK_EXT_discard_rectangles, "VK_EXT_discard_rectangles" );
	#endif
	#ifdef VK_EXT_DISCARD_RECTANGLES_SPEC_VERSION
		swigIntConstant( VK_EXT_DISCARD_RECTANGLES_SPEC_VERSION, "VK_EXT_DISCARD_RECTANGLES_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_conservative_rasterization
		swigIntConstant( VK_EXT_conservative_rasterization, "VK_EXT_conservative_rasterization" );
	#endif
	#ifdef VK_EXT_CONSERVATIVE_RASTERIZATION_SPEC_VERSION
		swigIntConstant( VK_EXT_CONSERVATIVE_RASTERIZATION_SPEC_VERSION, "VK_EXT_CONSERVATIVE_RASTERIZATION_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_depth_clip_enable
		swigIntConstant( VK_EXT_depth_clip_enable, "VK_EXT_depth_clip_enable" );
	#endif
	#ifdef VK_EXT_DEPTH_CLIP_ENABLE_SPEC_VERSION
		swigIntConstant( VK_EXT_DEPTH_CLIP_ENABLE_SPEC_VERSION, "VK_EXT_DEPTH_CLIP_ENABLE_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_swapchain_colorspace
		swigIntConstant( VK_EXT_swapchain_colorspace, "VK_EXT_swapchain_colorspace" );
	#endif
	#ifdef VK_EXT_SWAPCHAIN_COLOR_SPACE_SPEC_VERSION
		swigIntConstant( VK_EXT_SWAPCHAIN_COLOR_SPACE_SPEC_VERSION, "VK_EXT_SWAPCHAIN_COLOR_SPACE_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_hdr_metadata
		swigIntConstant( VK_EXT_hdr_metadata, "VK_EXT_hdr_metadata" );
	#endif
	#ifdef VK_EXT_HDR_METADATA_SPEC_VERSION
		swigIntConstant( VK_EXT_HDR_METADATA_SPEC_VERSION, "VK_EXT_HDR_METADATA_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_external_memory_dma_buf
		swigIntConstant( VK_EXT_external_memory_dma_buf, "VK_EXT_external_memory_dma_buf" );
	#endif
	#ifdef VK_EXT_EXTERNAL_MEMORY_DMA_BUF_SPEC_VERSION
		swigIntConstant( VK_EXT_EXTERNAL_MEMORY_DMA_BUF_SPEC_VERSION, "VK_EXT_EXTERNAL_MEMORY_DMA_BUF_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_queue_family_foreign
		swigIntConstant( VK_EXT_queue_family_foreign, "VK_EXT_queue_family_foreign" );
	#endif
	#ifdef VK_EXT_QUEUE_FAMILY_FOREIGN_SPEC_VERSION
		swigIntConstant( VK_EXT_QUEUE_FAMILY_FOREIGN_SPEC_VERSION, "VK_EXT_QUEUE_FAMILY_FOREIGN_SPEC_VERSION" );
	#endif
	#ifdef VK_QUEUE_FAMILY_FOREIGN_EXT
		swigUnsignedIntConstant( VK_QUEUE_FAMILY_FOREIGN_EXT, "VK_QUEUE_FAMILY_FOREIGN_EXT" );
	#endif
	#ifdef VK_EXT_debug_utils
		swigIntConstant( VK_EXT_debug_utils, "VK_EXT_debug_utils" );
	#endif
	#ifdef VK_EXT_DEBUG_UTILS_SPEC_VERSION
		swigIntConstant( VK_EXT_DEBUG_UTILS_SPEC_VERSION, "VK_EXT_DEBUG_UTILS_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_sampler_filter_minmax
		swigIntConstant( VK_EXT_sampler_filter_minmax, "VK_EXT_sampler_filter_minmax" );
	#endif
	#ifdef VK_EXT_SAMPLER_FILTER_MINMAX_SPEC_VERSION
		swigIntConstant( VK_EXT_SAMPLER_FILTER_MINMAX_SPEC_VERSION, "VK_EXT_SAMPLER_FILTER_MINMAX_SPEC_VERSION" );
	#endif
	#ifdef VK_AMD_gpu_shader_int16
		swigIntConstant( VK_AMD_gpu_shader_int16, "VK_AMD_gpu_shader_int16" );
	#endif
	#ifdef VK_AMD_GPU_SHADER_INT16_SPEC_VERSION
		swigIntConstant( VK_AMD_GPU_SHADER_INT16_SPEC_VERSION, "VK_AMD_GPU_SHADER_INT16_SPEC_VERSION" );
	#endif
	#ifdef VK_AMD_mixed_attachment_samples
		swigIntConstant( VK_AMD_mixed_attachment_samples, "VK_AMD_mixed_attachment_samples" );
	#endif
	#ifdef VK_AMD_MIXED_ATTACHMENT_SAMPLES_SPEC_VERSION
		swigIntConstant( VK_AMD_MIXED_ATTACHMENT_SAMPLES_SPEC_VERSION, "VK_AMD_MIXED_ATTACHMENT_SAMPLES_SPEC_VERSION" );
	#endif
	#ifdef VK_AMD_shader_fragment_mask
		swigIntConstant( VK_AMD_shader_fragment_mask, "VK_AMD_shader_fragment_mask" );
	#endif
	#ifdef VK_AMD_SHADER_FRAGMENT_MASK_SPEC_VERSION
		swigIntConstant( VK_AMD_SHADER_FRAGMENT_MASK_SPEC_VERSION, "VK_AMD_SHADER_FRAGMENT_MASK_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_inline_uniform_block
		swigIntConstant( VK_EXT_inline_uniform_block, "VK_EXT_inline_uniform_block" );
	#endif
	#ifdef VK_EXT_INLINE_UNIFORM_BLOCK_SPEC_VERSION
		swigIntConstant( VK_EXT_INLINE_UNIFORM_BLOCK_SPEC_VERSION, "VK_EXT_INLINE_UNIFORM_BLOCK_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_shader_stencil_export
		swigIntConstant( VK_EXT_shader_stencil_export, "VK_EXT_shader_stencil_export" );
	#endif
	#ifdef VK_EXT_SHADER_STENCIL_EXPORT_SPEC_VERSION
		swigIntConstant( VK_EXT_SHADER_STENCIL_EXPORT_SPEC_VERSION, "VK_EXT_SHADER_STENCIL_EXPORT_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_sample_locations
		swigIntConstant( VK_EXT_sample_locations, "VK_EXT_sample_locations" );
	#endif
	#ifdef VK_EXT_SAMPLE_LOCATIONS_SPEC_VERSION
		swigIntConstant( VK_EXT_SAMPLE_LOCATIONS_SPEC_VERSION, "VK_EXT_SAMPLE_LOCATIONS_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_blend_operation_advanced
		swigIntConstant( VK_EXT_blend_operation_advanced, "VK_EXT_blend_operation_advanced" );
	#endif
	#ifdef VK_EXT_BLEND_OPERATION_ADVANCED_SPEC_VERSION
		swigIntConstant( VK_EXT_BLEND_OPERATION_ADVANCED_SPEC_VERSION, "VK_EXT_BLEND_OPERATION_ADVANCED_SPEC_VERSION" );
	#endif
	#ifdef VK_NV_fragment_coverage_to_color
		swigIntConstant( VK_NV_fragment_coverage_to_color, "VK_NV_fragment_coverage_to_color" );
	#endif
	#ifdef VK_NV_FRAGMENT_COVERAGE_TO_COLOR_SPEC_VERSION
		swigIntConstant( VK_NV_FRAGMENT_COVERAGE_TO_COLOR_SPEC_VERSION, "VK_NV_FRAGMENT_COVERAGE_TO_COLOR_SPEC_VERSION" );
	#endif
	#ifdef VK_NV_framebuffer_mixed_samples
		swigIntConstant( VK_NV_framebuffer_mixed_samples, "VK_NV_framebuffer_mixed_samples" );
	#endif
	#ifdef VK_NV_FRAMEBUFFER_MIXED_SAMPLES_SPEC_VERSION
		swigIntConstant( VK_NV_FRAMEBUFFER_MIXED_SAMPLES_SPEC_VERSION, "VK_NV_FRAMEBUFFER_MIXED_SAMPLES_SPEC_VERSION" );
	#endif
	#ifdef VK_NV_fill_rectangle
		swigIntConstant( VK_NV_fill_rectangle, "VK_NV_fill_rectangle" );
	#endif
	#ifdef VK_NV_FILL_RECTANGLE_SPEC_VERSION
		swigIntConstant( VK_NV_FILL_RECTANGLE_SPEC_VERSION, "VK_NV_FILL_RECTANGLE_SPEC_VERSION" );
	#endif
	#ifdef VK_NV_shader_sm_builtins
		swigIntConstant( VK_NV_shader_sm_builtins, "VK_NV_shader_sm_builtins" );
	#endif
	#ifdef VK_NV_SHADER_SM_BUILTINS_SPEC_VERSION
		swigIntConstant( VK_NV_SHADER_SM_BUILTINS_SPEC_VERSION, "VK_NV_SHADER_SM_BUILTINS_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_post_depth_coverage
		swigIntConstant( VK_EXT_post_depth_coverage, "VK_EXT_post_depth_coverage" );
	#endif
	#ifdef VK_EXT_POST_DEPTH_COVERAGE_SPEC_VERSION
		swigIntConstant( VK_EXT_POST_DEPTH_COVERAGE_SPEC_VERSION, "VK_EXT_POST_DEPTH_COVERAGE_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_image_drm_format_modifier
		swigIntConstant( VK_EXT_image_drm_format_modifier, "VK_EXT_image_drm_format_modifier" );
	#endif
	#ifdef VK_EXT_IMAGE_DRM_FORMAT_MODIFIER_SPEC_VERSION
		swigIntConstant( VK_EXT_IMAGE_DRM_FORMAT_MODIFIER_SPEC_VERSION, "VK_EXT_IMAGE_DRM_FORMAT_MODIFIER_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_validation_cache
		swigIntConstant( VK_EXT_validation_cache, "VK_EXT_validation_cache" );
	#endif
	#ifdef VK_EXT_VALIDATION_CACHE_SPEC_VERSION
		swigIntConstant( VK_EXT_VALIDATION_CACHE_SPEC_VERSION, "VK_EXT_VALIDATION_CACHE_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_descriptor_indexing
		swigIntConstant( VK_EXT_descriptor_indexing, "VK_EXT_descriptor_indexing" );
	#endif
	#ifdef VK_EXT_DESCRIPTOR_INDEXING_SPEC_VERSION
		swigIntConstant( VK_EXT_DESCRIPTOR_INDEXING_SPEC_VERSION, "VK_EXT_DESCRIPTOR_INDEXING_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_shader_viewport_index_layer
		swigIntConstant( VK_EXT_shader_viewport_index_layer, "VK_EXT_shader_viewport_index_layer" );
	#endif
	#ifdef VK_EXT_SHADER_VIEWPORT_INDEX_LAYER_SPEC_VERSION
		swigIntConstant( VK_EXT_SHADER_VIEWPORT_INDEX_LAYER_SPEC_VERSION, "VK_EXT_SHADER_VIEWPORT_INDEX_LAYER_SPEC_VERSION" );
	#endif
	#ifdef VK_NV_shading_rate_image
		swigIntConstant( VK_NV_shading_rate_image, "VK_NV_shading_rate_image" );
	#endif
	#ifdef VK_NV_SHADING_RATE_IMAGE_SPEC_VERSION
		swigIntConstant( VK_NV_SHADING_RATE_IMAGE_SPEC_VERSION, "VK_NV_SHADING_RATE_IMAGE_SPEC_VERSION" );
	#endif
	#ifdef VK_NV_ray_tracing
		swigIntConstant( VK_NV_ray_tracing, "VK_NV_ray_tracing" );
	#endif
	#ifdef VK_NV_RAY_TRACING_SPEC_VERSION
		swigIntConstant( VK_NV_RAY_TRACING_SPEC_VERSION, "VK_NV_RAY_TRACING_SPEC_VERSION" );
	#endif
	#ifdef VK_SHADER_UNUSED_KHR
		swigUnsignedIntConstant( VK_SHADER_UNUSED_KHR, "VK_SHADER_UNUSED_KHR" );
	#endif
	#ifdef VK_SHADER_UNUSED_NV
		swigUnsignedIntConstant( VK_SHADER_UNUSED_NV, "VK_SHADER_UNUSED_NV" );
	#endif
	#ifdef VK_NV_representative_fragment_test
		swigIntConstant( VK_NV_representative_fragment_test, "VK_NV_representative_fragment_test" );
	#endif
	#ifdef VK_NV_REPRESENTATIVE_FRAGMENT_TEST_SPEC_VERSION
		swigIntConstant( VK_NV_REPRESENTATIVE_FRAGMENT_TEST_SPEC_VERSION, "VK_NV_REPRESENTATIVE_FRAGMENT_TEST_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_filter_cubic
		swigIntConstant( VK_EXT_filter_cubic, "VK_EXT_filter_cubic" );
	#endif
	#ifdef VK_EXT_FILTER_CUBIC_SPEC_VERSION
		swigIntConstant( VK_EXT_FILTER_CUBIC_SPEC_VERSION, "VK_EXT_FILTER_CUBIC_SPEC_VERSION" );
	#endif
	#ifdef VK_QCOM_render_pass_shader_resolve
		swigIntConstant( VK_QCOM_render_pass_shader_resolve, "VK_QCOM_render_pass_shader_resolve" );
	#endif
	#ifdef VK_QCOM_RENDER_PASS_SHADER_RESOLVE_SPEC_VERSION
		swigIntConstant( VK_QCOM_RENDER_PASS_SHADER_RESOLVE_SPEC_VERSION, "VK_QCOM_RENDER_PASS_SHADER_RESOLVE_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_global_priority
		swigIntConstant( VK_EXT_global_priority, "VK_EXT_global_priority" );
	#endif
	#ifdef VK_EXT_GLOBAL_PRIORITY_SPEC_VERSION
		swigIntConstant( VK_EXT_GLOBAL_PRIORITY_SPEC_VERSION, "VK_EXT_GLOBAL_PRIORITY_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_external_memory_host
		swigIntConstant( VK_EXT_external_memory_host, "VK_EXT_external_memory_host" );
	#endif
	#ifdef VK_EXT_EXTERNAL_MEMORY_HOST_SPEC_VERSION
		swigIntConstant( VK_EXT_EXTERNAL_MEMORY_HOST_SPEC_VERSION, "VK_EXT_EXTERNAL_MEMORY_HOST_SPEC_VERSION" );
	#endif
	#ifdef VK_AMD_buffer_marker
		swigIntConstant( VK_AMD_buffer_marker, "VK_AMD_buffer_marker" );
	#endif
	#ifdef VK_AMD_BUFFER_MARKER_SPEC_VERSION
		swigIntConstant( VK_AMD_BUFFER_MARKER_SPEC_VERSION, "VK_AMD_BUFFER_MARKER_SPEC_VERSION" );
	#endif
	#ifdef VK_AMD_pipeline_compiler_control
		swigIntConstant( VK_AMD_pipeline_compiler_control, "VK_AMD_pipeline_compiler_control" );
	#endif
	#ifdef VK_AMD_PIPELINE_COMPILER_CONTROL_SPEC_VERSION
		swigIntConstant( VK_AMD_PIPELINE_COMPILER_CONTROL_SPEC_VERSION, "VK_AMD_PIPELINE_COMPILER_CONTROL_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_calibrated_timestamps
		swigIntConstant( VK_EXT_calibrated_timestamps, "VK_EXT_calibrated_timestamps" );
	#endif
	#ifdef VK_EXT_CALIBRATED_TIMESTAMPS_SPEC_VERSION
		swigIntConstant( VK_EXT_CALIBRATED_TIMESTAMPS_SPEC_VERSION, "VK_EXT_CALIBRATED_TIMESTAMPS_SPEC_VERSION" );
	#endif
	#ifdef VK_AMD_shader_core_properties
		swigIntConstant( VK_AMD_shader_core_properties, "VK_AMD_shader_core_properties" );
	#endif
	#ifdef VK_AMD_SHADER_CORE_PROPERTIES_SPEC_VERSION
		swigIntConstant( VK_AMD_SHADER_CORE_PROPERTIES_SPEC_VERSION, "VK_AMD_SHADER_CORE_PROPERTIES_SPEC_VERSION" );
	#endif
	#ifdef VK_AMD_memory_overallocation_behavior
		swigIntConstant( VK_AMD_memory_overallocation_behavior, "VK_AMD_memory_overallocation_behavior" );
	#endif
	#ifdef VK_AMD_MEMORY_OVERALLOCATION_BEHAVIOR_SPEC_VERSION
		swigIntConstant( VK_AMD_MEMORY_OVERALLOCATION_BEHAVIOR_SPEC_VERSION, "VK_AMD_MEMORY_OVERALLOCATION_BEHAVIOR_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_vertex_attribute_divisor
		swigIntConstant( VK_EXT_vertex_attribute_divisor, "VK_EXT_vertex_attribute_divisor" );
	#endif
	#ifdef VK_EXT_VERTEX_ATTRIBUTE_DIVISOR_SPEC_VERSION
		swigIntConstant( VK_EXT_VERTEX_ATTRIBUTE_DIVISOR_SPEC_VERSION, "VK_EXT_VERTEX_ATTRIBUTE_DIVISOR_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_pipeline_creation_feedback
		swigIntConstant( VK_EXT_pipeline_creation_feedback, "VK_EXT_pipeline_creation_feedback" );
	#endif
	#ifdef VK_EXT_PIPELINE_CREATION_FEEDBACK_SPEC_VERSION
		swigIntConstant( VK_EXT_PIPELINE_CREATION_FEEDBACK_SPEC_VERSION, "VK_EXT_PIPELINE_CREATION_FEEDBACK_SPEC_VERSION" );
	#endif
	#ifdef VK_NV_shader_subgroup_partitioned
		swigIntConstant( VK_NV_shader_subgroup_partitioned, "VK_NV_shader_subgroup_partitioned" );
	#endif
	#ifdef VK_NV_SHADER_SUBGROUP_PARTITIONED_SPEC_VERSION
		swigIntConstant( VK_NV_SHADER_SUBGROUP_PARTITIONED_SPEC_VERSION, "VK_NV_SHADER_SUBGROUP_PARTITIONED_SPEC_VERSION" );
	#endif
	#ifdef VK_NV_compute_shader_derivatives
		swigIntConstant( VK_NV_compute_shader_derivatives, "VK_NV_compute_shader_derivatives" );
	#endif
	#ifdef VK_NV_COMPUTE_SHADER_DERIVATIVES_SPEC_VERSION
		swigIntConstant( VK_NV_COMPUTE_SHADER_DERIVATIVES_SPEC_VERSION, "VK_NV_COMPUTE_SHADER_DERIVATIVES_SPEC_VERSION" );
	#endif
	#ifdef VK_NV_mesh_shader
		swigIntConstant( VK_NV_mesh_shader, "VK_NV_mesh_shader" );
	#endif
	#ifdef VK_NV_MESH_SHADER_SPEC_VERSION
		swigIntConstant( VK_NV_MESH_SHADER_SPEC_VERSION, "VK_NV_MESH_SHADER_SPEC_VERSION" );
	#endif
	#ifdef VK_NV_fragment_shader_barycentric
		swigIntConstant( VK_NV_fragment_shader_barycentric, "VK_NV_fragment_shader_barycentric" );
	#endif
	#ifdef VK_NV_FRAGMENT_SHADER_BARYCENTRIC_SPEC_VERSION
		swigIntConstant( VK_NV_FRAGMENT_SHADER_BARYCENTRIC_SPEC_VERSION, "VK_NV_FRAGMENT_SHADER_BARYCENTRIC_SPEC_VERSION" );
	#endif
	#ifdef VK_NV_shader_image_footprint
		swigIntConstant( VK_NV_shader_image_footprint, "VK_NV_shader_image_footprint" );
	#endif
	#ifdef VK_NV_SHADER_IMAGE_FOOTPRINT_SPEC_VERSION
		swigIntConstant( VK_NV_SHADER_IMAGE_FOOTPRINT_SPEC_VERSION, "VK_NV_SHADER_IMAGE_FOOTPRINT_SPEC_VERSION" );
	#endif
	#ifdef VK_NV_scissor_exclusive
		swigIntConstant( VK_NV_scissor_exclusive, "VK_NV_scissor_exclusive" );
	#endif
	#ifdef VK_NV_SCISSOR_EXCLUSIVE_SPEC_VERSION
		swigIntConstant( VK_NV_SCISSOR_EXCLUSIVE_SPEC_VERSION, "VK_NV_SCISSOR_EXCLUSIVE_SPEC_VERSION" );
	#endif
	#ifdef VK_NV_device_diagnostic_checkpoints
		swigIntConstant( VK_NV_device_diagnostic_checkpoints, "VK_NV_device_diagnostic_checkpoints" );
	#endif
	#ifdef VK_NV_DEVICE_DIAGNOSTIC_CHECKPOINTS_SPEC_VERSION
		swigIntConstant( VK_NV_DEVICE_DIAGNOSTIC_CHECKPOINTS_SPEC_VERSION, "VK_NV_DEVICE_DIAGNOSTIC_CHECKPOINTS_SPEC_VERSION" );
	#endif
	#ifdef VK_INTEL_shader_integer_functions2
		swigIntConstant( VK_INTEL_shader_integer_functions2, "VK_INTEL_shader_integer_functions2" );
	#endif
	#ifdef VK_INTEL_SHADER_INTEGER_FUNCTIONS_2_SPEC_VERSION
		swigIntConstant( VK_INTEL_SHADER_INTEGER_FUNCTIONS_2_SPEC_VERSION, "VK_INTEL_SHADER_INTEGER_FUNCTIONS_2_SPEC_VERSION" );
	#endif
	#ifdef VK_INTEL_performance_query
		swigIntConstant( VK_INTEL_performance_query, "VK_INTEL_performance_query" );
	#endif
	#ifdef VK_INTEL_PERFORMANCE_QUERY_SPEC_VERSION
		swigIntConstant( VK_INTEL_PERFORMANCE_QUERY_SPEC_VERSION, "VK_INTEL_PERFORMANCE_QUERY_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_pci_bus_info
		swigIntConstant( VK_EXT_pci_bus_info, "VK_EXT_pci_bus_info" );
	#endif
	#ifdef VK_EXT_PCI_BUS_INFO_SPEC_VERSION
		swigIntConstant( VK_EXT_PCI_BUS_INFO_SPEC_VERSION, "VK_EXT_PCI_BUS_INFO_SPEC_VERSION" );
	#endif
	#ifdef VK_AMD_display_native_hdr
		swigIntConstant( VK_AMD_display_native_hdr, "VK_AMD_display_native_hdr" );
	#endif
	#ifdef VK_AMD_DISPLAY_NATIVE_HDR_SPEC_VERSION
		swigIntConstant( VK_AMD_DISPLAY_NATIVE_HDR_SPEC_VERSION, "VK_AMD_DISPLAY_NATIVE_HDR_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_fragment_density_map
		swigIntConstant( VK_EXT_fragment_density_map, "VK_EXT_fragment_density_map" );
	#endif
	#ifdef VK_EXT_FRAGMENT_DENSITY_MAP_SPEC_VERSION
		swigIntConstant( VK_EXT_FRAGMENT_DENSITY_MAP_SPEC_VERSION, "VK_EXT_FRAGMENT_DENSITY_MAP_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_scalar_block_layout
		swigIntConstant( VK_EXT_scalar_block_layout, "VK_EXT_scalar_block_layout" );
	#endif
	#ifdef VK_EXT_SCALAR_BLOCK_LAYOUT_SPEC_VERSION
		swigIntConstant( VK_EXT_SCALAR_BLOCK_LAYOUT_SPEC_VERSION, "VK_EXT_SCALAR_BLOCK_LAYOUT_SPEC_VERSION" );
	#endif
	#ifdef VK_GOOGLE_hlsl_functionality1
		swigIntConstant( VK_GOOGLE_hlsl_functionality1, "VK_GOOGLE_hlsl_functionality1" );
	#endif
	#ifdef VK_GOOGLE_HLSL_FUNCTIONALITY_1_SPEC_VERSION
		swigIntConstant( VK_GOOGLE_HLSL_FUNCTIONALITY_1_SPEC_VERSION, "VK_GOOGLE_HLSL_FUNCTIONALITY_1_SPEC_VERSION" );
	#endif
	#ifdef VK_GOOGLE_HLSL_FUNCTIONALITY1_SPEC_VERSION
		swigIntConstant( VK_GOOGLE_HLSL_FUNCTIONALITY1_SPEC_VERSION, "VK_GOOGLE_HLSL_FUNCTIONALITY1_SPEC_VERSION" );
	#endif
	#ifdef VK_GOOGLE_decorate_string
		swigIntConstant( VK_GOOGLE_decorate_string, "VK_GOOGLE_decorate_string" );
	#endif
	#ifdef VK_GOOGLE_DECORATE_STRING_SPEC_VERSION
		swigIntConstant( VK_GOOGLE_DECORATE_STRING_SPEC_VERSION, "VK_GOOGLE_DECORATE_STRING_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_subgroup_size_control
		swigIntConstant( VK_EXT_subgroup_size_control, "VK_EXT_subgroup_size_control" );
	#endif
	#ifdef VK_EXT_SUBGROUP_SIZE_CONTROL_SPEC_VERSION
		swigIntConstant( VK_EXT_SUBGROUP_SIZE_CONTROL_SPEC_VERSION, "VK_EXT_SUBGROUP_SIZE_CONTROL_SPEC_VERSION" );
	#endif
	#ifdef VK_AMD_shader_core_properties2
		swigIntConstant( VK_AMD_shader_core_properties2, "VK_AMD_shader_core_properties2" );
	#endif
	#ifdef VK_AMD_SHADER_CORE_PROPERTIES_2_SPEC_VERSION
		swigIntConstant( VK_AMD_SHADER_CORE_PROPERTIES_2_SPEC_VERSION, "VK_AMD_SHADER_CORE_PROPERTIES_2_SPEC_VERSION" );
	#endif
	#ifdef VK_AMD_device_coherent_memory
		swigIntConstant( VK_AMD_device_coherent_memory, "VK_AMD_device_coherent_memory" );
	#endif
	#ifdef VK_AMD_DEVICE_COHERENT_MEMORY_SPEC_VERSION
		swigIntConstant( VK_AMD_DEVICE_COHERENT_MEMORY_SPEC_VERSION, "VK_AMD_DEVICE_COHERENT_MEMORY_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_shader_image_atomic_int64
		swigIntConstant( VK_EXT_shader_image_atomic_int64, "VK_EXT_shader_image_atomic_int64" );
	#endif
	#ifdef VK_EXT_SHADER_IMAGE_ATOMIC_INT64_SPEC_VERSION
		swigIntConstant( VK_EXT_SHADER_IMAGE_ATOMIC_INT64_SPEC_VERSION, "VK_EXT_SHADER_IMAGE_ATOMIC_INT64_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_memory_budget
		swigIntConstant( VK_EXT_memory_budget, "VK_EXT_memory_budget" );
	#endif
	#ifdef VK_EXT_MEMORY_BUDGET_SPEC_VERSION
		swigIntConstant( VK_EXT_MEMORY_BUDGET_SPEC_VERSION, "VK_EXT_MEMORY_BUDGET_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_memory_priority
		swigIntConstant( VK_EXT_memory_priority, "VK_EXT_memory_priority" );
	#endif
	#ifdef VK_EXT_MEMORY_PRIORITY_SPEC_VERSION
		swigIntConstant( VK_EXT_MEMORY_PRIORITY_SPEC_VERSION, "VK_EXT_MEMORY_PRIORITY_SPEC_VERSION" );
	#endif
	#ifdef VK_NV_dedicated_allocation_image_aliasing
		swigIntConstant( VK_NV_dedicated_allocation_image_aliasing, "VK_NV_dedicated_allocation_image_aliasing" );
	#endif
	#ifdef VK_NV_DEDICATED_ALLOCATION_IMAGE_ALIASING_SPEC_VERSION
		swigIntConstant( VK_NV_DEDICATED_ALLOCATION_IMAGE_ALIASING_SPEC_VERSION, "VK_NV_DEDICATED_ALLOCATION_IMAGE_ALIASING_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_buffer_device_address
		swigIntConstant( VK_EXT_buffer_device_address, "VK_EXT_buffer_device_address" );
	#endif
	#ifdef VK_EXT_BUFFER_DEVICE_ADDRESS_SPEC_VERSION
		swigIntConstant( VK_EXT_BUFFER_DEVICE_ADDRESS_SPEC_VERSION, "VK_EXT_BUFFER_DEVICE_ADDRESS_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_tooling_info
		swigIntConstant( VK_EXT_tooling_info, "VK_EXT_tooling_info" );
	#endif
	#ifdef VK_EXT_TOOLING_INFO_SPEC_VERSION
		swigIntConstant( VK_EXT_TOOLING_INFO_SPEC_VERSION, "VK_EXT_TOOLING_INFO_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_separate_stencil_usage
		swigIntConstant( VK_EXT_separate_stencil_usage, "VK_EXT_separate_stencil_usage" );
	#endif
	#ifdef VK_EXT_SEPARATE_STENCIL_USAGE_SPEC_VERSION
		swigIntConstant( VK_EXT_SEPARATE_STENCIL_USAGE_SPEC_VERSION, "VK_EXT_SEPARATE_STENCIL_USAGE_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_validation_features
		swigIntConstant( VK_EXT_validation_features, "VK_EXT_validation_features" );
	#endif
	#ifdef VK_EXT_VALIDATION_FEATURES_SPEC_VERSION
		swigIntConstant( VK_EXT_VALIDATION_FEATURES_SPEC_VERSION, "VK_EXT_VALIDATION_FEATURES_SPEC_VERSION" );
	#endif
	#ifdef VK_NV_cooperative_matrix
		swigIntConstant( VK_NV_cooperative_matrix, "VK_NV_cooperative_matrix" );
	#endif
	#ifdef VK_NV_COOPERATIVE_MATRIX_SPEC_VERSION
		swigIntConstant( VK_NV_COOPERATIVE_MATRIX_SPEC_VERSION, "VK_NV_COOPERATIVE_MATRIX_SPEC_VERSION" );
	#endif
	#ifdef VK_NV_coverage_reduction_mode
		swigIntConstant( VK_NV_coverage_reduction_mode, "VK_NV_coverage_reduction_mode" );
	#endif
	#ifdef VK_NV_COVERAGE_REDUCTION_MODE_SPEC_VERSION
		swigIntConstant( VK_NV_COVERAGE_REDUCTION_MODE_SPEC_VERSION, "VK_NV_COVERAGE_REDUCTION_MODE_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_fragment_shader_interlock
		swigIntConstant( VK_EXT_fragment_shader_interlock, "VK_EXT_fragment_shader_interlock" );
	#endif
	#ifdef VK_EXT_FRAGMENT_SHADER_INTERLOCK_SPEC_VERSION
		swigIntConstant( VK_EXT_FRAGMENT_SHADER_INTERLOCK_SPEC_VERSION, "VK_EXT_FRAGMENT_SHADER_INTERLOCK_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_ycbcr_image_arrays
		swigIntConstant( VK_EXT_ycbcr_image_arrays, "VK_EXT_ycbcr_image_arrays" );
	#endif
	#ifdef VK_EXT_YCBCR_IMAGE_ARRAYS_SPEC_VERSION
		swigIntConstant( VK_EXT_YCBCR_IMAGE_ARRAYS_SPEC_VERSION, "VK_EXT_YCBCR_IMAGE_ARRAYS_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_provoking_vertex
		swigIntConstant( VK_EXT_provoking_vertex, "VK_EXT_provoking_vertex" );
	#endif
	#ifdef VK_EXT_PROVOKING_VERTEX_SPEC_VERSION
		swigIntConstant( VK_EXT_PROVOKING_VERTEX_SPEC_VERSION, "VK_EXT_PROVOKING_VERTEX_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_headless_surface
		swigIntConstant( VK_EXT_headless_surface, "VK_EXT_headless_surface" );
	#endif
	#ifdef VK_EXT_HEADLESS_SURFACE_SPEC_VERSION
		swigIntConstant( VK_EXT_HEADLESS_SURFACE_SPEC_VERSION, "VK_EXT_HEADLESS_SURFACE_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_line_rasterization
		swigIntConstant( VK_EXT_line_rasterization, "VK_EXT_line_rasterization" );
	#endif
	#ifdef VK_EXT_LINE_RASTERIZATION_SPEC_VERSION
		swigIntConstant( VK_EXT_LINE_RASTERIZATION_SPEC_VERSION, "VK_EXT_LINE_RASTERIZATION_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_shader_atomic_float
		swigIntConstant( VK_EXT_shader_atomic_float, "VK_EXT_shader_atomic_float" );
	#endif
	#ifdef VK_EXT_SHADER_ATOMIC_FLOAT_SPEC_VERSION
		swigIntConstant( VK_EXT_SHADER_ATOMIC_FLOAT_SPEC_VERSION, "VK_EXT_SHADER_ATOMIC_FLOAT_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_host_query_reset
		swigIntConstant( VK_EXT_host_query_reset, "VK_EXT_host_query_reset" );
	#endif
	#ifdef VK_EXT_HOST_QUERY_RESET_SPEC_VERSION
		swigIntConstant( VK_EXT_HOST_QUERY_RESET_SPEC_VERSION, "VK_EXT_HOST_QUERY_RESET_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_index_type_uint8
		swigIntConstant( VK_EXT_index_type_uint8, "VK_EXT_index_type_uint8" );
	#endif
	#ifdef VK_EXT_INDEX_TYPE_UINT8_SPEC_VERSION
		swigIntConstant( VK_EXT_INDEX_TYPE_UINT8_SPEC_VERSION, "VK_EXT_INDEX_TYPE_UINT8_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_extended_dynamic_state
		swigIntConstant( VK_EXT_extended_dynamic_state, "VK_EXT_extended_dynamic_state" );
	#endif
	#ifdef VK_EXT_EXTENDED_DYNAMIC_STATE_SPEC_VERSION
		swigIntConstant( VK_EXT_EXTENDED_DYNAMIC_STATE_SPEC_VERSION, "VK_EXT_EXTENDED_DYNAMIC_STATE_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_shader_atomic_float2
		swigIntConstant( VK_EXT_shader_atomic_float2, "VK_EXT_shader_atomic_float2" );
	#endif
	#ifdef VK_EXT_SHADER_ATOMIC_FLOAT_2_SPEC_VERSION
		swigIntConstant( VK_EXT_SHADER_ATOMIC_FLOAT_2_SPEC_VERSION, "VK_EXT_SHADER_ATOMIC_FLOAT_2_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_shader_demote_to_helper_invocation
		swigIntConstant( VK_EXT_shader_demote_to_helper_invocation, "VK_EXT_shader_demote_to_helper_invocation" );
	#endif
	#ifdef VK_EXT_SHADER_DEMOTE_TO_HELPER_INVOCATION_SPEC_VERSION
		swigIntConstant( VK_EXT_SHADER_DEMOTE_TO_HELPER_INVOCATION_SPEC_VERSION, "VK_EXT_SHADER_DEMOTE_TO_HELPER_INVOCATION_SPEC_VERSION" );
	#endif
	#ifdef VK_NV_device_generated_commands
		swigIntConstant( VK_NV_device_generated_commands, "VK_NV_device_generated_commands" );
	#endif
	#ifdef VK_NV_DEVICE_GENERATED_COMMANDS_SPEC_VERSION
		swigIntConstant( VK_NV_DEVICE_GENERATED_COMMANDS_SPEC_VERSION, "VK_NV_DEVICE_GENERATED_COMMANDS_SPEC_VERSION" );
	#endif
	#ifdef VK_NV_inherited_viewport_scissor
		swigIntConstant( VK_NV_inherited_viewport_scissor, "VK_NV_inherited_viewport_scissor" );
	#endif
	#ifdef VK_NV_INHERITED_VIEWPORT_SCISSOR_SPEC_VERSION
		swigIntConstant( VK_NV_INHERITED_VIEWPORT_SCISSOR_SPEC_VERSION, "VK_NV_INHERITED_VIEWPORT_SCISSOR_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_texel_buffer_alignment
		swigIntConstant( VK_EXT_texel_buffer_alignment, "VK_EXT_texel_buffer_alignment" );
	#endif
	#ifdef VK_EXT_TEXEL_BUFFER_ALIGNMENT_SPEC_VERSION
		swigIntConstant( VK_EXT_TEXEL_BUFFER_ALIGNMENT_SPEC_VERSION, "VK_EXT_TEXEL_BUFFER_ALIGNMENT_SPEC_VERSION" );
	#endif
	#ifdef VK_QCOM_render_pass_transform
		swigIntConstant( VK_QCOM_render_pass_transform, "VK_QCOM_render_pass_transform" );
	#endif
	#ifdef VK_QCOM_RENDER_PASS_TRANSFORM_SPEC_VERSION
		swigIntConstant( VK_QCOM_RENDER_PASS_TRANSFORM_SPEC_VERSION, "VK_QCOM_RENDER_PASS_TRANSFORM_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_device_memory_report
		swigIntConstant( VK_EXT_device_memory_report, "VK_EXT_device_memory_report" );
	#endif
	#ifdef VK_EXT_DEVICE_MEMORY_REPORT_SPEC_VERSION
		swigIntConstant( VK_EXT_DEVICE_MEMORY_REPORT_SPEC_VERSION, "VK_EXT_DEVICE_MEMORY_REPORT_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_acquire_drm_display
		swigIntConstant( VK_EXT_acquire_drm_display, "VK_EXT_acquire_drm_display" );
	#endif
	#ifdef VK_EXT_ACQUIRE_DRM_DISPLAY_SPEC_VERSION
		swigIntConstant( VK_EXT_ACQUIRE_DRM_DISPLAY_SPEC_VERSION, "VK_EXT_ACQUIRE_DRM_DISPLAY_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_robustness2
		swigIntConstant( VK_EXT_robustness2, "VK_EXT_robustness2" );
	#endif
	#ifdef VK_EXT_ROBUSTNESS_2_SPEC_VERSION
		swigIntConstant( VK_EXT_ROBUSTNESS_2_SPEC_VERSION, "VK_EXT_ROBUSTNESS_2_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_custom_border_color
		swigIntConstant( VK_EXT_custom_border_color, "VK_EXT_custom_border_color" );
	#endif
	#ifdef VK_EXT_CUSTOM_BORDER_COLOR_SPEC_VERSION
		swigIntConstant( VK_EXT_CUSTOM_BORDER_COLOR_SPEC_VERSION, "VK_EXT_CUSTOM_BORDER_COLOR_SPEC_VERSION" );
	#endif
	#ifdef VK_GOOGLE_user_type
		swigIntConstant( VK_GOOGLE_user_type, "VK_GOOGLE_user_type" );
	#endif
	#ifdef VK_GOOGLE_USER_TYPE_SPEC_VERSION
		swigIntConstant( VK_GOOGLE_USER_TYPE_SPEC_VERSION, "VK_GOOGLE_USER_TYPE_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_private_data
		swigIntConstant( VK_EXT_private_data, "VK_EXT_private_data" );
	#endif
	#ifdef VK_EXT_PRIVATE_DATA_SPEC_VERSION
		swigIntConstant( VK_EXT_PRIVATE_DATA_SPEC_VERSION, "VK_EXT_PRIVATE_DATA_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_pipeline_creation_cache_control
		swigIntConstant( VK_EXT_pipeline_creation_cache_control, "VK_EXT_pipeline_creation_cache_control" );
	#endif
	#ifdef VK_EXT_PIPELINE_CREATION_CACHE_CONTROL_SPEC_VERSION
		swigIntConstant( VK_EXT_PIPELINE_CREATION_CACHE_CONTROL_SPEC_VERSION, "VK_EXT_PIPELINE_CREATION_CACHE_CONTROL_SPEC_VERSION" );
	#endif
	#ifdef VK_NV_device_diagnostics_config
		swigIntConstant( VK_NV_device_diagnostics_config, "VK_NV_device_diagnostics_config" );
	#endif
	#ifdef VK_NV_DEVICE_DIAGNOSTICS_CONFIG_SPEC_VERSION
		swigIntConstant( VK_NV_DEVICE_DIAGNOSTICS_CONFIG_SPEC_VERSION, "VK_NV_DEVICE_DIAGNOSTICS_CONFIG_SPEC_VERSION" );
	#endif
	#ifdef VK_QCOM_render_pass_store_ops
		swigIntConstant( VK_QCOM_render_pass_store_ops, "VK_QCOM_render_pass_store_ops" );
	#endif
	#ifdef VK_QCOM_RENDER_PASS_STORE_OPS_SPEC_VERSION
		swigIntConstant( VK_QCOM_RENDER_PASS_STORE_OPS_SPEC_VERSION, "VK_QCOM_RENDER_PASS_STORE_OPS_SPEC_VERSION" );
	#endif
	#ifdef VK_NV_fragment_shading_rate_enums
		swigIntConstant( VK_NV_fragment_shading_rate_enums, "VK_NV_fragment_shading_rate_enums" );
	#endif
	#ifdef VK_NV_FRAGMENT_SHADING_RATE_ENUMS_SPEC_VERSION
		swigIntConstant( VK_NV_FRAGMENT_SHADING_RATE_ENUMS_SPEC_VERSION, "VK_NV_FRAGMENT_SHADING_RATE_ENUMS_SPEC_VERSION" );
	#endif
	#ifdef VK_NV_ray_tracing_motion_blur
		swigIntConstant( VK_NV_ray_tracing_motion_blur, "VK_NV_ray_tracing_motion_blur" );
	#endif
	#ifdef VK_NV_RAY_TRACING_MOTION_BLUR_SPEC_VERSION
		swigIntConstant( VK_NV_RAY_TRACING_MOTION_BLUR_SPEC_VERSION, "VK_NV_RAY_TRACING_MOTION_BLUR_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_ycbcr_2plane_444_formats
		swigIntConstant( VK_EXT_ycbcr_2plane_444_formats, "VK_EXT_ycbcr_2plane_444_formats" );
	#endif
	#ifdef VK_EXT_YCBCR_2PLANE_444_FORMATS_SPEC_VERSION
		swigIntConstant( VK_EXT_YCBCR_2PLANE_444_FORMATS_SPEC_VERSION, "VK_EXT_YCBCR_2PLANE_444_FORMATS_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_fragment_density_map2
		swigIntConstant( VK_EXT_fragment_density_map2, "VK_EXT_fragment_density_map2" );
	#endif
	#ifdef VK_EXT_FRAGMENT_DENSITY_MAP_2_SPEC_VERSION
		swigIntConstant( VK_EXT_FRAGMENT_DENSITY_MAP_2_SPEC_VERSION, "VK_EXT_FRAGMENT_DENSITY_MAP_2_SPEC_VERSION" );
	#endif
	#ifdef VK_QCOM_rotated_copy_commands
		swigIntConstant( VK_QCOM_rotated_copy_commands, "VK_QCOM_rotated_copy_commands" );
	#endif
	#ifdef VK_QCOM_ROTATED_COPY_COMMANDS_SPEC_VERSION
		swigIntConstant( VK_QCOM_ROTATED_COPY_COMMANDS_SPEC_VERSION, "VK_QCOM_ROTATED_COPY_COMMANDS_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_image_robustness
		swigIntConstant( VK_EXT_image_robustness, "VK_EXT_image_robustness" );
	#endif
	#ifdef VK_EXT_IMAGE_ROBUSTNESS_SPEC_VERSION
		swigIntConstant( VK_EXT_IMAGE_ROBUSTNESS_SPEC_VERSION, "VK_EXT_IMAGE_ROBUSTNESS_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_4444_formats
		swigIntConstant( VK_EXT_4444_formats, "VK_EXT_4444_formats" );
	#endif
	#ifdef VK_EXT_4444_FORMATS_SPEC_VERSION
		swigIntConstant( VK_EXT_4444_FORMATS_SPEC_VERSION, "VK_EXT_4444_FORMATS_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_rgba10x6_formats
		swigIntConstant( VK_EXT_rgba10x6_formats, "VK_EXT_rgba10x6_formats" );
	#endif
	#ifdef VK_EXT_RGBA10X6_FORMATS_SPEC_VERSION
		swigIntConstant( VK_EXT_RGBA10X6_FORMATS_SPEC_VERSION, "VK_EXT_RGBA10X6_FORMATS_SPEC_VERSION" );
	#endif
	#ifdef VK_NV_acquire_winrt_display
		swigIntConstant( VK_NV_acquire_winrt_display, "VK_NV_acquire_winrt_display" );
	#endif
	#ifdef VK_NV_ACQUIRE_WINRT_DISPLAY_SPEC_VERSION
		swigIntConstant( VK_NV_ACQUIRE_WINRT_DISPLAY_SPEC_VERSION, "VK_NV_ACQUIRE_WINRT_DISPLAY_SPEC_VERSION" );
	#endif
	#ifdef VK_VALVE_mutable_descriptor_type
		swigIntConstant( VK_VALVE_mutable_descriptor_type, "VK_VALVE_mutable_descriptor_type" );
	#endif
	#ifdef VK_VALVE_MUTABLE_DESCRIPTOR_TYPE_SPEC_VERSION
		swigIntConstant( VK_VALVE_MUTABLE_DESCRIPTOR_TYPE_SPEC_VERSION, "VK_VALVE_MUTABLE_DESCRIPTOR_TYPE_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_vertex_input_dynamic_state
		swigIntConstant( VK_EXT_vertex_input_dynamic_state, "VK_EXT_vertex_input_dynamic_state" );
	#endif
	#ifdef VK_EXT_VERTEX_INPUT_DYNAMIC_STATE_SPEC_VERSION
		swigIntConstant( VK_EXT_VERTEX_INPUT_DYNAMIC_STATE_SPEC_VERSION, "VK_EXT_VERTEX_INPUT_DYNAMIC_STATE_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_physical_device_drm
		swigIntConstant( VK_EXT_physical_device_drm, "VK_EXT_physical_device_drm" );
	#endif
	#ifdef VK_EXT_PHYSICAL_DEVICE_DRM_SPEC_VERSION
		swigIntConstant( VK_EXT_PHYSICAL_DEVICE_DRM_SPEC_VERSION, "VK_EXT_PHYSICAL_DEVICE_DRM_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_primitive_topology_list_restart
		swigIntConstant( VK_EXT_primitive_topology_list_restart, "VK_EXT_primitive_topology_list_restart" );
	#endif
	#ifdef VK_EXT_PRIMITIVE_TOPOLOGY_LIST_RESTART_SPEC_VERSION
		swigIntConstant( VK_EXT_PRIMITIVE_TOPOLOGY_LIST_RESTART_SPEC_VERSION, "VK_EXT_PRIMITIVE_TOPOLOGY_LIST_RESTART_SPEC_VERSION" );
	#endif
	#ifdef VK_HUAWEI_subpass_shading
		swigIntConstant( VK_HUAWEI_subpass_shading, "VK_HUAWEI_subpass_shading" );
	#endif
	#ifdef VK_HUAWEI_SUBPASS_SHADING_SPEC_VERSION
		swigIntConstant( VK_HUAWEI_SUBPASS_SHADING_SPEC_VERSION, "VK_HUAWEI_SUBPASS_SHADING_SPEC_VERSION" );
	#endif
	#ifdef VK_HUAWEI_invocation_mask
		swigIntConstant( VK_HUAWEI_invocation_mask, "VK_HUAWEI_invocation_mask" );
	#endif
	#ifdef VK_HUAWEI_INVOCATION_MASK_SPEC_VERSION
		swigIntConstant( VK_HUAWEI_INVOCATION_MASK_SPEC_VERSION, "VK_HUAWEI_INVOCATION_MASK_SPEC_VERSION" );
	#endif
	#ifdef VK_NV_external_memory_rdma
		swigIntConstant( VK_NV_external_memory_rdma, "VK_NV_external_memory_rdma" );
	#endif
	#ifdef VK_NV_EXTERNAL_MEMORY_RDMA_SPEC_VERSION
		swigIntConstant( VK_NV_EXTERNAL_MEMORY_RDMA_SPEC_VERSION, "VK_NV_EXTERNAL_MEMORY_RDMA_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_extended_dynamic_state2
		swigIntConstant( VK_EXT_extended_dynamic_state2, "VK_EXT_extended_dynamic_state2" );
	#endif
	#ifdef VK_EXT_EXTENDED_DYNAMIC_STATE_2_SPEC_VERSION
		swigIntConstant( VK_EXT_EXTENDED_DYNAMIC_STATE_2_SPEC_VERSION, "VK_EXT_EXTENDED_DYNAMIC_STATE_2_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_color_write_enable
		swigIntConstant( VK_EXT_color_write_enable, "VK_EXT_color_write_enable" );
	#endif
	#ifdef VK_EXT_COLOR_WRITE_ENABLE_SPEC_VERSION
		swigIntConstant( VK_EXT_COLOR_WRITE_ENABLE_SPEC_VERSION, "VK_EXT_COLOR_WRITE_ENABLE_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_global_priority_query
		swigIntConstant( VK_EXT_global_priority_query, "VK_EXT_global_priority_query" );
	#endif
	#ifdef VK_MAX_GLOBAL_PRIORITY_SIZE_EXT
		swigUnsignedIntConstant( VK_MAX_GLOBAL_PRIORITY_SIZE_EXT, "VK_MAX_GLOBAL_PRIORITY_SIZE_EXT" );
	#endif
	#ifdef VK_EXT_GLOBAL_PRIORITY_QUERY_SPEC_VERSION
		swigIntConstant( VK_EXT_GLOBAL_PRIORITY_QUERY_SPEC_VERSION, "VK_EXT_GLOBAL_PRIORITY_QUERY_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_multi_draw
		swigIntConstant( VK_EXT_multi_draw, "VK_EXT_multi_draw" );
	#endif
	#ifdef VK_EXT_MULTI_DRAW_SPEC_VERSION
		swigIntConstant( VK_EXT_MULTI_DRAW_SPEC_VERSION, "VK_EXT_MULTI_DRAW_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_load_store_op_none
		swigIntConstant( VK_EXT_load_store_op_none, "VK_EXT_load_store_op_none" );
	#endif
	#ifdef VK_EXT_LOAD_STORE_OP_NONE_SPEC_VERSION
		swigIntConstant( VK_EXT_LOAD_STORE_OP_NONE_SPEC_VERSION, "VK_EXT_LOAD_STORE_OP_NONE_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_border_color_swizzle
		swigIntConstant( VK_EXT_border_color_swizzle, "VK_EXT_border_color_swizzle" );
	#endif
	#ifdef VK_EXT_BORDER_COLOR_SWIZZLE_SPEC_VERSION
		swigIntConstant( VK_EXT_BORDER_COLOR_SWIZZLE_SPEC_VERSION, "VK_EXT_BORDER_COLOR_SWIZZLE_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_pageable_device_local_memory
		swigIntConstant( VK_EXT_pageable_device_local_memory, "VK_EXT_pageable_device_local_memory" );
	#endif
	#ifdef VK_EXT_PAGEABLE_DEVICE_LOCAL_MEMORY_SPEC_VERSION
		swigIntConstant( VK_EXT_PAGEABLE_DEVICE_LOCAL_MEMORY_SPEC_VERSION, "VK_EXT_PAGEABLE_DEVICE_LOCAL_MEMORY_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_acceleration_structure
		swigIntConstant( VK_KHR_acceleration_structure, "VK_KHR_acceleration_structure" );
	#endif
	#ifdef VK_KHR_ACCELERATION_STRUCTURE_SPEC_VERSION
		swigIntConstant( VK_KHR_ACCELERATION_STRUCTURE_SPEC_VERSION, "VK_KHR_ACCELERATION_STRUCTURE_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_ray_tracing_pipeline
		swigIntConstant( VK_KHR_ray_tracing_pipeline, "VK_KHR_ray_tracing_pipeline" );
	#endif
	#ifdef VK_KHR_RAY_TRACING_PIPELINE_SPEC_VERSION
		swigIntConstant( VK_KHR_RAY_TRACING_PIPELINE_SPEC_VERSION, "VK_KHR_RAY_TRACING_PIPELINE_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_ray_query
		swigIntConstant( VK_KHR_ray_query, "VK_KHR_ray_query" );
	#endif
	#ifdef VK_KHR_RAY_QUERY_SPEC_VERSION
		swigIntConstant( VK_KHR_RAY_QUERY_SPEC_VERSION, "VK_KHR_RAY_QUERY_SPEC_VERSION" );
	#endif

	swigNewline();

	swigComment("----===< long constants >===-----\n");
	#ifdef VK_NULL_HANDLE
		swigUnsignedLongConstant( VK_NULL_HANDLE, "VK_NULL_HANDLE" );
	#endif
	#ifdef VK_WHOLE_SIZE
		swigUnsignedLongConstant( VK_WHOLE_SIZE, "VK_WHOLE_SIZE" );
	#endif

	swigNewline();

	swigComment("---===< float constants >===----\n");
	#ifdef VK_LOD_CLAMP_NONE
		swigFloatConstant( VK_LOD_CLAMP_NONE, "VK_LOD_CLAMP_NONE" );
	#endif

	swigNewline();

	swigComment("--------===< enums >===---------\n");
	swigIntConstant( VK_SUCCESS, "VK_SUCCESS" );
	swigIntConstant( VK_NOT_READY, "VK_NOT_READY" );
	swigIntConstant( VK_TIMEOUT, "VK_TIMEOUT" );
	swigIntConstant( VK_EVENT_SET, "VK_EVENT_SET" );
	swigIntConstant( VK_EVENT_RESET, "VK_EVENT_RESET" );
	swigIntConstant( VK_INCOMPLETE, "VK_INCOMPLETE" );
	swigIntConstant( VK_ERROR_OUT_OF_HOST_MEMORY, "VK_ERROR_OUT_OF_HOST_MEMORY" );
	swigIntConstant( VK_ERROR_OUT_OF_DEVICE_MEMORY, "VK_ERROR_OUT_OF_DEVICE_MEMORY" );
	swigIntConstant( VK_ERROR_INITIALIZATION_FAILED, "VK_ERROR_INITIALIZATION_FAILED" );
	swigIntConstant( VK_ERROR_DEVICE_LOST, "VK_ERROR_DEVICE_LOST" );
	swigIntConstant( VK_ERROR_MEMORY_MAP_FAILED, "VK_ERROR_MEMORY_MAP_FAILED" );
	swigIntConstant( VK_ERROR_LAYER_NOT_PRESENT, "VK_ERROR_LAYER_NOT_PRESENT" );
	swigIntConstant( VK_ERROR_EXTENSION_NOT_PRESENT, "VK_ERROR_EXTENSION_NOT_PRESENT" );
	swigIntConstant( VK_ERROR_FEATURE_NOT_PRESENT, "VK_ERROR_FEATURE_NOT_PRESENT" );
	swigIntConstant( VK_ERROR_INCOMPATIBLE_DRIVER, "VK_ERROR_INCOMPATIBLE_DRIVER" );
	swigIntConstant( VK_ERROR_TOO_MANY_OBJECTS, "VK_ERROR_TOO_MANY_OBJECTS" );
	swigIntConstant( VK_ERROR_FORMAT_NOT_SUPPORTED, "VK_ERROR_FORMAT_NOT_SUPPORTED" );
	swigIntConstant( VK_ERROR_FRAGMENTED_POOL, "VK_ERROR_FRAGMENTED_POOL" );
	swigIntConstant( VK_ERROR_UNKNOWN, "VK_ERROR_UNKNOWN" );
	swigIntConstant( VK_ERROR_OUT_OF_POOL_MEMORY, "VK_ERROR_OUT_OF_POOL_MEMORY" );
	swigIntConstant( VK_ERROR_INVALID_EXTERNAL_HANDLE, "VK_ERROR_INVALID_EXTERNAL_HANDLE" );
	swigIntConstant( VK_ERROR_FRAGMENTATION, "VK_ERROR_FRAGMENTATION" );
	swigIntConstant( VK_ERROR_INVALID_OPAQUE_CAPTURE_ADDRESS, "VK_ERROR_INVALID_OPAQUE_CAPTURE_ADDRESS" );
	swigIntConstant( VK_ERROR_SURFACE_LOST_KHR, "VK_ERROR_SURFACE_LOST_KHR" );
	swigIntConstant( VK_ERROR_NATIVE_WINDOW_IN_USE_KHR, "VK_ERROR_NATIVE_WINDOW_IN_USE_KHR" );
	swigIntConstant( VK_SUBOPTIMAL_KHR, "VK_SUBOPTIMAL_KHR" );
	swigIntConstant( VK_ERROR_OUT_OF_DATE_KHR, "VK_ERROR_OUT_OF_DATE_KHR" );
	swigIntConstant( VK_ERROR_INCOMPATIBLE_DISPLAY_KHR, "VK_ERROR_INCOMPATIBLE_DISPLAY_KHR" );
	swigIntConstant( VK_ERROR_VALIDATION_FAILED_EXT, "VK_ERROR_VALIDATION_FAILED_EXT" );
	swigIntConstant( VK_ERROR_INVALID_SHADER_NV, "VK_ERROR_INVALID_SHADER_NV" );
	swigIntConstant( VK_ERROR_INVALID_DRM_FORMAT_MODIFIER_PLANE_LAYOUT_EXT, "VK_ERROR_INVALID_DRM_FORMAT_MODIFIER_PLANE_LAYOUT_EXT" );
	swigIntConstant( VK_ERROR_NOT_PERMITTED_EXT, "VK_ERROR_NOT_PERMITTED_EXT" );
	swigIntConstant( VK_ERROR_FULL_SCREEN_EXCLUSIVE_MODE_LOST_EXT, "VK_ERROR_FULL_SCREEN_EXCLUSIVE_MODE_LOST_EXT" );
	swigIntConstant( VK_THREAD_IDLE_KHR, "VK_THREAD_IDLE_KHR" );
	swigIntConstant( VK_THREAD_DONE_KHR, "VK_THREAD_DONE_KHR" );
	swigIntConstant( VK_OPERATION_DEFERRED_KHR, "VK_OPERATION_DEFERRED_KHR" );
	swigIntConstant( VK_OPERATION_NOT_DEFERRED_KHR, "VK_OPERATION_NOT_DEFERRED_KHR" );
	swigIntConstant( VK_PIPELINE_COMPILE_REQUIRED_EXT, "VK_PIPELINE_COMPILE_REQUIRED_EXT" );
	swigIntConstant( VK_ERROR_OUT_OF_POOL_MEMORY_KHR, "VK_ERROR_OUT_OF_POOL_MEMORY_KHR" );
	swigIntConstant( VK_ERROR_INVALID_EXTERNAL_HANDLE_KHR, "VK_ERROR_INVALID_EXTERNAL_HANDLE_KHR" );
	swigIntConstant( VK_ERROR_FRAGMENTATION_EXT, "VK_ERROR_FRAGMENTATION_EXT" );
	swigIntConstant( VK_ERROR_INVALID_DEVICE_ADDRESS_EXT, "VK_ERROR_INVALID_DEVICE_ADDRESS_EXT" );
	swigIntConstant( VK_ERROR_INVALID_OPAQUE_CAPTURE_ADDRESS_KHR, "VK_ERROR_INVALID_OPAQUE_CAPTURE_ADDRESS_KHR" );
	swigIntConstant( VK_ERROR_PIPELINE_COMPILE_REQUIRED_EXT, "VK_ERROR_PIPELINE_COMPILE_REQUIRED_EXT" );
	swigIntConstant( VK_RESULT_MAX_ENUM, "VK_RESULT_MAX_ENUM" );
	swigIntConstant( VK_STRUCTURE_TYPE_APPLICATION_INFO, "VK_STRUCTURE_TYPE_APPLICATION_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_INSTANCE_CREATE_INFO, "VK_STRUCTURE_TYPE_INSTANCE_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_DEVICE_QUEUE_CREATE_INFO, "VK_STRUCTURE_TYPE_DEVICE_QUEUE_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_DEVICE_CREATE_INFO, "VK_STRUCTURE_TYPE_DEVICE_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_SUBMIT_INFO, "VK_STRUCTURE_TYPE_SUBMIT_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_INFO, "VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_MAPPED_MEMORY_RANGE, "VK_STRUCTURE_TYPE_MAPPED_MEMORY_RANGE" );
	swigIntConstant( VK_STRUCTURE_TYPE_BIND_SPARSE_INFO, "VK_STRUCTURE_TYPE_BIND_SPARSE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_FENCE_CREATE_INFO, "VK_STRUCTURE_TYPE_FENCE_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_SEMAPHORE_CREATE_INFO, "VK_STRUCTURE_TYPE_SEMAPHORE_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_EVENT_CREATE_INFO, "VK_STRUCTURE_TYPE_EVENT_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_QUERY_POOL_CREATE_INFO, "VK_STRUCTURE_TYPE_QUERY_POOL_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_BUFFER_CREATE_INFO, "VK_STRUCTURE_TYPE_BUFFER_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_BUFFER_VIEW_CREATE_INFO, "VK_STRUCTURE_TYPE_BUFFER_VIEW_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_IMAGE_CREATE_INFO, "VK_STRUCTURE_TYPE_IMAGE_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_IMAGE_VIEW_CREATE_INFO, "VK_STRUCTURE_TYPE_IMAGE_VIEW_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_SHADER_MODULE_CREATE_INFO, "VK_STRUCTURE_TYPE_SHADER_MODULE_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_PIPELINE_CACHE_CREATE_INFO, "VK_STRUCTURE_TYPE_PIPELINE_CACHE_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_CREATE_INFO, "VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_STATE_CREATE_INFO, "VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_STATE_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_PIPELINE_INPUT_ASSEMBLY_STATE_CREATE_INFO, "VK_STRUCTURE_TYPE_PIPELINE_INPUT_ASSEMBLY_STATE_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_STATE_CREATE_INFO, "VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_STATE_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_STATE_CREATE_INFO, "VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_STATE_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_CREATE_INFO, "VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_PIPELINE_MULTISAMPLE_STATE_CREATE_INFO, "VK_STRUCTURE_TYPE_PIPELINE_MULTISAMPLE_STATE_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_PIPELINE_DEPTH_STENCIL_STATE_CREATE_INFO, "VK_STRUCTURE_TYPE_PIPELINE_DEPTH_STENCIL_STATE_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_PIPELINE_COLOR_BLEND_STATE_CREATE_INFO, "VK_STRUCTURE_TYPE_PIPELINE_COLOR_BLEND_STATE_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_PIPELINE_DYNAMIC_STATE_CREATE_INFO, "VK_STRUCTURE_TYPE_PIPELINE_DYNAMIC_STATE_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_CREATE_INFO, "VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_COMPUTE_PIPELINE_CREATE_INFO, "VK_STRUCTURE_TYPE_COMPUTE_PIPELINE_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_PIPELINE_LAYOUT_CREATE_INFO, "VK_STRUCTURE_TYPE_PIPELINE_LAYOUT_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_SAMPLER_CREATE_INFO, "VK_STRUCTURE_TYPE_SAMPLER_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_CREATE_INFO, "VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_CREATE_INFO, "VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_DESCRIPTOR_SET_ALLOCATE_INFO, "VK_STRUCTURE_TYPE_DESCRIPTOR_SET_ALLOCATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET, "VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET" );
	swigIntConstant( VK_STRUCTURE_TYPE_COPY_DESCRIPTOR_SET, "VK_STRUCTURE_TYPE_COPY_DESCRIPTOR_SET" );
	swigIntConstant( VK_STRUCTURE_TYPE_FRAMEBUFFER_CREATE_INFO, "VK_STRUCTURE_TYPE_FRAMEBUFFER_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO, "VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_COMMAND_POOL_CREATE_INFO, "VK_STRUCTURE_TYPE_COMMAND_POOL_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_COMMAND_BUFFER_ALLOCATE_INFO, "VK_STRUCTURE_TYPE_COMMAND_BUFFER_ALLOCATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_INFO, "VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_COMMAND_BUFFER_BEGIN_INFO, "VK_STRUCTURE_TYPE_COMMAND_BUFFER_BEGIN_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_RENDER_PASS_BEGIN_INFO, "VK_STRUCTURE_TYPE_RENDER_PASS_BEGIN_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER, "VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER" );
	swigIntConstant( VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER, "VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER" );
	swigIntConstant( VK_STRUCTURE_TYPE_MEMORY_BARRIER, "VK_STRUCTURE_TYPE_MEMORY_BARRIER" );
	swigIntConstant( VK_STRUCTURE_TYPE_LOADER_INSTANCE_CREATE_INFO, "VK_STRUCTURE_TYPE_LOADER_INSTANCE_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_LOADER_DEVICE_CREATE_INFO, "VK_STRUCTURE_TYPE_LOADER_DEVICE_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES" );
	swigIntConstant( VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_INFO, "VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_INFO, "VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES" );
	swigIntConstant( VK_STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS, "VK_STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS" );
	swigIntConstant( VK_STRUCTURE_TYPE_MEMORY_DEDICATED_ALLOCATE_INFO, "VK_STRUCTURE_TYPE_MEMORY_DEDICATED_ALLOCATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_FLAGS_INFO, "VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_FLAGS_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO, "VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO, "VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_DEVICE_GROUP_SUBMIT_INFO, "VK_STRUCTURE_TYPE_DEVICE_GROUP_SUBMIT_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_DEVICE_GROUP_BIND_SPARSE_INFO, "VK_STRUCTURE_TYPE_DEVICE_GROUP_BIND_SPARSE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO, "VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO, "VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GROUP_PROPERTIES, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GROUP_PROPERTIES" );
	swigIntConstant( VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO, "VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_BUFFER_MEMORY_REQUIREMENTS_INFO_2, "VK_STRUCTURE_TYPE_BUFFER_MEMORY_REQUIREMENTS_INFO_2" );
	swigIntConstant( VK_STRUCTURE_TYPE_IMAGE_MEMORY_REQUIREMENTS_INFO_2, "VK_STRUCTURE_TYPE_IMAGE_MEMORY_REQUIREMENTS_INFO_2" );
	swigIntConstant( VK_STRUCTURE_TYPE_IMAGE_SPARSE_MEMORY_REQUIREMENTS_INFO_2, "VK_STRUCTURE_TYPE_IMAGE_SPARSE_MEMORY_REQUIREMENTS_INFO_2" );
	swigIntConstant( VK_STRUCTURE_TYPE_MEMORY_REQUIREMENTS_2, "VK_STRUCTURE_TYPE_MEMORY_REQUIREMENTS_2" );
	swigIntConstant( VK_STRUCTURE_TYPE_SPARSE_IMAGE_MEMORY_REQUIREMENTS_2, "VK_STRUCTURE_TYPE_SPARSE_IMAGE_MEMORY_REQUIREMENTS_2" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2" );
	swigIntConstant( VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_2, "VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_2" );
	swigIntConstant( VK_STRUCTURE_TYPE_IMAGE_FORMAT_PROPERTIES_2, "VK_STRUCTURE_TYPE_IMAGE_FORMAT_PROPERTIES_2" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_FORMAT_INFO_2, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_FORMAT_INFO_2" );
	swigIntConstant( VK_STRUCTURE_TYPE_QUEUE_FAMILY_PROPERTIES_2, "VK_STRUCTURE_TYPE_QUEUE_FAMILY_PROPERTIES_2" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PROPERTIES_2, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PROPERTIES_2" );
	swigIntConstant( VK_STRUCTURE_TYPE_SPARSE_IMAGE_FORMAT_PROPERTIES_2, "VK_STRUCTURE_TYPE_SPARSE_IMAGE_FORMAT_PROPERTIES_2" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SPARSE_IMAGE_FORMAT_INFO_2, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SPARSE_IMAGE_FORMAT_INFO_2" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES" );
	swigIntConstant( VK_STRUCTURE_TYPE_RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO, "VK_STRUCTURE_TYPE_RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_IMAGE_VIEW_USAGE_CREATE_INFO, "VK_STRUCTURE_TYPE_IMAGE_VIEW_USAGE_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO, "VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_RENDER_PASS_MULTIVIEW_CREATE_INFO, "VK_STRUCTURE_TYPE_RENDER_PASS_MULTIVIEW_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES" );
	swigIntConstant( VK_STRUCTURE_TYPE_PROTECTED_SUBMIT_INFO, "VK_STRUCTURE_TYPE_PROTECTED_SUBMIT_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES" );
	swigIntConstant( VK_STRUCTURE_TYPE_DEVICE_QUEUE_INFO_2, "VK_STRUCTURE_TYPE_DEVICE_QUEUE_INFO_2" );
	swigIntConstant( VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_CREATE_INFO, "VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_INFO, "VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO, "VK_STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO, "VK_STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES" );
	swigIntConstant( VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES, "VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES" );
	swigIntConstant( VK_STRUCTURE_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_CREATE_INFO, "VK_STRUCTURE_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES, "VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_BUFFER_INFO, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_BUFFER_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_EXTERNAL_BUFFER_PROPERTIES, "VK_STRUCTURE_TYPE_EXTERNAL_BUFFER_PROPERTIES" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES" );
	swigIntConstant( VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO, "VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO, "VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO, "VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FENCE_INFO, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FENCE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_EXTERNAL_FENCE_PROPERTIES, "VK_STRUCTURE_TYPE_EXTERNAL_FENCE_PROPERTIES" );
	swigIntConstant( VK_STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO, "VK_STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_CREATE_INFO, "VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_SEMAPHORE_INFO, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_SEMAPHORE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_EXTERNAL_SEMAPHORE_PROPERTIES, "VK_STRUCTURE_TYPE_EXTERNAL_SEMAPHORE_PROPERTIES" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES" );
	swigIntConstant( VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_SUPPORT, "VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_SUPPORT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES" );
	swigIntConstant( VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO, "VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_2, "VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_2" );
	swigIntConstant( VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2, "VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2" );
	swigIntConstant( VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_2, "VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_2" );
	swigIntConstant( VK_STRUCTURE_TYPE_SUBPASS_DEPENDENCY_2, "VK_STRUCTURE_TYPE_SUBPASS_DEPENDENCY_2" );
	swigIntConstant( VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO_2, "VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO_2" );
	swigIntConstant( VK_STRUCTURE_TYPE_SUBPASS_BEGIN_INFO, "VK_STRUCTURE_TYPE_SUBPASS_BEGIN_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_SUBPASS_END_INFO, "VK_STRUCTURE_TYPE_SUBPASS_END_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES" );
	swigIntConstant( VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_BINDING_FLAGS_CREATE_INFO, "VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_BINDING_FLAGS_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES" );
	swigIntConstant( VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO, "VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_LAYOUT_SUPPORT, "VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_LAYOUT_SUPPORT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES" );
	swigIntConstant( VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE, "VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES" );
	swigIntConstant( VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO, "VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES" );
	swigIntConstant( VK_STRUCTURE_TYPE_SAMPLER_REDUCTION_MODE_CREATE_INFO, "VK_STRUCTURE_TYPE_SAMPLER_REDUCTION_MODE_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES" );
	swigIntConstant( VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO, "VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENT_IMAGE_INFO, "VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENT_IMAGE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO, "VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES" );
	swigIntConstant( VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT, "VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT" );
	swigIntConstant( VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT, "VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES" );
	swigIntConstant( VK_STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO, "VK_STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_TIMELINE_SEMAPHORE_SUBMIT_INFO, "VK_STRUCTURE_TYPE_TIMELINE_SEMAPHORE_SUBMIT_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_SEMAPHORE_WAIT_INFO, "VK_STRUCTURE_TYPE_SEMAPHORE_WAIT_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_SEMAPHORE_SIGNAL_INFO, "VK_STRUCTURE_TYPE_SEMAPHORE_SIGNAL_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES" );
	swigIntConstant( VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_INFO, "VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO, "VK_STRUCTURE_TYPE_BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_MEMORY_OPAQUE_CAPTURE_ADDRESS_ALLOCATE_INFO, "VK_STRUCTURE_TYPE_MEMORY_OPAQUE_CAPTURE_ADDRESS_ALLOCATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_DEVICE_MEMORY_OPAQUE_CAPTURE_ADDRESS_INFO, "VK_STRUCTURE_TYPE_DEVICE_MEMORY_OPAQUE_CAPTURE_ADDRESS_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_SWAPCHAIN_CREATE_INFO_KHR, "VK_STRUCTURE_TYPE_SWAPCHAIN_CREATE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PRESENT_INFO_KHR, "VK_STRUCTURE_TYPE_PRESENT_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_DEVICE_GROUP_PRESENT_CAPABILITIES_KHR, "VK_STRUCTURE_TYPE_DEVICE_GROUP_PRESENT_CAPABILITIES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_IMAGE_SWAPCHAIN_CREATE_INFO_KHR, "VK_STRUCTURE_TYPE_IMAGE_SWAPCHAIN_CREATE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_SWAPCHAIN_INFO_KHR, "VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_SWAPCHAIN_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_ACQUIRE_NEXT_IMAGE_INFO_KHR, "VK_STRUCTURE_TYPE_ACQUIRE_NEXT_IMAGE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_DEVICE_GROUP_PRESENT_INFO_KHR, "VK_STRUCTURE_TYPE_DEVICE_GROUP_PRESENT_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_DEVICE_GROUP_SWAPCHAIN_CREATE_INFO_KHR, "VK_STRUCTURE_TYPE_DEVICE_GROUP_SWAPCHAIN_CREATE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_DISPLAY_MODE_CREATE_INFO_KHR, "VK_STRUCTURE_TYPE_DISPLAY_MODE_CREATE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_DISPLAY_SURFACE_CREATE_INFO_KHR, "VK_STRUCTURE_TYPE_DISPLAY_SURFACE_CREATE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_DISPLAY_PRESENT_INFO_KHR, "VK_STRUCTURE_TYPE_DISPLAY_PRESENT_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_XLIB_SURFACE_CREATE_INFO_KHR, "VK_STRUCTURE_TYPE_XLIB_SURFACE_CREATE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_XCB_SURFACE_CREATE_INFO_KHR, "VK_STRUCTURE_TYPE_XCB_SURFACE_CREATE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_WAYLAND_SURFACE_CREATE_INFO_KHR, "VK_STRUCTURE_TYPE_WAYLAND_SURFACE_CREATE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_ANDROID_SURFACE_CREATE_INFO_KHR, "VK_STRUCTURE_TYPE_ANDROID_SURFACE_CREATE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_WIN32_SURFACE_CREATE_INFO_KHR, "VK_STRUCTURE_TYPE_WIN32_SURFACE_CREATE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_DEBUG_REPORT_CALLBACK_CREATE_INFO_EXT, "VK_STRUCTURE_TYPE_DEBUG_REPORT_CALLBACK_CREATE_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_RASTERIZATION_ORDER_AMD, "VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_RASTERIZATION_ORDER_AMD" );
	swigIntConstant( VK_STRUCTURE_TYPE_DEBUG_MARKER_OBJECT_NAME_INFO_EXT, "VK_STRUCTURE_TYPE_DEBUG_MARKER_OBJECT_NAME_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_DEBUG_MARKER_OBJECT_TAG_INFO_EXT, "VK_STRUCTURE_TYPE_DEBUG_MARKER_OBJECT_TAG_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_DEBUG_MARKER_MARKER_INFO_EXT, "VK_STRUCTURE_TYPE_DEBUG_MARKER_MARKER_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_IMAGE_CREATE_INFO_NV, "VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_IMAGE_CREATE_INFO_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_BUFFER_CREATE_INFO_NV, "VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_BUFFER_CREATE_INFO_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_MEMORY_ALLOCATE_INFO_NV, "VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_MEMORY_ALLOCATE_INFO_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_STREAM_CREATE_INFO_EXT, "VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_STREAM_CREATE_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_CU_MODULE_CREATE_INFO_NVX, "VK_STRUCTURE_TYPE_CU_MODULE_CREATE_INFO_NVX" );
	swigIntConstant( VK_STRUCTURE_TYPE_CU_FUNCTION_CREATE_INFO_NVX, "VK_STRUCTURE_TYPE_CU_FUNCTION_CREATE_INFO_NVX" );
	swigIntConstant( VK_STRUCTURE_TYPE_CU_LAUNCH_INFO_NVX, "VK_STRUCTURE_TYPE_CU_LAUNCH_INFO_NVX" );
	swigIntConstant( VK_STRUCTURE_TYPE_IMAGE_VIEW_HANDLE_INFO_NVX, "VK_STRUCTURE_TYPE_IMAGE_VIEW_HANDLE_INFO_NVX" );
	swigIntConstant( VK_STRUCTURE_TYPE_IMAGE_VIEW_ADDRESS_PROPERTIES_NVX, "VK_STRUCTURE_TYPE_IMAGE_VIEW_ADDRESS_PROPERTIES_NVX" );
	swigIntConstant( VK_STRUCTURE_TYPE_TEXTURE_LOD_GATHER_FORMAT_PROPERTIES_AMD, "VK_STRUCTURE_TYPE_TEXTURE_LOD_GATHER_FORMAT_PROPERTIES_AMD" );
	swigIntConstant( VK_STRUCTURE_TYPE_RENDERING_INFO_KHR, "VK_STRUCTURE_TYPE_RENDERING_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_RENDERING_ATTACHMENT_INFO_KHR, "VK_STRUCTURE_TYPE_RENDERING_ATTACHMENT_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PIPELINE_RENDERING_CREATE_INFO_KHR, "VK_STRUCTURE_TYPE_PIPELINE_RENDERING_CREATE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDERING_INFO_KHR, "VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDERING_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_RENDERING_FRAGMENT_SHADING_RATE_ATTACHMENT_INFO_KHR, "VK_STRUCTURE_TYPE_RENDERING_FRAGMENT_SHADING_RATE_ATTACHMENT_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_RENDERING_FRAGMENT_DENSITY_MAP_ATTACHMENT_INFO_EXT, "VK_STRUCTURE_TYPE_RENDERING_FRAGMENT_DENSITY_MAP_ATTACHMENT_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_ATTACHMENT_SAMPLE_COUNT_INFO_AMD, "VK_STRUCTURE_TYPE_ATTACHMENT_SAMPLE_COUNT_INFO_AMD" );
	swigIntConstant( VK_STRUCTURE_TYPE_MULTIVIEW_PER_VIEW_ATTRIBUTES_INFO_NVX, "VK_STRUCTURE_TYPE_MULTIVIEW_PER_VIEW_ATTRIBUTES_INFO_NVX" );
	swigIntConstant( VK_STRUCTURE_TYPE_STREAM_DESCRIPTOR_SURFACE_CREATE_INFO_GGP, "VK_STRUCTURE_TYPE_STREAM_DESCRIPTOR_SURFACE_CREATE_INFO_GGP" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CORNER_SAMPLED_IMAGE_FEATURES_NV, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CORNER_SAMPLED_IMAGE_FEATURES_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO_NV, "VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO_NV, "VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_IMPORT_MEMORY_WIN32_HANDLE_INFO_NV, "VK_STRUCTURE_TYPE_IMPORT_MEMORY_WIN32_HANDLE_INFO_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_EXPORT_MEMORY_WIN32_HANDLE_INFO_NV, "VK_STRUCTURE_TYPE_EXPORT_MEMORY_WIN32_HANDLE_INFO_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_NV, "VK_STRUCTURE_TYPE_WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_VALIDATION_FLAGS_EXT, "VK_STRUCTURE_TYPE_VALIDATION_FLAGS_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_VI_SURFACE_CREATE_INFO_NN, "VK_STRUCTURE_TYPE_VI_SURFACE_CREATE_INFO_NN" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_IMAGE_VIEW_ASTC_DECODE_MODE_EXT, "VK_STRUCTURE_TYPE_IMAGE_VIEW_ASTC_DECODE_MODE_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ASTC_DECODE_FEATURES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ASTC_DECODE_FEATURES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_IMPORT_MEMORY_WIN32_HANDLE_INFO_KHR, "VK_STRUCTURE_TYPE_IMPORT_MEMORY_WIN32_HANDLE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_EXPORT_MEMORY_WIN32_HANDLE_INFO_KHR, "VK_STRUCTURE_TYPE_EXPORT_MEMORY_WIN32_HANDLE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_MEMORY_WIN32_HANDLE_PROPERTIES_KHR, "VK_STRUCTURE_TYPE_MEMORY_WIN32_HANDLE_PROPERTIES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_MEMORY_GET_WIN32_HANDLE_INFO_KHR, "VK_STRUCTURE_TYPE_MEMORY_GET_WIN32_HANDLE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_IMPORT_MEMORY_FD_INFO_KHR, "VK_STRUCTURE_TYPE_IMPORT_MEMORY_FD_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_MEMORY_FD_PROPERTIES_KHR, "VK_STRUCTURE_TYPE_MEMORY_FD_PROPERTIES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_MEMORY_GET_FD_INFO_KHR, "VK_STRUCTURE_TYPE_MEMORY_GET_FD_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_KHR, "VK_STRUCTURE_TYPE_WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_IMPORT_SEMAPHORE_WIN32_HANDLE_INFO_KHR, "VK_STRUCTURE_TYPE_IMPORT_SEMAPHORE_WIN32_HANDLE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_WIN32_HANDLE_INFO_KHR, "VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_WIN32_HANDLE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_D3D12_FENCE_SUBMIT_INFO_KHR, "VK_STRUCTURE_TYPE_D3D12_FENCE_SUBMIT_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_SEMAPHORE_GET_WIN32_HANDLE_INFO_KHR, "VK_STRUCTURE_TYPE_SEMAPHORE_GET_WIN32_HANDLE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_IMPORT_SEMAPHORE_FD_INFO_KHR, "VK_STRUCTURE_TYPE_IMPORT_SEMAPHORE_FD_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_SEMAPHORE_GET_FD_INFO_KHR, "VK_STRUCTURE_TYPE_SEMAPHORE_GET_FD_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PUSH_DESCRIPTOR_PROPERTIES_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PUSH_DESCRIPTOR_PROPERTIES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_CONDITIONAL_RENDERING_INFO_EXT, "VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_CONDITIONAL_RENDERING_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_CONDITIONAL_RENDERING_BEGIN_INFO_EXT, "VK_STRUCTURE_TYPE_CONDITIONAL_RENDERING_BEGIN_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PRESENT_REGIONS_KHR, "VK_STRUCTURE_TYPE_PRESENT_REGIONS_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_W_SCALING_STATE_CREATE_INFO_NV, "VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_W_SCALING_STATE_CREATE_INFO_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_2_EXT, "VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_2_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_DISPLAY_POWER_INFO_EXT, "VK_STRUCTURE_TYPE_DISPLAY_POWER_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_DEVICE_EVENT_INFO_EXT, "VK_STRUCTURE_TYPE_DEVICE_EVENT_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_DISPLAY_EVENT_INFO_EXT, "VK_STRUCTURE_TYPE_DISPLAY_EVENT_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_SWAPCHAIN_COUNTER_CREATE_INFO_EXT, "VK_STRUCTURE_TYPE_SWAPCHAIN_COUNTER_CREATE_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PRESENT_TIMES_INFO_GOOGLE, "VK_STRUCTURE_TYPE_PRESENT_TIMES_INFO_GOOGLE" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PER_VIEW_ATTRIBUTES_PROPERTIES_NVX, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PER_VIEW_ATTRIBUTES_PROPERTIES_NVX" );
	swigIntConstant( VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_SWIZZLE_STATE_CREATE_INFO_NV, "VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_SWIZZLE_STATE_CREATE_INFO_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DISCARD_RECTANGLE_PROPERTIES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DISCARD_RECTANGLE_PROPERTIES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PIPELINE_DISCARD_RECTANGLE_STATE_CREATE_INFO_EXT, "VK_STRUCTURE_TYPE_PIPELINE_DISCARD_RECTANGLE_STATE_CREATE_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONSERVATIVE_RASTERIZATION_PROPERTIES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONSERVATIVE_RASTERIZATION_PROPERTIES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_CONSERVATIVE_STATE_CREATE_INFO_EXT, "VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_CONSERVATIVE_STATE_CREATE_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_DEPTH_CLIP_STATE_CREATE_INFO_EXT, "VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_DEPTH_CLIP_STATE_CREATE_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_HDR_METADATA_EXT, "VK_STRUCTURE_TYPE_HDR_METADATA_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_SHARED_PRESENT_SURFACE_CAPABILITIES_KHR, "VK_STRUCTURE_TYPE_SHARED_PRESENT_SURFACE_CAPABILITIES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_IMPORT_FENCE_WIN32_HANDLE_INFO_KHR, "VK_STRUCTURE_TYPE_IMPORT_FENCE_WIN32_HANDLE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_EXPORT_FENCE_WIN32_HANDLE_INFO_KHR, "VK_STRUCTURE_TYPE_EXPORT_FENCE_WIN32_HANDLE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_FENCE_GET_WIN32_HANDLE_INFO_KHR, "VK_STRUCTURE_TYPE_FENCE_GET_WIN32_HANDLE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_IMPORT_FENCE_FD_INFO_KHR, "VK_STRUCTURE_TYPE_IMPORT_FENCE_FD_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_FENCE_GET_FD_INFO_KHR, "VK_STRUCTURE_TYPE_FENCE_GET_FD_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PERFORMANCE_QUERY_FEATURES_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PERFORMANCE_QUERY_FEATURES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PERFORMANCE_QUERY_PROPERTIES_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PERFORMANCE_QUERY_PROPERTIES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_QUERY_POOL_PERFORMANCE_CREATE_INFO_KHR, "VK_STRUCTURE_TYPE_QUERY_POOL_PERFORMANCE_CREATE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PERFORMANCE_QUERY_SUBMIT_INFO_KHR, "VK_STRUCTURE_TYPE_PERFORMANCE_QUERY_SUBMIT_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_ACQUIRE_PROFILING_LOCK_INFO_KHR, "VK_STRUCTURE_TYPE_ACQUIRE_PROFILING_LOCK_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PERFORMANCE_COUNTER_KHR, "VK_STRUCTURE_TYPE_PERFORMANCE_COUNTER_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PERFORMANCE_COUNTER_DESCRIPTION_KHR, "VK_STRUCTURE_TYPE_PERFORMANCE_COUNTER_DESCRIPTION_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SURFACE_INFO_2_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SURFACE_INFO_2_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_2_KHR, "VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_2_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_SURFACE_FORMAT_2_KHR, "VK_STRUCTURE_TYPE_SURFACE_FORMAT_2_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_DISPLAY_PROPERTIES_2_KHR, "VK_STRUCTURE_TYPE_DISPLAY_PROPERTIES_2_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_DISPLAY_PLANE_PROPERTIES_2_KHR, "VK_STRUCTURE_TYPE_DISPLAY_PLANE_PROPERTIES_2_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_DISPLAY_MODE_PROPERTIES_2_KHR, "VK_STRUCTURE_TYPE_DISPLAY_MODE_PROPERTIES_2_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_DISPLAY_PLANE_INFO_2_KHR, "VK_STRUCTURE_TYPE_DISPLAY_PLANE_INFO_2_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_DISPLAY_PLANE_CAPABILITIES_2_KHR, "VK_STRUCTURE_TYPE_DISPLAY_PLANE_CAPABILITIES_2_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_IOS_SURFACE_CREATE_INFO_MVK, "VK_STRUCTURE_TYPE_IOS_SURFACE_CREATE_INFO_MVK" );
	swigIntConstant( VK_STRUCTURE_TYPE_MACOS_SURFACE_CREATE_INFO_MVK, "VK_STRUCTURE_TYPE_MACOS_SURFACE_CREATE_INFO_MVK" );
	swigIntConstant( VK_STRUCTURE_TYPE_DEBUG_UTILS_OBJECT_NAME_INFO_EXT, "VK_STRUCTURE_TYPE_DEBUG_UTILS_OBJECT_NAME_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_DEBUG_UTILS_OBJECT_TAG_INFO_EXT, "VK_STRUCTURE_TYPE_DEBUG_UTILS_OBJECT_TAG_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_DEBUG_UTILS_LABEL_EXT, "VK_STRUCTURE_TYPE_DEBUG_UTILS_LABEL_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_DEBUG_UTILS_MESSENGER_CALLBACK_DATA_EXT, "VK_STRUCTURE_TYPE_DEBUG_UTILS_MESSENGER_CALLBACK_DATA_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_DEBUG_UTILS_MESSENGER_CREATE_INFO_EXT, "VK_STRUCTURE_TYPE_DEBUG_UTILS_MESSENGER_CREATE_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_USAGE_ANDROID, "VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_USAGE_ANDROID" );
	swigIntConstant( VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_PROPERTIES_ANDROID, "VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_PROPERTIES_ANDROID" );
	swigIntConstant( VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_FORMAT_PROPERTIES_ANDROID, "VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_FORMAT_PROPERTIES_ANDROID" );
	swigIntConstant( VK_STRUCTURE_TYPE_IMPORT_ANDROID_HARDWARE_BUFFER_INFO_ANDROID, "VK_STRUCTURE_TYPE_IMPORT_ANDROID_HARDWARE_BUFFER_INFO_ANDROID" );
	swigIntConstant( VK_STRUCTURE_TYPE_MEMORY_GET_ANDROID_HARDWARE_BUFFER_INFO_ANDROID, "VK_STRUCTURE_TYPE_MEMORY_GET_ANDROID_HARDWARE_BUFFER_INFO_ANDROID" );
	swigIntConstant( VK_STRUCTURE_TYPE_EXTERNAL_FORMAT_ANDROID, "VK_STRUCTURE_TYPE_EXTERNAL_FORMAT_ANDROID" );
	swigIntConstant( VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_FORMAT_PROPERTIES_2_ANDROID, "VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_FORMAT_PROPERTIES_2_ANDROID" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_INLINE_UNIFORM_BLOCK_EXT, "VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_INLINE_UNIFORM_BLOCK_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_INLINE_UNIFORM_BLOCK_CREATE_INFO_EXT, "VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_INLINE_UNIFORM_BLOCK_CREATE_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_SAMPLE_LOCATIONS_INFO_EXT, "VK_STRUCTURE_TYPE_SAMPLE_LOCATIONS_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_RENDER_PASS_SAMPLE_LOCATIONS_BEGIN_INFO_EXT, "VK_STRUCTURE_TYPE_RENDER_PASS_SAMPLE_LOCATIONS_BEGIN_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PIPELINE_SAMPLE_LOCATIONS_STATE_CREATE_INFO_EXT, "VK_STRUCTURE_TYPE_PIPELINE_SAMPLE_LOCATIONS_STATE_CREATE_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLE_LOCATIONS_PROPERTIES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLE_LOCATIONS_PROPERTIES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_MULTISAMPLE_PROPERTIES_EXT, "VK_STRUCTURE_TYPE_MULTISAMPLE_PROPERTIES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_FEATURES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_FEATURES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_PROPERTIES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_PROPERTIES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PIPELINE_COLOR_BLEND_ADVANCED_STATE_CREATE_INFO_EXT, "VK_STRUCTURE_TYPE_PIPELINE_COLOR_BLEND_ADVANCED_STATE_CREATE_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PIPELINE_COVERAGE_TO_COLOR_STATE_CREATE_INFO_NV, "VK_STRUCTURE_TYPE_PIPELINE_COVERAGE_TO_COLOR_STATE_CREATE_INFO_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_ACCELERATION_STRUCTURE_KHR, "VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_ACCELERATION_STRUCTURE_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_BUILD_GEOMETRY_INFO_KHR, "VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_BUILD_GEOMETRY_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_DEVICE_ADDRESS_INFO_KHR, "VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_DEVICE_ADDRESS_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_AABBS_DATA_KHR, "VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_AABBS_DATA_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_INSTANCES_DATA_KHR, "VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_INSTANCES_DATA_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_TRIANGLES_DATA_KHR, "VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_TRIANGLES_DATA_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_KHR, "VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_VERSION_INFO_KHR, "VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_VERSION_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_COPY_ACCELERATION_STRUCTURE_INFO_KHR, "VK_STRUCTURE_TYPE_COPY_ACCELERATION_STRUCTURE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_COPY_ACCELERATION_STRUCTURE_TO_MEMORY_INFO_KHR, "VK_STRUCTURE_TYPE_COPY_ACCELERATION_STRUCTURE_TO_MEMORY_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_COPY_MEMORY_TO_ACCELERATION_STRUCTURE_INFO_KHR, "VK_STRUCTURE_TYPE_COPY_MEMORY_TO_ACCELERATION_STRUCTURE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_FEATURES_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_FEATURES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_PROPERTIES_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_PROPERTIES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CREATE_INFO_KHR, "VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CREATE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_BUILD_SIZES_INFO_KHR, "VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_BUILD_SIZES_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_FEATURES_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_FEATURES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_PROPERTIES_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_PROPERTIES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_RAY_TRACING_PIPELINE_CREATE_INFO_KHR, "VK_STRUCTURE_TYPE_RAY_TRACING_PIPELINE_CREATE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_RAY_TRACING_SHADER_GROUP_CREATE_INFO_KHR, "VK_STRUCTURE_TYPE_RAY_TRACING_SHADER_GROUP_CREATE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_RAY_TRACING_PIPELINE_INTERFACE_CREATE_INFO_KHR, "VK_STRUCTURE_TYPE_RAY_TRACING_PIPELINE_INTERFACE_CREATE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_QUERY_FEATURES_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_QUERY_FEATURES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PIPELINE_COVERAGE_MODULATION_STATE_CREATE_INFO_NV, "VK_STRUCTURE_TYPE_PIPELINE_COVERAGE_MODULATION_STATE_CREATE_INFO_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SM_BUILTINS_FEATURES_NV, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SM_BUILTINS_FEATURES_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SM_BUILTINS_PROPERTIES_NV, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SM_BUILTINS_PROPERTIES_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT, "VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_DRM_FORMAT_MODIFIER_INFO_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_DRM_FORMAT_MODIFIER_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_LIST_CREATE_INFO_EXT, "VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_LIST_CREATE_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_EXPLICIT_CREATE_INFO_EXT, "VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_EXPLICIT_CREATE_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_PROPERTIES_EXT, "VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_PROPERTIES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_2_EXT, "VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_2_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_VALIDATION_CACHE_CREATE_INFO_EXT, "VK_STRUCTURE_TYPE_VALIDATION_CACHE_CREATE_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_SHADER_MODULE_VALIDATION_CACHE_CREATE_INFO_EXT, "VK_STRUCTURE_TYPE_SHADER_MODULE_VALIDATION_CACHE_CREATE_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_SHADING_RATE_IMAGE_STATE_CREATE_INFO_NV, "VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_SHADING_RATE_IMAGE_STATE_CREATE_INFO_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADING_RATE_IMAGE_FEATURES_NV, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADING_RATE_IMAGE_FEATURES_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADING_RATE_IMAGE_PROPERTIES_NV, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADING_RATE_IMAGE_PROPERTIES_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_COARSE_SAMPLE_ORDER_STATE_CREATE_INFO_NV, "VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_COARSE_SAMPLE_ORDER_STATE_CREATE_INFO_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_RAY_TRACING_PIPELINE_CREATE_INFO_NV, "VK_STRUCTURE_TYPE_RAY_TRACING_PIPELINE_CREATE_INFO_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CREATE_INFO_NV, "VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CREATE_INFO_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_GEOMETRY_NV, "VK_STRUCTURE_TYPE_GEOMETRY_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_GEOMETRY_TRIANGLES_NV, "VK_STRUCTURE_TYPE_GEOMETRY_TRIANGLES_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_GEOMETRY_AABB_NV, "VK_STRUCTURE_TYPE_GEOMETRY_AABB_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_BIND_ACCELERATION_STRUCTURE_MEMORY_INFO_NV, "VK_STRUCTURE_TYPE_BIND_ACCELERATION_STRUCTURE_MEMORY_INFO_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_ACCELERATION_STRUCTURE_NV, "VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_ACCELERATION_STRUCTURE_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_INFO_NV, "VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_INFO_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PROPERTIES_NV, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PROPERTIES_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_RAY_TRACING_SHADER_GROUP_CREATE_INFO_NV, "VK_STRUCTURE_TYPE_RAY_TRACING_SHADER_GROUP_CREATE_INFO_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_INFO_NV, "VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_INFO_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_REPRESENTATIVE_FRAGMENT_TEST_FEATURES_NV, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_REPRESENTATIVE_FRAGMENT_TEST_FEATURES_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_PIPELINE_REPRESENTATIVE_FRAGMENT_TEST_STATE_CREATE_INFO_NV, "VK_STRUCTURE_TYPE_PIPELINE_REPRESENTATIVE_FRAGMENT_TEST_STATE_CREATE_INFO_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_IMAGE_FORMAT_INFO_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_IMAGE_FORMAT_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_FILTER_CUBIC_IMAGE_VIEW_IMAGE_FORMAT_PROPERTIES_EXT, "VK_STRUCTURE_TYPE_FILTER_CUBIC_IMAGE_VIEW_IMAGE_FORMAT_PROPERTIES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_DEVICE_QUEUE_GLOBAL_PRIORITY_CREATE_INFO_EXT, "VK_STRUCTURE_TYPE_DEVICE_QUEUE_GLOBAL_PRIORITY_CREATE_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_IMPORT_MEMORY_HOST_POINTER_INFO_EXT, "VK_STRUCTURE_TYPE_IMPORT_MEMORY_HOST_POINTER_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_MEMORY_HOST_POINTER_PROPERTIES_EXT, "VK_STRUCTURE_TYPE_MEMORY_HOST_POINTER_PROPERTIES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_MEMORY_HOST_PROPERTIES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_MEMORY_HOST_PROPERTIES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PIPELINE_COMPILER_CONTROL_CREATE_INFO_AMD, "VK_STRUCTURE_TYPE_PIPELINE_COMPILER_CONTROL_CREATE_INFO_AMD" );
	swigIntConstant( VK_STRUCTURE_TYPE_CALIBRATED_TIMESTAMP_INFO_EXT, "VK_STRUCTURE_TYPE_CALIBRATED_TIMESTAMP_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_AMD, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_AMD" );
	swigIntConstant( VK_STRUCTURE_TYPE_DEVICE_MEMORY_OVERALLOCATION_CREATE_INFO_AMD, "VK_STRUCTURE_TYPE_DEVICE_MEMORY_OVERALLOCATION_CREATE_INFO_AMD" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_DIVISOR_STATE_CREATE_INFO_EXT, "VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_DIVISOR_STATE_CREATE_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PRESENT_FRAME_TOKEN_GGP, "VK_STRUCTURE_TYPE_PRESENT_FRAME_TOKEN_GGP" );
	swigIntConstant( VK_STRUCTURE_TYPE_PIPELINE_CREATION_FEEDBACK_CREATE_INFO_EXT, "VK_STRUCTURE_TYPE_PIPELINE_CREATION_FEEDBACK_CREATE_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COMPUTE_SHADER_DERIVATIVES_FEATURES_NV, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COMPUTE_SHADER_DERIVATIVES_FEATURES_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_FEATURES_NV, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_FEATURES_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_PROPERTIES_NV, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_PROPERTIES_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_BARYCENTRIC_FEATURES_NV, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_BARYCENTRIC_FEATURES_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_FOOTPRINT_FEATURES_NV, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_FOOTPRINT_FEATURES_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_EXCLUSIVE_SCISSOR_STATE_CREATE_INFO_NV, "VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_EXCLUSIVE_SCISSOR_STATE_CREATE_INFO_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXCLUSIVE_SCISSOR_FEATURES_NV, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXCLUSIVE_SCISSOR_FEATURES_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_CHECKPOINT_DATA_NV, "VK_STRUCTURE_TYPE_CHECKPOINT_DATA_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_QUEUE_FAMILY_CHECKPOINT_PROPERTIES_NV, "VK_STRUCTURE_TYPE_QUEUE_FAMILY_CHECKPOINT_PROPERTIES_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_FUNCTIONS_2_FEATURES_INTEL, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_FUNCTIONS_2_FEATURES_INTEL" );
	swigIntConstant( VK_STRUCTURE_TYPE_QUERY_POOL_PERFORMANCE_QUERY_CREATE_INFO_INTEL, "VK_STRUCTURE_TYPE_QUERY_POOL_PERFORMANCE_QUERY_CREATE_INFO_INTEL" );
	swigIntConstant( VK_STRUCTURE_TYPE_INITIALIZE_PERFORMANCE_API_INFO_INTEL, "VK_STRUCTURE_TYPE_INITIALIZE_PERFORMANCE_API_INFO_INTEL" );
	swigIntConstant( VK_STRUCTURE_TYPE_PERFORMANCE_MARKER_INFO_INTEL, "VK_STRUCTURE_TYPE_PERFORMANCE_MARKER_INFO_INTEL" );
	swigIntConstant( VK_STRUCTURE_TYPE_PERFORMANCE_STREAM_MARKER_INFO_INTEL, "VK_STRUCTURE_TYPE_PERFORMANCE_STREAM_MARKER_INFO_INTEL" );
	swigIntConstant( VK_STRUCTURE_TYPE_PERFORMANCE_OVERRIDE_INFO_INTEL, "VK_STRUCTURE_TYPE_PERFORMANCE_OVERRIDE_INFO_INTEL" );
	swigIntConstant( VK_STRUCTURE_TYPE_PERFORMANCE_CONFIGURATION_ACQUIRE_INFO_INTEL, "VK_STRUCTURE_TYPE_PERFORMANCE_CONFIGURATION_ACQUIRE_INFO_INTEL" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PCI_BUS_INFO_PROPERTIES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PCI_BUS_INFO_PROPERTIES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_DISPLAY_NATIVE_HDR_SURFACE_CAPABILITIES_AMD, "VK_STRUCTURE_TYPE_DISPLAY_NATIVE_HDR_SURFACE_CAPABILITIES_AMD" );
	swigIntConstant( VK_STRUCTURE_TYPE_SWAPCHAIN_DISPLAY_NATIVE_HDR_CREATE_INFO_AMD, "VK_STRUCTURE_TYPE_SWAPCHAIN_DISPLAY_NATIVE_HDR_CREATE_INFO_AMD" );
	swigIntConstant( VK_STRUCTURE_TYPE_IMAGEPIPE_SURFACE_CREATE_INFO_FUCHSIA, "VK_STRUCTURE_TYPE_IMAGEPIPE_SURFACE_CREATE_INFO_FUCHSIA" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_METAL_SURFACE_CREATE_INFO_EXT, "VK_STRUCTURE_TYPE_METAL_SURFACE_CREATE_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_FEATURES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_FEATURES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_PROPERTIES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_PROPERTIES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_RENDER_PASS_FRAGMENT_DENSITY_MAP_CREATE_INFO_EXT, "VK_STRUCTURE_TYPE_RENDER_PASS_FRAGMENT_DENSITY_MAP_CREATE_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_REQUIRED_SUBGROUP_SIZE_CREATE_INFO_EXT, "VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_REQUIRED_SUBGROUP_SIZE_CREATE_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_FRAGMENT_SHADING_RATE_ATTACHMENT_INFO_KHR, "VK_STRUCTURE_TYPE_FRAGMENT_SHADING_RATE_ATTACHMENT_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PIPELINE_FRAGMENT_SHADING_RATE_STATE_CREATE_INFO_KHR, "VK_STRUCTURE_TYPE_PIPELINE_FRAGMENT_SHADING_RATE_STATE_CREATE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_PROPERTIES_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_PROPERTIES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_FEATURES_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_FEATURES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_2_AMD, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_2_AMD" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COHERENT_MEMORY_FEATURES_AMD, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COHERENT_MEMORY_FEATURES_AMD" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_ATOMIC_INT64_FEATURES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_ATOMIC_INT64_FEATURES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_BUDGET_PROPERTIES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_BUDGET_PROPERTIES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PRIORITY_FEATURES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PRIORITY_FEATURES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_MEMORY_PRIORITY_ALLOCATE_INFO_EXT, "VK_STRUCTURE_TYPE_MEMORY_PRIORITY_ALLOCATE_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_SURFACE_PROTECTED_CAPABILITIES_KHR, "VK_STRUCTURE_TYPE_SURFACE_PROTECTED_CAPABILITIES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEDICATED_ALLOCATION_IMAGE_ALIASING_FEATURES_NV, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEDICATED_ALLOCATION_IMAGE_ALIASING_FEATURES_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_CREATE_INFO_EXT, "VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_CREATE_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TOOL_PROPERTIES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TOOL_PROPERTIES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_VALIDATION_FEATURES_EXT, "VK_STRUCTURE_TYPE_VALIDATION_FEATURES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_WAIT_FEATURES_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_WAIT_FEATURES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_FEATURES_NV, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_FEATURES_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_COOPERATIVE_MATRIX_PROPERTIES_NV, "VK_STRUCTURE_TYPE_COOPERATIVE_MATRIX_PROPERTIES_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_PROPERTIES_NV, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_PROPERTIES_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COVERAGE_REDUCTION_MODE_FEATURES_NV, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COVERAGE_REDUCTION_MODE_FEATURES_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_PIPELINE_COVERAGE_REDUCTION_STATE_CREATE_INFO_NV, "VK_STRUCTURE_TYPE_PIPELINE_COVERAGE_REDUCTION_STATE_CREATE_INFO_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_FRAMEBUFFER_MIXED_SAMPLES_COMBINATION_NV, "VK_STRUCTURE_TYPE_FRAMEBUFFER_MIXED_SAMPLES_COMBINATION_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_IMAGE_ARRAYS_FEATURES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_IMAGE_ARRAYS_FEATURES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_PROVOKING_VERTEX_STATE_CREATE_INFO_EXT, "VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_PROVOKING_VERTEX_STATE_CREATE_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_PROPERTIES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_PROPERTIES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_SURFACE_FULL_SCREEN_EXCLUSIVE_INFO_EXT, "VK_STRUCTURE_TYPE_SURFACE_FULL_SCREEN_EXCLUSIVE_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_FULL_SCREEN_EXCLUSIVE_EXT, "VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_FULL_SCREEN_EXCLUSIVE_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_SURFACE_FULL_SCREEN_EXCLUSIVE_WIN32_INFO_EXT, "VK_STRUCTURE_TYPE_SURFACE_FULL_SCREEN_EXCLUSIVE_WIN32_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_HEADLESS_SURFACE_CREATE_INFO_EXT, "VK_STRUCTURE_TYPE_HEADLESS_SURFACE_CREATE_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_LINE_STATE_CREATE_INFO_EXT, "VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_LINE_STATE_CREATE_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_PROPERTIES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_PROPERTIES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_FEATURES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_FEATURES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_EXECUTABLE_PROPERTIES_FEATURES_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_EXECUTABLE_PROPERTIES_FEATURES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PIPELINE_INFO_KHR, "VK_STRUCTURE_TYPE_PIPELINE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_PROPERTIES_KHR, "VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_PROPERTIES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_INFO_KHR, "VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_STATISTIC_KHR, "VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_STATISTIC_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_INTERNAL_REPRESENTATION_KHR, "VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_INTERNAL_REPRESENTATION_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_2_FEATURES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_2_FEATURES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_PROPERTIES_NV, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_PROPERTIES_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_GRAPHICS_SHADER_GROUP_CREATE_INFO_NV, "VK_STRUCTURE_TYPE_GRAPHICS_SHADER_GROUP_CREATE_INFO_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_SHADER_GROUPS_CREATE_INFO_NV, "VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_SHADER_GROUPS_CREATE_INFO_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_INDIRECT_COMMANDS_LAYOUT_TOKEN_NV, "VK_STRUCTURE_TYPE_INDIRECT_COMMANDS_LAYOUT_TOKEN_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_INDIRECT_COMMANDS_LAYOUT_CREATE_INFO_NV, "VK_STRUCTURE_TYPE_INDIRECT_COMMANDS_LAYOUT_CREATE_INFO_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_GENERATED_COMMANDS_INFO_NV, "VK_STRUCTURE_TYPE_GENERATED_COMMANDS_INFO_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_GENERATED_COMMANDS_MEMORY_REQUIREMENTS_INFO_NV, "VK_STRUCTURE_TYPE_GENERATED_COMMANDS_MEMORY_REQUIREMENTS_INFO_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_FEATURES_NV, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_FEATURES_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INHERITED_VIEWPORT_SCISSOR_FEATURES_NV, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INHERITED_VIEWPORT_SCISSOR_FEATURES_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_VIEWPORT_SCISSOR_INFO_NV, "VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_VIEWPORT_SCISSOR_INFO_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDER_PASS_TRANSFORM_INFO_QCOM, "VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDER_PASS_TRANSFORM_INFO_QCOM" );
	swigIntConstant( VK_STRUCTURE_TYPE_RENDER_PASS_TRANSFORM_BEGIN_INFO_QCOM, "VK_STRUCTURE_TYPE_RENDER_PASS_TRANSFORM_BEGIN_INFO_QCOM" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_MEMORY_REPORT_FEATURES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_MEMORY_REPORT_FEATURES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_DEVICE_DEVICE_MEMORY_REPORT_CREATE_INFO_EXT, "VK_STRUCTURE_TYPE_DEVICE_DEVICE_MEMORY_REPORT_CREATE_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_DEVICE_MEMORY_REPORT_CALLBACK_DATA_EXT, "VK_STRUCTURE_TYPE_DEVICE_MEMORY_REPORT_CALLBACK_DATA_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_PROPERTIES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_PROPERTIES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_SAMPLER_CUSTOM_BORDER_COLOR_CREATE_INFO_EXT, "VK_STRUCTURE_TYPE_SAMPLER_CUSTOM_BORDER_COLOR_CREATE_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_PROPERTIES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_PROPERTIES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PIPELINE_LIBRARY_CREATE_INFO_KHR, "VK_STRUCTURE_TYPE_PIPELINE_LIBRARY_CREATE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PRESENT_ID_KHR, "VK_STRUCTURE_TYPE_PRESENT_ID_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_ID_FEATURES_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_ID_FEATURES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_DEVICE_PRIVATE_DATA_CREATE_INFO_EXT, "VK_STRUCTURE_TYPE_DEVICE_PRIVATE_DATA_CREATE_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PRIVATE_DATA_SLOT_CREATE_INFO_EXT, "VK_STRUCTURE_TYPE_PRIVATE_DATA_SLOT_CREATE_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DIAGNOSTICS_CONFIG_FEATURES_NV, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DIAGNOSTICS_CONFIG_FEATURES_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_DEVICE_DIAGNOSTICS_CONFIG_CREATE_INFO_NV, "VK_STRUCTURE_TYPE_DEVICE_DIAGNOSTICS_CONFIG_CREATE_INFO_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_MEMORY_BARRIER_2_KHR, "VK_STRUCTURE_TYPE_MEMORY_BARRIER_2_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER_2_KHR, "VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER_2_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER_2_KHR, "VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER_2_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_DEPENDENCY_INFO_KHR, "VK_STRUCTURE_TYPE_DEPENDENCY_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_SUBMIT_INFO_2_KHR, "VK_STRUCTURE_TYPE_SUBMIT_INFO_2_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_SEMAPHORE_SUBMIT_INFO_KHR, "VK_STRUCTURE_TYPE_SEMAPHORE_SUBMIT_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_COMMAND_BUFFER_SUBMIT_INFO_KHR, "VK_STRUCTURE_TYPE_COMMAND_BUFFER_SUBMIT_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_QUEUE_FAMILY_CHECKPOINT_PROPERTIES_2_NV, "VK_STRUCTURE_TYPE_QUEUE_FAMILY_CHECKPOINT_PROPERTIES_2_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_CHECKPOINT_DATA_2_NV, "VK_STRUCTURE_TYPE_CHECKPOINT_DATA_2_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_UNIFORM_CONTROL_FLOW_FEATURES_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_UNIFORM_CONTROL_FLOW_FEATURES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_ENUMS_PROPERTIES_NV, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_ENUMS_PROPERTIES_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_ENUMS_FEATURES_NV, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_ENUMS_FEATURES_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_PIPELINE_FRAGMENT_SHADING_RATE_ENUM_STATE_CREATE_INFO_NV, "VK_STRUCTURE_TYPE_PIPELINE_FRAGMENT_SHADING_RATE_ENUM_STATE_CREATE_INFO_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_MOTION_TRIANGLES_DATA_NV, "VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_MOTION_TRIANGLES_DATA_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_MOTION_BLUR_FEATURES_NV, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_MOTION_BLUR_FEATURES_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_MOTION_INFO_NV, "VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_MOTION_INFO_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_2_FEATURES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_2_FEATURES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_2_PROPERTIES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_2_PROPERTIES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_COPY_COMMAND_TRANSFORM_INFO_QCOM, "VK_STRUCTURE_TYPE_COPY_COMMAND_TRANSFORM_INFO_QCOM" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_WORKGROUP_MEMORY_EXPLICIT_LAYOUT_FEATURES_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_WORKGROUP_MEMORY_EXPLICIT_LAYOUT_FEATURES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_COPY_BUFFER_INFO_2_KHR, "VK_STRUCTURE_TYPE_COPY_BUFFER_INFO_2_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_COPY_IMAGE_INFO_2_KHR, "VK_STRUCTURE_TYPE_COPY_IMAGE_INFO_2_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_COPY_BUFFER_TO_IMAGE_INFO_2_KHR, "VK_STRUCTURE_TYPE_COPY_BUFFER_TO_IMAGE_INFO_2_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_COPY_IMAGE_TO_BUFFER_INFO_2_KHR, "VK_STRUCTURE_TYPE_COPY_IMAGE_TO_BUFFER_INFO_2_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_BLIT_IMAGE_INFO_2_KHR, "VK_STRUCTURE_TYPE_BLIT_IMAGE_INFO_2_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_RESOLVE_IMAGE_INFO_2_KHR, "VK_STRUCTURE_TYPE_RESOLVE_IMAGE_INFO_2_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_BUFFER_COPY_2_KHR, "VK_STRUCTURE_TYPE_BUFFER_COPY_2_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_IMAGE_COPY_2_KHR, "VK_STRUCTURE_TYPE_IMAGE_COPY_2_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_IMAGE_BLIT_2_KHR, "VK_STRUCTURE_TYPE_IMAGE_BLIT_2_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_BUFFER_IMAGE_COPY_2_KHR, "VK_STRUCTURE_TYPE_BUFFER_IMAGE_COPY_2_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_IMAGE_RESOLVE_2_KHR, "VK_STRUCTURE_TYPE_IMAGE_RESOLVE_2_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RGBA10X6_FORMATS_FEATURES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RGBA10X6_FORMATS_FEATURES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_DIRECTFB_SURFACE_CREATE_INFO_EXT, "VK_STRUCTURE_TYPE_DIRECTFB_SURFACE_CREATE_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MUTABLE_DESCRIPTOR_TYPE_FEATURES_VALVE, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MUTABLE_DESCRIPTOR_TYPE_FEATURES_VALVE" );
	swigIntConstant( VK_STRUCTURE_TYPE_MUTABLE_DESCRIPTOR_TYPE_CREATE_INFO_VALVE, "VK_STRUCTURE_TYPE_MUTABLE_DESCRIPTOR_TYPE_CREATE_INFO_VALVE" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_INPUT_DYNAMIC_STATE_FEATURES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_INPUT_DYNAMIC_STATE_FEATURES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_VERTEX_INPUT_BINDING_DESCRIPTION_2_EXT, "VK_STRUCTURE_TYPE_VERTEX_INPUT_BINDING_DESCRIPTION_2_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_VERTEX_INPUT_ATTRIBUTE_DESCRIPTION_2_EXT, "VK_STRUCTURE_TYPE_VERTEX_INPUT_ATTRIBUTE_DESCRIPTION_2_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRM_PROPERTIES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRM_PROPERTIES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_3_KHR, "VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_3_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_IMPORT_MEMORY_ZIRCON_HANDLE_INFO_FUCHSIA, "VK_STRUCTURE_TYPE_IMPORT_MEMORY_ZIRCON_HANDLE_INFO_FUCHSIA" );
	swigIntConstant( VK_STRUCTURE_TYPE_MEMORY_ZIRCON_HANDLE_PROPERTIES_FUCHSIA, "VK_STRUCTURE_TYPE_MEMORY_ZIRCON_HANDLE_PROPERTIES_FUCHSIA" );
	swigIntConstant( VK_STRUCTURE_TYPE_MEMORY_GET_ZIRCON_HANDLE_INFO_FUCHSIA, "VK_STRUCTURE_TYPE_MEMORY_GET_ZIRCON_HANDLE_INFO_FUCHSIA" );
	swigIntConstant( VK_STRUCTURE_TYPE_IMPORT_SEMAPHORE_ZIRCON_HANDLE_INFO_FUCHSIA, "VK_STRUCTURE_TYPE_IMPORT_SEMAPHORE_ZIRCON_HANDLE_INFO_FUCHSIA" );
	swigIntConstant( VK_STRUCTURE_TYPE_SEMAPHORE_GET_ZIRCON_HANDLE_INFO_FUCHSIA, "VK_STRUCTURE_TYPE_SEMAPHORE_GET_ZIRCON_HANDLE_INFO_FUCHSIA" );
	swigIntConstant( VK_STRUCTURE_TYPE_BUFFER_COLLECTION_CREATE_INFO_FUCHSIA, "VK_STRUCTURE_TYPE_BUFFER_COLLECTION_CREATE_INFO_FUCHSIA" );
	swigIntConstant( VK_STRUCTURE_TYPE_IMPORT_MEMORY_BUFFER_COLLECTION_FUCHSIA, "VK_STRUCTURE_TYPE_IMPORT_MEMORY_BUFFER_COLLECTION_FUCHSIA" );
	swigIntConstant( VK_STRUCTURE_TYPE_BUFFER_COLLECTION_IMAGE_CREATE_INFO_FUCHSIA, "VK_STRUCTURE_TYPE_BUFFER_COLLECTION_IMAGE_CREATE_INFO_FUCHSIA" );
	swigIntConstant( VK_STRUCTURE_TYPE_BUFFER_COLLECTION_PROPERTIES_FUCHSIA, "VK_STRUCTURE_TYPE_BUFFER_COLLECTION_PROPERTIES_FUCHSIA" );
	swigIntConstant( VK_STRUCTURE_TYPE_BUFFER_CONSTRAINTS_INFO_FUCHSIA, "VK_STRUCTURE_TYPE_BUFFER_CONSTRAINTS_INFO_FUCHSIA" );
	swigIntConstant( VK_STRUCTURE_TYPE_BUFFER_COLLECTION_BUFFER_CREATE_INFO_FUCHSIA, "VK_STRUCTURE_TYPE_BUFFER_COLLECTION_BUFFER_CREATE_INFO_FUCHSIA" );
	swigIntConstant( VK_STRUCTURE_TYPE_IMAGE_CONSTRAINTS_INFO_FUCHSIA, "VK_STRUCTURE_TYPE_IMAGE_CONSTRAINTS_INFO_FUCHSIA" );
	swigIntConstant( VK_STRUCTURE_TYPE_IMAGE_FORMAT_CONSTRAINTS_INFO_FUCHSIA, "VK_STRUCTURE_TYPE_IMAGE_FORMAT_CONSTRAINTS_INFO_FUCHSIA" );
	swigIntConstant( VK_STRUCTURE_TYPE_SYSMEM_COLOR_SPACE_FUCHSIA, "VK_STRUCTURE_TYPE_SYSMEM_COLOR_SPACE_FUCHSIA" );
	swigIntConstant( VK_STRUCTURE_TYPE_BUFFER_COLLECTION_CONSTRAINTS_INFO_FUCHSIA, "VK_STRUCTURE_TYPE_BUFFER_COLLECTION_CONSTRAINTS_INFO_FUCHSIA" );
	swigIntConstant( VK_STRUCTURE_TYPE_SUBPASS_SHADING_PIPELINE_CREATE_INFO_HUAWEI, "VK_STRUCTURE_TYPE_SUBPASS_SHADING_PIPELINE_CREATE_INFO_HUAWEI" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBPASS_SHADING_FEATURES_HUAWEI, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBPASS_SHADING_FEATURES_HUAWEI" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBPASS_SHADING_PROPERTIES_HUAWEI, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBPASS_SHADING_PROPERTIES_HUAWEI" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INVOCATION_MASK_FEATURES_HUAWEI, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INVOCATION_MASK_FEATURES_HUAWEI" );
	swigIntConstant( VK_STRUCTURE_TYPE_MEMORY_GET_REMOTE_ADDRESS_INFO_NV, "VK_STRUCTURE_TYPE_MEMORY_GET_REMOTE_ADDRESS_INFO_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_MEMORY_RDMA_FEATURES_NV, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_MEMORY_RDMA_FEATURES_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_SCREEN_SURFACE_CREATE_INFO_QNX, "VK_STRUCTURE_TYPE_SCREEN_SURFACE_CREATE_INFO_QNX" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PIPELINE_COLOR_WRITE_CREATE_INFO_EXT, "VK_STRUCTURE_TYPE_PIPELINE_COLOR_WRITE_CREATE_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GLOBAL_PRIORITY_QUERY_FEATURES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GLOBAL_PRIORITY_QUERY_FEATURES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_QUEUE_FAMILY_GLOBAL_PRIORITY_PROPERTIES_EXT, "VK_STRUCTURE_TYPE_QUEUE_FAMILY_GLOBAL_PRIORITY_PROPERTIES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_FEATURES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_FEATURES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_PROPERTIES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_PROPERTIES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BORDER_COLOR_SWIZZLE_FEATURES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BORDER_COLOR_SWIZZLE_FEATURES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_SAMPLER_BORDER_COLOR_COMPONENT_MAPPING_CREATE_INFO_EXT, "VK_STRUCTURE_TYPE_SAMPLER_BORDER_COLOR_COMPONENT_MAPPING_CREATE_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PAGEABLE_DEVICE_LOCAL_MEMORY_FEATURES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PAGEABLE_DEVICE_LOCAL_MEMORY_FEATURES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_DEVICE_BUFFER_MEMORY_REQUIREMENTS_KHR, "VK_STRUCTURE_TYPE_DEVICE_BUFFER_MEMORY_REQUIREMENTS_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_DEVICE_IMAGE_MEMORY_REQUIREMENTS_KHR, "VK_STRUCTURE_TYPE_DEVICE_IMAGE_MEMORY_REQUIREMENTS_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTER_FEATURES, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTER_FEATURES" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETER_FEATURES, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETER_FEATURES" );
	swigIntConstant( VK_STRUCTURE_TYPE_DEBUG_REPORT_CREATE_INFO_EXT, "VK_STRUCTURE_TYPE_DEBUG_REPORT_CREATE_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_ATTACHMENT_SAMPLE_COUNT_INFO_NV, "VK_STRUCTURE_TYPE_ATTACHMENT_SAMPLE_COUNT_INFO_NV" );
	swigIntConstant( VK_STRUCTURE_TYPE_RENDER_PASS_MULTIVIEW_CREATE_INFO_KHR, "VK_STRUCTURE_TYPE_RENDER_PASS_MULTIVIEW_CREATE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_2_KHR, "VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_2_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_IMAGE_FORMAT_PROPERTIES_2_KHR, "VK_STRUCTURE_TYPE_IMAGE_FORMAT_PROPERTIES_2_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_FORMAT_INFO_2_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_FORMAT_INFO_2_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_QUEUE_FAMILY_PROPERTIES_2_KHR, "VK_STRUCTURE_TYPE_QUEUE_FAMILY_PROPERTIES_2_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PROPERTIES_2_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PROPERTIES_2_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_SPARSE_IMAGE_FORMAT_PROPERTIES_2_KHR, "VK_STRUCTURE_TYPE_SPARSE_IMAGE_FORMAT_PROPERTIES_2_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SPARSE_IMAGE_FORMAT_INFO_2_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SPARSE_IMAGE_FORMAT_INFO_2_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_FLAGS_INFO_KHR, "VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_FLAGS_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO_KHR, "VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO_KHR, "VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_DEVICE_GROUP_SUBMIT_INFO_KHR, "VK_STRUCTURE_TYPE_DEVICE_GROUP_SUBMIT_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_DEVICE_GROUP_BIND_SPARSE_INFO_KHR, "VK_STRUCTURE_TYPE_DEVICE_GROUP_BIND_SPARSE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO_KHR, "VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO_KHR, "VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GROUP_PROPERTIES_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GROUP_PROPERTIES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO_KHR, "VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES_KHR, "VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_BUFFER_INFO_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_BUFFER_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_EXTERNAL_BUFFER_PROPERTIES_KHR, "VK_STRUCTURE_TYPE_EXTERNAL_BUFFER_PROPERTIES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO_KHR, "VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO_KHR, "VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO_KHR, "VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_SEMAPHORE_INFO_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_SEMAPHORE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_EXTERNAL_SEMAPHORE_PROPERTIES_KHR, "VK_STRUCTURE_TYPE_EXTERNAL_SEMAPHORE_PROPERTIES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_CREATE_INFO_KHR, "VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_CREATE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT16_INT8_FEATURES_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT16_INT8_FEATURES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_CREATE_INFO_KHR, "VK_STRUCTURE_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_CREATE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES2_EXT, "VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES2_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO_KHR, "VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENT_IMAGE_INFO_KHR, "VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENT_IMAGE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO_KHR, "VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_2_KHR, "VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_2_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2_KHR, "VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_2_KHR, "VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_2_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_SUBPASS_DEPENDENCY_2_KHR, "VK_STRUCTURE_TYPE_SUBPASS_DEPENDENCY_2_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO_2_KHR, "VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO_2_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_SUBPASS_BEGIN_INFO_KHR, "VK_STRUCTURE_TYPE_SUBPASS_BEGIN_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_SUBPASS_END_INFO_KHR, "VK_STRUCTURE_TYPE_SUBPASS_END_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FENCE_INFO_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FENCE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_EXTERNAL_FENCE_PROPERTIES_KHR, "VK_STRUCTURE_TYPE_EXTERNAL_FENCE_PROPERTIES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO_KHR, "VK_STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO_KHR, "VK_STRUCTURE_TYPE_RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_IMAGE_VIEW_USAGE_CREATE_INFO_KHR, "VK_STRUCTURE_TYPE_IMAGE_VIEW_USAGE_CREATE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO_KHR, "VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTER_FEATURES_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTER_FEATURES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS_KHR, "VK_STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_MEMORY_DEDICATED_ALLOCATE_INFO_KHR, "VK_STRUCTURE_TYPE_MEMORY_DEDICATED_ALLOCATE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_SAMPLER_REDUCTION_MODE_CREATE_INFO_EXT, "VK_STRUCTURE_TYPE_SAMPLER_REDUCTION_MODE_CREATE_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_BUFFER_MEMORY_REQUIREMENTS_INFO_2_KHR, "VK_STRUCTURE_TYPE_BUFFER_MEMORY_REQUIREMENTS_INFO_2_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_IMAGE_MEMORY_REQUIREMENTS_INFO_2_KHR, "VK_STRUCTURE_TYPE_IMAGE_MEMORY_REQUIREMENTS_INFO_2_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_IMAGE_SPARSE_MEMORY_REQUIREMENTS_INFO_2_KHR, "VK_STRUCTURE_TYPE_IMAGE_SPARSE_MEMORY_REQUIREMENTS_INFO_2_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_MEMORY_REQUIREMENTS_2_KHR, "VK_STRUCTURE_TYPE_MEMORY_REQUIREMENTS_2_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_SPARSE_IMAGE_MEMORY_REQUIREMENTS_2_KHR, "VK_STRUCTURE_TYPE_SPARSE_IMAGE_MEMORY_REQUIREMENTS_2_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO_KHR, "VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_CREATE_INFO_KHR, "VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_CREATE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_INFO_KHR, "VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO_KHR, "VK_STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO_KHR, "VK_STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES_KHR, "VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_INFO_KHR, "VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_INFO_KHR, "VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_BINDING_FLAGS_CREATE_INFO_EXT, "VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_BINDING_FLAGS_CREATE_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO_EXT, "VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_LAYOUT_SUPPORT_EXT, "VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_LAYOUT_SUPPORT_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_SUPPORT_KHR, "VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_SUPPORT_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE_KHR, "VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO_KHR, "VK_STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_TIMELINE_SEMAPHORE_SUBMIT_INFO_KHR, "VK_STRUCTURE_TYPE_TIMELINE_SEMAPHORE_SUBMIT_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_SEMAPHORE_WAIT_INFO_KHR, "VK_STRUCTURE_TYPE_SEMAPHORE_WAIT_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_SEMAPHORE_SIGNAL_INFO_KHR, "VK_STRUCTURE_TYPE_SEMAPHORE_SIGNAL_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_QUERY_POOL_CREATE_INFO_INTEL, "VK_STRUCTURE_TYPE_QUERY_POOL_CREATE_INFO_INTEL" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT_KHR, "VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT_KHR, "VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_ADDRESS_FEATURES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_ADDRESS_FEATURES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_INFO_EXT, "VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO_EXT, "VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES_KHR, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_INFO_KHR, "VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO_KHR, "VK_STRUCTURE_TYPE_BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_MEMORY_OPAQUE_CAPTURE_ADDRESS_ALLOCATE_INFO_KHR, "VK_STRUCTURE_TYPE_MEMORY_OPAQUE_CAPTURE_ADDRESS_ALLOCATE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_DEVICE_MEMORY_OPAQUE_CAPTURE_ADDRESS_INFO_KHR, "VK_STRUCTURE_TYPE_DEVICE_MEMORY_OPAQUE_CAPTURE_ADDRESS_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES_EXT, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_MAX_ENUM, "VK_STRUCTURE_TYPE_MAX_ENUM" );
	swigIntConstant( VK_IMAGE_LAYOUT_UNDEFINED, "VK_IMAGE_LAYOUT_UNDEFINED" );
	swigIntConstant( VK_IMAGE_LAYOUT_GENERAL, "VK_IMAGE_LAYOUT_GENERAL" );
	swigIntConstant( VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL, "VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL" );
	swigIntConstant( VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL, "VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL" );
	swigIntConstant( VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL, "VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL" );
	swigIntConstant( VK_IMAGE_LAYOUT_SHADER_READ_ONLY_OPTIMAL, "VK_IMAGE_LAYOUT_SHADER_READ_ONLY_OPTIMAL" );
	swigIntConstant( VK_IMAGE_LAYOUT_TRANSFER_SRC_OPTIMAL, "VK_IMAGE_LAYOUT_TRANSFER_SRC_OPTIMAL" );
	swigIntConstant( VK_IMAGE_LAYOUT_TRANSFER_DST_OPTIMAL, "VK_IMAGE_LAYOUT_TRANSFER_DST_OPTIMAL" );
	swigIntConstant( VK_IMAGE_LAYOUT_PREINITIALIZED, "VK_IMAGE_LAYOUT_PREINITIALIZED" );
	swigIntConstant( VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL, "VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL" );
	swigIntConstant( VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL, "VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL" );
	swigIntConstant( VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, "VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL" );
	swigIntConstant( VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, "VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL" );
	swigIntConstant( VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, "VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL" );
	swigIntConstant( VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL, "VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL" );
	swigIntConstant( VK_IMAGE_LAYOUT_PRESENT_SRC_KHR, "VK_IMAGE_LAYOUT_PRESENT_SRC_KHR" );
	swigIntConstant( VK_IMAGE_LAYOUT_SHARED_PRESENT_KHR, "VK_IMAGE_LAYOUT_SHARED_PRESENT_KHR" );
	swigIntConstant( VK_IMAGE_LAYOUT_FRAGMENT_DENSITY_MAP_OPTIMAL_EXT, "VK_IMAGE_LAYOUT_FRAGMENT_DENSITY_MAP_OPTIMAL_EXT" );
	swigIntConstant( VK_IMAGE_LAYOUT_FRAGMENT_SHADING_RATE_ATTACHMENT_OPTIMAL_KHR, "VK_IMAGE_LAYOUT_FRAGMENT_SHADING_RATE_ATTACHMENT_OPTIMAL_KHR" );
	swigIntConstant( VK_IMAGE_LAYOUT_READ_ONLY_OPTIMAL_KHR, "VK_IMAGE_LAYOUT_READ_ONLY_OPTIMAL_KHR" );
	swigIntConstant( VK_IMAGE_LAYOUT_ATTACHMENT_OPTIMAL_KHR, "VK_IMAGE_LAYOUT_ATTACHMENT_OPTIMAL_KHR" );
	swigIntConstant( VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL_KHR, "VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL_KHR" );
	swigIntConstant( VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL_KHR, "VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL_KHR" );
	swigIntConstant( VK_IMAGE_LAYOUT_SHADING_RATE_OPTIMAL_NV, "VK_IMAGE_LAYOUT_SHADING_RATE_OPTIMAL_NV" );
	swigIntConstant( VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL_KHR, "VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL_KHR" );
	swigIntConstant( VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL_KHR, "VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL_KHR" );
	swigIntConstant( VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL_KHR, "VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL_KHR" );
	swigIntConstant( VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL_KHR, "VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL_KHR" );
	swigIntConstant( VK_IMAGE_LAYOUT_MAX_ENUM, "VK_IMAGE_LAYOUT_MAX_ENUM" );
	swigIntConstant( VK_OBJECT_TYPE_UNKNOWN, "VK_OBJECT_TYPE_UNKNOWN" );
	swigIntConstant( VK_OBJECT_TYPE_INSTANCE, "VK_OBJECT_TYPE_INSTANCE" );
	swigIntConstant( VK_OBJECT_TYPE_PHYSICAL_DEVICE, "VK_OBJECT_TYPE_PHYSICAL_DEVICE" );
	swigIntConstant( VK_OBJECT_TYPE_DEVICE, "VK_OBJECT_TYPE_DEVICE" );
	swigIntConstant( VK_OBJECT_TYPE_QUEUE, "VK_OBJECT_TYPE_QUEUE" );
	swigIntConstant( VK_OBJECT_TYPE_SEMAPHORE, "VK_OBJECT_TYPE_SEMAPHORE" );
	swigIntConstant( VK_OBJECT_TYPE_COMMAND_BUFFER, "VK_OBJECT_TYPE_COMMAND_BUFFER" );
	swigIntConstant( VK_OBJECT_TYPE_FENCE, "VK_OBJECT_TYPE_FENCE" );
	swigIntConstant( VK_OBJECT_TYPE_DEVICE_MEMORY, "VK_OBJECT_TYPE_DEVICE_MEMORY" );
	swigIntConstant( VK_OBJECT_TYPE_BUFFER, "VK_OBJECT_TYPE_BUFFER" );
	swigIntConstant( VK_OBJECT_TYPE_IMAGE, "VK_OBJECT_TYPE_IMAGE" );
	swigIntConstant( VK_OBJECT_TYPE_EVENT, "VK_OBJECT_TYPE_EVENT" );
	swigIntConstant( VK_OBJECT_TYPE_QUERY_POOL, "VK_OBJECT_TYPE_QUERY_POOL" );
	swigIntConstant( VK_OBJECT_TYPE_BUFFER_VIEW, "VK_OBJECT_TYPE_BUFFER_VIEW" );
	swigIntConstant( VK_OBJECT_TYPE_IMAGE_VIEW, "VK_OBJECT_TYPE_IMAGE_VIEW" );
	swigIntConstant( VK_OBJECT_TYPE_SHADER_MODULE, "VK_OBJECT_TYPE_SHADER_MODULE" );
	swigIntConstant( VK_OBJECT_TYPE_PIPELINE_CACHE, "VK_OBJECT_TYPE_PIPELINE_CACHE" );
	swigIntConstant( VK_OBJECT_TYPE_PIPELINE_LAYOUT, "VK_OBJECT_TYPE_PIPELINE_LAYOUT" );
	swigIntConstant( VK_OBJECT_TYPE_RENDER_PASS, "VK_OBJECT_TYPE_RENDER_PASS" );
	swigIntConstant( VK_OBJECT_TYPE_PIPELINE, "VK_OBJECT_TYPE_PIPELINE" );
	swigIntConstant( VK_OBJECT_TYPE_DESCRIPTOR_SET_LAYOUT, "VK_OBJECT_TYPE_DESCRIPTOR_SET_LAYOUT" );
	swigIntConstant( VK_OBJECT_TYPE_SAMPLER, "VK_OBJECT_TYPE_SAMPLER" );
	swigIntConstant( VK_OBJECT_TYPE_DESCRIPTOR_POOL, "VK_OBJECT_TYPE_DESCRIPTOR_POOL" );
	swigIntConstant( VK_OBJECT_TYPE_DESCRIPTOR_SET, "VK_OBJECT_TYPE_DESCRIPTOR_SET" );
	swigIntConstant( VK_OBJECT_TYPE_FRAMEBUFFER, "VK_OBJECT_TYPE_FRAMEBUFFER" );
	swigIntConstant( VK_OBJECT_TYPE_COMMAND_POOL, "VK_OBJECT_TYPE_COMMAND_POOL" );
	swigIntConstant( VK_OBJECT_TYPE_SAMPLER_YCBCR_CONVERSION, "VK_OBJECT_TYPE_SAMPLER_YCBCR_CONVERSION" );
	swigIntConstant( VK_OBJECT_TYPE_DESCRIPTOR_UPDATE_TEMPLATE, "VK_OBJECT_TYPE_DESCRIPTOR_UPDATE_TEMPLATE" );
	swigIntConstant( VK_OBJECT_TYPE_SURFACE_KHR, "VK_OBJECT_TYPE_SURFACE_KHR" );
	swigIntConstant( VK_OBJECT_TYPE_SWAPCHAIN_KHR, "VK_OBJECT_TYPE_SWAPCHAIN_KHR" );
	swigIntConstant( VK_OBJECT_TYPE_DISPLAY_KHR, "VK_OBJECT_TYPE_DISPLAY_KHR" );
	swigIntConstant( VK_OBJECT_TYPE_DISPLAY_MODE_KHR, "VK_OBJECT_TYPE_DISPLAY_MODE_KHR" );
	swigIntConstant( VK_OBJECT_TYPE_DEBUG_REPORT_CALLBACK_EXT, "VK_OBJECT_TYPE_DEBUG_REPORT_CALLBACK_EXT" );
	swigIntConstant( VK_OBJECT_TYPE_CU_MODULE_NVX, "VK_OBJECT_TYPE_CU_MODULE_NVX" );
	swigIntConstant( VK_OBJECT_TYPE_CU_FUNCTION_NVX, "VK_OBJECT_TYPE_CU_FUNCTION_NVX" );
	swigIntConstant( VK_OBJECT_TYPE_DEBUG_UTILS_MESSENGER_EXT, "VK_OBJECT_TYPE_DEBUG_UTILS_MESSENGER_EXT" );
	swigIntConstant( VK_OBJECT_TYPE_ACCELERATION_STRUCTURE_KHR, "VK_OBJECT_TYPE_ACCELERATION_STRUCTURE_KHR" );
	swigIntConstant( VK_OBJECT_TYPE_VALIDATION_CACHE_EXT, "VK_OBJECT_TYPE_VALIDATION_CACHE_EXT" );
	swigIntConstant( VK_OBJECT_TYPE_ACCELERATION_STRUCTURE_NV, "VK_OBJECT_TYPE_ACCELERATION_STRUCTURE_NV" );
	swigIntConstant( VK_OBJECT_TYPE_PERFORMANCE_CONFIGURATION_INTEL, "VK_OBJECT_TYPE_PERFORMANCE_CONFIGURATION_INTEL" );
	swigIntConstant( VK_OBJECT_TYPE_DEFERRED_OPERATION_KHR, "VK_OBJECT_TYPE_DEFERRED_OPERATION_KHR" );
	swigIntConstant( VK_OBJECT_TYPE_INDIRECT_COMMANDS_LAYOUT_NV, "VK_OBJECT_TYPE_INDIRECT_COMMANDS_LAYOUT_NV" );
	swigIntConstant( VK_OBJECT_TYPE_PRIVATE_DATA_SLOT_EXT, "VK_OBJECT_TYPE_PRIVATE_DATA_SLOT_EXT" );
	swigIntConstant( VK_OBJECT_TYPE_BUFFER_COLLECTION_FUCHSIA, "VK_OBJECT_TYPE_BUFFER_COLLECTION_FUCHSIA" );
	swigIntConstant( VK_OBJECT_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_KHR, "VK_OBJECT_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_KHR" );
	swigIntConstant( VK_OBJECT_TYPE_SAMPLER_YCBCR_CONVERSION_KHR, "VK_OBJECT_TYPE_SAMPLER_YCBCR_CONVERSION_KHR" );
	swigIntConstant( VK_OBJECT_TYPE_MAX_ENUM, "VK_OBJECT_TYPE_MAX_ENUM" );
	swigIntConstant( VK_PIPELINE_CACHE_HEADER_VERSION_ONE, "VK_PIPELINE_CACHE_HEADER_VERSION_ONE" );
	swigIntConstant( VK_PIPELINE_CACHE_HEADER_VERSION_MAX_ENUM, "VK_PIPELINE_CACHE_HEADER_VERSION_MAX_ENUM" );
	swigIntConstant( VK_VENDOR_ID_VIV, "VK_VENDOR_ID_VIV" );
	swigIntConstant( VK_VENDOR_ID_VSI, "VK_VENDOR_ID_VSI" );
	swigIntConstant( VK_VENDOR_ID_KAZAN, "VK_VENDOR_ID_KAZAN" );
	swigIntConstant( VK_VENDOR_ID_CODEPLAY, "VK_VENDOR_ID_CODEPLAY" );
	swigIntConstant( VK_VENDOR_ID_MESA, "VK_VENDOR_ID_MESA" );
	swigIntConstant( VK_VENDOR_ID_POCL, "VK_VENDOR_ID_POCL" );
	swigIntConstant( VK_VENDOR_ID_MAX_ENUM, "VK_VENDOR_ID_MAX_ENUM" );
	swigIntConstant( VK_SYSTEM_ALLOCATION_SCOPE_COMMAND, "VK_SYSTEM_ALLOCATION_SCOPE_COMMAND" );
	swigIntConstant( VK_SYSTEM_ALLOCATION_SCOPE_OBJECT, "VK_SYSTEM_ALLOCATION_SCOPE_OBJECT" );
	swigIntConstant( VK_SYSTEM_ALLOCATION_SCOPE_CACHE, "VK_SYSTEM_ALLOCATION_SCOPE_CACHE" );
	swigIntConstant( VK_SYSTEM_ALLOCATION_SCOPE_DEVICE, "VK_SYSTEM_ALLOCATION_SCOPE_DEVICE" );
	swigIntConstant( VK_SYSTEM_ALLOCATION_SCOPE_INSTANCE, "VK_SYSTEM_ALLOCATION_SCOPE_INSTANCE" );
	swigIntConstant( VK_SYSTEM_ALLOCATION_SCOPE_MAX_ENUM, "VK_SYSTEM_ALLOCATION_SCOPE_MAX_ENUM" );
	swigIntConstant( VK_INTERNAL_ALLOCATION_TYPE_EXECUTABLE, "VK_INTERNAL_ALLOCATION_TYPE_EXECUTABLE" );
	swigIntConstant( VK_INTERNAL_ALLOCATION_TYPE_MAX_ENUM, "VK_INTERNAL_ALLOCATION_TYPE_MAX_ENUM" );
	swigIntConstant( VK_FORMAT_UNDEFINED, "VK_FORMAT_UNDEFINED" );
	swigIntConstant( VK_FORMAT_R4G4_UNORM_PACK8, "VK_FORMAT_R4G4_UNORM_PACK8" );
	swigIntConstant( VK_FORMAT_R4G4B4A4_UNORM_PACK16, "VK_FORMAT_R4G4B4A4_UNORM_PACK16" );
	swigIntConstant( VK_FORMAT_B4G4R4A4_UNORM_PACK16, "VK_FORMAT_B4G4R4A4_UNORM_PACK16" );
	swigIntConstant( VK_FORMAT_R5G6B5_UNORM_PACK16, "VK_FORMAT_R5G6B5_UNORM_PACK16" );
	swigIntConstant( VK_FORMAT_B5G6R5_UNORM_PACK16, "VK_FORMAT_B5G6R5_UNORM_PACK16" );
	swigIntConstant( VK_FORMAT_R5G5B5A1_UNORM_PACK16, "VK_FORMAT_R5G5B5A1_UNORM_PACK16" );
	swigIntConstant( VK_FORMAT_B5G5R5A1_UNORM_PACK16, "VK_FORMAT_B5G5R5A1_UNORM_PACK16" );
	swigIntConstant( VK_FORMAT_A1R5G5B5_UNORM_PACK16, "VK_FORMAT_A1R5G5B5_UNORM_PACK16" );
	swigIntConstant( VK_FORMAT_R8_UNORM, "VK_FORMAT_R8_UNORM" );
	swigIntConstant( VK_FORMAT_R8_SNORM, "VK_FORMAT_R8_SNORM" );
	swigIntConstant( VK_FORMAT_R8_USCALED, "VK_FORMAT_R8_USCALED" );
	swigIntConstant( VK_FORMAT_R8_SSCALED, "VK_FORMAT_R8_SSCALED" );
	swigIntConstant( VK_FORMAT_R8_UINT, "VK_FORMAT_R8_UINT" );
	swigIntConstant( VK_FORMAT_R8_SINT, "VK_FORMAT_R8_SINT" );
	swigIntConstant( VK_FORMAT_R8_SRGB, "VK_FORMAT_R8_SRGB" );
	swigIntConstant( VK_FORMAT_R8G8_UNORM, "VK_FORMAT_R8G8_UNORM" );
	swigIntConstant( VK_FORMAT_R8G8_SNORM, "VK_FORMAT_R8G8_SNORM" );
	swigIntConstant( VK_FORMAT_R8G8_USCALED, "VK_FORMAT_R8G8_USCALED" );
	swigIntConstant( VK_FORMAT_R8G8_SSCALED, "VK_FORMAT_R8G8_SSCALED" );
	swigIntConstant( VK_FORMAT_R8G8_UINT, "VK_FORMAT_R8G8_UINT" );
	swigIntConstant( VK_FORMAT_R8G8_SINT, "VK_FORMAT_R8G8_SINT" );
	swigIntConstant( VK_FORMAT_R8G8_SRGB, "VK_FORMAT_R8G8_SRGB" );
	swigIntConstant( VK_FORMAT_R8G8B8_UNORM, "VK_FORMAT_R8G8B8_UNORM" );
	swigIntConstant( VK_FORMAT_R8G8B8_SNORM, "VK_FORMAT_R8G8B8_SNORM" );
	swigIntConstant( VK_FORMAT_R8G8B8_USCALED, "VK_FORMAT_R8G8B8_USCALED" );
	swigIntConstant( VK_FORMAT_R8G8B8_SSCALED, "VK_FORMAT_R8G8B8_SSCALED" );
	swigIntConstant( VK_FORMAT_R8G8B8_UINT, "VK_FORMAT_R8G8B8_UINT" );
	swigIntConstant( VK_FORMAT_R8G8B8_SINT, "VK_FORMAT_R8G8B8_SINT" );
	swigIntConstant( VK_FORMAT_R8G8B8_SRGB, "VK_FORMAT_R8G8B8_SRGB" );
	swigIntConstant( VK_FORMAT_B8G8R8_UNORM, "VK_FORMAT_B8G8R8_UNORM" );
	swigIntConstant( VK_FORMAT_B8G8R8_SNORM, "VK_FORMAT_B8G8R8_SNORM" );
	swigIntConstant( VK_FORMAT_B8G8R8_USCALED, "VK_FORMAT_B8G8R8_USCALED" );
	swigIntConstant( VK_FORMAT_B8G8R8_SSCALED, "VK_FORMAT_B8G8R8_SSCALED" );
	swigIntConstant( VK_FORMAT_B8G8R8_UINT, "VK_FORMAT_B8G8R8_UINT" );
	swigIntConstant( VK_FORMAT_B8G8R8_SINT, "VK_FORMAT_B8G8R8_SINT" );
	swigIntConstant( VK_FORMAT_B8G8R8_SRGB, "VK_FORMAT_B8G8R8_SRGB" );
	swigIntConstant( VK_FORMAT_R8G8B8A8_UNORM, "VK_FORMAT_R8G8B8A8_UNORM" );
	swigIntConstant( VK_FORMAT_R8G8B8A8_SNORM, "VK_FORMAT_R8G8B8A8_SNORM" );
	swigIntConstant( VK_FORMAT_R8G8B8A8_USCALED, "VK_FORMAT_R8G8B8A8_USCALED" );
	swigIntConstant( VK_FORMAT_R8G8B8A8_SSCALED, "VK_FORMAT_R8G8B8A8_SSCALED" );
	swigIntConstant( VK_FORMAT_R8G8B8A8_UINT, "VK_FORMAT_R8G8B8A8_UINT" );
	swigIntConstant( VK_FORMAT_R8G8B8A8_SINT, "VK_FORMAT_R8G8B8A8_SINT" );
	swigIntConstant( VK_FORMAT_R8G8B8A8_SRGB, "VK_FORMAT_R8G8B8A8_SRGB" );
	swigIntConstant( VK_FORMAT_B8G8R8A8_UNORM, "VK_FORMAT_B8G8R8A8_UNORM" );
	swigIntConstant( VK_FORMAT_B8G8R8A8_SNORM, "VK_FORMAT_B8G8R8A8_SNORM" );
	swigIntConstant( VK_FORMAT_B8G8R8A8_USCALED, "VK_FORMAT_B8G8R8A8_USCALED" );
	swigIntConstant( VK_FORMAT_B8G8R8A8_SSCALED, "VK_FORMAT_B8G8R8A8_SSCALED" );
	swigIntConstant( VK_FORMAT_B8G8R8A8_UINT, "VK_FORMAT_B8G8R8A8_UINT" );
	swigIntConstant( VK_FORMAT_B8G8R8A8_SINT, "VK_FORMAT_B8G8R8A8_SINT" );
	swigIntConstant( VK_FORMAT_B8G8R8A8_SRGB, "VK_FORMAT_B8G8R8A8_SRGB" );
	swigIntConstant( VK_FORMAT_A8B8G8R8_UNORM_PACK32, "VK_FORMAT_A8B8G8R8_UNORM_PACK32" );
	swigIntConstant( VK_FORMAT_A8B8G8R8_SNORM_PACK32, "VK_FORMAT_A8B8G8R8_SNORM_PACK32" );
	swigIntConstant( VK_FORMAT_A8B8G8R8_USCALED_PACK32, "VK_FORMAT_A8B8G8R8_USCALED_PACK32" );
	swigIntConstant( VK_FORMAT_A8B8G8R8_SSCALED_PACK32, "VK_FORMAT_A8B8G8R8_SSCALED_PACK32" );
	swigIntConstant( VK_FORMAT_A8B8G8R8_UINT_PACK32, "VK_FORMAT_A8B8G8R8_UINT_PACK32" );
	swigIntConstant( VK_FORMAT_A8B8G8R8_SINT_PACK32, "VK_FORMAT_A8B8G8R8_SINT_PACK32" );
	swigIntConstant( VK_FORMAT_A8B8G8R8_SRGB_PACK32, "VK_FORMAT_A8B8G8R8_SRGB_PACK32" );
	swigIntConstant( VK_FORMAT_A2R10G10B10_UNORM_PACK32, "VK_FORMAT_A2R10G10B10_UNORM_PACK32" );
	swigIntConstant( VK_FORMAT_A2R10G10B10_SNORM_PACK32, "VK_FORMAT_A2R10G10B10_SNORM_PACK32" );
	swigIntConstant( VK_FORMAT_A2R10G10B10_USCALED_PACK32, "VK_FORMAT_A2R10G10B10_USCALED_PACK32" );
	swigIntConstant( VK_FORMAT_A2R10G10B10_SSCALED_PACK32, "VK_FORMAT_A2R10G10B10_SSCALED_PACK32" );
	swigIntConstant( VK_FORMAT_A2R10G10B10_UINT_PACK32, "VK_FORMAT_A2R10G10B10_UINT_PACK32" );
	swigIntConstant( VK_FORMAT_A2R10G10B10_SINT_PACK32, "VK_FORMAT_A2R10G10B10_SINT_PACK32" );
	swigIntConstant( VK_FORMAT_A2B10G10R10_UNORM_PACK32, "VK_FORMAT_A2B10G10R10_UNORM_PACK32" );
	swigIntConstant( VK_FORMAT_A2B10G10R10_SNORM_PACK32, "VK_FORMAT_A2B10G10R10_SNORM_PACK32" );
	swigIntConstant( VK_FORMAT_A2B10G10R10_USCALED_PACK32, "VK_FORMAT_A2B10G10R10_USCALED_PACK32" );
	swigIntConstant( VK_FORMAT_A2B10G10R10_SSCALED_PACK32, "VK_FORMAT_A2B10G10R10_SSCALED_PACK32" );
	swigIntConstant( VK_FORMAT_A2B10G10R10_UINT_PACK32, "VK_FORMAT_A2B10G10R10_UINT_PACK32" );
	swigIntConstant( VK_FORMAT_A2B10G10R10_SINT_PACK32, "VK_FORMAT_A2B10G10R10_SINT_PACK32" );
	swigIntConstant( VK_FORMAT_R16_UNORM, "VK_FORMAT_R16_UNORM" );
	swigIntConstant( VK_FORMAT_R16_SNORM, "VK_FORMAT_R16_SNORM" );
	swigIntConstant( VK_FORMAT_R16_USCALED, "VK_FORMAT_R16_USCALED" );
	swigIntConstant( VK_FORMAT_R16_SSCALED, "VK_FORMAT_R16_SSCALED" );
	swigIntConstant( VK_FORMAT_R16_UINT, "VK_FORMAT_R16_UINT" );
	swigIntConstant( VK_FORMAT_R16_SINT, "VK_FORMAT_R16_SINT" );
	swigIntConstant( VK_FORMAT_R16_SFLOAT, "VK_FORMAT_R16_SFLOAT" );
	swigIntConstant( VK_FORMAT_R16G16_UNORM, "VK_FORMAT_R16G16_UNORM" );
	swigIntConstant( VK_FORMAT_R16G16_SNORM, "VK_FORMAT_R16G16_SNORM" );
	swigIntConstant( VK_FORMAT_R16G16_USCALED, "VK_FORMAT_R16G16_USCALED" );
	swigIntConstant( VK_FORMAT_R16G16_SSCALED, "VK_FORMAT_R16G16_SSCALED" );
	swigIntConstant( VK_FORMAT_R16G16_UINT, "VK_FORMAT_R16G16_UINT" );
	swigIntConstant( VK_FORMAT_R16G16_SINT, "VK_FORMAT_R16G16_SINT" );
	swigIntConstant( VK_FORMAT_R16G16_SFLOAT, "VK_FORMAT_R16G16_SFLOAT" );
	swigIntConstant( VK_FORMAT_R16G16B16_UNORM, "VK_FORMAT_R16G16B16_UNORM" );
	swigIntConstant( VK_FORMAT_R16G16B16_SNORM, "VK_FORMAT_R16G16B16_SNORM" );
	swigIntConstant( VK_FORMAT_R16G16B16_USCALED, "VK_FORMAT_R16G16B16_USCALED" );
	swigIntConstant( VK_FORMAT_R16G16B16_SSCALED, "VK_FORMAT_R16G16B16_SSCALED" );
	swigIntConstant( VK_FORMAT_R16G16B16_UINT, "VK_FORMAT_R16G16B16_UINT" );
	swigIntConstant( VK_FORMAT_R16G16B16_SINT, "VK_FORMAT_R16G16B16_SINT" );
	swigIntConstant( VK_FORMAT_R16G16B16_SFLOAT, "VK_FORMAT_R16G16B16_SFLOAT" );
	swigIntConstant( VK_FORMAT_R16G16B16A16_UNORM, "VK_FORMAT_R16G16B16A16_UNORM" );
	swigIntConstant( VK_FORMAT_R16G16B16A16_SNORM, "VK_FORMAT_R16G16B16A16_SNORM" );
	swigIntConstant( VK_FORMAT_R16G16B16A16_USCALED, "VK_FORMAT_R16G16B16A16_USCALED" );
	swigIntConstant( VK_FORMAT_R16G16B16A16_SSCALED, "VK_FORMAT_R16G16B16A16_SSCALED" );
	swigIntConstant( VK_FORMAT_R16G16B16A16_UINT, "VK_FORMAT_R16G16B16A16_UINT" );
	swigIntConstant( VK_FORMAT_R16G16B16A16_SINT, "VK_FORMAT_R16G16B16A16_SINT" );
	swigIntConstant( VK_FORMAT_R16G16B16A16_SFLOAT, "VK_FORMAT_R16G16B16A16_SFLOAT" );
	swigIntConstant( VK_FORMAT_R32_UINT, "VK_FORMAT_R32_UINT" );
	swigIntConstant( VK_FORMAT_R32_SINT, "VK_FORMAT_R32_SINT" );
	swigIntConstant( VK_FORMAT_R32_SFLOAT, "VK_FORMAT_R32_SFLOAT" );
	swigIntConstant( VK_FORMAT_R32G32_UINT, "VK_FORMAT_R32G32_UINT" );
	swigIntConstant( VK_FORMAT_R32G32_SINT, "VK_FORMAT_R32G32_SINT" );
	swigIntConstant( VK_FORMAT_R32G32_SFLOAT, "VK_FORMAT_R32G32_SFLOAT" );
	swigIntConstant( VK_FORMAT_R32G32B32_UINT, "VK_FORMAT_R32G32B32_UINT" );
	swigIntConstant( VK_FORMAT_R32G32B32_SINT, "VK_FORMAT_R32G32B32_SINT" );
	swigIntConstant( VK_FORMAT_R32G32B32_SFLOAT, "VK_FORMAT_R32G32B32_SFLOAT" );
	swigIntConstant( VK_FORMAT_R32G32B32A32_UINT, "VK_FORMAT_R32G32B32A32_UINT" );
	swigIntConstant( VK_FORMAT_R32G32B32A32_SINT, "VK_FORMAT_R32G32B32A32_SINT" );
	swigIntConstant( VK_FORMAT_R32G32B32A32_SFLOAT, "VK_FORMAT_R32G32B32A32_SFLOAT" );
	swigIntConstant( VK_FORMAT_R64_UINT, "VK_FORMAT_R64_UINT" );
	swigIntConstant( VK_FORMAT_R64_SINT, "VK_FORMAT_R64_SINT" );
	swigIntConstant( VK_FORMAT_R64_SFLOAT, "VK_FORMAT_R64_SFLOAT" );
	swigIntConstant( VK_FORMAT_R64G64_UINT, "VK_FORMAT_R64G64_UINT" );
	swigIntConstant( VK_FORMAT_R64G64_SINT, "VK_FORMAT_R64G64_SINT" );
	swigIntConstant( VK_FORMAT_R64G64_SFLOAT, "VK_FORMAT_R64G64_SFLOAT" );
	swigIntConstant( VK_FORMAT_R64G64B64_UINT, "VK_FORMAT_R64G64B64_UINT" );
	swigIntConstant( VK_FORMAT_R64G64B64_SINT, "VK_FORMAT_R64G64B64_SINT" );
	swigIntConstant( VK_FORMAT_R64G64B64_SFLOAT, "VK_FORMAT_R64G64B64_SFLOAT" );
	swigIntConstant( VK_FORMAT_R64G64B64A64_UINT, "VK_FORMAT_R64G64B64A64_UINT" );
	swigIntConstant( VK_FORMAT_R64G64B64A64_SINT, "VK_FORMAT_R64G64B64A64_SINT" );
	swigIntConstant( VK_FORMAT_R64G64B64A64_SFLOAT, "VK_FORMAT_R64G64B64A64_SFLOAT" );
	swigIntConstant( VK_FORMAT_B10G11R11_UFLOAT_PACK32, "VK_FORMAT_B10G11R11_UFLOAT_PACK32" );
	swigIntConstant( VK_FORMAT_E5B9G9R9_UFLOAT_PACK32, "VK_FORMAT_E5B9G9R9_UFLOAT_PACK32" );
	swigIntConstant( VK_FORMAT_D16_UNORM, "VK_FORMAT_D16_UNORM" );
	swigIntConstant( VK_FORMAT_X8_D24_UNORM_PACK32, "VK_FORMAT_X8_D24_UNORM_PACK32" );
	swigIntConstant( VK_FORMAT_D32_SFLOAT, "VK_FORMAT_D32_SFLOAT" );
	swigIntConstant( VK_FORMAT_S8_UINT, "VK_FORMAT_S8_UINT" );
	swigIntConstant( VK_FORMAT_D16_UNORM_S8_UINT, "VK_FORMAT_D16_UNORM_S8_UINT" );
	swigIntConstant( VK_FORMAT_D24_UNORM_S8_UINT, "VK_FORMAT_D24_UNORM_S8_UINT" );
	swigIntConstant( VK_FORMAT_D32_SFLOAT_S8_UINT, "VK_FORMAT_D32_SFLOAT_S8_UINT" );
	swigIntConstant( VK_FORMAT_BC1_RGB_UNORM_BLOCK, "VK_FORMAT_BC1_RGB_UNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_BC1_RGB_SRGB_BLOCK, "VK_FORMAT_BC1_RGB_SRGB_BLOCK" );
	swigIntConstant( VK_FORMAT_BC1_RGBA_UNORM_BLOCK, "VK_FORMAT_BC1_RGBA_UNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_BC1_RGBA_SRGB_BLOCK, "VK_FORMAT_BC1_RGBA_SRGB_BLOCK" );
	swigIntConstant( VK_FORMAT_BC2_UNORM_BLOCK, "VK_FORMAT_BC2_UNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_BC2_SRGB_BLOCK, "VK_FORMAT_BC2_SRGB_BLOCK" );
	swigIntConstant( VK_FORMAT_BC3_UNORM_BLOCK, "VK_FORMAT_BC3_UNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_BC3_SRGB_BLOCK, "VK_FORMAT_BC3_SRGB_BLOCK" );
	swigIntConstant( VK_FORMAT_BC4_UNORM_BLOCK, "VK_FORMAT_BC4_UNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_BC4_SNORM_BLOCK, "VK_FORMAT_BC4_SNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_BC5_UNORM_BLOCK, "VK_FORMAT_BC5_UNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_BC5_SNORM_BLOCK, "VK_FORMAT_BC5_SNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_BC6H_UFLOAT_BLOCK, "VK_FORMAT_BC6H_UFLOAT_BLOCK" );
	swigIntConstant( VK_FORMAT_BC6H_SFLOAT_BLOCK, "VK_FORMAT_BC6H_SFLOAT_BLOCK" );
	swigIntConstant( VK_FORMAT_BC7_UNORM_BLOCK, "VK_FORMAT_BC7_UNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_BC7_SRGB_BLOCK, "VK_FORMAT_BC7_SRGB_BLOCK" );
	swigIntConstant( VK_FORMAT_ETC2_R8G8B8_UNORM_BLOCK, "VK_FORMAT_ETC2_R8G8B8_UNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_ETC2_R8G8B8_SRGB_BLOCK, "VK_FORMAT_ETC2_R8G8B8_SRGB_BLOCK" );
	swigIntConstant( VK_FORMAT_ETC2_R8G8B8A1_UNORM_BLOCK, "VK_FORMAT_ETC2_R8G8B8A1_UNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_ETC2_R8G8B8A1_SRGB_BLOCK, "VK_FORMAT_ETC2_R8G8B8A1_SRGB_BLOCK" );
	swigIntConstant( VK_FORMAT_ETC2_R8G8B8A8_UNORM_BLOCK, "VK_FORMAT_ETC2_R8G8B8A8_UNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_ETC2_R8G8B8A8_SRGB_BLOCK, "VK_FORMAT_ETC2_R8G8B8A8_SRGB_BLOCK" );
	swigIntConstant( VK_FORMAT_EAC_R11_UNORM_BLOCK, "VK_FORMAT_EAC_R11_UNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_EAC_R11_SNORM_BLOCK, "VK_FORMAT_EAC_R11_SNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_EAC_R11G11_UNORM_BLOCK, "VK_FORMAT_EAC_R11G11_UNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_EAC_R11G11_SNORM_BLOCK, "VK_FORMAT_EAC_R11G11_SNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_ASTC_4x4_UNORM_BLOCK, "VK_FORMAT_ASTC_4x4_UNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_ASTC_4x4_SRGB_BLOCK, "VK_FORMAT_ASTC_4x4_SRGB_BLOCK" );
	swigIntConstant( VK_FORMAT_ASTC_5x4_UNORM_BLOCK, "VK_FORMAT_ASTC_5x4_UNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_ASTC_5x4_SRGB_BLOCK, "VK_FORMAT_ASTC_5x4_SRGB_BLOCK" );
	swigIntConstant( VK_FORMAT_ASTC_5x5_UNORM_BLOCK, "VK_FORMAT_ASTC_5x5_UNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_ASTC_5x5_SRGB_BLOCK, "VK_FORMAT_ASTC_5x5_SRGB_BLOCK" );
	swigIntConstant( VK_FORMAT_ASTC_6x5_UNORM_BLOCK, "VK_FORMAT_ASTC_6x5_UNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_ASTC_6x5_SRGB_BLOCK, "VK_FORMAT_ASTC_6x5_SRGB_BLOCK" );
	swigIntConstant( VK_FORMAT_ASTC_6x6_UNORM_BLOCK, "VK_FORMAT_ASTC_6x6_UNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_ASTC_6x6_SRGB_BLOCK, "VK_FORMAT_ASTC_6x6_SRGB_BLOCK" );
	swigIntConstant( VK_FORMAT_ASTC_8x5_UNORM_BLOCK, "VK_FORMAT_ASTC_8x5_UNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_ASTC_8x5_SRGB_BLOCK, "VK_FORMAT_ASTC_8x5_SRGB_BLOCK" );
	swigIntConstant( VK_FORMAT_ASTC_8x6_UNORM_BLOCK, "VK_FORMAT_ASTC_8x6_UNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_ASTC_8x6_SRGB_BLOCK, "VK_FORMAT_ASTC_8x6_SRGB_BLOCK" );
	swigIntConstant( VK_FORMAT_ASTC_8x8_UNORM_BLOCK, "VK_FORMAT_ASTC_8x8_UNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_ASTC_8x8_SRGB_BLOCK, "VK_FORMAT_ASTC_8x8_SRGB_BLOCK" );
	swigIntConstant( VK_FORMAT_ASTC_10x5_UNORM_BLOCK, "VK_FORMAT_ASTC_10x5_UNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_ASTC_10x5_SRGB_BLOCK, "VK_FORMAT_ASTC_10x5_SRGB_BLOCK" );
	swigIntConstant( VK_FORMAT_ASTC_10x6_UNORM_BLOCK, "VK_FORMAT_ASTC_10x6_UNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_ASTC_10x6_SRGB_BLOCK, "VK_FORMAT_ASTC_10x6_SRGB_BLOCK" );
	swigIntConstant( VK_FORMAT_ASTC_10x8_UNORM_BLOCK, "VK_FORMAT_ASTC_10x8_UNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_ASTC_10x8_SRGB_BLOCK, "VK_FORMAT_ASTC_10x8_SRGB_BLOCK" );
	swigIntConstant( VK_FORMAT_ASTC_10x10_UNORM_BLOCK, "VK_FORMAT_ASTC_10x10_UNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_ASTC_10x10_SRGB_BLOCK, "VK_FORMAT_ASTC_10x10_SRGB_BLOCK" );
	swigIntConstant( VK_FORMAT_ASTC_12x10_UNORM_BLOCK, "VK_FORMAT_ASTC_12x10_UNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_ASTC_12x10_SRGB_BLOCK, "VK_FORMAT_ASTC_12x10_SRGB_BLOCK" );
	swigIntConstant( VK_FORMAT_ASTC_12x12_UNORM_BLOCK, "VK_FORMAT_ASTC_12x12_UNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_ASTC_12x12_SRGB_BLOCK, "VK_FORMAT_ASTC_12x12_SRGB_BLOCK" );
	swigIntConstant( VK_FORMAT_G8B8G8R8_422_UNORM, "VK_FORMAT_G8B8G8R8_422_UNORM" );
	swigIntConstant( VK_FORMAT_B8G8R8G8_422_UNORM, "VK_FORMAT_B8G8R8G8_422_UNORM" );
	swigIntConstant( VK_FORMAT_G8_B8_R8_3PLANE_420_UNORM, "VK_FORMAT_G8_B8_R8_3PLANE_420_UNORM" );
	swigIntConstant( VK_FORMAT_G8_B8R8_2PLANE_420_UNORM, "VK_FORMAT_G8_B8R8_2PLANE_420_UNORM" );
	swigIntConstant( VK_FORMAT_G8_B8_R8_3PLANE_422_UNORM, "VK_FORMAT_G8_B8_R8_3PLANE_422_UNORM" );
	swigIntConstant( VK_FORMAT_G8_B8R8_2PLANE_422_UNORM, "VK_FORMAT_G8_B8R8_2PLANE_422_UNORM" );
	swigIntConstant( VK_FORMAT_G8_B8_R8_3PLANE_444_UNORM, "VK_FORMAT_G8_B8_R8_3PLANE_444_UNORM" );
	swigIntConstant( VK_FORMAT_R10X6_UNORM_PACK16, "VK_FORMAT_R10X6_UNORM_PACK16" );
	swigIntConstant( VK_FORMAT_R10X6G10X6_UNORM_2PACK16, "VK_FORMAT_R10X6G10X6_UNORM_2PACK16" );
	swigIntConstant( VK_FORMAT_R10X6G10X6B10X6A10X6_UNORM_4PACK16, "VK_FORMAT_R10X6G10X6B10X6A10X6_UNORM_4PACK16" );
	swigIntConstant( VK_FORMAT_G10X6B10X6G10X6R10X6_422_UNORM_4PACK16, "VK_FORMAT_G10X6B10X6G10X6R10X6_422_UNORM_4PACK16" );
	swigIntConstant( VK_FORMAT_B10X6G10X6R10X6G10X6_422_UNORM_4PACK16, "VK_FORMAT_B10X6G10X6R10X6G10X6_422_UNORM_4PACK16" );
	swigIntConstant( VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_420_UNORM_3PACK16, "VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_420_UNORM_3PACK16" );
	swigIntConstant( VK_FORMAT_G10X6_B10X6R10X6_2PLANE_420_UNORM_3PACK16, "VK_FORMAT_G10X6_B10X6R10X6_2PLANE_420_UNORM_3PACK16" );
	swigIntConstant( VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_422_UNORM_3PACK16, "VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_422_UNORM_3PACK16" );
	swigIntConstant( VK_FORMAT_G10X6_B10X6R10X6_2PLANE_422_UNORM_3PACK16, "VK_FORMAT_G10X6_B10X6R10X6_2PLANE_422_UNORM_3PACK16" );
	swigIntConstant( VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_444_UNORM_3PACK16, "VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_444_UNORM_3PACK16" );
	swigIntConstant( VK_FORMAT_R12X4_UNORM_PACK16, "VK_FORMAT_R12X4_UNORM_PACK16" );
	swigIntConstant( VK_FORMAT_R12X4G12X4_UNORM_2PACK16, "VK_FORMAT_R12X4G12X4_UNORM_2PACK16" );
	swigIntConstant( VK_FORMAT_R12X4G12X4B12X4A12X4_UNORM_4PACK16, "VK_FORMAT_R12X4G12X4B12X4A12X4_UNORM_4PACK16" );
	swigIntConstant( VK_FORMAT_G12X4B12X4G12X4R12X4_422_UNORM_4PACK16, "VK_FORMAT_G12X4B12X4G12X4R12X4_422_UNORM_4PACK16" );
	swigIntConstant( VK_FORMAT_B12X4G12X4R12X4G12X4_422_UNORM_4PACK16, "VK_FORMAT_B12X4G12X4R12X4G12X4_422_UNORM_4PACK16" );
	swigIntConstant( VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_420_UNORM_3PACK16, "VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_420_UNORM_3PACK16" );
	swigIntConstant( VK_FORMAT_G12X4_B12X4R12X4_2PLANE_420_UNORM_3PACK16, "VK_FORMAT_G12X4_B12X4R12X4_2PLANE_420_UNORM_3PACK16" );
	swigIntConstant( VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_422_UNORM_3PACK16, "VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_422_UNORM_3PACK16" );
	swigIntConstant( VK_FORMAT_G12X4_B12X4R12X4_2PLANE_422_UNORM_3PACK16, "VK_FORMAT_G12X4_B12X4R12X4_2PLANE_422_UNORM_3PACK16" );
	swigIntConstant( VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_444_UNORM_3PACK16, "VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_444_UNORM_3PACK16" );
	swigIntConstant( VK_FORMAT_G16B16G16R16_422_UNORM, "VK_FORMAT_G16B16G16R16_422_UNORM" );
	swigIntConstant( VK_FORMAT_B16G16R16G16_422_UNORM, "VK_FORMAT_B16G16R16G16_422_UNORM" );
	swigIntConstant( VK_FORMAT_G16_B16_R16_3PLANE_420_UNORM, "VK_FORMAT_G16_B16_R16_3PLANE_420_UNORM" );
	swigIntConstant( VK_FORMAT_G16_B16R16_2PLANE_420_UNORM, "VK_FORMAT_G16_B16R16_2PLANE_420_UNORM" );
	swigIntConstant( VK_FORMAT_G16_B16_R16_3PLANE_422_UNORM, "VK_FORMAT_G16_B16_R16_3PLANE_422_UNORM" );
	swigIntConstant( VK_FORMAT_G16_B16R16_2PLANE_422_UNORM, "VK_FORMAT_G16_B16R16_2PLANE_422_UNORM" );
	swigIntConstant( VK_FORMAT_G16_B16_R16_3PLANE_444_UNORM, "VK_FORMAT_G16_B16_R16_3PLANE_444_UNORM" );
	swigIntConstant( VK_FORMAT_PVRTC1_2BPP_UNORM_BLOCK_IMG, "VK_FORMAT_PVRTC1_2BPP_UNORM_BLOCK_IMG" );
	swigIntConstant( VK_FORMAT_PVRTC1_4BPP_UNORM_BLOCK_IMG, "VK_FORMAT_PVRTC1_4BPP_UNORM_BLOCK_IMG" );
	swigIntConstant( VK_FORMAT_PVRTC2_2BPP_UNORM_BLOCK_IMG, "VK_FORMAT_PVRTC2_2BPP_UNORM_BLOCK_IMG" );
	swigIntConstant( VK_FORMAT_PVRTC2_4BPP_UNORM_BLOCK_IMG, "VK_FORMAT_PVRTC2_4BPP_UNORM_BLOCK_IMG" );
	swigIntConstant( VK_FORMAT_PVRTC1_2BPP_SRGB_BLOCK_IMG, "VK_FORMAT_PVRTC1_2BPP_SRGB_BLOCK_IMG" );
	swigIntConstant( VK_FORMAT_PVRTC1_4BPP_SRGB_BLOCK_IMG, "VK_FORMAT_PVRTC1_4BPP_SRGB_BLOCK_IMG" );
	swigIntConstant( VK_FORMAT_PVRTC2_2BPP_SRGB_BLOCK_IMG, "VK_FORMAT_PVRTC2_2BPP_SRGB_BLOCK_IMG" );
	swigIntConstant( VK_FORMAT_PVRTC2_4BPP_SRGB_BLOCK_IMG, "VK_FORMAT_PVRTC2_4BPP_SRGB_BLOCK_IMG" );
	swigIntConstant( VK_FORMAT_ASTC_4x4_SFLOAT_BLOCK_EXT, "VK_FORMAT_ASTC_4x4_SFLOAT_BLOCK_EXT" );
	swigIntConstant( VK_FORMAT_ASTC_5x4_SFLOAT_BLOCK_EXT, "VK_FORMAT_ASTC_5x4_SFLOAT_BLOCK_EXT" );
	swigIntConstant( VK_FORMAT_ASTC_5x5_SFLOAT_BLOCK_EXT, "VK_FORMAT_ASTC_5x5_SFLOAT_BLOCK_EXT" );
	swigIntConstant( VK_FORMAT_ASTC_6x5_SFLOAT_BLOCK_EXT, "VK_FORMAT_ASTC_6x5_SFLOAT_BLOCK_EXT" );
	swigIntConstant( VK_FORMAT_ASTC_6x6_SFLOAT_BLOCK_EXT, "VK_FORMAT_ASTC_6x6_SFLOAT_BLOCK_EXT" );
	swigIntConstant( VK_FORMAT_ASTC_8x5_SFLOAT_BLOCK_EXT, "VK_FORMAT_ASTC_8x5_SFLOAT_BLOCK_EXT" );
	swigIntConstant( VK_FORMAT_ASTC_8x6_SFLOAT_BLOCK_EXT, "VK_FORMAT_ASTC_8x6_SFLOAT_BLOCK_EXT" );
	swigIntConstant( VK_FORMAT_ASTC_8x8_SFLOAT_BLOCK_EXT, "VK_FORMAT_ASTC_8x8_SFLOAT_BLOCK_EXT" );
	swigIntConstant( VK_FORMAT_ASTC_10x5_SFLOAT_BLOCK_EXT, "VK_FORMAT_ASTC_10x5_SFLOAT_BLOCK_EXT" );
	swigIntConstant( VK_FORMAT_ASTC_10x6_SFLOAT_BLOCK_EXT, "VK_FORMAT_ASTC_10x6_SFLOAT_BLOCK_EXT" );
	swigIntConstant( VK_FORMAT_ASTC_10x8_SFLOAT_BLOCK_EXT, "VK_FORMAT_ASTC_10x8_SFLOAT_BLOCK_EXT" );
	swigIntConstant( VK_FORMAT_ASTC_10x10_SFLOAT_BLOCK_EXT, "VK_FORMAT_ASTC_10x10_SFLOAT_BLOCK_EXT" );
	swigIntConstant( VK_FORMAT_ASTC_12x10_SFLOAT_BLOCK_EXT, "VK_FORMAT_ASTC_12x10_SFLOAT_BLOCK_EXT" );
	swigIntConstant( VK_FORMAT_ASTC_12x12_SFLOAT_BLOCK_EXT, "VK_FORMAT_ASTC_12x12_SFLOAT_BLOCK_EXT" );
	swigIntConstant( VK_FORMAT_G8_B8R8_2PLANE_444_UNORM_EXT, "VK_FORMAT_G8_B8R8_2PLANE_444_UNORM_EXT" );
	swigIntConstant( VK_FORMAT_G10X6_B10X6R10X6_2PLANE_444_UNORM_3PACK16_EXT, "VK_FORMAT_G10X6_B10X6R10X6_2PLANE_444_UNORM_3PACK16_EXT" );
	swigIntConstant( VK_FORMAT_G12X4_B12X4R12X4_2PLANE_444_UNORM_3PACK16_EXT, "VK_FORMAT_G12X4_B12X4R12X4_2PLANE_444_UNORM_3PACK16_EXT" );
	swigIntConstant( VK_FORMAT_G16_B16R16_2PLANE_444_UNORM_EXT, "VK_FORMAT_G16_B16R16_2PLANE_444_UNORM_EXT" );
	swigIntConstant( VK_FORMAT_A4R4G4B4_UNORM_PACK16_EXT, "VK_FORMAT_A4R4G4B4_UNORM_PACK16_EXT" );
	swigIntConstant( VK_FORMAT_A4B4G4R4_UNORM_PACK16_EXT, "VK_FORMAT_A4B4G4R4_UNORM_PACK16_EXT" );
	swigIntConstant( VK_FORMAT_G8B8G8R8_422_UNORM_KHR, "VK_FORMAT_G8B8G8R8_422_UNORM_KHR" );
	swigIntConstant( VK_FORMAT_B8G8R8G8_422_UNORM_KHR, "VK_FORMAT_B8G8R8G8_422_UNORM_KHR" );
	swigIntConstant( VK_FORMAT_G8_B8_R8_3PLANE_420_UNORM_KHR, "VK_FORMAT_G8_B8_R8_3PLANE_420_UNORM_KHR" );
	swigIntConstant( VK_FORMAT_G8_B8R8_2PLANE_420_UNORM_KHR, "VK_FORMAT_G8_B8R8_2PLANE_420_UNORM_KHR" );
	swigIntConstant( VK_FORMAT_G8_B8_R8_3PLANE_422_UNORM_KHR, "VK_FORMAT_G8_B8_R8_3PLANE_422_UNORM_KHR" );
	swigIntConstant( VK_FORMAT_G8_B8R8_2PLANE_422_UNORM_KHR, "VK_FORMAT_G8_B8R8_2PLANE_422_UNORM_KHR" );
	swigIntConstant( VK_FORMAT_G8_B8_R8_3PLANE_444_UNORM_KHR, "VK_FORMAT_G8_B8_R8_3PLANE_444_UNORM_KHR" );
	swigIntConstant( VK_FORMAT_R10X6_UNORM_PACK16_KHR, "VK_FORMAT_R10X6_UNORM_PACK16_KHR" );
	swigIntConstant( VK_FORMAT_R10X6G10X6_UNORM_2PACK16_KHR, "VK_FORMAT_R10X6G10X6_UNORM_2PACK16_KHR" );
	swigIntConstant( VK_FORMAT_R10X6G10X6B10X6A10X6_UNORM_4PACK16_KHR, "VK_FORMAT_R10X6G10X6B10X6A10X6_UNORM_4PACK16_KHR" );
	swigIntConstant( VK_FORMAT_G10X6B10X6G10X6R10X6_422_UNORM_4PACK16_KHR, "VK_FORMAT_G10X6B10X6G10X6R10X6_422_UNORM_4PACK16_KHR" );
	swigIntConstant( VK_FORMAT_B10X6G10X6R10X6G10X6_422_UNORM_4PACK16_KHR, "VK_FORMAT_B10X6G10X6R10X6G10X6_422_UNORM_4PACK16_KHR" );
	swigIntConstant( VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_420_UNORM_3PACK16_KHR, "VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_420_UNORM_3PACK16_KHR" );
	swigIntConstant( VK_FORMAT_G10X6_B10X6R10X6_2PLANE_420_UNORM_3PACK16_KHR, "VK_FORMAT_G10X6_B10X6R10X6_2PLANE_420_UNORM_3PACK16_KHR" );
	swigIntConstant( VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_422_UNORM_3PACK16_KHR, "VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_422_UNORM_3PACK16_KHR" );
	swigIntConstant( VK_FORMAT_G10X6_B10X6R10X6_2PLANE_422_UNORM_3PACK16_KHR, "VK_FORMAT_G10X6_B10X6R10X6_2PLANE_422_UNORM_3PACK16_KHR" );
	swigIntConstant( VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_444_UNORM_3PACK16_KHR, "VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_444_UNORM_3PACK16_KHR" );
	swigIntConstant( VK_FORMAT_R12X4_UNORM_PACK16_KHR, "VK_FORMAT_R12X4_UNORM_PACK16_KHR" );
	swigIntConstant( VK_FORMAT_R12X4G12X4_UNORM_2PACK16_KHR, "VK_FORMAT_R12X4G12X4_UNORM_2PACK16_KHR" );
	swigIntConstant( VK_FORMAT_R12X4G12X4B12X4A12X4_UNORM_4PACK16_KHR, "VK_FORMAT_R12X4G12X4B12X4A12X4_UNORM_4PACK16_KHR" );
	swigIntConstant( VK_FORMAT_G12X4B12X4G12X4R12X4_422_UNORM_4PACK16_KHR, "VK_FORMAT_G12X4B12X4G12X4R12X4_422_UNORM_4PACK16_KHR" );
	swigIntConstant( VK_FORMAT_B12X4G12X4R12X4G12X4_422_UNORM_4PACK16_KHR, "VK_FORMAT_B12X4G12X4R12X4G12X4_422_UNORM_4PACK16_KHR" );
	swigIntConstant( VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_420_UNORM_3PACK16_KHR, "VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_420_UNORM_3PACK16_KHR" );
	swigIntConstant( VK_FORMAT_G12X4_B12X4R12X4_2PLANE_420_UNORM_3PACK16_KHR, "VK_FORMAT_G12X4_B12X4R12X4_2PLANE_420_UNORM_3PACK16_KHR" );
	swigIntConstant( VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_422_UNORM_3PACK16_KHR, "VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_422_UNORM_3PACK16_KHR" );
	swigIntConstant( VK_FORMAT_G12X4_B12X4R12X4_2PLANE_422_UNORM_3PACK16_KHR, "VK_FORMAT_G12X4_B12X4R12X4_2PLANE_422_UNORM_3PACK16_KHR" );
	swigIntConstant( VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_444_UNORM_3PACK16_KHR, "VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_444_UNORM_3PACK16_KHR" );
	swigIntConstant( VK_FORMAT_G16B16G16R16_422_UNORM_KHR, "VK_FORMAT_G16B16G16R16_422_UNORM_KHR" );
	swigIntConstant( VK_FORMAT_B16G16R16G16_422_UNORM_KHR, "VK_FORMAT_B16G16R16G16_422_UNORM_KHR" );
	swigIntConstant( VK_FORMAT_G16_B16_R16_3PLANE_420_UNORM_KHR, "VK_FORMAT_G16_B16_R16_3PLANE_420_UNORM_KHR" );
	swigIntConstant( VK_FORMAT_G16_B16R16_2PLANE_420_UNORM_KHR, "VK_FORMAT_G16_B16R16_2PLANE_420_UNORM_KHR" );
	swigIntConstant( VK_FORMAT_G16_B16_R16_3PLANE_422_UNORM_KHR, "VK_FORMAT_G16_B16_R16_3PLANE_422_UNORM_KHR" );
	swigIntConstant( VK_FORMAT_G16_B16R16_2PLANE_422_UNORM_KHR, "VK_FORMAT_G16_B16R16_2PLANE_422_UNORM_KHR" );
	swigIntConstant( VK_FORMAT_G16_B16_R16_3PLANE_444_UNORM_KHR, "VK_FORMAT_G16_B16_R16_3PLANE_444_UNORM_KHR" );
	swigIntConstant( VK_FORMAT_MAX_ENUM, "VK_FORMAT_MAX_ENUM" );
	swigIntConstant( VK_IMAGE_TILING_OPTIMAL, "VK_IMAGE_TILING_OPTIMAL" );
	swigIntConstant( VK_IMAGE_TILING_LINEAR, "VK_IMAGE_TILING_LINEAR" );
	swigIntConstant( VK_IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT, "VK_IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT" );
	swigIntConstant( VK_IMAGE_TILING_MAX_ENUM, "VK_IMAGE_TILING_MAX_ENUM" );
	swigIntConstant( VK_IMAGE_TYPE_1D, "VK_IMAGE_TYPE_1D" );
	swigIntConstant( VK_IMAGE_TYPE_2D, "VK_IMAGE_TYPE_2D" );
	swigIntConstant( VK_IMAGE_TYPE_3D, "VK_IMAGE_TYPE_3D" );
	swigIntConstant( VK_IMAGE_TYPE_MAX_ENUM, "VK_IMAGE_TYPE_MAX_ENUM" );
	swigIntConstant( VK_PHYSICAL_DEVICE_TYPE_OTHER, "VK_PHYSICAL_DEVICE_TYPE_OTHER" );
	swigIntConstant( VK_PHYSICAL_DEVICE_TYPE_INTEGRATED_GPU, "VK_PHYSICAL_DEVICE_TYPE_INTEGRATED_GPU" );
	swigIntConstant( VK_PHYSICAL_DEVICE_TYPE_DISCRETE_GPU, "VK_PHYSICAL_DEVICE_TYPE_DISCRETE_GPU" );
	swigIntConstant( VK_PHYSICAL_DEVICE_TYPE_VIRTUAL_GPU, "VK_PHYSICAL_DEVICE_TYPE_VIRTUAL_GPU" );
	swigIntConstant( VK_PHYSICAL_DEVICE_TYPE_CPU, "VK_PHYSICAL_DEVICE_TYPE_CPU" );
	swigIntConstant( VK_PHYSICAL_DEVICE_TYPE_MAX_ENUM, "VK_PHYSICAL_DEVICE_TYPE_MAX_ENUM" );
	swigIntConstant( VK_QUERY_TYPE_OCCLUSION, "VK_QUERY_TYPE_OCCLUSION" );
	swigIntConstant( VK_QUERY_TYPE_PIPELINE_STATISTICS, "VK_QUERY_TYPE_PIPELINE_STATISTICS" );
	swigIntConstant( VK_QUERY_TYPE_TIMESTAMP, "VK_QUERY_TYPE_TIMESTAMP" );
	swigIntConstant( VK_QUERY_TYPE_TRANSFORM_FEEDBACK_STREAM_EXT, "VK_QUERY_TYPE_TRANSFORM_FEEDBACK_STREAM_EXT" );
	swigIntConstant( VK_QUERY_TYPE_PERFORMANCE_QUERY_KHR, "VK_QUERY_TYPE_PERFORMANCE_QUERY_KHR" );
	swigIntConstant( VK_QUERY_TYPE_ACCELERATION_STRUCTURE_COMPACTED_SIZE_KHR, "VK_QUERY_TYPE_ACCELERATION_STRUCTURE_COMPACTED_SIZE_KHR" );
	swigIntConstant( VK_QUERY_TYPE_ACCELERATION_STRUCTURE_SERIALIZATION_SIZE_KHR, "VK_QUERY_TYPE_ACCELERATION_STRUCTURE_SERIALIZATION_SIZE_KHR" );
	swigIntConstant( VK_QUERY_TYPE_ACCELERATION_STRUCTURE_COMPACTED_SIZE_NV, "VK_QUERY_TYPE_ACCELERATION_STRUCTURE_COMPACTED_SIZE_NV" );
	swigIntConstant( VK_QUERY_TYPE_PERFORMANCE_QUERY_INTEL, "VK_QUERY_TYPE_PERFORMANCE_QUERY_INTEL" );
	swigIntConstant( VK_QUERY_TYPE_MAX_ENUM, "VK_QUERY_TYPE_MAX_ENUM" );
	swigIntConstant( VK_SHARING_MODE_EXCLUSIVE, "VK_SHARING_MODE_EXCLUSIVE" );
	swigIntConstant( VK_SHARING_MODE_CONCURRENT, "VK_SHARING_MODE_CONCURRENT" );
	swigIntConstant( VK_SHARING_MODE_MAX_ENUM, "VK_SHARING_MODE_MAX_ENUM" );
	swigIntConstant( VK_COMPONENT_SWIZZLE_IDENTITY, "VK_COMPONENT_SWIZZLE_IDENTITY" );
	swigIntConstant( VK_COMPONENT_SWIZZLE_ZERO, "VK_COMPONENT_SWIZZLE_ZERO" );
	swigIntConstant( VK_COMPONENT_SWIZZLE_ONE, "VK_COMPONENT_SWIZZLE_ONE" );
	swigIntConstant( VK_COMPONENT_SWIZZLE_R, "VK_COMPONENT_SWIZZLE_R" );
	swigIntConstant( VK_COMPONENT_SWIZZLE_G, "VK_COMPONENT_SWIZZLE_G" );
	swigIntConstant( VK_COMPONENT_SWIZZLE_B, "VK_COMPONENT_SWIZZLE_B" );
	swigIntConstant( VK_COMPONENT_SWIZZLE_A, "VK_COMPONENT_SWIZZLE_A" );
	swigIntConstant( VK_COMPONENT_SWIZZLE_MAX_ENUM, "VK_COMPONENT_SWIZZLE_MAX_ENUM" );
	swigIntConstant( VK_IMAGE_VIEW_TYPE_1D, "VK_IMAGE_VIEW_TYPE_1D" );
	swigIntConstant( VK_IMAGE_VIEW_TYPE_2D, "VK_IMAGE_VIEW_TYPE_2D" );
	swigIntConstant( VK_IMAGE_VIEW_TYPE_3D, "VK_IMAGE_VIEW_TYPE_3D" );
	swigIntConstant( VK_IMAGE_VIEW_TYPE_CUBE, "VK_IMAGE_VIEW_TYPE_CUBE" );
	swigIntConstant( VK_IMAGE_VIEW_TYPE_1D_ARRAY, "VK_IMAGE_VIEW_TYPE_1D_ARRAY" );
	swigIntConstant( VK_IMAGE_VIEW_TYPE_2D_ARRAY, "VK_IMAGE_VIEW_TYPE_2D_ARRAY" );
	swigIntConstant( VK_IMAGE_VIEW_TYPE_CUBE_ARRAY, "VK_IMAGE_VIEW_TYPE_CUBE_ARRAY" );
	swigIntConstant( VK_IMAGE_VIEW_TYPE_MAX_ENUM, "VK_IMAGE_VIEW_TYPE_MAX_ENUM" );
	swigIntConstant( VK_BLEND_FACTOR_ZERO, "VK_BLEND_FACTOR_ZERO" );
	swigIntConstant( VK_BLEND_FACTOR_ONE, "VK_BLEND_FACTOR_ONE" );
	swigIntConstant( VK_BLEND_FACTOR_SRC_COLOR, "VK_BLEND_FACTOR_SRC_COLOR" );
	swigIntConstant( VK_BLEND_FACTOR_ONE_MINUS_SRC_COLOR, "VK_BLEND_FACTOR_ONE_MINUS_SRC_COLOR" );
	swigIntConstant( VK_BLEND_FACTOR_DST_COLOR, "VK_BLEND_FACTOR_DST_COLOR" );
	swigIntConstant( VK_BLEND_FACTOR_ONE_MINUS_DST_COLOR, "VK_BLEND_FACTOR_ONE_MINUS_DST_COLOR" );
	swigIntConstant( VK_BLEND_FACTOR_SRC_ALPHA, "VK_BLEND_FACTOR_SRC_ALPHA" );
	swigIntConstant( VK_BLEND_FACTOR_ONE_MINUS_SRC_ALPHA, "VK_BLEND_FACTOR_ONE_MINUS_SRC_ALPHA" );
	swigIntConstant( VK_BLEND_FACTOR_DST_ALPHA, "VK_BLEND_FACTOR_DST_ALPHA" );
	swigIntConstant( VK_BLEND_FACTOR_ONE_MINUS_DST_ALPHA, "VK_BLEND_FACTOR_ONE_MINUS_DST_ALPHA" );
	swigIntConstant( VK_BLEND_FACTOR_CONSTANT_COLOR, "VK_BLEND_FACTOR_CONSTANT_COLOR" );
	swigIntConstant( VK_BLEND_FACTOR_ONE_MINUS_CONSTANT_COLOR, "VK_BLEND_FACTOR_ONE_MINUS_CONSTANT_COLOR" );
	swigIntConstant( VK_BLEND_FACTOR_CONSTANT_ALPHA, "VK_BLEND_FACTOR_CONSTANT_ALPHA" );
	swigIntConstant( VK_BLEND_FACTOR_ONE_MINUS_CONSTANT_ALPHA, "VK_BLEND_FACTOR_ONE_MINUS_CONSTANT_ALPHA" );
	swigIntConstant( VK_BLEND_FACTOR_SRC_ALPHA_SATURATE, "VK_BLEND_FACTOR_SRC_ALPHA_SATURATE" );
	swigIntConstant( VK_BLEND_FACTOR_SRC1_COLOR, "VK_BLEND_FACTOR_SRC1_COLOR" );
	swigIntConstant( VK_BLEND_FACTOR_ONE_MINUS_SRC1_COLOR, "VK_BLEND_FACTOR_ONE_MINUS_SRC1_COLOR" );
	swigIntConstant( VK_BLEND_FACTOR_SRC1_ALPHA, "VK_BLEND_FACTOR_SRC1_ALPHA" );
	swigIntConstant( VK_BLEND_FACTOR_ONE_MINUS_SRC1_ALPHA, "VK_BLEND_FACTOR_ONE_MINUS_SRC1_ALPHA" );
	swigIntConstant( VK_BLEND_FACTOR_MAX_ENUM, "VK_BLEND_FACTOR_MAX_ENUM" );
	swigIntConstant( VK_BLEND_OP_ADD, "VK_BLEND_OP_ADD" );
	swigIntConstant( VK_BLEND_OP_SUBTRACT, "VK_BLEND_OP_SUBTRACT" );
	swigIntConstant( VK_BLEND_OP_REVERSE_SUBTRACT, "VK_BLEND_OP_REVERSE_SUBTRACT" );
	swigIntConstant( VK_BLEND_OP_MIN, "VK_BLEND_OP_MIN" );
	swigIntConstant( VK_BLEND_OP_MAX, "VK_BLEND_OP_MAX" );
	swigIntConstant( VK_BLEND_OP_ZERO_EXT, "VK_BLEND_OP_ZERO_EXT" );
	swigIntConstant( VK_BLEND_OP_SRC_EXT, "VK_BLEND_OP_SRC_EXT" );
	swigIntConstant( VK_BLEND_OP_DST_EXT, "VK_BLEND_OP_DST_EXT" );
	swigIntConstant( VK_BLEND_OP_SRC_OVER_EXT, "VK_BLEND_OP_SRC_OVER_EXT" );
	swigIntConstant( VK_BLEND_OP_DST_OVER_EXT, "VK_BLEND_OP_DST_OVER_EXT" );
	swigIntConstant( VK_BLEND_OP_SRC_IN_EXT, "VK_BLEND_OP_SRC_IN_EXT" );
	swigIntConstant( VK_BLEND_OP_DST_IN_EXT, "VK_BLEND_OP_DST_IN_EXT" );
	swigIntConstant( VK_BLEND_OP_SRC_OUT_EXT, "VK_BLEND_OP_SRC_OUT_EXT" );
	swigIntConstant( VK_BLEND_OP_DST_OUT_EXT, "VK_BLEND_OP_DST_OUT_EXT" );
	swigIntConstant( VK_BLEND_OP_SRC_ATOP_EXT, "VK_BLEND_OP_SRC_ATOP_EXT" );
	swigIntConstant( VK_BLEND_OP_DST_ATOP_EXT, "VK_BLEND_OP_DST_ATOP_EXT" );
	swigIntConstant( VK_BLEND_OP_XOR_EXT, "VK_BLEND_OP_XOR_EXT" );
	swigIntConstant( VK_BLEND_OP_MULTIPLY_EXT, "VK_BLEND_OP_MULTIPLY_EXT" );
	swigIntConstant( VK_BLEND_OP_SCREEN_EXT, "VK_BLEND_OP_SCREEN_EXT" );
	swigIntConstant( VK_BLEND_OP_OVERLAY_EXT, "VK_BLEND_OP_OVERLAY_EXT" );
	swigIntConstant( VK_BLEND_OP_DARKEN_EXT, "VK_BLEND_OP_DARKEN_EXT" );
	swigIntConstant( VK_BLEND_OP_LIGHTEN_EXT, "VK_BLEND_OP_LIGHTEN_EXT" );
	swigIntConstant( VK_BLEND_OP_COLORDODGE_EXT, "VK_BLEND_OP_COLORDODGE_EXT" );
	swigIntConstant( VK_BLEND_OP_COLORBURN_EXT, "VK_BLEND_OP_COLORBURN_EXT" );
	swigIntConstant( VK_BLEND_OP_HARDLIGHT_EXT, "VK_BLEND_OP_HARDLIGHT_EXT" );
	swigIntConstant( VK_BLEND_OP_SOFTLIGHT_EXT, "VK_BLEND_OP_SOFTLIGHT_EXT" );
	swigIntConstant( VK_BLEND_OP_DIFFERENCE_EXT, "VK_BLEND_OP_DIFFERENCE_EXT" );
	swigIntConstant( VK_BLEND_OP_EXCLUSION_EXT, "VK_BLEND_OP_EXCLUSION_EXT" );
	swigIntConstant( VK_BLEND_OP_INVERT_EXT, "VK_BLEND_OP_INVERT_EXT" );
	swigIntConstant( VK_BLEND_OP_INVERT_RGB_EXT, "VK_BLEND_OP_INVERT_RGB_EXT" );
	swigIntConstant( VK_BLEND_OP_LINEARDODGE_EXT, "VK_BLEND_OP_LINEARDODGE_EXT" );
	swigIntConstant( VK_BLEND_OP_LINEARBURN_EXT, "VK_BLEND_OP_LINEARBURN_EXT" );
	swigIntConstant( VK_BLEND_OP_VIVIDLIGHT_EXT, "VK_BLEND_OP_VIVIDLIGHT_EXT" );
	swigIntConstant( VK_BLEND_OP_LINEARLIGHT_EXT, "VK_BLEND_OP_LINEARLIGHT_EXT" );
	swigIntConstant( VK_BLEND_OP_PINLIGHT_EXT, "VK_BLEND_OP_PINLIGHT_EXT" );
	swigIntConstant( VK_BLEND_OP_HARDMIX_EXT, "VK_BLEND_OP_HARDMIX_EXT" );
	swigIntConstant( VK_BLEND_OP_HSL_HUE_EXT, "VK_BLEND_OP_HSL_HUE_EXT" );
	swigIntConstant( VK_BLEND_OP_HSL_SATURATION_EXT, "VK_BLEND_OP_HSL_SATURATION_EXT" );
	swigIntConstant( VK_BLEND_OP_HSL_COLOR_EXT, "VK_BLEND_OP_HSL_COLOR_EXT" );
	swigIntConstant( VK_BLEND_OP_HSL_LUMINOSITY_EXT, "VK_BLEND_OP_HSL_LUMINOSITY_EXT" );
	swigIntConstant( VK_BLEND_OP_PLUS_EXT, "VK_BLEND_OP_PLUS_EXT" );
	swigIntConstant( VK_BLEND_OP_PLUS_CLAMPED_EXT, "VK_BLEND_OP_PLUS_CLAMPED_EXT" );
	swigIntConstant( VK_BLEND_OP_PLUS_CLAMPED_ALPHA_EXT, "VK_BLEND_OP_PLUS_CLAMPED_ALPHA_EXT" );
	swigIntConstant( VK_BLEND_OP_PLUS_DARKER_EXT, "VK_BLEND_OP_PLUS_DARKER_EXT" );
	swigIntConstant( VK_BLEND_OP_MINUS_EXT, "VK_BLEND_OP_MINUS_EXT" );
	swigIntConstant( VK_BLEND_OP_MINUS_CLAMPED_EXT, "VK_BLEND_OP_MINUS_CLAMPED_EXT" );
	swigIntConstant( VK_BLEND_OP_CONTRAST_EXT, "VK_BLEND_OP_CONTRAST_EXT" );
	swigIntConstant( VK_BLEND_OP_INVERT_OVG_EXT, "VK_BLEND_OP_INVERT_OVG_EXT" );
	swigIntConstant( VK_BLEND_OP_RED_EXT, "VK_BLEND_OP_RED_EXT" );
	swigIntConstant( VK_BLEND_OP_GREEN_EXT, "VK_BLEND_OP_GREEN_EXT" );
	swigIntConstant( VK_BLEND_OP_BLUE_EXT, "VK_BLEND_OP_BLUE_EXT" );
	swigIntConstant( VK_BLEND_OP_MAX_ENUM, "VK_BLEND_OP_MAX_ENUM" );
	swigIntConstant( VK_COMPARE_OP_NEVER, "VK_COMPARE_OP_NEVER" );
	swigIntConstant( VK_COMPARE_OP_LESS, "VK_COMPARE_OP_LESS" );
	swigIntConstant( VK_COMPARE_OP_EQUAL, "VK_COMPARE_OP_EQUAL" );
	swigIntConstant( VK_COMPARE_OP_LESS_OR_EQUAL, "VK_COMPARE_OP_LESS_OR_EQUAL" );
	swigIntConstant( VK_COMPARE_OP_GREATER, "VK_COMPARE_OP_GREATER" );
	swigIntConstant( VK_COMPARE_OP_NOT_EQUAL, "VK_COMPARE_OP_NOT_EQUAL" );
	swigIntConstant( VK_COMPARE_OP_GREATER_OR_EQUAL, "VK_COMPARE_OP_GREATER_OR_EQUAL" );
	swigIntConstant( VK_COMPARE_OP_ALWAYS, "VK_COMPARE_OP_ALWAYS" );
	swigIntConstant( VK_COMPARE_OP_MAX_ENUM, "VK_COMPARE_OP_MAX_ENUM" );
	swigIntConstant( VK_DYNAMIC_STATE_VIEWPORT, "VK_DYNAMIC_STATE_VIEWPORT" );
	swigIntConstant( VK_DYNAMIC_STATE_SCISSOR, "VK_DYNAMIC_STATE_SCISSOR" );
	swigIntConstant( VK_DYNAMIC_STATE_LINE_WIDTH, "VK_DYNAMIC_STATE_LINE_WIDTH" );
	swigIntConstant( VK_DYNAMIC_STATE_DEPTH_BIAS, "VK_DYNAMIC_STATE_DEPTH_BIAS" );
	swigIntConstant( VK_DYNAMIC_STATE_BLEND_CONSTANTS, "VK_DYNAMIC_STATE_BLEND_CONSTANTS" );
	swigIntConstant( VK_DYNAMIC_STATE_DEPTH_BOUNDS, "VK_DYNAMIC_STATE_DEPTH_BOUNDS" );
	swigIntConstant( VK_DYNAMIC_STATE_STENCIL_COMPARE_MASK, "VK_DYNAMIC_STATE_STENCIL_COMPARE_MASK" );
	swigIntConstant( VK_DYNAMIC_STATE_STENCIL_WRITE_MASK, "VK_DYNAMIC_STATE_STENCIL_WRITE_MASK" );
	swigIntConstant( VK_DYNAMIC_STATE_STENCIL_REFERENCE, "VK_DYNAMIC_STATE_STENCIL_REFERENCE" );
	swigIntConstant( VK_DYNAMIC_STATE_VIEWPORT_W_SCALING_NV, "VK_DYNAMIC_STATE_VIEWPORT_W_SCALING_NV" );
	swigIntConstant( VK_DYNAMIC_STATE_DISCARD_RECTANGLE_EXT, "VK_DYNAMIC_STATE_DISCARD_RECTANGLE_EXT" );
	swigIntConstant( VK_DYNAMIC_STATE_SAMPLE_LOCATIONS_EXT, "VK_DYNAMIC_STATE_SAMPLE_LOCATIONS_EXT" );
	swigIntConstant( VK_DYNAMIC_STATE_RAY_TRACING_PIPELINE_STACK_SIZE_KHR, "VK_DYNAMIC_STATE_RAY_TRACING_PIPELINE_STACK_SIZE_KHR" );
	swigIntConstant( VK_DYNAMIC_STATE_VIEWPORT_SHADING_RATE_PALETTE_NV, "VK_DYNAMIC_STATE_VIEWPORT_SHADING_RATE_PALETTE_NV" );
	swigIntConstant( VK_DYNAMIC_STATE_VIEWPORT_COARSE_SAMPLE_ORDER_NV, "VK_DYNAMIC_STATE_VIEWPORT_COARSE_SAMPLE_ORDER_NV" );
	swigIntConstant( VK_DYNAMIC_STATE_EXCLUSIVE_SCISSOR_NV, "VK_DYNAMIC_STATE_EXCLUSIVE_SCISSOR_NV" );
	swigIntConstant( VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR, "VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR" );
	swigIntConstant( VK_DYNAMIC_STATE_LINE_STIPPLE_EXT, "VK_DYNAMIC_STATE_LINE_STIPPLE_EXT" );
	swigIntConstant( VK_DYNAMIC_STATE_CULL_MODE_EXT, "VK_DYNAMIC_STATE_CULL_MODE_EXT" );
	swigIntConstant( VK_DYNAMIC_STATE_FRONT_FACE_EXT, "VK_DYNAMIC_STATE_FRONT_FACE_EXT" );
	swigIntConstant( VK_DYNAMIC_STATE_PRIMITIVE_TOPOLOGY_EXT, "VK_DYNAMIC_STATE_PRIMITIVE_TOPOLOGY_EXT" );
	swigIntConstant( VK_DYNAMIC_STATE_VIEWPORT_WITH_COUNT_EXT, "VK_DYNAMIC_STATE_VIEWPORT_WITH_COUNT_EXT" );
	swigIntConstant( VK_DYNAMIC_STATE_SCISSOR_WITH_COUNT_EXT, "VK_DYNAMIC_STATE_SCISSOR_WITH_COUNT_EXT" );
	swigIntConstant( VK_DYNAMIC_STATE_VERTEX_INPUT_BINDING_STRIDE_EXT, "VK_DYNAMIC_STATE_VERTEX_INPUT_BINDING_STRIDE_EXT" );
	swigIntConstant( VK_DYNAMIC_STATE_DEPTH_TEST_ENABLE_EXT, "VK_DYNAMIC_STATE_DEPTH_TEST_ENABLE_EXT" );
	swigIntConstant( VK_DYNAMIC_STATE_DEPTH_WRITE_ENABLE_EXT, "VK_DYNAMIC_STATE_DEPTH_WRITE_ENABLE_EXT" );
	swigIntConstant( VK_DYNAMIC_STATE_DEPTH_COMPARE_OP_EXT, "VK_DYNAMIC_STATE_DEPTH_COMPARE_OP_EXT" );
	swigIntConstant( VK_DYNAMIC_STATE_DEPTH_BOUNDS_TEST_ENABLE_EXT, "VK_DYNAMIC_STATE_DEPTH_BOUNDS_TEST_ENABLE_EXT" );
	swigIntConstant( VK_DYNAMIC_STATE_STENCIL_TEST_ENABLE_EXT, "VK_DYNAMIC_STATE_STENCIL_TEST_ENABLE_EXT" );
	swigIntConstant( VK_DYNAMIC_STATE_STENCIL_OP_EXT, "VK_DYNAMIC_STATE_STENCIL_OP_EXT" );
	swigIntConstant( VK_DYNAMIC_STATE_VERTEX_INPUT_EXT, "VK_DYNAMIC_STATE_VERTEX_INPUT_EXT" );
	swigIntConstant( VK_DYNAMIC_STATE_PATCH_CONTROL_POINTS_EXT, "VK_DYNAMIC_STATE_PATCH_CONTROL_POINTS_EXT" );
	swigIntConstant( VK_DYNAMIC_STATE_RASTERIZER_DISCARD_ENABLE_EXT, "VK_DYNAMIC_STATE_RASTERIZER_DISCARD_ENABLE_EXT" );
	swigIntConstant( VK_DYNAMIC_STATE_DEPTH_BIAS_ENABLE_EXT, "VK_DYNAMIC_STATE_DEPTH_BIAS_ENABLE_EXT" );
	swigIntConstant( VK_DYNAMIC_STATE_LOGIC_OP_EXT, "VK_DYNAMIC_STATE_LOGIC_OP_EXT" );
	swigIntConstant( VK_DYNAMIC_STATE_PRIMITIVE_RESTART_ENABLE_EXT, "VK_DYNAMIC_STATE_PRIMITIVE_RESTART_ENABLE_EXT" );
	swigIntConstant( VK_DYNAMIC_STATE_COLOR_WRITE_ENABLE_EXT, "VK_DYNAMIC_STATE_COLOR_WRITE_ENABLE_EXT" );
	swigIntConstant( VK_DYNAMIC_STATE_MAX_ENUM, "VK_DYNAMIC_STATE_MAX_ENUM" );
	swigIntConstant( VK_FRONT_FACE_COUNTER_CLOCKWISE, "VK_FRONT_FACE_COUNTER_CLOCKWISE" );
	swigIntConstant( VK_FRONT_FACE_CLOCKWISE, "VK_FRONT_FACE_CLOCKWISE" );
	swigIntConstant( VK_FRONT_FACE_MAX_ENUM, "VK_FRONT_FACE_MAX_ENUM" );
	swigIntConstant( VK_VERTEX_INPUT_RATE_VERTEX, "VK_VERTEX_INPUT_RATE_VERTEX" );
	swigIntConstant( VK_VERTEX_INPUT_RATE_INSTANCE, "VK_VERTEX_INPUT_RATE_INSTANCE" );
	swigIntConstant( VK_VERTEX_INPUT_RATE_MAX_ENUM, "VK_VERTEX_INPUT_RATE_MAX_ENUM" );
	swigIntConstant( VK_PRIMITIVE_TOPOLOGY_POINT_LIST, "VK_PRIMITIVE_TOPOLOGY_POINT_LIST" );
	swigIntConstant( VK_PRIMITIVE_TOPOLOGY_LINE_LIST, "VK_PRIMITIVE_TOPOLOGY_LINE_LIST" );
	swigIntConstant( VK_PRIMITIVE_TOPOLOGY_LINE_STRIP, "VK_PRIMITIVE_TOPOLOGY_LINE_STRIP" );
	swigIntConstant( VK_PRIMITIVE_TOPOLOGY_TRIANGLE_LIST, "VK_PRIMITIVE_TOPOLOGY_TRIANGLE_LIST" );
	swigIntConstant( VK_PRIMITIVE_TOPOLOGY_TRIANGLE_STRIP, "VK_PRIMITIVE_TOPOLOGY_TRIANGLE_STRIP" );
	swigIntConstant( VK_PRIMITIVE_TOPOLOGY_TRIANGLE_FAN, "VK_PRIMITIVE_TOPOLOGY_TRIANGLE_FAN" );
	swigIntConstant( VK_PRIMITIVE_TOPOLOGY_LINE_LIST_WITH_ADJACENCY, "VK_PRIMITIVE_TOPOLOGY_LINE_LIST_WITH_ADJACENCY" );
	swigIntConstant( VK_PRIMITIVE_TOPOLOGY_LINE_STRIP_WITH_ADJACENCY, "VK_PRIMITIVE_TOPOLOGY_LINE_STRIP_WITH_ADJACENCY" );
	swigIntConstant( VK_PRIMITIVE_TOPOLOGY_TRIANGLE_LIST_WITH_ADJACENCY, "VK_PRIMITIVE_TOPOLOGY_TRIANGLE_LIST_WITH_ADJACENCY" );
	swigIntConstant( VK_PRIMITIVE_TOPOLOGY_TRIANGLE_STRIP_WITH_ADJACENCY, "VK_PRIMITIVE_TOPOLOGY_TRIANGLE_STRIP_WITH_ADJACENCY" );
	swigIntConstant( VK_PRIMITIVE_TOPOLOGY_PATCH_LIST, "VK_PRIMITIVE_TOPOLOGY_PATCH_LIST" );
	swigIntConstant( VK_PRIMITIVE_TOPOLOGY_MAX_ENUM, "VK_PRIMITIVE_TOPOLOGY_MAX_ENUM" );
	swigIntConstant( VK_POLYGON_MODE_FILL, "VK_POLYGON_MODE_FILL" );
	swigIntConstant( VK_POLYGON_MODE_LINE, "VK_POLYGON_MODE_LINE" );
	swigIntConstant( VK_POLYGON_MODE_POINT, "VK_POLYGON_MODE_POINT" );
	swigIntConstant( VK_POLYGON_MODE_FILL_RECTANGLE_NV, "VK_POLYGON_MODE_FILL_RECTANGLE_NV" );
	swigIntConstant( VK_POLYGON_MODE_MAX_ENUM, "VK_POLYGON_MODE_MAX_ENUM" );
	swigIntConstant( VK_STENCIL_OP_KEEP, "VK_STENCIL_OP_KEEP" );
	swigIntConstant( VK_STENCIL_OP_ZERO, "VK_STENCIL_OP_ZERO" );
	swigIntConstant( VK_STENCIL_OP_REPLACE, "VK_STENCIL_OP_REPLACE" );
	swigIntConstant( VK_STENCIL_OP_INCREMENT_AND_CLAMP, "VK_STENCIL_OP_INCREMENT_AND_CLAMP" );
	swigIntConstant( VK_STENCIL_OP_DECREMENT_AND_CLAMP, "VK_STENCIL_OP_DECREMENT_AND_CLAMP" );
	swigIntConstant( VK_STENCIL_OP_INVERT, "VK_STENCIL_OP_INVERT" );
	swigIntConstant( VK_STENCIL_OP_INCREMENT_AND_WRAP, "VK_STENCIL_OP_INCREMENT_AND_WRAP" );
	swigIntConstant( VK_STENCIL_OP_DECREMENT_AND_WRAP, "VK_STENCIL_OP_DECREMENT_AND_WRAP" );
	swigIntConstant( VK_STENCIL_OP_MAX_ENUM, "VK_STENCIL_OP_MAX_ENUM" );
	swigIntConstant( VK_LOGIC_OP_CLEAR, "VK_LOGIC_OP_CLEAR" );
	swigIntConstant( VK_LOGIC_OP_AND, "VK_LOGIC_OP_AND" );
	swigIntConstant( VK_LOGIC_OP_AND_REVERSE, "VK_LOGIC_OP_AND_REVERSE" );
	swigIntConstant( VK_LOGIC_OP_COPY, "VK_LOGIC_OP_COPY" );
	swigIntConstant( VK_LOGIC_OP_AND_INVERTED, "VK_LOGIC_OP_AND_INVERTED" );
	swigIntConstant( VK_LOGIC_OP_NO_OP, "VK_LOGIC_OP_NO_OP" );
	swigIntConstant( VK_LOGIC_OP_XOR, "VK_LOGIC_OP_XOR" );
	swigIntConstant( VK_LOGIC_OP_OR, "VK_LOGIC_OP_OR" );
	swigIntConstant( VK_LOGIC_OP_NOR, "VK_LOGIC_OP_NOR" );
	swigIntConstant( VK_LOGIC_OP_EQUIVALENT, "VK_LOGIC_OP_EQUIVALENT" );
	swigIntConstant( VK_LOGIC_OP_INVERT, "VK_LOGIC_OP_INVERT" );
	swigIntConstant( VK_LOGIC_OP_OR_REVERSE, "VK_LOGIC_OP_OR_REVERSE" );
	swigIntConstant( VK_LOGIC_OP_COPY_INVERTED, "VK_LOGIC_OP_COPY_INVERTED" );
	swigIntConstant( VK_LOGIC_OP_OR_INVERTED, "VK_LOGIC_OP_OR_INVERTED" );
	swigIntConstant( VK_LOGIC_OP_NAND, "VK_LOGIC_OP_NAND" );
	swigIntConstant( VK_LOGIC_OP_SET, "VK_LOGIC_OP_SET" );
	swigIntConstant( VK_LOGIC_OP_MAX_ENUM, "VK_LOGIC_OP_MAX_ENUM" );
	swigIntConstant( VK_BORDER_COLOR_FLOAT_TRANSPARENT_BLACK, "VK_BORDER_COLOR_FLOAT_TRANSPARENT_BLACK" );
	swigIntConstant( VK_BORDER_COLOR_INT_TRANSPARENT_BLACK, "VK_BORDER_COLOR_INT_TRANSPARENT_BLACK" );
	swigIntConstant( VK_BORDER_COLOR_FLOAT_OPAQUE_BLACK, "VK_BORDER_COLOR_FLOAT_OPAQUE_BLACK" );
	swigIntConstant( VK_BORDER_COLOR_INT_OPAQUE_BLACK, "VK_BORDER_COLOR_INT_OPAQUE_BLACK" );
	swigIntConstant( VK_BORDER_COLOR_FLOAT_OPAQUE_WHITE, "VK_BORDER_COLOR_FLOAT_OPAQUE_WHITE" );
	swigIntConstant( VK_BORDER_COLOR_INT_OPAQUE_WHITE, "VK_BORDER_COLOR_INT_OPAQUE_WHITE" );
	swigIntConstant( VK_BORDER_COLOR_FLOAT_CUSTOM_EXT, "VK_BORDER_COLOR_FLOAT_CUSTOM_EXT" );
	swigIntConstant( VK_BORDER_COLOR_INT_CUSTOM_EXT, "VK_BORDER_COLOR_INT_CUSTOM_EXT" );
	swigIntConstant( VK_BORDER_COLOR_MAX_ENUM, "VK_BORDER_COLOR_MAX_ENUM" );
	swigIntConstant( VK_FILTER_NEAREST, "VK_FILTER_NEAREST" );
	swigIntConstant( VK_FILTER_LINEAR, "VK_FILTER_LINEAR" );
	swigIntConstant( VK_FILTER_CUBIC_IMG, "VK_FILTER_CUBIC_IMG" );
	swigIntConstant( VK_FILTER_CUBIC_EXT, "VK_FILTER_CUBIC_EXT" );
	swigIntConstant( VK_FILTER_MAX_ENUM, "VK_FILTER_MAX_ENUM" );
	swigIntConstant( VK_SAMPLER_ADDRESS_MODE_REPEAT, "VK_SAMPLER_ADDRESS_MODE_REPEAT" );
	swigIntConstant( VK_SAMPLER_ADDRESS_MODE_MIRRORED_REPEAT, "VK_SAMPLER_ADDRESS_MODE_MIRRORED_REPEAT" );
	swigIntConstant( VK_SAMPLER_ADDRESS_MODE_CLAMP_TO_EDGE, "VK_SAMPLER_ADDRESS_MODE_CLAMP_TO_EDGE" );
	swigIntConstant( VK_SAMPLER_ADDRESS_MODE_CLAMP_TO_BORDER, "VK_SAMPLER_ADDRESS_MODE_CLAMP_TO_BORDER" );
	swigIntConstant( VK_SAMPLER_ADDRESS_MODE_MIRROR_CLAMP_TO_EDGE, "VK_SAMPLER_ADDRESS_MODE_MIRROR_CLAMP_TO_EDGE" );
	swigIntConstant( VK_SAMPLER_ADDRESS_MODE_MIRROR_CLAMP_TO_EDGE_KHR, "VK_SAMPLER_ADDRESS_MODE_MIRROR_CLAMP_TO_EDGE_KHR" );
	swigIntConstant( VK_SAMPLER_ADDRESS_MODE_MAX_ENUM, "VK_SAMPLER_ADDRESS_MODE_MAX_ENUM" );
	swigIntConstant( VK_SAMPLER_MIPMAP_MODE_NEAREST, "VK_SAMPLER_MIPMAP_MODE_NEAREST" );
	swigIntConstant( VK_SAMPLER_MIPMAP_MODE_LINEAR, "VK_SAMPLER_MIPMAP_MODE_LINEAR" );
	swigIntConstant( VK_SAMPLER_MIPMAP_MODE_MAX_ENUM, "VK_SAMPLER_MIPMAP_MODE_MAX_ENUM" );
	swigIntConstant( VK_DESCRIPTOR_TYPE_SAMPLER, "VK_DESCRIPTOR_TYPE_SAMPLER" );
	swigIntConstant( VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, "VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER" );
	swigIntConstant( VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE, "VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE" );
	swigIntConstant( VK_DESCRIPTOR_TYPE_STORAGE_IMAGE, "VK_DESCRIPTOR_TYPE_STORAGE_IMAGE" );
	swigIntConstant( VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER, "VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER" );
	swigIntConstant( VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER, "VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER" );
	swigIntConstant( VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER, "VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER" );
	swigIntConstant( VK_DESCRIPTOR_TYPE_STORAGE_BUFFER, "VK_DESCRIPTOR_TYPE_STORAGE_BUFFER" );
	swigIntConstant( VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC, "VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC" );
	swigIntConstant( VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC, "VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC" );
	swigIntConstant( VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT, "VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT" );
	swigIntConstant( VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK_EXT, "VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK_EXT" );
	swigIntConstant( VK_DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_KHR, "VK_DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_KHR" );
	swigIntConstant( VK_DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_NV, "VK_DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_NV" );
	swigIntConstant( VK_DESCRIPTOR_TYPE_MUTABLE_VALVE, "VK_DESCRIPTOR_TYPE_MUTABLE_VALVE" );
	swigIntConstant( VK_DESCRIPTOR_TYPE_MAX_ENUM, "VK_DESCRIPTOR_TYPE_MAX_ENUM" );
	swigIntConstant( VK_ATTACHMENT_LOAD_OP_LOAD, "VK_ATTACHMENT_LOAD_OP_LOAD" );
	swigIntConstant( VK_ATTACHMENT_LOAD_OP_CLEAR, "VK_ATTACHMENT_LOAD_OP_CLEAR" );
	swigIntConstant( VK_ATTACHMENT_LOAD_OP_DONT_CARE, "VK_ATTACHMENT_LOAD_OP_DONT_CARE" );
	swigIntConstant( VK_ATTACHMENT_LOAD_OP_NONE_EXT, "VK_ATTACHMENT_LOAD_OP_NONE_EXT" );
	swigIntConstant( VK_ATTACHMENT_LOAD_OP_MAX_ENUM, "VK_ATTACHMENT_LOAD_OP_MAX_ENUM" );
	swigIntConstant( VK_ATTACHMENT_STORE_OP_STORE, "VK_ATTACHMENT_STORE_OP_STORE" );
	swigIntConstant( VK_ATTACHMENT_STORE_OP_DONT_CARE, "VK_ATTACHMENT_STORE_OP_DONT_CARE" );
	swigIntConstant( VK_ATTACHMENT_STORE_OP_NONE_KHR, "VK_ATTACHMENT_STORE_OP_NONE_KHR" );
	swigIntConstant( VK_ATTACHMENT_STORE_OP_NONE_QCOM, "VK_ATTACHMENT_STORE_OP_NONE_QCOM" );
	swigIntConstant( VK_ATTACHMENT_STORE_OP_NONE_EXT, "VK_ATTACHMENT_STORE_OP_NONE_EXT" );
	swigIntConstant( VK_ATTACHMENT_STORE_OP_MAX_ENUM, "VK_ATTACHMENT_STORE_OP_MAX_ENUM" );
	swigIntConstant( VK_PIPELINE_BIND_POINT_GRAPHICS, "VK_PIPELINE_BIND_POINT_GRAPHICS" );
	swigIntConstant( VK_PIPELINE_BIND_POINT_COMPUTE, "VK_PIPELINE_BIND_POINT_COMPUTE" );
	swigIntConstant( VK_PIPELINE_BIND_POINT_RAY_TRACING_KHR, "VK_PIPELINE_BIND_POINT_RAY_TRACING_KHR" );
	swigIntConstant( VK_PIPELINE_BIND_POINT_SUBPASS_SHADING_HUAWEI, "VK_PIPELINE_BIND_POINT_SUBPASS_SHADING_HUAWEI" );
	swigIntConstant( VK_PIPELINE_BIND_POINT_RAY_TRACING_NV, "VK_PIPELINE_BIND_POINT_RAY_TRACING_NV" );
	swigIntConstant( VK_PIPELINE_BIND_POINT_MAX_ENUM, "VK_PIPELINE_BIND_POINT_MAX_ENUM" );
	swigIntConstant( VK_COMMAND_BUFFER_LEVEL_PRIMARY, "VK_COMMAND_BUFFER_LEVEL_PRIMARY" );
	swigIntConstant( VK_COMMAND_BUFFER_LEVEL_SECONDARY, "VK_COMMAND_BUFFER_LEVEL_SECONDARY" );
	swigIntConstant( VK_COMMAND_BUFFER_LEVEL_MAX_ENUM, "VK_COMMAND_BUFFER_LEVEL_MAX_ENUM" );
	swigIntConstant( VK_INDEX_TYPE_UINT16, "VK_INDEX_TYPE_UINT16" );
	swigIntConstant( VK_INDEX_TYPE_UINT32, "VK_INDEX_TYPE_UINT32" );
	swigIntConstant( VK_INDEX_TYPE_NONE_KHR, "VK_INDEX_TYPE_NONE_KHR" );
	swigIntConstant( VK_INDEX_TYPE_UINT8_EXT, "VK_INDEX_TYPE_UINT8_EXT" );
	swigIntConstant( VK_INDEX_TYPE_NONE_NV, "VK_INDEX_TYPE_NONE_NV" );
	swigIntConstant( VK_INDEX_TYPE_MAX_ENUM, "VK_INDEX_TYPE_MAX_ENUM" );
	swigIntConstant( VK_SUBPASS_CONTENTS_INLINE, "VK_SUBPASS_CONTENTS_INLINE" );
	swigIntConstant( VK_SUBPASS_CONTENTS_SECONDARY_COMMAND_BUFFERS, "VK_SUBPASS_CONTENTS_SECONDARY_COMMAND_BUFFERS" );
	swigIntConstant( VK_SUBPASS_CONTENTS_MAX_ENUM, "VK_SUBPASS_CONTENTS_MAX_ENUM" );
	swigIntConstant( VK_ACCESS_INDIRECT_COMMAND_READ_BIT, "VK_ACCESS_INDIRECT_COMMAND_READ_BIT" );
	swigIntConstant( VK_ACCESS_INDEX_READ_BIT, "VK_ACCESS_INDEX_READ_BIT" );
	swigIntConstant( VK_ACCESS_VERTEX_ATTRIBUTE_READ_BIT, "VK_ACCESS_VERTEX_ATTRIBUTE_READ_BIT" );
	swigIntConstant( VK_ACCESS_UNIFORM_READ_BIT, "VK_ACCESS_UNIFORM_READ_BIT" );
	swigIntConstant( VK_ACCESS_INPUT_ATTACHMENT_READ_BIT, "VK_ACCESS_INPUT_ATTACHMENT_READ_BIT" );
	swigIntConstant( VK_ACCESS_SHADER_READ_BIT, "VK_ACCESS_SHADER_READ_BIT" );
	swigIntConstant( VK_ACCESS_SHADER_WRITE_BIT, "VK_ACCESS_SHADER_WRITE_BIT" );
	swigIntConstant( VK_ACCESS_COLOR_ATTACHMENT_READ_BIT, "VK_ACCESS_COLOR_ATTACHMENT_READ_BIT" );
	swigIntConstant( VK_ACCESS_COLOR_ATTACHMENT_WRITE_BIT, "VK_ACCESS_COLOR_ATTACHMENT_WRITE_BIT" );
	swigIntConstant( VK_ACCESS_DEPTH_STENCIL_ATTACHMENT_READ_BIT, "VK_ACCESS_DEPTH_STENCIL_ATTACHMENT_READ_BIT" );
	swigIntConstant( VK_ACCESS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT, "VK_ACCESS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT" );
	swigIntConstant( VK_ACCESS_TRANSFER_READ_BIT, "VK_ACCESS_TRANSFER_READ_BIT" );
	swigIntConstant( VK_ACCESS_TRANSFER_WRITE_BIT, "VK_ACCESS_TRANSFER_WRITE_BIT" );
	swigIntConstant( VK_ACCESS_HOST_READ_BIT, "VK_ACCESS_HOST_READ_BIT" );
	swigIntConstant( VK_ACCESS_HOST_WRITE_BIT, "VK_ACCESS_HOST_WRITE_BIT" );
	swigIntConstant( VK_ACCESS_MEMORY_READ_BIT, "VK_ACCESS_MEMORY_READ_BIT" );
	swigIntConstant( VK_ACCESS_MEMORY_WRITE_BIT, "VK_ACCESS_MEMORY_WRITE_BIT" );
	swigIntConstant( VK_ACCESS_TRANSFORM_FEEDBACK_WRITE_BIT_EXT, "VK_ACCESS_TRANSFORM_FEEDBACK_WRITE_BIT_EXT" );
	swigIntConstant( VK_ACCESS_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT, "VK_ACCESS_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT" );
	swigIntConstant( VK_ACCESS_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT, "VK_ACCESS_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT" );
	swigIntConstant( VK_ACCESS_CONDITIONAL_RENDERING_READ_BIT_EXT, "VK_ACCESS_CONDITIONAL_RENDERING_READ_BIT_EXT" );
	swigIntConstant( VK_ACCESS_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT, "VK_ACCESS_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT" );
	swigIntConstant( VK_ACCESS_ACCELERATION_STRUCTURE_READ_BIT_KHR, "VK_ACCESS_ACCELERATION_STRUCTURE_READ_BIT_KHR" );
	swigIntConstant( VK_ACCESS_ACCELERATION_STRUCTURE_WRITE_BIT_KHR, "VK_ACCESS_ACCELERATION_STRUCTURE_WRITE_BIT_KHR" );
	swigIntConstant( VK_ACCESS_FRAGMENT_DENSITY_MAP_READ_BIT_EXT, "VK_ACCESS_FRAGMENT_DENSITY_MAP_READ_BIT_EXT" );
	swigIntConstant( VK_ACCESS_FRAGMENT_SHADING_RATE_ATTACHMENT_READ_BIT_KHR, "VK_ACCESS_FRAGMENT_SHADING_RATE_ATTACHMENT_READ_BIT_KHR" );
	swigIntConstant( VK_ACCESS_COMMAND_PREPROCESS_READ_BIT_NV, "VK_ACCESS_COMMAND_PREPROCESS_READ_BIT_NV" );
	swigIntConstant( VK_ACCESS_COMMAND_PREPROCESS_WRITE_BIT_NV, "VK_ACCESS_COMMAND_PREPROCESS_WRITE_BIT_NV" );
	swigIntConstant( VK_ACCESS_NONE_KHR, "VK_ACCESS_NONE_KHR" );
	swigIntConstant( VK_ACCESS_SHADING_RATE_IMAGE_READ_BIT_NV, "VK_ACCESS_SHADING_RATE_IMAGE_READ_BIT_NV" );
	swigIntConstant( VK_ACCESS_ACCELERATION_STRUCTURE_READ_BIT_NV, "VK_ACCESS_ACCELERATION_STRUCTURE_READ_BIT_NV" );
	swigIntConstant( VK_ACCESS_ACCELERATION_STRUCTURE_WRITE_BIT_NV, "VK_ACCESS_ACCELERATION_STRUCTURE_WRITE_BIT_NV" );
	swigIntConstant( VK_ACCESS_FLAG_BITS_MAX_ENUM, "VK_ACCESS_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_IMAGE_ASPECT_COLOR_BIT, "VK_IMAGE_ASPECT_COLOR_BIT" );
	swigIntConstant( VK_IMAGE_ASPECT_DEPTH_BIT, "VK_IMAGE_ASPECT_DEPTH_BIT" );
	swigIntConstant( VK_IMAGE_ASPECT_STENCIL_BIT, "VK_IMAGE_ASPECT_STENCIL_BIT" );
	swigIntConstant( VK_IMAGE_ASPECT_METADATA_BIT, "VK_IMAGE_ASPECT_METADATA_BIT" );
	swigIntConstant( VK_IMAGE_ASPECT_PLANE_0_BIT, "VK_IMAGE_ASPECT_PLANE_0_BIT" );
	swigIntConstant( VK_IMAGE_ASPECT_PLANE_1_BIT, "VK_IMAGE_ASPECT_PLANE_1_BIT" );
	swigIntConstant( VK_IMAGE_ASPECT_PLANE_2_BIT, "VK_IMAGE_ASPECT_PLANE_2_BIT" );
	swigIntConstant( VK_IMAGE_ASPECT_MEMORY_PLANE_0_BIT_EXT, "VK_IMAGE_ASPECT_MEMORY_PLANE_0_BIT_EXT" );
	swigIntConstant( VK_IMAGE_ASPECT_MEMORY_PLANE_1_BIT_EXT, "VK_IMAGE_ASPECT_MEMORY_PLANE_1_BIT_EXT" );
	swigIntConstant( VK_IMAGE_ASPECT_MEMORY_PLANE_2_BIT_EXT, "VK_IMAGE_ASPECT_MEMORY_PLANE_2_BIT_EXT" );
	swigIntConstant( VK_IMAGE_ASPECT_MEMORY_PLANE_3_BIT_EXT, "VK_IMAGE_ASPECT_MEMORY_PLANE_3_BIT_EXT" );
	swigIntConstant( VK_IMAGE_ASPECT_PLANE_0_BIT_KHR, "VK_IMAGE_ASPECT_PLANE_0_BIT_KHR" );
	swigIntConstant( VK_IMAGE_ASPECT_PLANE_1_BIT_KHR, "VK_IMAGE_ASPECT_PLANE_1_BIT_KHR" );
	swigIntConstant( VK_IMAGE_ASPECT_PLANE_2_BIT_KHR, "VK_IMAGE_ASPECT_PLANE_2_BIT_KHR" );
	swigIntConstant( VK_IMAGE_ASPECT_FLAG_BITS_MAX_ENUM, "VK_IMAGE_ASPECT_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_FORMAT_FEATURE_SAMPLED_IMAGE_BIT, "VK_FORMAT_FEATURE_SAMPLED_IMAGE_BIT" );
	swigIntConstant( VK_FORMAT_FEATURE_STORAGE_IMAGE_BIT, "VK_FORMAT_FEATURE_STORAGE_IMAGE_BIT" );
	swigIntConstant( VK_FORMAT_FEATURE_STORAGE_IMAGE_ATOMIC_BIT, "VK_FORMAT_FEATURE_STORAGE_IMAGE_ATOMIC_BIT" );
	swigIntConstant( VK_FORMAT_FEATURE_UNIFORM_TEXEL_BUFFER_BIT, "VK_FORMAT_FEATURE_UNIFORM_TEXEL_BUFFER_BIT" );
	swigIntConstant( VK_FORMAT_FEATURE_STORAGE_TEXEL_BUFFER_BIT, "VK_FORMAT_FEATURE_STORAGE_TEXEL_BUFFER_BIT" );
	swigIntConstant( VK_FORMAT_FEATURE_STORAGE_TEXEL_BUFFER_ATOMIC_BIT, "VK_FORMAT_FEATURE_STORAGE_TEXEL_BUFFER_ATOMIC_BIT" );
	swigIntConstant( VK_FORMAT_FEATURE_VERTEX_BUFFER_BIT, "VK_FORMAT_FEATURE_VERTEX_BUFFER_BIT" );
	swigIntConstant( VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BIT, "VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BIT" );
	swigIntConstant( VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BLEND_BIT, "VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BLEND_BIT" );
	swigIntConstant( VK_FORMAT_FEATURE_DEPTH_STENCIL_ATTACHMENT_BIT, "VK_FORMAT_FEATURE_DEPTH_STENCIL_ATTACHMENT_BIT" );
	swigIntConstant( VK_FORMAT_FEATURE_BLIT_SRC_BIT, "VK_FORMAT_FEATURE_BLIT_SRC_BIT" );
	swigIntConstant( VK_FORMAT_FEATURE_BLIT_DST_BIT, "VK_FORMAT_FEATURE_BLIT_DST_BIT" );
	swigIntConstant( VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_LINEAR_BIT, "VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_LINEAR_BIT" );
	swigIntConstant( VK_FORMAT_FEATURE_TRANSFER_SRC_BIT, "VK_FORMAT_FEATURE_TRANSFER_SRC_BIT" );
	swigIntConstant( VK_FORMAT_FEATURE_TRANSFER_DST_BIT, "VK_FORMAT_FEATURE_TRANSFER_DST_BIT" );
	swigIntConstant( VK_FORMAT_FEATURE_MIDPOINT_CHROMA_SAMPLES_BIT, "VK_FORMAT_FEATURE_MIDPOINT_CHROMA_SAMPLES_BIT" );
	swigIntConstant( VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_LINEAR_FILTER_BIT, "VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_LINEAR_FILTER_BIT" );
	swigIntConstant( VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_SEPARATE_RECONSTRUCTION_FILTER_BIT, "VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_SEPARATE_RECONSTRUCTION_FILTER_BIT" );
	swigIntConstant( VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_BIT, "VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_BIT" );
	swigIntConstant( VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_FORCEABLE_BIT, "VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_FORCEABLE_BIT" );
	swigIntConstant( VK_FORMAT_FEATURE_DISJOINT_BIT, "VK_FORMAT_FEATURE_DISJOINT_BIT" );
	swigIntConstant( VK_FORMAT_FEATURE_COSITED_CHROMA_SAMPLES_BIT, "VK_FORMAT_FEATURE_COSITED_CHROMA_SAMPLES_BIT" );
	swigIntConstant( VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_MINMAX_BIT, "VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_MINMAX_BIT" );
	swigIntConstant( VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_CUBIC_BIT_IMG, "VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_CUBIC_BIT_IMG" );
	swigIntConstant( VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR, "VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR" );
	swigIntConstant( VK_FORMAT_FEATURE_FRAGMENT_DENSITY_MAP_BIT_EXT, "VK_FORMAT_FEATURE_FRAGMENT_DENSITY_MAP_BIT_EXT" );
	swigIntConstant( VK_FORMAT_FEATURE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR, "VK_FORMAT_FEATURE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR" );
	swigIntConstant( VK_FORMAT_FEATURE_TRANSFER_SRC_BIT_KHR, "VK_FORMAT_FEATURE_TRANSFER_SRC_BIT_KHR" );
	swigIntConstant( VK_FORMAT_FEATURE_TRANSFER_DST_BIT_KHR, "VK_FORMAT_FEATURE_TRANSFER_DST_BIT_KHR" );
	swigIntConstant( VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_MINMAX_BIT_EXT, "VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_MINMAX_BIT_EXT" );
	swigIntConstant( VK_FORMAT_FEATURE_MIDPOINT_CHROMA_SAMPLES_BIT_KHR, "VK_FORMAT_FEATURE_MIDPOINT_CHROMA_SAMPLES_BIT_KHR" );
	swigIntConstant( VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_LINEAR_FILTER_BIT_KHR, "VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_LINEAR_FILTER_BIT_KHR" );
	swigIntConstant( VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_SEPARATE_RECONSTRUCTION_FILTER_BIT_KHR, "VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_SEPARATE_RECONSTRUCTION_FILTER_BIT_KHR" );
	swigIntConstant( VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_BIT_KHR, "VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_BIT_KHR" );
	swigIntConstant( VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_FORCEABLE_BIT_KHR, "VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_FORCEABLE_BIT_KHR" );
	swigIntConstant( VK_FORMAT_FEATURE_DISJOINT_BIT_KHR, "VK_FORMAT_FEATURE_DISJOINT_BIT_KHR" );
	swigIntConstant( VK_FORMAT_FEATURE_COSITED_CHROMA_SAMPLES_BIT_KHR, "VK_FORMAT_FEATURE_COSITED_CHROMA_SAMPLES_BIT_KHR" );
	swigIntConstant( VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_CUBIC_BIT_EXT, "VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_CUBIC_BIT_EXT" );
	swigIntConstant( VK_FORMAT_FEATURE_FLAG_BITS_MAX_ENUM, "VK_FORMAT_FEATURE_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_IMAGE_CREATE_SPARSE_BINDING_BIT, "VK_IMAGE_CREATE_SPARSE_BINDING_BIT" );
	swigIntConstant( VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT, "VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT" );
	swigIntConstant( VK_IMAGE_CREATE_SPARSE_ALIASED_BIT, "VK_IMAGE_CREATE_SPARSE_ALIASED_BIT" );
	swigIntConstant( VK_IMAGE_CREATE_MUTABLE_FORMAT_BIT, "VK_IMAGE_CREATE_MUTABLE_FORMAT_BIT" );
	swigIntConstant( VK_IMAGE_CREATE_CUBE_COMPATIBLE_BIT, "VK_IMAGE_CREATE_CUBE_COMPATIBLE_BIT" );
	swigIntConstant( VK_IMAGE_CREATE_ALIAS_BIT, "VK_IMAGE_CREATE_ALIAS_BIT" );
	swigIntConstant( VK_IMAGE_CREATE_SPLIT_INSTANCE_BIND_REGIONS_BIT, "VK_IMAGE_CREATE_SPLIT_INSTANCE_BIND_REGIONS_BIT" );
	swigIntConstant( VK_IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT, "VK_IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT" );
	swigIntConstant( VK_IMAGE_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT, "VK_IMAGE_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT" );
	swigIntConstant( VK_IMAGE_CREATE_EXTENDED_USAGE_BIT, "VK_IMAGE_CREATE_EXTENDED_USAGE_BIT" );
	swigIntConstant( VK_IMAGE_CREATE_PROTECTED_BIT, "VK_IMAGE_CREATE_PROTECTED_BIT" );
	swigIntConstant( VK_IMAGE_CREATE_DISJOINT_BIT, "VK_IMAGE_CREATE_DISJOINT_BIT" );
	swigIntConstant( VK_IMAGE_CREATE_CORNER_SAMPLED_BIT_NV, "VK_IMAGE_CREATE_CORNER_SAMPLED_BIT_NV" );
	swigIntConstant( VK_IMAGE_CREATE_SAMPLE_LOCATIONS_COMPATIBLE_DEPTH_BIT_EXT, "VK_IMAGE_CREATE_SAMPLE_LOCATIONS_COMPATIBLE_DEPTH_BIT_EXT" );
	swigIntConstant( VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT, "VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT" );
	swigIntConstant( VK_IMAGE_CREATE_SPLIT_INSTANCE_BIND_REGIONS_BIT_KHR, "VK_IMAGE_CREATE_SPLIT_INSTANCE_BIND_REGIONS_BIT_KHR" );
	swigIntConstant( VK_IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT_KHR, "VK_IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT_KHR" );
	swigIntConstant( VK_IMAGE_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT_KHR, "VK_IMAGE_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT_KHR" );
	swigIntConstant( VK_IMAGE_CREATE_EXTENDED_USAGE_BIT_KHR, "VK_IMAGE_CREATE_EXTENDED_USAGE_BIT_KHR" );
	swigIntConstant( VK_IMAGE_CREATE_DISJOINT_BIT_KHR, "VK_IMAGE_CREATE_DISJOINT_BIT_KHR" );
	swigIntConstant( VK_IMAGE_CREATE_ALIAS_BIT_KHR, "VK_IMAGE_CREATE_ALIAS_BIT_KHR" );
	swigIntConstant( VK_IMAGE_CREATE_FLAG_BITS_MAX_ENUM, "VK_IMAGE_CREATE_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_SAMPLE_COUNT_1_BIT, "VK_SAMPLE_COUNT_1_BIT" );
	swigIntConstant( VK_SAMPLE_COUNT_2_BIT, "VK_SAMPLE_COUNT_2_BIT" );
	swigIntConstant( VK_SAMPLE_COUNT_4_BIT, "VK_SAMPLE_COUNT_4_BIT" );
	swigIntConstant( VK_SAMPLE_COUNT_8_BIT, "VK_SAMPLE_COUNT_8_BIT" );
	swigIntConstant( VK_SAMPLE_COUNT_16_BIT, "VK_SAMPLE_COUNT_16_BIT" );
	swigIntConstant( VK_SAMPLE_COUNT_32_BIT, "VK_SAMPLE_COUNT_32_BIT" );
	swigIntConstant( VK_SAMPLE_COUNT_64_BIT, "VK_SAMPLE_COUNT_64_BIT" );
	swigIntConstant( VK_SAMPLE_COUNT_FLAG_BITS_MAX_ENUM, "VK_SAMPLE_COUNT_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_IMAGE_USAGE_TRANSFER_SRC_BIT, "VK_IMAGE_USAGE_TRANSFER_SRC_BIT" );
	swigIntConstant( VK_IMAGE_USAGE_TRANSFER_DST_BIT, "VK_IMAGE_USAGE_TRANSFER_DST_BIT" );
	swigIntConstant( VK_IMAGE_USAGE_SAMPLED_BIT, "VK_IMAGE_USAGE_SAMPLED_BIT" );
	swigIntConstant( VK_IMAGE_USAGE_STORAGE_BIT, "VK_IMAGE_USAGE_STORAGE_BIT" );
	swigIntConstant( VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT, "VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT" );
	swigIntConstant( VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT, "VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT" );
	swigIntConstant( VK_IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT, "VK_IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT" );
	swigIntConstant( VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT, "VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT" );
	swigIntConstant( VK_IMAGE_USAGE_FRAGMENT_DENSITY_MAP_BIT_EXT, "VK_IMAGE_USAGE_FRAGMENT_DENSITY_MAP_BIT_EXT" );
	swigIntConstant( VK_IMAGE_USAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR, "VK_IMAGE_USAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR" );
	swigIntConstant( VK_IMAGE_USAGE_INVOCATION_MASK_BIT_HUAWEI, "VK_IMAGE_USAGE_INVOCATION_MASK_BIT_HUAWEI" );
	swigIntConstant( VK_IMAGE_USAGE_SHADING_RATE_IMAGE_BIT_NV, "VK_IMAGE_USAGE_SHADING_RATE_IMAGE_BIT_NV" );
	swigIntConstant( VK_IMAGE_USAGE_FLAG_BITS_MAX_ENUM, "VK_IMAGE_USAGE_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_MEMORY_HEAP_DEVICE_LOCAL_BIT, "VK_MEMORY_HEAP_DEVICE_LOCAL_BIT" );
	swigIntConstant( VK_MEMORY_HEAP_MULTI_INSTANCE_BIT, "VK_MEMORY_HEAP_MULTI_INSTANCE_BIT" );
	swigIntConstant( VK_MEMORY_HEAP_MULTI_INSTANCE_BIT_KHR, "VK_MEMORY_HEAP_MULTI_INSTANCE_BIT_KHR" );
	swigIntConstant( VK_MEMORY_HEAP_FLAG_BITS_MAX_ENUM, "VK_MEMORY_HEAP_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_MEMORY_PROPERTY_DEVICE_LOCAL_BIT, "VK_MEMORY_PROPERTY_DEVICE_LOCAL_BIT" );
	swigIntConstant( VK_MEMORY_PROPERTY_HOST_VISIBLE_BIT, "VK_MEMORY_PROPERTY_HOST_VISIBLE_BIT" );
	swigIntConstant( VK_MEMORY_PROPERTY_HOST_COHERENT_BIT, "VK_MEMORY_PROPERTY_HOST_COHERENT_BIT" );
	swigIntConstant( VK_MEMORY_PROPERTY_HOST_CACHED_BIT, "VK_MEMORY_PROPERTY_HOST_CACHED_BIT" );
	swigIntConstant( VK_MEMORY_PROPERTY_LAZILY_ALLOCATED_BIT, "VK_MEMORY_PROPERTY_LAZILY_ALLOCATED_BIT" );
	swigIntConstant( VK_MEMORY_PROPERTY_PROTECTED_BIT, "VK_MEMORY_PROPERTY_PROTECTED_BIT" );
	swigIntConstant( VK_MEMORY_PROPERTY_DEVICE_COHERENT_BIT_AMD, "VK_MEMORY_PROPERTY_DEVICE_COHERENT_BIT_AMD" );
	swigIntConstant( VK_MEMORY_PROPERTY_DEVICE_UNCACHED_BIT_AMD, "VK_MEMORY_PROPERTY_DEVICE_UNCACHED_BIT_AMD" );
	swigIntConstant( VK_MEMORY_PROPERTY_RDMA_CAPABLE_BIT_NV, "VK_MEMORY_PROPERTY_RDMA_CAPABLE_BIT_NV" );
	swigIntConstant( VK_MEMORY_PROPERTY_FLAG_BITS_MAX_ENUM, "VK_MEMORY_PROPERTY_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_QUEUE_GRAPHICS_BIT, "VK_QUEUE_GRAPHICS_BIT" );
	swigIntConstant( VK_QUEUE_COMPUTE_BIT, "VK_QUEUE_COMPUTE_BIT" );
	swigIntConstant( VK_QUEUE_TRANSFER_BIT, "VK_QUEUE_TRANSFER_BIT" );
	swigIntConstant( VK_QUEUE_SPARSE_BINDING_BIT, "VK_QUEUE_SPARSE_BINDING_BIT" );
	swigIntConstant( VK_QUEUE_PROTECTED_BIT, "VK_QUEUE_PROTECTED_BIT" );
	swigIntConstant( VK_QUEUE_FLAG_BITS_MAX_ENUM, "VK_QUEUE_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_DEVICE_QUEUE_CREATE_PROTECTED_BIT, "VK_DEVICE_QUEUE_CREATE_PROTECTED_BIT" );
	swigIntConstant( VK_DEVICE_QUEUE_CREATE_FLAG_BITS_MAX_ENUM, "VK_DEVICE_QUEUE_CREATE_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_PIPELINE_STAGE_TOP_OF_PIPE_BIT, "VK_PIPELINE_STAGE_TOP_OF_PIPE_BIT" );
	swigIntConstant( VK_PIPELINE_STAGE_DRAW_INDIRECT_BIT, "VK_PIPELINE_STAGE_DRAW_INDIRECT_BIT" );
	swigIntConstant( VK_PIPELINE_STAGE_VERTEX_INPUT_BIT, "VK_PIPELINE_STAGE_VERTEX_INPUT_BIT" );
	swigIntConstant( VK_PIPELINE_STAGE_VERTEX_SHADER_BIT, "VK_PIPELINE_STAGE_VERTEX_SHADER_BIT" );
	swigIntConstant( VK_PIPELINE_STAGE_TESSELLATION_CONTROL_SHADER_BIT, "VK_PIPELINE_STAGE_TESSELLATION_CONTROL_SHADER_BIT" );
	swigIntConstant( VK_PIPELINE_STAGE_TESSELLATION_EVALUATION_SHADER_BIT, "VK_PIPELINE_STAGE_TESSELLATION_EVALUATION_SHADER_BIT" );
	swigIntConstant( VK_PIPELINE_STAGE_GEOMETRY_SHADER_BIT, "VK_PIPELINE_STAGE_GEOMETRY_SHADER_BIT" );
	swigIntConstant( VK_PIPELINE_STAGE_FRAGMENT_SHADER_BIT, "VK_PIPELINE_STAGE_FRAGMENT_SHADER_BIT" );
	swigIntConstant( VK_PIPELINE_STAGE_EARLY_FRAGMENT_TESTS_BIT, "VK_PIPELINE_STAGE_EARLY_FRAGMENT_TESTS_BIT" );
	swigIntConstant( VK_PIPELINE_STAGE_LATE_FRAGMENT_TESTS_BIT, "VK_PIPELINE_STAGE_LATE_FRAGMENT_TESTS_BIT" );
	swigIntConstant( VK_PIPELINE_STAGE_COLOR_ATTACHMENT_OUTPUT_BIT, "VK_PIPELINE_STAGE_COLOR_ATTACHMENT_OUTPUT_BIT" );
	swigIntConstant( VK_PIPELINE_STAGE_COMPUTE_SHADER_BIT, "VK_PIPELINE_STAGE_COMPUTE_SHADER_BIT" );
	swigIntConstant( VK_PIPELINE_STAGE_TRANSFER_BIT, "VK_PIPELINE_STAGE_TRANSFER_BIT" );
	swigIntConstant( VK_PIPELINE_STAGE_BOTTOM_OF_PIPE_BIT, "VK_PIPELINE_STAGE_BOTTOM_OF_PIPE_BIT" );
	swigIntConstant( VK_PIPELINE_STAGE_HOST_BIT, "VK_PIPELINE_STAGE_HOST_BIT" );
	swigIntConstant( VK_PIPELINE_STAGE_ALL_GRAPHICS_BIT, "VK_PIPELINE_STAGE_ALL_GRAPHICS_BIT" );
	swigIntConstant( VK_PIPELINE_STAGE_ALL_COMMANDS_BIT, "VK_PIPELINE_STAGE_ALL_COMMANDS_BIT" );
	swigIntConstant( VK_PIPELINE_STAGE_TRANSFORM_FEEDBACK_BIT_EXT, "VK_PIPELINE_STAGE_TRANSFORM_FEEDBACK_BIT_EXT" );
	swigIntConstant( VK_PIPELINE_STAGE_CONDITIONAL_RENDERING_BIT_EXT, "VK_PIPELINE_STAGE_CONDITIONAL_RENDERING_BIT_EXT" );
	swigIntConstant( VK_PIPELINE_STAGE_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, "VK_PIPELINE_STAGE_ACCELERATION_STRUCTURE_BUILD_BIT_KHR" );
	swigIntConstant( VK_PIPELINE_STAGE_RAY_TRACING_SHADER_BIT_KHR, "VK_PIPELINE_STAGE_RAY_TRACING_SHADER_BIT_KHR" );
	swigIntConstant( VK_PIPELINE_STAGE_TASK_SHADER_BIT_NV, "VK_PIPELINE_STAGE_TASK_SHADER_BIT_NV" );
	swigIntConstant( VK_PIPELINE_STAGE_MESH_SHADER_BIT_NV, "VK_PIPELINE_STAGE_MESH_SHADER_BIT_NV" );
	swigIntConstant( VK_PIPELINE_STAGE_FRAGMENT_DENSITY_PROCESS_BIT_EXT, "VK_PIPELINE_STAGE_FRAGMENT_DENSITY_PROCESS_BIT_EXT" );
	swigIntConstant( VK_PIPELINE_STAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR, "VK_PIPELINE_STAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR" );
	swigIntConstant( VK_PIPELINE_STAGE_COMMAND_PREPROCESS_BIT_NV, "VK_PIPELINE_STAGE_COMMAND_PREPROCESS_BIT_NV" );
	swigIntConstant( VK_PIPELINE_STAGE_NONE_KHR, "VK_PIPELINE_STAGE_NONE_KHR" );
	swigIntConstant( VK_PIPELINE_STAGE_SHADING_RATE_IMAGE_BIT_NV, "VK_PIPELINE_STAGE_SHADING_RATE_IMAGE_BIT_NV" );
	swigIntConstant( VK_PIPELINE_STAGE_RAY_TRACING_SHADER_BIT_NV, "VK_PIPELINE_STAGE_RAY_TRACING_SHADER_BIT_NV" );
	swigIntConstant( VK_PIPELINE_STAGE_ACCELERATION_STRUCTURE_BUILD_BIT_NV, "VK_PIPELINE_STAGE_ACCELERATION_STRUCTURE_BUILD_BIT_NV" );
	swigIntConstant( VK_PIPELINE_STAGE_FLAG_BITS_MAX_ENUM, "VK_PIPELINE_STAGE_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_SPARSE_MEMORY_BIND_METADATA_BIT, "VK_SPARSE_MEMORY_BIND_METADATA_BIT" );
	swigIntConstant( VK_SPARSE_MEMORY_BIND_FLAG_BITS_MAX_ENUM, "VK_SPARSE_MEMORY_BIND_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_SPARSE_IMAGE_FORMAT_SINGLE_MIPTAIL_BIT, "VK_SPARSE_IMAGE_FORMAT_SINGLE_MIPTAIL_BIT" );
	swigIntConstant( VK_SPARSE_IMAGE_FORMAT_ALIGNED_MIP_SIZE_BIT, "VK_SPARSE_IMAGE_FORMAT_ALIGNED_MIP_SIZE_BIT" );
	swigIntConstant( VK_SPARSE_IMAGE_FORMAT_NONSTANDARD_BLOCK_SIZE_BIT, "VK_SPARSE_IMAGE_FORMAT_NONSTANDARD_BLOCK_SIZE_BIT" );
	swigIntConstant( VK_SPARSE_IMAGE_FORMAT_FLAG_BITS_MAX_ENUM, "VK_SPARSE_IMAGE_FORMAT_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_FENCE_CREATE_SIGNALED_BIT, "VK_FENCE_CREATE_SIGNALED_BIT" );
	swigIntConstant( VK_FENCE_CREATE_FLAG_BITS_MAX_ENUM, "VK_FENCE_CREATE_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_EVENT_CREATE_DEVICE_ONLY_BIT_KHR, "VK_EVENT_CREATE_DEVICE_ONLY_BIT_KHR" );
	swigIntConstant( VK_EVENT_CREATE_FLAG_BITS_MAX_ENUM, "VK_EVENT_CREATE_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_QUERY_PIPELINE_STATISTIC_INPUT_ASSEMBLY_VERTICES_BIT, "VK_QUERY_PIPELINE_STATISTIC_INPUT_ASSEMBLY_VERTICES_BIT" );
	swigIntConstant( VK_QUERY_PIPELINE_STATISTIC_INPUT_ASSEMBLY_PRIMITIVES_BIT, "VK_QUERY_PIPELINE_STATISTIC_INPUT_ASSEMBLY_PRIMITIVES_BIT" );
	swigIntConstant( VK_QUERY_PIPELINE_STATISTIC_VERTEX_SHADER_INVOCATIONS_BIT, "VK_QUERY_PIPELINE_STATISTIC_VERTEX_SHADER_INVOCATIONS_BIT" );
	swigIntConstant( VK_QUERY_PIPELINE_STATISTIC_GEOMETRY_SHADER_INVOCATIONS_BIT, "VK_QUERY_PIPELINE_STATISTIC_GEOMETRY_SHADER_INVOCATIONS_BIT" );
	swigIntConstant( VK_QUERY_PIPELINE_STATISTIC_GEOMETRY_SHADER_PRIMITIVES_BIT, "VK_QUERY_PIPELINE_STATISTIC_GEOMETRY_SHADER_PRIMITIVES_BIT" );
	swigIntConstant( VK_QUERY_PIPELINE_STATISTIC_CLIPPING_INVOCATIONS_BIT, "VK_QUERY_PIPELINE_STATISTIC_CLIPPING_INVOCATIONS_BIT" );
	swigIntConstant( VK_QUERY_PIPELINE_STATISTIC_CLIPPING_PRIMITIVES_BIT, "VK_QUERY_PIPELINE_STATISTIC_CLIPPING_PRIMITIVES_BIT" );
	swigIntConstant( VK_QUERY_PIPELINE_STATISTIC_FRAGMENT_SHADER_INVOCATIONS_BIT, "VK_QUERY_PIPELINE_STATISTIC_FRAGMENT_SHADER_INVOCATIONS_BIT" );
	swigIntConstant( VK_QUERY_PIPELINE_STATISTIC_TESSELLATION_CONTROL_SHADER_PATCHES_BIT, "VK_QUERY_PIPELINE_STATISTIC_TESSELLATION_CONTROL_SHADER_PATCHES_BIT" );
	swigIntConstant( VK_QUERY_PIPELINE_STATISTIC_TESSELLATION_EVALUATION_SHADER_INVOCATIONS_BIT, "VK_QUERY_PIPELINE_STATISTIC_TESSELLATION_EVALUATION_SHADER_INVOCATIONS_BIT" );
	swigIntConstant( VK_QUERY_PIPELINE_STATISTIC_COMPUTE_SHADER_INVOCATIONS_BIT, "VK_QUERY_PIPELINE_STATISTIC_COMPUTE_SHADER_INVOCATIONS_BIT" );
	swigIntConstant( VK_QUERY_PIPELINE_STATISTIC_FLAG_BITS_MAX_ENUM, "VK_QUERY_PIPELINE_STATISTIC_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_QUERY_RESULT_64_BIT, "VK_QUERY_RESULT_64_BIT" );
	swigIntConstant( VK_QUERY_RESULT_WAIT_BIT, "VK_QUERY_RESULT_WAIT_BIT" );
	swigIntConstant( VK_QUERY_RESULT_WITH_AVAILABILITY_BIT, "VK_QUERY_RESULT_WITH_AVAILABILITY_BIT" );
	swigIntConstant( VK_QUERY_RESULT_PARTIAL_BIT, "VK_QUERY_RESULT_PARTIAL_BIT" );
	swigIntConstant( VK_QUERY_RESULT_FLAG_BITS_MAX_ENUM, "VK_QUERY_RESULT_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_BUFFER_CREATE_SPARSE_BINDING_BIT, "VK_BUFFER_CREATE_SPARSE_BINDING_BIT" );
	swigIntConstant( VK_BUFFER_CREATE_SPARSE_RESIDENCY_BIT, "VK_BUFFER_CREATE_SPARSE_RESIDENCY_BIT" );
	swigIntConstant( VK_BUFFER_CREATE_SPARSE_ALIASED_BIT, "VK_BUFFER_CREATE_SPARSE_ALIASED_BIT" );
	swigIntConstant( VK_BUFFER_CREATE_PROTECTED_BIT, "VK_BUFFER_CREATE_PROTECTED_BIT" );
	swigIntConstant( VK_BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT, "VK_BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT" );
	swigIntConstant( VK_BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT_EXT, "VK_BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT_EXT" );
	swigIntConstant( VK_BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT_KHR, "VK_BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT_KHR" );
	swigIntConstant( VK_BUFFER_CREATE_FLAG_BITS_MAX_ENUM, "VK_BUFFER_CREATE_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_BUFFER_USAGE_TRANSFER_SRC_BIT, "VK_BUFFER_USAGE_TRANSFER_SRC_BIT" );
	swigIntConstant( VK_BUFFER_USAGE_TRANSFER_DST_BIT, "VK_BUFFER_USAGE_TRANSFER_DST_BIT" );
	swigIntConstant( VK_BUFFER_USAGE_UNIFORM_TEXEL_BUFFER_BIT, "VK_BUFFER_USAGE_UNIFORM_TEXEL_BUFFER_BIT" );
	swigIntConstant( VK_BUFFER_USAGE_STORAGE_TEXEL_BUFFER_BIT, "VK_BUFFER_USAGE_STORAGE_TEXEL_BUFFER_BIT" );
	swigIntConstant( VK_BUFFER_USAGE_UNIFORM_BUFFER_BIT, "VK_BUFFER_USAGE_UNIFORM_BUFFER_BIT" );
	swigIntConstant( VK_BUFFER_USAGE_STORAGE_BUFFER_BIT, "VK_BUFFER_USAGE_STORAGE_BUFFER_BIT" );
	swigIntConstant( VK_BUFFER_USAGE_INDEX_BUFFER_BIT, "VK_BUFFER_USAGE_INDEX_BUFFER_BIT" );
	swigIntConstant( VK_BUFFER_USAGE_VERTEX_BUFFER_BIT, "VK_BUFFER_USAGE_VERTEX_BUFFER_BIT" );
	swigIntConstant( VK_BUFFER_USAGE_INDIRECT_BUFFER_BIT, "VK_BUFFER_USAGE_INDIRECT_BUFFER_BIT" );
	swigIntConstant( VK_BUFFER_USAGE_SHADER_DEVICE_ADDRESS_BIT, "VK_BUFFER_USAGE_SHADER_DEVICE_ADDRESS_BIT" );
	swigIntConstant( VK_BUFFER_USAGE_TRANSFORM_FEEDBACK_BUFFER_BIT_EXT, "VK_BUFFER_USAGE_TRANSFORM_FEEDBACK_BUFFER_BIT_EXT" );
	swigIntConstant( VK_BUFFER_USAGE_TRANSFORM_FEEDBACK_COUNTER_BUFFER_BIT_EXT, "VK_BUFFER_USAGE_TRANSFORM_FEEDBACK_COUNTER_BUFFER_BIT_EXT" );
	swigIntConstant( VK_BUFFER_USAGE_CONDITIONAL_RENDERING_BIT_EXT, "VK_BUFFER_USAGE_CONDITIONAL_RENDERING_BIT_EXT" );
	swigIntConstant( VK_BUFFER_USAGE_ACCELERATION_STRUCTURE_BUILD_INPUT_READ_ONLY_BIT_KHR, "VK_BUFFER_USAGE_ACCELERATION_STRUCTURE_BUILD_INPUT_READ_ONLY_BIT_KHR" );
	swigIntConstant( VK_BUFFER_USAGE_ACCELERATION_STRUCTURE_STORAGE_BIT_KHR, "VK_BUFFER_USAGE_ACCELERATION_STRUCTURE_STORAGE_BIT_KHR" );
	swigIntConstant( VK_BUFFER_USAGE_SHADER_BINDING_TABLE_BIT_KHR, "VK_BUFFER_USAGE_SHADER_BINDING_TABLE_BIT_KHR" );
	swigIntConstant( VK_BUFFER_USAGE_RAY_TRACING_BIT_NV, "VK_BUFFER_USAGE_RAY_TRACING_BIT_NV" );
	swigIntConstant( VK_BUFFER_USAGE_SHADER_DEVICE_ADDRESS_BIT_EXT, "VK_BUFFER_USAGE_SHADER_DEVICE_ADDRESS_BIT_EXT" );
	swigIntConstant( VK_BUFFER_USAGE_SHADER_DEVICE_ADDRESS_BIT_KHR, "VK_BUFFER_USAGE_SHADER_DEVICE_ADDRESS_BIT_KHR" );
	swigIntConstant( VK_BUFFER_USAGE_FLAG_BITS_MAX_ENUM, "VK_BUFFER_USAGE_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_IMAGE_VIEW_CREATE_FRAGMENT_DENSITY_MAP_DYNAMIC_BIT_EXT, "VK_IMAGE_VIEW_CREATE_FRAGMENT_DENSITY_MAP_DYNAMIC_BIT_EXT" );
	swigIntConstant( VK_IMAGE_VIEW_CREATE_FRAGMENT_DENSITY_MAP_DEFERRED_BIT_EXT, "VK_IMAGE_VIEW_CREATE_FRAGMENT_DENSITY_MAP_DEFERRED_BIT_EXT" );
	swigIntConstant( VK_IMAGE_VIEW_CREATE_FLAG_BITS_MAX_ENUM, "VK_IMAGE_VIEW_CREATE_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_PIPELINE_CACHE_CREATE_EXTERNALLY_SYNCHRONIZED_BIT_EXT, "VK_PIPELINE_CACHE_CREATE_EXTERNALLY_SYNCHRONIZED_BIT_EXT" );
	swigIntConstant( VK_PIPELINE_CACHE_CREATE_FLAG_BITS_MAX_ENUM, "VK_PIPELINE_CACHE_CREATE_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_COLOR_COMPONENT_R_BIT, "VK_COLOR_COMPONENT_R_BIT" );
	swigIntConstant( VK_COLOR_COMPONENT_G_BIT, "VK_COLOR_COMPONENT_G_BIT" );
	swigIntConstant( VK_COLOR_COMPONENT_B_BIT, "VK_COLOR_COMPONENT_B_BIT" );
	swigIntConstant( VK_COLOR_COMPONENT_A_BIT, "VK_COLOR_COMPONENT_A_BIT" );
	swigIntConstant( VK_COLOR_COMPONENT_FLAG_BITS_MAX_ENUM, "VK_COLOR_COMPONENT_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_PIPELINE_CREATE_DISABLE_OPTIMIZATION_BIT, "VK_PIPELINE_CREATE_DISABLE_OPTIMIZATION_BIT" );
	swigIntConstant( VK_PIPELINE_CREATE_ALLOW_DERIVATIVES_BIT, "VK_PIPELINE_CREATE_ALLOW_DERIVATIVES_BIT" );
	swigIntConstant( VK_PIPELINE_CREATE_DERIVATIVE_BIT, "VK_PIPELINE_CREATE_DERIVATIVE_BIT" );
	swigIntConstant( VK_PIPELINE_CREATE_VIEW_INDEX_FROM_DEVICE_INDEX_BIT, "VK_PIPELINE_CREATE_VIEW_INDEX_FROM_DEVICE_INDEX_BIT" );
	swigIntConstant( VK_PIPELINE_CREATE_DISPATCH_BASE_BIT, "VK_PIPELINE_CREATE_DISPATCH_BASE_BIT" );
	swigIntConstant( VK_PIPELINE_RASTERIZATION_STATE_CREATE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR, "VK_PIPELINE_RASTERIZATION_STATE_CREATE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR" );
	swigIntConstant( VK_PIPELINE_RASTERIZATION_STATE_CREATE_FRAGMENT_DENSITY_MAP_ATTACHMENT_BIT_EXT, "VK_PIPELINE_RASTERIZATION_STATE_CREATE_FRAGMENT_DENSITY_MAP_ATTACHMENT_BIT_EXT" );
	swigIntConstant( VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_ANY_HIT_SHADERS_BIT_KHR, "VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_ANY_HIT_SHADERS_BIT_KHR" );
	swigIntConstant( VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_CLOSEST_HIT_SHADERS_BIT_KHR, "VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_CLOSEST_HIT_SHADERS_BIT_KHR" );
	swigIntConstant( VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_MISS_SHADERS_BIT_KHR, "VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_MISS_SHADERS_BIT_KHR" );
	swigIntConstant( VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_INTERSECTION_SHADERS_BIT_KHR, "VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_INTERSECTION_SHADERS_BIT_KHR" );
	swigIntConstant( VK_PIPELINE_CREATE_RAY_TRACING_SKIP_TRIANGLES_BIT_KHR, "VK_PIPELINE_CREATE_RAY_TRACING_SKIP_TRIANGLES_BIT_KHR" );
	swigIntConstant( VK_PIPELINE_CREATE_RAY_TRACING_SKIP_AABBS_BIT_KHR, "VK_PIPELINE_CREATE_RAY_TRACING_SKIP_AABBS_BIT_KHR" );
	swigIntConstant( VK_PIPELINE_CREATE_RAY_TRACING_SHADER_GROUP_HANDLE_CAPTURE_REPLAY_BIT_KHR, "VK_PIPELINE_CREATE_RAY_TRACING_SHADER_GROUP_HANDLE_CAPTURE_REPLAY_BIT_KHR" );
	swigIntConstant( VK_PIPELINE_CREATE_DEFER_COMPILE_BIT_NV, "VK_PIPELINE_CREATE_DEFER_COMPILE_BIT_NV" );
	swigIntConstant( VK_PIPELINE_CREATE_CAPTURE_STATISTICS_BIT_KHR, "VK_PIPELINE_CREATE_CAPTURE_STATISTICS_BIT_KHR" );
	swigIntConstant( VK_PIPELINE_CREATE_CAPTURE_INTERNAL_REPRESENTATIONS_BIT_KHR, "VK_PIPELINE_CREATE_CAPTURE_INTERNAL_REPRESENTATIONS_BIT_KHR" );
	swigIntConstant( VK_PIPELINE_CREATE_INDIRECT_BINDABLE_BIT_NV, "VK_PIPELINE_CREATE_INDIRECT_BINDABLE_BIT_NV" );
	swigIntConstant( VK_PIPELINE_CREATE_LIBRARY_BIT_KHR, "VK_PIPELINE_CREATE_LIBRARY_BIT_KHR" );
	swigIntConstant( VK_PIPELINE_CREATE_FAIL_ON_PIPELINE_COMPILE_REQUIRED_BIT_EXT, "VK_PIPELINE_CREATE_FAIL_ON_PIPELINE_COMPILE_REQUIRED_BIT_EXT" );
	swigIntConstant( VK_PIPELINE_CREATE_EARLY_RETURN_ON_FAILURE_BIT_EXT, "VK_PIPELINE_CREATE_EARLY_RETURN_ON_FAILURE_BIT_EXT" );
	swigIntConstant( VK_PIPELINE_CREATE_RAY_TRACING_ALLOW_MOTION_BIT_NV, "VK_PIPELINE_CREATE_RAY_TRACING_ALLOW_MOTION_BIT_NV" );
	swigIntConstant( VK_PIPELINE_CREATE_DISPATCH_BASE, "VK_PIPELINE_CREATE_DISPATCH_BASE" );
	swigIntConstant( VK_PIPELINE_CREATE_VIEW_INDEX_FROM_DEVICE_INDEX_BIT_KHR, "VK_PIPELINE_CREATE_VIEW_INDEX_FROM_DEVICE_INDEX_BIT_KHR" );
	swigIntConstant( VK_PIPELINE_CREATE_DISPATCH_BASE_KHR, "VK_PIPELINE_CREATE_DISPATCH_BASE_KHR" );
	swigIntConstant( VK_PIPELINE_CREATE_FLAG_BITS_MAX_ENUM, "VK_PIPELINE_CREATE_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_PIPELINE_SHADER_STAGE_CREATE_ALLOW_VARYING_SUBGROUP_SIZE_BIT_EXT, "VK_PIPELINE_SHADER_STAGE_CREATE_ALLOW_VARYING_SUBGROUP_SIZE_BIT_EXT" );
	swigIntConstant( VK_PIPELINE_SHADER_STAGE_CREATE_REQUIRE_FULL_SUBGROUPS_BIT_EXT, "VK_PIPELINE_SHADER_STAGE_CREATE_REQUIRE_FULL_SUBGROUPS_BIT_EXT" );
	swigIntConstant( VK_PIPELINE_SHADER_STAGE_CREATE_FLAG_BITS_MAX_ENUM, "VK_PIPELINE_SHADER_STAGE_CREATE_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_SHADER_STAGE_VERTEX_BIT, "VK_SHADER_STAGE_VERTEX_BIT" );
	swigIntConstant( VK_SHADER_STAGE_TESSELLATION_CONTROL_BIT, "VK_SHADER_STAGE_TESSELLATION_CONTROL_BIT" );
	swigIntConstant( VK_SHADER_STAGE_TESSELLATION_EVALUATION_BIT, "VK_SHADER_STAGE_TESSELLATION_EVALUATION_BIT" );
	swigIntConstant( VK_SHADER_STAGE_GEOMETRY_BIT, "VK_SHADER_STAGE_GEOMETRY_BIT" );
	swigIntConstant( VK_SHADER_STAGE_FRAGMENT_BIT, "VK_SHADER_STAGE_FRAGMENT_BIT" );
	swigIntConstant( VK_SHADER_STAGE_COMPUTE_BIT, "VK_SHADER_STAGE_COMPUTE_BIT" );
	swigIntConstant( VK_SHADER_STAGE_ALL_GRAPHICS, "VK_SHADER_STAGE_ALL_GRAPHICS" );
	swigIntConstant( VK_SHADER_STAGE_ALL, "VK_SHADER_STAGE_ALL" );
	swigIntConstant( VK_SHADER_STAGE_RAYGEN_BIT_KHR, "VK_SHADER_STAGE_RAYGEN_BIT_KHR" );
	swigIntConstant( VK_SHADER_STAGE_ANY_HIT_BIT_KHR, "VK_SHADER_STAGE_ANY_HIT_BIT_KHR" );
	swigIntConstant( VK_SHADER_STAGE_CLOSEST_HIT_BIT_KHR, "VK_SHADER_STAGE_CLOSEST_HIT_BIT_KHR" );
	swigIntConstant( VK_SHADER_STAGE_MISS_BIT_KHR, "VK_SHADER_STAGE_MISS_BIT_KHR" );
	swigIntConstant( VK_SHADER_STAGE_INTERSECTION_BIT_KHR, "VK_SHADER_STAGE_INTERSECTION_BIT_KHR" );
	swigIntConstant( VK_SHADER_STAGE_CALLABLE_BIT_KHR, "VK_SHADER_STAGE_CALLABLE_BIT_KHR" );
	swigIntConstant( VK_SHADER_STAGE_TASK_BIT_NV, "VK_SHADER_STAGE_TASK_BIT_NV" );
	swigIntConstant( VK_SHADER_STAGE_MESH_BIT_NV, "VK_SHADER_STAGE_MESH_BIT_NV" );
	swigIntConstant( VK_SHADER_STAGE_SUBPASS_SHADING_BIT_HUAWEI, "VK_SHADER_STAGE_SUBPASS_SHADING_BIT_HUAWEI" );
	swigIntConstant( VK_SHADER_STAGE_RAYGEN_BIT_NV, "VK_SHADER_STAGE_RAYGEN_BIT_NV" );
	swigIntConstant( VK_SHADER_STAGE_ANY_HIT_BIT_NV, "VK_SHADER_STAGE_ANY_HIT_BIT_NV" );
	swigIntConstant( VK_SHADER_STAGE_CLOSEST_HIT_BIT_NV, "VK_SHADER_STAGE_CLOSEST_HIT_BIT_NV" );
	swigIntConstant( VK_SHADER_STAGE_MISS_BIT_NV, "VK_SHADER_STAGE_MISS_BIT_NV" );
	swigIntConstant( VK_SHADER_STAGE_INTERSECTION_BIT_NV, "VK_SHADER_STAGE_INTERSECTION_BIT_NV" );
	swigIntConstant( VK_SHADER_STAGE_CALLABLE_BIT_NV, "VK_SHADER_STAGE_CALLABLE_BIT_NV" );
	swigIntConstant( VK_SHADER_STAGE_FLAG_BITS_MAX_ENUM, "VK_SHADER_STAGE_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_CULL_MODE_NONE, "VK_CULL_MODE_NONE" );
	swigIntConstant( VK_CULL_MODE_FRONT_BIT, "VK_CULL_MODE_FRONT_BIT" );
	swigIntConstant( VK_CULL_MODE_BACK_BIT, "VK_CULL_MODE_BACK_BIT" );
	swigIntConstant( VK_CULL_MODE_FRONT_AND_BACK, "VK_CULL_MODE_FRONT_AND_BACK" );
	swigIntConstant( VK_CULL_MODE_FLAG_BITS_MAX_ENUM, "VK_CULL_MODE_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_SAMPLER_CREATE_SUBSAMPLED_BIT_EXT, "VK_SAMPLER_CREATE_SUBSAMPLED_BIT_EXT" );
	swigIntConstant( VK_SAMPLER_CREATE_SUBSAMPLED_COARSE_RECONSTRUCTION_BIT_EXT, "VK_SAMPLER_CREATE_SUBSAMPLED_COARSE_RECONSTRUCTION_BIT_EXT" );
	swigIntConstant( VK_SAMPLER_CREATE_FLAG_BITS_MAX_ENUM, "VK_SAMPLER_CREATE_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_DESCRIPTOR_POOL_CREATE_FREE_DESCRIPTOR_SET_BIT, "VK_DESCRIPTOR_POOL_CREATE_FREE_DESCRIPTOR_SET_BIT" );
	swigIntConstant( VK_DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT, "VK_DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT" );
	swigIntConstant( VK_DESCRIPTOR_POOL_CREATE_HOST_ONLY_BIT_VALVE, "VK_DESCRIPTOR_POOL_CREATE_HOST_ONLY_BIT_VALVE" );
	swigIntConstant( VK_DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT_EXT, "VK_DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT_EXT" );
	swigIntConstant( VK_DESCRIPTOR_POOL_CREATE_FLAG_BITS_MAX_ENUM, "VK_DESCRIPTOR_POOL_CREATE_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT, "VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT" );
	swigIntConstant( VK_DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT_KHR, "VK_DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT_KHR" );
	swigIntConstant( VK_DESCRIPTOR_SET_LAYOUT_CREATE_HOST_ONLY_POOL_BIT_VALVE, "VK_DESCRIPTOR_SET_LAYOUT_CREATE_HOST_ONLY_POOL_BIT_VALVE" );
	swigIntConstant( VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT_EXT, "VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT_EXT" );
	swigIntConstant( VK_DESCRIPTOR_SET_LAYOUT_CREATE_FLAG_BITS_MAX_ENUM, "VK_DESCRIPTOR_SET_LAYOUT_CREATE_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_ATTACHMENT_DESCRIPTION_MAY_ALIAS_BIT, "VK_ATTACHMENT_DESCRIPTION_MAY_ALIAS_BIT" );
	swigIntConstant( VK_ATTACHMENT_DESCRIPTION_FLAG_BITS_MAX_ENUM, "VK_ATTACHMENT_DESCRIPTION_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_DEPENDENCY_BY_REGION_BIT, "VK_DEPENDENCY_BY_REGION_BIT" );
	swigIntConstant( VK_DEPENDENCY_DEVICE_GROUP_BIT, "VK_DEPENDENCY_DEVICE_GROUP_BIT" );
	swigIntConstant( VK_DEPENDENCY_VIEW_LOCAL_BIT, "VK_DEPENDENCY_VIEW_LOCAL_BIT" );
	swigIntConstant( VK_DEPENDENCY_VIEW_LOCAL_BIT_KHR, "VK_DEPENDENCY_VIEW_LOCAL_BIT_KHR" );
	swigIntConstant( VK_DEPENDENCY_DEVICE_GROUP_BIT_KHR, "VK_DEPENDENCY_DEVICE_GROUP_BIT_KHR" );
	swigIntConstant( VK_DEPENDENCY_FLAG_BITS_MAX_ENUM, "VK_DEPENDENCY_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, "VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT" );
	swigIntConstant( VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT_KHR, "VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT_KHR" );
	swigIntConstant( VK_FRAMEBUFFER_CREATE_FLAG_BITS_MAX_ENUM, "VK_FRAMEBUFFER_CREATE_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_RENDER_PASS_CREATE_TRANSFORM_BIT_QCOM, "VK_RENDER_PASS_CREATE_TRANSFORM_BIT_QCOM" );
	swigIntConstant( VK_RENDER_PASS_CREATE_FLAG_BITS_MAX_ENUM, "VK_RENDER_PASS_CREATE_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_SUBPASS_DESCRIPTION_PER_VIEW_ATTRIBUTES_BIT_NVX, "VK_SUBPASS_DESCRIPTION_PER_VIEW_ATTRIBUTES_BIT_NVX" );
	swigIntConstant( VK_SUBPASS_DESCRIPTION_PER_VIEW_POSITION_X_ONLY_BIT_NVX, "VK_SUBPASS_DESCRIPTION_PER_VIEW_POSITION_X_ONLY_BIT_NVX" );
	swigIntConstant( VK_SUBPASS_DESCRIPTION_FRAGMENT_REGION_BIT_QCOM, "VK_SUBPASS_DESCRIPTION_FRAGMENT_REGION_BIT_QCOM" );
	swigIntConstant( VK_SUBPASS_DESCRIPTION_SHADER_RESOLVE_BIT_QCOM, "VK_SUBPASS_DESCRIPTION_SHADER_RESOLVE_BIT_QCOM" );
	swigIntConstant( VK_SUBPASS_DESCRIPTION_FLAG_BITS_MAX_ENUM, "VK_SUBPASS_DESCRIPTION_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_COMMAND_POOL_CREATE_TRANSIENT_BIT, "VK_COMMAND_POOL_CREATE_TRANSIENT_BIT" );
	swigIntConstant( VK_COMMAND_POOL_CREATE_RESET_COMMAND_BUFFER_BIT, "VK_COMMAND_POOL_CREATE_RESET_COMMAND_BUFFER_BIT" );
	swigIntConstant( VK_COMMAND_POOL_CREATE_PROTECTED_BIT, "VK_COMMAND_POOL_CREATE_PROTECTED_BIT" );
	swigIntConstant( VK_COMMAND_POOL_CREATE_FLAG_BITS_MAX_ENUM, "VK_COMMAND_POOL_CREATE_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_COMMAND_POOL_RESET_RELEASE_RESOURCES_BIT, "VK_COMMAND_POOL_RESET_RELEASE_RESOURCES_BIT" );
	swigIntConstant( VK_COMMAND_POOL_RESET_FLAG_BITS_MAX_ENUM, "VK_COMMAND_POOL_RESET_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_COMMAND_BUFFER_USAGE_ONE_TIME_SUBMIT_BIT, "VK_COMMAND_BUFFER_USAGE_ONE_TIME_SUBMIT_BIT" );
	swigIntConstant( VK_COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT, "VK_COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT" );
	swigIntConstant( VK_COMMAND_BUFFER_USAGE_SIMULTANEOUS_USE_BIT, "VK_COMMAND_BUFFER_USAGE_SIMULTANEOUS_USE_BIT" );
	swigIntConstant( VK_COMMAND_BUFFER_USAGE_FLAG_BITS_MAX_ENUM, "VK_COMMAND_BUFFER_USAGE_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_QUERY_CONTROL_PRECISE_BIT, "VK_QUERY_CONTROL_PRECISE_BIT" );
	swigIntConstant( VK_QUERY_CONTROL_FLAG_BITS_MAX_ENUM, "VK_QUERY_CONTROL_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_COMMAND_BUFFER_RESET_RELEASE_RESOURCES_BIT, "VK_COMMAND_BUFFER_RESET_RELEASE_RESOURCES_BIT" );
	swigIntConstant( VK_COMMAND_BUFFER_RESET_FLAG_BITS_MAX_ENUM, "VK_COMMAND_BUFFER_RESET_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_STENCIL_FACE_FRONT_BIT, "VK_STENCIL_FACE_FRONT_BIT" );
	swigIntConstant( VK_STENCIL_FACE_BACK_BIT, "VK_STENCIL_FACE_BACK_BIT" );
	swigIntConstant( VK_STENCIL_FACE_FRONT_AND_BACK, "VK_STENCIL_FACE_FRONT_AND_BACK" );
	swigIntConstant( VK_STENCIL_FRONT_AND_BACK, "VK_STENCIL_FRONT_AND_BACK" );
	swigIntConstant( VK_STENCIL_FACE_FLAG_BITS_MAX_ENUM, "VK_STENCIL_FACE_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_POINT_CLIPPING_BEHAVIOR_ALL_CLIP_PLANES, "VK_POINT_CLIPPING_BEHAVIOR_ALL_CLIP_PLANES" );
	swigIntConstant( VK_POINT_CLIPPING_BEHAVIOR_USER_CLIP_PLANES_ONLY, "VK_POINT_CLIPPING_BEHAVIOR_USER_CLIP_PLANES_ONLY" );
	swigIntConstant( VK_POINT_CLIPPING_BEHAVIOR_ALL_CLIP_PLANES_KHR, "VK_POINT_CLIPPING_BEHAVIOR_ALL_CLIP_PLANES_KHR" );
	swigIntConstant( VK_POINT_CLIPPING_BEHAVIOR_USER_CLIP_PLANES_ONLY_KHR, "VK_POINT_CLIPPING_BEHAVIOR_USER_CLIP_PLANES_ONLY_KHR" );
	swigIntConstant( VK_POINT_CLIPPING_BEHAVIOR_MAX_ENUM, "VK_POINT_CLIPPING_BEHAVIOR_MAX_ENUM" );
	swigIntConstant( VK_TESSELLATION_DOMAIN_ORIGIN_UPPER_LEFT, "VK_TESSELLATION_DOMAIN_ORIGIN_UPPER_LEFT" );
	swigIntConstant( VK_TESSELLATION_DOMAIN_ORIGIN_LOWER_LEFT, "VK_TESSELLATION_DOMAIN_ORIGIN_LOWER_LEFT" );
	swigIntConstant( VK_TESSELLATION_DOMAIN_ORIGIN_UPPER_LEFT_KHR, "VK_TESSELLATION_DOMAIN_ORIGIN_UPPER_LEFT_KHR" );
	swigIntConstant( VK_TESSELLATION_DOMAIN_ORIGIN_LOWER_LEFT_KHR, "VK_TESSELLATION_DOMAIN_ORIGIN_LOWER_LEFT_KHR" );
	swigIntConstant( VK_TESSELLATION_DOMAIN_ORIGIN_MAX_ENUM, "VK_TESSELLATION_DOMAIN_ORIGIN_MAX_ENUM" );
	swigIntConstant( VK_SAMPLER_YCBCR_MODEL_CONVERSION_RGB_IDENTITY, "VK_SAMPLER_YCBCR_MODEL_CONVERSION_RGB_IDENTITY" );
	swigIntConstant( VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_IDENTITY, "VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_IDENTITY" );
	swigIntConstant( VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_709, "VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_709" );
	swigIntConstant( VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_601, "VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_601" );
	swigIntConstant( VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_2020, "VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_2020" );
	swigIntConstant( VK_SAMPLER_YCBCR_MODEL_CONVERSION_RGB_IDENTITY_KHR, "VK_SAMPLER_YCBCR_MODEL_CONVERSION_RGB_IDENTITY_KHR" );
	swigIntConstant( VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_IDENTITY_KHR, "VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_IDENTITY_KHR" );
	swigIntConstant( VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_709_KHR, "VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_709_KHR" );
	swigIntConstant( VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_601_KHR, "VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_601_KHR" );
	swigIntConstant( VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_2020_KHR, "VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_2020_KHR" );
	swigIntConstant( VK_SAMPLER_YCBCR_MODEL_CONVERSION_MAX_ENUM, "VK_SAMPLER_YCBCR_MODEL_CONVERSION_MAX_ENUM" );
	swigIntConstant( VK_SAMPLER_YCBCR_RANGE_ITU_FULL, "VK_SAMPLER_YCBCR_RANGE_ITU_FULL" );
	swigIntConstant( VK_SAMPLER_YCBCR_RANGE_ITU_NARROW, "VK_SAMPLER_YCBCR_RANGE_ITU_NARROW" );
	swigIntConstant( VK_SAMPLER_YCBCR_RANGE_ITU_FULL_KHR, "VK_SAMPLER_YCBCR_RANGE_ITU_FULL_KHR" );
	swigIntConstant( VK_SAMPLER_YCBCR_RANGE_ITU_NARROW_KHR, "VK_SAMPLER_YCBCR_RANGE_ITU_NARROW_KHR" );
	swigIntConstant( VK_SAMPLER_YCBCR_RANGE_MAX_ENUM, "VK_SAMPLER_YCBCR_RANGE_MAX_ENUM" );
	swigIntConstant( VK_CHROMA_LOCATION_COSITED_EVEN, "VK_CHROMA_LOCATION_COSITED_EVEN" );
	swigIntConstant( VK_CHROMA_LOCATION_MIDPOINT, "VK_CHROMA_LOCATION_MIDPOINT" );
	swigIntConstant( VK_CHROMA_LOCATION_COSITED_EVEN_KHR, "VK_CHROMA_LOCATION_COSITED_EVEN_KHR" );
	swigIntConstant( VK_CHROMA_LOCATION_MIDPOINT_KHR, "VK_CHROMA_LOCATION_MIDPOINT_KHR" );
	swigIntConstant( VK_CHROMA_LOCATION_MAX_ENUM, "VK_CHROMA_LOCATION_MAX_ENUM" );
	swigIntConstant( VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_DESCRIPTOR_SET, "VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_DESCRIPTOR_SET" );
	swigIntConstant( VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_PUSH_DESCRIPTORS_KHR, "VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_PUSH_DESCRIPTORS_KHR" );
	swigIntConstant( VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_DESCRIPTOR_SET_KHR, "VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_DESCRIPTOR_SET_KHR" );
	swigIntConstant( VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_MAX_ENUM, "VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_MAX_ENUM" );
	swigIntConstant( VK_SUBGROUP_FEATURE_BASIC_BIT, "VK_SUBGROUP_FEATURE_BASIC_BIT" );
	swigIntConstant( VK_SUBGROUP_FEATURE_VOTE_BIT, "VK_SUBGROUP_FEATURE_VOTE_BIT" );
	swigIntConstant( VK_SUBGROUP_FEATURE_ARITHMETIC_BIT, "VK_SUBGROUP_FEATURE_ARITHMETIC_BIT" );
	swigIntConstant( VK_SUBGROUP_FEATURE_BALLOT_BIT, "VK_SUBGROUP_FEATURE_BALLOT_BIT" );
	swigIntConstant( VK_SUBGROUP_FEATURE_SHUFFLE_BIT, "VK_SUBGROUP_FEATURE_SHUFFLE_BIT" );
	swigIntConstant( VK_SUBGROUP_FEATURE_SHUFFLE_RELATIVE_BIT, "VK_SUBGROUP_FEATURE_SHUFFLE_RELATIVE_BIT" );
	swigIntConstant( VK_SUBGROUP_FEATURE_CLUSTERED_BIT, "VK_SUBGROUP_FEATURE_CLUSTERED_BIT" );
	swigIntConstant( VK_SUBGROUP_FEATURE_QUAD_BIT, "VK_SUBGROUP_FEATURE_QUAD_BIT" );
	swigIntConstant( VK_SUBGROUP_FEATURE_PARTITIONED_BIT_NV, "VK_SUBGROUP_FEATURE_PARTITIONED_BIT_NV" );
	swigIntConstant( VK_SUBGROUP_FEATURE_FLAG_BITS_MAX_ENUM, "VK_SUBGROUP_FEATURE_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_PEER_MEMORY_FEATURE_COPY_SRC_BIT, "VK_PEER_MEMORY_FEATURE_COPY_SRC_BIT" );
	swigIntConstant( VK_PEER_MEMORY_FEATURE_COPY_DST_BIT, "VK_PEER_MEMORY_FEATURE_COPY_DST_BIT" );
	swigIntConstant( VK_PEER_MEMORY_FEATURE_GENERIC_SRC_BIT, "VK_PEER_MEMORY_FEATURE_GENERIC_SRC_BIT" );
	swigIntConstant( VK_PEER_MEMORY_FEATURE_GENERIC_DST_BIT, "VK_PEER_MEMORY_FEATURE_GENERIC_DST_BIT" );
	swigIntConstant( VK_PEER_MEMORY_FEATURE_COPY_SRC_BIT_KHR, "VK_PEER_MEMORY_FEATURE_COPY_SRC_BIT_KHR" );
	swigIntConstant( VK_PEER_MEMORY_FEATURE_COPY_DST_BIT_KHR, "VK_PEER_MEMORY_FEATURE_COPY_DST_BIT_KHR" );
	swigIntConstant( VK_PEER_MEMORY_FEATURE_GENERIC_SRC_BIT_KHR, "VK_PEER_MEMORY_FEATURE_GENERIC_SRC_BIT_KHR" );
	swigIntConstant( VK_PEER_MEMORY_FEATURE_GENERIC_DST_BIT_KHR, "VK_PEER_MEMORY_FEATURE_GENERIC_DST_BIT_KHR" );
	swigIntConstant( VK_PEER_MEMORY_FEATURE_FLAG_BITS_MAX_ENUM, "VK_PEER_MEMORY_FEATURE_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_MEMORY_ALLOCATE_DEVICE_MASK_BIT, "VK_MEMORY_ALLOCATE_DEVICE_MASK_BIT" );
	swigIntConstant( VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_BIT, "VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_BIT" );
	swigIntConstant( VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT, "VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT" );
	swigIntConstant( VK_MEMORY_ALLOCATE_DEVICE_MASK_BIT_KHR, "VK_MEMORY_ALLOCATE_DEVICE_MASK_BIT_KHR" );
	swigIntConstant( VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_BIT_KHR, "VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_BIT_KHR" );
	swigIntConstant( VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT_KHR, "VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT_KHR" );
	swigIntConstant( VK_MEMORY_ALLOCATE_FLAG_BITS_MAX_ENUM, "VK_MEMORY_ALLOCATE_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_FD_BIT, "VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_FD_BIT" );
	swigIntConstant( VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_BIT, "VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_BIT" );
	swigIntConstant( VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT, "VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT" );
	swigIntConstant( VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_BIT, "VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_BIT" );
	swigIntConstant( VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_KMT_BIT, "VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_KMT_BIT" );
	swigIntConstant( VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_HEAP_BIT, "VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_HEAP_BIT" );
	swigIntConstant( VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_RESOURCE_BIT, "VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_RESOURCE_BIT" );
	swigIntConstant( VK_EXTERNAL_MEMORY_HANDLE_TYPE_DMA_BUF_BIT_EXT, "VK_EXTERNAL_MEMORY_HANDLE_TYPE_DMA_BUF_BIT_EXT" );
	swigIntConstant( VK_EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID, "VK_EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID" );
	swigIntConstant( VK_EXTERNAL_MEMORY_HANDLE_TYPE_HOST_ALLOCATION_BIT_EXT, "VK_EXTERNAL_MEMORY_HANDLE_TYPE_HOST_ALLOCATION_BIT_EXT" );
	swigIntConstant( VK_EXTERNAL_MEMORY_HANDLE_TYPE_HOST_MAPPED_FOREIGN_MEMORY_BIT_EXT, "VK_EXTERNAL_MEMORY_HANDLE_TYPE_HOST_MAPPED_FOREIGN_MEMORY_BIT_EXT" );
	swigIntConstant( VK_EXTERNAL_MEMORY_HANDLE_TYPE_ZIRCON_VMO_BIT_FUCHSIA, "VK_EXTERNAL_MEMORY_HANDLE_TYPE_ZIRCON_VMO_BIT_FUCHSIA" );
	swigIntConstant( VK_EXTERNAL_MEMORY_HANDLE_TYPE_RDMA_ADDRESS_BIT_NV, "VK_EXTERNAL_MEMORY_HANDLE_TYPE_RDMA_ADDRESS_BIT_NV" );
	swigIntConstant( VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_FD_BIT_KHR, "VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_FD_BIT_KHR" );
	swigIntConstant( VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_BIT_KHR, "VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_BIT_KHR" );
	swigIntConstant( VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT_KHR, "VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT_KHR" );
	swigIntConstant( VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_BIT_KHR, "VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_BIT_KHR" );
	swigIntConstant( VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_KMT_BIT_KHR, "VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_KMT_BIT_KHR" );
	swigIntConstant( VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_HEAP_BIT_KHR, "VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_HEAP_BIT_KHR" );
	swigIntConstant( VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_RESOURCE_BIT_KHR, "VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_RESOURCE_BIT_KHR" );
	swigIntConstant( VK_EXTERNAL_MEMORY_HANDLE_TYPE_FLAG_BITS_MAX_ENUM, "VK_EXTERNAL_MEMORY_HANDLE_TYPE_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_EXTERNAL_MEMORY_FEATURE_DEDICATED_ONLY_BIT, "VK_EXTERNAL_MEMORY_FEATURE_DEDICATED_ONLY_BIT" );
	swigIntConstant( VK_EXTERNAL_MEMORY_FEATURE_EXPORTABLE_BIT, "VK_EXTERNAL_MEMORY_FEATURE_EXPORTABLE_BIT" );
	swigIntConstant( VK_EXTERNAL_MEMORY_FEATURE_IMPORTABLE_BIT, "VK_EXTERNAL_MEMORY_FEATURE_IMPORTABLE_BIT" );
	swigIntConstant( VK_EXTERNAL_MEMORY_FEATURE_DEDICATED_ONLY_BIT_KHR, "VK_EXTERNAL_MEMORY_FEATURE_DEDICATED_ONLY_BIT_KHR" );
	swigIntConstant( VK_EXTERNAL_MEMORY_FEATURE_EXPORTABLE_BIT_KHR, "VK_EXTERNAL_MEMORY_FEATURE_EXPORTABLE_BIT_KHR" );
	swigIntConstant( VK_EXTERNAL_MEMORY_FEATURE_IMPORTABLE_BIT_KHR, "VK_EXTERNAL_MEMORY_FEATURE_IMPORTABLE_BIT_KHR" );
	swigIntConstant( VK_EXTERNAL_MEMORY_FEATURE_FLAG_BITS_MAX_ENUM, "VK_EXTERNAL_MEMORY_FEATURE_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_FD_BIT, "VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_FD_BIT" );
	swigIntConstant( VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_WIN32_BIT, "VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_WIN32_BIT" );
	swigIntConstant( VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT, "VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT" );
	swigIntConstant( VK_EXTERNAL_FENCE_HANDLE_TYPE_SYNC_FD_BIT, "VK_EXTERNAL_FENCE_HANDLE_TYPE_SYNC_FD_BIT" );
	swigIntConstant( VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_FD_BIT_KHR, "VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_FD_BIT_KHR" );
	swigIntConstant( VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_WIN32_BIT_KHR, "VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_WIN32_BIT_KHR" );
	swigIntConstant( VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT_KHR, "VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT_KHR" );
	swigIntConstant( VK_EXTERNAL_FENCE_HANDLE_TYPE_SYNC_FD_BIT_KHR, "VK_EXTERNAL_FENCE_HANDLE_TYPE_SYNC_FD_BIT_KHR" );
	swigIntConstant( VK_EXTERNAL_FENCE_HANDLE_TYPE_FLAG_BITS_MAX_ENUM, "VK_EXTERNAL_FENCE_HANDLE_TYPE_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_EXTERNAL_FENCE_FEATURE_EXPORTABLE_BIT, "VK_EXTERNAL_FENCE_FEATURE_EXPORTABLE_BIT" );
	swigIntConstant( VK_EXTERNAL_FENCE_FEATURE_IMPORTABLE_BIT, "VK_EXTERNAL_FENCE_FEATURE_IMPORTABLE_BIT" );
	swigIntConstant( VK_EXTERNAL_FENCE_FEATURE_EXPORTABLE_BIT_KHR, "VK_EXTERNAL_FENCE_FEATURE_EXPORTABLE_BIT_KHR" );
	swigIntConstant( VK_EXTERNAL_FENCE_FEATURE_IMPORTABLE_BIT_KHR, "VK_EXTERNAL_FENCE_FEATURE_IMPORTABLE_BIT_KHR" );
	swigIntConstant( VK_EXTERNAL_FENCE_FEATURE_FLAG_BITS_MAX_ENUM, "VK_EXTERNAL_FENCE_FEATURE_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_FENCE_IMPORT_TEMPORARY_BIT, "VK_FENCE_IMPORT_TEMPORARY_BIT" );
	swigIntConstant( VK_FENCE_IMPORT_TEMPORARY_BIT_KHR, "VK_FENCE_IMPORT_TEMPORARY_BIT_KHR" );
	swigIntConstant( VK_FENCE_IMPORT_FLAG_BITS_MAX_ENUM, "VK_FENCE_IMPORT_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_SEMAPHORE_IMPORT_TEMPORARY_BIT, "VK_SEMAPHORE_IMPORT_TEMPORARY_BIT" );
	swigIntConstant( VK_SEMAPHORE_IMPORT_TEMPORARY_BIT_KHR, "VK_SEMAPHORE_IMPORT_TEMPORARY_BIT_KHR" );
	swigIntConstant( VK_SEMAPHORE_IMPORT_FLAG_BITS_MAX_ENUM, "VK_SEMAPHORE_IMPORT_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_FD_BIT, "VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_FD_BIT" );
	swigIntConstant( VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_BIT, "VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_BIT" );
	swigIntConstant( VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT, "VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT" );
	swigIntConstant( VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D12_FENCE_BIT, "VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D12_FENCE_BIT" );
	swigIntConstant( VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_SYNC_FD_BIT, "VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_SYNC_FD_BIT" );
	swigIntConstant( VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_ZIRCON_EVENT_BIT_FUCHSIA, "VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_ZIRCON_EVENT_BIT_FUCHSIA" );
	swigIntConstant( VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D11_FENCE_BIT, "VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D11_FENCE_BIT" );
	swigIntConstant( VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_FD_BIT_KHR, "VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_FD_BIT_KHR" );
	swigIntConstant( VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_BIT_KHR, "VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_BIT_KHR" );
	swigIntConstant( VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT_KHR, "VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT_KHR" );
	swigIntConstant( VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D12_FENCE_BIT_KHR, "VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D12_FENCE_BIT_KHR" );
	swigIntConstant( VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_SYNC_FD_BIT_KHR, "VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_SYNC_FD_BIT_KHR" );
	swigIntConstant( VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_FLAG_BITS_MAX_ENUM, "VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_EXTERNAL_SEMAPHORE_FEATURE_EXPORTABLE_BIT, "VK_EXTERNAL_SEMAPHORE_FEATURE_EXPORTABLE_BIT" );
	swigIntConstant( VK_EXTERNAL_SEMAPHORE_FEATURE_IMPORTABLE_BIT, "VK_EXTERNAL_SEMAPHORE_FEATURE_IMPORTABLE_BIT" );
	swigIntConstant( VK_EXTERNAL_SEMAPHORE_FEATURE_EXPORTABLE_BIT_KHR, "VK_EXTERNAL_SEMAPHORE_FEATURE_EXPORTABLE_BIT_KHR" );
	swigIntConstant( VK_EXTERNAL_SEMAPHORE_FEATURE_IMPORTABLE_BIT_KHR, "VK_EXTERNAL_SEMAPHORE_FEATURE_IMPORTABLE_BIT_KHR" );
	swigIntConstant( VK_EXTERNAL_SEMAPHORE_FEATURE_FLAG_BITS_MAX_ENUM, "VK_EXTERNAL_SEMAPHORE_FEATURE_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_DRIVER_ID_AMD_PROPRIETARY, "VK_DRIVER_ID_AMD_PROPRIETARY" );
	swigIntConstant( VK_DRIVER_ID_AMD_OPEN_SOURCE, "VK_DRIVER_ID_AMD_OPEN_SOURCE" );
	swigIntConstant( VK_DRIVER_ID_MESA_RADV, "VK_DRIVER_ID_MESA_RADV" );
	swigIntConstant( VK_DRIVER_ID_NVIDIA_PROPRIETARY, "VK_DRIVER_ID_NVIDIA_PROPRIETARY" );
	swigIntConstant( VK_DRIVER_ID_INTEL_PROPRIETARY_WINDOWS, "VK_DRIVER_ID_INTEL_PROPRIETARY_WINDOWS" );
	swigIntConstant( VK_DRIVER_ID_INTEL_OPEN_SOURCE_MESA, "VK_DRIVER_ID_INTEL_OPEN_SOURCE_MESA" );
	swigIntConstant( VK_DRIVER_ID_IMAGINATION_PROPRIETARY, "VK_DRIVER_ID_IMAGINATION_PROPRIETARY" );
	swigIntConstant( VK_DRIVER_ID_QUALCOMM_PROPRIETARY, "VK_DRIVER_ID_QUALCOMM_PROPRIETARY" );
	swigIntConstant( VK_DRIVER_ID_ARM_PROPRIETARY, "VK_DRIVER_ID_ARM_PROPRIETARY" );
	swigIntConstant( VK_DRIVER_ID_GOOGLE_SWIFTSHADER, "VK_DRIVER_ID_GOOGLE_SWIFTSHADER" );
	swigIntConstant( VK_DRIVER_ID_GGP_PROPRIETARY, "VK_DRIVER_ID_GGP_PROPRIETARY" );
	swigIntConstant( VK_DRIVER_ID_BROADCOM_PROPRIETARY, "VK_DRIVER_ID_BROADCOM_PROPRIETARY" );
	swigIntConstant( VK_DRIVER_ID_MESA_LLVMPIPE, "VK_DRIVER_ID_MESA_LLVMPIPE" );
	swigIntConstant( VK_DRIVER_ID_MOLTENVK, "VK_DRIVER_ID_MOLTENVK" );
	swigIntConstant( VK_DRIVER_ID_COREAVI_PROPRIETARY, "VK_DRIVER_ID_COREAVI_PROPRIETARY" );
	swigIntConstant( VK_DRIVER_ID_JUICE_PROPRIETARY, "VK_DRIVER_ID_JUICE_PROPRIETARY" );
	swigIntConstant( VK_DRIVER_ID_VERISILICON_PROPRIETARY, "VK_DRIVER_ID_VERISILICON_PROPRIETARY" );
	swigIntConstant( VK_DRIVER_ID_MESA_TURNIP, "VK_DRIVER_ID_MESA_TURNIP" );
	swigIntConstant( VK_DRIVER_ID_MESA_V3DV, "VK_DRIVER_ID_MESA_V3DV" );
	swigIntConstant( VK_DRIVER_ID_MESA_PANVK, "VK_DRIVER_ID_MESA_PANVK" );
	swigIntConstant( VK_DRIVER_ID_AMD_PROPRIETARY_KHR, "VK_DRIVER_ID_AMD_PROPRIETARY_KHR" );
	swigIntConstant( VK_DRIVER_ID_AMD_OPEN_SOURCE_KHR, "VK_DRIVER_ID_AMD_OPEN_SOURCE_KHR" );
	swigIntConstant( VK_DRIVER_ID_MESA_RADV_KHR, "VK_DRIVER_ID_MESA_RADV_KHR" );
	swigIntConstant( VK_DRIVER_ID_NVIDIA_PROPRIETARY_KHR, "VK_DRIVER_ID_NVIDIA_PROPRIETARY_KHR" );
	swigIntConstant( VK_DRIVER_ID_INTEL_PROPRIETARY_WINDOWS_KHR, "VK_DRIVER_ID_INTEL_PROPRIETARY_WINDOWS_KHR" );
	swigIntConstant( VK_DRIVER_ID_INTEL_OPEN_SOURCE_MESA_KHR, "VK_DRIVER_ID_INTEL_OPEN_SOURCE_MESA_KHR" );
	swigIntConstant( VK_DRIVER_ID_IMAGINATION_PROPRIETARY_KHR, "VK_DRIVER_ID_IMAGINATION_PROPRIETARY_KHR" );
	swigIntConstant( VK_DRIVER_ID_QUALCOMM_PROPRIETARY_KHR, "VK_DRIVER_ID_QUALCOMM_PROPRIETARY_KHR" );
	swigIntConstant( VK_DRIVER_ID_ARM_PROPRIETARY_KHR, "VK_DRIVER_ID_ARM_PROPRIETARY_KHR" );
	swigIntConstant( VK_DRIVER_ID_GOOGLE_SWIFTSHADER_KHR, "VK_DRIVER_ID_GOOGLE_SWIFTSHADER_KHR" );
	swigIntConstant( VK_DRIVER_ID_GGP_PROPRIETARY_KHR, "VK_DRIVER_ID_GGP_PROPRIETARY_KHR" );
	swigIntConstant( VK_DRIVER_ID_BROADCOM_PROPRIETARY_KHR, "VK_DRIVER_ID_BROADCOM_PROPRIETARY_KHR" );
	swigIntConstant( VK_DRIVER_ID_MAX_ENUM, "VK_DRIVER_ID_MAX_ENUM" );
	swigIntConstant( VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_32_BIT_ONLY, "VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_32_BIT_ONLY" );
	swigIntConstant( VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_ALL, "VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_ALL" );
	swigIntConstant( VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_NONE, "VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_NONE" );
	swigIntConstant( VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_32_BIT_ONLY_KHR, "VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_32_BIT_ONLY_KHR" );
	swigIntConstant( VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_ALL_KHR, "VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_ALL_KHR" );
	swigIntConstant( VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_NONE_KHR, "VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_NONE_KHR" );
	swigIntConstant( VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_MAX_ENUM, "VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_MAX_ENUM" );
	swigIntConstant( VK_SAMPLER_REDUCTION_MODE_WEIGHTED_AVERAGE, "VK_SAMPLER_REDUCTION_MODE_WEIGHTED_AVERAGE" );
	swigIntConstant( VK_SAMPLER_REDUCTION_MODE_MIN, "VK_SAMPLER_REDUCTION_MODE_MIN" );
	swigIntConstant( VK_SAMPLER_REDUCTION_MODE_MAX, "VK_SAMPLER_REDUCTION_MODE_MAX" );
	swigIntConstant( VK_SAMPLER_REDUCTION_MODE_WEIGHTED_AVERAGE_EXT, "VK_SAMPLER_REDUCTION_MODE_WEIGHTED_AVERAGE_EXT" );
	swigIntConstant( VK_SAMPLER_REDUCTION_MODE_MIN_EXT, "VK_SAMPLER_REDUCTION_MODE_MIN_EXT" );
	swigIntConstant( VK_SAMPLER_REDUCTION_MODE_MAX_EXT, "VK_SAMPLER_REDUCTION_MODE_MAX_EXT" );
	swigIntConstant( VK_SAMPLER_REDUCTION_MODE_MAX_ENUM, "VK_SAMPLER_REDUCTION_MODE_MAX_ENUM" );
	swigIntConstant( VK_SEMAPHORE_TYPE_BINARY, "VK_SEMAPHORE_TYPE_BINARY" );
	swigIntConstant( VK_SEMAPHORE_TYPE_TIMELINE, "VK_SEMAPHORE_TYPE_TIMELINE" );
	swigIntConstant( VK_SEMAPHORE_TYPE_BINARY_KHR, "VK_SEMAPHORE_TYPE_BINARY_KHR" );
	swigIntConstant( VK_SEMAPHORE_TYPE_TIMELINE_KHR, "VK_SEMAPHORE_TYPE_TIMELINE_KHR" );
	swigIntConstant( VK_SEMAPHORE_TYPE_MAX_ENUM, "VK_SEMAPHORE_TYPE_MAX_ENUM" );
	swigIntConstant( VK_RESOLVE_MODE_NONE, "VK_RESOLVE_MODE_NONE" );
	swigIntConstant( VK_RESOLVE_MODE_SAMPLE_ZERO_BIT, "VK_RESOLVE_MODE_SAMPLE_ZERO_BIT" );
	swigIntConstant( VK_RESOLVE_MODE_AVERAGE_BIT, "VK_RESOLVE_MODE_AVERAGE_BIT" );
	swigIntConstant( VK_RESOLVE_MODE_MIN_BIT, "VK_RESOLVE_MODE_MIN_BIT" );
	swigIntConstant( VK_RESOLVE_MODE_MAX_BIT, "VK_RESOLVE_MODE_MAX_BIT" );
	swigIntConstant( VK_RESOLVE_MODE_NONE_KHR, "VK_RESOLVE_MODE_NONE_KHR" );
	swigIntConstant( VK_RESOLVE_MODE_SAMPLE_ZERO_BIT_KHR, "VK_RESOLVE_MODE_SAMPLE_ZERO_BIT_KHR" );
	swigIntConstant( VK_RESOLVE_MODE_AVERAGE_BIT_KHR, "VK_RESOLVE_MODE_AVERAGE_BIT_KHR" );
	swigIntConstant( VK_RESOLVE_MODE_MIN_BIT_KHR, "VK_RESOLVE_MODE_MIN_BIT_KHR" );
	swigIntConstant( VK_RESOLVE_MODE_MAX_BIT_KHR, "VK_RESOLVE_MODE_MAX_BIT_KHR" );
	swigIntConstant( VK_RESOLVE_MODE_FLAG_BITS_MAX_ENUM, "VK_RESOLVE_MODE_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT, "VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT" );
	swigIntConstant( VK_DESCRIPTOR_BINDING_UPDATE_UNUSED_WHILE_PENDING_BIT, "VK_DESCRIPTOR_BINDING_UPDATE_UNUSED_WHILE_PENDING_BIT" );
	swigIntConstant( VK_DESCRIPTOR_BINDING_PARTIALLY_BOUND_BIT, "VK_DESCRIPTOR_BINDING_PARTIALLY_BOUND_BIT" );
	swigIntConstant( VK_DESCRIPTOR_BINDING_VARIABLE_DESCRIPTOR_COUNT_BIT, "VK_DESCRIPTOR_BINDING_VARIABLE_DESCRIPTOR_COUNT_BIT" );
	swigIntConstant( VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT_EXT, "VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT_EXT" );
	swigIntConstant( VK_DESCRIPTOR_BINDING_UPDATE_UNUSED_WHILE_PENDING_BIT_EXT, "VK_DESCRIPTOR_BINDING_UPDATE_UNUSED_WHILE_PENDING_BIT_EXT" );
	swigIntConstant( VK_DESCRIPTOR_BINDING_PARTIALLY_BOUND_BIT_EXT, "VK_DESCRIPTOR_BINDING_PARTIALLY_BOUND_BIT_EXT" );
	swigIntConstant( VK_DESCRIPTOR_BINDING_VARIABLE_DESCRIPTOR_COUNT_BIT_EXT, "VK_DESCRIPTOR_BINDING_VARIABLE_DESCRIPTOR_COUNT_BIT_EXT" );
	swigIntConstant( VK_DESCRIPTOR_BINDING_FLAG_BITS_MAX_ENUM, "VK_DESCRIPTOR_BINDING_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_SEMAPHORE_WAIT_ANY_BIT, "VK_SEMAPHORE_WAIT_ANY_BIT" );
	swigIntConstant( VK_SEMAPHORE_WAIT_ANY_BIT_KHR, "VK_SEMAPHORE_WAIT_ANY_BIT_KHR" );
	swigIntConstant( VK_SEMAPHORE_WAIT_FLAG_BITS_MAX_ENUM, "VK_SEMAPHORE_WAIT_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_PRESENT_MODE_IMMEDIATE_KHR, "VK_PRESENT_MODE_IMMEDIATE_KHR" );
	swigIntConstant( VK_PRESENT_MODE_MAILBOX_KHR, "VK_PRESENT_MODE_MAILBOX_KHR" );
	swigIntConstant( VK_PRESENT_MODE_FIFO_KHR, "VK_PRESENT_MODE_FIFO_KHR" );
	swigIntConstant( VK_PRESENT_MODE_FIFO_RELAXED_KHR, "VK_PRESENT_MODE_FIFO_RELAXED_KHR" );
	swigIntConstant( VK_PRESENT_MODE_SHARED_DEMAND_REFRESH_KHR, "VK_PRESENT_MODE_SHARED_DEMAND_REFRESH_KHR" );
	swigIntConstant( VK_PRESENT_MODE_SHARED_CONTINUOUS_REFRESH_KHR, "VK_PRESENT_MODE_SHARED_CONTINUOUS_REFRESH_KHR" );
	swigIntConstant( VK_PRESENT_MODE_MAX_ENUM_KHR, "VK_PRESENT_MODE_MAX_ENUM_KHR" );
	swigIntConstant( VK_COLOR_SPACE_SRGB_NONLINEAR_KHR, "VK_COLOR_SPACE_SRGB_NONLINEAR_KHR" );
	swigIntConstant( VK_COLOR_SPACE_DISPLAY_P3_NONLINEAR_EXT, "VK_COLOR_SPACE_DISPLAY_P3_NONLINEAR_EXT" );
	swigIntConstant( VK_COLOR_SPACE_EXTENDED_SRGB_LINEAR_EXT, "VK_COLOR_SPACE_EXTENDED_SRGB_LINEAR_EXT" );
	swigIntConstant( VK_COLOR_SPACE_DISPLAY_P3_LINEAR_EXT, "VK_COLOR_SPACE_DISPLAY_P3_LINEAR_EXT" );
	swigIntConstant( VK_COLOR_SPACE_DCI_P3_NONLINEAR_EXT, "VK_COLOR_SPACE_DCI_P3_NONLINEAR_EXT" );
	swigIntConstant( VK_COLOR_SPACE_BT709_LINEAR_EXT, "VK_COLOR_SPACE_BT709_LINEAR_EXT" );
	swigIntConstant( VK_COLOR_SPACE_BT709_NONLINEAR_EXT, "VK_COLOR_SPACE_BT709_NONLINEAR_EXT" );
	swigIntConstant( VK_COLOR_SPACE_BT2020_LINEAR_EXT, "VK_COLOR_SPACE_BT2020_LINEAR_EXT" );
	swigIntConstant( VK_COLOR_SPACE_HDR10_ST2084_EXT, "VK_COLOR_SPACE_HDR10_ST2084_EXT" );
	swigIntConstant( VK_COLOR_SPACE_DOLBYVISION_EXT, "VK_COLOR_SPACE_DOLBYVISION_EXT" );
	swigIntConstant( VK_COLOR_SPACE_HDR10_HLG_EXT, "VK_COLOR_SPACE_HDR10_HLG_EXT" );
	swigIntConstant( VK_COLOR_SPACE_ADOBERGB_LINEAR_EXT, "VK_COLOR_SPACE_ADOBERGB_LINEAR_EXT" );
	swigIntConstant( VK_COLOR_SPACE_ADOBERGB_NONLINEAR_EXT, "VK_COLOR_SPACE_ADOBERGB_NONLINEAR_EXT" );
	swigIntConstant( VK_COLOR_SPACE_PASS_THROUGH_EXT, "VK_COLOR_SPACE_PASS_THROUGH_EXT" );
	swigIntConstant( VK_COLOR_SPACE_EXTENDED_SRGB_NONLINEAR_EXT, "VK_COLOR_SPACE_EXTENDED_SRGB_NONLINEAR_EXT" );
	swigIntConstant( VK_COLOR_SPACE_DISPLAY_NATIVE_AMD, "VK_COLOR_SPACE_DISPLAY_NATIVE_AMD" );
	swigIntConstant( VK_COLORSPACE_SRGB_NONLINEAR_KHR, "VK_COLORSPACE_SRGB_NONLINEAR_KHR" );
	swigIntConstant( VK_COLOR_SPACE_DCI_P3_LINEAR_EXT, "VK_COLOR_SPACE_DCI_P3_LINEAR_EXT" );
	swigIntConstant( VK_COLOR_SPACE_MAX_ENUM_KHR, "VK_COLOR_SPACE_MAX_ENUM_KHR" );
	swigIntConstant( VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR, "VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR" );
	swigIntConstant( VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, "VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR" );
	swigIntConstant( VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, "VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR" );
	swigIntConstant( VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR, "VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR" );
	swigIntConstant( VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_BIT_KHR, "VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_BIT_KHR" );
	swigIntConstant( VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_90_BIT_KHR, "VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_90_BIT_KHR" );
	swigIntConstant( VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_180_BIT_KHR, "VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_180_BIT_KHR" );
	swigIntConstant( VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_270_BIT_KHR, "VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_270_BIT_KHR" );
	swigIntConstant( VK_SURFACE_TRANSFORM_INHERIT_BIT_KHR, "VK_SURFACE_TRANSFORM_INHERIT_BIT_KHR" );
	swigIntConstant( VK_SURFACE_TRANSFORM_FLAG_BITS_MAX_ENUM_KHR, "VK_SURFACE_TRANSFORM_FLAG_BITS_MAX_ENUM_KHR" );
	swigIntConstant( VK_COMPOSITE_ALPHA_OPAQUE_BIT_KHR, "VK_COMPOSITE_ALPHA_OPAQUE_BIT_KHR" );
	swigIntConstant( VK_COMPOSITE_ALPHA_PRE_MULTIPLIED_BIT_KHR, "VK_COMPOSITE_ALPHA_PRE_MULTIPLIED_BIT_KHR" );
	swigIntConstant( VK_COMPOSITE_ALPHA_POST_MULTIPLIED_BIT_KHR, "VK_COMPOSITE_ALPHA_POST_MULTIPLIED_BIT_KHR" );
	swigIntConstant( VK_COMPOSITE_ALPHA_INHERIT_BIT_KHR, "VK_COMPOSITE_ALPHA_INHERIT_BIT_KHR" );
	swigIntConstant( VK_COMPOSITE_ALPHA_FLAG_BITS_MAX_ENUM_KHR, "VK_COMPOSITE_ALPHA_FLAG_BITS_MAX_ENUM_KHR" );
	swigIntConstant( VK_SWAPCHAIN_CREATE_SPLIT_INSTANCE_BIND_REGIONS_BIT_KHR, "VK_SWAPCHAIN_CREATE_SPLIT_INSTANCE_BIND_REGIONS_BIT_KHR" );
	swigIntConstant( VK_SWAPCHAIN_CREATE_PROTECTED_BIT_KHR, "VK_SWAPCHAIN_CREATE_PROTECTED_BIT_KHR" );
	swigIntConstant( VK_SWAPCHAIN_CREATE_MUTABLE_FORMAT_BIT_KHR, "VK_SWAPCHAIN_CREATE_MUTABLE_FORMAT_BIT_KHR" );
	swigIntConstant( VK_SWAPCHAIN_CREATE_FLAG_BITS_MAX_ENUM_KHR, "VK_SWAPCHAIN_CREATE_FLAG_BITS_MAX_ENUM_KHR" );
	swigIntConstant( VK_DEVICE_GROUP_PRESENT_MODE_LOCAL_BIT_KHR, "VK_DEVICE_GROUP_PRESENT_MODE_LOCAL_BIT_KHR" );
	swigIntConstant( VK_DEVICE_GROUP_PRESENT_MODE_REMOTE_BIT_KHR, "VK_DEVICE_GROUP_PRESENT_MODE_REMOTE_BIT_KHR" );
	swigIntConstant( VK_DEVICE_GROUP_PRESENT_MODE_SUM_BIT_KHR, "VK_DEVICE_GROUP_PRESENT_MODE_SUM_BIT_KHR" );
	swigIntConstant( VK_DEVICE_GROUP_PRESENT_MODE_LOCAL_MULTI_DEVICE_BIT_KHR, "VK_DEVICE_GROUP_PRESENT_MODE_LOCAL_MULTI_DEVICE_BIT_KHR" );
	swigIntConstant( VK_DEVICE_GROUP_PRESENT_MODE_FLAG_BITS_MAX_ENUM_KHR, "VK_DEVICE_GROUP_PRESENT_MODE_FLAG_BITS_MAX_ENUM_KHR" );
	swigIntConstant( VK_DISPLAY_PLANE_ALPHA_OPAQUE_BIT_KHR, "VK_DISPLAY_PLANE_ALPHA_OPAQUE_BIT_KHR" );
	swigIntConstant( VK_DISPLAY_PLANE_ALPHA_GLOBAL_BIT_KHR, "VK_DISPLAY_PLANE_ALPHA_GLOBAL_BIT_KHR" );
	swigIntConstant( VK_DISPLAY_PLANE_ALPHA_PER_PIXEL_BIT_KHR, "VK_DISPLAY_PLANE_ALPHA_PER_PIXEL_BIT_KHR" );
	swigIntConstant( VK_DISPLAY_PLANE_ALPHA_PER_PIXEL_PREMULTIPLIED_BIT_KHR, "VK_DISPLAY_PLANE_ALPHA_PER_PIXEL_PREMULTIPLIED_BIT_KHR" );
	swigIntConstant( VK_DISPLAY_PLANE_ALPHA_FLAG_BITS_MAX_ENUM_KHR, "VK_DISPLAY_PLANE_ALPHA_FLAG_BITS_MAX_ENUM_KHR" );
	swigIntConstant( VK_RENDERING_CONTENTS_SECONDARY_COMMAND_BUFFERS_BIT_KHR, "VK_RENDERING_CONTENTS_SECONDARY_COMMAND_BUFFERS_BIT_KHR" );
	swigIntConstant( VK_RENDERING_SUSPENDING_BIT_KHR, "VK_RENDERING_SUSPENDING_BIT_KHR" );
	swigIntConstant( VK_RENDERING_RESUMING_BIT_KHR, "VK_RENDERING_RESUMING_BIT_KHR" );
	swigIntConstant( VK_RENDERING_FLAG_BITS_MAX_ENUM_KHR, "VK_RENDERING_FLAG_BITS_MAX_ENUM_KHR" );
	swigIntConstant( VK_PERFORMANCE_COUNTER_UNIT_GENERIC_KHR, "VK_PERFORMANCE_COUNTER_UNIT_GENERIC_KHR" );
	swigIntConstant( VK_PERFORMANCE_COUNTER_UNIT_PERCENTAGE_KHR, "VK_PERFORMANCE_COUNTER_UNIT_PERCENTAGE_KHR" );
	swigIntConstant( VK_PERFORMANCE_COUNTER_UNIT_NANOSECONDS_KHR, "VK_PERFORMANCE_COUNTER_UNIT_NANOSECONDS_KHR" );
	swigIntConstant( VK_PERFORMANCE_COUNTER_UNIT_BYTES_KHR, "VK_PERFORMANCE_COUNTER_UNIT_BYTES_KHR" );
	swigIntConstant( VK_PERFORMANCE_COUNTER_UNIT_BYTES_PER_SECOND_KHR, "VK_PERFORMANCE_COUNTER_UNIT_BYTES_PER_SECOND_KHR" );
	swigIntConstant( VK_PERFORMANCE_COUNTER_UNIT_KELVIN_KHR, "VK_PERFORMANCE_COUNTER_UNIT_KELVIN_KHR" );
	swigIntConstant( VK_PERFORMANCE_COUNTER_UNIT_WATTS_KHR, "VK_PERFORMANCE_COUNTER_UNIT_WATTS_KHR" );
	swigIntConstant( VK_PERFORMANCE_COUNTER_UNIT_VOLTS_KHR, "VK_PERFORMANCE_COUNTER_UNIT_VOLTS_KHR" );
	swigIntConstant( VK_PERFORMANCE_COUNTER_UNIT_AMPS_KHR, "VK_PERFORMANCE_COUNTER_UNIT_AMPS_KHR" );
	swigIntConstant( VK_PERFORMANCE_COUNTER_UNIT_HERTZ_KHR, "VK_PERFORMANCE_COUNTER_UNIT_HERTZ_KHR" );
	swigIntConstant( VK_PERFORMANCE_COUNTER_UNIT_CYCLES_KHR, "VK_PERFORMANCE_COUNTER_UNIT_CYCLES_KHR" );
	swigIntConstant( VK_PERFORMANCE_COUNTER_UNIT_MAX_ENUM_KHR, "VK_PERFORMANCE_COUNTER_UNIT_MAX_ENUM_KHR" );
	swigIntConstant( VK_PERFORMANCE_COUNTER_SCOPE_COMMAND_BUFFER_KHR, "VK_PERFORMANCE_COUNTER_SCOPE_COMMAND_BUFFER_KHR" );
	swigIntConstant( VK_PERFORMANCE_COUNTER_SCOPE_RENDER_PASS_KHR, "VK_PERFORMANCE_COUNTER_SCOPE_RENDER_PASS_KHR" );
	swigIntConstant( VK_PERFORMANCE_COUNTER_SCOPE_COMMAND_KHR, "VK_PERFORMANCE_COUNTER_SCOPE_COMMAND_KHR" );
	swigIntConstant( VK_QUERY_SCOPE_COMMAND_BUFFER_KHR, "VK_QUERY_SCOPE_COMMAND_BUFFER_KHR" );
	swigIntConstant( VK_QUERY_SCOPE_RENDER_PASS_KHR, "VK_QUERY_SCOPE_RENDER_PASS_KHR" );
	swigIntConstant( VK_QUERY_SCOPE_COMMAND_KHR, "VK_QUERY_SCOPE_COMMAND_KHR" );
	swigIntConstant( VK_PERFORMANCE_COUNTER_SCOPE_MAX_ENUM_KHR, "VK_PERFORMANCE_COUNTER_SCOPE_MAX_ENUM_KHR" );
	swigIntConstant( VK_PERFORMANCE_COUNTER_STORAGE_INT32_KHR, "VK_PERFORMANCE_COUNTER_STORAGE_INT32_KHR" );
	swigIntConstant( VK_PERFORMANCE_COUNTER_STORAGE_INT64_KHR, "VK_PERFORMANCE_COUNTER_STORAGE_INT64_KHR" );
	swigIntConstant( VK_PERFORMANCE_COUNTER_STORAGE_UINT32_KHR, "VK_PERFORMANCE_COUNTER_STORAGE_UINT32_KHR" );
	swigIntConstant( VK_PERFORMANCE_COUNTER_STORAGE_UINT64_KHR, "VK_PERFORMANCE_COUNTER_STORAGE_UINT64_KHR" );
	swigIntConstant( VK_PERFORMANCE_COUNTER_STORAGE_FLOAT32_KHR, "VK_PERFORMANCE_COUNTER_STORAGE_FLOAT32_KHR" );
	swigIntConstant( VK_PERFORMANCE_COUNTER_STORAGE_FLOAT64_KHR, "VK_PERFORMANCE_COUNTER_STORAGE_FLOAT64_KHR" );
	swigIntConstant( VK_PERFORMANCE_COUNTER_STORAGE_MAX_ENUM_KHR, "VK_PERFORMANCE_COUNTER_STORAGE_MAX_ENUM_KHR" );
	swigIntConstant( VK_PERFORMANCE_COUNTER_DESCRIPTION_PERFORMANCE_IMPACTING_BIT_KHR, "VK_PERFORMANCE_COUNTER_DESCRIPTION_PERFORMANCE_IMPACTING_BIT_KHR" );
	swigIntConstant( VK_PERFORMANCE_COUNTER_DESCRIPTION_CONCURRENTLY_IMPACTED_BIT_KHR, "VK_PERFORMANCE_COUNTER_DESCRIPTION_CONCURRENTLY_IMPACTED_BIT_KHR" );
	swigIntConstant( VK_PERFORMANCE_COUNTER_DESCRIPTION_PERFORMANCE_IMPACTING_KHR, "VK_PERFORMANCE_COUNTER_DESCRIPTION_PERFORMANCE_IMPACTING_KHR" );
	swigIntConstant( VK_PERFORMANCE_COUNTER_DESCRIPTION_CONCURRENTLY_IMPACTED_KHR, "VK_PERFORMANCE_COUNTER_DESCRIPTION_CONCURRENTLY_IMPACTED_KHR" );
	swigIntConstant( VK_PERFORMANCE_COUNTER_DESCRIPTION_FLAG_BITS_MAX_ENUM_KHR, "VK_PERFORMANCE_COUNTER_DESCRIPTION_FLAG_BITS_MAX_ENUM_KHR" );
	swigIntConstant( VK_ACQUIRE_PROFILING_LOCK_FLAG_BITS_MAX_ENUM_KHR, "VK_ACQUIRE_PROFILING_LOCK_FLAG_BITS_MAX_ENUM_KHR" );
	swigIntConstant( VK_FRAGMENT_SHADING_RATE_COMBINER_OP_KEEP_KHR, "VK_FRAGMENT_SHADING_RATE_COMBINER_OP_KEEP_KHR" );
	swigIntConstant( VK_FRAGMENT_SHADING_RATE_COMBINER_OP_REPLACE_KHR, "VK_FRAGMENT_SHADING_RATE_COMBINER_OP_REPLACE_KHR" );
	swigIntConstant( VK_FRAGMENT_SHADING_RATE_COMBINER_OP_MIN_KHR, "VK_FRAGMENT_SHADING_RATE_COMBINER_OP_MIN_KHR" );
	swigIntConstant( VK_FRAGMENT_SHADING_RATE_COMBINER_OP_MAX_KHR, "VK_FRAGMENT_SHADING_RATE_COMBINER_OP_MAX_KHR" );
	swigIntConstant( VK_FRAGMENT_SHADING_RATE_COMBINER_OP_MUL_KHR, "VK_FRAGMENT_SHADING_RATE_COMBINER_OP_MUL_KHR" );
	swigIntConstant( VK_FRAGMENT_SHADING_RATE_COMBINER_OP_MAX_ENUM_KHR, "VK_FRAGMENT_SHADING_RATE_COMBINER_OP_MAX_ENUM_KHR" );
	swigIntConstant( VK_PIPELINE_EXECUTABLE_STATISTIC_FORMAT_BOOL32_KHR, "VK_PIPELINE_EXECUTABLE_STATISTIC_FORMAT_BOOL32_KHR" );
	swigIntConstant( VK_PIPELINE_EXECUTABLE_STATISTIC_FORMAT_INT64_KHR, "VK_PIPELINE_EXECUTABLE_STATISTIC_FORMAT_INT64_KHR" );
	swigIntConstant( VK_PIPELINE_EXECUTABLE_STATISTIC_FORMAT_UINT64_KHR, "VK_PIPELINE_EXECUTABLE_STATISTIC_FORMAT_UINT64_KHR" );
	swigIntConstant( VK_PIPELINE_EXECUTABLE_STATISTIC_FORMAT_FLOAT64_KHR, "VK_PIPELINE_EXECUTABLE_STATISTIC_FORMAT_FLOAT64_KHR" );
	swigIntConstant( VK_PIPELINE_EXECUTABLE_STATISTIC_FORMAT_MAX_ENUM_KHR, "VK_PIPELINE_EXECUTABLE_STATISTIC_FORMAT_MAX_ENUM_KHR" );
	swigIntConstant( VK_SUBMIT_PROTECTED_BIT_KHR, "VK_SUBMIT_PROTECTED_BIT_KHR" );
	swigIntConstant( VK_SUBMIT_FLAG_BITS_MAX_ENUM_KHR, "VK_SUBMIT_FLAG_BITS_MAX_ENUM_KHR" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_UNKNOWN_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_UNKNOWN_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_INSTANCE_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_INSTANCE_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_PHYSICAL_DEVICE_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_PHYSICAL_DEVICE_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_DEVICE_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_DEVICE_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_QUEUE_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_QUEUE_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_SEMAPHORE_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_SEMAPHORE_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_COMMAND_BUFFER_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_COMMAND_BUFFER_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_FENCE_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_FENCE_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_DEVICE_MEMORY_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_DEVICE_MEMORY_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_BUFFER_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_BUFFER_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_IMAGE_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_IMAGE_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_EVENT_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_EVENT_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_QUERY_POOL_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_QUERY_POOL_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_BUFFER_VIEW_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_BUFFER_VIEW_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_IMAGE_VIEW_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_IMAGE_VIEW_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_SHADER_MODULE_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_SHADER_MODULE_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_PIPELINE_CACHE_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_PIPELINE_CACHE_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_PIPELINE_LAYOUT_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_PIPELINE_LAYOUT_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_RENDER_PASS_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_RENDER_PASS_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_PIPELINE_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_PIPELINE_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_DESCRIPTOR_SET_LAYOUT_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_DESCRIPTOR_SET_LAYOUT_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_SAMPLER_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_SAMPLER_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_DESCRIPTOR_POOL_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_DESCRIPTOR_POOL_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_DESCRIPTOR_SET_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_DESCRIPTOR_SET_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_FRAMEBUFFER_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_FRAMEBUFFER_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_COMMAND_POOL_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_COMMAND_POOL_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_SURFACE_KHR_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_SURFACE_KHR_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_SWAPCHAIN_KHR_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_SWAPCHAIN_KHR_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_DEBUG_REPORT_CALLBACK_EXT_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_DEBUG_REPORT_CALLBACK_EXT_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_DISPLAY_KHR_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_DISPLAY_KHR_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_DISPLAY_MODE_KHR_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_DISPLAY_MODE_KHR_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_VALIDATION_CACHE_EXT_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_VALIDATION_CACHE_EXT_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_SAMPLER_YCBCR_CONVERSION_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_SAMPLER_YCBCR_CONVERSION_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_CU_MODULE_NVX_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_CU_MODULE_NVX_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_CU_FUNCTION_NVX_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_CU_FUNCTION_NVX_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_ACCELERATION_STRUCTURE_KHR_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_ACCELERATION_STRUCTURE_KHR_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_ACCELERATION_STRUCTURE_NV_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_ACCELERATION_STRUCTURE_NV_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_BUFFER_COLLECTION_FUCHSIA_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_BUFFER_COLLECTION_FUCHSIA_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_DEBUG_REPORT_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_DEBUG_REPORT_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_VALIDATION_CACHE_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_VALIDATION_CACHE_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_KHR_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_KHR_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_SAMPLER_YCBCR_CONVERSION_KHR_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_SAMPLER_YCBCR_CONVERSION_KHR_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_MAX_ENUM_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_MAX_ENUM_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_INFORMATION_BIT_EXT, "VK_DEBUG_REPORT_INFORMATION_BIT_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_WARNING_BIT_EXT, "VK_DEBUG_REPORT_WARNING_BIT_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_PERFORMANCE_WARNING_BIT_EXT, "VK_DEBUG_REPORT_PERFORMANCE_WARNING_BIT_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_ERROR_BIT_EXT, "VK_DEBUG_REPORT_ERROR_BIT_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_DEBUG_BIT_EXT, "VK_DEBUG_REPORT_DEBUG_BIT_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_FLAG_BITS_MAX_ENUM_EXT, "VK_DEBUG_REPORT_FLAG_BITS_MAX_ENUM_EXT" );
	swigIntConstant( VK_RASTERIZATION_ORDER_STRICT_AMD, "VK_RASTERIZATION_ORDER_STRICT_AMD" );
	swigIntConstant( VK_RASTERIZATION_ORDER_RELAXED_AMD, "VK_RASTERIZATION_ORDER_RELAXED_AMD" );
	swigIntConstant( VK_RASTERIZATION_ORDER_MAX_ENUM_AMD, "VK_RASTERIZATION_ORDER_MAX_ENUM_AMD" );
	swigIntConstant( VK_SHADER_INFO_TYPE_STATISTICS_AMD, "VK_SHADER_INFO_TYPE_STATISTICS_AMD" );
	swigIntConstant( VK_SHADER_INFO_TYPE_BINARY_AMD, "VK_SHADER_INFO_TYPE_BINARY_AMD" );
	swigIntConstant( VK_SHADER_INFO_TYPE_DISASSEMBLY_AMD, "VK_SHADER_INFO_TYPE_DISASSEMBLY_AMD" );
	swigIntConstant( VK_SHADER_INFO_TYPE_MAX_ENUM_AMD, "VK_SHADER_INFO_TYPE_MAX_ENUM_AMD" );
	swigIntConstant( VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_BIT_NV, "VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_BIT_NV" );
	swigIntConstant( VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT_NV, "VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT_NV" );
	swigIntConstant( VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_IMAGE_BIT_NV, "VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_IMAGE_BIT_NV" );
	swigIntConstant( VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_IMAGE_KMT_BIT_NV, "VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_IMAGE_KMT_BIT_NV" );
	swigIntConstant( VK_EXTERNAL_MEMORY_HANDLE_TYPE_FLAG_BITS_MAX_ENUM_NV, "VK_EXTERNAL_MEMORY_HANDLE_TYPE_FLAG_BITS_MAX_ENUM_NV" );
	swigIntConstant( VK_EXTERNAL_MEMORY_FEATURE_DEDICATED_ONLY_BIT_NV, "VK_EXTERNAL_MEMORY_FEATURE_DEDICATED_ONLY_BIT_NV" );
	swigIntConstant( VK_EXTERNAL_MEMORY_FEATURE_EXPORTABLE_BIT_NV, "VK_EXTERNAL_MEMORY_FEATURE_EXPORTABLE_BIT_NV" );
	swigIntConstant( VK_EXTERNAL_MEMORY_FEATURE_IMPORTABLE_BIT_NV, "VK_EXTERNAL_MEMORY_FEATURE_IMPORTABLE_BIT_NV" );
	swigIntConstant( VK_EXTERNAL_MEMORY_FEATURE_FLAG_BITS_MAX_ENUM_NV, "VK_EXTERNAL_MEMORY_FEATURE_FLAG_BITS_MAX_ENUM_NV" );
	swigIntConstant( VK_VALIDATION_CHECK_ALL_EXT, "VK_VALIDATION_CHECK_ALL_EXT" );
	swigIntConstant( VK_VALIDATION_CHECK_SHADERS_EXT, "VK_VALIDATION_CHECK_SHADERS_EXT" );
	swigIntConstant( VK_VALIDATION_CHECK_MAX_ENUM_EXT, "VK_VALIDATION_CHECK_MAX_ENUM_EXT" );
	swigIntConstant( VK_CONDITIONAL_RENDERING_INVERTED_BIT_EXT, "VK_CONDITIONAL_RENDERING_INVERTED_BIT_EXT" );
	swigIntConstant( VK_CONDITIONAL_RENDERING_FLAG_BITS_MAX_ENUM_EXT, "VK_CONDITIONAL_RENDERING_FLAG_BITS_MAX_ENUM_EXT" );
	swigIntConstant( VK_SURFACE_COUNTER_VBLANK_BIT_EXT, "VK_SURFACE_COUNTER_VBLANK_BIT_EXT" );
	swigIntConstant( VK_SURFACE_COUNTER_VBLANK_EXT, "VK_SURFACE_COUNTER_VBLANK_EXT" );
	swigIntConstant( VK_SURFACE_COUNTER_FLAG_BITS_MAX_ENUM_EXT, "VK_SURFACE_COUNTER_FLAG_BITS_MAX_ENUM_EXT" );
	swigIntConstant( VK_DISPLAY_POWER_STATE_OFF_EXT, "VK_DISPLAY_POWER_STATE_OFF_EXT" );
	swigIntConstant( VK_DISPLAY_POWER_STATE_SUSPEND_EXT, "VK_DISPLAY_POWER_STATE_SUSPEND_EXT" );
	swigIntConstant( VK_DISPLAY_POWER_STATE_ON_EXT, "VK_DISPLAY_POWER_STATE_ON_EXT" );
	swigIntConstant( VK_DISPLAY_POWER_STATE_MAX_ENUM_EXT, "VK_DISPLAY_POWER_STATE_MAX_ENUM_EXT" );
	swigIntConstant( VK_DEVICE_EVENT_TYPE_DISPLAY_HOTPLUG_EXT, "VK_DEVICE_EVENT_TYPE_DISPLAY_HOTPLUG_EXT" );
	swigIntConstant( VK_DEVICE_EVENT_TYPE_MAX_ENUM_EXT, "VK_DEVICE_EVENT_TYPE_MAX_ENUM_EXT" );
	swigIntConstant( VK_DISPLAY_EVENT_TYPE_FIRST_PIXEL_OUT_EXT, "VK_DISPLAY_EVENT_TYPE_FIRST_PIXEL_OUT_EXT" );
	swigIntConstant( VK_DISPLAY_EVENT_TYPE_MAX_ENUM_EXT, "VK_DISPLAY_EVENT_TYPE_MAX_ENUM_EXT" );
	swigIntConstant( VK_VIEWPORT_COORDINATE_SWIZZLE_POSITIVE_X_NV, "VK_VIEWPORT_COORDINATE_SWIZZLE_POSITIVE_X_NV" );
	swigIntConstant( VK_VIEWPORT_COORDINATE_SWIZZLE_NEGATIVE_X_NV, "VK_VIEWPORT_COORDINATE_SWIZZLE_NEGATIVE_X_NV" );
	swigIntConstant( VK_VIEWPORT_COORDINATE_SWIZZLE_POSITIVE_Y_NV, "VK_VIEWPORT_COORDINATE_SWIZZLE_POSITIVE_Y_NV" );
	swigIntConstant( VK_VIEWPORT_COORDINATE_SWIZZLE_NEGATIVE_Y_NV, "VK_VIEWPORT_COORDINATE_SWIZZLE_NEGATIVE_Y_NV" );
	swigIntConstant( VK_VIEWPORT_COORDINATE_SWIZZLE_POSITIVE_Z_NV, "VK_VIEWPORT_COORDINATE_SWIZZLE_POSITIVE_Z_NV" );
	swigIntConstant( VK_VIEWPORT_COORDINATE_SWIZZLE_NEGATIVE_Z_NV, "VK_VIEWPORT_COORDINATE_SWIZZLE_NEGATIVE_Z_NV" );
	swigIntConstant( VK_VIEWPORT_COORDINATE_SWIZZLE_POSITIVE_W_NV, "VK_VIEWPORT_COORDINATE_SWIZZLE_POSITIVE_W_NV" );
	swigIntConstant( VK_VIEWPORT_COORDINATE_SWIZZLE_NEGATIVE_W_NV, "VK_VIEWPORT_COORDINATE_SWIZZLE_NEGATIVE_W_NV" );
	swigIntConstant( VK_VIEWPORT_COORDINATE_SWIZZLE_MAX_ENUM_NV, "VK_VIEWPORT_COORDINATE_SWIZZLE_MAX_ENUM_NV" );
	swigIntConstant( VK_DISCARD_RECTANGLE_MODE_INCLUSIVE_EXT, "VK_DISCARD_RECTANGLE_MODE_INCLUSIVE_EXT" );
	swigIntConstant( VK_DISCARD_RECTANGLE_MODE_EXCLUSIVE_EXT, "VK_DISCARD_RECTANGLE_MODE_EXCLUSIVE_EXT" );
	swigIntConstant( VK_DISCARD_RECTANGLE_MODE_MAX_ENUM_EXT, "VK_DISCARD_RECTANGLE_MODE_MAX_ENUM_EXT" );
	swigIntConstant( VK_CONSERVATIVE_RASTERIZATION_MODE_DISABLED_EXT, "VK_CONSERVATIVE_RASTERIZATION_MODE_DISABLED_EXT" );
	swigIntConstant( VK_CONSERVATIVE_RASTERIZATION_MODE_OVERESTIMATE_EXT, "VK_CONSERVATIVE_RASTERIZATION_MODE_OVERESTIMATE_EXT" );
	swigIntConstant( VK_CONSERVATIVE_RASTERIZATION_MODE_UNDERESTIMATE_EXT, "VK_CONSERVATIVE_RASTERIZATION_MODE_UNDERESTIMATE_EXT" );
	swigIntConstant( VK_CONSERVATIVE_RASTERIZATION_MODE_MAX_ENUM_EXT, "VK_CONSERVATIVE_RASTERIZATION_MODE_MAX_ENUM_EXT" );
	swigIntConstant( VK_DEBUG_UTILS_MESSAGE_SEVERITY_VERBOSE_BIT_EXT, "VK_DEBUG_UTILS_MESSAGE_SEVERITY_VERBOSE_BIT_EXT" );
	swigIntConstant( VK_DEBUG_UTILS_MESSAGE_SEVERITY_INFO_BIT_EXT, "VK_DEBUG_UTILS_MESSAGE_SEVERITY_INFO_BIT_EXT" );
	swigIntConstant( VK_DEBUG_UTILS_MESSAGE_SEVERITY_WARNING_BIT_EXT, "VK_DEBUG_UTILS_MESSAGE_SEVERITY_WARNING_BIT_EXT" );
	swigIntConstant( VK_DEBUG_UTILS_MESSAGE_SEVERITY_ERROR_BIT_EXT, "VK_DEBUG_UTILS_MESSAGE_SEVERITY_ERROR_BIT_EXT" );
	swigIntConstant( VK_DEBUG_UTILS_MESSAGE_SEVERITY_FLAG_BITS_MAX_ENUM_EXT, "VK_DEBUG_UTILS_MESSAGE_SEVERITY_FLAG_BITS_MAX_ENUM_EXT" );
	swigIntConstant( VK_DEBUG_UTILS_MESSAGE_TYPE_GENERAL_BIT_EXT, "VK_DEBUG_UTILS_MESSAGE_TYPE_GENERAL_BIT_EXT" );
	swigIntConstant( VK_DEBUG_UTILS_MESSAGE_TYPE_VALIDATION_BIT_EXT, "VK_DEBUG_UTILS_MESSAGE_TYPE_VALIDATION_BIT_EXT" );
	swigIntConstant( VK_DEBUG_UTILS_MESSAGE_TYPE_PERFORMANCE_BIT_EXT, "VK_DEBUG_UTILS_MESSAGE_TYPE_PERFORMANCE_BIT_EXT" );
	swigIntConstant( VK_DEBUG_UTILS_MESSAGE_TYPE_FLAG_BITS_MAX_ENUM_EXT, "VK_DEBUG_UTILS_MESSAGE_TYPE_FLAG_BITS_MAX_ENUM_EXT" );
	swigIntConstant( VK_BLEND_OVERLAP_UNCORRELATED_EXT, "VK_BLEND_OVERLAP_UNCORRELATED_EXT" );
	swigIntConstant( VK_BLEND_OVERLAP_DISJOINT_EXT, "VK_BLEND_OVERLAP_DISJOINT_EXT" );
	swigIntConstant( VK_BLEND_OVERLAP_CONJOINT_EXT, "VK_BLEND_OVERLAP_CONJOINT_EXT" );
	swigIntConstant( VK_BLEND_OVERLAP_MAX_ENUM_EXT, "VK_BLEND_OVERLAP_MAX_ENUM_EXT" );
	swigIntConstant( VK_COVERAGE_MODULATION_MODE_NONE_NV, "VK_COVERAGE_MODULATION_MODE_NONE_NV" );
	swigIntConstant( VK_COVERAGE_MODULATION_MODE_RGB_NV, "VK_COVERAGE_MODULATION_MODE_RGB_NV" );
	swigIntConstant( VK_COVERAGE_MODULATION_MODE_ALPHA_NV, "VK_COVERAGE_MODULATION_MODE_ALPHA_NV" );
	swigIntConstant( VK_COVERAGE_MODULATION_MODE_RGBA_NV, "VK_COVERAGE_MODULATION_MODE_RGBA_NV" );
	swigIntConstant( VK_COVERAGE_MODULATION_MODE_MAX_ENUM_NV, "VK_COVERAGE_MODULATION_MODE_MAX_ENUM_NV" );
	swigIntConstant( VK_VALIDATION_CACHE_HEADER_VERSION_ONE_EXT, "VK_VALIDATION_CACHE_HEADER_VERSION_ONE_EXT" );
	swigIntConstant( VK_VALIDATION_CACHE_HEADER_VERSION_MAX_ENUM_EXT, "VK_VALIDATION_CACHE_HEADER_VERSION_MAX_ENUM_EXT" );
	swigIntConstant( VK_SHADING_RATE_PALETTE_ENTRY_NO_INVOCATIONS_NV, "VK_SHADING_RATE_PALETTE_ENTRY_NO_INVOCATIONS_NV" );
	swigIntConstant( VK_SHADING_RATE_PALETTE_ENTRY_16_INVOCATIONS_PER_PIXEL_NV, "VK_SHADING_RATE_PALETTE_ENTRY_16_INVOCATIONS_PER_PIXEL_NV" );
	swigIntConstant( VK_SHADING_RATE_PALETTE_ENTRY_8_INVOCATIONS_PER_PIXEL_NV, "VK_SHADING_RATE_PALETTE_ENTRY_8_INVOCATIONS_PER_PIXEL_NV" );
	swigIntConstant( VK_SHADING_RATE_PALETTE_ENTRY_4_INVOCATIONS_PER_PIXEL_NV, "VK_SHADING_RATE_PALETTE_ENTRY_4_INVOCATIONS_PER_PIXEL_NV" );
	swigIntConstant( VK_SHADING_RATE_PALETTE_ENTRY_2_INVOCATIONS_PER_PIXEL_NV, "VK_SHADING_RATE_PALETTE_ENTRY_2_INVOCATIONS_PER_PIXEL_NV" );
	swigIntConstant( VK_SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_PIXEL_NV, "VK_SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_PIXEL_NV" );
	swigIntConstant( VK_SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_2X1_PIXELS_NV, "VK_SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_2X1_PIXELS_NV" );
	swigIntConstant( VK_SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_1X2_PIXELS_NV, "VK_SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_1X2_PIXELS_NV" );
	swigIntConstant( VK_SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_2X2_PIXELS_NV, "VK_SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_2X2_PIXELS_NV" );
	swigIntConstant( VK_SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_4X2_PIXELS_NV, "VK_SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_4X2_PIXELS_NV" );
	swigIntConstant( VK_SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_2X4_PIXELS_NV, "VK_SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_2X4_PIXELS_NV" );
	swigIntConstant( VK_SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_4X4_PIXELS_NV, "VK_SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_4X4_PIXELS_NV" );
	swigIntConstant( VK_SHADING_RATE_PALETTE_ENTRY_MAX_ENUM_NV, "VK_SHADING_RATE_PALETTE_ENTRY_MAX_ENUM_NV" );
	swigIntConstant( VK_COARSE_SAMPLE_ORDER_TYPE_DEFAULT_NV, "VK_COARSE_SAMPLE_ORDER_TYPE_DEFAULT_NV" );
	swigIntConstant( VK_COARSE_SAMPLE_ORDER_TYPE_CUSTOM_NV, "VK_COARSE_SAMPLE_ORDER_TYPE_CUSTOM_NV" );
	swigIntConstant( VK_COARSE_SAMPLE_ORDER_TYPE_PIXEL_MAJOR_NV, "VK_COARSE_SAMPLE_ORDER_TYPE_PIXEL_MAJOR_NV" );
	swigIntConstant( VK_COARSE_SAMPLE_ORDER_TYPE_SAMPLE_MAJOR_NV, "VK_COARSE_SAMPLE_ORDER_TYPE_SAMPLE_MAJOR_NV" );
	swigIntConstant( VK_COARSE_SAMPLE_ORDER_TYPE_MAX_ENUM_NV, "VK_COARSE_SAMPLE_ORDER_TYPE_MAX_ENUM_NV" );
	swigIntConstant( VK_RAY_TRACING_SHADER_GROUP_TYPE_GENERAL_KHR, "VK_RAY_TRACING_SHADER_GROUP_TYPE_GENERAL_KHR" );
	swigIntConstant( VK_RAY_TRACING_SHADER_GROUP_TYPE_TRIANGLES_HIT_GROUP_KHR, "VK_RAY_TRACING_SHADER_GROUP_TYPE_TRIANGLES_HIT_GROUP_KHR" );
	swigIntConstant( VK_RAY_TRACING_SHADER_GROUP_TYPE_PROCEDURAL_HIT_GROUP_KHR, "VK_RAY_TRACING_SHADER_GROUP_TYPE_PROCEDURAL_HIT_GROUP_KHR" );
	swigIntConstant( VK_RAY_TRACING_SHADER_GROUP_TYPE_GENERAL_NV, "VK_RAY_TRACING_SHADER_GROUP_TYPE_GENERAL_NV" );
	swigIntConstant( VK_RAY_TRACING_SHADER_GROUP_TYPE_TRIANGLES_HIT_GROUP_NV, "VK_RAY_TRACING_SHADER_GROUP_TYPE_TRIANGLES_HIT_GROUP_NV" );
	swigIntConstant( VK_RAY_TRACING_SHADER_GROUP_TYPE_PROCEDURAL_HIT_GROUP_NV, "VK_RAY_TRACING_SHADER_GROUP_TYPE_PROCEDURAL_HIT_GROUP_NV" );
	swigIntConstant( VK_RAY_TRACING_SHADER_GROUP_TYPE_MAX_ENUM_KHR, "VK_RAY_TRACING_SHADER_GROUP_TYPE_MAX_ENUM_KHR" );
	swigIntConstant( VK_GEOMETRY_TYPE_TRIANGLES_KHR, "VK_GEOMETRY_TYPE_TRIANGLES_KHR" );
	swigIntConstant( VK_GEOMETRY_TYPE_AABBS_KHR, "VK_GEOMETRY_TYPE_AABBS_KHR" );
	swigIntConstant( VK_GEOMETRY_TYPE_INSTANCES_KHR, "VK_GEOMETRY_TYPE_INSTANCES_KHR" );
	swigIntConstant( VK_GEOMETRY_TYPE_TRIANGLES_NV, "VK_GEOMETRY_TYPE_TRIANGLES_NV" );
	swigIntConstant( VK_GEOMETRY_TYPE_AABBS_NV, "VK_GEOMETRY_TYPE_AABBS_NV" );
	swigIntConstant( VK_GEOMETRY_TYPE_MAX_ENUM_KHR, "VK_GEOMETRY_TYPE_MAX_ENUM_KHR" );
	swigIntConstant( VK_ACCELERATION_STRUCTURE_TYPE_TOP_LEVEL_KHR, "VK_ACCELERATION_STRUCTURE_TYPE_TOP_LEVEL_KHR" );
	swigIntConstant( VK_ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL_KHR, "VK_ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL_KHR" );
	swigIntConstant( VK_ACCELERATION_STRUCTURE_TYPE_GENERIC_KHR, "VK_ACCELERATION_STRUCTURE_TYPE_GENERIC_KHR" );
	swigIntConstant( VK_ACCELERATION_STRUCTURE_TYPE_TOP_LEVEL_NV, "VK_ACCELERATION_STRUCTURE_TYPE_TOP_LEVEL_NV" );
	swigIntConstant( VK_ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL_NV, "VK_ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL_NV" );
	swigIntConstant( VK_ACCELERATION_STRUCTURE_TYPE_MAX_ENUM_KHR, "VK_ACCELERATION_STRUCTURE_TYPE_MAX_ENUM_KHR" );
	swigIntConstant( VK_COPY_ACCELERATION_STRUCTURE_MODE_CLONE_KHR, "VK_COPY_ACCELERATION_STRUCTURE_MODE_CLONE_KHR" );
	swigIntConstant( VK_COPY_ACCELERATION_STRUCTURE_MODE_COMPACT_KHR, "VK_COPY_ACCELERATION_STRUCTURE_MODE_COMPACT_KHR" );
	swigIntConstant( VK_COPY_ACCELERATION_STRUCTURE_MODE_SERIALIZE_KHR, "VK_COPY_ACCELERATION_STRUCTURE_MODE_SERIALIZE_KHR" );
	swigIntConstant( VK_COPY_ACCELERATION_STRUCTURE_MODE_DESERIALIZE_KHR, "VK_COPY_ACCELERATION_STRUCTURE_MODE_DESERIALIZE_KHR" );
	swigIntConstant( VK_COPY_ACCELERATION_STRUCTURE_MODE_CLONE_NV, "VK_COPY_ACCELERATION_STRUCTURE_MODE_CLONE_NV" );
	swigIntConstant( VK_COPY_ACCELERATION_STRUCTURE_MODE_COMPACT_NV, "VK_COPY_ACCELERATION_STRUCTURE_MODE_COMPACT_NV" );
	swigIntConstant( VK_COPY_ACCELERATION_STRUCTURE_MODE_MAX_ENUM_KHR, "VK_COPY_ACCELERATION_STRUCTURE_MODE_MAX_ENUM_KHR" );
	swigIntConstant( VK_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_TYPE_OBJECT_NV, "VK_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_TYPE_OBJECT_NV" );
	swigIntConstant( VK_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_TYPE_BUILD_SCRATCH_NV, "VK_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_TYPE_BUILD_SCRATCH_NV" );
	swigIntConstant( VK_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_TYPE_UPDATE_SCRATCH_NV, "VK_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_TYPE_UPDATE_SCRATCH_NV" );
	swigIntConstant( VK_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_TYPE_MAX_ENUM_NV, "VK_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_TYPE_MAX_ENUM_NV" );
	swigIntConstant( VK_GEOMETRY_OPAQUE_BIT_KHR, "VK_GEOMETRY_OPAQUE_BIT_KHR" );
	swigIntConstant( VK_GEOMETRY_NO_DUPLICATE_ANY_HIT_INVOCATION_BIT_KHR, "VK_GEOMETRY_NO_DUPLICATE_ANY_HIT_INVOCATION_BIT_KHR" );
	swigIntConstant( VK_GEOMETRY_OPAQUE_BIT_NV, "VK_GEOMETRY_OPAQUE_BIT_NV" );
	swigIntConstant( VK_GEOMETRY_NO_DUPLICATE_ANY_HIT_INVOCATION_BIT_NV, "VK_GEOMETRY_NO_DUPLICATE_ANY_HIT_INVOCATION_BIT_NV" );
	swigIntConstant( VK_GEOMETRY_FLAG_BITS_MAX_ENUM_KHR, "VK_GEOMETRY_FLAG_BITS_MAX_ENUM_KHR" );
	swigIntConstant( VK_GEOMETRY_INSTANCE_TRIANGLE_FACING_CULL_DISABLE_BIT_KHR, "VK_GEOMETRY_INSTANCE_TRIANGLE_FACING_CULL_DISABLE_BIT_KHR" );
	swigIntConstant( VK_GEOMETRY_INSTANCE_TRIANGLE_FLIP_FACING_BIT_KHR, "VK_GEOMETRY_INSTANCE_TRIANGLE_FLIP_FACING_BIT_KHR" );
	swigIntConstant( VK_GEOMETRY_INSTANCE_FORCE_OPAQUE_BIT_KHR, "VK_GEOMETRY_INSTANCE_FORCE_OPAQUE_BIT_KHR" );
	swigIntConstant( VK_GEOMETRY_INSTANCE_FORCE_NO_OPAQUE_BIT_KHR, "VK_GEOMETRY_INSTANCE_FORCE_NO_OPAQUE_BIT_KHR" );
	swigIntConstant( VK_GEOMETRY_INSTANCE_TRIANGLE_FRONT_COUNTERCLOCKWISE_BIT_KHR, "VK_GEOMETRY_INSTANCE_TRIANGLE_FRONT_COUNTERCLOCKWISE_BIT_KHR" );
	swigIntConstant( VK_GEOMETRY_INSTANCE_TRIANGLE_CULL_DISABLE_BIT_NV, "VK_GEOMETRY_INSTANCE_TRIANGLE_CULL_DISABLE_BIT_NV" );
	swigIntConstant( VK_GEOMETRY_INSTANCE_TRIANGLE_FRONT_COUNTERCLOCKWISE_BIT_NV, "VK_GEOMETRY_INSTANCE_TRIANGLE_FRONT_COUNTERCLOCKWISE_BIT_NV" );
	swigIntConstant( VK_GEOMETRY_INSTANCE_FORCE_OPAQUE_BIT_NV, "VK_GEOMETRY_INSTANCE_FORCE_OPAQUE_BIT_NV" );
	swigIntConstant( VK_GEOMETRY_INSTANCE_FORCE_NO_OPAQUE_BIT_NV, "VK_GEOMETRY_INSTANCE_FORCE_NO_OPAQUE_BIT_NV" );
	swigIntConstant( VK_GEOMETRY_INSTANCE_FLAG_BITS_MAX_ENUM_KHR, "VK_GEOMETRY_INSTANCE_FLAG_BITS_MAX_ENUM_KHR" );
	swigIntConstant( VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_UPDATE_BIT_KHR, "VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_UPDATE_BIT_KHR" );
	swigIntConstant( VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_COMPACTION_BIT_KHR, "VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_COMPACTION_BIT_KHR" );
	swigIntConstant( VK_BUILD_ACCELERATION_STRUCTURE_PREFER_FAST_TRACE_BIT_KHR, "VK_BUILD_ACCELERATION_STRUCTURE_PREFER_FAST_TRACE_BIT_KHR" );
	swigIntConstant( VK_BUILD_ACCELERATION_STRUCTURE_PREFER_FAST_BUILD_BIT_KHR, "VK_BUILD_ACCELERATION_STRUCTURE_PREFER_FAST_BUILD_BIT_KHR" );
	swigIntConstant( VK_BUILD_ACCELERATION_STRUCTURE_LOW_MEMORY_BIT_KHR, "VK_BUILD_ACCELERATION_STRUCTURE_LOW_MEMORY_BIT_KHR" );
	swigIntConstant( VK_BUILD_ACCELERATION_STRUCTURE_MOTION_BIT_NV, "VK_BUILD_ACCELERATION_STRUCTURE_MOTION_BIT_NV" );
	swigIntConstant( VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_UPDATE_BIT_NV, "VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_UPDATE_BIT_NV" );
	swigIntConstant( VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_COMPACTION_BIT_NV, "VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_COMPACTION_BIT_NV" );
	swigIntConstant( VK_BUILD_ACCELERATION_STRUCTURE_PREFER_FAST_TRACE_BIT_NV, "VK_BUILD_ACCELERATION_STRUCTURE_PREFER_FAST_TRACE_BIT_NV" );
	swigIntConstant( VK_BUILD_ACCELERATION_STRUCTURE_PREFER_FAST_BUILD_BIT_NV, "VK_BUILD_ACCELERATION_STRUCTURE_PREFER_FAST_BUILD_BIT_NV" );
	swigIntConstant( VK_BUILD_ACCELERATION_STRUCTURE_LOW_MEMORY_BIT_NV, "VK_BUILD_ACCELERATION_STRUCTURE_LOW_MEMORY_BIT_NV" );
	swigIntConstant( VK_BUILD_ACCELERATION_STRUCTURE_FLAG_BITS_MAX_ENUM_KHR, "VK_BUILD_ACCELERATION_STRUCTURE_FLAG_BITS_MAX_ENUM_KHR" );
	swigIntConstant( VK_QUEUE_GLOBAL_PRIORITY_LOW_EXT, "VK_QUEUE_GLOBAL_PRIORITY_LOW_EXT" );
	swigIntConstant( VK_QUEUE_GLOBAL_PRIORITY_MEDIUM_EXT, "VK_QUEUE_GLOBAL_PRIORITY_MEDIUM_EXT" );
	swigIntConstant( VK_QUEUE_GLOBAL_PRIORITY_HIGH_EXT, "VK_QUEUE_GLOBAL_PRIORITY_HIGH_EXT" );
	swigIntConstant( VK_QUEUE_GLOBAL_PRIORITY_REALTIME_EXT, "VK_QUEUE_GLOBAL_PRIORITY_REALTIME_EXT" );
	swigIntConstant( VK_QUEUE_GLOBAL_PRIORITY_MAX_ENUM_EXT, "VK_QUEUE_GLOBAL_PRIORITY_MAX_ENUM_EXT" );
	swigIntConstant( VK_PIPELINE_COMPILER_CONTROL_FLAG_BITS_MAX_ENUM_AMD, "VK_PIPELINE_COMPILER_CONTROL_FLAG_BITS_MAX_ENUM_AMD" );
	swigIntConstant( VK_TIME_DOMAIN_DEVICE_EXT, "VK_TIME_DOMAIN_DEVICE_EXT" );
	swigIntConstant( VK_TIME_DOMAIN_CLOCK_MONOTONIC_EXT, "VK_TIME_DOMAIN_CLOCK_MONOTONIC_EXT" );
	swigIntConstant( VK_TIME_DOMAIN_CLOCK_MONOTONIC_RAW_EXT, "VK_TIME_DOMAIN_CLOCK_MONOTONIC_RAW_EXT" );
	swigIntConstant( VK_TIME_DOMAIN_QUERY_PERFORMANCE_COUNTER_EXT, "VK_TIME_DOMAIN_QUERY_PERFORMANCE_COUNTER_EXT" );
	swigIntConstant( VK_TIME_DOMAIN_MAX_ENUM_EXT, "VK_TIME_DOMAIN_MAX_ENUM_EXT" );
	swigIntConstant( VK_MEMORY_OVERALLOCATION_BEHAVIOR_DEFAULT_AMD, "VK_MEMORY_OVERALLOCATION_BEHAVIOR_DEFAULT_AMD" );
	swigIntConstant( VK_MEMORY_OVERALLOCATION_BEHAVIOR_ALLOWED_AMD, "VK_MEMORY_OVERALLOCATION_BEHAVIOR_ALLOWED_AMD" );
	swigIntConstant( VK_MEMORY_OVERALLOCATION_BEHAVIOR_DISALLOWED_AMD, "VK_MEMORY_OVERALLOCATION_BEHAVIOR_DISALLOWED_AMD" );
	swigIntConstant( VK_MEMORY_OVERALLOCATION_BEHAVIOR_MAX_ENUM_AMD, "VK_MEMORY_OVERALLOCATION_BEHAVIOR_MAX_ENUM_AMD" );
	swigIntConstant( VK_PIPELINE_CREATION_FEEDBACK_VALID_BIT_EXT, "VK_PIPELINE_CREATION_FEEDBACK_VALID_BIT_EXT" );
	swigIntConstant( VK_PIPELINE_CREATION_FEEDBACK_APPLICATION_PIPELINE_CACHE_HIT_BIT_EXT, "VK_PIPELINE_CREATION_FEEDBACK_APPLICATION_PIPELINE_CACHE_HIT_BIT_EXT" );
	swigIntConstant( VK_PIPELINE_CREATION_FEEDBACK_BASE_PIPELINE_ACCELERATION_BIT_EXT, "VK_PIPELINE_CREATION_FEEDBACK_BASE_PIPELINE_ACCELERATION_BIT_EXT" );
	swigIntConstant( VK_PIPELINE_CREATION_FEEDBACK_FLAG_BITS_MAX_ENUM_EXT, "VK_PIPELINE_CREATION_FEEDBACK_FLAG_BITS_MAX_ENUM_EXT" );
	swigIntConstant( VK_PERFORMANCE_CONFIGURATION_TYPE_COMMAND_QUEUE_METRICS_DISCOVERY_ACTIVATED_INTEL, "VK_PERFORMANCE_CONFIGURATION_TYPE_COMMAND_QUEUE_METRICS_DISCOVERY_ACTIVATED_INTEL" );
	swigIntConstant( VK_PERFORMANCE_CONFIGURATION_TYPE_MAX_ENUM_INTEL, "VK_PERFORMANCE_CONFIGURATION_TYPE_MAX_ENUM_INTEL" );
	swigIntConstant( VK_QUERY_POOL_SAMPLING_MODE_MANUAL_INTEL, "VK_QUERY_POOL_SAMPLING_MODE_MANUAL_INTEL" );
	swigIntConstant( VK_QUERY_POOL_SAMPLING_MODE_MAX_ENUM_INTEL, "VK_QUERY_POOL_SAMPLING_MODE_MAX_ENUM_INTEL" );
	swigIntConstant( VK_PERFORMANCE_OVERRIDE_TYPE_NULL_HARDWARE_INTEL, "VK_PERFORMANCE_OVERRIDE_TYPE_NULL_HARDWARE_INTEL" );
	swigIntConstant( VK_PERFORMANCE_OVERRIDE_TYPE_FLUSH_GPU_CACHES_INTEL, "VK_PERFORMANCE_OVERRIDE_TYPE_FLUSH_GPU_CACHES_INTEL" );
	swigIntConstant( VK_PERFORMANCE_OVERRIDE_TYPE_MAX_ENUM_INTEL, "VK_PERFORMANCE_OVERRIDE_TYPE_MAX_ENUM_INTEL" );
	swigIntConstant( VK_PERFORMANCE_PARAMETER_TYPE_HW_COUNTERS_SUPPORTED_INTEL, "VK_PERFORMANCE_PARAMETER_TYPE_HW_COUNTERS_SUPPORTED_INTEL" );
	swigIntConstant( VK_PERFORMANCE_PARAMETER_TYPE_STREAM_MARKER_VALID_BITS_INTEL, "VK_PERFORMANCE_PARAMETER_TYPE_STREAM_MARKER_VALID_BITS_INTEL" );
	swigIntConstant( VK_PERFORMANCE_PARAMETER_TYPE_MAX_ENUM_INTEL, "VK_PERFORMANCE_PARAMETER_TYPE_MAX_ENUM_INTEL" );
	swigIntConstant( VK_PERFORMANCE_VALUE_TYPE_UINT32_INTEL, "VK_PERFORMANCE_VALUE_TYPE_UINT32_INTEL" );
	swigIntConstant( VK_PERFORMANCE_VALUE_TYPE_UINT64_INTEL, "VK_PERFORMANCE_VALUE_TYPE_UINT64_INTEL" );
	swigIntConstant( VK_PERFORMANCE_VALUE_TYPE_FLOAT_INTEL, "VK_PERFORMANCE_VALUE_TYPE_FLOAT_INTEL" );
	swigIntConstant( VK_PERFORMANCE_VALUE_TYPE_BOOL_INTEL, "VK_PERFORMANCE_VALUE_TYPE_BOOL_INTEL" );
	swigIntConstant( VK_PERFORMANCE_VALUE_TYPE_STRING_INTEL, "VK_PERFORMANCE_VALUE_TYPE_STRING_INTEL" );
	swigIntConstant( VK_PERFORMANCE_VALUE_TYPE_MAX_ENUM_INTEL, "VK_PERFORMANCE_VALUE_TYPE_MAX_ENUM_INTEL" );
	swigIntConstant( VK_SHADER_CORE_PROPERTIES_FLAG_BITS_MAX_ENUM_AMD, "VK_SHADER_CORE_PROPERTIES_FLAG_BITS_MAX_ENUM_AMD" );
	swigIntConstant( VK_TOOL_PURPOSE_VALIDATION_BIT_EXT, "VK_TOOL_PURPOSE_VALIDATION_BIT_EXT" );
	swigIntConstant( VK_TOOL_PURPOSE_PROFILING_BIT_EXT, "VK_TOOL_PURPOSE_PROFILING_BIT_EXT" );
	swigIntConstant( VK_TOOL_PURPOSE_TRACING_BIT_EXT, "VK_TOOL_PURPOSE_TRACING_BIT_EXT" );
	swigIntConstant( VK_TOOL_PURPOSE_ADDITIONAL_FEATURES_BIT_EXT, "VK_TOOL_PURPOSE_ADDITIONAL_FEATURES_BIT_EXT" );
	swigIntConstant( VK_TOOL_PURPOSE_MODIFYING_FEATURES_BIT_EXT, "VK_TOOL_PURPOSE_MODIFYING_FEATURES_BIT_EXT" );
	swigIntConstant( VK_TOOL_PURPOSE_DEBUG_REPORTING_BIT_EXT, "VK_TOOL_PURPOSE_DEBUG_REPORTING_BIT_EXT" );
	swigIntConstant( VK_TOOL_PURPOSE_DEBUG_MARKERS_BIT_EXT, "VK_TOOL_PURPOSE_DEBUG_MARKERS_BIT_EXT" );
	swigIntConstant( VK_TOOL_PURPOSE_FLAG_BITS_MAX_ENUM_EXT, "VK_TOOL_PURPOSE_FLAG_BITS_MAX_ENUM_EXT" );
	swigIntConstant( VK_VALIDATION_FEATURE_ENABLE_GPU_ASSISTED_EXT, "VK_VALIDATION_FEATURE_ENABLE_GPU_ASSISTED_EXT" );
	swigIntConstant( VK_VALIDATION_FEATURE_ENABLE_GPU_ASSISTED_RESERVE_BINDING_SLOT_EXT, "VK_VALIDATION_FEATURE_ENABLE_GPU_ASSISTED_RESERVE_BINDING_SLOT_EXT" );
	swigIntConstant( VK_VALIDATION_FEATURE_ENABLE_BEST_PRACTICES_EXT, "VK_VALIDATION_FEATURE_ENABLE_BEST_PRACTICES_EXT" );
	swigIntConstant( VK_VALIDATION_FEATURE_ENABLE_DEBUG_PRINTF_EXT, "VK_VALIDATION_FEATURE_ENABLE_DEBUG_PRINTF_EXT" );
	swigIntConstant( VK_VALIDATION_FEATURE_ENABLE_SYNCHRONIZATION_VALIDATION_EXT, "VK_VALIDATION_FEATURE_ENABLE_SYNCHRONIZATION_VALIDATION_EXT" );
	swigIntConstant( VK_VALIDATION_FEATURE_ENABLE_MAX_ENUM_EXT, "VK_VALIDATION_FEATURE_ENABLE_MAX_ENUM_EXT" );
	swigIntConstant( VK_VALIDATION_FEATURE_DISABLE_ALL_EXT, "VK_VALIDATION_FEATURE_DISABLE_ALL_EXT" );
	swigIntConstant( VK_VALIDATION_FEATURE_DISABLE_SHADERS_EXT, "VK_VALIDATION_FEATURE_DISABLE_SHADERS_EXT" );
	swigIntConstant( VK_VALIDATION_FEATURE_DISABLE_THREAD_SAFETY_EXT, "VK_VALIDATION_FEATURE_DISABLE_THREAD_SAFETY_EXT" );
	swigIntConstant( VK_VALIDATION_FEATURE_DISABLE_API_PARAMETERS_EXT, "VK_VALIDATION_FEATURE_DISABLE_API_PARAMETERS_EXT" );
	swigIntConstant( VK_VALIDATION_FEATURE_DISABLE_OBJECT_LIFETIMES_EXT, "VK_VALIDATION_FEATURE_DISABLE_OBJECT_LIFETIMES_EXT" );
	swigIntConstant( VK_VALIDATION_FEATURE_DISABLE_CORE_CHECKS_EXT, "VK_VALIDATION_FEATURE_DISABLE_CORE_CHECKS_EXT" );
	swigIntConstant( VK_VALIDATION_FEATURE_DISABLE_UNIQUE_HANDLES_EXT, "VK_VALIDATION_FEATURE_DISABLE_UNIQUE_HANDLES_EXT" );
	swigIntConstant( VK_VALIDATION_FEATURE_DISABLE_SHADER_VALIDATION_CACHE_EXT, "VK_VALIDATION_FEATURE_DISABLE_SHADER_VALIDATION_CACHE_EXT" );
	swigIntConstant( VK_VALIDATION_FEATURE_DISABLE_MAX_ENUM_EXT, "VK_VALIDATION_FEATURE_DISABLE_MAX_ENUM_EXT" );
	swigIntConstant( VK_COMPONENT_TYPE_FLOAT16_NV, "VK_COMPONENT_TYPE_FLOAT16_NV" );
	swigIntConstant( VK_COMPONENT_TYPE_FLOAT32_NV, "VK_COMPONENT_TYPE_FLOAT32_NV" );
	swigIntConstant( VK_COMPONENT_TYPE_FLOAT64_NV, "VK_COMPONENT_TYPE_FLOAT64_NV" );
	swigIntConstant( VK_COMPONENT_TYPE_SINT8_NV, "VK_COMPONENT_TYPE_SINT8_NV" );
	swigIntConstant( VK_COMPONENT_TYPE_SINT16_NV, "VK_COMPONENT_TYPE_SINT16_NV" );
	swigIntConstant( VK_COMPONENT_TYPE_SINT32_NV, "VK_COMPONENT_TYPE_SINT32_NV" );
	swigIntConstant( VK_COMPONENT_TYPE_SINT64_NV, "VK_COMPONENT_TYPE_SINT64_NV" );
	swigIntConstant( VK_COMPONENT_TYPE_UINT8_NV, "VK_COMPONENT_TYPE_UINT8_NV" );
	swigIntConstant( VK_COMPONENT_TYPE_UINT16_NV, "VK_COMPONENT_TYPE_UINT16_NV" );
	swigIntConstant( VK_COMPONENT_TYPE_UINT32_NV, "VK_COMPONENT_TYPE_UINT32_NV" );
	swigIntConstant( VK_COMPONENT_TYPE_UINT64_NV, "VK_COMPONENT_TYPE_UINT64_NV" );
	swigIntConstant( VK_COMPONENT_TYPE_MAX_ENUM_NV, "VK_COMPONENT_TYPE_MAX_ENUM_NV" );
	swigIntConstant( VK_SCOPE_DEVICE_NV, "VK_SCOPE_DEVICE_NV" );
	swigIntConstant( VK_SCOPE_WORKGROUP_NV, "VK_SCOPE_WORKGROUP_NV" );
	swigIntConstant( VK_SCOPE_SUBGROUP_NV, "VK_SCOPE_SUBGROUP_NV" );
	swigIntConstant( VK_SCOPE_QUEUE_FAMILY_NV, "VK_SCOPE_QUEUE_FAMILY_NV" );
	swigIntConstant( VK_SCOPE_MAX_ENUM_NV, "VK_SCOPE_MAX_ENUM_NV" );
	swigIntConstant( VK_COVERAGE_REDUCTION_MODE_MERGE_NV, "VK_COVERAGE_REDUCTION_MODE_MERGE_NV" );
	swigIntConstant( VK_COVERAGE_REDUCTION_MODE_TRUNCATE_NV, "VK_COVERAGE_REDUCTION_MODE_TRUNCATE_NV" );
	swigIntConstant( VK_COVERAGE_REDUCTION_MODE_MAX_ENUM_NV, "VK_COVERAGE_REDUCTION_MODE_MAX_ENUM_NV" );
	swigIntConstant( VK_PROVOKING_VERTEX_MODE_FIRST_VERTEX_EXT, "VK_PROVOKING_VERTEX_MODE_FIRST_VERTEX_EXT" );
	swigIntConstant( VK_PROVOKING_VERTEX_MODE_LAST_VERTEX_EXT, "VK_PROVOKING_VERTEX_MODE_LAST_VERTEX_EXT" );
	swigIntConstant( VK_PROVOKING_VERTEX_MODE_MAX_ENUM_EXT, "VK_PROVOKING_VERTEX_MODE_MAX_ENUM_EXT" );
	swigIntConstant( VK_LINE_RASTERIZATION_MODE_DEFAULT_EXT, "VK_LINE_RASTERIZATION_MODE_DEFAULT_EXT" );
	swigIntConstant( VK_LINE_RASTERIZATION_MODE_RECTANGULAR_EXT, "VK_LINE_RASTERIZATION_MODE_RECTANGULAR_EXT" );
	swigIntConstant( VK_LINE_RASTERIZATION_MODE_BRESENHAM_EXT, "VK_LINE_RASTERIZATION_MODE_BRESENHAM_EXT" );
	swigIntConstant( VK_LINE_RASTERIZATION_MODE_RECTANGULAR_SMOOTH_EXT, "VK_LINE_RASTERIZATION_MODE_RECTANGULAR_SMOOTH_EXT" );
	swigIntConstant( VK_LINE_RASTERIZATION_MODE_MAX_ENUM_EXT, "VK_LINE_RASTERIZATION_MODE_MAX_ENUM_EXT" );
	swigIntConstant( VK_INDIRECT_COMMANDS_TOKEN_TYPE_SHADER_GROUP_NV, "VK_INDIRECT_COMMANDS_TOKEN_TYPE_SHADER_GROUP_NV" );
	swigIntConstant( VK_INDIRECT_COMMANDS_TOKEN_TYPE_STATE_FLAGS_NV, "VK_INDIRECT_COMMANDS_TOKEN_TYPE_STATE_FLAGS_NV" );
	swigIntConstant( VK_INDIRECT_COMMANDS_TOKEN_TYPE_INDEX_BUFFER_NV, "VK_INDIRECT_COMMANDS_TOKEN_TYPE_INDEX_BUFFER_NV" );
	swigIntConstant( VK_INDIRECT_COMMANDS_TOKEN_TYPE_VERTEX_BUFFER_NV, "VK_INDIRECT_COMMANDS_TOKEN_TYPE_VERTEX_BUFFER_NV" );
	swigIntConstant( VK_INDIRECT_COMMANDS_TOKEN_TYPE_PUSH_CONSTANT_NV, "VK_INDIRECT_COMMANDS_TOKEN_TYPE_PUSH_CONSTANT_NV" );
	swigIntConstant( VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_INDEXED_NV, "VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_INDEXED_NV" );
	swigIntConstant( VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_NV, "VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_NV" );
	swigIntConstant( VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_TASKS_NV, "VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_TASKS_NV" );
	swigIntConstant( VK_INDIRECT_COMMANDS_TOKEN_TYPE_MAX_ENUM_NV, "VK_INDIRECT_COMMANDS_TOKEN_TYPE_MAX_ENUM_NV" );
	swigIntConstant( VK_INDIRECT_STATE_FLAG_FRONTFACE_BIT_NV, "VK_INDIRECT_STATE_FLAG_FRONTFACE_BIT_NV" );
	swigIntConstant( VK_INDIRECT_STATE_FLAG_BITS_MAX_ENUM_NV, "VK_INDIRECT_STATE_FLAG_BITS_MAX_ENUM_NV" );
	swigIntConstant( VK_INDIRECT_COMMANDS_LAYOUT_USAGE_EXPLICIT_PREPROCESS_BIT_NV, "VK_INDIRECT_COMMANDS_LAYOUT_USAGE_EXPLICIT_PREPROCESS_BIT_NV" );
	swigIntConstant( VK_INDIRECT_COMMANDS_LAYOUT_USAGE_INDEXED_SEQUENCES_BIT_NV, "VK_INDIRECT_COMMANDS_LAYOUT_USAGE_INDEXED_SEQUENCES_BIT_NV" );
	swigIntConstant( VK_INDIRECT_COMMANDS_LAYOUT_USAGE_UNORDERED_SEQUENCES_BIT_NV, "VK_INDIRECT_COMMANDS_LAYOUT_USAGE_UNORDERED_SEQUENCES_BIT_NV" );
	swigIntConstant( VK_INDIRECT_COMMANDS_LAYOUT_USAGE_FLAG_BITS_MAX_ENUM_NV, "VK_INDIRECT_COMMANDS_LAYOUT_USAGE_FLAG_BITS_MAX_ENUM_NV" );
	swigIntConstant( VK_DEVICE_MEMORY_REPORT_EVENT_TYPE_ALLOCATE_EXT, "VK_DEVICE_MEMORY_REPORT_EVENT_TYPE_ALLOCATE_EXT" );
	swigIntConstant( VK_DEVICE_MEMORY_REPORT_EVENT_TYPE_FREE_EXT, "VK_DEVICE_MEMORY_REPORT_EVENT_TYPE_FREE_EXT" );
	swigIntConstant( VK_DEVICE_MEMORY_REPORT_EVENT_TYPE_IMPORT_EXT, "VK_DEVICE_MEMORY_REPORT_EVENT_TYPE_IMPORT_EXT" );
	swigIntConstant( VK_DEVICE_MEMORY_REPORT_EVENT_TYPE_UNIMPORT_EXT, "VK_DEVICE_MEMORY_REPORT_EVENT_TYPE_UNIMPORT_EXT" );
	swigIntConstant( VK_DEVICE_MEMORY_REPORT_EVENT_TYPE_ALLOCATION_FAILED_EXT, "VK_DEVICE_MEMORY_REPORT_EVENT_TYPE_ALLOCATION_FAILED_EXT" );
	swigIntConstant( VK_DEVICE_MEMORY_REPORT_EVENT_TYPE_MAX_ENUM_EXT, "VK_DEVICE_MEMORY_REPORT_EVENT_TYPE_MAX_ENUM_EXT" );
	swigIntConstant( VK_PRIVATE_DATA_SLOT_CREATE_FLAG_BITS_MAX_ENUM_EXT, "VK_PRIVATE_DATA_SLOT_CREATE_FLAG_BITS_MAX_ENUM_EXT" );
	swigIntConstant( VK_DEVICE_DIAGNOSTICS_CONFIG_ENABLE_SHADER_DEBUG_INFO_BIT_NV, "VK_DEVICE_DIAGNOSTICS_CONFIG_ENABLE_SHADER_DEBUG_INFO_BIT_NV" );
	swigIntConstant( VK_DEVICE_DIAGNOSTICS_CONFIG_ENABLE_RESOURCE_TRACKING_BIT_NV, "VK_DEVICE_DIAGNOSTICS_CONFIG_ENABLE_RESOURCE_TRACKING_BIT_NV" );
	swigIntConstant( VK_DEVICE_DIAGNOSTICS_CONFIG_ENABLE_AUTOMATIC_CHECKPOINTS_BIT_NV, "VK_DEVICE_DIAGNOSTICS_CONFIG_ENABLE_AUTOMATIC_CHECKPOINTS_BIT_NV" );
	swigIntConstant( VK_DEVICE_DIAGNOSTICS_CONFIG_FLAG_BITS_MAX_ENUM_NV, "VK_DEVICE_DIAGNOSTICS_CONFIG_FLAG_BITS_MAX_ENUM_NV" );
	swigIntConstant( VK_FRAGMENT_SHADING_RATE_TYPE_FRAGMENT_SIZE_NV, "VK_FRAGMENT_SHADING_RATE_TYPE_FRAGMENT_SIZE_NV" );
	swigIntConstant( VK_FRAGMENT_SHADING_RATE_TYPE_ENUMS_NV, "VK_FRAGMENT_SHADING_RATE_TYPE_ENUMS_NV" );
	swigIntConstant( VK_FRAGMENT_SHADING_RATE_TYPE_MAX_ENUM_NV, "VK_FRAGMENT_SHADING_RATE_TYPE_MAX_ENUM_NV" );
	swigIntConstant( VK_FRAGMENT_SHADING_RATE_1_INVOCATION_PER_PIXEL_NV, "VK_FRAGMENT_SHADING_RATE_1_INVOCATION_PER_PIXEL_NV" );
	swigIntConstant( VK_FRAGMENT_SHADING_RATE_1_INVOCATION_PER_1X2_PIXELS_NV, "VK_FRAGMENT_SHADING_RATE_1_INVOCATION_PER_1X2_PIXELS_NV" );
	swigIntConstant( VK_FRAGMENT_SHADING_RATE_1_INVOCATION_PER_2X1_PIXELS_NV, "VK_FRAGMENT_SHADING_RATE_1_INVOCATION_PER_2X1_PIXELS_NV" );
	swigIntConstant( VK_FRAGMENT_SHADING_RATE_1_INVOCATION_PER_2X2_PIXELS_NV, "VK_FRAGMENT_SHADING_RATE_1_INVOCATION_PER_2X2_PIXELS_NV" );
	swigIntConstant( VK_FRAGMENT_SHADING_RATE_1_INVOCATION_PER_2X4_PIXELS_NV, "VK_FRAGMENT_SHADING_RATE_1_INVOCATION_PER_2X4_PIXELS_NV" );
	swigIntConstant( VK_FRAGMENT_SHADING_RATE_1_INVOCATION_PER_4X2_PIXELS_NV, "VK_FRAGMENT_SHADING_RATE_1_INVOCATION_PER_4X2_PIXELS_NV" );
	swigIntConstant( VK_FRAGMENT_SHADING_RATE_1_INVOCATION_PER_4X4_PIXELS_NV, "VK_FRAGMENT_SHADING_RATE_1_INVOCATION_PER_4X4_PIXELS_NV" );
	swigIntConstant( VK_FRAGMENT_SHADING_RATE_2_INVOCATIONS_PER_PIXEL_NV, "VK_FRAGMENT_SHADING_RATE_2_INVOCATIONS_PER_PIXEL_NV" );
	swigIntConstant( VK_FRAGMENT_SHADING_RATE_4_INVOCATIONS_PER_PIXEL_NV, "VK_FRAGMENT_SHADING_RATE_4_INVOCATIONS_PER_PIXEL_NV" );
	swigIntConstant( VK_FRAGMENT_SHADING_RATE_8_INVOCATIONS_PER_PIXEL_NV, "VK_FRAGMENT_SHADING_RATE_8_INVOCATIONS_PER_PIXEL_NV" );
	swigIntConstant( VK_FRAGMENT_SHADING_RATE_16_INVOCATIONS_PER_PIXEL_NV, "VK_FRAGMENT_SHADING_RATE_16_INVOCATIONS_PER_PIXEL_NV" );
	swigIntConstant( VK_FRAGMENT_SHADING_RATE_NO_INVOCATIONS_NV, "VK_FRAGMENT_SHADING_RATE_NO_INVOCATIONS_NV" );
	swigIntConstant( VK_FRAGMENT_SHADING_RATE_MAX_ENUM_NV, "VK_FRAGMENT_SHADING_RATE_MAX_ENUM_NV" );
	swigIntConstant( VK_ACCELERATION_STRUCTURE_MOTION_INSTANCE_TYPE_STATIC_NV, "VK_ACCELERATION_STRUCTURE_MOTION_INSTANCE_TYPE_STATIC_NV" );
	swigIntConstant( VK_ACCELERATION_STRUCTURE_MOTION_INSTANCE_TYPE_MATRIX_MOTION_NV, "VK_ACCELERATION_STRUCTURE_MOTION_INSTANCE_TYPE_MATRIX_MOTION_NV" );
	swigIntConstant( VK_ACCELERATION_STRUCTURE_MOTION_INSTANCE_TYPE_SRT_MOTION_NV, "VK_ACCELERATION_STRUCTURE_MOTION_INSTANCE_TYPE_SRT_MOTION_NV" );
	swigIntConstant( VK_ACCELERATION_STRUCTURE_MOTION_INSTANCE_TYPE_MAX_ENUM_NV, "VK_ACCELERATION_STRUCTURE_MOTION_INSTANCE_TYPE_MAX_ENUM_NV" );
	swigIntConstant( VK_BUILD_ACCELERATION_STRUCTURE_MODE_BUILD_KHR, "VK_BUILD_ACCELERATION_STRUCTURE_MODE_BUILD_KHR" );
	swigIntConstant( VK_BUILD_ACCELERATION_STRUCTURE_MODE_UPDATE_KHR, "VK_BUILD_ACCELERATION_STRUCTURE_MODE_UPDATE_KHR" );
	swigIntConstant( VK_BUILD_ACCELERATION_STRUCTURE_MODE_MAX_ENUM_KHR, "VK_BUILD_ACCELERATION_STRUCTURE_MODE_MAX_ENUM_KHR" );
	swigIntConstant( VK_ACCELERATION_STRUCTURE_BUILD_TYPE_HOST_KHR, "VK_ACCELERATION_STRUCTURE_BUILD_TYPE_HOST_KHR" );
	swigIntConstant( VK_ACCELERATION_STRUCTURE_BUILD_TYPE_DEVICE_KHR, "VK_ACCELERATION_STRUCTURE_BUILD_TYPE_DEVICE_KHR" );
	swigIntConstant( VK_ACCELERATION_STRUCTURE_BUILD_TYPE_HOST_OR_DEVICE_KHR, "VK_ACCELERATION_STRUCTURE_BUILD_TYPE_HOST_OR_DEVICE_KHR" );
	swigIntConstant( VK_ACCELERATION_STRUCTURE_BUILD_TYPE_MAX_ENUM_KHR, "VK_ACCELERATION_STRUCTURE_BUILD_TYPE_MAX_ENUM_KHR" );
	swigIntConstant( VK_ACCELERATION_STRUCTURE_COMPATIBILITY_COMPATIBLE_KHR, "VK_ACCELERATION_STRUCTURE_COMPATIBILITY_COMPATIBLE_KHR" );
	swigIntConstant( VK_ACCELERATION_STRUCTURE_COMPATIBILITY_INCOMPATIBLE_KHR, "VK_ACCELERATION_STRUCTURE_COMPATIBILITY_INCOMPATIBLE_KHR" );
	swigIntConstant( VK_ACCELERATION_STRUCTURE_COMPATIBILITY_MAX_ENUM_KHR, "VK_ACCELERATION_STRUCTURE_COMPATIBILITY_MAX_ENUM_KHR" );
	swigIntConstant( VK_ACCELERATION_STRUCTURE_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT_KHR, "VK_ACCELERATION_STRUCTURE_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT_KHR" );
	swigIntConstant( VK_ACCELERATION_STRUCTURE_CREATE_MOTION_BIT_NV, "VK_ACCELERATION_STRUCTURE_CREATE_MOTION_BIT_NV" );
	swigIntConstant( VK_ACCELERATION_STRUCTURE_CREATE_FLAG_BITS_MAX_ENUM_KHR, "VK_ACCELERATION_STRUCTURE_CREATE_FLAG_BITS_MAX_ENUM_KHR" );
	swigIntConstant( VK_SHADER_GROUP_SHADER_GENERAL_KHR, "VK_SHADER_GROUP_SHADER_GENERAL_KHR" );
	swigIntConstant( VK_SHADER_GROUP_SHADER_CLOSEST_HIT_KHR, "VK_SHADER_GROUP_SHADER_CLOSEST_HIT_KHR" );
	swigIntConstant( VK_SHADER_GROUP_SHADER_ANY_HIT_KHR, "VK_SHADER_GROUP_SHADER_ANY_HIT_KHR" );
	swigIntConstant( VK_SHADER_GROUP_SHADER_INTERSECTION_KHR, "VK_SHADER_GROUP_SHADER_INTERSECTION_KHR" );
	swigIntConstant( VK_SHADER_GROUP_SHADER_MAX_ENUM_KHR, "VK_SHADER_GROUP_SHADER_MAX_ENUM_KHR" );

	swigNewline();

	swigComment("-------===< structs >===--------\n");

	swigComment("struct VkExtent2D\n");
	printf( "begin-structure VkExtent2D\n" );
	swigStructField( "VkExtent2D-height", offsetof( struct VkExtent2D, height ), sizeof( uint32_t ) );
	swigStructField( "VkExtent2D-width", offsetof( struct VkExtent2D, width ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkExtent2D ) );

	swigComment("struct VkExtent3D\n");
	printf( "begin-structure VkExtent3D\n" );
	swigStructField( "VkExtent3D-height", offsetof( struct VkExtent3D, height ), sizeof( uint32_t ) );
	swigStructField( "VkExtent3D-width", offsetof( struct VkExtent3D, width ), sizeof( uint32_t ) );
	swigStructField( "VkExtent3D-depth", offsetof( struct VkExtent3D, depth ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkExtent3D ) );

	swigComment("struct VkOffset2D\n");
	printf( "begin-structure VkOffset2D\n" );
	swigStructField( "VkOffset2D-x", offsetof( struct VkOffset2D, x ), sizeof( int32_t ) );
	swigStructField( "VkOffset2D-y", offsetof( struct VkOffset2D, y ), sizeof( int32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkOffset2D ) );

	swigComment("struct VkOffset3D\n");
	printf( "begin-structure VkOffset3D\n" );
	swigStructField( "VkOffset3D-x", offsetof( struct VkOffset3D, x ), sizeof( int32_t ) );
	swigStructField( "VkOffset3D-y", offsetof( struct VkOffset3D, y ), sizeof( int32_t ) );
	swigStructField( "VkOffset3D-z", offsetof( struct VkOffset3D, z ), sizeof( int32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkOffset3D ) );

	swigComment("struct VkRect2D\n");
	printf( "begin-structure VkRect2D\n" );
	swigStructField( "VkRect2D-extent", offsetof( struct VkRect2D, extent ), sizeof( VkExtent2D ) );
	swigStructField( "VkRect2D-offset", offsetof( struct VkRect2D, offset ), sizeof( VkOffset2D ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkRect2D ) );

	swigComment("struct VkBaseInStructure\n");
	printf( "begin-structure VkBaseInStructure\n" );
	swigStructField( "VkBaseInStructure-pNext", offsetof( struct VkBaseInStructure, pNext ), sizeof( struct VkBaseInStructure const * ) );
	swigStructField( "VkBaseInStructure-sType", offsetof( struct VkBaseInStructure, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkBaseInStructure ) );

	swigComment("struct VkBaseOutStructure\n");
	printf( "begin-structure VkBaseOutStructure\n" );
	swigStructField( "VkBaseOutStructure-pNext", offsetof( struct VkBaseOutStructure, pNext ), sizeof( struct VkBaseOutStructure * ) );
	swigStructField( "VkBaseOutStructure-sType", offsetof( struct VkBaseOutStructure, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkBaseOutStructure ) );

	swigComment("struct VkBufferMemoryBarrier\n");
	printf( "begin-structure VkBufferMemoryBarrier\n" );
	swigStructField( "VkBufferMemoryBarrier-pNext", offsetof( struct VkBufferMemoryBarrier, pNext ), sizeof( void const * ) );
	swigStructField( "VkBufferMemoryBarrier-srcQueueFamilyIndex", offsetof( struct VkBufferMemoryBarrier, srcQueueFamilyIndex ), sizeof( uint32_t ) );
	swigStructField( "VkBufferMemoryBarrier-dstQueueFamilyIndex", offsetof( struct VkBufferMemoryBarrier, dstQueueFamilyIndex ), sizeof( uint32_t ) );
	swigStructField( "VkBufferMemoryBarrier-buffer", offsetof( struct VkBufferMemoryBarrier, buffer ), sizeof( VkBuffer ) );
	swigStructField( "VkBufferMemoryBarrier-offset", offsetof( struct VkBufferMemoryBarrier, offset ), sizeof( VkDeviceSize ) );
	swigStructField( "VkBufferMemoryBarrier-size", offsetof( struct VkBufferMemoryBarrier, size ), sizeof( VkDeviceSize ) );
	swigStructField( "VkBufferMemoryBarrier-sType", offsetof( struct VkBufferMemoryBarrier, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkBufferMemoryBarrier-srcAccessMask", offsetof( struct VkBufferMemoryBarrier, srcAccessMask ), sizeof( VkAccessFlags ) );
	swigStructField( "VkBufferMemoryBarrier-dstAccessMask", offsetof( struct VkBufferMemoryBarrier, dstAccessMask ), sizeof( VkAccessFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkBufferMemoryBarrier ) );

	swigComment("struct VkDispatchIndirectCommand\n");
	printf( "begin-structure VkDispatchIndirectCommand\n" );
	swigStructField( "VkDispatchIndirectCommand-x", offsetof( struct VkDispatchIndirectCommand, x ), sizeof( uint32_t ) );
	swigStructField( "VkDispatchIndirectCommand-y", offsetof( struct VkDispatchIndirectCommand, y ), sizeof( uint32_t ) );
	swigStructField( "VkDispatchIndirectCommand-z", offsetof( struct VkDispatchIndirectCommand, z ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDispatchIndirectCommand ) );

	swigComment("struct VkDrawIndexedIndirectCommand\n");
	printf( "begin-structure VkDrawIndexedIndirectCommand\n" );
	swigStructField( "VkDrawIndexedIndirectCommand-firstInstance", offsetof( struct VkDrawIndexedIndirectCommand, firstInstance ), sizeof( uint32_t ) );
	swigStructField( "VkDrawIndexedIndirectCommand-vertexOffset", offsetof( struct VkDrawIndexedIndirectCommand, vertexOffset ), sizeof( int32_t ) );
	swigStructField( "VkDrawIndexedIndirectCommand-instanceCount", offsetof( struct VkDrawIndexedIndirectCommand, instanceCount ), sizeof( uint32_t ) );
	swigStructField( "VkDrawIndexedIndirectCommand-firstIndex", offsetof( struct VkDrawIndexedIndirectCommand, firstIndex ), sizeof( uint32_t ) );
	swigStructField( "VkDrawIndexedIndirectCommand-indexCount", offsetof( struct VkDrawIndexedIndirectCommand, indexCount ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDrawIndexedIndirectCommand ) );

	swigComment("struct VkDrawIndirectCommand\n");
	printf( "begin-structure VkDrawIndirectCommand\n" );
	swigStructField( "VkDrawIndirectCommand-firstInstance", offsetof( struct VkDrawIndirectCommand, firstInstance ), sizeof( uint32_t ) );
	swigStructField( "VkDrawIndirectCommand-firstVertex", offsetof( struct VkDrawIndirectCommand, firstVertex ), sizeof( uint32_t ) );
	swigStructField( "VkDrawIndirectCommand-instanceCount", offsetof( struct VkDrawIndirectCommand, instanceCount ), sizeof( uint32_t ) );
	swigStructField( "VkDrawIndirectCommand-vertexCount", offsetof( struct VkDrawIndirectCommand, vertexCount ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDrawIndirectCommand ) );

	swigComment("struct VkImageSubresourceRange\n");
	printf( "begin-structure VkImageSubresourceRange\n" );
	swigStructField( "VkImageSubresourceRange-baseArrayLayer", offsetof( struct VkImageSubresourceRange, baseArrayLayer ), sizeof( uint32_t ) );
	swigStructField( "VkImageSubresourceRange-layerCount", offsetof( struct VkImageSubresourceRange, layerCount ), sizeof( uint32_t ) );
	swigStructField( "VkImageSubresourceRange-baseMipLevel", offsetof( struct VkImageSubresourceRange, baseMipLevel ), sizeof( uint32_t ) );
	swigStructField( "VkImageSubresourceRange-levelCount", offsetof( struct VkImageSubresourceRange, levelCount ), sizeof( uint32_t ) );
	swigStructField( "VkImageSubresourceRange-aspectMask", offsetof( struct VkImageSubresourceRange, aspectMask ), sizeof( VkImageAspectFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkImageSubresourceRange ) );

	swigComment("struct VkImageMemoryBarrier\n");
	printf( "begin-structure VkImageMemoryBarrier\n" );
	swigStructField( "VkImageMemoryBarrier-pNext", offsetof( struct VkImageMemoryBarrier, pNext ), sizeof( void const * ) );
	swigStructField( "VkImageMemoryBarrier-srcQueueFamilyIndex", offsetof( struct VkImageMemoryBarrier, srcQueueFamilyIndex ), sizeof( uint32_t ) );
	swigStructField( "VkImageMemoryBarrier-dstQueueFamilyIndex", offsetof( struct VkImageMemoryBarrier, dstQueueFamilyIndex ), sizeof( uint32_t ) );
	swigStructField( "VkImageMemoryBarrier-oldLayout", offsetof( struct VkImageMemoryBarrier, oldLayout ), sizeof( VkImageLayout ) );
	swigStructField( "VkImageMemoryBarrier-newLayout", offsetof( struct VkImageMemoryBarrier, newLayout ), sizeof( VkImageLayout ) );
	swigStructField( "VkImageMemoryBarrier-image", offsetof( struct VkImageMemoryBarrier, image ), sizeof( VkImage ) );
	swigStructField( "VkImageMemoryBarrier-sType", offsetof( struct VkImageMemoryBarrier, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkImageMemoryBarrier-srcAccessMask", offsetof( struct VkImageMemoryBarrier, srcAccessMask ), sizeof( VkAccessFlags ) );
	swigStructField( "VkImageMemoryBarrier-dstAccessMask", offsetof( struct VkImageMemoryBarrier, dstAccessMask ), sizeof( VkAccessFlags ) );
	swigStructField( "VkImageMemoryBarrier-subresourceRange", offsetof( struct VkImageMemoryBarrier, subresourceRange ), sizeof( VkImageSubresourceRange ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkImageMemoryBarrier ) );

	swigComment("struct VkMemoryBarrier\n");
	printf( "begin-structure VkMemoryBarrier\n" );
	swigStructField( "VkMemoryBarrier-pNext", offsetof( struct VkMemoryBarrier, pNext ), sizeof( void const * ) );
	swigStructField( "VkMemoryBarrier-sType", offsetof( struct VkMemoryBarrier, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkMemoryBarrier-srcAccessMask", offsetof( struct VkMemoryBarrier, srcAccessMask ), sizeof( VkAccessFlags ) );
	swigStructField( "VkMemoryBarrier-dstAccessMask", offsetof( struct VkMemoryBarrier, dstAccessMask ), sizeof( VkAccessFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkMemoryBarrier ) );

	swigComment("struct VkPipelineCacheHeaderVersionOne\n");
	printf( "begin-structure VkPipelineCacheHeaderVersionOne\n" );
	swigStructField( "VkPipelineCacheHeaderVersionOne-vendorID", offsetof( struct VkPipelineCacheHeaderVersionOne, vendorID ), sizeof( uint32_t ) );
	swigStructField( "VkPipelineCacheHeaderVersionOne-headerVersion", offsetof( struct VkPipelineCacheHeaderVersionOne, headerVersion ), sizeof( VkPipelineCacheHeaderVersion ) );
	swigStructField( "VkPipelineCacheHeaderVersionOne-headerSize", offsetof( struct VkPipelineCacheHeaderVersionOne, headerSize ), sizeof( uint32_t ) );
	swigStructField( "VkPipelineCacheHeaderVersionOne-deviceID", offsetof( struct VkPipelineCacheHeaderVersionOne, deviceID ), sizeof( uint32_t ) );
	swigStructField( "VkPipelineCacheHeaderVersionOne-pipelineCacheUUID", offsetof( struct VkPipelineCacheHeaderVersionOne, pipelineCacheUUID ), sizeof( uint8_t [16U] ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineCacheHeaderVersionOne ) );

	swigComment("struct VkAllocationCallbacks\n");
	printf( "begin-structure VkAllocationCallbacks\n" );
	swigStructField( "VkAllocationCallbacks-pfnAllocation", offsetof( struct VkAllocationCallbacks, pfnAllocation ), sizeof( PFN_vkAllocationFunction ) );
	swigStructField( "VkAllocationCallbacks-pfnReallocation", offsetof( struct VkAllocationCallbacks, pfnReallocation ), sizeof( PFN_vkReallocationFunction ) );
	swigStructField( "VkAllocationCallbacks-pfnInternalAllocation", offsetof( struct VkAllocationCallbacks, pfnInternalAllocation ), sizeof( PFN_vkInternalAllocationNotification ) );
	swigStructField( "VkAllocationCallbacks-pUserData", offsetof( struct VkAllocationCallbacks, pUserData ), sizeof( void * ) );
	swigStructField( "VkAllocationCallbacks-pfnFree", offsetof( struct VkAllocationCallbacks, pfnFree ), sizeof( PFN_vkFreeFunction ) );
	swigStructField( "VkAllocationCallbacks-pfnInternalFree", offsetof( struct VkAllocationCallbacks, pfnInternalFree ), sizeof( PFN_vkInternalFreeNotification ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkAllocationCallbacks ) );

	swigComment("struct VkApplicationInfo\n");
	printf( "begin-structure VkApplicationInfo\n" );
	swigStructField( "VkApplicationInfo-pNext", offsetof( struct VkApplicationInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkApplicationInfo-applicationVersion", offsetof( struct VkApplicationInfo, applicationVersion ), sizeof( uint32_t ) );
	swigStructField( "VkApplicationInfo-pEngineName", offsetof( struct VkApplicationInfo, pEngineName ), sizeof( char const * ) );
	swigStructField( "VkApplicationInfo-engineVersion", offsetof( struct VkApplicationInfo, engineVersion ), sizeof( uint32_t ) );
	swigStructField( "VkApplicationInfo-apiVersion", offsetof( struct VkApplicationInfo, apiVersion ), sizeof( uint32_t ) );
	swigStructField( "VkApplicationInfo-sType", offsetof( struct VkApplicationInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkApplicationInfo-pApplicationName", offsetof( struct VkApplicationInfo, pApplicationName ), sizeof( char const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkApplicationInfo ) );

	swigComment("struct VkFormatProperties\n");
	printf( "begin-structure VkFormatProperties\n" );
	swigStructField( "VkFormatProperties-linearTilingFeatures", offsetof( struct VkFormatProperties, linearTilingFeatures ), sizeof( VkFormatFeatureFlags ) );
	swigStructField( "VkFormatProperties-optimalTilingFeatures", offsetof( struct VkFormatProperties, optimalTilingFeatures ), sizeof( VkFormatFeatureFlags ) );
	swigStructField( "VkFormatProperties-bufferFeatures", offsetof( struct VkFormatProperties, bufferFeatures ), sizeof( VkFormatFeatureFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkFormatProperties ) );

	swigComment("struct VkImageFormatProperties\n");
	printf( "begin-structure VkImageFormatProperties\n" );
	swigStructField( "VkImageFormatProperties-maxMipLevels", offsetof( struct VkImageFormatProperties, maxMipLevels ), sizeof( uint32_t ) );
	swigStructField( "VkImageFormatProperties-sampleCounts", offsetof( struct VkImageFormatProperties, sampleCounts ), sizeof( VkSampleCountFlags ) );
	swigStructField( "VkImageFormatProperties-maxArrayLayers", offsetof( struct VkImageFormatProperties, maxArrayLayers ), sizeof( uint32_t ) );
	swigStructField( "VkImageFormatProperties-maxResourceSize", offsetof( struct VkImageFormatProperties, maxResourceSize ), sizeof( VkDeviceSize ) );
	swigStructField( "VkImageFormatProperties-maxExtent", offsetof( struct VkImageFormatProperties, maxExtent ), sizeof( VkExtent3D ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkImageFormatProperties ) );

	swigComment("struct VkInstanceCreateInfo\n");
	printf( "begin-structure VkInstanceCreateInfo\n" );
	swigStructField( "VkInstanceCreateInfo-enabledExtensionCount", offsetof( struct VkInstanceCreateInfo, enabledExtensionCount ), sizeof( uint32_t ) );
	swigStructField( "VkInstanceCreateInfo-pNext", offsetof( struct VkInstanceCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkInstanceCreateInfo-pApplicationInfo", offsetof( struct VkInstanceCreateInfo, pApplicationInfo ), sizeof( VkApplicationInfo const * ) );
	swigStructField( "VkInstanceCreateInfo-enabledLayerCount", offsetof( struct VkInstanceCreateInfo, enabledLayerCount ), sizeof( uint32_t ) );
	swigStructField( "VkInstanceCreateInfo-sType", offsetof( struct VkInstanceCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkInstanceCreateInfo-flags", offsetof( struct VkInstanceCreateInfo, flags ), sizeof( VkInstanceCreateFlags ) );
	swigStructField( "VkInstanceCreateInfo-ppEnabledExtensionNames", offsetof( struct VkInstanceCreateInfo, ppEnabledExtensionNames ), sizeof( char const *const * ) );
	swigStructField( "VkInstanceCreateInfo-ppEnabledLayerNames", offsetof( struct VkInstanceCreateInfo, ppEnabledLayerNames ), sizeof( char const *const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkInstanceCreateInfo ) );

	swigComment("struct VkMemoryHeap\n");
	printf( "begin-structure VkMemoryHeap\n" );
	swigStructField( "VkMemoryHeap-size", offsetof( struct VkMemoryHeap, size ), sizeof( VkDeviceSize ) );
	swigStructField( "VkMemoryHeap-flags", offsetof( struct VkMemoryHeap, flags ), sizeof( VkMemoryHeapFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkMemoryHeap ) );

	swigComment("struct VkMemoryType\n");
	printf( "begin-structure VkMemoryType\n" );
	swigStructField( "VkMemoryType-heapIndex", offsetof( struct VkMemoryType, heapIndex ), sizeof( uint32_t ) );
	swigStructField( "VkMemoryType-propertyFlags", offsetof( struct VkMemoryType, propertyFlags ), sizeof( VkMemoryPropertyFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkMemoryType ) );

	swigComment("struct VkPhysicalDeviceFeatures\n");
	printf( "begin-structure VkPhysicalDeviceFeatures\n" );
	swigStructField( "VkPhysicalDeviceFeatures-drawIndirectFirstInstance", offsetof( struct VkPhysicalDeviceFeatures, drawIndirectFirstInstance ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-shaderUniformBufferArrayDynamicIndexing", offsetof( struct VkPhysicalDeviceFeatures, shaderUniformBufferArrayDynamicIndexing ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-alphaToOne", offsetof( struct VkPhysicalDeviceFeatures, alphaToOne ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-dualSrcBlend", offsetof( struct VkPhysicalDeviceFeatures, dualSrcBlend ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-depthBiasClamp", offsetof( struct VkPhysicalDeviceFeatures, depthBiasClamp ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-shaderSampledImageArrayDynamicIndexing", offsetof( struct VkPhysicalDeviceFeatures, shaderSampledImageArrayDynamicIndexing ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-shaderStorageBufferArrayDynamicIndexing", offsetof( struct VkPhysicalDeviceFeatures, shaderStorageBufferArrayDynamicIndexing ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-shaderStorageImageArrayDynamicIndexing", offsetof( struct VkPhysicalDeviceFeatures, shaderStorageImageArrayDynamicIndexing ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-imageCubeArray", offsetof( struct VkPhysicalDeviceFeatures, imageCubeArray ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-shaderResourceResidency", offsetof( struct VkPhysicalDeviceFeatures, shaderResourceResidency ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-fillModeNonSolid", offsetof( struct VkPhysicalDeviceFeatures, fillModeNonSolid ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-textureCompressionBC", offsetof( struct VkPhysicalDeviceFeatures, textureCompressionBC ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-textureCompressionETC2", offsetof( struct VkPhysicalDeviceFeatures, textureCompressionETC2 ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-shaderImageGatherExtended", offsetof( struct VkPhysicalDeviceFeatures, shaderImageGatherExtended ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-robustBufferAccess", offsetof( struct VkPhysicalDeviceFeatures, robustBufferAccess ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-multiViewport", offsetof( struct VkPhysicalDeviceFeatures, multiViewport ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-independentBlend", offsetof( struct VkPhysicalDeviceFeatures, independentBlend ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-sparseResidencyAliased", offsetof( struct VkPhysicalDeviceFeatures, sparseResidencyAliased ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-fullDrawIndexUint32", offsetof( struct VkPhysicalDeviceFeatures, fullDrawIndexUint32 ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-fragmentStoresAndAtomics", offsetof( struct VkPhysicalDeviceFeatures, fragmentStoresAndAtomics ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-vertexPipelineStoresAndAtomics", offsetof( struct VkPhysicalDeviceFeatures, vertexPipelineStoresAndAtomics ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-textureCompressionASTC_LDR", offsetof( struct VkPhysicalDeviceFeatures, textureCompressionASTC_LDR ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-sparseBinding", offsetof( struct VkPhysicalDeviceFeatures, sparseBinding ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-tessellationShader", offsetof( struct VkPhysicalDeviceFeatures, tessellationShader ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-pipelineStatisticsQuery", offsetof( struct VkPhysicalDeviceFeatures, pipelineStatisticsQuery ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-shaderStorageImageMultisample", offsetof( struct VkPhysicalDeviceFeatures, shaderStorageImageMultisample ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-depthClamp", offsetof( struct VkPhysicalDeviceFeatures, depthClamp ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-shaderResourceMinLod", offsetof( struct VkPhysicalDeviceFeatures, shaderResourceMinLod ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-shaderInt16", offsetof( struct VkPhysicalDeviceFeatures, shaderInt16 ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-variableMultisampleRate", offsetof( struct VkPhysicalDeviceFeatures, variableMultisampleRate ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-sparseResidencyBuffer", offsetof( struct VkPhysicalDeviceFeatures, sparseResidencyBuffer ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-samplerAnisotropy", offsetof( struct VkPhysicalDeviceFeatures, samplerAnisotropy ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-shaderFloat64", offsetof( struct VkPhysicalDeviceFeatures, shaderFloat64 ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-geometryShader", offsetof( struct VkPhysicalDeviceFeatures, geometryShader ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-shaderClipDistance", offsetof( struct VkPhysicalDeviceFeatures, shaderClipDistance ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-shaderCullDistance", offsetof( struct VkPhysicalDeviceFeatures, shaderCullDistance ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-shaderInt64", offsetof( struct VkPhysicalDeviceFeatures, shaderInt64 ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-inheritedQueries", offsetof( struct VkPhysicalDeviceFeatures, inheritedQueries ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-depthBounds", offsetof( struct VkPhysicalDeviceFeatures, depthBounds ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-sparseResidencyImage3D", offsetof( struct VkPhysicalDeviceFeatures, sparseResidencyImage3D ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-logicOp", offsetof( struct VkPhysicalDeviceFeatures, logicOp ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-shaderStorageImageWriteWithoutFormat", offsetof( struct VkPhysicalDeviceFeatures, shaderStorageImageWriteWithoutFormat ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-shaderStorageImageReadWithoutFormat", offsetof( struct VkPhysicalDeviceFeatures, shaderStorageImageReadWithoutFormat ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-occlusionQueryPrecise", offsetof( struct VkPhysicalDeviceFeatures, occlusionQueryPrecise ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-shaderStorageImageExtendedFormats", offsetof( struct VkPhysicalDeviceFeatures, shaderStorageImageExtendedFormats ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-shaderTessellationAndGeometryPointSize", offsetof( struct VkPhysicalDeviceFeatures, shaderTessellationAndGeometryPointSize ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-sparseResidency2Samples", offsetof( struct VkPhysicalDeviceFeatures, sparseResidency2Samples ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-sparseResidency4Samples", offsetof( struct VkPhysicalDeviceFeatures, sparseResidency4Samples ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-sparseResidency8Samples", offsetof( struct VkPhysicalDeviceFeatures, sparseResidency8Samples ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-sparseResidency16Samples", offsetof( struct VkPhysicalDeviceFeatures, sparseResidency16Samples ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-wideLines", offsetof( struct VkPhysicalDeviceFeatures, wideLines ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-sampleRateShading", offsetof( struct VkPhysicalDeviceFeatures, sampleRateShading ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-sparseResidencyImage2D", offsetof( struct VkPhysicalDeviceFeatures, sparseResidencyImage2D ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-largePoints", offsetof( struct VkPhysicalDeviceFeatures, largePoints ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-multiDrawIndirect", offsetof( struct VkPhysicalDeviceFeatures, multiDrawIndirect ), sizeof( VkBool32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceFeatures ) );

	swigComment("struct VkPhysicalDeviceLimits\n");
	printf( "begin-structure VkPhysicalDeviceLimits\n" );
	swigStructField( "VkPhysicalDeviceLimits-discreteQueuePriorities", offsetof( struct VkPhysicalDeviceLimits, discreteQueuePriorities ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxVertexInputAttributeOffset", offsetof( struct VkPhysicalDeviceLimits, maxVertexInputAttributeOffset ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxSamplerAnisotropy", offsetof( struct VkPhysicalDeviceLimits, maxSamplerAnisotropy ), sizeof( float ) );
	swigStructField( "VkPhysicalDeviceLimits-maxComputeWorkGroupInvocations", offsetof( struct VkPhysicalDeviceLimits, maxComputeWorkGroupInvocations ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxGeometryShaderInvocations", offsetof( struct VkPhysicalDeviceLimits, maxGeometryShaderInvocations ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-standardSampleLocations", offsetof( struct VkPhysicalDeviceLimits, standardSampleLocations ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceLimits-maxBoundDescriptorSets", offsetof( struct VkPhysicalDeviceLimits, maxBoundDescriptorSets ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxFragmentCombinedOutputResources", offsetof( struct VkPhysicalDeviceLimits, maxFragmentCombinedOutputResources ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxPerStageResources", offsetof( struct VkPhysicalDeviceLimits, maxPerStageResources ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxDescriptorSetUniformBuffersDynamic", offsetof( struct VkPhysicalDeviceLimits, maxDescriptorSetUniformBuffersDynamic ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxDescriptorSetStorageBuffersDynamic", offsetof( struct VkPhysicalDeviceLimits, maxDescriptorSetStorageBuffersDynamic ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxFragmentDualSrcAttachments", offsetof( struct VkPhysicalDeviceLimits, maxFragmentDualSrcAttachments ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxFragmentOutputAttachments", offsetof( struct VkPhysicalDeviceLimits, maxFragmentOutputAttachments ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxPerStageDescriptorInputAttachments", offsetof( struct VkPhysicalDeviceLimits, maxPerStageDescriptorInputAttachments ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxDescriptorSetInputAttachments", offsetof( struct VkPhysicalDeviceLimits, maxDescriptorSetInputAttachments ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxColorAttachments", offsetof( struct VkPhysicalDeviceLimits, maxColorAttachments ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-lineWidthRange", offsetof( struct VkPhysicalDeviceLimits, lineWidthRange ), sizeof( float [2] ) );
	swigStructField( "VkPhysicalDeviceLimits-maxComputeWorkGroupSize", offsetof( struct VkPhysicalDeviceLimits, maxComputeWorkGroupSize ), sizeof( uint32_t [3] ) );
	swigStructField( "VkPhysicalDeviceLimits-strictLines", offsetof( struct VkPhysicalDeviceLimits, strictLines ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceLimits-pointSizeRange", offsetof( struct VkPhysicalDeviceLimits, pointSizeRange ), sizeof( float [2] ) );
	swigStructField( "VkPhysicalDeviceLimits-maxImageArrayLayers", offsetof( struct VkPhysicalDeviceLimits, maxImageArrayLayers ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-viewportBoundsRange", offsetof( struct VkPhysicalDeviceLimits, viewportBoundsRange ), sizeof( float [2] ) );
	swigStructField( "VkPhysicalDeviceLimits-maxDrawIndirectCount", offsetof( struct VkPhysicalDeviceLimits, maxDrawIndirectCount ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxComputeSharedMemorySize", offsetof( struct VkPhysicalDeviceLimits, maxComputeSharedMemorySize ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-timestampComputeAndGraphics", offsetof( struct VkPhysicalDeviceLimits, timestampComputeAndGraphics ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceLimits-maxSamplerLodBias", offsetof( struct VkPhysicalDeviceLimits, maxSamplerLodBias ), sizeof( float ) );
	swigStructField( "VkPhysicalDeviceLimits-sparseAddressSpaceSize", offsetof( struct VkPhysicalDeviceLimits, sparseAddressSpaceSize ), sizeof( VkDeviceSize ) );
	swigStructField( "VkPhysicalDeviceLimits-maxTessellationPatchSize", offsetof( struct VkPhysicalDeviceLimits, maxTessellationPatchSize ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxImageDimensionCube", offsetof( struct VkPhysicalDeviceLimits, maxImageDimensionCube ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-framebufferColorSampleCounts", offsetof( struct VkPhysicalDeviceLimits, framebufferColorSampleCounts ), sizeof( VkSampleCountFlags ) );
	swigStructField( "VkPhysicalDeviceLimits-framebufferDepthSampleCounts", offsetof( struct VkPhysicalDeviceLimits, framebufferDepthSampleCounts ), sizeof( VkSampleCountFlags ) );
	swigStructField( "VkPhysicalDeviceLimits-framebufferStencilSampleCounts", offsetof( struct VkPhysicalDeviceLimits, framebufferStencilSampleCounts ), sizeof( VkSampleCountFlags ) );
	swigStructField( "VkPhysicalDeviceLimits-framebufferNoAttachmentsSampleCounts", offsetof( struct VkPhysicalDeviceLimits, framebufferNoAttachmentsSampleCounts ), sizeof( VkSampleCountFlags ) );
	swigStructField( "VkPhysicalDeviceLimits-sampledImageColorSampleCounts", offsetof( struct VkPhysicalDeviceLimits, sampledImageColorSampleCounts ), sizeof( VkSampleCountFlags ) );
	swigStructField( "VkPhysicalDeviceLimits-sampledImageIntegerSampleCounts", offsetof( struct VkPhysicalDeviceLimits, sampledImageIntegerSampleCounts ), sizeof( VkSampleCountFlags ) );
	swigStructField( "VkPhysicalDeviceLimits-sampledImageDepthSampleCounts", offsetof( struct VkPhysicalDeviceLimits, sampledImageDepthSampleCounts ), sizeof( VkSampleCountFlags ) );
	swigStructField( "VkPhysicalDeviceLimits-sampledImageStencilSampleCounts", offsetof( struct VkPhysicalDeviceLimits, sampledImageStencilSampleCounts ), sizeof( VkSampleCountFlags ) );
	swigStructField( "VkPhysicalDeviceLimits-storageImageSampleCounts", offsetof( struct VkPhysicalDeviceLimits, storageImageSampleCounts ), sizeof( VkSampleCountFlags ) );
	swigStructField( "VkPhysicalDeviceLimits-maxViewportDimensions", offsetof( struct VkPhysicalDeviceLimits, maxViewportDimensions ), sizeof( uint32_t [2] ) );
	swigStructField( "VkPhysicalDeviceLimits-maxImageDimension3D", offsetof( struct VkPhysicalDeviceLimits, maxImageDimension3D ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxTexelGatherOffset", offsetof( struct VkPhysicalDeviceLimits, maxTexelGatherOffset ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-minTexelGatherOffset", offsetof( struct VkPhysicalDeviceLimits, minTexelGatherOffset ), sizeof( int32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxTexelOffset", offsetof( struct VkPhysicalDeviceLimits, maxTexelOffset ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-minTexelOffset", offsetof( struct VkPhysicalDeviceLimits, minTexelOffset ), sizeof( int32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxSamplerAllocationCount", offsetof( struct VkPhysicalDeviceLimits, maxSamplerAllocationCount ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxMemoryAllocationCount", offsetof( struct VkPhysicalDeviceLimits, maxMemoryAllocationCount ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-minInterpolationOffset", offsetof( struct VkPhysicalDeviceLimits, minInterpolationOffset ), sizeof( float ) );
	swigStructField( "VkPhysicalDeviceLimits-maxInterpolationOffset", offsetof( struct VkPhysicalDeviceLimits, maxInterpolationOffset ), sizeof( float ) );
	swigStructField( "VkPhysicalDeviceLimits-maxFragmentInputComponents", offsetof( struct VkPhysicalDeviceLimits, maxFragmentInputComponents ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxGeometryTotalOutputComponents", offsetof( struct VkPhysicalDeviceLimits, maxGeometryTotalOutputComponents ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxGeometryOutputComponents", offsetof( struct VkPhysicalDeviceLimits, maxGeometryOutputComponents ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxGeometryInputComponents", offsetof( struct VkPhysicalDeviceLimits, maxGeometryInputComponents ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxTessellationEvaluationOutputComponents", offsetof( struct VkPhysicalDeviceLimits, maxTessellationEvaluationOutputComponents ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxTessellationEvaluationInputComponents", offsetof( struct VkPhysicalDeviceLimits, maxTessellationEvaluationInputComponents ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxTessellationControlTotalOutputComponents", offsetof( struct VkPhysicalDeviceLimits, maxTessellationControlTotalOutputComponents ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxTessellationControlPerPatchOutputComponents", offsetof( struct VkPhysicalDeviceLimits, maxTessellationControlPerPatchOutputComponents ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxTessellationControlPerVertexOutputComponents", offsetof( struct VkPhysicalDeviceLimits, maxTessellationControlPerVertexOutputComponents ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxTessellationControlPerVertexInputComponents", offsetof( struct VkPhysicalDeviceLimits, maxTessellationControlPerVertexInputComponents ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxVertexInputBindingStride", offsetof( struct VkPhysicalDeviceLimits, maxVertexInputBindingStride ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxVertexOutputComponents", offsetof( struct VkPhysicalDeviceLimits, maxVertexOutputComponents ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxVertexInputAttributes", offsetof( struct VkPhysicalDeviceLimits, maxVertexInputAttributes ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-viewportSubPixelBits", offsetof( struct VkPhysicalDeviceLimits, viewportSubPixelBits ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxFramebufferWidth", offsetof( struct VkPhysicalDeviceLimits, maxFramebufferWidth ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxPerStageDescriptorStorageImages", offsetof( struct VkPhysicalDeviceLimits, maxPerStageDescriptorStorageImages ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxDescriptorSetStorageImages", offsetof( struct VkPhysicalDeviceLimits, maxDescriptorSetStorageImages ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-mipmapPrecisionBits", offsetof( struct VkPhysicalDeviceLimits, mipmapPrecisionBits ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-subTexelPrecisionBits", offsetof( struct VkPhysicalDeviceLimits, subTexelPrecisionBits ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-subPixelPrecisionBits", offsetof( struct VkPhysicalDeviceLimits, subPixelPrecisionBits ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxPushConstantsSize", offsetof( struct VkPhysicalDeviceLimits, maxPushConstantsSize ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxImageDimension1D", offsetof( struct VkPhysicalDeviceLimits, maxImageDimension1D ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-timestampPeriod", offsetof( struct VkPhysicalDeviceLimits, timestampPeriod ), sizeof( float ) );
	swigStructField( "VkPhysicalDeviceLimits-maxFramebufferLayers", offsetof( struct VkPhysicalDeviceLimits, maxFramebufferLayers ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-nonCoherentAtomSize", offsetof( struct VkPhysicalDeviceLimits, nonCoherentAtomSize ), sizeof( VkDeviceSize ) );
	swigStructField( "VkPhysicalDeviceLimits-maxComputeWorkGroupCount", offsetof( struct VkPhysicalDeviceLimits, maxComputeWorkGroupCount ), sizeof( uint32_t [3] ) );
	swigStructField( "VkPhysicalDeviceLimits-maxPerStageDescriptorUniformBuffers", offsetof( struct VkPhysicalDeviceLimits, maxPerStageDescriptorUniformBuffers ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxPerStageDescriptorStorageBuffers", offsetof( struct VkPhysicalDeviceLimits, maxPerStageDescriptorStorageBuffers ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxDescriptorSetUniformBuffers", offsetof( struct VkPhysicalDeviceLimits, maxDescriptorSetUniformBuffers ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxDescriptorSetStorageBuffers", offsetof( struct VkPhysicalDeviceLimits, maxDescriptorSetStorageBuffers ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-subPixelInterpolationOffsetBits", offsetof( struct VkPhysicalDeviceLimits, subPixelInterpolationOffsetBits ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxPerStageDescriptorSamplers", offsetof( struct VkPhysicalDeviceLimits, maxPerStageDescriptorSamplers ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxDescriptorSetSamplers", offsetof( struct VkPhysicalDeviceLimits, maxDescriptorSetSamplers ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxTessellationGenerationLevel", offsetof( struct VkPhysicalDeviceLimits, maxTessellationGenerationLevel ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxFramebufferHeight", offsetof( struct VkPhysicalDeviceLimits, maxFramebufferHeight ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxSampleMaskWords", offsetof( struct VkPhysicalDeviceLimits, maxSampleMaskWords ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-minStorageBufferOffsetAlignment", offsetof( struct VkPhysicalDeviceLimits, minStorageBufferOffsetAlignment ), sizeof( VkDeviceSize ) );
	swigStructField( "VkPhysicalDeviceLimits-minUniformBufferOffsetAlignment", offsetof( struct VkPhysicalDeviceLimits, minUniformBufferOffsetAlignment ), sizeof( VkDeviceSize ) );
	swigStructField( "VkPhysicalDeviceLimits-minTexelBufferOffsetAlignment", offsetof( struct VkPhysicalDeviceLimits, minTexelBufferOffsetAlignment ), sizeof( VkDeviceSize ) );
	swigStructField( "VkPhysicalDeviceLimits-minMemoryMapAlignment", offsetof( struct VkPhysicalDeviceLimits, minMemoryMapAlignment ), sizeof( size_t ) );
	swigStructField( "VkPhysicalDeviceLimits-optimalBufferCopyOffsetAlignment", offsetof( struct VkPhysicalDeviceLimits, optimalBufferCopyOffsetAlignment ), sizeof( VkDeviceSize ) );
	swigStructField( "VkPhysicalDeviceLimits-optimalBufferCopyRowPitchAlignment", offsetof( struct VkPhysicalDeviceLimits, optimalBufferCopyRowPitchAlignment ), sizeof( VkDeviceSize ) );
	swigStructField( "VkPhysicalDeviceLimits-bufferImageGranularity", offsetof( struct VkPhysicalDeviceLimits, bufferImageGranularity ), sizeof( VkDeviceSize ) );
	swigStructField( "VkPhysicalDeviceLimits-pointSizeGranularity", offsetof( struct VkPhysicalDeviceLimits, pointSizeGranularity ), sizeof( float ) );
	swigStructField( "VkPhysicalDeviceLimits-lineWidthGranularity", offsetof( struct VkPhysicalDeviceLimits, lineWidthGranularity ), sizeof( float ) );
	swigStructField( "VkPhysicalDeviceLimits-maxPerStageDescriptorSampledImages", offsetof( struct VkPhysicalDeviceLimits, maxPerStageDescriptorSampledImages ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxDescriptorSetSampledImages", offsetof( struct VkPhysicalDeviceLimits, maxDescriptorSetSampledImages ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxViewports", offsetof( struct VkPhysicalDeviceLimits, maxViewports ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxTexelBufferElements", offsetof( struct VkPhysicalDeviceLimits, maxTexelBufferElements ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxVertexInputBindings", offsetof( struct VkPhysicalDeviceLimits, maxVertexInputBindings ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxGeometryOutputVertices", offsetof( struct VkPhysicalDeviceLimits, maxGeometryOutputVertices ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxClipDistances", offsetof( struct VkPhysicalDeviceLimits, maxClipDistances ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxCullDistances", offsetof( struct VkPhysicalDeviceLimits, maxCullDistances ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxCombinedClipAndCullDistances", offsetof( struct VkPhysicalDeviceLimits, maxCombinedClipAndCullDistances ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxStorageBufferRange", offsetof( struct VkPhysicalDeviceLimits, maxStorageBufferRange ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxUniformBufferRange", offsetof( struct VkPhysicalDeviceLimits, maxUniformBufferRange ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxImageDimension2D", offsetof( struct VkPhysicalDeviceLimits, maxImageDimension2D ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxDrawIndexedIndexValue", offsetof( struct VkPhysicalDeviceLimits, maxDrawIndexedIndexValue ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceLimits ) );

	swigComment("struct VkPhysicalDeviceMemoryProperties\n");
	printf( "begin-structure VkPhysicalDeviceMemoryProperties\n" );
	swigStructField( "VkPhysicalDeviceMemoryProperties-memoryHeaps", offsetof( struct VkPhysicalDeviceMemoryProperties, memoryHeaps ), sizeof( VkMemoryHeap [16U] ) );
	swigStructField( "VkPhysicalDeviceMemoryProperties-memoryTypeCount", offsetof( struct VkPhysicalDeviceMemoryProperties, memoryTypeCount ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceMemoryProperties-memoryHeapCount", offsetof( struct VkPhysicalDeviceMemoryProperties, memoryHeapCount ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceMemoryProperties-memoryTypes", offsetof( struct VkPhysicalDeviceMemoryProperties, memoryTypes ), sizeof( VkMemoryType [32U] ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceMemoryProperties ) );

	swigComment("struct VkPhysicalDeviceSparseProperties\n");
	printf( "begin-structure VkPhysicalDeviceSparseProperties\n" );
	swigStructField( "VkPhysicalDeviceSparseProperties-residencyNonResidentStrict", offsetof( struct VkPhysicalDeviceSparseProperties, residencyNonResidentStrict ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceSparseProperties-residencyStandard2DBlockShape", offsetof( struct VkPhysicalDeviceSparseProperties, residencyStandard2DBlockShape ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceSparseProperties-residencyStandard2DMultisampleBlockShape", offsetof( struct VkPhysicalDeviceSparseProperties, residencyStandard2DMultisampleBlockShape ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceSparseProperties-residencyStandard3DBlockShape", offsetof( struct VkPhysicalDeviceSparseProperties, residencyStandard3DBlockShape ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceSparseProperties-residencyAlignedMipSize", offsetof( struct VkPhysicalDeviceSparseProperties, residencyAlignedMipSize ), sizeof( VkBool32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceSparseProperties ) );

	swigComment("struct VkPhysicalDeviceProperties\n");
	printf( "begin-structure VkPhysicalDeviceProperties\n" );
	swigStructField( "VkPhysicalDeviceProperties-vendorID", offsetof( struct VkPhysicalDeviceProperties, vendorID ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceProperties-deviceName", offsetof( struct VkPhysicalDeviceProperties, deviceName ), sizeof( char [256U] ) );
	swigStructField( "VkPhysicalDeviceProperties-apiVersion", offsetof( struct VkPhysicalDeviceProperties, apiVersion ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceProperties-driverVersion", offsetof( struct VkPhysicalDeviceProperties, driverVersion ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceProperties-sparseProperties", offsetof( struct VkPhysicalDeviceProperties, sparseProperties ), sizeof( VkPhysicalDeviceSparseProperties ) );
	swigStructField( "VkPhysicalDeviceProperties-deviceType", offsetof( struct VkPhysicalDeviceProperties, deviceType ), sizeof( VkPhysicalDeviceType ) );
	swigStructField( "VkPhysicalDeviceProperties-deviceID", offsetof( struct VkPhysicalDeviceProperties, deviceID ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceProperties-pipelineCacheUUID", offsetof( struct VkPhysicalDeviceProperties, pipelineCacheUUID ), sizeof( uint8_t [16U] ) );
	swigStructField( "VkPhysicalDeviceProperties-limits", offsetof( struct VkPhysicalDeviceProperties, limits ), sizeof( VkPhysicalDeviceLimits ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceProperties ) );

	swigComment("struct VkQueueFamilyProperties\n");
	printf( "begin-structure VkQueueFamilyProperties\n" );
	swigStructField( "VkQueueFamilyProperties-timestampValidBits", offsetof( struct VkQueueFamilyProperties, timestampValidBits ), sizeof( uint32_t ) );
	swigStructField( "VkQueueFamilyProperties-queueCount", offsetof( struct VkQueueFamilyProperties, queueCount ), sizeof( uint32_t ) );
	swigStructField( "VkQueueFamilyProperties-minImageTransferGranularity", offsetof( struct VkQueueFamilyProperties, minImageTransferGranularity ), sizeof( VkExtent3D ) );
	swigStructField( "VkQueueFamilyProperties-queueFlags", offsetof( struct VkQueueFamilyProperties, queueFlags ), sizeof( VkQueueFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkQueueFamilyProperties ) );

	swigComment("struct VkDeviceQueueCreateInfo\n");
	printf( "begin-structure VkDeviceQueueCreateInfo\n" );
	swigStructField( "VkDeviceQueueCreateInfo-pNext", offsetof( struct VkDeviceQueueCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkDeviceQueueCreateInfo-queueFamilyIndex", offsetof( struct VkDeviceQueueCreateInfo, queueFamilyIndex ), sizeof( uint32_t ) );
	swigStructField( "VkDeviceQueueCreateInfo-queueCount", offsetof( struct VkDeviceQueueCreateInfo, queueCount ), sizeof( uint32_t ) );
	swigStructField( "VkDeviceQueueCreateInfo-sType", offsetof( struct VkDeviceQueueCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkDeviceQueueCreateInfo-flags", offsetof( struct VkDeviceQueueCreateInfo, flags ), sizeof( VkDeviceQueueCreateFlags ) );
	swigStructField( "VkDeviceQueueCreateInfo-pQueuePriorities", offsetof( struct VkDeviceQueueCreateInfo, pQueuePriorities ), sizeof( float const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDeviceQueueCreateInfo ) );

	swigComment("struct VkDeviceCreateInfo\n");
	printf( "begin-structure VkDeviceCreateInfo\n" );
	swigStructField( "VkDeviceCreateInfo-pQueueCreateInfos", offsetof( struct VkDeviceCreateInfo, pQueueCreateInfos ), sizeof( VkDeviceQueueCreateInfo const * ) );
	swigStructField( "VkDeviceCreateInfo-enabledExtensionCount", offsetof( struct VkDeviceCreateInfo, enabledExtensionCount ), sizeof( uint32_t ) );
	swigStructField( "VkDeviceCreateInfo-pEnabledFeatures", offsetof( struct VkDeviceCreateInfo, pEnabledFeatures ), sizeof( VkPhysicalDeviceFeatures const * ) );
	swigStructField( "VkDeviceCreateInfo-pNext", offsetof( struct VkDeviceCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkDeviceCreateInfo-enabledLayerCount", offsetof( struct VkDeviceCreateInfo, enabledLayerCount ), sizeof( uint32_t ) );
	swigStructField( "VkDeviceCreateInfo-queueCreateInfoCount", offsetof( struct VkDeviceCreateInfo, queueCreateInfoCount ), sizeof( uint32_t ) );
	swigStructField( "VkDeviceCreateInfo-sType", offsetof( struct VkDeviceCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkDeviceCreateInfo-flags", offsetof( struct VkDeviceCreateInfo, flags ), sizeof( VkDeviceCreateFlags ) );
	swigStructField( "VkDeviceCreateInfo-ppEnabledExtensionNames", offsetof( struct VkDeviceCreateInfo, ppEnabledExtensionNames ), sizeof( char const *const * ) );
	swigStructField( "VkDeviceCreateInfo-ppEnabledLayerNames", offsetof( struct VkDeviceCreateInfo, ppEnabledLayerNames ), sizeof( char const *const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDeviceCreateInfo ) );

	swigComment("struct VkExtensionProperties\n");
	printf( "begin-structure VkExtensionProperties\n" );
	swigStructField( "VkExtensionProperties-specVersion", offsetof( struct VkExtensionProperties, specVersion ), sizeof( uint32_t ) );
	swigStructField( "VkExtensionProperties-extensionName", offsetof( struct VkExtensionProperties, extensionName ), sizeof( char [256U] ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkExtensionProperties ) );

	swigComment("struct VkLayerProperties\n");
	printf( "begin-structure VkLayerProperties\n" );
	swigStructField( "VkLayerProperties-layerName", offsetof( struct VkLayerProperties, layerName ), sizeof( char [256U] ) );
	swigStructField( "VkLayerProperties-specVersion", offsetof( struct VkLayerProperties, specVersion ), sizeof( uint32_t ) );
	swigStructField( "VkLayerProperties-implementationVersion", offsetof( struct VkLayerProperties, implementationVersion ), sizeof( uint32_t ) );
	swigStructField( "VkLayerProperties-description", offsetof( struct VkLayerProperties, description ), sizeof( char [256U] ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkLayerProperties ) );

	swigComment("struct VkSubmitInfo\n");
	printf( "begin-structure VkSubmitInfo\n" );
	swigStructField( "VkSubmitInfo-pNext", offsetof( struct VkSubmitInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkSubmitInfo-commandBufferCount", offsetof( struct VkSubmitInfo, commandBufferCount ), sizeof( uint32_t ) );
	swigStructField( "VkSubmitInfo-pWaitDstStageMask", offsetof( struct VkSubmitInfo, pWaitDstStageMask ), sizeof( VkPipelineStageFlags const * ) );
	swigStructField( "VkSubmitInfo-pCommandBuffers", offsetof( struct VkSubmitInfo, pCommandBuffers ), sizeof( VkCommandBuffer const * ) );
	swigStructField( "VkSubmitInfo-waitSemaphoreCount", offsetof( struct VkSubmitInfo, waitSemaphoreCount ), sizeof( uint32_t ) );
	swigStructField( "VkSubmitInfo-pWaitSemaphores", offsetof( struct VkSubmitInfo, pWaitSemaphores ), sizeof( VkSemaphore const * ) );
	swigStructField( "VkSubmitInfo-signalSemaphoreCount", offsetof( struct VkSubmitInfo, signalSemaphoreCount ), sizeof( uint32_t ) );
	swigStructField( "VkSubmitInfo-pSignalSemaphores", offsetof( struct VkSubmitInfo, pSignalSemaphores ), sizeof( VkSemaphore const * ) );
	swigStructField( "VkSubmitInfo-sType", offsetof( struct VkSubmitInfo, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSubmitInfo ) );

	swigComment("struct VkMappedMemoryRange\n");
	printf( "begin-structure VkMappedMemoryRange\n" );
	swigStructField( "VkMappedMemoryRange-pNext", offsetof( struct VkMappedMemoryRange, pNext ), sizeof( void const * ) );
	swigStructField( "VkMappedMemoryRange-memory", offsetof( struct VkMappedMemoryRange, memory ), sizeof( VkDeviceMemory ) );
	swigStructField( "VkMappedMemoryRange-offset", offsetof( struct VkMappedMemoryRange, offset ), sizeof( VkDeviceSize ) );
	swigStructField( "VkMappedMemoryRange-size", offsetof( struct VkMappedMemoryRange, size ), sizeof( VkDeviceSize ) );
	swigStructField( "VkMappedMemoryRange-sType", offsetof( struct VkMappedMemoryRange, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkMappedMemoryRange ) );

	swigComment("struct VkMemoryAllocateInfo\n");
	printf( "begin-structure VkMemoryAllocateInfo\n" );
	swigStructField( "VkMemoryAllocateInfo-pNext", offsetof( struct VkMemoryAllocateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkMemoryAllocateInfo-allocationSize", offsetof( struct VkMemoryAllocateInfo, allocationSize ), sizeof( VkDeviceSize ) );
	swigStructField( "VkMemoryAllocateInfo-memoryTypeIndex", offsetof( struct VkMemoryAllocateInfo, memoryTypeIndex ), sizeof( uint32_t ) );
	swigStructField( "VkMemoryAllocateInfo-sType", offsetof( struct VkMemoryAllocateInfo, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkMemoryAllocateInfo ) );

	swigComment("struct VkMemoryRequirements\n");
	printf( "begin-structure VkMemoryRequirements\n" );
	swigStructField( "VkMemoryRequirements-memoryTypeBits", offsetof( struct VkMemoryRequirements, memoryTypeBits ), sizeof( uint32_t ) );
	swigStructField( "VkMemoryRequirements-size", offsetof( struct VkMemoryRequirements, size ), sizeof( VkDeviceSize ) );
	swigStructField( "VkMemoryRequirements-alignment", offsetof( struct VkMemoryRequirements, alignment ), sizeof( VkDeviceSize ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkMemoryRequirements ) );

	swigComment("struct VkSparseMemoryBind\n");
	printf( "begin-structure VkSparseMemoryBind\n" );
	swigStructField( "VkSparseMemoryBind-memory", offsetof( struct VkSparseMemoryBind, memory ), sizeof( VkDeviceMemory ) );
	swigStructField( "VkSparseMemoryBind-resourceOffset", offsetof( struct VkSparseMemoryBind, resourceOffset ), sizeof( VkDeviceSize ) );
	swigStructField( "VkSparseMemoryBind-memoryOffset", offsetof( struct VkSparseMemoryBind, memoryOffset ), sizeof( VkDeviceSize ) );
	swigStructField( "VkSparseMemoryBind-size", offsetof( struct VkSparseMemoryBind, size ), sizeof( VkDeviceSize ) );
	swigStructField( "VkSparseMemoryBind-flags", offsetof( struct VkSparseMemoryBind, flags ), sizeof( VkSparseMemoryBindFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSparseMemoryBind ) );

	swigComment("struct VkSparseBufferMemoryBindInfo\n");
	printf( "begin-structure VkSparseBufferMemoryBindInfo\n" );
	swigStructField( "VkSparseBufferMemoryBindInfo-buffer", offsetof( struct VkSparseBufferMemoryBindInfo, buffer ), sizeof( VkBuffer ) );
	swigStructField( "VkSparseBufferMemoryBindInfo-bindCount", offsetof( struct VkSparseBufferMemoryBindInfo, bindCount ), sizeof( uint32_t ) );
	swigStructField( "VkSparseBufferMemoryBindInfo-pBinds", offsetof( struct VkSparseBufferMemoryBindInfo, pBinds ), sizeof( VkSparseMemoryBind const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSparseBufferMemoryBindInfo ) );

	swigComment("struct VkSparseImageOpaqueMemoryBindInfo\n");
	printf( "begin-structure VkSparseImageOpaqueMemoryBindInfo\n" );
	swigStructField( "VkSparseImageOpaqueMemoryBindInfo-bindCount", offsetof( struct VkSparseImageOpaqueMemoryBindInfo, bindCount ), sizeof( uint32_t ) );
	swigStructField( "VkSparseImageOpaqueMemoryBindInfo-pBinds", offsetof( struct VkSparseImageOpaqueMemoryBindInfo, pBinds ), sizeof( VkSparseMemoryBind const * ) );
	swigStructField( "VkSparseImageOpaqueMemoryBindInfo-image", offsetof( struct VkSparseImageOpaqueMemoryBindInfo, image ), sizeof( VkImage ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSparseImageOpaqueMemoryBindInfo ) );

	swigComment("struct VkImageSubresource\n");
	printf( "begin-structure VkImageSubresource\n" );
	swigStructField( "VkImageSubresource-arrayLayer", offsetof( struct VkImageSubresource, arrayLayer ), sizeof( uint32_t ) );
	swigStructField( "VkImageSubresource-mipLevel", offsetof( struct VkImageSubresource, mipLevel ), sizeof( uint32_t ) );
	swigStructField( "VkImageSubresource-aspectMask", offsetof( struct VkImageSubresource, aspectMask ), sizeof( VkImageAspectFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkImageSubresource ) );

	swigComment("struct VkSparseImageMemoryBind\n");
	printf( "begin-structure VkSparseImageMemoryBind\n" );
	swigStructField( "VkSparseImageMemoryBind-extent", offsetof( struct VkSparseImageMemoryBind, extent ), sizeof( VkExtent3D ) );
	swigStructField( "VkSparseImageMemoryBind-subresource", offsetof( struct VkSparseImageMemoryBind, subresource ), sizeof( VkImageSubresource ) );
	swigStructField( "VkSparseImageMemoryBind-memory", offsetof( struct VkSparseImageMemoryBind, memory ), sizeof( VkDeviceMemory ) );
	swigStructField( "VkSparseImageMemoryBind-offset", offsetof( struct VkSparseImageMemoryBind, offset ), sizeof( VkOffset3D ) );
	swigStructField( "VkSparseImageMemoryBind-memoryOffset", offsetof( struct VkSparseImageMemoryBind, memoryOffset ), sizeof( VkDeviceSize ) );
	swigStructField( "VkSparseImageMemoryBind-flags", offsetof( struct VkSparseImageMemoryBind, flags ), sizeof( VkSparseMemoryBindFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSparseImageMemoryBind ) );

	swigComment("struct VkSparseImageMemoryBindInfo\n");
	printf( "begin-structure VkSparseImageMemoryBindInfo\n" );
	swigStructField( "VkSparseImageMemoryBindInfo-bindCount", offsetof( struct VkSparseImageMemoryBindInfo, bindCount ), sizeof( uint32_t ) );
	swigStructField( "VkSparseImageMemoryBindInfo-pBinds", offsetof( struct VkSparseImageMemoryBindInfo, pBinds ), sizeof( VkSparseImageMemoryBind const * ) );
	swigStructField( "VkSparseImageMemoryBindInfo-image", offsetof( struct VkSparseImageMemoryBindInfo, image ), sizeof( VkImage ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSparseImageMemoryBindInfo ) );

	swigComment("struct VkBindSparseInfo\n");
	printf( "begin-structure VkBindSparseInfo\n" );
	swigStructField( "VkBindSparseInfo-pNext", offsetof( struct VkBindSparseInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkBindSparseInfo-pImageOpaqueBinds", offsetof( struct VkBindSparseInfo, pImageOpaqueBinds ), sizeof( VkSparseImageOpaqueMemoryBindInfo const * ) );
	swigStructField( "VkBindSparseInfo-pImageBinds", offsetof( struct VkBindSparseInfo, pImageBinds ), sizeof( VkSparseImageMemoryBindInfo const * ) );
	swigStructField( "VkBindSparseInfo-bufferBindCount", offsetof( struct VkBindSparseInfo, bufferBindCount ), sizeof( uint32_t ) );
	swigStructField( "VkBindSparseInfo-imageOpaqueBindCount", offsetof( struct VkBindSparseInfo, imageOpaqueBindCount ), sizeof( uint32_t ) );
	swigStructField( "VkBindSparseInfo-imageBindCount", offsetof( struct VkBindSparseInfo, imageBindCount ), sizeof( uint32_t ) );
	swigStructField( "VkBindSparseInfo-waitSemaphoreCount", offsetof( struct VkBindSparseInfo, waitSemaphoreCount ), sizeof( uint32_t ) );
	swigStructField( "VkBindSparseInfo-pWaitSemaphores", offsetof( struct VkBindSparseInfo, pWaitSemaphores ), sizeof( VkSemaphore const * ) );
	swigStructField( "VkBindSparseInfo-signalSemaphoreCount", offsetof( struct VkBindSparseInfo, signalSemaphoreCount ), sizeof( uint32_t ) );
	swigStructField( "VkBindSparseInfo-pSignalSemaphores", offsetof( struct VkBindSparseInfo, pSignalSemaphores ), sizeof( VkSemaphore const * ) );
	swigStructField( "VkBindSparseInfo-sType", offsetof( struct VkBindSparseInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkBindSparseInfo-pBufferBinds", offsetof( struct VkBindSparseInfo, pBufferBinds ), sizeof( VkSparseBufferMemoryBindInfo const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkBindSparseInfo ) );

	swigComment("struct VkSparseImageFormatProperties\n");
	printf( "begin-structure VkSparseImageFormatProperties\n" );
	swigStructField( "VkSparseImageFormatProperties-imageGranularity", offsetof( struct VkSparseImageFormatProperties, imageGranularity ), sizeof( VkExtent3D ) );
	swigStructField( "VkSparseImageFormatProperties-flags", offsetof( struct VkSparseImageFormatProperties, flags ), sizeof( VkSparseImageFormatFlags ) );
	swigStructField( "VkSparseImageFormatProperties-aspectMask", offsetof( struct VkSparseImageFormatProperties, aspectMask ), sizeof( VkImageAspectFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSparseImageFormatProperties ) );

	swigComment("struct VkSparseImageMemoryRequirements\n");
	printf( "begin-structure VkSparseImageMemoryRequirements\n" );
	swigStructField( "VkSparseImageMemoryRequirements-imageMipTailSize", offsetof( struct VkSparseImageMemoryRequirements, imageMipTailSize ), sizeof( VkDeviceSize ) );
	swigStructField( "VkSparseImageMemoryRequirements-imageMipTailOffset", offsetof( struct VkSparseImageMemoryRequirements, imageMipTailOffset ), sizeof( VkDeviceSize ) );
	swigStructField( "VkSparseImageMemoryRequirements-formatProperties", offsetof( struct VkSparseImageMemoryRequirements, formatProperties ), sizeof( VkSparseImageFormatProperties ) );
	swigStructField( "VkSparseImageMemoryRequirements-imageMipTailStride", offsetof( struct VkSparseImageMemoryRequirements, imageMipTailStride ), sizeof( VkDeviceSize ) );
	swigStructField( "VkSparseImageMemoryRequirements-imageMipTailFirstLod", offsetof( struct VkSparseImageMemoryRequirements, imageMipTailFirstLod ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSparseImageMemoryRequirements ) );

	swigComment("struct VkFenceCreateInfo\n");
	printf( "begin-structure VkFenceCreateInfo\n" );
	swigStructField( "VkFenceCreateInfo-pNext", offsetof( struct VkFenceCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkFenceCreateInfo-sType", offsetof( struct VkFenceCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkFenceCreateInfo-flags", offsetof( struct VkFenceCreateInfo, flags ), sizeof( VkFenceCreateFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkFenceCreateInfo ) );

	swigComment("struct VkSemaphoreCreateInfo\n");
	printf( "begin-structure VkSemaphoreCreateInfo\n" );
	swigStructField( "VkSemaphoreCreateInfo-pNext", offsetof( struct VkSemaphoreCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkSemaphoreCreateInfo-sType", offsetof( struct VkSemaphoreCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkSemaphoreCreateInfo-flags", offsetof( struct VkSemaphoreCreateInfo, flags ), sizeof( VkSemaphoreCreateFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSemaphoreCreateInfo ) );

	swigComment("struct VkEventCreateInfo\n");
	printf( "begin-structure VkEventCreateInfo\n" );
	swigStructField( "VkEventCreateInfo-pNext", offsetof( struct VkEventCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkEventCreateInfo-sType", offsetof( struct VkEventCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkEventCreateInfo-flags", offsetof( struct VkEventCreateInfo, flags ), sizeof( VkEventCreateFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkEventCreateInfo ) );

	swigComment("struct VkQueryPoolCreateInfo\n");
	printf( "begin-structure VkQueryPoolCreateInfo\n" );
	swigStructField( "VkQueryPoolCreateInfo-pipelineStatistics", offsetof( struct VkQueryPoolCreateInfo, pipelineStatistics ), sizeof( VkQueryPipelineStatisticFlags ) );
	swigStructField( "VkQueryPoolCreateInfo-pNext", offsetof( struct VkQueryPoolCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkQueryPoolCreateInfo-queryType", offsetof( struct VkQueryPoolCreateInfo, queryType ), sizeof( VkQueryType ) );
	swigStructField( "VkQueryPoolCreateInfo-queryCount", offsetof( struct VkQueryPoolCreateInfo, queryCount ), sizeof( uint32_t ) );
	swigStructField( "VkQueryPoolCreateInfo-sType", offsetof( struct VkQueryPoolCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkQueryPoolCreateInfo-flags", offsetof( struct VkQueryPoolCreateInfo, flags ), sizeof( VkQueryPoolCreateFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkQueryPoolCreateInfo ) );

	swigComment("struct VkBufferCreateInfo\n");
	printf( "begin-structure VkBufferCreateInfo\n" );
	swigStructField( "VkBufferCreateInfo-pNext", offsetof( struct VkBufferCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkBufferCreateInfo-sharingMode", offsetof( struct VkBufferCreateInfo, sharingMode ), sizeof( VkSharingMode ) );
	swigStructField( "VkBufferCreateInfo-usage", offsetof( struct VkBufferCreateInfo, usage ), sizeof( VkBufferUsageFlags ) );
	swigStructField( "VkBufferCreateInfo-size", offsetof( struct VkBufferCreateInfo, size ), sizeof( VkDeviceSize ) );
	swigStructField( "VkBufferCreateInfo-pQueueFamilyIndices", offsetof( struct VkBufferCreateInfo, pQueueFamilyIndices ), sizeof( uint32_t const * ) );
	swigStructField( "VkBufferCreateInfo-sType", offsetof( struct VkBufferCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkBufferCreateInfo-flags", offsetof( struct VkBufferCreateInfo, flags ), sizeof( VkBufferCreateFlags ) );
	swigStructField( "VkBufferCreateInfo-queueFamilyIndexCount", offsetof( struct VkBufferCreateInfo, queueFamilyIndexCount ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkBufferCreateInfo ) );

	swigComment("struct VkBufferViewCreateInfo\n");
	printf( "begin-structure VkBufferViewCreateInfo\n" );
	swigStructField( "VkBufferViewCreateInfo-pNext", offsetof( struct VkBufferViewCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkBufferViewCreateInfo-buffer", offsetof( struct VkBufferViewCreateInfo, buffer ), sizeof( VkBuffer ) );
	swigStructField( "VkBufferViewCreateInfo-offset", offsetof( struct VkBufferViewCreateInfo, offset ), sizeof( VkDeviceSize ) );
	swigStructField( "VkBufferViewCreateInfo-sType", offsetof( struct VkBufferViewCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkBufferViewCreateInfo-flags", offsetof( struct VkBufferViewCreateInfo, flags ), sizeof( VkBufferViewCreateFlags ) );
	swigStructField( "VkBufferViewCreateInfo-format", offsetof( struct VkBufferViewCreateInfo, format ), sizeof( VkFormat ) );
	swigStructField( "VkBufferViewCreateInfo-range", offsetof( struct VkBufferViewCreateInfo, range ), sizeof( VkDeviceSize ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkBufferViewCreateInfo ) );

	swigComment("struct VkImageCreateInfo\n");
	printf( "begin-structure VkImageCreateInfo\n" );
	swigStructField( "VkImageCreateInfo-queueFamilyIndexCount", offsetof( struct VkImageCreateInfo, queueFamilyIndexCount ), sizeof( uint32_t ) );
	swigStructField( "VkImageCreateInfo-pNext", offsetof( struct VkImageCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkImageCreateInfo-samples", offsetof( struct VkImageCreateInfo, samples ), sizeof( VkSampleCountFlagBits ) );
	swigStructField( "VkImageCreateInfo-format", offsetof( struct VkImageCreateInfo, format ), sizeof( VkFormat ) );
	swigStructField( "VkImageCreateInfo-extent", offsetof( struct VkImageCreateInfo, extent ), sizeof( VkExtent3D ) );
	swigStructField( "VkImageCreateInfo-pQueueFamilyIndices", offsetof( struct VkImageCreateInfo, pQueueFamilyIndices ), sizeof( uint32_t const * ) );
	swigStructField( "VkImageCreateInfo-imageType", offsetof( struct VkImageCreateInfo, imageType ), sizeof( VkImageType ) );
	swigStructField( "VkImageCreateInfo-arrayLayers", offsetof( struct VkImageCreateInfo, arrayLayers ), sizeof( uint32_t ) );
	swigStructField( "VkImageCreateInfo-flags", offsetof( struct VkImageCreateInfo, flags ), sizeof( VkImageCreateFlags ) );
	swigStructField( "VkImageCreateInfo-usage", offsetof( struct VkImageCreateInfo, usage ), sizeof( VkImageUsageFlags ) );
	swigStructField( "VkImageCreateInfo-sharingMode", offsetof( struct VkImageCreateInfo, sharingMode ), sizeof( VkSharingMode ) );
	swigStructField( "VkImageCreateInfo-mipLevels", offsetof( struct VkImageCreateInfo, mipLevels ), sizeof( uint32_t ) );
	swigStructField( "VkImageCreateInfo-tiling", offsetof( struct VkImageCreateInfo, tiling ), sizeof( VkImageTiling ) );
	swigStructField( "VkImageCreateInfo-sType", offsetof( struct VkImageCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkImageCreateInfo-initialLayout", offsetof( struct VkImageCreateInfo, initialLayout ), sizeof( VkImageLayout ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkImageCreateInfo ) );

	swigComment("struct VkSubresourceLayout\n");
	printf( "begin-structure VkSubresourceLayout\n" );
	swigStructField( "VkSubresourceLayout-offset", offsetof( struct VkSubresourceLayout, offset ), sizeof( VkDeviceSize ) );
	swigStructField( "VkSubresourceLayout-arrayPitch", offsetof( struct VkSubresourceLayout, arrayPitch ), sizeof( VkDeviceSize ) );
	swigStructField( "VkSubresourceLayout-size", offsetof( struct VkSubresourceLayout, size ), sizeof( VkDeviceSize ) );
	swigStructField( "VkSubresourceLayout-depthPitch", offsetof( struct VkSubresourceLayout, depthPitch ), sizeof( VkDeviceSize ) );
	swigStructField( "VkSubresourceLayout-rowPitch", offsetof( struct VkSubresourceLayout, rowPitch ), sizeof( VkDeviceSize ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSubresourceLayout ) );

	swigComment("struct VkComponentMapping\n");
	printf( "begin-structure VkComponentMapping\n" );
	swigStructField( "VkComponentMapping-b", offsetof( struct VkComponentMapping, b ), sizeof( VkComponentSwizzle ) );
	swigStructField( "VkComponentMapping-r", offsetof( struct VkComponentMapping, r ), sizeof( VkComponentSwizzle ) );
	swigStructField( "VkComponentMapping-g", offsetof( struct VkComponentMapping, g ), sizeof( VkComponentSwizzle ) );
	swigStructField( "VkComponentMapping-a", offsetof( struct VkComponentMapping, a ), sizeof( VkComponentSwizzle ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkComponentMapping ) );

	swigComment("struct VkImageViewCreateInfo\n");
	printf( "begin-structure VkImageViewCreateInfo\n" );
	swigStructField( "VkImageViewCreateInfo-pNext", offsetof( struct VkImageViewCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkImageViewCreateInfo-viewType", offsetof( struct VkImageViewCreateInfo, viewType ), sizeof( VkImageViewType ) );
	swigStructField( "VkImageViewCreateInfo-image", offsetof( struct VkImageViewCreateInfo, image ), sizeof( VkImage ) );
	swigStructField( "VkImageViewCreateInfo-sType", offsetof( struct VkImageViewCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkImageViewCreateInfo-flags", offsetof( struct VkImageViewCreateInfo, flags ), sizeof( VkImageViewCreateFlags ) );
	swigStructField( "VkImageViewCreateInfo-format", offsetof( struct VkImageViewCreateInfo, format ), sizeof( VkFormat ) );
	swigStructField( "VkImageViewCreateInfo-components", offsetof( struct VkImageViewCreateInfo, components ), sizeof( VkComponentMapping ) );
	swigStructField( "VkImageViewCreateInfo-subresourceRange", offsetof( struct VkImageViewCreateInfo, subresourceRange ), sizeof( VkImageSubresourceRange ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkImageViewCreateInfo ) );

	swigComment("struct VkShaderModuleCreateInfo\n");
	printf( "begin-structure VkShaderModuleCreateInfo\n" );
	swigStructField( "VkShaderModuleCreateInfo-pNext", offsetof( struct VkShaderModuleCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkShaderModuleCreateInfo-sType", offsetof( struct VkShaderModuleCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkShaderModuleCreateInfo-flags", offsetof( struct VkShaderModuleCreateInfo, flags ), sizeof( VkShaderModuleCreateFlags ) );
	swigStructField( "VkShaderModuleCreateInfo-codeSize", offsetof( struct VkShaderModuleCreateInfo, codeSize ), sizeof( size_t ) );
	swigStructField( "VkShaderModuleCreateInfo-pCode", offsetof( struct VkShaderModuleCreateInfo, pCode ), sizeof( uint32_t const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkShaderModuleCreateInfo ) );

	swigComment("struct VkPipelineCacheCreateInfo\n");
	printf( "begin-structure VkPipelineCacheCreateInfo\n" );
	swigStructField( "VkPipelineCacheCreateInfo-pNext", offsetof( struct VkPipelineCacheCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkPipelineCacheCreateInfo-initialDataSize", offsetof( struct VkPipelineCacheCreateInfo, initialDataSize ), sizeof( size_t ) );
	swigStructField( "VkPipelineCacheCreateInfo-pInitialData", offsetof( struct VkPipelineCacheCreateInfo, pInitialData ), sizeof( void const * ) );
	swigStructField( "VkPipelineCacheCreateInfo-sType", offsetof( struct VkPipelineCacheCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPipelineCacheCreateInfo-flags", offsetof( struct VkPipelineCacheCreateInfo, flags ), sizeof( VkPipelineCacheCreateFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineCacheCreateInfo ) );

	swigComment("struct VkSpecializationMapEntry\n");
	printf( "begin-structure VkSpecializationMapEntry\n" );
	swigStructField( "VkSpecializationMapEntry-constantID", offsetof( struct VkSpecializationMapEntry, constantID ), sizeof( uint32_t ) );
	swigStructField( "VkSpecializationMapEntry-offset", offsetof( struct VkSpecializationMapEntry, offset ), sizeof( uint32_t ) );
	swigStructField( "VkSpecializationMapEntry-size", offsetof( struct VkSpecializationMapEntry, size ), sizeof( size_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSpecializationMapEntry ) );

	swigComment("struct VkSpecializationInfo\n");
	printf( "begin-structure VkSpecializationInfo\n" );
	swigStructField( "VkSpecializationInfo-dataSize", offsetof( struct VkSpecializationInfo, dataSize ), sizeof( size_t ) );
	swigStructField( "VkSpecializationInfo-mapEntryCount", offsetof( struct VkSpecializationInfo, mapEntryCount ), sizeof( uint32_t ) );
	swigStructField( "VkSpecializationInfo-pData", offsetof( struct VkSpecializationInfo, pData ), sizeof( void const * ) );
	swigStructField( "VkSpecializationInfo-pMapEntries", offsetof( struct VkSpecializationInfo, pMapEntries ), sizeof( VkSpecializationMapEntry const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSpecializationInfo ) );

	swigComment("struct VkPipelineShaderStageCreateInfo\n");
	printf( "begin-structure VkPipelineShaderStageCreateInfo\n" );
	swigStructField( "VkPipelineShaderStageCreateInfo-pNext", offsetof( struct VkPipelineShaderStageCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkPipelineShaderStageCreateInfo-module", offsetof( struct VkPipelineShaderStageCreateInfo, module ), sizeof( VkShaderModule ) );
	swigStructField( "VkPipelineShaderStageCreateInfo-pSpecializationInfo", offsetof( struct VkPipelineShaderStageCreateInfo, pSpecializationInfo ), sizeof( VkSpecializationInfo const * ) );
	swigStructField( "VkPipelineShaderStageCreateInfo-stage", offsetof( struct VkPipelineShaderStageCreateInfo, stage ), sizeof( VkShaderStageFlagBits ) );
	swigStructField( "VkPipelineShaderStageCreateInfo-pName", offsetof( struct VkPipelineShaderStageCreateInfo, pName ), sizeof( char const * ) );
	swigStructField( "VkPipelineShaderStageCreateInfo-sType", offsetof( struct VkPipelineShaderStageCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPipelineShaderStageCreateInfo-flags", offsetof( struct VkPipelineShaderStageCreateInfo, flags ), sizeof( VkPipelineShaderStageCreateFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineShaderStageCreateInfo ) );

	swigComment("struct VkComputePipelineCreateInfo\n");
	printf( "begin-structure VkComputePipelineCreateInfo\n" );
	swigStructField( "VkComputePipelineCreateInfo-pNext", offsetof( struct VkComputePipelineCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkComputePipelineCreateInfo-stage", offsetof( struct VkComputePipelineCreateInfo, stage ), sizeof( VkPipelineShaderStageCreateInfo ) );
	swigStructField( "VkComputePipelineCreateInfo-basePipelineHandle", offsetof( struct VkComputePipelineCreateInfo, basePipelineHandle ), sizeof( VkPipeline ) );
	swigStructField( "VkComputePipelineCreateInfo-layout", offsetof( struct VkComputePipelineCreateInfo, layout ), sizeof( VkPipelineLayout ) );
	swigStructField( "VkComputePipelineCreateInfo-basePipelineIndex", offsetof( struct VkComputePipelineCreateInfo, basePipelineIndex ), sizeof( int32_t ) );
	swigStructField( "VkComputePipelineCreateInfo-sType", offsetof( struct VkComputePipelineCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkComputePipelineCreateInfo-flags", offsetof( struct VkComputePipelineCreateInfo, flags ), sizeof( VkPipelineCreateFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkComputePipelineCreateInfo ) );

	swigComment("struct VkVertexInputBindingDescription\n");
	printf( "begin-structure VkVertexInputBindingDescription\n" );
	swigStructField( "VkVertexInputBindingDescription-binding", offsetof( struct VkVertexInputBindingDescription, binding ), sizeof( uint32_t ) );
	swigStructField( "VkVertexInputBindingDescription-inputRate", offsetof( struct VkVertexInputBindingDescription, inputRate ), sizeof( VkVertexInputRate ) );
	swigStructField( "VkVertexInputBindingDescription-stride", offsetof( struct VkVertexInputBindingDescription, stride ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkVertexInputBindingDescription ) );

	swigComment("struct VkVertexInputAttributeDescription\n");
	printf( "begin-structure VkVertexInputAttributeDescription\n" );
	swigStructField( "VkVertexInputAttributeDescription-location", offsetof( struct VkVertexInputAttributeDescription, location ), sizeof( uint32_t ) );
	swigStructField( "VkVertexInputAttributeDescription-binding", offsetof( struct VkVertexInputAttributeDescription, binding ), sizeof( uint32_t ) );
	swigStructField( "VkVertexInputAttributeDescription-offset", offsetof( struct VkVertexInputAttributeDescription, offset ), sizeof( uint32_t ) );
	swigStructField( "VkVertexInputAttributeDescription-format", offsetof( struct VkVertexInputAttributeDescription, format ), sizeof( VkFormat ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkVertexInputAttributeDescription ) );

	swigComment("struct VkPipelineVertexInputStateCreateInfo\n");
	printf( "begin-structure VkPipelineVertexInputStateCreateInfo\n" );
	swigStructField( "VkPipelineVertexInputStateCreateInfo-vertexBindingDescriptionCount", offsetof( struct VkPipelineVertexInputStateCreateInfo, vertexBindingDescriptionCount ), sizeof( uint32_t ) );
	swigStructField( "VkPipelineVertexInputStateCreateInfo-vertexAttributeDescriptionCount", offsetof( struct VkPipelineVertexInputStateCreateInfo, vertexAttributeDescriptionCount ), sizeof( uint32_t ) );
	swigStructField( "VkPipelineVertexInputStateCreateInfo-pNext", offsetof( struct VkPipelineVertexInputStateCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkPipelineVertexInputStateCreateInfo-sType", offsetof( struct VkPipelineVertexInputStateCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPipelineVertexInputStateCreateInfo-flags", offsetof( struct VkPipelineVertexInputStateCreateInfo, flags ), sizeof( VkPipelineVertexInputStateCreateFlags ) );
	swigStructField( "VkPipelineVertexInputStateCreateInfo-pVertexBindingDescriptions", offsetof( struct VkPipelineVertexInputStateCreateInfo, pVertexBindingDescriptions ), sizeof( VkVertexInputBindingDescription const * ) );
	swigStructField( "VkPipelineVertexInputStateCreateInfo-pVertexAttributeDescriptions", offsetof( struct VkPipelineVertexInputStateCreateInfo, pVertexAttributeDescriptions ), sizeof( VkVertexInputAttributeDescription const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineVertexInputStateCreateInfo ) );

	swigComment("struct VkPipelineInputAssemblyStateCreateInfo\n");
	printf( "begin-structure VkPipelineInputAssemblyStateCreateInfo\n" );
	swigStructField( "VkPipelineInputAssemblyStateCreateInfo-pNext", offsetof( struct VkPipelineInputAssemblyStateCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkPipelineInputAssemblyStateCreateInfo-topology", offsetof( struct VkPipelineInputAssemblyStateCreateInfo, topology ), sizeof( VkPrimitiveTopology ) );
	swigStructField( "VkPipelineInputAssemblyStateCreateInfo-primitiveRestartEnable", offsetof( struct VkPipelineInputAssemblyStateCreateInfo, primitiveRestartEnable ), sizeof( VkBool32 ) );
	swigStructField( "VkPipelineInputAssemblyStateCreateInfo-sType", offsetof( struct VkPipelineInputAssemblyStateCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPipelineInputAssemblyStateCreateInfo-flags", offsetof( struct VkPipelineInputAssemblyStateCreateInfo, flags ), sizeof( VkPipelineInputAssemblyStateCreateFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineInputAssemblyStateCreateInfo ) );

	swigComment("struct VkPipelineTessellationStateCreateInfo\n");
	printf( "begin-structure VkPipelineTessellationStateCreateInfo\n" );
	swigStructField( "VkPipelineTessellationStateCreateInfo-pNext", offsetof( struct VkPipelineTessellationStateCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkPipelineTessellationStateCreateInfo-patchControlPoints", offsetof( struct VkPipelineTessellationStateCreateInfo, patchControlPoints ), sizeof( uint32_t ) );
	swigStructField( "VkPipelineTessellationStateCreateInfo-sType", offsetof( struct VkPipelineTessellationStateCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPipelineTessellationStateCreateInfo-flags", offsetof( struct VkPipelineTessellationStateCreateInfo, flags ), sizeof( VkPipelineTessellationStateCreateFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineTessellationStateCreateInfo ) );

	swigComment("struct VkViewport\n");
	printf( "begin-structure VkViewport\n" );
	swigStructField( "VkViewport-x", offsetof( struct VkViewport, x ), sizeof( float ) );
	swigStructField( "VkViewport-y", offsetof( struct VkViewport, y ), sizeof( float ) );
	swigStructField( "VkViewport-maxDepth", offsetof( struct VkViewport, maxDepth ), sizeof( float ) );
	swigStructField( "VkViewport-minDepth", offsetof( struct VkViewport, minDepth ), sizeof( float ) );
	swigStructField( "VkViewport-height", offsetof( struct VkViewport, height ), sizeof( float ) );
	swigStructField( "VkViewport-width", offsetof( struct VkViewport, width ), sizeof( float ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkViewport ) );

	swigComment("struct VkPipelineViewportStateCreateInfo\n");
	printf( "begin-structure VkPipelineViewportStateCreateInfo\n" );
	swigStructField( "VkPipelineViewportStateCreateInfo-pScissors", offsetof( struct VkPipelineViewportStateCreateInfo, pScissors ), sizeof( VkRect2D const * ) );
	swigStructField( "VkPipelineViewportStateCreateInfo-pNext", offsetof( struct VkPipelineViewportStateCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkPipelineViewportStateCreateInfo-scissorCount", offsetof( struct VkPipelineViewportStateCreateInfo, scissorCount ), sizeof( uint32_t ) );
	swigStructField( "VkPipelineViewportStateCreateInfo-sType", offsetof( struct VkPipelineViewportStateCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPipelineViewportStateCreateInfo-flags", offsetof( struct VkPipelineViewportStateCreateInfo, flags ), sizeof( VkPipelineViewportStateCreateFlags ) );
	swigStructField( "VkPipelineViewportStateCreateInfo-pViewports", offsetof( struct VkPipelineViewportStateCreateInfo, pViewports ), sizeof( VkViewport const * ) );
	swigStructField( "VkPipelineViewportStateCreateInfo-viewportCount", offsetof( struct VkPipelineViewportStateCreateInfo, viewportCount ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineViewportStateCreateInfo ) );

	swigComment("struct VkPipelineRasterizationStateCreateInfo\n");
	printf( "begin-structure VkPipelineRasterizationStateCreateInfo\n" );
	swigStructField( "VkPipelineRasterizationStateCreateInfo-frontFace", offsetof( struct VkPipelineRasterizationStateCreateInfo, frontFace ), sizeof( VkFrontFace ) );
	swigStructField( "VkPipelineRasterizationStateCreateInfo-lineWidth", offsetof( struct VkPipelineRasterizationStateCreateInfo, lineWidth ), sizeof( float ) );
	swigStructField( "VkPipelineRasterizationStateCreateInfo-pNext", offsetof( struct VkPipelineRasterizationStateCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkPipelineRasterizationStateCreateInfo-depthBiasConstantFactor", offsetof( struct VkPipelineRasterizationStateCreateInfo, depthBiasConstantFactor ), sizeof( float ) );
	swigStructField( "VkPipelineRasterizationStateCreateInfo-depthBiasClamp", offsetof( struct VkPipelineRasterizationStateCreateInfo, depthBiasClamp ), sizeof( float ) );
	swigStructField( "VkPipelineRasterizationStateCreateInfo-depthClampEnable", offsetof( struct VkPipelineRasterizationStateCreateInfo, depthClampEnable ), sizeof( VkBool32 ) );
	swigStructField( "VkPipelineRasterizationStateCreateInfo-rasterizerDiscardEnable", offsetof( struct VkPipelineRasterizationStateCreateInfo, rasterizerDiscardEnable ), sizeof( VkBool32 ) );
	swigStructField( "VkPipelineRasterizationStateCreateInfo-depthBiasSlopeFactor", offsetof( struct VkPipelineRasterizationStateCreateInfo, depthBiasSlopeFactor ), sizeof( float ) );
	swigStructField( "VkPipelineRasterizationStateCreateInfo-polygonMode", offsetof( struct VkPipelineRasterizationStateCreateInfo, polygonMode ), sizeof( VkPolygonMode ) );
	swigStructField( "VkPipelineRasterizationStateCreateInfo-cullMode", offsetof( struct VkPipelineRasterizationStateCreateInfo, cullMode ), sizeof( VkCullModeFlags ) );
	swigStructField( "VkPipelineRasterizationStateCreateInfo-depthBiasEnable", offsetof( struct VkPipelineRasterizationStateCreateInfo, depthBiasEnable ), sizeof( VkBool32 ) );
	swigStructField( "VkPipelineRasterizationStateCreateInfo-sType", offsetof( struct VkPipelineRasterizationStateCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPipelineRasterizationStateCreateInfo-flags", offsetof( struct VkPipelineRasterizationStateCreateInfo, flags ), sizeof( VkPipelineRasterizationStateCreateFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineRasterizationStateCreateInfo ) );

	swigComment("struct VkPipelineMultisampleStateCreateInfo\n");
	printf( "begin-structure VkPipelineMultisampleStateCreateInfo\n" );
	swigStructField( "VkPipelineMultisampleStateCreateInfo-pSampleMask", offsetof( struct VkPipelineMultisampleStateCreateInfo, pSampleMask ), sizeof( VkSampleMask const * ) );
	swigStructField( "VkPipelineMultisampleStateCreateInfo-pNext", offsetof( struct VkPipelineMultisampleStateCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkPipelineMultisampleStateCreateInfo-sampleShadingEnable", offsetof( struct VkPipelineMultisampleStateCreateInfo, sampleShadingEnable ), sizeof( VkBool32 ) );
	swigStructField( "VkPipelineMultisampleStateCreateInfo-alphaToCoverageEnable", offsetof( struct VkPipelineMultisampleStateCreateInfo, alphaToCoverageEnable ), sizeof( VkBool32 ) );
	swigStructField( "VkPipelineMultisampleStateCreateInfo-alphaToOneEnable", offsetof( struct VkPipelineMultisampleStateCreateInfo, alphaToOneEnable ), sizeof( VkBool32 ) );
	swigStructField( "VkPipelineMultisampleStateCreateInfo-rasterizationSamples", offsetof( struct VkPipelineMultisampleStateCreateInfo, rasterizationSamples ), sizeof( VkSampleCountFlagBits ) );
	swigStructField( "VkPipelineMultisampleStateCreateInfo-minSampleShading", offsetof( struct VkPipelineMultisampleStateCreateInfo, minSampleShading ), sizeof( float ) );
	swigStructField( "VkPipelineMultisampleStateCreateInfo-sType", offsetof( struct VkPipelineMultisampleStateCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPipelineMultisampleStateCreateInfo-flags", offsetof( struct VkPipelineMultisampleStateCreateInfo, flags ), sizeof( VkPipelineMultisampleStateCreateFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineMultisampleStateCreateInfo ) );

	swigComment("struct VkStencilOpState\n");
	printf( "begin-structure VkStencilOpState\n" );
	swigStructField( "VkStencilOpState-depthFailOp", offsetof( struct VkStencilOpState, depthFailOp ), sizeof( VkStencilOp ) );
	swigStructField( "VkStencilOpState-writeMask", offsetof( struct VkStencilOpState, writeMask ), sizeof( uint32_t ) );
	swigStructField( "VkStencilOpState-failOp", offsetof( struct VkStencilOpState, failOp ), sizeof( VkStencilOp ) );
	swigStructField( "VkStencilOpState-compareOp", offsetof( struct VkStencilOpState, compareOp ), sizeof( VkCompareOp ) );
	swigStructField( "VkStencilOpState-passOp", offsetof( struct VkStencilOpState, passOp ), sizeof( VkStencilOp ) );
	swigStructField( "VkStencilOpState-compareMask", offsetof( struct VkStencilOpState, compareMask ), sizeof( uint32_t ) );
	swigStructField( "VkStencilOpState-reference", offsetof( struct VkStencilOpState, reference ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkStencilOpState ) );

	swigComment("struct VkPipelineDepthStencilStateCreateInfo\n");
	printf( "begin-structure VkPipelineDepthStencilStateCreateInfo\n" );
	swigStructField( "VkPipelineDepthStencilStateCreateInfo-pNext", offsetof( struct VkPipelineDepthStencilStateCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkPipelineDepthStencilStateCreateInfo-depthTestEnable", offsetof( struct VkPipelineDepthStencilStateCreateInfo, depthTestEnable ), sizeof( VkBool32 ) );
	swigStructField( "VkPipelineDepthStencilStateCreateInfo-depthCompareOp", offsetof( struct VkPipelineDepthStencilStateCreateInfo, depthCompareOp ), sizeof( VkCompareOp ) );
	swigStructField( "VkPipelineDepthStencilStateCreateInfo-depthBoundsTestEnable", offsetof( struct VkPipelineDepthStencilStateCreateInfo, depthBoundsTestEnable ), sizeof( VkBool32 ) );
	swigStructField( "VkPipelineDepthStencilStateCreateInfo-stencilTestEnable", offsetof( struct VkPipelineDepthStencilStateCreateInfo, stencilTestEnable ), sizeof( VkBool32 ) );
	swigStructField( "VkPipelineDepthStencilStateCreateInfo-depthWriteEnable", offsetof( struct VkPipelineDepthStencilStateCreateInfo, depthWriteEnable ), sizeof( VkBool32 ) );
	swigStructField( "VkPipelineDepthStencilStateCreateInfo-back", offsetof( struct VkPipelineDepthStencilStateCreateInfo, back ), sizeof( VkStencilOpState ) );
	swigStructField( "VkPipelineDepthStencilStateCreateInfo-sType", offsetof( struct VkPipelineDepthStencilStateCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPipelineDepthStencilStateCreateInfo-flags", offsetof( struct VkPipelineDepthStencilStateCreateInfo, flags ), sizeof( VkPipelineDepthStencilStateCreateFlags ) );
	swigStructField( "VkPipelineDepthStencilStateCreateInfo-front", offsetof( struct VkPipelineDepthStencilStateCreateInfo, front ), sizeof( VkStencilOpState ) );
	swigStructField( "VkPipelineDepthStencilStateCreateInfo-minDepthBounds", offsetof( struct VkPipelineDepthStencilStateCreateInfo, minDepthBounds ), sizeof( float ) );
	swigStructField( "VkPipelineDepthStencilStateCreateInfo-maxDepthBounds", offsetof( struct VkPipelineDepthStencilStateCreateInfo, maxDepthBounds ), sizeof( float ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineDepthStencilStateCreateInfo ) );

	swigComment("struct VkPipelineColorBlendAttachmentState\n");
	printf( "begin-structure VkPipelineColorBlendAttachmentState\n" );
	swigStructField( "VkPipelineColorBlendAttachmentState-srcColorBlendFactor", offsetof( struct VkPipelineColorBlendAttachmentState, srcColorBlendFactor ), sizeof( VkBlendFactor ) );
	swigStructField( "VkPipelineColorBlendAttachmentState-dstColorBlendFactor", offsetof( struct VkPipelineColorBlendAttachmentState, dstColorBlendFactor ), sizeof( VkBlendFactor ) );
	swigStructField( "VkPipelineColorBlendAttachmentState-srcAlphaBlendFactor", offsetof( struct VkPipelineColorBlendAttachmentState, srcAlphaBlendFactor ), sizeof( VkBlendFactor ) );
	swigStructField( "VkPipelineColorBlendAttachmentState-dstAlphaBlendFactor", offsetof( struct VkPipelineColorBlendAttachmentState, dstAlphaBlendFactor ), sizeof( VkBlendFactor ) );
	swigStructField( "VkPipelineColorBlendAttachmentState-colorWriteMask", offsetof( struct VkPipelineColorBlendAttachmentState, colorWriteMask ), sizeof( VkColorComponentFlags ) );
	swigStructField( "VkPipelineColorBlendAttachmentState-blendEnable", offsetof( struct VkPipelineColorBlendAttachmentState, blendEnable ), sizeof( VkBool32 ) );
	swigStructField( "VkPipelineColorBlendAttachmentState-colorBlendOp", offsetof( struct VkPipelineColorBlendAttachmentState, colorBlendOp ), sizeof( VkBlendOp ) );
	swigStructField( "VkPipelineColorBlendAttachmentState-alphaBlendOp", offsetof( struct VkPipelineColorBlendAttachmentState, alphaBlendOp ), sizeof( VkBlendOp ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineColorBlendAttachmentState ) );

	swigComment("struct VkPipelineColorBlendStateCreateInfo\n");
	printf( "begin-structure VkPipelineColorBlendStateCreateInfo\n" );
	swigStructField( "VkPipelineColorBlendStateCreateInfo-pNext", offsetof( struct VkPipelineColorBlendStateCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkPipelineColorBlendStateCreateInfo-pAttachments", offsetof( struct VkPipelineColorBlendStateCreateInfo, pAttachments ), sizeof( VkPipelineColorBlendAttachmentState const * ) );
	swigStructField( "VkPipelineColorBlendStateCreateInfo-logicOpEnable", offsetof( struct VkPipelineColorBlendStateCreateInfo, logicOpEnable ), sizeof( VkBool32 ) );
	swigStructField( "VkPipelineColorBlendStateCreateInfo-sType", offsetof( struct VkPipelineColorBlendStateCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPipelineColorBlendStateCreateInfo-flags", offsetof( struct VkPipelineColorBlendStateCreateInfo, flags ), sizeof( VkPipelineColorBlendStateCreateFlags ) );
	swigStructField( "VkPipelineColorBlendStateCreateInfo-logicOp", offsetof( struct VkPipelineColorBlendStateCreateInfo, logicOp ), sizeof( VkLogicOp ) );
	swigStructField( "VkPipelineColorBlendStateCreateInfo-attachmentCount", offsetof( struct VkPipelineColorBlendStateCreateInfo, attachmentCount ), sizeof( uint32_t ) );
	swigStructField( "VkPipelineColorBlendStateCreateInfo-blendConstants", offsetof( struct VkPipelineColorBlendStateCreateInfo, blendConstants ), sizeof( float [4] ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineColorBlendStateCreateInfo ) );

	swigComment("struct VkPipelineDynamicStateCreateInfo\n");
	printf( "begin-structure VkPipelineDynamicStateCreateInfo\n" );
	swigStructField( "VkPipelineDynamicStateCreateInfo-pDynamicStates", offsetof( struct VkPipelineDynamicStateCreateInfo, pDynamicStates ), sizeof( VkDynamicState const * ) );
	swigStructField( "VkPipelineDynamicStateCreateInfo-pNext", offsetof( struct VkPipelineDynamicStateCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkPipelineDynamicStateCreateInfo-dynamicStateCount", offsetof( struct VkPipelineDynamicStateCreateInfo, dynamicStateCount ), sizeof( uint32_t ) );
	swigStructField( "VkPipelineDynamicStateCreateInfo-sType", offsetof( struct VkPipelineDynamicStateCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPipelineDynamicStateCreateInfo-flags", offsetof( struct VkPipelineDynamicStateCreateInfo, flags ), sizeof( VkPipelineDynamicStateCreateFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineDynamicStateCreateInfo ) );

	swigComment("struct VkGraphicsPipelineCreateInfo\n");
	printf( "begin-structure VkGraphicsPipelineCreateInfo\n" );
	swigStructField( "VkGraphicsPipelineCreateInfo-pDynamicState", offsetof( struct VkGraphicsPipelineCreateInfo, pDynamicState ), sizeof( VkPipelineDynamicStateCreateInfo const * ) );
	swigStructField( "VkGraphicsPipelineCreateInfo-pVertexInputState", offsetof( struct VkGraphicsPipelineCreateInfo, pVertexInputState ), sizeof( VkPipelineVertexInputStateCreateInfo const * ) );
	swigStructField( "VkGraphicsPipelineCreateInfo-pMultisampleState", offsetof( struct VkGraphicsPipelineCreateInfo, pMultisampleState ), sizeof( VkPipelineMultisampleStateCreateInfo const * ) );
	swigStructField( "VkGraphicsPipelineCreateInfo-basePipelineHandle", offsetof( struct VkGraphicsPipelineCreateInfo, basePipelineHandle ), sizeof( VkPipeline ) );
	swigStructField( "VkGraphicsPipelineCreateInfo-basePipelineIndex", offsetof( struct VkGraphicsPipelineCreateInfo, basePipelineIndex ), sizeof( int32_t ) );
	swigStructField( "VkGraphicsPipelineCreateInfo-pDepthStencilState", offsetof( struct VkGraphicsPipelineCreateInfo, pDepthStencilState ), sizeof( VkPipelineDepthStencilStateCreateInfo const * ) );
	swigStructField( "VkGraphicsPipelineCreateInfo-renderPass", offsetof( struct VkGraphicsPipelineCreateInfo, renderPass ), sizeof( VkRenderPass ) );
	swigStructField( "VkGraphicsPipelineCreateInfo-subpass", offsetof( struct VkGraphicsPipelineCreateInfo, subpass ), sizeof( uint32_t ) );
	swigStructField( "VkGraphicsPipelineCreateInfo-pNext", offsetof( struct VkGraphicsPipelineCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkGraphicsPipelineCreateInfo-pRasterizationState", offsetof( struct VkGraphicsPipelineCreateInfo, pRasterizationState ), sizeof( VkPipelineRasterizationStateCreateInfo const * ) );
	swigStructField( "VkGraphicsPipelineCreateInfo-pTessellationState", offsetof( struct VkGraphicsPipelineCreateInfo, pTessellationState ), sizeof( VkPipelineTessellationStateCreateInfo const * ) );
	swigStructField( "VkGraphicsPipelineCreateInfo-pInputAssemblyState", offsetof( struct VkGraphicsPipelineCreateInfo, pInputAssemblyState ), sizeof( VkPipelineInputAssemblyStateCreateInfo const * ) );
	swigStructField( "VkGraphicsPipelineCreateInfo-flags", offsetof( struct VkGraphicsPipelineCreateInfo, flags ), sizeof( VkPipelineCreateFlags ) );
	swigStructField( "VkGraphicsPipelineCreateInfo-layout", offsetof( struct VkGraphicsPipelineCreateInfo, layout ), sizeof( VkPipelineLayout ) );
	swigStructField( "VkGraphicsPipelineCreateInfo-pViewportState", offsetof( struct VkGraphicsPipelineCreateInfo, pViewportState ), sizeof( VkPipelineViewportStateCreateInfo const * ) );
	swigStructField( "VkGraphicsPipelineCreateInfo-stageCount", offsetof( struct VkGraphicsPipelineCreateInfo, stageCount ), sizeof( uint32_t ) );
	swigStructField( "VkGraphicsPipelineCreateInfo-pColorBlendState", offsetof( struct VkGraphicsPipelineCreateInfo, pColorBlendState ), sizeof( VkPipelineColorBlendStateCreateInfo const * ) );
	swigStructField( "VkGraphicsPipelineCreateInfo-pStages", offsetof( struct VkGraphicsPipelineCreateInfo, pStages ), sizeof( VkPipelineShaderStageCreateInfo const * ) );
	swigStructField( "VkGraphicsPipelineCreateInfo-sType", offsetof( struct VkGraphicsPipelineCreateInfo, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkGraphicsPipelineCreateInfo ) );

	swigComment("struct VkPushConstantRange\n");
	printf( "begin-structure VkPushConstantRange\n" );
	swigStructField( "VkPushConstantRange-offset", offsetof( struct VkPushConstantRange, offset ), sizeof( uint32_t ) );
	swigStructField( "VkPushConstantRange-size", offsetof( struct VkPushConstantRange, size ), sizeof( uint32_t ) );
	swigStructField( "VkPushConstantRange-stageFlags", offsetof( struct VkPushConstantRange, stageFlags ), sizeof( VkShaderStageFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPushConstantRange ) );

	swigComment("struct VkPipelineLayoutCreateInfo\n");
	printf( "begin-structure VkPipelineLayoutCreateInfo\n" );
	swigStructField( "VkPipelineLayoutCreateInfo-pNext", offsetof( struct VkPipelineLayoutCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkPipelineLayoutCreateInfo-pushConstantRangeCount", offsetof( struct VkPipelineLayoutCreateInfo, pushConstantRangeCount ), sizeof( uint32_t ) );
	swigStructField( "VkPipelineLayoutCreateInfo-pSetLayouts", offsetof( struct VkPipelineLayoutCreateInfo, pSetLayouts ), sizeof( VkDescriptorSetLayout const * ) );
	swigStructField( "VkPipelineLayoutCreateInfo-sType", offsetof( struct VkPipelineLayoutCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPipelineLayoutCreateInfo-flags", offsetof( struct VkPipelineLayoutCreateInfo, flags ), sizeof( VkPipelineLayoutCreateFlags ) );
	swigStructField( "VkPipelineLayoutCreateInfo-setLayoutCount", offsetof( struct VkPipelineLayoutCreateInfo, setLayoutCount ), sizeof( uint32_t ) );
	swigStructField( "VkPipelineLayoutCreateInfo-pPushConstantRanges", offsetof( struct VkPipelineLayoutCreateInfo, pPushConstantRanges ), sizeof( VkPushConstantRange const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineLayoutCreateInfo ) );

	swigComment("struct VkSamplerCreateInfo\n");
	printf( "begin-structure VkSamplerCreateInfo\n" );
	swigStructField( "VkSamplerCreateInfo-borderColor", offsetof( struct VkSamplerCreateInfo, borderColor ), sizeof( VkBorderColor ) );
	swigStructField( "VkSamplerCreateInfo-minLod", offsetof( struct VkSamplerCreateInfo, minLod ), sizeof( float ) );
	swigStructField( "VkSamplerCreateInfo-addressModeU", offsetof( struct VkSamplerCreateInfo, addressModeU ), sizeof( VkSamplerAddressMode ) );
	swigStructField( "VkSamplerCreateInfo-addressModeV", offsetof( struct VkSamplerCreateInfo, addressModeV ), sizeof( VkSamplerAddressMode ) );
	swigStructField( "VkSamplerCreateInfo-pNext", offsetof( struct VkSamplerCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkSamplerCreateInfo-addressModeW", offsetof( struct VkSamplerCreateInfo, addressModeW ), sizeof( VkSamplerAddressMode ) );
	swigStructField( "VkSamplerCreateInfo-maxAnisotropy", offsetof( struct VkSamplerCreateInfo, maxAnisotropy ), sizeof( float ) );
	swigStructField( "VkSamplerCreateInfo-compareEnable", offsetof( struct VkSamplerCreateInfo, compareEnable ), sizeof( VkBool32 ) );
	swigStructField( "VkSamplerCreateInfo-anisotropyEnable", offsetof( struct VkSamplerCreateInfo, anisotropyEnable ), sizeof( VkBool32 ) );
	swigStructField( "VkSamplerCreateInfo-mipmapMode", offsetof( struct VkSamplerCreateInfo, mipmapMode ), sizeof( VkSamplerMipmapMode ) );
	swigStructField( "VkSamplerCreateInfo-magFilter", offsetof( struct VkSamplerCreateInfo, magFilter ), sizeof( VkFilter ) );
	swigStructField( "VkSamplerCreateInfo-compareOp", offsetof( struct VkSamplerCreateInfo, compareOp ), sizeof( VkCompareOp ) );
	swigStructField( "VkSamplerCreateInfo-mipLodBias", offsetof( struct VkSamplerCreateInfo, mipLodBias ), sizeof( float ) );
	swigStructField( "VkSamplerCreateInfo-flags", offsetof( struct VkSamplerCreateInfo, flags ), sizeof( VkSamplerCreateFlags ) );
	swigStructField( "VkSamplerCreateInfo-minFilter", offsetof( struct VkSamplerCreateInfo, minFilter ), sizeof( VkFilter ) );
	swigStructField( "VkSamplerCreateInfo-maxLod", offsetof( struct VkSamplerCreateInfo, maxLod ), sizeof( float ) );
	swigStructField( "VkSamplerCreateInfo-unnormalizedCoordinates", offsetof( struct VkSamplerCreateInfo, unnormalizedCoordinates ), sizeof( VkBool32 ) );
	swigStructField( "VkSamplerCreateInfo-sType", offsetof( struct VkSamplerCreateInfo, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSamplerCreateInfo ) );

	swigComment("struct VkCopyDescriptorSet\n");
	printf( "begin-structure VkCopyDescriptorSet\n" );
	swigStructField( "VkCopyDescriptorSet-srcArrayElement", offsetof( struct VkCopyDescriptorSet, srcArrayElement ), sizeof( uint32_t ) );
	swigStructField( "VkCopyDescriptorSet-dstArrayElement", offsetof( struct VkCopyDescriptorSet, dstArrayElement ), sizeof( uint32_t ) );
	swigStructField( "VkCopyDescriptorSet-pNext", offsetof( struct VkCopyDescriptorSet, pNext ), sizeof( void const * ) );
	swigStructField( "VkCopyDescriptorSet-descriptorCount", offsetof( struct VkCopyDescriptorSet, descriptorCount ), sizeof( uint32_t ) );
	swigStructField( "VkCopyDescriptorSet-srcBinding", offsetof( struct VkCopyDescriptorSet, srcBinding ), sizeof( uint32_t ) );
	swigStructField( "VkCopyDescriptorSet-dstBinding", offsetof( struct VkCopyDescriptorSet, dstBinding ), sizeof( uint32_t ) );
	swigStructField( "VkCopyDescriptorSet-dstSet", offsetof( struct VkCopyDescriptorSet, dstSet ), sizeof( VkDescriptorSet ) );
	swigStructField( "VkCopyDescriptorSet-sType", offsetof( struct VkCopyDescriptorSet, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkCopyDescriptorSet-srcSet", offsetof( struct VkCopyDescriptorSet, srcSet ), sizeof( VkDescriptorSet ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkCopyDescriptorSet ) );

	swigComment("struct VkDescriptorBufferInfo\n");
	printf( "begin-structure VkDescriptorBufferInfo\n" );
	swigStructField( "VkDescriptorBufferInfo-buffer", offsetof( struct VkDescriptorBufferInfo, buffer ), sizeof( VkBuffer ) );
	swigStructField( "VkDescriptorBufferInfo-offset", offsetof( struct VkDescriptorBufferInfo, offset ), sizeof( VkDeviceSize ) );
	swigStructField( "VkDescriptorBufferInfo-range", offsetof( struct VkDescriptorBufferInfo, range ), sizeof( VkDeviceSize ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDescriptorBufferInfo ) );

	swigComment("struct VkDescriptorImageInfo\n");
	printf( "begin-structure VkDescriptorImageInfo\n" );
	swigStructField( "VkDescriptorImageInfo-sampler", offsetof( struct VkDescriptorImageInfo, sampler ), sizeof( VkSampler ) );
	swigStructField( "VkDescriptorImageInfo-imageLayout", offsetof( struct VkDescriptorImageInfo, imageLayout ), sizeof( VkImageLayout ) );
	swigStructField( "VkDescriptorImageInfo-imageView", offsetof( struct VkDescriptorImageInfo, imageView ), sizeof( VkImageView ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDescriptorImageInfo ) );

	swigComment("struct VkDescriptorPoolSize\n");
	printf( "begin-structure VkDescriptorPoolSize\n" );
	swigStructField( "VkDescriptorPoolSize-descriptorCount", offsetof( struct VkDescriptorPoolSize, descriptorCount ), sizeof( uint32_t ) );
	swigStructField( "VkDescriptorPoolSize-type", offsetof( struct VkDescriptorPoolSize, type ), sizeof( VkDescriptorType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDescriptorPoolSize ) );

	swigComment("struct VkDescriptorPoolCreateInfo\n");
	printf( "begin-structure VkDescriptorPoolCreateInfo\n" );
	swigStructField( "VkDescriptorPoolCreateInfo-pNext", offsetof( struct VkDescriptorPoolCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkDescriptorPoolCreateInfo-maxSets", offsetof( struct VkDescriptorPoolCreateInfo, maxSets ), sizeof( uint32_t ) );
	swigStructField( "VkDescriptorPoolCreateInfo-poolSizeCount", offsetof( struct VkDescriptorPoolCreateInfo, poolSizeCount ), sizeof( uint32_t ) );
	swigStructField( "VkDescriptorPoolCreateInfo-sType", offsetof( struct VkDescriptorPoolCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkDescriptorPoolCreateInfo-flags", offsetof( struct VkDescriptorPoolCreateInfo, flags ), sizeof( VkDescriptorPoolCreateFlags ) );
	swigStructField( "VkDescriptorPoolCreateInfo-pPoolSizes", offsetof( struct VkDescriptorPoolCreateInfo, pPoolSizes ), sizeof( VkDescriptorPoolSize const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDescriptorPoolCreateInfo ) );

	swigComment("struct VkDescriptorSetAllocateInfo\n");
	printf( "begin-structure VkDescriptorSetAllocateInfo\n" );
	swigStructField( "VkDescriptorSetAllocateInfo-pNext", offsetof( struct VkDescriptorSetAllocateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkDescriptorSetAllocateInfo-descriptorPool", offsetof( struct VkDescriptorSetAllocateInfo, descriptorPool ), sizeof( VkDescriptorPool ) );
	swigStructField( "VkDescriptorSetAllocateInfo-pSetLayouts", offsetof( struct VkDescriptorSetAllocateInfo, pSetLayouts ), sizeof( VkDescriptorSetLayout const * ) );
	swigStructField( "VkDescriptorSetAllocateInfo-sType", offsetof( struct VkDescriptorSetAllocateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkDescriptorSetAllocateInfo-descriptorSetCount", offsetof( struct VkDescriptorSetAllocateInfo, descriptorSetCount ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDescriptorSetAllocateInfo ) );

	swigComment("struct VkDescriptorSetLayoutBinding\n");
	printf( "begin-structure VkDescriptorSetLayoutBinding\n" );
	swigStructField( "VkDescriptorSetLayoutBinding-descriptorCount", offsetof( struct VkDescriptorSetLayoutBinding, descriptorCount ), sizeof( uint32_t ) );
	swigStructField( "VkDescriptorSetLayoutBinding-binding", offsetof( struct VkDescriptorSetLayoutBinding, binding ), sizeof( uint32_t ) );
	swigStructField( "VkDescriptorSetLayoutBinding-descriptorType", offsetof( struct VkDescriptorSetLayoutBinding, descriptorType ), sizeof( VkDescriptorType ) );
	swigStructField( "VkDescriptorSetLayoutBinding-pImmutableSamplers", offsetof( struct VkDescriptorSetLayoutBinding, pImmutableSamplers ), sizeof( VkSampler const * ) );
	swigStructField( "VkDescriptorSetLayoutBinding-stageFlags", offsetof( struct VkDescriptorSetLayoutBinding, stageFlags ), sizeof( VkShaderStageFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDescriptorSetLayoutBinding ) );

	swigComment("struct VkDescriptorSetLayoutCreateInfo\n");
	printf( "begin-structure VkDescriptorSetLayoutCreateInfo\n" );
	swigStructField( "VkDescriptorSetLayoutCreateInfo-pNext", offsetof( struct VkDescriptorSetLayoutCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkDescriptorSetLayoutCreateInfo-bindingCount", offsetof( struct VkDescriptorSetLayoutCreateInfo, bindingCount ), sizeof( uint32_t ) );
	swigStructField( "VkDescriptorSetLayoutCreateInfo-sType", offsetof( struct VkDescriptorSetLayoutCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkDescriptorSetLayoutCreateInfo-flags", offsetof( struct VkDescriptorSetLayoutCreateInfo, flags ), sizeof( VkDescriptorSetLayoutCreateFlags ) );
	swigStructField( "VkDescriptorSetLayoutCreateInfo-pBindings", offsetof( struct VkDescriptorSetLayoutCreateInfo, pBindings ), sizeof( VkDescriptorSetLayoutBinding const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDescriptorSetLayoutCreateInfo ) );

	swigComment("struct VkWriteDescriptorSet\n");
	printf( "begin-structure VkWriteDescriptorSet\n" );
	swigStructField( "VkWriteDescriptorSet-dstArrayElement", offsetof( struct VkWriteDescriptorSet, dstArrayElement ), sizeof( uint32_t ) );
	swigStructField( "VkWriteDescriptorSet-pNext", offsetof( struct VkWriteDescriptorSet, pNext ), sizeof( void const * ) );
	swigStructField( "VkWriteDescriptorSet-descriptorCount", offsetof( struct VkWriteDescriptorSet, descriptorCount ), sizeof( uint32_t ) );
	swigStructField( "VkWriteDescriptorSet-dstBinding", offsetof( struct VkWriteDescriptorSet, dstBinding ), sizeof( uint32_t ) );
	swigStructField( "VkWriteDescriptorSet-dstSet", offsetof( struct VkWriteDescriptorSet, dstSet ), sizeof( VkDescriptorSet ) );
	swigStructField( "VkWriteDescriptorSet-descriptorType", offsetof( struct VkWriteDescriptorSet, descriptorType ), sizeof( VkDescriptorType ) );
	swigStructField( "VkWriteDescriptorSet-sType", offsetof( struct VkWriteDescriptorSet, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkWriteDescriptorSet-pImageInfo", offsetof( struct VkWriteDescriptorSet, pImageInfo ), sizeof( VkDescriptorImageInfo const * ) );
	swigStructField( "VkWriteDescriptorSet-pBufferInfo", offsetof( struct VkWriteDescriptorSet, pBufferInfo ), sizeof( VkDescriptorBufferInfo const * ) );
	swigStructField( "VkWriteDescriptorSet-pTexelBufferView", offsetof( struct VkWriteDescriptorSet, pTexelBufferView ), sizeof( VkBufferView const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkWriteDescriptorSet ) );

	swigComment("struct VkAttachmentDescription\n");
	printf( "begin-structure VkAttachmentDescription\n" );
	swigStructField( "VkAttachmentDescription-initialLayout", offsetof( struct VkAttachmentDescription, initialLayout ), sizeof( VkImageLayout ) );
	swigStructField( "VkAttachmentDescription-finalLayout", offsetof( struct VkAttachmentDescription, finalLayout ), sizeof( VkImageLayout ) );
	swigStructField( "VkAttachmentDescription-storeOp", offsetof( struct VkAttachmentDescription, storeOp ), sizeof( VkAttachmentStoreOp ) );
	swigStructField( "VkAttachmentDescription-stencilLoadOp", offsetof( struct VkAttachmentDescription, stencilLoadOp ), sizeof( VkAttachmentLoadOp ) );
	swigStructField( "VkAttachmentDescription-stencilStoreOp", offsetof( struct VkAttachmentDescription, stencilStoreOp ), sizeof( VkAttachmentStoreOp ) );
	swigStructField( "VkAttachmentDescription-samples", offsetof( struct VkAttachmentDescription, samples ), sizeof( VkSampleCountFlagBits ) );
	swigStructField( "VkAttachmentDescription-loadOp", offsetof( struct VkAttachmentDescription, loadOp ), sizeof( VkAttachmentLoadOp ) );
	swigStructField( "VkAttachmentDescription-flags", offsetof( struct VkAttachmentDescription, flags ), sizeof( VkAttachmentDescriptionFlags ) );
	swigStructField( "VkAttachmentDescription-format", offsetof( struct VkAttachmentDescription, format ), sizeof( VkFormat ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkAttachmentDescription ) );

	swigComment("struct VkAttachmentReference\n");
	printf( "begin-structure VkAttachmentReference\n" );
	swigStructField( "VkAttachmentReference-attachment", offsetof( struct VkAttachmentReference, attachment ), sizeof( uint32_t ) );
	swigStructField( "VkAttachmentReference-layout", offsetof( struct VkAttachmentReference, layout ), sizeof( VkImageLayout ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkAttachmentReference ) );

	swigComment("struct VkFramebufferCreateInfo\n");
	printf( "begin-structure VkFramebufferCreateInfo\n" );
	swigStructField( "VkFramebufferCreateInfo-renderPass", offsetof( struct VkFramebufferCreateInfo, renderPass ), sizeof( VkRenderPass ) );
	swigStructField( "VkFramebufferCreateInfo-pNext", offsetof( struct VkFramebufferCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkFramebufferCreateInfo-pAttachments", offsetof( struct VkFramebufferCreateInfo, pAttachments ), sizeof( VkImageView const * ) );
	swigStructField( "VkFramebufferCreateInfo-height", offsetof( struct VkFramebufferCreateInfo, height ), sizeof( uint32_t ) );
	swigStructField( "VkFramebufferCreateInfo-sType", offsetof( struct VkFramebufferCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkFramebufferCreateInfo-flags", offsetof( struct VkFramebufferCreateInfo, flags ), sizeof( VkFramebufferCreateFlags ) );
	swigStructField( "VkFramebufferCreateInfo-width", offsetof( struct VkFramebufferCreateInfo, width ), sizeof( uint32_t ) );
	swigStructField( "VkFramebufferCreateInfo-layers", offsetof( struct VkFramebufferCreateInfo, layers ), sizeof( uint32_t ) );
	swigStructField( "VkFramebufferCreateInfo-attachmentCount", offsetof( struct VkFramebufferCreateInfo, attachmentCount ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkFramebufferCreateInfo ) );

	swigComment("struct VkSubpassDescription\n");
	printf( "begin-structure VkSubpassDescription\n" );
	swigStructField( "VkSubpassDescription-pInputAttachments", offsetof( struct VkSubpassDescription, pInputAttachments ), sizeof( VkAttachmentReference const * ) );
	swigStructField( "VkSubpassDescription-pColorAttachments", offsetof( struct VkSubpassDescription, pColorAttachments ), sizeof( VkAttachmentReference const * ) );
	swigStructField( "VkSubpassDescription-pResolveAttachments", offsetof( struct VkSubpassDescription, pResolveAttachments ), sizeof( VkAttachmentReference const * ) );
	swigStructField( "VkSubpassDescription-pDepthStencilAttachment", offsetof( struct VkSubpassDescription, pDepthStencilAttachment ), sizeof( VkAttachmentReference const * ) );
	swigStructField( "VkSubpassDescription-pPreserveAttachments", offsetof( struct VkSubpassDescription, pPreserveAttachments ), sizeof( uint32_t const * ) );
	swigStructField( "VkSubpassDescription-pipelineBindPoint", offsetof( struct VkSubpassDescription, pipelineBindPoint ), sizeof( VkPipelineBindPoint ) );
	swigStructField( "VkSubpassDescription-flags", offsetof( struct VkSubpassDescription, flags ), sizeof( VkSubpassDescriptionFlags ) );
	swigStructField( "VkSubpassDescription-inputAttachmentCount", offsetof( struct VkSubpassDescription, inputAttachmentCount ), sizeof( uint32_t ) );
	swigStructField( "VkSubpassDescription-colorAttachmentCount", offsetof( struct VkSubpassDescription, colorAttachmentCount ), sizeof( uint32_t ) );
	swigStructField( "VkSubpassDescription-preserveAttachmentCount", offsetof( struct VkSubpassDescription, preserveAttachmentCount ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSubpassDescription ) );

	swigComment("struct VkSubpassDependency\n");
	printf( "begin-structure VkSubpassDependency\n" );
	swigStructField( "VkSubpassDependency-srcStageMask", offsetof( struct VkSubpassDependency, srcStageMask ), sizeof( VkPipelineStageFlags ) );
	swigStructField( "VkSubpassDependency-dstStageMask", offsetof( struct VkSubpassDependency, dstStageMask ), sizeof( VkPipelineStageFlags ) );
	swigStructField( "VkSubpassDependency-dependencyFlags", offsetof( struct VkSubpassDependency, dependencyFlags ), sizeof( VkDependencyFlags ) );
	swigStructField( "VkSubpassDependency-srcSubpass", offsetof( struct VkSubpassDependency, srcSubpass ), sizeof( uint32_t ) );
	swigStructField( "VkSubpassDependency-dstSubpass", offsetof( struct VkSubpassDependency, dstSubpass ), sizeof( uint32_t ) );
	swigStructField( "VkSubpassDependency-srcAccessMask", offsetof( struct VkSubpassDependency, srcAccessMask ), sizeof( VkAccessFlags ) );
	swigStructField( "VkSubpassDependency-dstAccessMask", offsetof( struct VkSubpassDependency, dstAccessMask ), sizeof( VkAccessFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSubpassDependency ) );

	swigComment("struct VkRenderPassCreateInfo\n");
	printf( "begin-structure VkRenderPassCreateInfo\n" );
	swigStructField( "VkRenderPassCreateInfo-pNext", offsetof( struct VkRenderPassCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkRenderPassCreateInfo-pAttachments", offsetof( struct VkRenderPassCreateInfo, pAttachments ), sizeof( VkAttachmentDescription const * ) );
	swigStructField( "VkRenderPassCreateInfo-dependencyCount", offsetof( struct VkRenderPassCreateInfo, dependencyCount ), sizeof( uint32_t ) );
	swigStructField( "VkRenderPassCreateInfo-subpassCount", offsetof( struct VkRenderPassCreateInfo, subpassCount ), sizeof( uint32_t ) );
	swigStructField( "VkRenderPassCreateInfo-pSubpasses", offsetof( struct VkRenderPassCreateInfo, pSubpasses ), sizeof( VkSubpassDescription const * ) );
	swigStructField( "VkRenderPassCreateInfo-sType", offsetof( struct VkRenderPassCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkRenderPassCreateInfo-flags", offsetof( struct VkRenderPassCreateInfo, flags ), sizeof( VkRenderPassCreateFlags ) );
	swigStructField( "VkRenderPassCreateInfo-pDependencies", offsetof( struct VkRenderPassCreateInfo, pDependencies ), sizeof( VkSubpassDependency const * ) );
	swigStructField( "VkRenderPassCreateInfo-attachmentCount", offsetof( struct VkRenderPassCreateInfo, attachmentCount ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkRenderPassCreateInfo ) );

	swigComment("struct VkCommandPoolCreateInfo\n");
	printf( "begin-structure VkCommandPoolCreateInfo\n" );
	swigStructField( "VkCommandPoolCreateInfo-pNext", offsetof( struct VkCommandPoolCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkCommandPoolCreateInfo-queueFamilyIndex", offsetof( struct VkCommandPoolCreateInfo, queueFamilyIndex ), sizeof( uint32_t ) );
	swigStructField( "VkCommandPoolCreateInfo-sType", offsetof( struct VkCommandPoolCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkCommandPoolCreateInfo-flags", offsetof( struct VkCommandPoolCreateInfo, flags ), sizeof( VkCommandPoolCreateFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkCommandPoolCreateInfo ) );

	swigComment("struct VkCommandBufferAllocateInfo\n");
	printf( "begin-structure VkCommandBufferAllocateInfo\n" );
	swigStructField( "VkCommandBufferAllocateInfo-level", offsetof( struct VkCommandBufferAllocateInfo, level ), sizeof( VkCommandBufferLevel ) );
	swigStructField( "VkCommandBufferAllocateInfo-pNext", offsetof( struct VkCommandBufferAllocateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkCommandBufferAllocateInfo-commandPool", offsetof( struct VkCommandBufferAllocateInfo, commandPool ), sizeof( VkCommandPool ) );
	swigStructField( "VkCommandBufferAllocateInfo-commandBufferCount", offsetof( struct VkCommandBufferAllocateInfo, commandBufferCount ), sizeof( uint32_t ) );
	swigStructField( "VkCommandBufferAllocateInfo-sType", offsetof( struct VkCommandBufferAllocateInfo, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkCommandBufferAllocateInfo ) );

	swigComment("struct VkCommandBufferInheritanceInfo\n");
	printf( "begin-structure VkCommandBufferInheritanceInfo\n" );
	swigStructField( "VkCommandBufferInheritanceInfo-renderPass", offsetof( struct VkCommandBufferInheritanceInfo, renderPass ), sizeof( VkRenderPass ) );
	swigStructField( "VkCommandBufferInheritanceInfo-pipelineStatistics", offsetof( struct VkCommandBufferInheritanceInfo, pipelineStatistics ), sizeof( VkQueryPipelineStatisticFlags ) );
	swigStructField( "VkCommandBufferInheritanceInfo-pNext", offsetof( struct VkCommandBufferInheritanceInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkCommandBufferInheritanceInfo-framebuffer", offsetof( struct VkCommandBufferInheritanceInfo, framebuffer ), sizeof( VkFramebuffer ) );
	swigStructField( "VkCommandBufferInheritanceInfo-occlusionQueryEnable", offsetof( struct VkCommandBufferInheritanceInfo, occlusionQueryEnable ), sizeof( VkBool32 ) );
	swigStructField( "VkCommandBufferInheritanceInfo-sType", offsetof( struct VkCommandBufferInheritanceInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkCommandBufferInheritanceInfo-queryFlags", offsetof( struct VkCommandBufferInheritanceInfo, queryFlags ), sizeof( VkQueryControlFlags ) );
	swigStructField( "VkCommandBufferInheritanceInfo-subpass", offsetof( struct VkCommandBufferInheritanceInfo, subpass ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkCommandBufferInheritanceInfo ) );

	swigComment("struct VkCommandBufferBeginInfo\n");
	printf( "begin-structure VkCommandBufferBeginInfo\n" );
	swigStructField( "VkCommandBufferBeginInfo-pNext", offsetof( struct VkCommandBufferBeginInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkCommandBufferBeginInfo-sType", offsetof( struct VkCommandBufferBeginInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkCommandBufferBeginInfo-flags", offsetof( struct VkCommandBufferBeginInfo, flags ), sizeof( VkCommandBufferUsageFlags ) );
	swigStructField( "VkCommandBufferBeginInfo-pInheritanceInfo", offsetof( struct VkCommandBufferBeginInfo, pInheritanceInfo ), sizeof( VkCommandBufferInheritanceInfo const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkCommandBufferBeginInfo ) );

	swigComment("struct VkBufferCopy\n");
	printf( "begin-structure VkBufferCopy\n" );
	swigStructField( "VkBufferCopy-dstOffset", offsetof( struct VkBufferCopy, dstOffset ), sizeof( VkDeviceSize ) );
	swigStructField( "VkBufferCopy-srcOffset", offsetof( struct VkBufferCopy, srcOffset ), sizeof( VkDeviceSize ) );
	swigStructField( "VkBufferCopy-size", offsetof( struct VkBufferCopy, size ), sizeof( VkDeviceSize ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkBufferCopy ) );

	swigComment("struct VkImageSubresourceLayers\n");
	printf( "begin-structure VkImageSubresourceLayers\n" );
	swigStructField( "VkImageSubresourceLayers-baseArrayLayer", offsetof( struct VkImageSubresourceLayers, baseArrayLayer ), sizeof( uint32_t ) );
	swigStructField( "VkImageSubresourceLayers-layerCount", offsetof( struct VkImageSubresourceLayers, layerCount ), sizeof( uint32_t ) );
	swigStructField( "VkImageSubresourceLayers-mipLevel", offsetof( struct VkImageSubresourceLayers, mipLevel ), sizeof( uint32_t ) );
	swigStructField( "VkImageSubresourceLayers-aspectMask", offsetof( struct VkImageSubresourceLayers, aspectMask ), sizeof( VkImageAspectFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkImageSubresourceLayers ) );

	swigComment("struct VkBufferImageCopy\n");
	printf( "begin-structure VkBufferImageCopy\n" );
	swigStructField( "VkBufferImageCopy-imageExtent", offsetof( struct VkBufferImageCopy, imageExtent ), sizeof( VkExtent3D ) );
	swigStructField( "VkBufferImageCopy-imageSubresource", offsetof( struct VkBufferImageCopy, imageSubresource ), sizeof( VkImageSubresourceLayers ) );
	swigStructField( "VkBufferImageCopy-bufferOffset", offsetof( struct VkBufferImageCopy, bufferOffset ), sizeof( VkDeviceSize ) );
	swigStructField( "VkBufferImageCopy-imageOffset", offsetof( struct VkBufferImageCopy, imageOffset ), sizeof( VkOffset3D ) );
	swigStructField( "VkBufferImageCopy-bufferRowLength", offsetof( struct VkBufferImageCopy, bufferRowLength ), sizeof( uint32_t ) );
	swigStructField( "VkBufferImageCopy-bufferImageHeight", offsetof( struct VkBufferImageCopy, bufferImageHeight ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkBufferImageCopy ) );

	swigComment("union VkClearColorValue\n");
	printf( "begin-structure VkClearColorValue\n" );
	swigStructField( "VkClearColorValue-int32", offsetof( union VkClearColorValue, int32 ), sizeof( int32_t [4] ) );
	swigStructField( "VkClearColorValue-float32", offsetof( union VkClearColorValue, float32 ), sizeof( float [4] ) );
	swigStructField( "VkClearColorValue-uint32", offsetof( union VkClearColorValue, uint32 ), sizeof( uint32_t [4] ) );
	printf( "drop %zu end-structure\n", sizeof( union VkClearColorValue ) );

	swigComment("struct VkClearDepthStencilValue\n");
	printf( "begin-structure VkClearDepthStencilValue\n" );
	swigStructField( "VkClearDepthStencilValue-depth", offsetof( struct VkClearDepthStencilValue, depth ), sizeof( float ) );
	swigStructField( "VkClearDepthStencilValue-stencil", offsetof( struct VkClearDepthStencilValue, stencil ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkClearDepthStencilValue ) );

	swigComment("union VkClearValue\n");
	printf( "begin-structure VkClearValue\n" );
	swigStructField( "VkClearValue-color", offsetof( union VkClearValue, color ), sizeof( VkClearColorValue ) );
	swigStructField( "VkClearValue-depthStencil", offsetof( union VkClearValue, depthStencil ), sizeof( VkClearDepthStencilValue ) );
	printf( "drop %zu end-structure\n", sizeof( union VkClearValue ) );

	swigComment("struct VkClearAttachment\n");
	printf( "begin-structure VkClearAttachment\n" );
	swigStructField( "VkClearAttachment-colorAttachment", offsetof( struct VkClearAttachment, colorAttachment ), sizeof( uint32_t ) );
	swigStructField( "VkClearAttachment-clearValue", offsetof( struct VkClearAttachment, clearValue ), sizeof( VkClearValue ) );
	swigStructField( "VkClearAttachment-aspectMask", offsetof( struct VkClearAttachment, aspectMask ), sizeof( VkImageAspectFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkClearAttachment ) );

	swigComment("struct VkClearRect\n");
	printf( "begin-structure VkClearRect\n" );
	swigStructField( "VkClearRect-baseArrayLayer", offsetof( struct VkClearRect, baseArrayLayer ), sizeof( uint32_t ) );
	swigStructField( "VkClearRect-layerCount", offsetof( struct VkClearRect, layerCount ), sizeof( uint32_t ) );
	swigStructField( "VkClearRect-rect", offsetof( struct VkClearRect, rect ), sizeof( VkRect2D ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkClearRect ) );

	swigComment("struct VkImageBlit\n");
	printf( "begin-structure VkImageBlit\n" );
	swigStructField( "VkImageBlit-srcOffsets", offsetof( struct VkImageBlit, srcOffsets ), sizeof( VkOffset3D [2] ) );
	swigStructField( "VkImageBlit-dstOffsets", offsetof( struct VkImageBlit, dstOffsets ), sizeof( VkOffset3D [2] ) );
	swigStructField( "VkImageBlit-srcSubresource", offsetof( struct VkImageBlit, srcSubresource ), sizeof( VkImageSubresourceLayers ) );
	swigStructField( "VkImageBlit-dstSubresource", offsetof( struct VkImageBlit, dstSubresource ), sizeof( VkImageSubresourceLayers ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkImageBlit ) );

	swigComment("struct VkImageCopy\n");
	printf( "begin-structure VkImageCopy\n" );
	swigStructField( "VkImageCopy-extent", offsetof( struct VkImageCopy, extent ), sizeof( VkExtent3D ) );
	swigStructField( "VkImageCopy-srcSubresource", offsetof( struct VkImageCopy, srcSubresource ), sizeof( VkImageSubresourceLayers ) );
	swigStructField( "VkImageCopy-dstSubresource", offsetof( struct VkImageCopy, dstSubresource ), sizeof( VkImageSubresourceLayers ) );
	swigStructField( "VkImageCopy-dstOffset", offsetof( struct VkImageCopy, dstOffset ), sizeof( VkOffset3D ) );
	swigStructField( "VkImageCopy-srcOffset", offsetof( struct VkImageCopy, srcOffset ), sizeof( VkOffset3D ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkImageCopy ) );

	swigComment("struct VkImageResolve\n");
	printf( "begin-structure VkImageResolve\n" );
	swigStructField( "VkImageResolve-extent", offsetof( struct VkImageResolve, extent ), sizeof( VkExtent3D ) );
	swigStructField( "VkImageResolve-srcSubresource", offsetof( struct VkImageResolve, srcSubresource ), sizeof( VkImageSubresourceLayers ) );
	swigStructField( "VkImageResolve-dstSubresource", offsetof( struct VkImageResolve, dstSubresource ), sizeof( VkImageSubresourceLayers ) );
	swigStructField( "VkImageResolve-dstOffset", offsetof( struct VkImageResolve, dstOffset ), sizeof( VkOffset3D ) );
	swigStructField( "VkImageResolve-srcOffset", offsetof( struct VkImageResolve, srcOffset ), sizeof( VkOffset3D ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkImageResolve ) );

	swigComment("struct VkRenderPassBeginInfo\n");
	printf( "begin-structure VkRenderPassBeginInfo\n" );
	swigStructField( "VkRenderPassBeginInfo-renderPass", offsetof( struct VkRenderPassBeginInfo, renderPass ), sizeof( VkRenderPass ) );
	swigStructField( "VkRenderPassBeginInfo-pNext", offsetof( struct VkRenderPassBeginInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkRenderPassBeginInfo-framebuffer", offsetof( struct VkRenderPassBeginInfo, framebuffer ), sizeof( VkFramebuffer ) );
	swigStructField( "VkRenderPassBeginInfo-renderArea", offsetof( struct VkRenderPassBeginInfo, renderArea ), sizeof( VkRect2D ) );
	swigStructField( "VkRenderPassBeginInfo-clearValueCount", offsetof( struct VkRenderPassBeginInfo, clearValueCount ), sizeof( uint32_t ) );
	swigStructField( "VkRenderPassBeginInfo-sType", offsetof( struct VkRenderPassBeginInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkRenderPassBeginInfo-pClearValues", offsetof( struct VkRenderPassBeginInfo, pClearValues ), sizeof( VkClearValue const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkRenderPassBeginInfo ) );

	swigComment("struct VkPhysicalDeviceSubgroupProperties\n");
	printf( "begin-structure VkPhysicalDeviceSubgroupProperties\n" );
	swigStructField( "VkPhysicalDeviceSubgroupProperties-subgroupSize", offsetof( struct VkPhysicalDeviceSubgroupProperties, subgroupSize ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceSubgroupProperties-pNext", offsetof( struct VkPhysicalDeviceSubgroupProperties, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceSubgroupProperties-supportedStages", offsetof( struct VkPhysicalDeviceSubgroupProperties, supportedStages ), sizeof( VkShaderStageFlags ) );
	swigStructField( "VkPhysicalDeviceSubgroupProperties-quadOperationsInAllStages", offsetof( struct VkPhysicalDeviceSubgroupProperties, quadOperationsInAllStages ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceSubgroupProperties-sType", offsetof( struct VkPhysicalDeviceSubgroupProperties, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDeviceSubgroupProperties-supportedOperations", offsetof( struct VkPhysicalDeviceSubgroupProperties, supportedOperations ), sizeof( VkSubgroupFeatureFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceSubgroupProperties ) );

	swigComment("struct VkBindBufferMemoryInfo\n");
	printf( "begin-structure VkBindBufferMemoryInfo\n" );
	swigStructField( "VkBindBufferMemoryInfo-pNext", offsetof( struct VkBindBufferMemoryInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkBindBufferMemoryInfo-buffer", offsetof( struct VkBindBufferMemoryInfo, buffer ), sizeof( VkBuffer ) );
	swigStructField( "VkBindBufferMemoryInfo-memory", offsetof( struct VkBindBufferMemoryInfo, memory ), sizeof( VkDeviceMemory ) );
	swigStructField( "VkBindBufferMemoryInfo-memoryOffset", offsetof( struct VkBindBufferMemoryInfo, memoryOffset ), sizeof( VkDeviceSize ) );
	swigStructField( "VkBindBufferMemoryInfo-sType", offsetof( struct VkBindBufferMemoryInfo, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkBindBufferMemoryInfo ) );

	swigComment("struct VkBindImageMemoryInfo\n");
	printf( "begin-structure VkBindImageMemoryInfo\n" );
	swigStructField( "VkBindImageMemoryInfo-pNext", offsetof( struct VkBindImageMemoryInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkBindImageMemoryInfo-memory", offsetof( struct VkBindImageMemoryInfo, memory ), sizeof( VkDeviceMemory ) );
	swigStructField( "VkBindImageMemoryInfo-memoryOffset", offsetof( struct VkBindImageMemoryInfo, memoryOffset ), sizeof( VkDeviceSize ) );
	swigStructField( "VkBindImageMemoryInfo-image", offsetof( struct VkBindImageMemoryInfo, image ), sizeof( VkImage ) );
	swigStructField( "VkBindImageMemoryInfo-sType", offsetof( struct VkBindImageMemoryInfo, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkBindImageMemoryInfo ) );

	swigComment("struct VkPhysicalDevice16BitStorageFeatures\n");
	printf( "begin-structure VkPhysicalDevice16BitStorageFeatures\n" );
	swigStructField( "VkPhysicalDevice16BitStorageFeatures-storageBuffer16BitAccess", offsetof( struct VkPhysicalDevice16BitStorageFeatures, storageBuffer16BitAccess ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDevice16BitStorageFeatures-uniformAndStorageBuffer16BitAccess", offsetof( struct VkPhysicalDevice16BitStorageFeatures, uniformAndStorageBuffer16BitAccess ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDevice16BitStorageFeatures-pNext", offsetof( struct VkPhysicalDevice16BitStorageFeatures, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDevice16BitStorageFeatures-storageInputOutput16", offsetof( struct VkPhysicalDevice16BitStorageFeatures, storageInputOutput16 ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDevice16BitStorageFeatures-sType", offsetof( struct VkPhysicalDevice16BitStorageFeatures, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDevice16BitStorageFeatures-storagePushConstant16", offsetof( struct VkPhysicalDevice16BitStorageFeatures, storagePushConstant16 ), sizeof( VkBool32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDevice16BitStorageFeatures ) );

	swigComment("struct VkMemoryDedicatedRequirements\n");
	printf( "begin-structure VkMemoryDedicatedRequirements\n" );
	swigStructField( "VkMemoryDedicatedRequirements-prefersDedicatedAllocation", offsetof( struct VkMemoryDedicatedRequirements, prefersDedicatedAllocation ), sizeof( VkBool32 ) );
	swigStructField( "VkMemoryDedicatedRequirements-requiresDedicatedAllocation", offsetof( struct VkMemoryDedicatedRequirements, requiresDedicatedAllocation ), sizeof( VkBool32 ) );
	swigStructField( "VkMemoryDedicatedRequirements-pNext", offsetof( struct VkMemoryDedicatedRequirements, pNext ), sizeof( void * ) );
	swigStructField( "VkMemoryDedicatedRequirements-sType", offsetof( struct VkMemoryDedicatedRequirements, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkMemoryDedicatedRequirements ) );

	swigComment("struct VkMemoryDedicatedAllocateInfo\n");
	printf( "begin-structure VkMemoryDedicatedAllocateInfo\n" );
	swigStructField( "VkMemoryDedicatedAllocateInfo-pNext", offsetof( struct VkMemoryDedicatedAllocateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkMemoryDedicatedAllocateInfo-buffer", offsetof( struct VkMemoryDedicatedAllocateInfo, buffer ), sizeof( VkBuffer ) );
	swigStructField( "VkMemoryDedicatedAllocateInfo-image", offsetof( struct VkMemoryDedicatedAllocateInfo, image ), sizeof( VkImage ) );
	swigStructField( "VkMemoryDedicatedAllocateInfo-sType", offsetof( struct VkMemoryDedicatedAllocateInfo, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkMemoryDedicatedAllocateInfo ) );

	swigComment("struct VkMemoryAllocateFlagsInfo\n");
	printf( "begin-structure VkMemoryAllocateFlagsInfo\n" );
	swigStructField( "VkMemoryAllocateFlagsInfo-pNext", offsetof( struct VkMemoryAllocateFlagsInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkMemoryAllocateFlagsInfo-deviceMask", offsetof( struct VkMemoryAllocateFlagsInfo, deviceMask ), sizeof( uint32_t ) );
	swigStructField( "VkMemoryAllocateFlagsInfo-sType", offsetof( struct VkMemoryAllocateFlagsInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkMemoryAllocateFlagsInfo-flags", offsetof( struct VkMemoryAllocateFlagsInfo, flags ), sizeof( VkMemoryAllocateFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkMemoryAllocateFlagsInfo ) );

	swigComment("struct VkDeviceGroupRenderPassBeginInfo\n");
	printf( "begin-structure VkDeviceGroupRenderPassBeginInfo\n" );
	swigStructField( "VkDeviceGroupRenderPassBeginInfo-pNext", offsetof( struct VkDeviceGroupRenderPassBeginInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkDeviceGroupRenderPassBeginInfo-deviceMask", offsetof( struct VkDeviceGroupRenderPassBeginInfo, deviceMask ), sizeof( uint32_t ) );
	swigStructField( "VkDeviceGroupRenderPassBeginInfo-deviceRenderAreaCount", offsetof( struct VkDeviceGroupRenderPassBeginInfo, deviceRenderAreaCount ), sizeof( uint32_t ) );
	swigStructField( "VkDeviceGroupRenderPassBeginInfo-pDeviceRenderAreas", offsetof( struct VkDeviceGroupRenderPassBeginInfo, pDeviceRenderAreas ), sizeof( VkRect2D const * ) );
	swigStructField( "VkDeviceGroupRenderPassBeginInfo-sType", offsetof( struct VkDeviceGroupRenderPassBeginInfo, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDeviceGroupRenderPassBeginInfo ) );

	swigComment("struct VkDeviceGroupCommandBufferBeginInfo\n");
	printf( "begin-structure VkDeviceGroupCommandBufferBeginInfo\n" );
	swigStructField( "VkDeviceGroupCommandBufferBeginInfo-pNext", offsetof( struct VkDeviceGroupCommandBufferBeginInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkDeviceGroupCommandBufferBeginInfo-deviceMask", offsetof( struct VkDeviceGroupCommandBufferBeginInfo, deviceMask ), sizeof( uint32_t ) );
	swigStructField( "VkDeviceGroupCommandBufferBeginInfo-sType", offsetof( struct VkDeviceGroupCommandBufferBeginInfo, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDeviceGroupCommandBufferBeginInfo ) );

	swigComment("struct VkDeviceGroupSubmitInfo\n");
	printf( "begin-structure VkDeviceGroupSubmitInfo\n" );
	swigStructField( "VkDeviceGroupSubmitInfo-pNext", offsetof( struct VkDeviceGroupSubmitInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkDeviceGroupSubmitInfo-commandBufferCount", offsetof( struct VkDeviceGroupSubmitInfo, commandBufferCount ), sizeof( uint32_t ) );
	swigStructField( "VkDeviceGroupSubmitInfo-waitSemaphoreCount", offsetof( struct VkDeviceGroupSubmitInfo, waitSemaphoreCount ), sizeof( uint32_t ) );
	swigStructField( "VkDeviceGroupSubmitInfo-pWaitSemaphoreDeviceIndices", offsetof( struct VkDeviceGroupSubmitInfo, pWaitSemaphoreDeviceIndices ), sizeof( uint32_t const * ) );
	swigStructField( "VkDeviceGroupSubmitInfo-signalSemaphoreCount", offsetof( struct VkDeviceGroupSubmitInfo, signalSemaphoreCount ), sizeof( uint32_t ) );
	swigStructField( "VkDeviceGroupSubmitInfo-pSignalSemaphoreDeviceIndices", offsetof( struct VkDeviceGroupSubmitInfo, pSignalSemaphoreDeviceIndices ), sizeof( uint32_t const * ) );
	swigStructField( "VkDeviceGroupSubmitInfo-sType", offsetof( struct VkDeviceGroupSubmitInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkDeviceGroupSubmitInfo-pCommandBufferDeviceMasks", offsetof( struct VkDeviceGroupSubmitInfo, pCommandBufferDeviceMasks ), sizeof( uint32_t const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDeviceGroupSubmitInfo ) );

	swigComment("struct VkDeviceGroupBindSparseInfo\n");
	printf( "begin-structure VkDeviceGroupBindSparseInfo\n" );
	swigStructField( "VkDeviceGroupBindSparseInfo-pNext", offsetof( struct VkDeviceGroupBindSparseInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkDeviceGroupBindSparseInfo-resourceDeviceIndex", offsetof( struct VkDeviceGroupBindSparseInfo, resourceDeviceIndex ), sizeof( uint32_t ) );
	swigStructField( "VkDeviceGroupBindSparseInfo-memoryDeviceIndex", offsetof( struct VkDeviceGroupBindSparseInfo, memoryDeviceIndex ), sizeof( uint32_t ) );
	swigStructField( "VkDeviceGroupBindSparseInfo-sType", offsetof( struct VkDeviceGroupBindSparseInfo, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDeviceGroupBindSparseInfo ) );

	swigComment("struct VkBindBufferMemoryDeviceGroupInfo\n");
	printf( "begin-structure VkBindBufferMemoryDeviceGroupInfo\n" );
	swigStructField( "VkBindBufferMemoryDeviceGroupInfo-pNext", offsetof( struct VkBindBufferMemoryDeviceGroupInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkBindBufferMemoryDeviceGroupInfo-pDeviceIndices", offsetof( struct VkBindBufferMemoryDeviceGroupInfo, pDeviceIndices ), sizeof( uint32_t const * ) );
	swigStructField( "VkBindBufferMemoryDeviceGroupInfo-sType", offsetof( struct VkBindBufferMemoryDeviceGroupInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkBindBufferMemoryDeviceGroupInfo-deviceIndexCount", offsetof( struct VkBindBufferMemoryDeviceGroupInfo, deviceIndexCount ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkBindBufferMemoryDeviceGroupInfo ) );

	swigComment("struct VkBindImageMemoryDeviceGroupInfo\n");
	printf( "begin-structure VkBindImageMemoryDeviceGroupInfo\n" );
	swigStructField( "VkBindImageMemoryDeviceGroupInfo-splitInstanceBindRegionCount", offsetof( struct VkBindImageMemoryDeviceGroupInfo, splitInstanceBindRegionCount ), sizeof( uint32_t ) );
	swigStructField( "VkBindImageMemoryDeviceGroupInfo-pNext", offsetof( struct VkBindImageMemoryDeviceGroupInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkBindImageMemoryDeviceGroupInfo-pSplitInstanceBindRegions", offsetof( struct VkBindImageMemoryDeviceGroupInfo, pSplitInstanceBindRegions ), sizeof( VkRect2D const * ) );
	swigStructField( "VkBindImageMemoryDeviceGroupInfo-pDeviceIndices", offsetof( struct VkBindImageMemoryDeviceGroupInfo, pDeviceIndices ), sizeof( uint32_t const * ) );
	swigStructField( "VkBindImageMemoryDeviceGroupInfo-sType", offsetof( struct VkBindImageMemoryDeviceGroupInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkBindImageMemoryDeviceGroupInfo-deviceIndexCount", offsetof( struct VkBindImageMemoryDeviceGroupInfo, deviceIndexCount ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkBindImageMemoryDeviceGroupInfo ) );

	swigComment("struct VkPhysicalDeviceGroupProperties\n");
	printf( "begin-structure VkPhysicalDeviceGroupProperties\n" );
	swigStructField( "VkPhysicalDeviceGroupProperties-subsetAllocation", offsetof( struct VkPhysicalDeviceGroupProperties, subsetAllocation ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceGroupProperties-pNext", offsetof( struct VkPhysicalDeviceGroupProperties, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceGroupProperties-physicalDeviceCount", offsetof( struct VkPhysicalDeviceGroupProperties, physicalDeviceCount ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceGroupProperties-physicalDevices", offsetof( struct VkPhysicalDeviceGroupProperties, physicalDevices ), sizeof( VkPhysicalDevice [32U] ) );
	swigStructField( "VkPhysicalDeviceGroupProperties-sType", offsetof( struct VkPhysicalDeviceGroupProperties, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceGroupProperties ) );

	swigComment("struct VkDeviceGroupDeviceCreateInfo\n");
	printf( "begin-structure VkDeviceGroupDeviceCreateInfo\n" );
	swigStructField( "VkDeviceGroupDeviceCreateInfo-pNext", offsetof( struct VkDeviceGroupDeviceCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkDeviceGroupDeviceCreateInfo-physicalDeviceCount", offsetof( struct VkDeviceGroupDeviceCreateInfo, physicalDeviceCount ), sizeof( uint32_t ) );
	swigStructField( "VkDeviceGroupDeviceCreateInfo-pPhysicalDevices", offsetof( struct VkDeviceGroupDeviceCreateInfo, pPhysicalDevices ), sizeof( VkPhysicalDevice const * ) );
	swigStructField( "VkDeviceGroupDeviceCreateInfo-sType", offsetof( struct VkDeviceGroupDeviceCreateInfo, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDeviceGroupDeviceCreateInfo ) );

	swigComment("struct VkBufferMemoryRequirementsInfo2\n");
	printf( "begin-structure VkBufferMemoryRequirementsInfo2\n" );
	swigStructField( "VkBufferMemoryRequirementsInfo2-pNext", offsetof( struct VkBufferMemoryRequirementsInfo2, pNext ), sizeof( void const * ) );
	swigStructField( "VkBufferMemoryRequirementsInfo2-buffer", offsetof( struct VkBufferMemoryRequirementsInfo2, buffer ), sizeof( VkBuffer ) );
	swigStructField( "VkBufferMemoryRequirementsInfo2-sType", offsetof( struct VkBufferMemoryRequirementsInfo2, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkBufferMemoryRequirementsInfo2 ) );

	swigComment("struct VkImageMemoryRequirementsInfo2\n");
	printf( "begin-structure VkImageMemoryRequirementsInfo2\n" );
	swigStructField( "VkImageMemoryRequirementsInfo2-pNext", offsetof( struct VkImageMemoryRequirementsInfo2, pNext ), sizeof( void const * ) );
	swigStructField( "VkImageMemoryRequirementsInfo2-image", offsetof( struct VkImageMemoryRequirementsInfo2, image ), sizeof( VkImage ) );
	swigStructField( "VkImageMemoryRequirementsInfo2-sType", offsetof( struct VkImageMemoryRequirementsInfo2, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkImageMemoryRequirementsInfo2 ) );

	swigComment("struct VkImageSparseMemoryRequirementsInfo2\n");
	printf( "begin-structure VkImageSparseMemoryRequirementsInfo2\n" );
	swigStructField( "VkImageSparseMemoryRequirementsInfo2-pNext", offsetof( struct VkImageSparseMemoryRequirementsInfo2, pNext ), sizeof( void const * ) );
	swigStructField( "VkImageSparseMemoryRequirementsInfo2-image", offsetof( struct VkImageSparseMemoryRequirementsInfo2, image ), sizeof( VkImage ) );
	swigStructField( "VkImageSparseMemoryRequirementsInfo2-sType", offsetof( struct VkImageSparseMemoryRequirementsInfo2, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkImageSparseMemoryRequirementsInfo2 ) );

	swigComment("struct VkMemoryRequirements2\n");
	printf( "begin-structure VkMemoryRequirements2\n" );
	swigStructField( "VkMemoryRequirements2-pNext", offsetof( struct VkMemoryRequirements2, pNext ), sizeof( void * ) );
	swigStructField( "VkMemoryRequirements2-memoryRequirements", offsetof( struct VkMemoryRequirements2, memoryRequirements ), sizeof( VkMemoryRequirements ) );
	swigStructField( "VkMemoryRequirements2-sType", offsetof( struct VkMemoryRequirements2, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkMemoryRequirements2 ) );

	swigComment("struct VkSparseImageMemoryRequirements2\n");
	printf( "begin-structure VkSparseImageMemoryRequirements2\n" );
	swigStructField( "VkSparseImageMemoryRequirements2-pNext", offsetof( struct VkSparseImageMemoryRequirements2, pNext ), sizeof( void * ) );
	swigStructField( "VkSparseImageMemoryRequirements2-memoryRequirements", offsetof( struct VkSparseImageMemoryRequirements2, memoryRequirements ), sizeof( VkSparseImageMemoryRequirements ) );
	swigStructField( "VkSparseImageMemoryRequirements2-sType", offsetof( struct VkSparseImageMemoryRequirements2, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSparseImageMemoryRequirements2 ) );

	swigComment("struct VkPhysicalDeviceFeatures2\n");
	printf( "begin-structure VkPhysicalDeviceFeatures2\n" );
	swigStructField( "VkPhysicalDeviceFeatures2-features", offsetof( struct VkPhysicalDeviceFeatures2, features ), sizeof( VkPhysicalDeviceFeatures ) );
	swigStructField( "VkPhysicalDeviceFeatures2-pNext", offsetof( struct VkPhysicalDeviceFeatures2, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceFeatures2-sType", offsetof( struct VkPhysicalDeviceFeatures2, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceFeatures2 ) );

	swigComment("struct VkPhysicalDeviceProperties2\n");
	printf( "begin-structure VkPhysicalDeviceProperties2\n" );
	swigStructField( "VkPhysicalDeviceProperties2-pNext", offsetof( struct VkPhysicalDeviceProperties2, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceProperties2-properties", offsetof( struct VkPhysicalDeviceProperties2, properties ), sizeof( VkPhysicalDeviceProperties ) );
	swigStructField( "VkPhysicalDeviceProperties2-sType", offsetof( struct VkPhysicalDeviceProperties2, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceProperties2 ) );

	swigComment("struct VkFormatProperties2\n");
	printf( "begin-structure VkFormatProperties2\n" );
	swigStructField( "VkFormatProperties2-pNext", offsetof( struct VkFormatProperties2, pNext ), sizeof( void * ) );
	swigStructField( "VkFormatProperties2-formatProperties", offsetof( struct VkFormatProperties2, formatProperties ), sizeof( VkFormatProperties ) );
	swigStructField( "VkFormatProperties2-sType", offsetof( struct VkFormatProperties2, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkFormatProperties2 ) );

	swigComment("struct VkImageFormatProperties2\n");
	printf( "begin-structure VkImageFormatProperties2\n" );
	swigStructField( "VkImageFormatProperties2-pNext", offsetof( struct VkImageFormatProperties2, pNext ), sizeof( void * ) );
	swigStructField( "VkImageFormatProperties2-imageFormatProperties", offsetof( struct VkImageFormatProperties2, imageFormatProperties ), sizeof( VkImageFormatProperties ) );
	swigStructField( "VkImageFormatProperties2-sType", offsetof( struct VkImageFormatProperties2, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkImageFormatProperties2 ) );

	swigComment("struct VkPhysicalDeviceImageFormatInfo2\n");
	printf( "begin-structure VkPhysicalDeviceImageFormatInfo2\n" );
	swigStructField( "VkPhysicalDeviceImageFormatInfo2-pNext", offsetof( struct VkPhysicalDeviceImageFormatInfo2, pNext ), sizeof( void const * ) );
	swigStructField( "VkPhysicalDeviceImageFormatInfo2-usage", offsetof( struct VkPhysicalDeviceImageFormatInfo2, usage ), sizeof( VkImageUsageFlags ) );
	swigStructField( "VkPhysicalDeviceImageFormatInfo2-type", offsetof( struct VkPhysicalDeviceImageFormatInfo2, type ), sizeof( VkImageType ) );
	swigStructField( "VkPhysicalDeviceImageFormatInfo2-sType", offsetof( struct VkPhysicalDeviceImageFormatInfo2, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDeviceImageFormatInfo2-format", offsetof( struct VkPhysicalDeviceImageFormatInfo2, format ), sizeof( VkFormat ) );
	swigStructField( "VkPhysicalDeviceImageFormatInfo2-flags", offsetof( struct VkPhysicalDeviceImageFormatInfo2, flags ), sizeof( VkImageCreateFlags ) );
	swigStructField( "VkPhysicalDeviceImageFormatInfo2-tiling", offsetof( struct VkPhysicalDeviceImageFormatInfo2, tiling ), sizeof( VkImageTiling ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceImageFormatInfo2 ) );

	swigComment("struct VkQueueFamilyProperties2\n");
	printf( "begin-structure VkQueueFamilyProperties2\n" );
	swigStructField( "VkQueueFamilyProperties2-pNext", offsetof( struct VkQueueFamilyProperties2, pNext ), sizeof( void * ) );
	swigStructField( "VkQueueFamilyProperties2-queueFamilyProperties", offsetof( struct VkQueueFamilyProperties2, queueFamilyProperties ), sizeof( VkQueueFamilyProperties ) );
	swigStructField( "VkQueueFamilyProperties2-sType", offsetof( struct VkQueueFamilyProperties2, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkQueueFamilyProperties2 ) );

	swigComment("struct VkPhysicalDeviceMemoryProperties2\n");
	printf( "begin-structure VkPhysicalDeviceMemoryProperties2\n" );
	swigStructField( "VkPhysicalDeviceMemoryProperties2-pNext", offsetof( struct VkPhysicalDeviceMemoryProperties2, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceMemoryProperties2-memoryProperties", offsetof( struct VkPhysicalDeviceMemoryProperties2, memoryProperties ), sizeof( VkPhysicalDeviceMemoryProperties ) );
	swigStructField( "VkPhysicalDeviceMemoryProperties2-sType", offsetof( struct VkPhysicalDeviceMemoryProperties2, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceMemoryProperties2 ) );

	swigComment("struct VkSparseImageFormatProperties2\n");
	printf( "begin-structure VkSparseImageFormatProperties2\n" );
	swigStructField( "VkSparseImageFormatProperties2-pNext", offsetof( struct VkSparseImageFormatProperties2, pNext ), sizeof( void * ) );
	swigStructField( "VkSparseImageFormatProperties2-properties", offsetof( struct VkSparseImageFormatProperties2, properties ), sizeof( VkSparseImageFormatProperties ) );
	swigStructField( "VkSparseImageFormatProperties2-sType", offsetof( struct VkSparseImageFormatProperties2, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSparseImageFormatProperties2 ) );

	swigComment("struct VkPhysicalDeviceSparseImageFormatInfo2\n");
	printf( "begin-structure VkPhysicalDeviceSparseImageFormatInfo2\n" );
	swigStructField( "VkPhysicalDeviceSparseImageFormatInfo2-pNext", offsetof( struct VkPhysicalDeviceSparseImageFormatInfo2, pNext ), sizeof( void const * ) );
	swigStructField( "VkPhysicalDeviceSparseImageFormatInfo2-usage", offsetof( struct VkPhysicalDeviceSparseImageFormatInfo2, usage ), sizeof( VkImageUsageFlags ) );
	swigStructField( "VkPhysicalDeviceSparseImageFormatInfo2-type", offsetof( struct VkPhysicalDeviceSparseImageFormatInfo2, type ), sizeof( VkImageType ) );
	swigStructField( "VkPhysicalDeviceSparseImageFormatInfo2-samples", offsetof( struct VkPhysicalDeviceSparseImageFormatInfo2, samples ), sizeof( VkSampleCountFlagBits ) );
	swigStructField( "VkPhysicalDeviceSparseImageFormatInfo2-sType", offsetof( struct VkPhysicalDeviceSparseImageFormatInfo2, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDeviceSparseImageFormatInfo2-format", offsetof( struct VkPhysicalDeviceSparseImageFormatInfo2, format ), sizeof( VkFormat ) );
	swigStructField( "VkPhysicalDeviceSparseImageFormatInfo2-tiling", offsetof( struct VkPhysicalDeviceSparseImageFormatInfo2, tiling ), sizeof( VkImageTiling ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceSparseImageFormatInfo2 ) );

	swigComment("struct VkPhysicalDevicePointClippingProperties\n");
	printf( "begin-structure VkPhysicalDevicePointClippingProperties\n" );
	swigStructField( "VkPhysicalDevicePointClippingProperties-pNext", offsetof( struct VkPhysicalDevicePointClippingProperties, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDevicePointClippingProperties-pointClippingBehavior", offsetof( struct VkPhysicalDevicePointClippingProperties, pointClippingBehavior ), sizeof( VkPointClippingBehavior ) );
	swigStructField( "VkPhysicalDevicePointClippingProperties-sType", offsetof( struct VkPhysicalDevicePointClippingProperties, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDevicePointClippingProperties ) );

	swigComment("struct VkInputAttachmentAspectReference\n");
	printf( "begin-structure VkInputAttachmentAspectReference\n" );
	swigStructField( "VkInputAttachmentAspectReference-inputAttachmentIndex", offsetof( struct VkInputAttachmentAspectReference, inputAttachmentIndex ), sizeof( uint32_t ) );
	swigStructField( "VkInputAttachmentAspectReference-subpass", offsetof( struct VkInputAttachmentAspectReference, subpass ), sizeof( uint32_t ) );
	swigStructField( "VkInputAttachmentAspectReference-aspectMask", offsetof( struct VkInputAttachmentAspectReference, aspectMask ), sizeof( VkImageAspectFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkInputAttachmentAspectReference ) );

	swigComment("struct VkRenderPassInputAttachmentAspectCreateInfo\n");
	printf( "begin-structure VkRenderPassInputAttachmentAspectCreateInfo\n" );
	swigStructField( "VkRenderPassInputAttachmentAspectCreateInfo-pAspectReferences", offsetof( struct VkRenderPassInputAttachmentAspectCreateInfo, pAspectReferences ), sizeof( VkInputAttachmentAspectReference const * ) );
	swigStructField( "VkRenderPassInputAttachmentAspectCreateInfo-pNext", offsetof( struct VkRenderPassInputAttachmentAspectCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkRenderPassInputAttachmentAspectCreateInfo-aspectReferenceCount", offsetof( struct VkRenderPassInputAttachmentAspectCreateInfo, aspectReferenceCount ), sizeof( uint32_t ) );
	swigStructField( "VkRenderPassInputAttachmentAspectCreateInfo-sType", offsetof( struct VkRenderPassInputAttachmentAspectCreateInfo, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkRenderPassInputAttachmentAspectCreateInfo ) );

	swigComment("struct VkImageViewUsageCreateInfo\n");
	printf( "begin-structure VkImageViewUsageCreateInfo\n" );
	swigStructField( "VkImageViewUsageCreateInfo-pNext", offsetof( struct VkImageViewUsageCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkImageViewUsageCreateInfo-usage", offsetof( struct VkImageViewUsageCreateInfo, usage ), sizeof( VkImageUsageFlags ) );
	swigStructField( "VkImageViewUsageCreateInfo-sType", offsetof( struct VkImageViewUsageCreateInfo, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkImageViewUsageCreateInfo ) );

	swigComment("struct VkPipelineTessellationDomainOriginStateCreateInfo\n");
	printf( "begin-structure VkPipelineTessellationDomainOriginStateCreateInfo\n" );
	swigStructField( "VkPipelineTessellationDomainOriginStateCreateInfo-pNext", offsetof( struct VkPipelineTessellationDomainOriginStateCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkPipelineTessellationDomainOriginStateCreateInfo-domainOrigin", offsetof( struct VkPipelineTessellationDomainOriginStateCreateInfo, domainOrigin ), sizeof( VkTessellationDomainOrigin ) );
	swigStructField( "VkPipelineTessellationDomainOriginStateCreateInfo-sType", offsetof( struct VkPipelineTessellationDomainOriginStateCreateInfo, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineTessellationDomainOriginStateCreateInfo ) );

	swigComment("struct VkRenderPassMultiviewCreateInfo\n");
	printf( "begin-structure VkRenderPassMultiviewCreateInfo\n" );
	swigStructField( "VkRenderPassMultiviewCreateInfo-pViewOffsets", offsetof( struct VkRenderPassMultiviewCreateInfo, pViewOffsets ), sizeof( int32_t const * ) );
	swigStructField( "VkRenderPassMultiviewCreateInfo-pNext", offsetof( struct VkRenderPassMultiviewCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkRenderPassMultiviewCreateInfo-dependencyCount", offsetof( struct VkRenderPassMultiviewCreateInfo, dependencyCount ), sizeof( uint32_t ) );
	swigStructField( "VkRenderPassMultiviewCreateInfo-correlationMaskCount", offsetof( struct VkRenderPassMultiviewCreateInfo, correlationMaskCount ), sizeof( uint32_t ) );
	swigStructField( "VkRenderPassMultiviewCreateInfo-pCorrelationMasks", offsetof( struct VkRenderPassMultiviewCreateInfo, pCorrelationMasks ), sizeof( uint32_t const * ) );
	swigStructField( "VkRenderPassMultiviewCreateInfo-subpassCount", offsetof( struct VkRenderPassMultiviewCreateInfo, subpassCount ), sizeof( uint32_t ) );
	swigStructField( "VkRenderPassMultiviewCreateInfo-sType", offsetof( struct VkRenderPassMultiviewCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkRenderPassMultiviewCreateInfo-pViewMasks", offsetof( struct VkRenderPassMultiviewCreateInfo, pViewMasks ), sizeof( uint32_t const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkRenderPassMultiviewCreateInfo ) );

	swigComment("struct VkPhysicalDeviceMultiviewFeatures\n");
	printf( "begin-structure VkPhysicalDeviceMultiviewFeatures\n" );
	swigStructField( "VkPhysicalDeviceMultiviewFeatures-pNext", offsetof( struct VkPhysicalDeviceMultiviewFeatures, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceMultiviewFeatures-multiviewTessellationShader", offsetof( struct VkPhysicalDeviceMultiviewFeatures, multiviewTessellationShader ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceMultiviewFeatures-multiview", offsetof( struct VkPhysicalDeviceMultiviewFeatures, multiview ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceMultiviewFeatures-multiviewGeometryShader", offsetof( struct VkPhysicalDeviceMultiviewFeatures, multiviewGeometryShader ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceMultiviewFeatures-sType", offsetof( struct VkPhysicalDeviceMultiviewFeatures, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceMultiviewFeatures ) );

	swigComment("struct VkPhysicalDeviceMultiviewProperties\n");
	printf( "begin-structure VkPhysicalDeviceMultiviewProperties\n" );
	swigStructField( "VkPhysicalDeviceMultiviewProperties-pNext", offsetof( struct VkPhysicalDeviceMultiviewProperties, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceMultiviewProperties-maxMultiviewInstanceIndex", offsetof( struct VkPhysicalDeviceMultiviewProperties, maxMultiviewInstanceIndex ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceMultiviewProperties-maxMultiviewViewCount", offsetof( struct VkPhysicalDeviceMultiviewProperties, maxMultiviewViewCount ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceMultiviewProperties-sType", offsetof( struct VkPhysicalDeviceMultiviewProperties, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceMultiviewProperties ) );

	swigComment("struct VkPhysicalDeviceVariablePointersFeatures\n");
	printf( "begin-structure VkPhysicalDeviceVariablePointersFeatures\n" );
	swigStructField( "VkPhysicalDeviceVariablePointersFeatures-pNext", offsetof( struct VkPhysicalDeviceVariablePointersFeatures, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceVariablePointersFeatures-variablePointersStorageBuffer", offsetof( struct VkPhysicalDeviceVariablePointersFeatures, variablePointersStorageBuffer ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVariablePointersFeatures-variablePointers", offsetof( struct VkPhysicalDeviceVariablePointersFeatures, variablePointers ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVariablePointersFeatures-sType", offsetof( struct VkPhysicalDeviceVariablePointersFeatures, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceVariablePointersFeatures ) );

	swigComment("struct VkPhysicalDeviceProtectedMemoryFeatures\n");
	printf( "begin-structure VkPhysicalDeviceProtectedMemoryFeatures\n" );
	swigStructField( "VkPhysicalDeviceProtectedMemoryFeatures-pNext", offsetof( struct VkPhysicalDeviceProtectedMemoryFeatures, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceProtectedMemoryFeatures-protectedMemory", offsetof( struct VkPhysicalDeviceProtectedMemoryFeatures, protectedMemory ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceProtectedMemoryFeatures-sType", offsetof( struct VkPhysicalDeviceProtectedMemoryFeatures, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceProtectedMemoryFeatures ) );

	swigComment("struct VkPhysicalDeviceProtectedMemoryProperties\n");
	printf( "begin-structure VkPhysicalDeviceProtectedMemoryProperties\n" );
	swigStructField( "VkPhysicalDeviceProtectedMemoryProperties-protectedNoFault", offsetof( struct VkPhysicalDeviceProtectedMemoryProperties, protectedNoFault ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceProtectedMemoryProperties-pNext", offsetof( struct VkPhysicalDeviceProtectedMemoryProperties, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceProtectedMemoryProperties-sType", offsetof( struct VkPhysicalDeviceProtectedMemoryProperties, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceProtectedMemoryProperties ) );

	swigComment("struct VkDeviceQueueInfo2\n");
	printf( "begin-structure VkDeviceQueueInfo2\n" );
	swigStructField( "VkDeviceQueueInfo2-pNext", offsetof( struct VkDeviceQueueInfo2, pNext ), sizeof( void const * ) );
	swigStructField( "VkDeviceQueueInfo2-queueFamilyIndex", offsetof( struct VkDeviceQueueInfo2, queueFamilyIndex ), sizeof( uint32_t ) );
	swigStructField( "VkDeviceQueueInfo2-queueIndex", offsetof( struct VkDeviceQueueInfo2, queueIndex ), sizeof( uint32_t ) );
	swigStructField( "VkDeviceQueueInfo2-sType", offsetof( struct VkDeviceQueueInfo2, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkDeviceQueueInfo2-flags", offsetof( struct VkDeviceQueueInfo2, flags ), sizeof( VkDeviceQueueCreateFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDeviceQueueInfo2 ) );

	swigComment("struct VkProtectedSubmitInfo\n");
	printf( "begin-structure VkProtectedSubmitInfo\n" );
	swigStructField( "VkProtectedSubmitInfo-protectedSubmit", offsetof( struct VkProtectedSubmitInfo, protectedSubmit ), sizeof( VkBool32 ) );
	swigStructField( "VkProtectedSubmitInfo-pNext", offsetof( struct VkProtectedSubmitInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkProtectedSubmitInfo-sType", offsetof( struct VkProtectedSubmitInfo, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkProtectedSubmitInfo ) );

	swigComment("struct VkSamplerYcbcrConversionCreateInfo\n");
	printf( "begin-structure VkSamplerYcbcrConversionCreateInfo\n" );
	swigStructField( "VkSamplerYcbcrConversionCreateInfo-pNext", offsetof( struct VkSamplerYcbcrConversionCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkSamplerYcbcrConversionCreateInfo-xChromaOffset", offsetof( struct VkSamplerYcbcrConversionCreateInfo, xChromaOffset ), sizeof( VkChromaLocation ) );
	swigStructField( "VkSamplerYcbcrConversionCreateInfo-yChromaOffset", offsetof( struct VkSamplerYcbcrConversionCreateInfo, yChromaOffset ), sizeof( VkChromaLocation ) );
	swigStructField( "VkSamplerYcbcrConversionCreateInfo-chromaFilter", offsetof( struct VkSamplerYcbcrConversionCreateInfo, chromaFilter ), sizeof( VkFilter ) );
	swigStructField( "VkSamplerYcbcrConversionCreateInfo-forceExplicitReconstruction", offsetof( struct VkSamplerYcbcrConversionCreateInfo, forceExplicitReconstruction ), sizeof( VkBool32 ) );
	swigStructField( "VkSamplerYcbcrConversionCreateInfo-ycbcrRange", offsetof( struct VkSamplerYcbcrConversionCreateInfo, ycbcrRange ), sizeof( VkSamplerYcbcrRange ) );
	swigStructField( "VkSamplerYcbcrConversionCreateInfo-sType", offsetof( struct VkSamplerYcbcrConversionCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkSamplerYcbcrConversionCreateInfo-format", offsetof( struct VkSamplerYcbcrConversionCreateInfo, format ), sizeof( VkFormat ) );
	swigStructField( "VkSamplerYcbcrConversionCreateInfo-ycbcrModel", offsetof( struct VkSamplerYcbcrConversionCreateInfo, ycbcrModel ), sizeof( VkSamplerYcbcrModelConversion ) );
	swigStructField( "VkSamplerYcbcrConversionCreateInfo-components", offsetof( struct VkSamplerYcbcrConversionCreateInfo, components ), sizeof( VkComponentMapping ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSamplerYcbcrConversionCreateInfo ) );

	swigComment("struct VkSamplerYcbcrConversionInfo\n");
	printf( "begin-structure VkSamplerYcbcrConversionInfo\n" );
	swigStructField( "VkSamplerYcbcrConversionInfo-pNext", offsetof( struct VkSamplerYcbcrConversionInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkSamplerYcbcrConversionInfo-conversion", offsetof( struct VkSamplerYcbcrConversionInfo, conversion ), sizeof( VkSamplerYcbcrConversion ) );
	swigStructField( "VkSamplerYcbcrConversionInfo-sType", offsetof( struct VkSamplerYcbcrConversionInfo, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSamplerYcbcrConversionInfo ) );

	swigComment("struct VkBindImagePlaneMemoryInfo\n");
	printf( "begin-structure VkBindImagePlaneMemoryInfo\n" );
	swigStructField( "VkBindImagePlaneMemoryInfo-pNext", offsetof( struct VkBindImagePlaneMemoryInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkBindImagePlaneMemoryInfo-planeAspect", offsetof( struct VkBindImagePlaneMemoryInfo, planeAspect ), sizeof( VkImageAspectFlagBits ) );
	swigStructField( "VkBindImagePlaneMemoryInfo-sType", offsetof( struct VkBindImagePlaneMemoryInfo, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkBindImagePlaneMemoryInfo ) );

	swigComment("struct VkImagePlaneMemoryRequirementsInfo\n");
	printf( "begin-structure VkImagePlaneMemoryRequirementsInfo\n" );
	swigStructField( "VkImagePlaneMemoryRequirementsInfo-pNext", offsetof( struct VkImagePlaneMemoryRequirementsInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkImagePlaneMemoryRequirementsInfo-planeAspect", offsetof( struct VkImagePlaneMemoryRequirementsInfo, planeAspect ), sizeof( VkImageAspectFlagBits ) );
	swigStructField( "VkImagePlaneMemoryRequirementsInfo-sType", offsetof( struct VkImagePlaneMemoryRequirementsInfo, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkImagePlaneMemoryRequirementsInfo ) );

	swigComment("struct VkPhysicalDeviceSamplerYcbcrConversionFeatures\n");
	printf( "begin-structure VkPhysicalDeviceSamplerYcbcrConversionFeatures\n" );
	swigStructField( "VkPhysicalDeviceSamplerYcbcrConversionFeatures-pNext", offsetof( struct VkPhysicalDeviceSamplerYcbcrConversionFeatures, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceSamplerYcbcrConversionFeatures-samplerYcbcrConversion", offsetof( struct VkPhysicalDeviceSamplerYcbcrConversionFeatures, samplerYcbcrConversion ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceSamplerYcbcrConversionFeatures-sType", offsetof( struct VkPhysicalDeviceSamplerYcbcrConversionFeatures, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceSamplerYcbcrConversionFeatures ) );

	swigComment("struct VkSamplerYcbcrConversionImageFormatProperties\n");
	printf( "begin-structure VkSamplerYcbcrConversionImageFormatProperties\n" );
	swigStructField( "VkSamplerYcbcrConversionImageFormatProperties-pNext", offsetof( struct VkSamplerYcbcrConversionImageFormatProperties, pNext ), sizeof( void * ) );
	swigStructField( "VkSamplerYcbcrConversionImageFormatProperties-combinedImageSamplerDescriptorCount", offsetof( struct VkSamplerYcbcrConversionImageFormatProperties, combinedImageSamplerDescriptorCount ), sizeof( uint32_t ) );
	swigStructField( "VkSamplerYcbcrConversionImageFormatProperties-sType", offsetof( struct VkSamplerYcbcrConversionImageFormatProperties, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSamplerYcbcrConversionImageFormatProperties ) );

	swigComment("struct VkDescriptorUpdateTemplateEntry\n");
	printf( "begin-structure VkDescriptorUpdateTemplateEntry\n" );
	swigStructField( "VkDescriptorUpdateTemplateEntry-dstArrayElement", offsetof( struct VkDescriptorUpdateTemplateEntry, dstArrayElement ), sizeof( uint32_t ) );
	swigStructField( "VkDescriptorUpdateTemplateEntry-descriptorCount", offsetof( struct VkDescriptorUpdateTemplateEntry, descriptorCount ), sizeof( uint32_t ) );
	swigStructField( "VkDescriptorUpdateTemplateEntry-dstBinding", offsetof( struct VkDescriptorUpdateTemplateEntry, dstBinding ), sizeof( uint32_t ) );
	swigStructField( "VkDescriptorUpdateTemplateEntry-offset", offsetof( struct VkDescriptorUpdateTemplateEntry, offset ), sizeof( size_t ) );
	swigStructField( "VkDescriptorUpdateTemplateEntry-descriptorType", offsetof( struct VkDescriptorUpdateTemplateEntry, descriptorType ), sizeof( VkDescriptorType ) );
	swigStructField( "VkDescriptorUpdateTemplateEntry-stride", offsetof( struct VkDescriptorUpdateTemplateEntry, stride ), sizeof( size_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDescriptorUpdateTemplateEntry ) );

	swigComment("struct VkDescriptorUpdateTemplateCreateInfo\n");
	printf( "begin-structure VkDescriptorUpdateTemplateCreateInfo\n" );
	swigStructField( "VkDescriptorUpdateTemplateCreateInfo-pNext", offsetof( struct VkDescriptorUpdateTemplateCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkDescriptorUpdateTemplateCreateInfo-set", offsetof( struct VkDescriptorUpdateTemplateCreateInfo, set ), sizeof( uint32_t ) );
	swigStructField( "VkDescriptorUpdateTemplateCreateInfo-descriptorUpdateEntryCount", offsetof( struct VkDescriptorUpdateTemplateCreateInfo, descriptorUpdateEntryCount ), sizeof( uint32_t ) );
	swigStructField( "VkDescriptorUpdateTemplateCreateInfo-descriptorSetLayout", offsetof( struct VkDescriptorUpdateTemplateCreateInfo, descriptorSetLayout ), sizeof( VkDescriptorSetLayout ) );
	swigStructField( "VkDescriptorUpdateTemplateCreateInfo-pipelineBindPoint", offsetof( struct VkDescriptorUpdateTemplateCreateInfo, pipelineBindPoint ), sizeof( VkPipelineBindPoint ) );
	swigStructField( "VkDescriptorUpdateTemplateCreateInfo-templateType", offsetof( struct VkDescriptorUpdateTemplateCreateInfo, templateType ), sizeof( VkDescriptorUpdateTemplateType ) );
	swigStructField( "VkDescriptorUpdateTemplateCreateInfo-pipelineLayout", offsetof( struct VkDescriptorUpdateTemplateCreateInfo, pipelineLayout ), sizeof( VkPipelineLayout ) );
	swigStructField( "VkDescriptorUpdateTemplateCreateInfo-sType", offsetof( struct VkDescriptorUpdateTemplateCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkDescriptorUpdateTemplateCreateInfo-flags", offsetof( struct VkDescriptorUpdateTemplateCreateInfo, flags ), sizeof( VkDescriptorUpdateTemplateCreateFlags ) );
	swigStructField( "VkDescriptorUpdateTemplateCreateInfo-pDescriptorUpdateEntries", offsetof( struct VkDescriptorUpdateTemplateCreateInfo, pDescriptorUpdateEntries ), sizeof( VkDescriptorUpdateTemplateEntry const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDescriptorUpdateTemplateCreateInfo ) );

	swigComment("struct VkExternalMemoryProperties\n");
	printf( "begin-structure VkExternalMemoryProperties\n" );
	swigStructField( "VkExternalMemoryProperties-externalMemoryFeatures", offsetof( struct VkExternalMemoryProperties, externalMemoryFeatures ), sizeof( VkExternalMemoryFeatureFlags ) );
	swigStructField( "VkExternalMemoryProperties-exportFromImportedHandleTypes", offsetof( struct VkExternalMemoryProperties, exportFromImportedHandleTypes ), sizeof( VkExternalMemoryHandleTypeFlags ) );
	swigStructField( "VkExternalMemoryProperties-compatibleHandleTypes", offsetof( struct VkExternalMemoryProperties, compatibleHandleTypes ), sizeof( VkExternalMemoryHandleTypeFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkExternalMemoryProperties ) );

	swigComment("struct VkPhysicalDeviceExternalImageFormatInfo\n");
	printf( "begin-structure VkPhysicalDeviceExternalImageFormatInfo\n" );
	swigStructField( "VkPhysicalDeviceExternalImageFormatInfo-pNext", offsetof( struct VkPhysicalDeviceExternalImageFormatInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkPhysicalDeviceExternalImageFormatInfo-handleType", offsetof( struct VkPhysicalDeviceExternalImageFormatInfo, handleType ), sizeof( VkExternalMemoryHandleTypeFlagBits ) );
	swigStructField( "VkPhysicalDeviceExternalImageFormatInfo-sType", offsetof( struct VkPhysicalDeviceExternalImageFormatInfo, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceExternalImageFormatInfo ) );

	swigComment("struct VkExternalImageFormatProperties\n");
	printf( "begin-structure VkExternalImageFormatProperties\n" );
	swigStructField( "VkExternalImageFormatProperties-pNext", offsetof( struct VkExternalImageFormatProperties, pNext ), sizeof( void * ) );
	swigStructField( "VkExternalImageFormatProperties-externalMemoryProperties", offsetof( struct VkExternalImageFormatProperties, externalMemoryProperties ), sizeof( VkExternalMemoryProperties ) );
	swigStructField( "VkExternalImageFormatProperties-sType", offsetof( struct VkExternalImageFormatProperties, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkExternalImageFormatProperties ) );

	swigComment("struct VkPhysicalDeviceExternalBufferInfo\n");
	printf( "begin-structure VkPhysicalDeviceExternalBufferInfo\n" );
	swigStructField( "VkPhysicalDeviceExternalBufferInfo-pNext", offsetof( struct VkPhysicalDeviceExternalBufferInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkPhysicalDeviceExternalBufferInfo-usage", offsetof( struct VkPhysicalDeviceExternalBufferInfo, usage ), sizeof( VkBufferUsageFlags ) );
	swigStructField( "VkPhysicalDeviceExternalBufferInfo-handleType", offsetof( struct VkPhysicalDeviceExternalBufferInfo, handleType ), sizeof( VkExternalMemoryHandleTypeFlagBits ) );
	swigStructField( "VkPhysicalDeviceExternalBufferInfo-sType", offsetof( struct VkPhysicalDeviceExternalBufferInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDeviceExternalBufferInfo-flags", offsetof( struct VkPhysicalDeviceExternalBufferInfo, flags ), sizeof( VkBufferCreateFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceExternalBufferInfo ) );

	swigComment("struct VkExternalBufferProperties\n");
	printf( "begin-structure VkExternalBufferProperties\n" );
	swigStructField( "VkExternalBufferProperties-pNext", offsetof( struct VkExternalBufferProperties, pNext ), sizeof( void * ) );
	swigStructField( "VkExternalBufferProperties-externalMemoryProperties", offsetof( struct VkExternalBufferProperties, externalMemoryProperties ), sizeof( VkExternalMemoryProperties ) );
	swigStructField( "VkExternalBufferProperties-sType", offsetof( struct VkExternalBufferProperties, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkExternalBufferProperties ) );

	swigComment("struct VkPhysicalDeviceIDProperties\n");
	printf( "begin-structure VkPhysicalDeviceIDProperties\n" );
	swigStructField( "VkPhysicalDeviceIDProperties-pNext", offsetof( struct VkPhysicalDeviceIDProperties, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceIDProperties-deviceLUID", offsetof( struct VkPhysicalDeviceIDProperties, deviceLUID ), sizeof( uint8_t [8U] ) );
	swigStructField( "VkPhysicalDeviceIDProperties-deviceUUID", offsetof( struct VkPhysicalDeviceIDProperties, deviceUUID ), sizeof( uint8_t [16U] ) );
	swigStructField( "VkPhysicalDeviceIDProperties-deviceLUIDValid", offsetof( struct VkPhysicalDeviceIDProperties, deviceLUIDValid ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceIDProperties-driverUUID", offsetof( struct VkPhysicalDeviceIDProperties, driverUUID ), sizeof( uint8_t [16U] ) );
	swigStructField( "VkPhysicalDeviceIDProperties-deviceNodeMask", offsetof( struct VkPhysicalDeviceIDProperties, deviceNodeMask ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceIDProperties-sType", offsetof( struct VkPhysicalDeviceIDProperties, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceIDProperties ) );

	swigComment("struct VkExternalMemoryImageCreateInfo\n");
	printf( "begin-structure VkExternalMemoryImageCreateInfo\n" );
	swigStructField( "VkExternalMemoryImageCreateInfo-handleTypes", offsetof( struct VkExternalMemoryImageCreateInfo, handleTypes ), sizeof( VkExternalMemoryHandleTypeFlags ) );
	swigStructField( "VkExternalMemoryImageCreateInfo-pNext", offsetof( struct VkExternalMemoryImageCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkExternalMemoryImageCreateInfo-sType", offsetof( struct VkExternalMemoryImageCreateInfo, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkExternalMemoryImageCreateInfo ) );

	swigComment("struct VkExternalMemoryBufferCreateInfo\n");
	printf( "begin-structure VkExternalMemoryBufferCreateInfo\n" );
	swigStructField( "VkExternalMemoryBufferCreateInfo-handleTypes", offsetof( struct VkExternalMemoryBufferCreateInfo, handleTypes ), sizeof( VkExternalMemoryHandleTypeFlags ) );
	swigStructField( "VkExternalMemoryBufferCreateInfo-pNext", offsetof( struct VkExternalMemoryBufferCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkExternalMemoryBufferCreateInfo-sType", offsetof( struct VkExternalMemoryBufferCreateInfo, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkExternalMemoryBufferCreateInfo ) );

	swigComment("struct VkExportMemoryAllocateInfo\n");
	printf( "begin-structure VkExportMemoryAllocateInfo\n" );
	swigStructField( "VkExportMemoryAllocateInfo-handleTypes", offsetof( struct VkExportMemoryAllocateInfo, handleTypes ), sizeof( VkExternalMemoryHandleTypeFlags ) );
	swigStructField( "VkExportMemoryAllocateInfo-pNext", offsetof( struct VkExportMemoryAllocateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkExportMemoryAllocateInfo-sType", offsetof( struct VkExportMemoryAllocateInfo, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkExportMemoryAllocateInfo ) );

	swigComment("struct VkPhysicalDeviceExternalFenceInfo\n");
	printf( "begin-structure VkPhysicalDeviceExternalFenceInfo\n" );
	swigStructField( "VkPhysicalDeviceExternalFenceInfo-pNext", offsetof( struct VkPhysicalDeviceExternalFenceInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkPhysicalDeviceExternalFenceInfo-handleType", offsetof( struct VkPhysicalDeviceExternalFenceInfo, handleType ), sizeof( VkExternalFenceHandleTypeFlagBits ) );
	swigStructField( "VkPhysicalDeviceExternalFenceInfo-sType", offsetof( struct VkPhysicalDeviceExternalFenceInfo, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceExternalFenceInfo ) );

	swigComment("struct VkExternalFenceProperties\n");
	printf( "begin-structure VkExternalFenceProperties\n" );
	swigStructField( "VkExternalFenceProperties-exportFromImportedHandleTypes", offsetof( struct VkExternalFenceProperties, exportFromImportedHandleTypes ), sizeof( VkExternalFenceHandleTypeFlags ) );
	swigStructField( "VkExternalFenceProperties-compatibleHandleTypes", offsetof( struct VkExternalFenceProperties, compatibleHandleTypes ), sizeof( VkExternalFenceHandleTypeFlags ) );
	swigStructField( "VkExternalFenceProperties-externalFenceFeatures", offsetof( struct VkExternalFenceProperties, externalFenceFeatures ), sizeof( VkExternalFenceFeatureFlags ) );
	swigStructField( "VkExternalFenceProperties-pNext", offsetof( struct VkExternalFenceProperties, pNext ), sizeof( void * ) );
	swigStructField( "VkExternalFenceProperties-sType", offsetof( struct VkExternalFenceProperties, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkExternalFenceProperties ) );

	swigComment("struct VkExportFenceCreateInfo\n");
	printf( "begin-structure VkExportFenceCreateInfo\n" );
	swigStructField( "VkExportFenceCreateInfo-handleTypes", offsetof( struct VkExportFenceCreateInfo, handleTypes ), sizeof( VkExternalFenceHandleTypeFlags ) );
	swigStructField( "VkExportFenceCreateInfo-pNext", offsetof( struct VkExportFenceCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkExportFenceCreateInfo-sType", offsetof( struct VkExportFenceCreateInfo, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkExportFenceCreateInfo ) );

	swigComment("struct VkExportSemaphoreCreateInfo\n");
	printf( "begin-structure VkExportSemaphoreCreateInfo\n" );
	swigStructField( "VkExportSemaphoreCreateInfo-handleTypes", offsetof( struct VkExportSemaphoreCreateInfo, handleTypes ), sizeof( VkExternalSemaphoreHandleTypeFlags ) );
	swigStructField( "VkExportSemaphoreCreateInfo-pNext", offsetof( struct VkExportSemaphoreCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkExportSemaphoreCreateInfo-sType", offsetof( struct VkExportSemaphoreCreateInfo, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkExportSemaphoreCreateInfo ) );

	swigComment("struct VkPhysicalDeviceExternalSemaphoreInfo\n");
	printf( "begin-structure VkPhysicalDeviceExternalSemaphoreInfo\n" );
	swigStructField( "VkPhysicalDeviceExternalSemaphoreInfo-pNext", offsetof( struct VkPhysicalDeviceExternalSemaphoreInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkPhysicalDeviceExternalSemaphoreInfo-handleType", offsetof( struct VkPhysicalDeviceExternalSemaphoreInfo, handleType ), sizeof( VkExternalSemaphoreHandleTypeFlagBits ) );
	swigStructField( "VkPhysicalDeviceExternalSemaphoreInfo-sType", offsetof( struct VkPhysicalDeviceExternalSemaphoreInfo, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceExternalSemaphoreInfo ) );

	swigComment("struct VkExternalSemaphoreProperties\n");
	printf( "begin-structure VkExternalSemaphoreProperties\n" );
	swigStructField( "VkExternalSemaphoreProperties-exportFromImportedHandleTypes", offsetof( struct VkExternalSemaphoreProperties, exportFromImportedHandleTypes ), sizeof( VkExternalSemaphoreHandleTypeFlags ) );
	swigStructField( "VkExternalSemaphoreProperties-compatibleHandleTypes", offsetof( struct VkExternalSemaphoreProperties, compatibleHandleTypes ), sizeof( VkExternalSemaphoreHandleTypeFlags ) );
	swigStructField( "VkExternalSemaphoreProperties-externalSemaphoreFeatures", offsetof( struct VkExternalSemaphoreProperties, externalSemaphoreFeatures ), sizeof( VkExternalSemaphoreFeatureFlags ) );
	swigStructField( "VkExternalSemaphoreProperties-pNext", offsetof( struct VkExternalSemaphoreProperties, pNext ), sizeof( void * ) );
	swigStructField( "VkExternalSemaphoreProperties-sType", offsetof( struct VkExternalSemaphoreProperties, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkExternalSemaphoreProperties ) );

	swigComment("struct VkPhysicalDeviceMaintenance3Properties\n");
	printf( "begin-structure VkPhysicalDeviceMaintenance3Properties\n" );
	swigStructField( "VkPhysicalDeviceMaintenance3Properties-pNext", offsetof( struct VkPhysicalDeviceMaintenance3Properties, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceMaintenance3Properties-maxMemoryAllocationSize", offsetof( struct VkPhysicalDeviceMaintenance3Properties, maxMemoryAllocationSize ), sizeof( VkDeviceSize ) );
	swigStructField( "VkPhysicalDeviceMaintenance3Properties-maxPerSetDescriptors", offsetof( struct VkPhysicalDeviceMaintenance3Properties, maxPerSetDescriptors ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceMaintenance3Properties-sType", offsetof( struct VkPhysicalDeviceMaintenance3Properties, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceMaintenance3Properties ) );

	swigComment("struct VkDescriptorSetLayoutSupport\n");
	printf( "begin-structure VkDescriptorSetLayoutSupport\n" );
	swigStructField( "VkDescriptorSetLayoutSupport-pNext", offsetof( struct VkDescriptorSetLayoutSupport, pNext ), sizeof( void * ) );
	swigStructField( "VkDescriptorSetLayoutSupport-supported", offsetof( struct VkDescriptorSetLayoutSupport, supported ), sizeof( VkBool32 ) );
	swigStructField( "VkDescriptorSetLayoutSupport-sType", offsetof( struct VkDescriptorSetLayoutSupport, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDescriptorSetLayoutSupport ) );

	swigComment("struct VkPhysicalDeviceShaderDrawParametersFeatures\n");
	printf( "begin-structure VkPhysicalDeviceShaderDrawParametersFeatures\n" );
	swigStructField( "VkPhysicalDeviceShaderDrawParametersFeatures-pNext", offsetof( struct VkPhysicalDeviceShaderDrawParametersFeatures, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceShaderDrawParametersFeatures-shaderDrawParameters", offsetof( struct VkPhysicalDeviceShaderDrawParametersFeatures, shaderDrawParameters ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderDrawParametersFeatures-sType", offsetof( struct VkPhysicalDeviceShaderDrawParametersFeatures, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceShaderDrawParametersFeatures ) );

	swigComment("struct VkPhysicalDeviceVulkan11Features\n");
	printf( "begin-structure VkPhysicalDeviceVulkan11Features\n" );
	swigStructField( "VkPhysicalDeviceVulkan11Features-shaderDrawParameters", offsetof( struct VkPhysicalDeviceVulkan11Features, shaderDrawParameters ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan11Features-variablePointers", offsetof( struct VkPhysicalDeviceVulkan11Features, variablePointers ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan11Features-protectedMemory", offsetof( struct VkPhysicalDeviceVulkan11Features, protectedMemory ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan11Features-pNext", offsetof( struct VkPhysicalDeviceVulkan11Features, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceVulkan11Features-multiview", offsetof( struct VkPhysicalDeviceVulkan11Features, multiview ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan11Features-storageInputOutput16", offsetof( struct VkPhysicalDeviceVulkan11Features, storageInputOutput16 ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan11Features-storagePushConstant16", offsetof( struct VkPhysicalDeviceVulkan11Features, storagePushConstant16 ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan11Features-multiviewGeometryShader", offsetof( struct VkPhysicalDeviceVulkan11Features, multiviewGeometryShader ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan11Features-samplerYcbcrConversion", offsetof( struct VkPhysicalDeviceVulkan11Features, samplerYcbcrConversion ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan11Features-uniformAndStorageBuffer16BitAccess", offsetof( struct VkPhysicalDeviceVulkan11Features, uniformAndStorageBuffer16BitAccess ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan11Features-storageBuffer16BitAccess", offsetof( struct VkPhysicalDeviceVulkan11Features, storageBuffer16BitAccess ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan11Features-multiviewTessellationShader", offsetof( struct VkPhysicalDeviceVulkan11Features, multiviewTessellationShader ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan11Features-sType", offsetof( struct VkPhysicalDeviceVulkan11Features, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDeviceVulkan11Features-variablePointersStorageBuffer", offsetof( struct VkPhysicalDeviceVulkan11Features, variablePointersStorageBuffer ), sizeof( VkBool32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceVulkan11Features ) );

	swigComment("struct VkPhysicalDeviceVulkan11Properties\n");
	printf( "begin-structure VkPhysicalDeviceVulkan11Properties\n" );
	swigStructField( "VkPhysicalDeviceVulkan11Properties-driverUUID", offsetof( struct VkPhysicalDeviceVulkan11Properties, driverUUID ), sizeof( uint8_t [16U] ) );
	swigStructField( "VkPhysicalDeviceVulkan11Properties-pointClippingBehavior", offsetof( struct VkPhysicalDeviceVulkan11Properties, pointClippingBehavior ), sizeof( VkPointClippingBehavior ) );
	swigStructField( "VkPhysicalDeviceVulkan11Properties-deviceLUID", offsetof( struct VkPhysicalDeviceVulkan11Properties, deviceLUID ), sizeof( uint8_t [8U] ) );
	swigStructField( "VkPhysicalDeviceVulkan11Properties-subgroupSize", offsetof( struct VkPhysicalDeviceVulkan11Properties, subgroupSize ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceVulkan11Properties-maxPerSetDescriptors", offsetof( struct VkPhysicalDeviceVulkan11Properties, maxPerSetDescriptors ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceVulkan11Properties-pNext", offsetof( struct VkPhysicalDeviceVulkan11Properties, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceVulkan11Properties-maxMultiviewInstanceIndex", offsetof( struct VkPhysicalDeviceVulkan11Properties, maxMultiviewInstanceIndex ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceVulkan11Properties-protectedNoFault", offsetof( struct VkPhysicalDeviceVulkan11Properties, protectedNoFault ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan11Properties-deviceLUIDValid", offsetof( struct VkPhysicalDeviceVulkan11Properties, deviceLUIDValid ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan11Properties-maxMemoryAllocationSize", offsetof( struct VkPhysicalDeviceVulkan11Properties, maxMemoryAllocationSize ), sizeof( VkDeviceSize ) );
	swigStructField( "VkPhysicalDeviceVulkan11Properties-subgroupSupportedOperations", offsetof( struct VkPhysicalDeviceVulkan11Properties, subgroupSupportedOperations ), sizeof( VkSubgroupFeatureFlags ) );
	swigStructField( "VkPhysicalDeviceVulkan11Properties-deviceUUID", offsetof( struct VkPhysicalDeviceVulkan11Properties, deviceUUID ), sizeof( uint8_t [16U] ) );
	swigStructField( "VkPhysicalDeviceVulkan11Properties-deviceNodeMask", offsetof( struct VkPhysicalDeviceVulkan11Properties, deviceNodeMask ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceVulkan11Properties-subgroupQuadOperationsInAllStages", offsetof( struct VkPhysicalDeviceVulkan11Properties, subgroupQuadOperationsInAllStages ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan11Properties-subgroupSupportedStages", offsetof( struct VkPhysicalDeviceVulkan11Properties, subgroupSupportedStages ), sizeof( VkShaderStageFlags ) );
	swigStructField( "VkPhysicalDeviceVulkan11Properties-sType", offsetof( struct VkPhysicalDeviceVulkan11Properties, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDeviceVulkan11Properties-maxMultiviewViewCount", offsetof( struct VkPhysicalDeviceVulkan11Properties, maxMultiviewViewCount ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceVulkan11Properties ) );

	swigComment("struct VkPhysicalDeviceVulkan12Features\n");
	printf( "begin-structure VkPhysicalDeviceVulkan12Features\n" );
	swigStructField( "VkPhysicalDeviceVulkan12Features-shaderStorageTexelBufferArrayNonUniformIndexing", offsetof( struct VkPhysicalDeviceVulkan12Features, shaderStorageTexelBufferArrayNonUniformIndexing ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Features-shaderUniformTexelBufferArrayNonUniformIndexing", offsetof( struct VkPhysicalDeviceVulkan12Features, shaderUniformTexelBufferArrayNonUniformIndexing ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Features-shaderInputAttachmentArrayNonUniformIndexing", offsetof( struct VkPhysicalDeviceVulkan12Features, shaderInputAttachmentArrayNonUniformIndexing ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Features-shaderStorageImageArrayNonUniformIndexing", offsetof( struct VkPhysicalDeviceVulkan12Features, shaderStorageImageArrayNonUniformIndexing ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Features-shaderStorageBufferArrayNonUniformIndexing", offsetof( struct VkPhysicalDeviceVulkan12Features, shaderStorageBufferArrayNonUniformIndexing ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Features-shaderSampledImageArrayNonUniformIndexing", offsetof( struct VkPhysicalDeviceVulkan12Features, shaderSampledImageArrayNonUniformIndexing ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Features-shaderUniformBufferArrayNonUniformIndexing", offsetof( struct VkPhysicalDeviceVulkan12Features, shaderUniformBufferArrayNonUniformIndexing ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Features-shaderStorageTexelBufferArrayDynamicIndexing", offsetof( struct VkPhysicalDeviceVulkan12Features, shaderStorageTexelBufferArrayDynamicIndexing ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Features-descriptorIndexing", offsetof( struct VkPhysicalDeviceVulkan12Features, descriptorIndexing ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Features-shaderInputAttachmentArrayDynamicIndexing", offsetof( struct VkPhysicalDeviceVulkan12Features, shaderInputAttachmentArrayDynamicIndexing ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Features-shaderUniformTexelBufferArrayDynamicIndexing", offsetof( struct VkPhysicalDeviceVulkan12Features, shaderUniformTexelBufferArrayDynamicIndexing ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Features-bufferDeviceAddress", offsetof( struct VkPhysicalDeviceVulkan12Features, bufferDeviceAddress ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Features-subgroupBroadcastDynamicId", offsetof( struct VkPhysicalDeviceVulkan12Features, subgroupBroadcastDynamicId ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Features-samplerMirrorClampToEdge", offsetof( struct VkPhysicalDeviceVulkan12Features, samplerMirrorClampToEdge ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Features-shaderOutputLayer", offsetof( struct VkPhysicalDeviceVulkan12Features, shaderOutputLayer ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Features-sType", offsetof( struct VkPhysicalDeviceVulkan12Features, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDeviceVulkan12Features-descriptorBindingUpdateUnusedWhilePending", offsetof( struct VkPhysicalDeviceVulkan12Features, descriptorBindingUpdateUnusedWhilePending ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Features-vulkanMemoryModelAvailabilityVisibilityChains", offsetof( struct VkPhysicalDeviceVulkan12Features, vulkanMemoryModelAvailabilityVisibilityChains ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Features-storageBuffer8BitAccess", offsetof( struct VkPhysicalDeviceVulkan12Features, storageBuffer8BitAccess ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Features-uniformAndStorageBuffer8BitAccess", offsetof( struct VkPhysicalDeviceVulkan12Features, uniformAndStorageBuffer8BitAccess ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Features-imagelessFramebuffer", offsetof( struct VkPhysicalDeviceVulkan12Features, imagelessFramebuffer ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Features-bufferDeviceAddressMultiDevice", offsetof( struct VkPhysicalDeviceVulkan12Features, bufferDeviceAddressMultiDevice ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Features-shaderInt8", offsetof( struct VkPhysicalDeviceVulkan12Features, shaderInt8 ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Features-shaderBufferInt64Atomics", offsetof( struct VkPhysicalDeviceVulkan12Features, shaderBufferInt64Atomics ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Features-shaderSharedInt64Atomics", offsetof( struct VkPhysicalDeviceVulkan12Features, shaderSharedInt64Atomics ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Features-separateDepthStencilLayouts", offsetof( struct VkPhysicalDeviceVulkan12Features, separateDepthStencilLayouts ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Features-shaderFloat16", offsetof( struct VkPhysicalDeviceVulkan12Features, shaderFloat16 ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Features-vulkanMemoryModel", offsetof( struct VkPhysicalDeviceVulkan12Features, vulkanMemoryModel ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Features-timelineSemaphore", offsetof( struct VkPhysicalDeviceVulkan12Features, timelineSemaphore ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Features-shaderSubgroupExtendedTypes", offsetof( struct VkPhysicalDeviceVulkan12Features, shaderSubgroupExtendedTypes ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Features-descriptorBindingStorageTexelBufferUpdateAfterBind", offsetof( struct VkPhysicalDeviceVulkan12Features, descriptorBindingStorageTexelBufferUpdateAfterBind ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Features-descriptorBindingUniformTexelBufferUpdateAfterBind", offsetof( struct VkPhysicalDeviceVulkan12Features, descriptorBindingUniformTexelBufferUpdateAfterBind ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Features-descriptorBindingStorageBufferUpdateAfterBind", offsetof( struct VkPhysicalDeviceVulkan12Features, descriptorBindingStorageBufferUpdateAfterBind ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Features-descriptorBindingStorageImageUpdateAfterBind", offsetof( struct VkPhysicalDeviceVulkan12Features, descriptorBindingStorageImageUpdateAfterBind ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Features-descriptorBindingSampledImageUpdateAfterBind", offsetof( struct VkPhysicalDeviceVulkan12Features, descriptorBindingSampledImageUpdateAfterBind ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Features-descriptorBindingUniformBufferUpdateAfterBind", offsetof( struct VkPhysicalDeviceVulkan12Features, descriptorBindingUniformBufferUpdateAfterBind ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Features-storagePushConstant8", offsetof( struct VkPhysicalDeviceVulkan12Features, storagePushConstant8 ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Features-pNext", offsetof( struct VkPhysicalDeviceVulkan12Features, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceVulkan12Features-uniformBufferStandardLayout", offsetof( struct VkPhysicalDeviceVulkan12Features, uniformBufferStandardLayout ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Features-descriptorBindingPartiallyBound", offsetof( struct VkPhysicalDeviceVulkan12Features, descriptorBindingPartiallyBound ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Features-runtimeDescriptorArray", offsetof( struct VkPhysicalDeviceVulkan12Features, runtimeDescriptorArray ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Features-shaderOutputViewportIndex", offsetof( struct VkPhysicalDeviceVulkan12Features, shaderOutputViewportIndex ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Features-descriptorBindingVariableDescriptorCount", offsetof( struct VkPhysicalDeviceVulkan12Features, descriptorBindingVariableDescriptorCount ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Features-samplerFilterMinmax", offsetof( struct VkPhysicalDeviceVulkan12Features, samplerFilterMinmax ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Features-scalarBlockLayout", offsetof( struct VkPhysicalDeviceVulkan12Features, scalarBlockLayout ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Features-bufferDeviceAddressCaptureReplay", offsetof( struct VkPhysicalDeviceVulkan12Features, bufferDeviceAddressCaptureReplay ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Features-vulkanMemoryModelDeviceScope", offsetof( struct VkPhysicalDeviceVulkan12Features, vulkanMemoryModelDeviceScope ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Features-drawIndirectCount", offsetof( struct VkPhysicalDeviceVulkan12Features, drawIndirectCount ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Features-hostQueryReset", offsetof( struct VkPhysicalDeviceVulkan12Features, hostQueryReset ), sizeof( VkBool32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceVulkan12Features ) );

	swigComment("struct VkConformanceVersion\n");
	printf( "begin-structure VkConformanceVersion\n" );
	swigStructField( "VkConformanceVersion-subminor", offsetof( struct VkConformanceVersion, subminor ), sizeof( uint8_t ) );
	swigStructField( "VkConformanceVersion-major", offsetof( struct VkConformanceVersion, major ), sizeof( uint8_t ) );
	swigStructField( "VkConformanceVersion-minor", offsetof( struct VkConformanceVersion, minor ), sizeof( uint8_t ) );
	swigStructField( "VkConformanceVersion-patch", offsetof( struct VkConformanceVersion, patch ), sizeof( uint8_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkConformanceVersion ) );

	swigComment("struct VkPhysicalDeviceVulkan12Properties\n");
	printf( "begin-structure VkPhysicalDeviceVulkan12Properties\n" );
	swigStructField( "VkPhysicalDeviceVulkan12Properties-maxPerStageDescriptorUpdateAfterBindSamplers", offsetof( struct VkPhysicalDeviceVulkan12Properties, maxPerStageDescriptorUpdateAfterBindSamplers ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceVulkan12Properties-maxDescriptorSetUpdateAfterBindSamplers", offsetof( struct VkPhysicalDeviceVulkan12Properties, maxDescriptorSetUpdateAfterBindSamplers ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceVulkan12Properties-conformanceVersion", offsetof( struct VkPhysicalDeviceVulkan12Properties, conformanceVersion ), sizeof( VkConformanceVersion ) );
	swigStructField( "VkPhysicalDeviceVulkan12Properties-maxDescriptorSetUpdateAfterBindInputAttachments", offsetof( struct VkPhysicalDeviceVulkan12Properties, maxDescriptorSetUpdateAfterBindInputAttachments ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceVulkan12Properties-sType", offsetof( struct VkPhysicalDeviceVulkan12Properties, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDeviceVulkan12Properties-maxTimelineSemaphoreValueDifference", offsetof( struct VkPhysicalDeviceVulkan12Properties, maxTimelineSemaphoreValueDifference ), sizeof( uint64_t ) );
	swigStructField( "VkPhysicalDeviceVulkan12Properties-driverID", offsetof( struct VkPhysicalDeviceVulkan12Properties, driverID ), sizeof( VkDriverId ) );
	swigStructField( "VkPhysicalDeviceVulkan12Properties-shaderInputAttachmentArrayNonUniformIndexingNative", offsetof( struct VkPhysicalDeviceVulkan12Properties, shaderInputAttachmentArrayNonUniformIndexingNative ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Properties-shaderStorageImageArrayNonUniformIndexingNative", offsetof( struct VkPhysicalDeviceVulkan12Properties, shaderStorageImageArrayNonUniformIndexingNative ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Properties-shaderStorageBufferArrayNonUniformIndexingNative", offsetof( struct VkPhysicalDeviceVulkan12Properties, shaderStorageBufferArrayNonUniformIndexingNative ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Properties-shaderSampledImageArrayNonUniformIndexingNative", offsetof( struct VkPhysicalDeviceVulkan12Properties, shaderSampledImageArrayNonUniformIndexingNative ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Properties-shaderUniformBufferArrayNonUniformIndexingNative", offsetof( struct VkPhysicalDeviceVulkan12Properties, shaderUniformBufferArrayNonUniformIndexingNative ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Properties-denormBehaviorIndependence", offsetof( struct VkPhysicalDeviceVulkan12Properties, denormBehaviorIndependence ), sizeof( VkShaderFloatControlsIndependence ) );
	swigStructField( "VkPhysicalDeviceVulkan12Properties-roundingModeIndependence", offsetof( struct VkPhysicalDeviceVulkan12Properties, roundingModeIndependence ), sizeof( VkShaderFloatControlsIndependence ) );
	swigStructField( "VkPhysicalDeviceVulkan12Properties-shaderRoundingModeRTZFloat16", offsetof( struct VkPhysicalDeviceVulkan12Properties, shaderRoundingModeRTZFloat16 ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Properties-shaderRoundingModeRTEFloat16", offsetof( struct VkPhysicalDeviceVulkan12Properties, shaderRoundingModeRTEFloat16 ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Properties-shaderDenormFlushToZeroFloat16", offsetof( struct VkPhysicalDeviceVulkan12Properties, shaderDenormFlushToZeroFloat16 ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Properties-shaderSignedZeroInfNanPreserveFloat16", offsetof( struct VkPhysicalDeviceVulkan12Properties, shaderSignedZeroInfNanPreserveFloat16 ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Properties-shaderDenormPreserveFloat16", offsetof( struct VkPhysicalDeviceVulkan12Properties, shaderDenormPreserveFloat16 ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Properties-independentResolve", offsetof( struct VkPhysicalDeviceVulkan12Properties, independentResolve ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Properties-framebufferIntegerColorSampleCounts", offsetof( struct VkPhysicalDeviceVulkan12Properties, framebufferIntegerColorSampleCounts ), sizeof( VkSampleCountFlags ) );
	swigStructField( "VkPhysicalDeviceVulkan12Properties-quadDivergentImplicitLod", offsetof( struct VkPhysicalDeviceVulkan12Properties, quadDivergentImplicitLod ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Properties-maxPerStageDescriptorUpdateAfterBindSampledImages", offsetof( struct VkPhysicalDeviceVulkan12Properties, maxPerStageDescriptorUpdateAfterBindSampledImages ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceVulkan12Properties-maxDescriptorSetUpdateAfterBindSampledImages", offsetof( struct VkPhysicalDeviceVulkan12Properties, maxDescriptorSetUpdateAfterBindSampledImages ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceVulkan12Properties-robustBufferAccessUpdateAfterBind", offsetof( struct VkPhysicalDeviceVulkan12Properties, robustBufferAccessUpdateAfterBind ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Properties-pNext", offsetof( struct VkPhysicalDeviceVulkan12Properties, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceVulkan12Properties-shaderRoundingModeRTZFloat64", offsetof( struct VkPhysicalDeviceVulkan12Properties, shaderRoundingModeRTZFloat64 ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Properties-shaderRoundingModeRTEFloat64", offsetof( struct VkPhysicalDeviceVulkan12Properties, shaderRoundingModeRTEFloat64 ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Properties-shaderDenormFlushToZeroFloat64", offsetof( struct VkPhysicalDeviceVulkan12Properties, shaderDenormFlushToZeroFloat64 ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Properties-shaderSignedZeroInfNanPreserveFloat64", offsetof( struct VkPhysicalDeviceVulkan12Properties, shaderSignedZeroInfNanPreserveFloat64 ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Properties-shaderDenormPreserveFloat64", offsetof( struct VkPhysicalDeviceVulkan12Properties, shaderDenormPreserveFloat64 ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Properties-driverInfo", offsetof( struct VkPhysicalDeviceVulkan12Properties, driverInfo ), sizeof( char [256U] ) );
	swigStructField( "VkPhysicalDeviceVulkan12Properties-maxDescriptorSetUpdateAfterBindUniformBuffersDynamic", offsetof( struct VkPhysicalDeviceVulkan12Properties, maxDescriptorSetUpdateAfterBindUniformBuffersDynamic ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceVulkan12Properties-maxDescriptorSetUpdateAfterBindStorageBuffersDynamic", offsetof( struct VkPhysicalDeviceVulkan12Properties, maxDescriptorSetUpdateAfterBindStorageBuffersDynamic ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceVulkan12Properties-independentResolveNone", offsetof( struct VkPhysicalDeviceVulkan12Properties, independentResolveNone ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Properties-maxUpdateAfterBindDescriptorsInAllPools", offsetof( struct VkPhysicalDeviceVulkan12Properties, maxUpdateAfterBindDescriptorsInAllPools ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceVulkan12Properties-maxPerStageUpdateAfterBindResources", offsetof( struct VkPhysicalDeviceVulkan12Properties, maxPerStageUpdateAfterBindResources ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceVulkan12Properties-driverName", offsetof( struct VkPhysicalDeviceVulkan12Properties, driverName ), sizeof( char [256U] ) );
	swigStructField( "VkPhysicalDeviceVulkan12Properties-supportedDepthResolveModes", offsetof( struct VkPhysicalDeviceVulkan12Properties, supportedDepthResolveModes ), sizeof( VkResolveModeFlags ) );
	swigStructField( "VkPhysicalDeviceVulkan12Properties-supportedStencilResolveModes", offsetof( struct VkPhysicalDeviceVulkan12Properties, supportedStencilResolveModes ), sizeof( VkResolveModeFlags ) );
	swigStructField( "VkPhysicalDeviceVulkan12Properties-maxPerStageDescriptorUpdateAfterBindStorageImages", offsetof( struct VkPhysicalDeviceVulkan12Properties, maxPerStageDescriptorUpdateAfterBindStorageImages ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceVulkan12Properties-maxDescriptorSetUpdateAfterBindStorageImages", offsetof( struct VkPhysicalDeviceVulkan12Properties, maxDescriptorSetUpdateAfterBindStorageImages ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceVulkan12Properties-maxPerStageDescriptorUpdateAfterBindInputAttachments", offsetof( struct VkPhysicalDeviceVulkan12Properties, maxPerStageDescriptorUpdateAfterBindInputAttachments ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceVulkan12Properties-filterMinmaxSingleComponentFormats", offsetof( struct VkPhysicalDeviceVulkan12Properties, filterMinmaxSingleComponentFormats ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Properties-shaderRoundingModeRTZFloat32", offsetof( struct VkPhysicalDeviceVulkan12Properties, shaderRoundingModeRTZFloat32 ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Properties-shaderRoundingModeRTEFloat32", offsetof( struct VkPhysicalDeviceVulkan12Properties, shaderRoundingModeRTEFloat32 ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Properties-shaderDenormFlushToZeroFloat32", offsetof( struct VkPhysicalDeviceVulkan12Properties, shaderDenormFlushToZeroFloat32 ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Properties-shaderSignedZeroInfNanPreserveFloat32", offsetof( struct VkPhysicalDeviceVulkan12Properties, shaderSignedZeroInfNanPreserveFloat32 ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Properties-shaderDenormPreserveFloat32", offsetof( struct VkPhysicalDeviceVulkan12Properties, shaderDenormPreserveFloat32 ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Properties-filterMinmaxImageComponentMapping", offsetof( struct VkPhysicalDeviceVulkan12Properties, filterMinmaxImageComponentMapping ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkan12Properties-maxPerStageDescriptorUpdateAfterBindStorageBuffers", offsetof( struct VkPhysicalDeviceVulkan12Properties, maxPerStageDescriptorUpdateAfterBindStorageBuffers ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceVulkan12Properties-maxPerStageDescriptorUpdateAfterBindUniformBuffers", offsetof( struct VkPhysicalDeviceVulkan12Properties, maxPerStageDescriptorUpdateAfterBindUniformBuffers ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceVulkan12Properties-maxDescriptorSetUpdateAfterBindUniformBuffers", offsetof( struct VkPhysicalDeviceVulkan12Properties, maxDescriptorSetUpdateAfterBindUniformBuffers ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceVulkan12Properties-maxDescriptorSetUpdateAfterBindStorageBuffers", offsetof( struct VkPhysicalDeviceVulkan12Properties, maxDescriptorSetUpdateAfterBindStorageBuffers ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceVulkan12Properties ) );

	swigComment("struct VkImageFormatListCreateInfo\n");
	printf( "begin-structure VkImageFormatListCreateInfo\n" );
	swigStructField( "VkImageFormatListCreateInfo-pNext", offsetof( struct VkImageFormatListCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkImageFormatListCreateInfo-pViewFormats", offsetof( struct VkImageFormatListCreateInfo, pViewFormats ), sizeof( VkFormat const * ) );
	swigStructField( "VkImageFormatListCreateInfo-sType", offsetof( struct VkImageFormatListCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkImageFormatListCreateInfo-viewFormatCount", offsetof( struct VkImageFormatListCreateInfo, viewFormatCount ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkImageFormatListCreateInfo ) );

	swigComment("struct VkAttachmentDescription2\n");
	printf( "begin-structure VkAttachmentDescription2\n" );
	swigStructField( "VkAttachmentDescription2-pNext", offsetof( struct VkAttachmentDescription2, pNext ), sizeof( void const * ) );
	swigStructField( "VkAttachmentDescription2-initialLayout", offsetof( struct VkAttachmentDescription2, initialLayout ), sizeof( VkImageLayout ) );
	swigStructField( "VkAttachmentDescription2-finalLayout", offsetof( struct VkAttachmentDescription2, finalLayout ), sizeof( VkImageLayout ) );
	swigStructField( "VkAttachmentDescription2-storeOp", offsetof( struct VkAttachmentDescription2, storeOp ), sizeof( VkAttachmentStoreOp ) );
	swigStructField( "VkAttachmentDescription2-stencilLoadOp", offsetof( struct VkAttachmentDescription2, stencilLoadOp ), sizeof( VkAttachmentLoadOp ) );
	swigStructField( "VkAttachmentDescription2-stencilStoreOp", offsetof( struct VkAttachmentDescription2, stencilStoreOp ), sizeof( VkAttachmentStoreOp ) );
	swigStructField( "VkAttachmentDescription2-samples", offsetof( struct VkAttachmentDescription2, samples ), sizeof( VkSampleCountFlagBits ) );
	swigStructField( "VkAttachmentDescription2-loadOp", offsetof( struct VkAttachmentDescription2, loadOp ), sizeof( VkAttachmentLoadOp ) );
	swigStructField( "VkAttachmentDescription2-sType", offsetof( struct VkAttachmentDescription2, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkAttachmentDescription2-flags", offsetof( struct VkAttachmentDescription2, flags ), sizeof( VkAttachmentDescriptionFlags ) );
	swigStructField( "VkAttachmentDescription2-format", offsetof( struct VkAttachmentDescription2, format ), sizeof( VkFormat ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkAttachmentDescription2 ) );

	swigComment("struct VkAttachmentReference2\n");
	printf( "begin-structure VkAttachmentReference2\n" );
	swigStructField( "VkAttachmentReference2-pNext", offsetof( struct VkAttachmentReference2, pNext ), sizeof( void const * ) );
	swigStructField( "VkAttachmentReference2-attachment", offsetof( struct VkAttachmentReference2, attachment ), sizeof( uint32_t ) );
	swigStructField( "VkAttachmentReference2-layout", offsetof( struct VkAttachmentReference2, layout ), sizeof( VkImageLayout ) );
	swigStructField( "VkAttachmentReference2-sType", offsetof( struct VkAttachmentReference2, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkAttachmentReference2-aspectMask", offsetof( struct VkAttachmentReference2, aspectMask ), sizeof( VkImageAspectFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkAttachmentReference2 ) );

	swigComment("struct VkSubpassDescription2\n");
	printf( "begin-structure VkSubpassDescription2\n" );
	swigStructField( "VkSubpassDescription2-pNext", offsetof( struct VkSubpassDescription2, pNext ), sizeof( void const * ) );
	swigStructField( "VkSubpassDescription2-viewMask", offsetof( struct VkSubpassDescription2, viewMask ), sizeof( uint32_t ) );
	swigStructField( "VkSubpassDescription2-pInputAttachments", offsetof( struct VkSubpassDescription2, pInputAttachments ), sizeof( VkAttachmentReference2 const * ) );
	swigStructField( "VkSubpassDescription2-pColorAttachments", offsetof( struct VkSubpassDescription2, pColorAttachments ), sizeof( VkAttachmentReference2 const * ) );
	swigStructField( "VkSubpassDescription2-pResolveAttachments", offsetof( struct VkSubpassDescription2, pResolveAttachments ), sizeof( VkAttachmentReference2 const * ) );
	swigStructField( "VkSubpassDescription2-pDepthStencilAttachment", offsetof( struct VkSubpassDescription2, pDepthStencilAttachment ), sizeof( VkAttachmentReference2 const * ) );
	swigStructField( "VkSubpassDescription2-pPreserveAttachments", offsetof( struct VkSubpassDescription2, pPreserveAttachments ), sizeof( uint32_t const * ) );
	swigStructField( "VkSubpassDescription2-pipelineBindPoint", offsetof( struct VkSubpassDescription2, pipelineBindPoint ), sizeof( VkPipelineBindPoint ) );
	swigStructField( "VkSubpassDescription2-sType", offsetof( struct VkSubpassDescription2, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkSubpassDescription2-flags", offsetof( struct VkSubpassDescription2, flags ), sizeof( VkSubpassDescriptionFlags ) );
	swigStructField( "VkSubpassDescription2-inputAttachmentCount", offsetof( struct VkSubpassDescription2, inputAttachmentCount ), sizeof( uint32_t ) );
	swigStructField( "VkSubpassDescription2-colorAttachmentCount", offsetof( struct VkSubpassDescription2, colorAttachmentCount ), sizeof( uint32_t ) );
	swigStructField( "VkSubpassDescription2-preserveAttachmentCount", offsetof( struct VkSubpassDescription2, preserveAttachmentCount ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSubpassDescription2 ) );

	swigComment("struct VkSubpassDependency2\n");
	printf( "begin-structure VkSubpassDependency2\n" );
	swigStructField( "VkSubpassDependency2-pNext", offsetof( struct VkSubpassDependency2, pNext ), sizeof( void const * ) );
	swigStructField( "VkSubpassDependency2-srcStageMask", offsetof( struct VkSubpassDependency2, srcStageMask ), sizeof( VkPipelineStageFlags ) );
	swigStructField( "VkSubpassDependency2-dstStageMask", offsetof( struct VkSubpassDependency2, dstStageMask ), sizeof( VkPipelineStageFlags ) );
	swigStructField( "VkSubpassDependency2-viewOffset", offsetof( struct VkSubpassDependency2, viewOffset ), sizeof( int32_t ) );
	swigStructField( "VkSubpassDependency2-dependencyFlags", offsetof( struct VkSubpassDependency2, dependencyFlags ), sizeof( VkDependencyFlags ) );
	swigStructField( "VkSubpassDependency2-sType", offsetof( struct VkSubpassDependency2, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkSubpassDependency2-srcSubpass", offsetof( struct VkSubpassDependency2, srcSubpass ), sizeof( uint32_t ) );
	swigStructField( "VkSubpassDependency2-dstSubpass", offsetof( struct VkSubpassDependency2, dstSubpass ), sizeof( uint32_t ) );
	swigStructField( "VkSubpassDependency2-srcAccessMask", offsetof( struct VkSubpassDependency2, srcAccessMask ), sizeof( VkAccessFlags ) );
	swigStructField( "VkSubpassDependency2-dstAccessMask", offsetof( struct VkSubpassDependency2, dstAccessMask ), sizeof( VkAccessFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSubpassDependency2 ) );

	swigComment("struct VkRenderPassCreateInfo2\n");
	printf( "begin-structure VkRenderPassCreateInfo2\n" );
	swigStructField( "VkRenderPassCreateInfo2-pNext", offsetof( struct VkRenderPassCreateInfo2, pNext ), sizeof( void const * ) );
	swigStructField( "VkRenderPassCreateInfo2-pAttachments", offsetof( struct VkRenderPassCreateInfo2, pAttachments ), sizeof( VkAttachmentDescription2 const * ) );
	swigStructField( "VkRenderPassCreateInfo2-dependencyCount", offsetof( struct VkRenderPassCreateInfo2, dependencyCount ), sizeof( uint32_t ) );
	swigStructField( "VkRenderPassCreateInfo2-correlatedViewMaskCount", offsetof( struct VkRenderPassCreateInfo2, correlatedViewMaskCount ), sizeof( uint32_t ) );
	swigStructField( "VkRenderPassCreateInfo2-subpassCount", offsetof( struct VkRenderPassCreateInfo2, subpassCount ), sizeof( uint32_t ) );
	swigStructField( "VkRenderPassCreateInfo2-pSubpasses", offsetof( struct VkRenderPassCreateInfo2, pSubpasses ), sizeof( VkSubpassDescription2 const * ) );
	swigStructField( "VkRenderPassCreateInfo2-sType", offsetof( struct VkRenderPassCreateInfo2, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkRenderPassCreateInfo2-flags", offsetof( struct VkRenderPassCreateInfo2, flags ), sizeof( VkRenderPassCreateFlags ) );
	swigStructField( "VkRenderPassCreateInfo2-pDependencies", offsetof( struct VkRenderPassCreateInfo2, pDependencies ), sizeof( VkSubpassDependency2 const * ) );
	swigStructField( "VkRenderPassCreateInfo2-attachmentCount", offsetof( struct VkRenderPassCreateInfo2, attachmentCount ), sizeof( uint32_t ) );
	swigStructField( "VkRenderPassCreateInfo2-pCorrelatedViewMasks", offsetof( struct VkRenderPassCreateInfo2, pCorrelatedViewMasks ), sizeof( uint32_t const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkRenderPassCreateInfo2 ) );

	swigComment("struct VkSubpassBeginInfo\n");
	printf( "begin-structure VkSubpassBeginInfo\n" );
	swigStructField( "VkSubpassBeginInfo-pNext", offsetof( struct VkSubpassBeginInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkSubpassBeginInfo-sType", offsetof( struct VkSubpassBeginInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkSubpassBeginInfo-contents", offsetof( struct VkSubpassBeginInfo, contents ), sizeof( VkSubpassContents ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSubpassBeginInfo ) );

	swigComment("struct VkSubpassEndInfo\n");
	printf( "begin-structure VkSubpassEndInfo\n" );
	swigStructField( "VkSubpassEndInfo-pNext", offsetof( struct VkSubpassEndInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkSubpassEndInfo-sType", offsetof( struct VkSubpassEndInfo, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSubpassEndInfo ) );

	swigComment("struct VkPhysicalDevice8BitStorageFeatures\n");
	printf( "begin-structure VkPhysicalDevice8BitStorageFeatures\n" );
	swigStructField( "VkPhysicalDevice8BitStorageFeatures-storageBuffer8BitAccess", offsetof( struct VkPhysicalDevice8BitStorageFeatures, storageBuffer8BitAccess ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDevice8BitStorageFeatures-uniformAndStorageBuffer8BitAccess", offsetof( struct VkPhysicalDevice8BitStorageFeatures, uniformAndStorageBuffer8BitAccess ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDevice8BitStorageFeatures-pNext", offsetof( struct VkPhysicalDevice8BitStorageFeatures, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDevice8BitStorageFeatures-storagePushConstant8", offsetof( struct VkPhysicalDevice8BitStorageFeatures, storagePushConstant8 ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDevice8BitStorageFeatures-sType", offsetof( struct VkPhysicalDevice8BitStorageFeatures, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDevice8BitStorageFeatures ) );

	swigComment("struct VkPhysicalDeviceDriverProperties\n");
	printf( "begin-structure VkPhysicalDeviceDriverProperties\n" );
	swigStructField( "VkPhysicalDeviceDriverProperties-pNext", offsetof( struct VkPhysicalDeviceDriverProperties, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceDriverProperties-driverName", offsetof( struct VkPhysicalDeviceDriverProperties, driverName ), sizeof( char [256U] ) );
	swigStructField( "VkPhysicalDeviceDriverProperties-conformanceVersion", offsetof( struct VkPhysicalDeviceDriverProperties, conformanceVersion ), sizeof( VkConformanceVersion ) );
	swigStructField( "VkPhysicalDeviceDriverProperties-driverID", offsetof( struct VkPhysicalDeviceDriverProperties, driverID ), sizeof( VkDriverId ) );
	swigStructField( "VkPhysicalDeviceDriverProperties-sType", offsetof( struct VkPhysicalDeviceDriverProperties, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDeviceDriverProperties-driverInfo", offsetof( struct VkPhysicalDeviceDriverProperties, driverInfo ), sizeof( char [256U] ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceDriverProperties ) );

	swigComment("struct VkPhysicalDeviceShaderAtomicInt64Features\n");
	printf( "begin-structure VkPhysicalDeviceShaderAtomicInt64Features\n" );
	swigStructField( "VkPhysicalDeviceShaderAtomicInt64Features-pNext", offsetof( struct VkPhysicalDeviceShaderAtomicInt64Features, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceShaderAtomicInt64Features-sType", offsetof( struct VkPhysicalDeviceShaderAtomicInt64Features, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDeviceShaderAtomicInt64Features-shaderBufferInt64Atomics", offsetof( struct VkPhysicalDeviceShaderAtomicInt64Features, shaderBufferInt64Atomics ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderAtomicInt64Features-shaderSharedInt64Atomics", offsetof( struct VkPhysicalDeviceShaderAtomicInt64Features, shaderSharedInt64Atomics ), sizeof( VkBool32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceShaderAtomicInt64Features ) );

	swigComment("struct VkPhysicalDeviceShaderFloat16Int8Features\n");
	printf( "begin-structure VkPhysicalDeviceShaderFloat16Int8Features\n" );
	swigStructField( "VkPhysicalDeviceShaderFloat16Int8Features-pNext", offsetof( struct VkPhysicalDeviceShaderFloat16Int8Features, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceShaderFloat16Int8Features-sType", offsetof( struct VkPhysicalDeviceShaderFloat16Int8Features, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDeviceShaderFloat16Int8Features-shaderFloat16", offsetof( struct VkPhysicalDeviceShaderFloat16Int8Features, shaderFloat16 ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderFloat16Int8Features-shaderInt8", offsetof( struct VkPhysicalDeviceShaderFloat16Int8Features, shaderInt8 ), sizeof( VkBool32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceShaderFloat16Int8Features ) );

	swigComment("struct VkPhysicalDeviceFloatControlsProperties\n");
	printf( "begin-structure VkPhysicalDeviceFloatControlsProperties\n" );
	swigStructField( "VkPhysicalDeviceFloatControlsProperties-shaderDenormFlushToZeroFloat64", offsetof( struct VkPhysicalDeviceFloatControlsProperties, shaderDenormFlushToZeroFloat64 ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFloatControlsProperties-shaderDenormPreserveFloat64", offsetof( struct VkPhysicalDeviceFloatControlsProperties, shaderDenormPreserveFloat64 ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFloatControlsProperties-shaderSignedZeroInfNanPreserveFloat64", offsetof( struct VkPhysicalDeviceFloatControlsProperties, shaderSignedZeroInfNanPreserveFloat64 ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFloatControlsProperties-shaderRoundingModeRTEFloat64", offsetof( struct VkPhysicalDeviceFloatControlsProperties, shaderRoundingModeRTEFloat64 ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFloatControlsProperties-shaderRoundingModeRTZFloat64", offsetof( struct VkPhysicalDeviceFloatControlsProperties, shaderRoundingModeRTZFloat64 ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFloatControlsProperties-pNext", offsetof( struct VkPhysicalDeviceFloatControlsProperties, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceFloatControlsProperties-shaderDenormFlushToZeroFloat32", offsetof( struct VkPhysicalDeviceFloatControlsProperties, shaderDenormFlushToZeroFloat32 ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFloatControlsProperties-shaderDenormPreserveFloat32", offsetof( struct VkPhysicalDeviceFloatControlsProperties, shaderDenormPreserveFloat32 ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFloatControlsProperties-shaderSignedZeroInfNanPreserveFloat32", offsetof( struct VkPhysicalDeviceFloatControlsProperties, shaderSignedZeroInfNanPreserveFloat32 ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFloatControlsProperties-shaderRoundingModeRTEFloat32", offsetof( struct VkPhysicalDeviceFloatControlsProperties, shaderRoundingModeRTEFloat32 ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFloatControlsProperties-shaderRoundingModeRTZFloat32", offsetof( struct VkPhysicalDeviceFloatControlsProperties, shaderRoundingModeRTZFloat32 ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFloatControlsProperties-roundingModeIndependence", offsetof( struct VkPhysicalDeviceFloatControlsProperties, roundingModeIndependence ), sizeof( VkShaderFloatControlsIndependence ) );
	swigStructField( "VkPhysicalDeviceFloatControlsProperties-denormBehaviorIndependence", offsetof( struct VkPhysicalDeviceFloatControlsProperties, denormBehaviorIndependence ), sizeof( VkShaderFloatControlsIndependence ) );
	swigStructField( "VkPhysicalDeviceFloatControlsProperties-shaderRoundingModeRTEFloat16", offsetof( struct VkPhysicalDeviceFloatControlsProperties, shaderRoundingModeRTEFloat16 ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFloatControlsProperties-shaderDenormFlushToZeroFloat16", offsetof( struct VkPhysicalDeviceFloatControlsProperties, shaderDenormFlushToZeroFloat16 ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFloatControlsProperties-shaderDenormPreserveFloat16", offsetof( struct VkPhysicalDeviceFloatControlsProperties, shaderDenormPreserveFloat16 ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFloatControlsProperties-shaderSignedZeroInfNanPreserveFloat16", offsetof( struct VkPhysicalDeviceFloatControlsProperties, shaderSignedZeroInfNanPreserveFloat16 ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFloatControlsProperties-shaderRoundingModeRTZFloat16", offsetof( struct VkPhysicalDeviceFloatControlsProperties, shaderRoundingModeRTZFloat16 ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFloatControlsProperties-sType", offsetof( struct VkPhysicalDeviceFloatControlsProperties, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceFloatControlsProperties ) );

	swigComment("struct VkDescriptorSetLayoutBindingFlagsCreateInfo\n");
	printf( "begin-structure VkDescriptorSetLayoutBindingFlagsCreateInfo\n" );
	swigStructField( "VkDescriptorSetLayoutBindingFlagsCreateInfo-pNext", offsetof( struct VkDescriptorSetLayoutBindingFlagsCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkDescriptorSetLayoutBindingFlagsCreateInfo-bindingCount", offsetof( struct VkDescriptorSetLayoutBindingFlagsCreateInfo, bindingCount ), sizeof( uint32_t ) );
	swigStructField( "VkDescriptorSetLayoutBindingFlagsCreateInfo-pBindingFlags", offsetof( struct VkDescriptorSetLayoutBindingFlagsCreateInfo, pBindingFlags ), sizeof( VkDescriptorBindingFlags const * ) );
	swigStructField( "VkDescriptorSetLayoutBindingFlagsCreateInfo-sType", offsetof( struct VkDescriptorSetLayoutBindingFlagsCreateInfo, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDescriptorSetLayoutBindingFlagsCreateInfo ) );

	swigComment("struct VkPhysicalDeviceDescriptorIndexingFeatures\n");
	printf( "begin-structure VkPhysicalDeviceDescriptorIndexingFeatures\n" );
	swigStructField( "VkPhysicalDeviceDescriptorIndexingFeatures-descriptorBindingPartiallyBound", offsetof( struct VkPhysicalDeviceDescriptorIndexingFeatures, descriptorBindingPartiallyBound ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceDescriptorIndexingFeatures-pNext", offsetof( struct VkPhysicalDeviceDescriptorIndexingFeatures, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceDescriptorIndexingFeatures-runtimeDescriptorArray", offsetof( struct VkPhysicalDeviceDescriptorIndexingFeatures, runtimeDescriptorArray ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceDescriptorIndexingFeatures-descriptorBindingSampledImageUpdateAfterBind", offsetof( struct VkPhysicalDeviceDescriptorIndexingFeatures, descriptorBindingSampledImageUpdateAfterBind ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceDescriptorIndexingFeatures-descriptorBindingUniformBufferUpdateAfterBind", offsetof( struct VkPhysicalDeviceDescriptorIndexingFeatures, descriptorBindingUniformBufferUpdateAfterBind ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceDescriptorIndexingFeatures-descriptorBindingStorageImageUpdateAfterBind", offsetof( struct VkPhysicalDeviceDescriptorIndexingFeatures, descriptorBindingStorageImageUpdateAfterBind ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceDescriptorIndexingFeatures-descriptorBindingStorageBufferUpdateAfterBind", offsetof( struct VkPhysicalDeviceDescriptorIndexingFeatures, descriptorBindingStorageBufferUpdateAfterBind ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceDescriptorIndexingFeatures-descriptorBindingUniformTexelBufferUpdateAfterBind", offsetof( struct VkPhysicalDeviceDescriptorIndexingFeatures, descriptorBindingUniformTexelBufferUpdateAfterBind ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceDescriptorIndexingFeatures-descriptorBindingStorageTexelBufferUpdateAfterBind", offsetof( struct VkPhysicalDeviceDescriptorIndexingFeatures, descriptorBindingStorageTexelBufferUpdateAfterBind ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceDescriptorIndexingFeatures-descriptorBindingVariableDescriptorCount", offsetof( struct VkPhysicalDeviceDescriptorIndexingFeatures, descriptorBindingVariableDescriptorCount ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceDescriptorIndexingFeatures-shaderStorageTexelBufferArrayNonUniformIndexing", offsetof( struct VkPhysicalDeviceDescriptorIndexingFeatures, shaderStorageTexelBufferArrayNonUniformIndexing ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceDescriptorIndexingFeatures-shaderUniformTexelBufferArrayNonUniformIndexing", offsetof( struct VkPhysicalDeviceDescriptorIndexingFeatures, shaderUniformTexelBufferArrayNonUniformIndexing ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceDescriptorIndexingFeatures-shaderInputAttachmentArrayNonUniformIndexing", offsetof( struct VkPhysicalDeviceDescriptorIndexingFeatures, shaderInputAttachmentArrayNonUniformIndexing ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceDescriptorIndexingFeatures-shaderStorageImageArrayNonUniformIndexing", offsetof( struct VkPhysicalDeviceDescriptorIndexingFeatures, shaderStorageImageArrayNonUniformIndexing ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceDescriptorIndexingFeatures-shaderStorageBufferArrayNonUniformIndexing", offsetof( struct VkPhysicalDeviceDescriptorIndexingFeatures, shaderStorageBufferArrayNonUniformIndexing ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceDescriptorIndexingFeatures-shaderSampledImageArrayNonUniformIndexing", offsetof( struct VkPhysicalDeviceDescriptorIndexingFeatures, shaderSampledImageArrayNonUniformIndexing ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceDescriptorIndexingFeatures-shaderUniformBufferArrayNonUniformIndexing", offsetof( struct VkPhysicalDeviceDescriptorIndexingFeatures, shaderUniformBufferArrayNonUniformIndexing ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceDescriptorIndexingFeatures-shaderStorageTexelBufferArrayDynamicIndexing", offsetof( struct VkPhysicalDeviceDescriptorIndexingFeatures, shaderStorageTexelBufferArrayDynamicIndexing ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceDescriptorIndexingFeatures-shaderUniformTexelBufferArrayDynamicIndexing", offsetof( struct VkPhysicalDeviceDescriptorIndexingFeatures, shaderUniformTexelBufferArrayDynamicIndexing ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceDescriptorIndexingFeatures-shaderInputAttachmentArrayDynamicIndexing", offsetof( struct VkPhysicalDeviceDescriptorIndexingFeatures, shaderInputAttachmentArrayDynamicIndexing ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceDescriptorIndexingFeatures-descriptorBindingUpdateUnusedWhilePending", offsetof( struct VkPhysicalDeviceDescriptorIndexingFeatures, descriptorBindingUpdateUnusedWhilePending ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceDescriptorIndexingFeatures-sType", offsetof( struct VkPhysicalDeviceDescriptorIndexingFeatures, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceDescriptorIndexingFeatures ) );

	swigComment("struct VkPhysicalDeviceDescriptorIndexingProperties\n");
	printf( "begin-structure VkPhysicalDeviceDescriptorIndexingProperties\n" );
	swigStructField( "VkPhysicalDeviceDescriptorIndexingProperties-maxDescriptorSetUpdateAfterBindInputAttachments", offsetof( struct VkPhysicalDeviceDescriptorIndexingProperties, maxDescriptorSetUpdateAfterBindInputAttachments ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceDescriptorIndexingProperties-maxPerStageDescriptorUpdateAfterBindSampledImages", offsetof( struct VkPhysicalDeviceDescriptorIndexingProperties, maxPerStageDescriptorUpdateAfterBindSampledImages ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceDescriptorIndexingProperties-maxDescriptorSetUpdateAfterBindSampledImages", offsetof( struct VkPhysicalDeviceDescriptorIndexingProperties, maxDescriptorSetUpdateAfterBindSampledImages ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceDescriptorIndexingProperties-pNext", offsetof( struct VkPhysicalDeviceDescriptorIndexingProperties, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceDescriptorIndexingProperties-maxPerStageDescriptorUpdateAfterBindSamplers", offsetof( struct VkPhysicalDeviceDescriptorIndexingProperties, maxPerStageDescriptorUpdateAfterBindSamplers ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceDescriptorIndexingProperties-robustBufferAccessUpdateAfterBind", offsetof( struct VkPhysicalDeviceDescriptorIndexingProperties, robustBufferAccessUpdateAfterBind ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceDescriptorIndexingProperties-maxDescriptorSetUpdateAfterBindSamplers", offsetof( struct VkPhysicalDeviceDescriptorIndexingProperties, maxDescriptorSetUpdateAfterBindSamplers ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceDescriptorIndexingProperties-quadDivergentImplicitLod", offsetof( struct VkPhysicalDeviceDescriptorIndexingProperties, quadDivergentImplicitLod ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceDescriptorIndexingProperties-maxPerStageDescriptorUpdateAfterBindStorageBuffers", offsetof( struct VkPhysicalDeviceDescriptorIndexingProperties, maxPerStageDescriptorUpdateAfterBindStorageBuffers ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceDescriptorIndexingProperties-maxPerStageDescriptorUpdateAfterBindUniformBuffers", offsetof( struct VkPhysicalDeviceDescriptorIndexingProperties, maxPerStageDescriptorUpdateAfterBindUniformBuffers ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceDescriptorIndexingProperties-maxPerStageDescriptorUpdateAfterBindInputAttachments", offsetof( struct VkPhysicalDeviceDescriptorIndexingProperties, maxPerStageDescriptorUpdateAfterBindInputAttachments ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceDescriptorIndexingProperties-maxDescriptorSetUpdateAfterBindUniformBuffers", offsetof( struct VkPhysicalDeviceDescriptorIndexingProperties, maxDescriptorSetUpdateAfterBindUniformBuffers ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceDescriptorIndexingProperties-maxDescriptorSetUpdateAfterBindStorageBuffers", offsetof( struct VkPhysicalDeviceDescriptorIndexingProperties, maxDescriptorSetUpdateAfterBindStorageBuffers ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceDescriptorIndexingProperties-maxUpdateAfterBindDescriptorsInAllPools", offsetof( struct VkPhysicalDeviceDescriptorIndexingProperties, maxUpdateAfterBindDescriptorsInAllPools ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceDescriptorIndexingProperties-maxPerStageUpdateAfterBindResources", offsetof( struct VkPhysicalDeviceDescriptorIndexingProperties, maxPerStageUpdateAfterBindResources ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceDescriptorIndexingProperties-shaderInputAttachmentArrayNonUniformIndexingNative", offsetof( struct VkPhysicalDeviceDescriptorIndexingProperties, shaderInputAttachmentArrayNonUniformIndexingNative ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceDescriptorIndexingProperties-shaderStorageImageArrayNonUniformIndexingNative", offsetof( struct VkPhysicalDeviceDescriptorIndexingProperties, shaderStorageImageArrayNonUniformIndexingNative ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceDescriptorIndexingProperties-shaderStorageBufferArrayNonUniformIndexingNative", offsetof( struct VkPhysicalDeviceDescriptorIndexingProperties, shaderStorageBufferArrayNonUniformIndexingNative ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceDescriptorIndexingProperties-shaderSampledImageArrayNonUniformIndexingNative", offsetof( struct VkPhysicalDeviceDescriptorIndexingProperties, shaderSampledImageArrayNonUniformIndexingNative ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceDescriptorIndexingProperties-shaderUniformBufferArrayNonUniformIndexingNative", offsetof( struct VkPhysicalDeviceDescriptorIndexingProperties, shaderUniformBufferArrayNonUniformIndexingNative ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceDescriptorIndexingProperties-maxPerStageDescriptorUpdateAfterBindStorageImages", offsetof( struct VkPhysicalDeviceDescriptorIndexingProperties, maxPerStageDescriptorUpdateAfterBindStorageImages ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceDescriptorIndexingProperties-maxDescriptorSetUpdateAfterBindStorageImages", offsetof( struct VkPhysicalDeviceDescriptorIndexingProperties, maxDescriptorSetUpdateAfterBindStorageImages ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceDescriptorIndexingProperties-sType", offsetof( struct VkPhysicalDeviceDescriptorIndexingProperties, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDeviceDescriptorIndexingProperties-maxDescriptorSetUpdateAfterBindUniformBuffersDynamic", offsetof( struct VkPhysicalDeviceDescriptorIndexingProperties, maxDescriptorSetUpdateAfterBindUniformBuffersDynamic ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceDescriptorIndexingProperties-maxDescriptorSetUpdateAfterBindStorageBuffersDynamic", offsetof( struct VkPhysicalDeviceDescriptorIndexingProperties, maxDescriptorSetUpdateAfterBindStorageBuffersDynamic ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceDescriptorIndexingProperties ) );

	swigComment("struct VkDescriptorSetVariableDescriptorCountAllocateInfo\n");
	printf( "begin-structure VkDescriptorSetVariableDescriptorCountAllocateInfo\n" );
	swigStructField( "VkDescriptorSetVariableDescriptorCountAllocateInfo-pNext", offsetof( struct VkDescriptorSetVariableDescriptorCountAllocateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkDescriptorSetVariableDescriptorCountAllocateInfo-pDescriptorCounts", offsetof( struct VkDescriptorSetVariableDescriptorCountAllocateInfo, pDescriptorCounts ), sizeof( uint32_t const * ) );
	swigStructField( "VkDescriptorSetVariableDescriptorCountAllocateInfo-sType", offsetof( struct VkDescriptorSetVariableDescriptorCountAllocateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkDescriptorSetVariableDescriptorCountAllocateInfo-descriptorSetCount", offsetof( struct VkDescriptorSetVariableDescriptorCountAllocateInfo, descriptorSetCount ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDescriptorSetVariableDescriptorCountAllocateInfo ) );

	swigComment("struct VkDescriptorSetVariableDescriptorCountLayoutSupport\n");
	printf( "begin-structure VkDescriptorSetVariableDescriptorCountLayoutSupport\n" );
	swigStructField( "VkDescriptorSetVariableDescriptorCountLayoutSupport-pNext", offsetof( struct VkDescriptorSetVariableDescriptorCountLayoutSupport, pNext ), sizeof( void * ) );
	swigStructField( "VkDescriptorSetVariableDescriptorCountLayoutSupport-maxVariableDescriptorCount", offsetof( struct VkDescriptorSetVariableDescriptorCountLayoutSupport, maxVariableDescriptorCount ), sizeof( uint32_t ) );
	swigStructField( "VkDescriptorSetVariableDescriptorCountLayoutSupport-sType", offsetof( struct VkDescriptorSetVariableDescriptorCountLayoutSupport, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDescriptorSetVariableDescriptorCountLayoutSupport ) );

	swigComment("struct VkSubpassDescriptionDepthStencilResolve\n");
	printf( "begin-structure VkSubpassDescriptionDepthStencilResolve\n" );
	swigStructField( "VkSubpassDescriptionDepthStencilResolve-pNext", offsetof( struct VkSubpassDescriptionDepthStencilResolve, pNext ), sizeof( void const * ) );
	swigStructField( "VkSubpassDescriptionDepthStencilResolve-pDepthStencilResolveAttachment", offsetof( struct VkSubpassDescriptionDepthStencilResolve, pDepthStencilResolveAttachment ), sizeof( VkAttachmentReference2 const * ) );
	swigStructField( "VkSubpassDescriptionDepthStencilResolve-depthResolveMode", offsetof( struct VkSubpassDescriptionDepthStencilResolve, depthResolveMode ), sizeof( VkResolveModeFlagBits ) );
	swigStructField( "VkSubpassDescriptionDepthStencilResolve-stencilResolveMode", offsetof( struct VkSubpassDescriptionDepthStencilResolve, stencilResolveMode ), sizeof( VkResolveModeFlagBits ) );
	swigStructField( "VkSubpassDescriptionDepthStencilResolve-sType", offsetof( struct VkSubpassDescriptionDepthStencilResolve, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSubpassDescriptionDepthStencilResolve ) );

	swigComment("struct VkPhysicalDeviceDepthStencilResolveProperties\n");
	printf( "begin-structure VkPhysicalDeviceDepthStencilResolveProperties\n" );
	swigStructField( "VkPhysicalDeviceDepthStencilResolveProperties-pNext", offsetof( struct VkPhysicalDeviceDepthStencilResolveProperties, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceDepthStencilResolveProperties-supportedDepthResolveModes", offsetof( struct VkPhysicalDeviceDepthStencilResolveProperties, supportedDepthResolveModes ), sizeof( VkResolveModeFlags ) );
	swigStructField( "VkPhysicalDeviceDepthStencilResolveProperties-supportedStencilResolveModes", offsetof( struct VkPhysicalDeviceDepthStencilResolveProperties, supportedStencilResolveModes ), sizeof( VkResolveModeFlags ) );
	swigStructField( "VkPhysicalDeviceDepthStencilResolveProperties-independentResolveNone", offsetof( struct VkPhysicalDeviceDepthStencilResolveProperties, independentResolveNone ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceDepthStencilResolveProperties-sType", offsetof( struct VkPhysicalDeviceDepthStencilResolveProperties, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDeviceDepthStencilResolveProperties-independentResolve", offsetof( struct VkPhysicalDeviceDepthStencilResolveProperties, independentResolve ), sizeof( VkBool32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceDepthStencilResolveProperties ) );

	swigComment("struct VkPhysicalDeviceScalarBlockLayoutFeatures\n");
	printf( "begin-structure VkPhysicalDeviceScalarBlockLayoutFeatures\n" );
	swigStructField( "VkPhysicalDeviceScalarBlockLayoutFeatures-pNext", offsetof( struct VkPhysicalDeviceScalarBlockLayoutFeatures, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceScalarBlockLayoutFeatures-scalarBlockLayout", offsetof( struct VkPhysicalDeviceScalarBlockLayoutFeatures, scalarBlockLayout ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceScalarBlockLayoutFeatures-sType", offsetof( struct VkPhysicalDeviceScalarBlockLayoutFeatures, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceScalarBlockLayoutFeatures ) );

	swigComment("struct VkImageStencilUsageCreateInfo\n");
	printf( "begin-structure VkImageStencilUsageCreateInfo\n" );
	swigStructField( "VkImageStencilUsageCreateInfo-pNext", offsetof( struct VkImageStencilUsageCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkImageStencilUsageCreateInfo-stencilUsage", offsetof( struct VkImageStencilUsageCreateInfo, stencilUsage ), sizeof( VkImageUsageFlags ) );
	swigStructField( "VkImageStencilUsageCreateInfo-sType", offsetof( struct VkImageStencilUsageCreateInfo, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkImageStencilUsageCreateInfo ) );

	swigComment("struct VkSamplerReductionModeCreateInfo\n");
	printf( "begin-structure VkSamplerReductionModeCreateInfo\n" );
	swigStructField( "VkSamplerReductionModeCreateInfo-pNext", offsetof( struct VkSamplerReductionModeCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkSamplerReductionModeCreateInfo-reductionMode", offsetof( struct VkSamplerReductionModeCreateInfo, reductionMode ), sizeof( VkSamplerReductionMode ) );
	swigStructField( "VkSamplerReductionModeCreateInfo-sType", offsetof( struct VkSamplerReductionModeCreateInfo, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSamplerReductionModeCreateInfo ) );

	swigComment("struct VkPhysicalDeviceSamplerFilterMinmaxProperties\n");
	printf( "begin-structure VkPhysicalDeviceSamplerFilterMinmaxProperties\n" );
	swigStructField( "VkPhysicalDeviceSamplerFilterMinmaxProperties-pNext", offsetof( struct VkPhysicalDeviceSamplerFilterMinmaxProperties, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceSamplerFilterMinmaxProperties-filterMinmaxSingleComponentFormats", offsetof( struct VkPhysicalDeviceSamplerFilterMinmaxProperties, filterMinmaxSingleComponentFormats ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceSamplerFilterMinmaxProperties-sType", offsetof( struct VkPhysicalDeviceSamplerFilterMinmaxProperties, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDeviceSamplerFilterMinmaxProperties-filterMinmaxImageComponentMapping", offsetof( struct VkPhysicalDeviceSamplerFilterMinmaxProperties, filterMinmaxImageComponentMapping ), sizeof( VkBool32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceSamplerFilterMinmaxProperties ) );

	swigComment("struct VkPhysicalDeviceVulkanMemoryModelFeatures\n");
	printf( "begin-structure VkPhysicalDeviceVulkanMemoryModelFeatures\n" );
	swigStructField( "VkPhysicalDeviceVulkanMemoryModelFeatures-pNext", offsetof( struct VkPhysicalDeviceVulkanMemoryModelFeatures, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceVulkanMemoryModelFeatures-vulkanMemoryModelDeviceScope", offsetof( struct VkPhysicalDeviceVulkanMemoryModelFeatures, vulkanMemoryModelDeviceScope ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkanMemoryModelFeatures-vulkanMemoryModelAvailabilityVisibilityChains", offsetof( struct VkPhysicalDeviceVulkanMemoryModelFeatures, vulkanMemoryModelAvailabilityVisibilityChains ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVulkanMemoryModelFeatures-sType", offsetof( struct VkPhysicalDeviceVulkanMemoryModelFeatures, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDeviceVulkanMemoryModelFeatures-vulkanMemoryModel", offsetof( struct VkPhysicalDeviceVulkanMemoryModelFeatures, vulkanMemoryModel ), sizeof( VkBool32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceVulkanMemoryModelFeatures ) );

	swigComment("struct VkPhysicalDeviceImagelessFramebufferFeatures\n");
	printf( "begin-structure VkPhysicalDeviceImagelessFramebufferFeatures\n" );
	swigStructField( "VkPhysicalDeviceImagelessFramebufferFeatures-pNext", offsetof( struct VkPhysicalDeviceImagelessFramebufferFeatures, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceImagelessFramebufferFeatures-imagelessFramebuffer", offsetof( struct VkPhysicalDeviceImagelessFramebufferFeatures, imagelessFramebuffer ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceImagelessFramebufferFeatures-sType", offsetof( struct VkPhysicalDeviceImagelessFramebufferFeatures, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceImagelessFramebufferFeatures ) );

	swigComment("struct VkFramebufferAttachmentImageInfo\n");
	printf( "begin-structure VkFramebufferAttachmentImageInfo\n" );
	swigStructField( "VkFramebufferAttachmentImageInfo-pNext", offsetof( struct VkFramebufferAttachmentImageInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkFramebufferAttachmentImageInfo-layerCount", offsetof( struct VkFramebufferAttachmentImageInfo, layerCount ), sizeof( uint32_t ) );
	swigStructField( "VkFramebufferAttachmentImageInfo-usage", offsetof( struct VkFramebufferAttachmentImageInfo, usage ), sizeof( VkImageUsageFlags ) );
	swigStructField( "VkFramebufferAttachmentImageInfo-height", offsetof( struct VkFramebufferAttachmentImageInfo, height ), sizeof( uint32_t ) );
	swigStructField( "VkFramebufferAttachmentImageInfo-pViewFormats", offsetof( struct VkFramebufferAttachmentImageInfo, pViewFormats ), sizeof( VkFormat const * ) );
	swigStructField( "VkFramebufferAttachmentImageInfo-sType", offsetof( struct VkFramebufferAttachmentImageInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkFramebufferAttachmentImageInfo-flags", offsetof( struct VkFramebufferAttachmentImageInfo, flags ), sizeof( VkImageCreateFlags ) );
	swigStructField( "VkFramebufferAttachmentImageInfo-width", offsetof( struct VkFramebufferAttachmentImageInfo, width ), sizeof( uint32_t ) );
	swigStructField( "VkFramebufferAttachmentImageInfo-viewFormatCount", offsetof( struct VkFramebufferAttachmentImageInfo, viewFormatCount ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkFramebufferAttachmentImageInfo ) );

	swigComment("struct VkFramebufferAttachmentsCreateInfo\n");
	printf( "begin-structure VkFramebufferAttachmentsCreateInfo\n" );
	swigStructField( "VkFramebufferAttachmentsCreateInfo-pNext", offsetof( struct VkFramebufferAttachmentsCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkFramebufferAttachmentsCreateInfo-attachmentImageInfoCount", offsetof( struct VkFramebufferAttachmentsCreateInfo, attachmentImageInfoCount ), sizeof( uint32_t ) );
	swigStructField( "VkFramebufferAttachmentsCreateInfo-sType", offsetof( struct VkFramebufferAttachmentsCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkFramebufferAttachmentsCreateInfo-pAttachmentImageInfos", offsetof( struct VkFramebufferAttachmentsCreateInfo, pAttachmentImageInfos ), sizeof( VkFramebufferAttachmentImageInfo const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkFramebufferAttachmentsCreateInfo ) );

	swigComment("struct VkRenderPassAttachmentBeginInfo\n");
	printf( "begin-structure VkRenderPassAttachmentBeginInfo\n" );
	swigStructField( "VkRenderPassAttachmentBeginInfo-pNext", offsetof( struct VkRenderPassAttachmentBeginInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkRenderPassAttachmentBeginInfo-pAttachments", offsetof( struct VkRenderPassAttachmentBeginInfo, pAttachments ), sizeof( VkImageView const * ) );
	swigStructField( "VkRenderPassAttachmentBeginInfo-sType", offsetof( struct VkRenderPassAttachmentBeginInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkRenderPassAttachmentBeginInfo-attachmentCount", offsetof( struct VkRenderPassAttachmentBeginInfo, attachmentCount ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkRenderPassAttachmentBeginInfo ) );

	swigComment("struct VkPhysicalDeviceUniformBufferStandardLayoutFeatures\n");
	printf( "begin-structure VkPhysicalDeviceUniformBufferStandardLayoutFeatures\n" );
	swigStructField( "VkPhysicalDeviceUniformBufferStandardLayoutFeatures-pNext", offsetof( struct VkPhysicalDeviceUniformBufferStandardLayoutFeatures, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceUniformBufferStandardLayoutFeatures-uniformBufferStandardLayout", offsetof( struct VkPhysicalDeviceUniformBufferStandardLayoutFeatures, uniformBufferStandardLayout ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceUniformBufferStandardLayoutFeatures-sType", offsetof( struct VkPhysicalDeviceUniformBufferStandardLayoutFeatures, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceUniformBufferStandardLayoutFeatures ) );

	swigComment("struct VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures\n");
	printf( "begin-structure VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures\n" );
	swigStructField( "VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures-pNext", offsetof( struct VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures-shaderSubgroupExtendedTypes", offsetof( struct VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures, shaderSubgroupExtendedTypes ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures-sType", offsetof( struct VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures ) );

	swigComment("struct VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures\n");
	printf( "begin-structure VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures\n" );
	swigStructField( "VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures-pNext", offsetof( struct VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures-separateDepthStencilLayouts", offsetof( struct VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures, separateDepthStencilLayouts ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures-sType", offsetof( struct VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures ) );

	swigComment("struct VkAttachmentReferenceStencilLayout\n");
	printf( "begin-structure VkAttachmentReferenceStencilLayout\n" );
	swigStructField( "VkAttachmentReferenceStencilLayout-pNext", offsetof( struct VkAttachmentReferenceStencilLayout, pNext ), sizeof( void * ) );
	swigStructField( "VkAttachmentReferenceStencilLayout-stencilLayout", offsetof( struct VkAttachmentReferenceStencilLayout, stencilLayout ), sizeof( VkImageLayout ) );
	swigStructField( "VkAttachmentReferenceStencilLayout-sType", offsetof( struct VkAttachmentReferenceStencilLayout, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkAttachmentReferenceStencilLayout ) );

	swigComment("struct VkAttachmentDescriptionStencilLayout\n");
	printf( "begin-structure VkAttachmentDescriptionStencilLayout\n" );
	swigStructField( "VkAttachmentDescriptionStencilLayout-pNext", offsetof( struct VkAttachmentDescriptionStencilLayout, pNext ), sizeof( void * ) );
	swigStructField( "VkAttachmentDescriptionStencilLayout-stencilInitialLayout", offsetof( struct VkAttachmentDescriptionStencilLayout, stencilInitialLayout ), sizeof( VkImageLayout ) );
	swigStructField( "VkAttachmentDescriptionStencilLayout-stencilFinalLayout", offsetof( struct VkAttachmentDescriptionStencilLayout, stencilFinalLayout ), sizeof( VkImageLayout ) );
	swigStructField( "VkAttachmentDescriptionStencilLayout-sType", offsetof( struct VkAttachmentDescriptionStencilLayout, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkAttachmentDescriptionStencilLayout ) );

	swigComment("struct VkPhysicalDeviceHostQueryResetFeatures\n");
	printf( "begin-structure VkPhysicalDeviceHostQueryResetFeatures\n" );
	swigStructField( "VkPhysicalDeviceHostQueryResetFeatures-pNext", offsetof( struct VkPhysicalDeviceHostQueryResetFeatures, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceHostQueryResetFeatures-sType", offsetof( struct VkPhysicalDeviceHostQueryResetFeatures, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDeviceHostQueryResetFeatures-hostQueryReset", offsetof( struct VkPhysicalDeviceHostQueryResetFeatures, hostQueryReset ), sizeof( VkBool32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceHostQueryResetFeatures ) );

	swigComment("struct VkPhysicalDeviceTimelineSemaphoreFeatures\n");
	printf( "begin-structure VkPhysicalDeviceTimelineSemaphoreFeatures\n" );
	swigStructField( "VkPhysicalDeviceTimelineSemaphoreFeatures-pNext", offsetof( struct VkPhysicalDeviceTimelineSemaphoreFeatures, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceTimelineSemaphoreFeatures-timelineSemaphore", offsetof( struct VkPhysicalDeviceTimelineSemaphoreFeatures, timelineSemaphore ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceTimelineSemaphoreFeatures-sType", offsetof( struct VkPhysicalDeviceTimelineSemaphoreFeatures, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceTimelineSemaphoreFeatures ) );

	swigComment("struct VkPhysicalDeviceTimelineSemaphoreProperties\n");
	printf( "begin-structure VkPhysicalDeviceTimelineSemaphoreProperties\n" );
	swigStructField( "VkPhysicalDeviceTimelineSemaphoreProperties-pNext", offsetof( struct VkPhysicalDeviceTimelineSemaphoreProperties, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceTimelineSemaphoreProperties-maxTimelineSemaphoreValueDifference", offsetof( struct VkPhysicalDeviceTimelineSemaphoreProperties, maxTimelineSemaphoreValueDifference ), sizeof( uint64_t ) );
	swigStructField( "VkPhysicalDeviceTimelineSemaphoreProperties-sType", offsetof( struct VkPhysicalDeviceTimelineSemaphoreProperties, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceTimelineSemaphoreProperties ) );

	swigComment("struct VkSemaphoreTypeCreateInfo\n");
	printf( "begin-structure VkSemaphoreTypeCreateInfo\n" );
	swigStructField( "VkSemaphoreTypeCreateInfo-pNext", offsetof( struct VkSemaphoreTypeCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkSemaphoreTypeCreateInfo-initialValue", offsetof( struct VkSemaphoreTypeCreateInfo, initialValue ), sizeof( uint64_t ) );
	swigStructField( "VkSemaphoreTypeCreateInfo-sType", offsetof( struct VkSemaphoreTypeCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkSemaphoreTypeCreateInfo-semaphoreType", offsetof( struct VkSemaphoreTypeCreateInfo, semaphoreType ), sizeof( VkSemaphoreType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSemaphoreTypeCreateInfo ) );

	swigComment("struct VkTimelineSemaphoreSubmitInfo\n");
	printf( "begin-structure VkTimelineSemaphoreSubmitInfo\n" );
	swigStructField( "VkTimelineSemaphoreSubmitInfo-pNext", offsetof( struct VkTimelineSemaphoreSubmitInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkTimelineSemaphoreSubmitInfo-waitSemaphoreValueCount", offsetof( struct VkTimelineSemaphoreSubmitInfo, waitSemaphoreValueCount ), sizeof( uint32_t ) );
	swigStructField( "VkTimelineSemaphoreSubmitInfo-signalSemaphoreValueCount", offsetof( struct VkTimelineSemaphoreSubmitInfo, signalSemaphoreValueCount ), sizeof( uint32_t ) );
	swigStructField( "VkTimelineSemaphoreSubmitInfo-sType", offsetof( struct VkTimelineSemaphoreSubmitInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkTimelineSemaphoreSubmitInfo-pWaitSemaphoreValues", offsetof( struct VkTimelineSemaphoreSubmitInfo, pWaitSemaphoreValues ), sizeof( uint64_t const * ) );
	swigStructField( "VkTimelineSemaphoreSubmitInfo-pSignalSemaphoreValues", offsetof( struct VkTimelineSemaphoreSubmitInfo, pSignalSemaphoreValues ), sizeof( uint64_t const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkTimelineSemaphoreSubmitInfo ) );

	swigComment("struct VkSemaphoreWaitInfo\n");
	printf( "begin-structure VkSemaphoreWaitInfo\n" );
	swigStructField( "VkSemaphoreWaitInfo-pNext", offsetof( struct VkSemaphoreWaitInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkSemaphoreWaitInfo-semaphoreCount", offsetof( struct VkSemaphoreWaitInfo, semaphoreCount ), sizeof( uint32_t ) );
	swigStructField( "VkSemaphoreWaitInfo-pSemaphores", offsetof( struct VkSemaphoreWaitInfo, pSemaphores ), sizeof( VkSemaphore const * ) );
	swigStructField( "VkSemaphoreWaitInfo-sType", offsetof( struct VkSemaphoreWaitInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkSemaphoreWaitInfo-flags", offsetof( struct VkSemaphoreWaitInfo, flags ), sizeof( VkSemaphoreWaitFlags ) );
	swigStructField( "VkSemaphoreWaitInfo-pValues", offsetof( struct VkSemaphoreWaitInfo, pValues ), sizeof( uint64_t const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSemaphoreWaitInfo ) );

	swigComment("struct VkSemaphoreSignalInfo\n");
	printf( "begin-structure VkSemaphoreSignalInfo\n" );
	swigStructField( "VkSemaphoreSignalInfo-pNext", offsetof( struct VkSemaphoreSignalInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkSemaphoreSignalInfo-semaphore", offsetof( struct VkSemaphoreSignalInfo, semaphore ), sizeof( VkSemaphore ) );
	swigStructField( "VkSemaphoreSignalInfo-value", offsetof( struct VkSemaphoreSignalInfo, value ), sizeof( uint64_t ) );
	swigStructField( "VkSemaphoreSignalInfo-sType", offsetof( struct VkSemaphoreSignalInfo, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSemaphoreSignalInfo ) );

	swigComment("struct VkPhysicalDeviceBufferDeviceAddressFeatures\n");
	printf( "begin-structure VkPhysicalDeviceBufferDeviceAddressFeatures\n" );
	swigStructField( "VkPhysicalDeviceBufferDeviceAddressFeatures-pNext", offsetof( struct VkPhysicalDeviceBufferDeviceAddressFeatures, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceBufferDeviceAddressFeatures-bufferDeviceAddress", offsetof( struct VkPhysicalDeviceBufferDeviceAddressFeatures, bufferDeviceAddress ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceBufferDeviceAddressFeatures-bufferDeviceAddressCaptureReplay", offsetof( struct VkPhysicalDeviceBufferDeviceAddressFeatures, bufferDeviceAddressCaptureReplay ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceBufferDeviceAddressFeatures-sType", offsetof( struct VkPhysicalDeviceBufferDeviceAddressFeatures, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDeviceBufferDeviceAddressFeatures-bufferDeviceAddressMultiDevice", offsetof( struct VkPhysicalDeviceBufferDeviceAddressFeatures, bufferDeviceAddressMultiDevice ), sizeof( VkBool32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceBufferDeviceAddressFeatures ) );

	swigComment("struct VkBufferDeviceAddressInfo\n");
	printf( "begin-structure VkBufferDeviceAddressInfo\n" );
	swigStructField( "VkBufferDeviceAddressInfo-pNext", offsetof( struct VkBufferDeviceAddressInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkBufferDeviceAddressInfo-buffer", offsetof( struct VkBufferDeviceAddressInfo, buffer ), sizeof( VkBuffer ) );
	swigStructField( "VkBufferDeviceAddressInfo-sType", offsetof( struct VkBufferDeviceAddressInfo, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkBufferDeviceAddressInfo ) );

	swigComment("struct VkBufferOpaqueCaptureAddressCreateInfo\n");
	printf( "begin-structure VkBufferOpaqueCaptureAddressCreateInfo\n" );
	swigStructField( "VkBufferOpaqueCaptureAddressCreateInfo-pNext", offsetof( struct VkBufferOpaqueCaptureAddressCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkBufferOpaqueCaptureAddressCreateInfo-opaqueCaptureAddress", offsetof( struct VkBufferOpaqueCaptureAddressCreateInfo, opaqueCaptureAddress ), sizeof( uint64_t ) );
	swigStructField( "VkBufferOpaqueCaptureAddressCreateInfo-sType", offsetof( struct VkBufferOpaqueCaptureAddressCreateInfo, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkBufferOpaqueCaptureAddressCreateInfo ) );

	swigComment("struct VkMemoryOpaqueCaptureAddressAllocateInfo\n");
	printf( "begin-structure VkMemoryOpaqueCaptureAddressAllocateInfo\n" );
	swigStructField( "VkMemoryOpaqueCaptureAddressAllocateInfo-pNext", offsetof( struct VkMemoryOpaqueCaptureAddressAllocateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkMemoryOpaqueCaptureAddressAllocateInfo-opaqueCaptureAddress", offsetof( struct VkMemoryOpaqueCaptureAddressAllocateInfo, opaqueCaptureAddress ), sizeof( uint64_t ) );
	swigStructField( "VkMemoryOpaqueCaptureAddressAllocateInfo-sType", offsetof( struct VkMemoryOpaqueCaptureAddressAllocateInfo, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkMemoryOpaqueCaptureAddressAllocateInfo ) );

	swigComment("struct VkDeviceMemoryOpaqueCaptureAddressInfo\n");
	printf( "begin-structure VkDeviceMemoryOpaqueCaptureAddressInfo\n" );
	swigStructField( "VkDeviceMemoryOpaqueCaptureAddressInfo-pNext", offsetof( struct VkDeviceMemoryOpaqueCaptureAddressInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkDeviceMemoryOpaqueCaptureAddressInfo-memory", offsetof( struct VkDeviceMemoryOpaqueCaptureAddressInfo, memory ), sizeof( VkDeviceMemory ) );
	swigStructField( "VkDeviceMemoryOpaqueCaptureAddressInfo-sType", offsetof( struct VkDeviceMemoryOpaqueCaptureAddressInfo, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDeviceMemoryOpaqueCaptureAddressInfo ) );

	swigComment("struct VkSurfaceCapabilitiesKHR\n");
	printf( "begin-structure VkSurfaceCapabilitiesKHR\n" );
	swigStructField( "VkSurfaceCapabilitiesKHR-minImageExtent", offsetof( struct VkSurfaceCapabilitiesKHR, minImageExtent ), sizeof( VkExtent2D ) );
	swigStructField( "VkSurfaceCapabilitiesKHR-maxImageExtent", offsetof( struct VkSurfaceCapabilitiesKHR, maxImageExtent ), sizeof( VkExtent2D ) );
	swigStructField( "VkSurfaceCapabilitiesKHR-supportedTransforms", offsetof( struct VkSurfaceCapabilitiesKHR, supportedTransforms ), sizeof( VkSurfaceTransformFlagsKHR ) );
	swigStructField( "VkSurfaceCapabilitiesKHR-minImageCount", offsetof( struct VkSurfaceCapabilitiesKHR, minImageCount ), sizeof( uint32_t ) );
	swigStructField( "VkSurfaceCapabilitiesKHR-maxImageCount", offsetof( struct VkSurfaceCapabilitiesKHR, maxImageCount ), sizeof( uint32_t ) );
	swigStructField( "VkSurfaceCapabilitiesKHR-supportedCompositeAlpha", offsetof( struct VkSurfaceCapabilitiesKHR, supportedCompositeAlpha ), sizeof( VkCompositeAlphaFlagsKHR ) );
	swigStructField( "VkSurfaceCapabilitiesKHR-maxImageArrayLayers", offsetof( struct VkSurfaceCapabilitiesKHR, maxImageArrayLayers ), sizeof( uint32_t ) );
	swigStructField( "VkSurfaceCapabilitiesKHR-currentTransform", offsetof( struct VkSurfaceCapabilitiesKHR, currentTransform ), sizeof( VkSurfaceTransformFlagBitsKHR ) );
	swigStructField( "VkSurfaceCapabilitiesKHR-currentExtent", offsetof( struct VkSurfaceCapabilitiesKHR, currentExtent ), sizeof( VkExtent2D ) );
	swigStructField( "VkSurfaceCapabilitiesKHR-supportedUsageFlags", offsetof( struct VkSurfaceCapabilitiesKHR, supportedUsageFlags ), sizeof( VkImageUsageFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSurfaceCapabilitiesKHR ) );

	swigComment("struct VkSurfaceFormatKHR\n");
	printf( "begin-structure VkSurfaceFormatKHR\n" );
	swigStructField( "VkSurfaceFormatKHR-colorSpace", offsetof( struct VkSurfaceFormatKHR, colorSpace ), sizeof( VkColorSpaceKHR ) );
	swigStructField( "VkSurfaceFormatKHR-format", offsetof( struct VkSurfaceFormatKHR, format ), sizeof( VkFormat ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSurfaceFormatKHR ) );

	swigComment("struct VkSwapchainCreateInfoKHR\n");
	printf( "begin-structure VkSwapchainCreateInfoKHR\n" );
	swigStructField( "VkSwapchainCreateInfoKHR-preTransform", offsetof( struct VkSwapchainCreateInfoKHR, preTransform ), sizeof( VkSurfaceTransformFlagBitsKHR ) );
	swigStructField( "VkSwapchainCreateInfoKHR-queueFamilyIndexCount", offsetof( struct VkSwapchainCreateInfoKHR, queueFamilyIndexCount ), sizeof( uint32_t ) );
	swigStructField( "VkSwapchainCreateInfoKHR-oldSwapchain", offsetof( struct VkSwapchainCreateInfoKHR, oldSwapchain ), sizeof( VkSwapchainKHR ) );
	swigStructField( "VkSwapchainCreateInfoKHR-imageUsage", offsetof( struct VkSwapchainCreateInfoKHR, imageUsage ), sizeof( VkImageUsageFlags ) );
	swigStructField( "VkSwapchainCreateInfoKHR-pNext", offsetof( struct VkSwapchainCreateInfoKHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkSwapchainCreateInfoKHR-imageFormat", offsetof( struct VkSwapchainCreateInfoKHR, imageFormat ), sizeof( VkFormat ) );
	swigStructField( "VkSwapchainCreateInfoKHR-imageExtent", offsetof( struct VkSwapchainCreateInfoKHR, imageExtent ), sizeof( VkExtent2D ) );
	swigStructField( "VkSwapchainCreateInfoKHR-pQueueFamilyIndices", offsetof( struct VkSwapchainCreateInfoKHR, pQueueFamilyIndices ), sizeof( uint32_t const * ) );
	swigStructField( "VkSwapchainCreateInfoKHR-compositeAlpha", offsetof( struct VkSwapchainCreateInfoKHR, compositeAlpha ), sizeof( VkCompositeAlphaFlagBitsKHR ) );
	swigStructField( "VkSwapchainCreateInfoKHR-imageArrayLayers", offsetof( struct VkSwapchainCreateInfoKHR, imageArrayLayers ), sizeof( uint32_t ) );
	swigStructField( "VkSwapchainCreateInfoKHR-flags", offsetof( struct VkSwapchainCreateInfoKHR, flags ), sizeof( VkSwapchainCreateFlagsKHR ) );
	swigStructField( "VkSwapchainCreateInfoKHR-imageColorSpace", offsetof( struct VkSwapchainCreateInfoKHR, imageColorSpace ), sizeof( VkColorSpaceKHR ) );
	swigStructField( "VkSwapchainCreateInfoKHR-imageSharingMode", offsetof( struct VkSwapchainCreateInfoKHR, imageSharingMode ), sizeof( VkSharingMode ) );
	swigStructField( "VkSwapchainCreateInfoKHR-minImageCount", offsetof( struct VkSwapchainCreateInfoKHR, minImageCount ), sizeof( uint32_t ) );
	swigStructField( "VkSwapchainCreateInfoKHR-surface", offsetof( struct VkSwapchainCreateInfoKHR, surface ), sizeof( VkSurfaceKHR ) );
	swigStructField( "VkSwapchainCreateInfoKHR-presentMode", offsetof( struct VkSwapchainCreateInfoKHR, presentMode ), sizeof( VkPresentModeKHR ) );
	swigStructField( "VkSwapchainCreateInfoKHR-clipped", offsetof( struct VkSwapchainCreateInfoKHR, clipped ), sizeof( VkBool32 ) );
	swigStructField( "VkSwapchainCreateInfoKHR-sType", offsetof( struct VkSwapchainCreateInfoKHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSwapchainCreateInfoKHR ) );

	swigComment("struct VkPresentInfoKHR\n");
	printf( "begin-structure VkPresentInfoKHR\n" );
	swigStructField( "VkPresentInfoKHR-swapchainCount", offsetof( struct VkPresentInfoKHR, swapchainCount ), sizeof( uint32_t ) );
	swigStructField( "VkPresentInfoKHR-pNext", offsetof( struct VkPresentInfoKHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkPresentInfoKHR-waitSemaphoreCount", offsetof( struct VkPresentInfoKHR, waitSemaphoreCount ), sizeof( uint32_t ) );
	swigStructField( "VkPresentInfoKHR-pWaitSemaphores", offsetof( struct VkPresentInfoKHR, pWaitSemaphores ), sizeof( VkSemaphore const * ) );
	swigStructField( "VkPresentInfoKHR-pSwapchains", offsetof( struct VkPresentInfoKHR, pSwapchains ), sizeof( VkSwapchainKHR const * ) );
	swigStructField( "VkPresentInfoKHR-pImageIndices", offsetof( struct VkPresentInfoKHR, pImageIndices ), sizeof( uint32_t const * ) );
	swigStructField( "VkPresentInfoKHR-pResults", offsetof( struct VkPresentInfoKHR, pResults ), sizeof( VkResult * ) );
	swigStructField( "VkPresentInfoKHR-sType", offsetof( struct VkPresentInfoKHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPresentInfoKHR ) );

	swigComment("struct VkImageSwapchainCreateInfoKHR\n");
	printf( "begin-structure VkImageSwapchainCreateInfoKHR\n" );
	swigStructField( "VkImageSwapchainCreateInfoKHR-pNext", offsetof( struct VkImageSwapchainCreateInfoKHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkImageSwapchainCreateInfoKHR-swapchain", offsetof( struct VkImageSwapchainCreateInfoKHR, swapchain ), sizeof( VkSwapchainKHR ) );
	swigStructField( "VkImageSwapchainCreateInfoKHR-sType", offsetof( struct VkImageSwapchainCreateInfoKHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkImageSwapchainCreateInfoKHR ) );

	swigComment("struct VkBindImageMemorySwapchainInfoKHR\n");
	printf( "begin-structure VkBindImageMemorySwapchainInfoKHR\n" );
	swigStructField( "VkBindImageMemorySwapchainInfoKHR-pNext", offsetof( struct VkBindImageMemorySwapchainInfoKHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkBindImageMemorySwapchainInfoKHR-imageIndex", offsetof( struct VkBindImageMemorySwapchainInfoKHR, imageIndex ), sizeof( uint32_t ) );
	swigStructField( "VkBindImageMemorySwapchainInfoKHR-swapchain", offsetof( struct VkBindImageMemorySwapchainInfoKHR, swapchain ), sizeof( VkSwapchainKHR ) );
	swigStructField( "VkBindImageMemorySwapchainInfoKHR-sType", offsetof( struct VkBindImageMemorySwapchainInfoKHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkBindImageMemorySwapchainInfoKHR ) );

	swigComment("struct VkAcquireNextImageInfoKHR\n");
	printf( "begin-structure VkAcquireNextImageInfoKHR\n" );
	swigStructField( "VkAcquireNextImageInfoKHR-pNext", offsetof( struct VkAcquireNextImageInfoKHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkAcquireNextImageInfoKHR-fence", offsetof( struct VkAcquireNextImageInfoKHR, fence ), sizeof( VkFence ) );
	swigStructField( "VkAcquireNextImageInfoKHR-deviceMask", offsetof( struct VkAcquireNextImageInfoKHR, deviceMask ), sizeof( uint32_t ) );
	swigStructField( "VkAcquireNextImageInfoKHR-swapchain", offsetof( struct VkAcquireNextImageInfoKHR, swapchain ), sizeof( VkSwapchainKHR ) );
	swigStructField( "VkAcquireNextImageInfoKHR-semaphore", offsetof( struct VkAcquireNextImageInfoKHR, semaphore ), sizeof( VkSemaphore ) );
	swigStructField( "VkAcquireNextImageInfoKHR-timeout", offsetof( struct VkAcquireNextImageInfoKHR, timeout ), sizeof( uint64_t ) );
	swigStructField( "VkAcquireNextImageInfoKHR-sType", offsetof( struct VkAcquireNextImageInfoKHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkAcquireNextImageInfoKHR ) );

	swigComment("struct VkDeviceGroupPresentCapabilitiesKHR\n");
	printf( "begin-structure VkDeviceGroupPresentCapabilitiesKHR\n" );
	swigStructField( "VkDeviceGroupPresentCapabilitiesKHR-presentMask", offsetof( struct VkDeviceGroupPresentCapabilitiesKHR, presentMask ), sizeof( uint32_t [32U] ) );
	swigStructField( "VkDeviceGroupPresentCapabilitiesKHR-pNext", offsetof( struct VkDeviceGroupPresentCapabilitiesKHR, pNext ), sizeof( void * ) );
	swigStructField( "VkDeviceGroupPresentCapabilitiesKHR-sType", offsetof( struct VkDeviceGroupPresentCapabilitiesKHR, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkDeviceGroupPresentCapabilitiesKHR-modes", offsetof( struct VkDeviceGroupPresentCapabilitiesKHR, modes ), sizeof( VkDeviceGroupPresentModeFlagsKHR ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDeviceGroupPresentCapabilitiesKHR ) );

	swigComment("struct VkDeviceGroupPresentInfoKHR\n");
	printf( "begin-structure VkDeviceGroupPresentInfoKHR\n" );
	swigStructField( "VkDeviceGroupPresentInfoKHR-swapchainCount", offsetof( struct VkDeviceGroupPresentInfoKHR, swapchainCount ), sizeof( uint32_t ) );
	swigStructField( "VkDeviceGroupPresentInfoKHR-pNext", offsetof( struct VkDeviceGroupPresentInfoKHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkDeviceGroupPresentInfoKHR-sType", offsetof( struct VkDeviceGroupPresentInfoKHR, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkDeviceGroupPresentInfoKHR-pDeviceMasks", offsetof( struct VkDeviceGroupPresentInfoKHR, pDeviceMasks ), sizeof( uint32_t const * ) );
	swigStructField( "VkDeviceGroupPresentInfoKHR-mode", offsetof( struct VkDeviceGroupPresentInfoKHR, mode ), sizeof( VkDeviceGroupPresentModeFlagBitsKHR ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDeviceGroupPresentInfoKHR ) );

	swigComment("struct VkDeviceGroupSwapchainCreateInfoKHR\n");
	printf( "begin-structure VkDeviceGroupSwapchainCreateInfoKHR\n" );
	swigStructField( "VkDeviceGroupSwapchainCreateInfoKHR-pNext", offsetof( struct VkDeviceGroupSwapchainCreateInfoKHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkDeviceGroupSwapchainCreateInfoKHR-sType", offsetof( struct VkDeviceGroupSwapchainCreateInfoKHR, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkDeviceGroupSwapchainCreateInfoKHR-modes", offsetof( struct VkDeviceGroupSwapchainCreateInfoKHR, modes ), sizeof( VkDeviceGroupPresentModeFlagsKHR ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDeviceGroupSwapchainCreateInfoKHR ) );

	swigComment("struct VkDisplayModeParametersKHR\n");
	printf( "begin-structure VkDisplayModeParametersKHR\n" );
	swigStructField( "VkDisplayModeParametersKHR-refreshRate", offsetof( struct VkDisplayModeParametersKHR, refreshRate ), sizeof( uint32_t ) );
	swigStructField( "VkDisplayModeParametersKHR-visibleRegion", offsetof( struct VkDisplayModeParametersKHR, visibleRegion ), sizeof( VkExtent2D ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDisplayModeParametersKHR ) );

	swigComment("struct VkDisplayModeCreateInfoKHR\n");
	printf( "begin-structure VkDisplayModeCreateInfoKHR\n" );
	swigStructField( "VkDisplayModeCreateInfoKHR-pNext", offsetof( struct VkDisplayModeCreateInfoKHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkDisplayModeCreateInfoKHR-parameters", offsetof( struct VkDisplayModeCreateInfoKHR, parameters ), sizeof( VkDisplayModeParametersKHR ) );
	swigStructField( "VkDisplayModeCreateInfoKHR-sType", offsetof( struct VkDisplayModeCreateInfoKHR, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkDisplayModeCreateInfoKHR-flags", offsetof( struct VkDisplayModeCreateInfoKHR, flags ), sizeof( VkDisplayModeCreateFlagsKHR ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDisplayModeCreateInfoKHR ) );

	swigComment("struct VkDisplayModePropertiesKHR\n");
	printf( "begin-structure VkDisplayModePropertiesKHR\n" );
	swigStructField( "VkDisplayModePropertiesKHR-parameters", offsetof( struct VkDisplayModePropertiesKHR, parameters ), sizeof( VkDisplayModeParametersKHR ) );
	swigStructField( "VkDisplayModePropertiesKHR-displayMode", offsetof( struct VkDisplayModePropertiesKHR, displayMode ), sizeof( VkDisplayModeKHR ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDisplayModePropertiesKHR ) );

	swigComment("struct VkDisplayPlaneCapabilitiesKHR\n");
	printf( "begin-structure VkDisplayPlaneCapabilitiesKHR\n" );
	swigStructField( "VkDisplayPlaneCapabilitiesKHR-supportedAlpha", offsetof( struct VkDisplayPlaneCapabilitiesKHR, supportedAlpha ), sizeof( VkDisplayPlaneAlphaFlagsKHR ) );
	swigStructField( "VkDisplayPlaneCapabilitiesKHR-minSrcExtent", offsetof( struct VkDisplayPlaneCapabilitiesKHR, minSrcExtent ), sizeof( VkExtent2D ) );
	swigStructField( "VkDisplayPlaneCapabilitiesKHR-maxSrcExtent", offsetof( struct VkDisplayPlaneCapabilitiesKHR, maxSrcExtent ), sizeof( VkExtent2D ) );
	swigStructField( "VkDisplayPlaneCapabilitiesKHR-minSrcPosition", offsetof( struct VkDisplayPlaneCapabilitiesKHR, minSrcPosition ), sizeof( VkOffset2D ) );
	swigStructField( "VkDisplayPlaneCapabilitiesKHR-maxSrcPosition", offsetof( struct VkDisplayPlaneCapabilitiesKHR, maxSrcPosition ), sizeof( VkOffset2D ) );
	swigStructField( "VkDisplayPlaneCapabilitiesKHR-minDstPosition", offsetof( struct VkDisplayPlaneCapabilitiesKHR, minDstPosition ), sizeof( VkOffset2D ) );
	swigStructField( "VkDisplayPlaneCapabilitiesKHR-maxDstPosition", offsetof( struct VkDisplayPlaneCapabilitiesKHR, maxDstPosition ), sizeof( VkOffset2D ) );
	swigStructField( "VkDisplayPlaneCapabilitiesKHR-minDstExtent", offsetof( struct VkDisplayPlaneCapabilitiesKHR, minDstExtent ), sizeof( VkExtent2D ) );
	swigStructField( "VkDisplayPlaneCapabilitiesKHR-maxDstExtent", offsetof( struct VkDisplayPlaneCapabilitiesKHR, maxDstExtent ), sizeof( VkExtent2D ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDisplayPlaneCapabilitiesKHR ) );

	swigComment("struct VkDisplayPlanePropertiesKHR\n");
	printf( "begin-structure VkDisplayPlanePropertiesKHR\n" );
	swigStructField( "VkDisplayPlanePropertiesKHR-currentDisplay", offsetof( struct VkDisplayPlanePropertiesKHR, currentDisplay ), sizeof( VkDisplayKHR ) );
	swigStructField( "VkDisplayPlanePropertiesKHR-currentStackIndex", offsetof( struct VkDisplayPlanePropertiesKHR, currentStackIndex ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDisplayPlanePropertiesKHR ) );

	swigComment("struct VkDisplayPropertiesKHR\n");
	printf( "begin-structure VkDisplayPropertiesKHR\n" );
	swigStructField( "VkDisplayPropertiesKHR-display", offsetof( struct VkDisplayPropertiesKHR, display ), sizeof( VkDisplayKHR ) );
	swigStructField( "VkDisplayPropertiesKHR-physicalResolution", offsetof( struct VkDisplayPropertiesKHR, physicalResolution ), sizeof( VkExtent2D ) );
	swigStructField( "VkDisplayPropertiesKHR-supportedTransforms", offsetof( struct VkDisplayPropertiesKHR, supportedTransforms ), sizeof( VkSurfaceTransformFlagsKHR ) );
	swigStructField( "VkDisplayPropertiesKHR-persistentContent", offsetof( struct VkDisplayPropertiesKHR, persistentContent ), sizeof( VkBool32 ) );
	swigStructField( "VkDisplayPropertiesKHR-displayName", offsetof( struct VkDisplayPropertiesKHR, displayName ), sizeof( char const * ) );
	swigStructField( "VkDisplayPropertiesKHR-planeReorderPossible", offsetof( struct VkDisplayPropertiesKHR, planeReorderPossible ), sizeof( VkBool32 ) );
	swigStructField( "VkDisplayPropertiesKHR-physicalDimensions", offsetof( struct VkDisplayPropertiesKHR, physicalDimensions ), sizeof( VkExtent2D ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDisplayPropertiesKHR ) );

	swigComment("struct VkDisplaySurfaceCreateInfoKHR\n");
	printf( "begin-structure VkDisplaySurfaceCreateInfoKHR\n" );
	swigStructField( "VkDisplaySurfaceCreateInfoKHR-planeStackIndex", offsetof( struct VkDisplaySurfaceCreateInfoKHR, planeStackIndex ), sizeof( uint32_t ) );
	swigStructField( "VkDisplaySurfaceCreateInfoKHR-imageExtent", offsetof( struct VkDisplaySurfaceCreateInfoKHR, imageExtent ), sizeof( VkExtent2D ) );
	swigStructField( "VkDisplaySurfaceCreateInfoKHR-pNext", offsetof( struct VkDisplaySurfaceCreateInfoKHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkDisplaySurfaceCreateInfoKHR-alphaMode", offsetof( struct VkDisplaySurfaceCreateInfoKHR, alphaMode ), sizeof( VkDisplayPlaneAlphaFlagBitsKHR ) );
	swigStructField( "VkDisplaySurfaceCreateInfoKHR-globalAlpha", offsetof( struct VkDisplaySurfaceCreateInfoKHR, globalAlpha ), sizeof( float ) );
	swigStructField( "VkDisplaySurfaceCreateInfoKHR-planeIndex", offsetof( struct VkDisplaySurfaceCreateInfoKHR, planeIndex ), sizeof( uint32_t ) );
	swigStructField( "VkDisplaySurfaceCreateInfoKHR-sType", offsetof( struct VkDisplaySurfaceCreateInfoKHR, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkDisplaySurfaceCreateInfoKHR-flags", offsetof( struct VkDisplaySurfaceCreateInfoKHR, flags ), sizeof( VkDisplaySurfaceCreateFlagsKHR ) );
	swigStructField( "VkDisplaySurfaceCreateInfoKHR-transform", offsetof( struct VkDisplaySurfaceCreateInfoKHR, transform ), sizeof( VkSurfaceTransformFlagBitsKHR ) );
	swigStructField( "VkDisplaySurfaceCreateInfoKHR-displayMode", offsetof( struct VkDisplaySurfaceCreateInfoKHR, displayMode ), sizeof( VkDisplayModeKHR ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDisplaySurfaceCreateInfoKHR ) );

	swigComment("struct VkDisplayPresentInfoKHR\n");
	printf( "begin-structure VkDisplayPresentInfoKHR\n" );
	swigStructField( "VkDisplayPresentInfoKHR-pNext", offsetof( struct VkDisplayPresentInfoKHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkDisplayPresentInfoKHR-persistent", offsetof( struct VkDisplayPresentInfoKHR, persistent ), sizeof( VkBool32 ) );
	swigStructField( "VkDisplayPresentInfoKHR-srcRect", offsetof( struct VkDisplayPresentInfoKHR, srcRect ), sizeof( VkRect2D ) );
	swigStructField( "VkDisplayPresentInfoKHR-dstRect", offsetof( struct VkDisplayPresentInfoKHR, dstRect ), sizeof( VkRect2D ) );
	swigStructField( "VkDisplayPresentInfoKHR-sType", offsetof( struct VkDisplayPresentInfoKHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDisplayPresentInfoKHR ) );

	swigComment("struct VkRenderingAttachmentInfoKHR\n");
	printf( "begin-structure VkRenderingAttachmentInfoKHR\n" );
	swigStructField( "VkRenderingAttachmentInfoKHR-pNext", offsetof( struct VkRenderingAttachmentInfoKHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkRenderingAttachmentInfoKHR-clearValue", offsetof( struct VkRenderingAttachmentInfoKHR, clearValue ), sizeof( VkClearValue ) );
	swigStructField( "VkRenderingAttachmentInfoKHR-imageLayout", offsetof( struct VkRenderingAttachmentInfoKHR, imageLayout ), sizeof( VkImageLayout ) );
	swigStructField( "VkRenderingAttachmentInfoKHR-resolveMode", offsetof( struct VkRenderingAttachmentInfoKHR, resolveMode ), sizeof( VkResolveModeFlagBits ) );
	swigStructField( "VkRenderingAttachmentInfoKHR-resolveImageLayout", offsetof( struct VkRenderingAttachmentInfoKHR, resolveImageLayout ), sizeof( VkImageLayout ) );
	swigStructField( "VkRenderingAttachmentInfoKHR-storeOp", offsetof( struct VkRenderingAttachmentInfoKHR, storeOp ), sizeof( VkAttachmentStoreOp ) );
	swigStructField( "VkRenderingAttachmentInfoKHR-loadOp", offsetof( struct VkRenderingAttachmentInfoKHR, loadOp ), sizeof( VkAttachmentLoadOp ) );
	swigStructField( "VkRenderingAttachmentInfoKHR-sType", offsetof( struct VkRenderingAttachmentInfoKHR, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkRenderingAttachmentInfoKHR-imageView", offsetof( struct VkRenderingAttachmentInfoKHR, imageView ), sizeof( VkImageView ) );
	swigStructField( "VkRenderingAttachmentInfoKHR-resolveImageView", offsetof( struct VkRenderingAttachmentInfoKHR, resolveImageView ), sizeof( VkImageView ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkRenderingAttachmentInfoKHR ) );

	swigComment("struct VkRenderingInfoKHR\n");
	printf( "begin-structure VkRenderingInfoKHR\n" );
	swigStructField( "VkRenderingInfoKHR-pNext", offsetof( struct VkRenderingInfoKHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkRenderingInfoKHR-renderArea", offsetof( struct VkRenderingInfoKHR, renderArea ), sizeof( VkRect2D ) );
	swigStructField( "VkRenderingInfoKHR-layerCount", offsetof( struct VkRenderingInfoKHR, layerCount ), sizeof( uint32_t ) );
	swigStructField( "VkRenderingInfoKHR-viewMask", offsetof( struct VkRenderingInfoKHR, viewMask ), sizeof( uint32_t ) );
	swigStructField( "VkRenderingInfoKHR-pColorAttachments", offsetof( struct VkRenderingInfoKHR, pColorAttachments ), sizeof( VkRenderingAttachmentInfoKHR const * ) );
	swigStructField( "VkRenderingInfoKHR-pDepthAttachment", offsetof( struct VkRenderingInfoKHR, pDepthAttachment ), sizeof( VkRenderingAttachmentInfoKHR const * ) );
	swigStructField( "VkRenderingInfoKHR-pStencilAttachment", offsetof( struct VkRenderingInfoKHR, pStencilAttachment ), sizeof( VkRenderingAttachmentInfoKHR const * ) );
	swigStructField( "VkRenderingInfoKHR-sType", offsetof( struct VkRenderingInfoKHR, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkRenderingInfoKHR-flags", offsetof( struct VkRenderingInfoKHR, flags ), sizeof( VkRenderingFlagsKHR ) );
	swigStructField( "VkRenderingInfoKHR-colorAttachmentCount", offsetof( struct VkRenderingInfoKHR, colorAttachmentCount ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkRenderingInfoKHR ) );

	swigComment("struct VkPipelineRenderingCreateInfoKHR\n");
	printf( "begin-structure VkPipelineRenderingCreateInfoKHR\n" );
	swigStructField( "VkPipelineRenderingCreateInfoKHR-pNext", offsetof( struct VkPipelineRenderingCreateInfoKHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkPipelineRenderingCreateInfoKHR-viewMask", offsetof( struct VkPipelineRenderingCreateInfoKHR, viewMask ), sizeof( uint32_t ) );
	swigStructField( "VkPipelineRenderingCreateInfoKHR-pColorAttachmentFormats", offsetof( struct VkPipelineRenderingCreateInfoKHR, pColorAttachmentFormats ), sizeof( VkFormat const * ) );
	swigStructField( "VkPipelineRenderingCreateInfoKHR-depthAttachmentFormat", offsetof( struct VkPipelineRenderingCreateInfoKHR, depthAttachmentFormat ), sizeof( VkFormat ) );
	swigStructField( "VkPipelineRenderingCreateInfoKHR-stencilAttachmentFormat", offsetof( struct VkPipelineRenderingCreateInfoKHR, stencilAttachmentFormat ), sizeof( VkFormat ) );
	swigStructField( "VkPipelineRenderingCreateInfoKHR-sType", offsetof( struct VkPipelineRenderingCreateInfoKHR, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPipelineRenderingCreateInfoKHR-colorAttachmentCount", offsetof( struct VkPipelineRenderingCreateInfoKHR, colorAttachmentCount ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineRenderingCreateInfoKHR ) );

	swigComment("struct VkPhysicalDeviceDynamicRenderingFeaturesKHR\n");
	printf( "begin-structure VkPhysicalDeviceDynamicRenderingFeaturesKHR\n" );
	swigStructField( "VkPhysicalDeviceDynamicRenderingFeaturesKHR-pNext", offsetof( struct VkPhysicalDeviceDynamicRenderingFeaturesKHR, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceDynamicRenderingFeaturesKHR-sType", offsetof( struct VkPhysicalDeviceDynamicRenderingFeaturesKHR, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDeviceDynamicRenderingFeaturesKHR-dynamicRendering", offsetof( struct VkPhysicalDeviceDynamicRenderingFeaturesKHR, dynamicRendering ), sizeof( VkBool32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceDynamicRenderingFeaturesKHR ) );

	swigComment("struct VkCommandBufferInheritanceRenderingInfoKHR\n");
	printf( "begin-structure VkCommandBufferInheritanceRenderingInfoKHR\n" );
	swigStructField( "VkCommandBufferInheritanceRenderingInfoKHR-pNext", offsetof( struct VkCommandBufferInheritanceRenderingInfoKHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkCommandBufferInheritanceRenderingInfoKHR-viewMask", offsetof( struct VkCommandBufferInheritanceRenderingInfoKHR, viewMask ), sizeof( uint32_t ) );
	swigStructField( "VkCommandBufferInheritanceRenderingInfoKHR-pColorAttachmentFormats", offsetof( struct VkCommandBufferInheritanceRenderingInfoKHR, pColorAttachmentFormats ), sizeof( VkFormat const * ) );
	swigStructField( "VkCommandBufferInheritanceRenderingInfoKHR-depthAttachmentFormat", offsetof( struct VkCommandBufferInheritanceRenderingInfoKHR, depthAttachmentFormat ), sizeof( VkFormat ) );
	swigStructField( "VkCommandBufferInheritanceRenderingInfoKHR-stencilAttachmentFormat", offsetof( struct VkCommandBufferInheritanceRenderingInfoKHR, stencilAttachmentFormat ), sizeof( VkFormat ) );
	swigStructField( "VkCommandBufferInheritanceRenderingInfoKHR-rasterizationSamples", offsetof( struct VkCommandBufferInheritanceRenderingInfoKHR, rasterizationSamples ), sizeof( VkSampleCountFlagBits ) );
	swigStructField( "VkCommandBufferInheritanceRenderingInfoKHR-sType", offsetof( struct VkCommandBufferInheritanceRenderingInfoKHR, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkCommandBufferInheritanceRenderingInfoKHR-flags", offsetof( struct VkCommandBufferInheritanceRenderingInfoKHR, flags ), sizeof( VkRenderingFlagsKHR ) );
	swigStructField( "VkCommandBufferInheritanceRenderingInfoKHR-colorAttachmentCount", offsetof( struct VkCommandBufferInheritanceRenderingInfoKHR, colorAttachmentCount ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkCommandBufferInheritanceRenderingInfoKHR ) );

	swigComment("struct VkRenderingFragmentShadingRateAttachmentInfoKHR\n");
	printf( "begin-structure VkRenderingFragmentShadingRateAttachmentInfoKHR\n" );
	swigStructField( "VkRenderingFragmentShadingRateAttachmentInfoKHR-pNext", offsetof( struct VkRenderingFragmentShadingRateAttachmentInfoKHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkRenderingFragmentShadingRateAttachmentInfoKHR-shadingRateAttachmentTexelSize", offsetof( struct VkRenderingFragmentShadingRateAttachmentInfoKHR, shadingRateAttachmentTexelSize ), sizeof( VkExtent2D ) );
	swigStructField( "VkRenderingFragmentShadingRateAttachmentInfoKHR-imageLayout", offsetof( struct VkRenderingFragmentShadingRateAttachmentInfoKHR, imageLayout ), sizeof( VkImageLayout ) );
	swigStructField( "VkRenderingFragmentShadingRateAttachmentInfoKHR-sType", offsetof( struct VkRenderingFragmentShadingRateAttachmentInfoKHR, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkRenderingFragmentShadingRateAttachmentInfoKHR-imageView", offsetof( struct VkRenderingFragmentShadingRateAttachmentInfoKHR, imageView ), sizeof( VkImageView ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkRenderingFragmentShadingRateAttachmentInfoKHR ) );

	swigComment("struct VkRenderingFragmentDensityMapAttachmentInfoEXT\n");
	printf( "begin-structure VkRenderingFragmentDensityMapAttachmentInfoEXT\n" );
	swigStructField( "VkRenderingFragmentDensityMapAttachmentInfoEXT-pNext", offsetof( struct VkRenderingFragmentDensityMapAttachmentInfoEXT, pNext ), sizeof( void const * ) );
	swigStructField( "VkRenderingFragmentDensityMapAttachmentInfoEXT-imageLayout", offsetof( struct VkRenderingFragmentDensityMapAttachmentInfoEXT, imageLayout ), sizeof( VkImageLayout ) );
	swigStructField( "VkRenderingFragmentDensityMapAttachmentInfoEXT-sType", offsetof( struct VkRenderingFragmentDensityMapAttachmentInfoEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkRenderingFragmentDensityMapAttachmentInfoEXT-imageView", offsetof( struct VkRenderingFragmentDensityMapAttachmentInfoEXT, imageView ), sizeof( VkImageView ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkRenderingFragmentDensityMapAttachmentInfoEXT ) );

	swigComment("struct VkAttachmentSampleCountInfoAMD\n");
	printf( "begin-structure VkAttachmentSampleCountInfoAMD\n" );
	swigStructField( "VkAttachmentSampleCountInfoAMD-pNext", offsetof( struct VkAttachmentSampleCountInfoAMD, pNext ), sizeof( void const * ) );
	swigStructField( "VkAttachmentSampleCountInfoAMD-pColorAttachmentSamples", offsetof( struct VkAttachmentSampleCountInfoAMD, pColorAttachmentSamples ), sizeof( VkSampleCountFlagBits const * ) );
	swigStructField( "VkAttachmentSampleCountInfoAMD-depthStencilAttachmentSamples", offsetof( struct VkAttachmentSampleCountInfoAMD, depthStencilAttachmentSamples ), sizeof( VkSampleCountFlagBits ) );
	swigStructField( "VkAttachmentSampleCountInfoAMD-sType", offsetof( struct VkAttachmentSampleCountInfoAMD, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkAttachmentSampleCountInfoAMD-colorAttachmentCount", offsetof( struct VkAttachmentSampleCountInfoAMD, colorAttachmentCount ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkAttachmentSampleCountInfoAMD ) );

	swigComment("struct VkMultiviewPerViewAttributesInfoNVX\n");
	printf( "begin-structure VkMultiviewPerViewAttributesInfoNVX\n" );
	swigStructField( "VkMultiviewPerViewAttributesInfoNVX-perViewAttributesPositionXOnly", offsetof( struct VkMultiviewPerViewAttributesInfoNVX, perViewAttributesPositionXOnly ), sizeof( VkBool32 ) );
	swigStructField( "VkMultiviewPerViewAttributesInfoNVX-pNext", offsetof( struct VkMultiviewPerViewAttributesInfoNVX, pNext ), sizeof( void const * ) );
	swigStructField( "VkMultiviewPerViewAttributesInfoNVX-sType", offsetof( struct VkMultiviewPerViewAttributesInfoNVX, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkMultiviewPerViewAttributesInfoNVX-perViewAttributes", offsetof( struct VkMultiviewPerViewAttributesInfoNVX, perViewAttributes ), sizeof( VkBool32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkMultiviewPerViewAttributesInfoNVX ) );

	swigComment("struct VkImportMemoryFdInfoKHR\n");
	printf( "begin-structure VkImportMemoryFdInfoKHR\n" );
	swigStructField( "VkImportMemoryFdInfoKHR-pNext", offsetof( struct VkImportMemoryFdInfoKHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkImportMemoryFdInfoKHR-handleType", offsetof( struct VkImportMemoryFdInfoKHR, handleType ), sizeof( VkExternalMemoryHandleTypeFlagBits ) );
	swigStructField( "VkImportMemoryFdInfoKHR-fd", offsetof( struct VkImportMemoryFdInfoKHR, fd ), sizeof( int ) );
	swigStructField( "VkImportMemoryFdInfoKHR-sType", offsetof( struct VkImportMemoryFdInfoKHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkImportMemoryFdInfoKHR ) );

	swigComment("struct VkMemoryFdPropertiesKHR\n");
	printf( "begin-structure VkMemoryFdPropertiesKHR\n" );
	swigStructField( "VkMemoryFdPropertiesKHR-pNext", offsetof( struct VkMemoryFdPropertiesKHR, pNext ), sizeof( void * ) );
	swigStructField( "VkMemoryFdPropertiesKHR-memoryTypeBits", offsetof( struct VkMemoryFdPropertiesKHR, memoryTypeBits ), sizeof( uint32_t ) );
	swigStructField( "VkMemoryFdPropertiesKHR-sType", offsetof( struct VkMemoryFdPropertiesKHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkMemoryFdPropertiesKHR ) );

	swigComment("struct VkMemoryGetFdInfoKHR\n");
	printf( "begin-structure VkMemoryGetFdInfoKHR\n" );
	swigStructField( "VkMemoryGetFdInfoKHR-pNext", offsetof( struct VkMemoryGetFdInfoKHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkMemoryGetFdInfoKHR-memory", offsetof( struct VkMemoryGetFdInfoKHR, memory ), sizeof( VkDeviceMemory ) );
	swigStructField( "VkMemoryGetFdInfoKHR-handleType", offsetof( struct VkMemoryGetFdInfoKHR, handleType ), sizeof( VkExternalMemoryHandleTypeFlagBits ) );
	swigStructField( "VkMemoryGetFdInfoKHR-sType", offsetof( struct VkMemoryGetFdInfoKHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkMemoryGetFdInfoKHR ) );

	swigComment("struct VkImportSemaphoreFdInfoKHR\n");
	printf( "begin-structure VkImportSemaphoreFdInfoKHR\n" );
	swigStructField( "VkImportSemaphoreFdInfoKHR-pNext", offsetof( struct VkImportSemaphoreFdInfoKHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkImportSemaphoreFdInfoKHR-handleType", offsetof( struct VkImportSemaphoreFdInfoKHR, handleType ), sizeof( VkExternalSemaphoreHandleTypeFlagBits ) );
	swigStructField( "VkImportSemaphoreFdInfoKHR-semaphore", offsetof( struct VkImportSemaphoreFdInfoKHR, semaphore ), sizeof( VkSemaphore ) );
	swigStructField( "VkImportSemaphoreFdInfoKHR-fd", offsetof( struct VkImportSemaphoreFdInfoKHR, fd ), sizeof( int ) );
	swigStructField( "VkImportSemaphoreFdInfoKHR-sType", offsetof( struct VkImportSemaphoreFdInfoKHR, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkImportSemaphoreFdInfoKHR-flags", offsetof( struct VkImportSemaphoreFdInfoKHR, flags ), sizeof( VkSemaphoreImportFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkImportSemaphoreFdInfoKHR ) );

	swigComment("struct VkSemaphoreGetFdInfoKHR\n");
	printf( "begin-structure VkSemaphoreGetFdInfoKHR\n" );
	swigStructField( "VkSemaphoreGetFdInfoKHR-pNext", offsetof( struct VkSemaphoreGetFdInfoKHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkSemaphoreGetFdInfoKHR-handleType", offsetof( struct VkSemaphoreGetFdInfoKHR, handleType ), sizeof( VkExternalSemaphoreHandleTypeFlagBits ) );
	swigStructField( "VkSemaphoreGetFdInfoKHR-semaphore", offsetof( struct VkSemaphoreGetFdInfoKHR, semaphore ), sizeof( VkSemaphore ) );
	swigStructField( "VkSemaphoreGetFdInfoKHR-sType", offsetof( struct VkSemaphoreGetFdInfoKHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSemaphoreGetFdInfoKHR ) );

	swigComment("struct VkPhysicalDevicePushDescriptorPropertiesKHR\n");
	printf( "begin-structure VkPhysicalDevicePushDescriptorPropertiesKHR\n" );
	swigStructField( "VkPhysicalDevicePushDescriptorPropertiesKHR-pNext", offsetof( struct VkPhysicalDevicePushDescriptorPropertiesKHR, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDevicePushDescriptorPropertiesKHR-maxPushDescriptors", offsetof( struct VkPhysicalDevicePushDescriptorPropertiesKHR, maxPushDescriptors ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDevicePushDescriptorPropertiesKHR-sType", offsetof( struct VkPhysicalDevicePushDescriptorPropertiesKHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDevicePushDescriptorPropertiesKHR ) );

	swigComment("struct VkRectLayerKHR\n");
	printf( "begin-structure VkRectLayerKHR\n" );
	swigStructField( "VkRectLayerKHR-extent", offsetof( struct VkRectLayerKHR, extent ), sizeof( VkExtent2D ) );
	swigStructField( "VkRectLayerKHR-layer", offsetof( struct VkRectLayerKHR, layer ), sizeof( uint32_t ) );
	swigStructField( "VkRectLayerKHR-offset", offsetof( struct VkRectLayerKHR, offset ), sizeof( VkOffset2D ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkRectLayerKHR ) );

	swigComment("struct VkPresentRegionKHR\n");
	printf( "begin-structure VkPresentRegionKHR\n" );
	swigStructField( "VkPresentRegionKHR-pRectangles", offsetof( struct VkPresentRegionKHR, pRectangles ), sizeof( VkRectLayerKHR const * ) );
	swigStructField( "VkPresentRegionKHR-rectangleCount", offsetof( struct VkPresentRegionKHR, rectangleCount ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPresentRegionKHR ) );

	swigComment("struct VkPresentRegionsKHR\n");
	printf( "begin-structure VkPresentRegionsKHR\n" );
	swigStructField( "VkPresentRegionsKHR-swapchainCount", offsetof( struct VkPresentRegionsKHR, swapchainCount ), sizeof( uint32_t ) );
	swigStructField( "VkPresentRegionsKHR-pNext", offsetof( struct VkPresentRegionsKHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkPresentRegionsKHR-pRegions", offsetof( struct VkPresentRegionsKHR, pRegions ), sizeof( VkPresentRegionKHR const * ) );
	swigStructField( "VkPresentRegionsKHR-sType", offsetof( struct VkPresentRegionsKHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPresentRegionsKHR ) );

	swigComment("struct VkSharedPresentSurfaceCapabilitiesKHR\n");
	printf( "begin-structure VkSharedPresentSurfaceCapabilitiesKHR\n" );
	swigStructField( "VkSharedPresentSurfaceCapabilitiesKHR-pNext", offsetof( struct VkSharedPresentSurfaceCapabilitiesKHR, pNext ), sizeof( void * ) );
	swigStructField( "VkSharedPresentSurfaceCapabilitiesKHR-sType", offsetof( struct VkSharedPresentSurfaceCapabilitiesKHR, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkSharedPresentSurfaceCapabilitiesKHR-sharedPresentSupportedUsageFlags", offsetof( struct VkSharedPresentSurfaceCapabilitiesKHR, sharedPresentSupportedUsageFlags ), sizeof( VkImageUsageFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSharedPresentSurfaceCapabilitiesKHR ) );

	swigComment("struct VkImportFenceFdInfoKHR\n");
	printf( "begin-structure VkImportFenceFdInfoKHR\n" );
	swigStructField( "VkImportFenceFdInfoKHR-pNext", offsetof( struct VkImportFenceFdInfoKHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkImportFenceFdInfoKHR-fence", offsetof( struct VkImportFenceFdInfoKHR, fence ), sizeof( VkFence ) );
	swigStructField( "VkImportFenceFdInfoKHR-handleType", offsetof( struct VkImportFenceFdInfoKHR, handleType ), sizeof( VkExternalFenceHandleTypeFlagBits ) );
	swigStructField( "VkImportFenceFdInfoKHR-fd", offsetof( struct VkImportFenceFdInfoKHR, fd ), sizeof( int ) );
	swigStructField( "VkImportFenceFdInfoKHR-sType", offsetof( struct VkImportFenceFdInfoKHR, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkImportFenceFdInfoKHR-flags", offsetof( struct VkImportFenceFdInfoKHR, flags ), sizeof( VkFenceImportFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkImportFenceFdInfoKHR ) );

	swigComment("struct VkFenceGetFdInfoKHR\n");
	printf( "begin-structure VkFenceGetFdInfoKHR\n" );
	swigStructField( "VkFenceGetFdInfoKHR-pNext", offsetof( struct VkFenceGetFdInfoKHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkFenceGetFdInfoKHR-fence", offsetof( struct VkFenceGetFdInfoKHR, fence ), sizeof( VkFence ) );
	swigStructField( "VkFenceGetFdInfoKHR-handleType", offsetof( struct VkFenceGetFdInfoKHR, handleType ), sizeof( VkExternalFenceHandleTypeFlagBits ) );
	swigStructField( "VkFenceGetFdInfoKHR-sType", offsetof( struct VkFenceGetFdInfoKHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkFenceGetFdInfoKHR ) );

	swigComment("struct VkPhysicalDevicePerformanceQueryFeaturesKHR\n");
	printf( "begin-structure VkPhysicalDevicePerformanceQueryFeaturesKHR\n" );
	swigStructField( "VkPhysicalDevicePerformanceQueryFeaturesKHR-pNext", offsetof( struct VkPhysicalDevicePerformanceQueryFeaturesKHR, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDevicePerformanceQueryFeaturesKHR-sType", offsetof( struct VkPhysicalDevicePerformanceQueryFeaturesKHR, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDevicePerformanceQueryFeaturesKHR-performanceCounterQueryPools", offsetof( struct VkPhysicalDevicePerformanceQueryFeaturesKHR, performanceCounterQueryPools ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDevicePerformanceQueryFeaturesKHR-performanceCounterMultipleQueryPools", offsetof( struct VkPhysicalDevicePerformanceQueryFeaturesKHR, performanceCounterMultipleQueryPools ), sizeof( VkBool32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDevicePerformanceQueryFeaturesKHR ) );

	swigComment("struct VkPhysicalDevicePerformanceQueryPropertiesKHR\n");
	printf( "begin-structure VkPhysicalDevicePerformanceQueryPropertiesKHR\n" );
	swigStructField( "VkPhysicalDevicePerformanceQueryPropertiesKHR-pNext", offsetof( struct VkPhysicalDevicePerformanceQueryPropertiesKHR, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDevicePerformanceQueryPropertiesKHR-allowCommandBufferQueryCopies", offsetof( struct VkPhysicalDevicePerformanceQueryPropertiesKHR, allowCommandBufferQueryCopies ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDevicePerformanceQueryPropertiesKHR-sType", offsetof( struct VkPhysicalDevicePerformanceQueryPropertiesKHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDevicePerformanceQueryPropertiesKHR ) );

	swigComment("struct VkPerformanceCounterKHR\n");
	printf( "begin-structure VkPerformanceCounterKHR\n" );
	swigStructField( "VkPerformanceCounterKHR-scope", offsetof( struct VkPerformanceCounterKHR, scope ), sizeof( VkPerformanceCounterScopeKHR ) );
	swigStructField( "VkPerformanceCounterKHR-pNext", offsetof( struct VkPerformanceCounterKHR, pNext ), sizeof( void * ) );
	swigStructField( "VkPerformanceCounterKHR-storage", offsetof( struct VkPerformanceCounterKHR, storage ), sizeof( VkPerformanceCounterStorageKHR ) );
	swigStructField( "VkPerformanceCounterKHR-uuid", offsetof( struct VkPerformanceCounterKHR, uuid ), sizeof( uint8_t [16U] ) );
	swigStructField( "VkPerformanceCounterKHR-sType", offsetof( struct VkPerformanceCounterKHR, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPerformanceCounterKHR-unit", offsetof( struct VkPerformanceCounterKHR, unit ), sizeof( VkPerformanceCounterUnitKHR ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPerformanceCounterKHR ) );

	swigComment("struct VkPerformanceCounterDescriptionKHR\n");
	printf( "begin-structure VkPerformanceCounterDescriptionKHR\n" );
	swigStructField( "VkPerformanceCounterDescriptionKHR-pNext", offsetof( struct VkPerformanceCounterDescriptionKHR, pNext ), sizeof( void * ) );
	swigStructField( "VkPerformanceCounterDescriptionKHR-name", offsetof( struct VkPerformanceCounterDescriptionKHR, name ), sizeof( char [256U] ) );
	swigStructField( "VkPerformanceCounterDescriptionKHR-category", offsetof( struct VkPerformanceCounterDescriptionKHR, category ), sizeof( char [256U] ) );
	swigStructField( "VkPerformanceCounterDescriptionKHR-description", offsetof( struct VkPerformanceCounterDescriptionKHR, description ), sizeof( char [256U] ) );
	swigStructField( "VkPerformanceCounterDescriptionKHR-sType", offsetof( struct VkPerformanceCounterDescriptionKHR, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPerformanceCounterDescriptionKHR-flags", offsetof( struct VkPerformanceCounterDescriptionKHR, flags ), sizeof( VkPerformanceCounterDescriptionFlagsKHR ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPerformanceCounterDescriptionKHR ) );

	swigComment("struct VkQueryPoolPerformanceCreateInfoKHR\n");
	printf( "begin-structure VkQueryPoolPerformanceCreateInfoKHR\n" );
	swigStructField( "VkQueryPoolPerformanceCreateInfoKHR-pNext", offsetof( struct VkQueryPoolPerformanceCreateInfoKHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkQueryPoolPerformanceCreateInfoKHR-queueFamilyIndex", offsetof( struct VkQueryPoolPerformanceCreateInfoKHR, queueFamilyIndex ), sizeof( uint32_t ) );
	swigStructField( "VkQueryPoolPerformanceCreateInfoKHR-pCounterIndices", offsetof( struct VkQueryPoolPerformanceCreateInfoKHR, pCounterIndices ), sizeof( uint32_t const * ) );
	swigStructField( "VkQueryPoolPerformanceCreateInfoKHR-sType", offsetof( struct VkQueryPoolPerformanceCreateInfoKHR, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkQueryPoolPerformanceCreateInfoKHR-counterIndexCount", offsetof( struct VkQueryPoolPerformanceCreateInfoKHR, counterIndexCount ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkQueryPoolPerformanceCreateInfoKHR ) );

	swigComment("union VkPerformanceCounterResultKHR\n");
	printf( "begin-structure VkPerformanceCounterResultKHR\n" );
	swigStructField( "VkPerformanceCounterResultKHR-int32", offsetof( union VkPerformanceCounterResultKHR, int32 ), sizeof( int32_t ) );
	swigStructField( "VkPerformanceCounterResultKHR-int64", offsetof( union VkPerformanceCounterResultKHR, int64 ), sizeof( int64_t ) );
	swigStructField( "VkPerformanceCounterResultKHR-uint32", offsetof( union VkPerformanceCounterResultKHR, uint32 ), sizeof( uint32_t ) );
	swigStructField( "VkPerformanceCounterResultKHR-uint64", offsetof( union VkPerformanceCounterResultKHR, uint64 ), sizeof( uint64_t ) );
	swigStructField( "VkPerformanceCounterResultKHR-float32", offsetof( union VkPerformanceCounterResultKHR, float32 ), sizeof( float ) );
	swigStructField( "VkPerformanceCounterResultKHR-float64", offsetof( union VkPerformanceCounterResultKHR, float64 ), sizeof( double ) );
	printf( "drop %zu end-structure\n", sizeof( union VkPerformanceCounterResultKHR ) );

	swigComment("struct VkAcquireProfilingLockInfoKHR\n");
	printf( "begin-structure VkAcquireProfilingLockInfoKHR\n" );
	swigStructField( "VkAcquireProfilingLockInfoKHR-pNext", offsetof( struct VkAcquireProfilingLockInfoKHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkAcquireProfilingLockInfoKHR-timeout", offsetof( struct VkAcquireProfilingLockInfoKHR, timeout ), sizeof( uint64_t ) );
	swigStructField( "VkAcquireProfilingLockInfoKHR-sType", offsetof( struct VkAcquireProfilingLockInfoKHR, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkAcquireProfilingLockInfoKHR-flags", offsetof( struct VkAcquireProfilingLockInfoKHR, flags ), sizeof( VkAcquireProfilingLockFlagsKHR ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkAcquireProfilingLockInfoKHR ) );

	swigComment("struct VkPerformanceQuerySubmitInfoKHR\n");
	printf( "begin-structure VkPerformanceQuerySubmitInfoKHR\n" );
	swigStructField( "VkPerformanceQuerySubmitInfoKHR-pNext", offsetof( struct VkPerformanceQuerySubmitInfoKHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkPerformanceQuerySubmitInfoKHR-counterPassIndex", offsetof( struct VkPerformanceQuerySubmitInfoKHR, counterPassIndex ), sizeof( uint32_t ) );
	swigStructField( "VkPerformanceQuerySubmitInfoKHR-sType", offsetof( struct VkPerformanceQuerySubmitInfoKHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPerformanceQuerySubmitInfoKHR ) );

	swigComment("struct VkPhysicalDeviceSurfaceInfo2KHR\n");
	printf( "begin-structure VkPhysicalDeviceSurfaceInfo2KHR\n" );
	swigStructField( "VkPhysicalDeviceSurfaceInfo2KHR-pNext", offsetof( struct VkPhysicalDeviceSurfaceInfo2KHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkPhysicalDeviceSurfaceInfo2KHR-surface", offsetof( struct VkPhysicalDeviceSurfaceInfo2KHR, surface ), sizeof( VkSurfaceKHR ) );
	swigStructField( "VkPhysicalDeviceSurfaceInfo2KHR-sType", offsetof( struct VkPhysicalDeviceSurfaceInfo2KHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceSurfaceInfo2KHR ) );

	swigComment("struct VkSurfaceCapabilities2KHR\n");
	printf( "begin-structure VkSurfaceCapabilities2KHR\n" );
	swigStructField( "VkSurfaceCapabilities2KHR-pNext", offsetof( struct VkSurfaceCapabilities2KHR, pNext ), sizeof( void * ) );
	swigStructField( "VkSurfaceCapabilities2KHR-surfaceCapabilities", offsetof( struct VkSurfaceCapabilities2KHR, surfaceCapabilities ), sizeof( VkSurfaceCapabilitiesKHR ) );
	swigStructField( "VkSurfaceCapabilities2KHR-sType", offsetof( struct VkSurfaceCapabilities2KHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSurfaceCapabilities2KHR ) );

	swigComment("struct VkSurfaceFormat2KHR\n");
	printf( "begin-structure VkSurfaceFormat2KHR\n" );
	swigStructField( "VkSurfaceFormat2KHR-pNext", offsetof( struct VkSurfaceFormat2KHR, pNext ), sizeof( void * ) );
	swigStructField( "VkSurfaceFormat2KHR-sType", offsetof( struct VkSurfaceFormat2KHR, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkSurfaceFormat2KHR-surfaceFormat", offsetof( struct VkSurfaceFormat2KHR, surfaceFormat ), sizeof( VkSurfaceFormatKHR ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSurfaceFormat2KHR ) );

	swigComment("struct VkDisplayProperties2KHR\n");
	printf( "begin-structure VkDisplayProperties2KHR\n" );
	swigStructField( "VkDisplayProperties2KHR-pNext", offsetof( struct VkDisplayProperties2KHR, pNext ), sizeof( void * ) );
	swigStructField( "VkDisplayProperties2KHR-displayProperties", offsetof( struct VkDisplayProperties2KHR, displayProperties ), sizeof( VkDisplayPropertiesKHR ) );
	swigStructField( "VkDisplayProperties2KHR-sType", offsetof( struct VkDisplayProperties2KHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDisplayProperties2KHR ) );

	swigComment("struct VkDisplayPlaneProperties2KHR\n");
	printf( "begin-structure VkDisplayPlaneProperties2KHR\n" );
	swigStructField( "VkDisplayPlaneProperties2KHR-pNext", offsetof( struct VkDisplayPlaneProperties2KHR, pNext ), sizeof( void * ) );
	swigStructField( "VkDisplayPlaneProperties2KHR-displayPlaneProperties", offsetof( struct VkDisplayPlaneProperties2KHR, displayPlaneProperties ), sizeof( VkDisplayPlanePropertiesKHR ) );
	swigStructField( "VkDisplayPlaneProperties2KHR-sType", offsetof( struct VkDisplayPlaneProperties2KHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDisplayPlaneProperties2KHR ) );

	swigComment("struct VkDisplayModeProperties2KHR\n");
	printf( "begin-structure VkDisplayModeProperties2KHR\n" );
	swigStructField( "VkDisplayModeProperties2KHR-pNext", offsetof( struct VkDisplayModeProperties2KHR, pNext ), sizeof( void * ) );
	swigStructField( "VkDisplayModeProperties2KHR-displayModeProperties", offsetof( struct VkDisplayModeProperties2KHR, displayModeProperties ), sizeof( VkDisplayModePropertiesKHR ) );
	swigStructField( "VkDisplayModeProperties2KHR-sType", offsetof( struct VkDisplayModeProperties2KHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDisplayModeProperties2KHR ) );

	swigComment("struct VkDisplayPlaneInfo2KHR\n");
	printf( "begin-structure VkDisplayPlaneInfo2KHR\n" );
	swigStructField( "VkDisplayPlaneInfo2KHR-pNext", offsetof( struct VkDisplayPlaneInfo2KHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkDisplayPlaneInfo2KHR-planeIndex", offsetof( struct VkDisplayPlaneInfo2KHR, planeIndex ), sizeof( uint32_t ) );
	swigStructField( "VkDisplayPlaneInfo2KHR-sType", offsetof( struct VkDisplayPlaneInfo2KHR, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkDisplayPlaneInfo2KHR-mode", offsetof( struct VkDisplayPlaneInfo2KHR, mode ), sizeof( VkDisplayModeKHR ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDisplayPlaneInfo2KHR ) );

	swigComment("struct VkDisplayPlaneCapabilities2KHR\n");
	printf( "begin-structure VkDisplayPlaneCapabilities2KHR\n" );
	swigStructField( "VkDisplayPlaneCapabilities2KHR-pNext", offsetof( struct VkDisplayPlaneCapabilities2KHR, pNext ), sizeof( void * ) );
	swigStructField( "VkDisplayPlaneCapabilities2KHR-capabilities", offsetof( struct VkDisplayPlaneCapabilities2KHR, capabilities ), sizeof( VkDisplayPlaneCapabilitiesKHR ) );
	swigStructField( "VkDisplayPlaneCapabilities2KHR-sType", offsetof( struct VkDisplayPlaneCapabilities2KHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDisplayPlaneCapabilities2KHR ) );

	swigComment("struct VkPhysicalDeviceShaderClockFeaturesKHR\n");
	printf( "begin-structure VkPhysicalDeviceShaderClockFeaturesKHR\n" );
	swigStructField( "VkPhysicalDeviceShaderClockFeaturesKHR-pNext", offsetof( struct VkPhysicalDeviceShaderClockFeaturesKHR, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceShaderClockFeaturesKHR-sType", offsetof( struct VkPhysicalDeviceShaderClockFeaturesKHR, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDeviceShaderClockFeaturesKHR-shaderDeviceClock", offsetof( struct VkPhysicalDeviceShaderClockFeaturesKHR, shaderDeviceClock ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderClockFeaturesKHR-shaderSubgroupClock", offsetof( struct VkPhysicalDeviceShaderClockFeaturesKHR, shaderSubgroupClock ), sizeof( VkBool32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceShaderClockFeaturesKHR ) );

	swigComment("struct VkPhysicalDeviceShaderTerminateInvocationFeaturesKHR\n");
	printf( "begin-structure VkPhysicalDeviceShaderTerminateInvocationFeaturesKHR\n" );
	swigStructField( "VkPhysicalDeviceShaderTerminateInvocationFeaturesKHR-shaderTerminateInvocation", offsetof( struct VkPhysicalDeviceShaderTerminateInvocationFeaturesKHR, shaderTerminateInvocation ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderTerminateInvocationFeaturesKHR-pNext", offsetof( struct VkPhysicalDeviceShaderTerminateInvocationFeaturesKHR, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceShaderTerminateInvocationFeaturesKHR-sType", offsetof( struct VkPhysicalDeviceShaderTerminateInvocationFeaturesKHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceShaderTerminateInvocationFeaturesKHR ) );

	swigComment("struct VkFragmentShadingRateAttachmentInfoKHR\n");
	printf( "begin-structure VkFragmentShadingRateAttachmentInfoKHR\n" );
	swigStructField( "VkFragmentShadingRateAttachmentInfoKHR-pNext", offsetof( struct VkFragmentShadingRateAttachmentInfoKHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkFragmentShadingRateAttachmentInfoKHR-pFragmentShadingRateAttachment", offsetof( struct VkFragmentShadingRateAttachmentInfoKHR, pFragmentShadingRateAttachment ), sizeof( VkAttachmentReference2 const * ) );
	swigStructField( "VkFragmentShadingRateAttachmentInfoKHR-shadingRateAttachmentTexelSize", offsetof( struct VkFragmentShadingRateAttachmentInfoKHR, shadingRateAttachmentTexelSize ), sizeof( VkExtent2D ) );
	swigStructField( "VkFragmentShadingRateAttachmentInfoKHR-sType", offsetof( struct VkFragmentShadingRateAttachmentInfoKHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkFragmentShadingRateAttachmentInfoKHR ) );

	swigComment("struct VkPipelineFragmentShadingRateStateCreateInfoKHR\n");
	printf( "begin-structure VkPipelineFragmentShadingRateStateCreateInfoKHR\n" );
	swigStructField( "VkPipelineFragmentShadingRateStateCreateInfoKHR-combinerOps", offsetof( struct VkPipelineFragmentShadingRateStateCreateInfoKHR, combinerOps ), sizeof( VkFragmentShadingRateCombinerOpKHR [2] ) );
	swigStructField( "VkPipelineFragmentShadingRateStateCreateInfoKHR-pNext", offsetof( struct VkPipelineFragmentShadingRateStateCreateInfoKHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkPipelineFragmentShadingRateStateCreateInfoKHR-fragmentSize", offsetof( struct VkPipelineFragmentShadingRateStateCreateInfoKHR, fragmentSize ), sizeof( VkExtent2D ) );
	swigStructField( "VkPipelineFragmentShadingRateStateCreateInfoKHR-sType", offsetof( struct VkPipelineFragmentShadingRateStateCreateInfoKHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineFragmentShadingRateStateCreateInfoKHR ) );

	swigComment("struct VkPhysicalDeviceFragmentShadingRateFeaturesKHR\n");
	printf( "begin-structure VkPhysicalDeviceFragmentShadingRateFeaturesKHR\n" );
	swigStructField( "VkPhysicalDeviceFragmentShadingRateFeaturesKHR-pipelineFragmentShadingRate", offsetof( struct VkPhysicalDeviceFragmentShadingRateFeaturesKHR, pipelineFragmentShadingRate ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFragmentShadingRateFeaturesKHR-primitiveFragmentShadingRate", offsetof( struct VkPhysicalDeviceFragmentShadingRateFeaturesKHR, primitiveFragmentShadingRate ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFragmentShadingRateFeaturesKHR-attachmentFragmentShadingRate", offsetof( struct VkPhysicalDeviceFragmentShadingRateFeaturesKHR, attachmentFragmentShadingRate ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFragmentShadingRateFeaturesKHR-pNext", offsetof( struct VkPhysicalDeviceFragmentShadingRateFeaturesKHR, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceFragmentShadingRateFeaturesKHR-sType", offsetof( struct VkPhysicalDeviceFragmentShadingRateFeaturesKHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceFragmentShadingRateFeaturesKHR ) );

	swigComment("struct VkPhysicalDeviceFragmentShadingRatePropertiesKHR\n");
	printf( "begin-structure VkPhysicalDeviceFragmentShadingRatePropertiesKHR\n" );
	swigStructField( "VkPhysicalDeviceFragmentShadingRatePropertiesKHR-layeredShadingRateAttachments", offsetof( struct VkPhysicalDeviceFragmentShadingRatePropertiesKHR, layeredShadingRateAttachments ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFragmentShadingRatePropertiesKHR-maxFragmentSize", offsetof( struct VkPhysicalDeviceFragmentShadingRatePropertiesKHR, maxFragmentSize ), sizeof( VkExtent2D ) );
	swigStructField( "VkPhysicalDeviceFragmentShadingRatePropertiesKHR-fragmentShadingRateStrictMultiplyCombiner", offsetof( struct VkPhysicalDeviceFragmentShadingRatePropertiesKHR, fragmentShadingRateStrictMultiplyCombiner ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFragmentShadingRatePropertiesKHR-pNext", offsetof( struct VkPhysicalDeviceFragmentShadingRatePropertiesKHR, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceFragmentShadingRatePropertiesKHR-maxFragmentShadingRateAttachmentTexelSize", offsetof( struct VkPhysicalDeviceFragmentShadingRatePropertiesKHR, maxFragmentShadingRateAttachmentTexelSize ), sizeof( VkExtent2D ) );
	swigStructField( "VkPhysicalDeviceFragmentShadingRatePropertiesKHR-minFragmentShadingRateAttachmentTexelSize", offsetof( struct VkPhysicalDeviceFragmentShadingRatePropertiesKHR, minFragmentShadingRateAttachmentTexelSize ), sizeof( VkExtent2D ) );
	swigStructField( "VkPhysicalDeviceFragmentShadingRatePropertiesKHR-fragmentShadingRateNonTrivialCombinerOps", offsetof( struct VkPhysicalDeviceFragmentShadingRatePropertiesKHR, fragmentShadingRateNonTrivialCombinerOps ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFragmentShadingRatePropertiesKHR-maxFragmentShadingRateRasterizationSamples", offsetof( struct VkPhysicalDeviceFragmentShadingRatePropertiesKHR, maxFragmentShadingRateRasterizationSamples ), sizeof( VkSampleCountFlagBits ) );
	swigStructField( "VkPhysicalDeviceFragmentShadingRatePropertiesKHR-maxFragmentShadingRateCoverageSamples", offsetof( struct VkPhysicalDeviceFragmentShadingRatePropertiesKHR, maxFragmentShadingRateCoverageSamples ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceFragmentShadingRatePropertiesKHR-maxFragmentSizeAspectRatio", offsetof( struct VkPhysicalDeviceFragmentShadingRatePropertiesKHR, maxFragmentSizeAspectRatio ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceFragmentShadingRatePropertiesKHR-fragmentShadingRateWithSampleMask", offsetof( struct VkPhysicalDeviceFragmentShadingRatePropertiesKHR, fragmentShadingRateWithSampleMask ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFragmentShadingRatePropertiesKHR-fragmentShadingRateWithShaderSampleMask", offsetof( struct VkPhysicalDeviceFragmentShadingRatePropertiesKHR, fragmentShadingRateWithShaderSampleMask ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFragmentShadingRatePropertiesKHR-fragmentShadingRateWithFragmentShaderInterlock", offsetof( struct VkPhysicalDeviceFragmentShadingRatePropertiesKHR, fragmentShadingRateWithFragmentShaderInterlock ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFragmentShadingRatePropertiesKHR-maxFragmentShadingRateAttachmentTexelSizeAspectRatio", offsetof( struct VkPhysicalDeviceFragmentShadingRatePropertiesKHR, maxFragmentShadingRateAttachmentTexelSizeAspectRatio ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceFragmentShadingRatePropertiesKHR-fragmentShadingRateWithShaderDepthStencilWrites", offsetof( struct VkPhysicalDeviceFragmentShadingRatePropertiesKHR, fragmentShadingRateWithShaderDepthStencilWrites ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFragmentShadingRatePropertiesKHR-primitiveFragmentShadingRateWithMultipleViewports", offsetof( struct VkPhysicalDeviceFragmentShadingRatePropertiesKHR, primitiveFragmentShadingRateWithMultipleViewports ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFragmentShadingRatePropertiesKHR-fragmentShadingRateWithCustomSampleLocations", offsetof( struct VkPhysicalDeviceFragmentShadingRatePropertiesKHR, fragmentShadingRateWithCustomSampleLocations ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFragmentShadingRatePropertiesKHR-fragmentShadingRateWithConservativeRasterization", offsetof( struct VkPhysicalDeviceFragmentShadingRatePropertiesKHR, fragmentShadingRateWithConservativeRasterization ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFragmentShadingRatePropertiesKHR-sType", offsetof( struct VkPhysicalDeviceFragmentShadingRatePropertiesKHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceFragmentShadingRatePropertiesKHR ) );

	swigComment("struct VkPhysicalDeviceFragmentShadingRateKHR\n");
	printf( "begin-structure VkPhysicalDeviceFragmentShadingRateKHR\n" );
	swigStructField( "VkPhysicalDeviceFragmentShadingRateKHR-pNext", offsetof( struct VkPhysicalDeviceFragmentShadingRateKHR, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceFragmentShadingRateKHR-sampleCounts", offsetof( struct VkPhysicalDeviceFragmentShadingRateKHR, sampleCounts ), sizeof( VkSampleCountFlags ) );
	swigStructField( "VkPhysicalDeviceFragmentShadingRateKHR-fragmentSize", offsetof( struct VkPhysicalDeviceFragmentShadingRateKHR, fragmentSize ), sizeof( VkExtent2D ) );
	swigStructField( "VkPhysicalDeviceFragmentShadingRateKHR-sType", offsetof( struct VkPhysicalDeviceFragmentShadingRateKHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceFragmentShadingRateKHR ) );

	swigComment("struct VkSurfaceProtectedCapabilitiesKHR\n");
	printf( "begin-structure VkSurfaceProtectedCapabilitiesKHR\n" );
	swigStructField( "VkSurfaceProtectedCapabilitiesKHR-pNext", offsetof( struct VkSurfaceProtectedCapabilitiesKHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkSurfaceProtectedCapabilitiesKHR-sType", offsetof( struct VkSurfaceProtectedCapabilitiesKHR, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkSurfaceProtectedCapabilitiesKHR-supportsProtected", offsetof( struct VkSurfaceProtectedCapabilitiesKHR, supportsProtected ), sizeof( VkBool32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSurfaceProtectedCapabilitiesKHR ) );

	swigComment("struct VkPhysicalDevicePresentWaitFeaturesKHR\n");
	printf( "begin-structure VkPhysicalDevicePresentWaitFeaturesKHR\n" );
	swigStructField( "VkPhysicalDevicePresentWaitFeaturesKHR-presentWait", offsetof( struct VkPhysicalDevicePresentWaitFeaturesKHR, presentWait ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDevicePresentWaitFeaturesKHR-pNext", offsetof( struct VkPhysicalDevicePresentWaitFeaturesKHR, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDevicePresentWaitFeaturesKHR-sType", offsetof( struct VkPhysicalDevicePresentWaitFeaturesKHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDevicePresentWaitFeaturesKHR ) );

	swigComment("struct VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR\n");
	printf( "begin-structure VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR\n" );
	swigStructField( "VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR-pNext", offsetof( struct VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR-pipelineExecutableInfo", offsetof( struct VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR, pipelineExecutableInfo ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR-sType", offsetof( struct VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR ) );

	swigComment("struct VkPipelineInfoKHR\n");
	printf( "begin-structure VkPipelineInfoKHR\n" );
	swigStructField( "VkPipelineInfoKHR-pipeline", offsetof( struct VkPipelineInfoKHR, pipeline ), sizeof( VkPipeline ) );
	swigStructField( "VkPipelineInfoKHR-pNext", offsetof( struct VkPipelineInfoKHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkPipelineInfoKHR-sType", offsetof( struct VkPipelineInfoKHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineInfoKHR ) );

	swigComment("struct VkPipelineExecutablePropertiesKHR\n");
	printf( "begin-structure VkPipelineExecutablePropertiesKHR\n" );
	swigStructField( "VkPipelineExecutablePropertiesKHR-subgroupSize", offsetof( struct VkPipelineExecutablePropertiesKHR, subgroupSize ), sizeof( uint32_t ) );
	swigStructField( "VkPipelineExecutablePropertiesKHR-pNext", offsetof( struct VkPipelineExecutablePropertiesKHR, pNext ), sizeof( void * ) );
	swigStructField( "VkPipelineExecutablePropertiesKHR-name", offsetof( struct VkPipelineExecutablePropertiesKHR, name ), sizeof( char [256U] ) );
	swigStructField( "VkPipelineExecutablePropertiesKHR-stages", offsetof( struct VkPipelineExecutablePropertiesKHR, stages ), sizeof( VkShaderStageFlags ) );
	swigStructField( "VkPipelineExecutablePropertiesKHR-description", offsetof( struct VkPipelineExecutablePropertiesKHR, description ), sizeof( char [256U] ) );
	swigStructField( "VkPipelineExecutablePropertiesKHR-sType", offsetof( struct VkPipelineExecutablePropertiesKHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineExecutablePropertiesKHR ) );

	swigComment("struct VkPipelineExecutableInfoKHR\n");
	printf( "begin-structure VkPipelineExecutableInfoKHR\n" );
	swigStructField( "VkPipelineExecutableInfoKHR-pipeline", offsetof( struct VkPipelineExecutableInfoKHR, pipeline ), sizeof( VkPipeline ) );
	swigStructField( "VkPipelineExecutableInfoKHR-pNext", offsetof( struct VkPipelineExecutableInfoKHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkPipelineExecutableInfoKHR-executableIndex", offsetof( struct VkPipelineExecutableInfoKHR, executableIndex ), sizeof( uint32_t ) );
	swigStructField( "VkPipelineExecutableInfoKHR-sType", offsetof( struct VkPipelineExecutableInfoKHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineExecutableInfoKHR ) );

	swigComment("union VkPipelineExecutableStatisticValueKHR\n");
	printf( "begin-structure VkPipelineExecutableStatisticValueKHR\n" );
	swigStructField( "VkPipelineExecutableStatisticValueKHR-b32", offsetof( union VkPipelineExecutableStatisticValueKHR, b32 ), sizeof( VkBool32 ) );
	swigStructField( "VkPipelineExecutableStatisticValueKHR-i64", offsetof( union VkPipelineExecutableStatisticValueKHR, i64 ), sizeof( int64_t ) );
	swigStructField( "VkPipelineExecutableStatisticValueKHR-f64", offsetof( union VkPipelineExecutableStatisticValueKHR, f64 ), sizeof( double ) );
	swigStructField( "VkPipelineExecutableStatisticValueKHR-u64", offsetof( union VkPipelineExecutableStatisticValueKHR, u64 ), sizeof( uint64_t ) );
	printf( "drop %zu end-structure\n", sizeof( union VkPipelineExecutableStatisticValueKHR ) );

	swigComment("struct VkPipelineExecutableStatisticKHR\n");
	printf( "begin-structure VkPipelineExecutableStatisticKHR\n" );
	swigStructField( "VkPipelineExecutableStatisticKHR-pNext", offsetof( struct VkPipelineExecutableStatisticKHR, pNext ), sizeof( void * ) );
	swigStructField( "VkPipelineExecutableStatisticKHR-name", offsetof( struct VkPipelineExecutableStatisticKHR, name ), sizeof( char [256U] ) );
	swigStructField( "VkPipelineExecutableStatisticKHR-description", offsetof( struct VkPipelineExecutableStatisticKHR, description ), sizeof( char [256U] ) );
	swigStructField( "VkPipelineExecutableStatisticKHR-value", offsetof( struct VkPipelineExecutableStatisticKHR, value ), sizeof( VkPipelineExecutableStatisticValueKHR ) );
	swigStructField( "VkPipelineExecutableStatisticKHR-sType", offsetof( struct VkPipelineExecutableStatisticKHR, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPipelineExecutableStatisticKHR-format", offsetof( struct VkPipelineExecutableStatisticKHR, format ), sizeof( VkPipelineExecutableStatisticFormatKHR ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineExecutableStatisticKHR ) );

	swigComment("struct VkPipelineExecutableInternalRepresentationKHR\n");
	printf( "begin-structure VkPipelineExecutableInternalRepresentationKHR\n" );
	swigStructField( "VkPipelineExecutableInternalRepresentationKHR-pNext", offsetof( struct VkPipelineExecutableInternalRepresentationKHR, pNext ), sizeof( void * ) );
	swigStructField( "VkPipelineExecutableInternalRepresentationKHR-name", offsetof( struct VkPipelineExecutableInternalRepresentationKHR, name ), sizeof( char [256U] ) );
	swigStructField( "VkPipelineExecutableInternalRepresentationKHR-dataSize", offsetof( struct VkPipelineExecutableInternalRepresentationKHR, dataSize ), sizeof( size_t ) );
	swigStructField( "VkPipelineExecutableInternalRepresentationKHR-description", offsetof( struct VkPipelineExecutableInternalRepresentationKHR, description ), sizeof( char [256U] ) );
	swigStructField( "VkPipelineExecutableInternalRepresentationKHR-isText", offsetof( struct VkPipelineExecutableInternalRepresentationKHR, isText ), sizeof( VkBool32 ) );
	swigStructField( "VkPipelineExecutableInternalRepresentationKHR-pData", offsetof( struct VkPipelineExecutableInternalRepresentationKHR, pData ), sizeof( void * ) );
	swigStructField( "VkPipelineExecutableInternalRepresentationKHR-sType", offsetof( struct VkPipelineExecutableInternalRepresentationKHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineExecutableInternalRepresentationKHR ) );

	swigComment("struct VkPhysicalDeviceShaderIntegerDotProductFeaturesKHR\n");
	printf( "begin-structure VkPhysicalDeviceShaderIntegerDotProductFeaturesKHR\n" );
	swigStructField( "VkPhysicalDeviceShaderIntegerDotProductFeaturesKHR-pNext", offsetof( struct VkPhysicalDeviceShaderIntegerDotProductFeaturesKHR, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceShaderIntegerDotProductFeaturesKHR-shaderIntegerDotProduct", offsetof( struct VkPhysicalDeviceShaderIntegerDotProductFeaturesKHR, shaderIntegerDotProduct ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderIntegerDotProductFeaturesKHR-sType", offsetof( struct VkPhysicalDeviceShaderIntegerDotProductFeaturesKHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceShaderIntegerDotProductFeaturesKHR ) );

	swigComment("struct VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR\n");
	printf( "begin-structure VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR\n" );
	swigStructField( "VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR-integerDotProductAccumulatingSaturating8BitSignedAccelerated", offsetof( struct VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR, integerDotProductAccumulatingSaturating8BitSignedAccelerated ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR-pNext", offsetof( struct VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR-integerDotProduct32BitMixedSignednessAccelerated", offsetof( struct VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR, integerDotProduct32BitMixedSignednessAccelerated ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR-integerDotProduct32BitSignedAccelerated", offsetof( struct VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR, integerDotProduct32BitSignedAccelerated ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR-integerDotProduct32BitUnsignedAccelerated", offsetof( struct VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR, integerDotProduct32BitUnsignedAccelerated ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR-integerDotProduct16BitMixedSignednessAccelerated", offsetof( struct VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR, integerDotProduct16BitMixedSignednessAccelerated ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR-integerDotProduct16BitSignedAccelerated", offsetof( struct VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR, integerDotProduct16BitSignedAccelerated ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR-integerDotProduct16BitUnsignedAccelerated", offsetof( struct VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR, integerDotProduct16BitUnsignedAccelerated ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR-integerDotProduct4x8BitPackedSignedAccelerated", offsetof( struct VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR, integerDotProduct4x8BitPackedSignedAccelerated ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR-integerDotProduct4x8BitPackedUnsignedAccelerated", offsetof( struct VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR, integerDotProduct4x8BitPackedUnsignedAccelerated ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR-integerDotProduct8BitMixedSignednessAccelerated", offsetof( struct VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR, integerDotProduct8BitMixedSignednessAccelerated ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR-integerDotProduct8BitSignedAccelerated", offsetof( struct VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR, integerDotProduct8BitSignedAccelerated ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR-integerDotProduct8BitUnsignedAccelerated", offsetof( struct VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR, integerDotProduct8BitUnsignedAccelerated ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR-integerDotProduct64BitUnsignedAccelerated", offsetof( struct VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR, integerDotProduct64BitUnsignedAccelerated ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR-integerDotProduct64BitSignedAccelerated", offsetof( struct VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR, integerDotProduct64BitSignedAccelerated ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR-integerDotProduct64BitMixedSignednessAccelerated", offsetof( struct VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR, integerDotProduct64BitMixedSignednessAccelerated ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR-integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated", offsetof( struct VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR, integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR-integerDotProduct4x8BitPackedMixedSignednessAccelerated", offsetof( struct VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR, integerDotProduct4x8BitPackedMixedSignednessAccelerated ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR-integerDotProductAccumulatingSaturating16BitSignedAccelerated", offsetof( struct VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR, integerDotProductAccumulatingSaturating16BitSignedAccelerated ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR-integerDotProductAccumulatingSaturating32BitSignedAccelerated", offsetof( struct VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR, integerDotProductAccumulatingSaturating32BitSignedAccelerated ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR-integerDotProductAccumulatingSaturating64BitSignedAccelerated", offsetof( struct VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR, integerDotProductAccumulatingSaturating64BitSignedAccelerated ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR-integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated", offsetof( struct VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR, integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR-integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated", offsetof( struct VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR, integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR-integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated", offsetof( struct VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR, integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR-integerDotProductAccumulatingSaturating8BitUnsignedAccelerated", offsetof( struct VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR, integerDotProductAccumulatingSaturating8BitUnsignedAccelerated ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR-integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated", offsetof( struct VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR, integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR-integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated", offsetof( struct VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR, integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR-integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated", offsetof( struct VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR, integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR-sType", offsetof( struct VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR-integerDotProductAccumulatingSaturating16BitUnsignedAccelerated", offsetof( struct VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR, integerDotProductAccumulatingSaturating16BitUnsignedAccelerated ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR-integerDotProductAccumulatingSaturating32BitUnsignedAccelerated", offsetof( struct VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR, integerDotProductAccumulatingSaturating32BitUnsignedAccelerated ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR-integerDotProductAccumulatingSaturating64BitUnsignedAccelerated", offsetof( struct VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR, integerDotProductAccumulatingSaturating64BitUnsignedAccelerated ), sizeof( VkBool32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR ) );

	swigComment("struct VkPipelineLibraryCreateInfoKHR\n");
	printf( "begin-structure VkPipelineLibraryCreateInfoKHR\n" );
	swigStructField( "VkPipelineLibraryCreateInfoKHR-pNext", offsetof( struct VkPipelineLibraryCreateInfoKHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkPipelineLibraryCreateInfoKHR-pLibraries", offsetof( struct VkPipelineLibraryCreateInfoKHR, pLibraries ), sizeof( VkPipeline const * ) );
	swigStructField( "VkPipelineLibraryCreateInfoKHR-libraryCount", offsetof( struct VkPipelineLibraryCreateInfoKHR, libraryCount ), sizeof( uint32_t ) );
	swigStructField( "VkPipelineLibraryCreateInfoKHR-sType", offsetof( struct VkPipelineLibraryCreateInfoKHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineLibraryCreateInfoKHR ) );

	swigComment("struct VkPresentIdKHR\n");
	printf( "begin-structure VkPresentIdKHR\n" );
	swigStructField( "VkPresentIdKHR-swapchainCount", offsetof( struct VkPresentIdKHR, swapchainCount ), sizeof( uint32_t ) );
	swigStructField( "VkPresentIdKHR-pNext", offsetof( struct VkPresentIdKHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkPresentIdKHR-pPresentIds", offsetof( struct VkPresentIdKHR, pPresentIds ), sizeof( uint64_t const * ) );
	swigStructField( "VkPresentIdKHR-sType", offsetof( struct VkPresentIdKHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPresentIdKHR ) );

	swigComment("struct VkPhysicalDevicePresentIdFeaturesKHR\n");
	printf( "begin-structure VkPhysicalDevicePresentIdFeaturesKHR\n" );
	swigStructField( "VkPhysicalDevicePresentIdFeaturesKHR-presentId", offsetof( struct VkPhysicalDevicePresentIdFeaturesKHR, presentId ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDevicePresentIdFeaturesKHR-pNext", offsetof( struct VkPhysicalDevicePresentIdFeaturesKHR, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDevicePresentIdFeaturesKHR-sType", offsetof( struct VkPhysicalDevicePresentIdFeaturesKHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDevicePresentIdFeaturesKHR ) );

	swigComment("struct VkMemoryBarrier2KHR\n");
	printf( "begin-structure VkMemoryBarrier2KHR\n" );
	swigStructField( "VkMemoryBarrier2KHR-pNext", offsetof( struct VkMemoryBarrier2KHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkMemoryBarrier2KHR-srcStageMask", offsetof( struct VkMemoryBarrier2KHR, srcStageMask ), sizeof( VkPipelineStageFlags2KHR ) );
	swigStructField( "VkMemoryBarrier2KHR-dstStageMask", offsetof( struct VkMemoryBarrier2KHR, dstStageMask ), sizeof( VkPipelineStageFlags2KHR ) );
	swigStructField( "VkMemoryBarrier2KHR-sType", offsetof( struct VkMemoryBarrier2KHR, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkMemoryBarrier2KHR-srcAccessMask", offsetof( struct VkMemoryBarrier2KHR, srcAccessMask ), sizeof( VkAccessFlags2KHR ) );
	swigStructField( "VkMemoryBarrier2KHR-dstAccessMask", offsetof( struct VkMemoryBarrier2KHR, dstAccessMask ), sizeof( VkAccessFlags2KHR ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkMemoryBarrier2KHR ) );

	swigComment("struct VkBufferMemoryBarrier2KHR\n");
	printf( "begin-structure VkBufferMemoryBarrier2KHR\n" );
	swigStructField( "VkBufferMemoryBarrier2KHR-pNext", offsetof( struct VkBufferMemoryBarrier2KHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkBufferMemoryBarrier2KHR-srcQueueFamilyIndex", offsetof( struct VkBufferMemoryBarrier2KHR, srcQueueFamilyIndex ), sizeof( uint32_t ) );
	swigStructField( "VkBufferMemoryBarrier2KHR-dstQueueFamilyIndex", offsetof( struct VkBufferMemoryBarrier2KHR, dstQueueFamilyIndex ), sizeof( uint32_t ) );
	swigStructField( "VkBufferMemoryBarrier2KHR-buffer", offsetof( struct VkBufferMemoryBarrier2KHR, buffer ), sizeof( VkBuffer ) );
	swigStructField( "VkBufferMemoryBarrier2KHR-srcStageMask", offsetof( struct VkBufferMemoryBarrier2KHR, srcStageMask ), sizeof( VkPipelineStageFlags2KHR ) );
	swigStructField( "VkBufferMemoryBarrier2KHR-dstStageMask", offsetof( struct VkBufferMemoryBarrier2KHR, dstStageMask ), sizeof( VkPipelineStageFlags2KHR ) );
	swigStructField( "VkBufferMemoryBarrier2KHR-offset", offsetof( struct VkBufferMemoryBarrier2KHR, offset ), sizeof( VkDeviceSize ) );
	swigStructField( "VkBufferMemoryBarrier2KHR-size", offsetof( struct VkBufferMemoryBarrier2KHR, size ), sizeof( VkDeviceSize ) );
	swigStructField( "VkBufferMemoryBarrier2KHR-sType", offsetof( struct VkBufferMemoryBarrier2KHR, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkBufferMemoryBarrier2KHR-srcAccessMask", offsetof( struct VkBufferMemoryBarrier2KHR, srcAccessMask ), sizeof( VkAccessFlags2KHR ) );
	swigStructField( "VkBufferMemoryBarrier2KHR-dstAccessMask", offsetof( struct VkBufferMemoryBarrier2KHR, dstAccessMask ), sizeof( VkAccessFlags2KHR ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkBufferMemoryBarrier2KHR ) );

	swigComment("struct VkImageMemoryBarrier2KHR\n");
	printf( "begin-structure VkImageMemoryBarrier2KHR\n" );
	swigStructField( "VkImageMemoryBarrier2KHR-pNext", offsetof( struct VkImageMemoryBarrier2KHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkImageMemoryBarrier2KHR-srcQueueFamilyIndex", offsetof( struct VkImageMemoryBarrier2KHR, srcQueueFamilyIndex ), sizeof( uint32_t ) );
	swigStructField( "VkImageMemoryBarrier2KHR-dstQueueFamilyIndex", offsetof( struct VkImageMemoryBarrier2KHR, dstQueueFamilyIndex ), sizeof( uint32_t ) );
	swigStructField( "VkImageMemoryBarrier2KHR-oldLayout", offsetof( struct VkImageMemoryBarrier2KHR, oldLayout ), sizeof( VkImageLayout ) );
	swigStructField( "VkImageMemoryBarrier2KHR-srcStageMask", offsetof( struct VkImageMemoryBarrier2KHR, srcStageMask ), sizeof( VkPipelineStageFlags2KHR ) );
	swigStructField( "VkImageMemoryBarrier2KHR-dstStageMask", offsetof( struct VkImageMemoryBarrier2KHR, dstStageMask ), sizeof( VkPipelineStageFlags2KHR ) );
	swigStructField( "VkImageMemoryBarrier2KHR-newLayout", offsetof( struct VkImageMemoryBarrier2KHR, newLayout ), sizeof( VkImageLayout ) );
	swigStructField( "VkImageMemoryBarrier2KHR-image", offsetof( struct VkImageMemoryBarrier2KHR, image ), sizeof( VkImage ) );
	swigStructField( "VkImageMemoryBarrier2KHR-sType", offsetof( struct VkImageMemoryBarrier2KHR, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkImageMemoryBarrier2KHR-srcAccessMask", offsetof( struct VkImageMemoryBarrier2KHR, srcAccessMask ), sizeof( VkAccessFlags2KHR ) );
	swigStructField( "VkImageMemoryBarrier2KHR-dstAccessMask", offsetof( struct VkImageMemoryBarrier2KHR, dstAccessMask ), sizeof( VkAccessFlags2KHR ) );
	swigStructField( "VkImageMemoryBarrier2KHR-subresourceRange", offsetof( struct VkImageMemoryBarrier2KHR, subresourceRange ), sizeof( VkImageSubresourceRange ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkImageMemoryBarrier2KHR ) );

	swigComment("struct VkDependencyInfoKHR\n");
	printf( "begin-structure VkDependencyInfoKHR\n" );
	swigStructField( "VkDependencyInfoKHR-pNext", offsetof( struct VkDependencyInfoKHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkDependencyInfoKHR-memoryBarrierCount", offsetof( struct VkDependencyInfoKHR, memoryBarrierCount ), sizeof( uint32_t ) );
	swigStructField( "VkDependencyInfoKHR-bufferMemoryBarrierCount", offsetof( struct VkDependencyInfoKHR, bufferMemoryBarrierCount ), sizeof( uint32_t ) );
	swigStructField( "VkDependencyInfoKHR-imageMemoryBarrierCount", offsetof( struct VkDependencyInfoKHR, imageMemoryBarrierCount ), sizeof( uint32_t ) );
	swigStructField( "VkDependencyInfoKHR-dependencyFlags", offsetof( struct VkDependencyInfoKHR, dependencyFlags ), sizeof( VkDependencyFlags ) );
	swigStructField( "VkDependencyInfoKHR-sType", offsetof( struct VkDependencyInfoKHR, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkDependencyInfoKHR-pMemoryBarriers", offsetof( struct VkDependencyInfoKHR, pMemoryBarriers ), sizeof( VkMemoryBarrier2KHR const * ) );
	swigStructField( "VkDependencyInfoKHR-pBufferMemoryBarriers", offsetof( struct VkDependencyInfoKHR, pBufferMemoryBarriers ), sizeof( VkBufferMemoryBarrier2KHR const * ) );
	swigStructField( "VkDependencyInfoKHR-pImageMemoryBarriers", offsetof( struct VkDependencyInfoKHR, pImageMemoryBarriers ), sizeof( VkImageMemoryBarrier2KHR const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDependencyInfoKHR ) );

	swigComment("struct VkSemaphoreSubmitInfoKHR\n");
	printf( "begin-structure VkSemaphoreSubmitInfoKHR\n" );
	swigStructField( "VkSemaphoreSubmitInfoKHR-pNext", offsetof( struct VkSemaphoreSubmitInfoKHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkSemaphoreSubmitInfoKHR-deviceIndex", offsetof( struct VkSemaphoreSubmitInfoKHR, deviceIndex ), sizeof( uint32_t ) );
	swigStructField( "VkSemaphoreSubmitInfoKHR-semaphore", offsetof( struct VkSemaphoreSubmitInfoKHR, semaphore ), sizeof( VkSemaphore ) );
	swigStructField( "VkSemaphoreSubmitInfoKHR-value", offsetof( struct VkSemaphoreSubmitInfoKHR, value ), sizeof( uint64_t ) );
	swigStructField( "VkSemaphoreSubmitInfoKHR-stageMask", offsetof( struct VkSemaphoreSubmitInfoKHR, stageMask ), sizeof( VkPipelineStageFlags2KHR ) );
	swigStructField( "VkSemaphoreSubmitInfoKHR-sType", offsetof( struct VkSemaphoreSubmitInfoKHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSemaphoreSubmitInfoKHR ) );

	swigComment("struct VkCommandBufferSubmitInfoKHR\n");
	printf( "begin-structure VkCommandBufferSubmitInfoKHR\n" );
	swigStructField( "VkCommandBufferSubmitInfoKHR-pNext", offsetof( struct VkCommandBufferSubmitInfoKHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkCommandBufferSubmitInfoKHR-commandBuffer", offsetof( struct VkCommandBufferSubmitInfoKHR, commandBuffer ), sizeof( VkCommandBuffer ) );
	swigStructField( "VkCommandBufferSubmitInfoKHR-deviceMask", offsetof( struct VkCommandBufferSubmitInfoKHR, deviceMask ), sizeof( uint32_t ) );
	swigStructField( "VkCommandBufferSubmitInfoKHR-sType", offsetof( struct VkCommandBufferSubmitInfoKHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkCommandBufferSubmitInfoKHR ) );

	swigComment("struct VkSubmitInfo2KHR\n");
	printf( "begin-structure VkSubmitInfo2KHR\n" );
	swigStructField( "VkSubmitInfo2KHR-pWaitSemaphoreInfos", offsetof( struct VkSubmitInfo2KHR, pWaitSemaphoreInfos ), sizeof( VkSemaphoreSubmitInfoKHR const * ) );
	swigStructField( "VkSubmitInfo2KHR-pSignalSemaphoreInfos", offsetof( struct VkSubmitInfo2KHR, pSignalSemaphoreInfos ), sizeof( VkSemaphoreSubmitInfoKHR const * ) );
	swigStructField( "VkSubmitInfo2KHR-pNext", offsetof( struct VkSubmitInfo2KHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkSubmitInfo2KHR-waitSemaphoreInfoCount", offsetof( struct VkSubmitInfo2KHR, waitSemaphoreInfoCount ), sizeof( uint32_t ) );
	swigStructField( "VkSubmitInfo2KHR-commandBufferInfoCount", offsetof( struct VkSubmitInfo2KHR, commandBufferInfoCount ), sizeof( uint32_t ) );
	swigStructField( "VkSubmitInfo2KHR-signalSemaphoreInfoCount", offsetof( struct VkSubmitInfo2KHR, signalSemaphoreInfoCount ), sizeof( uint32_t ) );
	swigStructField( "VkSubmitInfo2KHR-pCommandBufferInfos", offsetof( struct VkSubmitInfo2KHR, pCommandBufferInfos ), sizeof( VkCommandBufferSubmitInfoKHR const * ) );
	swigStructField( "VkSubmitInfo2KHR-sType", offsetof( struct VkSubmitInfo2KHR, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkSubmitInfo2KHR-flags", offsetof( struct VkSubmitInfo2KHR, flags ), sizeof( VkSubmitFlagsKHR ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSubmitInfo2KHR ) );

	swigComment("struct VkPhysicalDeviceSynchronization2FeaturesKHR\n");
	printf( "begin-structure VkPhysicalDeviceSynchronization2FeaturesKHR\n" );
	swigStructField( "VkPhysicalDeviceSynchronization2FeaturesKHR-pNext", offsetof( struct VkPhysicalDeviceSynchronization2FeaturesKHR, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceSynchronization2FeaturesKHR-synchronization2", offsetof( struct VkPhysicalDeviceSynchronization2FeaturesKHR, synchronization2 ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceSynchronization2FeaturesKHR-sType", offsetof( struct VkPhysicalDeviceSynchronization2FeaturesKHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceSynchronization2FeaturesKHR ) );

	swigComment("struct VkQueueFamilyCheckpointProperties2NV\n");
	printf( "begin-structure VkQueueFamilyCheckpointProperties2NV\n" );
	swigStructField( "VkQueueFamilyCheckpointProperties2NV-pNext", offsetof( struct VkQueueFamilyCheckpointProperties2NV, pNext ), sizeof( void * ) );
	swigStructField( "VkQueueFamilyCheckpointProperties2NV-checkpointExecutionStageMask", offsetof( struct VkQueueFamilyCheckpointProperties2NV, checkpointExecutionStageMask ), sizeof( VkPipelineStageFlags2KHR ) );
	swigStructField( "VkQueueFamilyCheckpointProperties2NV-sType", offsetof( struct VkQueueFamilyCheckpointProperties2NV, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkQueueFamilyCheckpointProperties2NV ) );

	swigComment("struct VkCheckpointData2NV\n");
	printf( "begin-structure VkCheckpointData2NV\n" );
	swigStructField( "VkCheckpointData2NV-pCheckpointMarker", offsetof( struct VkCheckpointData2NV, pCheckpointMarker ), sizeof( void * ) );
	swigStructField( "VkCheckpointData2NV-pNext", offsetof( struct VkCheckpointData2NV, pNext ), sizeof( void * ) );
	swigStructField( "VkCheckpointData2NV-stage", offsetof( struct VkCheckpointData2NV, stage ), sizeof( VkPipelineStageFlags2KHR ) );
	swigStructField( "VkCheckpointData2NV-sType", offsetof( struct VkCheckpointData2NV, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkCheckpointData2NV ) );

	swigComment("struct VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR\n");
	printf( "begin-structure VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR\n" );
	swigStructField( "VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR-pNext", offsetof( struct VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR-shaderSubgroupUniformControlFlow", offsetof( struct VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR, shaderSubgroupUniformControlFlow ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR-sType", offsetof( struct VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR ) );

	swigComment("struct VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKHR\n");
	printf( "begin-structure VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKHR\n" );
	swigStructField( "VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKHR-pNext", offsetof( struct VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKHR, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKHR-shaderZeroInitializeWorkgroupMemory", offsetof( struct VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKHR, shaderZeroInitializeWorkgroupMemory ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKHR-sType", offsetof( struct VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKHR ) );

	swigComment("struct VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR\n");
	printf( "begin-structure VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR\n" );
	swigStructField( "VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR-workgroupMemoryExplicitLayout8BitAccess", offsetof( struct VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR, workgroupMemoryExplicitLayout8BitAccess ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR-workgroupMemoryExplicitLayout16BitAccess", offsetof( struct VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR, workgroupMemoryExplicitLayout16BitAccess ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR-pNext", offsetof( struct VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR-workgroupMemoryExplicitLayout", offsetof( struct VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR, workgroupMemoryExplicitLayout ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR-workgroupMemoryExplicitLayoutScalarBlockLayout", offsetof( struct VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR, workgroupMemoryExplicitLayoutScalarBlockLayout ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR-sType", offsetof( struct VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR ) );

	swigComment("struct VkBufferCopy2KHR\n");
	printf( "begin-structure VkBufferCopy2KHR\n" );
	swigStructField( "VkBufferCopy2KHR-pNext", offsetof( struct VkBufferCopy2KHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkBufferCopy2KHR-dstOffset", offsetof( struct VkBufferCopy2KHR, dstOffset ), sizeof( VkDeviceSize ) );
	swigStructField( "VkBufferCopy2KHR-srcOffset", offsetof( struct VkBufferCopy2KHR, srcOffset ), sizeof( VkDeviceSize ) );
	swigStructField( "VkBufferCopy2KHR-size", offsetof( struct VkBufferCopy2KHR, size ), sizeof( VkDeviceSize ) );
	swigStructField( "VkBufferCopy2KHR-sType", offsetof( struct VkBufferCopy2KHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkBufferCopy2KHR ) );

	swigComment("struct VkCopyBufferInfo2KHR\n");
	printf( "begin-structure VkCopyBufferInfo2KHR\n" );
	swigStructField( "VkCopyBufferInfo2KHR-regionCount", offsetof( struct VkCopyBufferInfo2KHR, regionCount ), sizeof( uint32_t ) );
	swigStructField( "VkCopyBufferInfo2KHR-pNext", offsetof( struct VkCopyBufferInfo2KHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkCopyBufferInfo2KHR-dstBuffer", offsetof( struct VkCopyBufferInfo2KHR, dstBuffer ), sizeof( VkBuffer ) );
	swigStructField( "VkCopyBufferInfo2KHR-srcBuffer", offsetof( struct VkCopyBufferInfo2KHR, srcBuffer ), sizeof( VkBuffer ) );
	swigStructField( "VkCopyBufferInfo2KHR-pRegions", offsetof( struct VkCopyBufferInfo2KHR, pRegions ), sizeof( VkBufferCopy2KHR const * ) );
	swigStructField( "VkCopyBufferInfo2KHR-sType", offsetof( struct VkCopyBufferInfo2KHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkCopyBufferInfo2KHR ) );

	swigComment("struct VkImageCopy2KHR\n");
	printf( "begin-structure VkImageCopy2KHR\n" );
	swigStructField( "VkImageCopy2KHR-extent", offsetof( struct VkImageCopy2KHR, extent ), sizeof( VkExtent3D ) );
	swigStructField( "VkImageCopy2KHR-pNext", offsetof( struct VkImageCopy2KHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkImageCopy2KHR-srcSubresource", offsetof( struct VkImageCopy2KHR, srcSubresource ), sizeof( VkImageSubresourceLayers ) );
	swigStructField( "VkImageCopy2KHR-dstSubresource", offsetof( struct VkImageCopy2KHR, dstSubresource ), sizeof( VkImageSubresourceLayers ) );
	swigStructField( "VkImageCopy2KHR-dstOffset", offsetof( struct VkImageCopy2KHR, dstOffset ), sizeof( VkOffset3D ) );
	swigStructField( "VkImageCopy2KHR-srcOffset", offsetof( struct VkImageCopy2KHR, srcOffset ), sizeof( VkOffset3D ) );
	swigStructField( "VkImageCopy2KHR-sType", offsetof( struct VkImageCopy2KHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkImageCopy2KHR ) );

	swigComment("struct VkCopyImageInfo2KHR\n");
	printf( "begin-structure VkCopyImageInfo2KHR\n" );
	swigStructField( "VkCopyImageInfo2KHR-dstImage", offsetof( struct VkCopyImageInfo2KHR, dstImage ), sizeof( VkImage ) );
	swigStructField( "VkCopyImageInfo2KHR-regionCount", offsetof( struct VkCopyImageInfo2KHR, regionCount ), sizeof( uint32_t ) );
	swigStructField( "VkCopyImageInfo2KHR-pNext", offsetof( struct VkCopyImageInfo2KHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkCopyImageInfo2KHR-srcImage", offsetof( struct VkCopyImageInfo2KHR, srcImage ), sizeof( VkImage ) );
	swigStructField( "VkCopyImageInfo2KHR-srcImageLayout", offsetof( struct VkCopyImageInfo2KHR, srcImageLayout ), sizeof( VkImageLayout ) );
	swigStructField( "VkCopyImageInfo2KHR-dstImageLayout", offsetof( struct VkCopyImageInfo2KHR, dstImageLayout ), sizeof( VkImageLayout ) );
	swigStructField( "VkCopyImageInfo2KHR-pRegions", offsetof( struct VkCopyImageInfo2KHR, pRegions ), sizeof( VkImageCopy2KHR const * ) );
	swigStructField( "VkCopyImageInfo2KHR-sType", offsetof( struct VkCopyImageInfo2KHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkCopyImageInfo2KHR ) );

	swigComment("struct VkBufferImageCopy2KHR\n");
	printf( "begin-structure VkBufferImageCopy2KHR\n" );
	swigStructField( "VkBufferImageCopy2KHR-imageExtent", offsetof( struct VkBufferImageCopy2KHR, imageExtent ), sizeof( VkExtent3D ) );
	swigStructField( "VkBufferImageCopy2KHR-pNext", offsetof( struct VkBufferImageCopy2KHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkBufferImageCopy2KHR-imageSubresource", offsetof( struct VkBufferImageCopy2KHR, imageSubresource ), sizeof( VkImageSubresourceLayers ) );
	swigStructField( "VkBufferImageCopy2KHR-bufferOffset", offsetof( struct VkBufferImageCopy2KHR, bufferOffset ), sizeof( VkDeviceSize ) );
	swigStructField( "VkBufferImageCopy2KHR-imageOffset", offsetof( struct VkBufferImageCopy2KHR, imageOffset ), sizeof( VkOffset3D ) );
	swigStructField( "VkBufferImageCopy2KHR-bufferRowLength", offsetof( struct VkBufferImageCopy2KHR, bufferRowLength ), sizeof( uint32_t ) );
	swigStructField( "VkBufferImageCopy2KHR-bufferImageHeight", offsetof( struct VkBufferImageCopy2KHR, bufferImageHeight ), sizeof( uint32_t ) );
	swigStructField( "VkBufferImageCopy2KHR-sType", offsetof( struct VkBufferImageCopy2KHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkBufferImageCopy2KHR ) );

	swigComment("struct VkCopyBufferToImageInfo2KHR\n");
	printf( "begin-structure VkCopyBufferToImageInfo2KHR\n" );
	swigStructField( "VkCopyBufferToImageInfo2KHR-dstImage", offsetof( struct VkCopyBufferToImageInfo2KHR, dstImage ), sizeof( VkImage ) );
	swigStructField( "VkCopyBufferToImageInfo2KHR-regionCount", offsetof( struct VkCopyBufferToImageInfo2KHR, regionCount ), sizeof( uint32_t ) );
	swigStructField( "VkCopyBufferToImageInfo2KHR-pNext", offsetof( struct VkCopyBufferToImageInfo2KHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkCopyBufferToImageInfo2KHR-srcBuffer", offsetof( struct VkCopyBufferToImageInfo2KHR, srcBuffer ), sizeof( VkBuffer ) );
	swigStructField( "VkCopyBufferToImageInfo2KHR-dstImageLayout", offsetof( struct VkCopyBufferToImageInfo2KHR, dstImageLayout ), sizeof( VkImageLayout ) );
	swigStructField( "VkCopyBufferToImageInfo2KHR-pRegions", offsetof( struct VkCopyBufferToImageInfo2KHR, pRegions ), sizeof( VkBufferImageCopy2KHR const * ) );
	swigStructField( "VkCopyBufferToImageInfo2KHR-sType", offsetof( struct VkCopyBufferToImageInfo2KHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkCopyBufferToImageInfo2KHR ) );

	swigComment("struct VkCopyImageToBufferInfo2KHR\n");
	printf( "begin-structure VkCopyImageToBufferInfo2KHR\n" );
	swigStructField( "VkCopyImageToBufferInfo2KHR-regionCount", offsetof( struct VkCopyImageToBufferInfo2KHR, regionCount ), sizeof( uint32_t ) );
	swigStructField( "VkCopyImageToBufferInfo2KHR-pNext", offsetof( struct VkCopyImageToBufferInfo2KHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkCopyImageToBufferInfo2KHR-dstBuffer", offsetof( struct VkCopyImageToBufferInfo2KHR, dstBuffer ), sizeof( VkBuffer ) );
	swigStructField( "VkCopyImageToBufferInfo2KHR-srcImage", offsetof( struct VkCopyImageToBufferInfo2KHR, srcImage ), sizeof( VkImage ) );
	swigStructField( "VkCopyImageToBufferInfo2KHR-srcImageLayout", offsetof( struct VkCopyImageToBufferInfo2KHR, srcImageLayout ), sizeof( VkImageLayout ) );
	swigStructField( "VkCopyImageToBufferInfo2KHR-pRegions", offsetof( struct VkCopyImageToBufferInfo2KHR, pRegions ), sizeof( VkBufferImageCopy2KHR const * ) );
	swigStructField( "VkCopyImageToBufferInfo2KHR-sType", offsetof( struct VkCopyImageToBufferInfo2KHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkCopyImageToBufferInfo2KHR ) );

	swigComment("struct VkImageBlit2KHR\n");
	printf( "begin-structure VkImageBlit2KHR\n" );
	swigStructField( "VkImageBlit2KHR-srcOffsets", offsetof( struct VkImageBlit2KHR, srcOffsets ), sizeof( VkOffset3D [2] ) );
	swigStructField( "VkImageBlit2KHR-dstOffsets", offsetof( struct VkImageBlit2KHR, dstOffsets ), sizeof( VkOffset3D [2] ) );
	swigStructField( "VkImageBlit2KHR-pNext", offsetof( struct VkImageBlit2KHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkImageBlit2KHR-srcSubresource", offsetof( struct VkImageBlit2KHR, srcSubresource ), sizeof( VkImageSubresourceLayers ) );
	swigStructField( "VkImageBlit2KHR-dstSubresource", offsetof( struct VkImageBlit2KHR, dstSubresource ), sizeof( VkImageSubresourceLayers ) );
	swigStructField( "VkImageBlit2KHR-sType", offsetof( struct VkImageBlit2KHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkImageBlit2KHR ) );

	swigComment("struct VkBlitImageInfo2KHR\n");
	printf( "begin-structure VkBlitImageInfo2KHR\n" );
	swigStructField( "VkBlitImageInfo2KHR-dstImage", offsetof( struct VkBlitImageInfo2KHR, dstImage ), sizeof( VkImage ) );
	swigStructField( "VkBlitImageInfo2KHR-regionCount", offsetof( struct VkBlitImageInfo2KHR, regionCount ), sizeof( uint32_t ) );
	swigStructField( "VkBlitImageInfo2KHR-pNext", offsetof( struct VkBlitImageInfo2KHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkBlitImageInfo2KHR-srcImage", offsetof( struct VkBlitImageInfo2KHR, srcImage ), sizeof( VkImage ) );
	swigStructField( "VkBlitImageInfo2KHR-srcImageLayout", offsetof( struct VkBlitImageInfo2KHR, srcImageLayout ), sizeof( VkImageLayout ) );
	swigStructField( "VkBlitImageInfo2KHR-dstImageLayout", offsetof( struct VkBlitImageInfo2KHR, dstImageLayout ), sizeof( VkImageLayout ) );
	swigStructField( "VkBlitImageInfo2KHR-pRegions", offsetof( struct VkBlitImageInfo2KHR, pRegions ), sizeof( VkImageBlit2KHR const * ) );
	swigStructField( "VkBlitImageInfo2KHR-filter", offsetof( struct VkBlitImageInfo2KHR, filter ), sizeof( VkFilter ) );
	swigStructField( "VkBlitImageInfo2KHR-sType", offsetof( struct VkBlitImageInfo2KHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkBlitImageInfo2KHR ) );

	swigComment("struct VkImageResolve2KHR\n");
	printf( "begin-structure VkImageResolve2KHR\n" );
	swigStructField( "VkImageResolve2KHR-extent", offsetof( struct VkImageResolve2KHR, extent ), sizeof( VkExtent3D ) );
	swigStructField( "VkImageResolve2KHR-pNext", offsetof( struct VkImageResolve2KHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkImageResolve2KHR-srcSubresource", offsetof( struct VkImageResolve2KHR, srcSubresource ), sizeof( VkImageSubresourceLayers ) );
	swigStructField( "VkImageResolve2KHR-dstSubresource", offsetof( struct VkImageResolve2KHR, dstSubresource ), sizeof( VkImageSubresourceLayers ) );
	swigStructField( "VkImageResolve2KHR-dstOffset", offsetof( struct VkImageResolve2KHR, dstOffset ), sizeof( VkOffset3D ) );
	swigStructField( "VkImageResolve2KHR-srcOffset", offsetof( struct VkImageResolve2KHR, srcOffset ), sizeof( VkOffset3D ) );
	swigStructField( "VkImageResolve2KHR-sType", offsetof( struct VkImageResolve2KHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkImageResolve2KHR ) );

	swigComment("struct VkResolveImageInfo2KHR\n");
	printf( "begin-structure VkResolveImageInfo2KHR\n" );
	swigStructField( "VkResolveImageInfo2KHR-dstImage", offsetof( struct VkResolveImageInfo2KHR, dstImage ), sizeof( VkImage ) );
	swigStructField( "VkResolveImageInfo2KHR-regionCount", offsetof( struct VkResolveImageInfo2KHR, regionCount ), sizeof( uint32_t ) );
	swigStructField( "VkResolveImageInfo2KHR-pNext", offsetof( struct VkResolveImageInfo2KHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkResolveImageInfo2KHR-srcImage", offsetof( struct VkResolveImageInfo2KHR, srcImage ), sizeof( VkImage ) );
	swigStructField( "VkResolveImageInfo2KHR-srcImageLayout", offsetof( struct VkResolveImageInfo2KHR, srcImageLayout ), sizeof( VkImageLayout ) );
	swigStructField( "VkResolveImageInfo2KHR-dstImageLayout", offsetof( struct VkResolveImageInfo2KHR, dstImageLayout ), sizeof( VkImageLayout ) );
	swigStructField( "VkResolveImageInfo2KHR-pRegions", offsetof( struct VkResolveImageInfo2KHR, pRegions ), sizeof( VkImageResolve2KHR const * ) );
	swigStructField( "VkResolveImageInfo2KHR-sType", offsetof( struct VkResolveImageInfo2KHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkResolveImageInfo2KHR ) );

	swigComment("struct VkFormatProperties3KHR\n");
	printf( "begin-structure VkFormatProperties3KHR\n" );
	swigStructField( "VkFormatProperties3KHR-linearTilingFeatures", offsetof( struct VkFormatProperties3KHR, linearTilingFeatures ), sizeof( VkFormatFeatureFlags2KHR ) );
	swigStructField( "VkFormatProperties3KHR-optimalTilingFeatures", offsetof( struct VkFormatProperties3KHR, optimalTilingFeatures ), sizeof( VkFormatFeatureFlags2KHR ) );
	swigStructField( "VkFormatProperties3KHR-bufferFeatures", offsetof( struct VkFormatProperties3KHR, bufferFeatures ), sizeof( VkFormatFeatureFlags2KHR ) );
	swigStructField( "VkFormatProperties3KHR-pNext", offsetof( struct VkFormatProperties3KHR, pNext ), sizeof( void * ) );
	swigStructField( "VkFormatProperties3KHR-sType", offsetof( struct VkFormatProperties3KHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkFormatProperties3KHR ) );

	swigComment("struct VkPhysicalDeviceMaintenance4FeaturesKHR\n");
	printf( "begin-structure VkPhysicalDeviceMaintenance4FeaturesKHR\n" );
	swigStructField( "VkPhysicalDeviceMaintenance4FeaturesKHR-pNext", offsetof( struct VkPhysicalDeviceMaintenance4FeaturesKHR, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceMaintenance4FeaturesKHR-maintenance4", offsetof( struct VkPhysicalDeviceMaintenance4FeaturesKHR, maintenance4 ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceMaintenance4FeaturesKHR-sType", offsetof( struct VkPhysicalDeviceMaintenance4FeaturesKHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceMaintenance4FeaturesKHR ) );

	swigComment("struct VkPhysicalDeviceMaintenance4PropertiesKHR\n");
	printf( "begin-structure VkPhysicalDeviceMaintenance4PropertiesKHR\n" );
	swigStructField( "VkPhysicalDeviceMaintenance4PropertiesKHR-pNext", offsetof( struct VkPhysicalDeviceMaintenance4PropertiesKHR, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceMaintenance4PropertiesKHR-sType", offsetof( struct VkPhysicalDeviceMaintenance4PropertiesKHR, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDeviceMaintenance4PropertiesKHR-maxBufferSize", offsetof( struct VkPhysicalDeviceMaintenance4PropertiesKHR, maxBufferSize ), sizeof( VkDeviceSize ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceMaintenance4PropertiesKHR ) );

	swigComment("struct VkDeviceBufferMemoryRequirementsKHR\n");
	printf( "begin-structure VkDeviceBufferMemoryRequirementsKHR\n" );
	swigStructField( "VkDeviceBufferMemoryRequirementsKHR-pNext", offsetof( struct VkDeviceBufferMemoryRequirementsKHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkDeviceBufferMemoryRequirementsKHR-pCreateInfo", offsetof( struct VkDeviceBufferMemoryRequirementsKHR, pCreateInfo ), sizeof( VkBufferCreateInfo const * ) );
	swigStructField( "VkDeviceBufferMemoryRequirementsKHR-sType", offsetof( struct VkDeviceBufferMemoryRequirementsKHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDeviceBufferMemoryRequirementsKHR ) );

	swigComment("struct VkDeviceImageMemoryRequirementsKHR\n");
	printf( "begin-structure VkDeviceImageMemoryRequirementsKHR\n" );
	swigStructField( "VkDeviceImageMemoryRequirementsKHR-pNext", offsetof( struct VkDeviceImageMemoryRequirementsKHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkDeviceImageMemoryRequirementsKHR-planeAspect", offsetof( struct VkDeviceImageMemoryRequirementsKHR, planeAspect ), sizeof( VkImageAspectFlagBits ) );
	swigStructField( "VkDeviceImageMemoryRequirementsKHR-pCreateInfo", offsetof( struct VkDeviceImageMemoryRequirementsKHR, pCreateInfo ), sizeof( VkImageCreateInfo const * ) );
	swigStructField( "VkDeviceImageMemoryRequirementsKHR-sType", offsetof( struct VkDeviceImageMemoryRequirementsKHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDeviceImageMemoryRequirementsKHR ) );

	swigComment("struct VkDebugReportCallbackCreateInfoEXT\n");
	printf( "begin-structure VkDebugReportCallbackCreateInfoEXT\n" );
	swigStructField( "VkDebugReportCallbackCreateInfoEXT-pNext", offsetof( struct VkDebugReportCallbackCreateInfoEXT, pNext ), sizeof( void const * ) );
	swigStructField( "VkDebugReportCallbackCreateInfoEXT-pUserData", offsetof( struct VkDebugReportCallbackCreateInfoEXT, pUserData ), sizeof( void * ) );
	swigStructField( "VkDebugReportCallbackCreateInfoEXT-sType", offsetof( struct VkDebugReportCallbackCreateInfoEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkDebugReportCallbackCreateInfoEXT-flags", offsetof( struct VkDebugReportCallbackCreateInfoEXT, flags ), sizeof( VkDebugReportFlagsEXT ) );
	swigStructField( "VkDebugReportCallbackCreateInfoEXT-pfnCallback", offsetof( struct VkDebugReportCallbackCreateInfoEXT, pfnCallback ), sizeof( PFN_vkDebugReportCallbackEXT ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDebugReportCallbackCreateInfoEXT ) );

	swigComment("struct VkPipelineRasterizationStateRasterizationOrderAMD\n");
	printf( "begin-structure VkPipelineRasterizationStateRasterizationOrderAMD\n" );
	swigStructField( "VkPipelineRasterizationStateRasterizationOrderAMD-rasterizationOrder", offsetof( struct VkPipelineRasterizationStateRasterizationOrderAMD, rasterizationOrder ), sizeof( VkRasterizationOrderAMD ) );
	swigStructField( "VkPipelineRasterizationStateRasterizationOrderAMD-pNext", offsetof( struct VkPipelineRasterizationStateRasterizationOrderAMD, pNext ), sizeof( void const * ) );
	swigStructField( "VkPipelineRasterizationStateRasterizationOrderAMD-sType", offsetof( struct VkPipelineRasterizationStateRasterizationOrderAMD, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineRasterizationStateRasterizationOrderAMD ) );

	swigComment("struct VkDebugMarkerObjectNameInfoEXT\n");
	printf( "begin-structure VkDebugMarkerObjectNameInfoEXT\n" );
	swigStructField( "VkDebugMarkerObjectNameInfoEXT-pNext", offsetof( struct VkDebugMarkerObjectNameInfoEXT, pNext ), sizeof( void const * ) );
	swigStructField( "VkDebugMarkerObjectNameInfoEXT-objectType", offsetof( struct VkDebugMarkerObjectNameInfoEXT, objectType ), sizeof( VkDebugReportObjectTypeEXT ) );
	swigStructField( "VkDebugMarkerObjectNameInfoEXT-object", offsetof( struct VkDebugMarkerObjectNameInfoEXT, object ), sizeof( uint64_t ) );
	swigStructField( "VkDebugMarkerObjectNameInfoEXT-sType", offsetof( struct VkDebugMarkerObjectNameInfoEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkDebugMarkerObjectNameInfoEXT-pObjectName", offsetof( struct VkDebugMarkerObjectNameInfoEXT, pObjectName ), sizeof( char const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDebugMarkerObjectNameInfoEXT ) );

	swigComment("struct VkDebugMarkerObjectTagInfoEXT\n");
	printf( "begin-structure VkDebugMarkerObjectTagInfoEXT\n" );
	swigStructField( "VkDebugMarkerObjectTagInfoEXT-pNext", offsetof( struct VkDebugMarkerObjectTagInfoEXT, pNext ), sizeof( void const * ) );
	swigStructField( "VkDebugMarkerObjectTagInfoEXT-objectType", offsetof( struct VkDebugMarkerObjectTagInfoEXT, objectType ), sizeof( VkDebugReportObjectTypeEXT ) );
	swigStructField( "VkDebugMarkerObjectTagInfoEXT-pTag", offsetof( struct VkDebugMarkerObjectTagInfoEXT, pTag ), sizeof( void const * ) );
	swigStructField( "VkDebugMarkerObjectTagInfoEXT-tagSize", offsetof( struct VkDebugMarkerObjectTagInfoEXT, tagSize ), sizeof( size_t ) );
	swigStructField( "VkDebugMarkerObjectTagInfoEXT-object", offsetof( struct VkDebugMarkerObjectTagInfoEXT, object ), sizeof( uint64_t ) );
	swigStructField( "VkDebugMarkerObjectTagInfoEXT-sType", offsetof( struct VkDebugMarkerObjectTagInfoEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkDebugMarkerObjectTagInfoEXT-tagName", offsetof( struct VkDebugMarkerObjectTagInfoEXT, tagName ), sizeof( uint64_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDebugMarkerObjectTagInfoEXT ) );

	swigComment("struct VkDebugMarkerMarkerInfoEXT\n");
	printf( "begin-structure VkDebugMarkerMarkerInfoEXT\n" );
	swigStructField( "VkDebugMarkerMarkerInfoEXT-color", offsetof( struct VkDebugMarkerMarkerInfoEXT, color ), sizeof( float [4] ) );
	swigStructField( "VkDebugMarkerMarkerInfoEXT-pNext", offsetof( struct VkDebugMarkerMarkerInfoEXT, pNext ), sizeof( void const * ) );
	swigStructField( "VkDebugMarkerMarkerInfoEXT-pMarkerName", offsetof( struct VkDebugMarkerMarkerInfoEXT, pMarkerName ), sizeof( char const * ) );
	swigStructField( "VkDebugMarkerMarkerInfoEXT-sType", offsetof( struct VkDebugMarkerMarkerInfoEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDebugMarkerMarkerInfoEXT ) );

	swigComment("struct VkDedicatedAllocationImageCreateInfoNV\n");
	printf( "begin-structure VkDedicatedAllocationImageCreateInfoNV\n" );
	swigStructField( "VkDedicatedAllocationImageCreateInfoNV-dedicatedAllocation", offsetof( struct VkDedicatedAllocationImageCreateInfoNV, dedicatedAllocation ), sizeof( VkBool32 ) );
	swigStructField( "VkDedicatedAllocationImageCreateInfoNV-pNext", offsetof( struct VkDedicatedAllocationImageCreateInfoNV, pNext ), sizeof( void const * ) );
	swigStructField( "VkDedicatedAllocationImageCreateInfoNV-sType", offsetof( struct VkDedicatedAllocationImageCreateInfoNV, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDedicatedAllocationImageCreateInfoNV ) );

	swigComment("struct VkDedicatedAllocationBufferCreateInfoNV\n");
	printf( "begin-structure VkDedicatedAllocationBufferCreateInfoNV\n" );
	swigStructField( "VkDedicatedAllocationBufferCreateInfoNV-dedicatedAllocation", offsetof( struct VkDedicatedAllocationBufferCreateInfoNV, dedicatedAllocation ), sizeof( VkBool32 ) );
	swigStructField( "VkDedicatedAllocationBufferCreateInfoNV-pNext", offsetof( struct VkDedicatedAllocationBufferCreateInfoNV, pNext ), sizeof( void const * ) );
	swigStructField( "VkDedicatedAllocationBufferCreateInfoNV-sType", offsetof( struct VkDedicatedAllocationBufferCreateInfoNV, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDedicatedAllocationBufferCreateInfoNV ) );

	swigComment("struct VkDedicatedAllocationMemoryAllocateInfoNV\n");
	printf( "begin-structure VkDedicatedAllocationMemoryAllocateInfoNV\n" );
	swigStructField( "VkDedicatedAllocationMemoryAllocateInfoNV-pNext", offsetof( struct VkDedicatedAllocationMemoryAllocateInfoNV, pNext ), sizeof( void const * ) );
	swigStructField( "VkDedicatedAllocationMemoryAllocateInfoNV-buffer", offsetof( struct VkDedicatedAllocationMemoryAllocateInfoNV, buffer ), sizeof( VkBuffer ) );
	swigStructField( "VkDedicatedAllocationMemoryAllocateInfoNV-image", offsetof( struct VkDedicatedAllocationMemoryAllocateInfoNV, image ), sizeof( VkImage ) );
	swigStructField( "VkDedicatedAllocationMemoryAllocateInfoNV-sType", offsetof( struct VkDedicatedAllocationMemoryAllocateInfoNV, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDedicatedAllocationMemoryAllocateInfoNV ) );

	swigComment("struct VkPhysicalDeviceTransformFeedbackFeaturesEXT\n");
	printf( "begin-structure VkPhysicalDeviceTransformFeedbackFeaturesEXT\n" );
	swigStructField( "VkPhysicalDeviceTransformFeedbackFeaturesEXT-pNext", offsetof( struct VkPhysicalDeviceTransformFeedbackFeaturesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceTransformFeedbackFeaturesEXT-transformFeedback", offsetof( struct VkPhysicalDeviceTransformFeedbackFeaturesEXT, transformFeedback ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceTransformFeedbackFeaturesEXT-sType", offsetof( struct VkPhysicalDeviceTransformFeedbackFeaturesEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDeviceTransformFeedbackFeaturesEXT-geometryStreams", offsetof( struct VkPhysicalDeviceTransformFeedbackFeaturesEXT, geometryStreams ), sizeof( VkBool32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceTransformFeedbackFeaturesEXT ) );

	swigComment("struct VkPhysicalDeviceTransformFeedbackPropertiesEXT\n");
	printf( "begin-structure VkPhysicalDeviceTransformFeedbackPropertiesEXT\n" );
	swigStructField( "VkPhysicalDeviceTransformFeedbackPropertiesEXT-pNext", offsetof( struct VkPhysicalDeviceTransformFeedbackPropertiesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceTransformFeedbackPropertiesEXT-maxTransformFeedbackStreamDataSize", offsetof( struct VkPhysicalDeviceTransformFeedbackPropertiesEXT, maxTransformFeedbackStreamDataSize ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceTransformFeedbackPropertiesEXT-maxTransformFeedbackBufferDataSize", offsetof( struct VkPhysicalDeviceTransformFeedbackPropertiesEXT, maxTransformFeedbackBufferDataSize ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceTransformFeedbackPropertiesEXT-transformFeedbackQueries", offsetof( struct VkPhysicalDeviceTransformFeedbackPropertiesEXT, transformFeedbackQueries ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceTransformFeedbackPropertiesEXT-maxTransformFeedbackBuffers", offsetof( struct VkPhysicalDeviceTransformFeedbackPropertiesEXT, maxTransformFeedbackBuffers ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceTransformFeedbackPropertiesEXT-sType", offsetof( struct VkPhysicalDeviceTransformFeedbackPropertiesEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDeviceTransformFeedbackPropertiesEXT-maxTransformFeedbackStreams", offsetof( struct VkPhysicalDeviceTransformFeedbackPropertiesEXT, maxTransformFeedbackStreams ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceTransformFeedbackPropertiesEXT-maxTransformFeedbackBufferSize", offsetof( struct VkPhysicalDeviceTransformFeedbackPropertiesEXT, maxTransformFeedbackBufferSize ), sizeof( VkDeviceSize ) );
	swigStructField( "VkPhysicalDeviceTransformFeedbackPropertiesEXT-maxTransformFeedbackBufferDataStride", offsetof( struct VkPhysicalDeviceTransformFeedbackPropertiesEXT, maxTransformFeedbackBufferDataStride ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceTransformFeedbackPropertiesEXT-transformFeedbackRasterizationStreamSelect", offsetof( struct VkPhysicalDeviceTransformFeedbackPropertiesEXT, transformFeedbackRasterizationStreamSelect ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceTransformFeedbackPropertiesEXT-transformFeedbackDraw", offsetof( struct VkPhysicalDeviceTransformFeedbackPropertiesEXT, transformFeedbackDraw ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceTransformFeedbackPropertiesEXT-transformFeedbackStreamsLinesTriangles", offsetof( struct VkPhysicalDeviceTransformFeedbackPropertiesEXT, transformFeedbackStreamsLinesTriangles ), sizeof( VkBool32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceTransformFeedbackPropertiesEXT ) );

	swigComment("struct VkPipelineRasterizationStateStreamCreateInfoEXT\n");
	printf( "begin-structure VkPipelineRasterizationStateStreamCreateInfoEXT\n" );
	swigStructField( "VkPipelineRasterizationStateStreamCreateInfoEXT-pNext", offsetof( struct VkPipelineRasterizationStateStreamCreateInfoEXT, pNext ), sizeof( void const * ) );
	swigStructField( "VkPipelineRasterizationStateStreamCreateInfoEXT-sType", offsetof( struct VkPipelineRasterizationStateStreamCreateInfoEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPipelineRasterizationStateStreamCreateInfoEXT-flags", offsetof( struct VkPipelineRasterizationStateStreamCreateInfoEXT, flags ), sizeof( VkPipelineRasterizationStateStreamCreateFlagsEXT ) );
	swigStructField( "VkPipelineRasterizationStateStreamCreateInfoEXT-rasterizationStream", offsetof( struct VkPipelineRasterizationStateStreamCreateInfoEXT, rasterizationStream ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineRasterizationStateStreamCreateInfoEXT ) );

	swigComment("struct VkCuModuleCreateInfoNVX\n");
	printf( "begin-structure VkCuModuleCreateInfoNVX\n" );
	swigStructField( "VkCuModuleCreateInfoNVX-pNext", offsetof( struct VkCuModuleCreateInfoNVX, pNext ), sizeof( void const * ) );
	swigStructField( "VkCuModuleCreateInfoNVX-dataSize", offsetof( struct VkCuModuleCreateInfoNVX, dataSize ), sizeof( size_t ) );
	swigStructField( "VkCuModuleCreateInfoNVX-pData", offsetof( struct VkCuModuleCreateInfoNVX, pData ), sizeof( void const * ) );
	swigStructField( "VkCuModuleCreateInfoNVX-sType", offsetof( struct VkCuModuleCreateInfoNVX, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkCuModuleCreateInfoNVX ) );

	swigComment("struct VkCuFunctionCreateInfoNVX\n");
	printf( "begin-structure VkCuFunctionCreateInfoNVX\n" );
	swigStructField( "VkCuFunctionCreateInfoNVX-pNext", offsetof( struct VkCuFunctionCreateInfoNVX, pNext ), sizeof( void const * ) );
	swigStructField( "VkCuFunctionCreateInfoNVX-module", offsetof( struct VkCuFunctionCreateInfoNVX, module ), sizeof( VkCuModuleNVX ) );
	swigStructField( "VkCuFunctionCreateInfoNVX-pName", offsetof( struct VkCuFunctionCreateInfoNVX, pName ), sizeof( char const * ) );
	swigStructField( "VkCuFunctionCreateInfoNVX-sType", offsetof( struct VkCuFunctionCreateInfoNVX, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkCuFunctionCreateInfoNVX ) );

	swigComment("struct VkCuLaunchInfoNVX\n");
	printf( "begin-structure VkCuLaunchInfoNVX\n" );
	swigStructField( "VkCuLaunchInfoNVX-gridDimX", offsetof( struct VkCuLaunchInfoNVX, gridDimX ), sizeof( uint32_t ) );
	swigStructField( "VkCuLaunchInfoNVX-gridDimY", offsetof( struct VkCuLaunchInfoNVX, gridDimY ), sizeof( uint32_t ) );
	swigStructField( "VkCuLaunchInfoNVX-gridDimZ", offsetof( struct VkCuLaunchInfoNVX, gridDimZ ), sizeof( uint32_t ) );
	swigStructField( "VkCuLaunchInfoNVX-blockDimX", offsetof( struct VkCuLaunchInfoNVX, blockDimX ), sizeof( uint32_t ) );
	swigStructField( "VkCuLaunchInfoNVX-extraCount", offsetof( struct VkCuLaunchInfoNVX, extraCount ), sizeof( size_t ) );
	swigStructField( "VkCuLaunchInfoNVX-pExtras", offsetof( struct VkCuLaunchInfoNVX, pExtras ), sizeof( void const *const * ) );
	swigStructField( "VkCuLaunchInfoNVX-blockDimY", offsetof( struct VkCuLaunchInfoNVX, blockDimY ), sizeof( uint32_t ) );
	swigStructField( "VkCuLaunchInfoNVX-pNext", offsetof( struct VkCuLaunchInfoNVX, pNext ), sizeof( void const * ) );
	swigStructField( "VkCuLaunchInfoNVX-blockDimZ", offsetof( struct VkCuLaunchInfoNVX, blockDimZ ), sizeof( uint32_t ) );
	swigStructField( "VkCuLaunchInfoNVX-pParams", offsetof( struct VkCuLaunchInfoNVX, pParams ), sizeof( void const *const * ) );
	swigStructField( "VkCuLaunchInfoNVX-function", offsetof( struct VkCuLaunchInfoNVX, function ), sizeof( VkCuFunctionNVX ) );
	swigStructField( "VkCuLaunchInfoNVX-paramCount", offsetof( struct VkCuLaunchInfoNVX, paramCount ), sizeof( size_t ) );
	swigStructField( "VkCuLaunchInfoNVX-sharedMemBytes", offsetof( struct VkCuLaunchInfoNVX, sharedMemBytes ), sizeof( uint32_t ) );
	swigStructField( "VkCuLaunchInfoNVX-sType", offsetof( struct VkCuLaunchInfoNVX, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkCuLaunchInfoNVX ) );

	swigComment("struct VkImageViewHandleInfoNVX\n");
	printf( "begin-structure VkImageViewHandleInfoNVX\n" );
	swigStructField( "VkImageViewHandleInfoNVX-pNext", offsetof( struct VkImageViewHandleInfoNVX, pNext ), sizeof( void const * ) );
	swigStructField( "VkImageViewHandleInfoNVX-sampler", offsetof( struct VkImageViewHandleInfoNVX, sampler ), sizeof( VkSampler ) );
	swigStructField( "VkImageViewHandleInfoNVX-descriptorType", offsetof( struct VkImageViewHandleInfoNVX, descriptorType ), sizeof( VkDescriptorType ) );
	swigStructField( "VkImageViewHandleInfoNVX-sType", offsetof( struct VkImageViewHandleInfoNVX, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkImageViewHandleInfoNVX-imageView", offsetof( struct VkImageViewHandleInfoNVX, imageView ), sizeof( VkImageView ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkImageViewHandleInfoNVX ) );

	swigComment("struct VkImageViewAddressPropertiesNVX\n");
	printf( "begin-structure VkImageViewAddressPropertiesNVX\n" );
	swigStructField( "VkImageViewAddressPropertiesNVX-pNext", offsetof( struct VkImageViewAddressPropertiesNVX, pNext ), sizeof( void * ) );
	swigStructField( "VkImageViewAddressPropertiesNVX-deviceAddress", offsetof( struct VkImageViewAddressPropertiesNVX, deviceAddress ), sizeof( VkDeviceAddress ) );
	swigStructField( "VkImageViewAddressPropertiesNVX-size", offsetof( struct VkImageViewAddressPropertiesNVX, size ), sizeof( VkDeviceSize ) );
	swigStructField( "VkImageViewAddressPropertiesNVX-sType", offsetof( struct VkImageViewAddressPropertiesNVX, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkImageViewAddressPropertiesNVX ) );

	swigComment("struct VkTextureLODGatherFormatPropertiesAMD\n");
	printf( "begin-structure VkTextureLODGatherFormatPropertiesAMD\n" );
	swigStructField( "VkTextureLODGatherFormatPropertiesAMD-pNext", offsetof( struct VkTextureLODGatherFormatPropertiesAMD, pNext ), sizeof( void * ) );
	swigStructField( "VkTextureLODGatherFormatPropertiesAMD-sType", offsetof( struct VkTextureLODGatherFormatPropertiesAMD, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkTextureLODGatherFormatPropertiesAMD-supportsTextureGatherLODBiasAMD", offsetof( struct VkTextureLODGatherFormatPropertiesAMD, supportsTextureGatherLODBiasAMD ), sizeof( VkBool32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkTextureLODGatherFormatPropertiesAMD ) );

	swigComment("struct VkShaderResourceUsageAMD\n");
	printf( "begin-structure VkShaderResourceUsageAMD\n" );
	swigStructField( "VkShaderResourceUsageAMD-ldsUsageSizeInBytes", offsetof( struct VkShaderResourceUsageAMD, ldsUsageSizeInBytes ), sizeof( size_t ) );
	swigStructField( "VkShaderResourceUsageAMD-scratchMemUsageInBytes", offsetof( struct VkShaderResourceUsageAMD, scratchMemUsageInBytes ), sizeof( size_t ) );
	swigStructField( "VkShaderResourceUsageAMD-numUsedVgprs", offsetof( struct VkShaderResourceUsageAMD, numUsedVgprs ), sizeof( uint32_t ) );
	swigStructField( "VkShaderResourceUsageAMD-ldsSizePerLocalWorkGroup", offsetof( struct VkShaderResourceUsageAMD, ldsSizePerLocalWorkGroup ), sizeof( uint32_t ) );
	swigStructField( "VkShaderResourceUsageAMD-numUsedSgprs", offsetof( struct VkShaderResourceUsageAMD, numUsedSgprs ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkShaderResourceUsageAMD ) );

	swigComment("struct VkShaderStatisticsInfoAMD\n");
	printf( "begin-structure VkShaderStatisticsInfoAMD\n" );
	swigStructField( "VkShaderStatisticsInfoAMD-numAvailableVgprs", offsetof( struct VkShaderStatisticsInfoAMD, numAvailableVgprs ), sizeof( uint32_t ) );
	swigStructField( "VkShaderStatisticsInfoAMD-computeWorkGroupSize", offsetof( struct VkShaderStatisticsInfoAMD, computeWorkGroupSize ), sizeof( uint32_t [3] ) );
	swigStructField( "VkShaderStatisticsInfoAMD-numPhysicalSgprs", offsetof( struct VkShaderStatisticsInfoAMD, numPhysicalSgprs ), sizeof( uint32_t ) );
	swigStructField( "VkShaderStatisticsInfoAMD-numAvailableSgprs", offsetof( struct VkShaderStatisticsInfoAMD, numAvailableSgprs ), sizeof( uint32_t ) );
	swigStructField( "VkShaderStatisticsInfoAMD-shaderStageMask", offsetof( struct VkShaderStatisticsInfoAMD, shaderStageMask ), sizeof( VkShaderStageFlags ) );
	swigStructField( "VkShaderStatisticsInfoAMD-resourceUsage", offsetof( struct VkShaderStatisticsInfoAMD, resourceUsage ), sizeof( VkShaderResourceUsageAMD ) );
	swigStructField( "VkShaderStatisticsInfoAMD-numPhysicalVgprs", offsetof( struct VkShaderStatisticsInfoAMD, numPhysicalVgprs ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkShaderStatisticsInfoAMD ) );

	swigComment("struct VkPhysicalDeviceCornerSampledImageFeaturesNV\n");
	printf( "begin-structure VkPhysicalDeviceCornerSampledImageFeaturesNV\n" );
	swigStructField( "VkPhysicalDeviceCornerSampledImageFeaturesNV-pNext", offsetof( struct VkPhysicalDeviceCornerSampledImageFeaturesNV, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceCornerSampledImageFeaturesNV-cornerSampledImage", offsetof( struct VkPhysicalDeviceCornerSampledImageFeaturesNV, cornerSampledImage ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceCornerSampledImageFeaturesNV-sType", offsetof( struct VkPhysicalDeviceCornerSampledImageFeaturesNV, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceCornerSampledImageFeaturesNV ) );

	swigComment("struct VkExternalImageFormatPropertiesNV\n");
	printf( "begin-structure VkExternalImageFormatPropertiesNV\n" );
	swigStructField( "VkExternalImageFormatPropertiesNV-externalMemoryFeatures", offsetof( struct VkExternalImageFormatPropertiesNV, externalMemoryFeatures ), sizeof( VkExternalMemoryFeatureFlagsNV ) );
	swigStructField( "VkExternalImageFormatPropertiesNV-exportFromImportedHandleTypes", offsetof( struct VkExternalImageFormatPropertiesNV, exportFromImportedHandleTypes ), sizeof( VkExternalMemoryHandleTypeFlagsNV ) );
	swigStructField( "VkExternalImageFormatPropertiesNV-compatibleHandleTypes", offsetof( struct VkExternalImageFormatPropertiesNV, compatibleHandleTypes ), sizeof( VkExternalMemoryHandleTypeFlagsNV ) );
	swigStructField( "VkExternalImageFormatPropertiesNV-imageFormatProperties", offsetof( struct VkExternalImageFormatPropertiesNV, imageFormatProperties ), sizeof( VkImageFormatProperties ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkExternalImageFormatPropertiesNV ) );

	swigComment("struct VkExternalMemoryImageCreateInfoNV\n");
	printf( "begin-structure VkExternalMemoryImageCreateInfoNV\n" );
	swigStructField( "VkExternalMemoryImageCreateInfoNV-handleTypes", offsetof( struct VkExternalMemoryImageCreateInfoNV, handleTypes ), sizeof( VkExternalMemoryHandleTypeFlagsNV ) );
	swigStructField( "VkExternalMemoryImageCreateInfoNV-pNext", offsetof( struct VkExternalMemoryImageCreateInfoNV, pNext ), sizeof( void const * ) );
	swigStructField( "VkExternalMemoryImageCreateInfoNV-sType", offsetof( struct VkExternalMemoryImageCreateInfoNV, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkExternalMemoryImageCreateInfoNV ) );

	swigComment("struct VkExportMemoryAllocateInfoNV\n");
	printf( "begin-structure VkExportMemoryAllocateInfoNV\n" );
	swigStructField( "VkExportMemoryAllocateInfoNV-handleTypes", offsetof( struct VkExportMemoryAllocateInfoNV, handleTypes ), sizeof( VkExternalMemoryHandleTypeFlagsNV ) );
	swigStructField( "VkExportMemoryAllocateInfoNV-pNext", offsetof( struct VkExportMemoryAllocateInfoNV, pNext ), sizeof( void const * ) );
	swigStructField( "VkExportMemoryAllocateInfoNV-sType", offsetof( struct VkExportMemoryAllocateInfoNV, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkExportMemoryAllocateInfoNV ) );

	swigComment("struct VkValidationFlagsEXT\n");
	printf( "begin-structure VkValidationFlagsEXT\n" );
	swigStructField( "VkValidationFlagsEXT-pNext", offsetof( struct VkValidationFlagsEXT, pNext ), sizeof( void const * ) );
	swigStructField( "VkValidationFlagsEXT-disabledValidationCheckCount", offsetof( struct VkValidationFlagsEXT, disabledValidationCheckCount ), sizeof( uint32_t ) );
	swigStructField( "VkValidationFlagsEXT-pDisabledValidationChecks", offsetof( struct VkValidationFlagsEXT, pDisabledValidationChecks ), sizeof( VkValidationCheckEXT const * ) );
	swigStructField( "VkValidationFlagsEXT-sType", offsetof( struct VkValidationFlagsEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkValidationFlagsEXT ) );

	swigComment("struct VkPhysicalDeviceTextureCompressionASTCHDRFeaturesEXT\n");
	printf( "begin-structure VkPhysicalDeviceTextureCompressionASTCHDRFeaturesEXT\n" );
	swigStructField( "VkPhysicalDeviceTextureCompressionASTCHDRFeaturesEXT-pNext", offsetof( struct VkPhysicalDeviceTextureCompressionASTCHDRFeaturesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceTextureCompressionASTCHDRFeaturesEXT-sType", offsetof( struct VkPhysicalDeviceTextureCompressionASTCHDRFeaturesEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDeviceTextureCompressionASTCHDRFeaturesEXT-textureCompressionASTC_HDR", offsetof( struct VkPhysicalDeviceTextureCompressionASTCHDRFeaturesEXT, textureCompressionASTC_HDR ), sizeof( VkBool32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceTextureCompressionASTCHDRFeaturesEXT ) );

	swigComment("struct VkImageViewASTCDecodeModeEXT\n");
	printf( "begin-structure VkImageViewASTCDecodeModeEXT\n" );
	swigStructField( "VkImageViewASTCDecodeModeEXT-pNext", offsetof( struct VkImageViewASTCDecodeModeEXT, pNext ), sizeof( void const * ) );
	swigStructField( "VkImageViewASTCDecodeModeEXT-decodeMode", offsetof( struct VkImageViewASTCDecodeModeEXT, decodeMode ), sizeof( VkFormat ) );
	swigStructField( "VkImageViewASTCDecodeModeEXT-sType", offsetof( struct VkImageViewASTCDecodeModeEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkImageViewASTCDecodeModeEXT ) );

	swigComment("struct VkPhysicalDeviceASTCDecodeFeaturesEXT\n");
	printf( "begin-structure VkPhysicalDeviceASTCDecodeFeaturesEXT\n" );
	swigStructField( "VkPhysicalDeviceASTCDecodeFeaturesEXT-pNext", offsetof( struct VkPhysicalDeviceASTCDecodeFeaturesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceASTCDecodeFeaturesEXT-decodeModeSharedExponent", offsetof( struct VkPhysicalDeviceASTCDecodeFeaturesEXT, decodeModeSharedExponent ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceASTCDecodeFeaturesEXT-sType", offsetof( struct VkPhysicalDeviceASTCDecodeFeaturesEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceASTCDecodeFeaturesEXT ) );

	swigComment("struct VkConditionalRenderingBeginInfoEXT\n");
	printf( "begin-structure VkConditionalRenderingBeginInfoEXT\n" );
	swigStructField( "VkConditionalRenderingBeginInfoEXT-pNext", offsetof( struct VkConditionalRenderingBeginInfoEXT, pNext ), sizeof( void const * ) );
	swigStructField( "VkConditionalRenderingBeginInfoEXT-buffer", offsetof( struct VkConditionalRenderingBeginInfoEXT, buffer ), sizeof( VkBuffer ) );
	swigStructField( "VkConditionalRenderingBeginInfoEXT-offset", offsetof( struct VkConditionalRenderingBeginInfoEXT, offset ), sizeof( VkDeviceSize ) );
	swigStructField( "VkConditionalRenderingBeginInfoEXT-sType", offsetof( struct VkConditionalRenderingBeginInfoEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkConditionalRenderingBeginInfoEXT-flags", offsetof( struct VkConditionalRenderingBeginInfoEXT, flags ), sizeof( VkConditionalRenderingFlagsEXT ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkConditionalRenderingBeginInfoEXT ) );

	swigComment("struct VkPhysicalDeviceConditionalRenderingFeaturesEXT\n");
	printf( "begin-structure VkPhysicalDeviceConditionalRenderingFeaturesEXT\n" );
	swigStructField( "VkPhysicalDeviceConditionalRenderingFeaturesEXT-pNext", offsetof( struct VkPhysicalDeviceConditionalRenderingFeaturesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceConditionalRenderingFeaturesEXT-sType", offsetof( struct VkPhysicalDeviceConditionalRenderingFeaturesEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDeviceConditionalRenderingFeaturesEXT-conditionalRendering", offsetof( struct VkPhysicalDeviceConditionalRenderingFeaturesEXT, conditionalRendering ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceConditionalRenderingFeaturesEXT-inheritedConditionalRendering", offsetof( struct VkPhysicalDeviceConditionalRenderingFeaturesEXT, inheritedConditionalRendering ), sizeof( VkBool32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceConditionalRenderingFeaturesEXT ) );

	swigComment("struct VkCommandBufferInheritanceConditionalRenderingInfoEXT\n");
	printf( "begin-structure VkCommandBufferInheritanceConditionalRenderingInfoEXT\n" );
	swigStructField( "VkCommandBufferInheritanceConditionalRenderingInfoEXT-pNext", offsetof( struct VkCommandBufferInheritanceConditionalRenderingInfoEXT, pNext ), sizeof( void const * ) );
	swigStructField( "VkCommandBufferInheritanceConditionalRenderingInfoEXT-conditionalRenderingEnable", offsetof( struct VkCommandBufferInheritanceConditionalRenderingInfoEXT, conditionalRenderingEnable ), sizeof( VkBool32 ) );
	swigStructField( "VkCommandBufferInheritanceConditionalRenderingInfoEXT-sType", offsetof( struct VkCommandBufferInheritanceConditionalRenderingInfoEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkCommandBufferInheritanceConditionalRenderingInfoEXT ) );

	swigComment("struct VkViewportWScalingNV\n");
	printf( "begin-structure VkViewportWScalingNV\n" );
	swigStructField( "VkViewportWScalingNV-xcoeff", offsetof( struct VkViewportWScalingNV, xcoeff ), sizeof( float ) );
	swigStructField( "VkViewportWScalingNV-ycoeff", offsetof( struct VkViewportWScalingNV, ycoeff ), sizeof( float ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkViewportWScalingNV ) );

	swigComment("struct VkPipelineViewportWScalingStateCreateInfoNV\n");
	printf( "begin-structure VkPipelineViewportWScalingStateCreateInfoNV\n" );
	swigStructField( "VkPipelineViewportWScalingStateCreateInfoNV-pNext", offsetof( struct VkPipelineViewportWScalingStateCreateInfoNV, pNext ), sizeof( void const * ) );
	swigStructField( "VkPipelineViewportWScalingStateCreateInfoNV-viewportWScalingEnable", offsetof( struct VkPipelineViewportWScalingStateCreateInfoNV, viewportWScalingEnable ), sizeof( VkBool32 ) );
	swigStructField( "VkPipelineViewportWScalingStateCreateInfoNV-sType", offsetof( struct VkPipelineViewportWScalingStateCreateInfoNV, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPipelineViewportWScalingStateCreateInfoNV-pViewportWScalings", offsetof( struct VkPipelineViewportWScalingStateCreateInfoNV, pViewportWScalings ), sizeof( VkViewportWScalingNV const * ) );
	swigStructField( "VkPipelineViewportWScalingStateCreateInfoNV-viewportCount", offsetof( struct VkPipelineViewportWScalingStateCreateInfoNV, viewportCount ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineViewportWScalingStateCreateInfoNV ) );

	swigComment("struct VkSurfaceCapabilities2EXT\n");
	printf( "begin-structure VkSurfaceCapabilities2EXT\n" );
	swigStructField( "VkSurfaceCapabilities2EXT-minImageExtent", offsetof( struct VkSurfaceCapabilities2EXT, minImageExtent ), sizeof( VkExtent2D ) );
	swigStructField( "VkSurfaceCapabilities2EXT-maxImageExtent", offsetof( struct VkSurfaceCapabilities2EXT, maxImageExtent ), sizeof( VkExtent2D ) );
	swigStructField( "VkSurfaceCapabilities2EXT-supportedTransforms", offsetof( struct VkSurfaceCapabilities2EXT, supportedTransforms ), sizeof( VkSurfaceTransformFlagsKHR ) );
	swigStructField( "VkSurfaceCapabilities2EXT-pNext", offsetof( struct VkSurfaceCapabilities2EXT, pNext ), sizeof( void * ) );
	swigStructField( "VkSurfaceCapabilities2EXT-minImageCount", offsetof( struct VkSurfaceCapabilities2EXT, minImageCount ), sizeof( uint32_t ) );
	swigStructField( "VkSurfaceCapabilities2EXT-maxImageCount", offsetof( struct VkSurfaceCapabilities2EXT, maxImageCount ), sizeof( uint32_t ) );
	swigStructField( "VkSurfaceCapabilities2EXT-supportedCompositeAlpha", offsetof( struct VkSurfaceCapabilities2EXT, supportedCompositeAlpha ), sizeof( VkCompositeAlphaFlagsKHR ) );
	swigStructField( "VkSurfaceCapabilities2EXT-sType", offsetof( struct VkSurfaceCapabilities2EXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkSurfaceCapabilities2EXT-maxImageArrayLayers", offsetof( struct VkSurfaceCapabilities2EXT, maxImageArrayLayers ), sizeof( uint32_t ) );
	swigStructField( "VkSurfaceCapabilities2EXT-currentTransform", offsetof( struct VkSurfaceCapabilities2EXT, currentTransform ), sizeof( VkSurfaceTransformFlagBitsKHR ) );
	swigStructField( "VkSurfaceCapabilities2EXT-currentExtent", offsetof( struct VkSurfaceCapabilities2EXT, currentExtent ), sizeof( VkExtent2D ) );
	swigStructField( "VkSurfaceCapabilities2EXT-supportedUsageFlags", offsetof( struct VkSurfaceCapabilities2EXT, supportedUsageFlags ), sizeof( VkImageUsageFlags ) );
	swigStructField( "VkSurfaceCapabilities2EXT-supportedSurfaceCounters", offsetof( struct VkSurfaceCapabilities2EXT, supportedSurfaceCounters ), sizeof( VkSurfaceCounterFlagsEXT ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSurfaceCapabilities2EXT ) );

	swigComment("struct VkDisplayPowerInfoEXT\n");
	printf( "begin-structure VkDisplayPowerInfoEXT\n" );
	swigStructField( "VkDisplayPowerInfoEXT-pNext", offsetof( struct VkDisplayPowerInfoEXT, pNext ), sizeof( void const * ) );
	swigStructField( "VkDisplayPowerInfoEXT-powerState", offsetof( struct VkDisplayPowerInfoEXT, powerState ), sizeof( VkDisplayPowerStateEXT ) );
	swigStructField( "VkDisplayPowerInfoEXT-sType", offsetof( struct VkDisplayPowerInfoEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDisplayPowerInfoEXT ) );

	swigComment("struct VkDeviceEventInfoEXT\n");
	printf( "begin-structure VkDeviceEventInfoEXT\n" );
	swigStructField( "VkDeviceEventInfoEXT-deviceEvent", offsetof( struct VkDeviceEventInfoEXT, deviceEvent ), sizeof( VkDeviceEventTypeEXT ) );
	swigStructField( "VkDeviceEventInfoEXT-pNext", offsetof( struct VkDeviceEventInfoEXT, pNext ), sizeof( void const * ) );
	swigStructField( "VkDeviceEventInfoEXT-sType", offsetof( struct VkDeviceEventInfoEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDeviceEventInfoEXT ) );

	swigComment("struct VkDisplayEventInfoEXT\n");
	printf( "begin-structure VkDisplayEventInfoEXT\n" );
	swigStructField( "VkDisplayEventInfoEXT-pNext", offsetof( struct VkDisplayEventInfoEXT, pNext ), sizeof( void const * ) );
	swigStructField( "VkDisplayEventInfoEXT-sType", offsetof( struct VkDisplayEventInfoEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkDisplayEventInfoEXT-displayEvent", offsetof( struct VkDisplayEventInfoEXT, displayEvent ), sizeof( VkDisplayEventTypeEXT ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDisplayEventInfoEXT ) );

	swigComment("struct VkSwapchainCounterCreateInfoEXT\n");
	printf( "begin-structure VkSwapchainCounterCreateInfoEXT\n" );
	swigStructField( "VkSwapchainCounterCreateInfoEXT-pNext", offsetof( struct VkSwapchainCounterCreateInfoEXT, pNext ), sizeof( void const * ) );
	swigStructField( "VkSwapchainCounterCreateInfoEXT-sType", offsetof( struct VkSwapchainCounterCreateInfoEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkSwapchainCounterCreateInfoEXT-surfaceCounters", offsetof( struct VkSwapchainCounterCreateInfoEXT, surfaceCounters ), sizeof( VkSurfaceCounterFlagsEXT ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSwapchainCounterCreateInfoEXT ) );

	swigComment("struct VkRefreshCycleDurationGOOGLE\n");
	printf( "begin-structure VkRefreshCycleDurationGOOGLE\n" );
	swigStructField( "VkRefreshCycleDurationGOOGLE-refreshDuration", offsetof( struct VkRefreshCycleDurationGOOGLE, refreshDuration ), sizeof( uint64_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkRefreshCycleDurationGOOGLE ) );

	swigComment("struct VkPastPresentationTimingGOOGLE\n");
	printf( "begin-structure VkPastPresentationTimingGOOGLE\n" );
	swigStructField( "VkPastPresentationTimingGOOGLE-desiredPresentTime", offsetof( struct VkPastPresentationTimingGOOGLE, desiredPresentTime ), sizeof( uint64_t ) );
	swigStructField( "VkPastPresentationTimingGOOGLE-actualPresentTime", offsetof( struct VkPastPresentationTimingGOOGLE, actualPresentTime ), sizeof( uint64_t ) );
	swigStructField( "VkPastPresentationTimingGOOGLE-earliestPresentTime", offsetof( struct VkPastPresentationTimingGOOGLE, earliestPresentTime ), sizeof( uint64_t ) );
	swigStructField( "VkPastPresentationTimingGOOGLE-presentID", offsetof( struct VkPastPresentationTimingGOOGLE, presentID ), sizeof( uint32_t ) );
	swigStructField( "VkPastPresentationTimingGOOGLE-presentMargin", offsetof( struct VkPastPresentationTimingGOOGLE, presentMargin ), sizeof( uint64_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPastPresentationTimingGOOGLE ) );

	swigComment("struct VkPresentTimeGOOGLE\n");
	printf( "begin-structure VkPresentTimeGOOGLE\n" );
	swigStructField( "VkPresentTimeGOOGLE-desiredPresentTime", offsetof( struct VkPresentTimeGOOGLE, desiredPresentTime ), sizeof( uint64_t ) );
	swigStructField( "VkPresentTimeGOOGLE-presentID", offsetof( struct VkPresentTimeGOOGLE, presentID ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPresentTimeGOOGLE ) );

	swigComment("struct VkPresentTimesInfoGOOGLE\n");
	printf( "begin-structure VkPresentTimesInfoGOOGLE\n" );
	swigStructField( "VkPresentTimesInfoGOOGLE-swapchainCount", offsetof( struct VkPresentTimesInfoGOOGLE, swapchainCount ), sizeof( uint32_t ) );
	swigStructField( "VkPresentTimesInfoGOOGLE-pTimes", offsetof( struct VkPresentTimesInfoGOOGLE, pTimes ), sizeof( VkPresentTimeGOOGLE const * ) );
	swigStructField( "VkPresentTimesInfoGOOGLE-pNext", offsetof( struct VkPresentTimesInfoGOOGLE, pNext ), sizeof( void const * ) );
	swigStructField( "VkPresentTimesInfoGOOGLE-sType", offsetof( struct VkPresentTimesInfoGOOGLE, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPresentTimesInfoGOOGLE ) );

	swigComment("struct VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX\n");
	printf( "begin-structure VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX\n" );
	swigStructField( "VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX-pNext", offsetof( struct VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX-sType", offsetof( struct VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX-perViewPositionAllComponents", offsetof( struct VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX, perViewPositionAllComponents ), sizeof( VkBool32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX ) );

	swigComment("struct VkViewportSwizzleNV\n");
	printf( "begin-structure VkViewportSwizzleNV\n" );
	swigStructField( "VkViewportSwizzleNV-w", offsetof( struct VkViewportSwizzleNV, w ), sizeof( VkViewportCoordinateSwizzleNV ) );
	swigStructField( "VkViewportSwizzleNV-x", offsetof( struct VkViewportSwizzleNV, x ), sizeof( VkViewportCoordinateSwizzleNV ) );
	swigStructField( "VkViewportSwizzleNV-y", offsetof( struct VkViewportSwizzleNV, y ), sizeof( VkViewportCoordinateSwizzleNV ) );
	swigStructField( "VkViewportSwizzleNV-z", offsetof( struct VkViewportSwizzleNV, z ), sizeof( VkViewportCoordinateSwizzleNV ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkViewportSwizzleNV ) );

	swigComment("struct VkPipelineViewportSwizzleStateCreateInfoNV\n");
	printf( "begin-structure VkPipelineViewportSwizzleStateCreateInfoNV\n" );
	swigStructField( "VkPipelineViewportSwizzleStateCreateInfoNV-pNext", offsetof( struct VkPipelineViewportSwizzleStateCreateInfoNV, pNext ), sizeof( void const * ) );
	swigStructField( "VkPipelineViewportSwizzleStateCreateInfoNV-sType", offsetof( struct VkPipelineViewportSwizzleStateCreateInfoNV, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPipelineViewportSwizzleStateCreateInfoNV-flags", offsetof( struct VkPipelineViewportSwizzleStateCreateInfoNV, flags ), sizeof( VkPipelineViewportSwizzleStateCreateFlagsNV ) );
	swigStructField( "VkPipelineViewportSwizzleStateCreateInfoNV-pViewportSwizzles", offsetof( struct VkPipelineViewportSwizzleStateCreateInfoNV, pViewportSwizzles ), sizeof( VkViewportSwizzleNV const * ) );
	swigStructField( "VkPipelineViewportSwizzleStateCreateInfoNV-viewportCount", offsetof( struct VkPipelineViewportSwizzleStateCreateInfoNV, viewportCount ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineViewportSwizzleStateCreateInfoNV ) );

	swigComment("struct VkPhysicalDeviceDiscardRectanglePropertiesEXT\n");
	printf( "begin-structure VkPhysicalDeviceDiscardRectanglePropertiesEXT\n" );
	swigStructField( "VkPhysicalDeviceDiscardRectanglePropertiesEXT-maxDiscardRectangles", offsetof( struct VkPhysicalDeviceDiscardRectanglePropertiesEXT, maxDiscardRectangles ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceDiscardRectanglePropertiesEXT-pNext", offsetof( struct VkPhysicalDeviceDiscardRectanglePropertiesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceDiscardRectanglePropertiesEXT-sType", offsetof( struct VkPhysicalDeviceDiscardRectanglePropertiesEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceDiscardRectanglePropertiesEXT ) );

	swigComment("struct VkPipelineDiscardRectangleStateCreateInfoEXT\n");
	printf( "begin-structure VkPipelineDiscardRectangleStateCreateInfoEXT\n" );
	swigStructField( "VkPipelineDiscardRectangleStateCreateInfoEXT-pDiscardRectangles", offsetof( struct VkPipelineDiscardRectangleStateCreateInfoEXT, pDiscardRectangles ), sizeof( VkRect2D const * ) );
	swigStructField( "VkPipelineDiscardRectangleStateCreateInfoEXT-pNext", offsetof( struct VkPipelineDiscardRectangleStateCreateInfoEXT, pNext ), sizeof( void const * ) );
	swigStructField( "VkPipelineDiscardRectangleStateCreateInfoEXT-discardRectangleMode", offsetof( struct VkPipelineDiscardRectangleStateCreateInfoEXT, discardRectangleMode ), sizeof( VkDiscardRectangleModeEXT ) );
	swigStructField( "VkPipelineDiscardRectangleStateCreateInfoEXT-discardRectangleCount", offsetof( struct VkPipelineDiscardRectangleStateCreateInfoEXT, discardRectangleCount ), sizeof( uint32_t ) );
	swigStructField( "VkPipelineDiscardRectangleStateCreateInfoEXT-sType", offsetof( struct VkPipelineDiscardRectangleStateCreateInfoEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPipelineDiscardRectangleStateCreateInfoEXT-flags", offsetof( struct VkPipelineDiscardRectangleStateCreateInfoEXT, flags ), sizeof( VkPipelineDiscardRectangleStateCreateFlagsEXT ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineDiscardRectangleStateCreateInfoEXT ) );

	swigComment("struct VkPhysicalDeviceConservativeRasterizationPropertiesEXT\n");
	printf( "begin-structure VkPhysicalDeviceConservativeRasterizationPropertiesEXT\n" );
	swigStructField( "VkPhysicalDeviceConservativeRasterizationPropertiesEXT-pNext", offsetof( struct VkPhysicalDeviceConservativeRasterizationPropertiesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceConservativeRasterizationPropertiesEXT-primitiveOverestimationSize", offsetof( struct VkPhysicalDeviceConservativeRasterizationPropertiesEXT, primitiveOverestimationSize ), sizeof( float ) );
	swigStructField( "VkPhysicalDeviceConservativeRasterizationPropertiesEXT-maxExtraPrimitiveOverestimationSize", offsetof( struct VkPhysicalDeviceConservativeRasterizationPropertiesEXT, maxExtraPrimitiveOverestimationSize ), sizeof( float ) );
	swigStructField( "VkPhysicalDeviceConservativeRasterizationPropertiesEXT-fullyCoveredFragmentShaderInputVariable", offsetof( struct VkPhysicalDeviceConservativeRasterizationPropertiesEXT, fullyCoveredFragmentShaderInputVariable ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceConservativeRasterizationPropertiesEXT-conservativeRasterizationPostDepthCoverage", offsetof( struct VkPhysicalDeviceConservativeRasterizationPropertiesEXT, conservativeRasterizationPostDepthCoverage ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceConservativeRasterizationPropertiesEXT-conservativePointAndLineRasterization", offsetof( struct VkPhysicalDeviceConservativeRasterizationPropertiesEXT, conservativePointAndLineRasterization ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceConservativeRasterizationPropertiesEXT-degenerateTrianglesRasterized", offsetof( struct VkPhysicalDeviceConservativeRasterizationPropertiesEXT, degenerateTrianglesRasterized ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceConservativeRasterizationPropertiesEXT-degenerateLinesRasterized", offsetof( struct VkPhysicalDeviceConservativeRasterizationPropertiesEXT, degenerateLinesRasterized ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceConservativeRasterizationPropertiesEXT-sType", offsetof( struct VkPhysicalDeviceConservativeRasterizationPropertiesEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDeviceConservativeRasterizationPropertiesEXT-extraPrimitiveOverestimationSizeGranularity", offsetof( struct VkPhysicalDeviceConservativeRasterizationPropertiesEXT, extraPrimitiveOverestimationSizeGranularity ), sizeof( float ) );
	swigStructField( "VkPhysicalDeviceConservativeRasterizationPropertiesEXT-primitiveUnderestimation", offsetof( struct VkPhysicalDeviceConservativeRasterizationPropertiesEXT, primitiveUnderestimation ), sizeof( VkBool32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceConservativeRasterizationPropertiesEXT ) );

	swigComment("struct VkPipelineRasterizationConservativeStateCreateInfoEXT\n");
	printf( "begin-structure VkPipelineRasterizationConservativeStateCreateInfoEXT\n" );
	swigStructField( "VkPipelineRasterizationConservativeStateCreateInfoEXT-pNext", offsetof( struct VkPipelineRasterizationConservativeStateCreateInfoEXT, pNext ), sizeof( void const * ) );
	swigStructField( "VkPipelineRasterizationConservativeStateCreateInfoEXT-extraPrimitiveOverestimationSize", offsetof( struct VkPipelineRasterizationConservativeStateCreateInfoEXT, extraPrimitiveOverestimationSize ), sizeof( float ) );
	swigStructField( "VkPipelineRasterizationConservativeStateCreateInfoEXT-conservativeRasterizationMode", offsetof( struct VkPipelineRasterizationConservativeStateCreateInfoEXT, conservativeRasterizationMode ), sizeof( VkConservativeRasterizationModeEXT ) );
	swigStructField( "VkPipelineRasterizationConservativeStateCreateInfoEXT-sType", offsetof( struct VkPipelineRasterizationConservativeStateCreateInfoEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPipelineRasterizationConservativeStateCreateInfoEXT-flags", offsetof( struct VkPipelineRasterizationConservativeStateCreateInfoEXT, flags ), sizeof( VkPipelineRasterizationConservativeStateCreateFlagsEXT ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineRasterizationConservativeStateCreateInfoEXT ) );

	swigComment("struct VkPhysicalDeviceDepthClipEnableFeaturesEXT\n");
	printf( "begin-structure VkPhysicalDeviceDepthClipEnableFeaturesEXT\n" );
	swigStructField( "VkPhysicalDeviceDepthClipEnableFeaturesEXT-pNext", offsetof( struct VkPhysicalDeviceDepthClipEnableFeaturesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceDepthClipEnableFeaturesEXT-depthClipEnable", offsetof( struct VkPhysicalDeviceDepthClipEnableFeaturesEXT, depthClipEnable ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceDepthClipEnableFeaturesEXT-sType", offsetof( struct VkPhysicalDeviceDepthClipEnableFeaturesEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceDepthClipEnableFeaturesEXT ) );

	swigComment("struct VkPipelineRasterizationDepthClipStateCreateInfoEXT\n");
	printf( "begin-structure VkPipelineRasterizationDepthClipStateCreateInfoEXT\n" );
	swigStructField( "VkPipelineRasterizationDepthClipStateCreateInfoEXT-pNext", offsetof( struct VkPipelineRasterizationDepthClipStateCreateInfoEXT, pNext ), sizeof( void const * ) );
	swigStructField( "VkPipelineRasterizationDepthClipStateCreateInfoEXT-depthClipEnable", offsetof( struct VkPipelineRasterizationDepthClipStateCreateInfoEXT, depthClipEnable ), sizeof( VkBool32 ) );
	swigStructField( "VkPipelineRasterizationDepthClipStateCreateInfoEXT-sType", offsetof( struct VkPipelineRasterizationDepthClipStateCreateInfoEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPipelineRasterizationDepthClipStateCreateInfoEXT-flags", offsetof( struct VkPipelineRasterizationDepthClipStateCreateInfoEXT, flags ), sizeof( VkPipelineRasterizationDepthClipStateCreateFlagsEXT ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineRasterizationDepthClipStateCreateInfoEXT ) );

	swigComment("struct VkXYColorEXT\n");
	printf( "begin-structure VkXYColorEXT\n" );
	swigStructField( "VkXYColorEXT-x", offsetof( struct VkXYColorEXT, x ), sizeof( float ) );
	swigStructField( "VkXYColorEXT-y", offsetof( struct VkXYColorEXT, y ), sizeof( float ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkXYColorEXT ) );

	swigComment("struct VkHdrMetadataEXT\n");
	printf( "begin-structure VkHdrMetadataEXT\n" );
	swigStructField( "VkHdrMetadataEXT-pNext", offsetof( struct VkHdrMetadataEXT, pNext ), sizeof( void const * ) );
	swigStructField( "VkHdrMetadataEXT-displayPrimaryRed", offsetof( struct VkHdrMetadataEXT, displayPrimaryRed ), sizeof( VkXYColorEXT ) );
	swigStructField( "VkHdrMetadataEXT-displayPrimaryGreen", offsetof( struct VkHdrMetadataEXT, displayPrimaryGreen ), sizeof( VkXYColorEXT ) );
	swigStructField( "VkHdrMetadataEXT-whitePoint", offsetof( struct VkHdrMetadataEXT, whitePoint ), sizeof( VkXYColorEXT ) );
	swigStructField( "VkHdrMetadataEXT-maxContentLightLevel", offsetof( struct VkHdrMetadataEXT, maxContentLightLevel ), sizeof( float ) );
	swigStructField( "VkHdrMetadataEXT-maxFrameAverageLightLevel", offsetof( struct VkHdrMetadataEXT, maxFrameAverageLightLevel ), sizeof( float ) );
	swigStructField( "VkHdrMetadataEXT-sType", offsetof( struct VkHdrMetadataEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkHdrMetadataEXT-maxLuminance", offsetof( struct VkHdrMetadataEXT, maxLuminance ), sizeof( float ) );
	swigStructField( "VkHdrMetadataEXT-minLuminance", offsetof( struct VkHdrMetadataEXT, minLuminance ), sizeof( float ) );
	swigStructField( "VkHdrMetadataEXT-displayPrimaryBlue", offsetof( struct VkHdrMetadataEXT, displayPrimaryBlue ), sizeof( VkXYColorEXT ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkHdrMetadataEXT ) );

	swigComment("struct VkDebugUtilsLabelEXT\n");
	printf( "begin-structure VkDebugUtilsLabelEXT\n" );
	swigStructField( "VkDebugUtilsLabelEXT-color", offsetof( struct VkDebugUtilsLabelEXT, color ), sizeof( float [4] ) );
	swigStructField( "VkDebugUtilsLabelEXT-pNext", offsetof( struct VkDebugUtilsLabelEXT, pNext ), sizeof( void const * ) );
	swigStructField( "VkDebugUtilsLabelEXT-sType", offsetof( struct VkDebugUtilsLabelEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkDebugUtilsLabelEXT-pLabelName", offsetof( struct VkDebugUtilsLabelEXT, pLabelName ), sizeof( char const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDebugUtilsLabelEXT ) );

	swigComment("struct VkDebugUtilsObjectNameInfoEXT\n");
	printf( "begin-structure VkDebugUtilsObjectNameInfoEXT\n" );
	swigStructField( "VkDebugUtilsObjectNameInfoEXT-pNext", offsetof( struct VkDebugUtilsObjectNameInfoEXT, pNext ), sizeof( void const * ) );
	swigStructField( "VkDebugUtilsObjectNameInfoEXT-objectType", offsetof( struct VkDebugUtilsObjectNameInfoEXT, objectType ), sizeof( VkObjectType ) );
	swigStructField( "VkDebugUtilsObjectNameInfoEXT-objectHandle", offsetof( struct VkDebugUtilsObjectNameInfoEXT, objectHandle ), sizeof( uint64_t ) );
	swigStructField( "VkDebugUtilsObjectNameInfoEXT-sType", offsetof( struct VkDebugUtilsObjectNameInfoEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkDebugUtilsObjectNameInfoEXT-pObjectName", offsetof( struct VkDebugUtilsObjectNameInfoEXT, pObjectName ), sizeof( char const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDebugUtilsObjectNameInfoEXT ) );

	swigComment("struct VkDebugUtilsMessengerCallbackDataEXT\n");
	printf( "begin-structure VkDebugUtilsMessengerCallbackDataEXT\n" );
	swigStructField( "VkDebugUtilsMessengerCallbackDataEXT-pQueueLabels", offsetof( struct VkDebugUtilsMessengerCallbackDataEXT, pQueueLabels ), sizeof( VkDebugUtilsLabelEXT const * ) );
	swigStructField( "VkDebugUtilsMessengerCallbackDataEXT-pNext", offsetof( struct VkDebugUtilsMessengerCallbackDataEXT, pNext ), sizeof( void const * ) );
	swigStructField( "VkDebugUtilsMessengerCallbackDataEXT-pMessageIdName", offsetof( struct VkDebugUtilsMessengerCallbackDataEXT, pMessageIdName ), sizeof( char const * ) );
	swigStructField( "VkDebugUtilsMessengerCallbackDataEXT-messageIdNumber", offsetof( struct VkDebugUtilsMessengerCallbackDataEXT, messageIdNumber ), sizeof( int32_t ) );
	swigStructField( "VkDebugUtilsMessengerCallbackDataEXT-queueLabelCount", offsetof( struct VkDebugUtilsMessengerCallbackDataEXT, queueLabelCount ), sizeof( uint32_t ) );
	swigStructField( "VkDebugUtilsMessengerCallbackDataEXT-cmdBufLabelCount", offsetof( struct VkDebugUtilsMessengerCallbackDataEXT, cmdBufLabelCount ), sizeof( uint32_t ) );
	swigStructField( "VkDebugUtilsMessengerCallbackDataEXT-pMessage", offsetof( struct VkDebugUtilsMessengerCallbackDataEXT, pMessage ), sizeof( char const * ) );
	swigStructField( "VkDebugUtilsMessengerCallbackDataEXT-pObjects", offsetof( struct VkDebugUtilsMessengerCallbackDataEXT, pObjects ), sizeof( VkDebugUtilsObjectNameInfoEXT const * ) );
	swigStructField( "VkDebugUtilsMessengerCallbackDataEXT-sType", offsetof( struct VkDebugUtilsMessengerCallbackDataEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkDebugUtilsMessengerCallbackDataEXT-flags", offsetof( struct VkDebugUtilsMessengerCallbackDataEXT, flags ), sizeof( VkDebugUtilsMessengerCallbackDataFlagsEXT ) );
	swigStructField( "VkDebugUtilsMessengerCallbackDataEXT-objectCount", offsetof( struct VkDebugUtilsMessengerCallbackDataEXT, objectCount ), sizeof( uint32_t ) );
	swigStructField( "VkDebugUtilsMessengerCallbackDataEXT-pCmdBufLabels", offsetof( struct VkDebugUtilsMessengerCallbackDataEXT, pCmdBufLabels ), sizeof( VkDebugUtilsLabelEXT const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDebugUtilsMessengerCallbackDataEXT ) );

	swigComment("struct VkDebugUtilsMessengerCreateInfoEXT\n");
	printf( "begin-structure VkDebugUtilsMessengerCreateInfoEXT\n" );
	swigStructField( "VkDebugUtilsMessengerCreateInfoEXT-pNext", offsetof( struct VkDebugUtilsMessengerCreateInfoEXT, pNext ), sizeof( void const * ) );
	swigStructField( "VkDebugUtilsMessengerCreateInfoEXT-pUserData", offsetof( struct VkDebugUtilsMessengerCreateInfoEXT, pUserData ), sizeof( void * ) );
	swigStructField( "VkDebugUtilsMessengerCreateInfoEXT-sType", offsetof( struct VkDebugUtilsMessengerCreateInfoEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkDebugUtilsMessengerCreateInfoEXT-flags", offsetof( struct VkDebugUtilsMessengerCreateInfoEXT, flags ), sizeof( VkDebugUtilsMessengerCreateFlagsEXT ) );
	swigStructField( "VkDebugUtilsMessengerCreateInfoEXT-messageType", offsetof( struct VkDebugUtilsMessengerCreateInfoEXT, messageType ), sizeof( VkDebugUtilsMessageTypeFlagsEXT ) );
	swigStructField( "VkDebugUtilsMessengerCreateInfoEXT-pfnUserCallback", offsetof( struct VkDebugUtilsMessengerCreateInfoEXT, pfnUserCallback ), sizeof( PFN_vkDebugUtilsMessengerCallbackEXT ) );
	swigStructField( "VkDebugUtilsMessengerCreateInfoEXT-messageSeverity", offsetof( struct VkDebugUtilsMessengerCreateInfoEXT, messageSeverity ), sizeof( VkDebugUtilsMessageSeverityFlagsEXT ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDebugUtilsMessengerCreateInfoEXT ) );

	swigComment("struct VkDebugUtilsObjectTagInfoEXT\n");
	printf( "begin-structure VkDebugUtilsObjectTagInfoEXT\n" );
	swigStructField( "VkDebugUtilsObjectTagInfoEXT-pNext", offsetof( struct VkDebugUtilsObjectTagInfoEXT, pNext ), sizeof( void const * ) );
	swigStructField( "VkDebugUtilsObjectTagInfoEXT-objectType", offsetof( struct VkDebugUtilsObjectTagInfoEXT, objectType ), sizeof( VkObjectType ) );
	swigStructField( "VkDebugUtilsObjectTagInfoEXT-objectHandle", offsetof( struct VkDebugUtilsObjectTagInfoEXT, objectHandle ), sizeof( uint64_t ) );
	swigStructField( "VkDebugUtilsObjectTagInfoEXT-pTag", offsetof( struct VkDebugUtilsObjectTagInfoEXT, pTag ), sizeof( void const * ) );
	swigStructField( "VkDebugUtilsObjectTagInfoEXT-tagSize", offsetof( struct VkDebugUtilsObjectTagInfoEXT, tagSize ), sizeof( size_t ) );
	swigStructField( "VkDebugUtilsObjectTagInfoEXT-sType", offsetof( struct VkDebugUtilsObjectTagInfoEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkDebugUtilsObjectTagInfoEXT-tagName", offsetof( struct VkDebugUtilsObjectTagInfoEXT, tagName ), sizeof( uint64_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDebugUtilsObjectTagInfoEXT ) );

	swigComment("struct VkPhysicalDeviceInlineUniformBlockFeaturesEXT\n");
	printf( "begin-structure VkPhysicalDeviceInlineUniformBlockFeaturesEXT\n" );
	swigStructField( "VkPhysicalDeviceInlineUniformBlockFeaturesEXT-pNext", offsetof( struct VkPhysicalDeviceInlineUniformBlockFeaturesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceInlineUniformBlockFeaturesEXT-descriptorBindingInlineUniformBlockUpdateAfterBind", offsetof( struct VkPhysicalDeviceInlineUniformBlockFeaturesEXT, descriptorBindingInlineUniformBlockUpdateAfterBind ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceInlineUniformBlockFeaturesEXT-inlineUniformBlock", offsetof( struct VkPhysicalDeviceInlineUniformBlockFeaturesEXT, inlineUniformBlock ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceInlineUniformBlockFeaturesEXT-sType", offsetof( struct VkPhysicalDeviceInlineUniformBlockFeaturesEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceInlineUniformBlockFeaturesEXT ) );

	swigComment("struct VkPhysicalDeviceInlineUniformBlockPropertiesEXT\n");
	printf( "begin-structure VkPhysicalDeviceInlineUniformBlockPropertiesEXT\n" );
	swigStructField( "VkPhysicalDeviceInlineUniformBlockPropertiesEXT-maxInlineUniformBlockSize", offsetof( struct VkPhysicalDeviceInlineUniformBlockPropertiesEXT, maxInlineUniformBlockSize ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceInlineUniformBlockPropertiesEXT-pNext", offsetof( struct VkPhysicalDeviceInlineUniformBlockPropertiesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceInlineUniformBlockPropertiesEXT-maxPerStageDescriptorInlineUniformBlocks", offsetof( struct VkPhysicalDeviceInlineUniformBlockPropertiesEXT, maxPerStageDescriptorInlineUniformBlocks ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceInlineUniformBlockPropertiesEXT-maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks", offsetof( struct VkPhysicalDeviceInlineUniformBlockPropertiesEXT, maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceInlineUniformBlockPropertiesEXT-maxDescriptorSetInlineUniformBlocks", offsetof( struct VkPhysicalDeviceInlineUniformBlockPropertiesEXT, maxDescriptorSetInlineUniformBlocks ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceInlineUniformBlockPropertiesEXT-maxDescriptorSetUpdateAfterBindInlineUniformBlocks", offsetof( struct VkPhysicalDeviceInlineUniformBlockPropertiesEXT, maxDescriptorSetUpdateAfterBindInlineUniformBlocks ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceInlineUniformBlockPropertiesEXT-sType", offsetof( struct VkPhysicalDeviceInlineUniformBlockPropertiesEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceInlineUniformBlockPropertiesEXT ) );

	swigComment("struct VkWriteDescriptorSetInlineUniformBlockEXT\n");
	printf( "begin-structure VkWriteDescriptorSetInlineUniformBlockEXT\n" );
	swigStructField( "VkWriteDescriptorSetInlineUniformBlockEXT-pNext", offsetof( struct VkWriteDescriptorSetInlineUniformBlockEXT, pNext ), sizeof( void const * ) );
	swigStructField( "VkWriteDescriptorSetInlineUniformBlockEXT-dataSize", offsetof( struct VkWriteDescriptorSetInlineUniformBlockEXT, dataSize ), sizeof( uint32_t ) );
	swigStructField( "VkWriteDescriptorSetInlineUniformBlockEXT-pData", offsetof( struct VkWriteDescriptorSetInlineUniformBlockEXT, pData ), sizeof( void const * ) );
	swigStructField( "VkWriteDescriptorSetInlineUniformBlockEXT-sType", offsetof( struct VkWriteDescriptorSetInlineUniformBlockEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkWriteDescriptorSetInlineUniformBlockEXT ) );

	swigComment("struct VkDescriptorPoolInlineUniformBlockCreateInfoEXT\n");
	printf( "begin-structure VkDescriptorPoolInlineUniformBlockCreateInfoEXT\n" );
	swigStructField( "VkDescriptorPoolInlineUniformBlockCreateInfoEXT-pNext", offsetof( struct VkDescriptorPoolInlineUniformBlockCreateInfoEXT, pNext ), sizeof( void const * ) );
	swigStructField( "VkDescriptorPoolInlineUniformBlockCreateInfoEXT-sType", offsetof( struct VkDescriptorPoolInlineUniformBlockCreateInfoEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkDescriptorPoolInlineUniformBlockCreateInfoEXT-maxInlineUniformBlockBindings", offsetof( struct VkDescriptorPoolInlineUniformBlockCreateInfoEXT, maxInlineUniformBlockBindings ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDescriptorPoolInlineUniformBlockCreateInfoEXT ) );

	swigComment("struct VkSampleLocationEXT\n");
	printf( "begin-structure VkSampleLocationEXT\n" );
	swigStructField( "VkSampleLocationEXT-x", offsetof( struct VkSampleLocationEXT, x ), sizeof( float ) );
	swigStructField( "VkSampleLocationEXT-y", offsetof( struct VkSampleLocationEXT, y ), sizeof( float ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSampleLocationEXT ) );

	swigComment("struct VkSampleLocationsInfoEXT\n");
	printf( "begin-structure VkSampleLocationsInfoEXT\n" );
	swigStructField( "VkSampleLocationsInfoEXT-pNext", offsetof( struct VkSampleLocationsInfoEXT, pNext ), sizeof( void const * ) );
	swigStructField( "VkSampleLocationsInfoEXT-sampleLocationsPerPixel", offsetof( struct VkSampleLocationsInfoEXT, sampleLocationsPerPixel ), sizeof( VkSampleCountFlagBits ) );
	swigStructField( "VkSampleLocationsInfoEXT-sampleLocationsCount", offsetof( struct VkSampleLocationsInfoEXT, sampleLocationsCount ), sizeof( uint32_t ) );
	swigStructField( "VkSampleLocationsInfoEXT-pSampleLocations", offsetof( struct VkSampleLocationsInfoEXT, pSampleLocations ), sizeof( VkSampleLocationEXT const * ) );
	swigStructField( "VkSampleLocationsInfoEXT-sType", offsetof( struct VkSampleLocationsInfoEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkSampleLocationsInfoEXT-sampleLocationGridSize", offsetof( struct VkSampleLocationsInfoEXT, sampleLocationGridSize ), sizeof( VkExtent2D ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSampleLocationsInfoEXT ) );

	swigComment("struct VkAttachmentSampleLocationsEXT\n");
	printf( "begin-structure VkAttachmentSampleLocationsEXT\n" );
	swigStructField( "VkAttachmentSampleLocationsEXT-attachmentIndex", offsetof( struct VkAttachmentSampleLocationsEXT, attachmentIndex ), sizeof( uint32_t ) );
	swigStructField( "VkAttachmentSampleLocationsEXT-sampleLocationsInfo", offsetof( struct VkAttachmentSampleLocationsEXT, sampleLocationsInfo ), sizeof( VkSampleLocationsInfoEXT ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkAttachmentSampleLocationsEXT ) );

	swigComment("struct VkSubpassSampleLocationsEXT\n");
	printf( "begin-structure VkSubpassSampleLocationsEXT\n" );
	swigStructField( "VkSubpassSampleLocationsEXT-subpassIndex", offsetof( struct VkSubpassSampleLocationsEXT, subpassIndex ), sizeof( uint32_t ) );
	swigStructField( "VkSubpassSampleLocationsEXT-sampleLocationsInfo", offsetof( struct VkSubpassSampleLocationsEXT, sampleLocationsInfo ), sizeof( VkSampleLocationsInfoEXT ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSubpassSampleLocationsEXT ) );

	swigComment("struct VkRenderPassSampleLocationsBeginInfoEXT\n");
	printf( "begin-structure VkRenderPassSampleLocationsBeginInfoEXT\n" );
	swigStructField( "VkRenderPassSampleLocationsBeginInfoEXT-pNext", offsetof( struct VkRenderPassSampleLocationsBeginInfoEXT, pNext ), sizeof( void const * ) );
	swigStructField( "VkRenderPassSampleLocationsBeginInfoEXT-attachmentInitialSampleLocationsCount", offsetof( struct VkRenderPassSampleLocationsBeginInfoEXT, attachmentInitialSampleLocationsCount ), sizeof( uint32_t ) );
	swigStructField( "VkRenderPassSampleLocationsBeginInfoEXT-pAttachmentInitialSampleLocations", offsetof( struct VkRenderPassSampleLocationsBeginInfoEXT, pAttachmentInitialSampleLocations ), sizeof( VkAttachmentSampleLocationsEXT const * ) );
	swigStructField( "VkRenderPassSampleLocationsBeginInfoEXT-postSubpassSampleLocationsCount", offsetof( struct VkRenderPassSampleLocationsBeginInfoEXT, postSubpassSampleLocationsCount ), sizeof( uint32_t ) );
	swigStructField( "VkRenderPassSampleLocationsBeginInfoEXT-pPostSubpassSampleLocations", offsetof( struct VkRenderPassSampleLocationsBeginInfoEXT, pPostSubpassSampleLocations ), sizeof( VkSubpassSampleLocationsEXT const * ) );
	swigStructField( "VkRenderPassSampleLocationsBeginInfoEXT-sType", offsetof( struct VkRenderPassSampleLocationsBeginInfoEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkRenderPassSampleLocationsBeginInfoEXT ) );

	swigComment("struct VkPipelineSampleLocationsStateCreateInfoEXT\n");
	printf( "begin-structure VkPipelineSampleLocationsStateCreateInfoEXT\n" );
	swigStructField( "VkPipelineSampleLocationsStateCreateInfoEXT-pNext", offsetof( struct VkPipelineSampleLocationsStateCreateInfoEXT, pNext ), sizeof( void const * ) );
	swigStructField( "VkPipelineSampleLocationsStateCreateInfoEXT-sampleLocationsEnable", offsetof( struct VkPipelineSampleLocationsStateCreateInfoEXT, sampleLocationsEnable ), sizeof( VkBool32 ) );
	swigStructField( "VkPipelineSampleLocationsStateCreateInfoEXT-sType", offsetof( struct VkPipelineSampleLocationsStateCreateInfoEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPipelineSampleLocationsStateCreateInfoEXT-sampleLocationsInfo", offsetof( struct VkPipelineSampleLocationsStateCreateInfoEXT, sampleLocationsInfo ), sizeof( VkSampleLocationsInfoEXT ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineSampleLocationsStateCreateInfoEXT ) );

	swigComment("struct VkPhysicalDeviceSampleLocationsPropertiesEXT\n");
	printf( "begin-structure VkPhysicalDeviceSampleLocationsPropertiesEXT\n" );
	swigStructField( "VkPhysicalDeviceSampleLocationsPropertiesEXT-sampleLocationCoordinateRange", offsetof( struct VkPhysicalDeviceSampleLocationsPropertiesEXT, sampleLocationCoordinateRange ), sizeof( float [2] ) );
	swigStructField( "VkPhysicalDeviceSampleLocationsPropertiesEXT-pNext", offsetof( struct VkPhysicalDeviceSampleLocationsPropertiesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceSampleLocationsPropertiesEXT-sampleLocationSampleCounts", offsetof( struct VkPhysicalDeviceSampleLocationsPropertiesEXT, sampleLocationSampleCounts ), sizeof( VkSampleCountFlags ) );
	swigStructField( "VkPhysicalDeviceSampleLocationsPropertiesEXT-sampleLocationSubPixelBits", offsetof( struct VkPhysicalDeviceSampleLocationsPropertiesEXT, sampleLocationSubPixelBits ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceSampleLocationsPropertiesEXT-variableSampleLocations", offsetof( struct VkPhysicalDeviceSampleLocationsPropertiesEXT, variableSampleLocations ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceSampleLocationsPropertiesEXT-sType", offsetof( struct VkPhysicalDeviceSampleLocationsPropertiesEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDeviceSampleLocationsPropertiesEXT-maxSampleLocationGridSize", offsetof( struct VkPhysicalDeviceSampleLocationsPropertiesEXT, maxSampleLocationGridSize ), sizeof( VkExtent2D ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceSampleLocationsPropertiesEXT ) );

	swigComment("struct VkMultisamplePropertiesEXT\n");
	printf( "begin-structure VkMultisamplePropertiesEXT\n" );
	swigStructField( "VkMultisamplePropertiesEXT-pNext", offsetof( struct VkMultisamplePropertiesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkMultisamplePropertiesEXT-sType", offsetof( struct VkMultisamplePropertiesEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkMultisamplePropertiesEXT-maxSampleLocationGridSize", offsetof( struct VkMultisamplePropertiesEXT, maxSampleLocationGridSize ), sizeof( VkExtent2D ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkMultisamplePropertiesEXT ) );

	swigComment("struct VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT\n");
	printf( "begin-structure VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT\n" );
	swigStructField( "VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT-pNext", offsetof( struct VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT-sType", offsetof( struct VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT-advancedBlendCoherentOperations", offsetof( struct VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT, advancedBlendCoherentOperations ), sizeof( VkBool32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT ) );

	swigComment("struct VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT\n");
	printf( "begin-structure VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT\n" );
	swigStructField( "VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT-advancedBlendIndependentBlend", offsetof( struct VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT, advancedBlendIndependentBlend ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT-pNext", offsetof( struct VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT-advancedBlendMaxColorAttachments", offsetof( struct VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT, advancedBlendMaxColorAttachments ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT-advancedBlendNonPremultipliedDstColor", offsetof( struct VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT, advancedBlendNonPremultipliedDstColor ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT-advancedBlendCorrelatedOverlap", offsetof( struct VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT, advancedBlendCorrelatedOverlap ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT-sType", offsetof( struct VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT-advancedBlendNonPremultipliedSrcColor", offsetof( struct VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT, advancedBlendNonPremultipliedSrcColor ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT-advancedBlendAllOperations", offsetof( struct VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT, advancedBlendAllOperations ), sizeof( VkBool32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT ) );

	swigComment("struct VkPipelineColorBlendAdvancedStateCreateInfoEXT\n");
	printf( "begin-structure VkPipelineColorBlendAdvancedStateCreateInfoEXT\n" );
	swigStructField( "VkPipelineColorBlendAdvancedStateCreateInfoEXT-pNext", offsetof( struct VkPipelineColorBlendAdvancedStateCreateInfoEXT, pNext ), sizeof( void const * ) );
	swigStructField( "VkPipelineColorBlendAdvancedStateCreateInfoEXT-srcPremultiplied", offsetof( struct VkPipelineColorBlendAdvancedStateCreateInfoEXT, srcPremultiplied ), sizeof( VkBool32 ) );
	swigStructField( "VkPipelineColorBlendAdvancedStateCreateInfoEXT-dstPremultiplied", offsetof( struct VkPipelineColorBlendAdvancedStateCreateInfoEXT, dstPremultiplied ), sizeof( VkBool32 ) );
	swigStructField( "VkPipelineColorBlendAdvancedStateCreateInfoEXT-blendOverlap", offsetof( struct VkPipelineColorBlendAdvancedStateCreateInfoEXT, blendOverlap ), sizeof( VkBlendOverlapEXT ) );
	swigStructField( "VkPipelineColorBlendAdvancedStateCreateInfoEXT-sType", offsetof( struct VkPipelineColorBlendAdvancedStateCreateInfoEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineColorBlendAdvancedStateCreateInfoEXT ) );

	swigComment("struct VkPipelineCoverageToColorStateCreateInfoNV\n");
	printf( "begin-structure VkPipelineCoverageToColorStateCreateInfoNV\n" );
	swigStructField( "VkPipelineCoverageToColorStateCreateInfoNV-coverageToColorLocation", offsetof( struct VkPipelineCoverageToColorStateCreateInfoNV, coverageToColorLocation ), sizeof( uint32_t ) );
	swigStructField( "VkPipelineCoverageToColorStateCreateInfoNV-pNext", offsetof( struct VkPipelineCoverageToColorStateCreateInfoNV, pNext ), sizeof( void const * ) );
	swigStructField( "VkPipelineCoverageToColorStateCreateInfoNV-coverageToColorEnable", offsetof( struct VkPipelineCoverageToColorStateCreateInfoNV, coverageToColorEnable ), sizeof( VkBool32 ) );
	swigStructField( "VkPipelineCoverageToColorStateCreateInfoNV-sType", offsetof( struct VkPipelineCoverageToColorStateCreateInfoNV, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPipelineCoverageToColorStateCreateInfoNV-flags", offsetof( struct VkPipelineCoverageToColorStateCreateInfoNV, flags ), sizeof( VkPipelineCoverageToColorStateCreateFlagsNV ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineCoverageToColorStateCreateInfoNV ) );

	swigComment("struct VkPipelineCoverageModulationStateCreateInfoNV\n");
	printf( "begin-structure VkPipelineCoverageModulationStateCreateInfoNV\n" );
	swigStructField( "VkPipelineCoverageModulationStateCreateInfoNV-pCoverageModulationTable", offsetof( struct VkPipelineCoverageModulationStateCreateInfoNV, pCoverageModulationTable ), sizeof( float const * ) );
	swigStructField( "VkPipelineCoverageModulationStateCreateInfoNV-pNext", offsetof( struct VkPipelineCoverageModulationStateCreateInfoNV, pNext ), sizeof( void const * ) );
	swigStructField( "VkPipelineCoverageModulationStateCreateInfoNV-coverageModulationMode", offsetof( struct VkPipelineCoverageModulationStateCreateInfoNV, coverageModulationMode ), sizeof( VkCoverageModulationModeNV ) );
	swigStructField( "VkPipelineCoverageModulationStateCreateInfoNV-coverageModulationTableEnable", offsetof( struct VkPipelineCoverageModulationStateCreateInfoNV, coverageModulationTableEnable ), sizeof( VkBool32 ) );
	swigStructField( "VkPipelineCoverageModulationStateCreateInfoNV-coverageModulationTableCount", offsetof( struct VkPipelineCoverageModulationStateCreateInfoNV, coverageModulationTableCount ), sizeof( uint32_t ) );
	swigStructField( "VkPipelineCoverageModulationStateCreateInfoNV-sType", offsetof( struct VkPipelineCoverageModulationStateCreateInfoNV, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPipelineCoverageModulationStateCreateInfoNV-flags", offsetof( struct VkPipelineCoverageModulationStateCreateInfoNV, flags ), sizeof( VkPipelineCoverageModulationStateCreateFlagsNV ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineCoverageModulationStateCreateInfoNV ) );

	swigComment("struct VkPhysicalDeviceShaderSMBuiltinsPropertiesNV\n");
	printf( "begin-structure VkPhysicalDeviceShaderSMBuiltinsPropertiesNV\n" );
	swigStructField( "VkPhysicalDeviceShaderSMBuiltinsPropertiesNV-pNext", offsetof( struct VkPhysicalDeviceShaderSMBuiltinsPropertiesNV, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceShaderSMBuiltinsPropertiesNV-sType", offsetof( struct VkPhysicalDeviceShaderSMBuiltinsPropertiesNV, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDeviceShaderSMBuiltinsPropertiesNV-shaderWarpsPerSM", offsetof( struct VkPhysicalDeviceShaderSMBuiltinsPropertiesNV, shaderWarpsPerSM ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceShaderSMBuiltinsPropertiesNV-shaderSMCount", offsetof( struct VkPhysicalDeviceShaderSMBuiltinsPropertiesNV, shaderSMCount ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceShaderSMBuiltinsPropertiesNV ) );

	swigComment("struct VkPhysicalDeviceShaderSMBuiltinsFeaturesNV\n");
	printf( "begin-structure VkPhysicalDeviceShaderSMBuiltinsFeaturesNV\n" );
	swigStructField( "VkPhysicalDeviceShaderSMBuiltinsFeaturesNV-pNext", offsetof( struct VkPhysicalDeviceShaderSMBuiltinsFeaturesNV, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceShaderSMBuiltinsFeaturesNV-shaderSMBuiltins", offsetof( struct VkPhysicalDeviceShaderSMBuiltinsFeaturesNV, shaderSMBuiltins ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderSMBuiltinsFeaturesNV-sType", offsetof( struct VkPhysicalDeviceShaderSMBuiltinsFeaturesNV, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceShaderSMBuiltinsFeaturesNV ) );

	swigComment("struct VkDrmFormatModifierPropertiesEXT\n");
	printf( "begin-structure VkDrmFormatModifierPropertiesEXT\n" );
	swigStructField( "VkDrmFormatModifierPropertiesEXT-drmFormatModifierTilingFeatures", offsetof( struct VkDrmFormatModifierPropertiesEXT, drmFormatModifierTilingFeatures ), sizeof( VkFormatFeatureFlags ) );
	swigStructField( "VkDrmFormatModifierPropertiesEXT-drmFormatModifierPlaneCount", offsetof( struct VkDrmFormatModifierPropertiesEXT, drmFormatModifierPlaneCount ), sizeof( uint32_t ) );
	swigStructField( "VkDrmFormatModifierPropertiesEXT-drmFormatModifier", offsetof( struct VkDrmFormatModifierPropertiesEXT, drmFormatModifier ), sizeof( uint64_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDrmFormatModifierPropertiesEXT ) );

	swigComment("struct VkDrmFormatModifierPropertiesListEXT\n");
	printf( "begin-structure VkDrmFormatModifierPropertiesListEXT\n" );
	swigStructField( "VkDrmFormatModifierPropertiesListEXT-pNext", offsetof( struct VkDrmFormatModifierPropertiesListEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkDrmFormatModifierPropertiesListEXT-drmFormatModifierCount", offsetof( struct VkDrmFormatModifierPropertiesListEXT, drmFormatModifierCount ), sizeof( uint32_t ) );
	swigStructField( "VkDrmFormatModifierPropertiesListEXT-pDrmFormatModifierProperties", offsetof( struct VkDrmFormatModifierPropertiesListEXT, pDrmFormatModifierProperties ), sizeof( VkDrmFormatModifierPropertiesEXT * ) );
	swigStructField( "VkDrmFormatModifierPropertiesListEXT-sType", offsetof( struct VkDrmFormatModifierPropertiesListEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDrmFormatModifierPropertiesListEXT ) );

	swigComment("struct VkPhysicalDeviceImageDrmFormatModifierInfoEXT\n");
	printf( "begin-structure VkPhysicalDeviceImageDrmFormatModifierInfoEXT\n" );
	swigStructField( "VkPhysicalDeviceImageDrmFormatModifierInfoEXT-pNext", offsetof( struct VkPhysicalDeviceImageDrmFormatModifierInfoEXT, pNext ), sizeof( void const * ) );
	swigStructField( "VkPhysicalDeviceImageDrmFormatModifierInfoEXT-sharingMode", offsetof( struct VkPhysicalDeviceImageDrmFormatModifierInfoEXT, sharingMode ), sizeof( VkSharingMode ) );
	swigStructField( "VkPhysicalDeviceImageDrmFormatModifierInfoEXT-pQueueFamilyIndices", offsetof( struct VkPhysicalDeviceImageDrmFormatModifierInfoEXT, pQueueFamilyIndices ), sizeof( uint32_t const * ) );
	swigStructField( "VkPhysicalDeviceImageDrmFormatModifierInfoEXT-sType", offsetof( struct VkPhysicalDeviceImageDrmFormatModifierInfoEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDeviceImageDrmFormatModifierInfoEXT-drmFormatModifier", offsetof( struct VkPhysicalDeviceImageDrmFormatModifierInfoEXT, drmFormatModifier ), sizeof( uint64_t ) );
	swigStructField( "VkPhysicalDeviceImageDrmFormatModifierInfoEXT-queueFamilyIndexCount", offsetof( struct VkPhysicalDeviceImageDrmFormatModifierInfoEXT, queueFamilyIndexCount ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceImageDrmFormatModifierInfoEXT ) );

	swigComment("struct VkImageDrmFormatModifierListCreateInfoEXT\n");
	printf( "begin-structure VkImageDrmFormatModifierListCreateInfoEXT\n" );
	swigStructField( "VkImageDrmFormatModifierListCreateInfoEXT-pNext", offsetof( struct VkImageDrmFormatModifierListCreateInfoEXT, pNext ), sizeof( void const * ) );
	swigStructField( "VkImageDrmFormatModifierListCreateInfoEXT-drmFormatModifierCount", offsetof( struct VkImageDrmFormatModifierListCreateInfoEXT, drmFormatModifierCount ), sizeof( uint32_t ) );
	swigStructField( "VkImageDrmFormatModifierListCreateInfoEXT-pDrmFormatModifiers", offsetof( struct VkImageDrmFormatModifierListCreateInfoEXT, pDrmFormatModifiers ), sizeof( uint64_t const * ) );
	swigStructField( "VkImageDrmFormatModifierListCreateInfoEXT-sType", offsetof( struct VkImageDrmFormatModifierListCreateInfoEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkImageDrmFormatModifierListCreateInfoEXT ) );

	swigComment("struct VkImageDrmFormatModifierExplicitCreateInfoEXT\n");
	printf( "begin-structure VkImageDrmFormatModifierExplicitCreateInfoEXT\n" );
	swigStructField( "VkImageDrmFormatModifierExplicitCreateInfoEXT-pNext", offsetof( struct VkImageDrmFormatModifierExplicitCreateInfoEXT, pNext ), sizeof( void const * ) );
	swigStructField( "VkImageDrmFormatModifierExplicitCreateInfoEXT-drmFormatModifierPlaneCount", offsetof( struct VkImageDrmFormatModifierExplicitCreateInfoEXT, drmFormatModifierPlaneCount ), sizeof( uint32_t ) );
	swigStructField( "VkImageDrmFormatModifierExplicitCreateInfoEXT-pPlaneLayouts", offsetof( struct VkImageDrmFormatModifierExplicitCreateInfoEXT, pPlaneLayouts ), sizeof( VkSubresourceLayout const * ) );
	swigStructField( "VkImageDrmFormatModifierExplicitCreateInfoEXT-sType", offsetof( struct VkImageDrmFormatModifierExplicitCreateInfoEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkImageDrmFormatModifierExplicitCreateInfoEXT-drmFormatModifier", offsetof( struct VkImageDrmFormatModifierExplicitCreateInfoEXT, drmFormatModifier ), sizeof( uint64_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkImageDrmFormatModifierExplicitCreateInfoEXT ) );

	swigComment("struct VkImageDrmFormatModifierPropertiesEXT\n");
	printf( "begin-structure VkImageDrmFormatModifierPropertiesEXT\n" );
	swigStructField( "VkImageDrmFormatModifierPropertiesEXT-pNext", offsetof( struct VkImageDrmFormatModifierPropertiesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkImageDrmFormatModifierPropertiesEXT-sType", offsetof( struct VkImageDrmFormatModifierPropertiesEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkImageDrmFormatModifierPropertiesEXT-drmFormatModifier", offsetof( struct VkImageDrmFormatModifierPropertiesEXT, drmFormatModifier ), sizeof( uint64_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkImageDrmFormatModifierPropertiesEXT ) );

	swigComment("struct VkDrmFormatModifierProperties2EXT\n");
	printf( "begin-structure VkDrmFormatModifierProperties2EXT\n" );
	swigStructField( "VkDrmFormatModifierProperties2EXT-drmFormatModifierTilingFeatures", offsetof( struct VkDrmFormatModifierProperties2EXT, drmFormatModifierTilingFeatures ), sizeof( VkFormatFeatureFlags2KHR ) );
	swigStructField( "VkDrmFormatModifierProperties2EXT-drmFormatModifierPlaneCount", offsetof( struct VkDrmFormatModifierProperties2EXT, drmFormatModifierPlaneCount ), sizeof( uint32_t ) );
	swigStructField( "VkDrmFormatModifierProperties2EXT-drmFormatModifier", offsetof( struct VkDrmFormatModifierProperties2EXT, drmFormatModifier ), sizeof( uint64_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDrmFormatModifierProperties2EXT ) );

	swigComment("struct VkDrmFormatModifierPropertiesList2EXT\n");
	printf( "begin-structure VkDrmFormatModifierPropertiesList2EXT\n" );
	swigStructField( "VkDrmFormatModifierPropertiesList2EXT-pNext", offsetof( struct VkDrmFormatModifierPropertiesList2EXT, pNext ), sizeof( void * ) );
	swigStructField( "VkDrmFormatModifierPropertiesList2EXT-drmFormatModifierCount", offsetof( struct VkDrmFormatModifierPropertiesList2EXT, drmFormatModifierCount ), sizeof( uint32_t ) );
	swigStructField( "VkDrmFormatModifierPropertiesList2EXT-pDrmFormatModifierProperties", offsetof( struct VkDrmFormatModifierPropertiesList2EXT, pDrmFormatModifierProperties ), sizeof( VkDrmFormatModifierProperties2EXT * ) );
	swigStructField( "VkDrmFormatModifierPropertiesList2EXT-sType", offsetof( struct VkDrmFormatModifierPropertiesList2EXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDrmFormatModifierPropertiesList2EXT ) );

	swigComment("struct VkValidationCacheCreateInfoEXT\n");
	printf( "begin-structure VkValidationCacheCreateInfoEXT\n" );
	swigStructField( "VkValidationCacheCreateInfoEXT-pNext", offsetof( struct VkValidationCacheCreateInfoEXT, pNext ), sizeof( void const * ) );
	swigStructField( "VkValidationCacheCreateInfoEXT-initialDataSize", offsetof( struct VkValidationCacheCreateInfoEXT, initialDataSize ), sizeof( size_t ) );
	swigStructField( "VkValidationCacheCreateInfoEXT-pInitialData", offsetof( struct VkValidationCacheCreateInfoEXT, pInitialData ), sizeof( void const * ) );
	swigStructField( "VkValidationCacheCreateInfoEXT-sType", offsetof( struct VkValidationCacheCreateInfoEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkValidationCacheCreateInfoEXT-flags", offsetof( struct VkValidationCacheCreateInfoEXT, flags ), sizeof( VkValidationCacheCreateFlagsEXT ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkValidationCacheCreateInfoEXT ) );

	swigComment("struct VkShaderModuleValidationCacheCreateInfoEXT\n");
	printf( "begin-structure VkShaderModuleValidationCacheCreateInfoEXT\n" );
	swigStructField( "VkShaderModuleValidationCacheCreateInfoEXT-pNext", offsetof( struct VkShaderModuleValidationCacheCreateInfoEXT, pNext ), sizeof( void const * ) );
	swigStructField( "VkShaderModuleValidationCacheCreateInfoEXT-validationCache", offsetof( struct VkShaderModuleValidationCacheCreateInfoEXT, validationCache ), sizeof( VkValidationCacheEXT ) );
	swigStructField( "VkShaderModuleValidationCacheCreateInfoEXT-sType", offsetof( struct VkShaderModuleValidationCacheCreateInfoEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkShaderModuleValidationCacheCreateInfoEXT ) );

	swigComment("struct VkShadingRatePaletteNV\n");
	printf( "begin-structure VkShadingRatePaletteNV\n" );
	swigStructField( "VkShadingRatePaletteNV-shadingRatePaletteEntryCount", offsetof( struct VkShadingRatePaletteNV, shadingRatePaletteEntryCount ), sizeof( uint32_t ) );
	swigStructField( "VkShadingRatePaletteNV-pShadingRatePaletteEntries", offsetof( struct VkShadingRatePaletteNV, pShadingRatePaletteEntries ), sizeof( VkShadingRatePaletteEntryNV const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkShadingRatePaletteNV ) );

	swigComment("struct VkPipelineViewportShadingRateImageStateCreateInfoNV\n");
	printf( "begin-structure VkPipelineViewportShadingRateImageStateCreateInfoNV\n" );
	swigStructField( "VkPipelineViewportShadingRateImageStateCreateInfoNV-pShadingRatePalettes", offsetof( struct VkPipelineViewportShadingRateImageStateCreateInfoNV, pShadingRatePalettes ), sizeof( VkShadingRatePaletteNV const * ) );
	swigStructField( "VkPipelineViewportShadingRateImageStateCreateInfoNV-pNext", offsetof( struct VkPipelineViewportShadingRateImageStateCreateInfoNV, pNext ), sizeof( void const * ) );
	swigStructField( "VkPipelineViewportShadingRateImageStateCreateInfoNV-shadingRateImageEnable", offsetof( struct VkPipelineViewportShadingRateImageStateCreateInfoNV, shadingRateImageEnable ), sizeof( VkBool32 ) );
	swigStructField( "VkPipelineViewportShadingRateImageStateCreateInfoNV-sType", offsetof( struct VkPipelineViewportShadingRateImageStateCreateInfoNV, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPipelineViewportShadingRateImageStateCreateInfoNV-viewportCount", offsetof( struct VkPipelineViewportShadingRateImageStateCreateInfoNV, viewportCount ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineViewportShadingRateImageStateCreateInfoNV ) );

	swigComment("struct VkPhysicalDeviceShadingRateImageFeaturesNV\n");
	printf( "begin-structure VkPhysicalDeviceShadingRateImageFeaturesNV\n" );
	swigStructField( "VkPhysicalDeviceShadingRateImageFeaturesNV-pNext", offsetof( struct VkPhysicalDeviceShadingRateImageFeaturesNV, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceShadingRateImageFeaturesNV-shadingRateCoarseSampleOrder", offsetof( struct VkPhysicalDeviceShadingRateImageFeaturesNV, shadingRateCoarseSampleOrder ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShadingRateImageFeaturesNV-sType", offsetof( struct VkPhysicalDeviceShadingRateImageFeaturesNV, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDeviceShadingRateImageFeaturesNV-shadingRateImage", offsetof( struct VkPhysicalDeviceShadingRateImageFeaturesNV, shadingRateImage ), sizeof( VkBool32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceShadingRateImageFeaturesNV ) );

	swigComment("struct VkPhysicalDeviceShadingRateImagePropertiesNV\n");
	printf( "begin-structure VkPhysicalDeviceShadingRateImagePropertiesNV\n" );
	swigStructField( "VkPhysicalDeviceShadingRateImagePropertiesNV-pNext", offsetof( struct VkPhysicalDeviceShadingRateImagePropertiesNV, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceShadingRateImagePropertiesNV-shadingRateTexelSize", offsetof( struct VkPhysicalDeviceShadingRateImagePropertiesNV, shadingRateTexelSize ), sizeof( VkExtent2D ) );
	swigStructField( "VkPhysicalDeviceShadingRateImagePropertiesNV-shadingRatePaletteSize", offsetof( struct VkPhysicalDeviceShadingRateImagePropertiesNV, shadingRatePaletteSize ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceShadingRateImagePropertiesNV-shadingRateMaxCoarseSamples", offsetof( struct VkPhysicalDeviceShadingRateImagePropertiesNV, shadingRateMaxCoarseSamples ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceShadingRateImagePropertiesNV-sType", offsetof( struct VkPhysicalDeviceShadingRateImagePropertiesNV, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceShadingRateImagePropertiesNV ) );

	swigComment("struct VkCoarseSampleLocationNV\n");
	printf( "begin-structure VkCoarseSampleLocationNV\n" );
	swigStructField( "VkCoarseSampleLocationNV-pixelX", offsetof( struct VkCoarseSampleLocationNV, pixelX ), sizeof( uint32_t ) );
	swigStructField( "VkCoarseSampleLocationNV-pixelY", offsetof( struct VkCoarseSampleLocationNV, pixelY ), sizeof( uint32_t ) );
	swigStructField( "VkCoarseSampleLocationNV-sample", offsetof( struct VkCoarseSampleLocationNV, sample ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkCoarseSampleLocationNV ) );

	swigComment("struct VkCoarseSampleOrderCustomNV\n");
	printf( "begin-structure VkCoarseSampleOrderCustomNV\n" );
	swigStructField( "VkCoarseSampleOrderCustomNV-shadingRate", offsetof( struct VkCoarseSampleOrderCustomNV, shadingRate ), sizeof( VkShadingRatePaletteEntryNV ) );
	swigStructField( "VkCoarseSampleOrderCustomNV-sampleLocationCount", offsetof( struct VkCoarseSampleOrderCustomNV, sampleLocationCount ), sizeof( uint32_t ) );
	swigStructField( "VkCoarseSampleOrderCustomNV-sampleCount", offsetof( struct VkCoarseSampleOrderCustomNV, sampleCount ), sizeof( uint32_t ) );
	swigStructField( "VkCoarseSampleOrderCustomNV-pSampleLocations", offsetof( struct VkCoarseSampleOrderCustomNV, pSampleLocations ), sizeof( VkCoarseSampleLocationNV const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkCoarseSampleOrderCustomNV ) );

	swigComment("struct VkPipelineViewportCoarseSampleOrderStateCreateInfoNV\n");
	printf( "begin-structure VkPipelineViewportCoarseSampleOrderStateCreateInfoNV\n" );
	swigStructField( "VkPipelineViewportCoarseSampleOrderStateCreateInfoNV-pNext", offsetof( struct VkPipelineViewportCoarseSampleOrderStateCreateInfoNV, pNext ), sizeof( void const * ) );
	swigStructField( "VkPipelineViewportCoarseSampleOrderStateCreateInfoNV-customSampleOrderCount", offsetof( struct VkPipelineViewportCoarseSampleOrderStateCreateInfoNV, customSampleOrderCount ), sizeof( uint32_t ) );
	swigStructField( "VkPipelineViewportCoarseSampleOrderStateCreateInfoNV-pCustomSampleOrders", offsetof( struct VkPipelineViewportCoarseSampleOrderStateCreateInfoNV, pCustomSampleOrders ), sizeof( VkCoarseSampleOrderCustomNV const * ) );
	swigStructField( "VkPipelineViewportCoarseSampleOrderStateCreateInfoNV-sType", offsetof( struct VkPipelineViewportCoarseSampleOrderStateCreateInfoNV, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPipelineViewportCoarseSampleOrderStateCreateInfoNV-sampleOrderType", offsetof( struct VkPipelineViewportCoarseSampleOrderStateCreateInfoNV, sampleOrderType ), sizeof( VkCoarseSampleOrderTypeNV ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineViewportCoarseSampleOrderStateCreateInfoNV ) );

	swigComment("struct VkRayTracingShaderGroupCreateInfoNV\n");
	printf( "begin-structure VkRayTracingShaderGroupCreateInfoNV\n" );
	swigStructField( "VkRayTracingShaderGroupCreateInfoNV-pNext", offsetof( struct VkRayTracingShaderGroupCreateInfoNV, pNext ), sizeof( void const * ) );
	swigStructField( "VkRayTracingShaderGroupCreateInfoNV-generalShader", offsetof( struct VkRayTracingShaderGroupCreateInfoNV, generalShader ), sizeof( uint32_t ) );
	swigStructField( "VkRayTracingShaderGroupCreateInfoNV-closestHitShader", offsetof( struct VkRayTracingShaderGroupCreateInfoNV, closestHitShader ), sizeof( uint32_t ) );
	swigStructField( "VkRayTracingShaderGroupCreateInfoNV-anyHitShader", offsetof( struct VkRayTracingShaderGroupCreateInfoNV, anyHitShader ), sizeof( uint32_t ) );
	swigStructField( "VkRayTracingShaderGroupCreateInfoNV-intersectionShader", offsetof( struct VkRayTracingShaderGroupCreateInfoNV, intersectionShader ), sizeof( uint32_t ) );
	swigStructField( "VkRayTracingShaderGroupCreateInfoNV-type", offsetof( struct VkRayTracingShaderGroupCreateInfoNV, type ), sizeof( VkRayTracingShaderGroupTypeKHR ) );
	swigStructField( "VkRayTracingShaderGroupCreateInfoNV-sType", offsetof( struct VkRayTracingShaderGroupCreateInfoNV, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkRayTracingShaderGroupCreateInfoNV ) );

	swigComment("struct VkRayTracingPipelineCreateInfoNV\n");
	printf( "begin-structure VkRayTracingPipelineCreateInfoNV\n" );
	swigStructField( "VkRayTracingPipelineCreateInfoNV-pNext", offsetof( struct VkRayTracingPipelineCreateInfoNV, pNext ), sizeof( void const * ) );
	swigStructField( "VkRayTracingPipelineCreateInfoNV-pStages", offsetof( struct VkRayTracingPipelineCreateInfoNV, pStages ), sizeof( VkPipelineShaderStageCreateInfo const * ) );
	swigStructField( "VkRayTracingPipelineCreateInfoNV-basePipelineHandle", offsetof( struct VkRayTracingPipelineCreateInfoNV, basePipelineHandle ), sizeof( VkPipeline ) );
	swigStructField( "VkRayTracingPipelineCreateInfoNV-stageCount", offsetof( struct VkRayTracingPipelineCreateInfoNV, stageCount ), sizeof( uint32_t ) );
	swigStructField( "VkRayTracingPipelineCreateInfoNV-maxRecursionDepth", offsetof( struct VkRayTracingPipelineCreateInfoNV, maxRecursionDepth ), sizeof( uint32_t ) );
	swigStructField( "VkRayTracingPipelineCreateInfoNV-layout", offsetof( struct VkRayTracingPipelineCreateInfoNV, layout ), sizeof( VkPipelineLayout ) );
	swigStructField( "VkRayTracingPipelineCreateInfoNV-basePipelineIndex", offsetof( struct VkRayTracingPipelineCreateInfoNV, basePipelineIndex ), sizeof( int32_t ) );
	swigStructField( "VkRayTracingPipelineCreateInfoNV-groupCount", offsetof( struct VkRayTracingPipelineCreateInfoNV, groupCount ), sizeof( uint32_t ) );
	swigStructField( "VkRayTracingPipelineCreateInfoNV-sType", offsetof( struct VkRayTracingPipelineCreateInfoNV, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkRayTracingPipelineCreateInfoNV-flags", offsetof( struct VkRayTracingPipelineCreateInfoNV, flags ), sizeof( VkPipelineCreateFlags ) );
	swigStructField( "VkRayTracingPipelineCreateInfoNV-pGroups", offsetof( struct VkRayTracingPipelineCreateInfoNV, pGroups ), sizeof( VkRayTracingShaderGroupCreateInfoNV const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkRayTracingPipelineCreateInfoNV ) );

	swigComment("struct VkGeometryTrianglesNV\n");
	printf( "begin-structure VkGeometryTrianglesNV\n" );
	swigStructField( "VkGeometryTrianglesNV-transformData", offsetof( struct VkGeometryTrianglesNV, transformData ), sizeof( VkBuffer ) );
	swigStructField( "VkGeometryTrianglesNV-pNext", offsetof( struct VkGeometryTrianglesNV, pNext ), sizeof( void const * ) );
	swigStructField( "VkGeometryTrianglesNV-indexType", offsetof( struct VkGeometryTrianglesNV, indexType ), sizeof( VkIndexType ) );
	swigStructField( "VkGeometryTrianglesNV-vertexOffset", offsetof( struct VkGeometryTrianglesNV, vertexOffset ), sizeof( VkDeviceSize ) );
	swigStructField( "VkGeometryTrianglesNV-indexOffset", offsetof( struct VkGeometryTrianglesNV, indexOffset ), sizeof( VkDeviceSize ) );
	swigStructField( "VkGeometryTrianglesNV-transformOffset", offsetof( struct VkGeometryTrianglesNV, transformOffset ), sizeof( VkDeviceSize ) );
	swigStructField( "VkGeometryTrianglesNV-vertexStride", offsetof( struct VkGeometryTrianglesNV, vertexStride ), sizeof( VkDeviceSize ) );
	swigStructField( "VkGeometryTrianglesNV-vertexFormat", offsetof( struct VkGeometryTrianglesNV, vertexFormat ), sizeof( VkFormat ) );
	swigStructField( "VkGeometryTrianglesNV-sType", offsetof( struct VkGeometryTrianglesNV, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkGeometryTrianglesNV-vertexData", offsetof( struct VkGeometryTrianglesNV, vertexData ), sizeof( VkBuffer ) );
	swigStructField( "VkGeometryTrianglesNV-indexData", offsetof( struct VkGeometryTrianglesNV, indexData ), sizeof( VkBuffer ) );
	swigStructField( "VkGeometryTrianglesNV-vertexCount", offsetof( struct VkGeometryTrianglesNV, vertexCount ), sizeof( uint32_t ) );
	swigStructField( "VkGeometryTrianglesNV-indexCount", offsetof( struct VkGeometryTrianglesNV, indexCount ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkGeometryTrianglesNV ) );

	swigComment("struct VkGeometryAABBNV\n");
	printf( "begin-structure VkGeometryAABBNV\n" );
	swigStructField( "VkGeometryAABBNV-pNext", offsetof( struct VkGeometryAABBNV, pNext ), sizeof( void const * ) );
	swigStructField( "VkGeometryAABBNV-aabbData", offsetof( struct VkGeometryAABBNV, aabbData ), sizeof( VkBuffer ) );
	swigStructField( "VkGeometryAABBNV-numAABBs", offsetof( struct VkGeometryAABBNV, numAABBs ), sizeof( uint32_t ) );
	swigStructField( "VkGeometryAABBNV-offset", offsetof( struct VkGeometryAABBNV, offset ), sizeof( VkDeviceSize ) );
	swigStructField( "VkGeometryAABBNV-sType", offsetof( struct VkGeometryAABBNV, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkGeometryAABBNV-stride", offsetof( struct VkGeometryAABBNV, stride ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkGeometryAABBNV ) );

	swigComment("struct VkGeometryDataNV\n");
	printf( "begin-structure VkGeometryDataNV\n" );
	swigStructField( "VkGeometryDataNV-aabbs", offsetof( struct VkGeometryDataNV, aabbs ), sizeof( VkGeometryAABBNV ) );
	swigStructField( "VkGeometryDataNV-triangles", offsetof( struct VkGeometryDataNV, triangles ), sizeof( VkGeometryTrianglesNV ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkGeometryDataNV ) );

	swigComment("struct VkGeometryNV\n");
	printf( "begin-structure VkGeometryNV\n" );
	swigStructField( "VkGeometryNV-pNext", offsetof( struct VkGeometryNV, pNext ), sizeof( void const * ) );
	swigStructField( "VkGeometryNV-geometryType", offsetof( struct VkGeometryNV, geometryType ), sizeof( VkGeometryTypeKHR ) );
	swigStructField( "VkGeometryNV-geometry", offsetof( struct VkGeometryNV, geometry ), sizeof( VkGeometryDataNV ) );
	swigStructField( "VkGeometryNV-sType", offsetof( struct VkGeometryNV, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkGeometryNV-flags", offsetof( struct VkGeometryNV, flags ), sizeof( VkGeometryFlagsKHR ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkGeometryNV ) );

// 	swigComment("struct VkAccelerationStructureInfoNV\n");
// 	printf( "begin-structure VkAccelerationStructureInfoNV\n" );
// 	swigStructField( "VkAccelerationStructureInfoNV-pNext", offsetof( struct VkAccelerationStructureInfoNV, pNext ), sizeof( void const * ) );
// 	swigStructField( "VkAccelerationStructureInfoNV-pGeometries", offsetof( struct VkAccelerationStructureInfoNV, pGeometries ), sizeof( VkGeometryNV const * ) );
// 	swigStructField( "VkAccelerationStructureInfoNV-geometryCount", offsetof( struct VkAccelerationStructureInfoNV, geometryCount ), sizeof( uint32_t ) );
// 	swigStructField( "VkAccelerationStructureInfoNV-instanceCount", offsetof( struct VkAccelerationStructureInfoNV, instanceCount ), sizeof( uint32_t ) );
// 	swigStructField( "VkAccelerationStructureInfoNV-type", offsetof( struct VkAccelerationStructureInfoNV, type ), sizeof( VkAccelerationStructureTypeNV ) );
// 	swigStructField( "VkAccelerationStructureInfoNV-sType", offsetof( struct VkAccelerationStructureInfoNV, sType ), sizeof( VkStructureType ) );
// 	swigStructField( "VkAccelerationStructureInfoNV-flags", offsetof( struct VkAccelerationStructureInfoNV, flags ), sizeof( VkBuildAccelerationStructureFlagsNV ) );
// 	printf( "drop %zu end-structure\n", sizeof( struct VkAccelerationStructureInfoNV ) );

// 	swigComment("struct VkAccelerationStructureCreateInfoNV\n");
// 	printf( "begin-structure VkAccelerationStructureCreateInfoNV\n" );
// 	swigStructField( "VkAccelerationStructureCreateInfoNV-pNext", offsetof( struct VkAccelerationStructureCreateInfoNV, pNext ), sizeof( void const * ) );
// 	swigStructField( "VkAccelerationStructureCreateInfoNV-info", offsetof( struct VkAccelerationStructureCreateInfoNV, info ), sizeof( VkAccelerationStructureInfoNV ) );
// 	swigStructField( "VkAccelerationStructureCreateInfoNV-sType", offsetof( struct VkAccelerationStructureCreateInfoNV, sType ), sizeof( VkStructureType ) );
// 	swigStructField( "VkAccelerationStructureCreateInfoNV-compactedSize", offsetof( struct VkAccelerationStructureCreateInfoNV, compactedSize ), sizeof( VkDeviceSize ) );
// 	printf( "drop %zu end-structure\n", sizeof( struct VkAccelerationStructureCreateInfoNV ) );

	swigComment("struct VkBindAccelerationStructureMemoryInfoNV\n");
	printf( "begin-structure VkBindAccelerationStructureMemoryInfoNV\n" );
	swigStructField( "VkBindAccelerationStructureMemoryInfoNV-pNext", offsetof( struct VkBindAccelerationStructureMemoryInfoNV, pNext ), sizeof( void const * ) );
// 	swigStructField( "VkBindAccelerationStructureMemoryInfoNV-accelerationStructure", offsetof( struct VkBindAccelerationStructureMemoryInfoNV, accelerationStructure ), sizeof( VkAccelerationStructureNV ) );
	swigStructField( "VkBindAccelerationStructureMemoryInfoNV-memory", offsetof( struct VkBindAccelerationStructureMemoryInfoNV, memory ), sizeof( VkDeviceMemory ) );
	swigStructField( "VkBindAccelerationStructureMemoryInfoNV-memoryOffset", offsetof( struct VkBindAccelerationStructureMemoryInfoNV, memoryOffset ), sizeof( VkDeviceSize ) );
	swigStructField( "VkBindAccelerationStructureMemoryInfoNV-pDeviceIndices", offsetof( struct VkBindAccelerationStructureMemoryInfoNV, pDeviceIndices ), sizeof( uint32_t const * ) );
	swigStructField( "VkBindAccelerationStructureMemoryInfoNV-sType", offsetof( struct VkBindAccelerationStructureMemoryInfoNV, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkBindAccelerationStructureMemoryInfoNV-deviceIndexCount", offsetof( struct VkBindAccelerationStructureMemoryInfoNV, deviceIndexCount ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkBindAccelerationStructureMemoryInfoNV ) );

	swigComment("struct VkWriteDescriptorSetAccelerationStructureNV\n");
	printf( "begin-structure VkWriteDescriptorSetAccelerationStructureNV\n" );
	swigStructField( "VkWriteDescriptorSetAccelerationStructureNV-pNext", offsetof( struct VkWriteDescriptorSetAccelerationStructureNV, pNext ), sizeof( void const * ) );
	swigStructField( "VkWriteDescriptorSetAccelerationStructureNV-accelerationStructureCount", offsetof( struct VkWriteDescriptorSetAccelerationStructureNV, accelerationStructureCount ), sizeof( uint32_t ) );
// 	swigStructField( "VkWriteDescriptorSetAccelerationStructureNV-pAccelerationStructures", offsetof( struct VkWriteDescriptorSetAccelerationStructureNV, pAccelerationStructures ), sizeof( VkAccelerationStructureNV const * ) );
	swigStructField( "VkWriteDescriptorSetAccelerationStructureNV-sType", offsetof( struct VkWriteDescriptorSetAccelerationStructureNV, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkWriteDescriptorSetAccelerationStructureNV ) );

// 	swigComment("struct VkAccelerationStructureMemoryRequirementsInfoNV\n");
// 	printf( "begin-structure VkAccelerationStructureMemoryRequirementsInfoNV\n" );
// 	swigStructField( "VkAccelerationStructureMemoryRequirementsInfoNV-pNext", offsetof( struct VkAccelerationStructureMemoryRequirementsInfoNV, pNext ), sizeof( void const * ) );
// 	swigStructField( "VkAccelerationStructureMemoryRequirementsInfoNV-accelerationStructure", offsetof( struct VkAccelerationStructureMemoryRequirementsInfoNV, accelerationStructure ), sizeof( VkAccelerationStructureNV ) );
// 	swigStructField( "VkAccelerationStructureMemoryRequirementsInfoNV-type", offsetof( struct VkAccelerationStructureMemoryRequirementsInfoNV, type ), sizeof( VkAccelerationStructureMemoryRequirementsTypeNV ) );
// 	swigStructField( "VkAccelerationStructureMemoryRequirementsInfoNV-sType", offsetof( struct VkAccelerationStructureMemoryRequirementsInfoNV, sType ), sizeof( VkStructureType ) );
// 	printf( "drop %zu end-structure\n", sizeof( struct VkAccelerationStructureMemoryRequirementsInfoNV ) );

	swigComment("struct VkPhysicalDeviceRayTracingPropertiesNV\n");
	printf( "begin-structure VkPhysicalDeviceRayTracingPropertiesNV\n" );
	swigStructField( "VkPhysicalDeviceRayTracingPropertiesNV-pNext", offsetof( struct VkPhysicalDeviceRayTracingPropertiesNV, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceRayTracingPropertiesNV-shaderGroupHandleSize", offsetof( struct VkPhysicalDeviceRayTracingPropertiesNV, shaderGroupHandleSize ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceRayTracingPropertiesNV-maxGeometryCount", offsetof( struct VkPhysicalDeviceRayTracingPropertiesNV, maxGeometryCount ), sizeof( uint64_t ) );
	swigStructField( "VkPhysicalDeviceRayTracingPropertiesNV-maxRecursionDepth", offsetof( struct VkPhysicalDeviceRayTracingPropertiesNV, maxRecursionDepth ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceRayTracingPropertiesNV-maxInstanceCount", offsetof( struct VkPhysicalDeviceRayTracingPropertiesNV, maxInstanceCount ), sizeof( uint64_t ) );
	swigStructField( "VkPhysicalDeviceRayTracingPropertiesNV-maxShaderGroupStride", offsetof( struct VkPhysicalDeviceRayTracingPropertiesNV, maxShaderGroupStride ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceRayTracingPropertiesNV-maxTriangleCount", offsetof( struct VkPhysicalDeviceRayTracingPropertiesNV, maxTriangleCount ), sizeof( uint64_t ) );
	swigStructField( "VkPhysicalDeviceRayTracingPropertiesNV-maxDescriptorSetAccelerationStructures", offsetof( struct VkPhysicalDeviceRayTracingPropertiesNV, maxDescriptorSetAccelerationStructures ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceRayTracingPropertiesNV-sType", offsetof( struct VkPhysicalDeviceRayTracingPropertiesNV, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDeviceRayTracingPropertiesNV-shaderGroupBaseAlignment", offsetof( struct VkPhysicalDeviceRayTracingPropertiesNV, shaderGroupBaseAlignment ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceRayTracingPropertiesNV ) );

	swigComment("struct VkTransformMatrixKHR\n");
	printf( "begin-structure VkTransformMatrixKHR\n" );
	swigStructField( "VkTransformMatrixKHR-matrix", offsetof( struct VkTransformMatrixKHR, matrix ), sizeof( float [3][4] ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkTransformMatrixKHR ) );

	swigComment("struct VkAabbPositionsKHR\n");
	printf( "begin-structure VkAabbPositionsKHR\n" );
	swigStructField( "VkAabbPositionsKHR-minX", offsetof( struct VkAabbPositionsKHR, minX ), sizeof( float ) );
	swigStructField( "VkAabbPositionsKHR-minY", offsetof( struct VkAabbPositionsKHR, minY ), sizeof( float ) );
	swigStructField( "VkAabbPositionsKHR-minZ", offsetof( struct VkAabbPositionsKHR, minZ ), sizeof( float ) );
	swigStructField( "VkAabbPositionsKHR-maxX", offsetof( struct VkAabbPositionsKHR, maxX ), sizeof( float ) );
	swigStructField( "VkAabbPositionsKHR-maxY", offsetof( struct VkAabbPositionsKHR, maxY ), sizeof( float ) );
	swigStructField( "VkAabbPositionsKHR-maxZ", offsetof( struct VkAabbPositionsKHR, maxZ ), sizeof( float ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkAabbPositionsKHR ) );

// 	swigComment("struct VkAccelerationStructureInstanceKHR\n");
// 	printf( "begin-structure VkAccelerationStructureInstanceKHR\n" );
// 	swigStructField( "VkAccelerationStructureInstanceKHR-mask", offsetof( struct VkAccelerationStructureInstanceKHR, mask ), sizeof( uint32_t ) );
// 	swigStructField( "VkAccelerationStructureInstanceKHR-instanceShaderBindingTableRecordOffset", offsetof( struct VkAccelerationStructureInstanceKHR, instanceShaderBindingTableRecordOffset ), sizeof( uint32_t ) );
// 	swigStructField( "VkAccelerationStructureInstanceKHR-instanceCustomIndex", offsetof( struct VkAccelerationStructureInstanceKHR, instanceCustomIndex ), sizeof( uint32_t ) );
// 	swigStructField( "VkAccelerationStructureInstanceKHR-accelerationStructureReference", offsetof( struct VkAccelerationStructureInstanceKHR, accelerationStructureReference ), sizeof( uint64_t ) );
// 	swigStructField( "VkAccelerationStructureInstanceKHR-transform", offsetof( struct VkAccelerationStructureInstanceKHR, transform ), sizeof( VkTransformMatrixKHR ) );
// 	swigStructField( "VkAccelerationStructureInstanceKHR-flags", offsetof( struct VkAccelerationStructureInstanceKHR, flags ), sizeof( VkGeometryInstanceFlagsKHR ) );
// 	printf( "drop %zu end-structure\n", sizeof( struct VkAccelerationStructureInstanceKHR ) );

	swigComment("struct VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV\n");
	printf( "begin-structure VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV\n" );
	swigStructField( "VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV-pNext", offsetof( struct VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV-representativeFragmentTest", offsetof( struct VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV, representativeFragmentTest ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV-sType", offsetof( struct VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV ) );

	swigComment("struct VkPipelineRepresentativeFragmentTestStateCreateInfoNV\n");
	printf( "begin-structure VkPipelineRepresentativeFragmentTestStateCreateInfoNV\n" );
	swigStructField( "VkPipelineRepresentativeFragmentTestStateCreateInfoNV-pNext", offsetof( struct VkPipelineRepresentativeFragmentTestStateCreateInfoNV, pNext ), sizeof( void const * ) );
	swigStructField( "VkPipelineRepresentativeFragmentTestStateCreateInfoNV-representativeFragmentTestEnable", offsetof( struct VkPipelineRepresentativeFragmentTestStateCreateInfoNV, representativeFragmentTestEnable ), sizeof( VkBool32 ) );
	swigStructField( "VkPipelineRepresentativeFragmentTestStateCreateInfoNV-sType", offsetof( struct VkPipelineRepresentativeFragmentTestStateCreateInfoNV, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineRepresentativeFragmentTestStateCreateInfoNV ) );

	swigComment("struct VkPhysicalDeviceImageViewImageFormatInfoEXT\n");
	printf( "begin-structure VkPhysicalDeviceImageViewImageFormatInfoEXT\n" );
	swigStructField( "VkPhysicalDeviceImageViewImageFormatInfoEXT-pNext", offsetof( struct VkPhysicalDeviceImageViewImageFormatInfoEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceImageViewImageFormatInfoEXT-imageViewType", offsetof( struct VkPhysicalDeviceImageViewImageFormatInfoEXT, imageViewType ), sizeof( VkImageViewType ) );
	swigStructField( "VkPhysicalDeviceImageViewImageFormatInfoEXT-sType", offsetof( struct VkPhysicalDeviceImageViewImageFormatInfoEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceImageViewImageFormatInfoEXT ) );

	swigComment("struct VkFilterCubicImageViewImageFormatPropertiesEXT\n");
	printf( "begin-structure VkFilterCubicImageViewImageFormatPropertiesEXT\n" );
	swigStructField( "VkFilterCubicImageViewImageFormatPropertiesEXT-pNext", offsetof( struct VkFilterCubicImageViewImageFormatPropertiesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkFilterCubicImageViewImageFormatPropertiesEXT-filterCubic", offsetof( struct VkFilterCubicImageViewImageFormatPropertiesEXT, filterCubic ), sizeof( VkBool32 ) );
	swigStructField( "VkFilterCubicImageViewImageFormatPropertiesEXT-filterCubicMinmax", offsetof( struct VkFilterCubicImageViewImageFormatPropertiesEXT, filterCubicMinmax ), sizeof( VkBool32 ) );
	swigStructField( "VkFilterCubicImageViewImageFormatPropertiesEXT-sType", offsetof( struct VkFilterCubicImageViewImageFormatPropertiesEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkFilterCubicImageViewImageFormatPropertiesEXT ) );

	swigComment("struct VkDeviceQueueGlobalPriorityCreateInfoEXT\n");
	printf( "begin-structure VkDeviceQueueGlobalPriorityCreateInfoEXT\n" );
	swigStructField( "VkDeviceQueueGlobalPriorityCreateInfoEXT-globalPriority", offsetof( struct VkDeviceQueueGlobalPriorityCreateInfoEXT, globalPriority ), sizeof( VkQueueGlobalPriorityEXT ) );
	swigStructField( "VkDeviceQueueGlobalPriorityCreateInfoEXT-pNext", offsetof( struct VkDeviceQueueGlobalPriorityCreateInfoEXT, pNext ), sizeof( void const * ) );
	swigStructField( "VkDeviceQueueGlobalPriorityCreateInfoEXT-sType", offsetof( struct VkDeviceQueueGlobalPriorityCreateInfoEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDeviceQueueGlobalPriorityCreateInfoEXT ) );

	swigComment("struct VkImportMemoryHostPointerInfoEXT\n");
	printf( "begin-structure VkImportMemoryHostPointerInfoEXT\n" );
	swigStructField( "VkImportMemoryHostPointerInfoEXT-pNext", offsetof( struct VkImportMemoryHostPointerInfoEXT, pNext ), sizeof( void const * ) );
	swigStructField( "VkImportMemoryHostPointerInfoEXT-handleType", offsetof( struct VkImportMemoryHostPointerInfoEXT, handleType ), sizeof( VkExternalMemoryHandleTypeFlagBits ) );
	swigStructField( "VkImportMemoryHostPointerInfoEXT-pHostPointer", offsetof( struct VkImportMemoryHostPointerInfoEXT, pHostPointer ), sizeof( void * ) );
	swigStructField( "VkImportMemoryHostPointerInfoEXT-sType", offsetof( struct VkImportMemoryHostPointerInfoEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkImportMemoryHostPointerInfoEXT ) );

	swigComment("struct VkMemoryHostPointerPropertiesEXT\n");
	printf( "begin-structure VkMemoryHostPointerPropertiesEXT\n" );
	swigStructField( "VkMemoryHostPointerPropertiesEXT-pNext", offsetof( struct VkMemoryHostPointerPropertiesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkMemoryHostPointerPropertiesEXT-memoryTypeBits", offsetof( struct VkMemoryHostPointerPropertiesEXT, memoryTypeBits ), sizeof( uint32_t ) );
	swigStructField( "VkMemoryHostPointerPropertiesEXT-sType", offsetof( struct VkMemoryHostPointerPropertiesEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkMemoryHostPointerPropertiesEXT ) );

	swigComment("struct VkPhysicalDeviceExternalMemoryHostPropertiesEXT\n");
	printf( "begin-structure VkPhysicalDeviceExternalMemoryHostPropertiesEXT\n" );
	swigStructField( "VkPhysicalDeviceExternalMemoryHostPropertiesEXT-pNext", offsetof( struct VkPhysicalDeviceExternalMemoryHostPropertiesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceExternalMemoryHostPropertiesEXT-sType", offsetof( struct VkPhysicalDeviceExternalMemoryHostPropertiesEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDeviceExternalMemoryHostPropertiesEXT-minImportedHostPointerAlignment", offsetof( struct VkPhysicalDeviceExternalMemoryHostPropertiesEXT, minImportedHostPointerAlignment ), sizeof( VkDeviceSize ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceExternalMemoryHostPropertiesEXT ) );

	swigComment("struct VkPipelineCompilerControlCreateInfoAMD\n");
	printf( "begin-structure VkPipelineCompilerControlCreateInfoAMD\n" );
	swigStructField( "VkPipelineCompilerControlCreateInfoAMD-pNext", offsetof( struct VkPipelineCompilerControlCreateInfoAMD, pNext ), sizeof( void const * ) );
	swigStructField( "VkPipelineCompilerControlCreateInfoAMD-sType", offsetof( struct VkPipelineCompilerControlCreateInfoAMD, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPipelineCompilerControlCreateInfoAMD-compilerControlFlags", offsetof( struct VkPipelineCompilerControlCreateInfoAMD, compilerControlFlags ), sizeof( VkPipelineCompilerControlFlagsAMD ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineCompilerControlCreateInfoAMD ) );

	swigComment("struct VkCalibratedTimestampInfoEXT\n");
	printf( "begin-structure VkCalibratedTimestampInfoEXT\n" );
	swigStructField( "VkCalibratedTimestampInfoEXT-pNext", offsetof( struct VkCalibratedTimestampInfoEXT, pNext ), sizeof( void const * ) );
	swigStructField( "VkCalibratedTimestampInfoEXT-sType", offsetof( struct VkCalibratedTimestampInfoEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkCalibratedTimestampInfoEXT-timeDomain", offsetof( struct VkCalibratedTimestampInfoEXT, timeDomain ), sizeof( VkTimeDomainEXT ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkCalibratedTimestampInfoEXT ) );

	swigComment("struct VkPhysicalDeviceShaderCorePropertiesAMD\n");
	printf( "begin-structure VkPhysicalDeviceShaderCorePropertiesAMD\n" );
	swigStructField( "VkPhysicalDeviceShaderCorePropertiesAMD-wavefrontSize", offsetof( struct VkPhysicalDeviceShaderCorePropertiesAMD, wavefrontSize ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceShaderCorePropertiesAMD-computeUnitsPerShaderArray", offsetof( struct VkPhysicalDeviceShaderCorePropertiesAMD, computeUnitsPerShaderArray ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceShaderCorePropertiesAMD-pNext", offsetof( struct VkPhysicalDeviceShaderCorePropertiesAMD, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceShaderCorePropertiesAMD-minVgprAllocation", offsetof( struct VkPhysicalDeviceShaderCorePropertiesAMD, minVgprAllocation ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceShaderCorePropertiesAMD-maxSgprAllocation", offsetof( struct VkPhysicalDeviceShaderCorePropertiesAMD, maxSgprAllocation ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceShaderCorePropertiesAMD-minSgprAllocation", offsetof( struct VkPhysicalDeviceShaderCorePropertiesAMD, minSgprAllocation ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceShaderCorePropertiesAMD-maxVgprAllocation", offsetof( struct VkPhysicalDeviceShaderCorePropertiesAMD, maxVgprAllocation ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceShaderCorePropertiesAMD-sgprAllocationGranularity", offsetof( struct VkPhysicalDeviceShaderCorePropertiesAMD, sgprAllocationGranularity ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceShaderCorePropertiesAMD-vgprAllocationGranularity", offsetof( struct VkPhysicalDeviceShaderCorePropertiesAMD, vgprAllocationGranularity ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceShaderCorePropertiesAMD-vgprsPerSimd", offsetof( struct VkPhysicalDeviceShaderCorePropertiesAMD, vgprsPerSimd ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceShaderCorePropertiesAMD-sgprsPerSimd", offsetof( struct VkPhysicalDeviceShaderCorePropertiesAMD, sgprsPerSimd ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceShaderCorePropertiesAMD-wavefrontsPerSimd", offsetof( struct VkPhysicalDeviceShaderCorePropertiesAMD, wavefrontsPerSimd ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceShaderCorePropertiesAMD-shaderArraysPerEngineCount", offsetof( struct VkPhysicalDeviceShaderCorePropertiesAMD, shaderArraysPerEngineCount ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceShaderCorePropertiesAMD-shaderEngineCount", offsetof( struct VkPhysicalDeviceShaderCorePropertiesAMD, shaderEngineCount ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceShaderCorePropertiesAMD-simdPerComputeUnit", offsetof( struct VkPhysicalDeviceShaderCorePropertiesAMD, simdPerComputeUnit ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceShaderCorePropertiesAMD-sType", offsetof( struct VkPhysicalDeviceShaderCorePropertiesAMD, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceShaderCorePropertiesAMD ) );

	swigComment("struct VkDeviceMemoryOverallocationCreateInfoAMD\n");
	printf( "begin-structure VkDeviceMemoryOverallocationCreateInfoAMD\n" );
	swigStructField( "VkDeviceMemoryOverallocationCreateInfoAMD-pNext", offsetof( struct VkDeviceMemoryOverallocationCreateInfoAMD, pNext ), sizeof( void const * ) );
	swigStructField( "VkDeviceMemoryOverallocationCreateInfoAMD-overallocationBehavior", offsetof( struct VkDeviceMemoryOverallocationCreateInfoAMD, overallocationBehavior ), sizeof( VkMemoryOverallocationBehaviorAMD ) );
	swigStructField( "VkDeviceMemoryOverallocationCreateInfoAMD-sType", offsetof( struct VkDeviceMemoryOverallocationCreateInfoAMD, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDeviceMemoryOverallocationCreateInfoAMD ) );

	swigComment("struct VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT\n");
	printf( "begin-structure VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT\n" );
	swigStructField( "VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT-pNext", offsetof( struct VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT-sType", offsetof( struct VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT-maxVertexAttribDivisor", offsetof( struct VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT, maxVertexAttribDivisor ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT ) );

	swigComment("struct VkVertexInputBindingDivisorDescriptionEXT\n");
	printf( "begin-structure VkVertexInputBindingDivisorDescriptionEXT\n" );
	swigStructField( "VkVertexInputBindingDivisorDescriptionEXT-binding", offsetof( struct VkVertexInputBindingDivisorDescriptionEXT, binding ), sizeof( uint32_t ) );
	swigStructField( "VkVertexInputBindingDivisorDescriptionEXT-divisor", offsetof( struct VkVertexInputBindingDivisorDescriptionEXT, divisor ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkVertexInputBindingDivisorDescriptionEXT ) );

	swigComment("struct VkPipelineVertexInputDivisorStateCreateInfoEXT\n");
	printf( "begin-structure VkPipelineVertexInputDivisorStateCreateInfoEXT\n" );
	swigStructField( "VkPipelineVertexInputDivisorStateCreateInfoEXT-pVertexBindingDivisors", offsetof( struct VkPipelineVertexInputDivisorStateCreateInfoEXT, pVertexBindingDivisors ), sizeof( VkVertexInputBindingDivisorDescriptionEXT const * ) );
	swigStructField( "VkPipelineVertexInputDivisorStateCreateInfoEXT-pNext", offsetof( struct VkPipelineVertexInputDivisorStateCreateInfoEXT, pNext ), sizeof( void const * ) );
	swigStructField( "VkPipelineVertexInputDivisorStateCreateInfoEXT-vertexBindingDivisorCount", offsetof( struct VkPipelineVertexInputDivisorStateCreateInfoEXT, vertexBindingDivisorCount ), sizeof( uint32_t ) );
	swigStructField( "VkPipelineVertexInputDivisorStateCreateInfoEXT-sType", offsetof( struct VkPipelineVertexInputDivisorStateCreateInfoEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineVertexInputDivisorStateCreateInfoEXT ) );

	swigComment("struct VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT\n");
	printf( "begin-structure VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT\n" );
	swigStructField( "VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT-pNext", offsetof( struct VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT-sType", offsetof( struct VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT-vertexAttributeInstanceRateDivisor", offsetof( struct VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT, vertexAttributeInstanceRateDivisor ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT-vertexAttributeInstanceRateZeroDivisor", offsetof( struct VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT, vertexAttributeInstanceRateZeroDivisor ), sizeof( VkBool32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT ) );

	swigComment("struct VkPipelineCreationFeedbackEXT\n");
	printf( "begin-structure VkPipelineCreationFeedbackEXT\n" );
	swigStructField( "VkPipelineCreationFeedbackEXT-duration", offsetof( struct VkPipelineCreationFeedbackEXT, duration ), sizeof( uint64_t ) );
	swigStructField( "VkPipelineCreationFeedbackEXT-flags", offsetof( struct VkPipelineCreationFeedbackEXT, flags ), sizeof( VkPipelineCreationFeedbackFlagsEXT ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineCreationFeedbackEXT ) );

	swigComment("struct VkPipelineCreationFeedbackCreateInfoEXT\n");
	printf( "begin-structure VkPipelineCreationFeedbackCreateInfoEXT\n" );
	swigStructField( "VkPipelineCreationFeedbackCreateInfoEXT-pNext", offsetof( struct VkPipelineCreationFeedbackCreateInfoEXT, pNext ), sizeof( void const * ) );
	swigStructField( "VkPipelineCreationFeedbackCreateInfoEXT-pPipelineCreationFeedback", offsetof( struct VkPipelineCreationFeedbackCreateInfoEXT, pPipelineCreationFeedback ), sizeof( VkPipelineCreationFeedbackEXT * ) );
	swigStructField( "VkPipelineCreationFeedbackCreateInfoEXT-pipelineStageCreationFeedbackCount", offsetof( struct VkPipelineCreationFeedbackCreateInfoEXT, pipelineStageCreationFeedbackCount ), sizeof( uint32_t ) );
	swigStructField( "VkPipelineCreationFeedbackCreateInfoEXT-sType", offsetof( struct VkPipelineCreationFeedbackCreateInfoEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPipelineCreationFeedbackCreateInfoEXT-pPipelineStageCreationFeedbacks", offsetof( struct VkPipelineCreationFeedbackCreateInfoEXT, pPipelineStageCreationFeedbacks ), sizeof( VkPipelineCreationFeedbackEXT * ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineCreationFeedbackCreateInfoEXT ) );

	swigComment("struct VkPhysicalDeviceComputeShaderDerivativesFeaturesNV\n");
	printf( "begin-structure VkPhysicalDeviceComputeShaderDerivativesFeaturesNV\n" );
	swigStructField( "VkPhysicalDeviceComputeShaderDerivativesFeaturesNV-pNext", offsetof( struct VkPhysicalDeviceComputeShaderDerivativesFeaturesNV, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceComputeShaderDerivativesFeaturesNV-sType", offsetof( struct VkPhysicalDeviceComputeShaderDerivativesFeaturesNV, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDeviceComputeShaderDerivativesFeaturesNV-computeDerivativeGroupLinear", offsetof( struct VkPhysicalDeviceComputeShaderDerivativesFeaturesNV, computeDerivativeGroupLinear ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceComputeShaderDerivativesFeaturesNV-computeDerivativeGroupQuads", offsetof( struct VkPhysicalDeviceComputeShaderDerivativesFeaturesNV, computeDerivativeGroupQuads ), sizeof( VkBool32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceComputeShaderDerivativesFeaturesNV ) );

	swigComment("struct VkPhysicalDeviceMeshShaderFeaturesNV\n");
	printf( "begin-structure VkPhysicalDeviceMeshShaderFeaturesNV\n" );
	swigStructField( "VkPhysicalDeviceMeshShaderFeaturesNV-pNext", offsetof( struct VkPhysicalDeviceMeshShaderFeaturesNV, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceMeshShaderFeaturesNV-meshShader", offsetof( struct VkPhysicalDeviceMeshShaderFeaturesNV, meshShader ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceMeshShaderFeaturesNV-taskShader", offsetof( struct VkPhysicalDeviceMeshShaderFeaturesNV, taskShader ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceMeshShaderFeaturesNV-sType", offsetof( struct VkPhysicalDeviceMeshShaderFeaturesNV, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceMeshShaderFeaturesNV ) );

	swigComment("struct VkPhysicalDeviceMeshShaderPropertiesNV\n");
	printf( "begin-structure VkPhysicalDeviceMeshShaderPropertiesNV\n" );
	swigStructField( "VkPhysicalDeviceMeshShaderPropertiesNV-maxMeshOutputVertices", offsetof( struct VkPhysicalDeviceMeshShaderPropertiesNV, maxMeshOutputVertices ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceMeshShaderPropertiesNV-maxMeshWorkGroupSize", offsetof( struct VkPhysicalDeviceMeshShaderPropertiesNV, maxMeshWorkGroupSize ), sizeof( uint32_t [3] ) );
	swigStructField( "VkPhysicalDeviceMeshShaderPropertiesNV-maxTaskWorkGroupSize", offsetof( struct VkPhysicalDeviceMeshShaderPropertiesNV, maxTaskWorkGroupSize ), sizeof( uint32_t [3] ) );
	swigStructField( "VkPhysicalDeviceMeshShaderPropertiesNV-pNext", offsetof( struct VkPhysicalDeviceMeshShaderPropertiesNV, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceMeshShaderPropertiesNV-meshOutputPerVertexGranularity", offsetof( struct VkPhysicalDeviceMeshShaderPropertiesNV, meshOutputPerVertexGranularity ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceMeshShaderPropertiesNV-maxMeshTotalMemorySize", offsetof( struct VkPhysicalDeviceMeshShaderPropertiesNV, maxMeshTotalMemorySize ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceMeshShaderPropertiesNV-maxTaskTotalMemorySize", offsetof( struct VkPhysicalDeviceMeshShaderPropertiesNV, maxTaskTotalMemorySize ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceMeshShaderPropertiesNV-meshOutputPerPrimitiveGranularity", offsetof( struct VkPhysicalDeviceMeshShaderPropertiesNV, meshOutputPerPrimitiveGranularity ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceMeshShaderPropertiesNV-maxMeshOutputPrimitives", offsetof( struct VkPhysicalDeviceMeshShaderPropertiesNV, maxMeshOutputPrimitives ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceMeshShaderPropertiesNV-maxDrawMeshTasksCount", offsetof( struct VkPhysicalDeviceMeshShaderPropertiesNV, maxDrawMeshTasksCount ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceMeshShaderPropertiesNV-maxTaskOutputCount", offsetof( struct VkPhysicalDeviceMeshShaderPropertiesNV, maxTaskOutputCount ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceMeshShaderPropertiesNV-maxMeshWorkGroupInvocations", offsetof( struct VkPhysicalDeviceMeshShaderPropertiesNV, maxMeshWorkGroupInvocations ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceMeshShaderPropertiesNV-maxTaskWorkGroupInvocations", offsetof( struct VkPhysicalDeviceMeshShaderPropertiesNV, maxTaskWorkGroupInvocations ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceMeshShaderPropertiesNV-sType", offsetof( struct VkPhysicalDeviceMeshShaderPropertiesNV, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDeviceMeshShaderPropertiesNV-maxMeshMultiviewViewCount", offsetof( struct VkPhysicalDeviceMeshShaderPropertiesNV, maxMeshMultiviewViewCount ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceMeshShaderPropertiesNV ) );

	swigComment("struct VkDrawMeshTasksIndirectCommandNV\n");
	printf( "begin-structure VkDrawMeshTasksIndirectCommandNV\n" );
	swigStructField( "VkDrawMeshTasksIndirectCommandNV-taskCount", offsetof( struct VkDrawMeshTasksIndirectCommandNV, taskCount ), sizeof( uint32_t ) );
	swigStructField( "VkDrawMeshTasksIndirectCommandNV-firstTask", offsetof( struct VkDrawMeshTasksIndirectCommandNV, firstTask ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDrawMeshTasksIndirectCommandNV ) );

	swigComment("struct VkPhysicalDeviceFragmentShaderBarycentricFeaturesNV\n");
	printf( "begin-structure VkPhysicalDeviceFragmentShaderBarycentricFeaturesNV\n" );
	swigStructField( "VkPhysicalDeviceFragmentShaderBarycentricFeaturesNV-pNext", offsetof( struct VkPhysicalDeviceFragmentShaderBarycentricFeaturesNV, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceFragmentShaderBarycentricFeaturesNV-fragmentShaderBarycentric", offsetof( struct VkPhysicalDeviceFragmentShaderBarycentricFeaturesNV, fragmentShaderBarycentric ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFragmentShaderBarycentricFeaturesNV-sType", offsetof( struct VkPhysicalDeviceFragmentShaderBarycentricFeaturesNV, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceFragmentShaderBarycentricFeaturesNV ) );

	swigComment("struct VkPhysicalDeviceShaderImageFootprintFeaturesNV\n");
	printf( "begin-structure VkPhysicalDeviceShaderImageFootprintFeaturesNV\n" );
	swigStructField( "VkPhysicalDeviceShaderImageFootprintFeaturesNV-pNext", offsetof( struct VkPhysicalDeviceShaderImageFootprintFeaturesNV, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceShaderImageFootprintFeaturesNV-imageFootprint", offsetof( struct VkPhysicalDeviceShaderImageFootprintFeaturesNV, imageFootprint ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderImageFootprintFeaturesNV-sType", offsetof( struct VkPhysicalDeviceShaderImageFootprintFeaturesNV, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceShaderImageFootprintFeaturesNV ) );

	swigComment("struct VkPipelineViewportExclusiveScissorStateCreateInfoNV\n");
	printf( "begin-structure VkPipelineViewportExclusiveScissorStateCreateInfoNV\n" );
	swigStructField( "VkPipelineViewportExclusiveScissorStateCreateInfoNV-pExclusiveScissors", offsetof( struct VkPipelineViewportExclusiveScissorStateCreateInfoNV, pExclusiveScissors ), sizeof( VkRect2D const * ) );
	swigStructField( "VkPipelineViewportExclusiveScissorStateCreateInfoNV-pNext", offsetof( struct VkPipelineViewportExclusiveScissorStateCreateInfoNV, pNext ), sizeof( void const * ) );
	swigStructField( "VkPipelineViewportExclusiveScissorStateCreateInfoNV-exclusiveScissorCount", offsetof( struct VkPipelineViewportExclusiveScissorStateCreateInfoNV, exclusiveScissorCount ), sizeof( uint32_t ) );
	swigStructField( "VkPipelineViewportExclusiveScissorStateCreateInfoNV-sType", offsetof( struct VkPipelineViewportExclusiveScissorStateCreateInfoNV, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineViewportExclusiveScissorStateCreateInfoNV ) );

	swigComment("struct VkPhysicalDeviceExclusiveScissorFeaturesNV\n");
	printf( "begin-structure VkPhysicalDeviceExclusiveScissorFeaturesNV\n" );
	swigStructField( "VkPhysicalDeviceExclusiveScissorFeaturesNV-pNext", offsetof( struct VkPhysicalDeviceExclusiveScissorFeaturesNV, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceExclusiveScissorFeaturesNV-sType", offsetof( struct VkPhysicalDeviceExclusiveScissorFeaturesNV, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDeviceExclusiveScissorFeaturesNV-exclusiveScissor", offsetof( struct VkPhysicalDeviceExclusiveScissorFeaturesNV, exclusiveScissor ), sizeof( VkBool32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceExclusiveScissorFeaturesNV ) );

	swigComment("struct VkQueueFamilyCheckpointPropertiesNV\n");
	printf( "begin-structure VkQueueFamilyCheckpointPropertiesNV\n" );
	swigStructField( "VkQueueFamilyCheckpointPropertiesNV-pNext", offsetof( struct VkQueueFamilyCheckpointPropertiesNV, pNext ), sizeof( void * ) );
	swigStructField( "VkQueueFamilyCheckpointPropertiesNV-checkpointExecutionStageMask", offsetof( struct VkQueueFamilyCheckpointPropertiesNV, checkpointExecutionStageMask ), sizeof( VkPipelineStageFlags ) );
	swigStructField( "VkQueueFamilyCheckpointPropertiesNV-sType", offsetof( struct VkQueueFamilyCheckpointPropertiesNV, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkQueueFamilyCheckpointPropertiesNV ) );

	swigComment("struct VkCheckpointDataNV\n");
	printf( "begin-structure VkCheckpointDataNV\n" );
	swigStructField( "VkCheckpointDataNV-pCheckpointMarker", offsetof( struct VkCheckpointDataNV, pCheckpointMarker ), sizeof( void * ) );
	swigStructField( "VkCheckpointDataNV-pNext", offsetof( struct VkCheckpointDataNV, pNext ), sizeof( void * ) );
	swigStructField( "VkCheckpointDataNV-stage", offsetof( struct VkCheckpointDataNV, stage ), sizeof( VkPipelineStageFlagBits ) );
	swigStructField( "VkCheckpointDataNV-sType", offsetof( struct VkCheckpointDataNV, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkCheckpointDataNV ) );

	swigComment("struct VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL\n");
	printf( "begin-structure VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL\n" );
	swigStructField( "VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL-pNext", offsetof( struct VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL-sType", offsetof( struct VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL-shaderIntegerFunctions2", offsetof( struct VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL, shaderIntegerFunctions2 ), sizeof( VkBool32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL ) );

	swigComment("union VkPerformanceValueDataINTEL\n");
	printf( "begin-structure VkPerformanceValueDataINTEL\n" );
	swigStructField( "VkPerformanceValueDataINTEL-value32", offsetof( union VkPerformanceValueDataINTEL, value32 ), sizeof( uint32_t ) );
	swigStructField( "VkPerformanceValueDataINTEL-value64", offsetof( union VkPerformanceValueDataINTEL, value64 ), sizeof( uint64_t ) );
	swigStructField( "VkPerformanceValueDataINTEL-valueFloat", offsetof( union VkPerformanceValueDataINTEL, valueFloat ), sizeof( float ) );
	swigStructField( "VkPerformanceValueDataINTEL-valueString", offsetof( union VkPerformanceValueDataINTEL, valueString ), sizeof( char const * ) );
	swigStructField( "VkPerformanceValueDataINTEL-valueBool", offsetof( union VkPerformanceValueDataINTEL, valueBool ), sizeof( VkBool32 ) );
	printf( "drop %zu end-structure\n", sizeof( union VkPerformanceValueDataINTEL ) );

	swigComment("struct VkPerformanceValueINTEL\n");
	printf( "begin-structure VkPerformanceValueINTEL\n" );
	swigStructField( "VkPerformanceValueINTEL-data", offsetof( struct VkPerformanceValueINTEL, data ), sizeof( VkPerformanceValueDataINTEL ) );
	swigStructField( "VkPerformanceValueINTEL-type", offsetof( struct VkPerformanceValueINTEL, type ), sizeof( VkPerformanceValueTypeINTEL ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPerformanceValueINTEL ) );

	swigComment("struct VkInitializePerformanceApiInfoINTEL\n");
	printf( "begin-structure VkInitializePerformanceApiInfoINTEL\n" );
	swigStructField( "VkInitializePerformanceApiInfoINTEL-pNext", offsetof( struct VkInitializePerformanceApiInfoINTEL, pNext ), sizeof( void const * ) );
	swigStructField( "VkInitializePerformanceApiInfoINTEL-pUserData", offsetof( struct VkInitializePerformanceApiInfoINTEL, pUserData ), sizeof( void * ) );
	swigStructField( "VkInitializePerformanceApiInfoINTEL-sType", offsetof( struct VkInitializePerformanceApiInfoINTEL, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkInitializePerformanceApiInfoINTEL ) );

	swigComment("struct VkQueryPoolPerformanceQueryCreateInfoINTEL\n");
	printf( "begin-structure VkQueryPoolPerformanceQueryCreateInfoINTEL\n" );
	swigStructField( "VkQueryPoolPerformanceQueryCreateInfoINTEL-pNext", offsetof( struct VkQueryPoolPerformanceQueryCreateInfoINTEL, pNext ), sizeof( void const * ) );
	swigStructField( "VkQueryPoolPerformanceQueryCreateInfoINTEL-sType", offsetof( struct VkQueryPoolPerformanceQueryCreateInfoINTEL, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkQueryPoolPerformanceQueryCreateInfoINTEL-performanceCountersSampling", offsetof( struct VkQueryPoolPerformanceQueryCreateInfoINTEL, performanceCountersSampling ), sizeof( VkQueryPoolSamplingModeINTEL ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkQueryPoolPerformanceQueryCreateInfoINTEL ) );

	swigComment("struct VkPerformanceMarkerInfoINTEL\n");
	printf( "begin-structure VkPerformanceMarkerInfoINTEL\n" );
	swigStructField( "VkPerformanceMarkerInfoINTEL-pNext", offsetof( struct VkPerformanceMarkerInfoINTEL, pNext ), sizeof( void const * ) );
	swigStructField( "VkPerformanceMarkerInfoINTEL-marker", offsetof( struct VkPerformanceMarkerInfoINTEL, marker ), sizeof( uint64_t ) );
	swigStructField( "VkPerformanceMarkerInfoINTEL-sType", offsetof( struct VkPerformanceMarkerInfoINTEL, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPerformanceMarkerInfoINTEL ) );

	swigComment("struct VkPerformanceStreamMarkerInfoINTEL\n");
	printf( "begin-structure VkPerformanceStreamMarkerInfoINTEL\n" );
	swigStructField( "VkPerformanceStreamMarkerInfoINTEL-pNext", offsetof( struct VkPerformanceStreamMarkerInfoINTEL, pNext ), sizeof( void const * ) );
	swigStructField( "VkPerformanceStreamMarkerInfoINTEL-marker", offsetof( struct VkPerformanceStreamMarkerInfoINTEL, marker ), sizeof( uint32_t ) );
	swigStructField( "VkPerformanceStreamMarkerInfoINTEL-sType", offsetof( struct VkPerformanceStreamMarkerInfoINTEL, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPerformanceStreamMarkerInfoINTEL ) );

	swigComment("struct VkPerformanceOverrideInfoINTEL\n");
	printf( "begin-structure VkPerformanceOverrideInfoINTEL\n" );
	swigStructField( "VkPerformanceOverrideInfoINTEL-pNext", offsetof( struct VkPerformanceOverrideInfoINTEL, pNext ), sizeof( void const * ) );
	swigStructField( "VkPerformanceOverrideInfoINTEL-parameter", offsetof( struct VkPerformanceOverrideInfoINTEL, parameter ), sizeof( uint64_t ) );
	swigStructField( "VkPerformanceOverrideInfoINTEL-enable", offsetof( struct VkPerformanceOverrideInfoINTEL, enable ), sizeof( VkBool32 ) );
	swigStructField( "VkPerformanceOverrideInfoINTEL-type", offsetof( struct VkPerformanceOverrideInfoINTEL, type ), sizeof( VkPerformanceOverrideTypeINTEL ) );
	swigStructField( "VkPerformanceOverrideInfoINTEL-sType", offsetof( struct VkPerformanceOverrideInfoINTEL, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPerformanceOverrideInfoINTEL ) );

	swigComment("struct VkPerformanceConfigurationAcquireInfoINTEL\n");
	printf( "begin-structure VkPerformanceConfigurationAcquireInfoINTEL\n" );
	swigStructField( "VkPerformanceConfigurationAcquireInfoINTEL-pNext", offsetof( struct VkPerformanceConfigurationAcquireInfoINTEL, pNext ), sizeof( void const * ) );
	swigStructField( "VkPerformanceConfigurationAcquireInfoINTEL-type", offsetof( struct VkPerformanceConfigurationAcquireInfoINTEL, type ), sizeof( VkPerformanceConfigurationTypeINTEL ) );
	swigStructField( "VkPerformanceConfigurationAcquireInfoINTEL-sType", offsetof( struct VkPerformanceConfigurationAcquireInfoINTEL, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPerformanceConfigurationAcquireInfoINTEL ) );

	swigComment("struct VkPhysicalDevicePCIBusInfoPropertiesEXT\n");
	printf( "begin-structure VkPhysicalDevicePCIBusInfoPropertiesEXT\n" );
	swigStructField( "VkPhysicalDevicePCIBusInfoPropertiesEXT-pNext", offsetof( struct VkPhysicalDevicePCIBusInfoPropertiesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDevicePCIBusInfoPropertiesEXT-pciFunction", offsetof( struct VkPhysicalDevicePCIBusInfoPropertiesEXT, pciFunction ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDevicePCIBusInfoPropertiesEXT-pciBus", offsetof( struct VkPhysicalDevicePCIBusInfoPropertiesEXT, pciBus ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDevicePCIBusInfoPropertiesEXT-sType", offsetof( struct VkPhysicalDevicePCIBusInfoPropertiesEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDevicePCIBusInfoPropertiesEXT-pciDomain", offsetof( struct VkPhysicalDevicePCIBusInfoPropertiesEXT, pciDomain ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDevicePCIBusInfoPropertiesEXT-pciDevice", offsetof( struct VkPhysicalDevicePCIBusInfoPropertiesEXT, pciDevice ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDevicePCIBusInfoPropertiesEXT ) );

	swigComment("struct VkDisplayNativeHdrSurfaceCapabilitiesAMD\n");
	printf( "begin-structure VkDisplayNativeHdrSurfaceCapabilitiesAMD\n" );
	swigStructField( "VkDisplayNativeHdrSurfaceCapabilitiesAMD-pNext", offsetof( struct VkDisplayNativeHdrSurfaceCapabilitiesAMD, pNext ), sizeof( void * ) );
	swigStructField( "VkDisplayNativeHdrSurfaceCapabilitiesAMD-localDimmingSupport", offsetof( struct VkDisplayNativeHdrSurfaceCapabilitiesAMD, localDimmingSupport ), sizeof( VkBool32 ) );
	swigStructField( "VkDisplayNativeHdrSurfaceCapabilitiesAMD-sType", offsetof( struct VkDisplayNativeHdrSurfaceCapabilitiesAMD, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDisplayNativeHdrSurfaceCapabilitiesAMD ) );

	swigComment("struct VkSwapchainDisplayNativeHdrCreateInfoAMD\n");
	printf( "begin-structure VkSwapchainDisplayNativeHdrCreateInfoAMD\n" );
	swigStructField( "VkSwapchainDisplayNativeHdrCreateInfoAMD-pNext", offsetof( struct VkSwapchainDisplayNativeHdrCreateInfoAMD, pNext ), sizeof( void const * ) );
	swigStructField( "VkSwapchainDisplayNativeHdrCreateInfoAMD-localDimmingEnable", offsetof( struct VkSwapchainDisplayNativeHdrCreateInfoAMD, localDimmingEnable ), sizeof( VkBool32 ) );
	swigStructField( "VkSwapchainDisplayNativeHdrCreateInfoAMD-sType", offsetof( struct VkSwapchainDisplayNativeHdrCreateInfoAMD, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSwapchainDisplayNativeHdrCreateInfoAMD ) );

	swigComment("struct VkPhysicalDeviceFragmentDensityMapFeaturesEXT\n");
	printf( "begin-structure VkPhysicalDeviceFragmentDensityMapFeaturesEXT\n" );
	swigStructField( "VkPhysicalDeviceFragmentDensityMapFeaturesEXT-pNext", offsetof( struct VkPhysicalDeviceFragmentDensityMapFeaturesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceFragmentDensityMapFeaturesEXT-fragmentDensityMapDynamic", offsetof( struct VkPhysicalDeviceFragmentDensityMapFeaturesEXT, fragmentDensityMapDynamic ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFragmentDensityMapFeaturesEXT-fragmentDensityMapNonSubsampledImages", offsetof( struct VkPhysicalDeviceFragmentDensityMapFeaturesEXT, fragmentDensityMapNonSubsampledImages ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFragmentDensityMapFeaturesEXT-fragmentDensityMap", offsetof( struct VkPhysicalDeviceFragmentDensityMapFeaturesEXT, fragmentDensityMap ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFragmentDensityMapFeaturesEXT-sType", offsetof( struct VkPhysicalDeviceFragmentDensityMapFeaturesEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceFragmentDensityMapFeaturesEXT ) );

	swigComment("struct VkPhysicalDeviceFragmentDensityMapPropertiesEXT\n");
	printf( "begin-structure VkPhysicalDeviceFragmentDensityMapPropertiesEXT\n" );
	swigStructField( "VkPhysicalDeviceFragmentDensityMapPropertiesEXT-pNext", offsetof( struct VkPhysicalDeviceFragmentDensityMapPropertiesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceFragmentDensityMapPropertiesEXT-minFragmentDensityTexelSize", offsetof( struct VkPhysicalDeviceFragmentDensityMapPropertiesEXT, minFragmentDensityTexelSize ), sizeof( VkExtent2D ) );
	swigStructField( "VkPhysicalDeviceFragmentDensityMapPropertiesEXT-maxFragmentDensityTexelSize", offsetof( struct VkPhysicalDeviceFragmentDensityMapPropertiesEXT, maxFragmentDensityTexelSize ), sizeof( VkExtent2D ) );
	swigStructField( "VkPhysicalDeviceFragmentDensityMapPropertiesEXT-fragmentDensityInvocations", offsetof( struct VkPhysicalDeviceFragmentDensityMapPropertiesEXT, fragmentDensityInvocations ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFragmentDensityMapPropertiesEXT-sType", offsetof( struct VkPhysicalDeviceFragmentDensityMapPropertiesEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceFragmentDensityMapPropertiesEXT ) );

	swigComment("struct VkRenderPassFragmentDensityMapCreateInfoEXT\n");
	printf( "begin-structure VkRenderPassFragmentDensityMapCreateInfoEXT\n" );
	swigStructField( "VkRenderPassFragmentDensityMapCreateInfoEXT-pNext", offsetof( struct VkRenderPassFragmentDensityMapCreateInfoEXT, pNext ), sizeof( void const * ) );
	swigStructField( "VkRenderPassFragmentDensityMapCreateInfoEXT-fragmentDensityMapAttachment", offsetof( struct VkRenderPassFragmentDensityMapCreateInfoEXT, fragmentDensityMapAttachment ), sizeof( VkAttachmentReference ) );
	swigStructField( "VkRenderPassFragmentDensityMapCreateInfoEXT-sType", offsetof( struct VkRenderPassFragmentDensityMapCreateInfoEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkRenderPassFragmentDensityMapCreateInfoEXT ) );

	swigComment("struct VkPhysicalDeviceSubgroupSizeControlFeaturesEXT\n");
	printf( "begin-structure VkPhysicalDeviceSubgroupSizeControlFeaturesEXT\n" );
	swigStructField( "VkPhysicalDeviceSubgroupSizeControlFeaturesEXT-computeFullSubgroups", offsetof( struct VkPhysicalDeviceSubgroupSizeControlFeaturesEXT, computeFullSubgroups ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceSubgroupSizeControlFeaturesEXT-pNext", offsetof( struct VkPhysicalDeviceSubgroupSizeControlFeaturesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceSubgroupSizeControlFeaturesEXT-subgroupSizeControl", offsetof( struct VkPhysicalDeviceSubgroupSizeControlFeaturesEXT, subgroupSizeControl ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceSubgroupSizeControlFeaturesEXT-sType", offsetof( struct VkPhysicalDeviceSubgroupSizeControlFeaturesEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceSubgroupSizeControlFeaturesEXT ) );

	swigComment("struct VkPhysicalDeviceSubgroupSizeControlPropertiesEXT\n");
	printf( "begin-structure VkPhysicalDeviceSubgroupSizeControlPropertiesEXT\n" );
	swigStructField( "VkPhysicalDeviceSubgroupSizeControlPropertiesEXT-minSubgroupSize", offsetof( struct VkPhysicalDeviceSubgroupSizeControlPropertiesEXT, minSubgroupSize ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceSubgroupSizeControlPropertiesEXT-maxSubgroupSize", offsetof( struct VkPhysicalDeviceSubgroupSizeControlPropertiesEXT, maxSubgroupSize ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceSubgroupSizeControlPropertiesEXT-maxComputeWorkgroupSubgroups", offsetof( struct VkPhysicalDeviceSubgroupSizeControlPropertiesEXT, maxComputeWorkgroupSubgroups ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceSubgroupSizeControlPropertiesEXT-pNext", offsetof( struct VkPhysicalDeviceSubgroupSizeControlPropertiesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceSubgroupSizeControlPropertiesEXT-requiredSubgroupSizeStages", offsetof( struct VkPhysicalDeviceSubgroupSizeControlPropertiesEXT, requiredSubgroupSizeStages ), sizeof( VkShaderStageFlags ) );
	swigStructField( "VkPhysicalDeviceSubgroupSizeControlPropertiesEXT-sType", offsetof( struct VkPhysicalDeviceSubgroupSizeControlPropertiesEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceSubgroupSizeControlPropertiesEXT ) );

	swigComment("struct VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT\n");
	printf( "begin-structure VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT\n" );
	swigStructField( "VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT-requiredSubgroupSize", offsetof( struct VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT, requiredSubgroupSize ), sizeof( uint32_t ) );
	swigStructField( "VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT-pNext", offsetof( struct VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT-sType", offsetof( struct VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT ) );

	swigComment("struct VkPhysicalDeviceShaderCoreProperties2AMD\n");
	printf( "begin-structure VkPhysicalDeviceShaderCoreProperties2AMD\n" );
	swigStructField( "VkPhysicalDeviceShaderCoreProperties2AMD-shaderCoreFeatures", offsetof( struct VkPhysicalDeviceShaderCoreProperties2AMD, shaderCoreFeatures ), sizeof( VkShaderCorePropertiesFlagsAMD ) );
	swigStructField( "VkPhysicalDeviceShaderCoreProperties2AMD-pNext", offsetof( struct VkPhysicalDeviceShaderCoreProperties2AMD, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceShaderCoreProperties2AMD-sType", offsetof( struct VkPhysicalDeviceShaderCoreProperties2AMD, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDeviceShaderCoreProperties2AMD-activeComputeUnitCount", offsetof( struct VkPhysicalDeviceShaderCoreProperties2AMD, activeComputeUnitCount ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceShaderCoreProperties2AMD ) );

	swigComment("struct VkPhysicalDeviceCoherentMemoryFeaturesAMD\n");
	printf( "begin-structure VkPhysicalDeviceCoherentMemoryFeaturesAMD\n" );
	swigStructField( "VkPhysicalDeviceCoherentMemoryFeaturesAMD-pNext", offsetof( struct VkPhysicalDeviceCoherentMemoryFeaturesAMD, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceCoherentMemoryFeaturesAMD-deviceCoherentMemory", offsetof( struct VkPhysicalDeviceCoherentMemoryFeaturesAMD, deviceCoherentMemory ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceCoherentMemoryFeaturesAMD-sType", offsetof( struct VkPhysicalDeviceCoherentMemoryFeaturesAMD, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceCoherentMemoryFeaturesAMD ) );

	swigComment("struct VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT\n");
	printf( "begin-structure VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT\n" );
	swigStructField( "VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT-pNext", offsetof( struct VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT-sType", offsetof( struct VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT-shaderImageInt64Atomics", offsetof( struct VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT, shaderImageInt64Atomics ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT-sparseImageInt64Atomics", offsetof( struct VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT, sparseImageInt64Atomics ), sizeof( VkBool32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT ) );

	swigComment("struct VkPhysicalDeviceMemoryBudgetPropertiesEXT\n");
	printf( "begin-structure VkPhysicalDeviceMemoryBudgetPropertiesEXT\n" );
	swigStructField( "VkPhysicalDeviceMemoryBudgetPropertiesEXT-pNext", offsetof( struct VkPhysicalDeviceMemoryBudgetPropertiesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceMemoryBudgetPropertiesEXT-heapBudget", offsetof( struct VkPhysicalDeviceMemoryBudgetPropertiesEXT, heapBudget ), sizeof( VkDeviceSize [16U] ) );
	swigStructField( "VkPhysicalDeviceMemoryBudgetPropertiesEXT-heapUsage", offsetof( struct VkPhysicalDeviceMemoryBudgetPropertiesEXT, heapUsage ), sizeof( VkDeviceSize [16U] ) );
	swigStructField( "VkPhysicalDeviceMemoryBudgetPropertiesEXT-sType", offsetof( struct VkPhysicalDeviceMemoryBudgetPropertiesEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceMemoryBudgetPropertiesEXT ) );

	swigComment("struct VkPhysicalDeviceMemoryPriorityFeaturesEXT\n");
	printf( "begin-structure VkPhysicalDeviceMemoryPriorityFeaturesEXT\n" );
	swigStructField( "VkPhysicalDeviceMemoryPriorityFeaturesEXT-memoryPriority", offsetof( struct VkPhysicalDeviceMemoryPriorityFeaturesEXT, memoryPriority ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceMemoryPriorityFeaturesEXT-pNext", offsetof( struct VkPhysicalDeviceMemoryPriorityFeaturesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceMemoryPriorityFeaturesEXT-sType", offsetof( struct VkPhysicalDeviceMemoryPriorityFeaturesEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceMemoryPriorityFeaturesEXT ) );

	swigComment("struct VkMemoryPriorityAllocateInfoEXT\n");
	printf( "begin-structure VkMemoryPriorityAllocateInfoEXT\n" );
	swigStructField( "VkMemoryPriorityAllocateInfoEXT-priority", offsetof( struct VkMemoryPriorityAllocateInfoEXT, priority ), sizeof( float ) );
	swigStructField( "VkMemoryPriorityAllocateInfoEXT-pNext", offsetof( struct VkMemoryPriorityAllocateInfoEXT, pNext ), sizeof( void const * ) );
	swigStructField( "VkMemoryPriorityAllocateInfoEXT-sType", offsetof( struct VkMemoryPriorityAllocateInfoEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkMemoryPriorityAllocateInfoEXT ) );

	swigComment("struct VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV\n");
	printf( "begin-structure VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV\n" );
	swigStructField( "VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV-pNext", offsetof( struct VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV-dedicatedAllocationImageAliasing", offsetof( struct VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV, dedicatedAllocationImageAliasing ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV-sType", offsetof( struct VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV ) );

	swigComment("struct VkPhysicalDeviceBufferDeviceAddressFeaturesEXT\n");
	printf( "begin-structure VkPhysicalDeviceBufferDeviceAddressFeaturesEXT\n" );
	swigStructField( "VkPhysicalDeviceBufferDeviceAddressFeaturesEXT-pNext", offsetof( struct VkPhysicalDeviceBufferDeviceAddressFeaturesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceBufferDeviceAddressFeaturesEXT-bufferDeviceAddress", offsetof( struct VkPhysicalDeviceBufferDeviceAddressFeaturesEXT, bufferDeviceAddress ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceBufferDeviceAddressFeaturesEXT-bufferDeviceAddressCaptureReplay", offsetof( struct VkPhysicalDeviceBufferDeviceAddressFeaturesEXT, bufferDeviceAddressCaptureReplay ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceBufferDeviceAddressFeaturesEXT-sType", offsetof( struct VkPhysicalDeviceBufferDeviceAddressFeaturesEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDeviceBufferDeviceAddressFeaturesEXT-bufferDeviceAddressMultiDevice", offsetof( struct VkPhysicalDeviceBufferDeviceAddressFeaturesEXT, bufferDeviceAddressMultiDevice ), sizeof( VkBool32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceBufferDeviceAddressFeaturesEXT ) );

	swigComment("struct VkBufferDeviceAddressCreateInfoEXT\n");
	printf( "begin-structure VkBufferDeviceAddressCreateInfoEXT\n" );
	swigStructField( "VkBufferDeviceAddressCreateInfoEXT-pNext", offsetof( struct VkBufferDeviceAddressCreateInfoEXT, pNext ), sizeof( void const * ) );
	swigStructField( "VkBufferDeviceAddressCreateInfoEXT-deviceAddress", offsetof( struct VkBufferDeviceAddressCreateInfoEXT, deviceAddress ), sizeof( VkDeviceAddress ) );
	swigStructField( "VkBufferDeviceAddressCreateInfoEXT-sType", offsetof( struct VkBufferDeviceAddressCreateInfoEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkBufferDeviceAddressCreateInfoEXT ) );

	swigComment("struct VkPhysicalDeviceToolPropertiesEXT\n");
	printf( "begin-structure VkPhysicalDeviceToolPropertiesEXT\n" );
	swigStructField( "VkPhysicalDeviceToolPropertiesEXT-purposes", offsetof( struct VkPhysicalDeviceToolPropertiesEXT, purposes ), sizeof( VkToolPurposeFlagsEXT ) );
	swigStructField( "VkPhysicalDeviceToolPropertiesEXT-pNext", offsetof( struct VkPhysicalDeviceToolPropertiesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceToolPropertiesEXT-name", offsetof( struct VkPhysicalDeviceToolPropertiesEXT, name ), sizeof( char [256U] ) );
	swigStructField( "VkPhysicalDeviceToolPropertiesEXT-layer", offsetof( struct VkPhysicalDeviceToolPropertiesEXT, layer ), sizeof( char [256U] ) );
	swigStructField( "VkPhysicalDeviceToolPropertiesEXT-version", offsetof( struct VkPhysicalDeviceToolPropertiesEXT, version ), sizeof( char [256U] ) );
	swigStructField( "VkPhysicalDeviceToolPropertiesEXT-description", offsetof( struct VkPhysicalDeviceToolPropertiesEXT, description ), sizeof( char [256U] ) );
	swigStructField( "VkPhysicalDeviceToolPropertiesEXT-sType", offsetof( struct VkPhysicalDeviceToolPropertiesEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceToolPropertiesEXT ) );

	swigComment("struct VkValidationFeaturesEXT\n");
	printf( "begin-structure VkValidationFeaturesEXT\n" );
	swigStructField( "VkValidationFeaturesEXT-pEnabledValidationFeatures", offsetof( struct VkValidationFeaturesEXT, pEnabledValidationFeatures ), sizeof( VkValidationFeatureEnableEXT const * ) );
	swigStructField( "VkValidationFeaturesEXT-pDisabledValidationFeatures", offsetof( struct VkValidationFeaturesEXT, pDisabledValidationFeatures ), sizeof( VkValidationFeatureDisableEXT const * ) );
	swigStructField( "VkValidationFeaturesEXT-pNext", offsetof( struct VkValidationFeaturesEXT, pNext ), sizeof( void const * ) );
	swigStructField( "VkValidationFeaturesEXT-enabledValidationFeatureCount", offsetof( struct VkValidationFeaturesEXT, enabledValidationFeatureCount ), sizeof( uint32_t ) );
	swigStructField( "VkValidationFeaturesEXT-disabledValidationFeatureCount", offsetof( struct VkValidationFeaturesEXT, disabledValidationFeatureCount ), sizeof( uint32_t ) );
	swigStructField( "VkValidationFeaturesEXT-sType", offsetof( struct VkValidationFeaturesEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkValidationFeaturesEXT ) );

	swigComment("struct VkCooperativeMatrixPropertiesNV\n");
	printf( "begin-structure VkCooperativeMatrixPropertiesNV\n" );
	swigStructField( "VkCooperativeMatrixPropertiesNV-MSize", offsetof( struct VkCooperativeMatrixPropertiesNV, MSize ), sizeof( uint32_t ) );
	swigStructField( "VkCooperativeMatrixPropertiesNV-scope", offsetof( struct VkCooperativeMatrixPropertiesNV, scope ), sizeof( VkScopeNV ) );
	swigStructField( "VkCooperativeMatrixPropertiesNV-pNext", offsetof( struct VkCooperativeMatrixPropertiesNV, pNext ), sizeof( void * ) );
	swigStructField( "VkCooperativeMatrixPropertiesNV-AType", offsetof( struct VkCooperativeMatrixPropertiesNV, AType ), sizeof( VkComponentTypeNV ) );
	swigStructField( "VkCooperativeMatrixPropertiesNV-CType", offsetof( struct VkCooperativeMatrixPropertiesNV, CType ), sizeof( VkComponentTypeNV ) );
	swigStructField( "VkCooperativeMatrixPropertiesNV-NSize", offsetof( struct VkCooperativeMatrixPropertiesNV, NSize ), sizeof( uint32_t ) );
	swigStructField( "VkCooperativeMatrixPropertiesNV-sType", offsetof( struct VkCooperativeMatrixPropertiesNV, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkCooperativeMatrixPropertiesNV-BType", offsetof( struct VkCooperativeMatrixPropertiesNV, BType ), sizeof( VkComponentTypeNV ) );
	swigStructField( "VkCooperativeMatrixPropertiesNV-KSize", offsetof( struct VkCooperativeMatrixPropertiesNV, KSize ), sizeof( uint32_t ) );
	swigStructField( "VkCooperativeMatrixPropertiesNV-DType", offsetof( struct VkCooperativeMatrixPropertiesNV, DType ), sizeof( VkComponentTypeNV ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkCooperativeMatrixPropertiesNV ) );

	swigComment("struct VkPhysicalDeviceCooperativeMatrixFeaturesNV\n");
	printf( "begin-structure VkPhysicalDeviceCooperativeMatrixFeaturesNV\n" );
	swigStructField( "VkPhysicalDeviceCooperativeMatrixFeaturesNV-cooperativeMatrixRobustBufferAccess", offsetof( struct VkPhysicalDeviceCooperativeMatrixFeaturesNV, cooperativeMatrixRobustBufferAccess ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceCooperativeMatrixFeaturesNV-pNext", offsetof( struct VkPhysicalDeviceCooperativeMatrixFeaturesNV, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceCooperativeMatrixFeaturesNV-cooperativeMatrix", offsetof( struct VkPhysicalDeviceCooperativeMatrixFeaturesNV, cooperativeMatrix ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceCooperativeMatrixFeaturesNV-sType", offsetof( struct VkPhysicalDeviceCooperativeMatrixFeaturesNV, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceCooperativeMatrixFeaturesNV ) );

	swigComment("struct VkPhysicalDeviceCooperativeMatrixPropertiesNV\n");
	printf( "begin-structure VkPhysicalDeviceCooperativeMatrixPropertiesNV\n" );
	swigStructField( "VkPhysicalDeviceCooperativeMatrixPropertiesNV-pNext", offsetof( struct VkPhysicalDeviceCooperativeMatrixPropertiesNV, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceCooperativeMatrixPropertiesNV-cooperativeMatrixSupportedStages", offsetof( struct VkPhysicalDeviceCooperativeMatrixPropertiesNV, cooperativeMatrixSupportedStages ), sizeof( VkShaderStageFlags ) );
	swigStructField( "VkPhysicalDeviceCooperativeMatrixPropertiesNV-sType", offsetof( struct VkPhysicalDeviceCooperativeMatrixPropertiesNV, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceCooperativeMatrixPropertiesNV ) );

	swigComment("struct VkPhysicalDeviceCoverageReductionModeFeaturesNV\n");
	printf( "begin-structure VkPhysicalDeviceCoverageReductionModeFeaturesNV\n" );
	swigStructField( "VkPhysicalDeviceCoverageReductionModeFeaturesNV-pNext", offsetof( struct VkPhysicalDeviceCoverageReductionModeFeaturesNV, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceCoverageReductionModeFeaturesNV-coverageReductionMode", offsetof( struct VkPhysicalDeviceCoverageReductionModeFeaturesNV, coverageReductionMode ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceCoverageReductionModeFeaturesNV-sType", offsetof( struct VkPhysicalDeviceCoverageReductionModeFeaturesNV, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceCoverageReductionModeFeaturesNV ) );

	swigComment("struct VkPipelineCoverageReductionStateCreateInfoNV\n");
	printf( "begin-structure VkPipelineCoverageReductionStateCreateInfoNV\n" );
	swigStructField( "VkPipelineCoverageReductionStateCreateInfoNV-pNext", offsetof( struct VkPipelineCoverageReductionStateCreateInfoNV, pNext ), sizeof( void const * ) );
	swigStructField( "VkPipelineCoverageReductionStateCreateInfoNV-coverageReductionMode", offsetof( struct VkPipelineCoverageReductionStateCreateInfoNV, coverageReductionMode ), sizeof( VkCoverageReductionModeNV ) );
	swigStructField( "VkPipelineCoverageReductionStateCreateInfoNV-sType", offsetof( struct VkPipelineCoverageReductionStateCreateInfoNV, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPipelineCoverageReductionStateCreateInfoNV-flags", offsetof( struct VkPipelineCoverageReductionStateCreateInfoNV, flags ), sizeof( VkPipelineCoverageReductionStateCreateFlagsNV ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineCoverageReductionStateCreateInfoNV ) );

	swigComment("struct VkFramebufferMixedSamplesCombinationNV\n");
	printf( "begin-structure VkFramebufferMixedSamplesCombinationNV\n" );
	swigStructField( "VkFramebufferMixedSamplesCombinationNV-pNext", offsetof( struct VkFramebufferMixedSamplesCombinationNV, pNext ), sizeof( void * ) );
	swigStructField( "VkFramebufferMixedSamplesCombinationNV-coverageReductionMode", offsetof( struct VkFramebufferMixedSamplesCombinationNV, coverageReductionMode ), sizeof( VkCoverageReductionModeNV ) );
	swigStructField( "VkFramebufferMixedSamplesCombinationNV-rasterizationSamples", offsetof( struct VkFramebufferMixedSamplesCombinationNV, rasterizationSamples ), sizeof( VkSampleCountFlagBits ) );
	swigStructField( "VkFramebufferMixedSamplesCombinationNV-depthStencilSamples", offsetof( struct VkFramebufferMixedSamplesCombinationNV, depthStencilSamples ), sizeof( VkSampleCountFlags ) );
	swigStructField( "VkFramebufferMixedSamplesCombinationNV-colorSamples", offsetof( struct VkFramebufferMixedSamplesCombinationNV, colorSamples ), sizeof( VkSampleCountFlags ) );
	swigStructField( "VkFramebufferMixedSamplesCombinationNV-sType", offsetof( struct VkFramebufferMixedSamplesCombinationNV, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkFramebufferMixedSamplesCombinationNV ) );

	swigComment("struct VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT\n");
	printf( "begin-structure VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT\n" );
	swigStructField( "VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT-pNext", offsetof( struct VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT-sType", offsetof( struct VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT-fragmentShaderSampleInterlock", offsetof( struct VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT, fragmentShaderSampleInterlock ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT-fragmentShaderPixelInterlock", offsetof( struct VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT, fragmentShaderPixelInterlock ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT-fragmentShaderShadingRateInterlock", offsetof( struct VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT, fragmentShaderShadingRateInterlock ), sizeof( VkBool32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT ) );

	swigComment("struct VkPhysicalDeviceYcbcrImageArraysFeaturesEXT\n");
	printf( "begin-structure VkPhysicalDeviceYcbcrImageArraysFeaturesEXT\n" );
	swigStructField( "VkPhysicalDeviceYcbcrImageArraysFeaturesEXT-pNext", offsetof( struct VkPhysicalDeviceYcbcrImageArraysFeaturesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceYcbcrImageArraysFeaturesEXT-ycbcrImageArrays", offsetof( struct VkPhysicalDeviceYcbcrImageArraysFeaturesEXT, ycbcrImageArrays ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceYcbcrImageArraysFeaturesEXT-sType", offsetof( struct VkPhysicalDeviceYcbcrImageArraysFeaturesEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceYcbcrImageArraysFeaturesEXT ) );

	swigComment("struct VkPhysicalDeviceProvokingVertexFeaturesEXT\n");
	printf( "begin-structure VkPhysicalDeviceProvokingVertexFeaturesEXT\n" );
	swigStructField( "VkPhysicalDeviceProvokingVertexFeaturesEXT-provokingVertexLast", offsetof( struct VkPhysicalDeviceProvokingVertexFeaturesEXT, provokingVertexLast ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceProvokingVertexFeaturesEXT-pNext", offsetof( struct VkPhysicalDeviceProvokingVertexFeaturesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceProvokingVertexFeaturesEXT-transformFeedbackPreservesProvokingVertex", offsetof( struct VkPhysicalDeviceProvokingVertexFeaturesEXT, transformFeedbackPreservesProvokingVertex ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceProvokingVertexFeaturesEXT-sType", offsetof( struct VkPhysicalDeviceProvokingVertexFeaturesEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceProvokingVertexFeaturesEXT ) );

	swigComment("struct VkPhysicalDeviceProvokingVertexPropertiesEXT\n");
	printf( "begin-structure VkPhysicalDeviceProvokingVertexPropertiesEXT\n" );
	swigStructField( "VkPhysicalDeviceProvokingVertexPropertiesEXT-provokingVertexModePerPipeline", offsetof( struct VkPhysicalDeviceProvokingVertexPropertiesEXT, provokingVertexModePerPipeline ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceProvokingVertexPropertiesEXT-pNext", offsetof( struct VkPhysicalDeviceProvokingVertexPropertiesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceProvokingVertexPropertiesEXT-sType", offsetof( struct VkPhysicalDeviceProvokingVertexPropertiesEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDeviceProvokingVertexPropertiesEXT-transformFeedbackPreservesTriangleFanProvokingVertex", offsetof( struct VkPhysicalDeviceProvokingVertexPropertiesEXT, transformFeedbackPreservesTriangleFanProvokingVertex ), sizeof( VkBool32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceProvokingVertexPropertiesEXT ) );

	swigComment("struct VkPipelineRasterizationProvokingVertexStateCreateInfoEXT\n");
	printf( "begin-structure VkPipelineRasterizationProvokingVertexStateCreateInfoEXT\n" );
	swigStructField( "VkPipelineRasterizationProvokingVertexStateCreateInfoEXT-pNext", offsetof( struct VkPipelineRasterizationProvokingVertexStateCreateInfoEXT, pNext ), sizeof( void const * ) );
	swigStructField( "VkPipelineRasterizationProvokingVertexStateCreateInfoEXT-provokingVertexMode", offsetof( struct VkPipelineRasterizationProvokingVertexStateCreateInfoEXT, provokingVertexMode ), sizeof( VkProvokingVertexModeEXT ) );
	swigStructField( "VkPipelineRasterizationProvokingVertexStateCreateInfoEXT-sType", offsetof( struct VkPipelineRasterizationProvokingVertexStateCreateInfoEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineRasterizationProvokingVertexStateCreateInfoEXT ) );

	swigComment("struct VkHeadlessSurfaceCreateInfoEXT\n");
	printf( "begin-structure VkHeadlessSurfaceCreateInfoEXT\n" );
	swigStructField( "VkHeadlessSurfaceCreateInfoEXT-pNext", offsetof( struct VkHeadlessSurfaceCreateInfoEXT, pNext ), sizeof( void const * ) );
	swigStructField( "VkHeadlessSurfaceCreateInfoEXT-sType", offsetof( struct VkHeadlessSurfaceCreateInfoEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkHeadlessSurfaceCreateInfoEXT-flags", offsetof( struct VkHeadlessSurfaceCreateInfoEXT, flags ), sizeof( VkHeadlessSurfaceCreateFlagsEXT ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkHeadlessSurfaceCreateInfoEXT ) );

	swigComment("struct VkPhysicalDeviceLineRasterizationFeaturesEXT\n");
	printf( "begin-structure VkPhysicalDeviceLineRasterizationFeaturesEXT\n" );
	swigStructField( "VkPhysicalDeviceLineRasterizationFeaturesEXT-pNext", offsetof( struct VkPhysicalDeviceLineRasterizationFeaturesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceLineRasterizationFeaturesEXT-rectangularLines", offsetof( struct VkPhysicalDeviceLineRasterizationFeaturesEXT, rectangularLines ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceLineRasterizationFeaturesEXT-stippledRectangularLines", offsetof( struct VkPhysicalDeviceLineRasterizationFeaturesEXT, stippledRectangularLines ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceLineRasterizationFeaturesEXT-smoothLines", offsetof( struct VkPhysicalDeviceLineRasterizationFeaturesEXT, smoothLines ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceLineRasterizationFeaturesEXT-stippledSmoothLines", offsetof( struct VkPhysicalDeviceLineRasterizationFeaturesEXT, stippledSmoothLines ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceLineRasterizationFeaturesEXT-sType", offsetof( struct VkPhysicalDeviceLineRasterizationFeaturesEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDeviceLineRasterizationFeaturesEXT-bresenhamLines", offsetof( struct VkPhysicalDeviceLineRasterizationFeaturesEXT, bresenhamLines ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceLineRasterizationFeaturesEXT-stippledBresenhamLines", offsetof( struct VkPhysicalDeviceLineRasterizationFeaturesEXT, stippledBresenhamLines ), sizeof( VkBool32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceLineRasterizationFeaturesEXT ) );

	swigComment("struct VkPhysicalDeviceLineRasterizationPropertiesEXT\n");
	printf( "begin-structure VkPhysicalDeviceLineRasterizationPropertiesEXT\n" );
	swigStructField( "VkPhysicalDeviceLineRasterizationPropertiesEXT-pNext", offsetof( struct VkPhysicalDeviceLineRasterizationPropertiesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceLineRasterizationPropertiesEXT-lineSubPixelPrecisionBits", offsetof( struct VkPhysicalDeviceLineRasterizationPropertiesEXT, lineSubPixelPrecisionBits ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLineRasterizationPropertiesEXT-sType", offsetof( struct VkPhysicalDeviceLineRasterizationPropertiesEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceLineRasterizationPropertiesEXT ) );

	swigComment("struct VkPipelineRasterizationLineStateCreateInfoEXT\n");
	printf( "begin-structure VkPipelineRasterizationLineStateCreateInfoEXT\n" );
	swigStructField( "VkPipelineRasterizationLineStateCreateInfoEXT-lineStipplePattern", offsetof( struct VkPipelineRasterizationLineStateCreateInfoEXT, lineStipplePattern ), sizeof( uint16_t ) );
	swigStructField( "VkPipelineRasterizationLineStateCreateInfoEXT-pNext", offsetof( struct VkPipelineRasterizationLineStateCreateInfoEXT, pNext ), sizeof( void const * ) );
	swigStructField( "VkPipelineRasterizationLineStateCreateInfoEXT-lineStippleFactor", offsetof( struct VkPipelineRasterizationLineStateCreateInfoEXT, lineStippleFactor ), sizeof( uint32_t ) );
	swigStructField( "VkPipelineRasterizationLineStateCreateInfoEXT-lineRasterizationMode", offsetof( struct VkPipelineRasterizationLineStateCreateInfoEXT, lineRasterizationMode ), sizeof( VkLineRasterizationModeEXT ) );
	swigStructField( "VkPipelineRasterizationLineStateCreateInfoEXT-stippledLineEnable", offsetof( struct VkPipelineRasterizationLineStateCreateInfoEXT, stippledLineEnable ), sizeof( VkBool32 ) );
	swigStructField( "VkPipelineRasterizationLineStateCreateInfoEXT-sType", offsetof( struct VkPipelineRasterizationLineStateCreateInfoEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineRasterizationLineStateCreateInfoEXT ) );

	swigComment("struct VkPhysicalDeviceShaderAtomicFloatFeaturesEXT\n");
	printf( "begin-structure VkPhysicalDeviceShaderAtomicFloatFeaturesEXT\n" );
	swigStructField( "VkPhysicalDeviceShaderAtomicFloatFeaturesEXT-sparseImageFloat32AtomicAdd", offsetof( struct VkPhysicalDeviceShaderAtomicFloatFeaturesEXT, sparseImageFloat32AtomicAdd ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderAtomicFloatFeaturesEXT-shaderImageFloat32AtomicAdd", offsetof( struct VkPhysicalDeviceShaderAtomicFloatFeaturesEXT, shaderImageFloat32AtomicAdd ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderAtomicFloatFeaturesEXT-shaderSharedFloat64AtomicAdd", offsetof( struct VkPhysicalDeviceShaderAtomicFloatFeaturesEXT, shaderSharedFloat64AtomicAdd ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderAtomicFloatFeaturesEXT-shaderSharedFloat32AtomicAdd", offsetof( struct VkPhysicalDeviceShaderAtomicFloatFeaturesEXT, shaderSharedFloat32AtomicAdd ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderAtomicFloatFeaturesEXT-shaderBufferFloat64AtomicAdd", offsetof( struct VkPhysicalDeviceShaderAtomicFloatFeaturesEXT, shaderBufferFloat64AtomicAdd ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderAtomicFloatFeaturesEXT-shaderBufferFloat32AtomicAdd", offsetof( struct VkPhysicalDeviceShaderAtomicFloatFeaturesEXT, shaderBufferFloat32AtomicAdd ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderAtomicFloatFeaturesEXT-pNext", offsetof( struct VkPhysicalDeviceShaderAtomicFloatFeaturesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceShaderAtomicFloatFeaturesEXT-sparseImageFloat32Atomics", offsetof( struct VkPhysicalDeviceShaderAtomicFloatFeaturesEXT, sparseImageFloat32Atomics ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderAtomicFloatFeaturesEXT-shaderImageFloat32Atomics", offsetof( struct VkPhysicalDeviceShaderAtomicFloatFeaturesEXT, shaderImageFloat32Atomics ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderAtomicFloatFeaturesEXT-shaderSharedFloat64Atomics", offsetof( struct VkPhysicalDeviceShaderAtomicFloatFeaturesEXT, shaderSharedFloat64Atomics ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderAtomicFloatFeaturesEXT-shaderSharedFloat32Atomics", offsetof( struct VkPhysicalDeviceShaderAtomicFloatFeaturesEXT, shaderSharedFloat32Atomics ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderAtomicFloatFeaturesEXT-shaderBufferFloat64Atomics", offsetof( struct VkPhysicalDeviceShaderAtomicFloatFeaturesEXT, shaderBufferFloat64Atomics ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderAtomicFloatFeaturesEXT-shaderBufferFloat32Atomics", offsetof( struct VkPhysicalDeviceShaderAtomicFloatFeaturesEXT, shaderBufferFloat32Atomics ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderAtomicFloatFeaturesEXT-sType", offsetof( struct VkPhysicalDeviceShaderAtomicFloatFeaturesEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceShaderAtomicFloatFeaturesEXT ) );

	swigComment("struct VkPhysicalDeviceIndexTypeUint8FeaturesEXT\n");
	printf( "begin-structure VkPhysicalDeviceIndexTypeUint8FeaturesEXT\n" );
	swigStructField( "VkPhysicalDeviceIndexTypeUint8FeaturesEXT-pNext", offsetof( struct VkPhysicalDeviceIndexTypeUint8FeaturesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceIndexTypeUint8FeaturesEXT-sType", offsetof( struct VkPhysicalDeviceIndexTypeUint8FeaturesEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDeviceIndexTypeUint8FeaturesEXT-indexTypeUint8", offsetof( struct VkPhysicalDeviceIndexTypeUint8FeaturesEXT, indexTypeUint8 ), sizeof( VkBool32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceIndexTypeUint8FeaturesEXT ) );

	swigComment("struct VkPhysicalDeviceExtendedDynamicStateFeaturesEXT\n");
	printf( "begin-structure VkPhysicalDeviceExtendedDynamicStateFeaturesEXT\n" );
	swigStructField( "VkPhysicalDeviceExtendedDynamicStateFeaturesEXT-pNext", offsetof( struct VkPhysicalDeviceExtendedDynamicStateFeaturesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceExtendedDynamicStateFeaturesEXT-extendedDynamicState", offsetof( struct VkPhysicalDeviceExtendedDynamicStateFeaturesEXT, extendedDynamicState ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceExtendedDynamicStateFeaturesEXT-sType", offsetof( struct VkPhysicalDeviceExtendedDynamicStateFeaturesEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceExtendedDynamicStateFeaturesEXT ) );

	swigComment("struct VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT\n");
	printf( "begin-structure VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT\n" );
	swigStructField( "VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT-sparseImageFloat32AtomicMinMax", offsetof( struct VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT, sparseImageFloat32AtomicMinMax ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT-shaderImageFloat32AtomicMinMax", offsetof( struct VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT, shaderImageFloat32AtomicMinMax ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT-shaderSharedFloat64AtomicMinMax", offsetof( struct VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT, shaderSharedFloat64AtomicMinMax ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT-shaderSharedFloat32AtomicMinMax", offsetof( struct VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT, shaderSharedFloat32AtomicMinMax ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT-shaderSharedFloat16AtomicMinMax", offsetof( struct VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT, shaderSharedFloat16AtomicMinMax ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT-shaderBufferFloat64AtomicMinMax", offsetof( struct VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT, shaderBufferFloat64AtomicMinMax ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT-shaderBufferFloat32AtomicMinMax", offsetof( struct VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT, shaderBufferFloat32AtomicMinMax ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT-shaderBufferFloat16AtomicMinMax", offsetof( struct VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT, shaderBufferFloat16AtomicMinMax ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT-shaderSharedFloat16AtomicAdd", offsetof( struct VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT, shaderSharedFloat16AtomicAdd ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT-shaderBufferFloat16AtomicAdd", offsetof( struct VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT, shaderBufferFloat16AtomicAdd ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT-pNext", offsetof( struct VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT-shaderSharedFloat16Atomics", offsetof( struct VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT, shaderSharedFloat16Atomics ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT-shaderBufferFloat16Atomics", offsetof( struct VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT, shaderBufferFloat16Atomics ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT-sType", offsetof( struct VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT ) );

	swigComment("struct VkPhysicalDeviceShaderDemoteToHelperInvocationFeaturesEXT\n");
	printf( "begin-structure VkPhysicalDeviceShaderDemoteToHelperInvocationFeaturesEXT\n" );
	swigStructField( "VkPhysicalDeviceShaderDemoteToHelperInvocationFeaturesEXT-shaderDemoteToHelperInvocation", offsetof( struct VkPhysicalDeviceShaderDemoteToHelperInvocationFeaturesEXT, shaderDemoteToHelperInvocation ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceShaderDemoteToHelperInvocationFeaturesEXT-pNext", offsetof( struct VkPhysicalDeviceShaderDemoteToHelperInvocationFeaturesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceShaderDemoteToHelperInvocationFeaturesEXT-sType", offsetof( struct VkPhysicalDeviceShaderDemoteToHelperInvocationFeaturesEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceShaderDemoteToHelperInvocationFeaturesEXT ) );

	swigComment("struct VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV\n");
	printf( "begin-structure VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV\n" );
	swigStructField( "VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV-maxIndirectCommandsTokenCount", offsetof( struct VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV, maxIndirectCommandsTokenCount ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV-pNext", offsetof( struct VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV-maxIndirectCommandsTokenOffset", offsetof( struct VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV, maxIndirectCommandsTokenOffset ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV-maxIndirectSequenceCount", offsetof( struct VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV, maxIndirectSequenceCount ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV-maxGraphicsShaderGroupCount", offsetof( struct VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV, maxGraphicsShaderGroupCount ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV-sType", offsetof( struct VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV-maxIndirectCommandsStreamCount", offsetof( struct VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV, maxIndirectCommandsStreamCount ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV-maxIndirectCommandsStreamStride", offsetof( struct VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV, maxIndirectCommandsStreamStride ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV-minSequencesCountBufferOffsetAlignment", offsetof( struct VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV, minSequencesCountBufferOffsetAlignment ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV-minSequencesIndexBufferOffsetAlignment", offsetof( struct VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV, minSequencesIndexBufferOffsetAlignment ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV-minIndirectCommandsBufferOffsetAlignment", offsetof( struct VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV, minIndirectCommandsBufferOffsetAlignment ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV ) );

	swigComment("struct VkPhysicalDeviceDeviceGeneratedCommandsFeaturesNV\n");
	printf( "begin-structure VkPhysicalDeviceDeviceGeneratedCommandsFeaturesNV\n" );
	swigStructField( "VkPhysicalDeviceDeviceGeneratedCommandsFeaturesNV-pNext", offsetof( struct VkPhysicalDeviceDeviceGeneratedCommandsFeaturesNV, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceDeviceGeneratedCommandsFeaturesNV-sType", offsetof( struct VkPhysicalDeviceDeviceGeneratedCommandsFeaturesNV, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDeviceDeviceGeneratedCommandsFeaturesNV-deviceGeneratedCommands", offsetof( struct VkPhysicalDeviceDeviceGeneratedCommandsFeaturesNV, deviceGeneratedCommands ), sizeof( VkBool32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceDeviceGeneratedCommandsFeaturesNV ) );

	swigComment("struct VkGraphicsShaderGroupCreateInfoNV\n");
	printf( "begin-structure VkGraphicsShaderGroupCreateInfoNV\n" );
	swigStructField( "VkGraphicsShaderGroupCreateInfoNV-pNext", offsetof( struct VkGraphicsShaderGroupCreateInfoNV, pNext ), sizeof( void const * ) );
	swigStructField( "VkGraphicsShaderGroupCreateInfoNV-pStages", offsetof( struct VkGraphicsShaderGroupCreateInfoNV, pStages ), sizeof( VkPipelineShaderStageCreateInfo const * ) );
	swigStructField( "VkGraphicsShaderGroupCreateInfoNV-pVertexInputState", offsetof( struct VkGraphicsShaderGroupCreateInfoNV, pVertexInputState ), sizeof( VkPipelineVertexInputStateCreateInfo const * ) );
	swigStructField( "VkGraphicsShaderGroupCreateInfoNV-stageCount", offsetof( struct VkGraphicsShaderGroupCreateInfoNV, stageCount ), sizeof( uint32_t ) );
	swigStructField( "VkGraphicsShaderGroupCreateInfoNV-pTessellationState", offsetof( struct VkGraphicsShaderGroupCreateInfoNV, pTessellationState ), sizeof( VkPipelineTessellationStateCreateInfo const * ) );
	swigStructField( "VkGraphicsShaderGroupCreateInfoNV-sType", offsetof( struct VkGraphicsShaderGroupCreateInfoNV, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkGraphicsShaderGroupCreateInfoNV ) );

	swigComment("struct VkGraphicsPipelineShaderGroupsCreateInfoNV\n");
	printf( "begin-structure VkGraphicsPipelineShaderGroupsCreateInfoNV\n" );
	swigStructField( "VkGraphicsPipelineShaderGroupsCreateInfoNV-pNext", offsetof( struct VkGraphicsPipelineShaderGroupsCreateInfoNV, pNext ), sizeof( void const * ) );
	swigStructField( "VkGraphicsPipelineShaderGroupsCreateInfoNV-groupCount", offsetof( struct VkGraphicsPipelineShaderGroupsCreateInfoNV, groupCount ), sizeof( uint32_t ) );
	swigStructField( "VkGraphicsPipelineShaderGroupsCreateInfoNV-pipelineCount", offsetof( struct VkGraphicsPipelineShaderGroupsCreateInfoNV, pipelineCount ), sizeof( uint32_t ) );
	swigStructField( "VkGraphicsPipelineShaderGroupsCreateInfoNV-sType", offsetof( struct VkGraphicsPipelineShaderGroupsCreateInfoNV, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkGraphicsPipelineShaderGroupsCreateInfoNV-pGroups", offsetof( struct VkGraphicsPipelineShaderGroupsCreateInfoNV, pGroups ), sizeof( VkGraphicsShaderGroupCreateInfoNV const * ) );
	swigStructField( "VkGraphicsPipelineShaderGroupsCreateInfoNV-pPipelines", offsetof( struct VkGraphicsPipelineShaderGroupsCreateInfoNV, pPipelines ), sizeof( VkPipeline const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkGraphicsPipelineShaderGroupsCreateInfoNV ) );

	swigComment("struct VkBindShaderGroupIndirectCommandNV\n");
	printf( "begin-structure VkBindShaderGroupIndirectCommandNV\n" );
	swigStructField( "VkBindShaderGroupIndirectCommandNV-groupIndex", offsetof( struct VkBindShaderGroupIndirectCommandNV, groupIndex ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkBindShaderGroupIndirectCommandNV ) );

	swigComment("struct VkBindIndexBufferIndirectCommandNV\n");
	printf( "begin-structure VkBindIndexBufferIndirectCommandNV\n" );
	swigStructField( "VkBindIndexBufferIndirectCommandNV-indexType", offsetof( struct VkBindIndexBufferIndirectCommandNV, indexType ), sizeof( VkIndexType ) );
	swigStructField( "VkBindIndexBufferIndirectCommandNV-bufferAddress", offsetof( struct VkBindIndexBufferIndirectCommandNV, bufferAddress ), sizeof( VkDeviceAddress ) );
	swigStructField( "VkBindIndexBufferIndirectCommandNV-size", offsetof( struct VkBindIndexBufferIndirectCommandNV, size ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkBindIndexBufferIndirectCommandNV ) );

	swigComment("struct VkBindVertexBufferIndirectCommandNV\n");
	printf( "begin-structure VkBindVertexBufferIndirectCommandNV\n" );
	swigStructField( "VkBindVertexBufferIndirectCommandNV-bufferAddress", offsetof( struct VkBindVertexBufferIndirectCommandNV, bufferAddress ), sizeof( VkDeviceAddress ) );
	swigStructField( "VkBindVertexBufferIndirectCommandNV-size", offsetof( struct VkBindVertexBufferIndirectCommandNV, size ), sizeof( uint32_t ) );
	swigStructField( "VkBindVertexBufferIndirectCommandNV-stride", offsetof( struct VkBindVertexBufferIndirectCommandNV, stride ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkBindVertexBufferIndirectCommandNV ) );

	swigComment("struct VkSetStateFlagsIndirectCommandNV\n");
	printf( "begin-structure VkSetStateFlagsIndirectCommandNV\n" );
	swigStructField( "VkSetStateFlagsIndirectCommandNV-data", offsetof( struct VkSetStateFlagsIndirectCommandNV, data ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSetStateFlagsIndirectCommandNV ) );

	swigComment("struct VkIndirectCommandsStreamNV\n");
	printf( "begin-structure VkIndirectCommandsStreamNV\n" );
	swigStructField( "VkIndirectCommandsStreamNV-buffer", offsetof( struct VkIndirectCommandsStreamNV, buffer ), sizeof( VkBuffer ) );
	swigStructField( "VkIndirectCommandsStreamNV-offset", offsetof( struct VkIndirectCommandsStreamNV, offset ), sizeof( VkDeviceSize ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkIndirectCommandsStreamNV ) );

	swigComment("struct VkIndirectCommandsLayoutTokenNV\n");
	printf( "begin-structure VkIndirectCommandsLayoutTokenNV\n" );
	swigStructField( "VkIndirectCommandsLayoutTokenNV-pushconstantSize", offsetof( struct VkIndirectCommandsLayoutTokenNV, pushconstantSize ), sizeof( uint32_t ) );
	swigStructField( "VkIndirectCommandsLayoutTokenNV-pushconstantShaderStageFlags", offsetof( struct VkIndirectCommandsLayoutTokenNV, pushconstantShaderStageFlags ), sizeof( VkShaderStageFlags ) );
	swigStructField( "VkIndirectCommandsLayoutTokenNV-pIndexTypes", offsetof( struct VkIndirectCommandsLayoutTokenNV, pIndexTypes ), sizeof( VkIndexType const * ) );
	swigStructField( "VkIndirectCommandsLayoutTokenNV-pNext", offsetof( struct VkIndirectCommandsLayoutTokenNV, pNext ), sizeof( void const * ) );
	swigStructField( "VkIndirectCommandsLayoutTokenNV-pIndexTypeValues", offsetof( struct VkIndirectCommandsLayoutTokenNV, pIndexTypeValues ), sizeof( uint32_t const * ) );
	swigStructField( "VkIndirectCommandsLayoutTokenNV-stream", offsetof( struct VkIndirectCommandsLayoutTokenNV, stream ), sizeof( uint32_t ) );
	swigStructField( "VkIndirectCommandsLayoutTokenNV-vertexDynamicStride", offsetof( struct VkIndirectCommandsLayoutTokenNV, vertexDynamicStride ), sizeof( VkBool32 ) );
	swigStructField( "VkIndirectCommandsLayoutTokenNV-offset", offsetof( struct VkIndirectCommandsLayoutTokenNV, offset ), sizeof( uint32_t ) );
	swigStructField( "VkIndirectCommandsLayoutTokenNV-indexTypeCount", offsetof( struct VkIndirectCommandsLayoutTokenNV, indexTypeCount ), sizeof( uint32_t ) );
	swigStructField( "VkIndirectCommandsLayoutTokenNV-pushconstantPipelineLayout", offsetof( struct VkIndirectCommandsLayoutTokenNV, pushconstantPipelineLayout ), sizeof( VkPipelineLayout ) );
	swigStructField( "VkIndirectCommandsLayoutTokenNV-pushconstantOffset", offsetof( struct VkIndirectCommandsLayoutTokenNV, pushconstantOffset ), sizeof( uint32_t ) );
	swigStructField( "VkIndirectCommandsLayoutTokenNV-tokenType", offsetof( struct VkIndirectCommandsLayoutTokenNV, tokenType ), sizeof( VkIndirectCommandsTokenTypeNV ) );
	swigStructField( "VkIndirectCommandsLayoutTokenNV-indirectStateFlags", offsetof( struct VkIndirectCommandsLayoutTokenNV, indirectStateFlags ), sizeof( VkIndirectStateFlagsNV ) );
	swigStructField( "VkIndirectCommandsLayoutTokenNV-sType", offsetof( struct VkIndirectCommandsLayoutTokenNV, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkIndirectCommandsLayoutTokenNV-vertexBindingUnit", offsetof( struct VkIndirectCommandsLayoutTokenNV, vertexBindingUnit ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkIndirectCommandsLayoutTokenNV ) );

	swigComment("struct VkIndirectCommandsLayoutCreateInfoNV\n");
	printf( "begin-structure VkIndirectCommandsLayoutCreateInfoNV\n" );
	swigStructField( "VkIndirectCommandsLayoutCreateInfoNV-tokenCount", offsetof( struct VkIndirectCommandsLayoutCreateInfoNV, tokenCount ), sizeof( uint32_t ) );
	swigStructField( "VkIndirectCommandsLayoutCreateInfoNV-pNext", offsetof( struct VkIndirectCommandsLayoutCreateInfoNV, pNext ), sizeof( void const * ) );
	swigStructField( "VkIndirectCommandsLayoutCreateInfoNV-pipelineBindPoint", offsetof( struct VkIndirectCommandsLayoutCreateInfoNV, pipelineBindPoint ), sizeof( VkPipelineBindPoint ) );
	swigStructField( "VkIndirectCommandsLayoutCreateInfoNV-pTokens", offsetof( struct VkIndirectCommandsLayoutCreateInfoNV, pTokens ), sizeof( VkIndirectCommandsLayoutTokenNV const * ) );
	swigStructField( "VkIndirectCommandsLayoutCreateInfoNV-pStreamStrides", offsetof( struct VkIndirectCommandsLayoutCreateInfoNV, pStreamStrides ), sizeof( uint32_t const * ) );
	swigStructField( "VkIndirectCommandsLayoutCreateInfoNV-sType", offsetof( struct VkIndirectCommandsLayoutCreateInfoNV, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkIndirectCommandsLayoutCreateInfoNV-flags", offsetof( struct VkIndirectCommandsLayoutCreateInfoNV, flags ), sizeof( VkIndirectCommandsLayoutUsageFlagsNV ) );
	swigStructField( "VkIndirectCommandsLayoutCreateInfoNV-streamCount", offsetof( struct VkIndirectCommandsLayoutCreateInfoNV, streamCount ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkIndirectCommandsLayoutCreateInfoNV ) );

	swigComment("struct VkGeneratedCommandsInfoNV\n");
	printf( "begin-structure VkGeneratedCommandsInfoNV\n" );
	swigStructField( "VkGeneratedCommandsInfoNV-sequencesIndexBuffer", offsetof( struct VkGeneratedCommandsInfoNV, sequencesIndexBuffer ), sizeof( VkBuffer ) );
	swigStructField( "VkGeneratedCommandsInfoNV-sequencesCountBuffer", offsetof( struct VkGeneratedCommandsInfoNV, sequencesCountBuffer ), sizeof( VkBuffer ) );
	swigStructField( "VkGeneratedCommandsInfoNV-pNext", offsetof( struct VkGeneratedCommandsInfoNV, pNext ), sizeof( void const * ) );
	swigStructField( "VkGeneratedCommandsInfoNV-sequencesCount", offsetof( struct VkGeneratedCommandsInfoNV, sequencesCount ), sizeof( uint32_t ) );
	swigStructField( "VkGeneratedCommandsInfoNV-preprocessOffset", offsetof( struct VkGeneratedCommandsInfoNV, preprocessOffset ), sizeof( VkDeviceSize ) );
	swigStructField( "VkGeneratedCommandsInfoNV-indirectCommandsLayout", offsetof( struct VkGeneratedCommandsInfoNV, indirectCommandsLayout ), sizeof( VkIndirectCommandsLayoutNV ) );
	swigStructField( "VkGeneratedCommandsInfoNV-preprocessSize", offsetof( struct VkGeneratedCommandsInfoNV, preprocessSize ), sizeof( VkDeviceSize ) );
	swigStructField( "VkGeneratedCommandsInfoNV-streamCount", offsetof( struct VkGeneratedCommandsInfoNV, streamCount ), sizeof( uint32_t ) );
	swigStructField( "VkGeneratedCommandsInfoNV-sequencesCountOffset", offsetof( struct VkGeneratedCommandsInfoNV, sequencesCountOffset ), sizeof( VkDeviceSize ) );
	swigStructField( "VkGeneratedCommandsInfoNV-sequencesIndexOffset", offsetof( struct VkGeneratedCommandsInfoNV, sequencesIndexOffset ), sizeof( VkDeviceSize ) );
	swigStructField( "VkGeneratedCommandsInfoNV-pipeline", offsetof( struct VkGeneratedCommandsInfoNV, pipeline ), sizeof( VkPipeline ) );
	swigStructField( "VkGeneratedCommandsInfoNV-pStreams", offsetof( struct VkGeneratedCommandsInfoNV, pStreams ), sizeof( VkIndirectCommandsStreamNV const * ) );
	swigStructField( "VkGeneratedCommandsInfoNV-pipelineBindPoint", offsetof( struct VkGeneratedCommandsInfoNV, pipelineBindPoint ), sizeof( VkPipelineBindPoint ) );
	swigStructField( "VkGeneratedCommandsInfoNV-sType", offsetof( struct VkGeneratedCommandsInfoNV, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkGeneratedCommandsInfoNV-preprocessBuffer", offsetof( struct VkGeneratedCommandsInfoNV, preprocessBuffer ), sizeof( VkBuffer ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkGeneratedCommandsInfoNV ) );

	swigComment("struct VkGeneratedCommandsMemoryRequirementsInfoNV\n");
	printf( "begin-structure VkGeneratedCommandsMemoryRequirementsInfoNV\n" );
	swigStructField( "VkGeneratedCommandsMemoryRequirementsInfoNV-pipeline", offsetof( struct VkGeneratedCommandsMemoryRequirementsInfoNV, pipeline ), sizeof( VkPipeline ) );
	swigStructField( "VkGeneratedCommandsMemoryRequirementsInfoNV-pNext", offsetof( struct VkGeneratedCommandsMemoryRequirementsInfoNV, pNext ), sizeof( void const * ) );
	swigStructField( "VkGeneratedCommandsMemoryRequirementsInfoNV-pipelineBindPoint", offsetof( struct VkGeneratedCommandsMemoryRequirementsInfoNV, pipelineBindPoint ), sizeof( VkPipelineBindPoint ) );
	swigStructField( "VkGeneratedCommandsMemoryRequirementsInfoNV-indirectCommandsLayout", offsetof( struct VkGeneratedCommandsMemoryRequirementsInfoNV, indirectCommandsLayout ), sizeof( VkIndirectCommandsLayoutNV ) );
	swigStructField( "VkGeneratedCommandsMemoryRequirementsInfoNV-maxSequencesCount", offsetof( struct VkGeneratedCommandsMemoryRequirementsInfoNV, maxSequencesCount ), sizeof( uint32_t ) );
	swigStructField( "VkGeneratedCommandsMemoryRequirementsInfoNV-sType", offsetof( struct VkGeneratedCommandsMemoryRequirementsInfoNV, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkGeneratedCommandsMemoryRequirementsInfoNV ) );

	swigComment("struct VkPhysicalDeviceInheritedViewportScissorFeaturesNV\n");
	printf( "begin-structure VkPhysicalDeviceInheritedViewportScissorFeaturesNV\n" );
	swigStructField( "VkPhysicalDeviceInheritedViewportScissorFeaturesNV-pNext", offsetof( struct VkPhysicalDeviceInheritedViewportScissorFeaturesNV, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceInheritedViewportScissorFeaturesNV-sType", offsetof( struct VkPhysicalDeviceInheritedViewportScissorFeaturesNV, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDeviceInheritedViewportScissorFeaturesNV-inheritedViewportScissor2D", offsetof( struct VkPhysicalDeviceInheritedViewportScissorFeaturesNV, inheritedViewportScissor2D ), sizeof( VkBool32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceInheritedViewportScissorFeaturesNV ) );

	swigComment("struct VkCommandBufferInheritanceViewportScissorInfoNV\n");
	printf( "begin-structure VkCommandBufferInheritanceViewportScissorInfoNV\n" );
	swigStructField( "VkCommandBufferInheritanceViewportScissorInfoNV-pNext", offsetof( struct VkCommandBufferInheritanceViewportScissorInfoNV, pNext ), sizeof( void const * ) );
	swigStructField( "VkCommandBufferInheritanceViewportScissorInfoNV-viewportDepthCount", offsetof( struct VkCommandBufferInheritanceViewportScissorInfoNV, viewportDepthCount ), sizeof( uint32_t ) );
	swigStructField( "VkCommandBufferInheritanceViewportScissorInfoNV-sType", offsetof( struct VkCommandBufferInheritanceViewportScissorInfoNV, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkCommandBufferInheritanceViewportScissorInfoNV-viewportScissor2D", offsetof( struct VkCommandBufferInheritanceViewportScissorInfoNV, viewportScissor2D ), sizeof( VkBool32 ) );
	swigStructField( "VkCommandBufferInheritanceViewportScissorInfoNV-pViewportDepths", offsetof( struct VkCommandBufferInheritanceViewportScissorInfoNV, pViewportDepths ), sizeof( VkViewport const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkCommandBufferInheritanceViewportScissorInfoNV ) );

	swigComment("struct VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT\n");
	printf( "begin-structure VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT\n" );
	swigStructField( "VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT-pNext", offsetof( struct VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT-sType", offsetof( struct VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT-texelBufferAlignment", offsetof( struct VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT, texelBufferAlignment ), sizeof( VkBool32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT ) );

	swigComment("struct VkPhysicalDeviceTexelBufferAlignmentPropertiesEXT\n");
	printf( "begin-structure VkPhysicalDeviceTexelBufferAlignmentPropertiesEXT\n" );
	swigStructField( "VkPhysicalDeviceTexelBufferAlignmentPropertiesEXT-pNext", offsetof( struct VkPhysicalDeviceTexelBufferAlignmentPropertiesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceTexelBufferAlignmentPropertiesEXT-storageTexelBufferOffsetAlignmentBytes", offsetof( struct VkPhysicalDeviceTexelBufferAlignmentPropertiesEXT, storageTexelBufferOffsetAlignmentBytes ), sizeof( VkDeviceSize ) );
	swigStructField( "VkPhysicalDeviceTexelBufferAlignmentPropertiesEXT-uniformTexelBufferOffsetAlignmentBytes", offsetof( struct VkPhysicalDeviceTexelBufferAlignmentPropertiesEXT, uniformTexelBufferOffsetAlignmentBytes ), sizeof( VkDeviceSize ) );
	swigStructField( "VkPhysicalDeviceTexelBufferAlignmentPropertiesEXT-sType", offsetof( struct VkPhysicalDeviceTexelBufferAlignmentPropertiesEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDeviceTexelBufferAlignmentPropertiesEXT-storageTexelBufferOffsetSingleTexelAlignment", offsetof( struct VkPhysicalDeviceTexelBufferAlignmentPropertiesEXT, storageTexelBufferOffsetSingleTexelAlignment ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceTexelBufferAlignmentPropertiesEXT-uniformTexelBufferOffsetSingleTexelAlignment", offsetof( struct VkPhysicalDeviceTexelBufferAlignmentPropertiesEXT, uniformTexelBufferOffsetSingleTexelAlignment ), sizeof( VkBool32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceTexelBufferAlignmentPropertiesEXT ) );

	swigComment("struct VkRenderPassTransformBeginInfoQCOM\n");
	printf( "begin-structure VkRenderPassTransformBeginInfoQCOM\n" );
	swigStructField( "VkRenderPassTransformBeginInfoQCOM-pNext", offsetof( struct VkRenderPassTransformBeginInfoQCOM, pNext ), sizeof( void * ) );
	swigStructField( "VkRenderPassTransformBeginInfoQCOM-sType", offsetof( struct VkRenderPassTransformBeginInfoQCOM, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkRenderPassTransformBeginInfoQCOM-transform", offsetof( struct VkRenderPassTransformBeginInfoQCOM, transform ), sizeof( VkSurfaceTransformFlagBitsKHR ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkRenderPassTransformBeginInfoQCOM ) );

	swigComment("struct VkCommandBufferInheritanceRenderPassTransformInfoQCOM\n");
	printf( "begin-structure VkCommandBufferInheritanceRenderPassTransformInfoQCOM\n" );
	swigStructField( "VkCommandBufferInheritanceRenderPassTransformInfoQCOM-pNext", offsetof( struct VkCommandBufferInheritanceRenderPassTransformInfoQCOM, pNext ), sizeof( void * ) );
	swigStructField( "VkCommandBufferInheritanceRenderPassTransformInfoQCOM-renderArea", offsetof( struct VkCommandBufferInheritanceRenderPassTransformInfoQCOM, renderArea ), sizeof( VkRect2D ) );
	swigStructField( "VkCommandBufferInheritanceRenderPassTransformInfoQCOM-sType", offsetof( struct VkCommandBufferInheritanceRenderPassTransformInfoQCOM, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkCommandBufferInheritanceRenderPassTransformInfoQCOM-transform", offsetof( struct VkCommandBufferInheritanceRenderPassTransformInfoQCOM, transform ), sizeof( VkSurfaceTransformFlagBitsKHR ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkCommandBufferInheritanceRenderPassTransformInfoQCOM ) );

	swigComment("struct VkPhysicalDeviceDeviceMemoryReportFeaturesEXT\n");
	printf( "begin-structure VkPhysicalDeviceDeviceMemoryReportFeaturesEXT\n" );
	swigStructField( "VkPhysicalDeviceDeviceMemoryReportFeaturesEXT-pNext", offsetof( struct VkPhysicalDeviceDeviceMemoryReportFeaturesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceDeviceMemoryReportFeaturesEXT-deviceMemoryReport", offsetof( struct VkPhysicalDeviceDeviceMemoryReportFeaturesEXT, deviceMemoryReport ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceDeviceMemoryReportFeaturesEXT-sType", offsetof( struct VkPhysicalDeviceDeviceMemoryReportFeaturesEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceDeviceMemoryReportFeaturesEXT ) );

	swigComment("struct VkDeviceMemoryReportCallbackDataEXT\n");
	printf( "begin-structure VkDeviceMemoryReportCallbackDataEXT\n" );
	swigStructField( "VkDeviceMemoryReportCallbackDataEXT-memoryObjectId", offsetof( struct VkDeviceMemoryReportCallbackDataEXT, memoryObjectId ), sizeof( uint64_t ) );
	swigStructField( "VkDeviceMemoryReportCallbackDataEXT-pNext", offsetof( struct VkDeviceMemoryReportCallbackDataEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkDeviceMemoryReportCallbackDataEXT-objectType", offsetof( struct VkDeviceMemoryReportCallbackDataEXT, objectType ), sizeof( VkObjectType ) );
	swigStructField( "VkDeviceMemoryReportCallbackDataEXT-objectHandle", offsetof( struct VkDeviceMemoryReportCallbackDataEXT, objectHandle ), sizeof( uint64_t ) );
	swigStructField( "VkDeviceMemoryReportCallbackDataEXT-heapIndex", offsetof( struct VkDeviceMemoryReportCallbackDataEXT, heapIndex ), sizeof( uint32_t ) );
	swigStructField( "VkDeviceMemoryReportCallbackDataEXT-type", offsetof( struct VkDeviceMemoryReportCallbackDataEXT, type ), sizeof( VkDeviceMemoryReportEventTypeEXT ) );
	swigStructField( "VkDeviceMemoryReportCallbackDataEXT-size", offsetof( struct VkDeviceMemoryReportCallbackDataEXT, size ), sizeof( VkDeviceSize ) );
	swigStructField( "VkDeviceMemoryReportCallbackDataEXT-sType", offsetof( struct VkDeviceMemoryReportCallbackDataEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkDeviceMemoryReportCallbackDataEXT-flags", offsetof( struct VkDeviceMemoryReportCallbackDataEXT, flags ), sizeof( VkDeviceMemoryReportFlagsEXT ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDeviceMemoryReportCallbackDataEXT ) );

	swigComment("struct VkDeviceDeviceMemoryReportCreateInfoEXT\n");
	printf( "begin-structure VkDeviceDeviceMemoryReportCreateInfoEXT\n" );
	swigStructField( "VkDeviceDeviceMemoryReportCreateInfoEXT-pNext", offsetof( struct VkDeviceDeviceMemoryReportCreateInfoEXT, pNext ), sizeof( void const * ) );
	swigStructField( "VkDeviceDeviceMemoryReportCreateInfoEXT-pUserData", offsetof( struct VkDeviceDeviceMemoryReportCreateInfoEXT, pUserData ), sizeof( void * ) );
	swigStructField( "VkDeviceDeviceMemoryReportCreateInfoEXT-sType", offsetof( struct VkDeviceDeviceMemoryReportCreateInfoEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkDeviceDeviceMemoryReportCreateInfoEXT-flags", offsetof( struct VkDeviceDeviceMemoryReportCreateInfoEXT, flags ), sizeof( VkDeviceMemoryReportFlagsEXT ) );
	swigStructField( "VkDeviceDeviceMemoryReportCreateInfoEXT-pfnUserCallback", offsetof( struct VkDeviceDeviceMemoryReportCreateInfoEXT, pfnUserCallback ), sizeof( PFN_vkDeviceMemoryReportCallbackEXT ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDeviceDeviceMemoryReportCreateInfoEXT ) );

	swigComment("struct VkPhysicalDeviceRobustness2FeaturesEXT\n");
	printf( "begin-structure VkPhysicalDeviceRobustness2FeaturesEXT\n" );
	swigStructField( "VkPhysicalDeviceRobustness2FeaturesEXT-nullDescriptor", offsetof( struct VkPhysicalDeviceRobustness2FeaturesEXT, nullDescriptor ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceRobustness2FeaturesEXT-pNext", offsetof( struct VkPhysicalDeviceRobustness2FeaturesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceRobustness2FeaturesEXT-robustBufferAccess2", offsetof( struct VkPhysicalDeviceRobustness2FeaturesEXT, robustBufferAccess2 ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceRobustness2FeaturesEXT-robustImageAccess2", offsetof( struct VkPhysicalDeviceRobustness2FeaturesEXT, robustImageAccess2 ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceRobustness2FeaturesEXT-sType", offsetof( struct VkPhysicalDeviceRobustness2FeaturesEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceRobustness2FeaturesEXT ) );

	swigComment("struct VkPhysicalDeviceRobustness2PropertiesEXT\n");
	printf( "begin-structure VkPhysicalDeviceRobustness2PropertiesEXT\n" );
	swigStructField( "VkPhysicalDeviceRobustness2PropertiesEXT-pNext", offsetof( struct VkPhysicalDeviceRobustness2PropertiesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceRobustness2PropertiesEXT-sType", offsetof( struct VkPhysicalDeviceRobustness2PropertiesEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDeviceRobustness2PropertiesEXT-robustStorageBufferAccessSizeAlignment", offsetof( struct VkPhysicalDeviceRobustness2PropertiesEXT, robustStorageBufferAccessSizeAlignment ), sizeof( VkDeviceSize ) );
	swigStructField( "VkPhysicalDeviceRobustness2PropertiesEXT-robustUniformBufferAccessSizeAlignment", offsetof( struct VkPhysicalDeviceRobustness2PropertiesEXT, robustUniformBufferAccessSizeAlignment ), sizeof( VkDeviceSize ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceRobustness2PropertiesEXT ) );

	swigComment("struct VkSamplerCustomBorderColorCreateInfoEXT\n");
	printf( "begin-structure VkSamplerCustomBorderColorCreateInfoEXT\n" );
	swigStructField( "VkSamplerCustomBorderColorCreateInfoEXT-pNext", offsetof( struct VkSamplerCustomBorderColorCreateInfoEXT, pNext ), sizeof( void const * ) );
	swigStructField( "VkSamplerCustomBorderColorCreateInfoEXT-sType", offsetof( struct VkSamplerCustomBorderColorCreateInfoEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkSamplerCustomBorderColorCreateInfoEXT-format", offsetof( struct VkSamplerCustomBorderColorCreateInfoEXT, format ), sizeof( VkFormat ) );
	swigStructField( "VkSamplerCustomBorderColorCreateInfoEXT-customBorderColor", offsetof( struct VkSamplerCustomBorderColorCreateInfoEXT, customBorderColor ), sizeof( VkClearColorValue ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSamplerCustomBorderColorCreateInfoEXT ) );

	swigComment("struct VkPhysicalDeviceCustomBorderColorPropertiesEXT\n");
	printf( "begin-structure VkPhysicalDeviceCustomBorderColorPropertiesEXT\n" );
	swigStructField( "VkPhysicalDeviceCustomBorderColorPropertiesEXT-pNext", offsetof( struct VkPhysicalDeviceCustomBorderColorPropertiesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceCustomBorderColorPropertiesEXT-maxCustomBorderColorSamplers", offsetof( struct VkPhysicalDeviceCustomBorderColorPropertiesEXT, maxCustomBorderColorSamplers ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceCustomBorderColorPropertiesEXT-sType", offsetof( struct VkPhysicalDeviceCustomBorderColorPropertiesEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceCustomBorderColorPropertiesEXT ) );

	swigComment("struct VkPhysicalDeviceCustomBorderColorFeaturesEXT\n");
	printf( "begin-structure VkPhysicalDeviceCustomBorderColorFeaturesEXT\n" );
	swigStructField( "VkPhysicalDeviceCustomBorderColorFeaturesEXT-customBorderColors", offsetof( struct VkPhysicalDeviceCustomBorderColorFeaturesEXT, customBorderColors ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceCustomBorderColorFeaturesEXT-pNext", offsetof( struct VkPhysicalDeviceCustomBorderColorFeaturesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceCustomBorderColorFeaturesEXT-customBorderColorWithoutFormat", offsetof( struct VkPhysicalDeviceCustomBorderColorFeaturesEXT, customBorderColorWithoutFormat ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceCustomBorderColorFeaturesEXT-sType", offsetof( struct VkPhysicalDeviceCustomBorderColorFeaturesEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceCustomBorderColorFeaturesEXT ) );

	swigComment("struct VkPhysicalDevicePrivateDataFeaturesEXT\n");
	printf( "begin-structure VkPhysicalDevicePrivateDataFeaturesEXT\n" );
	swigStructField( "VkPhysicalDevicePrivateDataFeaturesEXT-privateData", offsetof( struct VkPhysicalDevicePrivateDataFeaturesEXT, privateData ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDevicePrivateDataFeaturesEXT-pNext", offsetof( struct VkPhysicalDevicePrivateDataFeaturesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDevicePrivateDataFeaturesEXT-sType", offsetof( struct VkPhysicalDevicePrivateDataFeaturesEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDevicePrivateDataFeaturesEXT ) );

	swigComment("struct VkDevicePrivateDataCreateInfoEXT\n");
	printf( "begin-structure VkDevicePrivateDataCreateInfoEXT\n" );
	swigStructField( "VkDevicePrivateDataCreateInfoEXT-pNext", offsetof( struct VkDevicePrivateDataCreateInfoEXT, pNext ), sizeof( void const * ) );
	swigStructField( "VkDevicePrivateDataCreateInfoEXT-sType", offsetof( struct VkDevicePrivateDataCreateInfoEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkDevicePrivateDataCreateInfoEXT-privateDataSlotRequestCount", offsetof( struct VkDevicePrivateDataCreateInfoEXT, privateDataSlotRequestCount ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDevicePrivateDataCreateInfoEXT ) );

	swigComment("struct VkPrivateDataSlotCreateInfoEXT\n");
	printf( "begin-structure VkPrivateDataSlotCreateInfoEXT\n" );
	swigStructField( "VkPrivateDataSlotCreateInfoEXT-pNext", offsetof( struct VkPrivateDataSlotCreateInfoEXT, pNext ), sizeof( void const * ) );
	swigStructField( "VkPrivateDataSlotCreateInfoEXT-sType", offsetof( struct VkPrivateDataSlotCreateInfoEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPrivateDataSlotCreateInfoEXT-flags", offsetof( struct VkPrivateDataSlotCreateInfoEXT, flags ), sizeof( VkPrivateDataSlotCreateFlagsEXT ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPrivateDataSlotCreateInfoEXT ) );

	swigComment("struct VkPhysicalDevicePipelineCreationCacheControlFeaturesEXT\n");
	printf( "begin-structure VkPhysicalDevicePipelineCreationCacheControlFeaturesEXT\n" );
	swigStructField( "VkPhysicalDevicePipelineCreationCacheControlFeaturesEXT-pNext", offsetof( struct VkPhysicalDevicePipelineCreationCacheControlFeaturesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDevicePipelineCreationCacheControlFeaturesEXT-pipelineCreationCacheControl", offsetof( struct VkPhysicalDevicePipelineCreationCacheControlFeaturesEXT, pipelineCreationCacheControl ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDevicePipelineCreationCacheControlFeaturesEXT-sType", offsetof( struct VkPhysicalDevicePipelineCreationCacheControlFeaturesEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDevicePipelineCreationCacheControlFeaturesEXT ) );

	swigComment("struct VkPhysicalDeviceDiagnosticsConfigFeaturesNV\n");
	printf( "begin-structure VkPhysicalDeviceDiagnosticsConfigFeaturesNV\n" );
	swigStructField( "VkPhysicalDeviceDiagnosticsConfigFeaturesNV-diagnosticsConfig", offsetof( struct VkPhysicalDeviceDiagnosticsConfigFeaturesNV, diagnosticsConfig ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceDiagnosticsConfigFeaturesNV-pNext", offsetof( struct VkPhysicalDeviceDiagnosticsConfigFeaturesNV, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceDiagnosticsConfigFeaturesNV-sType", offsetof( struct VkPhysicalDeviceDiagnosticsConfigFeaturesNV, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceDiagnosticsConfigFeaturesNV ) );

	swigComment("struct VkDeviceDiagnosticsConfigCreateInfoNV\n");
	printf( "begin-structure VkDeviceDiagnosticsConfigCreateInfoNV\n" );
	swigStructField( "VkDeviceDiagnosticsConfigCreateInfoNV-pNext", offsetof( struct VkDeviceDiagnosticsConfigCreateInfoNV, pNext ), sizeof( void const * ) );
	swigStructField( "VkDeviceDiagnosticsConfigCreateInfoNV-sType", offsetof( struct VkDeviceDiagnosticsConfigCreateInfoNV, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkDeviceDiagnosticsConfigCreateInfoNV-flags", offsetof( struct VkDeviceDiagnosticsConfigCreateInfoNV, flags ), sizeof( VkDeviceDiagnosticsConfigFlagsNV ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDeviceDiagnosticsConfigCreateInfoNV ) );

	swigComment("struct VkPhysicalDeviceFragmentShadingRateEnumsFeaturesNV\n");
	printf( "begin-structure VkPhysicalDeviceFragmentShadingRateEnumsFeaturesNV\n" );
	swigStructField( "VkPhysicalDeviceFragmentShadingRateEnumsFeaturesNV-pNext", offsetof( struct VkPhysicalDeviceFragmentShadingRateEnumsFeaturesNV, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceFragmentShadingRateEnumsFeaturesNV-supersampleFragmentShadingRates", offsetof( struct VkPhysicalDeviceFragmentShadingRateEnumsFeaturesNV, supersampleFragmentShadingRates ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFragmentShadingRateEnumsFeaturesNV-noInvocationFragmentShadingRates", offsetof( struct VkPhysicalDeviceFragmentShadingRateEnumsFeaturesNV, noInvocationFragmentShadingRates ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFragmentShadingRateEnumsFeaturesNV-sType", offsetof( struct VkPhysicalDeviceFragmentShadingRateEnumsFeaturesNV, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDeviceFragmentShadingRateEnumsFeaturesNV-fragmentShadingRateEnums", offsetof( struct VkPhysicalDeviceFragmentShadingRateEnumsFeaturesNV, fragmentShadingRateEnums ), sizeof( VkBool32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceFragmentShadingRateEnumsFeaturesNV ) );

	swigComment("struct VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV\n");
	printf( "begin-structure VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV\n" );
	swigStructField( "VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV-maxFragmentShadingRateInvocationCount", offsetof( struct VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV, maxFragmentShadingRateInvocationCount ), sizeof( VkSampleCountFlagBits ) );
	swigStructField( "VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV-pNext", offsetof( struct VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV-sType", offsetof( struct VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV ) );

	swigComment("struct VkPipelineFragmentShadingRateEnumStateCreateInfoNV\n");
	printf( "begin-structure VkPipelineFragmentShadingRateEnumStateCreateInfoNV\n" );
	swigStructField( "VkPipelineFragmentShadingRateEnumStateCreateInfoNV-shadingRate", offsetof( struct VkPipelineFragmentShadingRateEnumStateCreateInfoNV, shadingRate ), sizeof( VkFragmentShadingRateNV ) );
	swigStructField( "VkPipelineFragmentShadingRateEnumStateCreateInfoNV-combinerOps", offsetof( struct VkPipelineFragmentShadingRateEnumStateCreateInfoNV, combinerOps ), sizeof( VkFragmentShadingRateCombinerOpKHR [2] ) );
	swigStructField( "VkPipelineFragmentShadingRateEnumStateCreateInfoNV-pNext", offsetof( struct VkPipelineFragmentShadingRateEnumStateCreateInfoNV, pNext ), sizeof( void const * ) );
	swigStructField( "VkPipelineFragmentShadingRateEnumStateCreateInfoNV-shadingRateType", offsetof( struct VkPipelineFragmentShadingRateEnumStateCreateInfoNV, shadingRateType ), sizeof( VkFragmentShadingRateTypeNV ) );
	swigStructField( "VkPipelineFragmentShadingRateEnumStateCreateInfoNV-sType", offsetof( struct VkPipelineFragmentShadingRateEnumStateCreateInfoNV, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineFragmentShadingRateEnumStateCreateInfoNV ) );

	swigComment("union VkDeviceOrHostAddressConstKHR\n");
	printf( "begin-structure VkDeviceOrHostAddressConstKHR\n" );
	swigStructField( "VkDeviceOrHostAddressConstKHR-deviceAddress", offsetof( union VkDeviceOrHostAddressConstKHR, deviceAddress ), sizeof( VkDeviceAddress ) );
	swigStructField( "VkDeviceOrHostAddressConstKHR-hostAddress", offsetof( union VkDeviceOrHostAddressConstKHR, hostAddress ), sizeof( void const * ) );
	printf( "drop %zu end-structure\n", sizeof( union VkDeviceOrHostAddressConstKHR ) );

// 	swigComment("struct VkAccelerationStructureGeometryMotionTrianglesDataNV\n");
// 	printf( "begin-structure VkAccelerationStructureGeometryMotionTrianglesDataNV\n" );
// 	swigStructField( "VkAccelerationStructureGeometryMotionTrianglesDataNV-pNext", offsetof( struct VkAccelerationStructureGeometryMotionTrianglesDataNV, pNext ), sizeof( void const * ) );
// 	swigStructField( "VkAccelerationStructureGeometryMotionTrianglesDataNV-sType", offsetof( struct VkAccelerationStructureGeometryMotionTrianglesDataNV, sType ), sizeof( VkStructureType ) );
// 	swigStructField( "VkAccelerationStructureGeometryMotionTrianglesDataNV-vertexData", offsetof( struct VkAccelerationStructureGeometryMotionTrianglesDataNV, vertexData ), sizeof( VkDeviceOrHostAddressConstKHR ) );
// 	printf( "drop %zu end-structure\n", sizeof( struct VkAccelerationStructureGeometryMotionTrianglesDataNV ) );

// 	swigComment("struct VkAccelerationStructureMotionInfoNV\n");
// 	printf( "begin-structure VkAccelerationStructureMotionInfoNV\n" );
// 	swigStructField( "VkAccelerationStructureMotionInfoNV-pNext", offsetof( struct VkAccelerationStructureMotionInfoNV, pNext ), sizeof( void const * ) );
// 	swigStructField( "VkAccelerationStructureMotionInfoNV-maxInstances", offsetof( struct VkAccelerationStructureMotionInfoNV, maxInstances ), sizeof( uint32_t ) );
// 	swigStructField( "VkAccelerationStructureMotionInfoNV-sType", offsetof( struct VkAccelerationStructureMotionInfoNV, sType ), sizeof( VkStructureType ) );
// 	swigStructField( "VkAccelerationStructureMotionInfoNV-flags", offsetof( struct VkAccelerationStructureMotionInfoNV, flags ), sizeof( VkAccelerationStructureMotionInfoFlagsNV ) );
// 	printf( "drop %zu end-structure\n", sizeof( struct VkAccelerationStructureMotionInfoNV ) );

// 	swigComment("struct VkAccelerationStructureMatrixMotionInstanceNV\n");
// 	printf( "begin-structure VkAccelerationStructureMatrixMotionInstanceNV\n" );
// 	swigStructField( "VkAccelerationStructureMatrixMotionInstanceNV-mask", offsetof( struct VkAccelerationStructureMatrixMotionInstanceNV, mask ), sizeof( uint32_t ) );
// 	swigStructField( "VkAccelerationStructureMatrixMotionInstanceNV-instanceShaderBindingTableRecordOffset", offsetof( struct VkAccelerationStructureMatrixMotionInstanceNV, instanceShaderBindingTableRecordOffset ), sizeof( uint32_t ) );
// 	swigStructField( "VkAccelerationStructureMatrixMotionInstanceNV-transformT0", offsetof( struct VkAccelerationStructureMatrixMotionInstanceNV, transformT0 ), sizeof( VkTransformMatrixKHR ) );
// 	swigStructField( "VkAccelerationStructureMatrixMotionInstanceNV-transformT1", offsetof( struct VkAccelerationStructureMatrixMotionInstanceNV, transformT1 ), sizeof( VkTransformMatrixKHR ) );
// 	swigStructField( "VkAccelerationStructureMatrixMotionInstanceNV-instanceCustomIndex", offsetof( struct VkAccelerationStructureMatrixMotionInstanceNV, instanceCustomIndex ), sizeof( uint32_t ) );
// 	swigStructField( "VkAccelerationStructureMatrixMotionInstanceNV-accelerationStructureReference", offsetof( struct VkAccelerationStructureMatrixMotionInstanceNV, accelerationStructureReference ), sizeof( uint64_t ) );
// 	swigStructField( "VkAccelerationStructureMatrixMotionInstanceNV-flags", offsetof( struct VkAccelerationStructureMatrixMotionInstanceNV, flags ), sizeof( VkGeometryInstanceFlagsKHR ) );
// 	printf( "drop %zu end-structure\n", sizeof( struct VkAccelerationStructureMatrixMotionInstanceNV ) );

	swigComment("struct VkSRTDataNV\n");
	printf( "begin-structure VkSRTDataNV\n" );
	swigStructField( "VkSRTDataNV-tx", offsetof( struct VkSRTDataNV, tx ), sizeof( float ) );
	swigStructField( "VkSRTDataNV-ty", offsetof( struct VkSRTDataNV, ty ), sizeof( float ) );
	swigStructField( "VkSRTDataNV-sx", offsetof( struct VkSRTDataNV, sx ), sizeof( float ) );
	swigStructField( "VkSRTDataNV-pvx", offsetof( struct VkSRTDataNV, pvx ), sizeof( float ) );
	swigStructField( "VkSRTDataNV-tz", offsetof( struct VkSRTDataNV, tz ), sizeof( float ) );
	swigStructField( "VkSRTDataNV-pvy", offsetof( struct VkSRTDataNV, pvy ), sizeof( float ) );
	swigStructField( "VkSRTDataNV-sy", offsetof( struct VkSRTDataNV, sy ), sizeof( float ) );
	swigStructField( "VkSRTDataNV-pvz", offsetof( struct VkSRTDataNV, pvz ), sizeof( float ) );
	swigStructField( "VkSRTDataNV-sz", offsetof( struct VkSRTDataNV, sz ), sizeof( float ) );
	swigStructField( "VkSRTDataNV-a", offsetof( struct VkSRTDataNV, a ), sizeof( float ) );
	swigStructField( "VkSRTDataNV-qw", offsetof( struct VkSRTDataNV, qw ), sizeof( float ) );
	swigStructField( "VkSRTDataNV-qx", offsetof( struct VkSRTDataNV, qx ), sizeof( float ) );
	swigStructField( "VkSRTDataNV-b", offsetof( struct VkSRTDataNV, b ), sizeof( float ) );
	swigStructField( "VkSRTDataNV-qy", offsetof( struct VkSRTDataNV, qy ), sizeof( float ) );
	swigStructField( "VkSRTDataNV-c", offsetof( struct VkSRTDataNV, c ), sizeof( float ) );
	swigStructField( "VkSRTDataNV-qz", offsetof( struct VkSRTDataNV, qz ), sizeof( float ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSRTDataNV ) );

// 	swigComment("struct VkAccelerationStructureSRTMotionInstanceNV\n");
// 	printf( "begin-structure VkAccelerationStructureSRTMotionInstanceNV\n" );
// 	swigStructField( "VkAccelerationStructureSRTMotionInstanceNV-mask", offsetof( struct VkAccelerationStructureSRTMotionInstanceNV, mask ), sizeof( uint32_t ) );
// 	swigStructField( "VkAccelerationStructureSRTMotionInstanceNV-instanceShaderBindingTableRecordOffset", offsetof( struct VkAccelerationStructureSRTMotionInstanceNV, instanceShaderBindingTableRecordOffset ), sizeof( uint32_t ) );
// 	swigStructField( "VkAccelerationStructureSRTMotionInstanceNV-transformT0", offsetof( struct VkAccelerationStructureSRTMotionInstanceNV, transformT0 ), sizeof( VkSRTDataNV ) );
// 	swigStructField( "VkAccelerationStructureSRTMotionInstanceNV-transformT1", offsetof( struct VkAccelerationStructureSRTMotionInstanceNV, transformT1 ), sizeof( VkSRTDataNV ) );
// 	swigStructField( "VkAccelerationStructureSRTMotionInstanceNV-instanceCustomIndex", offsetof( struct VkAccelerationStructureSRTMotionInstanceNV, instanceCustomIndex ), sizeof( uint32_t ) );
// 	swigStructField( "VkAccelerationStructureSRTMotionInstanceNV-accelerationStructureReference", offsetof( struct VkAccelerationStructureSRTMotionInstanceNV, accelerationStructureReference ), sizeof( uint64_t ) );
// 	swigStructField( "VkAccelerationStructureSRTMotionInstanceNV-flags", offsetof( struct VkAccelerationStructureSRTMotionInstanceNV, flags ), sizeof( VkGeometryInstanceFlagsKHR ) );
// 	printf( "drop %zu end-structure\n", sizeof( struct VkAccelerationStructureSRTMotionInstanceNV ) );

// 	swigComment("union VkAccelerationStructureMotionInstanceDataNV\n");
// 	printf( "begin-structure VkAccelerationStructureMotionInstanceDataNV\n" );
// // 	swigStructField( "VkAccelerationStructureMotionInstanceDataNV-staticInstance", offsetof( union VkAccelerationStructureMotionInstanceDataNV, staticInstance ), sizeof( VkAccelerationStructureInstanceKHR ) );
// 	swigStructField( "VkAccelerationStructureMotionInstanceDataNV-matrixMotionInstance", offsetof( union VkAccelerationStructureMotionInstanceDataNV, matrixMotionInstance ), sizeof( VkAccelerationStructureMatrixMotionInstanceNV ) );
// 	swigStructField( "VkAccelerationStructureMotionInstanceDataNV-srtMotionInstance", offsetof( union VkAccelerationStructureMotionInstanceDataNV, srtMotionInstance ), sizeof( VkAccelerationStructureSRTMotionInstanceNV ) );
// 	printf( "drop %zu end-structure\n", sizeof( union VkAccelerationStructureMotionInstanceDataNV ) );

// 	swigComment("struct VkAccelerationStructureMotionInstanceNV\n");
// 	printf( "begin-structure VkAccelerationStructureMotionInstanceNV\n" );
// 	swigStructField( "VkAccelerationStructureMotionInstanceNV-data", offsetof( struct VkAccelerationStructureMotionInstanceNV, data ), sizeof( VkAccelerationStructureMotionInstanceDataNV ) );
// 	swigStructField( "VkAccelerationStructureMotionInstanceNV-type", offsetof( struct VkAccelerationStructureMotionInstanceNV, type ), sizeof( VkAccelerationStructureMotionInstanceTypeNV ) );
// 	swigStructField( "VkAccelerationStructureMotionInstanceNV-flags", offsetof( struct VkAccelerationStructureMotionInstanceNV, flags ), sizeof( VkAccelerationStructureMotionInstanceFlagsNV ) );
// 	printf( "drop %zu end-structure\n", sizeof( struct VkAccelerationStructureMotionInstanceNV ) );

	swigComment("struct VkPhysicalDeviceRayTracingMotionBlurFeaturesNV\n");
	printf( "begin-structure VkPhysicalDeviceRayTracingMotionBlurFeaturesNV\n" );
	swigStructField( "VkPhysicalDeviceRayTracingMotionBlurFeaturesNV-pNext", offsetof( struct VkPhysicalDeviceRayTracingMotionBlurFeaturesNV, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceRayTracingMotionBlurFeaturesNV-rayTracingMotionBlur", offsetof( struct VkPhysicalDeviceRayTracingMotionBlurFeaturesNV, rayTracingMotionBlur ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceRayTracingMotionBlurFeaturesNV-rayTracingMotionBlurPipelineTraceRaysIndirect", offsetof( struct VkPhysicalDeviceRayTracingMotionBlurFeaturesNV, rayTracingMotionBlurPipelineTraceRaysIndirect ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceRayTracingMotionBlurFeaturesNV-sType", offsetof( struct VkPhysicalDeviceRayTracingMotionBlurFeaturesNV, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceRayTracingMotionBlurFeaturesNV ) );

	swigComment("struct VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT\n");
	printf( "begin-structure VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT\n" );
	swigStructField( "VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT-pNext", offsetof( struct VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT-ycbcr2plane444Formats", offsetof( struct VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT, ycbcr2plane444Formats ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT-sType", offsetof( struct VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT ) );

	swigComment("struct VkPhysicalDeviceFragmentDensityMap2FeaturesEXT\n");
	printf( "begin-structure VkPhysicalDeviceFragmentDensityMap2FeaturesEXT\n" );
	swigStructField( "VkPhysicalDeviceFragmentDensityMap2FeaturesEXT-pNext", offsetof( struct VkPhysicalDeviceFragmentDensityMap2FeaturesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceFragmentDensityMap2FeaturesEXT-fragmentDensityMapDeferred", offsetof( struct VkPhysicalDeviceFragmentDensityMap2FeaturesEXT, fragmentDensityMapDeferred ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFragmentDensityMap2FeaturesEXT-sType", offsetof( struct VkPhysicalDeviceFragmentDensityMap2FeaturesEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceFragmentDensityMap2FeaturesEXT ) );

	swigComment("struct VkPhysicalDeviceFragmentDensityMap2PropertiesEXT\n");
	printf( "begin-structure VkPhysicalDeviceFragmentDensityMap2PropertiesEXT\n" );
	swigStructField( "VkPhysicalDeviceFragmentDensityMap2PropertiesEXT-pNext", offsetof( struct VkPhysicalDeviceFragmentDensityMap2PropertiesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceFragmentDensityMap2PropertiesEXT-subsampledCoarseReconstructionEarlyAccess", offsetof( struct VkPhysicalDeviceFragmentDensityMap2PropertiesEXT, subsampledCoarseReconstructionEarlyAccess ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFragmentDensityMap2PropertiesEXT-maxDescriptorSetSubsampledSamplers", offsetof( struct VkPhysicalDeviceFragmentDensityMap2PropertiesEXT, maxDescriptorSetSubsampledSamplers ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceFragmentDensityMap2PropertiesEXT-sType", offsetof( struct VkPhysicalDeviceFragmentDensityMap2PropertiesEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDeviceFragmentDensityMap2PropertiesEXT-subsampledLoads", offsetof( struct VkPhysicalDeviceFragmentDensityMap2PropertiesEXT, subsampledLoads ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFragmentDensityMap2PropertiesEXT-maxSubsampledArrayLayers", offsetof( struct VkPhysicalDeviceFragmentDensityMap2PropertiesEXT, maxSubsampledArrayLayers ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceFragmentDensityMap2PropertiesEXT ) );

	swigComment("struct VkCopyCommandTransformInfoQCOM\n");
	printf( "begin-structure VkCopyCommandTransformInfoQCOM\n" );
	swigStructField( "VkCopyCommandTransformInfoQCOM-pNext", offsetof( struct VkCopyCommandTransformInfoQCOM, pNext ), sizeof( void const * ) );
	swigStructField( "VkCopyCommandTransformInfoQCOM-sType", offsetof( struct VkCopyCommandTransformInfoQCOM, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkCopyCommandTransformInfoQCOM-transform", offsetof( struct VkCopyCommandTransformInfoQCOM, transform ), sizeof( VkSurfaceTransformFlagBitsKHR ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkCopyCommandTransformInfoQCOM ) );

	swigComment("struct VkPhysicalDeviceImageRobustnessFeaturesEXT\n");
	printf( "begin-structure VkPhysicalDeviceImageRobustnessFeaturesEXT\n" );
	swigStructField( "VkPhysicalDeviceImageRobustnessFeaturesEXT-pNext", offsetof( struct VkPhysicalDeviceImageRobustnessFeaturesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceImageRobustnessFeaturesEXT-robustImageAccess", offsetof( struct VkPhysicalDeviceImageRobustnessFeaturesEXT, robustImageAccess ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceImageRobustnessFeaturesEXT-sType", offsetof( struct VkPhysicalDeviceImageRobustnessFeaturesEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceImageRobustnessFeaturesEXT ) );

	swigComment("struct VkPhysicalDevice4444FormatsFeaturesEXT\n");
	printf( "begin-structure VkPhysicalDevice4444FormatsFeaturesEXT\n" );
	swigStructField( "VkPhysicalDevice4444FormatsFeaturesEXT-formatA4R4G4B4", offsetof( struct VkPhysicalDevice4444FormatsFeaturesEXT, formatA4R4G4B4 ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDevice4444FormatsFeaturesEXT-pNext", offsetof( struct VkPhysicalDevice4444FormatsFeaturesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDevice4444FormatsFeaturesEXT-formatA4B4G4R4", offsetof( struct VkPhysicalDevice4444FormatsFeaturesEXT, formatA4B4G4R4 ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDevice4444FormatsFeaturesEXT-sType", offsetof( struct VkPhysicalDevice4444FormatsFeaturesEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDevice4444FormatsFeaturesEXT ) );

	swigComment("struct VkPhysicalDeviceRGBA10X6FormatsFeaturesEXT\n");
	printf( "begin-structure VkPhysicalDeviceRGBA10X6FormatsFeaturesEXT\n" );
	swigStructField( "VkPhysicalDeviceRGBA10X6FormatsFeaturesEXT-pNext", offsetof( struct VkPhysicalDeviceRGBA10X6FormatsFeaturesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceRGBA10X6FormatsFeaturesEXT-formatRgba10x6WithoutYCbCrSampler", offsetof( struct VkPhysicalDeviceRGBA10X6FormatsFeaturesEXT, formatRgba10x6WithoutYCbCrSampler ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceRGBA10X6FormatsFeaturesEXT-sType", offsetof( struct VkPhysicalDeviceRGBA10X6FormatsFeaturesEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceRGBA10X6FormatsFeaturesEXT ) );

	swigComment("struct VkPhysicalDeviceMutableDescriptorTypeFeaturesVALVE\n");
	printf( "begin-structure VkPhysicalDeviceMutableDescriptorTypeFeaturesVALVE\n" );
	swigStructField( "VkPhysicalDeviceMutableDescriptorTypeFeaturesVALVE-pNext", offsetof( struct VkPhysicalDeviceMutableDescriptorTypeFeaturesVALVE, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceMutableDescriptorTypeFeaturesVALVE-mutableDescriptorType", offsetof( struct VkPhysicalDeviceMutableDescriptorTypeFeaturesVALVE, mutableDescriptorType ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceMutableDescriptorTypeFeaturesVALVE-sType", offsetof( struct VkPhysicalDeviceMutableDescriptorTypeFeaturesVALVE, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceMutableDescriptorTypeFeaturesVALVE ) );

	swigComment("struct VkMutableDescriptorTypeListVALVE\n");
	printf( "begin-structure VkMutableDescriptorTypeListVALVE\n" );
	swigStructField( "VkMutableDescriptorTypeListVALVE-descriptorTypeCount", offsetof( struct VkMutableDescriptorTypeListVALVE, descriptorTypeCount ), sizeof( uint32_t ) );
	swigStructField( "VkMutableDescriptorTypeListVALVE-pDescriptorTypes", offsetof( struct VkMutableDescriptorTypeListVALVE, pDescriptorTypes ), sizeof( VkDescriptorType const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkMutableDescriptorTypeListVALVE ) );

	swigComment("struct VkMutableDescriptorTypeCreateInfoVALVE\n");
	printf( "begin-structure VkMutableDescriptorTypeCreateInfoVALVE\n" );
	swigStructField( "VkMutableDescriptorTypeCreateInfoVALVE-pNext", offsetof( struct VkMutableDescriptorTypeCreateInfoVALVE, pNext ), sizeof( void const * ) );
	swigStructField( "VkMutableDescriptorTypeCreateInfoVALVE-pMutableDescriptorTypeLists", offsetof( struct VkMutableDescriptorTypeCreateInfoVALVE, pMutableDescriptorTypeLists ), sizeof( VkMutableDescriptorTypeListVALVE const * ) );
	swigStructField( "VkMutableDescriptorTypeCreateInfoVALVE-sType", offsetof( struct VkMutableDescriptorTypeCreateInfoVALVE, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkMutableDescriptorTypeCreateInfoVALVE-mutableDescriptorTypeListCount", offsetof( struct VkMutableDescriptorTypeCreateInfoVALVE, mutableDescriptorTypeListCount ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkMutableDescriptorTypeCreateInfoVALVE ) );

	swigComment("struct VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT\n");
	printf( "begin-structure VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT\n" );
	swigStructField( "VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT-pNext", offsetof( struct VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT-vertexInputDynamicState", offsetof( struct VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT, vertexInputDynamicState ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT-sType", offsetof( struct VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT ) );

	swigComment("struct VkVertexInputBindingDescription2EXT\n");
	printf( "begin-structure VkVertexInputBindingDescription2EXT\n" );
	swigStructField( "VkVertexInputBindingDescription2EXT-pNext", offsetof( struct VkVertexInputBindingDescription2EXT, pNext ), sizeof( void * ) );
	swigStructField( "VkVertexInputBindingDescription2EXT-binding", offsetof( struct VkVertexInputBindingDescription2EXT, binding ), sizeof( uint32_t ) );
	swigStructField( "VkVertexInputBindingDescription2EXT-inputRate", offsetof( struct VkVertexInputBindingDescription2EXT, inputRate ), sizeof( VkVertexInputRate ) );
	swigStructField( "VkVertexInputBindingDescription2EXT-sType", offsetof( struct VkVertexInputBindingDescription2EXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkVertexInputBindingDescription2EXT-stride", offsetof( struct VkVertexInputBindingDescription2EXT, stride ), sizeof( uint32_t ) );
	swigStructField( "VkVertexInputBindingDescription2EXT-divisor", offsetof( struct VkVertexInputBindingDescription2EXT, divisor ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkVertexInputBindingDescription2EXT ) );

	swigComment("struct VkVertexInputAttributeDescription2EXT\n");
	printf( "begin-structure VkVertexInputAttributeDescription2EXT\n" );
	swigStructField( "VkVertexInputAttributeDescription2EXT-location", offsetof( struct VkVertexInputAttributeDescription2EXT, location ), sizeof( uint32_t ) );
	swigStructField( "VkVertexInputAttributeDescription2EXT-pNext", offsetof( struct VkVertexInputAttributeDescription2EXT, pNext ), sizeof( void * ) );
	swigStructField( "VkVertexInputAttributeDescription2EXT-binding", offsetof( struct VkVertexInputAttributeDescription2EXT, binding ), sizeof( uint32_t ) );
	swigStructField( "VkVertexInputAttributeDescription2EXT-offset", offsetof( struct VkVertexInputAttributeDescription2EXT, offset ), sizeof( uint32_t ) );
	swigStructField( "VkVertexInputAttributeDescription2EXT-sType", offsetof( struct VkVertexInputAttributeDescription2EXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkVertexInputAttributeDescription2EXT-format", offsetof( struct VkVertexInputAttributeDescription2EXT, format ), sizeof( VkFormat ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkVertexInputAttributeDescription2EXT ) );

	swigComment("struct VkPhysicalDeviceDrmPropertiesEXT\n");
	printf( "begin-structure VkPhysicalDeviceDrmPropertiesEXT\n" );
	swigStructField( "VkPhysicalDeviceDrmPropertiesEXT-hasPrimary", offsetof( struct VkPhysicalDeviceDrmPropertiesEXT, hasPrimary ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceDrmPropertiesEXT-renderMajor", offsetof( struct VkPhysicalDeviceDrmPropertiesEXT, renderMajor ), sizeof( int64_t ) );
	swigStructField( "VkPhysicalDeviceDrmPropertiesEXT-pNext", offsetof( struct VkPhysicalDeviceDrmPropertiesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceDrmPropertiesEXT-primaryMajor", offsetof( struct VkPhysicalDeviceDrmPropertiesEXT, primaryMajor ), sizeof( int64_t ) );
	swigStructField( "VkPhysicalDeviceDrmPropertiesEXT-hasRender", offsetof( struct VkPhysicalDeviceDrmPropertiesEXT, hasRender ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceDrmPropertiesEXT-renderMinor", offsetof( struct VkPhysicalDeviceDrmPropertiesEXT, renderMinor ), sizeof( int64_t ) );
	swigStructField( "VkPhysicalDeviceDrmPropertiesEXT-primaryMinor", offsetof( struct VkPhysicalDeviceDrmPropertiesEXT, primaryMinor ), sizeof( int64_t ) );
	swigStructField( "VkPhysicalDeviceDrmPropertiesEXT-sType", offsetof( struct VkPhysicalDeviceDrmPropertiesEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceDrmPropertiesEXT ) );

	swigComment("struct VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT\n");
	printf( "begin-structure VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT\n" );
	swigStructField( "VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT-pNext", offsetof( struct VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT-primitiveTopologyListRestart", offsetof( struct VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT, primitiveTopologyListRestart ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT-primitiveTopologyPatchListRestart", offsetof( struct VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT, primitiveTopologyPatchListRestart ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT-sType", offsetof( struct VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT ) );

	swigComment("struct VkSubpassShadingPipelineCreateInfoHUAWEI\n");
	printf( "begin-structure VkSubpassShadingPipelineCreateInfoHUAWEI\n" );
	swigStructField( "VkSubpassShadingPipelineCreateInfoHUAWEI-renderPass", offsetof( struct VkSubpassShadingPipelineCreateInfoHUAWEI, renderPass ), sizeof( VkRenderPass ) );
	swigStructField( "VkSubpassShadingPipelineCreateInfoHUAWEI-pNext", offsetof( struct VkSubpassShadingPipelineCreateInfoHUAWEI, pNext ), sizeof( void * ) );
	swigStructField( "VkSubpassShadingPipelineCreateInfoHUAWEI-sType", offsetof( struct VkSubpassShadingPipelineCreateInfoHUAWEI, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkSubpassShadingPipelineCreateInfoHUAWEI-subpass", offsetof( struct VkSubpassShadingPipelineCreateInfoHUAWEI, subpass ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSubpassShadingPipelineCreateInfoHUAWEI ) );

	swigComment("struct VkPhysicalDeviceSubpassShadingFeaturesHUAWEI\n");
	printf( "begin-structure VkPhysicalDeviceSubpassShadingFeaturesHUAWEI\n" );
	swigStructField( "VkPhysicalDeviceSubpassShadingFeaturesHUAWEI-pNext", offsetof( struct VkPhysicalDeviceSubpassShadingFeaturesHUAWEI, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceSubpassShadingFeaturesHUAWEI-subpassShading", offsetof( struct VkPhysicalDeviceSubpassShadingFeaturesHUAWEI, subpassShading ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceSubpassShadingFeaturesHUAWEI-sType", offsetof( struct VkPhysicalDeviceSubpassShadingFeaturesHUAWEI, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceSubpassShadingFeaturesHUAWEI ) );

	swigComment("struct VkPhysicalDeviceSubpassShadingPropertiesHUAWEI\n");
	printf( "begin-structure VkPhysicalDeviceSubpassShadingPropertiesHUAWEI\n" );
	swigStructField( "VkPhysicalDeviceSubpassShadingPropertiesHUAWEI-pNext", offsetof( struct VkPhysicalDeviceSubpassShadingPropertiesHUAWEI, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceSubpassShadingPropertiesHUAWEI-maxSubpassShadingWorkgroupSizeAspectRatio", offsetof( struct VkPhysicalDeviceSubpassShadingPropertiesHUAWEI, maxSubpassShadingWorkgroupSizeAspectRatio ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceSubpassShadingPropertiesHUAWEI-sType", offsetof( struct VkPhysicalDeviceSubpassShadingPropertiesHUAWEI, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceSubpassShadingPropertiesHUAWEI ) );

	swigComment("struct VkPhysicalDeviceInvocationMaskFeaturesHUAWEI\n");
	printf( "begin-structure VkPhysicalDeviceInvocationMaskFeaturesHUAWEI\n" );
	swigStructField( "VkPhysicalDeviceInvocationMaskFeaturesHUAWEI-pNext", offsetof( struct VkPhysicalDeviceInvocationMaskFeaturesHUAWEI, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceInvocationMaskFeaturesHUAWEI-sType", offsetof( struct VkPhysicalDeviceInvocationMaskFeaturesHUAWEI, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDeviceInvocationMaskFeaturesHUAWEI-invocationMask", offsetof( struct VkPhysicalDeviceInvocationMaskFeaturesHUAWEI, invocationMask ), sizeof( VkBool32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceInvocationMaskFeaturesHUAWEI ) );

	swigComment("struct VkMemoryGetRemoteAddressInfoNV\n");
	printf( "begin-structure VkMemoryGetRemoteAddressInfoNV\n" );
	swigStructField( "VkMemoryGetRemoteAddressInfoNV-pNext", offsetof( struct VkMemoryGetRemoteAddressInfoNV, pNext ), sizeof( void const * ) );
	swigStructField( "VkMemoryGetRemoteAddressInfoNV-memory", offsetof( struct VkMemoryGetRemoteAddressInfoNV, memory ), sizeof( VkDeviceMemory ) );
	swigStructField( "VkMemoryGetRemoteAddressInfoNV-handleType", offsetof( struct VkMemoryGetRemoteAddressInfoNV, handleType ), sizeof( VkExternalMemoryHandleTypeFlagBits ) );
	swigStructField( "VkMemoryGetRemoteAddressInfoNV-sType", offsetof( struct VkMemoryGetRemoteAddressInfoNV, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkMemoryGetRemoteAddressInfoNV ) );

	swigComment("struct VkPhysicalDeviceExternalMemoryRDMAFeaturesNV\n");
	printf( "begin-structure VkPhysicalDeviceExternalMemoryRDMAFeaturesNV\n" );
	swigStructField( "VkPhysicalDeviceExternalMemoryRDMAFeaturesNV-pNext", offsetof( struct VkPhysicalDeviceExternalMemoryRDMAFeaturesNV, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceExternalMemoryRDMAFeaturesNV-sType", offsetof( struct VkPhysicalDeviceExternalMemoryRDMAFeaturesNV, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDeviceExternalMemoryRDMAFeaturesNV-externalMemoryRDMA", offsetof( struct VkPhysicalDeviceExternalMemoryRDMAFeaturesNV, externalMemoryRDMA ), sizeof( VkBool32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceExternalMemoryRDMAFeaturesNV ) );

	swigComment("struct VkPhysicalDeviceExtendedDynamicState2FeaturesEXT\n");
	printf( "begin-structure VkPhysicalDeviceExtendedDynamicState2FeaturesEXT\n" );
	swigStructField( "VkPhysicalDeviceExtendedDynamicState2FeaturesEXT-pNext", offsetof( struct VkPhysicalDeviceExtendedDynamicState2FeaturesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceExtendedDynamicState2FeaturesEXT-extendedDynamicState2PatchControlPoints", offsetof( struct VkPhysicalDeviceExtendedDynamicState2FeaturesEXT, extendedDynamicState2PatchControlPoints ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceExtendedDynamicState2FeaturesEXT-sType", offsetof( struct VkPhysicalDeviceExtendedDynamicState2FeaturesEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPhysicalDeviceExtendedDynamicState2FeaturesEXT-extendedDynamicState2", offsetof( struct VkPhysicalDeviceExtendedDynamicState2FeaturesEXT, extendedDynamicState2 ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceExtendedDynamicState2FeaturesEXT-extendedDynamicState2LogicOp", offsetof( struct VkPhysicalDeviceExtendedDynamicState2FeaturesEXT, extendedDynamicState2LogicOp ), sizeof( VkBool32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceExtendedDynamicState2FeaturesEXT ) );

	swigComment("struct VkPhysicalDeviceColorWriteEnableFeaturesEXT\n");
	printf( "begin-structure VkPhysicalDeviceColorWriteEnableFeaturesEXT\n" );
	swigStructField( "VkPhysicalDeviceColorWriteEnableFeaturesEXT-pNext", offsetof( struct VkPhysicalDeviceColorWriteEnableFeaturesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceColorWriteEnableFeaturesEXT-colorWriteEnable", offsetof( struct VkPhysicalDeviceColorWriteEnableFeaturesEXT, colorWriteEnable ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceColorWriteEnableFeaturesEXT-sType", offsetof( struct VkPhysicalDeviceColorWriteEnableFeaturesEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceColorWriteEnableFeaturesEXT ) );

	swigComment("struct VkPipelineColorWriteCreateInfoEXT\n");
	printf( "begin-structure VkPipelineColorWriteCreateInfoEXT\n" );
	swigStructField( "VkPipelineColorWriteCreateInfoEXT-pNext", offsetof( struct VkPipelineColorWriteCreateInfoEXT, pNext ), sizeof( void const * ) );
	swigStructField( "VkPipelineColorWriteCreateInfoEXT-pColorWriteEnables", offsetof( struct VkPipelineColorWriteCreateInfoEXT, pColorWriteEnables ), sizeof( VkBool32 const * ) );
	swigStructField( "VkPipelineColorWriteCreateInfoEXT-sType", offsetof( struct VkPipelineColorWriteCreateInfoEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPipelineColorWriteCreateInfoEXT-attachmentCount", offsetof( struct VkPipelineColorWriteCreateInfoEXT, attachmentCount ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineColorWriteCreateInfoEXT ) );

	swigComment("struct VkPhysicalDeviceGlobalPriorityQueryFeaturesEXT\n");
	printf( "begin-structure VkPhysicalDeviceGlobalPriorityQueryFeaturesEXT\n" );
	swigStructField( "VkPhysicalDeviceGlobalPriorityQueryFeaturesEXT-pNext", offsetof( struct VkPhysicalDeviceGlobalPriorityQueryFeaturesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceGlobalPriorityQueryFeaturesEXT-globalPriorityQuery", offsetof( struct VkPhysicalDeviceGlobalPriorityQueryFeaturesEXT, globalPriorityQuery ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceGlobalPriorityQueryFeaturesEXT-sType", offsetof( struct VkPhysicalDeviceGlobalPriorityQueryFeaturesEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceGlobalPriorityQueryFeaturesEXT ) );

	swigComment("struct VkQueueFamilyGlobalPriorityPropertiesEXT\n");
	printf( "begin-structure VkQueueFamilyGlobalPriorityPropertiesEXT\n" );
	swigStructField( "VkQueueFamilyGlobalPriorityPropertiesEXT-pNext", offsetof( struct VkQueueFamilyGlobalPriorityPropertiesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkQueueFamilyGlobalPriorityPropertiesEXT-priorityCount", offsetof( struct VkQueueFamilyGlobalPriorityPropertiesEXT, priorityCount ), sizeof( uint32_t ) );
	swigStructField( "VkQueueFamilyGlobalPriorityPropertiesEXT-sType", offsetof( struct VkQueueFamilyGlobalPriorityPropertiesEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkQueueFamilyGlobalPriorityPropertiesEXT-priorities", offsetof( struct VkQueueFamilyGlobalPriorityPropertiesEXT, priorities ), sizeof( VkQueueGlobalPriorityEXT [16U] ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkQueueFamilyGlobalPriorityPropertiesEXT ) );

	swigComment("struct VkPhysicalDeviceMultiDrawFeaturesEXT\n");
	printf( "begin-structure VkPhysicalDeviceMultiDrawFeaturesEXT\n" );
	swigStructField( "VkPhysicalDeviceMultiDrawFeaturesEXT-pNext", offsetof( struct VkPhysicalDeviceMultiDrawFeaturesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceMultiDrawFeaturesEXT-multiDraw", offsetof( struct VkPhysicalDeviceMultiDrawFeaturesEXT, multiDraw ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceMultiDrawFeaturesEXT-sType", offsetof( struct VkPhysicalDeviceMultiDrawFeaturesEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceMultiDrawFeaturesEXT ) );

	swigComment("struct VkPhysicalDeviceMultiDrawPropertiesEXT\n");
	printf( "begin-structure VkPhysicalDeviceMultiDrawPropertiesEXT\n" );
	swigStructField( "VkPhysicalDeviceMultiDrawPropertiesEXT-pNext", offsetof( struct VkPhysicalDeviceMultiDrawPropertiesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceMultiDrawPropertiesEXT-maxMultiDrawCount", offsetof( struct VkPhysicalDeviceMultiDrawPropertiesEXT, maxMultiDrawCount ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceMultiDrawPropertiesEXT-sType", offsetof( struct VkPhysicalDeviceMultiDrawPropertiesEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceMultiDrawPropertiesEXT ) );

	swigComment("struct VkMultiDrawInfoEXT\n");
	printf( "begin-structure VkMultiDrawInfoEXT\n" );
	swigStructField( "VkMultiDrawInfoEXT-firstVertex", offsetof( struct VkMultiDrawInfoEXT, firstVertex ), sizeof( uint32_t ) );
	swigStructField( "VkMultiDrawInfoEXT-vertexCount", offsetof( struct VkMultiDrawInfoEXT, vertexCount ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkMultiDrawInfoEXT ) );

	swigComment("struct VkMultiDrawIndexedInfoEXT\n");
	printf( "begin-structure VkMultiDrawIndexedInfoEXT\n" );
	swigStructField( "VkMultiDrawIndexedInfoEXT-vertexOffset", offsetof( struct VkMultiDrawIndexedInfoEXT, vertexOffset ), sizeof( int32_t ) );
	swigStructField( "VkMultiDrawIndexedInfoEXT-firstIndex", offsetof( struct VkMultiDrawIndexedInfoEXT, firstIndex ), sizeof( uint32_t ) );
	swigStructField( "VkMultiDrawIndexedInfoEXT-indexCount", offsetof( struct VkMultiDrawIndexedInfoEXT, indexCount ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkMultiDrawIndexedInfoEXT ) );

	swigComment("struct VkPhysicalDeviceBorderColorSwizzleFeaturesEXT\n");
	printf( "begin-structure VkPhysicalDeviceBorderColorSwizzleFeaturesEXT\n" );
	swigStructField( "VkPhysicalDeviceBorderColorSwizzleFeaturesEXT-borderColorSwizzle", offsetof( struct VkPhysicalDeviceBorderColorSwizzleFeaturesEXT, borderColorSwizzle ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceBorderColorSwizzleFeaturesEXT-borderColorSwizzleFromImage", offsetof( struct VkPhysicalDeviceBorderColorSwizzleFeaturesEXT, borderColorSwizzleFromImage ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceBorderColorSwizzleFeaturesEXT-pNext", offsetof( struct VkPhysicalDeviceBorderColorSwizzleFeaturesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDeviceBorderColorSwizzleFeaturesEXT-sType", offsetof( struct VkPhysicalDeviceBorderColorSwizzleFeaturesEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceBorderColorSwizzleFeaturesEXT ) );

	swigComment("struct VkSamplerBorderColorComponentMappingCreateInfoEXT\n");
	printf( "begin-structure VkSamplerBorderColorComponentMappingCreateInfoEXT\n" );
	swigStructField( "VkSamplerBorderColorComponentMappingCreateInfoEXT-pNext", offsetof( struct VkSamplerBorderColorComponentMappingCreateInfoEXT, pNext ), sizeof( void const * ) );
	swigStructField( "VkSamplerBorderColorComponentMappingCreateInfoEXT-sType", offsetof( struct VkSamplerBorderColorComponentMappingCreateInfoEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkSamplerBorderColorComponentMappingCreateInfoEXT-components", offsetof( struct VkSamplerBorderColorComponentMappingCreateInfoEXT, components ), sizeof( VkComponentMapping ) );
	swigStructField( "VkSamplerBorderColorComponentMappingCreateInfoEXT-srgb", offsetof( struct VkSamplerBorderColorComponentMappingCreateInfoEXT, srgb ), sizeof( VkBool32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSamplerBorderColorComponentMappingCreateInfoEXT ) );

	swigComment("struct VkPhysicalDevicePageableDeviceLocalMemoryFeaturesEXT\n");
	printf( "begin-structure VkPhysicalDevicePageableDeviceLocalMemoryFeaturesEXT\n" );
	swigStructField( "VkPhysicalDevicePageableDeviceLocalMemoryFeaturesEXT-pNext", offsetof( struct VkPhysicalDevicePageableDeviceLocalMemoryFeaturesEXT, pNext ), sizeof( void * ) );
	swigStructField( "VkPhysicalDevicePageableDeviceLocalMemoryFeaturesEXT-pageableDeviceLocalMemory", offsetof( struct VkPhysicalDevicePageableDeviceLocalMemoryFeaturesEXT, pageableDeviceLocalMemory ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDevicePageableDeviceLocalMemoryFeaturesEXT-sType", offsetof( struct VkPhysicalDevicePageableDeviceLocalMemoryFeaturesEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDevicePageableDeviceLocalMemoryFeaturesEXT ) );

	swigComment("union VkDeviceOrHostAddressKHR\n");
	printf( "begin-structure VkDeviceOrHostAddressKHR\n" );
	swigStructField( "VkDeviceOrHostAddressKHR-deviceAddress", offsetof( union VkDeviceOrHostAddressKHR, deviceAddress ), sizeof( VkDeviceAddress ) );
	swigStructField( "VkDeviceOrHostAddressKHR-hostAddress", offsetof( union VkDeviceOrHostAddressKHR, hostAddress ), sizeof( void * ) );
	printf( "drop %zu end-structure\n", sizeof( union VkDeviceOrHostAddressKHR ) );

	swigComment("struct VkAccelerationStructureBuildRangeInfoKHR\n");
	printf( "begin-structure VkAccelerationStructureBuildRangeInfoKHR\n" );
	swigStructField( "VkAccelerationStructureBuildRangeInfoKHR-firstVertex", offsetof( struct VkAccelerationStructureBuildRangeInfoKHR, firstVertex ), sizeof( uint32_t ) );
	swigStructField( "VkAccelerationStructureBuildRangeInfoKHR-primitiveOffset", offsetof( struct VkAccelerationStructureBuildRangeInfoKHR, primitiveOffset ), sizeof( uint32_t ) );
	swigStructField( "VkAccelerationStructureBuildRangeInfoKHR-transformOffset", offsetof( struct VkAccelerationStructureBuildRangeInfoKHR, transformOffset ), sizeof( uint32_t ) );
	swigStructField( "VkAccelerationStructureBuildRangeInfoKHR-primitiveCount", offsetof( struct VkAccelerationStructureBuildRangeInfoKHR, primitiveCount ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkAccelerationStructureBuildRangeInfoKHR ) );

	swigComment("struct VkAccelerationStructureGeometryTrianglesDataKHR\n");
	printf( "begin-structure VkAccelerationStructureGeometryTrianglesDataKHR\n" );
	swigStructField( "VkAccelerationStructureGeometryTrianglesDataKHR-transformData", offsetof( struct VkAccelerationStructureGeometryTrianglesDataKHR, transformData ), sizeof( VkDeviceOrHostAddressConstKHR ) );
	swigStructField( "VkAccelerationStructureGeometryTrianglesDataKHR-pNext", offsetof( struct VkAccelerationStructureGeometryTrianglesDataKHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkAccelerationStructureGeometryTrianglesDataKHR-indexType", offsetof( struct VkAccelerationStructureGeometryTrianglesDataKHR, indexType ), sizeof( VkIndexType ) );
	swigStructField( "VkAccelerationStructureGeometryTrianglesDataKHR-maxVertex", offsetof( struct VkAccelerationStructureGeometryTrianglesDataKHR, maxVertex ), sizeof( uint32_t ) );
	swigStructField( "VkAccelerationStructureGeometryTrianglesDataKHR-vertexFormat", offsetof( struct VkAccelerationStructureGeometryTrianglesDataKHR, vertexFormat ), sizeof( VkFormat ) );
	swigStructField( "VkAccelerationStructureGeometry