/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 3.0.9
 *
 * This file is not intended to be easily readable and contains a number of
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG
 * interface file instead.
 * ----------------------------------------------------------------------------- */
#include <stdio.h>
#include <string.h>
#include <stddef.h>

// Do not edit below this line
// end-of-default-includes


#include <opus/opus.h>

typedef enum{ NONE = -1, GFORTH = 0, SWIFTFORTH, VFX } SwigTargetSystem;
SwigTargetSystem swigTargetSystem = NONE;

unsigned char swigPrintStackComments = 1;

/* comments */
void swigNewline()
{
	printf( "\n" );
}

void swigComment( char *comment )
{
	printf( "\\ %s", comment );
}

/* generic print */
void swigPrint( char* gforth, char *swiftForth, char *vfx )
{
	if( swigTargetSystem == GFORTH )
		printf( "%s", gforth );
	else if( swigTargetSystem == SWIFTFORTH )
		printf( "%s", swiftForth );
	else if( swigTargetSystem == VFX )
		printf( "%s", vfx );
	printf( "\n" );
}
void swigPrintSystem( SwigTargetSystem targetSystem, char *text )
{
	if( targetSystem == swigTargetSystem )
	    printf( "%s\n", text );
}

/* constants */
void swigIntConstant( long constant, char *name )
{
	printf( "#%ld\tconstant %s\n", constant, name );
}

void swigUnsignedIntConstant( unsigned long constant, char *name )
{
	printf( "#%lu\tconstant %s\n", constant, name );
}

void swigLongConstant( long long constant, char *name )
{
	printf( "#%lld.\t2constant %s\n", constant, name );
}

void swigUnsignedLongConstant( unsigned long long constant, char *name )
{
	printf( "#%llu.\t2constant %s\n", constant, name );
}

void swigFloatConstant( double constant, char *name )
{
	char buffer[128];
	sprintf( buffer, "%f", constant );

	/* if the constant contains no exponent, add one */
	char *s;
	for( s = buffer; *s != 0; s++ )
		if( *s == 'e' || *s == 'E' )
			break;

	/* exponent found */
	if( *s != 0 )
		printf( "%s\tfconstant %s\n", buffer, name );
	/* not found */
	else
		printf( "%se0\tfconstant %s\n", buffer, name );
}

void swigStringConstant( char* constant, char *name )
{
	char c;
	printf( ": %s s\\\" ", name );
	while(( c = *constant++ ))
	{
		switch(c)
		{
			case '\b': printf( "\\b" ); break;
			case '\n': printf( "\\n" ); break;
			case '\f': printf( "\\f" ); break;
			case '\r': printf( "\\r" ); break;
			case '\t': printf( "\\t" ); break;
			case '"' : printf( "\\q" ); break;
			default:
				if(c < 0x20)
					printf("\\x%02x", c);
				else
					printf("%c", c); break;
		}
	}
	printf(	"\" ;\n" );
}

/* structs */
void swigStructField( char *name, size_t offset, size_t size )
{
	printf( "\tdrop %zu %zu +field %s\n", offset, size, name );
}

/* functions */
void swigFunction( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	if( swigTargetSystem == GFORTH )
		printf( "%s", gforth );
	else if( swigTargetSystem == SWIFTFORTH )
		printf( "%s", swiftForth );
	else if( swigTargetSystem == VFX )
		printf( "%s", vfx );

	if( swigPrintStackComments )
		printf( "%s", stackComment );

	printf( "\n" );
}

/* function pointers */
void swigFunctionPointer( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	swigFunction( gforth, swiftForth, vfx, stackComment );
}

/* callbacks */
void swigCallback( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	swigFunction( gforth, swiftForth, vfx, stackComment );
}

void swigUsage( char **argv )
{
	fprintf( stderr, "Usage: %s [-gforth|-swiftforth|-vfx]\n", argv[0] );
}

int main( int argc, char **argv )
{
	int i;

	/* check arguments */
	for( i = 1; i < argc; i++ )
		if( strcmp( argv[i], "-gforth" ) == 0 )
			swigTargetSystem = GFORTH;
		else if( strcmp( argv[i], "-swiftforth" ) == 0 )
			swigTargetSystem = SWIFTFORTH;
		else if( strcmp( argv[i], "-vfx" ) == 0 )
			swigTargetSystem = VFX;

	if( swigTargetSystem == NONE )
	{
		fprintf( stderr, "Error: no target system specified\n" );
		swigUsage( argv );
		return 1;
	}

	/* primer */
	printf( "\\ This file has been generated using SWIG and fsi,\n"
		"\\ and is already platform dependent, search for the corresponding\n"
		"\\ fsi-file to compile it where no one has compiled it before ;)\n"
		"\\ Forth systems have their own own dynamic loader and don't need addional C-Code.\n"
		"\\ That's why this file will just print normal forth-code once compiled\n"
		"\\ and can be used directly with include or require.\n"
		"\\ As all comments are stripped during the compilation, please\n"
		"\\ insert the copyright notice of the original file here.\n"
	);



	swigNewline();

	swigComment("----===< prefix >===-----\n");

	swigPrint( "c-library opus\ns\" opus\" add-lib\n\\c #include <opus/opus.h>", "( none )", "( none )" );

	swigNewline();

	swigComment("----===< int constants >===-----\n");
	#ifdef OPUS_OK
		swigIntConstant( OPUS_OK, "OPUS_OK" );
	#endif
	#ifdef OPUS_BAD_ARG
		swigIntConstant( OPUS_BAD_ARG, "OPUS_BAD_ARG" );
	#endif
	#ifdef OPUS_BUFFER_TOO_SMALL
		swigIntConstant( OPUS_BUFFER_TOO_SMALL, "OPUS_BUFFER_TOO_SMALL" );
	#endif
	#ifdef OPUS_INTERNAL_ERROR
		swigIntConstant( OPUS_INTERNAL_ERROR, "OPUS_INTERNAL_ERROR" );
	#endif
	#ifdef OPUS_INVALID_PACKET
		swigIntConstant( OPUS_INVALID_PACKET, "OPUS_INVALID_PACKET" );
	#endif
	#ifdef OPUS_UNIMPLEMENTED
		swigIntConstant( OPUS_UNIMPLEMENTED, "OPUS_UNIMPLEMENTED" );
	#endif
	#ifdef OPUS_INVALID_STATE
		swigIntConstant( OPUS_INVALID_STATE, "OPUS_INVALID_STATE" );
	#endif
	#ifdef OPUS_ALLOC_FAIL
		swigIntConstant( OPUS_ALLOC_FAIL, "OPUS_ALLOC_FAIL" );
	#endif
	#ifdef OPUS_SET_APPLICATION_REQUEST
		swigIntConstant( OPUS_SET_APPLICATION_REQUEST, "OPUS_SET_APPLICATION_REQUEST" );
	#endif
	#ifdef OPUS_GET_APPLICATION_REQUEST
		swigIntConstant( OPUS_GET_APPLICATION_REQUEST, "OPUS_GET_APPLICATION_REQUEST" );
	#endif
	#ifdef OPUS_SET_BITRATE_REQUEST
		swigIntConstant( OPUS_SET_BITRATE_REQUEST, "OPUS_SET_BITRATE_REQUEST" );
	#endif
	#ifdef OPUS_GET_BITRATE_REQUEST
		swigIntConstant( OPUS_GET_BITRATE_REQUEST, "OPUS_GET_BITRATE_REQUEST" );
	#endif
	#ifdef OPUS_SET_MAX_BANDWIDTH_REQUEST
		swigIntConstant( OPUS_SET_MAX_BANDWIDTH_REQUEST, "OPUS_SET_MAX_BANDWIDTH_REQUEST" );
	#endif
	#ifdef OPUS_GET_MAX_BANDWIDTH_REQUEST
		swigIntConstant( OPUS_GET_MAX_BANDWIDTH_REQUEST, "OPUS_GET_MAX_BANDWIDTH_REQUEST" );
	#endif
	#ifdef OPUS_SET_VBR_REQUEST
		swigIntConstant( OPUS_SET_VBR_REQUEST, "OPUS_SET_VBR_REQUEST" );
	#endif
	#ifdef OPUS_GET_VBR_REQUEST
		swigIntConstant( OPUS_GET_VBR_REQUEST, "OPUS_GET_VBR_REQUEST" );
	#endif
	#ifdef OPUS_SET_BANDWIDTH_REQUEST
		swigIntConstant( OPUS_SET_BANDWIDTH_REQUEST, "OPUS_SET_BANDWIDTH_REQUEST" );
	#endif
	#ifdef OPUS_GET_BANDWIDTH_REQUEST
		swigIntConstant( OPUS_GET_BANDWIDTH_REQUEST, "OPUS_GET_BANDWIDTH_REQUEST" );
	#endif
	#ifdef OPUS_SET_COMPLEXITY_REQUEST
		swigIntConstant( OPUS_SET_COMPLEXITY_REQUEST, "OPUS_SET_COMPLEXITY_REQUEST" );
	#endif
	#ifdef OPUS_GET_COMPLEXITY_REQUEST
		swigIntConstant( OPUS_GET_COMPLEXITY_REQUEST, "OPUS_GET_COMPLEXITY_REQUEST" );
	#endif
	#ifdef OPUS_SET_INBAND_FEC_REQUEST
		swigIntConstant( OPUS_SET_INBAND_FEC_REQUEST, "OPUS_SET_INBAND_FEC_REQUEST" );
	#endif
	#ifdef OPUS_GET_INBAND_FEC_REQUEST
		swigIntConstant( OPUS_GET_INBAND_FEC_REQUEST, "OPUS_GET_INBAND_FEC_REQUEST" );
	#endif
	#ifdef OPUS_SET_PACKET_LOSS_PERC_REQUEST
		swigIntConstant( OPUS_SET_PACKET_LOSS_PERC_REQUEST, "OPUS_SET_PACKET_LOSS_PERC_REQUEST" );
	#endif
	#ifdef OPUS_GET_PACKET_LOSS_PERC_REQUEST
		swigIntConstant( OPUS_GET_PACKET_LOSS_PERC_REQUEST, "OPUS_GET_PACKET_LOSS_PERC_REQUEST" );
	#endif
	#ifdef OPUS_SET_DTX_REQUEST
		swigIntConstant( OPUS_SET_DTX_REQUEST, "OPUS_SET_DTX_REQUEST" );
	#endif
	#ifdef OPUS_GET_DTX_REQUEST
		swigIntConstant( OPUS_GET_DTX_REQUEST, "OPUS_GET_DTX_REQUEST" );
	#endif
	#ifdef OPUS_SET_VBR_CONSTRAINT_REQUEST
		swigIntConstant( OPUS_SET_VBR_CONSTRAINT_REQUEST, "OPUS_SET_VBR_CONSTRAINT_REQUEST" );
	#endif
	#ifdef OPUS_GET_VBR_CONSTRAINT_REQUEST
		swigIntConstant( OPUS_GET_VBR_CONSTRAINT_REQUEST, "OPUS_GET_VBR_CONSTRAINT_REQUEST" );
	#endif
	#ifdef OPUS_SET_FORCE_CHANNELS_REQUEST
		swigIntConstant( OPUS_SET_FORCE_CHANNELS_REQUEST, "OPUS_SET_FORCE_CHANNELS_REQUEST" );
	#endif
	#ifdef OPUS_GET_FORCE_CHANNELS_REQUEST
		swigIntConstant( OPUS_GET_FORCE_CHANNELS_REQUEST, "OPUS_GET_FORCE_CHANNELS_REQUEST" );
	#endif
	#ifdef OPUS_SET_SIGNAL_REQUEST
		swigIntConstant( OPUS_SET_SIGNAL_REQUEST, "OPUS_SET_SIGNAL_REQUEST" );
	#endif
	#ifdef OPUS_GET_SIGNAL_REQUEST
		swigIntConstant( OPUS_GET_SIGNAL_REQUEST, "OPUS_GET_SIGNAL_REQUEST" );
	#endif
	#ifdef OPUS_GET_LOOKAHEAD_REQUEST
		swigIntConstant( OPUS_GET_LOOKAHEAD_REQUEST, "OPUS_GET_LOOKAHEAD_REQUEST" );
	#endif
	#ifdef OPUS_GET_SAMPLE_RATE_REQUEST
		swigIntConstant( OPUS_GET_SAMPLE_RATE_REQUEST, "OPUS_GET_SAMPLE_RATE_REQUEST" );
	#endif
	#ifdef OPUS_GET_FINAL_RANGE_REQUEST
		swigIntConstant( OPUS_GET_FINAL_RANGE_REQUEST, "OPUS_GET_FINAL_RANGE_REQUEST" );
	#endif
	#ifdef OPUS_GET_PITCH_REQUEST
		swigIntConstant( OPUS_GET_PITCH_REQUEST, "OPUS_GET_PITCH_REQUEST" );
	#endif
	#ifdef OPUS_SET_GAIN_REQUEST
		swigIntConstant( OPUS_SET_GAIN_REQUEST, "OPUS_SET_GAIN_REQUEST" );
	#endif
	#ifdef OPUS_GET_GAIN_REQUEST
		swigIntConstant( OPUS_GET_GAIN_REQUEST, "OPUS_GET_GAIN_REQUEST" );
	#endif
	#ifdef OPUS_SET_LSB_DEPTH_REQUEST
		swigIntConstant( OPUS_SET_LSB_DEPTH_REQUEST, "OPUS_SET_LSB_DEPTH_REQUEST" );
	#endif
	#ifdef OPUS_GET_LSB_DEPTH_REQUEST
		swigIntConstant( OPUS_GET_LSB_DEPTH_REQUEST, "OPUS_GET_LSB_DEPTH_REQUEST" );
	#endif
	#ifdef OPUS_GET_LAST_PACKET_DURATION_REQUEST
		swigIntConstant( OPUS_GET_LAST_PACKET_DURATION_REQUEST, "OPUS_GET_LAST_PACKET_DURATION_REQUEST" );
	#endif
	#ifdef OPUS_SET_EXPERT_FRAME_DURATION_REQUEST
		swigIntConstant( OPUS_SET_EXPERT_FRAME_DURATION_REQUEST, "OPUS_SET_EXPERT_FRAME_DURATION_REQUEST" );
	#endif
	#ifdef OPUS_GET_EXPERT_FRAME_DURATION_REQUEST
		swigIntConstant( OPUS_GET_EXPERT_FRAME_DURATION_REQUEST, "OPUS_GET_EXPERT_FRAME_DURATION_REQUEST" );
	#endif
	#ifdef OPUS_SET_PREDICTION_DISABLED_REQUEST
		swigIntConstant( OPUS_SET_PREDICTION_DISABLED_REQUEST, "OPUS_SET_PREDICTION_DISABLED_REQUEST" );
	#endif
	#ifdef OPUS_GET_PREDICTION_DISABLED_REQUEST
		swigIntConstant( OPUS_GET_PREDICTION_DISABLED_REQUEST, "OPUS_GET_PREDICTION_DISABLED_REQUEST" );
	#endif
	#ifdef OPUS_SET_PHASE_INVERSION_DISABLED_REQUEST
		swigIntConstant( OPUS_SET_PHASE_INVERSION_DISABLED_REQUEST, "OPUS_SET_PHASE_INVERSION_DISABLED_REQUEST" );
	#endif
	#ifdef OPUS_GET_PHASE_INVERSION_DISABLED_REQUEST
		swigIntConstant( OPUS_GET_PHASE_INVERSION_DISABLED_REQUEST, "OPUS_GET_PHASE_INVERSION_DISABLED_REQUEST" );
	#endif
	#ifdef OPUS_GET_IN_DTX_REQUEST
		swigIntConstant( OPUS_GET_IN_DTX_REQUEST, "OPUS_GET_IN_DTX_REQUEST" );
	#endif
	#ifdef OPUS_AUTO
		swigIntConstant( OPUS_AUTO, "OPUS_AUTO" );
	#endif
	#ifdef OPUS_BITRATE_MAX
		swigIntConstant( OPUS_BITRATE_MAX, "OPUS_BITRATE_MAX" );
	#endif
	#ifdef OPUS_APPLICATION_VOIP
		swigIntConstant( OPUS_APPLICATION_VOIP, "OPUS_APPLICATION_VOIP" );
	#endif
	#ifdef OPUS_APPLICATION_AUDIO
		swigIntConstant( OPUS_APPLICATION_AUDIO, "OPUS_APPLICATION_AUDIO" );
	#endif
	#ifdef OPUS_APPLICATION_RESTRICTED_LOWDELAY
		swigIntConstant( OPUS_APPLICATION_RESTRICTED_LOWDELAY, "OPUS_APPLICATION_RESTRICTED_LOWDELAY" );
	#endif
	#ifdef OPUS_SIGNAL_VOICE
		swigIntConstant( OPUS_SIGNAL_VOICE, "OPUS_SIGNAL_VOICE" );
	#endif
	#ifdef OPUS_SIGNAL_MUSIC
		swigIntConstant( OPUS_SIGNAL_MUSIC, "OPUS_SIGNAL_MUSIC" );
	#endif
	#ifdef OPUS_BANDWIDTH_NARROWBAND
		swigIntConstant( OPUS_BANDWIDTH_NARROWBAND, "OPUS_BANDWIDTH_NARROWBAND" );
	#endif
	#ifdef OPUS_BANDWIDTH_MEDIUMBAND
		swigIntConstant( OPUS_BANDWIDTH_MEDIUMBAND, "OPUS_BANDWIDTH_MEDIUMBAND" );
	#endif
	#ifdef OPUS_BANDWIDTH_WIDEBAND
		swigIntConstant( OPUS_BANDWIDTH_WIDEBAND, "OPUS_BANDWIDTH_WIDEBAND" );
	#endif
	#ifdef OPUS_BANDWIDTH_SUPERWIDEBAND
		swigIntConstant( OPUS_BANDWIDTH_SUPERWIDEBAND, "OPUS_BANDWIDTH_SUPERWIDEBAND" );
	#endif
	#ifdef OPUS_BANDWIDTH_FULLBAND
		swigIntConstant( OPUS_BANDWIDTH_FULLBAND, "OPUS_BANDWIDTH_FULLBAND" );
	#endif
	#ifdef OPUS_FRAMESIZE_ARG
		swigIntConstant( OPUS_FRAMESIZE_ARG, "OPUS_FRAMESIZE_ARG" );
	#endif
	#ifdef OPUS_FRAMESIZE_2_5_MS
		swigIntConstant( OPUS_FRAMESIZE_2_5_MS, "OPUS_FRAMESIZE_2_5_MS" );
	#endif
	#ifdef OPUS_FRAMESIZE_5_MS
		swigIntConstant( OPUS_FRAMESIZE_5_MS, "OPUS_FRAMESIZE_5_MS" );
	#endif
	#ifdef OPUS_FRAMESIZE_10_MS
		swigIntConstant( OPUS_FRAMESIZE_10_MS, "OPUS_FRAMESIZE_10_MS" );
	#endif
	#ifdef OPUS_FRAMESIZE_20_MS
		swigIntConstant( OPUS_FRAMESIZE_20_MS, "OPUS_FRAMESIZE_20_MS" );
	#endif
	#ifdef OPUS_FRAMESIZE_40_MS
		swigIntConstant( OPUS_FRAMESIZE_40_MS, "OPUS_FRAMESIZE_40_MS" );
	#endif
	#ifdef OPUS_FRAMESIZE_60_MS
		swigIntConstant( OPUS_FRAMESIZE_60_MS, "OPUS_FRAMESIZE_60_MS" );
	#endif
	#ifdef OPUS_FRAMESIZE_80_MS
		swigIntConstant( OPUS_FRAMESIZE_80_MS, "OPUS_FRAMESIZE_80_MS" );
	#endif
	#ifdef OPUS_FRAMESIZE_100_MS
		swigIntConstant( OPUS_FRAMESIZE_100_MS, "OPUS_FRAMESIZE_100_MS" );
	#endif
	#ifdef OPUS_FRAMESIZE_120_MS
		swigIntConstant( OPUS_FRAMESIZE_120_MS, "OPUS_FRAMESIZE_120_MS" );
	#endif
	#ifdef OPUS_RESET_STATE
		swigIntConstant( OPUS_RESET_STATE, "OPUS_RESET_STATE" );
	#endif

	swigNewline();

	swigComment("------===< functions >===-------\n");
	swigFunction( "c-function opus_strerror opus_strerror n -- s", "FUNCTION: opus_strerror ( error -- s )", "EXTERN: \"C\" char * opus_strerror( int error );", "	( error -- )" );
	swigFunction( "c-function opus_get_version_string opus_get_version_string  -- s", "FUNCTION: opus_get_version_string (  -- s )", "EXTERN: \"C\" char * opus_get_version_string(  );", "	( -- )" );
	swigFunction( "c-function opus_encoder_get_size opus_encoder_get_size n -- n", "FUNCTION: opus_encoder_get_size ( channels -- n )", "EXTERN: \"C\" int opus_encoder_get_size( int channels );", "	( channels -- )" );
	swigFunction( "c-function opus_encoder_create opus_encoder_create n n n a -- a", "FUNCTION: opus_encoder_create ( Fs channels application error -- a )", "EXTERN: \"C\" void * opus_encoder_create( int Fs, int channels, int application, void * error );", "	( Fs channels application error -- )" );
	swigFunction( "c-function opus_encoder_init opus_encoder_init a n n n -- n", "FUNCTION: opus_encoder_init ( st Fs channels application -- n )", "EXTERN: \"C\" int opus_encoder_init( void * st, int Fs, int channels, int application );", "	( st Fs channels application -- )" );
	swigFunction( "c-function opus_encode opus_encode a a n a n -- n", "FUNCTION: opus_encode ( st pcm frame_size data max_data_bytes -- n )", "EXTERN: \"C\" int opus_encode( void * st, void * pcm, int frame_size, void * data, int max_data_bytes );", "	( st pcm frame_size data max_data_bytes -- )" );
	swigFunction( "c-function opus_encode_float opus_encode_float a a n a n -- n", "FUNCTION: opus_encode_float ( st pcm frame_size data max_data_bytes -- n )", "EXTERN: \"C\" int opus_encode_float( void * st, void * pcm, int frame_size, void * data, int max_data_bytes );", "	( st pcm frame_size data max_data_bytes -- )" );
	swigFunction( "c-function opus_encoder_destroy opus_encoder_destroy a -- void", "FUNCTION: opus_encoder_destroy ( st -- void )", "EXTERN: \"C\" void opus_encoder_destroy( void * st );", "	( st -- )" );
	swigFunction( "c-function opus_encoder_ctl opus_encoder_ctl a n ... -- n", "FUNCTION: opus_encoder_ctl ( st request  -- n )", "EXTERN: \"C\" int opus_encoder_ctl( void * st, int request, ...  );", "	( st request <noname> -- )" );
	swigFunction( "c-function opus_decoder_get_size opus_decoder_get_size n -- n", "FUNCTION: opus_decoder_get_size ( channels -- n )", "EXTERN: \"C\" int opus_decoder_get_size( int channels );", "	( channels -- )" );
	swigFunction( "c-function opus_decoder_create opus_decoder_create n n a -- a", "FUNCTION: opus_decoder_create ( Fs channels error -- a )", "EXTERN: \"C\" void * opus_decoder_create( int Fs, int channels, void * error );", "	( Fs channels error -- )" );
	swigFunction( "c-function opus_decoder_init opus_decoder_init a n n -- n", "FUNCTION: opus_decoder_init ( st Fs channels -- n )", "EXTERN: \"C\" int opus_decoder_init( void * st, int Fs, int channels );", "	( st Fs channels -- )" );
	swigFunction( "c-function opus_decode opus_decode a a n a n n -- n", "FUNCTION: opus_decode ( st data len pcm frame_size decode_fec -- n )", "EXTERN: \"C\" int opus_decode( void * st, void * data, int len, void * pcm, int frame_size, int decode_fec );", "	( st data len pcm frame_size decode_fec -- )" );
	swigFunction( "c-function opus_decode_float opus_decode_float a a n a n n -- n", "FUNCTION: opus_decode_float ( st data len pcm frame_size decode_fec -- n )", "EXTERN: \"C\" int opus_decode_float( void * st, void * data, int len, void * pcm, int frame_size, int decode_fec );", "	( st data len pcm frame_size decode_fec -- )" );
	swigFunction( "c-function opus_decoder_ctl opus_decoder_ctl a n ... -- n", "FUNCTION: opus_decoder_ctl ( st request  -- n )", "EXTERN: \"C\" int opus_decoder_ctl( void * st, int request, ...  );", "	( st request <noname> -- )" );
	swigFunction( "c-function opus_decoder_destroy opus_decoder_destroy a -- void", "FUNCTION: opus_decoder_destroy ( st -- void )", "EXTERN: \"C\" void opus_decoder_destroy( void * st );", "	( st -- )" );
	swigFunction( "c-function opus_packet_parse opus_packet_parse a n a a a a -- n", "FUNCTION: opus_packet_parse ( data len out_toc frames size payload_offset -- n )", "EXTERN: \"C\" int opus_packet_parse( void * data, int len, void * out_toc, void * frames, void * size, void * payload_offset );", "	( data len out_toc frames size payload_offset -- )" );
	swigFunction( "c-function opus_packet_get_bandwidth opus_packet_get_bandwidth a -- n", "FUNCTION: opus_packet_get_bandwidth ( data -- n )", "EXTERN: \"C\" int opus_packet_get_bandwidth( void * data );", "	( data -- )" );
	swigFunction( "c-function opus_packet_get_samples_per_frame opus_packet_get_samples_per_frame a n -- n", "FUNCTION: opus_packet_get_samples_per_frame ( data Fs -- n )", "EXTERN: \"C\" int opus_packet_get_samples_per_frame( void * data, int Fs );", "	( data Fs -- )" );
	swigFunction( "c-function opus_packet_get_nb_channels opus_packet_get_nb_channels a -- n", "FUNCTION: opus_packet_get_nb_channels ( data -- n )", "EXTERN: \"C\" int opus_packet_get_nb_channels( void * data );", "	( data -- )" );
	swigFunction( "c-function opus_packet_get_nb_frames opus_packet_get_nb_frames a n -- n", "FUNCTION: opus_packet_get_nb_frames ( packet len -- n )", "EXTERN: \"C\" int opus_packet_get_nb_frames( void * packet, int len );", "	( packet len -- )" );
	swigFunction( "c-function opus_packet_get_nb_samples opus_packet_get_nb_samples a n n -- n", "FUNCTION: opus_packet_get_nb_samples ( packet len Fs -- n )", "EXTERN: \"C\" int opus_packet_get_nb_samples( void * packet, int len, int Fs );", "	( packet len Fs -- )" );
	swigFunction( "c-function opus_decoder_get_nb_samples opus_decoder_get_nb_samples a a n -- n", "FUNCTION: opus_decoder_get_nb_samples ( dec packet len -- n )", "EXTERN: \"C\" int opus_decoder_get_nb_samples( void * dec, void * packet, int len );", "	( dec packet len -- )" );
	swigFunction( "c-function opus_pcm_soft_clip opus_pcm_soft_clip a n n a -- void", "FUNCTION: opus_pcm_soft_clip ( pcm frame_size channels softclip_mem -- void )", "EXTERN: \"C\" void opus_pcm_soft_clip( void * pcm, int frame_size, int channels, void * softclip_mem );", "	( pcm frame_size channels softclip_mem -- )" );
	swigFunction( "c-function opus_repacketizer_get_size opus_repacketizer_get_size  -- n", "FUNCTION: opus_repacketizer_get_size (  -- n )", "EXTERN: \"C\" int opus_repacketizer_get_size(  );", "	( -- )" );
	swigFunction( "c-function opus_repacketizer_init opus_repacketizer_init a -- a", "FUNCTION: opus_repacketizer_init ( rp -- a )", "EXTERN: \"C\" void * opus_repacketizer_init( void * rp );", "	( rp -- )" );
	swigFunction( "c-function opus_repacketizer_create opus_repacketizer_create  -- a", "FUNCTION: opus_repacketizer_create (  -- a )", "EXTERN: \"C\" void * opus_repacketizer_create(  );", "	( -- )" );
	swigFunction( "c-function opus_repacketizer_destroy opus_repacketizer_destroy a -- void", "FUNCTION: opus_repacketizer_destroy ( rp -- void )", "EXTERN: \"C\" void opus_repacketizer_destroy( void * rp );", "	( rp -- )" );
	swigFunction( "c-function opus_repacketizer_cat opus_repacketizer_cat a a n -- n", "FUNCTION: opus_repacketizer_cat ( rp data len -- n )", "EXTERN: \"C\" int opus_repacketizer_cat( void * rp, void * data, int len );", "	( rp data len -- )" );
	swigFunction( "c-function opus_repacketizer_out_range opus_repacketizer_out_range a n n a n -- n", "FUNCTION: opus_repacketizer_out_range ( rp begin end data maxlen -- n )", "EXTERN: \"C\" int opus_repacketizer_out_range( void * rp, int begin, int end, void * data, int maxlen );", "	( rp begin end data maxlen -- )" );
	swigFunction( "c-function opus_repacketizer_get_nb_frames opus_repacketizer_get_nb_frames a -- n", "FUNCTION: opus_repacketizer_get_nb_frames ( rp -- n )", "EXTERN: \"C\" int opus_repacketizer_get_nb_frames( void * rp );", "	( rp -- )" );
	swigFunction( "c-function opus_repacketizer_out opus_repacketizer_out a a n -- n", "FUNCTION: opus_repacketizer_out ( rp data maxlen -- n )", "EXTERN: \"C\" int opus_repacketizer_out( void * rp, void * data, int maxlen );", "	( rp data maxlen -- )" );
	swigFunction( "c-function opus_packet_pad opus_packet_pad a n n -- n", "FUNCTION: opus_packet_pad ( data len new_len -- n )", "EXTERN: \"C\" int opus_packet_pad( void * data, int len, int new_len );", "	( data len new_len -- )" );
	swigFunction( "c-function opus_packet_unpad opus_packet_unpad a n -- n", "FUNCTION: opus_packet_unpad ( data len -- n )", "EXTERN: \"C\" int opus_packet_unpad( void * data, int len );", "	( data len -- )" );
	swigFunction( "c-function opus_multistream_packet_pad opus_multistream_packet_pad a n n n -- n", "FUNCTION: opus_multistream_packet_pad ( data len new_len nb_streams -- n )", "EXTERN: \"C\" int opus_multistream_packet_pad( void * data, int len, int new_len, int nb_streams );", "	( data len new_len nb_streams -- )" );
	swigFunction( "c-function opus_multistream_packet_unpad opus_multistream_packet_unpad a n n -- n", "FUNCTION: opus_multistream_packet_unpad ( data len nb_streams -- n )", "EXTERN: \"C\" int opus_multistream_packet_unpad( void * data, int len, int nb_streams );", "	( data len nb_streams -- )" );

	swigNewline();

	swigComment("----===< postfix >===-----\n");

	swigPrint( "end-c-library", "( none )", "( none )" );
	
	return 0;
} /* end of main */



