/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 3.0.9
 *
 * This file is not intended to be easily readable and contains a number of
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG
 * interface file instead.
 * ----------------------------------------------------------------------------- */
#include <stdio.h>
#include <string.h>
#include <stddef.h>

// Do not edit below this line
// end-of-default-includes


#include <libavcodec/avcodec.h>
#include <libavutil/pixfmt.h>
#undef gforth_d2ll
#define gforth_d2ll(x1,x2) av_make_q(x1,x2)

typedef enum{ NONE = -1, GFORTH = 0, SWIFTFORTH, VFX } SwigTargetSystem;
SwigTargetSystem swigTargetSystem = NONE;

unsigned char swigPrintStackComments = 1;

/* comments */
void swigNewline()
{
	printf( "\n" );
}

void swigComment( char *comment )
{
	printf( "\\ %s", comment );
}

/* generic print */
void swigPrint( char* gforth, char *swiftForth, char *vfx )
{
	if( swigTargetSystem == GFORTH )
		printf( "%s", gforth );
	else if( swigTargetSystem == SWIFTFORTH )
		printf( "%s", swiftForth );
	else if( swigTargetSystem == VFX )
		printf( "%s", vfx );
	printf( "\n" );
}
void swigPrintSystem( SwigTargetSystem targetSystem, char *text )
{
	if( targetSystem == swigTargetSystem )
	    printf( "%s\n", text );
}

/* constants */
void swigIntConstant( long constant, char *name )
{
	printf( "#%ld\tconstant %s\n", constant, name );
}

void swigUnsignedIntConstant( unsigned long constant, char *name )
{
	printf( "#%lu\tconstant %s\n", constant, name );
}

void swigLongConstant( long long constant, char *name )
{
	printf( "#%lld.\t2constant %s\n", constant, name );
}

void swigUnsignedLongConstant( unsigned long long constant, char *name )
{
	printf( "#%llu.\t2constant %s\n", constant, name );
}

void swigFloatConstant( double constant, char *name )
{
	char buffer[128];
	sprintf( buffer, "%f", constant );

	/* if the constant contains no exponent, add one */
	char *s;
	for( s = buffer; *s != 0; s++ )
		if( *s == 'e' || *s == 'E' )
			break;

	/* exponent found */
	if( *s != 0 )
		printf( "%s\tfconstant %s\n", buffer, name );
	/* not found */
	else
		printf( "%se0\tfconstant %s\n", buffer, name );
}

void swigStringConstant( char* constant, char *name )
{
	char c;
	printf( ": %s s\\\" ", name );
	while(( c = *constant++ ))
	{
		switch(c)
		{
			case '\b': printf( "\\b" ); break;
			case '\n': printf( "\\n" ); break;
			case '\f': printf( "\\f" ); break;
			case '\r': printf( "\\r" ); break;
			case '\t': printf( "\\t" ); break;
			case '"' : printf( "\\q" ); break;
			default:
				if(c < 0x20)
					printf("\\x%02x", c);
				else
					printf("%c", c); break;
		}
	}
	printf(	"\" ;\n" );
}

/* structs */
void swigStructField( char *name, size_t offset, size_t size )
{
	printf( "\tdrop %zu %zu +field %s\n", offset, size, name );
}

/* functions */
void swigFunction( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	if( swigTargetSystem == GFORTH )
		printf( "%s", gforth );
	else if( swigTargetSystem == SWIFTFORTH )
		printf( "%s", swiftForth );
	else if( swigTargetSystem == VFX )
		printf( "%s", vfx );

	if( swigPrintStackComments )
		printf( "%s", stackComment );

	printf( "\n" );
}

/* function pointers */
void swigFunctionPointer( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	swigFunction( gforth, swiftForth, vfx, stackComment );
}

/* callbacks */
void swigCallback( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	swigFunction( gforth, swiftForth, vfx, stackComment );
}

void swigUsage( char **argv )
{
	fprintf( stderr, "Usage: %s [-gforth|-swiftforth|-vfx]\n", argv[0] );
}

int main( int argc, char **argv )
{
	int i;

	/* check arguments */
	for( i = 1; i < argc; i++ )
		if( strcmp( argv[i], "-gforth" ) == 0 )
			swigTargetSystem = GFORTH;
		else if( strcmp( argv[i], "-swiftforth" ) == 0 )
			swigTargetSystem = SWIFTFORTH;
		else if( strcmp( argv[i], "-vfx" ) == 0 )
			swigTargetSystem = VFX;

	if( swigTargetSystem == NONE )
	{
		fprintf( stderr, "Error: no target system specified\n" );
		swigUsage( argv );
		return 1;
	}

	/* primer */
	printf( "\\ This file has been generated using SWIG and fsi,\n"
		"\\ and is already platform dependent, search for the corresponding\n"
		"\\ fsi-file to compile it where no one has compiled it before ;)\n"
		"\\ Forth systems have their own own dynamic loader and don't need addional C-Code.\n"
		"\\ That's why this file will just print normal forth-code once compiled\n"
		"\\ and can be used directly with include or require.\n"
		"\\ As all comments are stripped during the compilation, please\n"
		"\\ insert the copyright notice of the original file here.\n"
	);



	swigNewline();

	swigComment("----===< prefix >===-----\n");

	swigPrint( "c-library avcodec\ns\" avcodec\" add-lib\n\\c #include <libavcodec/avcodec.h>\n\\c #include <libavutil/pixfmt.h>\n\\c #undef gforth_d2ll\n\\c #define gforth_d2ll(x1,x2) av_make_q(x1,x2)", "( none )", "( none )" );

	swigNewline();

	swigComment("----===< int constants >===-----\n");
	#ifdef AV_CODEC_PROP_INTRA_ONLY
		swigIntConstant( AV_CODEC_PROP_INTRA_ONLY, "AV_CODEC_PROP_INTRA_ONLY" );
	#endif
	#ifdef AV_CODEC_PROP_LOSSY
		swigIntConstant( AV_CODEC_PROP_LOSSY, "AV_CODEC_PROP_LOSSY" );
	#endif
	#ifdef AV_CODEC_PROP_LOSSLESS
		swigIntConstant( AV_CODEC_PROP_LOSSLESS, "AV_CODEC_PROP_LOSSLESS" );
	#endif
	#ifdef AV_CODEC_PROP_REORDER
		swigIntConstant( AV_CODEC_PROP_REORDER, "AV_CODEC_PROP_REORDER" );
	#endif
	#ifdef AV_CODEC_PROP_BITMAP_SUB
		swigIntConstant( AV_CODEC_PROP_BITMAP_SUB, "AV_CODEC_PROP_BITMAP_SUB" );
	#endif
	#ifdef AV_CODEC_PROP_TEXT_SUB
		swigIntConstant( AV_CODEC_PROP_TEXT_SUB, "AV_CODEC_PROP_TEXT_SUB" );
	#endif
	#ifdef AV_INPUT_BUFFER_PADDING_SIZE
		swigIntConstant( AV_INPUT_BUFFER_PADDING_SIZE, "AV_INPUT_BUFFER_PADDING_SIZE" );
	#endif
	#ifdef AV_INPUT_BUFFER_MIN_SIZE
		swigIntConstant( AV_INPUT_BUFFER_MIN_SIZE, "AV_INPUT_BUFFER_MIN_SIZE" );
	#endif
	#ifdef AV_CODEC_FLAG_UNALIGNED
		swigIntConstant( AV_CODEC_FLAG_UNALIGNED, "AV_CODEC_FLAG_UNALIGNED" );
	#endif
	#ifdef AV_CODEC_FLAG_QSCALE
		swigIntConstant( AV_CODEC_FLAG_QSCALE, "AV_CODEC_FLAG_QSCALE" );
	#endif
	#ifdef AV_CODEC_FLAG_4MV
		swigIntConstant( AV_CODEC_FLAG_4MV, "AV_CODEC_FLAG_4MV" );
	#endif
	#ifdef AV_CODEC_FLAG_OUTPUT_CORRUPT
		swigIntConstant( AV_CODEC_FLAG_OUTPUT_CORRUPT, "AV_CODEC_FLAG_OUTPUT_CORRUPT" );
	#endif
	#ifdef AV_CODEC_FLAG_QPEL
		swigIntConstant( AV_CODEC_FLAG_QPEL, "AV_CODEC_FLAG_QPEL" );
	#endif
	#ifdef AV_CODEC_FLAG_DROPCHANGED
		swigIntConstant( AV_CODEC_FLAG_DROPCHANGED, "AV_CODEC_FLAG_DROPCHANGED" );
	#endif
	#ifdef AV_CODEC_FLAG_PASS1
		swigIntConstant( AV_CODEC_FLAG_PASS1, "AV_CODEC_FLAG_PASS1" );
	#endif
	#ifdef AV_CODEC_FLAG_PASS2
		swigIntConstant( AV_CODEC_FLAG_PASS2, "AV_CODEC_FLAG_PASS2" );
	#endif
	#ifdef AV_CODEC_FLAG_LOOP_FILTER
		swigIntConstant( AV_CODEC_FLAG_LOOP_FILTER, "AV_CODEC_FLAG_LOOP_FILTER" );
	#endif
	#ifdef AV_CODEC_FLAG_GRAY
		swigIntConstant( AV_CODEC_FLAG_GRAY, "AV_CODEC_FLAG_GRAY" );
	#endif
	#ifdef AV_CODEC_FLAG_PSNR
		swigIntConstant( AV_CODEC_FLAG_PSNR, "AV_CODEC_FLAG_PSNR" );
	#endif
	#ifdef AV_CODEC_FLAG_TRUNCATED
		swigIntConstant( AV_CODEC_FLAG_TRUNCATED, "AV_CODEC_FLAG_TRUNCATED" );
	#endif
	#ifdef AV_CODEC_FLAG_INTERLACED_DCT
		swigIntConstant( AV_CODEC_FLAG_INTERLACED_DCT, "AV_CODEC_FLAG_INTERLACED_DCT" );
	#endif
	#ifdef AV_CODEC_FLAG_LOW_DELAY
		swigIntConstant( AV_CODEC_FLAG_LOW_DELAY, "AV_CODEC_FLAG_LOW_DELAY" );
	#endif
	#ifdef AV_CODEC_FLAG_GLOBAL_HEADER
		swigIntConstant( AV_CODEC_FLAG_GLOBAL_HEADER, "AV_CODEC_FLAG_GLOBAL_HEADER" );
	#endif
	#ifdef AV_CODEC_FLAG_BITEXACT
		swigIntConstant( AV_CODEC_FLAG_BITEXACT, "AV_CODEC_FLAG_BITEXACT" );
	#endif
	#ifdef AV_CODEC_FLAG_AC_PRED
		swigIntConstant( AV_CODEC_FLAG_AC_PRED, "AV_CODEC_FLAG_AC_PRED" );
	#endif
	#ifdef AV_CODEC_FLAG_INTERLACED_ME
		swigIntConstant( AV_CODEC_FLAG_INTERLACED_ME, "AV_CODEC_FLAG_INTERLACED_ME" );
	#endif
	#ifdef AV_CODEC_FLAG_CLOSED_GOP
		swigUnsignedIntConstant( AV_CODEC_FLAG_CLOSED_GOP, "AV_CODEC_FLAG_CLOSED_GOP" );
	#endif
	#ifdef AV_CODEC_FLAG2_FAST
		swigIntConstant( AV_CODEC_FLAG2_FAST, "AV_CODEC_FLAG2_FAST" );
	#endif
	#ifdef AV_CODEC_FLAG2_NO_OUTPUT
		swigIntConstant( AV_CODEC_FLAG2_NO_OUTPUT, "AV_CODEC_FLAG2_NO_OUTPUT" );
	#endif
	#ifdef AV_CODEC_FLAG2_LOCAL_HEADER
		swigIntConstant( AV_CODEC_FLAG2_LOCAL_HEADER, "AV_CODEC_FLAG2_LOCAL_HEADER" );
	#endif
	#ifdef AV_CODEC_FLAG2_DROP_FRAME_TIMECODE
		swigIntConstant( AV_CODEC_FLAG2_DROP_FRAME_TIMECODE, "AV_CODEC_FLAG2_DROP_FRAME_TIMECODE" );
	#endif
	#ifdef AV_CODEC_FLAG2_CHUNKS
		swigIntConstant( AV_CODEC_FLAG2_CHUNKS, "AV_CODEC_FLAG2_CHUNKS" );
	#endif
	#ifdef AV_CODEC_FLAG2_IGNORE_CROP
		swigIntConstant( AV_CODEC_FLAG2_IGNORE_CROP, "AV_CODEC_FLAG2_IGNORE_CROP" );
	#endif
	#ifdef AV_CODEC_FLAG2_SHOW_ALL
		swigIntConstant( AV_CODEC_FLAG2_SHOW_ALL, "AV_CODEC_FLAG2_SHOW_ALL" );
	#endif
	#ifdef AV_CODEC_FLAG2_EXPORT_MVS
		swigIntConstant( AV_CODEC_FLAG2_EXPORT_MVS, "AV_CODEC_FLAG2_EXPORT_MVS" );
	#endif
	#ifdef AV_CODEC_FLAG2_SKIP_MANUAL
		swigIntConstant( AV_CODEC_FLAG2_SKIP_MANUAL, "AV_CODEC_FLAG2_SKIP_MANUAL" );
	#endif
	#ifdef AV_CODEC_FLAG2_RO_FLUSH_NOOP
		swigIntConstant( AV_CODEC_FLAG2_RO_FLUSH_NOOP, "AV_CODEC_FLAG2_RO_FLUSH_NOOP" );
	#endif
	#ifdef AV_CODEC_CAP_DRAW_HORIZ_BAND
		swigIntConstant( AV_CODEC_CAP_DRAW_HORIZ_BAND, "AV_CODEC_CAP_DRAW_HORIZ_BAND" );
	#endif
	#ifdef AV_CODEC_CAP_DR1
		swigIntConstant( AV_CODEC_CAP_DR1, "AV_CODEC_CAP_DR1" );
	#endif
	#ifdef AV_CODEC_CAP_TRUNCATED
		swigIntConstant( AV_CODEC_CAP_TRUNCATED, "AV_CODEC_CAP_TRUNCATED" );
	#endif
	#ifdef AV_CODEC_CAP_DELAY
		swigIntConstant( AV_CODEC_CAP_DELAY, "AV_CODEC_CAP_DELAY" );
	#endif
	#ifdef AV_CODEC_CAP_SMALL_LAST_FRAME
		swigIntConstant( AV_CODEC_CAP_SMALL_LAST_FRAME, "AV_CODEC_CAP_SMALL_LAST_FRAME" );
	#endif
	#ifdef AV_CODEC_CAP_SUBFRAMES
		swigIntConstant( AV_CODEC_CAP_SUBFRAMES, "AV_CODEC_CAP_SUBFRAMES" );
	#endif
	#ifdef AV_CODEC_CAP_EXPERIMENTAL
		swigIntConstant( AV_CODEC_CAP_EXPERIMENTAL, "AV_CODEC_CAP_EXPERIMENTAL" );
	#endif
	#ifdef AV_CODEC_CAP_CHANNEL_CONF
		swigIntConstant( AV_CODEC_CAP_CHANNEL_CONF, "AV_CODEC_CAP_CHANNEL_CONF" );
	#endif
	#ifdef AV_CODEC_CAP_FRAME_THREADS
		swigIntConstant( AV_CODEC_CAP_FRAME_THREADS, "AV_CODEC_CAP_FRAME_THREADS" );
	#endif
	#ifdef AV_CODEC_CAP_SLICE_THREADS
		swigIntConstant( AV_CODEC_CAP_SLICE_THREADS, "AV_CODEC_CAP_SLICE_THREADS" );
	#endif
	#ifdef AV_CODEC_CAP_PARAM_CHANGE
		swigIntConstant( AV_CODEC_CAP_PARAM_CHANGE, "AV_CODEC_CAP_PARAM_CHANGE" );
	#endif
	#ifdef AV_CODEC_CAP_AUTO_THREADS
		swigIntConstant( AV_CODEC_CAP_AUTO_THREADS, "AV_CODEC_CAP_AUTO_THREADS" );
	#endif
	#ifdef AV_CODEC_CAP_VARIABLE_FRAME_SIZE
		swigIntConstant( AV_CODEC_CAP_VARIABLE_FRAME_SIZE, "AV_CODEC_CAP_VARIABLE_FRAME_SIZE" );
	#endif
	#ifdef AV_CODEC_CAP_AVOID_PROBING
		swigIntConstant( AV_CODEC_CAP_AVOID_PROBING, "AV_CODEC_CAP_AVOID_PROBING" );
	#endif
	#ifdef AV_CODEC_CAP_INTRA_ONLY
		swigIntConstant( AV_CODEC_CAP_INTRA_ONLY, "AV_CODEC_CAP_INTRA_ONLY" );
	#endif
	#ifdef AV_CODEC_CAP_LOSSLESS
		swigIntConstant( AV_CODEC_CAP_LOSSLESS, "AV_CODEC_CAP_LOSSLESS" );
	#endif
	#ifdef AV_CODEC_CAP_HARDWARE
		swigIntConstant( AV_CODEC_CAP_HARDWARE, "AV_CODEC_CAP_HARDWARE" );
	#endif
	#ifdef AV_CODEC_CAP_HYBRID
		swigIntConstant( AV_CODEC_CAP_HYBRID, "AV_CODEC_CAP_HYBRID" );
	#endif
	#ifdef AV_CODEC_CAP_ENCODER_REORDERED_OPAQUE
		swigIntConstant( AV_CODEC_CAP_ENCODER_REORDERED_OPAQUE, "AV_CODEC_CAP_ENCODER_REORDERED_OPAQUE" );
	#endif
	#ifdef AV_GET_BUFFER_FLAG_REF
		swigIntConstant( AV_GET_BUFFER_FLAG_REF, "AV_GET_BUFFER_FLAG_REF" );
	#endif
	#ifdef AV_PKT_FLAG_KEY
		swigIntConstant( AV_PKT_FLAG_KEY, "AV_PKT_FLAG_KEY" );
	#endif
	#ifdef AV_PKT_FLAG_CORRUPT
		swigIntConstant( AV_PKT_FLAG_CORRUPT, "AV_PKT_FLAG_CORRUPT" );
	#endif
	#ifdef AV_PKT_FLAG_DISCARD
		swigIntConstant( AV_PKT_FLAG_DISCARD, "AV_PKT_FLAG_DISCARD" );
	#endif
	#ifdef AV_PKT_FLAG_TRUSTED
		swigIntConstant( AV_PKT_FLAG_TRUSTED, "AV_PKT_FLAG_TRUSTED" );
	#endif
	#ifdef AV_PKT_FLAG_DISPOSABLE
		swigIntConstant( AV_PKT_FLAG_DISPOSABLE, "AV_PKT_FLAG_DISPOSABLE" );
	#endif
	#ifdef FF_COMPRESSION_DEFAULT
		swigIntConstant( FF_COMPRESSION_DEFAULT, "FF_COMPRESSION_DEFAULT" );
	#endif
	#ifdef FF_CMP_SAD
		swigIntConstant( FF_CMP_SAD, "FF_CMP_SAD" );
	#endif
	#ifdef FF_CMP_SSE
		swigIntConstant( FF_CMP_SSE, "FF_CMP_SSE" );
	#endif
	#ifdef FF_CMP_SATD
		swigIntConstant( FF_CMP_SATD, "FF_CMP_SATD" );
	#endif
	#ifdef FF_CMP_DCT
		swigIntConstant( FF_CMP_DCT, "FF_CMP_DCT" );
	#endif
	#ifdef FF_CMP_PSNR
		swigIntConstant( FF_CMP_PSNR, "FF_CMP_PSNR" );
	#endif
	#ifdef FF_CMP_BIT
		swigIntConstant( FF_CMP_BIT, "FF_CMP_BIT" );
	#endif
	#ifdef FF_CMP_RD
		swigIntConstant( FF_CMP_RD, "FF_CMP_RD" );
	#endif
	#ifdef FF_CMP_ZERO
		swigIntConstant( FF_CMP_ZERO, "FF_CMP_ZERO" );
	#endif
	#ifdef FF_CMP_VSAD
		swigIntConstant( FF_CMP_VSAD, "FF_CMP_VSAD" );
	#endif
	#ifdef FF_CMP_VSSE
		swigIntConstant( FF_CMP_VSSE, "FF_CMP_VSSE" );
	#endif
	#ifdef FF_CMP_NSSE
		swigIntConstant( FF_CMP_NSSE, "FF_CMP_NSSE" );
	#endif
	#ifdef FF_CMP_W53
		swigIntConstant( FF_CMP_W53, "FF_CMP_W53" );
	#endif
	#ifdef FF_CMP_W97
		swigIntConstant( FF_CMP_W97, "FF_CMP_W97" );
	#endif
	#ifdef FF_CMP_DCTMAX
		swigIntConstant( FF_CMP_DCTMAX, "FF_CMP_DCTMAX" );
	#endif
	#ifdef FF_CMP_DCT264
		swigIntConstant( FF_CMP_DCT264, "FF_CMP_DCT264" );
	#endif
	#ifdef FF_CMP_MEDIAN_SAD
		swigIntConstant( FF_CMP_MEDIAN_SAD, "FF_CMP_MEDIAN_SAD" );
	#endif
	#ifdef FF_CMP_CHROMA
		swigIntConstant( FF_CMP_CHROMA, "FF_CMP_CHROMA" );
	#endif
	#ifdef SLICE_FLAG_CODED_ORDER
		swigIntConstant( SLICE_FLAG_CODED_ORDER, "SLICE_FLAG_CODED_ORDER" );
	#endif
	#ifdef SLICE_FLAG_ALLOW_FIELD
		swigIntConstant( SLICE_FLAG_ALLOW_FIELD, "SLICE_FLAG_ALLOW_FIELD" );
	#endif
	#ifdef SLICE_FLAG_ALLOW_PLANE
		swigIntConstant( SLICE_FLAG_ALLOW_PLANE, "SLICE_FLAG_ALLOW_PLANE" );
	#endif
	#ifdef FF_MB_DECISION_SIMPLE
		swigIntConstant( FF_MB_DECISION_SIMPLE, "FF_MB_DECISION_SIMPLE" );
	#endif
	#ifdef FF_MB_DECISION_BITS
		swigIntConstant( FF_MB_DECISION_BITS, "FF_MB_DECISION_BITS" );
	#endif
	#ifdef FF_MB_DECISION_RD
		swigIntConstant( FF_MB_DECISION_RD, "FF_MB_DECISION_RD" );
	#endif
	#ifdef FF_BUG_AUTODETECT
		swigIntConstant( FF_BUG_AUTODETECT, "FF_BUG_AUTODETECT" );
	#endif
	#ifdef FF_BUG_XVID_ILACE
		swigIntConstant( FF_BUG_XVID_ILACE, "FF_BUG_XVID_ILACE" );
	#endif
	#ifdef FF_BUG_UMP4
		swigIntConstant( FF_BUG_UMP4, "FF_BUG_UMP4" );
	#endif
	#ifdef FF_BUG_NO_PADDING
		swigIntConstant( FF_BUG_NO_PADDING, "FF_BUG_NO_PADDING" );
	#endif
	#ifdef FF_BUG_AMV
		swigIntConstant( FF_BUG_AMV, "FF_BUG_AMV" );
	#endif
	#ifdef FF_BUG_QPEL_CHROMA
		swigIntConstant( FF_BUG_QPEL_CHROMA, "FF_BUG_QPEL_CHROMA" );
	#endif
	#ifdef FF_BUG_STD_QPEL
		swigIntConstant( FF_BUG_STD_QPEL, "FF_BUG_STD_QPEL" );
	#endif
	#ifdef FF_BUG_QPEL_CHROMA2
		swigIntConstant( FF_BUG_QPEL_CHROMA2, "FF_BUG_QPEL_CHROMA2" );
	#endif
	#ifdef FF_BUG_DIRECT_BLOCKSIZE
		swigIntConstant( FF_BUG_DIRECT_BLOCKSIZE, "FF_BUG_DIRECT_BLOCKSIZE" );
	#endif
	#ifdef FF_BUG_EDGE
		swigIntConstant( FF_BUG_EDGE, "FF_BUG_EDGE" );
	#endif
	#ifdef FF_BUG_HPEL_CHROMA
		swigIntConstant( FF_BUG_HPEL_CHROMA, "FF_BUG_HPEL_CHROMA" );
	#endif
	#ifdef FF_BUG_DC_CLIP
		swigIntConstant( FF_BUG_DC_CLIP, "FF_BUG_DC_CLIP" );
	#endif
	#ifdef FF_BUG_MS
		swigIntConstant( FF_BUG_MS, "FF_BUG_MS" );
	#endif
	#ifdef FF_BUG_TRUNCATED
		swigIntConstant( FF_BUG_TRUNCATED, "FF_BUG_TRUNCATED" );
	#endif
	#ifdef FF_BUG_IEDGE
		swigIntConstant( FF_BUG_IEDGE, "FF_BUG_IEDGE" );
	#endif
	#ifdef FF_COMPLIANCE_VERY_STRICT
		swigIntConstant( FF_COMPLIANCE_VERY_STRICT, "FF_COMPLIANCE_VERY_STRICT" );
	#endif
	#ifdef FF_COMPLIANCE_STRICT
		swigIntConstant( FF_COMPLIANCE_STRICT, "FF_COMPLIANCE_STRICT" );
	#endif
	#ifdef FF_COMPLIANCE_NORMAL
		swigIntConstant( FF_COMPLIANCE_NORMAL, "FF_COMPLIANCE_NORMAL" );
	#endif
	#ifdef FF_COMPLIANCE_UNOFFICIAL
		swigIntConstant( FF_COMPLIANCE_UNOFFICIAL, "FF_COMPLIANCE_UNOFFICIAL" );
	#endif
	#ifdef FF_COMPLIANCE_EXPERIMENTAL
		swigIntConstant( FF_COMPLIANCE_EXPERIMENTAL, "FF_COMPLIANCE_EXPERIMENTAL" );
	#endif
	#ifdef FF_EC_GUESS_MVS
		swigIntConstant( FF_EC_GUESS_MVS, "FF_EC_GUESS_MVS" );
	#endif
	#ifdef FF_EC_DEBLOCK
		swigIntConstant( FF_EC_DEBLOCK, "FF_EC_DEBLOCK" );
	#endif
	#ifdef FF_EC_FAVOR_INTER
		swigIntConstant( FF_EC_FAVOR_INTER, "FF_EC_FAVOR_INTER" );
	#endif
	#ifdef FF_DEBUG_PICT_INFO
		swigIntConstant( FF_DEBUG_PICT_INFO, "FF_DEBUG_PICT_INFO" );
	#endif
	#ifdef FF_DEBUG_RC
		swigIntConstant( FF_DEBUG_RC, "FF_DEBUG_RC" );
	#endif
	#ifdef FF_DEBUG_BITSTREAM
		swigIntConstant( FF_DEBUG_BITSTREAM, "FF_DEBUG_BITSTREAM" );
	#endif
	#ifdef FF_DEBUG_MB_TYPE
		swigIntConstant( FF_DEBUG_MB_TYPE, "FF_DEBUG_MB_TYPE" );
	#endif
	#ifdef FF_DEBUG_QP
		swigIntConstant( FF_DEBUG_QP, "FF_DEBUG_QP" );
	#endif
	#ifdef FF_DEBUG_DCT_COEFF
		swigIntConstant( FF_DEBUG_DCT_COEFF, "FF_DEBUG_DCT_COEFF" );
	#endif
	#ifdef FF_DEBUG_SKIP
		swigIntConstant( FF_DEBUG_SKIP, "FF_DEBUG_SKIP" );
	#endif
	#ifdef FF_DEBUG_STARTCODE
		swigIntConstant( FF_DEBUG_STARTCODE, "FF_DEBUG_STARTCODE" );
	#endif
	#ifdef FF_DEBUG_ER
		swigIntConstant( FF_DEBUG_ER, "FF_DEBUG_ER" );
	#endif
	#ifdef FF_DEBUG_MMCO
		swigIntConstant( FF_DEBUG_MMCO, "FF_DEBUG_MMCO" );
	#endif
	#ifdef FF_DEBUG_BUGS
		swigIntConstant( FF_DEBUG_BUGS, "FF_DEBUG_BUGS" );
	#endif
	#ifdef FF_DEBUG_BUFFERS
		swigIntConstant( FF_DEBUG_BUFFERS, "FF_DEBUG_BUFFERS" );
	#endif
	#ifdef FF_DEBUG_THREADS
		swigIntConstant( FF_DEBUG_THREADS, "FF_DEBUG_THREADS" );
	#endif
	#ifdef FF_DEBUG_GREEN_MD
		swigIntConstant( FF_DEBUG_GREEN_MD, "FF_DEBUG_GREEN_MD" );
	#endif
	#ifdef FF_DEBUG_NOMC
		swigIntConstant( FF_DEBUG_NOMC, "FF_DEBUG_NOMC" );
	#endif
	#ifdef AV_EF_CRCCHECK
		swigIntConstant( AV_EF_CRCCHECK, "AV_EF_CRCCHECK" );
	#endif
	#ifdef AV_EF_BITSTREAM
		swigIntConstant( AV_EF_BITSTREAM, "AV_EF_BITSTREAM" );
	#endif
	#ifdef AV_EF_BUFFER
		swigIntConstant( AV_EF_BUFFER, "AV_EF_BUFFER" );
	#endif
	#ifdef AV_EF_EXPLODE
		swigIntConstant( AV_EF_EXPLODE, "AV_EF_EXPLODE" );
	#endif
	#ifdef AV_EF_IGNORE_ERR
		swigIntConstant( AV_EF_IGNORE_ERR, "AV_EF_IGNORE_ERR" );
	#endif
	#ifdef AV_EF_CAREFUL
		swigIntConstant( AV_EF_CAREFUL, "AV_EF_CAREFUL" );
	#endif
	#ifdef AV_EF_COMPLIANT
		swigIntConstant( AV_EF_COMPLIANT, "AV_EF_COMPLIANT" );
	#endif
	#ifdef AV_EF_AGGRESSIVE
		swigIntConstant( AV_EF_AGGRESSIVE, "AV_EF_AGGRESSIVE" );
	#endif
	#ifdef FF_DCT_AUTO
		swigIntConstant( FF_DCT_AUTO, "FF_DCT_AUTO" );
	#endif
	#ifdef FF_DCT_FASTINT
		swigIntConstant( FF_DCT_FASTINT, "FF_DCT_FASTINT" );
	#endif
	#ifdef FF_DCT_INT
		swigIntConstant( FF_DCT_INT, "FF_DCT_INT" );
	#endif
	#ifdef FF_DCT_MMX
		swigIntConstant( FF_DCT_MMX, "FF_DCT_MMX" );
	#endif
	#ifdef FF_DCT_ALTIVEC
		swigIntConstant( FF_DCT_ALTIVEC, "FF_DCT_ALTIVEC" );
	#endif
	#ifdef FF_DCT_FAAN
		swigIntConstant( FF_DCT_FAAN, "FF_DCT_FAAN" );
	#endif
	#ifdef FF_IDCT_AUTO
		swigIntConstant( FF_IDCT_AUTO, "FF_IDCT_AUTO" );
	#endif
	#ifdef FF_IDCT_INT
		swigIntConstant( FF_IDCT_INT, "FF_IDCT_INT" );
	#endif
	#ifdef FF_IDCT_SIMPLE
		swigIntConstant( FF_IDCT_SIMPLE, "FF_IDCT_SIMPLE" );
	#endif
	#ifdef FF_IDCT_SIMPLEMMX
		swigIntConstant( FF_IDCT_SIMPLEMMX, "FF_IDCT_SIMPLEMMX" );
	#endif
	#ifdef FF_IDCT_ARM
		swigIntConstant( FF_IDCT_ARM, "FF_IDCT_ARM" );
	#endif
	#ifdef FF_IDCT_ALTIVEC
		swigIntConstant( FF_IDCT_ALTIVEC, "FF_IDCT_ALTIVEC" );
	#endif
	#ifdef FF_IDCT_SIMPLEARM
		swigIntConstant( FF_IDCT_SIMPLEARM, "FF_IDCT_SIMPLEARM" );
	#endif
	#ifdef FF_IDCT_XVID
		swigIntConstant( FF_IDCT_XVID, "FF_IDCT_XVID" );
	#endif
	#ifdef FF_IDCT_SIMPLEARMV5TE
		swigIntConstant( FF_IDCT_SIMPLEARMV5TE, "FF_IDCT_SIMPLEARMV5TE" );
	#endif
	#ifdef FF_IDCT_SIMPLEARMV6
		swigIntConstant( FF_IDCT_SIMPLEARMV6, "FF_IDCT_SIMPLEARMV6" );
	#endif
	#ifdef FF_IDCT_FAAN
		swigIntConstant( FF_IDCT_FAAN, "FF_IDCT_FAAN" );
	#endif
	#ifdef FF_IDCT_SIMPLENEON
		swigIntConstant( FF_IDCT_SIMPLENEON, "FF_IDCT_SIMPLENEON" );
	#endif
	#ifdef FF_IDCT_NONE
		swigIntConstant( FF_IDCT_NONE, "FF_IDCT_NONE" );
	#endif
	#ifdef FF_IDCT_SIMPLEAUTO
		swigIntConstant( FF_IDCT_SIMPLEAUTO, "FF_IDCT_SIMPLEAUTO" );
	#endif
	#ifdef FF_THREAD_FRAME
		swigIntConstant( FF_THREAD_FRAME, "FF_THREAD_FRAME" );
	#endif
	#ifdef FF_THREAD_SLICE
		swigIntConstant( FF_THREAD_SLICE, "FF_THREAD_SLICE" );
	#endif
	#ifdef FF_PROFILE_UNKNOWN
		swigIntConstant( FF_PROFILE_UNKNOWN, "FF_PROFILE_UNKNOWN" );
	#endif
	#ifdef FF_PROFILE_RESERVED
		swigIntConstant( FF_PROFILE_RESERVED, "FF_PROFILE_RESERVED" );
	#endif
	#ifdef FF_PROFILE_AAC_MAIN
		swigIntConstant( FF_PROFILE_AAC_MAIN, "FF_PROFILE_AAC_MAIN" );
	#endif
	#ifdef FF_PROFILE_AAC_LOW
		swigIntConstant( FF_PROFILE_AAC_LOW, "FF_PROFILE_AAC_LOW" );
	#endif
	#ifdef FF_PROFILE_AAC_SSR
		swigIntConstant( FF_PROFILE_AAC_SSR, "FF_PROFILE_AAC_SSR" );
	#endif
	#ifdef FF_PROFILE_AAC_LTP
		swigIntConstant( FF_PROFILE_AAC_LTP, "FF_PROFILE_AAC_LTP" );
	#endif
	#ifdef FF_PROFILE_AAC_HE
		swigIntConstant( FF_PROFILE_AAC_HE, "FF_PROFILE_AAC_HE" );
	#endif
	#ifdef FF_PROFILE_AAC_HE_V2
		swigIntConstant( FF_PROFILE_AAC_HE_V2, "FF_PROFILE_AAC_HE_V2" );
	#endif
	#ifdef FF_PROFILE_AAC_LD
		swigIntConstant( FF_PROFILE_AAC_LD, "FF_PROFILE_AAC_LD" );
	#endif
	#ifdef FF_PROFILE_AAC_ELD
		swigIntConstant( FF_PROFILE_AAC_ELD, "FF_PROFILE_AAC_ELD" );
	#endif
	#ifdef FF_PROFILE_MPEG2_AAC_LOW
		swigIntConstant( FF_PROFILE_MPEG2_AAC_LOW, "FF_PROFILE_MPEG2_AAC_LOW" );
	#endif
	#ifdef FF_PROFILE_MPEG2_AAC_HE
		swigIntConstant( FF_PROFILE_MPEG2_AAC_HE, "FF_PROFILE_MPEG2_AAC_HE" );
	#endif
	#ifdef FF_PROFILE_DNXHD
		swigIntConstant( FF_PROFILE_DNXHD, "FF_PROFILE_DNXHD" );
	#endif
	#ifdef FF_PROFILE_DNXHR_LB
		swigIntConstant( FF_PROFILE_DNXHR_LB, "FF_PROFILE_DNXHR_LB" );
	#endif
	#ifdef FF_PROFILE_DNXHR_SQ
		swigIntConstant( FF_PROFILE_DNXHR_SQ, "FF_PROFILE_DNXHR_SQ" );
	#endif
	#ifdef FF_PROFILE_DNXHR_HQ
		swigIntConstant( FF_PROFILE_DNXHR_HQ, "FF_PROFILE_DNXHR_HQ" );
	#endif
	#ifdef FF_PROFILE_DNXHR_HQX
		swigIntConstant( FF_PROFILE_DNXHR_HQX, "FF_PROFILE_DNXHR_HQX" );
	#endif
	#ifdef FF_PROFILE_DNXHR_444
		swigIntConstant( FF_PROFILE_DNXHR_444, "FF_PROFILE_DNXHR_444" );
	#endif
	#ifdef FF_PROFILE_DTS
		swigIntConstant( FF_PROFILE_DTS, "FF_PROFILE_DTS" );
	#endif
	#ifdef FF_PROFILE_DTS_ES
		swigIntConstant( FF_PROFILE_DTS_ES, "FF_PROFILE_DTS_ES" );
	#endif
	#ifdef FF_PROFILE_DTS_96_24
		swigIntConstant( FF_PROFILE_DTS_96_24, "FF_PROFILE_DTS_96_24" );
	#endif
	#ifdef FF_PROFILE_DTS_HD_HRA
		swigIntConstant( FF_PROFILE_DTS_HD_HRA, "FF_PROFILE_DTS_HD_HRA" );
	#endif
	#ifdef FF_PROFILE_DTS_HD_MA
		swigIntConstant( FF_PROFILE_DTS_HD_MA, "FF_PROFILE_DTS_HD_MA" );
	#endif
	#ifdef FF_PROFILE_DTS_EXPRESS
		swigIntConstant( FF_PROFILE_DTS_EXPRESS, "FF_PROFILE_DTS_EXPRESS" );
	#endif
	#ifdef FF_PROFILE_MPEG2_422
		swigIntConstant( FF_PROFILE_MPEG2_422, "FF_PROFILE_MPEG2_422" );
	#endif
	#ifdef FF_PROFILE_MPEG2_HIGH
		swigIntConstant( FF_PROFILE_MPEG2_HIGH, "FF_PROFILE_MPEG2_HIGH" );
	#endif
	#ifdef FF_PROFILE_MPEG2_SS
		swigIntConstant( FF_PROFILE_MPEG2_SS, "FF_PROFILE_MPEG2_SS" );
	#endif
	#ifdef FF_PROFILE_MPEG2_SNR_SCALABLE
		swigIntConstant( FF_PROFILE_MPEG2_SNR_SCALABLE, "FF_PROFILE_MPEG2_SNR_SCALABLE" );
	#endif
	#ifdef FF_PROFILE_MPEG2_MAIN
		swigIntConstant( FF_PROFILE_MPEG2_MAIN, "FF_PROFILE_MPEG2_MAIN" );
	#endif
	#ifdef FF_PROFILE_MPEG2_SIMPLE
		swigIntConstant( FF_PROFILE_MPEG2_SIMPLE, "FF_PROFILE_MPEG2_SIMPLE" );
	#endif
	#ifdef FF_PROFILE_H264_CONSTRAINED
		swigIntConstant( FF_PROFILE_H264_CONSTRAINED, "FF_PROFILE_H264_CONSTRAINED" );
	#endif
	#ifdef FF_PROFILE_H264_INTRA
		swigIntConstant( FF_PROFILE_H264_INTRA, "FF_PROFILE_H264_INTRA" );
	#endif
	#ifdef FF_PROFILE_H264_BASELINE
		swigIntConstant( FF_PROFILE_H264_BASELINE, "FF_PROFILE_H264_BASELINE" );
	#endif
	#ifdef FF_PROFILE_H264_CONSTRAINED_BASELINE
		swigIntConstant( FF_PROFILE_H264_CONSTRAINED_BASELINE, "FF_PROFILE_H264_CONSTRAINED_BASELINE" );
	#endif
	#ifdef FF_PROFILE_H264_MAIN
		swigIntConstant( FF_PROFILE_H264_MAIN, "FF_PROFILE_H264_MAIN" );
	#endif
	#ifdef FF_PROFILE_H264_EXTENDED
		swigIntConstant( FF_PROFILE_H264_EXTENDED, "FF_PROFILE_H264_EXTENDED" );
	#endif
	#ifdef FF_PROFILE_H264_HIGH
		swigIntConstant( FF_PROFILE_H264_HIGH, "FF_PROFILE_H264_HIGH" );
	#endif
	#ifdef FF_PROFILE_H264_HIGH_10
		swigIntConstant( FF_PROFILE_H264_HIGH_10, "FF_PROFILE_H264_HIGH_10" );
	#endif
	#ifdef FF_PROFILE_H264_HIGH_10_INTRA
		swigIntConstant( FF_PROFILE_H264_HIGH_10_INTRA, "FF_PROFILE_H264_HIGH_10_INTRA" );
	#endif
	#ifdef FF_PROFILE_H264_MULTIVIEW_HIGH
		swigIntConstant( FF_PROFILE_H264_MULTIVIEW_HIGH, "FF_PROFILE_H264_MULTIVIEW_HIGH" );
	#endif
	#ifdef FF_PROFILE_H264_HIGH_422
		swigIntConstant( FF_PROFILE_H264_HIGH_422, "FF_PROFILE_H264_HIGH_422" );
	#endif
	#ifdef FF_PROFILE_H264_HIGH_422_INTRA
		swigIntConstant( FF_PROFILE_H264_HIGH_422_INTRA, "FF_PROFILE_H264_HIGH_422_INTRA" );
	#endif
	#ifdef FF_PROFILE_H264_STEREO_HIGH
		swigIntConstant( FF_PROFILE_H264_STEREO_HIGH, "FF_PROFILE_H264_STEREO_HIGH" );
	#endif
	#ifdef FF_PROFILE_H264_HIGH_444
		swigIntConstant( FF_PROFILE_H264_HIGH_444, "FF_PROFILE_H264_HIGH_444" );
	#endif
	#ifdef FF_PROFILE_H264_HIGH_444_PREDICTIVE
		swigIntConstant( FF_PROFILE_H264_HIGH_444_PREDICTIVE, "FF_PROFILE_H264_HIGH_444_PREDICTIVE" );
	#endif
	#ifdef FF_PROFILE_H264_HIGH_444_INTRA
		swigIntConstant( FF_PROFILE_H264_HIGH_444_INTRA, "FF_PROFILE_H264_HIGH_444_INTRA" );
	#endif
	#ifdef FF_PROFILE_H264_CAVLC_444
		swigIntConstant( FF_PROFILE_H264_CAVLC_444, "FF_PROFILE_H264_CAVLC_444" );
	#endif
	#ifdef FF_PROFILE_VC1_SIMPLE
		swigIntConstant( FF_PROFILE_VC1_SIMPLE, "FF_PROFILE_VC1_SIMPLE" );
	#endif
	#ifdef FF_PROFILE_VC1_MAIN
		swigIntConstant( FF_PROFILE_VC1_MAIN, "FF_PROFILE_VC1_MAIN" );
	#endif
	#ifdef FF_PROFILE_VC1_COMPLEX
		swigIntConstant( FF_PROFILE_VC1_COMPLEX, "FF_PROFILE_VC1_COMPLEX" );
	#endif
	#ifdef FF_PROFILE_VC1_ADVANCED
		swigIntConstant( FF_PROFILE_VC1_ADVANCED, "FF_PROFILE_VC1_ADVANCED" );
	#endif
	#ifdef FF_PROFILE_MPEG4_SIMPLE
		swigIntConstant( FF_PROFILE_MPEG4_SIMPLE, "FF_PROFILE_MPEG4_SIMPLE" );
	#endif
	#ifdef FF_PROFILE_MPEG4_SIMPLE_SCALABLE
		swigIntConstant( FF_PROFILE_MPEG4_SIMPLE_SCALABLE, "FF_PROFILE_MPEG4_SIMPLE_SCALABLE" );
	#endif
	#ifdef FF_PROFILE_MPEG4_CORE
		swigIntConstant( FF_PROFILE_MPEG4_CORE, "FF_PROFILE_MPEG4_CORE" );
	#endif
	#ifdef FF_PROFILE_MPEG4_MAIN
		swigIntConstant( FF_PROFILE_MPEG4_MAIN, "FF_PROFILE_MPEG4_MAIN" );
	#endif
	#ifdef FF_PROFILE_MPEG4_N_BIT
		swigIntConstant( FF_PROFILE_MPEG4_N_BIT, "FF_PROFILE_MPEG4_N_BIT" );
	#endif
	#ifdef FF_PROFILE_MPEG4_SCALABLE_TEXTURE
		swigIntConstant( FF_PROFILE_MPEG4_SCALABLE_TEXTURE, "FF_PROFILE_MPEG4_SCALABLE_TEXTURE" );
	#endif
	#ifdef FF_PROFILE_MPEG4_SIMPLE_FACE_ANIMATION
		swigIntConstant( FF_PROFILE_MPEG4_SIMPLE_FACE_ANIMATION, "FF_PROFILE_MPEG4_SIMPLE_FACE_ANIMATION" );
	#endif
	#ifdef FF_PROFILE_MPEG4_BASIC_ANIMATED_TEXTURE
		swigIntConstant( FF_PROFILE_MPEG4_BASIC_ANIMATED_TEXTURE, "FF_PROFILE_MPEG4_BASIC_ANIMATED_TEXTURE" );
	#endif
	#ifdef FF_PROFILE_MPEG4_HYBRID
		swigIntConstant( FF_PROFILE_MPEG4_HYBRID, "FF_PROFILE_MPEG4_HYBRID" );
	#endif
	#ifdef FF_PROFILE_MPEG4_ADVANCED_REAL_TIME
		swigIntConstant( FF_PROFILE_MPEG4_ADVANCED_REAL_TIME, "FF_PROFILE_MPEG4_ADVANCED_REAL_TIME" );
	#endif
	#ifdef FF_PROFILE_MPEG4_CORE_SCALABLE
		swigIntConstant( FF_PROFILE_MPEG4_CORE_SCALABLE, "FF_PROFILE_MPEG4_CORE_SCALABLE" );
	#endif
	#ifdef FF_PROFILE_MPEG4_ADVANCED_CODING
		swigIntConstant( FF_PROFILE_MPEG4_ADVANCED_CODING, "FF_PROFILE_MPEG4_ADVANCED_CODING" );
	#endif
	#ifdef FF_PROFILE_MPEG4_ADVANCED_CORE
		swigIntConstant( FF_PROFILE_MPEG4_ADVANCED_CORE, "FF_PROFILE_MPEG4_ADVANCED_CORE" );
	#endif
	#ifdef FF_PROFILE_MPEG4_ADVANCED_SCALABLE_TEXTURE
		swigIntConstant( FF_PROFILE_MPEG4_ADVANCED_SCALABLE_TEXTURE, "FF_PROFILE_MPEG4_ADVANCED_SCALABLE_TEXTURE" );
	#endif
	#ifdef FF_PROFILE_MPEG4_SIMPLE_STUDIO
		swigIntConstant( FF_PROFILE_MPEG4_SIMPLE_STUDIO, "FF_PROFILE_MPEG4_SIMPLE_STUDIO" );
	#endif
	#ifdef FF_PROFILE_MPEG4_ADVANCED_SIMPLE
		swigIntConstant( FF_PROFILE_MPEG4_ADVANCED_SIMPLE, "FF_PROFILE_MPEG4_ADVANCED_SIMPLE" );
	#endif
	#ifdef FF_PROFILE_JPEG2000_CSTREAM_RESTRICTION_0
		swigIntConstant( FF_PROFILE_JPEG2000_CSTREAM_RESTRICTION_0, "FF_PROFILE_JPEG2000_CSTREAM_RESTRICTION_0" );
	#endif
	#ifdef FF_PROFILE_JPEG2000_CSTREAM_RESTRICTION_1
		swigIntConstant( FF_PROFILE_JPEG2000_CSTREAM_RESTRICTION_1, "FF_PROFILE_JPEG2000_CSTREAM_RESTRICTION_1" );
	#endif
	#ifdef FF_PROFILE_JPEG2000_CSTREAM_NO_RESTRICTION
		swigIntConstant( FF_PROFILE_JPEG2000_CSTREAM_NO_RESTRICTION, "FF_PROFILE_JPEG2000_CSTREAM_NO_RESTRICTION" );
	#endif
	#ifdef FF_PROFILE_JPEG2000_DCINEMA_2K
		swigIntConstant( FF_PROFILE_JPEG2000_DCINEMA_2K, "FF_PROFILE_JPEG2000_DCINEMA_2K" );
	#endif
	#ifdef FF_PROFILE_JPEG2000_DCINEMA_4K
		swigIntConstant( FF_PROFILE_JPEG2000_DCINEMA_4K, "FF_PROFILE_JPEG2000_DCINEMA_4K" );
	#endif
	#ifdef FF_PROFILE_VP9_0
		swigIntConstant( FF_PROFILE_VP9_0, "FF_PROFILE_VP9_0" );
	#endif
	#ifdef FF_PROFILE_VP9_1
		swigIntConstant( FF_PROFILE_VP9_1, "FF_PROFILE_VP9_1" );
	#endif
	#ifdef FF_PROFILE_VP9_2
		swigIntConstant( FF_PROFILE_VP9_2, "FF_PROFILE_VP9_2" );
	#endif
	#ifdef FF_PROFILE_VP9_3
		swigIntConstant( FF_PROFILE_VP9_3, "FF_PROFILE_VP9_3" );
	#endif
	#ifdef FF_PROFILE_HEVC_MAIN
		swigIntConstant( FF_PROFILE_HEVC_MAIN, "FF_PROFILE_HEVC_MAIN" );
	#endif
	#ifdef FF_PROFILE_HEVC_MAIN_10
		swigIntConstant( FF_PROFILE_HEVC_MAIN_10, "FF_PROFILE_HEVC_MAIN_10" );
	#endif
	#ifdef FF_PROFILE_HEVC_MAIN_STILL_PICTURE
		swigIntConstant( FF_PROFILE_HEVC_MAIN_STILL_PICTURE, "FF_PROFILE_HEVC_MAIN_STILL_PICTURE" );
	#endif
	#ifdef FF_PROFILE_HEVC_REXT
		swigIntConstant( FF_PROFILE_HEVC_REXT, "FF_PROFILE_HEVC_REXT" );
	#endif
	#ifdef FF_PROFILE_AV1_MAIN
		swigIntConstant( FF_PROFILE_AV1_MAIN, "FF_PROFILE_AV1_MAIN" );
	#endif
	#ifdef FF_PROFILE_AV1_HIGH
		swigIntConstant( FF_PROFILE_AV1_HIGH, "FF_PROFILE_AV1_HIGH" );
	#endif
	#ifdef FF_PROFILE_AV1_PROFESSIONAL
		swigIntConstant( FF_PROFILE_AV1_PROFESSIONAL, "FF_PROFILE_AV1_PROFESSIONAL" );
	#endif
	#ifdef FF_PROFILE_MJPEG_HUFFMAN_BASELINE_DCT
		swigIntConstant( FF_PROFILE_MJPEG_HUFFMAN_BASELINE_DCT, "FF_PROFILE_MJPEG_HUFFMAN_BASELINE_DCT" );
	#endif
	#ifdef FF_PROFILE_MJPEG_HUFFMAN_EXTENDED_SEQUENTIAL_DCT
		swigIntConstant( FF_PROFILE_MJPEG_HUFFMAN_EXTENDED_SEQUENTIAL_DCT, "FF_PROFILE_MJPEG_HUFFMAN_EXTENDED_SEQUENTIAL_DCT" );
	#endif
	#ifdef FF_PROFILE_MJPEG_HUFFMAN_PROGRESSIVE_DCT
		swigIntConstant( FF_PROFILE_MJPEG_HUFFMAN_PROGRESSIVE_DCT, "FF_PROFILE_MJPEG_HUFFMAN_PROGRESSIVE_DCT" );
	#endif
	#ifdef FF_PROFILE_MJPEG_HUFFMAN_LOSSLESS
		swigIntConstant( FF_PROFILE_MJPEG_HUFFMAN_LOSSLESS, "FF_PROFILE_MJPEG_HUFFMAN_LOSSLESS" );
	#endif
	#ifdef FF_PROFILE_MJPEG_JPEG_LS
		swigIntConstant( FF_PROFILE_MJPEG_JPEG_LS, "FF_PROFILE_MJPEG_JPEG_LS" );
	#endif
	#ifdef FF_PROFILE_SBC_MSBC
		swigIntConstant( FF_PROFILE_SBC_MSBC, "FF_PROFILE_SBC_MSBC" );
	#endif
	#ifdef FF_PROFILE_PRORES_PROXY
		swigIntConstant( FF_PROFILE_PRORES_PROXY, "FF_PROFILE_PRORES_PROXY" );
	#endif
	#ifdef FF_PROFILE_PRORES_LT
		swigIntConstant( FF_PROFILE_PRORES_LT, "FF_PROFILE_PRORES_LT" );
	#endif
	#ifdef FF_PROFILE_PRORES_STANDARD
		swigIntConstant( FF_PROFILE_PRORES_STANDARD, "FF_PROFILE_PRORES_STANDARD" );
	#endif
	#ifdef FF_PROFILE_PRORES_HQ
		swigIntConstant( FF_PROFILE_PRORES_HQ, "FF_PROFILE_PRORES_HQ" );
	#endif
	#ifdef FF_PROFILE_PRORES_4444
		swigIntConstant( FF_PROFILE_PRORES_4444, "FF_PROFILE_PRORES_4444" );
	#endif
	#ifdef FF_PROFILE_PRORES_XQ
		swigIntConstant( FF_PROFILE_PRORES_XQ, "FF_PROFILE_PRORES_XQ" );
	#endif
	#ifdef FF_PROFILE_ARIB_PROFILE_A
		swigIntConstant( FF_PROFILE_ARIB_PROFILE_A, "FF_PROFILE_ARIB_PROFILE_A" );
	#endif
	#ifdef FF_PROFILE_ARIB_PROFILE_C
		swigIntConstant( FF_PROFILE_ARIB_PROFILE_C, "FF_PROFILE_ARIB_PROFILE_C" );
	#endif
	#ifdef FF_LEVEL_UNKNOWN
		swigIntConstant( FF_LEVEL_UNKNOWN, "FF_LEVEL_UNKNOWN" );
	#endif
	#ifdef FF_SUB_CHARENC_MODE_DO_NOTHING
		swigIntConstant( FF_SUB_CHARENC_MODE_DO_NOTHING, "FF_SUB_CHARENC_MODE_DO_NOTHING" );
	#endif
	#ifdef FF_SUB_CHARENC_MODE_AUTOMATIC
		swigIntConstant( FF_SUB_CHARENC_MODE_AUTOMATIC, "FF_SUB_CHARENC_MODE_AUTOMATIC" );
	#endif
	#ifdef FF_SUB_CHARENC_MODE_PRE_DECODER
		swigIntConstant( FF_SUB_CHARENC_MODE_PRE_DECODER, "FF_SUB_CHARENC_MODE_PRE_DECODER" );
	#endif
	#ifdef FF_SUB_CHARENC_MODE_IGNORE
		swigIntConstant( FF_SUB_CHARENC_MODE_IGNORE, "FF_SUB_CHARENC_MODE_IGNORE" );
	#endif
	#ifdef FF_DEBUG_VIS_MV_P_FOR
		swigIntConstant( FF_DEBUG_VIS_MV_P_FOR, "FF_DEBUG_VIS_MV_P_FOR" );
	#endif
	#ifdef FF_DEBUG_VIS_MV_B_FOR
		swigIntConstant( FF_DEBUG_VIS_MV_B_FOR, "FF_DEBUG_VIS_MV_B_FOR" );
	#endif
	#ifdef FF_DEBUG_VIS_MV_B_BACK
		swigIntConstant( FF_DEBUG_VIS_MV_B_BACK, "FF_DEBUG_VIS_MV_B_BACK" );
	#endif
	#ifdef FF_CODEC_PROPERTY_LOSSLESS
		swigIntConstant( FF_CODEC_PROPERTY_LOSSLESS, "FF_CODEC_PROPERTY_LOSSLESS" );
	#endif
	#ifdef FF_CODEC_PROPERTY_CLOSED_CAPTIONS
		swigIntConstant( FF_CODEC_PROPERTY_CLOSED_CAPTIONS, "FF_CODEC_PROPERTY_CLOSED_CAPTIONS" );
	#endif
	#ifdef FF_SUB_TEXT_FMT_ASS
		swigIntConstant( FF_SUB_TEXT_FMT_ASS, "FF_SUB_TEXT_FMT_ASS" );
	#endif
	#ifdef AV_HWACCEL_CODEC_CAP_EXPERIMENTAL
		swigIntConstant( AV_HWACCEL_CODEC_CAP_EXPERIMENTAL, "AV_HWACCEL_CODEC_CAP_EXPERIMENTAL" );
	#endif
	#ifdef AV_HWACCEL_FLAG_IGNORE_LEVEL
		swigIntConstant( AV_HWACCEL_FLAG_IGNORE_LEVEL, "AV_HWACCEL_FLAG_IGNORE_LEVEL" );
	#endif
	#ifdef AV_HWACCEL_FLAG_ALLOW_HIGH_DEPTH
		swigIntConstant( AV_HWACCEL_FLAG_ALLOW_HIGH_DEPTH, "AV_HWACCEL_FLAG_ALLOW_HIGH_DEPTH" );
	#endif
	#ifdef AV_HWACCEL_FLAG_ALLOW_PROFILE_MISMATCH
		swigIntConstant( AV_HWACCEL_FLAG_ALLOW_PROFILE_MISMATCH, "AV_HWACCEL_FLAG_ALLOW_PROFILE_MISMATCH" );
	#endif
	#ifdef AV_SUBTITLE_FLAG_FORCED
		swigIntConstant( AV_SUBTITLE_FLAG_FORCED, "AV_SUBTITLE_FLAG_FORCED" );
	#endif
	#ifdef AV_PARSER_PTS_NB
		swigIntConstant( AV_PARSER_PTS_NB, "AV_PARSER_PTS_NB" );
	#endif
	#ifdef PARSER_FLAG_COMPLETE_FRAMES
		swigIntConstant( PARSER_FLAG_COMPLETE_FRAMES, "PARSER_FLAG_COMPLETE_FRAMES" );
	#endif
	#ifdef PARSER_FLAG_ONCE
		swigIntConstant( PARSER_FLAG_ONCE, "PARSER_FLAG_ONCE" );
	#endif
	#ifdef PARSER_FLAG_FETCHED_OFFSET
		swigIntConstant( PARSER_FLAG_FETCHED_OFFSET, "PARSER_FLAG_FETCHED_OFFSET" );
	#endif
	#ifdef PARSER_FLAG_USE_CODEC_TS
		swigIntConstant( PARSER_FLAG_USE_CODEC_TS, "PARSER_FLAG_USE_CODEC_TS" );
	#endif
	#ifdef AVPALETTE_SIZE
		swigIntConstant( AVPALETTE_SIZE, "AVPALETTE_SIZE" );
	#endif
	#ifdef AVPALETTE_COUNT
		swigIntConstant( AVPALETTE_COUNT, "AVPALETTE_COUNT" );
	#endif

	swigNewline();

	swigComment("--------===< enums >===---------\n");
	swigIntConstant( AV_CODEC_ID_NONE, "AV_CODEC_ID_NONE" );
	swigIntConstant( AV_CODEC_ID_MPEG1VIDEO, "AV_CODEC_ID_MPEG1VIDEO" );
	swigIntConstant( AV_CODEC_ID_MPEG2VIDEO, "AV_CODEC_ID_MPEG2VIDEO" );
	swigIntConstant( AV_CODEC_ID_H261, "AV_CODEC_ID_H261" );
	swigIntConstant( AV_CODEC_ID_H263, "AV_CODEC_ID_H263" );
	swigIntConstant( AV_CODEC_ID_RV10, "AV_CODEC_ID_RV10" );
	swigIntConstant( AV_CODEC_ID_RV20, "AV_CODEC_ID_RV20" );
	swigIntConstant( AV_CODEC_ID_MJPEG, "AV_CODEC_ID_MJPEG" );
	swigIntConstant( AV_CODEC_ID_MJPEGB, "AV_CODEC_ID_MJPEGB" );
	swigIntConstant( AV_CODEC_ID_LJPEG, "AV_CODEC_ID_LJPEG" );
	swigIntConstant( AV_CODEC_ID_SP5X, "AV_CODEC_ID_SP5X" );
	swigIntConstant( AV_CODEC_ID_JPEGLS, "AV_CODEC_ID_JPEGLS" );
	swigIntConstant( AV_CODEC_ID_MPEG4, "AV_CODEC_ID_MPEG4" );
	swigIntConstant( AV_CODEC_ID_RAWVIDEO, "AV_CODEC_ID_RAWVIDEO" );
	swigIntConstant( AV_CODEC_ID_MSMPEG4V1, "AV_CODEC_ID_MSMPEG4V1" );
	swigIntConstant( AV_CODEC_ID_MSMPEG4V2, "AV_CODEC_ID_MSMPEG4V2" );
	swigIntConstant( AV_CODEC_ID_MSMPEG4V3, "AV_CODEC_ID_MSMPEG4V3" );
	swigIntConstant( AV_CODEC_ID_WMV1, "AV_CODEC_ID_WMV1" );
	swigIntConstant( AV_CODEC_ID_WMV2, "AV_CODEC_ID_WMV2" );
	swigIntConstant( AV_CODEC_ID_H263P, "AV_CODEC_ID_H263P" );
	swigIntConstant( AV_CODEC_ID_H263I, "AV_CODEC_ID_H263I" );
	swigIntConstant( AV_CODEC_ID_FLV1, "AV_CODEC_ID_FLV1" );
	swigIntConstant( AV_CODEC_ID_SVQ1, "AV_CODEC_ID_SVQ1" );
	swigIntConstant( AV_CODEC_ID_SVQ3, "AV_CODEC_ID_SVQ3" );
	swigIntConstant( AV_CODEC_ID_DVVIDEO, "AV_CODEC_ID_DVVIDEO" );
	swigIntConstant( AV_CODEC_ID_HUFFYUV, "AV_CODEC_ID_HUFFYUV" );
	swigIntConstant( AV_CODEC_ID_CYUV, "AV_CODEC_ID_CYUV" );
	swigIntConstant( AV_CODEC_ID_H264, "AV_CODEC_ID_H264" );
	swigIntConstant( AV_CODEC_ID_INDEO3, "AV_CODEC_ID_INDEO3" );
	swigIntConstant( AV_CODEC_ID_VP3, "AV_CODEC_ID_VP3" );
	swigIntConstant( AV_CODEC_ID_THEORA, "AV_CODEC_ID_THEORA" );
	swigIntConstant( AV_CODEC_ID_ASV1, "AV_CODEC_ID_ASV1" );
	swigIntConstant( AV_CODEC_ID_ASV2, "AV_CODEC_ID_ASV2" );
	swigIntConstant( AV_CODEC_ID_FFV1, "AV_CODEC_ID_FFV1" );
	swigIntConstant( AV_CODEC_ID_4XM, "AV_CODEC_ID_4XM" );
	swigIntConstant( AV_CODEC_ID_VCR1, "AV_CODEC_ID_VCR1" );
	swigIntConstant( AV_CODEC_ID_CLJR, "AV_CODEC_ID_CLJR" );
	swigIntConstant( AV_CODEC_ID_MDEC, "AV_CODEC_ID_MDEC" );
	swigIntConstant( AV_CODEC_ID_ROQ, "AV_CODEC_ID_ROQ" );
	swigIntConstant( AV_CODEC_ID_INTERPLAY_VIDEO, "AV_CODEC_ID_INTERPLAY_VIDEO" );
	swigIntConstant( AV_CODEC_ID_XAN_WC3, "AV_CODEC_ID_XAN_WC3" );
	swigIntConstant( AV_CODEC_ID_XAN_WC4, "AV_CODEC_ID_XAN_WC4" );
	swigIntConstant( AV_CODEC_ID_RPZA, "AV_CODEC_ID_RPZA" );
	swigIntConstant( AV_CODEC_ID_CINEPAK, "AV_CODEC_ID_CINEPAK" );
	swigIntConstant( AV_CODEC_ID_WS_VQA, "AV_CODEC_ID_WS_VQA" );
	swigIntConstant( AV_CODEC_ID_MSRLE, "AV_CODEC_ID_MSRLE" );
	swigIntConstant( AV_CODEC_ID_MSVIDEO1, "AV_CODEC_ID_MSVIDEO1" );
	swigIntConstant( AV_CODEC_ID_IDCIN, "AV_CODEC_ID_IDCIN" );
	swigIntConstant( AV_CODEC_ID_8BPS, "AV_CODEC_ID_8BPS" );
	swigIntConstant( AV_CODEC_ID_SMC, "AV_CODEC_ID_SMC" );
	swigIntConstant( AV_CODEC_ID_FLIC, "AV_CODEC_ID_FLIC" );
	swigIntConstant( AV_CODEC_ID_TRUEMOTION1, "AV_CODEC_ID_TRUEMOTION1" );
	swigIntConstant( AV_CODEC_ID_VMDVIDEO, "AV_CODEC_ID_VMDVIDEO" );
	swigIntConstant( AV_CODEC_ID_MSZH, "AV_CODEC_ID_MSZH" );
	swigIntConstant( AV_CODEC_ID_ZLIB, "AV_CODEC_ID_ZLIB" );
	swigIntConstant( AV_CODEC_ID_QTRLE, "AV_CODEC_ID_QTRLE" );
	swigIntConstant( AV_CODEC_ID_TSCC, "AV_CODEC_ID_TSCC" );
	swigIntConstant( AV_CODEC_ID_ULTI, "AV_CODEC_ID_ULTI" );
	swigIntConstant( AV_CODEC_ID_QDRAW, "AV_CODEC_ID_QDRAW" );
	swigIntConstant( AV_CODEC_ID_VIXL, "AV_CODEC_ID_VIXL" );
	swigIntConstant( AV_CODEC_ID_QPEG, "AV_CODEC_ID_QPEG" );
	swigIntConstant( AV_CODEC_ID_PNG, "AV_CODEC_ID_PNG" );
	swigIntConstant( AV_CODEC_ID_PPM, "AV_CODEC_ID_PPM" );
	swigIntConstant( AV_CODEC_ID_PBM, "AV_CODEC_ID_PBM" );
	swigIntConstant( AV_CODEC_ID_PGM, "AV_CODEC_ID_PGM" );
	swigIntConstant( AV_CODEC_ID_PGMYUV, "AV_CODEC_ID_PGMYUV" );
	swigIntConstant( AV_CODEC_ID_PAM, "AV_CODEC_ID_PAM" );
	swigIntConstant( AV_CODEC_ID_FFVHUFF, "AV_CODEC_ID_FFVHUFF" );
	swigIntConstant( AV_CODEC_ID_RV30, "AV_CODEC_ID_RV30" );
	swigIntConstant( AV_CODEC_ID_RV40, "AV_CODEC_ID_RV40" );
	swigIntConstant( AV_CODEC_ID_VC1, "AV_CODEC_ID_VC1" );
	swigIntConstant( AV_CODEC_ID_WMV3, "AV_CODEC_ID_WMV3" );
	swigIntConstant( AV_CODEC_ID_LOCO, "AV_CODEC_ID_LOCO" );
	swigIntConstant( AV_CODEC_ID_WNV1, "AV_CODEC_ID_WNV1" );
	swigIntConstant( AV_CODEC_ID_AASC, "AV_CODEC_ID_AASC" );
	swigIntConstant( AV_CODEC_ID_INDEO2, "AV_CODEC_ID_INDEO2" );
	swigIntConstant( AV_CODEC_ID_FRAPS, "AV_CODEC_ID_FRAPS" );
	swigIntConstant( AV_CODEC_ID_TRUEMOTION2, "AV_CODEC_ID_TRUEMOTION2" );
	swigIntConstant( AV_CODEC_ID_BMP, "AV_CODEC_ID_BMP" );
	swigIntConstant( AV_CODEC_ID_CSCD, "AV_CODEC_ID_CSCD" );
	swigIntConstant( AV_CODEC_ID_MMVIDEO, "AV_CODEC_ID_MMVIDEO" );
	swigIntConstant( AV_CODEC_ID_ZMBV, "AV_CODEC_ID_ZMBV" );
	swigIntConstant( AV_CODEC_ID_AVS, "AV_CODEC_ID_AVS" );
	swigIntConstant( AV_CODEC_ID_SMACKVIDEO, "AV_CODEC_ID_SMACKVIDEO" );
	swigIntConstant( AV_CODEC_ID_NUV, "AV_CODEC_ID_NUV" );
	swigIntConstant( AV_CODEC_ID_KMVC, "AV_CODEC_ID_KMVC" );
	swigIntConstant( AV_CODEC_ID_FLASHSV, "AV_CODEC_ID_FLASHSV" );
	swigIntConstant( AV_CODEC_ID_CAVS, "AV_CODEC_ID_CAVS" );
	swigIntConstant( AV_CODEC_ID_JPEG2000, "AV_CODEC_ID_JPEG2000" );
	swigIntConstant( AV_CODEC_ID_VMNC, "AV_CODEC_ID_VMNC" );
	swigIntConstant( AV_CODEC_ID_VP5, "AV_CODEC_ID_VP5" );
	swigIntConstant( AV_CODEC_ID_VP6, "AV_CODEC_ID_VP6" );
	swigIntConstant( AV_CODEC_ID_VP6F, "AV_CODEC_ID_VP6F" );
	swigIntConstant( AV_CODEC_ID_TARGA, "AV_CODEC_ID_TARGA" );
	swigIntConstant( AV_CODEC_ID_DSICINVIDEO, "AV_CODEC_ID_DSICINVIDEO" );
	swigIntConstant( AV_CODEC_ID_TIERTEXSEQVIDEO, "AV_CODEC_ID_TIERTEXSEQVIDEO" );
	swigIntConstant( AV_CODEC_ID_TIFF, "AV_CODEC_ID_TIFF" );
	swigIntConstant( AV_CODEC_ID_GIF, "AV_CODEC_ID_GIF" );
	swigIntConstant( AV_CODEC_ID_DXA, "AV_CODEC_ID_DXA" );
	swigIntConstant( AV_CODEC_ID_DNXHD, "AV_CODEC_ID_DNXHD" );
	swigIntConstant( AV_CODEC_ID_THP, "AV_CODEC_ID_THP" );
	swigIntConstant( AV_CODEC_ID_SGI, "AV_CODEC_ID_SGI" );
	swigIntConstant( AV_CODEC_ID_C93, "AV_CODEC_ID_C93" );
	swigIntConstant( AV_CODEC_ID_BETHSOFTVID, "AV_CODEC_ID_BETHSOFTVID" );
	swigIntConstant( AV_CODEC_ID_PTX, "AV_CODEC_ID_PTX" );
	swigIntConstant( AV_CODEC_ID_TXD, "AV_CODEC_ID_TXD" );
	swigIntConstant( AV_CODEC_ID_VP6A, "AV_CODEC_ID_VP6A" );
	swigIntConstant( AV_CODEC_ID_AMV, "AV_CODEC_ID_AMV" );
	swigIntConstant( AV_CODEC_ID_VB, "AV_CODEC_ID_VB" );
	swigIntConstant( AV_CODEC_ID_PCX, "AV_CODEC_ID_PCX" );
	swigIntConstant( AV_CODEC_ID_SUNRAST, "AV_CODEC_ID_SUNRAST" );
	swigIntConstant( AV_CODEC_ID_INDEO4, "AV_CODEC_ID_INDEO4" );
	swigIntConstant( AV_CODEC_ID_INDEO5, "AV_CODEC_ID_INDEO5" );
	swigIntConstant( AV_CODEC_ID_MIMIC, "AV_CODEC_ID_MIMIC" );
	swigIntConstant( AV_CODEC_ID_RL2, "AV_CODEC_ID_RL2" );
	swigIntConstant( AV_CODEC_ID_ESCAPE124, "AV_CODEC_ID_ESCAPE124" );
	swigIntConstant( AV_CODEC_ID_DIRAC, "AV_CODEC_ID_DIRAC" );
	swigIntConstant( AV_CODEC_ID_BFI, "AV_CODEC_ID_BFI" );
	swigIntConstant( AV_CODEC_ID_CMV, "AV_CODEC_ID_CMV" );
	swigIntConstant( AV_CODEC_ID_MOTIONPIXELS, "AV_CODEC_ID_MOTIONPIXELS" );
	swigIntConstant( AV_CODEC_ID_TGV, "AV_CODEC_ID_TGV" );
	swigIntConstant( AV_CODEC_ID_TGQ, "AV_CODEC_ID_TGQ" );
	swigIntConstant( AV_CODEC_ID_TQI, "AV_CODEC_ID_TQI" );
	swigIntConstant( AV_CODEC_ID_AURA, "AV_CODEC_ID_AURA" );
	swigIntConstant( AV_CODEC_ID_AURA2, "AV_CODEC_ID_AURA2" );
	swigIntConstant( AV_CODEC_ID_V210X, "AV_CODEC_ID_V210X" );
	swigIntConstant( AV_CODEC_ID_TMV, "AV_CODEC_ID_TMV" );
	swigIntConstant( AV_CODEC_ID_V210, "AV_CODEC_ID_V210" );
	swigIntConstant( AV_CODEC_ID_DPX, "AV_CODEC_ID_DPX" );
	swigIntConstant( AV_CODEC_ID_MAD, "AV_CODEC_ID_MAD" );
	swigIntConstant( AV_CODEC_ID_FRWU, "AV_CODEC_ID_FRWU" );
	swigIntConstant( AV_CODEC_ID_FLASHSV2, "AV_CODEC_ID_FLASHSV2" );
	swigIntConstant( AV_CODEC_ID_CDGRAPHICS, "AV_CODEC_ID_CDGRAPHICS" );
	swigIntConstant( AV_CODEC_ID_R210, "AV_CODEC_ID_R210" );
	swigIntConstant( AV_CODEC_ID_ANM, "AV_CODEC_ID_ANM" );
	swigIntConstant( AV_CODEC_ID_BINKVIDEO, "AV_CODEC_ID_BINKVIDEO" );
	swigIntConstant( AV_CODEC_ID_IFF_ILBM, "AV_CODEC_ID_IFF_ILBM" );
	swigIntConstant( AV_CODEC_ID_KGV1, "AV_CODEC_ID_KGV1" );
	swigIntConstant( AV_CODEC_ID_YOP, "AV_CODEC_ID_YOP" );
	swigIntConstant( AV_CODEC_ID_VP8, "AV_CODEC_ID_VP8" );
	swigIntConstant( AV_CODEC_ID_PICTOR, "AV_CODEC_ID_PICTOR" );
	swigIntConstant( AV_CODEC_ID_ANSI, "AV_CODEC_ID_ANSI" );
	swigIntConstant( AV_CODEC_ID_A64_MULTI, "AV_CODEC_ID_A64_MULTI" );
	swigIntConstant( AV_CODEC_ID_A64_MULTI5, "AV_CODEC_ID_A64_MULTI5" );
	swigIntConstant( AV_CODEC_ID_R10K, "AV_CODEC_ID_R10K" );
	swigIntConstant( AV_CODEC_ID_MXPEG, "AV_CODEC_ID_MXPEG" );
	swigIntConstant( AV_CODEC_ID_LAGARITH, "AV_CODEC_ID_LAGARITH" );
	swigIntConstant( AV_CODEC_ID_PRORES, "AV_CODEC_ID_PRORES" );
	swigIntConstant( AV_CODEC_ID_JV, "AV_CODEC_ID_JV" );
	swigIntConstant( AV_CODEC_ID_DFA, "AV_CODEC_ID_DFA" );
	swigIntConstant( AV_CODEC_ID_WMV3IMAGE, "AV_CODEC_ID_WMV3IMAGE" );
	swigIntConstant( AV_CODEC_ID_VC1IMAGE, "AV_CODEC_ID_VC1IMAGE" );
	swigIntConstant( AV_CODEC_ID_UTVIDEO, "AV_CODEC_ID_UTVIDEO" );
	swigIntConstant( AV_CODEC_ID_BMV_VIDEO, "AV_CODEC_ID_BMV_VIDEO" );
	swigIntConstant( AV_CODEC_ID_VBLE, "AV_CODEC_ID_VBLE" );
	swigIntConstant( AV_CODEC_ID_DXTORY, "AV_CODEC_ID_DXTORY" );
	swigIntConstant( AV_CODEC_ID_V410, "AV_CODEC_ID_V410" );
	swigIntConstant( AV_CODEC_ID_XWD, "AV_CODEC_ID_XWD" );
	swigIntConstant( AV_CODEC_ID_CDXL, "AV_CODEC_ID_CDXL" );
	swigIntConstant( AV_CODEC_ID_XBM, "AV_CODEC_ID_XBM" );
	swigIntConstant( AV_CODEC_ID_ZEROCODEC, "AV_CODEC_ID_ZEROCODEC" );
	swigIntConstant( AV_CODEC_ID_MSS1, "AV_CODEC_ID_MSS1" );
	swigIntConstant( AV_CODEC_ID_MSA1, "AV_CODEC_ID_MSA1" );
	swigIntConstant( AV_CODEC_ID_TSCC2, "AV_CODEC_ID_TSCC2" );
	swigIntConstant( AV_CODEC_ID_MTS2, "AV_CODEC_ID_MTS2" );
	swigIntConstant( AV_CODEC_ID_CLLC, "AV_CODEC_ID_CLLC" );
	swigIntConstant( AV_CODEC_ID_MSS2, "AV_CODEC_ID_MSS2" );
	swigIntConstant( AV_CODEC_ID_VP9, "AV_CODEC_ID_VP9" );
	swigIntConstant( AV_CODEC_ID_AIC, "AV_CODEC_ID_AIC" );
	swigIntConstant( AV_CODEC_ID_ESCAPE130, "AV_CODEC_ID_ESCAPE130" );
	swigIntConstant( AV_CODEC_ID_G2M, "AV_CODEC_ID_G2M" );
	swigIntConstant( AV_CODEC_ID_WEBP, "AV_CODEC_ID_WEBP" );
	swigIntConstant( AV_CODEC_ID_HNM4_VIDEO, "AV_CODEC_ID_HNM4_VIDEO" );
	swigIntConstant( AV_CODEC_ID_HEVC, "AV_CODEC_ID_HEVC" );
	swigIntConstant( AV_CODEC_ID_FIC, "AV_CODEC_ID_FIC" );
	swigIntConstant( AV_CODEC_ID_ALIAS_PIX, "AV_CODEC_ID_ALIAS_PIX" );
	swigIntConstant( AV_CODEC_ID_BRENDER_PIX, "AV_CODEC_ID_BRENDER_PIX" );
	swigIntConstant( AV_CODEC_ID_PAF_VIDEO, "AV_CODEC_ID_PAF_VIDEO" );
	swigIntConstant( AV_CODEC_ID_EXR, "AV_CODEC_ID_EXR" );
	swigIntConstant( AV_CODEC_ID_VP7, "AV_CODEC_ID_VP7" );
	swigIntConstant( AV_CODEC_ID_SANM, "AV_CODEC_ID_SANM" );
	swigIntConstant( AV_CODEC_ID_SGIRLE, "AV_CODEC_ID_SGIRLE" );
	swigIntConstant( AV_CODEC_ID_MVC1, "AV_CODEC_ID_MVC1" );
	swigIntConstant( AV_CODEC_ID_MVC2, "AV_CODEC_ID_MVC2" );
	swigIntConstant( AV_CODEC_ID_HQX, "AV_CODEC_ID_HQX" );
	swigIntConstant( AV_CODEC_ID_TDSC, "AV_CODEC_ID_TDSC" );
	swigIntConstant( AV_CODEC_ID_HQ_HQA, "AV_CODEC_ID_HQ_HQA" );
	swigIntConstant( AV_CODEC_ID_HAP, "AV_CODEC_ID_HAP" );
	swigIntConstant( AV_CODEC_ID_DDS, "AV_CODEC_ID_DDS" );
	swigIntConstant( AV_CODEC_ID_DXV, "AV_CODEC_ID_DXV" );
	swigIntConstant( AV_CODEC_ID_SCREENPRESSO, "AV_CODEC_ID_SCREENPRESSO" );
	swigIntConstant( AV_CODEC_ID_RSCC, "AV_CODEC_ID_RSCC" );
	swigIntConstant( AV_CODEC_ID_AVS2, "AV_CODEC_ID_AVS2" );
	swigIntConstant( AV_CODEC_ID_Y41P, "AV_CODEC_ID_Y41P" );
	swigIntConstant( AV_CODEC_ID_AVRP, "AV_CODEC_ID_AVRP" );
	swigIntConstant( AV_CODEC_ID_012V, "AV_CODEC_ID_012V" );
	swigIntConstant( AV_CODEC_ID_AVUI, "AV_CODEC_ID_AVUI" );
	swigIntConstant( AV_CODEC_ID_AYUV, "AV_CODEC_ID_AYUV" );
	swigIntConstant( AV_CODEC_ID_TARGA_Y216, "AV_CODEC_ID_TARGA_Y216" );
	swigIntConstant( AV_CODEC_ID_V308, "AV_CODEC_ID_V308" );
	swigIntConstant( AV_CODEC_ID_V408, "AV_CODEC_ID_V408" );
	swigIntConstant( AV_CODEC_ID_YUV4, "AV_CODEC_ID_YUV4" );
	swigIntConstant( AV_CODEC_ID_AVRN, "AV_CODEC_ID_AVRN" );
	swigIntConstant( AV_CODEC_ID_CPIA, "AV_CODEC_ID_CPIA" );
	swigIntConstant( AV_CODEC_ID_XFACE, "AV_CODEC_ID_XFACE" );
	swigIntConstant( AV_CODEC_ID_SNOW, "AV_CODEC_ID_SNOW" );
	swigIntConstant( AV_CODEC_ID_SMVJPEG, "AV_CODEC_ID_SMVJPEG" );
	swigIntConstant( AV_CODEC_ID_APNG, "AV_CODEC_ID_APNG" );
	swigIntConstant( AV_CODEC_ID_DAALA, "AV_CODEC_ID_DAALA" );
	swigIntConstant( AV_CODEC_ID_CFHD, "AV_CODEC_ID_CFHD" );
	swigIntConstant( AV_CODEC_ID_TRUEMOTION2RT, "AV_CODEC_ID_TRUEMOTION2RT" );
	swigIntConstant( AV_CODEC_ID_M101, "AV_CODEC_ID_M101" );
	swigIntConstant( AV_CODEC_ID_MAGICYUV, "AV_CODEC_ID_MAGICYUV" );
	swigIntConstant( AV_CODEC_ID_SHEERVIDEO, "AV_CODEC_ID_SHEERVIDEO" );
	swigIntConstant( AV_CODEC_ID_YLC, "AV_CODEC_ID_YLC" );
	swigIntConstant( AV_CODEC_ID_PSD, "AV_CODEC_ID_PSD" );
	swigIntConstant( AV_CODEC_ID_PIXLET, "AV_CODEC_ID_PIXLET" );
	swigIntConstant( AV_CODEC_ID_SPEEDHQ, "AV_CODEC_ID_SPEEDHQ" );
	swigIntConstant( AV_CODEC_ID_FMVC, "AV_CODEC_ID_FMVC" );
	swigIntConstant( AV_CODEC_ID_SCPR, "AV_CODEC_ID_SCPR" );
	swigIntConstant( AV_CODEC_ID_CLEARVIDEO, "AV_CODEC_ID_CLEARVIDEO" );
	swigIntConstant( AV_CODEC_ID_XPM, "AV_CODEC_ID_XPM" );
	swigIntConstant( AV_CODEC_ID_AV1, "AV_CODEC_ID_AV1" );
	swigIntConstant( AV_CODEC_ID_BITPACKED, "AV_CODEC_ID_BITPACKED" );
	swigIntConstant( AV_CODEC_ID_MSCC, "AV_CODEC_ID_MSCC" );
	swigIntConstant( AV_CODEC_ID_SRGC, "AV_CODEC_ID_SRGC" );
	swigIntConstant( AV_CODEC_ID_SVG, "AV_CODEC_ID_SVG" );
	swigIntConstant( AV_CODEC_ID_GDV, "AV_CODEC_ID_GDV" );
	swigIntConstant( AV_CODEC_ID_FITS, "AV_CODEC_ID_FITS" );
	swigIntConstant( AV_CODEC_ID_IMM4, "AV_CODEC_ID_IMM4" );
	swigIntConstant( AV_CODEC_ID_PROSUMER, "AV_CODEC_ID_PROSUMER" );
	swigIntConstant( AV_CODEC_ID_MWSC, "AV_CODEC_ID_MWSC" );
	swigIntConstant( AV_CODEC_ID_WCMV, "AV_CODEC_ID_WCMV" );
	swigIntConstant( AV_CODEC_ID_RASC, "AV_CODEC_ID_RASC" );
	swigIntConstant( AV_CODEC_ID_HYMT, "AV_CODEC_ID_HYMT" );
	swigIntConstant( AV_CODEC_ID_ARBC, "AV_CODEC_ID_ARBC" );
	swigIntConstant( AV_CODEC_ID_AGM, "AV_CODEC_ID_AGM" );
	swigIntConstant( AV_CODEC_ID_LSCR, "AV_CODEC_ID_LSCR" );
	swigIntConstant( AV_CODEC_ID_VP4, "AV_CODEC_ID_VP4" );
	swigIntConstant( AV_CODEC_ID_FIRST_AUDIO, "AV_CODEC_ID_FIRST_AUDIO" );
	swigIntConstant( AV_CODEC_ID_PCM_S16LE, "AV_CODEC_ID_PCM_S16LE" );
	swigIntConstant( AV_CODEC_ID_PCM_S16BE, "AV_CODEC_ID_PCM_S16BE" );
	swigIntConstant( AV_CODEC_ID_PCM_U16LE, "AV_CODEC_ID_PCM_U16LE" );
	swigIntConstant( AV_CODEC_ID_PCM_U16BE, "AV_CODEC_ID_PCM_U16BE" );
	swigIntConstant( AV_CODEC_ID_PCM_S8, "AV_CODEC_ID_PCM_S8" );
	swigIntConstant( AV_CODEC_ID_PCM_U8, "AV_CODEC_ID_PCM_U8" );
	swigIntConstant( AV_CODEC_ID_PCM_MULAW, "AV_CODEC_ID_PCM_MULAW" );
	swigIntConstant( AV_CODEC_ID_PCM_ALAW, "AV_CODEC_ID_PCM_ALAW" );
	swigIntConstant( AV_CODEC_ID_PCM_S32LE, "AV_CODEC_ID_PCM_S32LE" );
	swigIntConstant( AV_CODEC_ID_PCM_S32BE, "AV_CODEC_ID_PCM_S32BE" );
	swigIntConstant( AV_CODEC_ID_PCM_U32LE, "AV_CODEC_ID_PCM_U32LE" );
	swigIntConstant( AV_CODEC_ID_PCM_U32BE, "AV_CODEC_ID_PCM_U32BE" );
	swigIntConstant( AV_CODEC_ID_PCM_S24LE, "AV_CODEC_ID_PCM_S24LE" );
	swigIntConstant( AV_CODEC_ID_PCM_S24BE, "AV_CODEC_ID_PCM_S24BE" );
	swigIntConstant( AV_CODEC_ID_PCM_U24LE, "AV_CODEC_ID_PCM_U24LE" );
	swigIntConstant( AV_CODEC_ID_PCM_U24BE, "AV_CODEC_ID_PCM_U24BE" );
	swigIntConstant( AV_CODEC_ID_PCM_S24DAUD, "AV_CODEC_ID_PCM_S24DAUD" );
	swigIntConstant( AV_CODEC_ID_PCM_ZORK, "AV_CODEC_ID_PCM_ZORK" );
	swigIntConstant( AV_CODEC_ID_PCM_S16LE_PLANAR, "AV_CODEC_ID_PCM_S16LE_PLANAR" );
	swigIntConstant( AV_CODEC_ID_PCM_DVD, "AV_CODEC_ID_PCM_DVD" );
	swigIntConstant( AV_CODEC_ID_PCM_F32BE, "AV_CODEC_ID_PCM_F32BE" );
	swigIntConstant( AV_CODEC_ID_PCM_F32LE, "AV_CODEC_ID_PCM_F32LE" );
	swigIntConstant( AV_CODEC_ID_PCM_F64BE, "AV_CODEC_ID_PCM_F64BE" );
	swigIntConstant( AV_CODEC_ID_PCM_F64LE, "AV_CODEC_ID_PCM_F64LE" );
	swigIntConstant( AV_CODEC_ID_PCM_BLURAY, "AV_CODEC_ID_PCM_BLURAY" );
	swigIntConstant( AV_CODEC_ID_PCM_LXF, "AV_CODEC_ID_PCM_LXF" );
	swigIntConstant( AV_CODEC_ID_S302M, "AV_CODEC_ID_S302M" );
	swigIntConstant( AV_CODEC_ID_PCM_S8_PLANAR, "AV_CODEC_ID_PCM_S8_PLANAR" );
	swigIntConstant( AV_CODEC_ID_PCM_S24LE_PLANAR, "AV_CODEC_ID_PCM_S24LE_PLANAR" );
	swigIntConstant( AV_CODEC_ID_PCM_S32LE_PLANAR, "AV_CODEC_ID_PCM_S32LE_PLANAR" );
	swigIntConstant( AV_CODEC_ID_PCM_S16BE_PLANAR, "AV_CODEC_ID_PCM_S16BE_PLANAR" );
	swigIntConstant( AV_CODEC_ID_PCM_S64LE, "AV_CODEC_ID_PCM_S64LE" );
	swigIntConstant( AV_CODEC_ID_PCM_S64BE, "AV_CODEC_ID_PCM_S64BE" );
	swigIntConstant( AV_CODEC_ID_PCM_F16LE, "AV_CODEC_ID_PCM_F16LE" );
	swigIntConstant( AV_CODEC_ID_PCM_F24LE, "AV_CODEC_ID_PCM_F24LE" );
	swigIntConstant( AV_CODEC_ID_PCM_VIDC, "AV_CODEC_ID_PCM_VIDC" );
	swigIntConstant( AV_CODEC_ID_ADPCM_IMA_QT, "AV_CODEC_ID_ADPCM_IMA_QT" );
	swigIntConstant( AV_CODEC_ID_ADPCM_IMA_WAV, "AV_CODEC_ID_ADPCM_IMA_WAV" );
	swigIntConstant( AV_CODEC_ID_ADPCM_IMA_DK3, "AV_CODEC_ID_ADPCM_IMA_DK3" );
	swigIntConstant( AV_CODEC_ID_ADPCM_IMA_DK4, "AV_CODEC_ID_ADPCM_IMA_DK4" );
	swigIntConstant( AV_CODEC_ID_ADPCM_IMA_WS, "AV_CODEC_ID_ADPCM_IMA_WS" );
	swigIntConstant( AV_CODEC_ID_ADPCM_IMA_SMJPEG, "AV_CODEC_ID_ADPCM_IMA_SMJPEG" );
	swigIntConstant( AV_CODEC_ID_ADPCM_MS, "AV_CODEC_ID_ADPCM_MS" );
	swigIntConstant( AV_CODEC_ID_ADPCM_4XM, "AV_CODEC_ID_ADPCM_4XM" );
	swigIntConstant( AV_CODEC_ID_ADPCM_XA, "AV_CODEC_ID_ADPCM_XA" );
	swigIntConstant( AV_CODEC_ID_ADPCM_ADX, "AV_CODEC_ID_ADPCM_ADX" );
	swigIntConstant( AV_CODEC_ID_ADPCM_EA, "AV_CODEC_ID_ADPCM_EA" );
	swigIntConstant( AV_CODEC_ID_ADPCM_G726, "AV_CODEC_ID_ADPCM_G726" );
	swigIntConstant( AV_CODEC_ID_ADPCM_CT, "AV_CODEC_ID_ADPCM_CT" );
	swigIntConstant( AV_CODEC_ID_ADPCM_SWF, "AV_CODEC_ID_ADPCM_SWF" );
	swigIntConstant( AV_CODEC_ID_ADPCM_YAMAHA, "AV_CODEC_ID_ADPCM_YAMAHA" );
	swigIntConstant( AV_CODEC_ID_ADPCM_SBPRO_4, "AV_CODEC_ID_ADPCM_SBPRO_4" );
	swigIntConstant( AV_CODEC_ID_ADPCM_SBPRO_3, "AV_CODEC_ID_ADPCM_SBPRO_3" );
	swigIntConstant( AV_CODEC_ID_ADPCM_SBPRO_2, "AV_CODEC_ID_ADPCM_SBPRO_2" );
	swigIntConstant( AV_CODEC_ID_ADPCM_THP, "AV_CODEC_ID_ADPCM_THP" );
	swigIntConstant( AV_CODEC_ID_ADPCM_IMA_AMV, "AV_CODEC_ID_ADPCM_IMA_AMV" );
	swigIntConstant( AV_CODEC_ID_ADPCM_EA_R1, "AV_CODEC_ID_ADPCM_EA_R1" );
	swigIntConstant( AV_CODEC_ID_ADPCM_EA_R3, "AV_CODEC_ID_ADPCM_EA_R3" );
	swigIntConstant( AV_CODEC_ID_ADPCM_EA_R2, "AV_CODEC_ID_ADPCM_EA_R2" );
	swigIntConstant( AV_CODEC_ID_ADPCM_IMA_EA_SEAD, "AV_CODEC_ID_ADPCM_IMA_EA_SEAD" );
	swigIntConstant( AV_CODEC_ID_ADPCM_IMA_EA_EACS, "AV_CODEC_ID_ADPCM_IMA_EA_EACS" );
	swigIntConstant( AV_CODEC_ID_ADPCM_EA_XAS, "AV_CODEC_ID_ADPCM_EA_XAS" );
	swigIntConstant( AV_CODEC_ID_ADPCM_EA_MAXIS_XA, "AV_CODEC_ID_ADPCM_EA_MAXIS_XA" );
	swigIntConstant( AV_CODEC_ID_ADPCM_IMA_ISS, "AV_CODEC_ID_ADPCM_IMA_ISS" );
	swigIntConstant( AV_CODEC_ID_ADPCM_G722, "AV_CODEC_ID_ADPCM_G722" );
	swigIntConstant( AV_CODEC_ID_ADPCM_IMA_APC, "AV_CODEC_ID_ADPCM_IMA_APC" );
	swigIntConstant( AV_CODEC_ID_ADPCM_VIMA, "AV_CODEC_ID_ADPCM_VIMA" );
	swigIntConstant( AV_CODEC_ID_ADPCM_AFC, "AV_CODEC_ID_ADPCM_AFC" );
	swigIntConstant( AV_CODEC_ID_ADPCM_IMA_OKI, "AV_CODEC_ID_ADPCM_IMA_OKI" );
	swigIntConstant( AV_CODEC_ID_ADPCM_DTK, "AV_CODEC_ID_ADPCM_DTK" );
	swigIntConstant( AV_CODEC_ID_ADPCM_IMA_RAD, "AV_CODEC_ID_ADPCM_IMA_RAD" );
	swigIntConstant( AV_CODEC_ID_ADPCM_G726LE, "AV_CODEC_ID_ADPCM_G726LE" );
	swigIntConstant( AV_CODEC_ID_ADPCM_THP_LE, "AV_CODEC_ID_ADPCM_THP_LE" );
	swigIntConstant( AV_CODEC_ID_ADPCM_PSX, "AV_CODEC_ID_ADPCM_PSX" );
	swigIntConstant( AV_CODEC_ID_ADPCM_AICA, "AV_CODEC_ID_ADPCM_AICA" );
	swigIntConstant( AV_CODEC_ID_ADPCM_IMA_DAT4, "AV_CODEC_ID_ADPCM_IMA_DAT4" );
	swigIntConstant( AV_CODEC_ID_ADPCM_MTAF, "AV_CODEC_ID_ADPCM_MTAF" );
	swigIntConstant( AV_CODEC_ID_ADPCM_AGM, "AV_CODEC_ID_ADPCM_AGM" );
	swigIntConstant( AV_CODEC_ID_AMR_NB, "AV_CODEC_ID_AMR_NB" );
	swigIntConstant( AV_CODEC_ID_AMR_WB, "AV_CODEC_ID_AMR_WB" );
	swigIntConstant( AV_CODEC_ID_RA_144, "AV_CODEC_ID_RA_144" );
	swigIntConstant( AV_CODEC_ID_RA_288, "AV_CODEC_ID_RA_288" );
	swigIntConstant( AV_CODEC_ID_ROQ_DPCM, "AV_CODEC_ID_ROQ_DPCM" );
	swigIntConstant( AV_CODEC_ID_INTERPLAY_DPCM, "AV_CODEC_ID_INTERPLAY_DPCM" );
	swigIntConstant( AV_CODEC_ID_XAN_DPCM, "AV_CODEC_ID_XAN_DPCM" );
	swigIntConstant( AV_CODEC_ID_SOL_DPCM, "AV_CODEC_ID_SOL_DPCM" );
	swigIntConstant( AV_CODEC_ID_SDX2_DPCM, "AV_CODEC_ID_SDX2_DPCM" );
	swigIntConstant( AV_CODEC_ID_GREMLIN_DPCM, "AV_CODEC_ID_GREMLIN_DPCM" );
	swigIntConstant( AV_CODEC_ID_MP2, "AV_CODEC_ID_MP2" );
	swigIntConstant( AV_CODEC_ID_MP3, "AV_CODEC_ID_MP3" );
	swigIntConstant( AV_CODEC_ID_AAC, "AV_CODEC_ID_AAC" );
	swigIntConstant( AV_CODEC_ID_AC3, "AV_CODEC_ID_AC3" );
	swigIntConstant( AV_CODEC_ID_DTS, "AV_CODEC_ID_DTS" );
	swigIntConstant( AV_CODEC_ID_VORBIS, "AV_CODEC_ID_VORBIS" );
	swigIntConstant( AV_CODEC_ID_DVAUDIO, "AV_CODEC_ID_DVAUDIO" );
	swigIntConstant( AV_CODEC_ID_WMAV1, "AV_CODEC_ID_WMAV1" );
	swigIntConstant( AV_CODEC_ID_WMAV2, "AV_CODEC_ID_WMAV2" );
	swigIntConstant( AV_CODEC_ID_MACE3, "AV_CODEC_ID_MACE3" );
	swigIntConstant( AV_CODEC_ID_MACE6, "AV_CODEC_ID_MACE6" );
	swigIntConstant( AV_CODEC_ID_VMDAUDIO, "AV_CODEC_ID_VMDAUDIO" );
	swigIntConstant( AV_CODEC_ID_FLAC, "AV_CODEC_ID_FLAC" );
	swigIntConstant( AV_CODEC_ID_MP3ADU, "AV_CODEC_ID_MP3ADU" );
	swigIntConstant( AV_CODEC_ID_MP3ON4, "AV_CODEC_ID_MP3ON4" );
	swigIntConstant( AV_CODEC_ID_SHORTEN, "AV_CODEC_ID_SHORTEN" );
	swigIntConstant( AV_CODEC_ID_ALAC, "AV_CODEC_ID_ALAC" );
	swigIntConstant( AV_CODEC_ID_WESTWOOD_SND1, "AV_CODEC_ID_WESTWOOD_SND1" );
	swigIntConstant( AV_CODEC_ID_GSM, "AV_CODEC_ID_GSM" );
	swigIntConstant( AV_CODEC_ID_QDM2, "AV_CODEC_ID_QDM2" );
	swigIntConstant( AV_CODEC_ID_COOK, "AV_CODEC_ID_COOK" );
	swigIntConstant( AV_CODEC_ID_TRUESPEECH, "AV_CODEC_ID_TRUESPEECH" );
	swigIntConstant( AV_CODEC_ID_TTA, "AV_CODEC_ID_TTA" );
	swigIntConstant( AV_CODEC_ID_SMACKAUDIO, "AV_CODEC_ID_SMACKAUDIO" );
	swigIntConstant( AV_CODEC_ID_QCELP, "AV_CODEC_ID_QCELP" );
	swigIntConstant( AV_CODEC_ID_WAVPACK, "AV_CODEC_ID_WAVPACK" );
	swigIntConstant( AV_CODEC_ID_DSICINAUDIO, "AV_CODEC_ID_DSICINAUDIO" );
	swigIntConstant( AV_CODEC_ID_IMC, "AV_CODEC_ID_IMC" );
	swigIntConstant( AV_CODEC_ID_MUSEPACK7, "AV_CODEC_ID_MUSEPACK7" );
	swigIntConstant( AV_CODEC_ID_MLP, "AV_CODEC_ID_MLP" );
	swigIntConstant( AV_CODEC_ID_GSM_MS, "AV_CODEC_ID_GSM_MS" );
	swigIntConstant( AV_CODEC_ID_ATRAC3, "AV_CODEC_ID_ATRAC3" );
	swigIntConstant( AV_CODEC_ID_APE, "AV_CODEC_ID_APE" );
	swigIntConstant( AV_CODEC_ID_NELLYMOSER, "AV_CODEC_ID_NELLYMOSER" );
	swigIntConstant( AV_CODEC_ID_MUSEPACK8, "AV_CODEC_ID_MUSEPACK8" );
	swigIntConstant( AV_CODEC_ID_SPEEX, "AV_CODEC_ID_SPEEX" );
	swigIntConstant( AV_CODEC_ID_WMAVOICE, "AV_CODEC_ID_WMAVOICE" );
	swigIntConstant( AV_CODEC_ID_WMAPRO, "AV_CODEC_ID_WMAPRO" );
	swigIntConstant( AV_CODEC_ID_WMALOSSLESS, "AV_CODEC_ID_WMALOSSLESS" );
	swigIntConstant( AV_CODEC_ID_ATRAC3P, "AV_CODEC_ID_ATRAC3P" );
	swigIntConstant( AV_CODEC_ID_EAC3, "AV_CODEC_ID_EAC3" );
	swigIntConstant( AV_CODEC_ID_SIPR, "AV_CODEC_ID_SIPR" );
	swigIntConstant( AV_CODEC_ID_MP1, "AV_CODEC_ID_MP1" );
	swigIntConstant( AV_CODEC_ID_TWINVQ, "AV_CODEC_ID_TWINVQ" );
	swigIntConstant( AV_CODEC_ID_TRUEHD, "AV_CODEC_ID_TRUEHD" );
	swigIntConstant( AV_CODEC_ID_MP4ALS, "AV_CODEC_ID_MP4ALS" );
	swigIntConstant( AV_CODEC_ID_ATRAC1, "AV_CODEC_ID_ATRAC1" );
	swigIntConstant( AV_CODEC_ID_BINKAUDIO_RDFT, "AV_CODEC_ID_BINKAUDIO_RDFT" );
	swigIntConstant( AV_CODEC_ID_BINKAUDIO_DCT, "AV_CODEC_ID_BINKAUDIO_DCT" );
	swigIntConstant( AV_CODEC_ID_AAC_LATM, "AV_CODEC_ID_AAC_LATM" );
	swigIntConstant( AV_CODEC_ID_QDMC, "AV_CODEC_ID_QDMC" );
	swigIntConstant( AV_CODEC_ID_CELT, "AV_CODEC_ID_CELT" );
	swigIntConstant( AV_CODEC_ID_G723_1, "AV_CODEC_ID_G723_1" );
	swigIntConstant( AV_CODEC_ID_G729, "AV_CODEC_ID_G729" );
	swigIntConstant( AV_CODEC_ID_8SVX_EXP, "AV_CODEC_ID_8SVX_EXP" );
	swigIntConstant( AV_CODEC_ID_8SVX_FIB, "AV_CODEC_ID_8SVX_FIB" );
	swigIntConstant( AV_CODEC_ID_BMV_AUDIO, "AV_CODEC_ID_BMV_AUDIO" );
	swigIntConstant( AV_CODEC_ID_RALF, "AV_CODEC_ID_RALF" );
	swigIntConstant( AV_CODEC_ID_IAC, "AV_CODEC_ID_IAC" );
	swigIntConstant( AV_CODEC_ID_ILBC, "AV_CODEC_ID_ILBC" );
	swigIntConstant( AV_CODEC_ID_OPUS, "AV_CODEC_ID_OPUS" );
	swigIntConstant( AV_CODEC_ID_COMFORT_NOISE, "AV_CODEC_ID_COMFORT_NOISE" );
	swigIntConstant( AV_CODEC_ID_TAK, "AV_CODEC_ID_TAK" );
	swigIntConstant( AV_CODEC_ID_METASOUND, "AV_CODEC_ID_METASOUND" );
	swigIntConstant( AV_CODEC_ID_PAF_AUDIO, "AV_CODEC_ID_PAF_AUDIO" );
	swigIntConstant( AV_CODEC_ID_ON2AVC, "AV_CODEC_ID_ON2AVC" );
	swigIntConstant( AV_CODEC_ID_DSS_SP, "AV_CODEC_ID_DSS_SP" );
	swigIntConstant( AV_CODEC_ID_CODEC2, "AV_CODEC_ID_CODEC2" );
	swigIntConstant( AV_CODEC_ID_FFWAVESYNTH, "AV_CODEC_ID_FFWAVESYNTH" );
	swigIntConstant( AV_CODEC_ID_SONIC, "AV_CODEC_ID_SONIC" );
	swigIntConstant( AV_CODEC_ID_SONIC_LS, "AV_CODEC_ID_SONIC_LS" );
	swigIntConstant( AV_CODEC_ID_EVRC, "AV_CODEC_ID_EVRC" );
	swigIntConstant( AV_CODEC_ID_SMV, "AV_CODEC_ID_SMV" );
	swigIntConstant( AV_CODEC_ID_DSD_LSBF, "AV_CODEC_ID_DSD_LSBF" );
	swigIntConstant( AV_CODEC_ID_DSD_MSBF, "AV_CODEC_ID_DSD_MSBF" );
	swigIntConstant( AV_CODEC_ID_DSD_LSBF_PLANAR, "AV_CODEC_ID_DSD_LSBF_PLANAR" );
	swigIntConstant( AV_CODEC_ID_DSD_MSBF_PLANAR, "AV_CODEC_ID_DSD_MSBF_PLANAR" );
	swigIntConstant( AV_CODEC_ID_4GV, "AV_CODEC_ID_4GV" );
	swigIntConstant( AV_CODEC_ID_INTERPLAY_ACM, "AV_CODEC_ID_INTERPLAY_ACM" );
	swigIntConstant( AV_CODEC_ID_XMA1, "AV_CODEC_ID_XMA1" );
	swigIntConstant( AV_CODEC_ID_XMA2, "AV_CODEC_ID_XMA2" );
	swigIntConstant( AV_CODEC_ID_DST, "AV_CODEC_ID_DST" );
	swigIntConstant( AV_CODEC_ID_ATRAC3AL, "AV_CODEC_ID_ATRAC3AL" );
	swigIntConstant( AV_CODEC_ID_ATRAC3PAL, "AV_CODEC_ID_ATRAC3PAL" );
	swigIntConstant( AV_CODEC_ID_DOLBY_E, "AV_CODEC_ID_DOLBY_E" );
	swigIntConstant( AV_CODEC_ID_APTX, "AV_CODEC_ID_APTX" );
	swigIntConstant( AV_CODEC_ID_APTX_HD, "AV_CODEC_ID_APTX_HD" );
	swigIntConstant( AV_CODEC_ID_SBC, "AV_CODEC_ID_SBC" );
	swigIntConstant( AV_CODEC_ID_ATRAC9, "AV_CODEC_ID_ATRAC9" );
	swigIntConstant( AV_CODEC_ID_HCOM, "AV_CODEC_ID_HCOM" );
	swigIntConstant( AV_CODEC_ID_FIRST_SUBTITLE, "AV_CODEC_ID_FIRST_SUBTITLE" );
	swigIntConstant( AV_CODEC_ID_DVD_SUBTITLE, "AV_CODEC_ID_DVD_SUBTITLE" );
	swigIntConstant( AV_CODEC_ID_DVB_SUBTITLE, "AV_CODEC_ID_DVB_SUBTITLE" );
	swigIntConstant( AV_CODEC_ID_TEXT, "AV_CODEC_ID_TEXT" );
	swigIntConstant( AV_CODEC_ID_XSUB, "AV_CODEC_ID_XSUB" );
	swigIntConstant( AV_CODEC_ID_SSA, "AV_CODEC_ID_SSA" );
	swigIntConstant( AV_CODEC_ID_MOV_TEXT, "AV_CODEC_ID_MOV_TEXT" );
	swigIntConstant( AV_CODEC_ID_HDMV_PGS_SUBTITLE, "AV_CODEC_ID_HDMV_PGS_SUBTITLE" );
	swigIntConstant( AV_CODEC_ID_DVB_TELETEXT, "AV_CODEC_ID_DVB_TELETEXT" );
	swigIntConstant( AV_CODEC_ID_SRT, "AV_CODEC_ID_SRT" );
	swigIntConstant( AV_CODEC_ID_MICRODVD, "AV_CODEC_ID_MICRODVD" );
	swigIntConstant( AV_CODEC_ID_EIA_608, "AV_CODEC_ID_EIA_608" );
	swigIntConstant( AV_CODEC_ID_JACOSUB, "AV_CODEC_ID_JACOSUB" );
	swigIntConstant( AV_CODEC_ID_SAMI, "AV_CODEC_ID_SAMI" );
	swigIntConstant( AV_CODEC_ID_REALTEXT, "AV_CODEC_ID_REALTEXT" );
	swigIntConstant( AV_CODEC_ID_STL, "AV_CODEC_ID_STL" );
	swigIntConstant( AV_CODEC_ID_SUBVIEWER1, "AV_CODEC_ID_SUBVIEWER1" );
	swigIntConstant( AV_CODEC_ID_SUBVIEWER, "AV_CODEC_ID_SUBVIEWER" );
	swigIntConstant( AV_CODEC_ID_SUBRIP, "AV_CODEC_ID_SUBRIP" );
	swigIntConstant( AV_CODEC_ID_WEBVTT, "AV_CODEC_ID_WEBVTT" );
	swigIntConstant( AV_CODEC_ID_MPL2, "AV_CODEC_ID_MPL2" );
	swigIntConstant( AV_CODEC_ID_VPLAYER, "AV_CODEC_ID_VPLAYER" );
	swigIntConstant( AV_CODEC_ID_PJS, "AV_CODEC_ID_PJS" );
	swigIntConstant( AV_CODEC_ID_ASS, "AV_CODEC_ID_ASS" );
	swigIntConstant( AV_CODEC_ID_HDMV_TEXT_SUBTITLE, "AV_CODEC_ID_HDMV_TEXT_SUBTITLE" );
	swigIntConstant( AV_CODEC_ID_TTML, "AV_CODEC_ID_TTML" );
	swigIntConstant( AV_CODEC_ID_ARIB_CAPTION, "AV_CODEC_ID_ARIB_CAPTION" );
	swigIntConstant( AV_CODEC_ID_FIRST_UNKNOWN, "AV_CODEC_ID_FIRST_UNKNOWN" );
	swigIntConstant( AV_CODEC_ID_TTF, "AV_CODEC_ID_TTF" );
	swigIntConstant( AV_CODEC_ID_SCTE_35, "AV_CODEC_ID_SCTE_35" );
	swigIntConstant( AV_CODEC_ID_BINTEXT, "AV_CODEC_ID_BINTEXT" );
	swigIntConstant( AV_CODEC_ID_XBIN, "AV_CODEC_ID_XBIN" );
	swigIntConstant( AV_CODEC_ID_IDF, "AV_CODEC_ID_IDF" );
	swigIntConstant( AV_CODEC_ID_OTF, "AV_CODEC_ID_OTF" );
	swigIntConstant( AV_CODEC_ID_SMPTE_KLV, "AV_CODEC_ID_SMPTE_KLV" );
	swigIntConstant( AV_CODEC_ID_DVD_NAV, "AV_CODEC_ID_DVD_NAV" );
	swigIntConstant( AV_CODEC_ID_TIMED_ID3, "AV_CODEC_ID_TIMED_ID3" );
	swigIntConstant( AV_CODEC_ID_BIN_DATA, "AV_CODEC_ID_BIN_DATA" );
	swigIntConstant( AV_CODEC_ID_PROBE, "AV_CODEC_ID_PROBE" );
	swigIntConstant( AV_CODEC_ID_MPEG2TS, "AV_CODEC_ID_MPEG2TS" );
	swigIntConstant( AV_CODEC_ID_MPEG4SYSTEMS, "AV_CODEC_ID_MPEG4SYSTEMS" );
	swigIntConstant( AV_CODEC_ID_FFMETADATA, "AV_CODEC_ID_FFMETADATA" );
	swigIntConstant( AV_CODEC_ID_WRAPPED_AVFRAME, "AV_CODEC_ID_WRAPPED_AVFRAME" );
	swigIntConstant( AVDISCARD_NONE, "AVDISCARD_NONE" );
	swigIntConstant( AVDISCARD_DEFAULT, "AVDISCARD_DEFAULT" );
	swigIntConstant( AVDISCARD_NONREF, "AVDISCARD_NONREF" );
	swigIntConstant( AVDISCARD_BIDIR, "AVDISCARD_BIDIR" );
	swigIntConstant( AVDISCARD_NONINTRA, "AVDISCARD_NONINTRA" );
	swigIntConstant( AVDISCARD_NONKEY, "AVDISCARD_NONKEY" );
	swigIntConstant( AVDISCARD_ALL, "AVDISCARD_ALL" );
	swigIntConstant( AV_AUDIO_SERVICE_TYPE_MAIN, "AV_AUDIO_SERVICE_TYPE_MAIN" );
	swigIntConstant( AV_AUDIO_SERVICE_TYPE_EFFECTS, "AV_AUDIO_SERVICE_TYPE_EFFECTS" );
	swigIntConstant( AV_AUDIO_SERVICE_TYPE_VISUALLY_IMPAIRED, "AV_AUDIO_SERVICE_TYPE_VISUALLY_IMPAIRED" );
	swigIntConstant( AV_AUDIO_SERVICE_TYPE_HEARING_IMPAIRED, "AV_AUDIO_SERVICE_TYPE_HEARING_IMPAIRED" );
	swigIntConstant( AV_AUDIO_SERVICE_TYPE_DIALOGUE, "AV_AUDIO_SERVICE_TYPE_DIALOGUE" );
	swigIntConstant( AV_AUDIO_SERVICE_TYPE_COMMENTARY, "AV_AUDIO_SERVICE_TYPE_COMMENTARY" );
	swigIntConstant( AV_AUDIO_SERVICE_TYPE_EMERGENCY, "AV_AUDIO_SERVICE_TYPE_EMERGENCY" );
	swigIntConstant( AV_AUDIO_SERVICE_TYPE_VOICE_OVER, "AV_AUDIO_SERVICE_TYPE_VOICE_OVER" );
	swigIntConstant( AV_AUDIO_SERVICE_TYPE_KARAOKE, "AV_AUDIO_SERVICE_TYPE_KARAOKE" );
	swigIntConstant( AV_AUDIO_SERVICE_TYPE_NB, "AV_AUDIO_SERVICE_TYPE_NB" );
	swigIntConstant( AV_PKT_DATA_PALETTE, "AV_PKT_DATA_PALETTE" );
	swigIntConstant( AV_PKT_DATA_NEW_EXTRADATA, "AV_PKT_DATA_NEW_EXTRADATA" );
	swigIntConstant( AV_PKT_DATA_PARAM_CHANGE, "AV_PKT_DATA_PARAM_CHANGE" );
	swigIntConstant( AV_PKT_DATA_H263_MB_INFO, "AV_PKT_DATA_H263_MB_INFO" );
	swigIntConstant( AV_PKT_DATA_REPLAYGAIN, "AV_PKT_DATA_REPLAYGAIN" );
	swigIntConstant( AV_PKT_DATA_DISPLAYMATRIX, "AV_PKT_DATA_DISPLAYMATRIX" );
	swigIntConstant( AV_PKT_DATA_STEREO3D, "AV_PKT_DATA_STEREO3D" );
	swigIntConstant( AV_PKT_DATA_AUDIO_SERVICE_TYPE, "AV_PKT_DATA_AUDIO_SERVICE_TYPE" );
	swigIntConstant( AV_PKT_DATA_QUALITY_STATS, "AV_PKT_DATA_QUALITY_STATS" );
	swigIntConstant( AV_PKT_DATA_FALLBACK_TRACK, "AV_PKT_DATA_FALLBACK_TRACK" );
	swigIntConstant( AV_PKT_DATA_CPB_PROPERTIES, "AV_PKT_DATA_CPB_PROPERTIES" );
	swigIntConstant( AV_PKT_DATA_SKIP_SAMPLES, "AV_PKT_DATA_SKIP_SAMPLES" );
	swigIntConstant( AV_PKT_DATA_JP_DUALMONO, "AV_PKT_DATA_JP_DUALMONO" );
	swigIntConstant( AV_PKT_DATA_STRINGS_METADATA, "AV_PKT_DATA_STRINGS_METADATA" );
	swigIntConstant( AV_PKT_DATA_SUBTITLE_POSITION, "AV_PKT_DATA_SUBTITLE_POSITION" );
	swigIntConstant( AV_PKT_DATA_MATROSKA_BLOCKADDITIONAL, "AV_PKT_DATA_MATROSKA_BLOCKADDITIONAL" );
	swigIntConstant( AV_PKT_DATA_WEBVTT_IDENTIFIER, "AV_PKT_DATA_WEBVTT_IDENTIFIER" );
	swigIntConstant( AV_PKT_DATA_WEBVTT_SETTINGS, "AV_PKT_DATA_WEBVTT_SETTINGS" );
	swigIntConstant( AV_PKT_DATA_METADATA_UPDATE, "AV_PKT_DATA_METADATA_UPDATE" );
	swigIntConstant( AV_PKT_DATA_MPEGTS_STREAM_ID, "AV_PKT_DATA_MPEGTS_STREAM_ID" );
	swigIntConstant( AV_PKT_DATA_MASTERING_DISPLAY_METADATA, "AV_PKT_DATA_MASTERING_DISPLAY_METADATA" );
	swigIntConstant( AV_PKT_DATA_SPHERICAL, "AV_PKT_DATA_SPHERICAL" );
	swigIntConstant( AV_PKT_DATA_CONTENT_LIGHT_LEVEL, "AV_PKT_DATA_CONTENT_LIGHT_LEVEL" );
	swigIntConstant( AV_PKT_DATA_A53_CC, "AV_PKT_DATA_A53_CC" );
	swigIntConstant( AV_PKT_DATA_ENCRYPTION_INIT_INFO, "AV_PKT_DATA_ENCRYPTION_INIT_INFO" );
	swigIntConstant( AV_PKT_DATA_ENCRYPTION_INFO, "AV_PKT_DATA_ENCRYPTION_INFO" );
	swigIntConstant( AV_PKT_DATA_AFD, "AV_PKT_DATA_AFD" );
	swigIntConstant( AV_PKT_DATA_NB, "AV_PKT_DATA_NB" );
	swigIntConstant( AV_SIDE_DATA_PARAM_CHANGE_CHANNEL_COUNT, "AV_SIDE_DATA_PARAM_CHANGE_CHANNEL_COUNT" );
	swigIntConstant( AV_SIDE_DATA_PARAM_CHANGE_CHANNEL_LAYOUT, "AV_SIDE_DATA_PARAM_CHANGE_CHANNEL_LAYOUT" );
	swigIntConstant( AV_SIDE_DATA_PARAM_CHANGE_SAMPLE_RATE, "AV_SIDE_DATA_PARAM_CHANGE_SAMPLE_RATE" );
	swigIntConstant( AV_SIDE_DATA_PARAM_CHANGE_DIMENSIONS, "AV_SIDE_DATA_PARAM_CHANGE_DIMENSIONS" );
	swigIntConstant( AV_FIELD_UNKNOWN, "AV_FIELD_UNKNOWN" );
	swigIntConstant( AV_FIELD_PROGRESSIVE, "AV_FIELD_PROGRESSIVE" );
	swigIntConstant( AV_FIELD_TT, "AV_FIELD_TT" );
	swigIntConstant( AV_FIELD_BB, "AV_FIELD_BB" );
	swigIntConstant( AV_FIELD_TB, "AV_FIELD_TB" );
	swigIntConstant( AV_FIELD_BT, "AV_FIELD_BT" );
	swigIntConstant( AV_CODEC_HW_CONFIG_METHOD_HW_DEVICE_CTX, "AV_CODEC_HW_CONFIG_METHOD_HW_DEVICE_CTX" );
	swigIntConstant( AV_CODEC_HW_CONFIG_METHOD_HW_FRAMES_CTX, "AV_CODEC_HW_CONFIG_METHOD_HW_FRAMES_CTX" );
	swigIntConstant( AV_CODEC_HW_CONFIG_METHOD_INTERNAL, "AV_CODEC_HW_CONFIG_METHOD_INTERNAL" );
	swigIntConstant( AV_CODEC_HW_CONFIG_METHOD_AD_HOC, "AV_CODEC_HW_CONFIG_METHOD_AD_HOC" );
	swigIntConstant( SUBTITLE_NONE, "SUBTITLE_NONE" );
	swigIntConstant( SUBTITLE_BITMAP, "SUBTITLE_BITMAP" );
	swigIntConstant( SUBTITLE_TEXT, "SUBTITLE_TEXT" );
	swigIntConstant( SUBTITLE_ASS, "SUBTITLE_ASS" );
	swigIntConstant( AV_PICTURE_STRUCTURE_UNKNOWN, "AV_PICTURE_STRUCTURE_UNKNOWN" );
	swigIntConstant( AV_PICTURE_STRUCTURE_TOP_FIELD, "AV_PICTURE_STRUCTURE_TOP_FIELD" );
	swigIntConstant( AV_PICTURE_STRUCTURE_BOTTOM_FIELD, "AV_PICTURE_STRUCTURE_BOTTOM_FIELD" );
	swigIntConstant( AV_PICTURE_STRUCTURE_FRAME, "AV_PICTURE_STRUCTURE_FRAME" );
	swigIntConstant( AV_PIX_FMT_NONE, "AV_PIX_FMT_NONE" );
	swigIntConstant( AV_PIX_FMT_YUV420P, "AV_PIX_FMT_YUV420P" );
	swigIntConstant( AV_PIX_FMT_YUYV422, "AV_PIX_FMT_YUYV422" );
	swigIntConstant( AV_PIX_FMT_RGB24, "AV_PIX_FMT_RGB24" );
	swigIntConstant( AV_PIX_FMT_BGR24, "AV_PIX_FMT_BGR24" );
	swigIntConstant( AV_PIX_FMT_YUV422P, "AV_PIX_FMT_YUV422P" );
	swigIntConstant( AV_PIX_FMT_YUV444P, "AV_PIX_FMT_YUV444P" );
	swigIntConstant( AV_PIX_FMT_YUV410P, "AV_PIX_FMT_YUV410P" );
	swigIntConstant( AV_PIX_FMT_YUV411P, "AV_PIX_FMT_YUV411P" );
	swigIntConstant( AV_PIX_FMT_GRAY8, "AV_PIX_FMT_GRAY8" );
	swigIntConstant( AV_PIX_FMT_MONOWHITE, "AV_PIX_FMT_MONOWHITE" );
	swigIntConstant( AV_PIX_FMT_MONOBLACK, "AV_PIX_FMT_MONOBLACK" );
	swigIntConstant( AV_PIX_FMT_PAL8, "AV_PIX_FMT_PAL8" );
	swigIntConstant( AV_PIX_FMT_YUVJ420P, "AV_PIX_FMT_YUVJ420P" );
	swigIntConstant( AV_PIX_FMT_YUVJ422P, "AV_PIX_FMT_YUVJ422P" );
	swigIntConstant( AV_PIX_FMT_YUVJ444P, "AV_PIX_FMT_YUVJ444P" );
	swigIntConstant( AV_PIX_FMT_UYVY422, "AV_PIX_FMT_UYVY422" );
	swigIntConstant( AV_PIX_FMT_UYYVYY411, "AV_PIX_FMT_UYYVYY411" );
	swigIntConstant( AV_PIX_FMT_BGR8, "AV_PIX_FMT_BGR8" );
	swigIntConstant( AV_PIX_FMT_BGR4, "AV_PIX_FMT_BGR4" );
	swigIntConstant( AV_PIX_FMT_BGR4_BYTE, "AV_PIX_FMT_BGR4_BYTE" );
	swigIntConstant( AV_PIX_FMT_RGB8, "AV_PIX_FMT_RGB8" );
	swigIntConstant( AV_PIX_FMT_RGB4, "AV_PIX_FMT_RGB4" );
	swigIntConstant( AV_PIX_FMT_RGB4_BYTE, "AV_PIX_FMT_RGB4_BYTE" );
	swigIntConstant( AV_PIX_FMT_NV12, "AV_PIX_FMT_NV12" );
	swigIntConstant( AV_PIX_FMT_NV21, "AV_PIX_FMT_NV21" );
	swigIntConstant( AV_PIX_FMT_ARGB, "AV_PIX_FMT_ARGB" );
	swigIntConstant( AV_PIX_FMT_RGBA, "AV_PIX_FMT_RGBA" );
	swigIntConstant( AV_PIX_FMT_ABGR, "AV_PIX_FMT_ABGR" );
	swigIntConstant( AV_PIX_FMT_BGRA, "AV_PIX_FMT_BGRA" );
	swigIntConstant( AV_PIX_FMT_GRAY16BE, "AV_PIX_FMT_GRAY16BE" );
	swigIntConstant( AV_PIX_FMT_GRAY16LE, "AV_PIX_FMT_GRAY16LE" );
	swigIntConstant( AV_PIX_FMT_YUV440P, "AV_PIX_FMT_YUV440P" );
	swigIntConstant( AV_PIX_FMT_YUVJ440P, "AV_PIX_FMT_YUVJ440P" );
	swigIntConstant( AV_PIX_FMT_YUVA420P, "AV_PIX_FMT_YUVA420P" );
	swigIntConstant( AV_PIX_FMT_RGB48BE, "AV_PIX_FMT_RGB48BE" );
	swigIntConstant( AV_PIX_FMT_RGB48LE, "AV_PIX_FMT_RGB48LE" );
	swigIntConstant( AV_PIX_FMT_RGB565BE, "AV_PIX_FMT_RGB565BE" );
	swigIntConstant( AV_PIX_FMT_RGB565LE, "AV_PIX_FMT_RGB565LE" );
	swigIntConstant( AV_PIX_FMT_RGB555BE, "AV_PIX_FMT_RGB555BE" );
	swigIntConstant( AV_PIX_FMT_RGB555LE, "AV_PIX_FMT_RGB555LE" );
	swigIntConstant( AV_PIX_FMT_BGR565BE, "AV_PIX_FMT_BGR565BE" );
	swigIntConstant( AV_PIX_FMT_BGR565LE, "AV_PIX_FMT_BGR565LE" );
	swigIntConstant( AV_PIX_FMT_BGR555BE, "AV_PIX_FMT_BGR555BE" );
	swigIntConstant( AV_PIX_FMT_BGR555LE, "AV_PIX_FMT_BGR555LE" );
	swigIntConstant( AV_PIX_FMT_VAAPI, "AV_PIX_FMT_VAAPI" );
	swigIntConstant( AV_PIX_FMT_YUV420P16LE, "AV_PIX_FMT_YUV420P16LE" );
	swigIntConstant( AV_PIX_FMT_YUV420P16BE, "AV_PIX_FMT_YUV420P16BE" );
	swigIntConstant( AV_PIX_FMT_YUV422P16LE, "AV_PIX_FMT_YUV422P16LE" );
	swigIntConstant( AV_PIX_FMT_YUV422P16BE, "AV_PIX_FMT_YUV422P16BE" );
	swigIntConstant( AV_PIX_FMT_YUV444P16LE, "AV_PIX_FMT_YUV444P16LE" );
	swigIntConstant( AV_PIX_FMT_YUV444P16BE, "AV_PIX_FMT_YUV444P16BE" );
	swigIntConstant( AV_PIX_FMT_DXVA2_VLD, "AV_PIX_FMT_DXVA2_VLD" );
	swigIntConstant( AV_PIX_FMT_RGB444LE, "AV_PIX_FMT_RGB444LE" );
	swigIntConstant( AV_PIX_FMT_RGB444BE, "AV_PIX_FMT_RGB444BE" );
	swigIntConstant( AV_PIX_FMT_BGR444LE, "AV_PIX_FMT_BGR444LE" );
	swigIntConstant( AV_PIX_FMT_BGR444BE, "AV_PIX_FMT_BGR444BE" );
	swigIntConstant( AV_PIX_FMT_YA8, "AV_PIX_FMT_YA8" );
	swigIntConstant( AV_PIX_FMT_Y400A, "AV_PIX_FMT_Y400A" );
	swigIntConstant( AV_PIX_FMT_GRAY8A, "AV_PIX_FMT_GRAY8A" );
	swigIntConstant( AV_PIX_FMT_BGR48BE, "AV_PIX_FMT_BGR48BE" );
	swigIntConstant( AV_PIX_FMT_BGR48LE, "AV_PIX_FMT_BGR48LE" );
	swigIntConstant( AV_PIX_FMT_YUV420P9BE, "AV_PIX_FMT_YUV420P9BE" );
	swigIntConstant( AV_PIX_FMT_YUV420P9LE, "AV_PIX_FMT_YUV420P9LE" );
	swigIntConstant( AV_PIX_FMT_YUV420P10BE, "AV_PIX_FMT_YUV420P10BE" );
	swigIntConstant( AV_PIX_FMT_YUV420P10LE, "AV_PIX_FMT_YUV420P10LE" );
	swigIntConstant( AV_PIX_FMT_YUV422P10BE, "AV_PIX_FMT_YUV422P10BE" );
	swigIntConstant( AV_PIX_FMT_YUV422P10LE, "AV_PIX_FMT_YUV422P10LE" );
	swigIntConstant( AV_PIX_FMT_YUV444P9BE, "AV_PIX_FMT_YUV444P9BE" );
	swigIntConstant( AV_PIX_FMT_YUV444P9LE, "AV_PIX_FMT_YUV444P9LE" );
	swigIntConstant( AV_PIX_FMT_YUV444P10BE, "AV_PIX_FMT_YUV444P10BE" );
	swigIntConstant( AV_PIX_FMT_YUV444P10LE, "AV_PIX_FMT_YUV444P10LE" );
	swigIntConstant( AV_PIX_FMT_YUV422P9BE, "AV_PIX_FMT_YUV422P9BE" );
	swigIntConstant( AV_PIX_FMT_YUV422P9LE, "AV_PIX_FMT_YUV422P9LE" );
	swigIntConstant( AV_PIX_FMT_GBRP, "AV_PIX_FMT_GBRP" );
	swigIntConstant( AV_PIX_FMT_GBR24P, "AV_PIX_FMT_GBR24P" );
	swigIntConstant( AV_PIX_FMT_GBRP9BE, "AV_PIX_FMT_GBRP9BE" );
	swigIntConstant( AV_PIX_FMT_GBRP9LE, "AV_PIX_FMT_GBRP9LE" );
	swigIntConstant( AV_PIX_FMT_GBRP10BE, "AV_PIX_FMT_GBRP10BE" );
	swigIntConstant( AV_PIX_FMT_GBRP10LE, "AV_PIX_FMT_GBRP10LE" );
	swigIntConstant( AV_PIX_FMT_GBRP16BE, "AV_PIX_FMT_GBRP16BE" );
	swigIntConstant( AV_PIX_FMT_GBRP16LE, "AV_PIX_FMT_GBRP16LE" );
	swigIntConstant( AV_PIX_FMT_YUVA422P, "AV_PIX_FMT_YUVA422P" );
	swigIntConstant( AV_PIX_FMT_YUVA444P, "AV_PIX_FMT_YUVA444P" );
	swigIntConstant( AV_PIX_FMT_YUVA420P9BE, "AV_PIX_FMT_YUVA420P9BE" );
	swigIntConstant( AV_PIX_FMT_YUVA420P9LE, "AV_PIX_FMT_YUVA420P9LE" );
	swigIntConstant( AV_PIX_FMT_YUVA422P9BE, "AV_PIX_FMT_YUVA422P9BE" );
	swigIntConstant( AV_PIX_FMT_YUVA422P9LE, "AV_PIX_FMT_YUVA422P9LE" );
	swigIntConstant( AV_PIX_FMT_YUVA444P9BE, "AV_PIX_FMT_YUVA444P9BE" );
	swigIntConstant( AV_PIX_FMT_YUVA444P9LE, "AV_PIX_FMT_YUVA444P9LE" );
	swigIntConstant( AV_PIX_FMT_YUVA420P10BE, "AV_PIX_FMT_YUVA420P10BE" );
	swigIntConstant( AV_PIX_FMT_YUVA420P10LE, "AV_PIX_FMT_YUVA420P10LE" );
	swigIntConstant( AV_PIX_FMT_YUVA422P10BE, "AV_PIX_FMT_YUVA422P10BE" );
	swigIntConstant( AV_PIX_FMT_YUVA422P10LE, "AV_PIX_FMT_YUVA422P10LE" );
	swigIntConstant( AV_PIX_FMT_YUVA444P10BE, "AV_PIX_FMT_YUVA444P10BE" );
	swigIntConstant( AV_PIX_FMT_YUVA444P10LE, "AV_PIX_FMT_YUVA444P10LE" );
	swigIntConstant( AV_PIX_FMT_YUVA420P16BE, "AV_PIX_FMT_YUVA420P16BE" );
	swigIntConstant( AV_PIX_FMT_YUVA420P16LE, "AV_PIX_FMT_YUVA420P16LE" );
	swigIntConstant( AV_PIX_FMT_YUVA422P16BE, "AV_PIX_FMT_YUVA422P16BE" );
	swigIntConstant( AV_PIX_FMT_YUVA422P16LE, "AV_PIX_FMT_YUVA422P16LE" );
	swigIntConstant( AV_PIX_FMT_YUVA444P16BE, "AV_PIX_FMT_YUVA444P16BE" );
	swigIntConstant( AV_PIX_FMT_YUVA444P16LE, "AV_PIX_FMT_YUVA444P16LE" );
	swigIntConstant( AV_PIX_FMT_VDPAU, "AV_PIX_FMT_VDPAU" );
	swigIntConstant( AV_PIX_FMT_XYZ12LE, "AV_PIX_FMT_XYZ12LE" );
	swigIntConstant( AV_PIX_FMT_XYZ12BE, "AV_PIX_FMT_XYZ12BE" );
	swigIntConstant( AV_PIX_FMT_NV16, "AV_PIX_FMT_NV16" );
	swigIntConstant( AV_PIX_FMT_NV20LE, "AV_PIX_FMT_NV20LE" );
	swigIntConstant( AV_PIX_FMT_NV20BE, "AV_PIX_FMT_NV20BE" );
	swigIntConstant( AV_PIX_FMT_RGBA64BE, "AV_PIX_FMT_RGBA64BE" );
	swigIntConstant( AV_PIX_FMT_RGBA64LE, "AV_PIX_FMT_RGBA64LE" );
	swigIntConstant( AV_PIX_FMT_BGRA64BE, "AV_PIX_FMT_BGRA64BE" );
	swigIntConstant( AV_PIX_FMT_BGRA64LE, "AV_PIX_FMT_BGRA64LE" );
	swigIntConstant( AV_PIX_FMT_YVYU422, "AV_PIX_FMT_YVYU422" );
	swigIntConstant( AV_PIX_FMT_YA16BE, "AV_PIX_FMT_YA16BE" );
	swigIntConstant( AV_PIX_FMT_YA16LE, "AV_PIX_FMT_YA16LE" );
	swigIntConstant( AV_PIX_FMT_GBRAP, "AV_PIX_FMT_GBRAP" );
	swigIntConstant( AV_PIX_FMT_GBRAP16BE, "AV_PIX_FMT_GBRAP16BE" );
	swigIntConstant( AV_PIX_FMT_GBRAP16LE, "AV_PIX_FMT_GBRAP16LE" );
	swigIntConstant( AV_PIX_FMT_QSV, "AV_PIX_FMT_QSV" );
	swigIntConstant( AV_PIX_FMT_MMAL, "AV_PIX_FMT_MMAL" );
	swigIntConstant( AV_PIX_FMT_D3D11VA_VLD, "AV_PIX_FMT_D3D11VA_VLD" );
	swigIntConstant( AV_PIX_FMT_CUDA, "AV_PIX_FMT_CUDA" );
	swigIntConstant( AV_PIX_FMT_0RGB, "AV_PIX_FMT_0RGB" );
	swigIntConstant( AV_PIX_FMT_RGB0, "AV_PIX_FMT_RGB0" );
	swigIntConstant( AV_PIX_FMT_0BGR, "AV_PIX_FMT_0BGR" );
	swigIntConstant( AV_PIX_FMT_BGR0, "AV_PIX_FMT_BGR0" );
	swigIntConstant( AV_PIX_FMT_YUV420P12BE, "AV_PIX_FMT_YUV420P12BE" );
	swigIntConstant( AV_PIX_FMT_YUV420P12LE, "AV_PIX_FMT_YUV420P12LE" );
	swigIntConstant( AV_PIX_FMT_YUV420P14BE, "AV_PIX_FMT_YUV420P14BE" );
	swigIntConstant( AV_PIX_FMT_YUV420P14LE, "AV_PIX_FMT_YUV420P14LE" );
	swigIntConstant( AV_PIX_FMT_YUV422P12BE, "AV_PIX_FMT_YUV422P12BE" );
	swigIntConstant( AV_PIX_FMT_YUV422P12LE, "AV_PIX_FMT_YUV422P12LE" );
	swigIntConstant( AV_PIX_FMT_YUV422P14BE, "AV_PIX_FMT_YUV422P14BE" );
	swigIntConstant( AV_PIX_FMT_YUV422P14LE, "AV_PIX_FMT_YUV422P14LE" );
	swigIntConstant( AV_PIX_FMT_YUV444P12BE, "AV_PIX_FMT_YUV444P12BE" );
	swigIntConstant( AV_PIX_FMT_YUV444P12LE, "AV_PIX_FMT_YUV444P12LE" );
	swigIntConstant( AV_PIX_FMT_YUV444P14BE, "AV_PIX_FMT_YUV444P14BE" );
	swigIntConstant( AV_PIX_FMT_YUV444P14LE, "AV_PIX_FMT_YUV444P14LE" );
	swigIntConstant( AV_PIX_FMT_GBRP12BE, "AV_PIX_FMT_GBRP12BE" );
	swigIntConstant( AV_PIX_FMT_GBRP12LE, "AV_PIX_FMT_GBRP12LE" );
	swigIntConstant( AV_PIX_FMT_GBRP14BE, "AV_PIX_FMT_GBRP14BE" );
	swigIntConstant( AV_PIX_FMT_GBRP14LE, "AV_PIX_FMT_GBRP14LE" );
	swigIntConstant( AV_PIX_FMT_YUVJ411P, "AV_PIX_FMT_YUVJ411P" );
	swigIntConstant( AV_PIX_FMT_BAYER_BGGR8, "AV_PIX_FMT_BAYER_BGGR8" );
	swigIntConstant( AV_PIX_FMT_BAYER_RGGB8, "AV_PIX_FMT_BAYER_RGGB8" );
	swigIntConstant( AV_PIX_FMT_BAYER_GBRG8, "AV_PIX_FMT_BAYER_GBRG8" );
	swigIntConstant( AV_PIX_FMT_BAYER_GRBG8, "AV_PIX_FMT_BAYER_GRBG8" );
	swigIntConstant( AV_PIX_FMT_BAYER_BGGR16LE, "AV_PIX_FMT_BAYER_BGGR16LE" );
	swigIntConstant( AV_PIX_FMT_BAYER_BGGR16BE, "AV_PIX_FMT_BAYER_BGGR16BE" );
	swigIntConstant( AV_PIX_FMT_BAYER_RGGB16LE, "AV_PIX_FMT_BAYER_RGGB16LE" );
	swigIntConstant( AV_PIX_FMT_BAYER_RGGB16BE, "AV_PIX_FMT_BAYER_RGGB16BE" );
	swigIntConstant( AV_PIX_FMT_BAYER_GBRG16LE, "AV_PIX_FMT_BAYER_GBRG16LE" );
	swigIntConstant( AV_PIX_FMT_BAYER_GBRG16BE, "AV_PIX_FMT_BAYER_GBRG16BE" );
	swigIntConstant( AV_PIX_FMT_BAYER_GRBG16LE, "AV_PIX_FMT_BAYER_GRBG16LE" );
	swigIntConstant( AV_PIX_FMT_BAYER_GRBG16BE, "AV_PIX_FMT_BAYER_GRBG16BE" );
	swigIntConstant( AV_PIX_FMT_XVMC, "AV_PIX_FMT_XVMC" );
	swigIntConstant( AV_PIX_FMT_YUV440P10LE, "AV_PIX_FMT_YUV440P10LE" );
	swigIntConstant( AV_PIX_FMT_YUV440P10BE, "AV_PIX_FMT_YUV440P10BE" );
	swigIntConstant( AV_PIX_FMT_YUV440P12LE, "AV_PIX_FMT_YUV440P12LE" );
	swigIntConstant( AV_PIX_FMT_YUV440P12BE, "AV_PIX_FMT_YUV440P12BE" );
	swigIntConstant( AV_PIX_FMT_AYUV64LE, "AV_PIX_FMT_AYUV64LE" );
	swigIntConstant( AV_PIX_FMT_AYUV64BE, "AV_PIX_FMT_AYUV64BE" );
	swigIntConstant( AV_PIX_FMT_VIDEOTOOLBOX, "AV_PIX_FMT_VIDEOTOOLBOX" );
	swigIntConstant( AV_PIX_FMT_P010LE, "AV_PIX_FMT_P010LE" );
	swigIntConstant( AV_PIX_FMT_P010BE, "AV_PIX_FMT_P010BE" );
	swigIntConstant( AV_PIX_FMT_GBRAP12BE, "AV_PIX_FMT_GBRAP12BE" );
	swigIntConstant( AV_PIX_FMT_GBRAP12LE, "AV_PIX_FMT_GBRAP12LE" );
	swigIntConstant( AV_PIX_FMT_GBRAP10BE, "AV_PIX_FMT_GBRAP10BE" );
	swigIntConstant( AV_PIX_FMT_GBRAP10LE, "AV_PIX_FMT_GBRAP10LE" );
	swigIntConstant( AV_PIX_FMT_MEDIACODEC, "AV_PIX_FMT_MEDIACODEC" );
	swigIntConstant( AV_PIX_FMT_GRAY12BE, "AV_PIX_FMT_GRAY12BE" );
	swigIntConstant( AV_PIX_FMT_GRAY12LE, "AV_PIX_FMT_GRAY12LE" );
	swigIntConstant( AV_PIX_FMT_GRAY10BE, "AV_PIX_FMT_GRAY10BE" );
	swigIntConstant( AV_PIX_FMT_GRAY10LE, "AV_PIX_FMT_GRAY10LE" );
	swigIntConstant( AV_PIX_FMT_P016LE, "AV_PIX_FMT_P016LE" );
	swigIntConstant( AV_PIX_FMT_P016BE, "AV_PIX_FMT_P016BE" );
	swigIntConstant( AV_PIX_FMT_D3D11, "AV_PIX_FMT_D3D11" );
	swigIntConstant( AV_PIX_FMT_GRAY9BE, "AV_PIX_FMT_GRAY9BE" );
	swigIntConstant( AV_PIX_FMT_GRAY9LE, "AV_PIX_FMT_GRAY9LE" );
	swigIntConstant( AV_PIX_FMT_GBRPF32BE, "AV_PIX_FMT_GBRPF32BE" );
	swigIntConstant( AV_PIX_FMT_GBRPF32LE, "AV_PIX_FMT_GBRPF32LE" );
	swigIntConstant( AV_PIX_FMT_GBRAPF32BE, "AV_PIX_FMT_GBRAPF32BE" );
	swigIntConstant( AV_PIX_FMT_GBRAPF32LE, "AV_PIX_FMT_GBRAPF32LE" );
	swigIntConstant( AV_PIX_FMT_DRM_PRIME, "AV_PIX_FMT_DRM_PRIME" );
	swigIntConstant( AV_PIX_FMT_OPENCL, "AV_PIX_FMT_OPENCL" );
	swigIntConstant( AV_PIX_FMT_GRAY14BE, "AV_PIX_FMT_GRAY14BE" );
	swigIntConstant( AV_PIX_FMT_GRAY14LE, "AV_PIX_FMT_GRAY14LE" );
	swigIntConstant( AV_PIX_FMT_GRAYF32BE, "AV_PIX_FMT_GRAYF32BE" );
	swigIntConstant( AV_PIX_FMT_GRAYF32LE, "AV_PIX_FMT_GRAYF32LE" );
	swigIntConstant( AV_PIX_FMT_YUVA422P12BE, "AV_PIX_FMT_YUVA422P12BE" );
	swigIntConstant( AV_PIX_FMT_YUVA422P12LE, "AV_PIX_FMT_YUVA422P12LE" );
	swigIntConstant( AV_PIX_FMT_YUVA444P12BE, "AV_PIX_FMT_YUVA444P12BE" );
	swigIntConstant( AV_PIX_FMT_YUVA444P12LE, "AV_PIX_FMT_YUVA444P12LE" );
	swigIntConstant( AV_PIX_FMT_NV24, "AV_PIX_FMT_NV24" );
	swigIntConstant( AV_PIX_FMT_NV42, "AV_PIX_FMT_NV42" );
	swigIntConstant( AV_PIX_FMT_NB, "AV_PIX_FMT_NB" );
	swigIntConstant( AVCOL_PRI_RESERVED0, "AVCOL_PRI_RESERVED0" );
	swigIntConstant( AVCOL_PRI_BT709, "AVCOL_PRI_BT709" );
	swigIntConstant( AVCOL_PRI_UNSPECIFIED, "AVCOL_PRI_UNSPECIFIED" );
	swigIntConstant( AVCOL_PRI_RESERVED, "AVCOL_PRI_RESERVED" );
	swigIntConstant( AVCOL_PRI_BT470M, "AVCOL_PRI_BT470M" );
	swigIntConstant( AVCOL_PRI_BT470BG, "AVCOL_PRI_BT470BG" );
	swigIntConstant( AVCOL_PRI_SMPTE170M, "AVCOL_PRI_SMPTE170M" );
	swigIntConstant( AVCOL_PRI_SMPTE240M, "AVCOL_PRI_SMPTE240M" );
	swigIntConstant( AVCOL_PRI_FILM, "AVCOL_PRI_FILM" );
	swigIntConstant( AVCOL_PRI_BT2020, "AVCOL_PRI_BT2020" );
	swigIntConstant( AVCOL_PRI_SMPTE428, "AVCOL_PRI_SMPTE428" );
	swigIntConstant( AVCOL_PRI_SMPTEST428_1, "AVCOL_PRI_SMPTEST428_1" );
	swigIntConstant( AVCOL_PRI_SMPTE431, "AVCOL_PRI_SMPTE431" );
	swigIntConstant( AVCOL_PRI_SMPTE432, "AVCOL_PRI_SMPTE432" );
	swigIntConstant( AVCOL_PRI_JEDEC_P22, "AVCOL_PRI_JEDEC_P22" );
	swigIntConstant( AVCOL_PRI_NB, "AVCOL_PRI_NB" );
	swigIntConstant( AVCOL_TRC_RESERVED0, "AVCOL_TRC_RESERVED0" );
	swigIntConstant( AVCOL_TRC_BT709, "AVCOL_TRC_BT709" );
	swigIntConstant( AVCOL_TRC_UNSPECIFIED, "AVCOL_TRC_UNSPECIFIED" );
	swigIntConstant( AVCOL_TRC_RESERVED, "AVCOL_TRC_RESERVED" );
	swigIntConstant( AVCOL_TRC_GAMMA22, "AVCOL_TRC_GAMMA22" );
	swigIntConstant( AVCOL_TRC_GAMMA28, "AVCOL_TRC_GAMMA28" );
	swigIntConstant( AVCOL_TRC_SMPTE170M, "AVCOL_TRC_SMPTE170M" );
	swigIntConstant( AVCOL_TRC_SMPTE240M, "AVCOL_TRC_SMPTE240M" );
	swigIntConstant( AVCOL_TRC_LINEAR, "AVCOL_TRC_LINEAR" );
	swigIntConstant( AVCOL_TRC_LOG, "AVCOL_TRC_LOG" );
	swigIntConstant( AVCOL_TRC_LOG_SQRT, "AVCOL_TRC_LOG_SQRT" );
	swigIntConstant( AVCOL_TRC_IEC61966_2_4, "AVCOL_TRC_IEC61966_2_4" );
	swigIntConstant( AVCOL_TRC_BT1361_ECG, "AVCOL_TRC_BT1361_ECG" );
	swigIntConstant( AVCOL_TRC_IEC61966_2_1, "AVCOL_TRC_IEC61966_2_1" );
	swigIntConstant( AVCOL_TRC_BT2020_10, "AVCOL_TRC_BT2020_10" );
	swigIntConstant( AVCOL_TRC_BT2020_12, "AVCOL_TRC_BT2020_12" );
	swigIntConstant( AVCOL_TRC_SMPTE2084, "AVCOL_TRC_SMPTE2084" );
	swigIntConstant( AVCOL_TRC_SMPTEST2084, "AVCOL_TRC_SMPTEST2084" );
	swigIntConstant( AVCOL_TRC_SMPTE428, "AVCOL_TRC_SMPTE428" );
	swigIntConstant( AVCOL_TRC_SMPTEST428_1, "AVCOL_TRC_SMPTEST428_1" );
	swigIntConstant( AVCOL_TRC_ARIB_STD_B67, "AVCOL_TRC_ARIB_STD_B67" );
	swigIntConstant( AVCOL_TRC_NB, "AVCOL_TRC_NB" );
	swigIntConstant( AVCOL_SPC_RGB, "AVCOL_SPC_RGB" );
	swigIntConstant( AVCOL_SPC_BT709, "AVCOL_SPC_BT709" );
	swigIntConstant( AVCOL_SPC_UNSPECIFIED, "AVCOL_SPC_UNSPECIFIED" );
	swigIntConstant( AVCOL_SPC_RESERVED, "AVCOL_SPC_RESERVED" );
	swigIntConstant( AVCOL_SPC_FCC, "AVCOL_SPC_FCC" );
	swigIntConstant( AVCOL_SPC_BT470BG, "AVCOL_SPC_BT470BG" );
	swigIntConstant( AVCOL_SPC_SMPTE170M, "AVCOL_SPC_SMPTE170M" );
	swigIntConstant( AVCOL_SPC_SMPTE240M, "AVCOL_SPC_SMPTE240M" );
	swigIntConstant( AVCOL_SPC_YCGCO, "AVCOL_SPC_YCGCO" );
	swigIntConstant( AVCOL_SPC_YCOCG, "AVCOL_SPC_YCOCG" );
	swigIntConstant( AVCOL_SPC_BT2020_NCL, "AVCOL_SPC_BT2020_NCL" );
	swigIntConstant( AVCOL_SPC_BT2020_CL, "AVCOL_SPC_BT2020_CL" );
	swigIntConstant( AVCOL_SPC_SMPTE2085, "AVCOL_SPC_SMPTE2085" );
	swigIntConstant( AVCOL_SPC_CHROMA_DERIVED_NCL, "AVCOL_SPC_CHROMA_DERIVED_NCL" );
	swigIntConstant( AVCOL_SPC_CHROMA_DERIVED_CL, "AVCOL_SPC_CHROMA_DERIVED_CL" );
	swigIntConstant( AVCOL_SPC_ICTCP, "AVCOL_SPC_ICTCP" );
	swigIntConstant( AVCOL_SPC_NB, "AVCOL_SPC_NB" );
	swigIntConstant( AVCOL_RANGE_UNSPECIFIED, "AVCOL_RANGE_UNSPECIFIED" );
	swigIntConstant( AVCOL_RANGE_MPEG, "AVCOL_RANGE_MPEG" );
	swigIntConstant( AVCOL_RANGE_JPEG, "AVCOL_RANGE_JPEG" );
	swigIntConstant( AVCOL_RANGE_NB, "AVCOL_RANGE_NB" );
	swigIntConstant( AVCHROMA_LOC_UNSPECIFIED, "AVCHROMA_LOC_UNSPECIFIED" );
	swigIntConstant( AVCHROMA_LOC_LEFT, "AVCHROMA_LOC_LEFT" );
	swigIntConstant( AVCHROMA_LOC_CENTER, "AVCHROMA_LOC_CENTER" );
	swigIntConstant( AVCHROMA_LOC_TOPLEFT, "AVCHROMA_LOC_TOPLEFT" );
	swigIntConstant( AVCHROMA_LOC_TOP, "AVCHROMA_LOC_TOP" );
	swigIntConstant( AVCHROMA_LOC_BOTTOMLEFT, "AVCHROMA_LOC_BOTTOMLEFT" );
	swigIntConstant( AVCHROMA_LOC_BOTTOM, "AVCHROMA_LOC_BOTTOM" );
	swigIntConstant( AVCHROMA_LOC_NB, "AVCHROMA_LOC_NB" );

	swigNewline();

	swigComment("-------===< structs >===--------\n");

	swigComment("AVCodecDescriptor\n");
	printf( "begin-structure AVCodecDescriptor\n" );
	swigStructField( "AVCodecDescriptor-name", offsetof( struct AVCodecDescriptor, name ), sizeof( char const * ) );
	swigStructField( "AVCodecDescriptor-id", offsetof( struct AVCodecDescriptor, id ), sizeof( enum AVCodecID ) );
	swigStructField( "AVCodecDescriptor-props", offsetof( struct AVCodecDescriptor, props ), sizeof( int ) );
	swigStructField( "AVCodecDescriptor-mime_types", offsetof( struct AVCodecDescriptor, mime_types ), sizeof( char const *const * ) );
	swigStructField( "AVCodecDescriptor-type", offsetof( struct AVCodecDescriptor, type ), sizeof( enum AVMediaType ) );
	swigStructField( "AVCodecDescriptor-long_name", offsetof( struct AVCodecDescriptor, long_name ), sizeof( char const * ) );
	swigStructField( "AVCodecDescriptor-profiles", offsetof( struct AVCodecDescriptor, profiles ), sizeof( struct AVProfile const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct AVCodecDescriptor ) );

	swigComment("RcOverride\n");
	printf( "begin-structure RcOverride\n" );
	swigStructField( "RcOverride-quality_factor", offsetof( struct RcOverride, quality_factor ), sizeof( float ) );
	swigStructField( "RcOverride-qscale", offsetof( struct RcOverride, qscale ), sizeof( int ) );
	swigStructField( "RcOverride-start_frame", offsetof( struct RcOverride, start_frame ), sizeof( int ) );
	swigStructField( "RcOverride-end_frame", offsetof( struct RcOverride, end_frame ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( struct RcOverride ) );

	swigComment("AVPanScan\n");
	printf( "begin-structure AVPanScan\n" );
	swigStructField( "AVPanScan-position", offsetof( struct AVPanScan, position ), sizeof( int16_t [3][2] ) );
	swigStructField( "AVPanScan-id", offsetof( struct AVPanScan, id ), sizeof( int ) );
	swigStructField( "AVPanScan-height", offsetof( struct AVPanScan, height ), sizeof( int ) );
	swigStructField( "AVPanScan-width", offsetof( struct AVPanScan, width ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( struct AVPanScan ) );

	swigComment("AVCPBProperties\n");
	printf( "begin-structure AVCPBProperties\n" );
	swigStructField( "AVCPBProperties-buffer_size", offsetof( struct AVCPBProperties, buffer_size ), sizeof( int ) );
	swigStructField( "AVCPBProperties-vbv_delay", offsetof( struct AVCPBProperties, vbv_delay ), sizeof( uint64_t ) );
	swigStructField( "AVCPBProperties-max_bitrate", offsetof( struct AVCPBProperties, max_bitrate ), sizeof( int64_t ) );
	swigStructField( "AVCPBProperties-min_bitrate", offsetof( struct AVCPBProperties, min_bitrate ), sizeof( int64_t ) );
	swigStructField( "AVCPBProperties-avg_bitrate", offsetof( struct AVCPBProperties, avg_bitrate ), sizeof( int64_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct AVCPBProperties ) );

	swigComment("AVPacketSideData\n");
	printf( "begin-structure AVPacketSideData\n" );
	swigStructField( "AVPacketSideData-data", offsetof( struct AVPacketSideData, data ), sizeof( uint8_t * ) );
	swigStructField( "AVPacketSideData-size", offsetof( struct AVPacketSideData, size ), sizeof( int ) );
	swigStructField( "AVPacketSideData-type", offsetof( struct AVPacketSideData, type ), sizeof( enum AVPacketSideDataType ) );
	printf( "drop %zu end-structure\n", sizeof( struct AVPacketSideData ) );

	swigComment("AVPacket\n");
	printf( "begin-structure AVPacket\n" );
	swigStructField( "AVPacket-side_data", offsetof( struct AVPacket, side_data ), sizeof( AVPacketSideData * ) );
	swigStructField( "AVPacket-data", offsetof( struct AVPacket, data ), sizeof( uint8_t * ) );
	swigStructField( "AVPacket-dts", offsetof( struct AVPacket, dts ), sizeof( int64_t ) );
	swigStructField( "AVPacket-duration", offsetof( struct AVPacket, duration ), sizeof( int64_t ) );
	swigStructField( "AVPacket-buf", offsetof( struct AVPacket, buf ), sizeof( AVBufferRef * ) );
	swigStructField( "AVPacket-side_data_elems", offsetof( struct AVPacket, side_data_elems ), sizeof( int ) );
	swigStructField( "AVPacket-size", offsetof( struct AVPacket, size ), sizeof( int ) );
	swigStructField( "AVPacket-pts", offsetof( struct AVPacket, pts ), sizeof( int64_t ) );
	swigStructField( "AVPacket-flags", offsetof( struct AVPacket, flags ), sizeof( int ) );
	swigStructField( "AVPacket-stream_index", offsetof( struct AVPacket, stream_index ), sizeof( int ) );
	swigStructField( "AVPacket-pos", offsetof( struct AVPacket, pos ), sizeof( int64_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct AVPacket ) );

	swigComment("AVCodecContext\n");
	printf( "begin-structure AVCodecContext\n" );
	swigStructField( "AVCodecContext-workaround_bugs", offsetof( struct AVCodecContext, workaround_bugs ), sizeof( int ) );
	swigStructField( "AVCodecContext-height", offsetof( struct AVCodecContext, height ), sizeof( int ) );
	swigStructField( "AVCodecContext-qmax", offsetof( struct AVCodecContext, qmax ), sizeof( int ) );
	swigStructField( "AVCodecContext-max_qdiff", offsetof( struct AVCodecContext, max_qdiff ), sizeof( int ) );
	swigStructField( "AVCodecContext-nsse_weight", offsetof( struct AVCodecContext, nsse_weight ), sizeof( int ) );
	swigStructField( "AVCodecContext-stats_out", offsetof( struct AVCodecContext, stats_out ), sizeof( char * ) );
	swigStructField( "AVCodecContext-request_sample_fmt", offsetof( struct AVCodecContext, request_sample_fmt ), sizeof( enum AVSampleFormat ) );
	swigStructField( "AVCodecContext-sample_fmt", offsetof( struct AVCodecContext, sample_fmt ), sizeof( enum AVSampleFormat ) );
	swigStructField( "AVCodecContext-frame_size", offsetof( struct AVCodecContext, frame_size ), sizeof( int ) );
	swigStructField( "AVCodecContext-stats_in", offsetof( struct AVCodecContext, stats_in ), sizeof( char * ) );
	swigStructField( "AVCodecContext-pkt_timebase", offsetof( struct AVCodecContext, pkt_timebase ), sizeof( AVRational ) );
	swigStructField( "AVCodecContext-qblur", offsetof( struct AVCodecContext, qblur ), sizeof( float ) );
	swigStructField( "AVCodecContext-profile", offsetof( struct AVCodecContext, profile ), sizeof( int ) );
	swigStructField( "AVCodecContext-chroma_sample_location", offsetof( struct AVCodecContext, chroma_sample_location ), sizeof( enum AVChromaLocation ) );
	swigStructField( "AVCodecContext-priv_data", offsetof( struct AVCodecContext, priv_data ), sizeof( void * ) );
	swigStructField( "AVCodecContext-skip_loop_filter", offsetof( struct AVCodecContext, skip_loop_filter ), sizeof( enum AVDiscard ) );
	swigStructField( "AVCodecContext-frame_number", offsetof( struct AVCodecContext, frame_number ), sizeof( int ) );
	swigStructField( "AVCodecContext-codec_descriptor", offsetof( struct AVCodecContext, codec_descriptor ), sizeof( AVCodecDescriptor const * ) );
	swigStructField( "AVCodecContext-colorspace", offsetof( struct AVCodecContext, colorspace ), sizeof( enum AVColorSpace ) );
	swigStructField( "AVCodecContext-pts_correction_num_faulty_pts", offsetof( struct AVCodecContext, pts_correction_num_faulty_pts ), sizeof( int64_t ) );
	swigStructField( "AVCodecContext-subtitle_header", offsetof( struct AVCodecContext, subtitle_header ), sizeof( uint8_t * ) );
	swigStructField( "AVCodecContext-bit_rate_tolerance", offsetof( struct AVCodecContext, bit_rate_tolerance ), sizeof( int ) );
	swigStructField( "AVCodecContext-ildct_cmp", offsetof( struct AVCodecContext, ildct_cmp ), sizeof( int ) );
	swigStructField( "AVCodecContext-active_thread_type", offsetof( struct AVCodecContext, active_thread_type ), sizeof( int ) );
	swigStructField( "AVCodecContext-thread_type", offsetof( struct AVCodecContext, thread_type ), sizeof( int ) );
	swigStructField( "AVCodecContext-color_primaries", offsetof( struct AVCodecContext, color_primaries ), sizeof( enum AVColorPrimaries ) );
	swigStructField( "AVCodecContext-get_buffer2", offsetof( struct AVCodecContext, get_buffer2 ), sizeof( int (*)(struct AVCodecContext *,AVFrame *,int) ) );
	swigStructField( "AVCodecContext-strict_std_compliance", offsetof( struct AVCodecContext, strict_std_compliance ), sizeof( int ) );
	swigStructField( "AVCodecContext-codec", offsetof( struct AVCodecContext, codec ), sizeof( struct AVCodec const * ) );
	swigStructField( "AVCodecContext-rc_min_vbv_overflow_use", offsetof( struct AVCodecContext, rc_min_vbv_overflow_use ), sizeof( float ) );
	swigStructField( "AVCodecContext-rc_min_rate", offsetof( struct AVCodecContext, rc_min_rate ), sizeof( int64_t ) );
	swigStructField( "AVCodecContext-nb_coded_side_data", offsetof( struct AVCodecContext, nb_coded_side_data ), sizeof( int ) );
	swigStructField( "AVCodecContext-coded_side_data", offsetof( struct AVCodecContext, coded_side_data ), sizeof( AVPacketSideData * ) );
	swigStructField( "AVCodecContext-hwaccel", offsetof( struct AVCodecContext, hwaccel ), sizeof( struct AVHWAccel const * ) );
	swigStructField( "AVCodecContext-pts_correction_last_dts", offsetof( struct AVCodecContext, pts_correction_last_dts ), sizeof( int64_t ) );
	swigStructField( "AVCodecContext-hw_frames_ctx", offsetof( struct AVCodecContext, hw_frames_ctx ), sizeof( AVBufferRef * ) );
	swigStructField( "AVCodecContext-error", offsetof( struct AVCodecContext, error ), sizeof( uint64_t [AV_NUM_DATA_POINTERS] ) );
	swigStructField( "AVCodecContext-global_quality", offsetof( struct AVCodecContext, global_quality ), sizeof( int ) );
	swigStructField( "AVCodecContext-me_subpel_quality", offsetof( struct AVCodecContext, me_subpel_quality ), sizeof( int ) );
	swigStructField( "AVCodecContext-channels", offsetof( struct AVCodecContext, channels ), sizeof( int ) );
	swigStructField( "AVCodecContext-slice_flags", offsetof( struct AVCodecContext, slice_flags ), sizeof( int ) );
	swigStructField( "AVCodecContext-me_range", offsetof( struct AVCodecContext, me_range ), sizeof( int ) );
	swigStructField( "AVCodecContext-subtitle_header_size", offsetof( struct AVCodecContext, subtitle_header_size ), sizeof( int ) );
	swigStructField( "AVCodecContext-rc_buffer_size", offsetof( struct AVCodecContext, rc_buffer_size ), sizeof( int ) );
	swigStructField( "AVCodecContext-rc_max_rate", offsetof( struct AVCodecContext, rc_max_rate ), sizeof( int64_t ) );
	swigStructField( "AVCodecContext-seek_preroll", offsetof( struct AVCodecContext, seek_preroll ), sizeof( int ) );
	swigStructField( "AVCodecContext-dia_size", offsetof( struct AVCodecContext, dia_size ), sizeof( int ) );
	swigStructField( "AVCodecContext-pre_dia_size", offsetof( struct AVCodecContext, pre_dia_size ), sizeof( int ) );
	swigStructField( "AVCodecContext-lowres", offsetof( struct AVCodecContext, lowres ), sizeof( int ) );
	swigStructField( "AVCodecContext-coded_width", offsetof( struct AVCodecContext, coded_width ), sizeof( int ) );
	swigStructField( "AVCodecContext-i_quant_offset", offsetof( struct AVCodecContext, i_quant_offset ), sizeof( float ) );
	swigStructField( "AVCodecContext-b_quant_offset", offsetof( struct AVCodecContext, b_quant_offset ), sizeof( float ) );
	swigStructField( "AVCodecContext-log_level_offset", offsetof( struct AVCodecContext, log_level_offset ), sizeof( int ) );
	swigStructField( "AVCodecContext-slice_offset", offsetof( struct AVCodecContext, slice_offset ), sizeof( int * ) );
	swigStructField( "AVCodecContext-skip_idct", offsetof( struct AVCodecContext, skip_idct ), sizeof( enum AVDiscard ) );
	swigStructField( "AVCodecContext-mv0_threshold", offsetof( struct AVCodecContext, mv0_threshold ), sizeof( int ) );
	swigStructField( "AVCodecContext-mb_lmin", offsetof( struct AVCodecContext, mb_lmin ), sizeof( int ) );
	swigStructField( "AVCodecContext-sub_text_format", offsetof( struct AVCodecContext, sub_text_format ), sizeof( int ) );
	swigStructField( "AVCodecContext-get_format", offsetof( struct AVCodecContext, get_format ), sizeof( enum AVPixelFormat (*)(struct AVCodecContext *,enum AVPixelFormat const *) ) );
	swigStructField( "AVCodecContext-lumi_masking", offsetof( struct AVCodecContext, lumi_masking ), sizeof( float ) );
	swigStructField( "AVCodecContext-temporal_cplx_masking", offsetof( struct AVCodecContext, temporal_cplx_masking ), sizeof( float ) );
	swigStructField( "AVCodecContext-spatial_cplx_masking", offsetof( struct AVCodecContext, spatial_cplx_masking ), sizeof( float ) );
	swigStructField( "AVCodecContext-p_masking", offsetof( struct AVCodecContext, p_masking ), sizeof( float ) );
	swigStructField( "AVCodecContext-dark_masking", offsetof( struct AVCodecContext, dark_masking ), sizeof( float ) );
	swigStructField( "AVCodecContext-execute", offsetof( struct AVCodecContext, execute ), sizeof( int (*)(struct AVCodecContext *,int (*)(struct AVCodecContext *,void *),void *,int *,int,int) ) );
	swigStructField( "AVCodecContext-sw_pix_fmt", offsetof( struct AVCodecContext, sw_pix_fmt ), sizeof( enum AVPixelFormat ) );
	swigStructField( "AVCodecContext-pix_fmt", offsetof( struct AVCodecContext, pix_fmt ), sizeof( enum AVPixelFormat ) );
	swigStructField( "AVCodecContext-hwaccel_context", offsetof( struct AVCodecContext, hwaccel_context ), sizeof( void * ) );
	swigStructField( "AVCodecContext-hwaccel_flags", offsetof( struct AVCodecContext, hwaccel_flags ), sizeof( int ) );
	swigStructField( "AVCodecContext-err_recognition", offsetof( struct AVCodecContext, err_recognition ), sizeof( int ) );
	swigStructField( "AVCodecContext-rc_override", offsetof( struct AVCodecContext, rc_override ), sizeof( RcOverride * ) );
	swigStructField( "AVCodecContext-rc_override_count", offsetof( struct AVCodecContext, rc_override_count ), sizeof( int ) );
	swigStructField( "AVCodecContext-slice_count", offsetof( struct AVCodecContext, slice_count ), sizeof( int ) );
	swigStructField( "AVCodecContext-color_range", offsetof( struct AVCodecContext, color_range ), sizeof( enum AVColorRange ) );
	swigStructField( "AVCodecContext-debug", offsetof( struct AVCodecContext, debug ), sizeof( int ) );
	swigStructField( "AVCodecContext-qmin", offsetof( struct AVCodecContext, qmin ), sizeof( int ) );
	swigStructField( "AVCodecContext-bidir_refine", offsetof( struct AVCodecContext, bidir_refine ), sizeof( int ) );
	swigStructField( "AVCodecContext-delay", offsetof( struct AVCodecContext, delay ), sizeof( int ) );
	swigStructField( "AVCodecContext-draw_horiz_band", offsetof( struct AVCodecContext, draw_horiz_band ), sizeof( void (*)(struct AVCodecContext *,AVFrame const *,int [AV_NUM_DATA_POINTERS],int,int,int) ) );
	swigStructField( "AVCodecContext-skip_bottom", offsetof( struct AVCodecContext, skip_bottom ), sizeof( int ) );
	swigStructField( "AVCodecContext-extradata_size", offsetof( struct AVCodecContext, extradata_size ), sizeof( int ) );
	swigStructField( "AVCodecContext-apply_cropping", offsetof( struct AVCodecContext, apply_cropping ), sizeof( int ) );
	swigStructField( "AVCodecContext-reordered_opaque", offsetof( struct AVCodecContext, reordered_opaque ), sizeof( int64_t ) );
	swigStructField( "AVCodecContext-sub_charenc_mode", offsetof( struct AVCodecContext, sub_charenc_mode ), sizeof( int ) );
	swigStructField( "AVCodecContext-flags2", offsetof( struct AVCodecContext, flags2 ), sizeof( int ) );
	swigStructField( "AVCodecContext-gop_size", offsetof( struct AVCodecContext, gop_size ), sizeof( int ) );
	swigStructField( "AVCodecContext-qcompress", offsetof( struct AVCodecContext, qcompress ), sizeof( float ) );
	swigStructField( "AVCodecContext-me_cmp", offsetof( struct AVCodecContext, me_cmp ), sizeof( int ) );
	swigStructField( "AVCodecContext-error_concealment", offsetof( struct AVCodecContext, error_concealment ), sizeof( int ) );
	swigStructField( "AVCodecContext-extradata", offsetof( struct AVCodecContext, extradata ), sizeof( uint8_t * ) );
	swigStructField( "AVCodecContext-keyint_min", offsetof( struct AVCodecContext, keyint_min ), sizeof( int ) );
	swigStructField( "AVCodecContext-codec_whitelist", offsetof( struct AVCodecContext, codec_whitelist ), sizeof( char * ) );
	swigStructField( "AVCodecContext-audio_service_type", offsetof( struct AVCodecContext, audio_service_type ), sizeof( enum AVAudioServiceType ) );
	swigStructField( "AVCodecContext-mb_cmp", offsetof( struct AVCodecContext, mb_cmp ), sizeof( int ) );
	swigStructField( "AVCodecContext-me_pre_cmp", offsetof( struct AVCodecContext, me_pre_cmp ), sizeof( int ) );
	swigStructField( "AVCodecContext-extra_hw_frames", offsetof( struct AVCodecContext, extra_hw_frames ), sizeof( int ) );
	swigStructField( "AVCodecContext-refcounted_frames", offsetof( struct AVCodecContext, refcounted_frames ), sizeof( int ) );
	swigStructField( "AVCodecContext-has_b_frames", offsetof( struct AVCodecContext, has_b_frames ), sizeof( int ) );
	swigStructField( "AVCodecContext-max_b_frames", offsetof( struct AVCodecContext, max_b_frames ), sizeof( int ) );
	swigStructField( "AVCodecContext-chroma_intra_matrix", offsetof( struct AVCodecContext, chroma_intra_matrix ), sizeof( uint16_t * ) );
	swigStructField( "AVCodecContext-intra_matrix", offsetof( struct AVCodecContext, intra_matrix ), sizeof( uint16_t * ) );
	swigStructField( "AVCodecContext-inter_matrix", offsetof( struct AVCodecContext, inter_matrix ), sizeof( uint16_t * ) );
	swigStructField( "AVCodecContext-compression_level", offsetof( struct AVCodecContext, compression_level ), sizeof( int ) );
	swigStructField( "AVCodecContext-block_align", offsetof( struct AVCodecContext, block_align ), sizeof( int ) );
	swigStructField( "AVCodecContext-thread_count", offsetof( struct AVCodecContext, thread_count ), sizeof( int ) );
	swigStructField( "AVCodecContext-last_predictor_count", offsetof( struct AVCodecContext, last_predictor_count ), sizeof( int ) );
	swigStructField( "AVCodecContext-sample_aspect_ratio", offsetof( struct AVCodecContext, sample_aspect_ratio ), sizeof( AVRational ) );
	swigStructField( "AVCodecContext-trailing_padding", offsetof( struct AVCodecContext, trailing_padding ), sizeof( int ) );
	swigStructField( "AVCodecContext-initial_padding", offsetof( struct AVCodecContext, initial_padding ), sizeof( int ) );
	swigStructField( "AVCodecContext-width", offsetof( struct AVCodecContext, width ), sizeof( int ) );
	swigStructField( "AVCodecContext-dump_separator", offsetof( struct AVCodecContext, dump_separator ), sizeof( uint8_t * ) );
	swigStructField( "AVCodecContext-slices", offsetof( struct AVCodecContext, slices ), sizeof( int ) );
	swigStructField( "AVCodecContext-pts_correction_last_pts", offsetof( struct AVCodecContext, pts_correction_last_pts ), sizeof( int64_t ) );
	swigStructField( "AVCodecContext-sub_charenc", offsetof( struct AVCodecContext, sub_charenc ), sizeof( char * ) );
	swigStructField( "AVCodecContext-codec_tag", offsetof( struct AVCodecContext, codec_tag ), sizeof( unsigned int ) );
	swigStructField( "AVCodecContext-opaque", offsetof( struct AVCodecContext, opaque ), sizeof( void * ) );
	swigStructField( "AVCodecContext-sample_rate", offsetof( struct AVCodecContext, sample_rate ), sizeof( int ) );
	swigStructField( "AVCodecContext-refs", offsetof( struct AVCodecContext, refs ), sizeof( int ) );
	swigStructField( "AVCodecContext-flags", offsetof( struct AVCodecContext, flags ), sizeof( int ) );
	swigStructField( "AVCodecContext-max_pixels", offsetof( struct AVCodecContext, max_pixels ), sizeof( int64_t ) );
	swigStructField( "AVCodecContext-bit_rate", offsetof( struct AVCodecContext, bit_rate ), sizeof( int64_t ) );
	swigStructField( "AVCodecContext-hw_device_ctx", offsetof( struct AVCodecContext, hw_device_ctx ), sizeof( AVBufferRef * ) );
	swigStructField( "AVCodecContext-framerate", offsetof( struct AVCodecContext, framerate ), sizeof( AVRational ) );
	swigStructField( "AVCodecContext-skip_frame", offsetof( struct AVCodecContext, skip_frame ), sizeof( enum AVDiscard ) );
	swigStructField( "AVCodecContext-ticks_per_frame", offsetof( struct AVCodecContext, ticks_per_frame ), sizeof( int ) );
	swigStructField( "AVCodecContext-pts_correction_num_faulty_dts", offsetof( struct AVCodecContext, pts_correction_num_faulty_dts ), sizeof( int64_t ) );
	swigStructField( "AVCodecContext-debug_mv", offsetof( struct AVCodecContext, debug_mv ), sizeof( int ) );
	swigStructField( "AVCodecContext-internal", offsetof( struct AVCodecContext, internal ), sizeof( struct AVCodecInternal * ) );
	swigStructField( "AVCodecContext-rc_initial_buffer_occupancy", offsetof( struct AVCodecContext, rc_initial_buffer_occupancy ), sizeof( int ) );
	swigStructField( "AVCodecContext-cutoff", offsetof( struct AVCodecContext, cutoff ), sizeof( int ) );
	swigStructField( "AVCodecContext-skip_top", offsetof( struct AVCodecContext, skip_top ), sizeof( int ) );
	swigStructField( "AVCodecContext-me_sub_cmp", offsetof( struct AVCodecContext, me_sub_cmp ), sizeof( int ) );
	swigStructField( "AVCodecContext-codec_type", offsetof( struct AVCodecContext, codec_type ), sizeof( enum AVMediaType ) );
	swigStructField( "AVCodecContext-bits_per_raw_sample", offsetof( struct AVCodecContext, bits_per_raw_sample ), sizeof( int ) );
	swigStructField( "AVCodecContext-bits_per_coded_sample", offsetof( struct AVCodecContext, bits_per_coded_sample ), sizeof( int ) );
	swigStructField( "AVCodecContext-trellis", offsetof( struct AVCodecContext, trellis ), sizeof( int ) );
	swigStructField( "AVCodecContext-discard_damaged_percentage", offsetof( struct AVCodecContext, discard_damaged_percentage ), sizeof( int ) );
	swigStructField( "AVCodecContext-idct_algo", offsetof( struct AVCodecContext, idct_algo ), sizeof( int ) );
	swigStructField( "AVCodecContext-dct_algo", offsetof( struct AVCodecContext, dct_algo ), sizeof( int ) );
	swigStructField( "AVCodecContext-properties", offsetof( struct AVCodecContext, properties ), sizeof( unsigned int ) );
	swigStructField( "AVCodecContext-coded_height", offsetof( struct AVCodecContext, coded_height ), sizeof( int ) );
	swigStructField( "AVCodecContext-execute2", offsetof( struct AVCodecContext, execute2 ), sizeof( int (*)(struct AVCodecContext *,int (*)(struct AVCodecContext *,void *,int,int),void *,int *,int) ) );
	swigStructField( "AVCodecContext-codec_id", offsetof( struct AVCodecContext, codec_id ), sizeof( enum AVCodecID ) );
	swigStructField( "AVCodecContext-color_trc", offsetof( struct AVCodecContext, color_trc ), sizeof( enum AVColorTransferCharacteristic ) );
	swigStructField( "AVCodecContext-request_channel_layout", offsetof( struct AVCodecContext, request_channel_layout ), sizeof( uint64_t ) );
	swigStructField( "AVCodecContext-channel_layout", offsetof( struct AVCodecContext, channel_layout ), sizeof( uint64_t ) );
	swigStructField( "AVCodecContext-time_base", offsetof( struct AVCodecContext, time_base ), sizeof( AVRational ) );
	swigStructField( "AVCodecContext-skip_alpha", offsetof( struct AVCodecContext, skip_alpha ), sizeof( int ) );
	swigStructField( "AVCodecContext-av_class", offsetof( struct AVCodecContext, av_class ), sizeof( AVClass const * ) );
	swigStructField( "AVCodecContext-level", offsetof( struct AVCodecContext, level ), sizeof( int ) );
	swigStructField( "AVCodecContext-thread_safe_callbacks", offsetof( struct AVCodecContext, thread_safe_callbacks ), sizeof( int ) );
	swigStructField( "AVCodecContext-mb_lmax", offsetof( struct AVCodecContext, mb_lmax ), sizeof( int ) );
	swigStructField( "AVCodecContext-mb_decision", offsetof( struct AVCodecContext, mb_decision ), sizeof( int ) );
	swigStructField( "AVCodecContext-intra_dc_precision", offsetof( struct AVCodecContext, intra_dc_precision ), sizeof( int ) );
	swigStructField( "AVCodecContext-rc_max_available_vbv_use", offsetof( struct AVCodecContext, rc_max_available_vbv_use ), sizeof( float ) );
	swigStructField( "AVCodecContext-field_order", offsetof( struct AVCodecContext, field_order ), sizeof( enum AVFieldOrder ) );
	swigStructField( "AVCodecContext-i_quant_factor", offsetof( struct AVCodecContext, i_quant_factor ), sizeof( float ) );
	swigStructField( "AVCodecContext-b_quant_factor", offsetof( struct AVCodecContext, b_quant_factor ), sizeof( float ) );
	printf( "drop %zu end-structure\n", sizeof( struct AVCodecContext ) );

	swigComment("AVProfile\n");
	printf( "begin-structure AVProfile\n" );
	swigStructField( "AVProfile-name", offsetof( struct AVProfile, name ), sizeof( char const * ) );
	swigStructField( "AVProfile-profile", offsetof( struct AVProfile, profile ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( struct AVProfile ) );

	swigComment("AVCodecHWConfig\n");
	printf( "begin-structure AVCodecHWConfig\n" );
	swigStructField( "AVCodecHWConfig-device_type", offsetof( struct AVCodecHWConfig, device_type ), sizeof( enum AVHWDeviceType ) );
	swigStructField( "AVCodecHWConfig-pix_fmt", offsetof( struct AVCodecHWConfig, pix_fmt ), sizeof( enum AVPixelFormat ) );
	swigStructField( "AVCodecHWConfig-methods", offsetof( struct AVCodecHWConfig, methods ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( struct AVCodecHWConfig ) );

	swigComment("AVCodec\n");
	printf( "begin-structure AVCodec\n" );
	swigStructField( "AVCodec-pix_fmts", offsetof( struct AVCodec, pix_fmts ), sizeof( enum AVPixelFormat const * ) );
	swigStructField( "AVCodec-decode", offsetof( struct AVCodec, decode ), sizeof( int (*)(AVCodecContext *,void *,int *,AVPacket *) ) );
	swigStructField( "AVCodec-priv_class", offsetof( struct AVCodec, priv_class ), sizeof( AVClass const * ) );
	swigStructField( "AVCodec-supported_samplerates", offsetof( struct AVCodec, supported_samplerates ), sizeof( int const * ) );
	swigStructField( "AVCodec-channel_layouts", offsetof( struct AVCodec, channel_layouts ), sizeof( uint64_t const * ) );
	swigStructField( "AVCodec-long_name", offsetof( struct AVCodec, long_name ), sizeof( char const * ) );
	swigStructField( "AVCodec-name", offsetof( struct AVCodec, name ), sizeof( char const * ) );
	swigStructField( "AVCodec-update_thread_context", offsetof( struct AVCodec, update_thread_context ), sizeof( int (*)(AVCodecContext *,AVCodecContext const *) ) );
	swigStructField( "AVCodec-encode2", offsetof( struct AVCodec, encode2 ), sizeof( int (*)(AVCodecContext *,AVPacket *,AVFrame const *,int *) ) );
	swigStructField( "AVCodec-receive_frame", offsetof( struct AVCodec, receive_frame ), sizeof( int (*)(AVCodecContext *,AVFrame *) ) );
	swigStructField( "AVCodec-capabilities", offsetof( struct AVCodec, capabilities ), sizeof( int ) );
	swigStructField( "AVCodec-flush", offsetof( struct AVCodec, flush ), sizeof( void (*)(AVCodecContext *) ) );
	swigStructField( "AVCodec-init_thread_copy", offsetof( struct AVCodec, init_thread_copy ), sizeof( int (*)(AVCodecContext *) ) );
	swigStructField( "AVCodec-caps_internal", offsetof( struct AVCodec, caps_internal ), sizeof( int ) );
	swigStructField( "AVCodec-profiles", offsetof( struct AVCodec, profiles ), sizeof( AVProfile const * ) );
	swigStructField( "AVCodec-supported_framerates", offsetof( struct AVCodec, supported_framerates ), sizeof( AVRational const * ) );
	swigStructField( "AVCodec-priv_data_size", offsetof( struct AVCodec, priv_data_size ), sizeof( int ) );
	swigStructField( "AVCodec-defaults", offsetof( struct AVCodec, defaults ), sizeof( AVCodecDefault const * ) );
	swigStructField( "AVCodec-sample_fmts", offsetof( struct AVCodec, sample_fmts ), sizeof( enum AVSampleFormat const * ) );
	swigStructField( "AVCodec-id", offsetof( struct AVCodec, id ), sizeof( enum AVCodecID ) );
	swigStructField( "AVCodec-max_lowres", offsetof( struct AVCodec, max_lowres ), sizeof( uint8_t ) );
	swigStructField( "AVCodec-init_static_data", offsetof( struct AVCodec, init_static_data ), sizeof( void (*)(struct AVCodec *) ) );
	swigStructField( "AVCodec-type", offsetof( struct AVCodec, type ), sizeof( enum AVMediaType ) );
	swigStructField( "AVCodec-hw_configs", offsetof( struct AVCodec, hw_configs ), sizeof( struct AVCodecHWConfigInternal const ** ) );
	swigStructField( "AVCodec-wrapper_name", offsetof( struct AVCodec, wrapper_name ), sizeof( char const * ) );
	swigStructField( "AVCodec-next", offsetof( struct AVCodec, next ), sizeof( struct AVCodec * ) );
	swigStructField( "AVCodec-receive_packet", offsetof( struct AVCodec, receive_packet ), sizeof( int (*)(AVCodecContext *,AVPacket *) ) );
	swigStructField( "AVCodec-bsfs", offsetof( struct AVCodec, bsfs ), sizeof( char const * ) );
	swigStructField( "AVCodec-encode_sub", offsetof( struct AVCodec, encode_sub ), sizeof( int (*)(AVCodecContext *,uint8_t *,int,struct AVSubtitle const *) ) );
	swigStructField( "AVCodec-close", offsetof( struct AVCodec, close ), sizeof( int (*)(AVCodecContext *) ) );
	swigStructField( "AVCodec-init", offsetof( struct AVCodec, init ), sizeof( int (*)(AVCodecContext *) ) );
	swigStructField( "AVCodec-send_frame", offsetof( struct AVCodec, send_frame ), sizeof( int (*)(AVCodecContext *,AVFrame const *) ) );
	printf( "drop %zu end-structure\n", sizeof( struct AVCodec ) );

	swigComment("AVHWAccel\n");
	printf( "begin-structure AVHWAccel\n" );
	swigStructField( "AVHWAccel-pix_fmt", offsetof( struct AVHWAccel, pix_fmt ), sizeof( enum AVPixelFormat ) );
	swigStructField( "AVHWAccel-alloc_frame", offsetof( struct AVHWAccel, alloc_frame ), sizeof( int (*)(AVCodecContext *,AVFrame *) ) );
	swigStructField( "AVHWAccel-name", offsetof( struct AVHWAccel, name ), sizeof( char const * ) );
	swigStructField( "AVHWAccel-capabilities", offsetof( struct AVHWAccel, capabilities ), sizeof( int ) );
	swigStructField( "AVHWAccel-decode_slice", offsetof( struct AVHWAccel, decode_slice ), sizeof( int (*)(AVCodecContext *,uint8_t const *,uint32_t) ) );
	swigStructField( "AVHWAccel-decode_params", offsetof( struct AVHWAccel, decode_params ), sizeof( int (*)(AVCodecContext *,int,uint8_t const *,uint32_t) ) );
	swigStructField( "AVHWAccel-frame_params", offsetof( struct AVHWAccel, frame_params ), sizeof( int (*)(AVCodecContext *,AVBufferRef *) ) );
	swigStructField( "AVHWAccel-caps_internal", offsetof( struct AVHWAccel, caps_internal ), sizeof( int ) );
	swigStructField( "AVHWAccel-frame_priv_data_size", offsetof( struct AVHWAccel, frame_priv_data_size ), sizeof( int ) );
	swigStructField( "AVHWAccel-priv_data_size", offsetof( struct AVHWAccel, priv_data_size ), sizeof( int ) );
	swigStructField( "AVHWAccel-id", offsetof( struct AVHWAccel, id ), sizeof( enum AVCodecID ) );
	swigStructField( "AVHWAccel-type", offsetof( struct AVHWAccel, type ), sizeof( enum AVMediaType ) );
	swigStructField( "AVHWAccel-decode_mb", offsetof( struct AVHWAccel, decode_mb ), sizeof( void (*)(struct MpegEncContext *) ) );
	swigStructField( "AVHWAccel-uninit", offsetof( struct AVHWAccel, uninit ), sizeof( int (*)(AVCodecContext *) ) );
	swigStructField( "AVHWAccel-end_frame", offsetof( struct AVHWAccel, end_frame ), sizeof( int (*)(AVCodecContext *) ) );
	swigStructField( "AVHWAccel-start_frame", offsetof( struct AVHWAccel, start_frame ), sizeof( int (*)(AVCodecContext *,uint8_t const *,uint32_t) ) );
	swigStructField( "AVHWAccel-init", offsetof( struct AVHWAccel, init ), sizeof( int (*)(AVCodecContext *) ) );
	printf( "drop %zu end-structure\n", sizeof( struct AVHWAccel ) );

	swigComment("AVSubtitleRect\n");
	printf( "begin-structure AVSubtitleRect\n" );
	swigStructField( "AVSubtitleRect-w", offsetof( struct AVSubtitleRect, w ), sizeof( int ) );
	swigStructField( "AVSubtitleRect-nb_colors", offsetof( struct AVSubtitleRect, nb_colors ), sizeof( int ) );
	swigStructField( "AVSubtitleRect-x", offsetof( struct AVSubtitleRect, x ), sizeof( int ) );
	swigStructField( "AVSubtitleRect-data", offsetof( struct AVSubtitleRect, data ), sizeof( uint8_t *[4] ) );
	swigStructField( "AVSubtitleRect-y", offsetof( struct AVSubtitleRect, y ), sizeof( int ) );
	swigStructField( "AVSubtitleRect-linesize", offsetof( struct AVSubtitleRect, linesize ), sizeof( int [4] ) );
	swigStructField( "AVSubtitleRect-type", offsetof( struct AVSubtitleRect, type ), sizeof( enum AVSubtitleType ) );
	swigStructField( "AVSubtitleRect-text", offsetof( struct AVSubtitleRect, text ), sizeof( char * ) );
	swigStructField( "AVSubtitleRect-flags", offsetof( struct AVSubtitleRect, flags ), sizeof( int ) );
	swigStructField( "AVSubtitleRect-h", offsetof( struct AVSubtitleRect, h ), sizeof( int ) );
	swigStructField( "AVSubtitleRect-ass", offsetof( struct AVSubtitleRect, ass ), sizeof( char * ) );
	printf( "drop %zu end-structure\n", sizeof( struct AVSubtitleRect ) );

	swigComment("AVSubtitle\n");
	printf( "begin-structure AVSubtitle\n" );
	swigStructField( "AVSubtitle-num_rects", offsetof( struct AVSubtitle, num_rects ), sizeof( unsigned int ) );
	swigStructField( "AVSubtitle-rects", offsetof( struct AVSubtitle, rects ), sizeof( AVSubtitleRect ** ) );
	swigStructField( "AVSubtitle-format", offsetof( struct AVSubtitle, format ), sizeof( uint16_t ) );
	swigStructField( "AVSubtitle-start_display_time", offsetof( struct AVSubtitle, start_display_time ), sizeof( uint32_t ) );
	swigStructField( "AVSubtitle-end_display_time", offsetof( struct AVSubtitle, end_display_time ), sizeof( uint32_t ) );
	swigStructField( "AVSubtitle-pts", offsetof( struct AVSubtitle, pts ), sizeof( int64_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct AVSubtitle ) );

	swigComment("AVCodecParameters\n");
	printf( "begin-structure AVCodecParameters\n" );
	swigStructField( "AVCodecParameters-extradata", offsetof( struct AVCodecParameters, extradata ), sizeof( uint8_t * ) );
	swigStructField( "AVCodecParameters-color_range", offsetof( struct AVCodecParameters, color_range ), sizeof( enum AVColorRange ) );
	swigStructField( "AVCodecParameters-seek_preroll", offsetof( struct AVCodecParameters, seek_preroll ), sizeof( int ) );
	swigStructField( "AVCodecParameters-height", offsetof( struct AVCodecParameters, height ), sizeof( int ) );
	swigStructField( "AVCodecParameters-chroma_location", offsetof( struct AVCodecParameters, chroma_location ), sizeof( enum AVChromaLocation ) );
	swigStructField( "AVCodecParameters-frame_size", offsetof( struct AVCodecParameters, frame_size ), sizeof( int ) );
	swigStructField( "AVCodecParameters-bit_rate", offsetof( struct AVCodecParameters, bit_rate ), sizeof( int64_t ) );
	swigStructField( "AVCodecParameters-sample_rate", offsetof( struct AVCodecParameters, sample_rate ), sizeof( int ) );
	swigStructField( "AVCodecParameters-profile", offsetof( struct AVCodecParameters, profile ), sizeof( int ) );
	swigStructField( "AVCodecParameters-color_space", offsetof( struct AVCodecParameters, color_space ), sizeof( enum AVColorSpace ) );
	swigStructField( "AVCodecParameters-format", offsetof( struct AVCodecParameters, format ), sizeof( int ) );
	swigStructField( "AVCodecParameters-level", offsetof( struct AVCodecParameters, level ), sizeof( int ) );
	swigStructField( "AVCodecParameters-codec_type", offsetof( struct AVCodecParameters, codec_type ), sizeof( enum AVMediaType ) );
	swigStructField( "AVCodecParameters-block_align", offsetof( struct AVCodecParameters, block_align ), sizeof( int ) );
	swigStructField( "AVCodecParameters-extradata_size", offsetof( struct AVCodecParameters, extradata_size ), sizeof( int ) );
	swigStructField( "AVCodecParameters-channels", offsetof( struct AVCodecParameters, channels ), sizeof( int ) );
	swigStructField( "AVCodecParameters-width", offsetof( struct AVCodecParameters, width ), sizeof( int ) );
	swigStructField( "AVCodecParameters-video_delay", offsetof( struct AVCodecParameters, video_delay ), sizeof( int ) );
	swigStructField( "AVCodecParameters-sample_aspect_ratio", offsetof( struct AVCodecParameters, sample_aspect_ratio ), sizeof( AVRational ) );
	swigStructField( "AVCodecParameters-codec_tag", offsetof( struct AVCodecParameters, codec_tag ), sizeof( uint32_t ) );
	swigStructField( "AVCodecParameters-color_primaries", offsetof( struct AVCodecParameters, color_primaries ), sizeof( enum AVColorPrimaries ) );
	swigStructField( "AVCodecParameters-initial_padding", offsetof( struct AVCodecParameters, initial_padding ), sizeof( int ) );
	swigStructField( "AVCodecParameters-trailing_padding", offsetof( struct AVCodecParameters, trailing_padding ), sizeof( int ) );
	swigStructField( "AVCodecParameters-bits_per_raw_sample", offsetof( struct AVCodecParameters, bits_per_raw_sample ), sizeof( int ) );
	swigStructField( "AVCodecParameters-bits_per_coded_sample", offsetof( struct AVCodecParameters, bits_per_coded_sample ), sizeof( int ) );
	swigStructField( "AVCodecParameters-codec_id", offsetof( struct AVCodecParameters, codec_id ), sizeof( enum AVCodecID ) );
	swigStructField( "AVCodecParameters-field_order", offsetof( struct AVCodecParameters, field_order ), sizeof( enum AVFieldOrder ) );
	swigStructField( "AVCodecParameters-color_trc", offsetof( struct AVCodecParameters, color_trc ), sizeof( enum AVColorTransferCharacteristic ) );
	swigStructField( "AVCodecParameters-channel_layout", offsetof( struct AVCodecParameters, channel_layout ), sizeof( uint64_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct AVCodecParameters ) );

	swigComment("AVCodecParserContext\n");
	printf( "begin-structure AVCodecParserContext\n" );
	swigStructField( "AVCodecParserContext-dts", offsetof( struct AVCodecParserContext, dts ), sizeof( int64_t ) );
	swigStructField( "AVCodecParserContext-pict_type", offsetof( struct AVCodecParserContext, pict_type ), sizeof( int ) );
	swigStructField( "AVCodecParserContext-format", offsetof( struct AVCodecParserContext, format ), sizeof( int ) );
	swigStructField( "AVCodecParserContext-width", offsetof( struct AVCodecParserContext, width ), sizeof( int ) );
	swigStructField( "AVCodecParserContext-pts", offsetof( struct AVCodecParserContext, pts ), sizeof( int64_t ) );
	swigStructField( "AVCodecParserContext-cur_frame_dts", offsetof( struct AVCodecParserContext, cur_frame_dts ), sizeof( int64_t [4] ) );
	swigStructField( "AVCodecParserContext-fetch_timestamp", offsetof( struct AVCodecParserContext, fetch_timestamp ), sizeof( int ) );
	swigStructField( "AVCodecParserContext-cur_frame_end", offsetof( struct AVCodecParserContext, cur_frame_end ), sizeof( int64_t [4] ) );
	swigStructField( "AVCodecParserContext-duration", offsetof( struct AVCodecParserContext, duration ), sizeof( int ) );
	swigStructField( "AVCodecParserContext-priv_data", offsetof( struct AVCodecParserContext, priv_data ), sizeof( void * ) );
	swigStructField( "AVCodecParserContext-cur_frame_pts", offsetof( struct AVCodecParserContext, cur_frame_pts ), sizeof( int64_t [4] ) );
	swigStructField( "AVCodecParserContext-output_picture_number", offsetof( struct AVCodecParserContext, output_picture_number ), sizeof( int ) );
	swigStructField( "AVCodecParserContext-pts_dts_delta", offsetof( struct AVCodecParserContext, pts_dts_delta ), sizeof( int ) );
	swigStructField( "AVCodecParserContext-dts_ref_dts_delta", offsetof( struct AVCodecParserContext, dts_ref_dts_delta ), sizeof( int ) );
	swigStructField( "AVCodecParserContext-coded_height", offsetof( struct AVCodecParserContext, coded_height ), sizeof( int ) );
	swigStructField( "AVCodecParserContext-picture_structure", offsetof( struct AVCodecParserContext, picture_structure ), sizeof( enum AVPictureStructure ) );
	swigStructField( "AVCodecParserContext-parser", offsetof( struct AVCodecParserContext, parser ), sizeof( struct AVCodecParser * ) );
	swigStructField( "AVCodecParserContext-last_pos", offsetof( struct AVCodecParserContext, last_pos ), sizeof( int64_t ) );
	swigStructField( "AVCodecParserContext-dts_sync_point", offsetof( struct AVCodecParserContext, dts_sync_point ), sizeof( int ) );
	swigStructField( "AVCodecParserContext-field_order", offsetof( struct AVCodecParserContext, field_order ), sizeof( enum AVFieldOrder ) );
	swigStructField( "AVCodecParserContext-height", offsetof( struct AVCodecParserContext, height ), sizeof( int ) );
	swigStructField( "AVCodecParserContext-frame_offset", offsetof( struct AVCodecParserContext, frame_offset ), sizeof( int64_t ) );
	swigStructField( "AVCodecParserContext-cur_offset", offsetof( struct AVCodecParserContext, cur_offset ), sizeof( int64_t ) );
	swigStructField( "AVCodecParserContext-next_frame_offset", offsetof( struct AVCodecParserContext, next_frame_offset ), sizeof( int64_t ) );
	swigStructField( "AVCodecParserContext-cur_frame_offset", offsetof( struct AVCodecParserContext, cur_frame_offset ), sizeof( int64_t [4] ) );
	swigStructField( "AVCodecParserContext-last_dts", offsetof( struct AVCodecParserContext, last_dts ), sizeof( int64_t ) );
	swigStructField( "AVCodecParserContext-pos", offsetof( struct AVCodecParserContext, pos ), sizeof( int64_t ) );
	swigStructField( "AVCodecParserContext-flags", offsetof( struct AVCodecParserContext, flags ), sizeof( int ) );
	swigStructField( "AVCodecParserContext-key_frame", offsetof( struct AVCodecParserContext, key_frame ), sizeof( int ) );
	swigStructField( "AVCodecParserContext-repeat_pict", offsetof( struct AVCodecParserContext, repeat_pict ), sizeof( int ) );
	swigStructField( "AVCodecParserContext-coded_width", offsetof( struct AVCodecParserContext, coded_width ), sizeof( int ) );
	swigStructField( "AVCodecParserContext-last_pts", offsetof( struct AVCodecParserContext, last_pts ), sizeof( int64_t ) );
	swigStructField( "AVCodecParserContext-cur_frame_pos", offsetof( struct AVCodecParserContext, cur_frame_pos ), sizeof( int64_t [4] ) );
	swigStructField( "AVCodecParserContext-cur_frame_start_index", offsetof( struct AVCodecParserContext, cur_frame_start_index ), sizeof( int ) );
	swigStructField( "AVCodecParserContext-offset", offsetof( struct AVCodecParserContext, offset ), sizeof( int64_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct AVCodecParserContext ) );

	swigComment("AVCodecParser\n");
	printf( "begin-structure AVCodecParser\n" );
	swigStructField( "AVCodecParser-split", offsetof( struct AVCodecParser, split ), sizeof( int (*)(AVCodecContext *,uint8_t const *,int) ) );
	swigStructField( "AVCodecParser-codec_ids", offsetof( struct AVCodecParser, codec_ids ), sizeof( int [5] ) );
	swigStructField( "AVCodecParser-priv_data_size", offsetof( struct AVCodecParser, priv_data_size ), sizeof( int ) );
	swigStructField( "AVCodecParser-parser_init", offsetof( struct AVCodecParser, parser_init ), sizeof( int (*)(AVCodecParserContext *) ) );
	swigStructField( "AVCodecParser-parser_parse", offsetof( struct AVCodecParser, parser_parse ), sizeof( int (*)(AVCodecParserContext *,AVCodecContext *,uint8_t const **,int *,uint8_t const *,int) ) );
	swigStructField( "AVCodecParser-parser_close", offsetof( struct AVCodecParser, parser_close ), sizeof( void (*)(AVCodecParserContext *) ) );
	swigStructField( "AVCodecParser-next", offsetof( struct AVCodecParser, next ), sizeof( struct AVCodecParser * ) );
	printf( "drop %zu end-structure\n", sizeof( struct AVCodecParser ) );

	swigComment("AVBSFContext\n");
	printf( "begin-structure AVBSFContext\n" );
	swigStructField( "AVBSFContext-internal", offsetof( struct AVBSFContext, internal ), sizeof( AVBSFInternal * ) );
	swigStructField( "AVBSFContext-par_in", offsetof( struct AVBSFContext, par_in ), sizeof( AVCodecParameters * ) );
	swigStructField( "AVBSFContext-par_out", offsetof( struct AVBSFContext, par_out ), sizeof( AVCodecParameters * ) );
	swigStructField( "AVBSFContext-filter", offsetof( struct AVBSFContext, filter ), sizeof( struct AVBitStreamFilter const * ) );
	swigStructField( "AVBSFContext-time_base_in", offsetof( struct AVBSFContext, time_base_in ), sizeof( AVRational ) );
	swigStructField( "AVBSFContext-av_class", offsetof( struct AVBSFContext, av_class ), sizeof( AVClass const * ) );
	swigStructField( "AVBSFContext-priv_data", offsetof( struct AVBSFContext, priv_data ), sizeof( void * ) );
	swigStructField( "AVBSFContext-time_base_out", offsetof( struct AVBSFContext, time_base_out ), sizeof( AVRational ) );
	printf( "drop %zu end-structure\n", sizeof( struct AVBSFContext ) );

	swigComment("AVBitStreamFilter\n");
	printf( "begin-structure AVBitStreamFilter\n" );
	swigStructField( "AVBitStreamFilter-init", offsetof( struct AVBitStreamFilter, init ), sizeof( int (*)(AVBSFContext *) ) );
	swigStructField( "AVBitStreamFilter-name", offsetof( struct AVBitStreamFilter, name ), sizeof( char const * ) );
	swigStructField( "AVBitStreamFilter-codec_ids", offsetof( struct AVBitStreamFilter, codec_ids ), sizeof( enum AVCodecID const * ) );
	swigStructField( "AVBitStreamFilter-priv_data_size", offsetof( struct AVBitStreamFilter, priv_data_size ), sizeof( int ) );
	swigStructField( "AVBitStreamFilter-filter", offsetof( struct AVBitStreamFilter, filter ), sizeof( int (*)(AVBSFContext *,AVPacket *) ) );
	swigStructField( "AVBitStreamFilter-priv_class", offsetof( struct AVBitStreamFilter, priv_class ), sizeof( AVClass const * ) );
	swigStructField( "AVBitStreamFilter-flush", offsetof( struct AVBitStreamFilter, flush ), sizeof( void (*)(AVBSFContext *) ) );
	swigStructField( "AVBitStreamFilter-close", offsetof( struct AVBitStreamFilter, close ), sizeof( void (*)(AVBSFContext *) ) );
	printf( "drop %zu end-structure\n", sizeof( struct AVBitStreamFilter ) );

	swigNewline();

	swigComment("--===< function pointers >===---\n");
	swigFunctionPointer( "c-funptr AVCodecContext-draw_horiz_band() {((struct AVCodecContext*)ptr)->draw_horiz_band} a a a n n n -- void", "", "", "	( s src offset y type height -- )" );
	swigFunctionPointer( "c-funptr AVCodecContext-get_format() {((struct AVCodecContext*)ptr)->get_format} a a -- n", "", "", "	( s fmt -- )" );
	swigFunctionPointer( "c-funptr AVCodecContext-get_buffer2() {((struct AVCodecContext*)ptr)->get_buffer2} a a n -- n", "", "", "	( s frame flags -- )" );
	swigFunctionPointer( "c-funptr AVCodecContext-execute() {((struct AVCodecContext*)ptr)->execute} a a a a n n -- n", "", "", "	( c func arg2 ret count size -- )" );
	swigFunctionPointer( "c-funptr AVCodecContext-execute2() {((struct AVCodecContext*)ptr)->execute2} a a a a n -- n", "", "", "	( c func arg2 ret count -- )" );
	swigFunctionPointer( "c-funptr AVCodec-init_thread_copy() {((struct AVCodec*)ptr)->init_thread_copy} a -- n", "", "", "	( <noname> -- )" );
	swigFunctionPointer( "c-funptr AVCodec-update_thread_context() {((struct AVCodec*)ptr)->update_thread_context} a a -- n", "", "", "	( dst src -- )" );
	swigFunctionPointer( "c-funptr AVCodec-init_static_data() {((struct AVCodec*)ptr)->init_static_data} a -- void", "", "", "	( codec -- )" );
	swigFunctionPointer( "c-funptr AVCodec-init() {((struct AVCodec*)ptr)->init} a -- n", "", "", "	( <noname> -- )" );
	swigFunctionPointer( "c-funptr AVCodec-encode_sub() {((struct AVCodec*)ptr)->encode_sub} a a n a -- n", "", "", "	( <noname> buf buf_size sub -- )" );
	swigFunctionPointer( "c-funptr AVCodec-encode2() {((struct AVCodec*)ptr)->encode2} a a a a -- n", "", "", "	( avctx avpkt frame got_packet_ptr -- )" );
	swigFunctionPointer( "c-funptr AVCodec-decode() {((struct AVCodec*)ptr)->decode} a a a a -- n", "", "", "	( <noname> outdata outdata_size avpkt -- )" );
	swigFunctionPointer( "c-funptr AVCodec-close() {((struct AVCodec*)ptr)->close} a -- n", "", "", "	( <noname> -- )" );
	swigFunctionPointer( "c-funptr AVCodec-send_frame() {((struct AVCodec*)ptr)->send_frame} a a -- n", "", "", "	( avctx frame -- )" );
	swigFunctionPointer( "c-funptr AVCodec-receive_packet() {((struct AVCodec*)ptr)->receive_packet} a a -- n", "", "", "	( avctx avpkt -- )" );
	swigFunctionPointer( "c-funptr AVCodec-receive_frame() {((struct AVCodec*)ptr)->receive_frame} a a -- n", "", "", "	( avctx frame -- )" );
	swigFunctionPointer( "c-funptr AVCodec-flush() {((struct AVCodec*)ptr)->flush} a -- void", "", "", "	( <noname> -- )" );
	swigFunctionPointer( "c-funptr AVHWAccel-alloc_frame() {((struct AVHWAccel*)ptr)->alloc_frame} a a -- n", "", "", "	( avctx frame -- )" );
	swigFunctionPointer( "c-funptr AVHWAccel-start_frame() {((struct AVHWAccel*)ptr)->start_frame} a a n -- n", "", "", "	( avctx buf buf_size -- )" );
	swigFunctionPointer( "c-funptr AVHWAccel-decode_params() {((struct AVHWAccel*)ptr)->decode_params} a n a n -- n", "", "", "	( avctx type buf buf_size -- )" );
	swigFunctionPointer( "c-funptr AVHWAccel-decode_slice() {((struct AVHWAccel*)ptr)->decode_slice} a a n -- n", "", "", "	( avctx buf buf_size -- )" );
	swigFunctionPointer( "c-funptr AVHWAccel-end_frame() {((struct AVHWAccel*)ptr)->end_frame} a -- n", "", "", "	( avctx -- )" );
	swigFunctionPointer( "c-funptr AVHWAccel-decode_mb() {((struct AVHWAccel*)ptr)->decode_mb} a -- void", "", "", "	( s -- )" );
	swigFunctionPointer( "c-funptr AVHWAccel-init() {((struct AVHWAccel*)ptr)->init} a -- n", "", "", "	( avctx -- )" );
	swigFunctionPointer( "c-funptr AVHWAccel-uninit() {((struct AVHWAccel*)ptr)->uninit} a -- n", "", "", "	( avctx -- )" );
	swigFunctionPointer( "c-funptr AVHWAccel-frame_params() {((struct AVHWAccel*)ptr)->frame_params} a a -- n", "", "", "	( avctx hw_frames_ctx -- )" );
	swigFunctionPointer( "c-funptr AVCodecParser-parser_init() {((struct AVCodecParser*)ptr)->parser_init} a -- n", "", "", "	( s -- )" );
	swigFunctionPointer( "c-funptr AVCodecParser-parser_parse() {((struct AVCodecParser*)ptr)->parser_parse} a a a a a n -- n", "", "", "	( s avctx poutbuf poutbuf_size buf buf_size -- )" );
	swigFunctionPointer( "c-funptr AVCodecParser-parser_close() {((struct AVCodecParser*)ptr)->parser_close} a -- void", "", "", "	( s -- )" );
	swigFunctionPointer( "c-funptr AVCodecParser-split() {((struct AVCodecParser*)ptr)->split} a a n -- n", "", "", "	( avctx buf buf_size -- )" );
	swigFunctionPointer( "c-funptr AVBitStreamFilter-init() {((struct AVBitStreamFilter*)ptr)->init} a -- n", "", "", "	( ctx -- )" );
	swigFunctionPointer( "c-funptr AVBitStreamFilter-filter() {((struct AVBitStreamFilter*)ptr)->filter} a a -- n", "", "", "	( ctx pkt -- )" );
	swigFunctionPointer( "c-funptr AVBitStreamFilter-close() {((struct AVBitStreamFilter*)ptr)->close} a -- void", "", "", "	( ctx -- )" );
	swigFunctionPointer( "c-funptr AVBitStreamFilter-flush() {((struct AVBitStreamFilter*)ptr)->flush} a -- void", "", "", "	( ctx -- )" );

	swigNewline();

	swigComment("------===< functions >===-------\n");
	swigFunction( "c-function avcodec_get_hw_config avcodec_get_hw_config a n -- a", "FUNCTION: avcodec_get_hw_config ( codec index -- a )", "EXTERN: \"C\" void * avcodec_get_hw_config( void * codec, int index );", "	( codec index -- )" );
	swigFunction( "c-function av_codec_iterate av_codec_iterate a -- a", "FUNCTION: av_codec_iterate ( opaque -- a )", "EXTERN: \"C\" void * av_codec_iterate( void * opaque );", "	( opaque -- )" );
	swigFunction( "c-function avcodec_version avcodec_version  -- u", "FUNCTION: avcodec_version (  -- u )", "EXTERN: \"C\" int avcodec_version(  );", "	( -- )" );
	swigFunction( "c-function avcodec_configuration avcodec_configuration  -- s", "FUNCTION: avcodec_configuration (  -- s )", "EXTERN: \"C\" char * avcodec_configuration(  );", "	( -- )" );
	swigFunction( "c-function avcodec_license avcodec_license  -- s", "FUNCTION: avcodec_license (  -- s )", "EXTERN: \"C\" char * avcodec_license(  );", "	( -- )" );
	swigFunction( "c-function avcodec_alloc_context3 avcodec_alloc_context3 a -- a", "FUNCTION: avcodec_alloc_context3 ( codec -- a )", "EXTERN: \"C\" void * avcodec_alloc_context3( void * codec );", "	( codec -- )" );
	swigFunction( "c-function avcodec_free_context avcodec_free_context a -- void", "FUNCTION: avcodec_free_context ( avctx -- void )", "EXTERN: \"C\" void avcodec_free_context( void * avctx );", "	( avctx -- )" );
	swigFunction( "c-function avcodec_get_class avcodec_get_class  -- a", "FUNCTION: avcodec_get_class (  -- a )", "EXTERN: \"C\" void * avcodec_get_class(  );", "	( -- )" );
	swigFunction( "c-function avcodec_parameters_alloc avcodec_parameters_alloc  -- a", "FUNCTION: avcodec_parameters_alloc (  -- a )", "EXTERN: \"C\" void * avcodec_parameters_alloc(  );", "	( -- )" );
	swigFunction( "c-function avcodec_parameters_free avcodec_parameters_free a -- void", "FUNCTION: avcodec_parameters_free ( par -- void )", "EXTERN: \"C\" void avcodec_parameters_free( void * par );", "	( par -- )" );
	swigFunction( "c-function avcodec_parameters_copy avcodec_parameters_copy a a -- n", "FUNCTION: avcodec_parameters_copy ( dst src -- n )", "EXTERN: \"C\" int avcodec_parameters_copy( void * dst, void * src );", "	( dst src -- )" );
	swigFunction( "c-function avcodec_parameters_from_context avcodec_parameters_from_context a a -- n", "FUNCTION: avcodec_parameters_from_context ( par codec -- n )", "EXTERN: \"C\" int avcodec_parameters_from_context( void * par, void * codec );", "	( par codec -- )" );
	swigFunction( "c-function avcodec_parameters_to_context avcodec_parameters_to_context a a -- n", "FUNCTION: avcodec_parameters_to_context ( codec par -- n )", "EXTERN: \"C\" int avcodec_parameters_to_context( void * codec, void * par );", "	( codec par -- )" );
	swigFunction( "c-function avcodec_open2 avcodec_open2 a a a -- n", "FUNCTION: avcodec_open2 ( avctx codec options -- n )", "EXTERN: \"C\" int avcodec_open2( void * avctx, void * codec, void * options );", "	( avctx codec options -- )" );
	swigFunction( "c-function avcodec_close avcodec_close a -- n", "FUNCTION: avcodec_close ( avctx -- n )", "EXTERN: \"C\" int avcodec_close( void * avctx );", "	( avctx -- )" );
	swigFunction( "c-function avsubtitle_free avsubtitle_free a -- void", "FUNCTION: avsubtitle_free ( sub -- void )", "EXTERN: \"C\" void avsubtitle_free( void * sub );", "	( sub -- )" );
	swigFunction( "c-function av_packet_alloc av_packet_alloc  -- a", "FUNCTION: av_packet_alloc (  -- a )", "EXTERN: \"C\" void * av_packet_alloc(  );", "	( -- )" );
	swigFunction( "c-function av_packet_clone av_packet_clone a -- a", "FUNCTION: av_packet_clone ( src -- a )", "EXTERN: \"C\" void * av_packet_clone( void * src );", "	( src -- )" );
	swigFunction( "c-function av_packet_free av_packet_free a -- void", "FUNCTION: av_packet_free ( pkt -- void )", "EXTERN: \"C\" void av_packet_free( void * pkt );", "	( pkt -- )" );
	swigFunction( "c-function av_init_packet av_init_packet a -- void", "FUNCTION: av_init_packet ( pkt -- void )", "EXTERN: \"C\" void av_init_packet( void * pkt );", "	( pkt -- )" );
	swigFunction( "c-function av_new_packet av_new_packet a n -- n", "FUNCTION: av_new_packet ( pkt size -- n )", "EXTERN: \"C\" int av_new_packet( void * pkt, int size );", "	( pkt size -- )" );
	swigFunction( "c-function av_shrink_packet av_shrink_packet a n -- void", "FUNCTION: av_shrink_packet ( pkt size -- void )", "EXTERN: \"C\" void av_shrink_packet( void * pkt, int size );", "	( pkt size -- )" );
	swigFunction( "c-function av_grow_packet av_grow_packet a n -- n", "FUNCTION: av_grow_packet ( pkt grow_by -- n )", "EXTERN: \"C\" int av_grow_packet( void * pkt, int grow_by );", "	( pkt grow_by -- )" );
	swigFunction( "c-function av_packet_from_data av_packet_from_data a a n -- n", "FUNCTION: av_packet_from_data ( pkt data size -- n )", "EXTERN: \"C\" int av_packet_from_data( void * pkt, void * data, int size );", "	( pkt data size -- )" );
	swigFunction( "c-function av_packet_new_side_data av_packet_new_side_data a n n -- a", "FUNCTION: av_packet_new_side_data ( pkt type size -- a )", "EXTERN: \"C\" void * av_packet_new_side_data( void * pkt, int type, int size );", "	( pkt type size -- )" );
	swigFunction( "c-function av_packet_add_side_data av_packet_add_side_data a n a n -- n", "FUNCTION: av_packet_add_side_data ( pkt type data size -- n )", "EXTERN: \"C\" int av_packet_add_side_data( void * pkt, int type, void * data, n size );", "	( pkt type data size -- )" );
	swigFunction( "c-function av_packet_shrink_side_data av_packet_shrink_side_data a n n -- n", "FUNCTION: av_packet_shrink_side_data ( pkt type size -- n )", "EXTERN: \"C\" int av_packet_shrink_side_data( void * pkt, int type, int size );", "	( pkt type size -- )" );
	swigFunction( "c-function av_packet_get_side_data av_packet_get_side_data a n a -- a", "FUNCTION: av_packet_get_side_data ( pkt type size -- a )", "EXTERN: \"C\" void * av_packet_get_side_data( void * pkt, int type, void * size );", "	( pkt type size -- )" );
	swigFunction( "c-function av_packet_side_data_name av_packet_side_data_name n -- s", "FUNCTION: av_packet_side_data_name ( type -- s )", "EXTERN: \"C\" char * av_packet_side_data_name( int type );", "	( type -- )" );
	swigFunction( "c-function av_packet_pack_dictionary av_packet_pack_dictionary a a -- a", "FUNCTION: av_packet_pack_dictionary ( dict size -- a )", "EXTERN: \"C\" void * av_packet_pack_dictionary( void * dict, void * size );", "	( dict size -- )" );
	swigFunction( "c-function av_packet_unpack_dictionary av_packet_unpack_dictionary a n a -- n", "FUNCTION: av_packet_unpack_dictionary ( data size dict -- n )", "EXTERN: \"C\" int av_packet_unpack_dictionary( void * data, int size, void * dict );", "	( data size dict -- )" );
	swigFunction( "c-function av_packet_free_side_data av_packet_free_side_data a -- void", "FUNCTION: av_packet_free_side_data ( pkt -- void )", "EXTERN: \"C\" void av_packet_free_side_data( void * pkt );", "	( pkt -- )" );
	swigFunction( "c-function av_packet_ref av_packet_ref a a -- n", "FUNCTION: av_packet_ref ( dst src -- n )", "EXTERN: \"C\" int av_packet_ref( void * dst, void * src );", "	( dst src -- )" );
	swigFunction( "c-function av_packet_unref av_packet_unref a -- void", "FUNCTION: av_packet_unref ( pkt -- void )", "EXTERN: \"C\" void av_packet_unref( void * pkt );", "	( pkt -- )" );
	swigFunction( "c-function av_packet_move_ref av_packet_move_ref a a -- void", "FUNCTION: av_packet_move_ref ( dst src -- void )", "EXTERN: \"C\" void av_packet_move_ref( void * dst, void * src );", "	( dst src -- )" );
	swigFunction( "c-function av_packet_copy_props av_packet_copy_props a a -- n", "FUNCTION: av_packet_copy_props ( dst src -- n )", "EXTERN: \"C\" int av_packet_copy_props( void * dst, void * src );", "	( dst src -- )" );
	swigFunction( "c-function av_packet_make_refcounted av_packet_make_refcounted a -- n", "FUNCTION: av_packet_make_refcounted ( pkt -- n )", "EXTERN: \"C\" int av_packet_make_refcounted( void * pkt );", "	( pkt -- )" );
	swigFunction( "c-function av_packet_make_writable av_packet_make_writable a -- n", "FUNCTION: av_packet_make_writable ( pkt -- n )", "EXTERN: \"C\" int av_packet_make_writable( void * pkt );", "	( pkt -- )" );
	swigFunction( "c-function av_packet_rescale_ts av_packet_rescale_ts a d d -- void", "FUNCTION: av_packet_rescale_ts ( pkt tb_src tb_dst -- void )", "EXTERN: \"C\" void av_packet_rescale_ts( void * pkt, long long tb_src, long long tb_dst );", "	( pkt tb_src tb_dst -- )" );
	swigFunction( "c-function avcodec_find_decoder avcodec_find_decoder n -- a", "FUNCTION: avcodec_find_decoder ( id -- a )", "EXTERN: \"C\" void * avcodec_find_decoder( int id );", "	( id -- )" );
	swigFunction( "c-function avcodec_find_decoder_by_name avcodec_find_decoder_by_name s -- a", "FUNCTION: avcodec_find_decoder_by_name ( name -- a )", "EXTERN: \"C\" void * avcodec_find_decoder_by_name( char * name );", "	( name -- )" );
	swigFunction( "c-function avcodec_default_get_buffer2 avcodec_default_get_buffer2 a a n -- n", "FUNCTION: avcodec_default_get_buffer2 ( s frame flags -- n )", "EXTERN: \"C\" int avcodec_default_get_buffer2( void * s, void * frame, int flags );", "	( s frame flags -- )" );
	swigFunction( "c-function avcodec_align_dimensions avcodec_align_dimensions a a a -- void", "FUNCTION: avcodec_align_dimensions ( s width height -- void )", "EXTERN: \"C\" void avcodec_align_dimensions( void * s, void * width, void * height );", "	( s width height -- )" );
	swigFunction( "c-function avcodec_align_dimensions2 avcodec_align_dimensions2 a a a a -- void", "FUNCTION: avcodec_align_dimensions2 ( s width height linesize_align -- void )", "EXTERN: \"C\" void avcodec_align_dimensions2( void * s, void * width, void * height, void * linesize_align );", "	( s width height linesize_align -- )" );
	swigFunction( "c-function avcodec_enum_to_chroma_pos avcodec_enum_to_chroma_pos a a n -- n", "FUNCTION: avcodec_enum_to_chroma_pos ( xpos ypos pos -- n )", "EXTERN: \"C\" int avcodec_enum_to_chroma_pos( void * xpos, void * ypos, int pos );", "	( xpos ypos pos -- )" );
	swigFunction( "c-function avcodec_chroma_pos_to_enum avcodec_chroma_pos_to_enum n n -- n", "FUNCTION: avcodec_chroma_pos_to_enum ( xpos ypos -- n )", "EXTERN: \"C\" int avcodec_chroma_pos_to_enum( int xpos, int ypos );", "	( xpos ypos -- )" );
	swigFunction( "c-function avcodec_decode_audio4 avcodec_decode_audio4 a a a a -- n", "FUNCTION: avcodec_decode_audio4 ( avctx frame got_frame_ptr avpkt -- n )", "EXTERN: \"C\" int avcodec_decode_audio4( void * avctx, void * frame, void * got_frame_ptr, void * avpkt );", "	( avctx frame got_frame_ptr avpkt -- )" );
	swigFunction( "c-function avcodec_decode_video2 avcodec_decode_video2 a a a a -- n", "FUNCTION: avcodec_decode_video2 ( avctx picture got_picture_ptr avpkt -- n )", "EXTERN: \"C\" int avcodec_decode_video2( void * avctx, void * picture, void * got_picture_ptr, void * avpkt );", "	( avctx picture got_picture_ptr avpkt -- )" );
	swigFunction( "c-function avcodec_decode_subtitle2 avcodec_decode_subtitle2 a a a a -- n", "FUNCTION: avcodec_decode_subtitle2 ( avctx sub got_sub_ptr avpkt -- n )", "EXTERN: \"C\" int avcodec_decode_subtitle2( void * avctx, void * sub, void * got_sub_ptr, void * avpkt );", "	( avctx sub got_sub_ptr avpkt -- )" );
	swigFunction( "c-function avcodec_send_packet avcodec_send_packet a a -- n", "FUNCTION: avcodec_send_packet ( avctx avpkt -- n )", "EXTERN: \"C\" int avcodec_send_packet( void * avctx, void * avpkt );", "	( avctx avpkt -- )" );
	swigFunction( "c-function avcodec_receive_frame avcodec_receive_frame a a -- n", "FUNCTION: avcodec_receive_frame ( avctx frame -- n )", "EXTERN: \"C\" int avcodec_receive_frame( void * avctx, void * frame );", "	( avctx frame -- )" );
	swigFunction( "c-function avcodec_send_frame avcodec_send_frame a a -- n", "FUNCTION: avcodec_send_frame ( avctx frame -- n )", "EXTERN: \"C\" int avcodec_send_frame( void * avctx, void * frame );", "	( avctx frame -- )" );
	swigFunction( "c-function avcodec_receive_packet avcodec_receive_packet a a -- n", "FUNCTION: avcodec_receive_packet ( avctx avpkt -- n )", "EXTERN: \"C\" int avcodec_receive_packet( void * avctx, void * avpkt );", "	( avctx avpkt -- )" );
	swigFunction( "c-function avcodec_get_hw_frames_parameters avcodec_get_hw_frames_parameters a a n a -- n", "FUNCTION: avcodec_get_hw_frames_parameters ( avctx device_ref hw_pix_fmt out_frames_ref -- n )", "EXTERN: \"C\" int avcodec_get_hw_frames_parameters( void * avctx, void * device_ref, int hw_pix_fmt, void * out_frames_ref );", "	( avctx device_ref hw_pix_fmt out_frames_ref -- )" );
	swigFunction( "c-function av_parser_iterate av_parser_iterate a -- a", "FUNCTION: av_parser_iterate ( opaque -- a )", "EXTERN: \"C\" void * av_parser_iterate( void * opaque );", "	( opaque -- )" );
	swigFunction( "c-function av_parser_next av_parser_next a -- a", "FUNCTION: av_parser_next ( c -- a )", "EXTERN: \"C\" void * av_parser_next( void * c );", "	( c -- )" );
	swigFunction( "c-function av_register_codec_parser av_register_codec_parser a -- void", "FUNCTION: av_register_codec_parser ( parser -- void )", "EXTERN: \"C\" void av_register_codec_parser( void * parser );", "	( parser -- )" );
	swigFunction( "c-function av_parser_init av_parser_init n -- a", "FUNCTION: av_parser_init ( codec_id -- a )", "EXTERN: \"C\" void * av_parser_init( int codec_id );", "	( codec_id -- )" );
	swigFunction( "c-function av_parser_parse2 av_parser_parse2 a a a a a n n n n -- n", "FUNCTION: av_parser_parse2 ( s avctx poutbuf poutbuf_size buf buf_size pts dts pos -- n )", "EXTERN: \"C\" int av_parser_parse2( void * s, void * avctx, void * poutbuf, void * poutbuf_size, void * buf, int buf_size, n pts, n dts, n pos );", "	( s avctx poutbuf poutbuf_size buf buf_size pts dts pos -- )" );
	swigFunction( "c-function av_parser_change av_parser_change a a a a a n n -- n", "FUNCTION: av_parser_change ( s avctx poutbuf poutbuf_size buf buf_size keyframe -- n )", "EXTERN: \"C\" int av_parser_change( void * s, void * avctx, void * poutbuf, void * poutbuf_size, void * buf, int buf_size, int keyframe );", "	( s avctx poutbuf poutbuf_size buf buf_size keyframe -- )" );
	swigFunction( "c-function av_parser_close av_parser_close a -- void", "FUNCTION: av_parser_close ( s -- void )", "EXTERN: \"C\" void av_parser_close( void * s );", "	( s -- )" );
	swigFunction( "c-function avcodec_find_encoder avcodec_find_encoder n -- a", "FUNCTION: avcodec_find_encoder ( id -- a )", "EXTERN: \"C\" void * avcodec_find_encoder( int id );", "	( id -- )" );
	swigFunction( "c-function avcodec_find_encoder_by_name avcodec_find_encoder_by_name s -- a", "FUNCTION: avcodec_find_encoder_by_name ( name -- a )", "EXTERN: \"C\" void * avcodec_find_encoder_by_name( char * name );", "	( name -- )" );
	swigFunction( "c-function avcodec_encode_audio2 avcodec_encode_audio2 a a a a -- n", "FUNCTION: avcodec_encode_audio2 ( avctx avpkt frame got_packet_ptr -- n )", "EXTERN: \"C\" int avcodec_encode_audio2( void * avctx, void * avpkt, void * frame, void * got_packet_ptr );", "	( avctx avpkt frame got_packet_ptr -- )" );
	swigFunction( "c-function avcodec_encode_video2 avcodec_encode_video2 a a a a -- n", "FUNCTION: avcodec_encode_video2 ( avctx avpkt frame got_packet_ptr -- n )", "EXTERN: \"C\" int avcodec_encode_video2( void * avctx, void * avpkt, void * frame, void * got_packet_ptr );", "	( avctx avpkt frame got_packet_ptr -- )" );
	swigFunction( "c-function avcodec_encode_subtitle avcodec_encode_subtitle a a n a -- n", "FUNCTION: avcodec_encode_subtitle ( avctx buf buf_size sub -- n )", "EXTERN: \"C\" int avcodec_encode_subtitle( void * avctx, void * buf, int buf_size, void * sub );", "	( avctx buf buf_size sub -- )" );
	swigFunction( "c-function avcodec_pix_fmt_to_codec_tag avcodec_pix_fmt_to_codec_tag n -- u", "FUNCTION: avcodec_pix_fmt_to_codec_tag ( pix_fmt -- u )", "EXTERN: \"C\" int avcodec_pix_fmt_to_codec_tag( int pix_fmt );", "	( pix_fmt -- )" );
	swigFunction( "c-function avcodec_get_pix_fmt_loss avcodec_get_pix_fmt_loss n n n -- n", "FUNCTION: avcodec_get_pix_fmt_loss ( dst_pix_fmt src_pix_fmt has_alpha -- n )", "EXTERN: \"C\" int avcodec_get_pix_fmt_loss( int dst_pix_fmt, int src_pix_fmt, int has_alpha );", "	( dst_pix_fmt src_pix_fmt has_alpha -- )" );
	swigFunction( "c-function avcodec_find_best_pix_fmt_of_list avcodec_find_best_pix_fmt_of_list a n n a -- n", "FUNCTION: avcodec_find_best_pix_fmt_of_list ( pix_fmt_list src_pix_fmt has_alpha loss_ptr -- n )", "EXTERN: \"C\" int avcodec_find_best_pix_fmt_of_list( void * pix_fmt_list, int src_pix_fmt, int has_alpha, void * loss_ptr );", "	( pix_fmt_list src_pix_fmt has_alpha loss_ptr -- )" );
	swigFunction( "c-function avcodec_find_best_pix_fmt_of_2 avcodec_find_best_pix_fmt_of_2 n n n n a -- n", "FUNCTION: avcodec_find_best_pix_fmt_of_2 ( dst_pix_fmt1 dst_pix_fmt2 src_pix_fmt has_alpha loss_ptr -- n )", "EXTERN: \"C\" int avcodec_find_best_pix_fmt_of_2( int dst_pix_fmt1, int dst_pix_fmt2, int src_pix_fmt, int has_alpha, void * loss_ptr );", "	( dst_pix_fmt1 dst_pix_fmt2 src_pix_fmt has_alpha loss_ptr -- )" );
	swigFunction( "c-function avcodec_find_best_pix_fmt2 avcodec_find_best_pix_fmt2 n n n n a -- n", "FUNCTION: avcodec_find_best_pix_fmt2 ( dst_pix_fmt1 dst_pix_fmt2 src_pix_fmt has_alpha loss_ptr -- n )", "EXTERN: \"C\" int avcodec_find_best_pix_fmt2( int dst_pix_fmt1, int dst_pix_fmt2, int src_pix_fmt, int has_alpha, void * loss_ptr );", "	( dst_pix_fmt1 dst_pix_fmt2 src_pix_fmt has_alpha loss_ptr -- )" );
	swigFunction( "c-function avcodec_default_get_format avcodec_default_get_format a a -- n", "FUNCTION: avcodec_default_get_format ( s fmt -- n )", "EXTERN: \"C\" int avcodec_default_get_format( void * s, void * fmt );", "	( s fmt -- )" );
	swigFunction( "c-function avcodec_string avcodec_string a n a n -- void", "FUNCTION: avcodec_string ( buf buf_size enc encode -- void )", "EXTERN: \"C\" void avcodec_string( void * buf, int buf_size, void * enc, int encode );", "	( buf buf_size enc encode -- )" );
	swigFunction( "c-function av_get_profile_name av_get_profile_name a n -- s", "FUNCTION: av_get_profile_name ( codec profile -- s )", "EXTERN: \"C\" char * av_get_profile_name( void * codec, int profile );", "	( codec profile -- )" );
	swigFunction( "c-function avcodec_profile_name avcodec_profile_name n n -- s", "FUNCTION: avcodec_profile_name ( codec_id profile -- s )", "EXTERN: \"C\" char * avcodec_profile_name( int codec_id, int profile );", "	( codec_id profile -- )" );
	swigFunction( "c-function avcodec_default_execute avcodec_default_execute a a a a n n -- n", "FUNCTION: avcodec_default_execute ( c func arg ret count size -- n )", "EXTERN: \"C\" int avcodec_default_execute( void * c, void * func, void * arg, void * ret, int count, int size );", "	( c func arg ret count size -- )" );
	swigFunction( "c-function avcodec_default_execute2 avcodec_default_execute2 a a a a n -- n", "FUNCTION: avcodec_default_execute2 ( c func arg ret count -- n )", "EXTERN: \"C\" int avcodec_default_execute2( void * c, void * func, void * arg, void * ret, int count );", "	( c func arg ret count -- )" );
	swigFunction( "c-function avcodec_fill_audio_frame avcodec_fill_audio_frame a n n a n n -- n", "FUNCTION: avcodec_fill_audio_frame ( frame nb_channels sample_fmt buf buf_size align -- n )", "EXTERN: \"C\" int avcodec_fill_audio_frame( void * frame, int nb_channels, int sample_fmt, void * buf, int buf_size, int align );", "	( frame nb_channels sample_fmt buf buf_size align -- )" );
	swigFunction( "c-function avcodec_flush_buffers avcodec_flush_buffers a -- void", "FUNCTION: avcodec_flush_buffers ( avctx -- void )", "EXTERN: \"C\" void avcodec_flush_buffers( void * avctx );", "	( avctx -- )" );
	swigFunction( "c-function av_get_bits_per_sample av_get_bits_per_sample n -- n", "FUNCTION: av_get_bits_per_sample ( codec_id -- n )", "EXTERN: \"C\" int av_get_bits_per_sample( int codec_id );", "	( codec_id -- )" );
	swigFunction( "c-function av_get_pcm_codec av_get_pcm_codec n n -- n", "FUNCTION: av_get_pcm_codec ( fmt be -- n )", "EXTERN: \"C\" int av_get_pcm_codec( int fmt, int be );", "	( fmt be -- )" );
	swigFunction( "c-function av_get_exact_bits_per_sample av_get_exact_bits_per_sample n -- n", "FUNCTION: av_get_exact_bits_per_sample ( codec_id -- n )", "EXTERN: \"C\" int av_get_exact_bits_per_sample( int codec_id );", "	( codec_id -- )" );
	swigFunction( "c-function av_get_audio_frame_duration av_get_audio_frame_duration a n -- n", "FUNCTION: av_get_audio_frame_duration ( avctx frame_bytes -- n )", "EXTERN: \"C\" int av_get_audio_frame_duration( void * avctx, int frame_bytes );", "	( avctx frame_bytes -- )" );
	swigFunction( "c-function av_get_audio_frame_duration2 av_get_audio_frame_duration2 a n -- n", "FUNCTION: av_get_audio_frame_duration2 ( par frame_bytes -- n )", "EXTERN: \"C\" int av_get_audio_frame_duration2( void * par, int frame_bytes );", "	( par frame_bytes -- )" );
	swigFunction( "c-function av_bsf_get_by_name av_bsf_get_by_name s -- a", "FUNCTION: av_bsf_get_by_name ( name -- a )", "EXTERN: \"C\" void * av_bsf_get_by_name( char * name );", "	( name -- )" );
	swigFunction( "c-function av_bsf_iterate av_bsf_iterate a -- a", "FUNCTION: av_bsf_iterate ( opaque -- a )", "EXTERN: \"C\" void * av_bsf_iterate( void * opaque );", "	( opaque -- )" );
	swigFunction( "c-function av_bsf_alloc av_bsf_alloc a a -- n", "FUNCTION: av_bsf_alloc ( filter ctx -- n )", "EXTERN: \"C\" int av_bsf_alloc( void * filter, void * ctx );", "	( filter ctx -- )" );
	swigFunction( "c-function av_bsf_init av_bsf_init a -- n", "FUNCTION: av_bsf_init ( ctx -- n )", "EXTERN: \"C\" int av_bsf_init( void * ctx );", "	( ctx -- )" );
	swigFunction( "c-function av_bsf_send_packet av_bsf_send_packet a a -- n", "FUNCTION: av_bsf_send_packet ( ctx pkt -- n )", "EXTERN: \"C\" int av_bsf_send_packet( void * ctx, void * pkt );", "	( ctx pkt -- )" );
	swigFunction( "c-function av_bsf_receive_packet av_bsf_receive_packet a a -- n", "FUNCTION: av_bsf_receive_packet ( ctx pkt -- n )", "EXTERN: \"C\" int av_bsf_receive_packet( void * ctx, void * pkt );", "	( ctx pkt -- )" );
	swigFunction( "c-function av_bsf_flush av_bsf_flush a -- void", "FUNCTION: av_bsf_flush ( ctx -- void )", "EXTERN: \"C\" void av_bsf_flush( void * ctx );", "	( ctx -- )" );
	swigFunction( "c-function av_bsf_free av_bsf_free a -- void", "FUNCTION: av_bsf_free ( ctx -- void )", "EXTERN: \"C\" void av_bsf_free( void * ctx );", "	( ctx -- )" );
	swigFunction( "c-function av_bsf_get_class av_bsf_get_class  -- a", "FUNCTION: av_bsf_get_class (  -- a )", "EXTERN: \"C\" void * av_bsf_get_class(  );", "	( -- )" );
	swigFunction( "c-function av_bsf_list_alloc av_bsf_list_alloc  -- a", "FUNCTION: av_bsf_list_alloc (  -- a )", "EXTERN: \"C\" void * av_bsf_list_alloc(  );", "	( -- )" );
	swigFunction( "c-function av_bsf_list_free av_bsf_list_free a -- void", "FUNCTION: av_bsf_list_free ( lst -- void )", "EXTERN: \"C\" void av_bsf_list_free( void * lst );", "	( lst -- )" );
	swigFunction( "c-function av_bsf_list_append av_bsf_list_append a a -- n", "FUNCTION: av_bsf_list_append ( lst bsf -- n )", "EXTERN: \"C\" int av_bsf_list_append( void * lst, void * bsf );", "	( lst bsf -- )" );
	swigFunction( "c-function av_bsf_list_append2 av_bsf_list_append2 a s a -- n", "FUNCTION: av_bsf_list_append2 ( lst bsf_name options -- n )", "EXTERN: \"C\" int av_bsf_list_append2( void * lst, char * bsf_name, void * options );", "	( lst bsf_name options -- )" );
	swigFunction( "c-function av_bsf_list_finalize av_bsf_list_finalize a a -- n", "FUNCTION: av_bsf_list_finalize ( lst bsf -- n )", "EXTERN: \"C\" int av_bsf_list_finalize( void * lst, void * bsf );", "	( lst bsf -- )" );
	swigFunction( "c-function av_bsf_list_parse_str av_bsf_list_parse_str s a -- n", "FUNCTION: av_bsf_list_parse_str ( str bsf -- n )", "EXTERN: \"C\" int av_bsf_list_parse_str( char * str, void * bsf );", "	( str bsf -- )" );
	swigFunction( "c-function av_bsf_get_null_filter av_bsf_get_null_filter a -- n", "FUNCTION: av_bsf_get_null_filter ( bsf -- n )", "EXTERN: \"C\" int av_bsf_get_null_filter( void * bsf );", "	( bsf -- )" );
	swigFunction( "c-function av_fast_padded_malloc av_fast_padded_malloc a a n -- void", "FUNCTION: av_fast_padded_malloc ( ptr size min_size -- void )", "EXTERN: \"C\" void av_fast_padded_malloc( void * ptr, void * size, n min_size );", "	( ptr size min_size -- )" );
	swigFunction( "c-function av_fast_padded_mallocz av_fast_padded_mallocz a a n -- void", "FUNCTION: av_fast_padded_mallocz ( ptr size min_size -- void )", "EXTERN: \"C\" void av_fast_padded_mallocz( void * ptr, void * size, n min_size );", "	( ptr size min_size -- )" );
	swigFunction( "c-function av_xiphlacing av_xiphlacing a u -- u", "FUNCTION: av_xiphlacing ( s v -- u )", "EXTERN: \"C\" int av_xiphlacing( void * s, int v );", "	( s v -- )" );
	swigFunction( "c-function avcodec_get_type avcodec_get_type n -- n", "FUNCTION: avcodec_get_type ( codec_id -- n )", "EXTERN: \"C\" int avcodec_get_type( int codec_id );", "	( codec_id -- )" );
	swigFunction( "c-function avcodec_get_name avcodec_get_name n -- s", "FUNCTION: avcodec_get_name ( id -- s )", "EXTERN: \"C\" char * avcodec_get_name( int id );", "	( id -- )" );
	swigFunction( "c-function avcodec_is_open avcodec_is_open a -- n", "FUNCTION: avcodec_is_open ( s -- n )", "EXTERN: \"C\" int avcodec_is_open( void * s );", "	( s -- )" );
	swigFunction( "c-function av_codec_is_encoder av_codec_is_encoder a -- n", "FUNCTION: av_codec_is_encoder ( codec -- n )", "EXTERN: \"C\" int av_codec_is_encoder( void * codec );", "	( codec -- )" );
	swigFunction( "c-function av_codec_is_decoder av_codec_is_decoder a -- n", "FUNCTION: av_codec_is_decoder ( codec -- n )", "EXTERN: \"C\" int av_codec_is_decoder( void * codec );", "	( codec -- )" );
	swigFunction( "c-function avcodec_descriptor_get avcodec_descriptor_get n -- a", "FUNCTION: avcodec_descriptor_get ( id -- a )", "EXTERN: \"C\" void * avcodec_descriptor_get( int id );", "	( id -- )" );
	swigFunction( "c-function avcodec_descriptor_next avcodec_descriptor_next a -- a", "FUNCTION: avcodec_descriptor_next ( prev -- a )", "EXTERN: \"C\" void * avcodec_descriptor_next( void * prev );", "	( prev -- )" );
	swigFunction( "c-function avcodec_descriptor_get_by_name avcodec_descriptor_get_by_name s -- a", "FUNCTION: avcodec_descriptor_get_by_name ( name -- a )", "EXTERN: \"C\" void * avcodec_descriptor_get_by_name( char * name );", "	( name -- )" );
	swigFunction( "c-function av_cpb_properties_alloc av_cpb_properties_alloc a -- a", "FUNCTION: av_cpb_properties_alloc ( size -- a )", "EXTERN: \"C\" void * av_cpb_properties_alloc( void * size );", "	( size -- )" );

	swigNewline();

	swigComment("----===< postfix >===-----\n");

	swigPrint( "end-c-library", "( none )", "( none )" );
	
	return 0;
} /* end of main */



