\ dosekey, based on:
\ ekey etc.

\ Authors: Anton Ertl, Bernd Paysan
\ Copyright (C) 2001,2007 Free Software Foundation, Inc.

\ This file is part of Gforth.

\ Gforth is free software; you can redistribute it and/or
\ modify it under the terms of the GNU General Public License
\ as published by the Free Software Foundation, either version 3
\ of the License, or (at your option) any later version.

\ This program is distributed in the hope that it will be useful,
\ but WITHOUT ANY WARRANTY; without even the implied warranty of
\ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
\ GNU General Public License for more details.

\ You should have received a copy of the GNU General Public License
\ along with this program. If not, see http://www.gnu.org/licenses/.


\ this implementation of EKEY just translates the KEY values
\ received following a null to values between 256 and 511

\ Caveats: It also translates a sequence of two codes beginning with
\ 0 if they were not generated by pressing the key.  It does not wait
\ for the second value in the sequence to arrive.

\ In a Forth implementation on DOS in which special keys are not 
\ available by a second call to KEY following a null value, this
\ code will not work.  It has only been used on Gforth 0.5

\ The dos-keycode names are compatible with pfe-0.9.14

: dos-keycode ( c "name" -- ; name execution: -- u ) 256 + constant ;

75 dos-keycode k-left
77 dos-keycode k-right
72 dos-keycode k-up
80 dos-keycode k-down
71 dos-keycode k-home
79 dos-keycode k-end
115 keycode k-prior \ note: captured by xterm
116 keycode k-next \ note: captured by xterm
82 dos-keycode k-insert \ not in pfe
\ function/keypad keys
59 dos-keycode k1
60 dos-keycode k2
61 dos-keycode k3
62 dos-keycode k4
63 dos-keycode k5
64 dos-keycode k6
65 dos-keycode k7
66 dos-keycode k8
67 dos-keycode k9
68 dos-keycode k10
133 dos-keycode k11 \ not in pfe
134 dos-keycode k12 \ not in pfe

\ shifted function/keypad keys have the same key sequences (in
\ xterm) and pfe gives the same keycodes; so use of these is
\ not portable to gforth outside of DOS
84 dos-keycode s-k1
85 dos-keycode s-k2
86 dos-keycode s-k3
87 dos-keycode s-k4
88 dos-keycode s-k5
89 dos-keycode s-k6
90 dos-keycode s-k7
91 dos-keycode s-k8
92 dos-keycode s-k9
93 dos-keycode s-k10
135 dos-keycode s-k11 \ not in pfe
136 dos-keycode s-k12 \ not in pfe

: ekey ( -- u ) \ facility-ext e-key
    key ?dup 0= if key 256 + then
;

: ekey>char ( u -- u false | c true ) \ facility-ext e-key-to-char
    dup 256 u<
;

: ekey? ( -- flag ) \ facility-ext e-key-question
    \G Return @code{true} if a keyboard event is available (use
    \G @code{ekey} to receive the event), @code{false} otherwise.
    key?
;

FALSE [IF]
   : test-ekey?
      begin
         begin
            begin key? until
         ekey? until
         .s ekey .s drop
      again
   ;
   test-ekey?
[THEN]
