/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 3.0.9
 *
 * This file is not intended to be easily readable and contains a number of
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG
 * interface file instead.
 * ----------------------------------------------------------------------------- */
#include <stdio.h>
#include <string.h>
#include <stddef.h>

// Do not edit below this line
// end-of-default-includes


#include <wayland-egl.h>
#include <wayland-cursor.h>

typedef enum{ NONE = -1, GFORTH = 0, SWIFTFORTH, VFX } SwigTargetSystem;
SwigTargetSystem swigTargetSystem = NONE;

unsigned char swigPrintStackComments = 1;

/* comments */
void swigNewline()
{
	printf( "\n" );
}

void swigComment( char *comment )
{
	printf( "\\ %s", comment );
}

/* generic print */
void swigPrint( char* gforth, char *swiftForth, char *vfx )
{
	if( swigTargetSystem == GFORTH )
		printf( "%s", gforth );
	else if( swigTargetSystem == SWIFTFORTH )
		printf( "%s", swiftForth );
	else if( swigTargetSystem == VFX )
		printf( "%s", vfx );
	printf( "\n" );
}
void swigPrintSystem( SwigTargetSystem targetSystem, char *text )
{
	if( targetSystem == swigTargetSystem )
	    printf( "%s\n", text );
}

/* constants */
void swigIntConstant( long constant, char *name )
{
	printf( "#%ld\tconstant %s\n", constant, name );
}

void swigUnsignedIntConstant( unsigned long constant, char *name )
{
	printf( "#%lu\tconstant %s\n", constant, name );
}

void swigLongConstant( long long constant, char *name )
{
	printf( "#%lld.\t2constant %s\n", constant, name );
}

void swigUnsignedLongConstant( unsigned long long constant, char *name )
{
	printf( "#%llu.\t2constant %s\n", constant, name );
}

void swigFloatConstant( double constant, char *name )
{
	char buffer[128];
	sprintf( buffer, "%f", constant );

	/* if the constant contains no exponent, add one */
	char *s;
	for( s = buffer; *s != 0; s++ )
		if( *s == 'e' || *s == 'E' )
			break;

	/* exponent found */
	if( *s != 0 )
		printf( "%s\tfconstant %s\n", buffer, name );
	/* not found */
	else
		printf( "%se0\tfconstant %s\n", buffer, name );
}

void swigStringConstant( char* constant, char *name )
{
	char c;
	printf( ": %s s\\\" ", name );
	while(( c = *constant++ ))
	{
		switch(c)
		{
			case '\b': printf( "\\b" ); break;
			case '\n': printf( "\\n" ); break;
			case '\f': printf( "\\f" ); break;
			case '\r': printf( "\\r" ); break;
			case '\t': printf( "\\t" ); break;
			case '"' : printf( "\\q" ); break;
			default:
				if(c < 0x20)
					printf("\\x%02x", c);
				else
					printf("%c", c); break;
		}
	}
	printf(	"\" ;\n" );
}

/* structs */
void swigStructField( char *name, size_t offset, size_t size )
{
	printf( "\tdrop %zu %zu +field %s\n", offset, size, name );
}

/* functions */
void swigFunction( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	if( swigTargetSystem == GFORTH )
		printf( "%s", gforth );
	else if( swigTargetSystem == SWIFTFORTH )
		printf( "%s", swiftForth );
	else if( swigTargetSystem == VFX )
		printf( "%s", vfx );

	if( swigPrintStackComments )
		printf( "%s", stackComment );

	printf( "\n" );
}

/* function pointers */
void swigFunctionPointer( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	swigFunction( gforth, swiftForth, vfx, stackComment );
}

/* callbacks */
void swigCallback( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	swigFunction( gforth, swiftForth, vfx, stackComment );
}

void swigUsage( char **argv )
{
	fprintf( stderr, "Usage: %s [-gforth|-swiftforth|-vfx]\n", argv[0] );
}

int main( int argc, char **argv )
{
	int i;

	/* check arguments */
	for( i = 1; i < argc; i++ )
		if( strcmp( argv[i], "-gforth" ) == 0 )
			swigTargetSystem = GFORTH;
		else if( strcmp( argv[i], "-swiftforth" ) == 0 )
			swigTargetSystem = SWIFTFORTH;
		else if( strcmp( argv[i], "-vfx" ) == 0 )
			swigTargetSystem = VFX;

	if( swigTargetSystem == NONE )
	{
		fprintf( stderr, "Error: no target system specified\n" );
		swigUsage( argv );
		return 1;
	}

	/* primer */
	printf( "\\ This file has been generated using SWIG and fsi,\n"
		"\\ and is already platform dependent, search for the corresponding\n"
		"\\ fsi-file to compile it where no one has compiled it before ;)\n"
		"\\ Forth systems have their own own dynamic loader and don't need addional C-Code.\n"
		"\\ That's why this file will just print normal forth-code once compiled\n"
		"\\ and can be used directly with include or require.\n"
		"\\ As all comments are stripped during the compilation, please\n"
		"\\ insert the copyright notice of the original file here.\n"
	);



	swigNewline();

	swigComment("----===< int constants >===-----\n");
	#ifdef WL_DISPLAY_SYNC
		swigIntConstant( WL_DISPLAY_SYNC, "WL_DISPLAY_SYNC" );
	#endif
	#ifdef WL_DISPLAY_GET_REGISTRY
		swigIntConstant( WL_DISPLAY_GET_REGISTRY, "WL_DISPLAY_GET_REGISTRY" );
	#endif
	#ifdef WL_DISPLAY_ERROR_SINCE_VERSION
		swigIntConstant( WL_DISPLAY_ERROR_SINCE_VERSION, "WL_DISPLAY_ERROR_SINCE_VERSION" );
	#endif
	#ifdef WL_DISPLAY_DELETE_ID_SINCE_VERSION
		swigIntConstant( WL_DISPLAY_DELETE_ID_SINCE_VERSION, "WL_DISPLAY_DELETE_ID_SINCE_VERSION" );
	#endif
	#ifdef WL_DISPLAY_SYNC_SINCE_VERSION
		swigIntConstant( WL_DISPLAY_SYNC_SINCE_VERSION, "WL_DISPLAY_SYNC_SINCE_VERSION" );
	#endif
	#ifdef WL_DISPLAY_GET_REGISTRY_SINCE_VERSION
		swigIntConstant( WL_DISPLAY_GET_REGISTRY_SINCE_VERSION, "WL_DISPLAY_GET_REGISTRY_SINCE_VERSION" );
	#endif
	#ifdef WL_REGISTRY_BIND
		swigIntConstant( WL_REGISTRY_BIND, "WL_REGISTRY_BIND" );
	#endif
	#ifdef WL_REGISTRY_GLOBAL_SINCE_VERSION
		swigIntConstant( WL_REGISTRY_GLOBAL_SINCE_VERSION, "WL_REGISTRY_GLOBAL_SINCE_VERSION" );
	#endif
	#ifdef WL_REGISTRY_GLOBAL_REMOVE_SINCE_VERSION
		swigIntConstant( WL_REGISTRY_GLOBAL_REMOVE_SINCE_VERSION, "WL_REGISTRY_GLOBAL_REMOVE_SINCE_VERSION" );
	#endif
	#ifdef WL_REGISTRY_BIND_SINCE_VERSION
		swigIntConstant( WL_REGISTRY_BIND_SINCE_VERSION, "WL_REGISTRY_BIND_SINCE_VERSION" );
	#endif
	#ifdef WL_CALLBACK_DONE_SINCE_VERSION
		swigIntConstant( WL_CALLBACK_DONE_SINCE_VERSION, "WL_CALLBACK_DONE_SINCE_VERSION" );
	#endif
	#ifdef WL_COMPOSITOR_CREATE_SURFACE
		swigIntConstant( WL_COMPOSITOR_CREATE_SURFACE, "WL_COMPOSITOR_CREATE_SURFACE" );
	#endif
	#ifdef WL_COMPOSITOR_CREATE_REGION
		swigIntConstant( WL_COMPOSITOR_CREATE_REGION, "WL_COMPOSITOR_CREATE_REGION" );
	#endif
	#ifdef WL_COMPOSITOR_CREATE_SURFACE_SINCE_VERSION
		swigIntConstant( WL_COMPOSITOR_CREATE_SURFACE_SINCE_VERSION, "WL_COMPOSITOR_CREATE_SURFACE_SINCE_VERSION" );
	#endif
	#ifdef WL_COMPOSITOR_CREATE_REGION_SINCE_VERSION
		swigIntConstant( WL_COMPOSITOR_CREATE_REGION_SINCE_VERSION, "WL_COMPOSITOR_CREATE_REGION_SINCE_VERSION" );
	#endif
	#ifdef WL_SHM_POOL_CREATE_BUFFER
		swigIntConstant( WL_SHM_POOL_CREATE_BUFFER, "WL_SHM_POOL_CREATE_BUFFER" );
	#endif
	#ifdef WL_SHM_POOL_DESTROY
		swigIntConstant( WL_SHM_POOL_DESTROY, "WL_SHM_POOL_DESTROY" );
	#endif
	#ifdef WL_SHM_POOL_RESIZE
		swigIntConstant( WL_SHM_POOL_RESIZE, "WL_SHM_POOL_RESIZE" );
	#endif
	#ifdef WL_SHM_POOL_CREATE_BUFFER_SINCE_VERSION
		swigIntConstant( WL_SHM_POOL_CREATE_BUFFER_SINCE_VERSION, "WL_SHM_POOL_CREATE_BUFFER_SINCE_VERSION" );
	#endif
	#ifdef WL_SHM_POOL_DESTROY_SINCE_VERSION
		swigIntConstant( WL_SHM_POOL_DESTROY_SINCE_VERSION, "WL_SHM_POOL_DESTROY_SINCE_VERSION" );
	#endif
	#ifdef WL_SHM_POOL_RESIZE_SINCE_VERSION
		swigIntConstant( WL_SHM_POOL_RESIZE_SINCE_VERSION, "WL_SHM_POOL_RESIZE_SINCE_VERSION" );
	#endif
	#ifdef WL_SHM_CREATE_POOL
		swigIntConstant( WL_SHM_CREATE_POOL, "WL_SHM_CREATE_POOL" );
	#endif
	#ifdef WL_SHM_FORMAT_SINCE_VERSION
		swigIntConstant( WL_SHM_FORMAT_SINCE_VERSION, "WL_SHM_FORMAT_SINCE_VERSION" );
	#endif
	#ifdef WL_SHM_CREATE_POOL_SINCE_VERSION
		swigIntConstant( WL_SHM_CREATE_POOL_SINCE_VERSION, "WL_SHM_CREATE_POOL_SINCE_VERSION" );
	#endif
	#ifdef WL_BUFFER_DESTROY
		swigIntConstant( WL_BUFFER_DESTROY, "WL_BUFFER_DESTROY" );
	#endif
	#ifdef WL_BUFFER_RELEASE_SINCE_VERSION
		swigIntConstant( WL_BUFFER_RELEASE_SINCE_VERSION, "WL_BUFFER_RELEASE_SINCE_VERSION" );
	#endif
	#ifdef WL_BUFFER_DESTROY_SINCE_VERSION
		swigIntConstant( WL_BUFFER_DESTROY_SINCE_VERSION, "WL_BUFFER_DESTROY_SINCE_VERSION" );
	#endif
	#ifdef WL_DATA_OFFER_ACCEPT
		swigIntConstant( WL_DATA_OFFER_ACCEPT, "WL_DATA_OFFER_ACCEPT" );
	#endif
	#ifdef WL_DATA_OFFER_RECEIVE
		swigIntConstant( WL_DATA_OFFER_RECEIVE, "WL_DATA_OFFER_RECEIVE" );
	#endif
	#ifdef WL_DATA_OFFER_DESTROY
		swigIntConstant( WL_DATA_OFFER_DESTROY, "WL_DATA_OFFER_DESTROY" );
	#endif
	#ifdef WL_DATA_OFFER_FINISH
		swigIntConstant( WL_DATA_OFFER_FINISH, "WL_DATA_OFFER_FINISH" );
	#endif
	#ifdef WL_DATA_OFFER_SET_ACTIONS
		swigIntConstant( WL_DATA_OFFER_SET_ACTIONS, "WL_DATA_OFFER_SET_ACTIONS" );
	#endif
	#ifdef WL_DATA_OFFER_OFFER_SINCE_VERSION
		swigIntConstant( WL_DATA_OFFER_OFFER_SINCE_VERSION, "WL_DATA_OFFER_OFFER_SINCE_VERSION" );
	#endif
	#ifdef WL_DATA_OFFER_SOURCE_ACTIONS_SINCE_VERSION
		swigIntConstant( WL_DATA_OFFER_SOURCE_ACTIONS_SINCE_VERSION, "WL_DATA_OFFER_SOURCE_ACTIONS_SINCE_VERSION" );
	#endif
	#ifdef WL_DATA_OFFER_ACTION_SINCE_VERSION
		swigIntConstant( WL_DATA_OFFER_ACTION_SINCE_VERSION, "WL_DATA_OFFER_ACTION_SINCE_VERSION" );
	#endif
	#ifdef WL_DATA_OFFER_ACCEPT_SINCE_VERSION
		swigIntConstant( WL_DATA_OFFER_ACCEPT_SINCE_VERSION, "WL_DATA_OFFER_ACCEPT_SINCE_VERSION" );
	#endif
	#ifdef WL_DATA_OFFER_RECEIVE_SINCE_VERSION
		swigIntConstant( WL_DATA_OFFER_RECEIVE_SINCE_VERSION, "WL_DATA_OFFER_RECEIVE_SINCE_VERSION" );
	#endif
	#ifdef WL_DATA_OFFER_DESTROY_SINCE_VERSION
		swigIntConstant( WL_DATA_OFFER_DESTROY_SINCE_VERSION, "WL_DATA_OFFER_DESTROY_SINCE_VERSION" );
	#endif
	#ifdef WL_DATA_OFFER_FINISH_SINCE_VERSION
		swigIntConstant( WL_DATA_OFFER_FINISH_SINCE_VERSION, "WL_DATA_OFFER_FINISH_SINCE_VERSION" );
	#endif
	#ifdef WL_DATA_OFFER_SET_ACTIONS_SINCE_VERSION
		swigIntConstant( WL_DATA_OFFER_SET_ACTIONS_SINCE_VERSION, "WL_DATA_OFFER_SET_ACTIONS_SINCE_VERSION" );
	#endif
	#ifdef WL_DATA_SOURCE_OFFER
		swigIntConstant( WL_DATA_SOURCE_OFFER, "WL_DATA_SOURCE_OFFER" );
	#endif
	#ifdef WL_DATA_SOURCE_DESTROY
		swigIntConstant( WL_DATA_SOURCE_DESTROY, "WL_DATA_SOURCE_DESTROY" );
	#endif
	#ifdef WL_DATA_SOURCE_SET_ACTIONS
		swigIntConstant( WL_DATA_SOURCE_SET_ACTIONS, "WL_DATA_SOURCE_SET_ACTIONS" );
	#endif
	#ifdef WL_DATA_SOURCE_TARGET_SINCE_VERSION
		swigIntConstant( WL_DATA_SOURCE_TARGET_SINCE_VERSION, "WL_DATA_SOURCE_TARGET_SINCE_VERSION" );
	#endif
	#ifdef WL_DATA_SOURCE_SEND_SINCE_VERSION
		swigIntConstant( WL_DATA_SOURCE_SEND_SINCE_VERSION, "WL_DATA_SOURCE_SEND_SINCE_VERSION" );
	#endif
	#ifdef WL_DATA_SOURCE_CANCELLED_SINCE_VERSION
		swigIntConstant( WL_DATA_SOURCE_CANCELLED_SINCE_VERSION, "WL_DATA_SOURCE_CANCELLED_SINCE_VERSION" );
	#endif
	#ifdef WL_DATA_SOURCE_DND_DROP_PERFORMED_SINCE_VERSION
		swigIntConstant( WL_DATA_SOURCE_DND_DROP_PERFORMED_SINCE_VERSION, "WL_DATA_SOURCE_DND_DROP_PERFORMED_SINCE_VERSION" );
	#endif
	#ifdef WL_DATA_SOURCE_DND_FINISHED_SINCE_VERSION
		swigIntConstant( WL_DATA_SOURCE_DND_FINISHED_SINCE_VERSION, "WL_DATA_SOURCE_DND_FINISHED_SINCE_VERSION" );
	#endif
	#ifdef WL_DATA_SOURCE_ACTION_SINCE_VERSION
		swigIntConstant( WL_DATA_SOURCE_ACTION_SINCE_VERSION, "WL_DATA_SOURCE_ACTION_SINCE_VERSION" );
	#endif
	#ifdef WL_DATA_SOURCE_OFFER_SINCE_VERSION
		swigIntConstant( WL_DATA_SOURCE_OFFER_SINCE_VERSION, "WL_DATA_SOURCE_OFFER_SINCE_VERSION" );
	#endif
	#ifdef WL_DATA_SOURCE_DESTROY_SINCE_VERSION
		swigIntConstant( WL_DATA_SOURCE_DESTROY_SINCE_VERSION, "WL_DATA_SOURCE_DESTROY_SINCE_VERSION" );
	#endif
	#ifdef WL_DATA_SOURCE_SET_ACTIONS_SINCE_VERSION
		swigIntConstant( WL_DATA_SOURCE_SET_ACTIONS_SINCE_VERSION, "WL_DATA_SOURCE_SET_ACTIONS_SINCE_VERSION" );
	#endif
	#ifdef WL_DATA_DEVICE_START_DRAG
		swigIntConstant( WL_DATA_DEVICE_START_DRAG, "WL_DATA_DEVICE_START_DRAG" );
	#endif
	#ifdef WL_DATA_DEVICE_SET_SELECTION
		swigIntConstant( WL_DATA_DEVICE_SET_SELECTION, "WL_DATA_DEVICE_SET_SELECTION" );
	#endif
	#ifdef WL_DATA_DEVICE_RELEASE
		swigIntConstant( WL_DATA_DEVICE_RELEASE, "WL_DATA_DEVICE_RELEASE" );
	#endif
	#ifdef WL_DATA_DEVICE_DATA_OFFER_SINCE_VERSION
		swigIntConstant( WL_DATA_DEVICE_DATA_OFFER_SINCE_VERSION, "WL_DATA_DEVICE_DATA_OFFER_SINCE_VERSION" );
	#endif
	#ifdef WL_DATA_DEVICE_ENTER_SINCE_VERSION
		swigIntConstant( WL_DATA_DEVICE_ENTER_SINCE_VERSION, "WL_DATA_DEVICE_ENTER_SINCE_VERSION" );
	#endif
	#ifdef WL_DATA_DEVICE_LEAVE_SINCE_VERSION
		swigIntConstant( WL_DATA_DEVICE_LEAVE_SINCE_VERSION, "WL_DATA_DEVICE_LEAVE_SINCE_VERSION" );
	#endif
	#ifdef WL_DATA_DEVICE_MOTION_SINCE_VERSION
		swigIntConstant( WL_DATA_DEVICE_MOTION_SINCE_VERSION, "WL_DATA_DEVICE_MOTION_SINCE_VERSION" );
	#endif
	#ifdef WL_DATA_DEVICE_DROP_SINCE_VERSION
		swigIntConstant( WL_DATA_DEVICE_DROP_SINCE_VERSION, "WL_DATA_DEVICE_DROP_SINCE_VERSION" );
	#endif
	#ifdef WL_DATA_DEVICE_SELECTION_SINCE_VERSION
		swigIntConstant( WL_DATA_DEVICE_SELECTION_SINCE_VERSION, "WL_DATA_DEVICE_SELECTION_SINCE_VERSION" );
	#endif
	#ifdef WL_DATA_DEVICE_START_DRAG_SINCE_VERSION
		swigIntConstant( WL_DATA_DEVICE_START_DRAG_SINCE_VERSION, "WL_DATA_DEVICE_START_DRAG_SINCE_VERSION" );
	#endif
	#ifdef WL_DATA_DEVICE_SET_SELECTION_SINCE_VERSION
		swigIntConstant( WL_DATA_DEVICE_SET_SELECTION_SINCE_VERSION, "WL_DATA_DEVICE_SET_SELECTION_SINCE_VERSION" );
	#endif
	#ifdef WL_DATA_DEVICE_RELEASE_SINCE_VERSION
		swigIntConstant( WL_DATA_DEVICE_RELEASE_SINCE_VERSION, "WL_DATA_DEVICE_RELEASE_SINCE_VERSION" );
	#endif
	#ifdef WL_DATA_DEVICE_MANAGER_CREATE_DATA_SOURCE
		swigIntConstant( WL_DATA_DEVICE_MANAGER_CREATE_DATA_SOURCE, "WL_DATA_DEVICE_MANAGER_CREATE_DATA_SOURCE" );
	#endif
	#ifdef WL_DATA_DEVICE_MANAGER_GET_DATA_DEVICE
		swigIntConstant( WL_DATA_DEVICE_MANAGER_GET_DATA_DEVICE, "WL_DATA_DEVICE_MANAGER_GET_DATA_DEVICE" );
	#endif
	#ifdef WL_DATA_DEVICE_MANAGER_CREATE_DATA_SOURCE_SINCE_VERSION
		swigIntConstant( WL_DATA_DEVICE_MANAGER_CREATE_DATA_SOURCE_SINCE_VERSION, "WL_DATA_DEVICE_MANAGER_CREATE_DATA_SOURCE_SINCE_VERSION" );
	#endif
	#ifdef WL_DATA_DEVICE_MANAGER_GET_DATA_DEVICE_SINCE_VERSION
		swigIntConstant( WL_DATA_DEVICE_MANAGER_GET_DATA_DEVICE_SINCE_VERSION, "WL_DATA_DEVICE_MANAGER_GET_DATA_DEVICE_SINCE_VERSION" );
	#endif
	#ifdef WL_SHELL_GET_SHELL_SURFACE
		swigIntConstant( WL_SHELL_GET_SHELL_SURFACE, "WL_SHELL_GET_SHELL_SURFACE" );
	#endif
	#ifdef WL_SHELL_GET_SHELL_SURFACE_SINCE_VERSION
		swigIntConstant( WL_SHELL_GET_SHELL_SURFACE_SINCE_VERSION, "WL_SHELL_GET_SHELL_SURFACE_SINCE_VERSION" );
	#endif
	#ifdef WL_SHELL_SURFACE_PONG
		swigIntConstant( WL_SHELL_SURFACE_PONG, "WL_SHELL_SURFACE_PONG" );
	#endif
	#ifdef WL_SHELL_SURFACE_MOVE
		swigIntConstant( WL_SHELL_SURFACE_MOVE, "WL_SHELL_SURFACE_MOVE" );
	#endif
	#ifdef WL_SHELL_SURFACE_RESIZE
		swigIntConstant( WL_SHELL_SURFACE_RESIZE, "WL_SHELL_SURFACE_RESIZE" );
	#endif
	#ifdef WL_SHELL_SURFACE_SET_TOPLEVEL
		swigIntConstant( WL_SHELL_SURFACE_SET_TOPLEVEL, "WL_SHELL_SURFACE_SET_TOPLEVEL" );
	#endif
	#ifdef WL_SHELL_SURFACE_SET_TRANSIENT
		swigIntConstant( WL_SHELL_SURFACE_SET_TRANSIENT, "WL_SHELL_SURFACE_SET_TRANSIENT" );
	#endif
	#ifdef WL_SHELL_SURFACE_SET_FULLSCREEN
		swigIntConstant( WL_SHELL_SURFACE_SET_FULLSCREEN, "WL_SHELL_SURFACE_SET_FULLSCREEN" );
	#endif
	#ifdef WL_SHELL_SURFACE_SET_POPUP
		swigIntConstant( WL_SHELL_SURFACE_SET_POPUP, "WL_SHELL_SURFACE_SET_POPUP" );
	#endif
	#ifdef WL_SHELL_SURFACE_SET_MAXIMIZED
		swigIntConstant( WL_SHELL_SURFACE_SET_MAXIMIZED, "WL_SHELL_SURFACE_SET_MAXIMIZED" );
	#endif
	#ifdef WL_SHELL_SURFACE_SET_TITLE
		swigIntConstant( WL_SHELL_SURFACE_SET_TITLE, "WL_SHELL_SURFACE_SET_TITLE" );
	#endif
	#ifdef WL_SHELL_SURFACE_SET_CLASS
		swigIntConstant( WL_SHELL_SURFACE_SET_CLASS, "WL_SHELL_SURFACE_SET_CLASS" );
	#endif
	#ifdef WL_SHELL_SURFACE_PING_SINCE_VERSION
		swigIntConstant( WL_SHELL_SURFACE_PING_SINCE_VERSION, "WL_SHELL_SURFACE_PING_SINCE_VERSION" );
	#endif
	#ifdef WL_SHELL_SURFACE_CONFIGURE_SINCE_VERSION
		swigIntConstant( WL_SHELL_SURFACE_CONFIGURE_SINCE_VERSION, "WL_SHELL_SURFACE_CONFIGURE_SINCE_VERSION" );
	#endif
	#ifdef WL_SHELL_SURFACE_POPUP_DONE_SINCE_VERSION
		swigIntConstant( WL_SHELL_SURFACE_POPUP_DONE_SINCE_VERSION, "WL_SHELL_SURFACE_POPUP_DONE_SINCE_VERSION" );
	#endif
	#ifdef WL_SHELL_SURFACE_PONG_SINCE_VERSION
		swigIntConstant( WL_SHELL_SURFACE_PONG_SINCE_VERSION, "WL_SHELL_SURFACE_PONG_SINCE_VERSION" );
	#endif
	#ifdef WL_SHELL_SURFACE_MOVE_SINCE_VERSION
		swigIntConstant( WL_SHELL_SURFACE_MOVE_SINCE_VERSION, "WL_SHELL_SURFACE_MOVE_SINCE_VERSION" );
	#endif
	#ifdef WL_SHELL_SURFACE_RESIZE_SINCE_VERSION
		swigIntConstant( WL_SHELL_SURFACE_RESIZE_SINCE_VERSION, "WL_SHELL_SURFACE_RESIZE_SINCE_VERSION" );
	#endif
	#ifdef WL_SHELL_SURFACE_SET_TOPLEVEL_SINCE_VERSION
		swigIntConstant( WL_SHELL_SURFACE_SET_TOPLEVEL_SINCE_VERSION, "WL_SHELL_SURFACE_SET_TOPLEVEL_SINCE_VERSION" );
	#endif
	#ifdef WL_SHELL_SURFACE_SET_TRANSIENT_SINCE_VERSION
		swigIntConstant( WL_SHELL_SURFACE_SET_TRANSIENT_SINCE_VERSION, "WL_SHELL_SURFACE_SET_TRANSIENT_SINCE_VERSION" );
	#endif
	#ifdef WL_SHELL_SURFACE_SET_FULLSCREEN_SINCE_VERSION
		swigIntConstant( WL_SHELL_SURFACE_SET_FULLSCREEN_SINCE_VERSION, "WL_SHELL_SURFACE_SET_FULLSCREEN_SINCE_VERSION" );
	#endif
	#ifdef WL_SHELL_SURFACE_SET_POPUP_SINCE_VERSION
		swigIntConstant( WL_SHELL_SURFACE_SET_POPUP_SINCE_VERSION, "WL_SHELL_SURFACE_SET_POPUP_SINCE_VERSION" );
	#endif
	#ifdef WL_SHELL_SURFACE_SET_MAXIMIZED_SINCE_VERSION
		swigIntConstant( WL_SHELL_SURFACE_SET_MAXIMIZED_SINCE_VERSION, "WL_SHELL_SURFACE_SET_MAXIMIZED_SINCE_VERSION" );
	#endif
	#ifdef WL_SHELL_SURFACE_SET_TITLE_SINCE_VERSION
		swigIntConstant( WL_SHELL_SURFACE_SET_TITLE_SINCE_VERSION, "WL_SHELL_SURFACE_SET_TITLE_SINCE_VERSION" );
	#endif
	#ifdef WL_SHELL_SURFACE_SET_CLASS_SINCE_VERSION
		swigIntConstant( WL_SHELL_SURFACE_SET_CLASS_SINCE_VERSION, "WL_SHELL_SURFACE_SET_CLASS_SINCE_VERSION" );
	#endif
	#ifdef WL_SURFACE_DESTROY
		swigIntConstant( WL_SURFACE_DESTROY, "WL_SURFACE_DESTROY" );
	#endif
	#ifdef WL_SURFACE_ATTACH
		swigIntConstant( WL_SURFACE_ATTACH, "WL_SURFACE_ATTACH" );
	#endif
	#ifdef WL_SURFACE_DAMAGE
		swigIntConstant( WL_SURFACE_DAMAGE, "WL_SURFACE_DAMAGE" );
	#endif
	#ifdef WL_SURFACE_FRAME
		swigIntConstant( WL_SURFACE_FRAME, "WL_SURFACE_FRAME" );
	#endif
	#ifdef WL_SURFACE_SET_OPAQUE_REGION
		swigIntConstant( WL_SURFACE_SET_OPAQUE_REGION, "WL_SURFACE_SET_OPAQUE_REGION" );
	#endif
	#ifdef WL_SURFACE_SET_INPUT_REGION
		swigIntConstant( WL_SURFACE_SET_INPUT_REGION, "WL_SURFACE_SET_INPUT_REGION" );
	#endif
	#ifdef WL_SURFACE_COMMIT
		swigIntConstant( WL_SURFACE_COMMIT, "WL_SURFACE_COMMIT" );
	#endif
	#ifdef WL_SURFACE_SET_BUFFER_TRANSFORM
		swigIntConstant( WL_SURFACE_SET_BUFFER_TRANSFORM, "WL_SURFACE_SET_BUFFER_TRANSFORM" );
	#endif
	#ifdef WL_SURFACE_SET_BUFFER_SCALE
		swigIntConstant( WL_SURFACE_SET_BUFFER_SCALE, "WL_SURFACE_SET_BUFFER_SCALE" );
	#endif
	#ifdef WL_SURFACE_DAMAGE_BUFFER
		swigIntConstant( WL_SURFACE_DAMAGE_BUFFER, "WL_SURFACE_DAMAGE_BUFFER" );
	#endif
	#ifdef WL_SURFACE_ENTER_SINCE_VERSION
		swigIntConstant( WL_SURFACE_ENTER_SINCE_VERSION, "WL_SURFACE_ENTER_SINCE_VERSION" );
	#endif
	#ifdef WL_SURFACE_LEAVE_SINCE_VERSION
		swigIntConstant( WL_SURFACE_LEAVE_SINCE_VERSION, "WL_SURFACE_LEAVE_SINCE_VERSION" );
	#endif
	#ifdef WL_SURFACE_DESTROY_SINCE_VERSION
		swigIntConstant( WL_SURFACE_DESTROY_SINCE_VERSION, "WL_SURFACE_DESTROY_SINCE_VERSION" );
	#endif
	#ifdef WL_SURFACE_ATTACH_SINCE_VERSION
		swigIntConstant( WL_SURFACE_ATTACH_SINCE_VERSION, "WL_SURFACE_ATTACH_SINCE_VERSION" );
	#endif
	#ifdef WL_SURFACE_DAMAGE_SINCE_VERSION
		swigIntConstant( WL_SURFACE_DAMAGE_SINCE_VERSION, "WL_SURFACE_DAMAGE_SINCE_VERSION" );
	#endif
	#ifdef WL_SURFACE_FRAME_SINCE_VERSION
		swigIntConstant( WL_SURFACE_FRAME_SINCE_VERSION, "WL_SURFACE_FRAME_SINCE_VERSION" );
	#endif
	#ifdef WL_SURFACE_SET_OPAQUE_REGION_SINCE_VERSION
		swigIntConstant( WL_SURFACE_SET_OPAQUE_REGION_SINCE_VERSION, "WL_SURFACE_SET_OPAQUE_REGION_SINCE_VERSION" );
	#endif
	#ifdef WL_SURFACE_SET_INPUT_REGION_SINCE_VERSION
		swigIntConstant( WL_SURFACE_SET_INPUT_REGION_SINCE_VERSION, "WL_SURFACE_SET_INPUT_REGION_SINCE_VERSION" );
	#endif
	#ifdef WL_SURFACE_COMMIT_SINCE_VERSION
		swigIntConstant( WL_SURFACE_COMMIT_SINCE_VERSION, "WL_SURFACE_COMMIT_SINCE_VERSION" );
	#endif
	#ifdef WL_SURFACE_SET_BUFFER_TRANSFORM_SINCE_VERSION
		swigIntConstant( WL_SURFACE_SET_BUFFER_TRANSFORM_SINCE_VERSION, "WL_SURFACE_SET_BUFFER_TRANSFORM_SINCE_VERSION" );
	#endif
	#ifdef WL_SURFACE_SET_BUFFER_SCALE_SINCE_VERSION
		swigIntConstant( WL_SURFACE_SET_BUFFER_SCALE_SINCE_VERSION, "WL_SURFACE_SET_BUFFER_SCALE_SINCE_VERSION" );
	#endif
	#ifdef WL_SURFACE_DAMAGE_BUFFER_SINCE_VERSION
		swigIntConstant( WL_SURFACE_DAMAGE_BUFFER_SINCE_VERSION, "WL_SURFACE_DAMAGE_BUFFER_SINCE_VERSION" );
	#endif
	#ifdef WL_SEAT_GET_POINTER
		swigIntConstant( WL_SEAT_GET_POINTER, "WL_SEAT_GET_POINTER" );
	#endif
	#ifdef WL_SEAT_GET_KEYBOARD
		swigIntConstant( WL_SEAT_GET_KEYBOARD, "WL_SEAT_GET_KEYBOARD" );
	#endif
	#ifdef WL_SEAT_GET_TOUCH
		swigIntConstant( WL_SEAT_GET_TOUCH, "WL_SEAT_GET_TOUCH" );
	#endif
	#ifdef WL_SEAT_RELEASE
		swigIntConstant( WL_SEAT_RELEASE, "WL_SEAT_RELEASE" );
	#endif
	#ifdef WL_SEAT_CAPABILITIES_SINCE_VERSION
		swigIntConstant( WL_SEAT_CAPABILITIES_SINCE_VERSION, "WL_SEAT_CAPABILITIES_SINCE_VERSION" );
	#endif
	#ifdef WL_SEAT_NAME_SINCE_VERSION
		swigIntConstant( WL_SEAT_NAME_SINCE_VERSION, "WL_SEAT_NAME_SINCE_VERSION" );
	#endif
	#ifdef WL_SEAT_GET_POINTER_SINCE_VERSION
		swigIntConstant( WL_SEAT_GET_POINTER_SINCE_VERSION, "WL_SEAT_GET_POINTER_SINCE_VERSION" );
	#endif
	#ifdef WL_SEAT_GET_KEYBOARD_SINCE_VERSION
		swigIntConstant( WL_SEAT_GET_KEYBOARD_SINCE_VERSION, "WL_SEAT_GET_KEYBOARD_SINCE_VERSION" );
	#endif
	#ifdef WL_SEAT_GET_TOUCH_SINCE_VERSION
		swigIntConstant( WL_SEAT_GET_TOUCH_SINCE_VERSION, "WL_SEAT_GET_TOUCH_SINCE_VERSION" );
	#endif
	#ifdef WL_SEAT_RELEASE_SINCE_VERSION
		swigIntConstant( WL_SEAT_RELEASE_SINCE_VERSION, "WL_SEAT_RELEASE_SINCE_VERSION" );
	#endif
	#ifdef WL_POINTER_AXIS_SOURCE_WHEEL_TILT_SINCE_VERSION
		swigIntConstant( WL_POINTER_AXIS_SOURCE_WHEEL_TILT_SINCE_VERSION, "WL_POINTER_AXIS_SOURCE_WHEEL_TILT_SINCE_VERSION" );
	#endif
	#ifdef WL_POINTER_SET_CURSOR
		swigIntConstant( WL_POINTER_SET_CURSOR, "WL_POINTER_SET_CURSOR" );
	#endif
	#ifdef WL_POINTER_RELEASE
		swigIntConstant( WL_POINTER_RELEASE, "WL_POINTER_RELEASE" );
	#endif
	#ifdef WL_POINTER_ENTER_SINCE_VERSION
		swigIntConstant( WL_POINTER_ENTER_SINCE_VERSION, "WL_POINTER_ENTER_SINCE_VERSION" );
	#endif
	#ifdef WL_POINTER_LEAVE_SINCE_VERSION
		swigIntConstant( WL_POINTER_LEAVE_SINCE_VERSION, "WL_POINTER_LEAVE_SINCE_VERSION" );
	#endif
	#ifdef WL_POINTER_MOTION_SINCE_VERSION
		swigIntConstant( WL_POINTER_MOTION_SINCE_VERSION, "WL_POINTER_MOTION_SINCE_VERSION" );
	#endif
	#ifdef WL_POINTER_BUTTON_SINCE_VERSION
		swigIntConstant( WL_POINTER_BUTTON_SINCE_VERSION, "WL_POINTER_BUTTON_SINCE_VERSION" );
	#endif
	#ifdef WL_POINTER_AXIS_SINCE_VERSION
		swigIntConstant( WL_POINTER_AXIS_SINCE_VERSION, "WL_POINTER_AXIS_SINCE_VERSION" );
	#endif
	#ifdef WL_POINTER_FRAME_SINCE_VERSION
		swigIntConstant( WL_POINTER_FRAME_SINCE_VERSION, "WL_POINTER_FRAME_SINCE_VERSION" );
	#endif
	#ifdef WL_POINTER_AXIS_SOURCE_SINCE_VERSION
		swigIntConstant( WL_POINTER_AXIS_SOURCE_SINCE_VERSION, "WL_POINTER_AXIS_SOURCE_SINCE_VERSION" );
	#endif
	#ifdef WL_POINTER_AXIS_STOP_SINCE_VERSION
		swigIntConstant( WL_POINTER_AXIS_STOP_SINCE_VERSION, "WL_POINTER_AXIS_STOP_SINCE_VERSION" );
	#endif
	#ifdef WL_POINTER_AXIS_DISCRETE_SINCE_VERSION
		swigIntConstant( WL_POINTER_AXIS_DISCRETE_SINCE_VERSION, "WL_POINTER_AXIS_DISCRETE_SINCE_VERSION" );
	#endif
	#ifdef WL_POINTER_SET_CURSOR_SINCE_VERSION
		swigIntConstant( WL_POINTER_SET_CURSOR_SINCE_VERSION, "WL_POINTER_SET_CURSOR_SINCE_VERSION" );
	#endif
	#ifdef WL_POINTER_RELEASE_SINCE_VERSION
		swigIntConstant( WL_POINTER_RELEASE_SINCE_VERSION, "WL_POINTER_RELEASE_SINCE_VERSION" );
	#endif
	#ifdef WL_KEYBOARD_RELEASE
		swigIntConstant( WL_KEYBOARD_RELEASE, "WL_KEYBOARD_RELEASE" );
	#endif
	#ifdef WL_KEYBOARD_KEYMAP_SINCE_VERSION
		swigIntConstant( WL_KEYBOARD_KEYMAP_SINCE_VERSION, "WL_KEYBOARD_KEYMAP_SINCE_VERSION" );
	#endif
	#ifdef WL_KEYBOARD_ENTER_SINCE_VERSION
		swigIntConstant( WL_KEYBOARD_ENTER_SINCE_VERSION, "WL_KEYBOARD_ENTER_SINCE_VERSION" );
	#endif
	#ifdef WL_KEYBOARD_LEAVE_SINCE_VERSION
		swigIntConstant( WL_KEYBOARD_LEAVE_SINCE_VERSION, "WL_KEYBOARD_LEAVE_SINCE_VERSION" );
	#endif
	#ifdef WL_KEYBOARD_KEY_SINCE_VERSION
		swigIntConstant( WL_KEYBOARD_KEY_SINCE_VERSION, "WL_KEYBOARD_KEY_SINCE_VERSION" );
	#endif
	#ifdef WL_KEYBOARD_MODIFIERS_SINCE_VERSION
		swigIntConstant( WL_KEYBOARD_MODIFIERS_SINCE_VERSION, "WL_KEYBOARD_MODIFIERS_SINCE_VERSION" );
	#endif
	#ifdef WL_KEYBOARD_REPEAT_INFO_SINCE_VERSION
		swigIntConstant( WL_KEYBOARD_REPEAT_INFO_SINCE_VERSION, "WL_KEYBOARD_REPEAT_INFO_SINCE_VERSION" );
	#endif
	#ifdef WL_KEYBOARD_RELEASE_SINCE_VERSION
		swigIntConstant( WL_KEYBOARD_RELEASE_SINCE_VERSION, "WL_KEYBOARD_RELEASE_SINCE_VERSION" );
	#endif
	#ifdef WL_TOUCH_RELEASE
		swigIntConstant( WL_TOUCH_RELEASE, "WL_TOUCH_RELEASE" );
	#endif
	#ifdef WL_TOUCH_DOWN_SINCE_VERSION
		swigIntConstant( WL_TOUCH_DOWN_SINCE_VERSION, "WL_TOUCH_DOWN_SINCE_VERSION" );
	#endif
	#ifdef WL_TOUCH_UP_SINCE_VERSION
		swigIntConstant( WL_TOUCH_UP_SINCE_VERSION, "WL_TOUCH_UP_SINCE_VERSION" );
	#endif
	#ifdef WL_TOUCH_MOTION_SINCE_VERSION
		swigIntConstant( WL_TOUCH_MOTION_SINCE_VERSION, "WL_TOUCH_MOTION_SINCE_VERSION" );
	#endif
	#ifdef WL_TOUCH_FRAME_SINCE_VERSION
		swigIntConstant( WL_TOUCH_FRAME_SINCE_VERSION, "WL_TOUCH_FRAME_SINCE_VERSION" );
	#endif
	#ifdef WL_TOUCH_CANCEL_SINCE_VERSION
		swigIntConstant( WL_TOUCH_CANCEL_SINCE_VERSION, "WL_TOUCH_CANCEL_SINCE_VERSION" );
	#endif
	#ifdef WL_TOUCH_SHAPE_SINCE_VERSION
		swigIntConstant( WL_TOUCH_SHAPE_SINCE_VERSION, "WL_TOUCH_SHAPE_SINCE_VERSION" );
	#endif
	#ifdef WL_TOUCH_ORIENTATION_SINCE_VERSION
		swigIntConstant( WL_TOUCH_ORIENTATION_SINCE_VERSION, "WL_TOUCH_ORIENTATION_SINCE_VERSION" );
	#endif
	#ifdef WL_TOUCH_RELEASE_SINCE_VERSION
		swigIntConstant( WL_TOUCH_RELEASE_SINCE_VERSION, "WL_TOUCH_RELEASE_SINCE_VERSION" );
	#endif
	#ifdef WL_OUTPUT_RELEASE
		swigIntConstant( WL_OUTPUT_RELEASE, "WL_OUTPUT_RELEASE" );
	#endif
	#ifdef WL_OUTPUT_GEOMETRY_SINCE_VERSION
		swigIntConstant( WL_OUTPUT_GEOMETRY_SINCE_VERSION, "WL_OUTPUT_GEOMETRY_SINCE_VERSION" );
	#endif
	#ifdef WL_OUTPUT_MODE_SINCE_VERSION
		swigIntConstant( WL_OUTPUT_MODE_SINCE_VERSION, "WL_OUTPUT_MODE_SINCE_VERSION" );
	#endif
	#ifdef WL_OUTPUT_DONE_SINCE_VERSION
		swigIntConstant( WL_OUTPUT_DONE_SINCE_VERSION, "WL_OUTPUT_DONE_SINCE_VERSION" );
	#endif
	#ifdef WL_OUTPUT_SCALE_SINCE_VERSION
		swigIntConstant( WL_OUTPUT_SCALE_SINCE_VERSION, "WL_OUTPUT_SCALE_SINCE_VERSION" );
	#endif
	#ifdef WL_OUTPUT_RELEASE_SINCE_VERSION
		swigIntConstant( WL_OUTPUT_RELEASE_SINCE_VERSION, "WL_OUTPUT_RELEASE_SINCE_VERSION" );
	#endif
	#ifdef WL_REGION_DESTROY
		swigIntConstant( WL_REGION_DESTROY, "WL_REGION_DESTROY" );
	#endif
	#ifdef WL_REGION_ADD
		swigIntConstant( WL_REGION_ADD, "WL_REGION_ADD" );
	#endif
	#ifdef WL_REGION_SUBTRACT
		swigIntConstant( WL_REGION_SUBTRACT, "WL_REGION_SUBTRACT" );
	#endif
	#ifdef WL_REGION_DESTROY_SINCE_VERSION
		swigIntConstant( WL_REGION_DESTROY_SINCE_VERSION, "WL_REGION_DESTROY_SINCE_VERSION" );
	#endif
	#ifdef WL_REGION_ADD_SINCE_VERSION
		swigIntConstant( WL_REGION_ADD_SINCE_VERSION, "WL_REGION_ADD_SINCE_VERSION" );
	#endif
	#ifdef WL_REGION_SUBTRACT_SINCE_VERSION
		swigIntConstant( WL_REGION_SUBTRACT_SINCE_VERSION, "WL_REGION_SUBTRACT_SINCE_VERSION" );
	#endif
	#ifdef WL_SUBCOMPOSITOR_DESTROY
		swigIntConstant( WL_SUBCOMPOSITOR_DESTROY, "WL_SUBCOMPOSITOR_DESTROY" );
	#endif
	#ifdef WL_SUBCOMPOSITOR_GET_SUBSURFACE
		swigIntConstant( WL_SUBCOMPOSITOR_GET_SUBSURFACE, "WL_SUBCOMPOSITOR_GET_SUBSURFACE" );
	#endif
	#ifdef WL_SUBCOMPOSITOR_DESTROY_SINCE_VERSION
		swigIntConstant( WL_SUBCOMPOSITOR_DESTROY_SINCE_VERSION, "WL_SUBCOMPOSITOR_DESTROY_SINCE_VERSION" );
	#endif
	#ifdef WL_SUBCOMPOSITOR_GET_SUBSURFACE_SINCE_VERSION
		swigIntConstant( WL_SUBCOMPOSITOR_GET_SUBSURFACE_SINCE_VERSION, "WL_SUBCOMPOSITOR_GET_SUBSURFACE_SINCE_VERSION" );
	#endif
	#ifdef WL_SUBSURFACE_DESTROY
		swigIntConstant( WL_SUBSURFACE_DESTROY, "WL_SUBSURFACE_DESTROY" );
	#endif
	#ifdef WL_SUBSURFACE_SET_POSITION
		swigIntConstant( WL_SUBSURFACE_SET_POSITION, "WL_SUBSURFACE_SET_POSITION" );
	#endif
	#ifdef WL_SUBSURFACE_PLACE_ABOVE
		swigIntConstant( WL_SUBSURFACE_PLACE_ABOVE, "WL_SUBSURFACE_PLACE_ABOVE" );
	#endif
	#ifdef WL_SUBSURFACE_PLACE_BELOW
		swigIntConstant( WL_SUBSURFACE_PLACE_BELOW, "WL_SUBSURFACE_PLACE_BELOW" );
	#endif
	#ifdef WL_SUBSURFACE_SET_SYNC
		swigIntConstant( WL_SUBSURFACE_SET_SYNC, "WL_SUBSURFACE_SET_SYNC" );
	#endif
	#ifdef WL_SUBSURFACE_SET_DESYNC
		swigIntConstant( WL_SUBSURFACE_SET_DESYNC, "WL_SUBSURFACE_SET_DESYNC" );
	#endif
	#ifdef WL_SUBSURFACE_DESTROY_SINCE_VERSION
		swigIntConstant( WL_SUBSURFACE_DESTROY_SINCE_VERSION, "WL_SUBSURFACE_DESTROY_SINCE_VERSION" );
	#endif
	#ifdef WL_SUBSURFACE_SET_POSITION_SINCE_VERSION
		swigIntConstant( WL_SUBSURFACE_SET_POSITION_SINCE_VERSION, "WL_SUBSURFACE_SET_POSITION_SINCE_VERSION" );
	#endif
	#ifdef WL_SUBSURFACE_PLACE_ABOVE_SINCE_VERSION
		swigIntConstant( WL_SUBSURFACE_PLACE_ABOVE_SINCE_VERSION, "WL_SUBSURFACE_PLACE_ABOVE_SINCE_VERSION" );
	#endif
	#ifdef WL_SUBSURFACE_PLACE_BELOW_SINCE_VERSION
		swigIntConstant( WL_SUBSURFACE_PLACE_BELOW_SINCE_VERSION, "WL_SUBSURFACE_PLACE_BELOW_SINCE_VERSION" );
	#endif
	#ifdef WL_SUBSURFACE_SET_SYNC_SINCE_VERSION
		swigIntConstant( WL_SUBSURFACE_SET_SYNC_SINCE_VERSION, "WL_SUBSURFACE_SET_SYNC_SINCE_VERSION" );
	#endif
	#ifdef WL_SUBSURFACE_SET_DESYNC_SINCE_VERSION
		swigIntConstant( WL_SUBSURFACE_SET_DESYNC_SINCE_VERSION, "WL_SUBSURFACE_SET_DESYNC_SINCE_VERSION" );
	#endif
	#ifdef WL_EGL_PLATFORM
		swigIntConstant( WL_EGL_PLATFORM, "WL_EGL_PLATFORM" );
	#endif

	swigNewline();

	swigComment("--------===< enums >===---------\n");
	swigIntConstant( WL_DISPLAY_ERROR_INVALID_OBJECT, "WL_DISPLAY_ERROR_INVALID_OBJECT" );
	swigIntConstant( WL_DISPLAY_ERROR_INVALID_METHOD, "WL_DISPLAY_ERROR_INVALID_METHOD" );
	swigIntConstant( WL_DISPLAY_ERROR_NO_MEMORY, "WL_DISPLAY_ERROR_NO_MEMORY" );
	swigIntConstant( WL_SHM_ERROR_INVALID_FORMAT, "WL_SHM_ERROR_INVALID_FORMAT" );
	swigIntConstant( WL_SHM_ERROR_INVALID_STRIDE, "WL_SHM_ERROR_INVALID_STRIDE" );
	swigIntConstant( WL_SHM_ERROR_INVALID_FD, "WL_SHM_ERROR_INVALID_FD" );
	swigIntConstant( WL_SHM_FORMAT_ARGB8888, "WL_SHM_FORMAT_ARGB8888" );
	swigIntConstant( WL_SHM_FORMAT_XRGB8888, "WL_SHM_FORMAT_XRGB8888" );
	swigIntConstant( WL_SHM_FORMAT_C8, "WL_SHM_FORMAT_C8" );
	swigIntConstant( WL_SHM_FORMAT_RGB332, "WL_SHM_FORMAT_RGB332" );
	swigIntConstant( WL_SHM_FORMAT_BGR233, "WL_SHM_FORMAT_BGR233" );
	swigIntConstant( WL_SHM_FORMAT_XRGB4444, "WL_SHM_FORMAT_XRGB4444" );
	swigIntConstant( WL_SHM_FORMAT_XBGR4444, "WL_SHM_FORMAT_XBGR4444" );
	swigIntConstant( WL_SHM_FORMAT_RGBX4444, "WL_SHM_FORMAT_RGBX4444" );
	swigIntConstant( WL_SHM_FORMAT_BGRX4444, "WL_SHM_FORMAT_BGRX4444" );
	swigIntConstant( WL_SHM_FORMAT_ARGB4444, "WL_SHM_FORMAT_ARGB4444" );
	swigIntConstant( WL_SHM_FORMAT_ABGR4444, "WL_SHM_FORMAT_ABGR4444" );
	swigIntConstant( WL_SHM_FORMAT_RGBA4444, "WL_SHM_FORMAT_RGBA4444" );
	swigIntConstant( WL_SHM_FORMAT_BGRA4444, "WL_SHM_FORMAT_BGRA4444" );
	swigIntConstant( WL_SHM_FORMAT_XRGB1555, "WL_SHM_FORMAT_XRGB1555" );
	swigIntConstant( WL_SHM_FORMAT_XBGR1555, "WL_SHM_FORMAT_XBGR1555" );
	swigIntConstant( WL_SHM_FORMAT_RGBX5551, "WL_SHM_FORMAT_RGBX5551" );
	swigIntConstant( WL_SHM_FORMAT_BGRX5551, "WL_SHM_FORMAT_BGRX5551" );
	swigIntConstant( WL_SHM_FORMAT_ARGB1555, "WL_SHM_FORMAT_ARGB1555" );
	swigIntConstant( WL_SHM_FORMAT_ABGR1555, "WL_SHM_FORMAT_ABGR1555" );
	swigIntConstant( WL_SHM_FORMAT_RGBA5551, "WL_SHM_FORMAT_RGBA5551" );
	swigIntConstant( WL_SHM_FORMAT_BGRA5551, "WL_SHM_FORMAT_BGRA5551" );
	swigIntConstant( WL_SHM_FORMAT_RGB565, "WL_SHM_FORMAT_RGB565" );
	swigIntConstant( WL_SHM_FORMAT_BGR565, "WL_SHM_FORMAT_BGR565" );
	swigIntConstant( WL_SHM_FORMAT_RGB888, "WL_SHM_FORMAT_RGB888" );
	swigIntConstant( WL_SHM_FORMAT_BGR888, "WL_SHM_FORMAT_BGR888" );
	swigIntConstant( WL_SHM_FORMAT_XBGR8888, "WL_SHM_FORMAT_XBGR8888" );
	swigIntConstant( WL_SHM_FORMAT_RGBX8888, "WL_SHM_FORMAT_RGBX8888" );
	swigIntConstant( WL_SHM_FORMAT_BGRX8888, "WL_SHM_FORMAT_BGRX8888" );
	swigIntConstant( WL_SHM_FORMAT_ABGR8888, "WL_SHM_FORMAT_ABGR8888" );
	swigIntConstant( WL_SHM_FORMAT_RGBA8888, "WL_SHM_FORMAT_RGBA8888" );
	swigIntConstant( WL_SHM_FORMAT_BGRA8888, "WL_SHM_FORMAT_BGRA8888" );
	swigIntConstant( WL_SHM_FORMAT_XRGB2101010, "WL_SHM_FORMAT_XRGB2101010" );
	swigIntConstant( WL_SHM_FORMAT_XBGR2101010, "WL_SHM_FORMAT_XBGR2101010" );
	swigIntConstant( WL_SHM_FORMAT_RGBX1010102, "WL_SHM_FORMAT_RGBX1010102" );
	swigIntConstant( WL_SHM_FORMAT_BGRX1010102, "WL_SHM_FORMAT_BGRX1010102" );
	swigIntConstant( WL_SHM_FORMAT_ARGB2101010, "WL_SHM_FORMAT_ARGB2101010" );
	swigIntConstant( WL_SHM_FORMAT_ABGR2101010, "WL_SHM_FORMAT_ABGR2101010" );
	swigIntConstant( WL_SHM_FORMAT_RGBA1010102, "WL_SHM_FORMAT_RGBA1010102" );
	swigIntConstant( WL_SHM_FORMAT_BGRA1010102, "WL_SHM_FORMAT_BGRA1010102" );
	swigIntConstant( WL_SHM_FORMAT_YUYV, "WL_SHM_FORMAT_YUYV" );
	swigIntConstant( WL_SHM_FORMAT_YVYU, "WL_SHM_FORMAT_YVYU" );
	swigIntConstant( WL_SHM_FORMAT_UYVY, "WL_SHM_FORMAT_UYVY" );
	swigIntConstant( WL_SHM_FORMAT_VYUY, "WL_SHM_FORMAT_VYUY" );
	swigIntConstant( WL_SHM_FORMAT_AYUV, "WL_SHM_FORMAT_AYUV" );
	swigIntConstant( WL_SHM_FORMAT_NV12, "WL_SHM_FORMAT_NV12" );
	swigIntConstant( WL_SHM_FORMAT_NV21, "WL_SHM_FORMAT_NV21" );
	swigIntConstant( WL_SHM_FORMAT_NV16, "WL_SHM_FORMAT_NV16" );
	swigIntConstant( WL_SHM_FORMAT_NV61, "WL_SHM_FORMAT_NV61" );
	swigIntConstant( WL_SHM_FORMAT_YUV410, "WL_SHM_FORMAT_YUV410" );
	swigIntConstant( WL_SHM_FORMAT_YVU410, "WL_SHM_FORMAT_YVU410" );
	swigIntConstant( WL_SHM_FORMAT_YUV411, "WL_SHM_FORMAT_YUV411" );
	swigIntConstant( WL_SHM_FORMAT_YVU411, "WL_SHM_FORMAT_YVU411" );
	swigIntConstant( WL_SHM_FORMAT_YUV420, "WL_SHM_FORMAT_YUV420" );
	swigIntConstant( WL_SHM_FORMAT_YVU420, "WL_SHM_FORMAT_YVU420" );
	swigIntConstant( WL_SHM_FORMAT_YUV422, "WL_SHM_FORMAT_YUV422" );
	swigIntConstant( WL_SHM_FORMAT_YVU422, "WL_SHM_FORMAT_YVU422" );
	swigIntConstant( WL_SHM_FORMAT_YUV444, "WL_SHM_FORMAT_YUV444" );
	swigIntConstant( WL_SHM_FORMAT_YVU444, "WL_SHM_FORMAT_YVU444" );
	swigIntConstant( WL_DATA_OFFER_ERROR_INVALID_FINISH, "WL_DATA_OFFER_ERROR_INVALID_FINISH" );
	swigIntConstant( WL_DATA_OFFER_ERROR_INVALID_ACTION_MASK, "WL_DATA_OFFER_ERROR_INVALID_ACTION_MASK" );
	swigIntConstant( WL_DATA_OFFER_ERROR_INVALID_ACTION, "WL_DATA_OFFER_ERROR_INVALID_ACTION" );
	swigIntConstant( WL_DATA_OFFER_ERROR_INVALID_OFFER, "WL_DATA_OFFER_ERROR_INVALID_OFFER" );
	swigIntConstant( WL_DATA_SOURCE_ERROR_INVALID_ACTION_MASK, "WL_DATA_SOURCE_ERROR_INVALID_ACTION_MASK" );
	swigIntConstant( WL_DATA_SOURCE_ERROR_INVALID_SOURCE, "WL_DATA_SOURCE_ERROR_INVALID_SOURCE" );
	swigIntConstant( WL_DATA_DEVICE_ERROR_ROLE, "WL_DATA_DEVICE_ERROR_ROLE" );
	swigIntConstant( WL_DATA_DEVICE_MANAGER_DND_ACTION_NONE, "WL_DATA_DEVICE_MANAGER_DND_ACTION_NONE" );
	swigIntConstant( WL_DATA_DEVICE_MANAGER_DND_ACTION_COPY, "WL_DATA_DEVICE_MANAGER_DND_ACTION_COPY" );
	swigIntConstant( WL_DATA_DEVICE_MANAGER_DND_ACTION_MOVE, "WL_DATA_DEVICE_MANAGER_DND_ACTION_MOVE" );
	swigIntConstant( WL_DATA_DEVICE_MANAGER_DND_ACTION_ASK, "WL_DATA_DEVICE_MANAGER_DND_ACTION_ASK" );
	swigIntConstant( WL_SHELL_ERROR_ROLE, "WL_SHELL_ERROR_ROLE" );
	swigIntConstant( WL_SHELL_SURFACE_RESIZE_NONE, "WL_SHELL_SURFACE_RESIZE_NONE" );
	swigIntConstant( WL_SHELL_SURFACE_RESIZE_TOP, "WL_SHELL_SURFACE_RESIZE_TOP" );
	swigIntConstant( WL_SHELL_SURFACE_RESIZE_BOTTOM, "WL_SHELL_SURFACE_RESIZE_BOTTOM" );
	swigIntConstant( WL_SHELL_SURFACE_RESIZE_LEFT, "WL_SHELL_SURFACE_RESIZE_LEFT" );
	swigIntConstant( WL_SHELL_SURFACE_RESIZE_TOP_LEFT, "WL_SHELL_SURFACE_RESIZE_TOP_LEFT" );
	swigIntConstant( WL_SHELL_SURFACE_RESIZE_BOTTOM_LEFT, "WL_SHELL_SURFACE_RESIZE_BOTTOM_LEFT" );
	swigIntConstant( WL_SHELL_SURFACE_RESIZE_RIGHT, "WL_SHELL_SURFACE_RESIZE_RIGHT" );
	swigIntConstant( WL_SHELL_SURFACE_RESIZE_TOP_RIGHT, "WL_SHELL_SURFACE_RESIZE_TOP_RIGHT" );
	swigIntConstant( WL_SHELL_SURFACE_RESIZE_BOTTOM_RIGHT, "WL_SHELL_SURFACE_RESIZE_BOTTOM_RIGHT" );
	swigIntConstant( WL_SHELL_SURFACE_TRANSIENT_INACTIVE, "WL_SHELL_SURFACE_TRANSIENT_INACTIVE" );
	swigIntConstant( WL_SHELL_SURFACE_FULLSCREEN_METHOD_DEFAULT, "WL_SHELL_SURFACE_FULLSCREEN_METHOD_DEFAULT" );
	swigIntConstant( WL_SHELL_SURFACE_FULLSCREEN_METHOD_SCALE, "WL_SHELL_SURFACE_FULLSCREEN_METHOD_SCALE" );
	swigIntConstant( WL_SHELL_SURFACE_FULLSCREEN_METHOD_DRIVER, "WL_SHELL_SURFACE_FULLSCREEN_METHOD_DRIVER" );
	swigIntConstant( WL_SHELL_SURFACE_FULLSCREEN_METHOD_FILL, "WL_SHELL_SURFACE_FULLSCREEN_METHOD_FILL" );
	swigIntConstant( WL_SURFACE_ERROR_INVALID_SCALE, "WL_SURFACE_ERROR_INVALID_SCALE" );
	swigIntConstant( WL_SURFACE_ERROR_INVALID_TRANSFORM, "WL_SURFACE_ERROR_INVALID_TRANSFORM" );
	swigIntConstant( WL_SEAT_CAPABILITY_POINTER, "WL_SEAT_CAPABILITY_POINTER" );
	swigIntConstant( WL_SEAT_CAPABILITY_KEYBOARD, "WL_SEAT_CAPABILITY_KEYBOARD" );
	swigIntConstant( WL_SEAT_CAPABILITY_TOUCH, "WL_SEAT_CAPABILITY_TOUCH" );
	swigIntConstant( WL_POINTER_ERROR_ROLE, "WL_POINTER_ERROR_ROLE" );
	swigIntConstant( WL_POINTER_BUTTON_STATE_RELEASED, "WL_POINTER_BUTTON_STATE_RELEASED" );
	swigIntConstant( WL_POINTER_BUTTON_STATE_PRESSED, "WL_POINTER_BUTTON_STATE_PRESSED" );
	swigIntConstant( WL_POINTER_AXIS_VERTICAL_SCROLL, "WL_POINTER_AXIS_VERTICAL_SCROLL" );
	swigIntConstant( WL_POINTER_AXIS_HORIZONTAL_SCROLL, "WL_POINTER_AXIS_HORIZONTAL_SCROLL" );
	swigIntConstant( WL_POINTER_AXIS_SOURCE_WHEEL, "WL_POINTER_AXIS_SOURCE_WHEEL" );
	swigIntConstant( WL_POINTER_AXIS_SOURCE_FINGER, "WL_POINTER_AXIS_SOURCE_FINGER" );
	swigIntConstant( WL_POINTER_AXIS_SOURCE_CONTINUOUS, "WL_POINTER_AXIS_SOURCE_CONTINUOUS" );
	swigIntConstant( WL_POINTER_AXIS_SOURCE_WHEEL_TILT, "WL_POINTER_AXIS_SOURCE_WHEEL_TILT" );
	swigIntConstant( WL_KEYBOARD_KEYMAP_FORMAT_NO_KEYMAP, "WL_KEYBOARD_KEYMAP_FORMAT_NO_KEYMAP" );
	swigIntConstant( WL_KEYBOARD_KEYMAP_FORMAT_XKB_V1, "WL_KEYBOARD_KEYMAP_FORMAT_XKB_V1" );
	swigIntConstant( WL_KEYBOARD_KEY_STATE_RELEASED, "WL_KEYBOARD_KEY_STATE_RELEASED" );
	swigIntConstant( WL_KEYBOARD_KEY_STATE_PRESSED, "WL_KEYBOARD_KEY_STATE_PRESSED" );
	swigIntConstant( WL_OUTPUT_SUBPIXEL_UNKNOWN, "WL_OUTPUT_SUBPIXEL_UNKNOWN" );
	swigIntConstant( WL_OUTPUT_SUBPIXEL_NONE, "WL_OUTPUT_SUBPIXEL_NONE" );
	swigIntConstant( WL_OUTPUT_SUBPIXEL_HORIZONTAL_RGB, "WL_OUTPUT_SUBPIXEL_HORIZONTAL_RGB" );
	swigIntConstant( WL_OUTPUT_SUBPIXEL_HORIZONTAL_BGR, "WL_OUTPUT_SUBPIXEL_HORIZONTAL_BGR" );
	swigIntConstant( WL_OUTPUT_SUBPIXEL_VERTICAL_RGB, "WL_OUTPUT_SUBPIXEL_VERTICAL_RGB" );
	swigIntConstant( WL_OUTPUT_SUBPIXEL_VERTICAL_BGR, "WL_OUTPUT_SUBPIXEL_VERTICAL_BGR" );
	swigIntConstant( WL_OUTPUT_TRANSFORM_NORMAL, "WL_OUTPUT_TRANSFORM_NORMAL" );
	swigIntConstant( WL_OUTPUT_TRANSFORM_90, "WL_OUTPUT_TRANSFORM_90" );
	swigIntConstant( WL_OUTPUT_TRANSFORM_180, "WL_OUTPUT_TRANSFORM_180" );
	swigIntConstant( WL_OUTPUT_TRANSFORM_270, "WL_OUTPUT_TRANSFORM_270" );
	swigIntConstant( WL_OUTPUT_TRANSFORM_FLIPPED, "WL_OUTPUT_TRANSFORM_FLIPPED" );
	swigIntConstant( WL_OUTPUT_TRANSFORM_FLIPPED_90, "WL_OUTPUT_TRANSFORM_FLIPPED_90" );
	swigIntConstant( WL_OUTPUT_TRANSFORM_FLIPPED_180, "WL_OUTPUT_TRANSFORM_FLIPPED_180" );
	swigIntConstant( WL_OUTPUT_TRANSFORM_FLIPPED_270, "WL_OUTPUT_TRANSFORM_FLIPPED_270" );
	swigIntConstant( WL_OUTPUT_MODE_CURRENT, "WL_OUTPUT_MODE_CURRENT" );
	swigIntConstant( WL_OUTPUT_MODE_PREFERRED, "WL_OUTPUT_MODE_PREFERRED" );
	swigIntConstant( WL_SUBCOMPOSITOR_ERROR_BAD_SURFACE, "WL_SUBCOMPOSITOR_ERROR_BAD_SURFACE" );
	swigIntConstant( WL_SUBSURFACE_ERROR_BAD_SURFACE, "WL_SUBSURFACE_ERROR_BAD_SURFACE" );

	swigNewline();

	swigComment("-------===< structs >===--------\n");

	swigComment("wl_display_listener\n");
	printf( "begin-structure wl_display_listener\n" );
	swigStructField( "wl_display_listener-error", offsetof( struct wl_display_listener, error ), sizeof( void (*)(void *,struct wl_display *,void *,uint32_t,char const *) ) );
	swigStructField( "wl_display_listener-delete_id", offsetof( struct wl_display_listener, delete_id ), sizeof( void (*)(void *,struct wl_display *,uint32_t) ) );
	printf( "drop %zu end-structure\n", sizeof( struct wl_display_listener ) );

	swigComment("wl_registry_listener\n");
	printf( "begin-structure wl_registry_listener\n" );
	swigStructField( "wl_registry_listener-global_remove", offsetof( struct wl_registry_listener, global_remove ), sizeof( void (*)(void *,struct wl_registry *,uint32_t) ) );
	swigStructField( "wl_registry_listener-global", offsetof( struct wl_registry_listener, global ), sizeof( void (*)(void *,struct wl_registry *,uint32_t,char const *,uint32_t) ) );
	printf( "drop %zu end-structure\n", sizeof( struct wl_registry_listener ) );

	swigComment("wl_callback_listener\n");
	printf( "begin-structure wl_callback_listener\n" );
	swigStructField( "wl_callback_listener-done", offsetof( struct wl_callback_listener, done ), sizeof( void (*)(void *,struct wl_callback *,uint32_t) ) );
	printf( "drop %zu end-structure\n", sizeof( struct wl_callback_listener ) );

	swigComment("wl_shm_listener\n");
	printf( "begin-structure wl_shm_listener\n" );
	swigStructField( "wl_shm_listener-format", offsetof( struct wl_shm_listener, format ), sizeof( void (*)(void *,struct wl_shm *,uint32_t) ) );
	printf( "drop %zu end-structure\n", sizeof( struct wl_shm_listener ) );

	swigComment("wl_buffer_listener\n");
	printf( "begin-structure wl_buffer_listener\n" );
	swigStructField( "wl_buffer_listener-release", offsetof( struct wl_buffer_listener, release ), sizeof( void (*)(void *,struct wl_buffer *) ) );
	printf( "drop %zu end-structure\n", sizeof( struct wl_buffer_listener ) );

	swigComment("wl_data_offer_listener\n");
	printf( "begin-structure wl_data_offer_listener\n" );
	swigStructField( "wl_data_offer_listener-offer", offsetof( struct wl_data_offer_listener, offer ), sizeof( void (*)(void *,struct wl_data_offer *,char const *) ) );
	swigStructField( "wl_data_offer_listener-source_actions", offsetof( struct wl_data_offer_listener, source_actions ), sizeof( void (*)(void *,struct wl_data_offer *,uint32_t) ) );
	swigStructField( "wl_data_offer_listener-action", offsetof( struct wl_data_offer_listener, action ), sizeof( void (*)(void *,struct wl_data_offer *,uint32_t) ) );
	printf( "drop %zu end-structure\n", sizeof( struct wl_data_offer_listener ) );

	swigComment("wl_data_source_listener\n");
	printf( "begin-structure wl_data_source_listener\n" );
	swigStructField( "wl_data_source_listener-cancelled", offsetof( struct wl_data_source_listener, cancelled ), sizeof( void (*)(void *,struct wl_data_source *) ) );
	swigStructField( "wl_data_source_listener-dnd_finished", offsetof( struct wl_data_source_listener, dnd_finished ), sizeof( void (*)(void *,struct wl_data_source *) ) );
	swigStructField( "wl_data_source_listener-target", offsetof( struct wl_data_source_listener, target ), sizeof( void (*)(void *,struct wl_data_source *,char const *) ) );
	swigStructField( "wl_data_source_listener-send", offsetof( struct wl_data_source_listener, send ), sizeof( void (*)(void *,struct wl_data_source *,char const *,int32_t) ) );
	swigStructField( "wl_data_source_listener-dnd_drop_performed", offsetof( struct wl_data_source_listener, dnd_drop_performed ), sizeof( void (*)(void *,struct wl_data_source *) ) );
	swigStructField( "wl_data_source_listener-action", offsetof( struct wl_data_source_listener, action ), sizeof( void (*)(void *,struct wl_data_source *,uint32_t) ) );
	printf( "drop %zu end-structure\n", sizeof( struct wl_data_source_listener ) );

	swigComment("wl_data_device_listener\n");
	printf( "begin-structure wl_data_device_listener\n" );
	swigStructField( "wl_data_device_listener-motion", offsetof( struct wl_data_device_listener, motion ), sizeof( void (*)(void *,struct wl_data_device *,uint32_t,wl_fixed_t,wl_fixed_t) ) );
	swigStructField( "wl_data_device_listener-drop", offsetof( struct wl_data_device_listener, drop ), sizeof( void (*)(void *,struct wl_data_device *) ) );
	swigStructField( "wl_data_device_listener-enter", offsetof( struct wl_data_device_listener, enter ), sizeof( void (*)(void *,struct wl_data_device *,uint32_t,struct wl_surface *,wl_fixed_t,wl_fixed_t,struct wl_data_offer *) ) );
	swigStructField( "wl_data_device_listener-leave", offsetof( struct wl_data_device_listener, leave ), sizeof( void (*)(void *,struct wl_data_device *) ) );
	swigStructField( "wl_data_device_listener-data_offer", offsetof( struct wl_data_device_listener, data_offer ), sizeof( void (*)(void *,struct wl_data_device *,struct wl_data_offer *) ) );
	swigStructField( "wl_data_device_listener-selection", offsetof( struct wl_data_device_listener, selection ), sizeof( void (*)(void *,struct wl_data_device *,struct wl_data_offer *) ) );
	printf( "drop %zu end-structure\n", sizeof( struct wl_data_device_listener ) );

	swigComment("wl_shell_surface_listener\n");
	printf( "begin-structure wl_shell_surface_listener\n" );
	swigStructField( "wl_shell_surface_listener-popup_done", offsetof( struct wl_shell_surface_listener, popup_done ), sizeof( void (*)(void *,struct wl_shell_surface *) ) );
	swigStructField( "wl_shell_surface_listener-ping", offsetof( struct wl_shell_surface_listener, ping ), sizeof( void (*)(void *,struct wl_shell_surface *,uint32_t) ) );
	swigStructField( "wl_shell_surface_listener-configure", offsetof( struct wl_shell_surface_listener, configure ), sizeof( void (*)(void *,struct wl_shell_surface *,uint32_t,int32_t,int32_t) ) );
	printf( "drop %zu end-structure\n", sizeof( struct wl_shell_surface_listener ) );

	swigComment("wl_surface_listener\n");
	printf( "begin-structure wl_surface_listener\n" );
	swigStructField( "wl_surface_listener-enter", offsetof( struct wl_surface_listener, enter ), sizeof( void (*)(void *,struct wl_surface *,struct wl_output *) ) );
	swigStructField( "wl_surface_listener-leave", offsetof( struct wl_surface_listener, leave ), sizeof( void (*)(void *,struct wl_surface *,struct wl_output *) ) );
	printf( "drop %zu end-structure\n", sizeof( struct wl_surface_listener ) );

	swigComment("wl_seat_listener\n");
	printf( "begin-structure wl_seat_listener\n" );
	swigStructField( "wl_seat_listener-capabilities", offsetof( struct wl_seat_listener, capabilities ), sizeof( void (*)(void *,struct wl_seat *,uint32_t) ) );
	swigStructField( "wl_seat_listener-name", offsetof( struct wl_seat_listener, name ), sizeof( void (*)(void *,struct wl_seat *,char const *) ) );
	printf( "drop %zu end-structure\n", sizeof( struct wl_seat_listener ) );

	swigComment("wl_pointer_listener\n");
	printf( "begin-structure wl_pointer_listener\n" );
	swigStructField( "wl_pointer_listener-motion", offsetof( struct wl_pointer_listener, motion ), sizeof( void (*)(void *,struct wl_pointer *,uint32_t,wl_fixed_t,wl_fixed_t) ) );
	swigStructField( "wl_pointer_listener-frame", offsetof( struct wl_pointer_listener, frame ), sizeof( void (*)(void *,struct wl_pointer *) ) );
	swigStructField( "wl_pointer_listener-axis_source", offsetof( struct wl_pointer_listener, axis_source ), sizeof( void (*)(void *,struct wl_pointer *,uint32_t) ) );
	swigStructField( "wl_pointer_listener-button", offsetof( struct wl_pointer_listener, button ), sizeof( void (*)(void *,struct wl_pointer *,uint32_t,uint32_t,uint32_t,uint32_t) ) );
	swigStructField( "wl_pointer_listener-enter", offsetof( struct wl_pointer_listener, enter ), sizeof( void (*)(void *,struct wl_pointer *,uint32_t,struct wl_surface *,wl_fixed_t,wl_fixed_t) ) );
	swigStructField( "wl_pointer_listener-axis", offsetof( struct wl_pointer_listener, axis ), sizeof( void (*)(void *,struct wl_pointer *,uint32_t,uint32_t,wl_fixed_t) ) );
	swigStructField( "wl_pointer_listener-leave", offsetof( struct wl_pointer_listener, leave ), sizeof( void (*)(void *,struct wl_pointer *,uint32_t,struct wl_surface *) ) );
	swigStructField( "wl_pointer_listener-axis_stop", offsetof( struct wl_pointer_listener, axis_stop ), sizeof( void (*)(void *,struct wl_pointer *,uint32_t,uint32_t) ) );
	swigStructField( "wl_pointer_listener-axis_discrete", offsetof( struct wl_pointer_listener, axis_discrete ), sizeof( void (*)(void *,struct wl_pointer *,uint32_t,int32_t) ) );
	printf( "drop %zu end-structure\n", sizeof( struct wl_pointer_listener ) );

	swigComment("wl_keyboard_listener\n");
	printf( "begin-structure wl_keyboard_listener\n" );
	swigStructField( "wl_keyboard_listener-modifiers", offsetof( struct wl_keyboard_listener, modifiers ), sizeof( void (*)(void *,struct wl_keyboard *,uint32_t,uint32_t,uint32_t,uint32_t,uint32_t) ) );
	swigStructField( "wl_keyboard_listener-enter", offsetof( struct wl_keyboard_listener, enter ), sizeof( void (*)(void *,struct wl_keyboard *,uint32_t,struct wl_surface *,struct wl_array *) ) );
	swigStructField( "wl_keyboard_listener-key", offsetof( struct wl_keyboard_listener, key ), sizeof( void (*)(void *,struct wl_keyboard *,uint32_t,uint32_t,uint32_t,uint32_t) ) );
	swigStructField( "wl_keyboard_listener-repeat_info", offsetof( struct wl_keyboard_listener, repeat_info ), sizeof( void (*)(void *,struct wl_keyboard *,int32_t,int32_t) ) );
	swigStructField( "wl_keyboard_listener-leave", offsetof( struct wl_keyboard_listener, leave ), sizeof( void (*)(void *,struct wl_keyboard *,uint32_t,struct wl_surface *) ) );
	swigStructField( "wl_keyboard_listener-keymap", offsetof( struct wl_keyboard_listener, keymap ), sizeof( void (*)(void *,struct wl_keyboard *,uint32_t,int32_t,uint32_t) ) );
	printf( "drop %zu end-structure\n", sizeof( struct wl_keyboard_listener ) );

	swigComment("wl_touch_listener\n");
	printf( "begin-structure wl_touch_listener\n" );
	swigStructField( "wl_touch_listener-motion", offsetof( struct wl_touch_listener, motion ), sizeof( void (*)(void *,struct wl_touch *,uint32_t,int32_t,wl_fixed_t,wl_fixed_t) ) );
	swigStructField( "wl_touch_listener-frame", offsetof( struct wl_touch_listener, frame ), sizeof( void (*)(void *,struct wl_touch *) ) );
	swigStructField( "wl_touch_listener-orientation", offsetof( struct wl_touch_listener, orientation ), sizeof( void (*)(void *,struct wl_touch *,int32_t,wl_fixed_t) ) );
	swigStructField( "wl_touch_listener-cancel", offsetof( struct wl_touch_listener, cancel ), sizeof( void (*)(void *,struct wl_touch *) ) );
	swigStructField( "wl_touch_listener-down", offsetof( struct wl_touch_listener, down ), sizeof( void (*)(void *,struct wl_touch *,uint32_t,uint32_t,struct wl_surface *,int32_t,wl_fixed_t,wl_fixed_t) ) );
	swigStructField( "wl_touch_listener-shape", offsetof( struct wl_touch_listener, shape ), sizeof( void (*)(void *,struct wl_touch *,int32_t,wl_fixed_t,wl_fixed_t) ) );
	swigStructField( "wl_touch_listener-up", offsetof( struct wl_touch_listener, up ), sizeof( void (*)(void *,struct wl_touch *,uint32_t,uint32_t,int32_t) ) );
	printf( "drop %zu end-structure\n", sizeof( struct wl_touch_listener ) );

	swigComment("wl_output_listener\n");
	printf( "begin-structure wl_output_listener\n" );
	swigStructField( "wl_output_listener-done", offsetof( struct wl_output_listener, done ), sizeof( void (*)(void *,struct wl_output *) ) );
	swigStructField( "wl_output_listener-geometry", offsetof( struct wl_output_listener, geometry ), sizeof( void (*)(void *,struct wl_output *,int32_t,int32_t,int32_t,int32_t,int32_t,char const *,char const *,int32_t) ) );
	swigStructField( "wl_output_listener-scale", offsetof( struct wl_output_listener, scale ), sizeof( void (*)(void *,struct wl_output *,int32_t) ) );
	swigStructField( "wl_output_listener-mode", offsetof( struct wl_output_listener, mode ), sizeof( void (*)(void *,struct wl_output *,uint32_t,int32_t,int32_t,int32_t) ) );
	printf( "drop %zu end-structure\n", sizeof( struct wl_output_listener ) );

	swigComment("wl_cursor_image\n");
	printf( "begin-structure wl_cursor_image\n" );
	swigStructField( "wl_cursor_image-hotspot_x", offsetof( struct wl_cursor_image, hotspot_x ), sizeof( uint32_t ) );
	swigStructField( "wl_cursor_image-hotspot_y", offsetof( struct wl_cursor_image, hotspot_y ), sizeof( uint32_t ) );
	swigStructField( "wl_cursor_image-delay", offsetof( struct wl_cursor_image, delay ), sizeof( uint32_t ) );
	swigStructField( "wl_cursor_image-height", offsetof( struct wl_cursor_image, height ), sizeof( uint32_t ) );
	swigStructField( "wl_cursor_image-width", offsetof( struct wl_cursor_image, width ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct wl_cursor_image ) );

	swigComment("wl_cursor\n");
	printf( "begin-structure wl_cursor\n" );
	swigStructField( "wl_cursor-image_count", offsetof( struct wl_cursor, image_count ), sizeof( unsigned int ) );
	swigStructField( "wl_cursor-name", offsetof( struct wl_cursor, name ), sizeof( char * ) );
	swigStructField( "wl_cursor-images", offsetof( struct wl_cursor, images ), sizeof( struct wl_cursor_image ** ) );
	printf( "drop %zu end-structure\n", sizeof( struct wl_cursor ) );

	swigNewline();

	swigComment("--===< function pointers >===---\n");
	swigFunctionPointer( "c-funptr wl_display_listener-error() {((struct wl_display_listener*)ptr)->error} a a a u s -- void", "", "", "	( data wl_display object_id code message -- )" );
	swigFunctionPointer( "c-funptr wl_display_listener-delete_id() {((struct wl_display_listener*)ptr)->delete_id} a a u -- void", "", "", "	( data wl_display id -- )" );
	swigFunctionPointer( "c-funptr wl_registry_listener-global() {((struct wl_registry_listener*)ptr)->global} a a u s u -- void", "", "", "	( data wl_registry name interface version -- )" );
	swigFunctionPointer( "c-funptr wl_registry_listener-global_remove() {((struct wl_registry_listener*)ptr)->global_remove} a a u -- void", "", "", "	( data wl_registry name -- )" );
	swigFunctionPointer( "c-funptr wl_callback_listener-done() {((struct wl_callback_listener*)ptr)->done} a a u -- void", "", "", "	( data wl_callback callback_data -- )" );
	swigFunctionPointer( "c-funptr wl_shm_listener-format() {((struct wl_shm_listener*)ptr)->format} a a u -- void", "", "", "	( data wl_shm format -- )" );
	swigFunctionPointer( "c-funptr wl_buffer_listener-release() {((struct wl_buffer_listener*)ptr)->release} a a -- void", "", "", "	( data wl_buffer -- )" );
	swigFunctionPointer( "c-funptr wl_data_offer_listener-offer() {((struct wl_data_offer_listener*)ptr)->offer} a a s -- void", "", "", "	( data wl_data_offer mime_type -- )" );
	swigFunctionPointer( "c-funptr wl_data_offer_listener-source_actions() {((struct wl_data_offer_listener*)ptr)->source_actions} a a u -- void", "", "", "	( data wl_data_offer source_actions -- )" );
	swigFunctionPointer( "c-funptr wl_data_offer_listener-action() {((struct wl_data_offer_listener*)ptr)->action} a a u -- void", "", "", "	( data wl_data_offer dnd_action -- )" );
	swigFunctionPointer( "c-funptr wl_data_source_listener-target() {((struct wl_data_source_listener*)ptr)->target} a a s -- void", "", "", "	( data wl_data_source mime_type -- )" );
	swigFunctionPointer( "c-funptr wl_data_source_listener-send() {((struct wl_data_source_listener*)ptr)->send} a a s n -- void", "", "", "	( data wl_data_source mime_type fd -- )" );
	swigFunctionPointer( "c-funptr wl_data_source_listener-cancelled() {((struct wl_data_source_listener*)ptr)->cancelled} a a -- void", "", "", "	( data wl_data_source -- )" );
	swigFunctionPointer( "c-funptr wl_data_source_listener-dnd_drop_performed() {((struct wl_data_source_listener*)ptr)->dnd_drop_performed} a a -- void", "", "", "	( data wl_data_source -- )" );
	swigFunctionPointer( "c-funptr wl_data_source_listener-dnd_finished() {((struct wl_data_source_listener*)ptr)->dnd_finished} a a -- void", "", "", "	( data wl_data_source -- )" );
	swigFunctionPointer( "c-funptr wl_data_source_listener-action() {((struct wl_data_source_listener*)ptr)->action} a a u -- void", "", "", "	( data wl_data_source dnd_action -- )" );
	swigFunctionPointer( "c-funptr wl_data_device_listener-data_offer() {((struct wl_data_device_listener*)ptr)->data_offer} a a a -- void", "", "", "	( data wl_data_device id -- )" );
	swigFunctionPointer( "c-funptr wl_data_device_listener-enter() {((struct wl_data_device_listener*)ptr)->enter} a a u a n n a -- void", "", "", "	( data wl_data_device serial surface x y id -- )" );
	swigFunctionPointer( "c-funptr wl_data_device_listener-leave() {((struct wl_data_device_listener*)ptr)->leave} a a -- void", "", "", "	( data wl_data_device -- )" );
	swigFunctionPointer( "c-funptr wl_data_device_listener-motion() {((struct wl_data_device_listener*)ptr)->motion} a a u n n -- void", "", "", "	( data wl_data_device time x y -- )" );
	swigFunctionPointer( "c-funptr wl_data_device_listener-drop() {((struct wl_data_device_listener*)ptr)->drop} a a -- void", "", "", "	( data wl_data_device -- )" );
	swigFunctionPointer( "c-funptr wl_data_device_listener-selection() {((struct wl_data_device_listener*)ptr)->selection} a a a -- void", "", "", "	( data wl_data_device id -- )" );
	swigFunctionPointer( "c-funptr wl_shell_surface_listener-ping() {((struct wl_shell_surface_listener*)ptr)->ping} a a u -- void", "", "", "	( data wl_shell_surface serial -- )" );
	swigFunctionPointer( "c-funptr wl_shell_surface_listener-configure() {((struct wl_shell_surface_listener*)ptr)->configure} a a u n n -- void", "", "", "	( data wl_shell_surface edges width height -- )" );
	swigFunctionPointer( "c-funptr wl_shell_surface_listener-popup_done() {((struct wl_shell_surface_listener*)ptr)->popup_done} a a -- void", "", "", "	( data wl_shell_surface -- )" );
	swigFunctionPointer( "c-funptr wl_surface_listener-enter() {((struct wl_surface_listener*)ptr)->enter} a a a -- void", "", "", "	( data wl_surface output -- )" );
	swigFunctionPointer( "c-funptr wl_surface_listener-leave() {((struct wl_surface_listener*)ptr)->leave} a a a -- void", "", "", "	( data wl_surface output -- )" );
	swigFunctionPointer( "c-funptr wl_seat_listener-capabilities() {((struct wl_seat_listener*)ptr)->capabilities} a a u -- void", "", "", "	( data wl_seat capabilities -- )" );
	swigFunctionPointer( "c-funptr wl_seat_listener-name() {((struct wl_seat_listener*)ptr)->name} a a s -- void", "", "", "	( data wl_seat name -- )" );
	swigFunctionPointer( "c-funptr wl_pointer_listener-enter() {((struct wl_pointer_listener*)ptr)->enter} a a u a n n -- void", "", "", "	( data wl_pointer serial surface surface_x surface_y -- )" );
	swigFunctionPointer( "c-funptr wl_pointer_listener-leave() {((struct wl_pointer_listener*)ptr)->leave} a a u a -- void", "", "", "	( data wl_pointer serial surface -- )" );
	swigFunctionPointer( "c-funptr wl_pointer_listener-motion() {((struct wl_pointer_listener*)ptr)->motion} a a u n n -- void", "", "", "	( data wl_pointer time surface_x surface_y -- )" );
	swigFunctionPointer( "c-funptr wl_pointer_listener-button() {((struct wl_pointer_listener*)ptr)->button} a a u u u u -- void", "", "", "	( data wl_pointer serial time button state -- )" );
	swigFunctionPointer( "c-funptr wl_pointer_listener-axis() {((struct wl_pointer_listener*)ptr)->axis} a a u u n -- void", "", "", "	( data wl_pointer time axis value -- )" );
	swigFunctionPointer( "c-funptr wl_pointer_listener-frame() {((struct wl_pointer_listener*)ptr)->frame} a a -- void", "", "", "	( data wl_pointer -- )" );
	swigFunctionPointer( "c-funptr wl_pointer_listener-axis_source() {((struct wl_pointer_listener*)ptr)->axis_source} a a u -- void", "", "", "	( data wl_pointer axis_source -- )" );
	swigFunctionPointer( "c-funptr wl_pointer_listener-axis_stop() {((struct wl_pointer_listener*)ptr)->axis_stop} a a u u -- void", "", "", "	( data wl_pointer time axis -- )" );
	swigFunctionPointer( "c-funptr wl_pointer_listener-axis_discrete() {((struct wl_pointer_listener*)ptr)->axis_discrete} a a u n -- void", "", "", "	( data wl_pointer axis discrete -- )" );
	swigFunctionPointer( "c-funptr wl_keyboard_listener-keymap() {((struct wl_keyboard_listener*)ptr)->keymap} a a u n u -- void", "", "", "	( data wl_keyboard format fd size -- )" );
	swigFunctionPointer( "c-funptr wl_keyboard_listener-enter() {((struct wl_keyboard_listener*)ptr)->enter} a a u a a -- void", "", "", "	( data wl_keyboard serial surface keys -- )" );
	swigFunctionPointer( "c-funptr wl_keyboard_listener-leave() {((struct wl_keyboard_listener*)ptr)->leave} a a u a -- void", "", "", "	( data wl_keyboard serial surface -- )" );
	swigFunctionPointer( "c-funptr wl_keyboard_listener-key() {((struct wl_keyboard_listener*)ptr)->key} a a u u u u -- void", "", "", "	( data wl_keyboard serial time key state -- )" );
	swigFunctionPointer( "c-funptr wl_keyboard_listener-modifiers() {((struct wl_keyboard_listener*)ptr)->modifiers} a a u u u u u -- void", "", "", "	( data wl_keyboard serial mods_depressed mods_latched mods_locked group -- )" );
	swigFunctionPointer( "c-funptr wl_keyboard_listener-repeat_info() {((struct wl_keyboard_listener*)ptr)->repeat_info} a a n n -- void", "", "", "	( data wl_keyboard rate delay -- )" );
	swigFunctionPointer( "c-funptr wl_touch_listener-down() {((struct wl_touch_listener*)ptr)->down} a a u u a n n n -- void", "", "", "	( data wl_touch serial time surface id x y -- )" );
	swigFunctionPointer( "c-funptr wl_touch_listener-up() {((struct wl_touch_listener*)ptr)->up} a a u u n -- void", "", "", "	( data wl_touch serial time id -- )" );
	swigFunctionPointer( "c-funptr wl_touch_listener-motion() {((struct wl_touch_listener*)ptr)->motion} a a u n n n -- void", "", "", "	( data wl_touch time id x y -- )" );
	swigFunctionPointer( "c-funptr wl_touch_listener-frame() {((struct wl_touch_listener*)ptr)->frame} a a -- void", "", "", "	( data wl_touch -- )" );
	swigFunctionPointer( "c-funptr wl_touch_listener-cancel() {((struct wl_touch_listener*)ptr)->cancel} a a -- void", "", "", "	( data wl_touch -- )" );
	swigFunctionPointer( "c-funptr wl_touch_listener-shape() {((struct wl_touch_listener*)ptr)->shape} a a n n n -- void", "", "", "	( data wl_touch id major minor -- )" );
	swigFunctionPointer( "c-funptr wl_touch_listener-orientation() {((struct wl_touch_listener*)ptr)->orientation} a a n n -- void", "", "", "	( data wl_touch id orientation -- )" );
	swigFunctionPointer( "c-funptr wl_output_listener-geometry() {((struct wl_output_listener*)ptr)->geometry} a a n n n n n s s n -- void", "", "", "	( data wl_output x y physical_width physical_height subpixel make model transform -- )" );
	swigFunctionPointer( "c-funptr wl_output_listener-mode() {((struct wl_output_listener*)ptr)->mode} a a u n n n -- void", "", "", "	( data wl_output flags width height refresh -- )" );
	swigFunctionPointer( "c-funptr wl_output_listener-done() {((struct wl_output_listener*)ptr)->done} a a -- void", "", "", "	( data wl_output -- )" );
	swigFunctionPointer( "c-funptr wl_output_listener-scale() {((struct wl_output_listener*)ptr)->scale} a a n -- void", "", "", "	( data wl_output factor -- )" );

	swigNewline();

	swigComment("------===< functions >===-------\n");
	swigFunction( "c-function wl_event_queue_destroy wl_event_queue_destroy a -- void", "FUNCTION: wl_event_queue_destroy ( queue -- void )", "EXTERN: \"C\" void wl_event_queue_destroy( void * queue );", "	( queue -- )" );
	swigFunction( "c-function wl_proxy_marshal wl_proxy_marshal a u ... -- void", "FUNCTION: wl_proxy_marshal ( p opcode  -- void )", "EXTERN: \"C\" void wl_proxy_marshal( void * p, int opcode, ...  );", "	( p opcode <noname> -- )" );
	swigFunction( "c-function wl_proxy_marshal_array wl_proxy_marshal_array a u a -- void", "FUNCTION: wl_proxy_marshal_array ( p opcode args -- void )", "EXTERN: \"C\" void wl_proxy_marshal_array( void * p, int opcode, void * args );", "	( p opcode args -- )" );
	swigFunction( "c-function wl_proxy_create wl_proxy_create a a -- a", "FUNCTION: wl_proxy_create ( factory interface -- a )", "EXTERN: \"C\" void * wl_proxy_create( void * factory, void * interface );", "	( factory interface -- )" );
	swigFunction( "c-function wl_proxy_create_wrapper wl_proxy_create_wrapper a -- a", "FUNCTION: wl_proxy_create_wrapper ( proxy -- a )", "EXTERN: \"C\" void * wl_proxy_create_wrapper( void * proxy );", "	( proxy -- )" );
	swigFunction( "c-function wl_proxy_wrapper_destroy wl_proxy_wrapper_destroy a -- void", "FUNCTION: wl_proxy_wrapper_destroy ( proxy_wrapper -- void )", "EXTERN: \"C\" void wl_proxy_wrapper_destroy( void * proxy_wrapper );", "	( proxy_wrapper -- )" );
	swigFunction( "c-function wl_proxy_marshal_constructor wl_proxy_marshal_constructor a u a ... -- a", "FUNCTION: wl_proxy_marshal_constructor ( proxy opcode interface  -- a )", "EXTERN: \"C\" void * wl_proxy_marshal_constructor( void * proxy, int opcode, void * interface, ...  );", "	( proxy opcode interface <noname> -- )" );
	swigFunction( "c-function wl_proxy_marshal_constructor_versioned wl_proxy_marshal_constructor_versioned a u a u ... -- a", "FUNCTION: wl_proxy_marshal_constructor_versioned ( proxy opcode interface version  -- a )", "EXTERN: \"C\" void * wl_proxy_marshal_constructor_versioned( void * proxy, int opcode, void * interface, int version, ...  );", "	( proxy opcode interface version <noname> -- )" );
	swigFunction( "c-function wl_proxy_marshal_array_constructor wl_proxy_marshal_array_constructor a u a a -- a", "FUNCTION: wl_proxy_marshal_array_constructor ( proxy opcode args interface -- a )", "EXTERN: \"C\" void * wl_proxy_marshal_array_constructor( void * proxy, int opcode, void * args, void * interface );", "	( proxy opcode args interface -- )" );
	swigFunction( "c-function wl_proxy_marshal_array_constructor_versioned wl_proxy_marshal_array_constructor_versioned a u a a u -- a", "FUNCTION: wl_proxy_marshal_array_constructor_versioned ( proxy opcode args interface version -- a )", "EXTERN: \"C\" void * wl_proxy_marshal_array_constructor_versioned( void * proxy, int opcode, void * args, void * interface, int version );", "	( proxy opcode args interface version -- )" );
	swigFunction( "c-function wl_proxy_destroy wl_proxy_destroy a -- void", "FUNCTION: wl_proxy_destroy ( proxy -- void )", "EXTERN: \"C\" void wl_proxy_destroy( void * proxy );", "	( proxy -- )" );
	swigFunction( "c-function wl_proxy_add_listener wl_proxy_add_listener a a a -- n", "FUNCTION: wl_proxy_add_listener ( proxy implementation data -- n )", "EXTERN: \"C\" int wl_proxy_add_listener( void * proxy, void * implementation, void * data );", "	( proxy implementation data -- )" );
	swigFunction( "c-function wl_proxy_get_listener wl_proxy_get_listener a -- a", "FUNCTION: wl_proxy_get_listener ( proxy -- a )", "EXTERN: \"C\" void * wl_proxy_get_listener( void * proxy );", "	( proxy -- )" );
	swigFunction( "c-function wl_proxy_add_dispatcher wl_proxy_add_dispatcher a a a a -- n", "FUNCTION: wl_proxy_add_dispatcher ( proxy dispatcher_func dispatcher_data data -- n )", "EXTERN: \"C\" int wl_proxy_add_dispatcher( void * proxy, void * dispatcher_func, void * dispatcher_data, void * data );", "	( proxy dispatcher_func dispatcher_data data -- )" );
	swigFunction( "c-function wl_proxy_set_user_data wl_proxy_set_user_data a a -- void", "FUNCTION: wl_proxy_set_user_data ( proxy user_data -- void )", "EXTERN: \"C\" void wl_proxy_set_user_data( void * proxy, void * user_data );", "	( proxy user_data -- )" );
	swigFunction( "c-function wl_proxy_get_user_data wl_proxy_get_user_data a -- a", "FUNCTION: wl_proxy_get_user_data ( proxy -- a )", "EXTERN: \"C\" void * wl_proxy_get_user_data( void * proxy );", "	( proxy -- )" );
	swigFunction( "c-function wl_proxy_get_version wl_proxy_get_version a -- u", "FUNCTION: wl_proxy_get_version ( proxy -- u )", "EXTERN: \"C\" int wl_proxy_get_version( void * proxy );", "	( proxy -- )" );
	swigFunction( "c-function wl_proxy_get_id wl_proxy_get_id a -- u", "FUNCTION: wl_proxy_get_id ( proxy -- u )", "EXTERN: \"C\" int wl_proxy_get_id( void * proxy );", "	( proxy -- )" );
	swigFunction( "c-function wl_proxy_get_class wl_proxy_get_class a -- s", "FUNCTION: wl_proxy_get_class ( proxy -- s )", "EXTERN: \"C\" char * wl_proxy_get_class( void * proxy );", "	( proxy -- )" );
	swigFunction( "c-function wl_proxy_set_queue wl_proxy_set_queue a a -- void", "FUNCTION: wl_proxy_set_queue ( proxy queue -- void )", "EXTERN: \"C\" void wl_proxy_set_queue( void * proxy, void * queue );", "	( proxy queue -- )" );
	swigFunction( "c-function wl_display_connect wl_display_connect s -- a", "FUNCTION: wl_display_connect ( name -- a )", "EXTERN: \"C\" void * wl_display_connect( char * name );", "	( name -- )" );
	swigFunction( "c-function wl_display_connect_to_fd wl_display_connect_to_fd n -- a", "FUNCTION: wl_display_connect_to_fd ( fd -- a )", "EXTERN: \"C\" void * wl_display_connect_to_fd( int fd );", "	( fd -- )" );
	swigFunction( "c-function wl_display_disconnect wl_display_disconnect a -- void", "FUNCTION: wl_display_disconnect ( display -- void )", "EXTERN: \"C\" void wl_display_disconnect( void * display );", "	( display -- )" );
	swigFunction( "c-function wl_display_get_fd wl_display_get_fd a -- n", "FUNCTION: wl_display_get_fd ( display -- n )", "EXTERN: \"C\" int wl_display_get_fd( void * display );", "	( display -- )" );
	swigFunction( "c-function wl_display_dispatch wl_display_dispatch a -- n", "FUNCTION: wl_display_dispatch ( display -- n )", "EXTERN: \"C\" int wl_display_dispatch( void * display );", "	( display -- )" );
	swigFunction( "c-function wl_display_dispatch_queue wl_display_dispatch_queue a a -- n", "FUNCTION: wl_display_dispatch_queue ( display queue -- n )", "EXTERN: \"C\" int wl_display_dispatch_queue( void * display, void * queue );", "	( display queue -- )" );
	swigFunction( "c-function wl_display_dispatch_queue_pending wl_display_dispatch_queue_pending a a -- n", "FUNCTION: wl_display_dispatch_queue_pending ( display queue -- n )", "EXTERN: \"C\" int wl_display_dispatch_queue_pending( void * display, void * queue );", "	( display queue -- )" );
	swigFunction( "c-function wl_display_dispatch_pending wl_display_dispatch_pending a -- n", "FUNCTION: wl_display_dispatch_pending ( display -- n )", "EXTERN: \"C\" int wl_display_dispatch_pending( void * display );", "	( display -- )" );
	swigFunction( "c-function wl_display_get_error wl_display_get_error a -- n", "FUNCTION: wl_display_get_error ( display -- n )", "EXTERN: \"C\" int wl_display_get_error( void * display );", "	( display -- )" );
	swigFunction( "c-function wl_display_get_protocol_error wl_display_get_protocol_error a a a -- u", "FUNCTION: wl_display_get_protocol_error ( display interface id -- u )", "EXTERN: \"C\" int wl_display_get_protocol_error( void * display, void * interface, void * id );", "	( display interface id -- )" );
	swigFunction( "c-function wl_display_flush wl_display_flush a -- n", "FUNCTION: wl_display_flush ( display -- n )", "EXTERN: \"C\" int wl_display_flush( void * display );", "	( display -- )" );
	swigFunction( "c-function wl_display_roundtrip_queue wl_display_roundtrip_queue a a -- n", "FUNCTION: wl_display_roundtrip_queue ( display queue -- n )", "EXTERN: \"C\" int wl_display_roundtrip_queue( void * display, void * queue );", "	( display queue -- )" );
	swigFunction( "c-function wl_display_roundtrip wl_display_roundtrip a -- n", "FUNCTION: wl_display_roundtrip ( display -- n )", "EXTERN: \"C\" int wl_display_roundtrip( void * display );", "	( display -- )" );
	swigFunction( "c-function wl_display_create_queue wl_display_create_queue a -- a", "FUNCTION: wl_display_create_queue ( display -- a )", "EXTERN: \"C\" void * wl_display_create_queue( void * display );", "	( display -- )" );
	swigFunction( "c-function wl_display_prepare_read_queue wl_display_prepare_read_queue a a -- n", "FUNCTION: wl_display_prepare_read_queue ( display queue -- n )", "EXTERN: \"C\" int wl_display_prepare_read_queue( void * display, void * queue );", "	( display queue -- )" );
	swigFunction( "c-function wl_display_prepare_read wl_display_prepare_read a -- n", "FUNCTION: wl_display_prepare_read ( display -- n )", "EXTERN: \"C\" int wl_display_prepare_read( void * display );", "	( display -- )" );
	swigFunction( "c-function wl_display_cancel_read wl_display_cancel_read a -- void", "FUNCTION: wl_display_cancel_read ( display -- void )", "EXTERN: \"C\" void wl_display_cancel_read( void * display );", "	( display -- )" );
	swigFunction( "c-function wl_display_read_events wl_display_read_events a -- n", "FUNCTION: wl_display_read_events ( display -- n )", "EXTERN: \"C\" int wl_display_read_events( void * display );", "	( display -- )" );
	swigFunction( "c-function wl_log_set_handler_client wl_log_set_handler_client a -- void", "FUNCTION: wl_log_set_handler_client ( handler -- void )", "EXTERN: \"C\" void wl_log_set_handler_client( void * handler );", "	( handler -- )" );
	swigFunction( "c-function wl_display_add_listener wl_display_add_listener a a a -- n", "FUNCTION: wl_display_add_listener ( wl_display listener data -- n )", "EXTERN: \"C\" int wl_display_add_listener( void * wl_display, void * listener, void * data );", "	( wl_display listener data -- )" );
	swigFunction( "c-function wl_display_set_user_data wl_display_set_user_data a a -- void", "FUNCTION: wl_display_set_user_data ( wl_display user_data -- void )", "EXTERN: \"C\" void wl_display_set_user_data( void * wl_display, void * user_data );", "	( wl_display user_data -- )" );
	swigFunction( "c-function wl_display_get_user_data wl_display_get_user_data a -- a", "FUNCTION: wl_display_get_user_data ( wl_display -- a )", "EXTERN: \"C\" void * wl_display_get_user_data( void * wl_display );", "	( wl_display -- )" );
	swigFunction( "c-function wl_display_get_version wl_display_get_version a -- u", "FUNCTION: wl_display_get_version ( wl_display -- u )", "EXTERN: \"C\" int wl_display_get_version( void * wl_display );", "	( wl_display -- )" );
	swigFunction( "c-function wl_display_sync wl_display_sync a -- a", "FUNCTION: wl_display_sync ( wl_display -- a )", "EXTERN: \"C\" void * wl_display_sync( void * wl_display );", "	( wl_display -- )" );
	swigFunction( "c-function wl_display_get_registry wl_display_get_registry a -- a", "FUNCTION: wl_display_get_registry ( wl_display -- a )", "EXTERN: \"C\" void * wl_display_get_registry( void * wl_display );", "	( wl_display -- )" );
	swigFunction( "c-function wl_registry_add_listener wl_registry_add_listener a a a -- n", "FUNCTION: wl_registry_add_listener ( wl_registry listener data -- n )", "EXTERN: \"C\" int wl_registry_add_listener( void * wl_registry, void * listener, void * data );", "	( wl_registry listener data -- )" );
	swigFunction( "c-function wl_registry_set_user_data wl_registry_set_user_data a a -- void", "FUNCTION: wl_registry_set_user_data ( wl_registry user_data -- void )", "EXTERN: \"C\" void wl_registry_set_user_data( void * wl_registry, void * user_data );", "	( wl_registry user_data -- )" );
	swigFunction( "c-function wl_registry_get_user_data wl_registry_get_user_data a -- a", "FUNCTION: wl_registry_get_user_data ( wl_registry -- a )", "EXTERN: \"C\" void * wl_registry_get_user_data( void * wl_registry );", "	( wl_registry -- )" );
	swigFunction( "c-function wl_registry_get_version wl_registry_get_version a -- u", "FUNCTION: wl_registry_get_version ( wl_registry -- u )", "EXTERN: \"C\" int wl_registry_get_version( void * wl_registry );", "	( wl_registry -- )" );
	swigFunction( "c-function wl_registry_destroy wl_registry_destroy a -- void", "FUNCTION: wl_registry_destroy ( wl_registry -- void )", "EXTERN: \"C\" void wl_registry_destroy( void * wl_registry );", "	( wl_registry -- )" );
	swigFunction( "c-function wl_registry_bind wl_registry_bind a u a u -- a", "FUNCTION: wl_registry_bind ( wl_registry name interface version -- a )", "EXTERN: \"C\" void * wl_registry_bind( void * wl_registry, int name, void * interface, int version );", "	( wl_registry name interface version -- )" );
	swigFunction( "c-function wl_callback_add_listener wl_callback_add_listener a a a -- n", "FUNCTION: wl_callback_add_listener ( wl_callback listener data -- n )", "EXTERN: \"C\" int wl_callback_add_listener( void * wl_callback, void * listener, void * data );", "	( wl_callback listener data -- )" );
	swigFunction( "c-function wl_callback_set_user_data wl_callback_set_user_data a a -- void", "FUNCTION: wl_callback_set_user_data ( wl_callback user_data -- void )", "EXTERN: \"C\" void wl_callback_set_user_data( void * wl_callback, void * user_data );", "	( wl_callback user_data -- )" );
	swigFunction( "c-function wl_callback_get_user_data wl_callback_get_user_data a -- a", "FUNCTION: wl_callback_get_user_data ( wl_callback -- a )", "EXTERN: \"C\" void * wl_callback_get_user_data( void * wl_callback );", "	( wl_callback -- )" );
	swigFunction( "c-function wl_callback_get_version wl_callback_get_version a -- u", "FUNCTION: wl_callback_get_version ( wl_callback -- u )", "EXTERN: \"C\" int wl_callback_get_version( void * wl_callback );", "	( wl_callback -- )" );
	swigFunction( "c-function wl_callback_destroy wl_callback_destroy a -- void", "FUNCTION: wl_callback_destroy ( wl_callback -- void )", "EXTERN: \"C\" void wl_callback_destroy( void * wl_callback );", "	( wl_callback -- )" );
	swigFunction( "c-function wl_compositor_set_user_data wl_compositor_set_user_data a a -- void", "FUNCTION: wl_compositor_set_user_data ( wl_compositor user_data -- void )", "EXTERN: \"C\" void wl_compositor_set_user_data( void * wl_compositor, void * user_data );", "	( wl_compositor user_data -- )" );
	swigFunction( "c-function wl_compositor_get_user_data wl_compositor_get_user_data a -- a", "FUNCTION: wl_compositor_get_user_data ( wl_compositor -- a )", "EXTERN: \"C\" void * wl_compositor_get_user_data( void * wl_compositor );", "	( wl_compositor -- )" );
	swigFunction( "c-function wl_compositor_get_version wl_compositor_get_version a -- u", "FUNCTION: wl_compositor_get_version ( wl_compositor -- u )", "EXTERN: \"C\" int wl_compositor_get_version( void * wl_compositor );", "	( wl_compositor -- )" );
	swigFunction( "c-function wl_compositor_destroy wl_compositor_destroy a -- void", "FUNCTION: wl_compositor_destroy ( wl_compositor -- void )", "EXTERN: \"C\" void wl_compositor_destroy( void * wl_compositor );", "	( wl_compositor -- )" );
	swigFunction( "c-function wl_compositor_create_surface wl_compositor_create_surface a -- a", "FUNCTION: wl_compositor_create_surface ( wl_compositor -- a )", "EXTERN: \"C\" void * wl_compositor_create_surface( void * wl_compositor );", "	( wl_compositor -- )" );
	swigFunction( "c-function wl_compositor_create_region wl_compositor_create_region a -- a", "FUNCTION: wl_compositor_create_region ( wl_compositor -- a )", "EXTERN: \"C\" void * wl_compositor_create_region( void * wl_compositor );", "	( wl_compositor -- )" );
	swigFunction( "c-function wl_shm_pool_set_user_data wl_shm_pool_set_user_data a a -- void", "FUNCTION: wl_shm_pool_set_user_data ( wl_shm_pool user_data -- void )", "EXTERN: \"C\" void wl_shm_pool_set_user_data( void * wl_shm_pool, void * user_data );", "	( wl_shm_pool user_data -- )" );
	swigFunction( "c-function wl_shm_pool_get_user_data wl_shm_pool_get_user_data a -- a", "FUNCTION: wl_shm_pool_get_user_data ( wl_shm_pool -- a )", "EXTERN: \"C\" void * wl_shm_pool_get_user_data( void * wl_shm_pool );", "	( wl_shm_pool -- )" );
	swigFunction( "c-function wl_shm_pool_get_version wl_shm_pool_get_version a -- u", "FUNCTION: wl_shm_pool_get_version ( wl_shm_pool -- u )", "EXTERN: \"C\" int wl_shm_pool_get_version( void * wl_shm_pool );", "	( wl_shm_pool -- )" );
	swigFunction( "c-function wl_shm_pool_create_buffer wl_shm_pool_create_buffer a n n n n u -- a", "FUNCTION: wl_shm_pool_create_buffer ( wl_shm_pool offset width height stride format -- a )", "EXTERN: \"C\" void * wl_shm_pool_create_buffer( void * wl_shm_pool, int offset, int width, int height, int stride, int format );", "	( wl_shm_pool offset width height stride format -- )" );
	swigFunction( "c-function wl_shm_pool_destroy wl_shm_pool_destroy a -- void", "FUNCTION: wl_shm_pool_destroy ( wl_shm_pool -- void )", "EXTERN: \"C\" void wl_shm_pool_destroy( void * wl_shm_pool );", "	( wl_shm_pool -- )" );
	swigFunction( "c-function wl_shm_pool_resize wl_shm_pool_resize a n -- void", "FUNCTION: wl_shm_pool_resize ( wl_shm_pool size -- void )", "EXTERN: \"C\" void wl_shm_pool_resize( void * wl_shm_pool, int size );", "	( wl_shm_pool size -- )" );
	swigFunction( "c-function wl_shm_add_listener wl_shm_add_listener a a a -- n", "FUNCTION: wl_shm_add_listener ( wl_shm listener data -- n )", "EXTERN: \"C\" int wl_shm_add_listener( void * wl_shm, void * listener, void * data );", "	( wl_shm listener data -- )" );
	swigFunction( "c-function wl_shm_set_user_data wl_shm_set_user_data a a -- void", "FUNCTION: wl_shm_set_user_data ( wl_shm user_data -- void )", "EXTERN: \"C\" void wl_shm_set_user_data( void * wl_shm, void * user_data );", "	( wl_shm user_data -- )" );
	swigFunction( "c-function wl_shm_get_user_data wl_shm_get_user_data a -- a", "FUNCTION: wl_shm_get_user_data ( wl_shm -- a )", "EXTERN: \"C\" void * wl_shm_get_user_data( void * wl_shm );", "	( wl_shm -- )" );
	swigFunction( "c-function wl_shm_get_version wl_shm_get_version a -- u", "FUNCTION: wl_shm_get_version ( wl_shm -- u )", "EXTERN: \"C\" int wl_shm_get_version( void * wl_shm );", "	( wl_shm -- )" );
	swigFunction( "c-function wl_shm_destroy wl_shm_destroy a -- void", "FUNCTION: wl_shm_destroy ( wl_shm -- void )", "EXTERN: \"C\" void wl_shm_destroy( void * wl_shm );", "	( wl_shm -- )" );
	swigFunction( "c-function wl_shm_create_pool wl_shm_create_pool a n n -- a", "FUNCTION: wl_shm_create_pool ( wl_shm fd size -- a )", "EXTERN: \"C\" void * wl_shm_create_pool( void * wl_shm, int fd, int size );", "	( wl_shm fd size -- )" );
	swigFunction( "c-function wl_buffer_add_listener wl_buffer_add_listener a a a -- n", "FUNCTION: wl_buffer_add_listener ( wl_buffer listener data -- n )", "EXTERN: \"C\" int wl_buffer_add_listener( void * wl_buffer, void * listener, void * data );", "	( wl_buffer listener data -- )" );
	swigFunction( "c-function wl_buffer_set_user_data wl_buffer_set_user_data a a -- void", "FUNCTION: wl_buffer_set_user_data ( wl_buffer user_data -- void )", "EXTERN: \"C\" void wl_buffer_set_user_data( void * wl_buffer, void * user_data );", "	( wl_buffer user_data -- )" );
	swigFunction( "c-function wl_buffer_get_user_data wl_buffer_get_user_data a -- a", "FUNCTION: wl_buffer_get_user_data ( wl_buffer -- a )", "EXTERN: \"C\" void * wl_buffer_get_user_data( void * wl_buffer );", "	( wl_buffer -- )" );
	swigFunction( "c-function wl_buffer_get_version wl_buffer_get_version a -- u", "FUNCTION: wl_buffer_get_version ( wl_buffer -- u )", "EXTERN: \"C\" int wl_buffer_get_version( void * wl_buffer );", "	( wl_buffer -- )" );
	swigFunction( "c-function wl_buffer_destroy wl_buffer_destroy a -- void", "FUNCTION: wl_buffer_destroy ( wl_buffer -- void )", "EXTERN: \"C\" void wl_buffer_destroy( void * wl_buffer );", "	( wl_buffer -- )" );
	swigFunction( "c-function wl_data_offer_add_listener wl_data_offer_add_listener a a a -- n", "FUNCTION: wl_data_offer_add_listener ( wl_data_offer listener data -- n )", "EXTERN: \"C\" int wl_data_offer_add_listener( void * wl_data_offer, void * listener, void * data );", "	( wl_data_offer listener data -- )" );
	swigFunction( "c-function wl_data_offer_set_user_data wl_data_offer_set_user_data a a -- void", "FUNCTION: wl_data_offer_set_user_data ( wl_data_offer user_data -- void )", "EXTERN: \"C\" void wl_data_offer_set_user_data( void * wl_data_offer, void * user_data );", "	( wl_data_offer user_data -- )" );
	swigFunction( "c-function wl_data_offer_get_user_data wl_data_offer_get_user_data a -- a", "FUNCTION: wl_data_offer_get_user_data ( wl_data_offer -- a )", "EXTERN: \"C\" void * wl_data_offer_get_user_data( void * wl_data_offer );", "	( wl_data_offer -- )" );
	swigFunction( "c-function wl_data_offer_get_version wl_data_offer_get_version a -- u", "FUNCTION: wl_data_offer_get_version ( wl_data_offer -- u )", "EXTERN: \"C\" int wl_data_offer_get_version( void * wl_data_offer );", "	( wl_data_offer -- )" );
	swigFunction( "c-function wl_data_offer_accept wl_data_offer_accept a u s -- void", "FUNCTION: wl_data_offer_accept ( wl_data_offer serial mime_type -- void )", "EXTERN: \"C\" void wl_data_offer_accept( void * wl_data_offer, int serial, char * mime_type );", "	( wl_data_offer serial mime_type -- )" );
	swigFunction( "c-function wl_data_offer_receive wl_data_offer_receive a s n -- void", "FUNCTION: wl_data_offer_receive ( wl_data_offer mime_type fd -- void )", "EXTERN: \"C\" void wl_data_offer_receive( void * wl_data_offer, char * mime_type, int fd );", "	( wl_data_offer mime_type fd -- )" );
	swigFunction( "c-function wl_data_offer_destroy wl_data_offer_destroy a -- void", "FUNCTION: wl_data_offer_destroy ( wl_data_offer -- void )", "EXTERN: \"C\" void wl_data_offer_destroy( void * wl_data_offer );", "	( wl_data_offer -- )" );
	swigFunction( "c-function wl_data_offer_finish wl_data_offer_finish a -- void", "FUNCTION: wl_data_offer_finish ( wl_data_offer -- void )", "EXTERN: \"C\" void wl_data_offer_finish( void * wl_data_offer );", "	( wl_data_offer -- )" );
	swigFunction( "c-function wl_data_offer_set_actions wl_data_offer_set_actions a u u -- void", "FUNCTION: wl_data_offer_set_actions ( wl_data_offer dnd_actions preferred_action -- void )", "EXTERN: \"C\" void wl_data_offer_set_actions( void * wl_data_offer, int dnd_actions, int preferred_action );", "	( wl_data_offer dnd_actions preferred_action -- )" );
	swigFunction( "c-function wl_data_source_add_listener wl_data_source_add_listener a a a -- n", "FUNCTION: wl_data_source_add_listener ( wl_data_source listener data -- n )", "EXTERN: \"C\" int wl_data_source_add_listener( void * wl_data_source, void * listener, void * data );", "	( wl_data_source listener data -- )" );
	swigFunction( "c-function wl_data_source_set_user_data wl_data_source_set_user_data a a -- void", "FUNCTION: wl_data_source_set_user_data ( wl_data_source user_data -- void )", "EXTERN: \"C\" void wl_data_source_set_user_data( void * wl_data_source, void * user_data );", "	( wl_data_source user_data -- )" );
	swigFunction( "c-function wl_data_source_get_user_data wl_data_source_get_user_data a -- a", "FUNCTION: wl_data_source_get_user_data ( wl_data_source -- a )", "EXTERN: \"C\" void * wl_data_source_get_user_data( void * wl_data_source );", "	( wl_data_source -- )" );
	swigFunction( "c-function wl_data_source_get_version wl_data_source_get_version a -- u", "FUNCTION: wl_data_source_get_version ( wl_data_source -- u )", "EXTERN: \"C\" int wl_data_source_get_version( void * wl_data_source );", "	( wl_data_source -- )" );
	swigFunction( "c-function wl_data_source_offer wl_data_source_offer a s -- void", "FUNCTION: wl_data_source_offer ( wl_data_source mime_type -- void )", "EXTERN: \"C\" void wl_data_source_offer( void * wl_data_source, char * mime_type );", "	( wl_data_source mime_type -- )" );
	swigFunction( "c-function wl_data_source_destroy wl_data_source_destroy a -- void", "FUNCTION: wl_data_source_destroy ( wl_data_source -- void )", "EXTERN: \"C\" void wl_data_source_destroy( void * wl_data_source );", "	( wl_data_source -- )" );
	swigFunction( "c-function wl_data_source_set_actions wl_data_source_set_actions a u -- void", "FUNCTION: wl_data_source_set_actions ( wl_data_source dnd_actions -- void )", "EXTERN: \"C\" void wl_data_source_set_actions( void * wl_data_source, int dnd_actions );", "	( wl_data_source dnd_actions -- )" );
	swigFunction( "c-function wl_data_device_add_listener wl_data_device_add_listener a a a -- n", "FUNCTION: wl_data_device_add_listener ( wl_data_device listener data -- n )", "EXTERN: \"C\" int wl_data_device_add_listener( void * wl_data_device, void * listener, void * data );", "	( wl_data_device listener data -- )" );
	swigFunction( "c-function wl_data_device_set_user_data wl_data_device_set_user_data a a -- void", "FUNCTION: wl_data_device_set_user_data ( wl_data_device user_data -- void )", "EXTERN: \"C\" void wl_data_device_set_user_data( void * wl_data_device, void * user_data );", "	( wl_data_device user_data -- )" );
	swigFunction( "c-function wl_data_device_get_user_data wl_data_device_get_user_data a -- a", "FUNCTION: wl_data_device_get_user_data ( wl_data_device -- a )", "EXTERN: \"C\" void * wl_data_device_get_user_data( void * wl_data_device );", "	( wl_data_device -- )" );
	swigFunction( "c-function wl_data_device_get_version wl_data_device_get_version a -- u", "FUNCTION: wl_data_device_get_version ( wl_data_device -- u )", "EXTERN: \"C\" int wl_data_device_get_version( void * wl_data_device );", "	( wl_data_device -- )" );
	swigFunction( "c-function wl_data_device_destroy wl_data_device_destroy a -- void", "FUNCTION: wl_data_device_destroy ( wl_data_device -- void )", "EXTERN: \"C\" void wl_data_device_destroy( void * wl_data_device );", "	( wl_data_device -- )" );
	swigFunction( "c-function wl_data_device_start_drag wl_data_device_start_drag a a a a u -- void", "FUNCTION: wl_data_device_start_drag ( wl_data_device source origin icon serial -- void )", "EXTERN: \"C\" void wl_data_device_start_drag( void * wl_data_device, void * source, void * origin, void * icon, int serial );", "	( wl_data_device source origin icon serial -- )" );
	swigFunction( "c-function wl_data_device_set_selection wl_data_device_set_selection a a u -- void", "FUNCTION: wl_data_device_set_selection ( wl_data_device source serial -- void )", "EXTERN: \"C\" void wl_data_device_set_selection( void * wl_data_device, void * source, int serial );", "	( wl_data_device source serial -- )" );
	swigFunction( "c-function wl_data_device_release wl_data_device_release a -- void", "FUNCTION: wl_data_device_release ( wl_data_device -- void )", "EXTERN: \"C\" void wl_data_device_release( void * wl_data_device );", "	( wl_data_device -- )" );
	swigFunction( "c-function wl_data_device_manager_set_user_data wl_data_device_manager_set_user_data a a -- void", "FUNCTION: wl_data_device_manager_set_user_data ( wl_data_device_manager user_data -- void )", "EXTERN: \"C\" void wl_data_device_manager_set_user_data( void * wl_data_device_manager, void * user_data );", "	( wl_data_device_manager user_data -- )" );
	swigFunction( "c-function wl_data_device_manager_get_user_data wl_data_device_manager_get_user_data a -- a", "FUNCTION: wl_data_device_manager_get_user_data ( wl_data_device_manager -- a )", "EXTERN: \"C\" void * wl_data_device_manager_get_user_data( void * wl_data_device_manager );", "	( wl_data_device_manager -- )" );
	swigFunction( "c-function wl_data_device_manager_get_version wl_data_device_manager_get_version a -- u", "FUNCTION: wl_data_device_manager_get_version ( wl_data_device_manager -- u )", "EXTERN: \"C\" int wl_data_device_manager_get_version( void * wl_data_device_manager );", "	( wl_data_device_manager -- )" );
	swigFunction( "c-function wl_data_device_manager_destroy wl_data_device_manager_destroy a -- void", "FUNCTION: wl_data_device_manager_destroy ( wl_data_device_manager -- void )", "EXTERN: \"C\" void wl_data_device_manager_destroy( void * wl_data_device_manager );", "	( wl_data_device_manager -- )" );
	swigFunction( "c-function wl_data_device_manager_create_data_source wl_data_device_manager_create_data_source a -- a", "FUNCTION: wl_data_device_manager_create_data_source ( wl_data_device_manager -- a )", "EXTERN: \"C\" void * wl_data_device_manager_create_data_source( void * wl_data_device_manager );", "	( wl_data_device_manager -- )" );
	swigFunction( "c-function wl_data_device_manager_get_data_device wl_data_device_manager_get_data_device a a -- a", "FUNCTION: wl_data_device_manager_get_data_device ( wl_data_device_manager seat -- a )", "EXTERN: \"C\" void * wl_data_device_manager_get_data_device( void * wl_data_device_manager, void * seat );", "	( wl_data_device_manager seat -- )" );
	swigFunction( "c-function wl_shell_set_user_data wl_shell_set_user_data a a -- void", "FUNCTION: wl_shell_set_user_data ( wl_shell user_data -- void )", "EXTERN: \"C\" void wl_shell_set_user_data( void * wl_shell, void * user_data );", "	( wl_shell user_data -- )" );
	swigFunction( "c-function wl_shell_get_user_data wl_shell_get_user_data a -- a", "FUNCTION: wl_shell_get_user_data ( wl_shell -- a )", "EXTERN: \"C\" void * wl_shell_get_user_data( void * wl_shell );", "	( wl_shell -- )" );
	swigFunction( "c-function wl_shell_get_version wl_shell_get_version a -- u", "FUNCTION: wl_shell_get_version ( wl_shell -- u )", "EXTERN: \"C\" int wl_shell_get_version( void * wl_shell );", "	( wl_shell -- )" );
	swigFunction( "c-function wl_shell_destroy wl_shell_destroy a -- void", "FUNCTION: wl_shell_destroy ( wl_shell -- void )", "EXTERN: \"C\" void wl_shell_destroy( void * wl_shell );", "	( wl_shell -- )" );
	swigFunction( "c-function wl_shell_get_shell_surface wl_shell_get_shell_surface a a -- a", "FUNCTION: wl_shell_get_shell_surface ( wl_shell surface -- a )", "EXTERN: \"C\" void * wl_shell_get_shell_surface( void * wl_shell, void * surface );", "	( wl_shell surface -- )" );
	swigFunction( "c-function wl_shell_surface_add_listener wl_shell_surface_add_listener a a a -- n", "FUNCTION: wl_shell_surface_add_listener ( wl_shell_surface listener data -- n )", "EXTERN: \"C\" int wl_shell_surface_add_listener( void * wl_shell_surface, void * listener, void * data );", "	( wl_shell_surface listener data -- )" );
	swigFunction( "c-function wl_shell_surface_set_user_data wl_shell_surface_set_user_data a a -- void", "FUNCTION: wl_shell_surface_set_user_data ( wl_shell_surface user_data -- void )", "EXTERN: \"C\" void wl_shell_surface_set_user_data( void * wl_shell_surface, void * user_data );", "	( wl_shell_surface user_data -- )" );
	swigFunction( "c-function wl_shell_surface_get_user_data wl_shell_surface_get_user_data a -- a", "FUNCTION: wl_shell_surface_get_user_data ( wl_shell_surface -- a )", "EXTERN: \"C\" void * wl_shell_surface_get_user_data( void * wl_shell_surface );", "	( wl_shell_surface -- )" );
	swigFunction( "c-function wl_shell_surface_get_version wl_shell_surface_get_version a -- u", "FUNCTION: wl_shell_surface_get_version ( wl_shell_surface -- u )", "EXTERN: \"C\" int wl_shell_surface_get_version( void * wl_shell_surface );", "	( wl_shell_surface -- )" );
	swigFunction( "c-function wl_shell_surface_destroy wl_shell_surface_destroy a -- void", "FUNCTION: wl_shell_surface_destroy ( wl_shell_surface -- void )", "EXTERN: \"C\" void wl_shell_surface_destroy( void * wl_shell_surface );", "	( wl_shell_surface -- )" );
	swigFunction( "c-function wl_shell_surface_pong wl_shell_surface_pong a u -- void", "FUNCTION: wl_shell_surface_pong ( wl_shell_surface serial -- void )", "EXTERN: \"C\" void wl_shell_surface_pong( void * wl_shell_surface, int serial );", "	( wl_shell_surface serial -- )" );
	swigFunction( "c-function wl_shell_surface_move wl_shell_surface_move a a u -- void", "FUNCTION: wl_shell_surface_move ( wl_shell_surface seat serial -- void )", "EXTERN: \"C\" void wl_shell_surface_move( void * wl_shell_surface, void * seat, int serial );", "	( wl_shell_surface seat serial -- )" );
	swigFunction( "c-function wl_shell_surface_set_toplevel wl_shell_surface_set_toplevel a -- void", "FUNCTION: wl_shell_surface_set_toplevel ( wl_shell_surface -- void )", "EXTERN: \"C\" void wl_shell_surface_set_toplevel( void * wl_shell_surface );", "	( wl_shell_surface -- )" );
	swigFunction( "c-function wl_shell_surface_set_transient wl_shell_surface_set_transient a a n n u -- void", "FUNCTION: wl_shell_surface_set_transient ( wl_shell_surface parent x y flags -- void )", "EXTERN: \"C\" void wl_shell_surface_set_transient( void * wl_shell_surface, void * parent, int x, int y, int flags );", "	( wl_shell_surface parent x y flags -- )" );
	swigFunction( "c-function wl_shell_surface_set_fullscreen wl_shell_surface_set_fullscreen a u u a -- void", "FUNCTION: wl_shell_surface_set_fullscreen ( wl_shell_surface method framerate output -- void )", "EXTERN: \"C\" void wl_shell_surface_set_fullscreen( void * wl_shell_surface, int method, int framerate, void * output );", "	( wl_shell_surface method framerate output -- )" );
	swigFunction( "c-function wl_shell_surface_set_popup wl_shell_surface_set_popup a a u a n n u -- void", "FUNCTION: wl_shell_surface_set_popup ( wl_shell_surface seat serial parent x y flags -- void )", "EXTERN: \"C\" void wl_shell_surface_set_popup( void * wl_shell_surface, void * seat, int serial, void * parent, int x, int y, int flags );", "	( wl_shell_surface seat serial parent x y flags -- )" );
	swigFunction( "c-function wl_shell_surface_set_maximized wl_shell_surface_set_maximized a a -- void", "FUNCTION: wl_shell_surface_set_maximized ( wl_shell_surface output -- void )", "EXTERN: \"C\" void wl_shell_surface_set_maximized( void * wl_shell_surface, void * output );", "	( wl_shell_surface output -- )" );
	swigFunction( "c-function wl_shell_surface_set_title wl_shell_surface_set_title a s -- void", "FUNCTION: wl_shell_surface_set_title ( wl_shell_surface title -- void )", "EXTERN: \"C\" void wl_shell_surface_set_title( void * wl_shell_surface, char * title );", "	( wl_shell_surface title -- )" );
	swigFunction( "c-function wl_shell_surface_set_class wl_shell_surface_set_class a s -- void", "FUNCTION: wl_shell_surface_set_class ( wl_shell_surface class_ -- void )", "EXTERN: \"C\" void wl_shell_surface_set_class( void * wl_shell_surface, char * class_ );", "	( wl_shell_surface class_ -- )" );
	swigFunction( "c-function wl_surface_add_listener wl_surface_add_listener a a a -- n", "FUNCTION: wl_surface_add_listener ( wl_surface listener data -- n )", "EXTERN: \"C\" int wl_surface_add_listener( void * wl_surface, void * listener, void * data );", "	( wl_surface listener data -- )" );
	swigFunction( "c-function wl_surface_set_user_data wl_surface_set_user_data a a -- void", "FUNCTION: wl_surface_set_user_data ( wl_surface user_data -- void )", "EXTERN: \"C\" void wl_surface_set_user_data( void * wl_surface, void * user_data );", "	( wl_surface user_data -- )" );
	swigFunction( "c-function wl_surface_get_user_data wl_surface_get_user_data a -- a", "FUNCTION: wl_surface_get_user_data ( wl_surface -- a )", "EXTERN: \"C\" void * wl_surface_get_user_data( void * wl_surface );", "	( wl_surface -- )" );
	swigFunction( "c-function wl_surface_get_version wl_surface_get_version a -- u", "FUNCTION: wl_surface_get_version ( wl_surface -- u )", "EXTERN: \"C\" int wl_surface_get_version( void * wl_surface );", "	( wl_surface -- )" );
	swigFunction( "c-function wl_surface_destroy wl_surface_destroy a -- void", "FUNCTION: wl_surface_destroy ( wl_surface -- void )", "EXTERN: \"C\" void wl_surface_destroy( void * wl_surface );", "	( wl_surface -- )" );
	swigFunction( "c-function wl_surface_attach wl_surface_attach a a n n -- void", "FUNCTION: wl_surface_attach ( wl_surface buffer x y -- void )", "EXTERN: \"C\" void wl_surface_attach( void * wl_surface, void * buffer, int x, int y );", "	( wl_surface buffer x y -- )" );
	swigFunction( "c-function wl_surface_damage wl_surface_damage a n n n n -- void", "FUNCTION: wl_surface_damage ( wl_surface x y width height -- void )", "EXTERN: \"C\" void wl_surface_damage( void * wl_surface, int x, int y, int width, int height );", "	( wl_surface x y width height -- )" );
	swigFunction( "c-function wl_surface_frame wl_surface_frame a -- a", "FUNCTION: wl_surface_frame ( wl_surface -- a )", "EXTERN: \"C\" void * wl_surface_frame( void * wl_surface );", "	( wl_surface -- )" );
	swigFunction( "c-function wl_surface_set_opaque_region wl_surface_set_opaque_region a a -- void", "FUNCTION: wl_surface_set_opaque_region ( wl_surface region -- void )", "EXTERN: \"C\" void wl_surface_set_opaque_region( void * wl_surface, void * region );", "	( wl_surface region -- )" );
	swigFunction( "c-function wl_surface_set_input_region wl_surface_set_input_region a a -- void", "FUNCTION: wl_surface_set_input_region ( wl_surface region -- void )", "EXTERN: \"C\" void wl_surface_set_input_region( void * wl_surface, void * region );", "	( wl_surface region -- )" );
	swigFunction( "c-function wl_surface_commit wl_surface_commit a -- void", "FUNCTION: wl_surface_commit ( wl_surface -- void )", "EXTERN: \"C\" void wl_surface_commit( void * wl_surface );", "	( wl_surface -- )" );
	swigFunction( "c-function wl_surface_set_buffer_transform wl_surface_set_buffer_transform a n -- void", "FUNCTION: wl_surface_set_buffer_transform ( wl_surface transform -- void )", "EXTERN: \"C\" void wl_surface_set_buffer_transform( void * wl_surface, int transform );", "	( wl_surface transform -- )" );
	swigFunction( "c-function wl_surface_set_buffer_scale wl_surface_set_buffer_scale a n -- void", "FUNCTION: wl_surface_set_buffer_scale ( wl_surface scale -- void )", "EXTERN: \"C\" void wl_surface_set_buffer_scale( void * wl_surface, int scale );", "	( wl_surface scale -- )" );
	swigFunction( "c-function wl_surface_damage_buffer wl_surface_damage_buffer a n n n n -- void", "FUNCTION: wl_surface_damage_buffer ( wl_surface x y width height -- void )", "EXTERN: \"C\" void wl_surface_damage_buffer( void * wl_surface, int x, int y, int width, int height );", "	( wl_surface x y width height -- )" );
	swigFunction( "c-function wl_seat_add_listener wl_seat_add_listener a a a -- n", "FUNCTION: wl_seat_add_listener ( wl_seat listener data -- n )", "EXTERN: \"C\" int wl_seat_add_listener( void * wl_seat, void * listener, void * data );", "	( wl_seat listener data -- )" );
	swigFunction( "c-function wl_seat_set_user_data wl_seat_set_user_data a a -- void", "FUNCTION: wl_seat_set_user_data ( wl_seat user_data -- void )", "EXTERN: \"C\" void wl_seat_set_user_data( void * wl_seat, void * user_data );", "	( wl_seat user_data -- )" );
	swigFunction( "c-function wl_seat_get_user_data wl_seat_get_user_data a -- a", "FUNCTION: wl_seat_get_user_data ( wl_seat -- a )", "EXTERN: \"C\" void * wl_seat_get_user_data( void * wl_seat );", "	( wl_seat -- )" );
	swigFunction( "c-function wl_seat_get_version wl_seat_get_version a -- u", "FUNCTION: wl_seat_get_version ( wl_seat -- u )", "EXTERN: \"C\" int wl_seat_get_version( void * wl_seat );", "	( wl_seat -- )" );
	swigFunction( "c-function wl_seat_destroy wl_seat_destroy a -- void", "FUNCTION: wl_seat_destroy ( wl_seat -- void )", "EXTERN: \"C\" void wl_seat_destroy( void * wl_seat );", "	( wl_seat -- )" );
	swigFunction( "c-function wl_seat_get_pointer wl_seat_get_pointer a -- a", "FUNCTION: wl_seat_get_pointer ( wl_seat -- a )", "EXTERN: \"C\" void * wl_seat_get_pointer( void * wl_seat );", "	( wl_seat -- )" );
	swigFunction( "c-function wl_seat_get_keyboard wl_seat_get_keyboard a -- a", "FUNCTION: wl_seat_get_keyboard ( wl_seat -- a )", "EXTERN: \"C\" void * wl_seat_get_keyboard( void * wl_seat );", "	( wl_seat -- )" );
	swigFunction( "c-function wl_seat_get_touch wl_seat_get_touch a -- a", "FUNCTION: wl_seat_get_touch ( wl_seat -- a )", "EXTERN: \"C\" void * wl_seat_get_touch( void * wl_seat );", "	( wl_seat -- )" );
	swigFunction( "c-function wl_seat_release wl_seat_release a -- void", "FUNCTION: wl_seat_release ( wl_seat -- void )", "EXTERN: \"C\" void wl_seat_release( void * wl_seat );", "	( wl_seat -- )" );
	swigFunction( "c-function wl_pointer_add_listener wl_pointer_add_listener a a a -- n", "FUNCTION: wl_pointer_add_listener ( wl_pointer listener data -- n )", "EXTERN: \"C\" int wl_pointer_add_listener( void * wl_pointer, void * listener, void * data );", "	( wl_pointer listener data -- )" );
	swigFunction( "c-function wl_pointer_set_user_data wl_pointer_set_user_data a a -- void", "FUNCTION: wl_pointer_set_user_data ( wl_pointer user_data -- void )", "EXTERN: \"C\" void wl_pointer_set_user_data( void * wl_pointer, void * user_data );", "	( wl_pointer user_data -- )" );
	swigFunction( "c-function wl_pointer_get_user_data wl_pointer_get_user_data a -- a", "FUNCTION: wl_pointer_get_user_data ( wl_pointer -- a )", "EXTERN: \"C\" void * wl_pointer_get_user_data( void * wl_pointer );", "	( wl_pointer -- )" );
	swigFunction( "c-function wl_pointer_get_version wl_pointer_get_version a -- u", "FUNCTION: wl_pointer_get_version ( wl_pointer -- u )", "EXTERN: \"C\" int wl_pointer_get_version( void * wl_pointer );", "	( wl_pointer -- )" );
	swigFunction( "c-function wl_pointer_destroy wl_pointer_destroy a -- void", "FUNCTION: wl_pointer_destroy ( wl_pointer -- void )", "EXTERN: \"C\" void wl_pointer_destroy( void * wl_pointer );", "	( wl_pointer -- )" );
	swigFunction( "c-function wl_pointer_set_cursor wl_pointer_set_cursor a u a n n -- void", "FUNCTION: wl_pointer_set_cursor ( wl_pointer serial surface hotspot_x hotspot_y -- void )", "EXTERN: \"C\" void wl_pointer_set_cursor( void * wl_pointer, int serial, void * surface, int hotspot_x, int hotspot_y );", "	( wl_pointer serial surface hotspot_x hotspot_y -- )" );
	swigFunction( "c-function wl_pointer_release wl_pointer_release a -- void", "FUNCTION: wl_pointer_release ( wl_pointer -- void )", "EXTERN: \"C\" void wl_pointer_release( void * wl_pointer );", "	( wl_pointer -- )" );
	swigFunction( "c-function wl_keyboard_add_listener wl_keyboard_add_listener a a a -- n", "FUNCTION: wl_keyboard_add_listener ( wl_keyboard listener data -- n )", "EXTERN: \"C\" int wl_keyboard_add_listener( void * wl_keyboard, void * listener, void * data );", "	( wl_keyboard listener data -- )" );
	swigFunction( "c-function wl_keyboard_set_user_data wl_keyboard_set_user_data a a -- void", "FUNCTION: wl_keyboard_set_user_data ( wl_keyboard user_data -- void )", "EXTERN: \"C\" void wl_keyboard_set_user_data( void * wl_keyboard, void * user_data );", "	( wl_keyboard user_data -- )" );
	swigFunction( "c-function wl_keyboard_get_user_data wl_keyboard_get_user_data a -- a", "FUNCTION: wl_keyboard_get_user_data ( wl_keyboard -- a )", "EXTERN: \"C\" void * wl_keyboard_get_user_data( void * wl_keyboard );", "	( wl_keyboard -- )" );
	swigFunction( "c-function wl_keyboard_get_version wl_keyboard_get_version a -- u", "FUNCTION: wl_keyboard_get_version ( wl_keyboard -- u )", "EXTERN: \"C\" int wl_keyboard_get_version( void * wl_keyboard );", "	( wl_keyboard -- )" );
	swigFunction( "c-function wl_keyboard_destroy wl_keyboard_destroy a -- void", "FUNCTION: wl_keyboard_destroy ( wl_keyboard -- void )", "EXTERN: \"C\" void wl_keyboard_destroy( void * wl_keyboard );", "	( wl_keyboard -- )" );
	swigFunction( "c-function wl_keyboard_release wl_keyboard_release a -- void", "FUNCTION: wl_keyboard_release ( wl_keyboard -- void )", "EXTERN: \"C\" void wl_keyboard_release( void * wl_keyboard );", "	( wl_keyboard -- )" );
	swigFunction( "c-function wl_touch_add_listener wl_touch_add_listener a a a -- n", "FUNCTION: wl_touch_add_listener ( wl_touch listener data -- n )", "EXTERN: \"C\" int wl_touch_add_listener( void * wl_touch, void * listener, void * data );", "	( wl_touch listener data -- )" );
	swigFunction( "c-function wl_touch_set_user_data wl_touch_set_user_data a a -- void", "FUNCTION: wl_touch_set_user_data ( wl_touch user_data -- void )", "EXTERN: \"C\" void wl_touch_set_user_data( void * wl_touch, void * user_data );", "	( wl_touch user_data -- )" );
	swigFunction( "c-function wl_touch_get_user_data wl_touch_get_user_data a -- a", "FUNCTION: wl_touch_get_user_data ( wl_touch -- a )", "EXTERN: \"C\" void * wl_touch_get_user_data( void * wl_touch );", "	( wl_touch -- )" );
	swigFunction( "c-function wl_touch_get_version wl_touch_get_version a -- u", "FUNCTION: wl_touch_get_version ( wl_touch -- u )", "EXTERN: \"C\" int wl_touch_get_version( void * wl_touch );", "	( wl_touch -- )" );
	swigFunction( "c-function wl_touch_destroy wl_touch_destroy a -- void", "FUNCTION: wl_touch_destroy ( wl_touch -- void )", "EXTERN: \"C\" void wl_touch_destroy( void * wl_touch );", "	( wl_touch -- )" );
	swigFunction( "c-function wl_touch_release wl_touch_release a -- void", "FUNCTION: wl_touch_release ( wl_touch -- void )", "EXTERN: \"C\" void wl_touch_release( void * wl_touch );", "	( wl_touch -- )" );
	swigFunction( "c-function wl_output_add_listener wl_output_add_listener a a a -- n", "FUNCTION: wl_output_add_listener ( wl_output listener data -- n )", "EXTERN: \"C\" int wl_output_add_listener( void * wl_output, void * listener, void * data );", "	( wl_output listener data -- )" );
	swigFunction( "c-function wl_output_set_user_data wl_output_set_user_data a a -- void", "FUNCTION: wl_output_set_user_data ( wl_output user_data -- void )", "EXTERN: \"C\" void wl_output_set_user_data( void * wl_output, void * user_data );", "	( wl_output user_data -- )" );
	swigFunction( "c-function wl_output_get_user_data wl_output_get_user_data a -- a", "FUNCTION: wl_output_get_user_data ( wl_output -- a )", "EXTERN: \"C\" void * wl_output_get_user_data( void * wl_output );", "	( wl_output -- )" );
	swigFunction( "c-function wl_output_get_version wl_output_get_version a -- u", "FUNCTION: wl_output_get_version ( wl_output -- u )", "EXTERN: \"C\" int wl_output_get_version( void * wl_output );", "	( wl_output -- )" );
	swigFunction( "c-function wl_output_destroy wl_output_destroy a -- void", "FUNCTION: wl_output_destroy ( wl_output -- void )", "EXTERN: \"C\" void wl_output_destroy( void * wl_output );", "	( wl_output -- )" );
	swigFunction( "c-function wl_output_release wl_output_release a -- void", "FUNCTION: wl_output_release ( wl_output -- void )", "EXTERN: \"C\" void wl_output_release( void * wl_output );", "	( wl_output -- )" );
	swigFunction( "c-function wl_region_set_user_data wl_region_set_user_data a a -- void", "FUNCTION: wl_region_set_user_data ( wl_region user_data -- void )", "EXTERN: \"C\" void wl_region_set_user_data( void * wl_region, void * user_data );", "	( wl_region user_data -- )" );
	swigFunction( "c-function wl_region_get_user_data wl_region_get_user_data a -- a", "FUNCTION: wl_region_get_user_data ( wl_region -- a )", "EXTERN: \"C\" void * wl_region_get_user_data( void * wl_region );", "	( wl_region -- )" );
	swigFunction( "c-function wl_region_get_version wl_region_get_version a -- u", "FUNCTION: wl_region_get_version ( wl_region -- u )", "EXTERN: \"C\" int wl_region_get_version( void * wl_region );", "	( wl_region -- )" );
	swigFunction( "c-function wl_region_destroy wl_region_destroy a -- void", "FUNCTION: wl_region_destroy ( wl_region -- void )", "EXTERN: \"C\" void wl_region_destroy( void * wl_region );", "	( wl_region -- )" );
	swigFunction( "c-function wl_region_add wl_region_add a n n n n -- void", "FUNCTION: wl_region_add ( wl_region x y width height -- void )", "EXTERN: \"C\" void wl_region_add( void * wl_region, int x, int y, int width, int height );", "	( wl_region x y width height -- )" );
	swigFunction( "c-function wl_region_subtract wl_region_subtract a n n n n -- void", "FUNCTION: wl_region_subtract ( wl_region x y width height -- void )", "EXTERN: \"C\" void wl_region_subtract( void * wl_region, int x, int y, int width, int height );", "	( wl_region x y width height -- )" );
	swigFunction( "c-function wl_subcompositor_set_user_data wl_subcompositor_set_user_data a a -- void", "FUNCTION: wl_subcompositor_set_user_data ( wl_subcompositor user_data -- void )", "EXTERN: \"C\" void wl_subcompositor_set_user_data( void * wl_subcompositor, void * user_data );", "	( wl_subcompositor user_data -- )" );
	swigFunction( "c-function wl_subcompositor_get_user_data wl_subcompositor_get_user_data a -- a", "FUNCTION: wl_subcompositor_get_user_data ( wl_subcompositor -- a )", "EXTERN: \"C\" void * wl_subcompositor_get_user_data( void * wl_subcompositor );", "	( wl_subcompositor -- )" );
	swigFunction( "c-function wl_subcompositor_get_version wl_subcompositor_get_version a -- u", "FUNCTION: wl_subcompositor_get_version ( wl_subcompositor -- u )", "EXTERN: \"C\" int wl_subcompositor_get_version( void * wl_subcompositor );", "	( wl_subcompositor -- )" );
	swigFunction( "c-function wl_subcompositor_destroy wl_subcompositor_destroy a -- void", "FUNCTION: wl_subcompositor_destroy ( wl_subcompositor -- void )", "EXTERN: \"C\" void wl_subcompositor_destroy( void * wl_subcompositor );", "	( wl_subcompositor -- )" );
	swigFunction( "c-function wl_subcompositor_get_subsurface wl_subcompositor_get_subsurface a a a -- a", "FUNCTION: wl_subcompositor_get_subsurface ( wl_subcompositor surface parent -- a )", "EXTERN: \"C\" void * wl_subcompositor_get_subsurface( void * wl_subcompositor, void * surface, void * parent );", "	( wl_subcompositor surface parent -- )" );
	swigFunction( "c-function wl_subsurface_set_user_data wl_subsurface_set_user_data a a -- void", "FUNCTION: wl_subsurface_set_user_data ( wl_subsurface user_data -- void )", "EXTERN: \"C\" void wl_subsurface_set_user_data( void * wl_subsurface, void * user_data );", "	( wl_subsurface user_data -- )" );
	swigFunction( "c-function wl_subsurface_get_user_data wl_subsurface_get_user_data a -- a", "FUNCTION: wl_subsurface_get_user_data ( wl_subsurface -- a )", "EXTERN: \"C\" void * wl_subsurface_get_user_data( void * wl_subsurface );", "	( wl_subsurface -- )" );
	swigFunction( "c-function wl_subsurface_get_version wl_subsurface_get_version a -- u", "FUNCTION: wl_subsurface_get_version ( wl_subsurface -- u )", "EXTERN: \"C\" int wl_subsurface_get_version( void * wl_subsurface );", "	( wl_subsurface -- )" );
	swigFunction( "c-function wl_subsurface_destroy wl_subsurface_destroy a -- void", "FUNCTION: wl_subsurface_destroy ( wl_subsurface -- void )", "EXTERN: \"C\" void wl_subsurface_destroy( void * wl_subsurface );", "	( wl_subsurface -- )" );
	swigFunction( "c-function wl_subsurface_set_position wl_subsurface_set_position a n n -- void", "FUNCTION: wl_subsurface_set_position ( wl_subsurface x y -- void )", "EXTERN: \"C\" void wl_subsurface_set_position( void * wl_subsurface, int x, int y );", "	( wl_subsurface x y -- )" );
	swigFunction( "c-function wl_subsurface_place_above wl_subsurface_place_above a a -- void", "FUNCTION: wl_subsurface_place_above ( wl_subsurface sibling -- void )", "EXTERN: \"C\" void wl_subsurface_place_above( void * wl_subsurface, void * sibling );", "	( wl_subsurface sibling -- )" );
	swigFunction( "c-function wl_subsurface_place_below wl_subsurface_place_below a a -- void", "FUNCTION: wl_subsurface_place_below ( wl_subsurface sibling -- void )", "EXTERN: \"C\" void wl_subsurface_place_below( void * wl_subsurface, void * sibling );", "	( wl_subsurface sibling -- )" );
	swigFunction( "c-function wl_subsurface_set_sync wl_subsurface_set_sync a -- void", "FUNCTION: wl_subsurface_set_sync ( wl_subsurface -- void )", "EXTERN: \"C\" void wl_subsurface_set_sync( void * wl_subsurface );", "	( wl_subsurface -- )" );
	swigFunction( "c-function wl_subsurface_set_desync wl_subsurface_set_desync a -- void", "FUNCTION: wl_subsurface_set_desync ( wl_subsurface -- void )", "EXTERN: \"C\" void wl_subsurface_set_desync( void * wl_subsurface );", "	( wl_subsurface -- )" );
	swigFunction( "c-function wl_egl_window_create wl_egl_window_create a n n -- a", "FUNCTION: wl_egl_window_create ( surface width height -- a )", "EXTERN: \"C\" void * wl_egl_window_create( void * surface, int width, int height );", "	( surface width height -- )" );
	swigFunction( "c-function wl_egl_window_destroy wl_egl_window_destroy a -- void", "FUNCTION: wl_egl_window_destroy ( egl_window -- void )", "EXTERN: \"C\" void wl_egl_window_destroy( void * egl_window );", "	( egl_window -- )" );
	swigFunction( "c-function wl_egl_window_resize wl_egl_window_resize a n n n n -- void", "FUNCTION: wl_egl_window_resize ( egl_window width height dx dy -- void )", "EXTERN: \"C\" void wl_egl_window_resize( void * egl_window, int width, int height, int dx, int dy );", "	( egl_window width height dx dy -- )" );
	swigFunction( "c-function wl_egl_window_get_attached_size wl_egl_window_get_attached_size a a a -- void", "FUNCTION: wl_egl_window_get_attached_size ( egl_window width height -- void )", "EXTERN: \"C\" void wl_egl_window_get_attached_size( void * egl_window, void * width, void * height );", "	( egl_window width height -- )" );
	swigFunction( "c-function wl_cursor_theme_load wl_cursor_theme_load s n a -- a", "FUNCTION: wl_cursor_theme_load ( name size shm -- a )", "EXTERN: \"C\" void * wl_cursor_theme_load( char * name, int size, void * shm );", "	( name size shm -- )" );
	swigFunction( "c-function wl_cursor_theme_destroy wl_cursor_theme_destroy a -- void", "FUNCTION: wl_cursor_theme_destroy ( theme -- void )", "EXTERN: \"C\" void wl_cursor_theme_destroy( void * theme );", "	( theme -- )" );
	swigFunction( "c-function wl_cursor_theme_get_cursor wl_cursor_theme_get_cursor a s -- a", "FUNCTION: wl_cursor_theme_get_cursor ( theme name -- a )", "EXTERN: \"C\" void * wl_cursor_theme_get_cursor( void * theme, char * name );", "	( theme name -- )" );
	swigFunction( "c-function wl_cursor_image_get_buffer wl_cursor_image_get_buffer a -- a", "FUNCTION: wl_cursor_image_get_buffer ( image -- a )", "EXTERN: \"C\" void * wl_cursor_image_get_buffer( void * image );", "	( image -- )" );
	swigFunction( "c-function wl_cursor_frame wl_cursor_frame a u -- n", "FUNCTION: wl_cursor_frame ( cursor time -- n )", "EXTERN: \"C\" int wl_cursor_frame( void * cursor, int time );", "	( cursor time -- )" );
	swigFunction( "c-function wl_cursor_frame_and_duration wl_cursor_frame_and_duration a u a -- n", "FUNCTION: wl_cursor_frame_and_duration ( cursor time duration -- n )", "EXTERN: \"C\" int wl_cursor_frame_and_duration( void * cursor, int time, void * duration );", "	( cursor time duration -- )" );
	
	return 0;
} /* end of main */



