/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 3.0.9
 *
 * This file is not intended to be easily readable and contains a number of
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG
 * interface file instead.
 * ----------------------------------------------------------------------------- */
#include <stdio.h>
#include <string.h>
#include <stddef.h>

// Do not edit below this line
// end-of-default-includes


#define GST_USE_UNSTABLE_API
#include <gst/gst.h>
#include <gst/gl/gl.h>
#include <gst/gl/egl/gstgldisplay_egl.h>
#include <gst/gl/x11/gstgldisplay_x11.h>

typedef enum{ NONE = -1, GFORTH = 0, SWIFTFORTH, VFX } SwigTargetSystem;
SwigTargetSystem swigTargetSystem = NONE;

unsigned char swigPrintStackComments = 1;

/* comments */
void swigNewline()
{
	printf( "\n" );
}

void swigComment( char *comment )
{
	printf( "\\ %s", comment );
}

/* generic print */
void swigPrint( char* gforth, char *swiftForth, char *vfx )
{
	if( swigTargetSystem == GFORTH )
		printf( "%s", gforth );
	else if( swigTargetSystem == SWIFTFORTH )
		printf( "%s", swiftForth );
	else if( swigTargetSystem == VFX )
		printf( "%s", vfx );
	printf( "\n" );
}
void swigPrintSystem( SwigTargetSystem targetSystem, char *text )
{
	if( targetSystem == swigTargetSystem )
	    printf( "%s\n", text );
}

/* constants */
void swigIntConstant( long constant, char *name )
{
	printf( "#%ld\tconstant %s\n", constant, name );
}

void swigUnsignedIntConstant( unsigned long constant, char *name )
{
	printf( "#%lu\tconstant %s\n", constant, name );
}

void swigLongConstant( long long constant, char *name )
{
	printf( "#%lld.\t2constant %s\n", constant, name );
}

void swigUnsignedLongConstant( unsigned long long constant, char *name )
{
	printf( "#%llu.\t2constant %s\n", constant, name );
}

void swigFloatConstant( double constant, char *name )
{
	char buffer[128];
	sprintf( buffer, "%f", constant );

	/* if the constant contains no exponent, add one */
	char *s;
	for( s = buffer; *s != 0; s++ )
		if( *s == 'e' || *s == 'E' )
			break;

	/* exponent found */
	if( *s != 0 )
		printf( "%s\tfconstant %s\n", buffer, name );
	/* not found */
	else
		printf( "%se0\tfconstant %s\n", buffer, name );
}

void swigStringConstant( char* constant, char *name )
{
	char c;
	printf( ": %s s\\\" ", name );
	while(( c = *constant++ ))
	{
		switch(c)
		{
			case '\b': printf( "\\b" ); break;
			case '\n': printf( "\\n" ); break;
			case '\f': printf( "\\f" ); break;
			case '\r': printf( "\\r" ); break;
			case '\t': printf( "\\t" ); break;
			case '"' : printf( "\\q" ); break;
			default:
				if(c < 0x20)
					printf("\\x%02x", c);
				else
					printf("%c", c); break;
		}
	}
	printf(	"\" ;\n" );
}

/* structs */
void swigStructField( char *name, size_t offset, size_t size )
{
	printf( "\tdrop %zu %zu +field %s\n", offset, size, name );
}

/* functions */
void swigFunction( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	if( swigTargetSystem == GFORTH )
		printf( "%s", gforth );
	else if( swigTargetSystem == SWIFTFORTH )
		printf( "%s", swiftForth );
	else if( swigTargetSystem == VFX )
		printf( "%s", vfx );

	if( swigPrintStackComments )
		printf( "%s", stackComment );

	printf( "\n" );
}

/* function pointers */
void swigFunctionPointer( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	swigFunction( gforth, swiftForth, vfx, stackComment );
}

/* callbacks */
void swigCallback( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	swigFunction( gforth, swiftForth, vfx, stackComment );
}

void swigUsage( char **argv )
{
	fprintf( stderr, "Usage: %s [-gforth|-swiftforth|-vfx]\n", argv[0] );
}

int main( int argc, char **argv )
{
	int i;

	/* check arguments */
	for( i = 1; i < argc; i++ )
		if( strcmp( argv[i], "-gforth" ) == 0 )
			swigTargetSystem = GFORTH;
		else if( strcmp( argv[i], "-swiftforth" ) == 0 )
			swigTargetSystem = SWIFTFORTH;
		else if( strcmp( argv[i], "-vfx" ) == 0 )
			swigTargetSystem = VFX;

	if( swigTargetSystem == NONE )
	{
		fprintf( stderr, "Error: no target system specified\n" );
		swigUsage( argv );
		return 1;
	}

	/* primer */
	printf( "\\ This file has been generated using SWIG and fsi,\n"
		"\\ and is already platform dependent, search for the corresponding\n"
		"\\ fsi-file to compile it where no one has compiled it before ;)\n"
		"\\ Forth systems have their own own dynamic loader and don't need addional C-Code.\n"
		"\\ That's why this file will just print normal forth-code once compiled\n"
		"\\ and can be used directly with include or require.\n"
		"\\ As all comments are stripped during the compilation, please\n"
		"\\ insert the copyright notice of the original file here.\n"
	);


typedef union {
  gpointer _gst_reserved[GST_PADDING];
  struct {
    GstFlowReturn flow_ret;
  } abi;
} _GstPadProbeInfo_ABI;

typedef struct {
  GstFlowReturn flow_ret;
} _GstPadProbeInfo_ABI_abi;

typedef union {
  gpointer _gst_reserved[GST_PADDING];
  struct {
    GstFlowReturn last_flowret;
    GstPadEventFullFunction eventfullfunc;
  } abi;
} _GstPad_ABI;

typedef struct {
  GstFlowReturn last_flowret;
  GstPadEventFullFunction eventfullfunc;
} _GstPad_ABI_abi;


	swigNewline();

	swigComment("----===< prefix >===-----\n");

	swigPrint( "c-library gst\ns\" gstreamer-1.0\" add-lib\n\\c #define GST_USE_UNSTABLE_API\n\\c #include <gst/gst.h>\n\\c #include <gst/gl/gl.h>\n\\c #include <gst/gl/egl/gstgldisplay_egl.h>\n\\c #include <gst/gl/x11/gstgldisplay_x11.h>", "( none )", "( none )" );

	swigNewline();

	swigComment("----===< int constants >===-----\n");
	#ifdef GST_VERSION_MAJOR
		swigIntConstant( GST_VERSION_MAJOR, "GST_VERSION_MAJOR" );
	#endif
	#ifdef GST_VERSION_MINOR
		swigIntConstant( GST_VERSION_MINOR, "GST_VERSION_MINOR" );
	#endif
	#ifdef GST_VERSION_MICRO
		swigIntConstant( GST_VERSION_MICRO, "GST_VERSION_MICRO" );
	#endif
	#ifdef GST_VERSION_NANO
		swigIntConstant( GST_VERSION_NANO, "GST_VERSION_NANO" );
	#endif
	#ifdef GST_EVENT_NUM_SHIFT
		swigIntConstant( GST_EVENT_NUM_SHIFT, "GST_EVENT_NUM_SHIFT" );
	#endif
	#ifdef GST_QUERY_NUM_SHIFT
		swigIntConstant( GST_QUERY_NUM_SHIFT, "GST_QUERY_NUM_SHIFT" );
	#endif
	#ifdef GST_TOC_REPEAT_COUNT_INFINITE
		swigIntConstant( GST_TOC_REPEAT_COUNT_INFINITE, "GST_TOC_REPEAT_COUNT_INFINITE" );
	#endif
	#ifdef GST_URI_NO_PORT
		swigIntConstant( GST_URI_NO_PORT, "GST_URI_NO_PORT" );
	#endif
	#ifdef GST_SEQNUM_INVALID
		swigIntConstant( GST_SEQNUM_INVALID, "GST_SEQNUM_INVALID" );
	#endif
	#ifdef GST_GROUP_ID_INVALID
		swigIntConstant( GST_GROUP_ID_INVALID, "GST_GROUP_ID_INVALID" );
	#endif
	#ifdef GST_VALUE_LESS_THAN
		swigIntConstant( GST_VALUE_LESS_THAN, "GST_VALUE_LESS_THAN" );
	#endif
	#ifdef GST_VALUE_EQUAL
		swigIntConstant( GST_VALUE_EQUAL, "GST_VALUE_EQUAL" );
	#endif
	#ifdef GST_VALUE_GREATER_THAN
		swigIntConstant( GST_VALUE_GREATER_THAN, "GST_VALUE_GREATER_THAN" );
	#endif
	#ifdef GST_VALUE_UNORDERED
		swigIntConstant( GST_VALUE_UNORDERED, "GST_VALUE_UNORDERED" );
	#endif
	#ifdef GST_GL_HAVE_OPENGL
		swigIntConstant( GST_GL_HAVE_OPENGL, "GST_GL_HAVE_OPENGL" );
	#endif
	#ifdef GST_GL_HAVE_GLES2
		swigIntConstant( GST_GL_HAVE_GLES2, "GST_GL_HAVE_GLES2" );
	#endif
	#ifdef GST_GL_HAVE_GLES3
		swigIntConstant( GST_GL_HAVE_GLES3, "GST_GL_HAVE_GLES3" );
	#endif
	#ifdef GST_GL_HAVE_GLES3EXT3_H
		swigIntConstant( GST_GL_HAVE_GLES3EXT3_H, "GST_GL_HAVE_GLES3EXT3_H" );
	#endif
	#ifdef GST_GL_HAVE_WINDOW_X11
		swigIntConstant( GST_GL_HAVE_WINDOW_X11, "GST_GL_HAVE_WINDOW_X11" );
	#endif
	#ifdef GST_GL_HAVE_WINDOW_COCOA
		swigIntConstant( GST_GL_HAVE_WINDOW_COCOA, "GST_GL_HAVE_WINDOW_COCOA" );
	#endif
	#ifdef GST_GL_HAVE_WINDOW_WIN32
		swigIntConstant( GST_GL_HAVE_WINDOW_WIN32, "GST_GL_HAVE_WINDOW_WIN32" );
	#endif
	#ifdef GST_GL_HAVE_WINDOW_WAYLAND
		swigIntConstant( GST_GL_HAVE_WINDOW_WAYLAND, "GST_GL_HAVE_WINDOW_WAYLAND" );
	#endif
	#ifdef GST_GL_HAVE_WINDOW_ANDROID
		swigIntConstant( GST_GL_HAVE_WINDOW_ANDROID, "GST_GL_HAVE_WINDOW_ANDROID" );
	#endif
	#ifdef GST_GL_HAVE_WINDOW_DISPMANX
		swigIntConstant( GST_GL_HAVE_WINDOW_DISPMANX, "GST_GL_HAVE_WINDOW_DISPMANX" );
	#endif
	#ifdef GST_GL_HAVE_WINDOW_EAGL
		swigIntConstant( GST_GL_HAVE_WINDOW_EAGL, "GST_GL_HAVE_WINDOW_EAGL" );
	#endif
	#ifdef GST_GL_HAVE_WINDOW_VIV_FB
		swigIntConstant( GST_GL_HAVE_WINDOW_VIV_FB, "GST_GL_HAVE_WINDOW_VIV_FB" );
	#endif
	#ifdef GST_GL_HAVE_WINDOW_GBM
		swigIntConstant( GST_GL_HAVE_WINDOW_GBM, "GST_GL_HAVE_WINDOW_GBM" );
	#endif
	#ifdef GST_GL_HAVE_PLATFORM_EGL
		swigIntConstant( GST_GL_HAVE_PLATFORM_EGL, "GST_GL_HAVE_PLATFORM_EGL" );
	#endif
	#ifdef GST_GL_HAVE_PLATFORM_GLX
		swigIntConstant( GST_GL_HAVE_PLATFORM_GLX, "GST_GL_HAVE_PLATFORM_GLX" );
	#endif
	#ifdef GST_GL_HAVE_PLATFORM_WGL
		swigIntConstant( GST_GL_HAVE_PLATFORM_WGL, "GST_GL_HAVE_PLATFORM_WGL" );
	#endif
	#ifdef GST_GL_HAVE_PLATFORM_CGL
		swigIntConstant( GST_GL_HAVE_PLATFORM_CGL, "GST_GL_HAVE_PLATFORM_CGL" );
	#endif
	#ifdef GST_GL_HAVE_PLATFORM_EAGL
		swigIntConstant( GST_GL_HAVE_PLATFORM_EAGL, "GST_GL_HAVE_PLATFORM_EAGL" );
	#endif
	#ifdef GST_GL_HAVE_DMABUF
		swigIntConstant( GST_GL_HAVE_DMABUF, "GST_GL_HAVE_DMABUF" );
	#endif
	#ifdef GST_GL_HAVE_VIV_DIRECTVIV
		swigIntConstant( GST_GL_HAVE_VIV_DIRECTVIV, "GST_GL_HAVE_VIV_DIRECTVIV" );
	#endif
	#ifdef GST_GL_HAVE_GLEGLIMAGEOES
		swigIntConstant( GST_GL_HAVE_GLEGLIMAGEOES, "GST_GL_HAVE_GLEGLIMAGEOES" );
	#endif
	#ifdef GST_GL_HAVE_GLCHAR
		swigIntConstant( GST_GL_HAVE_GLCHAR, "GST_GL_HAVE_GLCHAR" );
	#endif
	#ifdef GST_GL_HAVE_GLSIZEIPTR
		swigIntConstant( GST_GL_HAVE_GLSIZEIPTR, "GST_GL_HAVE_GLSIZEIPTR" );
	#endif
	#ifdef GST_GL_HAVE_GLINTPTR
		swigIntConstant( GST_GL_HAVE_GLINTPTR, "GST_GL_HAVE_GLINTPTR" );
	#endif
	#ifdef GST_GL_HAVE_GLSYNC
		swigIntConstant( GST_GL_HAVE_GLSYNC, "GST_GL_HAVE_GLSYNC" );
	#endif
	#ifdef GST_GL_HAVE_GLUINT64
		swigIntConstant( GST_GL_HAVE_GLUINT64, "GST_GL_HAVE_GLUINT64" );
	#endif
	#ifdef GST_GL_HAVE_GLINT64
		swigIntConstant( GST_GL_HAVE_GLINT64, "GST_GL_HAVE_GLINT64" );
	#endif
	#ifdef GST_GL_HAVE_EGLATTRIB
		swigIntConstant( GST_GL_HAVE_EGLATTRIB, "GST_GL_HAVE_EGLATTRIB" );
	#endif
	#ifdef GST_GL_HAVE_EGLUINT64KHR
		swigIntConstant( GST_GL_HAVE_EGLUINT64KHR, "GST_GL_HAVE_EGLUINT64KHR" );
	#endif
	#ifdef GST_GL_ALLOCATION_PARAMS_ALLOC_FLAG_VIDEO
		swigIntConstant( GST_GL_ALLOCATION_PARAMS_ALLOC_FLAG_VIDEO, "GST_GL_ALLOCATION_PARAMS_ALLOC_FLAG_VIDEO" );
	#endif

	swigNewline();

	swigComment("--------===< enums >===---------\n");
	swigIntConstant( GST_BIN_FLAG_NO_RESYNC, "GST_BIN_FLAG_NO_RESYNC" );
	swigIntConstant( GST_BIN_FLAG_STREAMS_AWARE, "GST_BIN_FLAG_STREAMS_AWARE" );
	swigIntConstant( GST_BIN_FLAG_LAST, "GST_BIN_FLAG_LAST" );
	swigIntConstant( GST_BUFFER_FLAG_LIVE, "GST_BUFFER_FLAG_LIVE" );
	swigIntConstant( GST_BUFFER_FLAG_DECODE_ONLY, "GST_BUFFER_FLAG_DECODE_ONLY" );
	swigIntConstant( GST_BUFFER_FLAG_DISCONT, "GST_BUFFER_FLAG_DISCONT" );
	swigIntConstant( GST_BUFFER_FLAG_RESYNC, "GST_BUFFER_FLAG_RESYNC" );
	swigIntConstant( GST_BUFFER_FLAG_CORRUPTED, "GST_BUFFER_FLAG_CORRUPTED" );
	swigIntConstant( GST_BUFFER_FLAG_MARKER, "GST_BUFFER_FLAG_MARKER" );
	swigIntConstant( GST_BUFFER_FLAG_HEADER, "GST_BUFFER_FLAG_HEADER" );
	swigIntConstant( GST_BUFFER_FLAG_GAP, "GST_BUFFER_FLAG_GAP" );
	swigIntConstant( GST_BUFFER_FLAG_DROPPABLE, "GST_BUFFER_FLAG_DROPPABLE" );
	swigIntConstant( GST_BUFFER_FLAG_DELTA_UNIT, "GST_BUFFER_FLAG_DELTA_UNIT" );
	swigIntConstant( GST_BUFFER_FLAG_TAG_MEMORY, "GST_BUFFER_FLAG_TAG_MEMORY" );
	swigIntConstant( GST_BUFFER_FLAG_SYNC_AFTER, "GST_BUFFER_FLAG_SYNC_AFTER" );
	swigIntConstant( GST_BUFFER_FLAG_NON_DROPPABLE, "GST_BUFFER_FLAG_NON_DROPPABLE" );
	swigIntConstant( GST_BUFFER_FLAG_LAST, "GST_BUFFER_FLAG_LAST" );
	swigIntConstant( GST_BUFFER_COPY_NONE, "GST_BUFFER_COPY_NONE" );
	swigIntConstant( GST_BUFFER_COPY_FLAGS, "GST_BUFFER_COPY_FLAGS" );
	swigIntConstant( GST_BUFFER_COPY_TIMESTAMPS, "GST_BUFFER_COPY_TIMESTAMPS" );
	swigIntConstant( GST_BUFFER_COPY_META, "GST_BUFFER_COPY_META" );
	swigIntConstant( GST_BUFFER_COPY_MEMORY, "GST_BUFFER_COPY_MEMORY" );
	swigIntConstant( GST_BUFFER_COPY_MERGE, "GST_BUFFER_COPY_MERGE" );
	swigIntConstant( GST_BUFFER_COPY_DEEP, "GST_BUFFER_COPY_DEEP" );
	swigIntConstant( GST_BUFFER_POOL_ACQUIRE_FLAG_NONE, "GST_BUFFER_POOL_ACQUIRE_FLAG_NONE" );
	swigIntConstant( GST_BUFFER_POOL_ACQUIRE_FLAG_KEY_UNIT, "GST_BUFFER_POOL_ACQUIRE_FLAG_KEY_UNIT" );
	swigIntConstant( GST_BUFFER_POOL_ACQUIRE_FLAG_DONTWAIT, "GST_BUFFER_POOL_ACQUIRE_FLAG_DONTWAIT" );
	swigIntConstant( GST_BUFFER_POOL_ACQUIRE_FLAG_DISCONT, "GST_BUFFER_POOL_ACQUIRE_FLAG_DISCONT" );
	swigIntConstant( GST_BUFFER_POOL_ACQUIRE_FLAG_LAST, "GST_BUFFER_POOL_ACQUIRE_FLAG_LAST" );
	swigIntConstant( GST_BUS_FLUSHING, "GST_BUS_FLUSHING" );
	swigIntConstant( GST_BUS_FLAG_LAST, "GST_BUS_FLAG_LAST" );
	swigIntConstant( GST_BUS_DROP, "GST_BUS_DROP" );
	swigIntConstant( GST_BUS_PASS, "GST_BUS_PASS" );
	swigIntConstant( GST_BUS_ASYNC, "GST_BUS_ASYNC" );
	swigIntConstant( GST_CAPS_FLAG_ANY, "GST_CAPS_FLAG_ANY" );
	swigIntConstant( GST_CAPS_INTERSECT_ZIG_ZAG, "GST_CAPS_INTERSECT_ZIG_ZAG" );
	swigIntConstant( GST_CAPS_INTERSECT_FIRST, "GST_CAPS_INTERSECT_FIRST" );
	swigIntConstant( GST_CLOCK_OK, "GST_CLOCK_OK" );
	swigIntConstant( GST_CLOCK_EARLY, "GST_CLOCK_EARLY" );
	swigIntConstant( GST_CLOCK_UNSCHEDULED, "GST_CLOCK_UNSCHEDULED" );
	swigIntConstant( GST_CLOCK_BUSY, "GST_CLOCK_BUSY" );
	swigIntConstant( GST_CLOCK_BADTIME, "GST_CLOCK_BADTIME" );
	swigIntConstant( GST_CLOCK_ERROR, "GST_CLOCK_ERROR" );
	swigIntConstant( GST_CLOCK_UNSUPPORTED, "GST_CLOCK_UNSUPPORTED" );
	swigIntConstant( GST_CLOCK_DONE, "GST_CLOCK_DONE" );
	swigIntConstant( GST_CLOCK_ENTRY_SINGLE, "GST_CLOCK_ENTRY_SINGLE" );
	swigIntConstant( GST_CLOCK_ENTRY_PERIODIC, "GST_CLOCK_ENTRY_PERIODIC" );
	swigIntConstant( GST_CLOCK_FLAG_CAN_DO_SINGLE_SYNC, "GST_CLOCK_FLAG_CAN_DO_SINGLE_SYNC" );
	swigIntConstant( GST_CLOCK_FLAG_CAN_DO_SINGLE_ASYNC, "GST_CLOCK_FLAG_CAN_DO_SINGLE_ASYNC" );
	swigIntConstant( GST_CLOCK_FLAG_CAN_DO_PERIODIC_SYNC, "GST_CLOCK_FLAG_CAN_DO_PERIODIC_SYNC" );
	swigIntConstant( GST_CLOCK_FLAG_CAN_DO_PERIODIC_ASYNC, "GST_CLOCK_FLAG_CAN_DO_PERIODIC_ASYNC" );
	swigIntConstant( GST_CLOCK_FLAG_CAN_SET_RESOLUTION, "GST_CLOCK_FLAG_CAN_SET_RESOLUTION" );
	swigIntConstant( GST_CLOCK_FLAG_CAN_SET_MASTER, "GST_CLOCK_FLAG_CAN_SET_MASTER" );
	swigIntConstant( GST_CLOCK_FLAG_NEEDS_STARTUP_SYNC, "GST_CLOCK_FLAG_NEEDS_STARTUP_SYNC" );
	swigIntConstant( GST_CLOCK_FLAG_LAST, "GST_CLOCK_FLAG_LAST" );
	swigIntConstant( GST_DEBUG_GRAPH_SHOW_MEDIA_TYPE, "GST_DEBUG_GRAPH_SHOW_MEDIA_TYPE" );
	swigIntConstant( GST_DEBUG_GRAPH_SHOW_CAPS_DETAILS, "GST_DEBUG_GRAPH_SHOW_CAPS_DETAILS" );
	swigIntConstant( GST_DEBUG_GRAPH_SHOW_NON_DEFAULT_PARAMS, "GST_DEBUG_GRAPH_SHOW_NON_DEFAULT_PARAMS" );
	swigIntConstant( GST_DEBUG_GRAPH_SHOW_STATES, "GST_DEBUG_GRAPH_SHOW_STATES" );
	swigIntConstant( GST_DEBUG_GRAPH_SHOW_FULL_PARAMS, "GST_DEBUG_GRAPH_SHOW_FULL_PARAMS" );
	swigIntConstant( GST_DEBUG_GRAPH_SHOW_ALL, "GST_DEBUG_GRAPH_SHOW_ALL" );
	swigIntConstant( GST_DEBUG_GRAPH_SHOW_VERBOSE, "GST_DEBUG_GRAPH_SHOW_VERBOSE" );
	swigIntConstant( GST_STATE_VOID_PENDING, "GST_STATE_VOID_PENDING" );
	swigIntConstant( GST_STATE_NULL, "GST_STATE_NULL" );
	swigIntConstant( GST_STATE_READY, "GST_STATE_READY" );
	swigIntConstant( GST_STATE_PAUSED, "GST_STATE_PAUSED" );
	swigIntConstant( GST_STATE_PLAYING, "GST_STATE_PLAYING" );
	swigIntConstant( GST_STATE_CHANGE_FAILURE, "GST_STATE_CHANGE_FAILURE" );
	swigIntConstant( GST_STATE_CHANGE_SUCCESS, "GST_STATE_CHANGE_SUCCESS" );
	swigIntConstant( GST_STATE_CHANGE_ASYNC, "GST_STATE_CHANGE_ASYNC" );
	swigIntConstant( GST_STATE_CHANGE_NO_PREROLL, "GST_STATE_CHANGE_NO_PREROLL" );
	swigIntConstant( GST_STATE_CHANGE_NULL_TO_READY, "GST_STATE_CHANGE_NULL_TO_READY" );
	swigIntConstant( GST_STATE_CHANGE_READY_TO_PAUSED, "GST_STATE_CHANGE_READY_TO_PAUSED" );
	swigIntConstant( GST_STATE_CHANGE_PAUSED_TO_PLAYING, "GST_STATE_CHANGE_PAUSED_TO_PLAYING" );
	swigIntConstant( GST_STATE_CHANGE_PLAYING_TO_PAUSED, "GST_STATE_CHANGE_PLAYING_TO_PAUSED" );
	swigIntConstant( GST_STATE_CHANGE_PAUSED_TO_READY, "GST_STATE_CHANGE_PAUSED_TO_READY" );
	swigIntConstant( GST_STATE_CHANGE_READY_TO_NULL, "GST_STATE_CHANGE_READY_TO_NULL" );
	swigIntConstant( GST_STATE_CHANGE_NULL_TO_NULL, "GST_STATE_CHANGE_NULL_TO_NULL" );
	swigIntConstant( GST_STATE_CHANGE_READY_TO_READY, "GST_STATE_CHANGE_READY_TO_READY" );
	swigIntConstant( GST_STATE_CHANGE_PAUSED_TO_PAUSED, "GST_STATE_CHANGE_PAUSED_TO_PAUSED" );
	swigIntConstant( GST_STATE_CHANGE_PLAYING_TO_PLAYING, "GST_STATE_CHANGE_PLAYING_TO_PLAYING" );
	swigIntConstant( GST_ELEMENT_FLAG_LOCKED_STATE, "GST_ELEMENT_FLAG_LOCKED_STATE" );
	swigIntConstant( GST_ELEMENT_FLAG_SINK, "GST_ELEMENT_FLAG_SINK" );
	swigIntConstant( GST_ELEMENT_FLAG_SOURCE, "GST_ELEMENT_FLAG_SOURCE" );
	swigIntConstant( GST_ELEMENT_FLAG_PROVIDE_CLOCK, "GST_ELEMENT_FLAG_PROVIDE_CLOCK" );
	swigIntConstant( GST_ELEMENT_FLAG_REQUIRE_CLOCK, "GST_ELEMENT_FLAG_REQUIRE_CLOCK" );
	swigIntConstant( GST_ELEMENT_FLAG_INDEXABLE, "GST_ELEMENT_FLAG_INDEXABLE" );
	swigIntConstant( GST_ELEMENT_FLAG_LAST, "GST_ELEMENT_FLAG_LAST" );
	swigIntConstant( GST_CORE_ERROR_FAILED, "GST_CORE_ERROR_FAILED" );
	swigIntConstant( GST_CORE_ERROR_TOO_LAZY, "GST_CORE_ERROR_TOO_LAZY" );
	swigIntConstant( GST_CORE_ERROR_NOT_IMPLEMENTED, "GST_CORE_ERROR_NOT_IMPLEMENTED" );
	swigIntConstant( GST_CORE_ERROR_STATE_CHANGE, "GST_CORE_ERROR_STATE_CHANGE" );
	swigIntConstant( GST_CORE_ERROR_PAD, "GST_CORE_ERROR_PAD" );
	swigIntConstant( GST_CORE_ERROR_THREAD, "GST_CORE_ERROR_THREAD" );
	swigIntConstant( GST_CORE_ERROR_NEGOTIATION, "GST_CORE_ERROR_NEGOTIATION" );
	swigIntConstant( GST_CORE_ERROR_EVENT, "GST_CORE_ERROR_EVENT" );
	swigIntConstant( GST_CORE_ERROR_SEEK, "GST_CORE_ERROR_SEEK" );
	swigIntConstant( GST_CORE_ERROR_CAPS, "GST_CORE_ERROR_CAPS" );
	swigIntConstant( GST_CORE_ERROR_TAG, "GST_CORE_ERROR_TAG" );
	swigIntConstant( GST_CORE_ERROR_MISSING_PLUGIN, "GST_CORE_ERROR_MISSING_PLUGIN" );
	swigIntConstant( GST_CORE_ERROR_CLOCK, "GST_CORE_ERROR_CLOCK" );
	swigIntConstant( GST_CORE_ERROR_DISABLED, "GST_CORE_ERROR_DISABLED" );
	swigIntConstant( GST_CORE_ERROR_NUM_ERRORS, "GST_CORE_ERROR_NUM_ERRORS" );
	swigIntConstant( GST_LIBRARY_ERROR_FAILED, "GST_LIBRARY_ERROR_FAILED" );
	swigIntConstant( GST_LIBRARY_ERROR_TOO_LAZY, "GST_LIBRARY_ERROR_TOO_LAZY" );
	swigIntConstant( GST_LIBRARY_ERROR_INIT, "GST_LIBRARY_ERROR_INIT" );
	swigIntConstant( GST_LIBRARY_ERROR_SHUTDOWN, "GST_LIBRARY_ERROR_SHUTDOWN" );
	swigIntConstant( GST_LIBRARY_ERROR_SETTINGS, "GST_LIBRARY_ERROR_SETTINGS" );
	swigIntConstant( GST_LIBRARY_ERROR_ENCODE, "GST_LIBRARY_ERROR_ENCODE" );
	swigIntConstant( GST_LIBRARY_ERROR_NUM_ERRORS, "GST_LIBRARY_ERROR_NUM_ERRORS" );
	swigIntConstant( GST_RESOURCE_ERROR_FAILED, "GST_RESOURCE_ERROR_FAILED" );
	swigIntConstant( GST_RESOURCE_ERROR_TOO_LAZY, "GST_RESOURCE_ERROR_TOO_LAZY" );
	swigIntConstant( GST_RESOURCE_ERROR_NOT_FOUND, "GST_RESOURCE_ERROR_NOT_FOUND" );
	swigIntConstant( GST_RESOURCE_ERROR_BUSY, "GST_RESOURCE_ERROR_BUSY" );
	swigIntConstant( GST_RESOURCE_ERROR_OPEN_READ, "GST_RESOURCE_ERROR_OPEN_READ" );
	swigIntConstant( GST_RESOURCE_ERROR_OPEN_WRITE, "GST_RESOURCE_ERROR_OPEN_WRITE" );
	swigIntConstant( GST_RESOURCE_ERROR_OPEN_READ_WRITE, "GST_RESOURCE_ERROR_OPEN_READ_WRITE" );
	swigIntConstant( GST_RESOURCE_ERROR_CLOSE, "GST_RESOURCE_ERROR_CLOSE" );
	swigIntConstant( GST_RESOURCE_ERROR_READ, "GST_RESOURCE_ERROR_READ" );
	swigIntConstant( GST_RESOURCE_ERROR_WRITE, "GST_RESOURCE_ERROR_WRITE" );
	swigIntConstant( GST_RESOURCE_ERROR_SEEK, "GST_RESOURCE_ERROR_SEEK" );
	swigIntConstant( GST_RESOURCE_ERROR_SYNC, "GST_RESOURCE_ERROR_SYNC" );
	swigIntConstant( GST_RESOURCE_ERROR_SETTINGS, "GST_RESOURCE_ERROR_SETTINGS" );
	swigIntConstant( GST_RESOURCE_ERROR_NO_SPACE_LEFT, "GST_RESOURCE_ERROR_NO_SPACE_LEFT" );
	swigIntConstant( GST_RESOURCE_ERROR_NOT_AUTHORIZED, "GST_RESOURCE_ERROR_NOT_AUTHORIZED" );
	swigIntConstant( GST_RESOURCE_ERROR_NUM_ERRORS, "GST_RESOURCE_ERROR_NUM_ERRORS" );
	swigIntConstant( GST_STREAM_ERROR_FAILED, "GST_STREAM_ERROR_FAILED" );
	swigIntConstant( GST_STREAM_ERROR_TOO_LAZY, "GST_STREAM_ERROR_TOO_LAZY" );
	swigIntConstant( GST_STREAM_ERROR_NOT_IMPLEMENTED, "GST_STREAM_ERROR_NOT_IMPLEMENTED" );
	swigIntConstant( GST_STREAM_ERROR_TYPE_NOT_FOUND, "GST_STREAM_ERROR_TYPE_NOT_FOUND" );
	swigIntConstant( GST_STREAM_ERROR_WRONG_TYPE, "GST_STREAM_ERROR_WRONG_TYPE" );
	swigIntConstant( GST_STREAM_ERROR_CODEC_NOT_FOUND, "GST_STREAM_ERROR_CODEC_NOT_FOUND" );
	swigIntConstant( GST_STREAM_ERROR_DECODE, "GST_STREAM_ERROR_DECODE" );
	swigIntConstant( GST_STREAM_ERROR_ENCODE, "GST_STREAM_ERROR_ENCODE" );
	swigIntConstant( GST_STREAM_ERROR_DEMUX, "GST_STREAM_ERROR_DEMUX" );
	swigIntConstant( GST_STREAM_ERROR_MUX, "GST_STREAM_ERROR_MUX" );
	swigIntConstant( GST_STREAM_ERROR_FORMAT, "GST_STREAM_ERROR_FORMAT" );
	swigIntConstant( GST_STREAM_ERROR_DECRYPT, "GST_STREAM_ERROR_DECRYPT" );
	swigIntConstant( GST_STREAM_ERROR_DECRYPT_NOKEY, "GST_STREAM_ERROR_DECRYPT_NOKEY" );
	swigIntConstant( GST_STREAM_ERROR_NUM_ERRORS, "GST_STREAM_ERROR_NUM_ERRORS" );
	swigIntConstant( GST_EVENT_TYPE_UPSTREAM, "GST_EVENT_TYPE_UPSTREAM" );
	swigIntConstant( GST_EVENT_TYPE_DOWNSTREAM, "GST_EVENT_TYPE_DOWNSTREAM" );
	swigIntConstant( GST_EVENT_TYPE_SERIALIZED, "GST_EVENT_TYPE_SERIALIZED" );
	swigIntConstant( GST_EVENT_TYPE_STICKY, "GST_EVENT_TYPE_STICKY" );
	swigIntConstant( GST_EVENT_TYPE_STICKY_MULTI, "GST_EVENT_TYPE_STICKY_MULTI" );
	swigIntConstant( GST_EVENT_UNKNOWN, "GST_EVENT_UNKNOWN" );
	swigIntConstant( GST_EVENT_FLUSH_START, "GST_EVENT_FLUSH_START" );
	swigIntConstant( GST_EVENT_FLUSH_STOP, "GST_EVENT_FLUSH_STOP" );
	swigIntConstant( GST_EVENT_STREAM_START, "GST_EVENT_STREAM_START" );
	swigIntConstant( GST_EVENT_CAPS, "GST_EVENT_CAPS" );
	swigIntConstant( GST_EVENT_SEGMENT, "GST_EVENT_SEGMENT" );
	swigIntConstant( GST_EVENT_STREAM_COLLECTION, "GST_EVENT_STREAM_COLLECTION" );
	swigIntConstant( GST_EVENT_TAG, "GST_EVENT_TAG" );
	swigIntConstant( GST_EVENT_BUFFERSIZE, "GST_EVENT_BUFFERSIZE" );
	swigIntConstant( GST_EVENT_SINK_MESSAGE, "GST_EVENT_SINK_MESSAGE" );
	swigIntConstant( GST_EVENT_STREAM_GROUP_DONE, "GST_EVENT_STREAM_GROUP_DONE" );
	swigIntConstant( GST_EVENT_EOS, "GST_EVENT_EOS" );
	swigIntConstant( GST_EVENT_TOC, "GST_EVENT_TOC" );
	swigIntConstant( GST_EVENT_PROTECTION, "GST_EVENT_PROTECTION" );
	swigIntConstant( GST_EVENT_SEGMENT_DONE, "GST_EVENT_SEGMENT_DONE" );
	swigIntConstant( GST_EVENT_GAP, "GST_EVENT_GAP" );
	swigIntConstant( GST_EVENT_QOS, "GST_EVENT_QOS" );
	swigIntConstant( GST_EVENT_SEEK, "GST_EVENT_SEEK" );
	swigIntConstant( GST_EVENT_NAVIGATION, "GST_EVENT_NAVIGATION" );
	swigIntConstant( GST_EVENT_LATENCY, "GST_EVENT_LATENCY" );
	swigIntConstant( GST_EVENT_STEP, "GST_EVENT_STEP" );
	swigIntConstant( GST_EVENT_RECONFIGURE, "GST_EVENT_RECONFIGURE" );
	swigIntConstant( GST_EVENT_TOC_SELECT, "GST_EVENT_TOC_SELECT" );
	swigIntConstant( GST_EVENT_SELECT_STREAMS, "GST_EVENT_SELECT_STREAMS" );
	swigIntConstant( GST_EVENT_CUSTOM_UPSTREAM, "GST_EVENT_CUSTOM_UPSTREAM" );
	swigIntConstant( GST_EVENT_CUSTOM_DOWNSTREAM, "GST_EVENT_CUSTOM_DOWNSTREAM" );
	swigIntConstant( GST_EVENT_CUSTOM_DOWNSTREAM_OOB, "GST_EVENT_CUSTOM_DOWNSTREAM_OOB" );
	swigIntConstant( GST_EVENT_CUSTOM_DOWNSTREAM_STICKY, "GST_EVENT_CUSTOM_DOWNSTREAM_STICKY" );
	swigIntConstant( GST_EVENT_CUSTOM_BOTH, "GST_EVENT_CUSTOM_BOTH" );
	swigIntConstant( GST_EVENT_CUSTOM_BOTH_OOB, "GST_EVENT_CUSTOM_BOTH_OOB" );
	swigIntConstant( GST_STREAM_FLAG_NONE, "GST_STREAM_FLAG_NONE" );
	swigIntConstant( GST_STREAM_FLAG_SPARSE, "GST_STREAM_FLAG_SPARSE" );
	swigIntConstant( GST_STREAM_FLAG_SELECT, "GST_STREAM_FLAG_SELECT" );
	swigIntConstant( GST_STREAM_FLAG_UNSELECT, "GST_STREAM_FLAG_UNSELECT" );
	swigIntConstant( GST_QOS_TYPE_OVERFLOW, "GST_QOS_TYPE_OVERFLOW" );
	swigIntConstant( GST_QOS_TYPE_UNDERFLOW, "GST_QOS_TYPE_UNDERFLOW" );
	swigIntConstant( GST_QOS_TYPE_THROTTLE, "GST_QOS_TYPE_THROTTLE" );
	swigIntConstant( GST_ITERATOR_DONE, "GST_ITERATOR_DONE" );
	swigIntConstant( GST_ITERATOR_OK, "GST_ITERATOR_OK" );
	swigIntConstant( GST_ITERATOR_RESYNC, "GST_ITERATOR_RESYNC" );
	swigIntConstant( GST_ITERATOR_ERROR, "GST_ITERATOR_ERROR" );
	swigIntConstant( GST_ITERATOR_ITEM_SKIP, "GST_ITERATOR_ITEM_SKIP" );
	swigIntConstant( GST_ITERATOR_ITEM_PASS, "GST_ITERATOR_ITEM_PASS" );
	swigIntConstant( GST_ITERATOR_ITEM_END, "GST_ITERATOR_ITEM_END" );
	swigIntConstant( GST_MESSAGE_UNKNOWN, "GST_MESSAGE_UNKNOWN" );
	swigIntConstant( GST_MESSAGE_EOS, "GST_MESSAGE_EOS" );
	swigIntConstant( GST_MESSAGE_ERROR, "GST_MESSAGE_ERROR" );
	swigIntConstant( GST_MESSAGE_WARNING, "GST_MESSAGE_WARNING" );
	swigIntConstant( GST_MESSAGE_INFO, "GST_MESSAGE_INFO" );
	swigIntConstant( GST_MESSAGE_TAG, "GST_MESSAGE_TAG" );
	swigIntConstant( GST_MESSAGE_BUFFERING, "GST_MESSAGE_BUFFERING" );
	swigIntConstant( GST_MESSAGE_STATE_CHANGED, "GST_MESSAGE_STATE_CHANGED" );
	swigIntConstant( GST_MESSAGE_STATE_DIRTY, "GST_MESSAGE_STATE_DIRTY" );
	swigIntConstant( GST_MESSAGE_STEP_DONE, "GST_MESSAGE_STEP_DONE" );
	swigIntConstant( GST_MESSAGE_CLOCK_PROVIDE, "GST_MESSAGE_CLOCK_PROVIDE" );
	swigIntConstant( GST_MESSAGE_CLOCK_LOST, "GST_MESSAGE_CLOCK_LOST" );
	swigIntConstant( GST_MESSAGE_NEW_CLOCK, "GST_MESSAGE_NEW_CLOCK" );
	swigIntConstant( GST_MESSAGE_STRUCTURE_CHANGE, "GST_MESSAGE_STRUCTURE_CHANGE" );
	swigIntConstant( GST_MESSAGE_STREAM_STATUS, "GST_MESSAGE_STREAM_STATUS" );
	swigIntConstant( GST_MESSAGE_APPLICATION, "GST_MESSAGE_APPLICATION" );
	swigIntConstant( GST_MESSAGE_ELEMENT, "GST_MESSAGE_ELEMENT" );
	swigIntConstant( GST_MESSAGE_SEGMENT_START, "GST_MESSAGE_SEGMENT_START" );
	swigIntConstant( GST_MESSAGE_SEGMENT_DONE, "GST_MESSAGE_SEGMENT_DONE" );
	swigIntConstant( GST_MESSAGE_DURATION_CHANGED, "GST_MESSAGE_DURATION_CHANGED" );
	swigIntConstant( GST_MESSAGE_LATENCY, "GST_MESSAGE_LATENCY" );
	swigIntConstant( GST_MESSAGE_ASYNC_START, "GST_MESSAGE_ASYNC_START" );
	swigIntConstant( GST_MESSAGE_ASYNC_DONE, "GST_MESSAGE_ASYNC_DONE" );
	swigIntConstant( GST_MESSAGE_REQUEST_STATE, "GST_MESSAGE_REQUEST_STATE" );
	swigIntConstant( GST_MESSAGE_STEP_START, "GST_MESSAGE_STEP_START" );
	swigIntConstant( GST_MESSAGE_QOS, "GST_MESSAGE_QOS" );
	swigIntConstant( GST_MESSAGE_PROGRESS, "GST_MESSAGE_PROGRESS" );
	swigIntConstant( GST_MESSAGE_TOC, "GST_MESSAGE_TOC" );
	swigIntConstant( GST_MESSAGE_RESET_TIME, "GST_MESSAGE_RESET_TIME" );
	swigIntConstant( GST_MESSAGE_STREAM_START, "GST_MESSAGE_STREAM_START" );
	swigIntConstant( GST_MESSAGE_NEED_CONTEXT, "GST_MESSAGE_NEED_CONTEXT" );
	swigIntConstant( GST_MESSAGE_HAVE_CONTEXT, "GST_MESSAGE_HAVE_CONTEXT" );
	swigIntConstant( GST_MESSAGE_EXTENDED, "GST_MESSAGE_EXTENDED" );
	swigIntConstant( GST_MESSAGE_DEVICE_ADDED, "GST_MESSAGE_DEVICE_ADDED" );
	swigIntConstant( GST_MESSAGE_DEVICE_REMOVED, "GST_MESSAGE_DEVICE_REMOVED" );
	swigIntConstant( GST_MESSAGE_PROPERTY_NOTIFY, "GST_MESSAGE_PROPERTY_NOTIFY" );
	swigIntConstant( GST_MESSAGE_STREAM_COLLECTION, "GST_MESSAGE_STREAM_COLLECTION" );
	swigIntConstant( GST_MESSAGE_STREAMS_SELECTED, "GST_MESSAGE_STREAMS_SELECTED" );
	swigIntConstant( GST_MESSAGE_REDIRECT, "GST_MESSAGE_REDIRECT" );
	swigIntConstant( GST_MESSAGE_ANY, "GST_MESSAGE_ANY" );
	swigIntConstant( GST_STRUCTURE_CHANGE_TYPE_PAD_LINK, "GST_STRUCTURE_CHANGE_TYPE_PAD_LINK" );
	swigIntConstant( GST_STRUCTURE_CHANGE_TYPE_PAD_UNLINK, "GST_STRUCTURE_CHANGE_TYPE_PAD_UNLINK" );
	swigIntConstant( GST_STREAM_STATUS_TYPE_CREATE, "GST_STREAM_STATUS_TYPE_CREATE" );
	swigIntConstant( GST_STREAM_STATUS_TYPE_ENTER, "GST_STREAM_STATUS_TYPE_ENTER" );
	swigIntConstant( GST_STREAM_STATUS_TYPE_LEAVE, "GST_STREAM_STATUS_TYPE_LEAVE" );
	swigIntConstant( GST_STREAM_STATUS_TYPE_DESTROY, "GST_STREAM_STATUS_TYPE_DESTROY" );
	swigIntConstant( GST_STREAM_STATUS_TYPE_START, "GST_STREAM_STATUS_TYPE_START" );
	swigIntConstant( GST_STREAM_STATUS_TYPE_PAUSE, "GST_STREAM_STATUS_TYPE_PAUSE" );
	swigIntConstant( GST_STREAM_STATUS_TYPE_STOP, "GST_STREAM_STATUS_TYPE_STOP" );
	swigIntConstant( GST_PROGRESS_TYPE_START, "GST_PROGRESS_TYPE_START" );
	swigIntConstant( GST_PROGRESS_TYPE_CONTINUE, "GST_PROGRESS_TYPE_CONTINUE" );
	swigIntConstant( GST_PROGRESS_TYPE_COMPLETE, "GST_PROGRESS_TYPE_COMPLETE" );
	swigIntConstant( GST_PROGRESS_TYPE_CANCELED, "GST_PROGRESS_TYPE_CANCELED" );
	swigIntConstant( GST_PROGRESS_TYPE_ERROR, "GST_PROGRESS_TYPE_ERROR" );
	swigIntConstant( GST_MEMORY_FLAG_READONLY, "GST_MEMORY_FLAG_READONLY" );
	swigIntConstant( GST_MEMORY_FLAG_NO_SHARE, "GST_MEMORY_FLAG_NO_SHARE" );
	swigIntConstant( GST_MEMORY_FLAG_ZERO_PREFIXED, "GST_MEMORY_FLAG_ZERO_PREFIXED" );
	swigIntConstant( GST_MEMORY_FLAG_ZERO_PADDED, "GST_MEMORY_FLAG_ZERO_PADDED" );
	swigIntConstant( GST_MEMORY_FLAG_PHYSICALLY_CONTIGUOUS, "GST_MEMORY_FLAG_PHYSICALLY_CONTIGUOUS" );
	swigIntConstant( GST_MEMORY_FLAG_NOT_MAPPABLE, "GST_MEMORY_FLAG_NOT_MAPPABLE" );
	swigIntConstant( GST_MEMORY_FLAG_LAST, "GST_MEMORY_FLAG_LAST" );
	swigIntConstant( GST_MAP_READ, "GST_MAP_READ" );
	swigIntConstant( GST_MAP_WRITE, "GST_MAP_WRITE" );
	swigIntConstant( GST_MAP_FLAG_LAST, "GST_MAP_FLAG_LAST" );
	swigIntConstant( GST_META_FLAG_NONE, "GST_META_FLAG_NONE" );
	swigIntConstant( GST_META_FLAG_READONLY, "GST_META_FLAG_READONLY" );
	swigIntConstant( GST_META_FLAG_POOLED, "GST_META_FLAG_POOLED" );
	swigIntConstant( GST_META_FLAG_LOCKED, "GST_META_FLAG_LOCKED" );
	swigIntConstant( GST_META_FLAG_LAST, "GST_META_FLAG_LAST" );
	swigIntConstant( GST_MINI_OBJECT_FLAG_LOCKABLE, "GST_MINI_OBJECT_FLAG_LOCKABLE" );
	swigIntConstant( GST_MINI_OBJECT_FLAG_LOCK_READONLY, "GST_MINI_OBJECT_FLAG_LOCK_READONLY" );
	swigIntConstant( GST_MINI_OBJECT_FLAG_MAY_BE_LEAKED, "GST_MINI_OBJECT_FLAG_MAY_BE_LEAKED" );
	swigIntConstant( GST_MINI_OBJECT_FLAG_LAST, "GST_MINI_OBJECT_FLAG_LAST" );
	swigIntConstant( GST_LOCK_FLAG_READ, "GST_LOCK_FLAG_READ" );
	swigIntConstant( GST_LOCK_FLAG_WRITE, "GST_LOCK_FLAG_WRITE" );
	swigIntConstant( GST_LOCK_FLAG_EXCLUSIVE, "GST_LOCK_FLAG_EXCLUSIVE" );
	swigIntConstant( GST_LOCK_FLAG_LAST, "GST_LOCK_FLAG_LAST" );
	swigIntConstant( GST_OBJECT_FLAG_MAY_BE_LEAKED, "GST_OBJECT_FLAG_MAY_BE_LEAKED" );
	swigIntConstant( GST_OBJECT_FLAG_LAST, "GST_OBJECT_FLAG_LAST" );
	swigIntConstant( GST_PAD_UNKNOWN, "GST_PAD_UNKNOWN" );
	swigIntConstant( GST_PAD_SRC, "GST_PAD_SRC" );
	swigIntConstant( GST_PAD_SINK, "GST_PAD_SINK" );
	swigIntConstant( GST_PAD_MODE_NONE, "GST_PAD_MODE_NONE" );
	swigIntConstant( GST_PAD_MODE_PUSH, "GST_PAD_MODE_PUSH" );
	swigIntConstant( GST_PAD_MODE_PULL, "GST_PAD_MODE_PULL" );
	swigIntConstant( GST_PAD_LINK_OK, "GST_PAD_LINK_OK" );
	swigIntConstant( GST_PAD_LINK_WRONG_HIERARCHY, "GST_PAD_LINK_WRONG_HIERARCHY" );
	swigIntConstant( GST_PAD_LINK_WAS_LINKED, "GST_PAD_LINK_WAS_LINKED" );
	swigIntConstant( GST_PAD_LINK_WRONG_DIRECTION, "GST_PAD_LINK_WRONG_DIRECTION" );
	swigIntConstant( GST_PAD_LINK_NOFORMAT, "GST_PAD_LINK_NOFORMAT" );
	swigIntConstant( GST_PAD_LINK_NOSCHED, "GST_PAD_LINK_NOSCHED" );
	swigIntConstant( GST_PAD_LINK_REFUSED, "GST_PAD_LINK_REFUSED" );
	swigIntConstant( GST_FLOW_CUSTOM_SUCCESS_2, "GST_FLOW_CUSTOM_SUCCESS_2" );
	swigIntConstant( GST_FLOW_CUSTOM_SUCCESS_1, "GST_FLOW_CUSTOM_SUCCESS_1" );
	swigIntConstant( GST_FLOW_CUSTOM_SUCCESS, "GST_FLOW_CUSTOM_SUCCESS" );
	swigIntConstant( GST_FLOW_OK, "GST_FLOW_OK" );
	swigIntConstant( GST_FLOW_NOT_LINKED, "GST_FLOW_NOT_LINKED" );
	swigIntConstant( GST_FLOW_FLUSHING, "GST_FLOW_FLUSHING" );
	swigIntConstant( GST_FLOW_EOS, "GST_FLOW_EOS" );
	swigIntConstant( GST_FLOW_NOT_NEGOTIATED, "GST_FLOW_NOT_NEGOTIATED" );
	swigIntConstant( GST_FLOW_ERROR, "GST_FLOW_ERROR" );
	swigIntConstant( GST_FLOW_NOT_SUPPORTED, "GST_FLOW_NOT_SUPPORTED" );
	swigIntConstant( GST_FLOW_CUSTOM_ERROR, "GST_FLOW_CUSTOM_ERROR" );
	swigIntConstant( GST_FLOW_CUSTOM_ERROR_1, "GST_FLOW_CUSTOM_ERROR_1" );
	swigIntConstant( GST_FLOW_CUSTOM_ERROR_2, "GST_FLOW_CUSTOM_ERROR_2" );
	swigIntConstant( GST_PAD_LINK_CHECK_NOTHING, "GST_PAD_LINK_CHECK_NOTHING" );
	swigIntConstant( GST_PAD_LINK_CHECK_HIERARCHY, "GST_PAD_LINK_CHECK_HIERARCHY" );
	swigIntConstant( GST_PAD_LINK_CHECK_TEMPLATE_CAPS, "GST_PAD_LINK_CHECK_TEMPLATE_CAPS" );
	swigIntConstant( GST_PAD_LINK_CHECK_CAPS, "GST_PAD_LINK_CHECK_CAPS" );
	swigIntConstant( GST_PAD_LINK_CHECK_NO_RECONFIGURE, "GST_PAD_LINK_CHECK_NO_RECONFIGURE" );
	swigIntConstant( GST_PAD_LINK_CHECK_DEFAULT, "GST_PAD_LINK_CHECK_DEFAULT" );
	swigIntConstant( GST_PAD_PROBE_TYPE_INVALID, "GST_PAD_PROBE_TYPE_INVALID" );
	swigIntConstant( GST_PAD_PROBE_TYPE_IDLE, "GST_PAD_PROBE_TYPE_IDLE" );
	swigIntConstant( GST_PAD_PROBE_TYPE_BLOCK, "GST_PAD_PROBE_TYPE_BLOCK" );
	swigIntConstant( GST_PAD_PROBE_TYPE_BUFFER, "GST_PAD_PROBE_TYPE_BUFFER" );
	swigIntConstant( GST_PAD_PROBE_TYPE_BUFFER_LIST, "GST_PAD_PROBE_TYPE_BUFFER_LIST" );
	swigIntConstant( GST_PAD_PROBE_TYPE_EVENT_DOWNSTREAM, "GST_PAD_PROBE_TYPE_EVENT_DOWNSTREAM" );
	swigIntConstant( GST_PAD_PROBE_TYPE_EVENT_UPSTREAM, "GST_PAD_PROBE_TYPE_EVENT_UPSTREAM" );
	swigIntConstant( GST_PAD_PROBE_TYPE_EVENT_FLUSH, "GST_PAD_PROBE_TYPE_EVENT_FLUSH" );
	swigIntConstant( GST_PAD_PROBE_TYPE_QUERY_DOWNSTREAM, "GST_PAD_PROBE_TYPE_QUERY_DOWNSTREAM" );
	swigIntConstant( GST_PAD_PROBE_TYPE_QUERY_UPSTREAM, "GST_PAD_PROBE_TYPE_QUERY_UPSTREAM" );
	swigIntConstant( GST_PAD_PROBE_TYPE_PUSH, "GST_PAD_PROBE_TYPE_PUSH" );
	swigIntConstant( GST_PAD_PROBE_TYPE_PULL, "GST_PAD_PROBE_TYPE_PULL" );
	swigIntConstant( GST_PAD_PROBE_TYPE_BLOCKING, "GST_PAD_PROBE_TYPE_BLOCKING" );
	swigIntConstant( GST_PAD_PROBE_TYPE_DATA_DOWNSTREAM, "GST_PAD_PROBE_TYPE_DATA_DOWNSTREAM" );
	swigIntConstant( GST_PAD_PROBE_TYPE_DATA_UPSTREAM, "GST_PAD_PROBE_TYPE_DATA_UPSTREAM" );
	swigIntConstant( GST_PAD_PROBE_TYPE_DATA_BOTH, "GST_PAD_PROBE_TYPE_DATA_BOTH" );
	swigIntConstant( GST_PAD_PROBE_TYPE_BLOCK_DOWNSTREAM, "GST_PAD_PROBE_TYPE_BLOCK_DOWNSTREAM" );
	swigIntConstant( GST_PAD_PROBE_TYPE_BLOCK_UPSTREAM, "GST_PAD_PROBE_TYPE_BLOCK_UPSTREAM" );
	swigIntConstant( GST_PAD_PROBE_TYPE_EVENT_BOTH, "GST_PAD_PROBE_TYPE_EVENT_BOTH" );
	swigIntConstant( GST_PAD_PROBE_TYPE_QUERY_BOTH, "GST_PAD_PROBE_TYPE_QUERY_BOTH" );
	swigIntConstant( GST_PAD_PROBE_TYPE_ALL_BOTH, "GST_PAD_PROBE_TYPE_ALL_BOTH" );
	swigIntConstant( GST_PAD_PROBE_TYPE_SCHEDULING, "GST_PAD_PROBE_TYPE_SCHEDULING" );
	swigIntConstant( GST_PAD_PROBE_DROP, "GST_PAD_PROBE_DROP" );
	swigIntConstant( GST_PAD_PROBE_OK, "GST_PAD_PROBE_OK" );
	swigIntConstant( GST_PAD_PROBE_REMOVE, "GST_PAD_PROBE_REMOVE" );
	swigIntConstant( GST_PAD_PROBE_PASS, "GST_PAD_PROBE_PASS" );
	swigIntConstant( GST_PAD_PROBE_HANDLED, "GST_PAD_PROBE_HANDLED" );
	swigIntConstant( GST_PAD_FLAG_BLOCKED, "GST_PAD_FLAG_BLOCKED" );
	swigIntConstant( GST_PAD_FLAG_FLUSHING, "GST_PAD_FLAG_FLUSHING" );
	swigIntConstant( GST_PAD_FLAG_EOS, "GST_PAD_FLAG_EOS" );
	swigIntConstant( GST_PAD_FLAG_BLOCKING, "GST_PAD_FLAG_BLOCKING" );
	swigIntConstant( GST_PAD_FLAG_NEED_PARENT, "GST_PAD_FLAG_NEED_PARENT" );
	swigIntConstant( GST_PAD_FLAG_NEED_RECONFIGURE, "GST_PAD_FLAG_NEED_RECONFIGURE" );
	swigIntConstant( GST_PAD_FLAG_PENDING_EVENTS, "GST_PAD_FLAG_PENDING_EVENTS" );
	swigIntConstant( GST_PAD_FLAG_FIXED_CAPS, "GST_PAD_FLAG_FIXED_CAPS" );
	swigIntConstant( GST_PAD_FLAG_PROXY_CAPS, "GST_PAD_FLAG_PROXY_CAPS" );
	swigIntConstant( GST_PAD_FLAG_PROXY_ALLOCATION, "GST_PAD_FLAG_PROXY_ALLOCATION" );
	swigIntConstant( GST_PAD_FLAG_PROXY_SCHEDULING, "GST_PAD_FLAG_PROXY_SCHEDULING" );
	swigIntConstant( GST_PAD_FLAG_ACCEPT_INTERSECT, "GST_PAD_FLAG_ACCEPT_INTERSECT" );
	swigIntConstant( GST_PAD_FLAG_ACCEPT_TEMPLATE, "GST_PAD_FLAG_ACCEPT_TEMPLATE" );
	swigIntConstant( GST_PAD_FLAG_LAST, "GST_PAD_FLAG_LAST" );
	swigIntConstant( GST_PIPELINE_FLAG_FIXED_CLOCK, "GST_PIPELINE_FLAG_FIXED_CLOCK" );
	swigIntConstant( GST_PIPELINE_FLAG_LAST, "GST_PIPELINE_FLAG_LAST" );
	swigIntConstant( GST_PLUGIN_ERROR_MODULE, "GST_PLUGIN_ERROR_MODULE" );
	swigIntConstant( GST_PLUGIN_ERROR_DEPENDENCIES, "GST_PLUGIN_ERROR_DEPENDENCIES" );
	swigIntConstant( GST_PLUGIN_ERROR_NAME_MISMATCH, "GST_PLUGIN_ERROR_NAME_MISMATCH" );
	swigIntConstant( GST_PLUGIN_FLAG_CACHED, "GST_PLUGIN_FLAG_CACHED" );
	swigIntConstant( GST_PLUGIN_FLAG_BLACKLISTED, "GST_PLUGIN_FLAG_BLACKLISTED" );
	swigIntConstant( GST_PLUGIN_DEPENDENCY_FLAG_NONE, "GST_PLUGIN_DEPENDENCY_FLAG_NONE" );
	swigIntConstant( GST_PLUGIN_DEPENDENCY_FLAG_RECURSE, "GST_PLUGIN_DEPENDENCY_FLAG_RECURSE" );
	swigIntConstant( GST_PLUGIN_DEPENDENCY_FLAG_PATHS_ARE_DEFAULT_ONLY, "GST_PLUGIN_DEPENDENCY_FLAG_PATHS_ARE_DEFAULT_ONLY" );
	swigIntConstant( GST_PLUGIN_DEPENDENCY_FLAG_FILE_NAME_IS_SUFFIX, "GST_PLUGIN_DEPENDENCY_FLAG_FILE_NAME_IS_SUFFIX" );
	swigIntConstant( GST_PLUGIN_DEPENDENCY_FLAG_FILE_NAME_IS_PREFIX, "GST_PLUGIN_DEPENDENCY_FLAG_FILE_NAME_IS_PREFIX" );
	swigIntConstant( GST_PLUGIN_DEPENDENCY_FLAG_PATHS_ARE_RELATIVE_TO_EXE, "GST_PLUGIN_DEPENDENCY_FLAG_PATHS_ARE_RELATIVE_TO_EXE" );
	swigIntConstant( GST_QUERY_TYPE_UPSTREAM, "GST_QUERY_TYPE_UPSTREAM" );
	swigIntConstant( GST_QUERY_TYPE_DOWNSTREAM, "GST_QUERY_TYPE_DOWNSTREAM" );
	swigIntConstant( GST_QUERY_TYPE_SERIALIZED, "GST_QUERY_TYPE_SERIALIZED" );
	swigIntConstant( GST_QUERY_UNKNOWN, "GST_QUERY_UNKNOWN" );
	swigIntConstant( GST_QUERY_POSITION, "GST_QUERY_POSITION" );
	swigIntConstant( GST_QUERY_DURATION, "GST_QUERY_DURATION" );
	swigIntConstant( GST_QUERY_LATENCY, "GST_QUERY_LATENCY" );
	swigIntConstant( GST_QUERY_JITTER, "GST_QUERY_JITTER" );
	swigIntConstant( GST_QUERY_RATE, "GST_QUERY_RATE" );
	swigIntConstant( GST_QUERY_SEEKING, "GST_QUERY_SEEKING" );
	swigIntConstant( GST_QUERY_SEGMENT, "GST_QUERY_SEGMENT" );
	swigIntConstant( GST_QUERY_CONVERT, "GST_QUERY_CONVERT" );
	swigIntConstant( GST_QUERY_FORMATS, "GST_QUERY_FORMATS" );
	swigIntConstant( GST_QUERY_BUFFERING, "GST_QUERY_BUFFERING" );
	swigIntConstant( GST_QUERY_CUSTOM, "GST_QUERY_CUSTOM" );
	swigIntConstant( GST_QUERY_URI, "GST_QUERY_URI" );
	swigIntConstant( GST_QUERY_ALLOCATION, "GST_QUERY_ALLOCATION" );
	swigIntConstant( GST_QUERY_SCHEDULING, "GST_QUERY_SCHEDULING" );
	swigIntConstant( GST_QUERY_ACCEPT_CAPS, "GST_QUERY_ACCEPT_CAPS" );
	swigIntConstant( GST_QUERY_CAPS, "GST_QUERY_CAPS" );
	swigIntConstant( GST_QUERY_DRAIN, "GST_QUERY_DRAIN" );
	swigIntConstant( GST_QUERY_CONTEXT, "GST_QUERY_CONTEXT" );
	swigIntConstant( GST_BUFFERING_STREAM, "GST_BUFFERING_STREAM" );
	swigIntConstant( GST_BUFFERING_DOWNLOAD, "GST_BUFFERING_DOWNLOAD" );
	swigIntConstant( GST_BUFFERING_TIMESHIFT, "GST_BUFFERING_TIMESHIFT" );
	swigIntConstant( GST_BUFFERING_LIVE, "GST_BUFFERING_LIVE" );
	swigIntConstant( GST_SCHEDULING_FLAG_SEEKABLE, "GST_SCHEDULING_FLAG_SEEKABLE" );
	swigIntConstant( GST_SCHEDULING_FLAG_SEQUENTIAL, "GST_SCHEDULING_FLAG_SEQUENTIAL" );
	swigIntConstant( GST_SCHEDULING_FLAG_BANDWIDTH_LIMITED, "GST_SCHEDULING_FLAG_BANDWIDTH_LIMITED" );
	swigIntConstant( GST_SEEK_TYPE_NONE, "GST_SEEK_TYPE_NONE" );
	swigIntConstant( GST_SEEK_TYPE_SET, "GST_SEEK_TYPE_SET" );
	swigIntConstant( GST_SEEK_TYPE_END, "GST_SEEK_TYPE_END" );
	swigIntConstant( GST_SEEK_FLAG_NONE, "GST_SEEK_FLAG_NONE" );
	swigIntConstant( GST_SEEK_FLAG_FLUSH, "GST_SEEK_FLAG_FLUSH" );
	swigIntConstant( GST_SEEK_FLAG_ACCURATE, "GST_SEEK_FLAG_ACCURATE" );
	swigIntConstant( GST_SEEK_FLAG_KEY_UNIT, "GST_SEEK_FLAG_KEY_UNIT" );
	swigIntConstant( GST_SEEK_FLAG_SEGMENT, "GST_SEEK_FLAG_SEGMENT" );
	swigIntConstant( GST_SEEK_FLAG_TRICKMODE, "GST_SEEK_FLAG_TRICKMODE" );
	swigIntConstant( GST_SEEK_FLAG_SKIP, "GST_SEEK_FLAG_SKIP" );
	swigIntConstant( GST_SEEK_FLAG_SNAP_BEFORE, "GST_SEEK_FLAG_SNAP_BEFORE" );
	swigIntConstant( GST_SEEK_FLAG_SNAP_AFTER, "GST_SEEK_FLAG_SNAP_AFTER" );
	swigIntConstant( GST_SEEK_FLAG_SNAP_NEAREST, "GST_SEEK_FLAG_SNAP_NEAREST" );
	swigIntConstant( GST_SEEK_FLAG_TRICKMODE_KEY_UNITS, "GST_SEEK_FLAG_TRICKMODE_KEY_UNITS" );
	swigIntConstant( GST_SEEK_FLAG_TRICKMODE_NO_AUDIO, "GST_SEEK_FLAG_TRICKMODE_NO_AUDIO" );
	swigIntConstant( GST_SEGMENT_FLAG_NONE, "GST_SEGMENT_FLAG_NONE" );
	swigIntConstant( GST_SEGMENT_FLAG_RESET, "GST_SEGMENT_FLAG_RESET" );
	swigIntConstant( GST_SEGMENT_FLAG_TRICKMODE, "GST_SEGMENT_FLAG_TRICKMODE" );
	swigIntConstant( GST_SEGMENT_FLAG_SKIP, "GST_SEGMENT_FLAG_SKIP" );
	swigIntConstant( GST_SEGMENT_FLAG_SEGMENT, "GST_SEGMENT_FLAG_SEGMENT" );
	swigIntConstant( GST_SEGMENT_FLAG_TRICKMODE_KEY_UNITS, "GST_SEGMENT_FLAG_TRICKMODE_KEY_UNITS" );
	swigIntConstant( GST_SEGMENT_FLAG_TRICKMODE_NO_AUDIO, "GST_SEGMENT_FLAG_TRICKMODE_NO_AUDIO" );
	swigIntConstant( GST_CLOCK_TYPE_REALTIME, "GST_CLOCK_TYPE_REALTIME" );
	swigIntConstant( GST_CLOCK_TYPE_MONOTONIC, "GST_CLOCK_TYPE_MONOTONIC" );
	swigIntConstant( GST_CLOCK_TYPE_OTHER, "GST_CLOCK_TYPE_OTHER" );
	swigIntConstant( GST_TAG_MERGE_UNDEFINED, "GST_TAG_MERGE_UNDEFINED" );
	swigIntConstant( GST_TAG_MERGE_REPLACE_ALL, "GST_TAG_MERGE_REPLACE_ALL" );
	swigIntConstant( GST_TAG_MERGE_REPLACE, "GST_TAG_MERGE_REPLACE" );
	swigIntConstant( GST_TAG_MERGE_APPEND, "GST_TAG_MERGE_APPEND" );
	swigIntConstant( GST_TAG_MERGE_PREPEND, "GST_TAG_MERGE_PREPEND" );
	swigIntConstant( GST_TAG_MERGE_KEEP, "GST_TAG_MERGE_KEEP" );
	swigIntConstant( GST_TAG_MERGE_KEEP_ALL, "GST_TAG_MERGE_KEEP_ALL" );
	swigIntConstant( GST_TAG_MERGE_COUNT, "GST_TAG_MERGE_COUNT" );
	swigIntConstant( GST_TAG_FLAG_UNDEFINED, "GST_TAG_FLAG_UNDEFINED" );
	swigIntConstant( GST_TAG_FLAG_META, "GST_TAG_FLAG_META" );
	swigIntConstant( GST_TAG_FLAG_ENCODED, "GST_TAG_FLAG_ENCODED" );
	swigIntConstant( GST_TAG_FLAG_DECODED, "GST_TAG_FLAG_DECODED" );
	swigIntConstant( GST_TAG_FLAG_COUNT, "GST_TAG_FLAG_COUNT" );
	swigIntConstant( GST_TAG_SCOPE_STREAM, "GST_TAG_SCOPE_STREAM" );
	swigIntConstant( GST_TAG_SCOPE_GLOBAL, "GST_TAG_SCOPE_GLOBAL" );
	swigIntConstant( GST_TASK_STARTED, "GST_TASK_STARTED" );
	swigIntConstant( GST_TASK_STOPPED, "GST_TASK_STOPPED" );
	swigIntConstant( GST_TASK_PAUSED, "GST_TASK_PAUSED" );
	swigIntConstant( GST_TOC_SCOPE_GLOBAL, "GST_TOC_SCOPE_GLOBAL" );
	swigIntConstant( GST_TOC_SCOPE_CURRENT, "GST_TOC_SCOPE_CURRENT" );
	swigIntConstant( GST_TOC_ENTRY_TYPE_ANGLE, "GST_TOC_ENTRY_TYPE_ANGLE" );
	swigIntConstant( GST_TOC_ENTRY_TYPE_VERSION, "GST_TOC_ENTRY_TYPE_VERSION" );
	swigIntConstant( GST_TOC_ENTRY_TYPE_EDITION, "GST_TOC_ENTRY_TYPE_EDITION" );
	swigIntConstant( GST_TOC_ENTRY_TYPE_INVALID, "GST_TOC_ENTRY_TYPE_INVALID" );
	swigIntConstant( GST_TOC_ENTRY_TYPE_TITLE, "GST_TOC_ENTRY_TYPE_TITLE" );
	swigIntConstant( GST_TOC_ENTRY_TYPE_TRACK, "GST_TOC_ENTRY_TYPE_TRACK" );
	swigIntConstant( GST_TOC_ENTRY_TYPE_CHAPTER, "GST_TOC_ENTRY_TYPE_CHAPTER" );
	swigIntConstant( GST_TOC_LOOP_NONE, "GST_TOC_LOOP_NONE" );
	swigIntConstant( GST_TOC_LOOP_FORWARD, "GST_TOC_LOOP_FORWARD" );
	swigIntConstant( GST_TOC_LOOP_REVERSE, "GST_TOC_LOOP_REVERSE" );
	swigIntConstant( GST_TOC_LOOP_PING_PONG, "GST_TOC_LOOP_PING_PONG" );
	swigIntConstant( GST_TYPE_FIND_NONE, "GST_TYPE_FIND_NONE" );
	swigIntConstant( GST_TYPE_FIND_MINIMUM, "GST_TYPE_FIND_MINIMUM" );
	swigIntConstant( GST_TYPE_FIND_POSSIBLE, "GST_TYPE_FIND_POSSIBLE" );
	swigIntConstant( GST_TYPE_FIND_LIKELY, "GST_TYPE_FIND_LIKELY" );
	swigIntConstant( GST_TYPE_FIND_NEARLY_CERTAIN, "GST_TYPE_FIND_NEARLY_CERTAIN" );
	swigIntConstant( GST_TYPE_FIND_MAXIMUM, "GST_TYPE_FIND_MAXIMUM" );
	swigIntConstant( GST_URI_ERROR_UNSUPPORTED_PROTOCOL, "GST_URI_ERROR_UNSUPPORTED_PROTOCOL" );
	swigIntConstant( GST_URI_ERROR_BAD_URI, "GST_URI_ERROR_BAD_URI" );
	swigIntConstant( GST_URI_ERROR_BAD_STATE, "GST_URI_ERROR_BAD_STATE" );
	swigIntConstant( GST_URI_ERROR_BAD_REFERENCE, "GST_URI_ERROR_BAD_REFERENCE" );
	swigIntConstant( GST_URI_UNKNOWN, "GST_URI_UNKNOWN" );
	swigIntConstant( GST_URI_SINK, "GST_URI_SINK" );
	swigIntConstant( GST_URI_SRC, "GST_URI_SRC" );
	swigIntConstant( GST_SEARCH_MODE_EXACT, "GST_SEARCH_MODE_EXACT" );
	swigIntConstant( GST_SEARCH_MODE_BEFORE, "GST_SEARCH_MODE_BEFORE" );
	swigIntConstant( GST_SEARCH_MODE_AFTER, "GST_SEARCH_MODE_AFTER" );
	swigIntConstant( GST_PARSE_ERROR_SYNTAX, "GST_PARSE_ERROR_SYNTAX" );
	swigIntConstant( GST_PARSE_ERROR_NO_SUCH_ELEMENT, "GST_PARSE_ERROR_NO_SUCH_ELEMENT" );
	swigIntConstant( GST_PARSE_ERROR_NO_SUCH_PROPERTY, "GST_PARSE_ERROR_NO_SUCH_PROPERTY" );
	swigIntConstant( GST_PARSE_ERROR_LINK, "GST_PARSE_ERROR_LINK" );
	swigIntConstant( GST_PARSE_ERROR_COULD_NOT_SET_PROPERTY, "GST_PARSE_ERROR_COULD_NOT_SET_PROPERTY" );
	swigIntConstant( GST_PARSE_ERROR_EMPTY_BIN, "GST_PARSE_ERROR_EMPTY_BIN" );
	swigIntConstant( GST_PARSE_ERROR_EMPTY, "GST_PARSE_ERROR_EMPTY" );
	swigIntConstant( GST_PARSE_ERROR_DELAYED_LINK, "GST_PARSE_ERROR_DELAYED_LINK" );
	swigIntConstant( GST_PARSE_FLAG_NONE, "GST_PARSE_FLAG_NONE" );
	swigIntConstant( GST_PARSE_FLAG_FATAL_ERRORS, "GST_PARSE_FLAG_FATAL_ERRORS" );
	swigIntConstant( GST_PARSE_FLAG_NO_SINGLE_ELEMENT_BINS, "GST_PARSE_FLAG_NO_SINGLE_ELEMENT_BINS" );
	swigIntConstant( GST_PARSE_FLAG_PLACE_IN_BIN, "GST_PARSE_FLAG_PLACE_IN_BIN" );
	swigIntConstant( GST_GL_API_NONE, "GST_GL_API_NONE" );
	swigIntConstant( GST_GL_API_OPENGL, "GST_GL_API_OPENGL" );
	swigIntConstant( GST_GL_API_OPENGL3, "GST_GL_API_OPENGL3" );
	swigIntConstant( GST_GL_API_GLES1, "GST_GL_API_GLES1" );
	swigIntConstant( GST_GL_API_GLES2, "GST_GL_API_GLES2" );
	swigIntConstant( GST_GL_API_ANY, "GST_GL_API_ANY" );
	swigIntConstant( GST_GL_PLATFORM_NONE, "GST_GL_PLATFORM_NONE" );
	swigIntConstant( GST_GL_PLATFORM_EGL, "GST_GL_PLATFORM_EGL" );
	swigIntConstant( GST_GL_PLATFORM_GLX, "GST_GL_PLATFORM_GLX" );
	swigIntConstant( GST_GL_PLATFORM_WGL, "GST_GL_PLATFORM_WGL" );
	swigIntConstant( GST_GL_PLATFORM_CGL, "GST_GL_PLATFORM_CGL" );
	swigIntConstant( GST_GL_PLATFORM_EAGL, "GST_GL_PLATFORM_EAGL" );
	swigIntConstant( GST_GL_PLATFORM_ANY, "GST_GL_PLATFORM_ANY" );
	swigIntConstant( GST_GL_DISPLAY_TYPE_NONE, "GST_GL_DISPLAY_TYPE_NONE" );
	swigIntConstant( GST_GL_DISPLAY_TYPE_X11, "GST_GL_DISPLAY_TYPE_X11" );
	swigIntConstant( GST_GL_DISPLAY_TYPE_WAYLAND, "GST_GL_DISPLAY_TYPE_WAYLAND" );
	swigIntConstant( GST_GL_DISPLAY_TYPE_COCOA, "GST_GL_DISPLAY_TYPE_COCOA" );
	swigIntConstant( GST_GL_DISPLAY_TYPE_WIN32, "GST_GL_DISPLAY_TYPE_WIN32" );
	swigIntConstant( GST_GL_DISPLAY_TYPE_DISPMANX, "GST_GL_DISPLAY_TYPE_DISPMANX" );
	swigIntConstant( GST_GL_DISPLAY_TYPE_EGL, "GST_GL_DISPLAY_TYPE_EGL" );
	swigIntConstant( GST_GL_DISPLAY_TYPE_VIV_FB, "GST_GL_DISPLAY_TYPE_VIV_FB" );
	swigIntConstant( GST_GL_DISPLAY_TYPE_GBM, "GST_GL_DISPLAY_TYPE_GBM" );
	swigIntConstant( GST_GL_DISPLAY_TYPE_ANY, "GST_GL_DISPLAY_TYPE_ANY" );
	swigIntConstant( GST_GL_CONTEXT_ERROR_FAILED, "GST_GL_CONTEXT_ERROR_FAILED" );
	swigIntConstant( GST_GL_CONTEXT_ERROR_WRONG_CONFIG, "GST_GL_CONTEXT_ERROR_WRONG_CONFIG" );
	swigIntConstant( GST_GL_CONTEXT_ERROR_WRONG_API, "GST_GL_CONTEXT_ERROR_WRONG_API" );
	swigIntConstant( GST_GL_CONTEXT_ERROR_OLD_LIBS, "GST_GL_CONTEXT_ERROR_OLD_LIBS" );
	swigIntConstant( GST_GL_CONTEXT_ERROR_CREATE_CONTEXT, "GST_GL_CONTEXT_ERROR_CREATE_CONTEXT" );
	swigIntConstant( GST_GL_CONTEXT_ERROR_RESOURCE_UNAVAILABLE, "GST_GL_CONTEXT_ERROR_RESOURCE_UNAVAILABLE" );
	swigIntConstant( GST_GL_WINDOW_ERROR_FAILED, "GST_GL_WINDOW_ERROR_FAILED" );
	swigIntConstant( GST_GL_WINDOW_ERROR_OLD_LIBS, "GST_GL_WINDOW_ERROR_OLD_LIBS" );
	swigIntConstant( GST_GL_WINDOW_ERROR_RESOURCE_UNAVAILABLE, "GST_GL_WINDOW_ERROR_RESOURCE_UNAVAILABLE" );
	swigIntConstant( GST_GL_UPLOAD_DONE, "GST_GL_UPLOAD_DONE" );
	swigIntConstant( GST_GL_UPLOAD_ERROR, "GST_GL_UPLOAD_ERROR" );
	swigIntConstant( GST_GL_UPLOAD_UNSUPPORTED, "GST_GL_UPLOAD_UNSUPPORTED" );
	swigIntConstant( GST_GL_UPLOAD_RECONFIGURE, "GST_GL_UPLOAD_RECONFIGURE" );
	swigIntConstant( GST_GL_UPLOAD_UNSHARED_GL_CONTEXT, "GST_GL_UPLOAD_UNSHARED_GL_CONTEXT" );

	swigNewline();

	swigComment("-------===< structs >===--------\n");

	swigComment("_GstBin\n");
	printf( "begin-structure _GstBin\n" );
	swigStructField( "_GstBin-element", offsetof( struct _GstBin, element ), sizeof( GstElement ) );
	swigStructField( "_GstBin-state_dirty", offsetof( struct _GstBin, state_dirty ), sizeof( gboolean ) );
	swigStructField( "_GstBin-clock_dirty", offsetof( struct _GstBin, clock_dirty ), sizeof( gboolean ) );
	swigStructField( "_GstBin-children_cookie", offsetof( struct _GstBin, children_cookie ), sizeof( guint32 ) );
	swigStructField( "_GstBin-polling", offsetof( struct _GstBin, polling ), sizeof( gboolean ) );
	swigStructField( "_GstBin-_gst_reserved", offsetof( struct _GstBin, _gst_reserved ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "_GstBin-child_bus", offsetof( struct _GstBin, child_bus ), sizeof( GstBus * ) );
	swigStructField( "_GstBin-provided_clock", offsetof( struct _GstBin, provided_clock ), sizeof( GstClock * ) );
	swigStructField( "_GstBin-clock_provider", offsetof( struct _GstBin, clock_provider ), sizeof( GstElement * ) );
	swigStructField( "_GstBin-priv", offsetof( struct _GstBin, priv ), sizeof( GstBinPrivate * ) );
	swigStructField( "_GstBin-messages", offsetof( struct _GstBin, messages ), sizeof( GList * ) );
	swigStructField( "_GstBin-numchildren", offsetof( struct _GstBin, numchildren ), sizeof( gint ) );
	swigStructField( "_GstBin-children", offsetof( struct _GstBin, children ), sizeof( GList * ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstBin ) );

	swigComment("_GstBinClass\n");
	printf( "begin-structure _GstBinClass\n" );
	swigStructField( "_GstBinClass-add_element", offsetof( struct _GstBinClass, add_element ), sizeof( gboolean (*)(GstBin *,GstElement *) ) );
	swigStructField( "_GstBinClass-remove_element", offsetof( struct _GstBinClass, remove_element ), sizeof( gboolean (*)(GstBin *,GstElement *) ) );
	swigStructField( "_GstBinClass-element_added", offsetof( struct _GstBinClass, element_added ), sizeof( void (*)(GstBin *,GstElement *) ) );
	swigStructField( "_GstBinClass-deep_element_added", offsetof( struct _GstBinClass, deep_element_added ), sizeof( void (*)(GstBin *,GstBin *,GstElement *) ) );
	swigStructField( "_GstBinClass-_gst_reserved", offsetof( struct _GstBinClass, _gst_reserved ), sizeof( gpointer [GST_PADDING-2] ) );
	swigStructField( "_GstBinClass-element_removed", offsetof( struct _GstBinClass, element_removed ), sizeof( void (*)(GstBin *,GstElement *) ) );
	swigStructField( "_GstBinClass-do_latency", offsetof( struct _GstBinClass, do_latency ), sizeof( gboolean (*)(GstBin *) ) );
	swigStructField( "_GstBinClass-deep_element_removed", offsetof( struct _GstBinClass, deep_element_removed ), sizeof( void (*)(GstBin *,GstBin *,GstElement *) ) );
	swigStructField( "_GstBinClass-pool", offsetof( struct _GstBinClass, pool ), sizeof( GThreadPool * ) );
	swigStructField( "_GstBinClass-handle_message", offsetof( struct _GstBinClass, handle_message ), sizeof( void (*)(GstBin *,GstMessage *) ) );
	swigStructField( "_GstBinClass-parent_class", offsetof( struct _GstBinClass, parent_class ), sizeof( GstElementClass ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstBinClass ) );

	swigComment("_GstBuffer\n");
	printf( "begin-structure _GstBuffer\n" );
	swigStructField( "_GstBuffer-dts", offsetof( struct _GstBuffer, dts ), sizeof( GstClockTime ) );
	swigStructField( "_GstBuffer-duration", offsetof( struct _GstBuffer, duration ), sizeof( GstClockTime ) );
	swigStructField( "_GstBuffer-offset_end", offsetof( struct _GstBuffer, offset_end ), sizeof( guint64 ) );
	swigStructField( "_GstBuffer-mini_object", offsetof( struct _GstBuffer, mini_object ), sizeof( GstMiniObject ) );
	swigStructField( "_GstBuffer-offset", offsetof( struct _GstBuffer, offset ), sizeof( guint64 ) );
	swigStructField( "_GstBuffer-pool", offsetof( struct _GstBuffer, pool ), sizeof( GstBufferPool * ) );
	swigStructField( "_GstBuffer-pts", offsetof( struct _GstBuffer, pts ), sizeof( GstClockTime ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstBuffer ) );

	swigComment("_GstParentBufferMeta\n");
	printf( "begin-structure _GstParentBufferMeta\n" );
	swigStructField( "_GstParentBufferMeta-buffer", offsetof( struct _GstParentBufferMeta, buffer ), sizeof( GstBuffer * ) );
	swigStructField( "_GstParentBufferMeta-parent", offsetof( struct _GstParentBufferMeta, parent ), sizeof( GstMeta ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstParentBufferMeta ) );

	swigComment("_GstReferenceTimestampMeta\n");
	printf( "begin-structure _GstReferenceTimestampMeta\n" );
	swigStructField( "_GstReferenceTimestampMeta-duration", offsetof( struct _GstReferenceTimestampMeta, duration ), sizeof( GstClockTime ) );
	swigStructField( "_GstReferenceTimestampMeta-reference", offsetof( struct _GstReferenceTimestampMeta, reference ), sizeof( GstCaps * ) );
	swigStructField( "_GstReferenceTimestampMeta-parent", offsetof( struct _GstReferenceTimestampMeta, parent ), sizeof( GstMeta ) );
	swigStructField( "_GstReferenceTimestampMeta-timestamp", offsetof( struct _GstReferenceTimestampMeta, timestamp ), sizeof( GstClockTime ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstReferenceTimestampMeta ) );

	swigComment("_GstBufferPoolAcquireParams\n");
	printf( "begin-structure _GstBufferPoolAcquireParams\n" );
	swigStructField( "_GstBufferPoolAcquireParams-stop", offsetof( struct _GstBufferPoolAcquireParams, stop ), sizeof( gint64 ) );
	swigStructField( "_GstBufferPoolAcquireParams-_gst_reserved", offsetof( struct _GstBufferPoolAcquireParams, _gst_reserved ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "_GstBufferPoolAcquireParams-format", offsetof( struct _GstBufferPoolAcquireParams, format ), sizeof( GstFormat ) );
	swigStructField( "_GstBufferPoolAcquireParams-start", offsetof( struct _GstBufferPoolAcquireParams, start ), sizeof( gint64 ) );
	swigStructField( "_GstBufferPoolAcquireParams-flags", offsetof( struct _GstBufferPoolAcquireParams, flags ), sizeof( GstBufferPoolAcquireFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstBufferPoolAcquireParams ) );

	swigComment("_GstBufferPool\n");
	printf( "begin-structure _GstBufferPool\n" );
	swigStructField( "_GstBufferPool-_gst_reserved", offsetof( struct _GstBufferPool, _gst_reserved ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "_GstBufferPool-flushing", offsetof( struct _GstBufferPool, flushing ), sizeof( gint ) );
	swigStructField( "_GstBufferPool-priv", offsetof( struct _GstBufferPool, priv ), sizeof( GstBufferPoolPrivate * ) );
	swigStructField( "_GstBufferPool-object", offsetof( struct _GstBufferPool, object ), sizeof( GstObject ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstBufferPool ) );

	swigComment("_GstBufferPoolClass\n");
	printf( "begin-structure _GstBufferPoolClass\n" );
	swigStructField( "_GstBufferPoolClass-stop", offsetof( struct _GstBufferPoolClass, stop ), sizeof( gboolean (*)(GstBufferPool *) ) );
	swigStructField( "_GstBufferPoolClass-acquire_buffer", offsetof( struct _GstBufferPoolClass, acquire_buffer ), sizeof( GstFlowReturn (*)(GstBufferPool *,GstBuffer **,GstBufferPoolAcquireParams *) ) );
	swigStructField( "_GstBufferPoolClass-alloc_buffer", offsetof( struct _GstBufferPoolClass, alloc_buffer ), sizeof( GstFlowReturn (*)(GstBufferPool *,GstBuffer **,GstBufferPoolAcquireParams *) ) );
	swigStructField( "_GstBufferPoolClass-reset_buffer", offsetof( struct _GstBufferPoolClass, reset_buffer ), sizeof( void (*)(GstBufferPool *,GstBuffer *) ) );
	swigStructField( "_GstBufferPoolClass-release_buffer", offsetof( struct _GstBufferPoolClass, release_buffer ), sizeof( void (*)(GstBufferPool *,GstBuffer *) ) );
	swigStructField( "_GstBufferPoolClass-free_buffer", offsetof( struct _GstBufferPoolClass, free_buffer ), sizeof( void (*)(GstBufferPool *,GstBuffer *) ) );
	swigStructField( "_GstBufferPoolClass-_gst_reserved", offsetof( struct _GstBufferPoolClass, _gst_reserved ), sizeof( gpointer [GST_PADDING-2] ) );
	swigStructField( "_GstBufferPoolClass-flush_start", offsetof( struct _GstBufferPoolClass, flush_start ), sizeof( void (*)(GstBufferPool *) ) );
	swigStructField( "_GstBufferPoolClass-flush_stop", offsetof( struct _GstBufferPoolClass, flush_stop ), sizeof( void (*)(GstBufferPool *) ) );
	swigStructField( "_GstBufferPoolClass-object_class", offsetof( struct _GstBufferPoolClass, object_class ), sizeof( GstObjectClass ) );
	swigStructField( "_GstBufferPoolClass-start", offsetof( struct _GstBufferPoolClass, start ), sizeof( gboolean (*)(GstBufferPool *) ) );
	swigStructField( "_GstBufferPoolClass-get_options", offsetof( struct _GstBufferPoolClass, get_options ), sizeof( char const **(*)(GstBufferPool *) ) );
	swigStructField( "_GstBufferPoolClass-set_config", offsetof( struct _GstBufferPoolClass, set_config ), sizeof( gboolean (*)(GstBufferPool *,GstStructure *) ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstBufferPoolClass ) );

	swigComment("_GstBus\n");
	printf( "begin-structure _GstBus\n" );
	swigStructField( "_GstBus-_gst_reserved", offsetof( struct _GstBus, _gst_reserved ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "_GstBus-priv", offsetof( struct _GstBus, priv ), sizeof( GstBusPrivate * ) );
	swigStructField( "_GstBus-object", offsetof( struct _GstBus, object ), sizeof( GstObject ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstBus ) );

	swigComment("_GstBusClass\n");
	printf( "begin-structure _GstBusClass\n" );
	swigStructField( "_GstBusClass-_gst_reserved", offsetof( struct _GstBusClass, _gst_reserved ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "_GstBusClass-message", offsetof( struct _GstBusClass, message ), sizeof( void (*)(GstBus *,GstMessage *) ) );
	swigStructField( "_GstBusClass-sync_message", offsetof( struct _GstBusClass, sync_message ), sizeof( void (*)(GstBus *,GstMessage *) ) );
	swigStructField( "_GstBusClass-parent_class", offsetof( struct _GstBusClass, parent_class ), sizeof( GstObjectClass ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstBusClass ) );

	swigComment("_GstCaps\n");
	printf( "begin-structure _GstCaps\n" );
	swigStructField( "_GstCaps-mini_object", offsetof( struct _GstCaps, mini_object ), sizeof( GstMiniObject ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstCaps ) );

	swigComment("_GstStaticCaps\n");
	printf( "begin-structure _GstStaticCaps\n" );
	swigStructField( "_GstStaticCaps-_gst_reserved", offsetof( struct _GstStaticCaps, _gst_reserved ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "_GstStaticCaps-caps", offsetof( struct _GstStaticCaps, caps ), sizeof( GstCaps * ) );
	swigStructField( "_GstStaticCaps-string", offsetof( struct _GstStaticCaps, string ), sizeof( char const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstStaticCaps ) );

	swigComment("_GstChildProxyInterface\n");
	printf( "begin-structure _GstChildProxyInterface\n" );
	swigStructField( "_GstChildProxyInterface-get_children_count", offsetof( struct _GstChildProxyInterface, get_children_count ), sizeof( guint (*)(GstChildProxy *) ) );
	swigStructField( "_GstChildProxyInterface-child_added", offsetof( struct _GstChildProxyInterface, child_added ), sizeof( void (*)(GstChildProxy *,GObject *,char const *) ) );
	swigStructField( "_GstChildProxyInterface-_gst_reserved", offsetof( struct _GstChildProxyInterface, _gst_reserved ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "_GstChildProxyInterface-child_removed", offsetof( struct _GstChildProxyInterface, child_removed ), sizeof( void (*)(GstChildProxy *,GObject *,char const *) ) );
	swigStructField( "_GstChildProxyInterface-parent", offsetof( struct _GstChildProxyInterface, parent ), sizeof( GTypeInterface ) );
	swigStructField( "_GstChildProxyInterface-get_child_by_name", offsetof( struct _GstChildProxyInterface, get_child_by_name ), sizeof( GObject *(*)(GstChildProxy *,char const *) ) );
	swigStructField( "_GstChildProxyInterface-get_child_by_index", offsetof( struct _GstChildProxyInterface, get_child_by_index ), sizeof( GObject *(*)(GstChildProxy *,guint) ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstChildProxyInterface ) );

	swigComment("_GstClockEntry\n");
	printf( "begin-structure _GstClockEntry\n" );
	swigStructField( "_GstClockEntry-refcount", offsetof( struct _GstClockEntry, refcount ), sizeof( gint ) );
	swigStructField( "_GstClockEntry-func", offsetof( struct _GstClockEntry, func ), sizeof( GstClockCallback ) );
	swigStructField( "_GstClockEntry-status", offsetof( struct _GstClockEntry, status ), sizeof( GstClockReturn ) );
	swigStructField( "_GstClockEntry-_gst_reserved", offsetof( struct _GstClockEntry, _gst_reserved ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "_GstClockEntry-time", offsetof( struct _GstClockEntry, time ), sizeof( GstClockTime ) );
	swigStructField( "_GstClockEntry-unscheduled", offsetof( struct _GstClockEntry, unscheduled ), sizeof( gboolean ) );
	swigStructField( "_GstClockEntry-interval", offsetof( struct _GstClockEntry, interval ), sizeof( GstClockTime ) );
	swigStructField( "_GstClockEntry-clock", offsetof( struct _GstClockEntry, clock ), sizeof( GstClock * ) );
	swigStructField( "_GstClockEntry-type", offsetof( struct _GstClockEntry, type ), sizeof( GstClockEntryType ) );
	swigStructField( "_GstClockEntry-user_data", offsetof( struct _GstClockEntry, user_data ), sizeof( gpointer ) );
	swigStructField( "_GstClockEntry-destroy_data", offsetof( struct _GstClockEntry, destroy_data ), sizeof( GDestroyNotify ) );
	swigStructField( "_GstClockEntry-woken_up", offsetof( struct _GstClockEntry, woken_up ), sizeof( gboolean ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstClockEntry ) );

	swigComment("_GstClock\n");
	printf( "begin-structure _GstClock\n" );
	swigStructField( "_GstClock-_gst_reserved", offsetof( struct _GstClock, _gst_reserved ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "_GstClock-priv", offsetof( struct _GstClock, priv ), sizeof( GstClockPrivate * ) );
	swigStructField( "_GstClock-object", offsetof( struct _GstClock, object ), sizeof( GstObject ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstClock ) );

	swigComment("_GstClockClass\n");
	printf( "begin-structure _GstClockClass\n" );
	swigStructField( "_GstClockClass-change_resolution", offsetof( struct _GstClockClass, change_resolution ), sizeof( GstClockTime (*)(GstClock *,GstClockTime,GstClockTime) ) );
	swigStructField( "_GstClockClass-get_resolution", offsetof( struct _GstClockClass, get_resolution ), sizeof( GstClockTime (*)(GstClock *) ) );
	swigStructField( "_GstClockClass-get_internal_time", offsetof( struct _GstClockClass, get_internal_time ), sizeof( GstClockTime (*)(GstClock *) ) );
	swigStructField( "_GstClockClass-_gst_reserved", offsetof( struct _GstClockClass, _gst_reserved ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "_GstClockClass-wait", offsetof( struct _GstClockClass, wait ), sizeof( GstClockReturn (*)(GstClock *,GstClockEntry *,GstClockTimeDiff *) ) );
	swigStructField( "_GstClockClass-wait_async", offsetof( struct _GstClockClass, wait_async ), sizeof( GstClockReturn (*)(GstClock *,GstClockEntry *) ) );
	swigStructField( "_GstClockClass-parent_class", offsetof( struct _GstClockClass, parent_class ), sizeof( GstObjectClass ) );
	swigStructField( "_GstClockClass-unschedule", offsetof( struct _GstClockClass, unschedule ), sizeof( void (*)(GstClock *,GstClockEntry *) ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstClockClass ) );

	swigComment("_GstTimedValue\n");
	printf( "begin-structure _GstTimedValue\n" );
	swigStructField( "_GstTimedValue-value", offsetof( struct _GstTimedValue, value ), sizeof( gdouble ) );
	swigStructField( "_GstTimedValue-timestamp", offsetof( struct _GstTimedValue, timestamp ), sizeof( GstClockTime ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstTimedValue ) );

	swigComment("_GstControlSource\n");
	printf( "begin-structure _GstControlSource\n" );
	swigStructField( "_GstControlSource-_gst_reserved", offsetof( struct _GstControlSource, _gst_reserved ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "_GstControlSource-get_value", offsetof( struct _GstControlSource, get_value ), sizeof( GstControlSourceGetValue ) );
	swigStructField( "_GstControlSource-parent", offsetof( struct _GstControlSource, parent ), sizeof( GstObject ) );
	swigStructField( "_GstControlSource-get_value_array", offsetof( struct _GstControlSource, get_value_array ), sizeof( GstControlSourceGetValueArray ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstControlSource ) );

	swigComment("_GstControlSourceClass\n");
	printf( "begin-structure _GstControlSourceClass\n" );
	swigStructField( "_GstControlSourceClass-_gst_reserved", offsetof( struct _GstControlSourceClass, _gst_reserved ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "_GstControlSourceClass-parent_class", offsetof( struct _GstControlSourceClass, parent_class ), sizeof( GstObjectClass ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstControlSourceClass ) );

	swigComment("_GstDevice\n");
	printf( "begin-structure _GstDevice\n" );
	swigStructField( "_GstDevice-_gst_reserved", offsetof( struct _GstDevice, _gst_reserved ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "_GstDevice-priv", offsetof( struct _GstDevice, priv ), sizeof( GstDevicePrivate * ) );
	swigStructField( "_GstDevice-parent", offsetof( struct _GstDevice, parent ), sizeof( GstObject ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstDevice ) );

	swigComment("_GstDeviceClass\n");
	printf( "begin-structure _GstDeviceClass\n" );
	swigStructField( "_GstDeviceClass-create_element", offsetof( struct _GstDeviceClass, create_element ), sizeof( GstElement *(*)(GstDevice *,char const *) ) );
	swigStructField( "_GstDeviceClass-reconfigure_element", offsetof( struct _GstDeviceClass, reconfigure_element ), sizeof( gboolean (*)(GstDevice *,GstElement *) ) );
	swigStructField( "_GstDeviceClass-_gst_reserved", offsetof( struct _GstDeviceClass, _gst_reserved ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "_GstDeviceClass-parent_class", offsetof( struct _GstDeviceClass, parent_class ), sizeof( GstObjectClass ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstDeviceClass ) );

	swigComment("_GstDeviceMonitor\n");
	printf( "begin-structure _GstDeviceMonitor\n" );
	swigStructField( "_GstDeviceMonitor-_gst_reserved", offsetof( struct _GstDeviceMonitor, _gst_reserved ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "_GstDeviceMonitor-priv", offsetof( struct _GstDeviceMonitor, priv ), sizeof( GstDeviceMonitorPrivate * ) );
	swigStructField( "_GstDeviceMonitor-parent", offsetof( struct _GstDeviceMonitor, parent ), sizeof( GstObject ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstDeviceMonitor ) );

	swigComment("_GstDeviceMonitorClass\n");
	printf( "begin-structure _GstDeviceMonitorClass\n" );
	swigStructField( "_GstDeviceMonitorClass-_gst_reserved", offsetof( struct _GstDeviceMonitorClass, _gst_reserved ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "_GstDeviceMonitorClass-parent_class", offsetof( struct _GstDeviceMonitorClass, parent_class ), sizeof( GstObjectClass ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstDeviceMonitorClass ) );

	swigComment("_GstDeviceProvider\n");
	printf( "begin-structure _GstDeviceProvider\n" );
	swigStructField( "_GstDeviceProvider-_gst_reserved", offsetof( struct _GstDeviceProvider, _gst_reserved ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "_GstDeviceProvider-devices", offsetof( struct _GstDeviceProvider, devices ), sizeof( GList * ) );
	swigStructField( "_GstDeviceProvider-priv", offsetof( struct _GstDeviceProvider, priv ), sizeof( GstDeviceProviderPrivate * ) );
	swigStructField( "_GstDeviceProvider-parent", offsetof( struct _GstDeviceProvider, parent ), sizeof( GstObject ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstDeviceProvider ) );

	swigComment("_GstDeviceProviderClass\n");
	printf( "begin-structure _GstDeviceProviderClass\n" );
	swigStructField( "_GstDeviceProviderClass-stop", offsetof( struct _GstDeviceProviderClass, stop ), sizeof( void (*)(GstDeviceProvider *) ) );
	swigStructField( "_GstDeviceProviderClass-_gst_reserved", offsetof( struct _GstDeviceProviderClass, _gst_reserved ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "_GstDeviceProviderClass-metadata", offsetof( struct _GstDeviceProviderClass, metadata ), sizeof( gpointer ) );
	swigStructField( "_GstDeviceProviderClass-probe", offsetof( struct _GstDeviceProviderClass, probe ), sizeof( GList *(*)(GstDeviceProvider *) ) );
	swigStructField( "_GstDeviceProviderClass-parent_class", offsetof( struct _GstDeviceProviderClass, parent_class ), sizeof( GstObjectClass ) );
	swigStructField( "_GstDeviceProviderClass-factory", offsetof( struct _GstDeviceProviderClass, factory ), sizeof( GstDeviceProviderFactory * ) );
	swigStructField( "_GstDeviceProviderClass-start", offsetof( struct _GstDeviceProviderClass, start ), sizeof( gboolean (*)(GstDeviceProvider *) ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstDeviceProviderClass ) );

	swigComment("_GstElement\n");
	printf( "begin-structure _GstElement\n" );
	swigStructField( "_GstElement-bus", offsetof( struct _GstElement, bus ), sizeof( GstBus * ) );
	swigStructField( "_GstElement-clock", offsetof( struct _GstElement, clock ), sizeof( GstClock * ) );
	swigStructField( "_GstElement-pads", offsetof( struct _GstElement, pads ), sizeof( GList * ) );
	swigStructField( "_GstElement-last_return", offsetof( struct _GstElement, last_return ), sizeof( GstStateChangeReturn ) );
	swigStructField( "_GstElement-state_cond", offsetof( struct _GstElement, state_cond ), sizeof( GCond ) );
	swigStructField( "_GstElement-base_time", offsetof( struct _GstElement, base_time ), sizeof( GstClockTimeDiff ) );
	swigStructField( "_GstElement-state_cookie", offsetof( struct _GstElement, state_cookie ), sizeof( guint32 ) );
	swigStructField( "_GstElement-pads_cookie", offsetof( struct _GstElement, pads_cookie ), sizeof( guint32 ) );
	swigStructField( "_GstElement-next_state", offsetof( struct _GstElement, next_state ), sizeof( GstState ) );
	swigStructField( "_GstElement-current_state", offsetof( struct _GstElement, current_state ), sizeof( GstState ) );
	swigStructField( "_GstElement-target_state", offsetof( struct _GstElement, target_state ), sizeof( GstState ) );
	swigStructField( "_GstElement-numsrcpads", offsetof( struct _GstElement, numsrcpads ), sizeof( guint16 ) );
	swigStructField( "_GstElement-srcpads", offsetof( struct _GstElement, srcpads ), sizeof( GList * ) );
	swigStructField( "_GstElement-_gst_reserved", offsetof( struct _GstElement, _gst_reserved ), sizeof( gpointer [GST_PADDING-1] ) );
	swigStructField( "_GstElement-numsinkpads", offsetof( struct _GstElement, numsinkpads ), sizeof( guint16 ) );
	swigStructField( "_GstElement-sinkpads", offsetof( struct _GstElement, sinkpads ), sizeof( GList * ) );
	swigStructField( "_GstElement-pending_state", offsetof( struct _GstElement, pending_state ), sizeof( GstState ) );
	swigStructField( "_GstElement-contexts", offsetof( struct _GstElement, contexts ), sizeof( GList * ) );
	swigStructField( "_GstElement-state_lock", offsetof( struct _GstElement, state_lock ), sizeof( GRecMutex ) );
	swigStructField( "_GstElement-start_time", offsetof( struct _GstElement, start_time ), sizeof( GstClockTime ) );
	swigStructField( "_GstElement-object", offsetof( struct _GstElement, object ), sizeof( GstObject ) );
	swigStructField( "_GstElement-numpads", offsetof( struct _GstElement, numpads ), sizeof( guint16 ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstElement ) );

	swigComment("_GstElementClass\n");
	printf( "begin-structure _GstElementClass\n" );
	swigStructField( "_GstElementClass-provide_clock", offsetof( struct _GstElementClass, provide_clock ), sizeof( GstClock *(*)(GstElement *) ) );
	swigStructField( "_GstElementClass-parent_class", offsetof( struct _GstElementClass, parent_class ), sizeof( GstObjectClass ) );
	swigStructField( "_GstElementClass-numpadtemplates", offsetof( struct _GstElementClass, numpadtemplates ), sizeof( gint ) );
	swigStructField( "_GstElementClass-padtemplates", offsetof( struct _GstElementClass, padtemplates ), sizeof( GList * ) );
	swigStructField( "_GstElementClass-set_bus", offsetof( struct _GstElementClass, set_bus ), sizeof( void (*)(GstElement *,GstBus *) ) );
	swigStructField( "_GstElementClass-set_context", offsetof( struct _GstElementClass, set_context ), sizeof( void (*)(GstElement *,GstContext *) ) );
	swigStructField( "_GstElementClass-elementfactory", offsetof( struct _GstElementClass, elementfactory ), sizeof( GstElementFactory * ) );
	swigStructField( "_GstElementClass-pad_templ_cookie", offsetof( struct _GstElementClass, pad_templ_cookie ), sizeof( guint32 ) );
	swigStructField( "_GstElementClass-post_message", offsetof( struct _GstElementClass, post_message ), sizeof( gboolean (*)(GstElement *,GstMessage *) ) );
	swigStructField( "_GstElementClass-set_state", offsetof( struct _GstElementClass, set_state ), sizeof( GstStateChangeReturn (*)(GstElement *,GstState) ) );
	swigStructField( "_GstElementClass-get_state", offsetof( struct _GstElementClass, get_state ), sizeof( GstStateChangeReturn (*)(GstElement *,GstState *,GstState *,GstClockTime) ) );
	swigStructField( "_GstElementClass-release_pad", offsetof( struct _GstElementClass, release_pad ), sizeof( void (*)(GstElement *,GstPad *) ) );
	swigStructField( "_GstElementClass-pad_added", offsetof( struct _GstElementClass, pad_added ), sizeof( void (*)(GstElement *,GstPad *) ) );
	swigStructField( "_GstElementClass-_gst_reserved", offsetof( struct _GstElementClass, _gst_reserved ), sizeof( gpointer [GST_PADDING_LARGE-2] ) );
	swigStructField( "_GstElementClass-request_new_pad", offsetof( struct _GstElementClass, request_new_pad ), sizeof( GstPad *(*)(GstElement *,GstPadTemplate *,char const *,GstCaps const *) ) );
	swigStructField( "_GstElementClass-pad_removed", offsetof( struct _GstElementClass, pad_removed ), sizeof( void (*)(GstElement *,GstPad *) ) );
	swigStructField( "_GstElementClass-metadata", offsetof( struct _GstElementClass, metadata ), sizeof( gpointer ) );
	swigStructField( "_GstElementClass-change_state", offsetof( struct _GstElementClass, change_state ), sizeof( GstStateChangeReturn (*)(GstElement *,GstStateChange) ) );
	swigStructField( "_GstElementClass-state_changed", offsetof( struct _GstElementClass, state_changed ), sizeof( void (*)(GstElement *,GstState,GstState,GstState) ) );
	swigStructField( "_GstElementClass-set_clock", offsetof( struct _GstElementClass, set_clock ), sizeof( gboolean (*)(GstElement *,GstClock *) ) );
	swigStructField( "_GstElementClass-query", offsetof( struct _GstElementClass, query ), sizeof( gboolean (*)(GstElement *,GstQuery *) ) );
	swigStructField( "_GstElementClass-send_event", offsetof( struct _GstElementClass, send_event ), sizeof( gboolean (*)(GstElement *,GstEvent *) ) );
	swigStructField( "_GstElementClass-no_more_pads", offsetof( struct _GstElementClass, no_more_pads ), sizeof( void (*)(GstElement *) ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstElementClass ) );

	swigComment("_GstEvent\n");
	printf( "begin-structure _GstEvent\n" );
	swigStructField( "_GstEvent-seqnum", offsetof( struct _GstEvent, seqnum ), sizeof( guint32 ) );
	swigStructField( "_GstEvent-mini_object", offsetof( struct _GstEvent, mini_object ), sizeof( GstMiniObject ) );
	swigStructField( "_GstEvent-type", offsetof( struct _GstEvent, type ), sizeof( GstEventType ) );
	swigStructField( "_GstEvent-timestamp", offsetof( struct _GstEvent, timestamp ), sizeof( guint64 ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstEvent ) );

	swigComment("_GstProxyPad\n");
	printf( "begin-structure _GstProxyPad\n" );
	swigStructField( "_GstProxyPad-priv", offsetof( struct _GstProxyPad, priv ), sizeof( GstProxyPadPrivate * ) );
	swigStructField( "_GstProxyPad-pad", offsetof( struct _GstProxyPad, pad ), sizeof( GstPad ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstProxyPad ) );

	swigComment("_GstProxyPadClass\n");
	printf( "begin-structure _GstProxyPadClass\n" );
	swigStructField( "_GstProxyPadClass-_gst_reserved", offsetof( struct _GstProxyPadClass, _gst_reserved ), sizeof( gpointer [1] ) );
	swigStructField( "_GstProxyPadClass-parent_class", offsetof( struct _GstProxyPadClass, parent_class ), sizeof( GstPadClass ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstProxyPadClass ) );

	swigComment("_GstGhostPad\n");
	printf( "begin-structure _GstGhostPad\n" );
	swigStructField( "_GstGhostPad-priv", offsetof( struct _GstGhostPad, priv ), sizeof( GstGhostPadPrivate * ) );
	swigStructField( "_GstGhostPad-pad", offsetof( struct _GstGhostPad, pad ), sizeof( GstProxyPad ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstGhostPad ) );

	swigComment("_GstGhostPadClass\n");
	printf( "begin-structure _GstGhostPadClass\n" );
	swigStructField( "_GstGhostPadClass-_gst_reserved", offsetof( struct _GstGhostPadClass, _gst_reserved ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "_GstGhostPadClass-parent_class", offsetof( struct _GstGhostPadClass, parent_class ), sizeof( GstProxyPadClass ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstGhostPadClass ) );

	swigComment("_GstIterator\n");
	printf( "begin-structure _GstIterator\n" );
	swigStructField( "_GstIterator-resync", offsetof( struct _GstIterator, resync ), sizeof( GstIteratorResyncFunction ) );
	swigStructField( "_GstIterator-lock", offsetof( struct _GstIterator, lock ), sizeof( GMutex * ) );
	swigStructField( "_GstIterator-copy", offsetof( struct _GstIterator, copy ), sizeof( GstIteratorCopyFunction ) );
	swigStructField( "_GstIterator-master_cookie", offsetof( struct _GstIterator, master_cookie ), sizeof( guint32 * ) );
	swigStructField( "_GstIterator-_gst_reserved", offsetof( struct _GstIterator, _gst_reserved ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "_GstIterator-free", offsetof( struct _GstIterator, free ), sizeof( GstIteratorFreeFunction ) );
	swigStructField( "_GstIterator-cookie", offsetof( struct _GstIterator, cookie ), sizeof( guint32 ) );
	swigStructField( "_GstIterator-item", offsetof( struct _GstIterator, item ), sizeof( GstIteratorItemFunction ) );
	swigStructField( "_GstIterator-type", offsetof( struct _GstIterator, type ), sizeof( GType ) );
	swigStructField( "_GstIterator-size", offsetof( struct _GstIterator, size ), sizeof( guint ) );
	swigStructField( "_GstIterator-next", offsetof( struct _GstIterator, next ), sizeof( GstIteratorNextFunction ) );
	swigStructField( "_GstIterator-pushed", offsetof( struct _GstIterator, pushed ), sizeof( GstIterator * ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstIterator ) );

	swigComment("_GstMessage\n");
	printf( "begin-structure _GstMessage\n" );
	swigStructField( "_GstMessage-lock", offsetof( struct _GstMessage, lock ), sizeof( GMutex ) );
	swigStructField( "_GstMessage-cond", offsetof( struct _GstMessage, cond ), sizeof( GCond ) );
	swigStructField( "_GstMessage-src", offsetof( struct _GstMessage, src ), sizeof( GstObject * ) );
	swigStructField( "_GstMessage-seqnum", offsetof( struct _GstMessage, seqnum ), sizeof( guint32 ) );
	swigStructField( "_GstMessage-mini_object", offsetof( struct _GstMessage, mini_object ), sizeof( GstMiniObject ) );
	swigStructField( "_GstMessage-type", offsetof( struct _GstMessage, type ), sizeof( GstMessageType ) );
	swigStructField( "_GstMessage-timestamp", offsetof( struct _GstMessage, timestamp ), sizeof( guint64 ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstMessage ) );

	swigComment("_GstMemory\n");
	printf( "begin-structure _GstMemory\n" );
	swigStructField( "_GstMemory-mini_object", offsetof( struct _GstMemory, mini_object ), sizeof( GstMiniObject ) );
	swigStructField( "_GstMemory-maxsize", offsetof( struct _GstMemory, maxsize ), sizeof( gsize ) );
	swigStructField( "_GstMemory-align", offsetof( struct _GstMemory, align ), sizeof( gsize ) );
	swigStructField( "_GstMemory-offset", offsetof( struct _GstMemory, offset ), sizeof( gsize ) );
	swigStructField( "_GstMemory-size", offsetof( struct _GstMemory, size ), sizeof( gsize ) );
	swigStructField( "_GstMemory-allocator", offsetof( struct _GstMemory, allocator ), sizeof( GstAllocator * ) );
	swigStructField( "_GstMemory-parent", offsetof( struct _GstMemory, parent ), sizeof( GstMemory * ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstMemory ) );

	swigComment("GstMapInfo\n");
	printf( "begin-structure GstMapInfo\n" );
	swigStructField( "GstMapInfo-data", offsetof( GstMapInfo, data ), sizeof( guint8 * ) );
	swigStructField( "GstMapInfo-_gst_reserved", offsetof( GstMapInfo, _gst_reserved ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "GstMapInfo-memory", offsetof( GstMapInfo, memory ), sizeof( GstMemory * ) );
	swigStructField( "GstMapInfo-maxsize", offsetof( GstMapInfo, maxsize ), sizeof( gsize ) );
	swigStructField( "GstMapInfo-size", offsetof( GstMapInfo, size ), sizeof( gsize ) );
	swigStructField( "GstMapInfo-user_data", offsetof( GstMapInfo, user_data ), sizeof( gpointer [4] ) );
	swigStructField( "GstMapInfo-flags", offsetof( GstMapInfo, flags ), sizeof( GstMapFlags ) );
	printf( "drop %zu end-structure\n", sizeof( GstMapInfo ) );

	swigComment("_GstMeta\n");
	printf( "begin-structure _GstMeta\n" );
	swigStructField( "_GstMeta-info", offsetof( struct _GstMeta, info ), sizeof( GstMetaInfo const * ) );
	swigStructField( "_GstMeta-flags", offsetof( struct _GstMeta, flags ), sizeof( GstMetaFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstMeta ) );

	swigComment("GstMetaTransformCopy\n");
	printf( "begin-structure GstMetaTransformCopy\n" );
	swigStructField( "GstMetaTransformCopy-offset", offsetof( GstMetaTransformCopy, offset ), sizeof( gsize ) );
	swigStructField( "GstMetaTransformCopy-size", offsetof( GstMetaTransformCopy, size ), sizeof( gsize ) );
	swigStructField( "GstMetaTransformCopy-region", offsetof( GstMetaTransformCopy, region ), sizeof( gboolean ) );
	printf( "drop %zu end-structure\n", sizeof( GstMetaTransformCopy ) );

	swigComment("_GstMetaInfo\n");
	printf( "begin-structure _GstMetaInfo\n" );
	swigStructField( "_GstMetaInfo-init_func", offsetof( struct _GstMetaInfo, init_func ), sizeof( GstMetaInitFunction ) );
	swigStructField( "_GstMetaInfo-transform_func", offsetof( struct _GstMetaInfo, transform_func ), sizeof( GstMetaTransformFunction ) );
	swigStructField( "_GstMetaInfo-type", offsetof( struct _GstMetaInfo, type ), sizeof( GType ) );
	swigStructField( "_GstMetaInfo-size", offsetof( struct _GstMetaInfo, size ), sizeof( gsize ) );
	swigStructField( "_GstMetaInfo-api", offsetof( struct _GstMetaInfo, api ), sizeof( GType ) );
	swigStructField( "_GstMetaInfo-free_func", offsetof( struct _GstMetaInfo, free_func ), sizeof( GstMetaFreeFunction ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstMetaInfo ) );

	swigComment("_GstMiniObject\n");
	printf( "begin-structure _GstMiniObject\n" );
	swigStructField( "_GstMiniObject-refcount", offsetof( struct _GstMiniObject, refcount ), sizeof( gint ) );
	swigStructField( "_GstMiniObject-copy", offsetof( struct _GstMiniObject, copy ), sizeof( GstMiniObjectCopyFunction ) );
	swigStructField( "_GstMiniObject-dispose", offsetof( struct _GstMiniObject, dispose ), sizeof( GstMiniObjectDisposeFunction ) );
	swigStructField( "_GstMiniObject-free", offsetof( struct _GstMiniObject, free ), sizeof( GstMiniObjectFreeFunction ) );
	swigStructField( "_GstMiniObject-type", offsetof( struct _GstMiniObject, type ), sizeof( GType ) );
	swigStructField( "_GstMiniObject-n_qdata", offsetof( struct _GstMiniObject, n_qdata ), sizeof( guint ) );
	swigStructField( "_GstMiniObject-flags", offsetof( struct _GstMiniObject, flags ), sizeof( guint ) );
	swigStructField( "_GstMiniObject-qdata", offsetof( struct _GstMiniObject, qdata ), sizeof( gpointer ) );
	swigStructField( "_GstMiniObject-lockstate", offsetof( struct _GstMiniObject, lockstate ), sizeof( gint ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstMiniObject ) );

	swigComment("_GstObject\n");
	printf( "begin-structure _GstObject\n" );
	swigStructField( "_GstObject-lock", offsetof( struct _GstObject, lock ), sizeof( GMutex ) );
	swigStructField( "_GstObject-last_sync", offsetof( struct _GstObject, last_sync ), sizeof( guint64 ) );
	swigStructField( "_GstObject-name", offsetof( struct _GstObject, name ), sizeof( char * ) );
	swigStructField( "_GstObject-_gst_reserved", offsetof( struct _GstObject, _gst_reserved ), sizeof( gpointer ) );
	swigStructField( "_GstObject-control_rate", offsetof( struct _GstObject, control_rate ), sizeof( guint64 ) );
	swigStructField( "_GstObject-object", offsetof( struct _GstObject, object ), sizeof( GInitiallyUnowned ) );
	swigStructField( "_GstObject-parent", offsetof( struct _GstObject, parent ), sizeof( GstObject * ) );
	swigStructField( "_GstObject-flags", offsetof( struct _GstObject, flags ), sizeof( guint32 ) );
	swigStructField( "_GstObject-control_bindings", offsetof( struct _GstObject, control_bindings ), sizeof( GList * ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstObject ) );

	swigComment("_GstObjectClass\n");
	printf( "begin-structure _GstObjectClass\n" );
	swigStructField( "_GstObjectClass-_gst_reserved", offsetof( struct _GstObjectClass, _gst_reserved ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "_GstObjectClass-path_string_separator", offsetof( struct _GstObjectClass, path_string_separator ), sizeof( char const * ) );
	swigStructField( "_GstObjectClass-deep_notify", offsetof( struct _GstObjectClass, deep_notify ), sizeof( void (*)(GstObject *,GstObject *,GParamSpec *) ) );
	swigStructField( "_GstObjectClass-parent_class", offsetof( struct _GstObjectClass, parent_class ), sizeof( GInitiallyUnownedClass ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstObjectClass ) );

	swigComment("_GstPadProbeInfo\n");
	printf( "begin-structure _GstPadProbeInfo\n" );
	swigStructField( "_GstPadProbeInfo-data", offsetof( struct _GstPadProbeInfo, data ), sizeof( gpointer ) );
	swigStructField( "_GstPadProbeInfo-id", offsetof( struct _GstPadProbeInfo, id ), sizeof( gulong ) );
	swigStructField( "_GstPadProbeInfo-offset", offsetof( struct _GstPadProbeInfo, offset ), sizeof( guint64 ) );
	swigStructField( "_GstPadProbeInfo-type", offsetof( struct _GstPadProbeInfo, type ), sizeof( GstPadProbeType ) );
	swigStructField( "_GstPadProbeInfo-size", offsetof( struct _GstPadProbeInfo, size ), sizeof( guint ) );
	swigStructField( "_GstPadProbeInfo-ABI", offsetof( struct _GstPadProbeInfo, ABI ), sizeof( _GstPadProbeInfo_ABI ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstPadProbeInfo ) );

	swigComment("_GstPadProbeInfo_ABI\n");
	printf( "begin-structure _GstPadProbeInfo_ABI\n" );
	swigStructField( "_GstPadProbeInfo_ABI-_gst_reserved", offsetof( _GstPadProbeInfo_ABI, _gst_reserved ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "_GstPadProbeInfo_ABI-abi", offsetof( _GstPadProbeInfo_ABI, abi ), sizeof( _GstPadProbeInfo_ABI_abi ) );
	printf( "drop %zu end-structure\n", sizeof( _GstPadProbeInfo_ABI ) );

	swigComment("_GstPadProbeInfo_ABI_abi\n");
	printf( "begin-structure _GstPadProbeInfo_ABI_abi\n" );
	swigStructField( "_GstPadProbeInfo_ABI_abi-flow_ret", offsetof( _GstPadProbeInfo_ABI_abi, flow_ret ), sizeof( GstFlowReturn ) );
	printf( "drop %zu end-structure\n", sizeof( _GstPadProbeInfo_ABI_abi ) );

	swigComment("_GstPad\n");
	printf( "begin-structure _GstPad\n" );
	swigStructField( "_GstPad-chainlistfunc", offsetof( struct _GstPad, chainlistfunc ), sizeof( GstPadChainListFunction ) );
	swigStructField( "_GstPad-stream_rec_lock", offsetof( struct _GstPad, stream_rec_lock ), sizeof( GRecMutex ) );
	swigStructField( "_GstPad-task", offsetof( struct _GstPad, task ), sizeof( GstTask * ) );
	swigStructField( "_GstPad-num_probes", offsetof( struct _GstPad, num_probes ), sizeof( gint ) );
	swigStructField( "_GstPad-block_cond", offsetof( struct _GstPad, block_cond ), sizeof( GCond ) );
	swigStructField( "_GstPad-getrangenotify", offsetof( struct _GstPad, getrangenotify ), sizeof( GDestroyNotify ) );
	swigStructField( "_GstPad-unlinknotify", offsetof( struct _GstPad, unlinknotify ), sizeof( GDestroyNotify ) );
	swigStructField( "_GstPad-linknotify", offsetof( struct _GstPad, linknotify ), sizeof( GDestroyNotify ) );
	swigStructField( "_GstPad-activatemodenotify", offsetof( struct _GstPad, activatemodenotify ), sizeof( GDestroyNotify ) );
	swigStructField( "_GstPad-activatenotify", offsetof( struct _GstPad, activatenotify ), sizeof( GDestroyNotify ) );
	swigStructField( "_GstPad-querynotify", offsetof( struct _GstPad, querynotify ), sizeof( GDestroyNotify ) );
	swigStructField( "_GstPad-iterintlinknotify", offsetof( struct _GstPad, iterintlinknotify ), sizeof( GDestroyNotify ) );
	swigStructField( "_GstPad-activatefunc", offsetof( struct _GstPad, activatefunc ), sizeof( GstPadActivateFunction ) );
	swigStructField( "_GstPad-chainfunc", offsetof( struct _GstPad, chainfunc ), sizeof( GstPadChainFunction ) );
	swigStructField( "_GstPad-unlinkfunc", offsetof( struct _GstPad, unlinkfunc ), sizeof( GstPadUnlinkFunction ) );
	swigStructField( "_GstPad-linkfunc", offsetof( struct _GstPad, linkfunc ), sizeof( GstPadLinkFunction ) );
	swigStructField( "_GstPad-iterintlinkfunc", offsetof( struct _GstPad, iterintlinkfunc ), sizeof( GstPadIterIntLinkFunction ) );
	swigStructField( "_GstPad-peer", offsetof( struct _GstPad, peer ), sizeof( GstPad * ) );
	swigStructField( "_GstPad-probes", offsetof( struct _GstPad, probes ), sizeof( GHookList ) );
	swigStructField( "_GstPad-eventfunc", offsetof( struct _GstPad, eventfunc ), sizeof( GstPadEventFunction ) );
	swigStructField( "_GstPad-querydata", offsetof( struct _GstPad, querydata ), sizeof( gpointer ) );
	swigStructField( "_GstPad-direction", offsetof( struct _GstPad, direction ), sizeof( GstPadDirection ) );
	swigStructField( "_GstPad-chainlistdata", offsetof( struct _GstPad, chainlistdata ), sizeof( gpointer ) );
	swigStructField( "_GstPad-eventnotify", offsetof( struct _GstPad, eventnotify ), sizeof( GDestroyNotify ) );
	swigStructField( "_GstPad-chainlistnotify", offsetof( struct _GstPad, chainlistnotify ), sizeof( GDestroyNotify ) );
	swigStructField( "_GstPad-chainnotify", offsetof( struct _GstPad, chainnotify ), sizeof( GDestroyNotify ) );
	swigStructField( "_GstPad-getrangefunc", offsetof( struct _GstPad, getrangefunc ), sizeof( GstPadGetRangeFunction ) );
	swigStructField( "_GstPad-activatemodefunc", offsetof( struct _GstPad, activatemodefunc ), sizeof( GstPadActivateModeFunction ) );
	swigStructField( "_GstPad-activatedata", offsetof( struct _GstPad, activatedata ), sizeof( gpointer ) );
	swigStructField( "_GstPad-chaindata", offsetof( struct _GstPad, chaindata ), sizeof( gpointer ) );
	swigStructField( "_GstPad-element_private", offsetof( struct _GstPad, element_private ), sizeof( gpointer ) );
	swigStructField( "_GstPad-padtemplate", offsetof( struct _GstPad, padtemplate ), sizeof( GstPadTemplate * ) );
	swigStructField( "_GstPad-unlinkdata", offsetof( struct _GstPad, unlinkdata ), sizeof( gpointer ) );
	swigStructField( "_GstPad-linkdata", offsetof( struct _GstPad, linkdata ), sizeof( gpointer ) );
	swigStructField( "_GstPad-iterintlinkdata", offsetof( struct _GstPad, iterintlinkdata ), sizeof( gpointer ) );
	swigStructField( "_GstPad-priv", offsetof( struct _GstPad, priv ), sizeof( GstPadPrivate * ) );
	swigStructField( "_GstPad-eventdata", offsetof( struct _GstPad, eventdata ), sizeof( gpointer ) );
	swigStructField( "_GstPad-num_blocked", offsetof( struct _GstPad, num_blocked ), sizeof( gint ) );
	swigStructField( "_GstPad-object", offsetof( struct _GstPad, object ), sizeof( GstObject ) );
	swigStructField( "_GstPad-getrangedata", offsetof( struct _GstPad, getrangedata ), sizeof( gpointer ) );
	swigStructField( "_GstPad-activatemodedata", offsetof( struct _GstPad, activatemodedata ), sizeof( gpointer ) );
	swigStructField( "_GstPad-queryfunc", offsetof( struct _GstPad, queryfunc ), sizeof( GstPadQueryFunction ) );
	swigStructField( "_GstPad-mode", offsetof( struct _GstPad, mode ), sizeof( GstPadMode ) );
	swigStructField( "_GstPad-offset", offsetof( struct _GstPad, offset ), sizeof( gint64 ) );
	swigStructField( "_GstPad-ABI", offsetof( struct _GstPad, ABI ), sizeof( _GstPad_ABI ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstPad ) );

	swigComment("_GstPad_ABI\n");
	printf( "begin-structure _GstPad_ABI\n" );
	swigStructField( "_GstPad_ABI-_gst_reserved", offsetof( _GstPad_ABI, _gst_reserved ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "_GstPad_ABI-abi", offsetof( _GstPad_ABI, abi ), sizeof( _GstPad_ABI_abi ) );
	printf( "drop %zu end-structure\n", sizeof( _GstPad_ABI ) );

	swigComment("_GstPad_ABI_abi\n");
	printf( "begin-structure _GstPad_ABI_abi\n" );
	swigStructField( "_GstPad_ABI_abi-eventfullfunc", offsetof( _GstPad_ABI_abi, eventfullfunc ), sizeof( GstPadEventFullFunction ) );
	swigStructField( "_GstPad_ABI_abi-last_flowret", offsetof( _GstPad_ABI_abi, last_flowret ), sizeof( GstFlowReturn ) );
	printf( "drop %zu end-structure\n", sizeof( _GstPad_ABI_abi ) );

	swigComment("_GstPadClass\n");
	printf( "begin-structure _GstPadClass\n" );
	swigStructField( "_GstPadClass-_gst_reserved", offsetof( struct _GstPadClass, _gst_reserved ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "_GstPadClass-parent_class", offsetof( struct _GstPadClass, parent_class ), sizeof( GstObjectClass ) );
	swigStructField( "_GstPadClass-linked", offsetof( struct _GstPadClass, linked ), sizeof( void (*)(GstPad *,GstPad *) ) );
	swigStructField( "_GstPadClass-unlinked", offsetof( struct _GstPadClass, unlinked ), sizeof( void (*)(GstPad *,GstPad *) ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstPadClass ) );

	swigComment("_GstParamSpecFraction\n");
	printf( "begin-structure _GstParamSpecFraction\n" );
	swigStructField( "_GstParamSpecFraction-min_den", offsetof( struct _GstParamSpecFraction, min_den ), sizeof( gint ) );
	swigStructField( "_GstParamSpecFraction-parent_instance", offsetof( struct _GstParamSpecFraction, parent_instance ), sizeof( GParamSpec ) );
	swigStructField( "_GstParamSpecFraction-max_num", offsetof( struct _GstParamSpecFraction, max_num ), sizeof( gint ) );
	swigStructField( "_GstParamSpecFraction-def_num", offsetof( struct _GstParamSpecFraction, def_num ), sizeof( gint ) );
	swigStructField( "_GstParamSpecFraction-max_den", offsetof( struct _GstParamSpecFraction, max_den ), sizeof( gint ) );
	swigStructField( "_GstParamSpecFraction-def_den", offsetof( struct _GstParamSpecFraction, def_den ), sizeof( gint ) );
	swigStructField( "_GstParamSpecFraction-min_num", offsetof( struct _GstParamSpecFraction, min_num ), sizeof( gint ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstParamSpecFraction ) );

	swigComment("_GstParamSpecArray\n");
	printf( "begin-structure _GstParamSpecArray\n" );
	swigStructField( "_GstParamSpecArray-parent_instance", offsetof( struct _GstParamSpecArray, parent_instance ), sizeof( GParamSpec ) );
	swigStructField( "_GstParamSpecArray-element_spec", offsetof( struct _GstParamSpecArray, element_spec ), sizeof( GParamSpec * ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstParamSpecArray ) );

	swigComment("_GstPipeline\n");
	printf( "begin-structure _GstPipeline\n" );
	swigStructField( "_GstPipeline-delay", offsetof( struct _GstPipeline, delay ), sizeof( GstClockTime ) );
	swigStructField( "_GstPipeline-_gst_reserved", offsetof( struct _GstPipeline, _gst_reserved ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "_GstPipeline-stream_time", offsetof( struct _GstPipeline, stream_time ), sizeof( GstClockTime ) );
	swigStructField( "_GstPipeline-fixed_clock", offsetof( struct _GstPipeline, fixed_clock ), sizeof( GstClock * ) );
	swigStructField( "_GstPipeline-priv", offsetof( struct _GstPipeline, priv ), sizeof( GstPipelinePrivate * ) );
	swigStructField( "_GstPipeline-bin", offsetof( struct _GstPipeline, bin ), sizeof( GstBin ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstPipeline ) );

	swigComment("_GstPipelineClass\n");
	printf( "begin-structure _GstPipelineClass\n" );
	swigStructField( "_GstPipelineClass-_gst_reserved", offsetof( struct _GstPipelineClass, _gst_reserved ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "_GstPipelineClass-parent_class", offsetof( struct _GstPipelineClass, parent_class ), sizeof( GstBinClass ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstPipelineClass ) );

	swigComment("_GstPluginDesc\n");
	printf( "begin-structure _GstPluginDesc\n" );
	swigStructField( "_GstPluginDesc-name", offsetof( struct _GstPluginDesc, name ), sizeof( char const * ) );
	swigStructField( "_GstPluginDesc-_gst_reserved", offsetof( struct _GstPluginDesc, _gst_reserved ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "_GstPluginDesc-major_version", offsetof( struct _GstPluginDesc, major_version ), sizeof( gint ) );
	swigStructField( "_GstPluginDesc-minor_version", offsetof( struct _GstPluginDesc, minor_version ), sizeof( gint ) );
	swigStructField( "_GstPluginDesc-plugin_init", offsetof( struct _GstPluginDesc, plugin_init ), sizeof( GstPluginInitFunc ) );
	swigStructField( "_GstPluginDesc-version", offsetof( struct _GstPluginDesc, version ), sizeof( char const * ) );
	swigStructField( "_GstPluginDesc-license", offsetof( struct _GstPluginDesc, license ), sizeof( char const * ) );
	swigStructField( "_GstPluginDesc-source", offsetof( struct _GstPluginDesc, source ), sizeof( char const * ) );
	swigStructField( "_GstPluginDesc-package", offsetof( struct _GstPluginDesc, package ), sizeof( char const * ) );
	swigStructField( "_GstPluginDesc-description", offsetof( struct _GstPluginDesc, description ), sizeof( char const * ) );
	swigStructField( "_GstPluginDesc-origin", offsetof( struct _GstPluginDesc, origin ), sizeof( char const * ) );
	swigStructField( "_GstPluginDesc-release_datetime", offsetof( struct _GstPluginDesc, release_datetime ), sizeof( char const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstPluginDesc ) );

	swigComment("GstPollFD\n");
	printf( "begin-structure GstPollFD\n" );
	swigStructField( "GstPollFD-idx", offsetof( GstPollFD, idx ), sizeof( gint ) );
	swigStructField( "GstPollFD-fd", offsetof( GstPollFD, fd ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( GstPollFD ) );

	swigComment("_GstPresetInterface\n");
	printf( "begin-structure _GstPresetInterface\n" );
	swigStructField( "_GstPresetInterface-_gst_reserved", offsetof( struct _GstPresetInterface, _gst_reserved ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "_GstPresetInterface-load_preset", offsetof( struct _GstPresetInterface, load_preset ), sizeof( gboolean (*)(GstPreset *,char const *) ) );
	swigStructField( "_GstPresetInterface-save_preset", offsetof( struct _GstPresetInterface, save_preset ), sizeof( gboolean (*)(GstPreset *,char const *) ) );
	swigStructField( "_GstPresetInterface-rename_preset", offsetof( struct _GstPresetInterface, rename_preset ), sizeof( gboolean (*)(GstPreset *,char const *,char const *) ) );
	swigStructField( "_GstPresetInterface-delete_preset", offsetof( struct _GstPresetInterface, delete_preset ), sizeof( gboolean (*)(GstPreset *,char const *) ) );
	swigStructField( "_GstPresetInterface-set_meta", offsetof( struct _GstPresetInterface, set_meta ), sizeof( gboolean (*)(GstPreset *,char const *,char const *,char const *) ) );
	swigStructField( "_GstPresetInterface-get_meta", offsetof( struct _GstPresetInterface, get_meta ), sizeof( gboolean (*)(GstPreset *,char const *,char const *,char **) ) );
	swigStructField( "_GstPresetInterface-parent", offsetof( struct _GstPresetInterface, parent ), sizeof( GTypeInterface ) );
	swigStructField( "_GstPresetInterface-get_property_names", offsetof( struct _GstPresetInterface, get_property_names ), sizeof( char **(*)(GstPreset *) ) );
	swigStructField( "_GstPresetInterface-get_preset_names", offsetof( struct _GstPresetInterface, get_preset_names ), sizeof( char **(*)(GstPreset *) ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstPresetInterface ) );

	swigComment("_GstQuery\n");
	printf( "begin-structure _GstQuery\n" );
	swigStructField( "_GstQuery-mini_object", offsetof( struct _GstQuery, mini_object ), sizeof( GstMiniObject ) );
	swigStructField( "_GstQuery-type", offsetof( struct _GstQuery, type ), sizeof( GstQueryType ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstQuery ) );

	swigComment("_GstRegistry\n");
	printf( "begin-structure _GstRegistry\n" );
	swigStructField( "_GstRegistry-priv", offsetof( struct _GstRegistry, priv ), sizeof( GstRegistryPrivate * ) );
	swigStructField( "_GstRegistry-object", offsetof( struct _GstRegistry, object ), sizeof( GstObject ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstRegistry ) );

	swigComment("_GstRegistryClass\n");
	printf( "begin-structure _GstRegistryClass\n" );
	swigStructField( "_GstRegistryClass-parent_class", offsetof( struct _GstRegistryClass, parent_class ), sizeof( GstObjectClass ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstRegistryClass ) );

	swigComment("_GstSegment\n");
	printf( "begin-structure _GstSegment\n" );
	swigStructField( "_GstSegment-stop", offsetof( struct _GstSegment, stop ), sizeof( guint64 ) );
	swigStructField( "_GstSegment-applied_rate", offsetof( struct _GstSegment, applied_rate ), sizeof( gdouble ) );
	swigStructField( "_GstSegment-position", offsetof( struct _GstSegment, position ), sizeof( guint64 ) );
	swigStructField( "_GstSegment-_gst_reserved", offsetof( struct _GstSegment, _gst_reserved ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "_GstSegment-time", offsetof( struct _GstSegment, time ), sizeof( guint64 ) );
	swigStructField( "_GstSegment-duration", offsetof( struct _GstSegment, duration ), sizeof( guint64 ) );
	swigStructField( "_GstSegment-offset", offsetof( struct _GstSegment, offset ), sizeof( guint64 ) );
	swigStructField( "_GstSegment-flags", offsetof( struct _GstSegment, flags ), sizeof( GstSegmentFlags ) );
	swigStructField( "_GstSegment-rate", offsetof( struct _GstSegment, rate ), sizeof( gdouble ) );
	swigStructField( "_GstSegment-format", offsetof( struct _GstSegment, format ), sizeof( GstFormat ) );
	swigStructField( "_GstSegment-start", offsetof( struct _GstSegment, start ), sizeof( guint64 ) );
	swigStructField( "_GstSegment-base", offsetof( struct _GstSegment, base ), sizeof( guint64 ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstSegment ) );

	swigComment("_GstStructure\n");
	printf( "begin-structure _GstStructure\n" );
	swigStructField( "_GstStructure-name", offsetof( struct _GstStructure, name ), sizeof( GQuark ) );
	swigStructField( "_GstStructure-type", offsetof( struct _GstStructure, type ), sizeof( GType ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstStructure ) );

	swigComment("_GstSystemClock\n");
	printf( "begin-structure _GstSystemClock\n" );
	swigStructField( "_GstSystemClock-_gst_reserved", offsetof( struct _GstSystemClock, _gst_reserved ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "_GstSystemClock-priv", offsetof( struct _GstSystemClock, priv ), sizeof( GstSystemClockPrivate * ) );
	swigStructField( "_GstSystemClock-clock", offsetof( struct _GstSystemClock, clock ), sizeof( GstClock ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstSystemClock ) );

	swigComment("_GstSystemClockClass\n");
	printf( "begin-structure _GstSystemClockClass\n" );
	swigStructField( "_GstSystemClockClass-_gst_reserved", offsetof( struct _GstSystemClockClass, _gst_reserved ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "_GstSystemClockClass-parent_class", offsetof( struct _GstSystemClockClass, parent_class ), sizeof( GstClockClass ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstSystemClockClass ) );

	swigComment("_GstTagList\n");
	printf( "begin-structure _GstTagList\n" );
	swigStructField( "_GstTagList-mini_object", offsetof( struct _GstTagList, mini_object ), sizeof( GstMiniObject ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstTagList ) );

	swigComment("_GstTagSetterInterface\n");
	printf( "begin-structure _GstTagSetterInterface\n" );
	swigStructField( "_GstTagSetterInterface-g_iface", offsetof( struct _GstTagSetterInterface, g_iface ), sizeof( GTypeInterface ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstTagSetterInterface ) );

	swigComment("_GstTask\n");
	printf( "begin-structure _GstTask\n" );
	swigStructField( "_GstTask-cond", offsetof( struct _GstTask, cond ), sizeof( GCond ) );
	swigStructField( "_GstTask-lock", offsetof( struct _GstTask, lock ), sizeof( GRecMutex * ) );
	swigStructField( "_GstTask-func", offsetof( struct _GstTask, func ), sizeof( GstTaskFunction ) );
	swigStructField( "_GstTask-thread", offsetof( struct _GstTask, thread ), sizeof( GThread * ) );
	swigStructField( "_GstTask-_gst_reserved", offsetof( struct _GstTask, _gst_reserved ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "_GstTask-running", offsetof( struct _GstTask, running ), sizeof( gboolean ) );
	swigStructField( "_GstTask-priv", offsetof( struct _GstTask, priv ), sizeof( GstTaskPrivate * ) );
	swigStructField( "_GstTask-object", offsetof( struct _GstTask, object ), sizeof( GstObject ) );
	swigStructField( "_GstTask-user_data", offsetof( struct _GstTask, user_data ), sizeof( gpointer ) );
	swigStructField( "_GstTask-state", offsetof( struct _GstTask, state ), sizeof( GstTaskState ) );
	swigStructField( "_GstTask-notify", offsetof( struct _GstTask, notify ), sizeof( GDestroyNotify ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstTask ) );

	swigComment("_GstTaskClass\n");
	printf( "begin-structure _GstTaskClass\n" );
	swigStructField( "_GstTaskClass-_gst_reserved", offsetof( struct _GstTaskClass, _gst_reserved ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "_GstTaskClass-pool", offsetof( struct _GstTaskClass, pool ), sizeof( GstTaskPool * ) );
	swigStructField( "_GstTaskClass-parent_class", offsetof( struct _GstTaskClass, parent_class ), sizeof( GstObjectClass ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstTaskClass ) );

	swigComment("_GstTaskPool\n");
	printf( "begin-structure _GstTaskPool\n" );
	swigStructField( "_GstTaskPool-_gst_reserved", offsetof( struct _GstTaskPool, _gst_reserved ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "_GstTaskPool-object", offsetof( struct _GstTaskPool, object ), sizeof( GstObject ) );
	swigStructField( "_GstTaskPool-pool", offsetof( struct _GstTaskPool, pool ), sizeof( GThreadPool * ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstTaskPool ) );

	swigComment("_GstTaskPoolClass\n");
	printf( "begin-structure _GstTaskPoolClass\n" );
	swigStructField( "_GstTaskPoolClass-push", offsetof( struct _GstTaskPoolClass, push ), sizeof( gpointer (*)(GstTaskPool *,GstTaskPoolFunction,gpointer,GError **) ) );
	swigStructField( "_GstTaskPoolClass-_gst_reserved", offsetof( struct _GstTaskPoolClass, _gst_reserved ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "_GstTaskPoolClass-prepare", offsetof( struct _GstTaskPoolClass, prepare ), sizeof( void (*)(GstTaskPool *,GError **) ) );
	swigStructField( "_GstTaskPoolClass-cleanup", offsetof( struct _GstTaskPoolClass, cleanup ), sizeof( void (*)(GstTaskPool *) ) );
	swigStructField( "_GstTaskPoolClass-join", offsetof( struct _GstTaskPoolClass, join ), sizeof( void (*)(GstTaskPool *,gpointer) ) );
	swigStructField( "_GstTaskPoolClass-parent_class", offsetof( struct _GstTaskPoolClass, parent_class ), sizeof( GstObjectClass ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstTaskPoolClass ) );

	swigComment("_GstTocSetterInterface\n");
	printf( "begin-structure _GstTocSetterInterface\n" );
	swigStructField( "_GstTocSetterInterface-g_iface", offsetof( struct _GstTocSetterInterface, g_iface ), sizeof( GTypeInterface ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstTocSetterInterface ) );

	swigComment("_GstTypeFind\n");
	printf( "begin-structure _GstTypeFind\n" );
	swigStructField( "_GstTypeFind-data", offsetof( struct _GstTypeFind, data ), sizeof( gpointer ) );
	swigStructField( "_GstTypeFind-_gst_reserved", offsetof( struct _GstTypeFind, _gst_reserved ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "_GstTypeFind-get_length", offsetof( struct _GstTypeFind, get_length ), sizeof( guint64 (*)(gpointer) ) );
	swigStructField( "_GstTypeFind-suggest", offsetof( struct _GstTypeFind, suggest ), sizeof( void (*)(gpointer,guint,GstCaps *) ) );
	swigStructField( "_GstTypeFind-peek", offsetof( struct _GstTypeFind, peek ), sizeof( guint8 const *(*)(gpointer,gint64,guint) ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstTypeFind ) );

	swigComment("_GstURIHandlerInterface\n");
	printf( "begin-structure _GstURIHandlerInterface\n" );
	swigStructField( "_GstURIHandlerInterface-get_protocols", offsetof( struct _GstURIHandlerInterface, get_protocols ), sizeof( char const *const *(*)(GType) ) );
	swigStructField( "_GstURIHandlerInterface-get_type", offsetof( struct _GstURIHandlerInterface, get_type ), sizeof( GstURIType (*)(GType) ) );
	swigStructField( "_GstURIHandlerInterface-parent", offsetof( struct _GstURIHandlerInterface, parent ), sizeof( GTypeInterface ) );
	swigStructField( "_GstURIHandlerInterface-get_uri", offsetof( struct _GstURIHandlerInterface, get_uri ), sizeof( char *(*)(GstURIHandler *) ) );
	swigStructField( "_GstURIHandlerInterface-set_uri", offsetof( struct _GstURIHandlerInterface, set_uri ), sizeof( gboolean (*)(GstURIHandler *,char const *,GError **) ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstURIHandlerInterface ) );

	swigComment("_GstValueTable\n");
	printf( "begin-structure _GstValueTable\n" );
	swigStructField( "_GstValueTable-_gst_reserved", offsetof( struct _GstValueTable, _gst_reserved ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "_GstValueTable-type", offsetof( struct _GstValueTable, type ), sizeof( GType ) );
	swigStructField( "_GstValueTable-serialize", offsetof( struct _GstValueTable, serialize ), sizeof( GstValueSerializeFunc ) );
	swigStructField( "_GstValueTable-deserialize", offsetof( struct _GstValueTable, deserialize ), sizeof( GstValueDeserializeFunc ) );
	swigStructField( "_GstValueTable-compare", offsetof( struct _GstValueTable, compare ), sizeof( GstValueCompareFunc ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstValueTable ) );

	swigComment("_GstGLDisplay\n");
	printf( "begin-structure _GstGLDisplay\n" );
	swigStructField( "_GstGLDisplay-event_source", offsetof( struct _GstGLDisplay, event_source ), sizeof( GSource * ) );
	swigStructField( "_GstGLDisplay-priv", offsetof( struct _GstGLDisplay, priv ), sizeof( GstGLDisplayPrivate * ) );
	swigStructField( "_GstGLDisplay-object", offsetof( struct _GstGLDisplay, object ), sizeof( GstObject ) );
	swigStructField( "_GstGLDisplay-type", offsetof( struct _GstGLDisplay, type ), sizeof( GstGLDisplayType ) );
	swigStructField( "_GstGLDisplay-main_context", offsetof( struct _GstGLDisplay, main_context ), sizeof( GMainContext * ) );
	swigStructField( "_GstGLDisplay-windows", offsetof( struct _GstGLDisplay, windows ), sizeof( GList * ) );
	swigStructField( "_GstGLDisplay-main_loop", offsetof( struct _GstGLDisplay, main_loop ), sizeof( GMainLoop * ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstGLDisplay ) );

	swigComment("_GstGLDisplayClass\n");
	printf( "begin-structure _GstGLDisplayClass\n" );
	swigStructField( "_GstGLDisplayClass-get_handle", offsetof( struct _GstGLDisplayClass, get_handle ), sizeof( guintptr (*)(GstGLDisplay *) ) );
	swigStructField( "_GstGLDisplayClass-create_window", offsetof( struct _GstGLDisplayClass, create_window ), sizeof( GstGLWindow *(*)(GstGLDisplay *) ) );
	swigStructField( "_GstGLDisplayClass-_padding", offsetof( struct _GstGLDisplayClass, _padding ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "_GstGLDisplayClass-object_class", offsetof( struct _GstGLDisplayClass, object_class ), sizeof( GstObjectClass ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstGLDisplayClass ) );

	swigComment("_GstGLContext\n");
	printf( "begin-structure _GstGLContext\n" );
	swigStructField( "_GstGLContext-display", offsetof( struct _GstGLContext, display ), sizeof( GstGLDisplay * ) );
	swigStructField( "_GstGLContext-_reserved", offsetof( struct _GstGLContext, _reserved ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "_GstGLContext-window", offsetof( struct _GstGLContext, window ), sizeof( GstGLWindow * ) );
	swigStructField( "_GstGLContext-priv", offsetof( struct _GstGLContext, priv ), sizeof( GstGLContextPrivate * ) );
	swigStructField( "_GstGLContext-gl_vtable", offsetof( struct _GstGLContext, gl_vtable ), sizeof( GstGLFuncs * ) );
	swigStructField( "_GstGLContext-parent", offsetof( struct _GstGLContext, parent ), sizeof( GstObject ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstGLContext ) );

	swigComment("_GstGLContextClass\n");
	printf( "begin-structure _GstGLContextClass\n" );
	swigStructField( "_GstGLContextClass-parent_class", offsetof( struct _GstGLContextClass, parent_class ), sizeof( GstObjectClass ) );
	swigStructField( "_GstGLContextClass-check_feature", offsetof( struct _GstGLContextClass, check_feature ), sizeof( gboolean (*)(GstGLContext *,char const *) ) );
	swigStructField( "_GstGLContextClass-destroy_context", offsetof( struct _GstGLContextClass, destroy_context ), sizeof( void (*)(GstGLContext *) ) );
	swigStructField( "_GstGLContextClass-create_context", offsetof( struct _GstGLContextClass, create_context ), sizeof( gboolean (*)(GstGLContext *,GstGLAPI,GstGLContext *,GError **) ) );
	swigStructField( "_GstGLContextClass-get_gl_platform", offsetof( struct _GstGLContextClass, get_gl_platform ), sizeof( GstGLPlatform (*)(GstGLContext *) ) );
	swigStructField( "_GstGLContextClass-get_gl_context", offsetof( struct _GstGLContextClass, get_gl_context ), sizeof( guintptr (*)(GstGLContext *) ) );
	swigStructField( "_GstGLContextClass-get_current_context", offsetof( struct _GstGLContextClass, get_current_context ), sizeof( guintptr (*)(void) ) );
	swigStructField( "_GstGLContextClass-swap_buffers", offsetof( struct _GstGLContextClass, swap_buffers ), sizeof( void (*)(GstGLContext *) ) );
	swigStructField( "_GstGLContextClass-_reserved", offsetof( struct _GstGLContextClass, _reserved ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "_GstGLContextClass-choose_format", offsetof( struct _GstGLContextClass, choose_format ), sizeof( gboolean (*)(GstGLContext *,GError **) ) );
	swigStructField( "_GstGLContextClass-get_gl_api", offsetof( struct _GstGLContextClass, get_gl_api ), sizeof( GstGLAPI (*)(GstGLContext *) ) );
	swigStructField( "_GstGLContextClass-get_gl_platform_version", offsetof( struct _GstGLContextClass, get_gl_platform_version ), sizeof( void (*)(GstGLContext *,gint *,gint *) ) );
	swigStructField( "_GstGLContextClass-activate", offsetof( struct _GstGLContextClass, activate ), sizeof( gboolean (*)(GstGLContext *,gboolean) ) );
	swigStructField( "_GstGLContextClass-get_proc_address", offsetof( struct _GstGLContextClass, get_proc_address ), sizeof( gpointer (*)(GstGLAPI,char const *) ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstGLContextClass ) );

	swigComment("_GstGLWindow\n");
	printf( "begin-structure _GstGLWindow\n" );
	swigStructField( "_GstGLWindow-is_drawing", offsetof( struct _GstGLWindow, is_drawing ), sizeof( gboolean ) );
	swigStructField( "_GstGLWindow-resize", offsetof( struct _GstGLWindow, resize ), sizeof( GstGLWindowResizeCB ) );
	swigStructField( "_GstGLWindow-main_context", offsetof( struct _GstGLWindow, main_context ), sizeof( GMainContext * ) );
	swigStructField( "_GstGLWindow-context_ref", offsetof( struct _GstGLWindow, context_ref ), sizeof( GWeakRef ) );
	swigStructField( "_GstGLWindow-resize_notify", offsetof( struct _GstGLWindow, resize_notify ), sizeof( GDestroyNotify ) );
	swigStructField( "_GstGLWindow-close_notify", offsetof( struct _GstGLWindow, close_notify ), sizeof( GDestroyNotify ) );
	swigStructField( "_GstGLWindow-draw_notify", offsetof( struct _GstGLWindow, draw_notify ), sizeof( GDestroyNotify ) );
	swigStructField( "_GstGLWindow-draw", offsetof( struct _GstGLWindow, draw ), sizeof( GstGLWindowCB ) );
	swigStructField( "_GstGLWindow-queue_resize", offsetof( struct _GstGLWindow, queue_resize ), sizeof( gboolean ) );
	swigStructField( "_GstGLWindow-_reserved", offsetof( struct _GstGLWindow, _reserved ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "_GstGLWindow-display", offsetof( struct _GstGLWindow, display ), sizeof( GstGLDisplay * ) );
	swigStructField( "_GstGLWindow-resize_data", offsetof( struct _GstGLWindow, resize_data ), sizeof( gpointer ) );
	swigStructField( "_GstGLWindow-priv", offsetof( struct _GstGLWindow, priv ), sizeof( GstGLWindowPrivate * ) );
	swigStructField( "_GstGLWindow-close_data", offsetof( struct _GstGLWindow, close_data ), sizeof( gpointer ) );
	swigStructField( "_GstGLWindow-close", offsetof( struct _GstGLWindow, close ), sizeof( GstGLWindowCB ) );
	swigStructField( "_GstGLWindow-parent", offsetof( struct _GstGLWindow, parent ), sizeof( GstObject ) );
	swigStructField( "_GstGLWindow-draw_data", offsetof( struct _GstGLWindow, draw_data ), sizeof( gpointer ) );
	swigStructField( "_GstGLWindow-lock", offsetof( struct _GstGLWindow, lock ), sizeof( GMutex ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstGLWindow ) );

	swigComment("_GstGLWindowClass\n");
	printf( "begin-structure _GstGLWindowClass\n" );
	swigStructField( "_GstGLWindowClass-parent_class", offsetof( struct _GstGLWindowClass, parent_class ), sizeof( GstObjectClass ) );
	swigStructField( "_GstGLWindowClass-set_preferred_size", offsetof( struct _GstGLWindowClass, set_preferred_size ), sizeof( void (*)(GstGLWindow *,gint,gint) ) );
	swigStructField( "_GstGLWindowClass-handle_events", offsetof( struct _GstGLWindowClass, handle_events ), sizeof( void (*)(GstGLWindow *,gboolean) ) );
	swigStructField( "_GstGLWindowClass-get_window_handle", offsetof( struct _GstGLWindowClass, get_window_handle ), sizeof( guintptr (*)(GstGLWindow *) ) );
	swigStructField( "_GstGLWindowClass-set_window_handle", offsetof( struct _GstGLWindowClass, set_window_handle ), sizeof( void (*)(GstGLWindow *,guintptr) ) );
	swigStructField( "_GstGLWindowClass-show", offsetof( struct _GstGLWindowClass, show ), sizeof( void (*)(GstGLWindow *) ) );
	swigStructField( "_GstGLWindowClass-send_message", offsetof( struct _GstGLWindowClass, send_message ), sizeof( void (*)(GstGLWindow *,GstGLWindowCB,gpointer) ) );
	swigStructField( "_GstGLWindowClass-draw", offsetof( struct _GstGLWindowClass, draw ), sizeof( void (*)(GstGLWindow *) ) );
	swigStructField( "_GstGLWindowClass-set_render_rectangle", offsetof( struct _GstGLWindowClass, set_render_rectangle ), sizeof( gboolean (*)(GstGLWindow *,gint,gint,gint,gint) ) );
	swigStructField( "_GstGLWindowClass-queue_resize", offsetof( struct _GstGLWindowClass, queue_resize ), sizeof( void (*)(GstGLWindow *) ) );
	swigStructField( "_GstGLWindowClass-send_message_async", offsetof( struct _GstGLWindowClass, send_message_async ), sizeof( void (*)(GstGLWindow *,GstGLWindowCB,gpointer,GDestroyNotify) ) );
	swigStructField( "_GstGLWindowClass-_reserved", offsetof( struct _GstGLWindowClass, _reserved ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "_GstGLWindowClass-get_display", offsetof( struct _GstGLWindowClass, get_display ), sizeof( guintptr (*)(GstGLWindow *) ) );
	swigStructField( "_GstGLWindowClass-run", offsetof( struct _GstGLWindowClass, run ), sizeof( void (*)(GstGLWindow *) ) );
	swigStructField( "_GstGLWindowClass-open", offsetof( struct _GstGLWindowClass, open ), sizeof( gboolean (*)(GstGLWindow *,GError **) ) );
	swigStructField( "_GstGLWindowClass-quit", offsetof( struct _GstGLWindowClass, quit ), sizeof( void (*)(GstGLWindow *) ) );
	swigStructField( "_GstGLWindowClass-close", offsetof( struct _GstGLWindowClass, close ), sizeof( void (*)(GstGLWindow *) ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstGLWindowClass ) );

	swigComment("_GstGLShader\n");
	printf( "begin-structure _GstGLShader\n" );
	swigStructField( "_GstGLShader-priv", offsetof( struct _GstGLShader, priv ), sizeof( GstGLShaderPrivate * ) );
	swigStructField( "_GstGLShader-_padding", offsetof( struct _GstGLShader, _padding ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "_GstGLShader-parent", offsetof( struct _GstGLShader, parent ), sizeof( GstObject ) );
	swigStructField( "_GstGLShader-context", offsetof( struct _GstGLShader, context ), sizeof( GstGLContext * ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstGLShader ) );

	swigComment("_GstGLShaderClass\n");
	printf( "begin-structure _GstGLShaderClass\n" );
	swigStructField( "_GstGLShaderClass-parent_class", offsetof( struct _GstGLShaderClass, parent_class ), sizeof( GstObjectClass ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstGLShaderClass ) );

	swigComment("_GstGLUpload\n");
	printf( "begin-structure _GstGLUpload\n" );
	swigStructField( "_GstGLUpload-_reserved", offsetof( struct _GstGLUpload, _reserved ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "_GstGLUpload-priv", offsetof( struct _GstGLUpload, priv ), sizeof( GstGLUploadPrivate * ) );
	swigStructField( "_GstGLUpload-parent", offsetof( struct _GstGLUpload, parent ), sizeof( GstObject ) );
	swigStructField( "_GstGLUpload-context", offsetof( struct _GstGLUpload, context ), sizeof( GstGLContext * ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstGLUpload ) );

	swigComment("_GstGLUploadClass\n");
	printf( "begin-structure _GstGLUploadClass\n" );
	swigStructField( "_GstGLUploadClass-_padding", offsetof( struct _GstGLUploadClass, _padding ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "_GstGLUploadClass-object_class", offsetof( struct _GstGLUploadClass, object_class ), sizeof( GstObjectClass ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstGLUploadClass ) );

	swigComment("_GstGLMemory\n");
	printf( "begin-structure _GstGLMemory\n" );
	swigStructField( "_GstGLMemory-tex_id", offsetof( struct _GstGLMemory, tex_id ), sizeof( guint ) );
	swigStructField( "_GstGLMemory-tex_target", offsetof( struct _GstGLMemory, tex_target ), sizeof( GstGLTextureTarget ) );
	swigStructField( "_GstGLMemory-tex_scaling", offsetof( struct _GstGLMemory, tex_scaling ), sizeof( gfloat [2] ) );
	swigStructField( "_GstGLMemory-mem", offsetof( struct _GstGLMemory, mem ), sizeof( GstGLBaseMemory ) );
	swigStructField( "_GstGLMemory-plane", offsetof( struct _GstGLMemory, plane ), sizeof( guint ) );
	swigStructField( "_GstGLMemory-unpack_length", offsetof( struct _GstGLMemory, unpack_length ), sizeof( guint ) );
	swigStructField( "_GstGLMemory-_padding", offsetof( struct _GstGLMemory, _padding ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "_GstGLMemory-tex_format", offsetof( struct _GstGLMemory, tex_format ), sizeof( GstGLFormat ) );
	swigStructField( "_GstGLMemory-info", offsetof( struct _GstGLMemory, info ), sizeof( GstVideoInfo ) );
	swigStructField( "_GstGLMemory-texture_wrapped", offsetof( struct _GstGLMemory, texture_wrapped ), sizeof( gboolean ) );
	swigStructField( "_GstGLMemory-tex_width", offsetof( struct _GstGLMemory, tex_width ), sizeof( guint ) );
	swigStructField( "_GstGLMemory-valign", offsetof( struct _GstGLMemory, valign ), sizeof( GstVideoAlignment ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstGLMemory ) );

	swigComment("_GstGLVideoAllocationParams\n");
	printf( "begin-structure _GstGLVideoAllocationParams\n" );
	swigStructField( "_GstGLVideoAllocationParams-v_info", offsetof( struct _GstGLVideoAllocationParams, v_info ), sizeof( GstVideoInfo * ) );
	swigStructField( "_GstGLVideoAllocationParams-target", offsetof( struct _GstGLVideoAllocationParams, target ), sizeof( GstGLTextureTarget ) );
	swigStructField( "_GstGLVideoAllocationParams-plane", offsetof( struct _GstGLVideoAllocationParams, plane ), sizeof( guint ) );
	swigStructField( "_GstGLVideoAllocationParams-_padding", offsetof( struct _GstGLVideoAllocationParams, _padding ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "_GstGLVideoAllocationParams-tex_format", offsetof( struct _GstGLVideoAllocationParams, tex_format ), sizeof( GstGLFormat ) );
	swigStructField( "_GstGLVideoAllocationParams-parent", offsetof( struct _GstGLVideoAllocationParams, parent ), sizeof( GstGLAllocationParams ) );
	swigStructField( "_GstGLVideoAllocationParams-valign", offsetof( struct _GstGLVideoAllocationParams, valign ), sizeof( GstVideoAlignment * ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstGLVideoAllocationParams ) );

	swigComment("_GstGLMemoryAllocator\n");
	printf( "begin-structure _GstGLMemoryAllocator\n" );
	swigStructField( "_GstGLMemoryAllocator-_padding", offsetof( struct _GstGLMemoryAllocator, _padding ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "_GstGLMemoryAllocator-parent", offsetof( struct _GstGLMemoryAllocator, parent ), sizeof( GstGLBaseMemoryAllocator ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstGLMemoryAllocator ) );

	swigComment("_GstGLMemoryAllocatorClass\n");
	printf( "begin-structure _GstGLMemoryAllocatorClass\n" );
	swigStructField( "_GstGLMemoryAllocatorClass-copy", offsetof( struct _GstGLMemoryAllocatorClass, copy ), sizeof( GstGLBaseMemoryAllocatorCopyFunction ) );
	swigStructField( "_GstGLMemoryAllocatorClass-unmap", offsetof( struct _GstGLMemoryAllocatorClass, unmap ), sizeof( GstGLBaseMemoryAllocatorUnmapFunction ) );
	swigStructField( "_GstGLMemoryAllocatorClass-_padding", offsetof( struct _GstGLMemoryAllocatorClass, _padding ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "_GstGLMemoryAllocatorClass-map", offsetof( struct _GstGLMemoryAllocatorClass, map ), sizeof( GstGLBaseMemoryAllocatorMapFunction ) );
	swigStructField( "_GstGLMemoryAllocatorClass-parent_class", offsetof( struct _GstGLMemoryAllocatorClass, parent_class ), sizeof( GstGLBaseMemoryAllocatorClass ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstGLMemoryAllocatorClass ) );

	swigComment("_GstGLBufferPool\n");
	printf( "begin-structure _GstGLBufferPool\n" );
	swigStructField( "_GstGLBufferPool-bufferpool", offsetof( struct _GstGLBufferPool, bufferpool ), sizeof( GstBufferPool ) );
	swigStructField( "_GstGLBufferPool-priv", offsetof( struct _GstGLBufferPool, priv ), sizeof( GstGLBufferPoolPrivate * ) );
	swigStructField( "_GstGLBufferPool-_padding", offsetof( struct _GstGLBufferPool, _padding ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "_GstGLBufferPool-context", offsetof( struct _GstGLBufferPool, context ), sizeof( GstGLContext * ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstGLBufferPool ) );

	swigComment("_GstGLBufferPoolClass\n");
	printf( "begin-structure _GstGLBufferPoolClass\n" );
	swigStructField( "_GstGLBufferPoolClass-_padding", offsetof( struct _GstGLBufferPoolClass, _padding ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "_GstGLBufferPoolClass-parent_class", offsetof( struct _GstGLBufferPoolClass, parent_class ), sizeof( GstBufferPoolClass ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstGLBufferPoolClass ) );

	swigComment("_GstGLFramebuffer\n");
	printf( "begin-structure _GstGLFramebuffer\n" );
	swigStructField( "_GstGLFramebuffer-fbo_id", offsetof( struct _GstGLFramebuffer, fbo_id ), sizeof( guint ) );
	swigStructField( "_GstGLFramebuffer-attachments", offsetof( struct _GstGLFramebuffer, attachments ), sizeof( GArray * ) );
	swigStructField( "_GstGLFramebuffer-_padding", offsetof( struct _GstGLFramebuffer, _padding ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "_GstGLFramebuffer-priv", offsetof( struct _GstGLFramebuffer, priv ), sizeof( GstGLFramebufferPrivate * ) );
	swigStructField( "_GstGLFramebuffer-object", offsetof( struct _GstGLFramebuffer, object ), sizeof( GstObject ) );
	swigStructField( "_GstGLFramebuffer-context", offsetof( struct _GstGLFramebuffer, context ), sizeof( GstGLContext * ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstGLFramebuffer ) );

	swigComment("_GstGLFramebufferClass\n");
	printf( "begin-structure _GstGLFramebufferClass\n" );
	swigStructField( "_GstGLFramebufferClass-_padding", offsetof( struct _GstGLFramebufferClass, _padding ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "_GstGLFramebufferClass-object_class", offsetof( struct _GstGLFramebufferClass, object_class ), sizeof( GstObjectClass ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstGLFramebufferClass ) );

	swigComment("_GstGLFilter\n");
	printf( "begin-structure _GstGLFilter\n" );
	swigStructField( "_GstGLFilter-fbo", offsetof( struct _GstGLFilter, fbo ), sizeof( GstGLFramebuffer * ) );
	swigStructField( "_GstGLFilter-in_info", offsetof( struct _GstGLFilter, in_info ), sizeof( GstVideoInfo ) );
	swigStructField( "_GstGLFilter-valid_attributes", offsetof( struct _GstGLFilter, valid_attributes ), sizeof( gboolean ) );
	swigStructField( "_GstGLFilter-out_texture_target", offsetof( struct _GstGLFilter, out_texture_target ), sizeof( GstGLTextureTarget ) );
	swigStructField( "_GstGLFilter-in_texture_target", offsetof( struct _GstGLFilter, in_texture_target ), sizeof( GstGLTextureTarget ) );
	swigStructField( "_GstGLFilter-vertex_buffer", offsetof( struct _GstGLFilter, vertex_buffer ), sizeof( guint ) );
	swigStructField( "_GstGLFilter-outbuf", offsetof( struct _GstGLFilter, outbuf ), sizeof( GstBuffer * ) );
	swigStructField( "_GstGLFilter-inbuf", offsetof( struct _GstGLFilter, inbuf ), sizeof( GstBuffer * ) );
	swigStructField( "_GstGLFilter-vbo_indices", offsetof( struct _GstGLFilter, vbo_indices ), sizeof( guint ) );
	swigStructField( "_GstGLFilter-out_caps", offsetof( struct _GstGLFilter, out_caps ), sizeof( GstCaps * ) );
	swigStructField( "_GstGLFilter-draw_attr_texture_loc", offsetof( struct _GstGLFilter, draw_attr_texture_loc ), sizeof( gint ) );
	swigStructField( "_GstGLFilter-gl_result", offsetof( struct _GstGLFilter, gl_result ), sizeof( gboolean ) );
	swigStructField( "_GstGLFilter-out_info", offsetof( struct _GstGLFilter, out_info ), sizeof( GstVideoInfo ) );
	swigStructField( "_GstGLFilter-draw_attr_position_loc", offsetof( struct _GstGLFilter, draw_attr_position_loc ), sizeof( gint ) );
	swigStructField( "_GstGLFilter-_padding", offsetof( struct _GstGLFilter, _padding ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "_GstGLFilter-default_shader", offsetof( struct _GstGLFilter, default_shader ), sizeof( GstGLShader * ) );
	swigStructField( "_GstGLFilter-vao", offsetof( struct _GstGLFilter, vao ), sizeof( guint ) );
	swigStructField( "_GstGLFilter-parent", offsetof( struct _GstGLFilter, parent ), sizeof( GstGLBaseFilter ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstGLFilter ) );

	swigComment("_GstGLFilterClass\n");
	printf( "begin-structure _GstGLFilterClass\n" );
	swigStructField( "_GstGLFilterClass-transform_internal_caps", offsetof( struct _GstGLFilterClass, transform_internal_caps ), sizeof( GstCaps *(*)(GstGLFilter *,GstPadDirection,GstCaps *,GstCaps *) ) );
	swigStructField( "_GstGLFilterClass-set_caps", offsetof( struct _GstGLFilterClass, set_caps ), sizeof( gboolean (*)(GstGLFilter *,GstCaps *,GstCaps *) ) );
	swigStructField( "_GstGLFilterClass-filter", offsetof( struct _GstGLFilterClass, filter ), sizeof( gboolean (*)(GstGLFilter *,GstBuffer *,GstBuffer *) ) );
	swigStructField( "_GstGLFilterClass-_padding", offsetof( struct _GstGLFilterClass, _padding ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "_GstGLFilterClass-init_fbo", offsetof( struct _GstGLFilterClass, init_fbo ), sizeof( gboolean (*)(GstGLFilter *) ) );
	swigStructField( "_GstGLFilterClass-parent_class", offsetof( struct _GstGLFilterClass, parent_class ), sizeof( GstGLBaseFilterClass ) );
	swigStructField( "_GstGLFilterClass-filter_texture", offsetof( struct _GstGLFilterClass, filter_texture ), sizeof( gboolean (*)(GstGLFilter *,GstGLMemory *,GstGLMemory *) ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstGLFilterClass ) );

	swigComment("_GstGLSyncMeta\n");
	printf( "begin-structure _GstGLSyncMeta\n" );
	swigStructField( "_GstGLSyncMeta-set_sync", offsetof( struct _GstGLSyncMeta, set_sync ), sizeof( void (*)(GstGLSyncMeta *,GstGLContext *) ) );
	swigStructField( "_GstGLSyncMeta-wait_cpu_gl", offsetof( struct _GstGLSyncMeta, wait_cpu_gl ), sizeof( void (*)(GstGLSyncMeta *,GstGLContext *) ) );
	swigStructField( "_GstGLSyncMeta-data", offsetof( struct _GstGLSyncMeta, data ), sizeof( gpointer ) );
	swigStructField( "_GstGLSyncMeta-copy", offsetof( struct _GstGLSyncMeta, copy ), sizeof( void (*)(GstGLSyncMeta *,GstBuffer *,GstGLSyncMeta *,GstBuffer *) ) );
	swigStructField( "_GstGLSyncMeta-wait", offsetof( struct _GstGLSyncMeta, wait ), sizeof( void (*)(GstGLSyncMeta *,GstGLContext *) ) );
	swigStructField( "_GstGLSyncMeta-wait_gl", offsetof( struct _GstGLSyncMeta, wait_gl ), sizeof( void (*)(GstGLSyncMeta *,GstGLContext *) ) );
	swigStructField( "_GstGLSyncMeta-free", offsetof( struct _GstGLSyncMeta, free ), sizeof( void (*)(GstGLSyncMeta *,GstGLContext *) ) );
	swigStructField( "_GstGLSyncMeta-wait_cpu", offsetof( struct _GstGLSyncMeta, wait_cpu ), sizeof( void (*)(GstGLSyncMeta *,GstGLContext *) ) );
	swigStructField( "_GstGLSyncMeta-set_sync_gl", offsetof( struct _GstGLSyncMeta, set_sync_gl ), sizeof( void (*)(GstGLSyncMeta *,GstGLContext *) ) );
	swigStructField( "_GstGLSyncMeta-parent", offsetof( struct _GstGLSyncMeta, parent ), sizeof( GstMeta ) );
	swigStructField( "_GstGLSyncMeta-context", offsetof( struct _GstGLSyncMeta, context ), sizeof( GstGLContext * ) );
	swigStructField( "_GstGLSyncMeta-free_gl", offsetof( struct _GstGLSyncMeta, free_gl ), sizeof( void (*)(GstGLSyncMeta *,GstGLContext *) ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstGLSyncMeta ) );

	swigComment("_GstGLDisplayEGL\n");
	printf( "begin-structure _GstGLDisplayEGL\n" );
	swigStructField( "_GstGLDisplayEGL-display", offsetof( struct _GstGLDisplayEGL, display ), sizeof( gpointer ) );
	swigStructField( "_GstGLDisplayEGL-foreign_display", offsetof( struct _GstGLDisplayEGL, foreign_display ), sizeof( gboolean ) );
	swigStructField( "_GstGLDisplayEGL-_padding", offsetof( struct _GstGLDisplayEGL, _padding ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "_GstGLDisplayEGL-parent", offsetof( struct _GstGLDisplayEGL, parent ), sizeof( GstGLDisplay ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstGLDisplayEGL ) );

	swigComment("_GstGLDisplayEGLClass\n");
	printf( "begin-structure _GstGLDisplayEGLClass\n" );
	swigStructField( "_GstGLDisplayEGLClass-_padding", offsetof( struct _GstGLDisplayEGLClass, _padding ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "_GstGLDisplayEGLClass-object_class", offsetof( struct _GstGLDisplayEGLClass, object_class ), sizeof( GstGLDisplayClass ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstGLDisplayEGLClass ) );

	swigComment("_GstGLDisplayX11\n");
	printf( "begin-structure _GstGLDisplayX11\n" );
	swigStructField( "_GstGLDisplayX11-display", offsetof( struct _GstGLDisplayX11, display ), sizeof( Display * ) );
	swigStructField( "_GstGLDisplayX11-foreign_display", offsetof( struct _GstGLDisplayX11, foreign_display ), sizeof( gboolean ) );
	swigStructField( "_GstGLDisplayX11-name", offsetof( struct _GstGLDisplayX11, name ), sizeof( char * ) );
	swigStructField( "_GstGLDisplayX11-_padding", offsetof( struct _GstGLDisplayX11, _padding ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "_GstGLDisplayX11-parent", offsetof( struct _GstGLDisplayX11, parent ), sizeof( GstGLDisplay ) );
	swigStructField( "_GstGLDisplayX11-xcb_connection", offsetof( struct _GstGLDisplayX11, xcb_connection ), sizeof( xcb_connection_t * ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstGLDisplayX11 ) );

	swigComment("_GstGLDisplayX11Class\n");
	printf( "begin-structure _GstGLDisplayX11Class\n" );
	swigStructField( "_GstGLDisplayX11Class-_padding", offsetof( struct _GstGLDisplayX11Class, _padding ), sizeof( gpointer [GST_PADDING] ) );
	swigStructField( "_GstGLDisplayX11Class-object_class", offsetof( struct _GstGLDisplayX11Class, object_class ), sizeof( GstGLDisplayClass ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GstGLDisplayX11Class ) );

	swigNewline();

	swigComment("--===< function pointers >===---\n");
	swigFunctionPointer( "c-funptr _GstBinClass-element_added() {((struct _GstBinClass*)ptr)->element_added} a a -- void", "", "", "	( bin child -- )" );
	swigFunctionPointer( "c-funptr _GstBinClass-element_removed() {((struct _GstBinClass*)ptr)->element_removed} a a -- void", "", "", "	( bin child -- )" );
	swigFunctionPointer( "c-funptr _GstBinClass-add_element() {((struct _GstBinClass*)ptr)->add_element} a a -- n", "", "", "	( bin element -- )" );
	swigFunctionPointer( "c-funptr _GstBinClass-remove_element() {((struct _GstBinClass*)ptr)->remove_element} a a -- n", "", "", "	( bin element -- )" );
	swigFunctionPointer( "c-funptr _GstBinClass-handle_message() {((struct _GstBinClass*)ptr)->handle_message} a a -- void", "", "", "	( bin message -- )" );
	swigFunctionPointer( "c-funptr _GstBinClass-do_latency() {((struct _GstBinClass*)ptr)->do_latency} a -- n", "", "", "	( bin -- )" );
	swigFunctionPointer( "c-funptr _GstBinClass-deep_element_added() {((struct _GstBinClass*)ptr)->deep_element_added} a a a -- void", "", "", "	( bin sub_bin child -- )" );
	swigFunctionPointer( "c-funptr _GstBinClass-deep_element_removed() {((struct _GstBinClass*)ptr)->deep_element_removed} a a a -- void", "", "", "	( bin sub_bin child -- )" );
	swigFunctionPointer( "c-funptr _GstBufferPoolClass-get_options() {((struct _GstBufferPoolClass*)ptr)->get_options} a -- a", "", "", "	( pool -- )" );
	swigFunctionPointer( "c-funptr _GstBufferPoolClass-set_config() {((struct _GstBufferPoolClass*)ptr)->set_config} a a -- n", "", "", "	( pool config -- )" );
	swigFunctionPointer( "c-funptr _GstBufferPoolClass-start() {((struct _GstBufferPoolClass*)ptr)->start} a -- n", "", "", "	( pool -- )" );
	swigFunctionPointer( "c-funptr _GstBufferPoolClass-stop() {((struct _GstBufferPoolClass*)ptr)->stop} a -- n", "", "", "	( pool -- )" );
	swigFunctionPointer( "c-funptr _GstBufferPoolClass-acquire_buffer() {((struct _GstBufferPoolClass*)ptr)->acquire_buffer} a a a -- n", "", "", "	( pool buffer params -- )" );
	swigFunctionPointer( "c-funptr _GstBufferPoolClass-alloc_buffer() {((struct _GstBufferPoolClass*)ptr)->alloc_buffer} a a a -- n", "", "", "	( pool buffer params -- )" );
	swigFunctionPointer( "c-funptr _GstBufferPoolClass-reset_buffer() {((struct _GstBufferPoolClass*)ptr)->reset_buffer} a a -- void", "", "", "	( pool buffer -- )" );
	swigFunctionPointer( "c-funptr _GstBufferPoolClass-release_buffer() {((struct _GstBufferPoolClass*)ptr)->release_buffer} a a -- void", "", "", "	( pool buffer -- )" );
	swigFunctionPointer( "c-funptr _GstBufferPoolClass-free_buffer() {((struct _GstBufferPoolClass*)ptr)->free_buffer} a a -- void", "", "", "	( pool buffer -- )" );
	swigFunctionPointer( "c-funptr _GstBufferPoolClass-flush_start() {((struct _GstBufferPoolClass*)ptr)->flush_start} a -- void", "", "", "	( pool -- )" );
	swigFunctionPointer( "c-funptr _GstBufferPoolClass-flush_stop() {((struct _GstBufferPoolClass*)ptr)->flush_stop} a -- void", "", "", "	( pool -- )" );
	swigFunctionPointer( "c-funptr _GstBusClass-message() {((struct _GstBusClass*)ptr)->message} a a -- void", "", "", "	( bus message -- )" );
	swigFunctionPointer( "c-funptr _GstBusClass-sync_message() {((struct _GstBusClass*)ptr)->sync_message} a a -- void", "", "", "	( bus message -- )" );
	swigFunctionPointer( "c-funptr _GstChildProxyInterface-get_child_by_name() {((struct _GstChildProxyInterface*)ptr)->get_child_by_name} a s -- a", "", "", "	( parent name -- )" );
	swigFunctionPointer( "c-funptr _GstChildProxyInterface-get_child_by_index() {((struct _GstChildProxyInterface*)ptr)->get_child_by_index} a u -- a", "", "", "	( parent index -- )" );
	swigFunctionPointer( "c-funptr _GstChildProxyInterface-get_children_count() {((struct _GstChildProxyInterface*)ptr)->get_children_count} a -- u", "", "", "	( parent -- )" );
	swigFunctionPointer( "c-funptr _GstChildProxyInterface-child_added() {((struct _GstChildProxyInterface*)ptr)->child_added} a a s -- void", "", "", "	( parent child name -- )" );
	swigFunctionPointer( "c-funptr _GstChildProxyInterface-child_removed() {((struct _GstChildProxyInterface*)ptr)->child_removed} a a s -- void", "", "", "	( parent child name -- )" );
	swigFunctionPointer( "c-funptr _GstClockClass-change_resolution() {((struct _GstClockClass*)ptr)->change_resolution} a ud ud -- ud", "", "", "	( clock old_resolution new_resolution -- )" );
	swigFunctionPointer( "c-funptr _GstClockClass-get_resolution() {((struct _GstClockClass*)ptr)->get_resolution} a -- ud", "", "", "	( clock -- )" );
	swigFunctionPointer( "c-funptr _GstClockClass-get_internal_time() {((struct _GstClockClass*)ptr)->get_internal_time} a -- ud", "", "", "	( clock -- )" );
	swigFunctionPointer( "c-funptr _GstClockClass-wait() {((struct _GstClockClass*)ptr)->wait} a a a -- n", "", "", "	( clock entry jitter -- )" );
	swigFunctionPointer( "c-funptr _GstClockClass-wait_async() {((struct _GstClockClass*)ptr)->wait_async} a a -- n", "", "", "	( clock entry -- )" );
	swigFunctionPointer( "c-funptr _GstClockClass-unschedule() {((struct _GstClockClass*)ptr)->unschedule} a a -- void", "", "", "	( clock entry -- )" );
	swigFunctionPointer( "c-funptr _GstDeviceClass-create_element() {((struct _GstDeviceClass*)ptr)->create_element} a s -- a", "", "", "	( device name -- )" );
	swigFunctionPointer( "c-funptr _GstDeviceClass-reconfigure_element() {((struct _GstDeviceClass*)ptr)->reconfigure_element} a a -- n", "", "", "	( device element -- )" );
	swigFunctionPointer( "c-funptr _GstDeviceProviderClass-probe() {((struct _GstDeviceProviderClass*)ptr)->probe} a -- a", "", "", "	( provider -- )" );
	swigFunctionPointer( "c-funptr _GstDeviceProviderClass-start() {((struct _GstDeviceProviderClass*)ptr)->start} a -- n", "", "", "	( provider -- )" );
	swigFunctionPointer( "c-funptr _GstDeviceProviderClass-stop() {((struct _GstDeviceProviderClass*)ptr)->stop} a -- void", "", "", "	( provider -- )" );
	swigFunctionPointer( "c-funptr _GstElementClass-pad_added() {((struct _GstElementClass*)ptr)->pad_added} a a -- void", "", "", "	( element pad -- )" );
	swigFunctionPointer( "c-funptr _GstElementClass-pad_removed() {((struct _GstElementClass*)ptr)->pad_removed} a a -- void", "", "", "	( element pad -- )" );
	swigFunctionPointer( "c-funptr _GstElementClass-no_more_pads() {((struct _GstElementClass*)ptr)->no_more_pads} a -- void", "", "", "	( element -- )" );
	swigFunctionPointer( "c-funptr _GstElementClass-request_new_pad() {((struct _GstElementClass*)ptr)->request_new_pad} a a s a -- a", "", "", "	( element templ name caps -- )" );
	swigFunctionPointer( "c-funptr _GstElementClass-release_pad() {((struct _GstElementClass*)ptr)->release_pad} a a -- void", "", "", "	( element pad -- )" );
	swigFunctionPointer( "c-funptr _GstElementClass-get_state() {((struct _GstElementClass*)ptr)->get_state} a a a ud -- n", "", "", "	( element state pending timeout -- )" );
	swigFunctionPointer( "c-funptr _GstElementClass-set_state() {((struct _GstElementClass*)ptr)->set_state} a n -- n", "", "", "	( element state -- )" );
	swigFunctionPointer( "c-funptr _GstElementClass-change_state() {((struct _GstElementClass*)ptr)->change_state} a n -- n", "", "", "	( element transition -- )" );
	swigFunctionPointer( "c-funptr _GstElementClass-state_changed() {((struct _GstElementClass*)ptr)->state_changed} a n n n -- void", "", "", "	( element oldstate newstate pending -- )" );
	swigFunctionPointer( "c-funptr _GstElementClass-set_bus() {((struct _GstElementClass*)ptr)->set_bus} a a -- void", "", "", "	( element bus -- )" );
	swigFunctionPointer( "c-funptr _GstElementClass-provide_clock() {((struct _GstElementClass*)ptr)->provide_clock} a -- a", "", "", "	( element -- )" );
	swigFunctionPointer( "c-funptr _GstElementClass-set_clock() {((struct _GstElementClass*)ptr)->set_clock} a a -- n", "", "", "	( element clock -- )" );
	swigFunctionPointer( "c-funptr _GstElementClass-send_event() {((struct _GstElementClass*)ptr)->send_event} a a -- n", "", "", "	( element event -- )" );
	swigFunctionPointer( "c-funptr _GstElementClass-query() {((struct _GstElementClass*)ptr)->query} a a -- n", "", "", "	( element query -- )" );
	swigFunctionPointer( "c-funptr _GstElementClass-post_message() {((struct _GstElementClass*)ptr)->post_message} a a -- n", "", "", "	( element message -- )" );
	swigFunctionPointer( "c-funptr _GstElementClass-set_context() {((struct _GstElementClass*)ptr)->set_context} a a -- void", "", "", "	( element context -- )" );
	swigFunctionPointer( "c-funptr _GstObjectClass-deep_notify() {((struct _GstObjectClass*)ptr)->deep_notify} a a a -- void", "", "", "	( object orig pspec -- )" );
	swigFunctionPointer( "c-funptr _GstPadClass-linked() {((struct _GstPadClass*)ptr)->linked} a a -- void", "", "", "	( pad peer -- )" );
	swigFunctionPointer( "c-funptr _GstPadClass-unlinked() {((struct _GstPadClass*)ptr)->unlinked} a a -- void", "", "", "	( pad peer -- )" );
	swigFunctionPointer( "c-funptr _GstPresetInterface-get_preset_names() {((struct _GstPresetInterface*)ptr)->get_preset_names} a -- a", "", "", "	( preset -- )" );
	swigFunctionPointer( "c-funptr _GstPresetInterface-get_property_names() {((struct _GstPresetInterface*)ptr)->get_property_names} a -- a", "", "", "	( preset -- )" );
	swigFunctionPointer( "c-funptr _GstPresetInterface-load_preset() {((struct _GstPresetInterface*)ptr)->load_preset} a s -- n", "", "", "	( preset name -- )" );
	swigFunctionPointer( "c-funptr _GstPresetInterface-save_preset() {((struct _GstPresetInterface*)ptr)->save_preset} a s -- n", "", "", "	( preset name -- )" );
	swigFunctionPointer( "c-funptr _GstPresetInterface-rename_preset() {((struct _GstPresetInterface*)ptr)->rename_preset} a s s -- n", "", "", "	( preset old_name new_name -- )" );
	swigFunctionPointer( "c-funptr _GstPresetInterface-delete_preset() {((struct _GstPresetInterface*)ptr)->delete_preset} a s -- n", "", "", "	( preset name -- )" );
	swigFunctionPointer( "c-funptr _GstPresetInterface-set_meta() {((struct _GstPresetInterface*)ptr)->set_meta} a s s s -- n", "", "", "	( preset name tag value -- )" );
	swigFunctionPointer( "c-funptr _GstPresetInterface-get_meta() {((struct _GstPresetInterface*)ptr)->get_meta} a s s a -- n", "", "", "	( preset name tag value -- )" );
	swigFunctionPointer( "c-funptr _GstTaskPoolClass-prepare() {((struct _GstTaskPoolClass*)ptr)->prepare} a a -- void", "", "", "	( pool error -- )" );
	swigFunctionPointer( "c-funptr _GstTaskPoolClass-cleanup() {((struct _GstTaskPoolClass*)ptr)->cleanup} a -- void", "", "", "	( pool -- )" );
	swigFunctionPointer( "c-funptr _GstTaskPoolClass-push() {((struct _GstTaskPoolClass*)ptr)->push} a a a a -- a", "", "", "	( pool func user_data error -- )" );
	swigFunctionPointer( "c-funptr _GstTaskPoolClass-join() {((struct _GstTaskPoolClass*)ptr)->join} a a -- void", "", "", "	( pool id -- )" );
	swigFunctionPointer( "c-funptr _GstTypeFind-peek() {((struct _GstTypeFind*)ptr)->peek} a d u -- a", "", "", "	( data offset size -- )" );
	swigFunctionPointer( "c-funptr _GstTypeFind-suggest() {((struct _GstTypeFind*)ptr)->suggest} a u a -- void", "", "", "	( data probability caps -- )" );
	swigFunctionPointer( "c-funptr _GstTypeFind-get_length() {((struct _GstTypeFind*)ptr)->get_length} a -- ud", "", "", "	( data -- )" );
	swigFunctionPointer( "c-funptr _GstURIHandlerInterface-get_type() {((struct _GstURIHandlerInterface*)ptr)->get_type} u -- n", "", "", "	( type -- )" );
	swigFunctionPointer( "c-funptr _GstURIHandlerInterface-get_protocols() {((struct _GstURIHandlerInterface*)ptr)->get_protocols} u -- a", "", "", "	( type -- )" );
	swigFunctionPointer( "c-funptr _GstURIHandlerInterface-get_uri() {((struct _GstURIHandlerInterface*)ptr)->get_uri} a -- a", "", "", "	( handler -- )" );
	swigFunctionPointer( "c-funptr _GstURIHandlerInterface-set_uri() {((struct _GstURIHandlerInterface*)ptr)->set_uri} a s a -- n", "", "", "	( handler uri error -- )" );
	swigFunctionPointer( "c-funptr _GstGLDisplayClass-get_handle() {((struct _GstGLDisplayClass*)ptr)->get_handle} a -- u", "", "", "	( display -- )" );
	swigFunctionPointer( "c-funptr _GstGLDisplayClass-create_window() {((struct _GstGLDisplayClass*)ptr)->create_window} a -- a", "", "", "	( display -- )" );
	swigFunctionPointer( "c-funptr _GstGLContextClass-get_current_context() {((struct _GstGLContextClass*)ptr)->get_current_context}  -- u", "", "", "	( <noname> -- )" );
	swigFunctionPointer( "c-funptr _GstGLContextClass-get_gl_context() {((struct _GstGLContextClass*)ptr)->get_gl_context} a -- u", "", "", "	( context -- )" );
	swigFunctionPointer( "c-funptr _GstGLContextClass-get_gl_api() {((struct _GstGLContextClass*)ptr)->get_gl_api} a -- n", "", "", "	( context -- )" );
	swigFunctionPointer( "c-funptr _GstGLContextClass-get_gl_platform() {((struct _GstGLContextClass*)ptr)->get_gl_platform} a -- n", "", "", "	( context -- )" );
	swigFunctionPointer( "c-funptr _GstGLContextClass-get_proc_address() {((struct _GstGLContextClass*)ptr)->get_proc_address} n s -- a", "", "", "	( gl_api name -- )" );
	swigFunctionPointer( "c-funptr _GstGLContextClass-activate() {((struct _GstGLContextClass*)ptr)->activate} a n -- n", "", "", "	( context activate -- )" );
	swigFunctionPointer( "c-funptr _GstGLContextClass-choose_format() {((struct _GstGLContextClass*)ptr)->choose_format} a a -- n", "", "", "	( context error -- )" );
	swigFunctionPointer( "c-funptr _GstGLContextClass-create_context() {((struct _GstGLContextClass*)ptr)->create_context} a n a a -- n", "", "", "	( context gl_api other_context error -- )" );
	swigFunctionPointer( "c-funptr _GstGLContextClass-destroy_context() {((struct _GstGLContextClass*)ptr)->destroy_context} a -- void", "", "", "	( context -- )" );
	swigFunctionPointer( "c-funptr _GstGLContextClass-swap_buffers() {((struct _GstGLContextClass*)ptr)->swap_buffers} a -- void", "", "", "	( context -- )" );
	swigFunctionPointer( "c-funptr _GstGLContextClass-check_feature() {((struct _GstGLContextClass*)ptr)->check_feature} a s -- n", "", "", "	( context feature -- )" );
	swigFunctionPointer( "c-funptr _GstGLContextClass-get_gl_platform_version() {((struct _GstGLContextClass*)ptr)->get_gl_platform_version} a a a -- void", "", "", "	( context major minor -- )" );
	swigFunctionPointer( "c-funptr _GstGLWindowClass-get_display() {((struct _GstGLWindowClass*)ptr)->get_display} a -- u", "", "", "	( window -- )" );
	swigFunctionPointer( "c-funptr _GstGLWindowClass-set_window_handle() {((struct _GstGLWindowClass*)ptr)->set_window_handle} a u -- void", "", "", "	( window handle -- )" );
	swigFunctionPointer( "c-funptr _GstGLWindowClass-get_window_handle() {((struct _GstGLWindowClass*)ptr)->get_window_handle} a -- u", "", "", "	( window -- )" );
	swigFunctionPointer( "c-funptr _GstGLWindowClass-draw() {((struct _GstGLWindowClass*)ptr)->draw} a -- void", "", "", "	( window -- )" );
	swigFunctionPointer( "c-funptr _GstGLWindowClass-run() {((struct _GstGLWindowClass*)ptr)->run} a -- void", "", "", "	( window -- )" );
	swigFunctionPointer( "c-funptr _GstGLWindowClass-quit() {((struct _GstGLWindowClass*)ptr)->quit} a -- void", "", "", "	( window -- )" );
	swigFunctionPointer( "c-funptr _GstGLWindowClass-send_message() {((struct _GstGLWindowClass*)ptr)->send_message} a a a -- void", "", "", "	( window callback data -- )" );
	swigFunctionPointer( "c-funptr _GstGLWindowClass-send_message_async() {((struct _GstGLWindowClass*)ptr)->send_message_async} a a a a -- void", "", "", "	( window callback data destroy -- )" );
	swigFunctionPointer( "c-funptr _GstGLWindowClass-open() {((struct _GstGLWindowClass*)ptr)->open} a a -- n", "", "", "	( window error -- )" );
	swigFunctionPointer( "c-funptr _GstGLWindowClass-close() {((struct _GstGLWindowClass*)ptr)->close} a -- void", "", "", "	( window -- )" );
	swigFunctionPointer( "c-funptr _GstGLWindowClass-handle_events() {((struct _GstGLWindowClass*)ptr)->handle_events} a n -- void", "", "", "	( window handle_events -- )" );
	swigFunctionPointer( "c-funptr _GstGLWindowClass-set_preferred_size() {((struct _GstGLWindowClass*)ptr)->set_preferred_size} a n n -- void", "", "", "	( window width height -- )" );
	swigFunctionPointer( "c-funptr _GstGLWindowClass-show() {((struct _GstGLWindowClass*)ptr)->show} a -- void", "", "", "	( window -- )" );
	swigFunctionPointer( "c-funptr _GstGLWindowClass-set_render_rectangle() {((struct _GstGLWindowClass*)ptr)->set_render_rectangle} a n n n n -- n", "", "", "	( window x y width height -- )" );
	swigFunctionPointer( "c-funptr _GstGLWindowClass-queue_resize() {((struct _GstGLWindowClass*)ptr)->queue_resize} a -- void", "", "", "	( window -- )" );
	swigFunctionPointer( "c-funptr _GstGLFilterClass-set_caps() {((struct _GstGLFilterClass*)ptr)->set_caps} a a a -- n", "", "", "	( filter incaps outcaps -- )" );
	swigFunctionPointer( "c-funptr _GstGLFilterClass-filter() {((struct _GstGLFilterClass*)ptr)->filter} a a a -- n", "", "", "	( filter inbuf outbuf -- )" );
	swigFunctionPointer( "c-funptr _GstGLFilterClass-filter_texture() {((struct _GstGLFilterClass*)ptr)->filter_texture} a a a -- n", "", "", "	( filter in_tex out_tex -- )" );
	swigFunctionPointer( "c-funptr _GstGLFilterClass-init_fbo() {((struct _GstGLFilterClass*)ptr)->init_fbo} a -- n", "", "", "	( filter -- )" );
	swigFunctionPointer( "c-funptr _GstGLFilterClass-transform_internal_caps() {((struct _GstGLFilterClass*)ptr)->transform_internal_caps} a n a a -- a", "", "", "	( filter direction caps filter_caps -- )" );
	swigFunctionPointer( "c-funptr _GstGLSyncMeta-set_sync() {((struct _GstGLSyncMeta*)ptr)->set_sync} a a -- void", "", "", "	( sync context -- )" );
	swigFunctionPointer( "c-funptr _GstGLSyncMeta-set_sync_gl() {((struct _GstGLSyncMeta*)ptr)->set_sync_gl} a a -- void", "", "", "	( sync context -- )" );
	swigFunctionPointer( "c-funptr _GstGLSyncMeta-wait() {((struct _GstGLSyncMeta*)ptr)->wait} a a -- void", "", "", "	( sync context -- )" );
	swigFunctionPointer( "c-funptr _GstGLSyncMeta-wait_gl() {((struct _GstGLSyncMeta*)ptr)->wait_gl} a a -- void", "", "", "	( sync context -- )" );
	swigFunctionPointer( "c-funptr _GstGLSyncMeta-wait_cpu() {((struct _GstGLSyncMeta*)ptr)->wait_cpu} a a -- void", "", "", "	( sync context -- )" );
	swigFunctionPointer( "c-funptr _GstGLSyncMeta-wait_cpu_gl() {((struct _GstGLSyncMeta*)ptr)->wait_cpu_gl} a a -- void", "", "", "	( sync context -- )" );
	swigFunctionPointer( "c-funptr _GstGLSyncMeta-copy() {((struct _GstGLSyncMeta*)ptr)->copy} a a a a -- void", "", "", "	( src sbuffer dest dbuffer -- )" );
	swigFunctionPointer( "c-funptr _GstGLSyncMeta-free() {((struct _GstGLSyncMeta*)ptr)->free} a a -- void", "", "", "	( sync context -- )" );
	swigFunctionPointer( "c-funptr _GstGLSyncMeta-free_gl() {((struct _GstGLSyncMeta*)ptr)->free_gl} a a -- void", "", "", "	( sync context -- )" );

	swigNewline();

	swigComment("------===< callbacks >===-------\n");
	swigCallback( "c-callback GstBufferForeachMetaFunc: a a a -- n", "", "", "	( buffer meta user_data -- )" );
	swigCallback( "c-callback GstBufferListFunc: a u a -- n", "", "", "	( buffer idx user_data -- )" );
	swigCallback( "c-callback GstBusSyncHandler: a a a -- n", "", "", "	( bus message user_data -- )" );
	swigCallback( "c-callback GstBusFunc: a a a -- n", "", "", "	( bus message user_data -- )" );
	swigCallback( "c-callback GstCapsForeachFunc: a a a -- n", "", "", "	( features structure user_data -- )" );
	swigCallback( "c-callback GstCapsMapFunc: a a a -- n", "", "", "	( features structure user_data -- )" );
	swigCallback( "c-callback GstCapsFilterMapFunc: a a a -- n", "", "", "	( features structure user_data -- )" );
	swigCallback( "c-callback GstClockCallback: a ud a a -- n", "", "", "	( clock time id user_data -- )" );
	swigCallback( "c-callback GstControlSourceGetValue: a ud a -- n", "", "", "	( self timestamp value -- )" );
	swigCallback( "c-callback GstControlSourceGetValueArray: a ud ud u a -- n", "", "", "	( self timestamp interval n_values values -- )" );
	swigCallback( "c-callback GstElementForeachPadFunc: a a a -- n", "", "", "	( element pad user_data -- )" );
	swigCallback( "c-callback GstElementCallAsyncFunc: a a -- void", "", "", "	( element user_data -- )" );
	swigCallback( "c-callback GstIteratorCopyFunction: a a -- void", "", "", "	( it copy -- )" );
	swigCallback( "c-callback GstIteratorItemFunction: a a -- n", "", "", "	( it item -- )" );
	swigCallback( "c-callback GstIteratorNextFunction: a a -- n", "", "", "	( it result -- )" );
	swigCallback( "c-callback GstIteratorResyncFunction: a -- void", "", "", "	( it -- )" );
	swigCallback( "c-callback GstIteratorFreeFunction: a -- void", "", "", "	( it -- )" );
	swigCallback( "c-callback GstIteratorForeachFunction: a a -- void", "", "", "	( item user_data -- )" );
	swigCallback( "c-callback GstIteratorFoldFunction: a a a -- n", "", "", "	( item ret user_data -- )" );
	swigCallback( "c-callback GstMemoryMapFunction: a u n -- a", "", "", "	( mem maxsize flags -- )" );
	swigCallback( "c-callback GstMemoryMapFullFunction: a a u -- a", "", "", "	( mem info maxsize -- )" );
	swigCallback( "c-callback GstMemoryUnmapFunction: a -- void", "", "", "	( mem -- )" );
	swigCallback( "c-callback GstMemoryUnmapFullFunction: a a -- void", "", "", "	( mem info -- )" );
	swigCallback( "c-callback GstMemoryCopyFunction: a n n -- a", "", "", "	( mem offset size -- )" );
	swigCallback( "c-callback GstMemoryShareFunction: a n n -- a", "", "", "	( mem offset size -- )" );
	swigCallback( "c-callback GstMemoryIsSpanFunction: a a a -- n", "", "", "	( mem1 mem2 offset -- )" );
	swigCallback( "c-callback GstMetaInitFunction: a a a -- n", "", "", "	( meta params buffer -- )" );
	swigCallback( "c-callback GstMetaFreeFunction: a a -- void", "", "", "	( meta buffer -- )" );
	swigCallback( "c-callback GstMetaTransformFunction: a a a n a -- n", "", "", "	( transbuf meta buffer type data -- )" );
	swigCallback( "c-callback GstMiniObjectCopyFunction: a -- a", "", "", "	( obj -- )" );
	swigCallback( "c-callback GstMiniObjectDisposeFunction: a -- n", "", "", "	( obj -- )" );
	swigCallback( "c-callback GstMiniObjectFreeFunction: a -- void", "", "", "	( obj -- )" );
	swigCallback( "c-callback GstMiniObjectNotify: a a -- void", "", "", "	( user_data obj -- )" );
	swigCallback( "c-callback GstPadActivateFunction: a a -- n", "", "", "	( pad parent -- )" );
	swigCallback( "c-callback GstPadActivateModeFunction: a a n n -- n", "", "", "	( pad parent mode active -- )" );
	swigCallback( "c-callback GstPadChainFunction: a a a -- n", "", "", "	( pad parent buffer -- )" );
	swigCallback( "c-callback GstPadChainListFunction: a a a -- n", "", "", "	( pad parent list -- )" );
	swigCallback( "c-callback GstPadGetRangeFunction: a a ud u a -- n", "", "", "	( pad parent offset length buffer -- )" );
	swigCallback( "c-callback GstPadEventFunction: a a a -- n", "", "", "	( pad parent event -- )" );
	swigCallback( "c-callback GstPadEventFullFunction: a a a -- n", "", "", "	( pad parent event -- )" );
	swigCallback( "c-callback GstPadIterIntLinkFunction: a a -- a", "", "", "	( pad parent -- )" );
	swigCallback( "c-callback GstPadQueryFunction: a a a -- n", "", "", "	( pad parent query -- )" );
	swigCallback( "c-callback GstPadLinkFunction: a a a -- n", "", "", "	( pad parent peer -- )" );
	swigCallback( "c-callback GstPadUnlinkFunction: a a -- void", "", "", "	( pad parent -- )" );
	swigCallback( "c-callback GstPadForwardFunction: a a -- n", "", "", "	( pad user_data -- )" );
	swigCallback( "c-callback GstPadProbeCallback: a a a -- n", "", "", "	( pad info user_data -- )" );
	swigCallback( "c-callback GstPadStickyEventsForeachFunction: a a a -- n", "", "", "	( pad event user_data -- )" );
	swigCallback( "c-callback GstPluginInitFunc: a -- n", "", "", "	( plugin -- )" );
	swigCallback( "c-callback GstPluginInitFullFunc: a a -- n", "", "", "	( plugin user_data -- )" );
	swigCallback( "c-callback GstPluginFilter: a a -- n", "", "", "	( plugin user_data -- )" );
	swigCallback( "c-callback GstStructureForeachFunc: n a a -- n", "", "", "	( field_id value user_data -- )" );
	swigCallback( "c-callback GstStructureMapFunc: n a a -- n", "", "", "	( field_id value user_data -- )" );
	swigCallback( "c-callback GstStructureFilterMapFunc: n a a -- n", "", "", "	( field_id value user_data -- )" );
	swigCallback( "c-callback GstTagForeachFunc: a s a -- void", "", "", "	( list tag user_data -- )" );
	swigCallback( "c-callback GstTagMergeFunc: a a -- void", "", "", "	( dest src -- )" );
	swigCallback( "c-callback GstTaskFunction: a -- void", "", "", "	( user_data -- )" );
	swigCallback( "c-callback GstTaskThreadFunc: a a a -- void", "", "", "	( task thread user_data -- )" );
	swigCallback( "c-callback GstTaskPoolFunction: a -- void", "", "", "	( user_data -- )" );
	swigCallback( "c-callback GstTypeFindFunction: a a -- void", "", "", "	( find user_data -- )" );
	swigCallback( "c-callback GstValueCompareFunc: a a -- n", "", "", "	( value1 value2 -- )" );
	swigCallback( "c-callback GstValueSerializeFunc: a -- a", "", "", "	( value1 -- )" );
	swigCallback( "c-callback GstValueDeserializeFunc: a s -- n", "", "", "	( dest s -- )" );
	swigCallback( "c-callback GstGLContextThreadFunc: a a -- void", "", "", "	( context data -- )" );
	swigCallback( "c-callback GstGLWindowCB: a -- void", "", "", "	( data -- )" );
	swigCallback( "c-callback GstGLWindowResizeCB: a u u -- void", "", "", "	( data width height -- )" );
	swigCallback( "c-callback GstGLFramebufferFunc: a -- n", "", "", "	( stuff -- )" );
	swigCallback( "c-callback GstGLFilterRenderFunc: a a a -- n", "", "", "	( filter in_tex user_data -- )" );

	swigNewline();

	swigComment("------===< functions >===-------\n");
	swigFunction( "c-function gst_init gst_init a a -- void", "FUNCTION: gst_init ( argc argv -- void )", "EXTERN: \"C\" void gst_init( void * argc, void * argv );", "	( argc argv -- )" );
	swigFunction( "c-function gst_init_check gst_init_check a a a -- n", "FUNCTION: gst_init_check ( argc argv err -- n )", "EXTERN: \"C\" int gst_init_check( void * argc, void * argv, void * err );", "	( argc argv err -- )" );
	swigFunction( "c-function gst_is_initialized gst_is_initialized  -- n", "FUNCTION: gst_is_initialized (  -- n )", "EXTERN: \"C\" int gst_is_initialized(  );", "	( -- )" );
	swigFunction( "c-function gst_init_get_option_group gst_init_get_option_group  -- a", "FUNCTION: gst_init_get_option_group (  -- a )", "EXTERN: \"C\" void * gst_init_get_option_group(  );", "	( -- )" );
	swigFunction( "c-function gst_deinit gst_deinit  -- void", "FUNCTION: gst_deinit (  -- void )", "EXTERN: \"C\" void gst_deinit(  );", "	( -- )" );
	swigFunction( "c-function gst_version gst_version a a a a -- void", "FUNCTION: gst_version ( major minor micro nano -- void )", "EXTERN: \"C\" void gst_version( void * major, void * minor, void * micro, void * nano );", "	( major minor micro nano -- )" );
	swigFunction( "c-function gst_version_string gst_version_string  -- a", "FUNCTION: gst_version_string (  -- a )", "EXTERN: \"C\" void * gst_version_string(  );", "	( -- )" );
	swigFunction( "c-function gst_segtrap_is_enabled gst_segtrap_is_enabled  -- n", "FUNCTION: gst_segtrap_is_enabled (  -- n )", "EXTERN: \"C\" int gst_segtrap_is_enabled(  );", "	( -- )" );
	swigFunction( "c-function gst_segtrap_set_enabled gst_segtrap_set_enabled n -- void", "FUNCTION: gst_segtrap_set_enabled ( enabled -- void )", "EXTERN: \"C\" void gst_segtrap_set_enabled( int enabled );", "	( enabled -- )" );
	swigFunction( "c-function gst_registry_fork_is_enabled gst_registry_fork_is_enabled  -- n", "FUNCTION: gst_registry_fork_is_enabled (  -- n )", "EXTERN: \"C\" int gst_registry_fork_is_enabled(  );", "	( -- )" );
	swigFunction( "c-function gst_registry_fork_set_enabled gst_registry_fork_set_enabled n -- void", "FUNCTION: gst_registry_fork_set_enabled ( enabled -- void )", "EXTERN: \"C\" void gst_registry_fork_set_enabled( int enabled );", "	( enabled -- )" );
	swigFunction( "c-function gst_update_registry gst_update_registry  -- n", "FUNCTION: gst_update_registry (  -- n )", "EXTERN: \"C\" int gst_update_registry(  );", "	( -- )" );
	swigFunction( "c-function gst_get_main_executable_path gst_get_main_executable_path  -- s", "FUNCTION: gst_get_main_executable_path (  -- s )", "EXTERN: \"C\" char * gst_get_main_executable_path(  );", "	( -- )" );
	swigFunction( "c-function gst_allocator_flags_get_type gst_allocator_flags_get_type  -- u", "FUNCTION: gst_allocator_flags_get_type (  -- u )", "EXTERN: \"C\" int gst_allocator_flags_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_bin_flags_get_type gst_bin_flags_get_type  -- u", "FUNCTION: gst_bin_flags_get_type (  -- u )", "EXTERN: \"C\" int gst_bin_flags_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_buffer_flags_get_type gst_buffer_flags_get_type  -- u", "FUNCTION: gst_buffer_flags_get_type (  -- u )", "EXTERN: \"C\" int gst_buffer_flags_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_buffer_copy_flags_get_type gst_buffer_copy_flags_get_type  -- u", "FUNCTION: gst_buffer_copy_flags_get_type (  -- u )", "EXTERN: \"C\" int gst_buffer_copy_flags_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_buffer_pool_acquire_flags_get_type gst_buffer_pool_acquire_flags_get_type  -- u", "FUNCTION: gst_buffer_pool_acquire_flags_get_type (  -- u )", "EXTERN: \"C\" int gst_buffer_pool_acquire_flags_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_bus_flags_get_type gst_bus_flags_get_type  -- u", "FUNCTION: gst_bus_flags_get_type (  -- u )", "EXTERN: \"C\" int gst_bus_flags_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_bus_sync_reply_get_type gst_bus_sync_reply_get_type  -- u", "FUNCTION: gst_bus_sync_reply_get_type (  -- u )", "EXTERN: \"C\" int gst_bus_sync_reply_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_caps_flags_get_type gst_caps_flags_get_type  -- u", "FUNCTION: gst_caps_flags_get_type (  -- u )", "EXTERN: \"C\" int gst_caps_flags_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_caps_intersect_mode_get_type gst_caps_intersect_mode_get_type  -- u", "FUNCTION: gst_caps_intersect_mode_get_type (  -- u )", "EXTERN: \"C\" int gst_caps_intersect_mode_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_clock_return_get_type gst_clock_return_get_type  -- u", "FUNCTION: gst_clock_return_get_type (  -- u )", "EXTERN: \"C\" int gst_clock_return_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_clock_entry_type_get_type gst_clock_entry_type_get_type  -- u", "FUNCTION: gst_clock_entry_type_get_type (  -- u )", "EXTERN: \"C\" int gst_clock_entry_type_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_clock_flags_get_type gst_clock_flags_get_type  -- u", "FUNCTION: gst_clock_flags_get_type (  -- u )", "EXTERN: \"C\" int gst_clock_flags_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_debug_graph_details_get_type gst_debug_graph_details_get_type  -- u", "FUNCTION: gst_debug_graph_details_get_type (  -- u )", "EXTERN: \"C\" int gst_debug_graph_details_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_state_get_type gst_state_get_type  -- u", "FUNCTION: gst_state_get_type (  -- u )", "EXTERN: \"C\" int gst_state_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_state_change_return_get_type gst_state_change_return_get_type  -- u", "FUNCTION: gst_state_change_return_get_type (  -- u )", "EXTERN: \"C\" int gst_state_change_return_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_state_change_get_type gst_state_change_get_type  -- u", "FUNCTION: gst_state_change_get_type (  -- u )", "EXTERN: \"C\" int gst_state_change_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_element_flags_get_type gst_element_flags_get_type  -- u", "FUNCTION: gst_element_flags_get_type (  -- u )", "EXTERN: \"C\" int gst_element_flags_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_core_error_get_type gst_core_error_get_type  -- u", "FUNCTION: gst_core_error_get_type (  -- u )", "EXTERN: \"C\" int gst_core_error_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_library_error_get_type gst_library_error_get_type  -- u", "FUNCTION: gst_library_error_get_type (  -- u )", "EXTERN: \"C\" int gst_library_error_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_resource_error_get_type gst_resource_error_get_type  -- u", "FUNCTION: gst_resource_error_get_type (  -- u )", "EXTERN: \"C\" int gst_resource_error_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_stream_error_get_type gst_stream_error_get_type  -- u", "FUNCTION: gst_stream_error_get_type (  -- u )", "EXTERN: \"C\" int gst_stream_error_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_event_type_flags_get_type gst_event_type_flags_get_type  -- u", "FUNCTION: gst_event_type_flags_get_type (  -- u )", "EXTERN: \"C\" int gst_event_type_flags_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_event_type_get_type gst_event_type_get_type  -- u", "FUNCTION: gst_event_type_get_type (  -- u )", "EXTERN: \"C\" int gst_event_type_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_stream_flags_get_type gst_stream_flags_get_type  -- u", "FUNCTION: gst_stream_flags_get_type (  -- u )", "EXTERN: \"C\" int gst_stream_flags_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_qos_type_get_type gst_qos_type_get_type  -- u", "FUNCTION: gst_qos_type_get_type (  -- u )", "EXTERN: \"C\" int gst_qos_type_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_format_get_type gst_format_get_type  -- u", "FUNCTION: gst_format_get_type (  -- u )", "EXTERN: \"C\" int gst_format_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_debug_level_get_type gst_debug_level_get_type  -- u", "FUNCTION: gst_debug_level_get_type (  -- u )", "EXTERN: \"C\" int gst_debug_level_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_debug_color_flags_get_type gst_debug_color_flags_get_type  -- u", "FUNCTION: gst_debug_color_flags_get_type (  -- u )", "EXTERN: \"C\" int gst_debug_color_flags_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_stack_trace_flags_get_type gst_stack_trace_flags_get_type  -- u", "FUNCTION: gst_stack_trace_flags_get_type (  -- u )", "EXTERN: \"C\" int gst_stack_trace_flags_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_debug_color_mode_get_type gst_debug_color_mode_get_type  -- u", "FUNCTION: gst_debug_color_mode_get_type (  -- u )", "EXTERN: \"C\" int gst_debug_color_mode_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_iterator_result_get_type gst_iterator_result_get_type  -- u", "FUNCTION: gst_iterator_result_get_type (  -- u )", "EXTERN: \"C\" int gst_iterator_result_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_iterator_item_get_type gst_iterator_item_get_type  -- u", "FUNCTION: gst_iterator_item_get_type (  -- u )", "EXTERN: \"C\" int gst_iterator_item_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_memory_flags_get_type gst_memory_flags_get_type  -- u", "FUNCTION: gst_memory_flags_get_type (  -- u )", "EXTERN: \"C\" int gst_memory_flags_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_map_flags_get_type gst_map_flags_get_type  -- u", "FUNCTION: gst_map_flags_get_type (  -- u )", "EXTERN: \"C\" int gst_map_flags_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_message_type_get_type gst_message_type_get_type  -- u", "FUNCTION: gst_message_type_get_type (  -- u )", "EXTERN: \"C\" int gst_message_type_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_structure_change_type_get_type gst_structure_change_type_get_type  -- u", "FUNCTION: gst_structure_change_type_get_type (  -- u )", "EXTERN: \"C\" int gst_structure_change_type_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_stream_status_type_get_type gst_stream_status_type_get_type  -- u", "FUNCTION: gst_stream_status_type_get_type (  -- u )", "EXTERN: \"C\" int gst_stream_status_type_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_progress_type_get_type gst_progress_type_get_type  -- u", "FUNCTION: gst_progress_type_get_type (  -- u )", "EXTERN: \"C\" int gst_progress_type_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_meta_flags_get_type gst_meta_flags_get_type  -- u", "FUNCTION: gst_meta_flags_get_type (  -- u )", "EXTERN: \"C\" int gst_meta_flags_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_mini_object_flags_get_type gst_mini_object_flags_get_type  -- u", "FUNCTION: gst_mini_object_flags_get_type (  -- u )", "EXTERN: \"C\" int gst_mini_object_flags_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_lock_flags_get_type gst_lock_flags_get_type  -- u", "FUNCTION: gst_lock_flags_get_type (  -- u )", "EXTERN: \"C\" int gst_lock_flags_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_object_flags_get_type gst_object_flags_get_type  -- u", "FUNCTION: gst_object_flags_get_type (  -- u )", "EXTERN: \"C\" int gst_object_flags_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_pad_direction_get_type gst_pad_direction_get_type  -- u", "FUNCTION: gst_pad_direction_get_type (  -- u )", "EXTERN: \"C\" int gst_pad_direction_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_pad_mode_get_type gst_pad_mode_get_type  -- u", "FUNCTION: gst_pad_mode_get_type (  -- u )", "EXTERN: \"C\" int gst_pad_mode_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_pad_link_return_get_type gst_pad_link_return_get_type  -- u", "FUNCTION: gst_pad_link_return_get_type (  -- u )", "EXTERN: \"C\" int gst_pad_link_return_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_flow_return_get_type gst_flow_return_get_type  -- u", "FUNCTION: gst_flow_return_get_type (  -- u )", "EXTERN: \"C\" int gst_flow_return_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_pad_link_check_get_type gst_pad_link_check_get_type  -- u", "FUNCTION: gst_pad_link_check_get_type (  -- u )", "EXTERN: \"C\" int gst_pad_link_check_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_pad_probe_type_get_type gst_pad_probe_type_get_type  -- u", "FUNCTION: gst_pad_probe_type_get_type (  -- u )", "EXTERN: \"C\" int gst_pad_probe_type_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_pad_probe_return_get_type gst_pad_probe_return_get_type  -- u", "FUNCTION: gst_pad_probe_return_get_type (  -- u )", "EXTERN: \"C\" int gst_pad_probe_return_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_pad_flags_get_type gst_pad_flags_get_type  -- u", "FUNCTION: gst_pad_flags_get_type (  -- u )", "EXTERN: \"C\" int gst_pad_flags_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_pad_presence_get_type gst_pad_presence_get_type  -- u", "FUNCTION: gst_pad_presence_get_type (  -- u )", "EXTERN: \"C\" int gst_pad_presence_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_pad_template_flags_get_type gst_pad_template_flags_get_type  -- u", "FUNCTION: gst_pad_template_flags_get_type (  -- u )", "EXTERN: \"C\" int gst_pad_template_flags_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_parse_error_get_type gst_parse_error_get_type  -- u", "FUNCTION: gst_parse_error_get_type (  -- u )", "EXTERN: \"C\" int gst_parse_error_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_parse_flags_get_type gst_parse_flags_get_type  -- u", "FUNCTION: gst_parse_flags_get_type (  -- u )", "EXTERN: \"C\" int gst_parse_flags_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_pipeline_flags_get_type gst_pipeline_flags_get_type  -- u", "FUNCTION: gst_pipeline_flags_get_type (  -- u )", "EXTERN: \"C\" int gst_pipeline_flags_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_plugin_error_get_type gst_plugin_error_get_type  -- u", "FUNCTION: gst_plugin_error_get_type (  -- u )", "EXTERN: \"C\" int gst_plugin_error_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_plugin_flags_get_type gst_plugin_flags_get_type  -- u", "FUNCTION: gst_plugin_flags_get_type (  -- u )", "EXTERN: \"C\" int gst_plugin_flags_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_plugin_dependency_flags_get_type gst_plugin_dependency_flags_get_type  -- u", "FUNCTION: gst_plugin_dependency_flags_get_type (  -- u )", "EXTERN: \"C\" int gst_plugin_dependency_flags_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_rank_get_type gst_rank_get_type  -- u", "FUNCTION: gst_rank_get_type (  -- u )", "EXTERN: \"C\" int gst_rank_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_promise_result_get_type gst_promise_result_get_type  -- u", "FUNCTION: gst_promise_result_get_type (  -- u )", "EXTERN: \"C\" int gst_promise_result_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_query_type_flags_get_type gst_query_type_flags_get_type  -- u", "FUNCTION: gst_query_type_flags_get_type (  -- u )", "EXTERN: \"C\" int gst_query_type_flags_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_query_type_get_type gst_query_type_get_type  -- u", "FUNCTION: gst_query_type_get_type (  -- u )", "EXTERN: \"C\" int gst_query_type_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_buffering_mode_get_type gst_buffering_mode_get_type  -- u", "FUNCTION: gst_buffering_mode_get_type (  -- u )", "EXTERN: \"C\" int gst_buffering_mode_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_scheduling_flags_get_type gst_scheduling_flags_get_type  -- u", "FUNCTION: gst_scheduling_flags_get_type (  -- u )", "EXTERN: \"C\" int gst_scheduling_flags_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_seek_type_get_type gst_seek_type_get_type  -- u", "FUNCTION: gst_seek_type_get_type (  -- u )", "EXTERN: \"C\" int gst_seek_type_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_seek_flags_get_type gst_seek_flags_get_type  -- u", "FUNCTION: gst_seek_flags_get_type (  -- u )", "EXTERN: \"C\" int gst_seek_flags_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_segment_flags_get_type gst_segment_flags_get_type  -- u", "FUNCTION: gst_segment_flags_get_type (  -- u )", "EXTERN: \"C\" int gst_segment_flags_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_stream_type_get_type gst_stream_type_get_type  -- u", "FUNCTION: gst_stream_type_get_type (  -- u )", "EXTERN: \"C\" int gst_stream_type_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_clock_type_get_type gst_clock_type_get_type  -- u", "FUNCTION: gst_clock_type_get_type (  -- u )", "EXTERN: \"C\" int gst_clock_type_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_tag_merge_mode_get_type gst_tag_merge_mode_get_type  -- u", "FUNCTION: gst_tag_merge_mode_get_type (  -- u )", "EXTERN: \"C\" int gst_tag_merge_mode_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_tag_flag_get_type gst_tag_flag_get_type  -- u", "FUNCTION: gst_tag_flag_get_type (  -- u )", "EXTERN: \"C\" int gst_tag_flag_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_tag_scope_get_type gst_tag_scope_get_type  -- u", "FUNCTION: gst_tag_scope_get_type (  -- u )", "EXTERN: \"C\" int gst_tag_scope_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_task_state_get_type gst_task_state_get_type  -- u", "FUNCTION: gst_task_state_get_type (  -- u )", "EXTERN: \"C\" int gst_task_state_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_toc_scope_get_type gst_toc_scope_get_type  -- u", "FUNCTION: gst_toc_scope_get_type (  -- u )", "EXTERN: \"C\" int gst_toc_scope_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_toc_entry_type_get_type gst_toc_entry_type_get_type  -- u", "FUNCTION: gst_toc_entry_type_get_type (  -- u )", "EXTERN: \"C\" int gst_toc_entry_type_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_toc_loop_type_get_type gst_toc_loop_type_get_type  -- u", "FUNCTION: gst_toc_loop_type_get_type (  -- u )", "EXTERN: \"C\" int gst_toc_loop_type_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_tracer_value_scope_get_type gst_tracer_value_scope_get_type  -- u", "FUNCTION: gst_tracer_value_scope_get_type (  -- u )", "EXTERN: \"C\" int gst_tracer_value_scope_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_tracer_value_flags_get_type gst_tracer_value_flags_get_type  -- u", "FUNCTION: gst_tracer_value_flags_get_type (  -- u )", "EXTERN: \"C\" int gst_tracer_value_flags_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_type_find_probability_get_type gst_type_find_probability_get_type  -- u", "FUNCTION: gst_type_find_probability_get_type (  -- u )", "EXTERN: \"C\" int gst_type_find_probability_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_uri_error_get_type gst_uri_error_get_type  -- u", "FUNCTION: gst_uri_error_get_type (  -- u )", "EXTERN: \"C\" int gst_uri_error_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_uri_type_get_type gst_uri_type_get_type  -- u", "FUNCTION: gst_uri_type_get_type (  -- u )", "EXTERN: \"C\" int gst_uri_type_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_search_mode_get_type gst_search_mode_get_type  -- u", "FUNCTION: gst_search_mode_get_type (  -- u )", "EXTERN: \"C\" int gst_search_mode_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_atomic_queue_get_type gst_atomic_queue_get_type  -- u", "FUNCTION: gst_atomic_queue_get_type (  -- u )", "EXTERN: \"C\" int gst_atomic_queue_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_atomic_queue_new gst_atomic_queue_new u -- a", "FUNCTION: gst_atomic_queue_new ( initial_size -- a )", "EXTERN: \"C\" void * gst_atomic_queue_new( int initial_size );", "	( initial_size -- )" );
	swigFunction( "c-function gst_atomic_queue_ref gst_atomic_queue_ref a -- void", "FUNCTION: gst_atomic_queue_ref ( queue -- void )", "EXTERN: \"C\" void gst_atomic_queue_ref( void * queue );", "	( queue -- )" );
	swigFunction( "c-function gst_atomic_queue_unref gst_atomic_queue_unref a -- void", "FUNCTION: gst_atomic_queue_unref ( queue -- void )", "EXTERN: \"C\" void gst_atomic_queue_unref( void * queue );", "	( queue -- )" );
	swigFunction( "c-function gst_atomic_queue_push gst_atomic_queue_push a a -- void", "FUNCTION: gst_atomic_queue_push ( queue data -- void )", "EXTERN: \"C\" void gst_atomic_queue_push( void * queue, void * data );", "	( queue data -- )" );
	swigFunction( "c-function gst_atomic_queue_pop gst_atomic_queue_pop a -- a", "FUNCTION: gst_atomic_queue_pop ( queue -- a )", "EXTERN: \"C\" void * gst_atomic_queue_pop( void * queue );", "	( queue -- )" );
	swigFunction( "c-function gst_atomic_queue_peek gst_atomic_queue_peek a -- a", "FUNCTION: gst_atomic_queue_peek ( queue -- a )", "EXTERN: \"C\" void * gst_atomic_queue_peek( void * queue );", "	( queue -- )" );
	swigFunction( "c-function gst_atomic_queue_length gst_atomic_queue_length a -- u", "FUNCTION: gst_atomic_queue_length ( queue -- u )", "EXTERN: \"C\" int gst_atomic_queue_length( void * queue );", "	( queue -- )" );
	swigFunction( "c-function gst_bin_get_type gst_bin_get_type  -- u", "FUNCTION: gst_bin_get_type (  -- u )", "EXTERN: \"C\" int gst_bin_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_bin_new gst_bin_new s -- a", "FUNCTION: gst_bin_new ( name -- a )", "EXTERN: \"C\" void * gst_bin_new( char * name );", "	( name -- )" );
	swigFunction( "c-function gst_bin_add gst_bin_add a a -- n", "FUNCTION: gst_bin_add ( bin element -- n )", "EXTERN: \"C\" int gst_bin_add( void * bin, void * element );", "	( bin element -- )" );
	swigFunction( "c-function gst_bin_remove gst_bin_remove a a -- n", "FUNCTION: gst_bin_remove ( bin element -- n )", "EXTERN: \"C\" int gst_bin_remove( void * bin, void * element );", "	( bin element -- )" );
	swigFunction( "c-function gst_bin_get_by_name gst_bin_get_by_name a s -- a", "FUNCTION: gst_bin_get_by_name ( bin name -- a )", "EXTERN: \"C\" void * gst_bin_get_by_name( void * bin, char * name );", "	( bin name -- )" );
	swigFunction( "c-function gst_bin_get_by_name_recurse_up gst_bin_get_by_name_recurse_up a s -- a", "FUNCTION: gst_bin_get_by_name_recurse_up ( bin name -- a )", "EXTERN: \"C\" void * gst_bin_get_by_name_recurse_up( void * bin, char * name );", "	( bin name -- )" );
	swigFunction( "c-function gst_bin_get_by_interface gst_bin_get_by_interface a u -- a", "FUNCTION: gst_bin_get_by_interface ( bin iface -- a )", "EXTERN: \"C\" void * gst_bin_get_by_interface( void * bin, int iface );", "	( bin iface -- )" );
	swigFunction( "c-function gst_bin_iterate_elements gst_bin_iterate_elements a -- a", "FUNCTION: gst_bin_iterate_elements ( bin -- a )", "EXTERN: \"C\" void * gst_bin_iterate_elements( void * bin );", "	( bin -- )" );
	swigFunction( "c-function gst_bin_iterate_sorted gst_bin_iterate_sorted a -- a", "FUNCTION: gst_bin_iterate_sorted ( bin -- a )", "EXTERN: \"C\" void * gst_bin_iterate_sorted( void * bin );", "	( bin -- )" );
	swigFunction( "c-function gst_bin_iterate_recurse gst_bin_iterate_recurse a -- a", "FUNCTION: gst_bin_iterate_recurse ( bin -- a )", "EXTERN: \"C\" void * gst_bin_iterate_recurse( void * bin );", "	( bin -- )" );
	swigFunction( "c-function gst_bin_iterate_sinks gst_bin_iterate_sinks a -- a", "FUNCTION: gst_bin_iterate_sinks ( bin -- a )", "EXTERN: \"C\" void * gst_bin_iterate_sinks( void * bin );", "	( bin -- )" );
	swigFunction( "c-function gst_bin_iterate_sources gst_bin_iterate_sources a -- a", "FUNCTION: gst_bin_iterate_sources ( bin -- a )", "EXTERN: \"C\" void * gst_bin_iterate_sources( void * bin );", "	( bin -- )" );
	swigFunction( "c-function gst_bin_iterate_all_by_interface gst_bin_iterate_all_by_interface a u -- a", "FUNCTION: gst_bin_iterate_all_by_interface ( bin iface -- a )", "EXTERN: \"C\" void * gst_bin_iterate_all_by_interface( void * bin, int iface );", "	( bin iface -- )" );
	swigFunction( "c-function gst_bin_recalculate_latency gst_bin_recalculate_latency a -- n", "FUNCTION: gst_bin_recalculate_latency ( bin -- n )", "EXTERN: \"C\" int gst_bin_recalculate_latency( void * bin );", "	( bin -- )" );
	swigFunction( "c-function gst_bin_set_suppressed_flags gst_bin_set_suppressed_flags a n -- void", "FUNCTION: gst_bin_set_suppressed_flags ( bin flags -- void )", "EXTERN: \"C\" void gst_bin_set_suppressed_flags( void * bin, int flags );", "	( bin flags -- )" );
	swigFunction( "c-function gst_bin_get_suppressed_flags gst_bin_get_suppressed_flags a -- n", "FUNCTION: gst_bin_get_suppressed_flags ( bin -- n )", "EXTERN: \"C\" int gst_bin_get_suppressed_flags( void * bin );", "	( bin -- )" );
	swigFunction( "c-function gst_buffer_get_type gst_buffer_get_type  -- u", "FUNCTION: gst_buffer_get_type (  -- u )", "EXTERN: \"C\" int gst_buffer_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_buffer_get_max_memory gst_buffer_get_max_memory  -- u", "FUNCTION: gst_buffer_get_max_memory (  -- u )", "EXTERN: \"C\" int gst_buffer_get_max_memory(  );", "	( -- )" );
	swigFunction( "c-function gst_buffer_new gst_buffer_new  -- a", "FUNCTION: gst_buffer_new (  -- a )", "EXTERN: \"C\" void * gst_buffer_new(  );", "	( -- )" );
	swigFunction( "c-function gst_buffer_new_allocate gst_buffer_new_allocate a u a -- a", "FUNCTION: gst_buffer_new_allocate ( allocator size params -- a )", "EXTERN: \"C\" void * gst_buffer_new_allocate( void * allocator, int size, void * params );", "	( allocator size params -- )" );
	swigFunction( "c-function gst_buffer_new_wrapped_full gst_buffer_new_wrapped_full n a u u u a a -- a", "FUNCTION: gst_buffer_new_wrapped_full ( flags data maxsize offset size user_data notify -- a )", "EXTERN: \"C\" void * gst_buffer_new_wrapped_full( int flags, void * data, int maxsize, int offset, int size, void * user_data, void * notify );", "	( flags data maxsize offset size user_data notify -- )" );
	swigFunction( "c-function gst_buffer_new_wrapped gst_buffer_new_wrapped a u -- a", "FUNCTION: gst_buffer_new_wrapped ( data size -- a )", "EXTERN: \"C\" void * gst_buffer_new_wrapped( void * data, int size );", "	( data size -- )" );
	swigFunction( "c-function gst_buffer_n_memory gst_buffer_n_memory a -- u", "FUNCTION: gst_buffer_n_memory ( buffer -- u )", "EXTERN: \"C\" int gst_buffer_n_memory( void * buffer );", "	( buffer -- )" );
	swigFunction( "c-function gst_buffer_insert_memory gst_buffer_insert_memory a n a -- void", "FUNCTION: gst_buffer_insert_memory ( buffer idx mem -- void )", "EXTERN: \"C\" void gst_buffer_insert_memory( void * buffer, int idx, void * mem );", "	( buffer idx mem -- )" );
	swigFunction( "c-function gst_buffer_replace_memory_range gst_buffer_replace_memory_range a u n a -- void", "FUNCTION: gst_buffer_replace_memory_range ( buffer idx length mem -- void )", "EXTERN: \"C\" void gst_buffer_replace_memory_range( void * buffer, int idx, int length, void * mem );", "	( buffer idx length mem -- )" );
	swigFunction( "c-function gst_buffer_peek_memory gst_buffer_peek_memory a u -- a", "FUNCTION: gst_buffer_peek_memory ( buffer idx -- a )", "EXTERN: \"C\" void * gst_buffer_peek_memory( void * buffer, int idx );", "	( buffer idx -- )" );
	swigFunction( "c-function gst_buffer_get_memory_range gst_buffer_get_memory_range a u n -- a", "FUNCTION: gst_buffer_get_memory_range ( buffer idx length -- a )", "EXTERN: \"C\" void * gst_buffer_get_memory_range( void * buffer, int idx, int length );", "	( buffer idx length -- )" );
	swigFunction( "c-function gst_buffer_remove_memory_range gst_buffer_remove_memory_range a u n -- void", "FUNCTION: gst_buffer_remove_memory_range ( buffer idx length -- void )", "EXTERN: \"C\" void gst_buffer_remove_memory_range( void * buffer, int idx, int length );", "	( buffer idx length -- )" );
	swigFunction( "c-function gst_buffer_prepend_memory gst_buffer_prepend_memory a a -- void", "FUNCTION: gst_buffer_prepend_memory ( buffer mem -- void )", "EXTERN: \"C\" void gst_buffer_prepend_memory( void * buffer, void * mem );", "	( buffer mem -- )" );
	swigFunction( "c-function gst_buffer_append_memory gst_buffer_append_memory a a -- void", "FUNCTION: gst_buffer_append_memory ( buffer mem -- void )", "EXTERN: \"C\" void gst_buffer_append_memory( void * buffer, void * mem );", "	( buffer mem -- )" );
	swigFunction( "c-function gst_buffer_replace_memory gst_buffer_replace_memory a u a -- void", "FUNCTION: gst_buffer_replace_memory ( buffer idx mem -- void )", "EXTERN: \"C\" void gst_buffer_replace_memory( void * buffer, int idx, void * mem );", "	( buffer idx mem -- )" );
	swigFunction( "c-function gst_buffer_replace_all_memory gst_buffer_replace_all_memory a a -- void", "FUNCTION: gst_buffer_replace_all_memory ( buffer mem -- void )", "EXTERN: \"C\" void gst_buffer_replace_all_memory( void * buffer, void * mem );", "	( buffer mem -- )" );
	swigFunction( "c-function gst_buffer_get_memory gst_buffer_get_memory a u -- a", "FUNCTION: gst_buffer_get_memory ( buffer idx -- a )", "EXTERN: \"C\" void * gst_buffer_get_memory( void * buffer, int idx );", "	( buffer idx -- )" );
	swigFunction( "c-function gst_buffer_get_all_memory gst_buffer_get_all_memory a -- a", "FUNCTION: gst_buffer_get_all_memory ( buffer -- a )", "EXTERN: \"C\" void * gst_buffer_get_all_memory( void * buffer );", "	( buffer -- )" );
	swigFunction( "c-function gst_buffer_remove_memory gst_buffer_remove_memory a u -- void", "FUNCTION: gst_buffer_remove_memory ( buffer idx -- void )", "EXTERN: \"C\" void gst_buffer_remove_memory( void * buffer, int idx );", "	( buffer idx -- )" );
	swigFunction( "c-function gst_buffer_remove_all_memory gst_buffer_remove_all_memory a -- void", "FUNCTION: gst_buffer_remove_all_memory ( buffer -- void )", "EXTERN: \"C\" void gst_buffer_remove_all_memory( void * buffer );", "	( buffer -- )" );
	swigFunction( "c-function gst_buffer_find_memory gst_buffer_find_memory a u u a a a -- n", "FUNCTION: gst_buffer_find_memory ( buffer offset size idx length skip -- n )", "EXTERN: \"C\" int gst_buffer_find_memory( void * buffer, int offset, int size, void * idx, void * length, void * skip );", "	( buffer offset size idx length skip -- )" );
	swigFunction( "c-function gst_buffer_is_memory_range_writable gst_buffer_is_memory_range_writable a u n -- n", "FUNCTION: gst_buffer_is_memory_range_writable ( buffer idx length -- n )", "EXTERN: \"C\" int gst_buffer_is_memory_range_writable( void * buffer, int idx, int length );", "	( buffer idx length -- )" );
	swigFunction( "c-function gst_buffer_is_all_memory_writable gst_buffer_is_all_memory_writable a -- n", "FUNCTION: gst_buffer_is_all_memory_writable ( buffer -- n )", "EXTERN: \"C\" int gst_buffer_is_all_memory_writable( void * buffer );", "	( buffer -- )" );
	swigFunction( "c-function gst_buffer_fill gst_buffer_fill a u a u -- u", "FUNCTION: gst_buffer_fill ( buffer offset src size -- u )", "EXTERN: \"C\" int gst_buffer_fill( void * buffer, int offset, void * src, int size );", "	( buffer offset src size -- )" );
	swigFunction( "c-function gst_buffer_extract gst_buffer_extract a u a u -- u", "FUNCTION: gst_buffer_extract ( buffer offset dest size -- u )", "EXTERN: \"C\" int gst_buffer_extract( void * buffer, int offset, void * dest, int size );", "	( buffer offset dest size -- )" );
	swigFunction( "c-function gst_buffer_memcmp gst_buffer_memcmp a u a u -- n", "FUNCTION: gst_buffer_memcmp ( buffer offset mem size -- n )", "EXTERN: \"C\" int gst_buffer_memcmp( void * buffer, int offset, void * mem, int size );", "	( buffer offset mem size -- )" );
	swigFunction( "c-function gst_buffer_memset gst_buffer_memset a u u u -- u", "FUNCTION: gst_buffer_memset ( buffer offset val size -- u )", "EXTERN: \"C\" int gst_buffer_memset( void * buffer, int offset, char val, int size );", "	( buffer offset val size -- )" );
	swigFunction( "c-function gst_buffer_get_sizes_range gst_buffer_get_sizes_range a u n a a -- u", "FUNCTION: gst_buffer_get_sizes_range ( buffer idx length offset maxsize -- u )", "EXTERN: \"C\" int gst_buffer_get_sizes_range( void * buffer, int idx, int length, void * offset, void * maxsize );", "	( buffer idx length offset maxsize -- )" );
	swigFunction( "c-function gst_buffer_resize_range gst_buffer_resize_range a u n n n -- n", "FUNCTION: gst_buffer_resize_range ( buffer idx length offset size -- n )", "EXTERN: \"C\" int gst_buffer_resize_range( void * buffer, int idx, int length, n offset, n size );", "	( buffer idx length offset size -- )" );
	swigFunction( "c-function gst_buffer_get_sizes gst_buffer_get_sizes a a a -- u", "FUNCTION: gst_buffer_get_sizes ( buffer offset maxsize -- u )", "EXTERN: \"C\" int gst_buffer_get_sizes( void * buffer, void * offset, void * maxsize );", "	( buffer offset maxsize -- )" );
	swigFunction( "c-function gst_buffer_get_size gst_buffer_get_size a -- u", "FUNCTION: gst_buffer_get_size ( buffer -- u )", "EXTERN: \"C\" int gst_buffer_get_size( void * buffer );", "	( buffer -- )" );
	swigFunction( "c-function gst_buffer_resize gst_buffer_resize a n n -- void", "FUNCTION: gst_buffer_resize ( buffer offset size -- void )", "EXTERN: \"C\" void gst_buffer_resize( void * buffer, n offset, n size );", "	( buffer offset size -- )" );
	swigFunction( "c-function gst_buffer_set_size gst_buffer_set_size a n -- void", "FUNCTION: gst_buffer_set_size ( buffer size -- void )", "EXTERN: \"C\" void gst_buffer_set_size( void * buffer, n size );", "	( buffer size -- )" );
	swigFunction( "c-function gst_buffer_map_range gst_buffer_map_range a u n a n -- n", "FUNCTION: gst_buffer_map_range ( buffer idx length info flags -- n )", "EXTERN: \"C\" int gst_buffer_map_range( void * buffer, int idx, int length, void * info, int flags );", "	( buffer idx length info flags -- )" );
	swigFunction( "c-function gst_buffer_map gst_buffer_map a a n -- n", "FUNCTION: gst_buffer_map ( buffer info flags -- n )", "EXTERN: \"C\" int gst_buffer_map( void * buffer, void * info, int flags );", "	( buffer info flags -- )" );
	swigFunction( "c-function gst_buffer_unmap gst_buffer_unmap a a -- void", "FUNCTION: gst_buffer_unmap ( buffer info -- void )", "EXTERN: \"C\" void gst_buffer_unmap( void * buffer, void * info );", "	( buffer info -- )" );
	swigFunction( "c-function gst_buffer_extract_dup gst_buffer_extract_dup a u u a a -- void", "FUNCTION: gst_buffer_extract_dup ( buffer offset size dest dest_size -- void )", "EXTERN: \"C\" void gst_buffer_extract_dup( void * buffer, int offset, int size, void * dest, void * dest_size );", "	( buffer offset size dest dest_size -- )" );
	swigFunction( "c-function gst_buffer_get_flags gst_buffer_get_flags a -- n", "FUNCTION: gst_buffer_get_flags ( buffer -- n )", "EXTERN: \"C\" int gst_buffer_get_flags( void * buffer );", "	( buffer -- )" );
	swigFunction( "c-function gst_buffer_has_flags gst_buffer_has_flags a n -- n", "FUNCTION: gst_buffer_has_flags ( buffer flags -- n )", "EXTERN: \"C\" int gst_buffer_has_flags( void * buffer, int flags );", "	( buffer flags -- )" );
	swigFunction( "c-function gst_buffer_set_flags gst_buffer_set_flags a n -- n", "FUNCTION: gst_buffer_set_flags ( buffer flags -- n )", "EXTERN: \"C\" int gst_buffer_set_flags( void * buffer, int flags );", "	( buffer flags -- )" );
	swigFunction( "c-function gst_buffer_unset_flags gst_buffer_unset_flags a n -- n", "FUNCTION: gst_buffer_unset_flags ( buffer flags -- n )", "EXTERN: \"C\" int gst_buffer_unset_flags( void * buffer, int flags );", "	( buffer flags -- )" );
	swigFunction( "c-function gst_buffer_ref gst_buffer_ref a -- a", "FUNCTION: gst_buffer_ref ( buf -- a )", "EXTERN: \"C\" void * gst_buffer_ref( void * buf );", "	( buf -- )" );
	swigFunction( "c-function gst_buffer_unref gst_buffer_unref a -- void", "FUNCTION: gst_buffer_unref ( buf -- void )", "EXTERN: \"C\" void gst_buffer_unref( void * buf );", "	( buf -- )" );
	swigFunction( "c-function gst_buffer_copy gst_buffer_copy a -- a", "FUNCTION: gst_buffer_copy ( buf -- a )", "EXTERN: \"C\" void * gst_buffer_copy( void * buf );", "	( buf -- )" );
	swigFunction( "c-function gst_buffer_copy_deep gst_buffer_copy_deep a -- a", "FUNCTION: gst_buffer_copy_deep ( buf -- a )", "EXTERN: \"C\" void * gst_buffer_copy_deep( void * buf );", "	( buf -- )" );
	swigFunction( "c-function gst_buffer_copy_into gst_buffer_copy_into a a n u u -- n", "FUNCTION: gst_buffer_copy_into ( dest src flags offset size -- n )", "EXTERN: \"C\" int gst_buffer_copy_into( void * dest, void * src, int flags, int offset, int size );", "	( dest src flags offset size -- )" );
	swigFunction( "c-function gst_buffer_replace gst_buffer_replace a a -- n", "FUNCTION: gst_buffer_replace ( obuf nbuf -- n )", "EXTERN: \"C\" int gst_buffer_replace( void * obuf, void * nbuf );", "	( obuf nbuf -- )" );
	swigFunction( "c-function gst_buffer_copy_region gst_buffer_copy_region a n u u -- a", "FUNCTION: gst_buffer_copy_region ( parent flags offset size -- a )", "EXTERN: \"C\" void * gst_buffer_copy_region( void * parent, int flags, int offset, int size );", "	( parent flags offset size -- )" );
	swigFunction( "c-function gst_buffer_append_region gst_buffer_append_region a a n n -- a", "FUNCTION: gst_buffer_append_region ( buf1 buf2 offset size -- a )", "EXTERN: \"C\" void * gst_buffer_append_region( void * buf1, void * buf2, n offset, n size );", "	( buf1 buf2 offset size -- )" );
	swigFunction( "c-function gst_buffer_append gst_buffer_append a a -- a", "FUNCTION: gst_buffer_append ( buf1 buf2 -- a )", "EXTERN: \"C\" void * gst_buffer_append( void * buf1, void * buf2 );", "	( buf1 buf2 -- )" );
	swigFunction( "c-function gst_buffer_get_meta gst_buffer_get_meta a u -- a", "FUNCTION: gst_buffer_get_meta ( buffer api -- a )", "EXTERN: \"C\" void * gst_buffer_get_meta( void * buffer, int api );", "	( buffer api -- )" );
	swigFunction( "c-function gst_buffer_get_n_meta gst_buffer_get_n_meta a u -- u", "FUNCTION: gst_buffer_get_n_meta ( buffer api_type -- u )", "EXTERN: \"C\" int gst_buffer_get_n_meta( void * buffer, int api_type );", "	( buffer api_type -- )" );
	swigFunction( "c-function gst_buffer_add_meta gst_buffer_add_meta a a a -- a", "FUNCTION: gst_buffer_add_meta ( buffer info params -- a )", "EXTERN: \"C\" void * gst_buffer_add_meta( void * buffer, void * info, void * params );", "	( buffer info params -- )" );
	swigFunction( "c-function gst_buffer_remove_meta gst_buffer_remove_meta a a -- n", "FUNCTION: gst_buffer_remove_meta ( buffer meta -- n )", "EXTERN: \"C\" int gst_buffer_remove_meta( void * buffer, void * meta );", "	( buffer meta -- )" );
	swigFunction( "c-function gst_buffer_iterate_meta gst_buffer_iterate_meta a a -- a", "FUNCTION: gst_buffer_iterate_meta ( buffer state -- a )", "EXTERN: \"C\" void * gst_buffer_iterate_meta( void * buffer, void * state );", "	( buffer state -- )" );
	swigFunction( "c-function gst_buffer_iterate_meta_filtered gst_buffer_iterate_meta_filtered a a u -- a", "FUNCTION: gst_buffer_iterate_meta_filtered ( buffer state meta_api_type -- a )", "EXTERN: \"C\" void * gst_buffer_iterate_meta_filtered( void * buffer, void * state, int meta_api_type );", "	( buffer state meta_api_type -- )" );
	swigFunction( "c-function gst_buffer_foreach_meta gst_buffer_foreach_meta a a a -- n", "FUNCTION: gst_buffer_foreach_meta ( buffer func user_data -- n )", "EXTERN: \"C\" int gst_buffer_foreach_meta( void * buffer, void * func, void * user_data );", "	( buffer func user_data -- )" );
	swigFunction( "c-function gst_parent_buffer_meta_api_get_type gst_parent_buffer_meta_api_get_type  -- u", "FUNCTION: gst_parent_buffer_meta_api_get_type (  -- u )", "EXTERN: \"C\" int gst_parent_buffer_meta_api_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_parent_buffer_meta_get_info gst_parent_buffer_meta_get_info  -- a", "FUNCTION: gst_parent_buffer_meta_get_info (  -- a )", "EXTERN: \"C\" void * gst_parent_buffer_meta_get_info(  );", "	( -- )" );
	swigFunction( "c-function gst_buffer_add_parent_buffer_meta gst_buffer_add_parent_buffer_meta a a -- a", "FUNCTION: gst_buffer_add_parent_buffer_meta ( buffer ref -- a )", "EXTERN: \"C\" void * gst_buffer_add_parent_buffer_meta( void * buffer, void * ref );", "	( buffer ref -- )" );
	swigFunction( "c-function gst_reference_timestamp_meta_api_get_type gst_reference_timestamp_meta_api_get_type  -- u", "FUNCTION: gst_reference_timestamp_meta_api_get_type (  -- u )", "EXTERN: \"C\" int gst_reference_timestamp_meta_api_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_reference_timestamp_meta_get_info gst_reference_timestamp_meta_get_info  -- a", "FUNCTION: gst_reference_timestamp_meta_get_info (  -- a )", "EXTERN: \"C\" void * gst_reference_timestamp_meta_get_info(  );", "	( -- )" );
	swigFunction( "c-function gst_buffer_add_reference_timestamp_meta gst_buffer_add_reference_timestamp_meta a a ud ud -- a", "FUNCTION: gst_buffer_add_reference_timestamp_meta ( buffer reference timestamp duration -- a )", "EXTERN: \"C\" void * gst_buffer_add_reference_timestamp_meta( void * buffer, void * reference, long long timestamp, long long duration );", "	( buffer reference timestamp duration -- )" );
	swigFunction( "c-function gst_buffer_get_reference_timestamp_meta gst_buffer_get_reference_timestamp_meta a a -- a", "FUNCTION: gst_buffer_get_reference_timestamp_meta ( buffer reference -- a )", "EXTERN: \"C\" void * gst_buffer_get_reference_timestamp_meta( void * buffer, void * reference );", "	( buffer reference -- )" );
	swigFunction( "c-function gst_buffer_list_ref gst_buffer_list_ref a -- a", "FUNCTION: gst_buffer_list_ref ( list -- a )", "EXTERN: \"C\" void * gst_buffer_list_ref( void * list );", "	( list -- )" );
	swigFunction( "c-function gst_buffer_list_unref gst_buffer_list_unref a -- void", "FUNCTION: gst_buffer_list_unref ( list -- void )", "EXTERN: \"C\" void gst_buffer_list_unref( void * list );", "	( list -- )" );
	swigFunction( "c-function gst_buffer_list_copy gst_buffer_list_copy a -- a", "FUNCTION: gst_buffer_list_copy ( list -- a )", "EXTERN: \"C\" void * gst_buffer_list_copy( void * list );", "	( list -- )" );
	swigFunction( "c-function gst_buffer_list_get_type gst_buffer_list_get_type  -- u", "FUNCTION: gst_buffer_list_get_type (  -- u )", "EXTERN: \"C\" int gst_buffer_list_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_buffer_list_new gst_buffer_list_new  -- a", "FUNCTION: gst_buffer_list_new (  -- a )", "EXTERN: \"C\" void * gst_buffer_list_new(  );", "	( -- )" );
	swigFunction( "c-function gst_buffer_list_new_sized gst_buffer_list_new_sized u -- a", "FUNCTION: gst_buffer_list_new_sized ( size -- a )", "EXTERN: \"C\" void * gst_buffer_list_new_sized( int size );", "	( size -- )" );
	swigFunction( "c-function gst_buffer_list_length gst_buffer_list_length a -- u", "FUNCTION: gst_buffer_list_length ( list -- u )", "EXTERN: \"C\" int gst_buffer_list_length( void * list );", "	( list -- )" );
	swigFunction( "c-function gst_buffer_list_get gst_buffer_list_get a u -- a", "FUNCTION: gst_buffer_list_get ( list idx -- a )", "EXTERN: \"C\" void * gst_buffer_list_get( void * list, int idx );", "	( list idx -- )" );
	swigFunction( "c-function gst_buffer_list_get_writable gst_buffer_list_get_writable a u -- a", "FUNCTION: gst_buffer_list_get_writable ( list idx -- a )", "EXTERN: \"C\" void * gst_buffer_list_get_writable( void * list, int idx );", "	( list idx -- )" );
	swigFunction( "c-function gst_buffer_list_insert gst_buffer_list_insert a n a -- void", "FUNCTION: gst_buffer_list_insert ( list idx buffer -- void )", "EXTERN: \"C\" void gst_buffer_list_insert( void * list, int idx, void * buffer );", "	( list idx buffer -- )" );
	swigFunction( "c-function gst_buffer_list_remove gst_buffer_list_remove a u u -- void", "FUNCTION: gst_buffer_list_remove ( list idx length -- void )", "EXTERN: \"C\" void gst_buffer_list_remove( void * list, int idx, int length );", "	( list idx length -- )" );
	swigFunction( "c-function gst_buffer_list_foreach gst_buffer_list_foreach a a a -- n", "FUNCTION: gst_buffer_list_foreach ( list func user_data -- n )", "EXTERN: \"C\" int gst_buffer_list_foreach( void * list, void * func, void * user_data );", "	( list func user_data -- )" );
	swigFunction( "c-function gst_buffer_list_copy_deep gst_buffer_list_copy_deep a -- a", "FUNCTION: gst_buffer_list_copy_deep ( list -- a )", "EXTERN: \"C\" void * gst_buffer_list_copy_deep( void * list );", "	( list -- )" );
	swigFunction( "c-function gst_buffer_list_calculate_size gst_buffer_list_calculate_size a -- u", "FUNCTION: gst_buffer_list_calculate_size ( list -- u )", "EXTERN: \"C\" int gst_buffer_list_calculate_size( void * list );", "	( list -- )" );
	swigFunction( "c-function gst_buffer_pool_get_type gst_buffer_pool_get_type  -- u", "FUNCTION: gst_buffer_pool_get_type (  -- u )", "EXTERN: \"C\" int gst_buffer_pool_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_buffer_pool_new gst_buffer_pool_new  -- a", "FUNCTION: gst_buffer_pool_new (  -- a )", "EXTERN: \"C\" void * gst_buffer_pool_new(  );", "	( -- )" );
	swigFunction( "c-function gst_buffer_pool_set_active gst_buffer_pool_set_active a n -- n", "FUNCTION: gst_buffer_pool_set_active ( pool active -- n )", "EXTERN: \"C\" int gst_buffer_pool_set_active( void * pool, int active );", "	( pool active -- )" );
	swigFunction( "c-function gst_buffer_pool_is_active gst_buffer_pool_is_active a -- n", "FUNCTION: gst_buffer_pool_is_active ( pool -- n )", "EXTERN: \"C\" int gst_buffer_pool_is_active( void * pool );", "	( pool -- )" );
	swigFunction( "c-function gst_buffer_pool_set_config gst_buffer_pool_set_config a a -- n", "FUNCTION: gst_buffer_pool_set_config ( pool config -- n )", "EXTERN: \"C\" int gst_buffer_pool_set_config( void * pool, void * config );", "	( pool config -- )" );
	swigFunction( "c-function gst_buffer_pool_get_config gst_buffer_pool_get_config a -- a", "FUNCTION: gst_buffer_pool_get_config ( pool -- a )", "EXTERN: \"C\" void * gst_buffer_pool_get_config( void * pool );", "	( pool -- )" );
	swigFunction( "c-function gst_buffer_pool_get_options gst_buffer_pool_get_options a -- a", "FUNCTION: gst_buffer_pool_get_options ( pool -- a )", "EXTERN: \"C\" void * gst_buffer_pool_get_options( void * pool );", "	( pool -- )" );
	swigFunction( "c-function gst_buffer_pool_has_option gst_buffer_pool_has_option a s -- n", "FUNCTION: gst_buffer_pool_has_option ( pool option -- n )", "EXTERN: \"C\" int gst_buffer_pool_has_option( void * pool, char * option );", "	( pool option -- )" );
	swigFunction( "c-function gst_buffer_pool_set_flushing gst_buffer_pool_set_flushing a n -- void", "FUNCTION: gst_buffer_pool_set_flushing ( pool flushing -- void )", "EXTERN: \"C\" void gst_buffer_pool_set_flushing( void * pool, int flushing );", "	( pool flushing -- )" );
	swigFunction( "c-function gst_buffer_pool_config_set_params gst_buffer_pool_config_set_params a a u u u -- void", "FUNCTION: gst_buffer_pool_config_set_params ( config caps size min_buffers max_buffers -- void )", "EXTERN: \"C\" void gst_buffer_pool_config_set_params( void * config, void * caps, int size, int min_buffers, int max_buffers );", "	( config caps size min_buffers max_buffers -- )" );
	swigFunction( "c-function gst_buffer_pool_config_get_params gst_buffer_pool_config_get_params a a a a a -- n", "FUNCTION: gst_buffer_pool_config_get_params ( config caps size min_buffers max_buffers -- n )", "EXTERN: \"C\" int gst_buffer_pool_config_get_params( void * config, void * caps, void * size, void * min_buffers, void * max_buffers );", "	( config caps size min_buffers max_buffers -- )" );
	swigFunction( "c-function gst_buffer_pool_config_set_allocator gst_buffer_pool_config_set_allocator a a a -- void", "FUNCTION: gst_buffer_pool_config_set_allocator ( config allocator params -- void )", "EXTERN: \"C\" void gst_buffer_pool_config_set_allocator( void * config, void * allocator, void * params );", "	( config allocator params -- )" );
	swigFunction( "c-function gst_buffer_pool_config_get_allocator gst_buffer_pool_config_get_allocator a a a -- n", "FUNCTION: gst_buffer_pool_config_get_allocator ( config allocator params -- n )", "EXTERN: \"C\" int gst_buffer_pool_config_get_allocator( void * config, void * allocator, void * params );", "	( config allocator params -- )" );
	swigFunction( "c-function gst_buffer_pool_config_n_options gst_buffer_pool_config_n_options a -- u", "FUNCTION: gst_buffer_pool_config_n_options ( config -- u )", "EXTERN: \"C\" int gst_buffer_pool_config_n_options( void * config );", "	( config -- )" );
	swigFunction( "c-function gst_buffer_pool_config_add_option gst_buffer_pool_config_add_option a s -- void", "FUNCTION: gst_buffer_pool_config_add_option ( config option -- void )", "EXTERN: \"C\" void gst_buffer_pool_config_add_option( void * config, char * option );", "	( config option -- )" );
	swigFunction( "c-function gst_buffer_pool_config_get_option gst_buffer_pool_config_get_option a u -- s", "FUNCTION: gst_buffer_pool_config_get_option ( config index -- s )", "EXTERN: \"C\" char * gst_buffer_pool_config_get_option( void * config, int index );", "	( config index -- )" );
	swigFunction( "c-function gst_buffer_pool_config_has_option gst_buffer_pool_config_has_option a s -- n", "FUNCTION: gst_buffer_pool_config_has_option ( config option -- n )", "EXTERN: \"C\" int gst_buffer_pool_config_has_option( void * config, char * option );", "	( config option -- )" );
	swigFunction( "c-function gst_buffer_pool_config_validate_params gst_buffer_pool_config_validate_params a a u u u -- n", "FUNCTION: gst_buffer_pool_config_validate_params ( config caps size min_buffers max_buffers -- n )", "EXTERN: \"C\" int gst_buffer_pool_config_validate_params( void * config, void * caps, int size, int min_buffers, int max_buffers );", "	( config caps size min_buffers max_buffers -- )" );
	swigFunction( "c-function gst_buffer_pool_acquire_buffer gst_buffer_pool_acquire_buffer a a a -- n", "FUNCTION: gst_buffer_pool_acquire_buffer ( pool buffer params -- n )", "EXTERN: \"C\" int gst_buffer_pool_acquire_buffer( void * pool, void * buffer, void * params );", "	( pool buffer params -- )" );
	swigFunction( "c-function gst_buffer_pool_release_buffer gst_buffer_pool_release_buffer a a -- void", "FUNCTION: gst_buffer_pool_release_buffer ( pool buffer -- void )", "EXTERN: \"C\" void gst_buffer_pool_release_buffer( void * pool, void * buffer );", "	( pool buffer -- )" );
	swigFunction( "c-function gst_bus_get_type gst_bus_get_type  -- u", "FUNCTION: gst_bus_get_type (  -- u )", "EXTERN: \"C\" int gst_bus_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_bus_new gst_bus_new  -- a", "FUNCTION: gst_bus_new (  -- a )", "EXTERN: \"C\" void * gst_bus_new(  );", "	( -- )" );
	swigFunction( "c-function gst_bus_post gst_bus_post a a -- n", "FUNCTION: gst_bus_post ( bus message -- n )", "EXTERN: \"C\" int gst_bus_post( void * bus, void * message );", "	( bus message -- )" );
	swigFunction( "c-function gst_bus_have_pending gst_bus_have_pending a -- n", "FUNCTION: gst_bus_have_pending ( bus -- n )", "EXTERN: \"C\" int gst_bus_have_pending( void * bus );", "	( bus -- )" );
	swigFunction( "c-function gst_bus_peek gst_bus_peek a -- a", "FUNCTION: gst_bus_peek ( bus -- a )", "EXTERN: \"C\" void * gst_bus_peek( void * bus );", "	( bus -- )" );
	swigFunction( "c-function gst_bus_pop gst_bus_pop a -- a", "FUNCTION: gst_bus_pop ( bus -- a )", "EXTERN: \"C\" void * gst_bus_pop( void * bus );", "	( bus -- )" );
	swigFunction( "c-function gst_bus_pop_filtered gst_bus_pop_filtered a n -- a", "FUNCTION: gst_bus_pop_filtered ( bus types -- a )", "EXTERN: \"C\" void * gst_bus_pop_filtered( void * bus, int types );", "	( bus types -- )" );
	swigFunction( "c-function gst_bus_timed_pop gst_bus_timed_pop a ud -- a", "FUNCTION: gst_bus_timed_pop ( bus timeout -- a )", "EXTERN: \"C\" void * gst_bus_timed_pop( void * bus, long long timeout );", "	( bus timeout -- )" );
	swigFunction( "c-function gst_bus_timed_pop_filtered gst_bus_timed_pop_filtered a ud n -- a", "FUNCTION: gst_bus_timed_pop_filtered ( bus timeout types -- a )", "EXTERN: \"C\" void * gst_bus_timed_pop_filtered( void * bus, long long timeout, int types );", "	( bus timeout types -- )" );
	swigFunction( "c-function gst_bus_set_flushing gst_bus_set_flushing a n -- void", "FUNCTION: gst_bus_set_flushing ( bus flushing -- void )", "EXTERN: \"C\" void gst_bus_set_flushing( void * bus, int flushing );", "	( bus flushing -- )" );
	swigFunction( "c-function gst_bus_set_sync_handler gst_bus_set_sync_handler a a a a -- void", "FUNCTION: gst_bus_set_sync_handler ( bus func user_data notify -- void )", "EXTERN: \"C\" void gst_bus_set_sync_handler( void * bus, void * func, void * user_data, void * notify );", "	( bus func user_data notify -- )" );
	swigFunction( "c-function gst_bus_get_pollfd gst_bus_get_pollfd a a -- void", "FUNCTION: gst_bus_get_pollfd ( bus fd -- void )", "EXTERN: \"C\" void gst_bus_get_pollfd( void * bus, void * fd );", "	( bus fd -- )" );
	swigFunction( "c-function gst_bus_create_watch gst_bus_create_watch a -- a", "FUNCTION: gst_bus_create_watch ( bus -- a )", "EXTERN: \"C\" void * gst_bus_create_watch( void * bus );", "	( bus -- )" );
	swigFunction( "c-function gst_bus_add_watch_full gst_bus_add_watch_full a n a a a -- u", "FUNCTION: gst_bus_add_watch_full ( bus priority func user_data notify -- u )", "EXTERN: \"C\" int gst_bus_add_watch_full( void * bus, int priority, void * func, void * user_data, void * notify );", "	( bus priority func user_data notify -- )" );
	swigFunction( "c-function gst_bus_add_watch gst_bus_add_watch a a a -- u", "FUNCTION: gst_bus_add_watch ( bus func user_data -- u )", "EXTERN: \"C\" int gst_bus_add_watch( void * bus, void * func, void * user_data );", "	( bus func user_data -- )" );
	swigFunction( "c-function gst_bus_remove_watch gst_bus_remove_watch a -- n", "FUNCTION: gst_bus_remove_watch ( bus -- n )", "EXTERN: \"C\" int gst_bus_remove_watch( void * bus );", "	( bus -- )" );
	swigFunction( "c-function gst_bus_poll gst_bus_poll a n ud -- a", "FUNCTION: gst_bus_poll ( bus events timeout -- a )", "EXTERN: \"C\" void * gst_bus_poll( void * bus, int events, long long timeout );", "	( bus events timeout -- )" );
	swigFunction( "c-function gst_bus_async_signal_func gst_bus_async_signal_func a a a -- n", "FUNCTION: gst_bus_async_signal_func ( bus message data -- n )", "EXTERN: \"C\" int gst_bus_async_signal_func( void * bus, void * message, void * data );", "	( bus message data -- )" );
	swigFunction( "c-function gst_bus_sync_signal_handler gst_bus_sync_signal_handler a a a -- n", "FUNCTION: gst_bus_sync_signal_handler ( bus message data -- n )", "EXTERN: \"C\" int gst_bus_sync_signal_handler( void * bus, void * message, void * data );", "	( bus message data -- )" );
	swigFunction( "c-function gst_bus_add_signal_watch gst_bus_add_signal_watch a -- void", "FUNCTION: gst_bus_add_signal_watch ( bus -- void )", "EXTERN: \"C\" void gst_bus_add_signal_watch( void * bus );", "	( bus -- )" );
	swigFunction( "c-function gst_bus_add_signal_watch_full gst_bus_add_signal_watch_full a n -- void", "FUNCTION: gst_bus_add_signal_watch_full ( bus priority -- void )", "EXTERN: \"C\" void gst_bus_add_signal_watch_full( void * bus, int priority );", "	( bus priority -- )" );
	swigFunction( "c-function gst_bus_remove_signal_watch gst_bus_remove_signal_watch a -- void", "FUNCTION: gst_bus_remove_signal_watch ( bus -- void )", "EXTERN: \"C\" void gst_bus_remove_signal_watch( void * bus );", "	( bus -- )" );
	swigFunction( "c-function gst_bus_enable_sync_message_emission gst_bus_enable_sync_message_emission a -- void", "FUNCTION: gst_bus_enable_sync_message_emission ( bus -- void )", "EXTERN: \"C\" void gst_bus_enable_sync_message_emission( void * bus );", "	( bus -- )" );
	swigFunction( "c-function gst_bus_disable_sync_message_emission gst_bus_disable_sync_message_emission a -- void", "FUNCTION: gst_bus_disable_sync_message_emission ( bus -- void )", "EXTERN: \"C\" void gst_bus_disable_sync_message_emission( void * bus );", "	( bus -- )" );
	swigFunction( "c-function gst_caps_ref gst_caps_ref a -- a", "FUNCTION: gst_caps_ref ( caps -- a )", "EXTERN: \"C\" void * gst_caps_ref( void * caps );", "	( caps -- )" );
	swigFunction( "c-function gst_caps_unref gst_caps_unref a -- void", "FUNCTION: gst_caps_unref ( caps -- void )", "EXTERN: \"C\" void gst_caps_unref( void * caps );", "	( caps -- )" );
	swigFunction( "c-function gst_caps_copy gst_caps_copy a -- a", "FUNCTION: gst_caps_copy ( caps -- a )", "EXTERN: \"C\" void * gst_caps_copy( void * caps );", "	( caps -- )" );
	swigFunction( "c-function gst_caps_replace gst_caps_replace a a -- n", "FUNCTION: gst_caps_replace ( old_caps new_caps -- n )", "EXTERN: \"C\" int gst_caps_replace( void * old_caps, void * new_caps );", "	( old_caps new_caps -- )" );
	swigFunction( "c-function gst_caps_take gst_caps_take a a -- n", "FUNCTION: gst_caps_take ( old_caps new_caps -- n )", "EXTERN: \"C\" int gst_caps_take( void * old_caps, void * new_caps );", "	( old_caps new_caps -- )" );
	swigFunction( "c-function gst_caps_get_type gst_caps_get_type  -- u", "FUNCTION: gst_caps_get_type (  -- u )", "EXTERN: \"C\" int gst_caps_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_caps_new_empty gst_caps_new_empty  -- a", "FUNCTION: gst_caps_new_empty (  -- a )", "EXTERN: \"C\" void * gst_caps_new_empty(  );", "	( -- )" );
	swigFunction( "c-function gst_caps_new_any gst_caps_new_any  -- a", "FUNCTION: gst_caps_new_any (  -- a )", "EXTERN: \"C\" void * gst_caps_new_any(  );", "	( -- )" );
	swigFunction( "c-function gst_caps_new_empty_simple gst_caps_new_empty_simple s -- a", "FUNCTION: gst_caps_new_empty_simple ( media_type -- a )", "EXTERN: \"C\" void * gst_caps_new_empty_simple( char * media_type );", "	( media_type -- )" );
	swigFunction( "c-function gst_caps_new_simple gst_caps_new_simple s s ... -- a", "FUNCTION: gst_caps_new_simple ( media_type fieldname  -- a )", "EXTERN: \"C\" void * gst_caps_new_simple( char * media_type, char * fieldname, ...  );", "	( media_type fieldname <noname> -- )" );
	swigFunction( "c-function gst_caps_new_full gst_caps_new_full a ... -- a", "FUNCTION: gst_caps_new_full ( struct1  -- a )", "EXTERN: \"C\" void * gst_caps_new_full( void * struct1, ...  );", "	( struct1 <noname> -- )" );
	swigFunction( "c-function gst_caps_new_full_valist gst_caps_new_full_valist a a -- a", "FUNCTION: gst_caps_new_full_valist ( structure var_args -- a )", "EXTERN: \"C\" void * gst_caps_new_full_valist( void * structure, void * var_args );", "	( structure var_args -- )" );
	swigFunction( "c-function gst_static_caps_get_type gst_static_caps_get_type  -- u", "FUNCTION: gst_static_caps_get_type (  -- u )", "EXTERN: \"C\" int gst_static_caps_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_static_caps_get gst_static_caps_get a -- a", "FUNCTION: gst_static_caps_get ( static_caps -- a )", "EXTERN: \"C\" void * gst_static_caps_get( void * static_caps );", "	( static_caps -- )" );
	swigFunction( "c-function gst_static_caps_cleanup gst_static_caps_cleanup a -- void", "FUNCTION: gst_static_caps_cleanup ( static_caps -- void )", "EXTERN: \"C\" void gst_static_caps_cleanup( void * static_caps );", "	( static_caps -- )" );
	swigFunction( "c-function gst_caps_append gst_caps_append a a -- void", "FUNCTION: gst_caps_append ( caps1 caps2 -- void )", "EXTERN: \"C\" void gst_caps_append( void * caps1, void * caps2 );", "	( caps1 caps2 -- )" );
	swigFunction( "c-function gst_caps_append_structure gst_caps_append_structure a a -- void", "FUNCTION: gst_caps_append_structure ( caps structure -- void )", "EXTERN: \"C\" void gst_caps_append_structure( void * caps, void * structure );", "	( caps structure -- )" );
	swigFunction( "c-function gst_caps_append_structure_full gst_caps_append_structure_full a a a -- void", "FUNCTION: gst_caps_append_structure_full ( caps structure features -- void )", "EXTERN: \"C\" void gst_caps_append_structure_full( void * caps, void * structure, void * features );", "	( caps structure features -- )" );
	swigFunction( "c-function gst_caps_remove_structure gst_caps_remove_structure a u -- void", "FUNCTION: gst_caps_remove_structure ( caps idx -- void )", "EXTERN: \"C\" void gst_caps_remove_structure( void * caps, int idx );", "	( caps idx -- )" );
	swigFunction( "c-function gst_caps_merge gst_caps_merge a a -- a", "FUNCTION: gst_caps_merge ( caps1 caps2 -- a )", "EXTERN: \"C\" void * gst_caps_merge( void * caps1, void * caps2 );", "	( caps1 caps2 -- )" );
	swigFunction( "c-function gst_caps_merge_structure gst_caps_merge_structure a a -- a", "FUNCTION: gst_caps_merge_structure ( caps structure -- a )", "EXTERN: \"C\" void * gst_caps_merge_structure( void * caps, void * structure );", "	( caps structure -- )" );
	swigFunction( "c-function gst_caps_merge_structure_full gst_caps_merge_structure_full a a a -- a", "FUNCTION: gst_caps_merge_structure_full ( caps structure features -- a )", "EXTERN: \"C\" void * gst_caps_merge_structure_full( void * caps, void * structure, void * features );", "	( caps structure features -- )" );
	swigFunction( "c-function gst_caps_get_size gst_caps_get_size a -- u", "FUNCTION: gst_caps_get_size ( caps -- u )", "EXTERN: \"C\" int gst_caps_get_size( void * caps );", "	( caps -- )" );
	swigFunction( "c-function gst_caps_get_structure gst_caps_get_structure a u -- a", "FUNCTION: gst_caps_get_structure ( caps index -- a )", "EXTERN: \"C\" void * gst_caps_get_structure( void * caps, int index );", "	( caps index -- )" );
	swigFunction( "c-function gst_caps_steal_structure gst_caps_steal_structure a u -- a", "FUNCTION: gst_caps_steal_structure ( caps index -- a )", "EXTERN: \"C\" void * gst_caps_steal_structure( void * caps, int index );", "	( caps index -- )" );
	swigFunction( "c-function gst_caps_set_features gst_caps_set_features a u a -- void", "FUNCTION: gst_caps_set_features ( caps index features -- void )", "EXTERN: \"C\" void gst_caps_set_features( void * caps, int index, void * features );", "	( caps index features -- )" );
	swigFunction( "c-function gst_caps_get_features gst_caps_get_features a u -- a", "FUNCTION: gst_caps_get_features ( caps index -- a )", "EXTERN: \"C\" void * gst_caps_get_features( void * caps, int index );", "	( caps index -- )" );
	swigFunction( "c-function gst_caps_copy_nth gst_caps_copy_nth a u -- a", "FUNCTION: gst_caps_copy_nth ( caps nth -- a )", "EXTERN: \"C\" void * gst_caps_copy_nth( void * caps, int nth );", "	( caps nth -- )" );
	swigFunction( "c-function gst_caps_truncate gst_caps_truncate a -- a", "FUNCTION: gst_caps_truncate ( caps -- a )", "EXTERN: \"C\" void * gst_caps_truncate( void * caps );", "	( caps -- )" );
	swigFunction( "c-function gst_caps_set_value gst_caps_set_value a s a -- void", "FUNCTION: gst_caps_set_value ( caps field value -- void )", "EXTERN: \"C\" void gst_caps_set_value( void * caps, char * field, void * value );", "	( caps field value -- )" );
	swigFunction( "c-function gst_caps_set_simple gst_caps_set_simple a s ... -- void", "FUNCTION: gst_caps_set_simple ( caps field  -- void )", "EXTERN: \"C\" void gst_caps_set_simple( void * caps, char * field, ...  );", "	( caps field <noname> -- )" );
	swigFunction( "c-function gst_caps_set_simple_valist gst_caps_set_simple_valist a s a -- void", "FUNCTION: gst_caps_set_simple_valist ( caps field varargs -- void )", "EXTERN: \"C\" void gst_caps_set_simple_valist( void * caps, char * field, void * varargs );", "	( caps field varargs -- )" );
	swigFunction( "c-function gst_caps_foreach gst_caps_foreach a a a -- n", "FUNCTION: gst_caps_foreach ( caps func user_data -- n )", "EXTERN: \"C\" int gst_caps_foreach( void * caps, void * func, void * user_data );", "	( caps func user_data -- )" );
	swigFunction( "c-function gst_caps_map_in_place gst_caps_map_in_place a a a -- n", "FUNCTION: gst_caps_map_in_place ( caps func user_data -- n )", "EXTERN: \"C\" int gst_caps_map_in_place( void * caps, void * func, void * user_data );", "	( caps func user_data -- )" );
	swigFunction( "c-function gst_caps_filter_and_map_in_place gst_caps_filter_and_map_in_place a a a -- void", "FUNCTION: gst_caps_filter_and_map_in_place ( caps func user_data -- void )", "EXTERN: \"C\" void gst_caps_filter_and_map_in_place( void * caps, void * func, void * user_data );", "	( caps func user_data -- )" );
	swigFunction( "c-function gst_caps_is_any gst_caps_is_any a -- n", "FUNCTION: gst_caps_is_any ( caps -- n )", "EXTERN: \"C\" int gst_caps_is_any( void * caps );", "	( caps -- )" );
	swigFunction( "c-function gst_caps_is_empty gst_caps_is_empty a -- n", "FUNCTION: gst_caps_is_empty ( caps -- n )", "EXTERN: \"C\" int gst_caps_is_empty( void * caps );", "	( caps -- )" );
	swigFunction( "c-function gst_caps_is_fixed gst_caps_is_fixed a -- n", "FUNCTION: gst_caps_is_fixed ( caps -- n )", "EXTERN: \"C\" int gst_caps_is_fixed( void * caps );", "	( caps -- )" );
	swigFunction( "c-function gst_caps_is_always_compatible gst_caps_is_always_compatible a a -- n", "FUNCTION: gst_caps_is_always_compatible ( caps1 caps2 -- n )", "EXTERN: \"C\" int gst_caps_is_always_compatible( void * caps1, void * caps2 );", "	( caps1 caps2 -- )" );
	swigFunction( "c-function gst_caps_is_subset gst_caps_is_subset a a -- n", "FUNCTION: gst_caps_is_subset ( subset superset -- n )", "EXTERN: \"C\" int gst_caps_is_subset( void * subset, void * superset );", "	( subset superset -- )" );
	swigFunction( "c-function gst_caps_is_subset_structure gst_caps_is_subset_structure a a -- n", "FUNCTION: gst_caps_is_subset_structure ( caps structure -- n )", "EXTERN: \"C\" int gst_caps_is_subset_structure( void * caps, void * structure );", "	( caps structure -- )" );
	swigFunction( "c-function gst_caps_is_subset_structure_full gst_caps_is_subset_structure_full a a a -- n", "FUNCTION: gst_caps_is_subset_structure_full ( caps structure features -- n )", "EXTERN: \"C\" int gst_caps_is_subset_structure_full( void * caps, void * structure, void * features );", "	( caps structure features -- )" );
	swigFunction( "c-function gst_caps_is_equal gst_caps_is_equal a a -- n", "FUNCTION: gst_caps_is_equal ( caps1 caps2 -- n )", "EXTERN: \"C\" int gst_caps_is_equal( void * caps1, void * caps2 );", "	( caps1 caps2 -- )" );
	swigFunction( "c-function gst_caps_is_equal_fixed gst_caps_is_equal_fixed a a -- n", "FUNCTION: gst_caps_is_equal_fixed ( caps1 caps2 -- n )", "EXTERN: \"C\" int gst_caps_is_equal_fixed( void * caps1, void * caps2 );", "	( caps1 caps2 -- )" );
	swigFunction( "c-function gst_caps_can_intersect gst_caps_can_intersect a a -- n", "FUNCTION: gst_caps_can_intersect ( caps1 caps2 -- n )", "EXTERN: \"C\" int gst_caps_can_intersect( void * caps1, void * caps2 );", "	( caps1 caps2 -- )" );
	swigFunction( "c-function gst_caps_is_strictly_equal gst_caps_is_strictly_equal a a -- n", "FUNCTION: gst_caps_is_strictly_equal ( caps1 caps2 -- n )", "EXTERN: \"C\" int gst_caps_is_strictly_equal( void * caps1, void * caps2 );", "	( caps1 caps2 -- )" );
	swigFunction( "c-function gst_caps_intersect gst_caps_intersect a a -- a", "FUNCTION: gst_caps_intersect ( caps1 caps2 -- a )", "EXTERN: \"C\" void * gst_caps_intersect( void * caps1, void * caps2 );", "	( caps1 caps2 -- )" );
	swigFunction( "c-function gst_caps_intersect_full gst_caps_intersect_full a a n -- a", "FUNCTION: gst_caps_intersect_full ( caps1 caps2 mode -- a )", "EXTERN: \"C\" void * gst_caps_intersect_full( void * caps1, void * caps2, int mode );", "	( caps1 caps2 mode -- )" );
	swigFunction( "c-function gst_caps_subtract gst_caps_subtract a a -- a", "FUNCTION: gst_caps_subtract ( minuend subtrahend -- a )", "EXTERN: \"C\" void * gst_caps_subtract( void * minuend, void * subtrahend );", "	( minuend subtrahend -- )" );
	swigFunction( "c-function gst_caps_normalize gst_caps_normalize a -- a", "FUNCTION: gst_caps_normalize ( caps -- a )", "EXTERN: \"C\" void * gst_caps_normalize( void * caps );", "	( caps -- )" );
	swigFunction( "c-function gst_caps_simplify gst_caps_simplify a -- a", "FUNCTION: gst_caps_simplify ( caps -- a )", "EXTERN: \"C\" void * gst_caps_simplify( void * caps );", "	( caps -- )" );
	swigFunction( "c-function gst_caps_fixate gst_caps_fixate a -- a", "FUNCTION: gst_caps_fixate ( caps -- a )", "EXTERN: \"C\" void * gst_caps_fixate( void * caps );", "	( caps -- )" );
	swigFunction( "c-function gst_caps_to_string gst_caps_to_string a -- a", "FUNCTION: gst_caps_to_string ( caps -- a )", "EXTERN: \"C\" void * gst_caps_to_string( void * caps );", "	( caps -- )" );
	swigFunction( "c-function gst_caps_from_string gst_caps_from_string s -- a", "FUNCTION: gst_caps_from_string ( string -- a )", "EXTERN: \"C\" void * gst_caps_from_string( char * string );", "	( string -- )" );
	swigFunction( "c-function gst_caps_features_get_type gst_caps_features_get_type  -- u", "FUNCTION: gst_caps_features_get_type (  -- u )", "EXTERN: \"C\" int gst_caps_features_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_is_caps_features gst_is_caps_features a -- n", "FUNCTION: gst_is_caps_features ( obj -- n )", "EXTERN: \"C\" int gst_is_caps_features( void * obj );", "	( obj -- )" );
	swigFunction( "c-function gst_caps_features_new_empty gst_caps_features_new_empty  -- a", "FUNCTION: gst_caps_features_new_empty (  -- a )", "EXTERN: \"C\" void * gst_caps_features_new_empty(  );", "	( -- )" );
	swigFunction( "c-function gst_caps_features_new_any gst_caps_features_new_any  -- a", "FUNCTION: gst_caps_features_new_any (  -- a )", "EXTERN: \"C\" void * gst_caps_features_new_any(  );", "	( -- )" );
	swigFunction( "c-function gst_caps_features_new gst_caps_features_new s ... -- a", "FUNCTION: gst_caps_features_new ( feature1  -- a )", "EXTERN: \"C\" void * gst_caps_features_new( char * feature1, ...  );", "	( feature1 <noname> -- )" );
	swigFunction( "c-function gst_caps_features_new_valist gst_caps_features_new_valist s a -- a", "FUNCTION: gst_caps_features_new_valist ( feature1 varargs -- a )", "EXTERN: \"C\" void * gst_caps_features_new_valist( char * feature1, void * varargs );", "	( feature1 varargs -- )" );
	swigFunction( "c-function gst_caps_features_new_id gst_caps_features_new_id n ... -- a", "FUNCTION: gst_caps_features_new_id ( feature1  -- a )", "EXTERN: \"C\" void * gst_caps_features_new_id( n feature1, ...  );", "	( feature1 <noname> -- )" );
	swigFunction( "c-function gst_caps_features_new_id_valist gst_caps_features_new_id_valist n a -- a", "FUNCTION: gst_caps_features_new_id_valist ( feature1 varargs -- a )", "EXTERN: \"C\" void * gst_caps_features_new_id_valist( n feature1, void * varargs );", "	( feature1 varargs -- )" );
	swigFunction( "c-function gst_caps_features_set_parent_refcount gst_caps_features_set_parent_refcount a a -- n", "FUNCTION: gst_caps_features_set_parent_refcount ( features refcount -- n )", "EXTERN: \"C\" int gst_caps_features_set_parent_refcount( void * features, void * refcount );", "	( features refcount -- )" );
	swigFunction( "c-function gst_caps_features_copy gst_caps_features_copy a -- a", "FUNCTION: gst_caps_features_copy ( features -- a )", "EXTERN: \"C\" void * gst_caps_features_copy( void * features );", "	( features -- )" );
	swigFunction( "c-function gst_caps_features_free gst_caps_features_free a -- void", "FUNCTION: gst_caps_features_free ( features -- void )", "EXTERN: \"C\" void gst_caps_features_free( void * features );", "	( features -- )" );
	swigFunction( "c-function gst_caps_features_to_string gst_caps_features_to_string a -- a", "FUNCTION: gst_caps_features_to_string ( features -- a )", "EXTERN: \"C\" void * gst_caps_features_to_string( void * features );", "	( features -- )" );
	swigFunction( "c-function gst_caps_features_from_string gst_caps_features_from_string s -- a", "FUNCTION: gst_caps_features_from_string ( features -- a )", "EXTERN: \"C\" void * gst_caps_features_from_string( char * features );", "	( features -- )" );
	swigFunction( "c-function gst_caps_features_get_size gst_caps_features_get_size a -- u", "FUNCTION: gst_caps_features_get_size ( features -- u )", "EXTERN: \"C\" int gst_caps_features_get_size( void * features );", "	( features -- )" );
	swigFunction( "c-function gst_caps_features_get_nth gst_caps_features_get_nth a u -- s", "FUNCTION: gst_caps_features_get_nth ( features i -- s )", "EXTERN: \"C\" char * gst_caps_features_get_nth( void * features, int i );", "	( features i -- )" );
	swigFunction( "c-function gst_caps_features_get_nth_id gst_caps_features_get_nth_id a u -- n", "FUNCTION: gst_caps_features_get_nth_id ( features i -- n )", "EXTERN: \"C\" n gst_caps_features_get_nth_id( void * features, int i );", "	( features i -- )" );
	swigFunction( "c-function gst_caps_features_contains gst_caps_features_contains a s -- n", "FUNCTION: gst_caps_features_contains ( features feature -- n )", "EXTERN: \"C\" int gst_caps_features_contains( void * features, char * feature );", "	( features feature -- )" );
	swigFunction( "c-function gst_caps_features_contains_id gst_caps_features_contains_id a n -- n", "FUNCTION: gst_caps_features_contains_id ( features feature -- n )", "EXTERN: \"C\" int gst_caps_features_contains_id( void * features, n feature );", "	( features feature -- )" );
	swigFunction( "c-function gst_caps_features_is_equal gst_caps_features_is_equal a a -- n", "FUNCTION: gst_caps_features_is_equal ( features1 features2 -- n )", "EXTERN: \"C\" int gst_caps_features_is_equal( void * features1, void * features2 );", "	( features1 features2 -- )" );
	swigFunction( "c-function gst_caps_features_is_any gst_caps_features_is_any a -- n", "FUNCTION: gst_caps_features_is_any ( features -- n )", "EXTERN: \"C\" int gst_caps_features_is_any( void * features );", "	( features -- )" );
	swigFunction( "c-function gst_caps_features_add gst_caps_features_add a s -- void", "FUNCTION: gst_caps_features_add ( features feature -- void )", "EXTERN: \"C\" void gst_caps_features_add( void * features, char * feature );", "	( features feature -- )" );
	swigFunction( "c-function gst_caps_features_add_id gst_caps_features_add_id a n -- void", "FUNCTION: gst_caps_features_add_id ( features feature -- void )", "EXTERN: \"C\" void gst_caps_features_add_id( void * features, n feature );", "	( features feature -- )" );
	swigFunction( "c-function gst_caps_features_remove gst_caps_features_remove a s -- void", "FUNCTION: gst_caps_features_remove ( features feature -- void )", "EXTERN: \"C\" void gst_caps_features_remove( void * features, char * feature );", "	( features feature -- )" );
	swigFunction( "c-function gst_caps_features_remove_id gst_caps_features_remove_id a n -- void", "FUNCTION: gst_caps_features_remove_id ( features feature -- void )", "EXTERN: \"C\" void gst_caps_features_remove_id( void * features, n feature );", "	( features feature -- )" );
	swigFunction( "c-function gst_child_proxy_get_type gst_child_proxy_get_type  -- u", "FUNCTION: gst_child_proxy_get_type (  -- u )", "EXTERN: \"C\" int gst_child_proxy_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_child_proxy_get_child_by_name gst_child_proxy_get_child_by_name a s -- a", "FUNCTION: gst_child_proxy_get_child_by_name ( parent name -- a )", "EXTERN: \"C\" void * gst_child_proxy_get_child_by_name( void * parent, char * name );", "	( parent name -- )" );
	swigFunction( "c-function gst_child_proxy_get_children_count gst_child_proxy_get_children_count a -- u", "FUNCTION: gst_child_proxy_get_children_count ( parent -- u )", "EXTERN: \"C\" int gst_child_proxy_get_children_count( void * parent );", "	( parent -- )" );
	swigFunction( "c-function gst_child_proxy_get_child_by_index gst_child_proxy_get_child_by_index a u -- a", "FUNCTION: gst_child_proxy_get_child_by_index ( parent index -- a )", "EXTERN: \"C\" void * gst_child_proxy_get_child_by_index( void * parent, int index );", "	( parent index -- )" );
	swigFunction( "c-function gst_child_proxy_lookup gst_child_proxy_lookup a s a a -- n", "FUNCTION: gst_child_proxy_lookup ( object name target pspec -- n )", "EXTERN: \"C\" int gst_child_proxy_lookup( void * object, char * name, void * target, void * pspec );", "	( object name target pspec -- )" );
	swigFunction( "c-function gst_child_proxy_get_property gst_child_proxy_get_property a s a -- void", "FUNCTION: gst_child_proxy_get_property ( object name value -- void )", "EXTERN: \"C\" void gst_child_proxy_get_property( void * object, char * name, void * value );", "	( object name value -- )" );
	swigFunction( "c-function gst_child_proxy_get_valist gst_child_proxy_get_valist a s a -- void", "FUNCTION: gst_child_proxy_get_valist ( object first_property_name var_args -- void )", "EXTERN: \"C\" void gst_child_proxy_get_valist( void * object, char * first_property_name, void * var_args );", "	( object first_property_name var_args -- )" );
	swigFunction( "c-function gst_child_proxy_get gst_child_proxy_get a s ... -- void", "FUNCTION: gst_child_proxy_get ( object first_property_name  -- void )", "EXTERN: \"C\" void gst_child_proxy_get( void * object, char * first_property_name, ...  );", "	( object first_property_name <noname> -- )" );
	swigFunction( "c-function gst_child_proxy_set_property gst_child_proxy_set_property a s a -- void", "FUNCTION: gst_child_proxy_set_property ( object name value -- void )", "EXTERN: \"C\" void gst_child_proxy_set_property( void * object, char * name, void * value );", "	( object name value -- )" );
	swigFunction( "c-function gst_child_proxy_set_valist gst_child_proxy_set_valist a s a -- void", "FUNCTION: gst_child_proxy_set_valist ( object first_property_name var_args -- void )", "EXTERN: \"C\" void gst_child_proxy_set_valist( void * object, char * first_property_name, void * var_args );", "	( object first_property_name var_args -- )" );
	swigFunction( "c-function gst_child_proxy_set gst_child_proxy_set a s ... -- void", "FUNCTION: gst_child_proxy_set ( object first_property_name  -- void )", "EXTERN: \"C\" void gst_child_proxy_set( void * object, char * first_property_name, ...  );", "	( object first_property_name <noname> -- )" );
	swigFunction( "c-function gst_child_proxy_child_added gst_child_proxy_child_added a a s -- void", "FUNCTION: gst_child_proxy_child_added ( parent child name -- void )", "EXTERN: \"C\" void gst_child_proxy_child_added( void * parent, void * child, char * name );", "	( parent child name -- )" );
	swigFunction( "c-function gst_child_proxy_child_removed gst_child_proxy_child_removed a a s -- void", "FUNCTION: gst_child_proxy_child_removed ( parent child name -- void )", "EXTERN: \"C\" void gst_child_proxy_child_removed( void * parent, void * child, char * name );", "	( parent child name -- )" );
	swigFunction( "c-function gst_clock_get_type gst_clock_get_type  -- u", "FUNCTION: gst_clock_get_type (  -- u )", "EXTERN: \"C\" int gst_clock_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_clock_set_resolution gst_clock_set_resolution a ud -- ud", "FUNCTION: gst_clock_set_resolution ( clock resolution -- ud )", "EXTERN: \"C\" long long gst_clock_set_resolution( void * clock, long long resolution );", "	( clock resolution -- )" );
	swigFunction( "c-function gst_clock_get_resolution gst_clock_get_resolution a -- ud", "FUNCTION: gst_clock_get_resolution ( clock -- ud )", "EXTERN: \"C\" long long gst_clock_get_resolution( void * clock );", "	( clock -- )" );
	swigFunction( "c-function gst_clock_get_time gst_clock_get_time a -- ud", "FUNCTION: gst_clock_get_time ( clock -- ud )", "EXTERN: \"C\" long long gst_clock_get_time( void * clock );", "	( clock -- )" );
	swigFunction( "c-function gst_clock_set_calibration gst_clock_set_calibration a ud ud ud ud -- void", "FUNCTION: gst_clock_set_calibration ( clock internal external rate_num rate_denom -- void )", "EXTERN: \"C\" void gst_clock_set_calibration( void * clock, long long internal, long long external, long long rate_num, long long rate_denom );", "	( clock internal external rate_num rate_denom -- )" );
	swigFunction( "c-function gst_clock_get_calibration gst_clock_get_calibration a a a a a -- void", "FUNCTION: gst_clock_get_calibration ( clock internal external rate_num rate_denom -- void )", "EXTERN: \"C\" void gst_clock_get_calibration( void * clock, void * internal, void * external, void * rate_num, void * rate_denom );", "	( clock internal external rate_num rate_denom -- )" );
	swigFunction( "c-function gst_clock_set_master gst_clock_set_master a a -- n", "FUNCTION: gst_clock_set_master ( clock master -- n )", "EXTERN: \"C\" int gst_clock_set_master( void * clock, void * master );", "	( clock master -- )" );
	swigFunction( "c-function gst_clock_get_master gst_clock_get_master a -- a", "FUNCTION: gst_clock_get_master ( clock -- a )", "EXTERN: \"C\" void * gst_clock_get_master( void * clock );", "	( clock -- )" );
	swigFunction( "c-function gst_clock_set_timeout gst_clock_set_timeout a ud -- void", "FUNCTION: gst_clock_set_timeout ( clock timeout -- void )", "EXTERN: \"C\" void gst_clock_set_timeout( void * clock, long long timeout );", "	( clock timeout -- )" );
	swigFunction( "c-function gst_clock_get_timeout gst_clock_get_timeout a -- ud", "FUNCTION: gst_clock_get_timeout ( clock -- ud )", "EXTERN: \"C\" long long gst_clock_get_timeout( void * clock );", "	( clock -- )" );
	swigFunction( "c-function gst_clock_add_observation gst_clock_add_observation a ud ud a -- n", "FUNCTION: gst_clock_add_observation ( clock slave master r_squared -- n )", "EXTERN: \"C\" int gst_clock_add_observation( void * clock, long long slave, long long master, void * r_squared );", "	( clock slave master r_squared -- )" );
	swigFunction( "c-function gst_clock_add_observation_unapplied gst_clock_add_observation_unapplied a ud ud a a a a a -- n", "FUNCTION: gst_clock_add_observation_unapplied ( clock slave master r_squared internal external rate_num rate_denom -- n )", "EXTERN: \"C\" int gst_clock_add_observation_unapplied( void * clock, long long slave, long long master, void * r_squared, void * internal, void * external, void * rate_num, void * rate_denom );", "	( clock slave master r_squared internal external rate_num rate_denom -- )" );
	swigFunction( "c-function gst_clock_get_internal_time gst_clock_get_internal_time a -- ud", "FUNCTION: gst_clock_get_internal_time ( clock -- ud )", "EXTERN: \"C\" long long gst_clock_get_internal_time( void * clock );", "	( clock -- )" );
	swigFunction( "c-function gst_clock_adjust_unlocked gst_clock_adjust_unlocked a ud -- ud", "FUNCTION: gst_clock_adjust_unlocked ( clock internal -- ud )", "EXTERN: \"C\" long long gst_clock_adjust_unlocked( void * clock, long long internal );", "	( clock internal -- )" );
	swigFunction( "c-function gst_clock_adjust_with_calibration gst_clock_adjust_with_calibration a ud ud ud ud ud -- ud", "FUNCTION: gst_clock_adjust_with_calibration ( clock internal_target cinternal cexternal cnum cdenom -- ud )", "EXTERN: \"C\" long long gst_clock_adjust_with_calibration( void * clock, long long internal_target, long long cinternal, long long cexternal, long long cnum, long long cdenom );", "	( clock internal_target cinternal cexternal cnum cdenom -- )" );
	swigFunction( "c-function gst_clock_unadjust_with_calibration gst_clock_unadjust_with_calibration a ud ud ud ud ud -- ud", "FUNCTION: gst_clock_unadjust_with_calibration ( clock external_target cinternal cexternal cnum cdenom -- ud )", "EXTERN: \"C\" long long gst_clock_unadjust_with_calibration( void * clock, long long external_target, long long cinternal, long long cexternal, long long cnum, long long cdenom );", "	( clock external_target cinternal cexternal cnum cdenom -- )" );
	swigFunction( "c-function gst_clock_unadjust_unlocked gst_clock_unadjust_unlocked a ud -- ud", "FUNCTION: gst_clock_unadjust_unlocked ( clock external -- ud )", "EXTERN: \"C\" long long gst_clock_unadjust_unlocked( void * clock, long long external );", "	( clock external -- )" );
	swigFunction( "c-function gst_clock_wait_for_sync gst_clock_wait_for_sync a ud -- n", "FUNCTION: gst_clock_wait_for_sync ( clock timeout -- n )", "EXTERN: \"C\" int gst_clock_wait_for_sync( void * clock, long long timeout );", "	( clock timeout -- )" );
	swigFunction( "c-function gst_clock_is_synced gst_clock_is_synced a -- n", "FUNCTION: gst_clock_is_synced ( clock -- n )", "EXTERN: \"C\" int gst_clock_is_synced( void * clock );", "	( clock -- )" );
	swigFunction( "c-function gst_clock_set_synced gst_clock_set_synced a n -- void", "FUNCTION: gst_clock_set_synced ( clock synced -- void )", "EXTERN: \"C\" void gst_clock_set_synced( void * clock, int synced );", "	( clock synced -- )" );
	swigFunction( "c-function gst_clock_new_single_shot_id gst_clock_new_single_shot_id a ud -- a", "FUNCTION: gst_clock_new_single_shot_id ( clock time -- a )", "EXTERN: \"C\" void * gst_clock_new_single_shot_id( void * clock, long long time );", "	( clock time -- )" );
	swigFunction( "c-function gst_clock_new_periodic_id gst_clock_new_periodic_id a ud ud -- a", "FUNCTION: gst_clock_new_periodic_id ( clock start_time interval -- a )", "EXTERN: \"C\" void * gst_clock_new_periodic_id( void * clock, long long start_time, long long interval );", "	( clock start_time interval -- )" );
	swigFunction( "c-function gst_clock_id_ref gst_clock_id_ref a -- a", "FUNCTION: gst_clock_id_ref ( id -- a )", "EXTERN: \"C\" void * gst_clock_id_ref( void * id );", "	( id -- )" );
	swigFunction( "c-function gst_clock_id_unref gst_clock_id_unref a -- void", "FUNCTION: gst_clock_id_unref ( id -- void )", "EXTERN: \"C\" void gst_clock_id_unref( void * id );", "	( id -- )" );
	swigFunction( "c-function gst_clock_id_compare_func gst_clock_id_compare_func a a -- n", "FUNCTION: gst_clock_id_compare_func ( id1 id2 -- n )", "EXTERN: \"C\" int gst_clock_id_compare_func( void * id1, void * id2 );", "	( id1 id2 -- )" );
	swigFunction( "c-function gst_clock_id_get_time gst_clock_id_get_time a -- ud", "FUNCTION: gst_clock_id_get_time ( id -- ud )", "EXTERN: \"C\" long long gst_clock_id_get_time( void * id );", "	( id -- )" );
	swigFunction( "c-function gst_clock_id_wait gst_clock_id_wait a a -- n", "FUNCTION: gst_clock_id_wait ( id jitter -- n )", "EXTERN: \"C\" int gst_clock_id_wait( void * id, void * jitter );", "	( id jitter -- )" );
	swigFunction( "c-function gst_clock_id_wait_async gst_clock_id_wait_async a a a a -- n", "FUNCTION: gst_clock_id_wait_async ( id func user_data destroy_data -- n )", "EXTERN: \"C\" int gst_clock_id_wait_async( void * id, void * func, void * user_data, void * destroy_data );", "	( id func user_data destroy_data -- )" );
	swigFunction( "c-function gst_clock_id_unschedule gst_clock_id_unschedule a -- void", "FUNCTION: gst_clock_id_unschedule ( id -- void )", "EXTERN: \"C\" void gst_clock_id_unschedule( void * id );", "	( id -- )" );
	swigFunction( "c-function gst_clock_single_shot_id_reinit gst_clock_single_shot_id_reinit a a ud -- n", "FUNCTION: gst_clock_single_shot_id_reinit ( clock id time -- n )", "EXTERN: \"C\" int gst_clock_single_shot_id_reinit( void * clock, void * id, long long time );", "	( clock id time -- )" );
	swigFunction( "c-function gst_clock_periodic_id_reinit gst_clock_periodic_id_reinit a a ud ud -- n", "FUNCTION: gst_clock_periodic_id_reinit ( clock id start_time interval -- n )", "EXTERN: \"C\" int gst_clock_periodic_id_reinit( void * clock, void * id, long long start_time, long long interval );", "	( clock id start_time interval -- )" );
	swigFunction( "c-function gst_control_source_get_type gst_control_source_get_type  -- u", "FUNCTION: gst_control_source_get_type (  -- u )", "EXTERN: \"C\" int gst_control_source_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_control_source_get_value gst_control_source_get_value a ud a -- n", "FUNCTION: gst_control_source_get_value ( self timestamp value -- n )", "EXTERN: \"C\" int gst_control_source_get_value( void * self, long long timestamp, void * value );", "	( self timestamp value -- )" );
	swigFunction( "c-function gst_control_source_get_value_array gst_control_source_get_value_array a ud ud u a -- n", "FUNCTION: gst_control_source_get_value_array ( self timestamp interval n_values values -- n )", "EXTERN: \"C\" int gst_control_source_get_value_array( void * self, long long timestamp, long long interval, int n_values, void * values );", "	( self timestamp interval n_values values -- )" );
	swigFunction( "c-function gst_date_time_get_type gst_date_time_get_type  -- u", "FUNCTION: gst_date_time_get_type (  -- u )", "EXTERN: \"C\" int gst_date_time_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_date_time_has_year gst_date_time_has_year a -- n", "FUNCTION: gst_date_time_has_year ( datetime -- n )", "EXTERN: \"C\" int gst_date_time_has_year( void * datetime );", "	( datetime -- )" );
	swigFunction( "c-function gst_date_time_has_month gst_date_time_has_month a -- n", "FUNCTION: gst_date_time_has_month ( datetime -- n )", "EXTERN: \"C\" int gst_date_time_has_month( void * datetime );", "	( datetime -- )" );
	swigFunction( "c-function gst_date_time_has_day gst_date_time_has_day a -- n", "FUNCTION: gst_date_time_has_day ( datetime -- n )", "EXTERN: \"C\" int gst_date_time_has_day( void * datetime );", "	( datetime -- )" );
	swigFunction( "c-function gst_date_time_has_time gst_date_time_has_time a -- n", "FUNCTION: gst_date_time_has_time ( datetime -- n )", "EXTERN: \"C\" int gst_date_time_has_time( void * datetime );", "	( datetime -- )" );
	swigFunction( "c-function gst_date_time_has_second gst_date_time_has_second a -- n", "FUNCTION: gst_date_time_has_second ( datetime -- n )", "EXTERN: \"C\" int gst_date_time_has_second( void * datetime );", "	( datetime -- )" );
	swigFunction( "c-function gst_date_time_get_year gst_date_time_get_year a -- n", "FUNCTION: gst_date_time_get_year ( datetime -- n )", "EXTERN: \"C\" int gst_date_time_get_year( void * datetime );", "	( datetime -- )" );
	swigFunction( "c-function gst_date_time_get_month gst_date_time_get_month a -- n", "FUNCTION: gst_date_time_get_month ( datetime -- n )", "EXTERN: \"C\" int gst_date_time_get_month( void * datetime );", "	( datetime -- )" );
	swigFunction( "c-function gst_date_time_get_day gst_date_time_get_day a -- n", "FUNCTION: gst_date_time_get_day ( datetime -- n )", "EXTERN: \"C\" int gst_date_time_get_day( void * datetime );", "	( datetime -- )" );
	swigFunction( "c-function gst_date_time_get_hour gst_date_time_get_hour a -- n", "FUNCTION: gst_date_time_get_hour ( datetime -- n )", "EXTERN: \"C\" int gst_date_time_get_hour( void * datetime );", "	( datetime -- )" );
	swigFunction( "c-function gst_date_time_get_minute gst_date_time_get_minute a -- n", "FUNCTION: gst_date_time_get_minute ( datetime -- n )", "EXTERN: \"C\" int gst_date_time_get_minute( void * datetime );", "	( datetime -- )" );
	swigFunction( "c-function gst_date_time_get_second gst_date_time_get_second a -- n", "FUNCTION: gst_date_time_get_second ( datetime -- n )", "EXTERN: \"C\" int gst_date_time_get_second( void * datetime );", "	( datetime -- )" );
	swigFunction( "c-function gst_date_time_get_microsecond gst_date_time_get_microsecond a -- n", "FUNCTION: gst_date_time_get_microsecond ( datetime -- n )", "EXTERN: \"C\" int gst_date_time_get_microsecond( void * datetime );", "	( datetime -- )" );
	swigFunction( "c-function gst_date_time_get_time_zone_offset gst_date_time_get_time_zone_offset a -- r", "FUNCTION: gst_date_time_get_time_zone_offset ( datetime -- r )", "EXTERN: \"C\" float gst_date_time_get_time_zone_offset( void * datetime );", "	( datetime -- )" );
	swigFunction( "c-function gst_date_time_new_from_unix_epoch_local_time gst_date_time_new_from_unix_epoch_local_time d -- a", "FUNCTION: gst_date_time_new_from_unix_epoch_local_time ( secs -- a )", "EXTERN: \"C\" void * gst_date_time_new_from_unix_epoch_local_time( long long secs );", "	( secs -- )" );
	swigFunction( "c-function gst_date_time_new_from_unix_epoch_utc gst_date_time_new_from_unix_epoch_utc d -- a", "FUNCTION: gst_date_time_new_from_unix_epoch_utc ( secs -- a )", "EXTERN: \"C\" void * gst_date_time_new_from_unix_epoch_utc( long long secs );", "	( secs -- )" );
	swigFunction( "c-function gst_date_time_new_local_time gst_date_time_new_local_time n n n n n r -- a", "FUNCTION: gst_date_time_new_local_time ( year month day hour minute seconds -- a )", "EXTERN: \"C\" void * gst_date_time_new_local_time( int year, int month, int day, int hour, int minute, double seconds );", "	( year month day hour minute seconds -- )" );
	swigFunction( "c-function gst_date_time_new_y gst_date_time_new_y n -- a", "FUNCTION: gst_date_time_new_y ( year -- a )", "EXTERN: \"C\" void * gst_date_time_new_y( int year );", "	( year -- )" );
	swigFunction( "c-function gst_date_time_new_ym gst_date_time_new_ym n n -- a", "FUNCTION: gst_date_time_new_ym ( year month -- a )", "EXTERN: \"C\" void * gst_date_time_new_ym( int year, int month );", "	( year month -- )" );
	swigFunction( "c-function gst_date_time_new_ymd gst_date_time_new_ymd n n n -- a", "FUNCTION: gst_date_time_new_ymd ( year month day -- a )", "EXTERN: \"C\" void * gst_date_time_new_ymd( int year, int month, int day );", "	( year month day -- )" );
	swigFunction( "c-function gst_date_time_new gst_date_time_new r n n n n n r -- a", "FUNCTION: gst_date_time_new ( tzoffset year month day hour minute seconds -- a )", "EXTERN: \"C\" void * gst_date_time_new( float tzoffset, int year, int month, int day, int hour, int minute, double seconds );", "	( tzoffset year month day hour minute seconds -- )" );
	swigFunction( "c-function gst_date_time_new_now_local_time gst_date_time_new_now_local_time  -- a", "FUNCTION: gst_date_time_new_now_local_time (  -- a )", "EXTERN: \"C\" void * gst_date_time_new_now_local_time(  );", "	( -- )" );
	swigFunction( "c-function gst_date_time_new_now_utc gst_date_time_new_now_utc  -- a", "FUNCTION: gst_date_time_new_now_utc (  -- a )", "EXTERN: \"C\" void * gst_date_time_new_now_utc(  );", "	( -- )" );
	swigFunction( "c-function gst_date_time_to_iso8601_string gst_date_time_to_iso8601_string a -- a", "FUNCTION: gst_date_time_to_iso8601_string ( datetime -- a )", "EXTERN: \"C\" void * gst_date_time_to_iso8601_string( void * datetime );", "	( datetime -- )" );
	swigFunction( "c-function gst_date_time_new_from_iso8601_string gst_date_time_new_from_iso8601_string s -- a", "FUNCTION: gst_date_time_new_from_iso8601_string ( string -- a )", "EXTERN: \"C\" void * gst_date_time_new_from_iso8601_string( char * string );", "	( string -- )" );
	swigFunction( "c-function gst_date_time_to_g_date_time gst_date_time_to_g_date_time a -- a", "FUNCTION: gst_date_time_to_g_date_time ( datetime -- a )", "EXTERN: \"C\" void * gst_date_time_to_g_date_time( void * datetime );", "	( datetime -- )" );
	swigFunction( "c-function gst_date_time_new_from_g_date_time gst_date_time_new_from_g_date_time a -- a", "FUNCTION: gst_date_time_new_from_g_date_time ( dt -- a )", "EXTERN: \"C\" void * gst_date_time_new_from_g_date_time( void * dt );", "	( dt -- )" );
	swigFunction( "c-function gst_date_time_ref gst_date_time_ref a -- a", "FUNCTION: gst_date_time_ref ( datetime -- a )", "EXTERN: \"C\" void * gst_date_time_ref( void * datetime );", "	( datetime -- )" );
	swigFunction( "c-function gst_date_time_unref gst_date_time_unref a -- void", "FUNCTION: gst_date_time_unref ( datetime -- void )", "EXTERN: \"C\" void gst_date_time_unref( void * datetime );", "	( datetime -- )" );
	swigFunction( "c-function gst_debug_bin_to_dot_data gst_debug_bin_to_dot_data a n -- a", "FUNCTION: gst_debug_bin_to_dot_data ( bin details -- a )", "EXTERN: \"C\" void * gst_debug_bin_to_dot_data( void * bin, int details );", "	( bin details -- )" );
	swigFunction( "c-function gst_debug_bin_to_dot_file gst_debug_bin_to_dot_file a n s -- void", "FUNCTION: gst_debug_bin_to_dot_file ( bin details file_name -- void )", "EXTERN: \"C\" void gst_debug_bin_to_dot_file( void * bin, int details, char * file_name );", "	( bin details file_name -- )" );
	swigFunction( "c-function gst_debug_bin_to_dot_file_with_ts gst_debug_bin_to_dot_file_with_ts a n s -- void", "FUNCTION: gst_debug_bin_to_dot_file_with_ts ( bin details file_name -- void )", "EXTERN: \"C\" void gst_debug_bin_to_dot_file_with_ts( void * bin, int details, char * file_name );", "	( bin details file_name -- )" );
	swigFunction( "c-function gst_device_get_type gst_device_get_type  -- u", "FUNCTION: gst_device_get_type (  -- u )", "EXTERN: \"C\" int gst_device_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_device_create_element gst_device_create_element a s -- a", "FUNCTION: gst_device_create_element ( device name -- a )", "EXTERN: \"C\" void * gst_device_create_element( void * device, char * name );", "	( device name -- )" );
	swigFunction( "c-function gst_device_get_caps gst_device_get_caps a -- a", "FUNCTION: gst_device_get_caps ( device -- a )", "EXTERN: \"C\" void * gst_device_get_caps( void * device );", "	( device -- )" );
	swigFunction( "c-function gst_device_get_display_name gst_device_get_display_name a -- a", "FUNCTION: gst_device_get_display_name ( device -- a )", "EXTERN: \"C\" void * gst_device_get_display_name( void * device );", "	( device -- )" );
	swigFunction( "c-function gst_device_get_device_class gst_device_get_device_class a -- a", "FUNCTION: gst_device_get_device_class ( device -- a )", "EXTERN: \"C\" void * gst_device_get_device_class( void * device );", "	( device -- )" );
	swigFunction( "c-function gst_device_get_properties gst_device_get_properties a -- a", "FUNCTION: gst_device_get_properties ( device -- a )", "EXTERN: \"C\" void * gst_device_get_properties( void * device );", "	( device -- )" );
	swigFunction( "c-function gst_device_reconfigure_element gst_device_reconfigure_element a a -- n", "FUNCTION: gst_device_reconfigure_element ( device element -- n )", "EXTERN: \"C\" int gst_device_reconfigure_element( void * device, void * element );", "	( device element -- )" );
	swigFunction( "c-function gst_device_has_classesv gst_device_has_classesv a a -- n", "FUNCTION: gst_device_has_classesv ( device classes -- n )", "EXTERN: \"C\" int gst_device_has_classesv( void * device, void * classes );", "	( device classes -- )" );
	swigFunction( "c-function gst_device_has_classes gst_device_has_classes a s -- n", "FUNCTION: gst_device_has_classes ( device classes -- n )", "EXTERN: \"C\" int gst_device_has_classes( void * device, char * classes );", "	( device classes -- )" );
	swigFunction( "c-function gst_device_monitor_get_type gst_device_monitor_get_type  -- u", "FUNCTION: gst_device_monitor_get_type (  -- u )", "EXTERN: \"C\" int gst_device_monitor_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_device_monitor_new gst_device_monitor_new  -- a", "FUNCTION: gst_device_monitor_new (  -- a )", "EXTERN: \"C\" void * gst_device_monitor_new(  );", "	( -- )" );
	swigFunction( "c-function gst_device_monitor_get_bus gst_device_monitor_get_bus a -- a", "FUNCTION: gst_device_monitor_get_bus ( monitor -- a )", "EXTERN: \"C\" void * gst_device_monitor_get_bus( void * monitor );", "	( monitor -- )" );
	swigFunction( "c-function gst_device_monitor_get_devices gst_device_monitor_get_devices a -- a", "FUNCTION: gst_device_monitor_get_devices ( monitor -- a )", "EXTERN: \"C\" void * gst_device_monitor_get_devices( void * monitor );", "	( monitor -- )" );
	swigFunction( "c-function gst_device_monitor_start gst_device_monitor_start a -- n", "FUNCTION: gst_device_monitor_start ( monitor -- n )", "EXTERN: \"C\" int gst_device_monitor_start( void * monitor );", "	( monitor -- )" );
	swigFunction( "c-function gst_device_monitor_stop gst_device_monitor_stop a -- void", "FUNCTION: gst_device_monitor_stop ( monitor -- void )", "EXTERN: \"C\" void gst_device_monitor_stop( void * monitor );", "	( monitor -- )" );
	swigFunction( "c-function gst_device_monitor_add_filter gst_device_monitor_add_filter a s a -- u", "FUNCTION: gst_device_monitor_add_filter ( monitor classes caps -- u )", "EXTERN: \"C\" int gst_device_monitor_add_filter( void * monitor, char * classes, void * caps );", "	( monitor classes caps -- )" );
	swigFunction( "c-function gst_device_monitor_remove_filter gst_device_monitor_remove_filter a u -- n", "FUNCTION: gst_device_monitor_remove_filter ( monitor filter_id -- n )", "EXTERN: \"C\" int gst_device_monitor_remove_filter( void * monitor, int filter_id );", "	( monitor filter_id -- )" );
	swigFunction( "c-function gst_device_monitor_get_providers gst_device_monitor_get_providers a -- a", "FUNCTION: gst_device_monitor_get_providers ( monitor -- a )", "EXTERN: \"C\" void * gst_device_monitor_get_providers( void * monitor );", "	( monitor -- )" );
	swigFunction( "c-function gst_device_monitor_set_show_all_devices gst_device_monitor_set_show_all_devices a n -- void", "FUNCTION: gst_device_monitor_set_show_all_devices ( monitor show_all -- void )", "EXTERN: \"C\" void gst_device_monitor_set_show_all_devices( void * monitor, int show_all );", "	( monitor show_all -- )" );
	swigFunction( "c-function gst_device_monitor_get_show_all_devices gst_device_monitor_get_show_all_devices a -- n", "FUNCTION: gst_device_monitor_get_show_all_devices ( monitor -- n )", "EXTERN: \"C\" int gst_device_monitor_get_show_all_devices( void * monitor );", "	( monitor -- )" );
	swigFunction( "c-function gst_device_provider_get_type gst_device_provider_get_type  -- u", "FUNCTION: gst_device_provider_get_type (  -- u )", "EXTERN: \"C\" int gst_device_provider_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_device_provider_get_devices gst_device_provider_get_devices a -- a", "FUNCTION: gst_device_provider_get_devices ( provider -- a )", "EXTERN: \"C\" void * gst_device_provider_get_devices( void * provider );", "	( provider -- )" );
	swigFunction( "c-function gst_device_provider_start gst_device_provider_start a -- n", "FUNCTION: gst_device_provider_start ( provider -- n )", "EXTERN: \"C\" int gst_device_provider_start( void * provider );", "	( provider -- )" );
	swigFunction( "c-function gst_device_provider_stop gst_device_provider_stop a -- void", "FUNCTION: gst_device_provider_stop ( provider -- void )", "EXTERN: \"C\" void gst_device_provider_stop( void * provider );", "	( provider -- )" );
	swigFunction( "c-function gst_device_provider_can_monitor gst_device_provider_can_monitor a -- n", "FUNCTION: gst_device_provider_can_monitor ( provider -- n )", "EXTERN: \"C\" int gst_device_provider_can_monitor( void * provider );", "	( provider -- )" );
	swigFunction( "c-function gst_device_provider_get_bus gst_device_provider_get_bus a -- a", "FUNCTION: gst_device_provider_get_bus ( provider -- a )", "EXTERN: \"C\" void * gst_device_provider_get_bus( void * provider );", "	( provider -- )" );
	swigFunction( "c-function gst_device_provider_device_add gst_device_provider_device_add a a -- void", "FUNCTION: gst_device_provider_device_add ( provider device -- void )", "EXTERN: \"C\" void gst_device_provider_device_add( void * provider, void * device );", "	( provider device -- )" );
	swigFunction( "c-function gst_device_provider_device_remove gst_device_provider_device_remove a a -- void", "FUNCTION: gst_device_provider_device_remove ( provider device -- void )", "EXTERN: \"C\" void gst_device_provider_device_remove( void * provider, void * device );", "	( provider device -- )" );
	swigFunction( "c-function gst_device_provider_get_hidden_providers gst_device_provider_get_hidden_providers a -- a", "FUNCTION: gst_device_provider_get_hidden_providers ( provider -- a )", "EXTERN: \"C\" void * gst_device_provider_get_hidden_providers( void * provider );", "	( provider -- )" );
	swigFunction( "c-function gst_device_provider_hide_provider gst_device_provider_hide_provider a s -- void", "FUNCTION: gst_device_provider_hide_provider ( provider name -- void )", "EXTERN: \"C\" void gst_device_provider_hide_provider( void * provider, char * name );", "	( provider name -- )" );
	swigFunction( "c-function gst_device_provider_unhide_provider gst_device_provider_unhide_provider a s -- void", "FUNCTION: gst_device_provider_unhide_provider ( provider name -- void )", "EXTERN: \"C\" void gst_device_provider_unhide_provider( void * provider, char * name );", "	( provider name -- )" );
	swigFunction( "c-function gst_device_provider_get_metadata gst_device_provider_get_metadata a s -- s", "FUNCTION: gst_device_provider_get_metadata ( provider key -- s )", "EXTERN: \"C\" char * gst_device_provider_get_metadata( void * provider, char * key );", "	( provider key -- )" );
	swigFunction( "c-function gst_device_provider_class_set_metadata gst_device_provider_class_set_metadata a s s s s -- void", "FUNCTION: gst_device_provider_class_set_metadata ( klass longname classification description author -- void )", "EXTERN: \"C\" void gst_device_provider_class_set_metadata( void * klass, char * longname, char * classification, char * description, char * author );", "	( klass longname classification description author -- )" );
	swigFunction( "c-function gst_device_provider_class_set_static_metadata gst_device_provider_class_set_static_metadata a s s s s -- void", "FUNCTION: gst_device_provider_class_set_static_metadata ( klass longname classification description author -- void )", "EXTERN: \"C\" void gst_device_provider_class_set_static_metadata( void * klass, char * longname, char * classification, char * description, char * author );", "	( klass longname classification description author -- )" );
	swigFunction( "c-function gst_device_provider_class_add_metadata gst_device_provider_class_add_metadata a s s -- void", "FUNCTION: gst_device_provider_class_add_metadata ( klass key value -- void )", "EXTERN: \"C\" void gst_device_provider_class_add_metadata( void * klass, char * key, char * value );", "	( klass key value -- )" );
	swigFunction( "c-function gst_device_provider_class_add_static_metadata gst_device_provider_class_add_static_metadata a s s -- void", "FUNCTION: gst_device_provider_class_add_static_metadata ( klass key value -- void )", "EXTERN: \"C\" void gst_device_provider_class_add_static_metadata( void * klass, char * key, char * value );", "	( klass key value -- )" );
	swigFunction( "c-function gst_device_provider_class_get_metadata gst_device_provider_class_get_metadata a s -- s", "FUNCTION: gst_device_provider_class_get_metadata ( klass key -- s )", "EXTERN: \"C\" char * gst_device_provider_class_get_metadata( void * klass, char * key );", "	( klass key -- )" );
	swigFunction( "c-function gst_device_provider_get_factory gst_device_provider_get_factory a -- a", "FUNCTION: gst_device_provider_get_factory ( provider -- a )", "EXTERN: \"C\" void * gst_device_provider_get_factory( void * provider );", "	( provider -- )" );
	swigFunction( "c-function gst_make_element_message_details gst_make_element_message_details s ... -- a", "FUNCTION: gst_make_element_message_details ( name  -- a )", "EXTERN: \"C\" void * gst_make_element_message_details( char * name, ...  );", "	( name <noname> -- )" );
	swigFunction( "c-function gst_element_class_add_pad_template gst_element_class_add_pad_template a a -- void", "FUNCTION: gst_element_class_add_pad_template ( klass templ -- void )", "EXTERN: \"C\" void gst_element_class_add_pad_template( void * klass, void * templ );", "	( klass templ -- )" );
	swigFunction( "c-function gst_element_class_add_static_pad_template gst_element_class_add_static_pad_template a a -- void", "FUNCTION: gst_element_class_add_static_pad_template ( klass static_templ -- void )", "EXTERN: \"C\" void gst_element_class_add_static_pad_template( void * klass, void * static_templ );", "	( klass static_templ -- )" );
	swigFunction( "c-function gst_element_class_add_static_pad_template_with_gtype gst_element_class_add_static_pad_template_with_gtype a a u -- void", "FUNCTION: gst_element_class_add_static_pad_template_with_gtype ( klass static_templ pad_type -- void )", "EXTERN: \"C\" void gst_element_class_add_static_pad_template_with_gtype( void * klass, void * static_templ, int pad_type );", "	( klass static_templ pad_type -- )" );
	swigFunction( "c-function gst_element_class_get_pad_template gst_element_class_get_pad_template a s -- a", "FUNCTION: gst_element_class_get_pad_template ( element_class name -- a )", "EXTERN: \"C\" void * gst_element_class_get_pad_template( void * element_class, char * name );", "	( element_class name -- )" );
	swigFunction( "c-function gst_element_class_get_pad_template_list gst_element_class_get_pad_template_list a -- a", "FUNCTION: gst_element_class_get_pad_template_list ( element_class -- a )", "EXTERN: \"C\" void * gst_element_class_get_pad_template_list( void * element_class );", "	( element_class -- )" );
	swigFunction( "c-function gst_element_class_set_metadata gst_element_class_set_metadata a s s s s -- void", "FUNCTION: gst_element_class_set_metadata ( klass longname classification description author -- void )", "EXTERN: \"C\" void gst_element_class_set_metadata( void * klass, char * longname, char * classification, char * description, char * author );", "	( klass longname classification description author -- )" );
	swigFunction( "c-function gst_element_class_set_static_metadata gst_element_class_set_static_metadata a s s s s -- void", "FUNCTION: gst_element_class_set_static_metadata ( klass longname classification description author -- void )", "EXTERN: \"C\" void gst_element_class_set_static_metadata( void * klass, char * longname, char * classification, char * description, char * author );", "	( klass longname classification description author -- )" );
	swigFunction( "c-function gst_element_class_add_metadata gst_element_class_add_metadata a s s -- void", "FUNCTION: gst_element_class_add_metadata ( klass key value -- void )", "EXTERN: \"C\" void gst_element_class_add_metadata( void * klass, char * key, char * value );", "	( klass key value -- )" );
	swigFunction( "c-function gst_element_class_add_static_metadata gst_element_class_add_static_metadata a s s -- void", "FUNCTION: gst_element_class_add_static_metadata ( klass key value -- void )", "EXTERN: \"C\" void gst_element_class_add_static_metadata( void * klass, char * key, char * value );", "	( klass key value -- )" );
	swigFunction( "c-function gst_element_class_get_metadata gst_element_class_get_metadata a s -- s", "FUNCTION: gst_element_class_get_metadata ( klass key -- s )", "EXTERN: \"C\" char * gst_element_class_get_metadata( void * klass, char * key );", "	( klass key -- )" );
	swigFunction( "c-function gst_element_get_type gst_element_get_type  -- u", "FUNCTION: gst_element_get_type (  -- u )", "EXTERN: \"C\" int gst_element_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_element_provide_clock gst_element_provide_clock a -- a", "FUNCTION: gst_element_provide_clock ( element -- a )", "EXTERN: \"C\" void * gst_element_provide_clock( void * element );", "	( element -- )" );
	swigFunction( "c-function gst_element_get_clock gst_element_get_clock a -- a", "FUNCTION: gst_element_get_clock ( element -- a )", "EXTERN: \"C\" void * gst_element_get_clock( void * element );", "	( element -- )" );
	swigFunction( "c-function gst_element_set_clock gst_element_set_clock a a -- n", "FUNCTION: gst_element_set_clock ( element clock -- n )", "EXTERN: \"C\" int gst_element_set_clock( void * element, void * clock );", "	( element clock -- )" );
	swigFunction( "c-function gst_element_set_base_time gst_element_set_base_time a ud -- void", "FUNCTION: gst_element_set_base_time ( element time -- void )", "EXTERN: \"C\" void gst_element_set_base_time( void * element, long long time );", "	( element time -- )" );
	swigFunction( "c-function gst_element_get_base_time gst_element_get_base_time a -- ud", "FUNCTION: gst_element_get_base_time ( element -- ud )", "EXTERN: \"C\" long long gst_element_get_base_time( void * element );", "	( element -- )" );
	swigFunction( "c-function gst_element_set_start_time gst_element_set_start_time a ud -- void", "FUNCTION: gst_element_set_start_time ( element time -- void )", "EXTERN: \"C\" void gst_element_set_start_time( void * element, long long time );", "	( element time -- )" );
	swigFunction( "c-function gst_element_get_start_time gst_element_get_start_time a -- ud", "FUNCTION: gst_element_get_start_time ( element -- ud )", "EXTERN: \"C\" long long gst_element_get_start_time( void * element );", "	( element -- )" );
	swigFunction( "c-function gst_element_set_bus gst_element_set_bus a a -- void", "FUNCTION: gst_element_set_bus ( element bus -- void )", "EXTERN: \"C\" void gst_element_set_bus( void * element, void * bus );", "	( element bus -- )" );
	swigFunction( "c-function gst_element_get_bus gst_element_get_bus a -- a", "FUNCTION: gst_element_get_bus ( element -- a )", "EXTERN: \"C\" void * gst_element_get_bus( void * element );", "	( element -- )" );
	swigFunction( "c-function gst_element_set_context gst_element_set_context a a -- void", "FUNCTION: gst_element_set_context ( element context -- void )", "EXTERN: \"C\" void gst_element_set_context( void * element, void * context );", "	( element context -- )" );
	swigFunction( "c-function gst_element_get_contexts gst_element_get_contexts a -- a", "FUNCTION: gst_element_get_contexts ( element -- a )", "EXTERN: \"C\" void * gst_element_get_contexts( void * element );", "	( element -- )" );
	swigFunction( "c-function gst_element_get_context gst_element_get_context a s -- a", "FUNCTION: gst_element_get_context ( element context_type -- a )", "EXTERN: \"C\" void * gst_element_get_context( void * element, char * context_type );", "	( element context_type -- )" );
	swigFunction( "c-function gst_element_get_context_unlocked gst_element_get_context_unlocked a s -- a", "FUNCTION: gst_element_get_context_unlocked ( element context_type -- a )", "EXTERN: \"C\" void * gst_element_get_context_unlocked( void * element, char * context_type );", "	( element context_type -- )" );
	swigFunction( "c-function gst_element_add_pad gst_element_add_pad a a -- n", "FUNCTION: gst_element_add_pad ( element pad -- n )", "EXTERN: \"C\" int gst_element_add_pad( void * element, void * pad );", "	( element pad -- )" );
	swigFunction( "c-function gst_element_remove_pad gst_element_remove_pad a a -- n", "FUNCTION: gst_element_remove_pad ( element pad -- n )", "EXTERN: \"C\" int gst_element_remove_pad( void * element, void * pad );", "	( element pad -- )" );
	swigFunction( "c-function gst_element_no_more_pads gst_element_no_more_pads a -- void", "FUNCTION: gst_element_no_more_pads ( element -- void )", "EXTERN: \"C\" void gst_element_no_more_pads( void * element );", "	( element -- )" );
	swigFunction( "c-function gst_element_get_static_pad gst_element_get_static_pad a s -- a", "FUNCTION: gst_element_get_static_pad ( element name -- a )", "EXTERN: \"C\" void * gst_element_get_static_pad( void * element, char * name );", "	( element name -- )" );
	swigFunction( "c-function gst_element_get_request_pad gst_element_get_request_pad a s -- a", "FUNCTION: gst_element_get_request_pad ( element name -- a )", "EXTERN: \"C\" void * gst_element_get_request_pad( void * element, char * name );", "	( element name -- )" );
	swigFunction( "c-function gst_element_request_pad gst_element_request_pad a a s a -- a", "FUNCTION: gst_element_request_pad ( element templ name caps -- a )", "EXTERN: \"C\" void * gst_element_request_pad( void * element, void * templ, char * name, void * caps );", "	( element templ name caps -- )" );
	swigFunction( "c-function gst_element_release_request_pad gst_element_release_request_pad a a -- void", "FUNCTION: gst_element_release_request_pad ( element pad -- void )", "EXTERN: \"C\" void gst_element_release_request_pad( void * element, void * pad );", "	( element pad -- )" );
	swigFunction( "c-function gst_element_iterate_pads gst_element_iterate_pads a -- a", "FUNCTION: gst_element_iterate_pads ( element -- a )", "EXTERN: \"C\" void * gst_element_iterate_pads( void * element );", "	( element -- )" );
	swigFunction( "c-function gst_element_iterate_src_pads gst_element_iterate_src_pads a -- a", "FUNCTION: gst_element_iterate_src_pads ( element -- a )", "EXTERN: \"C\" void * gst_element_iterate_src_pads( void * element );", "	( element -- )" );
	swigFunction( "c-function gst_element_iterate_sink_pads gst_element_iterate_sink_pads a -- a", "FUNCTION: gst_element_iterate_sink_pads ( element -- a )", "EXTERN: \"C\" void * gst_element_iterate_sink_pads( void * element );", "	( element -- )" );
	swigFunction( "c-function gst_element_foreach_sink_pad gst_element_foreach_sink_pad a a a -- n", "FUNCTION: gst_element_foreach_sink_pad ( element func user_data -- n )", "EXTERN: \"C\" int gst_element_foreach_sink_pad( void * element, void * func, void * user_data );", "	( element func user_data -- )" );
	swigFunction( "c-function gst_element_foreach_src_pad gst_element_foreach_src_pad a a a -- n", "FUNCTION: gst_element_foreach_src_pad ( element func user_data -- n )", "EXTERN: \"C\" int gst_element_foreach_src_pad( void * element, void * func, void * user_data );", "	( element func user_data -- )" );
	swigFunction( "c-function gst_element_foreach_pad gst_element_foreach_pad a a a -- n", "FUNCTION: gst_element_foreach_pad ( element func user_data -- n )", "EXTERN: \"C\" int gst_element_foreach_pad( void * element, void * func, void * user_data );", "	( element func user_data -- )" );
	swigFunction( "c-function gst_element_send_event gst_element_send_event a a -- n", "FUNCTION: gst_element_send_event ( element event -- n )", "EXTERN: \"C\" int gst_element_send_event( void * element, void * event );", "	( element event -- )" );
	swigFunction( "c-function gst_element_seek gst_element_seek a r u n n d n d -- n", "FUNCTION: gst_element_seek ( element rate format flags start_type start stop_type stop -- n )", "EXTERN: \"C\" int gst_element_seek( void * element, double rate, int format, int flags, int start_type, long long start, int stop_type, long long stop );", "	( element rate format flags start_type start stop_type stop -- )" );
	swigFunction( "c-function gst_element_query gst_element_query a a -- n", "FUNCTION: gst_element_query ( element query -- n )", "EXTERN: \"C\" int gst_element_query( void * element, void * query );", "	( element query -- )" );
	swigFunction( "c-function gst_element_post_message gst_element_post_message a a -- n", "FUNCTION: gst_element_post_message ( element message -- n )", "EXTERN: \"C\" int gst_element_post_message( void * element, void * message );", "	( element message -- )" );
	swigFunction( "c-function _gst_element_error_printf _gst_element_error_printf s ... -- a", "FUNCTION: _gst_element_error_printf ( format  -- a )", "EXTERN: \"C\" void * _gst_element_error_printf( char * format, ...  );", "	( format <noname> -- )" );
	swigFunction( "c-function gst_element_message_full gst_element_message_full a n n n a a s s n -- void", "FUNCTION: gst_element_message_full ( element type domain code text debug file function line -- void )", "EXTERN: \"C\" void gst_element_message_full( void * element, int type, n domain, int code, void * text, void * debug, char * file, char * function, int line );", "	( element type domain code text debug file function line -- )" );
	swigFunction( "c-function gst_element_message_full_with_details gst_element_message_full_with_details a n n n a a s s n a -- void", "FUNCTION: gst_element_message_full_with_details ( element type domain code text debug file function line structure -- void )", "EXTERN: \"C\" void gst_element_message_full_with_details( void * element, int type, n domain, int code, void * text, void * debug, char * file, char * function, int line, void * structure );", "	( element type domain code text debug file function line structure -- )" );
	swigFunction( "c-function gst_element_is_locked_state gst_element_is_locked_state a -- n", "FUNCTION: gst_element_is_locked_state ( element -- n )", "EXTERN: \"C\" int gst_element_is_locked_state( void * element );", "	( element -- )" );
	swigFunction( "c-function gst_element_set_locked_state gst_element_set_locked_state a n -- n", "FUNCTION: gst_element_set_locked_state ( element locked_state -- n )", "EXTERN: \"C\" int gst_element_set_locked_state( void * element, int locked_state );", "	( element locked_state -- )" );
	swigFunction( "c-function gst_element_sync_state_with_parent gst_element_sync_state_with_parent a -- n", "FUNCTION: gst_element_sync_state_with_parent ( element -- n )", "EXTERN: \"C\" int gst_element_sync_state_with_parent( void * element );", "	( element -- )" );
	swigFunction( "c-function gst_element_get_state gst_element_get_state a a a ud -- n", "FUNCTION: gst_element_get_state ( element state pending timeout -- n )", "EXTERN: \"C\" int gst_element_get_state( void * element, void * state, void * pending, long long timeout );", "	( element state pending timeout -- )" );
	swigFunction( "c-function gst_element_set_state gst_element_set_state a n -- n", "FUNCTION: gst_element_set_state ( element state -- n )", "EXTERN: \"C\" int gst_element_set_state( void * element, int state );", "	( element state -- )" );
	swigFunction( "c-function gst_element_abort_state gst_element_abort_state a -- void", "FUNCTION: gst_element_abort_state ( element -- void )", "EXTERN: \"C\" void gst_element_abort_state( void * element );", "	( element -- )" );
	swigFunction( "c-function gst_element_change_state gst_element_change_state a n -- n", "FUNCTION: gst_element_change_state ( element transition -- n )", "EXTERN: \"C\" int gst_element_change_state( void * element, int transition );", "	( element transition -- )" );
	swigFunction( "c-function gst_element_continue_state gst_element_continue_state a n -- n", "FUNCTION: gst_element_continue_state ( element ret -- n )", "EXTERN: \"C\" int gst_element_continue_state( void * element, int ret );", "	( element ret -- )" );
	swigFunction( "c-function gst_element_lost_state gst_element_lost_state a -- void", "FUNCTION: gst_element_lost_state ( element -- void )", "EXTERN: \"C\" void gst_element_lost_state( void * element );", "	( element -- )" );
	swigFunction( "c-function gst_element_call_async gst_element_call_async a a a a -- void", "FUNCTION: gst_element_call_async ( element func user_data destroy_notify -- void )", "EXTERN: \"C\" void gst_element_call_async( void * element, void * func, void * user_data, void * destroy_notify );", "	( element func user_data destroy_notify -- )" );
	swigFunction( "c-function gst_element_get_factory gst_element_get_factory a -- a", "FUNCTION: gst_element_get_factory ( element -- a )", "EXTERN: \"C\" void * gst_element_get_factory( void * element );", "	( element -- )" );
	swigFunction( "c-function gst_element_add_property_notify_watch gst_element_add_property_notify_watch a s n -- n", "FUNCTION: gst_element_add_property_notify_watch ( element property_name include_value -- n )", "EXTERN: \"C\" n gst_element_add_property_notify_watch( void * element, char * property_name, int include_value );", "	( element property_name include_value -- )" );
	swigFunction( "c-function gst_element_add_property_deep_notify_watch gst_element_add_property_deep_notify_watch a s n -- n", "FUNCTION: gst_element_add_property_deep_notify_watch ( element property_name include_value -- n )", "EXTERN: \"C\" n gst_element_add_property_deep_notify_watch( void * element, char * property_name, int include_value );", "	( element property_name include_value -- )" );
	swigFunction( "c-function gst_element_remove_property_notify_watch gst_element_remove_property_notify_watch a n -- void", "FUNCTION: gst_element_remove_property_notify_watch ( element watch_id -- void )", "EXTERN: \"C\" void gst_element_remove_property_notify_watch( void * element, n watch_id );", "	( element watch_id -- )" );
	swigFunction( "c-function gst_element_get_pad_template gst_element_get_pad_template a s -- a", "FUNCTION: gst_element_get_pad_template ( element name -- a )", "EXTERN: \"C\" void * gst_element_get_pad_template( void * element, char * name );", "	( element name -- )" );
	swigFunction( "c-function gst_element_get_pad_template_list gst_element_get_pad_template_list a -- a", "FUNCTION: gst_element_get_pad_template_list ( element -- a )", "EXTERN: \"C\" void * gst_element_get_pad_template_list( void * element );", "	( element -- )" );
	swigFunction( "c-function gst_element_get_metadata gst_element_get_metadata a s -- s", "FUNCTION: gst_element_get_metadata ( element key -- s )", "EXTERN: \"C\" char * gst_element_get_metadata( void * element, char * key );", "	( element key -- )" );
	swigFunction( "c-function gst_error_get_message gst_error_get_message n n -- a", "FUNCTION: gst_error_get_message ( domain code -- a )", "EXTERN: \"C\" void * gst_error_get_message( n domain, int code );", "	( domain code -- )" );
	swigFunction( "c-function gst_stream_error_quark gst_stream_error_quark  -- n", "FUNCTION: gst_stream_error_quark (  -- n )", "EXTERN: \"C\" n gst_stream_error_quark(  );", "	( -- )" );
	swigFunction( "c-function gst_core_error_quark gst_core_error_quark  -- n", "FUNCTION: gst_core_error_quark (  -- n )", "EXTERN: \"C\" n gst_core_error_quark(  );", "	( -- )" );
	swigFunction( "c-function gst_resource_error_quark gst_resource_error_quark  -- n", "FUNCTION: gst_resource_error_quark (  -- n )", "EXTERN: \"C\" n gst_resource_error_quark(  );", "	( -- )" );
	swigFunction( "c-function gst_library_error_quark gst_library_error_quark  -- n", "FUNCTION: gst_library_error_quark (  -- n )", "EXTERN: \"C\" n gst_library_error_quark(  );", "	( -- )" );
	swigFunction( "c-function gst_event_replace gst_event_replace a a -- n", "FUNCTION: gst_event_replace ( old_event new_event -- n )", "EXTERN: \"C\" int gst_event_replace( void * old_event, void * new_event );", "	( old_event new_event -- )" );
	swigFunction( "c-function gst_event_steal gst_event_steal a -- a", "FUNCTION: gst_event_steal ( old_event -- a )", "EXTERN: \"C\" void * gst_event_steal( void * old_event );", "	( old_event -- )" );
	swigFunction( "c-function gst_event_take gst_event_take a a -- n", "FUNCTION: gst_event_take ( old_event new_event -- n )", "EXTERN: \"C\" int gst_event_take( void * old_event, void * new_event );", "	( old_event new_event -- )" );
	swigFunction( "c-function gst_event_type_get_name gst_event_type_get_name n -- s", "FUNCTION: gst_event_type_get_name ( type -- s )", "EXTERN: \"C\" char * gst_event_type_get_name( int type );", "	( type -- )" );
	swigFunction( "c-function gst_event_type_to_quark gst_event_type_to_quark n -- n", "FUNCTION: gst_event_type_to_quark ( type -- n )", "EXTERN: \"C\" n gst_event_type_to_quark( int type );", "	( type -- )" );
	swigFunction( "c-function gst_event_type_get_flags gst_event_type_get_flags n -- n", "FUNCTION: gst_event_type_get_flags ( type -- n )", "EXTERN: \"C\" int gst_event_type_get_flags( int type );", "	( type -- )" );
	swigFunction( "c-function gst_event_ref gst_event_ref a -- a", "FUNCTION: gst_event_ref ( event -- a )", "EXTERN: \"C\" void * gst_event_ref( void * event );", "	( event -- )" );
	swigFunction( "c-function gst_event_unref gst_event_unref a -- void", "FUNCTION: gst_event_unref ( event -- void )", "EXTERN: \"C\" void gst_event_unref( void * event );", "	( event -- )" );
	swigFunction( "c-function gst_event_copy gst_event_copy a -- a", "FUNCTION: gst_event_copy ( event -- a )", "EXTERN: \"C\" void * gst_event_copy( void * event );", "	( event -- )" );
	swigFunction( "c-function gst_event_get_type gst_event_get_type  -- u", "FUNCTION: gst_event_get_type (  -- u )", "EXTERN: \"C\" int gst_event_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_event_new_custom gst_event_new_custom n a -- a", "FUNCTION: gst_event_new_custom ( type structure -- a )", "EXTERN: \"C\" void * gst_event_new_custom( int type, void * structure );", "	( type structure -- )" );
	swigFunction( "c-function gst_event_get_structure gst_event_get_structure a -- a", "FUNCTION: gst_event_get_structure ( event -- a )", "EXTERN: \"C\" void * gst_event_get_structure( void * event );", "	( event -- )" );
	swigFunction( "c-function gst_event_writable_structure gst_event_writable_structure a -- a", "FUNCTION: gst_event_writable_structure ( event -- a )", "EXTERN: \"C\" void * gst_event_writable_structure( void * event );", "	( event -- )" );
	swigFunction( "c-function gst_event_has_name gst_event_has_name a s -- n", "FUNCTION: gst_event_has_name ( event name -- n )", "EXTERN: \"C\" int gst_event_has_name( void * event, char * name );", "	( event name -- )" );
	swigFunction( "c-function gst_event_get_seqnum gst_event_get_seqnum a -- u", "FUNCTION: gst_event_get_seqnum ( event -- u )", "EXTERN: \"C\" int gst_event_get_seqnum( void * event );", "	( event -- )" );
	swigFunction( "c-function gst_event_set_seqnum gst_event_set_seqnum a u -- void", "FUNCTION: gst_event_set_seqnum ( event seqnum -- void )", "EXTERN: \"C\" void gst_event_set_seqnum( void * event, int seqnum );", "	( event seqnum -- )" );
	swigFunction( "c-function gst_event_get_running_time_offset gst_event_get_running_time_offset a -- d", "FUNCTION: gst_event_get_running_time_offset ( event -- d )", "EXTERN: \"C\" long long gst_event_get_running_time_offset( void * event );", "	( event -- )" );
	swigFunction( "c-function gst_event_set_running_time_offset gst_event_set_running_time_offset a d -- void", "FUNCTION: gst_event_set_running_time_offset ( event offset -- void )", "EXTERN: \"C\" void gst_event_set_running_time_offset( void * event, long long offset );", "	( event offset -- )" );
	swigFunction( "c-function gst_event_new_stream_start gst_event_new_stream_start s -- a", "FUNCTION: gst_event_new_stream_start ( stream_id -- a )", "EXTERN: \"C\" void * gst_event_new_stream_start( char * stream_id );", "	( stream_id -- )" );
	swigFunction( "c-function gst_event_parse_stream_start gst_event_parse_stream_start a a -- void", "FUNCTION: gst_event_parse_stream_start ( event stream_id -- void )", "EXTERN: \"C\" void gst_event_parse_stream_start( void * event, void * stream_id );", "	( event stream_id -- )" );
	swigFunction( "c-function gst_event_set_stream gst_event_set_stream a a -- void", "FUNCTION: gst_event_set_stream ( event stream -- void )", "EXTERN: \"C\" void gst_event_set_stream( void * event, void * stream );", "	( event stream -- )" );
	swigFunction( "c-function gst_event_parse_stream gst_event_parse_stream a a -- void", "FUNCTION: gst_event_parse_stream ( event stream -- void )", "EXTERN: \"C\" void gst_event_parse_stream( void * event, void * stream );", "	( event stream -- )" );
	swigFunction( "c-function gst_event_set_stream_flags gst_event_set_stream_flags a n -- void", "FUNCTION: gst_event_set_stream_flags ( event flags -- void )", "EXTERN: \"C\" void gst_event_set_stream_flags( void * event, int flags );", "	( event flags -- )" );
	swigFunction( "c-function gst_event_parse_stream_flags gst_event_parse_stream_flags a a -- void", "FUNCTION: gst_event_parse_stream_flags ( event flags -- void )", "EXTERN: \"C\" void gst_event_parse_stream_flags( void * event, void * flags );", "	( event flags -- )" );
	swigFunction( "c-function gst_event_set_group_id gst_event_set_group_id a u -- void", "FUNCTION: gst_event_set_group_id ( event group_id -- void )", "EXTERN: \"C\" void gst_event_set_group_id( void * event, int group_id );", "	( event group_id -- )" );
	swigFunction( "c-function gst_event_parse_group_id gst_event_parse_group_id a a -- n", "FUNCTION: gst_event_parse_group_id ( event group_id -- n )", "EXTERN: \"C\" int gst_event_parse_group_id( void * event, void * group_id );", "	( event group_id -- )" );
	swigFunction( "c-function gst_event_new_flush_start gst_event_new_flush_start  -- a", "FUNCTION: gst_event_new_flush_start (  -- a )", "EXTERN: \"C\" void * gst_event_new_flush_start(  );", "	( -- )" );
	swigFunction( "c-function gst_event_new_flush_stop gst_event_new_flush_stop n -- a", "FUNCTION: gst_event_new_flush_stop ( reset_time -- a )", "EXTERN: \"C\" void * gst_event_new_flush_stop( int reset_time );", "	( reset_time -- )" );
	swigFunction( "c-function gst_event_parse_flush_stop gst_event_parse_flush_stop a a -- void", "FUNCTION: gst_event_parse_flush_stop ( event reset_time -- void )", "EXTERN: \"C\" void gst_event_parse_flush_stop( void * event, void * reset_time );", "	( event reset_time -- )" );
	swigFunction( "c-function gst_event_new_stream_collection gst_event_new_stream_collection a -- a", "FUNCTION: gst_event_new_stream_collection ( collection -- a )", "EXTERN: \"C\" void * gst_event_new_stream_collection( void * collection );", "	( collection -- )" );
	swigFunction( "c-function gst_event_parse_stream_collection gst_event_parse_stream_collection a a -- void", "FUNCTION: gst_event_parse_stream_collection ( event collection -- void )", "EXTERN: \"C\" void gst_event_parse_stream_collection( void * event, void * collection );", "	( event collection -- )" );
	swigFunction( "c-function gst_event_new_select_streams gst_event_new_select_streams a -- a", "FUNCTION: gst_event_new_select_streams ( streams -- a )", "EXTERN: \"C\" void * gst_event_new_select_streams( void * streams );", "	( streams -- )" );
	swigFunction( "c-function gst_event_parse_select_streams gst_event_parse_select_streams a a -- void", "FUNCTION: gst_event_parse_select_streams ( event streams -- void )", "EXTERN: \"C\" void gst_event_parse_select_streams( void * event, void * streams );", "	( event streams -- )" );
	swigFunction( "c-function gst_event_new_stream_group_done gst_event_new_stream_group_done u -- a", "FUNCTION: gst_event_new_stream_group_done ( group_id -- a )", "EXTERN: \"C\" void * gst_event_new_stream_group_done( int group_id );", "	( group_id -- )" );
	swigFunction( "c-function gst_event_parse_stream_group_done gst_event_parse_stream_group_done a a -- void", "FUNCTION: gst_event_parse_stream_group_done ( event group_id -- void )", "EXTERN: \"C\" void gst_event_parse_stream_group_done( void * event, void * group_id );", "	( event group_id -- )" );
	swigFunction( "c-function gst_event_new_eos gst_event_new_eos  -- a", "FUNCTION: gst_event_new_eos (  -- a )", "EXTERN: \"C\" void * gst_event_new_eos(  );", "	( -- )" );
	swigFunction( "c-function gst_event_new_gap gst_event_new_gap ud ud -- a", "FUNCTION: gst_event_new_gap ( timestamp duration -- a )", "EXTERN: \"C\" void * gst_event_new_gap( long long timestamp, long long duration );", "	( timestamp duration -- )" );
	swigFunction( "c-function gst_event_parse_gap gst_event_parse_gap a a a -- void", "FUNCTION: gst_event_parse_gap ( event timestamp duration -- void )", "EXTERN: \"C\" void gst_event_parse_gap( void * event, void * timestamp, void * duration );", "	( event timestamp duration -- )" );
	swigFunction( "c-function gst_event_new_caps gst_event_new_caps a -- a", "FUNCTION: gst_event_new_caps ( caps -- a )", "EXTERN: \"C\" void * gst_event_new_caps( void * caps );", "	( caps -- )" );
	swigFunction( "c-function gst_event_parse_caps gst_event_parse_caps a a -- void", "FUNCTION: gst_event_parse_caps ( event caps -- void )", "EXTERN: \"C\" void gst_event_parse_caps( void * event, void * caps );", "	( event caps -- )" );
	swigFunction( "c-function gst_event_new_segment gst_event_new_segment a -- a", "FUNCTION: gst_event_new_segment ( segment -- a )", "EXTERN: \"C\" void * gst_event_new_segment( void * segment );", "	( segment -- )" );
	swigFunction( "c-function gst_event_parse_segment gst_event_parse_segment a a -- void", "FUNCTION: gst_event_parse_segment ( event segment -- void )", "EXTERN: \"C\" void gst_event_parse_segment( void * event, void * segment );", "	( event segment -- )" );
	swigFunction( "c-function gst_event_copy_segment gst_event_copy_segment a a -- void", "FUNCTION: gst_event_copy_segment ( event segment -- void )", "EXTERN: \"C\" void gst_event_copy_segment( void * event, void * segment );", "	( event segment -- )" );
	swigFunction( "c-function gst_event_new_tag gst_event_new_tag a -- a", "FUNCTION: gst_event_new_tag ( taglist -- a )", "EXTERN: \"C\" void * gst_event_new_tag( void * taglist );", "	( taglist -- )" );
	swigFunction( "c-function gst_event_parse_tag gst_event_parse_tag a a -- void", "FUNCTION: gst_event_parse_tag ( event taglist -- void )", "EXTERN: \"C\" void gst_event_parse_tag( void * event, void * taglist );", "	( event taglist -- )" );
	swigFunction( "c-function gst_event_new_toc gst_event_new_toc a n -- a", "FUNCTION: gst_event_new_toc ( toc updated -- a )", "EXTERN: \"C\" void * gst_event_new_toc( void * toc, int updated );", "	( toc updated -- )" );
	swigFunction( "c-function gst_event_parse_toc gst_event_parse_toc a a a -- void", "FUNCTION: gst_event_parse_toc ( event toc updated -- void )", "EXTERN: \"C\" void gst_event_parse_toc( void * event, void * toc, void * updated );", "	( event toc updated -- )" );
	swigFunction( "c-function gst_event_new_protection gst_event_new_protection s a s -- a", "FUNCTION: gst_event_new_protection ( system_id data origin -- a )", "EXTERN: \"C\" void * gst_event_new_protection( char * system_id, void * data, char * origin );", "	( system_id data origin -- )" );
	swigFunction( "c-function gst_event_parse_protection gst_event_parse_protection a a a a -- void", "FUNCTION: gst_event_parse_protection ( event system_id data origin -- void )", "EXTERN: \"C\" void gst_event_parse_protection( void * event, void * system_id, void * data, void * origin );", "	( event system_id data origin -- )" );
	swigFunction( "c-function gst_event_new_buffer_size gst_event_new_buffer_size u d d n -- a", "FUNCTION: gst_event_new_buffer_size ( format minsize maxsize async -- a )", "EXTERN: \"C\" void * gst_event_new_buffer_size( int format, long long minsize, long long maxsize, int async );", "	( format minsize maxsize async -- )" );
	swigFunction( "c-function gst_event_parse_buffer_size gst_event_parse_buffer_size a a a a a -- void", "FUNCTION: gst_event_parse_buffer_size ( event format minsize maxsize async -- void )", "EXTERN: \"C\" void gst_event_parse_buffer_size( void * event, void * format, void * minsize, void * maxsize, void * async );", "	( event format minsize maxsize async -- )" );
	swigFunction( "c-function gst_event_new_sink_message gst_event_new_sink_message s a -- a", "FUNCTION: gst_event_new_sink_message ( name msg -- a )", "EXTERN: \"C\" void * gst_event_new_sink_message( char * name, void * msg );", "	( name msg -- )" );
	swigFunction( "c-function gst_event_parse_sink_message gst_event_parse_sink_message a a -- void", "FUNCTION: gst_event_parse_sink_message ( event msg -- void )", "EXTERN: \"C\" void gst_event_parse_sink_message( void * event, void * msg );", "	( event msg -- )" );
	swigFunction( "c-function gst_event_new_qos gst_event_new_qos n r d ud -- a", "FUNCTION: gst_event_new_qos ( type proportion diff timestamp -- a )", "EXTERN: \"C\" void * gst_event_new_qos( int type, double proportion, long long diff, long long timestamp );", "	( type proportion diff timestamp -- )" );
	swigFunction( "c-function gst_event_parse_qos gst_event_parse_qos a a a a a -- void", "FUNCTION: gst_event_parse_qos ( event type proportion diff timestamp -- void )", "EXTERN: \"C\" void gst_event_parse_qos( void * event, void * type, void * proportion, void * diff, void * timestamp );", "	( event type proportion diff timestamp -- )" );
	swigFunction( "c-function gst_event_new_seek gst_event_new_seek r u n n d n d -- a", "FUNCTION: gst_event_new_seek ( rate format flags start_type start stop_type stop -- a )", "EXTERN: \"C\" void * gst_event_new_seek( double rate, int format, int flags, int start_type, long long start, int stop_type, long long stop );", "	( rate format flags start_type start stop_type stop -- )" );
	swigFunction( "c-function gst_event_parse_seek gst_event_parse_seek a a a a a a a a -- void", "FUNCTION: gst_event_parse_seek ( event rate format flags start_type start stop_type stop -- void )", "EXTERN: \"C\" void gst_event_parse_seek( void * event, void * rate, void * format, void * flags, void * start_type, void * start, void * stop_type, void * stop );", "	( event rate format flags start_type start stop_type stop -- )" );
	swigFunction( "c-function gst_event_new_navigation gst_event_new_navigation a -- a", "FUNCTION: gst_event_new_navigation ( structure -- a )", "EXTERN: \"C\" void * gst_event_new_navigation( void * structure );", "	( structure -- )" );
	swigFunction( "c-function gst_event_new_latency gst_event_new_latency ud -- a", "FUNCTION: gst_event_new_latency ( latency -- a )", "EXTERN: \"C\" void * gst_event_new_latency( long long latency );", "	( latency -- )" );
	swigFunction( "c-function gst_event_parse_latency gst_event_parse_latency a a -- void", "FUNCTION: gst_event_parse_latency ( event latency -- void )", "EXTERN: \"C\" void gst_event_parse_latency( void * event, void * latency );", "	( event latency -- )" );
	swigFunction( "c-function gst_event_new_step gst_event_new_step u ud r n n -- a", "FUNCTION: gst_event_new_step ( format amount rate flush intermediate -- a )", "EXTERN: \"C\" void * gst_event_new_step( int format, long long amount, double rate, int flush, int intermediate );", "	( format amount rate flush intermediate -- )" );
	swigFunction( "c-function gst_event_parse_step gst_event_parse_step a a a a a a -- void", "FUNCTION: gst_event_parse_step ( event format amount rate flush intermediate -- void )", "EXTERN: \"C\" void gst_event_parse_step( void * event, void * format, void * amount, void * rate, void * flush, void * intermediate );", "	( event format amount rate flush intermediate -- )" );
	swigFunction( "c-function gst_event_new_reconfigure gst_event_new_reconfigure  -- a", "FUNCTION: gst_event_new_reconfigure (  -- a )", "EXTERN: \"C\" void * gst_event_new_reconfigure(  );", "	( -- )" );
	swigFunction( "c-function gst_event_new_toc_select gst_event_new_toc_select s -- a", "FUNCTION: gst_event_new_toc_select ( uid -- a )", "EXTERN: \"C\" void * gst_event_new_toc_select( char * uid );", "	( uid -- )" );
	swigFunction( "c-function gst_event_parse_toc_select gst_event_parse_toc_select a a -- void", "FUNCTION: gst_event_parse_toc_select ( event uid -- void )", "EXTERN: \"C\" void gst_event_parse_toc_select( void * event, void * uid );", "	( event uid -- )" );
	swigFunction( "c-function gst_event_new_segment_done gst_event_new_segment_done u d -- a", "FUNCTION: gst_event_new_segment_done ( format position -- a )", "EXTERN: \"C\" void * gst_event_new_segment_done( int format, long long position );", "	( format position -- )" );
	swigFunction( "c-function gst_event_parse_segment_done gst_event_parse_segment_done a a a -- void", "FUNCTION: gst_event_parse_segment_done ( event format position -- void )", "EXTERN: \"C\" void gst_event_parse_segment_done( void * event, void * format, void * position );", "	( event format position -- )" );
	swigFunction( "c-function gst_proxy_pad_get_type gst_proxy_pad_get_type  -- u", "FUNCTION: gst_proxy_pad_get_type (  -- u )", "EXTERN: \"C\" int gst_proxy_pad_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_proxy_pad_get_internal gst_proxy_pad_get_internal a -- a", "FUNCTION: gst_proxy_pad_get_internal ( pad -- a )", "EXTERN: \"C\" void * gst_proxy_pad_get_internal( void * pad );", "	( pad -- )" );
	swigFunction( "c-function gst_proxy_pad_iterate_internal_links_default gst_proxy_pad_iterate_internal_links_default a a -- a", "FUNCTION: gst_proxy_pad_iterate_internal_links_default ( pad parent -- a )", "EXTERN: \"C\" void * gst_proxy_pad_iterate_internal_links_default( void * pad, void * parent );", "	( pad parent -- )" );
	swigFunction( "c-function gst_proxy_pad_chain_default gst_proxy_pad_chain_default a a a -- n", "FUNCTION: gst_proxy_pad_chain_default ( pad parent buffer -- n )", "EXTERN: \"C\" int gst_proxy_pad_chain_default( void * pad, void * parent, void * buffer );", "	( pad parent buffer -- )" );
	swigFunction( "c-function gst_proxy_pad_chain_list_default gst_proxy_pad_chain_list_default a a a -- n", "FUNCTION: gst_proxy_pad_chain_list_default ( pad parent list -- n )", "EXTERN: \"C\" int gst_proxy_pad_chain_list_default( void * pad, void * parent, void * list );", "	( pad parent list -- )" );
	swigFunction( "c-function gst_proxy_pad_getrange_default gst_proxy_pad_getrange_default a a ud u a -- n", "FUNCTION: gst_proxy_pad_getrange_default ( pad parent offset size buffer -- n )", "EXTERN: \"C\" int gst_proxy_pad_getrange_default( void * pad, void * parent, long long offset, int size, void * buffer );", "	( pad parent offset size buffer -- )" );
	swigFunction( "c-function gst_ghost_pad_get_type gst_ghost_pad_get_type  -- u", "FUNCTION: gst_ghost_pad_get_type (  -- u )", "EXTERN: \"C\" int gst_ghost_pad_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_ghost_pad_new gst_ghost_pad_new s a -- a", "FUNCTION: gst_ghost_pad_new ( name target -- a )", "EXTERN: \"C\" void * gst_ghost_pad_new( char * name, void * target );", "	( name target -- )" );
	swigFunction( "c-function gst_ghost_pad_new_no_target gst_ghost_pad_new_no_target s n -- a", "FUNCTION: gst_ghost_pad_new_no_target ( name dir -- a )", "EXTERN: \"C\" void * gst_ghost_pad_new_no_target( char * name, int dir );", "	( name dir -- )" );
	swigFunction( "c-function gst_ghost_pad_new_from_template gst_ghost_pad_new_from_template s a a -- a", "FUNCTION: gst_ghost_pad_new_from_template ( name target templ -- a )", "EXTERN: \"C\" void * gst_ghost_pad_new_from_template( char * name, void * target, void * templ );", "	( name target templ -- )" );
	swigFunction( "c-function gst_ghost_pad_new_no_target_from_template gst_ghost_pad_new_no_target_from_template s a -- a", "FUNCTION: gst_ghost_pad_new_no_target_from_template ( name templ -- a )", "EXTERN: \"C\" void * gst_ghost_pad_new_no_target_from_template( char * name, void * templ );", "	( name templ -- )" );
	swigFunction( "c-function gst_ghost_pad_get_target gst_ghost_pad_get_target a -- a", "FUNCTION: gst_ghost_pad_get_target ( gpad -- a )", "EXTERN: \"C\" void * gst_ghost_pad_get_target( void * gpad );", "	( gpad -- )" );
	swigFunction( "c-function gst_ghost_pad_set_target gst_ghost_pad_set_target a a -- n", "FUNCTION: gst_ghost_pad_set_target ( gpad newtarget -- n )", "EXTERN: \"C\" int gst_ghost_pad_set_target( void * gpad, void * newtarget );", "	( gpad newtarget -- )" );
	swigFunction( "c-function gst_ghost_pad_construct gst_ghost_pad_construct a -- n", "FUNCTION: gst_ghost_pad_construct ( gpad -- n )", "EXTERN: \"C\" int gst_ghost_pad_construct( void * gpad );", "	( gpad -- )" );
	swigFunction( "c-function gst_ghost_pad_activate_mode_default gst_ghost_pad_activate_mode_default a a n n -- n", "FUNCTION: gst_ghost_pad_activate_mode_default ( pad parent mode active -- n )", "EXTERN: \"C\" int gst_ghost_pad_activate_mode_default( void * pad, void * parent, int mode, int active );", "	( pad parent mode active -- )" );
	swigFunction( "c-function gst_ghost_pad_internal_activate_mode_default gst_ghost_pad_internal_activate_mode_default a a n n -- n", "FUNCTION: gst_ghost_pad_internal_activate_mode_default ( pad parent mode active -- n )", "EXTERN: \"C\" int gst_ghost_pad_internal_activate_mode_default( void * pad, void * parent, int mode, int active );", "	( pad parent mode active -- )" );
	swigFunction( "c-function gst_iterator_get_type gst_iterator_get_type  -- u", "FUNCTION: gst_iterator_get_type (  -- u )", "EXTERN: \"C\" int gst_iterator_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_iterator_new gst_iterator_new u u a a a a a a a -- a", "FUNCTION: gst_iterator_new ( size type lock master_cookie copy next item resync free -- a )", "EXTERN: \"C\" void * gst_iterator_new( int size, int type, void * lock, void * master_cookie, void * copy, void * next, void * item, void * resync, void * free );", "	( size type lock master_cookie copy next item resync free -- )" );
	swigFunction( "c-function gst_iterator_new_list gst_iterator_new_list u a a a a a -- a", "FUNCTION: gst_iterator_new_list ( type lock master_cookie list owner item -- a )", "EXTERN: \"C\" void * gst_iterator_new_list( int type, void * lock, void * master_cookie, void * list, void * owner, void * item );", "	( type lock master_cookie list owner item -- )" );
	swigFunction( "c-function gst_iterator_new_single gst_iterator_new_single u a -- a", "FUNCTION: gst_iterator_new_single ( type object -- a )", "EXTERN: \"C\" void * gst_iterator_new_single( int type, void * object );", "	( type object -- )" );
	swigFunction( "c-function gst_iterator_copy gst_iterator_copy a -- a", "FUNCTION: gst_iterator_copy ( it -- a )", "EXTERN: \"C\" void * gst_iterator_copy( void * it );", "	( it -- )" );
	swigFunction( "c-function gst_iterator_next gst_iterator_next a a -- n", "FUNCTION: gst_iterator_next ( it elem -- n )", "EXTERN: \"C\" int gst_iterator_next( void * it, void * elem );", "	( it elem -- )" );
	swigFunction( "c-function gst_iterator_resync gst_iterator_resync a -- void", "FUNCTION: gst_iterator_resync ( it -- void )", "EXTERN: \"C\" void gst_iterator_resync( void * it );", "	( it -- )" );
	swigFunction( "c-function gst_iterator_free gst_iterator_free a -- void", "FUNCTION: gst_iterator_free ( it -- void )", "EXTERN: \"C\" void gst_iterator_free( void * it );", "	( it -- )" );
	swigFunction( "c-function gst_iterator_push gst_iterator_push a a -- void", "FUNCTION: gst_iterator_push ( it other -- void )", "EXTERN: \"C\" void gst_iterator_push( void * it, void * other );", "	( it other -- )" );
	swigFunction( "c-function gst_iterator_filter gst_iterator_filter a a a -- a", "FUNCTION: gst_iterator_filter ( it func user_data -- a )", "EXTERN: \"C\" void * gst_iterator_filter( void * it, void * func, void * user_data );", "	( it func user_data -- )" );
	swigFunction( "c-function gst_iterator_fold gst_iterator_fold a a a a -- n", "FUNCTION: gst_iterator_fold ( it func ret user_data -- n )", "EXTERN: \"C\" int gst_iterator_fold( void * it, void * func, void * ret, void * user_data );", "	( it func ret user_data -- )" );
	swigFunction( "c-function gst_iterator_foreach gst_iterator_foreach a a a -- n", "FUNCTION: gst_iterator_foreach ( it func user_data -- n )", "EXTERN: \"C\" int gst_iterator_foreach( void * it, void * func, void * user_data );", "	( it func user_data -- )" );
	swigFunction( "c-function gst_iterator_find_custom gst_iterator_find_custom a a a a -- n", "FUNCTION: gst_iterator_find_custom ( it func elem user_data -- n )", "EXTERN: \"C\" int gst_iterator_find_custom( void * it, void * func, void * elem, void * user_data );", "	( it func elem user_data -- )" );
	swigFunction( "c-function gst_message_get_type gst_message_get_type  -- u", "FUNCTION: gst_message_get_type (  -- u )", "EXTERN: \"C\" int gst_message_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_message_type_get_name gst_message_type_get_name n -- s", "FUNCTION: gst_message_type_get_name ( type -- s )", "EXTERN: \"C\" char * gst_message_type_get_name( int type );", "	( type -- )" );
	swigFunction( "c-function gst_message_type_to_quark gst_message_type_to_quark n -- n", "FUNCTION: gst_message_type_to_quark ( type -- n )", "EXTERN: \"C\" n gst_message_type_to_quark( int type );", "	( type -- )" );
	swigFunction( "c-function gst_message_ref gst_message_ref a -- a", "FUNCTION: gst_message_ref ( msg -- a )", "EXTERN: \"C\" void * gst_message_ref( void * msg );", "	( msg -- )" );
	swigFunction( "c-function gst_message_unref gst_message_unref a -- void", "FUNCTION: gst_message_unref ( msg -- void )", "EXTERN: \"C\" void gst_message_unref( void * msg );", "	( msg -- )" );
	swigFunction( "c-function gst_message_copy gst_message_copy a -- a", "FUNCTION: gst_message_copy ( msg -- a )", "EXTERN: \"C\" void * gst_message_copy( void * msg );", "	( msg -- )" );
	swigFunction( "c-function gst_message_replace gst_message_replace a a -- n", "FUNCTION: gst_message_replace ( old_message new_message -- n )", "EXTERN: \"C\" int gst_message_replace( void * old_message, void * new_message );", "	( old_message new_message -- )" );
	swigFunction( "c-function gst_message_new_custom gst_message_new_custom n a a -- a", "FUNCTION: gst_message_new_custom ( type src structure -- a )", "EXTERN: \"C\" void * gst_message_new_custom( int type, void * src, void * structure );", "	( type src structure -- )" );
	swigFunction( "c-function gst_message_get_structure gst_message_get_structure a -- a", "FUNCTION: gst_message_get_structure ( message -- a )", "EXTERN: \"C\" void * gst_message_get_structure( void * message );", "	( message -- )" );
	swigFunction( "c-function gst_message_writable_structure gst_message_writable_structure a -- a", "FUNCTION: gst_message_writable_structure ( message -- a )", "EXTERN: \"C\" void * gst_message_writable_structure( void * message );", "	( message -- )" );
	swigFunction( "c-function gst_message_has_name gst_message_has_name a s -- n", "FUNCTION: gst_message_has_name ( message name -- n )", "EXTERN: \"C\" int gst_message_has_name( void * message, char * name );", "	( message name -- )" );
	swigFunction( "c-function gst_message_get_seqnum gst_message_get_seqnum a -- u", "FUNCTION: gst_message_get_seqnum ( message -- u )", "EXTERN: \"C\" int gst_message_get_seqnum( void * message );", "	( message -- )" );
	swigFunction( "c-function gst_message_set_seqnum gst_message_set_seqnum a u -- void", "FUNCTION: gst_message_set_seqnum ( message seqnum -- void )", "EXTERN: \"C\" void gst_message_set_seqnum( void * message, int seqnum );", "	( message seqnum -- )" );
	swigFunction( "c-function gst_message_new_eos gst_message_new_eos a -- a", "FUNCTION: gst_message_new_eos ( src -- a )", "EXTERN: \"C\" void * gst_message_new_eos( void * src );", "	( src -- )" );
	swigFunction( "c-function gst_message_new_error gst_message_new_error a a s -- a", "FUNCTION: gst_message_new_error ( src error debug -- a )", "EXTERN: \"C\" void * gst_message_new_error( void * src, void * error, char * debug );", "	( src error debug -- )" );
	swigFunction( "c-function gst_message_new_error_with_details gst_message_new_error_with_details a a s a -- a", "FUNCTION: gst_message_new_error_with_details ( src error debug details -- a )", "EXTERN: \"C\" void * gst_message_new_error_with_details( void * src, void * error, char * debug, void * details );", "	( src error debug details -- )" );
	swigFunction( "c-function gst_message_parse_error gst_message_parse_error a a a -- void", "FUNCTION: gst_message_parse_error ( message gerror debug -- void )", "EXTERN: \"C\" void gst_message_parse_error( void * message, void * gerror, void * debug );", "	( message gerror debug -- )" );
	swigFunction( "c-function gst_message_parse_error_details gst_message_parse_error_details a a -- void", "FUNCTION: gst_message_parse_error_details ( message structure -- void )", "EXTERN: \"C\" void gst_message_parse_error_details( void * message, void * structure );", "	( message structure -- )" );
	swigFunction( "c-function gst_message_new_warning gst_message_new_warning a a s -- a", "FUNCTION: gst_message_new_warning ( src error debug -- a )", "EXTERN: \"C\" void * gst_message_new_warning( void * src, void * error, char * debug );", "	( src error debug -- )" );
	swigFunction( "c-function gst_message_new_warning_with_details gst_message_new_warning_with_details a a s a -- a", "FUNCTION: gst_message_new_warning_with_details ( src error debug details -- a )", "EXTERN: \"C\" void * gst_message_new_warning_with_details( void * src, void * error, char * debug, void * details );", "	( src error debug details -- )" );
	swigFunction( "c-function gst_message_parse_warning gst_message_parse_warning a a a -- void", "FUNCTION: gst_message_parse_warning ( message gerror debug -- void )", "EXTERN: \"C\" void gst_message_parse_warning( void * message, void * gerror, void * debug );", "	( message gerror debug -- )" );
	swigFunction( "c-function gst_message_parse_warning_details gst_message_parse_warning_details a a -- void", "FUNCTION: gst_message_parse_warning_details ( message structure -- void )", "EXTERN: \"C\" void gst_message_parse_warning_details( void * message, void * structure );", "	( message structure -- )" );
	swigFunction( "c-function gst_message_new_info gst_message_new_info a a s -- a", "FUNCTION: gst_message_new_info ( src error debug -- a )", "EXTERN: \"C\" void * gst_message_new_info( void * src, void * error, char * debug );", "	( src error debug -- )" );
	swigFunction( "c-function gst_message_new_info_with_details gst_message_new_info_with_details a a s a -- a", "FUNCTION: gst_message_new_info_with_details ( src error debug details -- a )", "EXTERN: \"C\" void * gst_message_new_info_with_details( void * src, void * error, char * debug, void * details );", "	( src error debug details -- )" );
	swigFunction( "c-function gst_message_parse_info gst_message_parse_info a a a -- void", "FUNCTION: gst_message_parse_info ( message gerror debug -- void )", "EXTERN: \"C\" void gst_message_parse_info( void * message, void * gerror, void * debug );", "	( message gerror debug -- )" );
	swigFunction( "c-function gst_message_parse_info_details gst_message_parse_info_details a a -- void", "FUNCTION: gst_message_parse_info_details ( message structure -- void )", "EXTERN: \"C\" void gst_message_parse_info_details( void * message, void * structure );", "	( message structure -- )" );
	swigFunction( "c-function gst_message_new_tag gst_message_new_tag a a -- a", "FUNCTION: gst_message_new_tag ( src tag_list -- a )", "EXTERN: \"C\" void * gst_message_new_tag( void * src, void * tag_list );", "	( src tag_list -- )" );
	swigFunction( "c-function gst_message_parse_tag gst_message_parse_tag a a -- void", "FUNCTION: gst_message_parse_tag ( message tag_list -- void )", "EXTERN: \"C\" void gst_message_parse_tag( void * message, void * tag_list );", "	( message tag_list -- )" );
	swigFunction( "c-function gst_message_new_buffering gst_message_new_buffering a n -- a", "FUNCTION: gst_message_new_buffering ( src percent -- a )", "EXTERN: \"C\" void * gst_message_new_buffering( void * src, int percent );", "	( src percent -- )" );
	swigFunction( "c-function gst_message_parse_buffering gst_message_parse_buffering a a -- void", "FUNCTION: gst_message_parse_buffering ( message percent -- void )", "EXTERN: \"C\" void gst_message_parse_buffering( void * message, void * percent );", "	( message percent -- )" );
	swigFunction( "c-function gst_message_set_buffering_stats gst_message_set_buffering_stats a n n n d -- void", "FUNCTION: gst_message_set_buffering_stats ( message mode avg_in avg_out buffering_left -- void )", "EXTERN: \"C\" void gst_message_set_buffering_stats( void * message, int mode, int avg_in, int avg_out, long long buffering_left );", "	( message mode avg_in avg_out buffering_left -- )" );
	swigFunction( "c-function gst_message_parse_buffering_stats gst_message_parse_buffering_stats a a a a a -- void", "FUNCTION: gst_message_parse_buffering_stats ( message mode avg_in avg_out buffering_left -- void )", "EXTERN: \"C\" void gst_message_parse_buffering_stats( void * message, void * mode, void * avg_in, void * avg_out, void * buffering_left );", "	( message mode avg_in avg_out buffering_left -- )" );
	swigFunction( "c-function gst_message_new_state_changed gst_message_new_state_changed a n n n -- a", "FUNCTION: gst_message_new_state_changed ( src oldstate newstate pending -- a )", "EXTERN: \"C\" void * gst_message_new_state_changed( void * src, int oldstate, int newstate, int pending );", "	( src oldstate newstate pending -- )" );
	swigFunction( "c-function gst_message_parse_state_changed gst_message_parse_state_changed a a a a -- void", "FUNCTION: gst_message_parse_state_changed ( message oldstate newstate pending -- void )", "EXTERN: \"C\" void gst_message_parse_state_changed( void * message, void * oldstate, void * newstate, void * pending );", "	( message oldstate newstate pending -- )" );
	swigFunction( "c-function gst_message_new_state_dirty gst_message_new_state_dirty a -- a", "FUNCTION: gst_message_new_state_dirty ( src -- a )", "EXTERN: \"C\" void * gst_message_new_state_dirty( void * src );", "	( src -- )" );
	swigFunction( "c-function gst_message_new_step_done gst_message_new_step_done a u ud r n n ud n -- a", "FUNCTION: gst_message_new_step_done ( src format amount rate flush intermediate duration eos -- a )", "EXTERN: \"C\" void * gst_message_new_step_done( void * src, int format, long long amount, double rate, int flush, int intermediate, long long duration, int eos );", "	( src format amount rate flush intermediate duration eos -- )" );
	swigFunction( "c-function gst_message_parse_step_done gst_message_parse_step_done a a a a a a a a -- void", "FUNCTION: gst_message_parse_step_done ( message format amount rate flush intermediate duration eos -- void )", "EXTERN: \"C\" void gst_message_parse_step_done( void * message, void * format, void * amount, void * rate, void * flush, void * intermediate, void * duration, void * eos );", "	( message format amount rate flush intermediate duration eos -- )" );
	swigFunction( "c-function gst_message_new_clock_provide gst_message_new_clock_provide a a n -- a", "FUNCTION: gst_message_new_clock_provide ( src clock ready -- a )", "EXTERN: \"C\" void * gst_message_new_clock_provide( void * src, void * clock, int ready );", "	( src clock ready -- )" );
	swigFunction( "c-function gst_message_parse_clock_provide gst_message_parse_clock_provide a a a -- void", "FUNCTION: gst_message_parse_clock_provide ( message clock ready -- void )", "EXTERN: \"C\" void gst_message_parse_clock_provide( void * message, void * clock, void * ready );", "	( message clock ready -- )" );
	swigFunction( "c-function gst_message_new_clock_lost gst_message_new_clock_lost a a -- a", "FUNCTION: gst_message_new_clock_lost ( src clock -- a )", "EXTERN: \"C\" void * gst_message_new_clock_lost( void * src, void * clock );", "	( src clock -- )" );
	swigFunction( "c-function gst_message_parse_clock_lost gst_message_parse_clock_lost a a -- void", "FUNCTION: gst_message_parse_clock_lost ( message clock -- void )", "EXTERN: \"C\" void gst_message_parse_clock_lost( void * message, void * clock );", "	( message clock -- )" );
	swigFunction( "c-function gst_message_new_new_clock gst_message_new_new_clock a a -- a", "FUNCTION: gst_message_new_new_clock ( src clock -- a )", "EXTERN: \"C\" void * gst_message_new_new_clock( void * src, void * clock );", "	( src clock -- )" );
	swigFunction( "c-function gst_message_parse_new_clock gst_message_parse_new_clock a a -- void", "FUNCTION: gst_message_parse_new_clock ( message clock -- void )", "EXTERN: \"C\" void gst_message_parse_new_clock( void * message, void * clock );", "	( message clock -- )" );
	swigFunction( "c-function gst_message_new_application gst_message_new_application a a -- a", "FUNCTION: gst_message_new_application ( src structure -- a )", "EXTERN: \"C\" void * gst_message_new_application( void * src, void * structure );", "	( src structure -- )" );
	swigFunction( "c-function gst_message_new_element gst_message_new_element a a -- a", "FUNCTION: gst_message_new_element ( src structure -- a )", "EXTERN: \"C\" void * gst_message_new_element( void * src, void * structure );", "	( src structure -- )" );
	swigFunction( "c-function gst_message_new_segment_start gst_message_new_segment_start a u d -- a", "FUNCTION: gst_message_new_segment_start ( src format position -- a )", "EXTERN: \"C\" void * gst_message_new_segment_start( void * src, int format, long long position );", "	( src format position -- )" );
	swigFunction( "c-function gst_message_parse_segment_start gst_message_parse_segment_start a a a -- void", "FUNCTION: gst_message_parse_segment_start ( message format position -- void )", "EXTERN: \"C\" void gst_message_parse_segment_start( void * message, void * format, void * position );", "	( message format position -- )" );
	swigFunction( "c-function gst_message_new_segment_done gst_message_new_segment_done a u d -- a", "FUNCTION: gst_message_new_segment_done ( src format position -- a )", "EXTERN: \"C\" void * gst_message_new_segment_done( void * src, int format, long long position );", "	( src format position -- )" );
	swigFunction( "c-function gst_message_parse_segment_done gst_message_parse_segment_done a a a -- void", "FUNCTION: gst_message_parse_segment_done ( message format position -- void )", "EXTERN: \"C\" void gst_message_parse_segment_done( void * message, void * format, void * position );", "	( message format position -- )" );
	swigFunction( "c-function gst_message_new_duration_changed gst_message_new_duration_changed a -- a", "FUNCTION: gst_message_new_duration_changed ( src -- a )", "EXTERN: \"C\" void * gst_message_new_duration_changed( void * src );", "	( src -- )" );
	swigFunction( "c-function gst_message_new_latency gst_message_new_latency a -- a", "FUNCTION: gst_message_new_latency ( src -- a )", "EXTERN: \"C\" void * gst_message_new_latency( void * src );", "	( src -- )" );
	swigFunction( "c-function gst_message_new_async_start gst_message_new_async_start a -- a", "FUNCTION: gst_message_new_async_start ( src -- a )", "EXTERN: \"C\" void * gst_message_new_async_start( void * src );", "	( src -- )" );
	swigFunction( "c-function gst_message_new_async_done gst_message_new_async_done a ud -- a", "FUNCTION: gst_message_new_async_done ( src running_time -- a )", "EXTERN: \"C\" void * gst_message_new_async_done( void * src, long long running_time );", "	( src running_time -- )" );
	swigFunction( "c-function gst_message_parse_async_done gst_message_parse_async_done a a -- void", "FUNCTION: gst_message_parse_async_done ( message running_time -- void )", "EXTERN: \"C\" void gst_message_parse_async_done( void * message, void * running_time );", "	( message running_time -- )" );
	swigFunction( "c-function gst_message_new_structure_change gst_message_new_structure_change a n a n -- a", "FUNCTION: gst_message_new_structure_change ( src type owner busy -- a )", "EXTERN: \"C\" void * gst_message_new_structure_change( void * src, int type, void * owner, int busy );", "	( src type owner busy -- )" );
	swigFunction( "c-function gst_message_parse_structure_change gst_message_parse_structure_change a a a a -- void", "FUNCTION: gst_message_parse_structure_change ( message type owner busy -- void )", "EXTERN: \"C\" void gst_message_parse_structure_change( void * message, void * type, void * owner, void * busy );", "	( message type owner busy -- )" );
	swigFunction( "c-function gst_message_new_stream_status gst_message_new_stream_status a n a -- a", "FUNCTION: gst_message_new_stream_status ( src type owner -- a )", "EXTERN: \"C\" void * gst_message_new_stream_status( void * src, int type, void * owner );", "	( src type owner -- )" );
	swigFunction( "c-function gst_message_parse_stream_status gst_message_parse_stream_status a a a -- void", "FUNCTION: gst_message_parse_stream_status ( message type owner -- void )", "EXTERN: \"C\" void gst_message_parse_stream_status( void * message, void * type, void * owner );", "	( message type owner -- )" );
	swigFunction( "c-function gst_message_set_stream_status_object gst_message_set_stream_status_object a a -- void", "FUNCTION: gst_message_set_stream_status_object ( message object -- void )", "EXTERN: \"C\" void gst_message_set_stream_status_object( void * message, void * object );", "	( message object -- )" );
	swigFunction( "c-function gst_message_get_stream_status_object gst_message_get_stream_status_object a -- a", "FUNCTION: gst_message_get_stream_status_object ( message -- a )", "EXTERN: \"C\" void * gst_message_get_stream_status_object( void * message );", "	( message -- )" );
	swigFunction( "c-function gst_message_new_request_state gst_message_new_request_state a n -- a", "FUNCTION: gst_message_new_request_state ( src state -- a )", "EXTERN: \"C\" void * gst_message_new_request_state( void * src, int state );", "	( src state -- )" );
	swigFunction( "c-function gst_message_parse_request_state gst_message_parse_request_state a a -- void", "FUNCTION: gst_message_parse_request_state ( message state -- void )", "EXTERN: \"C\" void gst_message_parse_request_state( void * message, void * state );", "	( message state -- )" );
	swigFunction( "c-function gst_message_new_step_start gst_message_new_step_start a n u ud r n n -- a", "FUNCTION: gst_message_new_step_start ( src active format amount rate flush intermediate -- a )", "EXTERN: \"C\" void * gst_message_new_step_start( void * src, int active, int format, long long amount, double rate, int flush, int intermediate );", "	( src active format amount rate flush intermediate -- )" );
	swigFunction( "c-function gst_message_parse_step_start gst_message_parse_step_start a a a a a a a -- void", "FUNCTION: gst_message_parse_step_start ( message active format amount rate flush intermediate -- void )", "EXTERN: \"C\" void gst_message_parse_step_start( void * message, void * active, void * format, void * amount, void * rate, void * flush, void * intermediate );", "	( message active format amount rate flush intermediate -- )" );
	swigFunction( "c-function gst_message_new_qos gst_message_new_qos a n ud ud ud ud -- a", "FUNCTION: gst_message_new_qos ( src live running_time stream_time timestamp duration -- a )", "EXTERN: \"C\" void * gst_message_new_qos( void * src, int live, long long running_time, long long stream_time, long long timestamp, long long duration );", "	( src live running_time stream_time timestamp duration -- )" );
	swigFunction( "c-function gst_message_set_qos_values gst_message_set_qos_values a d r n -- void", "FUNCTION: gst_message_set_qos_values ( message jitter proportion quality -- void )", "EXTERN: \"C\" void gst_message_set_qos_values( void * message, long long jitter, double proportion, int quality );", "	( message jitter proportion quality -- )" );
	swigFunction( "c-function gst_message_set_qos_stats gst_message_set_qos_stats a u ud ud -- void", "FUNCTION: gst_message_set_qos_stats ( message format processed dropped -- void )", "EXTERN: \"C\" void gst_message_set_qos_stats( void * message, int format, long long processed, long long dropped );", "	( message format processed dropped -- )" );
	swigFunction( "c-function gst_message_parse_qos gst_message_parse_qos a a a a a a -- void", "FUNCTION: gst_message_parse_qos ( message live running_time stream_time timestamp duration -- void )", "EXTERN: \"C\" void gst_message_parse_qos( void * message, void * live, void * running_time, void * stream_time, void * timestamp, void * duration );", "	( message live running_time stream_time timestamp duration -- )" );
	swigFunction( "c-function gst_message_parse_qos_values gst_message_parse_qos_values a a a a -- void", "FUNCTION: gst_message_parse_qos_values ( message jitter proportion quality -- void )", "EXTERN: \"C\" void gst_message_parse_qos_values( void * message, void * jitter, void * proportion, void * quality );", "	( message jitter proportion quality -- )" );
	swigFunction( "c-function gst_message_parse_qos_stats gst_message_parse_qos_stats a a a a -- void", "FUNCTION: gst_message_parse_qos_stats ( message format processed dropped -- void )", "EXTERN: \"C\" void gst_message_parse_qos_stats( void * message, void * format, void * processed, void * dropped );", "	( message format processed dropped -- )" );
	swigFunction( "c-function gst_message_new_progress gst_message_new_progress a n s s -- a", "FUNCTION: gst_message_new_progress ( src type code text -- a )", "EXTERN: \"C\" void * gst_message_new_progress( void * src, int type, char * code, char * text );", "	( src type code text -- )" );
	swigFunction( "c-function gst_message_parse_progress gst_message_parse_progress a a a a -- void", "FUNCTION: gst_message_parse_progress ( message type code text -- void )", "EXTERN: \"C\" void gst_message_parse_progress( void * message, void * type, void * code, void * text );", "	( message type code text -- )" );
	swigFunction( "c-function gst_message_new_toc gst_message_new_toc a a n -- a", "FUNCTION: gst_message_new_toc ( src toc updated -- a )", "EXTERN: \"C\" void * gst_message_new_toc( void * src, void * toc, int updated );", "	( src toc updated -- )" );
	swigFunction( "c-function gst_message_parse_toc gst_message_parse_toc a a a -- void", "FUNCTION: gst_message_parse_toc ( message toc updated -- void )", "EXTERN: \"C\" void gst_message_parse_toc( void * message, void * toc, void * updated );", "	( message toc updated -- )" );
	swigFunction( "c-function gst_message_new_reset_time gst_message_new_reset_time a ud -- a", "FUNCTION: gst_message_new_reset_time ( src running_time -- a )", "EXTERN: \"C\" void * gst_message_new_reset_time( void * src, long long running_time );", "	( src running_time -- )" );
	swigFunction( "c-function gst_message_parse_reset_time gst_message_parse_reset_time a a -- void", "FUNCTION: gst_message_parse_reset_time ( message running_time -- void )", "EXTERN: \"C\" void gst_message_parse_reset_time( void * message, void * running_time );", "	( message running_time -- )" );
	swigFunction( "c-function gst_message_new_stream_start gst_message_new_stream_start a -- a", "FUNCTION: gst_message_new_stream_start ( src -- a )", "EXTERN: \"C\" void * gst_message_new_stream_start( void * src );", "	( src -- )" );
	swigFunction( "c-function gst_message_set_group_id gst_message_set_group_id a u -- void", "FUNCTION: gst_message_set_group_id ( message group_id -- void )", "EXTERN: \"C\" void gst_message_set_group_id( void * message, int group_id );", "	( message group_id -- )" );
	swigFunction( "c-function gst_message_parse_group_id gst_message_parse_group_id a a -- n", "FUNCTION: gst_message_parse_group_id ( message group_id -- n )", "EXTERN: \"C\" int gst_message_parse_group_id( void * message, void * group_id );", "	( message group_id -- )" );
	swigFunction( "c-function gst_message_new_need_context gst_message_new_need_context a s -- a", "FUNCTION: gst_message_new_need_context ( src context_type -- a )", "EXTERN: \"C\" void * gst_message_new_need_context( void * src, char * context_type );", "	( src context_type -- )" );
	swigFunction( "c-function gst_message_parse_context_type gst_message_parse_context_type a a -- n", "FUNCTION: gst_message_parse_context_type ( message context_type -- n )", "EXTERN: \"C\" int gst_message_parse_context_type( void * message, void * context_type );", "	( message context_type -- )" );
	swigFunction( "c-function gst_message_new_have_context gst_message_new_have_context a a -- a", "FUNCTION: gst_message_new_have_context ( src context -- a )", "EXTERN: \"C\" void * gst_message_new_have_context( void * src, void * context );", "	( src context -- )" );
	swigFunction( "c-function gst_message_parse_have_context gst_message_parse_have_context a a -- void", "FUNCTION: gst_message_parse_have_context ( message context -- void )", "EXTERN: \"C\" void gst_message_parse_have_context( void * message, void * context );", "	( message context -- )" );
	swigFunction( "c-function gst_message_new_device_added gst_message_new_device_added a a -- a", "FUNCTION: gst_message_new_device_added ( src device -- a )", "EXTERN: \"C\" void * gst_message_new_device_added( void * src, void * device );", "	( src device -- )" );
	swigFunction( "c-function gst_message_parse_device_added gst_message_parse_device_added a a -- void", "FUNCTION: gst_message_parse_device_added ( message device -- void )", "EXTERN: \"C\" void gst_message_parse_device_added( void * message, void * device );", "	( message device -- )" );
	swigFunction( "c-function gst_message_new_device_removed gst_message_new_device_removed a a -- a", "FUNCTION: gst_message_new_device_removed ( src device -- a )", "EXTERN: \"C\" void * gst_message_new_device_removed( void * src, void * device );", "	( src device -- )" );
	swigFunction( "c-function gst_message_parse_device_removed gst_message_parse_device_removed a a -- void", "FUNCTION: gst_message_parse_device_removed ( message device -- void )", "EXTERN: \"C\" void gst_message_parse_device_removed( void * message, void * device );", "	( message device -- )" );
	swigFunction( "c-function gst_message_new_property_notify gst_message_new_property_notify a s a -- a", "FUNCTION: gst_message_new_property_notify ( src property_name val -- a )", "EXTERN: \"C\" void * gst_message_new_property_notify( void * src, char * property_name, void * val );", "	( src property_name val -- )" );
	swigFunction( "c-function gst_message_parse_property_notify gst_message_parse_property_notify a a a a -- void", "FUNCTION: gst_message_parse_property_notify ( message object property_name property_value -- void )", "EXTERN: \"C\" void gst_message_parse_property_notify( void * message, void * object, void * property_name, void * property_value );", "	( message object property_name property_value -- )" );
	swigFunction( "c-function gst_message_new_stream_collection gst_message_new_stream_collection a a -- a", "FUNCTION: gst_message_new_stream_collection ( src collection -- a )", "EXTERN: \"C\" void * gst_message_new_stream_collection( void * src, void * collection );", "	( src collection -- )" );
	swigFunction( "c-function gst_message_parse_stream_collection gst_message_parse_stream_collection a a -- void", "FUNCTION: gst_message_parse_stream_collection ( message collection -- void )", "EXTERN: \"C\" void gst_message_parse_stream_collection( void * message, void * collection );", "	( message collection -- )" );
	swigFunction( "c-function gst_message_new_streams_selected gst_message_new_streams_selected a a -- a", "FUNCTION: gst_message_new_streams_selected ( src collection -- a )", "EXTERN: \"C\" void * gst_message_new_streams_selected( void * src, void * collection );", "	( src collection -- )" );
	swigFunction( "c-function gst_message_streams_selected_add gst_message_streams_selected_add a a -- void", "FUNCTION: gst_message_streams_selected_add ( message stream -- void )", "EXTERN: \"C\" void gst_message_streams_selected_add( void * message, void * stream );", "	( message stream -- )" );
	swigFunction( "c-function gst_message_parse_streams_selected gst_message_parse_streams_selected a a -- void", "FUNCTION: gst_message_parse_streams_selected ( message collection -- void )", "EXTERN: \"C\" void gst_message_parse_streams_selected( void * message, void * collection );", "	( message collection -- )" );
	swigFunction( "c-function gst_message_streams_selected_get_size gst_message_streams_selected_get_size a -- u", "FUNCTION: gst_message_streams_selected_get_size ( message -- u )", "EXTERN: \"C\" int gst_message_streams_selected_get_size( void * message );", "	( message -- )" );
	swigFunction( "c-function gst_message_streams_selected_get_stream gst_message_streams_selected_get_stream a u -- a", "FUNCTION: gst_message_streams_selected_get_stream ( message idx -- a )", "EXTERN: \"C\" void * gst_message_streams_selected_get_stream( void * message, int idx );", "	( message idx -- )" );
	swigFunction( "c-function gst_message_new_redirect gst_message_new_redirect a s a a -- a", "FUNCTION: gst_message_new_redirect ( src location tag_list entry_struct -- a )", "EXTERN: \"C\" void * gst_message_new_redirect( void * src, char * location, void * tag_list, void * entry_struct );", "	( src location tag_list entry_struct -- )" );
	swigFunction( "c-function gst_message_add_redirect_entry gst_message_add_redirect_entry a s a a -- void", "FUNCTION: gst_message_add_redirect_entry ( message location tag_list entry_struct -- void )", "EXTERN: \"C\" void gst_message_add_redirect_entry( void * message, char * location, void * tag_list, void * entry_struct );", "	( message location tag_list entry_struct -- )" );
	swigFunction( "c-function gst_message_parse_redirect_entry gst_message_parse_redirect_entry a u a a a -- void", "FUNCTION: gst_message_parse_redirect_entry ( message entry_index location tag_list entry_struct -- void )", "EXTERN: \"C\" void gst_message_parse_redirect_entry( void * message, int entry_index, void * location, void * tag_list, void * entry_struct );", "	( message entry_index location tag_list entry_struct -- )" );
	swigFunction( "c-function gst_message_get_num_redirect_entries gst_message_get_num_redirect_entries a -- u", "FUNCTION: gst_message_get_num_redirect_entries ( message -- u )", "EXTERN: \"C\" int gst_message_get_num_redirect_entries( void * message );", "	( message -- )" );
	swigFunction( "c-function gst_memory_get_type gst_memory_get_type  -- u", "FUNCTION: gst_memory_get_type (  -- u )", "EXTERN: \"C\" int gst_memory_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_memory_init gst_memory_init a n a a u u u u -- void", "FUNCTION: gst_memory_init ( mem flags allocator parent maxsize align offset size -- void )", "EXTERN: \"C\" void gst_memory_init( void * mem, int flags, void * allocator, void * parent, int maxsize, int align, int offset, int size );", "	( mem flags allocator parent maxsize align offset size -- )" );
	swigFunction( "c-function gst_memory_is_type gst_memory_is_type a s -- n", "FUNCTION: gst_memory_is_type ( mem mem_type -- n )", "EXTERN: \"C\" int gst_memory_is_type( void * mem, char * mem_type );", "	( mem mem_type -- )" );
	swigFunction( "c-function gst_memory_ref gst_memory_ref a -- a", "FUNCTION: gst_memory_ref ( memory -- a )", "EXTERN: \"C\" void * gst_memory_ref( void * memory );", "	( memory -- )" );
	swigFunction( "c-function gst_memory_unref gst_memory_unref a -- void", "FUNCTION: gst_memory_unref ( memory -- void )", "EXTERN: \"C\" void gst_memory_unref( void * memory );", "	( memory -- )" );
	swigFunction( "c-function gst_memory_get_sizes gst_memory_get_sizes a a a -- u", "FUNCTION: gst_memory_get_sizes ( mem offset maxsize -- u )", "EXTERN: \"C\" int gst_memory_get_sizes( void * mem, void * offset, void * maxsize );", "	( mem offset maxsize -- )" );
	swigFunction( "c-function gst_memory_resize gst_memory_resize a n u -- void", "FUNCTION: gst_memory_resize ( mem offset size -- void )", "EXTERN: \"C\" void gst_memory_resize( void * mem, n offset, int size );", "	( mem offset size -- )" );
	swigFunction( "c-function gst_memory_make_mapped gst_memory_make_mapped a a n -- a", "FUNCTION: gst_memory_make_mapped ( mem info flags -- a )", "EXTERN: \"C\" void * gst_memory_make_mapped( void * mem, void * info, int flags );", "	( mem info flags -- )" );
	swigFunction( "c-function gst_memory_map gst_memory_map a a n -- n", "FUNCTION: gst_memory_map ( mem info flags -- n )", "EXTERN: \"C\" int gst_memory_map( void * mem, void * info, int flags );", "	( mem info flags -- )" );
	swigFunction( "c-function gst_memory_unmap gst_memory_unmap a a -- void", "FUNCTION: gst_memory_unmap ( mem info -- void )", "EXTERN: \"C\" void gst_memory_unmap( void * mem, void * info );", "	( mem info -- )" );
	swigFunction( "c-function gst_memory_copy gst_memory_copy a n n -- a", "FUNCTION: gst_memory_copy ( mem offset size -- a )", "EXTERN: \"C\" void * gst_memory_copy( void * mem, n offset, n size );", "	( mem offset size -- )" );
	swigFunction( "c-function gst_memory_share gst_memory_share a n n -- a", "FUNCTION: gst_memory_share ( mem offset size -- a )", "EXTERN: \"C\" void * gst_memory_share( void * mem, n offset, n size );", "	( mem offset size -- )" );
	swigFunction( "c-function gst_memory_is_span gst_memory_is_span a a a -- n", "FUNCTION: gst_memory_is_span ( mem1 mem2 offset -- n )", "EXTERN: \"C\" int gst_memory_is_span( void * mem1, void * mem2, void * offset );", "	( mem1 mem2 offset -- )" );
	swigFunction( "c-function gst_meta_api_type_register gst_meta_api_type_register s a -- u", "FUNCTION: gst_meta_api_type_register ( api tags -- u )", "EXTERN: \"C\" int gst_meta_api_type_register( char * api, void * tags );", "	( api tags -- )" );
	swigFunction( "c-function gst_meta_api_type_has_tag gst_meta_api_type_has_tag u n -- n", "FUNCTION: gst_meta_api_type_has_tag ( api tag -- n )", "EXTERN: \"C\" int gst_meta_api_type_has_tag( int api, n tag );", "	( api tag -- )" );
	swigFunction( "c-function gst_meta_register gst_meta_register u s u a a a -- a", "FUNCTION: gst_meta_register ( api impl size init_func free_func transform_func -- a )", "EXTERN: \"C\" void * gst_meta_register( int api, char * impl, int size, void * init_func, void * free_func, void * transform_func );", "	( api impl size init_func free_func transform_func -- )" );
	swigFunction( "c-function gst_meta_get_info gst_meta_get_info s -- a", "FUNCTION: gst_meta_get_info ( impl -- a )", "EXTERN: \"C\" void * gst_meta_get_info( char * impl );", "	( impl -- )" );
	swigFunction( "c-function gst_meta_api_type_get_tags gst_meta_api_type_get_tags u -- a", "FUNCTION: gst_meta_api_type_get_tags ( api -- a )", "EXTERN: \"C\" void * gst_meta_api_type_get_tags( int api );", "	( api -- )" );
	swigFunction( "c-function gst_mini_object_init gst_mini_object_init a u u a a a -- void", "FUNCTION: gst_mini_object_init ( mini_object flags type copy_func dispose_func free_func -- void )", "EXTERN: \"C\" void gst_mini_object_init( void * mini_object, int flags, int type, void * copy_func, void * dispose_func, void * free_func );", "	( mini_object flags type copy_func dispose_func free_func -- )" );
	swigFunction( "c-function gst_mini_object_ref gst_mini_object_ref a -- a", "FUNCTION: gst_mini_object_ref ( mini_object -- a )", "EXTERN: \"C\" void * gst_mini_object_ref( void * mini_object );", "	( mini_object -- )" );
	swigFunction( "c-function gst_mini_object_unref gst_mini_object_unref a -- void", "FUNCTION: gst_mini_object_unref ( mini_object -- void )", "EXTERN: \"C\" void gst_mini_object_unref( void * mini_object );", "	( mini_object -- )" );
	swigFunction( "c-function gst_mini_object_weak_ref gst_mini_object_weak_ref a a a -- void", "FUNCTION: gst_mini_object_weak_ref ( object notify data -- void )", "EXTERN: \"C\" void gst_mini_object_weak_ref( void * object, void * notify, void * data );", "	( object notify data -- )" );
	swigFunction( "c-function gst_mini_object_weak_unref gst_mini_object_weak_unref a a a -- void", "FUNCTION: gst_mini_object_weak_unref ( object notify data -- void )", "EXTERN: \"C\" void gst_mini_object_weak_unref( void * object, void * notify, void * data );", "	( object notify data -- )" );
	swigFunction( "c-function gst_mini_object_lock gst_mini_object_lock a n -- n", "FUNCTION: gst_mini_object_lock ( object flags -- n )", "EXTERN: \"C\" int gst_mini_object_lock( void * object, int flags );", "	( object flags -- )" );
	swigFunction( "c-function gst_mini_object_unlock gst_mini_object_unlock a n -- void", "FUNCTION: gst_mini_object_unlock ( object flags -- void )", "EXTERN: \"C\" void gst_mini_object_unlock( void * object, int flags );", "	( object flags -- )" );
	swigFunction( "c-function gst_mini_object_is_writable gst_mini_object_is_writable a -- n", "FUNCTION: gst_mini_object_is_writable ( mini_object -- n )", "EXTERN: \"C\" int gst_mini_object_is_writable( void * mini_object );", "	( mini_object -- )" );
	swigFunction( "c-function gst_mini_object_make_writable gst_mini_object_make_writable a -- a", "FUNCTION: gst_mini_object_make_writable ( mini_object -- a )", "EXTERN: \"C\" void * gst_mini_object_make_writable( void * mini_object );", "	( mini_object -- )" );
	swigFunction( "c-function gst_mini_object_copy gst_mini_object_copy a -- a", "FUNCTION: gst_mini_object_copy ( mini_object -- a )", "EXTERN: \"C\" void * gst_mini_object_copy( void * mini_object );", "	( mini_object -- )" );
	swigFunction( "c-function gst_mini_object_set_qdata gst_mini_object_set_qdata a n a a -- void", "FUNCTION: gst_mini_object_set_qdata ( object quark data destroy -- void )", "EXTERN: \"C\" void gst_mini_object_set_qdata( void * object, n quark, void * data, void * destroy );", "	( object quark data destroy -- )" );
	swigFunction( "c-function gst_mini_object_get_qdata gst_mini_object_get_qdata a n -- a", "FUNCTION: gst_mini_object_get_qdata ( object quark -- a )", "EXTERN: \"C\" void * gst_mini_object_get_qdata( void * object, n quark );", "	( object quark -- )" );
	swigFunction( "c-function gst_mini_object_steal_qdata gst_mini_object_steal_qdata a n -- a", "FUNCTION: gst_mini_object_steal_qdata ( object quark -- a )", "EXTERN: \"C\" void * gst_mini_object_steal_qdata( void * object, n quark );", "	( object quark -- )" );
	swigFunction( "c-function gst_mini_object_replace gst_mini_object_replace a a -- n", "FUNCTION: gst_mini_object_replace ( olddata newdata -- n )", "EXTERN: \"C\" int gst_mini_object_replace( void * olddata, void * newdata );", "	( olddata newdata -- )" );
	swigFunction( "c-function gst_mini_object_take gst_mini_object_take a a -- n", "FUNCTION: gst_mini_object_take ( olddata newdata -- n )", "EXTERN: \"C\" int gst_mini_object_take( void * olddata, void * newdata );", "	( olddata newdata -- )" );
	swigFunction( "c-function gst_mini_object_steal gst_mini_object_steal a -- a", "FUNCTION: gst_mini_object_steal ( olddata -- a )", "EXTERN: \"C\" void * gst_mini_object_steal( void * olddata );", "	( olddata -- )" );
	swigFunction( "c-function gst_object_get_type gst_object_get_type  -- u", "FUNCTION: gst_object_get_type (  -- u )", "EXTERN: \"C\" int gst_object_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_object_set_name gst_object_set_name a s -- n", "FUNCTION: gst_object_set_name ( object name -- n )", "EXTERN: \"C\" int gst_object_set_name( void * object, char * name );", "	( object name -- )" );
	swigFunction( "c-function gst_object_get_name gst_object_get_name a -- a", "FUNCTION: gst_object_get_name ( object -- a )", "EXTERN: \"C\" void * gst_object_get_name( void * object );", "	( object -- )" );
	swigFunction( "c-function gst_object_set_parent gst_object_set_parent a a -- n", "FUNCTION: gst_object_set_parent ( object parent -- n )", "EXTERN: \"C\" int gst_object_set_parent( void * object, void * parent );", "	( object parent -- )" );
	swigFunction( "c-function gst_object_get_parent gst_object_get_parent a -- a", "FUNCTION: gst_object_get_parent ( object -- a )", "EXTERN: \"C\" void * gst_object_get_parent( void * object );", "	( object -- )" );
	swigFunction( "c-function gst_object_unparent gst_object_unparent a -- void", "FUNCTION: gst_object_unparent ( object -- void )", "EXTERN: \"C\" void gst_object_unparent( void * object );", "	( object -- )" );
	swigFunction( "c-function gst_object_has_as_parent gst_object_has_as_parent a a -- n", "FUNCTION: gst_object_has_as_parent ( object parent -- n )", "EXTERN: \"C\" int gst_object_has_as_parent( void * object, void * parent );", "	( object parent -- )" );
	swigFunction( "c-function gst_object_has_as_ancestor gst_object_has_as_ancestor a a -- n", "FUNCTION: gst_object_has_as_ancestor ( object ancestor -- n )", "EXTERN: \"C\" int gst_object_has_as_ancestor( void * object, void * ancestor );", "	( object ancestor -- )" );
	swigFunction( "c-function gst_object_has_ancestor gst_object_has_ancestor a a -- n", "FUNCTION: gst_object_has_ancestor ( object ancestor -- n )", "EXTERN: \"C\" int gst_object_has_ancestor( void * object, void * ancestor );", "	( object ancestor -- )" );
	swigFunction( "c-function gst_object_default_deep_notify gst_object_default_deep_notify a a a a -- void", "FUNCTION: gst_object_default_deep_notify ( object orig pspec excluded_props -- void )", "EXTERN: \"C\" void gst_object_default_deep_notify( void * object, void * orig, void * pspec, void * excluded_props );", "	( object orig pspec excluded_props -- )" );
	swigFunction( "c-function gst_object_ref gst_object_ref a -- a", "FUNCTION: gst_object_ref ( object -- a )", "EXTERN: \"C\" void * gst_object_ref( void * object );", "	( object -- )" );
	swigFunction( "c-function gst_object_unref gst_object_unref a -- void", "FUNCTION: gst_object_unref ( object -- void )", "EXTERN: \"C\" void gst_object_unref( void * object );", "	( object -- )" );
	swigFunction( "c-function gst_object_ref_sink gst_object_ref_sink a -- a", "FUNCTION: gst_object_ref_sink ( object -- a )", "EXTERN: \"C\" void * gst_object_ref_sink( void * object );", "	( object -- )" );
	swigFunction( "c-function gst_object_replace gst_object_replace a a -- n", "FUNCTION: gst_object_replace ( oldobj newobj -- n )", "EXTERN: \"C\" int gst_object_replace( void * oldobj, void * newobj );", "	( oldobj newobj -- )" );
	swigFunction( "c-function gst_object_get_path_string gst_object_get_path_string a -- a", "FUNCTION: gst_object_get_path_string ( object -- a )", "EXTERN: \"C\" void * gst_object_get_path_string( void * object );", "	( object -- )" );
	swigFunction( "c-function gst_object_check_uniqueness gst_object_check_uniqueness a s -- n", "FUNCTION: gst_object_check_uniqueness ( list name -- n )", "EXTERN: \"C\" int gst_object_check_uniqueness( void * list, char * name );", "	( list name -- )" );
	swigFunction( "c-function gst_object_suggest_next_sync gst_object_suggest_next_sync a -- ud", "FUNCTION: gst_object_suggest_next_sync ( object -- ud )", "EXTERN: \"C\" long long gst_object_suggest_next_sync( void * object );", "	( object -- )" );
	swigFunction( "c-function gst_object_sync_values gst_object_sync_values a ud -- n", "FUNCTION: gst_object_sync_values ( object timestamp -- n )", "EXTERN: \"C\" int gst_object_sync_values( void * object, long long timestamp );", "	( object timestamp -- )" );
	swigFunction( "c-function gst_object_has_active_control_bindings gst_object_has_active_control_bindings a -- n", "FUNCTION: gst_object_has_active_control_bindings ( object -- n )", "EXTERN: \"C\" int gst_object_has_active_control_bindings( void * object );", "	( object -- )" );
	swigFunction( "c-function gst_object_set_control_bindings_disabled gst_object_set_control_bindings_disabled a n -- void", "FUNCTION: gst_object_set_control_bindings_disabled ( object disabled -- void )", "EXTERN: \"C\" void gst_object_set_control_bindings_disabled( void * object, int disabled );", "	( object disabled -- )" );
	swigFunction( "c-function gst_object_set_control_binding_disabled gst_object_set_control_binding_disabled a s n -- void", "FUNCTION: gst_object_set_control_binding_disabled ( object property_name disabled -- void )", "EXTERN: \"C\" void gst_object_set_control_binding_disabled( void * object, char * property_name, int disabled );", "	( object property_name disabled -- )" );
	swigFunction( "c-function gst_object_add_control_binding gst_object_add_control_binding a a -- n", "FUNCTION: gst_object_add_control_binding ( object binding -- n )", "EXTERN: \"C\" int gst_object_add_control_binding( void * object, void * binding );", "	( object binding -- )" );
	swigFunction( "c-function gst_object_get_control_binding gst_object_get_control_binding a s -- a", "FUNCTION: gst_object_get_control_binding ( object property_name -- a )", "EXTERN: \"C\" void * gst_object_get_control_binding( void * object, char * property_name );", "	( object property_name -- )" );
	swigFunction( "c-function gst_object_remove_control_binding gst_object_remove_control_binding a a -- n", "FUNCTION: gst_object_remove_control_binding ( object binding -- n )", "EXTERN: \"C\" int gst_object_remove_control_binding( void * object, void * binding );", "	( object binding -- )" );
	swigFunction( "c-function gst_object_get_value gst_object_get_value a s ud -- a", "FUNCTION: gst_object_get_value ( object property_name timestamp -- a )", "EXTERN: \"C\" void * gst_object_get_value( void * object, char * property_name, long long timestamp );", "	( object property_name timestamp -- )" );
	swigFunction( "c-function gst_object_get_value_array gst_object_get_value_array a s ud ud u a -- n", "FUNCTION: gst_object_get_value_array ( object property_name timestamp interval n_values values -- n )", "EXTERN: \"C\" int gst_object_get_value_array( void * object, char * property_name, long long timestamp, long long interval, int n_values, void * values );", "	( object property_name timestamp interval n_values values -- )" );
	swigFunction( "c-function gst_object_get_g_value_array gst_object_get_g_value_array a s ud ud u a -- n", "FUNCTION: gst_object_get_g_value_array ( object property_name timestamp interval n_values values -- n )", "EXTERN: \"C\" int gst_object_get_g_value_array( void * object, char * property_name, long long timestamp, long long interval, int n_values, void * values );", "	( object property_name timestamp interval n_values values -- )" );
	swigFunction( "c-function gst_object_get_control_rate gst_object_get_control_rate a -- ud", "FUNCTION: gst_object_get_control_rate ( object -- ud )", "EXTERN: \"C\" long long gst_object_get_control_rate( void * object );", "	( object -- )" );
	swigFunction( "c-function gst_object_set_control_rate gst_object_set_control_rate a ud -- void", "FUNCTION: gst_object_set_control_rate ( object control_rate -- void )", "EXTERN: \"C\" void gst_object_set_control_rate( void * object, long long control_rate );", "	( object control_rate -- )" );
	swigFunction( "c-function gst_pad_mode_get_name gst_pad_mode_get_name n -- s", "FUNCTION: gst_pad_mode_get_name ( mode -- s )", "EXTERN: \"C\" char * gst_pad_mode_get_name( int mode );", "	( mode -- )" );
	swigFunction( "c-function gst_flow_get_name gst_flow_get_name n -- s", "FUNCTION: gst_flow_get_name ( ret -- s )", "EXTERN: \"C\" char * gst_flow_get_name( int ret );", "	( ret -- )" );
	swigFunction( "c-function gst_flow_to_quark gst_flow_to_quark n -- n", "FUNCTION: gst_flow_to_quark ( ret -- n )", "EXTERN: \"C\" n gst_flow_to_quark( int ret );", "	( ret -- )" );
	swigFunction( "c-function gst_pad_link_get_name gst_pad_link_get_name n -- s", "FUNCTION: gst_pad_link_get_name ( ret -- s )", "EXTERN: \"C\" char * gst_pad_link_get_name( int ret );", "	( ret -- )" );
	swigFunction( "c-function gst_pad_probe_info_get_event gst_pad_probe_info_get_event a -- a", "FUNCTION: gst_pad_probe_info_get_event ( info -- a )", "EXTERN: \"C\" void * gst_pad_probe_info_get_event( void * info );", "	( info -- )" );
	swigFunction( "c-function gst_pad_probe_info_get_query gst_pad_probe_info_get_query a -- a", "FUNCTION: gst_pad_probe_info_get_query ( info -- a )", "EXTERN: \"C\" void * gst_pad_probe_info_get_query( void * info );", "	( info -- )" );
	swigFunction( "c-function gst_pad_probe_info_get_buffer gst_pad_probe_info_get_buffer a -- a", "FUNCTION: gst_pad_probe_info_get_buffer ( info -- a )", "EXTERN: \"C\" void * gst_pad_probe_info_get_buffer( void * info );", "	( info -- )" );
	swigFunction( "c-function gst_pad_probe_info_get_buffer_list gst_pad_probe_info_get_buffer_list a -- a", "FUNCTION: gst_pad_probe_info_get_buffer_list ( info -- a )", "EXTERN: \"C\" void * gst_pad_probe_info_get_buffer_list( void * info );", "	( info -- )" );
	swigFunction( "c-function gst_pad_get_type gst_pad_get_type  -- u", "FUNCTION: gst_pad_get_type (  -- u )", "EXTERN: \"C\" int gst_pad_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_pad_new gst_pad_new s n -- a", "FUNCTION: gst_pad_new ( name direction -- a )", "EXTERN: \"C\" void * gst_pad_new( char * name, int direction );", "	( name direction -- )" );
	swigFunction( "c-function gst_pad_new_from_template gst_pad_new_from_template a s -- a", "FUNCTION: gst_pad_new_from_template ( templ name -- a )", "EXTERN: \"C\" void * gst_pad_new_from_template( void * templ, char * name );", "	( templ name -- )" );
	swigFunction( "c-function gst_pad_new_from_static_template gst_pad_new_from_static_template a s -- a", "FUNCTION: gst_pad_new_from_static_template ( templ name -- a )", "EXTERN: \"C\" void * gst_pad_new_from_static_template( void * templ, char * name );", "	( templ name -- )" );
	swigFunction( "c-function gst_pad_get_direction gst_pad_get_direction a -- n", "FUNCTION: gst_pad_get_direction ( pad -- n )", "EXTERN: \"C\" int gst_pad_get_direction( void * pad );", "	( pad -- )" );
	swigFunction( "c-function gst_pad_set_active gst_pad_set_active a n -- n", "FUNCTION: gst_pad_set_active ( pad active -- n )", "EXTERN: \"C\" int gst_pad_set_active( void * pad, int active );", "	( pad active -- )" );
	swigFunction( "c-function gst_pad_is_active gst_pad_is_active a -- n", "FUNCTION: gst_pad_is_active ( pad -- n )", "EXTERN: \"C\" int gst_pad_is_active( void * pad );", "	( pad -- )" );
	swigFunction( "c-function gst_pad_activate_mode gst_pad_activate_mode a n n -- n", "FUNCTION: gst_pad_activate_mode ( pad mode active -- n )", "EXTERN: \"C\" int gst_pad_activate_mode( void * pad, int mode, int active );", "	( pad mode active -- )" );
	swigFunction( "c-function gst_pad_add_probe gst_pad_add_probe a n a a a -- n", "FUNCTION: gst_pad_add_probe ( pad mask callback user_data destroy_data -- n )", "EXTERN: \"C\" n gst_pad_add_probe( void * pad, int mask, void * callback, void * user_data, void * destroy_data );", "	( pad mask callback user_data destroy_data -- )" );
	swigFunction( "c-function gst_pad_remove_probe gst_pad_remove_probe a n -- void", "FUNCTION: gst_pad_remove_probe ( pad id -- void )", "EXTERN: \"C\" void gst_pad_remove_probe( void * pad, n id );", "	( pad id -- )" );
	swigFunction( "c-function gst_pad_is_blocked gst_pad_is_blocked a -- n", "FUNCTION: gst_pad_is_blocked ( pad -- n )", "EXTERN: \"C\" int gst_pad_is_blocked( void * pad );", "	( pad -- )" );
	swigFunction( "c-function gst_pad_is_blocking gst_pad_is_blocking a -- n", "FUNCTION: gst_pad_is_blocking ( pad -- n )", "EXTERN: \"C\" int gst_pad_is_blocking( void * pad );", "	( pad -- )" );
	swigFunction( "c-function gst_pad_mark_reconfigure gst_pad_mark_reconfigure a -- void", "FUNCTION: gst_pad_mark_reconfigure ( pad -- void )", "EXTERN: \"C\" void gst_pad_mark_reconfigure( void * pad );", "	( pad -- )" );
	swigFunction( "c-function gst_pad_needs_reconfigure gst_pad_needs_reconfigure a -- n", "FUNCTION: gst_pad_needs_reconfigure ( pad -- n )", "EXTERN: \"C\" int gst_pad_needs_reconfigure( void * pad );", "	( pad -- )" );
	swigFunction( "c-function gst_pad_check_reconfigure gst_pad_check_reconfigure a -- n", "FUNCTION: gst_pad_check_reconfigure ( pad -- n )", "EXTERN: \"C\" int gst_pad_check_reconfigure( void * pad );", "	( pad -- )" );
	swigFunction( "c-function gst_pad_set_element_private gst_pad_set_element_private a a -- void", "FUNCTION: gst_pad_set_element_private ( pad priv -- void )", "EXTERN: \"C\" void gst_pad_set_element_private( void * pad, void * priv );", "	( pad priv -- )" );
	swigFunction( "c-function gst_pad_get_element_private gst_pad_get_element_private a -- a", "FUNCTION: gst_pad_get_element_private ( pad -- a )", "EXTERN: \"C\" void * gst_pad_get_element_private( void * pad );", "	( pad -- )" );
	swigFunction( "c-function gst_pad_get_pad_template gst_pad_get_pad_template a -- a", "FUNCTION: gst_pad_get_pad_template ( pad -- a )", "EXTERN: \"C\" void * gst_pad_get_pad_template( void * pad );", "	( pad -- )" );
	swigFunction( "c-function gst_pad_store_sticky_event gst_pad_store_sticky_event a a -- n", "FUNCTION: gst_pad_store_sticky_event ( pad event -- n )", "EXTERN: \"C\" int gst_pad_store_sticky_event( void * pad, void * event );", "	( pad event -- )" );
	swigFunction( "c-function gst_pad_get_sticky_event gst_pad_get_sticky_event a n u -- a", "FUNCTION: gst_pad_get_sticky_event ( pad event_type idx -- a )", "EXTERN: \"C\" void * gst_pad_get_sticky_event( void * pad, int event_type, int idx );", "	( pad event_type idx -- )" );
	swigFunction( "c-function gst_pad_sticky_events_foreach gst_pad_sticky_events_foreach a a a -- void", "FUNCTION: gst_pad_sticky_events_foreach ( pad foreach_func user_data -- void )", "EXTERN: \"C\" void gst_pad_sticky_events_foreach( void * pad, void * foreach_func, void * user_data );", "	( pad foreach_func user_data -- )" );
	swigFunction( "c-function gst_pad_set_activate_function_full gst_pad_set_activate_function_full a a a a -- void", "FUNCTION: gst_pad_set_activate_function_full ( pad activate user_data notify -- void )", "EXTERN: \"C\" void gst_pad_set_activate_function_full( void * pad, void * activate, void * user_data, void * notify );", "	( pad activate user_data notify -- )" );
	swigFunction( "c-function gst_pad_set_activatemode_function_full gst_pad_set_activatemode_function_full a a a a -- void", "FUNCTION: gst_pad_set_activatemode_function_full ( pad activatemode user_data notify -- void )", "EXTERN: \"C\" void gst_pad_set_activatemode_function_full( void * pad, void * activatemode, void * user_data, void * notify );", "	( pad activatemode user_data notify -- )" );
	swigFunction( "c-function gst_pad_set_chain_function_full gst_pad_set_chain_function_full a a a a -- void", "FUNCTION: gst_pad_set_chain_function_full ( pad chain user_data notify -- void )", "EXTERN: \"C\" void gst_pad_set_chain_function_full( void * pad, void * chain, void * user_data, void * notify );", "	( pad chain user_data notify -- )" );
	swigFunction( "c-function gst_pad_set_chain_list_function_full gst_pad_set_chain_list_function_full a a a a -- void", "FUNCTION: gst_pad_set_chain_list_function_full ( pad chainlist user_data notify -- void )", "EXTERN: \"C\" void gst_pad_set_chain_list_function_full( void * pad, void * chainlist, void * user_data, void * notify );", "	( pad chainlist user_data notify -- )" );
	swigFunction( "c-function gst_pad_set_getrange_function_full gst_pad_set_getrange_function_full a a a a -- void", "FUNCTION: gst_pad_set_getrange_function_full ( pad get user_data notify -- void )", "EXTERN: \"C\" void gst_pad_set_getrange_function_full( void * pad, void * get, void * user_data, void * notify );", "	( pad get user_data notify -- )" );
	swigFunction( "c-function gst_pad_set_event_function_full gst_pad_set_event_function_full a a a a -- void", "FUNCTION: gst_pad_set_event_function_full ( pad event user_data notify -- void )", "EXTERN: \"C\" void gst_pad_set_event_function_full( void * pad, void * event, void * user_data, void * notify );", "	( pad event user_data notify -- )" );
	swigFunction( "c-function gst_pad_set_event_full_function_full gst_pad_set_event_full_function_full a a a a -- void", "FUNCTION: gst_pad_set_event_full_function_full ( pad event user_data notify -- void )", "EXTERN: \"C\" void gst_pad_set_event_full_function_full( void * pad, void * event, void * user_data, void * notify );", "	( pad event user_data notify -- )" );
	swigFunction( "c-function gst_pad_set_link_function_full gst_pad_set_link_function_full a a a a -- void", "FUNCTION: gst_pad_set_link_function_full ( pad link user_data notify -- void )", "EXTERN: \"C\" void gst_pad_set_link_function_full( void * pad, void * link, void * user_data, void * notify );", "	( pad link user_data notify -- )" );
	swigFunction( "c-function gst_pad_set_unlink_function_full gst_pad_set_unlink_function_full a a a a -- void", "FUNCTION: gst_pad_set_unlink_function_full ( pad unlink user_data notify -- void )", "EXTERN: \"C\" void gst_pad_set_unlink_function_full( void * pad, void * unlink, void * user_data, void * notify );", "	( pad unlink user_data notify -- )" );
	swigFunction( "c-function gst_pad_can_link gst_pad_can_link a a -- n", "FUNCTION: gst_pad_can_link ( srcpad sinkpad -- n )", "EXTERN: \"C\" int gst_pad_can_link( void * srcpad, void * sinkpad );", "	( srcpad sinkpad -- )" );
	swigFunction( "c-function gst_pad_link gst_pad_link a a -- n", "FUNCTION: gst_pad_link ( srcpad sinkpad -- n )", "EXTERN: \"C\" int gst_pad_link( void * srcpad, void * sinkpad );", "	( srcpad sinkpad -- )" );
	swigFunction( "c-function gst_pad_link_full gst_pad_link_full a a n -- n", "FUNCTION: gst_pad_link_full ( srcpad sinkpad flags -- n )", "EXTERN: \"C\" int gst_pad_link_full( void * srcpad, void * sinkpad, int flags );", "	( srcpad sinkpad flags -- )" );
	swigFunction( "c-function gst_pad_unlink gst_pad_unlink a a -- n", "FUNCTION: gst_pad_unlink ( srcpad sinkpad -- n )", "EXTERN: \"C\" int gst_pad_unlink( void * srcpad, void * sinkpad );", "	( srcpad sinkpad -- )" );
	swigFunction( "c-function gst_pad_is_linked gst_pad_is_linked a -- n", "FUNCTION: gst_pad_is_linked ( pad -- n )", "EXTERN: \"C\" int gst_pad_is_linked( void * pad );", "	( pad -- )" );
	swigFunction( "c-function gst_pad_get_peer gst_pad_get_peer a -- a", "FUNCTION: gst_pad_get_peer ( pad -- a )", "EXTERN: \"C\" void * gst_pad_get_peer( void * pad );", "	( pad -- )" );
	swigFunction( "c-function gst_pad_get_pad_template_caps gst_pad_get_pad_template_caps a -- a", "FUNCTION: gst_pad_get_pad_template_caps ( pad -- a )", "EXTERN: \"C\" void * gst_pad_get_pad_template_caps( void * pad );", "	( pad -- )" );
	swigFunction( "c-function gst_pad_get_current_caps gst_pad_get_current_caps a -- a", "FUNCTION: gst_pad_get_current_caps ( pad -- a )", "EXTERN: \"C\" void * gst_pad_get_current_caps( void * pad );", "	( pad -- )" );
	swigFunction( "c-function gst_pad_has_current_caps gst_pad_has_current_caps a -- n", "FUNCTION: gst_pad_has_current_caps ( pad -- n )", "EXTERN: \"C\" int gst_pad_has_current_caps( void * pad );", "	( pad -- )" );
	swigFunction( "c-function gst_pad_get_allowed_caps gst_pad_get_allowed_caps a -- a", "FUNCTION: gst_pad_get_allowed_caps ( pad -- a )", "EXTERN: \"C\" void * gst_pad_get_allowed_caps( void * pad );", "	( pad -- )" );
	swigFunction( "c-function gst_pad_get_offset gst_pad_get_offset a -- d", "FUNCTION: gst_pad_get_offset ( pad -- d )", "EXTERN: \"C\" long long gst_pad_get_offset( void * pad );", "	( pad -- )" );
	swigFunction( "c-function gst_pad_set_offset gst_pad_set_offset a d -- void", "FUNCTION: gst_pad_set_offset ( pad offset -- void )", "EXTERN: \"C\" void gst_pad_set_offset( void * pad, long long offset );", "	( pad offset -- )" );
	swigFunction( "c-function gst_pad_push gst_pad_push a a -- n", "FUNCTION: gst_pad_push ( pad buffer -- n )", "EXTERN: \"C\" int gst_pad_push( void * pad, void * buffer );", "	( pad buffer -- )" );
	swigFunction( "c-function gst_pad_push_list gst_pad_push_list a a -- n", "FUNCTION: gst_pad_push_list ( pad list -- n )", "EXTERN: \"C\" int gst_pad_push_list( void * pad, void * list );", "	( pad list -- )" );
	swigFunction( "c-function gst_pad_pull_range gst_pad_pull_range a ud u a -- n", "FUNCTION: gst_pad_pull_range ( pad offset size buffer -- n )", "EXTERN: \"C\" int gst_pad_pull_range( void * pad, long long offset, int size, void * buffer );", "	( pad offset size buffer -- )" );
	swigFunction( "c-function gst_pad_push_event gst_pad_push_event a a -- n", "FUNCTION: gst_pad_push_event ( pad event -- n )", "EXTERN: \"C\" int gst_pad_push_event( void * pad, void * event );", "	( pad event -- )" );
	swigFunction( "c-function gst_pad_event_default gst_pad_event_default a a a -- n", "FUNCTION: gst_pad_event_default ( pad parent event -- n )", "EXTERN: \"C\" int gst_pad_event_default( void * pad, void * parent, void * event );", "	( pad parent event -- )" );
	swigFunction( "c-function gst_pad_get_last_flow_return gst_pad_get_last_flow_return a -- n", "FUNCTION: gst_pad_get_last_flow_return ( pad -- n )", "EXTERN: \"C\" int gst_pad_get_last_flow_return( void * pad );", "	( pad -- )" );
	swigFunction( "c-function gst_pad_chain gst_pad_chain a a -- n", "FUNCTION: gst_pad_chain ( pad buffer -- n )", "EXTERN: \"C\" int gst_pad_chain( void * pad, void * buffer );", "	( pad buffer -- )" );
	swigFunction( "c-function gst_pad_chain_list gst_pad_chain_list a a -- n", "FUNCTION: gst_pad_chain_list ( pad list -- n )", "EXTERN: \"C\" int gst_pad_chain_list( void * pad, void * list );", "	( pad list -- )" );
	swigFunction( "c-function gst_pad_get_range gst_pad_get_range a ud u a -- n", "FUNCTION: gst_pad_get_range ( pad offset size buffer -- n )", "EXTERN: \"C\" int gst_pad_get_range( void * pad, long long offset, int size, void * buffer );", "	( pad offset size buffer -- )" );
	swigFunction( "c-function gst_pad_send_event gst_pad_send_event a a -- n", "FUNCTION: gst_pad_send_event ( pad event -- n )", "EXTERN: \"C\" int gst_pad_send_event( void * pad, void * event );", "	( pad event -- )" );
	swigFunction( "c-function gst_pad_start_task gst_pad_start_task a a a a -- n", "FUNCTION: gst_pad_start_task ( pad func user_data notify -- n )", "EXTERN: \"C\" int gst_pad_start_task( void * pad, void * func, void * user_data, void * notify );", "	( pad func user_data notify -- )" );
	swigFunction( "c-function gst_pad_pause_task gst_pad_pause_task a -- n", "FUNCTION: gst_pad_pause_task ( pad -- n )", "EXTERN: \"C\" int gst_pad_pause_task( void * pad );", "	( pad -- )" );
	swigFunction( "c-function gst_pad_stop_task gst_pad_stop_task a -- n", "FUNCTION: gst_pad_stop_task ( pad -- n )", "EXTERN: \"C\" int gst_pad_stop_task( void * pad );", "	( pad -- )" );
	swigFunction( "c-function gst_pad_get_task_state gst_pad_get_task_state a -- n", "FUNCTION: gst_pad_get_task_state ( pad -- n )", "EXTERN: \"C\" int gst_pad_get_task_state( void * pad );", "	( pad -- )" );
	swigFunction( "c-function gst_pad_set_iterate_internal_links_function_full gst_pad_set_iterate_internal_links_function_full a a a a -- void", "FUNCTION: gst_pad_set_iterate_internal_links_function_full ( pad iterintlink user_data notify -- void )", "EXTERN: \"C\" void gst_pad_set_iterate_internal_links_function_full( void * pad, void * iterintlink, void * user_data, void * notify );", "	( pad iterintlink user_data notify -- )" );
	swigFunction( "c-function gst_pad_iterate_internal_links gst_pad_iterate_internal_links a -- a", "FUNCTION: gst_pad_iterate_internal_links ( pad -- a )", "EXTERN: \"C\" void * gst_pad_iterate_internal_links( void * pad );", "	( pad -- )" );
	swigFunction( "c-function gst_pad_iterate_internal_links_default gst_pad_iterate_internal_links_default a a -- a", "FUNCTION: gst_pad_iterate_internal_links_default ( pad parent -- a )", "EXTERN: \"C\" void * gst_pad_iterate_internal_links_default( void * pad, void * parent );", "	( pad parent -- )" );
	swigFunction( "c-function gst_pad_query gst_pad_query a a -- n", "FUNCTION: gst_pad_query ( pad query -- n )", "EXTERN: \"C\" int gst_pad_query( void * pad, void * query );", "	( pad query -- )" );
	swigFunction( "c-function gst_pad_peer_query gst_pad_peer_query a a -- n", "FUNCTION: gst_pad_peer_query ( pad query -- n )", "EXTERN: \"C\" int gst_pad_peer_query( void * pad, void * query );", "	( pad query -- )" );
	swigFunction( "c-function gst_pad_set_query_function_full gst_pad_set_query_function_full a a a a -- void", "FUNCTION: gst_pad_set_query_function_full ( pad query user_data notify -- void )", "EXTERN: \"C\" void gst_pad_set_query_function_full( void * pad, void * query, void * user_data, void * notify );", "	( pad query user_data notify -- )" );
	swigFunction( "c-function gst_pad_query_default gst_pad_query_default a a a -- n", "FUNCTION: gst_pad_query_default ( pad parent query -- n )", "EXTERN: \"C\" int gst_pad_query_default( void * pad, void * parent, void * query );", "	( pad parent query -- )" );
	swigFunction( "c-function gst_pad_forward gst_pad_forward a a a -- n", "FUNCTION: gst_pad_forward ( pad forward user_data -- n )", "EXTERN: \"C\" int gst_pad_forward( void * pad, void * forward, void * user_data );", "	( pad forward user_data -- )" );
	swigFunction( "c-function gst_param_spec_fraction_get_type gst_param_spec_fraction_get_type  -- u", "FUNCTION: gst_param_spec_fraction_get_type (  -- u )", "EXTERN: \"C\" int gst_param_spec_fraction_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_param_spec_array_get_type gst_param_spec_array_get_type  -- u", "FUNCTION: gst_param_spec_array_get_type (  -- u )", "EXTERN: \"C\" int gst_param_spec_array_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_param_spec_fraction gst_param_spec_fraction s s s n n n n n n n -- a", "FUNCTION: gst_param_spec_fraction ( name nick blurb min_num min_denom max_num max_denom default_num default_denom flags -- a )", "EXTERN: \"C\" void * gst_param_spec_fraction( char * name, char * nick, char * blurb, int min_num, int min_denom, int max_num, int max_denom, int default_num, int default_denom, n flags );", "	( name nick blurb min_num min_denom max_num max_denom default_num default_denom flags -- )" );
	swigFunction( "c-function gst_param_spec_array gst_param_spec_array s s s a n -- a", "FUNCTION: gst_param_spec_array ( name nick blurb element_spec flags -- a )", "EXTERN: \"C\" void * gst_param_spec_array( char * name, char * nick, char * blurb, void * element_spec, n flags );", "	( name nick blurb element_spec flags -- )" );
	swigFunction( "c-function gst_pipeline_get_type gst_pipeline_get_type  -- u", "FUNCTION: gst_pipeline_get_type (  -- u )", "EXTERN: \"C\" int gst_pipeline_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_pipeline_new gst_pipeline_new s -- a", "FUNCTION: gst_pipeline_new ( name -- a )", "EXTERN: \"C\" void * gst_pipeline_new( char * name );", "	( name -- )" );
	swigFunction( "c-function gst_pipeline_get_bus gst_pipeline_get_bus a -- a", "FUNCTION: gst_pipeline_get_bus ( pipeline -- a )", "EXTERN: \"C\" void * gst_pipeline_get_bus( void * pipeline );", "	( pipeline -- )" );
	swigFunction( "c-function gst_pipeline_use_clock gst_pipeline_use_clock a a -- void", "FUNCTION: gst_pipeline_use_clock ( pipeline clock -- void )", "EXTERN: \"C\" void gst_pipeline_use_clock( void * pipeline, void * clock );", "	( pipeline clock -- )" );
	swigFunction( "c-function gst_pipeline_set_clock gst_pipeline_set_clock a a -- n", "FUNCTION: gst_pipeline_set_clock ( pipeline clock -- n )", "EXTERN: \"C\" int gst_pipeline_set_clock( void * pipeline, void * clock );", "	( pipeline clock -- )" );
	swigFunction( "c-function gst_pipeline_get_clock gst_pipeline_get_clock a -- a", "FUNCTION: gst_pipeline_get_clock ( pipeline -- a )", "EXTERN: \"C\" void * gst_pipeline_get_clock( void * pipeline );", "	( pipeline -- )" );
	swigFunction( "c-function gst_pipeline_get_pipeline_clock gst_pipeline_get_pipeline_clock a -- a", "FUNCTION: gst_pipeline_get_pipeline_clock ( pipeline -- a )", "EXTERN: \"C\" void * gst_pipeline_get_pipeline_clock( void * pipeline );", "	( pipeline -- )" );
	swigFunction( "c-function gst_pipeline_auto_clock gst_pipeline_auto_clock a -- void", "FUNCTION: gst_pipeline_auto_clock ( pipeline -- void )", "EXTERN: \"C\" void gst_pipeline_auto_clock( void * pipeline );", "	( pipeline -- )" );
	swigFunction( "c-function gst_pipeline_set_delay gst_pipeline_set_delay a ud -- void", "FUNCTION: gst_pipeline_set_delay ( pipeline delay -- void )", "EXTERN: \"C\" void gst_pipeline_set_delay( void * pipeline, long long delay );", "	( pipeline delay -- )" );
	swigFunction( "c-function gst_pipeline_get_delay gst_pipeline_get_delay a -- ud", "FUNCTION: gst_pipeline_get_delay ( pipeline -- ud )", "EXTERN: \"C\" long long gst_pipeline_get_delay( void * pipeline );", "	( pipeline -- )" );
	swigFunction( "c-function gst_pipeline_set_latency gst_pipeline_set_latency a ud -- void", "FUNCTION: gst_pipeline_set_latency ( pipeline latency -- void )", "EXTERN: \"C\" void gst_pipeline_set_latency( void * pipeline, long long latency );", "	( pipeline latency -- )" );
	swigFunction( "c-function gst_pipeline_get_latency gst_pipeline_get_latency a -- ud", "FUNCTION: gst_pipeline_get_latency ( pipeline -- ud )", "EXTERN: \"C\" long long gst_pipeline_get_latency( void * pipeline );", "	( pipeline -- )" );
	swigFunction( "c-function gst_pipeline_set_auto_flush_bus gst_pipeline_set_auto_flush_bus a n -- void", "FUNCTION: gst_pipeline_set_auto_flush_bus ( pipeline auto_flush -- void )", "EXTERN: \"C\" void gst_pipeline_set_auto_flush_bus( void * pipeline, int auto_flush );", "	( pipeline auto_flush -- )" );
	swigFunction( "c-function gst_pipeline_get_auto_flush_bus gst_pipeline_get_auto_flush_bus a -- n", "FUNCTION: gst_pipeline_get_auto_flush_bus ( pipeline -- n )", "EXTERN: \"C\" int gst_pipeline_get_auto_flush_bus( void * pipeline );", "	( pipeline -- )" );
	swigFunction( "c-function gst_plugin_error_quark gst_plugin_error_quark  -- n", "FUNCTION: gst_plugin_error_quark (  -- n )", "EXTERN: \"C\" n gst_plugin_error_quark(  );", "	( -- )" );
	swigFunction( "c-function gst_plugin_get_type gst_plugin_get_type  -- u", "FUNCTION: gst_plugin_get_type (  -- u )", "EXTERN: \"C\" int gst_plugin_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_plugin_register_static gst_plugin_register_static n n s s a s s s s s -- n", "FUNCTION: gst_plugin_register_static ( major_version minor_version name description init_func version license source package origin -- n )", "EXTERN: \"C\" int gst_plugin_register_static( int major_version, int minor_version, char * name, char * description, void * init_func, char * version, char * license, char * source, char * package, char * origin );", "	( major_version minor_version name description init_func version license source package origin -- )" );
	swigFunction( "c-function gst_plugin_register_static_full gst_plugin_register_static_full n n s s a s s s s s a -- n", "FUNCTION: gst_plugin_register_static_full ( major_version minor_version name description init_full_func version license source package origin user_data -- n )", "EXTERN: \"C\" int gst_plugin_register_static_full( int major_version, int minor_version, char * name, char * description, void * init_full_func, char * version, char * license, char * source, char * package, char * origin, void * user_data );", "	( major_version minor_version name description init_full_func version license source package origin user_data -- )" );
	swigFunction( "c-function gst_plugin_get_name gst_plugin_get_name a -- s", "FUNCTION: gst_plugin_get_name ( plugin -- s )", "EXTERN: \"C\" char * gst_plugin_get_name( void * plugin );", "	( plugin -- )" );
	swigFunction( "c-function gst_plugin_get_description gst_plugin_get_description a -- s", "FUNCTION: gst_plugin_get_description ( plugin -- s )", "EXTERN: \"C\" char * gst_plugin_get_description( void * plugin );", "	( plugin -- )" );
	swigFunction( "c-function gst_plugin_get_filename gst_plugin_get_filename a -- s", "FUNCTION: gst_plugin_get_filename ( plugin -- s )", "EXTERN: \"C\" char * gst_plugin_get_filename( void * plugin );", "	( plugin -- )" );
	swigFunction( "c-function gst_plugin_get_version gst_plugin_get_version a -- s", "FUNCTION: gst_plugin_get_version ( plugin -- s )", "EXTERN: \"C\" char * gst_plugin_get_version( void * plugin );", "	( plugin -- )" );
	swigFunction( "c-function gst_plugin_get_license gst_plugin_get_license a -- s", "FUNCTION: gst_plugin_get_license ( plugin -- s )", "EXTERN: \"C\" char * gst_plugin_get_license( void * plugin );", "	( plugin -- )" );
	swigFunction( "c-function gst_plugin_get_source gst_plugin_get_source a -- s", "FUNCTION: gst_plugin_get_source ( plugin -- s )", "EXTERN: \"C\" char * gst_plugin_get_source( void * plugin );", "	( plugin -- )" );
	swigFunction( "c-function gst_plugin_get_package gst_plugin_get_package a -- s", "FUNCTION: gst_plugin_get_package ( plugin -- s )", "EXTERN: \"C\" char * gst_plugin_get_package( void * plugin );", "	( plugin -- )" );
	swigFunction( "c-function gst_plugin_get_origin gst_plugin_get_origin a -- s", "FUNCTION: gst_plugin_get_origin ( plugin -- s )", "EXTERN: \"C\" char * gst_plugin_get_origin( void * plugin );", "	( plugin -- )" );
	swigFunction( "c-function gst_plugin_get_release_date_string gst_plugin_get_release_date_string a -- s", "FUNCTION: gst_plugin_get_release_date_string ( plugin -- s )", "EXTERN: \"C\" char * gst_plugin_get_release_date_string( void * plugin );", "	( plugin -- )" );
	swigFunction( "c-function gst_plugin_get_cache_data gst_plugin_get_cache_data a -- a", "FUNCTION: gst_plugin_get_cache_data ( plugin -- a )", "EXTERN: \"C\" void * gst_plugin_get_cache_data( void * plugin );", "	( plugin -- )" );
	swigFunction( "c-function gst_plugin_set_cache_data gst_plugin_set_cache_data a a -- void", "FUNCTION: gst_plugin_set_cache_data ( plugin cache_data -- void )", "EXTERN: \"C\" void gst_plugin_set_cache_data( void * plugin, void * cache_data );", "	( plugin cache_data -- )" );
	swigFunction( "c-function gst_plugin_is_loaded gst_plugin_is_loaded a -- n", "FUNCTION: gst_plugin_is_loaded ( plugin -- n )", "EXTERN: \"C\" int gst_plugin_is_loaded( void * plugin );", "	( plugin -- )" );
	swigFunction( "c-function gst_plugin_load_file gst_plugin_load_file s a -- a", "FUNCTION: gst_plugin_load_file ( filename error -- a )", "EXTERN: \"C\" void * gst_plugin_load_file( char * filename, void * error );", "	( filename error -- )" );
	swigFunction( "c-function gst_plugin_load gst_plugin_load a -- a", "FUNCTION: gst_plugin_load ( plugin -- a )", "EXTERN: \"C\" void * gst_plugin_load( void * plugin );", "	( plugin -- )" );
	swigFunction( "c-function gst_plugin_load_by_name gst_plugin_load_by_name s -- a", "FUNCTION: gst_plugin_load_by_name ( name -- a )", "EXTERN: \"C\" void * gst_plugin_load_by_name( char * name );", "	( name -- )" );
	swigFunction( "c-function gst_plugin_add_dependency gst_plugin_add_dependency a a a a n -- void", "FUNCTION: gst_plugin_add_dependency ( plugin env_vars paths names flags -- void )", "EXTERN: \"C\" void gst_plugin_add_dependency( void * plugin, void * env_vars, void * paths, void * names, int flags );", "	( plugin env_vars paths names flags -- )" );
	swigFunction( "c-function gst_plugin_add_dependency_simple gst_plugin_add_dependency_simple a s s s n -- void", "FUNCTION: gst_plugin_add_dependency_simple ( plugin env_vars paths names flags -- void )", "EXTERN: \"C\" void gst_plugin_add_dependency_simple( void * plugin, char * env_vars, char * paths, char * names, int flags );", "	( plugin env_vars paths names flags -- )" );
	swigFunction( "c-function gst_plugin_list_free gst_plugin_list_free a -- void", "FUNCTION: gst_plugin_list_free ( list -- void )", "EXTERN: \"C\" void gst_plugin_list_free( void * list );", "	( list -- )" );
	swigFunction( "c-function gst_poll_new gst_poll_new n -- a", "FUNCTION: gst_poll_new ( controllable -- a )", "EXTERN: \"C\" void * gst_poll_new( int controllable );", "	( controllable -- )" );
	swigFunction( "c-function gst_poll_new_timer gst_poll_new_timer  -- a", "FUNCTION: gst_poll_new_timer (  -- a )", "EXTERN: \"C\" void * gst_poll_new_timer(  );", "	( -- )" );
	swigFunction( "c-function gst_poll_free gst_poll_free a -- void", "FUNCTION: gst_poll_free ( set -- void )", "EXTERN: \"C\" void gst_poll_free( void * set );", "	( set -- )" );
	swigFunction( "c-function gst_poll_get_read_gpollfd gst_poll_get_read_gpollfd a a -- void", "FUNCTION: gst_poll_get_read_gpollfd ( set fd -- void )", "EXTERN: \"C\" void gst_poll_get_read_gpollfd( void * set, void * fd );", "	( set fd -- )" );
	swigFunction( "c-function gst_poll_fd_init gst_poll_fd_init a -- void", "FUNCTION: gst_poll_fd_init ( fd -- void )", "EXTERN: \"C\" void gst_poll_fd_init( void * fd );", "	( fd -- )" );
	swigFunction( "c-function gst_poll_add_fd gst_poll_add_fd a a -- n", "FUNCTION: gst_poll_add_fd ( set fd -- n )", "EXTERN: \"C\" int gst_poll_add_fd( void * set, void * fd );", "	( set fd -- )" );
	swigFunction( "c-function gst_poll_remove_fd gst_poll_remove_fd a a -- n", "FUNCTION: gst_poll_remove_fd ( set fd -- n )", "EXTERN: \"C\" int gst_poll_remove_fd( void * set, void * fd );", "	( set fd -- )" );
	swigFunction( "c-function gst_poll_fd_ctl_write gst_poll_fd_ctl_write a a n -- n", "FUNCTION: gst_poll_fd_ctl_write ( set fd active -- n )", "EXTERN: \"C\" int gst_poll_fd_ctl_write( void * set, void * fd, int active );", "	( set fd active -- )" );
	swigFunction( "c-function gst_poll_fd_ctl_read gst_poll_fd_ctl_read a a n -- n", "FUNCTION: gst_poll_fd_ctl_read ( set fd active -- n )", "EXTERN: \"C\" int gst_poll_fd_ctl_read( void * set, void * fd, int active );", "	( set fd active -- )" );
	swigFunction( "c-function gst_poll_fd_ignored gst_poll_fd_ignored a a -- void", "FUNCTION: gst_poll_fd_ignored ( set fd -- void )", "EXTERN: \"C\" void gst_poll_fd_ignored( void * set, void * fd );", "	( set fd -- )" );
	swigFunction( "c-function gst_poll_fd_has_closed gst_poll_fd_has_closed a a -- n", "FUNCTION: gst_poll_fd_has_closed ( set fd -- n )", "EXTERN: \"C\" int gst_poll_fd_has_closed( void * set, void * fd );", "	( set fd -- )" );
	swigFunction( "c-function gst_poll_fd_has_error gst_poll_fd_has_error a a -- n", "FUNCTION: gst_poll_fd_has_error ( set fd -- n )", "EXTERN: \"C\" int gst_poll_fd_has_error( void * set, void * fd );", "	( set fd -- )" );
	swigFunction( "c-function gst_poll_fd_can_read gst_poll_fd_can_read a a -- n", "FUNCTION: gst_poll_fd_can_read ( set fd -- n )", "EXTERN: \"C\" int gst_poll_fd_can_read( void * set, void * fd );", "	( set fd -- )" );
	swigFunction( "c-function gst_poll_fd_can_write gst_poll_fd_can_write a a -- n", "FUNCTION: gst_poll_fd_can_write ( set fd -- n )", "EXTERN: \"C\" int gst_poll_fd_can_write( void * set, void * fd );", "	( set fd -- )" );
	swigFunction( "c-function gst_poll_wait gst_poll_wait a ud -- n", "FUNCTION: gst_poll_wait ( set timeout -- n )", "EXTERN: \"C\" int gst_poll_wait( void * set, long long timeout );", "	( set timeout -- )" );
	swigFunction( "c-function gst_poll_set_controllable gst_poll_set_controllable a n -- n", "FUNCTION: gst_poll_set_controllable ( set controllable -- n )", "EXTERN: \"C\" int gst_poll_set_controllable( void * set, int controllable );", "	( set controllable -- )" );
	swigFunction( "c-function gst_poll_restart gst_poll_restart a -- void", "FUNCTION: gst_poll_restart ( set -- void )", "EXTERN: \"C\" void gst_poll_restart( void * set );", "	( set -- )" );
	swigFunction( "c-function gst_poll_set_flushing gst_poll_set_flushing a n -- void", "FUNCTION: gst_poll_set_flushing ( set flushing -- void )", "EXTERN: \"C\" void gst_poll_set_flushing( void * set, int flushing );", "	( set flushing -- )" );
	swigFunction( "c-function gst_poll_write_control gst_poll_write_control a -- n", "FUNCTION: gst_poll_write_control ( set -- n )", "EXTERN: \"C\" int gst_poll_write_control( void * set );", "	( set -- )" );
	swigFunction( "c-function gst_poll_read_control gst_poll_read_control a -- n", "FUNCTION: gst_poll_read_control ( set -- n )", "EXTERN: \"C\" int gst_poll_read_control( void * set );", "	( set -- )" );
	swigFunction( "c-function gst_preset_get_type gst_preset_get_type  -- u", "FUNCTION: gst_preset_get_type (  -- u )", "EXTERN: \"C\" int gst_preset_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_preset_get_preset_names gst_preset_get_preset_names a -- a", "FUNCTION: gst_preset_get_preset_names ( preset -- a )", "EXTERN: \"C\" void * gst_preset_get_preset_names( void * preset );", "	( preset -- )" );
	swigFunction( "c-function gst_preset_get_property_names gst_preset_get_property_names a -- a", "FUNCTION: gst_preset_get_property_names ( preset -- a )", "EXTERN: \"C\" void * gst_preset_get_property_names( void * preset );", "	( preset -- )" );
	swigFunction( "c-function gst_preset_load_preset gst_preset_load_preset a s -- n", "FUNCTION: gst_preset_load_preset ( preset name -- n )", "EXTERN: \"C\" int gst_preset_load_preset( void * preset, char * name );", "	( preset name -- )" );
	swigFunction( "c-function gst_preset_save_preset gst_preset_save_preset a s -- n", "FUNCTION: gst_preset_save_preset ( preset name -- n )", "EXTERN: \"C\" int gst_preset_save_preset( void * preset, char * name );", "	( preset name -- )" );
	swigFunction( "c-function gst_preset_rename_preset gst_preset_rename_preset a s s -- n", "FUNCTION: gst_preset_rename_preset ( preset old_name new_name -- n )", "EXTERN: \"C\" int gst_preset_rename_preset( void * preset, char * old_name, char * new_name );", "	( preset old_name new_name -- )" );
	swigFunction( "c-function gst_preset_delete_preset gst_preset_delete_preset a s -- n", "FUNCTION: gst_preset_delete_preset ( preset name -- n )", "EXTERN: \"C\" int gst_preset_delete_preset( void * preset, char * name );", "	( preset name -- )" );
	swigFunction( "c-function gst_preset_set_meta gst_preset_set_meta a s s s -- n", "FUNCTION: gst_preset_set_meta ( preset name tag value -- n )", "EXTERN: \"C\" int gst_preset_set_meta( void * preset, char * name, char * tag, char * value );", "	( preset name tag value -- )" );
	swigFunction( "c-function gst_preset_get_meta gst_preset_get_meta a s s a -- n", "FUNCTION: gst_preset_get_meta ( preset name tag value -- n )", "EXTERN: \"C\" int gst_preset_get_meta( void * preset, char * name, char * tag, void * value );", "	( preset name tag value -- )" );
	swigFunction( "c-function gst_preset_set_app_dir gst_preset_set_app_dir s -- n", "FUNCTION: gst_preset_set_app_dir ( app_dir -- n )", "EXTERN: \"C\" int gst_preset_set_app_dir( char * app_dir );", "	( app_dir -- )" );
	swigFunction( "c-function gst_preset_get_app_dir gst_preset_get_app_dir  -- s", "FUNCTION: gst_preset_get_app_dir (  -- s )", "EXTERN: \"C\" char * gst_preset_get_app_dir(  );", "	( -- )" );
	swigFunction( "c-function gst_preset_is_editable gst_preset_is_editable a -- n", "FUNCTION: gst_preset_is_editable ( preset -- n )", "EXTERN: \"C\" int gst_preset_is_editable( void * preset );", "	( preset -- )" );
	swigFunction( "c-function gst_query_type_get_name gst_query_type_get_name n -- s", "FUNCTION: gst_query_type_get_name ( type -- s )", "EXTERN: \"C\" char * gst_query_type_get_name( int type );", "	( type -- )" );
	swigFunction( "c-function gst_query_type_to_quark gst_query_type_to_quark n -- n", "FUNCTION: gst_query_type_to_quark ( type -- n )", "EXTERN: \"C\" n gst_query_type_to_quark( int type );", "	( type -- )" );
	swigFunction( "c-function gst_query_type_get_flags gst_query_type_get_flags n -- n", "FUNCTION: gst_query_type_get_flags ( type -- n )", "EXTERN: \"C\" int gst_query_type_get_flags( int type );", "	( type -- )" );
	swigFunction( "c-function gst_query_get_type gst_query_get_type  -- u", "FUNCTION: gst_query_get_type (  -- u )", "EXTERN: \"C\" int gst_query_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_query_ref gst_query_ref a -- a", "FUNCTION: gst_query_ref ( q -- a )", "EXTERN: \"C\" void * gst_query_ref( void * q );", "	( q -- )" );
	swigFunction( "c-function gst_query_unref gst_query_unref a -- void", "FUNCTION: gst_query_unref ( q -- void )", "EXTERN: \"C\" void gst_query_unref( void * q );", "	( q -- )" );
	swigFunction( "c-function gst_query_copy gst_query_copy a -- a", "FUNCTION: gst_query_copy ( q -- a )", "EXTERN: \"C\" void * gst_query_copy( void * q );", "	( q -- )" );
	swigFunction( "c-function gst_query_replace gst_query_replace a a -- n", "FUNCTION: gst_query_replace ( old_query new_query -- n )", "EXTERN: \"C\" int gst_query_replace( void * old_query, void * new_query );", "	( old_query new_query -- )" );
	swigFunction( "c-function gst_query_new_custom gst_query_new_custom n a -- a", "FUNCTION: gst_query_new_custom ( type structure -- a )", "EXTERN: \"C\" void * gst_query_new_custom( int type, void * structure );", "	( type structure -- )" );
	swigFunction( "c-function gst_query_get_structure gst_query_get_structure a -- a", "FUNCTION: gst_query_get_structure ( query -- a )", "EXTERN: \"C\" void * gst_query_get_structure( void * query );", "	( query -- )" );
	swigFunction( "c-function gst_query_writable_structure gst_query_writable_structure a -- a", "FUNCTION: gst_query_writable_structure ( query -- a )", "EXTERN: \"C\" void * gst_query_writable_structure( void * query );", "	( query -- )" );
	swigFunction( "c-function gst_query_new_position gst_query_new_position u -- a", "FUNCTION: gst_query_new_position ( format -- a )", "EXTERN: \"C\" void * gst_query_new_position( int format );", "	( format -- )" );
	swigFunction( "c-function gst_query_set_position gst_query_set_position a u d -- void", "FUNCTION: gst_query_set_position ( query format cur -- void )", "EXTERN: \"C\" void gst_query_set_position( void * query, int format, long long cur );", "	( query format cur -- )" );
	swigFunction( "c-function gst_query_parse_position gst_query_parse_position a a a -- void", "FUNCTION: gst_query_parse_position ( query format cur -- void )", "EXTERN: \"C\" void gst_query_parse_position( void * query, void * format, void * cur );", "	( query format cur -- )" );
	swigFunction( "c-function gst_query_new_duration gst_query_new_duration u -- a", "FUNCTION: gst_query_new_duration ( format -- a )", "EXTERN: \"C\" void * gst_query_new_duration( int format );", "	( format -- )" );
	swigFunction( "c-function gst_query_set_duration gst_query_set_duration a u d -- void", "FUNCTION: gst_query_set_duration ( query format duration -- void )", "EXTERN: \"C\" void gst_query_set_duration( void * query, int format, long long duration );", "	( query format duration -- )" );
	swigFunction( "c-function gst_query_parse_duration gst_query_parse_duration a a a -- void", "FUNCTION: gst_query_parse_duration ( query format duration -- void )", "EXTERN: \"C\" void gst_query_parse_duration( void * query, void * format, void * duration );", "	( query format duration -- )" );
	swigFunction( "c-function gst_query_new_latency gst_query_new_latency  -- a", "FUNCTION: gst_query_new_latency (  -- a )", "EXTERN: \"C\" void * gst_query_new_latency(  );", "	( -- )" );
	swigFunction( "c-function gst_query_set_latency gst_query_set_latency a n ud ud -- void", "FUNCTION: gst_query_set_latency ( query live min_latency max_latency -- void )", "EXTERN: \"C\" void gst_query_set_latency( void * query, int live, long long min_latency, long long max_latency );", "	( query live min_latency max_latency -- )" );
	swigFunction( "c-function gst_query_parse_latency gst_query_parse_latency a a a a -- void", "FUNCTION: gst_query_parse_latency ( query live min_latency max_latency -- void )", "EXTERN: \"C\" void gst_query_parse_latency( void * query, void * live, void * min_latency, void * max_latency );", "	( query live min_latency max_latency -- )" );
	swigFunction( "c-function gst_query_new_convert gst_query_new_convert u d u -- a", "FUNCTION: gst_query_new_convert ( src_format value dest_format -- a )", "EXTERN: \"C\" void * gst_query_new_convert( int src_format, long long value, int dest_format );", "	( src_format value dest_format -- )" );
	swigFunction( "c-function gst_query_set_convert gst_query_set_convert a u d u d -- void", "FUNCTION: gst_query_set_convert ( query src_format src_value dest_format dest_value -- void )", "EXTERN: \"C\" void gst_query_set_convert( void * query, int src_format, long long src_value, int dest_format, long long dest_value );", "	( query src_format src_value dest_format dest_value -- )" );
	swigFunction( "c-function gst_query_parse_convert gst_query_parse_convert a a a a a -- void", "FUNCTION: gst_query_parse_convert ( query src_format src_value dest_format dest_value -- void )", "EXTERN: \"C\" void gst_query_parse_convert( void * query, void * src_format, void * src_value, void * dest_format, void * dest_value );", "	( query src_format src_value dest_format dest_value -- )" );
	swigFunction( "c-function gst_query_new_segment gst_query_new_segment u -- a", "FUNCTION: gst_query_new_segment ( format -- a )", "EXTERN: \"C\" void * gst_query_new_segment( int format );", "	( format -- )" );
	swigFunction( "c-function gst_query_set_segment gst_query_set_segment a r u d d -- void", "FUNCTION: gst_query_set_segment ( query rate format start_value stop_value -- void )", "EXTERN: \"C\" void gst_query_set_segment( void * query, double rate, int format, long long start_value, long long stop_value );", "	( query rate format start_value stop_value -- )" );
	swigFunction( "c-function gst_query_parse_segment gst_query_parse_segment a a a a a -- void", "FUNCTION: gst_query_parse_segment ( query rate format start_value stop_value -- void )", "EXTERN: \"C\" void gst_query_parse_segment( void * query, void * rate, void * format, void * start_value, void * stop_value );", "	( query rate format start_value stop_value -- )" );
	swigFunction( "c-function gst_query_new_seeking gst_query_new_seeking u -- a", "FUNCTION: gst_query_new_seeking ( format -- a )", "EXTERN: \"C\" void * gst_query_new_seeking( int format );", "	( format -- )" );
	swigFunction( "c-function gst_query_set_seeking gst_query_set_seeking a u n d d -- void", "FUNCTION: gst_query_set_seeking ( query format seekable segment_start segment_end -- void )", "EXTERN: \"C\" void gst_query_set_seeking( void * query, int format, int seekable, long long segment_start, long long segment_end );", "	( query format seekable segment_start segment_end -- )" );
	swigFunction( "c-function gst_query_parse_seeking gst_query_parse_seeking a a a a a -- void", "FUNCTION: gst_query_parse_seeking ( query format seekable segment_start segment_end -- void )", "EXTERN: \"C\" void gst_query_parse_seeking( void * query, void * format, void * seekable, void * segment_start, void * segment_end );", "	( query format seekable segment_start segment_end -- )" );
	swigFunction( "c-function gst_query_new_formats gst_query_new_formats  -- a", "FUNCTION: gst_query_new_formats (  -- a )", "EXTERN: \"C\" void * gst_query_new_formats(  );", "	( -- )" );
	swigFunction( "c-function gst_query_set_formats gst_query_set_formats a n ... -- void", "FUNCTION: gst_query_set_formats ( query n_formats  -- void )", "EXTERN: \"C\" void gst_query_set_formats( void * query, int n_formats, ...  );", "	( query n_formats <noname> -- )" );
	swigFunction( "c-function gst_query_set_formatsv gst_query_set_formatsv a n a -- void", "FUNCTION: gst_query_set_formatsv ( query n_formats formats -- void )", "EXTERN: \"C\" void gst_query_set_formatsv( void * query, int n_formats, void * formats );", "	( query n_formats formats -- )" );
	swigFunction( "c-function gst_query_parse_n_formats gst_query_parse_n_formats a a -- void", "FUNCTION: gst_query_parse_n_formats ( query n_formats -- void )", "EXTERN: \"C\" void gst_query_parse_n_formats( void * query, void * n_formats );", "	( query n_formats -- )" );
	swigFunction( "c-function gst_query_parse_nth_format gst_query_parse_nth_format a u a -- void", "FUNCTION: gst_query_parse_nth_format ( query nth format -- void )", "EXTERN: \"C\" void gst_query_parse_nth_format( void * query, int nth, void * format );", "	( query nth format -- )" );
	swigFunction( "c-function gst_query_new_buffering gst_query_new_buffering u -- a", "FUNCTION: gst_query_new_buffering ( format -- a )", "EXTERN: \"C\" void * gst_query_new_buffering( int format );", "	( format -- )" );
	swigFunction( "c-function gst_query_set_buffering_percent gst_query_set_buffering_percent a n n -- void", "FUNCTION: gst_query_set_buffering_percent ( query busy percent -- void )", "EXTERN: \"C\" void gst_query_set_buffering_percent( void * query, int busy, int percent );", "	( query busy percent -- )" );
	swigFunction( "c-function gst_query_parse_buffering_percent gst_query_parse_buffering_percent a a a -- void", "FUNCTION: gst_query_parse_buffering_percent ( query busy percent -- void )", "EXTERN: \"C\" void gst_query_parse_buffering_percent( void * query, void * busy, void * percent );", "	( query busy percent -- )" );
	swigFunction( "c-function gst_query_set_buffering_stats gst_query_set_buffering_stats a n n n d -- void", "FUNCTION: gst_query_set_buffering_stats ( query mode avg_in avg_out buffering_left -- void )", "EXTERN: \"C\" void gst_query_set_buffering_stats( void * query, int mode, int avg_in, int avg_out, long long buffering_left );", "	( query mode avg_in avg_out buffering_left -- )" );
	swigFunction( "c-function gst_query_parse_buffering_stats gst_query_parse_buffering_stats a a a a a -- void", "FUNCTION: gst_query_parse_buffering_stats ( query mode avg_in avg_out buffering_left -- void )", "EXTERN: \"C\" void gst_query_parse_buffering_stats( void * query, void * mode, void * avg_in, void * avg_out, void * buffering_left );", "	( query mode avg_in avg_out buffering_left -- )" );
	swigFunction( "c-function gst_query_set_buffering_range gst_query_set_buffering_range a u d d d -- void", "FUNCTION: gst_query_set_buffering_range ( query format start stop estimated_total -- void )", "EXTERN: \"C\" void gst_query_set_buffering_range( void * query, int format, long long start, long long stop, long long estimated_total );", "	( query format start stop estimated_total -- )" );
	swigFunction( "c-function gst_query_parse_buffering_range gst_query_parse_buffering_range a a a a a -- void", "FUNCTION: gst_query_parse_buffering_range ( query format start stop estimated_total -- void )", "EXTERN: \"C\" void gst_query_parse_buffering_range( void * query, void * format, void * start, void * stop, void * estimated_total );", "	( query format start stop estimated_total -- )" );
	swigFunction( "c-function gst_query_add_buffering_range gst_query_add_buffering_range a d d -- n", "FUNCTION: gst_query_add_buffering_range ( query start stop -- n )", "EXTERN: \"C\" int gst_query_add_buffering_range( void * query, long long start, long long stop );", "	( query start stop -- )" );
	swigFunction( "c-function gst_query_get_n_buffering_ranges gst_query_get_n_buffering_ranges a -- u", "FUNCTION: gst_query_get_n_buffering_ranges ( query -- u )", "EXTERN: \"C\" int gst_query_get_n_buffering_ranges( void * query );", "	( query -- )" );
	swigFunction( "c-function gst_query_parse_nth_buffering_range gst_query_parse_nth_buffering_range a u a a -- n", "FUNCTION: gst_query_parse_nth_buffering_range ( query index start stop -- n )", "EXTERN: \"C\" int gst_query_parse_nth_buffering_range( void * query, int index, void * start, void * stop );", "	( query index start stop -- )" );
	swigFunction( "c-function gst_query_new_uri gst_query_new_uri  -- a", "FUNCTION: gst_query_new_uri (  -- a )", "EXTERN: \"C\" void * gst_query_new_uri(  );", "	( -- )" );
	swigFunction( "c-function gst_query_parse_uri gst_query_parse_uri a a -- void", "FUNCTION: gst_query_parse_uri ( query uri -- void )", "EXTERN: \"C\" void gst_query_parse_uri( void * query, void * uri );", "	( query uri -- )" );
	swigFunction( "c-function gst_query_set_uri gst_query_set_uri a s -- void", "FUNCTION: gst_query_set_uri ( query uri -- void )", "EXTERN: \"C\" void gst_query_set_uri( void * query, char * uri );", "	( query uri -- )" );
	swigFunction( "c-function gst_query_parse_uri_redirection gst_query_parse_uri_redirection a a -- void", "FUNCTION: gst_query_parse_uri_redirection ( query uri -- void )", "EXTERN: \"C\" void gst_query_parse_uri_redirection( void * query, void * uri );", "	( query uri -- )" );
	swigFunction( "c-function gst_query_set_uri_redirection gst_query_set_uri_redirection a s -- void", "FUNCTION: gst_query_set_uri_redirection ( query uri -- void )", "EXTERN: \"C\" void gst_query_set_uri_redirection( void * query, char * uri );", "	( query uri -- )" );
	swigFunction( "c-function gst_query_parse_uri_redirection_permanent gst_query_parse_uri_redirection_permanent a a -- void", "FUNCTION: gst_query_parse_uri_redirection_permanent ( query permanent -- void )", "EXTERN: \"C\" void gst_query_parse_uri_redirection_permanent( void * query, void * permanent );", "	( query permanent -- )" );
	swigFunction( "c-function gst_query_set_uri_redirection_permanent gst_query_set_uri_redirection_permanent a n -- void", "FUNCTION: gst_query_set_uri_redirection_permanent ( query permanent -- void )", "EXTERN: \"C\" void gst_query_set_uri_redirection_permanent( void * query, int permanent );", "	( query permanent -- )" );
	swigFunction( "c-function gst_query_new_allocation gst_query_new_allocation a n -- a", "FUNCTION: gst_query_new_allocation ( caps need_pool -- a )", "EXTERN: \"C\" void * gst_query_new_allocation( void * caps, int need_pool );", "	( caps need_pool -- )" );
	swigFunction( "c-function gst_query_parse_allocation gst_query_parse_allocation a a a -- void", "FUNCTION: gst_query_parse_allocation ( query caps need_pool -- void )", "EXTERN: \"C\" void gst_query_parse_allocation( void * query, void * caps, void * need_pool );", "	( query caps need_pool -- )" );
	swigFunction( "c-function gst_query_add_allocation_pool gst_query_add_allocation_pool a a u u u -- void", "FUNCTION: gst_query_add_allocation_pool ( query pool size min_buffers max_buffers -- void )", "EXTERN: \"C\" void gst_query_add_allocation_pool( void * query, void * pool, int size, int min_buffers, int max_buffers );", "	( query pool size min_buffers max_buffers -- )" );
	swigFunction( "c-function gst_query_get_n_allocation_pools gst_query_get_n_allocation_pools a -- u", "FUNCTION: gst_query_get_n_allocation_pools ( query -- u )", "EXTERN: \"C\" int gst_query_get_n_allocation_pools( void * query );", "	( query -- )" );
	swigFunction( "c-function gst_query_parse_nth_allocation_pool gst_query_parse_nth_allocation_pool a u a a a a -- void", "FUNCTION: gst_query_parse_nth_allocation_pool ( query index pool size min_buffers max_buffers -- void )", "EXTERN: \"C\" void gst_query_parse_nth_allocation_pool( void * query, int index, void * pool, void * size, void * min_buffers, void * max_buffers );", "	( query index pool size min_buffers max_buffers -- )" );
	swigFunction( "c-function gst_query_set_nth_allocation_pool gst_query_set_nth_allocation_pool a u a u u u -- void", "FUNCTION: gst_query_set_nth_allocation_pool ( query index pool size min_buffers max_buffers -- void )", "EXTERN: \"C\" void gst_query_set_nth_allocation_pool( void * query, int index, void * pool, int size, int min_buffers, int max_buffers );", "	( query index pool size min_buffers max_buffers -- )" );
	swigFunction( "c-function gst_query_remove_nth_allocation_pool gst_query_remove_nth_allocation_pool a u -- void", "FUNCTION: gst_query_remove_nth_allocation_pool ( query index -- void )", "EXTERN: \"C\" void gst_query_remove_nth_allocation_pool( void * query, int index );", "	( query index -- )" );
	swigFunction( "c-function gst_query_add_allocation_param gst_query_add_allocation_param a a a -- void", "FUNCTION: gst_query_add_allocation_param ( query allocator params -- void )", "EXTERN: \"C\" void gst_query_add_allocation_param( void * query, void * allocator, void * params );", "	( query allocator params -- )" );
	swigFunction( "c-function gst_query_get_n_allocation_params gst_query_get_n_allocation_params a -- u", "FUNCTION: gst_query_get_n_allocation_params ( query -- u )", "EXTERN: \"C\" int gst_query_get_n_allocation_params( void * query );", "	( query -- )" );
	swigFunction( "c-function gst_query_parse_nth_allocation_param gst_query_parse_nth_allocation_param a u a a -- void", "FUNCTION: gst_query_parse_nth_allocation_param ( query index allocator params -- void )", "EXTERN: \"C\" void gst_query_parse_nth_allocation_param( void * query, int index, void * allocator, void * params );", "	( query index allocator params -- )" );
	swigFunction( "c-function gst_query_set_nth_allocation_param gst_query_set_nth_allocation_param a u a a -- void", "FUNCTION: gst_query_set_nth_allocation_param ( query index allocator params -- void )", "EXTERN: \"C\" void gst_query_set_nth_allocation_param( void * query, int index, void * allocator, void * params );", "	( query index allocator params -- )" );
	swigFunction( "c-function gst_query_remove_nth_allocation_param gst_query_remove_nth_allocation_param a u -- void", "FUNCTION: gst_query_remove_nth_allocation_param ( query index -- void )", "EXTERN: \"C\" void gst_query_remove_nth_allocation_param( void * query, int index );", "	( query index -- )" );
	swigFunction( "c-function gst_query_add_allocation_meta gst_query_add_allocation_meta a u a -- void", "FUNCTION: gst_query_add_allocation_meta ( query api params -- void )", "EXTERN: \"C\" void gst_query_add_allocation_meta( void * query, int api, void * params );", "	( query api params -- )" );
	swigFunction( "c-function gst_query_get_n_allocation_metas gst_query_get_n_allocation_metas a -- u", "FUNCTION: gst_query_get_n_allocation_metas ( query -- u )", "EXTERN: \"C\" int gst_query_get_n_allocation_metas( void * query );", "	( query -- )" );
	swigFunction( "c-function gst_query_parse_nth_allocation_meta gst_query_parse_nth_allocation_meta a u a -- u", "FUNCTION: gst_query_parse_nth_allocation_meta ( query index params -- u )", "EXTERN: \"C\" int gst_query_parse_nth_allocation_meta( void * query, int index, void * params );", "	( query index params -- )" );
	swigFunction( "c-function gst_query_remove_nth_allocation_meta gst_query_remove_nth_allocation_meta a u -- void", "FUNCTION: gst_query_remove_nth_allocation_meta ( query index -- void )", "EXTERN: \"C\" void gst_query_remove_nth_allocation_meta( void * query, int index );", "	( query index -- )" );
	swigFunction( "c-function gst_query_find_allocation_meta gst_query_find_allocation_meta a u a -- n", "FUNCTION: gst_query_find_allocation_meta ( query api index -- n )", "EXTERN: \"C\" int gst_query_find_allocation_meta( void * query, int api, void * index );", "	( query api index -- )" );
	swigFunction( "c-function gst_query_new_scheduling gst_query_new_scheduling  -- a", "FUNCTION: gst_query_new_scheduling (  -- a )", "EXTERN: \"C\" void * gst_query_new_scheduling(  );", "	( -- )" );
	swigFunction( "c-function gst_query_set_scheduling gst_query_set_scheduling a n n n n -- void", "FUNCTION: gst_query_set_scheduling ( query flags minsize maxsize align -- void )", "EXTERN: \"C\" void gst_query_set_scheduling( void * query, int flags, int minsize, int maxsize, int align );", "	( query flags minsize maxsize align -- )" );
	swigFunction( "c-function gst_query_parse_scheduling gst_query_parse_scheduling a a a a a -- void", "FUNCTION: gst_query_parse_scheduling ( query flags minsize maxsize align -- void )", "EXTERN: \"C\" void gst_query_parse_scheduling( void * query, void * flags, void * minsize, void * maxsize, void * align );", "	( query flags minsize maxsize align -- )" );
	swigFunction( "c-function gst_query_add_scheduling_mode gst_query_add_scheduling_mode a n -- void", "FUNCTION: gst_query_add_scheduling_mode ( query mode -- void )", "EXTERN: \"C\" void gst_query_add_scheduling_mode( void * query, int mode );", "	( query mode -- )" );
	swigFunction( "c-function gst_query_get_n_scheduling_modes gst_query_get_n_scheduling_modes a -- u", "FUNCTION: gst_query_get_n_scheduling_modes ( query -- u )", "EXTERN: \"C\" int gst_query_get_n_scheduling_modes( void * query );", "	( query -- )" );
	swigFunction( "c-function gst_query_parse_nth_scheduling_mode gst_query_parse_nth_scheduling_mode a u -- n", "FUNCTION: gst_query_parse_nth_scheduling_mode ( query index -- n )", "EXTERN: \"C\" int gst_query_parse_nth_scheduling_mode( void * query, int index );", "	( query index -- )" );
	swigFunction( "c-function gst_query_has_scheduling_mode gst_query_has_scheduling_mode a n -- n", "FUNCTION: gst_query_has_scheduling_mode ( query mode -- n )", "EXTERN: \"C\" int gst_query_has_scheduling_mode( void * query, int mode );", "	( query mode -- )" );
	swigFunction( "c-function gst_query_has_scheduling_mode_with_flags gst_query_has_scheduling_mode_with_flags a n n -- n", "FUNCTION: gst_query_has_scheduling_mode_with_flags ( query mode flags -- n )", "EXTERN: \"C\" int gst_query_has_scheduling_mode_with_flags( void * query, int mode, int flags );", "	( query mode flags -- )" );
	swigFunction( "c-function gst_query_new_accept_caps gst_query_new_accept_caps a -- a", "FUNCTION: gst_query_new_accept_caps ( caps -- a )", "EXTERN: \"C\" void * gst_query_new_accept_caps( void * caps );", "	( caps -- )" );
	swigFunction( "c-function gst_query_parse_accept_caps gst_query_parse_accept_caps a a -- void", "FUNCTION: gst_query_parse_accept_caps ( query caps -- void )", "EXTERN: \"C\" void gst_query_parse_accept_caps( void * query, void * caps );", "	( query caps -- )" );
	swigFunction( "c-function gst_query_set_accept_caps_result gst_query_set_accept_caps_result a n -- void", "FUNCTION: gst_query_set_accept_caps_result ( query result -- void )", "EXTERN: \"C\" void gst_query_set_accept_caps_result( void * query, int result );", "	( query result -- )" );
	swigFunction( "c-function gst_query_parse_accept_caps_result gst_query_parse_accept_caps_result a a -- void", "FUNCTION: gst_query_parse_accept_caps_result ( query result -- void )", "EXTERN: \"C\" void gst_query_parse_accept_caps_result( void * query, void * result );", "	( query result -- )" );
	swigFunction( "c-function gst_query_new_caps gst_query_new_caps a -- a", "FUNCTION: gst_query_new_caps ( filter -- a )", "EXTERN: \"C\" void * gst_query_new_caps( void * filter );", "	( filter -- )" );
	swigFunction( "c-function gst_query_parse_caps gst_query_parse_caps a a -- void", "FUNCTION: gst_query_parse_caps ( query filter -- void )", "EXTERN: \"C\" void gst_query_parse_caps( void * query, void * filter );", "	( query filter -- )" );
	swigFunction( "c-function gst_query_set_caps_result gst_query_set_caps_result a a -- void", "FUNCTION: gst_query_set_caps_result ( query caps -- void )", "EXTERN: \"C\" void gst_query_set_caps_result( void * query, void * caps );", "	( query caps -- )" );
	swigFunction( "c-function gst_query_parse_caps_result gst_query_parse_caps_result a a -- void", "FUNCTION: gst_query_parse_caps_result ( query caps -- void )", "EXTERN: \"C\" void gst_query_parse_caps_result( void * query, void * caps );", "	( query caps -- )" );
	swigFunction( "c-function gst_query_new_drain gst_query_new_drain  -- a", "FUNCTION: gst_query_new_drain (  -- a )", "EXTERN: \"C\" void * gst_query_new_drain(  );", "	( -- )" );
	swigFunction( "c-function gst_query_new_context gst_query_new_context s -- a", "FUNCTION: gst_query_new_context ( context_type -- a )", "EXTERN: \"C\" void * gst_query_new_context( char * context_type );", "	( context_type -- )" );
	swigFunction( "c-function gst_query_parse_context_type gst_query_parse_context_type a a -- n", "FUNCTION: gst_query_parse_context_type ( query context_type -- n )", "EXTERN: \"C\" int gst_query_parse_context_type( void * query, void * context_type );", "	( query context_type -- )" );
	swigFunction( "c-function gst_query_set_context gst_query_set_context a a -- void", "FUNCTION: gst_query_set_context ( query context -- void )", "EXTERN: \"C\" void gst_query_set_context( void * query, void * context );", "	( query context -- )" );
	swigFunction( "c-function gst_query_parse_context gst_query_parse_context a a -- void", "FUNCTION: gst_query_parse_context ( query context -- void )", "EXTERN: \"C\" void gst_query_parse_context( void * query, void * context );", "	( query context -- )" );
	swigFunction( "c-function gst_registry_get_type gst_registry_get_type  -- u", "FUNCTION: gst_registry_get_type (  -- u )", "EXTERN: \"C\" int gst_registry_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_registry_get gst_registry_get  -- a", "FUNCTION: gst_registry_get (  -- a )", "EXTERN: \"C\" void * gst_registry_get(  );", "	( -- )" );
	swigFunction( "c-function gst_registry_scan_path gst_registry_scan_path a s -- n", "FUNCTION: gst_registry_scan_path ( registry path -- n )", "EXTERN: \"C\" int gst_registry_scan_path( void * registry, char * path );", "	( registry path -- )" );
	swigFunction( "c-function gst_registry_add_plugin gst_registry_add_plugin a a -- n", "FUNCTION: gst_registry_add_plugin ( registry plugin -- n )", "EXTERN: \"C\" int gst_registry_add_plugin( void * registry, void * plugin );", "	( registry plugin -- )" );
	swigFunction( "c-function gst_registry_remove_plugin gst_registry_remove_plugin a a -- void", "FUNCTION: gst_registry_remove_plugin ( registry plugin -- void )", "EXTERN: \"C\" void gst_registry_remove_plugin( void * registry, void * plugin );", "	( registry plugin -- )" );
	swigFunction( "c-function gst_registry_add_feature gst_registry_add_feature a a -- n", "FUNCTION: gst_registry_add_feature ( registry feature -- n )", "EXTERN: \"C\" int gst_registry_add_feature( void * registry, void * feature );", "	( registry feature -- )" );
	swigFunction( "c-function gst_registry_remove_feature gst_registry_remove_feature a a -- void", "FUNCTION: gst_registry_remove_feature ( registry feature -- void )", "EXTERN: \"C\" void gst_registry_remove_feature( void * registry, void * feature );", "	( registry feature -- )" );
	swigFunction( "c-function gst_registry_get_plugin_list gst_registry_get_plugin_list a -- a", "FUNCTION: gst_registry_get_plugin_list ( registry -- a )", "EXTERN: \"C\" void * gst_registry_get_plugin_list( void * registry );", "	( registry -- )" );
	swigFunction( "c-function gst_registry_plugin_filter gst_registry_plugin_filter a a n a -- a", "FUNCTION: gst_registry_plugin_filter ( registry filter first user_data -- a )", "EXTERN: \"C\" void * gst_registry_plugin_filter( void * registry, void * filter, int first, void * user_data );", "	( registry filter first user_data -- )" );
	swigFunction( "c-function gst_registry_feature_filter gst_registry_feature_filter a a n a -- a", "FUNCTION: gst_registry_feature_filter ( registry filter first user_data -- a )", "EXTERN: \"C\" void * gst_registry_feature_filter( void * registry, void * filter, int first, void * user_data );", "	( registry filter first user_data -- )" );
	swigFunction( "c-function gst_registry_get_feature_list gst_registry_get_feature_list a u -- a", "FUNCTION: gst_registry_get_feature_list ( registry type -- a )", "EXTERN: \"C\" void * gst_registry_get_feature_list( void * registry, int type );", "	( registry type -- )" );
	swigFunction( "c-function gst_registry_get_feature_list_by_plugin gst_registry_get_feature_list_by_plugin a s -- a", "FUNCTION: gst_registry_get_feature_list_by_plugin ( registry name -- a )", "EXTERN: \"C\" void * gst_registry_get_feature_list_by_plugin( void * registry, char * name );", "	( registry name -- )" );
	swigFunction( "c-function gst_registry_get_feature_list_cookie gst_registry_get_feature_list_cookie a -- u", "FUNCTION: gst_registry_get_feature_list_cookie ( registry -- u )", "EXTERN: \"C\" int gst_registry_get_feature_list_cookie( void * registry );", "	( registry -- )" );
	swigFunction( "c-function gst_registry_find_plugin gst_registry_find_plugin a s -- a", "FUNCTION: gst_registry_find_plugin ( registry name -- a )", "EXTERN: \"C\" void * gst_registry_find_plugin( void * registry, char * name );", "	( registry name -- )" );
	swigFunction( "c-function gst_registry_find_feature gst_registry_find_feature a s u -- a", "FUNCTION: gst_registry_find_feature ( registry name type -- a )", "EXTERN: \"C\" void * gst_registry_find_feature( void * registry, char * name, int type );", "	( registry name type -- )" );
	swigFunction( "c-function gst_registry_lookup gst_registry_lookup a s -- a", "FUNCTION: gst_registry_lookup ( registry filename -- a )", "EXTERN: \"C\" void * gst_registry_lookup( void * registry, char * filename );", "	( registry filename -- )" );
	swigFunction( "c-function gst_registry_lookup_feature gst_registry_lookup_feature a s -- a", "FUNCTION: gst_registry_lookup_feature ( registry name -- a )", "EXTERN: \"C\" void * gst_registry_lookup_feature( void * registry, char * name );", "	( registry name -- )" );
	swigFunction( "c-function gst_registry_check_feature_version gst_registry_check_feature_version a s u u u -- n", "FUNCTION: gst_registry_check_feature_version ( registry feature_name min_major min_minor min_micro -- n )", "EXTERN: \"C\" int gst_registry_check_feature_version( void * registry, char * feature_name, int min_major, int min_minor, int min_micro );", "	( registry feature_name min_major min_minor min_micro -- )" );
	swigFunction( "c-function gst_sample_get_type gst_sample_get_type  -- u", "FUNCTION: gst_sample_get_type (  -- u )", "EXTERN: \"C\" int gst_sample_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_sample_new gst_sample_new a a a a -- a", "FUNCTION: gst_sample_new ( buffer caps segment info -- a )", "EXTERN: \"C\" void * gst_sample_new( void * buffer, void * caps, void * segment, void * info );", "	( buffer caps segment info -- )" );
	swigFunction( "c-function gst_sample_get_buffer gst_sample_get_buffer a -- a", "FUNCTION: gst_sample_get_buffer ( sample -- a )", "EXTERN: \"C\" void * gst_sample_get_buffer( void * sample );", "	( sample -- )" );
	swigFunction( "c-function gst_sample_get_caps gst_sample_get_caps a -- a", "FUNCTION: gst_sample_get_caps ( sample -- a )", "EXTERN: \"C\" void * gst_sample_get_caps( void * sample );", "	( sample -- )" );
	swigFunction( "c-function gst_sample_get_segment gst_sample_get_segment a -- a", "FUNCTION: gst_sample_get_segment ( sample -- a )", "EXTERN: \"C\" void * gst_sample_get_segment( void * sample );", "	( sample -- )" );
	swigFunction( "c-function gst_sample_get_info gst_sample_get_info a -- a", "FUNCTION: gst_sample_get_info ( sample -- a )", "EXTERN: \"C\" void * gst_sample_get_info( void * sample );", "	( sample -- )" );
	swigFunction( "c-function gst_sample_get_buffer_list gst_sample_get_buffer_list a -- a", "FUNCTION: gst_sample_get_buffer_list ( sample -- a )", "EXTERN: \"C\" void * gst_sample_get_buffer_list( void * sample );", "	( sample -- )" );
	swigFunction( "c-function gst_sample_set_buffer_list gst_sample_set_buffer_list a a -- void", "FUNCTION: gst_sample_set_buffer_list ( sample buffer_list -- void )", "EXTERN: \"C\" void gst_sample_set_buffer_list( void * sample, void * buffer_list );", "	( sample buffer_list -- )" );
	swigFunction( "c-function gst_sample_ref gst_sample_ref a -- a", "FUNCTION: gst_sample_ref ( sample -- a )", "EXTERN: \"C\" void * gst_sample_ref( void * sample );", "	( sample -- )" );
	swigFunction( "c-function gst_sample_unref gst_sample_unref a -- void", "FUNCTION: gst_sample_unref ( sample -- void )", "EXTERN: \"C\" void gst_sample_unref( void * sample );", "	( sample -- )" );
	swigFunction( "c-function gst_sample_copy gst_sample_copy a -- a", "FUNCTION: gst_sample_copy ( buf -- a )", "EXTERN: \"C\" void * gst_sample_copy( void * buf );", "	( buf -- )" );
	swigFunction( "c-function gst_segment_get_type gst_segment_get_type  -- u", "FUNCTION: gst_segment_get_type (  -- u )", "EXTERN: \"C\" int gst_segment_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_segment_new gst_segment_new  -- a", "FUNCTION: gst_segment_new (  -- a )", "EXTERN: \"C\" void * gst_segment_new(  );", "	( -- )" );
	swigFunction( "c-function gst_segment_copy gst_segment_copy a -- a", "FUNCTION: gst_segment_copy ( segment -- a )", "EXTERN: \"C\" void * gst_segment_copy( void * segment );", "	( segment -- )" );
	swigFunction( "c-function gst_segment_copy_into gst_segment_copy_into a a -- void", "FUNCTION: gst_segment_copy_into ( src dest -- void )", "EXTERN: \"C\" void gst_segment_copy_into( void * src, void * dest );", "	( src dest -- )" );
	swigFunction( "c-function gst_segment_free gst_segment_free a -- void", "FUNCTION: gst_segment_free ( segment -- void )", "EXTERN: \"C\" void gst_segment_free( void * segment );", "	( segment -- )" );
	swigFunction( "c-function gst_segment_init gst_segment_init a u -- void", "FUNCTION: gst_segment_init ( segment format -- void )", "EXTERN: \"C\" void gst_segment_init( void * segment, int format );", "	( segment format -- )" );
	swigFunction( "c-function gst_segment_to_stream_time_full gst_segment_to_stream_time_full a u ud a -- n", "FUNCTION: gst_segment_to_stream_time_full ( segment format position stream_time -- n )", "EXTERN: \"C\" int gst_segment_to_stream_time_full( void * segment, int format, long long position, void * stream_time );", "	( segment format position stream_time -- )" );
	swigFunction( "c-function gst_segment_to_stream_time gst_segment_to_stream_time a u ud -- ud", "FUNCTION: gst_segment_to_stream_time ( segment format position -- ud )", "EXTERN: \"C\" long long gst_segment_to_stream_time( void * segment, int format, long long position );", "	( segment format position -- )" );
	swigFunction( "c-function gst_segment_position_from_stream_time_full gst_segment_position_from_stream_time_full a u ud a -- n", "FUNCTION: gst_segment_position_from_stream_time_full ( segment format stream_time position -- n )", "EXTERN: \"C\" int gst_segment_position_from_stream_time_full( void * segment, int format, long long stream_time, void * position );", "	( segment format stream_time position -- )" );
	swigFunction( "c-function gst_segment_position_from_stream_time gst_segment_position_from_stream_time a u ud -- ud", "FUNCTION: gst_segment_position_from_stream_time ( segment format stream_time -- ud )", "EXTERN: \"C\" long long gst_segment_position_from_stream_time( void * segment, int format, long long stream_time );", "	( segment format stream_time -- )" );
	swigFunction( "c-function gst_segment_to_running_time gst_segment_to_running_time a u ud -- ud", "FUNCTION: gst_segment_to_running_time ( segment format position -- ud )", "EXTERN: \"C\" long long gst_segment_to_running_time( void * segment, int format, long long position );", "	( segment format position -- )" );
	swigFunction( "c-function gst_segment_to_running_time_full gst_segment_to_running_time_full a u ud a -- n", "FUNCTION: gst_segment_to_running_time_full ( segment format position running_time -- n )", "EXTERN: \"C\" int gst_segment_to_running_time_full( void * segment, int format, long long position, void * running_time );", "	( segment format position running_time -- )" );
	swigFunction( "c-function gst_segment_to_position gst_segment_to_position a u ud -- ud", "FUNCTION: gst_segment_to_position ( segment format running_time -- ud )", "EXTERN: \"C\" long long gst_segment_to_position( void * segment, int format, long long running_time );", "	( segment format running_time -- )" );
	swigFunction( "c-function gst_segment_position_from_running_time_full gst_segment_position_from_running_time_full a u ud a -- n", "FUNCTION: gst_segment_position_from_running_time_full ( segment format running_time position -- n )", "EXTERN: \"C\" int gst_segment_position_from_running_time_full( void * segment, int format, long long running_time, void * position );", "	( segment format running_time position -- )" );
	swigFunction( "c-function gst_segment_position_from_running_time gst_segment_position_from_running_time a u ud -- ud", "FUNCTION: gst_segment_position_from_running_time ( segment format running_time -- ud )", "EXTERN: \"C\" long long gst_segment_position_from_running_time( void * segment, int format, long long running_time );", "	( segment format running_time -- )" );
	swigFunction( "c-function gst_segment_set_running_time gst_segment_set_running_time a u ud -- n", "FUNCTION: gst_segment_set_running_time ( segment format running_time -- n )", "EXTERN: \"C\" int gst_segment_set_running_time( void * segment, int format, long long running_time );", "	( segment format running_time -- )" );
	swigFunction( "c-function gst_segment_offset_running_time gst_segment_offset_running_time a u d -- n", "FUNCTION: gst_segment_offset_running_time ( segment format offset -- n )", "EXTERN: \"C\" int gst_segment_offset_running_time( void * segment, int format, long long offset );", "	( segment format offset -- )" );
	swigFunction( "c-function gst_segment_clip gst_segment_clip a u ud ud a a -- n", "FUNCTION: gst_segment_clip ( segment format start stop clip_start clip_stop -- n )", "EXTERN: \"C\" int gst_segment_clip( void * segment, int format, long long start, long long stop, void * clip_start, void * clip_stop );", "	( segment format start stop clip_start clip_stop -- )" );
	swigFunction( "c-function gst_segment_do_seek gst_segment_do_seek a r u n n ud n ud a -- n", "FUNCTION: gst_segment_do_seek ( segment rate format flags start_type start stop_type stop update -- n )", "EXTERN: \"C\" int gst_segment_do_seek( void * segment, double rate, int format, int flags, int start_type, long long start, int stop_type, long long stop, void * update );", "	( segment rate format flags start_type start stop_type stop update -- )" );
	swigFunction( "c-function gst_segment_is_equal gst_segment_is_equal a a -- n", "FUNCTION: gst_segment_is_equal ( s0 s1 -- n )", "EXTERN: \"C\" int gst_segment_is_equal( void * s0, void * s1 );", "	( s0 s1 -- )" );
	swigFunction( "c-function gst_structure_get_type gst_structure_get_type  -- u", "FUNCTION: gst_structure_get_type (  -- u )", "EXTERN: \"C\" int gst_structure_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_structure_new_empty gst_structure_new_empty s -- a", "FUNCTION: gst_structure_new_empty ( name -- a )", "EXTERN: \"C\" void * gst_structure_new_empty( char * name );", "	( name -- )" );
	swigFunction( "c-function gst_structure_new_id_empty gst_structure_new_id_empty n -- a", "FUNCTION: gst_structure_new_id_empty ( quark -- a )", "EXTERN: \"C\" void * gst_structure_new_id_empty( n quark );", "	( quark -- )" );
	swigFunction( "c-function gst_structure_new gst_structure_new s s ... -- a", "FUNCTION: gst_structure_new ( name firstfield  -- a )", "EXTERN: \"C\" void * gst_structure_new( char * name, char * firstfield, ...  );", "	( name firstfield <noname> -- )" );
	swigFunction( "c-function gst_structure_new_valist gst_structure_new_valist s s a -- a", "FUNCTION: gst_structure_new_valist ( name firstfield varargs -- a )", "EXTERN: \"C\" void * gst_structure_new_valist( char * name, char * firstfield, void * varargs );", "	( name firstfield varargs -- )" );
	swigFunction( "c-function gst_structure_new_id gst_structure_new_id n n ... -- a", "FUNCTION: gst_structure_new_id ( name_quark field_quark  -- a )", "EXTERN: \"C\" void * gst_structure_new_id( n name_quark, n field_quark, ...  );", "	( name_quark field_quark <noname> -- )" );
	swigFunction( "c-function gst_structure_new_from_string gst_structure_new_from_string s -- a", "FUNCTION: gst_structure_new_from_string ( string -- a )", "EXTERN: \"C\" void * gst_structure_new_from_string( char * string );", "	( string -- )" );
	swigFunction( "c-function gst_structure_copy gst_structure_copy a -- a", "FUNCTION: gst_structure_copy ( structure -- a )", "EXTERN: \"C\" void * gst_structure_copy( void * structure );", "	( structure -- )" );
	swigFunction( "c-function gst_structure_set_parent_refcount gst_structure_set_parent_refcount a a -- n", "FUNCTION: gst_structure_set_parent_refcount ( structure refcount -- n )", "EXTERN: \"C\" int gst_structure_set_parent_refcount( void * structure, void * refcount );", "	( structure refcount -- )" );
	swigFunction( "c-function gst_structure_free gst_structure_free a -- void", "FUNCTION: gst_structure_free ( structure -- void )", "EXTERN: \"C\" void gst_structure_free( void * structure );", "	( structure -- )" );
	swigFunction( "c-function gst_structure_get_name gst_structure_get_name a -- s", "FUNCTION: gst_structure_get_name ( structure -- s )", "EXTERN: \"C\" char * gst_structure_get_name( void * structure );", "	( structure -- )" );
	swigFunction( "c-function gst_structure_get_name_id gst_structure_get_name_id a -- n", "FUNCTION: gst_structure_get_name_id ( structure -- n )", "EXTERN: \"C\" n gst_structure_get_name_id( void * structure );", "	( structure -- )" );
	swigFunction( "c-function gst_structure_has_name gst_structure_has_name a s -- n", "FUNCTION: gst_structure_has_name ( structure name -- n )", "EXTERN: \"C\" int gst_structure_has_name( void * structure, char * name );", "	( structure name -- )" );
	swigFunction( "c-function gst_structure_set_name gst_structure_set_name a s -- void", "FUNCTION: gst_structure_set_name ( structure name -- void )", "EXTERN: \"C\" void gst_structure_set_name( void * structure, char * name );", "	( structure name -- )" );
	swigFunction( "c-function gst_structure_id_set_value gst_structure_id_set_value a n a -- void", "FUNCTION: gst_structure_id_set_value ( structure field value -- void )", "EXTERN: \"C\" void gst_structure_id_set_value( void * structure, n field, void * value );", "	( structure field value -- )" );
	swigFunction( "c-function gst_structure_set_value gst_structure_set_value a s a -- void", "FUNCTION: gst_structure_set_value ( structure fieldname value -- void )", "EXTERN: \"C\" void gst_structure_set_value( void * structure, char * fieldname, void * value );", "	( structure fieldname value -- )" );
	swigFunction( "c-function gst_structure_set_array gst_structure_set_array a s a -- void", "FUNCTION: gst_structure_set_array ( structure fieldname array -- void )", "EXTERN: \"C\" void gst_structure_set_array( void * structure, char * fieldname, void * array );", "	( structure fieldname array -- )" );
	swigFunction( "c-function gst_structure_set_list gst_structure_set_list a s a -- void", "FUNCTION: gst_structure_set_list ( structure fieldname array -- void )", "EXTERN: \"C\" void gst_structure_set_list( void * structure, char * fieldname, void * array );", "	( structure fieldname array -- )" );
	swigFunction( "c-function gst_structure_id_take_value gst_structure_id_take_value a n a -- void", "FUNCTION: gst_structure_id_take_value ( structure field value -- void )", "EXTERN: \"C\" void gst_structure_id_take_value( void * structure, n field, void * value );", "	( structure field value -- )" );
	swigFunction( "c-function gst_structure_take_value gst_structure_take_value a s a -- void", "FUNCTION: gst_structure_take_value ( structure fieldname value -- void )", "EXTERN: \"C\" void gst_structure_take_value( void * structure, char * fieldname, void * value );", "	( structure fieldname value -- )" );
	swigFunction( "c-function gst_structure_set gst_structure_set a s ... -- void", "FUNCTION: gst_structure_set ( structure fieldname  -- void )", "EXTERN: \"C\" void gst_structure_set( void * structure, char * fieldname, ...  );", "	( structure fieldname <noname> -- )" );
	swigFunction( "c-function gst_structure_set_valist gst_structure_set_valist a s a -- void", "FUNCTION: gst_structure_set_valist ( structure fieldname varargs -- void )", "EXTERN: \"C\" void gst_structure_set_valist( void * structure, char * fieldname, void * varargs );", "	( structure fieldname varargs -- )" );
	swigFunction( "c-function gst_structure_id_set gst_structure_id_set a n ... -- void", "FUNCTION: gst_structure_id_set ( structure fieldname  -- void )", "EXTERN: \"C\" void gst_structure_id_set( void * structure, n fieldname, ...  );", "	( structure fieldname <noname> -- )" );
	swigFunction( "c-function gst_structure_id_set_valist gst_structure_id_set_valist a n a -- void", "FUNCTION: gst_structure_id_set_valist ( structure fieldname varargs -- void )", "EXTERN: \"C\" void gst_structure_id_set_valist( void * structure, n fieldname, void * varargs );", "	( structure fieldname varargs -- )" );
	swigFunction( "c-function gst_structure_get_valist gst_structure_get_valist a s a -- n", "FUNCTION: gst_structure_get_valist ( structure first_fieldname args -- n )", "EXTERN: \"C\" int gst_structure_get_valist( void * structure, char * first_fieldname, void * args );", "	( structure first_fieldname args -- )" );
	swigFunction( "c-function gst_structure_get gst_structure_get a s ... -- n", "FUNCTION: gst_structure_get ( structure first_fieldname  -- n )", "EXTERN: \"C\" int gst_structure_get( void * structure, char * first_fieldname, ...  );", "	( structure first_fieldname <noname> -- )" );
	swigFunction( "c-function gst_structure_id_get_valist gst_structure_id_get_valist a n a -- n", "FUNCTION: gst_structure_id_get_valist ( structure first_field_id args -- n )", "EXTERN: \"C\" int gst_structure_id_get_valist( void * structure, n first_field_id, void * args );", "	( structure first_field_id args -- )" );
	swigFunction( "c-function gst_structure_id_get gst_structure_id_get a n ... -- n", "FUNCTION: gst_structure_id_get ( structure first_field_id  -- n )", "EXTERN: \"C\" int gst_structure_id_get( void * structure, n first_field_id, ...  );", "	( structure first_field_id <noname> -- )" );
	swigFunction( "c-function gst_structure_id_get_value gst_structure_id_get_value a n -- a", "FUNCTION: gst_structure_id_get_value ( structure field -- a )", "EXTERN: \"C\" void * gst_structure_id_get_value( void * structure, n field );", "	( structure field -- )" );
	swigFunction( "c-function gst_structure_get_value gst_structure_get_value a s -- a", "FUNCTION: gst_structure_get_value ( structure fieldname -- a )", "EXTERN: \"C\" void * gst_structure_get_value( void * structure, char * fieldname );", "	( structure fieldname -- )" );
	swigFunction( "c-function gst_structure_remove_field gst_structure_remove_field a s -- void", "FUNCTION: gst_structure_remove_field ( structure fieldname -- void )", "EXTERN: \"C\" void gst_structure_remove_field( void * structure, char * fieldname );", "	( structure fieldname -- )" );
	swigFunction( "c-function gst_structure_remove_fields gst_structure_remove_fields a s ... -- void", "FUNCTION: gst_structure_remove_fields ( structure fieldname  -- void )", "EXTERN: \"C\" void gst_structure_remove_fields( void * structure, char * fieldname, ...  );", "	( structure fieldname <noname> -- )" );
	swigFunction( "c-function gst_structure_remove_fields_valist gst_structure_remove_fields_valist a s a -- void", "FUNCTION: gst_structure_remove_fields_valist ( structure fieldname varargs -- void )", "EXTERN: \"C\" void gst_structure_remove_fields_valist( void * structure, char * fieldname, void * varargs );", "	( structure fieldname varargs -- )" );
	swigFunction( "c-function gst_structure_remove_all_fields gst_structure_remove_all_fields a -- void", "FUNCTION: gst_structure_remove_all_fields ( structure -- void )", "EXTERN: \"C\" void gst_structure_remove_all_fields( void * structure );", "	( structure -- )" );
	swigFunction( "c-function gst_structure_get_field_type gst_structure_get_field_type a s -- u", "FUNCTION: gst_structure_get_field_type ( structure fieldname -- u )", "EXTERN: \"C\" int gst_structure_get_field_type( void * structure, char * fieldname );", "	( structure fieldname -- )" );
	swigFunction( "c-function gst_structure_foreach gst_structure_foreach a a a -- n", "FUNCTION: gst_structure_foreach ( structure func user_data -- n )", "EXTERN: \"C\" int gst_structure_foreach( void * structure, void * func, void * user_data );", "	( structure func user_data -- )" );
	swigFunction( "c-function gst_structure_map_in_place gst_structure_map_in_place a a a -- n", "FUNCTION: gst_structure_map_in_place ( structure func user_data -- n )", "EXTERN: \"C\" int gst_structure_map_in_place( void * structure, void * func, void * user_data );", "	( structure func user_data -- )" );
	swigFunction( "c-function gst_structure_filter_and_map_in_place gst_structure_filter_and_map_in_place a a a -- void", "FUNCTION: gst_structure_filter_and_map_in_place ( structure func user_data -- void )", "EXTERN: \"C\" void gst_structure_filter_and_map_in_place( void * structure, void * func, void * user_data );", "	( structure func user_data -- )" );
	swigFunction( "c-function gst_structure_n_fields gst_structure_n_fields a -- n", "FUNCTION: gst_structure_n_fields ( structure -- n )", "EXTERN: \"C\" int gst_structure_n_fields( void * structure );", "	( structure -- )" );
	swigFunction( "c-function gst_structure_nth_field_name gst_structure_nth_field_name a u -- s", "FUNCTION: gst_structure_nth_field_name ( structure index -- s )", "EXTERN: \"C\" char * gst_structure_nth_field_name( void * structure, int index );", "	( structure index -- )" );
	swigFunction( "c-function gst_structure_id_has_field gst_structure_id_has_field a n -- n", "FUNCTION: gst_structure_id_has_field ( structure field -- n )", "EXTERN: \"C\" int gst_structure_id_has_field( void * structure, n field );", "	( structure field -- )" );
	swigFunction( "c-function gst_structure_id_has_field_typed gst_structure_id_has_field_typed a n u -- n", "FUNCTION: gst_structure_id_has_field_typed ( structure field type -- n )", "EXTERN: \"C\" int gst_structure_id_has_field_typed( void * structure, n field, int type );", "	( structure field type -- )" );
	swigFunction( "c-function gst_structure_has_field gst_structure_has_field a s -- n", "FUNCTION: gst_structure_has_field ( structure fieldname -- n )", "EXTERN: \"C\" int gst_structure_has_field( void * structure, char * fieldname );", "	( structure fieldname -- )" );
	swigFunction( "c-function gst_structure_has_field_typed gst_structure_has_field_typed a s u -- n", "FUNCTION: gst_structure_has_field_typed ( structure fieldname type -- n )", "EXTERN: \"C\" int gst_structure_has_field_typed( void * structure, char * fieldname, int type );", "	( structure fieldname type -- )" );
	swigFunction( "c-function gst_structure_get_boolean gst_structure_get_boolean a s a -- n", "FUNCTION: gst_structure_get_boolean ( structure fieldname value -- n )", "EXTERN: \"C\" int gst_structure_get_boolean( void * structure, char * fieldname, void * value );", "	( structure fieldname value -- )" );
	swigFunction( "c-function gst_structure_get_int gst_structure_get_int a s a -- n", "FUNCTION: gst_structure_get_int ( structure fieldname value -- n )", "EXTERN: \"C\" int gst_structure_get_int( void * structure, char * fieldname, void * value );", "	( structure fieldname value -- )" );
	swigFunction( "c-function gst_structure_get_uint gst_structure_get_uint a s a -- n", "FUNCTION: gst_structure_get_uint ( structure fieldname value -- n )", "EXTERN: \"C\" int gst_structure_get_uint( void * structure, char * fieldname, void * value );", "	( structure fieldname value -- )" );
	swigFunction( "c-function gst_structure_get_int64 gst_structure_get_int64 a s a -- n", "FUNCTION: gst_structure_get_int64 ( structure fieldname value -- n )", "EXTERN: \"C\" int gst_structure_get_int64( void * structure, char * fieldname, void * value );", "	( structure fieldname value -- )" );
	swigFunction( "c-function gst_structure_get_uint64 gst_structure_get_uint64 a s a -- n", "FUNCTION: gst_structure_get_uint64 ( structure fieldname value -- n )", "EXTERN: \"C\" int gst_structure_get_uint64( void * structure, char * fieldname, void * value );", "	( structure fieldname value -- )" );
	swigFunction( "c-function gst_structure_get_double gst_structure_get_double a s a -- n", "FUNCTION: gst_structure_get_double ( structure fieldname value -- n )", "EXTERN: \"C\" int gst_structure_get_double( void * structure, char * fieldname, void * value );", "	( structure fieldname value -- )" );
	swigFunction( "c-function gst_structure_get_date gst_structure_get_date a s a -- n", "FUNCTION: gst_structure_get_date ( structure fieldname value -- n )", "EXTERN: \"C\" int gst_structure_get_date( void * structure, char * fieldname, void * value );", "	( structure fieldname value -- )" );
	swigFunction( "c-function gst_structure_get_date_time gst_structure_get_date_time a s a -- n", "FUNCTION: gst_structure_get_date_time ( structure fieldname value -- n )", "EXTERN: \"C\" int gst_structure_get_date_time( void * structure, char * fieldname, void * value );", "	( structure fieldname value -- )" );
	swigFunction( "c-function gst_structure_get_clock_time gst_structure_get_clock_time a s a -- n", "FUNCTION: gst_structure_get_clock_time ( structure fieldname value -- n )", "EXTERN: \"C\" int gst_structure_get_clock_time( void * structure, char * fieldname, void * value );", "	( structure fieldname value -- )" );
	swigFunction( "c-function gst_structure_get_string gst_structure_get_string a s -- s", "FUNCTION: gst_structure_get_string ( structure fieldname -- s )", "EXTERN: \"C\" char * gst_structure_get_string( void * structure, char * fieldname );", "	( structure fieldname -- )" );
	swigFunction( "c-function gst_structure_get_enum gst_structure_get_enum a s u a -- n", "FUNCTION: gst_structure_get_enum ( structure fieldname enumtype value -- n )", "EXTERN: \"C\" int gst_structure_get_enum( void * structure, char * fieldname, int enumtype, void * value );", "	( structure fieldname enumtype value -- )" );
	swigFunction( "c-function gst_structure_get_fraction gst_structure_get_fraction a s a a -- n", "FUNCTION: gst_structure_get_fraction ( structure fieldname value_numerator value_denominator -- n )", "EXTERN: \"C\" int gst_structure_get_fraction( void * structure, char * fieldname, void * value_numerator, void * value_denominator );", "	( structure fieldname value_numerator value_denominator -- )" );
	swigFunction( "c-function gst_structure_get_flagset gst_structure_get_flagset a s a a -- n", "FUNCTION: gst_structure_get_flagset ( structure fieldname value_flags value_mask -- n )", "EXTERN: \"C\" int gst_structure_get_flagset( void * structure, char * fieldname, void * value_flags, void * value_mask );", "	( structure fieldname value_flags value_mask -- )" );
	swigFunction( "c-function gst_structure_get_array gst_structure_get_array a s a -- n", "FUNCTION: gst_structure_get_array ( structure fieldname array -- n )", "EXTERN: \"C\" int gst_structure_get_array( void * structure, char * fieldname, void * array );", "	( structure fieldname array -- )" );
	swigFunction( "c-function gst_structure_get_list gst_structure_get_list a s a -- n", "FUNCTION: gst_structure_get_list ( structure fieldname array -- n )", "EXTERN: \"C\" int gst_structure_get_list( void * structure, char * fieldname, void * array );", "	( structure fieldname array -- )" );
	swigFunction( "c-function gst_structure_to_string gst_structure_to_string a -- a", "FUNCTION: gst_structure_to_string ( structure -- a )", "EXTERN: \"C\" void * gst_structure_to_string( void * structure );", "	( structure -- )" );
	swigFunction( "c-function gst_structure_from_string gst_structure_from_string s a -- a", "FUNCTION: gst_structure_from_string ( string end -- a )", "EXTERN: \"C\" void * gst_structure_from_string( char * string, void * end );", "	( string end -- )" );
	swigFunction( "c-function gst_structure_fixate_field_nearest_int gst_structure_fixate_field_nearest_int a s n -- n", "FUNCTION: gst_structure_fixate_field_nearest_int ( structure field_name target -- n )", "EXTERN: \"C\" int gst_structure_fixate_field_nearest_int( void * structure, char * field_name, int target );", "	( structure field_name target -- )" );
	swigFunction( "c-function gst_structure_fixate_field_nearest_double gst_structure_fixate_field_nearest_double a s r -- n", "FUNCTION: gst_structure_fixate_field_nearest_double ( structure field_name target -- n )", "EXTERN: \"C\" int gst_structure_fixate_field_nearest_double( void * structure, char * field_name, double target );", "	( structure field_name target -- )" );
	swigFunction( "c-function gst_structure_fixate_field_boolean gst_structure_fixate_field_boolean a s n -- n", "FUNCTION: gst_structure_fixate_field_boolean ( structure field_name target -- n )", "EXTERN: \"C\" int gst_structure_fixate_field_boolean( void * structure, char * field_name, int target );", "	( structure field_name target -- )" );
	swigFunction( "c-function gst_structure_fixate_field_string gst_structure_fixate_field_string a s s -- n", "FUNCTION: gst_structure_fixate_field_string ( structure field_name target -- n )", "EXTERN: \"C\" int gst_structure_fixate_field_string( void * structure, char * field_name, char * target );", "	( structure field_name target -- )" );
	swigFunction( "c-function gst_structure_fixate_field_nearest_fraction gst_structure_fixate_field_nearest_fraction a s n n -- n", "FUNCTION: gst_structure_fixate_field_nearest_fraction ( structure field_name target_numerator target_denominator -- n )", "EXTERN: \"C\" int gst_structure_fixate_field_nearest_fraction( void * structure, char * field_name, int target_numerator, int target_denominator );", "	( structure field_name target_numerator target_denominator -- )" );
	swigFunction( "c-function gst_structure_fixate_field gst_structure_fixate_field a s -- n", "FUNCTION: gst_structure_fixate_field ( structure field_name -- n )", "EXTERN: \"C\" int gst_structure_fixate_field( void * structure, char * field_name );", "	( structure field_name -- )" );
	swigFunction( "c-function gst_structure_fixate gst_structure_fixate a -- void", "FUNCTION: gst_structure_fixate ( structure -- void )", "EXTERN: \"C\" void gst_structure_fixate( void * structure );", "	( structure -- )" );
	swigFunction( "c-function gst_structure_is_equal gst_structure_is_equal a a -- n", "FUNCTION: gst_structure_is_equal ( structure1 structure2 -- n )", "EXTERN: \"C\" int gst_structure_is_equal( void * structure1, void * structure2 );", "	( structure1 structure2 -- )" );
	swigFunction( "c-function gst_structure_is_subset gst_structure_is_subset a a -- n", "FUNCTION: gst_structure_is_subset ( subset superset -- n )", "EXTERN: \"C\" int gst_structure_is_subset( void * subset, void * superset );", "	( subset superset -- )" );
	swigFunction( "c-function gst_structure_can_intersect gst_structure_can_intersect a a -- n", "FUNCTION: gst_structure_can_intersect ( struct1 struct2 -- n )", "EXTERN: \"C\" int gst_structure_can_intersect( void * struct1, void * struct2 );", "	( struct1 struct2 -- )" );
	swigFunction( "c-function gst_structure_intersect gst_structure_intersect a a -- a", "FUNCTION: gst_structure_intersect ( struct1 struct2 -- a )", "EXTERN: \"C\" void * gst_structure_intersect( void * struct1, void * struct2 );", "	( struct1 struct2 -- )" );
	swigFunction( "c-function gst_system_clock_get_type gst_system_clock_get_type  -- u", "FUNCTION: gst_system_clock_get_type (  -- u )", "EXTERN: \"C\" int gst_system_clock_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_system_clock_obtain gst_system_clock_obtain  -- a", "FUNCTION: gst_system_clock_obtain (  -- a )", "EXTERN: \"C\" void * gst_system_clock_obtain(  );", "	( -- )" );
	swigFunction( "c-function gst_system_clock_set_default gst_system_clock_set_default a -- void", "FUNCTION: gst_system_clock_set_default ( new_clock -- void )", "EXTERN: \"C\" void gst_system_clock_set_default( void * new_clock );", "	( new_clock -- )" );
	swigFunction( "c-function gst_tag_list_get_type gst_tag_list_get_type  -- u", "FUNCTION: gst_tag_list_get_type (  -- u )", "EXTERN: \"C\" int gst_tag_list_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_tag_register gst_tag_register s n u s s a -- void", "FUNCTION: gst_tag_register ( name flag type nick blurb func -- void )", "EXTERN: \"C\" void gst_tag_register( char * name, int flag, int type, char * nick, char * blurb, void * func );", "	( name flag type nick blurb func -- )" );
	swigFunction( "c-function gst_tag_register_static gst_tag_register_static s n u s s a -- void", "FUNCTION: gst_tag_register_static ( name flag type nick blurb func -- void )", "EXTERN: \"C\" void gst_tag_register_static( char * name, int flag, int type, char * nick, char * blurb, void * func );", "	( name flag type nick blurb func -- )" );
	swigFunction( "c-function gst_tag_merge_use_first gst_tag_merge_use_first a a -- void", "FUNCTION: gst_tag_merge_use_first ( dest src -- void )", "EXTERN: \"C\" void gst_tag_merge_use_first( void * dest, void * src );", "	( dest src -- )" );
	swigFunction( "c-function gst_tag_merge_strings_with_comma gst_tag_merge_strings_with_comma a a -- void", "FUNCTION: gst_tag_merge_strings_with_comma ( dest src -- void )", "EXTERN: \"C\" void gst_tag_merge_strings_with_comma( void * dest, void * src );", "	( dest src -- )" );
	swigFunction( "c-function gst_tag_exists gst_tag_exists s -- n", "FUNCTION: gst_tag_exists ( tag -- n )", "EXTERN: \"C\" int gst_tag_exists( char * tag );", "	( tag -- )" );
	swigFunction( "c-function gst_tag_get_type gst_tag_get_type s -- u", "FUNCTION: gst_tag_get_type ( tag -- u )", "EXTERN: \"C\" int gst_tag_get_type( char * tag );", "	( tag -- )" );
	swigFunction( "c-function gst_tag_get_nick gst_tag_get_nick s -- s", "FUNCTION: gst_tag_get_nick ( tag -- s )", "EXTERN: \"C\" char * gst_tag_get_nick( char * tag );", "	( tag -- )" );
	swigFunction( "c-function gst_tag_get_description gst_tag_get_description s -- s", "FUNCTION: gst_tag_get_description ( tag -- s )", "EXTERN: \"C\" char * gst_tag_get_description( char * tag );", "	( tag -- )" );
	swigFunction( "c-function gst_tag_get_flag gst_tag_get_flag s -- n", "FUNCTION: gst_tag_get_flag ( tag -- n )", "EXTERN: \"C\" int gst_tag_get_flag( char * tag );", "	( tag -- )" );
	swigFunction( "c-function gst_tag_is_fixed gst_tag_is_fixed s -- n", "FUNCTION: gst_tag_is_fixed ( tag -- n )", "EXTERN: \"C\" int gst_tag_is_fixed( char * tag );", "	( tag -- )" );
	swigFunction( "c-function gst_tag_list_new_empty gst_tag_list_new_empty  -- a", "FUNCTION: gst_tag_list_new_empty (  -- a )", "EXTERN: \"C\" void * gst_tag_list_new_empty(  );", "	( -- )" );
	swigFunction( "c-function gst_tag_list_new gst_tag_list_new s ... -- a", "FUNCTION: gst_tag_list_new ( tag  -- a )", "EXTERN: \"C\" void * gst_tag_list_new( char * tag, ...  );", "	( tag <noname> -- )" );
	swigFunction( "c-function gst_tag_list_new_valist gst_tag_list_new_valist a -- a", "FUNCTION: gst_tag_list_new_valist ( var_args -- a )", "EXTERN: \"C\" void * gst_tag_list_new_valist( void * var_args );", "	( var_args -- )" );
	swigFunction( "c-function gst_tag_list_set_scope gst_tag_list_set_scope a n -- void", "FUNCTION: gst_tag_list_set_scope ( list scope -- void )", "EXTERN: \"C\" void gst_tag_list_set_scope( void * list, int scope );", "	( list scope -- )" );
	swigFunction( "c-function gst_tag_list_get_scope gst_tag_list_get_scope a -- n", "FUNCTION: gst_tag_list_get_scope ( list -- n )", "EXTERN: \"C\" int gst_tag_list_get_scope( void * list );", "	( list -- )" );
	swigFunction( "c-function gst_tag_list_to_string gst_tag_list_to_string a -- a", "FUNCTION: gst_tag_list_to_string ( list -- a )", "EXTERN: \"C\" void * gst_tag_list_to_string( void * list );", "	( list -- )" );
	swigFunction( "c-function gst_tag_list_new_from_string gst_tag_list_new_from_string s -- a", "FUNCTION: gst_tag_list_new_from_string ( str -- a )", "EXTERN: \"C\" void * gst_tag_list_new_from_string( char * str );", "	( str -- )" );
	swigFunction( "c-function gst_tag_list_n_tags gst_tag_list_n_tags a -- n", "FUNCTION: gst_tag_list_n_tags ( list -- n )", "EXTERN: \"C\" int gst_tag_list_n_tags( void * list );", "	( list -- )" );
	swigFunction( "c-function gst_tag_list_nth_tag_name gst_tag_list_nth_tag_name a u -- s", "FUNCTION: gst_tag_list_nth_tag_name ( list index -- s )", "EXTERN: \"C\" char * gst_tag_list_nth_tag_name( void * list, int index );", "	( list index -- )" );
	swigFunction( "c-function gst_tag_list_is_empty gst_tag_list_is_empty a -- n", "FUNCTION: gst_tag_list_is_empty ( list -- n )", "EXTERN: \"C\" int gst_tag_list_is_empty( void * list );", "	( list -- )" );
	swigFunction( "c-function gst_tag_list_is_equal gst_tag_list_is_equal a a -- n", "FUNCTION: gst_tag_list_is_equal ( list1 list2 -- n )", "EXTERN: \"C\" int gst_tag_list_is_equal( void * list1, void * list2 );", "	( list1 list2 -- )" );
	swigFunction( "c-function gst_tag_list_insert gst_tag_list_insert a a n -- void", "FUNCTION: gst_tag_list_insert ( into from mode -- void )", "EXTERN: \"C\" void gst_tag_list_insert( void * into, void * from, int mode );", "	( into from mode -- )" );
	swigFunction( "c-function gst_tag_list_merge gst_tag_list_merge a a n -- a", "FUNCTION: gst_tag_list_merge ( list1 list2 mode -- a )", "EXTERN: \"C\" void * gst_tag_list_merge( void * list1, void * list2, int mode );", "	( list1 list2 mode -- )" );
	swigFunction( "c-function gst_tag_list_get_tag_size gst_tag_list_get_tag_size a s -- u", "FUNCTION: gst_tag_list_get_tag_size ( list tag -- u )", "EXTERN: \"C\" int gst_tag_list_get_tag_size( void * list, char * tag );", "	( list tag -- )" );
	swigFunction( "c-function gst_tag_list_add gst_tag_list_add a n s ... -- void", "FUNCTION: gst_tag_list_add ( list mode tag  -- void )", "EXTERN: \"C\" void gst_tag_list_add( void * list, int mode, char * tag, ...  );", "	( list mode tag <noname> -- )" );
	swigFunction( "c-function gst_tag_list_add_values gst_tag_list_add_values a n s ... -- void", "FUNCTION: gst_tag_list_add_values ( list mode tag  -- void )", "EXTERN: \"C\" void gst_tag_list_add_values( void * list, int mode, char * tag, ...  );", "	( list mode tag <noname> -- )" );
	swigFunction( "c-function gst_tag_list_add_valist gst_tag_list_add_valist a n s a -- void", "FUNCTION: gst_tag_list_add_valist ( list mode tag var_args -- void )", "EXTERN: \"C\" void gst_tag_list_add_valist( void * list, int mode, char * tag, void * var_args );", "	( list mode tag var_args -- )" );
	swigFunction( "c-function gst_tag_list_add_valist_values gst_tag_list_add_valist_values a n s a -- void", "FUNCTION: gst_tag_list_add_valist_values ( list mode tag var_args -- void )", "EXTERN: \"C\" void gst_tag_list_add_valist_values( void * list, int mode, char * tag, void * var_args );", "	( list mode tag var_args -- )" );
	swigFunction( "c-function gst_tag_list_add_value gst_tag_list_add_value a n s a -- void", "FUNCTION: gst_tag_list_add_value ( list mode tag value -- void )", "EXTERN: \"C\" void gst_tag_list_add_value( void * list, int mode, char * tag, void * value );", "	( list mode tag value -- )" );
	swigFunction( "c-function gst_tag_list_remove_tag gst_tag_list_remove_tag a s -- void", "FUNCTION: gst_tag_list_remove_tag ( list tag -- void )", "EXTERN: \"C\" void gst_tag_list_remove_tag( void * list, char * tag );", "	( list tag -- )" );
	swigFunction( "c-function gst_tag_list_foreach gst_tag_list_foreach a a a -- void", "FUNCTION: gst_tag_list_foreach ( list func user_data -- void )", "EXTERN: \"C\" void gst_tag_list_foreach( void * list, void * func, void * user_data );", "	( list func user_data -- )" );
	swigFunction( "c-function gst_tag_list_get_value_index gst_tag_list_get_value_index a s u -- a", "FUNCTION: gst_tag_list_get_value_index ( list tag index -- a )", "EXTERN: \"C\" void * gst_tag_list_get_value_index( void * list, char * tag, int index );", "	( list tag index -- )" );
	swigFunction( "c-function gst_tag_list_copy_value gst_tag_list_copy_value a a s -- n", "FUNCTION: gst_tag_list_copy_value ( dest list tag -- n )", "EXTERN: \"C\" int gst_tag_list_copy_value( void * dest, void * list, char * tag );", "	( dest list tag -- )" );
	swigFunction( "c-function gst_tag_list_get_boolean gst_tag_list_get_boolean a s a -- n", "FUNCTION: gst_tag_list_get_boolean ( list tag value -- n )", "EXTERN: \"C\" int gst_tag_list_get_boolean( void * list, char * tag, void * value );", "	( list tag value -- )" );
	swigFunction( "c-function gst_tag_list_get_boolean_index gst_tag_list_get_boolean_index a s u a -- n", "FUNCTION: gst_tag_list_get_boolean_index ( list tag index value -- n )", "EXTERN: \"C\" int gst_tag_list_get_boolean_index( void * list, char * tag, int index, void * value );", "	( list tag index value -- )" );
	swigFunction( "c-function gst_tag_list_get_int gst_tag_list_get_int a s a -- n", "FUNCTION: gst_tag_list_get_int ( list tag value -- n )", "EXTERN: \"C\" int gst_tag_list_get_int( void * list, char * tag, void * value );", "	( list tag value -- )" );
	swigFunction( "c-function gst_tag_list_get_int_index gst_tag_list_get_int_index a s u a -- n", "FUNCTION: gst_tag_list_get_int_index ( list tag index value -- n )", "EXTERN: \"C\" int gst_tag_list_get_int_index( void * list, char * tag, int index, void * value );", "	( list tag index value -- )" );
	swigFunction( "c-function gst_tag_list_get_uint gst_tag_list_get_uint a s a -- n", "FUNCTION: gst_tag_list_get_uint ( list tag value -- n )", "EXTERN: \"C\" int gst_tag_list_get_uint( void * list, char * tag, void * value );", "	( list tag value -- )" );
	swigFunction( "c-function gst_tag_list_get_uint_index gst_tag_list_get_uint_index a s u a -- n", "FUNCTION: gst_tag_list_get_uint_index ( list tag index value -- n )", "EXTERN: \"C\" int gst_tag_list_get_uint_index( void * list, char * tag, int index, void * value );", "	( list tag index value -- )" );
	swigFunction( "c-function gst_tag_list_get_int64 gst_tag_list_get_int64 a s a -- n", "FUNCTION: gst_tag_list_get_int64 ( list tag value -- n )", "EXTERN: \"C\" int gst_tag_list_get_int64( void * list, char * tag, void * value );", "	( list tag value -- )" );
	swigFunction( "c-function gst_tag_list_get_int64_index gst_tag_list_get_int64_index a s u a -- n", "FUNCTION: gst_tag_list_get_int64_index ( list tag index value -- n )", "EXTERN: \"C\" int gst_tag_list_get_int64_index( void * list, char * tag, int index, void * value );", "	( list tag index value -- )" );
	swigFunction( "c-function gst_tag_list_get_uint64 gst_tag_list_get_uint64 a s a -- n", "FUNCTION: gst_tag_list_get_uint64 ( list tag value -- n )", "EXTERN: \"C\" int gst_tag_list_get_uint64( void * list, char * tag, void * value );", "	( list tag value -- )" );
	swigFunction( "c-function gst_tag_list_get_uint64_index gst_tag_list_get_uint64_index a s u a -- n", "FUNCTION: gst_tag_list_get_uint64_index ( list tag index value -- n )", "EXTERN: \"C\" int gst_tag_list_get_uint64_index( void * list, char * tag, int index, void * value );", "	( list tag index value -- )" );
	swigFunction( "c-function gst_tag_list_get_float gst_tag_list_get_float a s a -- n", "FUNCTION: gst_tag_list_get_float ( list tag value -- n )", "EXTERN: \"C\" int gst_tag_list_get_float( void * list, char * tag, void * value );", "	( list tag value -- )" );
	swigFunction( "c-function gst_tag_list_get_float_index gst_tag_list_get_float_index a s u a -- n", "FUNCTION: gst_tag_list_get_float_index ( list tag index value -- n )", "EXTERN: \"C\" int gst_tag_list_get_float_index( void * list, char * tag, int index, void * value );", "	( list tag index value -- )" );
	swigFunction( "c-function gst_tag_list_get_double gst_tag_list_get_double a s a -- n", "FUNCTION: gst_tag_list_get_double ( list tag value -- n )", "EXTERN: \"C\" int gst_tag_list_get_double( void * list, char * tag, void * value );", "	( list tag value -- )" );
	swigFunction( "c-function gst_tag_list_get_double_index gst_tag_list_get_double_index a s u a -- n", "FUNCTION: gst_tag_list_get_double_index ( list tag index value -- n )", "EXTERN: \"C\" int gst_tag_list_get_double_index( void * list, char * tag, int index, void * value );", "	( list tag index value -- )" );
	swigFunction( "c-function gst_tag_list_get_string gst_tag_list_get_string a s a -- n", "FUNCTION: gst_tag_list_get_string ( list tag value -- n )", "EXTERN: \"C\" int gst_tag_list_get_string( void * list, char * tag, void * value );", "	( list tag value -- )" );
	swigFunction( "c-function gst_tag_list_get_string_index gst_tag_list_get_string_index a s u a -- n", "FUNCTION: gst_tag_list_get_string_index ( list tag index value -- n )", "EXTERN: \"C\" int gst_tag_list_get_string_index( void * list, char * tag, int index, void * value );", "	( list tag index value -- )" );
	swigFunction( "c-function gst_tag_list_peek_string_index gst_tag_list_peek_string_index a s u a -- n", "FUNCTION: gst_tag_list_peek_string_index ( list tag index value -- n )", "EXTERN: \"C\" int gst_tag_list_peek_string_index( void * list, char * tag, int index, void * value );", "	( list tag index value -- )" );
	swigFunction( "c-function gst_tag_list_get_pointer gst_tag_list_get_pointer a s a -- n", "FUNCTION: gst_tag_list_get_pointer ( list tag value -- n )", "EXTERN: \"C\" int gst_tag_list_get_pointer( void * list, char * tag, void * value );", "	( list tag value -- )" );
	swigFunction( "c-function gst_tag_list_get_pointer_index gst_tag_list_get_pointer_index a s u a -- n", "FUNCTION: gst_tag_list_get_pointer_index ( list tag index value -- n )", "EXTERN: \"C\" int gst_tag_list_get_pointer_index( void * list, char * tag, int index, void * value );", "	( list tag index value -- )" );
	swigFunction( "c-function gst_tag_list_get_date gst_tag_list_get_date a s a -- n", "FUNCTION: gst_tag_list_get_date ( list tag value -- n )", "EXTERN: \"C\" int gst_tag_list_get_date( void * list, char * tag, void * value );", "	( list tag value -- )" );
	swigFunction( "c-function gst_tag_list_get_date_index gst_tag_list_get_date_index a s u a -- n", "FUNCTION: gst_tag_list_get_date_index ( list tag index value -- n )", "EXTERN: \"C\" int gst_tag_list_get_date_index( void * list, char * tag, int index, void * value );", "	( list tag index value -- )" );
	swigFunction( "c-function gst_tag_list_get_date_time gst_tag_list_get_date_time a s a -- n", "FUNCTION: gst_tag_list_get_date_time ( list tag value -- n )", "EXTERN: \"C\" int gst_tag_list_get_date_time( void * list, char * tag, void * value );", "	( list tag value -- )" );
	swigFunction( "c-function gst_tag_list_get_date_time_index gst_tag_list_get_date_time_index a s u a -- n", "FUNCTION: gst_tag_list_get_date_time_index ( list tag index value -- n )", "EXTERN: \"C\" int gst_tag_list_get_date_time_index( void * list, char * tag, int index, void * value );", "	( list tag index value -- )" );
	swigFunction( "c-function gst_tag_list_get_sample gst_tag_list_get_sample a s a -- n", "FUNCTION: gst_tag_list_get_sample ( list tag sample -- n )", "EXTERN: \"C\" int gst_tag_list_get_sample( void * list, char * tag, void * sample );", "	( list tag sample -- )" );
	swigFunction( "c-function gst_tag_list_get_sample_index gst_tag_list_get_sample_index a s u a -- n", "FUNCTION: gst_tag_list_get_sample_index ( list tag index sample -- n )", "EXTERN: \"C\" int gst_tag_list_get_sample_index( void * list, char * tag, int index, void * sample );", "	( list tag index sample -- )" );
	swigFunction( "c-function gst_tag_list_ref gst_tag_list_ref a -- a", "FUNCTION: gst_tag_list_ref ( taglist -- a )", "EXTERN: \"C\" void * gst_tag_list_ref( void * taglist );", "	( taglist -- )" );
	swigFunction( "c-function gst_tag_list_unref gst_tag_list_unref a -- void", "FUNCTION: gst_tag_list_unref ( taglist -- void )", "EXTERN: \"C\" void gst_tag_list_unref( void * taglist );", "	( taglist -- )" );
	swigFunction( "c-function gst_tag_list_copy gst_tag_list_copy a -- a", "FUNCTION: gst_tag_list_copy ( taglist -- a )", "EXTERN: \"C\" void * gst_tag_list_copy( void * taglist );", "	( taglist -- )" );
	swigFunction( "c-function gst_tag_setter_get_type gst_tag_setter_get_type  -- u", "FUNCTION: gst_tag_setter_get_type (  -- u )", "EXTERN: \"C\" int gst_tag_setter_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_tag_setter_reset_tags gst_tag_setter_reset_tags a -- void", "FUNCTION: gst_tag_setter_reset_tags ( setter -- void )", "EXTERN: \"C\" void gst_tag_setter_reset_tags( void * setter );", "	( setter -- )" );
	swigFunction( "c-function gst_tag_setter_merge_tags gst_tag_setter_merge_tags a a n -- void", "FUNCTION: gst_tag_setter_merge_tags ( setter list mode -- void )", "EXTERN: \"C\" void gst_tag_setter_merge_tags( void * setter, void * list, int mode );", "	( setter list mode -- )" );
	swigFunction( "c-function gst_tag_setter_add_tags gst_tag_setter_add_tags a n s ... -- void", "FUNCTION: gst_tag_setter_add_tags ( setter mode tag  -- void )", "EXTERN: \"C\" void gst_tag_setter_add_tags( void * setter, int mode, char * tag, ...  );", "	( setter mode tag <noname> -- )" );
	swigFunction( "c-function gst_tag_setter_add_tag_values gst_tag_setter_add_tag_values a n s ... -- void", "FUNCTION: gst_tag_setter_add_tag_values ( setter mode tag  -- void )", "EXTERN: \"C\" void gst_tag_setter_add_tag_values( void * setter, int mode, char * tag, ...  );", "	( setter mode tag <noname> -- )" );
	swigFunction( "c-function gst_tag_setter_add_tag_valist gst_tag_setter_add_tag_valist a n s a -- void", "FUNCTION: gst_tag_setter_add_tag_valist ( setter mode tag var_args -- void )", "EXTERN: \"C\" void gst_tag_setter_add_tag_valist( void * setter, int mode, char * tag, void * var_args );", "	( setter mode tag var_args -- )" );
	swigFunction( "c-function gst_tag_setter_add_tag_valist_values gst_tag_setter_add_tag_valist_values a n s a -- void", "FUNCTION: gst_tag_setter_add_tag_valist_values ( setter mode tag var_args -- void )", "EXTERN: \"C\" void gst_tag_setter_add_tag_valist_values( void * setter, int mode, char * tag, void * var_args );", "	( setter mode tag var_args -- )" );
	swigFunction( "c-function gst_tag_setter_add_tag_value gst_tag_setter_add_tag_value a n s a -- void", "FUNCTION: gst_tag_setter_add_tag_value ( setter mode tag value -- void )", "EXTERN: \"C\" void gst_tag_setter_add_tag_value( void * setter, int mode, char * tag, void * value );", "	( setter mode tag value -- )" );
	swigFunction( "c-function gst_tag_setter_get_tag_list gst_tag_setter_get_tag_list a -- a", "FUNCTION: gst_tag_setter_get_tag_list ( setter -- a )", "EXTERN: \"C\" void * gst_tag_setter_get_tag_list( void * setter );", "	( setter -- )" );
	swigFunction( "c-function gst_tag_setter_set_tag_merge_mode gst_tag_setter_set_tag_merge_mode a n -- void", "FUNCTION: gst_tag_setter_set_tag_merge_mode ( setter mode -- void )", "EXTERN: \"C\" void gst_tag_setter_set_tag_merge_mode( void * setter, int mode );", "	( setter mode -- )" );
	swigFunction( "c-function gst_tag_setter_get_tag_merge_mode gst_tag_setter_get_tag_merge_mode a -- n", "FUNCTION: gst_tag_setter_get_tag_merge_mode ( setter -- n )", "EXTERN: \"C\" int gst_tag_setter_get_tag_merge_mode( void * setter );", "	( setter -- )" );
	swigFunction( "c-function gst_task_cleanup_all gst_task_cleanup_all  -- void", "FUNCTION: gst_task_cleanup_all (  -- void )", "EXTERN: \"C\" void gst_task_cleanup_all(  );", "	( -- )" );
	swigFunction( "c-function gst_task_get_type gst_task_get_type  -- u", "FUNCTION: gst_task_get_type (  -- u )", "EXTERN: \"C\" int gst_task_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_task_new gst_task_new a a a -- a", "FUNCTION: gst_task_new ( func user_data notify -- a )", "EXTERN: \"C\" void * gst_task_new( void * func, void * user_data, void * notify );", "	( func user_data notify -- )" );
	swigFunction( "c-function gst_task_set_lock gst_task_set_lock a a -- void", "FUNCTION: gst_task_set_lock ( task mutex -- void )", "EXTERN: \"C\" void gst_task_set_lock( void * task, void * mutex );", "	( task mutex -- )" );
	swigFunction( "c-function gst_task_get_pool gst_task_get_pool a -- a", "FUNCTION: gst_task_get_pool ( task -- a )", "EXTERN: \"C\" void * gst_task_get_pool( void * task );", "	( task -- )" );
	swigFunction( "c-function gst_task_set_pool gst_task_set_pool a a -- void", "FUNCTION: gst_task_set_pool ( task pool -- void )", "EXTERN: \"C\" void gst_task_set_pool( void * task, void * pool );", "	( task pool -- )" );
	swigFunction( "c-function gst_task_set_enter_callback gst_task_set_enter_callback a a a a -- void", "FUNCTION: gst_task_set_enter_callback ( task enter_func user_data notify -- void )", "EXTERN: \"C\" void gst_task_set_enter_callback( void * task, void * enter_func, void * user_data, void * notify );", "	( task enter_func user_data notify -- )" );
	swigFunction( "c-function gst_task_set_leave_callback gst_task_set_leave_callback a a a a -- void", "FUNCTION: gst_task_set_leave_callback ( task leave_func user_data notify -- void )", "EXTERN: \"C\" void gst_task_set_leave_callback( void * task, void * leave_func, void * user_data, void * notify );", "	( task leave_func user_data notify -- )" );
	swigFunction( "c-function gst_task_get_state gst_task_get_state a -- n", "FUNCTION: gst_task_get_state ( task -- n )", "EXTERN: \"C\" int gst_task_get_state( void * task );", "	( task -- )" );
	swigFunction( "c-function gst_task_set_state gst_task_set_state a n -- n", "FUNCTION: gst_task_set_state ( task state -- n )", "EXTERN: \"C\" int gst_task_set_state( void * task, int state );", "	( task state -- )" );
	swigFunction( "c-function gst_task_start gst_task_start a -- n", "FUNCTION: gst_task_start ( task -- n )", "EXTERN: \"C\" int gst_task_start( void * task );", "	( task -- )" );
	swigFunction( "c-function gst_task_stop gst_task_stop a -- n", "FUNCTION: gst_task_stop ( task -- n )", "EXTERN: \"C\" int gst_task_stop( void * task );", "	( task -- )" );
	swigFunction( "c-function gst_task_pause gst_task_pause a -- n", "FUNCTION: gst_task_pause ( task -- n )", "EXTERN: \"C\" int gst_task_pause( void * task );", "	( task -- )" );
	swigFunction( "c-function gst_task_join gst_task_join a -- n", "FUNCTION: gst_task_join ( task -- n )", "EXTERN: \"C\" int gst_task_join( void * task );", "	( task -- )" );
	swigFunction( "c-function gst_task_pool_get_type gst_task_pool_get_type  -- u", "FUNCTION: gst_task_pool_get_type (  -- u )", "EXTERN: \"C\" int gst_task_pool_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_task_pool_new gst_task_pool_new  -- a", "FUNCTION: gst_task_pool_new (  -- a )", "EXTERN: \"C\" void * gst_task_pool_new(  );", "	( -- )" );
	swigFunction( "c-function gst_task_pool_prepare gst_task_pool_prepare a a -- void", "FUNCTION: gst_task_pool_prepare ( pool error -- void )", "EXTERN: \"C\" void gst_task_pool_prepare( void * pool, void * error );", "	( pool error -- )" );
	swigFunction( "c-function gst_task_pool_push gst_task_pool_push a a a a -- a", "FUNCTION: gst_task_pool_push ( pool func user_data error -- a )", "EXTERN: \"C\" void * gst_task_pool_push( void * pool, void * func, void * user_data, void * error );", "	( pool func user_data error -- )" );
	swigFunction( "c-function gst_task_pool_join gst_task_pool_join a a -- void", "FUNCTION: gst_task_pool_join ( pool id -- void )", "EXTERN: \"C\" void gst_task_pool_join( void * pool, void * id );", "	( pool id -- )" );
	swigFunction( "c-function gst_task_pool_cleanup gst_task_pool_cleanup a -- void", "FUNCTION: gst_task_pool_cleanup ( pool -- void )", "EXTERN: \"C\" void gst_task_pool_cleanup( void * pool );", "	( pool -- )" );
	swigFunction( "c-function gst_toc_get_type gst_toc_get_type  -- u", "FUNCTION: gst_toc_get_type (  -- u )", "EXTERN: \"C\" int gst_toc_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_toc_entry_get_type gst_toc_entry_get_type  -- u", "FUNCTION: gst_toc_entry_get_type (  -- u )", "EXTERN: \"C\" int gst_toc_entry_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_toc_new gst_toc_new n -- a", "FUNCTION: gst_toc_new ( scope -- a )", "EXTERN: \"C\" void * gst_toc_new( int scope );", "	( scope -- )" );
	swigFunction( "c-function gst_toc_get_scope gst_toc_get_scope a -- n", "FUNCTION: gst_toc_get_scope ( toc -- n )", "EXTERN: \"C\" int gst_toc_get_scope( void * toc );", "	( toc -- )" );
	swigFunction( "c-function gst_toc_set_tags gst_toc_set_tags a a -- void", "FUNCTION: gst_toc_set_tags ( toc tags -- void )", "EXTERN: \"C\" void gst_toc_set_tags( void * toc, void * tags );", "	( toc tags -- )" );
	swigFunction( "c-function gst_toc_merge_tags gst_toc_merge_tags a a n -- void", "FUNCTION: gst_toc_merge_tags ( toc tags mode -- void )", "EXTERN: \"C\" void gst_toc_merge_tags( void * toc, void * tags, int mode );", "	( toc tags mode -- )" );
	swigFunction( "c-function gst_toc_get_tags gst_toc_get_tags a -- a", "FUNCTION: gst_toc_get_tags ( toc -- a )", "EXTERN: \"C\" void * gst_toc_get_tags( void * toc );", "	( toc -- )" );
	swigFunction( "c-function gst_toc_append_entry gst_toc_append_entry a a -- void", "FUNCTION: gst_toc_append_entry ( toc entry -- void )", "EXTERN: \"C\" void gst_toc_append_entry( void * toc, void * entry );", "	( toc entry -- )" );
	swigFunction( "c-function gst_toc_get_entries gst_toc_get_entries a -- a", "FUNCTION: gst_toc_get_entries ( toc -- a )", "EXTERN: \"C\" void * gst_toc_get_entries( void * toc );", "	( toc -- )" );
	swigFunction( "c-function gst_toc_dump gst_toc_dump a -- void", "FUNCTION: gst_toc_dump ( toc -- void )", "EXTERN: \"C\" void gst_toc_dump( void * toc );", "	( toc -- )" );
	swigFunction( "c-function gst_toc_entry_new gst_toc_entry_new n s -- a", "FUNCTION: gst_toc_entry_new ( type uid -- a )", "EXTERN: \"C\" void * gst_toc_entry_new( int type, char * uid );", "	( type uid -- )" );
	swigFunction( "c-function gst_toc_find_entry gst_toc_find_entry a s -- a", "FUNCTION: gst_toc_find_entry ( toc uid -- a )", "EXTERN: \"C\" void * gst_toc_find_entry( void * toc, char * uid );", "	( toc uid -- )" );
	swigFunction( "c-function gst_toc_entry_get_entry_type gst_toc_entry_get_entry_type a -- n", "FUNCTION: gst_toc_entry_get_entry_type ( entry -- n )", "EXTERN: \"C\" int gst_toc_entry_get_entry_type( void * entry );", "	( entry -- )" );
	swigFunction( "c-function gst_toc_entry_get_uid gst_toc_entry_get_uid a -- s", "FUNCTION: gst_toc_entry_get_uid ( entry -- s )", "EXTERN: \"C\" char * gst_toc_entry_get_uid( void * entry );", "	( entry -- )" );
	swigFunction( "c-function gst_toc_entry_append_sub_entry gst_toc_entry_append_sub_entry a a -- void", "FUNCTION: gst_toc_entry_append_sub_entry ( entry subentry -- void )", "EXTERN: \"C\" void gst_toc_entry_append_sub_entry( void * entry, void * subentry );", "	( entry subentry -- )" );
	swigFunction( "c-function gst_toc_entry_get_sub_entries gst_toc_entry_get_sub_entries a -- a", "FUNCTION: gst_toc_entry_get_sub_entries ( entry -- a )", "EXTERN: \"C\" void * gst_toc_entry_get_sub_entries( void * entry );", "	( entry -- )" );
	swigFunction( "c-function gst_toc_entry_set_tags gst_toc_entry_set_tags a a -- void", "FUNCTION: gst_toc_entry_set_tags ( entry tags -- void )", "EXTERN: \"C\" void gst_toc_entry_set_tags( void * entry, void * tags );", "	( entry tags -- )" );
	swigFunction( "c-function gst_toc_entry_merge_tags gst_toc_entry_merge_tags a a n -- void", "FUNCTION: gst_toc_entry_merge_tags ( entry tags mode -- void )", "EXTERN: \"C\" void gst_toc_entry_merge_tags( void * entry, void * tags, int mode );", "	( entry tags mode -- )" );
	swigFunction( "c-function gst_toc_entry_get_tags gst_toc_entry_get_tags a -- a", "FUNCTION: gst_toc_entry_get_tags ( entry -- a )", "EXTERN: \"C\" void * gst_toc_entry_get_tags( void * entry );", "	( entry -- )" );
	swigFunction( "c-function gst_toc_entry_is_alternative gst_toc_entry_is_alternative a -- n", "FUNCTION: gst_toc_entry_is_alternative ( entry -- n )", "EXTERN: \"C\" int gst_toc_entry_is_alternative( void * entry );", "	( entry -- )" );
	swigFunction( "c-function gst_toc_entry_is_sequence gst_toc_entry_is_sequence a -- n", "FUNCTION: gst_toc_entry_is_sequence ( entry -- n )", "EXTERN: \"C\" int gst_toc_entry_is_sequence( void * entry );", "	( entry -- )" );
	swigFunction( "c-function gst_toc_entry_set_start_stop_times gst_toc_entry_set_start_stop_times a d d -- void", "FUNCTION: gst_toc_entry_set_start_stop_times ( entry start stop -- void )", "EXTERN: \"C\" void gst_toc_entry_set_start_stop_times( void * entry, long long start, long long stop );", "	( entry start stop -- )" );
	swigFunction( "c-function gst_toc_entry_get_start_stop_times gst_toc_entry_get_start_stop_times a a a -- n", "FUNCTION: gst_toc_entry_get_start_stop_times ( entry start stop -- n )", "EXTERN: \"C\" int gst_toc_entry_get_start_stop_times( void * entry, void * start, void * stop );", "	( entry start stop -- )" );
	swigFunction( "c-function gst_toc_entry_set_loop gst_toc_entry_set_loop a n n -- void", "FUNCTION: gst_toc_entry_set_loop ( entry loop_type repeat_count -- void )", "EXTERN: \"C\" void gst_toc_entry_set_loop( void * entry, int loop_type, int repeat_count );", "	( entry loop_type repeat_count -- )" );
	swigFunction( "c-function gst_toc_entry_get_loop gst_toc_entry_get_loop a a a -- n", "FUNCTION: gst_toc_entry_get_loop ( entry loop_type repeat_count -- n )", "EXTERN: \"C\" int gst_toc_entry_get_loop( void * entry, void * loop_type, void * repeat_count );", "	( entry loop_type repeat_count -- )" );
	swigFunction( "c-function gst_toc_entry_get_toc gst_toc_entry_get_toc a -- a", "FUNCTION: gst_toc_entry_get_toc ( entry -- a )", "EXTERN: \"C\" void * gst_toc_entry_get_toc( void * entry );", "	( entry -- )" );
	swigFunction( "c-function gst_toc_entry_get_parent gst_toc_entry_get_parent a -- a", "FUNCTION: gst_toc_entry_get_parent ( entry -- a )", "EXTERN: \"C\" void * gst_toc_entry_get_parent( void * entry );", "	( entry -- )" );
	swigFunction( "c-function gst_toc_entry_type_get_nick gst_toc_entry_type_get_nick n -- s", "FUNCTION: gst_toc_entry_type_get_nick ( type -- s )", "EXTERN: \"C\" char * gst_toc_entry_type_get_nick( int type );", "	( type -- )" );
	swigFunction( "c-function gst_toc_setter_get_type gst_toc_setter_get_type  -- u", "FUNCTION: gst_toc_setter_get_type (  -- u )", "EXTERN: \"C\" int gst_toc_setter_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_toc_setter_reset gst_toc_setter_reset a -- void", "FUNCTION: gst_toc_setter_reset ( setter -- void )", "EXTERN: \"C\" void gst_toc_setter_reset( void * setter );", "	( setter -- )" );
	swigFunction( "c-function gst_toc_setter_get_toc gst_toc_setter_get_toc a -- a", "FUNCTION: gst_toc_setter_get_toc ( setter -- a )", "EXTERN: \"C\" void * gst_toc_setter_get_toc( void * setter );", "	( setter -- )" );
	swigFunction( "c-function gst_toc_setter_set_toc gst_toc_setter_set_toc a a -- void", "FUNCTION: gst_toc_setter_set_toc ( setter toc -- void )", "EXTERN: \"C\" void gst_toc_setter_set_toc( void * setter, void * toc );", "	( setter toc -- )" );
	swigFunction( "c-function gst_type_find_get_type gst_type_find_get_type  -- u", "FUNCTION: gst_type_find_get_type (  -- u )", "EXTERN: \"C\" int gst_type_find_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_type_find_peek gst_type_find_peek a d u -- a", "FUNCTION: gst_type_find_peek ( find offset size -- a )", "EXTERN: \"C\" void * gst_type_find_peek( void * find, long long offset, int size );", "	( find offset size -- )" );
	swigFunction( "c-function gst_type_find_suggest gst_type_find_suggest a u a -- void", "FUNCTION: gst_type_find_suggest ( find probability caps -- void )", "EXTERN: \"C\" void gst_type_find_suggest( void * find, int probability, void * caps );", "	( find probability caps -- )" );
	swigFunction( "c-function gst_type_find_suggest_simple gst_type_find_suggest_simple a u s s ... -- void", "FUNCTION: gst_type_find_suggest_simple ( find probability media_type fieldname  -- void )", "EXTERN: \"C\" void gst_type_find_suggest_simple( void * find, int probability, char * media_type, char * fieldname, ...  );", "	( find probability media_type fieldname <noname> -- )" );
	swigFunction( "c-function gst_type_find_get_length gst_type_find_get_length a -- ud", "FUNCTION: gst_type_find_get_length ( find -- ud )", "EXTERN: \"C\" long long gst_type_find_get_length( void * find );", "	( find -- )" );
	swigFunction( "c-function gst_type_find_register gst_type_find_register a s u a s a a a -- n", "FUNCTION: gst_type_find_register ( plugin name rank func extensions possible_caps data data_notify -- n )", "EXTERN: \"C\" int gst_type_find_register( void * plugin, char * name, int rank, void * func, char * extensions, void * possible_caps, void * data, void * data_notify );", "	( plugin name rank func extensions possible_caps data data_notify -- )" );
	swigFunction( "c-function gst_type_find_factory_get_type gst_type_find_factory_get_type  -- u", "FUNCTION: gst_type_find_factory_get_type (  -- u )", "EXTERN: \"C\" int gst_type_find_factory_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_type_find_factory_get_list gst_type_find_factory_get_list  -- a", "FUNCTION: gst_type_find_factory_get_list (  -- a )", "EXTERN: \"C\" void * gst_type_find_factory_get_list(  );", "	( -- )" );
	swigFunction( "c-function gst_type_find_factory_get_extensions gst_type_find_factory_get_extensions a -- a", "FUNCTION: gst_type_find_factory_get_extensions ( factory -- a )", "EXTERN: \"C\" void * gst_type_find_factory_get_extensions( void * factory );", "	( factory -- )" );
	swigFunction( "c-function gst_type_find_factory_get_caps gst_type_find_factory_get_caps a -- a", "FUNCTION: gst_type_find_factory_get_caps ( factory -- a )", "EXTERN: \"C\" void * gst_type_find_factory_get_caps( void * factory );", "	( factory -- )" );
	swigFunction( "c-function gst_type_find_factory_has_function gst_type_find_factory_has_function a -- n", "FUNCTION: gst_type_find_factory_has_function ( factory -- n )", "EXTERN: \"C\" int gst_type_find_factory_has_function( void * factory );", "	( factory -- )" );
	swigFunction( "c-function gst_type_find_factory_call_function gst_type_find_factory_call_function a a -- void", "FUNCTION: gst_type_find_factory_call_function ( factory find -- void )", "EXTERN: \"C\" void gst_type_find_factory_call_function( void * factory, void * find );", "	( factory find -- )" );
	swigFunction( "c-function gst_uri_error_quark gst_uri_error_quark  -- n", "FUNCTION: gst_uri_error_quark (  -- n )", "EXTERN: \"C\" n gst_uri_error_quark(  );", "	( -- )" );
	swigFunction( "c-function gst_uri_protocol_is_valid gst_uri_protocol_is_valid s -- n", "FUNCTION: gst_uri_protocol_is_valid ( protocol -- n )", "EXTERN: \"C\" int gst_uri_protocol_is_valid( char * protocol );", "	( protocol -- )" );
	swigFunction( "c-function gst_uri_protocol_is_supported gst_uri_protocol_is_supported n s -- n", "FUNCTION: gst_uri_protocol_is_supported ( type protocol -- n )", "EXTERN: \"C\" int gst_uri_protocol_is_supported( int type, char * protocol );", "	( type protocol -- )" );
	swigFunction( "c-function gst_uri_is_valid gst_uri_is_valid s -- n", "FUNCTION: gst_uri_is_valid ( uri -- n )", "EXTERN: \"C\" int gst_uri_is_valid( char * uri );", "	( uri -- )" );
	swigFunction( "c-function gst_uri_get_protocol gst_uri_get_protocol s -- a", "FUNCTION: gst_uri_get_protocol ( uri -- a )", "EXTERN: \"C\" void * gst_uri_get_protocol( char * uri );", "	( uri -- )" );
	swigFunction( "c-function gst_uri_has_protocol gst_uri_has_protocol s s -- n", "FUNCTION: gst_uri_has_protocol ( uri protocol -- n )", "EXTERN: \"C\" int gst_uri_has_protocol( char * uri, char * protocol );", "	( uri protocol -- )" );
	swigFunction( "c-function gst_uri_get_location gst_uri_get_location s -- a", "FUNCTION: gst_uri_get_location ( uri -- a )", "EXTERN: \"C\" void * gst_uri_get_location( char * uri );", "	( uri -- )" );
	swigFunction( "c-function gst_uri_construct gst_uri_construct s s -- a", "FUNCTION: gst_uri_construct ( protocol location -- a )", "EXTERN: \"C\" void * gst_uri_construct( char * protocol, char * location );", "	( protocol location -- )" );
	swigFunction( "c-function gst_filename_to_uri gst_filename_to_uri s a -- a", "FUNCTION: gst_filename_to_uri ( filename error -- a )", "EXTERN: \"C\" void * gst_filename_to_uri( char * filename, void * error );", "	( filename error -- )" );
	swigFunction( "c-function gst_element_make_from_uri gst_element_make_from_uri n s s a -- a", "FUNCTION: gst_element_make_from_uri ( type uri elementname error -- a )", "EXTERN: \"C\" void * gst_element_make_from_uri( int type, char * uri, char * elementname, void * error );", "	( type uri elementname error -- )" );
	swigFunction( "c-function gst_uri_handler_get_type gst_uri_handler_get_type  -- u", "FUNCTION: gst_uri_handler_get_type (  -- u )", "EXTERN: \"C\" int gst_uri_handler_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_uri_handler_get_uri_type gst_uri_handler_get_uri_type a -- n", "FUNCTION: gst_uri_handler_get_uri_type ( handler -- n )", "EXTERN: \"C\" int gst_uri_handler_get_uri_type( void * handler );", "	( handler -- )" );
	swigFunction( "c-function gst_uri_handler_get_protocols gst_uri_handler_get_protocols a -- a", "FUNCTION: gst_uri_handler_get_protocols ( handler -- a )", "EXTERN: \"C\" void * gst_uri_handler_get_protocols( void * handler );", "	( handler -- )" );
	swigFunction( "c-function gst_uri_handler_get_uri gst_uri_handler_get_uri a -- a", "FUNCTION: gst_uri_handler_get_uri ( handler -- a )", "EXTERN: \"C\" void * gst_uri_handler_get_uri( void * handler );", "	( handler -- )" );
	swigFunction( "c-function gst_uri_handler_set_uri gst_uri_handler_set_uri a s a -- n", "FUNCTION: gst_uri_handler_set_uri ( handler uri error -- n )", "EXTERN: \"C\" int gst_uri_handler_set_uri( void * handler, char * uri, void * error );", "	( handler uri error -- )" );
	swigFunction( "c-function gst_uri_get_type gst_uri_get_type  -- u", "FUNCTION: gst_uri_get_type (  -- u )", "EXTERN: \"C\" int gst_uri_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_uri_new gst_uri_new s s s u s s s -- a", "FUNCTION: gst_uri_new ( scheme userinfo host port path query fragment -- a )", "EXTERN: \"C\" void * gst_uri_new( char * scheme, char * userinfo, char * host, int port, char * path, char * query, char * fragment );", "	( scheme userinfo host port path query fragment -- )" );
	swigFunction( "c-function gst_uri_new_with_base gst_uri_new_with_base a s s s u s s s -- a", "FUNCTION: gst_uri_new_with_base ( base scheme userinfo host port path query fragment -- a )", "EXTERN: \"C\" void * gst_uri_new_with_base( void * base, char * scheme, char * userinfo, char * host, int port, char * path, char * query, char * fragment );", "	( base scheme userinfo host port path query fragment -- )" );
	swigFunction( "c-function gst_uri_from_string gst_uri_from_string s -- a", "FUNCTION: gst_uri_from_string ( uri -- a )", "EXTERN: \"C\" void * gst_uri_from_string( char * uri );", "	( uri -- )" );
	swigFunction( "c-function gst_uri_from_string_with_base gst_uri_from_string_with_base a s -- a", "FUNCTION: gst_uri_from_string_with_base ( base uri -- a )", "EXTERN: \"C\" void * gst_uri_from_string_with_base( void * base, char * uri );", "	( base uri -- )" );
	swigFunction( "c-function gst_uri_equal gst_uri_equal a a -- n", "FUNCTION: gst_uri_equal ( first second -- n )", "EXTERN: \"C\" int gst_uri_equal( void * first, void * second );", "	( first second -- )" );
	swigFunction( "c-function gst_uri_join gst_uri_join a a -- a", "FUNCTION: gst_uri_join ( base_uri ref_uri -- a )", "EXTERN: \"C\" void * gst_uri_join( void * base_uri, void * ref_uri );", "	( base_uri ref_uri -- )" );
	swigFunction( "c-function gst_uri_join_strings gst_uri_join_strings s s -- a", "FUNCTION: gst_uri_join_strings ( base_uri ref_uri -- a )", "EXTERN: \"C\" void * gst_uri_join_strings( char * base_uri, char * ref_uri );", "	( base_uri ref_uri -- )" );
	swigFunction( "c-function gst_uri_is_writable gst_uri_is_writable a -- n", "FUNCTION: gst_uri_is_writable ( uri -- n )", "EXTERN: \"C\" int gst_uri_is_writable( void * uri );", "	( uri -- )" );
	swigFunction( "c-function gst_uri_make_writable gst_uri_make_writable a -- a", "FUNCTION: gst_uri_make_writable ( uri -- a )", "EXTERN: \"C\" void * gst_uri_make_writable( void * uri );", "	( uri -- )" );
	swigFunction( "c-function gst_uri_to_string gst_uri_to_string a -- a", "FUNCTION: gst_uri_to_string ( uri -- a )", "EXTERN: \"C\" void * gst_uri_to_string( void * uri );", "	( uri -- )" );
	swigFunction( "c-function gst_uri_is_normalized gst_uri_is_normalized a -- n", "FUNCTION: gst_uri_is_normalized ( uri -- n )", "EXTERN: \"C\" int gst_uri_is_normalized( void * uri );", "	( uri -- )" );
	swigFunction( "c-function gst_uri_normalize gst_uri_normalize a -- n", "FUNCTION: gst_uri_normalize ( uri -- n )", "EXTERN: \"C\" int gst_uri_normalize( void * uri );", "	( uri -- )" );
	swigFunction( "c-function gst_uri_get_scheme gst_uri_get_scheme a -- s", "FUNCTION: gst_uri_get_scheme ( uri -- s )", "EXTERN: \"C\" char * gst_uri_get_scheme( void * uri );", "	( uri -- )" );
	swigFunction( "c-function gst_uri_set_scheme gst_uri_set_scheme a s -- n", "FUNCTION: gst_uri_set_scheme ( uri scheme -- n )", "EXTERN: \"C\" int gst_uri_set_scheme( void * uri, char * scheme );", "	( uri scheme -- )" );
	swigFunction( "c-function gst_uri_get_userinfo gst_uri_get_userinfo a -- s", "FUNCTION: gst_uri_get_userinfo ( uri -- s )", "EXTERN: \"C\" char * gst_uri_get_userinfo( void * uri );", "	( uri -- )" );
	swigFunction( "c-function gst_uri_set_userinfo gst_uri_set_userinfo a s -- n", "FUNCTION: gst_uri_set_userinfo ( uri userinfo -- n )", "EXTERN: \"C\" int gst_uri_set_userinfo( void * uri, char * userinfo );", "	( uri userinfo -- )" );
	swigFunction( "c-function gst_uri_get_host gst_uri_get_host a -- s", "FUNCTION: gst_uri_get_host ( uri -- s )", "EXTERN: \"C\" char * gst_uri_get_host( void * uri );", "	( uri -- )" );
	swigFunction( "c-function gst_uri_set_host gst_uri_set_host a s -- n", "FUNCTION: gst_uri_set_host ( uri host -- n )", "EXTERN: \"C\" int gst_uri_set_host( void * uri, char * host );", "	( uri host -- )" );
	swigFunction( "c-function gst_uri_get_port gst_uri_get_port a -- u", "FUNCTION: gst_uri_get_port ( uri -- u )", "EXTERN: \"C\" int gst_uri_get_port( void * uri );", "	( uri -- )" );
	swigFunction( "c-function gst_uri_set_port gst_uri_set_port a u -- n", "FUNCTION: gst_uri_set_port ( uri port -- n )", "EXTERN: \"C\" int gst_uri_set_port( void * uri, int port );", "	( uri port -- )" );
	swigFunction( "c-function gst_uri_get_path gst_uri_get_path a -- a", "FUNCTION: gst_uri_get_path ( uri -- a )", "EXTERN: \"C\" void * gst_uri_get_path( void * uri );", "	( uri -- )" );
	swigFunction( "c-function gst_uri_set_path gst_uri_set_path a s -- n", "FUNCTION: gst_uri_set_path ( uri path -- n )", "EXTERN: \"C\" int gst_uri_set_path( void * uri, char * path );", "	( uri path -- )" );
	swigFunction( "c-function gst_uri_get_path_string gst_uri_get_path_string a -- a", "FUNCTION: gst_uri_get_path_string ( uri -- a )", "EXTERN: \"C\" void * gst_uri_get_path_string( void * uri );", "	( uri -- )" );
	swigFunction( "c-function gst_uri_set_path_string gst_uri_set_path_string a s -- n", "FUNCTION: gst_uri_set_path_string ( uri path -- n )", "EXTERN: \"C\" int gst_uri_set_path_string( void * uri, char * path );", "	( uri path -- )" );
	swigFunction( "c-function gst_uri_get_path_segments gst_uri_get_path_segments a -- a", "FUNCTION: gst_uri_get_path_segments ( uri -- a )", "EXTERN: \"C\" void * gst_uri_get_path_segments( void * uri );", "	( uri -- )" );
	swigFunction( "c-function gst_uri_set_path_segments gst_uri_set_path_segments a a -- n", "FUNCTION: gst_uri_set_path_segments ( uri path_segments -- n )", "EXTERN: \"C\" int gst_uri_set_path_segments( void * uri, void * path_segments );", "	( uri path_segments -- )" );
	swigFunction( "c-function gst_uri_append_path gst_uri_append_path a s -- n", "FUNCTION: gst_uri_append_path ( uri relative_path -- n )", "EXTERN: \"C\" int gst_uri_append_path( void * uri, char * relative_path );", "	( uri relative_path -- )" );
	swigFunction( "c-function gst_uri_append_path_segment gst_uri_append_path_segment a s -- n", "FUNCTION: gst_uri_append_path_segment ( uri path_segment -- n )", "EXTERN: \"C\" int gst_uri_append_path_segment( void * uri, char * path_segment );", "	( uri path_segment -- )" );
	swigFunction( "c-function gst_uri_get_query_string gst_uri_get_query_string a -- a", "FUNCTION: gst_uri_get_query_string ( uri -- a )", "EXTERN: \"C\" void * gst_uri_get_query_string( void * uri );", "	( uri -- )" );
	swigFunction( "c-function gst_uri_set_query_string gst_uri_set_query_string a s -- n", "FUNCTION: gst_uri_set_query_string ( uri query -- n )", "EXTERN: \"C\" int gst_uri_set_query_string( void * uri, char * query );", "	( uri query -- )" );
	swigFunction( "c-function gst_uri_get_query_table gst_uri_get_query_table a -- a", "FUNCTION: gst_uri_get_query_table ( uri -- a )", "EXTERN: \"C\" void * gst_uri_get_query_table( void * uri );", "	( uri -- )" );
	swigFunction( "c-function gst_uri_set_query_table gst_uri_set_query_table a a -- n", "FUNCTION: gst_uri_set_query_table ( uri query_table -- n )", "EXTERN: \"C\" int gst_uri_set_query_table( void * uri, void * query_table );", "	( uri query_table -- )" );
	swigFunction( "c-function gst_uri_set_query_value gst_uri_set_query_value a s s -- n", "FUNCTION: gst_uri_set_query_value ( uri query_key query_value -- n )", "EXTERN: \"C\" int gst_uri_set_query_value( void * uri, char * query_key, char * query_value );", "	( uri query_key query_value -- )" );
	swigFunction( "c-function gst_uri_remove_query_key gst_uri_remove_query_key a s -- n", "FUNCTION: gst_uri_remove_query_key ( uri query_key -- n )", "EXTERN: \"C\" int gst_uri_remove_query_key( void * uri, char * query_key );", "	( uri query_key -- )" );
	swigFunction( "c-function gst_uri_query_has_key gst_uri_query_has_key a s -- n", "FUNCTION: gst_uri_query_has_key ( uri query_key -- n )", "EXTERN: \"C\" int gst_uri_query_has_key( void * uri, char * query_key );", "	( uri query_key -- )" );
	swigFunction( "c-function gst_uri_get_query_value gst_uri_get_query_value a s -- s", "FUNCTION: gst_uri_get_query_value ( uri query_key -- s )", "EXTERN: \"C\" char * gst_uri_get_query_value( void * uri, char * query_key );", "	( uri query_key -- )" );
	swigFunction( "c-function gst_uri_get_query_keys gst_uri_get_query_keys a -- a", "FUNCTION: gst_uri_get_query_keys ( uri -- a )", "EXTERN: \"C\" void * gst_uri_get_query_keys( void * uri );", "	( uri -- )" );
	swigFunction( "c-function gst_uri_get_fragment gst_uri_get_fragment a -- s", "FUNCTION: gst_uri_get_fragment ( uri -- s )", "EXTERN: \"C\" char * gst_uri_get_fragment( void * uri );", "	( uri -- )" );
	swigFunction( "c-function gst_uri_set_fragment gst_uri_set_fragment a s -- n", "FUNCTION: gst_uri_set_fragment ( uri fragment -- n )", "EXTERN: \"C\" int gst_uri_set_fragment( void * uri, char * fragment );", "	( uri fragment -- )" );
	swigFunction( "c-function gst_uri_get_media_fragment_table gst_uri_get_media_fragment_table a -- a", "FUNCTION: gst_uri_get_media_fragment_table ( uri -- a )", "EXTERN: \"C\" void * gst_uri_get_media_fragment_table( void * uri );", "	( uri -- )" );
	swigFunction( "c-function gst_uri_copy gst_uri_copy a -- a", "FUNCTION: gst_uri_copy ( uri -- a )", "EXTERN: \"C\" void * gst_uri_copy( void * uri );", "	( uri -- )" );
	swigFunction( "c-function gst_uri_ref gst_uri_ref a -- a", "FUNCTION: gst_uri_ref ( uri -- a )", "EXTERN: \"C\" void * gst_uri_ref( void * uri );", "	( uri -- )" );
	swigFunction( "c-function gst_uri_unref gst_uri_unref a -- void", "FUNCTION: gst_uri_unref ( uri -- void )", "EXTERN: \"C\" void gst_uri_unref( void * uri );", "	( uri -- )" );
	swigFunction( "c-function gst_util_set_value_from_string gst_util_set_value_from_string a s -- void", "FUNCTION: gst_util_set_value_from_string ( value value_str -- void )", "EXTERN: \"C\" void gst_util_set_value_from_string( void * value, char * value_str );", "	( value value_str -- )" );
	swigFunction( "c-function gst_util_set_object_arg gst_util_set_object_arg a s s -- void", "FUNCTION: gst_util_set_object_arg ( object name value -- void )", "EXTERN: \"C\" void gst_util_set_object_arg( void * object, char * name, char * value );", "	( object name value -- )" );
	swigFunction( "c-function gst_util_set_object_array gst_util_set_object_array a s a -- n", "FUNCTION: gst_util_set_object_array ( object name array -- n )", "EXTERN: \"C\" int gst_util_set_object_array( void * object, char * name, void * array );", "	( object name array -- )" );
	swigFunction( "c-function gst_util_get_object_array gst_util_get_object_array a s a -- n", "FUNCTION: gst_util_get_object_array ( object name array -- n )", "EXTERN: \"C\" int gst_util_get_object_array( void * object, char * name, void * array );", "	( object name array -- )" );
	swigFunction( "c-function gst_util_dump_mem gst_util_dump_mem a u -- void", "FUNCTION: gst_util_dump_mem ( mem size -- void )", "EXTERN: \"C\" void gst_util_dump_mem( void * mem, int size );", "	( mem size -- )" );
	swigFunction( "c-function gst_util_dump_buffer gst_util_dump_buffer a -- void", "FUNCTION: gst_util_dump_buffer ( buf -- void )", "EXTERN: \"C\" void gst_util_dump_buffer( void * buf );", "	( buf -- )" );
	swigFunction( "c-function gst_util_gdouble_to_guint64 gst_util_gdouble_to_guint64 r -- ud", "FUNCTION: gst_util_gdouble_to_guint64 ( value -- ud )", "EXTERN: \"C\" long long gst_util_gdouble_to_guint64( double value );", "	( value -- )" );
	swigFunction( "c-function gst_util_guint64_to_gdouble gst_util_guint64_to_gdouble ud -- r", "FUNCTION: gst_util_guint64_to_gdouble ( value -- r )", "EXTERN: \"C\" double gst_util_guint64_to_gdouble( long long value );", "	( value -- )" );
	swigFunction( "c-function gst_util_uint64_scale gst_util_uint64_scale ud ud ud -- ud", "FUNCTION: gst_util_uint64_scale ( val num denom -- ud )", "EXTERN: \"C\" long long gst_util_uint64_scale( long long val, long long num, long long denom );", "	( val num denom -- )" );
	swigFunction( "c-function gst_util_uint64_scale_round gst_util_uint64_scale_round ud ud ud -- ud", "FUNCTION: gst_util_uint64_scale_round ( val num denom -- ud )", "EXTERN: \"C\" long long gst_util_uint64_scale_round( long long val, long long num, long long denom );", "	( val num denom -- )" );
	swigFunction( "c-function gst_util_uint64_scale_ceil gst_util_uint64_scale_ceil ud ud ud -- ud", "FUNCTION: gst_util_uint64_scale_ceil ( val num denom -- ud )", "EXTERN: \"C\" long long gst_util_uint64_scale_ceil( long long val, long long num, long long denom );", "	( val num denom -- )" );
	swigFunction( "c-function gst_util_uint64_scale_int gst_util_uint64_scale_int ud n n -- ud", "FUNCTION: gst_util_uint64_scale_int ( val num denom -- ud )", "EXTERN: \"C\" long long gst_util_uint64_scale_int( long long val, int num, int denom );", "	( val num denom -- )" );
	swigFunction( "c-function gst_util_uint64_scale_int_round gst_util_uint64_scale_int_round ud n n -- ud", "FUNCTION: gst_util_uint64_scale_int_round ( val num denom -- ud )", "EXTERN: \"C\" long long gst_util_uint64_scale_int_round( long long val, int num, int denom );", "	( val num denom -- )" );
	swigFunction( "c-function gst_util_uint64_scale_int_ceil gst_util_uint64_scale_int_ceil ud n n -- ud", "FUNCTION: gst_util_uint64_scale_int_ceil ( val num denom -- ud )", "EXTERN: \"C\" long long gst_util_uint64_scale_int_ceil( long long val, int num, int denom );", "	( val num denom -- )" );
	swigFunction( "c-function gst_util_seqnum_next gst_util_seqnum_next  -- u", "FUNCTION: gst_util_seqnum_next (  -- u )", "EXTERN: \"C\" int gst_util_seqnum_next(  );", "	( -- )" );
	swigFunction( "c-function gst_util_seqnum_compare gst_util_seqnum_compare u u -- n", "FUNCTION: gst_util_seqnum_compare ( s1 s2 -- n )", "EXTERN: \"C\" int gst_util_seqnum_compare( int s1, int s2 );", "	( s1 s2 -- )" );
	swigFunction( "c-function gst_util_group_id_next gst_util_group_id_next  -- u", "FUNCTION: gst_util_group_id_next (  -- u )", "EXTERN: \"C\" int gst_util_group_id_next(  );", "	( -- )" );
	swigFunction( "c-function __gst_slow_read64_be __gst_slow_read64_be a -- ud", "FUNCTION: __gst_slow_read64_be ( data -- ud )", "EXTERN: \"C\" long long __gst_slow_read64_be( void * data );", "	( data -- )" );
	swigFunction( "c-function __gst_slow_read64_le __gst_slow_read64_le a -- ud", "FUNCTION: __gst_slow_read64_le ( data -- ud )", "EXTERN: \"C\" long long __gst_slow_read64_le( void * data );", "	( data -- )" );
	swigFunction( "c-function __gst_slow_read32_be __gst_slow_read32_be a -- u", "FUNCTION: __gst_slow_read32_be ( data -- u )", "EXTERN: \"C\" int __gst_slow_read32_be( void * data );", "	( data -- )" );
	swigFunction( "c-function __gst_slow_read32_le __gst_slow_read32_le a -- u", "FUNCTION: __gst_slow_read32_le ( data -- u )", "EXTERN: \"C\" int __gst_slow_read32_le( void * data );", "	( data -- )" );
	swigFunction( "c-function __gst_slow_read24_be __gst_slow_read24_be a -- u", "FUNCTION: __gst_slow_read24_be ( data -- u )", "EXTERN: \"C\" int __gst_slow_read24_be( void * data );", "	( data -- )" );
	swigFunction( "c-function __gst_slow_read24_le __gst_slow_read24_le a -- u", "FUNCTION: __gst_slow_read24_le ( data -- u )", "EXTERN: \"C\" int __gst_slow_read24_le( void * data );", "	( data -- )" );
	swigFunction( "c-function __gst_slow_read16_be __gst_slow_read16_be a -- u", "FUNCTION: __gst_slow_read16_be ( data -- u )", "EXTERN: \"C\" int __gst_slow_read16_be( void * data );", "	( data -- )" );
	swigFunction( "c-function __gst_slow_read16_le __gst_slow_read16_le a -- u", "FUNCTION: __gst_slow_read16_le ( data -- u )", "EXTERN: \"C\" int __gst_slow_read16_le( void * data );", "	( data -- )" );
	swigFunction( "c-function GFLOAT_SWAP_LE_BE GFLOAT_SWAP_LE_BE r -- r", "FUNCTION: GFLOAT_SWAP_LE_BE ( in -- r )", "EXTERN: \"C\" float GFLOAT_SWAP_LE_BE( float in );", "	( in -- )" );
	swigFunction( "c-function GDOUBLE_SWAP_LE_BE GDOUBLE_SWAP_LE_BE r -- r", "FUNCTION: GDOUBLE_SWAP_LE_BE ( in -- r )", "EXTERN: \"C\" double GDOUBLE_SWAP_LE_BE( double in );", "	( in -- )" );
	swigFunction( "c-function GST_READ_FLOAT_LE GST_READ_FLOAT_LE a -- r", "FUNCTION: GST_READ_FLOAT_LE ( data -- r )", "EXTERN: \"C\" float GST_READ_FLOAT_LE( void * data );", "	( data -- )" );
	swigFunction( "c-function GST_READ_FLOAT_BE GST_READ_FLOAT_BE a -- r", "FUNCTION: GST_READ_FLOAT_BE ( data -- r )", "EXTERN: \"C\" float GST_READ_FLOAT_BE( void * data );", "	( data -- )" );
	swigFunction( "c-function GST_READ_DOUBLE_LE GST_READ_DOUBLE_LE a -- r", "FUNCTION: GST_READ_DOUBLE_LE ( data -- r )", "EXTERN: \"C\" double GST_READ_DOUBLE_LE( void * data );", "	( data -- )" );
	swigFunction( "c-function GST_READ_DOUBLE_BE GST_READ_DOUBLE_BE a -- r", "FUNCTION: GST_READ_DOUBLE_BE ( data -- r )", "EXTERN: \"C\" double GST_READ_DOUBLE_BE( void * data );", "	( data -- )" );
	swigFunction( "c-function GST_WRITE_FLOAT_LE GST_WRITE_FLOAT_LE a r -- void", "FUNCTION: GST_WRITE_FLOAT_LE ( data num -- void )", "EXTERN: \"C\" void GST_WRITE_FLOAT_LE( void * data, float num );", "	( data num -- )" );
	swigFunction( "c-function GST_WRITE_FLOAT_BE GST_WRITE_FLOAT_BE a r -- void", "FUNCTION: GST_WRITE_FLOAT_BE ( data num -- void )", "EXTERN: \"C\" void GST_WRITE_FLOAT_BE( void * data, float num );", "	( data num -- )" );
	swigFunction( "c-function GST_WRITE_DOUBLE_LE GST_WRITE_DOUBLE_LE a r -- void", "FUNCTION: GST_WRITE_DOUBLE_LE ( data num -- void )", "EXTERN: \"C\" void GST_WRITE_DOUBLE_LE( void * data, double num );", "	( data num -- )" );
	swigFunction( "c-function GST_WRITE_DOUBLE_BE GST_WRITE_DOUBLE_BE a r -- void", "FUNCTION: GST_WRITE_DOUBLE_BE ( data num -- void )", "EXTERN: \"C\" void GST_WRITE_DOUBLE_BE( void * data, double num );", "	( data num -- )" );
	swigFunction( "c-function gst_object_default_error gst_object_default_error a a s -- void", "FUNCTION: gst_object_default_error ( source error debug -- void )", "EXTERN: \"C\" void gst_object_default_error( void * source, void * error, char * debug );", "	( source error debug -- )" );
	swigFunction( "c-function gst_element_create_all_pads gst_element_create_all_pads a -- void", "FUNCTION: gst_element_create_all_pads ( element -- void )", "EXTERN: \"C\" void gst_element_create_all_pads( void * element );", "	( element -- )" );
	swigFunction( "c-function gst_element_get_compatible_pad gst_element_get_compatible_pad a a a -- a", "FUNCTION: gst_element_get_compatible_pad ( element pad caps -- a )", "EXTERN: \"C\" void * gst_element_get_compatible_pad( void * element, void * pad, void * caps );", "	( element pad caps -- )" );
	swigFunction( "c-function gst_element_get_compatible_pad_template gst_element_get_compatible_pad_template a a -- a", "FUNCTION: gst_element_get_compatible_pad_template ( element compattempl -- a )", "EXTERN: \"C\" void * gst_element_get_compatible_pad_template( void * element, void * compattempl );", "	( element compattempl -- )" );
	swigFunction( "c-function gst_element_state_get_name gst_element_state_get_name n -- s", "FUNCTION: gst_element_state_get_name ( state -- s )", "EXTERN: \"C\" char * gst_element_state_get_name( int state );", "	( state -- )" );
	swigFunction( "c-function gst_element_state_change_return_get_name gst_element_state_change_return_get_name n -- s", "FUNCTION: gst_element_state_change_return_get_name ( state_ret -- s )", "EXTERN: \"C\" char * gst_element_state_change_return_get_name( int state_ret );", "	( state_ret -- )" );
	swigFunction( "c-function gst_state_change_get_name gst_state_change_get_name n -- s", "FUNCTION: gst_state_change_get_name ( transition -- s )", "EXTERN: \"C\" char * gst_state_change_get_name( int transition );", "	( transition -- )" );
	swigFunction( "c-function gst_element_link gst_element_link a a -- n", "FUNCTION: gst_element_link ( src dest -- n )", "EXTERN: \"C\" int gst_element_link( void * src, void * dest );", "	( src dest -- )" );
	swigFunction( "c-function gst_element_link_many gst_element_link_many a a ... -- n", "FUNCTION: gst_element_link_many ( element_1 element_2  -- n )", "EXTERN: \"C\" int gst_element_link_many( void * element_1, void * element_2, ...  );", "	( element_1 element_2 <noname> -- )" );
	swigFunction( "c-function gst_element_link_filtered gst_element_link_filtered a a a -- n", "FUNCTION: gst_element_link_filtered ( src dest filter -- n )", "EXTERN: \"C\" int gst_element_link_filtered( void * src, void * dest, void * filter );", "	( src dest filter -- )" );
	swigFunction( "c-function gst_element_unlink gst_element_unlink a a -- void", "FUNCTION: gst_element_unlink ( src dest -- void )", "EXTERN: \"C\" void gst_element_unlink( void * src, void * dest );", "	( src dest -- )" );
	swigFunction( "c-function gst_element_unlink_many gst_element_unlink_many a a ... -- void", "FUNCTION: gst_element_unlink_many ( element_1 element_2  -- void )", "EXTERN: \"C\" void gst_element_unlink_many( void * element_1, void * element_2, ...  );", "	( element_1 element_2 <noname> -- )" );
	swigFunction( "c-function gst_element_link_pads gst_element_link_pads a s a s -- n", "FUNCTION: gst_element_link_pads ( src srcpadname dest destpadname -- n )", "EXTERN: \"C\" int gst_element_link_pads( void * src, char * srcpadname, void * dest, char * destpadname );", "	( src srcpadname dest destpadname -- )" );
	swigFunction( "c-function gst_element_link_pads_full gst_element_link_pads_full a s a s n -- n", "FUNCTION: gst_element_link_pads_full ( src srcpadname dest destpadname flags -- n )", "EXTERN: \"C\" int gst_element_link_pads_full( void * src, char * srcpadname, void * dest, char * destpadname, int flags );", "	( src srcpadname dest destpadname flags -- )" );
	swigFunction( "c-function gst_element_unlink_pads gst_element_unlink_pads a s a s -- void", "FUNCTION: gst_element_unlink_pads ( src srcpadname dest destpadname -- void )", "EXTERN: \"C\" void gst_element_unlink_pads( void * src, char * srcpadname, void * dest, char * destpadname );", "	( src srcpadname dest destpadname -- )" );
	swigFunction( "c-function gst_element_link_pads_filtered gst_element_link_pads_filtered a s a s a -- n", "FUNCTION: gst_element_link_pads_filtered ( src srcpadname dest destpadname filter -- n )", "EXTERN: \"C\" int gst_element_link_pads_filtered( void * src, char * srcpadname, void * dest, char * destpadname, void * filter );", "	( src srcpadname dest destpadname filter -- )" );
	swigFunction( "c-function gst_element_seek_simple gst_element_seek_simple a u n d -- n", "FUNCTION: gst_element_seek_simple ( element format seek_flags seek_pos -- n )", "EXTERN: \"C\" int gst_element_seek_simple( void * element, int format, int seek_flags, long long seek_pos );", "	( element format seek_flags seek_pos -- )" );
	swigFunction( "c-function gst_element_factory_can_sink_all_caps gst_element_factory_can_sink_all_caps a a -- n", "FUNCTION: gst_element_factory_can_sink_all_caps ( factory caps -- n )", "EXTERN: \"C\" int gst_element_factory_can_sink_all_caps( void * factory, void * caps );", "	( factory caps -- )" );
	swigFunction( "c-function gst_element_factory_can_src_all_caps gst_element_factory_can_src_all_caps a a -- n", "FUNCTION: gst_element_factory_can_src_all_caps ( factory caps -- n )", "EXTERN: \"C\" int gst_element_factory_can_src_all_caps( void * factory, void * caps );", "	( factory caps -- )" );
	swigFunction( "c-function gst_element_factory_can_sink_any_caps gst_element_factory_can_sink_any_caps a a -- n", "FUNCTION: gst_element_factory_can_sink_any_caps ( factory caps -- n )", "EXTERN: \"C\" int gst_element_factory_can_sink_any_caps( void * factory, void * caps );", "	( factory caps -- )" );
	swigFunction( "c-function gst_element_factory_can_src_any_caps gst_element_factory_can_src_any_caps a a -- n", "FUNCTION: gst_element_factory_can_src_any_caps ( factory caps -- n )", "EXTERN: \"C\" int gst_element_factory_can_src_any_caps( void * factory, void * caps );", "	( factory caps -- )" );
	swigFunction( "c-function gst_element_query_position gst_element_query_position a u a -- n", "FUNCTION: gst_element_query_position ( element format cur -- n )", "EXTERN: \"C\" int gst_element_query_position( void * element, int format, void * cur );", "	( element format cur -- )" );
	swigFunction( "c-function gst_element_query_duration gst_element_query_duration a u a -- n", "FUNCTION: gst_element_query_duration ( element format duration -- n )", "EXTERN: \"C\" int gst_element_query_duration( void * element, int format, void * duration );", "	( element format duration -- )" );
	swigFunction( "c-function gst_element_query_convert gst_element_query_convert a u d u a -- n", "FUNCTION: gst_element_query_convert ( element src_format src_val dest_format dest_val -- n )", "EXTERN: \"C\" int gst_element_query_convert( void * element, int src_format, long long src_val, int dest_format, void * dest_val );", "	( element src_format src_val dest_format dest_val -- )" );
	swigFunction( "c-function gst_pad_use_fixed_caps gst_pad_use_fixed_caps a -- void", "FUNCTION: gst_pad_use_fixed_caps ( pad -- void )", "EXTERN: \"C\" void gst_pad_use_fixed_caps( void * pad );", "	( pad -- )" );
	swigFunction( "c-function gst_pad_get_parent_element gst_pad_get_parent_element a -- a", "FUNCTION: gst_pad_get_parent_element ( pad -- a )", "EXTERN: \"C\" void * gst_pad_get_parent_element( void * pad );", "	( pad -- )" );
	swigFunction( "c-function gst_pad_proxy_query_accept_caps gst_pad_proxy_query_accept_caps a a -- n", "FUNCTION: gst_pad_proxy_query_accept_caps ( pad query -- n )", "EXTERN: \"C\" int gst_pad_proxy_query_accept_caps( void * pad, void * query );", "	( pad query -- )" );
	swigFunction( "c-function gst_pad_proxy_query_caps gst_pad_proxy_query_caps a a -- n", "FUNCTION: gst_pad_proxy_query_caps ( pad query -- n )", "EXTERN: \"C\" int gst_pad_proxy_query_caps( void * pad, void * query );", "	( pad query -- )" );
	swigFunction( "c-function gst_pad_query_position gst_pad_query_position a u a -- n", "FUNCTION: gst_pad_query_position ( pad format cur -- n )", "EXTERN: \"C\" int gst_pad_query_position( void * pad, int format, void * cur );", "	( pad format cur -- )" );
	swigFunction( "c-function gst_pad_query_duration gst_pad_query_duration a u a -- n", "FUNCTION: gst_pad_query_duration ( pad format duration -- n )", "EXTERN: \"C\" int gst_pad_query_duration( void * pad, int format, void * duration );", "	( pad format duration -- )" );
	swigFunction( "c-function gst_pad_query_convert gst_pad_query_convert a u d u a -- n", "FUNCTION: gst_pad_query_convert ( pad src_format src_val dest_format dest_val -- n )", "EXTERN: \"C\" int gst_pad_query_convert( void * pad, int src_format, long long src_val, int dest_format, void * dest_val );", "	( pad src_format src_val dest_format dest_val -- )" );
	swigFunction( "c-function gst_pad_query_caps gst_pad_query_caps a a -- a", "FUNCTION: gst_pad_query_caps ( pad filter -- a )", "EXTERN: \"C\" void * gst_pad_query_caps( void * pad, void * filter );", "	( pad filter -- )" );
	swigFunction( "c-function gst_pad_query_accept_caps gst_pad_query_accept_caps a a -- n", "FUNCTION: gst_pad_query_accept_caps ( pad caps -- n )", "EXTERN: \"C\" int gst_pad_query_accept_caps( void * pad, void * caps );", "	( pad caps -- )" );
	swigFunction( "c-function gst_pad_link_maybe_ghosting gst_pad_link_maybe_ghosting a a -- n", "FUNCTION: gst_pad_link_maybe_ghosting ( src sink -- n )", "EXTERN: \"C\" int gst_pad_link_maybe_ghosting( void * src, void * sink );", "	( src sink -- )" );
	swigFunction( "c-function gst_pad_link_maybe_ghosting_full gst_pad_link_maybe_ghosting_full a a n -- n", "FUNCTION: gst_pad_link_maybe_ghosting_full ( src sink flags -- n )", "EXTERN: \"C\" int gst_pad_link_maybe_ghosting_full( void * src, void * sink, int flags );", "	( src sink flags -- )" );
	swigFunction( "c-function gst_pad_peer_query_position gst_pad_peer_query_position a u a -- n", "FUNCTION: gst_pad_peer_query_position ( pad format cur -- n )", "EXTERN: \"C\" int gst_pad_peer_query_position( void * pad, int format, void * cur );", "	( pad format cur -- )" );
	swigFunction( "c-function gst_pad_peer_query_duration gst_pad_peer_query_duration a u a -- n", "FUNCTION: gst_pad_peer_query_duration ( pad format duration -- n )", "EXTERN: \"C\" int gst_pad_peer_query_duration( void * pad, int format, void * duration );", "	( pad format duration -- )" );
	swigFunction( "c-function gst_pad_peer_query_convert gst_pad_peer_query_convert a u d u a -- n", "FUNCTION: gst_pad_peer_query_convert ( pad src_format src_val dest_format dest_val -- n )", "EXTERN: \"C\" int gst_pad_peer_query_convert( void * pad, int src_format, long long src_val, int dest_format, void * dest_val );", "	( pad src_format src_val dest_format dest_val -- )" );
	swigFunction( "c-function gst_pad_peer_query_caps gst_pad_peer_query_caps a a -- a", "FUNCTION: gst_pad_peer_query_caps ( pad filter -- a )", "EXTERN: \"C\" void * gst_pad_peer_query_caps( void * pad, void * filter );", "	( pad filter -- )" );
	swigFunction( "c-function gst_pad_peer_query_accept_caps gst_pad_peer_query_accept_caps a a -- n", "FUNCTION: gst_pad_peer_query_accept_caps ( pad caps -- n )", "EXTERN: \"C\" int gst_pad_peer_query_accept_caps( void * pad, void * caps );", "	( pad caps -- )" );
	swigFunction( "c-function gst_pad_create_stream_id gst_pad_create_stream_id a a s -- a", "FUNCTION: gst_pad_create_stream_id ( pad parent stream_id -- a )", "EXTERN: \"C\" void * gst_pad_create_stream_id( void * pad, void * parent, char * stream_id );", "	( pad parent stream_id -- )" );
	swigFunction( "c-function gst_pad_create_stream_id_printf gst_pad_create_stream_id_printf a a s ... -- a", "FUNCTION: gst_pad_create_stream_id_printf ( pad parent stream_id  -- a )", "EXTERN: \"C\" void * gst_pad_create_stream_id_printf( void * pad, void * parent, char * stream_id, ...  );", "	( pad parent stream_id <noname> -- )" );
	swigFunction( "c-function gst_pad_create_stream_id_printf_valist gst_pad_create_stream_id_printf_valist a a s a -- a", "FUNCTION: gst_pad_create_stream_id_printf_valist ( pad parent stream_id var_args -- a )", "EXTERN: \"C\" void * gst_pad_create_stream_id_printf_valist( void * pad, void * parent, char * stream_id, void * var_args );", "	( pad parent stream_id var_args -- )" );
	swigFunction( "c-function gst_pad_get_stream_id gst_pad_get_stream_id a -- a", "FUNCTION: gst_pad_get_stream_id ( pad -- a )", "EXTERN: \"C\" void * gst_pad_get_stream_id( void * pad );", "	( pad -- )" );
	swigFunction( "c-function gst_pad_get_stream gst_pad_get_stream a -- a", "FUNCTION: gst_pad_get_stream ( pad -- a )", "EXTERN: \"C\" void * gst_pad_get_stream( void * pad );", "	( pad -- )" );
	swigFunction( "c-function gst_bin_add_many gst_bin_add_many a a ... -- void", "FUNCTION: gst_bin_add_many ( bin element_1  -- void )", "EXTERN: \"C\" void gst_bin_add_many( void * bin, void * element_1, ...  );", "	( bin element_1 <noname> -- )" );
	swigFunction( "c-function gst_bin_remove_many gst_bin_remove_many a a ... -- void", "FUNCTION: gst_bin_remove_many ( bin element_1  -- void )", "EXTERN: \"C\" void gst_bin_remove_many( void * bin, void * element_1, ...  );", "	( bin element_1 <noname> -- )" );
	swigFunction( "c-function gst_bin_find_unlinked_pad gst_bin_find_unlinked_pad a n -- a", "FUNCTION: gst_bin_find_unlinked_pad ( bin direction -- a )", "EXTERN: \"C\" void * gst_bin_find_unlinked_pad( void * bin, int direction );", "	( bin direction -- )" );
	swigFunction( "c-function gst_bin_sync_children_states gst_bin_sync_children_states a -- n", "FUNCTION: gst_bin_sync_children_states ( bin -- n )", "EXTERN: \"C\" int gst_bin_sync_children_states( void * bin );", "	( bin -- )" );
	swigFunction( "c-function gst_parse_bin_from_description gst_parse_bin_from_description s n a -- a", "FUNCTION: gst_parse_bin_from_description ( bin_description ghost_unlinked_pads err -- a )", "EXTERN: \"C\" void * gst_parse_bin_from_description( char * bin_description, int ghost_unlinked_pads, void * err );", "	( bin_description ghost_unlinked_pads err -- )" );
	swigFunction( "c-function gst_parse_bin_from_description_full gst_parse_bin_from_description_full s n a n a -- a", "FUNCTION: gst_parse_bin_from_description_full ( bin_description ghost_unlinked_pads context flags err -- a )", "EXTERN: \"C\" void * gst_parse_bin_from_description_full( char * bin_description, int ghost_unlinked_pads, void * context, int flags, void * err );", "	( bin_description ghost_unlinked_pads context flags err -- )" );
	swigFunction( "c-function gst_util_get_timestamp gst_util_get_timestamp  -- ud", "FUNCTION: gst_util_get_timestamp (  -- ud )", "EXTERN: \"C\" long long gst_util_get_timestamp(  );", "	( -- )" );
	swigFunction( "c-function gst_util_array_binary_search gst_util_array_binary_search a u u a n a a -- a", "FUNCTION: gst_util_array_binary_search ( array num_elements element_size search_func mode search_data user_data -- a )", "EXTERN: \"C\" void * gst_util_array_binary_search( void * array, int num_elements, int element_size, void * search_func, int mode, void * search_data, void * user_data );", "	( array num_elements element_size search_func mode search_data user_data -- )" );
	swigFunction( "c-function gst_util_greatest_common_divisor gst_util_greatest_common_divisor n n -- n", "FUNCTION: gst_util_greatest_common_divisor ( a b -- n )", "EXTERN: \"C\" int gst_util_greatest_common_divisor( int a, int b );", "	( a b -- )" );
	swigFunction( "c-function gst_util_greatest_common_divisor_int64 gst_util_greatest_common_divisor_int64 d d -- d", "FUNCTION: gst_util_greatest_common_divisor_int64 ( a b -- d )", "EXTERN: \"C\" long long gst_util_greatest_common_divisor_int64( long long a, long long b );", "	( a b -- )" );
	swigFunction( "c-function gst_util_fraction_to_double gst_util_fraction_to_double n n a -- void", "FUNCTION: gst_util_fraction_to_double ( src_n src_d dest -- void )", "EXTERN: \"C\" void gst_util_fraction_to_double( int src_n, int src_d, void * dest );", "	( src_n src_d dest -- )" );
	swigFunction( "c-function gst_util_double_to_fraction gst_util_double_to_fraction r a a -- void", "FUNCTION: gst_util_double_to_fraction ( src dest_n dest_d -- void )", "EXTERN: \"C\" void gst_util_double_to_fraction( double src, void * dest_n, void * dest_d );", "	( src dest_n dest_d -- )" );
	swigFunction( "c-function gst_util_fraction_multiply gst_util_fraction_multiply n n n n a a -- n", "FUNCTION: gst_util_fraction_multiply ( a_n a_d b_n b_d res_n res_d -- n )", "EXTERN: \"C\" int gst_util_fraction_multiply( int a_n, int a_d, int b_n, int b_d, void * res_n, void * res_d );", "	( a_n a_d b_n b_d res_n res_d -- )" );
	swigFunction( "c-function gst_util_fraction_add gst_util_fraction_add n n n n a a -- n", "FUNCTION: gst_util_fraction_add ( a_n a_d b_n b_d res_n res_d -- n )", "EXTERN: \"C\" int gst_util_fraction_add( int a_n, int a_d, int b_n, int b_d, void * res_n, void * res_d );", "	( a_n a_d b_n b_d res_n res_d -- )" );
	swigFunction( "c-function gst_util_fraction_compare gst_util_fraction_compare n n n n -- n", "FUNCTION: gst_util_fraction_compare ( a_n a_d b_n b_d -- n )", "EXTERN: \"C\" int gst_util_fraction_compare( int a_n, int a_d, int b_n, int b_d );", "	( a_n a_d b_n b_d -- )" );
	swigFunction( "c-function gst_calculate_linear_regression gst_calculate_linear_regression a a u a a a a a -- n", "FUNCTION: gst_calculate_linear_regression ( xy temp n m_num m_denom b xbase r_squared -- n )", "EXTERN: \"C\" int gst_calculate_linear_regression( void * xy, void * temp, int n, void * m_num, void * m_denom, void * b, void * xbase, void * r_squared );", "	( xy temp n m_num m_denom b xbase r_squared -- )" );
	swigFunction( "c-function gst_int_range_get_type gst_int_range_get_type  -- u", "FUNCTION: gst_int_range_get_type (  -- u )", "EXTERN: \"C\" int gst_int_range_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_int64_range_get_type gst_int64_range_get_type  -- u", "FUNCTION: gst_int64_range_get_type (  -- u )", "EXTERN: \"C\" int gst_int64_range_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_double_range_get_type gst_double_range_get_type  -- u", "FUNCTION: gst_double_range_get_type (  -- u )", "EXTERN: \"C\" int gst_double_range_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_fraction_range_get_type gst_fraction_range_get_type  -- u", "FUNCTION: gst_fraction_range_get_type (  -- u )", "EXTERN: \"C\" int gst_fraction_range_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_fraction_get_type gst_fraction_get_type  -- u", "FUNCTION: gst_fraction_get_type (  -- u )", "EXTERN: \"C\" int gst_fraction_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_value_list_get_type gst_value_list_get_type  -- u", "FUNCTION: gst_value_list_get_type (  -- u )", "EXTERN: \"C\" int gst_value_list_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_value_array_get_type gst_value_array_get_type  -- u", "FUNCTION: gst_value_array_get_type (  -- u )", "EXTERN: \"C\" int gst_value_array_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_bitmask_get_type gst_bitmask_get_type  -- u", "FUNCTION: gst_bitmask_get_type (  -- u )", "EXTERN: \"C\" int gst_bitmask_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_flagset_get_type gst_flagset_get_type  -- u", "FUNCTION: gst_flagset_get_type (  -- u )", "EXTERN: \"C\" int gst_flagset_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_g_thread_get_type gst_g_thread_get_type  -- u", "FUNCTION: gst_g_thread_get_type (  -- u )", "EXTERN: \"C\" int gst_g_thread_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_value_register gst_value_register a -- void", "FUNCTION: gst_value_register ( table -- void )", "EXTERN: \"C\" void gst_value_register( void * table );", "	( table -- )" );
	swigFunction( "c-function gst_value_init_and_copy gst_value_init_and_copy a a -- void", "FUNCTION: gst_value_init_and_copy ( dest src -- void )", "EXTERN: \"C\" void gst_value_init_and_copy( void * dest, void * src );", "	( dest src -- )" );
	swigFunction( "c-function gst_value_serialize gst_value_serialize a -- a", "FUNCTION: gst_value_serialize ( value -- a )", "EXTERN: \"C\" void * gst_value_serialize( void * value );", "	( value -- )" );
	swigFunction( "c-function gst_value_deserialize gst_value_deserialize a s -- n", "FUNCTION: gst_value_deserialize ( dest src -- n )", "EXTERN: \"C\" int gst_value_deserialize( void * dest, char * src );", "	( dest src -- )" );
	swigFunction( "c-function gst_value_list_append_value gst_value_list_append_value a a -- void", "FUNCTION: gst_value_list_append_value ( value append_value -- void )", "EXTERN: \"C\" void gst_value_list_append_value( void * value, void * append_value );", "	( value append_value -- )" );
	swigFunction( "c-function gst_value_list_append_and_take_value gst_value_list_append_and_take_value a a -- void", "FUNCTION: gst_value_list_append_and_take_value ( value append_value -- void )", "EXTERN: \"C\" void gst_value_list_append_and_take_value( void * value, void * append_value );", "	( value append_value -- )" );
	swigFunction( "c-function gst_value_list_prepend_value gst_value_list_prepend_value a a -- void", "FUNCTION: gst_value_list_prepend_value ( value prepend_value -- void )", "EXTERN: \"C\" void gst_value_list_prepend_value( void * value, void * prepend_value );", "	( value prepend_value -- )" );
	swigFunction( "c-function gst_value_list_concat gst_value_list_concat a a a -- void", "FUNCTION: gst_value_list_concat ( dest value1 value2 -- void )", "EXTERN: \"C\" void gst_value_list_concat( void * dest, void * value1, void * value2 );", "	( dest value1 value2 -- )" );
	swigFunction( "c-function gst_value_list_merge gst_value_list_merge a a a -- void", "FUNCTION: gst_value_list_merge ( dest value1 value2 -- void )", "EXTERN: \"C\" void gst_value_list_merge( void * dest, void * value1, void * value2 );", "	( dest value1 value2 -- )" );
	swigFunction( "c-function gst_value_list_get_size gst_value_list_get_size a -- u", "FUNCTION: gst_value_list_get_size ( value -- u )", "EXTERN: \"C\" int gst_value_list_get_size( void * value );", "	( value -- )" );
	swigFunction( "c-function gst_value_list_get_value gst_value_list_get_value a u -- a", "FUNCTION: gst_value_list_get_value ( value index -- a )", "EXTERN: \"C\" void * gst_value_list_get_value( void * value, int index );", "	( value index -- )" );
	swigFunction( "c-function gst_value_array_append_value gst_value_array_append_value a a -- void", "FUNCTION: gst_value_array_append_value ( value append_value -- void )", "EXTERN: \"C\" void gst_value_array_append_value( void * value, void * append_value );", "	( value append_value -- )" );
	swigFunction( "c-function gst_value_array_append_and_take_value gst_value_array_append_and_take_value a a -- void", "FUNCTION: gst_value_array_append_and_take_value ( value append_value -- void )", "EXTERN: \"C\" void gst_value_array_append_and_take_value( void * value, void * append_value );", "	( value append_value -- )" );
	swigFunction( "c-function gst_value_array_prepend_value gst_value_array_prepend_value a a -- void", "FUNCTION: gst_value_array_prepend_value ( value prepend_value -- void )", "EXTERN: \"C\" void gst_value_array_prepend_value( void * value, void * prepend_value );", "	( value prepend_value -- )" );
	swigFunction( "c-function gst_value_array_get_size gst_value_array_get_size a -- u", "FUNCTION: gst_value_array_get_size ( value -- u )", "EXTERN: \"C\" int gst_value_array_get_size( void * value );", "	( value -- )" );
	swigFunction( "c-function gst_value_array_get_value gst_value_array_get_value a u -- a", "FUNCTION: gst_value_array_get_value ( value index -- a )", "EXTERN: \"C\" void * gst_value_array_get_value( void * value, int index );", "	( value index -- )" );
	swigFunction( "c-function gst_value_set_int_range gst_value_set_int_range a n n -- void", "FUNCTION: gst_value_set_int_range ( value start end -- void )", "EXTERN: \"C\" void gst_value_set_int_range( void * value, int start, int end );", "	( value start end -- )" );
	swigFunction( "c-function gst_value_set_int_range_step gst_value_set_int_range_step a n n n -- void", "FUNCTION: gst_value_set_int_range_step ( value start end step -- void )", "EXTERN: \"C\" void gst_value_set_int_range_step( void * value, int start, int end, int step );", "	( value start end step -- )" );
	swigFunction( "c-function gst_value_get_int_range_min gst_value_get_int_range_min a -- n", "FUNCTION: gst_value_get_int_range_min ( value -- n )", "EXTERN: \"C\" int gst_value_get_int_range_min( void * value );", "	( value -- )" );
	swigFunction( "c-function gst_value_get_int_range_max gst_value_get_int_range_max a -- n", "FUNCTION: gst_value_get_int_range_max ( value -- n )", "EXTERN: \"C\" int gst_value_get_int_range_max( void * value );", "	( value -- )" );
	swigFunction( "c-function gst_value_get_int_range_step gst_value_get_int_range_step a -- n", "FUNCTION: gst_value_get_int_range_step ( value -- n )", "EXTERN: \"C\" int gst_value_get_int_range_step( void * value );", "	( value -- )" );
	swigFunction( "c-function gst_value_set_int64_range gst_value_set_int64_range a d d -- void", "FUNCTION: gst_value_set_int64_range ( value start end -- void )", "EXTERN: \"C\" void gst_value_set_int64_range( void * value, long long start, long long end );", "	( value start end -- )" );
	swigFunction( "c-function gst_value_set_int64_range_step gst_value_set_int64_range_step a d d d -- void", "FUNCTION: gst_value_set_int64_range_step ( value start end step -- void )", "EXTERN: \"C\" void gst_value_set_int64_range_step( void * value, long long start, long long end, long long step );", "	( value start end step -- )" );
	swigFunction( "c-function gst_value_get_int64_range_min gst_value_get_int64_range_min a -- d", "FUNCTION: gst_value_get_int64_range_min ( value -- d )", "EXTERN: \"C\" long long gst_value_get_int64_range_min( void * value );", "	( value -- )" );
	swigFunction( "c-function gst_value_get_int64_range_max gst_value_get_int64_range_max a -- d", "FUNCTION: gst_value_get_int64_range_max ( value -- d )", "EXTERN: \"C\" long long gst_value_get_int64_range_max( void * value );", "	( value -- )" );
	swigFunction( "c-function gst_value_get_int64_range_step gst_value_get_int64_range_step a -- d", "FUNCTION: gst_value_get_int64_range_step ( value -- d )", "EXTERN: \"C\" long long gst_value_get_int64_range_step( void * value );", "	( value -- )" );
	swigFunction( "c-function gst_value_set_double_range gst_value_set_double_range a r r -- void", "FUNCTION: gst_value_set_double_range ( value start end -- void )", "EXTERN: \"C\" void gst_value_set_double_range( void * value, double start, double end );", "	( value start end -- )" );
	swigFunction( "c-function gst_value_get_double_range_min gst_value_get_double_range_min a -- r", "FUNCTION: gst_value_get_double_range_min ( value -- r )", "EXTERN: \"C\" double gst_value_get_double_range_min( void * value );", "	( value -- )" );
	swigFunction( "c-function gst_value_get_double_range_max gst_value_get_double_range_max a -- r", "FUNCTION: gst_value_get_double_range_max ( value -- r )", "EXTERN: \"C\" double gst_value_get_double_range_max( void * value );", "	( value -- )" );
	swigFunction( "c-function gst_value_get_caps gst_value_get_caps a -- a", "FUNCTION: gst_value_get_caps ( value -- a )", "EXTERN: \"C\" void * gst_value_get_caps( void * value );", "	( value -- )" );
	swigFunction( "c-function gst_value_set_caps gst_value_set_caps a a -- void", "FUNCTION: gst_value_set_caps ( value caps -- void )", "EXTERN: \"C\" void gst_value_set_caps( void * value, void * caps );", "	( value caps -- )" );
	swigFunction( "c-function gst_value_get_structure gst_value_get_structure a -- a", "FUNCTION: gst_value_get_structure ( value -- a )", "EXTERN: \"C\" void * gst_value_get_structure( void * value );", "	( value -- )" );
	swigFunction( "c-function gst_value_set_structure gst_value_set_structure a a -- void", "FUNCTION: gst_value_set_structure ( value structure -- void )", "EXTERN: \"C\" void gst_value_set_structure( void * value, void * structure );", "	( value structure -- )" );
	swigFunction( "c-function gst_value_get_caps_features gst_value_get_caps_features a -- a", "FUNCTION: gst_value_get_caps_features ( value -- a )", "EXTERN: \"C\" void * gst_value_get_caps_features( void * value );", "	( value -- )" );
	swigFunction( "c-function gst_value_set_caps_features gst_value_set_caps_features a a -- void", "FUNCTION: gst_value_set_caps_features ( value features -- void )", "EXTERN: \"C\" void gst_value_set_caps_features( void * value, void * features );", "	( value features -- )" );
	swigFunction( "c-function gst_value_set_fraction gst_value_set_fraction a n n -- void", "FUNCTION: gst_value_set_fraction ( value numerator denominator -- void )", "EXTERN: \"C\" void gst_value_set_fraction( void * value, int numerator, int denominator );", "	( value numerator denominator -- )" );
	swigFunction( "c-function gst_value_get_fraction_numerator gst_value_get_fraction_numerator a -- n", "FUNCTION: gst_value_get_fraction_numerator ( value -- n )", "EXTERN: \"C\" int gst_value_get_fraction_numerator( void * value );", "	( value -- )" );
	swigFunction( "c-function gst_value_get_fraction_denominator gst_value_get_fraction_denominator a -- n", "FUNCTION: gst_value_get_fraction_denominator ( value -- n )", "EXTERN: \"C\" int gst_value_get_fraction_denominator( void * value );", "	( value -- )" );
	swigFunction( "c-function gst_value_fraction_multiply gst_value_fraction_multiply a a a -- n", "FUNCTION: gst_value_fraction_multiply ( product factor1 factor2 -- n )", "EXTERN: \"C\" int gst_value_fraction_multiply( void * product, void * factor1, void * factor2 );", "	( product factor1 factor2 -- )" );
	swigFunction( "c-function gst_value_fraction_subtract gst_value_fraction_subtract a a a -- n", "FUNCTION: gst_value_fraction_subtract ( dest minuend subtrahend -- n )", "EXTERN: \"C\" int gst_value_fraction_subtract( void * dest, void * minuend, void * subtrahend );", "	( dest minuend subtrahend -- )" );
	swigFunction( "c-function gst_value_set_fraction_range gst_value_set_fraction_range a a a -- void", "FUNCTION: gst_value_set_fraction_range ( value start end -- void )", "EXTERN: \"C\" void gst_value_set_fraction_range( void * value, void * start, void * end );", "	( value start end -- )" );
	swigFunction( "c-function gst_value_set_fraction_range_full gst_value_set_fraction_range_full a n n n n -- void", "FUNCTION: gst_value_set_fraction_range_full ( value numerator_start denominator_start numerator_end denominator_end -- void )", "EXTERN: \"C\" void gst_value_set_fraction_range_full( void * value, int numerator_start, int denominator_start, int numerator_end, int denominator_end );", "	( value numerator_start denominator_start numerator_end denominator_end -- )" );
	swigFunction( "c-function gst_value_get_fraction_range_min gst_value_get_fraction_range_min a -- a", "FUNCTION: gst_value_get_fraction_range_min ( value -- a )", "EXTERN: \"C\" void * gst_value_get_fraction_range_min( void * value );", "	( value -- )" );
	swigFunction( "c-function gst_value_get_fraction_range_max gst_value_get_fraction_range_max a -- a", "FUNCTION: gst_value_get_fraction_range_max ( value -- a )", "EXTERN: \"C\" void * gst_value_get_fraction_range_max( void * value );", "	( value -- )" );
	swigFunction( "c-function gst_value_get_bitmask gst_value_get_bitmask a -- ud", "FUNCTION: gst_value_get_bitmask ( value -- ud )", "EXTERN: \"C\" long long gst_value_get_bitmask( void * value );", "	( value -- )" );
	swigFunction( "c-function gst_value_set_bitmask gst_value_set_bitmask a ud -- void", "FUNCTION: gst_value_set_bitmask ( value bitmask -- void )", "EXTERN: \"C\" void gst_value_set_bitmask( void * value, long long bitmask );", "	( value bitmask -- )" );
	swigFunction( "c-function gst_value_set_flagset gst_value_set_flagset a u u -- void", "FUNCTION: gst_value_set_flagset ( value flags mask -- void )", "EXTERN: \"C\" void gst_value_set_flagset( void * value, int flags, int mask );", "	( value flags mask -- )" );
	swigFunction( "c-function gst_value_get_flagset_flags gst_value_get_flagset_flags a -- u", "FUNCTION: gst_value_get_flagset_flags ( value -- u )", "EXTERN: \"C\" int gst_value_get_flagset_flags( void * value );", "	( value -- )" );
	swigFunction( "c-function gst_value_get_flagset_mask gst_value_get_flagset_mask a -- u", "FUNCTION: gst_value_get_flagset_mask ( value -- u )", "EXTERN: \"C\" int gst_value_get_flagset_mask( void * value );", "	( value -- )" );
	swigFunction( "c-function gst_value_compare gst_value_compare a a -- n", "FUNCTION: gst_value_compare ( value1 value2 -- n )", "EXTERN: \"C\" int gst_value_compare( void * value1, void * value2 );", "	( value1 value2 -- )" );
	swigFunction( "c-function gst_value_can_compare gst_value_can_compare a a -- n", "FUNCTION: gst_value_can_compare ( value1 value2 -- n )", "EXTERN: \"C\" int gst_value_can_compare( void * value1, void * value2 );", "	( value1 value2 -- )" );
	swigFunction( "c-function gst_value_is_subset gst_value_is_subset a a -- n", "FUNCTION: gst_value_is_subset ( value1 value2 -- n )", "EXTERN: \"C\" int gst_value_is_subset( void * value1, void * value2 );", "	( value1 value2 -- )" );
	swigFunction( "c-function gst_value_union gst_value_union a a a -- n", "FUNCTION: gst_value_union ( dest value1 value2 -- n )", "EXTERN: \"C\" int gst_value_union( void * dest, void * value1, void * value2 );", "	( dest value1 value2 -- )" );
	swigFunction( "c-function gst_value_can_union gst_value_can_union a a -- n", "FUNCTION: gst_value_can_union ( value1 value2 -- n )", "EXTERN: \"C\" int gst_value_can_union( void * value1, void * value2 );", "	( value1 value2 -- )" );
	swigFunction( "c-function gst_value_intersect gst_value_intersect a a a -- n", "FUNCTION: gst_value_intersect ( dest value1 value2 -- n )", "EXTERN: \"C\" int gst_value_intersect( void * dest, void * value1, void * value2 );", "	( dest value1 value2 -- )" );
	swigFunction( "c-function gst_value_can_intersect gst_value_can_intersect a a -- n", "FUNCTION: gst_value_can_intersect ( value1 value2 -- n )", "EXTERN: \"C\" int gst_value_can_intersect( void * value1, void * value2 );", "	( value1 value2 -- )" );
	swigFunction( "c-function gst_value_subtract gst_value_subtract a a a -- n", "FUNCTION: gst_value_subtract ( dest minuend subtrahend -- n )", "EXTERN: \"C\" int gst_value_subtract( void * dest, void * minuend, void * subtrahend );", "	( dest minuend subtrahend -- )" );
	swigFunction( "c-function gst_value_can_subtract gst_value_can_subtract a a -- n", "FUNCTION: gst_value_can_subtract ( minuend subtrahend -- n )", "EXTERN: \"C\" int gst_value_can_subtract( void * minuend, void * subtrahend );", "	( minuend subtrahend -- )" );
	swigFunction( "c-function gst_value_is_fixed gst_value_is_fixed a -- n", "FUNCTION: gst_value_is_fixed ( value -- n )", "EXTERN: \"C\" int gst_value_is_fixed( void * value );", "	( value -- )" );
	swigFunction( "c-function gst_value_fixate gst_value_fixate a a -- n", "FUNCTION: gst_value_fixate ( dest src -- n )", "EXTERN: \"C\" int gst_value_fixate( void * dest, void * src );", "	( dest src -- )" );
	swigFunction( "c-function gst_flagset_register gst_flagset_register u -- u", "FUNCTION: gst_flagset_register ( flags_type -- u )", "EXTERN: \"C\" int gst_flagset_register( int flags_type );", "	( flags_type -- )" );
	swigFunction( "c-function gst_parse_error_quark gst_parse_error_quark  -- n", "FUNCTION: gst_parse_error_quark (  -- n )", "EXTERN: \"C\" n gst_parse_error_quark(  );", "	( -- )" );
	swigFunction( "c-function gst_parse_context_get_type gst_parse_context_get_type  -- u", "FUNCTION: gst_parse_context_get_type (  -- u )", "EXTERN: \"C\" int gst_parse_context_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_parse_context_new gst_parse_context_new  -- a", "FUNCTION: gst_parse_context_new (  -- a )", "EXTERN: \"C\" void * gst_parse_context_new(  );", "	( -- )" );
	swigFunction( "c-function gst_parse_context_get_missing_elements gst_parse_context_get_missing_elements a -- a", "FUNCTION: gst_parse_context_get_missing_elements ( context -- a )", "EXTERN: \"C\" void * gst_parse_context_get_missing_elements( void * context );", "	( context -- )" );
	swigFunction( "c-function gst_parse_context_free gst_parse_context_free a -- void", "FUNCTION: gst_parse_context_free ( context -- void )", "EXTERN: \"C\" void gst_parse_context_free( void * context );", "	( context -- )" );
	swigFunction( "c-function gst_parse_context_copy gst_parse_context_copy a -- a", "FUNCTION: gst_parse_context_copy ( context -- a )", "EXTERN: \"C\" void * gst_parse_context_copy( void * context );", "	( context -- )" );
	swigFunction( "c-function gst_parse_launch gst_parse_launch s a -- a", "FUNCTION: gst_parse_launch ( pipeline_description error -- a )", "EXTERN: \"C\" void * gst_parse_launch( char * pipeline_description, void * error );", "	( pipeline_description error -- )" );
	swigFunction( "c-function gst_parse_launchv gst_parse_launchv a a -- a", "FUNCTION: gst_parse_launchv ( argv error -- a )", "EXTERN: \"C\" void * gst_parse_launchv( void * argv, void * error );", "	( argv error -- )" );
	swigFunction( "c-function gst_parse_launch_full gst_parse_launch_full s a n a -- a", "FUNCTION: gst_parse_launch_full ( pipeline_description context flags error -- a )", "EXTERN: \"C\" void * gst_parse_launch_full( char * pipeline_description, void * context, int flags, void * error );", "	( pipeline_description context flags error -- )" );
	swigFunction( "c-function gst_parse_launchv_full gst_parse_launchv_full a a n a -- a", "FUNCTION: gst_parse_launchv_full ( argv context flags error -- a )", "EXTERN: \"C\" void * gst_parse_launchv_full( void * argv, void * context, int flags, void * error );", "	( argv context flags error -- )" );
	swigFunction( "c-function gst_gl_api_to_string gst_gl_api_to_string n -- a", "FUNCTION: gst_gl_api_to_string ( api -- a )", "EXTERN: \"C\" void * gst_gl_api_to_string( int api );", "	( api -- )" );
	swigFunction( "c-function gst_gl_api_from_string gst_gl_api_from_string s -- n", "FUNCTION: gst_gl_api_from_string ( api_s -- n )", "EXTERN: \"C\" int gst_gl_api_from_string( char * api_s );", "	( api_s -- )" );
	swigFunction( "c-function gst_gl_platform_to_string gst_gl_platform_to_string n -- a", "FUNCTION: gst_gl_platform_to_string ( platform -- a )", "EXTERN: \"C\" void * gst_gl_platform_to_string( int platform );", "	( platform -- )" );
	swigFunction( "c-function gst_gl_platform_from_string gst_gl_platform_from_string s -- n", "FUNCTION: gst_gl_platform_from_string ( platform_s -- n )", "EXTERN: \"C\" int gst_gl_platform_from_string( char * platform_s );", "	( platform_s -- )" );
	swigFunction( "c-function gst_gl_display_get_type gst_gl_display_get_type  -- u", "FUNCTION: gst_gl_display_get_type (  -- u )", "EXTERN: \"C\" int gst_gl_display_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_gl_display_new gst_gl_display_new  -- a", "FUNCTION: gst_gl_display_new (  -- a )", "EXTERN: \"C\" void * gst_gl_display_new(  );", "	( -- )" );
	swigFunction( "c-function gst_gl_display_get_handle gst_gl_display_get_handle a -- u", "FUNCTION: gst_gl_display_get_handle ( display -- u )", "EXTERN: \"C\" long gst_gl_display_get_handle( void * display );", "	( display -- )" );
	swigFunction( "c-function gst_gl_display_get_handle_type gst_gl_display_get_handle_type a -- n", "FUNCTION: gst_gl_display_get_handle_type ( display -- n )", "EXTERN: \"C\" int gst_gl_display_get_handle_type( void * display );", "	( display -- )" );
	swigFunction( "c-function gst_gl_display_filter_gl_api gst_gl_display_filter_gl_api a n -- void", "FUNCTION: gst_gl_display_filter_gl_api ( display gl_api -- void )", "EXTERN: \"C\" void gst_gl_display_filter_gl_api( void * display, int gl_api );", "	( display gl_api -- )" );
	swigFunction( "c-function gst_gl_display_get_gl_api gst_gl_display_get_gl_api a -- n", "FUNCTION: gst_gl_display_get_gl_api ( display -- n )", "EXTERN: \"C\" int gst_gl_display_get_gl_api( void * display );", "	( display -- )" );
	swigFunction( "c-function gst_gl_display_get_gl_api_unlocked gst_gl_display_get_gl_api_unlocked a -- n", "FUNCTION: gst_gl_display_get_gl_api_unlocked ( display -- n )", "EXTERN: \"C\" int gst_gl_display_get_gl_api_unlocked( void * display );", "	( display -- )" );
	swigFunction( "c-function gst_context_set_gl_display gst_context_set_gl_display a a -- void", "FUNCTION: gst_context_set_gl_display ( context display -- void )", "EXTERN: \"C\" void gst_context_set_gl_display( void * context, void * display );", "	( context display -- )" );
	swigFunction( "c-function gst_context_get_gl_display gst_context_get_gl_display a a -- n", "FUNCTION: gst_context_get_gl_display ( context display -- n )", "EXTERN: \"C\" int gst_context_get_gl_display( void * context, void * display );", "	( context display -- )" );
	swigFunction( "c-function gst_gl_display_create_context gst_gl_display_create_context a a a a -- n", "FUNCTION: gst_gl_display_create_context ( display other_context p_context error -- n )", "EXTERN: \"C\" int gst_gl_display_create_context( void * display, void * other_context, void * p_context, void * error );", "	( display other_context p_context error -- )" );
	swigFunction( "c-function gst_gl_display_get_gl_context_for_thread gst_gl_display_get_gl_context_for_thread a a -- a", "FUNCTION: gst_gl_display_get_gl_context_for_thread ( display thread -- a )", "EXTERN: \"C\" void * gst_gl_display_get_gl_context_for_thread( void * display, void * thread );", "	( display thread -- )" );
	swigFunction( "c-function gst_gl_display_add_context gst_gl_display_add_context a a -- n", "FUNCTION: gst_gl_display_add_context ( display context -- n )", "EXTERN: \"C\" int gst_gl_display_add_context( void * display, void * context );", "	( display context -- )" );
	swigFunction( "c-function gst_gl_display_create_window gst_gl_display_create_window a -- a", "FUNCTION: gst_gl_display_create_window ( display -- a )", "EXTERN: \"C\" void * gst_gl_display_create_window( void * display );", "	( display -- )" );
	swigFunction( "c-function gst_gl_display_remove_window gst_gl_display_remove_window a a -- n", "FUNCTION: gst_gl_display_remove_window ( display window -- n )", "EXTERN: \"C\" int gst_gl_display_remove_window( void * display, void * window );", "	( display window -- )" );
	swigFunction( "c-function gst_gl_display_find_window gst_gl_display_find_window a a a -- a", "FUNCTION: gst_gl_display_find_window ( display data compare_func -- a )", "EXTERN: \"C\" void * gst_gl_display_find_window( void * display, void * data, void * compare_func );", "	( display data compare_func -- )" );
	swigFunction( "c-function gst_gl_context_get_type gst_gl_context_get_type  -- u", "FUNCTION: gst_gl_context_get_type (  -- u )", "EXTERN: \"C\" int gst_gl_context_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_gl_context_error_quark gst_gl_context_error_quark  -- n", "FUNCTION: gst_gl_context_error_quark (  -- n )", "EXTERN: \"C\" n gst_gl_context_error_quark(  );", "	( -- )" );
	swigFunction( "c-function gst_gl_context_new gst_gl_context_new a -- a", "FUNCTION: gst_gl_context_new ( display -- a )", "EXTERN: \"C\" void * gst_gl_context_new( void * display );", "	( display -- )" );
	swigFunction( "c-function gst_gl_context_new_wrapped gst_gl_context_new_wrapped a u n n -- a", "FUNCTION: gst_gl_context_new_wrapped ( display handle context_type available_apis -- a )", "EXTERN: \"C\" void * gst_gl_context_new_wrapped( void * display, long handle, int context_type, int available_apis );", "	( display handle context_type available_apis -- )" );
	swigFunction( "c-function gst_gl_context_activate gst_gl_context_activate a n -- n", "FUNCTION: gst_gl_context_activate ( context activate -- n )", "EXTERN: \"C\" int gst_gl_context_activate( void * context, int activate );", "	( context activate -- )" );
	swigFunction( "c-function gst_gl_context_get_thread gst_gl_context_get_thread a -- a", "FUNCTION: gst_gl_context_get_thread ( context -- a )", "EXTERN: \"C\" void * gst_gl_context_get_thread( void * context );", "	( context -- )" );
	swigFunction( "c-function gst_gl_context_get_current gst_gl_context_get_current  -- a", "FUNCTION: gst_gl_context_get_current (  -- a )", "EXTERN: \"C\" void * gst_gl_context_get_current(  );", "	( -- )" );
	swigFunction( "c-function gst_gl_context_get_display gst_gl_context_get_display a -- a", "FUNCTION: gst_gl_context_get_display ( context -- a )", "EXTERN: \"C\" void * gst_gl_context_get_display( void * context );", "	( context -- )" );
	swigFunction( "c-function gst_gl_context_get_proc_address gst_gl_context_get_proc_address a s -- a", "FUNCTION: gst_gl_context_get_proc_address ( context name -- a )", "EXTERN: \"C\" void * gst_gl_context_get_proc_address( void * context, char * name );", "	( context name -- )" );
	swigFunction( "c-function gst_gl_context_get_gl_platform gst_gl_context_get_gl_platform a -- n", "FUNCTION: gst_gl_context_get_gl_platform ( context -- n )", "EXTERN: \"C\" int gst_gl_context_get_gl_platform( void * context );", "	( context -- )" );
	swigFunction( "c-function gst_gl_context_get_gl_api gst_gl_context_get_gl_api a -- n", "FUNCTION: gst_gl_context_get_gl_api ( context -- n )", "EXTERN: \"C\" int gst_gl_context_get_gl_api( void * context );", "	( context -- )" );
	swigFunction( "c-function gst_gl_context_get_gl_context gst_gl_context_get_gl_context a -- u", "FUNCTION: gst_gl_context_get_gl_context ( context -- u )", "EXTERN: \"C\" long gst_gl_context_get_gl_context( void * context );", "	( context -- )" );
	swigFunction( "c-function gst_gl_context_can_share gst_gl_context_can_share a a -- n", "FUNCTION: gst_gl_context_can_share ( context other_context -- n )", "EXTERN: \"C\" int gst_gl_context_can_share( void * context, void * other_context );", "	( context other_context -- )" );
	swigFunction( "c-function gst_gl_context_swap_buffers gst_gl_context_swap_buffers a -- void", "FUNCTION: gst_gl_context_swap_buffers ( context -- void )", "EXTERN: \"C\" void gst_gl_context_swap_buffers( void * context );", "	( context -- )" );
	swigFunction( "c-function gst_gl_context_create gst_gl_context_create a a a -- n", "FUNCTION: gst_gl_context_create ( context other_context error -- n )", "EXTERN: \"C\" int gst_gl_context_create( void * context, void * other_context, void * error );", "	( context other_context error -- )" );
	swigFunction( "c-function gst_gl_context_destroy gst_gl_context_destroy a -- void", "FUNCTION: gst_gl_context_destroy ( context -- void )", "EXTERN: \"C\" void gst_gl_context_destroy( void * context );", "	( context -- )" );
	swigFunction( "c-function gst_gl_context_default_get_proc_address gst_gl_context_default_get_proc_address n s -- a", "FUNCTION: gst_gl_context_default_get_proc_address ( gl_api name -- a )", "EXTERN: \"C\" void * gst_gl_context_default_get_proc_address( int gl_api, char * name );", "	( gl_api name -- )" );
	swigFunction( "c-function gst_gl_context_get_proc_address_with_platform gst_gl_context_get_proc_address_with_platform n n s -- a", "FUNCTION: gst_gl_context_get_proc_address_with_platform ( context_type gl_api name -- a )", "EXTERN: \"C\" void * gst_gl_context_get_proc_address_with_platform( int context_type, int gl_api, char * name );", "	( context_type gl_api name -- )" );
	swigFunction( "c-function gst_gl_context_set_window gst_gl_context_set_window a a -- n", "FUNCTION: gst_gl_context_set_window ( context window -- n )", "EXTERN: \"C\" int gst_gl_context_set_window( void * context, void * window );", "	( context window -- )" );
	swigFunction( "c-function gst_gl_context_get_window gst_gl_context_get_window a -- a", "FUNCTION: gst_gl_context_get_window ( context -- a )", "EXTERN: \"C\" void * gst_gl_context_get_window( void * context );", "	( context -- )" );
	swigFunction( "c-function gst_gl_context_get_gl_version gst_gl_context_get_gl_version a a a -- void", "FUNCTION: gst_gl_context_get_gl_version ( context maj min -- void )", "EXTERN: \"C\" void gst_gl_context_get_gl_version( void * context, void * maj, void * min );", "	( context maj min -- )" );
	swigFunction( "c-function gst_gl_context_check_gl_version gst_gl_context_check_gl_version a n n n -- n", "FUNCTION: gst_gl_context_check_gl_version ( context api maj min -- n )", "EXTERN: \"C\" int gst_gl_context_check_gl_version( void * context, int api, int maj, int min );", "	( context api maj min -- )" );
	swigFunction( "c-function gst_gl_context_check_feature gst_gl_context_check_feature a s -- n", "FUNCTION: gst_gl_context_check_feature ( context feature -- n )", "EXTERN: \"C\" int gst_gl_context_check_feature( void * context, char * feature );", "	( context feature -- )" );
	swigFunction( "c-function gst_gl_context_get_gl_platform_version gst_gl_context_get_gl_platform_version a a a -- void", "FUNCTION: gst_gl_context_get_gl_platform_version ( context major minor -- void )", "EXTERN: \"C\" void gst_gl_context_get_gl_platform_version( void * context, void * major, void * minor );", "	( context major minor -- )" );
	swigFunction( "c-function gst_gl_context_get_current_gl_context gst_gl_context_get_current_gl_context n -- u", "FUNCTION: gst_gl_context_get_current_gl_context ( context_type -- u )", "EXTERN: \"C\" long gst_gl_context_get_current_gl_context( int context_type );", "	( context_type -- )" );
	swigFunction( "c-function gst_gl_context_get_current_gl_api gst_gl_context_get_current_gl_api n a a -- n", "FUNCTION: gst_gl_context_get_current_gl_api ( platform major minor -- n )", "EXTERN: \"C\" int gst_gl_context_get_current_gl_api( int platform, void * major, void * minor );", "	( platform major minor -- )" );
	swigFunction( "c-function gst_gl_context_is_shared gst_gl_context_is_shared a -- n", "FUNCTION: gst_gl_context_is_shared ( context -- n )", "EXTERN: \"C\" int gst_gl_context_is_shared( void * context );", "	( context -- )" );
	swigFunction( "c-function gst_gl_context_set_shared_with gst_gl_context_set_shared_with a a -- void", "FUNCTION: gst_gl_context_set_shared_with ( context share -- void )", "EXTERN: \"C\" void gst_gl_context_set_shared_with( void * context, void * share );", "	( context share -- )" );
	swigFunction( "c-function gst_gl_context_fill_info gst_gl_context_fill_info a a -- n", "FUNCTION: gst_gl_context_fill_info ( context error -- n )", "EXTERN: \"C\" int gst_gl_context_fill_info( void * context, void * error );", "	( context error -- )" );
	swigFunction( "c-function gst_gl_context_thread_add gst_gl_context_thread_add a a a -- void", "FUNCTION: gst_gl_context_thread_add ( context func data -- void )", "EXTERN: \"C\" void gst_gl_context_thread_add( void * context, void * func, void * data );", "	( context func data -- )" );
	swigFunction( "c-function gst_gl_check_extension gst_gl_check_extension s s -- n", "FUNCTION: gst_gl_check_extension ( name ext -- n )", "EXTERN: \"C\" int gst_gl_check_extension( char * name, char * ext );", "	( name ext -- )" );
	swigFunction( "c-function gst_gl_ensure_element_data gst_gl_ensure_element_data a a a -- n", "FUNCTION: gst_gl_ensure_element_data ( element display_ptr other_context_ptr -- n )", "EXTERN: \"C\" int gst_gl_ensure_element_data( void * element, void * display_ptr, void * other_context_ptr );", "	( element display_ptr other_context_ptr -- )" );
	swigFunction( "c-function gst_gl_handle_set_context gst_gl_handle_set_context a a a a -- n", "FUNCTION: gst_gl_handle_set_context ( element context display other_context -- n )", "EXTERN: \"C\" int gst_gl_handle_set_context( void * element, void * context, void * display, void * other_context );", "	( element context display other_context -- )" );
	swigFunction( "c-function gst_gl_handle_context_query gst_gl_handle_context_query a a a a a -- n", "FUNCTION: gst_gl_handle_context_query ( element query display context other_context -- n )", "EXTERN: \"C\" int gst_gl_handle_context_query( void * element, void * query, void * display, void * context, void * other_context );", "	( element query display context other_context -- )" );
	swigFunction( "c-function gst_gl_query_local_gl_context gst_gl_query_local_gl_context a n a -- n", "FUNCTION: gst_gl_query_local_gl_context ( element direction context_ptr -- n )", "EXTERN: \"C\" int gst_gl_query_local_gl_context( void * element, int direction, void * context_ptr );", "	( element direction context_ptr -- )" );
	swigFunction( "c-function gst_gl_element_propagate_display_context gst_gl_element_propagate_display_context a a -- void", "FUNCTION: gst_gl_element_propagate_display_context ( element display -- void )", "EXTERN: \"C\" void gst_gl_element_propagate_display_context( void * element, void * display );", "	( element display -- )" );
	swigFunction( "c-function gst_gl_get_plane_data_size gst_gl_get_plane_data_size a a u -- u", "FUNCTION: gst_gl_get_plane_data_size ( info align plane -- u )", "EXTERN: \"C\" int gst_gl_get_plane_data_size( void * info, void * align, int plane );", "	( info align plane -- )" );
	swigFunction( "c-function gst_gl_get_plane_start gst_gl_get_plane_start a a u -- u", "FUNCTION: gst_gl_get_plane_start ( info valign plane -- u )", "EXTERN: \"C\" int gst_gl_get_plane_start( void * info, void * valign, int plane );", "	( info valign plane -- )" );
	swigFunction( "c-function gst_gl_value_set_texture_target_from_mask gst_gl_value_set_texture_target_from_mask a u -- n", "FUNCTION: gst_gl_value_set_texture_target_from_mask ( value target_mask -- n )", "EXTERN: \"C\" int gst_gl_value_set_texture_target_from_mask( void * value, int target_mask );", "	( value target_mask -- )" );
	swigFunction( "c-function gst_gl_value_set_texture_target gst_gl_value_set_texture_target a u -- n", "FUNCTION: gst_gl_value_set_texture_target ( value target -- n )", "EXTERN: \"C\" int gst_gl_value_set_texture_target( void * value, int target );", "	( value target -- )" );
	swigFunction( "c-function gst_gl_value_get_texture_target_mask gst_gl_value_get_texture_target_mask a -- u", "FUNCTION: gst_gl_value_get_texture_target_mask ( value -- u )", "EXTERN: \"C\" int gst_gl_value_get_texture_target_mask( void * value );", "	( value -- )" );
	swigFunction( "c-function gst_gl_window_get_type gst_gl_window_get_type  -- u", "FUNCTION: gst_gl_window_get_type (  -- u )", "EXTERN: \"C\" int gst_gl_window_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_gl_window_error_quark gst_gl_window_error_quark  -- n", "FUNCTION: gst_gl_window_error_quark (  -- n )", "EXTERN: \"C\" n gst_gl_window_error_quark(  );", "	( -- )" );
	swigFunction( "c-function gst_gl_window_new gst_gl_window_new a -- a", "FUNCTION: gst_gl_window_new ( display -- a )", "EXTERN: \"C\" void * gst_gl_window_new( void * display );", "	( display -- )" );
	swigFunction( "c-function gst_gl_window_set_draw_callback gst_gl_window_set_draw_callback a a a a -- void", "FUNCTION: gst_gl_window_set_draw_callback ( window callback data destroy_notify -- void )", "EXTERN: \"C\" void gst_gl_window_set_draw_callback( void * window, void * callback, void * data, void * destroy_notify );", "	( window callback data destroy_notify -- )" );
	swigFunction( "c-function gst_gl_window_set_resize_callback gst_gl_window_set_resize_callback a a a a -- void", "FUNCTION: gst_gl_window_set_resize_callback ( window callback data destroy_notify -- void )", "EXTERN: \"C\" void gst_gl_window_set_resize_callback( void * window, void * callback, void * data, void * destroy_notify );", "	( window callback data destroy_notify -- )" );
	swigFunction( "c-function gst_gl_window_set_close_callback gst_gl_window_set_close_callback a a a a -- void", "FUNCTION: gst_gl_window_set_close_callback ( window callback data destroy_notify -- void )", "EXTERN: \"C\" void gst_gl_window_set_close_callback( void * window, void * callback, void * data, void * destroy_notify );", "	( window callback data destroy_notify -- )" );
	swigFunction( "c-function gst_gl_window_set_window_handle gst_gl_window_set_window_handle a u -- void", "FUNCTION: gst_gl_window_set_window_handle ( window handle -- void )", "EXTERN: \"C\" void gst_gl_window_set_window_handle( void * window, long handle );", "	( window handle -- )" );
	swigFunction( "c-function gst_gl_window_get_window_handle gst_gl_window_get_window_handle a -- u", "FUNCTION: gst_gl_window_get_window_handle ( window -- u )", "EXTERN: \"C\" long gst_gl_window_get_window_handle( void * window );", "	( window -- )" );
	swigFunction( "c-function gst_gl_window_run gst_gl_window_run a -- void", "FUNCTION: gst_gl_window_run ( window -- void )", "EXTERN: \"C\" void gst_gl_window_run( void * window );", "	( window -- )" );
	swigFunction( "c-function gst_gl_window_quit gst_gl_window_quit a -- void", "FUNCTION: gst_gl_window_quit ( window -- void )", "EXTERN: \"C\" void gst_gl_window_quit( void * window );", "	( window -- )" );
	swigFunction( "c-function gst_gl_window_send_message gst_gl_window_send_message a a a -- void", "FUNCTION: gst_gl_window_send_message ( window callback data -- void )", "EXTERN: \"C\" void gst_gl_window_send_message( void * window, void * callback, void * data );", "	( window callback data -- )" );
	swigFunction( "c-function gst_gl_window_send_message_async gst_gl_window_send_message_async a a a a -- void", "FUNCTION: gst_gl_window_send_message_async ( window callback data destroy -- void )", "EXTERN: \"C\" void gst_gl_window_send_message_async( void * window, void * callback, void * data, void * destroy );", "	( window callback data destroy -- )" );
	swigFunction( "c-function gst_gl_window_handle_events gst_gl_window_handle_events a n -- void", "FUNCTION: gst_gl_window_handle_events ( window handle_events -- void )", "EXTERN: \"C\" void gst_gl_window_handle_events( void * window, int handle_events );", "	( window handle_events -- )" );
	swigFunction( "c-function gst_gl_window_send_key_event gst_gl_window_send_key_event a s s -- void", "FUNCTION: gst_gl_window_send_key_event ( window event_type key_str -- void )", "EXTERN: \"C\" void gst_gl_window_send_key_event( void * window, char * event_type, char * key_str );", "	( window event_type key_str -- )" );
	swigFunction( "c-function gst_gl_window_send_mouse_event gst_gl_window_send_mouse_event a s n r r -- void", "FUNCTION: gst_gl_window_send_mouse_event ( window event_type button posx posy -- void )", "EXTERN: \"C\" void gst_gl_window_send_mouse_event( void * window, char * event_type, int button, double posx, double posy );", "	( window event_type button posx posy -- )" );
	swigFunction( "c-function gst_gl_window_queue_resize gst_gl_window_queue_resize a -- void", "FUNCTION: gst_gl_window_queue_resize ( window -- void )", "EXTERN: \"C\" void gst_gl_window_queue_resize( void * window );", "	( window -- )" );
	swigFunction( "c-function gst_gl_window_draw gst_gl_window_draw a -- void", "FUNCTION: gst_gl_window_draw ( window -- void )", "EXTERN: \"C\" void gst_gl_window_draw( void * window );", "	( window -- )" );
	swigFunction( "c-function gst_gl_window_show gst_gl_window_show a -- void", "FUNCTION: gst_gl_window_show ( window -- void )", "EXTERN: \"C\" void gst_gl_window_show( void * window );", "	( window -- )" );
	swigFunction( "c-function gst_gl_window_set_preferred_size gst_gl_window_set_preferred_size a n n -- void", "FUNCTION: gst_gl_window_set_preferred_size ( window width height -- void )", "EXTERN: \"C\" void gst_gl_window_set_preferred_size( void * window, int width, int height );", "	( window width height -- )" );
	swigFunction( "c-function gst_gl_window_get_surface_dimensions gst_gl_window_get_surface_dimensions a a a -- void", "FUNCTION: gst_gl_window_get_surface_dimensions ( window width height -- void )", "EXTERN: \"C\" void gst_gl_window_get_surface_dimensions( void * window, void * width, void * height );", "	( window width height -- )" );
	swigFunction( "c-function gst_gl_window_set_render_rectangle gst_gl_window_set_render_rectangle a n n n n -- n", "FUNCTION: gst_gl_window_set_render_rectangle ( window x y width height -- n )", "EXTERN: \"C\" int gst_gl_window_set_render_rectangle( void * window, int x, int y, int width, int height );", "	( window x y width height -- )" );
	swigFunction( "c-function gst_gl_window_resize gst_gl_window_resize a u u -- void", "FUNCTION: gst_gl_window_resize ( window width height -- void )", "EXTERN: \"C\" void gst_gl_window_resize( void * window, int width, int height );", "	( window width height -- )" );
	swigFunction( "c-function gst_gl_window_get_context gst_gl_window_get_context a -- a", "FUNCTION: gst_gl_window_get_context ( window -- a )", "EXTERN: \"C\" void * gst_gl_window_get_context( void * window );", "	( window -- )" );
	swigFunction( "c-function gst_gl_window_get_display gst_gl_window_get_display a -- u", "FUNCTION: gst_gl_window_get_display ( window -- u )", "EXTERN: \"C\" long gst_gl_window_get_display( void * window );", "	( window -- )" );
	swigFunction( "c-function gst_gl_shader_get_type gst_gl_shader_get_type  -- u", "FUNCTION: gst_gl_shader_get_type (  -- u )", "EXTERN: \"C\" int gst_gl_shader_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_gl_shader_new gst_gl_shader_new a -- a", "FUNCTION: gst_gl_shader_new ( context -- a )", "EXTERN: \"C\" void * gst_gl_shader_new( void * context );", "	( context -- )" );
	swigFunction( "c-function gst_gl_shader_new_with_stages gst_gl_shader_new_with_stages a a ... -- a", "FUNCTION: gst_gl_shader_new_with_stages ( context error  -- a )", "EXTERN: \"C\" void * gst_gl_shader_new_with_stages( void * context, void * error, ...  );", "	( context error <noname> -- )" );
	swigFunction( "c-function gst_gl_shader_new_link_with_stages gst_gl_shader_new_link_with_stages a a ... -- a", "FUNCTION: gst_gl_shader_new_link_with_stages ( context error  -- a )", "EXTERN: \"C\" void * gst_gl_shader_new_link_with_stages( void * context, void * error, ...  );", "	( context error <noname> -- )" );
	swigFunction( "c-function gst_gl_shader_new_default gst_gl_shader_new_default a a -- a", "FUNCTION: gst_gl_shader_new_default ( context error -- a )", "EXTERN: \"C\" void * gst_gl_shader_new_default( void * context, void * error );", "	( context error -- )" );
	swigFunction( "c-function gst_gl_shader_attach gst_gl_shader_attach a a -- n", "FUNCTION: gst_gl_shader_attach ( shader stage -- n )", "EXTERN: \"C\" int gst_gl_shader_attach( void * shader, void * stage );", "	( shader stage -- )" );
	swigFunction( "c-function gst_gl_shader_attach_unlocked gst_gl_shader_attach_unlocked a a -- n", "FUNCTION: gst_gl_shader_attach_unlocked ( shader stage -- n )", "EXTERN: \"C\" int gst_gl_shader_attach_unlocked( void * shader, void * stage );", "	( shader stage -- )" );
	swigFunction( "c-function gst_gl_shader_detach gst_gl_shader_detach a a -- void", "FUNCTION: gst_gl_shader_detach ( shader stage -- void )", "EXTERN: \"C\" void gst_gl_shader_detach( void * shader, void * stage );", "	( shader stage -- )" );
	swigFunction( "c-function gst_gl_shader_detach_unlocked gst_gl_shader_detach_unlocked a a -- void", "FUNCTION: gst_gl_shader_detach_unlocked ( shader stage -- void )", "EXTERN: \"C\" void gst_gl_shader_detach_unlocked( void * shader, void * stage );", "	( shader stage -- )" );
	swigFunction( "c-function gst_gl_shader_compile_attach_stage gst_gl_shader_compile_attach_stage a a a -- n", "FUNCTION: gst_gl_shader_compile_attach_stage ( shader stage error -- n )", "EXTERN: \"C\" int gst_gl_shader_compile_attach_stage( void * shader, void * stage, void * error );", "	( shader stage error -- )" );
	swigFunction( "c-function gst_gl_shader_link gst_gl_shader_link a a -- n", "FUNCTION: gst_gl_shader_link ( shader error -- n )", "EXTERN: \"C\" int gst_gl_shader_link( void * shader, void * error );", "	( shader error -- )" );
	swigFunction( "c-function gst_gl_shader_is_linked gst_gl_shader_is_linked a -- n", "FUNCTION: gst_gl_shader_is_linked ( shader -- n )", "EXTERN: \"C\" int gst_gl_shader_is_linked( void * shader );", "	( shader -- )" );
	swigFunction( "c-function gst_gl_shader_get_program_handle gst_gl_shader_get_program_handle a -- n", "FUNCTION: gst_gl_shader_get_program_handle ( shader -- n )", "EXTERN: \"C\" int gst_gl_shader_get_program_handle( void * shader );", "	( shader -- )" );
	swigFunction( "c-function gst_gl_shader_release gst_gl_shader_release a -- void", "FUNCTION: gst_gl_shader_release ( shader -- void )", "EXTERN: \"C\" void gst_gl_shader_release( void * shader );", "	( shader -- )" );
	swigFunction( "c-function gst_gl_shader_release_unlocked gst_gl_shader_release_unlocked a -- void", "FUNCTION: gst_gl_shader_release_unlocked ( shader -- void )", "EXTERN: \"C\" void gst_gl_shader_release_unlocked( void * shader );", "	( shader -- )" );
	swigFunction( "c-function gst_gl_shader_use gst_gl_shader_use a -- void", "FUNCTION: gst_gl_shader_use ( shader -- void )", "EXTERN: \"C\" void gst_gl_shader_use( void * shader );", "	( shader -- )" );
	swigFunction( "c-function gst_gl_context_clear_shader gst_gl_context_clear_shader a -- void", "FUNCTION: gst_gl_context_clear_shader ( context -- void )", "EXTERN: \"C\" void gst_gl_context_clear_shader( void * context );", "	( context -- )" );
	swigFunction( "c-function gst_gl_shader_set_uniform_1i gst_gl_shader_set_uniform_1i a s n -- void", "FUNCTION: gst_gl_shader_set_uniform_1i ( shader name value -- void )", "EXTERN: \"C\" void gst_gl_shader_set_uniform_1i( void * shader, char * name, int value );", "	( shader name value -- )" );
	swigFunction( "c-function gst_gl_shader_set_uniform_1iv gst_gl_shader_set_uniform_1iv a s u a -- void", "FUNCTION: gst_gl_shader_set_uniform_1iv ( shader name count value -- void )", "EXTERN: \"C\" void gst_gl_shader_set_uniform_1iv( void * shader, char * name, int count, void * value );", "	( shader name count value -- )" );
	swigFunction( "c-function gst_gl_shader_set_uniform_1f gst_gl_shader_set_uniform_1f a s r -- void", "FUNCTION: gst_gl_shader_set_uniform_1f ( shader name value -- void )", "EXTERN: \"C\" void gst_gl_shader_set_uniform_1f( void * shader, char * name, float value );", "	( shader name value -- )" );
	swigFunction( "c-function gst_gl_shader_set_uniform_1fv gst_gl_shader_set_uniform_1fv a s u a -- void", "FUNCTION: gst_gl_shader_set_uniform_1fv ( shader name count value -- void )", "EXTERN: \"C\" void gst_gl_shader_set_uniform_1fv( void * shader, char * name, int count, void * value );", "	( shader name count value -- )" );
	swigFunction( "c-function gst_gl_shader_set_uniform_2i gst_gl_shader_set_uniform_2i a s n n -- void", "FUNCTION: gst_gl_shader_set_uniform_2i ( shader name v0 v1 -- void )", "EXTERN: \"C\" void gst_gl_shader_set_uniform_2i( void * shader, char * name, int v0, int v1 );", "	( shader name v0 v1 -- )" );
	swigFunction( "c-function gst_gl_shader_set_uniform_2iv gst_gl_shader_set_uniform_2iv a s u a -- void", "FUNCTION: gst_gl_shader_set_uniform_2iv ( shader name count value -- void )", "EXTERN: \"C\" void gst_gl_shader_set_uniform_2iv( void * shader, char * name, int count, void * value );", "	( shader name count value -- )" );
	swigFunction( "c-function gst_gl_shader_set_uniform_2f gst_gl_shader_set_uniform_2f a s r r -- void", "FUNCTION: gst_gl_shader_set_uniform_2f ( shader name v0 v1 -- void )", "EXTERN: \"C\" void gst_gl_shader_set_uniform_2f( void * shader, char * name, float v0, float v1 );", "	( shader name v0 v1 -- )" );
	swigFunction( "c-function gst_gl_shader_set_uniform_2fv gst_gl_shader_set_uniform_2fv a s u a -- void", "FUNCTION: gst_gl_shader_set_uniform_2fv ( shader name count value -- void )", "EXTERN: \"C\" void gst_gl_shader_set_uniform_2fv( void * shader, char * name, int count, void * value );", "	( shader name count value -- )" );
	swigFunction( "c-function gst_gl_shader_set_uniform_3i gst_gl_shader_set_uniform_3i a s n n n -- void", "FUNCTION: gst_gl_shader_set_uniform_3i ( shader name v0 v1 v2 -- void )", "EXTERN: \"C\" void gst_gl_shader_set_uniform_3i( void * shader, char * name, int v0, int v1, int v2 );", "	( shader name v0 v1 v2 -- )" );
	swigFunction( "c-function gst_gl_shader_set_uniform_3iv gst_gl_shader_set_uniform_3iv a s u a -- void", "FUNCTION: gst_gl_shader_set_uniform_3iv ( shader name count value -- void )", "EXTERN: \"C\" void gst_gl_shader_set_uniform_3iv( void * shader, char * name, int count, void * value );", "	( shader name count value -- )" );
	swigFunction( "c-function gst_gl_shader_set_uniform_3f gst_gl_shader_set_uniform_3f a s r r r -- void", "FUNCTION: gst_gl_shader_set_uniform_3f ( shader name v0 v1 v2 -- void )", "EXTERN: \"C\" void gst_gl_shader_set_uniform_3f( void * shader, char * name, float v0, float v1, float v2 );", "	( shader name v0 v1 v2 -- )" );
	swigFunction( "c-function gst_gl_shader_set_uniform_3fv gst_gl_shader_set_uniform_3fv a s u a -- void", "FUNCTION: gst_gl_shader_set_uniform_3fv ( shader name count value -- void )", "EXTERN: \"C\" void gst_gl_shader_set_uniform_3fv( void * shader, char * name, int count, void * value );", "	( shader name count value -- )" );
	swigFunction( "c-function gst_gl_shader_set_uniform_4i gst_gl_shader_set_uniform_4i a s n n n n -- void", "FUNCTION: gst_gl_shader_set_uniform_4i ( shader name v0 v1 v2 v3 -- void )", "EXTERN: \"C\" void gst_gl_shader_set_uniform_4i( void * shader, char * name, int v0, int v1, int v2, int v3 );", "	( shader name v0 v1 v2 v3 -- )" );
	swigFunction( "c-function gst_gl_shader_set_uniform_4iv gst_gl_shader_set_uniform_4iv a s u a -- void", "FUNCTION: gst_gl_shader_set_uniform_4iv ( shader name count value -- void )", "EXTERN: \"C\" void gst_gl_shader_set_uniform_4iv( void * shader, char * name, int count, void * value );", "	( shader name count value -- )" );
	swigFunction( "c-function gst_gl_shader_set_uniform_4f gst_gl_shader_set_uniform_4f a s r r r r -- void", "FUNCTION: gst_gl_shader_set_uniform_4f ( shader name v0 v1 v2 v3 -- void )", "EXTERN: \"C\" void gst_gl_shader_set_uniform_4f( void * shader, char * name, float v0, float v1, float v2, float v3 );", "	( shader name v0 v1 v2 v3 -- )" );
	swigFunction( "c-function gst_gl_shader_set_uniform_4fv gst_gl_shader_set_uniform_4fv a s u a -- void", "FUNCTION: gst_gl_shader_set_uniform_4fv ( shader name count value -- void )", "EXTERN: \"C\" void gst_gl_shader_set_uniform_4fv( void * shader, char * name, int count, void * value );", "	( shader name count value -- )" );
	swigFunction( "c-function gst_gl_shader_set_uniform_matrix_2fv gst_gl_shader_set_uniform_matrix_2fv a s n n a -- void", "FUNCTION: gst_gl_shader_set_uniform_matrix_2fv ( shader name count transpose value -- void )", "EXTERN: \"C\" void gst_gl_shader_set_uniform_matrix_2fv( void * shader, char * name, int count, int transpose, void * value );", "	( shader name count transpose value -- )" );
	swigFunction( "c-function gst_gl_shader_set_uniform_matrix_3fv gst_gl_shader_set_uniform_matrix_3fv a s n n a -- void", "FUNCTION: gst_gl_shader_set_uniform_matrix_3fv ( shader name count transpose value -- void )", "EXTERN: \"C\" void gst_gl_shader_set_uniform_matrix_3fv( void * shader, char * name, int count, int transpose, void * value );", "	( shader name count transpose value -- )" );
	swigFunction( "c-function gst_gl_shader_set_uniform_matrix_4fv gst_gl_shader_set_uniform_matrix_4fv a s n n a -- void", "FUNCTION: gst_gl_shader_set_uniform_matrix_4fv ( shader name count transpose value -- void )", "EXTERN: \"C\" void gst_gl_shader_set_uniform_matrix_4fv( void * shader, char * name, int count, int transpose, void * value );", "	( shader name count transpose value -- )" );
	swigFunction( "c-function gst_gl_shader_set_uniform_matrix_2x3fv gst_gl_shader_set_uniform_matrix_2x3fv a s n n a -- void", "FUNCTION: gst_gl_shader_set_uniform_matrix_2x3fv ( shader name count transpose value -- void )", "EXTERN: \"C\" void gst_gl_shader_set_uniform_matrix_2x3fv( void * shader, char * name, int count, int transpose, void * value );", "	( shader name count transpose value -- )" );
	swigFunction( "c-function gst_gl_shader_set_uniform_matrix_2x4fv gst_gl_shader_set_uniform_matrix_2x4fv a s n n a -- void", "FUNCTION: gst_gl_shader_set_uniform_matrix_2x4fv ( shader name count transpose value -- void )", "EXTERN: \"C\" void gst_gl_shader_set_uniform_matrix_2x4fv( void * shader, char * name, int count, int transpose, void * value );", "	( shader name count transpose value -- )" );
	swigFunction( "c-function gst_gl_shader_set_uniform_matrix_3x2fv gst_gl_shader_set_uniform_matrix_3x2fv a s n n a -- void", "FUNCTION: gst_gl_shader_set_uniform_matrix_3x2fv ( shader name count transpose value -- void )", "EXTERN: \"C\" void gst_gl_shader_set_uniform_matrix_3x2fv( void * shader, char * name, int count, int transpose, void * value );", "	( shader name count transpose value -- )" );
	swigFunction( "c-function gst_gl_shader_set_uniform_matrix_3x4fv gst_gl_shader_set_uniform_matrix_3x4fv a s n n a -- void", "FUNCTION: gst_gl_shader_set_uniform_matrix_3x4fv ( shader name count transpose value -- void )", "EXTERN: \"C\" void gst_gl_shader_set_uniform_matrix_3x4fv( void * shader, char * name, int count, int transpose, void * value );", "	( shader name count transpose value -- )" );
	swigFunction( "c-function gst_gl_shader_set_uniform_matrix_4x2fv gst_gl_shader_set_uniform_matrix_4x2fv a s n n a -- void", "FUNCTION: gst_gl_shader_set_uniform_matrix_4x2fv ( shader name count transpose value -- void )", "EXTERN: \"C\" void gst_gl_shader_set_uniform_matrix_4x2fv( void * shader, char * name, int count, int transpose, void * value );", "	( shader name count transpose value -- )" );
	swigFunction( "c-function gst_gl_shader_set_uniform_matrix_4x3fv gst_gl_shader_set_uniform_matrix_4x3fv a s n n a -- void", "FUNCTION: gst_gl_shader_set_uniform_matrix_4x3fv ( shader name count transpose value -- void )", "EXTERN: \"C\" void gst_gl_shader_set_uniform_matrix_4x3fv( void * shader, char * name, int count, int transpose, void * value );", "	( shader name count transpose value -- )" );
	swigFunction( "c-function gst_gl_shader_get_attribute_location gst_gl_shader_get_attribute_location a s -- n", "FUNCTION: gst_gl_shader_get_attribute_location ( shader name -- n )", "EXTERN: \"C\" int gst_gl_shader_get_attribute_location( void * shader, char * name );", "	( shader name -- )" );
	swigFunction( "c-function gst_gl_shader_bind_attribute_location gst_gl_shader_bind_attribute_location a u s -- void", "FUNCTION: gst_gl_shader_bind_attribute_location ( shader index name -- void )", "EXTERN: \"C\" void gst_gl_shader_bind_attribute_location( void * shader, int index, char * name );", "	( shader index name -- )" );
	swigFunction( "c-function gst_gl_shader_bind_frag_data_location gst_gl_shader_bind_frag_data_location a u s -- void", "FUNCTION: gst_gl_shader_bind_frag_data_location ( shader index name -- void )", "EXTERN: \"C\" void gst_gl_shader_bind_frag_data_location( void * shader, int index, char * name );", "	( shader index name -- )" );
	swigFunction( "c-function gst_gl_upload_get_type gst_gl_upload_get_type  -- u", "FUNCTION: gst_gl_upload_get_type (  -- u )", "EXTERN: \"C\" int gst_gl_upload_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_gl_upload_get_input_template_caps gst_gl_upload_get_input_template_caps  -- a", "FUNCTION: gst_gl_upload_get_input_template_caps (  -- a )", "EXTERN: \"C\" void * gst_gl_upload_get_input_template_caps(  );", "	( -- )" );
	swigFunction( "c-function gst_gl_upload_new gst_gl_upload_new a -- a", "FUNCTION: gst_gl_upload_new ( context -- a )", "EXTERN: \"C\" void * gst_gl_upload_new( void * context );", "	( context -- )" );
	swigFunction( "c-function gst_gl_upload_set_context gst_gl_upload_set_context a a -- void", "FUNCTION: gst_gl_upload_set_context ( upload context -- void )", "EXTERN: \"C\" void gst_gl_upload_set_context( void * upload, void * context );", "	( upload context -- )" );
	swigFunction( "c-function gst_gl_upload_transform_caps gst_gl_upload_transform_caps a a n a a -- a", "FUNCTION: gst_gl_upload_transform_caps ( upload context direction caps filter -- a )", "EXTERN: \"C\" void * gst_gl_upload_transform_caps( void * upload, void * context, int direction, void * caps, void * filter );", "	( upload context direction caps filter -- )" );
	swigFunction( "c-function gst_gl_upload_set_caps gst_gl_upload_set_caps a a a -- n", "FUNCTION: gst_gl_upload_set_caps ( upload in_caps out_caps -- n )", "EXTERN: \"C\" int gst_gl_upload_set_caps( void * upload, void * in_caps, void * out_caps );", "	( upload in_caps out_caps -- )" );
	swigFunction( "c-function gst_gl_upload_get_caps gst_gl_upload_get_caps a a a -- void", "FUNCTION: gst_gl_upload_get_caps ( upload in_caps out_caps -- void )", "EXTERN: \"C\" void gst_gl_upload_get_caps( void * upload, void * in_caps, void * out_caps );", "	( upload in_caps out_caps -- )" );
	swigFunction( "c-function gst_gl_upload_propose_allocation gst_gl_upload_propose_allocation a a a -- void", "FUNCTION: gst_gl_upload_propose_allocation ( upload decide_query query -- void )", "EXTERN: \"C\" void gst_gl_upload_propose_allocation( void * upload, void * decide_query, void * query );", "	( upload decide_query query -- )" );
	swigFunction( "c-function gst_gl_upload_perform_with_buffer gst_gl_upload_perform_with_buffer a a a -- n", "FUNCTION: gst_gl_upload_perform_with_buffer ( upload buffer outbuf_ptr -- n )", "EXTERN: \"C\" int gst_gl_upload_perform_with_buffer( void * upload, void * buffer, void * outbuf_ptr );", "	( upload buffer outbuf_ptr -- )" );
	swigFunction( "c-function gst_gl_memory_allocator_get_type gst_gl_memory_allocator_get_type  -- u", "FUNCTION: gst_gl_memory_allocator_get_type (  -- u )", "EXTERN: \"C\" int gst_gl_memory_allocator_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_gl_video_allocation_params_get_type gst_gl_video_allocation_params_get_type  -- u", "FUNCTION: gst_gl_video_allocation_params_get_type (  -- u )", "EXTERN: \"C\" int gst_gl_video_allocation_params_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_gl_video_allocation_params_init_full gst_gl_video_allocation_params_init_full a u u a a a a a u a u u a a a a -- n", "FUNCTION: gst_gl_video_allocation_params_init_full ( params struct_size alloc_flags copy free context alloc_params v_info plane valign target tex_format wrapped_data gl_handle user_data notify -- n )", "EXTERN: \"C\" int gst_gl_video_allocation_params_init_full( void * params, int struct_size, int alloc_flags, void * copy, void * free, void * context, void * alloc_params, void * v_info, int plane, void * valign, int target, int tex_format, void * wrapped_data, void * gl_handle, void * user_data, void * notify );", "	( params struct_size alloc_flags copy free context alloc_params v_info plane valign target tex_format wrapped_data gl_handle user_data notify -- )" );
	swigFunction( "c-function gst_gl_video_allocation_params_new gst_gl_video_allocation_params_new a a a u a u u -- a", "FUNCTION: gst_gl_video_allocation_params_new ( context alloc_params v_info plane valign target tex_format -- a )", "EXTERN: \"C\" void * gst_gl_video_allocation_params_new( void * context, void * alloc_params, void * v_info, int plane, void * valign, int target, int tex_format );", "	( context alloc_params v_info plane valign target tex_format -- )" );
	swigFunction( "c-function gst_gl_video_allocation_params_new_wrapped_data gst_gl_video_allocation_params_new_wrapped_data a a a u a u u a a a -- a", "FUNCTION: gst_gl_video_allocation_params_new_wrapped_data ( context alloc_params v_info plane valign target tex_format wrapped_data user_data notify -- a )", "EXTERN: \"C\" void * gst_gl_video_allocation_params_new_wrapped_data( void * context, void * alloc_params, void * v_info, int plane, void * valign, int target, int tex_format, void * wrapped_data, void * user_data, void * notify );", "	( context alloc_params v_info plane valign target tex_format wrapped_data user_data notify -- )" );
	swigFunction( "c-function gst_gl_video_allocation_params_new_wrapped_texture gst_gl_video_allocation_params_new_wrapped_texture a a a u a u u u a a -- a", "FUNCTION: gst_gl_video_allocation_params_new_wrapped_texture ( context alloc_params v_info plane valign target tex_format tex_id user_data notify -- a )", "EXTERN: \"C\" void * gst_gl_video_allocation_params_new_wrapped_texture( void * context, void * alloc_params, void * v_info, int plane, void * valign, int target, int tex_format, int tex_id, void * user_data, void * notify );", "	( context alloc_params v_info plane valign target tex_format tex_id user_data notify -- )" );
	swigFunction( "c-function gst_gl_video_allocation_params_new_wrapped_gl_handle gst_gl_video_allocation_params_new_wrapped_gl_handle a a a u a u u a a a -- a", "FUNCTION: gst_gl_video_allocation_params_new_wrapped_gl_handle ( context alloc_params v_info plane valign target tex_format gl_handle user_data notify -- a )", "EXTERN: \"C\" void * gst_gl_video_allocation_params_new_wrapped_gl_handle( void * context, void * alloc_params, void * v_info, int plane, void * valign, int target, int tex_format, void * gl_handle, void * user_data, void * notify );", "	( context alloc_params v_info plane valign target tex_format gl_handle user_data notify -- )" );
	swigFunction( "c-function gst_gl_video_allocation_params_free_data gst_gl_video_allocation_params_free_data a -- void", "FUNCTION: gst_gl_video_allocation_params_free_data ( params -- void )", "EXTERN: \"C\" void gst_gl_video_allocation_params_free_data( void * params );", "	( params -- )" );
	swigFunction( "c-function gst_gl_video_allocation_params_copy_data gst_gl_video_allocation_params_copy_data a a -- void", "FUNCTION: gst_gl_video_allocation_params_copy_data ( src_vid dest_vid -- void )", "EXTERN: \"C\" void gst_gl_video_allocation_params_copy_data( void * src_vid, void * dest_vid );", "	( src_vid dest_vid -- )" );
	swigFunction( "c-function gst_gl_memory_init_once gst_gl_memory_init_once  -- void", "FUNCTION: gst_gl_memory_init_once (  -- void )", "EXTERN: \"C\" void gst_gl_memory_init_once(  );", "	( -- )" );
	swigFunction( "c-function gst_is_gl_memory gst_is_gl_memory a -- n", "FUNCTION: gst_is_gl_memory ( mem -- n )", "EXTERN: \"C\" int gst_is_gl_memory( void * mem );", "	( mem -- )" );
	swigFunction( "c-function gst_gl_memory_init gst_gl_memory_init a a a a u u a a u a a a -- void", "FUNCTION: gst_gl_memory_init ( mem allocator parent context target tex_format params info plane valign user_data notify -- void )", "EXTERN: \"C\" void gst_gl_memory_init( void * mem, void * allocator, void * parent, void * context, int target, int tex_format, void * params, void * info, int plane, void * valign, void * user_data, void * notify );", "	( mem allocator parent context target tex_format params info plane valign user_data notify -- )" );
	swigFunction( "c-function gst_gl_memory_copy_into gst_gl_memory_copy_into a u u u n n -- n", "FUNCTION: gst_gl_memory_copy_into ( gl_mem tex_id target tex_format width height -- n )", "EXTERN: \"C\" int gst_gl_memory_copy_into( void * gl_mem, int tex_id, int target, int tex_format, int width, int height );", "	( gl_mem tex_id target tex_format width height -- )" );
	swigFunction( "c-function gst_gl_memory_copy_teximage gst_gl_memory_copy_teximage a u u u n n -- n", "FUNCTION: gst_gl_memory_copy_teximage ( src tex_id out_target out_tex_format out_width out_height -- n )", "EXTERN: \"C\" int gst_gl_memory_copy_teximage( void * src, int tex_id, int out_target, int out_tex_format, int out_width, int out_height );", "	( src tex_id out_target out_tex_format out_width out_height -- )" );
	swigFunction( "c-function gst_gl_memory_read_pixels gst_gl_memory_read_pixels a a -- n", "FUNCTION: gst_gl_memory_read_pixels ( gl_mem read_pointer -- n )", "EXTERN: \"C\" int gst_gl_memory_read_pixels( void * gl_mem, void * read_pointer );", "	( gl_mem read_pointer -- )" );
	swigFunction( "c-function gst_gl_memory_texsubimage gst_gl_memory_texsubimage a a -- void", "FUNCTION: gst_gl_memory_texsubimage ( gl_mem read_pointer -- void )", "EXTERN: \"C\" void gst_gl_memory_texsubimage( void * gl_mem, void * read_pointer );", "	( gl_mem read_pointer -- )" );
	swigFunction( "c-function gst_gl_memory_get_texture_width gst_gl_memory_get_texture_width a -- n", "FUNCTION: gst_gl_memory_get_texture_width ( gl_mem -- n )", "EXTERN: \"C\" int gst_gl_memory_get_texture_width( void * gl_mem );", "	( gl_mem -- )" );
	swigFunction( "c-function gst_gl_memory_get_texture_height gst_gl_memory_get_texture_height a -- n", "FUNCTION: gst_gl_memory_get_texture_height ( gl_mem -- n )", "EXTERN: \"C\" int gst_gl_memory_get_texture_height( void * gl_mem );", "	( gl_mem -- )" );
	swigFunction( "c-function gst_gl_memory_get_texture_format gst_gl_memory_get_texture_format a -- u", "FUNCTION: gst_gl_memory_get_texture_format ( gl_mem -- u )", "EXTERN: \"C\" int gst_gl_memory_get_texture_format( void * gl_mem );", "	( gl_mem -- )" );
	swigFunction( "c-function gst_gl_memory_get_texture_target gst_gl_memory_get_texture_target a -- u", "FUNCTION: gst_gl_memory_get_texture_target ( gl_mem -- u )", "EXTERN: \"C\" int gst_gl_memory_get_texture_target( void * gl_mem );", "	( gl_mem -- )" );
	swigFunction( "c-function gst_gl_memory_get_texture_id gst_gl_memory_get_texture_id a -- u", "FUNCTION: gst_gl_memory_get_texture_id ( gl_mem -- u )", "EXTERN: \"C\" int gst_gl_memory_get_texture_id( void * gl_mem );", "	( gl_mem -- )" );
	swigFunction( "c-function gst_gl_memory_setup_buffer gst_gl_memory_setup_buffer a a a a a u -- n", "FUNCTION: gst_gl_memory_setup_buffer ( allocator buffer params tex_formats wrapped_data n_wrapped_pointers -- n )", "EXTERN: \"C\" int gst_gl_memory_setup_buffer( void * allocator, void * buffer, void * params, void * tex_formats, void * wrapped_data, int n_wrapped_pointers );", "	( allocator buffer params tex_formats wrapped_data n_wrapped_pointers -- )" );
	swigFunction( "c-function gst_gl_memory_allocator_get_default gst_gl_memory_allocator_get_default a -- a", "FUNCTION: gst_gl_memory_allocator_get_default ( context -- a )", "EXTERN: \"C\" void * gst_gl_memory_allocator_get_default( void * context );", "	( context -- )" );
	swigFunction( "c-function gst_gl_buffer_pool_get_type gst_gl_buffer_pool_get_type  -- u", "FUNCTION: gst_gl_buffer_pool_get_type (  -- u )", "EXTERN: \"C\" int gst_gl_buffer_pool_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_gl_buffer_pool_new gst_gl_buffer_pool_new a -- a", "FUNCTION: gst_gl_buffer_pool_new ( context -- a )", "EXTERN: \"C\" void * gst_gl_buffer_pool_new( void * context );", "	( context -- )" );
	swigFunction( "c-function gst_buffer_pool_config_get_gl_allocation_params gst_buffer_pool_config_get_gl_allocation_params a -- a", "FUNCTION: gst_buffer_pool_config_get_gl_allocation_params ( config -- a )", "EXTERN: \"C\" void * gst_buffer_pool_config_get_gl_allocation_params( void * config );", "	( config -- )" );
	swigFunction( "c-function gst_buffer_pool_config_set_gl_allocation_params gst_buffer_pool_config_set_gl_allocation_params a a -- void", "FUNCTION: gst_buffer_pool_config_set_gl_allocation_params ( config params -- void )", "EXTERN: \"C\" void gst_buffer_pool_config_set_gl_allocation_params( void * config, void * params );", "	( config params -- )" );
	swigFunction( "c-function gst_gl_framebuffer_get_type gst_gl_framebuffer_get_type  -- u", "FUNCTION: gst_gl_framebuffer_get_type (  -- u )", "EXTERN: \"C\" int gst_gl_framebuffer_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_gl_framebuffer_new gst_gl_framebuffer_new a -- a", "FUNCTION: gst_gl_framebuffer_new ( context -- a )", "EXTERN: \"C\" void * gst_gl_framebuffer_new( void * context );", "	( context -- )" );
	swigFunction( "c-function gst_gl_framebuffer_new_with_default_depth gst_gl_framebuffer_new_with_default_depth a u u -- a", "FUNCTION: gst_gl_framebuffer_new_with_default_depth ( context width height -- a )", "EXTERN: \"C\" void * gst_gl_framebuffer_new_with_default_depth( void * context, int width, int height );", "	( context width height -- )" );
	swigFunction( "c-function gst_gl_framebuffer_get_id gst_gl_framebuffer_get_id a -- u", "FUNCTION: gst_gl_framebuffer_get_id ( fb -- u )", "EXTERN: \"C\" int gst_gl_framebuffer_get_id( void * fb );", "	( fb -- )" );
	swigFunction( "c-function gst_gl_framebuffer_attach gst_gl_framebuffer_attach a u a -- void", "FUNCTION: gst_gl_framebuffer_attach ( fb attachment_point mem -- void )", "EXTERN: \"C\" void gst_gl_framebuffer_attach( void * fb, int attachment_point, void * mem );", "	( fb attachment_point mem -- )" );
	swigFunction( "c-function gst_gl_framebuffer_bind gst_gl_framebuffer_bind a -- void", "FUNCTION: gst_gl_framebuffer_bind ( fb -- void )", "EXTERN: \"C\" void gst_gl_framebuffer_bind( void * fb );", "	( fb -- )" );
	swigFunction( "c-function gst_gl_context_clear_framebuffer gst_gl_context_clear_framebuffer a -- void", "FUNCTION: gst_gl_context_clear_framebuffer ( context -- void )", "EXTERN: \"C\" void gst_gl_context_clear_framebuffer( void * context );", "	( context -- )" );
	swigFunction( "c-function gst_gl_framebuffer_get_effective_dimensions gst_gl_framebuffer_get_effective_dimensions a a a -- void", "FUNCTION: gst_gl_framebuffer_get_effective_dimensions ( fb width height -- void )", "EXTERN: \"C\" void gst_gl_framebuffer_get_effective_dimensions( void * fb, void * width, void * height );", "	( fb width height -- )" );
	swigFunction( "c-function gst_gl_context_check_framebuffer_status gst_gl_context_check_framebuffer_status a u -- n", "FUNCTION: gst_gl_context_check_framebuffer_status ( context fbo_target -- n )", "EXTERN: \"C\" int gst_gl_context_check_framebuffer_status( void * context, int fbo_target );", "	( context fbo_target -- )" );
	swigFunction( "c-function gst_gl_framebuffer_draw_to_texture gst_gl_framebuffer_draw_to_texture a a a a -- n", "FUNCTION: gst_gl_framebuffer_draw_to_texture ( fb mem func user_data -- n )", "EXTERN: \"C\" int gst_gl_framebuffer_draw_to_texture( void * fb, void * mem, void * func, void * user_data );", "	( fb mem func user_data -- )" );
	swigFunction( "c-function gst_gl_filter_get_type gst_gl_filter_get_type  -- u", "FUNCTION: gst_gl_filter_get_type (  -- u )", "EXTERN: \"C\" int gst_gl_filter_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_gl_filter_add_rgba_pad_templates gst_gl_filter_add_rgba_pad_templates a -- void", "FUNCTION: gst_gl_filter_add_rgba_pad_templates ( klass -- void )", "EXTERN: \"C\" void gst_gl_filter_add_rgba_pad_templates( void * klass );", "	( klass -- )" );
	swigFunction( "c-function gst_gl_filter_filter_texture gst_gl_filter_filter_texture a a a -- n", "FUNCTION: gst_gl_filter_filter_texture ( filter inbuf outbuf -- n )", "EXTERN: \"C\" int gst_gl_filter_filter_texture( void * filter, void * inbuf, void * outbuf );", "	( filter inbuf outbuf -- )" );
	swigFunction( "c-function gst_gl_filter_render_to_target gst_gl_filter_render_to_target a a a a a -- n", "FUNCTION: gst_gl_filter_render_to_target ( filter input output func data -- n )", "EXTERN: \"C\" int gst_gl_filter_render_to_target( void * filter, void * input, void * output, void * func, void * data );", "	( filter input output func data -- )" );
	swigFunction( "c-function gst_gl_filter_draw_fullscreen_quad gst_gl_filter_draw_fullscreen_quad a -- void", "FUNCTION: gst_gl_filter_draw_fullscreen_quad ( filter -- void )", "EXTERN: \"C\" void gst_gl_filter_draw_fullscreen_quad( void * filter );", "	( filter -- )" );
	swigFunction( "c-function gst_gl_filter_render_to_target_with_shader gst_gl_filter_render_to_target_with_shader a a a a -- void", "FUNCTION: gst_gl_filter_render_to_target_with_shader ( filter input output shader -- void )", "EXTERN: \"C\" void gst_gl_filter_render_to_target_with_shader( void * filter, void * input, void * output, void * shader );", "	( filter input output shader -- )" );
	swigFunction( "c-function gst_gl_sync_meta_api_get_type gst_gl_sync_meta_api_get_type  -- u", "FUNCTION: gst_gl_sync_meta_api_get_type (  -- u )", "EXTERN: \"C\" int gst_gl_sync_meta_api_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_gl_sync_meta_get_info gst_gl_sync_meta_get_info  -- a", "FUNCTION: gst_gl_sync_meta_get_info (  -- a )", "EXTERN: \"C\" void * gst_gl_sync_meta_get_info(  );", "	( -- )" );
	swigFunction( "c-function gst_buffer_add_gl_sync_meta gst_buffer_add_gl_sync_meta a a -- a", "FUNCTION: gst_buffer_add_gl_sync_meta ( context buffer -- a )", "EXTERN: \"C\" void * gst_buffer_add_gl_sync_meta( void * context, void * buffer );", "	( context buffer -- )" );
	swigFunction( "c-function gst_buffer_add_gl_sync_meta_full gst_buffer_add_gl_sync_meta_full a a a -- a", "FUNCTION: gst_buffer_add_gl_sync_meta_full ( context buffer data -- a )", "EXTERN: \"C\" void * gst_buffer_add_gl_sync_meta_full( void * context, void * buffer, void * data );", "	( context buffer data -- )" );
	swigFunction( "c-function gst_gl_sync_meta_set_sync_point gst_gl_sync_meta_set_sync_point a a -- void", "FUNCTION: gst_gl_sync_meta_set_sync_point ( sync_meta context -- void )", "EXTERN: \"C\" void gst_gl_sync_meta_set_sync_point( void * sync_meta, void * context );", "	( sync_meta context -- )" );
	swigFunction( "c-function gst_gl_sync_meta_wait gst_gl_sync_meta_wait a a -- void", "FUNCTION: gst_gl_sync_meta_wait ( sync_meta context -- void )", "EXTERN: \"C\" void gst_gl_sync_meta_wait( void * sync_meta, void * context );", "	( sync_meta context -- )" );
	swigFunction( "c-function gst_gl_sync_meta_wait_cpu gst_gl_sync_meta_wait_cpu a a -- void", "FUNCTION: gst_gl_sync_meta_wait_cpu ( sync_meta context -- void )", "EXTERN: \"C\" void gst_gl_sync_meta_wait_cpu( void * sync_meta, void * context );", "	( sync_meta context -- )" );
	swigFunction( "c-function gst_gl_display_egl_get_type gst_gl_display_egl_get_type  -- u", "FUNCTION: gst_gl_display_egl_get_type (  -- u )", "EXTERN: \"C\" int gst_gl_display_egl_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_gl_display_egl_new gst_gl_display_egl_new  -- a", "FUNCTION: gst_gl_display_egl_new (  -- a )", "EXTERN: \"C\" void * gst_gl_display_egl_new(  );", "	( -- )" );
	swigFunction( "c-function gst_gl_display_egl_new_with_egl_display gst_gl_display_egl_new_with_egl_display a -- a", "FUNCTION: gst_gl_display_egl_new_with_egl_display ( display -- a )", "EXTERN: \"C\" void * gst_gl_display_egl_new_with_egl_display( void * display );", "	( display -- )" );
	swigFunction( "c-function gst_gl_display_egl_from_gl_display gst_gl_display_egl_from_gl_display a -- a", "FUNCTION: gst_gl_display_egl_from_gl_display ( display -- a )", "EXTERN: \"C\" void * gst_gl_display_egl_from_gl_display( void * display );", "	( display -- )" );
	swigFunction( "c-function gst_gl_display_egl_get_from_native gst_gl_display_egl_get_from_native n u -- a", "FUNCTION: gst_gl_display_egl_get_from_native ( type display -- a )", "EXTERN: \"C\" void * gst_gl_display_egl_get_from_native( int type, long display );", "	( type display -- )" );
	swigFunction( "c-function gst_gl_display_x11_get_type gst_gl_display_x11_get_type  -- u", "FUNCTION: gst_gl_display_x11_get_type (  -- u )", "EXTERN: \"C\" int gst_gl_display_x11_get_type(  );", "	( -- )" );
	swigFunction( "c-function gst_gl_display_x11_new gst_gl_display_x11_new s -- a", "FUNCTION: gst_gl_display_x11_new ( name -- a )", "EXTERN: \"C\" void * gst_gl_display_x11_new( char * name );", "	( name -- )" );
	swigFunction( "c-function gst_gl_display_x11_new_with_display gst_gl_display_x11_new_with_display a -- a", "FUNCTION: gst_gl_display_x11_new_with_display ( display -- a )", "EXTERN: \"C\" void * gst_gl_display_x11_new_with_display( void * display );", "	( display -- )" );

	swigNewline();

	swigComment("----===< postfix >===-----\n");

	swigPrint( "end-c-library", "( none )", "( none )" );
	
	return 0;
} /* end of main */



