/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 3.0.9
 *
 * This file is not intended to be easily readable and contains a number of
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG
 * interface file instead.
 * ----------------------------------------------------------------------------- */
#include <stdio.h>
#include <string.h>
#include <stddef.h>

// Do not edit below this line
// end-of-default-includes


#include <glib.h>
#include <glib-object.h>

typedef enum{ NONE = -1, GFORTH = 0, SWIFTFORTH, VFX } SwigTargetSystem;
SwigTargetSystem swigTargetSystem = NONE;

unsigned char swigPrintStackComments = 1;

/* comments */
void swigNewline()
{
	printf( "\n" );
}

void swigComment( char *comment )
{
	printf( "\\ %s", comment );
}

/* generic print */
void swigPrint( char* gforth, char *swiftForth, char *vfx )
{
	if( swigTargetSystem == GFORTH )
		printf( "%s", gforth );
	else if( swigTargetSystem == SWIFTFORTH )
		printf( "%s", swiftForth );
	else if( swigTargetSystem == VFX )
		printf( "%s", vfx );
	printf( "\n" );
}
void swigPrintSystem( SwigTargetSystem targetSystem, char *text )
{
	if( targetSystem == swigTargetSystem )
	    printf( "%s\n", text );
}

/* constants */
void swigIntConstant( long constant, char *name )
{
	printf( "#%ld\tconstant %s\n", constant, name );
}

void swigUnsignedIntConstant( unsigned long constant, char *name )
{
	printf( "#%lu\tconstant %s\n", constant, name );
}

void swigLongConstant( long long constant, char *name )
{
	printf( "#%lld.\t2constant %s\n", constant, name );
}

void swigUnsignedLongConstant( unsigned long long constant, char *name )
{
	printf( "#%llu.\t2constant %s\n", constant, name );
}

void swigFloatConstant( double constant, char *name )
{
	char buffer[128];
	sprintf( buffer, "%f", constant );

	/* if the constant contains no exponent, add one */
	char *s;
	for( s = buffer; *s != 0; s++ )
		if( *s == 'e' || *s == 'E' )
			break;

	/* exponent found */
	if( *s != 0 )
		printf( "%s\tfconstant %s\n", buffer, name );
	/* not found */
	else
		printf( "%se0\tfconstant %s\n", buffer, name );
}

void swigStringConstant( char* constant, char *name )
{
	char c;
	printf( ": %s s\\\" ", name );
	while(( c = *constant++ ))
	{
		switch(c)
		{
			case '\b': printf( "\\b" ); break;
			case '\n': printf( "\\n" ); break;
			case '\f': printf( "\\f" ); break;
			case '\r': printf( "\\r" ); break;
			case '\t': printf( "\\t" ); break;
			case '"' : printf( "\\q" ); break;
			default:
				if(c < 0x20)
					printf("\\x%02x", c);
				else
					printf("%c", c); break;
		}
	}
	printf(	"\" ;\n" );
}

/* structs */
void swigStructField( char *name, size_t offset, size_t size )
{
	printf( "\tdrop %zu %zu +field %s\n", offset, size, name );
}

/* functions */
void swigFunction( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	if( swigTargetSystem == GFORTH )
		printf( "%s", gforth );
	else if( swigTargetSystem == SWIFTFORTH )
		printf( "%s", swiftForth );
	else if( swigTargetSystem == VFX )
		printf( "%s", vfx );

	if( swigPrintStackComments )
		printf( "%s", stackComment );

	printf( "\n" );
}

/* function pointers */
void swigFunctionPointer( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	swigFunction( gforth, swiftForth, vfx, stackComment );
}

/* callbacks */
void swigCallback( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	swigFunction( gforth, swiftForth, vfx, stackComment );
}

void swigUsage( char **argv )
{
	fprintf( stderr, "Usage: %s [-gforth|-swiftforth|-vfx]\n", argv[0] );
}

int main( int argc, char **argv )
{
	int i;

	/* check arguments */
	for( i = 1; i < argc; i++ )
		if( strcmp( argv[i], "-gforth" ) == 0 )
			swigTargetSystem = GFORTH;
		else if( strcmp( argv[i], "-swiftforth" ) == 0 )
			swigTargetSystem = SWIFTFORTH;
		else if( strcmp( argv[i], "-vfx" ) == 0 )
			swigTargetSystem = VFX;

	if( swigTargetSystem == NONE )
	{
		fprintf( stderr, "Error: no target system specified\n" );
		swigUsage( argv );
		return 1;
	}

	/* primer */
	printf( "\\ This file has been generated using SWIG and fsi,\n"
		"\\ and is already platform dependent, search for the corresponding\n"
		"\\ fsi-file to compile it where no one has compiled it before ;)\n"
		"\\ Forth systems have their own own dynamic loader and don't need addional C-Code.\n"
		"\\ That's why this file will just print normal forth-code once compiled\n"
		"\\ and can be used directly with include or require.\n"
		"\\ As all comments are stripped during the compilation, please\n"
		"\\ insert the copyright notice of the original file here.\n"
	);


typedef union {
  gpointer p; 
} GWeakRef_priv;


	swigNewline();

	swigComment("----===< prefix >===-----\n");

	swigPrint( "c-library gobject\ns\" gobject\" add-lib\n\\c #include <glib.h>\n\\c #include <glib-object.h>", "( none )", "( none )" );

	swigNewline();

	swigComment("----===< int constants >===-----\n");
	#ifdef G_LITTLE_ENDIAN
		swigIntConstant( G_LITTLE_ENDIAN, "G_LITTLE_ENDIAN" );
	#endif
	#ifdef G_BIG_ENDIAN
		swigIntConstant( G_BIG_ENDIAN, "G_BIG_ENDIAN" );
	#endif
	#ifdef G_PDP_ENDIAN
		swigIntConstant( G_PDP_ENDIAN, "G_PDP_ENDIAN" );
	#endif
	#ifdef G_IEEE754_FLOAT_BIAS
		swigIntConstant( G_IEEE754_FLOAT_BIAS, "G_IEEE754_FLOAT_BIAS" );
	#endif
	#ifdef G_IEEE754_DOUBLE_BIAS
		swigIntConstant( G_IEEE754_DOUBLE_BIAS, "G_IEEE754_DOUBLE_BIAS" );
	#endif
	#ifdef G_PRIORITY_HIGH
		swigIntConstant( G_PRIORITY_HIGH, "G_PRIORITY_HIGH" );
	#endif
	#ifdef G_PRIORITY_DEFAULT
		swigIntConstant( G_PRIORITY_DEFAULT, "G_PRIORITY_DEFAULT" );
	#endif
	#ifdef G_PRIORITY_HIGH_IDLE
		swigIntConstant( G_PRIORITY_HIGH_IDLE, "G_PRIORITY_HIGH_IDLE" );
	#endif
	#ifdef G_PRIORITY_DEFAULT_IDLE
		swigIntConstant( G_PRIORITY_DEFAULT_IDLE, "G_PRIORITY_DEFAULT_IDLE" );
	#endif
	#ifdef G_PRIORITY_LOW
		swigIntConstant( G_PRIORITY_LOW, "G_PRIORITY_LOW" );
	#endif
	#ifdef G_TYPE_FUNDAMENTAL_SHIFT
		swigIntConstant( G_TYPE_FUNDAMENTAL_SHIFT, "G_TYPE_FUNDAMENTAL_SHIFT" );
	#endif
	#ifdef G_TYPE_RESERVED_GLIB_FIRST
		swigIntConstant( G_TYPE_RESERVED_GLIB_FIRST, "G_TYPE_RESERVED_GLIB_FIRST" );
	#endif
	#ifdef G_TYPE_RESERVED_GLIB_LAST
		swigIntConstant( G_TYPE_RESERVED_GLIB_LAST, "G_TYPE_RESERVED_GLIB_LAST" );
	#endif
	#ifdef G_TYPE_RESERVED_BSE_FIRST
		swigIntConstant( G_TYPE_RESERVED_BSE_FIRST, "G_TYPE_RESERVED_BSE_FIRST" );
	#endif
	#ifdef G_TYPE_RESERVED_BSE_LAST
		swigIntConstant( G_TYPE_RESERVED_BSE_LAST, "G_TYPE_RESERVED_BSE_LAST" );
	#endif
	#ifdef G_TYPE_RESERVED_USER_FIRST
		swigIntConstant( G_TYPE_RESERVED_USER_FIRST, "G_TYPE_RESERVED_USER_FIRST" );
	#endif
	#ifdef G_SIGNAL_FLAGS_MASK
		swigIntConstant( G_SIGNAL_FLAGS_MASK, "G_SIGNAL_FLAGS_MASK" );
	#endif
	#ifdef G_SIGNAL_MATCH_MASK
		swigIntConstant( G_SIGNAL_MATCH_MASK, "G_SIGNAL_MATCH_MASK" );
	#endif

	swigNewline();

	swigComment("---===< float constants >===----\n");
	#ifdef G_E
		swigFloatConstant( G_E, "G_E" );
	#endif
	#ifdef G_LN2
		swigFloatConstant( G_LN2, "G_LN2" );
	#endif
	#ifdef G_LN10
		swigFloatConstant( G_LN10, "G_LN10" );
	#endif
	#ifdef G_PI
		swigFloatConstant( G_PI, "G_PI" );
	#endif
	#ifdef G_PI_2
		swigFloatConstant( G_PI_2, "G_PI_2" );
	#endif
	#ifdef G_PI_4
		swigFloatConstant( G_PI_4, "G_PI_4" );
	#endif
	#ifdef G_SQRT2
		swigFloatConstant( G_SQRT2, "G_SQRT2" );
	#endif
	#ifdef G_LOG_2_BASE_10
		swigFloatConstant( G_LOG_2_BASE_10, "G_LOG_2_BASE_10" );
	#endif

	swigNewline();

	swigComment("--------===< enums >===---------\n");
	swigIntConstant( G_THREAD_ERROR_AGAIN, "G_THREAD_ERROR_AGAIN" );
	swigIntConstant( G_ONCE_STATUS_NOTCALLED, "G_ONCE_STATUS_NOTCALLED" );
	swigIntConstant( G_ONCE_STATUS_PROGRESS, "G_ONCE_STATUS_PROGRESS" );
	swigIntConstant( G_ONCE_STATUS_READY, "G_ONCE_STATUS_READY" );
	swigIntConstant( G_IO_IN, "G_IO_IN" );
	swigIntConstant( G_IO_OUT, "G_IO_OUT" );
	swigIntConstant( G_IO_PRI, "G_IO_PRI" );
	swigIntConstant( G_IO_ERR, "G_IO_ERR" );
	swigIntConstant( G_IO_HUP, "G_IO_HUP" );
	swigIntConstant( G_IO_NVAL, "G_IO_NVAL" );
	swigIntConstant( G_TYPE_DEBUG_NONE, "G_TYPE_DEBUG_NONE" );
	swigIntConstant( G_TYPE_DEBUG_OBJECTS, "G_TYPE_DEBUG_OBJECTS" );
	swigIntConstant( G_TYPE_DEBUG_SIGNALS, "G_TYPE_DEBUG_SIGNALS" );
	swigIntConstant( G_TYPE_DEBUG_INSTANCE_COUNT, "G_TYPE_DEBUG_INSTANCE_COUNT" );
	swigIntConstant( G_TYPE_DEBUG_MASK, "G_TYPE_DEBUG_MASK" );
	swigIntConstant( G_TYPE_FLAG_CLASSED, "G_TYPE_FLAG_CLASSED" );
	swigIntConstant( G_TYPE_FLAG_INSTANTIATABLE, "G_TYPE_FLAG_INSTANTIATABLE" );
	swigIntConstant( G_TYPE_FLAG_DERIVABLE, "G_TYPE_FLAG_DERIVABLE" );
	swigIntConstant( G_TYPE_FLAG_DEEP_DERIVABLE, "G_TYPE_FLAG_DEEP_DERIVABLE" );
	swigIntConstant( G_TYPE_FLAG_ABSTRACT, "G_TYPE_FLAG_ABSTRACT" );
	swigIntConstant( G_TYPE_FLAG_VALUE_ABSTRACT, "G_TYPE_FLAG_VALUE_ABSTRACT" );
	swigIntConstant( G_SIGNAL_RUN_FIRST, "G_SIGNAL_RUN_FIRST" );
	swigIntConstant( G_SIGNAL_RUN_LAST, "G_SIGNAL_RUN_LAST" );
	swigIntConstant( G_SIGNAL_RUN_CLEANUP, "G_SIGNAL_RUN_CLEANUP" );
	swigIntConstant( G_SIGNAL_NO_RECURSE, "G_SIGNAL_NO_RECURSE" );
	swigIntConstant( G_SIGNAL_DETAILED, "G_SIGNAL_DETAILED" );
	swigIntConstant( G_SIGNAL_ACTION, "G_SIGNAL_ACTION" );
	swigIntConstant( G_SIGNAL_NO_HOOKS, "G_SIGNAL_NO_HOOKS" );
	swigIntConstant( G_SIGNAL_MUST_COLLECT, "G_SIGNAL_MUST_COLLECT" );
	swigIntConstant( G_SIGNAL_DEPRECATED, "G_SIGNAL_DEPRECATED" );
	swigIntConstant( G_CONNECT_AFTER, "G_CONNECT_AFTER" );
	swigIntConstant( G_CONNECT_SWAPPED, "G_CONNECT_SWAPPED" );
	swigIntConstant( G_SIGNAL_MATCH_ID, "G_SIGNAL_MATCH_ID" );
	swigIntConstant( G_SIGNAL_MATCH_DETAIL, "G_SIGNAL_MATCH_DETAIL" );
	swigIntConstant( G_SIGNAL_MATCH_CLOSURE, "G_SIGNAL_MATCH_CLOSURE" );
	swigIntConstant( G_SIGNAL_MATCH_FUNC, "G_SIGNAL_MATCH_FUNC" );
	swigIntConstant( G_SIGNAL_MATCH_DATA, "G_SIGNAL_MATCH_DATA" );
	swigIntConstant( G_SIGNAL_MATCH_UNBLOCKED, "G_SIGNAL_MATCH_UNBLOCKED" );

	swigNewline();

	swigComment("-------===< structs >===--------\n");

	swigComment("_GTimeVal\n");
	printf( "begin-structure _GTimeVal\n" );
	swigStructField( "_GTimeVal-tv_usec", offsetof( struct _GTimeVal, tv_usec ), sizeof( glong ) );
	swigStructField( "_GTimeVal-tv_sec", offsetof( struct _GTimeVal, tv_sec ), sizeof( glong ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GTimeVal ) );

	swigComment("_GMutex\n");
	printf( "begin-structure _GMutex\n" );
	swigStructField( "_GMutex-p", offsetof( union _GMutex, p ), sizeof( gpointer ) );
	swigStructField( "_GMutex-i", offsetof( union _GMutex, i ), sizeof( guint [2] ) );
	printf( "drop %zu end-structure\n", sizeof( union _GMutex ) );

	swigComment("_GRWLock\n");
	printf( "begin-structure _GRWLock\n" );
	swigStructField( "_GRWLock-p", offsetof( struct _GRWLock, p ), sizeof( gpointer ) );
	swigStructField( "_GRWLock-i", offsetof( struct _GRWLock, i ), sizeof( guint [2] ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GRWLock ) );

	swigComment("_GCond\n");
	printf( "begin-structure _GCond\n" );
	swigStructField( "_GCond-p", offsetof( struct _GCond, p ), sizeof( gpointer ) );
	swigStructField( "_GCond-i", offsetof( struct _GCond, i ), sizeof( guint [2] ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GCond ) );

	swigComment("_GRecMutex\n");
	printf( "begin-structure _GRecMutex\n" );
	swigStructField( "_GRecMutex-p", offsetof( struct _GRecMutex, p ), sizeof( gpointer ) );
	swigStructField( "_GRecMutex-i", offsetof( struct _GRecMutex, i ), sizeof( guint [2] ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GRecMutex ) );

	swigComment("_GPrivate\n");
	printf( "begin-structure _GPrivate\n" );
	swigStructField( "_GPrivate-p", offsetof( struct _GPrivate, p ), sizeof( gpointer ) );
	swigStructField( "_GPrivate-future", offsetof( struct _GPrivate, future ), sizeof( gpointer [2] ) );
	swigStructField( "_GPrivate-notify", offsetof( struct _GPrivate, notify ), sizeof( GDestroyNotify ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GPrivate ) );

	swigComment("_GOnce\n");
	printf( "begin-structure _GOnce\n" );
	swigStructField( "_GOnce-status", offsetof( struct _GOnce, status ), sizeof( GOnceStatus volatile ) );
	swigStructField( "_GOnce-retval", offsetof( struct _GOnce, retval ), sizeof( gpointer volatile ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GOnce ) );

	swigComment("_GSource\n");
	printf( "begin-structure _GSource\n" );
	swigStructField( "_GSource-priority", offsetof( struct _GSource, priority ), sizeof( gint ) );
	swigStructField( "_GSource-callback_funcs", offsetof( struct _GSource, callback_funcs ), sizeof( GSourceCallbackFuncs * ) );
	swigStructField( "_GSource-source_funcs", offsetof( struct _GSource, source_funcs ), sizeof( GSourceFuncs const * ) );
	swigStructField( "_GSource-ref_count", offsetof( struct _GSource, ref_count ), sizeof( guint ) );
	swigStructField( "_GSource-prev", offsetof( struct _GSource, prev ), sizeof( GSource * ) );
	swigStructField( "_GSource-name", offsetof( struct _GSource, name ), sizeof( char * ) );
	swigStructField( "_GSource-poll_fds", offsetof( struct _GSource, poll_fds ), sizeof( GSList * ) );
	swigStructField( "_GSource-priv", offsetof( struct _GSource, priv ), sizeof( GSourcePrivate * ) );
	swigStructField( "_GSource-callback_data", offsetof( struct _GSource, callback_data ), sizeof( gpointer ) );
	swigStructField( "_GSource-source_id", offsetof( struct _GSource, source_id ), sizeof( guint ) );
	swigStructField( "_GSource-context", offsetof( struct _GSource, context ), sizeof( GMainContext * ) );
	swigStructField( "_GSource-flags", offsetof( struct _GSource, flags ), sizeof( guint ) );
	swigStructField( "_GSource-next", offsetof( struct _GSource, next ), sizeof( GSource * ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GSource ) );

	swigComment("_GSourceCallbackFuncs\n");
	printf( "begin-structure _GSourceCallbackFuncs\n" );
	swigStructField( "_GSourceCallbackFuncs-unref", offsetof( struct _GSourceCallbackFuncs, unref ), sizeof( void (*)(gpointer) ) );
	swigStructField( "_GSourceCallbackFuncs-get", offsetof( struct _GSourceCallbackFuncs, get ), sizeof( void (*)(gpointer,GSource *,GSourceFunc *,gpointer *) ) );
	swigStructField( "_GSourceCallbackFuncs-ref", offsetof( struct _GSourceCallbackFuncs, ref ), sizeof( void (*)(gpointer) ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GSourceCallbackFuncs ) );

	swigComment("_GSourceFuncs\n");
	printf( "begin-structure _GSourceFuncs\n" );
	swigStructField( "_GSourceFuncs-finalize", offsetof( struct _GSourceFuncs, finalize ), sizeof( void (*)(GSource *) ) );
	swigStructField( "_GSourceFuncs-check", offsetof( struct _GSourceFuncs, check ), sizeof( gboolean (*)(GSource *) ) );
	swigStructField( "_GSourceFuncs-prepare", offsetof( struct _GSourceFuncs, prepare ), sizeof( gboolean (*)(GSource *,gint *) ) );
	swigStructField( "_GSourceFuncs-closure_marshal", offsetof( struct _GSourceFuncs, closure_marshal ), sizeof( GSourceDummyMarshal ) );
	swigStructField( "_GSourceFuncs-closure_callback", offsetof( struct _GSourceFuncs, closure_callback ), sizeof( GSourceFunc ) );
	swigStructField( "_GSourceFuncs-dispatch", offsetof( struct _GSourceFuncs, dispatch ), sizeof( gboolean (*)(GSource *,GSourceFunc,gpointer) ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GSourceFuncs ) );

	swigComment("_GTypeClass\n");
	printf( "begin-structure _GTypeClass\n" );
	swigStructField( "_GTypeClass-g_type", offsetof( struct _GTypeClass, g_type ), sizeof( GType ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GTypeClass ) );

	swigComment("_GTypeInstance\n");
	printf( "begin-structure _GTypeInstance\n" );
	swigStructField( "_GTypeInstance-g_class", offsetof( struct _GTypeInstance, g_class ), sizeof( GTypeClass * ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GTypeInstance ) );

	swigComment("_GTypeInterface\n");
	printf( "begin-structure _GTypeInterface\n" );
	swigStructField( "_GTypeInterface-g_type", offsetof( struct _GTypeInterface, g_type ), sizeof( GType ) );
	swigStructField( "_GTypeInterface-g_instance_type", offsetof( struct _GTypeInterface, g_instance_type ), sizeof( GType ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GTypeInterface ) );

	swigComment("_GTypeQuery\n");
	printf( "begin-structure _GTypeQuery\n" );
	swigStructField( "_GTypeQuery-type_name", offsetof( struct _GTypeQuery, type_name ), sizeof( gchar const * ) );
	swigStructField( "_GTypeQuery-class_size", offsetof( struct _GTypeQuery, class_size ), sizeof( guint ) );
	swigStructField( "_GTypeQuery-instance_size", offsetof( struct _GTypeQuery, instance_size ), sizeof( guint ) );
	swigStructField( "_GTypeQuery-type", offsetof( struct _GTypeQuery, type ), sizeof( GType ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GTypeQuery ) );

	swigComment("_GTypeInfo\n");
	printf( "begin-structure _GTypeInfo\n" );
	swigStructField( "_GTypeInfo-base_finalize", offsetof( struct _GTypeInfo, base_finalize ), sizeof( GBaseFinalizeFunc ) );
	swigStructField( "_GTypeInfo-class_finalize", offsetof( struct _GTypeInfo, class_finalize ), sizeof( GClassFinalizeFunc ) );
	swigStructField( "_GTypeInfo-value_table", offsetof( struct _GTypeInfo, value_table ), sizeof( GTypeValueTable const * ) );
	swigStructField( "_GTypeInfo-n_preallocs", offsetof( struct _GTypeInfo, n_preallocs ), sizeof( guint16 ) );
	swigStructField( "_GTypeInfo-class_size", offsetof( struct _GTypeInfo, class_size ), sizeof( guint16 ) );
	swigStructField( "_GTypeInfo-instance_size", offsetof( struct _GTypeInfo, instance_size ), sizeof( guint16 ) );
	swigStructField( "_GTypeInfo-base_init", offsetof( struct _GTypeInfo, base_init ), sizeof( GBaseInitFunc ) );
	swigStructField( "_GTypeInfo-class_init", offsetof( struct _GTypeInfo, class_init ), sizeof( GClassInitFunc ) );
	swigStructField( "_GTypeInfo-instance_init", offsetof( struct _GTypeInfo, instance_init ), sizeof( GInstanceInitFunc ) );
	swigStructField( "_GTypeInfo-class_data", offsetof( struct _GTypeInfo, class_data ), sizeof( gconstpointer ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GTypeInfo ) );

	swigComment("_GTypeFundamentalInfo\n");
	printf( "begin-structure _GTypeFundamentalInfo\n" );
	swigStructField( "_GTypeFundamentalInfo-type_flags", offsetof( struct _GTypeFundamentalInfo, type_flags ), sizeof( GTypeFundamentalFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GTypeFundamentalInfo ) );

	swigComment("_GInterfaceInfo\n");
	printf( "begin-structure _GInterfaceInfo\n" );
	swigStructField( "_GInterfaceInfo-interface_finalize", offsetof( struct _GInterfaceInfo, interface_finalize ), sizeof( GInterfaceFinalizeFunc ) );
	swigStructField( "_GInterfaceInfo-interface_init", offsetof( struct _GInterfaceInfo, interface_init ), sizeof( GInterfaceInitFunc ) );
	swigStructField( "_GInterfaceInfo-interface_data", offsetof( struct _GInterfaceInfo, interface_data ), sizeof( gpointer ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GInterfaceInfo ) );

	swigComment("_GTypeValueTable\n");
	printf( "begin-structure _GTypeValueTable\n" );
	swigStructField( "_GTypeValueTable-value_free", offsetof( struct _GTypeValueTable, value_free ), sizeof( void (*)(GValue *) ) );
	swigStructField( "_GTypeValueTable-lcopy_value", offsetof( struct _GTypeValueTable, lcopy_value ), sizeof( gchar *(*)(GValue const *,guint,GTypeCValue *,guint) ) );
	swigStructField( "_GTypeValueTable-value_peek_pointer", offsetof( struct _GTypeValueTable, value_peek_pointer ), sizeof( gpointer (*)(GValue const *) ) );
	swigStructField( "_GTypeValueTable-collect_value", offsetof( struct _GTypeValueTable, collect_value ), sizeof( gchar *(*)(GValue *,guint,GTypeCValue *,guint) ) );
	swigStructField( "_GTypeValueTable-collect_format", offsetof( struct _GTypeValueTable, collect_format ), sizeof( gchar const * ) );
	swigStructField( "_GTypeValueTable-lcopy_format", offsetof( struct _GTypeValueTable, lcopy_format ), sizeof( gchar const * ) );
	swigStructField( "_GTypeValueTable-value_init", offsetof( struct _GTypeValueTable, value_init ), sizeof( void (*)(GValue *) ) );
	swigStructField( "_GTypeValueTable-value_copy", offsetof( struct _GTypeValueTable, value_copy ), sizeof( void (*)(GValue const *,GValue *) ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GTypeValueTable ) );

	swigComment("_GObject\n");
	printf( "begin-structure _GObject\n" );
	swigStructField( "_GObject-g_type_instance", offsetof( struct _GObject, g_type_instance ), sizeof( GTypeInstance ) );
	swigStructField( "_GObject-ref_count", offsetof( struct _GObject, ref_count ), sizeof( guint volatile ) );
	swigStructField( "_GObject-qdata", offsetof( struct _GObject, qdata ), sizeof( GData * ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GObject ) );

	swigComment("_GObjectClass\n");
	printf( "begin-structure _GObjectClass\n" );
	swigStructField( "_GObjectClass-set_property", offsetof( struct _GObjectClass, set_property ), sizeof( void (*)(GObject *,guint,GValue const *,GParamSpec *) ) );
	swigStructField( "_GObjectClass-get_property", offsetof( struct _GObjectClass, get_property ), sizeof( void (*)(GObject *,guint,GValue *,GParamSpec *) ) );
	swigStructField( "_GObjectClass-finalize", offsetof( struct _GObjectClass, finalize ), sizeof( void (*)(GObject *) ) );
	swigStructField( "_GObjectClass-constructor", offsetof( struct _GObjectClass, constructor ), sizeof( GObject *(*)(GType,guint,GObjectConstructParam *) ) );
	swigStructField( "_GObjectClass-dispose", offsetof( struct _GObjectClass, dispose ), sizeof( void (*)(GObject *) ) );
	swigStructField( "_GObjectClass-pdummy", offsetof( struct _GObjectClass, pdummy ), sizeof( gpointer [6] ) );
	swigStructField( "_GObjectClass-construct_properties", offsetof( struct _GObjectClass, construct_properties ), sizeof( GSList * ) );
	swigStructField( "_GObjectClass-constructed", offsetof( struct _GObjectClass, constructed ), sizeof( void (*)(GObject *) ) );
	swigStructField( "_GObjectClass-g_type_class", offsetof( struct _GObjectClass, g_type_class ), sizeof( GTypeClass ) );
	swigStructField( "_GObjectClass-notify", offsetof( struct _GObjectClass, notify ), sizeof( void (*)(GObject *,GParamSpec *) ) );
	swigStructField( "_GObjectClass-flags", offsetof( struct _GObjectClass, flags ), sizeof( gsize ) );
	swigStructField( "_GObjectClass-dispatch_properties_changed", offsetof( struct _GObjectClass, dispatch_properties_changed ), sizeof( void (*)(GObject *,guint,GParamSpec **) ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GObjectClass ) );

	swigComment("_GObjectConstructParam\n");
	printf( "begin-structure _GObjectConstructParam\n" );
	swigStructField( "_GObjectConstructParam-pspec", offsetof( struct _GObjectConstructParam, pspec ), sizeof( GParamSpec * ) );
	swigStructField( "_GObjectConstructParam-value", offsetof( struct _GObjectConstructParam, value ), sizeof( GValue * ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GObjectConstructParam ) );

	swigComment("GWeakRef\n");
	printf( "begin-structure GWeakRef\n" );
	swigStructField( "GWeakRef-priv", offsetof( GWeakRef, priv ), sizeof( GWeakRef_priv ) );
	printf( "drop %zu end-structure\n", sizeof( GWeakRef ) );

	swigComment("GWeakRef_priv\n");
	printf( "begin-structure GWeakRef_priv\n" );
	swigStructField( "GWeakRef_priv-p", offsetof( GWeakRef_priv, p ), sizeof( gpointer ) );
	printf( "drop %zu end-structure\n", sizeof( GWeakRef_priv ) );

	swigComment("_GSignalInvocationHint\n");
	printf( "begin-structure _GSignalInvocationHint\n" );
	swigStructField( "_GSignalInvocationHint-signal_id", offsetof( struct _GSignalInvocationHint, signal_id ), sizeof( guint ) );
	swigStructField( "_GSignalInvocationHint-detail", offsetof( struct _GSignalInvocationHint, detail ), sizeof( GQuark ) );
	swigStructField( "_GSignalInvocationHint-run_type", offsetof( struct _GSignalInvocationHint, run_type ), sizeof( GSignalFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GSignalInvocationHint ) );

	swigComment("_GSignalQuery\n");
	printf( "begin-structure _GSignalQuery\n" );
	swigStructField( "_GSignalQuery-return_type", offsetof( struct _GSignalQuery, return_type ), sizeof( GType ) );
	swigStructField( "_GSignalQuery-signal_id", offsetof( struct _GSignalQuery, signal_id ), sizeof( guint ) );
	swigStructField( "_GSignalQuery-param_types", offsetof( struct _GSignalQuery, param_types ), sizeof( GType const * ) );
	swigStructField( "_GSignalQuery-itype", offsetof( struct _GSignalQuery, itype ), sizeof( GType ) );
	swigStructField( "_GSignalQuery-signal_flags", offsetof( struct _GSignalQuery, signal_flags ), sizeof( GSignalFlags ) );
	swigStructField( "_GSignalQuery-n_params", offsetof( struct _GSignalQuery, n_params ), sizeof( guint ) );
	swigStructField( "_GSignalQuery-signal_name", offsetof( struct _GSignalQuery, signal_name ), sizeof( gchar const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct _GSignalQuery ) );

	swigNewline();

	swigComment("--===< function pointers >===---\n");
	swigFunctionPointer( "c-funptr _GSourceCallbackFuncs-ref() {((struct _GSourceCallbackFuncs*)ptr)->ref} a -- void", "", "", "	( cb_data -- )" );
	swigFunctionPointer( "c-funptr _GSourceCallbackFuncs-unref() {((struct _GSourceCallbackFuncs*)ptr)->unref} a -- void", "", "", "	( cb_data -- )" );
	swigFunctionPointer( "c-funptr _GSourceCallbackFuncs-get() {((struct _GSourceCallbackFuncs*)ptr)->get} a a a a -- void", "", "", "	( cb_data source func data -- )" );
	swigFunctionPointer( "c-funptr _GSourceFuncs-prepare() {((struct _GSourceFuncs*)ptr)->prepare} a a -- n", "", "", "	( source timeout_ -- )" );
	swigFunctionPointer( "c-funptr _GSourceFuncs-check() {((struct _GSourceFuncs*)ptr)->check} a -- n", "", "", "	( source -- )" );
	swigFunctionPointer( "c-funptr _GSourceFuncs-dispatch() {((struct _GSourceFuncs*)ptr)->dispatch} a a a -- n", "", "", "	( source callback user_data -- )" );
	swigFunctionPointer( "c-funptr _GSourceFuncs-finalize() {((struct _GSourceFuncs*)ptr)->finalize} a -- void", "", "", "	( source -- )" );
	swigFunctionPointer( "c-funptr _GTypeValueTable-value_init() {((struct _GTypeValueTable*)ptr)->value_init} a -- void", "", "", "	( value -- )" );
	swigFunctionPointer( "c-funptr _GTypeValueTable-value_free() {((struct _GTypeValueTable*)ptr)->value_free} a -- void", "", "", "	( value -- )" );
	swigFunctionPointer( "c-funptr _GTypeValueTable-value_copy() {((struct _GTypeValueTable*)ptr)->value_copy} a a -- void", "", "", "	( src_value dest_value -- )" );
	swigFunctionPointer( "c-funptr _GTypeValueTable-value_peek_pointer() {((struct _GTypeValueTable*)ptr)->value_peek_pointer} a -- a", "", "", "	( value -- )" );
	swigFunctionPointer( "c-funptr _GTypeValueTable-collect_value() {((struct _GTypeValueTable*)ptr)->collect_value} a u a u -- a", "", "", "	( value n_collect_values collect_values collect_flags -- )" );
	swigFunctionPointer( "c-funptr _GTypeValueTable-lcopy_value() {((struct _GTypeValueTable*)ptr)->lcopy_value} a u a u -- a", "", "", "	( value n_collect_values collect_values collect_flags -- )" );
	swigFunctionPointer( "c-funptr _GObjectClass-constructor() {((struct _GObjectClass*)ptr)->constructor} n u a -- a", "", "", "	( type n_construct_properties construct_properties -- )" );
	swigFunctionPointer( "c-funptr _GObjectClass-set_property() {((struct _GObjectClass*)ptr)->set_property} a u a a -- void", "", "", "	( object property_id value pspec -- )" );
	swigFunctionPointer( "c-funptr _GObjectClass-get_property() {((struct _GObjectClass*)ptr)->get_property} a u a a -- void", "", "", "	( object property_id value pspec -- )" );
	swigFunctionPointer( "c-funptr _GObjectClass-dispose() {((struct _GObjectClass*)ptr)->dispose} a -- void", "", "", "	( object -- )" );
	swigFunctionPointer( "c-funptr _GObjectClass-finalize() {((struct _GObjectClass*)ptr)->finalize} a -- void", "", "", "	( object -- )" );
	swigFunctionPointer( "c-funptr _GObjectClass-dispatch_properties_changed() {((struct _GObjectClass*)ptr)->dispatch_properties_changed} a u a -- void", "", "", "	( object n_pspecs pspecs -- )" );
	swigFunctionPointer( "c-funptr _GObjectClass-notify() {((struct _GObjectClass*)ptr)->notify} a a -- void", "", "", "	( object pspec -- )" );
	swigFunctionPointer( "c-funptr _GObjectClass-constructed() {((struct _GObjectClass*)ptr)->constructed} a -- void", "", "", "	( object -- )" );

	swigNewline();

	swigComment("------===< callbacks >===-------\n");
	swigCallback( "c-callback GCompareFunc: a a -- n", "", "", "	( a b -- )" );
	swigCallback( "c-callback GCompareDataFunc: a a a -- n", "", "", "	( a b user_data -- )" );
	swigCallback( "c-callback GEqualFunc: a a -- n", "", "", "	( a b -- )" );
	swigCallback( "c-callback GDestroyNotify: a -- void", "", "", "	( data -- )" );
	swigCallback( "c-callback GFunc: a a -- void", "", "", "	( data user_data -- )" );
	swigCallback( "c-callback GHashFunc: a -- u", "", "", "	( key -- )" );
	swigCallback( "c-callback GHFunc: a a a -- void", "", "", "	( key value user_data -- )" );
	swigCallback( "c-callback GFreeFunc: a -- void", "", "", "	( data -- )" );
	swigCallback( "c-callback GTranslateFunc: s a -- s", "", "", "	( str data -- )" );
	swigCallback( "c-callback GThreadFunc: a -- a", "", "", "	( data -- )" );
	swigCallback( "c-callback GSourceFunc: a -- n", "", "", "	( user_data -- )" );
	swigCallback( "c-callback GChildWatchFunc: n n a -- void", "", "", "	( pid status user_data -- )" );
	swigCallback( "c-callback GSourceDummyMarshal:  -- void", "", "", "	( <noname> -- )" );
	swigCallback( "c-callback GClearHandleFunc: u -- void", "", "", "	( handle_id -- )" );
	swigCallback( "c-callback GBaseInitFunc: a -- void", "", "", "	( g_class -- )" );
	swigCallback( "c-callback GBaseFinalizeFunc: a -- void", "", "", "	( g_class -- )" );
	swigCallback( "c-callback GClassInitFunc: a a -- void", "", "", "	( g_class class_data -- )" );
	swigCallback( "c-callback GClassFinalizeFunc: a a -- void", "", "", "	( g_class class_data -- )" );
	swigCallback( "c-callback GInstanceInitFunc: a a -- void", "", "", "	( instance g_class -- )" );
	swigCallback( "c-callback GInterfaceInitFunc: a a -- void", "", "", "	( g_iface iface_data -- )" );
	swigCallback( "c-callback GInterfaceFinalizeFunc: a a -- void", "", "", "	( g_iface iface_data -- )" );
	swigCallback( "c-callback GTypeClassCacheFunc: a a -- n", "", "", "	( cache_data g_class -- )" );
	swigCallback( "c-callback GTypeInterfaceCheckFunc: a a -- void", "", "", "	( check_data g_iface -- )" );
	swigCallback( "c-callback GObjectGetPropertyFunc: a u a a -- void", "", "", "	( object property_id value pspec -- )" );
	swigCallback( "c-callback GObjectSetPropertyFunc: a u a a -- void", "", "", "	( object property_id value pspec -- )" );
	swigCallback( "c-callback GObjectFinalizeFunc: a -- void", "", "", "	( object -- )" );
	swigCallback( "c-callback GWeakNotify: a a -- void", "", "", "	( data where_the_object_was -- )" );
	swigCallback( "c-callback GToggleNotify: a a n -- void", "", "", "	( data object is_last_ref -- )" );
	swigCallback( "c-callback GSignalEmissionHook: a u a a -- n", "", "", "	( ihint n_param_values param_values data -- )" );
	swigCallback( "c-callback GSignalAccumulator: a a a a -- n", "", "", "	( ihint return_accu handler_return data -- )" );

	swigNewline();

	swigComment("------===< functions >===-------\n");
	swigFunction( "c-function _GLIB_CHECKED_ADD_U32 _GLIB_CHECKED_ADD_U32 a n n -- n", "FUNCTION: _GLIB_CHECKED_ADD_U32 ( dest a b -- n )", "EXTERN: \"C\" int _GLIB_CHECKED_ADD_U32( void * dest, n a, n b );", "	( dest a b -- )" );
	swigFunction( "c-function _GLIB_CHECKED_MUL_U32 _GLIB_CHECKED_MUL_U32 a n n -- n", "FUNCTION: _GLIB_CHECKED_MUL_U32 ( dest a b -- n )", "EXTERN: \"C\" int _GLIB_CHECKED_MUL_U32( void * dest, n a, n b );", "	( dest a b -- )" );
	swigFunction( "c-function _GLIB_CHECKED_ADD_U64 _GLIB_CHECKED_ADD_U64 a n n -- n", "FUNCTION: _GLIB_CHECKED_ADD_U64 ( dest a b -- n )", "EXTERN: \"C\" int _GLIB_CHECKED_ADD_U64( void * dest, n a, n b );", "	( dest a b -- )" );
	swigFunction( "c-function _GLIB_CHECKED_MUL_U64 _GLIB_CHECKED_MUL_U64 a n n -- n", "FUNCTION: _GLIB_CHECKED_MUL_U64 ( dest a b -- n )", "EXTERN: \"C\" int _GLIB_CHECKED_MUL_U64( void * dest, n a, n b );", "	( dest a b -- )" );
	swigFunction( "c-function g_quark_try_string g_quark_try_string s -- n", "FUNCTION: g_quark_try_string ( string -- n )", "EXTERN: \"C\" n g_quark_try_string( char * string );", "	( string -- )" );
	swigFunction( "c-function g_quark_from_static_string g_quark_from_static_string s -- n", "FUNCTION: g_quark_from_static_string ( string -- n )", "EXTERN: \"C\" n g_quark_from_static_string( char * string );", "	( string -- )" );
	swigFunction( "c-function g_quark_from_string g_quark_from_string s -- n", "FUNCTION: g_quark_from_string ( string -- n )", "EXTERN: \"C\" n g_quark_from_string( char * string );", "	( string -- )" );
	swigFunction( "c-function g_quark_to_string g_quark_to_string n -- s", "FUNCTION: g_quark_to_string ( quark -- s )", "EXTERN: \"C\" char * g_quark_to_string( n quark );", "	( quark -- )" );
	swigFunction( "c-function g_intern_string g_intern_string s -- s", "FUNCTION: g_intern_string ( string -- s )", "EXTERN: \"C\" char * g_intern_string( char * string );", "	( string -- )" );
	swigFunction( "c-function g_intern_static_string g_intern_static_string s -- s", "FUNCTION: g_intern_static_string ( string -- s )", "EXTERN: \"C\" char * g_intern_static_string( char * string );", "	( string -- )" );
	swigFunction( "c-function g_thread_error_quark g_thread_error_quark  -- n", "FUNCTION: g_thread_error_quark (  -- n )", "EXTERN: \"C\" n g_thread_error_quark(  );", "	( -- )" );
	swigFunction( "c-function g_thread_ref g_thread_ref a -- a", "FUNCTION: g_thread_ref ( thread -- a )", "EXTERN: \"C\" void * g_thread_ref( void * thread );", "	( thread -- )" );
	swigFunction( "c-function g_thread_unref g_thread_unref a -- void", "FUNCTION: g_thread_unref ( thread -- void )", "EXTERN: \"C\" void g_thread_unref( void * thread );", "	( thread -- )" );
	swigFunction( "c-function g_thread_new g_thread_new s a a -- a", "FUNCTION: g_thread_new ( name func data -- a )", "EXTERN: \"C\" void * g_thread_new( char * name, void * func, void * data );", "	( name func data -- )" );
	swigFunction( "c-function g_thread_try_new g_thread_try_new s a a a -- a", "FUNCTION: g_thread_try_new ( name func data error -- a )", "EXTERN: \"C\" void * g_thread_try_new( char * name, void * func, void * data, void * error );", "	( name func data error -- )" );
	swigFunction( "c-function g_thread_self g_thread_self  -- a", "FUNCTION: g_thread_self (  -- a )", "EXTERN: \"C\" void * g_thread_self(  );", "	( -- )" );
	swigFunction( "c-function g_thread_exit g_thread_exit a -- void", "FUNCTION: g_thread_exit ( retval -- void )", "EXTERN: \"C\" void g_thread_exit( void * retval );", "	( retval -- )" );
	swigFunction( "c-function g_thread_join g_thread_join a -- a", "FUNCTION: g_thread_join ( thread -- a )", "EXTERN: \"C\" void * g_thread_join( void * thread );", "	( thread -- )" );
	swigFunction( "c-function g_thread_yield g_thread_yield  -- void", "FUNCTION: g_thread_yield (  -- void )", "EXTERN: \"C\" void g_thread_yield(  );", "	( -- )" );
	swigFunction( "c-function g_mutex_init g_mutex_init a -- void", "FUNCTION: g_mutex_init ( mutex -- void )", "EXTERN: \"C\" void g_mutex_init( void * mutex );", "	( mutex -- )" );
	swigFunction( "c-function g_mutex_clear g_mutex_clear a -- void", "FUNCTION: g_mutex_clear ( mutex -- void )", "EXTERN: \"C\" void g_mutex_clear( void * mutex );", "	( mutex -- )" );
	swigFunction( "c-function g_mutex_lock g_mutex_lock a -- void", "FUNCTION: g_mutex_lock ( mutex -- void )", "EXTERN: \"C\" void g_mutex_lock( void * mutex );", "	( mutex -- )" );
	swigFunction( "c-function g_mutex_trylock g_mutex_trylock a -- n", "FUNCTION: g_mutex_trylock ( mutex -- n )", "EXTERN: \"C\" int g_mutex_trylock( void * mutex );", "	( mutex -- )" );
	swigFunction( "c-function g_mutex_unlock g_mutex_unlock a -- void", "FUNCTION: g_mutex_unlock ( mutex -- void )", "EXTERN: \"C\" void g_mutex_unlock( void * mutex );", "	( mutex -- )" );
	swigFunction( "c-function g_rw_lock_init g_rw_lock_init a -- void", "FUNCTION: g_rw_lock_init ( rw_lock -- void )", "EXTERN: \"C\" void g_rw_lock_init( void * rw_lock );", "	( rw_lock -- )" );
	swigFunction( "c-function g_rw_lock_clear g_rw_lock_clear a -- void", "FUNCTION: g_rw_lock_clear ( rw_lock -- void )", "EXTERN: \"C\" void g_rw_lock_clear( void * rw_lock );", "	( rw_lock -- )" );
	swigFunction( "c-function g_rw_lock_writer_lock g_rw_lock_writer_lock a -- void", "FUNCTION: g_rw_lock_writer_lock ( rw_lock -- void )", "EXTERN: \"C\" void g_rw_lock_writer_lock( void * rw_lock );", "	( rw_lock -- )" );
	swigFunction( "c-function g_rw_lock_writer_trylock g_rw_lock_writer_trylock a -- n", "FUNCTION: g_rw_lock_writer_trylock ( rw_lock -- n )", "EXTERN: \"C\" int g_rw_lock_writer_trylock( void * rw_lock );", "	( rw_lock -- )" );
	swigFunction( "c-function g_rw_lock_writer_unlock g_rw_lock_writer_unlock a -- void", "FUNCTION: g_rw_lock_writer_unlock ( rw_lock -- void )", "EXTERN: \"C\" void g_rw_lock_writer_unlock( void * rw_lock );", "	( rw_lock -- )" );
	swigFunction( "c-function g_rw_lock_reader_lock g_rw_lock_reader_lock a -- void", "FUNCTION: g_rw_lock_reader_lock ( rw_lock -- void )", "EXTERN: \"C\" void g_rw_lock_reader_lock( void * rw_lock );", "	( rw_lock -- )" );
	swigFunction( "c-function g_rw_lock_reader_trylock g_rw_lock_reader_trylock a -- n", "FUNCTION: g_rw_lock_reader_trylock ( rw_lock -- n )", "EXTERN: \"C\" int g_rw_lock_reader_trylock( void * rw_lock );", "	( rw_lock -- )" );
	swigFunction( "c-function g_rw_lock_reader_unlock g_rw_lock_reader_unlock a -- void", "FUNCTION: g_rw_lock_reader_unlock ( rw_lock -- void )", "EXTERN: \"C\" void g_rw_lock_reader_unlock( void * rw_lock );", "	( rw_lock -- )" );
	swigFunction( "c-function g_rec_mutex_init g_rec_mutex_init a -- void", "FUNCTION: g_rec_mutex_init ( rec_mutex -- void )", "EXTERN: \"C\" void g_rec_mutex_init( void * rec_mutex );", "	( rec_mutex -- )" );
	swigFunction( "c-function g_rec_mutex_clear g_rec_mutex_clear a -- void", "FUNCTION: g_rec_mutex_clear ( rec_mutex -- void )", "EXTERN: \"C\" void g_rec_mutex_clear( void * rec_mutex );", "	( rec_mutex -- )" );
	swigFunction( "c-function g_rec_mutex_lock g_rec_mutex_lock a -- void", "FUNCTION: g_rec_mutex_lock ( rec_mutex -- void )", "EXTERN: \"C\" void g_rec_mutex_lock( void * rec_mutex );", "	( rec_mutex -- )" );
	swigFunction( "c-function g_rec_mutex_trylock g_rec_mutex_trylock a -- n", "FUNCTION: g_rec_mutex_trylock ( rec_mutex -- n )", "EXTERN: \"C\" int g_rec_mutex_trylock( void * rec_mutex );", "	( rec_mutex -- )" );
	swigFunction( "c-function g_rec_mutex_unlock g_rec_mutex_unlock a -- void", "FUNCTION: g_rec_mutex_unlock ( rec_mutex -- void )", "EXTERN: \"C\" void g_rec_mutex_unlock( void * rec_mutex );", "	( rec_mutex -- )" );
	swigFunction( "c-function g_cond_init g_cond_init a -- void", "FUNCTION: g_cond_init ( cond -- void )", "EXTERN: \"C\" void g_cond_init( void * cond );", "	( cond -- )" );
	swigFunction( "c-function g_cond_clear g_cond_clear a -- void", "FUNCTION: g_cond_clear ( cond -- void )", "EXTERN: \"C\" void g_cond_clear( void * cond );", "	( cond -- )" );
	swigFunction( "c-function g_cond_wait g_cond_wait a a -- void", "FUNCTION: g_cond_wait ( cond mutex -- void )", "EXTERN: \"C\" void g_cond_wait( void * cond, void * mutex );", "	( cond mutex -- )" );
	swigFunction( "c-function g_cond_signal g_cond_signal a -- void", "FUNCTION: g_cond_signal ( cond -- void )", "EXTERN: \"C\" void g_cond_signal( void * cond );", "	( cond -- )" );
	swigFunction( "c-function g_cond_broadcast g_cond_broadcast a -- void", "FUNCTION: g_cond_broadcast ( cond -- void )", "EXTERN: \"C\" void g_cond_broadcast( void * cond );", "	( cond -- )" );
	swigFunction( "c-function g_cond_wait_until g_cond_wait_until a a n -- n", "FUNCTION: g_cond_wait_until ( cond mutex end_time -- n )", "EXTERN: \"C\" int g_cond_wait_until( void * cond, void * mutex, n end_time );", "	( cond mutex end_time -- )" );
	swigFunction( "c-function g_private_get g_private_get a -- a", "FUNCTION: g_private_get ( key -- a )", "EXTERN: \"C\" void * g_private_get( void * key );", "	( key -- )" );
	swigFunction( "c-function g_private_set g_private_set a a -- void", "FUNCTION: g_private_set ( key value -- void )", "EXTERN: \"C\" void g_private_set( void * key, void * value );", "	( key value -- )" );
	swigFunction( "c-function g_private_replace g_private_replace a a -- void", "FUNCTION: g_private_replace ( key value -- void )", "EXTERN: \"C\" void g_private_replace( void * key, void * value );", "	( key value -- )" );
	swigFunction( "c-function g_once_impl g_once_impl a a a -- a", "FUNCTION: g_once_impl ( once func arg -- a )", "EXTERN: \"C\" void * g_once_impl( void * once, void * func, void * arg );", "	( once func arg -- )" );
	swigFunction( "c-function g_once_init_enter g_once_init_enter a -- n", "FUNCTION: g_once_init_enter ( location -- n )", "EXTERN: \"C\" int g_once_init_enter( void * location );", "	( location -- )" );
	swigFunction( "c-function g_once_init_leave g_once_init_leave a n -- void", "FUNCTION: g_once_init_leave ( location result -- void )", "EXTERN: \"C\" void g_once_init_leave( void * location, n result );", "	( location result -- )" );
	swigFunction( "c-function g_get_num_processors g_get_num_processors  -- u", "FUNCTION: g_get_num_processors (  -- u )", "EXTERN: \"C\" int g_get_num_processors(  );", "	( -- )" );
	swigFunction( "c-function g_mutex_locker_new g_mutex_locker_new a -- a", "FUNCTION: g_mutex_locker_new ( mutex -- a )", "EXTERN: \"C\" void * g_mutex_locker_new( void * mutex );", "	( mutex -- )" );
	swigFunction( "c-function g_mutex_locker_free g_mutex_locker_free a -- void", "FUNCTION: g_mutex_locker_free ( locker -- void )", "EXTERN: \"C\" void g_mutex_locker_free( void * locker );", "	( locker -- )" );
	swigFunction( "c-function g_main_context_new g_main_context_new  -- a", "FUNCTION: g_main_context_new (  -- a )", "EXTERN: \"C\" void * g_main_context_new(  );", "	( -- )" );
	swigFunction( "c-function g_main_context_ref g_main_context_ref a -- a", "FUNCTION: g_main_context_ref ( context -- a )", "EXTERN: \"C\" void * g_main_context_ref( void * context );", "	( context -- )" );
	swigFunction( "c-function g_main_context_unref g_main_context_unref a -- void", "FUNCTION: g_main_context_unref ( context -- void )", "EXTERN: \"C\" void g_main_context_unref( void * context );", "	( context -- )" );
	swigFunction( "c-function g_main_context_default g_main_context_default  -- a", "FUNCTION: g_main_context_default (  -- a )", "EXTERN: \"C\" void * g_main_context_default(  );", "	( -- )" );
	swigFunction( "c-function g_main_context_iteration g_main_context_iteration a n -- n", "FUNCTION: g_main_context_iteration ( context may_block -- n )", "EXTERN: \"C\" int g_main_context_iteration( void * context, int may_block );", "	( context may_block -- )" );
	swigFunction( "c-function g_main_context_pending g_main_context_pending a -- n", "FUNCTION: g_main_context_pending ( context -- n )", "EXTERN: \"C\" int g_main_context_pending( void * context );", "	( context -- )" );
	swigFunction( "c-function g_main_context_find_source_by_id g_main_context_find_source_by_id a u -- a", "FUNCTION: g_main_context_find_source_by_id ( context source_id -- a )", "EXTERN: \"C\" void * g_main_context_find_source_by_id( void * context, int source_id );", "	( context source_id -- )" );
	swigFunction( "c-function g_main_context_find_source_by_user_data g_main_context_find_source_by_user_data a a -- a", "FUNCTION: g_main_context_find_source_by_user_data ( context user_data -- a )", "EXTERN: \"C\" void * g_main_context_find_source_by_user_data( void * context, void * user_data );", "	( context user_data -- )" );
	swigFunction( "c-function g_main_context_find_source_by_funcs_user_data g_main_context_find_source_by_funcs_user_data a a a -- a", "FUNCTION: g_main_context_find_source_by_funcs_user_data ( context funcs user_data -- a )", "EXTERN: \"C\" void * g_main_context_find_source_by_funcs_user_data( void * context, void * funcs, void * user_data );", "	( context funcs user_data -- )" );
	swigFunction( "c-function g_main_context_wakeup g_main_context_wakeup a -- void", "FUNCTION: g_main_context_wakeup ( context -- void )", "EXTERN: \"C\" void g_main_context_wakeup( void * context );", "	( context -- )" );
	swigFunction( "c-function g_main_context_acquire g_main_context_acquire a -- n", "FUNCTION: g_main_context_acquire ( context -- n )", "EXTERN: \"C\" int g_main_context_acquire( void * context );", "	( context -- )" );
	swigFunction( "c-function g_main_context_release g_main_context_release a -- void", "FUNCTION: g_main_context_release ( context -- void )", "EXTERN: \"C\" void g_main_context_release( void * context );", "	( context -- )" );
	swigFunction( "c-function g_main_context_is_owner g_main_context_is_owner a -- n", "FUNCTION: g_main_context_is_owner ( context -- n )", "EXTERN: \"C\" int g_main_context_is_owner( void * context );", "	( context -- )" );
	swigFunction( "c-function g_main_context_wait g_main_context_wait a a a -- n", "FUNCTION: g_main_context_wait ( context cond mutex -- n )", "EXTERN: \"C\" int g_main_context_wait( void * context, void * cond, void * mutex );", "	( context cond mutex -- )" );
	swigFunction( "c-function g_main_context_prepare g_main_context_prepare a a -- n", "FUNCTION: g_main_context_prepare ( context priority -- n )", "EXTERN: \"C\" int g_main_context_prepare( void * context, void * priority );", "	( context priority -- )" );
	swigFunction( "c-function g_main_context_query g_main_context_query a n a a n -- n", "FUNCTION: g_main_context_query ( context max_priority timeout_ fds n_fds -- n )", "EXTERN: \"C\" int g_main_context_query( void * context, int max_priority, void * timeout_, void * fds, int n_fds );", "	( context max_priority timeout_ fds n_fds -- )" );
	swigFunction( "c-function g_main_context_check g_main_context_check a n a n -- n", "FUNCTION: g_main_context_check ( context max_priority fds n_fds -- n )", "EXTERN: \"C\" int g_main_context_check( void * context, int max_priority, void * fds, int n_fds );", "	( context max_priority fds n_fds -- )" );
	swigFunction( "c-function g_main_context_dispatch g_main_context_dispatch a -- void", "FUNCTION: g_main_context_dispatch ( context -- void )", "EXTERN: \"C\" void g_main_context_dispatch( void * context );", "	( context -- )" );
	swigFunction( "c-function g_main_context_set_poll_func g_main_context_set_poll_func a a -- void", "FUNCTION: g_main_context_set_poll_func ( context func -- void )", "EXTERN: \"C\" void g_main_context_set_poll_func( void * context, void * func );", "	( context func -- )" );
	swigFunction( "c-function g_main_context_get_poll_func g_main_context_get_poll_func a -- a", "FUNCTION: g_main_context_get_poll_func ( context -- a )", "EXTERN: \"C\" void * g_main_context_get_poll_func( void * context );", "	( context -- )" );
	swigFunction( "c-function g_main_context_add_poll g_main_context_add_poll a a n -- void", "FUNCTION: g_main_context_add_poll ( context fd priority -- void )", "EXTERN: \"C\" void g_main_context_add_poll( void * context, void * fd, int priority );", "	( context fd priority -- )" );
	swigFunction( "c-function g_main_context_remove_poll g_main_context_remove_poll a a -- void", "FUNCTION: g_main_context_remove_poll ( context fd -- void )", "EXTERN: \"C\" void g_main_context_remove_poll( void * context, void * fd );", "	( context fd -- )" );
	swigFunction( "c-function g_main_depth g_main_depth  -- n", "FUNCTION: g_main_depth (  -- n )", "EXTERN: \"C\" int g_main_depth(  );", "	( -- )" );
	swigFunction( "c-function g_main_current_source g_main_current_source  -- a", "FUNCTION: g_main_current_source (  -- a )", "EXTERN: \"C\" void * g_main_current_source(  );", "	( -- )" );
	swigFunction( "c-function g_main_context_push_thread_default g_main_context_push_thread_default a -- void", "FUNCTION: g_main_context_push_thread_default ( context -- void )", "EXTERN: \"C\" void g_main_context_push_thread_default( void * context );", "	( context -- )" );
	swigFunction( "c-function g_main_context_pop_thread_default g_main_context_pop_thread_default a -- void", "FUNCTION: g_main_context_pop_thread_default ( context -- void )", "EXTERN: \"C\" void g_main_context_pop_thread_default( void * context );", "	( context -- )" );
	swigFunction( "c-function g_main_context_get_thread_default g_main_context_get_thread_default  -- a", "FUNCTION: g_main_context_get_thread_default (  -- a )", "EXTERN: \"C\" void * g_main_context_get_thread_default(  );", "	( -- )" );
	swigFunction( "c-function g_main_context_ref_thread_default g_main_context_ref_thread_default  -- a", "FUNCTION: g_main_context_ref_thread_default (  -- a )", "EXTERN: \"C\" void * g_main_context_ref_thread_default(  );", "	( -- )" );
	swigFunction( "c-function g_main_loop_new g_main_loop_new a n -- a", "FUNCTION: g_main_loop_new ( context is_running -- a )", "EXTERN: \"C\" void * g_main_loop_new( void * context, int is_running );", "	( context is_running -- )" );
	swigFunction( "c-function g_main_loop_run g_main_loop_run a -- void", "FUNCTION: g_main_loop_run ( loop -- void )", "EXTERN: \"C\" void g_main_loop_run( void * loop );", "	( loop -- )" );
	swigFunction( "c-function g_main_loop_quit g_main_loop_quit a -- void", "FUNCTION: g_main_loop_quit ( loop -- void )", "EXTERN: \"C\" void g_main_loop_quit( void * loop );", "	( loop -- )" );
	swigFunction( "c-function g_main_loop_ref g_main_loop_ref a -- a", "FUNCTION: g_main_loop_ref ( loop -- a )", "EXTERN: \"C\" void * g_main_loop_ref( void * loop );", "	( loop -- )" );
	swigFunction( "c-function g_main_loop_unref g_main_loop_unref a -- void", "FUNCTION: g_main_loop_unref ( loop -- void )", "EXTERN: \"C\" void g_main_loop_unref( void * loop );", "	( loop -- )" );
	swigFunction( "c-function g_main_loop_is_running g_main_loop_is_running a -- n", "FUNCTION: g_main_loop_is_running ( loop -- n )", "EXTERN: \"C\" int g_main_loop_is_running( void * loop );", "	( loop -- )" );
	swigFunction( "c-function g_main_loop_get_context g_main_loop_get_context a -- a", "FUNCTION: g_main_loop_get_context ( loop -- a )", "EXTERN: \"C\" void * g_main_loop_get_context( void * loop );", "	( loop -- )" );
	swigFunction( "c-function g_source_new g_source_new a u -- a", "FUNCTION: g_source_new ( source_funcs struct_size -- a )", "EXTERN: \"C\" void * g_source_new( void * source_funcs, int struct_size );", "	( source_funcs struct_size -- )" );
	swigFunction( "c-function g_source_ref g_source_ref a -- a", "FUNCTION: g_source_ref ( source -- a )", "EXTERN: \"C\" void * g_source_ref( void * source );", "	( source -- )" );
	swigFunction( "c-function g_source_unref g_source_unref a -- void", "FUNCTION: g_source_unref ( source -- void )", "EXTERN: \"C\" void g_source_unref( void * source );", "	( source -- )" );
	swigFunction( "c-function g_source_attach g_source_attach a a -- u", "FUNCTION: g_source_attach ( source context -- u )", "EXTERN: \"C\" int g_source_attach( void * source, void * context );", "	( source context -- )" );
	swigFunction( "c-function g_source_destroy g_source_destroy a -- void", "FUNCTION: g_source_destroy ( source -- void )", "EXTERN: \"C\" void g_source_destroy( void * source );", "	( source -- )" );
	swigFunction( "c-function g_source_set_priority g_source_set_priority a n -- void", "FUNCTION: g_source_set_priority ( source priority -- void )", "EXTERN: \"C\" void g_source_set_priority( void * source, int priority );", "	( source priority -- )" );
	swigFunction( "c-function g_source_get_priority g_source_get_priority a -- n", "FUNCTION: g_source_get_priority ( source -- n )", "EXTERN: \"C\" int g_source_get_priority( void * source );", "	( source -- )" );
	swigFunction( "c-function g_source_set_can_recurse g_source_set_can_recurse a n -- void", "FUNCTION: g_source_set_can_recurse ( source can_recurse -- void )", "EXTERN: \"C\" void g_source_set_can_recurse( void * source, int can_recurse );", "	( source can_recurse -- )" );
	swigFunction( "c-function g_source_get_can_recurse g_source_get_can_recurse a -- n", "FUNCTION: g_source_get_can_recurse ( source -- n )", "EXTERN: \"C\" int g_source_get_can_recurse( void * source );", "	( source -- )" );
	swigFunction( "c-function g_source_get_id g_source_get_id a -- u", "FUNCTION: g_source_get_id ( source -- u )", "EXTERN: \"C\" int g_source_get_id( void * source );", "	( source -- )" );
	swigFunction( "c-function g_source_get_context g_source_get_context a -- a", "FUNCTION: g_source_get_context ( source -- a )", "EXTERN: \"C\" void * g_source_get_context( void * source );", "	( source -- )" );
	swigFunction( "c-function g_source_set_callback g_source_set_callback a a a a -- void", "FUNCTION: g_source_set_callback ( source func data notify -- void )", "EXTERN: \"C\" void g_source_set_callback( void * source, void * func, void * data, void * notify );", "	( source func data notify -- )" );
	swigFunction( "c-function g_source_set_funcs g_source_set_funcs a a -- void", "FUNCTION: g_source_set_funcs ( source funcs -- void )", "EXTERN: \"C\" void g_source_set_funcs( void * source, void * funcs );", "	( source funcs -- )" );
	swigFunction( "c-function g_source_is_destroyed g_source_is_destroyed a -- n", "FUNCTION: g_source_is_destroyed ( source -- n )", "EXTERN: \"C\" int g_source_is_destroyed( void * source );", "	( source -- )" );
	swigFunction( "c-function g_source_set_name g_source_set_name a s -- void", "FUNCTION: g_source_set_name ( source name -- void )", "EXTERN: \"C\" void g_source_set_name( void * source, char * name );", "	( source name -- )" );
	swigFunction( "c-function g_source_get_name g_source_get_name a -- s", "FUNCTION: g_source_get_name ( source -- s )", "EXTERN: \"C\" char * g_source_get_name( void * source );", "	( source -- )" );
	swigFunction( "c-function g_source_set_name_by_id g_source_set_name_by_id u s -- void", "FUNCTION: g_source_set_name_by_id ( tag name -- void )", "EXTERN: \"C\" void g_source_set_name_by_id( int tag, char * name );", "	( tag name -- )" );
	swigFunction( "c-function g_source_set_ready_time g_source_set_ready_time a n -- void", "FUNCTION: g_source_set_ready_time ( source ready_time -- void )", "EXTERN: \"C\" void g_source_set_ready_time( void * source, n ready_time );", "	( source ready_time -- )" );
	swigFunction( "c-function g_source_get_ready_time g_source_get_ready_time a -- n", "FUNCTION: g_source_get_ready_time ( source -- n )", "EXTERN: \"C\" n g_source_get_ready_time( void * source );", "	( source -- )" );
	swigFunction( "c-function g_source_set_callback_indirect g_source_set_callback_indirect a a a -- void", "FUNCTION: g_source_set_callback_indirect ( source callback_data callback_funcs -- void )", "EXTERN: \"C\" void g_source_set_callback_indirect( void * source, void * callback_data, void * callback_funcs );", "	( source callback_data callback_funcs -- )" );
	swigFunction( "c-function g_source_add_poll g_source_add_poll a a -- void", "FUNCTION: g_source_add_poll ( source fd -- void )", "EXTERN: \"C\" void g_source_add_poll( void * source, void * fd );", "	( source fd -- )" );
	swigFunction( "c-function g_source_remove_poll g_source_remove_poll a a -- void", "FUNCTION: g_source_remove_poll ( source fd -- void )", "EXTERN: \"C\" void g_source_remove_poll( void * source, void * fd );", "	( source fd -- )" );
	swigFunction( "c-function g_source_add_child_source g_source_add_child_source a a -- void", "FUNCTION: g_source_add_child_source ( source child_source -- void )", "EXTERN: \"C\" void g_source_add_child_source( void * source, void * child_source );", "	( source child_source -- )" );
	swigFunction( "c-function g_source_remove_child_source g_source_remove_child_source a a -- void", "FUNCTION: g_source_remove_child_source ( source child_source -- void )", "EXTERN: \"C\" void g_source_remove_child_source( void * source, void * child_source );", "	( source child_source -- )" );
	swigFunction( "c-function g_source_get_current_time g_source_get_current_time a a -- void", "FUNCTION: g_source_get_current_time ( source timeval -- void )", "EXTERN: \"C\" void g_source_get_current_time( void * source, void * timeval );", "	( source timeval -- )" );
	swigFunction( "c-function g_source_get_time g_source_get_time a -- n", "FUNCTION: g_source_get_time ( source -- n )", "EXTERN: \"C\" n g_source_get_time( void * source );", "	( source -- )" );
	swigFunction( "c-function g_idle_source_new g_idle_source_new  -- a", "FUNCTION: g_idle_source_new (  -- a )", "EXTERN: \"C\" void * g_idle_source_new(  );", "	( -- )" );
	swigFunction( "c-function g_child_watch_source_new g_child_watch_source_new n -- a", "FUNCTION: g_child_watch_source_new ( pid -- a )", "EXTERN: \"C\" void * g_child_watch_source_new( n pid );", "	( pid -- )" );
	swigFunction( "c-function g_timeout_source_new g_timeout_source_new u -- a", "FUNCTION: g_timeout_source_new ( interval -- a )", "EXTERN: \"C\" void * g_timeout_source_new( int interval );", "	( interval -- )" );
	swigFunction( "c-function g_timeout_source_new_seconds g_timeout_source_new_seconds u -- a", "FUNCTION: g_timeout_source_new_seconds ( interval -- a )", "EXTERN: \"C\" void * g_timeout_source_new_seconds( int interval );", "	( interval -- )" );
	swigFunction( "c-function g_get_current_time g_get_current_time a -- void", "FUNCTION: g_get_current_time ( result -- void )", "EXTERN: \"C\" void g_get_current_time( void * result );", "	( result -- )" );
	swigFunction( "c-function g_get_monotonic_time g_get_monotonic_time  -- n", "FUNCTION: g_get_monotonic_time (  -- n )", "EXTERN: \"C\" n g_get_monotonic_time(  );", "	( -- )" );
	swigFunction( "c-function g_get_real_time g_get_real_time  -- n", "FUNCTION: g_get_real_time (  -- n )", "EXTERN: \"C\" n g_get_real_time(  );", "	( -- )" );
	swigFunction( "c-function g_source_remove g_source_remove u -- n", "FUNCTION: g_source_remove ( tag -- n )", "EXTERN: \"C\" int g_source_remove( int tag );", "	( tag -- )" );
	swigFunction( "c-function g_source_remove_by_user_data g_source_remove_by_user_data a -- n", "FUNCTION: g_source_remove_by_user_data ( user_data -- n )", "EXTERN: \"C\" int g_source_remove_by_user_data( void * user_data );", "	( user_data -- )" );
	swigFunction( "c-function g_source_remove_by_funcs_user_data g_source_remove_by_funcs_user_data a a -- n", "FUNCTION: g_source_remove_by_funcs_user_data ( funcs user_data -- n )", "EXTERN: \"C\" int g_source_remove_by_funcs_user_data( void * funcs, void * user_data );", "	( funcs user_data -- )" );
	swigFunction( "c-function g_clear_handle_id g_clear_handle_id a a -- void", "FUNCTION: g_clear_handle_id ( tag_ptr clear_func -- void )", "EXTERN: \"C\" void g_clear_handle_id( void * tag_ptr, void * clear_func );", "	( tag_ptr clear_func -- )" );
	swigFunction( "c-function g_timeout_add_full g_timeout_add_full n u a a a -- u", "FUNCTION: g_timeout_add_full ( priority interval function data notify -- u )", "EXTERN: \"C\" int g_timeout_add_full( int priority, int interval, void * function, void * data, void * notify );", "	( priority interval function data notify -- )" );
	swigFunction( "c-function g_timeout_add g_timeout_add u a a -- u", "FUNCTION: g_timeout_add ( interval function data -- u )", "EXTERN: \"C\" int g_timeout_add( int interval, void * function, void * data );", "	( interval function data -- )" );
	swigFunction( "c-function g_timeout_add_seconds_full g_timeout_add_seconds_full n u a a a -- u", "FUNCTION: g_timeout_add_seconds_full ( priority interval function data notify -- u )", "EXTERN: \"C\" int g_timeout_add_seconds_full( int priority, int interval, void * function, void * data, void * notify );", "	( priority interval function data notify -- )" );
	swigFunction( "c-function g_timeout_add_seconds g_timeout_add_seconds u a a -- u", "FUNCTION: g_timeout_add_seconds ( interval function data -- u )", "EXTERN: \"C\" int g_timeout_add_seconds( int interval, void * function, void * data );", "	( interval function data -- )" );
	swigFunction( "c-function g_child_watch_add_full g_child_watch_add_full n n a a a -- u", "FUNCTION: g_child_watch_add_full ( priority pid function data notify -- u )", "EXTERN: \"C\" int g_child_watch_add_full( int priority, n pid, void * function, void * data, void * notify );", "	( priority pid function data notify -- )" );
	swigFunction( "c-function g_child_watch_add g_child_watch_add n a a -- u", "FUNCTION: g_child_watch_add ( pid function data -- u )", "EXTERN: \"C\" int g_child_watch_add( n pid, void * function, void * data );", "	( pid function data -- )" );
	swigFunction( "c-function g_idle_add g_idle_add a a -- u", "FUNCTION: g_idle_add ( function data -- u )", "EXTERN: \"C\" int g_idle_add( void * function, void * data );", "	( function data -- )" );
	swigFunction( "c-function g_idle_add_full g_idle_add_full n a a a -- u", "FUNCTION: g_idle_add_full ( priority function data notify -- u )", "EXTERN: \"C\" int g_idle_add_full( int priority, void * function, void * data, void * notify );", "	( priority function data notify -- )" );
	swigFunction( "c-function g_idle_remove_by_data g_idle_remove_by_data a -- n", "FUNCTION: g_idle_remove_by_data ( data -- n )", "EXTERN: \"C\" int g_idle_remove_by_data( void * data );", "	( data -- )" );
	swigFunction( "c-function g_main_context_invoke_full g_main_context_invoke_full a n a a a -- void", "FUNCTION: g_main_context_invoke_full ( context priority function data notify -- void )", "EXTERN: \"C\" void g_main_context_invoke_full( void * context, int priority, void * function, void * data, void * notify );", "	( context priority function data notify -- )" );
	swigFunction( "c-function g_main_context_invoke g_main_context_invoke a a a -- void", "FUNCTION: g_main_context_invoke ( context function data -- void )", "EXTERN: \"C\" void g_main_context_invoke( void * context, void * function, void * data );", "	( context function data -- )" );
	swigFunction( "c-function g_type_init g_type_init  -- void", "FUNCTION: g_type_init (  -- void )", "EXTERN: \"C\" void g_type_init(  );", "	( -- )" );
	swigFunction( "c-function g_type_init_with_debug_flags g_type_init_with_debug_flags n -- void", "FUNCTION: g_type_init_with_debug_flags ( debug_flags -- void )", "EXTERN: \"C\" void g_type_init_with_debug_flags( int debug_flags );", "	( debug_flags -- )" );
	swigFunction( "c-function g_type_name g_type_name n -- s", "FUNCTION: g_type_name ( type -- s )", "EXTERN: \"C\" char * g_type_name( n type );", "	( type -- )" );
	swigFunction( "c-function g_type_qname g_type_qname n -- n", "FUNCTION: g_type_qname ( type -- n )", "EXTERN: \"C\" n g_type_qname( n type );", "	( type -- )" );
	swigFunction( "c-function g_type_from_name g_type_from_name s -- n", "FUNCTION: g_type_from_name ( name -- n )", "EXTERN: \"C\" n g_type_from_name( char * name );", "	( name -- )" );
	swigFunction( "c-function g_type_parent g_type_parent n -- n", "FUNCTION: g_type_parent ( type -- n )", "EXTERN: \"C\" n g_type_parent( n type );", "	( type -- )" );
	swigFunction( "c-function g_type_depth g_type_depth n -- u", "FUNCTION: g_type_depth ( type -- u )", "EXTERN: \"C\" int g_type_depth( n type );", "	( type -- )" );
	swigFunction( "c-function g_type_next_base g_type_next_base n n -- n", "FUNCTION: g_type_next_base ( leaf_type root_type -- n )", "EXTERN: \"C\" n g_type_next_base( n leaf_type, n root_type );", "	( leaf_type root_type -- )" );
	swigFunction( "c-function g_type_is_a g_type_is_a n n -- n", "FUNCTION: g_type_is_a ( type is_a_type -- n )", "EXTERN: \"C\" int g_type_is_a( n type, n is_a_type );", "	( type is_a_type -- )" );
	swigFunction( "c-function g_type_class_ref g_type_class_ref n -- a", "FUNCTION: g_type_class_ref ( type -- a )", "EXTERN: \"C\" void * g_type_class_ref( n type );", "	( type -- )" );
	swigFunction( "c-function g_type_class_peek g_type_class_peek n -- a", "FUNCTION: g_type_class_peek ( type -- a )", "EXTERN: \"C\" void * g_type_class_peek( n type );", "	( type -- )" );
	swigFunction( "c-function g_type_class_peek_static g_type_class_peek_static n -- a", "FUNCTION: g_type_class_peek_static ( type -- a )", "EXTERN: \"C\" void * g_type_class_peek_static( n type );", "	( type -- )" );
	swigFunction( "c-function g_type_class_unref g_type_class_unref a -- void", "FUNCTION: g_type_class_unref ( g_class -- void )", "EXTERN: \"C\" void g_type_class_unref( void * g_class );", "	( g_class -- )" );
	swigFunction( "c-function g_type_class_peek_parent g_type_class_peek_parent a -- a", "FUNCTION: g_type_class_peek_parent ( g_class -- a )", "EXTERN: \"C\" void * g_type_class_peek_parent( void * g_class );", "	( g_class -- )" );
	swigFunction( "c-function g_type_interface_peek g_type_interface_peek a n -- a", "FUNCTION: g_type_interface_peek ( instance_class iface_type -- a )", "EXTERN: \"C\" void * g_type_interface_peek( void * instance_class, n iface_type );", "	( instance_class iface_type -- )" );
	swigFunction( "c-function g_type_interface_peek_parent g_type_interface_peek_parent a -- a", "FUNCTION: g_type_interface_peek_parent ( g_iface -- a )", "EXTERN: \"C\" void * g_type_interface_peek_parent( void * g_iface );", "	( g_iface -- )" );
	swigFunction( "c-function g_type_default_interface_ref g_type_default_interface_ref n -- a", "FUNCTION: g_type_default_interface_ref ( g_type -- a )", "EXTERN: \"C\" void * g_type_default_interface_ref( n g_type );", "	( g_type -- )" );
	swigFunction( "c-function g_type_default_interface_peek g_type_default_interface_peek n -- a", "FUNCTION: g_type_default_interface_peek ( g_type -- a )", "EXTERN: \"C\" void * g_type_default_interface_peek( n g_type );", "	( g_type -- )" );
	swigFunction( "c-function g_type_default_interface_unref g_type_default_interface_unref a -- void", "FUNCTION: g_type_default_interface_unref ( g_iface -- void )", "EXTERN: \"C\" void g_type_default_interface_unref( void * g_iface );", "	( g_iface -- )" );
	swigFunction( "c-function g_type_children g_type_children n a -- a", "FUNCTION: g_type_children ( type n_children -- a )", "EXTERN: \"C\" void * g_type_children( n type, void * n_children );", "	( type n_children -- )" );
	swigFunction( "c-function g_type_interfaces g_type_interfaces n a -- a", "FUNCTION: g_type_interfaces ( type n_interfaces -- a )", "EXTERN: \"C\" void * g_type_interfaces( n type, void * n_interfaces );", "	( type n_interfaces -- )" );
	swigFunction( "c-function g_type_set_qdata g_type_set_qdata n n a -- void", "FUNCTION: g_type_set_qdata ( type quark data -- void )", "EXTERN: \"C\" void g_type_set_qdata( n type, n quark, void * data );", "	( type quark data -- )" );
	swigFunction( "c-function g_type_get_qdata g_type_get_qdata n n -- a", "FUNCTION: g_type_get_qdata ( type quark -- a )", "EXTERN: \"C\" void * g_type_get_qdata( n type, n quark );", "	( type quark -- )" );
	swigFunction( "c-function g_type_query g_type_query n a -- void", "FUNCTION: g_type_query ( type query -- void )", "EXTERN: \"C\" void g_type_query( n type, void * query );", "	( type query -- )" );
	swigFunction( "c-function g_type_get_instance_count g_type_get_instance_count n -- n", "FUNCTION: g_type_get_instance_count ( type -- n )", "EXTERN: \"C\" int g_type_get_instance_count( n type );", "	( type -- )" );
	swigFunction( "c-function g_type_register_static g_type_register_static n s a n -- n", "FUNCTION: g_type_register_static ( parent_type type_name info flags -- n )", "EXTERN: \"C\" n g_type_register_static( n parent_type, char * type_name, void * info, int flags );", "	( parent_type type_name info flags -- )" );
	swigFunction( "c-function g_type_register_static_simple g_type_register_static_simple n s u a u a n -- n", "FUNCTION: g_type_register_static_simple ( parent_type type_name class_size class_init instance_size instance_init flags -- n )", "EXTERN: \"C\" n g_type_register_static_simple( n parent_type, char * type_name, int class_size, void * class_init, int instance_size, void * instance_init, int flags );", "	( parent_type type_name class_size class_init instance_size instance_init flags -- )" );
	swigFunction( "c-function g_type_register_dynamic g_type_register_dynamic n s a n -- n", "FUNCTION: g_type_register_dynamic ( parent_type type_name plugin flags -- n )", "EXTERN: \"C\" n g_type_register_dynamic( n parent_type, char * type_name, void * plugin, int flags );", "	( parent_type type_name plugin flags -- )" );
	swigFunction( "c-function g_type_register_fundamental g_type_register_fundamental n s a a n -- n", "FUNCTION: g_type_register_fundamental ( type_id type_name info finfo flags -- n )", "EXTERN: \"C\" n g_type_register_fundamental( n type_id, char * type_name, void * info, void * finfo, int flags );", "	( type_id type_name info finfo flags -- )" );
	swigFunction( "c-function g_type_add_interface_static g_type_add_interface_static n n a -- void", "FUNCTION: g_type_add_interface_static ( instance_type interface_type info -- void )", "EXTERN: \"C\" void g_type_add_interface_static( n instance_type, n interface_type, void * info );", "	( instance_type interface_type info -- )" );
	swigFunction( "c-function g_type_add_interface_dynamic g_type_add_interface_dynamic n n a -- void", "FUNCTION: g_type_add_interface_dynamic ( instance_type interface_type plugin -- void )", "EXTERN: \"C\" void g_type_add_interface_dynamic( n instance_type, n interface_type, void * plugin );", "	( instance_type interface_type plugin -- )" );
	swigFunction( "c-function g_type_interface_add_prerequisite g_type_interface_add_prerequisite n n -- void", "FUNCTION: g_type_interface_add_prerequisite ( interface_type prerequisite_type -- void )", "EXTERN: \"C\" void g_type_interface_add_prerequisite( n interface_type, n prerequisite_type );", "	( interface_type prerequisite_type -- )" );
	swigFunction( "c-function g_type_interface_prerequisites g_type_interface_prerequisites n a -- a", "FUNCTION: g_type_interface_prerequisites ( interface_type n_prerequisites -- a )", "EXTERN: \"C\" void * g_type_interface_prerequisites( n interface_type, void * n_prerequisites );", "	( interface_type n_prerequisites -- )" );
	swigFunction( "c-function g_type_class_add_private g_type_class_add_private a n -- void", "FUNCTION: g_type_class_add_private ( g_class private_size -- void )", "EXTERN: \"C\" void g_type_class_add_private( void * g_class, n private_size );", "	( g_class private_size -- )" );
	swigFunction( "c-function g_type_add_instance_private g_type_add_instance_private n n -- n", "FUNCTION: g_type_add_instance_private ( class_type private_size -- n )", "EXTERN: \"C\" int g_type_add_instance_private( n class_type, n private_size );", "	( class_type private_size -- )" );
	swigFunction( "c-function g_type_instance_get_private g_type_instance_get_private a n -- a", "FUNCTION: g_type_instance_get_private ( instance private_type -- a )", "EXTERN: \"C\" void * g_type_instance_get_private( void * instance, n private_type );", "	( instance private_type -- )" );
	swigFunction( "c-function g_type_class_adjust_private_offset g_type_class_adjust_private_offset a a -- void", "FUNCTION: g_type_class_adjust_private_offset ( g_class private_size_or_offset -- void )", "EXTERN: \"C\" void g_type_class_adjust_private_offset( void * g_class, void * private_size_or_offset );", "	( g_class private_size_or_offset -- )" );
	swigFunction( "c-function g_type_add_class_private g_type_add_class_private n n -- void", "FUNCTION: g_type_add_class_private ( class_type private_size -- void )", "EXTERN: \"C\" void g_type_add_class_private( n class_type, n private_size );", "	( class_type private_size -- )" );
	swigFunction( "c-function g_type_class_get_private g_type_class_get_private a n -- a", "FUNCTION: g_type_class_get_private ( klass private_type -- a )", "EXTERN: \"C\" void * g_type_class_get_private( void * klass, n private_type );", "	( klass private_type -- )" );
	swigFunction( "c-function g_type_class_get_instance_private_offset g_type_class_get_instance_private_offset a -- n", "FUNCTION: g_type_class_get_instance_private_offset ( g_class -- n )", "EXTERN: \"C\" int g_type_class_get_instance_private_offset( void * g_class );", "	( g_class -- )" );
	swigFunction( "c-function g_type_ensure g_type_ensure n -- void", "FUNCTION: g_type_ensure ( type -- void )", "EXTERN: \"C\" void g_type_ensure( n type );", "	( type -- )" );
	swigFunction( "c-function g_type_get_type_registration_serial g_type_get_type_registration_serial  -- u", "FUNCTION: g_type_get_type_registration_serial (  -- u )", "EXTERN: \"C\" int g_type_get_type_registration_serial(  );", "	( -- )" );
	swigFunction( "c-function g_type_get_plugin g_type_get_plugin n -- a", "FUNCTION: g_type_get_plugin ( type -- a )", "EXTERN: \"C\" void * g_type_get_plugin( n type );", "	( type -- )" );
	swigFunction( "c-function g_type_interface_get_plugin g_type_interface_get_plugin n n -- a", "FUNCTION: g_type_interface_get_plugin ( instance_type interface_type -- a )", "EXTERN: \"C\" void * g_type_interface_get_plugin( n instance_type, n interface_type );", "	( instance_type interface_type -- )" );
	swigFunction( "c-function g_type_fundamental_next g_type_fundamental_next  -- n", "FUNCTION: g_type_fundamental_next (  -- n )", "EXTERN: \"C\" n g_type_fundamental_next(  );", "	( -- )" );
	swigFunction( "c-function g_type_fundamental g_type_fundamental n -- n", "FUNCTION: g_type_fundamental ( type_id -- n )", "EXTERN: \"C\" n g_type_fundamental( n type_id );", "	( type_id -- )" );
	swigFunction( "c-function g_type_create_instance g_type_create_instance n -- a", "FUNCTION: g_type_create_instance ( type -- a )", "EXTERN: \"C\" void * g_type_create_instance( n type );", "	( type -- )" );
	swigFunction( "c-function g_type_free_instance g_type_free_instance a -- void", "FUNCTION: g_type_free_instance ( instance -- void )", "EXTERN: \"C\" void g_type_free_instance( void * instance );", "	( instance -- )" );
	swigFunction( "c-function g_type_add_class_cache_func g_type_add_class_cache_func a a -- void", "FUNCTION: g_type_add_class_cache_func ( cache_data cache_func -- void )", "EXTERN: \"C\" void g_type_add_class_cache_func( void * cache_data, void * cache_func );", "	( cache_data cache_func -- )" );
	swigFunction( "c-function g_type_remove_class_cache_func g_type_remove_class_cache_func a a -- void", "FUNCTION: g_type_remove_class_cache_func ( cache_data cache_func -- void )", "EXTERN: \"C\" void g_type_remove_class_cache_func( void * cache_data, void * cache_func );", "	( cache_data cache_func -- )" );
	swigFunction( "c-function g_type_class_unref_uncached g_type_class_unref_uncached a -- void", "FUNCTION: g_type_class_unref_uncached ( g_class -- void )", "EXTERN: \"C\" void g_type_class_unref_uncached( void * g_class );", "	( g_class -- )" );
	swigFunction( "c-function g_type_add_interface_check g_type_add_interface_check a a -- void", "FUNCTION: g_type_add_interface_check ( check_data check_func -- void )", "EXTERN: \"C\" void g_type_add_interface_check( void * check_data, void * check_func );", "	( check_data check_func -- )" );
	swigFunction( "c-function g_type_remove_interface_check g_type_remove_interface_check a a -- void", "FUNCTION: g_type_remove_interface_check ( check_data check_func -- void )", "EXTERN: \"C\" void g_type_remove_interface_check( void * check_data, void * check_func );", "	( check_data check_func -- )" );
	swigFunction( "c-function g_type_value_table_peek g_type_value_table_peek n -- a", "FUNCTION: g_type_value_table_peek ( type -- a )", "EXTERN: \"C\" void * g_type_value_table_peek( n type );", "	( type -- )" );
	swigFunction( "c-function g_type_check_instance g_type_check_instance a -- n", "FUNCTION: g_type_check_instance ( instance -- n )", "EXTERN: \"C\" int g_type_check_instance( void * instance );", "	( instance -- )" );
	swigFunction( "c-function g_type_check_instance_cast g_type_check_instance_cast a n -- a", "FUNCTION: g_type_check_instance_cast ( instance iface_type -- a )", "EXTERN: \"C\" void * g_type_check_instance_cast( void * instance, n iface_type );", "	( instance iface_type -- )" );
	swigFunction( "c-function g_type_check_instance_is_a g_type_check_instance_is_a a n -- n", "FUNCTION: g_type_check_instance_is_a ( instance iface_type -- n )", "EXTERN: \"C\" int g_type_check_instance_is_a( void * instance, n iface_type );", "	( instance iface_type -- )" );
	swigFunction( "c-function g_type_check_instance_is_fundamentally_a g_type_check_instance_is_fundamentally_a a n -- n", "FUNCTION: g_type_check_instance_is_fundamentally_a ( instance fundamental_type -- n )", "EXTERN: \"C\" int g_type_check_instance_is_fundamentally_a( void * instance, n fundamental_type );", "	( instance fundamental_type -- )" );
	swigFunction( "c-function g_type_check_class_cast g_type_check_class_cast a n -- a", "FUNCTION: g_type_check_class_cast ( g_class is_a_type -- a )", "EXTERN: \"C\" void * g_type_check_class_cast( void * g_class, n is_a_type );", "	( g_class is_a_type -- )" );
	swigFunction( "c-function g_type_check_class_is_a g_type_check_class_is_a a n -- n", "FUNCTION: g_type_check_class_is_a ( g_class is_a_type -- n )", "EXTERN: \"C\" int g_type_check_class_is_a( void * g_class, n is_a_type );", "	( g_class is_a_type -- )" );
	swigFunction( "c-function g_type_check_is_value_type g_type_check_is_value_type n -- n", "FUNCTION: g_type_check_is_value_type ( type -- n )", "EXTERN: \"C\" int g_type_check_is_value_type( n type );", "	( type -- )" );
	swigFunction( "c-function g_type_check_value g_type_check_value a -- n", "FUNCTION: g_type_check_value ( value -- n )", "EXTERN: \"C\" int g_type_check_value( void * value );", "	( value -- )" );
	swigFunction( "c-function g_type_check_value_holds g_type_check_value_holds a n -- n", "FUNCTION: g_type_check_value_holds ( value type -- n )", "EXTERN: \"C\" int g_type_check_value_holds( void * value, n type );", "	( value type -- )" );
	swigFunction( "c-function g_type_test_flags g_type_test_flags n u -- n", "FUNCTION: g_type_test_flags ( type flags -- n )", "EXTERN: \"C\" int g_type_test_flags( n type, int flags );", "	( type flags -- )" );
	swigFunction( "c-function g_type_name_from_instance g_type_name_from_instance a -- s", "FUNCTION: g_type_name_from_instance ( instance -- s )", "EXTERN: \"C\" char * g_type_name_from_instance( void * instance );", "	( instance -- )" );
	swigFunction( "c-function g_type_name_from_class g_type_name_from_class a -- s", "FUNCTION: g_type_name_from_class ( g_class -- s )", "EXTERN: \"C\" char * g_type_name_from_class( void * g_class );", "	( g_class -- )" );
	swigFunction( "c-function g_initially_unowned_get_type g_initially_unowned_get_type  -- n", "FUNCTION: g_initially_unowned_get_type (  -- n )", "EXTERN: \"C\" n g_initially_unowned_get_type(  );", "	( -- )" );
	swigFunction( "c-function g_object_class_install_property g_object_class_install_property a u a -- void", "FUNCTION: g_object_class_install_property ( oclass property_id pspec -- void )", "EXTERN: \"C\" void g_object_class_install_property( void * oclass, int property_id, void * pspec );", "	( oclass property_id pspec -- )" );
	swigFunction( "c-function g_object_class_find_property g_object_class_find_property a s -- a", "FUNCTION: g_object_class_find_property ( oclass property_name -- a )", "EXTERN: \"C\" void * g_object_class_find_property( void * oclass, char * property_name );", "	( oclass property_name -- )" );
	swigFunction( "c-function g_object_class_list_properties g_object_class_list_properties a a -- a", "FUNCTION: g_object_class_list_properties ( oclass n_properties -- a )", "EXTERN: \"C\" void * g_object_class_list_properties( void * oclass, void * n_properties );", "	( oclass n_properties -- )" );
	swigFunction( "c-function g_object_class_override_property g_object_class_override_property a u s -- void", "FUNCTION: g_object_class_override_property ( oclass property_id name -- void )", "EXTERN: \"C\" void g_object_class_override_property( void * oclass, int property_id, char * name );", "	( oclass property_id name -- )" );
	swigFunction( "c-function g_object_class_install_properties g_object_class_install_properties a u a -- void", "FUNCTION: g_object_class_install_properties ( oclass n_pspecs pspecs -- void )", "EXTERN: \"C\" void g_object_class_install_properties( void * oclass, int n_pspecs, void * pspecs );", "	( oclass n_pspecs pspecs -- )" );
	swigFunction( "c-function g_object_interface_install_property g_object_interface_install_property a a -- void", "FUNCTION: g_object_interface_install_property ( g_iface pspec -- void )", "EXTERN: \"C\" void g_object_interface_install_property( void * g_iface, void * pspec );", "	( g_iface pspec -- )" );
	swigFunction( "c-function g_object_interface_find_property g_object_interface_find_property a s -- a", "FUNCTION: g_object_interface_find_property ( g_iface property_name -- a )", "EXTERN: \"C\" void * g_object_interface_find_property( void * g_iface, char * property_name );", "	( g_iface property_name -- )" );
	swigFunction( "c-function g_object_interface_list_properties g_object_interface_list_properties a a -- a", "FUNCTION: g_object_interface_list_properties ( g_iface n_properties_p -- a )", "EXTERN: \"C\" void * g_object_interface_list_properties( void * g_iface, void * n_properties_p );", "	( g_iface n_properties_p -- )" );
	swigFunction( "c-function g_object_get_type g_object_get_type  -- n", "FUNCTION: g_object_get_type (  -- n )", "EXTERN: \"C\" n g_object_get_type(  );", "	( -- )" );
	swigFunction( "c-function g_object_new g_object_new n s ... -- a", "FUNCTION: g_object_new ( object_type first_property_name  -- a )", "EXTERN: \"C\" void * g_object_new( n object_type, char * first_property_name, ...  );", "	( object_type first_property_name <noname> -- )" );
	swigFunction( "c-function g_object_new_with_properties g_object_new_with_properties n u a a -- a", "FUNCTION: g_object_new_with_properties ( object_type n_properties names values -- a )", "EXTERN: \"C\" void * g_object_new_with_properties( n object_type, int n_properties, void * names, void * values );", "	( object_type n_properties names values -- )" );
	swigFunction( "c-function g_object_newv g_object_newv n u a -- a", "FUNCTION: g_object_newv ( object_type n_parameters parameters -- a )", "EXTERN: \"C\" void * g_object_newv( n object_type, int n_parameters, void * parameters );", "	( object_type n_parameters parameters -- )" );
	swigFunction( "c-function g_object_new_valist g_object_new_valist n s n -- a", "FUNCTION: g_object_new_valist ( object_type first_property_name var_args -- a )", "EXTERN: \"C\" void * g_object_new_valist( n object_type, char * first_property_name, n var_args );", "	( object_type first_property_name var_args -- )" );
	swigFunction( "c-function g_object_set g_object_set a s ... -- void", "FUNCTION: g_object_set ( object first_property_name  -- void )", "EXTERN: \"C\" void g_object_set( void * object, char * first_property_name, ...  );", "	( object first_property_name <noname> -- )" );
	swigFunction( "c-function g_object_get g_object_get a s ... -- void", "FUNCTION: g_object_get ( object first_property_name  -- void )", "EXTERN: \"C\" void g_object_get( void * object, char * first_property_name, ...  );", "	( object first_property_name <noname> -- )" );
	swigFunction( "c-function g_object_connect g_object_connect a s ... -- a", "FUNCTION: g_object_connect ( object signal_spec  -- a )", "EXTERN: \"C\" void * g_object_connect( void * object, char * signal_spec, ...  );", "	( object signal_spec <noname> -- )" );
	swigFunction( "c-function g_object_disconnect g_object_disconnect a s ... -- void", "FUNCTION: g_object_disconnect ( object signal_spec  -- void )", "EXTERN: \"C\" void g_object_disconnect( void * object, char * signal_spec, ...  );", "	( object signal_spec <noname> -- )" );
	swigFunction( "c-function g_object_setv g_object_setv a u a a -- void", "FUNCTION: g_object_setv ( object n_properties names values -- void )", "EXTERN: \"C\" void g_object_setv( void * object, int n_properties, void * names, void * values );", "	( object n_properties names values -- )" );
	swigFunction( "c-function g_object_set_valist g_object_set_valist a s n -- void", "FUNCTION: g_object_set_valist ( object first_property_name var_args -- void )", "EXTERN: \"C\" void g_object_set_valist( void * object, char * first_property_name, n var_args );", "	( object first_property_name var_args -- )" );
	swigFunction( "c-function g_object_getv g_object_getv a u a a -- void", "FUNCTION: g_object_getv ( object n_properties names values -- void )", "EXTERN: \"C\" void g_object_getv( void * object, int n_properties, void * names, void * values );", "	( object n_properties names values -- )" );
	swigFunction( "c-function g_object_get_valist g_object_get_valist a s n -- void", "FUNCTION: g_object_get_valist ( object first_property_name var_args -- void )", "EXTERN: \"C\" void g_object_get_valist( void * object, char * first_property_name, n var_args );", "	( object first_property_name var_args -- )" );
	swigFunction( "c-function g_object_set_property g_object_set_property a s a -- void", "FUNCTION: g_object_set_property ( object property_name value -- void )", "EXTERN: \"C\" void g_object_set_property( void * object, char * property_name, void * value );", "	( object property_name value -- )" );
	swigFunction( "c-function g_object_get_property g_object_get_property a s a -- void", "FUNCTION: g_object_get_property ( object property_name value -- void )", "EXTERN: \"C\" void g_object_get_property( void * object, char * property_name, void * value );", "	( object property_name value -- )" );
	swigFunction( "c-function g_object_freeze_notify g_object_freeze_notify a -- void", "FUNCTION: g_object_freeze_notify ( object -- void )", "EXTERN: \"C\" void g_object_freeze_notify( void * object );", "	( object -- )" );
	swigFunction( "c-function g_object_notify g_object_notify a s -- void", "FUNCTION: g_object_notify ( object property_name -- void )", "EXTERN: \"C\" void g_object_notify( void * object, char * property_name );", "	( object property_name -- )" );
	swigFunction( "c-function g_object_notify_by_pspec g_object_notify_by_pspec a a -- void", "FUNCTION: g_object_notify_by_pspec ( object pspec -- void )", "EXTERN: \"C\" void g_object_notify_by_pspec( void * object, void * pspec );", "	( object pspec -- )" );
	swigFunction( "c-function g_object_thaw_notify g_object_thaw_notify a -- void", "FUNCTION: g_object_thaw_notify ( object -- void )", "EXTERN: \"C\" void g_object_thaw_notify( void * object );", "	( object -- )" );
	swigFunction( "c-function g_object_is_floating g_object_is_floating a -- n", "FUNCTION: g_object_is_floating ( object -- n )", "EXTERN: \"C\" int g_object_is_floating( void * object );", "	( object -- )" );
	swigFunction( "c-function g_object_ref_sink g_object_ref_sink a -- a", "FUNCTION: g_object_ref_sink ( object -- a )", "EXTERN: \"C\" void * g_object_ref_sink( void * object );", "	( object -- )" );
	swigFunction( "c-function g_object_ref g_object_ref a -- a", "FUNCTION: g_object_ref ( object -- a )", "EXTERN: \"C\" void * g_object_ref( void * object );", "	( object -- )" );
	swigFunction( "c-function g_object_unref g_object_unref a -- void", "FUNCTION: g_object_unref ( object -- void )", "EXTERN: \"C\" void g_object_unref( void * object );", "	( object -- )" );
	swigFunction( "c-function g_object_weak_ref g_object_weak_ref a a a -- void", "FUNCTION: g_object_weak_ref ( object notify data -- void )", "EXTERN: \"C\" void g_object_weak_ref( void * object, void * notify, void * data );", "	( object notify data -- )" );
	swigFunction( "c-function g_object_weak_unref g_object_weak_unref a a a -- void", "FUNCTION: g_object_weak_unref ( object notify data -- void )", "EXTERN: \"C\" void g_object_weak_unref( void * object, void * notify, void * data );", "	( object notify data -- )" );
	swigFunction( "c-function g_object_add_weak_pointer g_object_add_weak_pointer a a -- void", "FUNCTION: g_object_add_weak_pointer ( object weak_pointer_location -- void )", "EXTERN: \"C\" void g_object_add_weak_pointer( void * object, void * weak_pointer_location );", "	( object weak_pointer_location -- )" );
	swigFunction( "c-function g_object_remove_weak_pointer g_object_remove_weak_pointer a a -- void", "FUNCTION: g_object_remove_weak_pointer ( object weak_pointer_location -- void )", "EXTERN: \"C\" void g_object_remove_weak_pointer( void * object, void * weak_pointer_location );", "	( object weak_pointer_location -- )" );
	swigFunction( "c-function g_object_add_toggle_ref g_object_add_toggle_ref a a a -- void", "FUNCTION: g_object_add_toggle_ref ( object notify data -- void )", "EXTERN: \"C\" void g_object_add_toggle_ref( void * object, void * notify, void * data );", "	( object notify data -- )" );
	swigFunction( "c-function g_object_remove_toggle_ref g_object_remove_toggle_ref a a a -- void", "FUNCTION: g_object_remove_toggle_ref ( object notify data -- void )", "EXTERN: \"C\" void g_object_remove_toggle_ref( void * object, void * notify, void * data );", "	( object notify data -- )" );
	swigFunction( "c-function g_object_get_qdata g_object_get_qdata a n -- a", "FUNCTION: g_object_get_qdata ( object quark -- a )", "EXTERN: \"C\" void * g_object_get_qdata( void * object, n quark );", "	( object quark -- )" );
	swigFunction( "c-function g_object_set_qdata g_object_set_qdata a n a -- void", "FUNCTION: g_object_set_qdata ( object quark data -- void )", "EXTERN: \"C\" void g_object_set_qdata( void * object, n quark, void * data );", "	( object quark data -- )" );
	swigFunction( "c-function g_object_set_qdata_full g_object_set_qdata_full a n a a -- void", "FUNCTION: g_object_set_qdata_full ( object quark data destroy -- void )", "EXTERN: \"C\" void g_object_set_qdata_full( void * object, n quark, void * data, void * destroy );", "	( object quark data destroy -- )" );
	swigFunction( "c-function g_object_steal_qdata g_object_steal_qdata a n -- a", "FUNCTION: g_object_steal_qdata ( object quark -- a )", "EXTERN: \"C\" void * g_object_steal_qdata( void * object, n quark );", "	( object quark -- )" );
	swigFunction( "c-function g_object_dup_qdata g_object_dup_qdata a n a a -- a", "FUNCTION: g_object_dup_qdata ( object quark dup_func user_data -- a )", "EXTERN: \"C\" void * g_object_dup_qdata( void * object, n quark, void * dup_func, void * user_data );", "	( object quark dup_func user_data -- )" );
	swigFunction( "c-function g_object_replace_qdata g_object_replace_qdata a n a a a a -- n", "FUNCTION: g_object_replace_qdata ( object quark oldval newval destroy old_destroy -- n )", "EXTERN: \"C\" int g_object_replace_qdata( void * object, n quark, void * oldval, void * newval, void * destroy, void * old_destroy );", "	( object quark oldval newval destroy old_destroy -- )" );
	swigFunction( "c-function g_object_get_data g_object_get_data a s -- a", "FUNCTION: g_object_get_data ( object key -- a )", "EXTERN: \"C\" void * g_object_get_data( void * object, char * key );", "	( object key -- )" );
	swigFunction( "c-function g_object_set_data g_object_set_data a s a -- void", "FUNCTION: g_object_set_data ( object key data -- void )", "EXTERN: \"C\" void g_object_set_data( void * object, char * key, void * data );", "	( object key data -- )" );
	swigFunction( "c-function g_object_set_data_full g_object_set_data_full a s a a -- void", "FUNCTION: g_object_set_data_full ( object key data destroy -- void )", "EXTERN: \"C\" void g_object_set_data_full( void * object, char * key, void * data, void * destroy );", "	( object key data destroy -- )" );
	swigFunction( "c-function g_object_steal_data g_object_steal_data a s -- a", "FUNCTION: g_object_steal_data ( object key -- a )", "EXTERN: \"C\" void * g_object_steal_data( void * object, char * key );", "	( object key -- )" );
	swigFunction( "c-function g_object_dup_data g_object_dup_data a s a a -- a", "FUNCTION: g_object_dup_data ( object key dup_func user_data -- a )", "EXTERN: \"C\" void * g_object_dup_data( void * object, char * key, void * dup_func, void * user_data );", "	( object key dup_func user_data -- )" );
	swigFunction( "c-function g_object_replace_data g_object_replace_data a s a a a a -- n", "FUNCTION: g_object_replace_data ( object key oldval newval destroy old_destroy -- n )", "EXTERN: \"C\" int g_object_replace_data( void * object, char * key, void * oldval, void * newval, void * destroy, void * old_destroy );", "	( object key oldval newval destroy old_destroy -- )" );
	swigFunction( "c-function g_object_watch_closure g_object_watch_closure a a -- void", "FUNCTION: g_object_watch_closure ( object closure -- void )", "EXTERN: \"C\" void g_object_watch_closure( void * object, void * closure );", "	( object closure -- )" );
	swigFunction( "c-function g_cclosure_new_object g_cclosure_new_object a a -- a", "FUNCTION: g_cclosure_new_object ( callback_func object -- a )", "EXTERN: \"C\" void * g_cclosure_new_object( void * callback_func, void * object );", "	( callback_func object -- )" );
	swigFunction( "c-function g_cclosure_new_object_swap g_cclosure_new_object_swap a a -- a", "FUNCTION: g_cclosure_new_object_swap ( callback_func object -- a )", "EXTERN: \"C\" void * g_cclosure_new_object_swap( void * callback_func, void * object );", "	( callback_func object -- )" );
	swigFunction( "c-function g_closure_new_object g_closure_new_object u a -- a", "FUNCTION: g_closure_new_object ( sizeof_closure object -- a )", "EXTERN: \"C\" void * g_closure_new_object( int sizeof_closure, void * object );", "	( sizeof_closure object -- )" );
	swigFunction( "c-function g_value_set_object g_value_set_object a a -- void", "FUNCTION: g_value_set_object ( value v_object -- void )", "EXTERN: \"C\" void g_value_set_object( void * value, void * v_object );", "	( value v_object -- )" );
	swigFunction( "c-function g_value_get_object g_value_get_object a -- a", "FUNCTION: g_value_get_object ( value -- a )", "EXTERN: \"C\" void * g_value_get_object( void * value );", "	( value -- )" );
	swigFunction( "c-function g_value_dup_object g_value_dup_object a -- a", "FUNCTION: g_value_dup_object ( value -- a )", "EXTERN: \"C\" void * g_value_dup_object( void * value );", "	( value -- )" );
	swigFunction( "c-function g_signal_connect_object g_signal_connect_object a s a a n -- u", "FUNCTION: g_signal_connect_object ( instance detailed_signal c_handler gobject connect_flags -- u )", "EXTERN: \"C\" long g_signal_connect_object( void * instance, char * detailed_signal, void * c_handler, void * gobject, int connect_flags );", "	( instance detailed_signal c_handler gobject connect_flags -- )" );
	swigFunction( "c-function g_object_force_floating g_object_force_floating a -- void", "FUNCTION: g_object_force_floating ( object -- void )", "EXTERN: \"C\" void g_object_force_floating( void * object );", "	( object -- )" );
	swigFunction( "c-function g_object_run_dispose g_object_run_dispose a -- void", "FUNCTION: g_object_run_dispose ( object -- void )", "EXTERN: \"C\" void g_object_run_dispose( void * object );", "	( object -- )" );
	swigFunction( "c-function g_value_take_object g_value_take_object a a -- void", "FUNCTION: g_value_take_object ( value v_object -- void )", "EXTERN: \"C\" void g_value_take_object( void * value, void * v_object );", "	( value v_object -- )" );
	swigFunction( "c-function g_value_set_object_take_ownership g_value_set_object_take_ownership a a -- void", "FUNCTION: g_value_set_object_take_ownership ( value v_object -- void )", "EXTERN: \"C\" void g_value_set_object_take_ownership( void * value, void * v_object );", "	( value v_object -- )" );
	swigFunction( "c-function g_object_compat_control g_object_compat_control n a -- n", "FUNCTION: g_object_compat_control ( what data -- n )", "EXTERN: \"C\" n g_object_compat_control( n what, void * data );", "	( what data -- )" );
	swigFunction( "c-function g_clear_object g_clear_object a -- void", "FUNCTION: g_clear_object ( object_ptr -- void )", "EXTERN: \"C\" void g_clear_object( void * object_ptr );", "	( object_ptr -- )" );
	swigFunction( "c-function g_set_object g_set_object a a -- n", "FUNCTION: g_set_object ( object_ptr new_object -- n )", "EXTERN: \"C\" int g_set_object( void * object_ptr, void * new_object );", "	( object_ptr new_object -- )" );
	swigFunction( "c-function g_clear_weak_pointer g_clear_weak_pointer a -- void", "FUNCTION: g_clear_weak_pointer ( weak_pointer_location -- void )", "EXTERN: \"C\" void g_clear_weak_pointer( void * weak_pointer_location );", "	( weak_pointer_location -- )" );
	swigFunction( "c-function g_set_weak_pointer g_set_weak_pointer a a -- n", "FUNCTION: g_set_weak_pointer ( weak_pointer_location new_object -- n )", "EXTERN: \"C\" int g_set_weak_pointer( void * weak_pointer_location, void * new_object );", "	( weak_pointer_location new_object -- )" );
	swigFunction( "c-function g_weak_ref_init g_weak_ref_init a a -- void", "FUNCTION: g_weak_ref_init ( weak_ref object -- void )", "EXTERN: \"C\" void g_weak_ref_init( void * weak_ref, void * object );", "	( weak_ref object -- )" );
	swigFunction( "c-function g_weak_ref_clear g_weak_ref_clear a -- void", "FUNCTION: g_weak_ref_clear ( weak_ref -- void )", "EXTERN: \"C\" void g_weak_ref_clear( void * weak_ref );", "	( weak_ref -- )" );
	swigFunction( "c-function g_weak_ref_get g_weak_ref_get a -- a", "FUNCTION: g_weak_ref_get ( weak_ref -- a )", "EXTERN: \"C\" void * g_weak_ref_get( void * weak_ref );", "	( weak_ref -- )" );
	swigFunction( "c-function g_weak_ref_set g_weak_ref_set a a -- void", "FUNCTION: g_weak_ref_set ( weak_ref object -- void )", "EXTERN: \"C\" void g_weak_ref_set( void * weak_ref, void * object );", "	( weak_ref object -- )" );
	swigFunction( "c-function g_signal_newv g_signal_newv s n n a a a a n u a -- u", "FUNCTION: g_signal_newv ( signal_name itype signal_flags class_closure accumulator accu_data c_marshaller return_type n_params param_types -- u )", "EXTERN: \"C\" int g_signal_newv( char * signal_name, n itype, int signal_flags, void * class_closure, void * accumulator, void * accu_data, void * c_marshaller, n return_type, int n_params, void * param_types );", "	( signal_name itype signal_flags class_closure accumulator accu_data c_marshaller return_type n_params param_types -- )" );
	swigFunction( "c-function g_signal_new_valist g_signal_new_valist s n n a a a a n u n -- u", "FUNCTION: g_signal_new_valist ( signal_name itype signal_flags class_closure accumulator accu_data c_marshaller return_type n_params args -- u )", "EXTERN: \"C\" int g_signal_new_valist( char * signal_name, n itype, int signal_flags, void * class_closure, void * accumulator, void * accu_data, void * c_marshaller, n return_type, int n_params, n args );", "	( signal_name itype signal_flags class_closure accumulator accu_data c_marshaller return_type n_params args -- )" );
	swigFunction( "c-function g_signal_new g_signal_new s n n u a a a n u ... -- u", "FUNCTION: g_signal_new ( signal_name itype signal_flags class_offset accumulator accu_data c_marshaller return_type n_params  -- u )", "EXTERN: \"C\" int g_signal_new( char * signal_name, n itype, int signal_flags, int class_offset, void * accumulator, void * accu_data, void * c_marshaller, n return_type, int n_params, ...  );", "	( signal_name itype signal_flags class_offset accumulator accu_data c_marshaller return_type n_params <noname> -- )" );
	swigFunction( "c-function g_signal_new_class_handler g_signal_new_class_handler s n n a a a a n u ... -- u", "FUNCTION: g_signal_new_class_handler ( signal_name itype signal_flags class_handler accumulator accu_data c_marshaller return_type n_params  -- u )", "EXTERN: \"C\" int g_signal_new_class_handler( char * signal_name, n itype, int signal_flags, void * class_handler, void * accumulator, void * accu_data, void * c_marshaller, n return_type, int n_params, ...  );", "	( signal_name itype signal_flags class_handler accumulator accu_data c_marshaller return_type n_params <noname> -- )" );
	swigFunction( "c-function g_signal_set_va_marshaller g_signal_set_va_marshaller u n a -- void", "FUNCTION: g_signal_set_va_marshaller ( signal_id instance_type va_marshaller -- void )", "EXTERN: \"C\" void g_signal_set_va_marshaller( int signal_id, n instance_type, void * va_marshaller );", "	( signal_id instance_type va_marshaller -- )" );
	swigFunction( "c-function g_signal_emitv g_signal_emitv a u n a -- void", "FUNCTION: g_signal_emitv ( instance_and_params signal_id detail return_value -- void )", "EXTERN: \"C\" void g_signal_emitv( void * instance_and_params, int signal_id, n detail, void * return_value );", "	( instance_and_params signal_id detail return_value -- )" );
	swigFunction( "c-function g_signal_emit_valist g_signal_emit_valist a u n n -- void", "FUNCTION: g_signal_emit_valist ( instance signal_id detail var_args -- void )", "EXTERN: \"C\" void g_signal_emit_valist( void * instance, int signal_id, n detail, n var_args );", "	( instance signal_id detail var_args -- )" );
	swigFunction( "c-function g_signal_emit g_signal_emit a u n ... -- void", "FUNCTION: g_signal_emit ( instance signal_id detail  -- void )", "EXTERN: \"C\" void g_signal_emit( void * instance, int signal_id, n detail, ...  );", "	( instance signal_id detail <noname> -- )" );
	swigFunction( "c-function g_signal_emit_by_name g_signal_emit_by_name a s ... -- void", "FUNCTION: g_signal_emit_by_name ( instance detailed_signal  -- void )", "EXTERN: \"C\" void g_signal_emit_by_name( void * instance, char * detailed_signal, ...  );", "	( instance detailed_signal <noname> -- )" );
	swigFunction( "c-function g_signal_lookup g_signal_lookup s n -- u", "FUNCTION: g_signal_lookup ( name itype -- u )", "EXTERN: \"C\" int g_signal_lookup( char * name, n itype );", "	( name itype -- )" );
	swigFunction( "c-function g_signal_name g_signal_name u -- s", "FUNCTION: g_signal_name ( signal_id -- s )", "EXTERN: \"C\" char * g_signal_name( int signal_id );", "	( signal_id -- )" );
	swigFunction( "c-function g_signal_query g_signal_query u a -- void", "FUNCTION: g_signal_query ( signal_id query -- void )", "EXTERN: \"C\" void g_signal_query( int signal_id, void * query );", "	( signal_id query -- )" );
	swigFunction( "c-function g_signal_list_ids g_signal_list_ids n a -- a", "FUNCTION: g_signal_list_ids ( itype n_ids -- a )", "EXTERN: \"C\" void * g_signal_list_ids( n itype, void * n_ids );", "	( itype n_ids -- )" );
	swigFunction( "c-function g_signal_parse_name g_signal_parse_name s n a a n -- n", "FUNCTION: g_signal_parse_name ( detailed_signal itype signal_id_p detail_p force_detail_quark -- n )", "EXTERN: \"C\" int g_signal_parse_name( char * detailed_signal, n itype, void * signal_id_p, void * detail_p, int force_detail_quark );", "	( detailed_signal itype signal_id_p detail_p force_detail_quark -- )" );
	swigFunction( "c-function g_signal_get_invocation_hint g_signal_get_invocation_hint a -- a", "FUNCTION: g_signal_get_invocation_hint ( instance -- a )", "EXTERN: \"C\" void * g_signal_get_invocation_hint( void * instance );", "	( instance -- )" );
	swigFunction( "c-function g_signal_stop_emission g_signal_stop_emission a u n -- void", "FUNCTION: g_signal_stop_emission ( instance signal_id detail -- void )", "EXTERN: \"C\" void g_signal_stop_emission( void * instance, int signal_id, n detail );", "	( instance signal_id detail -- )" );
	swigFunction( "c-function g_signal_stop_emission_by_name g_signal_stop_emission_by_name a s -- void", "FUNCTION: g_signal_stop_emission_by_name ( instance detailed_signal -- void )", "EXTERN: \"C\" void g_signal_stop_emission_by_name( void * instance, char * detailed_signal );", "	( instance detailed_signal -- )" );
	swigFunction( "c-function g_signal_add_emission_hook g_signal_add_emission_hook u n a a a -- u", "FUNCTION: g_signal_add_emission_hook ( signal_id detail hook_func hook_data data_destroy -- u )", "EXTERN: \"C\" long g_signal_add_emission_hook( int signal_id, n detail, void * hook_func, void * hook_data, void * data_destroy );", "	( signal_id detail hook_func hook_data data_destroy -- )" );
	swigFunction( "c-function g_signal_remove_emission_hook g_signal_remove_emission_hook u u -- void", "FUNCTION: g_signal_remove_emission_hook ( signal_id hook_id -- void )", "EXTERN: \"C\" void g_signal_remove_emission_hook( int signal_id, long hook_id );", "	( signal_id hook_id -- )" );
	swigFunction( "c-function g_signal_has_handler_pending g_signal_has_handler_pending a u n n -- n", "FUNCTION: g_signal_has_handler_pending ( instance signal_id detail may_be_blocked -- n )", "EXTERN: \"C\" int g_signal_has_handler_pending( void * instance, int signal_id, n detail, int may_be_blocked );", "	( instance signal_id detail may_be_blocked -- )" );
	swigFunction( "c-function g_signal_connect_closure_by_id g_signal_connect_closure_by_id a u n a n -- u", "FUNCTION: g_signal_connect_closure_by_id ( instance signal_id detail closure after -- u )", "EXTERN: \"C\" long g_signal_connect_closure_by_id( void * instance, int signal_id, n detail, void * closure, int after );", "	( instance signal_id detail closure after -- )" );
	swigFunction( "c-function g_signal_connect_closure g_signal_connect_closure a s a n -- u", "FUNCTION: g_signal_connect_closure ( instance detailed_signal closure after -- u )", "EXTERN: \"C\" long g_signal_connect_closure( void * instance, char * detailed_signal, void * closure, int after );", "	( instance detailed_signal closure after -- )" );
	swigFunction( "c-function g_signal_connect_data g_signal_connect_data a s a a a n -- u", "FUNCTION: g_signal_connect_data ( instance detailed_signal c_handler data destroy_data connect_flags -- u )", "EXTERN: \"C\" long g_signal_connect_data( void * instance, char * detailed_signal, void * c_handler, void * data, void * destroy_data, int connect_flags );", "	( instance detailed_signal c_handler data destroy_data connect_flags -- )" );
	swigFunction( "c-function g_signal_handler_block g_signal_handler_block a u -- void", "FUNCTION: g_signal_handler_block ( instance handler_id -- void )", "EXTERN: \"C\" void g_signal_handler_block( void * instance, long handler_id );", "	( instance handler_id -- )" );
	swigFunction( "c-function g_signal_handler_unblock g_signal_handler_unblock a u -- void", "FUNCTION: g_signal_handler_unblock ( instance handler_id -- void )", "EXTERN: \"C\" void g_signal_handler_unblock( void * instance, long handler_id );", "	( instance handler_id -- )" );
	swigFunction( "c-function g_signal_handler_disconnect g_signal_handler_disconnect a u -- void", "FUNCTION: g_signal_handler_disconnect ( instance handler_id -- void )", "EXTERN: \"C\" void g_signal_handler_disconnect( void * instance, long handler_id );", "	( instance handler_id -- )" );
	swigFunction( "c-function g_signal_handler_is_connected g_signal_handler_is_connected a u -- n", "FUNCTION: g_signal_handler_is_connected ( instance handler_id -- n )", "EXTERN: \"C\" int g_signal_handler_is_connected( void * instance, long handler_id );", "	( instance handler_id -- )" );
	swigFunction( "c-function g_signal_handler_find g_signal_handler_find a n u n a a a -- u", "FUNCTION: g_signal_handler_find ( instance mask signal_id detail closure func data -- u )", "EXTERN: \"C\" long g_signal_handler_find( void * instance, int mask, int signal_id, n detail, void * closure, void * func, void * data );", "	( instance mask signal_id detail closure func data -- )" );
	swigFunction( "c-function g_signal_handlers_block_matched g_signal_handlers_block_matched a n u n a a a -- u", "FUNCTION: g_signal_handlers_block_matched ( instance mask signal_id detail closure func data -- u )", "EXTERN: \"C\" int g_signal_handlers_block_matched( void * instance, int mask, int signal_id, n detail, void * closure, void * func, void * data );", "	( instance mask signal_id detail closure func data -- )" );
	swigFunction( "c-function g_signal_handlers_unblock_matched g_signal_handlers_unblock_matched a n u n a a a -- u", "FUNCTION: g_signal_handlers_unblock_matched ( instance mask signal_id detail closure func data -- u )", "EXTERN: \"C\" int g_signal_handlers_unblock_matched( void * instance, int mask, int signal_id, n detail, void * closure, void * func, void * data );", "	( instance mask signal_id detail closure func data -- )" );
	swigFunction( "c-function g_signal_handlers_disconnect_matched g_signal_handlers_disconnect_matched a n u n a a a -- u", "FUNCTION: g_signal_handlers_disconnect_matched ( instance mask signal_id detail closure func data -- u )", "EXTERN: \"C\" int g_signal_handlers_disconnect_matched( void * instance, int mask, int signal_id, n detail, void * closure, void * func, void * data );", "	( instance mask signal_id detail closure func data -- )" );
	swigFunction( "c-function g_signal_override_class_closure g_signal_override_class_closure u n a -- void", "FUNCTION: g_signal_override_class_closure ( signal_id instance_type class_closure -- void )", "EXTERN: \"C\" void g_signal_override_class_closure( int signal_id, n instance_type, void * class_closure );", "	( signal_id instance_type class_closure -- )" );
	swigFunction( "c-function g_signal_override_class_handler g_signal_override_class_handler s n a -- void", "FUNCTION: g_signal_override_class_handler ( signal_name instance_type class_handler -- void )", "EXTERN: \"C\" void g_signal_override_class_handler( char * signal_name, n instance_type, void * class_handler );", "	( signal_name instance_type class_handler -- )" );
	swigFunction( "c-function g_signal_chain_from_overridden g_signal_chain_from_overridden a a -- void", "FUNCTION: g_signal_chain_from_overridden ( instance_and_params return_value -- void )", "EXTERN: \"C\" void g_signal_chain_from_overridden( void * instance_and_params, void * return_value );", "	( instance_and_params return_value -- )" );
	swigFunction( "c-function g_signal_chain_from_overridden_handler g_signal_chain_from_overridden_handler a ... -- void", "FUNCTION: g_signal_chain_from_overridden_handler ( instance  -- void )", "EXTERN: \"C\" void g_signal_chain_from_overridden_handler( void * instance, ...  );", "	( instance <noname> -- )" );
	swigFunction( "c-function g_signal_accumulator_true_handled g_signal_accumulator_true_handled a a a a -- n", "FUNCTION: g_signal_accumulator_true_handled ( ihint return_accu handler_return dummy -- n )", "EXTERN: \"C\" int g_signal_accumulator_true_handled( void * ihint, void * return_accu, void * handler_return, void * dummy );", "	( ihint return_accu handler_return dummy -- )" );
	swigFunction( "c-function g_signal_accumulator_first_wins g_signal_accumulator_first_wins a a a a -- n", "FUNCTION: g_signal_accumulator_first_wins ( ihint return_accu handler_return dummy -- n )", "EXTERN: \"C\" int g_signal_accumulator_first_wins( void * ihint, void * return_accu, void * handler_return, void * dummy );", "	( ihint return_accu handler_return dummy -- )" );
	swigFunction( "c-function g_signal_handlers_destroy g_signal_handlers_destroy a -- void", "FUNCTION: g_signal_handlers_destroy ( instance -- void )", "EXTERN: \"C\" void g_signal_handlers_destroy( void * instance );", "	( instance -- )" );
	swigFunction( "c-function _g_signals_destroy _g_signals_destroy n -- void", "FUNCTION: _g_signals_destroy ( itype -- void )", "EXTERN: \"C\" void _g_signals_destroy( n itype );", "	( itype -- )" );

	swigNewline();

	swigComment("----===< postfix >===-----\n");

	swigPrint( "end-c-library", "( none )", "( none )" );
	
	return 0;
} /* end of main */



