/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 3.0.9
 *
 * This file is not intended to be easily readable and contains a number of
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG
 * interface file instead.
 * ----------------------------------------------------------------------------- */
#include <stdio.h>
#include <string.h>
#include <stddef.h>



#define JNINativeInterface_ JNINativeInterface
#define JNIInvokeInterface_ JNIInvokeInterface
#include <jni.h>
#ifdef __gnu_linux__
#undef stderr
extern struct _IO_FILE *stderr;
#endif

typedef enum{ NONE = -1, GFORTH = 0, SWIFTFORTH, VFX } SwigTargetSystem;
SwigTargetSystem swigTargetSystem = NONE;

unsigned char swigPrintStackComments = 1;

/* comments */
void swigNewline()
{
	printf( "\n" );
}

void swigComment( char *comment )
{
	printf( "\\ %s", comment );
}

/* constants */
void swigIntConstant( long constant, char *name )
{
	printf( "#%ld\tconstant %s\n", constant, name );
}

void swigUnsignedIntConstant( unsigned long constant, char *name )
{
	printf( "#%lu\tconstant %s\n", constant, name );
}

void swigLongConstant( long long constant, char *name )
{
	printf( "#%lld.\t2constant %s\n", constant, name );
}

void swigUnsignedLongConstant( unsigned long long constant, char *name )
{
	printf( "#%llu.\t2constant %s\n", constant, name );
}

void swigFloatConstant( double constant, char *name )
{
	char buffer[128];
	sprintf( buffer, "%f", constant );

	/* if the constant contains no exponent, add one */
	char *s;
	for( s = buffer; *s != 0; s++ )
		if( *s == 'e' || *s == 'E' )
			break;

	/* exponent found */
	if( *s != 0 )
		printf( "%s\tfconstant %s\n", buffer, name );
	/* not found */
	else
		printf( "%se0\tfconstant %s\n", buffer, name );
}

void swigStringConstant( char* constant, char *name )
{
	char c;
	printf( ": %s s\\\" ", name );
	while(( c = *constant++ ))
	{
		switch(c)
		{
			case '\b': printf( "\\b" ); break;
			case '\n': printf( "\\n" ); break;
			case '\f': printf( "\\f" ); break;
			case '\r': printf( "\\r" ); break;
			case '\t': printf( "\\t" ); break;
			case '"' : printf( "\\q" ); break;
			default:
				if(c < 0x20)
					printf("\\x%02x", c);
				else
					printf("%c", c); break;
		}
	}
	printf(	"\" ;\n" );
}

/* structs */
void swigStructField( char *name, size_t offset, size_t size )
{
	printf( "\tdrop %zu %zu +field %s\n", offset, size, name );
}

/* functions */
void swigFunction( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	if( swigTargetSystem == GFORTH )
		printf( "%s", gforth );
	else if( swigTargetSystem == SWIFTFORTH )
		printf( "%s", swiftForth );
	else if( swigTargetSystem == VFX )
		printf( "%s", vfx );

	if( swigPrintStackComments )
		printf( "%s", stackComment );

	printf( "\n" );
}

/* function pointers */
void swigFunctionPointer( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	swigFunction( gforth, swiftForth, vfx, stackComment );
}

/* callbacks */
void swigCallback( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	swigFunction( gforth, swiftForth, vfx, stackComment );
}

void swigUsage( char **argv )
{
	fprintf( stderr, "Usage: %s [-gforth|-swiftforth|-vfx]\n", argv[0] );
}

int main( int argc, char **argv )
{
	int i;

	/* check arguments */
	for( i = 1; i < argc; i++ )
		if( strcmp( argv[i], "-gforth" ) == 0 )
			swigTargetSystem = GFORTH;
		else if( strcmp( argv[i], "-swiftforth" ) == 0 )
			swigTargetSystem = SWIFTFORTH;
		else if( strcmp( argv[i], "-vfx" ) == 0 )
			swigTargetSystem = VFX;

	if( swigTargetSystem == NONE )
	{
		fprintf( stderr, "Error: no target system specified\n" );
		swigUsage( argv );
		return 1;
	}

	/* primer */
	printf( "\\ This file has been generated using SWIG and fsi,\n"
		"\\ and is already platform dependent, search for the corresponding\n"
		"\\ fsi-file to compile it where no one has compiled it before ;)\n"
		"\\ GForth has its own dynamic loader and doesn't need addional C-Code.\n"
		"\\ That's why this file contains normal Gforth-code( version 0.6.9 or higher )\n"
		"\\ and could be used directly with include or require.\n"
		"\\ As all comments are stripped during the compilation, please\n"
		"\\ insert the copyright notice of the original file here.\n"
	);



	swigNewline();

	swigComment("----===< int constants ===>-----\n");
	#ifdef JNI_TRUE
		swigIntConstant( JNI_TRUE, "JNI_TRUE" );
	#endif
	#ifdef JNI_FALSE
		swigIntConstant( JNI_FALSE, "JNI_FALSE" );
	#endif
	#ifdef JNI_VERSION_1_1
		swigIntConstant( JNI_VERSION_1_1, "JNI_VERSION_1_1" );
	#endif
	#ifdef JNI_VERSION_1_2
		swigIntConstant( JNI_VERSION_1_2, "JNI_VERSION_1_2" );
	#endif
	#ifdef JNI_VERSION_1_4
		swigIntConstant( JNI_VERSION_1_4, "JNI_VERSION_1_4" );
	#endif
	#ifdef JNI_VERSION_1_6
		swigIntConstant( JNI_VERSION_1_6, "JNI_VERSION_1_6" );
	#endif
	#ifdef JNI_COMMIT
		swigIntConstant( JNI_COMMIT, "JNI_COMMIT" );
	#endif
	#ifdef JNI_ABORT
		swigIntConstant( JNI_ABORT, "JNI_ABORT" );
	#endif
	#ifdef JNI_OK
		swigIntConstant( JNI_OK, "JNI_OK" );
	#endif
	#ifdef JNI_ERR
		swigIntConstant( JNI_ERR, "JNI_ERR" );
	#endif
	#ifdef JNI_EDETACHED
		swigIntConstant( JNI_EDETACHED, "JNI_EDETACHED" );
	#endif
	#ifdef JNI_EVERSION
		swigIntConstant( JNI_EVERSION, "JNI_EVERSION" );
	#endif

	swigNewline();

	swigComment("--------===< enums >===---------\n");
	swigIntConstant( JNIInvalidRefType, "JNIInvalidRefType" );
	swigIntConstant( JNILocalRefType, "JNILocalRefType" );
	swigIntConstant( JNIGlobalRefType, "JNIGlobalRefType" );
	swigIntConstant( JNIWeakGlobalRefType, "JNIWeakGlobalRefType" );

	swigNewline();

	swigComment("-------===< structs >===--------\n");

	swigComment("jvalue\n");
	printf( "begin-structure jvalue\n" );
	swigStructField( "jvalue-b", offsetof( union jvalue, b ), sizeof( jbyte ) );
	swigStructField( "jvalue-i", offsetof( union jvalue, i ), sizeof( jint ) );
	swigStructField( "jvalue-c", offsetof( union jvalue, c ), sizeof( jchar ) );
	swigStructField( "jvalue-j", offsetof( union jvalue, j ), sizeof( jlong ) );
	swigStructField( "jvalue-d", offsetof( union jvalue, d ), sizeof( jdouble ) );
	swigStructField( "jvalue-z", offsetof( union jvalue, z ), sizeof( jboolean ) );
	swigStructField( "jvalue-s", offsetof( union jvalue, s ), sizeof( jshort ) );
	swigStructField( "jvalue-l", offsetof( union jvalue, l ), sizeof( jobject ) );
	swigStructField( "jvalue-f", offsetof( union jvalue, f ), sizeof( jfloat ) );
	printf( "drop %zu end-structure\n", sizeof( union jvalue ) );

	swigComment("JNINativeMethod\n");
	printf( "begin-structure JNINativeMethod\n" );
	swigStructField( "JNINativeMethod-signature", offsetof( JNINativeMethod, signature ), sizeof( char * ) );
	swigStructField( "JNINativeMethod-name", offsetof( JNINativeMethod, name ), sizeof( char * ) );
	swigStructField( "JNINativeMethod-fnPtr", offsetof( JNINativeMethod, fnPtr ), sizeof( void * ) );
	printf( "drop %zu end-structure\n", sizeof( JNINativeMethod ) );

	swigComment("JNINativeInterface\n");
	printf( "begin-structure JNINativeInterface\n" );
	swigStructField( "JNINativeInterface-IsAssignableFrom", offsetof( struct JNINativeInterface, IsAssignableFrom ), sizeof( jboolean (*)(JNIEnv *,jclass,jclass) ) );
	swigStructField( "JNINativeInterface-SetStaticBooleanField", offsetof( struct JNINativeInterface, SetStaticBooleanField ), sizeof( void (*)(JNIEnv *,jclass,jfieldID,jboolean) ) );
	swigStructField( "JNINativeInterface-GetStaticBooleanField", offsetof( struct JNINativeInterface, GetStaticBooleanField ), sizeof( jboolean (*)(JNIEnv *,jclass,jfieldID) ) );
	swigStructField( "JNINativeInterface-SetBooleanField", offsetof( struct JNINativeInterface, SetBooleanField ), sizeof( void (*)(JNIEnv *,jobject,jfieldID,jboolean) ) );
	swigStructField( "JNINativeInterface-GetBooleanField", offsetof( struct JNINativeInterface, GetBooleanField ), sizeof( jboolean (*)(JNIEnv *,jobject,jfieldID) ) );
	swigStructField( "JNINativeInterface-reserved0", offsetof( struct JNINativeInterface, reserved0 ), sizeof( void * ) );
	swigStructField( "JNINativeInterface-reserved1", offsetof( struct JNINativeInterface, reserved1 ), sizeof( void * ) );
	swigStructField( "JNINativeInterface-NewBooleanArray", offsetof( struct JNINativeInterface, NewBooleanArray ), sizeof( jbooleanArray (*)(JNIEnv *,jsize) ) );
	swigStructField( "JNINativeInterface-reserved2", offsetof( struct JNINativeInterface, reserved2 ), sizeof( void * ) );
	swigStructField( "JNINativeInterface-reserved3", offsetof( struct JNINativeInterface, reserved3 ), sizeof( void * ) );
	swigStructField( "JNINativeInterface-NewObjectA", offsetof( struct JNINativeInterface, NewObjectA ), sizeof( jobject (*)(JNIEnv *,jclass,jmethodID,jvalue const *) ) );
	swigStructField( "JNINativeInterface-ExceptionClear", offsetof( struct JNINativeInterface, ExceptionClear ), sizeof( void (*)(JNIEnv *) ) );
	swigStructField( "JNINativeInterface-GetStringLength", offsetof( struct JNINativeInterface, GetStringLength ), sizeof( jsize (*)(JNIEnv *,jstring) ) );
	swigStructField( "JNINativeInterface-GetArrayLength", offsetof( struct JNINativeInterface, GetArrayLength ), sizeof( jsize (*)(JNIEnv *,jarray) ) );
	swigStructField( "JNINativeInterface-GetDirectBufferAddress", offsetof( struct JNINativeInterface, GetDirectBufferAddress ), sizeof( void *(*)(JNIEnv *,jobject) ) );
	swigStructField( "JNINativeInterface-NewString", offsetof( struct JNINativeInterface, NewString ), sizeof( jstring (*)(JNIEnv *,jchar const *,jsize) ) );
	swigStructField( "JNINativeInterface-ExceptionOccurred", offsetof( struct JNINativeInterface, ExceptionOccurred ), sizeof( jthrowable (*)(JNIEnv *) ) );
	swigStructField( "JNINativeInterface-NewObjectV", offsetof( struct JNINativeInterface, NewObjectV ), sizeof( jobject (*)(JNIEnv *,jclass,jmethodID,va_list) ) );
	swigStructField( "JNINativeInterface-IsInstanceOf", offsetof( struct JNINativeInterface, IsInstanceOf ), sizeof( jboolean (*)(JNIEnv *,jobject,jclass) ) );
	swigStructField( "JNINativeInterface-GetObjectArrayElement", offsetof( struct JNINativeInterface, GetObjectArrayElement ), sizeof( jobject (*)(JNIEnv *,jobjectArray,jsize) ) );
	swigStructField( "JNINativeInterface-SetObjectArrayElement", offsetof( struct JNINativeInterface, SetObjectArrayElement ), sizeof( void (*)(JNIEnv *,jobjectArray,jsize,jobject) ) );
	swigStructField( "JNINativeInterface-NewDirectByteBuffer", offsetof( struct JNINativeInterface, NewDirectByteBuffer ), sizeof( jobject (*)(JNIEnv *,void *,jlong) ) );
	swigStructField( "JNINativeInterface-GetStaticFieldID", offsetof( struct JNINativeInterface, GetStaticFieldID ), sizeof( jfieldID (*)(JNIEnv *,jclass,char const *,char const *) ) );
	swigStructField( "JNINativeInterface-GetFieldID", offsetof( struct JNINativeInterface, GetFieldID ), sizeof( jfieldID (*)(JNIEnv *,jclass,char const *,char const *) ) );
	swigStructField( "JNINativeInterface-GetStaticLongField", offsetof( struct JNINativeInterface, GetStaticLongField ), sizeof( jlong (*)(JNIEnv *,jclass,jfieldID) ) );
	swigStructField( "JNINativeInterface-SetLongField", offsetof( struct JNINativeInterface, SetLongField ), sizeof( void (*)(JNIEnv *,jobject,jfieldID,jlong) ) );
	swigStructField( "JNINativeInterface-GetLongField", offsetof( struct JNINativeInterface, GetLongField ), sizeof( jlong (*)(JNIEnv *,jobject,jfieldID) ) );
	swigStructField( "JNINativeInterface-SetStaticLongField", offsetof( struct JNINativeInterface, SetStaticLongField ), sizeof( void (*)(JNIEnv *,jclass,jfieldID,jlong) ) );
	swigStructField( "JNINativeInterface-NewLongArray", offsetof( struct JNINativeInterface, NewLongArray ), sizeof( jlongArray (*)(JNIEnv *,jsize) ) );
	swigStructField( "JNINativeInterface-ExceptionCheck", offsetof( struct JNINativeInterface, ExceptionCheck ), sizeof( jboolean (*)(JNIEnv *) ) );
	swigStructField( "JNINativeInterface-Throw", offsetof( struct JNINativeInterface, Throw ), sizeof( jint (*)(JNIEnv *,jthrowable) ) );
	swigStructField( "JNINativeInterface-NewLocalRef", offsetof( struct JNINativeInterface, NewLocalRef ), sizeof( jobject (*)(JNIEnv *,jobject) ) );
	swigStructField( "JNINativeInterface-DeleteLocalRef", offsetof( struct JNINativeInterface, DeleteLocalRef ), sizeof( void (*)(JNIEnv *,jobject) ) );
	swigStructField( "JNINativeInterface-NewObject", offsetof( struct JNINativeInterface, NewObject ), sizeof( jobject (*)(JNIEnv *,jclass,jmethodID,...) ) );
	swigStructField( "JNINativeInterface-AllocObject", offsetof( struct JNINativeInterface, AllocObject ), sizeof( jobject (*)(JNIEnv *,jclass) ) );
	swigStructField( "JNINativeInterface-IsSameObject", offsetof( struct JNINativeInterface, IsSameObject ), sizeof( jboolean (*)(JNIEnv *,jobject,jobject) ) );
	swigStructField( "JNINativeInterface-GetStringChars", offsetof( struct JNINativeInterface, GetStringChars ), sizeof( jchar const *(*)(JNIEnv *,jstring,jboolean *) ) );
	swigStructField( "JNINativeInterface-ReleaseStringChars", offsetof( struct JNINativeInterface, ReleaseStringChars ), sizeof( void (*)(JNIEnv *,jstring,jchar const *) ) );
	swigStructField( "JNINativeInterface-SetStaticByteField", offsetof( struct JNINativeInterface, SetStaticByteField ), sizeof( void (*)(JNIEnv *,jclass,jfieldID,jbyte) ) );
	swigStructField( "JNINativeInterface-GetStaticDoubleField", offsetof( struct JNINativeInterface, GetStaticDoubleField ), sizeof( jdouble (*)(JNIEnv *,jclass,jfieldID) ) );
	swigStructField( "JNINativeInterface-GetStaticByteField", offsetof( struct JNINativeInterface, GetStaticByteField ), sizeof( jbyte (*)(JNIEnv *,jclass,jfieldID) ) );
	swigStructField( "JNINativeInterface-SetDoubleField", offsetof( struct JNINativeInterface, SetDoubleField ), sizeof( void (*)(JNIEnv *,jobject,jfieldID,jdouble) ) );
	swigStructField( "JNINativeInterface-SetByteField", offsetof( struct JNINativeInterface, SetByteField ), sizeof( void (*)(JNIEnv *,jobject,jfieldID,jbyte) ) );
	swigStructField( "JNINativeInterface-GetDoubleField", offsetof( struct JNINativeInterface, GetDoubleField ), sizeof( jdouble (*)(JNIEnv *,jobject,jfieldID) ) );
	swigStructField( "JNINativeInterface-GetByteField", offsetof( struct JNINativeInterface, GetByteField ), sizeof( jbyte (*)(JNIEnv *,jobject,jfieldID) ) );
	swigStructField( "JNINativeInterface-SetStaticDoubleField", offsetof( struct JNINativeInterface, SetStaticDoubleField ), sizeof( void (*)(JNIEnv *,jclass,jfieldID,jdouble) ) );
	swigStructField( "JNINativeInterface-CallStaticVoidMethodA", offsetof( struct JNINativeInterface, CallStaticVoidMethodA ), sizeof( void (*)(JNIEnv *,jclass,jmethodID,jvalue const *) ) );
	swigStructField( "JNINativeInterface-CallStaticDoubleMethodA", offsetof( struct JNINativeInterface, CallStaticDoubleMethodA ), sizeof( jdouble (*)(JNIEnv *,jclass,jmethodID,jvalue const *) ) );
	swigStructField( "JNINativeInterface-CallStaticFloatMethodA", offsetof( struct JNINativeInterface, CallStaticFloatMethodA ), sizeof( jfloat (*)(JNIEnv *,jclass,jmethodID,jvalue const *) ) );
	swigStructField( "JNINativeInterface-CallStaticLongMethodA", offsetof( struct JNINativeInterface, CallStaticLongMethodA ), sizeof( jlong (*)(JNIEnv *,jclass,jmethodID,jvalue const *) ) );
	swigStructField( "JNINativeInterface-CallStaticIntMethodA", offsetof( struct JNINativeInterface, CallStaticIntMethodA ), sizeof( jint (*)(JNIEnv *,jclass,jmethodID,jvalue const *) ) );
	swigStructField( "JNINativeInterface-CallStaticShortMethodA", offsetof( struct JNINativeInterface, CallStaticShortMethodA ), sizeof( jshort (*)(JNIEnv *,jclass,jmethodID,jvalue const *) ) );
	swigStructField( "JNINativeInterface-CallStaticCharMethodA", offsetof( struct JNINativeInterface, CallStaticCharMethodA ), sizeof( jchar (*)(JNIEnv *,jclass,jmethodID,jvalue const *) ) );
	swigStructField( "JNINativeInterface-CallStaticByteMethodA", offsetof( struct JNINativeInterface, CallStaticByteMethodA ), sizeof( jbyte (*)(JNIEnv *,jclass,jmethodID,jvalue const *) ) );
	swigStructField( "JNINativeInterface-CallStaticBooleanMethodA", offsetof( struct JNINativeInterface, CallStaticBooleanMethodA ), sizeof( jboolean (*)(JNIEnv *,jclass,jmethodID,jvalue const *) ) );
	swigStructField( "JNINativeInterface-CallStaticObjectMethodA", offsetof( struct JNINativeInterface, CallStaticObjectMethodA ), sizeof( jobject (*)(JNIEnv *,jclass,jmethodID,jvalue const *) ) );
	swigStructField( "JNINativeInterface-CallNonvirtualVoidMethodA", offsetof( struct JNINativeInterface, CallNonvirtualVoidMethodA ), sizeof( void (*)(JNIEnv *,jobject,jclass,jmethodID,jvalue const *) ) );
	swigStructField( "JNINativeInterface-CallNonvirtualDoubleMethodA", offsetof( struct JNINativeInterface, CallNonvirtualDoubleMethodA ), sizeof( jdouble (*)(JNIEnv *,jobject,jclass,jmethodID,jvalue const *) ) );
	swigStructField( "JNINativeInterface-CallNonvirtualFloatMethodA", offsetof( struct JNINativeInterface, CallNonvirtualFloatMethodA ), sizeof( jfloat (*)(JNIEnv *,jobject,jclass,jmethodID,jvalue const *) ) );
	swigStructField( "JNINativeInterface-CallNonvirtualLongMethodA", offsetof( struct JNINativeInterface, CallNonvirtualLongMethodA ), sizeof( jlong (*)(JNIEnv *,jobject,jclass,jmethodID,jvalue const *) ) );
	swigStructField( "JNINativeInterface-CallNonvirtualIntMethodA", offsetof( struct JNINativeInterface, CallNonvirtualIntMethodA ), sizeof( jint (*)(JNIEnv *,jobject,jclass,jmethodID,jvalue const *) ) );
	swigStructField( "JNINativeInterface-CallNonvirtualShortMethodA", offsetof( struct JNINativeInterface, CallNonvirtualShortMethodA ), sizeof( jshort (*)(JNIEnv *,jobject,jclass,jmethodID,jvalue const *) ) );
	swigStructField( "JNINativeInterface-CallNonvirtualCharMethodA", offsetof( struct JNINativeInterface, CallNonvirtualCharMethodA ), sizeof( jchar (*)(JNIEnv *,jobject,jclass,jmethodID,jvalue const *) ) );
	swigStructField( "JNINativeInterface-CallObjectMethodA", offsetof( struct JNINativeInterface, CallObjectMethodA ), sizeof( jobject (*)(JNIEnv *,jobject,jmethodID,jvalue const *) ) );
	swigStructField( "JNINativeInterface-CallBooleanMethodA", offsetof( struct JNINativeInterface, CallBooleanMethodA ), sizeof( jboolean (*)(JNIEnv *,jobject,jmethodID,jvalue const *) ) );
	swigStructField( "JNINativeInterface-CallByteMethodA", offsetof( struct JNINativeInterface, CallByteMethodA ), sizeof( jbyte (*)(JNIEnv *,jobject,jmethodID,jvalue const *) ) );
	swigStructField( "JNINativeInterface-CallCharMethodA", offsetof( struct JNINativeInterface, CallCharMethodA ), sizeof( jchar (*)(JNIEnv *,jobject,jmethodID,jvalue const *) ) );
	swigStructField( "JNINativeInterface-CallShortMethodA", offsetof( struct JNINativeInterface, CallShortMethodA ), sizeof( jshort (*)(JNIEnv *,jobject,jmethodID,jvalue const *) ) );
	swigStructField( "JNINativeInterface-CallIntMethodA", offsetof( struct JNINativeInterface, CallIntMethodA ), sizeof( jint (*)(JNIEnv *,jobject,jmethodID,jvalue const *) ) );
	swigStructField( "JNINativeInterface-CallLongMethodA", offsetof( struct JNINativeInterface, CallLongMethodA ), sizeof( jlong (*)(JNIEnv *,jobject,jmethodID,jvalue const *) ) );
	swigStructField( "JNINativeInterface-CallFloatMethodA", offsetof( struct JNINativeInterface, CallFloatMethodA ), sizeof( jfloat (*)(JNIEnv *,jobject,jmethodID,jvalue const *) ) );
	swigStructField( "JNINativeInterface-CallDoubleMethodA", offsetof( struct JNINativeInterface, CallDoubleMethodA ), sizeof( jdouble (*)(JNIEnv *,jobject,jmethodID,jvalue const *) ) );
	swigStructField( "JNINativeInterface-CallVoidMethodA", offsetof( struct JNINativeInterface, CallVoidMethodA ), sizeof( void (*)(JNIEnv *,jobject,jmethodID,jvalue const *) ) );
	swigStructField( "JNINativeInterface-CallNonvirtualObjectMethodA", offsetof( struct JNINativeInterface, CallNonvirtualObjectMethodA ), sizeof( jobject (*)(JNIEnv *,jobject,jclass,jmethodID,jvalue const *) ) );
	swigStructField( "JNINativeInterface-CallNonvirtualBooleanMethodA", offsetof( struct JNINativeInterface, CallNonvirtualBooleanMethodA ), sizeof( jboolean (*)(JNIEnv *,jobject,jclass,jmethodID,jvalue const *) ) );
	swigStructField( "JNINativeInterface-CallNonvirtualByteMethodA", offsetof( struct JNINativeInterface, CallNonvirtualByteMethodA ), sizeof( jbyte (*)(JNIEnv *,jobject,jclass,jmethodID,jvalue const *) ) );
	swigStructField( "JNINativeInterface-NewByteArray", offsetof( struct JNINativeInterface, NewByteArray ), sizeof( jbyteArray (*)(JNIEnv *,jsize) ) );
	swigStructField( "JNINativeInterface-NewDoubleArray", offsetof( struct JNINativeInterface, NewDoubleArray ), sizeof( jdoubleArray (*)(JNIEnv *,jsize) ) );
	swigStructField( "JNINativeInterface-SetStaticObjectField", offsetof( struct JNINativeInterface, SetStaticObjectField ), sizeof( void (*)(JNIEnv *,jclass,jfieldID,jobject) ) );
	swigStructField( "JNINativeInterface-GetStaticFloatField", offsetof( struct JNINativeInterface, GetStaticFloatField ), sizeof( jfloat (*)(JNIEnv *,jclass,jfieldID) ) );
	swigStructField( "JNINativeInterface-GetStaticObjectField", offsetof( struct JNINativeInterface, GetStaticObjectField ), sizeof( jobject (*)(JNIEnv *,jclass,jfieldID) ) );
	swigStructField( "JNINativeInterface-SetFloatField", offsetof( struct JNINativeInterface, SetFloatField ), sizeof( void (*)(JNIEnv *,jobject,jfieldID,jfloat) ) );
	swigStructField( "JNINativeInterface-SetObjectField", offsetof( struct JNINativeInterface, SetObjectField ), sizeof( void (*)(JNIEnv *,jobject,jfieldID,jobject) ) );
	swigStructField( "JNINativeInterface-GetFloatField", offsetof( struct JNINativeInterface, GetFloatField ), sizeof( jfloat (*)(JNIEnv *,jobject,jfieldID) ) );
	swigStructField( "JNINativeInterface-GetObjectField", offsetof( struct JNINativeInterface, GetObjectField ), sizeof( jobject (*)(JNIEnv *,jobject,jfieldID) ) );
	swigStructField( "JNINativeInterface-SetStaticFloatField", offsetof( struct JNINativeInterface, SetStaticFloatField ), sizeof( void (*)(JNIEnv *,jclass,jfieldID,jfloat) ) );
	swigStructField( "JNINativeInterface-NewObjectArray", offsetof( struct JNINativeInterface, NewObjectArray ), sizeof( jobjectArray (*)(JNIEnv *,jsize,jclass,jobject) ) );
	swigStructField( "JNINativeInterface-NewFloatArray", offsetof( struct JNINativeInterface, NewFloatArray ), sizeof( jfloatArray (*)(JNIEnv *,jsize) ) );
	swigStructField( "JNINativeInterface-RegisterNatives", offsetof( struct JNINativeInterface, RegisterNatives ), sizeof( jint (*)(JNIEnv *,jclass,JNINativeMethod const *,jint) ) );
	swigStructField( "JNINativeInterface-UnregisterNatives", offsetof( struct JNINativeInterface, UnregisterNatives ), sizeof( jint (*)(JNIEnv *,jclass) ) );
	swigStructField( "JNINativeInterface-MonitorExit", offsetof( struct JNINativeInterface, MonitorExit ), sizeof( jint (*)(JNIEnv *,jobject) ) );
	swigStructField( "JNINativeInterface-FindClass", offsetof( struct JNINativeInterface, FindClass ), sizeof( jclass (*)(JNIEnv *,char const *) ) );
	swigStructField( "JNINativeInterface-PopLocalFrame", offsetof( struct JNINativeInterface, PopLocalFrame ), sizeof( jobject (*)(JNIEnv *,jobject) ) );
	swigStructField( "JNINativeInterface-PushLocalFrame", offsetof( struct JNINativeInterface, PushLocalFrame ), sizeof( jint (*)(JNIEnv *,jint) ) );
	swigStructField( "JNINativeInterface-GetSuperclass", offsetof( struct JNINativeInterface, GetSuperclass ), sizeof( jclass (*)(JNIEnv *,jclass) ) );
	swigStructField( "JNINativeInterface-GetPrimitiveArrayCritical", offsetof( struct JNINativeInterface, GetPrimitiveArrayCritical ), sizeof( void *(*)(JNIEnv *,jarray,jboolean *) ) );
	swigStructField( "JNINativeInterface-ReleasePrimitiveArrayCritical", offsetof( struct JNINativeInterface, ReleasePrimitiveArrayCritical ), sizeof( void (*)(JNIEnv *,jarray,void *,jint) ) );
	swigStructField( "JNINativeInterface-GetStringCritical", offsetof( struct JNINativeInterface, GetStringCritical ), sizeof( jchar const *(*)(JNIEnv *,jstring,jboolean *) ) );
	swigStructField( "JNINativeInterface-ReleaseStringCritical", offsetof( struct JNINativeInterface, ReleaseStringCritical ), sizeof( void (*)(JNIEnv *,jstring,jchar const *) ) );
	swigStructField( "JNINativeInterface-CallStaticVoidMethodV", offsetof( struct JNINativeInterface, CallStaticVoidMethodV ), sizeof( void (*)(JNIEnv *,jclass,jmethodID,va_list) ) );
	swigStructField( "JNINativeInterface-CallStaticDoubleMethodV", offsetof( struct JNINativeInterface, CallStaticDoubleMethodV ), sizeof( jdouble (*)(JNIEnv *,jclass,jmethodID,va_list) ) );
	swigStructField( "JNINativeInterface-CallStaticFloatMethodV", offsetof( struct JNINativeInterface, CallStaticFloatMethodV ), sizeof( jfloat (*)(JNIEnv *,jclass,jmethodID,va_list) ) );
	swigStructField( "JNINativeInterface-CallStaticLongMethodV", offsetof( struct JNINativeInterface, CallStaticLongMethodV ), sizeof( jlong (*)(JNIEnv *,jclass,jmethodID,va_list) ) );
	swigStructField( "JNINativeInterface-CallStaticIntMethodV", offsetof( struct JNINativeInterface, CallStaticIntMethodV ), sizeof( jint (*)(JNIEnv *,jclass,jmethodID,va_list) ) );
	swigStructField( "JNINativeInterface-CallStaticShortMethodV", offsetof( struct JNINativeInterface, CallStaticShortMethodV ), sizeof( jshort (*)(JNIEnv *,jclass,jmethodID,va_list) ) );
	swigStructField( "JNINativeInterface-CallStaticCharMethodV", offsetof( struct JNINativeInterface, CallStaticCharMethodV ), sizeof( jchar (*)(JNIEnv *,jclass,jmethodID,va_list) ) );
	swigStructField( "JNINativeInterface-CallStaticByteMethodV", offsetof( struct JNINativeInterface, CallStaticByteMethodV ), sizeof( jbyte (*)(JNIEnv *,jclass,jmethodID,va_list) ) );
	swigStructField( "JNINativeInterface-CallStaticBooleanMethodV", offsetof( struct JNINativeInterface, CallStaticBooleanMethodV ), sizeof( jboolean (*)(JNIEnv *,jclass,jmethodID,va_list) ) );
	swigStructField( "JNINativeInterface-CallStaticObjectMethodV", offsetof( struct JNINativeInterface, CallStaticObjectMethodV ), sizeof( jobject (*)(JNIEnv *,jclass,jmethodID,va_list) ) );
	swigStructField( "JNINativeInterface-CallNonvirtualVoidMethodV", offsetof( struct JNINativeInterface, CallNonvirtualVoidMethodV ), sizeof( void (*)(JNIEnv *,jobject,jclass,jmethodID,va_list) ) );
	swigStructField( "JNINativeInterface-CallNonvirtualDoubleMethodV", offsetof( struct JNINativeInterface, CallNonvirtualDoubleMethodV ), sizeof( jdouble (*)(JNIEnv *,jobject,jclass,jmethodID,va_list) ) );
	swigStructField( "JNINativeInterface-CallNonvirtualFloatMethodV", offsetof( struct JNINativeInterface, CallNonvirtualFloatMethodV ), sizeof( jfloat (*)(JNIEnv *,jobject,jclass,jmethodID,va_list) ) );
	swigStructField( "JNINativeInterface-CallNonvirtualLongMethodV", offsetof( struct JNINativeInterface, CallNonvirtualLongMethodV ), sizeof( jlong (*)(JNIEnv *,jobject,jclass,jmethodID,va_list) ) );
	swigStructField( "JNINativeInterface-CallNonvirtualIntMethodV", offsetof( struct JNINativeInterface, CallNonvirtualIntMethodV ), sizeof( jint (*)(JNIEnv *,jobject,jclass,jmethodID,va_list) ) );
	swigStructField( "JNINativeInterface-CallNonvirtualShortMethodV", offsetof( struct JNINativeInterface, CallNonvirtualShortMethodV ), sizeof( jshort (*)(JNIEnv *,jobject,jclass,jmethodID,va_list) ) );
	swigStructField( "JNINativeInterface-CallNonvirtualCharMethodV", offsetof( struct JNINativeInterface, CallNonvirtualCharMethodV ), sizeof( jchar (*)(JNIEnv *,jobject,jclass,jmethodID,va_list) ) );
	swigStructField( "JNINativeInterface-CallObjectMethodV", offsetof( struct JNINativeInterface, CallObjectMethodV ), sizeof( jobject (*)(JNIEnv *,jobject,jmethodID,va_list) ) );
	swigStructField( "JNINativeInterface-CallBooleanMethodV", offsetof( struct JNINativeInterface, CallBooleanMethodV ), sizeof( jboolean (*)(JNIEnv *,jobject,jmethodID,va_list) ) );
	swigStructField( "JNINativeInterface-CallByteMethodV", offsetof( struct JNINativeInterface, CallByteMethodV ), sizeof( jbyte (*)(JNIEnv *,jobject,jmethodID,va_list) ) );
	swigStructField( "JNINativeInterface-CallCharMethodV", offsetof( struct JNINativeInterface, CallCharMethodV ), sizeof( jchar (*)(JNIEnv *,jobject,jmethodID,va_list) ) );
	swigStructField( "JNINativeInterface-CallShortMethodV", offsetof( struct JNINativeInterface, CallShortMethodV ), sizeof( jshort (*)(JNIEnv *,jobject,jmethodID,va_list) ) );
	swigStructField( "JNINativeInterface-CallIntMethodV", offsetof( struct JNINativeInterface, CallIntMethodV ), sizeof( jint (*)(JNIEnv *,jobject,jmethodID,va_list) ) );
	swigStructField( "JNINativeInterface-CallLongMethodV", offsetof( struct JNINativeInterface, CallLongMethodV ), sizeof( jlong (*)(JNIEnv *,jobject,jmethodID,va_list) ) );
	swigStructField( "JNINativeInterface-CallFloatMethodV", offsetof( struct JNINativeInterface, CallFloatMethodV ), sizeof( jfloat (*)(JNIEnv *,jobject,jmethodID,va_list) ) );
	swigStructField( "JNINativeInterface-CallDoubleMethodV", offsetof( struct JNINativeInterface, CallDoubleMethodV ), sizeof( jdouble (*)(JNIEnv *,jobject,jmethodID,va_list) ) );
	swigStructField( "JNINativeInterface-CallVoidMethodV", offsetof( struct JNINativeInterface, CallVoidMethodV ), sizeof( void (*)(JNIEnv *,jobject,jmethodID,va_list) ) );
	swigStructField( "JNINativeInterface-CallNonvirtualObjectMethodV", offsetof( struct JNINativeInterface, CallNonvirtualObjectMethodV ), sizeof( jobject (*)(JNIEnv *,jobject,jclass,jmethodID,va_list) ) );
	swigStructField( "JNINativeInterface-CallNonvirtualBooleanMethodV", offsetof( struct JNINativeInterface, CallNonvirtualBooleanMethodV ), sizeof( jboolean (*)(JNIEnv *,jobject,jclass,jmethodID,va_list) ) );
	swigStructField( "JNINativeInterface-CallNonvirtualByteMethodV", offsetof( struct JNINativeInterface, CallNonvirtualByteMethodV ), sizeof( jbyte (*)(JNIEnv *,jobject,jclass,jmethodID,va_list) ) );
	swigStructField( "JNINativeInterface-GetStaticIntField", offsetof( struct JNINativeInterface, GetStaticIntField ), sizeof( jint (*)(JNIEnv *,jclass,jfieldID) ) );
	swigStructField( "JNINativeInterface-GetStaticShortField", offsetof( struct JNINativeInterface, GetStaticShortField ), sizeof( jshort (*)(JNIEnv *,jclass,jfieldID) ) );
	swigStructField( "JNINativeInterface-SetIntField", offsetof( struct JNINativeInterface, SetIntField ), sizeof( void (*)(JNIEnv *,jobject,jfieldID,jint) ) );
	swigStructField( "JNINativeInterface-SetShortField", offsetof( struct JNINativeInterface, SetShortField ), sizeof( void (*)(JNIEnv *,jobject,jfieldID,jshort) ) );
	swigStructField( "JNINativeInterface-GetIntField", offsetof( struct JNINativeInterface, GetIntField ), sizeof( jint (*)(JNIEnv *,jobject,jfieldID) ) );
	swigStructField( "JNINativeInterface-GetShortField", offsetof( struct JNINativeInterface, GetShortField ), sizeof( jshort (*)(JNIEnv *,jobject,jfieldID) ) );
	swigStructField( "JNINativeInterface-SetStaticShortField", offsetof( struct JNINativeInterface, SetStaticShortField ), sizeof( void (*)(JNIEnv *,jclass,jfieldID,jshort) ) );
	swigStructField( "JNINativeInterface-SetStaticIntField", offsetof( struct JNINativeInterface, SetStaticIntField ), sizeof( void (*)(JNIEnv *,jclass,jfieldID,jint) ) );
	swigStructField( "JNINativeInterface-NewShortArray", offsetof( struct JNINativeInterface, NewShortArray ), sizeof( jshortArray (*)(JNIEnv *,jsize) ) );
	swigStructField( "JNINativeInterface-NewIntArray", offsetof( struct JNINativeInterface, NewIntArray ), sizeof( jintArray (*)(JNIEnv *,jsize) ) );
	swigStructField( "JNINativeInterface-SetStaticCharField", offsetof( struct JNINativeInterface, SetStaticCharField ), sizeof( void (*)(JNIEnv *,jclass,jfieldID,jchar) ) );
	swigStructField( "JNINativeInterface-GetStaticCharField", offsetof( struct JNINativeInterface, GetStaticCharField ), sizeof( jchar (*)(JNIEnv *,jclass,jfieldID) ) );
	swigStructField( "JNINativeInterface-SetCharField", offsetof( struct JNINativeInterface, SetCharField ), sizeof( void (*)(JNIEnv *,jobject,jfieldID,jchar) ) );
	swigStructField( "JNINativeInterface-GetCharField", offsetof( struct JNINativeInterface, GetCharField ), sizeof( jchar (*)(JNIEnv *,jobject,jfieldID) ) );
	swigStructField( "JNINativeInterface-NewCharArray", offsetof( struct JNINativeInterface, NewCharArray ), sizeof( jcharArray (*)(JNIEnv *,jsize) ) );
	swigStructField( "JNINativeInterface-GetObjectRefType", offsetof( struct JNINativeInterface, GetObjectRefType ), sizeof( jobjectRefType (*)(JNIEnv *,jobject) ) );
	swigStructField( "JNINativeInterface-GetJavaVM", offsetof( struct JNINativeInterface, GetJavaVM ), sizeof( jint (*)(JNIEnv *,JavaVM **) ) );
	swigStructField( "JNINativeInterface-GetStaticMethodID", offsetof( struct JNINativeInterface, GetStaticMethodID ), sizeof( jmethodID (*)(JNIEnv *,jclass,char const *,char const *) ) );
	swigStructField( "JNINativeInterface-GetMethodID", offsetof( struct JNINativeInterface, GetMethodID ), sizeof( jmethodID (*)(JNIEnv *,jclass,char const *,char const *) ) );
	swigStructField( "JNINativeInterface-ThrowNew", offsetof( struct JNINativeInterface, ThrowNew ), sizeof( jint (*)(JNIEnv *,jclass,char const *) ) );
	swigStructField( "JNINativeInterface-GetVersion", offsetof( struct JNINativeInterface, GetVersion ), sizeof( jint (*)(JNIEnv *) ) );
	swigStructField( "JNINativeInterface-MonitorEnter", offsetof( struct JNINativeInterface, MonitorEnter ), sizeof( jint (*)(JNIEnv *,jobject) ) );
	swigStructField( "JNINativeInterface-CallStaticVoidMethod", offsetof( struct JNINativeInterface, CallStaticVoidMethod ), sizeof( void (*)(JNIEnv *,jclass,jmethodID,...) ) );
	swigStructField( "JNINativeInterface-CallStaticFloatMethod", offsetof( struct JNINativeInterface, CallStaticFloatMethod ), sizeof( jfloat (*)(JNIEnv *,jclass,jmethodID,...) ) );
	swigStructField( "JNINativeInterface-CallStaticIntMethod", offsetof( struct JNINativeInterface, CallStaticIntMethod ), sizeof( jint (*)(JNIEnv *,jclass,jmethodID,...) ) );
	swigStructField( "JNINativeInterface-CallStaticShortMethod", offsetof( struct JNINativeInterface, CallStaticShortMethod ), sizeof( jshort (*)(JNIEnv *,jclass,jmethodID,...) ) );
	swigStructField( "JNINativeInterface-CallStaticCharMethod", offsetof( struct JNINativeInterface, CallStaticCharMethod ), sizeof( jchar (*)(JNIEnv *,jclass,jmethodID,...) ) );
	swigStructField( "JNINativeInterface-CallStaticBooleanMethod", offsetof( struct JNINativeInterface, CallStaticBooleanMethod ), sizeof( jboolean (*)(JNIEnv *,jclass,jmethodID,...) ) );
	swigStructField( "JNINativeInterface-CallStaticObjectMethod", offsetof( struct JNINativeInterface, CallStaticObjectMethod ), sizeof( jobject (*)(JNIEnv *,jclass,jmethodID,...) ) );
	swigStructField( "JNINativeInterface-CallNonvirtualVoidMethod", offsetof( struct JNINativeInterface, CallNonvirtualVoidMethod ), sizeof( void (*)(JNIEnv *,jobject,jclass,jmethodID,...) ) );
	swigStructField( "JNINativeInterface-CallNonvirtualFloatMethod", offsetof( struct JNINativeInterface, CallNonvirtualFloatMethod ), sizeof( jfloat (*)(JNIEnv *,jobject,jclass,jmethodID,...) ) );
	swigStructField( "JNINativeInterface-CallNonvirtualIntMethod", offsetof( struct JNINativeInterface, CallNonvirtualIntMethod ), sizeof( jint (*)(JNIEnv *,jobject,jclass,jmethodID,...) ) );
	swigStructField( "JNINativeInterface-CallNonvirtualShortMethod", offsetof( struct JNINativeInterface, CallNonvirtualShortMethod ), sizeof( jshort (*)(JNIEnv *,jobject,jclass,jmethodID,...) ) );
	swigStructField( "JNINativeInterface-FromReflectedMethod", offsetof( struct JNINativeInterface, FromReflectedMethod ), sizeof( jmethodID (*)(JNIEnv *,jobject) ) );
	swigStructField( "JNINativeInterface-ToReflectedMethod", offsetof( struct JNINativeInterface, ToReflectedMethod ), sizeof( jobject (*)(JNIEnv *,jclass,jmethodID,jboolean) ) );
	swigStructField( "JNINativeInterface-CallObjectMethod", offsetof( struct JNINativeInterface, CallObjectMethod ), sizeof( jobject (*)(JNIEnv *,jobject,jmethodID,...) ) );
	swigStructField( "JNINativeInterface-CallBooleanMethod", offsetof( struct JNINativeInterface, CallBooleanMethod ), sizeof( jboolean (*)(JNIEnv *,jobject,jmethodID,...) ) );
	swigStructField( "JNINativeInterface-CallCharMethod", offsetof( struct JNINativeInterface, CallCharMethod ), sizeof( jchar (*)(JNIEnv *,jobject,jmethodID,...) ) );
	swigStructField( "JNINativeInterface-CallShortMethod", offsetof( struct JNINativeInterface, CallShortMethod ), sizeof( jshort (*)(JNIEnv *,jobject,jmethodID,...) ) );
	swigStructField( "JNINativeInterface-CallIntMethod", offsetof( struct JNINativeInterface, CallIntMethod ), sizeof( jint (*)(JNIEnv *,jobject,jmethodID,...) ) );
	swigStructField( "JNINativeInterface-CallFloatMethod", offsetof( struct JNINativeInterface, CallFloatMethod ), sizeof( jfloat (*)(JNIEnv *,jobject,jmethodID,...) ) );
	swigStructField( "JNINativeInterface-CallVoidMethod", offsetof( struct JNINativeInterface, CallVoidMethod ), sizeof( void (*)(JNIEnv *,jobject,jmethodID,...) ) );
	swigStructField( "JNINativeInterface-CallNonvirtualObjectMethod", offsetof( struct JNINativeInterface, CallNonvirtualObjectMethod ), sizeof( jobject (*)(JNIEnv *,jobject,jclass,jmethodID,...) ) );
	swigStructField( "JNINativeInterface-CallNonvirtualBooleanMethod", offsetof( struct JNINativeInterface, CallNonvirtualBooleanMethod ), sizeof( jboolean (*)(JNIEnv *,jobject,jclass,jmethodID,...) ) );
	swigStructField( "JNINativeInterface-CallNonvirtualCharMethod", offsetof( struct JNINativeInterface, CallNonvirtualCharMethod ), sizeof( jchar (*)(JNIEnv *,jobject,jclass,jmethodID,...) ) );
	swigStructField( "JNINativeInterface-GetStringUTFRegion", offsetof( struct JNINativeInterface, GetStringUTFRegion ), sizeof( void (*)(JNIEnv *,jstring,jsize,jsize,char *) ) );
	swigStructField( "JNINativeInterface-FatalError", offsetof( struct JNINativeInterface, FatalError ), sizeof( void (*)(JNIEnv *,char const *) ) );
	swigStructField( "JNINativeInterface-GetBooleanArrayElements", offsetof( struct JNINativeInterface, GetBooleanArrayElements ), sizeof( jboolean *(*)(JNIEnv *,jbooleanArray,jboolean *) ) );
	swigStructField( "JNINativeInterface-GetByteArrayElements", offsetof( struct JNINativeInterface, GetByteArrayElements ), sizeof( jbyte *(*)(JNIEnv *,jbyteArray,jboolean *) ) );
	swigStructField( "JNINativeInterface-GetCharArrayElements", offsetof( struct JNINativeInterface, GetCharArrayElements ), sizeof( jchar *(*)(JNIEnv *,jcharArray,jboolean *) ) );
	swigStructField( "JNINativeInterface-GetShortArrayElements", offsetof( struct JNINativeInterface, GetShortArrayElements ), sizeof( jshort *(*)(JNIEnv *,jshortArray,jboolean *) ) );
	swigStructField( "JNINativeInterface-GetIntArrayElements", offsetof( struct JNINativeInterface, GetIntArrayElements ), sizeof( jint *(*)(JNIEnv *,jintArray,jboolean *) ) );
	swigStructField( "JNINativeInterface-GetLongArrayElements", offsetof( struct JNINativeInterface, GetLongArrayElements ), sizeof( jlong *(*)(JNIEnv *,jlongArray,jboolean *) ) );
	swigStructField( "JNINativeInterface-GetFloatArrayElements", offsetof( struct JNINativeInterface, GetFloatArrayElements ), sizeof( jfloat *(*)(JNIEnv *,jfloatArray,jboolean *) ) );
	swigStructField( "JNINativeInterface-GetDoubleArrayElements", offsetof( struct JNINativeInterface, GetDoubleArrayElements ), sizeof( jdouble *(*)(JNIEnv *,jdoubleArray,jboolean *) ) );
	swigStructField( "JNINativeInterface-ReleaseBooleanArrayElements", offsetof( struct JNINativeInterface, ReleaseBooleanArrayElements ), sizeof( void (*)(JNIEnv *,jbooleanArray,jboolean *,jint) ) );
	swigStructField( "JNINativeInterface-ReleaseByteArrayElements", offsetof( struct JNINativeInterface, ReleaseByteArrayElements ), sizeof( void (*)(JNIEnv *,jbyteArray,jbyte *,jint) ) );
	swigStructField( "JNINativeInterface-ReleaseCharArrayElements", offsetof( struct JNINativeInterface, ReleaseCharArrayElements ), sizeof( void (*)(JNIEnv *,jcharArray,jchar *,jint) ) );
	swigStructField( "JNINativeInterface-ReleaseShortArrayElements", offsetof( struct JNINativeInterface, ReleaseShortArrayElements ), sizeof( void (*)(JNIEnv *,jshortArray,jshort *,jint) ) );
	swigStructField( "JNINativeInterface-ReleaseIntArrayElements", offsetof( struct JNINativeInterface, ReleaseIntArrayElements ), sizeof( void (*)(JNIEnv *,jintArray,jint *,jint) ) );
	swigStructField( "JNINativeInterface-ReleaseLongArrayElements", offsetof( struct JNINativeInterface, ReleaseLongArrayElements ), sizeof( void (*)(JNIEnv *,jlongArray,jlong *,jint) ) );
	swigStructField( "JNINativeInterface-ReleaseFloatArrayElements", offsetof( struct JNINativeInterface, ReleaseFloatArrayElements ), sizeof( void (*)(JNIEnv *,jfloatArray,jfloat *,jint) ) );
	swigStructField( "JNINativeInterface-ReleaseDoubleArrayElements", offsetof( struct JNINativeInterface, ReleaseDoubleArrayElements ), sizeof( void (*)(JNIEnv *,jdoubleArray,jdouble *,jint) ) );
	swigStructField( "JNINativeInterface-GetStringUTFChars", offsetof( struct JNINativeInterface, GetStringUTFChars ), sizeof( char const *(*)(JNIEnv *,jstring,jboolean *) ) );
	swigStructField( "JNINativeInterface-ReleaseStringUTFChars", offsetof( struct JNINativeInterface, ReleaseStringUTFChars ), sizeof( void (*)(JNIEnv *,jstring,char const *) ) );
	swigStructField( "JNINativeInterface-FromReflectedField", offsetof( struct JNINativeInterface, FromReflectedField ), sizeof( jfieldID (*)(JNIEnv *,jobject) ) );
	swigStructField( "JNINativeInterface-ToReflectedField", offsetof( struct JNINativeInterface, ToReflectedField ), sizeof( jobject (*)(JNIEnv *,jclass,jfieldID,jboolean) ) );
	swigStructField( "JNINativeInterface-NewStringUTF", offsetof( struct JNINativeInterface, NewStringUTF ), sizeof( jstring (*)(JNIEnv *,char const *) ) );
	swigStructField( "JNINativeInterface-GetStringUTFLength", offsetof( struct JNINativeInterface, GetStringUTFLength ), sizeof( jsize (*)(JNIEnv *,jstring) ) );
	swigStructField( "JNINativeInterface-DefineClass", offsetof( struct JNINativeInterface, DefineClass ), sizeof( jclass (*)(JNIEnv *,char const *,jobject,jbyte const *,jsize) ) );
	swigStructField( "JNINativeInterface-DeleteGlobalRef", offsetof( struct JNINativeInterface, DeleteGlobalRef ), sizeof( void (*)(JNIEnv *,jobject) ) );
	swigStructField( "JNINativeInterface-NewGlobalRef", offsetof( struct JNINativeInterface, NewGlobalRef ), sizeof( jobject (*)(JNIEnv *,jobject) ) );
	swigStructField( "JNINativeInterface-NewWeakGlobalRef", offsetof( struct JNINativeInterface, NewWeakGlobalRef ), sizeof( jweak (*)(JNIEnv *,jobject) ) );
	swigStructField( "JNINativeInterface-DeleteWeakGlobalRef", offsetof( struct JNINativeInterface, DeleteWeakGlobalRef ), sizeof( void (*)(JNIEnv *,jweak) ) );
	swigStructField( "JNINativeInterface-CallStaticDoubleMethod", offsetof( struct JNINativeInterface, CallStaticDoubleMethod ), sizeof( jdouble (*)(JNIEnv *,jclass,jmethodID,...) ) );
	swigStructField( "JNINativeInterface-CallStaticLongMethod", offsetof( struct JNINativeInterface, CallStaticLongMethod ), sizeof( jlong (*)(JNIEnv *,jclass,jmethodID,...) ) );
	swigStructField( "JNINativeInterface-CallStaticByteMethod", offsetof( struct JNINativeInterface, CallStaticByteMethod ), sizeof( jbyte (*)(JNIEnv *,jclass,jmethodID,...) ) );
	swigStructField( "JNINativeInterface-CallNonvirtualDoubleMethod", offsetof( struct JNINativeInterface, CallNonvirtualDoubleMethod ), sizeof( jdouble (*)(JNIEnv *,jobject,jclass,jmethodID,...) ) );
	swigStructField( "JNINativeInterface-CallNonvirtualLongMethod", offsetof( struct JNINativeInterface, CallNonvirtualLongMethod ), sizeof( jlong (*)(JNIEnv *,jobject,jclass,jmethodID,...) ) );
	swigStructField( "JNINativeInterface-CallByteMethod", offsetof( struct JNINativeInterface, CallByteMethod ), sizeof( jbyte (*)(JNIEnv *,jobject,jmethodID,...) ) );
	swigStructField( "JNINativeInterface-CallLongMethod", offsetof( struct JNINativeInterface, CallLongMethod ), sizeof( jlong (*)(JNIEnv *,jobject,jmethodID,...) ) );
	swigStructField( "JNINativeInterface-CallDoubleMethod", offsetof( struct JNINativeInterface, CallDoubleMethod ), sizeof( jdouble (*)(JNIEnv *,jobject,jmethodID,...) ) );
	swigStructField( "JNINativeInterface-CallNonvirtualByteMethod", offsetof( struct JNINativeInterface, CallNonvirtualByteMethod ), sizeof( jbyte (*)(JNIEnv *,jobject,jclass,jmethodID,...) ) );
	swigStructField( "JNINativeInterface-GetBooleanArrayRegion", offsetof( struct JNINativeInterface, GetBooleanArrayRegion ), sizeof( void (*)(JNIEnv *,jbooleanArray,jsize,jsize,jboolean *) ) );
	swigStructField( "JNINativeInterface-GetByteArrayRegion", offsetof( struct JNINativeInterface, GetByteArrayRegion ), sizeof( void (*)(JNIEnv *,jbyteArray,jsize,jsize,jbyte *) ) );
	swigStructField( "JNINativeInterface-GetCharArrayRegion", offsetof( struct JNINativeInterface, GetCharArrayRegion ), sizeof( void (*)(JNIEnv *,jcharArray,jsize,jsize,jchar *) ) );
	swigStructField( "JNINativeInterface-GetShortArrayRegion", offsetof( struct JNINativeInterface, GetShortArrayRegion ), sizeof( void (*)(JNIEnv *,jshortArray,jsize,jsize,jshort *) ) );
	swigStructField( "JNINativeInterface-GetIntArrayRegion", offsetof( struct JNINativeInterface, GetIntArrayRegion ), sizeof( void (*)(JNIEnv *,jintArray,jsize,jsize,jint *) ) );
	swigStructField( "JNINativeInterface-GetLongArrayRegion", offsetof( struct JNINativeInterface, GetLongArrayRegion ), sizeof( void (*)(JNIEnv *,jlongArray,jsize,jsize,jlong *) ) );
	swigStructField( "JNINativeInterface-GetFloatArrayRegion", offsetof( struct JNINativeInterface, GetFloatArrayRegion ), sizeof( void (*)(JNIEnv *,jfloatArray,jsize,jsize,jfloat *) ) );
	swigStructField( "JNINativeInterface-GetDoubleArrayRegion", offsetof( struct JNINativeInterface, GetDoubleArrayRegion ), sizeof( void (*)(JNIEnv *,jdoubleArray,jsize,jsize,jdouble *) ) );
	swigStructField( "JNINativeInterface-SetBooleanArrayRegion", offsetof( struct JNINativeInterface, SetBooleanArrayRegion ), sizeof( void (*)(JNIEnv *,jbooleanArray,jsize,jsize,jboolean const *) ) );
	swigStructField( "JNINativeInterface-SetByteArrayRegion", offsetof( struct JNINativeInterface, SetByteArrayRegion ), sizeof( void (*)(JNIEnv *,jbyteArray,jsize,jsize,jbyte const *) ) );
	swigStructField( "JNINativeInterface-SetCharArrayRegion", offsetof( struct JNINativeInterface, SetCharArrayRegion ), sizeof( void (*)(JNIEnv *,jcharArray,jsize,jsize,jchar const *) ) );
	swigStructField( "JNINativeInterface-SetShortArrayRegion", offsetof( struct JNINativeInterface, SetShortArrayRegion ), sizeof( void (*)(JNIEnv *,jshortArray,jsize,jsize,jshort const *) ) );
	swigStructField( "JNINativeInterface-SetIntArrayRegion", offsetof( struct JNINativeInterface, SetIntArrayRegion ), sizeof( void (*)(JNIEnv *,jintArray,jsize,jsize,jint const *) ) );
	swigStructField( "JNINativeInterface-SetLongArrayRegion", offsetof( struct JNINativeInterface, SetLongArrayRegion ), sizeof( void (*)(JNIEnv *,jlongArray,jsize,jsize,jlong const *) ) );
	swigStructField( "JNINativeInterface-SetFloatArrayRegion", offsetof( struct JNINativeInterface, SetFloatArrayRegion ), sizeof( void (*)(JNIEnv *,jfloatArray,jsize,jsize,jfloat const *) ) );
	swigStructField( "JNINativeInterface-SetDoubleArrayRegion", offsetof( struct JNINativeInterface, SetDoubleArrayRegion ), sizeof( void (*)(JNIEnv *,jdoubleArray,jsize,jsize,jdouble const *) ) );
	swigStructField( "JNINativeInterface-GetStringRegion", offsetof( struct JNINativeInterface, GetStringRegion ), sizeof( void (*)(JNIEnv *,jstring,jsize,jsize,jchar *) ) );
	swigStructField( "JNINativeInterface-GetObjectClass", offsetof( struct JNINativeInterface, GetObjectClass ), sizeof( jclass (*)(JNIEnv *,jobject) ) );
	swigStructField( "JNINativeInterface-EnsureLocalCapacity", offsetof( struct JNINativeInterface, EnsureLocalCapacity ), sizeof( jint (*)(JNIEnv *,jint) ) );
	swigStructField( "JNINativeInterface-ExceptionDescribe", offsetof( struct JNINativeInterface, ExceptionDescribe ), sizeof( void (*)(JNIEnv *) ) );
	swigStructField( "JNINativeInterface-GetDirectBufferCapacity", offsetof( struct JNINativeInterface, GetDirectBufferCapacity ), sizeof( jlong (*)(JNIEnv *,jobject) ) );
	printf( "drop %zu end-structure\n", sizeof( struct JNINativeInterface ) );

	swigComment("JNIInvokeInterface\n");
	printf( "begin-structure JNIInvokeInterface\n" );
	swigStructField( "JNIInvokeInterface-AttachCurrentThread", offsetof( struct JNIInvokeInterface, AttachCurrentThread ), sizeof( jint (*)(JavaVM *,void **,void *) ) );
	swigStructField( "JNIInvokeInterface-DetachCurrentThread", offsetof( struct JNIInvokeInterface, DetachCurrentThread ), sizeof( jint (*)(JavaVM *) ) );
	swigStructField( "JNIInvokeInterface-DestroyJavaVM", offsetof( struct JNIInvokeInterface, DestroyJavaVM ), sizeof( jint (*)(JavaVM *) ) );
	swigStructField( "JNIInvokeInterface-reserved0", offsetof( struct JNIInvokeInterface, reserved0 ), sizeof( void * ) );
	swigStructField( "JNIInvokeInterface-reserved1", offsetof( struct JNIInvokeInterface, reserved1 ), sizeof( void * ) );
	swigStructField( "JNIInvokeInterface-AttachCurrentThreadAsDaemon", offsetof( struct JNIInvokeInterface, AttachCurrentThreadAsDaemon ), sizeof( jint (*)(JavaVM *,void **,void *) ) );
	swigStructField( "JNIInvokeInterface-reserved2", offsetof( struct JNIInvokeInterface, reserved2 ), sizeof( void * ) );
	swigStructField( "JNIInvokeInterface-GetEnv", offsetof( struct JNIInvokeInterface, GetEnv ), sizeof( jint (*)(JavaVM *,void **,jint) ) );
	printf( "drop %zu end-structure\n", sizeof( struct JNIInvokeInterface ) );

	swigComment("JavaVMAttachArgs\n");
	printf( "begin-structure JavaVMAttachArgs\n" );
	swigStructField( "JavaVMAttachArgs-name", offsetof( struct JavaVMAttachArgs, name ), sizeof( char * ) );
	swigStructField( "JavaVMAttachArgs-version", offsetof( struct JavaVMAttachArgs, version ), sizeof( jint ) );
	swigStructField( "JavaVMAttachArgs-group", offsetof( struct JavaVMAttachArgs, group ), sizeof( jobject ) );
	printf( "drop %zu end-structure\n", sizeof( struct JavaVMAttachArgs ) );

	swigComment("JavaVMOption\n");
	printf( "begin-structure JavaVMOption\n" );
	swigStructField( "JavaVMOption-optionString", offsetof( struct JavaVMOption, optionString ), sizeof( char * ) );
	swigStructField( "JavaVMOption-extraInfo", offsetof( struct JavaVMOption, extraInfo ), sizeof( void * ) );
	printf( "drop %zu end-structure\n", sizeof( struct JavaVMOption ) );

	swigComment("JavaVMInitArgs\n");
	printf( "begin-structure JavaVMInitArgs\n" );
	swigStructField( "JavaVMInitArgs-version", offsetof( struct JavaVMInitArgs, version ), sizeof( jint ) );
	swigStructField( "JavaVMInitArgs-ignoreUnrecognized", offsetof( struct JavaVMInitArgs, ignoreUnrecognized ), sizeof( jboolean ) );
	swigStructField( "JavaVMInitArgs-nOptions", offsetof( struct JavaVMInitArgs, nOptions ), sizeof( jint ) );
	swigStructField( "JavaVMInitArgs-options", offsetof( struct JavaVMInitArgs, options ), sizeof( JavaVMOption * ) );
	printf( "drop %zu end-structure\n", sizeof( struct JavaVMInitArgs ) );

	swigComment("JDK1_1InitArgs\n");
	printf( "begin-structure JDK1_1InitArgs\n" );
	swigStructField( "JDK1_1InitArgs-classpath", offsetof( struct JDK1_1InitArgs, classpath ), sizeof( char const * ) );
	swigStructField( "JDK1_1InitArgs-exit", offsetof( struct JDK1_1InitArgs, exit ), sizeof( void (*)(jint) ) );
	swigStructField( "JDK1_1InitArgs-reserved0", offsetof( struct JDK1_1InitArgs, reserved0 ), sizeof( jint ) );
	swigStructField( "JDK1_1InitArgs-enableClassGC", offsetof( struct JDK1_1InitArgs, enableClassGC ), sizeof( jint ) );
	swigStructField( "JDK1_1InitArgs-disableAsyncGC", offsetof( struct JDK1_1InitArgs, disableAsyncGC ), sizeof( jint ) );
	swigStructField( "JDK1_1InitArgs-reserved1", offsetof( struct JDK1_1InitArgs, reserved1 ), sizeof( jint ) );
	swigStructField( "JDK1_1InitArgs-javaStackSize", offsetof( struct JDK1_1InitArgs, javaStackSize ), sizeof( jint ) );
	swigStructField( "JDK1_1InitArgs-nativeStackSize", offsetof( struct JDK1_1InitArgs, nativeStackSize ), sizeof( jint ) );
	swigStructField( "JDK1_1InitArgs-reserved2", offsetof( struct JDK1_1InitArgs, reserved2 ), sizeof( jint ) );
	swigStructField( "JDK1_1InitArgs-checkSource", offsetof( struct JDK1_1InitArgs, checkSource ), sizeof( jint ) );
	swigStructField( "JDK1_1InitArgs-properties", offsetof( struct JDK1_1InitArgs, properties ), sizeof( char ** ) );
	swigStructField( "JDK1_1InitArgs-version", offsetof( struct JDK1_1InitArgs, version ), sizeof( jint ) );
	swigStructField( "JDK1_1InitArgs-verifyMode", offsetof( struct JDK1_1InitArgs, verifyMode ), sizeof( jint ) );
	swigStructField( "JDK1_1InitArgs-abort", offsetof( struct JDK1_1InitArgs, abort ), sizeof( void (*)(void) ) );
	swigStructField( "JDK1_1InitArgs-enableVerboseGC", offsetof( struct JDK1_1InitArgs, enableVerboseGC ), sizeof( jint ) );
	swigStructField( "JDK1_1InitArgs-maxHeapSize", offsetof( struct JDK1_1InitArgs, maxHeapSize ), sizeof( jint ) );
	swigStructField( "JDK1_1InitArgs-minHeapSize", offsetof( struct JDK1_1InitArgs, minHeapSize ), sizeof( jint ) );
	swigStructField( "JDK1_1InitArgs-vfprintf", offsetof( struct JDK1_1InitArgs, vfprintf ), sizeof( jint (*)(FILE *,char const *,va_list) ) );
	printf( "drop %zu end-structure\n", sizeof( struct JDK1_1InitArgs ) );

	swigComment("JDK1_1AttachArgs\n");
	printf( "begin-structure JDK1_1AttachArgs\n" );
	swigStructField( "JDK1_1AttachArgs-__padding", offsetof( struct JDK1_1AttachArgs, __padding ), sizeof( void * ) );
	printf( "drop %zu end-structure\n", sizeof( struct JDK1_1AttachArgs ) );

	swigNewline();

	swigComment("--===< function pointers >===---\n");
	swigFunctionPointer( "c-funptr JNINativeInterface-GetVersion() {((struct JNINativeInterface*)ptr)->GetVersion} a -- n", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-DefineClass() {((struct JNINativeInterface*)ptr)->DefineClass} a s a a n -- a", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-FindClass() {((struct JNINativeInterface*)ptr)->FindClass} a s -- a", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-FromReflectedMethod() {((struct JNINativeInterface*)ptr)->FromReflectedMethod} a a -- a", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-FromReflectedField() {((struct JNINativeInterface*)ptr)->FromReflectedField} a a -- a", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-ToReflectedMethod() {((struct JNINativeInterface*)ptr)->ToReflectedMethod} a a a u -- a", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-GetSuperclass() {((struct JNINativeInterface*)ptr)->GetSuperclass} a a -- a", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-IsAssignableFrom() {((struct JNINativeInterface*)ptr)->IsAssignableFrom} a a a -- u", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-ToReflectedField() {((struct JNINativeInterface*)ptr)->ToReflectedField} a a a u -- a", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-Throw() {((struct JNINativeInterface*)ptr)->Throw} a a -- n", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-ThrowNew() {((struct JNINativeInterface*)ptr)->ThrowNew} a a s -- n", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-ExceptionOccurred() {((struct JNINativeInterface*)ptr)->ExceptionOccurred} a -- a", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-ExceptionDescribe() {((struct JNINativeInterface*)ptr)->ExceptionDescribe} a -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-ExceptionClear() {((struct JNINativeInterface*)ptr)->ExceptionClear} a -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-FatalError() {((struct JNINativeInterface*)ptr)->FatalError} a s -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-PushLocalFrame() {((struct JNINativeInterface*)ptr)->PushLocalFrame} a n -- n", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-PopLocalFrame() {((struct JNINativeInterface*)ptr)->PopLocalFrame} a a -- a", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-NewGlobalRef() {((struct JNINativeInterface*)ptr)->NewGlobalRef} a a -- a", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-DeleteGlobalRef() {((struct JNINativeInterface*)ptr)->DeleteGlobalRef} a a -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-DeleteLocalRef() {((struct JNINativeInterface*)ptr)->DeleteLocalRef} a a -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-IsSameObject() {((struct JNINativeInterface*)ptr)->IsSameObject} a a a -- u", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-NewLocalRef() {((struct JNINativeInterface*)ptr)->NewLocalRef} a a -- a", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-EnsureLocalCapacity() {((struct JNINativeInterface*)ptr)->EnsureLocalCapacity} a n -- n", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-AllocObject() {((struct JNINativeInterface*)ptr)->AllocObject} a a -- a", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-NewObject() {((struct JNINativeInterface*)ptr)->NewObject} a a a ... -- a", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-NewObjectA() {((struct JNINativeInterface*)ptr)->NewObjectA} a a a a -- a", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-GetObjectClass() {((struct JNINativeInterface*)ptr)->GetObjectClass} a a -- a", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-IsInstanceOf() {((struct JNINativeInterface*)ptr)->IsInstanceOf} a a a -- u", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-GetMethodID() {((struct JNINativeInterface*)ptr)->GetMethodID} a a s s -- a", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallObjectMethod() {((struct JNINativeInterface*)ptr)->CallObjectMethod} a a a ... -- a", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallObjectMethodA() {((struct JNINativeInterface*)ptr)->CallObjectMethodA} a a a a -- a", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallBooleanMethod() {((struct JNINativeInterface*)ptr)->CallBooleanMethod} a a a ... -- u", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallBooleanMethodA() {((struct JNINativeInterface*)ptr)->CallBooleanMethodA} a a a a -- u", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallByteMethod() {((struct JNINativeInterface*)ptr)->CallByteMethod} a a a ... -- u", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallByteMethodA() {((struct JNINativeInterface*)ptr)->CallByteMethodA} a a a a -- u", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallCharMethod() {((struct JNINativeInterface*)ptr)->CallCharMethod} a a a ... -- n", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallCharMethodA() {((struct JNINativeInterface*)ptr)->CallCharMethodA} a a a a -- n", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallShortMethod() {((struct JNINativeInterface*)ptr)->CallShortMethod} a a a ... -- n", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallShortMethodA() {((struct JNINativeInterface*)ptr)->CallShortMethodA} a a a a -- n", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallIntMethod() {((struct JNINativeInterface*)ptr)->CallIntMethod} a a a ... -- n", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallIntMethodA() {((struct JNINativeInterface*)ptr)->CallIntMethodA} a a a a -- n", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallLongMethod() {((struct JNINativeInterface*)ptr)->CallLongMethod} a a a ... -- d", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallLongMethodA() {((struct JNINativeInterface*)ptr)->CallLongMethodA} a a a a -- d", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallFloatMethod() {((struct JNINativeInterface*)ptr)->CallFloatMethod} a a a ... -- r", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallFloatMethodA() {((struct JNINativeInterface*)ptr)->CallFloatMethodA} a a a a -- r", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallDoubleMethod() {((struct JNINativeInterface*)ptr)->CallDoubleMethod} a a a ... -- r", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallDoubleMethodA() {((struct JNINativeInterface*)ptr)->CallDoubleMethodA} a a a a -- r", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallVoidMethod() {((struct JNINativeInterface*)ptr)->CallVoidMethod} a a a ... -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallVoidMethodA() {((struct JNINativeInterface*)ptr)->CallVoidMethodA} a a a a -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallNonvirtualObjectMethod() {((struct JNINativeInterface*)ptr)->CallNonvirtualObjectMethod} a a a a ... -- a", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallNonvirtualObjectMethodA() {((struct JNINativeInterface*)ptr)->CallNonvirtualObjectMethodA} a a a a a -- a", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallNonvirtualBooleanMethod() {((struct JNINativeInterface*)ptr)->CallNonvirtualBooleanMethod} a a a a ... -- u", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallNonvirtualBooleanMethodA() {((struct JNINativeInterface*)ptr)->CallNonvirtualBooleanMethodA} a a a a a -- u", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallNonvirtualByteMethod() {((struct JNINativeInterface*)ptr)->CallNonvirtualByteMethod} a a a a ... -- u", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallNonvirtualByteMethodA() {((struct JNINativeInterface*)ptr)->CallNonvirtualByteMethodA} a a a a a -- u", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallNonvirtualCharMethod() {((struct JNINativeInterface*)ptr)->CallNonvirtualCharMethod} a a a a ... -- n", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallNonvirtualCharMethodA() {((struct JNINativeInterface*)ptr)->CallNonvirtualCharMethodA} a a a a a -- n", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallNonvirtualShortMethod() {((struct JNINativeInterface*)ptr)->CallNonvirtualShortMethod} a a a a ... -- n", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallNonvirtualShortMethodA() {((struct JNINativeInterface*)ptr)->CallNonvirtualShortMethodA} a a a a a -- n", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallNonvirtualIntMethod() {((struct JNINativeInterface*)ptr)->CallNonvirtualIntMethod} a a a a ... -- n", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallNonvirtualIntMethodA() {((struct JNINativeInterface*)ptr)->CallNonvirtualIntMethodA} a a a a a -- n", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallNonvirtualLongMethod() {((struct JNINativeInterface*)ptr)->CallNonvirtualLongMethod} a a a a ... -- d", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallNonvirtualLongMethodA() {((struct JNINativeInterface*)ptr)->CallNonvirtualLongMethodA} a a a a a -- d", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallNonvirtualFloatMethod() {((struct JNINativeInterface*)ptr)->CallNonvirtualFloatMethod} a a a a ... -- r", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallNonvirtualFloatMethodA() {((struct JNINativeInterface*)ptr)->CallNonvirtualFloatMethodA} a a a a a -- r", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallNonvirtualDoubleMethod() {((struct JNINativeInterface*)ptr)->CallNonvirtualDoubleMethod} a a a a ... -- r", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallNonvirtualDoubleMethodA() {((struct JNINativeInterface*)ptr)->CallNonvirtualDoubleMethodA} a a a a a -- r", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallNonvirtualVoidMethod() {((struct JNINativeInterface*)ptr)->CallNonvirtualVoidMethod} a a a a ... -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallNonvirtualVoidMethodA() {((struct JNINativeInterface*)ptr)->CallNonvirtualVoidMethodA} a a a a a -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-GetFieldID() {((struct JNINativeInterface*)ptr)->GetFieldID} a a s s -- a", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-GetObjectField() {((struct JNINativeInterface*)ptr)->GetObjectField} a a a -- a", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-GetBooleanField() {((struct JNINativeInterface*)ptr)->GetBooleanField} a a a -- u", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-GetByteField() {((struct JNINativeInterface*)ptr)->GetByteField} a a a -- u", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-GetCharField() {((struct JNINativeInterface*)ptr)->GetCharField} a a a -- n", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-GetShortField() {((struct JNINativeInterface*)ptr)->GetShortField} a a a -- n", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-GetIntField() {((struct JNINativeInterface*)ptr)->GetIntField} a a a -- n", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-GetLongField() {((struct JNINativeInterface*)ptr)->GetLongField} a a a -- d", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-GetFloatField() {((struct JNINativeInterface*)ptr)->GetFloatField} a a a -- r", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-GetDoubleField() {((struct JNINativeInterface*)ptr)->GetDoubleField} a a a -- r", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-SetObjectField() {((struct JNINativeInterface*)ptr)->SetObjectField} a a a a -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-SetBooleanField() {((struct JNINativeInterface*)ptr)->SetBooleanField} a a a u -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-SetByteField() {((struct JNINativeInterface*)ptr)->SetByteField} a a a u -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-SetCharField() {((struct JNINativeInterface*)ptr)->SetCharField} a a a n -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-SetShortField() {((struct JNINativeInterface*)ptr)->SetShortField} a a a n -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-SetIntField() {((struct JNINativeInterface*)ptr)->SetIntField} a a a n -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-SetLongField() {((struct JNINativeInterface*)ptr)->SetLongField} a a a d -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-SetFloatField() {((struct JNINativeInterface*)ptr)->SetFloatField} a a a r -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-SetDoubleField() {((struct JNINativeInterface*)ptr)->SetDoubleField} a a a r -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-GetStaticMethodID() {((struct JNINativeInterface*)ptr)->GetStaticMethodID} a a s s -- a", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallStaticObjectMethod() {((struct JNINativeInterface*)ptr)->CallStaticObjectMethod} a a a ... -- a", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallStaticObjectMethodA() {((struct JNINativeInterface*)ptr)->CallStaticObjectMethodA} a a a a -- a", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallStaticBooleanMethod() {((struct JNINativeInterface*)ptr)->CallStaticBooleanMethod} a a a ... -- u", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallStaticBooleanMethodA() {((struct JNINativeInterface*)ptr)->CallStaticBooleanMethodA} a a a a -- u", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallStaticByteMethod() {((struct JNINativeInterface*)ptr)->CallStaticByteMethod} a a a ... -- u", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallStaticByteMethodA() {((struct JNINativeInterface*)ptr)->CallStaticByteMethodA} a a a a -- u", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallStaticCharMethod() {((struct JNINativeInterface*)ptr)->CallStaticCharMethod} a a a ... -- n", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallStaticCharMethodA() {((struct JNINativeInterface*)ptr)->CallStaticCharMethodA} a a a a -- n", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallStaticShortMethod() {((struct JNINativeInterface*)ptr)->CallStaticShortMethod} a a a ... -- n", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallStaticShortMethodA() {((struct JNINativeInterface*)ptr)->CallStaticShortMethodA} a a a a -- n", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallStaticIntMethod() {((struct JNINativeInterface*)ptr)->CallStaticIntMethod} a a a ... -- n", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallStaticIntMethodA() {((struct JNINativeInterface*)ptr)->CallStaticIntMethodA} a a a a -- n", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallStaticLongMethod() {((struct JNINativeInterface*)ptr)->CallStaticLongMethod} a a a ... -- d", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallStaticLongMethodA() {((struct JNINativeInterface*)ptr)->CallStaticLongMethodA} a a a a -- d", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallStaticFloatMethod() {((struct JNINativeInterface*)ptr)->CallStaticFloatMethod} a a a ... -- r", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallStaticFloatMethodA() {((struct JNINativeInterface*)ptr)->CallStaticFloatMethodA} a a a a -- r", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallStaticDoubleMethod() {((struct JNINativeInterface*)ptr)->CallStaticDoubleMethod} a a a ... -- r", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallStaticDoubleMethodA() {((struct JNINativeInterface*)ptr)->CallStaticDoubleMethodA} a a a a -- r", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallStaticVoidMethod() {((struct JNINativeInterface*)ptr)->CallStaticVoidMethod} a a a ... -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-CallStaticVoidMethodA() {((struct JNINativeInterface*)ptr)->CallStaticVoidMethodA} a a a a -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-GetStaticFieldID() {((struct JNINativeInterface*)ptr)->GetStaticFieldID} a a s s -- a", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-GetStaticObjectField() {((struct JNINativeInterface*)ptr)->GetStaticObjectField} a a a -- a", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-GetStaticBooleanField() {((struct JNINativeInterface*)ptr)->GetStaticBooleanField} a a a -- u", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-GetStaticByteField() {((struct JNINativeInterface*)ptr)->GetStaticByteField} a a a -- u", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-GetStaticCharField() {((struct JNINativeInterface*)ptr)->GetStaticCharField} a a a -- n", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-GetStaticShortField() {((struct JNINativeInterface*)ptr)->GetStaticShortField} a a a -- n", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-GetStaticIntField() {((struct JNINativeInterface*)ptr)->GetStaticIntField} a a a -- n", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-GetStaticLongField() {((struct JNINativeInterface*)ptr)->GetStaticLongField} a a a -- d", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-GetStaticFloatField() {((struct JNINativeInterface*)ptr)->GetStaticFloatField} a a a -- r", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-GetStaticDoubleField() {((struct JNINativeInterface*)ptr)->GetStaticDoubleField} a a a -- r", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-SetStaticObjectField() {((struct JNINativeInterface*)ptr)->SetStaticObjectField} a a a a -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-SetStaticBooleanField() {((struct JNINativeInterface*)ptr)->SetStaticBooleanField} a a a u -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-SetStaticByteField() {((struct JNINativeInterface*)ptr)->SetStaticByteField} a a a u -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-SetStaticCharField() {((struct JNINativeInterface*)ptr)->SetStaticCharField} a a a n -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-SetStaticShortField() {((struct JNINativeInterface*)ptr)->SetStaticShortField} a a a n -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-SetStaticIntField() {((struct JNINativeInterface*)ptr)->SetStaticIntField} a a a n -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-SetStaticLongField() {((struct JNINativeInterface*)ptr)->SetStaticLongField} a a a d -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-SetStaticFloatField() {((struct JNINativeInterface*)ptr)->SetStaticFloatField} a a a r -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-SetStaticDoubleField() {((struct JNINativeInterface*)ptr)->SetStaticDoubleField} a a a r -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-NewString() {((struct JNINativeInterface*)ptr)->NewString} a a n -- a", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-GetStringLength() {((struct JNINativeInterface*)ptr)->GetStringLength} a a -- n", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-GetStringChars() {((struct JNINativeInterface*)ptr)->GetStringChars} a a a -- a", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-ReleaseStringChars() {((struct JNINativeInterface*)ptr)->ReleaseStringChars} a a a -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-NewStringUTF() {((struct JNINativeInterface*)ptr)->NewStringUTF} a s -- a", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-GetStringUTFLength() {((struct JNINativeInterface*)ptr)->GetStringUTFLength} a a -- n", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-GetStringUTFChars() {((struct JNINativeInterface*)ptr)->GetStringUTFChars} a a a -- s", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-ReleaseStringUTFChars() {((struct JNINativeInterface*)ptr)->ReleaseStringUTFChars} a a s -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-GetArrayLength() {((struct JNINativeInterface*)ptr)->GetArrayLength} a a -- n", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-NewObjectArray() {((struct JNINativeInterface*)ptr)->NewObjectArray} a n a a -- a", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-GetObjectArrayElement() {((struct JNINativeInterface*)ptr)->GetObjectArrayElement} a a n -- a", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-SetObjectArrayElement() {((struct JNINativeInterface*)ptr)->SetObjectArrayElement} a a n a -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-NewBooleanArray() {((struct JNINativeInterface*)ptr)->NewBooleanArray} a n -- a", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-NewByteArray() {((struct JNINativeInterface*)ptr)->NewByteArray} a n -- a", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-NewCharArray() {((struct JNINativeInterface*)ptr)->NewCharArray} a n -- a", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-NewShortArray() {((struct JNINativeInterface*)ptr)->NewShortArray} a n -- a", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-NewIntArray() {((struct JNINativeInterface*)ptr)->NewIntArray} a n -- a", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-NewLongArray() {((struct JNINativeInterface*)ptr)->NewLongArray} a n -- a", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-NewFloatArray() {((struct JNINativeInterface*)ptr)->NewFloatArray} a n -- a", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-NewDoubleArray() {((struct JNINativeInterface*)ptr)->NewDoubleArray} a n -- a", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-GetBooleanArrayElements() {((struct JNINativeInterface*)ptr)->GetBooleanArrayElements} a a a -- a", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-GetByteArrayElements() {((struct JNINativeInterface*)ptr)->GetByteArrayElements} a a a -- a", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-GetCharArrayElements() {((struct JNINativeInterface*)ptr)->GetCharArrayElements} a a a -- a", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-GetShortArrayElements() {((struct JNINativeInterface*)ptr)->GetShortArrayElements} a a a -- a", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-GetIntArrayElements() {((struct JNINativeInterface*)ptr)->GetIntArrayElements} a a a -- a", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-GetLongArrayElements() {((struct JNINativeInterface*)ptr)->GetLongArrayElements} a a a -- a", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-GetFloatArrayElements() {((struct JNINativeInterface*)ptr)->GetFloatArrayElements} a a a -- a", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-GetDoubleArrayElements() {((struct JNINativeInterface*)ptr)->GetDoubleArrayElements} a a a -- a", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-ReleaseBooleanArrayElements() {((struct JNINativeInterface*)ptr)->ReleaseBooleanArrayElements} a a a n -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-ReleaseByteArrayElements() {((struct JNINativeInterface*)ptr)->ReleaseByteArrayElements} a a a n -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-ReleaseCharArrayElements() {((struct JNINativeInterface*)ptr)->ReleaseCharArrayElements} a a a n -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-ReleaseShortArrayElements() {((struct JNINativeInterface*)ptr)->ReleaseShortArrayElements} a a a n -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-ReleaseIntArrayElements() {((struct JNINativeInterface*)ptr)->ReleaseIntArrayElements} a a a n -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-ReleaseLongArrayElements() {((struct JNINativeInterface*)ptr)->ReleaseLongArrayElements} a a a n -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-ReleaseFloatArrayElements() {((struct JNINativeInterface*)ptr)->ReleaseFloatArrayElements} a a a n -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-ReleaseDoubleArrayElements() {((struct JNINativeInterface*)ptr)->ReleaseDoubleArrayElements} a a a n -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-GetBooleanArrayRegion() {((struct JNINativeInterface*)ptr)->GetBooleanArrayRegion} a a n n a -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-GetByteArrayRegion() {((struct JNINativeInterface*)ptr)->GetByteArrayRegion} a a n n a -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-GetCharArrayRegion() {((struct JNINativeInterface*)ptr)->GetCharArrayRegion} a a n n a -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-GetShortArrayRegion() {((struct JNINativeInterface*)ptr)->GetShortArrayRegion} a a n n a -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-GetIntArrayRegion() {((struct JNINativeInterface*)ptr)->GetIntArrayRegion} a a n n a -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-GetLongArrayRegion() {((struct JNINativeInterface*)ptr)->GetLongArrayRegion} a a n n a -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-GetFloatArrayRegion() {((struct JNINativeInterface*)ptr)->GetFloatArrayRegion} a a n n a -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-GetDoubleArrayRegion() {((struct JNINativeInterface*)ptr)->GetDoubleArrayRegion} a a n n a -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-SetBooleanArrayRegion() {((struct JNINativeInterface*)ptr)->SetBooleanArrayRegion} a a n n a -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-SetByteArrayRegion() {((struct JNINativeInterface*)ptr)->SetByteArrayRegion} a a n n a -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-SetCharArrayRegion() {((struct JNINativeInterface*)ptr)->SetCharArrayRegion} a a n n a -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-SetShortArrayRegion() {((struct JNINativeInterface*)ptr)->SetShortArrayRegion} a a n n a -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-SetIntArrayRegion() {((struct JNINativeInterface*)ptr)->SetIntArrayRegion} a a n n a -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-SetLongArrayRegion() {((struct JNINativeInterface*)ptr)->SetLongArrayRegion} a a n n a -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-SetFloatArrayRegion() {((struct JNINativeInterface*)ptr)->SetFloatArrayRegion} a a n n a -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-SetDoubleArrayRegion() {((struct JNINativeInterface*)ptr)->SetDoubleArrayRegion} a a n n a -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-RegisterNatives() {((struct JNINativeInterface*)ptr)->RegisterNatives} a a a n -- n", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-UnregisterNatives() {((struct JNINativeInterface*)ptr)->UnregisterNatives} a a -- n", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-MonitorEnter() {((struct JNINativeInterface*)ptr)->MonitorEnter} a a -- n", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-MonitorExit() {((struct JNINativeInterface*)ptr)->MonitorExit} a a -- n", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-GetJavaVM() {((struct JNINativeInterface*)ptr)->GetJavaVM} a a -- n", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-GetStringRegion() {((struct JNINativeInterface*)ptr)->GetStringRegion} a a n n a -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-GetStringUTFRegion() {((struct JNINativeInterface*)ptr)->GetStringUTFRegion} a a n n a -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-GetPrimitiveArrayCritical() {((struct JNINativeInterface*)ptr)->GetPrimitiveArrayCritical} a a a -- a", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-ReleasePrimitiveArrayCritical() {((struct JNINativeInterface*)ptr)->ReleasePrimitiveArrayCritical} a a a n -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-GetStringCritical() {((struct JNINativeInterface*)ptr)->GetStringCritical} a a a -- a", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-ReleaseStringCritical() {((struct JNINativeInterface*)ptr)->ReleaseStringCritical} a a a -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-NewWeakGlobalRef() {((struct JNINativeInterface*)ptr)->NewWeakGlobalRef} a a -- a", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-DeleteWeakGlobalRef() {((struct JNINativeInterface*)ptr)->DeleteWeakGlobalRef} a a -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-ExceptionCheck() {((struct JNINativeInterface*)ptr)->ExceptionCheck} a -- u", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-NewDirectByteBuffer() {((struct JNINativeInterface*)ptr)->NewDirectByteBuffer} a a d -- a", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-GetDirectBufferAddress() {((struct JNINativeInterface*)ptr)->GetDirectBufferAddress} a a -- a", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-GetDirectBufferCapacity() {((struct JNINativeInterface*)ptr)->GetDirectBufferCapacity} a a -- d", "", "", "" );
	swigFunctionPointer( "c-funptr JNINativeInterface-GetObjectRefType() {((struct JNINativeInterface*)ptr)->GetObjectRefType} a a -- n", "", "", "" );
	swigFunctionPointer( "c-funptr JNIInvokeInterface-DestroyJavaVM() {((struct JNIInvokeInterface*)ptr)->DestroyJavaVM} a -- n", "", "", "" );
	swigFunctionPointer( "c-funptr JNIInvokeInterface-AttachCurrentThread() {((struct JNIInvokeInterface*)ptr)->AttachCurrentThread} a a a -- n", "", "", "" );
	swigFunctionPointer( "c-funptr JNIInvokeInterface-DetachCurrentThread() {((struct JNIInvokeInterface*)ptr)->DetachCurrentThread} a -- n", "", "", "" );
	swigFunctionPointer( "c-funptr JNIInvokeInterface-GetEnv() {((struct JNIInvokeInterface*)ptr)->GetEnv} a a n -- n", "", "", "" );
	swigFunctionPointer( "c-funptr JNIInvokeInterface-AttachCurrentThreadAsDaemon() {((struct JNIInvokeInterface*)ptr)->AttachCurrentThreadAsDaemon} a a a -- n", "", "", "" );
	swigFunctionPointer( "c-funptr JDK1_1InitArgs-exit() {((struct JDK1_1InitArgs*)ptr)->exit} n -- void", "", "", "" );
	swigFunctionPointer( "c-funptr JDK1_1InitArgs-abort() {((struct JDK1_1InitArgs*)ptr)->abort}  -- void", "", "", "" );

	swigNewline();

	swigComment("------===< functions >===-------\n");
	swigFunction( "c-function JNI_OnLoad JNI_OnLoad a a -- n", "FUNCTION: JNI_OnLoad", "EXTERN: n C JNI_OnLoad( a a );", "" );
	swigFunction( "c-function JNI_OnUnload JNI_OnUnload a a -- void", "FUNCTION: JNI_OnUnload", "EXTERN: void C JNI_OnUnload( a a );", "" );
	swigFunction( "c-function JNI_GetDefaultJavaVMInitArgs JNI_GetDefaultJavaVMInitArgs a -- n", "FUNCTION: JNI_GetDefaultJavaVMInitArgs", "EXTERN: n C JNI_GetDefaultJavaVMInitArgs( a );", "" );
	swigFunction( "c-function JNI_CreateJavaVM JNI_CreateJavaVM a a a -- n", "FUNCTION: JNI_CreateJavaVM", "EXTERN: n C JNI_CreateJavaVM( a a a );", "" );
	swigFunction( "c-function JNI_GetCreatedJavaVMs JNI_GetCreatedJavaVMs a n a -- n", "FUNCTION: JNI_GetCreatedJavaVMs", "EXTERN: n C JNI_GetCreatedJavaVMs( a n a );", "" );
	
	return 0;
} /* end of main */



