/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 3.0.9
 *
 * This file is not intended to be easily readable and contains a number of
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG
 * interface file instead.
 * ----------------------------------------------------------------------------- */
#include <stdio.h>
#include <string.h>
#include <stddef.h>



#include <vulkan/vulkan.h>

typedef enum{ NONE = -1, GFORTH = 0, SWIFTFORTH, VFX } SwigTargetSystem;
SwigTargetSystem swigTargetSystem = NONE;

unsigned char swigPrintStackComments = 1;

/* comments */
void swigNewline()
{
	printf( "\n" );
}

void swigComment( char *comment )
{
	printf( "\\ %s", comment );
}

/* constants */
void swigIntConstant( long constant, char *name )
{
	printf( "#%ld\tconstant %s\n", constant, name );
}

void swigUnsignedIntConstant( unsigned long constant, char *name )
{
	printf( "#%lu\tconstant %s\n", constant, name );
}

void swigLongConstant( long long constant, char *name )
{
	printf( "#%lld.\t2constant %s\n", constant, name );
}

void swigUnsignedLongConstant( unsigned long long constant, char *name )
{
	printf( "#%llu.\t2constant %s\n", constant, name );
}

void swigFloatConstant( double constant, char *name )
{
	char buffer[128];
	sprintf( buffer, "%f", constant );

	/* if the constant contains no exponent, add one */
	char *s;
	for( s = buffer; *s != 0; s++ )
		if( *s == 'e' || *s == 'E' )
			break;

	/* exponent found */
	if( *s != 0 )
		printf( "%s\tfconstant %s\n", buffer, name );
	/* not found */
	else
		printf( "%se0\tfconstant %s\n", buffer, name );
}

void swigStringConstant( char* constant, char *name )
{
	char c;
	printf( ": %s s\\\" ", name );
	while(( c = *constant++ ))
	{
		switch(c)
		{
			case '\b': printf( "\\b" ); break;
			case '\n': printf( "\\n" ); break;
			case '\f': printf( "\\f" ); break;
			case '\r': printf( "\\r" ); break;
			case '\t': printf( "\\t" ); break;
			case '"' : printf( "\\q" ); break;
			default:
				if(c < 0x20)
					printf("\\x%02x", c);
				else
					printf("%c", c); break;
		}
	}
	printf(	"\" ;\n" );
}

/* structs */
void swigStructField( char *name, size_t offset, size_t size )
{
	printf( "\tdrop %zu %zu +field %s\n", offset, size, name );
}

/* functions */
void swigFunction( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	if( swigTargetSystem == GFORTH )
		printf( "%s", gforth );
	else if( swigTargetSystem == SWIFTFORTH )
		printf( "%s", swiftForth );
	else if( swigTargetSystem == VFX )
		printf( "%s", vfx );

	if( swigPrintStackComments )
		printf( "%s", stackComment );

	printf( "\n" );
}

/* function pointers */
void swigFunctionPointer( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	swigFunction( gforth, swiftForth, vfx, stackComment );
}

/* callbacks */
void swigCallback( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	swigFunction( gforth, swiftForth, vfx, stackComment );
}

void swigUsage( char **argv )
{
	fprintf( stderr, "Usage: %s [-gforth|-swiftforth|-vfx]\n", argv[0] );
}

int main( int argc, char **argv )
{
	int i;

	/* check arguments */
	for( i = 1; i < argc; i++ )
		if( strcmp( argv[i], "-gforth" ) == 0 )
			swigTargetSystem = GFORTH;
		else if( strcmp( argv[i], "-swiftforth" ) == 0 )
			swigTargetSystem = SWIFTFORTH;
		else if( strcmp( argv[i], "-vfx" ) == 0 )
			swigTargetSystem = VFX;

	if( swigTargetSystem == NONE )
	{
		fprintf( stderr, "Error: no target system specified\n" );
		swigUsage( argv );
		return 1;
	}

	/* primer */
	printf( "\\ This file has been generated using SWIG and fsi,\n"
		"\\ and is already platform dependent, search for the corresponding\n"
		"\\ fsi-file to compile it where no one has compiled it before ;)\n"
		"\\ GForth has its own dynamic loader and doesn't need addional C-Code.\n"
		"\\ That's why this file contains normal Gforth-code( version 0.6.9 or higher )\n"
		"\\ and could be used directly with include or require.\n"
		"\\ As all comments are stripped during the compilation, please\n"
		"\\ insert the copyright notice of the original file here.\n"
	);



	swigNewline();

	swigComment("----===< int constants ===>-----\n");
	#ifdef VULKAN_H_
		swigIntConstant( VULKAN_H_, "VULKAN_H_" );
	#endif
	#ifdef VK_VERSION_1_0
		swigIntConstant( VK_VERSION_1_0, "VK_VERSION_1_0" );
	#endif
	#ifdef VK_API_VERSION_1_0
		swigIntConstant( VK_API_VERSION_1_0, "VK_API_VERSION_1_0" );
	#endif
	#ifdef VK_HEADER_VERSION
		swigIntConstant( VK_HEADER_VERSION, "VK_HEADER_VERSION" );
	#endif
	#ifdef VK_NULL_HANDLE
		swigIntConstant( VK_NULL_HANDLE, "VK_NULL_HANDLE" );
	#endif
	#ifdef VK_REMAINING_MIP_LEVELS
		swigUnsignedIntConstant( VK_REMAINING_MIP_LEVELS, "VK_REMAINING_MIP_LEVELS" );
	#endif
	#ifdef VK_REMAINING_ARRAY_LAYERS
		swigUnsignedIntConstant( VK_REMAINING_ARRAY_LAYERS, "VK_REMAINING_ARRAY_LAYERS" );
	#endif
	#ifdef VK_ATTACHMENT_UNUSED
		swigUnsignedIntConstant( VK_ATTACHMENT_UNUSED, "VK_ATTACHMENT_UNUSED" );
	#endif
	#ifdef VK_TRUE
		swigIntConstant( VK_TRUE, "VK_TRUE" );
	#endif
	#ifdef VK_FALSE
		swigIntConstant( VK_FALSE, "VK_FALSE" );
	#endif
	#ifdef VK_QUEUE_FAMILY_IGNORED
		swigUnsignedIntConstant( VK_QUEUE_FAMILY_IGNORED, "VK_QUEUE_FAMILY_IGNORED" );
	#endif
	#ifdef VK_SUBPASS_EXTERNAL
		swigUnsignedIntConstant( VK_SUBPASS_EXTERNAL, "VK_SUBPASS_EXTERNAL" );
	#endif
	#ifdef VK_MAX_PHYSICAL_DEVICE_NAME_SIZE
		swigIntConstant( VK_MAX_PHYSICAL_DEVICE_NAME_SIZE, "VK_MAX_PHYSICAL_DEVICE_NAME_SIZE" );
	#endif
	#ifdef VK_UUID_SIZE
		swigIntConstant( VK_UUID_SIZE, "VK_UUID_SIZE" );
	#endif
	#ifdef VK_MAX_MEMORY_TYPES
		swigIntConstant( VK_MAX_MEMORY_TYPES, "VK_MAX_MEMORY_TYPES" );
	#endif
	#ifdef VK_MAX_MEMORY_HEAPS
		swigIntConstant( VK_MAX_MEMORY_HEAPS, "VK_MAX_MEMORY_HEAPS" );
	#endif
	#ifdef VK_MAX_EXTENSION_NAME_SIZE
		swigIntConstant( VK_MAX_EXTENSION_NAME_SIZE, "VK_MAX_EXTENSION_NAME_SIZE" );
	#endif
	#ifdef VK_MAX_DESCRIPTION_SIZE
		swigIntConstant( VK_MAX_DESCRIPTION_SIZE, "VK_MAX_DESCRIPTION_SIZE" );
	#endif
	#ifdef VK_KHR_surface
		swigIntConstant( VK_KHR_surface, "VK_KHR_surface" );
	#endif
	#ifdef VK_KHR_SURFACE_SPEC_VERSION
		swigIntConstant( VK_KHR_SURFACE_SPEC_VERSION, "VK_KHR_SURFACE_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_swapchain
		swigIntConstant( VK_KHR_swapchain, "VK_KHR_swapchain" );
	#endif
	#ifdef VK_KHR_SWAPCHAIN_SPEC_VERSION
		swigIntConstant( VK_KHR_SWAPCHAIN_SPEC_VERSION, "VK_KHR_SWAPCHAIN_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_display
		swigIntConstant( VK_KHR_display, "VK_KHR_display" );
	#endif
	#ifdef VK_KHR_DISPLAY_SPEC_VERSION
		swigIntConstant( VK_KHR_DISPLAY_SPEC_VERSION, "VK_KHR_DISPLAY_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_display_swapchain
		swigIntConstant( VK_KHR_display_swapchain, "VK_KHR_display_swapchain" );
	#endif
	#ifdef VK_KHR_DISPLAY_SWAPCHAIN_SPEC_VERSION
		swigIntConstant( VK_KHR_DISPLAY_SWAPCHAIN_SPEC_VERSION, "VK_KHR_DISPLAY_SWAPCHAIN_SPEC_VERSION" );
	#endif
	#ifdef VK_KHR_sampler_mirror_clamp_to_edge
		swigIntConstant( VK_KHR_sampler_mirror_clamp_to_edge, "VK_KHR_sampler_mirror_clamp_to_edge" );
	#endif
	#ifdef VK_KHR_SAMPLER_MIRROR_CLAMP_TO_EDGE_SPEC_VERSION
		swigIntConstant( VK_KHR_SAMPLER_MIRROR_CLAMP_TO_EDGE_SPEC_VERSION, "VK_KHR_SAMPLER_MIRROR_CLAMP_TO_EDGE_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_debug_report
		swigIntConstant( VK_EXT_debug_report, "VK_EXT_debug_report" );
	#endif
	#ifdef VK_EXT_DEBUG_REPORT_SPEC_VERSION
		swigIntConstant( VK_EXT_DEBUG_REPORT_SPEC_VERSION, "VK_EXT_DEBUG_REPORT_SPEC_VERSION" );
	#endif
	#ifdef VK_NV_glsl_shader
		swigIntConstant( VK_NV_glsl_shader, "VK_NV_glsl_shader" );
	#endif
	#ifdef VK_NV_GLSL_SHADER_SPEC_VERSION
		swigIntConstant( VK_NV_GLSL_SHADER_SPEC_VERSION, "VK_NV_GLSL_SHADER_SPEC_VERSION" );
	#endif
	#ifdef VK_IMG_filter_cubic
		swigIntConstant( VK_IMG_filter_cubic, "VK_IMG_filter_cubic" );
	#endif
	#ifdef VK_IMG_FILTER_CUBIC_SPEC_VERSION
		swigIntConstant( VK_IMG_FILTER_CUBIC_SPEC_VERSION, "VK_IMG_FILTER_CUBIC_SPEC_VERSION" );
	#endif
	#ifdef VK_AMD_rasterization_order
		swigIntConstant( VK_AMD_rasterization_order, "VK_AMD_rasterization_order" );
	#endif
	#ifdef VK_AMD_RASTERIZATION_ORDER_SPEC_VERSION
		swigIntConstant( VK_AMD_RASTERIZATION_ORDER_SPEC_VERSION, "VK_AMD_RASTERIZATION_ORDER_SPEC_VERSION" );
	#endif
	#ifdef VK_EXT_debug_marker
		swigIntConstant( VK_EXT_debug_marker, "VK_EXT_debug_marker" );
	#endif
	#ifdef VK_EXT_DEBUG_MARKER_SPEC_VERSION
		swigIntConstant( VK_EXT_DEBUG_MARKER_SPEC_VERSION, "VK_EXT_DEBUG_MARKER_SPEC_VERSION" );
	#endif

	swigNewline();

	swigComment("----===< long constants ===>-----\n");
	#ifdef VK_WHOLE_SIZE
		swigUnsignedLongConstant( VK_WHOLE_SIZE, "VK_WHOLE_SIZE" );
	#endif

	swigNewline();

	swigComment("---===< float constants >===----\n");
	#ifdef VK_LOD_CLAMP_NONE
		swigFloatConstant( VK_LOD_CLAMP_NONE, "VK_LOD_CLAMP_NONE" );
	#endif

	swigNewline();

	swigComment("--------===< enums >===---------\n");
	swigIntConstant( VK_PIPELINE_CACHE_HEADER_VERSION_ONE, "VK_PIPELINE_CACHE_HEADER_VERSION_ONE" );
	swigIntConstant( VK_PIPELINE_CACHE_HEADER_VERSION_BEGIN_RANGE, "VK_PIPELINE_CACHE_HEADER_VERSION_BEGIN_RANGE" );
	swigIntConstant( VK_PIPELINE_CACHE_HEADER_VERSION_END_RANGE, "VK_PIPELINE_CACHE_HEADER_VERSION_END_RANGE" );
	swigIntConstant( VK_PIPELINE_CACHE_HEADER_VERSION_RANGE_SIZE, "VK_PIPELINE_CACHE_HEADER_VERSION_RANGE_SIZE" );
	swigIntConstant( VK_PIPELINE_CACHE_HEADER_VERSION_MAX_ENUM, "VK_PIPELINE_CACHE_HEADER_VERSION_MAX_ENUM" );
	swigIntConstant( VK_SUCCESS, "VK_SUCCESS" );
	swigIntConstant( VK_NOT_READY, "VK_NOT_READY" );
	swigIntConstant( VK_TIMEOUT, "VK_TIMEOUT" );
	swigIntConstant( VK_EVENT_SET, "VK_EVENT_SET" );
	swigIntConstant( VK_EVENT_RESET, "VK_EVENT_RESET" );
	swigIntConstant( VK_INCOMPLETE, "VK_INCOMPLETE" );
	swigIntConstant( VK_ERROR_OUT_OF_HOST_MEMORY, "VK_ERROR_OUT_OF_HOST_MEMORY" );
	swigIntConstant( VK_ERROR_OUT_OF_DEVICE_MEMORY, "VK_ERROR_OUT_OF_DEVICE_MEMORY" );
	swigIntConstant( VK_ERROR_INITIALIZATION_FAILED, "VK_ERROR_INITIALIZATION_FAILED" );
	swigIntConstant( VK_ERROR_DEVICE_LOST, "VK_ERROR_DEVICE_LOST" );
	swigIntConstant( VK_ERROR_MEMORY_MAP_FAILED, "VK_ERROR_MEMORY_MAP_FAILED" );
	swigIntConstant( VK_ERROR_LAYER_NOT_PRESENT, "VK_ERROR_LAYER_NOT_PRESENT" );
	swigIntConstant( VK_ERROR_EXTENSION_NOT_PRESENT, "VK_ERROR_EXTENSION_NOT_PRESENT" );
	swigIntConstant( VK_ERROR_FEATURE_NOT_PRESENT, "VK_ERROR_FEATURE_NOT_PRESENT" );
	swigIntConstant( VK_ERROR_INCOMPATIBLE_DRIVER, "VK_ERROR_INCOMPATIBLE_DRIVER" );
	swigIntConstant( VK_ERROR_TOO_MANY_OBJECTS, "VK_ERROR_TOO_MANY_OBJECTS" );
	swigIntConstant( VK_ERROR_FORMAT_NOT_SUPPORTED, "VK_ERROR_FORMAT_NOT_SUPPORTED" );
	swigIntConstant( VK_ERROR_SURFACE_LOST_KHR, "VK_ERROR_SURFACE_LOST_KHR" );
	swigIntConstant( VK_ERROR_NATIVE_WINDOW_IN_USE_KHR, "VK_ERROR_NATIVE_WINDOW_IN_USE_KHR" );
	swigIntConstant( VK_SUBOPTIMAL_KHR, "VK_SUBOPTIMAL_KHR" );
	swigIntConstant( VK_ERROR_OUT_OF_DATE_KHR, "VK_ERROR_OUT_OF_DATE_KHR" );
	swigIntConstant( VK_ERROR_INCOMPATIBLE_DISPLAY_KHR, "VK_ERROR_INCOMPATIBLE_DISPLAY_KHR" );
	swigIntConstant( VK_ERROR_VALIDATION_FAILED_EXT, "VK_ERROR_VALIDATION_FAILED_EXT" );
	swigIntConstant( VK_ERROR_INVALID_SHADER_NV, "VK_ERROR_INVALID_SHADER_NV" );
	swigIntConstant( VK_RESULT_BEGIN_RANGE, "VK_RESULT_BEGIN_RANGE" );
	swigIntConstant( VK_RESULT_END_RANGE, "VK_RESULT_END_RANGE" );
	swigIntConstant( VK_RESULT_RANGE_SIZE, "VK_RESULT_RANGE_SIZE" );
	swigIntConstant( VK_RESULT_MAX_ENUM, "VK_RESULT_MAX_ENUM" );
	swigIntConstant( VK_STRUCTURE_TYPE_APPLICATION_INFO, "VK_STRUCTURE_TYPE_APPLICATION_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_INSTANCE_CREATE_INFO, "VK_STRUCTURE_TYPE_INSTANCE_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_DEVICE_QUEUE_CREATE_INFO, "VK_STRUCTURE_TYPE_DEVICE_QUEUE_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_DEVICE_CREATE_INFO, "VK_STRUCTURE_TYPE_DEVICE_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_SUBMIT_INFO, "VK_STRUCTURE_TYPE_SUBMIT_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_INFO, "VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_MAPPED_MEMORY_RANGE, "VK_STRUCTURE_TYPE_MAPPED_MEMORY_RANGE" );
	swigIntConstant( VK_STRUCTURE_TYPE_BIND_SPARSE_INFO, "VK_STRUCTURE_TYPE_BIND_SPARSE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_FENCE_CREATE_INFO, "VK_STRUCTURE_TYPE_FENCE_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_SEMAPHORE_CREATE_INFO, "VK_STRUCTURE_TYPE_SEMAPHORE_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_EVENT_CREATE_INFO, "VK_STRUCTURE_TYPE_EVENT_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_QUERY_POOL_CREATE_INFO, "VK_STRUCTURE_TYPE_QUERY_POOL_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_BUFFER_CREATE_INFO, "VK_STRUCTURE_TYPE_BUFFER_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_BUFFER_VIEW_CREATE_INFO, "VK_STRUCTURE_TYPE_BUFFER_VIEW_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_IMAGE_CREATE_INFO, "VK_STRUCTURE_TYPE_IMAGE_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_IMAGE_VIEW_CREATE_INFO, "VK_STRUCTURE_TYPE_IMAGE_VIEW_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_SHADER_MODULE_CREATE_INFO, "VK_STRUCTURE_TYPE_SHADER_MODULE_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_PIPELINE_CACHE_CREATE_INFO, "VK_STRUCTURE_TYPE_PIPELINE_CACHE_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_CREATE_INFO, "VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_STATE_CREATE_INFO, "VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_STATE_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_PIPELINE_INPUT_ASSEMBLY_STATE_CREATE_INFO, "VK_STRUCTURE_TYPE_PIPELINE_INPUT_ASSEMBLY_STATE_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_STATE_CREATE_INFO, "VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_STATE_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_STATE_CREATE_INFO, "VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_STATE_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_CREATE_INFO, "VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_PIPELINE_MULTISAMPLE_STATE_CREATE_INFO, "VK_STRUCTURE_TYPE_PIPELINE_MULTISAMPLE_STATE_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_PIPELINE_DEPTH_STENCIL_STATE_CREATE_INFO, "VK_STRUCTURE_TYPE_PIPELINE_DEPTH_STENCIL_STATE_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_PIPELINE_COLOR_BLEND_STATE_CREATE_INFO, "VK_STRUCTURE_TYPE_PIPELINE_COLOR_BLEND_STATE_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_PIPELINE_DYNAMIC_STATE_CREATE_INFO, "VK_STRUCTURE_TYPE_PIPELINE_DYNAMIC_STATE_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_CREATE_INFO, "VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_COMPUTE_PIPELINE_CREATE_INFO, "VK_STRUCTURE_TYPE_COMPUTE_PIPELINE_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_PIPELINE_LAYOUT_CREATE_INFO, "VK_STRUCTURE_TYPE_PIPELINE_LAYOUT_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_SAMPLER_CREATE_INFO, "VK_STRUCTURE_TYPE_SAMPLER_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_CREATE_INFO, "VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_CREATE_INFO, "VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_DESCRIPTOR_SET_ALLOCATE_INFO, "VK_STRUCTURE_TYPE_DESCRIPTOR_SET_ALLOCATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET, "VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET" );
	swigIntConstant( VK_STRUCTURE_TYPE_COPY_DESCRIPTOR_SET, "VK_STRUCTURE_TYPE_COPY_DESCRIPTOR_SET" );
	swigIntConstant( VK_STRUCTURE_TYPE_FRAMEBUFFER_CREATE_INFO, "VK_STRUCTURE_TYPE_FRAMEBUFFER_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO, "VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_COMMAND_POOL_CREATE_INFO, "VK_STRUCTURE_TYPE_COMMAND_POOL_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_COMMAND_BUFFER_ALLOCATE_INFO, "VK_STRUCTURE_TYPE_COMMAND_BUFFER_ALLOCATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_INFO, "VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_COMMAND_BUFFER_BEGIN_INFO, "VK_STRUCTURE_TYPE_COMMAND_BUFFER_BEGIN_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_RENDER_PASS_BEGIN_INFO, "VK_STRUCTURE_TYPE_RENDER_PASS_BEGIN_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER, "VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER" );
	swigIntConstant( VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER, "VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER" );
	swigIntConstant( VK_STRUCTURE_TYPE_MEMORY_BARRIER, "VK_STRUCTURE_TYPE_MEMORY_BARRIER" );
	swigIntConstant( VK_STRUCTURE_TYPE_LOADER_INSTANCE_CREATE_INFO, "VK_STRUCTURE_TYPE_LOADER_INSTANCE_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_LOADER_DEVICE_CREATE_INFO, "VK_STRUCTURE_TYPE_LOADER_DEVICE_CREATE_INFO" );
	swigIntConstant( VK_STRUCTURE_TYPE_SWAPCHAIN_CREATE_INFO_KHR, "VK_STRUCTURE_TYPE_SWAPCHAIN_CREATE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_PRESENT_INFO_KHR, "VK_STRUCTURE_TYPE_PRESENT_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_DISPLAY_MODE_CREATE_INFO_KHR, "VK_STRUCTURE_TYPE_DISPLAY_MODE_CREATE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_DISPLAY_SURFACE_CREATE_INFO_KHR, "VK_STRUCTURE_TYPE_DISPLAY_SURFACE_CREATE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_DISPLAY_PRESENT_INFO_KHR, "VK_STRUCTURE_TYPE_DISPLAY_PRESENT_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_XLIB_SURFACE_CREATE_INFO_KHR, "VK_STRUCTURE_TYPE_XLIB_SURFACE_CREATE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_XCB_SURFACE_CREATE_INFO_KHR, "VK_STRUCTURE_TYPE_XCB_SURFACE_CREATE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_WAYLAND_SURFACE_CREATE_INFO_KHR, "VK_STRUCTURE_TYPE_WAYLAND_SURFACE_CREATE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_MIR_SURFACE_CREATE_INFO_KHR, "VK_STRUCTURE_TYPE_MIR_SURFACE_CREATE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_ANDROID_SURFACE_CREATE_INFO_KHR, "VK_STRUCTURE_TYPE_ANDROID_SURFACE_CREATE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_WIN32_SURFACE_CREATE_INFO_KHR, "VK_STRUCTURE_TYPE_WIN32_SURFACE_CREATE_INFO_KHR" );
	swigIntConstant( VK_STRUCTURE_TYPE_DEBUG_REPORT_CALLBACK_CREATE_INFO_EXT, "VK_STRUCTURE_TYPE_DEBUG_REPORT_CALLBACK_CREATE_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_RASTERIZATION_ORDER_AMD, "VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_RASTERIZATION_ORDER_AMD" );
	swigIntConstant( VK_STRUCTURE_TYPE_DEBUG_MARKER_OBJECT_NAME_INFO_EXT, "VK_STRUCTURE_TYPE_DEBUG_MARKER_OBJECT_NAME_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_DEBUG_MARKER_OBJECT_TAG_INFO_EXT, "VK_STRUCTURE_TYPE_DEBUG_MARKER_OBJECT_TAG_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_DEBUG_MARKER_MARKER_INFO_EXT, "VK_STRUCTURE_TYPE_DEBUG_MARKER_MARKER_INFO_EXT" );
	swigIntConstant( VK_STRUCTURE_TYPE_BEGIN_RANGE, "VK_STRUCTURE_TYPE_BEGIN_RANGE" );
	swigIntConstant( VK_STRUCTURE_TYPE_END_RANGE, "VK_STRUCTURE_TYPE_END_RANGE" );
	swigIntConstant( VK_STRUCTURE_TYPE_RANGE_SIZE, "VK_STRUCTURE_TYPE_RANGE_SIZE" );
	swigIntConstant( VK_STRUCTURE_TYPE_MAX_ENUM, "VK_STRUCTURE_TYPE_MAX_ENUM" );
	swigIntConstant( VK_SYSTEM_ALLOCATION_SCOPE_COMMAND, "VK_SYSTEM_ALLOCATION_SCOPE_COMMAND" );
	swigIntConstant( VK_SYSTEM_ALLOCATION_SCOPE_OBJECT, "VK_SYSTEM_ALLOCATION_SCOPE_OBJECT" );
	swigIntConstant( VK_SYSTEM_ALLOCATION_SCOPE_CACHE, "VK_SYSTEM_ALLOCATION_SCOPE_CACHE" );
	swigIntConstant( VK_SYSTEM_ALLOCATION_SCOPE_DEVICE, "VK_SYSTEM_ALLOCATION_SCOPE_DEVICE" );
	swigIntConstant( VK_SYSTEM_ALLOCATION_SCOPE_INSTANCE, "VK_SYSTEM_ALLOCATION_SCOPE_INSTANCE" );
	swigIntConstant( VK_SYSTEM_ALLOCATION_SCOPE_BEGIN_RANGE, "VK_SYSTEM_ALLOCATION_SCOPE_BEGIN_RANGE" );
	swigIntConstant( VK_SYSTEM_ALLOCATION_SCOPE_END_RANGE, "VK_SYSTEM_ALLOCATION_SCOPE_END_RANGE" );
	swigIntConstant( VK_SYSTEM_ALLOCATION_SCOPE_RANGE_SIZE, "VK_SYSTEM_ALLOCATION_SCOPE_RANGE_SIZE" );
	swigIntConstant( VK_SYSTEM_ALLOCATION_SCOPE_MAX_ENUM, "VK_SYSTEM_ALLOCATION_SCOPE_MAX_ENUM" );
	swigIntConstant( VK_INTERNAL_ALLOCATION_TYPE_EXECUTABLE, "VK_INTERNAL_ALLOCATION_TYPE_EXECUTABLE" );
	swigIntConstant( VK_INTERNAL_ALLOCATION_TYPE_BEGIN_RANGE, "VK_INTERNAL_ALLOCATION_TYPE_BEGIN_RANGE" );
	swigIntConstant( VK_INTERNAL_ALLOCATION_TYPE_END_RANGE, "VK_INTERNAL_ALLOCATION_TYPE_END_RANGE" );
	swigIntConstant( VK_INTERNAL_ALLOCATION_TYPE_RANGE_SIZE, "VK_INTERNAL_ALLOCATION_TYPE_RANGE_SIZE" );
	swigIntConstant( VK_INTERNAL_ALLOCATION_TYPE_MAX_ENUM, "VK_INTERNAL_ALLOCATION_TYPE_MAX_ENUM" );
	swigIntConstant( VK_FORMAT_UNDEFINED, "VK_FORMAT_UNDEFINED" );
	swigIntConstant( VK_FORMAT_R4G4_UNORM_PACK8, "VK_FORMAT_R4G4_UNORM_PACK8" );
	swigIntConstant( VK_FORMAT_R4G4B4A4_UNORM_PACK16, "VK_FORMAT_R4G4B4A4_UNORM_PACK16" );
	swigIntConstant( VK_FORMAT_B4G4R4A4_UNORM_PACK16, "VK_FORMAT_B4G4R4A4_UNORM_PACK16" );
	swigIntConstant( VK_FORMAT_R5G6B5_UNORM_PACK16, "VK_FORMAT_R5G6B5_UNORM_PACK16" );
	swigIntConstant( VK_FORMAT_B5G6R5_UNORM_PACK16, "VK_FORMAT_B5G6R5_UNORM_PACK16" );
	swigIntConstant( VK_FORMAT_R5G5B5A1_UNORM_PACK16, "VK_FORMAT_R5G5B5A1_UNORM_PACK16" );
	swigIntConstant( VK_FORMAT_B5G5R5A1_UNORM_PACK16, "VK_FORMAT_B5G5R5A1_UNORM_PACK16" );
	swigIntConstant( VK_FORMAT_A1R5G5B5_UNORM_PACK16, "VK_FORMAT_A1R5G5B5_UNORM_PACK16" );
	swigIntConstant( VK_FORMAT_R8_UNORM, "VK_FORMAT_R8_UNORM" );
	swigIntConstant( VK_FORMAT_R8_SNORM, "VK_FORMAT_R8_SNORM" );
	swigIntConstant( VK_FORMAT_R8_USCALED, "VK_FORMAT_R8_USCALED" );
	swigIntConstant( VK_FORMAT_R8_SSCALED, "VK_FORMAT_R8_SSCALED" );
	swigIntConstant( VK_FORMAT_R8_UINT, "VK_FORMAT_R8_UINT" );
	swigIntConstant( VK_FORMAT_R8_SINT, "VK_FORMAT_R8_SINT" );
	swigIntConstant( VK_FORMAT_R8_SRGB, "VK_FORMAT_R8_SRGB" );
	swigIntConstant( VK_FORMAT_R8G8_UNORM, "VK_FORMAT_R8G8_UNORM" );
	swigIntConstant( VK_FORMAT_R8G8_SNORM, "VK_FORMAT_R8G8_SNORM" );
	swigIntConstant( VK_FORMAT_R8G8_USCALED, "VK_FORMAT_R8G8_USCALED" );
	swigIntConstant( VK_FORMAT_R8G8_SSCALED, "VK_FORMAT_R8G8_SSCALED" );
	swigIntConstant( VK_FORMAT_R8G8_UINT, "VK_FORMAT_R8G8_UINT" );
	swigIntConstant( VK_FORMAT_R8G8_SINT, "VK_FORMAT_R8G8_SINT" );
	swigIntConstant( VK_FORMAT_R8G8_SRGB, "VK_FORMAT_R8G8_SRGB" );
	swigIntConstant( VK_FORMAT_R8G8B8_UNORM, "VK_FORMAT_R8G8B8_UNORM" );
	swigIntConstant( VK_FORMAT_R8G8B8_SNORM, "VK_FORMAT_R8G8B8_SNORM" );
	swigIntConstant( VK_FORMAT_R8G8B8_USCALED, "VK_FORMAT_R8G8B8_USCALED" );
	swigIntConstant( VK_FORMAT_R8G8B8_SSCALED, "VK_FORMAT_R8G8B8_SSCALED" );
	swigIntConstant( VK_FORMAT_R8G8B8_UINT, "VK_FORMAT_R8G8B8_UINT" );
	swigIntConstant( VK_FORMAT_R8G8B8_SINT, "VK_FORMAT_R8G8B8_SINT" );
	swigIntConstant( VK_FORMAT_R8G8B8_SRGB, "VK_FORMAT_R8G8B8_SRGB" );
	swigIntConstant( VK_FORMAT_B8G8R8_UNORM, "VK_FORMAT_B8G8R8_UNORM" );
	swigIntConstant( VK_FORMAT_B8G8R8_SNORM, "VK_FORMAT_B8G8R8_SNORM" );
	swigIntConstant( VK_FORMAT_B8G8R8_USCALED, "VK_FORMAT_B8G8R8_USCALED" );
	swigIntConstant( VK_FORMAT_B8G8R8_SSCALED, "VK_FORMAT_B8G8R8_SSCALED" );
	swigIntConstant( VK_FORMAT_B8G8R8_UINT, "VK_FORMAT_B8G8R8_UINT" );
	swigIntConstant( VK_FORMAT_B8G8R8_SINT, "VK_FORMAT_B8G8R8_SINT" );
	swigIntConstant( VK_FORMAT_B8G8R8_SRGB, "VK_FORMAT_B8G8R8_SRGB" );
	swigIntConstant( VK_FORMAT_R8G8B8A8_UNORM, "VK_FORMAT_R8G8B8A8_UNORM" );
	swigIntConstant( VK_FORMAT_R8G8B8A8_SNORM, "VK_FORMAT_R8G8B8A8_SNORM" );
	swigIntConstant( VK_FORMAT_R8G8B8A8_USCALED, "VK_FORMAT_R8G8B8A8_USCALED" );
	swigIntConstant( VK_FORMAT_R8G8B8A8_SSCALED, "VK_FORMAT_R8G8B8A8_SSCALED" );
	swigIntConstant( VK_FORMAT_R8G8B8A8_UINT, "VK_FORMAT_R8G8B8A8_UINT" );
	swigIntConstant( VK_FORMAT_R8G8B8A8_SINT, "VK_FORMAT_R8G8B8A8_SINT" );
	swigIntConstant( VK_FORMAT_R8G8B8A8_SRGB, "VK_FORMAT_R8G8B8A8_SRGB" );
	swigIntConstant( VK_FORMAT_B8G8R8A8_UNORM, "VK_FORMAT_B8G8R8A8_UNORM" );
	swigIntConstant( VK_FORMAT_B8G8R8A8_SNORM, "VK_FORMAT_B8G8R8A8_SNORM" );
	swigIntConstant( VK_FORMAT_B8G8R8A8_USCALED, "VK_FORMAT_B8G8R8A8_USCALED" );
	swigIntConstant( VK_FORMAT_B8G8R8A8_SSCALED, "VK_FORMAT_B8G8R8A8_SSCALED" );
	swigIntConstant( VK_FORMAT_B8G8R8A8_UINT, "VK_FORMAT_B8G8R8A8_UINT" );
	swigIntConstant( VK_FORMAT_B8G8R8A8_SINT, "VK_FORMAT_B8G8R8A8_SINT" );
	swigIntConstant( VK_FORMAT_B8G8R8A8_SRGB, "VK_FORMAT_B8G8R8A8_SRGB" );
	swigIntConstant( VK_FORMAT_A8B8G8R8_UNORM_PACK32, "VK_FORMAT_A8B8G8R8_UNORM_PACK32" );
	swigIntConstant( VK_FORMAT_A8B8G8R8_SNORM_PACK32, "VK_FORMAT_A8B8G8R8_SNORM_PACK32" );
	swigIntConstant( VK_FORMAT_A8B8G8R8_USCALED_PACK32, "VK_FORMAT_A8B8G8R8_USCALED_PACK32" );
	swigIntConstant( VK_FORMAT_A8B8G8R8_SSCALED_PACK32, "VK_FORMAT_A8B8G8R8_SSCALED_PACK32" );
	swigIntConstant( VK_FORMAT_A8B8G8R8_UINT_PACK32, "VK_FORMAT_A8B8G8R8_UINT_PACK32" );
	swigIntConstant( VK_FORMAT_A8B8G8R8_SINT_PACK32, "VK_FORMAT_A8B8G8R8_SINT_PACK32" );
	swigIntConstant( VK_FORMAT_A8B8G8R8_SRGB_PACK32, "VK_FORMAT_A8B8G8R8_SRGB_PACK32" );
	swigIntConstant( VK_FORMAT_A2R10G10B10_UNORM_PACK32, "VK_FORMAT_A2R10G10B10_UNORM_PACK32" );
	swigIntConstant( VK_FORMAT_A2R10G10B10_SNORM_PACK32, "VK_FORMAT_A2R10G10B10_SNORM_PACK32" );
	swigIntConstant( VK_FORMAT_A2R10G10B10_USCALED_PACK32, "VK_FORMAT_A2R10G10B10_USCALED_PACK32" );
	swigIntConstant( VK_FORMAT_A2R10G10B10_SSCALED_PACK32, "VK_FORMAT_A2R10G10B10_SSCALED_PACK32" );
	swigIntConstant( VK_FORMAT_A2R10G10B10_UINT_PACK32, "VK_FORMAT_A2R10G10B10_UINT_PACK32" );
	swigIntConstant( VK_FORMAT_A2R10G10B10_SINT_PACK32, "VK_FORMAT_A2R10G10B10_SINT_PACK32" );
	swigIntConstant( VK_FORMAT_A2B10G10R10_UNORM_PACK32, "VK_FORMAT_A2B10G10R10_UNORM_PACK32" );
	swigIntConstant( VK_FORMAT_A2B10G10R10_SNORM_PACK32, "VK_FORMAT_A2B10G10R10_SNORM_PACK32" );
	swigIntConstant( VK_FORMAT_A2B10G10R10_USCALED_PACK32, "VK_FORMAT_A2B10G10R10_USCALED_PACK32" );
	swigIntConstant( VK_FORMAT_A2B10G10R10_SSCALED_PACK32, "VK_FORMAT_A2B10G10R10_SSCALED_PACK32" );
	swigIntConstant( VK_FORMAT_A2B10G10R10_UINT_PACK32, "VK_FORMAT_A2B10G10R10_UINT_PACK32" );
	swigIntConstant( VK_FORMAT_A2B10G10R10_SINT_PACK32, "VK_FORMAT_A2B10G10R10_SINT_PACK32" );
	swigIntConstant( VK_FORMAT_R16_UNORM, "VK_FORMAT_R16_UNORM" );
	swigIntConstant( VK_FORMAT_R16_SNORM, "VK_FORMAT_R16_SNORM" );
	swigIntConstant( VK_FORMAT_R16_USCALED, "VK_FORMAT_R16_USCALED" );
	swigIntConstant( VK_FORMAT_R16_SSCALED, "VK_FORMAT_R16_SSCALED" );
	swigIntConstant( VK_FORMAT_R16_UINT, "VK_FORMAT_R16_UINT" );
	swigIntConstant( VK_FORMAT_R16_SINT, "VK_FORMAT_R16_SINT" );
	swigIntConstant( VK_FORMAT_R16_SFLOAT, "VK_FORMAT_R16_SFLOAT" );
	swigIntConstant( VK_FORMAT_R16G16_UNORM, "VK_FORMAT_R16G16_UNORM" );
	swigIntConstant( VK_FORMAT_R16G16_SNORM, "VK_FORMAT_R16G16_SNORM" );
	swigIntConstant( VK_FORMAT_R16G16_USCALED, "VK_FORMAT_R16G16_USCALED" );
	swigIntConstant( VK_FORMAT_R16G16_SSCALED, "VK_FORMAT_R16G16_SSCALED" );
	swigIntConstant( VK_FORMAT_R16G16_UINT, "VK_FORMAT_R16G16_UINT" );
	swigIntConstant( VK_FORMAT_R16G16_SINT, "VK_FORMAT_R16G16_SINT" );
	swigIntConstant( VK_FORMAT_R16G16_SFLOAT, "VK_FORMAT_R16G16_SFLOAT" );
	swigIntConstant( VK_FORMAT_R16G16B16_UNORM, "VK_FORMAT_R16G16B16_UNORM" );
	swigIntConstant( VK_FORMAT_R16G16B16_SNORM, "VK_FORMAT_R16G16B16_SNORM" );
	swigIntConstant( VK_FORMAT_R16G16B16_USCALED, "VK_FORMAT_R16G16B16_USCALED" );
	swigIntConstant( VK_FORMAT_R16G16B16_SSCALED, "VK_FORMAT_R16G16B16_SSCALED" );
	swigIntConstant( VK_FORMAT_R16G16B16_UINT, "VK_FORMAT_R16G16B16_UINT" );
	swigIntConstant( VK_FORMAT_R16G16B16_SINT, "VK_FORMAT_R16G16B16_SINT" );
	swigIntConstant( VK_FORMAT_R16G16B16_SFLOAT, "VK_FORMAT_R16G16B16_SFLOAT" );
	swigIntConstant( VK_FORMAT_R16G16B16A16_UNORM, "VK_FORMAT_R16G16B16A16_UNORM" );
	swigIntConstant( VK_FORMAT_R16G16B16A16_SNORM, "VK_FORMAT_R16G16B16A16_SNORM" );
	swigIntConstant( VK_FORMAT_R16G16B16A16_USCALED, "VK_FORMAT_R16G16B16A16_USCALED" );
	swigIntConstant( VK_FORMAT_R16G16B16A16_SSCALED, "VK_FORMAT_R16G16B16A16_SSCALED" );
	swigIntConstant( VK_FORMAT_R16G16B16A16_UINT, "VK_FORMAT_R16G16B16A16_UINT" );
	swigIntConstant( VK_FORMAT_R16G16B16A16_SINT, "VK_FORMAT_R16G16B16A16_SINT" );
	swigIntConstant( VK_FORMAT_R16G16B16A16_SFLOAT, "VK_FORMAT_R16G16B16A16_SFLOAT" );
	swigIntConstant( VK_FORMAT_R32_UINT, "VK_FORMAT_R32_UINT" );
	swigIntConstant( VK_FORMAT_R32_SINT, "VK_FORMAT_R32_SINT" );
	swigIntConstant( VK_FORMAT_R32_SFLOAT, "VK_FORMAT_R32_SFLOAT" );
	swigIntConstant( VK_FORMAT_R32G32_UINT, "VK_FORMAT_R32G32_UINT" );
	swigIntConstant( VK_FORMAT_R32G32_SINT, "VK_FORMAT_R32G32_SINT" );
	swigIntConstant( VK_FORMAT_R32G32_SFLOAT, "VK_FORMAT_R32G32_SFLOAT" );
	swigIntConstant( VK_FORMAT_R32G32B32_UINT, "VK_FORMAT_R32G32B32_UINT" );
	swigIntConstant( VK_FORMAT_R32G32B32_SINT, "VK_FORMAT_R32G32B32_SINT" );
	swigIntConstant( VK_FORMAT_R32G32B32_SFLOAT, "VK_FORMAT_R32G32B32_SFLOAT" );
	swigIntConstant( VK_FORMAT_R32G32B32A32_UINT, "VK_FORMAT_R32G32B32A32_UINT" );
	swigIntConstant( VK_FORMAT_R32G32B32A32_SINT, "VK_FORMAT_R32G32B32A32_SINT" );
	swigIntConstant( VK_FORMAT_R32G32B32A32_SFLOAT, "VK_FORMAT_R32G32B32A32_SFLOAT" );
	swigIntConstant( VK_FORMAT_R64_UINT, "VK_FORMAT_R64_UINT" );
	swigIntConstant( VK_FORMAT_R64_SINT, "VK_FORMAT_R64_SINT" );
	swigIntConstant( VK_FORMAT_R64_SFLOAT, "VK_FORMAT_R64_SFLOAT" );
	swigIntConstant( VK_FORMAT_R64G64_UINT, "VK_FORMAT_R64G64_UINT" );
	swigIntConstant( VK_FORMAT_R64G64_SINT, "VK_FORMAT_R64G64_SINT" );
	swigIntConstant( VK_FORMAT_R64G64_SFLOAT, "VK_FORMAT_R64G64_SFLOAT" );
	swigIntConstant( VK_FORMAT_R64G64B64_UINT, "VK_FORMAT_R64G64B64_UINT" );
	swigIntConstant( VK_FORMAT_R64G64B64_SINT, "VK_FORMAT_R64G64B64_SINT" );
	swigIntConstant( VK_FORMAT_R64G64B64_SFLOAT, "VK_FORMAT_R64G64B64_SFLOAT" );
	swigIntConstant( VK_FORMAT_R64G64B64A64_UINT, "VK_FORMAT_R64G64B64A64_UINT" );
	swigIntConstant( VK_FORMAT_R64G64B64A64_SINT, "VK_FORMAT_R64G64B64A64_SINT" );
	swigIntConstant( VK_FORMAT_R64G64B64A64_SFLOAT, "VK_FORMAT_R64G64B64A64_SFLOAT" );
	swigIntConstant( VK_FORMAT_B10G11R11_UFLOAT_PACK32, "VK_FORMAT_B10G11R11_UFLOAT_PACK32" );
	swigIntConstant( VK_FORMAT_E5B9G9R9_UFLOAT_PACK32, "VK_FORMAT_E5B9G9R9_UFLOAT_PACK32" );
	swigIntConstant( VK_FORMAT_D16_UNORM, "VK_FORMAT_D16_UNORM" );
	swigIntConstant( VK_FORMAT_X8_D24_UNORM_PACK32, "VK_FORMAT_X8_D24_UNORM_PACK32" );
	swigIntConstant( VK_FORMAT_D32_SFLOAT, "VK_FORMAT_D32_SFLOAT" );
	swigIntConstant( VK_FORMAT_S8_UINT, "VK_FORMAT_S8_UINT" );
	swigIntConstant( VK_FORMAT_D16_UNORM_S8_UINT, "VK_FORMAT_D16_UNORM_S8_UINT" );
	swigIntConstant( VK_FORMAT_D24_UNORM_S8_UINT, "VK_FORMAT_D24_UNORM_S8_UINT" );
	swigIntConstant( VK_FORMAT_D32_SFLOAT_S8_UINT, "VK_FORMAT_D32_SFLOAT_S8_UINT" );
	swigIntConstant( VK_FORMAT_BC1_RGB_UNORM_BLOCK, "VK_FORMAT_BC1_RGB_UNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_BC1_RGB_SRGB_BLOCK, "VK_FORMAT_BC1_RGB_SRGB_BLOCK" );
	swigIntConstant( VK_FORMAT_BC1_RGBA_UNORM_BLOCK, "VK_FORMAT_BC1_RGBA_UNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_BC1_RGBA_SRGB_BLOCK, "VK_FORMAT_BC1_RGBA_SRGB_BLOCK" );
	swigIntConstant( VK_FORMAT_BC2_UNORM_BLOCK, "VK_FORMAT_BC2_UNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_BC2_SRGB_BLOCK, "VK_FORMAT_BC2_SRGB_BLOCK" );
	swigIntConstant( VK_FORMAT_BC3_UNORM_BLOCK, "VK_FORMAT_BC3_UNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_BC3_SRGB_BLOCK, "VK_FORMAT_BC3_SRGB_BLOCK" );
	swigIntConstant( VK_FORMAT_BC4_UNORM_BLOCK, "VK_FORMAT_BC4_UNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_BC4_SNORM_BLOCK, "VK_FORMAT_BC4_SNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_BC5_UNORM_BLOCK, "VK_FORMAT_BC5_UNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_BC5_SNORM_BLOCK, "VK_FORMAT_BC5_SNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_BC6H_UFLOAT_BLOCK, "VK_FORMAT_BC6H_UFLOAT_BLOCK" );
	swigIntConstant( VK_FORMAT_BC6H_SFLOAT_BLOCK, "VK_FORMAT_BC6H_SFLOAT_BLOCK" );
	swigIntConstant( VK_FORMAT_BC7_UNORM_BLOCK, "VK_FORMAT_BC7_UNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_BC7_SRGB_BLOCK, "VK_FORMAT_BC7_SRGB_BLOCK" );
	swigIntConstant( VK_FORMAT_ETC2_R8G8B8_UNORM_BLOCK, "VK_FORMAT_ETC2_R8G8B8_UNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_ETC2_R8G8B8_SRGB_BLOCK, "VK_FORMAT_ETC2_R8G8B8_SRGB_BLOCK" );
	swigIntConstant( VK_FORMAT_ETC2_R8G8B8A1_UNORM_BLOCK, "VK_FORMAT_ETC2_R8G8B8A1_UNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_ETC2_R8G8B8A1_SRGB_BLOCK, "VK_FORMAT_ETC2_R8G8B8A1_SRGB_BLOCK" );
	swigIntConstant( VK_FORMAT_ETC2_R8G8B8A8_UNORM_BLOCK, "VK_FORMAT_ETC2_R8G8B8A8_UNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_ETC2_R8G8B8A8_SRGB_BLOCK, "VK_FORMAT_ETC2_R8G8B8A8_SRGB_BLOCK" );
	swigIntConstant( VK_FORMAT_EAC_R11_UNORM_BLOCK, "VK_FORMAT_EAC_R11_UNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_EAC_R11_SNORM_BLOCK, "VK_FORMAT_EAC_R11_SNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_EAC_R11G11_UNORM_BLOCK, "VK_FORMAT_EAC_R11G11_UNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_EAC_R11G11_SNORM_BLOCK, "VK_FORMAT_EAC_R11G11_SNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_ASTC_4x4_UNORM_BLOCK, "VK_FORMAT_ASTC_4x4_UNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_ASTC_4x4_SRGB_BLOCK, "VK_FORMAT_ASTC_4x4_SRGB_BLOCK" );
	swigIntConstant( VK_FORMAT_ASTC_5x4_UNORM_BLOCK, "VK_FORMAT_ASTC_5x4_UNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_ASTC_5x4_SRGB_BLOCK, "VK_FORMAT_ASTC_5x4_SRGB_BLOCK" );
	swigIntConstant( VK_FORMAT_ASTC_5x5_UNORM_BLOCK, "VK_FORMAT_ASTC_5x5_UNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_ASTC_5x5_SRGB_BLOCK, "VK_FORMAT_ASTC_5x5_SRGB_BLOCK" );
	swigIntConstant( VK_FORMAT_ASTC_6x5_UNORM_BLOCK, "VK_FORMAT_ASTC_6x5_UNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_ASTC_6x5_SRGB_BLOCK, "VK_FORMAT_ASTC_6x5_SRGB_BLOCK" );
	swigIntConstant( VK_FORMAT_ASTC_6x6_UNORM_BLOCK, "VK_FORMAT_ASTC_6x6_UNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_ASTC_6x6_SRGB_BLOCK, "VK_FORMAT_ASTC_6x6_SRGB_BLOCK" );
	swigIntConstant( VK_FORMAT_ASTC_8x5_UNORM_BLOCK, "VK_FORMAT_ASTC_8x5_UNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_ASTC_8x5_SRGB_BLOCK, "VK_FORMAT_ASTC_8x5_SRGB_BLOCK" );
	swigIntConstant( VK_FORMAT_ASTC_8x6_UNORM_BLOCK, "VK_FORMAT_ASTC_8x6_UNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_ASTC_8x6_SRGB_BLOCK, "VK_FORMAT_ASTC_8x6_SRGB_BLOCK" );
	swigIntConstant( VK_FORMAT_ASTC_8x8_UNORM_BLOCK, "VK_FORMAT_ASTC_8x8_UNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_ASTC_8x8_SRGB_BLOCK, "VK_FORMAT_ASTC_8x8_SRGB_BLOCK" );
	swigIntConstant( VK_FORMAT_ASTC_10x5_UNORM_BLOCK, "VK_FORMAT_ASTC_10x5_UNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_ASTC_10x5_SRGB_BLOCK, "VK_FORMAT_ASTC_10x5_SRGB_BLOCK" );
	swigIntConstant( VK_FORMAT_ASTC_10x6_UNORM_BLOCK, "VK_FORMAT_ASTC_10x6_UNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_ASTC_10x6_SRGB_BLOCK, "VK_FORMAT_ASTC_10x6_SRGB_BLOCK" );
	swigIntConstant( VK_FORMAT_ASTC_10x8_UNORM_BLOCK, "VK_FORMAT_ASTC_10x8_UNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_ASTC_10x8_SRGB_BLOCK, "VK_FORMAT_ASTC_10x8_SRGB_BLOCK" );
	swigIntConstant( VK_FORMAT_ASTC_10x10_UNORM_BLOCK, "VK_FORMAT_ASTC_10x10_UNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_ASTC_10x10_SRGB_BLOCK, "VK_FORMAT_ASTC_10x10_SRGB_BLOCK" );
	swigIntConstant( VK_FORMAT_ASTC_12x10_UNORM_BLOCK, "VK_FORMAT_ASTC_12x10_UNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_ASTC_12x10_SRGB_BLOCK, "VK_FORMAT_ASTC_12x10_SRGB_BLOCK" );
	swigIntConstant( VK_FORMAT_ASTC_12x12_UNORM_BLOCK, "VK_FORMAT_ASTC_12x12_UNORM_BLOCK" );
	swigIntConstant( VK_FORMAT_ASTC_12x12_SRGB_BLOCK, "VK_FORMAT_ASTC_12x12_SRGB_BLOCK" );
	swigIntConstant( VK_FORMAT_BEGIN_RANGE, "VK_FORMAT_BEGIN_RANGE" );
	swigIntConstant( VK_FORMAT_END_RANGE, "VK_FORMAT_END_RANGE" );
	swigIntConstant( VK_FORMAT_RANGE_SIZE, "VK_FORMAT_RANGE_SIZE" );
	swigIntConstant( VK_FORMAT_MAX_ENUM, "VK_FORMAT_MAX_ENUM" );
	swigIntConstant( VK_IMAGE_TYPE_1D, "VK_IMAGE_TYPE_1D" );
	swigIntConstant( VK_IMAGE_TYPE_2D, "VK_IMAGE_TYPE_2D" );
	swigIntConstant( VK_IMAGE_TYPE_3D, "VK_IMAGE_TYPE_3D" );
	swigIntConstant( VK_IMAGE_TYPE_BEGIN_RANGE, "VK_IMAGE_TYPE_BEGIN_RANGE" );
	swigIntConstant( VK_IMAGE_TYPE_END_RANGE, "VK_IMAGE_TYPE_END_RANGE" );
	swigIntConstant( VK_IMAGE_TYPE_RANGE_SIZE, "VK_IMAGE_TYPE_RANGE_SIZE" );
	swigIntConstant( VK_IMAGE_TYPE_MAX_ENUM, "VK_IMAGE_TYPE_MAX_ENUM" );
	swigIntConstant( VK_IMAGE_TILING_OPTIMAL, "VK_IMAGE_TILING_OPTIMAL" );
	swigIntConstant( VK_IMAGE_TILING_LINEAR, "VK_IMAGE_TILING_LINEAR" );
	swigIntConstant( VK_IMAGE_TILING_BEGIN_RANGE, "VK_IMAGE_TILING_BEGIN_RANGE" );
	swigIntConstant( VK_IMAGE_TILING_END_RANGE, "VK_IMAGE_TILING_END_RANGE" );
	swigIntConstant( VK_IMAGE_TILING_RANGE_SIZE, "VK_IMAGE_TILING_RANGE_SIZE" );
	swigIntConstant( VK_IMAGE_TILING_MAX_ENUM, "VK_IMAGE_TILING_MAX_ENUM" );
	swigIntConstant( VK_PHYSICAL_DEVICE_TYPE_OTHER, "VK_PHYSICAL_DEVICE_TYPE_OTHER" );
	swigIntConstant( VK_PHYSICAL_DEVICE_TYPE_INTEGRATED_GPU, "VK_PHYSICAL_DEVICE_TYPE_INTEGRATED_GPU" );
	swigIntConstant( VK_PHYSICAL_DEVICE_TYPE_DISCRETE_GPU, "VK_PHYSICAL_DEVICE_TYPE_DISCRETE_GPU" );
	swigIntConstant( VK_PHYSICAL_DEVICE_TYPE_VIRTUAL_GPU, "VK_PHYSICAL_DEVICE_TYPE_VIRTUAL_GPU" );
	swigIntConstant( VK_PHYSICAL_DEVICE_TYPE_CPU, "VK_PHYSICAL_DEVICE_TYPE_CPU" );
	swigIntConstant( VK_PHYSICAL_DEVICE_TYPE_BEGIN_RANGE, "VK_PHYSICAL_DEVICE_TYPE_BEGIN_RANGE" );
	swigIntConstant( VK_PHYSICAL_DEVICE_TYPE_END_RANGE, "VK_PHYSICAL_DEVICE_TYPE_END_RANGE" );
	swigIntConstant( VK_PHYSICAL_DEVICE_TYPE_RANGE_SIZE, "VK_PHYSICAL_DEVICE_TYPE_RANGE_SIZE" );
	swigIntConstant( VK_PHYSICAL_DEVICE_TYPE_MAX_ENUM, "VK_PHYSICAL_DEVICE_TYPE_MAX_ENUM" );
	swigIntConstant( VK_QUERY_TYPE_OCCLUSION, "VK_QUERY_TYPE_OCCLUSION" );
	swigIntConstant( VK_QUERY_TYPE_PIPELINE_STATISTICS, "VK_QUERY_TYPE_PIPELINE_STATISTICS" );
	swigIntConstant( VK_QUERY_TYPE_TIMESTAMP, "VK_QUERY_TYPE_TIMESTAMP" );
	swigIntConstant( VK_QUERY_TYPE_BEGIN_RANGE, "VK_QUERY_TYPE_BEGIN_RANGE" );
	swigIntConstant( VK_QUERY_TYPE_END_RANGE, "VK_QUERY_TYPE_END_RANGE" );
	swigIntConstant( VK_QUERY_TYPE_RANGE_SIZE, "VK_QUERY_TYPE_RANGE_SIZE" );
	swigIntConstant( VK_QUERY_TYPE_MAX_ENUM, "VK_QUERY_TYPE_MAX_ENUM" );
	swigIntConstant( VK_SHARING_MODE_EXCLUSIVE, "VK_SHARING_MODE_EXCLUSIVE" );
	swigIntConstant( VK_SHARING_MODE_CONCURRENT, "VK_SHARING_MODE_CONCURRENT" );
	swigIntConstant( VK_SHARING_MODE_BEGIN_RANGE, "VK_SHARING_MODE_BEGIN_RANGE" );
	swigIntConstant( VK_SHARING_MODE_END_RANGE, "VK_SHARING_MODE_END_RANGE" );
	swigIntConstant( VK_SHARING_MODE_RANGE_SIZE, "VK_SHARING_MODE_RANGE_SIZE" );
	swigIntConstant( VK_SHARING_MODE_MAX_ENUM, "VK_SHARING_MODE_MAX_ENUM" );
	swigIntConstant( VK_IMAGE_LAYOUT_UNDEFINED, "VK_IMAGE_LAYOUT_UNDEFINED" );
	swigIntConstant( VK_IMAGE_LAYOUT_GENERAL, "VK_IMAGE_LAYOUT_GENERAL" );
	swigIntConstant( VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL, "VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL" );
	swigIntConstant( VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL, "VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL" );
	swigIntConstant( VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL, "VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL" );
	swigIntConstant( VK_IMAGE_LAYOUT_SHADER_READ_ONLY_OPTIMAL, "VK_IMAGE_LAYOUT_SHADER_READ_ONLY_OPTIMAL" );
	swigIntConstant( VK_IMAGE_LAYOUT_TRANSFER_SRC_OPTIMAL, "VK_IMAGE_LAYOUT_TRANSFER_SRC_OPTIMAL" );
	swigIntConstant( VK_IMAGE_LAYOUT_TRANSFER_DST_OPTIMAL, "VK_IMAGE_LAYOUT_TRANSFER_DST_OPTIMAL" );
	swigIntConstant( VK_IMAGE_LAYOUT_PREINITIALIZED, "VK_IMAGE_LAYOUT_PREINITIALIZED" );
	swigIntConstant( VK_IMAGE_LAYOUT_PRESENT_SRC_KHR, "VK_IMAGE_LAYOUT_PRESENT_SRC_KHR" );
	swigIntConstant( VK_IMAGE_LAYOUT_BEGIN_RANGE, "VK_IMAGE_LAYOUT_BEGIN_RANGE" );
	swigIntConstant( VK_IMAGE_LAYOUT_END_RANGE, "VK_IMAGE_LAYOUT_END_RANGE" );
	swigIntConstant( VK_IMAGE_LAYOUT_RANGE_SIZE, "VK_IMAGE_LAYOUT_RANGE_SIZE" );
	swigIntConstant( VK_IMAGE_LAYOUT_MAX_ENUM, "VK_IMAGE_LAYOUT_MAX_ENUM" );
	swigIntConstant( VK_IMAGE_VIEW_TYPE_1D, "VK_IMAGE_VIEW_TYPE_1D" );
	swigIntConstant( VK_IMAGE_VIEW_TYPE_2D, "VK_IMAGE_VIEW_TYPE_2D" );
	swigIntConstant( VK_IMAGE_VIEW_TYPE_3D, "VK_IMAGE_VIEW_TYPE_3D" );
	swigIntConstant( VK_IMAGE_VIEW_TYPE_CUBE, "VK_IMAGE_VIEW_TYPE_CUBE" );
	swigIntConstant( VK_IMAGE_VIEW_TYPE_1D_ARRAY, "VK_IMAGE_VIEW_TYPE_1D_ARRAY" );
	swigIntConstant( VK_IMAGE_VIEW_TYPE_2D_ARRAY, "VK_IMAGE_VIEW_TYPE_2D_ARRAY" );
	swigIntConstant( VK_IMAGE_VIEW_TYPE_CUBE_ARRAY, "VK_IMAGE_VIEW_TYPE_CUBE_ARRAY" );
	swigIntConstant( VK_IMAGE_VIEW_TYPE_BEGIN_RANGE, "VK_IMAGE_VIEW_TYPE_BEGIN_RANGE" );
	swigIntConstant( VK_IMAGE_VIEW_TYPE_END_RANGE, "VK_IMAGE_VIEW_TYPE_END_RANGE" );
	swigIntConstant( VK_IMAGE_VIEW_TYPE_RANGE_SIZE, "VK_IMAGE_VIEW_TYPE_RANGE_SIZE" );
	swigIntConstant( VK_IMAGE_VIEW_TYPE_MAX_ENUM, "VK_IMAGE_VIEW_TYPE_MAX_ENUM" );
	swigIntConstant( VK_COMPONENT_SWIZZLE_IDENTITY, "VK_COMPONENT_SWIZZLE_IDENTITY" );
	swigIntConstant( VK_COMPONENT_SWIZZLE_ZERO, "VK_COMPONENT_SWIZZLE_ZERO" );
	swigIntConstant( VK_COMPONENT_SWIZZLE_ONE, "VK_COMPONENT_SWIZZLE_ONE" );
	swigIntConstant( VK_COMPONENT_SWIZZLE_R, "VK_COMPONENT_SWIZZLE_R" );
	swigIntConstant( VK_COMPONENT_SWIZZLE_G, "VK_COMPONENT_SWIZZLE_G" );
	swigIntConstant( VK_COMPONENT_SWIZZLE_B, "VK_COMPONENT_SWIZZLE_B" );
	swigIntConstant( VK_COMPONENT_SWIZZLE_A, "VK_COMPONENT_SWIZZLE_A" );
	swigIntConstant( VK_COMPONENT_SWIZZLE_BEGIN_RANGE, "VK_COMPONENT_SWIZZLE_BEGIN_RANGE" );
	swigIntConstant( VK_COMPONENT_SWIZZLE_END_RANGE, "VK_COMPONENT_SWIZZLE_END_RANGE" );
	swigIntConstant( VK_COMPONENT_SWIZZLE_RANGE_SIZE, "VK_COMPONENT_SWIZZLE_RANGE_SIZE" );
	swigIntConstant( VK_COMPONENT_SWIZZLE_MAX_ENUM, "VK_COMPONENT_SWIZZLE_MAX_ENUM" );
	swigIntConstant( VK_VERTEX_INPUT_RATE_VERTEX, "VK_VERTEX_INPUT_RATE_VERTEX" );
	swigIntConstant( VK_VERTEX_INPUT_RATE_INSTANCE, "VK_VERTEX_INPUT_RATE_INSTANCE" );
	swigIntConstant( VK_VERTEX_INPUT_RATE_BEGIN_RANGE, "VK_VERTEX_INPUT_RATE_BEGIN_RANGE" );
	swigIntConstant( VK_VERTEX_INPUT_RATE_END_RANGE, "VK_VERTEX_INPUT_RATE_END_RANGE" );
	swigIntConstant( VK_VERTEX_INPUT_RATE_RANGE_SIZE, "VK_VERTEX_INPUT_RATE_RANGE_SIZE" );
	swigIntConstant( VK_VERTEX_INPUT_RATE_MAX_ENUM, "VK_VERTEX_INPUT_RATE_MAX_ENUM" );
	swigIntConstant( VK_PRIMITIVE_TOPOLOGY_POINT_LIST, "VK_PRIMITIVE_TOPOLOGY_POINT_LIST" );
	swigIntConstant( VK_PRIMITIVE_TOPOLOGY_LINE_LIST, "VK_PRIMITIVE_TOPOLOGY_LINE_LIST" );
	swigIntConstant( VK_PRIMITIVE_TOPOLOGY_LINE_STRIP, "VK_PRIMITIVE_TOPOLOGY_LINE_STRIP" );
	swigIntConstant( VK_PRIMITIVE_TOPOLOGY_TRIANGLE_LIST, "VK_PRIMITIVE_TOPOLOGY_TRIANGLE_LIST" );
	swigIntConstant( VK_PRIMITIVE_TOPOLOGY_TRIANGLE_STRIP, "VK_PRIMITIVE_TOPOLOGY_TRIANGLE_STRIP" );
	swigIntConstant( VK_PRIMITIVE_TOPOLOGY_TRIANGLE_FAN, "VK_PRIMITIVE_TOPOLOGY_TRIANGLE_FAN" );
	swigIntConstant( VK_PRIMITIVE_TOPOLOGY_LINE_LIST_WITH_ADJACENCY, "VK_PRIMITIVE_TOPOLOGY_LINE_LIST_WITH_ADJACENCY" );
	swigIntConstant( VK_PRIMITIVE_TOPOLOGY_LINE_STRIP_WITH_ADJACENCY, "VK_PRIMITIVE_TOPOLOGY_LINE_STRIP_WITH_ADJACENCY" );
	swigIntConstant( VK_PRIMITIVE_TOPOLOGY_TRIANGLE_LIST_WITH_ADJACENCY, "VK_PRIMITIVE_TOPOLOGY_TRIANGLE_LIST_WITH_ADJACENCY" );
	swigIntConstant( VK_PRIMITIVE_TOPOLOGY_TRIANGLE_STRIP_WITH_ADJACENCY, "VK_PRIMITIVE_TOPOLOGY_TRIANGLE_STRIP_WITH_ADJACENCY" );
	swigIntConstant( VK_PRIMITIVE_TOPOLOGY_PATCH_LIST, "VK_PRIMITIVE_TOPOLOGY_PATCH_LIST" );
	swigIntConstant( VK_PRIMITIVE_TOPOLOGY_BEGIN_RANGE, "VK_PRIMITIVE_TOPOLOGY_BEGIN_RANGE" );
	swigIntConstant( VK_PRIMITIVE_TOPOLOGY_END_RANGE, "VK_PRIMITIVE_TOPOLOGY_END_RANGE" );
	swigIntConstant( VK_PRIMITIVE_TOPOLOGY_RANGE_SIZE, "VK_PRIMITIVE_TOPOLOGY_RANGE_SIZE" );
	swigIntConstant( VK_PRIMITIVE_TOPOLOGY_MAX_ENUM, "VK_PRIMITIVE_TOPOLOGY_MAX_ENUM" );
	swigIntConstant( VK_POLYGON_MODE_FILL, "VK_POLYGON_MODE_FILL" );
	swigIntConstant( VK_POLYGON_MODE_LINE, "VK_POLYGON_MODE_LINE" );
	swigIntConstant( VK_POLYGON_MODE_POINT, "VK_POLYGON_MODE_POINT" );
	swigIntConstant( VK_POLYGON_MODE_BEGIN_RANGE, "VK_POLYGON_MODE_BEGIN_RANGE" );
	swigIntConstant( VK_POLYGON_MODE_END_RANGE, "VK_POLYGON_MODE_END_RANGE" );
	swigIntConstant( VK_POLYGON_MODE_RANGE_SIZE, "VK_POLYGON_MODE_RANGE_SIZE" );
	swigIntConstant( VK_POLYGON_MODE_MAX_ENUM, "VK_POLYGON_MODE_MAX_ENUM" );
	swigIntConstant( VK_FRONT_FACE_COUNTER_CLOCKWISE, "VK_FRONT_FACE_COUNTER_CLOCKWISE" );
	swigIntConstant( VK_FRONT_FACE_CLOCKWISE, "VK_FRONT_FACE_CLOCKWISE" );
	swigIntConstant( VK_FRONT_FACE_BEGIN_RANGE, "VK_FRONT_FACE_BEGIN_RANGE" );
	swigIntConstant( VK_FRONT_FACE_END_RANGE, "VK_FRONT_FACE_END_RANGE" );
	swigIntConstant( VK_FRONT_FACE_RANGE_SIZE, "VK_FRONT_FACE_RANGE_SIZE" );
	swigIntConstant( VK_FRONT_FACE_MAX_ENUM, "VK_FRONT_FACE_MAX_ENUM" );
	swigIntConstant( VK_COMPARE_OP_NEVER, "VK_COMPARE_OP_NEVER" );
	swigIntConstant( VK_COMPARE_OP_LESS, "VK_COMPARE_OP_LESS" );
	swigIntConstant( VK_COMPARE_OP_EQUAL, "VK_COMPARE_OP_EQUAL" );
	swigIntConstant( VK_COMPARE_OP_LESS_OR_EQUAL, "VK_COMPARE_OP_LESS_OR_EQUAL" );
	swigIntConstant( VK_COMPARE_OP_GREATER, "VK_COMPARE_OP_GREATER" );
	swigIntConstant( VK_COMPARE_OP_NOT_EQUAL, "VK_COMPARE_OP_NOT_EQUAL" );
	swigIntConstant( VK_COMPARE_OP_GREATER_OR_EQUAL, "VK_COMPARE_OP_GREATER_OR_EQUAL" );
	swigIntConstant( VK_COMPARE_OP_ALWAYS, "VK_COMPARE_OP_ALWAYS" );
	swigIntConstant( VK_COMPARE_OP_BEGIN_RANGE, "VK_COMPARE_OP_BEGIN_RANGE" );
	swigIntConstant( VK_COMPARE_OP_END_RANGE, "VK_COMPARE_OP_END_RANGE" );
	swigIntConstant( VK_COMPARE_OP_RANGE_SIZE, "VK_COMPARE_OP_RANGE_SIZE" );
	swigIntConstant( VK_COMPARE_OP_MAX_ENUM, "VK_COMPARE_OP_MAX_ENUM" );
	swigIntConstant( VK_STENCIL_OP_KEEP, "VK_STENCIL_OP_KEEP" );
	swigIntConstant( VK_STENCIL_OP_ZERO, "VK_STENCIL_OP_ZERO" );
	swigIntConstant( VK_STENCIL_OP_REPLACE, "VK_STENCIL_OP_REPLACE" );
	swigIntConstant( VK_STENCIL_OP_INCREMENT_AND_CLAMP, "VK_STENCIL_OP_INCREMENT_AND_CLAMP" );
	swigIntConstant( VK_STENCIL_OP_DECREMENT_AND_CLAMP, "VK_STENCIL_OP_DECREMENT_AND_CLAMP" );
	swigIntConstant( VK_STENCIL_OP_INVERT, "VK_STENCIL_OP_INVERT" );
	swigIntConstant( VK_STENCIL_OP_INCREMENT_AND_WRAP, "VK_STENCIL_OP_INCREMENT_AND_WRAP" );
	swigIntConstant( VK_STENCIL_OP_DECREMENT_AND_WRAP, "VK_STENCIL_OP_DECREMENT_AND_WRAP" );
	swigIntConstant( VK_STENCIL_OP_BEGIN_RANGE, "VK_STENCIL_OP_BEGIN_RANGE" );
	swigIntConstant( VK_STENCIL_OP_END_RANGE, "VK_STENCIL_OP_END_RANGE" );
	swigIntConstant( VK_STENCIL_OP_RANGE_SIZE, "VK_STENCIL_OP_RANGE_SIZE" );
	swigIntConstant( VK_STENCIL_OP_MAX_ENUM, "VK_STENCIL_OP_MAX_ENUM" );
	swigIntConstant( VK_LOGIC_OP_CLEAR, "VK_LOGIC_OP_CLEAR" );
	swigIntConstant( VK_LOGIC_OP_AND, "VK_LOGIC_OP_AND" );
	swigIntConstant( VK_LOGIC_OP_AND_REVERSE, "VK_LOGIC_OP_AND_REVERSE" );
	swigIntConstant( VK_LOGIC_OP_COPY, "VK_LOGIC_OP_COPY" );
	swigIntConstant( VK_LOGIC_OP_AND_INVERTED, "VK_LOGIC_OP_AND_INVERTED" );
	swigIntConstant( VK_LOGIC_OP_NO_OP, "VK_LOGIC_OP_NO_OP" );
	swigIntConstant( VK_LOGIC_OP_XOR, "VK_LOGIC_OP_XOR" );
	swigIntConstant( VK_LOGIC_OP_OR, "VK_LOGIC_OP_OR" );
	swigIntConstant( VK_LOGIC_OP_NOR, "VK_LOGIC_OP_NOR" );
	swigIntConstant( VK_LOGIC_OP_EQUIVALENT, "VK_LOGIC_OP_EQUIVALENT" );
	swigIntConstant( VK_LOGIC_OP_INVERT, "VK_LOGIC_OP_INVERT" );
	swigIntConstant( VK_LOGIC_OP_OR_REVERSE, "VK_LOGIC_OP_OR_REVERSE" );
	swigIntConstant( VK_LOGIC_OP_COPY_INVERTED, "VK_LOGIC_OP_COPY_INVERTED" );
	swigIntConstant( VK_LOGIC_OP_OR_INVERTED, "VK_LOGIC_OP_OR_INVERTED" );
	swigIntConstant( VK_LOGIC_OP_NAND, "VK_LOGIC_OP_NAND" );
	swigIntConstant( VK_LOGIC_OP_SET, "VK_LOGIC_OP_SET" );
	swigIntConstant( VK_LOGIC_OP_BEGIN_RANGE, "VK_LOGIC_OP_BEGIN_RANGE" );
	swigIntConstant( VK_LOGIC_OP_END_RANGE, "VK_LOGIC_OP_END_RANGE" );
	swigIntConstant( VK_LOGIC_OP_RANGE_SIZE, "VK_LOGIC_OP_RANGE_SIZE" );
	swigIntConstant( VK_LOGIC_OP_MAX_ENUM, "VK_LOGIC_OP_MAX_ENUM" );
	swigIntConstant( VK_BLEND_FACTOR_ZERO, "VK_BLEND_FACTOR_ZERO" );
	swigIntConstant( VK_BLEND_FACTOR_ONE, "VK_BLEND_FACTOR_ONE" );
	swigIntConstant( VK_BLEND_FACTOR_SRC_COLOR, "VK_BLEND_FACTOR_SRC_COLOR" );
	swigIntConstant( VK_BLEND_FACTOR_ONE_MINUS_SRC_COLOR, "VK_BLEND_FACTOR_ONE_MINUS_SRC_COLOR" );
	swigIntConstant( VK_BLEND_FACTOR_DST_COLOR, "VK_BLEND_FACTOR_DST_COLOR" );
	swigIntConstant( VK_BLEND_FACTOR_ONE_MINUS_DST_COLOR, "VK_BLEND_FACTOR_ONE_MINUS_DST_COLOR" );
	swigIntConstant( VK_BLEND_FACTOR_SRC_ALPHA, "VK_BLEND_FACTOR_SRC_ALPHA" );
	swigIntConstant( VK_BLEND_FACTOR_ONE_MINUS_SRC_ALPHA, "VK_BLEND_FACTOR_ONE_MINUS_SRC_ALPHA" );
	swigIntConstant( VK_BLEND_FACTOR_DST_ALPHA, "VK_BLEND_FACTOR_DST_ALPHA" );
	swigIntConstant( VK_BLEND_FACTOR_ONE_MINUS_DST_ALPHA, "VK_BLEND_FACTOR_ONE_MINUS_DST_ALPHA" );
	swigIntConstant( VK_BLEND_FACTOR_CONSTANT_COLOR, "VK_BLEND_FACTOR_CONSTANT_COLOR" );
	swigIntConstant( VK_BLEND_FACTOR_ONE_MINUS_CONSTANT_COLOR, "VK_BLEND_FACTOR_ONE_MINUS_CONSTANT_COLOR" );
	swigIntConstant( VK_BLEND_FACTOR_CONSTANT_ALPHA, "VK_BLEND_FACTOR_CONSTANT_ALPHA" );
	swigIntConstant( VK_BLEND_FACTOR_ONE_MINUS_CONSTANT_ALPHA, "VK_BLEND_FACTOR_ONE_MINUS_CONSTANT_ALPHA" );
	swigIntConstant( VK_BLEND_FACTOR_SRC_ALPHA_SATURATE, "VK_BLEND_FACTOR_SRC_ALPHA_SATURATE" );
	swigIntConstant( VK_BLEND_FACTOR_SRC1_COLOR, "VK_BLEND_FACTOR_SRC1_COLOR" );
	swigIntConstant( VK_BLEND_FACTOR_ONE_MINUS_SRC1_COLOR, "VK_BLEND_FACTOR_ONE_MINUS_SRC1_COLOR" );
	swigIntConstant( VK_BLEND_FACTOR_SRC1_ALPHA, "VK_BLEND_FACTOR_SRC1_ALPHA" );
	swigIntConstant( VK_BLEND_FACTOR_ONE_MINUS_SRC1_ALPHA, "VK_BLEND_FACTOR_ONE_MINUS_SRC1_ALPHA" );
	swigIntConstant( VK_BLEND_FACTOR_BEGIN_RANGE, "VK_BLEND_FACTOR_BEGIN_RANGE" );
	swigIntConstant( VK_BLEND_FACTOR_END_RANGE, "VK_BLEND_FACTOR_END_RANGE" );
	swigIntConstant( VK_BLEND_FACTOR_RANGE_SIZE, "VK_BLEND_FACTOR_RANGE_SIZE" );
	swigIntConstant( VK_BLEND_FACTOR_MAX_ENUM, "VK_BLEND_FACTOR_MAX_ENUM" );
	swigIntConstant( VK_BLEND_OP_ADD, "VK_BLEND_OP_ADD" );
	swigIntConstant( VK_BLEND_OP_SUBTRACT, "VK_BLEND_OP_SUBTRACT" );
	swigIntConstant( VK_BLEND_OP_REVERSE_SUBTRACT, "VK_BLEND_OP_REVERSE_SUBTRACT" );
	swigIntConstant( VK_BLEND_OP_MIN, "VK_BLEND_OP_MIN" );
	swigIntConstant( VK_BLEND_OP_MAX, "VK_BLEND_OP_MAX" );
	swigIntConstant( VK_BLEND_OP_BEGIN_RANGE, "VK_BLEND_OP_BEGIN_RANGE" );
	swigIntConstant( VK_BLEND_OP_END_RANGE, "VK_BLEND_OP_END_RANGE" );
	swigIntConstant( VK_BLEND_OP_RANGE_SIZE, "VK_BLEND_OP_RANGE_SIZE" );
	swigIntConstant( VK_BLEND_OP_MAX_ENUM, "VK_BLEND_OP_MAX_ENUM" );
	swigIntConstant( VK_DYNAMIC_STATE_VIEWPORT, "VK_DYNAMIC_STATE_VIEWPORT" );
	swigIntConstant( VK_DYNAMIC_STATE_SCISSOR, "VK_DYNAMIC_STATE_SCISSOR" );
	swigIntConstant( VK_DYNAMIC_STATE_LINE_WIDTH, "VK_DYNAMIC_STATE_LINE_WIDTH" );
	swigIntConstant( VK_DYNAMIC_STATE_DEPTH_BIAS, "VK_DYNAMIC_STATE_DEPTH_BIAS" );
	swigIntConstant( VK_DYNAMIC_STATE_BLEND_CONSTANTS, "VK_DYNAMIC_STATE_BLEND_CONSTANTS" );
	swigIntConstant( VK_DYNAMIC_STATE_DEPTH_BOUNDS, "VK_DYNAMIC_STATE_DEPTH_BOUNDS" );
	swigIntConstant( VK_DYNAMIC_STATE_STENCIL_COMPARE_MASK, "VK_DYNAMIC_STATE_STENCIL_COMPARE_MASK" );
	swigIntConstant( VK_DYNAMIC_STATE_STENCIL_WRITE_MASK, "VK_DYNAMIC_STATE_STENCIL_WRITE_MASK" );
	swigIntConstant( VK_DYNAMIC_STATE_STENCIL_REFERENCE, "VK_DYNAMIC_STATE_STENCIL_REFERENCE" );
	swigIntConstant( VK_DYNAMIC_STATE_BEGIN_RANGE, "VK_DYNAMIC_STATE_BEGIN_RANGE" );
	swigIntConstant( VK_DYNAMIC_STATE_END_RANGE, "VK_DYNAMIC_STATE_END_RANGE" );
	swigIntConstant( VK_DYNAMIC_STATE_RANGE_SIZE, "VK_DYNAMIC_STATE_RANGE_SIZE" );
	swigIntConstant( VK_DYNAMIC_STATE_MAX_ENUM, "VK_DYNAMIC_STATE_MAX_ENUM" );
	swigIntConstant( VK_FILTER_NEAREST, "VK_FILTER_NEAREST" );
	swigIntConstant( VK_FILTER_LINEAR, "VK_FILTER_LINEAR" );
	swigIntConstant( VK_FILTER_CUBIC_IMG, "VK_FILTER_CUBIC_IMG" );
	swigIntConstant( VK_FILTER_BEGIN_RANGE, "VK_FILTER_BEGIN_RANGE" );
	swigIntConstant( VK_FILTER_END_RANGE, "VK_FILTER_END_RANGE" );
	swigIntConstant( VK_FILTER_RANGE_SIZE, "VK_FILTER_RANGE_SIZE" );
	swigIntConstant( VK_FILTER_MAX_ENUM, "VK_FILTER_MAX_ENUM" );
	swigIntConstant( VK_SAMPLER_MIPMAP_MODE_NEAREST, "VK_SAMPLER_MIPMAP_MODE_NEAREST" );
	swigIntConstant( VK_SAMPLER_MIPMAP_MODE_LINEAR, "VK_SAMPLER_MIPMAP_MODE_LINEAR" );
	swigIntConstant( VK_SAMPLER_MIPMAP_MODE_BEGIN_RANGE, "VK_SAMPLER_MIPMAP_MODE_BEGIN_RANGE" );
	swigIntConstant( VK_SAMPLER_MIPMAP_MODE_END_RANGE, "VK_SAMPLER_MIPMAP_MODE_END_RANGE" );
	swigIntConstant( VK_SAMPLER_MIPMAP_MODE_RANGE_SIZE, "VK_SAMPLER_MIPMAP_MODE_RANGE_SIZE" );
	swigIntConstant( VK_SAMPLER_MIPMAP_MODE_MAX_ENUM, "VK_SAMPLER_MIPMAP_MODE_MAX_ENUM" );
	swigIntConstant( VK_SAMPLER_ADDRESS_MODE_REPEAT, "VK_SAMPLER_ADDRESS_MODE_REPEAT" );
	swigIntConstant( VK_SAMPLER_ADDRESS_MODE_MIRRORED_REPEAT, "VK_SAMPLER_ADDRESS_MODE_MIRRORED_REPEAT" );
	swigIntConstant( VK_SAMPLER_ADDRESS_MODE_CLAMP_TO_EDGE, "VK_SAMPLER_ADDRESS_MODE_CLAMP_TO_EDGE" );
	swigIntConstant( VK_SAMPLER_ADDRESS_MODE_CLAMP_TO_BORDER, "VK_SAMPLER_ADDRESS_MODE_CLAMP_TO_BORDER" );
	swigIntConstant( VK_SAMPLER_ADDRESS_MODE_MIRROR_CLAMP_TO_EDGE, "VK_SAMPLER_ADDRESS_MODE_MIRROR_CLAMP_TO_EDGE" );
	swigIntConstant( VK_SAMPLER_ADDRESS_MODE_BEGIN_RANGE, "VK_SAMPLER_ADDRESS_MODE_BEGIN_RANGE" );
	swigIntConstant( VK_SAMPLER_ADDRESS_MODE_END_RANGE, "VK_SAMPLER_ADDRESS_MODE_END_RANGE" );
	swigIntConstant( VK_SAMPLER_ADDRESS_MODE_RANGE_SIZE, "VK_SAMPLER_ADDRESS_MODE_RANGE_SIZE" );
	swigIntConstant( VK_SAMPLER_ADDRESS_MODE_MAX_ENUM, "VK_SAMPLER_ADDRESS_MODE_MAX_ENUM" );
	swigIntConstant( VK_BORDER_COLOR_FLOAT_TRANSPARENT_BLACK, "VK_BORDER_COLOR_FLOAT_TRANSPARENT_BLACK" );
	swigIntConstant( VK_BORDER_COLOR_INT_TRANSPARENT_BLACK, "VK_BORDER_COLOR_INT_TRANSPARENT_BLACK" );
	swigIntConstant( VK_BORDER_COLOR_FLOAT_OPAQUE_BLACK, "VK_BORDER_COLOR_FLOAT_OPAQUE_BLACK" );
	swigIntConstant( VK_BORDER_COLOR_INT_OPAQUE_BLACK, "VK_BORDER_COLOR_INT_OPAQUE_BLACK" );
	swigIntConstant( VK_BORDER_COLOR_FLOAT_OPAQUE_WHITE, "VK_BORDER_COLOR_FLOAT_OPAQUE_WHITE" );
	swigIntConstant( VK_BORDER_COLOR_INT_OPAQUE_WHITE, "VK_BORDER_COLOR_INT_OPAQUE_WHITE" );
	swigIntConstant( VK_BORDER_COLOR_BEGIN_RANGE, "VK_BORDER_COLOR_BEGIN_RANGE" );
	swigIntConstant( VK_BORDER_COLOR_END_RANGE, "VK_BORDER_COLOR_END_RANGE" );
	swigIntConstant( VK_BORDER_COLOR_RANGE_SIZE, "VK_BORDER_COLOR_RANGE_SIZE" );
	swigIntConstant( VK_BORDER_COLOR_MAX_ENUM, "VK_BORDER_COLOR_MAX_ENUM" );
	swigIntConstant( VK_DESCRIPTOR_TYPE_SAMPLER, "VK_DESCRIPTOR_TYPE_SAMPLER" );
	swigIntConstant( VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, "VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER" );
	swigIntConstant( VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE, "VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE" );
	swigIntConstant( VK_DESCRIPTOR_TYPE_STORAGE_IMAGE, "VK_DESCRIPTOR_TYPE_STORAGE_IMAGE" );
	swigIntConstant( VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER, "VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER" );
	swigIntConstant( VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER, "VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER" );
	swigIntConstant( VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER, "VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER" );
	swigIntConstant( VK_DESCRIPTOR_TYPE_STORAGE_BUFFER, "VK_DESCRIPTOR_TYPE_STORAGE_BUFFER" );
	swigIntConstant( VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC, "VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC" );
	swigIntConstant( VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC, "VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC" );
	swigIntConstant( VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT, "VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT" );
	swigIntConstant( VK_DESCRIPTOR_TYPE_BEGIN_RANGE, "VK_DESCRIPTOR_TYPE_BEGIN_RANGE" );
	swigIntConstant( VK_DESCRIPTOR_TYPE_END_RANGE, "VK_DESCRIPTOR_TYPE_END_RANGE" );
	swigIntConstant( VK_DESCRIPTOR_TYPE_RANGE_SIZE, "VK_DESCRIPTOR_TYPE_RANGE_SIZE" );
	swigIntConstant( VK_DESCRIPTOR_TYPE_MAX_ENUM, "VK_DESCRIPTOR_TYPE_MAX_ENUM" );
	swigIntConstant( VK_ATTACHMENT_LOAD_OP_LOAD, "VK_ATTACHMENT_LOAD_OP_LOAD" );
	swigIntConstant( VK_ATTACHMENT_LOAD_OP_CLEAR, "VK_ATTACHMENT_LOAD_OP_CLEAR" );
	swigIntConstant( VK_ATTACHMENT_LOAD_OP_DONT_CARE, "VK_ATTACHMENT_LOAD_OP_DONT_CARE" );
	swigIntConstant( VK_ATTACHMENT_LOAD_OP_BEGIN_RANGE, "VK_ATTACHMENT_LOAD_OP_BEGIN_RANGE" );
	swigIntConstant( VK_ATTACHMENT_LOAD_OP_END_RANGE, "VK_ATTACHMENT_LOAD_OP_END_RANGE" );
	swigIntConstant( VK_ATTACHMENT_LOAD_OP_RANGE_SIZE, "VK_ATTACHMENT_LOAD_OP_RANGE_SIZE" );
	swigIntConstant( VK_ATTACHMENT_LOAD_OP_MAX_ENUM, "VK_ATTACHMENT_LOAD_OP_MAX_ENUM" );
	swigIntConstant( VK_ATTACHMENT_STORE_OP_STORE, "VK_ATTACHMENT_STORE_OP_STORE" );
	swigIntConstant( VK_ATTACHMENT_STORE_OP_DONT_CARE, "VK_ATTACHMENT_STORE_OP_DONT_CARE" );
	swigIntConstant( VK_ATTACHMENT_STORE_OP_BEGIN_RANGE, "VK_ATTACHMENT_STORE_OP_BEGIN_RANGE" );
	swigIntConstant( VK_ATTACHMENT_STORE_OP_END_RANGE, "VK_ATTACHMENT_STORE_OP_END_RANGE" );
	swigIntConstant( VK_ATTACHMENT_STORE_OP_RANGE_SIZE, "VK_ATTACHMENT_STORE_OP_RANGE_SIZE" );
	swigIntConstant( VK_ATTACHMENT_STORE_OP_MAX_ENUM, "VK_ATTACHMENT_STORE_OP_MAX_ENUM" );
	swigIntConstant( VK_PIPELINE_BIND_POINT_GRAPHICS, "VK_PIPELINE_BIND_POINT_GRAPHICS" );
	swigIntConstant( VK_PIPELINE_BIND_POINT_COMPUTE, "VK_PIPELINE_BIND_POINT_COMPUTE" );
	swigIntConstant( VK_PIPELINE_BIND_POINT_BEGIN_RANGE, "VK_PIPELINE_BIND_POINT_BEGIN_RANGE" );
	swigIntConstant( VK_PIPELINE_BIND_POINT_END_RANGE, "VK_PIPELINE_BIND_POINT_END_RANGE" );
	swigIntConstant( VK_PIPELINE_BIND_POINT_RANGE_SIZE, "VK_PIPELINE_BIND_POINT_RANGE_SIZE" );
	swigIntConstant( VK_PIPELINE_BIND_POINT_MAX_ENUM, "VK_PIPELINE_BIND_POINT_MAX_ENUM" );
	swigIntConstant( VK_COMMAND_BUFFER_LEVEL_PRIMARY, "VK_COMMAND_BUFFER_LEVEL_PRIMARY" );
	swigIntConstant( VK_COMMAND_BUFFER_LEVEL_SECONDARY, "VK_COMMAND_BUFFER_LEVEL_SECONDARY" );
	swigIntConstant( VK_COMMAND_BUFFER_LEVEL_BEGIN_RANGE, "VK_COMMAND_BUFFER_LEVEL_BEGIN_RANGE" );
	swigIntConstant( VK_COMMAND_BUFFER_LEVEL_END_RANGE, "VK_COMMAND_BUFFER_LEVEL_END_RANGE" );
	swigIntConstant( VK_COMMAND_BUFFER_LEVEL_RANGE_SIZE, "VK_COMMAND_BUFFER_LEVEL_RANGE_SIZE" );
	swigIntConstant( VK_COMMAND_BUFFER_LEVEL_MAX_ENUM, "VK_COMMAND_BUFFER_LEVEL_MAX_ENUM" );
	swigIntConstant( VK_INDEX_TYPE_UINT16, "VK_INDEX_TYPE_UINT16" );
	swigIntConstant( VK_INDEX_TYPE_UINT32, "VK_INDEX_TYPE_UINT32" );
	swigIntConstant( VK_INDEX_TYPE_BEGIN_RANGE, "VK_INDEX_TYPE_BEGIN_RANGE" );
	swigIntConstant( VK_INDEX_TYPE_END_RANGE, "VK_INDEX_TYPE_END_RANGE" );
	swigIntConstant( VK_INDEX_TYPE_RANGE_SIZE, "VK_INDEX_TYPE_RANGE_SIZE" );
	swigIntConstant( VK_INDEX_TYPE_MAX_ENUM, "VK_INDEX_TYPE_MAX_ENUM" );
	swigIntConstant( VK_SUBPASS_CONTENTS_INLINE, "VK_SUBPASS_CONTENTS_INLINE" );
	swigIntConstant( VK_SUBPASS_CONTENTS_SECONDARY_COMMAND_BUFFERS, "VK_SUBPASS_CONTENTS_SECONDARY_COMMAND_BUFFERS" );
	swigIntConstant( VK_SUBPASS_CONTENTS_BEGIN_RANGE, "VK_SUBPASS_CONTENTS_BEGIN_RANGE" );
	swigIntConstant( VK_SUBPASS_CONTENTS_END_RANGE, "VK_SUBPASS_CONTENTS_END_RANGE" );
	swigIntConstant( VK_SUBPASS_CONTENTS_RANGE_SIZE, "VK_SUBPASS_CONTENTS_RANGE_SIZE" );
	swigIntConstant( VK_SUBPASS_CONTENTS_MAX_ENUM, "VK_SUBPASS_CONTENTS_MAX_ENUM" );
	swigIntConstant( VK_FORMAT_FEATURE_SAMPLED_IMAGE_BIT, "VK_FORMAT_FEATURE_SAMPLED_IMAGE_BIT" );
	swigIntConstant( VK_FORMAT_FEATURE_STORAGE_IMAGE_BIT, "VK_FORMAT_FEATURE_STORAGE_IMAGE_BIT" );
	swigIntConstant( VK_FORMAT_FEATURE_STORAGE_IMAGE_ATOMIC_BIT, "VK_FORMAT_FEATURE_STORAGE_IMAGE_ATOMIC_BIT" );
	swigIntConstant( VK_FORMAT_FEATURE_UNIFORM_TEXEL_BUFFER_BIT, "VK_FORMAT_FEATURE_UNIFORM_TEXEL_BUFFER_BIT" );
	swigIntConstant( VK_FORMAT_FEATURE_STORAGE_TEXEL_BUFFER_BIT, "VK_FORMAT_FEATURE_STORAGE_TEXEL_BUFFER_BIT" );
	swigIntConstant( VK_FORMAT_FEATURE_STORAGE_TEXEL_BUFFER_ATOMIC_BIT, "VK_FORMAT_FEATURE_STORAGE_TEXEL_BUFFER_ATOMIC_BIT" );
	swigIntConstant( VK_FORMAT_FEATURE_VERTEX_BUFFER_BIT, "VK_FORMAT_FEATURE_VERTEX_BUFFER_BIT" );
	swigIntConstant( VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BIT, "VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BIT" );
	swigIntConstant( VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BLEND_BIT, "VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BLEND_BIT" );
	swigIntConstant( VK_FORMAT_FEATURE_DEPTH_STENCIL_ATTACHMENT_BIT, "VK_FORMAT_FEATURE_DEPTH_STENCIL_ATTACHMENT_BIT" );
	swigIntConstant( VK_FORMAT_FEATURE_BLIT_SRC_BIT, "VK_FORMAT_FEATURE_BLIT_SRC_BIT" );
	swigIntConstant( VK_FORMAT_FEATURE_BLIT_DST_BIT, "VK_FORMAT_FEATURE_BLIT_DST_BIT" );
	swigIntConstant( VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_LINEAR_BIT, "VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_LINEAR_BIT" );
	swigIntConstant( VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_CUBIC_BIT_IMG, "VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_CUBIC_BIT_IMG" );
	swigIntConstant( VK_FORMAT_FEATURE_FLAG_BITS_MAX_ENUM, "VK_FORMAT_FEATURE_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_IMAGE_USAGE_TRANSFER_SRC_BIT, "VK_IMAGE_USAGE_TRANSFER_SRC_BIT" );
	swigIntConstant( VK_IMAGE_USAGE_TRANSFER_DST_BIT, "VK_IMAGE_USAGE_TRANSFER_DST_BIT" );
	swigIntConstant( VK_IMAGE_USAGE_SAMPLED_BIT, "VK_IMAGE_USAGE_SAMPLED_BIT" );
	swigIntConstant( VK_IMAGE_USAGE_STORAGE_BIT, "VK_IMAGE_USAGE_STORAGE_BIT" );
	swigIntConstant( VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT, "VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT" );
	swigIntConstant( VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT, "VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT" );
	swigIntConstant( VK_IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT, "VK_IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT" );
	swigIntConstant( VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT, "VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT" );
	swigIntConstant( VK_IMAGE_USAGE_FLAG_BITS_MAX_ENUM, "VK_IMAGE_USAGE_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_IMAGE_CREATE_SPARSE_BINDING_BIT, "VK_IMAGE_CREATE_SPARSE_BINDING_BIT" );
	swigIntConstant( VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT, "VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT" );
	swigIntConstant( VK_IMAGE_CREATE_SPARSE_ALIASED_BIT, "VK_IMAGE_CREATE_SPARSE_ALIASED_BIT" );
	swigIntConstant( VK_IMAGE_CREATE_MUTABLE_FORMAT_BIT, "VK_IMAGE_CREATE_MUTABLE_FORMAT_BIT" );
	swigIntConstant( VK_IMAGE_CREATE_CUBE_COMPATIBLE_BIT, "VK_IMAGE_CREATE_CUBE_COMPATIBLE_BIT" );
	swigIntConstant( VK_IMAGE_CREATE_FLAG_BITS_MAX_ENUM, "VK_IMAGE_CREATE_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_SAMPLE_COUNT_1_BIT, "VK_SAMPLE_COUNT_1_BIT" );
	swigIntConstant( VK_SAMPLE_COUNT_2_BIT, "VK_SAMPLE_COUNT_2_BIT" );
	swigIntConstant( VK_SAMPLE_COUNT_4_BIT, "VK_SAMPLE_COUNT_4_BIT" );
	swigIntConstant( VK_SAMPLE_COUNT_8_BIT, "VK_SAMPLE_COUNT_8_BIT" );
	swigIntConstant( VK_SAMPLE_COUNT_16_BIT, "VK_SAMPLE_COUNT_16_BIT" );
	swigIntConstant( VK_SAMPLE_COUNT_32_BIT, "VK_SAMPLE_COUNT_32_BIT" );
	swigIntConstant( VK_SAMPLE_COUNT_64_BIT, "VK_SAMPLE_COUNT_64_BIT" );
	swigIntConstant( VK_SAMPLE_COUNT_FLAG_BITS_MAX_ENUM, "VK_SAMPLE_COUNT_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_QUEUE_GRAPHICS_BIT, "VK_QUEUE_GRAPHICS_BIT" );
	swigIntConstant( VK_QUEUE_COMPUTE_BIT, "VK_QUEUE_COMPUTE_BIT" );
	swigIntConstant( VK_QUEUE_TRANSFER_BIT, "VK_QUEUE_TRANSFER_BIT" );
	swigIntConstant( VK_QUEUE_SPARSE_BINDING_BIT, "VK_QUEUE_SPARSE_BINDING_BIT" );
	swigIntConstant( VK_QUEUE_FLAG_BITS_MAX_ENUM, "VK_QUEUE_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_MEMORY_PROPERTY_DEVICE_LOCAL_BIT, "VK_MEMORY_PROPERTY_DEVICE_LOCAL_BIT" );
	swigIntConstant( VK_MEMORY_PROPERTY_HOST_VISIBLE_BIT, "VK_MEMORY_PROPERTY_HOST_VISIBLE_BIT" );
	swigIntConstant( VK_MEMORY_PROPERTY_HOST_COHERENT_BIT, "VK_MEMORY_PROPERTY_HOST_COHERENT_BIT" );
	swigIntConstant( VK_MEMORY_PROPERTY_HOST_CACHED_BIT, "VK_MEMORY_PROPERTY_HOST_CACHED_BIT" );
	swigIntConstant( VK_MEMORY_PROPERTY_LAZILY_ALLOCATED_BIT, "VK_MEMORY_PROPERTY_LAZILY_ALLOCATED_BIT" );
	swigIntConstant( VK_MEMORY_PROPERTY_FLAG_BITS_MAX_ENUM, "VK_MEMORY_PROPERTY_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_MEMORY_HEAP_DEVICE_LOCAL_BIT, "VK_MEMORY_HEAP_DEVICE_LOCAL_BIT" );
	swigIntConstant( VK_MEMORY_HEAP_FLAG_BITS_MAX_ENUM, "VK_MEMORY_HEAP_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_PIPELINE_STAGE_TOP_OF_PIPE_BIT, "VK_PIPELINE_STAGE_TOP_OF_PIPE_BIT" );
	swigIntConstant( VK_PIPELINE_STAGE_DRAW_INDIRECT_BIT, "VK_PIPELINE_STAGE_DRAW_INDIRECT_BIT" );
	swigIntConstant( VK_PIPELINE_STAGE_VERTEX_INPUT_BIT, "VK_PIPELINE_STAGE_VERTEX_INPUT_BIT" );
	swigIntConstant( VK_PIPELINE_STAGE_VERTEX_SHADER_BIT, "VK_PIPELINE_STAGE_VERTEX_SHADER_BIT" );
	swigIntConstant( VK_PIPELINE_STAGE_TESSELLATION_CONTROL_SHADER_BIT, "VK_PIPELINE_STAGE_TESSELLATION_CONTROL_SHADER_BIT" );
	swigIntConstant( VK_PIPELINE_STAGE_TESSELLATION_EVALUATION_SHADER_BIT, "VK_PIPELINE_STAGE_TESSELLATION_EVALUATION_SHADER_BIT" );
	swigIntConstant( VK_PIPELINE_STAGE_GEOMETRY_SHADER_BIT, "VK_PIPELINE_STAGE_GEOMETRY_SHADER_BIT" );
	swigIntConstant( VK_PIPELINE_STAGE_FRAGMENT_SHADER_BIT, "VK_PIPELINE_STAGE_FRAGMENT_SHADER_BIT" );
	swigIntConstant( VK_PIPELINE_STAGE_EARLY_FRAGMENT_TESTS_BIT, "VK_PIPELINE_STAGE_EARLY_FRAGMENT_TESTS_BIT" );
	swigIntConstant( VK_PIPELINE_STAGE_LATE_FRAGMENT_TESTS_BIT, "VK_PIPELINE_STAGE_LATE_FRAGMENT_TESTS_BIT" );
	swigIntConstant( VK_PIPELINE_STAGE_COLOR_ATTACHMENT_OUTPUT_BIT, "VK_PIPELINE_STAGE_COLOR_ATTACHMENT_OUTPUT_BIT" );
	swigIntConstant( VK_PIPELINE_STAGE_COMPUTE_SHADER_BIT, "VK_PIPELINE_STAGE_COMPUTE_SHADER_BIT" );
	swigIntConstant( VK_PIPELINE_STAGE_TRANSFER_BIT, "VK_PIPELINE_STAGE_TRANSFER_BIT" );
	swigIntConstant( VK_PIPELINE_STAGE_BOTTOM_OF_PIPE_BIT, "VK_PIPELINE_STAGE_BOTTOM_OF_PIPE_BIT" );
	swigIntConstant( VK_PIPELINE_STAGE_HOST_BIT, "VK_PIPELINE_STAGE_HOST_BIT" );
	swigIntConstant( VK_PIPELINE_STAGE_ALL_GRAPHICS_BIT, "VK_PIPELINE_STAGE_ALL_GRAPHICS_BIT" );
	swigIntConstant( VK_PIPELINE_STAGE_ALL_COMMANDS_BIT, "VK_PIPELINE_STAGE_ALL_COMMANDS_BIT" );
	swigIntConstant( VK_PIPELINE_STAGE_FLAG_BITS_MAX_ENUM, "VK_PIPELINE_STAGE_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_IMAGE_ASPECT_COLOR_BIT, "VK_IMAGE_ASPECT_COLOR_BIT" );
	swigIntConstant( VK_IMAGE_ASPECT_DEPTH_BIT, "VK_IMAGE_ASPECT_DEPTH_BIT" );
	swigIntConstant( VK_IMAGE_ASPECT_STENCIL_BIT, "VK_IMAGE_ASPECT_STENCIL_BIT" );
	swigIntConstant( VK_IMAGE_ASPECT_METADATA_BIT, "VK_IMAGE_ASPECT_METADATA_BIT" );
	swigIntConstant( VK_IMAGE_ASPECT_FLAG_BITS_MAX_ENUM, "VK_IMAGE_ASPECT_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_SPARSE_IMAGE_FORMAT_SINGLE_MIPTAIL_BIT, "VK_SPARSE_IMAGE_FORMAT_SINGLE_MIPTAIL_BIT" );
	swigIntConstant( VK_SPARSE_IMAGE_FORMAT_ALIGNED_MIP_SIZE_BIT, "VK_SPARSE_IMAGE_FORMAT_ALIGNED_MIP_SIZE_BIT" );
	swigIntConstant( VK_SPARSE_IMAGE_FORMAT_NONSTANDARD_BLOCK_SIZE_BIT, "VK_SPARSE_IMAGE_FORMAT_NONSTANDARD_BLOCK_SIZE_BIT" );
	swigIntConstant( VK_SPARSE_IMAGE_FORMAT_FLAG_BITS_MAX_ENUM, "VK_SPARSE_IMAGE_FORMAT_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_SPARSE_MEMORY_BIND_METADATA_BIT, "VK_SPARSE_MEMORY_BIND_METADATA_BIT" );
	swigIntConstant( VK_SPARSE_MEMORY_BIND_FLAG_BITS_MAX_ENUM, "VK_SPARSE_MEMORY_BIND_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_FENCE_CREATE_SIGNALED_BIT, "VK_FENCE_CREATE_SIGNALED_BIT" );
	swigIntConstant( VK_FENCE_CREATE_FLAG_BITS_MAX_ENUM, "VK_FENCE_CREATE_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_QUERY_PIPELINE_STATISTIC_INPUT_ASSEMBLY_VERTICES_BIT, "VK_QUERY_PIPELINE_STATISTIC_INPUT_ASSEMBLY_VERTICES_BIT" );
	swigIntConstant( VK_QUERY_PIPELINE_STATISTIC_INPUT_ASSEMBLY_PRIMITIVES_BIT, "VK_QUERY_PIPELINE_STATISTIC_INPUT_ASSEMBLY_PRIMITIVES_BIT" );
	swigIntConstant( VK_QUERY_PIPELINE_STATISTIC_VERTEX_SHADER_INVOCATIONS_BIT, "VK_QUERY_PIPELINE_STATISTIC_VERTEX_SHADER_INVOCATIONS_BIT" );
	swigIntConstant( VK_QUERY_PIPELINE_STATISTIC_GEOMETRY_SHADER_INVOCATIONS_BIT, "VK_QUERY_PIPELINE_STATISTIC_GEOMETRY_SHADER_INVOCATIONS_BIT" );
	swigIntConstant( VK_QUERY_PIPELINE_STATISTIC_GEOMETRY_SHADER_PRIMITIVES_BIT, "VK_QUERY_PIPELINE_STATISTIC_GEOMETRY_SHADER_PRIMITIVES_BIT" );
	swigIntConstant( VK_QUERY_PIPELINE_STATISTIC_CLIPPING_INVOCATIONS_BIT, "VK_QUERY_PIPELINE_STATISTIC_CLIPPING_INVOCATIONS_BIT" );
	swigIntConstant( VK_QUERY_PIPELINE_STATISTIC_CLIPPING_PRIMITIVES_BIT, "VK_QUERY_PIPELINE_STATISTIC_CLIPPING_PRIMITIVES_BIT" );
	swigIntConstant( VK_QUERY_PIPELINE_STATISTIC_FRAGMENT_SHADER_INVOCATIONS_BIT, "VK_QUERY_PIPELINE_STATISTIC_FRAGMENT_SHADER_INVOCATIONS_BIT" );
	swigIntConstant( VK_QUERY_PIPELINE_STATISTIC_TESSELLATION_CONTROL_SHADER_PATCHES_BIT, "VK_QUERY_PIPELINE_STATISTIC_TESSELLATION_CONTROL_SHADER_PATCHES_BIT" );
	swigIntConstant( VK_QUERY_PIPELINE_STATISTIC_TESSELLATION_EVALUATION_SHADER_INVOCATIONS_BIT, "VK_QUERY_PIPELINE_STATISTIC_TESSELLATION_EVALUATION_SHADER_INVOCATIONS_BIT" );
	swigIntConstant( VK_QUERY_PIPELINE_STATISTIC_COMPUTE_SHADER_INVOCATIONS_BIT, "VK_QUERY_PIPELINE_STATISTIC_COMPUTE_SHADER_INVOCATIONS_BIT" );
	swigIntConstant( VK_QUERY_PIPELINE_STATISTIC_FLAG_BITS_MAX_ENUM, "VK_QUERY_PIPELINE_STATISTIC_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_QUERY_RESULT_64_BIT, "VK_QUERY_RESULT_64_BIT" );
	swigIntConstant( VK_QUERY_RESULT_WAIT_BIT, "VK_QUERY_RESULT_WAIT_BIT" );
	swigIntConstant( VK_QUERY_RESULT_WITH_AVAILABILITY_BIT, "VK_QUERY_RESULT_WITH_AVAILABILITY_BIT" );
	swigIntConstant( VK_QUERY_RESULT_PARTIAL_BIT, "VK_QUERY_RESULT_PARTIAL_BIT" );
	swigIntConstant( VK_QUERY_RESULT_FLAG_BITS_MAX_ENUM, "VK_QUERY_RESULT_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_BUFFER_CREATE_SPARSE_BINDING_BIT, "VK_BUFFER_CREATE_SPARSE_BINDING_BIT" );
	swigIntConstant( VK_BUFFER_CREATE_SPARSE_RESIDENCY_BIT, "VK_BUFFER_CREATE_SPARSE_RESIDENCY_BIT" );
	swigIntConstant( VK_BUFFER_CREATE_SPARSE_ALIASED_BIT, "VK_BUFFER_CREATE_SPARSE_ALIASED_BIT" );
	swigIntConstant( VK_BUFFER_CREATE_FLAG_BITS_MAX_ENUM, "VK_BUFFER_CREATE_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_BUFFER_USAGE_TRANSFER_SRC_BIT, "VK_BUFFER_USAGE_TRANSFER_SRC_BIT" );
	swigIntConstant( VK_BUFFER_USAGE_TRANSFER_DST_BIT, "VK_BUFFER_USAGE_TRANSFER_DST_BIT" );
	swigIntConstant( VK_BUFFER_USAGE_UNIFORM_TEXEL_BUFFER_BIT, "VK_BUFFER_USAGE_UNIFORM_TEXEL_BUFFER_BIT" );
	swigIntConstant( VK_BUFFER_USAGE_STORAGE_TEXEL_BUFFER_BIT, "VK_BUFFER_USAGE_STORAGE_TEXEL_BUFFER_BIT" );
	swigIntConstant( VK_BUFFER_USAGE_UNIFORM_BUFFER_BIT, "VK_BUFFER_USAGE_UNIFORM_BUFFER_BIT" );
	swigIntConstant( VK_BUFFER_USAGE_STORAGE_BUFFER_BIT, "VK_BUFFER_USAGE_STORAGE_BUFFER_BIT" );
	swigIntConstant( VK_BUFFER_USAGE_INDEX_BUFFER_BIT, "VK_BUFFER_USAGE_INDEX_BUFFER_BIT" );
	swigIntConstant( VK_BUFFER_USAGE_VERTEX_BUFFER_BIT, "VK_BUFFER_USAGE_VERTEX_BUFFER_BIT" );
	swigIntConstant( VK_BUFFER_USAGE_INDIRECT_BUFFER_BIT, "VK_BUFFER_USAGE_INDIRECT_BUFFER_BIT" );
	swigIntConstant( VK_BUFFER_USAGE_FLAG_BITS_MAX_ENUM, "VK_BUFFER_USAGE_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_PIPELINE_CREATE_DISABLE_OPTIMIZATION_BIT, "VK_PIPELINE_CREATE_DISABLE_OPTIMIZATION_BIT" );
	swigIntConstant( VK_PIPELINE_CREATE_ALLOW_DERIVATIVES_BIT, "VK_PIPELINE_CREATE_ALLOW_DERIVATIVES_BIT" );
	swigIntConstant( VK_PIPELINE_CREATE_DERIVATIVE_BIT, "VK_PIPELINE_CREATE_DERIVATIVE_BIT" );
	swigIntConstant( VK_PIPELINE_CREATE_FLAG_BITS_MAX_ENUM, "VK_PIPELINE_CREATE_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_SHADER_STAGE_VERTEX_BIT, "VK_SHADER_STAGE_VERTEX_BIT" );
	swigIntConstant( VK_SHADER_STAGE_TESSELLATION_CONTROL_BIT, "VK_SHADER_STAGE_TESSELLATION_CONTROL_BIT" );
	swigIntConstant( VK_SHADER_STAGE_TESSELLATION_EVALUATION_BIT, "VK_SHADER_STAGE_TESSELLATION_EVALUATION_BIT" );
	swigIntConstant( VK_SHADER_STAGE_GEOMETRY_BIT, "VK_SHADER_STAGE_GEOMETRY_BIT" );
	swigIntConstant( VK_SHADER_STAGE_FRAGMENT_BIT, "VK_SHADER_STAGE_FRAGMENT_BIT" );
	swigIntConstant( VK_SHADER_STAGE_COMPUTE_BIT, "VK_SHADER_STAGE_COMPUTE_BIT" );
	swigIntConstant( VK_SHADER_STAGE_ALL_GRAPHICS, "VK_SHADER_STAGE_ALL_GRAPHICS" );
	swigIntConstant( VK_SHADER_STAGE_ALL, "VK_SHADER_STAGE_ALL" );
	swigIntConstant( VK_SHADER_STAGE_FLAG_BITS_MAX_ENUM, "VK_SHADER_STAGE_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_CULL_MODE_NONE, "VK_CULL_MODE_NONE" );
	swigIntConstant( VK_CULL_MODE_FRONT_BIT, "VK_CULL_MODE_FRONT_BIT" );
	swigIntConstant( VK_CULL_MODE_BACK_BIT, "VK_CULL_MODE_BACK_BIT" );
	swigIntConstant( VK_CULL_MODE_FRONT_AND_BACK, "VK_CULL_MODE_FRONT_AND_BACK" );
	swigIntConstant( VK_CULL_MODE_FLAG_BITS_MAX_ENUM, "VK_CULL_MODE_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_COLOR_COMPONENT_R_BIT, "VK_COLOR_COMPONENT_R_BIT" );
	swigIntConstant( VK_COLOR_COMPONENT_G_BIT, "VK_COLOR_COMPONENT_G_BIT" );
	swigIntConstant( VK_COLOR_COMPONENT_B_BIT, "VK_COLOR_COMPONENT_B_BIT" );
	swigIntConstant( VK_COLOR_COMPONENT_A_BIT, "VK_COLOR_COMPONENT_A_BIT" );
	swigIntConstant( VK_COLOR_COMPONENT_FLAG_BITS_MAX_ENUM, "VK_COLOR_COMPONENT_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_DESCRIPTOR_POOL_CREATE_FREE_DESCRIPTOR_SET_BIT, "VK_DESCRIPTOR_POOL_CREATE_FREE_DESCRIPTOR_SET_BIT" );
	swigIntConstant( VK_DESCRIPTOR_POOL_CREATE_FLAG_BITS_MAX_ENUM, "VK_DESCRIPTOR_POOL_CREATE_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_ATTACHMENT_DESCRIPTION_MAY_ALIAS_BIT, "VK_ATTACHMENT_DESCRIPTION_MAY_ALIAS_BIT" );
	swigIntConstant( VK_ATTACHMENT_DESCRIPTION_FLAG_BITS_MAX_ENUM, "VK_ATTACHMENT_DESCRIPTION_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_ACCESS_INDIRECT_COMMAND_READ_BIT, "VK_ACCESS_INDIRECT_COMMAND_READ_BIT" );
	swigIntConstant( VK_ACCESS_INDEX_READ_BIT, "VK_ACCESS_INDEX_READ_BIT" );
	swigIntConstant( VK_ACCESS_VERTEX_ATTRIBUTE_READ_BIT, "VK_ACCESS_VERTEX_ATTRIBUTE_READ_BIT" );
	swigIntConstant( VK_ACCESS_UNIFORM_READ_BIT, "VK_ACCESS_UNIFORM_READ_BIT" );
	swigIntConstant( VK_ACCESS_INPUT_ATTACHMENT_READ_BIT, "VK_ACCESS_INPUT_ATTACHMENT_READ_BIT" );
	swigIntConstant( VK_ACCESS_SHADER_READ_BIT, "VK_ACCESS_SHADER_READ_BIT" );
	swigIntConstant( VK_ACCESS_SHADER_WRITE_BIT, "VK_ACCESS_SHADER_WRITE_BIT" );
	swigIntConstant( VK_ACCESS_COLOR_ATTACHMENT_READ_BIT, "VK_ACCESS_COLOR_ATTACHMENT_READ_BIT" );
	swigIntConstant( VK_ACCESS_COLOR_ATTACHMENT_WRITE_BIT, "VK_ACCESS_COLOR_ATTACHMENT_WRITE_BIT" );
	swigIntConstant( VK_ACCESS_DEPTH_STENCIL_ATTACHMENT_READ_BIT, "VK_ACCESS_DEPTH_STENCIL_ATTACHMENT_READ_BIT" );
	swigIntConstant( VK_ACCESS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT, "VK_ACCESS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT" );
	swigIntConstant( VK_ACCESS_TRANSFER_READ_BIT, "VK_ACCESS_TRANSFER_READ_BIT" );
	swigIntConstant( VK_ACCESS_TRANSFER_WRITE_BIT, "VK_ACCESS_TRANSFER_WRITE_BIT" );
	swigIntConstant( VK_ACCESS_HOST_READ_BIT, "VK_ACCESS_HOST_READ_BIT" );
	swigIntConstant( VK_ACCESS_HOST_WRITE_BIT, "VK_ACCESS_HOST_WRITE_BIT" );
	swigIntConstant( VK_ACCESS_MEMORY_READ_BIT, "VK_ACCESS_MEMORY_READ_BIT" );
	swigIntConstant( VK_ACCESS_MEMORY_WRITE_BIT, "VK_ACCESS_MEMORY_WRITE_BIT" );
	swigIntConstant( VK_ACCESS_FLAG_BITS_MAX_ENUM, "VK_ACCESS_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_DEPENDENCY_BY_REGION_BIT, "VK_DEPENDENCY_BY_REGION_BIT" );
	swigIntConstant( VK_DEPENDENCY_FLAG_BITS_MAX_ENUM, "VK_DEPENDENCY_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_COMMAND_POOL_CREATE_TRANSIENT_BIT, "VK_COMMAND_POOL_CREATE_TRANSIENT_BIT" );
	swigIntConstant( VK_COMMAND_POOL_CREATE_RESET_COMMAND_BUFFER_BIT, "VK_COMMAND_POOL_CREATE_RESET_COMMAND_BUFFER_BIT" );
	swigIntConstant( VK_COMMAND_POOL_CREATE_FLAG_BITS_MAX_ENUM, "VK_COMMAND_POOL_CREATE_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_COMMAND_POOL_RESET_RELEASE_RESOURCES_BIT, "VK_COMMAND_POOL_RESET_RELEASE_RESOURCES_BIT" );
	swigIntConstant( VK_COMMAND_POOL_RESET_FLAG_BITS_MAX_ENUM, "VK_COMMAND_POOL_RESET_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_COMMAND_BUFFER_USAGE_ONE_TIME_SUBMIT_BIT, "VK_COMMAND_BUFFER_USAGE_ONE_TIME_SUBMIT_BIT" );
	swigIntConstant( VK_COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT, "VK_COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT" );
	swigIntConstant( VK_COMMAND_BUFFER_USAGE_SIMULTANEOUS_USE_BIT, "VK_COMMAND_BUFFER_USAGE_SIMULTANEOUS_USE_BIT" );
	swigIntConstant( VK_COMMAND_BUFFER_USAGE_FLAG_BITS_MAX_ENUM, "VK_COMMAND_BUFFER_USAGE_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_QUERY_CONTROL_PRECISE_BIT, "VK_QUERY_CONTROL_PRECISE_BIT" );
	swigIntConstant( VK_QUERY_CONTROL_FLAG_BITS_MAX_ENUM, "VK_QUERY_CONTROL_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_COMMAND_BUFFER_RESET_RELEASE_RESOURCES_BIT, "VK_COMMAND_BUFFER_RESET_RELEASE_RESOURCES_BIT" );
	swigIntConstant( VK_COMMAND_BUFFER_RESET_FLAG_BITS_MAX_ENUM, "VK_COMMAND_BUFFER_RESET_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_STENCIL_FACE_FRONT_BIT, "VK_STENCIL_FACE_FRONT_BIT" );
	swigIntConstant( VK_STENCIL_FACE_BACK_BIT, "VK_STENCIL_FACE_BACK_BIT" );
	swigIntConstant( VK_STENCIL_FRONT_AND_BACK, "VK_STENCIL_FRONT_AND_BACK" );
	swigIntConstant( VK_STENCIL_FACE_FLAG_BITS_MAX_ENUM, "VK_STENCIL_FACE_FLAG_BITS_MAX_ENUM" );
	swigIntConstant( VK_COLOR_SPACE_SRGB_NONLINEAR_KHR, "VK_COLOR_SPACE_SRGB_NONLINEAR_KHR" );
	swigIntConstant( VK_COLOR_SPACE_BEGIN_RANGE_KHR, "VK_COLOR_SPACE_BEGIN_RANGE_KHR" );
	swigIntConstant( VK_COLOR_SPACE_END_RANGE_KHR, "VK_COLOR_SPACE_END_RANGE_KHR" );
	swigIntConstant( VK_COLOR_SPACE_RANGE_SIZE_KHR, "VK_COLOR_SPACE_RANGE_SIZE_KHR" );
	swigIntConstant( VK_COLOR_SPACE_MAX_ENUM_KHR, "VK_COLOR_SPACE_MAX_ENUM_KHR" );
	swigIntConstant( VK_PRESENT_MODE_IMMEDIATE_KHR, "VK_PRESENT_MODE_IMMEDIATE_KHR" );
	swigIntConstant( VK_PRESENT_MODE_MAILBOX_KHR, "VK_PRESENT_MODE_MAILBOX_KHR" );
	swigIntConstant( VK_PRESENT_MODE_FIFO_KHR, "VK_PRESENT_MODE_FIFO_KHR" );
	swigIntConstant( VK_PRESENT_MODE_FIFO_RELAXED_KHR, "VK_PRESENT_MODE_FIFO_RELAXED_KHR" );
	swigIntConstant( VK_PRESENT_MODE_BEGIN_RANGE_KHR, "VK_PRESENT_MODE_BEGIN_RANGE_KHR" );
	swigIntConstant( VK_PRESENT_MODE_END_RANGE_KHR, "VK_PRESENT_MODE_END_RANGE_KHR" );
	swigIntConstant( VK_PRESENT_MODE_RANGE_SIZE_KHR, "VK_PRESENT_MODE_RANGE_SIZE_KHR" );
	swigIntConstant( VK_PRESENT_MODE_MAX_ENUM_KHR, "VK_PRESENT_MODE_MAX_ENUM_KHR" );
	swigIntConstant( VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR, "VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR" );
	swigIntConstant( VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, "VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR" );
	swigIntConstant( VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, "VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR" );
	swigIntConstant( VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR, "VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR" );
	swigIntConstant( VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_BIT_KHR, "VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_BIT_KHR" );
	swigIntConstant( VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_90_BIT_KHR, "VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_90_BIT_KHR" );
	swigIntConstant( VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_180_BIT_KHR, "VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_180_BIT_KHR" );
	swigIntConstant( VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_270_BIT_KHR, "VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_270_BIT_KHR" );
	swigIntConstant( VK_SURFACE_TRANSFORM_INHERIT_BIT_KHR, "VK_SURFACE_TRANSFORM_INHERIT_BIT_KHR" );
	swigIntConstant( VK_SURFACE_TRANSFORM_FLAG_BITS_MAX_ENUM_KHR, "VK_SURFACE_TRANSFORM_FLAG_BITS_MAX_ENUM_KHR" );
	swigIntConstant( VK_COMPOSITE_ALPHA_OPAQUE_BIT_KHR, "VK_COMPOSITE_ALPHA_OPAQUE_BIT_KHR" );
	swigIntConstant( VK_COMPOSITE_ALPHA_PRE_MULTIPLIED_BIT_KHR, "VK_COMPOSITE_ALPHA_PRE_MULTIPLIED_BIT_KHR" );
	swigIntConstant( VK_COMPOSITE_ALPHA_POST_MULTIPLIED_BIT_KHR, "VK_COMPOSITE_ALPHA_POST_MULTIPLIED_BIT_KHR" );
	swigIntConstant( VK_COMPOSITE_ALPHA_INHERIT_BIT_KHR, "VK_COMPOSITE_ALPHA_INHERIT_BIT_KHR" );
	swigIntConstant( VK_COMPOSITE_ALPHA_FLAG_BITS_MAX_ENUM_KHR, "VK_COMPOSITE_ALPHA_FLAG_BITS_MAX_ENUM_KHR" );
	swigIntConstant( VK_DISPLAY_PLANE_ALPHA_OPAQUE_BIT_KHR, "VK_DISPLAY_PLANE_ALPHA_OPAQUE_BIT_KHR" );
	swigIntConstant( VK_DISPLAY_PLANE_ALPHA_GLOBAL_BIT_KHR, "VK_DISPLAY_PLANE_ALPHA_GLOBAL_BIT_KHR" );
	swigIntConstant( VK_DISPLAY_PLANE_ALPHA_PER_PIXEL_BIT_KHR, "VK_DISPLAY_PLANE_ALPHA_PER_PIXEL_BIT_KHR" );
	swigIntConstant( VK_DISPLAY_PLANE_ALPHA_PER_PIXEL_PREMULTIPLIED_BIT_KHR, "VK_DISPLAY_PLANE_ALPHA_PER_PIXEL_PREMULTIPLIED_BIT_KHR" );
	swigIntConstant( VK_DISPLAY_PLANE_ALPHA_FLAG_BITS_MAX_ENUM_KHR, "VK_DISPLAY_PLANE_ALPHA_FLAG_BITS_MAX_ENUM_KHR" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_UNKNOWN_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_UNKNOWN_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_INSTANCE_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_INSTANCE_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_PHYSICAL_DEVICE_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_PHYSICAL_DEVICE_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_DEVICE_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_DEVICE_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_QUEUE_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_QUEUE_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_SEMAPHORE_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_SEMAPHORE_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_COMMAND_BUFFER_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_COMMAND_BUFFER_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_FENCE_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_FENCE_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_DEVICE_MEMORY_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_DEVICE_MEMORY_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_BUFFER_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_BUFFER_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_IMAGE_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_IMAGE_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_EVENT_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_EVENT_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_QUERY_POOL_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_QUERY_POOL_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_BUFFER_VIEW_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_BUFFER_VIEW_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_IMAGE_VIEW_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_IMAGE_VIEW_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_SHADER_MODULE_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_SHADER_MODULE_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_PIPELINE_CACHE_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_PIPELINE_CACHE_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_PIPELINE_LAYOUT_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_PIPELINE_LAYOUT_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_RENDER_PASS_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_RENDER_PASS_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_PIPELINE_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_PIPELINE_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_DESCRIPTOR_SET_LAYOUT_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_DESCRIPTOR_SET_LAYOUT_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_SAMPLER_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_SAMPLER_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_DESCRIPTOR_POOL_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_DESCRIPTOR_POOL_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_DESCRIPTOR_SET_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_DESCRIPTOR_SET_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_FRAMEBUFFER_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_FRAMEBUFFER_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_COMMAND_POOL_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_COMMAND_POOL_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_SURFACE_KHR_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_SURFACE_KHR_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_SWAPCHAIN_KHR_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_SWAPCHAIN_KHR_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_DEBUG_REPORT_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_DEBUG_REPORT_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_BEGIN_RANGE_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_BEGIN_RANGE_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_END_RANGE_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_END_RANGE_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_RANGE_SIZE_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_RANGE_SIZE_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_OBJECT_TYPE_MAX_ENUM_EXT, "VK_DEBUG_REPORT_OBJECT_TYPE_MAX_ENUM_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_ERROR_NONE_EXT, "VK_DEBUG_REPORT_ERROR_NONE_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_ERROR_CALLBACK_REF_EXT, "VK_DEBUG_REPORT_ERROR_CALLBACK_REF_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_ERROR_BEGIN_RANGE_EXT, "VK_DEBUG_REPORT_ERROR_BEGIN_RANGE_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_ERROR_END_RANGE_EXT, "VK_DEBUG_REPORT_ERROR_END_RANGE_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_ERROR_RANGE_SIZE_EXT, "VK_DEBUG_REPORT_ERROR_RANGE_SIZE_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_ERROR_MAX_ENUM_EXT, "VK_DEBUG_REPORT_ERROR_MAX_ENUM_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_INFORMATION_BIT_EXT, "VK_DEBUG_REPORT_INFORMATION_BIT_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_WARNING_BIT_EXT, "VK_DEBUG_REPORT_WARNING_BIT_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_PERFORMANCE_WARNING_BIT_EXT, "VK_DEBUG_REPORT_PERFORMANCE_WARNING_BIT_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_ERROR_BIT_EXT, "VK_DEBUG_REPORT_ERROR_BIT_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_DEBUG_BIT_EXT, "VK_DEBUG_REPORT_DEBUG_BIT_EXT" );
	swigIntConstant( VK_DEBUG_REPORT_FLAG_BITS_MAX_ENUM_EXT, "VK_DEBUG_REPORT_FLAG_BITS_MAX_ENUM_EXT" );
	swigIntConstant( VK_RASTERIZATION_ORDER_STRICT_AMD, "VK_RASTERIZATION_ORDER_STRICT_AMD" );
	swigIntConstant( VK_RASTERIZATION_ORDER_RELAXED_AMD, "VK_RASTERIZATION_ORDER_RELAXED_AMD" );
	swigIntConstant( VK_RASTERIZATION_ORDER_BEGIN_RANGE_AMD, "VK_RASTERIZATION_ORDER_BEGIN_RANGE_AMD" );
	swigIntConstant( VK_RASTERIZATION_ORDER_END_RANGE_AMD, "VK_RASTERIZATION_ORDER_END_RANGE_AMD" );
	swigIntConstant( VK_RASTERIZATION_ORDER_RANGE_SIZE_AMD, "VK_RASTERIZATION_ORDER_RANGE_SIZE_AMD" );
	swigIntConstant( VK_RASTERIZATION_ORDER_MAX_ENUM_AMD, "VK_RASTERIZATION_ORDER_MAX_ENUM_AMD" );

	swigNewline();

	swigComment("-------===< structs >===--------\n");

	swigComment("VkApplicationInfo\n");
	printf( "begin-structure VkApplicationInfo\n" );
	swigStructField( "VkApplicationInfo-pNext", offsetof( struct VkApplicationInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkApplicationInfo-applicationVersion", offsetof( struct VkApplicationInfo, applicationVersion ), sizeof( uint32_t ) );
	swigStructField( "VkApplicationInfo-pEngineName", offsetof( struct VkApplicationInfo, pEngineName ), sizeof( char const * ) );
	swigStructField( "VkApplicationInfo-engineVersion", offsetof( struct VkApplicationInfo, engineVersion ), sizeof( uint32_t ) );
	swigStructField( "VkApplicationInfo-apiVersion", offsetof( struct VkApplicationInfo, apiVersion ), sizeof( uint32_t ) );
	swigStructField( "VkApplicationInfo-sType", offsetof( struct VkApplicationInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkApplicationInfo-pApplicationName", offsetof( struct VkApplicationInfo, pApplicationName ), sizeof( char const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkApplicationInfo ) );

	swigComment("VkInstanceCreateInfo\n");
	printf( "begin-structure VkInstanceCreateInfo\n" );
	swigStructField( "VkInstanceCreateInfo-enabledExtensionCount", offsetof( struct VkInstanceCreateInfo, enabledExtensionCount ), sizeof( uint32_t ) );
	swigStructField( "VkInstanceCreateInfo-pNext", offsetof( struct VkInstanceCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkInstanceCreateInfo-pApplicationInfo", offsetof( struct VkInstanceCreateInfo, pApplicationInfo ), sizeof( VkApplicationInfo const * ) );
	swigStructField( "VkInstanceCreateInfo-enabledLayerCount", offsetof( struct VkInstanceCreateInfo, enabledLayerCount ), sizeof( uint32_t ) );
	swigStructField( "VkInstanceCreateInfo-sType", offsetof( struct VkInstanceCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkInstanceCreateInfo-flags", offsetof( struct VkInstanceCreateInfo, flags ), sizeof( VkInstanceCreateFlags ) );
	swigStructField( "VkInstanceCreateInfo-ppEnabledExtensionNames", offsetof( struct VkInstanceCreateInfo, ppEnabledExtensionNames ), sizeof( char const *const * ) );
	swigStructField( "VkInstanceCreateInfo-ppEnabledLayerNames", offsetof( struct VkInstanceCreateInfo, ppEnabledLayerNames ), sizeof( char const *const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkInstanceCreateInfo ) );

	swigComment("VkAllocationCallbacks\n");
	printf( "begin-structure VkAllocationCallbacks\n" );
	swigStructField( "VkAllocationCallbacks-pfnAllocation", offsetof( struct VkAllocationCallbacks, pfnAllocation ), sizeof( PFN_vkAllocationFunction ) );
	swigStructField( "VkAllocationCallbacks-pfnReallocation", offsetof( struct VkAllocationCallbacks, pfnReallocation ), sizeof( PFN_vkReallocationFunction ) );
	swigStructField( "VkAllocationCallbacks-pfnInternalAllocation", offsetof( struct VkAllocationCallbacks, pfnInternalAllocation ), sizeof( PFN_vkInternalAllocationNotification ) );
	swigStructField( "VkAllocationCallbacks-pUserData", offsetof( struct VkAllocationCallbacks, pUserData ), sizeof( void * ) );
	swigStructField( "VkAllocationCallbacks-pfnFree", offsetof( struct VkAllocationCallbacks, pfnFree ), sizeof( PFN_vkFreeFunction ) );
	swigStructField( "VkAllocationCallbacks-pfnInternalFree", offsetof( struct VkAllocationCallbacks, pfnInternalFree ), sizeof( PFN_vkInternalFreeNotification ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkAllocationCallbacks ) );

	swigComment("VkPhysicalDeviceFeatures\n");
	printf( "begin-structure VkPhysicalDeviceFeatures\n" );
	swigStructField( "VkPhysicalDeviceFeatures-drawIndirectFirstInstance", offsetof( struct VkPhysicalDeviceFeatures, drawIndirectFirstInstance ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-shaderUniformBufferArrayDynamicIndexing", offsetof( struct VkPhysicalDeviceFeatures, shaderUniformBufferArrayDynamicIndexing ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-alphaToOne", offsetof( struct VkPhysicalDeviceFeatures, alphaToOne ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-dualSrcBlend", offsetof( struct VkPhysicalDeviceFeatures, dualSrcBlend ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-depthBiasClamp", offsetof( struct VkPhysicalDeviceFeatures, depthBiasClamp ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-shaderSampledImageArrayDynamicIndexing", offsetof( struct VkPhysicalDeviceFeatures, shaderSampledImageArrayDynamicIndexing ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-shaderStorageBufferArrayDynamicIndexing", offsetof( struct VkPhysicalDeviceFeatures, shaderStorageBufferArrayDynamicIndexing ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-shaderStorageImageArrayDynamicIndexing", offsetof( struct VkPhysicalDeviceFeatures, shaderStorageImageArrayDynamicIndexing ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-imageCubeArray", offsetof( struct VkPhysicalDeviceFeatures, imageCubeArray ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-shaderResourceResidency", offsetof( struct VkPhysicalDeviceFeatures, shaderResourceResidency ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-fillModeNonSolid", offsetof( struct VkPhysicalDeviceFeatures, fillModeNonSolid ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-textureCompressionBC", offsetof( struct VkPhysicalDeviceFeatures, textureCompressionBC ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-textureCompressionETC2", offsetof( struct VkPhysicalDeviceFeatures, textureCompressionETC2 ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-shaderImageGatherExtended", offsetof( struct VkPhysicalDeviceFeatures, shaderImageGatherExtended ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-robustBufferAccess", offsetof( struct VkPhysicalDeviceFeatures, robustBufferAccess ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-multiViewport", offsetof( struct VkPhysicalDeviceFeatures, multiViewport ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-independentBlend", offsetof( struct VkPhysicalDeviceFeatures, independentBlend ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-sparseResidencyAliased", offsetof( struct VkPhysicalDeviceFeatures, sparseResidencyAliased ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-fullDrawIndexUint32", offsetof( struct VkPhysicalDeviceFeatures, fullDrawIndexUint32 ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-fragmentStoresAndAtomics", offsetof( struct VkPhysicalDeviceFeatures, fragmentStoresAndAtomics ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-vertexPipelineStoresAndAtomics", offsetof( struct VkPhysicalDeviceFeatures, vertexPipelineStoresAndAtomics ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-textureCompressionASTC_LDR", offsetof( struct VkPhysicalDeviceFeatures, textureCompressionASTC_LDR ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-sparseBinding", offsetof( struct VkPhysicalDeviceFeatures, sparseBinding ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-tessellationShader", offsetof( struct VkPhysicalDeviceFeatures, tessellationShader ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-pipelineStatisticsQuery", offsetof( struct VkPhysicalDeviceFeatures, pipelineStatisticsQuery ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-shaderStorageImageMultisample", offsetof( struct VkPhysicalDeviceFeatures, shaderStorageImageMultisample ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-depthClamp", offsetof( struct VkPhysicalDeviceFeatures, depthClamp ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-shaderResourceMinLod", offsetof( struct VkPhysicalDeviceFeatures, shaderResourceMinLod ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-shaderInt16", offsetof( struct VkPhysicalDeviceFeatures, shaderInt16 ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-variableMultisampleRate", offsetof( struct VkPhysicalDeviceFeatures, variableMultisampleRate ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-sparseResidencyBuffer", offsetof( struct VkPhysicalDeviceFeatures, sparseResidencyBuffer ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-samplerAnisotropy", offsetof( struct VkPhysicalDeviceFeatures, samplerAnisotropy ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-shaderFloat64", offsetof( struct VkPhysicalDeviceFeatures, shaderFloat64 ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-geometryShader", offsetof( struct VkPhysicalDeviceFeatures, geometryShader ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-shaderClipDistance", offsetof( struct VkPhysicalDeviceFeatures, shaderClipDistance ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-shaderCullDistance", offsetof( struct VkPhysicalDeviceFeatures, shaderCullDistance ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-shaderInt64", offsetof( struct VkPhysicalDeviceFeatures, shaderInt64 ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-inheritedQueries", offsetof( struct VkPhysicalDeviceFeatures, inheritedQueries ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-depthBounds", offsetof( struct VkPhysicalDeviceFeatures, depthBounds ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-sparseResidencyImage3D", offsetof( struct VkPhysicalDeviceFeatures, sparseResidencyImage3D ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-logicOp", offsetof( struct VkPhysicalDeviceFeatures, logicOp ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-shaderStorageImageWriteWithoutFormat", offsetof( struct VkPhysicalDeviceFeatures, shaderStorageImageWriteWithoutFormat ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-shaderStorageImageReadWithoutFormat", offsetof( struct VkPhysicalDeviceFeatures, shaderStorageImageReadWithoutFormat ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-occlusionQueryPrecise", offsetof( struct VkPhysicalDeviceFeatures, occlusionQueryPrecise ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-shaderStorageImageExtendedFormats", offsetof( struct VkPhysicalDeviceFeatures, shaderStorageImageExtendedFormats ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-shaderTessellationAndGeometryPointSize", offsetof( struct VkPhysicalDeviceFeatures, shaderTessellationAndGeometryPointSize ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-sparseResidency2Samples", offsetof( struct VkPhysicalDeviceFeatures, sparseResidency2Samples ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-sparseResidency4Samples", offsetof( struct VkPhysicalDeviceFeatures, sparseResidency4Samples ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-sparseResidency8Samples", offsetof( struct VkPhysicalDeviceFeatures, sparseResidency8Samples ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-sparseResidency16Samples", offsetof( struct VkPhysicalDeviceFeatures, sparseResidency16Samples ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-wideLines", offsetof( struct VkPhysicalDeviceFeatures, wideLines ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-sampleRateShading", offsetof( struct VkPhysicalDeviceFeatures, sampleRateShading ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-sparseResidencyImage2D", offsetof( struct VkPhysicalDeviceFeatures, sparseResidencyImage2D ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-largePoints", offsetof( struct VkPhysicalDeviceFeatures, largePoints ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceFeatures-multiDrawIndirect", offsetof( struct VkPhysicalDeviceFeatures, multiDrawIndirect ), sizeof( VkBool32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceFeatures ) );

	swigComment("VkFormatProperties\n");
	printf( "begin-structure VkFormatProperties\n" );
	swigStructField( "VkFormatProperties-linearTilingFeatures", offsetof( struct VkFormatProperties, linearTilingFeatures ), sizeof( VkFormatFeatureFlags ) );
	swigStructField( "VkFormatProperties-optimalTilingFeatures", offsetof( struct VkFormatProperties, optimalTilingFeatures ), sizeof( VkFormatFeatureFlags ) );
	swigStructField( "VkFormatProperties-bufferFeatures", offsetof( struct VkFormatProperties, bufferFeatures ), sizeof( VkFormatFeatureFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkFormatProperties ) );

	swigComment("VkExtent3D\n");
	printf( "begin-structure VkExtent3D\n" );
	swigStructField( "VkExtent3D-height", offsetof( struct VkExtent3D, height ), sizeof( uint32_t ) );
	swigStructField( "VkExtent3D-width", offsetof( struct VkExtent3D, width ), sizeof( uint32_t ) );
	swigStructField( "VkExtent3D-depth", offsetof( struct VkExtent3D, depth ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkExtent3D ) );

	swigComment("VkImageFormatProperties\n");
	printf( "begin-structure VkImageFormatProperties\n" );
	swigStructField( "VkImageFormatProperties-maxMipLevels", offsetof( struct VkImageFormatProperties, maxMipLevels ), sizeof( uint32_t ) );
	swigStructField( "VkImageFormatProperties-sampleCounts", offsetof( struct VkImageFormatProperties, sampleCounts ), sizeof( VkSampleCountFlags ) );
	swigStructField( "VkImageFormatProperties-maxArrayLayers", offsetof( struct VkImageFormatProperties, maxArrayLayers ), sizeof( uint32_t ) );
	swigStructField( "VkImageFormatProperties-maxResourceSize", offsetof( struct VkImageFormatProperties, maxResourceSize ), sizeof( VkDeviceSize ) );
	swigStructField( "VkImageFormatProperties-maxExtent", offsetof( struct VkImageFormatProperties, maxExtent ), sizeof( VkExtent3D ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkImageFormatProperties ) );

	swigComment("VkPhysicalDeviceLimits\n");
	printf( "begin-structure VkPhysicalDeviceLimits\n" );
	swigStructField( "VkPhysicalDeviceLimits-discreteQueuePriorities", offsetof( struct VkPhysicalDeviceLimits, discreteQueuePriorities ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxVertexInputAttributeOffset", offsetof( struct VkPhysicalDeviceLimits, maxVertexInputAttributeOffset ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxSamplerAnisotropy", offsetof( struct VkPhysicalDeviceLimits, maxSamplerAnisotropy ), sizeof( float ) );
	swigStructField( "VkPhysicalDeviceLimits-maxComputeWorkGroupInvocations", offsetof( struct VkPhysicalDeviceLimits, maxComputeWorkGroupInvocations ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxGeometryShaderInvocations", offsetof( struct VkPhysicalDeviceLimits, maxGeometryShaderInvocations ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-standardSampleLocations", offsetof( struct VkPhysicalDeviceLimits, standardSampleLocations ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceLimits-maxBoundDescriptorSets", offsetof( struct VkPhysicalDeviceLimits, maxBoundDescriptorSets ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxFragmentCombinedOutputResources", offsetof( struct VkPhysicalDeviceLimits, maxFragmentCombinedOutputResources ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxPerStageResources", offsetof( struct VkPhysicalDeviceLimits, maxPerStageResources ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxDescriptorSetUniformBuffersDynamic", offsetof( struct VkPhysicalDeviceLimits, maxDescriptorSetUniformBuffersDynamic ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxDescriptorSetStorageBuffersDynamic", offsetof( struct VkPhysicalDeviceLimits, maxDescriptorSetStorageBuffersDynamic ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxFragmentDualSrcAttachments", offsetof( struct VkPhysicalDeviceLimits, maxFragmentDualSrcAttachments ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxFragmentOutputAttachments", offsetof( struct VkPhysicalDeviceLimits, maxFragmentOutputAttachments ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxPerStageDescriptorInputAttachments", offsetof( struct VkPhysicalDeviceLimits, maxPerStageDescriptorInputAttachments ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxDescriptorSetInputAttachments", offsetof( struct VkPhysicalDeviceLimits, maxDescriptorSetInputAttachments ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxColorAttachments", offsetof( struct VkPhysicalDeviceLimits, maxColorAttachments ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-lineWidthRange", offsetof( struct VkPhysicalDeviceLimits, lineWidthRange ), sizeof( float [2] ) );
	swigStructField( "VkPhysicalDeviceLimits-maxComputeWorkGroupSize", offsetof( struct VkPhysicalDeviceLimits, maxComputeWorkGroupSize ), sizeof( uint32_t [3] ) );
	swigStructField( "VkPhysicalDeviceLimits-strictLines", offsetof( struct VkPhysicalDeviceLimits, strictLines ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceLimits-pointSizeRange", offsetof( struct VkPhysicalDeviceLimits, pointSizeRange ), sizeof( float [2] ) );
	swigStructField( "VkPhysicalDeviceLimits-maxImageArrayLayers", offsetof( struct VkPhysicalDeviceLimits, maxImageArrayLayers ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-viewportBoundsRange", offsetof( struct VkPhysicalDeviceLimits, viewportBoundsRange ), sizeof( float [2] ) );
	swigStructField( "VkPhysicalDeviceLimits-maxDrawIndirectCount", offsetof( struct VkPhysicalDeviceLimits, maxDrawIndirectCount ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxComputeSharedMemorySize", offsetof( struct VkPhysicalDeviceLimits, maxComputeSharedMemorySize ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-timestampComputeAndGraphics", offsetof( struct VkPhysicalDeviceLimits, timestampComputeAndGraphics ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceLimits-maxSamplerLodBias", offsetof( struct VkPhysicalDeviceLimits, maxSamplerLodBias ), sizeof( float ) );
	swigStructField( "VkPhysicalDeviceLimits-sparseAddressSpaceSize", offsetof( struct VkPhysicalDeviceLimits, sparseAddressSpaceSize ), sizeof( VkDeviceSize ) );
	swigStructField( "VkPhysicalDeviceLimits-maxTessellationPatchSize", offsetof( struct VkPhysicalDeviceLimits, maxTessellationPatchSize ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxImageDimensionCube", offsetof( struct VkPhysicalDeviceLimits, maxImageDimensionCube ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-framebufferColorSampleCounts", offsetof( struct VkPhysicalDeviceLimits, framebufferColorSampleCounts ), sizeof( VkSampleCountFlags ) );
	swigStructField( "VkPhysicalDeviceLimits-framebufferDepthSampleCounts", offsetof( struct VkPhysicalDeviceLimits, framebufferDepthSampleCounts ), sizeof( VkSampleCountFlags ) );
	swigStructField( "VkPhysicalDeviceLimits-framebufferStencilSampleCounts", offsetof( struct VkPhysicalDeviceLimits, framebufferStencilSampleCounts ), sizeof( VkSampleCountFlags ) );
	swigStructField( "VkPhysicalDeviceLimits-framebufferNoAttachmentsSampleCounts", offsetof( struct VkPhysicalDeviceLimits, framebufferNoAttachmentsSampleCounts ), sizeof( VkSampleCountFlags ) );
	swigStructField( "VkPhysicalDeviceLimits-sampledImageColorSampleCounts", offsetof( struct VkPhysicalDeviceLimits, sampledImageColorSampleCounts ), sizeof( VkSampleCountFlags ) );
	swigStructField( "VkPhysicalDeviceLimits-sampledImageIntegerSampleCounts", offsetof( struct VkPhysicalDeviceLimits, sampledImageIntegerSampleCounts ), sizeof( VkSampleCountFlags ) );
	swigStructField( "VkPhysicalDeviceLimits-sampledImageDepthSampleCounts", offsetof( struct VkPhysicalDeviceLimits, sampledImageDepthSampleCounts ), sizeof( VkSampleCountFlags ) );
	swigStructField( "VkPhysicalDeviceLimits-sampledImageStencilSampleCounts", offsetof( struct VkPhysicalDeviceLimits, sampledImageStencilSampleCounts ), sizeof( VkSampleCountFlags ) );
	swigStructField( "VkPhysicalDeviceLimits-storageImageSampleCounts", offsetof( struct VkPhysicalDeviceLimits, storageImageSampleCounts ), sizeof( VkSampleCountFlags ) );
	swigStructField( "VkPhysicalDeviceLimits-maxViewportDimensions", offsetof( struct VkPhysicalDeviceLimits, maxViewportDimensions ), sizeof( uint32_t [2] ) );
	swigStructField( "VkPhysicalDeviceLimits-maxImageDimension3D", offsetof( struct VkPhysicalDeviceLimits, maxImageDimension3D ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxTexelGatherOffset", offsetof( struct VkPhysicalDeviceLimits, maxTexelGatherOffset ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-minTexelGatherOffset", offsetof( struct VkPhysicalDeviceLimits, minTexelGatherOffset ), sizeof( int32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxTexelOffset", offsetof( struct VkPhysicalDeviceLimits, maxTexelOffset ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-minTexelOffset", offsetof( struct VkPhysicalDeviceLimits, minTexelOffset ), sizeof( int32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxSamplerAllocationCount", offsetof( struct VkPhysicalDeviceLimits, maxSamplerAllocationCount ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxMemoryAllocationCount", offsetof( struct VkPhysicalDeviceLimits, maxMemoryAllocationCount ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-minInterpolationOffset", offsetof( struct VkPhysicalDeviceLimits, minInterpolationOffset ), sizeof( float ) );
	swigStructField( "VkPhysicalDeviceLimits-maxInterpolationOffset", offsetof( struct VkPhysicalDeviceLimits, maxInterpolationOffset ), sizeof( float ) );
	swigStructField( "VkPhysicalDeviceLimits-maxFragmentInputComponents", offsetof( struct VkPhysicalDeviceLimits, maxFragmentInputComponents ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxGeometryTotalOutputComponents", offsetof( struct VkPhysicalDeviceLimits, maxGeometryTotalOutputComponents ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxGeometryOutputComponents", offsetof( struct VkPhysicalDeviceLimits, maxGeometryOutputComponents ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxGeometryInputComponents", offsetof( struct VkPhysicalDeviceLimits, maxGeometryInputComponents ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxTessellationEvaluationOutputComponents", offsetof( struct VkPhysicalDeviceLimits, maxTessellationEvaluationOutputComponents ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxTessellationEvaluationInputComponents", offsetof( struct VkPhysicalDeviceLimits, maxTessellationEvaluationInputComponents ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxTessellationControlTotalOutputComponents", offsetof( struct VkPhysicalDeviceLimits, maxTessellationControlTotalOutputComponents ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxTessellationControlPerPatchOutputComponents", offsetof( struct VkPhysicalDeviceLimits, maxTessellationControlPerPatchOutputComponents ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxTessellationControlPerVertexOutputComponents", offsetof( struct VkPhysicalDeviceLimits, maxTessellationControlPerVertexOutputComponents ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxTessellationControlPerVertexInputComponents", offsetof( struct VkPhysicalDeviceLimits, maxTessellationControlPerVertexInputComponents ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxVertexInputBindingStride", offsetof( struct VkPhysicalDeviceLimits, maxVertexInputBindingStride ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxVertexOutputComponents", offsetof( struct VkPhysicalDeviceLimits, maxVertexOutputComponents ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxVertexInputAttributes", offsetof( struct VkPhysicalDeviceLimits, maxVertexInputAttributes ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-viewportSubPixelBits", offsetof( struct VkPhysicalDeviceLimits, viewportSubPixelBits ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxFramebufferWidth", offsetof( struct VkPhysicalDeviceLimits, maxFramebufferWidth ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxPerStageDescriptorStorageImages", offsetof( struct VkPhysicalDeviceLimits, maxPerStageDescriptorStorageImages ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxDescriptorSetStorageImages", offsetof( struct VkPhysicalDeviceLimits, maxDescriptorSetStorageImages ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-mipmapPrecisionBits", offsetof( struct VkPhysicalDeviceLimits, mipmapPrecisionBits ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-subTexelPrecisionBits", offsetof( struct VkPhysicalDeviceLimits, subTexelPrecisionBits ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-subPixelPrecisionBits", offsetof( struct VkPhysicalDeviceLimits, subPixelPrecisionBits ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxPushConstantsSize", offsetof( struct VkPhysicalDeviceLimits, maxPushConstantsSize ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxImageDimension1D", offsetof( struct VkPhysicalDeviceLimits, maxImageDimension1D ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-timestampPeriod", offsetof( struct VkPhysicalDeviceLimits, timestampPeriod ), sizeof( float ) );
	swigStructField( "VkPhysicalDeviceLimits-maxFramebufferLayers", offsetof( struct VkPhysicalDeviceLimits, maxFramebufferLayers ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-nonCoherentAtomSize", offsetof( struct VkPhysicalDeviceLimits, nonCoherentAtomSize ), sizeof( VkDeviceSize ) );
	swigStructField( "VkPhysicalDeviceLimits-maxComputeWorkGroupCount", offsetof( struct VkPhysicalDeviceLimits, maxComputeWorkGroupCount ), sizeof( uint32_t [3] ) );
	swigStructField( "VkPhysicalDeviceLimits-maxPerStageDescriptorUniformBuffers", offsetof( struct VkPhysicalDeviceLimits, maxPerStageDescriptorUniformBuffers ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxPerStageDescriptorStorageBuffers", offsetof( struct VkPhysicalDeviceLimits, maxPerStageDescriptorStorageBuffers ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxDescriptorSetUniformBuffers", offsetof( struct VkPhysicalDeviceLimits, maxDescriptorSetUniformBuffers ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxDescriptorSetStorageBuffers", offsetof( struct VkPhysicalDeviceLimits, maxDescriptorSetStorageBuffers ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-subPixelInterpolationOffsetBits", offsetof( struct VkPhysicalDeviceLimits, subPixelInterpolationOffsetBits ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxPerStageDescriptorSamplers", offsetof( struct VkPhysicalDeviceLimits, maxPerStageDescriptorSamplers ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxDescriptorSetSamplers", offsetof( struct VkPhysicalDeviceLimits, maxDescriptorSetSamplers ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxTessellationGenerationLevel", offsetof( struct VkPhysicalDeviceLimits, maxTessellationGenerationLevel ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxFramebufferHeight", offsetof( struct VkPhysicalDeviceLimits, maxFramebufferHeight ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxSampleMaskWords", offsetof( struct VkPhysicalDeviceLimits, maxSampleMaskWords ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-minStorageBufferOffsetAlignment", offsetof( struct VkPhysicalDeviceLimits, minStorageBufferOffsetAlignment ), sizeof( VkDeviceSize ) );
	swigStructField( "VkPhysicalDeviceLimits-minUniformBufferOffsetAlignment", offsetof( struct VkPhysicalDeviceLimits, minUniformBufferOffsetAlignment ), sizeof( VkDeviceSize ) );
	swigStructField( "VkPhysicalDeviceLimits-minTexelBufferOffsetAlignment", offsetof( struct VkPhysicalDeviceLimits, minTexelBufferOffsetAlignment ), sizeof( VkDeviceSize ) );
	swigStructField( "VkPhysicalDeviceLimits-minMemoryMapAlignment", offsetof( struct VkPhysicalDeviceLimits, minMemoryMapAlignment ), sizeof( size_t ) );
	swigStructField( "VkPhysicalDeviceLimits-optimalBufferCopyOffsetAlignment", offsetof( struct VkPhysicalDeviceLimits, optimalBufferCopyOffsetAlignment ), sizeof( VkDeviceSize ) );
	swigStructField( "VkPhysicalDeviceLimits-optimalBufferCopyRowPitchAlignment", offsetof( struct VkPhysicalDeviceLimits, optimalBufferCopyRowPitchAlignment ), sizeof( VkDeviceSize ) );
	swigStructField( "VkPhysicalDeviceLimits-bufferImageGranularity", offsetof( struct VkPhysicalDeviceLimits, bufferImageGranularity ), sizeof( VkDeviceSize ) );
	swigStructField( "VkPhysicalDeviceLimits-pointSizeGranularity", offsetof( struct VkPhysicalDeviceLimits, pointSizeGranularity ), sizeof( float ) );
	swigStructField( "VkPhysicalDeviceLimits-lineWidthGranularity", offsetof( struct VkPhysicalDeviceLimits, lineWidthGranularity ), sizeof( float ) );
	swigStructField( "VkPhysicalDeviceLimits-maxPerStageDescriptorSampledImages", offsetof( struct VkPhysicalDeviceLimits, maxPerStageDescriptorSampledImages ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxDescriptorSetSampledImages", offsetof( struct VkPhysicalDeviceLimits, maxDescriptorSetSampledImages ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxViewports", offsetof( struct VkPhysicalDeviceLimits, maxViewports ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxTexelBufferElements", offsetof( struct VkPhysicalDeviceLimits, maxTexelBufferElements ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxVertexInputBindings", offsetof( struct VkPhysicalDeviceLimits, maxVertexInputBindings ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxGeometryOutputVertices", offsetof( struct VkPhysicalDeviceLimits, maxGeometryOutputVertices ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxClipDistances", offsetof( struct VkPhysicalDeviceLimits, maxClipDistances ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxCullDistances", offsetof( struct VkPhysicalDeviceLimits, maxCullDistances ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxCombinedClipAndCullDistances", offsetof( struct VkPhysicalDeviceLimits, maxCombinedClipAndCullDistances ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxStorageBufferRange", offsetof( struct VkPhysicalDeviceLimits, maxStorageBufferRange ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxUniformBufferRange", offsetof( struct VkPhysicalDeviceLimits, maxUniformBufferRange ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxImageDimension2D", offsetof( struct VkPhysicalDeviceLimits, maxImageDimension2D ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceLimits-maxDrawIndexedIndexValue", offsetof( struct VkPhysicalDeviceLimits, maxDrawIndexedIndexValue ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceLimits ) );

	swigComment("VkPhysicalDeviceSparseProperties\n");
	printf( "begin-structure VkPhysicalDeviceSparseProperties\n" );
	swigStructField( "VkPhysicalDeviceSparseProperties-residencyNonResidentStrict", offsetof( struct VkPhysicalDeviceSparseProperties, residencyNonResidentStrict ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceSparseProperties-residencyStandard2DBlockShape", offsetof( struct VkPhysicalDeviceSparseProperties, residencyStandard2DBlockShape ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceSparseProperties-residencyStandard2DMultisampleBlockShape", offsetof( struct VkPhysicalDeviceSparseProperties, residencyStandard2DMultisampleBlockShape ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceSparseProperties-residencyStandard3DBlockShape", offsetof( struct VkPhysicalDeviceSparseProperties, residencyStandard3DBlockShape ), sizeof( VkBool32 ) );
	swigStructField( "VkPhysicalDeviceSparseProperties-residencyAlignedMipSize", offsetof( struct VkPhysicalDeviceSparseProperties, residencyAlignedMipSize ), sizeof( VkBool32 ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceSparseProperties ) );

	swigComment("VkPhysicalDeviceProperties\n");
	printf( "begin-structure VkPhysicalDeviceProperties\n" );
	swigStructField( "VkPhysicalDeviceProperties-vendorID", offsetof( struct VkPhysicalDeviceProperties, vendorID ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceProperties-deviceName", offsetof( struct VkPhysicalDeviceProperties, deviceName ), sizeof( char [256] ) );
	swigStructField( "VkPhysicalDeviceProperties-apiVersion", offsetof( struct VkPhysicalDeviceProperties, apiVersion ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceProperties-driverVersion", offsetof( struct VkPhysicalDeviceProperties, driverVersion ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceProperties-sparseProperties", offsetof( struct VkPhysicalDeviceProperties, sparseProperties ), sizeof( VkPhysicalDeviceSparseProperties ) );
	swigStructField( "VkPhysicalDeviceProperties-deviceType", offsetof( struct VkPhysicalDeviceProperties, deviceType ), sizeof( VkPhysicalDeviceType ) );
	swigStructField( "VkPhysicalDeviceProperties-deviceID", offsetof( struct VkPhysicalDeviceProperties, deviceID ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceProperties-pipelineCacheUUID", offsetof( struct VkPhysicalDeviceProperties, pipelineCacheUUID ), sizeof( uint8_t [16] ) );
	swigStructField( "VkPhysicalDeviceProperties-limits", offsetof( struct VkPhysicalDeviceProperties, limits ), sizeof( VkPhysicalDeviceLimits ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceProperties ) );

	swigComment("VkQueueFamilyProperties\n");
	printf( "begin-structure VkQueueFamilyProperties\n" );
	swigStructField( "VkQueueFamilyProperties-timestampValidBits", offsetof( struct VkQueueFamilyProperties, timestampValidBits ), sizeof( uint32_t ) );
	swigStructField( "VkQueueFamilyProperties-queueCount", offsetof( struct VkQueueFamilyProperties, queueCount ), sizeof( uint32_t ) );
	swigStructField( "VkQueueFamilyProperties-minImageTransferGranularity", offsetof( struct VkQueueFamilyProperties, minImageTransferGranularity ), sizeof( VkExtent3D ) );
	swigStructField( "VkQueueFamilyProperties-queueFlags", offsetof( struct VkQueueFamilyProperties, queueFlags ), sizeof( VkQueueFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkQueueFamilyProperties ) );

	swigComment("VkMemoryType\n");
	printf( "begin-structure VkMemoryType\n" );
	swigStructField( "VkMemoryType-heapIndex", offsetof( struct VkMemoryType, heapIndex ), sizeof( uint32_t ) );
	swigStructField( "VkMemoryType-propertyFlags", offsetof( struct VkMemoryType, propertyFlags ), sizeof( VkMemoryPropertyFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkMemoryType ) );

	swigComment("VkMemoryHeap\n");
	printf( "begin-structure VkMemoryHeap\n" );
	swigStructField( "VkMemoryHeap-size", offsetof( struct VkMemoryHeap, size ), sizeof( VkDeviceSize ) );
	swigStructField( "VkMemoryHeap-flags", offsetof( struct VkMemoryHeap, flags ), sizeof( VkMemoryHeapFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkMemoryHeap ) );

	swigComment("VkPhysicalDeviceMemoryProperties\n");
	printf( "begin-structure VkPhysicalDeviceMemoryProperties\n" );
	swigStructField( "VkPhysicalDeviceMemoryProperties-memoryHeaps", offsetof( struct VkPhysicalDeviceMemoryProperties, memoryHeaps ), sizeof( VkMemoryHeap [16] ) );
	swigStructField( "VkPhysicalDeviceMemoryProperties-memoryTypeCount", offsetof( struct VkPhysicalDeviceMemoryProperties, memoryTypeCount ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceMemoryProperties-memoryHeapCount", offsetof( struct VkPhysicalDeviceMemoryProperties, memoryHeapCount ), sizeof( uint32_t ) );
	swigStructField( "VkPhysicalDeviceMemoryProperties-memoryTypes", offsetof( struct VkPhysicalDeviceMemoryProperties, memoryTypes ), sizeof( VkMemoryType [32] ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPhysicalDeviceMemoryProperties ) );

	swigComment("VkDeviceQueueCreateInfo\n");
	printf( "begin-structure VkDeviceQueueCreateInfo\n" );
	swigStructField( "VkDeviceQueueCreateInfo-pNext", offsetof( struct VkDeviceQueueCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkDeviceQueueCreateInfo-queueFamilyIndex", offsetof( struct VkDeviceQueueCreateInfo, queueFamilyIndex ), sizeof( uint32_t ) );
	swigStructField( "VkDeviceQueueCreateInfo-queueCount", offsetof( struct VkDeviceQueueCreateInfo, queueCount ), sizeof( uint32_t ) );
	swigStructField( "VkDeviceQueueCreateInfo-sType", offsetof( struct VkDeviceQueueCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkDeviceQueueCreateInfo-flags", offsetof( struct VkDeviceQueueCreateInfo, flags ), sizeof( VkDeviceQueueCreateFlags ) );
	swigStructField( "VkDeviceQueueCreateInfo-pQueuePriorities", offsetof( struct VkDeviceQueueCreateInfo, pQueuePriorities ), sizeof( float const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDeviceQueueCreateInfo ) );

	swigComment("VkDeviceCreateInfo\n");
	printf( "begin-structure VkDeviceCreateInfo\n" );
	swigStructField( "VkDeviceCreateInfo-pQueueCreateInfos", offsetof( struct VkDeviceCreateInfo, pQueueCreateInfos ), sizeof( VkDeviceQueueCreateInfo const * ) );
	swigStructField( "VkDeviceCreateInfo-enabledExtensionCount", offsetof( struct VkDeviceCreateInfo, enabledExtensionCount ), sizeof( uint32_t ) );
	swigStructField( "VkDeviceCreateInfo-pEnabledFeatures", offsetof( struct VkDeviceCreateInfo, pEnabledFeatures ), sizeof( VkPhysicalDeviceFeatures const * ) );
	swigStructField( "VkDeviceCreateInfo-pNext", offsetof( struct VkDeviceCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkDeviceCreateInfo-enabledLayerCount", offsetof( struct VkDeviceCreateInfo, enabledLayerCount ), sizeof( uint32_t ) );
	swigStructField( "VkDeviceCreateInfo-queueCreateInfoCount", offsetof( struct VkDeviceCreateInfo, queueCreateInfoCount ), sizeof( uint32_t ) );
	swigStructField( "VkDeviceCreateInfo-sType", offsetof( struct VkDeviceCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkDeviceCreateInfo-flags", offsetof( struct VkDeviceCreateInfo, flags ), sizeof( VkDeviceCreateFlags ) );
	swigStructField( "VkDeviceCreateInfo-ppEnabledExtensionNames", offsetof( struct VkDeviceCreateInfo, ppEnabledExtensionNames ), sizeof( char const *const * ) );
	swigStructField( "VkDeviceCreateInfo-ppEnabledLayerNames", offsetof( struct VkDeviceCreateInfo, ppEnabledLayerNames ), sizeof( char const *const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDeviceCreateInfo ) );

	swigComment("VkExtensionProperties\n");
	printf( "begin-structure VkExtensionProperties\n" );
	swigStructField( "VkExtensionProperties-specVersion", offsetof( struct VkExtensionProperties, specVersion ), sizeof( uint32_t ) );
	swigStructField( "VkExtensionProperties-extensionName", offsetof( struct VkExtensionProperties, extensionName ), sizeof( char [256] ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkExtensionProperties ) );

	swigComment("VkLayerProperties\n");
	printf( "begin-structure VkLayerProperties\n" );
	swigStructField( "VkLayerProperties-layerName", offsetof( struct VkLayerProperties, layerName ), sizeof( char [256] ) );
	swigStructField( "VkLayerProperties-specVersion", offsetof( struct VkLayerProperties, specVersion ), sizeof( uint32_t ) );
	swigStructField( "VkLayerProperties-implementationVersion", offsetof( struct VkLayerProperties, implementationVersion ), sizeof( uint32_t ) );
	swigStructField( "VkLayerProperties-description", offsetof( struct VkLayerProperties, description ), sizeof( char [256] ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkLayerProperties ) );

	swigComment("VkSubmitInfo\n");
	printf( "begin-structure VkSubmitInfo\n" );
	swigStructField( "VkSubmitInfo-pNext", offsetof( struct VkSubmitInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkSubmitInfo-commandBufferCount", offsetof( struct VkSubmitInfo, commandBufferCount ), sizeof( uint32_t ) );
	swigStructField( "VkSubmitInfo-pWaitDstStageMask", offsetof( struct VkSubmitInfo, pWaitDstStageMask ), sizeof( VkPipelineStageFlags const * ) );
	swigStructField( "VkSubmitInfo-pCommandBuffers", offsetof( struct VkSubmitInfo, pCommandBuffers ), sizeof( VkCommandBuffer const * ) );
	swigStructField( "VkSubmitInfo-waitSemaphoreCount", offsetof( struct VkSubmitInfo, waitSemaphoreCount ), sizeof( uint32_t ) );
	swigStructField( "VkSubmitInfo-pWaitSemaphores", offsetof( struct VkSubmitInfo, pWaitSemaphores ), sizeof( VkSemaphore const * ) );
	swigStructField( "VkSubmitInfo-signalSemaphoreCount", offsetof( struct VkSubmitInfo, signalSemaphoreCount ), sizeof( uint32_t ) );
	swigStructField( "VkSubmitInfo-pSignalSemaphores", offsetof( struct VkSubmitInfo, pSignalSemaphores ), sizeof( VkSemaphore const * ) );
	swigStructField( "VkSubmitInfo-sType", offsetof( struct VkSubmitInfo, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSubmitInfo ) );

	swigComment("VkMemoryAllocateInfo\n");
	printf( "begin-structure VkMemoryAllocateInfo\n" );
	swigStructField( "VkMemoryAllocateInfo-pNext", offsetof( struct VkMemoryAllocateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkMemoryAllocateInfo-allocationSize", offsetof( struct VkMemoryAllocateInfo, allocationSize ), sizeof( VkDeviceSize ) );
	swigStructField( "VkMemoryAllocateInfo-memoryTypeIndex", offsetof( struct VkMemoryAllocateInfo, memoryTypeIndex ), sizeof( uint32_t ) );
	swigStructField( "VkMemoryAllocateInfo-sType", offsetof( struct VkMemoryAllocateInfo, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkMemoryAllocateInfo ) );

	swigComment("VkMappedMemoryRange\n");
	printf( "begin-structure VkMappedMemoryRange\n" );
	swigStructField( "VkMappedMemoryRange-pNext", offsetof( struct VkMappedMemoryRange, pNext ), sizeof( void const * ) );
	swigStructField( "VkMappedMemoryRange-memory", offsetof( struct VkMappedMemoryRange, memory ), sizeof( VkDeviceMemory ) );
	swigStructField( "VkMappedMemoryRange-offset", offsetof( struct VkMappedMemoryRange, offset ), sizeof( VkDeviceSize ) );
	swigStructField( "VkMappedMemoryRange-size", offsetof( struct VkMappedMemoryRange, size ), sizeof( VkDeviceSize ) );
	swigStructField( "VkMappedMemoryRange-sType", offsetof( struct VkMappedMemoryRange, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkMappedMemoryRange ) );

	swigComment("VkMemoryRequirements\n");
	printf( "begin-structure VkMemoryRequirements\n" );
	swigStructField( "VkMemoryRequirements-memoryTypeBits", offsetof( struct VkMemoryRequirements, memoryTypeBits ), sizeof( uint32_t ) );
	swigStructField( "VkMemoryRequirements-size", offsetof( struct VkMemoryRequirements, size ), sizeof( VkDeviceSize ) );
	swigStructField( "VkMemoryRequirements-alignment", offsetof( struct VkMemoryRequirements, alignment ), sizeof( VkDeviceSize ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkMemoryRequirements ) );

	swigComment("VkSparseImageFormatProperties\n");
	printf( "begin-structure VkSparseImageFormatProperties\n" );
	swigStructField( "VkSparseImageFormatProperties-imageGranularity", offsetof( struct VkSparseImageFormatProperties, imageGranularity ), sizeof( VkExtent3D ) );
	swigStructField( "VkSparseImageFormatProperties-flags", offsetof( struct VkSparseImageFormatProperties, flags ), sizeof( VkSparseImageFormatFlags ) );
	swigStructField( "VkSparseImageFormatProperties-aspectMask", offsetof( struct VkSparseImageFormatProperties, aspectMask ), sizeof( VkImageAspectFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSparseImageFormatProperties ) );

	swigComment("VkSparseImageMemoryRequirements\n");
	printf( "begin-structure VkSparseImageMemoryRequirements\n" );
	swigStructField( "VkSparseImageMemoryRequirements-imageMipTailSize", offsetof( struct VkSparseImageMemoryRequirements, imageMipTailSize ), sizeof( VkDeviceSize ) );
	swigStructField( "VkSparseImageMemoryRequirements-imageMipTailOffset", offsetof( struct VkSparseImageMemoryRequirements, imageMipTailOffset ), sizeof( VkDeviceSize ) );
	swigStructField( "VkSparseImageMemoryRequirements-formatProperties", offsetof( struct VkSparseImageMemoryRequirements, formatProperties ), sizeof( VkSparseImageFormatProperties ) );
	swigStructField( "VkSparseImageMemoryRequirements-imageMipTailStride", offsetof( struct VkSparseImageMemoryRequirements, imageMipTailStride ), sizeof( VkDeviceSize ) );
	swigStructField( "VkSparseImageMemoryRequirements-imageMipTailFirstLod", offsetof( struct VkSparseImageMemoryRequirements, imageMipTailFirstLod ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSparseImageMemoryRequirements ) );

	swigComment("VkSparseMemoryBind\n");
	printf( "begin-structure VkSparseMemoryBind\n" );
	swigStructField( "VkSparseMemoryBind-memory", offsetof( struct VkSparseMemoryBind, memory ), sizeof( VkDeviceMemory ) );
	swigStructField( "VkSparseMemoryBind-resourceOffset", offsetof( struct VkSparseMemoryBind, resourceOffset ), sizeof( VkDeviceSize ) );
	swigStructField( "VkSparseMemoryBind-memoryOffset", offsetof( struct VkSparseMemoryBind, memoryOffset ), sizeof( VkDeviceSize ) );
	swigStructField( "VkSparseMemoryBind-size", offsetof( struct VkSparseMemoryBind, size ), sizeof( VkDeviceSize ) );
	swigStructField( "VkSparseMemoryBind-flags", offsetof( struct VkSparseMemoryBind, flags ), sizeof( VkSparseMemoryBindFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSparseMemoryBind ) );

	swigComment("VkSparseBufferMemoryBindInfo\n");
	printf( "begin-structure VkSparseBufferMemoryBindInfo\n" );
	swigStructField( "VkSparseBufferMemoryBindInfo-buffer", offsetof( struct VkSparseBufferMemoryBindInfo, buffer ), sizeof( VkBuffer ) );
	swigStructField( "VkSparseBufferMemoryBindInfo-bindCount", offsetof( struct VkSparseBufferMemoryBindInfo, bindCount ), sizeof( uint32_t ) );
	swigStructField( "VkSparseBufferMemoryBindInfo-pBinds", offsetof( struct VkSparseBufferMemoryBindInfo, pBinds ), sizeof( VkSparseMemoryBind const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSparseBufferMemoryBindInfo ) );

	swigComment("VkSparseImageOpaqueMemoryBindInfo\n");
	printf( "begin-structure VkSparseImageOpaqueMemoryBindInfo\n" );
	swigStructField( "VkSparseImageOpaqueMemoryBindInfo-bindCount", offsetof( struct VkSparseImageOpaqueMemoryBindInfo, bindCount ), sizeof( uint32_t ) );
	swigStructField( "VkSparseImageOpaqueMemoryBindInfo-pBinds", offsetof( struct VkSparseImageOpaqueMemoryBindInfo, pBinds ), sizeof( VkSparseMemoryBind const * ) );
	swigStructField( "VkSparseImageOpaqueMemoryBindInfo-image", offsetof( struct VkSparseImageOpaqueMemoryBindInfo, image ), sizeof( VkImage ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSparseImageOpaqueMemoryBindInfo ) );

	swigComment("VkImageSubresource\n");
	printf( "begin-structure VkImageSubresource\n" );
	swigStructField( "VkImageSubresource-arrayLayer", offsetof( struct VkImageSubresource, arrayLayer ), sizeof( uint32_t ) );
	swigStructField( "VkImageSubresource-mipLevel", offsetof( struct VkImageSubresource, mipLevel ), sizeof( uint32_t ) );
	swigStructField( "VkImageSubresource-aspectMask", offsetof( struct VkImageSubresource, aspectMask ), sizeof( VkImageAspectFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkImageSubresource ) );

	swigComment("VkOffset3D\n");
	printf( "begin-structure VkOffset3D\n" );
	swigStructField( "VkOffset3D-x", offsetof( struct VkOffset3D, x ), sizeof( int32_t ) );
	swigStructField( "VkOffset3D-y", offsetof( struct VkOffset3D, y ), sizeof( int32_t ) );
	swigStructField( "VkOffset3D-z", offsetof( struct VkOffset3D, z ), sizeof( int32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkOffset3D ) );

	swigComment("VkSparseImageMemoryBind\n");
	printf( "begin-structure VkSparseImageMemoryBind\n" );
	swigStructField( "VkSparseImageMemoryBind-extent", offsetof( struct VkSparseImageMemoryBind, extent ), sizeof( VkExtent3D ) );
	swigStructField( "VkSparseImageMemoryBind-subresource", offsetof( struct VkSparseImageMemoryBind, subresource ), sizeof( VkImageSubresource ) );
	swigStructField( "VkSparseImageMemoryBind-memory", offsetof( struct VkSparseImageMemoryBind, memory ), sizeof( VkDeviceMemory ) );
	swigStructField( "VkSparseImageMemoryBind-offset", offsetof( struct VkSparseImageMemoryBind, offset ), sizeof( VkOffset3D ) );
	swigStructField( "VkSparseImageMemoryBind-memoryOffset", offsetof( struct VkSparseImageMemoryBind, memoryOffset ), sizeof( VkDeviceSize ) );
	swigStructField( "VkSparseImageMemoryBind-flags", offsetof( struct VkSparseImageMemoryBind, flags ), sizeof( VkSparseMemoryBindFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSparseImageMemoryBind ) );

	swigComment("VkSparseImageMemoryBindInfo\n");
	printf( "begin-structure VkSparseImageMemoryBindInfo\n" );
	swigStructField( "VkSparseImageMemoryBindInfo-bindCount", offsetof( struct VkSparseImageMemoryBindInfo, bindCount ), sizeof( uint32_t ) );
	swigStructField( "VkSparseImageMemoryBindInfo-pBinds", offsetof( struct VkSparseImageMemoryBindInfo, pBinds ), sizeof( VkSparseImageMemoryBind const * ) );
	swigStructField( "VkSparseImageMemoryBindInfo-image", offsetof( struct VkSparseImageMemoryBindInfo, image ), sizeof( VkImage ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSparseImageMemoryBindInfo ) );

	swigComment("VkBindSparseInfo\n");
	printf( "begin-structure VkBindSparseInfo\n" );
	swigStructField( "VkBindSparseInfo-pNext", offsetof( struct VkBindSparseInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkBindSparseInfo-pImageOpaqueBinds", offsetof( struct VkBindSparseInfo, pImageOpaqueBinds ), sizeof( VkSparseImageOpaqueMemoryBindInfo const * ) );
	swigStructField( "VkBindSparseInfo-pImageBinds", offsetof( struct VkBindSparseInfo, pImageBinds ), sizeof( VkSparseImageMemoryBindInfo const * ) );
	swigStructField( "VkBindSparseInfo-bufferBindCount", offsetof( struct VkBindSparseInfo, bufferBindCount ), sizeof( uint32_t ) );
	swigStructField( "VkBindSparseInfo-imageOpaqueBindCount", offsetof( struct VkBindSparseInfo, imageOpaqueBindCount ), sizeof( uint32_t ) );
	swigStructField( "VkBindSparseInfo-imageBindCount", offsetof( struct VkBindSparseInfo, imageBindCount ), sizeof( uint32_t ) );
	swigStructField( "VkBindSparseInfo-waitSemaphoreCount", offsetof( struct VkBindSparseInfo, waitSemaphoreCount ), sizeof( uint32_t ) );
	swigStructField( "VkBindSparseInfo-pWaitSemaphores", offsetof( struct VkBindSparseInfo, pWaitSemaphores ), sizeof( VkSemaphore const * ) );
	swigStructField( "VkBindSparseInfo-signalSemaphoreCount", offsetof( struct VkBindSparseInfo, signalSemaphoreCount ), sizeof( uint32_t ) );
	swigStructField( "VkBindSparseInfo-pSignalSemaphores", offsetof( struct VkBindSparseInfo, pSignalSemaphores ), sizeof( VkSemaphore const * ) );
	swigStructField( "VkBindSparseInfo-sType", offsetof( struct VkBindSparseInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkBindSparseInfo-pBufferBinds", offsetof( struct VkBindSparseInfo, pBufferBinds ), sizeof( VkSparseBufferMemoryBindInfo const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkBindSparseInfo ) );

	swigComment("VkFenceCreateInfo\n");
	printf( "begin-structure VkFenceCreateInfo\n" );
	swigStructField( "VkFenceCreateInfo-pNext", offsetof( struct VkFenceCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkFenceCreateInfo-sType", offsetof( struct VkFenceCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkFenceCreateInfo-flags", offsetof( struct VkFenceCreateInfo, flags ), sizeof( VkFenceCreateFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkFenceCreateInfo ) );

	swigComment("VkSemaphoreCreateInfo\n");
	printf( "begin-structure VkSemaphoreCreateInfo\n" );
	swigStructField( "VkSemaphoreCreateInfo-pNext", offsetof( struct VkSemaphoreCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkSemaphoreCreateInfo-sType", offsetof( struct VkSemaphoreCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkSemaphoreCreateInfo-flags", offsetof( struct VkSemaphoreCreateInfo, flags ), sizeof( VkSemaphoreCreateFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSemaphoreCreateInfo ) );

	swigComment("VkEventCreateInfo\n");
	printf( "begin-structure VkEventCreateInfo\n" );
	swigStructField( "VkEventCreateInfo-pNext", offsetof( struct VkEventCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkEventCreateInfo-sType", offsetof( struct VkEventCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkEventCreateInfo-flags", offsetof( struct VkEventCreateInfo, flags ), sizeof( VkEventCreateFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkEventCreateInfo ) );

	swigComment("VkQueryPoolCreateInfo\n");
	printf( "begin-structure VkQueryPoolCreateInfo\n" );
	swigStructField( "VkQueryPoolCreateInfo-pipelineStatistics", offsetof( struct VkQueryPoolCreateInfo, pipelineStatistics ), sizeof( VkQueryPipelineStatisticFlags ) );
	swigStructField( "VkQueryPoolCreateInfo-pNext", offsetof( struct VkQueryPoolCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkQueryPoolCreateInfo-queryType", offsetof( struct VkQueryPoolCreateInfo, queryType ), sizeof( VkQueryType ) );
	swigStructField( "VkQueryPoolCreateInfo-queryCount", offsetof( struct VkQueryPoolCreateInfo, queryCount ), sizeof( uint32_t ) );
	swigStructField( "VkQueryPoolCreateInfo-sType", offsetof( struct VkQueryPoolCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkQueryPoolCreateInfo-flags", offsetof( struct VkQueryPoolCreateInfo, flags ), sizeof( VkQueryPoolCreateFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkQueryPoolCreateInfo ) );

	swigComment("VkBufferCreateInfo\n");
	printf( "begin-structure VkBufferCreateInfo\n" );
	swigStructField( "VkBufferCreateInfo-pNext", offsetof( struct VkBufferCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkBufferCreateInfo-sharingMode", offsetof( struct VkBufferCreateInfo, sharingMode ), sizeof( VkSharingMode ) );
	swigStructField( "VkBufferCreateInfo-usage", offsetof( struct VkBufferCreateInfo, usage ), sizeof( VkBufferUsageFlags ) );
	swigStructField( "VkBufferCreateInfo-size", offsetof( struct VkBufferCreateInfo, size ), sizeof( VkDeviceSize ) );
	swigStructField( "VkBufferCreateInfo-pQueueFamilyIndices", offsetof( struct VkBufferCreateInfo, pQueueFamilyIndices ), sizeof( uint32_t const * ) );
	swigStructField( "VkBufferCreateInfo-sType", offsetof( struct VkBufferCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkBufferCreateInfo-flags", offsetof( struct VkBufferCreateInfo, flags ), sizeof( VkBufferCreateFlags ) );
	swigStructField( "VkBufferCreateInfo-queueFamilyIndexCount", offsetof( struct VkBufferCreateInfo, queueFamilyIndexCount ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkBufferCreateInfo ) );

	swigComment("VkBufferViewCreateInfo\n");
	printf( "begin-structure VkBufferViewCreateInfo\n" );
	swigStructField( "VkBufferViewCreateInfo-pNext", offsetof( struct VkBufferViewCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkBufferViewCreateInfo-buffer", offsetof( struct VkBufferViewCreateInfo, buffer ), sizeof( VkBuffer ) );
	swigStructField( "VkBufferViewCreateInfo-offset", offsetof( struct VkBufferViewCreateInfo, offset ), sizeof( VkDeviceSize ) );
	swigStructField( "VkBufferViewCreateInfo-sType", offsetof( struct VkBufferViewCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkBufferViewCreateInfo-flags", offsetof( struct VkBufferViewCreateInfo, flags ), sizeof( VkBufferViewCreateFlags ) );
	swigStructField( "VkBufferViewCreateInfo-format", offsetof( struct VkBufferViewCreateInfo, format ), sizeof( VkFormat ) );
	swigStructField( "VkBufferViewCreateInfo-range", offsetof( struct VkBufferViewCreateInfo, range ), sizeof( VkDeviceSize ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkBufferViewCreateInfo ) );

	swigComment("VkImageCreateInfo\n");
	printf( "begin-structure VkImageCreateInfo\n" );
	swigStructField( "VkImageCreateInfo-queueFamilyIndexCount", offsetof( struct VkImageCreateInfo, queueFamilyIndexCount ), sizeof( uint32_t ) );
	swigStructField( "VkImageCreateInfo-pNext", offsetof( struct VkImageCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkImageCreateInfo-samples", offsetof( struct VkImageCreateInfo, samples ), sizeof( VkSampleCountFlagBits ) );
	swigStructField( "VkImageCreateInfo-format", offsetof( struct VkImageCreateInfo, format ), sizeof( VkFormat ) );
	swigStructField( "VkImageCreateInfo-extent", offsetof( struct VkImageCreateInfo, extent ), sizeof( VkExtent3D ) );
	swigStructField( "VkImageCreateInfo-pQueueFamilyIndices", offsetof( struct VkImageCreateInfo, pQueueFamilyIndices ), sizeof( uint32_t const * ) );
	swigStructField( "VkImageCreateInfo-imageType", offsetof( struct VkImageCreateInfo, imageType ), sizeof( VkImageType ) );
	swigStructField( "VkImageCreateInfo-arrayLayers", offsetof( struct VkImageCreateInfo, arrayLayers ), sizeof( uint32_t ) );
	swigStructField( "VkImageCreateInfo-flags", offsetof( struct VkImageCreateInfo, flags ), sizeof( VkImageCreateFlags ) );
	swigStructField( "VkImageCreateInfo-usage", offsetof( struct VkImageCreateInfo, usage ), sizeof( VkImageUsageFlags ) );
	swigStructField( "VkImageCreateInfo-sharingMode", offsetof( struct VkImageCreateInfo, sharingMode ), sizeof( VkSharingMode ) );
	swigStructField( "VkImageCreateInfo-mipLevels", offsetof( struct VkImageCreateInfo, mipLevels ), sizeof( uint32_t ) );
	swigStructField( "VkImageCreateInfo-tiling", offsetof( struct VkImageCreateInfo, tiling ), sizeof( VkImageTiling ) );
	swigStructField( "VkImageCreateInfo-sType", offsetof( struct VkImageCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkImageCreateInfo-initialLayout", offsetof( struct VkImageCreateInfo, initialLayout ), sizeof( VkImageLayout ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkImageCreateInfo ) );

	swigComment("VkSubresourceLayout\n");
	printf( "begin-structure VkSubresourceLayout\n" );
	swigStructField( "VkSubresourceLayout-offset", offsetof( struct VkSubresourceLayout, offset ), sizeof( VkDeviceSize ) );
	swigStructField( "VkSubresourceLayout-arrayPitch", offsetof( struct VkSubresourceLayout, arrayPitch ), sizeof( VkDeviceSize ) );
	swigStructField( "VkSubresourceLayout-size", offsetof( struct VkSubresourceLayout, size ), sizeof( VkDeviceSize ) );
	swigStructField( "VkSubresourceLayout-depthPitch", offsetof( struct VkSubresourceLayout, depthPitch ), sizeof( VkDeviceSize ) );
	swigStructField( "VkSubresourceLayout-rowPitch", offsetof( struct VkSubresourceLayout, rowPitch ), sizeof( VkDeviceSize ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSubresourceLayout ) );

	swigComment("VkComponentMapping\n");
	printf( "begin-structure VkComponentMapping\n" );
	swigStructField( "VkComponentMapping-b", offsetof( struct VkComponentMapping, b ), sizeof( VkComponentSwizzle ) );
	swigStructField( "VkComponentMapping-r", offsetof( struct VkComponentMapping, r ), sizeof( VkComponentSwizzle ) );
	swigStructField( "VkComponentMapping-g", offsetof( struct VkComponentMapping, g ), sizeof( VkComponentSwizzle ) );
	swigStructField( "VkComponentMapping-a", offsetof( struct VkComponentMapping, a ), sizeof( VkComponentSwizzle ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkComponentMapping ) );

	swigComment("VkImageSubresourceRange\n");
	printf( "begin-structure VkImageSubresourceRange\n" );
	swigStructField( "VkImageSubresourceRange-baseArrayLayer", offsetof( struct VkImageSubresourceRange, baseArrayLayer ), sizeof( uint32_t ) );
	swigStructField( "VkImageSubresourceRange-layerCount", offsetof( struct VkImageSubresourceRange, layerCount ), sizeof( uint32_t ) );
	swigStructField( "VkImageSubresourceRange-baseMipLevel", offsetof( struct VkImageSubresourceRange, baseMipLevel ), sizeof( uint32_t ) );
	swigStructField( "VkImageSubresourceRange-levelCount", offsetof( struct VkImageSubresourceRange, levelCount ), sizeof( uint32_t ) );
	swigStructField( "VkImageSubresourceRange-aspectMask", offsetof( struct VkImageSubresourceRange, aspectMask ), sizeof( VkImageAspectFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkImageSubresourceRange ) );

	swigComment("VkImageViewCreateInfo\n");
	printf( "begin-structure VkImageViewCreateInfo\n" );
	swigStructField( "VkImageViewCreateInfo-pNext", offsetof( struct VkImageViewCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkImageViewCreateInfo-viewType", offsetof( struct VkImageViewCreateInfo, viewType ), sizeof( VkImageViewType ) );
	swigStructField( "VkImageViewCreateInfo-image", offsetof( struct VkImageViewCreateInfo, image ), sizeof( VkImage ) );
	swigStructField( "VkImageViewCreateInfo-sType", offsetof( struct VkImageViewCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkImageViewCreateInfo-flags", offsetof( struct VkImageViewCreateInfo, flags ), sizeof( VkImageViewCreateFlags ) );
	swigStructField( "VkImageViewCreateInfo-format", offsetof( struct VkImageViewCreateInfo, format ), sizeof( VkFormat ) );
	swigStructField( "VkImageViewCreateInfo-components", offsetof( struct VkImageViewCreateInfo, components ), sizeof( VkComponentMapping ) );
	swigStructField( "VkImageViewCreateInfo-subresourceRange", offsetof( struct VkImageViewCreateInfo, subresourceRange ), sizeof( VkImageSubresourceRange ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkImageViewCreateInfo ) );

	swigComment("VkShaderModuleCreateInfo\n");
	printf( "begin-structure VkShaderModuleCreateInfo\n" );
	swigStructField( "VkShaderModuleCreateInfo-pNext", offsetof( struct VkShaderModuleCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkShaderModuleCreateInfo-sType", offsetof( struct VkShaderModuleCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkShaderModuleCreateInfo-flags", offsetof( struct VkShaderModuleCreateInfo, flags ), sizeof( VkShaderModuleCreateFlags ) );
	swigStructField( "VkShaderModuleCreateInfo-codeSize", offsetof( struct VkShaderModuleCreateInfo, codeSize ), sizeof( size_t ) );
	swigStructField( "VkShaderModuleCreateInfo-pCode", offsetof( struct VkShaderModuleCreateInfo, pCode ), sizeof( uint32_t const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkShaderModuleCreateInfo ) );

	swigComment("VkPipelineCacheCreateInfo\n");
	printf( "begin-structure VkPipelineCacheCreateInfo\n" );
	swigStructField( "VkPipelineCacheCreateInfo-pNext", offsetof( struct VkPipelineCacheCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkPipelineCacheCreateInfo-initialDataSize", offsetof( struct VkPipelineCacheCreateInfo, initialDataSize ), sizeof( size_t ) );
	swigStructField( "VkPipelineCacheCreateInfo-pInitialData", offsetof( struct VkPipelineCacheCreateInfo, pInitialData ), sizeof( void const * ) );
	swigStructField( "VkPipelineCacheCreateInfo-sType", offsetof( struct VkPipelineCacheCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPipelineCacheCreateInfo-flags", offsetof( struct VkPipelineCacheCreateInfo, flags ), sizeof( VkPipelineCacheCreateFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineCacheCreateInfo ) );

	swigComment("VkSpecializationMapEntry\n");
	printf( "begin-structure VkSpecializationMapEntry\n" );
	swigStructField( "VkSpecializationMapEntry-constantID", offsetof( struct VkSpecializationMapEntry, constantID ), sizeof( uint32_t ) );
	swigStructField( "VkSpecializationMapEntry-offset", offsetof( struct VkSpecializationMapEntry, offset ), sizeof( uint32_t ) );
	swigStructField( "VkSpecializationMapEntry-size", offsetof( struct VkSpecializationMapEntry, size ), sizeof( size_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSpecializationMapEntry ) );

	swigComment("VkSpecializationInfo\n");
	printf( "begin-structure VkSpecializationInfo\n" );
	swigStructField( "VkSpecializationInfo-dataSize", offsetof( struct VkSpecializationInfo, dataSize ), sizeof( size_t ) );
	swigStructField( "VkSpecializationInfo-mapEntryCount", offsetof( struct VkSpecializationInfo, mapEntryCount ), sizeof( uint32_t ) );
	swigStructField( "VkSpecializationInfo-pData", offsetof( struct VkSpecializationInfo, pData ), sizeof( void const * ) );
	swigStructField( "VkSpecializationInfo-pMapEntries", offsetof( struct VkSpecializationInfo, pMapEntries ), sizeof( VkSpecializationMapEntry const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSpecializationInfo ) );

	swigComment("VkPipelineShaderStageCreateInfo\n");
	printf( "begin-structure VkPipelineShaderStageCreateInfo\n" );
	swigStructField( "VkPipelineShaderStageCreateInfo-pNext", offsetof( struct VkPipelineShaderStageCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkPipelineShaderStageCreateInfo-module", offsetof( struct VkPipelineShaderStageCreateInfo, module ), sizeof( VkShaderModule ) );
	swigStructField( "VkPipelineShaderStageCreateInfo-pSpecializationInfo", offsetof( struct VkPipelineShaderStageCreateInfo, pSpecializationInfo ), sizeof( VkSpecializationInfo const * ) );
	swigStructField( "VkPipelineShaderStageCreateInfo-stage", offsetof( struct VkPipelineShaderStageCreateInfo, stage ), sizeof( VkShaderStageFlagBits ) );
	swigStructField( "VkPipelineShaderStageCreateInfo-pName", offsetof( struct VkPipelineShaderStageCreateInfo, pName ), sizeof( char const * ) );
	swigStructField( "VkPipelineShaderStageCreateInfo-sType", offsetof( struct VkPipelineShaderStageCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPipelineShaderStageCreateInfo-flags", offsetof( struct VkPipelineShaderStageCreateInfo, flags ), sizeof( VkPipelineShaderStageCreateFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineShaderStageCreateInfo ) );

	swigComment("VkVertexInputBindingDescription\n");
	printf( "begin-structure VkVertexInputBindingDescription\n" );
	swigStructField( "VkVertexInputBindingDescription-binding", offsetof( struct VkVertexInputBindingDescription, binding ), sizeof( uint32_t ) );
	swigStructField( "VkVertexInputBindingDescription-inputRate", offsetof( struct VkVertexInputBindingDescription, inputRate ), sizeof( VkVertexInputRate ) );
	swigStructField( "VkVertexInputBindingDescription-stride", offsetof( struct VkVertexInputBindingDescription, stride ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkVertexInputBindingDescription ) );

	swigComment("VkVertexInputAttributeDescription\n");
	printf( "begin-structure VkVertexInputAttributeDescription\n" );
	swigStructField( "VkVertexInputAttributeDescription-location", offsetof( struct VkVertexInputAttributeDescription, location ), sizeof( uint32_t ) );
	swigStructField( "VkVertexInputAttributeDescription-binding", offsetof( struct VkVertexInputAttributeDescription, binding ), sizeof( uint32_t ) );
	swigStructField( "VkVertexInputAttributeDescription-offset", offsetof( struct VkVertexInputAttributeDescription, offset ), sizeof( uint32_t ) );
	swigStructField( "VkVertexInputAttributeDescription-format", offsetof( struct VkVertexInputAttributeDescription, format ), sizeof( VkFormat ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkVertexInputAttributeDescription ) );

	swigComment("VkPipelineVertexInputStateCreateInfo\n");
	printf( "begin-structure VkPipelineVertexInputStateCreateInfo\n" );
	swigStructField( "VkPipelineVertexInputStateCreateInfo-vertexBindingDescriptionCount", offsetof( struct VkPipelineVertexInputStateCreateInfo, vertexBindingDescriptionCount ), sizeof( uint32_t ) );
	swigStructField( "VkPipelineVertexInputStateCreateInfo-vertexAttributeDescriptionCount", offsetof( struct VkPipelineVertexInputStateCreateInfo, vertexAttributeDescriptionCount ), sizeof( uint32_t ) );
	swigStructField( "VkPipelineVertexInputStateCreateInfo-pNext", offsetof( struct VkPipelineVertexInputStateCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkPipelineVertexInputStateCreateInfo-sType", offsetof( struct VkPipelineVertexInputStateCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPipelineVertexInputStateCreateInfo-flags", offsetof( struct VkPipelineVertexInputStateCreateInfo, flags ), sizeof( VkPipelineVertexInputStateCreateFlags ) );
	swigStructField( "VkPipelineVertexInputStateCreateInfo-pVertexBindingDescriptions", offsetof( struct VkPipelineVertexInputStateCreateInfo, pVertexBindingDescriptions ), sizeof( VkVertexInputBindingDescription const * ) );
	swigStructField( "VkPipelineVertexInputStateCreateInfo-pVertexAttributeDescriptions", offsetof( struct VkPipelineVertexInputStateCreateInfo, pVertexAttributeDescriptions ), sizeof( VkVertexInputAttributeDescription const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineVertexInputStateCreateInfo ) );

	swigComment("VkPipelineInputAssemblyStateCreateInfo\n");
	printf( "begin-structure VkPipelineInputAssemblyStateCreateInfo\n" );
	swigStructField( "VkPipelineInputAssemblyStateCreateInfo-pNext", offsetof( struct VkPipelineInputAssemblyStateCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkPipelineInputAssemblyStateCreateInfo-topology", offsetof( struct VkPipelineInputAssemblyStateCreateInfo, topology ), sizeof( VkPrimitiveTopology ) );
	swigStructField( "VkPipelineInputAssemblyStateCreateInfo-primitiveRestartEnable", offsetof( struct VkPipelineInputAssemblyStateCreateInfo, primitiveRestartEnable ), sizeof( VkBool32 ) );
	swigStructField( "VkPipelineInputAssemblyStateCreateInfo-sType", offsetof( struct VkPipelineInputAssemblyStateCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPipelineInputAssemblyStateCreateInfo-flags", offsetof( struct VkPipelineInputAssemblyStateCreateInfo, flags ), sizeof( VkPipelineInputAssemblyStateCreateFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineInputAssemblyStateCreateInfo ) );

	swigComment("VkPipelineTessellationStateCreateInfo\n");
	printf( "begin-structure VkPipelineTessellationStateCreateInfo\n" );
	swigStructField( "VkPipelineTessellationStateCreateInfo-pNext", offsetof( struct VkPipelineTessellationStateCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkPipelineTessellationStateCreateInfo-patchControlPoints", offsetof( struct VkPipelineTessellationStateCreateInfo, patchControlPoints ), sizeof( uint32_t ) );
	swigStructField( "VkPipelineTessellationStateCreateInfo-sType", offsetof( struct VkPipelineTessellationStateCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPipelineTessellationStateCreateInfo-flags", offsetof( struct VkPipelineTessellationStateCreateInfo, flags ), sizeof( VkPipelineTessellationStateCreateFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineTessellationStateCreateInfo ) );

	swigComment("VkViewport\n");
	printf( "begin-structure VkViewport\n" );
	swigStructField( "VkViewport-x", offsetof( struct VkViewport, x ), sizeof( float ) );
	swigStructField( "VkViewport-y", offsetof( struct VkViewport, y ), sizeof( float ) );
	swigStructField( "VkViewport-maxDepth", offsetof( struct VkViewport, maxDepth ), sizeof( float ) );
	swigStructField( "VkViewport-minDepth", offsetof( struct VkViewport, minDepth ), sizeof( float ) );
	swigStructField( "VkViewport-height", offsetof( struct VkViewport, height ), sizeof( float ) );
	swigStructField( "VkViewport-width", offsetof( struct VkViewport, width ), sizeof( float ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkViewport ) );

	swigComment("VkOffset2D\n");
	printf( "begin-structure VkOffset2D\n" );
	swigStructField( "VkOffset2D-x", offsetof( struct VkOffset2D, x ), sizeof( int32_t ) );
	swigStructField( "VkOffset2D-y", offsetof( struct VkOffset2D, y ), sizeof( int32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkOffset2D ) );

	swigComment("VkExtent2D\n");
	printf( "begin-structure VkExtent2D\n" );
	swigStructField( "VkExtent2D-height", offsetof( struct VkExtent2D, height ), sizeof( uint32_t ) );
	swigStructField( "VkExtent2D-width", offsetof( struct VkExtent2D, width ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkExtent2D ) );

	swigComment("VkRect2D\n");
	printf( "begin-structure VkRect2D\n" );
	swigStructField( "VkRect2D-extent", offsetof( struct VkRect2D, extent ), sizeof( VkExtent2D ) );
	swigStructField( "VkRect2D-offset", offsetof( struct VkRect2D, offset ), sizeof( VkOffset2D ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkRect2D ) );

	swigComment("VkPipelineViewportStateCreateInfo\n");
	printf( "begin-structure VkPipelineViewportStateCreateInfo\n" );
	swigStructField( "VkPipelineViewportStateCreateInfo-pScissors", offsetof( struct VkPipelineViewportStateCreateInfo, pScissors ), sizeof( VkRect2D const * ) );
	swigStructField( "VkPipelineViewportStateCreateInfo-pNext", offsetof( struct VkPipelineViewportStateCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkPipelineViewportStateCreateInfo-scissorCount", offsetof( struct VkPipelineViewportStateCreateInfo, scissorCount ), sizeof( uint32_t ) );
	swigStructField( "VkPipelineViewportStateCreateInfo-sType", offsetof( struct VkPipelineViewportStateCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPipelineViewportStateCreateInfo-flags", offsetof( struct VkPipelineViewportStateCreateInfo, flags ), sizeof( VkPipelineViewportStateCreateFlags ) );
	swigStructField( "VkPipelineViewportStateCreateInfo-pViewports", offsetof( struct VkPipelineViewportStateCreateInfo, pViewports ), sizeof( VkViewport const * ) );
	swigStructField( "VkPipelineViewportStateCreateInfo-viewportCount", offsetof( struct VkPipelineViewportStateCreateInfo, viewportCount ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineViewportStateCreateInfo ) );

	swigComment("VkPipelineRasterizationStateCreateInfo\n");
	printf( "begin-structure VkPipelineRasterizationStateCreateInfo\n" );
	swigStructField( "VkPipelineRasterizationStateCreateInfo-frontFace", offsetof( struct VkPipelineRasterizationStateCreateInfo, frontFace ), sizeof( VkFrontFace ) );
	swigStructField( "VkPipelineRasterizationStateCreateInfo-lineWidth", offsetof( struct VkPipelineRasterizationStateCreateInfo, lineWidth ), sizeof( float ) );
	swigStructField( "VkPipelineRasterizationStateCreateInfo-pNext", offsetof( struct VkPipelineRasterizationStateCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkPipelineRasterizationStateCreateInfo-depthBiasConstantFactor", offsetof( struct VkPipelineRasterizationStateCreateInfo, depthBiasConstantFactor ), sizeof( float ) );
	swigStructField( "VkPipelineRasterizationStateCreateInfo-depthBiasClamp", offsetof( struct VkPipelineRasterizationStateCreateInfo, depthBiasClamp ), sizeof( float ) );
	swigStructField( "VkPipelineRasterizationStateCreateInfo-depthClampEnable", offsetof( struct VkPipelineRasterizationStateCreateInfo, depthClampEnable ), sizeof( VkBool32 ) );
	swigStructField( "VkPipelineRasterizationStateCreateInfo-rasterizerDiscardEnable", offsetof( struct VkPipelineRasterizationStateCreateInfo, rasterizerDiscardEnable ), sizeof( VkBool32 ) );
	swigStructField( "VkPipelineRasterizationStateCreateInfo-depthBiasSlopeFactor", offsetof( struct VkPipelineRasterizationStateCreateInfo, depthBiasSlopeFactor ), sizeof( float ) );
	swigStructField( "VkPipelineRasterizationStateCreateInfo-polygonMode", offsetof( struct VkPipelineRasterizationStateCreateInfo, polygonMode ), sizeof( VkPolygonMode ) );
	swigStructField( "VkPipelineRasterizationStateCreateInfo-cullMode", offsetof( struct VkPipelineRasterizationStateCreateInfo, cullMode ), sizeof( VkCullModeFlags ) );
	swigStructField( "VkPipelineRasterizationStateCreateInfo-depthBiasEnable", offsetof( struct VkPipelineRasterizationStateCreateInfo, depthBiasEnable ), sizeof( VkBool32 ) );
	swigStructField( "VkPipelineRasterizationStateCreateInfo-sType", offsetof( struct VkPipelineRasterizationStateCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPipelineRasterizationStateCreateInfo-flags", offsetof( struct VkPipelineRasterizationStateCreateInfo, flags ), sizeof( VkPipelineRasterizationStateCreateFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineRasterizationStateCreateInfo ) );

	swigComment("VkPipelineMultisampleStateCreateInfo\n");
	printf( "begin-structure VkPipelineMultisampleStateCreateInfo\n" );
	swigStructField( "VkPipelineMultisampleStateCreateInfo-pSampleMask", offsetof( struct VkPipelineMultisampleStateCreateInfo, pSampleMask ), sizeof( VkSampleMask const * ) );
	swigStructField( "VkPipelineMultisampleStateCreateInfo-pNext", offsetof( struct VkPipelineMultisampleStateCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkPipelineMultisampleStateCreateInfo-sampleShadingEnable", offsetof( struct VkPipelineMultisampleStateCreateInfo, sampleShadingEnable ), sizeof( VkBool32 ) );
	swigStructField( "VkPipelineMultisampleStateCreateInfo-alphaToCoverageEnable", offsetof( struct VkPipelineMultisampleStateCreateInfo, alphaToCoverageEnable ), sizeof( VkBool32 ) );
	swigStructField( "VkPipelineMultisampleStateCreateInfo-alphaToOneEnable", offsetof( struct VkPipelineMultisampleStateCreateInfo, alphaToOneEnable ), sizeof( VkBool32 ) );
	swigStructField( "VkPipelineMultisampleStateCreateInfo-rasterizationSamples", offsetof( struct VkPipelineMultisampleStateCreateInfo, rasterizationSamples ), sizeof( VkSampleCountFlagBits ) );
	swigStructField( "VkPipelineMultisampleStateCreateInfo-minSampleShading", offsetof( struct VkPipelineMultisampleStateCreateInfo, minSampleShading ), sizeof( float ) );
	swigStructField( "VkPipelineMultisampleStateCreateInfo-sType", offsetof( struct VkPipelineMultisampleStateCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPipelineMultisampleStateCreateInfo-flags", offsetof( struct VkPipelineMultisampleStateCreateInfo, flags ), sizeof( VkPipelineMultisampleStateCreateFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineMultisampleStateCreateInfo ) );

	swigComment("VkStencilOpState\n");
	printf( "begin-structure VkStencilOpState\n" );
	swigStructField( "VkStencilOpState-depthFailOp", offsetof( struct VkStencilOpState, depthFailOp ), sizeof( VkStencilOp ) );
	swigStructField( "VkStencilOpState-writeMask", offsetof( struct VkStencilOpState, writeMask ), sizeof( uint32_t ) );
	swigStructField( "VkStencilOpState-failOp", offsetof( struct VkStencilOpState, failOp ), sizeof( VkStencilOp ) );
	swigStructField( "VkStencilOpState-compareOp", offsetof( struct VkStencilOpState, compareOp ), sizeof( VkCompareOp ) );
	swigStructField( "VkStencilOpState-passOp", offsetof( struct VkStencilOpState, passOp ), sizeof( VkStencilOp ) );
	swigStructField( "VkStencilOpState-compareMask", offsetof( struct VkStencilOpState, compareMask ), sizeof( uint32_t ) );
	swigStructField( "VkStencilOpState-reference", offsetof( struct VkStencilOpState, reference ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkStencilOpState ) );

	swigComment("VkPipelineDepthStencilStateCreateInfo\n");
	printf( "begin-structure VkPipelineDepthStencilStateCreateInfo\n" );
	swigStructField( "VkPipelineDepthStencilStateCreateInfo-pNext", offsetof( struct VkPipelineDepthStencilStateCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkPipelineDepthStencilStateCreateInfo-depthTestEnable", offsetof( struct VkPipelineDepthStencilStateCreateInfo, depthTestEnable ), sizeof( VkBool32 ) );
	swigStructField( "VkPipelineDepthStencilStateCreateInfo-depthCompareOp", offsetof( struct VkPipelineDepthStencilStateCreateInfo, depthCompareOp ), sizeof( VkCompareOp ) );
	swigStructField( "VkPipelineDepthStencilStateCreateInfo-depthBoundsTestEnable", offsetof( struct VkPipelineDepthStencilStateCreateInfo, depthBoundsTestEnable ), sizeof( VkBool32 ) );
	swigStructField( "VkPipelineDepthStencilStateCreateInfo-stencilTestEnable", offsetof( struct VkPipelineDepthStencilStateCreateInfo, stencilTestEnable ), sizeof( VkBool32 ) );
	swigStructField( "VkPipelineDepthStencilStateCreateInfo-depthWriteEnable", offsetof( struct VkPipelineDepthStencilStateCreateInfo, depthWriteEnable ), sizeof( VkBool32 ) );
	swigStructField( "VkPipelineDepthStencilStateCreateInfo-back", offsetof( struct VkPipelineDepthStencilStateCreateInfo, back ), sizeof( VkStencilOpState ) );
	swigStructField( "VkPipelineDepthStencilStateCreateInfo-sType", offsetof( struct VkPipelineDepthStencilStateCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPipelineDepthStencilStateCreateInfo-flags", offsetof( struct VkPipelineDepthStencilStateCreateInfo, flags ), sizeof( VkPipelineDepthStencilStateCreateFlags ) );
	swigStructField( "VkPipelineDepthStencilStateCreateInfo-front", offsetof( struct VkPipelineDepthStencilStateCreateInfo, front ), sizeof( VkStencilOpState ) );
	swigStructField( "VkPipelineDepthStencilStateCreateInfo-minDepthBounds", offsetof( struct VkPipelineDepthStencilStateCreateInfo, minDepthBounds ), sizeof( float ) );
	swigStructField( "VkPipelineDepthStencilStateCreateInfo-maxDepthBounds", offsetof( struct VkPipelineDepthStencilStateCreateInfo, maxDepthBounds ), sizeof( float ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineDepthStencilStateCreateInfo ) );

	swigComment("VkPipelineColorBlendAttachmentState\n");
	printf( "begin-structure VkPipelineColorBlendAttachmentState\n" );
	swigStructField( "VkPipelineColorBlendAttachmentState-srcColorBlendFactor", offsetof( struct VkPipelineColorBlendAttachmentState, srcColorBlendFactor ), sizeof( VkBlendFactor ) );
	swigStructField( "VkPipelineColorBlendAttachmentState-dstColorBlendFactor", offsetof( struct VkPipelineColorBlendAttachmentState, dstColorBlendFactor ), sizeof( VkBlendFactor ) );
	swigStructField( "VkPipelineColorBlendAttachmentState-srcAlphaBlendFactor", offsetof( struct VkPipelineColorBlendAttachmentState, srcAlphaBlendFactor ), sizeof( VkBlendFactor ) );
	swigStructField( "VkPipelineColorBlendAttachmentState-dstAlphaBlendFactor", offsetof( struct VkPipelineColorBlendAttachmentState, dstAlphaBlendFactor ), sizeof( VkBlendFactor ) );
	swigStructField( "VkPipelineColorBlendAttachmentState-colorWriteMask", offsetof( struct VkPipelineColorBlendAttachmentState, colorWriteMask ), sizeof( VkColorComponentFlags ) );
	swigStructField( "VkPipelineColorBlendAttachmentState-blendEnable", offsetof( struct VkPipelineColorBlendAttachmentState, blendEnable ), sizeof( VkBool32 ) );
	swigStructField( "VkPipelineColorBlendAttachmentState-colorBlendOp", offsetof( struct VkPipelineColorBlendAttachmentState, colorBlendOp ), sizeof( VkBlendOp ) );
	swigStructField( "VkPipelineColorBlendAttachmentState-alphaBlendOp", offsetof( struct VkPipelineColorBlendAttachmentState, alphaBlendOp ), sizeof( VkBlendOp ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineColorBlendAttachmentState ) );

	swigComment("VkPipelineColorBlendStateCreateInfo\n");
	printf( "begin-structure VkPipelineColorBlendStateCreateInfo\n" );
	swigStructField( "VkPipelineColorBlendStateCreateInfo-pNext", offsetof( struct VkPipelineColorBlendStateCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkPipelineColorBlendStateCreateInfo-pAttachments", offsetof( struct VkPipelineColorBlendStateCreateInfo, pAttachments ), sizeof( VkPipelineColorBlendAttachmentState const * ) );
	swigStructField( "VkPipelineColorBlendStateCreateInfo-logicOpEnable", offsetof( struct VkPipelineColorBlendStateCreateInfo, logicOpEnable ), sizeof( VkBool32 ) );
	swigStructField( "VkPipelineColorBlendStateCreateInfo-sType", offsetof( struct VkPipelineColorBlendStateCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPipelineColorBlendStateCreateInfo-flags", offsetof( struct VkPipelineColorBlendStateCreateInfo, flags ), sizeof( VkPipelineColorBlendStateCreateFlags ) );
	swigStructField( "VkPipelineColorBlendStateCreateInfo-logicOp", offsetof( struct VkPipelineColorBlendStateCreateInfo, logicOp ), sizeof( VkLogicOp ) );
	swigStructField( "VkPipelineColorBlendStateCreateInfo-attachmentCount", offsetof( struct VkPipelineColorBlendStateCreateInfo, attachmentCount ), sizeof( uint32_t ) );
	swigStructField( "VkPipelineColorBlendStateCreateInfo-blendConstants", offsetof( struct VkPipelineColorBlendStateCreateInfo, blendConstants ), sizeof( float [4] ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineColorBlendStateCreateInfo ) );

	swigComment("VkPipelineDynamicStateCreateInfo\n");
	printf( "begin-structure VkPipelineDynamicStateCreateInfo\n" );
	swigStructField( "VkPipelineDynamicStateCreateInfo-pDynamicStates", offsetof( struct VkPipelineDynamicStateCreateInfo, pDynamicStates ), sizeof( VkDynamicState const * ) );
	swigStructField( "VkPipelineDynamicStateCreateInfo-pNext", offsetof( struct VkPipelineDynamicStateCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkPipelineDynamicStateCreateInfo-dynamicStateCount", offsetof( struct VkPipelineDynamicStateCreateInfo, dynamicStateCount ), sizeof( uint32_t ) );
	swigStructField( "VkPipelineDynamicStateCreateInfo-sType", offsetof( struct VkPipelineDynamicStateCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPipelineDynamicStateCreateInfo-flags", offsetof( struct VkPipelineDynamicStateCreateInfo, flags ), sizeof( VkPipelineDynamicStateCreateFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineDynamicStateCreateInfo ) );

	swigComment("VkGraphicsPipelineCreateInfo\n");
	printf( "begin-structure VkGraphicsPipelineCreateInfo\n" );
	swigStructField( "VkGraphicsPipelineCreateInfo-pDynamicState", offsetof( struct VkGraphicsPipelineCreateInfo, pDynamicState ), sizeof( VkPipelineDynamicStateCreateInfo const * ) );
	swigStructField( "VkGraphicsPipelineCreateInfo-pVertexInputState", offsetof( struct VkGraphicsPipelineCreateInfo, pVertexInputState ), sizeof( VkPipelineVertexInputStateCreateInfo const * ) );
	swigStructField( "VkGraphicsPipelineCreateInfo-pMultisampleState", offsetof( struct VkGraphicsPipelineCreateInfo, pMultisampleState ), sizeof( VkPipelineMultisampleStateCreateInfo const * ) );
	swigStructField( "VkGraphicsPipelineCreateInfo-basePipelineHandle", offsetof( struct VkGraphicsPipelineCreateInfo, basePipelineHandle ), sizeof( VkPipeline ) );
	swigStructField( "VkGraphicsPipelineCreateInfo-basePipelineIndex", offsetof( struct VkGraphicsPipelineCreateInfo, basePipelineIndex ), sizeof( int32_t ) );
	swigStructField( "VkGraphicsPipelineCreateInfo-pDepthStencilState", offsetof( struct VkGraphicsPipelineCreateInfo, pDepthStencilState ), sizeof( VkPipelineDepthStencilStateCreateInfo const * ) );
	swigStructField( "VkGraphicsPipelineCreateInfo-renderPass", offsetof( struct VkGraphicsPipelineCreateInfo, renderPass ), sizeof( VkRenderPass ) );
	swigStructField( "VkGraphicsPipelineCreateInfo-subpass", offsetof( struct VkGraphicsPipelineCreateInfo, subpass ), sizeof( uint32_t ) );
	swigStructField( "VkGraphicsPipelineCreateInfo-pNext", offsetof( struct VkGraphicsPipelineCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkGraphicsPipelineCreateInfo-pRasterizationState", offsetof( struct VkGraphicsPipelineCreateInfo, pRasterizationState ), sizeof( VkPipelineRasterizationStateCreateInfo const * ) );
	swigStructField( "VkGraphicsPipelineCreateInfo-pTessellationState", offsetof( struct VkGraphicsPipelineCreateInfo, pTessellationState ), sizeof( VkPipelineTessellationStateCreateInfo const * ) );
	swigStructField( "VkGraphicsPipelineCreateInfo-pInputAssemblyState", offsetof( struct VkGraphicsPipelineCreateInfo, pInputAssemblyState ), sizeof( VkPipelineInputAssemblyStateCreateInfo const * ) );
	swigStructField( "VkGraphicsPipelineCreateInfo-flags", offsetof( struct VkGraphicsPipelineCreateInfo, flags ), sizeof( VkPipelineCreateFlags ) );
	swigStructField( "VkGraphicsPipelineCreateInfo-layout", offsetof( struct VkGraphicsPipelineCreateInfo, layout ), sizeof( VkPipelineLayout ) );
	swigStructField( "VkGraphicsPipelineCreateInfo-pViewportState", offsetof( struct VkGraphicsPipelineCreateInfo, pViewportState ), sizeof( VkPipelineViewportStateCreateInfo const * ) );
	swigStructField( "VkGraphicsPipelineCreateInfo-stageCount", offsetof( struct VkGraphicsPipelineCreateInfo, stageCount ), sizeof( uint32_t ) );
	swigStructField( "VkGraphicsPipelineCreateInfo-pColorBlendState", offsetof( struct VkGraphicsPipelineCreateInfo, pColorBlendState ), sizeof( VkPipelineColorBlendStateCreateInfo const * ) );
	swigStructField( "VkGraphicsPipelineCreateInfo-pStages", offsetof( struct VkGraphicsPipelineCreateInfo, pStages ), sizeof( VkPipelineShaderStageCreateInfo const * ) );
	swigStructField( "VkGraphicsPipelineCreateInfo-sType", offsetof( struct VkGraphicsPipelineCreateInfo, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkGraphicsPipelineCreateInfo ) );

	swigComment("VkComputePipelineCreateInfo\n");
	printf( "begin-structure VkComputePipelineCreateInfo\n" );
	swigStructField( "VkComputePipelineCreateInfo-pNext", offsetof( struct VkComputePipelineCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkComputePipelineCreateInfo-stage", offsetof( struct VkComputePipelineCreateInfo, stage ), sizeof( VkPipelineShaderStageCreateInfo ) );
	swigStructField( "VkComputePipelineCreateInfo-basePipelineHandle", offsetof( struct VkComputePipelineCreateInfo, basePipelineHandle ), sizeof( VkPipeline ) );
	swigStructField( "VkComputePipelineCreateInfo-layout", offsetof( struct VkComputePipelineCreateInfo, layout ), sizeof( VkPipelineLayout ) );
	swigStructField( "VkComputePipelineCreateInfo-basePipelineIndex", offsetof( struct VkComputePipelineCreateInfo, basePipelineIndex ), sizeof( int32_t ) );
	swigStructField( "VkComputePipelineCreateInfo-sType", offsetof( struct VkComputePipelineCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkComputePipelineCreateInfo-flags", offsetof( struct VkComputePipelineCreateInfo, flags ), sizeof( VkPipelineCreateFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkComputePipelineCreateInfo ) );

	swigComment("VkPushConstantRange\n");
	printf( "begin-structure VkPushConstantRange\n" );
	swigStructField( "VkPushConstantRange-offset", offsetof( struct VkPushConstantRange, offset ), sizeof( uint32_t ) );
	swigStructField( "VkPushConstantRange-size", offsetof( struct VkPushConstantRange, size ), sizeof( uint32_t ) );
	swigStructField( "VkPushConstantRange-stageFlags", offsetof( struct VkPushConstantRange, stageFlags ), sizeof( VkShaderStageFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPushConstantRange ) );

	swigComment("VkPipelineLayoutCreateInfo\n");
	printf( "begin-structure VkPipelineLayoutCreateInfo\n" );
	swigStructField( "VkPipelineLayoutCreateInfo-pNext", offsetof( struct VkPipelineLayoutCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkPipelineLayoutCreateInfo-pushConstantRangeCount", offsetof( struct VkPipelineLayoutCreateInfo, pushConstantRangeCount ), sizeof( uint32_t ) );
	swigStructField( "VkPipelineLayoutCreateInfo-pSetLayouts", offsetof( struct VkPipelineLayoutCreateInfo, pSetLayouts ), sizeof( VkDescriptorSetLayout const * ) );
	swigStructField( "VkPipelineLayoutCreateInfo-sType", offsetof( struct VkPipelineLayoutCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkPipelineLayoutCreateInfo-flags", offsetof( struct VkPipelineLayoutCreateInfo, flags ), sizeof( VkPipelineLayoutCreateFlags ) );
	swigStructField( "VkPipelineLayoutCreateInfo-setLayoutCount", offsetof( struct VkPipelineLayoutCreateInfo, setLayoutCount ), sizeof( uint32_t ) );
	swigStructField( "VkPipelineLayoutCreateInfo-pPushConstantRanges", offsetof( struct VkPipelineLayoutCreateInfo, pPushConstantRanges ), sizeof( VkPushConstantRange const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineLayoutCreateInfo ) );

	swigComment("VkSamplerCreateInfo\n");
	printf( "begin-structure VkSamplerCreateInfo\n" );
	swigStructField( "VkSamplerCreateInfo-borderColor", offsetof( struct VkSamplerCreateInfo, borderColor ), sizeof( VkBorderColor ) );
	swigStructField( "VkSamplerCreateInfo-minLod", offsetof( struct VkSamplerCreateInfo, minLod ), sizeof( float ) );
	swigStructField( "VkSamplerCreateInfo-addressModeU", offsetof( struct VkSamplerCreateInfo, addressModeU ), sizeof( VkSamplerAddressMode ) );
	swigStructField( "VkSamplerCreateInfo-addressModeV", offsetof( struct VkSamplerCreateInfo, addressModeV ), sizeof( VkSamplerAddressMode ) );
	swigStructField( "VkSamplerCreateInfo-pNext", offsetof( struct VkSamplerCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkSamplerCreateInfo-addressModeW", offsetof( struct VkSamplerCreateInfo, addressModeW ), sizeof( VkSamplerAddressMode ) );
	swigStructField( "VkSamplerCreateInfo-maxAnisotropy", offsetof( struct VkSamplerCreateInfo, maxAnisotropy ), sizeof( float ) );
	swigStructField( "VkSamplerCreateInfo-compareEnable", offsetof( struct VkSamplerCreateInfo, compareEnable ), sizeof( VkBool32 ) );
	swigStructField( "VkSamplerCreateInfo-anisotropyEnable", offsetof( struct VkSamplerCreateInfo, anisotropyEnable ), sizeof( VkBool32 ) );
	swigStructField( "VkSamplerCreateInfo-mipmapMode", offsetof( struct VkSamplerCreateInfo, mipmapMode ), sizeof( VkSamplerMipmapMode ) );
	swigStructField( "VkSamplerCreateInfo-magFilter", offsetof( struct VkSamplerCreateInfo, magFilter ), sizeof( VkFilter ) );
	swigStructField( "VkSamplerCreateInfo-compareOp", offsetof( struct VkSamplerCreateInfo, compareOp ), sizeof( VkCompareOp ) );
	swigStructField( "VkSamplerCreateInfo-mipLodBias", offsetof( struct VkSamplerCreateInfo, mipLodBias ), sizeof( float ) );
	swigStructField( "VkSamplerCreateInfo-flags", offsetof( struct VkSamplerCreateInfo, flags ), sizeof( VkSamplerCreateFlags ) );
	swigStructField( "VkSamplerCreateInfo-minFilter", offsetof( struct VkSamplerCreateInfo, minFilter ), sizeof( VkFilter ) );
	swigStructField( "VkSamplerCreateInfo-maxLod", offsetof( struct VkSamplerCreateInfo, maxLod ), sizeof( float ) );
	swigStructField( "VkSamplerCreateInfo-unnormalizedCoordinates", offsetof( struct VkSamplerCreateInfo, unnormalizedCoordinates ), sizeof( VkBool32 ) );
	swigStructField( "VkSamplerCreateInfo-sType", offsetof( struct VkSamplerCreateInfo, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSamplerCreateInfo ) );

	swigComment("VkDescriptorSetLayoutBinding\n");
	printf( "begin-structure VkDescriptorSetLayoutBinding\n" );
	swigStructField( "VkDescriptorSetLayoutBinding-descriptorCount", offsetof( struct VkDescriptorSetLayoutBinding, descriptorCount ), sizeof( uint32_t ) );
	swigStructField( "VkDescriptorSetLayoutBinding-binding", offsetof( struct VkDescriptorSetLayoutBinding, binding ), sizeof( uint32_t ) );
	swigStructField( "VkDescriptorSetLayoutBinding-descriptorType", offsetof( struct VkDescriptorSetLayoutBinding, descriptorType ), sizeof( VkDescriptorType ) );
	swigStructField( "VkDescriptorSetLayoutBinding-pImmutableSamplers", offsetof( struct VkDescriptorSetLayoutBinding, pImmutableSamplers ), sizeof( VkSampler const * ) );
	swigStructField( "VkDescriptorSetLayoutBinding-stageFlags", offsetof( struct VkDescriptorSetLayoutBinding, stageFlags ), sizeof( VkShaderStageFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDescriptorSetLayoutBinding ) );

	swigComment("VkDescriptorSetLayoutCreateInfo\n");
	printf( "begin-structure VkDescriptorSetLayoutCreateInfo\n" );
	swigStructField( "VkDescriptorSetLayoutCreateInfo-pNext", offsetof( struct VkDescriptorSetLayoutCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkDescriptorSetLayoutCreateInfo-bindingCount", offsetof( struct VkDescriptorSetLayoutCreateInfo, bindingCount ), sizeof( uint32_t ) );
	swigStructField( "VkDescriptorSetLayoutCreateInfo-sType", offsetof( struct VkDescriptorSetLayoutCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkDescriptorSetLayoutCreateInfo-flags", offsetof( struct VkDescriptorSetLayoutCreateInfo, flags ), sizeof( VkDescriptorSetLayoutCreateFlags ) );
	swigStructField( "VkDescriptorSetLayoutCreateInfo-pBindings", offsetof( struct VkDescriptorSetLayoutCreateInfo, pBindings ), sizeof( VkDescriptorSetLayoutBinding const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDescriptorSetLayoutCreateInfo ) );

	swigComment("VkDescriptorPoolSize\n");
	printf( "begin-structure VkDescriptorPoolSize\n" );
	swigStructField( "VkDescriptorPoolSize-descriptorCount", offsetof( struct VkDescriptorPoolSize, descriptorCount ), sizeof( uint32_t ) );
	swigStructField( "VkDescriptorPoolSize-type", offsetof( struct VkDescriptorPoolSize, type ), sizeof( VkDescriptorType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDescriptorPoolSize ) );

	swigComment("VkDescriptorPoolCreateInfo\n");
	printf( "begin-structure VkDescriptorPoolCreateInfo\n" );
	swigStructField( "VkDescriptorPoolCreateInfo-pNext", offsetof( struct VkDescriptorPoolCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkDescriptorPoolCreateInfo-maxSets", offsetof( struct VkDescriptorPoolCreateInfo, maxSets ), sizeof( uint32_t ) );
	swigStructField( "VkDescriptorPoolCreateInfo-poolSizeCount", offsetof( struct VkDescriptorPoolCreateInfo, poolSizeCount ), sizeof( uint32_t ) );
	swigStructField( "VkDescriptorPoolCreateInfo-sType", offsetof( struct VkDescriptorPoolCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkDescriptorPoolCreateInfo-flags", offsetof( struct VkDescriptorPoolCreateInfo, flags ), sizeof( VkDescriptorPoolCreateFlags ) );
	swigStructField( "VkDescriptorPoolCreateInfo-pPoolSizes", offsetof( struct VkDescriptorPoolCreateInfo, pPoolSizes ), sizeof( VkDescriptorPoolSize const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDescriptorPoolCreateInfo ) );

	swigComment("VkDescriptorSetAllocateInfo\n");
	printf( "begin-structure VkDescriptorSetAllocateInfo\n" );
	swigStructField( "VkDescriptorSetAllocateInfo-pNext", offsetof( struct VkDescriptorSetAllocateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkDescriptorSetAllocateInfo-descriptorPool", offsetof( struct VkDescriptorSetAllocateInfo, descriptorPool ), sizeof( VkDescriptorPool ) );
	swigStructField( "VkDescriptorSetAllocateInfo-pSetLayouts", offsetof( struct VkDescriptorSetAllocateInfo, pSetLayouts ), sizeof( VkDescriptorSetLayout const * ) );
	swigStructField( "VkDescriptorSetAllocateInfo-sType", offsetof( struct VkDescriptorSetAllocateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkDescriptorSetAllocateInfo-descriptorSetCount", offsetof( struct VkDescriptorSetAllocateInfo, descriptorSetCount ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDescriptorSetAllocateInfo ) );

	swigComment("VkDescriptorImageInfo\n");
	printf( "begin-structure VkDescriptorImageInfo\n" );
	swigStructField( "VkDescriptorImageInfo-sampler", offsetof( struct VkDescriptorImageInfo, sampler ), sizeof( VkSampler ) );
	swigStructField( "VkDescriptorImageInfo-imageLayout", offsetof( struct VkDescriptorImageInfo, imageLayout ), sizeof( VkImageLayout ) );
	swigStructField( "VkDescriptorImageInfo-imageView", offsetof( struct VkDescriptorImageInfo, imageView ), sizeof( VkImageView ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDescriptorImageInfo ) );

	swigComment("VkDescriptorBufferInfo\n");
	printf( "begin-structure VkDescriptorBufferInfo\n" );
	swigStructField( "VkDescriptorBufferInfo-buffer", offsetof( struct VkDescriptorBufferInfo, buffer ), sizeof( VkBuffer ) );
	swigStructField( "VkDescriptorBufferInfo-offset", offsetof( struct VkDescriptorBufferInfo, offset ), sizeof( VkDeviceSize ) );
	swigStructField( "VkDescriptorBufferInfo-range", offsetof( struct VkDescriptorBufferInfo, range ), sizeof( VkDeviceSize ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDescriptorBufferInfo ) );

	swigComment("VkWriteDescriptorSet\n");
	printf( "begin-structure VkWriteDescriptorSet\n" );
	swigStructField( "VkWriteDescriptorSet-dstArrayElement", offsetof( struct VkWriteDescriptorSet, dstArrayElement ), sizeof( uint32_t ) );
	swigStructField( "VkWriteDescriptorSet-pNext", offsetof( struct VkWriteDescriptorSet, pNext ), sizeof( void const * ) );
	swigStructField( "VkWriteDescriptorSet-descriptorCount", offsetof( struct VkWriteDescriptorSet, descriptorCount ), sizeof( uint32_t ) );
	swigStructField( "VkWriteDescriptorSet-dstBinding", offsetof( struct VkWriteDescriptorSet, dstBinding ), sizeof( uint32_t ) );
	swigStructField( "VkWriteDescriptorSet-dstSet", offsetof( struct VkWriteDescriptorSet, dstSet ), sizeof( VkDescriptorSet ) );
	swigStructField( "VkWriteDescriptorSet-descriptorType", offsetof( struct VkWriteDescriptorSet, descriptorType ), sizeof( VkDescriptorType ) );
	swigStructField( "VkWriteDescriptorSet-sType", offsetof( struct VkWriteDescriptorSet, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkWriteDescriptorSet-pImageInfo", offsetof( struct VkWriteDescriptorSet, pImageInfo ), sizeof( VkDescriptorImageInfo const * ) );
	swigStructField( "VkWriteDescriptorSet-pBufferInfo", offsetof( struct VkWriteDescriptorSet, pBufferInfo ), sizeof( VkDescriptorBufferInfo const * ) );
	swigStructField( "VkWriteDescriptorSet-pTexelBufferView", offsetof( struct VkWriteDescriptorSet, pTexelBufferView ), sizeof( VkBufferView const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkWriteDescriptorSet ) );

	swigComment("VkCopyDescriptorSet\n");
	printf( "begin-structure VkCopyDescriptorSet\n" );
	swigStructField( "VkCopyDescriptorSet-srcArrayElement", offsetof( struct VkCopyDescriptorSet, srcArrayElement ), sizeof( uint32_t ) );
	swigStructField( "VkCopyDescriptorSet-dstArrayElement", offsetof( struct VkCopyDescriptorSet, dstArrayElement ), sizeof( uint32_t ) );
	swigStructField( "VkCopyDescriptorSet-pNext", offsetof( struct VkCopyDescriptorSet, pNext ), sizeof( void const * ) );
	swigStructField( "VkCopyDescriptorSet-descriptorCount", offsetof( struct VkCopyDescriptorSet, descriptorCount ), sizeof( uint32_t ) );
	swigStructField( "VkCopyDescriptorSet-srcBinding", offsetof( struct VkCopyDescriptorSet, srcBinding ), sizeof( uint32_t ) );
	swigStructField( "VkCopyDescriptorSet-dstBinding", offsetof( struct VkCopyDescriptorSet, dstBinding ), sizeof( uint32_t ) );
	swigStructField( "VkCopyDescriptorSet-dstSet", offsetof( struct VkCopyDescriptorSet, dstSet ), sizeof( VkDescriptorSet ) );
	swigStructField( "VkCopyDescriptorSet-sType", offsetof( struct VkCopyDescriptorSet, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkCopyDescriptorSet-srcSet", offsetof( struct VkCopyDescriptorSet, srcSet ), sizeof( VkDescriptorSet ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkCopyDescriptorSet ) );

	swigComment("VkFramebufferCreateInfo\n");
	printf( "begin-structure VkFramebufferCreateInfo\n" );
	swigStructField( "VkFramebufferCreateInfo-renderPass", offsetof( struct VkFramebufferCreateInfo, renderPass ), sizeof( VkRenderPass ) );
	swigStructField( "VkFramebufferCreateInfo-pNext", offsetof( struct VkFramebufferCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkFramebufferCreateInfo-pAttachments", offsetof( struct VkFramebufferCreateInfo, pAttachments ), sizeof( VkImageView const * ) );
	swigStructField( "VkFramebufferCreateInfo-height", offsetof( struct VkFramebufferCreateInfo, height ), sizeof( uint32_t ) );
	swigStructField( "VkFramebufferCreateInfo-sType", offsetof( struct VkFramebufferCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkFramebufferCreateInfo-flags", offsetof( struct VkFramebufferCreateInfo, flags ), sizeof( VkFramebufferCreateFlags ) );
	swigStructField( "VkFramebufferCreateInfo-width", offsetof( struct VkFramebufferCreateInfo, width ), sizeof( uint32_t ) );
	swigStructField( "VkFramebufferCreateInfo-layers", offsetof( struct VkFramebufferCreateInfo, layers ), sizeof( uint32_t ) );
	swigStructField( "VkFramebufferCreateInfo-attachmentCount", offsetof( struct VkFramebufferCreateInfo, attachmentCount ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkFramebufferCreateInfo ) );

	swigComment("VkAttachmentDescription\n");
	printf( "begin-structure VkAttachmentDescription\n" );
	swigStructField( "VkAttachmentDescription-initialLayout", offsetof( struct VkAttachmentDescription, initialLayout ), sizeof( VkImageLayout ) );
	swigStructField( "VkAttachmentDescription-finalLayout", offsetof( struct VkAttachmentDescription, finalLayout ), sizeof( VkImageLayout ) );
	swigStructField( "VkAttachmentDescription-storeOp", offsetof( struct VkAttachmentDescription, storeOp ), sizeof( VkAttachmentStoreOp ) );
	swigStructField( "VkAttachmentDescription-stencilLoadOp", offsetof( struct VkAttachmentDescription, stencilLoadOp ), sizeof( VkAttachmentLoadOp ) );
	swigStructField( "VkAttachmentDescription-stencilStoreOp", offsetof( struct VkAttachmentDescription, stencilStoreOp ), sizeof( VkAttachmentStoreOp ) );
	swigStructField( "VkAttachmentDescription-samples", offsetof( struct VkAttachmentDescription, samples ), sizeof( VkSampleCountFlagBits ) );
	swigStructField( "VkAttachmentDescription-loadOp", offsetof( struct VkAttachmentDescription, loadOp ), sizeof( VkAttachmentLoadOp ) );
	swigStructField( "VkAttachmentDescription-flags", offsetof( struct VkAttachmentDescription, flags ), sizeof( VkAttachmentDescriptionFlags ) );
	swigStructField( "VkAttachmentDescription-format", offsetof( struct VkAttachmentDescription, format ), sizeof( VkFormat ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkAttachmentDescription ) );

	swigComment("VkAttachmentReference\n");
	printf( "begin-structure VkAttachmentReference\n" );
	swigStructField( "VkAttachmentReference-attachment", offsetof( struct VkAttachmentReference, attachment ), sizeof( uint32_t ) );
	swigStructField( "VkAttachmentReference-layout", offsetof( struct VkAttachmentReference, layout ), sizeof( VkImageLayout ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkAttachmentReference ) );

	swigComment("VkSubpassDescription\n");
	printf( "begin-structure VkSubpassDescription\n" );
	swigStructField( "VkSubpassDescription-pInputAttachments", offsetof( struct VkSubpassDescription, pInputAttachments ), sizeof( VkAttachmentReference const * ) );
	swigStructField( "VkSubpassDescription-pColorAttachments", offsetof( struct VkSubpassDescription, pColorAttachments ), sizeof( VkAttachmentReference const * ) );
	swigStructField( "VkSubpassDescription-pResolveAttachments", offsetof( struct VkSubpassDescription, pResolveAttachments ), sizeof( VkAttachmentReference const * ) );
	swigStructField( "VkSubpassDescription-pDepthStencilAttachment", offsetof( struct VkSubpassDescription, pDepthStencilAttachment ), sizeof( VkAttachmentReference const * ) );
	swigStructField( "VkSubpassDescription-pPreserveAttachments", offsetof( struct VkSubpassDescription, pPreserveAttachments ), sizeof( uint32_t const * ) );
	swigStructField( "VkSubpassDescription-pipelineBindPoint", offsetof( struct VkSubpassDescription, pipelineBindPoint ), sizeof( VkPipelineBindPoint ) );
	swigStructField( "VkSubpassDescription-flags", offsetof( struct VkSubpassDescription, flags ), sizeof( VkSubpassDescriptionFlags ) );
	swigStructField( "VkSubpassDescription-inputAttachmentCount", offsetof( struct VkSubpassDescription, inputAttachmentCount ), sizeof( uint32_t ) );
	swigStructField( "VkSubpassDescription-colorAttachmentCount", offsetof( struct VkSubpassDescription, colorAttachmentCount ), sizeof( uint32_t ) );
	swigStructField( "VkSubpassDescription-preserveAttachmentCount", offsetof( struct VkSubpassDescription, preserveAttachmentCount ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSubpassDescription ) );

	swigComment("VkSubpassDependency\n");
	printf( "begin-structure VkSubpassDependency\n" );
	swigStructField( "VkSubpassDependency-srcStageMask", offsetof( struct VkSubpassDependency, srcStageMask ), sizeof( VkPipelineStageFlags ) );
	swigStructField( "VkSubpassDependency-dstStageMask", offsetof( struct VkSubpassDependency, dstStageMask ), sizeof( VkPipelineStageFlags ) );
	swigStructField( "VkSubpassDependency-dependencyFlags", offsetof( struct VkSubpassDependency, dependencyFlags ), sizeof( VkDependencyFlags ) );
	swigStructField( "VkSubpassDependency-srcSubpass", offsetof( struct VkSubpassDependency, srcSubpass ), sizeof( uint32_t ) );
	swigStructField( "VkSubpassDependency-dstSubpass", offsetof( struct VkSubpassDependency, dstSubpass ), sizeof( uint32_t ) );
	swigStructField( "VkSubpassDependency-srcAccessMask", offsetof( struct VkSubpassDependency, srcAccessMask ), sizeof( VkAccessFlags ) );
	swigStructField( "VkSubpassDependency-dstAccessMask", offsetof( struct VkSubpassDependency, dstAccessMask ), sizeof( VkAccessFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSubpassDependency ) );

	swigComment("VkRenderPassCreateInfo\n");
	printf( "begin-structure VkRenderPassCreateInfo\n" );
	swigStructField( "VkRenderPassCreateInfo-pNext", offsetof( struct VkRenderPassCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkRenderPassCreateInfo-pAttachments", offsetof( struct VkRenderPassCreateInfo, pAttachments ), sizeof( VkAttachmentDescription const * ) );
	swigStructField( "VkRenderPassCreateInfo-dependencyCount", offsetof( struct VkRenderPassCreateInfo, dependencyCount ), sizeof( uint32_t ) );
	swigStructField( "VkRenderPassCreateInfo-subpassCount", offsetof( struct VkRenderPassCreateInfo, subpassCount ), sizeof( uint32_t ) );
	swigStructField( "VkRenderPassCreateInfo-pSubpasses", offsetof( struct VkRenderPassCreateInfo, pSubpasses ), sizeof( VkSubpassDescription const * ) );
	swigStructField( "VkRenderPassCreateInfo-sType", offsetof( struct VkRenderPassCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkRenderPassCreateInfo-flags", offsetof( struct VkRenderPassCreateInfo, flags ), sizeof( VkRenderPassCreateFlags ) );
	swigStructField( "VkRenderPassCreateInfo-pDependencies", offsetof( struct VkRenderPassCreateInfo, pDependencies ), sizeof( VkSubpassDependency const * ) );
	swigStructField( "VkRenderPassCreateInfo-attachmentCount", offsetof( struct VkRenderPassCreateInfo, attachmentCount ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkRenderPassCreateInfo ) );

	swigComment("VkCommandPoolCreateInfo\n");
	printf( "begin-structure VkCommandPoolCreateInfo\n" );
	swigStructField( "VkCommandPoolCreateInfo-pNext", offsetof( struct VkCommandPoolCreateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkCommandPoolCreateInfo-queueFamilyIndex", offsetof( struct VkCommandPoolCreateInfo, queueFamilyIndex ), sizeof( uint32_t ) );
	swigStructField( "VkCommandPoolCreateInfo-sType", offsetof( struct VkCommandPoolCreateInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkCommandPoolCreateInfo-flags", offsetof( struct VkCommandPoolCreateInfo, flags ), sizeof( VkCommandPoolCreateFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkCommandPoolCreateInfo ) );

	swigComment("VkCommandBufferAllocateInfo\n");
	printf( "begin-structure VkCommandBufferAllocateInfo\n" );
	swigStructField( "VkCommandBufferAllocateInfo-level", offsetof( struct VkCommandBufferAllocateInfo, level ), sizeof( VkCommandBufferLevel ) );
	swigStructField( "VkCommandBufferAllocateInfo-pNext", offsetof( struct VkCommandBufferAllocateInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkCommandBufferAllocateInfo-commandPool", offsetof( struct VkCommandBufferAllocateInfo, commandPool ), sizeof( VkCommandPool ) );
	swigStructField( "VkCommandBufferAllocateInfo-commandBufferCount", offsetof( struct VkCommandBufferAllocateInfo, commandBufferCount ), sizeof( uint32_t ) );
	swigStructField( "VkCommandBufferAllocateInfo-sType", offsetof( struct VkCommandBufferAllocateInfo, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkCommandBufferAllocateInfo ) );

	swigComment("VkCommandBufferInheritanceInfo\n");
	printf( "begin-structure VkCommandBufferInheritanceInfo\n" );
	swigStructField( "VkCommandBufferInheritanceInfo-renderPass", offsetof( struct VkCommandBufferInheritanceInfo, renderPass ), sizeof( VkRenderPass ) );
	swigStructField( "VkCommandBufferInheritanceInfo-pipelineStatistics", offsetof( struct VkCommandBufferInheritanceInfo, pipelineStatistics ), sizeof( VkQueryPipelineStatisticFlags ) );
	swigStructField( "VkCommandBufferInheritanceInfo-pNext", offsetof( struct VkCommandBufferInheritanceInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkCommandBufferInheritanceInfo-framebuffer", offsetof( struct VkCommandBufferInheritanceInfo, framebuffer ), sizeof( VkFramebuffer ) );
	swigStructField( "VkCommandBufferInheritanceInfo-occlusionQueryEnable", offsetof( struct VkCommandBufferInheritanceInfo, occlusionQueryEnable ), sizeof( VkBool32 ) );
	swigStructField( "VkCommandBufferInheritanceInfo-sType", offsetof( struct VkCommandBufferInheritanceInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkCommandBufferInheritanceInfo-queryFlags", offsetof( struct VkCommandBufferInheritanceInfo, queryFlags ), sizeof( VkQueryControlFlags ) );
	swigStructField( "VkCommandBufferInheritanceInfo-subpass", offsetof( struct VkCommandBufferInheritanceInfo, subpass ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkCommandBufferInheritanceInfo ) );

	swigComment("VkCommandBufferBeginInfo\n");
	printf( "begin-structure VkCommandBufferBeginInfo\n" );
	swigStructField( "VkCommandBufferBeginInfo-pNext", offsetof( struct VkCommandBufferBeginInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkCommandBufferBeginInfo-sType", offsetof( struct VkCommandBufferBeginInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkCommandBufferBeginInfo-flags", offsetof( struct VkCommandBufferBeginInfo, flags ), sizeof( VkCommandBufferUsageFlags ) );
	swigStructField( "VkCommandBufferBeginInfo-pInheritanceInfo", offsetof( struct VkCommandBufferBeginInfo, pInheritanceInfo ), sizeof( VkCommandBufferInheritanceInfo const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkCommandBufferBeginInfo ) );

	swigComment("VkBufferCopy\n");
	printf( "begin-structure VkBufferCopy\n" );
	swigStructField( "VkBufferCopy-dstOffset", offsetof( struct VkBufferCopy, dstOffset ), sizeof( VkDeviceSize ) );
	swigStructField( "VkBufferCopy-srcOffset", offsetof( struct VkBufferCopy, srcOffset ), sizeof( VkDeviceSize ) );
	swigStructField( "VkBufferCopy-size", offsetof( struct VkBufferCopy, size ), sizeof( VkDeviceSize ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkBufferCopy ) );

	swigComment("VkImageSubresourceLayers\n");
	printf( "begin-structure VkImageSubresourceLayers\n" );
	swigStructField( "VkImageSubresourceLayers-baseArrayLayer", offsetof( struct VkImageSubresourceLayers, baseArrayLayer ), sizeof( uint32_t ) );
	swigStructField( "VkImageSubresourceLayers-layerCount", offsetof( struct VkImageSubresourceLayers, layerCount ), sizeof( uint32_t ) );
	swigStructField( "VkImageSubresourceLayers-mipLevel", offsetof( struct VkImageSubresourceLayers, mipLevel ), sizeof( uint32_t ) );
	swigStructField( "VkImageSubresourceLayers-aspectMask", offsetof( struct VkImageSubresourceLayers, aspectMask ), sizeof( VkImageAspectFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkImageSubresourceLayers ) );

	swigComment("VkImageCopy\n");
	printf( "begin-structure VkImageCopy\n" );
	swigStructField( "VkImageCopy-extent", offsetof( struct VkImageCopy, extent ), sizeof( VkExtent3D ) );
	swigStructField( "VkImageCopy-srcSubresource", offsetof( struct VkImageCopy, srcSubresource ), sizeof( VkImageSubresourceLayers ) );
	swigStructField( "VkImageCopy-dstSubresource", offsetof( struct VkImageCopy, dstSubresource ), sizeof( VkImageSubresourceLayers ) );
	swigStructField( "VkImageCopy-dstOffset", offsetof( struct VkImageCopy, dstOffset ), sizeof( VkOffset3D ) );
	swigStructField( "VkImageCopy-srcOffset", offsetof( struct VkImageCopy, srcOffset ), sizeof( VkOffset3D ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkImageCopy ) );

	swigComment("VkImageBlit\n");
	printf( "begin-structure VkImageBlit\n" );
	swigStructField( "VkImageBlit-srcOffsets", offsetof( struct VkImageBlit, srcOffsets ), sizeof( VkOffset3D [2] ) );
	swigStructField( "VkImageBlit-dstOffsets", offsetof( struct VkImageBlit, dstOffsets ), sizeof( VkOffset3D [2] ) );
	swigStructField( "VkImageBlit-srcSubresource", offsetof( struct VkImageBlit, srcSubresource ), sizeof( VkImageSubresourceLayers ) );
	swigStructField( "VkImageBlit-dstSubresource", offsetof( struct VkImageBlit, dstSubresource ), sizeof( VkImageSubresourceLayers ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkImageBlit ) );

	swigComment("VkBufferImageCopy\n");
	printf( "begin-structure VkBufferImageCopy\n" );
	swigStructField( "VkBufferImageCopy-imageExtent", offsetof( struct VkBufferImageCopy, imageExtent ), sizeof( VkExtent3D ) );
	swigStructField( "VkBufferImageCopy-imageSubresource", offsetof( struct VkBufferImageCopy, imageSubresource ), sizeof( VkImageSubresourceLayers ) );
	swigStructField( "VkBufferImageCopy-bufferOffset", offsetof( struct VkBufferImageCopy, bufferOffset ), sizeof( VkDeviceSize ) );
	swigStructField( "VkBufferImageCopy-imageOffset", offsetof( struct VkBufferImageCopy, imageOffset ), sizeof( VkOffset3D ) );
	swigStructField( "VkBufferImageCopy-bufferRowLength", offsetof( struct VkBufferImageCopy, bufferRowLength ), sizeof( uint32_t ) );
	swigStructField( "VkBufferImageCopy-bufferImageHeight", offsetof( struct VkBufferImageCopy, bufferImageHeight ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkBufferImageCopy ) );

	swigComment("VkClearColorValue\n");
	printf( "begin-structure VkClearColorValue\n" );
	swigStructField( "VkClearColorValue-int32", offsetof( union VkClearColorValue, int32 ), sizeof( int32_t [4] ) );
	swigStructField( "VkClearColorValue-float32", offsetof( union VkClearColorValue, float32 ), sizeof( float [4] ) );
	swigStructField( "VkClearColorValue-uint32", offsetof( union VkClearColorValue, uint32 ), sizeof( uint32_t [4] ) );
	printf( "drop %zu end-structure\n", sizeof( union VkClearColorValue ) );

	swigComment("VkClearDepthStencilValue\n");
	printf( "begin-structure VkClearDepthStencilValue\n" );
	swigStructField( "VkClearDepthStencilValue-depth", offsetof( struct VkClearDepthStencilValue, depth ), sizeof( float ) );
	swigStructField( "VkClearDepthStencilValue-stencil", offsetof( struct VkClearDepthStencilValue, stencil ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkClearDepthStencilValue ) );

	swigComment("VkClearValue\n");
	printf( "begin-structure VkClearValue\n" );
	swigStructField( "VkClearValue-color", offsetof( union VkClearValue, color ), sizeof( VkClearColorValue ) );
	swigStructField( "VkClearValue-depthStencil", offsetof( union VkClearValue, depthStencil ), sizeof( VkClearDepthStencilValue ) );
	printf( "drop %zu end-structure\n", sizeof( union VkClearValue ) );

	swigComment("VkClearAttachment\n");
	printf( "begin-structure VkClearAttachment\n" );
	swigStructField( "VkClearAttachment-colorAttachment", offsetof( struct VkClearAttachment, colorAttachment ), sizeof( uint32_t ) );
	swigStructField( "VkClearAttachment-clearValue", offsetof( struct VkClearAttachment, clearValue ), sizeof( VkClearValue ) );
	swigStructField( "VkClearAttachment-aspectMask", offsetof( struct VkClearAttachment, aspectMask ), sizeof( VkImageAspectFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkClearAttachment ) );

	swigComment("VkClearRect\n");
	printf( "begin-structure VkClearRect\n" );
	swigStructField( "VkClearRect-baseArrayLayer", offsetof( struct VkClearRect, baseArrayLayer ), sizeof( uint32_t ) );
	swigStructField( "VkClearRect-layerCount", offsetof( struct VkClearRect, layerCount ), sizeof( uint32_t ) );
	swigStructField( "VkClearRect-rect", offsetof( struct VkClearRect, rect ), sizeof( VkRect2D ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkClearRect ) );

	swigComment("VkImageResolve\n");
	printf( "begin-structure VkImageResolve\n" );
	swigStructField( "VkImageResolve-extent", offsetof( struct VkImageResolve, extent ), sizeof( VkExtent3D ) );
	swigStructField( "VkImageResolve-srcSubresource", offsetof( struct VkImageResolve, srcSubresource ), sizeof( VkImageSubresourceLayers ) );
	swigStructField( "VkImageResolve-dstSubresource", offsetof( struct VkImageResolve, dstSubresource ), sizeof( VkImageSubresourceLayers ) );
	swigStructField( "VkImageResolve-dstOffset", offsetof( struct VkImageResolve, dstOffset ), sizeof( VkOffset3D ) );
	swigStructField( "VkImageResolve-srcOffset", offsetof( struct VkImageResolve, srcOffset ), sizeof( VkOffset3D ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkImageResolve ) );

	swigComment("VkMemoryBarrier\n");
	printf( "begin-structure VkMemoryBarrier\n" );
	swigStructField( "VkMemoryBarrier-pNext", offsetof( struct VkMemoryBarrier, pNext ), sizeof( void const * ) );
	swigStructField( "VkMemoryBarrier-sType", offsetof( struct VkMemoryBarrier, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkMemoryBarrier-srcAccessMask", offsetof( struct VkMemoryBarrier, srcAccessMask ), sizeof( VkAccessFlags ) );
	swigStructField( "VkMemoryBarrier-dstAccessMask", offsetof( struct VkMemoryBarrier, dstAccessMask ), sizeof( VkAccessFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkMemoryBarrier ) );

	swigComment("VkBufferMemoryBarrier\n");
	printf( "begin-structure VkBufferMemoryBarrier\n" );
	swigStructField( "VkBufferMemoryBarrier-pNext", offsetof( struct VkBufferMemoryBarrier, pNext ), sizeof( void const * ) );
	swigStructField( "VkBufferMemoryBarrier-srcQueueFamilyIndex", offsetof( struct VkBufferMemoryBarrier, srcQueueFamilyIndex ), sizeof( uint32_t ) );
	swigStructField( "VkBufferMemoryBarrier-dstQueueFamilyIndex", offsetof( struct VkBufferMemoryBarrier, dstQueueFamilyIndex ), sizeof( uint32_t ) );
	swigStructField( "VkBufferMemoryBarrier-buffer", offsetof( struct VkBufferMemoryBarrier, buffer ), sizeof( VkBuffer ) );
	swigStructField( "VkBufferMemoryBarrier-offset", offsetof( struct VkBufferMemoryBarrier, offset ), sizeof( VkDeviceSize ) );
	swigStructField( "VkBufferMemoryBarrier-size", offsetof( struct VkBufferMemoryBarrier, size ), sizeof( VkDeviceSize ) );
	swigStructField( "VkBufferMemoryBarrier-sType", offsetof( struct VkBufferMemoryBarrier, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkBufferMemoryBarrier-srcAccessMask", offsetof( struct VkBufferMemoryBarrier, srcAccessMask ), sizeof( VkAccessFlags ) );
	swigStructField( "VkBufferMemoryBarrier-dstAccessMask", offsetof( struct VkBufferMemoryBarrier, dstAccessMask ), sizeof( VkAccessFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkBufferMemoryBarrier ) );

	swigComment("VkImageMemoryBarrier\n");
	printf( "begin-structure VkImageMemoryBarrier\n" );
	swigStructField( "VkImageMemoryBarrier-pNext", offsetof( struct VkImageMemoryBarrier, pNext ), sizeof( void const * ) );
	swigStructField( "VkImageMemoryBarrier-srcQueueFamilyIndex", offsetof( struct VkImageMemoryBarrier, srcQueueFamilyIndex ), sizeof( uint32_t ) );
	swigStructField( "VkImageMemoryBarrier-dstQueueFamilyIndex", offsetof( struct VkImageMemoryBarrier, dstQueueFamilyIndex ), sizeof( uint32_t ) );
	swigStructField( "VkImageMemoryBarrier-oldLayout", offsetof( struct VkImageMemoryBarrier, oldLayout ), sizeof( VkImageLayout ) );
	swigStructField( "VkImageMemoryBarrier-newLayout", offsetof( struct VkImageMemoryBarrier, newLayout ), sizeof( VkImageLayout ) );
	swigStructField( "VkImageMemoryBarrier-image", offsetof( struct VkImageMemoryBarrier, image ), sizeof( VkImage ) );
	swigStructField( "VkImageMemoryBarrier-sType", offsetof( struct VkImageMemoryBarrier, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkImageMemoryBarrier-srcAccessMask", offsetof( struct VkImageMemoryBarrier, srcAccessMask ), sizeof( VkAccessFlags ) );
	swigStructField( "VkImageMemoryBarrier-dstAccessMask", offsetof( struct VkImageMemoryBarrier, dstAccessMask ), sizeof( VkAccessFlags ) );
	swigStructField( "VkImageMemoryBarrier-subresourceRange", offsetof( struct VkImageMemoryBarrier, subresourceRange ), sizeof( VkImageSubresourceRange ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkImageMemoryBarrier ) );

	swigComment("VkRenderPassBeginInfo\n");
	printf( "begin-structure VkRenderPassBeginInfo\n" );
	swigStructField( "VkRenderPassBeginInfo-renderPass", offsetof( struct VkRenderPassBeginInfo, renderPass ), sizeof( VkRenderPass ) );
	swigStructField( "VkRenderPassBeginInfo-pNext", offsetof( struct VkRenderPassBeginInfo, pNext ), sizeof( void const * ) );
	swigStructField( "VkRenderPassBeginInfo-framebuffer", offsetof( struct VkRenderPassBeginInfo, framebuffer ), sizeof( VkFramebuffer ) );
	swigStructField( "VkRenderPassBeginInfo-renderArea", offsetof( struct VkRenderPassBeginInfo, renderArea ), sizeof( VkRect2D ) );
	swigStructField( "VkRenderPassBeginInfo-clearValueCount", offsetof( struct VkRenderPassBeginInfo, clearValueCount ), sizeof( uint32_t ) );
	swigStructField( "VkRenderPassBeginInfo-sType", offsetof( struct VkRenderPassBeginInfo, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkRenderPassBeginInfo-pClearValues", offsetof( struct VkRenderPassBeginInfo, pClearValues ), sizeof( VkClearValue const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkRenderPassBeginInfo ) );

	swigComment("VkDispatchIndirectCommand\n");
	printf( "begin-structure VkDispatchIndirectCommand\n" );
	swigStructField( "VkDispatchIndirectCommand-x", offsetof( struct VkDispatchIndirectCommand, x ), sizeof( uint32_t ) );
	swigStructField( "VkDispatchIndirectCommand-y", offsetof( struct VkDispatchIndirectCommand, y ), sizeof( uint32_t ) );
	swigStructField( "VkDispatchIndirectCommand-z", offsetof( struct VkDispatchIndirectCommand, z ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDispatchIndirectCommand ) );

	swigComment("VkDrawIndexedIndirectCommand\n");
	printf( "begin-structure VkDrawIndexedIndirectCommand\n" );
	swigStructField( "VkDrawIndexedIndirectCommand-firstInstance", offsetof( struct VkDrawIndexedIndirectCommand, firstInstance ), sizeof( uint32_t ) );
	swigStructField( "VkDrawIndexedIndirectCommand-vertexOffset", offsetof( struct VkDrawIndexedIndirectCommand, vertexOffset ), sizeof( int32_t ) );
	swigStructField( "VkDrawIndexedIndirectCommand-instanceCount", offsetof( struct VkDrawIndexedIndirectCommand, instanceCount ), sizeof( uint32_t ) );
	swigStructField( "VkDrawIndexedIndirectCommand-firstIndex", offsetof( struct VkDrawIndexedIndirectCommand, firstIndex ), sizeof( uint32_t ) );
	swigStructField( "VkDrawIndexedIndirectCommand-indexCount", offsetof( struct VkDrawIndexedIndirectCommand, indexCount ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDrawIndexedIndirectCommand ) );

	swigComment("VkDrawIndirectCommand\n");
	printf( "begin-structure VkDrawIndirectCommand\n" );
	swigStructField( "VkDrawIndirectCommand-firstInstance", offsetof( struct VkDrawIndirectCommand, firstInstance ), sizeof( uint32_t ) );
	swigStructField( "VkDrawIndirectCommand-firstVertex", offsetof( struct VkDrawIndirectCommand, firstVertex ), sizeof( uint32_t ) );
	swigStructField( "VkDrawIndirectCommand-instanceCount", offsetof( struct VkDrawIndirectCommand, instanceCount ), sizeof( uint32_t ) );
	swigStructField( "VkDrawIndirectCommand-vertexCount", offsetof( struct VkDrawIndirectCommand, vertexCount ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDrawIndirectCommand ) );

	swigComment("VkSurfaceCapabilitiesKHR\n");
	printf( "begin-structure VkSurfaceCapabilitiesKHR\n" );
	swigStructField( "VkSurfaceCapabilitiesKHR-minImageExtent", offsetof( struct VkSurfaceCapabilitiesKHR, minImageExtent ), sizeof( VkExtent2D ) );
	swigStructField( "VkSurfaceCapabilitiesKHR-maxImageExtent", offsetof( struct VkSurfaceCapabilitiesKHR, maxImageExtent ), sizeof( VkExtent2D ) );
	swigStructField( "VkSurfaceCapabilitiesKHR-supportedTransforms", offsetof( struct VkSurfaceCapabilitiesKHR, supportedTransforms ), sizeof( VkSurfaceTransformFlagsKHR ) );
	swigStructField( "VkSurfaceCapabilitiesKHR-minImageCount", offsetof( struct VkSurfaceCapabilitiesKHR, minImageCount ), sizeof( uint32_t ) );
	swigStructField( "VkSurfaceCapabilitiesKHR-maxImageCount", offsetof( struct VkSurfaceCapabilitiesKHR, maxImageCount ), sizeof( uint32_t ) );
	swigStructField( "VkSurfaceCapabilitiesKHR-supportedCompositeAlpha", offsetof( struct VkSurfaceCapabilitiesKHR, supportedCompositeAlpha ), sizeof( VkCompositeAlphaFlagsKHR ) );
	swigStructField( "VkSurfaceCapabilitiesKHR-maxImageArrayLayers", offsetof( struct VkSurfaceCapabilitiesKHR, maxImageArrayLayers ), sizeof( uint32_t ) );
	swigStructField( "VkSurfaceCapabilitiesKHR-currentTransform", offsetof( struct VkSurfaceCapabilitiesKHR, currentTransform ), sizeof( VkSurfaceTransformFlagBitsKHR ) );
	swigStructField( "VkSurfaceCapabilitiesKHR-currentExtent", offsetof( struct VkSurfaceCapabilitiesKHR, currentExtent ), sizeof( VkExtent2D ) );
	swigStructField( "VkSurfaceCapabilitiesKHR-supportedUsageFlags", offsetof( struct VkSurfaceCapabilitiesKHR, supportedUsageFlags ), sizeof( VkImageUsageFlags ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSurfaceCapabilitiesKHR ) );

	swigComment("VkSurfaceFormatKHR\n");
	printf( "begin-structure VkSurfaceFormatKHR\n" );
	swigStructField( "VkSurfaceFormatKHR-colorSpace", offsetof( struct VkSurfaceFormatKHR, colorSpace ), sizeof( VkColorSpaceKHR ) );
	swigStructField( "VkSurfaceFormatKHR-format", offsetof( struct VkSurfaceFormatKHR, format ), sizeof( VkFormat ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSurfaceFormatKHR ) );

	swigComment("VkSwapchainCreateInfoKHR\n");
	printf( "begin-structure VkSwapchainCreateInfoKHR\n" );
	swigStructField( "VkSwapchainCreateInfoKHR-preTransform", offsetof( struct VkSwapchainCreateInfoKHR, preTransform ), sizeof( VkSurfaceTransformFlagBitsKHR ) );
	swigStructField( "VkSwapchainCreateInfoKHR-queueFamilyIndexCount", offsetof( struct VkSwapchainCreateInfoKHR, queueFamilyIndexCount ), sizeof( uint32_t ) );
	swigStructField( "VkSwapchainCreateInfoKHR-oldSwapchain", offsetof( struct VkSwapchainCreateInfoKHR, oldSwapchain ), sizeof( VkSwapchainKHR ) );
	swigStructField( "VkSwapchainCreateInfoKHR-imageUsage", offsetof( struct VkSwapchainCreateInfoKHR, imageUsage ), sizeof( VkImageUsageFlags ) );
	swigStructField( "VkSwapchainCreateInfoKHR-pNext", offsetof( struct VkSwapchainCreateInfoKHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkSwapchainCreateInfoKHR-imageFormat", offsetof( struct VkSwapchainCreateInfoKHR, imageFormat ), sizeof( VkFormat ) );
	swigStructField( "VkSwapchainCreateInfoKHR-imageExtent", offsetof( struct VkSwapchainCreateInfoKHR, imageExtent ), sizeof( VkExtent2D ) );
	swigStructField( "VkSwapchainCreateInfoKHR-pQueueFamilyIndices", offsetof( struct VkSwapchainCreateInfoKHR, pQueueFamilyIndices ), sizeof( uint32_t const * ) );
	swigStructField( "VkSwapchainCreateInfoKHR-compositeAlpha", offsetof( struct VkSwapchainCreateInfoKHR, compositeAlpha ), sizeof( VkCompositeAlphaFlagBitsKHR ) );
	swigStructField( "VkSwapchainCreateInfoKHR-imageArrayLayers", offsetof( struct VkSwapchainCreateInfoKHR, imageArrayLayers ), sizeof( uint32_t ) );
	swigStructField( "VkSwapchainCreateInfoKHR-flags", offsetof( struct VkSwapchainCreateInfoKHR, flags ), sizeof( VkSwapchainCreateFlagsKHR ) );
	swigStructField( "VkSwapchainCreateInfoKHR-imageColorSpace", offsetof( struct VkSwapchainCreateInfoKHR, imageColorSpace ), sizeof( VkColorSpaceKHR ) );
	swigStructField( "VkSwapchainCreateInfoKHR-imageSharingMode", offsetof( struct VkSwapchainCreateInfoKHR, imageSharingMode ), sizeof( VkSharingMode ) );
	swigStructField( "VkSwapchainCreateInfoKHR-minImageCount", offsetof( struct VkSwapchainCreateInfoKHR, minImageCount ), sizeof( uint32_t ) );
	swigStructField( "VkSwapchainCreateInfoKHR-surface", offsetof( struct VkSwapchainCreateInfoKHR, surface ), sizeof( VkSurfaceKHR ) );
	swigStructField( "VkSwapchainCreateInfoKHR-presentMode", offsetof( struct VkSwapchainCreateInfoKHR, presentMode ), sizeof( VkPresentModeKHR ) );
	swigStructField( "VkSwapchainCreateInfoKHR-clipped", offsetof( struct VkSwapchainCreateInfoKHR, clipped ), sizeof( VkBool32 ) );
	swigStructField( "VkSwapchainCreateInfoKHR-sType", offsetof( struct VkSwapchainCreateInfoKHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkSwapchainCreateInfoKHR ) );

	swigComment("VkPresentInfoKHR\n");
	printf( "begin-structure VkPresentInfoKHR\n" );
	swigStructField( "VkPresentInfoKHR-swapchainCount", offsetof( struct VkPresentInfoKHR, swapchainCount ), sizeof( uint32_t ) );
	swigStructField( "VkPresentInfoKHR-pNext", offsetof( struct VkPresentInfoKHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkPresentInfoKHR-waitSemaphoreCount", offsetof( struct VkPresentInfoKHR, waitSemaphoreCount ), sizeof( uint32_t ) );
	swigStructField( "VkPresentInfoKHR-pWaitSemaphores", offsetof( struct VkPresentInfoKHR, pWaitSemaphores ), sizeof( VkSemaphore const * ) );
	swigStructField( "VkPresentInfoKHR-pSwapchains", offsetof( struct VkPresentInfoKHR, pSwapchains ), sizeof( VkSwapchainKHR const * ) );
	swigStructField( "VkPresentInfoKHR-pImageIndices", offsetof( struct VkPresentInfoKHR, pImageIndices ), sizeof( uint32_t const * ) );
	swigStructField( "VkPresentInfoKHR-pResults", offsetof( struct VkPresentInfoKHR, pResults ), sizeof( VkResult * ) );
	swigStructField( "VkPresentInfoKHR-sType", offsetof( struct VkPresentInfoKHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPresentInfoKHR ) );

	swigComment("VkDisplayPropertiesKHR\n");
	printf( "begin-structure VkDisplayPropertiesKHR\n" );
	swigStructField( "VkDisplayPropertiesKHR-display", offsetof( struct VkDisplayPropertiesKHR, display ), sizeof( VkDisplayKHR ) );
	swigStructField( "VkDisplayPropertiesKHR-physicalResolution", offsetof( struct VkDisplayPropertiesKHR, physicalResolution ), sizeof( VkExtent2D ) );
	swigStructField( "VkDisplayPropertiesKHR-supportedTransforms", offsetof( struct VkDisplayPropertiesKHR, supportedTransforms ), sizeof( VkSurfaceTransformFlagsKHR ) );
	swigStructField( "VkDisplayPropertiesKHR-persistentContent", offsetof( struct VkDisplayPropertiesKHR, persistentContent ), sizeof( VkBool32 ) );
	swigStructField( "VkDisplayPropertiesKHR-displayName", offsetof( struct VkDisplayPropertiesKHR, displayName ), sizeof( char const * ) );
	swigStructField( "VkDisplayPropertiesKHR-planeReorderPossible", offsetof( struct VkDisplayPropertiesKHR, planeReorderPossible ), sizeof( VkBool32 ) );
	swigStructField( "VkDisplayPropertiesKHR-physicalDimensions", offsetof( struct VkDisplayPropertiesKHR, physicalDimensions ), sizeof( VkExtent2D ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDisplayPropertiesKHR ) );

	swigComment("VkDisplayModeParametersKHR\n");
	printf( "begin-structure VkDisplayModeParametersKHR\n" );
	swigStructField( "VkDisplayModeParametersKHR-refreshRate", offsetof( struct VkDisplayModeParametersKHR, refreshRate ), sizeof( uint32_t ) );
	swigStructField( "VkDisplayModeParametersKHR-visibleRegion", offsetof( struct VkDisplayModeParametersKHR, visibleRegion ), sizeof( VkExtent2D ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDisplayModeParametersKHR ) );

	swigComment("VkDisplayModePropertiesKHR\n");
	printf( "begin-structure VkDisplayModePropertiesKHR\n" );
	swigStructField( "VkDisplayModePropertiesKHR-parameters", offsetof( struct VkDisplayModePropertiesKHR, parameters ), sizeof( VkDisplayModeParametersKHR ) );
	swigStructField( "VkDisplayModePropertiesKHR-displayMode", offsetof( struct VkDisplayModePropertiesKHR, displayMode ), sizeof( VkDisplayModeKHR ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDisplayModePropertiesKHR ) );

	swigComment("VkDisplayModeCreateInfoKHR\n");
	printf( "begin-structure VkDisplayModeCreateInfoKHR\n" );
	swigStructField( "VkDisplayModeCreateInfoKHR-pNext", offsetof( struct VkDisplayModeCreateInfoKHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkDisplayModeCreateInfoKHR-parameters", offsetof( struct VkDisplayModeCreateInfoKHR, parameters ), sizeof( VkDisplayModeParametersKHR ) );
	swigStructField( "VkDisplayModeCreateInfoKHR-sType", offsetof( struct VkDisplayModeCreateInfoKHR, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkDisplayModeCreateInfoKHR-flags", offsetof( struct VkDisplayModeCreateInfoKHR, flags ), sizeof( VkDisplayModeCreateFlagsKHR ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDisplayModeCreateInfoKHR ) );

	swigComment("VkDisplayPlaneCapabilitiesKHR\n");
	printf( "begin-structure VkDisplayPlaneCapabilitiesKHR\n" );
	swigStructField( "VkDisplayPlaneCapabilitiesKHR-supportedAlpha", offsetof( struct VkDisplayPlaneCapabilitiesKHR, supportedAlpha ), sizeof( VkDisplayPlaneAlphaFlagsKHR ) );
	swigStructField( "VkDisplayPlaneCapabilitiesKHR-minSrcExtent", offsetof( struct VkDisplayPlaneCapabilitiesKHR, minSrcExtent ), sizeof( VkExtent2D ) );
	swigStructField( "VkDisplayPlaneCapabilitiesKHR-maxSrcExtent", offsetof( struct VkDisplayPlaneCapabilitiesKHR, maxSrcExtent ), sizeof( VkExtent2D ) );
	swigStructField( "VkDisplayPlaneCapabilitiesKHR-minSrcPosition", offsetof( struct VkDisplayPlaneCapabilitiesKHR, minSrcPosition ), sizeof( VkOffset2D ) );
	swigStructField( "VkDisplayPlaneCapabilitiesKHR-maxSrcPosition", offsetof( struct VkDisplayPlaneCapabilitiesKHR, maxSrcPosition ), sizeof( VkOffset2D ) );
	swigStructField( "VkDisplayPlaneCapabilitiesKHR-minDstPosition", offsetof( struct VkDisplayPlaneCapabilitiesKHR, minDstPosition ), sizeof( VkOffset2D ) );
	swigStructField( "VkDisplayPlaneCapabilitiesKHR-maxDstPosition", offsetof( struct VkDisplayPlaneCapabilitiesKHR, maxDstPosition ), sizeof( VkOffset2D ) );
	swigStructField( "VkDisplayPlaneCapabilitiesKHR-minDstExtent", offsetof( struct VkDisplayPlaneCapabilitiesKHR, minDstExtent ), sizeof( VkExtent2D ) );
	swigStructField( "VkDisplayPlaneCapabilitiesKHR-maxDstExtent", offsetof( struct VkDisplayPlaneCapabilitiesKHR, maxDstExtent ), sizeof( VkExtent2D ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDisplayPlaneCapabilitiesKHR ) );

	swigComment("VkDisplayPlanePropertiesKHR\n");
	printf( "begin-structure VkDisplayPlanePropertiesKHR\n" );
	swigStructField( "VkDisplayPlanePropertiesKHR-currentDisplay", offsetof( struct VkDisplayPlanePropertiesKHR, currentDisplay ), sizeof( VkDisplayKHR ) );
	swigStructField( "VkDisplayPlanePropertiesKHR-currentStackIndex", offsetof( struct VkDisplayPlanePropertiesKHR, currentStackIndex ), sizeof( uint32_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDisplayPlanePropertiesKHR ) );

	swigComment("VkDisplaySurfaceCreateInfoKHR\n");
	printf( "begin-structure VkDisplaySurfaceCreateInfoKHR\n" );
	swigStructField( "VkDisplaySurfaceCreateInfoKHR-planeStackIndex", offsetof( struct VkDisplaySurfaceCreateInfoKHR, planeStackIndex ), sizeof( uint32_t ) );
	swigStructField( "VkDisplaySurfaceCreateInfoKHR-imageExtent", offsetof( struct VkDisplaySurfaceCreateInfoKHR, imageExtent ), sizeof( VkExtent2D ) );
	swigStructField( "VkDisplaySurfaceCreateInfoKHR-pNext", offsetof( struct VkDisplaySurfaceCreateInfoKHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkDisplaySurfaceCreateInfoKHR-alphaMode", offsetof( struct VkDisplaySurfaceCreateInfoKHR, alphaMode ), sizeof( VkDisplayPlaneAlphaFlagBitsKHR ) );
	swigStructField( "VkDisplaySurfaceCreateInfoKHR-globalAlpha", offsetof( struct VkDisplaySurfaceCreateInfoKHR, globalAlpha ), sizeof( float ) );
	swigStructField( "VkDisplaySurfaceCreateInfoKHR-planeIndex", offsetof( struct VkDisplaySurfaceCreateInfoKHR, planeIndex ), sizeof( uint32_t ) );
	swigStructField( "VkDisplaySurfaceCreateInfoKHR-sType", offsetof( struct VkDisplaySurfaceCreateInfoKHR, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkDisplaySurfaceCreateInfoKHR-flags", offsetof( struct VkDisplaySurfaceCreateInfoKHR, flags ), sizeof( VkDisplaySurfaceCreateFlagsKHR ) );
	swigStructField( "VkDisplaySurfaceCreateInfoKHR-transform", offsetof( struct VkDisplaySurfaceCreateInfoKHR, transform ), sizeof( VkSurfaceTransformFlagBitsKHR ) );
	swigStructField( "VkDisplaySurfaceCreateInfoKHR-displayMode", offsetof( struct VkDisplaySurfaceCreateInfoKHR, displayMode ), sizeof( VkDisplayModeKHR ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDisplaySurfaceCreateInfoKHR ) );

	swigComment("VkDisplayPresentInfoKHR\n");
	printf( "begin-structure VkDisplayPresentInfoKHR\n" );
	swigStructField( "VkDisplayPresentInfoKHR-pNext", offsetof( struct VkDisplayPresentInfoKHR, pNext ), sizeof( void const * ) );
	swigStructField( "VkDisplayPresentInfoKHR-persistent", offsetof( struct VkDisplayPresentInfoKHR, persistent ), sizeof( VkBool32 ) );
	swigStructField( "VkDisplayPresentInfoKHR-srcRect", offsetof( struct VkDisplayPresentInfoKHR, srcRect ), sizeof( VkRect2D ) );
	swigStructField( "VkDisplayPresentInfoKHR-dstRect", offsetof( struct VkDisplayPresentInfoKHR, dstRect ), sizeof( VkRect2D ) );
	swigStructField( "VkDisplayPresentInfoKHR-sType", offsetof( struct VkDisplayPresentInfoKHR, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDisplayPresentInfoKHR ) );

	swigComment("VkDebugReportCallbackCreateInfoEXT\n");
	printf( "begin-structure VkDebugReportCallbackCreateInfoEXT\n" );
	swigStructField( "VkDebugReportCallbackCreateInfoEXT-pNext", offsetof( struct VkDebugReportCallbackCreateInfoEXT, pNext ), sizeof( void const * ) );
	swigStructField( "VkDebugReportCallbackCreateInfoEXT-pUserData", offsetof( struct VkDebugReportCallbackCreateInfoEXT, pUserData ), sizeof( void * ) );
	swigStructField( "VkDebugReportCallbackCreateInfoEXT-sType", offsetof( struct VkDebugReportCallbackCreateInfoEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkDebugReportCallbackCreateInfoEXT-flags", offsetof( struct VkDebugReportCallbackCreateInfoEXT, flags ), sizeof( VkDebugReportFlagsEXT ) );
	swigStructField( "VkDebugReportCallbackCreateInfoEXT-pfnCallback", offsetof( struct VkDebugReportCallbackCreateInfoEXT, pfnCallback ), sizeof( PFN_vkDebugReportCallbackEXT ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDebugReportCallbackCreateInfoEXT ) );

	swigComment("VkPipelineRasterizationStateRasterizationOrderAMD\n");
	printf( "begin-structure VkPipelineRasterizationStateRasterizationOrderAMD\n" );
	swigStructField( "VkPipelineRasterizationStateRasterizationOrderAMD-rasterizationOrder", offsetof( struct VkPipelineRasterizationStateRasterizationOrderAMD, rasterizationOrder ), sizeof( VkRasterizationOrderAMD ) );
	swigStructField( "VkPipelineRasterizationStateRasterizationOrderAMD-pNext", offsetof( struct VkPipelineRasterizationStateRasterizationOrderAMD, pNext ), sizeof( void const * ) );
	swigStructField( "VkPipelineRasterizationStateRasterizationOrderAMD-sType", offsetof( struct VkPipelineRasterizationStateRasterizationOrderAMD, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkPipelineRasterizationStateRasterizationOrderAMD ) );

	swigComment("VkDebugMarkerObjectNameInfoEXT\n");
	printf( "begin-structure VkDebugMarkerObjectNameInfoEXT\n" );
	swigStructField( "VkDebugMarkerObjectNameInfoEXT-pNext", offsetof( struct VkDebugMarkerObjectNameInfoEXT, pNext ), sizeof( void const * ) );
	swigStructField( "VkDebugMarkerObjectNameInfoEXT-objectType", offsetof( struct VkDebugMarkerObjectNameInfoEXT, objectType ), sizeof( VkDebugReportObjectTypeEXT ) );
	swigStructField( "VkDebugMarkerObjectNameInfoEXT-object", offsetof( struct VkDebugMarkerObjectNameInfoEXT, object ), sizeof( uint64_t ) );
	swigStructField( "VkDebugMarkerObjectNameInfoEXT-sType", offsetof( struct VkDebugMarkerObjectNameInfoEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkDebugMarkerObjectNameInfoEXT-pObjectName", offsetof( struct VkDebugMarkerObjectNameInfoEXT, pObjectName ), sizeof( char const * ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDebugMarkerObjectNameInfoEXT ) );

	swigComment("VkDebugMarkerObjectTagInfoEXT\n");
	printf( "begin-structure VkDebugMarkerObjectTagInfoEXT\n" );
	swigStructField( "VkDebugMarkerObjectTagInfoEXT-pNext", offsetof( struct VkDebugMarkerObjectTagInfoEXT, pNext ), sizeof( void const * ) );
	swigStructField( "VkDebugMarkerObjectTagInfoEXT-objectType", offsetof( struct VkDebugMarkerObjectTagInfoEXT, objectType ), sizeof( VkDebugReportObjectTypeEXT ) );
	swigStructField( "VkDebugMarkerObjectTagInfoEXT-pTag", offsetof( struct VkDebugMarkerObjectTagInfoEXT, pTag ), sizeof( void const * ) );
	swigStructField( "VkDebugMarkerObjectTagInfoEXT-tagSize", offsetof( struct VkDebugMarkerObjectTagInfoEXT, tagSize ), sizeof( size_t ) );
	swigStructField( "VkDebugMarkerObjectTagInfoEXT-object", offsetof( struct VkDebugMarkerObjectTagInfoEXT, object ), sizeof( uint64_t ) );
	swigStructField( "VkDebugMarkerObjectTagInfoEXT-sType", offsetof( struct VkDebugMarkerObjectTagInfoEXT, sType ), sizeof( VkStructureType ) );
	swigStructField( "VkDebugMarkerObjectTagInfoEXT-tagName", offsetof( struct VkDebugMarkerObjectTagInfoEXT, tagName ), sizeof( uint64_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDebugMarkerObjectTagInfoEXT ) );

	swigComment("VkDebugMarkerMarkerInfoEXT\n");
	printf( "begin-structure VkDebugMarkerMarkerInfoEXT\n" );
	swigStructField( "VkDebugMarkerMarkerInfoEXT-color", offsetof( struct VkDebugMarkerMarkerInfoEXT, color ), sizeof( float [4] ) );
	swigStructField( "VkDebugMarkerMarkerInfoEXT-pNext", offsetof( struct VkDebugMarkerMarkerInfoEXT, pNext ), sizeof( void const * ) );
	swigStructField( "VkDebugMarkerMarkerInfoEXT-pMarkerName", offsetof( struct VkDebugMarkerMarkerInfoEXT, pMarkerName ), sizeof( char const * ) );
	swigStructField( "VkDebugMarkerMarkerInfoEXT-sType", offsetof( struct VkDebugMarkerMarkerInfoEXT, sType ), sizeof( VkStructureType ) );
	printf( "drop %zu end-structure\n", sizeof( struct VkDebugMarkerMarkerInfoEXT ) );

	swigNewline();

	swigComment("------===< callbacks >===-------\n");
	swigCallback( "c-callback PFN_vkAllocationFunction: a u u n -- a", "", "", "" );
	swigCallback( "c-callback PFN_vkReallocationFunction: a a u u n -- a", "", "", "" );
	swigCallback( "c-callback PFN_vkFreeFunction: a a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkInternalAllocationNotification: a u n n -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkInternalFreeNotification: a u n n -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkVoidFunction:  -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkCreateInstance: a a a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkDestroyInstance: a a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkEnumeratePhysicalDevices: a a a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkGetPhysicalDeviceFeatures: a a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkGetPhysicalDeviceFormatProperties: a n a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkGetPhysicalDeviceImageFormatProperties: a n n n u u a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkGetPhysicalDeviceProperties: a a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkGetPhysicalDeviceQueueFamilyProperties: a a a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkGetPhysicalDeviceMemoryProperties: a a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkGetInstanceProcAddr: a s -- a", "", "", "" );
	swigCallback( "c-callback PFN_vkGetDeviceProcAddr: a s -- a", "", "", "" );
	swigCallback( "c-callback PFN_vkCreateDevice: a a a a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkDestroyDevice: a a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkEnumerateInstanceExtensionProperties: s a a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkEnumerateDeviceExtensionProperties: a s a a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkEnumerateInstanceLayerProperties: a a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkEnumerateDeviceLayerProperties: a a a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkGetDeviceQueue: a u u a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkQueueSubmit: a u a a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkQueueWaitIdle: a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkDeviceWaitIdle: a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkAllocateMemory: a a a a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkFreeMemory: a a a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkMapMemory: a a ud ud u a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkUnmapMemory: a a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkFlushMappedMemoryRanges: a u a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkInvalidateMappedMemoryRanges: a u a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkGetDeviceMemoryCommitment: a a a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkBindBufferMemory: a a a ud -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkBindImageMemory: a a a ud -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkGetBufferMemoryRequirements: a a a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkGetImageMemoryRequirements: a a a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkGetImageSparseMemoryRequirements: a a a a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkGetPhysicalDeviceSparseImageFormatProperties: a n n n u n a a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkQueueBindSparse: a u a a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkCreateFence: a a a a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkDestroyFence: a a a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkResetFences: a u a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkGetFenceStatus: a a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkWaitForFences: a u a u ud -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkCreateSemaphore: a a a a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkDestroySemaphore: a a a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkCreateEvent: a a a a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkDestroyEvent: a a a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkGetEventStatus: a a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkSetEvent: a a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkResetEvent: a a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkCreateQueryPool: a a a a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkDestroyQueryPool: a a a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkGetQueryPoolResults: a a u u u a ud u -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkCreateBuffer: a a a a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkDestroyBuffer: a a a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkCreateBufferView: a a a a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkDestroyBufferView: a a a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkCreateImage: a a a a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkDestroyImage: a a a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkGetImageSubresourceLayout: a a a a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkCreateImageView: a a a a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkDestroyImageView: a a a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkCreateShaderModule: a a a a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkDestroyShaderModule: a a a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkCreatePipelineCache: a a a a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkDestroyPipelineCache: a a a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkGetPipelineCacheData: a a a a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkMergePipelineCaches: a a u a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkCreateGraphicsPipelines: a a u a a a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkCreateComputePipelines: a a u a a a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkDestroyPipeline: a a a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkCreatePipelineLayout: a a a a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkDestroyPipelineLayout: a a a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkCreateSampler: a a a a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkDestroySampler: a a a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkCreateDescriptorSetLayout: a a a a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkDestroyDescriptorSetLayout: a a a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkCreateDescriptorPool: a a a a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkDestroyDescriptorPool: a a a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkResetDescriptorPool: a a u -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkAllocateDescriptorSets: a a a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkFreeDescriptorSets: a a u a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkUpdateDescriptorSets: a u a u a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkCreateFramebuffer: a a a a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkDestroyFramebuffer: a a a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkCreateRenderPass: a a a a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkDestroyRenderPass: a a a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkGetRenderAreaGranularity: a a a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkCreateCommandPool: a a a a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkDestroyCommandPool: a a a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkResetCommandPool: a a u -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkAllocateCommandBuffers: a a a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkFreeCommandBuffers: a a u a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkBeginCommandBuffer: a a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkEndCommandBuffer: a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkResetCommandBuffer: a u -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkCmdBindPipeline: a n a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkCmdSetViewport: a u u a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkCmdSetScissor: a u u a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkCmdSetLineWidth: a r -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkCmdSetDepthBias: a r r r -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkCmdSetBlendConstants: a a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkCmdSetDepthBounds: a r r -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkCmdSetStencilCompareMask: a u u -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkCmdSetStencilWriteMask: a u u -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkCmdSetStencilReference: a u u -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkCmdBindDescriptorSets: a n a u u a u a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkCmdBindIndexBuffer: a a ud n -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkCmdBindVertexBuffers: a u u a a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkCmdDraw: a u u u u -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkCmdDrawIndexed: a u u u n u -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkCmdDrawIndirect: a a ud u u -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkCmdDrawIndexedIndirect: a a ud u u -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkCmdDispatch: a u u u -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkCmdDispatchIndirect: a a ud -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkCmdCopyBuffer: a a a u a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkCmdCopyImage: a a n a n u a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkCmdBlitImage: a a n a n u a n -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkCmdCopyBufferToImage: a a a n u a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkCmdCopyImageToBuffer: a a n a u a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkCmdUpdateBuffer: a a ud ud a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkCmdFillBuffer: a a ud ud u -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkCmdClearColorImage: a a n a u a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkCmdClearDepthStencilImage: a a n a u a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkCmdClearAttachments: a u a u a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkCmdResolveImage: a a n a n u a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkCmdSetEvent: a a u -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkCmdResetEvent: a a u -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkCmdWaitEvents: a u a u u u a u a u a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkCmdPipelineBarrier: a u u u u a u a u a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkCmdBeginQuery: a a u u -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkCmdEndQuery: a a u -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkCmdResetQueryPool: a a u u -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkCmdWriteTimestamp: a n a u -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkCmdCopyQueryPoolResults: a a u u a ud ud u -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkCmdPushConstants: a a u u u a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkCmdBeginRenderPass: a a n -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkCmdNextSubpass: a n -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkCmdEndRenderPass: a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkCmdExecuteCommands: a u a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkDestroySurfaceKHR: a a a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkGetPhysicalDeviceSurfaceSupportKHR: a u a a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkGetPhysicalDeviceSurfaceCapabilitiesKHR: a a a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkGetPhysicalDeviceSurfaceFormatsKHR: a a a a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkGetPhysicalDeviceSurfacePresentModesKHR: a a a a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkCreateSwapchainKHR: a a a a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkDestroySwapchainKHR: a a a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkGetSwapchainImagesKHR: a a a a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkAcquireNextImageKHR: a a ud a a a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkQueuePresentKHR: a a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkGetPhysicalDeviceDisplayPropertiesKHR: a a a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkGetPhysicalDeviceDisplayPlanePropertiesKHR: a a a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkGetDisplayPlaneSupportedDisplaysKHR: a u a a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkGetDisplayModePropertiesKHR: a a a a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkCreateDisplayModeKHR: a a a a a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkGetDisplayPlaneCapabilitiesKHR: a a u a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkCreateDisplayPlaneSurfaceKHR: a a a a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkCreateSharedSwapchainsKHR: a u a a a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkDebugReportCallbackEXT: u n ud u n s s a -- u", "", "", "" );
	swigCallback( "c-callback PFN_vkCreateDebugReportCallbackEXT: a a a a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkDestroyDebugReportCallbackEXT: a a a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkDebugReportMessageEXT: a u n ud u n s s -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkDebugMarkerSetObjectTagEXT: a a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkDebugMarkerSetObjectNameEXT: a a -- n", "", "", "" );
	swigCallback( "c-callback PFN_vkCmdDebugMarkerBeginEXT: a a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkCmdDebugMarkerEndEXT: a -- void", "", "", "" );
	swigCallback( "c-callback PFN_vkCmdDebugMarkerInsertEXT: a a -- void", "", "", "" );

	swigNewline();

	swigComment("------===< functions >===-------\n");
	swigFunction( "c-function vkCreateInstance vkCreateInstance a a a -- n", "FUNCTION: vkCreateInstance", "EXTERN: n C vkCreateInstance( a a a );", "" );
	swigFunction( "c-function vkDestroyInstance vkDestroyInstance a a -- void", "FUNCTION: vkDestroyInstance", "EXTERN: void C vkDestroyInstance( a a );", "" );
	swigFunction( "c-function vkEnumeratePhysicalDevices vkEnumeratePhysicalDevices a a a -- n", "FUNCTION: vkEnumeratePhysicalDevices", "EXTERN: n C vkEnumeratePhysicalDevices( a a a );", "" );
	swigFunction( "c-function vkGetPhysicalDeviceFeatures vkGetPhysicalDeviceFeatures a a -- void", "FUNCTION: vkGetPhysicalDeviceFeatures", "EXTERN: void C vkGetPhysicalDeviceFeatures( a a );", "" );
	swigFunction( "c-function vkGetPhysicalDeviceFormatProperties vkGetPhysicalDeviceFormatProperties a n a -- void", "FUNCTION: vkGetPhysicalDeviceFormatProperties", "EXTERN: void C vkGetPhysicalDeviceFormatProperties( a n a );", "" );
	swigFunction( "c-function vkGetPhysicalDeviceImageFormatProperties vkGetPhysicalDeviceImageFormatProperties a n n n u u a -- n", "FUNCTION: vkGetPhysicalDeviceImageFormatProperties", "EXTERN: n C vkGetPhysicalDeviceImageFormatProperties( a n n n u u a );", "" );
	swigFunction( "c-function vkGetPhysicalDeviceProperties vkGetPhysicalDeviceProperties a a -- void", "FUNCTION: vkGetPhysicalDeviceProperties", "EXTERN: void C vkGetPhysicalDeviceProperties( a a );", "" );
	swigFunction( "c-function vkGetPhysicalDeviceQueueFamilyProperties vkGetPhysicalDeviceQueueFamilyProperties a a a -- void", "FUNCTION: vkGetPhysicalDeviceQueueFamilyProperties", "EXTERN: void C vkGetPhysicalDeviceQueueFamilyProperties( a a a );", "" );
	swigFunction( "c-function vkGetPhysicalDeviceMemoryProperties vkGetPhysicalDeviceMemoryProperties a a -- void", "FUNCTION: vkGetPhysicalDeviceMemoryProperties", "EXTERN: void C vkGetPhysicalDeviceMemoryProperties( a a );", "" );
	swigFunction( "c-function vkGetInstanceProcAddr vkGetInstanceProcAddr a s -- a", "FUNCTION: vkGetInstanceProcAddr", "EXTERN: a C vkGetInstanceProcAddr( a s );", "" );
	swigFunction( "c-function vkGetDeviceProcAddr vkGetDeviceProcAddr a s -- a", "FUNCTION: vkGetDeviceProcAddr", "EXTERN: a C vkGetDeviceProcAddr( a s );", "" );
	swigFunction( "c-function vkCreateDevice vkCreateDevice a a a a -- n", "FUNCTION: vkCreateDevice", "EXTERN: n C vkCreateDevice( a a a a );", "" );
	swigFunction( "c-function vkDestroyDevice vkDestroyDevice a a -- void", "FUNCTION: vkDestroyDevice", "EXTERN: void C vkDestroyDevice( a a );", "" );
	swigFunction( "c-function vkEnumerateInstanceExtensionProperties vkEnumerateInstanceExtensionProperties s a a -- n", "FUNCTION: vkEnumerateInstanceExtensionProperties", "EXTERN: n C vkEnumerateInstanceExtensionProperties( s a a );", "" );
	swigFunction( "c-function vkEnumerateDeviceExtensionProperties vkEnumerateDeviceExtensionProperties a s a a -- n", "FUNCTION: vkEnumerateDeviceExtensionProperties", "EXTERN: n C vkEnumerateDeviceExtensionProperties( a s a a );", "" );
	swigFunction( "c-function vkEnumerateInstanceLayerProperties vkEnumerateInstanceLayerProperties a a -- n", "FUNCTION: vkEnumerateInstanceLayerProperties", "EXTERN: n C vkEnumerateInstanceLayerProperties( a a );", "" );
	swigFunction( "c-function vkEnumerateDeviceLayerProperties vkEnumerateDeviceLayerProperties a a a -- n", "FUNCTION: vkEnumerateDeviceLayerProperties", "EXTERN: n C vkEnumerateDeviceLayerProperties( a a a );", "" );
	swigFunction( "c-function vkGetDeviceQueue vkGetDeviceQueue a u u a -- void", "FUNCTION: vkGetDeviceQueue", "EXTERN: void C vkGetDeviceQueue( a u u a );", "" );
	swigFunction( "c-function vkQueueSubmit vkQueueSubmit a u a a -- n", "FUNCTION: vkQueueSubmit", "EXTERN: n C vkQueueSubmit( a u a a );", "" );
	swigFunction( "c-function vkQueueWaitIdle vkQueueWaitIdle a -- n", "FUNCTION: vkQueueWaitIdle", "EXTERN: n C vkQueueWaitIdle( a );", "" );
	swigFunction( "c-function vkDeviceWaitIdle vkDeviceWaitIdle a -- n", "FUNCTION: vkDeviceWaitIdle", "EXTERN: n C vkDeviceWaitIdle( a );", "" );
	swigFunction( "c-function vkAllocateMemory vkAllocateMemory a a a a -- n", "FUNCTION: vkAllocateMemory", "EXTERN: n C vkAllocateMemory( a a a a );", "" );
	swigFunction( "c-function vkFreeMemory vkFreeMemory a a a -- void", "FUNCTION: vkFreeMemory", "EXTERN: void C vkFreeMemory( a a a );", "" );
	swigFunction( "c-function vkMapMemory vkMapMemory a a ud ud u a -- n", "FUNCTION: vkMapMemory", "EXTERN: n C vkMapMemory( a a ud ud u a );", "" );
	swigFunction( "c-function vkUnmapMemory vkUnmapMemory a a -- void", "FUNCTION: vkUnmapMemory", "EXTERN: void C vkUnmapMemory( a a );", "" );
	swigFunction( "c-function vkFlushMappedMemoryRanges vkFlushMappedMemoryRanges a u a -- n", "FUNCTION: vkFlushMappedMemoryRanges", "EXTERN: n C vkFlushMappedMemoryRanges( a u a );", "" );
	swigFunction( "c-function vkInvalidateMappedMemoryRanges vkInvalidateMappedMemoryRanges a u a -- n", "FUNCTION: vkInvalidateMappedMemoryRanges", "EXTERN: n C vkInvalidateMappedMemoryRanges( a u a );", "" );
	swigFunction( "c-function vkGetDeviceMemoryCommitment vkGetDeviceMemoryCommitment a a a -- void", "FUNCTION: vkGetDeviceMemoryCommitment", "EXTERN: void C vkGetDeviceMemoryCommitment( a a a );", "" );
	swigFunction( "c-function vkBindBufferMemory vkBindBufferMemory a a a ud -- n", "FUNCTION: vkBindBufferMemory", "EXTERN: n C vkBindBufferMemory( a a a ud );", "" );
	swigFunction( "c-function vkBindImageMemory vkBindImageMemory a a a ud -- n", "FUNCTION: vkBindImageMemory", "EXTERN: n C vkBindImageMemory( a a a ud );", "" );
	swigFunction( "c-function vkGetBufferMemoryRequirements vkGetBufferMemoryRequirements a a a -- void", "FUNCTION: vkGetBufferMemoryRequirements", "EXTERN: void C vkGetBufferMemoryRequirements( a a a );", "" );
	swigFunction( "c-function vkGetImageMemoryRequirements vkGetImageMemoryRequirements a a a -- void", "FUNCTION: vkGetImageMemoryRequirements", "EXTERN: void C vkGetImageMemoryRequirements( a a a );", "" );
	swigFunction( "c-function vkGetImageSparseMemoryRequirements vkGetImageSparseMemoryRequirements a a a a -- void", "FUNCTION: vkGetImageSparseMemoryRequirements", "EXTERN: void C vkGetImageSparseMemoryRequirements( a a a a );", "" );
	swigFunction( "c-function vkGetPhysicalDeviceSparseImageFormatProperties vkGetPhysicalDeviceSparseImageFormatProperties a n n n u n a a -- void", "FUNCTION: vkGetPhysicalDeviceSparseImageFormatProperties", "EXTERN: void C vkGetPhysicalDeviceSparseImageFormatProperties( a n n n u n a a );", "" );
	swigFunction( "c-function vkQueueBindSparse vkQueueBindSparse a u a a -- n", "FUNCTION: vkQueueBindSparse", "EXTERN: n C vkQueueBindSparse( a u a a );", "" );
	swigFunction( "c-function vkCreateFence vkCreateFence a a a a -- n", "FUNCTION: vkCreateFence", "EXTERN: n C vkCreateFence( a a a a );", "" );
	swigFunction( "c-function vkDestroyFence vkDestroyFence a a a -- void", "FUNCTION: vkDestroyFence", "EXTERN: void C vkDestroyFence( a a a );", "" );
	swigFunction( "c-function vkResetFences vkResetFences a u a -- n", "FUNCTION: vkResetFences", "EXTERN: n C vkResetFences( a u a );", "" );
	swigFunction( "c-function vkGetFenceStatus vkGetFenceStatus a a -- n", "FUNCTION: vkGetFenceStatus", "EXTERN: n C vkGetFenceStatus( a a );", "" );
	swigFunction( "c-function vkWaitForFences vkWaitForFences a u a u ud -- n", "FUNCTION: vkWaitForFences", "EXTERN: n C vkWaitForFences( a u a u ud );", "" );
	swigFunction( "c-function vkCreateSemaphore vkCreateSemaphore a a a a -- n", "FUNCTION: vkCreateSemaphore", "EXTERN: n C vkCreateSemaphore( a a a a );", "" );
	swigFunction( "c-function vkDestroySemaphore vkDestroySemaphore a a a -- void", "FUNCTION: vkDestroySemaphore", "EXTERN: void C vkDestroySemaphore( a a a );", "" );
	swigFunction( "c-function vkCreateEvent vkCreateEvent a a a a -- n", "FUNCTION: vkCreateEvent", "EXTERN: n C vkCreateEvent( a a a a );", "" );
	swigFunction( "c-function vkDestroyEvent vkDestroyEvent a a a -- void", "FUNCTION: vkDestroyEvent", "EXTERN: void C vkDestroyEvent( a a a );", "" );
	swigFunction( "c-function vkGetEventStatus vkGetEventStatus a a -- n", "FUNCTION: vkGetEventStatus", "EXTERN: n C vkGetEventStatus( a a );", "" );
	swigFunction( "c-function vkSetEvent vkSetEvent a a -- n", "FUNCTION: vkSetEvent", "EXTERN: n C vkSetEvent( a a );", "" );
	swigFunction( "c-function vkResetEvent vkResetEvent a a -- n", "FUNCTION: vkResetEvent", "EXTERN: n C vkResetEvent( a a );", "" );
	swigFunction( "c-function vkCreateQueryPool vkCreateQueryPool a a a a -- n", "FUNCTION: vkCreateQueryPool", "EXTERN: n C vkCreateQueryPool( a a a a );", "" );
	swigFunction( "c-function vkDestroyQueryPool vkDestroyQueryPool a a a -- void", "FUNCTION: vkDestroyQueryPool", "EXTERN: void C vkDestroyQueryPool( a a a );", "" );
	swigFunction( "c-function vkGetQueryPoolResults vkGetQueryPoolResults a a u u u a ud u -- n", "FUNCTION: vkGetQueryPoolResults", "EXTERN: n C vkGetQueryPoolResults( a a u u u a ud u );", "" );
	swigFunction( "c-function vkCreateBuffer vkCreateBuffer a a a a -- n", "FUNCTION: vkCreateBuffer", "EXTERN: n C vkCreateBuffer( a a a a );", "" );
	swigFunction( "c-function vkDestroyBuffer vkDestroyBuffer a a a -- void", "FUNCTION: vkDestroyBuffer", "EXTERN: void C vkDestroyBuffer( a a a );", "" );
	swigFunction( "c-function vkCreateBufferView vkCreateBufferView a a a a -- n", "FUNCTION: vkCreateBufferView", "EXTERN: n C vkCreateBufferView( a a a a );", "" );
	swigFunction( "c-function vkDestroyBufferView vkDestroyBufferView a a a -- void", "FUNCTION: vkDestroyBufferView", "EXTERN: void C vkDestroyBufferView( a a a );", "" );
	swigFunction( "c-function vkCreateImage vkCreateImage a a a a -- n", "FUNCTION: vkCreateImage", "EXTERN: n C vkCreateImage( a a a a );", "" );
	swigFunction( "c-function vkDestroyImage vkDestroyImage a a a -- void", "FUNCTION: vkDestroyImage", "EXTERN: void C vkDestroyImage( a a a );", "" );
	swigFunction( "c-function vkGetImageSubresourceLayout vkGetImageSubresourceLayout a a a a -- void", "FUNCTION: vkGetImageSubresourceLayout", "EXTERN: void C vkGetImageSubresourceLayout( a a a a );", "" );
	swigFunction( "c-function vkCreateImageView vkCreateImageView a a a a -- n", "FUNCTION: vkCreateImageView", "EXTERN: n C vkCreateImageView( a a a a );", "" );
	swigFunction( "c-function vkDestroyImageView vkDestroyImageView a a a -- void", "FUNCTION: vkDestroyImageView", "EXTERN: void C vkDestroyImageView( a a a );", "" );
	swigFunction( "c-function vkCreateShaderModule vkCreateShaderModule a a a a -- n", "FUNCTION: vkCreateShaderModule", "EXTERN: n C vkCreateShaderModule( a a a a );", "" );
	swigFunction( "c-function vkDestroyShaderModule vkDestroyShaderModule a a a -- void", "FUNCTION: vkDestroyShaderModule", "EXTERN: void C vkDestroyShaderModule( a a a );", "" );
	swigFunction( "c-function vkCreatePipelineCache vkCreatePipelineCache a a a a -- n", "FUNCTION: vkCreatePipelineCache", "EXTERN: n C vkCreatePipelineCache( a a a a );", "" );
	swigFunction( "c-function vkDestroyPipelineCache vkDestroyPipelineCache a a a -- void", "FUNCTION: vkDestroyPipelineCache", "EXTERN: void C vkDestroyPipelineCache( a a a );", "" );
	swigFunction( "c-function vkGetPipelineCacheData vkGetPipelineCacheData a a a a -- n", "FUNCTION: vkGetPipelineCacheData", "EXTERN: n C vkGetPipelineCacheData( a a a a );", "" );
	swigFunction( "c-function vkMergePipelineCaches vkMergePipelineCaches a a u a -- n", "FUNCTION: vkMergePipelineCaches", "EXTERN: n C vkMergePipelineCaches( a a u a );", "" );
	swigFunction( "c-function vkCreateGraphicsPipelines vkCreateGraphicsPipelines a a u a a a -- n", "FUNCTION: vkCreateGraphicsPipelines", "EXTERN: n C vkCreateGraphicsPipelines( a a u a a a );", "" );
	swigFunction( "c-function vkCreateComputePipelines vkCreateComputePipelines a a u a a a -- n", "FUNCTION: vkCreateComputePipelines", "EXTERN: n C vkCreateComputePipelines( a a u a a a );", "" );
	swigFunction( "c-function vkDestroyPipeline vkDestroyPipeline a a a -- void", "FUNCTION: vkDestroyPipeline", "EXTERN: void C vkDestroyPipeline( a a a );", "" );
	swigFunction( "c-function vkCreatePipelineLayout vkCreatePipelineLayout a a a a -- n", "FUNCTION: vkCreatePipelineLayout", "EXTERN: n C vkCreatePipelineLayout( a a a a );", "" );
	swigFunction( "c-function vkDestroyPipelineLayout vkDestroyPipelineLayout a a a -- void", "FUNCTION: vkDestroyPipelineLayout", "EXTERN: void C vkDestroyPipelineLayout( a a a );", "" );
	swigFunction( "c-function vkCreateSampler vkCreateSampler a a a a -- n", "FUNCTION: vkCreateSampler", "EXTERN: n C vkCreateSampler( a a a a );", "" );
	swigFunction( "c-function vkDestroySampler vkDestroySampler a a a -- void", "FUNCTION: vkDestroySampler", "EXTERN: void C vkDestroySampler( a a a );", "" );
	swigFunction( "c-function vkCreateDescriptorSetLayout vkCreateDescriptorSetLayout a a a a -- n", "FUNCTION: vkCreateDescriptorSetLayout", "EXTERN: n C vkCreateDescriptorSetLayout( a a a a );", "" );
	swigFunction( "c-function vkDestroyDescriptorSetLayout vkDestroyDescriptorSetLayout a a a -- void", "FUNCTION: vkDestroyDescriptorSetLayout", "EXTERN: void C vkDestroyDescriptorSetLayout( a a a );", "" );
	swigFunction( "c-function vkCreateDescriptorPool vkCreateDescriptorPool a a a a -- n", "FUNCTION: vkCreateDescriptorPool", "EXTERN: n C vkCreateDescriptorPool( a a a a );", "" );
	swigFunction( "c-function vkDestroyDescriptorPool vkDestroyDescriptorPool a a a -- void", "FUNCTION: vkDestroyDescriptorPool", "EXTERN: void C vkDestroyDescriptorPool( a a a );", "" );
	swigFunction( "c-function vkResetDescriptorPool vkResetDescriptorPool a a u -- n", "FUNCTION: vkResetDescriptorPool", "EXTERN: n C vkResetDescriptorPool( a a u );", "" );
	swigFunction( "c-function vkAllocateDescriptorSets vkAllocateDescriptorSets a a a -- n", "FUNCTION: vkAllocateDescriptorSets", "EXTERN: n C vkAllocateDescriptorSets( a a a );", "" );
	swigFunction( "c-function vkFreeDescriptorSets vkFreeDescriptorSets a a u a -- n", "FUNCTION: vkFreeDescriptorSets", "EXTERN: n C vkFreeDescriptorSets( a a u a );", "" );
	swigFunction( "c-function vkUpdateDescriptorSets vkUpdateDescriptorSets a u a u a -- void", "FUNCTION: vkUpdateDescriptorSets", "EXTERN: void C vkUpdateDescriptorSets( a u a u a );", "" );
	swigFunction( "c-function vkCreateFramebuffer vkCreateFramebuffer a a a a -- n", "FUNCTION: vkCreateFramebuffer", "EXTERN: n C vkCreateFramebuffer( a a a a );", "" );
	swigFunction( "c-function vkDestroyFramebuffer vkDestroyFramebuffer a a a -- void", "FUNCTION: vkDestroyFramebuffer", "EXTERN: void C vkDestroyFramebuffer( a a a );", "" );
	swigFunction( "c-function vkCreateRenderPass vkCreateRenderPass a a a a -- n", "FUNCTION: vkCreateRenderPass", "EXTERN: n C vkCreateRenderPass( a a a a );", "" );
	swigFunction( "c-function vkDestroyRenderPass vkDestroyRenderPass a a a -- void", "FUNCTION: vkDestroyRenderPass", "EXTERN: void C vkDestroyRenderPass( a a a );", "" );
	swigFunction( "c-function vkGetRenderAreaGranularity vkGetRenderAreaGranularity a a a -- void", "FUNCTION: vkGetRenderAreaGranularity", "EXTERN: void C vkGetRenderAreaGranularity( a a a );", "" );
	swigFunction( "c-function vkCreateCommandPool vkCreateCommandPool a a a a -- n", "FUNCTION: vkCreateCommandPool", "EXTERN: n C vkCreateCommandPool( a a a a );", "" );
	swigFunction( "c-function vkDestroyCommandPool vkDestroyCommandPool a a a -- void", "FUNCTION: vkDestroyCommandPool", "EXTERN: void C vkDestroyCommandPool( a a a );", "" );
	swigFunction( "c-function vkResetCommandPool vkResetCommandPool a a u -- n", "FUNCTION: vkResetCommandPool", "EXTERN: n C vkResetCommandPool( a a u );", "" );
	swigFunction( "c-function vkAllocateCommandBuffers vkAllocateCommandBuffers a a a -- n", "FUNCTION: vkAllocateCommandBuffers", "EXTERN: n C vkAllocateCommandBuffers( a a a );", "" );
	swigFunction( "c-function vkFreeCommandBuffers vkFreeCommandBuffers a a u a -- void", "FUNCTION: vkFreeCommandBuffers", "EXTERN: void C vkFreeCommandBuffers( a a u a );", "" );
	swigFunction( "c-function vkBeginCommandBuffer vkBeginCommandBuffer a a -- n", "FUNCTION: vkBeginCommandBuffer", "EXTERN: n C vkBeginCommandBuffer( a a );", "" );
	swigFunction( "c-function vkEndCommandBuffer vkEndCommandBuffer a -- n", "FUNCTION: vkEndCommandBuffer", "EXTERN: n C vkEndCommandBuffer( a );", "" );
	swigFunction( "c-function vkResetCommandBuffer vkResetCommandBuffer a u -- n", "FUNCTION: vkResetCommandBuffer", "EXTERN: n C vkResetCommandBuffer( a u );", "" );
	swigFunction( "c-function vkCmdBindPipeline vkCmdBindPipeline a n a -- void", "FUNCTION: vkCmdBindPipeline", "EXTERN: void C vkCmdBindPipeline( a n a );", "" );
	swigFunction( "c-function vkCmdSetViewport vkCmdSetViewport a u u a -- void", "FUNCTION: vkCmdSetViewport", "EXTERN: void C vkCmdSetViewport( a u u a );", "" );
	swigFunction( "c-function vkCmdSetScissor vkCmdSetScissor a u u a -- void", "FUNCTION: vkCmdSetScissor", "EXTERN: void C vkCmdSetScissor( a u u a );", "" );
	swigFunction( "c-function vkCmdSetLineWidth vkCmdSetLineWidth a r -- void", "FUNCTION: vkCmdSetLineWidth", "EXTERN: void C vkCmdSetLineWidth( a r );", "" );
	swigFunction( "c-function vkCmdSetDepthBias vkCmdSetDepthBias a r r r -- void", "FUNCTION: vkCmdSetDepthBias", "EXTERN: void C vkCmdSetDepthBias( a r r r );", "" );
	swigFunction( "c-function vkCmdSetBlendConstants vkCmdSetBlendConstants a a -- void", "FUNCTION: vkCmdSetBlendConstants", "EXTERN: void C vkCmdSetBlendConstants( a a );", "" );
	swigFunction( "c-function vkCmdSetDepthBounds vkCmdSetDepthBounds a r r -- void", "FUNCTION: vkCmdSetDepthBounds", "EXTERN: void C vkCmdSetDepthBounds( a r r );", "" );
	swigFunction( "c-function vkCmdSetStencilCompareMask vkCmdSetStencilCompareMask a u u -- void", "FUNCTION: vkCmdSetStencilCompareMask", "EXTERN: void C vkCmdSetStencilCompareMask( a u u );", "" );
	swigFunction( "c-function vkCmdSetStencilWriteMask vkCmdSetStencilWriteMask a u u -- void", "FUNCTION: vkCmdSetStencilWriteMask", "EXTERN: void C vkCmdSetStencilWriteMask( a u u );", "" );
	swigFunction( "c-function vkCmdSetStencilReference vkCmdSetStencilReference a u u -- void", "FUNCTION: vkCmdSetStencilReference", "EXTERN: void C vkCmdSetStencilReference( a u u );", "" );
	swigFunction( "c-function vkCmdBindDescriptorSets vkCmdBindDescriptorSets a n a u u a u a -- void", "FUNCTION: vkCmdBindDescriptorSets", "EXTERN: void C vkCmdBindDescriptorSets( a n a u u a u a );", "" );
	swigFunction( "c-function vkCmdBindIndexBuffer vkCmdBindIndexBuffer a a ud n -- void", "FUNCTION: vkCmdBindIndexBuffer", "EXTERN: void C vkCmdBindIndexBuffer( a a ud n );", "" );
	swigFunction( "c-function vkCmdBindVertexBuffers vkCmdBindVertexBuffers a u u a a -- void", "FUNCTION: vkCmdBindVertexBuffers", "EXTERN: void C vkCmdBindVertexBuffers( a u u a a );", "" );
	swigFunction( "c-function vkCmdDraw vkCmdDraw a u u u u -- void", "FUNCTION: vkCmdDraw", "EXTERN: void C vkCmdDraw( a u u u u );", "" );
	swigFunction( "c-function vkCmdDrawIndexed vkCmdDrawIndexed a u u u n u -- void", "FUNCTION: vkCmdDrawIndexed", "EXTERN: void C vkCmdDrawIndexed( a u u u n u );", "" );
	swigFunction( "c-function vkCmdDrawIndirect vkCmdDrawIndirect a a ud u u -- void", "FUNCTION: vkCmdDrawIndirect", "EXTERN: void C vkCmdDrawIndirect( a a ud u u );", "" );
	swigFunction( "c-function vkCmdDrawIndexedIndirect vkCmdDrawIndexedIndirect a a ud u u -- void", "FUNCTION: vkCmdDrawIndexedIndirect", "EXTERN: void C vkCmdDrawIndexedIndirect( a a ud u u );", "" );
	swigFunction( "c-function vkCmdDispatch vkCmdDispatch a u u u -- void", "FUNCTION: vkCmdDispatch", "EXTERN: void C vkCmdDispatch( a u u u );", "" );
	swigFunction( "c-function vkCmdDispatchIndirect vkCmdDispatchIndirect a a ud -- void", "FUNCTION: vkCmdDispatchIndirect", "EXTERN: void C vkCmdDispatchIndirect( a a ud );", "" );
	swigFunction( "c-function vkCmdCopyBuffer vkCmdCopyBuffer a a a u a -- void", "FUNCTION: vkCmdCopyBuffer", "EXTERN: void C vkCmdCopyBuffer( a a a u a );", "" );
	swigFunction( "c-function vkCmdCopyImage vkCmdCopyImage a a n a n u a -- void", "FUNCTION: vkCmdCopyImage", "EXTERN: void C vkCmdCopyImage( a a n a n u a );", "" );
	swigFunction( "c-function vkCmdBlitImage vkCmdBlitImage a a n a n u a n -- void", "FUNCTION: vkCmdBlitImage", "EXTERN: void C vkCmdBlitImage( a a n a n u a n );", "" );
	swigFunction( "c-function vkCmdCopyBufferToImage vkCmdCopyBufferToImage a a a n u a -- void", "FUNCTION: vkCmdCopyBufferToImage", "EXTERN: void C vkCmdCopyBufferToImage( a a a n u a );", "" );
	swigFunction( "c-function vkCmdCopyImageToBuffer vkCmdCopyImageToBuffer a a n a u a -- void", "FUNCTION: vkCmdCopyImageToBuffer", "EXTERN: void C vkCmdCopyImageToBuffer( a a n a u a );", "" );
	swigFunction( "c-function vkCmdUpdateBuffer vkCmdUpdateBuffer a a ud ud a -- void", "FUNCTION: vkCmdUpdateBuffer", "EXTERN: void C vkCmdUpdateBuffer( a a ud ud a );", "" );
	swigFunction( "c-function vkCmdFillBuffer vkCmdFillBuffer a a ud ud u -- void", "FUNCTION: vkCmdFillBuffer", "EXTERN: void C vkCmdFillBuffer( a a ud ud u );", "" );
	swigFunction( "c-function vkCmdClearColorImage vkCmdClearColorImage a a n a u a -- void", "FUNCTION: vkCmdClearColorImage", "EXTERN: void C vkCmdClearColorImage( a a n a u a );", "" );
	swigFunction( "c-function vkCmdClearDepthStencilImage vkCmdClearDepthStencilImage a a n a u a -- void", "FUNCTION: vkCmdClearDepthStencilImage", "EXTERN: void C vkCmdClearDepthStencilImage( a a n a u a );", "" );
	swigFunction( "c-function vkCmdClearAttachments vkCmdClearAttachments a u a u a -- void", "FUNCTION: vkCmdClearAttachments", "EXTERN: void C vkCmdClearAttachments( a u a u a );", "" );
	swigFunction( "c-function vkCmdResolveImage vkCmdResolveImage a a n a n u a -- void", "FUNCTION: vkCmdResolveImage", "EXTERN: void C vkCmdResolveImage( a a n a n u a );", "" );
	swigFunction( "c-function vkCmdSetEvent vkCmdSetEvent a a u -- void", "FUNCTION: vkCmdSetEvent", "EXTERN: void C vkCmdSetEvent( a a u );", "" );
	swigFunction( "c-function vkCmdResetEvent vkCmdResetEvent a a u -- void", "FUNCTION: vkCmdResetEvent", "EXTERN: void C vkCmdResetEvent( a a u );", "" );
	swigFunction( "c-function vkCmdWaitEvents vkCmdWaitEvents a u a u u u a u a u a -- void", "FUNCTION: vkCmdWaitEvents", "EXTERN: void C vkCmdWaitEvents( a u a u u u a u a u a );", "" );
	swigFunction( "c-function vkCmdPipelineBarrier vkCmdPipelineBarrier a u u u u a u a u a -- void", "FUNCTION: vkCmdPipelineBarrier", "EXTERN: void C vkCmdPipelineBarrier( a u u u u a u a u a );", "" );
	swigFunction( "c-function vkCmdBeginQuery vkCmdBeginQuery a a u u -- void", "FUNCTION: vkCmdBeginQuery", "EXTERN: void C vkCmdBeginQuery( a a u u );", "" );
	swigFunction( "c-function vkCmdEndQuery vkCmdEndQuery a a u -- void", "FUNCTION: vkCmdEndQuery", "EXTERN: void C vkCmdEndQuery( a a u );", "" );
	swigFunction( "c-function vkCmdResetQueryPool vkCmdResetQueryPool a a u u -- void", "FUNCTION: vkCmdResetQueryPool", "EXTERN: void C vkCmdResetQueryPool( a a u u );", "" );
	swigFunction( "c-function vkCmdWriteTimestamp vkCmdWriteTimestamp a n a u -- void", "FUNCTION: vkCmdWriteTimestamp", "EXTERN: void C vkCmdWriteTimestamp( a n a u );", "" );
	swigFunction( "c-function vkCmdCopyQueryPoolResults vkCmdCopyQueryPoolResults a a u u a ud ud u -- void", "FUNCTION: vkCmdCopyQueryPoolResults", "EXTERN: void C vkCmdCopyQueryPoolResults( a a u u a ud ud u );", "" );
	swigFunction( "c-function vkCmdPushConstants vkCmdPushConstants a a u u u a -- void", "FUNCTION: vkCmdPushConstants", "EXTERN: void C vkCmdPushConstants( a a u u u a );", "" );
	swigFunction( "c-function vkCmdBeginRenderPass vkCmdBeginRenderPass a a n -- void", "FUNCTION: vkCmdBeginRenderPass", "EXTERN: void C vkCmdBeginRenderPass( a a n );", "" );
	swigFunction( "c-function vkCmdNextSubpass vkCmdNextSubpass a n -- void", "FUNCTION: vkCmdNextSubpass", "EXTERN: void C vkCmdNextSubpass( a n );", "" );
	swigFunction( "c-function vkCmdEndRenderPass vkCmdEndRenderPass a -- void", "FUNCTION: vkCmdEndRenderPass", "EXTERN: void C vkCmdEndRenderPass( a );", "" );
	swigFunction( "c-function vkCmdExecuteCommands vkCmdExecuteCommands a u a -- void", "FUNCTION: vkCmdExecuteCommands", "EXTERN: void C vkCmdExecuteCommands( a u a );", "" );
	swigFunction( "c-function vkDestroySurfaceKHR vkDestroySurfaceKHR a a a -- void", "FUNCTION: vkDestroySurfaceKHR", "EXTERN: void C vkDestroySurfaceKHR( a a a );", "" );
	swigFunction( "c-function vkGetPhysicalDeviceSurfaceSupportKHR vkGetPhysicalDeviceSurfaceSupportKHR a u a a -- n", "FUNCTION: vkGetPhysicalDeviceSurfaceSupportKHR", "EXTERN: n C vkGetPhysicalDeviceSurfaceSupportKHR( a u a a );", "" );
	swigFunction( "c-function vkGetPhysicalDeviceSurfaceCapabilitiesKHR vkGetPhysicalDeviceSurfaceCapabilitiesKHR a a a -- n", "FUNCTION: vkGetPhysicalDeviceSurfaceCapabilitiesKHR", "EXTERN: n C vkGetPhysicalDeviceSurfaceCapabilitiesKHR( a a a );", "" );
	swigFunction( "c-function vkGetPhysicalDeviceSurfaceFormatsKHR vkGetPhysicalDeviceSurfaceFormatsKHR a a a a -- n", "FUNCTION: vkGetPhysicalDeviceSurfaceFormatsKHR", "EXTERN: n C vkGetPhysicalDeviceSurfaceFormatsKHR( a a a a );", "" );
	swigFunction( "c-function vkGetPhysicalDeviceSurfacePresentModesKHR vkGetPhysicalDeviceSurfacePresentModesKHR a a a a -- n", "FUNCTION: vkGetPhysicalDeviceSurfacePresentModesKHR", "EXTERN: n C vkGetPhysicalDeviceSurfacePresentModesKHR( a a a a );", "" );
	swigFunction( "c-function vkCreateSwapchainKHR vkCreateSwapchainKHR a a a a -- n", "FUNCTION: vkCreateSwapchainKHR", "EXTERN: n C vkCreateSwapchainKHR( a a a a );", "" );
	swigFunction( "c-function vkDestroySwapchainKHR vkDestroySwapchainKHR a a a -- void", "FUNCTION: vkDestroySwapchainKHR", "EXTERN: void C vkDestroySwapchainKHR( a a a );", "" );
	swigFunction( "c-function vkGetSwapchainImagesKHR vkGetSwapchainImagesKHR a a a a -- n", "FUNCTION: vkGetSwapchainImagesKHR", "EXTERN: n C vkGetSwapchainImagesKHR( a a a a );", "" );
	swigFunction( "c-function vkAcquireNextImageKHR vkAcquireNextImageKHR a a ud a a a -- n", "FUNCTION: vkAcquireNextImageKHR", "EXTERN: n C vkAcquireNextImageKHR( a a ud a a a );", "" );
	swigFunction( "c-function vkQueuePresentKHR vkQueuePresentKHR a a -- n", "FUNCTION: vkQueuePresentKHR", "EXTERN: n C vkQueuePresentKHR( a a );", "" );
	swigFunction( "c-function vkGetPhysicalDeviceDisplayPropertiesKHR vkGetPhysicalDeviceDisplayPropertiesKHR a a a -- n", "FUNCTION: vkGetPhysicalDeviceDisplayPropertiesKHR", "EXTERN: n C vkGetPhysicalDeviceDisplayPropertiesKHR( a a a );", "" );
	swigFunction( "c-function vkGetPhysicalDeviceDisplayPlanePropertiesKHR vkGetPhysicalDeviceDisplayPlanePropertiesKHR a a a -- n", "FUNCTION: vkGetPhysicalDeviceDisplayPlanePropertiesKHR", "EXTERN: n C vkGetPhysicalDeviceDisplayPlanePropertiesKHR( a a a );", "" );
	swigFunction( "c-function vkGetDisplayPlaneSupportedDisplaysKHR vkGetDisplayPlaneSupportedDisplaysKHR a u a a -- n", "FUNCTION: vkGetDisplayPlaneSupportedDisplaysKHR", "EXTERN: n C vkGetDisplayPlaneSupportedDisplaysKHR( a u a a );", "" );
	swigFunction( "c-function vkGetDisplayModePropertiesKHR vkGetDisplayModePropertiesKHR a a a a -- n", "FUNCTION: vkGetDisplayModePropertiesKHR", "EXTERN: n C vkGetDisplayModePropertiesKHR( a a a a );", "" );
	swigFunction( "c-function vkCreateDisplayModeKHR vkCreateDisplayModeKHR a a a a a -- n", "FUNCTION: vkCreateDisplayModeKHR", "EXTERN: n C vkCreateDisplayModeKHR( a a a a a );", "" );
	swigFunction( "c-function vkGetDisplayPlaneCapabilitiesKHR vkGetDisplayPlaneCapabilitiesKHR a a u a -- n", "FUNCTION: vkGetDisplayPlaneCapabilitiesKHR", "EXTERN: n C vkGetDisplayPlaneCapabilitiesKHR( a a u a );", "" );
	swigFunction( "c-function vkCreateDisplayPlaneSurfaceKHR vkCreateDisplayPlaneSurfaceKHR a a a a -- n", "FUNCTION: vkCreateDisplayPlaneSurfaceKHR", "EXTERN: n C vkCreateDisplayPlaneSurfaceKHR( a a a a );", "" );
	swigFunction( "c-function vkCreateSharedSwapchainsKHR vkCreateSharedSwapchainsKHR a u a a a -- n", "FUNCTION: vkCreateSharedSwapchainsKHR", "EXTERN: n C vkCreateSharedSwapchainsKHR( a u a a a );", "" );
	swigFunction( "c-function vkCreateDebugReportCallbackEXT vkCreateDebugReportCallbackEXT a a a a -- n", "FUNCTION: vkCreateDebugReportCallbackEXT", "EXTERN: n C vkCreateDebugReportCallbackEXT( a a a a );", "" );
	swigFunction( "c-function vkDestroyDebugReportCallbackEXT vkDestroyDebugReportCallbackEXT a a a -- void", "FUNCTION: vkDestroyDebugReportCallbackEXT", "EXTERN: void C vkDestroyDebugReportCallbackEXT( a a a );", "" );
	swigFunction( "c-function vkDebugReportMessageEXT vkDebugReportMessageEXT a u n ud u n s s -- void", "FUNCTION: vkDebugReportMessageEXT", "EXTERN: void C vkDebugReportMessageEXT( a u n ud u n s s );", "" );
	swigFunction( "c-function vkDebugMarkerSetObjectTagEXT vkDebugMarkerSetObjectTagEXT a a -- n", "FUNCTION: vkDebugMarkerSetObjectTagEXT", "EXTERN: n C vkDebugMarkerSetObjectTagEXT( a a );", "" );
	swigFunction( "c-function vkDebugMarkerSetObjectNameEXT vkDebugMarkerSetObjectNameEXT a a -- n", "FUNCTION: vkDebugMarkerSetObjectNameEXT", "EXTERN: n C vkDebugMarkerSetObjectNameEXT( a a );", "" );
	swigFunction( "c-function vkCmdDebugMarkerBeginEXT vkCmdDebugMarkerBeginEXT a a -- void", "FUNCTION: vkCmdDebugMarkerBeginEXT", "EXTERN: void C vkCmdDebugMarkerBeginEXT( a a );", "" );
	swigFunction( "c-function vkCmdDebugMarkerEndEXT vkCmdDebugMarkerEndEXT a -- void", "FUNCTION: vkCmdDebugMarkerEndEXT", "EXTERN: void C vkCmdDebugMarkerEndEXT( a );", "" );
	swigFunction( "c-function vkCmdDebugMarkerInsertEXT vkCmdDebugMarkerInsertEXT a a -- void", "FUNCTION: vkCmdDebugMarkerInsertEXT", "EXTERN: void C vkCmdDebugMarkerInsertEXT( a a );", "" );
	
	return 0;
} /* end of main */



