/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 3.0.9
 *
 * This file is not intended to be easily readable and contains a number of
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG
 * interface file instead.
 * ----------------------------------------------------------------------------- */
#include <stdio.h>
#include <string.h>
#include <stddef.h>



#include <gps.h>

typedef enum{ NONE = -1, GFORTH = 0, SWIFTFORTH, VFX } SwigTargetSystem;
SwigTargetSystem swigTargetSystem = NONE;

unsigned char swigPrintStackComments = 1;

/* comments */
void swigNewline()
{
	printf( "\n" );
}

void swigComment( char *comment )
{
	printf( "\\ %s", comment );
}

/* constants */
void swigIntConstant( long constant, char *name )
{
	printf( "#%ld\tconstant %s\n", constant, name );
}

void swigUnsignedIntConstant( unsigned long constant, char *name )
{
	printf( "#%lu\tconstant %s\n", constant, name );
}

void swigLongConstant( long long constant, char *name )
{
	printf( "#%lld.\t2constant %s\n", constant, name );
}

void swigUnsignedLongConstant( unsigned long long constant, char *name )
{
	printf( "#%llu.\t2constant %s\n", constant, name );
}

void swigFloatConstant( double constant, char *name )
{
	char buffer[128];
	sprintf( buffer, "%f", constant );

	/* if the constant contains no exponent, add one */
	char *s;
	for( s = buffer; *s != 0; s++ )
		if( *s == 'e' || *s == 'E' )
			break;

	/* exponent found */
	if( *s != 0 )
		printf( "%s\tfconstant %s\n", buffer, name );
	/* not found */
	else
		printf( "%se0\tfconstant %s\n", buffer, name );
}

void swigStringConstant( char* constant, char *name )
{
	char c;
	printf( ": %s s\\\" ", name );
	while(( c = *constant++ ))
	{
		switch(c)
		{
			case '\b': printf( "\\b" ); break;
			case '\n': printf( "\\n" ); break;
			case '\f': printf( "\\f" ); break;
			case '\r': printf( "\\r" ); break;
			case '\t': printf( "\\t" ); break;
			case '"' : printf( "\\q" ); break;
			default:
				if(c < 0x20)
					printf("\\x%02x", c);
				else
					printf("%c", c); break;
		}
	}
	printf(	"\" ;\n" );
}

/* structs */
void swigStructField( char *name, size_t offset, size_t size )
{
	printf( "\tdrop %zu %zu +field %s\n", offset, size, name );
}

/* functions */
void swigFunction( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	if( swigTargetSystem == GFORTH )
		printf( "%s", gforth );
	else if( swigTargetSystem == SWIFTFORTH )
		printf( "%s", swiftForth );
	else if( swigTargetSystem == VFX )
		printf( "%s", vfx );

	if( swigPrintStackComments )
		printf( "%s", stackComment );

	printf( "\n" );
}

/* function pointers */
void swigFunctionPointer( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	swigFunction( gforth, swiftForth, vfx, stackComment );
}

/* callbacks */
void swigCallback( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	swigFunction( gforth, swiftForth, vfx, stackComment );
}

void swigUsage( char **argv )
{
	fprintf( stderr, "Usage: %s [-gforth|-swiftforth|-vfx]\n", argv[0] );
}

int main( int argc, char **argv )
{
	int i;

	/* check arguments */
	for( i = 1; i < argc; i++ )
		if( strcmp( argv[i], "-gforth" ) == 0 )
			swigTargetSystem = GFORTH;
		else if( strcmp( argv[i], "-swiftforth" ) == 0 )
			swigTargetSystem = SWIFTFORTH;
		else if( strcmp( argv[i], "-vfx" ) == 0 )
			swigTargetSystem = VFX;

	if( swigTargetSystem == NONE )
	{
		fprintf( stderr, "Error: no target system specified\n" );
		swigUsage( argv );
		return 1;
	}

	/* primer */
	printf( "\\ This file has been generated using SWIG and fsi,\n"
		"\\ and is already platform dependent, search for the corresponding\n"
		"\\ fsi-file to compile it where no one has compiled it before ;)\n"
		"\\ GForth has its own dynamic loader and doesn't need addional C-Code.\n"
		"\\ That's why this file contains normal Gforth-code( version 0.6.9 or higher )\n"
		"\\ and could be used directly with include or require.\n"
		"\\ As all comments are stripped during the compilation, please\n"
		"\\ insert the copyright notice of the original file here.\n"
	);


typedef struct {
  unsigned int nentries;
  struct                {
    unsigned ident;		                  
    unsigned udre;		                            
    unsigned iod;		                   
    double prc;		                 
    double rrc;		                      
  } sat[18];
} _gps_ranges;

typedef struct {
  bool valid;		                             
  double x, y, z;
} _ecef;

typedef struct {
  bool valid;		                             
  int system;
  int sense;
  
  
  
  char datum[6];
  double dx, dy, dz;
} _reference;

typedef struct {
  unsigned int nentries;
  struct          {
    unsigned ident;		                  
    bool iodl;		                   
    unsigned int health;	                           
    
    
    
    
    int snr;			                               
    
    bool health_en; 	                    
    bool new_data;		               
    bool los_warning;	                           
    unsigned int tou;	                               
  } sat[(33-2)];
} _conhealth;

typedef struct {
  unsigned int nentries;
  struct           {
    double latitude, longitude;	              
    unsigned int range;		                 
    double frequency;		                    
    unsigned int health;		                    
    unsigned int station_id;	                        
    unsigned int bitrate;		                              
  } station[10];
} _almanac;

typedef struct {
  bool status;		                           
  bool rangeflag;		                            
  double lat, lon;		                                
  unsigned int range;		                              
} _xmitter;

typedef struct {
  unsigned int week;			                       
  unsigned int hour;			                          
  unsigned int leapsecs;		                         
} _gpstime;

typedef struct {
  unsigned int nentries;
  struct                    {
    unsigned ident;		                  
    unsigned udre;		                            
    unsigned tod;		                   
    bool change;		                          
    double prc;		                 
    double rrc;		                      
  } sat[18];
} _glonass_ranges;

typedef union {
  struct {
    struct rtcm3_rtk_hdr	header;
    struct              {
      unsigned ident;			                  
      struct rtcm3_basic_rtk L1;
    } rtk_data[64];
  } rtcm3_1001;
  struct {
    struct rtcm3_rtk_hdr	header;
    struct              {
      unsigned ident;			                  
      struct rtcm3_extended_rtk L1;
    } rtk_data[64];
  } rtcm3_1002;
  struct              {
    struct rtcm3_rtk_hdr	header;
    struct {
      unsigned ident;			                  
      struct rtcm3_basic_rtk L1;
      struct rtcm3_basic_rtk L2;
    } rtk_data[64];
  } rtcm3_1003;
  struct              {
    struct rtcm3_rtk_hdr	header;
    struct {
      unsigned ident;			                  
      struct rtcm3_extended_rtk L1;
      struct rtcm3_extended_rtk L2;
    } rtk_data[64];
  } rtcm3_1004;
  struct              {
    unsigned int station_id;		                          
    int system;				                         
    bool reference_station;		                                 
    bool single_receiver;		                                
    double ecef_x, ecef_y, ecef_z;	                           
  } rtcm3_1005;
  struct              {
    unsigned int station_id;		                          
    int system;				                         
    bool reference_station;		                                 
    bool single_receiver;		                                
    double ecef_x, ecef_y, ecef_z;	                           
    double height;			                    
  } rtcm3_1006;
  struct {
    unsigned int station_id;			                          
    char descriptor[31+1];	                        
    unsigned int setup_id;
  } rtcm3_1007;
  struct {
    unsigned int station_id;			                          
    char descriptor[31+1];	                        
    unsigned int setup_id;
    char serial[31+1];	                     
  } rtcm3_1008;
  struct {
    struct rtcm3_rtk_hdr	header;
    struct              {
      unsigned ident;		                  
      struct rtcm3_basic_rtk L1;
    } rtk_data[64];
  } rtcm3_1009;
  struct {
    struct rtcm3_rtk_hdr	header;
    struct              {
      unsigned ident;		                  
      struct rtcm3_extended_rtk L1;
    } rtk_data[64];
  } rtcm3_1010;
  struct {
    struct rtcm3_rtk_hdr	header;
    struct              {
      unsigned ident;			                  
      struct rtcm3_extended_rtk L1;
      struct rtcm3_extended_rtk L2;
    } rtk_data[64];
  } rtcm3_1011;
  struct {
    struct rtcm3_rtk_hdr	header;
    struct              {
      unsigned ident;			                  
      struct rtcm3_extended_rtk L1;
      struct rtcm3_extended_rtk L2;
    } rtk_data[64];
  } rtcm3_1012;
  struct {
    unsigned int station_id;	                          
    unsigned short mjd;		                                      
    unsigned int sod;		                          
    unsigned char leapsecs;	                           
    unsigned char ncount;	                                      
    struct              {
      unsigned short id;		                     
      bool sync;
      unsigned short interval;	                              
    } announcements[32];
  } rtcm3_1013;
  
  struct              {
    unsigned int network_id;	                
    unsigned int subnetwork_id;	                   
    unsigned int stationcount;	                                      
    unsigned int master_id;	                                 
    unsigned int aux_id;	                                   
    double d_lat, d_lon, d_alt;	                               
  } rtcm3_1014;
  struct              {
    struct rtcm3_network_rtk_header	header;
    struct rtcm3_correction_diff corrections[64];
  } rtcm3_1015;
  struct              {
    struct rtcm3_network_rtk_header	header;
    struct rtcm3_correction_diff corrections[64];
  } rtcm3_1016;
  struct              {
    struct rtcm3_network_rtk_header	header;
    struct rtcm3_correction_diff corrections[64];
  } rtcm3_1017;
  
  struct              {
    unsigned int ident;		                  
    unsigned int week;		                     
    unsigned char sv_accuracy;	                     
    enum {
      reserved_code, p, ca, l2c
    } code;
    double idot;
    unsigned char iode;
    
    unsigned int t_sub_oc;
    signed int a_sub_f2;
    signed int a_sub_f1;
    signed int a_sub_f0;
    unsigned int iodc;
    signed int C_sub_rs;
    signed int delta_sub_n;
    signed int M_sub_0;
    signed int C_sub_uc;
    unsigned int e;
    signed int C_sub_us;
    unsigned int sqrt_sub_A;
    unsigned int t_sub_oe;
    signed int C_sub_ic;
    signed int OMEGA_sub_0;
    signed int C_sub_is;
    signed int i_sub_0;
    signed int C_sub_rc;
    signed int argument_of_perigee;
    signed int omegadot;
    signed int t_sub_GD;
    unsigned char sv_health;
    bool p_data;
    bool fit_interval;
  } rtcm3_1019;
  struct              {
    unsigned int ident;		                  
    unsigned short channel;	                                        
    
    bool C_sub_n;
    bool health_avAilability_indicator;
    unsigned char P1;
    unsigned short t_sub_k;
    bool msb_of_B_sub_n;
    bool P2;
    bool t_sub_b;
    signed int x_sub_n_t_of_t_sub_b_prime;
    signed int x_sub_n_t_of_t_sub_b;
    signed int x_sub_n_t_of_t_sub_b_prime_prime;
    signed int y_sub_n_t_of_t_sub_b_prime;
    signed int y_sub_n_t_of_t_sub_b;
    signed int y_sub_n_t_of_t_sub_b_prime_prime;
    signed int z_sub_n_t_of_t_sub_b_prime;
    signed int z_sub_n_t_of_t_sub_b;
    signed int z_sub_n_t_of_t_sub_b_prime_prime;
    bool P3;
    signed int gamma_sub_n_of_t_sub_b;
    unsigned char MP;
    bool Ml_n;
    signed int tau_n_of_t_sub_b;
    signed int M_delta_tau_sub_n;
    unsigned int E_sub_n;
    bool MP4;
    unsigned char MF_sub_T;
    unsigned char MN_sub_T;
    unsigned char MM;
    bool additioinal_data_availability;
    unsigned int N_sup_A;
    unsigned int tau_sub_c;
    unsigned int M_N_sub_4;
    signed int M_tau_sub_GPS;
    bool M_l_sub_n;
  } rtcm3_1020;
  struct              {
    unsigned int station_id;	                          
    unsigned short mjd;		                                      
    unsigned int sod;		                          
    size_t len;			                       
    size_t unicode_units;	                             
    unsigned char text[128];
  } rtcm3_1029;
  struct              {
    unsigned int station_id;			                          
    char descriptor[31+1];	                        
    unsigned int setup_id;
    char serial[31+1];	                     
    char receiver[31+1];	                     
    char firmware[31+1];	                     
  } rtcm3_1033;
  char data[1024];		                                        
} rtcm3_t_rtcmtypes;

typedef struct {
  struct rtcm3_rtk_hdr	header;
  struct              {
    unsigned ident;			                  
    struct rtcm3_basic_rtk L1;
  } rtk_data[64];
} rtcm3_t_rtcmtypes_rtcm3_1001;

typedef struct {
  struct rtcm3_rtk_hdr	header;
  struct              {
    unsigned ident;			                  
    struct rtcm3_extended_rtk L1;
  } rtk_data[64];
} rtcm3_t_rtcmtypes_rtcm3_1002;

typedef struct {
  unsigned int station_id;			                          
  char descriptor[31+1];	                        
  unsigned int setup_id;
} rtcm3_t_rtcmtypes_rtcm3_1007;

typedef struct {
  unsigned int station_id;			                          
  char descriptor[31+1];	                        
  unsigned int setup_id;
  char serial[31+1];	                     
} rtcm3_t_rtcmtypes_rtcm3_1008;

typedef struct {
  struct rtcm3_rtk_hdr	header;
  struct              {
    unsigned ident;		                  
    struct rtcm3_basic_rtk L1;
  } rtk_data[64];
} rtcm3_t_rtcmtypes_rtcm3_1009;

typedef struct {
  struct rtcm3_rtk_hdr	header;
  struct              {
    unsigned ident;		                  
    struct rtcm3_extended_rtk L1;
  } rtk_data[64];
} rtcm3_t_rtcmtypes_rtcm3_1010;

typedef struct {
  struct rtcm3_rtk_hdr	header;
  struct              {
    unsigned ident;			                  
    struct rtcm3_extended_rtk L1;
    struct rtcm3_extended_rtk L2;
  } rtk_data[64];
} rtcm3_t_rtcmtypes_rtcm3_1011;

typedef struct {
  struct rtcm3_rtk_hdr	header;
  struct              {
    unsigned ident;			                  
    struct rtcm3_extended_rtk L1;
    struct rtcm3_extended_rtk L2;
  } rtk_data[64];
} rtcm3_t_rtcmtypes_rtcm3_1012;

typedef struct {
  unsigned int station_id;	                          
  unsigned short mjd;		                                      
  unsigned int sod;		                          
  unsigned char leapsecs;	                           
  unsigned char ncount;	                                      
  struct              {
    unsigned short id;		                     
    bool sync;
    unsigned short interval;	                              
  } announcements[32];
} rtcm3_t_rtcmtypes_rtcm3_1013;

typedef struct {
  unsigned ident;			                  
  struct rtcm3_basic_rtk L1;
  struct rtcm3_basic_rtk L2;
} rtcm3_1003_t_rtk_data;

typedef struct {
  unsigned ident;			                  
  struct rtcm3_extended_rtk L1;
  struct rtcm3_extended_rtk L2;
} rtcm3_1004_t_rtk_data;

typedef struct {
  uint16_t WN;
  
  uint16_t IODC;
  
  uint16_t toc;
  long l_toc;
  
  uint8_t l2;
  
  uint8_t l2p;
  
  unsigned int ura;
  
  unsigned int hlth;
  
  int32_t af0;
  double d_af0;
  
  int16_t af1;
  double d_af1;
  
  int8_t af2;
  double d_af2;
  
  int8_t Tgd;
  double d_Tgd;
} _sub1;

typedef struct {
  uint8_t IODE;
  
  uint8_t AODO;
  uint16_t u_AODO;
  
  uint8_t fit;
  
  uint16_t toe;
  long l_toe;
  
  int16_t Crs;
  double d_Crs;
  
  int16_t Cus;
  double d_Cus;
  
  int16_t Cuc;
  double d_Cuc;
  
  int16_t deltan;
  double d_deltan;
  
  int32_t M0;
  double d_M0;
  
  uint32_t e;
  double d_eccentricity;
  
  uint32_t sqrtA;
  double d_sqrtA;
} _sub2;

typedef struct {
  uint8_t IODE;
  
  int16_t IDOT;
  double d_IDOT;
  
  int16_t Cic;
  double d_Cic;
  
  int16_t Cis;
  double d_Cis;
  
  int16_t Crc;
  double d_Crc;
  
  int32_t i0;
  double d_i0;
  
  int32_t Omega0;
  double d_Omega0;
  
  int32_t omega;
  double d_omega;
  
  int32_t Omegad;
  double d_Omegad;
} _sub3;

typedef struct {
  struct almanac_t almanac;
} _sub4;

typedef struct {
  char ERD[33];
  
  unsigned char ai;
} _sub4_13;

typedef struct {
  char str[24];
} _sub4_17;

typedef struct {
  int32_t A0;
  double d_A0;
  
  int32_t A1;
  double d_A1;
  
  
  
  
  int8_t alpha0;
  double d_alpha0;
  
  int8_t alpha1;
  double d_alpha1;
  
  int8_t alpha2;
  double d_alpha2;
  
  int8_t alpha3;
  double d_alpha3;
  
  
  
  
  int8_t beta0;
  double d_beta0;
  
  int8_t beta1;
  double d_beta1;
  
  int8_t beta2;
  double d_beta2;
  
  int8_t beta3;
  double d_beta3;
  
  
  int8_t leap;
  
  int8_t lsf;
  
  
  uint8_t tot;
  double d_tot;
  
  
  uint8_t WNt;
  
  uint8_t WNlsf;
  
  uint8_t DN;
} _sub4_18;

typedef struct {
  unsigned char svf[33];
  
  uint8_t svhx[8];
} _sub4_25;

typedef struct {
  struct almanac_t almanac;
} _sub5;

typedef struct {
  uint8_t toa;
  long l_toa;
  
  uint8_t WNa;
  
  uint8_t sv[25];
} _sub5_25;

typedef struct {
  unsigned int status;		                       
  signed turn;			                  
  
  
  
  unsigned int speed;			                                    
  
  
  bool accuracy;			                       
  
  int lon;				               
  
  int lat;				              
  
  unsigned int course;		                        
  
  unsigned int heading;		                  
  
  unsigned int second;		                              
  
  
  
  
  unsigned int maneuver;	                        
  
  bool raim;			               
  unsigned int radio;		                       
} _type1;

typedef struct {
  unsigned int year;			              
  
  unsigned int month;			               
  
  unsigned int day;			             
  
  unsigned int hour;			              
  
  unsigned int minute;		                
  
  unsigned int second;		                
  
  bool accuracy;		                 
  int lon;			               
  int lat;			              
  unsigned int epfd;		                                 
  
  bool raim;			               
  unsigned int radio;		                       
} _type4;

typedef struct {
  unsigned int ais_version;	                       
  unsigned int imo;		                        
  char callsign[7+1];		              
  
  char shipname[20+1];	                 
  unsigned int shiptype;	                    
  unsigned int to_bow;	                      
  unsigned int to_stern;	                        
  unsigned int to_port;	                       
  unsigned int to_starboard;	                            
  unsigned int epfd;		                                  
  unsigned int month;		               
  unsigned int day;		             
  unsigned int hour;		              
  unsigned int minute;	                
  unsigned int draught;	                     
  char destination[20+1];	                      
  unsigned int dte;		                          
  
} _type5;

typedef struct {
  unsigned int seqno;		                     
  unsigned int dest_mmsi;	                      
  bool retransmit;		                     
  
  unsigned int dac;                               
  unsigned int fid;                              
  bool structured;		                             
  
  size_t bitcount;		                           
  union {
    char bitdata[(920 + 7) / 8];
    
    struct {
      char country[2+1];	                     
      char locode[3+1];	               
      char section[5+1];	                     
      char terminal[5+1];	                   
      char hectometre[5+1];	                        
      unsigned int month;	               
      unsigned int day;	             
      unsigned int hour;	              
      unsigned int minute;	                
      unsigned int tugs;	                    
      unsigned int airdraught;	                 
    } dac200fid21;
    
    struct {
      char country[2+1];	                     
      char locode[3+1];	               
      char section[5+1];	                     
      char terminal[5+1];	                   
      char hectometre[5+1];	                        
      unsigned int month;	               
      unsigned int day;	             
      unsigned int hour;	              
      unsigned int minute;	                
      unsigned int status;	            
      
      
      
      
    } dac200fid22;
    
    struct {
      unsigned int crew;	                     
      unsigned int passengers;	                           
      unsigned int personnel;	                          
      
    } dac200fid55;
    
    struct {
      unsigned int ana_int;                                
      unsigned int ana_ext1;                                  
      unsigned int ana_ext2;                                  
      unsigned int racon;                   
      unsigned int light;                   
      bool alarm;                  
      unsigned int stat_ext;                                  
      bool off_pos;                             
    } dac235fid10;
    
    struct {
      char lastport[5+1];		                       
      unsigned int lmonth;	               
      unsigned int lday;		             
      unsigned int lhour;		              
      unsigned int lminute;	                
      char nextport[5+1];		                       
      unsigned int nmonth;	               
      unsigned int nday;		             
      unsigned int nhour;		              
      unsigned int nminute;	                
      char dangerous[20+1];	                         
      char imdcat[4+1];		                  
      unsigned int unid;		               
      unsigned int amount;	                     
      unsigned int unit;		                      
    } dac1fid12;
    
    struct {
      unsigned int airdraught;	                 
    } dac1fid15;
    
    struct {
      unsigned persons;	                       
    } dac1fid16;
    
    struct {
      unsigned int linkage;	                        
      unsigned int month;	                 
      unsigned int day;	               
      unsigned int hour;	                
      unsigned int minute;	                  
      char portname[20+1];	                          
      char destination[5+1];	                 
      signed int lon;	               
      signed int lat;	              
    } dac1fid18;
    
    struct {
      unsigned int linkage;	                        
      unsigned int berth_length;	                  
      unsigned int berth_depth;	                       
      unsigned int position;	                      
      unsigned int month;	                 
      unsigned int day;	               
      unsigned int hour;	                
      unsigned int minute;	                  
      unsigned int availability;	                           
      unsigned int agent;	           
      unsigned int fuel;	                 
      unsigned int chandler;	              
      unsigned int stevedore;	               
      unsigned int electrical;	                
      unsigned int water;	                   
      unsigned int customs;	                   
      unsigned int cartage;	             
      unsigned int crane;	              
      unsigned int lift;	             
      unsigned int medical;	                        
      unsigned int navrepair;	                       
      unsigned int provisions;	                
      unsigned int shiprepair;	                 
      unsigned int surveyor;	              
      unsigned int steam;	           
      unsigned int tugs;	          
      unsigned int solidwaste;	                            
      unsigned int liquidwaste;	                             
      unsigned int hazardouswaste;	                                
      unsigned int ballast;	                               
      unsigned int additional;	                         
      unsigned int regional1;	                         
      unsigned int regional2;	                         
      unsigned int future1;	                         
      unsigned int future2;	                         
      char berth_name[20+1];	                   
      signed int berth_lon;	               
      signed int berth_lat;	              
    } dac1fid20;
    
    
    struct {
      bool wmo;			                         
      union {
        struct {
          char location[20+1];	              
          signed int lon;		               
          signed int lat;		              
          unsigned int day;		                
          unsigned int hour;		                 
          unsigned int minute;	                   
          bool vislimit;		                
          unsigned int visibility;	                     
          
          
          unsigned humidity;		                 
          unsigned int wspeed;	                        
          unsigned int wgust;		               
          
          unsigned int wdir;		                    
          
          unsigned int pressure;	                       
          
          
          
          unsigned int pressuretend;	              
          int airtemp;		                      
          
          
          unsigned int watertemp;	                   
          
          
          unsigned int waveperiod;	                
          
          unsigned int wavedir;	                      
          
          unsigned int swellheight;	                   
          unsigned int swellperiod;	                
          unsigned int swelldir;	                      
        } nonwmo_obs;
        struct {
          signed int lon;		               
          signed int lat;		              
          unsigned int month;		               
          unsigned int day;		                
          unsigned int hour;		                 
          unsigned int minute;	                   
          unsigned int course;	                        
          unsigned int speed;		                
          
          
          
          unsigned int heading;	                  
          
          
          unsigned int pressure;	                        
          
          
          unsigned int pdelta;	                        
          
          
          unsigned int ptend;		                
          unsigned int twinddir;	                       
          
          unsigned int twindspeed;	                       
          
          
          unsigned int rwinddir;	                       
          
          unsigned int rwindspeed;	                       
          
          
          unsigned int mgustspeed;	                       
          
          
          unsigned int mgustdir;	                       
          
          unsigned int airtemp;	               
          
          unsigned humidity;		                 
          
          
        } wmo_obs;
      };
    } dac1fid21;
    
    
    struct {
      unsigned int unit;	                      
      unsigned int amount;	                     
      int ncargos;
      struct         {
        unsigned int code;	                
        unsigned int subtype;	                   
      } cargos[28];
    } dac1fid25;
    
    struct route_info dac1fid28;
    
    struct {
      unsigned int linkage;
      
      char text[154];
    } dac1fid30;
    
    struct {
      unsigned int month;	           
      unsigned int day;	         
      signed int ntidals;
      struct         {
        signed int lon;	               
        signed int lat;	              
        unsigned int from_hour;	                   
        unsigned int from_min;	                     
        unsigned int to_hour;	                 
        unsigned int to_min;	                   
        
        unsigned int cdir;	                            
        
        unsigned int cspeed;	                             
      } tidals[3];
    } dac1fid32;
  };
} _type6;

typedef struct {
  unsigned int mmsi1;
  unsigned int mmsi2;
  unsigned int mmsi3;
  unsigned int mmsi4;
  
} _type7;

typedef struct {
  unsigned int dac;       	                          
  unsigned int fid;       	                   
  
  size_t bitcount;		                           
  bool structured;		                             
  union {
    char bitdata[(952 + 7) / 8];
    
    struct {
      char vin[8+1];      	                        
      unsigned int length;	                    
      unsigned int beam;  	                  
      unsigned int shiptype;	                           
      unsigned int hazard;	                     
      
      unsigned int draught;	             
      unsigned int loaded;	                     
      bool speed_q;	                        
      bool course_q;	                         
      bool heading_q;	                          
    } dac200fid10;
    
    struct {
      unsigned int start_year;	                
      unsigned int start_month;	                 
      unsigned int start_day;	               
      unsigned int end_year;	              
      unsigned int end_month;	               
      unsigned int end_day;	             
      unsigned int start_hour;	                
      unsigned int start_minute;	                  
      unsigned int end_hour;	              
      unsigned int end_minute;	                
      signed int start_lon;	                     
      signed int start_lat;	                    
      signed int end_lon;	                   
      signed int end_lat;	                  
      unsigned int type;	          
      
      signed int min;	               
      
      signed int max;	               
      
      unsigned int intensity;	                    
      
      unsigned int wind;	                    
      
    } dac200fid23;
    struct {
      char country[2+1];	                     
      signed int ngauges;
      struct         {
        unsigned int id;	              
        
        signed int level;	                 
        
      } gauges[4];
    } dac200fid24;
    struct {
      signed int lon;	                      
      signed int lat;	                     
      unsigned int form;	                 
      
      unsigned int facing;	                        
      
      unsigned int direction;	                         
      
      unsigned int status;	                  
      
    } dac200fid40;
    
    struct {
      int lon;			                                 
      
      int lat;			                                
      
      unsigned int day;		             
      unsigned int hour;		              
      unsigned int minute;	                
      unsigned int wspeed;	                        
      unsigned int wgust;		               
      
      unsigned int wdir;		                    
      unsigned int wgustdir;	                         
      
      unsigned int airtemp;	                             
      
      
      
      unsigned int humidity;	                          
      
      unsigned int dewpoint;	                           
      
      
      
      unsigned int pressure;	                       
      
      
      unsigned int pressuretend;	              
      
      unsigned int visibility;	                              
      
      
      int waterlevel;		                
      
      
      
      unsigned int leveltrend;	                            
      
      unsigned int cspeed;	                                        
      
      
      unsigned int cdir;		                                   
      
      unsigned int cspeed2;	                                
      unsigned int cdir2;		                           
      unsigned int cdepth2;	                          
      
      unsigned int cspeed3;	                                
      unsigned int cdir3;		                           
      unsigned int cdepth3;	                          
      unsigned int waveheight;	                   
      
      
      unsigned int waveperiod;	                
      
      unsigned int wavedir;	                          
      
      unsigned int swellheight;	                   
      unsigned int swellperiod;	                
      unsigned int swelldir;	                          
      unsigned int seastate;	                          
      
      unsigned int watertemp;	                          
      
      
      
      unsigned int preciptype;	                     
      
      unsigned int salinity;	                     
      
      
      unsigned int ice;		                       
      
    } dac1fid11;
    
    struct {
      char reason[20+1];		                        
      char closefrom[20+1];	                              
      char closeto[20+1];		                            
      unsigned int radius;	                      
      
      unsigned int extunit;	                       
      
      unsigned int fday;		                    
      unsigned int fmonth;	                      
      unsigned int fhour;		                     
      unsigned int fminute;	                       
      unsigned int tday;		                  
      unsigned int tmonth;	                    
      unsigned int thour;		                   
      unsigned int tminute;	                     
    } dac1fid13;
    
    struct {
      unsigned int airdraught;	                 
    } dac1fid15;
    
    struct {
      unsigned persons;	                       
    } dac1fid16;
    
    struct {
      signed int ntargets;
      struct          {
        unsigned int idtype;	                     
        union           {
          unsigned int mmsi;
          unsigned int imo;
          
          char callsign[7+1];
          char other[7+1];
        } id;
        signed int lat;		              
        signed int lon;		               
        
        unsigned int course;	                        
        unsigned int second;	                
        
        unsigned int speed;	                       
      } targets[4];
    } dac1fid17;
    
    struct {
      unsigned int linkage;	                        
      char station[20+1];		                            
      signed int lon;		               
      signed int lat;		              
      unsigned int status;	                      
      unsigned int signal;	                       
      unsigned int hour;		              
      unsigned int minute;	                
      unsigned int nextsignal;	                          
    } dac1fid19;
    
    struct route_info dac1fid27;
    
    struct {
      unsigned int linkage;
      
      char text[162];
    } dac1fid29;
    
    struct {
      bool accuracy;	                                     
      
      int lon;		                                 
      
      int lat;		                                 
      
      unsigned int day;		             
      unsigned int hour;		              
      unsigned int minute;	                
      unsigned int wspeed;	                        
      unsigned int wgust;		               
      
      
      unsigned int wdir;		                    
      unsigned int wgustdir;	                         
      
      int airtemp;		                             
      
      
      unsigned int humidity;	                          
      
      int dewpoint;		                           
      
      
      unsigned int pressure;	                       
      
      
      
      unsigned int pressuretend;	              
      
      bool visgreater;                                         
      unsigned int visibility;	                              
      
      
      int waterlevel;		        
      
      
      
      unsigned int leveltrend;	                            
      
      unsigned int cspeed;	                                
      
      
      unsigned int cdir;		                           
      unsigned int cspeed2;	                                
      unsigned int cdir2;		                           
      unsigned int cdepth2;	                             
      
      
      unsigned int cspeed3;	                                
      unsigned int cdir3;		                           
      unsigned int cdepth3;	                             
      unsigned int waveheight;	                   
      
      
      unsigned int waveperiod;	                
      
      unsigned int wavedir;	                          
      unsigned int swellheight;	                   
      unsigned int swellperiod;	                
      unsigned int swelldir;	                          
      unsigned int seastate;	                          
      
      int watertemp;		                          
      
      
      unsigned int preciptype;	                     
      
      unsigned int salinity;	                                   
      
      
      unsigned int ice;		                       
      
    } dac1fid31;
  };
} _type8;

typedef struct {
  unsigned int alt;		                        
  
  
  unsigned int speed;		                                    
  
  
  bool accuracy;		                       
  int lon;			               
  int lat;			              
  unsigned int course;	                        
  unsigned int second;	                              
  unsigned int regional;	                       
  unsigned int dte;		                          
  
  bool assigned;		                        
  bool raim;			               
  unsigned int radio;		                       
} _type9;

typedef struct {
  unsigned int dest_mmsi;	                      
  
} _type10;

typedef struct {
  unsigned int seqno;		                     
  unsigned int dest_mmsi;	                      
  bool retransmit;		                     
  
  
  char text[157];
} _type12;

typedef struct {
  char text[161];
} _type14;

typedef struct {
  unsigned int mmsi1;
  unsigned int type1_1;
  unsigned int offset1_1;
  
  unsigned int type1_2;
  unsigned int offset1_2;
  
  unsigned int mmsi2;
  unsigned int type2_1;
  unsigned int offset2_1;
  
} _type15;

typedef struct {
  unsigned int mmsi1;
  unsigned int offset1;
  unsigned int increment1;
  unsigned int mmsi2;
  unsigned int offset2;
  unsigned int increment2;
} _type16;

typedef struct {
  int lon;			               
  int lat;			              
  
  
  size_t bitcount;		                           
  char bitdata[(736 + 7) / 8];
} _type17;

typedef struct {
  unsigned int reserved;	                        
  unsigned int speed;		                                    
  bool accuracy;		                       
  int lon;			               
  
  int lat;			              
  
  unsigned int course;	                        
  unsigned int heading;	                  
  unsigned int second;	                              
  unsigned int regional;	                       
  bool cs;     		                             
  bool display;		                                
  bool dsc;   		                                      
  bool band;   		                                      
  bool msg22;	        	                                       
  bool assigned;		                        
  bool raim;			               
  unsigned int radio;		                       
} _type18;

typedef struct {
  unsigned int reserved;	                        
  unsigned int speed;		                                    
  bool accuracy;		                       
  int lon;			               
  int lat;			              
  unsigned int course;	                        
  unsigned int heading;	                  
  unsigned int second;	                              
  unsigned int regional;	                       
  char shipname[20+1];		               
  unsigned int shiptype;	                    
  unsigned int to_bow;	                      
  unsigned int to_stern;	                        
  unsigned int to_port;	                       
  unsigned int to_starboard;	                            
  unsigned int epfd;		                                  
  bool raim;			               
  unsigned int dte;    	                          
  bool assigned;		                        
  
} _type19;

typedef struct {
  unsigned int offset1;	                      
  unsigned int number1;	                                 
  unsigned int timeout1;	                        
  unsigned int increment1;	                      
  unsigned int offset2;	                      
  unsigned int number2;	                                 
  unsigned int timeout2;	                        
  unsigned int increment2;	                      
  unsigned int offset3;	                      
  unsigned int number3;	                                 
  unsigned int timeout3;	                        
  unsigned int increment3;	                      
  unsigned int offset4;	                      
  unsigned int number4;	                                 
  unsigned int timeout4;	                        
  unsigned int increment4;	                      
} _type20;

typedef struct {
  unsigned int aid_type;	              
  char name[35];		                               
  bool accuracy;		                       
  int lon;			               
  int lat;			              
  unsigned int to_bow;	                      
  unsigned int to_stern;	                        
  unsigned int to_port;	                       
  unsigned int to_starboard;	                            
  unsigned int epfd;		                  
  unsigned int second;	                             
  bool off_position;		                            
  unsigned int regional;	                             
  bool raim;			               
  bool virtual_aid;		                         
  bool assigned;		                        
  
} _type21;

typedef struct {
  unsigned int channel_a;	                      
  unsigned int channel_b;	                      
  unsigned int txrx;		                           
  bool power;			                     
  
  union {
    struct {
      int ne_lon;		                         
      int ne_lat;		                        
      int sw_lon;		                         
      int sw_lat;		                        
    } area;
    struct {
      unsigned int dest1;	                              
      unsigned int dest2;	                              
    } mmsi;
  };
  bool addressed;		                                 
  bool band_a;		                                   
  bool band_b;		                                   
  unsigned int zonesize;	                               
} _type22;

typedef struct {
  int ne_lon;			                         
  int ne_lat;			                        
  int sw_lon;			                         
  int sw_lat;			                        
  
  unsigned int stationtype;	                       
  unsigned int shiptype;	                    
  
  unsigned int txrx;		                          
  unsigned int interval;	                     
  unsigned int quiet;		                
  
} _type23;

typedef struct {
  char shipname[20+1];	                 
  enum {
    both,
    part_a,
    part_b,
  } part;
  unsigned int shiptype;	                    
  char vendorid[8];		               
  unsigned int model;		                     
  unsigned int serial;	                   
  char callsign[8];		              
  union {
    unsigned int mothership_mmsi;	                         
    struct {
      unsigned int to_bow;	                      
      unsigned int to_stern;	                        
      unsigned int to_port;	                       
      unsigned int to_starboard;	                            
    } dim;
  };
} _type24;

typedef struct {
  bool addressed;		                                 
  bool structured;		                            
  unsigned int dest_mmsi;	                      
  unsigned int app_id;                            
  
  size_t bitcount;		                           
  char bitdata[(128 + 7) / 8];
} _type25;

typedef struct {
  bool addressed;		                                 
  bool structured;		                            
  unsigned int dest_mmsi;	                      
  unsigned int app_id;                            
  
  size_t bitcount;		                           
  char bitdata[(1004 + 7) / 8];
  unsigned int radio;		                       
} _type26;

typedef struct {
  bool accuracy;		                       
  bool raim;			               
  unsigned int status;	                       
  
  int lon;			               
  
  int lat;			              
  
  unsigned int speed;		                                    
  
  unsigned int course;	                        
  
  bool gnss;			                                     
} _type27;

typedef struct {
  timestamp_t time;
  int ndevices;
  struct devconfig_t list[4];
} gps_data_t_devices;


	swigNewline();

	swigComment("----===< int constants ===>-----\n");
	#ifdef GPSD_API_MAJOR_VERSION
		swigIntConstant( GPSD_API_MAJOR_VERSION, "GPSD_API_MAJOR_VERSION" );
	#endif
	#ifdef GPSD_API_MINOR_VERSION
		swigIntConstant( GPSD_API_MINOR_VERSION, "GPSD_API_MINOR_VERSION" );
	#endif
	#ifdef MAXCHANNELS
		swigIntConstant( MAXCHANNELS, "MAXCHANNELS" );
	#endif
	#ifdef MAXUSERDEVS
		swigIntConstant( MAXUSERDEVS, "MAXUSERDEVS" );
	#endif
	#ifdef GPS_PATH_MAX
		swigIntConstant( GPS_PATH_MAX, "GPS_PATH_MAX" );
	#endif
	#ifdef MODE_NOT_SEEN
		swigIntConstant( MODE_NOT_SEEN, "MODE_NOT_SEEN" );
	#endif
	#ifdef MODE_NO_FIX
		swigIntConstant( MODE_NO_FIX, "MODE_NO_FIX" );
	#endif
	#ifdef MODE_2D
		swigIntConstant( MODE_2D, "MODE_2D" );
	#endif
	#ifdef MODE_3D
		swigIntConstant( MODE_3D, "MODE_3D" );
	#endif
	#ifdef GLONASS_PRN_OFFSET
		swigIntConstant( GLONASS_PRN_OFFSET, "GLONASS_PRN_OFFSET" );
	#endif
	#ifdef RTCM2_WORDS_MAX
		swigIntConstant( RTCM2_WORDS_MAX, "RTCM2_WORDS_MAX" );
	#endif
	#ifdef MAXCORRECTIONS
		swigIntConstant( MAXCORRECTIONS, "MAXCORRECTIONS" );
	#endif
	#ifdef MAXSTATIONS
		swigIntConstant( MAXSTATIONS, "MAXSTATIONS" );
	#endif
	#ifdef MAXHEALTH
		swigIntConstant( MAXHEALTH, "MAXHEALTH" );
	#endif
	#ifdef NAVSYSTEM_GPS
		swigIntConstant( NAVSYSTEM_GPS, "NAVSYSTEM_GPS" );
	#endif
	#ifdef NAVSYSTEM_GLONASS
		swigIntConstant( NAVSYSTEM_GLONASS, "NAVSYSTEM_GLONASS" );
	#endif
	#ifdef NAVSYSTEM_GALILEO
		swigIntConstant( NAVSYSTEM_GALILEO, "NAVSYSTEM_GALILEO" );
	#endif
	#ifdef NAVSYSTEM_UNKNOWN
		swigIntConstant( NAVSYSTEM_UNKNOWN, "NAVSYSTEM_UNKNOWN" );
	#endif
	#ifdef HEALTH_NORMAL
		swigIntConstant( HEALTH_NORMAL, "HEALTH_NORMAL" );
	#endif
	#ifdef HEALTH_UNMONITORED
		swigIntConstant( HEALTH_UNMONITORED, "HEALTH_UNMONITORED" );
	#endif
	#ifdef HEALTH_NOINFO
		swigIntConstant( HEALTH_NOINFO, "HEALTH_NOINFO" );
	#endif
	#ifdef HEALTH_DONOTUSE
		swigIntConstant( HEALTH_DONOTUSE, "HEALTH_DONOTUSE" );
	#endif
	#ifdef SNR_BAD
		swigIntConstant( SNR_BAD, "SNR_BAD" );
	#endif
	#ifdef RTCM3_MAX_SATELLITES
		swigIntConstant( RTCM3_MAX_SATELLITES, "RTCM3_MAX_SATELLITES" );
	#endif
	#ifdef RTCM3_MAX_DESCRIPTOR
		swigIntConstant( RTCM3_MAX_DESCRIPTOR, "RTCM3_MAX_DESCRIPTOR" );
	#endif
	#ifdef RTCM3_MAX_ANNOUNCEMENTS
		swigIntConstant( RTCM3_MAX_ANNOUNCEMENTS, "RTCM3_MAX_ANNOUNCEMENTS" );
	#endif
	#ifdef AIS_LON3_NOT_AVAILABLE
		swigIntConstant( AIS_LON3_NOT_AVAILABLE, "AIS_LON3_NOT_AVAILABLE" );
	#endif
	#ifdef AIS_LAT3_NOT_AVAILABLE
		swigIntConstant( AIS_LAT3_NOT_AVAILABLE, "AIS_LAT3_NOT_AVAILABLE" );
	#endif
	#ifdef AIS_LON4_NOT_AVAILABLE
		swigIntConstant( AIS_LON4_NOT_AVAILABLE, "AIS_LON4_NOT_AVAILABLE" );
	#endif
	#ifdef AIS_LAT4_NOT_AVAILABLE
		swigIntConstant( AIS_LAT4_NOT_AVAILABLE, "AIS_LAT4_NOT_AVAILABLE" );
	#endif
	#ifdef DAC1FID32_CDIR_NOT_AVAILABLE
		swigIntConstant( DAC1FID32_CDIR_NOT_AVAILABLE, "DAC1FID32_CDIR_NOT_AVAILABLE" );
	#endif
	#ifdef DAC1FID32_CSPEED_NOT_AVAILABLE
		swigIntConstant( DAC1FID32_CSPEED_NOT_AVAILABLE, "DAC1FID32_CSPEED_NOT_AVAILABLE" );
	#endif
	#ifdef DAC200FID24_GAUGE_ID_UNKNOWN
		swigIntConstant( DAC200FID24_GAUGE_ID_UNKNOWN, "DAC200FID24_GAUGE_ID_UNKNOWN" );
	#endif
	#ifdef DAC200FID24_GAUGE_LEVEL_UNKNOWN
		swigIntConstant( DAC200FID24_GAUGE_LEVEL_UNKNOWN, "DAC200FID24_GAUGE_LEVEL_UNKNOWN" );
	#endif
	#ifdef DAC1FID17_ID_LENGTH
		swigIntConstant( DAC1FID17_ID_LENGTH, "DAC1FID17_ID_LENGTH" );
	#endif
	#ifdef DAC1FID17_IDTYPE_MMSI
		swigIntConstant( DAC1FID17_IDTYPE_MMSI, "DAC1FID17_IDTYPE_MMSI" );
	#endif
	#ifdef DAC1FID17_IDTYPE_IMO
		swigIntConstant( DAC1FID17_IDTYPE_IMO, "DAC1FID17_IDTYPE_IMO" );
	#endif
	#ifdef DAC1FID17_IDTYPE_CALLSIGN
		swigIntConstant( DAC1FID17_IDTYPE_CALLSIGN, "DAC1FID17_IDTYPE_CALLSIGN" );
	#endif
	#ifdef DAC1FID17_IDTYPE_OTHER
		swigIntConstant( DAC1FID17_IDTYPE_OTHER, "DAC1FID17_IDTYPE_OTHER" );
	#endif
	#ifdef DAC1FID17_COURSE_NOT_AVAILABLE
		swigIntConstant( DAC1FID17_COURSE_NOT_AVAILABLE, "DAC1FID17_COURSE_NOT_AVAILABLE" );
	#endif
	#ifdef DAC1FID17_SPEED_NOT_AVAILABLE
		swigIntConstant( DAC1FID17_SPEED_NOT_AVAILABLE, "DAC1FID17_SPEED_NOT_AVAILABLE" );
	#endif
	#ifdef SAT_ACQUIRED
		swigIntConstant( SAT_ACQUIRED, "SAT_ACQUIRED" );
	#endif
	#ifdef SAT_CODE_TRACK
		swigIntConstant( SAT_CODE_TRACK, "SAT_CODE_TRACK" );
	#endif
	#ifdef SAT_CARR_TRACK
		swigIntConstant( SAT_CARR_TRACK, "SAT_CARR_TRACK" );
	#endif
	#ifdef SAT_DATA_SYNC
		swigIntConstant( SAT_DATA_SYNC, "SAT_DATA_SYNC" );
	#endif
	#ifdef SAT_FRAME_SYNC
		swigIntConstant( SAT_FRAME_SYNC, "SAT_FRAME_SYNC" );
	#endif
	#ifdef SAT_EPHEMERIS
		swigIntConstant( SAT_EPHEMERIS, "SAT_EPHEMERIS" );
	#endif
	#ifdef SAT_FIX_USED
		swigIntConstant( SAT_FIX_USED, "SAT_FIX_USED" );
	#endif
	#ifdef SEEN_GPS
		swigIntConstant( SEEN_GPS, "SEEN_GPS" );
	#endif
	#ifdef SEEN_RTCM2
		swigIntConstant( SEEN_RTCM2, "SEEN_RTCM2" );
	#endif
	#ifdef SEEN_RTCM3
		swigIntConstant( SEEN_RTCM3, "SEEN_RTCM3" );
	#endif
	#ifdef SEEN_AIS
		swigIntConstant( SEEN_AIS, "SEEN_AIS" );
	#endif
	#ifdef WATCH_ENABLE
		swigUnsignedIntConstant( WATCH_ENABLE, "WATCH_ENABLE" );
	#endif
	#ifdef WATCH_DISABLE
		swigUnsignedIntConstant( WATCH_DISABLE, "WATCH_DISABLE" );
	#endif
	#ifdef WATCH_JSON
		swigUnsignedIntConstant( WATCH_JSON, "WATCH_JSON" );
	#endif
	#ifdef WATCH_NMEA
		swigUnsignedIntConstant( WATCH_NMEA, "WATCH_NMEA" );
	#endif
	#ifdef WATCH_RARE
		swigUnsignedIntConstant( WATCH_RARE, "WATCH_RARE" );
	#endif
	#ifdef WATCH_RAW
		swigUnsignedIntConstant( WATCH_RAW, "WATCH_RAW" );
	#endif
	#ifdef WATCH_SCALED
		swigUnsignedIntConstant( WATCH_SCALED, "WATCH_SCALED" );
	#endif
	#ifdef WATCH_TIMING
		swigUnsignedIntConstant( WATCH_TIMING, "WATCH_TIMING" );
	#endif
	#ifdef WATCH_DEVICE
		swigUnsignedIntConstant( WATCH_DEVICE, "WATCH_DEVICE" );
	#endif
	#ifdef WATCH_SPLIT24
		swigUnsignedIntConstant( WATCH_SPLIT24, "WATCH_SPLIT24" );
	#endif
	#ifdef WATCH_PPS
		swigUnsignedIntConstant( WATCH_PPS, "WATCH_PPS" );
	#endif
	#ifdef WATCH_NEWSTYLE
		swigUnsignedIntConstant( WATCH_NEWSTYLE, "WATCH_NEWSTYLE" );
	#endif
	#ifdef SET_HIGH_BIT
		swigIntConstant( SET_HIGH_BIT, "SET_HIGH_BIT" );
	#endif
	#ifdef STATUS_NO_FIX
		swigIntConstant( STATUS_NO_FIX, "STATUS_NO_FIX" );
	#endif
	#ifdef STATUS_FIX
		swigIntConstant( STATUS_FIX, "STATUS_FIX" );
	#endif
	#ifdef WGS84A
		swigIntConstant( WGS84A, "WGS84A" );
	#endif
	#ifdef NL_NOSERVICE
		swigIntConstant( NL_NOSERVICE, "NL_NOSERVICE" );
	#endif
	#ifdef NL_NOHOST
		swigIntConstant( NL_NOHOST, "NL_NOHOST" );
	#endif
	#ifdef NL_NOPROTO
		swigIntConstant( NL_NOPROTO, "NL_NOPROTO" );
	#endif
	#ifdef NL_NOSOCK
		swigIntConstant( NL_NOSOCK, "NL_NOSOCK" );
	#endif
	#ifdef NL_NOSOCKOPT
		swigIntConstant( NL_NOSOCKOPT, "NL_NOSOCKOPT" );
	#endif
	#ifdef NL_NOCONNECT
		swigIntConstant( NL_NOCONNECT, "NL_NOCONNECT" );
	#endif
	#ifdef SHM_NOSHARED
		swigIntConstant( SHM_NOSHARED, "SHM_NOSHARED" );
	#endif
	#ifdef SHM_NOATTACH
		swigIntConstant( SHM_NOATTACH, "SHM_NOATTACH" );
	#endif
	#ifdef DBUS_FAILURE
		swigIntConstant( DBUS_FAILURE, "DBUS_FAILURE" );
	#endif

	swigNewline();

	swigComment("----===< long constants ===>-----\n");
	#ifdef ONLINE_SET
		swigUnsignedLongConstant( ONLINE_SET, "ONLINE_SET" );
	#endif
	#ifdef TIME_SET
		swigUnsignedLongConstant( TIME_SET, "TIME_SET" );
	#endif
	#ifdef TIMERR_SET
		swigUnsignedLongConstant( TIMERR_SET, "TIMERR_SET" );
	#endif
	#ifdef LATLON_SET
		swigUnsignedLongConstant( LATLON_SET, "LATLON_SET" );
	#endif
	#ifdef ALTITUDE_SET
		swigUnsignedLongConstant( ALTITUDE_SET, "ALTITUDE_SET" );
	#endif
	#ifdef SPEED_SET
		swigUnsignedLongConstant( SPEED_SET, "SPEED_SET" );
	#endif
	#ifdef TRACK_SET
		swigUnsignedLongConstant( TRACK_SET, "TRACK_SET" );
	#endif
	#ifdef CLIMB_SET
		swigUnsignedLongConstant( CLIMB_SET, "CLIMB_SET" );
	#endif
	#ifdef STATUS_SET
		swigUnsignedLongConstant( STATUS_SET, "STATUS_SET" );
	#endif
	#ifdef MODE_SET
		swigUnsignedLongConstant( MODE_SET, "MODE_SET" );
	#endif
	#ifdef DOP_SET
		swigUnsignedLongConstant( DOP_SET, "DOP_SET" );
	#endif
	#ifdef HERR_SET
		swigUnsignedLongConstant( HERR_SET, "HERR_SET" );
	#endif
	#ifdef VERR_SET
		swigUnsignedLongConstant( VERR_SET, "VERR_SET" );
	#endif
	#ifdef ATTITUDE_SET
		swigUnsignedLongConstant( ATTITUDE_SET, "ATTITUDE_SET" );
	#endif
	#ifdef SATELLITE_SET
		swigUnsignedLongConstant( SATELLITE_SET, "SATELLITE_SET" );
	#endif
	#ifdef SPEEDERR_SET
		swigUnsignedLongConstant( SPEEDERR_SET, "SPEEDERR_SET" );
	#endif
	#ifdef TRACKERR_SET
		swigUnsignedLongConstant( TRACKERR_SET, "TRACKERR_SET" );
	#endif
	#ifdef CLIMBERR_SET
		swigUnsignedLongConstant( CLIMBERR_SET, "CLIMBERR_SET" );
	#endif
	#ifdef DEVICE_SET
		swigUnsignedLongConstant( DEVICE_SET, "DEVICE_SET" );
	#endif
	#ifdef DEVICELIST_SET
		swigUnsignedLongConstant( DEVICELIST_SET, "DEVICELIST_SET" );
	#endif
	#ifdef DEVICEID_SET
		swigUnsignedLongConstant( DEVICEID_SET, "DEVICEID_SET" );
	#endif
	#ifdef RTCM2_SET
		swigUnsignedLongConstant( RTCM2_SET, "RTCM2_SET" );
	#endif
	#ifdef RTCM3_SET
		swigUnsignedLongConstant( RTCM3_SET, "RTCM3_SET" );
	#endif
	#ifdef AIS_SET
		swigUnsignedLongConstant( AIS_SET, "AIS_SET" );
	#endif
	#ifdef PACKET_SET
		swigUnsignedLongConstant( PACKET_SET, "PACKET_SET" );
	#endif
	#ifdef SUBFRAME_SET
		swigUnsignedLongConstant( SUBFRAME_SET, "SUBFRAME_SET" );
	#endif
	#ifdef GST_SET
		swigUnsignedLongConstant( GST_SET, "GST_SET" );
	#endif
	#ifdef VERSION_SET
		swigUnsignedLongConstant( VERSION_SET, "VERSION_SET" );
	#endif
	#ifdef POLICY_SET
		swigUnsignedLongConstant( POLICY_SET, "POLICY_SET" );
	#endif
	#ifdef LOGMESSAGE_SET
		swigUnsignedLongConstant( LOGMESSAGE_SET, "LOGMESSAGE_SET" );
	#endif
	#ifdef ERROR_SET
		swigUnsignedLongConstant( ERROR_SET, "ERROR_SET" );
	#endif
	#ifdef TOFF_SET
		swigUnsignedLongConstant( TOFF_SET, "TOFF_SET" );
	#endif
	#ifdef PPS_SET
		swigUnsignedLongConstant( PPS_SET, "PPS_SET" );
	#endif
	#ifdef NAVDATA_SET
		swigUnsignedLongConstant( NAVDATA_SET, "NAVDATA_SET" );
	#endif
	#ifdef UNION_SET
		swigUnsignedLongConstant( UNION_SET, "UNION_SET" );
	#endif

	swigNewline();

	swigComment("---===< float constants >===----\n");
	#ifdef GPS_AMBIGUITY_MODULUS
		swigFloatConstant( GPS_AMBIGUITY_MODULUS, "GPS_AMBIGUITY_MODULUS" );
	#endif
	#ifdef GLONASS_AMBIGUITY_MODULUS
		swigFloatConstant( GLONASS_AMBIGUITY_MODULUS, "GLONASS_AMBIGUITY_MODULUS" );
	#endif
	#ifdef MESSAGE_INTERVAL_UNITS
		swigFloatConstant( MESSAGE_INTERVAL_UNITS, "MESSAGE_INTERVAL_UNITS" );
	#endif
	#ifdef AIS_LATLON3_DIV
		swigFloatConstant( AIS_LATLON3_DIV, "AIS_LATLON3_DIV" );
	#endif
	#ifdef AIS_LATLON4_DIV
		swigFloatConstant( AIS_LATLON4_DIV, "AIS_LATLON4_DIV" );
	#endif
	#ifdef METERS_TO_FEET
		swigFloatConstant( METERS_TO_FEET, "METERS_TO_FEET" );
	#endif
	#ifdef METERS_TO_MILES
		swigFloatConstant( METERS_TO_MILES, "METERS_TO_MILES" );
	#endif
	#ifdef METERS_TO_FATHOMS
		swigFloatConstant( METERS_TO_FATHOMS, "METERS_TO_FATHOMS" );
	#endif
	#ifdef KNOTS_TO_MPH
		swigFloatConstant( KNOTS_TO_MPH, "KNOTS_TO_MPH" );
	#endif
	#ifdef KNOTS_TO_KPH
		swigFloatConstant( KNOTS_TO_KPH, "KNOTS_TO_KPH" );
	#endif
	#ifdef KNOTS_TO_MPS
		swigFloatConstant( KNOTS_TO_MPS, "KNOTS_TO_MPS" );
	#endif
	#ifdef MPS_TO_KPH
		swigFloatConstant( MPS_TO_KPH, "MPS_TO_KPH" );
	#endif
	#ifdef MPS_TO_MPH
		swigFloatConstant( MPS_TO_MPH, "MPS_TO_MPH" );
	#endif
	#ifdef MPS_TO_KNOTS
		swigFloatConstant( MPS_TO_KNOTS, "MPS_TO_KNOTS" );
	#endif
	#ifdef GPS_PI
		swigFloatConstant( GPS_PI, "GPS_PI" );
	#endif
	#ifdef RAD_2_DEG
		swigFloatConstant( RAD_2_DEG, "RAD_2_DEG" );
	#endif
	#ifdef DEG_2_RAD
		swigFloatConstant( DEG_2_RAD, "DEG_2_RAD" );
	#endif
	#ifdef WGS84F
		swigFloatConstant( WGS84F, "WGS84F" );
	#endif
	#ifdef WGS84B
		swigFloatConstant( WGS84B, "WGS84B" );
	#endif

	swigNewline();

	swigComment("--------===< enums >===---------\n");
	swigIntConstant( reserved, "reserved" );
	swigIntConstant( correct, "correct" );
	swigIntConstant( widelane, "widelane" );
	swigIntConstant( uncertain, "uncertain" );
	swigIntConstant( reserved_code, "reserved_code" );
	swigIntConstant( p, "p" );
	swigIntConstant( ca, "ca" );
	swigIntConstant( l2c, "l2c" );

	swigNewline();

	swigComment("-------===< structs >===--------\n");

	swigComment("gps_fix_t\n");
	printf( "begin-structure gps_fix_t\n" );
	swigStructField( "gps_fix_t-mode", offsetof( struct gps_fix_t, mode ), sizeof( int ) );
	swigStructField( "gps_fix_t-climb", offsetof( struct gps_fix_t, climb ), sizeof( double ) );
	swigStructField( "gps_fix_t-track", offsetof( struct gps_fix_t, track ), sizeof( double ) );
	swigStructField( "gps_fix_t-altitude", offsetof( struct gps_fix_t, altitude ), sizeof( double ) );
	swigStructField( "gps_fix_t-time", offsetof( struct gps_fix_t, time ), sizeof( timestamp_t ) );
	swigStructField( "gps_fix_t-speed", offsetof( struct gps_fix_t, speed ), sizeof( double ) );
	swigStructField( "gps_fix_t-latitude", offsetof( struct gps_fix_t, latitude ), sizeof( double ) );
	swigStructField( "gps_fix_t-eps", offsetof( struct gps_fix_t, eps ), sizeof( double ) );
	swigStructField( "gps_fix_t-ept", offsetof( struct gps_fix_t, ept ), sizeof( double ) );
	swigStructField( "gps_fix_t-epc", offsetof( struct gps_fix_t, epc ), sizeof( double ) );
	swigStructField( "gps_fix_t-epd", offsetof( struct gps_fix_t, epd ), sizeof( double ) );
	swigStructField( "gps_fix_t-epv", offsetof( struct gps_fix_t, epv ), sizeof( double ) );
	swigStructField( "gps_fix_t-longitude", offsetof( struct gps_fix_t, longitude ), sizeof( double ) );
	swigStructField( "gps_fix_t-epx", offsetof( struct gps_fix_t, epx ), sizeof( double ) );
	swigStructField( "gps_fix_t-epy", offsetof( struct gps_fix_t, epy ), sizeof( double ) );
	printf( "drop %zu end-structure\n", sizeof( struct gps_fix_t ) );

	swigComment("gst_t\n");
	printf( "begin-structure gst_t\n" );
	swigStructField( "gst_t-smajor_orientation", offsetof( struct gst_t, smajor_orientation ), sizeof( double ) );
	swigStructField( "gst_t-utctime", offsetof( struct gst_t, utctime ), sizeof( double ) );
	swigStructField( "gst_t-rms_deviation", offsetof( struct gst_t, rms_deviation ), sizeof( double ) );
	swigStructField( "gst_t-smajor_deviation", offsetof( struct gst_t, smajor_deviation ), sizeof( double ) );
	swigStructField( "gst_t-sminor_deviation", offsetof( struct gst_t, sminor_deviation ), sizeof( double ) );
	swigStructField( "gst_t-lat_err_deviation", offsetof( struct gst_t, lat_err_deviation ), sizeof( double ) );
	swigStructField( "gst_t-lon_err_deviation", offsetof( struct gst_t, lon_err_deviation ), sizeof( double ) );
	swigStructField( "gst_t-alt_err_deviation", offsetof( struct gst_t, alt_err_deviation ), sizeof( double ) );
	printf( "drop %zu end-structure\n", sizeof( struct gst_t ) );

	swigComment("rtcm2_t\n");
	printf( "begin-structure rtcm2_t\n" );
	swigStructField( "rtcm2_t-stathlth", offsetof( struct rtcm2_t, stathlth ), sizeof( unsigned int ) );
	swigStructField( "rtcm2_t-conhealth", offsetof( struct rtcm2_t, conhealth ), sizeof( _conhealth ) );
	swigStructField( "rtcm2_t-zcount", offsetof( struct rtcm2_t, zcount ), sizeof( double ) );
	swigStructField( "rtcm2_t-length", offsetof( struct rtcm2_t, length ), sizeof( unsigned int ) );
	swigStructField( "rtcm2_t-reference", offsetof( struct rtcm2_t, reference ), sizeof( _reference ) );
	swigStructField( "rtcm2_t-gpstime", offsetof( struct rtcm2_t, gpstime ), sizeof( _gpstime ) );
	swigStructField( "rtcm2_t-message", offsetof( struct rtcm2_t, message ), sizeof( char [(33-2) *sizeof(isgps30bits_t)] ) );
	swigStructField( "rtcm2_t-seqnum", offsetof( struct rtcm2_t, seqnum ), sizeof( unsigned int ) );
	swigStructField( "rtcm2_t-words", offsetof( struct rtcm2_t, words ), sizeof( isgps30bits_t [33-2] ) );
	swigStructField( "rtcm2_t-xmitter", offsetof( struct rtcm2_t, xmitter ), sizeof( _xmitter ) );
	swigStructField( "rtcm2_t-almanac", offsetof( struct rtcm2_t, almanac ), sizeof( _almanac ) );
	swigStructField( "rtcm2_t-type", offsetof( struct rtcm2_t, type ), sizeof( unsigned int ) );
	swigStructField( "rtcm2_t-refstaid", offsetof( struct rtcm2_t, refstaid ), sizeof( unsigned int ) );
	swigStructField( "rtcm2_t-glonass_ranges", offsetof( struct rtcm2_t, glonass_ranges ), sizeof( _glonass_ranges ) );
	swigStructField( "rtcm2_t-gps_ranges", offsetof( struct rtcm2_t, gps_ranges ), sizeof( _gps_ranges ) );
	swigStructField( "rtcm2_t-ecef", offsetof( struct rtcm2_t, ecef ), sizeof( _ecef ) );
	printf( "drop %zu end-structure\n", sizeof( struct rtcm2_t ) );

	swigComment("gps_rangesat_t\n");
	printf( "begin-structure gps_rangesat_t\n" );
	swigStructField( "gps_rangesat_t-prc", offsetof( struct gps_rangesat_t, prc ), sizeof( double ) );
	swigStructField( "gps_rangesat_t-ident", offsetof( struct gps_rangesat_t, ident ), sizeof( unsigned int ) );
	swigStructField( "gps_rangesat_t-iod", offsetof( struct gps_rangesat_t, iod ), sizeof( unsigned int ) );
	swigStructField( "gps_rangesat_t-udre", offsetof( struct gps_rangesat_t, udre ), sizeof( unsigned int ) );
	swigStructField( "gps_rangesat_t-rrc", offsetof( struct gps_rangesat_t, rrc ), sizeof( double ) );
	printf( "drop %zu end-structure\n", sizeof( struct gps_rangesat_t ) );

	swigComment("consat_t\n");
	printf( "begin-structure consat_t\n" );
	swigStructField( "consat_t-health", offsetof( struct consat_t, health ), sizeof( unsigned int ) );
	swigStructField( "consat_t-snr", offsetof( struct consat_t, snr ), sizeof( int ) );
	swigStructField( "consat_t-new_data", offsetof( struct consat_t, new_data ), sizeof( bool ) );
	swigStructField( "consat_t-health_en", offsetof( struct consat_t, health_en ), sizeof( bool ) );
	swigStructField( "consat_t-iodl", offsetof( struct consat_t, iodl ), sizeof( bool ) );
	swigStructField( "consat_t-tou", offsetof( struct consat_t, tou ), sizeof( unsigned int ) );
	swigStructField( "consat_t-ident", offsetof( struct consat_t, ident ), sizeof( unsigned int ) );
	swigStructField( "consat_t-los_warning", offsetof( struct consat_t, los_warning ), sizeof( bool ) );
	printf( "drop %zu end-structure\n", sizeof( struct consat_t ) );

	swigComment("station_t\n");
	printf( "begin-structure station_t\n" );
	swigStructField( "station_t-health", offsetof( struct station_t, health ), sizeof( unsigned int ) );
	swigStructField( "station_t-latitude", offsetof( struct station_t, latitude ), sizeof( double ) );
	swigStructField( "station_t-station_id", offsetof( struct station_t, station_id ), sizeof( unsigned int ) );
	swigStructField( "station_t-frequency", offsetof( struct station_t, frequency ), sizeof( double ) );
	swigStructField( "station_t-longitude", offsetof( struct station_t, longitude ), sizeof( double ) );
	swigStructField( "station_t-range", offsetof( struct station_t, range ), sizeof( unsigned int ) );
	swigStructField( "station_t-bitrate", offsetof( struct station_t, bitrate ), sizeof( unsigned int ) );
	printf( "drop %zu end-structure\n", sizeof( struct station_t ) );

	swigComment("glonass_rangesat_t\n");
	printf( "begin-structure glonass_rangesat_t\n" );
	swigStructField( "glonass_rangesat_t-change", offsetof( struct glonass_rangesat_t, change ), sizeof( bool ) );
	swigStructField( "glonass_rangesat_t-prc", offsetof( struct glonass_rangesat_t, prc ), sizeof( double ) );
	swigStructField( "glonass_rangesat_t-ident", offsetof( struct glonass_rangesat_t, ident ), sizeof( unsigned int ) );
	swigStructField( "glonass_rangesat_t-udre", offsetof( struct glonass_rangesat_t, udre ), sizeof( unsigned int ) );
	swigStructField( "glonass_rangesat_t-tod", offsetof( struct glonass_rangesat_t, tod ), sizeof( unsigned int ) );
	swigStructField( "glonass_rangesat_t-rrc", offsetof( struct glonass_rangesat_t, rrc ), sizeof( double ) );
	printf( "drop %zu end-structure\n", sizeof( struct glonass_rangesat_t ) );

	swigComment("rtcm3_rtk_hdr\n");
	printf( "begin-structure rtcm3_rtk_hdr\n" );
	swigStructField( "rtcm3_rtk_hdr-sync", offsetof( struct rtcm3_rtk_hdr, sync ), sizeof( bool ) );
	swigStructField( "rtcm3_rtk_hdr-satcount", offsetof( struct rtcm3_rtk_hdr, satcount ), sizeof( unsigned short ) );
	swigStructField( "rtcm3_rtk_hdr-smoothing", offsetof( struct rtcm3_rtk_hdr, smoothing ), sizeof( bool ) );
	swigStructField( "rtcm3_rtk_hdr-station_id", offsetof( struct rtcm3_rtk_hdr, station_id ), sizeof( unsigned int ) );
	swigStructField( "rtcm3_rtk_hdr-interval", offsetof( struct rtcm3_rtk_hdr, interval ), sizeof( unsigned int ) );
	swigStructField( "rtcm3_rtk_hdr-tow", offsetof( struct rtcm3_rtk_hdr, tow ), sizeof( time_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct rtcm3_rtk_hdr ) );

	swigComment("rtcm3_basic_rtk\n");
	printf( "begin-structure rtcm3_basic_rtk\n" );
	swigStructField( "rtcm3_basic_rtk-indicator", offsetof( struct rtcm3_basic_rtk, indicator ), sizeof( unsigned char ) );
	swigStructField( "rtcm3_basic_rtk-channel", offsetof( struct rtcm3_basic_rtk, channel ), sizeof( unsigned int ) );
	swigStructField( "rtcm3_basic_rtk-rangediff", offsetof( struct rtcm3_basic_rtk, rangediff ), sizeof( double ) );
	swigStructField( "rtcm3_basic_rtk-pseudorange", offsetof( struct rtcm3_basic_rtk, pseudorange ), sizeof( double ) );
	swigStructField( "rtcm3_basic_rtk-locktime", offsetof( struct rtcm3_basic_rtk, locktime ), sizeof( unsigned char ) );
	printf( "drop %zu end-structure\n", sizeof( struct rtcm3_basic_rtk ) );

	swigComment("rtcm3_extended_rtk\n");
	printf( "begin-structure rtcm3_extended_rtk\n" );
	swigStructField( "rtcm3_extended_rtk-indicator", offsetof( struct rtcm3_extended_rtk, indicator ), sizeof( unsigned char ) );
	swigStructField( "rtcm3_extended_rtk-channel", offsetof( struct rtcm3_extended_rtk, channel ), sizeof( unsigned int ) );
	swigStructField( "rtcm3_extended_rtk-rangediff", offsetof( struct rtcm3_extended_rtk, rangediff ), sizeof( double ) );
	swigStructField( "rtcm3_extended_rtk-pseudorange", offsetof( struct rtcm3_extended_rtk, pseudorange ), sizeof( double ) );
	swigStructField( "rtcm3_extended_rtk-locktime", offsetof( struct rtcm3_extended_rtk, locktime ), sizeof( unsigned char ) );
	swigStructField( "rtcm3_extended_rtk-CNR", offsetof( struct rtcm3_extended_rtk, CNR ), sizeof( double ) );
	swigStructField( "rtcm3_extended_rtk-ambiguity", offsetof( struct rtcm3_extended_rtk, ambiguity ), sizeof( unsigned char ) );
	printf( "drop %zu end-structure\n", sizeof( struct rtcm3_extended_rtk ) );

	swigComment("rtcm3_network_rtk_header\n");
	printf( "begin-structure rtcm3_network_rtk_header\n" );
	swigStructField( "rtcm3_network_rtk_header-satcount", offsetof( struct rtcm3_network_rtk_header, satcount ), sizeof( unsigned char ) );
	swigStructField( "rtcm3_network_rtk_header-network_id", offsetof( struct rtcm3_network_rtk_header, network_id ), sizeof( unsigned int ) );
	swigStructField( "rtcm3_network_rtk_header-subnetwork_id", offsetof( struct rtcm3_network_rtk_header, subnetwork_id ), sizeof( unsigned int ) );
	swigStructField( "rtcm3_network_rtk_header-master_id", offsetof( struct rtcm3_network_rtk_header, master_id ), sizeof( unsigned int ) );
	swigStructField( "rtcm3_network_rtk_header-time", offsetof( struct rtcm3_network_rtk_header, time ), sizeof( time_t ) );
	swigStructField( "rtcm3_network_rtk_header-multimesg", offsetof( struct rtcm3_network_rtk_header, multimesg ), sizeof( bool ) );
	swigStructField( "rtcm3_network_rtk_header-aux_id", offsetof( struct rtcm3_network_rtk_header, aux_id ), sizeof( unsigned int ) );
	printf( "drop %zu end-structure\n", sizeof( struct rtcm3_network_rtk_header ) );

	swigComment("rtcm3_correction_diff\n");
	printf( "begin-structure rtcm3_correction_diff\n" );
	swigStructField( "rtcm3_correction_diff-nonsync", offsetof( struct rtcm3_correction_diff, nonsync ), sizeof( unsigned char ) );
	swigStructField( "rtcm3_correction_diff-geometric_diff", offsetof( struct rtcm3_correction_diff, geometric_diff ), sizeof( double ) );
	swigStructField( "rtcm3_correction_diff-iode", offsetof( struct rtcm3_correction_diff, iode ), sizeof( unsigned char ) );
	swigStructField( "rtcm3_correction_diff-ionospheric_diff", offsetof( struct rtcm3_correction_diff, ionospheric_diff ), sizeof( double ) );
	swigStructField( "rtcm3_correction_diff-ident", offsetof( struct rtcm3_correction_diff, ident ), sizeof( unsigned char ) );
	swigStructField( "rtcm3_correction_diff-ambiguity", offsetof( struct rtcm3_correction_diff, ambiguity ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( struct rtcm3_correction_diff ) );

	swigComment("rtcm3_t\n");
	printf( "begin-structure rtcm3_t\n" );
	swigStructField( "rtcm3_t-rtcmtypes", offsetof( struct rtcm3_t, rtcmtypes ), sizeof( rtcm3_t_rtcmtypes ) );
	swigStructField( "rtcm3_t-type", offsetof( struct rtcm3_t, type ), sizeof( unsigned int ) );
	swigStructField( "rtcm3_t-length", offsetof( struct rtcm3_t, length ), sizeof( unsigned int ) );
	printf( "drop %zu end-structure\n", sizeof( struct rtcm3_t ) );

	swigComment("rtcm3_t_rtcmtypes\n");
	printf( "begin-structure rtcm3_t_rtcmtypes\n" );
	swigStructField( "rtcm3_t_rtcmtypes-rtcm3_1011", offsetof( rtcm3_t_rtcmtypes, rtcm3_1011 ), sizeof( rtcm3_t_rtcmtypes_rtcm3_1011 ) );
	swigStructField( "rtcm3_t_rtcmtypes-rtcm3_1012", offsetof( rtcm3_t_rtcmtypes, rtcm3_1012 ), sizeof( rtcm3_t_rtcmtypes_rtcm3_1012 ) );
	swigStructField( "rtcm3_t_rtcmtypes-rtcm3_1001", offsetof( rtcm3_t_rtcmtypes, rtcm3_1001 ), sizeof( rtcm3_t_rtcmtypes_rtcm3_1001 ) );
	swigStructField( "rtcm3_t_rtcmtypes-rtcm3_1013", offsetof( rtcm3_t_rtcmtypes, rtcm3_1013 ), sizeof( rtcm3_t_rtcmtypes_rtcm3_1013 ) );
	swigStructField( "rtcm3_t_rtcmtypes-rtcm3_1014", offsetof( rtcm3_t_rtcmtypes, rtcm3_1014 ), sizeof( struct rtcm3_1014_t ) );
	swigStructField( "rtcm3_t_rtcmtypes-rtcm3_1002", offsetof( rtcm3_t_rtcmtypes, rtcm3_1002 ), sizeof( rtcm3_t_rtcmtypes_rtcm3_1002 ) );
	swigStructField( "rtcm3_t_rtcmtypes-rtcm3_1003", offsetof( rtcm3_t_rtcmtypes, rtcm3_1003 ), sizeof( struct rtcm3_1003_t ) );
	swigStructField( "rtcm3_t_rtcmtypes-rtcm3_1015", offsetof( rtcm3_t_rtcmtypes, rtcm3_1015 ), sizeof( struct rtcm3_1015_t ) );
	swigStructField( "rtcm3_t_rtcmtypes-rtcm3_1004", offsetof( rtcm3_t_rtcmtypes, rtcm3_1004 ), sizeof( struct rtcm3_1004_t ) );
	swigStructField( "rtcm3_t_rtcmtypes-rtcm3_1016", offsetof( rtcm3_t_rtcmtypes, rtcm3_1016 ), sizeof( struct rtcm3_1016_t ) );
	swigStructField( "rtcm3_t_rtcmtypes-rtcm3_1005", offsetof( rtcm3_t_rtcmtypes, rtcm3_1005 ), sizeof( struct rtcm3_1005_t ) );
	swigStructField( "rtcm3_t_rtcmtypes-rtcm3_1017", offsetof( rtcm3_t_rtcmtypes, rtcm3_1017 ), sizeof( struct rtcm3_1017_t ) );
	swigStructField( "rtcm3_t_rtcmtypes-rtcm3_1029", offsetof( rtcm3_t_rtcmtypes, rtcm3_1029 ), sizeof( struct rtcm3_1029_t ) );
	swigStructField( "rtcm3_t_rtcmtypes-rtcm3_1006", offsetof( rtcm3_t_rtcmtypes, rtcm3_1006 ), sizeof( struct rtcm3_1006_t ) );
	swigStructField( "rtcm3_t_rtcmtypes-rtcm3_1019", offsetof( rtcm3_t_rtcmtypes, rtcm3_1019 ), sizeof( struct rtcm3_1019_t ) );
	swigStructField( "rtcm3_t_rtcmtypes-rtcm3_1007", offsetof( rtcm3_t_rtcmtypes, rtcm3_1007 ), sizeof( rtcm3_t_rtcmtypes_rtcm3_1007 ) );
	swigStructField( "rtcm3_t_rtcmtypes-rtcm3_1008", offsetof( rtcm3_t_rtcmtypes, rtcm3_1008 ), sizeof( rtcm3_t_rtcmtypes_rtcm3_1008 ) );
	swigStructField( "rtcm3_t_rtcmtypes-rtcm3_1009", offsetof( rtcm3_t_rtcmtypes, rtcm3_1009 ), sizeof( rtcm3_t_rtcmtypes_rtcm3_1009 ) );
	swigStructField( "rtcm3_t_rtcmtypes-rtcm3_1020", offsetof( rtcm3_t_rtcmtypes, rtcm3_1020 ), sizeof( struct rtcm3_1020_t ) );
	swigStructField( "rtcm3_t_rtcmtypes-data", offsetof( rtcm3_t_rtcmtypes, data ), sizeof( char [1024] ) );
	swigStructField( "rtcm3_t_rtcmtypes-rtcm3_1033", offsetof( rtcm3_t_rtcmtypes, rtcm3_1033 ), sizeof( struct rtcm3_1033_t ) );
	swigStructField( "rtcm3_t_rtcmtypes-rtcm3_1010", offsetof( rtcm3_t_rtcmtypes, rtcm3_1010 ), sizeof( rtcm3_t_rtcmtypes_rtcm3_1010 ) );
	printf( "drop %zu end-structure\n", sizeof( rtcm3_t_rtcmtypes ) );

	swigComment("rtcm3_t_rtcmtypes_rtcm3_1013\n");
	printf( "begin-structure rtcm3_t_rtcmtypes_rtcm3_1013\n" );
	swigStructField( "rtcm3_t_rtcmtypes_rtcm3_1013-mjd", offsetof( rtcm3_t_rtcmtypes_rtcm3_1013, mjd ), sizeof( unsigned short ) );
	swigStructField( "rtcm3_t_rtcmtypes_rtcm3_1013-announcements", offsetof( rtcm3_t_rtcmtypes_rtcm3_1013, announcements ), sizeof( struct rtcm3_1013_t [32] ) );
	swigStructField( "rtcm3_t_rtcmtypes_rtcm3_1013-station_id", offsetof( rtcm3_t_rtcmtypes_rtcm3_1013, station_id ), sizeof( unsigned int ) );
	swigStructField( "rtcm3_t_rtcmtypes_rtcm3_1013-ncount", offsetof( rtcm3_t_rtcmtypes_rtcm3_1013, ncount ), sizeof( unsigned char ) );
	swigStructField( "rtcm3_t_rtcmtypes_rtcm3_1013-sod", offsetof( rtcm3_t_rtcmtypes_rtcm3_1013, sod ), sizeof( unsigned int ) );
	swigStructField( "rtcm3_t_rtcmtypes_rtcm3_1013-leapsecs", offsetof( rtcm3_t_rtcmtypes_rtcm3_1013, leapsecs ), sizeof( unsigned char ) );
	printf( "drop %zu end-structure\n", sizeof( rtcm3_t_rtcmtypes_rtcm3_1013 ) );

	swigComment("rtcm3_t_rtcmtypes_rtcm3_1012\n");
	printf( "begin-structure rtcm3_t_rtcmtypes_rtcm3_1012\n" );
	swigStructField( "rtcm3_t_rtcmtypes_rtcm3_1012-header", offsetof( rtcm3_t_rtcmtypes_rtcm3_1012, header ), sizeof( struct rtcm3_rtk_hdr ) );
	printf( "drop %zu end-structure\n", sizeof( rtcm3_t_rtcmtypes_rtcm3_1012 ) );

	swigComment("rtcm3_t_rtcmtypes_rtcm3_1011\n");
	printf( "begin-structure rtcm3_t_rtcmtypes_rtcm3_1011\n" );
	swigStructField( "rtcm3_t_rtcmtypes_rtcm3_1011-header", offsetof( rtcm3_t_rtcmtypes_rtcm3_1011, header ), sizeof( struct rtcm3_rtk_hdr ) );
	printf( "drop %zu end-structure\n", sizeof( rtcm3_t_rtcmtypes_rtcm3_1011 ) );

	swigComment("rtcm3_t_rtcmtypes_rtcm3_1010\n");
	printf( "begin-structure rtcm3_t_rtcmtypes_rtcm3_1010\n" );
	swigStructField( "rtcm3_t_rtcmtypes_rtcm3_1010-header", offsetof( rtcm3_t_rtcmtypes_rtcm3_1010, header ), sizeof( struct rtcm3_rtk_hdr ) );
	printf( "drop %zu end-structure\n", sizeof( rtcm3_t_rtcmtypes_rtcm3_1010 ) );

	swigComment("rtcm3_t_rtcmtypes_rtcm3_1009\n");
	printf( "begin-structure rtcm3_t_rtcmtypes_rtcm3_1009\n" );
	swigStructField( "rtcm3_t_rtcmtypes_rtcm3_1009-header", offsetof( rtcm3_t_rtcmtypes_rtcm3_1009, header ), sizeof( struct rtcm3_rtk_hdr ) );
	printf( "drop %zu end-structure\n", sizeof( rtcm3_t_rtcmtypes_rtcm3_1009 ) );

	swigComment("rtcm3_t_rtcmtypes_rtcm3_1008\n");
	printf( "begin-structure rtcm3_t_rtcmtypes_rtcm3_1008\n" );
	swigStructField( "rtcm3_t_rtcmtypes_rtcm3_1008-descriptor", offsetof( rtcm3_t_rtcmtypes_rtcm3_1008, descriptor ), sizeof( char [31+1] ) );
	swigStructField( "rtcm3_t_rtcmtypes_rtcm3_1008-setup_id", offsetof( rtcm3_t_rtcmtypes_rtcm3_1008, setup_id ), sizeof( unsigned int ) );
	swigStructField( "rtcm3_t_rtcmtypes_rtcm3_1008-station_id", offsetof( rtcm3_t_rtcmtypes_rtcm3_1008, station_id ), sizeof( unsigned int ) );
	swigStructField( "rtcm3_t_rtcmtypes_rtcm3_1008-serial", offsetof( rtcm3_t_rtcmtypes_rtcm3_1008, serial ), sizeof( char [31+1] ) );
	printf( "drop %zu end-structure\n", sizeof( rtcm3_t_rtcmtypes_rtcm3_1008 ) );

	swigComment("rtcm3_t_rtcmtypes_rtcm3_1007\n");
	printf( "begin-structure rtcm3_t_rtcmtypes_rtcm3_1007\n" );
	swigStructField( "rtcm3_t_rtcmtypes_rtcm3_1007-descriptor", offsetof( rtcm3_t_rtcmtypes_rtcm3_1007, descriptor ), sizeof( char [31+1] ) );
	swigStructField( "rtcm3_t_rtcmtypes_rtcm3_1007-setup_id", offsetof( rtcm3_t_rtcmtypes_rtcm3_1007, setup_id ), sizeof( unsigned int ) );
	swigStructField( "rtcm3_t_rtcmtypes_rtcm3_1007-station_id", offsetof( rtcm3_t_rtcmtypes_rtcm3_1007, station_id ), sizeof( unsigned int ) );
	printf( "drop %zu end-structure\n", sizeof( rtcm3_t_rtcmtypes_rtcm3_1007 ) );

	swigComment("rtcm3_t_rtcmtypes_rtcm3_1002\n");
	printf( "begin-structure rtcm3_t_rtcmtypes_rtcm3_1002\n" );
	swigStructField( "rtcm3_t_rtcmtypes_rtcm3_1002-header", offsetof( rtcm3_t_rtcmtypes_rtcm3_1002, header ), sizeof( struct rtcm3_rtk_hdr ) );
	printf( "drop %zu end-structure\n", sizeof( rtcm3_t_rtcmtypes_rtcm3_1002 ) );

	swigComment("rtcm3_t_rtcmtypes_rtcm3_1001\n");
	printf( "begin-structure rtcm3_t_rtcmtypes_rtcm3_1001\n" );
	swigStructField( "rtcm3_t_rtcmtypes_rtcm3_1001-header", offsetof( rtcm3_t_rtcmtypes_rtcm3_1001, header ), sizeof( struct rtcm3_rtk_hdr ) );
	swigStructField( "rtcm3_t_rtcmtypes_rtcm3_1001-rtk_data", offsetof( rtcm3_t_rtcmtypes_rtcm3_1001, rtk_data ), sizeof( struct rtcm3_1001_t [64] ) );
	printf( "drop %zu end-structure\n", sizeof( rtcm3_t_rtcmtypes_rtcm3_1001 ) );

	swigComment("rtcm3_1001_t\n");
	printf( "begin-structure rtcm3_1001_t\n" );
	swigStructField( "rtcm3_1001_t-L1", offsetof( struct rtcm3_1001_t, L1 ), sizeof( struct rtcm3_basic_rtk ) );
	swigStructField( "rtcm3_1001_t-ident", offsetof( struct rtcm3_1001_t, ident ), sizeof( unsigned int ) );
	printf( "drop %zu end-structure\n", sizeof( struct rtcm3_1001_t ) );

	swigComment("rtcm3_1002_t\n");
	printf( "begin-structure rtcm3_1002_t\n" );
	swigStructField( "rtcm3_1002_t-L1", offsetof( struct rtcm3_1002_t, L1 ), sizeof( struct rtcm3_extended_rtk ) );
	swigStructField( "rtcm3_1002_t-ident", offsetof( struct rtcm3_1002_t, ident ), sizeof( unsigned int ) );
	printf( "drop %zu end-structure\n", sizeof( struct rtcm3_1002_t ) );

	swigComment("rtcm3_1003_t\n");
	printf( "begin-structure rtcm3_1003_t\n" );
	swigStructField( "rtcm3_1003_t-header", offsetof( struct rtcm3_1003_t, header ), sizeof( struct rtcm3_rtk_hdr ) );
	swigStructField( "rtcm3_1003_t-rtk_data", offsetof( struct rtcm3_1003_t, rtk_data ), sizeof( rtcm3_1003_t_rtk_data [64] ) );
	printf( "drop %zu end-structure\n", sizeof( struct rtcm3_1003_t ) );

	swigComment("rtcm3_1003_t_rtk_data\n");
	printf( "begin-structure rtcm3_1003_t_rtk_data\n" );
	swigStructField( "rtcm3_1003_t_rtk_data-L1", offsetof( rtcm3_1003_t_rtk_data, L1 ), sizeof( struct rtcm3_basic_rtk ) );
	swigStructField( "rtcm3_1003_t_rtk_data-ident", offsetof( rtcm3_1003_t_rtk_data, ident ), sizeof( unsigned int ) );
	swigStructField( "rtcm3_1003_t_rtk_data-L2", offsetof( rtcm3_1003_t_rtk_data, L2 ), sizeof( struct rtcm3_basic_rtk ) );
	printf( "drop %zu end-structure\n", sizeof( rtcm3_1003_t_rtk_data ) );

	swigComment("rtcm3_1004_t\n");
	printf( "begin-structure rtcm3_1004_t\n" );
	swigStructField( "rtcm3_1004_t-header", offsetof( struct rtcm3_1004_t, header ), sizeof( struct rtcm3_rtk_hdr ) );
	swigStructField( "rtcm3_1004_t-rtk_data", offsetof( struct rtcm3_1004_t, rtk_data ), sizeof( rtcm3_1004_t_rtk_data [64] ) );
	printf( "drop %zu end-structure\n", sizeof( struct rtcm3_1004_t ) );

	swigComment("rtcm3_1004_t_rtk_data\n");
	printf( "begin-structure rtcm3_1004_t_rtk_data\n" );
	swigStructField( "rtcm3_1004_t_rtk_data-L1", offsetof( rtcm3_1004_t_rtk_data, L1 ), sizeof( struct rtcm3_extended_rtk ) );
	swigStructField( "rtcm3_1004_t_rtk_data-ident", offsetof( rtcm3_1004_t_rtk_data, ident ), sizeof( unsigned int ) );
	swigStructField( "rtcm3_1004_t_rtk_data-L2", offsetof( rtcm3_1004_t_rtk_data, L2 ), sizeof( struct rtcm3_extended_rtk ) );
	printf( "drop %zu end-structure\n", sizeof( rtcm3_1004_t_rtk_data ) );

	swigComment("rtcm3_1005_t\n");
	printf( "begin-structure rtcm3_1005_t\n" );
	swigStructField( "rtcm3_1005_t-ecef_x", offsetof( struct rtcm3_1005_t, ecef_x ), sizeof( double ) );
	swigStructField( "rtcm3_1005_t-station_id", offsetof( struct rtcm3_1005_t, station_id ), sizeof( unsigned int ) );
	swigStructField( "rtcm3_1005_t-single_receiver", offsetof( struct rtcm3_1005_t, single_receiver ), sizeof( bool ) );
	swigStructField( "rtcm3_1005_t-ecef_y", offsetof( struct rtcm3_1005_t, ecef_y ), sizeof( double ) );
	swigStructField( "rtcm3_1005_t-ecef_z", offsetof( struct rtcm3_1005_t, ecef_z ), sizeof( double ) );
	swigStructField( "rtcm3_1005_t-system", offsetof( struct rtcm3_1005_t, system ), sizeof( int ) );
	swigStructField( "rtcm3_1005_t-reference_station", offsetof( struct rtcm3_1005_t, reference_station ), sizeof( bool ) );
	printf( "drop %zu end-structure\n", sizeof( struct rtcm3_1005_t ) );

	swigComment("rtcm3_1006_t\n");
	printf( "begin-structure rtcm3_1006_t\n" );
	swigStructField( "rtcm3_1006_t-ecef_x", offsetof( struct rtcm3_1006_t, ecef_x ), sizeof( double ) );
	swigStructField( "rtcm3_1006_t-station_id", offsetof( struct rtcm3_1006_t, station_id ), sizeof( unsigned int ) );
	swigStructField( "rtcm3_1006_t-single_receiver", offsetof( struct rtcm3_1006_t, single_receiver ), sizeof( bool ) );
	swigStructField( "rtcm3_1006_t-ecef_y", offsetof( struct rtcm3_1006_t, ecef_y ), sizeof( double ) );
	swigStructField( "rtcm3_1006_t-ecef_z", offsetof( struct rtcm3_1006_t, ecef_z ), sizeof( double ) );
	swigStructField( "rtcm3_1006_t-system", offsetof( struct rtcm3_1006_t, system ), sizeof( int ) );
	swigStructField( "rtcm3_1006_t-height", offsetof( struct rtcm3_1006_t, height ), sizeof( double ) );
	swigStructField( "rtcm3_1006_t-reference_station", offsetof( struct rtcm3_1006_t, reference_station ), sizeof( bool ) );
	printf( "drop %zu end-structure\n", sizeof( struct rtcm3_1006_t ) );

	swigComment("rtcm3_1009_t\n");
	printf( "begin-structure rtcm3_1009_t\n" );
	swigStructField( "rtcm3_1009_t-L1", offsetof( struct rtcm3_1009_t, L1 ), sizeof( struct rtcm3_basic_rtk ) );
	swigStructField( "rtcm3_1009_t-ident", offsetof( struct rtcm3_1009_t, ident ), sizeof( unsigned int ) );
	printf( "drop %zu end-structure\n", sizeof( struct rtcm3_1009_t ) );

	swigComment("rtcm3_1010_t\n");
	printf( "begin-structure rtcm3_1010_t\n" );
	swigStructField( "rtcm3_1010_t-L1", offsetof( struct rtcm3_1010_t, L1 ), sizeof( struct rtcm3_extended_rtk ) );
	swigStructField( "rtcm3_1010_t-ident", offsetof( struct rtcm3_1010_t, ident ), sizeof( unsigned int ) );
	printf( "drop %zu end-structure\n", sizeof( struct rtcm3_1010_t ) );

	swigComment("rtcm3_1011_t\n");
	printf( "begin-structure rtcm3_1011_t\n" );
	swigStructField( "rtcm3_1011_t-L1", offsetof( struct rtcm3_1011_t, L1 ), sizeof( struct rtcm3_extended_rtk ) );
	swigStructField( "rtcm3_1011_t-ident", offsetof( struct rtcm3_1011_t, ident ), sizeof( unsigned int ) );
	swigStructField( "rtcm3_1011_t-L2", offsetof( struct rtcm3_1011_t, L2 ), sizeof( struct rtcm3_extended_rtk ) );
	printf( "drop %zu end-structure\n", sizeof( struct rtcm3_1011_t ) );

	swigComment("rtcm3_1012_t\n");
	printf( "begin-structure rtcm3_1012_t\n" );
	swigStructField( "rtcm3_1012_t-L1", offsetof( struct rtcm3_1012_t, L1 ), sizeof( struct rtcm3_extended_rtk ) );
	swigStructField( "rtcm3_1012_t-ident", offsetof( struct rtcm3_1012_t, ident ), sizeof( unsigned int ) );
	swigStructField( "rtcm3_1012_t-L2", offsetof( struct rtcm3_1012_t, L2 ), sizeof( struct rtcm3_extended_rtk ) );
	printf( "drop %zu end-structure\n", sizeof( struct rtcm3_1012_t ) );

	swigComment("rtcm3_1013_t\n");
	printf( "begin-structure rtcm3_1013_t\n" );
	swigStructField( "rtcm3_1013_t-sync", offsetof( struct rtcm3_1013_t, sync ), sizeof( bool ) );
	swigStructField( "rtcm3_1013_t-id", offsetof( struct rtcm3_1013_t, id ), sizeof( unsigned short ) );
	swigStructField( "rtcm3_1013_t-interval", offsetof( struct rtcm3_1013_t, interval ), sizeof( unsigned short ) );
	printf( "drop %zu end-structure\n", sizeof( struct rtcm3_1013_t ) );

	swigComment("rtcm3_1014_t\n");
	printf( "begin-structure rtcm3_1014_t\n" );
	swigStructField( "rtcm3_1014_t-network_id", offsetof( struct rtcm3_1014_t, network_id ), sizeof( unsigned int ) );
	swigStructField( "rtcm3_1014_t-subnetwork_id", offsetof( struct rtcm3_1014_t, subnetwork_id ), sizeof( unsigned int ) );
	swigStructField( "rtcm3_1014_t-master_id", offsetof( struct rtcm3_1014_t, master_id ), sizeof( unsigned int ) );
	swigStructField( "rtcm3_1014_t-stationcount", offsetof( struct rtcm3_1014_t, stationcount ), sizeof( unsigned int ) );
	swigStructField( "rtcm3_1014_t-d_lat", offsetof( struct rtcm3_1014_t, d_lat ), sizeof( double ) );
	swigStructField( "rtcm3_1014_t-d_lon", offsetof( struct rtcm3_1014_t, d_lon ), sizeof( double ) );
	swigStructField( "rtcm3_1014_t-d_alt", offsetof( struct rtcm3_1014_t, d_alt ), sizeof( double ) );
	swigStructField( "rtcm3_1014_t-aux_id", offsetof( struct rtcm3_1014_t, aux_id ), sizeof( unsigned int ) );
	printf( "drop %zu end-structure\n", sizeof( struct rtcm3_1014_t ) );

	swigComment("rtcm3_1015_t\n");
	printf( "begin-structure rtcm3_1015_t\n" );
	swigStructField( "rtcm3_1015_t-corrections", offsetof( struct rtcm3_1015_t, corrections ), sizeof( struct rtcm3_correction_diff [64] ) );
	swigStructField( "rtcm3_1015_t-header", offsetof( struct rtcm3_1015_t, header ), sizeof( struct rtcm3_network_rtk_header ) );
	printf( "drop %zu end-structure\n", sizeof( struct rtcm3_1015_t ) );

	swigComment("rtcm3_1016_t\n");
	printf( "begin-structure rtcm3_1016_t\n" );
	swigStructField( "rtcm3_1016_t-corrections", offsetof( struct rtcm3_1016_t, corrections ), sizeof( struct rtcm3_correction_diff [64] ) );
	swigStructField( "rtcm3_1016_t-header", offsetof( struct rtcm3_1016_t, header ), sizeof( struct rtcm3_network_rtk_header ) );
	printf( "drop %zu end-structure\n", sizeof( struct rtcm3_1016_t ) );

	swigComment("rtcm3_1017_t\n");
	printf( "begin-structure rtcm3_1017_t\n" );
	swigStructField( "rtcm3_1017_t-corrections", offsetof( struct rtcm3_1017_t, corrections ), sizeof( struct rtcm3_correction_diff [64] ) );
	swigStructField( "rtcm3_1017_t-header", offsetof( struct rtcm3_1017_t, header ), sizeof( struct rtcm3_network_rtk_header ) );
	printf( "drop %zu end-structure\n", sizeof( struct rtcm3_1017_t ) );

	swigComment("rtcm3_1019_t\n");
	printf( "begin-structure rtcm3_1019_t\n" );
	swigStructField( "rtcm3_1019_t-C_sub_is", offsetof( struct rtcm3_1019_t, C_sub_is ), sizeof( int ) );
	swigStructField( "rtcm3_1019_t-C_sub_rc", offsetof( struct rtcm3_1019_t, C_sub_rc ), sizeof( int ) );
	swigStructField( "rtcm3_1019_t-C_sub_ic", offsetof( struct rtcm3_1019_t, C_sub_ic ), sizeof( int ) );
	swigStructField( "rtcm3_1019_t-sv_accuracy", offsetof( struct rtcm3_1019_t, sv_accuracy ), sizeof( unsigned char ) );
	swigStructField( "rtcm3_1019_t-week", offsetof( struct rtcm3_1019_t, week ), sizeof( unsigned int ) );
	swigStructField( "rtcm3_1019_t-omegadot", offsetof( struct rtcm3_1019_t, omegadot ), sizeof( int ) );
	swigStructField( "rtcm3_1019_t-t_sub_GD", offsetof( struct rtcm3_1019_t, t_sub_GD ), sizeof( int ) );
	swigStructField( "rtcm3_1019_t-sv_health", offsetof( struct rtcm3_1019_t, sv_health ), sizeof( unsigned char ) );
	swigStructField( "rtcm3_1019_t-fit_interval", offsetof( struct rtcm3_1019_t, fit_interval ), sizeof( bool ) );
	swigStructField( "rtcm3_1019_t-t_sub_oc", offsetof( struct rtcm3_1019_t, t_sub_oc ), sizeof( unsigned int ) );
	swigStructField( "rtcm3_1019_t-a_sub_f0", offsetof( struct rtcm3_1019_t, a_sub_f0 ), sizeof( int ) );
	swigStructField( "rtcm3_1019_t-ident", offsetof( struct rtcm3_1019_t, ident ), sizeof( unsigned int ) );
	swigStructField( "rtcm3_1019_t-delta_sub_n", offsetof( struct rtcm3_1019_t, delta_sub_n ), sizeof( int ) );
	swigStructField( "rtcm3_1019_t-a_sub_f1", offsetof( struct rtcm3_1019_t, a_sub_f1 ), sizeof( int ) );
	swigStructField( "rtcm3_1019_t-t_sub_oe", offsetof( struct rtcm3_1019_t, t_sub_oe ), sizeof( unsigned int ) );
	swigStructField( "rtcm3_1019_t-a_sub_f2", offsetof( struct rtcm3_1019_t, a_sub_f2 ), sizeof( int ) );
	swigStructField( "rtcm3_1019_t-sqrt_sub_A", offsetof( struct rtcm3_1019_t, sqrt_sub_A ), sizeof( unsigned int ) );
	swigStructField( "rtcm3_1019_t-argument_of_perigee", offsetof( struct rtcm3_1019_t, argument_of_perigee ), sizeof( int ) );
	swigStructField( "rtcm3_1019_t-C_sub_us", offsetof( struct rtcm3_1019_t, C_sub_us ), sizeof( int ) );
	swigStructField( "rtcm3_1019_t-C_sub_uc", offsetof( struct rtcm3_1019_t, C_sub_uc ), sizeof( int ) );
	swigStructField( "rtcm3_1019_t-code", offsetof( struct rtcm3_1019_t, code ), sizeof( int ) );
	swigStructField( "rtcm3_1019_t-M_sub_0", offsetof( struct rtcm3_1019_t, M_sub_0 ), sizeof( int ) );
	swigStructField( "rtcm3_1019_t-iodc", offsetof( struct rtcm3_1019_t, iodc ), sizeof( unsigned int ) );
	swigStructField( "rtcm3_1019_t-OMEGA_sub_0", offsetof( struct rtcm3_1019_t, OMEGA_sub_0 ), sizeof( int ) );
	swigStructField( "rtcm3_1019_t-i_sub_0", offsetof( struct rtcm3_1019_t, i_sub_0 ), sizeof( int ) );
	swigStructField( "rtcm3_1019_t-idot", offsetof( struct rtcm3_1019_t, idot ), sizeof( double ) );
	swigStructField( "rtcm3_1019_t-iode", offsetof( struct rtcm3_1019_t, iode ), sizeof( unsigned char ) );
	swigStructField( "rtcm3_1019_t-p_data", offsetof( struct rtcm3_1019_t, p_data ), sizeof( bool ) );
	swigStructField( "rtcm3_1019_t-C_sub_rs", offsetof( struct rtcm3_1019_t, C_sub_rs ), sizeof( int ) );
	swigStructField( "rtcm3_1019_t-e", offsetof( struct rtcm3_1019_t, e ), sizeof( unsigned int ) );
	printf( "drop %zu end-structure\n", sizeof( struct rtcm3_1019_t ) );

	swigComment("rtcm3_1020_t\n");
	printf( "begin-structure rtcm3_1020_t\n" );
	swigStructField( "rtcm3_1020_t-tau_n_of_t_sub_b", offsetof( struct rtcm3_1020_t, tau_n_of_t_sub_b ), sizeof( int ) );
	swigStructField( "rtcm3_1020_t-gamma_sub_n_of_t_sub_b", offsetof( struct rtcm3_1020_t, gamma_sub_n_of_t_sub_b ), sizeof( int ) );
	swigStructField( "rtcm3_1020_t-z_sub_n_t_of_t_sub_b", offsetof( struct rtcm3_1020_t, z_sub_n_t_of_t_sub_b ), sizeof( int ) );
	swigStructField( "rtcm3_1020_t-t_sub_b", offsetof( struct rtcm3_1020_t, t_sub_b ), sizeof( bool ) );
	swigStructField( "rtcm3_1020_t-x_sub_n_t_of_t_sub_b", offsetof( struct rtcm3_1020_t, x_sub_n_t_of_t_sub_b ), sizeof( int ) );
	swigStructField( "rtcm3_1020_t-y_sub_n_t_of_t_sub_b", offsetof( struct rtcm3_1020_t, y_sub_n_t_of_t_sub_b ), sizeof( int ) );
	swigStructField( "rtcm3_1020_t-E_sub_n", offsetof( struct rtcm3_1020_t, E_sub_n ), sizeof( unsigned int ) );
	swigStructField( "rtcm3_1020_t-M_delta_tau_sub_n", offsetof( struct rtcm3_1020_t, M_delta_tau_sub_n ), sizeof( int ) );
	swigStructField( "rtcm3_1020_t-C_sub_n", offsetof( struct rtcm3_1020_t, C_sub_n ), sizeof( bool ) );
	swigStructField( "rtcm3_1020_t-z_sub_n_t_of_t_sub_b_prime_prime", offsetof( struct rtcm3_1020_t, z_sub_n_t_of_t_sub_b_prime_prime ), sizeof( int ) );
	swigStructField( "rtcm3_1020_t-y_sub_n_t_of_t_sub_b_prime_prime", offsetof( struct rtcm3_1020_t, y_sub_n_t_of_t_sub_b_prime_prime ), sizeof( int ) );
	swigStructField( "rtcm3_1020_t-x_sub_n_t_of_t_sub_b_prime_prime", offsetof( struct rtcm3_1020_t, x_sub_n_t_of_t_sub_b_prime_prime ), sizeof( int ) );
	swigStructField( "rtcm3_1020_t-health_avAilability_indicator", offsetof( struct rtcm3_1020_t, health_avAilability_indicator ), sizeof( bool ) );
	swigStructField( "rtcm3_1020_t-M_tau_sub_GPS", offsetof( struct rtcm3_1020_t, M_tau_sub_GPS ), sizeof( int ) );
	swigStructField( "rtcm3_1020_t-ident", offsetof( struct rtcm3_1020_t, ident ), sizeof( unsigned int ) );
	swigStructField( "rtcm3_1020_t-t_sub_k", offsetof( struct rtcm3_1020_t, t_sub_k ), sizeof( unsigned short ) );
	swigStructField( "rtcm3_1020_t-additioinal_data_availability", offsetof( struct rtcm3_1020_t, additioinal_data_availability ), sizeof( bool ) );
	swigStructField( "rtcm3_1020_t-msb_of_B_sub_n", offsetof( struct rtcm3_1020_t, msb_of_B_sub_n ), sizeof( bool ) );
	swigStructField( "rtcm3_1020_t-M_l_sub_n", offsetof( struct rtcm3_1020_t, M_l_sub_n ), sizeof( bool ) );
	swigStructField( "rtcm3_1020_t-z_sub_n_t_of_t_sub_b_prime", offsetof( struct rtcm3_1020_t, z_sub_n_t_of_t_sub_b_prime ), sizeof( int ) );
	swigStructField( "rtcm3_1020_t-x_sub_n_t_of_t_sub_b_prime", offsetof( struct rtcm3_1020_t, x_sub_n_t_of_t_sub_b_prime ), sizeof( int ) );
	swigStructField( "rtcm3_1020_t-y_sub_n_t_of_t_sub_b_prime", offsetof( struct rtcm3_1020_t, y_sub_n_t_of_t_sub_b_prime ), sizeof( int ) );
	swigStructField( "rtcm3_1020_t-P1", offsetof( struct rtcm3_1020_t, P1 ), sizeof( unsigned char ) );
	swigStructField( "rtcm3_1020_t-P2", offsetof( struct rtcm3_1020_t, P2 ), sizeof( bool ) );
	swigStructField( "rtcm3_1020_t-P3", offsetof( struct rtcm3_1020_t, P3 ), sizeof( bool ) );
	swigStructField( "rtcm3_1020_t-MP4", offsetof( struct rtcm3_1020_t, MP4 ), sizeof( bool ) );
	swigStructField( "rtcm3_1020_t-N_sup_A", offsetof( struct rtcm3_1020_t, N_sup_A ), sizeof( unsigned int ) );
	swigStructField( "rtcm3_1020_t-MM", offsetof( struct rtcm3_1020_t, MM ), sizeof( unsigned char ) );
	swigStructField( "rtcm3_1020_t-MN_sub_T", offsetof( struct rtcm3_1020_t, MN_sub_T ), sizeof( unsigned char ) );
	swigStructField( "rtcm3_1020_t-MF_sub_T", offsetof( struct rtcm3_1020_t, MF_sub_T ), sizeof( unsigned char ) );
	swigStructField( "rtcm3_1020_t-MP", offsetof( struct rtcm3_1020_t, MP ), sizeof( unsigned char ) );
	swigStructField( "rtcm3_1020_t-channel", offsetof( struct rtcm3_1020_t, channel ), sizeof( unsigned short ) );
	swigStructField( "rtcm3_1020_t-tau_sub_c", offsetof( struct rtcm3_1020_t, tau_sub_c ), sizeof( unsigned int ) );
	swigStructField( "rtcm3_1020_t-M_N_sub_4", offsetof( struct rtcm3_1020_t, M_N_sub_4 ), sizeof( unsigned int ) );
	swigStructField( "rtcm3_1020_t-Ml_n", offsetof( struct rtcm3_1020_t, Ml_n ), sizeof( bool ) );
	printf( "drop %zu end-structure\n", sizeof( struct rtcm3_1020_t ) );

	swigComment("rtcm3_1029_t\n");
	printf( "begin-structure rtcm3_1029_t\n" );
	swigStructField( "rtcm3_1029_t-mjd", offsetof( struct rtcm3_1029_t, mjd ), sizeof( unsigned short ) );
	swigStructField( "rtcm3_1029_t-unicode_units", offsetof( struct rtcm3_1029_t, unicode_units ), sizeof( size_t ) );
	swigStructField( "rtcm3_1029_t-station_id", offsetof( struct rtcm3_1029_t, station_id ), sizeof( unsigned int ) );
	swigStructField( "rtcm3_1029_t-len", offsetof( struct rtcm3_1029_t, len ), sizeof( size_t ) );
	swigStructField( "rtcm3_1029_t-sod", offsetof( struct rtcm3_1029_t, sod ), sizeof( unsigned int ) );
	swigStructField( "rtcm3_1029_t-text", offsetof( struct rtcm3_1029_t, text ), sizeof( unsigned char [128] ) );
	printf( "drop %zu end-structure\n", sizeof( struct rtcm3_1029_t ) );

	swigComment("rtcm3_1033_t\n");
	printf( "begin-structure rtcm3_1033_t\n" );
	swigStructField( "rtcm3_1033_t-descriptor", offsetof( struct rtcm3_1033_t, descriptor ), sizeof( char [31+1] ) );
	swigStructField( "rtcm3_1033_t-setup_id", offsetof( struct rtcm3_1033_t, setup_id ), sizeof( unsigned int ) );
	swigStructField( "rtcm3_1033_t-station_id", offsetof( struct rtcm3_1033_t, station_id ), sizeof( unsigned int ) );
	swigStructField( "rtcm3_1033_t-receiver", offsetof( struct rtcm3_1033_t, receiver ), sizeof( char [31+1] ) );
	swigStructField( "rtcm3_1033_t-serial", offsetof( struct rtcm3_1033_t, serial ), sizeof( char [31+1] ) );
	swigStructField( "rtcm3_1033_t-firmware", offsetof( struct rtcm3_1033_t, firmware ), sizeof( char [31+1] ) );
	printf( "drop %zu end-structure\n", sizeof( struct rtcm3_1033_t ) );

	swigComment("almanac_t\n");
	printf( "begin-structure almanac_t\n" );
	swigStructField( "almanac_t-d_af0", offsetof( struct almanac_t, d_af0 ), sizeof( double ) );
	swigStructField( "almanac_t-d_M0", offsetof( struct almanac_t, d_M0 ), sizeof( double ) );
	swigStructField( "almanac_t-sqrtA", offsetof( struct almanac_t, sqrtA ), sizeof( uint32_t ) );
	swigStructField( "almanac_t-d_af1", offsetof( struct almanac_t, d_af1 ), sizeof( double ) );
	swigStructField( "almanac_t-d_omega", offsetof( struct almanac_t, d_omega ), sizeof( double ) );
	swigStructField( "almanac_t-d_Omega0", offsetof( struct almanac_t, d_Omega0 ), sizeof( double ) );
	swigStructField( "almanac_t-svh", offsetof( struct almanac_t, svh ), sizeof( uint8_t ) );
	swigStructField( "almanac_t-d_eccentricity", offsetof( struct almanac_t, d_eccentricity ), sizeof( double ) );
	swigStructField( "almanac_t-d_Omegad", offsetof( struct almanac_t, d_Omegad ), sizeof( double ) );
	swigStructField( "almanac_t-sv", offsetof( struct almanac_t, sv ), sizeof( uint8_t ) );
	swigStructField( "almanac_t-Omega0", offsetof( struct almanac_t, Omega0 ), sizeof( int32_t ) );
	swigStructField( "almanac_t-omega", offsetof( struct almanac_t, omega ), sizeof( int32_t ) );
	swigStructField( "almanac_t-deltai", offsetof( struct almanac_t, deltai ), sizeof( int16_t ) );
	swigStructField( "almanac_t-Omegad", offsetof( struct almanac_t, Omegad ), sizeof( int16_t ) );
	swigStructField( "almanac_t-af0", offsetof( struct almanac_t, af0 ), sizeof( int16_t ) );
	swigStructField( "almanac_t-af1", offsetof( struct almanac_t, af1 ), sizeof( int16_t ) );
	swigStructField( "almanac_t-d_sqrtA", offsetof( struct almanac_t, d_sqrtA ), sizeof( double ) );
	swigStructField( "almanac_t-M0", offsetof( struct almanac_t, M0 ), sizeof( int32_t ) );
	swigStructField( "almanac_t-d_deltai", offsetof( struct almanac_t, d_deltai ), sizeof( double ) );
	swigStructField( "almanac_t-l_toa", offsetof( struct almanac_t, l_toa ), sizeof( long ) );
	swigStructField( "almanac_t-toa", offsetof( struct almanac_t, toa ), sizeof( uint8_t ) );
	swigStructField( "almanac_t-e", offsetof( struct almanac_t, e ), sizeof( uint16_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct almanac_t ) );

	swigComment("subframe_t\n");
	printf( "begin-structure subframe_t\n" );
	swigStructField( "subframe_t-sub5", offsetof( struct subframe_t, sub5 ), sizeof( _sub5 ) );
	swigStructField( "subframe_t-sub4_17", offsetof( struct subframe_t, sub4_17 ), sizeof( _sub4_17 ) );
	swigStructField( "subframe_t-sub4_18", offsetof( struct subframe_t, sub4_18 ), sizeof( _sub4_18 ) );
	swigStructField( "subframe_t-data_id", offsetof( struct subframe_t, data_id ), sizeof( uint8_t ) );
	swigStructField( "subframe_t-sub5_25", offsetof( struct subframe_t, sub5_25 ), sizeof( _sub5_25 ) );
	swigStructField( "subframe_t-subframe_num", offsetof( struct subframe_t, subframe_num ), sizeof( uint8_t ) );
	swigStructField( "subframe_t-antispoof", offsetof( struct subframe_t, antispoof ), sizeof( bool ) );
	swigStructField( "subframe_t-l_TOW17", offsetof( struct subframe_t, l_TOW17 ), sizeof( long ) );
	swigStructField( "subframe_t-is_almanac", offsetof( struct subframe_t, is_almanac ), sizeof( int ) );
	swigStructField( "subframe_t-alert", offsetof( struct subframe_t, alert ), sizeof( bool ) );
	swigStructField( "subframe_t-sub1", offsetof( struct subframe_t, sub1 ), sizeof( _sub1 ) );
	swigStructField( "subframe_t-tSVID", offsetof( struct subframe_t, tSVID ), sizeof( uint8_t ) );
	swigStructField( "subframe_t-pageid", offsetof( struct subframe_t, pageid ), sizeof( uint8_t ) );
	swigStructField( "subframe_t-integrity", offsetof( struct subframe_t, integrity ), sizeof( bool ) );
	swigStructField( "subframe_t-sub2", offsetof( struct subframe_t, sub2 ), sizeof( _sub2 ) );
	swigStructField( "subframe_t-TOW17", offsetof( struct subframe_t, TOW17 ), sizeof( uint32_t ) );
	swigStructField( "subframe_t-sub4_13", offsetof( struct subframe_t, sub4_13 ), sizeof( _sub4_13 ) );
	swigStructField( "subframe_t-sub4_25", offsetof( struct subframe_t, sub4_25 ), sizeof( _sub4_25 ) );
	swigStructField( "subframe_t-sub3", offsetof( struct subframe_t, sub3 ), sizeof( _sub3 ) );
	swigStructField( "subframe_t-sub4", offsetof( struct subframe_t, sub4 ), sizeof( _sub4 ) );
	printf( "drop %zu end-structure\n", sizeof( struct subframe_t ) );

	swigComment("route_info\n");
	printf( "begin-structure route_info\n" );
	swigStructField( "route_info-waypoints", offsetof( struct route_info, waypoints ), sizeof( struct waypoint_t [16] ) );
	swigStructField( "route_info-day", offsetof( struct route_info, day ), sizeof( unsigned int ) );
	swigStructField( "route_info-duration", offsetof( struct route_info, duration ), sizeof( unsigned int ) );
	swigStructField( "route_info-waycount", offsetof( struct route_info, waycount ), sizeof( int ) );
	swigStructField( "route_info-sender", offsetof( struct route_info, sender ), sizeof( unsigned int ) );
	swigStructField( "route_info-rtype", offsetof( struct route_info, rtype ), sizeof( unsigned int ) );
	swigStructField( "route_info-month", offsetof( struct route_info, month ), sizeof( unsigned int ) );
	swigStructField( "route_info-hour", offsetof( struct route_info, hour ), sizeof( unsigned int ) );
	swigStructField( "route_info-minute", offsetof( struct route_info, minute ), sizeof( unsigned int ) );
	swigStructField( "route_info-linkage", offsetof( struct route_info, linkage ), sizeof( unsigned int ) );
	printf( "drop %zu end-structure\n", sizeof( struct route_info ) );

	swigComment("waypoint_t\n");
	printf( "begin-structure waypoint_t\n" );
	swigStructField( "waypoint_t-lon", offsetof( struct waypoint_t, lon ), sizeof( int ) );
	swigStructField( "waypoint_t-lat", offsetof( struct waypoint_t, lat ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( struct waypoint_t ) );

	swigComment("ais_t\n");
	printf( "begin-structure ais_t\n" );
	swigStructField( "ais_t-mmsi", offsetof( struct ais_t, mmsi ), sizeof( unsigned int ) );
	swigStructField( "ais_t-type8", offsetof( struct ais_t, type8 ), sizeof( _type8 ) );
	swigStructField( "ais_t-type20", offsetof( struct ais_t, type20 ), sizeof( _type20 ) );
	swigStructField( "ais_t-type9", offsetof( struct ais_t, type9 ), sizeof( _type9 ) );
	swigStructField( "ais_t-type21", offsetof( struct ais_t, type21 ), sizeof( _type21 ) );
	swigStructField( "ais_t-type10", offsetof( struct ais_t, type10 ), sizeof( _type10 ) );
	swigStructField( "ais_t-type22", offsetof( struct ais_t, type22 ), sizeof( _type22 ) );
	swigStructField( "ais_t-type23", offsetof( struct ais_t, type23 ), sizeof( _type23 ) );
	swigStructField( "ais_t-type12", offsetof( struct ais_t, type12 ), sizeof( _type12 ) );
	swigStructField( "ais_t-type24", offsetof( struct ais_t, type24 ), sizeof( _type24 ) );
	swigStructField( "ais_t-type25", offsetof( struct ais_t, type25 ), sizeof( _type25 ) );
	swigStructField( "ais_t-type14", offsetof( struct ais_t, type14 ), sizeof( _type14 ) );
	swigStructField( "ais_t-type26", offsetof( struct ais_t, type26 ), sizeof( _type26 ) );
	swigStructField( "ais_t-repeat", offsetof( struct ais_t, repeat ), sizeof( unsigned int ) );
	swigStructField( "ais_t-type15", offsetof( struct ais_t, type15 ), sizeof( _type15 ) );
	swigStructField( "ais_t-type27", offsetof( struct ais_t, type27 ), sizeof( _type27 ) );
	swigStructField( "ais_t-type16", offsetof( struct ais_t, type16 ), sizeof( _type16 ) );
	swigStructField( "ais_t-type17", offsetof( struct ais_t, type17 ), sizeof( _type17 ) );
	swigStructField( "ais_t-type1", offsetof( struct ais_t, type1 ), sizeof( _type1 ) );
	swigStructField( "ais_t-type18", offsetof( struct ais_t, type18 ), sizeof( _type18 ) );
	swigStructField( "ais_t-type", offsetof( struct ais_t, type ), sizeof( unsigned int ) );
	swigStructField( "ais_t-type19", offsetof( struct ais_t, type19 ), sizeof( _type19 ) );
	swigStructField( "ais_t-type4", offsetof( struct ais_t, type4 ), sizeof( _type4 ) );
	swigStructField( "ais_t-type5", offsetof( struct ais_t, type5 ), sizeof( _type5 ) );
	swigStructField( "ais_t-type6", offsetof( struct ais_t, type6 ), sizeof( _type6 ) );
	swigStructField( "ais_t-type7", offsetof( struct ais_t, type7 ), sizeof( _type7 ) );
	printf( "drop %zu end-structure\n", sizeof( struct ais_t ) );

	swigComment("cargo_t\n");
	printf( "begin-structure cargo_t\n" );
	swigStructField( "cargo_t-code", offsetof( struct cargo_t, code ), sizeof( unsigned int ) );
	swigStructField( "cargo_t-subtype", offsetof( struct cargo_t, subtype ), sizeof( unsigned int ) );
	printf( "drop %zu end-structure\n", sizeof( struct cargo_t ) );

	swigComment("tidal_t\n");
	printf( "begin-structure tidal_t\n" );
	swigStructField( "tidal_t-lon", offsetof( struct tidal_t, lon ), sizeof( int ) );
	swigStructField( "tidal_t-cdir", offsetof( struct tidal_t, cdir ), sizeof( unsigned int ) );
	swigStructField( "tidal_t-from_min", offsetof( struct tidal_t, from_min ), sizeof( unsigned int ) );
	swigStructField( "tidal_t-to_hour", offsetof( struct tidal_t, to_hour ), sizeof( unsigned int ) );
	swigStructField( "tidal_t-cspeed", offsetof( struct tidal_t, cspeed ), sizeof( unsigned int ) );
	swigStructField( "tidal_t-from_hour", offsetof( struct tidal_t, from_hour ), sizeof( unsigned int ) );
	swigStructField( "tidal_t-to_min", offsetof( struct tidal_t, to_min ), sizeof( unsigned int ) );
	swigStructField( "tidal_t-lat", offsetof( struct tidal_t, lat ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( struct tidal_t ) );

	swigComment("gauge_t\n");
	printf( "begin-structure gauge_t\n" );
	swigStructField( "gauge_t-level", offsetof( struct gauge_t, level ), sizeof( int ) );
	swigStructField( "gauge_t-id", offsetof( struct gauge_t, id ), sizeof( unsigned int ) );
	printf( "drop %zu end-structure\n", sizeof( struct gauge_t ) );

	swigComment("target_id\n");
	printf( "begin-structure target_id\n" );
	swigStructField( "target_id-imo", offsetof( union target_id, imo ), sizeof( unsigned int ) );
	swigStructField( "target_id-callsign", offsetof( union target_id, callsign ), sizeof( char [7+1] ) );
	swigStructField( "target_id-mmsi", offsetof( union target_id, mmsi ), sizeof( unsigned int ) );
	swigStructField( "target_id-other", offsetof( union target_id, other ), sizeof( char [7+1] ) );
	printf( "drop %zu end-structure\n", sizeof( union target_id ) );

	swigComment("target_t\n");
	printf( "begin-structure target_t\n" );
	swigStructField( "target_t-lon", offsetof( struct target_t, lon ), sizeof( int ) );
	swigStructField( "target_t-id", offsetof( struct target_t, id ), sizeof( union target_id ) );
	swigStructField( "target_t-second", offsetof( struct target_t, second ), sizeof( unsigned int ) );
	swigStructField( "target_t-idtype", offsetof( struct target_t, idtype ), sizeof( unsigned int ) );
	swigStructField( "target_t-speed", offsetof( struct target_t, speed ), sizeof( unsigned int ) );
	swigStructField( "target_t-lat", offsetof( struct target_t, lat ), sizeof( int ) );
	swigStructField( "target_t-course", offsetof( struct target_t, course ), sizeof( unsigned int ) );
	printf( "drop %zu end-structure\n", sizeof( struct target_t ) );

	swigComment("satellite_t\n");
	printf( "begin-structure satellite_t\n" );
	swigStructField( "satellite_t-ss", offsetof( struct satellite_t, ss ), sizeof( double ) );
	swigStructField( "satellite_t-elevation", offsetof( struct satellite_t, elevation ), sizeof( short ) );
	swigStructField( "satellite_t-used", offsetof( struct satellite_t, used ), sizeof( bool ) );
	swigStructField( "satellite_t-azimuth", offsetof( struct satellite_t, azimuth ), sizeof( short ) );
	swigStructField( "satellite_t-PRN", offsetof( struct satellite_t, PRN ), sizeof( short ) );
	printf( "drop %zu end-structure\n", sizeof( struct satellite_t ) );

	swigComment("attitude_t\n");
	printf( "begin-structure attitude_t\n" );
	swigStructField( "attitude_t-acc_z", offsetof( struct attitude_t, acc_z ), sizeof( double ) );
	swigStructField( "attitude_t-roll_st", offsetof( struct attitude_t, roll_st ), sizeof( char ) );
	swigStructField( "attitude_t-mag_x", offsetof( struct attitude_t, mag_x ), sizeof( double ) );
	swigStructField( "attitude_t-yaw", offsetof( struct attitude_t, yaw ), sizeof( double ) );
	swigStructField( "attitude_t-mag_y", offsetof( struct attitude_t, mag_y ), sizeof( double ) );
	swigStructField( "attitude_t-roll", offsetof( struct attitude_t, roll ), sizeof( double ) );
	swigStructField( "attitude_t-mag_z", offsetof( struct attitude_t, mag_z ), sizeof( double ) );
	swigStructField( "attitude_t-pitch_st", offsetof( struct attitude_t, pitch_st ), sizeof( char ) );
	swigStructField( "attitude_t-mag_len", offsetof( struct attitude_t, mag_len ), sizeof( double ) );
	swigStructField( "attitude_t-heading", offsetof( struct attitude_t, heading ), sizeof( double ) );
	swigStructField( "attitude_t-depth", offsetof( struct attitude_t, depth ), sizeof( double ) );
	swigStructField( "attitude_t-yaw_st", offsetof( struct attitude_t, yaw_st ), sizeof( char ) );
	swigStructField( "attitude_t-dip", offsetof( struct attitude_t, dip ), sizeof( double ) );
	swigStructField( "attitude_t-pitch", offsetof( struct attitude_t, pitch ), sizeof( double ) );
	swigStructField( "attitude_t-mag_st", offsetof( struct attitude_t, mag_st ), sizeof( char ) );
	swigStructField( "attitude_t-gyro_x", offsetof( struct attitude_t, gyro_x ), sizeof( double ) );
	swigStructField( "attitude_t-acc_len", offsetof( struct attitude_t, acc_len ), sizeof( double ) );
	swigStructField( "attitude_t-acc_x", offsetof( struct attitude_t, acc_x ), sizeof( double ) );
	swigStructField( "attitude_t-gyro_y", offsetof( struct attitude_t, gyro_y ), sizeof( double ) );
	swigStructField( "attitude_t-acc_y", offsetof( struct attitude_t, acc_y ), sizeof( double ) );
	swigStructField( "attitude_t-temp", offsetof( struct attitude_t, temp ), sizeof( double ) );
	printf( "drop %zu end-structure\n", sizeof( struct attitude_t ) );

	swigComment("navdata_t\n");
	printf( "begin-structure navdata_t\n" );
	swigStructField( "navdata_t-compass_status", offsetof( struct navdata_t, compass_status ), sizeof( unsigned int ) );
	swigStructField( "navdata_t-crosstrack_status", offsetof( struct navdata_t, crosstrack_status ), sizeof( unsigned int ) );
	swigStructField( "navdata_t-compass_heading", offsetof( struct navdata_t, compass_heading ), sizeof( double ) );
	swigStructField( "navdata_t-depth", offsetof( struct navdata_t, depth ), sizeof( double ) );
	swigStructField( "navdata_t-water_temp", offsetof( struct navdata_t, water_temp ), sizeof( double ) );
	swigStructField( "navdata_t-air_temp", offsetof( struct navdata_t, air_temp ), sizeof( double ) );
	swigStructField( "navdata_t-air_pressure", offsetof( struct navdata_t, air_pressure ), sizeof( double ) );
	swigStructField( "navdata_t-compass_variation", offsetof( struct navdata_t, compass_variation ), sizeof( double ) );
	swigStructField( "navdata_t-compass_deviation", offsetof( struct navdata_t, compass_deviation ), sizeof( double ) );
	swigStructField( "navdata_t-version", offsetof( struct navdata_t, version ), sizeof( unsigned int ) );
	swigStructField( "navdata_t-log_trip", offsetof( struct navdata_t, log_trip ), sizeof( unsigned int ) );
	swigStructField( "navdata_t-depth_offset", offsetof( struct navdata_t, depth_offset ), sizeof( double ) );
	swigStructField( "navdata_t-crosstrack_error", offsetof( struct navdata_t, crosstrack_error ), sizeof( double ) );
	swigStructField( "navdata_t-log_cumulative", offsetof( struct navdata_t, log_cumulative ), sizeof( unsigned int ) );
	swigStructField( "navdata_t-wind_dir", offsetof( struct navdata_t, wind_dir ), sizeof( double ) );
	swigStructField( "navdata_t-wind_speed", offsetof( struct navdata_t, wind_speed ), sizeof( double ) );
	printf( "drop %zu end-structure\n", sizeof( struct navdata_t ) );

	swigComment("dop_t\n");
	printf( "begin-structure dop_t\n" );
	swigStructField( "dop_t-pdop", offsetof( struct dop_t, pdop ), sizeof( double ) );
	swigStructField( "dop_t-xdop", offsetof( struct dop_t, xdop ), sizeof( double ) );
	swigStructField( "dop_t-ydop", offsetof( struct dop_t, ydop ), sizeof( double ) );
	swigStructField( "dop_t-tdop", offsetof( struct dop_t, tdop ), sizeof( double ) );
	swigStructField( "dop_t-gdop", offsetof( struct dop_t, gdop ), sizeof( double ) );
	swigStructField( "dop_t-hdop", offsetof( struct dop_t, hdop ), sizeof( double ) );
	swigStructField( "dop_t-vdop", offsetof( struct dop_t, vdop ), sizeof( double ) );
	printf( "drop %zu end-structure\n", sizeof( struct dop_t ) );

	swigComment("rawdata_t\n");
	printf( "begin-structure rawdata_t\n" );
	swigStructField( "rawdata_t-pseudorange", offsetof( struct rawdata_t, pseudorange ), sizeof( double [72] ) );
	swigStructField( "rawdata_t-deltarange", offsetof( struct rawdata_t, deltarange ), sizeof( double [72] ) );
	swigStructField( "rawdata_t-satstat", offsetof( struct rawdata_t, satstat ), sizeof( unsigned int [72] ) );
	swigStructField( "rawdata_t-codephase", offsetof( struct rawdata_t, codephase ), sizeof( double [72] ) );
	swigStructField( "rawdata_t-doppler", offsetof( struct rawdata_t, doppler ), sizeof( double [72] ) );
	swigStructField( "rawdata_t-mtime", offsetof( struct rawdata_t, mtime ), sizeof( double [72] ) );
	swigStructField( "rawdata_t-carrierphase", offsetof( struct rawdata_t, carrierphase ), sizeof( double [72] ) );
	printf( "drop %zu end-structure\n", sizeof( struct rawdata_t ) );

	swigComment("version_t\n");
	printf( "begin-structure version_t\n" );
	swigStructField( "version_t-remote", offsetof( struct version_t, remote ), sizeof( char [128] ) );
	swigStructField( "version_t-rev", offsetof( struct version_t, rev ), sizeof( char [64] ) );
	swigStructField( "version_t-proto_minor", offsetof( struct version_t, proto_minor ), sizeof( int ) );
	swigStructField( "version_t-release", offsetof( struct version_t, release ), sizeof( char [64] ) );
	swigStructField( "version_t-proto_major", offsetof( struct version_t, proto_major ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( struct version_t ) );

	swigComment("devconfig_t\n");
	printf( "begin-structure devconfig_t\n" );
	swigStructField( "devconfig_t-parity", offsetof( struct devconfig_t, parity ), sizeof( char ) );
	swigStructField( "devconfig_t-driver", offsetof( struct devconfig_t, driver ), sizeof( char [64] ) );
	swigStructField( "devconfig_t-activated", offsetof( struct devconfig_t, activated ), sizeof( double ) );
	swigStructField( "devconfig_t-stopbits", offsetof( struct devconfig_t, stopbits ), sizeof( unsigned int ) );
	swigStructField( "devconfig_t-cycle", offsetof( struct devconfig_t, cycle ), sizeof( double ) );
	swigStructField( "devconfig_t-mincycle", offsetof( struct devconfig_t, mincycle ), sizeof( double ) );
	swigStructField( "devconfig_t-driver_mode", offsetof( struct devconfig_t, driver_mode ), sizeof( int ) );
	swigStructField( "devconfig_t-subtype", offsetof( struct devconfig_t, subtype ), sizeof( char [64] ) );
	swigStructField( "devconfig_t-flags", offsetof( struct devconfig_t, flags ), sizeof( int ) );
	swigStructField( "devconfig_t-path", offsetof( struct devconfig_t, path ), sizeof( char [128] ) );
	swigStructField( "devconfig_t-baudrate", offsetof( struct devconfig_t, baudrate ), sizeof( unsigned int ) );
	printf( "drop %zu end-structure\n", sizeof( struct devconfig_t ) );

	swigComment("policy_t\n");
	printf( "begin-structure policy_t\n" );
	swigStructField( "policy_t-raw", offsetof( struct policy_t, raw ), sizeof( int ) );
	swigStructField( "policy_t-timing", offsetof( struct policy_t, timing ), sizeof( bool ) );
	swigStructField( "policy_t-loglevel", offsetof( struct policy_t, loglevel ), sizeof( int ) );
	swigStructField( "policy_t-remote", offsetof( struct policy_t, remote ), sizeof( char [128] ) );
	swigStructField( "policy_t-json", offsetof( struct policy_t, json ), sizeof( bool ) );
	swigStructField( "policy_t-watcher", offsetof( struct policy_t, watcher ), sizeof( bool ) );
	swigStructField( "policy_t-nmea", offsetof( struct policy_t, nmea ), sizeof( bool ) );
	swigStructField( "policy_t-split24", offsetof( struct policy_t, split24 ), sizeof( bool ) );
	swigStructField( "policy_t-pps", offsetof( struct policy_t, pps ), sizeof( bool ) );
	swigStructField( "policy_t-scaled", offsetof( struct policy_t, scaled ), sizeof( bool ) );
	swigStructField( "policy_t-devpath", offsetof( struct policy_t, devpath ), sizeof( char [128] ) );
	printf( "drop %zu end-structure\n", sizeof( struct policy_t ) );

	swigComment("timedelta_t\n");
	printf( "begin-structure timedelta_t\n" );
	swigStructField( "timedelta_t-real", offsetof( struct timedelta_t, real ), sizeof( struct timespec ) );
	swigStructField( "timedelta_t-clock", offsetof( struct timedelta_t, clock ), sizeof( struct timespec ) );
	printf( "drop %zu end-structure\n", sizeof( struct timedelta_t ) );

	swigComment("gps_data_t\n");
	printf( "begin-structure gps_data_t\n" );
	swigStructField( "gps_data_t-set", offsetof( struct gps_data_t, set ), sizeof( gps_mask_t ) );
	swigStructField( "gps_data_t-dop", offsetof( struct gps_data_t, dop ), sizeof( struct dop_t ) );
	swigStructField( "gps_data_t-attitude", offsetof( struct gps_data_t, attitude ), sizeof( struct attitude_t ) );
	swigStructField( "gps_data_t-gps_fd", offsetof( struct gps_data_t, gps_fd ), sizeof( socket_t ) );
	swigStructField( "gps_data_t-rtcm2", offsetof( struct gps_data_t, rtcm2 ), sizeof( struct rtcm2_t ) );
	swigStructField( "gps_data_t-devices", offsetof( struct gps_data_t, devices ), sizeof( gps_data_t_devices ) );
	swigStructField( "gps_data_t-rtcm3", offsetof( struct gps_data_t, rtcm3 ), sizeof( struct rtcm3_t ) );
	swigStructField( "gps_data_t-ais", offsetof( struct gps_data_t, ais ), sizeof( struct ais_t ) );
	swigStructField( "gps_data_t-skyview_time", offsetof( struct gps_data_t, skyview_time ), sizeof( timestamp_t ) );
	swigStructField( "gps_data_t-raw", offsetof( struct gps_data_t, raw ), sizeof( struct rawdata_t ) );
	swigStructField( "gps_data_t-skyview", offsetof( struct gps_data_t, skyview ), sizeof( struct satellite_t [72] ) );
	swigStructField( "gps_data_t-policy", offsetof( struct gps_data_t, policy ), sizeof( struct policy_t ) );
	swigStructField( "gps_data_t-epe", offsetof( struct gps_data_t, epe ), sizeof( double ) );
	swigStructField( "gps_data_t-subframe", offsetof( struct gps_data_t, subframe ), sizeof( struct subframe_t ) );
	swigStructField( "gps_data_t-gst", offsetof( struct gps_data_t, gst ), sizeof( struct gst_t ) );
	swigStructField( "gps_data_t-toff", offsetof( struct gps_data_t, toff ), sizeof( struct timedelta_t ) );
	swigStructField( "gps_data_t-dev", offsetof( struct gps_data_t, dev ), sizeof( struct devconfig_t ) );
	swigStructField( "gps_data_t-satellites_used", offsetof( struct gps_data_t, satellites_used ), sizeof( int ) );
	swigStructField( "gps_data_t-version", offsetof( struct gps_data_t, version ), sizeof( struct version_t ) );
	swigStructField( "gps_data_t-fix", offsetof( struct gps_data_t, fix ), sizeof( struct gps_fix_t ) );
	swigStructField( "gps_data_t-privdata", offsetof( struct gps_data_t, privdata ), sizeof( void * ) );
	swigStructField( "gps_data_t-navdata", offsetof( struct gps_data_t, navdata ), sizeof( struct navdata_t ) );
	swigStructField( "gps_data_t-status", offsetof( struct gps_data_t, status ), sizeof( int ) );
	swigStructField( "gps_data_t-error", offsetof( struct gps_data_t, error ), sizeof( char [256] ) );
	swigStructField( "gps_data_t-satellites_visible", offsetof( struct gps_data_t, satellites_visible ), sizeof( int ) );
	swigStructField( "gps_data_t-separation", offsetof( struct gps_data_t, separation ), sizeof( double ) );
	swigStructField( "gps_data_t-online", offsetof( struct gps_data_t, online ), sizeof( timestamp_t ) );
	swigStructField( "gps_data_t-pps", offsetof( struct gps_data_t, pps ), sizeof( struct timedelta_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct gps_data_t ) );

	swigComment("gps_data_t_devices\n");
	printf( "begin-structure gps_data_t_devices\n" );
	swigStructField( "gps_data_t_devices-time", offsetof( gps_data_t_devices, time ), sizeof( timestamp_t ) );
	swigStructField( "gps_data_t_devices-ndevices", offsetof( gps_data_t_devices, ndevices ), sizeof( int ) );
	swigStructField( "gps_data_t_devices-list", offsetof( gps_data_t_devices, list ), sizeof( struct devconfig_t [4] ) );
	printf( "drop %zu end-structure\n", sizeof( gps_data_t_devices ) );

	swigNewline();

	swigComment("------===< functions >===-------\n");
	swigFunction( "c-function gps_open gps_open s s a -- n", "FUNCTION: gps_open", "EXTERN: n C gps_open( s s a );", "" );
	swigFunction( "c-function gps_close gps_close a -- n", "FUNCTION: gps_close", "EXTERN: n C gps_close( a );", "" );
	swigFunction( "c-function gps_send gps_send a s ... -- n", "FUNCTION: gps_send", "EXTERN: n C gps_send( a s ... );", "" );
	swigFunction( "c-function gps_read gps_read a -- n", "FUNCTION: gps_read", "EXTERN: n C gps_read( a );", "" );
	swigFunction( "c-function gps_unpack gps_unpack a a -- n", "FUNCTION: gps_unpack", "EXTERN: n C gps_unpack( a a );", "" );
	swigFunction( "c-function gps_waiting gps_waiting a n -- n", "FUNCTION: gps_waiting", "EXTERN: n C gps_waiting( a n );", "" );
	swigFunction( "c-function gps_stream gps_stream a u a -- n", "FUNCTION: gps_stream", "EXTERN: n C gps_stream( a u a );", "" );
	swigFunction( "c-function gps_mainloop gps_mainloop a n a -- n", "FUNCTION: gps_mainloop", "EXTERN: n C gps_mainloop( a n a );", "" );
	swigFunction( "c-function gps_data gps_data a -- s", "FUNCTION: gps_data", "EXTERN: s C gps_data( a );", "" );
	swigFunction( "c-function gps_errstr gps_errstr n -- s", "FUNCTION: gps_errstr", "EXTERN: s C gps_errstr( n );", "" );
	swigFunction( "c-function json_toff_read json_toff_read s a a -- n", "FUNCTION: json_toff_read", "EXTERN: n C json_toff_read( s a a );", "" );
	swigFunction( "c-function json_pps_read json_pps_read s a a -- n", "FUNCTION: json_pps_read", "EXTERN: n C json_pps_read( s a a );", "" );
	swigFunction( "c-function libgps_trace libgps_trace n s ... -- void", "FUNCTION: libgps_trace", "EXTERN: void C libgps_trace( n s ... );", "" );
	swigFunction( "c-function gps_clear_fix gps_clear_fix a -- void", "FUNCTION: gps_clear_fix", "EXTERN: void C gps_clear_fix( a );", "" );
	swigFunction( "c-function gps_clear_dop gps_clear_dop a -- void", "FUNCTION: gps_clear_dop", "EXTERN: void C gps_clear_dop( a );", "" );
	swigFunction( "c-function gps_merge_fix gps_merge_fix a ud a -- void", "FUNCTION: gps_merge_fix", "EXTERN: void C gps_merge_fix( a ud a );", "" );
	swigFunction( "c-function gps_enable_debug gps_enable_debug n a -- void", "FUNCTION: gps_enable_debug", "EXTERN: void C gps_enable_debug( n a );", "" );
	swigFunction( "c-function gps_maskdump gps_maskdump ud -- s", "FUNCTION: gps_maskdump", "EXTERN: s C gps_maskdump( ud );", "" );
	swigFunction( "c-function safe_atof safe_atof s -- r", "FUNCTION: safe_atof", "EXTERN: r C safe_atof( s );", "" );
	swigFunction( "c-function mkgmtime mkgmtime a -- n", "FUNCTION: mkgmtime", "EXTERN: n C mkgmtime( a );", "" );
	swigFunction( "c-function timestamp timestamp  -- r", "FUNCTION: timestamp", "EXTERN: r C timestamp(  );", "" );
	swigFunction( "c-function iso8601_to_unix iso8601_to_unix a -- r", "FUNCTION: iso8601_to_unix", "EXTERN: r C iso8601_to_unix( a );", "" );
	swigFunction( "c-function unix_to_iso8601 unix_to_iso8601 r a n -- a", "FUNCTION: unix_to_iso8601", "EXTERN: a C unix_to_iso8601( r a n );", "" );
	swigFunction( "c-function earth_distance earth_distance r r r r -- r", "FUNCTION: earth_distance", "EXTERN: r C earth_distance( r r r r );", "" );
	swigFunction( "c-function earth_distance_and_bearings earth_distance_and_bearings r r r r a a -- r", "FUNCTION: earth_distance_and_bearings", "EXTERN: r C earth_distance_and_bearings( r r r r a a );", "" );
	swigFunction( "c-function wgs84_separation wgs84_separation r r -- r", "FUNCTION: wgs84_separation", "EXTERN: r C wgs84_separation( r r );", "" );
	
	return 0;
} /* end of main */



