/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 3.0.9
 *
 * This file is not intended to be easily readable and contains a number of
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG
 * interface file instead.
 * ----------------------------------------------------------------------------- */
#include <stdio.h>
#include <string.h>
#include <stddef.h>



#include <SOIL2.h>
#ifdef __gnu_linux__
#undef stderr
extern struct _IO_FILE *stderr;
#endif

typedef enum{ NONE = -1, GFORTH = 0, SWIFTFORTH, VFX } SwigTargetSystem;
SwigTargetSystem swigTargetSystem = NONE;

unsigned char swigPrintStackComments = 1;

/* comments */
void swigNewline()
{
	printf( "\n" );
}

void swigComment( char *comment )
{
	printf( "\\ %s", comment );
}

/* constants */
void swigIntConstant( long constant, char *name )
{
	printf( "%ld\tconstant %s\n", constant, name );
}

void swigUnsignedIntConstant( unsigned long constant, char *name )
{
	printf( "%lu\tconstant %s\n", constant, name );
}

void swigLongConstant( long long constant, char *name )
{
	printf( "%lld.\t2constant %s\n", constant, name );
}

void swigUnsignedLongConstant( unsigned long long constant, char *name )
{
	printf( "%llu.\t2constant %s\n", constant, name );
}

void swigFloatConstant( double constant, char *name )
{
	char buffer[128];
	sprintf( buffer, "%f", constant );

	/* if the constant contains no exponent, add one */
	char *s;
	for( s = buffer; *s != 0; s++ )
		if( *s == 'e' || *s == 'E' )
			break;

	/* exponent found */
	if( *s != 0 )
		printf( "%s\tfconstant %s\n", buffer, name );
	/* not found */
	else
		printf( "%se0\tfconstant %s\n", buffer, name );
}

void swigStringConstant( char* constant, char *name )
{
	char c;
	printf( ": %s s\\\" ", name );
	while(( c = *constant++ ))
	{
		switch(c)
		{
			case '\b': printf( "\\b" ); break;
			case '\n': printf( "\\n" ); break;
			case '\f': printf( "\\f" ); break;
			case '\r': printf( "\\r" ); break;
			case '\t': printf( "\\t" ); break;
			case '"' : printf( "\\q" ); break;
			default:
				if(c < 0x20)
					printf("\\x%02x", c);
				else
					printf("%c", c); break;
		}
	}
	printf(	"\" ;\n" );
}

/* structs */
void swigStructField( char *name, size_t offset, size_t size )
{
	printf( "\tdrop %zu %zu +field %s\n", offset, size, name );
}

/* functions */
void swigFunction( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	if( swigTargetSystem == GFORTH )
		printf( "%s", gforth );
	else if( swigTargetSystem == SWIFTFORTH )
		printf( "%s", swiftForth );
	else if( swigTargetSystem == VFX )
		printf( "%s", vfx );

	if( swigPrintStackComments )
		printf( "%s", stackComment );

	printf( "\n" );
}

/* function pointers */
void swigFunctionPointer( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	swigFunction( gforth, swiftForth, vfx, stackComment );
}

/* callbacks */
void swigCallback( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	swigFunction( gforth, swiftForth, vfx, stackComment );
}

void swigUsage( char **argv )
{
	fprintf( stderr, "Usage: %s [-gforth|-swiftforth|-vfx]\n", argv[0] );
}

int main( int argc, char **argv )
{
	int i;

	/* check arguments */
	for( i = 1; i < argc; i++ )
		if( strcmp( argv[i], "-gforth" ) == 0 )
			swigTargetSystem = GFORTH;
		else if( strcmp( argv[i], "-swiftforth" ) == 0 )
			swigTargetSystem = SWIFTFORTH;
		else if( strcmp( argv[i], "-vfx" ) == 0 )
			swigTargetSystem = VFX;

	if( swigTargetSystem == NONE )
	{
		fprintf( stderr, "Error: no target system specified\n" );
		swigUsage( argv );
		return 1;
	}

	/* primer */
	printf( "\\ This file has been generated using SWIG and fsi,\n"
		"\\ and is already platform dependent, search for the corresponding\n"
		"\\ fsi-file to compile it where no one has compiled it before ;)\n"
		"\\ GForth has its own dynamic loader and doesn't need addional C-Code.\n"
		"\\ That's why this file contains normal Gforth-code( version 0.6.9 or higher )\n"
		"\\ and could be used directly with include or require.\n"
		"\\ As all comments are stripped during the compilation, please\n"
		"\\ insert the copyright notice of the original file here.\n"
	);



	swigNewline();

	swigComment("--------===< enums >===---------\n");
	swigIntConstant( SOIL_LOAD_AUTO, "SOIL_LOAD_AUTO" );
	swigIntConstant( SOIL_LOAD_L, "SOIL_LOAD_L" );
	swigIntConstant( SOIL_LOAD_LA, "SOIL_LOAD_LA" );
	swigIntConstant( SOIL_LOAD_RGB, "SOIL_LOAD_RGB" );
	swigIntConstant( SOIL_LOAD_RGBA, "SOIL_LOAD_RGBA" );
	swigIntConstant( SOIL_CREATE_NEW_ID, "SOIL_CREATE_NEW_ID" );
	swigIntConstant( SOIL_FLAG_POWER_OF_TWO, "SOIL_FLAG_POWER_OF_TWO" );
	swigIntConstant( SOIL_FLAG_MIPMAPS, "SOIL_FLAG_MIPMAPS" );
	swigIntConstant( SOIL_FLAG_TEXTURE_REPEATS, "SOIL_FLAG_TEXTURE_REPEATS" );
	swigIntConstant( SOIL_FLAG_MULTIPLY_ALPHA, "SOIL_FLAG_MULTIPLY_ALPHA" );
	swigIntConstant( SOIL_FLAG_INVERT_Y, "SOIL_FLAG_INVERT_Y" );
	swigIntConstant( SOIL_FLAG_COMPRESS_TO_DXT, "SOIL_FLAG_COMPRESS_TO_DXT" );
	swigIntConstant( SOIL_FLAG_DDS_LOAD_DIRECT, "SOIL_FLAG_DDS_LOAD_DIRECT" );
	swigIntConstant( SOIL_FLAG_NTSC_SAFE_RGB, "SOIL_FLAG_NTSC_SAFE_RGB" );
	swigIntConstant( SOIL_FLAG_CoCg_Y, "SOIL_FLAG_CoCg_Y" );
	swigIntConstant( SOIL_FLAG_TEXTURE_RECTANGLE, "SOIL_FLAG_TEXTURE_RECTANGLE" );
	swigIntConstant( SOIL_FLAG_PVR_LOAD_DIRECT, "SOIL_FLAG_PVR_LOAD_DIRECT" );
	swigIntConstant( SOIL_FLAG_ETC1_LOAD_DIRECT, "SOIL_FLAG_ETC1_LOAD_DIRECT" );
	swigIntConstant( SOIL_FLAG_GL_MIPMAPS, "SOIL_FLAG_GL_MIPMAPS" );
	swigIntConstant( SOIL_SAVE_TYPE_TGA, "SOIL_SAVE_TYPE_TGA" );
	swigIntConstant( SOIL_SAVE_TYPE_BMP, "SOIL_SAVE_TYPE_BMP" );
	swigIntConstant( SOIL_SAVE_TYPE_PNG, "SOIL_SAVE_TYPE_PNG" );
	swigIntConstant( SOIL_SAVE_TYPE_DDS, "SOIL_SAVE_TYPE_DDS" );
	swigIntConstant( SOIL_HDR_RGBE, "SOIL_HDR_RGBE" );
	swigIntConstant( SOIL_HDR_RGBdivA, "SOIL_HDR_RGBdivA" );
	swigIntConstant( SOIL_HDR_RGBdivA2, "SOIL_HDR_RGBdivA2" );

	swigNewline();

	swigComment("------===< functions >===-------\n");
	swigFunction( "c-function SOIL_load_OGL_texture SOIL_load_OGL_texture s n u u -- u", "FUNCTION: SOIL_load_OGL_texture", "EXTERN: u C SOIL_load_OGL_texture( s n u u );", "" );
	swigFunction( "c-function SOIL_load_OGL_cubemap SOIL_load_OGL_cubemap s s s s s s n u u -- u", "FUNCTION: SOIL_load_OGL_cubemap", "EXTERN: u C SOIL_load_OGL_cubemap( s s s s s s n u u );", "" );
	swigFunction( "c-function SOIL_load_OGL_single_cubemap SOIL_load_OGL_single_cubemap s s n u u -- u", "FUNCTION: SOIL_load_OGL_single_cubemap", "EXTERN: u C SOIL_load_OGL_single_cubemap( s s n u u );", "" );
	swigFunction( "c-function SOIL_load_OGL_HDR_texture SOIL_load_OGL_HDR_texture s n n u u -- u", "FUNCTION: SOIL_load_OGL_HDR_texture", "EXTERN: u C SOIL_load_OGL_HDR_texture( s n n u u );", "" );
	swigFunction( "c-function SOIL_load_OGL_texture_from_memory SOIL_load_OGL_texture_from_memory a n n u u -- u", "FUNCTION: SOIL_load_OGL_texture_from_memory", "EXTERN: u C SOIL_load_OGL_texture_from_memory( a n n u u );", "" );
	swigFunction( "c-function SOIL_load_OGL_cubemap_from_memory SOIL_load_OGL_cubemap_from_memory a n a n a n a n a n a n n u u -- u", "FUNCTION: SOIL_load_OGL_cubemap_from_memory", "EXTERN: u C SOIL_load_OGL_cubemap_from_memory( a n a n a n a n a n a n n u u );", "" );
	swigFunction( "c-function SOIL_load_OGL_single_cubemap_from_memory SOIL_load_OGL_single_cubemap_from_memory a n s n u u -- u", "FUNCTION: SOIL_load_OGL_single_cubemap_from_memory", "EXTERN: u C SOIL_load_OGL_single_cubemap_from_memory( a n s n u u );", "" );
	swigFunction( "c-function SOIL_create_OGL_texture SOIL_create_OGL_texture a a a n u u -- u", "FUNCTION: SOIL_create_OGL_texture", "EXTERN: u C SOIL_create_OGL_texture( a a a n u u );", "" );
	swigFunction( "c-function SOIL_create_OGL_single_cubemap SOIL_create_OGL_single_cubemap a n n n s u u -- u", "FUNCTION: SOIL_create_OGL_single_cubemap", "EXTERN: u C SOIL_create_OGL_single_cubemap( a n n n s u u );", "" );
	swigFunction( "c-function SOIL_save_screenshot SOIL_save_screenshot s n n n n n -- n", "FUNCTION: SOIL_save_screenshot", "EXTERN: n C SOIL_save_screenshot( s n n n n n );", "" );
	swigFunction( "c-function SOIL_load_image SOIL_load_image s a a a n -- a", "FUNCTION: SOIL_load_image", "EXTERN: a C SOIL_load_image( s a a a n );", "" );
	swigFunction( "c-function SOIL_load_image_from_memory SOIL_load_image_from_memory a n a a a n -- a", "FUNCTION: SOIL_load_image_from_memory", "EXTERN: a C SOIL_load_image_from_memory( a n a a a n );", "" );
	swigFunction( "c-function SOIL_save_image SOIL_save_image s n n n n a -- n", "FUNCTION: SOIL_save_image", "EXTERN: n C SOIL_save_image( s n n n n a );", "" );
	swigFunction( "c-function SOIL_free_image_data SOIL_free_image_data a -- void", "FUNCTION: SOIL_free_image_data", "EXTERN: void C SOIL_free_image_data( a );", "" );
	swigFunction( "c-function SOIL_last_result SOIL_last_result  -- s", "FUNCTION: SOIL_last_result", "EXTERN: s C SOIL_last_result(  );", "" );
	swigFunction( "c-function SOIL_GL_GetProcAddress SOIL_GL_GetProcAddress s -- a", "FUNCTION: SOIL_GL_GetProcAddress", "EXTERN: a C SOIL_GL_GetProcAddress( s );", "" );
	swigFunction( "c-function SOIL_GL_ExtensionSupported SOIL_GL_ExtensionSupported s -- n", "FUNCTION: SOIL_GL_ExtensionSupported", "EXTERN: n C SOIL_GL_ExtensionSupported( s );", "" );
	swigFunction( "c-function SOIL_direct_load_DDS SOIL_direct_load_DDS s u n n -- u", "FUNCTION: SOIL_direct_load_DDS", "EXTERN: u C SOIL_direct_load_DDS( s u n n );", "" );
	swigFunction( "c-function SOIL_direct_load_DDS_from_memory SOIL_direct_load_DDS_from_memory a n u n n -- u", "FUNCTION: SOIL_direct_load_DDS_from_memory", "EXTERN: u C SOIL_direct_load_DDS_from_memory( a n u n n );", "" );
	swigFunction( "c-function SOIL_direct_load_PVR SOIL_direct_load_PVR s u n n -- u", "FUNCTION: SOIL_direct_load_PVR", "EXTERN: u C SOIL_direct_load_PVR( s u n n );", "" );
	swigFunction( "c-function SOIL_direct_load_PVR_from_memory SOIL_direct_load_PVR_from_memory a n u n n -- u", "FUNCTION: SOIL_direct_load_PVR_from_memory", "EXTERN: u C SOIL_direct_load_PVR_from_memory( a n u n n );", "" );
	swigFunction( "c-function SOIL_direct_load_ETC1 SOIL_direct_load_ETC1 s u n -- u", "FUNCTION: SOIL_direct_load_ETC1", "EXTERN: u C SOIL_direct_load_ETC1( s u n );", "" );
	swigFunction( "c-function SOIL_direct_load_ETC1_from_memory SOIL_direct_load_ETC1_from_memory a n u n -- u", "FUNCTION: SOIL_direct_load_ETC1_from_memory", "EXTERN: u C SOIL_direct_load_ETC1_from_memory( a n u n );", "" );
	
	return 0;
} /* end of main */



