/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 3.0.9
 *
 * This file is not intended to be easily readable and contains a number of
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG
 * interface file instead.
 * ----------------------------------------------------------------------------- */
#include <stdio.h>
#include <string.h>
#include <stddef.h>



#include "freetype-gl.h"
#ifdef __gnu_linux__
#undef stderr
extern struct _IO_FILE *stderr;
#endif

typedef enum{ NONE = -1, GFORTH = 0, SWIFTFORTH, VFX } SwigTargetSystem;
SwigTargetSystem swigTargetSystem = NONE;

unsigned char swigPrintStackComments = 1;

/* comments */
void swigNewline()
{
	printf( "\n" );
}

void swigComment( char *comment )
{
	printf( "\\ %s", comment );
}

/* constants */
void swigIntConstant( long constant, char *name )
{
	printf( "%ld\tconstant %s\n", constant, name );
}

void swigUnsignedIntConstant( unsigned long constant, char *name )
{
	printf( "%lu\tconstant %s\n", constant, name );
}

void swigLongConstant( long long constant, char *name )
{
	printf( "%lld.\t2constant %s\n", constant, name );
}

void swigUnsignedLongConstant( unsigned long long constant, char *name )
{
	printf( "%llu.\t2constant %s\n", constant, name );
}

void swigFloatConstant( double constant, char *name )
{
	char buffer[128];
	sprintf( buffer, "%f", constant );

	/* if the constant contains no exponent, add one */
	char *s;
	for( s = buffer; *s != 0; s++ )
		if( *s == 'e' || *s == 'E' )
			break;

	/* exponent found */
	if( *s != 0 )
		printf( "%s\tfconstant %s\n", buffer, name );
	/* not found */
	else
		printf( "%se0\tfconstant %s\n", buffer, name );
}

void swigStringConstant( char* constant, char *name )
{
	char c;
	printf( ": %s s\\\" ", name );
	while(( c = *constant++ ))
	{
		switch(c)
		{
			case '\b': printf( "\\b" ); break;
			case '\n': printf( "\\n" ); break;
			case '\f': printf( "\\f" ); break;
			case '\r': printf( "\\r" ); break;
			case '\t': printf( "\\t" ); break;
			case '"' : printf( "\\q" ); break;
			default:
				if(c < 0x20)
					printf("\\x%02x", c);
				else
					printf("%c", c); break;
		}
	}
	printf(	"\" ;\n" );
}

/* structs */
void swigStructField( char *name, size_t offset, size_t size )
{
	printf( "\tdrop %zu %zu +field %s\n", offset, size, name );
}

/* functions */
void swigFunction( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	if( swigTargetSystem == GFORTH )
		printf( "%s", gforth );
	else if( swigTargetSystem == SWIFTFORTH )
		printf( "%s", swiftForth );
	else if( swigTargetSystem == VFX )
		printf( "%s", vfx );

	if( swigPrintStackComments )
		printf( "%s", stackComment );

	printf( "\n" );
}

/* function pointers */
void swigFunctionPointer( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	swigFunction( gforth, swiftForth, vfx, stackComment );
}

/* callbacks */
void swigCallback( char* gforth, char *swiftForth, char *vfx, char *stackComment )
{
	swigFunction( gforth, swiftForth, vfx, stackComment );
}

void swigUsage( char **argv )
{
	fprintf( stderr, "Usage: %s [-gforth|-swiftforth|-vfx]\n", argv[0] );
}

int main( int argc, char **argv )
{
	int i;

	/* check arguments */
	for( i = 1; i < argc; i++ )
		if( strcmp( argv[i], "-gforth" ) == 0 )
			swigTargetSystem = GFORTH;
		else if( strcmp( argv[i], "-swiftforth" ) == 0 )
			swigTargetSystem = SWIFTFORTH;
		else if( strcmp( argv[i], "-vfx" ) == 0 )
			swigTargetSystem = VFX;

	if( swigTargetSystem == NONE )
	{
		fprintf( stderr, "Error: no target system specified\n" );
		swigUsage( argv );
		return 1;
	}

	/* primer */
	printf( "\\ This file has been generated using SWIG and fsi,\n"
		"\\ and is already platform dependent, search for the corresponding\n"
		"\\ fsi-file to compile it where no one has compiled it before ;)\n"
		"\\ GForth has its own dynamic loader and doesn't need addional C-Code.\n"
		"\\ That's why this file contains normal Gforth-code( version 0.6.9 or higher )\n"
		"\\ and could be used directly with include or require.\n"
		"\\ As all comments are stripped during the compilation, please\n"
		"\\ insert the copyright notice of the original file here.\n"
	);


typedef struct {
  const void *base;
  size_t size;
} _memory;


	swigNewline();

	swigComment("--------===< enums >===---------\n");
	swigIntConstant( TEXTURE_FONT_FILE, "TEXTURE_FONT_FILE" );
	swigIntConstant( TEXTURE_FONT_MEMORY, "TEXTURE_FONT_MEMORY" );

	swigNewline();

	swigComment("-------===< structs >===--------\n");

	swigComment("ivec4\n");
	printf( "begin-structure ivec4\n" );
	swigStructField( "ivec4-w", offsetof( ivec4, w ), sizeof( int ) );
	swigStructField( "ivec4-g", offsetof( ivec4, g ), sizeof( int ) );
	swigStructField( "ivec4-x", offsetof( ivec4, x ), sizeof( int ) );
	swigStructField( "ivec4-y", offsetof( ivec4, y ), sizeof( int ) );
	swigStructField( "ivec4-height", offsetof( ivec4, height ), sizeof( int ) );
	swigStructField( "ivec4-z", offsetof( ivec4, z ), sizeof( int ) );
	swigStructField( "ivec4-icount", offsetof( ivec4, icount ), sizeof( int ) );
	swigStructField( "ivec4-vstart", offsetof( ivec4, vstart ), sizeof( int ) );
	swigStructField( "ivec4-alpha", offsetof( ivec4, alpha ), sizeof( int ) );
	swigStructField( "ivec4-y_", offsetof( ivec4, y_ ), sizeof( int ) );
	swigStructField( "ivec4-x_", offsetof( ivec4, x_ ), sizeof( int ) );
	swigStructField( "ivec4-blue", offsetof( ivec4, blue ), sizeof( int ) );
	swigStructField( "ivec4-width", offsetof( ivec4, width ), sizeof( int ) );
	swigStructField( "ivec4-green", offsetof( ivec4, green ), sizeof( int ) );
	swigStructField( "ivec4-a", offsetof( ivec4, a ), sizeof( int ) );
	swigStructField( "ivec4-r", offsetof( ivec4, r ), sizeof( int ) );
	swigStructField( "ivec4-vcount", offsetof( ivec4, vcount ), sizeof( int ) );
	swigStructField( "ivec4-istart", offsetof( ivec4, istart ), sizeof( int ) );
	swigStructField( "ivec4-b", offsetof( ivec4, b ), sizeof( int ) );
	swigStructField( "ivec4-red", offsetof( ivec4, red ), sizeof( int ) );
	swigStructField( "ivec4-data", offsetof( ivec4, data ), sizeof( int [4] ) );
	printf( "drop %zu end-structure\n", sizeof( ivec4 ) );

	swigComment("ivec3\n");
	printf( "begin-structure ivec3\n" );
	swigStructField( "ivec3-b", offsetof( ivec3, b ), sizeof( int ) );
	swigStructField( "ivec3-data", offsetof( ivec3, data ), sizeof( int [3] ) );
	swigStructField( "ivec3-x", offsetof( ivec3, x ), sizeof( int ) );
	swigStructField( "ivec3-blue", offsetof( ivec3, blue ), sizeof( int ) );
	swigStructField( "ivec3-y", offsetof( ivec3, y ), sizeof( int ) );
	swigStructField( "ivec3-r", offsetof( ivec3, r ), sizeof( int ) );
	swigStructField( "ivec3-z", offsetof( ivec3, z ), sizeof( int ) );
	swigStructField( "ivec3-green", offsetof( ivec3, green ), sizeof( int ) );
	swigStructField( "ivec3-red", offsetof( ivec3, red ), sizeof( int ) );
	swigStructField( "ivec3-g", offsetof( ivec3, g ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( ivec3 ) );

	swigComment("ivec2\n");
	printf( "begin-structure ivec2\n" );
	swigStructField( "ivec2-end", offsetof( ivec2, end ), sizeof( int ) );
	swigStructField( "ivec2-data", offsetof( ivec2, data ), sizeof( int [2] ) );
	swigStructField( "ivec2-x", offsetof( ivec2, x ), sizeof( int ) );
	swigStructField( "ivec2-y", offsetof( ivec2, y ), sizeof( int ) );
	swigStructField( "ivec2-s", offsetof( ivec2, s ), sizeof( int ) );
	swigStructField( "ivec2-t", offsetof( ivec2, t ), sizeof( int ) );
	swigStructField( "ivec2-start", offsetof( ivec2, start ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( ivec2 ) );

	swigComment("vec4\n");
	printf( "begin-structure vec4\n" );
	swigStructField( "vec4-w", offsetof( vec4, w ), sizeof( float ) );
	swigStructField( "vec4-g", offsetof( vec4, g ), sizeof( float ) );
	swigStructField( "vec4-x", offsetof( vec4, x ), sizeof( float ) );
	swigStructField( "vec4-y", offsetof( vec4, y ), sizeof( float ) );
	swigStructField( "vec4-height", offsetof( vec4, height ), sizeof( float ) );
	swigStructField( "vec4-z", offsetof( vec4, z ), sizeof( float ) );
	swigStructField( "vec4-alpha", offsetof( vec4, alpha ), sizeof( float ) );
	swigStructField( "vec4-blue", offsetof( vec4, blue ), sizeof( float ) );
	swigStructField( "vec4-width", offsetof( vec4, width ), sizeof( float ) );
	swigStructField( "vec4-green", offsetof( vec4, green ), sizeof( float ) );
	swigStructField( "vec4-a", offsetof( vec4, a ), sizeof( float ) );
	swigStructField( "vec4-r", offsetof( vec4, r ), sizeof( float ) );
	swigStructField( "vec4-left", offsetof( vec4, left ), sizeof( float ) );
	swigStructField( "vec4-b", offsetof( vec4, b ), sizeof( float ) );
	swigStructField( "vec4-red", offsetof( vec4, red ), sizeof( float ) );
	swigStructField( "vec4-top", offsetof( vec4, top ), sizeof( float ) );
	swigStructField( "vec4-data", offsetof( vec4, data ), sizeof( float [4] ) );
	printf( "drop %zu end-structure\n", sizeof( vec4 ) );

	swigComment("vec3\n");
	printf( "begin-structure vec3\n" );
	swigStructField( "vec3-b", offsetof( vec3, b ), sizeof( float ) );
	swigStructField( "vec3-data", offsetof( vec3, data ), sizeof( float [3] ) );
	swigStructField( "vec3-x", offsetof( vec3, x ), sizeof( float ) );
	swigStructField( "vec3-blue", offsetof( vec3, blue ), sizeof( float ) );
	swigStructField( "vec3-y", offsetof( vec3, y ), sizeof( float ) );
	swigStructField( "vec3-r", offsetof( vec3, r ), sizeof( float ) );
	swigStructField( "vec3-z", offsetof( vec3, z ), sizeof( float ) );
	swigStructField( "vec3-green", offsetof( vec3, green ), sizeof( float ) );
	swigStructField( "vec3-red", offsetof( vec3, red ), sizeof( float ) );
	swigStructField( "vec3-g", offsetof( vec3, g ), sizeof( float ) );
	printf( "drop %zu end-structure\n", sizeof( vec3 ) );

	swigComment("vec2\n");
	printf( "begin-structure vec2\n" );
	swigStructField( "vec2-data", offsetof( vec2, data ), sizeof( float [2] ) );
	swigStructField( "vec2-x", offsetof( vec2, x ), sizeof( float ) );
	swigStructField( "vec2-y", offsetof( vec2, y ), sizeof( float ) );
	swigStructField( "vec2-s", offsetof( vec2, s ), sizeof( float ) );
	swigStructField( "vec2-t", offsetof( vec2, t ), sizeof( float ) );
	printf( "drop %zu end-structure\n", sizeof( vec2 ) );

	swigComment("vector_t\n");
	printf( "begin-structure vector_t\n" );
	swigStructField( "vector_t-items", offsetof( struct vector_t, items ), sizeof( void * ) );
	swigStructField( "vector_t-size", offsetof( struct vector_t, size ), sizeof( size_t ) );
	swigStructField( "vector_t-item_size", offsetof( struct vector_t, item_size ), sizeof( size_t ) );
	swigStructField( "vector_t-capacity", offsetof( struct vector_t, capacity ), sizeof( size_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct vector_t ) );

	swigComment("texture_atlas_t\n");
	printf( "begin-structure texture_atlas_t\n" );
	swigStructField( "texture_atlas_t-data", offsetof( struct texture_atlas_t, data ), sizeof( unsigned char * ) );
	swigStructField( "texture_atlas_t-id", offsetof( struct texture_atlas_t, id ), sizeof( unsigned int ) );
	swigStructField( "texture_atlas_t-nodes", offsetof( struct texture_atlas_t, nodes ), sizeof( vector_t * ) );
	swigStructField( "texture_atlas_t-height", offsetof( struct texture_atlas_t, height ), sizeof( size_t ) );
	swigStructField( "texture_atlas_t-used", offsetof( struct texture_atlas_t, used ), sizeof( size_t ) );
	swigStructField( "texture_atlas_t-width", offsetof( struct texture_atlas_t, width ), sizeof( size_t ) );
	swigStructField( "texture_atlas_t-depth", offsetof( struct texture_atlas_t, depth ), sizeof( size_t ) );
	printf( "drop %zu end-structure\n", sizeof( struct texture_atlas_t ) );

	swigComment("kerning_t\n");
	printf( "begin-structure kerning_t\n" );
	swigStructField( "kerning_t-codepoint", offsetof( struct kerning_t, codepoint ), sizeof( uint32_t ) );
	swigStructField( "kerning_t-kerning", offsetof( struct kerning_t, kerning ), sizeof( float ) );
	printf( "drop %zu end-structure\n", sizeof( struct kerning_t ) );

	swigComment("texture_glyph_t\n");
	printf( "begin-structure texture_glyph_t\n" );
	swigStructField( "texture_glyph_t-codepoint", offsetof( struct texture_glyph_t, codepoint ), sizeof( uint32_t ) );
	swigStructField( "texture_glyph_t-height", offsetof( struct texture_glyph_t, height ), sizeof( size_t ) );
	swigStructField( "texture_glyph_t-t0", offsetof( struct texture_glyph_t, t0 ), sizeof( float ) );
	swigStructField( "texture_glyph_t-t1", offsetof( struct texture_glyph_t, t1 ), sizeof( float ) );
	swigStructField( "texture_glyph_t-outline_thickness", offsetof( struct texture_glyph_t, outline_thickness ), sizeof( float ) );
	swigStructField( "texture_glyph_t-s0", offsetof( struct texture_glyph_t, s0 ), sizeof( float ) );
	swigStructField( "texture_glyph_t-s1", offsetof( struct texture_glyph_t, s1 ), sizeof( float ) );
	swigStructField( "texture_glyph_t-offset_x", offsetof( struct texture_glyph_t, offset_x ), sizeof( int ) );
	swigStructField( "texture_glyph_t-offset_y", offsetof( struct texture_glyph_t, offset_y ), sizeof( int ) );
	swigStructField( "texture_glyph_t-outline_type", offsetof( struct texture_glyph_t, outline_type ), sizeof( int ) );
	swigStructField( "texture_glyph_t-advance_x", offsetof( struct texture_glyph_t, advance_x ), sizeof( float ) );
	swigStructField( "texture_glyph_t-advance_y", offsetof( struct texture_glyph_t, advance_y ), sizeof( float ) );
	swigStructField( "texture_glyph_t-width", offsetof( struct texture_glyph_t, width ), sizeof( size_t ) );
	swigStructField( "texture_glyph_t-kerning", offsetof( struct texture_glyph_t, kerning ), sizeof( vector_t * ) );
	printf( "drop %zu end-structure\n", sizeof( struct texture_glyph_t ) );

	swigComment("texture_font_t\n");
	printf( "begin-structure texture_font_t\n" );
	swigStructField( "texture_font_t-ascender", offsetof( struct texture_font_t, ascender ), sizeof( float ) );
	swigStructField( "texture_font_t-descender", offsetof( struct texture_font_t, descender ), sizeof( float ) );
	swigStructField( "texture_font_t-height", offsetof( struct texture_font_t, height ), sizeof( float ) );
	swigStructField( "texture_font_t-size", offsetof( struct texture_font_t, size ), sizeof( float ) );
	swigStructField( "texture_font_t-location", offsetof( struct texture_font_t, location ), sizeof( loc_t ) );
	swigStructField( "texture_font_t-glyphs", offsetof( struct texture_font_t, glyphs ), sizeof( vector_t * ) );
	swigStructField( "texture_font_t-linegap", offsetof( struct texture_font_t, linegap ), sizeof( float ) );
	swigStructField( "texture_font_t-outline_thickness", offsetof( struct texture_font_t, outline_thickness ), sizeof( float ) );
	swigStructField( "texture_font_t-underline_thickness", offsetof( struct texture_font_t, underline_thickness ), sizeof( float ) );
	swigStructField( "texture_font_t-filtering", offsetof( struct texture_font_t, filtering ), sizeof( int ) );
	swigStructField( "texture_font_t-outline_type", offsetof( struct texture_font_t, outline_type ), sizeof( int ) );
	swigStructField( "texture_font_t-atlas", offsetof( struct texture_font_t, atlas ), sizeof( texture_atlas_t * ) );
	swigStructField( "texture_font_t-lcd_weights", offsetof( struct texture_font_t, lcd_weights ), sizeof( unsigned char [5] ) );
	swigStructField( "texture_font_t-hinting", offsetof( struct texture_font_t, hinting ), sizeof( int ) );
	swigStructField( "texture_font_t-underline_position", offsetof( struct texture_font_t, underline_position ), sizeof( float ) );
	swigStructField( "texture_font_t-filename", offsetof( struct texture_font_t, filename ), sizeof( char * ) );
	swigStructField( "texture_font_t-memory", offsetof( struct texture_font_t, memory ), sizeof( _memory ) );
	swigStructField( "texture_font_t-kerning", offsetof( struct texture_font_t, kerning ), sizeof( int ) );
	printf( "drop %zu end-structure\n", sizeof( struct texture_font_t ) );

	swigNewline();

	swigComment("------===< functions >===-------\n");
	swigFunction( "c-function vector_new vector_new n -- a", "FUNCTION: vector_new", "EXTERN: a C vector_new( n );", "" );
	swigFunction( "c-function vector_delete vector_delete a -- void", "FUNCTION: vector_delete", "EXTERN: void C vector_delete( a );", "" );
	swigFunction( "c-function vector_get vector_get a n -- a", "FUNCTION: vector_get", "EXTERN: a C vector_get( a n );", "" );
	swigFunction( "c-function vector_front vector_front a -- a", "FUNCTION: vector_front", "EXTERN: a C vector_front( a );", "" );
	swigFunction( "c-function vector_back vector_back a -- a", "FUNCTION: vector_back", "EXTERN: a C vector_back( a );", "" );
	swigFunction( "c-function vector_contains vector_contains a a a -- n", "FUNCTION: vector_contains", "EXTERN: n C vector_contains( a a a );", "" );
	swigFunction( "c-function vector_empty vector_empty a -- n", "FUNCTION: vector_empty", "EXTERN: n C vector_empty( a );", "" );
	swigFunction( "c-function vector_size vector_size a -- n", "FUNCTION: vector_size", "EXTERN: n C vector_size( a );", "" );
	swigFunction( "c-function vector_reserve vector_reserve a n -- void", "FUNCTION: vector_reserve", "EXTERN: void C vector_reserve( a n );", "" );
	swigFunction( "c-function vector_capacity vector_capacity a -- n", "FUNCTION: vector_capacity", "EXTERN: n C vector_capacity( a );", "" );
	swigFunction( "c-function vector_shrink vector_shrink a -- void", "FUNCTION: vector_shrink", "EXTERN: void C vector_shrink( a );", "" );
	swigFunction( "c-function vector_clear vector_clear a -- void", "FUNCTION: vector_clear", "EXTERN: void C vector_clear( a );", "" );
	swigFunction( "c-function vector_set vector_set a n a -- void", "FUNCTION: vector_set", "EXTERN: void C vector_set( a n a );", "" );
	swigFunction( "c-function vector_erase vector_erase a n -- void", "FUNCTION: vector_erase", "EXTERN: void C vector_erase( a n );", "" );
	swigFunction( "c-function vector_erase_range vector_erase_range a n n -- void", "FUNCTION: vector_erase_range", "EXTERN: void C vector_erase_range( a n n );", "" );
	swigFunction( "c-function vector_push_back vector_push_back a a -- void", "FUNCTION: vector_push_back", "EXTERN: void C vector_push_back( a a );", "" );
	swigFunction( "c-function vector_pop_back vector_pop_back a -- void", "FUNCTION: vector_pop_back", "EXTERN: void C vector_pop_back( a );", "" );
	swigFunction( "c-function vector_resize vector_resize a n -- void", "FUNCTION: vector_resize", "EXTERN: void C vector_resize( a n );", "" );
	swigFunction( "c-function vector_insert vector_insert a n a -- void", "FUNCTION: vector_insert", "EXTERN: void C vector_insert( a n a );", "" );
	swigFunction( "c-function vector_insert_data vector_insert_data a n a n -- void", "FUNCTION: vector_insert_data", "EXTERN: void C vector_insert_data( a n a n );", "" );
	swigFunction( "c-function vector_push_back_data vector_push_back_data a a n -- void", "FUNCTION: vector_push_back_data", "EXTERN: void C vector_push_back_data( a a n );", "" );
	swigFunction( "c-function vector_sort vector_sort a a -- void", "FUNCTION: vector_sort", "EXTERN: void C vector_sort( a a );", "" );
	swigFunction( "c-function texture_atlas_new texture_atlas_new n n n -- a", "FUNCTION: texture_atlas_new", "EXTERN: a C texture_atlas_new( n n n );", "" );
	swigFunction( "c-function texture_atlas_delete texture_atlas_delete a -- void", "FUNCTION: texture_atlas_delete", "EXTERN: void C texture_atlas_delete( a );", "" );
	swigFunction( "c-function texture_atlas_upload texture_atlas_upload a -- void", "FUNCTION: texture_atlas_upload", "EXTERN: void C texture_atlas_upload( a );", "" );
	swigFunction( "c-function texture_atlas_get_region texture_atlas_get_region a n n -- struct", "FUNCTION: texture_atlas_get_region", "EXTERN: struct C texture_atlas_get_region( a n n );", "" );
	swigFunction( "c-function texture_atlas_set_region texture_atlas_set_region a n n n n a n -- void", "FUNCTION: texture_atlas_set_region", "EXTERN: void C texture_atlas_set_region( a n n n n a n );", "" );
	swigFunction( "c-function texture_atlas_clear texture_atlas_clear a -- void", "FUNCTION: texture_atlas_clear", "EXTERN: void C texture_atlas_clear( a );", "" );
	swigFunction( "c-function texture_font_new_from_file texture_font_new_from_file a r s -- a", "FUNCTION: texture_font_new_from_file", "EXTERN: a C texture_font_new_from_file( a r s );", "" );
	swigFunction( "c-function texture_font_new_from_memory texture_font_new_from_memory a r a n -- a", "FUNCTION: texture_font_new_from_memory", "EXTERN: a C texture_font_new_from_memory( a r a n );", "" );
	swigFunction( "c-function texture_font_delete texture_font_delete a -- void", "FUNCTION: texture_font_delete", "EXTERN: void C texture_font_delete( a );", "" );
	swigFunction( "c-function texture_font_get_glyph texture_font_get_glyph a s -- a", "FUNCTION: texture_font_get_glyph", "EXTERN: a C texture_font_get_glyph( a s );", "" );
	swigFunction( "c-function texture_font_load_glyphs texture_font_load_glyphs a s -- n", "FUNCTION: texture_font_load_glyphs", "EXTERN: n C texture_font_load_glyphs( a s );", "" );
	swigFunction( "c-function texture_glyph_get_kerning texture_glyph_get_kerning a s -- r", "FUNCTION: texture_glyph_get_kerning", "EXTERN: r C texture_glyph_get_kerning( a s );", "" );
	swigFunction( "c-function texture_glyph_new texture_glyph_new  -- a", "FUNCTION: texture_glyph_new", "EXTERN: a C texture_glyph_new(  );", "" );
	
	return 0;
} /* end of main */



