#include <gforth/0.7.9_20150610/libcc.h>
#include <avcall.h>
#include <callback.h>
static av_alist alist;
static va_alist gforth_clist;
static float frv;
static int irv;
static double drv;
static long long llrv;
static void * prv;

void gforth_callback_ffcall(Xt* fcall, void * alist)
{
  {
    /* save global variables */
    stackpointers *SPs=get_gforth_SPs();
    Cell *rp = SPs->rpx;
    Cell *sp = SPs->spx;
    Float *fp = SPs->fpx;
    char *lp = SPs->lpx;
    va_alist clist = gforth_clist;

    gforth_clist = (va_alist)alist;

    gforth_engine(fcall, SPs);

    /* restore global variables */
    SPs->rpx = rp;
    SPs->spx = sp;
    SPs->fpx = fp;
    SPs->lpx = lp;
    gforth_clist = clist;
  }
}
#define av_start_void1(c_addr) av_start_void(alist, c_addr)
ptrpair libgffflib_LTX_gforth_c_av_start_void1_a_v(GFORTH_ARGS)
{
  Cell MAYBE_UNUSED *sp = x.sp;
  Float MAYBE_UNUSED *fp = x.fp;
  int MAYBE_UNUSED arg0=0, farg0=-1;
  av_start_void1((void *)(sp[0]));
  x.sp = sp+1;
  return x;
}
#define av_start_int1(c_addr) av_start_int(alist, c_addr, &irv)
ptrpair libgffflib_LTX_gforth_c_av_start_int1_a_v(GFORTH_ARGS)
{
  Cell MAYBE_UNUSED *sp = x.sp;
  Float MAYBE_UNUSED *fp = x.fp;
  int MAYBE_UNUSED arg0=0, farg0=-1;
  av_start_int1((void *)(sp[0]));
  x.sp = sp+1;
  return x;
}
#define av_start_float1(c_addr) av_start_float(alist, c_addr, &frv)
ptrpair libgffflib_LTX_gforth_c_av_start_float1_a_v(GFORTH_ARGS)
{
  Cell MAYBE_UNUSED *sp = x.sp;
  Float MAYBE_UNUSED *fp = x.fp;
  int MAYBE_UNUSED arg0=0, farg0=-1;
  av_start_float1((void *)(sp[0]));
  x.sp = sp+1;
  return x;
}
#define av_start_double1(c_addr) av_start_double(alist, c_addr, &drv)
ptrpair libgffflib_LTX_gforth_c_av_start_double1_a_v(GFORTH_ARGS)
{
  Cell MAYBE_UNUSED *sp = x.sp;
  Float MAYBE_UNUSED *fp = x.fp;
  int MAYBE_UNUSED arg0=0, farg0=-1;
  av_start_double1((void *)(sp[0]));
  x.sp = sp+1;
  return x;
}
#define av_start_longlong1(c_addr) av_start_longlong(alist, c_addr, &llrv)
ptrpair libgffflib_LTX_gforth_c_av_start_longlong1_a_v(GFORTH_ARGS)
{
  Cell MAYBE_UNUSED *sp = x.sp;
  Float MAYBE_UNUSED *fp = x.fp;
  int MAYBE_UNUSED arg0=0, farg0=-1;
  av_start_longlong1((void *)(sp[0]));
  x.sp = sp+1;
  return x;
}
#define av_start_ptr1(c_addr) av_start_ptr(alist, c_addr, void *, &prv)
ptrpair libgffflib_LTX_gforth_c_av_start_ptr1_a_v(GFORTH_ARGS)
{
  Cell MAYBE_UNUSED *sp = x.sp;
  Float MAYBE_UNUSED *fp = x.fp;
  int MAYBE_UNUSED arg0=0, farg0=-1;
  av_start_ptr1((void *)(sp[0]));
  x.sp = sp+1;
  return x;
}
#define av_int1(w) av_int(alist,w)
ptrpair libgffflib_LTX_gforth_c_av_int1_n_v(GFORTH_ARGS)
{
  Cell MAYBE_UNUSED *sp = x.sp;
  Float MAYBE_UNUSED *fp = x.fp;
  int MAYBE_UNUSED arg0=0, farg0=-1;
  av_int1(sp[0]);
  x.sp = sp+1;
  return x;
}
#define av_float1(r) av_float(alist,r)
ptrpair libgffflib_LTX_gforth_c_av_float1_r_v(GFORTH_ARGS)
{
  Cell MAYBE_UNUSED *sp = x.sp;
  Float MAYBE_UNUSED *fp = x.fp;
  int MAYBE_UNUSED arg0=-1, farg0=0;
  av_float1(fp[0]);
  x.fp = fp+1;
  return x;
}
#define av_double1(r) av_double(alist,r)
ptrpair libgffflib_LTX_gforth_c_av_double1_r_v(GFORTH_ARGS)
{
  Cell MAYBE_UNUSED *sp = x.sp;
  Float MAYBE_UNUSED *fp = x.fp;
  int MAYBE_UNUSED arg0=-1, farg0=0;
  av_double1(fp[0]);
  x.fp = fp+1;
  return x;
}
#define av_longlong1(d) av_longlong(alist,d)
ptrpair libgffflib_LTX_gforth_c_av_longlong1_d_v(GFORTH_ARGS)
{
  Cell MAYBE_UNUSED *sp = x.sp;
  Float MAYBE_UNUSED *fp = x.fp;
  int MAYBE_UNUSED arg0=1, farg0=-1;
  av_longlong1(gforth_d2ll(sp[1],sp[0]));
  x.sp = sp+2;
  return x;
}
#define av_ptr1(a) av_ptr(alist, void *, a)
ptrpair libgffflib_LTX_gforth_c_av_ptr1_a_v(GFORTH_ARGS)
{
  Cell MAYBE_UNUSED *sp = x.sp;
  Float MAYBE_UNUSED *fp = x.fp;
  int MAYBE_UNUSED arg0=0, farg0=-1;
  av_ptr1((void *)(sp[0]));
  x.sp = sp+1;
  return x;
}
#define av_call_void() av_call(alist)
ptrpair libgffflib_LTX_gforth_c_av_call_void__v(GFORTH_ARGS)
{
  Cell MAYBE_UNUSED *sp = x.sp;
  Float MAYBE_UNUSED *fp = x.fp;
  int MAYBE_UNUSED arg0=-1, farg0=-1;
  av_call_void();
  return x;
}
#define av_call_int() (av_call(alist), irv)
ptrpair libgffflib_LTX_gforth_c_av_call_int__n(GFORTH_ARGS)
{
  Cell MAYBE_UNUSED *sp = x.sp;
  Float MAYBE_UNUSED *fp = x.fp;
  int MAYBE_UNUSED arg0=-1, farg0=-1;
  sp[-1]=av_call_int();
  x.sp = sp+-1;
  return x;
}
#define av_call_float() (av_call(alist), frv)
ptrpair libgffflib_LTX_gforth_c_av_call_float__r(GFORTH_ARGS)
{
  Cell MAYBE_UNUSED *sp = x.sp;
  Float MAYBE_UNUSED *fp = x.fp;
  int MAYBE_UNUSED arg0=-1, farg0=-1;
  fp[-1]=av_call_float();
  x.fp = fp+-1;
  return x;
}
#define av_call_double() (av_call(alist), drv)
ptrpair libgffflib_LTX_gforth_c_av_call_double__r(GFORTH_ARGS)
{
  Cell MAYBE_UNUSED *sp = x.sp;
  Float MAYBE_UNUSED *fp = x.fp;
  int MAYBE_UNUSED arg0=-1, farg0=-1;
  fp[-1]=av_call_double();
  x.fp = fp+-1;
  return x;
}
#define av_call_longlong() (av_call(alist), llrv)
ptrpair libgffflib_LTX_gforth_c_av_call_longlong__d(GFORTH_ARGS)
{
  Cell MAYBE_UNUSED *sp = x.sp;
  Float MAYBE_UNUSED *fp = x.fp;
  int MAYBE_UNUSED arg0=-1, farg0=-1;
  gforth_ll2d(av_call_longlong(),sp[-1],sp[-2]);
  x.sp = sp+-2;
  return x;
}
#define av_call_ptr() (av_call(alist), prv)
ptrpair libgffflib_LTX_gforth_c_av_call_ptr__a(GFORTH_ARGS)
{
  Cell MAYBE_UNUSED *sp = x.sp;
  Float MAYBE_UNUSED *fp = x.fp;
  int MAYBE_UNUSED arg0=-1, farg0=-1;
  sp[-1]=(Cell)av_call_ptr();
  x.sp = sp+-1;
  return x;
}
#define alloc_callback1(a_ip) alloc_callback(gforth_callback_ffcall, (Xt *)a_ip)
ptrpair libgffflib_LTX_gforth_c_alloc_callback1_a_a(GFORTH_ARGS)
{
  Cell MAYBE_UNUSED *sp = x.sp;
  Float MAYBE_UNUSED *fp = x.fp;
  int MAYBE_UNUSED arg0=0, farg0=-1;
  sp[0]=(Cell)alloc_callback1((void *)(sp[0]));
  return x;
}
#define va_start_void1() va_start_void(gforth_clist)
ptrpair libgffflib_LTX_gforth_c_va_start_void1__v(GFORTH_ARGS)
{
  Cell MAYBE_UNUSED *sp = x.sp;
  Float MAYBE_UNUSED *fp = x.fp;
  int MAYBE_UNUSED arg0=-1, farg0=-1;
  va_start_void1();
  return x;
}
#define va_start_int1() va_start_int(gforth_clist)
ptrpair libgffflib_LTX_gforth_c_va_start_int1__v(GFORTH_ARGS)
{
  Cell MAYBE_UNUSED *sp = x.sp;
  Float MAYBE_UNUSED *fp = x.fp;
  int MAYBE_UNUSED arg0=-1, farg0=-1;
  va_start_int1();
  return x;
}
#define va_start_longlong1() va_start_longlong(gforth_clist)
ptrpair libgffflib_LTX_gforth_c_va_start_longlong1__v(GFORTH_ARGS)
{
  Cell MAYBE_UNUSED *sp = x.sp;
  Float MAYBE_UNUSED *fp = x.fp;
  int MAYBE_UNUSED arg0=-1, farg0=-1;
  va_start_longlong1();
  return x;
}
#define va_start_ptr1() va_start_ptr(gforth_clist, (char *))
ptrpair libgffflib_LTX_gforth_c_va_start_ptr1__v(GFORTH_ARGS)
{
  Cell MAYBE_UNUSED *sp = x.sp;
  Float MAYBE_UNUSED *fp = x.fp;
  int MAYBE_UNUSED arg0=-1, farg0=-1;
  va_start_ptr1();
  return x;
}
#define va_start_float1() va_start_float(gforth_clist)
ptrpair libgffflib_LTX_gforth_c_va_start_float1__v(GFORTH_ARGS)
{
  Cell MAYBE_UNUSED *sp = x.sp;
  Float MAYBE_UNUSED *fp = x.fp;
  int MAYBE_UNUSED arg0=-1, farg0=-1;
  va_start_float1();
  return x;
}
#define va_start_double1() va_start_double(gforth_clist)
ptrpair libgffflib_LTX_gforth_c_va_start_double1__v(GFORTH_ARGS)
{
  Cell MAYBE_UNUSED *sp = x.sp;
  Float MAYBE_UNUSED *fp = x.fp;
  int MAYBE_UNUSED arg0=-1, farg0=-1;
  va_start_double1();
  return x;
}
#define va_arg_int1() va_arg_int(gforth_clist)
ptrpair libgffflib_LTX_gforth_c_va_arg_int1__n(GFORTH_ARGS)
{
  Cell MAYBE_UNUSED *sp = x.sp;
  Float MAYBE_UNUSED *fp = x.fp;
  int MAYBE_UNUSED arg0=-1, farg0=-1;
  sp[-1]=va_arg_int1();
  x.sp = sp+-1;
  return x;
}
#define va_arg_longlong1() va_arg_longlong(gforth_clist)
ptrpair libgffflib_LTX_gforth_c_va_arg_longlong1__d(GFORTH_ARGS)
{
  Cell MAYBE_UNUSED *sp = x.sp;
  Float MAYBE_UNUSED *fp = x.fp;
  int MAYBE_UNUSED arg0=-1, farg0=-1;
  gforth_ll2d(va_arg_longlong1(),sp[-1],sp[-2]);
  x.sp = sp+-2;
  return x;
}
#define va_arg_ptr1() va_arg_ptr(gforth_clist, char *)
ptrpair libgffflib_LTX_gforth_c_va_arg_ptr1__a(GFORTH_ARGS)
{
  Cell MAYBE_UNUSED *sp = x.sp;
  Float MAYBE_UNUSED *fp = x.fp;
  int MAYBE_UNUSED arg0=-1, farg0=-1;
  sp[-1]=(Cell)va_arg_ptr1();
  x.sp = sp+-1;
  return x;
}
#define va_arg_float1() va_arg_float(gforth_clist)
ptrpair libgffflib_LTX_gforth_c_va_arg_float1__r(GFORTH_ARGS)
{
  Cell MAYBE_UNUSED *sp = x.sp;
  Float MAYBE_UNUSED *fp = x.fp;
  int MAYBE_UNUSED arg0=-1, farg0=-1;
  fp[-1]=va_arg_float1();
  x.fp = fp+-1;
  return x;
}
#define va_arg_double1() va_arg_double(gforth_clist)
ptrpair libgffflib_LTX_gforth_c_va_arg_double1__r(GFORTH_ARGS)
{
  Cell MAYBE_UNUSED *sp = x.sp;
  Float MAYBE_UNUSED *fp = x.fp;
  int MAYBE_UNUSED arg0=-1, farg0=-1;
  fp[-1]=va_arg_double1();
  x.fp = fp+-1;
  return x;
}
#define va_return_void1() va_return_void(gforth_clist)
ptrpair libgffflib_LTX_gforth_c_va_return_void1__v(GFORTH_ARGS)
{
  Cell MAYBE_UNUSED *sp = x.sp;
  Float MAYBE_UNUSED *fp = x.fp;
  int MAYBE_UNUSED arg0=-1, farg0=-1;
  va_return_void1();
  return x;
}
#define va_return_int1(w) va_return_int(gforth_clist,w)
ptrpair libgffflib_LTX_gforth_c_va_return_int1_n_v(GFORTH_ARGS)
{
  Cell MAYBE_UNUSED *sp = x.sp;
  Float MAYBE_UNUSED *fp = x.fp;
  int MAYBE_UNUSED arg0=0, farg0=-1;
  va_return_int1(sp[0]);
  x.sp = sp+1;
  return x;
}
#define va_return_ptr1(w) va_return_ptr(gforth_clist, void *, w)
ptrpair libgffflib_LTX_gforth_c_va_return_ptr1_a_v(GFORTH_ARGS)
{
  Cell MAYBE_UNUSED *sp = x.sp;
  Float MAYBE_UNUSED *fp = x.fp;
  int MAYBE_UNUSED arg0=0, farg0=-1;
  va_return_ptr1((void *)(sp[0]));
  x.sp = sp+1;
  return x;
}
#define va_return_longlong1(d) va_return_longlong(gforth_clist,d)
ptrpair libgffflib_LTX_gforth_c_va_return_longlong1_d_v(GFORTH_ARGS)
{
  Cell MAYBE_UNUSED *sp = x.sp;
  Float MAYBE_UNUSED *fp = x.fp;
  int MAYBE_UNUSED arg0=1, farg0=-1;
  va_return_longlong1(gforth_d2ll(sp[1],sp[0]));
  x.sp = sp+2;
  return x;
}
#define va_return_float1(r) va_return_float(gforth_clist,r)
ptrpair libgffflib_LTX_gforth_c_va_return_float1_r_v(GFORTH_ARGS)
{
  Cell MAYBE_UNUSED *sp = x.sp;
  Float MAYBE_UNUSED *fp = x.fp;
  int MAYBE_UNUSED arg0=-1, farg0=0;
  va_return_float1(fp[0]);
  x.fp = fp+1;
  return x;
}
#define va_return_double1(r) va_return_double(gforth_clist,r)
ptrpair libgffflib_LTX_gforth_c_va_return_double1_r_v(GFORTH_ARGS)
{
  Cell MAYBE_UNUSED *sp = x.sp;
  Float MAYBE_UNUSED *fp = x.fp;
  int MAYBE_UNUSED arg0=-1, farg0=0;
  va_return_double1(fp[0]);
  x.fp = fp+1;
  return x;
}
hash_128 gflibcc_hash_fflib = "\xCF\xBC\xB7\x09\x75\xF9\xBA\x07\x9F\xCB\xA5\xC8\x8F\x30\x69\x2E";
