/* header file for libcc-generated C code

  Copyright (C) 2006,2007,2008,2012,2013,2014 Free Software Foundation, Inc.

  This file is part of Gforth.

  Gforth is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation, either version 3
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program. If not, see http://www.gnu.org/licenses/.
*/

#include <gforth/0.7.9_20150610/config.h>
#include <signal.h>
#include <alloca.h>
#include <setjmp.h>

#if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__) || defined(__ANDROID__)
#undef HAS_BACKLINK
#endif

typedef CELL_TYPE Cell;
typedef unsigned CELL_TYPE UCell;
typedef unsigned char Char;
typedef double Float;
typedef Char *Address;
typedef void **Xt;

#define Clongest long long
typedef unsigned Clongest UClongest;

typedef struct {
  Cell next_task;
  Cell prev_task;
  Cell save_task;
  Cell* sp0;
  Cell* rp0;
  Float* fp0;
  Address lp0;
  Xt *throw_entry;
} user_area;

typedef struct {
  Cell* sp;
  Float* fp;
} ptrpair;

typedef struct {
  Cell magic;
  Cell *spx;
  Cell *rpx;
  Address lpx;
  Float *fpx;
  user_area* upx;
  Cell *s_ip;
  Cell *s_rp;
  jmp_buf * throw_jumpptr;
} stackpointers;

#ifdef HAS_BACKLINK
#define gforth_magic (gforth_SPs.magic)
#define gforth_SP (gforth_SPs.spx)
#define gforth_RP (gforth_SPs.rpx)
#define gforth_LP (gforth_SPs.lpx)
#define gforth_FP (gforth_SPs.fpx)
#define gforth_UP (gforth_SPs.upx)
#define saved_ip (gforth_SPs.s_ip)
#define saved_rp (gforth_SPs.s_rp)
#define throw_jmp_handler (gforth_SPs.throw_jumpptr)

extern PER_THREAD stackpointers gforth_SPs;
#define get_gforth_SPs() (&gforth_SPs)
#define sr_call , get_gforth_SPs()
extern void *gforth_engine(Xt *, stackpointers *);
extern char *cstr(char *from, Cell size);
extern char *tilde_cstr(char *from, Cell size);
extern user_area* gforth_stacks(Cell dsize, Cell rsize, Cell fsize, Cell lsize);
extern void gforth_free_stacks(user_area* t);
extern user_area *gforth_main_UP;
extern Cell gforth_go(Xt *ip);
extern void gforth_sigset(sigset_t* set, ...);
ptrpair gforth_libcc_init(ptrpair x)
{
  x.sp++;
  return x;
}
#define GFORTH_ARGS ptrpair x
#else
static Cell *(*gforth_pointers)(Cell);
ptrpair gforth_libcc_init(ptrpair x)
{
  gforth_pointers=(Cell *(*)(Cell))*x.sp++;
  return x;
}
#define gforth_SPs ((stackpointers *)(gforth_pointers(0)))
#define get_gforth_SPs() ((stackpointers *)(gforth_pointers(0)))
#define sr_call , get_gforth_SPs()

#define gforth_magic (gforth_SPs->magic)
#define gforth_SP (gforth_SPs->spx)
#define gforth_RP (gforth_SPs->rpx)
#define gforth_LP (gforth_SPs->lpx)
#define gforth_FP (gforth_SPs->fpx)
#define gforth_UP (gforth_SPs->upx)
#define saved_ip (gforth_SPs->s_ip)
#define saved_rp (gforth_SPs->s_rp)
#define throw_jmp_handler (gforth_SPs->throw_jumpptr)

#define gforth_engine ((char *(*)(Xt*, stackpointers *))gforth_pointers(1))
#define cstr ((char *(*)(char *, Cell))gforth_pointers(2))
#define tilde_cstr ((char *(*)(char *, Cell))gforth_pointers(3))
#define gforth_stacks ((user_area *(*)(Cell, Cell, Cell, Cell))gforth_pointers(4))
#define gforth_free_stacks ((void(*)(user_area*))gforth_pointers(5))
#define gforth_main_UP *((user_area **)(gforth_pointers(6)))
#define gforth_go ((Cell(*)(Xt*))gforth_pointers(7))
#define gforth_sigset ((void(*)(sigset_t*, ...))gforth_pointers(8))
#define GFORTH_ARGS ptrpair x
#endif

#if SIZEOF_CHAR_P == 4
#define GFORTH_MAGIC 0x3B3C51D5U
#else
#define GFORTH_MAGIC 0x1E059AF1785E72D4ULL
#endif

#define CELL_BITS	(sizeof(Cell) * 8)

#define gforth_d2ll(lo,hi) \
  (Clongest)((sizeof(Cell) < sizeof(Clongest))		\
   ? (((UClongest)(lo))|(((UClongest)(hi))<<CELL_BITS)) \
   : (lo))

#define gforth_ud2ll(lo,hi) \
  (UClongest)((sizeof(Cell) < sizeof(Clongest))		\
   ? (((UClongest)(lo))|(((UClongest)(hi))<<CELL_BITS)) \
   : (lo))

#define gforth_ll2d(ll,lo,hi) \
  do { \
    Clongest _ll = (ll); \
    (lo) = (Cell)_ll; \
    (hi) = ((sizeof(Cell) < sizeof(Clongest)) \
            ? (_ll >> CELL_BITS) \
            : 0); \
  } while (0);

#define gforth_ll2ud(ll,lo,hi) \
  do { \
    UClongest _ll = (ll); \
    (lo) = (Cell)_ll; \
    (hi) = ((sizeof(Cell) < sizeof(Clongest)) \
            ? (_ll >> CELL_BITS) \
            : 0); \
  } while (0);

typedef Char hash_128[16];

#define GFSS 0x80 /* stack sizes */

#define GFORTH_MAKESTACK(n)					   \
  if(gforth_magic != GFORTH_MAGIC) {				   \
    gforth_RP = alloca(n*sizeof(Cell))+sizeof(Cell)*(n);	   \
    gforth_SP = alloca(n*sizeof(Cell))+sizeof(Cell)*(n-1);	   \
    gforth_FP = alloca(n*sizeof(Float))+sizeof(Float)*(n-1);	   \
    gforth_LP = alloca(n*sizeof(Cell))+sizeof(Cell)*(n);	   \
    gforth_UP = gforth_main_UP;					   \
  }
