
#include "botforth.h" 

#ifdef ptForth
#include "ptxtras.h" 
#else
#include "xtras.h" 
#endif

void INSTALL()  /* -- */
{  /* setup hash table for searching */
}

void EXECUTE_WORD()  /* ? \ s -- ? */
{  /* lookup and execute a dictionary entry */
	latest();
	SEARCH_DICTIONARY();
	if(*sp++)	/* IF */
	{
		L_TO_TICK();
		EXECUTE();
	}
	else	/* ELSE */
	{
		*(char**)--sp="\016EXECUTE-WORD: ";
		COUNT();
		TYPE();
		COUNT();
		TYPE();
		*(char**)--sp="\032 is not in the dictionary.";
		COUNT();
		TYPE();
	}
}

/* ==== Notice and error handlers ==== */

void NUMBER_arg()  /* -- n */  /* used to prefix numbers */
{
	*--sp=-1;	/* LITERAL */
}

void ERROR_STRING()  /* n -- s */
{  /* convert error number into a string */
	switch(*sp)
	{
		case 0:		*sp=(Cell)"\000";
					break;
		case -1:	*sp = (Cell)"\021File not found.  ";
					break;
		default:	*sp = (Cell)"\021An error occured.";
	}
}

void W_DOT_NOTICE()  /* s -- */
{
	QUESTION_CR();
	COUNT();
	TYPE();
}

void W_DOT_ERROR()  /* s -- */
{
	QUESTION_CR();
	*(char**)--sp="\007Error: ";
	COUNT();
	TYPE();
	COUNT();
	TYPE();
}

void W_DOT_MESSAGES()  /* ..\ n -- */
{
	*--sp=0;	/* LITERAL */
	TO_R();
	for(;;)	/* BEGIN */
	{
		QUESTION_DUP();
		if(!*sp++)break;	/* WHILE */
		SWAP();
		TO_R();
		*--sp=1;	/* LITERAL */
		MINUS();
	};	/* REPEAT */  /* reverse stack order */
	for(;;)	/* BEGIN */
	{
		R_FROM();
		QUESTION_DUP();
		if(!*sp++)break;	/* WHILE */
		DUP();
		NUMBER_arg();
		EQUALS();
		if(*sp++)	/* IF */
		{
			DROP();
			R_FROM();
			DOT();
		}
		else	/* ELSE */
		{
			COUNT();
			TYPE();
		}
	};	/* REPEAT */
}

void W_DOT_NOTICES()  /* ..\ n -- */  /* print out strings and numbers */
{
	QUESTION_CR();
	W_DOT_MESSAGES();
}

void W_DOT_ERRORS()  /* ..\ n -- */  /* print out strings and numbers */
{
	QUESTION_CR();
	*(char**)--sp="\007Error: ";
	COUNT();
	TYPE();
	W_DOT_MESSAGES();
}
 