/* Time services  Rob Chapman  Jun 8, 1993 */

#include <time.h>	/* for time functions */
#include "botforth.h"
#include "timeout.h"

/*               Timeout Support in Seconds
  Timeouts are assumed to be a coarse grained function measured in terms of
  seconds.  This mechanism requires each user to have space for a timeout
  time.  This space is initially set and then subsequently polled
  to determine if a timeout has occurred.  SET-TIMEOUT uses the current
  time and adds n seconds to it.  TIMEOUT? is used to check the timeout
  timer against the current time. */

void TIMEOUT()  /* "name" -- */
{  /* for timeout declarations */
	CREATE();
	*--sp=0;	/* LITERAL */
	COMMA();
}

void TIME()  /* -- seconds */
{  /* get the current time in seconds */
	*--sp = (Cell)time(0);
}

void TIMEOUT_QUERY()  /* a -- f */
{  /* check to see if a timeout is expired */
	FETCH();
	TIME();
	U_LESS_THAN();
}

void SET_TIMEOUT()  /* n \ a -- */
{  /* set a timeout time in seconds */
	SWAP();
	TIME();
	PLUS();
	SWAP();
	STORE();
}

/* ==== Event timing ==== */
struct
{
	Cell name1;
}start_time_={0,};

void start_time()  /* -- a */  
{
	*--sp=(Cell)&start_time_;
}


void START()  /* -- */
{
	TIME();
	start_time();
	STORE();
}

void END()  /* -- */
{
	TIME();
	start_time();
	FETCH();
	MINUS();
	DOT_D();
	*(char**)--sp="\010seconds ";
	COUNT();
	TYPE();
}
 