/* Exception signal handlers  Rob Chapman  Aug 13, 1993 */

#include <signal.h>	/* for catching exception signals */
#include "botforth.h"

void aborted(int sig)  /* -- */
{
	end_program("Abort, bye");
}

void math_error(int sig)  /* -- */
{
	end_program("Math error, bye");
}

void instruction_error(int sig)  /* -- */
{
	end_program("Instruction error, bye");
}

void interrupt(int sig)  /* -- */
{
	(void) signal(SIGINT, interrupt);
	setup_io();
	QUIT();
	end_program("Interrupt, bye");
}

void bus_error(int sig)  /* -- */
{
	end_program("Bus error, bye");
}

void terminate(int sig)  /* -- */
{
	end_program("Terminated, bye");
}

void init_signals()  /* -- */
{
	(void) signal(SIGABRT, aborted);
	(void) signal(SIGFPE, math_error);
	(void) signal(SIGILL, instruction_error);
	(void) signal(SIGINT, interrupt);
	(void) signal(SIGSEGV, bus_error);
	(void) signal(SIGTERM, terminate);
}
 