/* Nested environment shells  Rob Chapman  May 31, 1993 */

#include "botforth.h"
#include "shells.h"

/*                              Contexts
  The C language provides a mechanism for returning from an abitrarily 
  deep call to a preset historical moment.  int setjump(*ep) accepts an 
  environment from the enviroment pointer, ep.  The Forth environment is
  saved by saving the two stack pointers on a shell stack through shp.
  In C:
  
  	shell_nest();
	if( setjmp(*ep) == 0 )
	{
		/ code to execute /
	}
	shell_unest();
  
  In Forth:
  	
	SHELL{  ( code to execute )  }SHELL
*/

/* ==== Environment stacks ==== */ 
jmp_buf env[SHELLS], *ep = &env[SHELLS];	/* for saving C context */
Cell *shells[SHELLS*4], **shp = &shells[SHELLS*4];	/* shell = |rp0|sp0|ip|flag| */

void shell_nest()  /* -- */
{
	*--shp = rp0_;			/* record base of return stack */
	*--shp = sp0_;			/* record base of data stack */
	*--shp = (Cell *)ip;	/* record current instruction pointer */
	*--shp = (Cell *)-1;	/* record ok flag */
	rp0_ = rp;				/* set current as bottom */
	sp0_ = sp;				/* set current as bottom */
	--ep;					/* point to new environment */
	if((&shells[SHELLS*4] - shp)/4 == SHELLS)
		end_program("Ran out of environment shells!");
}

void shell_unest()  /* -- */
{
	ep++;					/* relinguish environment buffer */
	*--sp = (Cell)*shp++;	/* push ok flag to data stack */
	ip = (void (***)())*shp++;	/* redeem instruction pointer */
	sp0_  = *shp++;			/* redeem base of data stack */
	rp0_  = *shp++;			/* redeem base of return stack */
}

/* ==== Possible shell exits ==== */
void SHELL_END()	/* -- */	/* reset the return stack but allow data */
{
	rp = rp0_;	/* RP! */
	longjmp(*ep, -1);
}

void SHELL_OUT()	/* ? -- */	/* reset both stacks */
{
	sp = sp0_;	/* SP! */
	SHELL_END();
}

void SHELL_ABORT()	/* ? -- */	/* reset both stacks and set error flag */
{
	*shp = (Cell *)0;	/* set shell flag as fail */
	SHELL_OUT();
}

/* ==== Dictionary entries ==== */
void SHELL()  /* -- */	/* Shell execution for indirect threaded Forth code */
{
	shell_nest();
	if( setjmp(*ep) == 0 )	/* take a leap of faith */
	{ /* execute indirect threaded code */
		YES();				/* do the code first time through */
		while((tick = *ip++) != 0)	/* continue until an exit is encountered */
			(**tick)();		/* execute indirectly */
	}
	shell_unest();
	NO();	/* skip over the code second time through */
}

void SHELL_LEFT_CURLEY_BRACKET()  /* -- */	/* Shell execution for indirect threaded Forth code */
{
	*--sp=(Cell)&_SHELL.tick;
	COMPILE();
	IF();
}

void RIGHT_CURLEY_BRACKET_SHELL()  /* -- flag */	/* terminate shell */
{
	*--sp=(Cell)&_SHELL_END.tick;
	COMPILE();
	ENDIF();
}

void SH_STORE()  /* -- */	/* reset shell stacks */
{  /* reset shell stack */
	shp = &shells[SHELLS*4];
	ep  = &env[SHELLS];
}
 