/* Local platform specific io definitions  Rob Chapman  Feb 19, 1994 */

#include <stdio.h>		/* ANSI standard io */

#ifdef unix			/* Unix specific initialization for IO */
#include <sys/fcntl.h>
#endif

#ifdef THINK_C
#include <console.h>	/* Mac specific */
#endif

#if defined(__GNUC__) && defined(MSDOS)
#include "gppconio.h"
#endif

#if !defined(__GNUC__) && defined(MSDOS)
#include <conio.h>
#endif

#include "botforth.h"
#include "localio.h"

void SYS()  /* "commands" -- */
{
	_CR(), FLUSH_EMITS();
	INPUT();
#if defined(unix) || defined(MSDOS)
	restore_io(), system((char *)sp[0]), setup_io();
#endif
	DROP();
	ZERO_TIB();
}

int io_status;	/* saved at start of program, restored at end */
int io_setup=0;	/* state of io: 0 = as was; 1 = set for nonblockio */

void setup_io()	/* -- */  /* setup the io interface for non blocking */
{
	if(io_setup == 0)
	{
		io_setup = 1;
#ifdef unix
		io_status = fcntl(0, F_GETFL);
		system("stty raw -echo");
		fcntl(0, F_SETFL, O_NONBLOCK);
#endif
#ifdef THINK_C
		csetmode( C_RAW, stdin );   /* necessary for non-blocking io */
		console_options.pause_atexit = 0;	/* exit is immediate */
#endif
#if defined(__GNUC__) && defined(MSDOS)
 		gppconio_init();
#endif
	}
}

void restore_io()  /* -- */	/* restore io to entry conditions */
{
	if(io_setup == 1)
	{
		io_setup = 0;
#ifdef unix
		system("stty -raw echo");
		fcntl(0, F_SETFL, io_status);
#endif
	}
}

void key_query()  /* -- c|0 */  /* platform specific for nonblocking input */
{
#if defined(unix) || defined(THINK_C)
	if ( (*--sp = (Cell)getchar()) == EOF)
		sp[0] = 0;
#endif
#if defined(__GNUC__) && defined(MSDOS)
  *--sp = (kbhit()) ? (Cell)getkey() : (Cell)0;
#endif
#if !defined(__GNUC__) && defined(MSDOS)
  *--sp = (kbhit()) ? (Cell)getch() : (Cell)0;
#endif
}

void emit_query()  /* c -- c|0 */	/* output a single character */
{
#if defined(unix) || defined(THINK_C)
	if(sp[0] != putchar((char)sp[0]));
		sp[0] = 0;
#endif
#if defined(MSDOS) && defined(__GNUCC__)
    if (sp[0] == 8)
      {
        int x = wherex() - 1, y = wherey();
        gotoxy(x,y);putch(' ');gotoxy(x,y);
      }
    else
        putch((char)sp[0]);
	sp[0] = 0;
#endif

#if defined(MSDOS) && !defined(__GNUCC__)
	putch((char)sp[0]);
	sp[0] = 0;
#endif

}

void finish_emits()  /* -- */  /* sometimes we need to prevent overwriting */
{
#if defined(THINK_C) || (defined(MSDOS)&&!defined(__GNUCC__))
	fflush(stdout);
#endif
}
 