/* Code Libraries for botForth */

#include	"botforth.h"

#include "library.h"
#include "extkern.h"


/* ==== botForth addendums ==== */

void OCT()  /* -- */
{
	*--sp=8;
	base();
	*(Cell *)(*sp)=*(sp+1);
	sp+=2;      /* 2DROP */     /* ! */
}

void SHIFT()  /* n \ m -- n */
{
	sp--,*sp=*(sp+1);   /* DUP */
	*sp=(Integer)*sp<0?-1:0;	  /* 0< */
	if(*sp++)      /* IF */
	{
		if((Integer)*sp<0) *sp=-(*sp);   /* ABS */
		for(*--rp=*sp++;*rp;(*rp)--)	/* FOR */
		{
			*sp>>=1;    /* U2/ */
		}     /* NEXT */
		rp++;
	}
	else	  /* ELSE */
	{
		for(*--rp=*sp++;*rp;(*rp)--)	/* FOR */
		{
			*sp<<=1;    /* 2* */
		}      /* NEXT */
		rp++;
	}
}

void NON_QUERY()  /* f -- f' */
{
	*sp=*sp==0?-1:0;	 /* 0 = */
}

void ZERO_KEYS()  /* -- */
{
	for(;;)   /* BEGIN */
	{
		KEY_QUERY();
		if(!*sp++)break;     /* WHILE */
		KEY();
		sp++;	/* DROP */
	};   /* REPEAT */
}

void QUESTION_ASCII()  /* char -- char */
{
	BL();
	--sp,*sp=*(sp+2);     /* OVER */
	if(*(sp+1)>*sp) *++sp=-1; else *++sp=0;
	--sp,*sp=*(sp+2);    /* OVER */
	*--sp=126;
	if(*(sp+1)>*sp) *++sp=-1; else *++sp=0;
	*(sp+1)|=*sp,sp++;     /* OR */
	if(*sp++)      /* IF */
	{
		sp++;	/* DROP */
		*--sp=46;
	}
}

void ERASE_LINE()  /* -- */
{
	out();
	*sp=*(Cell *)(*sp);    /* @ */
	for(*--rp=*sp;*rp;(*rp)--)	/* FOR */
	{
		*--sp=8;
		EMIT();
	}       /* NEXT */
	for(*rp=*sp;*rp;(*rp)--)	/* FOR */
	{
		BL();
		EMIT();
	}       /* NEXT */
	for(*rp=*sp++;*rp;(*rp)--)	/* FOR */
	{
		*--sp=8;
		EMIT();
	}       /* NEXT */
	rp++;
}

void QUESTION_STOP()  /* -- */
{
	BARON();
	KEY_QUERY();
	if(!*sp++)      /* IF */
	{
		return;      /* EXIT */
	}
	ZERO_KEYS();
	QUESTION_CR();
	--sp,*(char**)sp="\053( --- SPACE to proceed  ESC to abort. --- )";
	COUNT();
	TYPE();
	for(;;)   /* BEGIN */
	{
		KEY();
		sp--,*sp=*(sp+1);	  /* DUP */
		*--sp=27;
		if(*(sp+1)==*sp) *++sp=-1; else *++sp=0;
		if(*sp++)       /* IF */
		{
			ERASE_LINE();
			ABORT();
		}
		BL();
		if(*(sp+1)==*sp) {sp+=2;break;}
		sp+=2;
	}    /* truth UNTIL */
	ERASE_LINE();
	ZERO_KEYS();
}

void BACK_TICK()  /* -- n */
{
	BL();
	WORD();
	HERE();
	*sp+=1;	  /* + */
	*sp=(Cell)(*(Byte *)(*sp));    /* C@ */
	tick = (thread)&_LITERAL.tick;    /* ' */
	TestTick;(**tick)();	  /* EXECUTE */
}

void ROTATEQ()  /* q \ n -- */
{
	for(*--rp=*sp++;*rp;(*rp)--)	/* FOR */
	{
		sp--,*sp=*(sp+1);   /* DUP */
		Q_FROM();
		--sp,*sp=*(sp+2);   /* OVER */
		TO_Q();
	}    /* NEXT */
	rp++;
	sp++;   /* DROP */
}

void TRANSFERQ()  /* srcq \ dstq \ n -- */
{
	for(*--rp=*sp++;*rp;(*rp)--)	/* FOR */
	{
		--sp,*sp=*(sp+2);   /* OVER */
		Q_FROM();
		--sp,*sp=*(sp+2);	  /* OVER */
		TO_Q();
	}    /* NEXT */
	rp++;
	sp+=2;	  /* 2DROP */
}

void PUSH()  /* n \ q -- */
{
	TO_Q();
}

void POP() { /* q -- n */  /* q<|ueued items|  q is transferred to the data stack */
	int 	*insert;
	Queue	*queue;
	
	queue = (Queue *)sp[0];
	if ( queue->insert == queue->end )
		queue->insert = (Cell *)&queue->end;
	sp[0] = *++queue->insert;
}

void STUFF() { /* n \ q -- */  /* |queued item|<s s is transferred from the data stack */
	int 	*remove;
	Queue	*queue;
	
	queue = (Queue *)*sp++;
	if ( queue->remove == queue->end )
		queue->remove = (Cell *)&queue->end;
	*++queue->remove = *sp++;
}

void PULL()  /* q -- n */
{
	Q_FROM();
}

/* ==== String support ==== */
struct
{
	Byte name8[20];
}number_;

void number()  /* -- a */  /* space for writing a number string */
{
	*--sp=(Cell)&number_;
}

void DOLLARS_STORE()  /* s \ a -- */
{
	--sp,sp[0]=*(Byte*)sp[2];	/* OVER C@ */
	sp[0]+=1;	/* + */
	CMOVE();
}

void PLUS_DOLLARS()  /* s \ a \ n -- */
{
	*--rp=*sp++;	/* >R */
	--sp,sp[0]=sp[2];	/* OVER */
	COUNT();
	sp[1]+=sp[0],sp++;	/* + */
	*--sp=*rp;	/* R */
	CMOVE();
	*--sp=*rp++;	/* R> */
	*--rp=sp[1],sp[1]=sp[0],sp[0]=*rp++;	/* SWAP */
	C_PLUS_STORE();
}

void NUMBER_TO_DOLLARS()  /* n -- s */
{
	START_NUMBER_CONVERSION();
	CONVERT_NUMBER();
	END_NUMBER_CONVERSION();
	--sp,sp[0]=sp[1];	/* DUP */
	number();
	C_STORE_PLUS();
	*--rp=sp[1],sp[1]=sp[0],sp[0]=*rp++;	/* SWAP */
	CMOVE();
	number();
}

void DOLLARS_WITHIN()  /* s1 \ a \ n -- a | 0 */
{  /* address of string s1 within or 0  Note: strings cannot contain nulls */
	TUCK(), HERE(), *sp += 256,  SWAP(), CMOVE();
	HERE(), *sp += 256,  PLUS(), *--sp = 0, SWAP(), C_STORE();
	C_FETCH_PLUS(), OVER(), HERE(), SWAP(), CMOVE();
	HERE(), PLUS(), *--sp = 0, SWAP(), C_STORE();
	HERE(),  DUP(), *sp += 256;
	sp[1] = (Cell)strstr((void *)sp[0], (void *)sp[1]), sp++;
}

/* ==== Fancy number output ==== */

void DOT_B()  /* n -- */
{
	*--sp=2;
	base();
	*(Cell *)(*sp)=*(sp+1);
	sp+=2;	 /* 2DROP */     /* ! */
	START_NUMBER_CONVERSION();
	for(*--rp=*sp++;*rp;(*rp)--)	/* FOR */
	{ 
			for(*--rp=*sp++;*rp;(*rp)--)	/* FOR */
		{ 
			CONVERT_DIGIT();
		}    /* NEXT */
		rp++;
		BL();
		HOLD();
	}	 /* NEXT */
	rp++;
	CONVERT_DIGIT();
	CONVERT_DIGIT();
	CONVERT_DIGIT();
	CONVERT_DIGIT();
	END_NUMBER_CONVERSION();
	TYPE();
	SPACE();
	HEX();
}

void DOT_D()  /* n -- */
{
	base();
	*sp=*(Cell *)(*sp);	  /* @ */
	*(sp+1)^=*sp;
	*sp^=*(sp+1);
	*(sp+1)^=*sp;       /* SWAP */
	DECIMAL();
	DOT();
	base();
	*(Cell *)(*sp)=*(sp+1);
	sp+=2;     /* 2DROP */     /* ! */
}

void DOT_H()  /* n -- */
{
	base();
	*sp=*(Cell *)(*sp);       /* @ */
	*(sp+1)^=*sp;
	*sp^=*(sp+1);
	*(sp+1)^=*sp;       /* SWAP */
	HEX();
	*--sp=sizeof(Cell);   /* CELL */
	*sp<<=1;     /* 2* */
	DOT_R();
	SPACE();
	base();
	*(Cell *)(*sp)=*(sp+1);
	sp+=2;       /* 2DROP */     /* ! */
}

/* ==== Link list tools ==== */

void PREVIOUS()  /* entry \ head -- prev */
{
	for(;;)       /* BEGIN */
	{
		--sp,*sp=*(sp+2);	 /* OVER */
		--sp,*sp=*(sp+2);    /* OVER */
		*sp=*(Cell *)(*sp);	  /* @ */
		*(sp+1)^=*sp,sp++;      /* XOR */
		if(!*sp++)break;      /* WHILE */
		*sp=*(Cell *)(*sp);	 /* @ */
	};      /* REPEAT */
	*(sp+1)=*sp,sp++;	  /* NIP */
}

void LINK()  /* a \ b -- */
{
	--sp,*sp=*(sp+2);    /* OVER */
	--sp,*sp=*(sp+2);    /* OVER */
	*sp=*(Cell *)(*sp);	  /* @ */
	*(sp+1)^=*sp;
	*sp^=*(sp+1);
	*(sp+1)^=*sp;       /* SWAP */
	*(Cell *)(*sp)=*(sp+1);
	sp+=2;       /* 2DROP */     /* ! */
	*(Cell *)(*sp)=*(sp+1);
	sp+=2;	  /* 2DROP */     /* ! */
}

void UNLINK()  /* b -- a */
{
	sp--,*sp=*(sp+1);      /* DUP */
	*sp=*(Cell *)(*sp);   /* @ */
	sp--,*sp=*(sp+1);       /* DUP */
	*(sp+1)=*(sp+2);
	*(sp+2)=*sp;	 /* TUCK */
	*sp=*(Cell *)(*sp);	  /* @ */
	*(sp+1)^=*sp;
	*sp^=*(sp+1);
	*(sp+1)^=*sp;       /* SWAP */
	*(Cell *)(*sp)=*(sp+1);
	sp+=2;       /* 2DROP */     /* ! */
}

void CHAIN()  /* head -- */
{
	HERE();
	--sp,*sp=*(sp+2);      /* OVER */
	*sp=*(Cell *)(*sp);	  /* @ */
	COMMA();
	*(sp+1)^=*sp;
	*sp^=*(sp+1);
	*(sp+1)^=*sp;      /* SWAP */
	*(Cell *)(*sp)=*(sp+1);
	sp+=2;       /* 2DROP */     /* ! */
}

/* Memory Manager */
void FREE()  /* a -- */
{
    free((void *)*sp++);      /* DROP */
}

void ALLOCATE()  /* n -- a */
{
	*sp = (Cell)malloc(*sp);
	if(*sp == 0 )
	{
		*sp = (Cell)"\031Memory allocation failed!";
		COUNT(), TYPE();
		ABORT();
	}
}

void DOT_RAM()   /* -- */	/* print out memory usage */
{
	limit();
	FETCH();
	HERE();
	MINUS();
	DOT_D();
}

/* Dictionaries  Rob Chapman  Apr 15, 91 */

/* ==== Dictionary information array ==== */
Cell dict_=0;

void dict()  /* -- a */  /* -> | >table | capacity# | #free | adjunct | */
{
	*--sp=(Cell)&dict_;
}

void USE_DICT()  /* dictionary -- */
{
	if(sp[0])
	{	
		dict();
		*(Cell *)(*sp)=*(sp+1);
		sp+=2;	/* 2DROP */     /* ! */
	}
	else
	{
		*--sp = (Cell)"\037ERROR:Dictionary address is 0! ", COUNT(), TYPE(), FLUSH_EMITS();
		SHELL_OUT();
	}
}

void string_table()  /* -- a */
{
	*--sp = *(Cell *)dict_;
}

void capacity_NUMBER()  /* -- n */
{
	*--sp = *((Cell *)dict_ + 1);
}

void NUMBER_free()  /* -- n */
{
	*--sp = *((Cell *)dict_ + 2);
}

void adjunct_table()  /* -- a */
{
	*--sp = *((Cell *)dict_ + 3);
}

void DICTIONARY()  /* -- dict */
{
	*--sp=4;
	CELLS();
	ALLOCATE();
	sp--,*sp=*(sp+1);	/* DUP */
	USE_DICT();
	INITIALIZE();
}

void QUESTION_FREE()  /* a -- */
{
	if(sp[0])
		FREE();
	else
		sp++;
}

void FREE_DICTIONARY()  /* dict -- */
{
	DUP(), FETCH(), QUESTION_FREE();
	DUP(), sp[0] += 3 * sizeof(Cell), FETCH(), QUESTION_FREE();
	FREE();
}

/* ==== Dictionary growth ==== */
/* prime useable sizes: 251,509,1021,2053,4093,8191 */

void NUMBER_hash()  /* -- n */  /* hardwired table size */
{
	*--sp=2053;
}

void EMPTY()  /* dict -- */
{
	USE_DICT();
	string_table();
	QUESTION_FREE();
	adjunct_table();
	QUESTION_FREE();
	INITIALIZE();
}

void INITIALIZE()  /* -- */
{
	*--sp=0;
	NUMBER_hash();
	*sp-=20;   /* - */
	NUMBER_hash();
	sp--,*sp=*(sp+1);	/* DUP */
	CELLS();
	ALLOCATE();
	--sp,*sp=*(sp+2);	/* OVER */
	--sp,*sp=*(sp+2);    /* OVER */
	*(sp+1)^=*sp;
	*sp^=*(sp+1);
	*(sp+1)^=*sp;    /* SWAP */
	CELLS();
	ERASE();
	dict();
	*sp=*(Cell *)(*sp);	/* @ */
	STORE_PLUS();
	STORE_PLUS();
	STORE_PLUS();
	*(Cell *)(*sp)=*(sp+1);
	sp+=2;       /* 2DROP */     /* ! */
}

void PLUS_ENTRY()  /* -- */
{
	NUMBER_free();
	if(!*sp++)       /* IF */
	{
		*--sp = (Cell)"\020Dictionary Full.", COUNT(), TYPE();
		dict();
		*sp=*(Cell *)(*sp);     /* @ */
		EMPTY();
	}
	*--sp=-1;
	dict();
	*sp=*(Cell *)(*sp);     /* @ */
	*--sp=2;
	CELLS();
	*(sp+1)+=*sp,sp++;	 /* + */
	*(Cell *)(*sp)+=*(sp+1);
	sp+=2;	 /* 2DROP */     /* +! */
}

void MINUS_ENTRY()  /* -- */
{
	*--sp=1;
	dict();
	*sp=*(Cell *)(*sp);    /* @ */
	*--sp=2;
	CELLS();
	*(sp+1)+=*sp,sp++;	 /* + */
	*(Cell *)(*sp)+=*(sp+1);
	sp+=2;	 /* 2DROP */     /* +! */
}

void QUESTION_ADJUNCT()  /* -- */
{
	adjunct_table();
	if(*sp++)      /* IF */
	{
		return;      /* EXIT */
	}
	capacity_NUMBER();
	CELLS();
	ALLOCATE();
	sp--,*sp=*(sp+1);	  /* DUP */
	capacity_NUMBER();
	CELLS();
	ERASE();
	dict();
	*sp=*(Cell *)(*sp);      /* @ */
	*--sp=3;
	CELLS();
	*(sp+1)+=*sp,sp++;	 /* + */
	*(Cell *)(*sp)=*(sp+1);
	sp+=2;	  /* 2DROP */     /* ! */
}

/* ==== Table checks ==== */
struct
{
	Cell nameA;
}ZERO_string_={0};

void ZERO_string()  /* -- a */  /* zero-length-null-string for replacing deleted entries */
{
	*--sp=(Cell)&ZERO_string_;
}


void USED_QUERY()  /* loc -- f */
{
	*sp=*(Cell *)(*sp);	  /* @ */
	if(*sp)
	{       /* DUP IF */
		ZERO_string();
		*(sp+1)^=*sp,sp++;	  /* XOR */
	}
}

void DIFFERENT_QUERY()  /* string \ loc -- f */
{
	*sp=*(Cell *)(*sp);    /* @ */
	if(*sp)
	{       /* DUP IF */
		NAME_QUERY();
		*sp=*sp==0?-1:0;	/* 0= */
	}
	else	 /* ELSE */
	{
		*(sp+1)=*sp,sp++;	  /* NIP */
	}
}

/* ==== Hashing algorithms ==== */
void BLEND()  /*  n \ string -- n' \ string' */
{
	sp[1] ^= *(Byte *)sp[0]++;
	sp[1] = ((sp[1] << 3) & 0xFFFF) | (sp[1] >> 13);
}

void HASH()  /* string -- loc */
{
	--sp, sp[0] = sp[1], sp[1] = 8315;	/* literal SWAP */
	COUNT();
	for(*--rp=(*sp++)&31;*rp;(*rp)--)	/* FOR */
	{
		BLEND();
	}	  /* NEXT */
	rp++;
	sp++;       /* DROP */
	capacity_NUMBER();
	sp[1]%=sp[0],sp++;		/* MOD */
	sp[0] *= sizeof(Cell);	/* CELLS */
	string_table();
	sp[1]+=sp[0],sp++;		/* + */
}

/* ==== Rehash algorithm based on first character of string ==== */
void ASCKEY()  /* string \ loc -- string \ loc' */
{
	sp[0] += (1 + *(Byte *)(sp[1] + 1)) * sizeof(Cell);
}

void REHASH()  /* string \ loc -- string \ loc' */
{
	string_table();
	sp[1] = (sp[1] - sp[0])/sizeof(Cell), sp++;
	sp[0] += 1 + *(Byte *)(sp[1] + 1);
	capacity_NUMBER();
	sp[1] %= sp[0],sp++;		/* MOD */
	sp[0] *= sizeof( Cell );	/* CELLS */
	string_table();
	sp[1]+=sp[0],sp++;		/* + */
}

/* ==== Messages for implicit string table ==== */
Cell junk_=0;

void junk()  /* -- a */  /* junk entry for when there is no dictionary */
{
	*--sp=(Cell)&junk_;
}

void BUMP()  /* string \ loc -- string' \ loc */
{
	*--rp=*sp;	  /* DUP >R */
	sp--,*sp=*(sp+1);	  /* DUP */
	*sp=*(Cell *)(*sp);   /* @ */
	*--rp=*sp++;	  /* >R */
	*(Cell *)(*sp)=*(sp+1);
	sp+=2;	 /* 2DROP */     /* ! */
	*--sp=*rp++;	  /* R> */
	*--sp=*rp++;	  /* R> */
}

void LOCATE()  /* string \ dict -- loc */
{
	USE_DICT();
	capacity_NUMBER();
	if(!*sp++)      /* IF */
	{
		sp++;	/* DROP */
		junk();
		return;      /* EXIT */
	}
	sp--,*sp=*(sp+1);	  /* DUP */
	HASH();
	for(;;)       /* BEGIN */
	{
		--sp,*sp=*(sp+2);	 /* OVER */
		--sp,*sp=*(sp+2);    /* OVER */
		DIFFERENT_QUERY();
		if(!*sp++)break;	  /* WHILE */
		REHASH();
	};	/* REPEAT */
	sp[1]=sp[0],sp++;	  /* NIP */
}

/* ==== Dictionary interface ==== */

void INSERT()  /* string \ dict -- */
{
	USE_DICT();
	PLUS_ENTRY();
	sp--,*sp=*(sp+1);	 /* DUP */
	HASH();
	for(;;)       /* BEGIN */
	{
		sp--,*sp=*(sp+1);	 /* DUP */
		USED_QUERY();
		if(!*sp++)break;	/* WHILE */
		--sp,*sp=*(sp+2);   /* OVER */
		--sp,*sp=*(sp+2);    /* OVER */
		*sp=*(Cell *)(*sp);	  /* @ */
		NAME_QUERY();
		if(*sp++)    /* IF */
		{
			BUMP();
		}
		REHASH();
	};       /* REPEAT */
	*(Cell *)(*sp)=*(sp+1);
	sp+=2;     /* 2DROP */     /* ! */
}

void APPEND()  /* string \ dict -- */
{
	USE_DICT();
	PLUS_ENTRY();
	sp--,*sp=*(sp+1);	 /* DUP */
	HASH();
	for(;;)       /* BEGIN */
	{
		sp--,*sp=*(sp+1);	 /* DUP */
		USED_QUERY();
		if(!*sp++)break;	/* WHILE */
		REHASH();
	};	/* REPEAT */
	*(Cell *)(*sp)=*(sp+1);
	sp+=2;     /* 2DROP */     /* ! */
}

void DELETE()  /* string \ dict -- */
{
	LOCATE();
	sp--,*sp=*(sp+1);	  /* DUP */
	*sp=*(Cell *)(*sp);   /* @ */
	if(*sp++)       /* IF */
	{
		sp--,*sp=*(sp+1);    /* DUP */
		*sp=*(Cell *)(*sp);   /* @ */
		ZERO_string();
		*(sp+1)^=*sp,sp++;       /* XOR */
		if(*sp++)     /* IF */
		{
			ZERO_string();
			--sp,*sp=*(sp+2);     /* OVER */
			*(Cell *)(*sp)=*(sp+1);
			sp+=2;       /* 2DROP */     /* ! */
			MINUS_ENTRY();
		}
	}
	sp++;	/* DROP */
}

void FIND()  /* string \ dict -- entry | 0 */
{
		LOCATE();
		*sp=*(Cell *)(*sp);     /* @ */
}

void ADJUNCT()  /* string \ dict -- entry | 0 */
{
	LOCATE();
	string_table();
	*(sp+1)-=*sp,sp++;      /* - */
	QUESTION_ADJUNCT();
	adjunct_table();
	*(sp+1)+=*sp,sp++;	 /* + */
}
/* insert a string into the dictionary */
/* append a string to the dictionary */
/* delete a string from the dictionary */
/* return an associate cell for string */
/* find a string in the dict. */
/* empty the dictionary */
/* used to instantiate a dictionary */

/* Tools */

/* ==== Additional Baron words ==== */

void QUESTION_BARON_FULL()  /* -- */
{
	peasantq();
	FETCH_PLUS();
	*sp=*(Cell *)(*sp);   /* @ */
	*(sp+1)-=*sp,sp++;      /* - */
	if(*sp++)       /* IF */
	{
		return;      /* EXIT */
	}  /* REBOOT  ; */
	ZERO_BARON();
	INIT();
	--sp,*(char**)sp="\047Too many peasants. Interrupts disabled.";
	COUNT();
	TYPE();
	QUIT();
}

/* ==== Case construct ==== */

void _CASE()  /* -- 0 */
{
	*--sp=0;
}

void LEFT_CURLEY_BRACKET()  /* 0. -- 0.. */
{
	*--sp=(Cell)&_OVER.tick;   /* ' */
	COMPILE();
	*--sp=(Cell)&_EQUALS.tick;   /* ' */
	COMPILE();
	tick = (thread)&_IF.tick;       /* ' */
	TestTick;(**tick)();	  /* EXECUTE */
	*--sp=(Cell)&_DROP.tick;	  /* ' */
	COMPILE();
}

void RIGHT_CURLEY_BRACKET()  /* 0.. -- 0.. */
{
	tick = (thread)&_ELSE.tick;	  /* ' */
	TestTick;(**tick)();	  /* EXECUTE */
}

void ENDCASE()  /* 0... -- */
{
	*--sp=(Cell)&_DROP.tick;       /* ' */
	COMPILE();
	for(;;)      /* BEGIN */
	{
		QUESTION_DUP();
		if(!*sp++)break;	  /* WHILE */
		tick = (thread)&_ENDIF.tick;   /* ' */
		TestTick;(**tick)();	  /* EXECUTE */
	};	/* REPEAT */
}

/* ==== String interpreter ==== */

void INTERPRET_WORD()  /* s -- */
{
	latest();
	SEARCH_DICTIONARY();
	if(*sp++)	/* IF */
	{
		L_TO_NAME();
		sp--,*sp=*(sp+1);       /* DUP */
		N_TO_TICK();
		*(sp+1)^=*sp;
		*sp^=*(sp+1);
		*(sp+1)^=*sp;	/* SWAP */
		*sp=(Cell)(*(Byte *)(*sp));	 /* C@ */
		*sp&=224;      /* AND */
		QUESTION_EXECUTE();
	}
	else    /* ELSE */
	{
		NUMBER();
		tick = (thread)&_LITERAL.tick;      /* ' */
		TestTick;(**tick)();	  /* EXECUTE */
	}
}

/* ==== Dump Utility ==== */

void DOT_LINE()  /* a -- a+ */
{
	QUESTION_CR();
	QUESTION_STOP();
	sp--,*sp=*(sp+1);      /* DUP */
	*--sp=8;
	DOT_R();
	--sp,*(char**)sp="\003:  ";
	COUNT();
	TYPE();
	sp--,*sp=*(sp+1);   /* DUP */
	for(*--rp=16;*rp;(*rp)--)	/* FOR */
	{ 
		C_FETCH_PLUS();
		*(sp+1)^=*sp;
		*sp^=*(sp+1);
		*(sp+1)^=*sp;     /* SWAP */
		START_NUMBER_CONVERSION();
		BL();
		HOLD();
		CONVERT_DIGIT();
		CONVERT_DIGIT();
		END_NUMBER_CONVERSION();
		TYPE();
	}	/* NEXT */
	rp++;
	sp++;   /* DROP */
	for(*--rp=16;*rp;(*rp)--)	/* FOR */
	{    
		C_FETCH_PLUS();
		*(sp+1)^=*sp;
		*sp^=*(sp+1);
		*(sp+1)^=*sp;     /* SWAP */
		sp--,*sp=*(sp+1);    /* DUP */
		BL();
		if((Integer)*(sp+1)<(Integer)*sp) *++sp=-1; else *++sp=0;
		--sp,*sp=*(sp+2);     /* OVER */
		*--sp=125;
		if((Integer)*(sp+1)>(Integer)*sp) *++sp=-1; else *++sp=0;
		*(sp+1)|=*sp,sp++;   /* OR */
		if(*sp++)      /* IF */
		{
			sp++;	/* DROP */
			*--sp=46;
		}
		EMIT();
	}     /* NEXT */
	rp++;
}

void DOT_FIELDS()  /* a -- */
{
	QUESTION_CR();
	QUESTION_STOP();
	*--sp=10;
	SPACES();
	for(*--rp=16;*rp;(*rp)--)	/* FOR */
	{      
		sp--,*sp=*(sp+1);     /* DUP */
		*sp&=255;     /* AND */
		*--sp=3;
		DOT_R();
		*sp+=1;	  /* + */
	}       /* NEXT */
	rp++;
	sp++;   /* DROP */
}

void DUMP()  /* a \ n -- */
{
	base();
	*sp=*(Cell *)(*sp);	 /* @ */
	*--rp=*sp++;	  /* >R */
	HEX();
	--sp,*sp=*(sp+2);       /* OVER */
	DOT_FIELDS();
	for(*--rp=*sp++;*rp;(*rp)--)	/* FOR */
	{
		DOT_LINE();
	}      /* NEXT */
	rp++;
	sp++;   /* DROP */
	*--sp=*rp++;	  /* R> */
	base();
	*(Cell *)(*sp)=*(sp+1);
	sp+=2;	 /* 2DROP */     /* ! */
}

void DOT_S()  /* -- */
{
	DEPTH();
	--sp,*sp=*(sp+1);   /* DUP */
	DOT();
	--sp,*(char**)sp="\025items on data stack: ";
	COUNT();
	TYPE();
	*--sp=10;
	if((Integer)*sp<(Integer)*(sp+1)) *(sp+1)=*sp; sp++;       /* MIN */
	*--sp=0;
	if((Integer)*sp>(Integer)*(sp+1)) *(sp+1)=*sp; sp++;      /* MAX */
	*--rp=*sp++;	  /* >R */
	HERE();
	*--sp=*rp;      /* R */
	for(*--rp=*sp++;*rp;(*rp)--)	/* FOR */
	{
		STORE_PLUS();
	}     /* NEXT */
	rp++;
	*sp-=sizeof(Cell);      /* CELL - */
	*--sp=*rp++;	  /* R> */
	for(*--rp=*sp++;*rp;(*rp)--)	/* FOR */
	{
		FETCH_MINUS();
		--sp,*sp=*(sp+2);    /* OVER */
		DOT();
	}     /* NEXT */
	rp++;
	sp++;   /* DROP */
}

/* ==== Peasant viewing ==== */

void UMAX()  /* a \ b -- c */
{
	--sp,*sp=*(sp+2);	/* OVER */
	--sp,*sp=*(sp+2);    /* OVER */
	if(*(sp+1)<*sp) *++sp=-1; else *++sp=0;
	if(*sp++)    /* IF */
	{
		*(sp+1)^=*sp;
		*sp^=*(sp+1);
		*(sp+1)^=*sp;    /* SWAP */
	}
	sp++;      /* DROP */
}

void IN_WHAT()  /* addr -- link | 0 */
{
#ifdef itaint
	sp--,*sp=*(sp+1);	/* DUP */
	HERE();
	if((Integer)*(sp+1)>(Integer)*sp) *++sp=-1; else *++sp=0;
	if(*sp++)   /* IF */
	{
		sp++;	/* DROP */
		*--sp=0;
		return;	  /* EXIT */
	}
#endif
	sp--,*sp=*(sp+1);	  /* DUP */
	T_TO_NAME();
	N_TO_TICK();
	--sp,*sp=*(sp+2);   /* OVER */
	if(*(sp+1)==*sp) *++sp=-1; else *++sp=0;
	if(*sp++)   /* IF */
	{
		T_TO_LINK();
		return;	 /* EXIT */
	}
	*--sp=0;
	*--rp=*sp++;	  /* >R */
	latest();
	for(;;)      /* BEGIN */
	{
		L_TO_LINK();
		QUESTION_DUP();
		if(!*sp++)break;     /* WHILE */
		--sp,*sp=*(sp+2);   /* OVER */
		--sp,*sp=*(sp+2);    /* OVER */
		if(*(sp+1)>*sp) *++sp=-1; else *++sp=0;
		if(*sp++)    /* IF */
		{
			sp--,*sp=*(sp+1);    /* DUP */
			*--sp=*rp++;	  /* R> */
			UMAX();
			*--rp=*sp++;	  /* >R */
		}
	};   /* REPEAT */
	sp++;      /* DROP */
	*--sp=*rp++;	  /* R> */
}

void DOT_NAME()  /* lf -- */
{
	L_TO_NAME();
	C_FETCH_PLUS();
	*(sp+1)^=*sp;
	*sp^=*(sp+1);
	*(sp+1)^=*sp;       /* SWAP */
	*sp&=31;     /* AND */
	sp--,*sp=*(sp+1);     /* DUP */
	*sp+=2;       /* + */
	out();
	*sp=*(Cell *)(*sp);      /* @ */
	*(sp+1)+=*sp,sp++;      /* + */
	*--sp=78;
	if((Integer)*(sp+1)>(Integer)*sp) *++sp=-1; else *++sp=0;
	if(*sp++)	/* IF */
	{
			_CR();
		QUESTION_STOP();
	}
	TYPE();
	*--sp=2;
	SPACES();
}

void DOT_WORD()  /* a -- */
{
	IN_WHAT();
	QUESTION_DUP();
	if(*sp++)	/* IF */
	{
		DOT_NAME();
	}
	else   /* ELSE */
	{
		--sp,*(char**)sp="\004??? ";
		COUNT();
		TYPE();
	}
}

void SHOW_PEASANTS()  /* -- */
{
	*--sp=-1;
	TO_BARON();
	for(;;)       /* BEGIN */
	{
		BARON_FROM();
		sp--,*sp=*(sp+1);   /* DUP */
		*sp^=-1;      /* XOR */
		if(!*sp++)break;      /* WHILE */
		_CR();
		sp--,*sp=*(sp+1);    /* DUP */
		DOT_WORD();
		TO_BARON();
	};    /* REPEAT */
	sp++;      /* DROP */
	DOT_PROMPT();
}

void PEASANTS()  /* -- */
{
	*--sp=(Cell)&_SHOW_PEASANTS.tick;       /* ' */
	TO_BARON();
}

void WORDS()  /* -- */
{
	QUESTION_CR();
	QUESTION_STOP();
	latest();
	for(;;)	/* BEGIN */
	{
		L_TO_LINK();
		QUESTION_DUP();
		if(!*sp++)break;     /* WHILE */
		sp--,*sp=*(sp+1);   /* DUP */
		DOT_NAME();
		FLUSH_EMITS();
	};       /* REPEAT */
}

void WATCH_STACK(){  /* -- */
	for(;;){	/* BEGIN */    
		*--sp=(Cell)(sp+1);
		sp_0();
		FETCH();
		SWAP();
		MINUS();
		*sp/=sizeof(Cell);      /* CELL/ */     /* DEPTH */
		BARON_FROM();
		TUCK();
		*--rp = *sp++;
		*--rp = *sp++;
		EXECUTE();
		*--sp=(Cell)(sp+1);
		sp_0();
		FETCH();
		SWAP();
		MINUS();
		*sp/=sizeof(Cell);      /* CELL/ */     /* DEPTH */
		*--sp = *rp++;
		XOR();
		if(*sp++){      /* IF */		
				*--sp = *rp++;
			T_TO_LINK();
			DOT_NAME();
			--sp,*(char**)sp="\024changed the stack...";
			COUNT();
			TYPE();
			DOT_S();
		}
		else{   /* ELSE */		
				*--sp = *rp++;
			DROP();
		}
	};      /* REPEAT */
}

void bye()  /* -- */
{
	end_program("");
}
 