/* From kernel queues to standard io  Rob Chapman  May 8, 1993 */

#include "botforth.h"
#include "io.h"

extern void end_program();

void poll_key()		/* transfer a key from stdin to the kernel input queue */
{
	key_query();
	if (sp[0] != 0)
	{
		keyq();
		TO_Q();
	}
	else
		sp++;
}

void poll_emit()	/* transfer a character from kernel to stdout */
{
	emitq();
	Q_QUERY();
	if(sp[0])
	{
		for(*--rp=*sp++;*rp;(*rp)--)	/* FOR */
		{
			emitq();
			Q_FROM();
			if(*sp==27)	/* escape from program? */
			{
				sp++;
				end_program("bye");
			}
			while(sp[0] != 0)
				emit_query();
			sp++;
		}    /* NEXT */
		rp++;
		finish_emits();
	}
	else
		sp++;
}

void STDIN()  /* -- */	/* peasant for polling kernel input and output queues */
{
	poll_key();
	*--sp=(Cell)&_STDIN.tick;
	TO_BARON();
}

void STDOUT()  /* -- */	/* peasant for polling kernel input and output queues */
{
	poll_emit();
	*--sp=(Cell)&_STDOUT.tick;
	TO_BARON();
}

void INIT_IO()  /* -- */	/* initialize input/output */
{
	setup_io();
	*--sp=(Cell)&_STDIN.tick;
	RUN();
	*--sp=(Cell)&_STDOUT.tick;
	RUN();
}

 